*****************************************************************************
**                                                                         **
** Engine: Spacescope+                                                     **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 


	;*********************************************
	;**       Eagleplayer SpaceScope+ V1.0      **
	;**            1993 Henryk Richter         **
	;*********************************************
	;
	; strzt nach 4 Minuten ab, wenn der Eagleplayer modifiziert ist !!
	;
	incdir	include:
	include	exec/exec_lib.i
	include	exec/libraries.i
	include	exec/interrupts.i
	include	intuition/intuition.i
	include	intuition/intuition_LIB.i
	include	libraries/gadtools.i
	include	libraries/gadtools_lib.i
	include	dos/dos_lib.i
	include	libraries/dos.i
	include	graphics/graphics_lib.i
	include	misc/EagleplayerEngine.i
	include	exec/execbase.i
	include	misc/BuggsMacros.i

	;
ver		macro
		dc.b	"1.53"
		endm
StructVer	macro
		dc.w	1,53
		endm
date		macro
		dc.b	"05-Apr-97"
		endm
StructDate	macro
		dc.b	05,04
		dc.w	1997
		endm
	;
Test = 0	;auf 0 Setzen zur Nutzung mit dem Eagleplayer
		;zu Testzwecken meldet sich der Analyzer sonst selbst ab !
debug = 0
;===========================================================================
	section	0,code
;===========================================================================
an_num = 24			;Anzahl der Balken (nicht ndern)
an_zeilen = 128			;Anzahl der Zeilen (nicht ndern)
win_breite = (an_num+8)*8
;===========================================================================
BEGIN
	bra.w	fangan
	EUSN_Identifier
	dc.l	0		;eus_next
	ifne	debug
	dc.w	-2
	else
	dc.w	0		;eus_Usernr
	endc
	dc.l	0		;eus_EPBase
	dc.l	0		;eus_Freetable
	dc.l	0		;eus_Taskadr
	dc.l	0		;eus_unused1
	dc.l	0		;eus_unused2
	dc.l	0		;eus_unused3
	dc.l	Tagliste	;eus_unused4
	dc.w	0		;eus_ticks
	dc.w	0		;eus_tickcounter
	dc.l	EUIB_OnlyPlay!EUIB_OnlyActive ;eus_tickflags
	dc.l	USMB_Zipwin!USMB_ChangeConfig!USMB_ChangeInterrupt;eus_msgflags
	dc.l	MyAnalyzername	;eus_PName
	dc.l	mybuggsname
	dc.l	myinfo
	dc.w	37		;eus_Kickstart
	dc.l	Eagleversion	;eus_EPVersion
	structver		;eus_version
	dc.l	MyUsername	;eus_username

	dc.w	268		;eus_winx
	dc.w	167		;eus_winy
	dc.w	EUSB_openwin

	dc.w	0		;special informations
	dc.w	0		;special informations
	dc.l	0		;EUS_Special2
	dc.l	0		;EUS_Special3
	structdate		;EUS_Creatordate
	dc.b	-5		;EUS_Priority
	dc.b	EUTY_Scope
	dc.w	0
	dc.l	0		;EUS_Reserved3
	dc.l	0		;EUS_Reserved4
	dc.l	0		;EUS_Reserved5
	dc.l	0		;EUS_Reserved6

		ifne	(*-begin)-EUS_SizeOF
		Aber Hallo
		endc

	dc.b	`$VER: Space-Scope+ `
	ver
	dc.b	` (`
	date
	dc.b	`)`,0
	even

Tagliste:	dc.l	EUT_SpecialinfoLNr,LNrE_SpecialInfo_Spacescope
		dc.l	0

fangan
	move.l	4,a6

	lea	datas,a5
	move.l	a5,a0
	move.w	#dataslen-1,d0
.clr	move.b	#0,(a0)+
	dbf	d0,.clr

	move.w	attnflags(A6),d0
	and.w	#AFF_68020,d0
	sne	MC68020on(A5)

	move.w	#30,modeid(a5)
	
	moveq	#-1,d0
	jsr	_LVOallocsignal(a6)	;Signal allokieren
	tst.l	d0
	blt	NoSignal
	move.l	d0,mysignal(a5)

	suba.l	A1,A1
	JSR	_LVOfindtask(A6)
	move.l	d0,mytask(a5)

	lea	dos(pc),a1
	moveq	#33,d0
	jsr	_LVOopenlibrary(a6)
	tst.l	d0
	beq	NODOS
	move.l	d0,_dos(a5)

	lea	MsgPort1(a5),a4		;MSG Port Struktur initialisieren
	bsr	MakeMsgPort
	tst.l	d0
	blt	NoPort
	move.l	a4,MsgPort(A5)

	lea	int(pc),a1
	moveq	#33,d0
	jsr	_LVOopenlibrary(a6)
	tst.l	d0
	beq	NOINT
	move.l	d0,intsave(a5)

	lea	graf(pc),a1
	moveq	#33,d0
	jsr	_LVOopenlibrary(a6)
	tst.l	d0
	beq	NOGRAF
	move.l	d0,grafsave(a5)

	lea	gad(pc),a1
	moveq	#37,d0
	jsr	_LVOopenlibrary(a6)
	move.l	d0,gadsave(a5)
	beq	NoGadTo

	moveq	#0,d7

	bsr	sendfirstmessage	;Message an Eagleplayer senden,da
					;der Analyzer gern mal die Struktur-
					;Adresse haben mchte
	blt	endme	;Fehler aufgetreten

	bsr	HandleActions		;Auf Usereingaben reagieren
endme
	move.l	d7,-(sp)
	bsr	closewin
	move.l	(sp)+,d7		;Error oder Exit-Message vom Player
	blt.s	Error
	bsr	Sendlastmessage
Error
	move.l	mypubscreen(a5),d0
	beq.s	.ok
	move.l	d0,a1
	suba.l	a0,a0
	jsr	_LVOunlockpubscreen(a6)
.ok
	move.l	gadsave(a5),a1
	move.l	4,a6
	jsr	_LVOcloselibrary(A6)
nogadto
	move.l	grafsave(a5),a1
	move.l	4,a6
	jsr	_LVOcloselibrary(a6)
NoGraf
	move.l	intsave(a5),a1
	move.l	4,a6
	jsr	_LVOcloselibrary(a6)
noint
	move.l	4,a6
	lea	msgport1(a5),a2
	move.b	mp_sigbit(a2),d0
	ext.w	d0
	ext.l	d0
	jsr	_LVOfreesignal(a6)
NoPort
	move.l	4,a6
	move.l	_dos(a5),a1
	jsr	_LVOcloselibrary(a6)
nodos
	move.l	mysignal(a5),d0
	move.l	4,a6
	jsr	_LVOfreesignal(a6)
NoSignal
	moveq	#0,d0
	rts

MakeMsgPort
					;Message Port initialisieren
	move.l	4.w,a6
	moveq	#-1,d0
	jsr	_LVOallocsignal(a6)	;MSG Signal zuweisen lassen
	tst.l	d0
	blt	.nosignal2		;Fehler

	move.b	#nt_msgport,ln_type(a4)
	move.b	#0,ln_pri(a4)
	move.b	#pa_signal,mp_flags(a4)
	move.b	d0,mp_sigbit(a4)

	move.l	mytask(a5),mp_sigtask(a4);mp_SigTask

	lea	mp_msglist(a4),a1
	Newlist	a1			;macro in Lists.i

	moveq	#0,d0
.nosignal2				;Fehler
	rts
************************************************************************
*                   Fenster ffnen                                     *
************************************************************************
Openwin:
	tst.l	winhandle(a5)
	bne.w	.Error2

	move.l	intsave(a5),a6

	lea	begin(pc),a0
	move.l	eus_epbase(a0),d0
	beq.s	.noep
	move.l	d0,a0
	move.w	EPG_Wordreserved8(A0),word8(A5)
	move.l	EPG_Pubscreen(a0),d0
.noep
	move.l	d0,a0

	jsr	_LVOlockpubscreen(A6)	;aktuellen Publicscreen rauskriegen
	tst.l	d0
	bne.s	.pbs

	suba.l	a0,a0
	jsr	_LVOlockpubscreen(A6)	;aktuellen Publicscreen rauskriegen
	tst.l	d0
	beq	.Error2		;sollte nicht auftreten
.pbs
	move.l	d0,mypubscreen(a5);fr UnLockpubscreen()
	move.l	d0,a1
	move.b  sc_WBorLeft(a1),d0
	ext.w   d0
	move.w	d0,offx(a5)

	move.l	sc_font(a1),a0
	move.l	a0,fontatt(a5)

	move.w	ta_ysize(a0),d0		;Hhe des Screenfonts
	move.w	d0,d1
	move.w	d0,fonth(a5)
	move.b  sc_WBorTop(a1),d0
	ext.w   d0
	add.w	d0,d1
	move.w	d1,myhoehe1(a5)		;und eintragen

	add.w	#AN_zeilen+15,d1	;64 Zeilen + Rand
					;+ Rand
					;in D1 Windowhhe

	move.w	#win_breite,winwidth(a5)
	movem.l	d0-d6/a0-a6,-(sp)
	bsr	makemenus		;Mens basteln
	movem.l	(sp)+,d0-d6/a0-a6
	tst.l	d7
	blt.w	.Error

	move.l	intsave(a5),a6
	lea	mytags(a5),a1		;WINDOW INIT

	move.l	#WA_Pubscreen,(a1)+
	move.l	mypubscreen(A5),(a1)+

	move.l	#WA_Newlookmenus,(a1)+
	move.l	#1,(a1)+

	move.l	#wa_Pubscreenfallback,(A1)+
	move.l	#1,(a1)+

	lea	begin(pc),a0
	moveq	#0,d0
	move.l	#wa_top,(a1)+
	move.w	eus_winy(a0),d0
	and.w	#$fff,d0
	move.l	d0,(a1)+
	move.l	#wa_left,(a1)+
	move.w	eus_winx(a0),d0
	and.w	#$fff,d0
	move.l	d0,(a1)+

	moveq	#0,d0
	move.l	#wa_width,(a1)+		;Breite
	move.w	eus_special(a0),d0
	bne.s	.noset3
	move.w	#win_breite,d0
.noset3
	move.l	d0,(a1)+

	move.l	#wa_height,(a1)+	;Hhe

	move.w	eus_special+2(a0),d0
	bne.s	.noset4
	move.l	d1,d0
.noset4
	move.l	d0,(a1)+

	move.l	#wa_minheight,(a1)+
	move.w	myhoehe1(a5),d1
	add.w	#40,d1
	move.l	d1,(a1)+
	move.l	#wa_minwidth,(a1)+
	move.l	#80,(A1)+

	move.l	#wa_maxheight,(a1)+
	move.l	#768,(A1)+
	move.l	#wa_maxwidth,(a1)+
	move.l	#1024,(A1)+

	move.l	#wa_flags,(a1)+
	move.l	#Windowdrag!Windowdepth!Windowclose!windowsizing,(a1)+
	move.l	#WA_TITLE,(a1)+
	lea	mywinname(pc),a0
	move.l	a0,(a1)+
	move.l	#wa_idcmp,(a1)+
 move.l	#IDCMP_NEWSIZE!closewindow!mousebuttons!menupick!refreshwindow,(a1)+
	move.l	#wa_autoadjust,(a1)+
	move.l	#1,(a1)+

	move.l	#WA_ScreenTitle,(a1)+
	move.l	#Project0STitle,(a1)+


	move.l	#TAG_DONE,(a1)+

	suba.l	a0,a0
	lea	mytags(a5),a1
	jsr	_LVOopenwindowtaglist(a6)
	move.l	d0,Winhandle(a5)
	tst.l	d0
	bne.s	.winopened

	lea	mytags(a5),a1		;Fehler,nochmal auf Position 0/0
	move.l	#wa_top,(a1)+		;zu ffnen versuchen
	move.l	#0,(a1)+
	move.l	#wa_left,(a1)+
	move.l	#0,(a1)+

	suba.l	a0,a0
	lea	mytags(a5),a1
	move.l	intsave(a5),a6
	jsr	_LVOopenwindowtaglist(a6)	;wirst DU wohl aufgehen !
	move.l	d0,Winhandle(a5)
	tst.l	d0

	beq.w	.Error
.winopened

	move.l	d0,a0
	move.l	wd_userport(a0),a0	;User Port
	move.l	a0,port(a5)

	bsr	makebitmap
	blt	.Error
	bsr	maketables

	bsr	refresh

	bsr	addmenus		;Men darstellen

	lea	begin(pc),a0
	move.l	EUS_EPBase(a0),a0
	lea	EPG_someprefs(a0),a0
	move.l	a0,flagsadr(A5)

	move.l	intsave(a5),a6
	suba.l	a0,a0
	move.l	mypubscreen(a5),d0
	beq.s	.nopub
	move.l	d0,a1
	jsr	_LVOunlockpubscreen(a6)	;PUBscreen freigeben
.nopub	
.error2
	rts
.error
	bra	closewin
*******************************************************************
*                   Window schlieen                              *
*******************************************************************
Closewin
	tst.l	winhandle(a5)
	beq.s	.nowin

	bsr	freebitmap
	bsr	freemenus
	
	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	clr.l	Winhandle(a5)
	clr.l	port(a5)
	lea	begin(pc),a1

	move.w	myhoehe1(a5),d0		;Zipwindow ?
	cmp.w	wd_height(a0),d0
	beq.s	.noxy

	move.w	wd_leftedge(a0),d0
	and.w	#$fff,d0
	move.w	eus_winx(a1),d1
	and.w	#$f000,d1
	or.w	d0,d1
	move.w	d1,eus_winx(a1)

	move.w	wd_topedge(a0),d0
	and.w	#$fff,d0
	move.w	eus_winy(a1),d1
	and.w	#$f000,d1
	or.w	d0,d1
	move.w	d1,eus_winy(a1)

	move.w	wd_width(a0),eus_special(a1)
	move.w	wd_height(a0),eus_special+2(a1)
.noxy
	jsr	_LVOclosewindow(a6)
.nowin	rts
********************************************************************
*                  Init Message Struktur                           *
********************************************************************
Sendfirstmessage
	move.l	4,a6
	lea	Portname(pc),a1
	jsr	_LVOfindport(a6)
	tst.l	d0
	beq.s	.error

	move.l	d0,a0			;Portadresse

	move.l	msgport(a5),d3
	move.l	mytask(a5),d4
	move.l	mysignal(a5),d5
	move.w	#USclass_Newuserprg,d6

	ifne	debug

	bsr	allocmsg
	beq.s	.error
	move.l	d0,a1			;Messageadresse

	move.w	#UM_sizeof-20,mn_length(a1)
	move.b	#nt_message,ln_type(a1) ;Message-Typ
	lea	begin(pc),a2
	move.l	a2,um_result(a1)
	move.w	#-2,UM_UserNr(a1)
	move.l	#USM_Userprg,UM_Type(a1)

	move.l	d3,mn_replyport(a1)	;Portadresse,an die
						;zurckgesendet wird
	move.l	d3,UM_Userport(a1)
	move.l	d4,UM_TaskAdr(a1)
	move.l	d5,UM_Signal(a1)
	move.w	d6,UM_class(a1)

	move.l	4,a6
	jsr	_LVOputmsg(a6)

	else
	bsr	sendmess
	endc

	moveq	#0,d7
	rts
.error
	moveq	#-1,d7
	rts
******************************************************************************
* Abschiedsgru an Eagleplayer,der dann wei,da der Analyzer geendet hat    *
******************************************************************************
Sendlastmessage:
	move.l	4,a6
	lea	Portname(pc),a1	;EaglePlayer finden
	jsr	_LVOfindport(a6)
	tst.l	d0
	beq.s	.ok	;Eagleplayer hat sich schon verabschiedet

	move.l	d0,a0			;Portadresse
	move.l	msgport(a5),d3
	moveq	#0,d4
	moveq	#0,d5
	move.w	#USclass_exit,d6

	bsr	sendmess
.wait
	move.l	MSGport(a5),a0
	jsr	_LVOwaitport(a6)
	move.l	MSGport(a5),a0
	jsr	_LVOgetmsg(a6)
	tst.l	d0
	beq.s	.wait
	move.l	d0,a1
	cmp.l	#USM_Userprg,UM_Type(a1)
	beq.s	.meine
.nichtmeine
	jsr	_LVOreplymsg(a6)
	bra.s	.wait
.meine
.ok
	rts
*******************************************************************************
sendmess:
	bsr	allocmsg
	bne.s	.ok
	rts
.ok
	move.l	d0,a1			;Messageadresse

	move.w	#UM_sizeof-20,mn_length(a1)
	move.b	#nt_message,ln_type(a1) ;Message-Typ
	move.l	#USM_Userprg,UM_Type(a1)

	ifne	debug
	move.w	saveusernr(a5),UM_UserNr(a1)
	else
	lea	begin(pc),a2
	move.w	EUS_Usernr(A2),UM_UserNr(a1)
	endc

	move.l	d3,mn_replyport(a1)	;Portadresse,an die
						;zurckgesendet wird
	move.l	d3,UM_Userport(a1)
	move.l	d4,UM_TaskAdr(a1)
	move.l	d5,UM_Signal(a1)
	move.w	d6,UM_class(a1)

	clr.l	UM_Command(a1)
	clr.l	UM_Result(A1)
	clr.l	UM_ArgString(A1)

	move.l	4,a6
	jmp	_LVOputmsg(a6)
*******************************************************************************
*                        Mens erstellen                                      *
*******************************************************************************
MakeMenus
	move.l	gadsave(a5),A6

	move.l	mypubscreen(a5),a0
	suba.l	a1,a1
	jsr	_LVOgetvisualinfoa(a6)	;Visual Info vom Screen anfordern
	move.l	d0,vi(a5)
	tst.l	d0
	beq	.nomen

	lea	mymenus(A5),a0
	move.b	#nm_title,gnm_type(a0)
	lea	mylabel1(pc),a1
	move.l	a1,gnm_Label(a0)

	move.b	#nm_item,gnm_type+gnm_sizeof(a0)
	lea	mycheck1(pc),a1
	move.l	a1,gnm_Label+gnm_sizeof(a0)
	move.w	#CHECKIT,gnm_flags+gnm_sizeof(a0)
	lea	begin(pc),a2
	move.w	eus_winx(A2),d0
	rol.w	#4,d0			;nun Werte von 0-3 in D0
	and.b	#$f,d0
	bne.s	.nomode0
	move.w	#30,d1
	move.w	#Checked!CHECKIT,gnm_flags+gnm_sizeof(a0)
.nomode0
	move.l	#%1110,gnm_mutualexclude+gnm_sizeof(a0)

	move.b	#nm_item,gnm_type+gnm_sizeof*2(a0)
	lea	mycheck2(pc),a1
	move.l	a1,gnm_Label+gnm_sizeof*2(a0)
	move.w	#CHECKIT,gnm_flags+gnm_sizeof*2(a0)
	cmp.b	#1,d0
	bne.s	.nomode1
	move.w	#100,d1
	move.w	#Checked!CHECKIT,gnm_flags+gnm_sizeof*2(a0)
.nomode1
	move.l	#%1101,gnm_mutualexclude+gnm_sizeof*2(a0)

	move.b	#nm_item,gnm_type+gnm_sizeof*3(a0)
	lea	mycheck3(pc),a1
	move.l	a1,gnm_Label+gnm_sizeof*3(a0)
	move.w	#checkit,gnm_flags+gnm_sizeof*3(a0)
	cmp.b	#2,d0
	bne.s	.nomode2
	move.w	#200,d1
	move.w	#Checked!CHECKIT,gnm_flags+gnm_sizeof*3(a0)
.nomode2
	move.l	#%1011,gnm_mutualexclude+gnm_sizeof*3(a0)

	move.b	#nm_item,gnm_type+gnm_sizeof*4(a0)
	lea	mycheck3.1(pc),a1
	move.l	a1,gnm_Label+gnm_sizeof*4(a0)
	move.w	#checkit,gnm_flags+gnm_sizeof*4(a0)
	cmp.b	#3,d0
	bne.s	.nomode3
	move.w	#300,d1
	move.w	#Checked!CHECKIT,gnm_flags+gnm_sizeof*4(a0)
.nomode3
	move.l	#%0111,gnm_mutualexclude+gnm_sizeof*4(a0)

	move.w	d1,modeid(A5)

	move.b	#nm_item,gnm_type+gnm_sizeof*5(a0)
	lea	mycheck4(pc),a1
	move.l	a1,gnm_Label+gnm_sizeof*5(a0)
	move.w	#checkit!menutoggle,gnm_flags+gnm_sizeof*5(a0)
	lea	begin(pc),a2
	move.w	eus_winy(A2),d0
	rol.w	#4,d0			;nun Werte von 0-15 in D0
	btst	#0,d0
	sne	invertid(A5)
	beq.s	.noin
	move.w	#Checked!CHECKIT!menutoggle,gnm_flags+gnm_sizeof*5(a0)
.noin
	lea	gnm_sizeof*6(a0),a0
	move.b	#nm_item,gnm_type(a0)
	lea	mycheck5(pc),a1
	move.l	a1,gnm_Label(a0)
	move.w	#checkit!menutoggle,gnm_flags(a0)
	btst	#1,d0
	sne	brightid(A5)
	beq.s	.nobri
	move.w	#Checked!CHECKIT!menutoggle,gnm_flags(a0)
.nobri
	and.b	#1,brightid(A5)

	lea	gnm_sizeof(a0),a0
	move.b	#nm_item,gnm_type(a0)
	lea	mycheck6(pc),a1
	move.l	a1,gnm_Label(a0)
	move.w	#checkit!menutoggle,gnm_flags(a0)
	btst	#2,d0
	sne	slowid+1(A5)
	beq.s	.noslo
	move.w	#Checked!CHECKIT!menutoggle,gnm_flags(a0)
.noslo
	and.w	#1,slowid(A5)

	lea	gnm_sizeof(a0),a0
	move.b	#nm_item,gnm_type(a0)
	lea	mylabel2(pc),a1
	move.l	a1,gnm_Label(a0)
	lea	mylabel21(pc),a1
	move.l	a1,gnm_CommKey(a0)

	lea	gnm_sizeof(a0),a0
	move.b	#nm_item,gnm_type(a0)
	lea	mylabel4(pc),a1
	move.l	a1,gnm_Label(a0)
	lea	mylabel41(pc),a1
	move.l	a1,gnm_CommKey(a0)

	lea	gnm_sizeof(a0),a0
	move.b	#nm_item,gnm_type(a0)
	lea	mylabel3(pc),a1
	move.l	a1,gnm_Label(a0)
	lea	mylabel31(pc),a1
	move.l	a1,gnm_CommKey(a0)

	move.b	#nm_end,gnm_type+gnm_sizeof(a0)

	lea	mymenus(A5),a0
	move.l	gadsave(a5),a6
	lea	mytags(a5),a1
	move.l	#gtmn_fullmenu,(a1)+
	move.l	#1,(a1)+
	move.l	#GTMN_Newlookmenus,(A1)+
	move.l	#1,(a1)+
	move.l	#tag_done,(a1)+
	lea	mytags(a5),a1
	jsr	_LVOcreatemenusA(a6)
	move.l	d0,menuadr(a5)
	tst.l	d0
	beq.s	.nomen
	move.l	d0,a0
	move.l	vi(a5),a1
	lea	mytags(a5),a2
	move.l	#GTMN_Newlookmenus,(A2)+
	move.l	#1,(a2)+
	move.l	#tag_done,(a2)+
	lea	mytags(a5),a2
	jsr	_LVOLayoutMenusA(a6)
	tst.l	d0
	beq.s	.free
	
	moveq	#0,d7
	rts
.free
	move.l	menuadr(a5),a0
	jsr	_LVOfreemenus(a6)
.nomen
	moveq	#-1,d7
	rts
********************* Visual Info Freigeben ***********************************
Freevi:
	move.l	vi(a5),a0
	jmp	_LVOfreevisualinfo(a6)
*********************** Men wechschmeisen ************************************
Freemenus
	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	jsr	_LVOclearmenustrip(A6)
	
	move.l	gadsave(a5),a6
	move.l	Menuadr(a5),d0
	beq.s	.end
	move.l	d0,a0
	jmp	_LVOfreemenus(a6)
.end
	bsr	Freevi	;Visual Info Wegschmeien
	rts
********************* Men anhngen *************************
Addmenus
	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	move.l	Menuadr(a5),a1
	jmp	_LVOsetmenustrip(a6)
*************************************************************
*     2. Bitmap erzeugen fr direkten Zugriff auf Bild      *
*       (per Blitter wird kopiert,Tiefe = 1)                *
*************************************************************
makebitmap
	lea	my_bitmap(a5),a3

	move.l	4,a6
	move.l	winhandle(A5),d0
	beq.s	.norast
	move.l	d0,a0

	move.w	wd_width(a0),d0		;ganze Breite
	sub.w	#38-8,d0
	lsr.w	#3,d0
	and.w	#~1,d0
	move.w	d0,(a3)			;bm_BytesPerRow

	move.w	wd_height(a0),d1
	move.b	wd_borderbottom(a0),d2
	ext.w	d2
	sub.w	myhoehe1(a5),d1
	mulu	d1,d0			;Breite in Bytes mal Hhe
	sub.w	d2,d1
	sub.w	#15,d1
	move.w	d1,bm_rows(a3)		;Anzahl Zeilen

	move.b	brightid(a5),d1
	addq.b	#1,d1
	move.b	d1,bm_depth(a3)		;auf 1 lassen

	move.l	d0,d6
	add.l	d0,d0			;2 Bitplanes
	move.l	d0,memsize(a5)
	move.l	#$10002,d1		;#memf_chip,d1
	jsr	_LVOallocmem(a6)
	tst.l	d0
	beq.s	.norast
	move.l	d0,bm_planes(a3)
	add.l	d6,d0
	move.l	d0,bm_planes+4(a3)

	moveq	#0,d7
	rts
.norast2

.norast
	moveq	#-1,d7
	rts
**************************************************************
*                   Bitplane(s) freigeben                    *
**************************************************************
freebitmap
	move.l	4,a6
	lea	my_bitmap(a5),a1
	move.l	bm_planes(a1),d0	;Planeptr[1]
	beq.s	.no1
	move.l	d0,a1
	move.l	memsize(A5),d0
	jsr	_LVOfreemem(a6)	
.no1
	lea	my_bitmap(a5),a1
	clr.l	bm_planes(a1)	;Planeptr[1] lschen
RET	rts
*****************************************************************
allocmsg
	movem.l	d1-a6,-(sp)
	move.l	4,a6
	moveq	#UM_Sizeof,d0
	move.l	#$10001,d1
	jsr	_LVOallocmem(A6)
	movem.l	(sp)+,d1-a6
	tst.l	d0
	rts
*****************************************************************
freemsg
	moveq	#UM_sizeof,d0
	move.l	4,a6
	jsr	_LVOfreemem(A6)
	rts
*************************************************************
*           Windowrefresh und Detaildarstellung             *
*************************************************************
Refresh:
	move.l	winhandle(a5),d0
	beq.s	RET
	move.l	d0,a0

	move.l	grafsave(a5),a6
	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	moveq	#1,d0
	jsr	_LVOsetapen(A6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	moveq	#0,d0
	jsr	_LVOsetbpen(A6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	moveq	#1,d0			;RP_Jam2
	jsr	_LVOsetdrmd(A6)

	move.b	rp_areaptsz(a1),d4
	move.l	rp_areaptrn(a1),d5

	move.l	winhandle(A5),a1
	move.w	wd_width(A1),d2		;x2
	sub.w	#19-6,d2

	move.w	wd_height(a1),d3
	move.l	wd_rport(a1),a1

	move.b	#1,rp_areaptsz(a1)
	lea	patt1(pc),a0
	move.l	a0,rp_areaptrn(a1)

	move.w	#3,d0			;x1
	move.w	myhoehe1(A5),d1		;y1

	subq.w	#3,d3			;y2

	movem.l	d4-d5,-(sp)
	jsr	_LVOrectfill(a6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(A1),a1
	move.b	d4,rp_areaptsz(a1)
	move.l	d5,rp_areaptrn(a1)

	move.l	winhandle(A5),a1
	move.w	wd_width(a1),d2
	move.w	wd_height(a1),d3
	moveq	#0,d0
	move.b	WD_Borderbottom(a1),d0
	sub.w	d0,d3

	move.l	wd_rport(a1),a1

	lea	patt2(pc),a0
	move.l	a0,rp_areaptrn(a1)

	move.w	#12,d0 ;Left
	move.w	myhoehe1(a5),d1	;Top
	add.w	#7,d1
	sub.w	#24+2,d2
	sub.w	#5,d3
	jsr	_LVOrectfill(a6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	move.w	#3+8,d0
	move.w	myhoehe1(A5),d1		;y1
	addq.w	#4,d1
	jsr	_LVOmove(A6)

	movem.l	(Sp)+,d4-d5

	move.l	gadsave(a5),a6
	move.l	winhandle(a5),a0
	move.w	wd_width(a0),d2
	move.w	wd_height(a0),d3
	moveq	#0,d0
	move.b	WD_Borderbottom(a0),d0
	sub.w	d0,d3
	move.l	wd_rport(a0),a0
	lea	mytags(a5),a3
	move.l	#GT_Visualinfo,(a3)+
	move.l	vi(a5),(a3)+
	move.l	#GTBB_recessed,(a3)+
	move.l	#1,(a3)+
	move.l	#tag_done,(a3)+
	lea	mytags(a5),a3		;TagList mu in A3 und A1 sein !!!!!!!
	move.l	a3,a1
	move.w	#12,d0 ;Left
	move.w	myhoehe1(a5),d1	;Top
	add.w	#7,d1
	sub.w	#24+14,d2
	sub.w	d1,d3
	sub.w	#4,d3
	jsr	_LVOdrawbevelboxa(a6)

	move.l	winhandle(A5),a0
	move.l	intsave(a5),a6
	jsr	_LVOrefreshwindowframe(A6)

	bsr	clear
	bra	intowindow
***************************************************************
*            Tabellen fr Multiplikation erstellen            *
***************************************************************
maketables:
	move.l	winhandle(a5),a0
	move.w	wd_width(a0),d0
	sub.w	#46,d0
	move.w	d0,pixelZ(A5)

	lea	mulutab+256(A5),a0
	move.w	#128-1,d0
	move.w	my_bitmap(A5),d2
	move.w	my_bitmap+bm_rows(A5),d3
	move.w	d3,d5
	lsr.w	#1,d3				;Zeilen durch 2
	mulu	d2,d3				;Mitte
	moveq	#0,d1
	moveq	#0,d4

	move.l	d3,d6
	add.w	d6,d6
.mulutab
	add.w	d3,d4
	bpl.s	.goon
	moveq	#0,d4
.goon
	move.w	d4,(a0)+
	addq.w	#1,d1				;Nchster Wert
	move.w	d1,d4				;
	mulu	d5,d4				;mal max. Anzahl Zeilen
	lsr.l	#8,d4				;durch 128 Steps
	mulu	d2,d4				;mal Bytes pro Zeile
	dbf	d0,.mulutab

	lea	mulutab+256(A5),a0
	move.w	#128-1,d0
	move.w	my_bitmap(A5),d2
	move.w	my_bitmap+bm_rows(A5),d3
	move.w	d3,d5
	lsr.w	#1,d3				;Zeilen durch 2
	mulu	d2,d3				;Mitte
	moveq	#0,d1
	moveq	#0,d4
.mulutab1
	add.w	d3,d4
	bpl.s	.goon2
	moveq	#0,d4
.goon2
	move.w	d4,-(a0)
	subq.w	#1,d1				;Nchster Wert
	move.w	d1,d4				;
	muls	d5,d4				;mal Anzahl Zeilen
	asr.l	#8,d4				;durch 128 Steps
	muls	d2,d4
	dbf	d0,.mulutab1

	move.w	my_bitmap(A5),d2		;Bytes per row
	moveq	#0,d0
	move.w	d2,d5
	lsl.w	#2,d5				;durch 2 mal 8
	move.w	my_bitmap+bm_rows(A5),d3
	move.w	d2,d4
	lsl.w	#3,d4

;	move.w	pixelz(A5),d4			;Pixel horizontal

	move.w	#256-1,d0
	lea	HoriTAB(a5),a0
	moveq	#-128,d1
.hori1
	move.w	d1,d6
	addq.w	#1,d1
	muls	d4,d6
	asr.l	#8,d6
	add.l	d5,d6			;auf Mitte
	bpl.s	.goon3
	moveq	#0,d6
.goon3
	move.l	d6,d2

	lsr.w	#3,d2			;Hori Bytes
	move.b	d2,(A0)+		;Hori Bytes
	and.b	#7,d6
	moveq	#7,d2
	sub.b	d6,d2
	move.b	d2,(a0)+		;Hori Pixels
	dbf	d0,.hori1
	rts
***************************************************************
* ANALYZER , berechnet Positionen,zeichnet ein und stellt dar *
* 1. Variante,(von unten nach oben wachsend)                  *
***************************************************************
Clear:
;============== Normale Lschroutine ===========================
	lea.l	my_bitmap(a5),a0
	move.l	bm_planes(a0),d0
	beq.s	.fail
	move.l	d0,a1			;1.Bitplane

	move.l	memsize(A5),d0
	lsr.l	#3,d0
	move.l	d0,d1
	moveq	#-1,d2

	move.b	invertid(a5),d6
	bne.s	.invert
.clr2
	move.l	d2,(a1)+
	subq.l	#1,d0
	bne.s	.clr2
.clr1
	clr.l	(a1)+
	subq.l	#1,d1
	bne.s	.clr1	
.fail
	rts
.invert
.clr12
	clr.l	(a1)+
	subq.l	#1,d1
	bne.s	.clr12
.clr21
	move.l	d2,(a1)+
	subq.l	#1,d0
	bne.s	.clr21
	rts
Analyze1
	addq.w	#1,counter(A5)
	bsr	clear
;=============== Kanle auswerten ============================================
;====================== Bereich lschen ===================================
	addq.w	#1,wait(A5)
	move.w	slowid(a5),d0
	and.w	d0,wait(A5)

;	move.w	word8(a5),d0		;irgendwas mit`m Eagleplayer nicht in
;					;Ordnung ?
;	beq.s	.ok			;alles klar
;	move.w	counter(A5),d0
;	cmp.w	#50*50*4,d0		;1sek*60*4 = 4 Minuten	
;	blo.s	.ok
;	move.l	immernull(A5),a0
;	clr.l	(A0)+			;Adresse 0 lschen
;	clr.l	(A0)+			;nebenbei Execbase lschen
;.ok

	move.l	AN_Structadr(a5),a4;Analyzer Struktur
	moveq	#-1,d2				;Alle Kanle
	move.w	ups_flags(a4),d1
	and.w	#UPSB_Dmacon,d1			;Flag ob Kanle an/aus ?
	beq.s	.nodmacon
	move.w	UPS_Dmacon(a4),d2	;Ja,zugehrige Werte ranholen
.nodmacon

	lea	permerk(a5),a3	;SamplePeriod merken und Spielzeit der Samples
				;in 1/50 Sekunden
	moveq	#0,d4

	lea	vol64(pc),a2

	move.l	flagsadr(A5),a4
	move.l	(a4),d6
	and.l	#EGPRB_MasterVolume,d6
	beq.s	.NoMaster

	lea	begin(pc),a2
	move.l	EUS_EPBase(a2),a2
	lea	EPG_Voice1vol(a2),a2
.nomaster
	move.l	AN_Structadr(a5),a4;Analyzer Struktur
Scope1:
	lsr.w	#1,d2
	bcc.s	.no
	move.l	UPS_Voice1Adr(a4),d1
	beq.s	.no
	move.l	d1,a1
	move.w	UPS_Voice1Per(a4),d1
	beq.s	.ok

	move.w	d1,(a3)
	move.w	#0,2(a3)
	bra.s	.copyto
.ok
	tst.w	(a3)		;berhaupt keine Sampleperiod bergeben ?
	beq.s	.no
.copyto
	move.w	UPS_Voice1len(a4),d4
	cmp.w	#3,d4
	blo.s	.no
	bsr	copybitmap
.no
	addq.l	#4,a3
	move.l	an_structadr(a5),a4
	lea	UPS_Modulo*3(a4),a4	 ;Analyzer Struktur 4.Stimme
Scope4:
	lsr.w	#1,d2
	bcc.s	.no
	move.l	UPS_Voice1Adr(a4),d1
	beq.s	.no
	move.l	d1,A1
	move.w	UPS_Voice1Per(a4),d1
	beq.s	.ok
	move.w	d1,(a3)
	move.w	#0,2(a3)
	bra.s	.copyto
.ok
	tst.w	(a3)		;berhaupt keine Sampleperiod bergeben ?
	beq.s	.no
.copyto
	move.w	UPS_Voice1len(a4),d4
	cmp.w	#2,d4
	blo.s	.no
	bsr	copybitmap
.no
	addq.l	#4,a3
	move.l	an_structadr(a5),a4
	lea	UPS_Modulo(a4),a4	 ;Analyzer Struktur 2.Stimme
Scope2:
	lsr.w	#1,d2
	bcc.s	.no
	move.l	UPS_Voice1Adr(a4),d1
	beq.s	.no
	move.l	d1,a1
	move.w	UPS_Voice1Per(a4),d1
	beq.s	.ok
	move.w	d1,(a3)
	move.w	#0,2(a3)
	bra.s	.copyto
.ok
	tst.w	(a3)		;berhaupt keine Sampleperiod bergeben ?
	beq.s	.no
.copyto
	move.w	UPS_Voice1len(a4),d4
	cmp.w	#2,d4
	blo.s	.no
	bsr	copybitmap
.no
	addq.l	#4,a3

	move.l	an_structadr(a5),a4
	lea	UPS_Modulo*2(a4),a4	 ;Analyzer Struktur 3.Stimme
Scope3:
	lsr.w	#1,d2
	bcc.s	.no
	move.l	UPS_Voice1Adr(a4),d1
	beq.s	.no
	move.l	d1,A1
	move.w	UPS_Voice1Per(a4),d1
	beq.s	.ok
	move.w	d1,(a3)
	move.w	#0,2(a3)
	bra.s	.copyto
.ok
	tst.w	(a3)		;berhaupt keine Sampleperiod bergeben ?
	beq.s	.no
.copyto
	move.w	UPS_Voice1len(a4),d4
	cmp.w	#2,d4
	blo.s	.no
	bsr	copybitmap
.no
; ========= In das Window (dessen Rastport) kopieren =====================
; ============== ZielPosition X2 in D2 bergeben =========================
intowindow:
	tst.w	wait(A5)
	bne.s	RTE

	move.l	4,a6
	moveq	#0,d0
	move.l	mytask(a5),a1
	jsr	_LVOsettaskpri(A6)
	move.l	d0,-(sp)

	move.l	grafsave(a5),a6
	move.l	winhandle(a5),a1
	move.l	wd_rport(a1),a1		;Rastport (Ziel)
	move.w	#16,d2			;X2->Position im Fenster
	move.w	myhoehe1(a5),d3		;Y2
	add.w	#9,d3

	lea	my_bitmap(a5),a0	;Bitmap (Quelle)
	tst.l	bm_planes(a0)
	beq.s	.skip
	moveq	#0,d0			;X1
	moveq	#0,d1			;Y1

	move.w	pixelz(a5),d4		;Breite
	move.w	bm_rows(a0),d5		;Hhe	
		
	move.b	#$c0,d6		;Miniterm

	jsr	_LVObltbitmaprastport(a6)
.skip
	move.l	4,a6
	move.l	(sp)+,d0
	move.l	mytask(a5),a1
	jsr	_LVOsettaskpri(A6)
RTE
	rts
;============ Kopieren des Samples in die Bitmap =======================
copybitmap:
	tst.w	wait(A5)
	bne.s	RTE

	lea.l	my_bitmap(a5),a0
	moveq	#0,d0
	move.w	(a0),d0			;Bytes per Row
	move.l	bm_planes(a0),a0	;1.Bitplane

	and.l	#$ffff,d4
	add.l	d4,d4		;Samplelnge Words -> Samplelnge Bytes

	move.w	2(a3),d0
	swap	d0		;=d0*65535
	lsr.l	#1,d0
	divu	(a3),d0		;durch Sampleperiod
	and.l	#$ffff,d0
 	add.l	d0,d0
	cmp.l	d4,d0		;grer als Samplelnge ?
	blo.s	cbm_ok
	tst.w	ups_voice1repeat(a4)
	bne	cbm_reddy
cbm_loop
	tst.l	d4
	bne.s	.divu
	moveq	#0,d0
	clr.w	2(a3)
	bra.s	cbm_ok
.divu
	divu	d4,d0
	swap	d0
	clr.w	2(a3)
	and.l	#$ffff,d0
cbm_ok
	add.l	d0,a1

	sub.l	d0,d4			;Lnge - Anfangsoffset im Sample

	move.w	UPS_Voice1vol(a4),d1
;	move.w	#63,d1			;testweise

	cmp.w	#63,d1
	blo.s	.ok
	moveq	#63,d1
.ok
	mulu	(A2)+,d1		;Mastervolume

				;!!!! statt lsr #6,d1 und unten lsl #9
				;     lsl #3 und AND
;	lsl.w	#8,d1			;mal 512 (dann ist Ergebnis so weit
;					;nach links geschiftet, da man statt
;					;normal asr #6  SWAP nehmen kann
;	add.w	d1,d1

	lsl.l	#3,d1
	and.l	#~511,d1

	moveq	#0,d7
	move.w	modeid(a5),d7		;Schleifenzhler Pixelanzahl
	cmp.l	d7,d4			;Rest vom Sample grer Pixelanzahl ?
	bhs.s	.oksam			;n
	move.w	d4,d7			;Pixelanzahl = Rest vom Sample
	bge.s	.oksam
	neg.w	d7
.oksam
	move.w	#[an_zeilen/2+4]*[an_num+4],d4
	moveq	#0,d6
	movem.l	d2/d3/a2/a3/a4,-(sp)
	moveq	#0,d3
	lea	20(a1),a2	;abstimmen auf bestmgliches Ergebnis

	lea	mulutab+256(a5),a3
	lea	HORItab+256(a5),a4
	move.l	bm_planes+4+my_bitmap(a5),a6	;2.Bitplane

	move.b	invertid(a5),d6
	bne.w	.invert
	move.b	brightid(a5),d6
	bne.w	.bright1

;	move.l	flagsadr(A5),a4
;	move.l	(a4),d6
;	and.l	#EGPRB_MasterVolume,d6
;	beq.s	.NoMaster
	lea	HORItab+256(a5),a4

	tst.b	MC68020on(A5)
	bne.s	.Opti020Routine
.mainloop
	move.b	(a1)+,d6
	ext.w	d6
	add.w	d6,d6
	muls	d1,d6
	clr.w	d6
	swap	d6
	add.w	d6,d6
	move.w	(a3,d6.w),d6		;Mulutab und auch Tabelle zum setzen
					;des Ausgangspunktes in die Mitte
	move.b	(a2)+,d3
	ext.w	d3
	add.w	d3,d3
	muls	d1,d3
	swap	d3
	add.w	d3,d3

	move.b	1(a4,d3.w),d2
	move.b	(a4,d3.w),d3
	ext.w	d3
	ext.l	d3
	add.l	d3,d6
	bclr	d2,(a0,d6.l)

	dbf	d7,.mainloop
	bra.s	.endloop
.opti020routine
.do020
	move.b	(a1)+,d6
	ext.w	d6
	add.w	d6,d6
	muls	d1,d6
	clr.w	d6
	swap	d6
	move.w	(a3,d6.w*2),d6		;Mulutab und auch Tabelle zum setzen
					;des Ausgangspunktes in die Mitte
	move.b	(a2)+,d3
	ext.w	d3
	add.w	d3,d3
	muls	d1,d3
	swap	d3
	add.w	d3,d3
	move.b	1(a4,d3.w),d2
	move.b	(a4,d3.w),d3
	extb.l	d3
	add.l	d3,d6
	bclr	d2,(a0,d6.l)
	dbf	d7,.do020
	bra.s	.endloop
.invert
	move.b	brightid(a5),d6
	bne.s	.bright2
.invertloop
	move.b	(a1)+,d6
	ext.w	d6
	add.w	d6,d6
	muls	d1,d6
	clr.w	d6
	swap	d6
	add.w	d6,d6
	move.w	(a3,d6.w),d6		;Mulutab und auch Tabelle zum setzen
					;des Ausgangspunktes in die Mitte
	move.b	(a2)+,d3
	ext.w	d3
	add.w	d3,d3
	muls	d1,d3
	swap	d3
	add.w	d3,d3

	move.b	1(a4,d3.w),d2
	move.b	(a4,d3.w),d3
	ext.w	d3
	ext.l	d3
	add.l	d3,d6
	bset	d2,(a0,d6.l)

	dbf	d7,.invertloop
.endloop
	movem.l	(sp)+,d2/d3/a2/a3/a4
	addq.w	#1,2(a3)
	moveq	#0,d4
	rts
.bright2
	exg.l	a6,a0
.bright1
	move.b	(a1)+,d6
	ext.w	d6
	add.w	d6,d6
	muls	d1,d6
	clr.w	d6
	swap	d6
	add.w	d6,d6

	move.w	(a3,d6.w),d6		;Mulutab und auch Tabelle zum setzen
					;des Ausgangspunktes in die Mitte
	move.b	(a2)+,d3
	ext.w	d3
	add.w	d3,d3
	muls	d1,d3
	swap	d3
	add.w	d3,d3

	move.b	1(a4,d3.w),d2
	move.b	(a4,d3.w),d3
	ext.w	d3
	ext.l	d3
	add.l	d3,d6
	bclr	d2,(a0,d6.l)
	bset	d2,(a6,d6.l)

	dbf	d7,.bright1
	bra.s	.endloop
cbm_reddy
	clr.w	(a3)
	rts
*******************************************************************
*    berprfen,ob Analyzerstruktur schon bergeben wurde und     *
* und ob der aktuelle Player Lautstrke und Sampleperiod bergibt *
*******************************************************************
AN_test
	move.l	winhandle(a5),d0	;Window berhaupt offen ?
	beq.w	.noanalyze
	move.l	d0,a0
	move.w	myhoehe1(a5),d0
	cmp.w	wd_height(a0),d0	;Window im ZIP-Modus ?
	beq.w	.noanalyze

	move.l	an_structadr(a5),d0	;Strukturadresse vorhanden ?
	beq.w	.Noanalyze
	move.l	d0,a0

	tst.w	UPS_enabled(a0)		;Zugriff erlaubt ?
	bne.w	.noanalyze

	move.w	UPS_Flags(a0),d0	;alle bentigten Werte bergeben ?
	and.w	#UPSB_Per!UPSB_len!UPSB_adr,d0
	cmp.w	#UPSB_Per!UPSB_len!UPSB_adr,d0
	bne.w	.noanalyze

;	lea.l	an_struct(a5),a1
;
;	move.w	UPS_Flags(a0),UPS_Flags(a1)
;	move.w	UPS_Dmacon(a0),UPS_Dmacon(a1)
;	move.w	UPS_Voice1per(a0),UPS_Voice1per(a1)
;	move.w	UPS_Voice2per(a0),UPS_Voice2per(a1)
;	move.w	UPS_Voice3per(a0),UPS_Voice3per(a1)
;	move.w	UPS_Voice4per(a0),UPS_Voice4per(a1)
;	move.w	UPS_Voice1len(a0),UPS_Voice1len(a1)
;	move.w	UPS_Voice2len(a0),UPS_Voice2len(a1)
;	move.w	UPS_Voice3len(a0),UPS_Voice3len(a1)
;	move.w	UPS_Voice4len(a0),UPS_Voice4len(a1)
;	move.w	UPS_Voice1vol(a0),UPS_Voice1vol(a1)
;	move.w	UPS_Voice2vol(a0),UPS_Voice2vol(a1)
;	move.w	UPS_Voice3vol(a0),UPS_Voice3vol(a1)
;	move.w	UPS_Voice4vol(a0),UPS_Voice4vol(a1)
;	move.l	UPS_Voice1Adr(a0),UPS_Voice1adr(a1)
;	move.l	UPS_Voice2Adr(a0),UPS_Voice2adr(a1)
;	move.l	UPS_Voice3Adr(a0),UPS_Voice3adr(a1)
;	move.l	UPS_Voice4Adr(a0),UPS_Voice4adr(a1)
;	move.w	UPS_Voice1Repeat(a0),UPS_Voice1repeat(a1)
;	move.w	UPS_Voice2Repeat(a0),UPS_Voice2repeat(a1)
;	move.w	UPS_Voice3Repeat(a0),UPS_Voice3repeat(a1)
;	move.w	UPS_Voice4Repeat(a0),UPS_Voice4repeat(a1)

	bra	Analyze1
.noanalyze
	rts
*************************************************************
*           Nachrichtenbearbeitung                          *
*************************************************************
HandleActions
	bra.s	.ma2
.ma
	btst	d3,d0
	beq.s	.ma2

	movem.l	d0/d3,-(sp)
	bsr.w	an_test
	movem.l	(sp)+,d0/d3
	bclr	d3,d0
	tst.l	d0
	beq	.waitsig
.ma2
	move.l	4,a6
	move.l	port(a5),d0
	beq.s	.nowinport
	move.l	d0,a0
	jsr	_LVOgetmsg(a6)
	tst.l	d0
	bne	.msg
.nowinport
	move.l	msgport(a5),a0
	jsr	_LVOgetmsg(a6)
	tst.l	d0
	bne	.AN_msg
.waitsig
	move.l	4,a6
	moveq	#0,d0
	move.l	port(a5),d1
	beq.s	.noport
	move.l	d1,a0
	move.b	mp_sigbit(a0),d1
	bset	d1,d0
.noport
	move.l	msgport(a5),a0

	move.b	mp_sigbit(a0),d1
	bset	d1,d0

	move.l	mysignal(a5),d3

	tst.l	an_structadr(A5)
	beq.s	.nowaitsig

	bset	d3,d0
.nowaitsig
	jsr	_LVOwait(a6)
	bra	.ma
.AN_msg
	move.l	d0,a1

	move.l	MSGPort(a5),UM_Userport(a1)
	lea	begin(pc),a2

	ifne	debug
	move.w	um_usernr(a1),saveusernr(A5)
	else
	lea	begin(pc),a2
	move.w	EUS_Usernr(A2),UM_UserNr(a1)
	endc

	move.l	mytask(a5),UM_TaskAdr(a1)
	move.l	mysignal(a5),d1
	move.l	d1,UM_Signal(a1)

	move.w	UM_class(a1),d3		<-
	move.l	UM_Type(a1),d7
	move.w	UM_Signal(a1),d5 	<-
	move.l	UM_structadr(a1),d6 	<-

	cmp.w	#USclass_exit,d3
	bne.s	.noexi
	clr.l	UM_Signal(a1)
	clr.l	UM_Taskadr(a1)
.noexi
	cmp.w	#USclass_getconfig,d3		;when this command comes,set
						;the actual preferences into
						;the Eagleuser-Structure
						;(EUS_-structure at the be-
						;ginning of the program)
	bne	.noprev

	lea	begin(pc),a2

	moveq	#0,d0	
	move.b	invertid(a5),d1
	sne	d0
	and.w	#1,d0

	move.b	brightid(a5),d1
	beq.s	.nosetbr
	or.b	#2,d0				;Bset #1,d0
.nosetbr
	move.w	slowid(a5),d1
	beq.s	.nosetslo
	or.b	#4,d0				;Bset #1,d0
.nosetslo
	ror.w	#4,d0
	move.w	eus_winy(A2),d1
	and.w	#$fff,d1
	or.w	d0,d1
	move.w	d1,eus_winy(A2)

	moveq	#0,d0
	move.l	winhandle(A5),d1		;Window
	beq.s	.prnowin			;no Window opened,no change
						;of preferences
	or.w	#eusb_openwin,d0		;set Flag: window is open

	move.l	d1,a0				;Window

	move.w	wd_leftedge(a0),d4
	and.w	#$fff,d4
	move.w	eus_winx(a2),d1
	and.w	#$f000,d1
	or.w	d4,d1
	move.w	d1,eus_winx(a2)

	move.w	wd_topedge(a0),d4
	and.w	#$fff,d4
	move.w	eus_winy(a2),d1
	and.w	#$f000,d1
	or.w	d4,d1
	move.w	d1,eus_winy(a2)

	move.w	wd_width(a0),eus_special(a2)
	move.w	wd_height(a0),eus_special+2(a2)
.prnowin
	move.w	d0,eus_flags(a2)		;Save Flags
.noprev
	move.w	#USClass_Dummy,UM_Class(A1)

	cmp.w	#USclass_Show,d3
	beq.s	.win
	cmp.w	#USclass_Activate,d3
	bne.w	.nowin
.win
	move.l	Begin+EUS_EPBase(pc),a0
	move.l	EPG_SomePrefs(a0),d0
	btst	#EGPRF_Iconify,d0
	bne.w	.noShow

	push	all
	bsr	Openwin
	pop	all
	tst.l	Winhandle(A5)
	beq.s	.noshow
	move	d3,UM_Class(a1)
.noWin
.noshow

	cmp.w	#USclass_Hide,d3
	beq.s	.closewin
	cmp.w	#USclass_DeActivate,d3
	bne.s	.noclosewin
.closewin
	push	all
	bsr	Closewin
	pop	all
.noclosewin
	move.l	d6,an_structadr(a5)	;Analyzerstrukturadresse merken
	tst.l	d6
	bne.s	.noclr

	move.l	winhandle(a5),d0
	beq.s	.noclr

	push	all
		bsr	clear
		bsr	intowindow
	pop	all
.noclr

	cmp.w	#USClass_Answer,d3
	bne.s	.notanswered

	move.l	UM_Command(a1),SaveCommand(A5)
	move.l	UM_Result(a1),SaveResult(A5)

	move.l	UM_ArgString(A1),d0
	beq.s	.notanswered
	clr.l	UM_Argstring(a1)
	move.l	d0,Savestring(A5)
.notanswered
	move.l	mn_replyport(a1),d0
	cmp.l	MSGport(a5),d0		 ;eine von uns abgeschickte Message ?
	beq.s	.noreply
	jsr	_LVOreplymsg(a6)
.noreply
	cmp.l	#USM_Eagleplayer,d7	;Hat EaglePlayer was zu melden ?
	beq	.mess

	bsr	freemsg

.mess
	move.l	savestring(a5),d0
	beq.s	.nostring
	movem.l	d0-a6,-(sp)

	clr.l	savestring(A5)
	move.l	d0,d6
	move.l	4,a6
.clrnext
	move.l	d6,a3
	move.l	EPT_Stringsize(A3),d0
	move.l	a3,a1
	move.l	EPT_Next(A3),d6
	jsr	_LVOfreemem(A6)
	tst.l	d6
	bne.s	.clrnext

	movem.l	(sp)+,d0-a6
.nostring
	cmp.w	#USclass_Dummy,d3	;leere Message,nur neue Analyzer-
	beq	.ma2			;adresse bekommen

	cmp.w	#USclass_zipwin,d3
	bne.s	.nozip
.setzip
	move.l	4,a6

	move.l	winhandle(a5),d0
	beq	.ma
	move.l	d0,a0
	move.w	wd_height(a0),d0
	cmp.w	myhoehe1(a5),d0
	beq.w	.ma		;Window schon klein
.zip
	move.w	d0,-(sp)

	move.l	intsave(a5),a6
	jsr	_LVOzipwindow(a6)

	move.w	(sp)+,d4

	move.l	winhandle(a5),a2
.Zipwait:
	moveq	#1,d1
	move.l	_Dos(a5),a6
	jsr	_LVODelay(a6)

	cmp.w	wd_height(a2),d4
	beq.s	.zipwait

	bra	.ma
.nozip
	cmp.w	#USclass_unzipwin,d3
	bne.s	.nounzip

.clearzip
	move.l	4,a6

	move.l	winhandle(a5),d0
	beq	.ma
	move.l	d0,a0
	move.w	wd_height(a0),d0
	cmp.w	myhoehe1(a5),d0
	beq.s	.zip
	bra	.ma
.nounzip

	cmp.w	#USclass_exit,d3
	beq	.exit

	cmp.w	#USclass_NewConfig,d3	;is there a new config
	bne.w	.nonewcon		;no

	lea	begin(pc),a0		;start of program (EUS_-Structure)
	move.w	eus_flags(a0),d0	;get Flags
	btst	#eusf_openwin,d0	;Window open ?
	beq.s	.nowino
	bsr	openwin			;open it
	bra.s	.weio
.nowino
	bsr	closewin		;else close it
.weio
	lea	begin(pc),a0		;start of program (EUS_-Structure)
	move.l	winhandle(a5),d0	;windowaddress
	beq.s	.nothingtomove		;no Window , no movement

	move.l	d0,a1			;Window
	move.l	wd_wscreen(a1),a2	;Parent Screen

	move.w	eus_winx(a0),d0		;new X-position
	and.w	#$fff,d0
	move.w	d0,d1			;save
	blt.s	.oldx			;less than 0 -> stop

	add.w	#win_breite,d1		;new position + Window-width
	cmp.w	sc_width(a2),d1		;bigger than Screenwidth ?
	bhi.s	.oldx			;then old X-position (Delta = 0)

	sub.w	wd_leftedge(a1),d0	;new - old X-position = Delta X
	bra.s	.gety
.oldx
	moveq	#0,d0			;Delta X = 0
.gety
	move.w	eus_winy(a0),d1		;new Y-position
	and.w	#$fff,d1

	move.w	d1,d2			;save
	blt.s	.oldy			;less than 0 -> stop and take old

	add.w	wd_height(a1),d2	;new position + window-height
	cmp.w	sc_height(a2),d2	;bigger than Screenheight ?
	bhi.s	.oldy

	sub.w	wd_topedge(a1),d1	;new - old Y-position = Delta Y
	bra.s	.setdeltas
.oldy	moveq	#0,d1

.setdeltas
	move.l	intsave(a5),a6		;Intuition
	move.l	a1,a0			;Winhandle
	jsr	_LVOmovewindow(A6)
.nothingtomove
	lea	begin(pc),a0
	move.w	eus_flags(a0),d0
	btst	#eusf_zipwin,d0		;Zipwindow ?
	bne	.setzip			;yes
	bra	.clearzip		;no
.nonewcon
	bra	.ma
.noeagle
	bra	.ma2
.msg
	move.l	d0,a1
	move.l	im_class(a1),d7
	move.w	im_code(a1),d5 		<-
	move.l	im_Iaddress(a1),d6 	<-
	jsr	_LVOreplymsg(a6)

	cmp.l	#IDCMP_NEWSIZE,d7
	bne.w	.standard

	bsr	freebitmap
	bsr	makebitmap
	bsr	maketables

	bra	.ma2
.standard
	cmp.l	#refreshwindow,d7
	bne.s	.noref
	bsr	refresh
	bra	.ma2
.noref
.testgads
	cmp.l	#CloseWindow,d7
	bne	.noclo
.closewinny
	if	Test=0
	bsr	closewin
	move.l	4,a6
	lea	Portname(pc),a1
	jsr	_LVOfindport(a6)
	tst.l	d0
	beq.w	.endme		;kein Eagleplayerport->Ende des Programmes
	move.l	d0,a0			;Portadresse
	move.l	msgport(a5),d3
	move.l	mytask(a5),d4
	move.l	mysignal(a5),d5
	move.w	#USclass_DeActivate,d6
	bsr	sendmess
	bra	.ma2
	else
	bra.s	.endme
	endc
.noclo
	cmp.l	#menupick,d7
	bne.w	.nomenu

	cmp.w	#menunull,d5
	beq	.ma2
	bra.s	.nextme
.next
	move.w	mi_nextselect(a1),d5
	cmp.w	#menunull,d5
	beq	.ma2
.nextme
	move.w	d5,d0
	move.l	intsave(A5),a6
	move.l	menuadr(a5),a0
	jsr	_LVOitemaddress(a6)
	tst.l	d0
	beq	.ma2
	move.l	d0,a1

	move.w	d5,d0
	and.w	#$7e0,d0
	bne.s	.nomodeit1
	moveq	#30,d1
.mode					;1.Men 1.Eintrag "30 Pix"
	move.w	d1,Modeid(a5)

	moveq	#0,d0
	cmp.w	#30,d1
	beq.s	.setmod
	moveq	#1,d0
	cmp.w	#100,d1
	beq.s	.setmod
	moveq	#2,d0
	cmp.w	#200,d1
	beq.s	.setmod
	moveq	#3,d0
.setmod
	ror.w	#4,d0
	lea	begin(pc),a2
	move.w	eus_winx(a2),d1
	and.w	#$fff,d1
	or.w	d0,d1
	move.w	d1,eus_winx(a2)
	bra	.next
.nomodeit1
	cmp.w	#32,d0
	bne.s	.nomode2
	move.w	#100,d1			;1. Men 2. Eintrag "100 Pix"
	bra.s	.mode
.nomode2
	cmp.w	#64,d0
	bne.s	.nomode3
	move.w	#200,d1			;1. Men 3. Eintrag "200 Pix"
	bra.s	.mode
.nomode3
	cmp.w	#96,d0
	bne.s	.nomode4
	move.w	#300,d1			;1. Men 4. Eintrag "200 Pix"
	bra.s	.mode
.nomode4
	cmp.w	#128,d0			;1. Men 4. Eintrag "Inverted"
	bne.s	.noin

	moveq	#0,d1
	move.w	mi_flags(a1),d0
	and.w	#checked,d0
	beq.s	.nome
	moveq	#1,d1
.nome
	move.b	d1,invertid(a5)

	move.w	begin+eus_winy,d0
	rol.w	#4,d0			;nun Werte von 0-15 in D0
	and.b	#~1,d0
	tst.b	d1
	beq.s	.clrin
	or.b	#1,d0
.clrin
	ror.w	#4,d0
	move.w	d0,begin+eus_winy

	move.l	a1,-(sp)
	bsr	clear
	bsr	intowindow
	move.l	(sp)+,a1

	bra	.next
.noin
	cmp.w	#160,d0			;5. Item (Bright Mode)
	bne.s	.nobri

	moveq	#0,d1
	move.w	mi_flags(a1),d0
	and.w	#checked,d0
	beq.s	.nome2
	moveq	#1,d1
.nome2
	move.b	d1,brightid(a5)
	move.w	begin+eus_winy,d0
	rol.w	#4,d0			;nun Werte von 0-15 in D0
	and.b	#~2,d0
	tst.b	d1
	beq.s	.clrbri
	or.b	#2,d0
.clrbri
	ror.w	#4,d0
	move.w	d0,begin+eus_winy

	addq.b	#1,d1
	move.b	#2,my_bitmap+bm_depth(a5)

	move.b	invertid(A5),d2
	clr.b	invertid(A5)
	clr.w	wait(A5)
	movem.l	d0-a6,-(sp)
	bsr	clear
	bsr	intowindow
	movem.l	(sp)+,d0-a6

	move.b	d1,my_bitmap+bm_depth(a5)
	move.b	d2,invertid(A5)
	movem.l	d0-a6,-(sp)
	bsr	clear
	bsr	intowindow
	movem.l	(sp)+,d0-a6
	bra	.next
.nobri
	cmp.w	#192,d0
	bne.s	.noslo

	moveq	#0,d1
	move.w	mi_flags(a1),d0
	and.w	#checked,d0
	beq.s	.nome3
	moveq	#1,d1
.nome3
	move.w	d1,slowid(a5)

	move.w	begin+eus_winy,d0
	rol.w	#4,d0			;nun Werte von 0-15 in D0
	and.b	#~4,d0
	tst.w	d1
	beq.s	.clrslo
	or.b	#4,d0
.clrslo
	ror.w	#4,d0
	move.w	d0,begin+eus_winy
	bra	.next
.noslo
	cmp.w	#256,d0		;6. Item ? (Hide)
	beq.w	.closewinny
	cmp.w	#288,d0		;7. Item (Quit)
	beq.s	.endme

	lea	Aboutmessage(pc),a0
	bsr	Merror
	bra	.next
.nomenu
	bra	.ma2
.endme
	moveq	#0,d7
	RTS
.exit	moveq	#-1,d7
	rts
******************************************************************************
*                       Ausgabe von Error-Messages                           *
*                 Input: a0 -> Zeiger auf Ausgabestring                      *
******************************************************************************
MERROR:
	movem.l	d0/a2-a3,-(sp)
	suba.l	a3,a3			;*Arguments
	lea	my_easygadget(pc),a2
	bsr	Errorout
	movem.l	(sp)+,d0/a2-a3
	rts
Errorout
	movem.l	d1-a6,-(sp)
	move.l	Intsave(a5),a6
	lea	my_easystruct(a5),a1

	move.l	a0,es_textformat(a1)

	move.l	a2,es_gadgetformat(a1)

	lea	my_easytitle(pc),a0
	move.l	a0,es_Title(a1)
	move.l	winhandle(a5),a0	;*Window
	suba.l	a2,a2			;*IDCMP_ptr
	jsr	_LVOeasyrequestargs(a6)			;!! durch Reqtools
							;ersetzen
	movem.l	(sp)+,d1-a6	
	rts
;*****************************************************************************
;*                        Daten und Initialisierungen                        *
;*****************************************************************************

int:	dc.b	`intuition.library`,0
gad:	dc.b	`gadtools.library`,0
graf:	dc.b	`graphics.library`,0
dos:	dc.b	`dos.library`,0

portname:	dc.b	`EAGLEPLAYERPORT`,0
Project0STitle: dc.b	'Spacescope (Eagleplayer),  DEFECT Softworks',0
	even

MyWinName:	dc.b	`Space-Scope+`,0
my_easygadget:	dc.b	`   OK   `,0
my_easytitle:	dc.b	`Space-Scope+ Message`,0
my_easygadget2:	dc.b	` Retry | Cancel `,0
MyAnalyzername:	dc.b	`ESpace-Scope+.1`,0
MyUsername:	dc.b	`Space-Scope+`,0

Aboutmessage:	dc.b	`     EaglePlayer Space-Scope+ `
		ver
		dc.b	$0a
		dc.b	` 1993 Henryk "BUGGS" Richter, Freeware`,$0a,$0a
		dc.b	`After an Idea of seen in an ATARI ST Tracker and`,10
		dc.b	`in the new Protrackerclone "QUADRACOMPOSER 2.x"`,10
		dc.b	"   Please don`t try it with Chiptunes !",10,10
		dc.b	`In Slow Mode only 50%% of the normally used `,10
		dc.b	`        CPU Time is needed !`,10,10
		dc.b	`FOR NON PROFIT DISTRIBUTION ONLY,CONSULT`,$0a
		dc.b	`AUTHORS FOR PERMISSION TO SELL THIS PIECE !`,0
NoportMessage:	dc.b	`Cannot find EaglePlayer Port`,0

Confile:	dc.b	`CON:10/10/250/40/Space-Scope+`,0
Conout:	dc.b	`Needs Amiga OS2.04 or higher to run`,0
Conlen = *-Conout
Mylabel1:	dc.b	`Project`,0
Mylabel2:	dc.b	`About`,0
Mylabel21:	dc.b	`A`,0
MyLabel3:	dc.b	`Quit`,0
MyLabel31:	dc.b	`Q`,0
MyLabel4:	dc.b	`Hide`,0
MyLabel41:	dc.b	`H`,0
mycheck1	dc.b	`30  Pix *4`,0
mycheck2	dc.b	`100 Pix *4`,0
mycheck3	dc.b	`200 Pix *4`,0
mycheck3.1	dc.b	`300 Pix *2`,0
mycheck4	dc.b	`Inverted`,0
mycheck5	dc.b	`Bright Mode`,0
mycheck6	dc.b	`Slow Mode`,0
mybuggsname	dc.b	`Buggs of DEFECT`,0
myinfo	dc.b	`Nice Sampleviewer`,0

	even
vol64	dc.w	64,64,64,64

patt1	dc.w	%1010101010101010
	dc.w	%0101010101010101
patt2	dc.w	0,0
;*********** Leertabellen (spter im BSS-Hunk) ***********************
		section	1,BSS
datas:
pixelZ		rs.w	1
memsize		rs.l	1
intsave:	rs.l	1
gadsave:	rs.l	1
grafsave:	rs.l	1
_dos		rs.l	1
WinHandle:	rs.l	1
offx:		rs.w	1
offy:		rs.w	1
Port:		rs.l	1
MSGPort:	rs.l	1
Handle:		rs.l	1
Menuadr:	rs.l	1
Mysignal	rs.l	1
Mytask		rs.l	1
mypubscreen:	rs.l	1	;aktueller Publicscreen
fonth:		rs.l	1	;Fonthhe
fontatt:	rs.l	1	;Fontattr Strukturadresse (entweder die des
				;Screens oder die eigene,wenn Screenfont zu
				;gro)
vi:		rs.l	1	;Visualinfo

mytags:		rs.l	20*2
myzoom:		rs.w	3
myhoehe2:	rs.w	1
myhoehe1:	rs.w	1
winwidth:	rs.w	1

MY_Easystruct:	rs.l	1	;EASY-Request
		rs.l	1
		rs.l	1
		rs.l	1
		rs.l	1
MY_Bitmap:	rs.b	8
		rs.l	8
lastrow:	rs.l	1
lastrow2:	rs.l	1
Mymenus:	rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.l	1
Nulls:		rs.b	an_num*4

Nulls2:		rs.l	7		;nicht trennen !!
Nulls3:		rs.l	7
Nulls4:		rs.l	7

Permerk:	rs.l	4		;4 Kanle,je 2 Wrter
SaveCommand	rs.l	1
SaveResult	rs.l	1
Savestring	rs.l	1
flagsadr	rs.l	1
invertid	rs.b	1
brightid	rs.b	1

AN_Structadr:	rs.l	1
;AN_Struct:	rs.b	UPS_sizeof
		rs.b	2
Modeid		rs.w	1	;Frei
Voicesmerk	rs.w	1
MC68020on	rs.w	1

slowid		rs.w	1
wait		rs.w	1
word8		rs.w	1	;Wort fr Absturz bei Modifikation
counter		rs.w	1
immernull	rs.l	1

		rs.w	32
HoriTAB		rs.w	512	;Tabelle fr horizontale Werte
		rs.w	32
Mulutab		rs.b	512	;Tabelle fr Multiplikation mit
				;Breite der Bitplane
		rs.w	32

MsgPort1:	rs.b	mp_size	;extra Messageport

	ifne	debug
saveusernr	rs.w	1
	endc

DatasLen:	rs.w	0
		ds.b	DatasLen
	end
