*****************************************************************************
**                                                                         **
** Noiseconverter: Magnetic Fields                                         **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 


*-----------------------------------------------------------------------------*
*			Noiseconverter V1.0				      *
*			  MagneticFields				      *
*-----------------------------------------------------------------------------*
Test	= 0
			incdir	include:
			include	misc/eagleplayer.i
			include	misc/eagleplayerconverter.i
			include	exec/exec_lib.i

	if	Test
haha	lea	data,a0
	move.l	#datasize,d0
	bsr	Convert
	beq.s	.error
	move.l	a0,a1
	move.l	d2,d1
	move.l	4,a6
	jsr	_LVOFreeMem(a6)
.error:	illegal
	endc


	CONVERTERHEADER	TAGS

	dc.b	"Noiseconverter-MagneticFields V1.0",10
	dc.b	"done by Eagleeye/DFT 28.02.97",0
	even

Tags:		dc.l	CV_Convertername,Convertername
		dc.l	CV_Convert,Convert
		dc.l	CV_RequestConverter,1
		dc.l	CV_Version,1<<16!0
		dc.l	CV_Creator,Creator
		dc.l	CV_EagleBase,EagleBase
		dc.l	0


EagleBase:	dc.l	0
Creator:	dc.b	"???, adapted by DEFECT",0
Convertername:	dc.b	"Magnetic Fields",0
Smpl.MSG:	dc.b	"SMP.",0
Mdat.MSG:	dc.b	"MFP.",0
		even

*-----------------------------------------------------------------------------*
* Input: a0=Adr der Datei
*	 d0=Size der Datei
* Output:d0=ConvertSize oder NULL
*	 d1=Flags
*	 d2=Memsize or NULL
*	 a0=ConvertAdr
*	 a1=Formatname
*	 a2=SamplePtr (fr Protrackerclones) oder NULL
Convert:	move.l	a0,a3
		move.l	d0,d3
		bsr	Check
		bne.w	.Error

		*-- Speicher allokieren --*
		move.l	d3,d0
		move.l	d3,d5
		bsr	AllocMem
		move.l	d0,a4
		beq.w	.Error

		*-- Samplefile laden --*
		ifeq	Test
		bsr	LadeSampleFile
		else
		move.l	#sample,a0
		move.l	#samplesize,d0
		endc
	*	move.l	d0,a2
		tst.l	d0
		beq.w	.SampleError
	*	beq.w	.NoSampleError
		move.l	a0,a2
.NoSampleError:

		*--- Kopf zusammensetzen ---*
		lea	20(a4),a0
		moveq	#30,d0
		move.l	a3,a1
.NextSample:	moveq	#0,d1
		move.w	0(a1),22(a0)
		move.w	2(a1),24(a0)
		move.w	4(a1),26(a0)
		move.w	6(a1),28(a0)
		lea	8(a1),a1
		lea	30(a0),a0
		dbf	d0,.NextSample
		move.l	#"M.K.",$438(a4)
		lea	950(a4),a1
		lea	$f8(a3),a0
		moveq	#$7f,d0
.CopyIt:	move.b	(a0)+,(a1)+
		dbf	d0,.CopyIt

		*--- Samples rankopieren ---*
		move.l	a4,a0
		add.l	#1084,a0
		move.l	d2,d1
		mulu	#1024,d1
		add.l	d1,a0			;Memsize
		cmp.l	#0,a2
		beq.s	.NoSamples
.CopySamples:	move.b	(a2)+,(a0)+
		subq.l	#1,d4
		bne.s	.CopySamples
.NoSamples:
		*--- Pattern dekodieren ---*
		moveq	#0,d4
		move.b	$f8(a3),d4
		subq.l	#1,d4
		lea	$fa(a3),a6
		moveq	#0,d3
.NextPos:	moveq	#0,d0
		move.b	(a6)+,d0
		lea	1084(a4),a1
		mulu	#1024,d0
		lea	(a1,d0.w),a1

		moveq	#0,d2
		bsr	DekodePattern
		moveq	#2,d2
		bsr	DekodePattern
		moveq	#4,d2
		bsr	DekodePattern
		moveq	#6,d2
		bsr	DekodePattern
		addq.l	#8,d3

*		moveq	#0,d1
*		move.b	$f8(a3),d1
*		asl.l	#3,d1
*		cmp.w	d1,d3
*		bcs.s	.lbC0003CA
*		moveq	#0,d3			;Pattern existiert im gepackten
						;File nicht
.lbC0003CA:	dbf	d4,.NextPos
		moveq	#0,d0
		move.l	d5,d0
		move.l	d5,d2
		add.l	#SecurityMem,d2
		move.l	#CVF_FreeOriginal,d1
		move.l	a4,a0
		lea	Convertername(pc),a1
		sub.l	a2,a2
		tst.l	d0
		rts

	*--- Error ist aufgetreten ---*
.SampleError:	move.l	a4,a1			;Speicher wieder freigeben
		move.l	d3,d0
		move.l	4,a6
		jsr	_LVOFreeMem(a6)
.Error:		moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
* Input: d0=Memsize
* Output:d0=Memadr oder NULL
*-----------------------------------------------------------------------------*
AllocMem:	movem.l	d1-a6,-(a7)
		add.l	#SecurityMem,d0		;important !!!
		move.l	EagleBase(pc),a4
	ifeq	Test
		move.l	#$10002,d1		;Chip
		move.l	EPG_SomePrefs(a4),d2
		btst	#EGPRF_LoadFast,d2
		beq.s	.MemtypeOk
	endc
		move.l	#$10001,d1		;Fast
.MemtypeOK:	move.l	4,a6
		jsr	_LVOAllocMem(a6)
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
DekodePattern:	movem.l	d0/d1/d2/d3/a0/a1,-(a7)

		move.w	$17A(A3),D0
		asl.w	#3,D0
		lea	$17E(A3),A0
	*	move.l	A0,Patternstart
		add.w	d2,d3
		move.w	0(A0,D3.W),D1
		adda.w	D0,A0
		adda.w	D1,A0

		moveq	#63,d3
		add.w	d2,d2
		moveq	#-$10,d1
.CopyPattern:	add.l	#$10,d1
		bsr	GetPTNote
		move.l	d0,(a1,d2.w)
		lea	16(a1),a1
		dbf	d3,.CopyPattern
		movem.l	(a7)+,d0/d1/d2/d3/a0/a1
		rts


*-----------------------------------------------------------------------------*
GetPTNote:	movem.l	D1/D2,-(SP)
		lsr.w	#4,D1
		move.w	D1,D2
		lsr.w	#4,D2
		andi.w	#3,D2
		move.b	0(A0,D2.W),D0
		move.w	D1,D2
		lsr.w	#2,D2
		andi.w	#3,D2
		add.b	D0,D2
		move.b	0(A0,D2.W),D0
		move.w	D1,D2
		andi.w	#3,D2
		add.b	D0,D2
		moveq	#0,D0
		move.b	0(A0,D2.W),D0
		add.w	D0,D0
		move.l	0(A0,D0.W),D0
		movem.l	(SP)+,D1/D2
		rts

*-----------------------------------------------------------------------------*
* Input: --
* Output:d0=Filesize der Samples
*	 a0=Adr der Samples
*-----------------------------------------------------------------------------*
LadeSampleFile:	movem.l	d1-d7/a1-a6,-(a7)
		move.l	EagleBase(pc),a4
		moveq	#0,d7
		move.l	dtg_PathArrayPtr(A4),A0
		clr.b	(A0)
		move.l	dtg_CopyDir(A4),A0
		jsr	(A0)
		bsr.s	ErsetzePrefix
		move.l	#$10000,EPG_Arg1(a4)	;ist egal, wird eh kopiert
		move.l	#1,EPG_ArgN(a4)
		jsr	ENPP_NewLoadFile(a4)
		tst.l	d0
		bne.s	.NoFile
		moveq	#1,d0
		jsr	ENPP_GetLoadListData(a4)
		move.l	d0,d7
.NoFile:	move.l	d7,d0
		movem.l	(a7)+,d1-d7/a1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
ErsetzePrefix:	move.l	dtg_PathArrayPtr(a4),a0
.FindPathEnd:	tst.b	(a0)+
		bne.s	.FindPathEnd
		subq.l	#1,a0
		lea	smpl.MSG(pc),a1
.CopyPrefix:	move.b	(a1)+,(a0)+
		bne.s	.CopyPrefix
		subq.l	#1,a0
		move.l	dtg_FileArrayPtr(a4),a1
		lea	mdat.MSG(pc),a2

.CopyRestOfFilename:
		move.b	(a2)+,D0
		beq.s	.CopyIt
		move.b	(a1)+,D1
		cmp.b	#"a",d1
		blo.s	.BitOk
		cmp.b	#"z",d1
		bhi.s	.BitOk
		bclr	#5,D1
.BitOk:		cmp.b	D0,D1
		beq.s	.CopyRestOfFileName
		movea.l	dtg_FileArrayPtr(A4),A1
.CopyIt:	move.b	(a1)+,(a0)+
		bne.s	.CopyIt
		rts



*-----------------------------------------------------------------------------*
* Output: d0=Error oder NULL
*	  d2=Patternanz
*	  d3=Memsize fr Protracker
*	  d4=Samplesize
Check:		moveq	#30,d0
		move.l	a0,a1
		moveq	#0,d3
.NextSample:	moveq	#0,d1
		move.w	(a1),d1
		beq.s	.LeeresSample
		add.l	d1,d3
		add.l	d1,d3
		cmp.b	#64,3(a1)
		bhi.s	.Error
		cmp.w	6(a1),d1
		blo.s	.Error
		bra.s	.SampleOk
.LeeresSample:	tst.l	2(a1)
		bne.s	.Error
		cmp.w	#1,6(a1)
		bhi.s	.Error
.SampleOk:	lea	8(a1),a1
		dbf	d0,.NextSample

		move.l	d3,d4
		moveq	#0,d0
		move.b	(a1)+,d0		;Length
		cmp.b	#$7F,(a1)		;Restart
		bne.b	.Error

		lea	$fa(a0),a1
		moveq	#0,d2
		moveq	#$80-1,d0
.NextPattern:	move.b	(a1)+,d1
		blt.s	.Error
		cmp.b	d1,d2
		bgt.s	.D2Groesser
		move.b	d1,d2
.D2Groesser:	dbf	d0,.NextPattern

		addq.l	#1,d2
		move.l	d2,d1
		mulu	#1024,d1
		add.l	d1,d3			;Memsize
		add.l	#1084,d3

		*-- Kennung --*
		move.b	$F8(A0),D1
		move.b	$17B(A0),D0
		cmp.b	D1,D0
		bne.b	.Error
		move.b	$17D(A0),D0
		cmp.b	D1,D0
		bne.b	.Error

		moveq	#0,d0
		rts

.Error:		moveq	#EPR_UnknownFormat,d0
		rts


	if	Test
data:		incdir	"Modules:Trackerclones/Magnetic_Fields/"

		*incbin	MFP.03                        
		incbin	mfp.0c                        
		*incbin	MFP.10                        
		*incbin	MFP.11                        
		*incbin	MFP.12                        
		*incbin	MFP.13                        
		*incbin	MFP.14                        
		*incbin	MFP.15                        
		*incbin	MFP.16                        
		*incbin	MFP.17                        
		*incbin	MFP.18                        
		*incbin	MFP.19                        
		*incbin	MFP.1a                        
		*incbin	MFP.1b                        
		*incbin	MFP.1c                        
		*incbin	MFP.1d                        
		*incbin	MFP.1e                        
		*incbin	MFP.501                       
		*incbin	mfp.503                       
		*incbin	mfp.505                       
		*incbin	MFP.507                       
		*incbin	mfp.5e0                       
		*incbin	MFP.70                        
		*incbin	MFP.71                        
		*incbin	MFP.72                        
		*incbin	MFP.74                        
		*incbin	MFP.78                        
		*incbin	MFP.79                        
		*incbin	MFP.7b                        
		*incbin	MFP.7c                        
		*incbin	MFP.7d                        
		*incbin	MFP.7e                        
		*incbin	MFP.7f                        
		*incbin	MFP.KidChaos Title            
		*incbin	MFP.SoWhat                    
datasize	= *-data

mod		incbin	"Mod.sowhat"
		blk.b	256,$ff
sample:
		*incbin	Smp.03                        
		incbin	smp.0c                        
		*incbin	SMP.10                        
		*incbin	SMP.11                        
		*incbin	SMP.12                        
		*incbin	SMP.13                        
		*incbin	SMP.14                        
		*incbin	Smp.501                       
		*incbin	smp.503                       
		*incbin	smp.505                       
		*incbin	Smp.507                       
		*incbin	smp.5e0                       
		*incbin	SMP.60                        
		*incbin	Smp.78                        
		*incbin	SMP.79                        
		*incbin	SMP.KidChaos Title            
		*incbin	SMP.SoWhat                    

samplesize	= *-sample

neumem:		ds.b	203652
neumemb:
		blk.b	256,$ff
	endc

