*****************************************************************************
**                                                                         **
** Engine: Moduleinfo                                                      **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 


*---------------------------------------------------------------------------*
*				Moduleinfo V2.0x			    *
*---------------------------------------------------------------------------*
Executable	= 0
Test		= 1
Debugger	= 1
BackPicture	= 1

ver		macro
		dc.b	"2.06"
		endm
StructVer	macro
		dc.w	2,06
		endm
date		macro
		dc.b	"05-Jul-98"
		endm
StructDate	macro
		dc.b	05,07
		dc.w	1998
		endm

	incdir	include:
	include	exec/exec_lib.i
	include	dos/dos_lib.i
	include	dos/dos.i
	include	dos/exall.i
	include	exec/libraries.i
	include	exec/interrupts.i
	include	exec/lists.i
	include	libraries/diskfont_lib.i
	include	intuition/intuition.i
	include	intuition/intuition_LIB.i
	include	graphics/graphics_lib.i
	include	misc/BuggsMacros.i
	include	misc/Eagleplayer.i
	include	misc/EagleplayerEngine.i
	include	misc/EagleplayerSampleSaver.i
	include	libraries/asl_lib.i
	include	libraries/asl.i
	include	libraries/gadtools.i
	include	libraries/gadtools_lib.i
	include	libraries/locale_lib.i

	include "intuition/icclass.i"
	include "intuition/classes.i"
        include "intuition/classusr.i"
        include "intuition/imageclass.i"
	include	libraries/utility_lib.i

	include	libraries/datatypes_lib.i
	include	datatypes/datatypes.i
	include	datatypes/pictureclass.i

	include	libraries/reqtools.i
	include	libraries/reqtools_lib.i

*	include	libraries/asl_lib.i
	include	libraries/asl.i

;===========================================================================
;		Definitionen & Vereinbarungen 
;===========================================================================
Defheight		= 600 ;220	;def. Innerheight
Defwidth		= 370	;def. Innerwidth
ZoomWidth		= 180
StringGadgetOffset	= 8		* Zur Fonthhe fr Stringgadgetheight
GadgetAnz		= 8
TitlePufferSize		= MaxDirectoryNamesize
PathPufferSize		= MaxDirectorynamesize
Ticks			= 50


SampleBytePufferSize	= 100
FrequencePufferSize	= 10
FileNamePufferSize	= 40
PositionPufferSize	= 16
LengthPufferSize	= 16
TimePufferSize		= 32
TextPufferSize		= MaxDirectorynamesize

MinFreq			= 1000
MaxFreq			= 58000
FreqStep		= 10

BevelHohe		= 1
BevelBreite		= 2
MinListViewWidth	= 40		*Min Width der Listviews
ListviewBorder		= 4		*Hhe des ListviewRandes (oben+unten)
MinGadgetWidth		= 15		*Min. Breite von Gadgets
MinTextGadgetXOffset	= 3		*Abstand des Textes im Gadget vom
					*Bevelrand
MinTextGadgetYOffset	= 4		*Abstand des Textes im Gadget vom
					*Bevelrand
GadgetXAbstand		= 3		*Abstand der Gadgets untereinander
					*sowie vom linken Rand
GadgetYAbstand		= 3		*Abstand der Gadgets untereinander
					*sowie vom oberen & unteren Rand
AboveAbstand		= 7		*Abstand, wenn Text berm ListView
*MinWinWidth		= 50
*MinWinHeight		= 40


		rsreset
			rs.b	1
EPENr_FirstNummer	rs.b	0
EPENr_Length		rs.b	1
EPENr_Position		rs.b	1
EPENr_Time		rs.b	1
EPENr_Name		rs.b	1
EPENr_Infolist		rs.b	1
EPENr_Slider		rs.b	1
EPENr_SaveSample	rs.b	1
EPENr_TextGadget	rs.b	1

EPENr_About		rs.b	1
EPENr_Quit		rs.b	1
EPENr_Hide		rs.b	1
EPENr_SelectBackPic	rs.b	1
EPENr_BackPic		rs.b	1
EPENr_ViewUp		rs.b	1	*Selectbalken im Listview setzen
EPENr_ViewDown		rs.b	1
EPENr_ViewPageUp	rs.b	1
EPENr_ViewPageDown	rs.b	1
EPENr_ViewTop		rs.b	1
EPENr_ViewBotom		rs.b	1
EPENr_ViewLeft		rs.b	1	*Selectbalken im Listview setzen
EPENr_ViewRight		rs.b	1
EPENr_ViewPageLeft	rs.b	1
EPENr_ViewPageRight	rs.b	1
EPENr_ViewLeftMarge	rs.b	1
EPENr_ViewRightMarge	rs.b	1
EPENr_Play		rs.b	1
EPENr_LoadConfig	rs.b	1
EPENr_SaveConfig	rs.b	1
EPENr_Vorwaerts		rs.b	1
EPENr_Rueckwaerts	rs.b	1
EPENr_ModuleCont	rs.b	1
EPENr_Stop		rs.b	1
EPENr_ChooseFont	rs.b	1
EPENr_SampleSaverOn	rs.b	1
EPENr_LastNr		rs.b	0


			rsreset
			rs.b	1
LENr_WindowTitle	rs.b	1
LENr_Project		rs.b	1
LENr_Settings		rs.b	1
LENr_About		rs.b	1
LENr_Hide		rs.b	1
LENr_Quit		rs.b	1
LENr_BackPic		rs.b	1
LENr_SelectBackPic	rs.b	1
LENr_SaveConfig		rs.b	1
LENr_AboutText		rs.b	1
LENr_Ok			rs.b	1
LENr_RequestTitle	rs.b	1
LENr_EPNotFound		rs.b	1
LENr_Frequence		rs.b	1
LENr_ModuleCont		rs.b	1
LENr_ModuleContKey	rs.b	1
LENr_Play		rs.b	1
LENr_PlayKey		rs.b	1
LENr_Stop		rs.b	1
LENr_StopKey		rs.b	1
LENr_SaveSample		rs.b	1
LENr_SaveSampleMenu	rs.b	1
LENr_SaveSampleKey	rs.b	1
LENr_Vorwaerts		rs.b	1
LENr_VorwaertsKey	rs.b	1
LENr_Rueckwaerts	rs.b	1
LENr_RueckwaertsKey	rs.b	1
LENr_Position		rs.b	1
LENr_Size		rs.b	1
LENr_Name		rs.b	1
LENr_Time		rs.b	1
LENr_Soundsystem	rs.b	1
LENr_Ja			rs.b	1
LENr_Nein		rs.b	1
LENr_Min		rs.b	1
LENr_Sec		rs.b	1

LENr_Songname		rs.b	1
LENr_Author		rs.b	1
LENr_Duration		rs.b	1
LENr_Loadsize		rs.b	1
LENr_Calcsize		rs.b	1
LENr_Songsize		rs.b	1
LENr_SamplesSize	rs.b	1
LENr_Chipsize		rs.b	1
LENr_Othersize		rs.b	1
LENr_SamplesAnz		rs.b	1
LENr_MaxSamples		rs.b	1
LENr_SynthSamples	rs.b	1
LENr_MaxSynthsamples	rs.b	1
LENr_Length		rs.b	1
LENr_MaxLength		rs.b	1
LENr_Patterns		rs.b	1
LENr_MaxPatterns	rs.b	1
LENr_UnpackedInfo	rs.b	1
LENr_Unpackedsystem	rs.b	1
LENr_UnpackFilesize	rs.b	1
LENr_Subsongs		rs.b	1
LENr_MaxSubSong		rs.b	1
LENr_Voices		rs.b	1
LENr_MaxVoices		rs.b	1
LENr_Steps		rs.b	1
LENr_Maxsteps		rs.b	1
LENr_Prefix		rs.b	1
LENr_AboutReplayer	rs.b	1
LENr_ExtraInfo		rs.b	1
LENr_Specialinfo	rs.b	1
LENr_Frequenz		rs.b	1
LENr_Boost		rs.b	1
LENr_Mode		rs.b	1

LENr_OldSoundtracker	rs.b	1
LENr_Soundtracker	rs.b	1
LENr_Noisetracker	rs.b	1
LENr_ProTracker		rs.b	1
LENr_Instrumentenliste	rs.b	1
LENr_Bytes		rs.b	1
LENr_KeinSample		rs.b	1
LENr_UnknownSize	rs.b	1

LENr_ChooseFont		rs.b	1
LENr_SamplesaverOn	rs.b	1

LENr_Album		rs.b	1
LENr_Year		rs.b	1
LENr_Comment		rs.b	1
LENr_Genre		rs.b	1
LENr_Bitrate		rs.b	1

LENr_LastExternal	rs.b	0


		rsreset
GadgetMerkPuffer	rs.l	GadgetAnz+2
MyTags			rs.l	20*2
LocalePuffer		rs.w	LENr_LastExternal
TitlePuffer		rs.b	TitlePufferSize
FrequencePuffer		rs.b	FrequencePufferSize
FileNamePuffer		rs.b	FileNamePufferSize
PositionPuffer		rs.b	PositionPufferSize
LengthPuffer		rs.b	LengthPufferSize
TimePuffer		rs.b	TimePufferSize
TextPuffer		rs.b	TextPufferSize
SamplebytePuffer	rs.b	SampleBytePufferSize


TextRequestArgs		rs.l	3
BufNewGad		rs.b	gng_sizeof	*Buffer fr Gadgetcreieren
MyFont			rs.l	2
MY_Easystruct		rs.l	5	;EASY-Request
Infolist		rs.b	lh_size
CurrentSeconds		rs.l	1
CurrentMicros		rs.l	1
StartSeconds		rs.l	1
StartMicros		rs.l	1
MyTaskAdr		rs.l	1
GadgetListadr		rs.l	1
MenuAdr			rs.l	1
VisualInfo		rs.l	1
MyPubScreen		rs.l	1
WinHandle		rs.l	1
WindowPort		rs.l	1
MyRastPort		rs.l	1
OldMenuAdr		rs.l	1
MyCatalog		rs.l	1
SelectedEntry		rs.l	1
AndererPort		rs.l	1
*ENA_Args1		rs.b	ENA_String+34
*ENA_Args2		rs.b	ENA_String+34
MerkUserNr		rs.w	1
MsgUnterwegs		rs.l	1
ExitNow			rs.w	1
Qualifier		rs.w	1
MaxEntries		rs.l	1
MsgPort			rs.l	1
UPrg_Struct		rs.l	1
Signal			rs.l	1
SignalBits		rs.l	1
OldDirLock		rs.l	1
Font			rs.l	1
FontX			rs.w	1
FontY			rs.w	1
OffX			rs.w	1
OffY			rs.w	1
WinPosX			rs.w	1
WinPosY			rs.w	1
WinHeight		rs.w	1
WinWidth		rs.w	1
LastWidth		rs.w	1		;Opaque-Sizing Workaround
LastHeight		rs.w	1
ZoomPosX		rs.w	1
ZoomPosY		rs.w	1
InfoWidth		rs.w	1
InfoWidth2		rs.w	1
IntBase			rs.l	1
GFXBase			rs.l	1
DosBase			rs.l	1
GadBase			rs.l	1
LocaleBase		rs.l	1
MyReqToolsBase		rs.l	1
MyASLBase		rs.l	1
MyDiskfontBase		rs.l	1
RealNumGadgets		rs.l	1
WindowDisabled		rs.w	1
Kick3On			rs.w	1
NoWait			rs.w	1
LastPos			rs.l	1
LastTime		rs.l	1
KillAll			rs.w	1
Zahler			rs.w	1
Samplewidth		rs.w	1
SampleBytesWidth	rs.w	1
MyTextAttr		rs.b	ta_sizeof+4*2	;TextAttr fr Openfont calls + Text extent space 
MyFontAdr		rs.l	1		;allozierter Font

			*-- BackPic --*
;----------------------- Daten fr Datatypes-Bild ----------------------------------------
DatatypesBase		rs.l	1
DT_PicObject		rs.l	1
DT_MyBitMapheader	rs.l	1
DT_MyBitMap		rs.l	1
DT_Breit2:		rs.l	1
DT_Hoehe2:		rs.l	1
DT_XPos2:		rs.l	1
DT_YPos2:		rs.l	1
Mycmap			rs.l	1
MyPen			rs.l	1
DT_Picture		rs.b	300

ConfigDatas		rs.b	0			\  wird als eigene
DT_Picturedir		rs.b	200			 \ Prefs abgespeichert
DT_Picturename		rs.b	108			 /
Dirpuffer		rs.b	200
Filepuffer		rs.b	108		       /
PlayFrequence		rs.l	1
MyFontName		rs.b	108
MyFontSize		rs.w	1
ConfigDatasEND		rs.b	0			/


ZoomState		rs.b	1
ListeDa			rs.b	1

PufferEnd		rs.b	0


NextMenu	EQU	1
NextItem	EQU	1<<5
NextSubItem	EQU	1<<11
NoSubMenu	EQU	$f800
SubMenu		EQU	$800

			rsreset
Menu1			rs.b	1
Menu2			rs.b	1

			rsreset
			rs.b	Menu1!NoSubMenu
MNr_Play		rs.b	NextItem
MNr_Stop		rs.b	NextItem
MNr_SaveSample		rs.b	NextItem
MNr_Modulecont		rs.b	NextItem
			rs.b	NextItem		;Barlabel
MNr_About		rs.b	NextItem
MNr_Hide		rs.b	NextItem
			rs.b	NextItem		;Barlabel
MNr_Quit		rs.b	NextItem

			rsreset
			rs.b	Menu2!NoSubMenu
MNr_Time		rs.b	NextItem
MNr_SampleSaverOn	rs.b	NextItem
MNr_BackPic		rs.b	NextItem
MNr_SelectBackPic	rs.b	NextItem
MNr_ChooseFont		rs.b	NextItem
			rs.b	NextItem		;Barlabel
MNr_SaveConfig		rs.b	NextItem


			rsreset
			rs.b	MNr_Time-$f800
MNr_Vorwaerts		rs.b	NextSubItem
MNr_Rueckwaerts		rs.b	NextSubItem




	*----------------- Einstellungen der Prefs --------------*
PFB_BackPic		EQU	2
PFB_Rueckwaerts		EQU	3
PFB_Length		EQU	4
PFB_Position		EQU	5
PFB_Time		EQU	6
PFB_Name		EQU	7
PFB_SampleSaverOn	EQU	8

PFF_BackPic		EQU	1<<PFB_BackPic
PFF_Rueckwaerts		EQU	1<<PFB_Rueckwaerts
PFF_Length		EQU	1<<PFB_Length
PFF_Position		EQU	1<<PFB_Position
PFF_Time		EQU	1<<PFB_Time
PFF_Name		EQU	1<<PFB_Name
PFF_SampleSaverOn	EQU	1<<PFB_SampleSaverOn
	

EB	macro
	if	test
	move.l	4,a6
	else
	move.l	4.w,a6
	endc
	ENDM

my_Redrawlist	macro
		dc.l	\1
		dc.w	\2
		ENDM



		STRUCTURE	MY_ListStruct,0
		STRUCT		ML_Node,LN_Size
		ULONG		ML_Size
		APTR		ML_SampleStruct
		LABEL		ML_Chars


;===========================================================================
	section	0,code
;===========================================================================

		if	test
Start
		bra	FirstInit
	illegal

FirstEagleInit:	lea	EaglePuffer,a5
		move.l	a5,EUS_EPBase+EUS_Structure

		lea	MyIntuiname,a1
		EB
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,DTG_Intuitionbase(a5)

		lea	MyGFXname,a1
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,DTG_GFXbase(a5)

		lea	MyGadToolsname,a1
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,DTG_GadToolsbase(a5)

		lea	MyLocalename,a1
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,EPG_Localebase(a5)

		lea	MyDosname,a1
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,DTG_Dosbase(a5)

		move.l	#3*60+4,EPG_CurrentTime(a5)
		move.l	#5*60+30,EPG_Duration(a5)

		lea	Puffer,a5
		rts

MyIntuiname:	dc.b	"intuition.library",0
MyGFXname:	dc.b	"graphics.library",0
MyGadtoolsname:	dc.b	"gadtools.library",0
MyLocalename:	dc.b	"locale.library",0
MyDosname:	dc.b	"dos.library",0
Name1:		dc.b	"Module1",0
Name2:		dc.b	"Module2",0
Name3:		dc.b	"Module3",0

TestList:	dc.b	"MODLIST",10
		dc.b	"Modules:Agnostica",10
		dc.b	"'EP:Test' MP:01=1,02='8-Bit Amplifier',03='Animal'",10
		dc.b	'":Test3"'
TestListSize	= *-Testlist

		even
EaglePuffer	ds.b	EPG_SizeOf

EP_List1	ds.b	LH_Size
EP_Entry1	ds.b	LN_Size
EP_Entry2	ds.b	LN_Size
EP_Entry3	ds.b	LN_Size

		endc
*-----------------------------------------------------------------------------*
*-----				Start Programm				------*
*-----------------------------------------------------------------------------*
EUS_Structure:	bra.w	FirstInit			;EUS_Jump
		EUSN_Identifier				;EUS_Identifier
		dc.l	0				;EUS_Next
		dc.w	0				;EUS_Usernr
EPBase		dc.l	0				;EUS_EPBase
		dc.l	0				;EUS_FreeTable
		dc.l	0				;EUS_TaskAdr = NULL
		dc.l	0				;EUS_UnUsed1
		dc.l	0				;EUS_UnUsed2
		dc.l	0				;EUS_UnUsed3
		dc.l	TagListe			;EUS_Taglist
		dc.w	Ticks				;EUS_Ticks
		dc.w	0				;EUS_TickCounter
		dc.l	EUIB_OnlyPlay!EUIB_OnlyActive	;EUS_TickFlags
		dc.l	USMB_KillModule!USMB_NewModule!USMB_WaitPointer!USMB_Zipwin!USMB_ChangeConfig!USMB_NewPreference
		dc.l	MyProzessName			;EUS_PName
		dc.l	MyCreatorname			;EUS_Creator
		dc.l	MySpecialInfo			;EUS_AboutUPRG
		dc.w	37				;EUS_Kickstart
		dc.l	11				;EUS_EPVersion
		StructVer				;EUS_Version,EUS_Revision
		dc.l	MyProzessName			;EUS_Username
		dc.w	350				;EUS_WinX
		dc.w	$62 14				;EUS_WinY
		dc.w	EUSB_Openwin			;EUS_Flags
EUS_Width	dc.w	DefWidth		;EUS_Special  -> InnerWidth
EUS_Height	dc.w	Defheight		;EUS_Special+2 -> InnerHeigth
		dc.l	0				;EUS_Special2
ZoomX		equ	EUS_Special2
ZoomY		equ	EUS_Special2+2
ZoomONOFF	equ	EUS_Special3
PrefsFlags	equ	EUS_Special3+2
		dc.w	0				;EUS_Special3
		if	Test!Debugger
		dc.w	PFF_BackPic			;PrefsFlags
		else
		dc.w	PFF_SampleSaverOn		;PrefsFlags
		endc

		StructDate				;EUS_Creatordate
		dc.b	0				;EUS_Prioritt
		dc.b	EUTY_Moduleinfo			;EUS_Type
		dc.w	0				;EUS_Reserved2
		dc.l	0				;EUS_Reserved3
		dc.l	0				;EUS_Reserved4
		dc.l	0				;EUS_Reserved5
		dc.l	0				;EUS_Reserved6
		ifne	(*-EUS_Structure)-EUS_SizeOF
		Aber Hallo
		endc

		dc.b	`$VER: Eagleplayer-Moduleinfo V`
		ver
		dc.b	` (`
		date
		dc.b	`)`,0
		even

TagListe:	dc.l	EUT_SpecialinfoLNr,LNrE_SpecialInfo_Moduleinfo
		dc.l	EUT_LocaleTable,EPLocaleTabelle
		dc.l	0

EPLocaleTabelle:dc.w	LNrE_Unknown
		dc.l	Unknown.MSG
LA_Unknown:	dc.l	0
		dc.w	0


*----------------------------------------------------------------------------*
FirstInit:	lea	Puffer,a5		;BSS lschen
		EB
		cmp.w	#37,LIB_Version(a6)	;EXEC V37 ?
		blo	Exit			;nein,raus
		bsr	ClrPuffer

		EB
		cmp.w	#39,Lib_Version(a6)
		blo.s	.NoKick3
		not.w	Kick3On(a5)
.NoKick3:	move.l	EUS_Structure+EUS_EPBase(pc),d0
		beq.w	Exit

		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	DTG_Intuitionbase(a4),Intbase(a5)
		move.l	DTG_GFXBase(a4),GFXBase(a5)
		move.l	EPG_LocaleBase(a4),LocaleBase(a5)
		move.l	DTG_GadtoolsBase(a4),GadBase(a5)
		move.l	DTG_Dosbase(a4),DosBase(a5)
		
		move.l	#-1,mypen(A5)	;Halfshine Farbe fr Gadgets, zur Sicherheit -1 gesetzt

		lea	EUS_Structure(pc),a0

		move.w	EUS_Width-EUS_Structure(a0),d0
		and.w	#$fff,d0			;Workaround fr Problem mit
							;Configs des alten Moduleinfo
		move.w	d0,EUS_Width-EUS_Structure(a0)

		move.b	ZoomOnOff(a0),ZoomState(a5)
		move	Eus_Winx(a0),WinPosX(a5)
		move	Eus_Winy(a0),WinPosY(a5)
		move	ZoomX(a0),ZoomPosX(a5)
		move	ZoomY(a0),ZoomPosY(a5)

		move.l	#22000,PlayFrequence(a5)

;		bsr	InitGadgetFlags
		bsr	InitLists
		bsr	FirstLocaleInit

		sub.l	a1,a1
		EB
		jsr	_LVOFindTask(a6)
		move.l	d0,MyTaskAdr(a5)

		bsr	LoadConfig


	*- Signal fr Interruptansteuerung des Eagleplayers -*
	*------------------ allokieren ----------------------*
		moveq	#0,d6
		moveq	#-1,d0
		jsr	_LVOAllocSignal(a6)	;Signal allokieren
		tst.l	d0
		blt	NoSignal
		move.l	d0,Signal(a5)
		bset	d0,d6
		move.l	d6,SignalBits(a5)


*-------------------------- Mesage an Eagleplayer schicken -----------------*
*---- Input:	;d1 = Enabled(0) oder Disabled(1)			----*
*----		d2 = US_Class						----*
*----		d3 = Command						----*
*----		d4 = ArgList						----*
*----		d5 = Result						----*
	if Executable+Debugger
		if debugger
		move.l	#EUS_Structure,d5
		else
		moveq	#0,d5
		endc
		moveq	#0,d1
		moveq	#USClass_NewUserPrg,d2
		moveq	#0,d3
		moveq	#0,d4
		if	debugger
		move.w	#-2,MerkUserNr(a5)
		endc
		bsr	SendeOneMessage
		tst.l	d0
	else
		bsr.w	OpenWin
	endc
		beq.s	ExitEngine

		moveq	#EPNr_Status2,d3
		move.l	#`MFIL`,d0
		moveq	#0,d1
		bsr	SendMess

	*------------ Hauptprogramm ablaufen lassen ------------*
		tst.l	MaxEntries(a5)
		beq.s	.NoSel
		clr.l	SelectedEntry(a5)
		moveq	#1,d0
		bsr	SetModulesEntry
.NoSel:		bsr.w	Warten



*-----------------------------------------------------------------------------*
ExitEngine:	lea	Puffer,a5

		bsr	WaitUserMessages
		bsr	CloseWin
		bsr	FreeInfoList
		bsr	RemoveMsgPort

		move.l	Signal(a5),d0
		move.l	4,a6
		jsr	_LVOFreeSignal(a6)
		clr.l	Signal(a5)
		
NoSignal:	move.l	DatatypesBase(a5),d0
		beq.s	.nodt
		move.l	d0,a1
		EB
		jsr	_LVOCloselibrary(a6)
		clr.l	DatatypesBase(a5)
.nodt

		move.l	MyReqToolsBase(a5),d0
		beq.s	.noReqTools
		move.l	d0,a1
		EB
		jsr	_LVOCloselibrary(a6)
		clr.l	MyReqToolsBase(a5)
.NoReqTools:

		move.l	MyASLBase(a5),d0
		beq.s	.noASL
		move.l	d0,a1
		EB
		jsr	_LVOCloselibrary(a6)
		clr.l	MyASLBase(a5)
.NoASL:

		move.l	MyDiskFontBase(a5),d0
		beq.s	.noDiskF
		move.l	d0,a1
		EB
		jsr	_LVOCloselibrary(a6)
		clr.l	MyDiskFontBase(a5)
.NoDiskF:

Exit:		moveq	#EPR_ErrorAddUserPrg,d0
		ifeq	Executable
		illegal
		else
		rts
		endc
*-----------------------------------------------------------------------------*
InitLists:	lea	Infolist(a5),a0
		Newlist	a0
		rts
*---------------------- Inserte einen Eintrag in eine Liste ------------------*
* Input: a0=Liste							      *
*	 a1=Neue Node							      *
*	 a2=Node, die davorsteht oder NULL fr erste			      *
*-----------------------------------------------------------------------------*
InsertInList:	movem.l	d0/a0/a3,-(a7)

		*-- Erster Eintrag --*
		move.l	a2,d0
		bne.s	.NoFirst
		ADDHEAD
		bra.s	.Return

		*-- Letzter Eintrag --*
.NoFirst:	cmp.l	LH_TailPred(a0),a2
		bne.s	.NoLast
		ADDTAIL
		bra.s	.Return

.NoLast:	move.l	LN_Succ(a2),d0			;Vorgnger in a2
		beq.s	.Return
		move.l	d0,a3				;Nachfolger in a3

		move.l	a1,LN_Succ(a2)			;Verk. zum Vorgnger
		move.l	a1,LN_Pred(a3)			;Verk. zum Nachfolger

		move.l	a2,LN_Pred(a1)
		move.l	a3,LN_Succ(a1)

.Return:	movem.l	(a7)+,d0/a0/a3
		rts


*-----------------------------------------------------------------------------*
* Input: d0=Tag
*	 d0=Ergebnis
*-----------------------------------------------------------------------------*
FindPlTag:	movem.l	d2/a6,-(a7)
		move.l	EUS_Structure+EUS_EPBase(pc),a6
		move.l	EPG_PlayerTagList(a6),a6
		bsr	FindTag
		move.l	a6,d0
		movem.l	(a7)+,d2/a6
		tst.l	d0
		rts

FindMITag:	movem.l	d2/a6,-(a7)
		move.l	EUS_Structure+EUS_EPBase(pc),a6
		move.l	EPG_ModuleInfoTagList(a6),a6
		bsr	FindTag
		move.l	a6,d0
		movem.l	(a7)+,d2/a6
		tst.l	d0
		rts


FindTag:
FindTag2:	move.l	d3,-(a7)
		move.l	a7,d3

	*--------- Recursive FindTag-Routine ----------*
FindTag3:	moveq	#0,d2
		cmp.l	a6,d2
		beq.s	.Empty
		move.l	(a6)+,d2			;Tag rauslesen
		bne.s	.NoEmpty
.Empty:		cmp.l	d3,a7				;ak. Stack vergleichen
		beq.s	.TagNoFound
		move.l	(a7)+,a6
		bra.b	.NoMore
.NoEmpty:	cmp.l	d2,d0
		beq.s	.TagFound

	*----- Tag-Skip gefunden ???? -----*
		cmp.l	#Tag_Skip,d2
		bne.s	.NoSkip
		addq.l	#8,a6				;Diesen und nchsten
		addq.l	#4,a6				;Tag berspringen
		bra.s	.NoMore

	*------ Tag-More gefunden ???? -----*
.NoSkip:	cmp.l	#Tag_More,d2
		bne.s	.NoMore

		move.l	a6,-(a7)		;Adr der Tagliste sichern
		move.l	(a6),a6			;Neue Tagliste setzen
		bra.b	FindTag3
.NoMore:	addq.l	#4,a6
		bra.s	FindTag3
.TagFound:	move.l	(a6),a6
		move.l	a6,d2
.TagNoFound:	move.l	d3,a7
		move.l	(a7)+,d3
		tst.l	d2
		bne.s	.NoNull
		sub.l	a6,a6
.NoNull:	tst.l	d2
		rts




*-----------------------------------------------------------------------------*
SaveConfig:	movem.l	d1-a6,-(a7)

	ifeq	test
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_ConfigDirArrayPtr(a4),d1
		beq.s	.NoConfigDir
	else
		move.l	#Configdir,d1
	endc
		move.l	Dosbase(a5),a6
		moveq	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.s	.NoConfigDir
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1

.NoConfigDir:	move.l	d1,-(a7)
		lea	ConfigName(pc),a1
		move.l	a1,d1
		move.l	#1006,d2			*Mode_NewFile
		move.l	Dosbase(a5),a6
		jsr	_LVOOpen(a6)
		move.l	(a7)+,d1
		move.l	d0,-(a7)
		tst.l	d1
		beq.s	.NoConfigDir2
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnlock(a6)
.NoConfigDir2:	move.l	(a7)+,d6
		moveq	#EPR_FileNotFound,d0
		tst.l	d6
		beq.w	.Return

	*----------- Nun Config Schritt fr Schritt speichern ---------*
		lea	ConfigDatas(a5),a0
		move.l	#ConfigDatasEnd-ConfigDatas,d3
		move.l	d6,d1
		move.l	a0,d2
		move.l	Dosbase(a5),a6
		jsr	_LVOWrite(a6)

		*--- Datei Closen ---*
		move.l	d6,d1
		beq.s	.AllesOk
		move.l	Dosbase(a5),a6
		jsr	_LVOClose(a6)

.AllesOk:	moveq	#0,d0
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
LoadConfig:	movem.l	d1-a6,-(a7)

	ifeq	test
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_ConfigDirArrayPtr(a4),d1
		beq.s	.NoConfigDir
	else
		move.l	#Configdir,d1
	endc
		move.l	Dosbase(a5),a6
		moveq	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.s	.NoConfigDir
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1

.NoConfigDir:	move.l	d1,-(a7)
		lea	ConfigName(pc),a1
		move.l	a1,d1
		move.l	#1005,d2			*Mode_NewFile
		move.l	Dosbase(a5),a6
		jsr	_LVOOpen(a6)
		move.l	(a7)+,d1
		move.l	d0,-(a7)
		tst.l	d1
		beq.s	.NoConfigDir2
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnlock(a6)
.NoConfigDir2:	move.l	(a7)+,d6
		moveq	#EPR_FileNotFound,d0
		tst.l	d6
		beq.w	.Return

	*----------- Nun Config Schritt fr Schritt speichern ---------*
		lea	ConfigDatas(a5),a0
		move.l	#ConfigDatasEnd-ConfigDatas,d3
		move.l	d6,d1
		move.l	a0,d2
		move.l	Dosbase(a5),a6
		jsr	_LVORead(a6)

		*--- Datei Closen ---*
		move.l	d6,d1
		beq.s	.AllesOk
		move.l	d0,-(a7)
		move.l	Dosbase(a5),a6
		jsr	_LVOClose(a6)
		move.l	(a7)+,d1
		moveq	#EPR_ErrorInFile,d0
		cmp.l	d0,d3
		bne.s	.Return

.AllesOk:	moveq	#0,d0
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts



*-----------------------------------------------------------------------------*
* Output: d0+a6 = Librarybase
*-----------------------------------------------------------------------------*
GetReqToolsBase:movem.l	d1-a5,-(a7)
		move.l	MyReqToolsBase(a5),d0
		bne.s	.Return
		lea	MyReqToolsName(pc),a1
		EB
		moveq	#38,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,MyReqToolsBase(a5)
.Return:	move.l	d0,a6
		movem.l	(a7)+,d1-a5
		rts

*-----------------------------------------------------------------------------*
* Output: d0+a6 = Librarybase
*-----------------------------------------------------------------------------*
GetASLBase:	movem.l	d1-a5,-(a7)
		move.l	MyASLBase(a5),d0
		bne.s	.Return
		lea	MyASLName(pc),a1
		EB
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,MyASLBase(a5)
.Return:	move.l	d0,a6
		movem.l	(a7)+,d1-a5
		rts

*-----------------------------------------------------------------------------*
* Output: d0+a6 = Librarybase
*-----------------------------------------------------------------------------*
GetDiskfontBase:
		movem.l	d1-a5,-(a7)
		move.l	MyDiskfontBase(a5),d0
		bne.s	.Return
		lea	MyDiskFontName(pc),a1
		EB
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,MyDiskFontBase(a5)
.Return:	move.l	d0,a6
		movem.l	(a7)+,d1-a5
		rts


*-----------------------------------------------------------------------------*
SendeOneMessage:
		movem.l	d1-a6,-(a7)
	if	executable+debugger
		bsr	CreateMsgPort
		beq.w	.Fehler

		bsr	WaitUserMessages

	*	tst	Exitnow(a5)
	*	bne	.fehler

		bsr	AllocMsg
		beq	.fehler
		move.l	d0,a1
		move.l	d0,a4
		*lea	MyMessage(a5),a1

	*------------ Exec-Message initialisieren -----------*
		move.w	#UM_Sizeof-20,MN_Length(a1)
		move.b	#NT_Message,LN_Type(a1)
		move.l	MsgPort(a5),MN_ReplyPort(a1)

	*------------ User-Message initialisieren -----------*
		if	debugger
		move.w	MerkUserNr(a5),UM_UserNr(a1)
		else
		move.w	EUS_Structure+EUS_UserNr(pc),UM_UserNr(a1)
		endc
		move.l	MyTaskAdr(a5),UM_TaskAdr(a1)
		move.l	Signal(a5),UM_Signal(a1)
		move.l	MsgPort(a5),UM_UserPort(a1)
		move.l	#USM_Userprg,UM_Type(a1)
		move.w	d1,UM_Enabled(a1)
		move.w	d2,UM_Class(a1)			;Kennung setzen
		move.l	d3,UM_Command(a1)
		move.l	d4,UM_ArgString(a1)
		move.l	d5,UM_Result(a1)

		*move.l	a1,ThisMessage(A5)

	*------------ Message senden -------------*
.RetryFindPort:	move.l	AndererPort(a5),d0
		move.l	d0,a1
		bne.s	.JaAnderer
		lea	EPUserPortName(pc),a1
.JaAnderer:	EB
		jsr	_LVOFindPort(a6)
		move.l	d0,a0
		tst.l	d0
		bne.s	.PortDa

	*----- Eagleplayer-Port nicht gefunden ----*
		tst.l	AndererPort(a5)
		bne.s	.Fehler

		moveq	#LENr_EPNotFound,d0
		moveq	#LENr_Ok,d1
		bsr	TextRequest
		moveq	#0,d0
		bra.s	.Fehler
		*beq.s	.Fehler
		*bra.s	.RetryFindPort

.PortDa:	movem.l	d0/a0,-(a7)
		*move.l	ThisMessage(A5),a1
		*lea	MyMessage(a5),a1
		move.l	a4,a1

		move.l	UM_TaskAdr(a1),d0
		beq.s	.NoTask
		move.l	d0,a1
		moveq	#0,d0
		jsr	_LVOSetTaskPri(a6)	
.NoTask:	movem.l	(a7)+,d0/a0
		*move.l	ThisMessage(A5),a1
		*lea	MyMessage(a5),a1
		move.l	a4,a1
		jsr	_LVOPutMsg(a6)

		addq.l	#1,MsgUnterwegs(a5)

	*---------- Alles klar, Ende ----------*
.NoPort:	bsr	WaitUserMessages
	endc
		moveq	#-1,d0
.Fehler:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
CreateMsgPort:	movem.l	d1-d7/a1-a6,-(a7)
		move.l	MsgPort(a5),d0
		bne.s	.PortOk
		EB
		jsr	_LVOCreateMsgPort(a6)	;Messageport auf die schnelle Art
		move.l	d0,MSGport(a5)
		tst.l	d0
		beq.s	.PortOk
		move.l	d0,a1
		move.l	#MyMsgPortName,LN_Name(a1)
		jsr	_LVOAddPort(a6)


	*----------- SignalBits setzen ------------*
		move.l	MsgPort(a5),a0
		move.l	SignalBits(a5),d6
		moveq	#0,d0
		move.b	15(a0),d0
		bset	d0,d6
		move.l	d6,SignalBits(a5)

.PortOk:	movem.l	(a7)+,d1-d7/a1-a6
		move.l	MsgPort(a5),d0
		move.l	d0,a0
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
* Output: d0=Adr
Allocmsg:	movem.l	d1-a6,-(sp)
		EB
		moveq	#UM_Sizeof,d0
		move.l	#$10001,d1
		jsr	_LVOAllocMem(A6)
		movem.l	(sp)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: a1=Msg
Freemsg:	movem.l	d0-a6,-(a7)
		moveq	#0,d0
		move.w	mn_length(a1),d0
		beq.s	.Error
		add.l	#20,d0
		EB
		jsr	_LVOFreemem(A6)
.Error:		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
RemoveMsgPort:	movem.l	d0-a6,-(a7)

	*----------- SignalBits sperren ------------*
		move.l	MSGport(a5),d0
		beq.s	.PortOk
		move.l	d0,a1
		move.l	SignalBits(a5),d1
		moveq	#0,d0
		move.b	15(a1),d0
		bclr	d0,d1
		move.l	d1,SignalBits(a5)
		EB
		jsr	_LVORemPort(a6)

		move.l	MsgPort(a5),a0
		jsr	_LVODeleteMsgPort(a6)	;Messageport auf die schnelle Art
		clr.l	MsgPort(a5)
.PortOk:	movem.l	(a7)+,d0-a6
		rts

*----------------------- Gibt die Return-Structure frei -------------------*
FreeCommandStruct:
		movem.l d0/d1/a0/a1/a4/a6,-(a7)
		move.l	UPrg_Struct(a5),a4
.NextStruct:	moveq	#0,d0
		cmp.l	a4,d0
		beq.w	.Return
		move.l	a4,a1
		move.l	(a1),a4
		move.l	EPT_StringSize(a1),d0
		beq.s	.StructFree
		EB
		jsr	_LVOFreeMem(a6)
.StructFree:	bra.b	.NextStruct
.Return:
		clr.l	UPrg_Struct(a5)
		movem.l	(a7)+,d0/d1/a0/a1/a4/a6
		rts

*---------------------------------------------------------------------------*
WaitUserMessages:movem.l d0-a6,-(a7)

	if debugger
		bsr.w	CopyEPBase
	endc

		tst.w	NoWait(a5)
		bne.s	.Return

.WaitNochmal:
		tst.l	MsgUnterwegs(a5)
		beq.w	.Return
		move.l	4,a6
		bsr	CreateMsgPort
		beq.s	.Return
		move.l	a0,a3
		jsr	_LVOGetMsg(a6)
		tst.l	d0
		bne.s	.MSG

		tst.w	ExitNow(a5)
		bne.w	.Return

		move.l	a3,a0
		jsr	_LVOWaitPort(a6)
		bra.s	.WaitNochmal
.MSG
		move.l	d0,a1
		bsr	UserMessage

		tst.w	ExitNow(a5)
		beq.w	.WaitNochmal
.Return:	movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
ClrPuffer:	if	Test
		bsr	FirstEagleInit
		endc

		move.l	a5,a0
		move.w	#PufferEnd-1,d0
.clr		clr.b	(a0)+
		dbf	d0,.clr
		rts

		if	Debugger!Test
CopyEPBase:
*		move.l	EUS_Structure+EUS_EPBase(pc),d0
*		beq.s	.Fertig
*		move.l	d0,a0
*		*move.l	a0,EPBase(a5)
*		move.w	#EPG_SizeOf/2-1,d0
*		move.l	a5,a1
*.CopyEP:	move.w	(a0)+,(a1)+
*		dbf	d0,.CopyEP
.Fertig:	rts
		endc

*-----------------------------------------------------------------------------*
* Sendet dem Eagleplayer, falls dieser im Helpmode ist, eine HelpNode
*-----------------------------------------------------------------------------*
* Input: a0=Nodename
* Output:d0=0  --> Node geschickt
SendHelp:	movem.l	d1-a6,-(a7)
		move.l	EPBase(pc),a4
		move.l	EPG_SomePrefs(a4),d1
		btst	#EGPRF_Help,d1
		beq.s	.NoHelp

		move.l	a0,a3
		bsr	BerechStringSize

		moveq	#0,d7
		bsr	AllocArg
		beq.s	.NoHelp
		move.l	d7,d4
		move.l	d7,a1

		moveq	#0,d7
		bsr	AllocArg
		beq.s	.NoHelp
		move.l	d7,a2

		*--- Args setzen ---*

		move.l	a3,ENA_Arg1(a2)
		move.l	d0,ENA_Arg2(a2)

		move.l	#EPNr_FirstEngine,d0
		add.w	EUS_Structure+EUS_UserNr(pc),d0
		move.l	d0,ENA_Arg1(a1)
		move.l	a2,ENA_Next(a1)

		*--- Kommando an EP schicken ---*
		moveq	#0,d1
		moveq	#USClass_Command,d2
		move.l	#EPNr_HelpLink,d3		*EP-Kommando
		moveq	#0,d5
		bsr	SendeOneMessage


		moveq	#1,d0
.NoHelp:	seq	d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Eine Message wird an den Eagleplayer gesendet.
* Input: d0=Wert fr Arg1 = Nummer
*	 d1=Wert fr Arg2
*	 d3=EPNr_Nummer
SendMess:	movem.l	d0-a6,-(a7)

		moveq	#0,d7
		bsr	AllocArg
		beq.s	.Error
		move.l	d0,ENA_Arg1(a0)
		move.l	d1,ENA_Arg2(a0)
		move.l	a0,d4			-> Args
		moveq	#0,d1
		moveq	#USClass_Command,d2
		moveq	#0,d5
		bsr	SendeOneMessage
.Error:		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: d7=Size nach ENA_Size
* Output:d7=a0=Adr
AllocArg:	movem.l	d0-d6/a1-a6,-(a7)
		move.l	#ENA_Size+4,d0
		add.l	d7,d0
		EB
		move.l	#$10001,d1
		jsr	_LVOAllocMem(a6)
		move.l	d0,a0
		move.l	#ENA_Size+4,ENA_Size(a0)
		add.l	d7,ENA_Size(a0)
		move.l	d0,d7
		movem.l	(a7)+,d0-d6/a1-a6
		tst.l	d7
		rts

*-----------------------------------------------------------------------------*
* Eine Message wird ohne Args an den Eagleplayer gesendet.
* Input: d3=EPNr_Nummer
SendOhneMess:	movem.l	d0-a6,-(a7)
		moveq	#0,d4
		moveq	#0,d1
		moveq	#USClass_Command,d2
		moveq	#0,d5
		bsr	SendeOneMessage
		movem.l	(a7)+,d0-a6
		rts

*---------------------------------------------------------------------------*
*------------ Hier befindet sich nun die Schleife die Aktionen -------------*
*---------------------------------------------------------------------------*
Warten:		move.l	MsgPort(a5),d0
		beq.s	WartenWinPort
		move.l	d0,a0
		EB
		jsr	_LVOGetmsg(a6)
		tst.l	d0			;Scrollen erlaubt
		beq.w	WartenWinPort
		bsr.w	UserMessage
		bra.w	Warten

SendExit:	moveq	#0,d1
		moveq	#USClass_Exit,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		bsr	SendeOneMessage
Return:		rts

WartenWinPort:	tst.w	ExitNow(a5)
		bne.w	Return

		move.l	WindowPort(a5),d0
		beq.s	Wait
		move.l	d0,a0
		move.l	GadBase(a5),a6
		jsr	_LVOGT_GetIMsg(a6)
		tst.l	d0
		beq.s	Wait
		move.l	d0,a1
		bsr.w	GetMsg

		cmp.w	#EPNr_Engine,d0
		bne.s	Warten
		rts

*----------------------------------------------------------------------------*
*------------- Hier wait, bis einer der Message-Ports ->>> Message ----------*
*----------------------------------------------------------------------------*
Wait:		move.l	SignalBits(a5),d0
		or.w	#$1000,d0		;Break-Signal
		EB
		jsr	_LVOWait(a6)

	*------- War es ein Break Signal -----*
		btst	#12,d0			;Break-Signal
		bne.w	SendExit

	*-- Pattern schreiben --*
		move.l	Signal(a5),d1
		btst	d1,d0
		beq.s	.NoUpdate
		moveq	#1,d7
		bsr.w	UpdateInfos
		bclr	d1,d0

	*------- War es ein UserMessage ------*
.NoUpdate:	move.l	MsgPort(a5),d2
		beq.s	.NoPort
		move.l	d2,a0
		moveq	#0,d1
		move.b	15(a0),d1
		btst	d1,d0
		bne.w	Warten			;EaglePort

	*----- war es eine Window-Message ----*
.NoPort:	move.l	WindowPort(a5),d2		;Testen ob Window-Port
		beq.s	.NoMain
		move.l	d2,a0
		move.b	15(a0),d1
		btst	d1,d0
		bne.w	WartenWinPort

.NoMain:	bra.w	Wait





*-----------------------------------------------------------------------------*
GetMsg:		lea	Puffer,a5
		*move.l	WindowPort(a5),d0
		*beq.w	.Return
		*move.l	d0,a0
		*move.l	GadBase(a5),a6
		*jsr	_LVOGT_getimsg(a6)
		*tst.l	d0
		*beq	.Return
		*move.l	d0,a1
		move.l	im_class(a1),d7
		moveq	#0,d5
		move.l	IM_Seconds(a1),CurrentSeconds(a5)
		move.l	IM_Micros(a1),CurrentMicros(a5)
		move.w	im_code(a1),d5 		<- Fr Tastatur / Selnummer Listview
		move.l	im_Iaddress(a1),d6 	<- Fr Gadgetabfrage
		move.l	im_seconds(a1),d2	<- fr Doppelclick
		move.l	im_micros(a1),d3	<- auch f. Doppelclick
		move.w	im_Qualifier(a1),Qualifier(a5)
		jsr	_LVOGT_ReplyIMsg(a6)

	*---------------- MSG auswerten -------------*
		cmp.l	#IDCMP_Changewindow,d7	;Refresh
		bne.s	.TestNewSize
		move.l	Winhandle(a5),a0
		move	OffY(A5),d0
		cmp	wd_height(a0),d0
		bne.s	.setposun
		move.w	wd_leftedge(a0),ZoomPosX(a5)
		move.w	wd_topedge(a0),ZoomPosY(a5)
		st	ZoomState(a5)
		bra.w	.Return
.Setposun:	move.w	wd_leftedge(a0),WinPosX(a5)
		move.w	wd_topedge(a0),WinPosY(a5)
		move.w	wd_Width(a0),WinWidth(a5)
		move.w	wd_Height(a0),WinHeight(a5)
		sf	ZoomState(a5)
		bra.w	.Return

*---------------------------------------------------*
* das war die alte Refreshroutine
******************************************
*.TestNewSize:	cmp.l	#NewSize,d7
*		bne.s	.TestRefreshWindow
*
*		move.l	Winhandle(a5),a0
*		move	OffY(A5),d0
*		cmp	WD_Height(a0),d0
*		beq.s	.SizeNoMerk
*		move.w	wd_Width(a0),WinWidth(a5)
*		move.w	wd_Height(a0),WinHeight(a5)
*.SizeNoMerk:	move.l	GadgetListAdr(a5),d0
*		beq.s	.TestRefreshWindow
*		move.l	d0,a1
*		moveq	#0,d0
*		move.w	RealNumGadgets(a5),d0
*		move.l	Winhandle(a5),a0
*		move.l	Intbase(a5),a6
*		jsr	_LVORemoveGList(a6)
*		bsr	FreeGadgets
*		bsr	Clearwindow
*		bsr	InitGadgets
*		bne.w	.Return
*		bsr	AddGads
*		*bne	.Return
*		bsr	EinTragNeu
*		bra.w	.Return
*
*.TestRefreshWindow:
*
*		cmp.l	#Refreshwindow,d7	;Refresh
*		bne.s	.TestGadgetUp
*
*.Refresh:
*
*	move.l	IntBase(a5),a6
*	move.l	WinHandle(a5),a0
*	jsr	_LVORefreshWindowFrame(a6)
*	bra.w	.return
*---------------------------------------------------*

.TestNewSize:	cmp.l	#NewSize,d7
		bne.s	.TestRefreshWindow

		move.l	Winhandle(a5),a0

		move.w	wd_width(a0),d0
		move.w	wd_height(a0),d1

		cmp.w	LastWidth(a5),d0
		bne.s	.NewSizeReal
		cmp.w	LastHeight(a5),d1
		beq.w	.Return
.NewSizeReal:
		move.w	d0,LastWidth(a5)
		move.w	d1,LastHeight(a5)

		bsr	ResizeWindow
		bra.w	.Return

.TestRefreshWindow:

		cmp.l	#Refreshwindow,d7	;Refresh
		bne.s	.TestGadgetUp

*		bsr	ResizeWindow

		bra.w	.Return



*		bsr	Clearwindow
*	*	move.l	Gadbase(a5),a6
*	*	move.l	Winhandle(a5),a0	;*Window
*	*	jsr	_LVOGT_beginrefresh(a6)
*
*	*	move.l	Winhandle(a5),a0	;*Window
*	*	moveq	#1,d0
*	*	jsr	_LVOGT_Endrefresh(a6)
*
*		move.l	GadgetListAdr(a5),a0
*		move.l	Winhandle(a5),a1
*		suba.l	a2,a2
*		moveq	#-1,d0
*		move.l	IntBase(a5),a6
*		jsr	_LVOrefreshglist(a6)
*
*		move.l	GadBase(a5),a6
*		move.l	Winhandle(a5),a0
*		sub.l	a1,a1
*		jsr	_LVOGT_RefreshWindow(a6)
*
*
*		bra.w	.Return

.TestGadgetUp:	cmp.l	#Gadgetup,d7
		bne.w	.TestgadgetDown
		move.l	d6,a1
		move.w	GG_Gadgetid(a1),d0	;Nr des Gadgets
		bsr	JumpTo
		bra.w	.Return

.TestGadgetDown:cmp.l	#MouseMove,d7
		bne.w	.TestMenu
		move.l	d6,a1
		move.w	GG_Gadgetid(a1),d0	;Nr des Gadgets
		cmp.w	#EPENr_Slider,d0
		bne.w	.Return
		bsr	JumpTo
		bra.w	.Return


.MenuLoop:	move.l	OldMenuAdr(a5),a1
		move.w	MI_NextSelect(A1),d5
		bra.s	.MenuNext
.TestMenu:	cmp.l	#MenuPick,d7
		bne.w	.TestRawKey
.MenuNext:	move.w	d5,d0
		cmp.w	#menunull,d0
		beq	.Return
		move.l	MenuAdr(a5),a0
		move.l	IntBase(a5),a6
		jsr	_LVOItemAddress(a6)
		move.l	d0,a1
		tst.l	d0
		beq	.Return
		move.l	d0,OldMenuAdr(a5)

		lea	.Menutabelle(pc),a0
.NextItem:	move.w	(a0)+,d1
		beq.w	.Return
		move.w	(a0)+,d0
		cmp.w	d5,d1
		bne.s	.NextItem
.JumpTo:	moveq	#0,d2		;d5 mit durchschleifen fr Show by
		sub.l	a2,a2
		bsr	JumpTo
		bra.w	.Return

.MenuTabelle:
		dc.w	MNr_Play,EPENr_Play
		dc.w	MNr_Stop,EPENr_Stop
		dc.w	MNr_SaveSample,EPENr_SaveSample
		dc.w	MNr_ModuleCont,EPENr_ModuleCont
		dc.w	MNr_About,EPENr_About
		dc.w	MNr_Hide,EPENr_Hide
		dc.w	MNr_Quit,EPENr_Quit
		dc.w	MNr_Vorwaerts,EPENr_Vorwaerts
		dc.w	MNr_Rueckwaerts,EPENr_Rueckwaerts
		dc.w	MNr_SampleSaverOn,EPENr_SampleSaverOn
		dc.w	MNr_BackPic,EPENr_BackPic
		dc.w	MNr_SelectBackPic,EPENr_SelectBackPic
		dc.w	MNr_ChooseFont,EPENr_ChooseFont
		dc.w	MNr_SaveConfig,EPENr_SaveConfig
		dc.w	0


.TestRawkey:	cmp.l	#rawkey,d7
		bne	.TestVanillaKey
		
		move.w	Qualifier(a5),d2
		btst	#3,d2
		bne.s	.Control
		btst	#0,d2
		bne.s	.Shift
		btst	#1,d2
		bne.s	.Shift

		moveq	#EPENr_ViewUp,d0
		cmp.b	#$4c,d5
		beq.w	.JumpTo

		moveq	#EPENr_ViewDown,d0
		cmp.b	#$4d,d5
		beq.w	.JumpTo

		moveq	#EPENr_ViewLeft,d0
		cmp.b	#$4f,d5
		beq.w	.JumpTo

		moveq	#EPENr_ViewRight,d0
		cmp.b	#$4e,d5
		beq.w	.JumpTo

		*cmp.b	#$45,d5			;ESC
		*beq.w	.HideWindow
		*cmp.b	#$4d,d5
		*beq.s	.EinenRunter
		*cmp.b	#$4c,d5
		*beq.s	.EinenRauf
		*cmp.b	#$44,d5
		*beq.s	.ToggleZustand
		*cmp.b	#$40,d5
		*beq.s	.ToggleZustand
		cmp.b	#$5f,d5
		beq.s	.ToggleHelpMode
		bra.w	.Return


.Control:	moveq	#EPENr_ViewTop,d0
		cmp.b	#$4c,d5
		beq.w	.JumpTo

		moveq	#EPENr_ViewBotom,d0
		cmp.b	#$4d,d5
		beq.w	.JumpTo

		moveq	#EPENr_ViewLeftMarge,d0
		cmp.b	#$4f,d5
		beq.w	.JumpTo

		moveq	#EPENr_ViewRightMarge,d0
		cmp.b	#$4e,d5
		beq.w	.JumpTo

		bra.w	.Return

.Shift:		moveq	#EPENr_ViewPageUp,d0
		cmp.b	#$4c,d5
		beq.w	.JumpTo

		moveq	#EPENr_ViewPageDown,d0
		cmp.b	#$4d,d5
		beq.w	.JumpTo

		moveq	#EPENr_ViewPageLeft,d0
		cmp.b	#$4f,d5
		beq.w	.JumpTo

		moveq	#EPENr_ViewPageRight,d0
		cmp.b	#$4e,d5
		beq.w	.JumpTo

		bra.w	.Return


*
*.EinenRunter:	move.l	SelectedEntry(a5),d0
*		cmp.l	MaxEntries(a5),d0
*		beq.w	.Return
*		addq.l	#1,d0
*		bsr	SetModulesEntry
*		bra.w	.Return
*
*.EinenRauf:	move.l	SelectedEntry(a5),d0
*		cmp.l	#2,d0
*		blt.w	.Return
*		subq.l	#1,d0
*		bsr	SetModulesEntry
*		bra.w	.Return
*



*.Help:		move.l	#EPNr_HelpLink,d3		*EP-Kommando
*		move.l	SelectedEntry(a5),d0		*Playernummer
*		add.w	#EPNr_FirstPlayer,d0
*		cmp.b	#Mode_Player,Mode(a5)
*		beq.s	.Hlp_Player
*		bsr	GetEngineNr
*		add.w	#EPNr_FirstEngine-1,d0
*.Hlp_Player:	moveq	#0,d1
*		bsr	SendMess
*		bra.w	.Return

.ToggleHelpMode:moveq	#EPNr_Help,d3
		moveq	#-1,d0				;Toggle
		moveq	#0,d1
		bsr	SendMess
		bsr	ErlaubeGadgets
		bra.w	.Return

.TestVanillaKey:cmp.l	#vanillakey,d7
		bne	.TestCloseWindow

		*cmp.b	#13,d5				;Tab
		*beq.s	.ToggleZustand
		*cmp.b	#32,d5				;Leertaste
		*beq.s	.ToggleZustand
		cmp.b	#$1b,d5
		beq.w	.HideWindow

		bclr	#5,d5
		lea	.Tastaturtabelle(pc),a1
.TesteTasten:	moveq	#0,d0
		move.b	(a1)+,d1
		beq.w	.Return
		move.b	(a1)+,d0
		bne.s	.StandardKuerzel
		move.l	d1,d0
		bsr	GetLocaleString
		move.l	d0,a0
		moveq	#0,d4
		move.b	(a0),d0
.StandardKuerzel:moveq	#0,d4
		move.b	(a1)+,d4
		bclr	#5,d0
		cmp.b	d0,d5
		bne.w	.TesteTasten
		move.l	d4,d0
		bsr	JumpTo
		bra.w	.Return

.Tastaturtabelle:
		dc.b	1,"Q",EPENr_Quit
		dc.b	1,"H",EPENr_Hide
		dc.b	1,"A",EPENr_About
		dc.b	1,13,EPENr_Play
		dc.b	LENr_PlayKey,0,EPENr_Play
		dc.b	LENr_StopKey,0,EPENr_Stop
		dc.b	LENr_SaveSampleKey,0,EPENr_SaveSample
		dc.b	LENr_ModuleContKey,0,EPENr_ModuleCont
		dc.b	0
		even

.TestCloseWindow:cmp.l	#CloseWindow,d7
		bne	.Return

.HideWindow:	lea	Helpnode_Hide(pc),a0
		bsr	SendHelp
		beq.w	.Return

		moveq	#EPENr_Hide,d0
		bsr	JumpTo
		if	Debugger!Executable
		bra.s	.Return
		endc

.CloseWindow:	moveq	#EPENr_Quit,d0
		bsr	JumpTo

		moveq	#EPNr_Engine,d0
		ifeq	executable+debugger
		bra.w	.Return
		else
		bra.w	.Return2
		endc


.Return:	moveq	#0,d0
.Return2:	tst.l	d0
		rts

PJM	MACRO
	dc.w	\1-.JumpToTabelle,\2-.JumpToTabelle
	ENDM

*-----------------------------------------------------------------------------*
* d0=EPNr_Nummer
* d5=MenuItemNr
JumpTo:		movem.l	d1-a6,-(a7)
		lea	.JumpToTabelle(pc),a0
		cmp.w	#EPENr_LastNr,d0
		bhi.s	.Return
		move.l	d0,d1
		add.w	d0,d0
		add.w	d0,d0

		move.l	EPBase(pc),a4
		btst	#EGPRF_Help-8,EPG_SomePrefs+2(a4)
		beq.s	.NoHelp
		tst.w	-2(a0,d0.w)
		beq.s	.NoHelp

		move.w	-2(a0,d0.w),d0
		lea	(a0,d0.w),a0
		bsr	SendHelp
		cmp.w	#EPENr_Slider,d1
		bne.s	.Return
		move.l	PlayFrequence(a5),d5
		bsr	SetSlider
		bra.s	.Return

.NoHelp:	move.w	-4(a0,d0.w),d0
		lea	(a0,d0.w),a0
		jsr	(a0)
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

.JumpToTabelle:

.EPENr_Length		PJM	Return,.JumpToTabelle
.EPENr_Position		PJM	Return,.JumpToTabelle
.EPENr_Time		PJM	Return,.JumpToTabelle
.EPENr_Name		PJM	Return,.JumpToTabelle
.EPENr_Infoliste	PJM	Listview,Helpnode_Infoliste
.EPENr_Slider		PJM	Slider,Helpnode_Slider
.EPENr_SaveSample	PJM	SaveSample,Helpnode_SaveSample
.EPENr_TextGadget	PJM	Return,.JumpToTabelle
.EPENr_About		PJM	About,Helpnode_About
.EPENr_Quit		PJM	Quit,Helpnode_Quit
.EPENr_Hide		PJM	Hide,Helpnode_Hide
.EPENr_SelectBackPic	PJM	SelectBackPic,Helpnode_SelectBackPic
.EPENr_BackPic		PJM	BackPic,Helpnode_BackPic
.EPENr_ViewUp		PJM	ViewUp,.JumpToTabelle
.EPENr_ViewDown		PJM	ViewDown,.JumpToTabelle
.EPENr_ViewPageUp	PJM	ViewPageUp,.JumpToTabelle
.EPENr_ViewPageDown	PJM	ViewPageDown,.JumpToTabelle
.EPENr_ViewTop		PJM	ViewTop,.JumpToTabelle
.EPENr_ViewBotom	PJM	ViewBotom,.JumpToTabelle
.EPENr_ViewLeft		PJM	ViewLeft,.JumpToTabelle
.EPENr_ViewRight	PJM	ViewRight,.JumpToTabelle
.EPENr_ViewPageLeft	PJM	ViewPageLeft,.JumpToTabelle
.EPENr_ViewPageRight	PJM	ViewPageRight,.JumpToTabelle
.EPENr_ViewLeftMarge	PJM	ViewLeftMarge,.JumpToTabelle
.EPENr_ViewRightMarge	PJM	ViewRightMarge,.JumpToTabelle
.EPENr_Play		PJM	Play,Helpnode_Play
.EPENr_LoadConfig	PJM	LoadConfig,.JumpToTabelle
.EPENr_SaveConfig	PJM	SaveConfig,Helpnode_SaveConfig
.EPENr_Vorwaerts	PJM	Vorwaerts,Helpnode_Vorwaerts
.EPENr_Rueckwaerts	PJM	Rueckwaerts,Helpnode_Rueckwaerts
.EPENr_ModuleCont	PJM	ModuleCont,Helpnode_Modulecont
.EPENr_Stop		PJM	Stop,Helpnode_Stop
.EPENr_ChooseFont	PJM	ChooseFont,Helpnode_ChooseFont
.EPENr_SamplesaverOn	PJM	SamplesaverOn,Helpnode_SamplesaverOn

			ifne	(EPENr_LastNr-1)*4-(*-.JumpToTabelle)
			HUHU
			endc


*-----------------------------------------------------------------------------*
Rueckwaerts:	moveq	#PFF_Rueckwaerts,d1
		bra.s	SetTime
Vorwaerts:	moveq	#0,d1
SetTime:	move.w	PrefsFlags+EUS_Structure(pc),d0
		move.l	d0,d2
		and.w	#~[PFF_Rueckwaerts],d0
		or.w	d1,d0
		move.w	d0,PrefsFlags+EUS_Structure
		moveq	#0,d7
		bsr	UpdateInfos
		rts

*-----------------------------------------------------------------------------*
* Input: d0=Nummer
*	 a1=Adr des Items !!!!!!!!!!!!!!
*-----------------------------------------------------------------------------*
SampleSaverOn:
		move.b	MI_Flags(a1),d0
		and	#1,d0

		move.w	PrefsFlags+EUS_Structure(pc),d1
		and.w	#~[PFF_SampleSaverOn],d1
		lsl.l	#PFB_SampleSaverOn,d0
		or.w	d0,d1
		move.w	d1,PrefsFlags+EUS_Structure

		bsr	ResizeWindow

.Return:	moveq	#0,d0
		rts
*-----------------------------------------------------------------------------*
* Samplesaver laden und reinhppen
SaveSample:	move.l	EUS_Structure+EUS_EPBase(pc),a4


		moveq	#0,d7
		bsr	AllocArg
		beq.s	.Error
		move.l	d7,d4
		move.l	d7,a1

		moveq	#0,d7
		bsr	AllocArg
		beq.s	.Error
		move.l	d7,a2

		lea	Samplesaver(pc),a0
		bsr	BerechStringSize
		move.l	a0,ENA_Arg1(a1)
		move.l	d0,ENA_Arg2(a1)

		*--- Args setzen ---*
		move.l	#1,ENA_Arg1(a2)			*anschalten
		move.l	a2,ENA_Next(a1)


		*--- Kommando an EP schicken ---*
		moveq	#0,d1
		moveq	#USClass_Command,d2
		move.l	#EPNr_AscEngine,d3		*EP-Kommando
		moveq	#0,d5
		bsr	SendeOneMessage

		move.l	Dosbase(a5),a6
		moveq	#2,d1
		jsr	_LVODelay(a6)

		*--- Jetzt Sample setzen im Samplesaver ---*
		moveq	#0,d7
		bsr	AllocArg
		beq.s	.Return
		move.l	d7,d4
		move.l	d7,a1

		bsr	GetSelectedStruct
		bne.s	.Return
		move.l	ML_SampleStruct(a0),ENA_Arg1(a1)

	lea	SampleMSGPortName(pc),a0
	move.l	a0,AndererPort(a5)

		*--- Kommando an EP schicken ---*
		moveq	#0,d1
		moveq	#USClass_EngineCommand,d2
		move.l	#2,d3				*EP-Kommando
		moveq	#0,d5
		bsr	SendeOneMessage

	clr.l	AndererPort(a5)

.Error:
.Return:	moveq	#0,d0
		rts



*-----------------------------------------------------------------------------*
ModuleCont:	move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_SomePrefs(a4),d0
		btst	#EGPRF_NowPlay,d0
		beq.s	.NoStop
		bsr	Stop			;nur wenn Sample gespielt wird
	*	beq.s	.Return

.NoStop:	moveq	#0,d7
		bsr	AllocArg
		beq.s	.Return
		move.l	d7,d4
		move.l	d7,a1
		move.l	#1,ENA_Arg1(a1)

		*--- Kommando an EP schicken ---*
		moveq	#0,d1
		moveq	#USClass_Command,d2
		move.l	#EPNr_Play,d3		*EP-Kommando
		moveq	#0,d5
		bsr	SendeOneMessage
.Return:	moveq	#0,d0
		rts


*-----------------------------------------------------------------------------*
Play:		movem.l	d1-a6,-(a7)
		move.l	EPBase(pc),a4

		lea	SampleSaveTags(pc),a4
		lea	PlayFrequence(a5),a1
		move.l	a1,4(a4)

		bsr	GetSelectedStruct
		bne.s	.Error
		move.l	ML_Samplestruct(a0),d0
		beq.s	.Error
		move.l	d0,a3

		tst.l	EPS_Adr(a3)
		beq.s	.Error
		tst.l	EPS_Length(a3)
		beq.s	.Error

		moveq	#0,d7
		bsr	AllocArg
		beq.s	.Error
		move.l	d7,d4
		move.l	d7,a1

		moveq	#0,d7
		bsr	AllocArg
		beq.s	.Error
		move.l	d7,a2

		*--- Args setzen ---*
		move.l	a3,ENA_Arg1(a1)
		move.l	a4,ENA_Arg1(a2)
		move.l	a2,ENA_Next(a1)

		*--- Kommando an EP schicken ---*
		moveq	#0,d1
		moveq	#USClass_Command,d2
		move.l	#EPNr_PlaySample,d3		*EP-Kommando
		moveq	#0,d5
		bsr	SendeOneMessage
		bsr	ErlaubeGadgets
.Error:		moveq	#0,d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

SampleSavetags:	dc.l	SS_DefFreqPtr,0
		dc.l	0

*-----------------------------------------------------------------------------*
Stop:		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_PlayerTaglist(a4),a6
		move.l	#EP_SamplePlayer,d0
		bsr	FindTag
		beq.s	.Return

		moveq	#0,d7
		bsr	AllocArg
		beq.s	.Return
		move.l	d7,d4
		move.l	d7,a1
		move.l	#0,ENA_Arg1(a1)

		*--- Kommando an EP schicken ---*
		moveq	#0,d1
		moveq	#USClass_Command,d2
		move.l	#EPNr_Play,d3		*EP-Kommando
		moveq	#0,d5
		bsr	SendeOneMessage
		bsr	ErlaubeGadgets
		moveq	#1,d2
.Return:	moveq	#0,d0
		tst.l	d2
		rts

*-----------------------------------------------------------------------------*
ChooseFont:
		bsr	GetASLBase
		beq.s	.End

		moveq	#ASL_FontRequest,d0
		suba.l	a0,a0
		jsr	_LVOAllocAslRequest(A6)
		move.l	d0,d7	
		beq.s	.end

		lea	MyTags(A5),a1
		move.l	#ASLFO_TitleText,(a1)+

		moveq	#LENr_ChooseFont,d0
		bsr	GetLocaleString
		move.l	d0,(A1)+

		move.l	#ASLFO_MinHeight,(a1)+
		move.l	#6,(a1)+

*		move.l	#ASLFO_maxHeight,(a1)+
*		moveq	#0,d0
*		move.w	SCR_font_max(A5),d0
*		move.l	d0,(a1)+
*		move.l	#ASLFO_FilterFunc,(a1)+
*		lea	myhook(pc),a2
*		move.l	a2,(a1)+

		clr.l	(a1)

		move.l	d7,a0
		lea	MyTags(A5),a1
		jsr	_LVOAslRequest(a6)
		tst.l	d0
		beq.s	.free

		move.l	d7,a0
		move.w	fo_attr+ta_ysize(a0),d0
		move.w	d0,MyFontsize(A5)

		move.l	fo_attr+ta_name(a0),a0
		lea	MyFontName(a5),a1
.cop
		move.b	(a0)+,(a1)+
		bne.s	.cop
.free
		move.l	d7,a0
		jsr	_LVOFreeAslRequest(A6)

		bsr	CloseWin
		bsr	OpenWin
	move.w	#1,NoWait(a5)
		moveq	#EPNr_GetSampleInfo,d3
		bsr	SendOhneMess

		moveq	#EPNr_Status2,d3
		move.l	#`MFIL`,d0
		moveq	#0,d1
		bsr	SendMess

	clr.w	NoWait(a5)
.end
		moveq	#0,d0
		rts

*myhook					;Filterhook, um zu groe Fonts nicht
*					;anzuzeigen
*	dcb.b	mln_size,0
*	dc.l	my_hook
*	dc.l	0
*	dc.l	0
*my_hook
*	push	d1
*	move.w	SCR_font_max+Datas,d1
*	moveq	#0,d0
*	cmp.w	ta_ysize(a1),d1
*	blt.s	.hi
*	moveq	#1,d0
*.hi		
*	pop	d1
*	rts

*----------------------------------------------------------------------------*
*       holt aktuell eingestellten Font oder Default: ScreenFont
*  Input: none
* Output: D0 - Adresse des Fonts
GetFont:
		push	d1-a6
		tst.b	MyFontName(A5)
		beq	.DefFont
		move.w	MyFontSize(A5),d0
		beq	.DefFont

		lea	MyTextAttr(A5),a0
		clr.b	ta_Style(a0)
		move.b	#0,ta_Flags(a0)
		move.w	d0,ta_YSize(a0)
		lea	MyFontName(a5),a3
		move.l	a3,ta_name(A0)

		bsr	GetDiskFontBase
		beq	.DefFont		
		jsr	_LVOOpenDiskFont(A6)
		move.l	d0,MyFontAdr(a5)
		bne.s	.Return
.DefFont
		move.l	MyPubscreen(a5),d0
		beq.s	.Return
		move.l	d0,a0
		move.l	sc_RastPort+rp_Font(a0),d0
.Return
		pop	d1-a6
		tst.l	d0
		rts

*----------------------------------------------------------------------------*
Slider:		mulu	#FreqStep,d5
		cmp.l	PlayFrequence(a5),d5
		beq.w	.Return
		move.l	d5,PlayFrequence(a5)
		lea	FrequencePuffer(a5),a1
		move.l	d5,d0
		bsr	Hexdez

		*--- Nun Frequenz im spielenden Player setzen --*
		*-- aber nur, wenn der selectierte auch dem   --*
		*-- spielendem entspricht! --*
		bsr	GetSelectedStruct
		bne.s	.NoChange

		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_PlayerTaglist(a4),a6
		move.l	#EP_SamplePlayer,d0
		bsr	FindTag
		beq.s	.Return

		move.l	EPG_PlayerTaglist(a4),a6
		move.l	#EP_SetPlayFrequency,d0
		bsr	FindTag
		beq.s	.NoChange
		move.l	d5,d0
		movem.l	d0-a6,-(a7)
		move.l	EUS_Structure+EUS_EPBase(pc),a5
		jsr	(a6)
		movem.l	(a7)+,d0-a6

		*--- Textgadget updaten ---*
.NoChange:	lea	TextGadgetTags(pc),a3
		moveq	#EPENr_TextGadget,d0
		bsr	GetGadgetAdr
		bne	.Return
		*lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)
.Return:
		moveq	#0,d0
		rts


*------------ verndere die Einstellungen des Listviewgadgets ---------------*
ViewTop:	moveq	#1,d5
		bra.s	SetListView
ViewBotom:	move.l	MaxEntries(a5),d5
		*subq.l	#1,d5
		bra.s	SetListView
ViewUp:		moveq	#0,d5
		move.l	SelectedEntry(a5),d5
		cmp.l	#1,d5
		ble.w	Return
		subq.l	#1,d5
		bra.s	SetListView
ViewDown:	moveq	#0,d5
		move.l	SelectedEntry(a5),d5
		addq.l	#1,d5
		*cmp.l	#1,d5
		*beq.s	SetListView
		cmp.l	MaxEntries(a5),d5
		bhi.w	Return
		bra.s	SetListView

ViewPageUp:	bsr.w	BerechGadAnz
		moveq	#0,d5
		move.l	SelectedEntry(a5),d5
		sub.w	d0,d5
		bhi.s	.IO
		moveq	#1,d5
.Io:		bra.s	SetListView

ViewPageDown:	bsr.w	BerechGadAnz
		moveq	#0,d5
		move.l	SelectedEntry(a5),d5
		add.w	d0,d5
		cmp.l	MaxEntries(a5),d5
		blo.s	.IO
		move.l	MaxEntries(a5),d5
.Io:		bra.w	SetListView


SetListView:	move.l	d5,d0
		bra.w	SetModulesEntry



*---------------- verndere die Einstellungen des Sliders ------------------*
ViewLeftMarge:	move.l	#MinFreq,d5
		bra.s	SetSlider
ViewRightMarge:	move.l	#MaxFreq,d5
		bra.s	SetSlider

ViewLeft:	move.l	PlayFrequence(a5),d5
		sub.l	#FreqStep,d5
		cmp.l	#MinFreq,d5
		bhi.s	.ok
		move.l	#MinFreq,d5
.Ok:		bra.s	SetSlider

ViewRight:	move.l	PlayFrequence(a5),d5
		add.l	#FreqStep,d5
		cmp.l	#MaxFreq,d5
		blt.s	.ok
		move.l	#MaxFreq,d5
.Ok:		bra.s	SetSlider


ViewPageLeft:	move.l	PlayFrequence(a5),d5
		sub.l	#FreqStep*50,d5
		cmp.l	#MinFreq,d5
		bhi.s	.ok
		move.l	#MinFreq,d5
.Ok:		bra.s	SetSlider

ViewPageRight:	move.l	PlayFrequence(a5),d5
		add.l	#FreqStep*50,d5
		cmp.l	#MaxFreq,d5
		blt.s	.ok
		move.l	#MaxFreq,d5
.Ok:		bra.w	SetSlider

		*--- Slider updaten ---*
SetSlider:	lea	SliderPos(pc),a3
		divu	#FreqStep,d5
		move.l	d5,4(a3)

		moveq	#EPENr_Slider,d0
		bsr	GetGadgetAdr
		bne	.skip
		*lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)
.skip
		bra.w	Slider



*-------------- Anzahl der angezeigten Items im Listview berechnen -----------*
BerechGadAnz:	moveq	#EPENr_Infolist,d0
		movem.l	d1/a0/a1,-(a7)
		bsr	GetGadgetAdr		*NotFound ?
		bne.s	.Return
		move.l	WinHandle(a5),d0
		move.l	d0,a1
		move.l	50(a1),a1		*Rastport
		move.l	52(a1),a1		*Font
		moveq	#0,d0
		move.w	20(a1),d0		*FontHhe
		moveq	#0,d1
		move.w	10(a0),d1		*Gadgethhe
		divu	d0,d1
		moveq	#0,d0
		move.w	d1,d0
.Return:	movem.l	(a7)+,d1/a0/a1
		rts


*-----------------------------------------------------------------------------*
* Input: d0=Nummer
*	 a1=Adr des Items !!!!!!!!!!!!!!
*-----------------------------------------------------------------------------*
BackPic:	move.b	MI_Flags(a1),d0
		and	#1,d0

		move.w	PrefsFlags+EUS_Structure(pc),d1
		and.b	#~[PFF_BackPic],d1
		lsl.l	#PFB_BackPic,d0
		or.b	d0,d1
		move.w	d1,PrefsFlags+EUS_Structure

		tst.b	d0
		beq.s	.SetPic
		tst.b	DT_Picturename(A5)			;Test, ob schon Name vorliegt
		bne.s	.SetPic
		lea	DT_PictureDir(a5),a0
		lea	DT_Picturename(a5),a1
		move.w	#LENr_SelectBackPic,d0
		bsr	DT_Filerequest
		bne	.SetPic


		move.l	Winhandle(a5),d0
		beq.w	.Return
		move.l	d0,a0
		move.l	a1,-(a7)
		move.l	IntBase(a5),a6
		jsr	_LVOClearMenuStrip(a6)
		move.l	(a7)+,a1
		move	mi_Flags(a1),d0
		and	#~CHECKED,d0
		move	d0,mi_Flags(a1)				;bser,bser Hack...

		move.l	Winhandle(a5),a0
		move.l	MenuAdr(a5),a1
		jsr	_LVOSetMenuStrip(a6)

		moveq	#0,d2
		bra	BackPic

.SetPic:	bsr	LoadNewPicture
.Return:	moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
SelectBackPic:	lea	DT_PictureDir(a5),a0
		lea	DT_Picturename(a5),a1
		move.w	#LENr_SelectBackPic,d0
		bsr	DT_Filerequest
		beq	.Return

		move.w	PrefsFlags+EUS_Structure(pc),d0
		and.b	#PFF_BackPic,d0
		beq	.Return
		bsr	LoadNewPicture
.Return:	moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
About:		moveq	#LENr_AboutText,d0
		moveq	#LENr_Ok,d1
		bsr	TextRequest		;Infotext ausgeben (Requester)
		moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
Hide:		ifeq	executable+debugger
		move.w	#1,ExitNow(a5)
		moveq	#EPNr_Engine,d0
		bra.w	.Return
		else
		moveq	#0,d1
		moveq	#USClass_Deactivate,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		bsr	SendeOneMessage
		endc
.Return:	rts

*-----------------------------------------------------------------------------*
Quit:		*bsr	SaveListBeforeQuitFirst
		move.w	#1,ExitNow(a5)
		bsr	MerkWindowSize
		moveq	#0,d1
		moveq	#USClass_Exit,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		bsr	SendeOneMessage
		rts


******************************************************************************
*---------------- Auswertung einer UserProgram-Message ----------------------*
******************************************************************************
*
*	Achtung 2. Ausgang der Routine bei Exit !!!!!!!!!!!!
*	Achtung 3. Ausgang der Routine bei UserQuitEagle !!!!!!!!!!!!
*
UserMessage:
		if Executable+Debugger
	;	lea	TextPuffer(a5),a0		;Sicherheitshalber
		move.l	d0,a1
		cmp.l	#USM_UserPrg,UM_Type(a1) ;Test auf Analyzer-MSG
		beq.w	.Auswertung
		cmp.l	#USM_Eagleplayer,UM_Type(a1) ;Test auf Analyzer-MSG
		*bne.w	.ReplyIt3
		bne.w	.ReplyIt

	*--------------- Es ist ein Message angekommen ------------*
.Auswertung:	moveq	#0,d0
		move.w	UM_UserNr(a1),d0

		if	debugger
		move.w	UM_UserNr(a1),MerkUserNr(a5)
		endc


		*move.l	UM_ArgString(a1),UPrg_Struct(a5)
		moveq	#0,d0
		moveq	#0,d7
		move.w	UM_Class(a1),d7
		beq.w	.ReplyIt
		cmp.w	#USClass_NewUserPrg,d7
		beq.w	.NewConfig			;.NewUserPrg
		cmp.w	#USClass_Activate,d7
		beq.w	.Activate
		cmp.w	#USClass_Show,d7
		beq.w	.OpenWindow
		cmp.w	#USClass_DeActivate,d7
		beq.w	.DeActivate
		cmp.w	#USClass_Hide,d7
		beq.w	.CloseWindow
		cmp.w	#USClass_ZipWin,d7
		beq.w	.ZipWindow
		cmp.w	#USClass_UnZipWin,d7
		beq.w	.UnZipWindow
		cmp.w	#USClass_NewConfig,d7
		beq.w	.NewConfig
		cmp.w	#USClass_GetConfig,d7
		beq.w	.GetConfig
		cmp.w	#USClass_Exit,d7
		beq.w	.Exit
		cmp.w	#USClass_SetWaitPointer,d7
		beq.w	.WaitPointer
		cmp.w	#USClass_ClearWaitPointer,d7
		beq.w	.ClearPointer
		cmp.w	#USClass_NewPreference,d7
		beq.w	.NewPreference
		cmp.w	#USClass_SaveConfig,d7
		beq.w	.SaveConfig
		cmp.w	#USClass_NewModule,d7
		beq.w	.NewModule
		cmp.w	#USClass_KillModule,d7
		beq.w	.KillModule
		cmp.w	#USClass_Answer,d7
		beq.w	.Answer
		move.l	d7,d0
		bra.w	.ReplyIt

	*------- Ankommende Message sagt : "Answer" -------*
.Answer:	movem.l	d7/a1,-(a7)
		*cmp.w	#EPNr_GetSampleInfo,UM_Command+2(a1)
		*bne.s	.NoSampleinfo
		cmp.w	#EPNr_Status2,UM_Command+2(a1)
		bne.s	.NoSampleinfo

		*-- Filenamen kopieren --*
		moveq	#FilenamePufferSize-2,d1
		move.l	UM_Arglist(a1),d0
		beq.s	.NoFilename
		move.l	d0,a1
		lea	EPT_String(a1),a0
		lea	FileNamePuffer(a5),a1
		bsr	StringCopy

.NoFilename:	bsr	FreeInfolist
		bsr	TitleAufbau
.NoSampleinfo:	movem.l	(a7)+,d0/a1
		bra.w	.ReplyIt		;Message replyen


	*------- Ankommende Message sagt : "Kill Module" -------*
.KillModule:	*clr.l	SampleInfoLocked(a5)
	move.w	#1,KillAll(a5)
		clr.b	FilenamePuffer(a5)
		bsr	FreeInfoList
	clr.w	KillAll(a5)
		move.l	d7,d0
		bra.w	.ReplyIt

	*------- Ankommende Message sagt : "NEW Module" -------*
.NewModule:	move.l	d7,-(a7)
	move.w	#1,NoWait(a5)
		moveq	#EPNr_GetSampleInfo,d3
		bsr	SendOhneMess

		moveq	#EPNr_Status2,d3
		move.l	#`MFIL`,d0
		moveq	#0,d1
		bsr	SendMess

	clr.w	NoWait(a5)
		move.l	(a7)+,d0
		bra.w	.ReplyIt		;Message replyen

	*------- Ankommende Message sagt : "EXIT" -------*
.Exit:		move.w	#1,ExitNow(a5)
		bra.w	.ReplyIt		;Message replyen

	*----- Es wurde ein neue Config eingestellt -----*
.NewConfig:	move.w	EUS_Structure+EUS_Flags(pc),d0
		btst	#EUSF_Activate,d0
		beq.s	.Deactivate
		btst	#EUSF_Show,d0
		beq.s	.Iconify
		btst	#EUSF_ZipWin,d0
		bne.s	.ZipWindow
		bra.s	.OpenWindow

.Iconify:	bsr	CloseWin
		moveq	#USClass_Hide,d0
		bra.s	.ReplyIt

	*- Der Eagleplayer mchte gerne die Config haben -*
.GetConfig:	bsr	MerkWindowSize
		moveq	#USClass_GetConfig,d0
		bra.s	.ReplyIt



	*------ Ankommende Message sagt : "CLOSE MY WINDOW" -----*
.DeActivate:	moveq	#USClass_DeActivate,d7
.CloseWindow:	move.l	d7,-(a7)
		bsr	CloseWin
		move.l	(a7)+,d0
		bra.s	.ReplyIt

	*------ Angekommende Message sagt : "OPEN MY WINDOW" -----*
.Activate:
.OpenWindow:	move.l	EUS_Structure+EUS_EPBase(pc),a0
		move.l	EPG_SomePrefs(a0),d0
		btst	#EGPRF_Iconify,d0
		bne.s	.CloseWindow

		*move.w	EUS_Structure+EUS_Flags(pc),d0
		*btst	#EUSF_Show,d0
		*beq.s	.Activated
		tst.l	Winhandle(a5)
		bne.s	.Activated

		bsr.w	OpenWin
		tst.l	d0
		beq.s	.CloseWindow
		moveq	#USClass_Activate,d7
		bra.w	.NewModule

.Activated:	moveq	#USClass_Activate,d0
		bra.w	.ReplyIt

		*--- Im Eagleplayer "Help" gedrckt" ----*
.NewPreference:	cmp.l	#EPNr_Help,UM_Command(a1)
		bne.s	.ReplyIt
		bsr	ErlaubeGadgets
		bra.s	.ReplyIt

	*------ Ankommende Message sagt : "Zip my Window" -------*
.SaveConfig:	move.l	d7,-(a7)
		bsr	SaveConfig
		move.l	(a7)+,d0
		bra.s	.ReplyIt


.WaitPointer:	bsr	WaitPointer
		move.l	d7,d0
		bra.w	.ReplyIt

.ClearPointer:	bsr	ClearPointer
		move.l	d7,d0
		bra.w	.ReplyIt


	*------ Ankommende Message sagt : "Zip my Window" -------*
.ZipWindow:	*bsr.w	ZipMyWindow
		moveq	#USClass_ZipWin,d0
		bra.s	.ReplyIt

	*------ Ankommende Message sagt : "UnZip my Window" -----*
.UnZipWindow:	*bsr.w	UnZipMyWindow
		moveq	#USClass_UnZipWin,d0


	*------- Message frs Replyen vorbereiten ------*
	*----------------- Class setzen ----------------*
.ReplyIt:	bsr	ReplayIt
	endc
		rts


*-----------------------------------------------------------------------------*
* Die angegebene Msg wird replayed (auer wenn a1=0)
* Input: a1=Message oder NULL
*	 d0=Userclass
ReplayIt:	movem.l	d0-d7/a0/a2-a6,-(a7)
		bsr.w	FreeCommandStruct
		move.l	a1,d1
		beq.s	.NoMSG
		clr.l	UM_Argstring(A1)
		move.l	a1,a0
		*move.l	UM_StructAdr(a1),StructAdr(a5)
		move.w	d0,UM_Class(a1)			;Dummy setzen
.ReplyIt3:	move.l	a1,d0
		beq.s	.NoMSG
		move.l	MSgPort(a5),a0
		cmp.l	14(a1),a0		;Reply-Port vergleichen
		beq.w	.ClearMerk
		EB
		jsr	_LVOReplymsg(a6)
.NoMSG:		bra.s	.Return

.ClearMerk:	subq.l	#1,MsgUnterwegs(a5)
		bsr	Freemsg			;meine Message, also freigeben

.Return:	movem.l	(a7)+,d0-d7/a0/a2-a6
		sub.l	a1,a1
		rts

*-----------------------------------------------------------------------------*
MerkWindowSize:	movem.l	d0-a6,-(a7)
		lea	EUS_Structure(pc),a2
		move.w	EUS_Flags(a2),d0
		bclr	#EUSF_OpenWin,d0		*Flags
		move.l	WinHandle(a5),d1
		beq.s	.GetNoWindow
		or.w	#EUSB_OpenWin,d0

		move.w	WinPosX(a5),eus_winx(a2)	;Save Windowpostion
		move.w	WinPosY(a5),eus_winy(a2)
		move.w	WinWidth(a5),EUS_Special(a2)	;Save Windowpostion
		move.w	WinHeight(a5),EUS_Special+2(a2)
		move.w	ZoomposX(a5),Zoomx(a2)
		move.w	ZoomposY(A5),Zoomy(a2)
		move.b	Zoomstate(a5),ZoomONOFF(a2)
		*move.b	Onsysfont(A5),Sysfontonoff(a2)

.GetNoWindow:	move.w	d0,EUS_Flags(a2)
		movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
WaitPointer:	movem.l	a0/a1/a4/d0,-(a7)
		tst.l	WinHandle(a5)
		beq.s	.Return
		tst.w	WindowDisabled(a5)
		bne.s	.Return

		*--- Alle Menus disablen ---*
		*Input:a0=Window
		*      a1=Menu
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	WinHandle(a5),a0
		move.l	MenuAdr(a5),a1
		if	Executable!Debugger
		jsr	ENPP_SetWaitPointer(a4)
		endc

		move.w	#1,WindowDisabled(a5)

.Return:	movem.l	(sp)+,a0/a1/a4/d0
		rts


*-----------------------------------------------------------------------------*
ClearPointer:	movem.l	a0/a1/a4/d0,-(a7)
		tst.w	WindowDisabled(a5)
		beq.s	.Return

		*--- Alle Menus disablen ---*
		*Input:a0=Window
		*      a1=Menu
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	WinHandle(a5),a0
		move.l	MenuAdr(a5),a1
		if	Executable!Debugger
		jsr	ENPP_ClearWaitPointer(a4)
		endc

.Return:	clr.w	WindowDisabled(a5)
		movem.l	(sp)+,a0/a1/a4/d0
		rts





*------------------------------- TextRequest ---------------------------------*
* Input: d0=LocaleNummer						      *
*	 d1=GadgetLocaleNr
* Output:d0=GadgetNr							      *
*-----------------------------------------------------------------------------*
TextRequest:	movem.l	d1-a6,-(a7)
		bsr	GetLocaleString
		move.l	d0,a1				*Text

		bsr	GetReqToolsBase
		beq.s	.Return


		move.l	d1,d0
		bsr	GetLocaleString
		move.l	d0,a2				*Gadgets

		moveq	#LENr_RequestTitle,d0
		bsr	GetLocaleString

		lea	MyTags(a5),a0
		move.l	#_RT_Window,(a0)+
		move.l	WinHandle(a5),(a0)+
		move.l	#_RT_UnderScore,(a0)+
		move.l	#"_",(a0)+
		move.l	#RTEZ_ReqTitle,(a0)+
		move.l	d0,(a0)+
		clr.l	(a0)

		lea	MyTags(a5),a0			;Tags fr Textrequest
		lea	TextRequestArgs(a5),a4			;APTR to Arglist
		sub.l	a3,a3				;Reqtoolsinfo
		move.l	MyReqToolsBase(a5),a6
	*ifeq	Test
		jsr	_LVOrtEZRequestA(a6)		;ersetzen
	*else
	*	moveq	#0,d0
	*endc
.Return:	movem.l	(sp)+,d1-a6	
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: d0=Nummer
* Output:d0=Error oder NULL
*	 a0=Structure oder NULL
*-----------------------------------------------------------------------------*
GetSelectedStruct:
		movem.l	d1-d7/a1-a6,-(a7)
		move.l	SelectedEntry(a5),d0
		beq.s	.Error
		subq.l	#1,d0
		lea	Infolist(a5),a0
.GiveStruct:	move.l	(a0),d1
		beq.s	.Error
		move.l	d1,a0
		dbf	d0,.GiveStruct
		lea	-ML_Node(a0),a0
		moveq	#0,d0
.Return:	movem.l	(a7)+,d1-d7/a1-a6
		tst.l	d0
		rts

.Error:		moveq	#-1,d0
		sub.l	a0,a0
		bra.s	.Return



*----------------------- Listview-Gadget wurde gedrckt ----------------------*
Listview:	move.l	StartSeconds(a5),d0
		move.l	StartMicros(a5),d1
		move.l	CurrentSeconds(a5),d2
		move.l	CurrentMicros(a5),d3
		move.l	d2,StartSeconds(a5)
		move.l	d3,StartMicros(a5)
		move.l	SelectedEntry(a5),d4
		addq.l	#1,d5
		*move.l	d5,SelectedEntry(a5)


		*--- Wenn Eagleplayer im Helpmode ---*
		*--- Kommando an EP schicken fr  ---*
		*--- Helpnode                     ---*
		cmp.w	d4,d5
		bne.w	.EinfacherKlick
		move.l	IntBase(a5),a6
		jsr	_LVODoubleClick(a6)

	*------ Listviews & Stringgadgets refreshen ------*
		cmp.l	#1,d0			--> Einfacher Klick
		bne.w	.Return
		clr.l	StartSeconds(a5)
		clr.l	StartMicros(a5)

		bsr	Play
		bra.s	.Return

.EinfacherKlick:move.l	d5,d0			--> Nummer
		bsr.w	SetModulesEntry
.Return:	rts




*-----------------------------------------------------------------------------*
* Es wurde ein neuer Eintrag angewhlt.
* Input: d0=Neue Nummer (des angewhlten Labels)
SetModulesEntry:movem.l	d1-a6,-(a7)
		tst.l	WinHandle(a5)
		beq.w	.Return

		cmp.l	SelectedEntry(a5),d0
		beq.w	.Return
		move.l	d0,SelectedEntry(a5)


		*--- Gadgets sperren oder erlauben ---*
		*--- Anderen Anzeigelistviews fllen ---*
		subq.l	#1,d0
		lea	MyTags(a5),a3
		move.l	#GTLV_Selected,(a3)+
		move.l	d0,(a3)+
		move.l	#GTLV_MakeVisible,(a3)+
		move.l	d0,(a3)+
		clr.l	(a3)
		moveq	#EPENr_Infolist,d0
		bsr	GetGadgetAdr
		bne	.NoList
		lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)
.NoList
		bsr	ErlaubeGadgets

.Return:	movem.l	(a7)+,d1-a6
		rts


MIM	MACRO
	dc.w	\1,\2,\3-Jumpto
	dc.l	\4
	ENDM

MIRWB_Zahl	= 0
MIRWB_String	= 1
MIRWB_Zustand	= 2
MIRWB_Nothing	= 3	;dann bernimmt die Routine alles
MIRWB_TextToNodes = 4
MIRWB_OnlyResult = 5

MIRWF_Zahl	  = 1<<MIRWB_Zahl
MIRWF_String	  = 1<<MIRWB_String
MIRWF_Zustand	  = 1<<MIRWB_Zustand
MIRWF_Nothing	  = 1<<MIRWB_Nothing			;dann bernimmt die Routine alles
MIRWF_TextToNodes = 1<<MIRWB_TextToNodes
MIRWF_OnlyResult  = 1<<MIRWB_OnlyResult


*--------------------- Make a Liste fr Moduleinfo ---------------------------*
* Hier wird auch der Rest refreshed.
* Die Liste mu leer sein !!!
* Input: --
* Output:d0=Error oder NULL
MakeInfoList:	movem.l	d0-a6,-(a7)
		tst.b	ListeDa(a5)
		bne.w	.Return

		lea	Infolist(a5),a0
		newlist	a0

		tst.l	WinHandle(a5)
		beq.w	.Return



		*--- Listview updaten ---*
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		tst.l	EPG_PlayerTaglist(a4)
		beq.w	.PrintLength
		tst.w	KillAll(a5)
		bne.w	.PrintLength


		lea	MILIST-10(pc),a3
.Next:		move.l	EUS_Structure+EUS_EPBase(pc),a4
		lea	10(a3),a3
		tst.w	4(a3)
		beq.w	.PrintLength
		move.w	(a3),d0
		bsr	GetLocaleString
		move.l	d0,a2
		move.w	4(a3),d0
		lea	JumpTo(pc),a6
		lea	(a6,d0.w),a6

	*-- Einsprung in Routine
	*-- Input: a2=Adr fr LENr
	*--	   a4=EUS
	*--	   d1=Parameter
	*-- Output:d0=MIRW_Flags 
	*--	   d2=Zahl/Zustand
	*-- ODER!  a0=String
	*--	   a2=LENrText oder NULL (z.B. Zeiger auf "Creator:")
		move.l	6(a3),d1		;Tag
		move.w	2(a3),d0		;Einsprung
		move	4(a3),d6
		movem.l	a3-a6,-(a7)
		jsr	(a6)
		movem.l	(a7)+,a3-a6
		move.l	d0,d6
		btst	#MIRWB_Nothing,d6
		bne.s	.Next

		lea	TextPuffer(a5),a1
		move.w	#TextPufferSize-2,d1
		btst	#MIRWB_OnlyResult,d6
		bne.w	.String

		move.l	a0,-(a7)
		move.l	a2,a0
		bsr	StringCopy
		move.l	(a7)+,a0

		btst	#MIRWB_String,d6
		bne.w	.String

		cmp.l	#10,d1
		blo.s	.Next

		btst	#MIRWB_Zahl,d6
		bne.w	.Zahl
		btst	#MIRWB_Zustand,d6
		bne.w	.ZuStand
		bra.s	.Next

		*--- Zustand printen ---*
.Zustand:	moveq	#LENr_Ja,d0
		bsr	GetLocaleString
		tst.l	d2
		bne.s	.ZustandOk
		moveq	#LENr_Nein,d0
		bsr	GetLocaleString
.ZustandOk:	move.l	d0,a0
		bra.s	.String

		*--- Zahl printen ---*
.Zahl:		move.l	d2,d0
		bsr	Hexdez
		bra.s	.NimmTextPuffer

		*--- String printen ---*
.String:	cmp.l	a0,a1
		beq.s	.NimmTextPuffer
		bsr	StringCopy
.NimmTextPuffer:lea	TextPuffer(a5),a0
		lea	InfoList(a5),a4
		lea	AllocTheNode(pc),a6
		btst	#MIRWB_TextToNodes,d6
		beq.s	.NormalAlloc
		lea	TextToNodes(pc),a6
		lea	InfoList(a5),a1
.NormalAlloc:	jsr	(a6)
		*tst.l	d0
		*beq.s	.Error
		bra.w	.Next




		*--- Length (Size) setzen ---*
.PrintLength:	move.l	EUS_Structure+EUS_EPBase(pc),a4
		lea	Zerobytes(pc),a0
		moveq	#0,d0
		tst.w	KillAll(a5)
		bne.s	.NoSize
		move.l	EPG_Modulesize(a4),d0
		beq.s	.NoSize
		cmp.l	#-1,d0
		beq.s	.NoSize
		lea	TextPuffer(a5),a1
		bsr	Hexdez
		lea	TextPuffer(a5),a0
.NoSize:	lea	LengthPuffer(a5),a1
		move.w	#LengthPufferSize-2,d1
		bsr	StringCopy

		lea	LengthTags(pc),a3
		moveq	#EPENr_Length,d0
		bsr	GetGadgetAdr
		bne	.nolen
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)
.nolen

		*--- Name setzen ---*
		lea	FileTags(pc),a3
		moveq	#EPENr_Name,d0
		bsr	GetGadgetAdr
		bne	.noname
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)
.noname

		moveq	#0,d7
		bsr	UpdateInfos



.DasWars:	move.l	MaxEntries(a5),d0
		cmp.l	SelectedEntry(a5),d0
		bhi.s	.Ok
		move.l	d0,SelectedEntry(a5)
.Ok:


		moveq	#EPENr_Infolist,d0
		lea	InfoList(a5),a0
		bsr	ReAddlist
		move.b	#1,ListeDa(a5)

.Return:	movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
*MIRWF_Zahl	= 1
*MIRWF_String	= 2
*MIRWF_Zustand	= 4
*MIRWF_Nothing	= 8	;dann bernimmt die Routine alles
*MIRWF_TextToNodes = 16
*-----------------------------------------------------------------------------*
*	dc.w	LENr,Returnwert+Flags,Jump,ModinfoTag

MIList:	
		MIM	LENr_Soundsystem,MIRWF_String,G_Soundsystem,0
		MIM	LENr_Songname,MIRWF_String,G_NurModuleinfo,MI_Songname
		MIM	LENr_Author,MIRWF_String,G_NurModuleinfo,MI_Authorname
		MIM	LENr_Album,MIRWF_String,G_NurModuleinfo,MI_AlbumName
		MIM	LENr_Duration,0,G_Duration,EPG_Duration
		MIM	LENr_Year,MIRWF_String,G_NurModuleinfo,MI_Year
		MIM	LENr_Comment,MIRWF_String,G_NurModuleinfo,MI_Comment
		MIM	LENr_Genre,MIRWF_String,G_NurModuleinfo,MI_Genre

		MIM	LENr_Subsongs,MIRWF_Zahl,G_SubSong,MI_SubSongs
		MIM	0,MIRWF_String!MIRWF_TextToNodes,G_Leerzeile,0

		MIM	LENr_Loadsize,MIRWF_Zahl,G_NurModuleinfo,MI_LoadSize
		MIM	LENr_Calcsize,MIRWF_Zahl,G_NurModuleinfo,MI_CalcSize
		MIM	LENr_Songsize,MIRWF_Zahl,G_NurModuleinfo,MI_SongSize
		MIM	LENr_ChipSize,MIRWF_Zahl,G_NurModuleinfo,MI_ChipSize
		MIM	LENr_Othersize,MIRWF_Zahl,G_NurModuleinfo,MI_OtherSize
		MIM	LENr_Samplessize,MIRWF_Zahl,G_NurModuleinfo,MI_SamplesSize

		MIM	0,MIRWF_String!MIRWF_TextToNodes,G_Leerzeile2,0

		MIM	LENr_SamplesAnz,MIRWF_Zahl,G_NurModuleinfo,MI_Samples
		MIM	LENr_MaxSamples,MIRWF_Zahl,G_NurModuleinfo,MI_MaxSamples
		MIM	LENr_SynthSamples,MIRWF_Zahl,G_NurModuleinfo,MI_SynthSamples
		MIM	LENr_MaxSynthsamples,MIRWF_Zahl,G_NurModuleinfo,MI_MaxSynthSamples
		MIM	LENr_MaxSubSong,MIRWF_Zahl,G_NurModuleinfo,MI_MaxSubSongs
		MIM	LENr_Voices,MIRWF_Zahl,G_Voices,MI_Voices
		MIM	LENr_Maxvoices,MIRWF_Zahl,G_NurModuleinfo,MI_MaxVoices
		MIM	LENr_Length,MIRWF_Zahl,G_NurModuleinfo,MI_Length
		MIM	LENr_MaxLength,MIRWF_Zahl,G_NurModuleinfo,MI_MaxLength
		MIM	LENr_Steps,MIRWF_Zahl,G_NurModuleinfo,MI_Steps
		MIM	LENr_Maxsteps,MIRWF_Zahl,G_NurModuleinfo,MI_MaxSteps
		MIM	LENr_Patterns,MIRWF_Zahl,G_NurModuleinfo,MI_Pattern
		MIM	LENr_MaxPatterns,MIRWF_Zahl,G_NurModuleinfo,MI_MaxPattern

		MIM	0,MIRWF_String!MIRWF_TextToNodes,G_Leerzeile2,0

	MIM	LENr_Unpackedinfo,MIRWF_String,G_USSInfo,MI_UnpackedSystem
	MIM	LENr_Unpackedsystem,MIRWF_String,G_USoundsystem,MI_UnpackedSystem
		MIM	LENr_UnpackFilesize,MIRWF_Zahl,G_NurModuleInfo,MI_Unpacked
		MIM	LENr_Prefix,MIRWF_String,G_NurModuleinfo,MI_Prefix

*		MIM	0,MIRWF_String!MIRWF_TextToNodes,G_Leerzeile2,0

		MIM	LENr_Frequenz,MIRWF_Zahl,G_NurModuleinfo,MI_PlayFrequency
*		MIM	LENr_Bitrate,MIRWF_Zahl,G_NurModuleinfo,MI_Bitrate
		MIM	LENr_Boost,MIRWF_Zahl,G_NurModuleinfo,MI_Volumeboost
		MIM	LENr_Mode,MIRWF_Zahl,G_NurModuleinfo,MI_Playmode
		MIM	LENr_AboutReplayer,MIRWF_String!MIRWF_TextToNodes,G_NurModuleinfo,MI_About
*		MIM	LENr_AboutReplayer,MIRWF_String,G_NurModuleinfo,MI_About
*		MIM	LENr_Specialinfo,MIRWF_String!MIRWF_TextToNodes,G_NurModuleinfo,MI_SpecialInfo
		MIM	LENr_Specialinfo,MIRWF_String!MIRWF_TextToNodes,G_NurModuleinfo,MI_SpecialInfo
		MIM	LENr_ExtraInfo,MIRWF_String!MIRWF_TextToNodes,G_NurModuleinfo,MI_ExtraInfo

		* hat Enter mit drin
		MIM	LENr_Instrumentenliste,MIRWF_String,G_InitSampleinfo,0
		MIM	0,MIRWF_String,G_InsertSamples,0


		dc.w	0,0,0,0,0

*-----------------------------------------------------------------------------*
*MIRW_Zahl	= 1
*MIRW_String	= 2
*MIRW_Zustand	= 4
*MIRW_Nothing	= 8	;dann bernimmt die Routine alles
*MIRW_TextToNodes = 16
*-----------------------------------------------------------------------------*
G_Soundsystem:	move.l	EPG_Soundsystemname(a4),a0
		rts

*G_NurModuleinfo3:
* bra.s	g_nothing
* addq.w	#1,Zahler(a5)
*		rts
* nop
*G_NurModuleinfo2:
*	cmp.l	#MI_Bitrate,d1
*	bne.s	G_NurModuleInfo
*		nop
G_NurModuleinfo:move.l	d0,-(a7)
		move.l	d1,d0
		bsr	FindMITag
		move.l	d0,d2
		move.l	d0,a0
		move.l	(a7)+,d0
		tst.l	d2
		bne.s	.ok
		cmp.l	d2,a0
		beq.s	G_Nothing
.Ok:		btst	#MIRWB_String,d6
		beq.w	.NoString

		tst.b	(a0)			;Enforcer-Hit bei MI_Samples
		beq.s	G_Nothing
.NoString:	addq.w	#1,Zahler(a5)
		rts

G_Nothing:	moveq	#MIRWF_Nothing,d0
		rts


*G_AusGlobalsLong:
*		move.l	(a4,d1.w),d1
*		bne.s	.Return
**		moveq	#MIRWF_Nothing,d0
*.Return:	rts

G_Duration:	move.l	EPG_Duration(a4),d2
		beq.s	G_Nothing
		lea	TextPuffer(a5),a1
		move.l	a2,a0
		move.w	#TextPufferSize-2,d1
		bsr	StringCopy
		divu	#60,d2
		move.l	d2,d3
		ext.l	d2
		move.l	d2,d0
		bsr	Hexdez
		moveq	#LENr_min,d0
		bsr	GetLocalestring
		move.l	d0,a0
		bsr	Stringcopy
		move.l	d3,d0
		swap	d0
		ext.l	d0
		bsr	Hexdez
		moveq	#LENr_sec,d0
		bsr	GetLocalestring
		move.l	d0,a0
		bsr	Stringcopy
		moveq	#MIRWF_String!MIRWF_OnlyResult,d0
		lea	TextPuffer(a5),a0
		rts

G_USSInfo:	move.l	d1,d0
		bsr	FindMITag
		beq.s	G_Nothing
		move.l	a2,a0
		addq.l	#1,Zahler(a5)
		moveq	#MIRWF_String!MIRWF_OnlyResult,d0
		rts

G_USoundSystem:	move.l	d1,d0
		bsr	FindMITag
		beq.s	G_Nothing
		move.l	d0,d2
		cmp.l	#MIUS_SizeOF,d0
		bhi.s	.ok
		moveq	#LENr_OldSoundtracker,d0
		subq.l	#1,d2
		beq.s	.Ok2
		moveq	#LENr_Soundtracker,d0
		subq.l	#1,d2
		beq.s	.Ok2
		moveq	#LENr_Noisetracker,d0
		subq.l	#1,d2
		beq.s	.Ok2
		moveq	#LENr_ProTracker,d0
.Ok2:		bsr	GetLocaleString
.Ok:		move.l	d0,a0
		addq.w	#1,Zahler(a5)
		moveq	#MIRWF_String,d0
		rts

G_LeerZeile:	lea	Zerobytes(pc),a0
		move.l	a0,a2
		clr.w	Zahler(a5)
		rts

G_LeerZeile2:	tst.w	Zahler(a5)
		beq.w	G_Nothing
		lea	Zerobytes(pc),a0
		move.l	a0,a2
		clr.w	Zahler(a5)
		rts

G_Voices:	move.l	#MI_Voices,d0
		bsr	FindMITag
		bne.s	.Ja

		move.l	EPG_AmplifierTagList(a4),a6
		move.l	#EPAMT_NumStructs,d0
		bsr	FindTag
		bne.s	.Ja2

		moveq	#15,d2
		move.w	EPG_Voices(a4),d1
		beq.w	G_Nothing
		moveq	#0,d0
.NextVoice:	btst	d2,d1
		beq.s	.No
		addq.l	#1,d0
.No:		dbf	d2,.NextVoice

.Ja:		move.l	d0,d2
.Ja2:		moveq	#MIRWF_Zahl,d0
		addq.w	#1,Zahler(a5)
		rts


G_SubSong:	move.l	#MI_SubSongs,d0
		bsr	FindMITag
		bne.s	.Ja

		move.w	EPG_SubSongs(a4),d0
		ble.w	G_Nothing
.Ja		move.l	d0,d2
		moveq	#MIRWF_Zahl,d0
		rts

G_InitSampleinfo:
		tst.l	EPG_SampleInfoStructure(a4)
		beq.w	G_Nothing
		move.l	a2,a0
		moveq	#MIRWF_String!MIRWF_TextToNodes!MIRWF_OnlyResult,d0
		tst.w	Zahler(a5)
		bne.s	.Weiter
		addq.l	#1,a0
.Weiter:	rts


G_InsertSamples:move.l	EPG_SampleInfoStructure(a4),d0
		moveq	#0,d2
		moveq	#0,d1
.Next:		tst.l	d0
		beq.w	.G_Nothing
		move.l	d0,a3
		move.l	LA_Unknown(pc),a0
		move.l	EPS_Samplename(a3),d0
		*beq	.HoleNext		;(nur zur Sicherheit, sollte nicht vorkommen)
		beq.s	.KeinName
		move.l	d0,a0
.KeinName:
;		push	a2
;		move.l	a0,a2
;
;		move.w	EPS_Maxnamelen(A0),d0
;		subq	#1,d0
;		bmi.s	.end
;.zero
;		move.b	(A2)+,d1
;		beq.s	.end
;		cmp.b	#32,d1
;		blo.s	.no
;		dbf	d0,.zero
;		bra.s	.end
;.no		clr.b	-1(a2)
;.end
;		pop	a2

		bsr	GetTextlength

		cmp.l	d0,d2
		bhi.s	.NoHigher
		move.l	d0,d2

.NoHigher:	lea	InfoList(a5),a4
		bsr	AllocTheNode
		tst.l	d0
		beq.w	G_Nothing
		move.l	d0,a0
		move.l	a3,ML_SampleStruct(a0)

		*-- max Breite von "6536 Bytes" berechnen --*
		lea	TextPuffer(a5),a1
		move.l	EPS_Length(a3),d0
		bsr	Hexdez
		lea	TextPuffer(a5),a0
		bsr	NimmBiggerSize2
.HoleNext
		move.l	(a3),d0
		bra.s	.Next

.G_Nothing:	add.w	#15,d2
		move.w	d2,SampleWidth(a5)

		moveq	#LENr_Bytes,d0
		bsr	GetTextlength2
		add.l	d0,d1

		moveq	#LENr_KeinSample,d0
		bsr	GetLocaleString
		move.l	d0,a0
		bsr	NimmBiggerSize2

		moveq	#LENr_UnknownSize,d0
		bsr	GetLocaleString
		move.l	d0,a0
		bsr	NimmBiggerSize2

		move.w	d1,SamplebytesWidth(a5)

		bra.w	G_Nothing


*-----------------------------------------------------------------------------*
* Length,Pos,Time updaten
* Inout:d7=1, wenn vom Interrupt aus
UpdateInfos:	movem.l	d0-a6,-(a7)
		move.l	EUS_Structure+EUS_EPBase(pc),a4

		*--- Position setzen ---*
		lea	Striche3(pc),a0
		moveq	#0,d0
		tst.w	KillAll(a5)
		bne.s	.KeinePos

		move.l	#EP_GetPositionNr,d0
		bsr	FindPlTag
		bne.s	.Yes
		tst.l	d7
		bne.w	.PrintTime
		bra.s	.KeinePos
.Yes:		movem.l	d1-a6,-(a7)
		move.l	d0,a6
		move.l	a4,a5
		moveq	#0,d0
		jsr	(a6)
		movem.l	(a7)+,d1-a6
		tst.l	d7
		beq.s	.NoPosTest
		cmp.l	LastPos(a5),d0
		beq.w	.PrintTime
.NoPosTest:
		move.l	d0,LastPos(a5)
		lea	TextPuffer(a5),a1

;		cmp.b	#9,d0
;		bhi.w	.PO_High
;		move.b	#"0",(a1)+
;.PO_High:	cmp.b	#99,d0
;		bhi.w	.PO_High_2
;		move.b	#"0",(a1)+
;.PO_High_2:

		bsr	Hexdez

		lea	TextPuffer(a5),a0
.KeinePos:	lea	PositionPuffer(a5),a1
		move.w	#PositionPufferSize-2,d1
		bsr	StringCopy
		move.b	#"/",(a1)+

		move.l	a1,-(a7)
		lea	Striche3(pc),a0
		moveq	#0,d0
		tst.w	KillAll(a5)
		bne.s	.KeinePos2

		move.l	#MI_Length,d0
		bsr	FindMITag
		beq.s	.KeinePos2
		lea	TextPuffer(a5),a1
;		cmp.b	#9,d0
;		bhi.s	.PO_High2
;		move.b	#"0",(a1)+
;.PO_High2:	cmp.b	#99,d0
;		bhi.s	.PO_High2_2
;		move.b	#"0",(a1)+
;.PO_High2_2:
		bsr	Hexdez

		lea	TextPuffer(a5),a0
.KeinePos2:	move.l	(a7)+,a1
		bsr	StringCopy

		lea	PositionTags(pc),a3
		moveq	#EPENr_Position,d0
		bsr	GetGadgetAdr
		bne	.nopos
		*lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)
.nopos

		*-- Time setzen --*
.PrintTime:	lea	TimePuffer(a5),a1
		moveq	#0,d0
		tst.w	KillAll(a5)
		bne.s	.PrintTime2

		move.l	EPG_CurrentTime(a4),d0
		tst.l	d7
		beq.s	.PrintTime2
		cmp.l	LastTime(a5),d0
		beq.w	.Return
.PrintTime2:	move.l	d0,LastTime(a5)
		move.w	EUS_Structure+PrefsFlags(pc),d1
		btst	#PFB_Rueckwaerts,d1
		beq.s	.Normal
		move.l	EPG_Duration(a4),d1
		beq.s	.Normal
		sub.l	d0,d1
		move.l	d1,d0			;d0=Anz der Sekunden
		tst.l	d0
		blt.s	.return
		move.b	#"-",(a1)+

.Normal:	move.l	d0,d1
		divu	#60,d0
		move.l	d0,d2
		and.l	#$ffff,d0
		cmp.b	#9,d0
		bhi.s	.TN_High
		add.b	#`0`,d0
		move.b	d0,(a1)+
		bra.s	.TN_Lo
.TN_High:	bsr	Hexdez
.TN_Lo
		move.b	#":",(a1)+
		move.l	d2,d0
		swap	d0
		and.l	#$ffff,d0
		cmp.b	#9,d0
		bhi.s	.TN_High2
		move.b	#"0",(a1)+
.TN_High2:	bsr	Hexdez

		lea	TimePuffer(a5),a3
		move.l	a3,d0			;Pufferadresse
		sub.l	a1,d0			;- aktuelle Adresse = - Lnge
		add	#TimePufferSize-2,d0	;+ Gesamtlnge = zu fllender Rest
.clr		move.b	#` `,(a1)+
		dbf	d0,.clr
		clr.b	(a1)

		lea	TimeTags(pc),a3
		moveq	#EPENr_Time,d0
		bsr	GetGadgetAdr
		bne	.Return
		*lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

.Return:	movem.l	(a7)+,d0-a6
		rts

*--------- Hookfunktion, um aktuellen Amplifier  farblich hervorzuheben ------*
*---------------- derzeit noch kein Support fr "disabled"-Gadgets -----------*
*benutzte Globals:
* - grafsave+datas = Graphics Base
*
*Erkennung, ob Zeile hervorzuheben oder nicht:
* - EPG_ActiveAmplifier heranziehen und EUS_Creator vergleichen
*
* Input:a0:Hook
*	a1:Message
*	a2:Node
* Output:?
*-----------------------------------------------------------------------------*
Listview_Hook:	movem.l	d1-a6,-(a7)
		lea	Puffer,a5


	move.l	lvdm_MethodID(a1),d1
	cmp.l	#LV_Draw,d1
	bne.w	.Error
	move.l	a1,a4
	move.l	lvdm_RastPort(a4),d7
	beq.w	.Error

	move.l	lvdm_DrawInfo(A4),d0
	beq.w	.Error
	move.l	d0,a1
	move.l	dri_Pens(a1),a1

	move.l	ln_name(A2),a3
.textpen
	move	textpen*2(a1),d0		;SW
	*move	highlighttextpen*2(a1),d0	;Weiss
.high
	move	backgroundpen*2(a1),d6

	cmp.l	#LVR_SELECTED,lvdm_State(a4)
	bne.s	.normalBG

	move	FILLPEN*2(a1),d6
;	move	Filltextpen*2(a1),d0
.normalBG
	move	d6,d1
	moveq	#RP_Jam1,d2
	move.l	d7,a1
	move.l	GFXBase(a5),a6			;Graphics Base
	jsr	_LVOsetabpendrmd(A6)

	move.w	lvdm_bounds+ra_minx(a4),d0
	addq	#1,d0
	move.w	lvdm_bounds+ra_miny(a4),d1
	move.l	d7,a1
	add	rp_TxBaseline(a1),d1
	jsr	_LVOMove(A6)

	move.l	d7,a1
	moveq	#RP_Jam2,d0
	jsr	_LVOsetdrmd(A6)

	move.w	lvdm_bounds+ra_maxx(a4),d5		;Begrenzung des Textes
	sub	lvdm_bounds+ra_minx(a4),d5		;auf Breite des
	blt	.Error					;Listviews, solange

	move.l	a3,a0					;Text
	moveq	#-1,d3					;bis der Text passt
.lop1
	addq	#1,d3
	tst.b	(a0)+
	bne.s	.lop1
.charloop
	move.l	d7,a1
	move.l	a3,a0					;Text
	move.w	d3,d0
	jsr	_LVOtextlength(A6)
	cmp.w	d5,d0
	blt.s	.ok
	subq.w	#1,d3
	bra.s	.charloop
.ok
	move	d0,d4
	move.w	d3,d0
	move.l	a3,a0					;Text
	move.l	d7,a1
	jsr	_LVOtext(A6)

	move.l	d7,a1
	move	d6,d0
	move	d6,d1
	moveq	#0,d2
	jsr	_LVOsetabpendrmd(A6)

	move	lvdm_bounds+ra_minx(a4),d0
	add	d4,d0
	move	lvdm_bounds+ra_miny(a4),d1
	move	lvdm_bounds+ra_maxx(a4),d2
	move	lvdm_bounds+ra_maxy(a4),d3
	move.l	d7,a1
	jsr	_LVORectfill(a6)	;freien Platz nach dem Text lschen

*	bra.w	.NoSample

	*-------- Samplesize dahinter printen ---------*
		tst.l	ML_Samplestruct-ML_Node(a2)
		beq.w	.NoSample

		move.w	lvdm_bounds+ra_maxx(a4),d5	;Begrenzung des Textes
		sub	lvdm_bounds+ra_minx(a4),d5	;auf Breite des
		blt	.NoSample				;Listviews, solange
		sub.w	SampleWidth(a5),d5
		blt	.NoSample			;Listviews, solange


		cmp.w	SamplebytesWidth(a5),d5
		blo.w	.NoSample
		addq.l	#3,d5

		*--- Text zusammensetzen: "xyz Bytes " ----*
		lea	SampleBytePuffer(a5),a1
		move.w	#SampleBytePufferSize-2,d1
		move.l	ML_SampleStruct-ML_Node(a2),a3
		move.l	EPS_Length(a3),d0
		beq.s	.KeineSize
		cmp.l	#-1,d0
		beq.s	.UnknownSize
		bsr	Hexdez
		moveq	#LENr_Bytes,d0
		bra.s	.CopyRest
.UnknownSize:	moveq	#LENr_UnknownSize,d0
		bra.s	.CopyRest
.KeineSize:	moveq	#LENr_KeinSample,d0
.CopyRest:	bsr	GetLocaleString
		move.l	d0,a0
		bsr	StringCopy


		*--- Farben setzen ----*
		move.l	lvdm_DrawInfo(A4),a1
		move.l	dri_Pens(a1),a1
		move	textpen*2(a1),d0		;SW
		move	backgroundpen*2(a1),d6
		cmp.l	#LVR_SELECTED,lvdm_State(a4)
		bne.s	.normalBG2
		move	FILLPEN*2(a1),d6
	;	move	Filltextpen*2(a1),d0
.normalBG2:	move	d6,d1
		moveq	#RP_Jam1,d2
		move.l	d7,a1
		move.l	GFXBase(a5),a6			;Graphics Base
		jsr	_LVOsetabpendrmd(A6)



		*--- Position setzen -----*
*****
		lea	SampleBytePuffer(a5),a0
		bsr	GetTextlength
		move.w	lvdm_bounds+ra_maxx(a4),d1
		sub.w	d0,d1
		move.w	d1,d0
		subq.l	#3,d0
****

	*	move.w	lvdm_bounds+ra_minx(a4),d0
	*	add.w	SampleWidth(a5),d0
		move.w	lvdm_bounds+ra_miny(a4),d1
		move.l	d7,a1				;Rastport
		add	rp_TxBaseline(a1),d1
		jsr	_LVOMove(A6)

		move.l	d7,a1
		moveq	#RP_Jam2,d0
		jsr	_LVOsetdrmd(A6)

		*--- Lnge des Textes berechen ---*
		lea	SampleBytePuffer(a5),a0
		bsr	berechStringSize
		move.l	d0,d3

		*--- Mal schauen, wie viele Bytes da rein passen --*
.charloop2:	move.l	d7,a1
		lea	SampleBytePuffer(a5),a0
		move.w	d3,d0
		jsr	_LVOtextlength(A6)
		cmp.w	d5,d0
		blt.s	.ok2
		subq.w	#1,d3
		bra.s	.charloop2

.ok2:		move	d0,d4
		move.w	d3,d0
		lea	SampleBytePuffer(a5),a0		;Text
		move.l	d7,a1
		jsr	_LVOtext(A6)

		*-- farben zurcksetzen --*
		move.l	d7,a1
		move	d6,d0
		move	d6,d1
		moveq	#0,d2
		jsr	_LVOsetabpendrmd(A6)



	
.NoSample:	movem.l	(a7)+,d1-a6
		moveq	#LVCB_OK,d0
		rts

.Error:		movem.l	(a7)+,d1-a6
		moveq	#LVCB_Unknown,d0
		rts


*-----------------------------------------------------------------------------*
Titleaufbau:	movem.l	d0-a6,-(a7)
		tst.l	WinHandle(a5)
		beq.s	.Return

		moveq	#LENr_Windowtitle,d0
		bsr	GetLocaleString
		move.l	d0,a1
		move.l	EPBase(pc),a2
		move.l	EPG_TitlePuffer(a2),a2
		move.l	WinHandle(a5),a0
		move.l	INtBase(a5),a6
		jsr	_LVOSetWindowTitles(a6)

.Return:	movem.l	(a7)+,d0-a6
		rts

*------------------------------- Hexdez ----------------------------*
*---- Input:	d0=Hexzahl					----*
*----		d1=Flags	Bit 0: 1=Hidezero		----*
*----				Bit 1: 1=use negativ		----*
*----		a1=OutputPuffer					----*
*-------------------------------------------------------------------*
HexdezSigned:	movem.l	d0-d7/a0/a2-a6,-(a7)
		btst	#1,d1
		beq.s	.NoNegativ
		tst.l	d0
		bge.s	.NoNegativ
		move.b	#"-",(a1)+
		neg.l	d0
.NoNegativ:	*btst	#0,d1
		*beq.s	.HideZero
		*bsr.s	.Hexdez
		*bra.s	.Ok
.HideZero:	bsr	Hexdez
.Ok		movem.l	(a7)+,d0-d7/a0/a2-a6
		rts

*-----------------------------------------------------------------------------*
* Input: d0=Zahl
*	 a1=OutputPuffer
* Output:a1=Ende des Outputpuffers
*-----------------------------------------------------------------------------*
Hexdez:		tst.l	d0
		beq.s	.TypeNull
		movem.l	d0-d4/a0,-(a7)
		lea	hexdeztab(pc),a0
		moveq	#0,d4
		moveq	#9,d3
.HexDez1:	move.l	(a0)+,d1
		moveq	#0,d2
.HexDez2:	addq.l	#1,d2
		sub.l	d1,d0
		bcc.s	.Hexdez2
		add.l	d1,d0
		add.b	#$2f,d2
		cmp.b	#$30,d2
		bne.s	.Printealle
		tst.b	d4
		beq.s	.PrinteNoZiffer
.Printealle:	moveq	#1,d4
		move.b	d2,(a1)+
.PrinteNoZiffer:dbf	d3,.Hexdez1
		clr.b	(a1)
		movem.l	(a7)+,d0-d4/a0
		rts
.TypeNull	move.b	#$30,(a1)+
		clr.b	(a1)
		rts

	*-------- Hilfstabelle fr Hex-Dez-Umwandelung --------*
Hexdeztab:	dc.l	1000000000,100000000,10000000,1000000,100000,10000
		dc.l	1000,100,10,1

*-----------------------------------------------------------------------------*
ErlaubeGadgets:	movem.l	d0-a6,-(a7)
		move.l	WinHandle(a5),d0
		beq.s	.Return

		move.l	d0,a0
		move.l	IntBase(a5),a6
		jsr	_LVOClearMenuStrip(a6)

		*-- Gadgets setzen --*
		lea	.GG-6(pc),a3
.NextGadget:	lea	6(a3),a3
		tst.w	(a3)
		beq.s	.SetMenus
		lea	.GG(pc),a1
		move.w	2(a3),d0
		lea	(a1,d0.w),a1			*d1=Zustand der Nr.

		moveq	#0,d1
		move.l	EPBase(pc),a0
		move.l	EPG_SomePrefs(a0),d0
		btst	#EGPRF_Help,d0
		bne.s	.Help
		jsr	(a1)
.Help:		move.w	(a3),d0
		bsr	SetzeGadget
		move.w	4(a3),d0
		beq.s	.NextGadget
		bsr	.SetItem
		bra.s	.NextGadget

.SetMenus:	move.l	Winhandle(a5),a0
		move.l	MenuAdr(a5),a1
		move.l	IntBase(a5),a6
		jsr	_LVOSetMenuStrip(a6)

.Return:	bsr	Titleaufbau
		movem.l	(a7)+,d0-a6
		rts

	*------------ Menus setzen -------------*
	* Input d0=MenuNr
	*	d1=Zustand 1=Sperren 0=Enablen
.SetItem:	move.w	d0,d2
		and.w	#$1f,d2
		*subq.w	#1,d2
		lea	MenuAdr(a5),a0
.NextMenu:	move.l	(a0),d3
		beq.s	.Ret
		move.l	d3,a0
		dbf	d2,.NextMenu

		move.l	d0,d2
		and.l	#$7e0,d2
		lsr.l	#5,d2
		lea	MU_FirstItem(a0),a0
.NextItem:	move.l	(a0),d3
		beq.s	.Ret
		move.l	d3,a0
		dbf	d2,.NextItem

		move.l	d0,d2
		and.l	#$f800,d2
		cmp.l	#$f800,d2
		beq.s	.NoSubMenu
		lsr.l	#8,d2
		lsr.l	#3,d2
		lea	MI_SubItem(a0),a0
.NextSubItem:	move.l	(a0),d3
		beq.s	.Ret
		move.l	d3,a0
		dbf	d2,.NextSubItem

.NoSubMenu:	move	mi_Flags(a0),d0
		and	#~ITEMENABLED,d0
		tst.w	d1
		bne.s	.Off
		or	#ITEMENABLED,d0
.Off:		move	d0,mi_Flags(a0)
.Ret:		rts

* d1=0 -> on
.GG:
		dc.w	EPENr_Slider,GGZS_NurPlaySamples-.GG,0
		dc.w	EPENr_SaveSample,GGZS_NurSaveSamples-.GG,0
		dc.w	-1,GGZS_NurPlaySamples-.GG,MNr_Play
		dc.w	-1,GGZS_WhenPlaying-.GG,MNr_Stop
		dc.w	-1,GGZS_NurSaveSamples-.GG,MNr_SaveSample
		dc.w	-1,GGZS_WhenModLoaded-.GG,MNr_Modulecont
		dc.w	0


GGZS_NurPlaySamples:
		moveq	#1,d1
		bsr	GetSelectedStruct
		bne.s	.Return
		move.l	ML_SampleStruct(a0),d0
		beq.s	.Return
		move.l	d0,a0
		tst.l	EPS_Adr(a0)
		beq.s	.Return
		tst.l	EPS_Length(a0)
		beq.s	.Return
		move.w	EPS_Flags(a0),d0
		btst	#USIF_PlayAble,d0
		beq.s	.Return
		moveq	#0,d1
.Return:	rts

GGZS_NurSaveSamples:
		moveq	#1,d1
		bsr	GetSelectedStruct
		bne.s	.Return
		move.l	ML_SampleStruct(a0),d0
		beq.s	.Return
		move.l	d0,a0
		tst.l	EPS_Adr(a0)
		beq.s	.Return
		tst.l	EPS_Length(a0)
		beq.s	.Return
		move.w	EPS_Flags(a0),d0
		btst	#USIF_Saveable,d0
		beq.s	.Return
		moveq	#0,d1
.Return:	rts

GGZS_WhenPlaying:
		moveq	#1,d1
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_PlayerTaglist(a4),a6
		move.l	#EP_SamplePlayer,d0
		bsr	FindTag
		beq.s	.Return
		moveq	#0,d1
.Return		rts

GGZS_WhenModLoaded:
		moveq	#1,d1
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		tst.l	EPG_PlayerTaglist(a4)
		beq.s	.Return
		move.l	EPG_SomePrefs(a4),d0
		btst	#EGPRF_NowPlay,d0
		beq.s	.Return
		moveq	#0,d1
.Return		rts

*---------------------------- Setze dieses Gadget ----------------------------*
* Input: d0=Nummer des Gadgets
*	 d1=Zustand 0=on 1=off
*-----------------------------------------------------------------------------*
SetzeGadget:	movem.l	d0-a6,-(a7)
		tst.l	WinHandle(a5)
		beq.s	.Return

		bsr	GetGadgetAdr			*a0=Gadgetadr
		bne.s	.Return
		lea	MyTags(a5),a3
		move.l	#GA_Disabled,(a3)+
		move.l	d1,(a3)+
		clr.l	(a3)
		lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)
		
.Return:
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
UpdateMenus:	movem.l	d0-a6,-(a7)
		move.w	EUS_Structure+PrefsFlags(pc),d0


		move.w	#CHECKIT!Menutoggle,d1
		btst	#PFB_BackPic,d0
		beq.s	.NoBackPic
		or.w	#CHECKED,d1
.NoBackPic:	move.w	d1,BackPicFlags

		move.w	#CHECKIT!CHECKED,d1
		move.w	#CHECKIT,d2
		btst	#PFB_Rueckwaerts,d0
		beq.s	.NoRueckwaerts
		exg	d1,d2
.NoRueckwaerts:	move.w	d1,TimeVorwFlags
		move.w	d2,TimeRueckFlags

		move.w	#CHECKIT!Menutoggle,d1
		btst	#PFB_SampleSaverOn,d0
		beq.s	.NoSamplesaveron
		or.w	#CHECKED,d1
.NoSamplesaveron:
		move.w	d1,SampleSaverOnFlags

		movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
OpenWin:	movem.l	d1-a6,-(a7)
		lea	Puffer,a5
		tst.l	WinHandle(a5)
		bne.s	.WindowDa

		st	LastWidth(A5)
		st	LastHeight(a5)

		bsr	UpdateMenus

		move.l	Intbase(a5),a6
		bsr	LockPubscreen		;Public Screen holen
		bne	.Error
		bsr	SetUpWin		;Fenster ffnen
		tst.l	d0
		bne.w	.Error
.Error:	
.WindowDa	move.l	WinHandle(a5),d0
		movem.l	(a7)+,d1-a6
		rts


*-----------------------------------------------------------------------------*
* Fenster ffnen, mit Menu & Gadgets sowie Sizeanpassung		      *
* Input: --								      *
* Output: d0=Error oder NULL						      *
*-----------------------------------------------------------------------------*
SetUpWin:	movem.l d1-a6,-(sp)

		bsr	InitLocale

		move.l	MyPubscreen(a5),d0
		beq.w	.Error
		move.l	d0,a0
		move.l	SC_Font(a0),a1
		move.w	TA_YSize(a1),d3
		addq.w	#1,d3
		move.b	sc_WBorTop(a0),d0
		ext.w	d0
		add.w	d3,d0
		move.w	d0,OffY(a5)

		move.b  SC_WBorLeft(a0),d0
		ext.w   d0
		move.w	d0,Offx(a5)

		bsr	GetFont
		beq	.Error
;		move.l	sc_RastPort+rp_Font(a0),a0
		move.l	d0,a0

		lea	MyFont(a5),a1
		move.l	a1,Font(a5)
		move.l  LN_Name(a0),ta_Name(a1)
		move.w  tf_YSize(a0),ta_YSize(a1)
		move.w  tf_XSize(a0),FontX(a5)
		move.w  tf_YSize(a0),FontY(a5)
		clr.w	6(a1)

		bsr	BerechMinWindowSize


	*--------------- Gre des Fensters festlegen --------------*
		moveq	#0,d2
		moveq	#0,d3
		move.w	EUS_Structure+EUS_Special(pc),d2
		move.w	EUS_Structure+EUS_Special+2(pc),d3
		bne.s	.NimmDiese

		moveq	#0,d0			*Keine Eintragung
		move.w	FontY(a5),d0		*--> Fonthhe *6
		mulu	#6,d0
		add.w	d0,d3
		move.l	#200,d2

		*----- Ist diese Gre erlaubt ? -----*
.NimmDiese:	cmp.w	Win_MinHeight+2(pc),d3
		bhi.s	.HeightOk
		move.l	Win_MinHeight(pc),d3
.HeightOk:	cmp.w	Win_MinWidth+2(pc),d2
		bhi.s	.WidthOk
		move.l	Win_MinWidth(pc),d2
.WidthOk:	move.l	mypubscreen(A5),a0
		move.l	d2,ahawidth
		move.l	d3,ahaheight

		*--- Pat Window in Screen ---*
		move.l	d2,d0
		move.l	d0,d4
		moveq	#0,d2
		add.w	d2,d0
		add.w	OffX(a5),d0
		move.b	sc_WBorRight(a0),d1
		ext.w	d1
		add.w	d1,d0
		cmp.w	sc_Width(a0),d0
		bls.s	.WinWidthOk
		move.w	sc_Width(a0),d0
		sub.w	d4,d0
		move.w	d0,d2			*-> nein, jetzt
.WinWidthOk:	move.l	d3,d0
		move.l	d0,d4

		*-- Menus creieren ---*
		move.l	GadBase(a5),a6
		lea	Menus(pc),a0
		lea	MenuTags(pc),a1
		jsr	_LVOCreateMenusA(a6)
		move.l	d0,MenuAdr(a5)
		tst.l	d0
		beq	.Error
		move.l	d0,a0
		move.l	VisualInfo(a5),a1
		lea	MenuTags(pc),a2
		jsr	_LVOLayoutMenusA(a6)

		moveq	#0,d0
		moveq	#0,d1
		moveq	#0,d2
		moveq	#0,d3
		moveq	#0,d7
		move	WinPosX(a5),d0
		move	WinPosY(a5),d1
		move	ZoomPosX(a5),d2
		move	ZoomPosY(a5),d3
		move.l	ahawidth(pc),d4
		move.l	ahaheight(pc),d5
		*move.l	#ZoomWidth,d6

		move.l	mypubscreen(A5),a0
		lea	sc_RastPort(a0),a0
		move.l	rp_Font(a0),a0
		move.w  tf_XSize(a0),d6
		mulu	#ZoomWidth,d6
		addq	#4,d6
		lsr	#3,d6
		move	OffY(a5),d7
		tst.b	ZoomState(a5)
		beq.s	.Normal
		exg.l	d0,d2
		exg.l	d1,d3
		exg.l	d4,d6
		exg.l	d5,d7
.normal:	lea	WindowTags(pc),a1
		move.l	d0,Win_LeftPos-WindowTags(A1)
		move.l	d1,Win_TopPos-WindowTags(A1)
		move.l	d4,Win_Width-WindowTags(A1)
		move.l	d5,Win_Height-WindowTags(A1)
		move.w	d2,ZoomStruct-WindowTags(A1)
		move.w	d3,ZoomStruct+2-WindowTags(A1)
		move	d6,ZoomStruct+4-WindowTags(A1)
		move	d7,ZoomStruct+6-WindowTags(A1)

		move.l	IntBase(A5),a6
		move.l	MyPubScreen(a5),Pubadr-WindowTags(a1)
		suba.l	a0,a0
		jsr	_LVOOpenWindowTagList(a6)
		move.l	d0,Winhandle(a5)
		tst.l	d0
		beq	.OpenWindowError

		move.l	WinHandle(a5),a0
		move.w	wd_leftedge(a0),WinPosX(a5)
		move.w	wd_topedge(a0),WinPosY(a5)
		move.w	wd_Width(a0),WinWidth(a5)
		move.w	wd_Height(a0),WinHeight(a5)

		move.l	d0,a0
		move.l	WD_RPort(a0),a0
		move.l	a0,MyRastPort(a5)

		bsr	InitBackdrop


		if	BackPicture
		bsr	ClearWindow
		endc

		bsr	InitGadgets
		bne	.GadgetError

		bsr	RedrawGadgets

		bsr	AddGads
		bne	.GadgetError

		bsr	ErlaubeGadgets


		move.l	Winhandle(a5),a0
		move.l	MenuAdr(a5),a1
		jsr	_LVOSetMenuStrip(a6)

		move.l	Winhandle(a5),a0
		move.l	WD_Userport(a0),a0	;User Port
		move.l	a0,WindowPort(a5)
		moveq	#0,d0

	*--------------- SignalBits setzen ---------------*
		move.l	SignalBits(a5),d6
		moveq	#0,d0
		move.b	15(a0),d0
		bset	d0,d6
		move.l	d6,SignalBits(a5)
		moveq	#0,d0


.SetUpReturn:	movem.l	(sp)+,d1-a6
		tst.l	d0
		rts

.GadgetError	bsr	Closedownwindow
.OpenWindowError:bsr	FreeMenus
.Error:		moveq	#EPR_UnknownError,d0
		bra.s	.SetUpReturn




*----------------------------- Window lschen --------------------------------*
ClearWindow:	movem.l	d0-a6,-(a7)
		tst.l	WinHandle(a5)
		beq.w	.Return
		tst.l	MyRastPort(a5)
		beq.w	.Return

		tst.l	DT_PicObject(a5)
		bne	.DT_CopyTiledBitMap

		move.l	winhandle(A5),a1
		move.w	wd_width(A1),d2		;x2
		moveq	#0,d0
		move.b	wd_borderright(a1),d0
		sub.w	d0,d2

		move.w	wd_height(a1),d3
		moveq	#0,d0
		move.b	wd_borderbottom(a1),d0
		sub.w	d0,d3

		move.w	Offx(a5),d0		;x1
		move.w	Offy(A5),d1		;y1

		bsr	ClearRectangle
		bra.s	.Refresh

.DT_CopyTiledBitMap:
		bsr	FillWithBackPic
.Refresh:
		move.l	winhandle(A5),a0
		move.l	IntBase(a5),a6
		jsr	_LVORefreshwindowframe(A6)

.Return:	movem.l	(a7)+,d0-a6
		rts

*--------------- lscht den angegebenen Bereich --------------------*
* Input: D0 = Leftedge
*        D1 = Topedge
*        D2 = Width
*        D3 = Height
ClearRectangle:
		push	all
		move.l	GFXBase(a5),a6

		move.l	Winhandle(a5),d4
		beq	.fail
		move.l	d4,a1

		push	d0-d3

		move.l	wd_rport(a1),a1
		move.l	a1,a3
		moveq	#0,d0
		jsr	_LVOsetapen(a6)

		move.l	a3,a1
		moveq	#0,d0
		jsr	_LVOsetbpen(A6)

		move.l	a3,a1
		moveq	#1,d0			;RP_Jam2
		jsr	_LVOsetdrmd(a6)

		pop	d0-d3
		add	d0,d2
		add	d1,d3
		move.l	a3,a1
		jsr	_LVOrectfill(a6)
.fail
		pop	all
		rts

*-----------------------------------------------------------------------------*
*        Alle Gadgets, die Text enthalten lschen wg. Hintergrundbild         *
*        die Positionen werden aus den NewGadget-Strukturen gezogen           *
*-----------------------------------------------------------------------------*
RedrawGadgets:
		push	all
		lea	Refreshed_Gads(pc),a4
.loop
		move.l	(a4)+,d0		;Adresse Gadget
		beq	.return
		move.l	d0,a0

		move.w	(a4)+,d1		;Flagbit holen, Indikator ob an oder aus
		move	d1,d2
		and	#$7fff,d1
		beq.s	.doit			;Fehler
		and	PrefsFlags+EUS_Structure(pc),d1
		beq	.loop			;Gadget ist aus...
.doit
		move.w	gng_LeftEdge(a0),d0

		move.w	gng_TopEdge(a0),d1
		add.w	OffY(a5),d1
		addq.w	#GadgetYAbstand,d1

		add.w	OffX(a5),d0
		addq.w	#GadgetXAbstand,d0

		moveq	#0,d3
		move.w	gng_Height(a0),d3
		and	#$8000,d2
		beq.s	.nolist
		sub	#ListviewBorder,d3
		move.l	font(a5),a1
		move	ta_ysize(a1),d2
		divu	d2,d3
		mulu	d2,d3
		add	#ListviewBorder,d3
.nolist
		move.w	gng_Width(a0),d2
		bsr	ClearRectangle

		bra	.loop
.return
		pop	all
		rts
*-----------------------------------------------------------------------------*
* Init Backdrop (fr OpenWindow)
*-----------------------------------------------------------------------------*
InitBackdrop:	movem.l	d0-a6,-(a7)

	*-------- Halfshine Pen fr Hintergrund anfordern oder Pic Init ----------------*
		move.l	#-1,mypen(A5)

		move.w	PrefsFlags+EUS_Structure(pc),d0
		and.b	#PFF_BackPic,d0		;Bit 1 = Back Pic
		beq.s	.pen

		bsr	DT_OpenPicture		;Bild ffnen
		bne.s	.Return			;bei Fehler dann doch Pen
.pen
		move.l	GFXBase(A5),a6
		cmp.w	#39,lib_version(A6)
		blo	.Return

		move.l	MyPubScreen(a5),a0
		move.l	sc_viewport+vp_colormap(a0),a0	;Viewport->Colormap
		move.l	a0,mycmap(A5)
		moveq	#-1,d0			;Number
		move.l	#123<<24,d1		;Red
		move.l	#123<<24,d2		;Green
		move.l	#123<<24,d3		;Blue

		lea	Mytags(A5),a1
		move.l	#OBP_Precision,(a1)
		move.l	#PRECISION_GUI,4(a1)
		clr.l	8(A1)
		jsr	_LVOObtainBestPenA(A6)
		move.l	d0,MyPen(a5)

.Return:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
FillWithBackPic:
*		tst.l	DT_PicObject(a5)
*		bne	.DT_CopyTiledBitMap
*		movem.l	d0-a6,-(a7)
*		move.l	WinHandle(a5),a4
*		move.l	WD_RPort(a4),a1
*
*		move.l	myPen(a5),d0
*		bpl.s	.yup
*		moveq	#0,d0
*.yup
*		move.l	GFXBase(a5),a6
*		jsr	_LVOSetAPen(a6)			; set the pen
*
*		*move.l	winhandle(A5),a1
*		*move.l	wd_rport(a1),a1
*		*moveq	#1,d0
*		*jsr	_LVOsetbpen(A6)
*
*
*		move.l	wd_rPort(a4),a1
*		move.b	wd_borderleft(a4),d0
*		ext.w	d0
*		move.b	wd_bordertop(a4),d1
*		ext.w	d1
*		move.b	wd_borderright(a4),d2
*		ext.w	d2
*		neg.w	d2
*		move.b	wd_borderbottom(a4),d3
*		ext.w	d3
*		neg.w	d3
*		subq	#1,d2
*		subq	#1,d3
*		add.w	wd_width(a4),d2
*		add.w	wd_height(a4),d3
*
*		move.l	GFXBase(a5),a6
*		jsr	_LVOrectfill(a6)		;Hintergrund killen
*
*		movem.l	(a7)+,d0-a6
*		rts


;void CopyTiledBitMap(void)
;Slow but Mem-Saving routine
.DT_CopyTiledBitMap:
		push	d1-d7/a1/a3/a4/a6
		move.l	GFXBase(a5),a6

		move.l	Winhandle(A5),a0
		moveq	#0,d0
		moveq	#0,d1
		move.w	wd_width(a0),d0
		move.b	wd_borderleft(A0),d1
		add.b	wd_borderRight(A0),d1
		sub.l	d1,d0
		move.l	d0,DT_Breit2(A5)
		
		move.w	wd_height(a0),d0
		move.b	wd_bordertop(A0),d1
		add.b	wd_borderbottom(A0),d1
		sub.l	d1,d0
		move.l	d0,DT_Hoehe2(A5)

		moveq	#0,d0
		move.b	wd_borderleft(a0),d0
		move.l	d0,DT_XPos2(a5)

		move.b	wd_borderTop(a0),d0
		move.l	d0,DT_YPos2(a5)

		move.l	DT_MyBitMapheader(a5),a0
		moveq	#0,d0
		move.w	(a0)+,d0
		move.l	d0,a4			; SrcSizeX
		move.w	(a0),d0
		move.l	d0,a3			; SrcSizeY

		moveq	#256-$c0,d6
		neg.b	d6

		move.l	Winhandle(A5),a1
		move.l	WD_Rport(a1),a1
		move.l	a1,-(sp)

		moveq	#0,d2				; dest x
		moveq	#0,d3				; dest y
.MainLoop
		move.l	a4,d4				; SrcSizeX

		move.l	d2,d7				; dest x
		cmp.l	DT_Breit2(A5),d7		; Row copied ?
		blt.s	.Xweit
		add.l	a3,d3				; Yup, next Row
		moveq	#0,d2				; dest x
		moveq	#0,d7
.XWeit
		add.l	d4,d7				; pos x + SrcSizeX
		cmp.l	DT_Breit2(a5),d7		; dest x (left) < DestX+SrcSizeX ?
		blt.s	.skip1
		move.l	DT_Breit2(A5),d4		; DestSizeX
		sub.l	d2,d4				; - Dest X = Dest Left
.skip1		
		move.l	a3,d5
		move.l	d3,d7
		cmp.l	DT_Hoehe2(A5),d7
		bge.s	.YReady
		add.l	d5,d7				; pos y + SrcSizeY
		cmp.l	DT_Hoehe2(a5),d7		; dest y (left) < DestY+SrcSizeY ?
		blt.s	.skip2
		move.l	DT_Hoehe2(A5),d5		; DestSizeY
		sub.l	d3,d5				; - Dest Y = Dest Left
.skip2
		add.l	DT_XPos2(A5),d2			; Xpos + Winborder
		add.l	DT_YPos2(A5),d3			; YPos + Winborder
		move.l	(sp),a1
		move.l	DT_MyBitMap(a5),a0		; Source
		moveq	#0,d0
		moveq	#0,d1
		jsr	_LVOBltBitMapRastport(a6)
		sub.l	DT_XPos2(A5),d2			; del Border
		sub.l	DT_YPos2(A5),d3			; del Border
		add.l	a4,d2
		bra.s	.Mainloop

.YReady:	addq.l	#4,sp
		pop	d1-d7/a1/a3/a4/a6
		rts


*-----------------------------------------------------------------------------*
LoadNewPicture:	movem.l	d0-a6,-(a7)

	*-------- Bild freigeben (wenn vorhanden) -----------------------*
.RetryPic:	bsr	DT_FreePicture

	*-------- Halfshine Pen fr Gadgets freigeben -------------------*
		move.l	GFXBase(a5),a6
		cmp.w	#39,lib_version(A6)
		blo	.kick20
		move.l	mypen(A5),d0
		move.l	mycmap(A5),a0
		jsr	_LVOReleasepen(A6)

	*-------- Halfshine Pen fr Hintergrund anfordern oder Pic Init ----------------*
.Kick20		move.l	#-1,mypen(A5)

		move.w	EUS_Structure+PrefsFlags(pc),d0
		and.w	#PFF_BackPic,d0		;Bit 1 = Back Pic
		beq.s	.pen

		bsr	DT_OpenPicture		;Bild ffnen
		bne.s	.kick2			;bei Fehler dann doch Pen
.pen
		move.l	GFXBase(a5),a6
		cmp.w	#39,lib_version(a6)
		blo	.kick2

		move.l	MyPubScreen(a5),a0
		move.l	sc_viewport+vp_colormap(a0),a0	;Viewport->Colormap
		move.l	a0,mycmap(a5)
		moveq	#-1,d0			;Number
		move.l	#123<<24,d1		;Red
		move.l	#123<<24,d2		;Green
		move.l	#123<<24,d3		;Blue

		lea	mytags(A5),a1
		move.l	#OBP_Precision,(a1)
		move.l	#PRECISION_GUI,4(a1)
		clr.l	8(A1)
		jsr	_LVOObtainBestPenA(A6)
		move.l	d0,mypen(A5)
.Kick2		bsr	Resizewindow
.Return:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Gibt des Backpic frei
DT_FreePicture:	movem.l	d0-a6,-(a7)

		move.l	DT_PicObject(A5),d0
		beq.s	.fail
		move.l	DatatypesBase(a5),a6
		move.l	d0,a0
		jsr	_LVODisposeDTObject(a6)
		clr.l	DT_PicObject(A5)
		clr.l	DT_MyBitMapheader(a5)
		clr.l	DT_MyBitMap(a5)
.fail		moveq	#0,d0
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input:	d0=LocaleNr fr Title des Requesters
*		a0=Dir
*		a1=Filename
* Output:d0=Null=Error d0<>0 ok (MultiSelectZeiger)
*-----------------------------------------------------------------------------*
DT_MultiFileRequest2:
		movem.l	d1-a6,-(a7)
		move.l	#FREQF_MULTISELECT,d6
		bra.s	DT_FileReq2

DT_MultiFileRequest:
		movem.l	d1-a6,-(a7)
		move.l	#FREQF_MULTISELECT!FREQF_SELECTDIRS,d6
		bra.s	DT_FileReq2

DT_Filerequest:	movem.l	d1-a6,-(a7)
		moveq	#0,d6
DT_FileReq2:

	move.l	a0,a3
	move.l	a1,a2
	move.l	d0,d4
		bsr	GetReqToolsBase
		beq.s	.Return

		sub.l	a0,a0
		moveq	#0,d0				;Struktur-Type
		jsr	_LVORTAllocRequestA(a6)
		move.l	d0,d7
		beq.s	.fail

		lea	mytags(A5),a0
		move.l	#_RTFI_Dir,(A0)+
		move.l	a3,(a0)+
		clr.l	(A0)	
		lea	mytags(A5),a0
		move.l	d7,a1
		jsr	_LVORTchangereqattrA(A6)

		move.l	d4,d0
		bsr	GetLocaleString
		move.l	a3,-(a7)
		move.l	d0,a3
		lea	mytags(A5),a0
		move.l	#_RT_Window,(a0)+
		move.l	winhandle(a5),(a0)+
		tst.l	d6
		beq.s	.NoFlags
		move.l	#_RTFI_Flags,(a0)+
		move.l	d6,(a0)+
.NoFlags:
	;	move.l	#_RT_LockWindow,(a0)+
	;	move.l	#1,(a0)+
		clr.l	(A0)
		lea	mytags(A5),a0
		move.l	d7,a1
		jsr	_LVORTFilerequestA(A6)
		move.l	(a7)+,a3
		move.l	d0,d6

		move.l	d7,a0
		move.l	rtfi_Dir(a0),a0
		lea	(a3),a1
		move.w	#200-1,d1
		bsr	StringCopy

		move.l	d7,a1
		jsr	_LVORTFreerequest(A6)
		move.l	d6,d0

.Fail:
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts



*-----------------------------------------------------------------------------*
DT_OpenPicture:	movem.l	d1-a6,-(a7)

		moveq	#0,d0
		move.l	DT_PicObject(a5),d1
		bne.w	.fail
		move.l	winhandle(a5),d0
		beq.w	.fail

		move.l	DatatypesBase(a5),d0
		bne.w	.Ok
		lea	Datatypesname(pc),a1
		moveq	#39,d0
		EB
		jsr	_LVOopenlibrary(a6)
		move.l	d0,DatatypesBase(a5)
		tst.l	d0
		beq.w	.Fail
.Ok:


		lea	DT_Picture(a5),a0
		lea	DT_Picturedir(a5),a1
.copy		move.b	(a1)+,(a0)+
		bne.s	.copy
		subq.l	#1,a1

		lea	DT_Picture(a5),a0
		move.l	a0,d1
		lea	DT_Picturename(a5),a0
		move.l	a0,d2
		move.l	#300,d3
		move.l	DosBase(a5),a6
		jsr	_LVOAddPart(A6)

		move.l	DatatypesBase(a5),a6
		lea	mytags(A5),a0
		move.l	#DTA_Sourcetype,(a0)+
		move.l	#DTST_File,(a0)+
		move.l	#DTA_GroupID,(a0)+
		move.l	#GID_Picture,(a0)+
		move.l	#PDTA_Remap,(a0)+
		move.l	#1,(a0)+
		move.l	#PDTA_Screen,(a0)+
		move.l	winhandle(A5),a1
		move.l	wd_WScreen(a1),(a0)+
		move.l	#PDTA_FreeSourceBitMap,(a0)+
		move.l	#1,(a0)+
		move.l	#OBP_Precision,(a0)+
		move.l	#Precision_IMAGE,(A0)+
		clr.l	(a0)+
		lea	mytags(A5),a0

		*ifne	test
		*lea	DT_PicName(pc),a1
		*else
		lea	DT_Picture(a5),a1
		*endc
		move.l	a1,d0
		jsr	_LVONewDTObjectA(A6)
		move.l	d0,DT_PicObject(A5)
		beq.w	.fail

		move.l	#1,-(a7)		;Taglist ??
		move.l	#0,-(a7)		;
		move.l	#DTM_ProcLayout,-(a7)	;
		push	d0
		bsr	_DoMethod	
		add	#4*4,sp
		tst.l	d0
		beq	DT_FreePicture

		lea	mytags(A5),a2
		move.l	#PDTA_BitMapHeader,(a2)+
		lea	DT_MyBitMapheader(a5),a0
		move.l	a0,(a2)+
		move.l	#PDTA_DestBitMap,(a2)+
		lea	DT_MyBitMap(a5),a0
		move.l	a0,(A2)+
		clr.l	(A2)
		lea	mytags(A5),a2
		move.l	DT_PicObject(A5),a0
		move.l	DatatypesBase(a5),a6
		jsr	_LVOGetDTAttrsA(A6)
		cmp.l	#1,d0
		blt	DT_FreePicture
		tst.l	DT_MyBitMap(A5)
		bne.s	.attrok

		lea	mytags(A5),a2
		move.l	#PDTA_BitMap,(a2)+
		lea	DT_MyBitMap(a5),a0
		move.l	a0,(A2)+
		clr.l	(A2)
		lea	mytags(A5),a2
		move.l	DT_PicObject(A5),a0
		jsr	_LVOGetDTAttrsA(A6)
		tst.l	DT_MyBitMap(A5)
		beq	DT_FreePicture
.attrok:	moveq	#1,d0
.fail		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

;ULONG DoMethod( Object *obj, unsigned long MethodID, ... ); from Amiga.lib
_DoMethod:	move.l	a2,-(sp)
		movea.l	8(sp),a2		;*obj
		move.l	a2,d0
		beq.s	.cmnullreturn
		lea	12(sp),a1		;methodid, ...
		movea.l	-4(a2),a0
		pea	.cmreturn(pc)
		move.l	8(a0),-(sp)
		rts
.cmnullreturn:	moveq	#0,d0
.cmreturn:	movea.l	(sp)+,a2
		rts


*-----------------------------------------------------------------------------*
ResizeWindow:	movem.l	d0-a6,-(a7)

;		move.l	IntBase(a5),a6
;		move.l	WinHandle(a5),a0
;		jsr	_LVORefreshWindowFrame(a6)

		move.l	GadgetListAdr(a5),d0
		beq.s	.NoGadgets
		move.l	d0,a1
		moveq	#0,d0
		move.w	RealNumGadgets(a5),d0
		move.l	Winhandle(a5),a0
		move.l	Intbase(a5),a6
		jsr	_LVORemoveGList(a6)
.NoGadgets:
		bsr	FreeGadgets
		bsr	Clearwindow
		bsr	InitGadgets
		bne.w	.Return

		bsr	RedrawGadgets

		bsr	AddGads
		bsr	ErlaubeGadgets
		bsr	FreeinfoList
		*bne	.Return
		*bsr	EinTragNeu
.Return:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
Closewin:	movem.l	d0-a6,-(a7)
		lea	Puffer,a5
		tst.l	WinHandle(a5)
		beq.s	.KeinWindow
		bsr	MerkWindowSize
		bsr	Closedownwindow
.KeinWindow:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
Closedownwindow:movem.l d0-a6,-(a7)

		move.l	MyFontAdr(a5),d0
		beq.s	.OK1
		clr.l	MyFontAdr(a5)
		move.l	d0,a1
		move.l	GFXBase(a5),a6
		jsr	_LVOCloseFont(a6)
.Ok1:

		move.l	WinHandle(a5),d0
		beq.s	.Return
		move.l	d0,a0
		move.l	86(a0),a1			;MsgPort des Windows
		move.l	SignalBits(a5),d1
		moveq	#0,d0
		move.b	15(a1),d0
		bclr	d0,d1
		move.l	d1,SignalBits(a5)

		move.l	IntBase(a5),a6
		move.l	Winhandle(a5),d0
		beq.s	.NoWindow
		move.l	d0,a0
		jsr	_LVOCloseWindow(a6)
.NoWindow:	clr.l	Winhandle(a5)
		clr.l	WindowPort(a5)
		clr.l	MyRastPort(a5)
		clr.w	WindowDisabled(a5)

		bsr	FreeMenus
		bsr	FreeGadgets
		bsr	FreeLocale

		bsr	UnlockPubScreen
.Return:	bsr	DT_FreePicture
		movem.l (sp)+,d0-a6
		rts


*--------------------------- Gadgets freigeben -------------------------------*
FreeGadgets:	movem.l	d0-a6,-(a7)

		move.l	GadBase(a5),a6
		move.l	GadgetListAdr(a5),d0
		move.l	d0,a0
		beq	.NoGadgets
		jsr	_LVOFreeGadgets(a6)
.NoGadgets:	clr.l	GadgetListAdr(a5)

		lea	GadgetMerkPuffer(a5),a0
		move.l	#GadgetAnz-1,d1
.ClrPuffer:	clr.l	(a0)+
		dbf	d1,.ClrPuffer
		movem.l	(a7)+,d0-a6

		clr.b	ListeDa(a5)
		rts

*-----------------------------------------------------------------------------*
FreeMenus:	movem.l	d0-a6,-(a7)
		move.l	IntBase(a5),a6
		move.l	MenuAdr(a5),d0
		move.l	d0,a0
		beq	.NoMenu
		move.l	Winhandle(a5),d0
		beq.s	.NoWindow
		move.l	d0,a0
		jsr	_LVOClearMenuStrip(a6)
.NoWindow:	move.l	GadBase(a5),a6
		move.l	MenuAdr(a5),d0
		beq.s	.NoMenu
		move.l	d0,a0
		jsr	_LVOFreeMenus(a6)
.NoMenu:	clr.l	MenuAdr(a5)
		movem.l	(a7)+,d0-a6
		rts

*----------------------------- Lock PubScreen --------------------------------*
LockPubScreen:	movem.l	d1-a6,-(a7)
		moveq	#EPR_UnknownError,d7
		move.l	IntBase(a5),a6
		lea	EUS_Structure(pc),a0
		move.l	EUS_EPBase(a0),d0
		beq.s	.KeinEP
		move.l	d0,a0
		move.l	EPG_Pubscreen(a0),d0
		*move.w	EPG_Wordreserved7(a0),word7(a5)
.KeinEp:	move.l	d0,a0
		jsr	_LVOLockPubScreen(a6)
		move.l	d0,MyPubscreen(a5)
		tst.l	d0
		beq.s	.Return

		move.l	Mypubscreen(a5),a0
		move.l	GadBase(a5),a6
		suba.l	a1,a1
		jsr	_LVOGetVisualInfoA(a6)
		move.l	d0,VisualInfo(a5)
		tst.l	d0
		beq.s	.Return
		moveq	#0,d7
.Return:	move.l	d7,d0
		movem.l	(a7)+,d1-a6
		rts

*------------------------------ Unlock PubScreen -----------------------------*
UnlockPubScreen:movem.l	d0-a6,-(a7)
		move.l	GadBase(a5),a6
		move.l	VisualInfo(a5),d0
		beq.s	.NoVisualInfo
		move.l	d0,a0
		jsr	_LVOFreeVisualInfo(a6)
		clr.l	VisualInfo(a5)
.NoVisualInfo:	move.l	IntBase(a5),a6
		suba.l	a0,a0
		move.l	Mypubscreen(a5),d0
		beq.s	.NoPublicScreen
		move.l	d0,a1
		jsr	_LVOUnlockPubScreen(a6)
.NoPublicScreen:clr.l	Mypubscreen(A5)
		movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
* Berechnet aus den Gadgets die min Height und Width und setzt diese in die   *
* Tagliste.
*-----------------------------------------------------------------------------*
BerechMinWindowSize:
		movem.l	d0-a6,-(a7)

	*-- Berechnungsgrundlage --*
	*-- min Width = min Cyclestringlen+25

**-----------------------------------*
* (C) Players		Infomation   *
* Available		Eigenschaften*
*------------------------------------*
* add del Config load save activate deactivate *


		*--- Breite der Gadgetleiste berechnen ---*
		moveq	#0,d7
		moveq	#0,d2
		moveq	#MinGadgetWidth,d1
		moveq	#LENr_Frequence,d0	;Frequence
		bsr	NimmBiggerSize		;Hexdezpuffer
		add.l	d1,d2
		moveq	#0,d1
		lea	ZiffernPuffer+4(pc),a0
		moveq	#MinGadgetWidth,d1
		bsr	NimmBiggerSize2
		add.l	d1,d2
		add.l	#GadgetXAbstand*2,d2

		moveq	#MinGadgetWidth,d1
		moveq	#LENr_SaveSample,d0
		bsr	NimmBiggerSize
		add.l	d1,d2			;d2=untere Breite



		moveq	#MinGadgetWidth,d1
		moveq	#LENr_Size,d0
		bsr	NimmBiggerSize
		move.l	d1,d3

		moveq	#MinGadgetWidth,d1
		moveq	#LENr_Position,d0
		bsr	NimmBiggerSize
		cmp.l	d1,d3
		bhi.s	.XBleibtSo_1
		move.l	d1,d3
.XBleibtSo_1:	moveq	#MinGadgetWidth,d1
		moveq	#LENr_Time,d0
		bsr	NimmBiggerSize
		cmp.l	d1,d3
		bhi.s	.XBleibtSo_2
		move.l	d1,d3
.XBleibtSo_2:

		moveq	#MinGadgetWidth,d1
		lea	ZiffernPuffer+3(pc),a0	;3 Ziffern pro Gadget
		bsr	NimmBiggerSize2
		add.l	d1,d3
		add.l	d1,d3
		add.l	d1,d3



		cmp.l	d3,d2		*d2=untere Reihe
		bhi.s	.XBleibtSo
		move.l	d3,d2

*  Hier testen
.XBleibtSo:	add.l	#BevelBreite*2+MinTextGadgetXOffset*5+GadgetXAbstand,d2
					*Abstand vom Bevelrand links & rechts
					*sowie Abstand zum nchsten Gadget
					*Breite aller Bevelboxen
					*dazuaddieren 5 Gadgets*2Rnder = 14
		move.l	d2,d6

		add.l	#GadgetXAbstand*2,d6	*Abstand vom Rand links&Rechts

		move.l	MyPubScreen(a5),a0
		move.b	Sc_WBorLeft(a0),d0
		ext.w	d0
		add.w	d0,d6
		move.b	Sc_WBorRight(a0),d0
		add.w	d0,d6
		move.l	d6,Win_MinWidth


	*----- So, nun wird die Y-Ausdehnung des Window berechnet -----*
		moveq	#0,d0
		move.w	FontY(a5),d0
		add.w	#MinTextGadgetYOffset*2+BevelHohe*2,d0

		mulu	#9,d0	* 2 fr Len/Time/Pos, 1=Rnder
				* 2+1 fr Listview, 1 fr Slider, 1 fr Text
				* und 1 als Reserve

		add.w	Offy(a5),d0
		move.l	d0,Win_MinHeight


		movem.l	(a7)+,d0-a6
		rts
	
*-----------------------------------------------------------------------------*
* In der Windowstruktur sind die aktuellen Werte der Gre!		      *
* Jetzt
* Input: --
*-----------------------------------------------------------------------------*
InitGadgets:	movem.l	d1-a6,-(a7)


		move.l	PlayFrequence(a5),d0
		divu	#FreqStep,d0
		move.l	d0,SliderPos+4
		move.l	PlayFrequence(a5),d0
		lea	FrequencePuffer(a5),a1
		bsr	Hexdez

		*----- Zur Verfgung stehende Ausmae berechnen ------*
		move.l	WinHandle(a5),d0
		beq.w	.Return
		move.l	d0,a0
		moveq	#0,d6
		moveq	#0,d7
		move.w	WD_Width(a0),d6
		move.w	WD_Height(a0),d7
		moveq	#0,d0
		move.b	WD_BorderBottom(a0),d0
		sub.w	d0,d7				*InnerHeight
		sub.w	OffY(a5),d7
		sub.l	#GadgetYAbstand*2,d7
		move.b	WD_BorderLeft(a0),d0
		sub.w	d0,d6
		move.b	WD_BorderRight(a0),d0
		sub.w	d0,d6				*InnerWidth
		sub.l	#GadgetXAbstand*2,d6


	*	sub.l	#GadgetYAbstand*2,d7
	*	sub.l	#GadgetYAbstand,d7
		moveq	#0,d0
		move.w	FontY(a5),d0
		add.w	#MinTextGadgetYOffset+BevelHohe*2,d0
		sub.l	d0,d7



		*-- Postionen der Gadgets lschen --*
		lea	Gadgets(pc),a4
		moveq	#GadgetAnz-1,d1
		move.l	a4,a3
.GadgetClr:	move.w	#GadgetXAbstand,gng_leftedge(a3)
		*move.w	FontY(a5),2(a3)				*Gren lschen
		*clr.l	4(a3)
		lea	GNG_SizeOf(a3),a3		*Positionen und
		dbf	d1,.GadgetClr


	*-- Die Breiten der Gadgetleisten wird berechnet --*
	*-- Als erstes wird die Stringbreite berechnet und gemerkt --*
	*-- dann wird calibriert
	move.l	d6,-(a7)

	subq.l	#GadgetXAbstand*2,d6
	subq.l	#GadgetXAbstand,d6


		*move.l	MaxOberWidth(a5),d1
		*move.l	MaxOberWidth2(a5),d2
		*mulu	d6,d1
		*divu	d2,d1


		moveq	#LENr_Name,d0		*Name
		bsr	GetTextlength2
		move.l	d0,d3
		moveq	#LENr_Size,d0
		bsr	GetTextLength2
		cmp.l	d0,d3
		bhi.s	.NameLaenger
		move.l	d0,d3
.NameLaenger	move.l	d3,d5
		moveq	#LENr_Position,d0
		bsr	GetTextLength2
		cmp.l	d0,d3
		bhi.s	.XBleibtSo_1
		move.l	d0,d3
.XBleibtSo_1:	moveq	#LENr_Time,d0
		bsr	GetTextLength2
		cmp.l	d0,d3
		bhi.s	.XBleibtSo_2
		move.l	d0,d3
.XBleibtSo_2:	moveq	#0,d1
		add.l	d3,d1



		move.l	d6,d2
		divu	#3,d2
	*	sub.w	MaxOberWidth(a5),d2
		sub.w	d1,d2
	sub.w	#GadgetXAbstand,d2

		*moveq	#LENr_Size,d0
		*bsr	GetTextlength2
		move.l	d5,d0
		add.w	#MinTextGadgetXOffset*2+BevelBreite*2,d0
		add.w	d0,gng_leftedge(A4)
		add.w	#GadgetXAbstand/2,gng_leftedge(A4)

		add.w	d6,gng_leftedge+gng_sizeof*2(A4)
		add.w	#GadgetXAbstand/2,gng_leftedge+gng_sizeof*2(A4)
		sub.w	d2,gng_leftedge+gng_sizeof*2(A4)


		moveq	#LENr_Time,d0
		bsr	GetTextlength2
		move.w	gng_leftedge+gng_sizeof*2(A4),d3
		sub.w	d0,d3			;rechter Rand

		move.w	gng_leftedge(A4),d4
		add.w	d2,d4			;linker Rand

		sub.w	d4,d3		;Max Width
	sub.w	#GadgetXAbstand*2+MinTextGadgetXOffset*2+BevelBreite*2,d3
	sub.w	d2,d3	;jetzt nur noch Textbreite

		moveq	#LENr_Position,d0
		bsr	GetTextlength2
		sub.w	d0,d3	;Bytes, die zuviel sind insgesamt
		lsr.w	#1,d3
		add.w	d3,d4
		add.w	d0,d4
		add.w	d4,gng_leftedge+gng_sizeof(A4)
		add.w	#GadgetXAbstand,gng_leftedge+gng_sizeof(A4)


		*add.w	d1,gng_leftedge(A4)
		*add.w	d1,gng_leftedge+gng_sizeof(A4)
		*add.w	d1,gng_leftedge+gng_sizeof*2(A4)

		*mulu	#3,d1
		*move.l	d6,d0
		*sub.w	d1,d0
		*divu	#3,d0
		move.w	d2,gng_Width(A4)
		move.w	d2,gng_Width+gng_sizeof(A4)
		move.w	d2,gng_Width+gng_sizeof*2(A4)


	*	moveq	#LENr_Name,d0		*Name
	*	bsr	GetTextlength2
		move.l	d5,d0
		add.w	#GadgetXAbstand*2,d0
		move.w	d6,gng_width+gng_sizeof*3(a4)
		sub.w	d0,gng_width+gng_sizeof*3(a4)
		add.w	d0,gng_leftedge+gng_sizeof*3(a4)
		add.w	#GadgetXAbstand/2,gng_leftedge+gng_sizeof*3(a4)

	move.l	(a7)+,d6

		*-- Bevelrand malen --*
		bsr	Bevelrand

		move.w	d6,gng_width+gng_sizeof*4(a4)	*Infolist
		sub.w	#GadgetXAbstand,gng_leftedge+gng_sizeof*4(a4)

		move.w	d6,gng_width+gng_sizeof*5(a4)	*Slider
		sub.w	#GadgetXAbstand,gng_leftedge+gng_sizeof*5(a4)
		*sub.w	#GadgetXAbstand*2,gng_width(a4)
		*sub.w	#GadgetXAbstand*2,gng_width+gng_sizeof(a4)


		moveq	#LENr_SaveSample,d0
		bsr	GetTextlength2
		add.w	#MinTextGadgetXOffset*2+Bevelbreite*2,d0
	*	sub.w	#GadgetXAbstand,gng_leftedge+gng_sizeof*6(a4)
		move.w	d0,gng_width+gng_sizeof*6(a4)
		sub.w	d0,d6
		subq.w	#GadgetXabstand,d6
		add.w	d6,gng_leftedge+gng_sizeof*6(a4)
		subq.w	#GadgetXabstand,d6


		moveq	#LENr_Frequence,d0
		bsr	GetTextlength2
		move.w	d6,gng_width+gng_sizeof*7(a4)
		sub.w	d0,gng_width+gng_sizeof*7(a4)
		sub.w	#GadgetXAbstand*4,gng_width+gng_sizeof*7(a4)
	sub.w	#GadgetXAbstand,d0
		add.w	d0,gng_leftedge+gng_sizeof*7(a4)
		add.w	#GadgetXAbstand*3,gng_leftedge+gng_sizeof*7(a4)
		sub.w	#GadgetXAbstand,gng_leftedge+gng_sizeof*7(a4)


		*-- Jetzt die Y-Koordinaten --*
		move.w	FontY(a5),d4
		add.w	#MinTextGadgetYOffset,d4
		move.w	d4,gng_height+gng_sizeof*0(a4)	;Length
		move.w	d4,gng_height+gng_sizeof*1(a4)	;Pos
		move.w	d4,gng_height+gng_sizeof*2(a4)	;Time
		move.w	d4,gng_height+gng_sizeof*3(a4)	;Name
		move.w	d4,gng_height+gng_sizeof*5(a4)	;Slider
		move.w	d4,gng_height+gng_sizeof*6(a4)	;Freq
		move.w	d4,gng_height+gng_sizeof*7(a4)	;Save

		move.w	#GadgetYAbstand+3,gng_topedge+gng_sizeof*0(a4)	;Length
		move.w	#GadgetYAbstand+3,gng_topedge+gng_sizeof*1(a4)	;Pos
		move.w	#GadgetYAbstand+3,gng_topedge+gng_sizeof*2(a4)	;Time

		moveq	#GadgetYAbstand+3,d0
		add.w	d4,d0
		add.w	#GadgetYAbstand*2,d0
		move.w	d0,gng_topedge+gng_sizeof*3(a4)	;Name

		add.w	d4,d0
		add.w	#GadgetYAbstand*3,d0
		move.w	d0,gng_topedge+gng_sizeof*4(a4)	;Listview

	*	add.w	#GadgetYAbstand*2,d7
		move.w	d7,gng_topedge+gng_sizeof*6(a4)	;Freq
		move.w	d7,gng_topedge+gng_sizeof*7(a4)	;Save Sample

		move.w	PrefsFlags+EUS_Structure(pc),d1
		and.w	#PFF_SampleSaverOn,d1
		beq.s	.skipsub

		sub.w	#GadgetYAbstand*2,d7
		sub.w	d4,d7
		move.w	d7,gng_topedge+gng_sizeof*5(a4)	;Slider

		sub.w	#GadgetYAbstand,d7
		sub.w	d4,d7
.skipsub
		add.w	d4,d7
		sub.w	d0,d7
		move.w	d7,gng_height+gng_sizeof*4(a4)	;Listview

		bsr	CreateGadgets				*d0=Return

.Return:	movem.l	(a7)+,d1-a6
		rts


.Error:		moveq	#EPR_UnknownError,d0
		bra.s	.Return


*-----------------------------------------------------------------------------*
* Input: d6=Breite
BevelRand:	movem.l	d0-a6,-(a7)

		move.l	GadBase(a5),a6
		move.l	WinHandle(a5),d0
		beq.s	.Return
		move.l	d0,a0
		move.l	WD_RPort(a0),a2
		lea	BevelTags(pc),a1
		move.l	VisualInfo(a5),4(a1)

		
		move.w  #GadgetXAbstand,d0
		add.w   Offx(A5),d0
		move.w  #GadgetYAbstand,d1
		add.w   Offy(a5),d1

		move.w	WD_Width(a0),d2
		moveq	#GadgetXAbstand,d3		;Rechter Rand minus 4
		add.b	wd_borderright(a0),d3
		sub.w	d3,d2
		sub.w	d0,d2

		move.w	FontY(a5),d3
		add.w	#BevelHohe*2+MinTextGadgetYOffset,d3
		add.w	d3,d3			;2 mal fonthhe
		add.w	#GadgetYAbstand*5,d3
		*add.w	#30,d3

		move.l  a2,a0
		jsr     _LVODrawBevelBoxA(a6)

.Return:	movem.l	(a7)+,d0-a6
		rts

BevelTags:	dc.l	GT_VisualInfo,0,0

*-----------------------------------------------------------------------------*
* Input: --
* Output:d0=Error oder Null
*-----------------------------------------------------------------------------*
CreateGadgets:	movem.l	d1-a6,-(a7)
		moveq	#EPR_UnknownError,d7
		move.l	GadBase(A5),a6
		lea	GadgetListadr(a5),a0
		jsr	_LVOCreateContext(a6)
		move.l	d0,a3
		tst.l	d0
		beq.w	.Error

		moveq	#0,d3
		lea.l	GadgetTags(pc),a4
		lea	RejectGadgetsList(pc),a2
.NextGadget:
		move	(a2)+,d0
		beq.s	.useit
		and	PrefsFlags+EUS_Structure(pc),d0
		beq	.Findtags
.useit
		EB
		lea	Gadgets(pc),a0
		move.l	d3,d0
		mulu	#GNG_SIZEOF,d0		* +2 wegen Locale !
		add.l	d0,a0
		lea.l	BufNewGad(a5),a1
		moveq	#GNG_SizeOf,d0
		jsr	_LVOCopyMem(a6)
		lea.l	BufNewGad(a5),a0
		move.l	VisualInfo(a5),GNG_VisualInfo(a0)
		move.l	Font(a5),GNG_TextAttr(a0)

		move.w	GNG_TopEdge(a0),d0
		add.w	OffY(a5),d0
		addq.w	#GadgetYAbstand,d0
		move.w	d0,GNG_TopEdge(a0)

		move.w	GNG_LeftEdge(a0),d0
		add.w	OffX(a5),d0
		add.w	#GadgetXAbstand,d0
		move.w	d0,GNG_LeftEdge(a0)

		move.l	GadBase(a5),a6
		lea	GadgetTypes(pc),a0
		moveq	#0,d0
		move.l	d3,d1
		asl.l	#1,d1
		add.l	d1,a0
		move.w	(a0),d0
		move.l	a3,a0
		lea	BufNewGad(a5),a1
	push	a2
		move.l	a4,a2
		jsr	_LVOCreateGadgetA(a6)
	pop	a2
		tst.l	d0
		beq.s	.Error

		*------- Gadgetadr im Puffer merken --------*
		move.l	d0,a3
		move.l	d3,d0
		asl.l	#2,d0
		lea.l	GadgetMerkPuffer(a5),a0
		add.l	d0,a0
		move.l	a3,(a0)

		*--- Start der nchsten Tagliste finden ----*
.FindTags:	tst.l	(a4)
		beq.s	.NochEinGadget
		addq.w	#8,a4
		bra.s	.FindTags

.NochEinGadget:	addq.w	#4,a4
		addq.w	#1,d3
		cmp.w	#GadgetAnz,d3
		bmi	.NextGadget
		moveq	#0,d7
.Return:	move.l	d7,d0
		movem.l	(a7)+,d1-a6
		rts

.Error:		bsr.w	FreeGadgets
		bra.s	.Return

*-----------------------------------------------------------------------------*
AddGads:	movem.l	d0-a6,-(sp)
		tst.l	WinHandle(a5)
		beq.w	.Return
		move.l	GadgetListAdr(a5),d0
		beq.s	.Return
		move.l	d0,a1

		moveq	#0,d1
.count:		move.l	d0,a0
		addq.l	#1,d1
		move.l	(A0),d0
		bne.s	.count
		move.w	d1,RealNumGadgets(a5)

		move.l	IntBase(a5),a6
		move.l	Winhandle(a5),a0
		moveq	#-1,d0
		moveq	#-1,d1
		sub.l	a2,a2
		jsr	_LVOAddGList(a6)

		lea	MyTags(a5),a3
		move.l	#GTLV_Selected,(a3)+
		move.l	SelectedEntry(a5),(a3)
		subq.l	#1,(a3)+
		clr.l	(a3)
		moveq	#EPENr_Infolist,d0
		bsr	GetGadgetAdr
		bne	.nolist
		lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)
.nolist
		move.b	#1,ListeDa(a5)

		move.l	GadgetListAdr(a5),a0
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		moveq	#-1,d0
		move.l	IntBase(a5),a6
		jsr	_LVOrefreshglist(a6)

		move.l	GadBase(a5),a6
		move.l	Winhandle(a5),a0
		sub.l	a1,a1
		jsr	_LVOGT_RefreshWindow(a6)


.Return:	movem.l	(sp)+,d0-a6
		rts



*----------------------- Liste wieder an Gadget anhngen ---------------------*
* Input: --
*-----------------------------------------------------------------------------*
Readdlist:	movem.l	d0-a6,-(sp)
		tst.l	Winhandle(a5)
		beq.s	.Return

		tst.b	ListeDa(a5)
		bne.s	.Return

		tst.l	MaxEntries(a5)
		beq.s	.NoSel
		tst.l	SelectedEntry(a5)
		bne.s	.NoSel
		addq.l	#1,SelectedEntry(a5)

.NoSel:		moveq	#EPENr_Infolist,d0
		bsr	GetGadgetAdr			;Gadgetadresse in A0
		bne.s	.Return
		lea	MyTags(a5),a3
		move.l	#GTLV_Labels,(a3)+
		lea	Infolist(a5),a2
		move.l	a2,(a3)+
		move.l	#GTLV_Selected,(a3)+
		move.l	SelectedEntry(a5),(a3)
		subq.l	#1,(a3)+
		move.l	#GTLV_ShowSelected,(a3)+
		move.l	#1,(a3)+
		move.l	#GTLV_MakeVisible,(a3)+
		move.l	SelectedEntry(a5),(a3)
		subq.l	#1,(a3)+
		clr.l	(a3)

		lea	MyTags(a5),a3
		move.l	WinHandle(a5),a1
		sub.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

		move.b	#1,ListeDa(a5)
		bsr	ErlaubeGadgets

.Return:	movem.l	(sp)+,d0-a6
		rts



******************************************************************************
* Die Liste wird removed
******************************************************************************
RemoveList:	movem.l	d0-a6,-(a7)
		moveq	#EPENr_InfoList,d0
		tst.b	ListeDa(a5)
		beq.s	.Return

		tst.l	Winhandle(a5)
		beq.s	.Return
		bsr	GetGadgetAdr			;Gadgetadresse in A0
		bne.s	.Return
		lea	Mytags(a5),a3
		move.l	#GTLV_Labels,(a3)+
		move.l	#-1,(a3)+
		clr.l	(a3)+
		lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

.Return:	clr.b	ListeDa(a5)
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
FreeInfoList:	movem.l	d0-a6,-(a7)
		bsr	RemoveList
		lea	Infolist(a5),a0
		bsr	DeleteAList
	*	clr.l	SelectedEntry(a5)
		clr.l	MaxEntries(a5)
		bsr	MakeInfoList
		bsr	ErlaubeGadgets
		movem.l	(a7)+,d0-a6
		rts



*-----------------------------------------------------------------------------*
* Input: a0=List
*-----------------------------------------------------------------------------*
DeleteAList:	movem.l	d0-a6,-(a7)
		move.l	a0,d4

.NextNode:	move.l	d4,a0
	;Macro remhead aus exec/lists.i 	A0-list A1-(destroyed) D0=node
		MOVE.L  (A0),A1
		MOVE.L  (A1),D0
		BEQ.S   .empty
		MOVE.L  D0,(A0)
		EXG.L   D0,A1
		MOVE.L  A0,LN_PRED(A1)

		move.l	d0,a1
		lea	-ML_Node(a1),a3
		bsr	FreeThisNode
		bra.s	.NextNode

.empty:		movem.l	(sp)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: a3=EFL_Struct (bereits removed)
*-----------------------------------------------------------------------------*
FreeThisNode:	movem.l	d0-d2/a0-a2/a6,-(a7)

		move.l	ML_Size(a3),d0
		beq.s	.NextNode
		move.l	a3,a1
		EB
		jsr	_LVOFreemem(a6)

.NextNode:	movem.l	(a7)+,d0-d2/a0-a2/a6
		rts

*-----------------------------------------------------------------------------*
* a0=Text
* a1=Liste
* Output: d0=Error oder NULL
*-----------------------------------------------------------------------------*
TextToNodes:	movem.l	d1-a6,-(a7)
		move.l	a0,a4
		move.l	a1,d6



	*----------- Width des Listview rausfinden -----------*
	* Kleiner Trick, Gadget im ArchiveInfo ist immer das -*
	* grte					      *
	*-----------------------------------------------------*
		move.l	WinHandle(a5),d0
		beq.w	.Return
		move.l	d0,a0
		lea	WD_FirstGadget(a0),a2
		moveq	#0,d1
.FindIt:	move.l	(a2),d0
		beq.w	.AllesFound
		move.l	d0,a2
		move.w	GG_GadgetType(a2),d0		*GadgetID
		btst	#15,d0				*Systemgadget ?
		bne.s	.FindIt
		move.w	GG_Width(a2),d2
		cmp.w	d2,d1
		bhi.s	.FindIt
		cmp.w	InfoWidth(a5),d2
		beq.s	.FindIt
		move.w	GG_Width(a2),d1
		bra.s	.FindIt

.AllesFound:	sub.w	#23,d1			*move.w	InfoWidth(a5),d0
		move.w	d1,InfoWidth2(a5)




	*---- Text nach Leerzeichen durchsuchen und dann Width testen ----*
.TextSchleife:	move.l	a4,a3
		moveq	#-1,d1
		moveq	#0,d3
.NextB:		addq.l	#1,d1
		move.b	(a3)+,d2
		beq.s	.Zeilenende
		*cmp.b	#"-",d2
		*beq.s	.TestTrennung
		*cmp.b	#",",d2
		*beq.s	.TestTrennung
		cmp.b	#" ",d2
		beq.s	.TestTrennung

		cmp.b	#10,d2
		bne.s	.NextB
.ZeilenEnde:	tst.l	d1
		blt.s	.DasWars
		bsr	.TesteString
		beq.s	.NimmThisString
		bra.s	.EinKurzer

.TestTrennung:	*subq.l	#1,d1
		*blt.s	.DasWars
		*subq.l	#1,a3
		bsr	.TesteString
		beq.s	.NextB		
		*---- String zu lang 1 Word krzer ----*
.EinKurzer:	move.l	d1,d3
		subq.l	#1,a3
.EinKurzer_2:	subq.l	#1,d1
		blt.s	.NimmThisString2
		move.b	-(a3),d2
		*cmp.b	#"-",d2
		*beq.s	.NimmThisString
		*cmp.b	#",",d2
		*beq.s	.NimmThisString
		cmp.b	#" ",d2
		bne.s	.EinKurzer_2
		bra.s	.NimmThisString

		*--- a4=Textstart d1=Size ---*
.NimmThisString2:move.l	d3,d1
.NimmThisString:bsr.s	.ThisStringToNode
		beq.s	.Return				*No Mem
		tst.b	(a4,d1.w)
		beq.s	.DasWars
		lea	1(a4,d1.w),a4
		bra.s	.TextSchleife


.DasWars:	moveq	#0,d0
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*---------- Pat der String in a4 mit Size in d1 ins Listview ----------------*
.TesteString:	movem.l	d1-a6,-(a7)
		moveq	#EPR_ErrorInArguments,d0
		tst.l	d1
		blt.s	.TesteString_2
		move.b	(a4,d1.w),d2
		move.l	d2,-(a7)
		clr.b	(a4,d1.w)
		move.l	a4,a0
		bsr	GetTextlength
		move.l	(a7)+,d2
		move.b	d2,(a4,d1.w)
		move.l	d0,d1
		moveq	#0,d0
		cmp.w	InfoWidth2(a5),d1
		blt.s	.TesteString_2
		moveq	#EPR_ErrorInString,d0
.TesteString_2:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*------- der String ab a3 wird mit der Lnge von D1 in die Node gehngt ------*
.ThisStringToNode:
		movem.l	d1-a6,-(a7)
		moveq	#0,d0
		tst.l	d1
		blt.s	.ThisError
		move.b	(a4,d1.w),d2
		move.l	d2,-(a7)
		clr.b	(a4,d1.w)
		move.l	a4,a0
		move.l	a4,-(a7)
		move.l	d6,a4
		bsr	AllocTheNode
		move.l	(a7)+,a4
		move.l	(a7)+,d2
		move.b	d2,(a4,d1.w)
.ThisError:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*----------------------------------------------------------------------------*
* Speicher fr Node-Struktur + String anfordern, an Liste anhngen und init  *
*									     *
* Input: a0=StringAdr							     *
*	 a4=Liste							     *
* Output:d0=NUll=Error	L						     *
*----------------------------------------------------------------------------*
AllocTheNode:	movem.l	d1-a6,-(sp)
		move.l	a0,a2
		bsr	BerechStringSize
		EB
		move.l	#$10000,d1
		add.l	#ML_Chars+10,d0
		move.l	d0,d3
		jsr	_LVOAllocmem(a6)
		tst.l	d0
		beq.s	.Error

		move.l	d0,a3
		move.l	a4,a0
		move.l	d0,a1			;(erspart Arbeit)
		addtail
		lea	ML_Chars(a3),a1
		move.l	a1,LN_Name(a3)
		move.l	d3,ML_Size(a3)

		move.w	d3,d1
		sub.w	#ML_Chars+10+1,d1
		move.l	a2,a0
		bsr	StringCopy2

		move.l	a3,d0

		addq.l	#1,MaxEntries(a5)

.Error:		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts



*------------------------------- Get GadgetAdr -------------------------------*
* d0=0, wenn ok
GetGadgetAdr:	sub.l	a0,a0
		cmp.w	#GadgetAnz,d0
		bhi.s	.Error
		tst.l	GadgetListAdr(a5)
		beq.s	.Error
		lea	GadgetMerkPuffer(a5),a0
		subq.l	#EPENr_FirstNummer,d0
		asl.l	#2,d0
		tst.l	(a0,d0)
		beq.s	.Error
		move.l	(a0,d0),a0
		moveq	#0,d0
		rts
.Error:		moveq	#-1,d0
		rts



*--------------------------- normaler Stringvergleich ------------------------*
* Input: a0=String1
*	 a1=String2
* Output:d0=0 Strings gleich
*	 d0<0 String 1 vor String 2
*	 d0>0 String 2 vor String 1
*-----------------------------------------------------------------------------*
StrCmp:		movem.l	d1/a0/a1,-(a7)
		move.l	a0,d0
		beq.s	.Kleiner
		move.l	a1,d0
		beq.s	.Kleiner
.Repeat:	move.b	(a0)+,d1
		beq.s	.Ende1
		cmp.b	#`A`,d1		;Kommando in Grobuchstaben
		blo.s	.NoD1Set	;umwandeln
		cmp.b	#`Z`,d1
		bhi.s	.NoD1Set
		bset	#5,d1		;bis auf Bit 5 alle bernehmen -> fertig
.NoD1Set:	move.b	(a1)+,d0	;Wert holen
		beq.s	.Grosser
		cmp.b	#`A`,d0		;Kommando in Grobuchstaben
		blo.s	.NoBSet		;umwandeln
		cmp.b	#`Z`,d0
		bhi.s	.NoBSet
		bset	#5,d0		;bis auf Bit 5 alle bernehmen -> fertig
.NoBSet:	cmp.b	d1,d0
		beq.s	.Repeat
		bhi.s	.Kleiner
.Grosser:	moveq	#1,d0
		bra.s	.Return
.Kleiner:	moveq	#-1,d0
.Return:	movem.l	(a7)+,d1/a0/a1
		tst.l	d0
		rts			;---> Error in String !!!!

.Ende1:		tst.b	(a1)
		bne.s	.Kleiner
		moveq	#0,d0
		bra.s	.Return

*---------------------------- Make Correct-Dir ------------------------------*
*----- Corrigiert den Dirnamen so, da Filenamen nur rankopiert werden ------*
*----- Input: a0=Diradresse						-----*
*----------------------------------------------------------------------------*
MakeCorrectDir:	move.l	a0,-(a7)
		tst.b	(a0)
		beq.s	.NoSchraeg
.NextB:		tst.b	(a0)+
		bne.s	.NextB
		subq.l	#2,a0
		cmp.b	#":",(a0)
		beq.s	.NoSchraeg
		cmp.b	#"/",(a0)+
		beq.s	.NoSchraeg
		move.b	#"/",(a0)+
		clr.b	(a0)
.NoSchraeg:	move.l	(a7)+,a0
		rts


*---------------- Berechnet die Gre des Strings in a0 ---------------------*
*------- >= a0=String							-----*
*------- => d0=Stringsize						-----*
*----------------------------------------------------------------------------*
BerechStringSize:move.l a0,-(a7)
		moveq	#0,d0
		cmp.l	d0,a0
		beq.s	.NoTest
		moveq	#-1,d0
.NextB:		addq.l	#1,d0
		tst.b	(a0)+
		bne.s	.NextB
.NoTest:	move.l	(a7)+,a0
		tst.l	d0
		rts


*----------------------------------------------------------------------------*
StringCopy:	moveq	#0,d0
		cmp.l	a1,d0
		beq.s	.Return
		cmp.l	a0,d0
		beq.s	.Return
		tst.w	d1
		blt.s	.Return

.CopyIt:	clr.b	(a1)
		move.b	(a0)+,d0		;Copiere String bis 0 d1=Anz
		beq.b	.Return
		move.b	d0,(a1)+
		dbf	d1,.CopyIt
		clr.b	(a1)
.Return		moveq	#0,d0
		rts

*----------------------------------------------------------------------------*
StringCopy2:	moveq	#0,d0
		cmp.l	a1,d0
		beq.s	.Return
		cmp.l	a0,d0
		beq.s	.Return
		tst.w	d1
		blt.s	.Return

.CopyIt:	clr.b	(a1)
		move.b	(a0)+,d0		;Copiere String bis 0 d1=Anz
		beq.b	.Return
		cmp.b	#32,d0
		blo.s	.return
		*blo.s	.Ok
		*moveq	#32,d0
.Ok:		move.b	d0,(a1)+
		dbf	d1,.CopyIt
		clr.b	(a1)
.Return		moveq	#0,d0
		rts


*-----------------------------------------------------------------------------*
InitLocale:	movem.l	d0-a6,-(a7)

		*--- Catalog ffnen ---*
		if	Executable!Debugger
		tst.l	MyCatalog(a5)
		bne.s	.NoCatalog
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		lea	Catalogname(pc),a1
		jsr	ENPP_OpenCatalog(a4)		;_LVOopencatalogA
		move.l	d0,MyCatalog(a5)

		else

		*--- Catalog ffnen ---*
		tst.l	MyCatalog(a5)
		bne.s	.NoCatalog
		move.l	LocaleBase(a5),d0
		beq.s	.NoCatalog
		move.l	d0,a6
		suba.l	a0,a0
		suba.l	a2,a2
		lea	Catalogname(pc),a1
		jsr	_LVOOpenCatalogA(a6)		;_LVOopencatalogA
		move.l	d0,MyCatalog(a5)
		endc

.NoCatalog:	moveq	#5,d0
		lea	LocaleTabelle-4(pc),a0
		lea	LocaleTabelle(pc),a1
.NextOne:	lea	4(a0),a0
		move.w	(a0),d0
		beq.s	.DasWars
		move.w	2(a0),d1
		lea	(a1,d1.w),a2
		bsr	GetLocaleString
		move.l	d0,(a2)
		bra.s	.NextOne
.DasWars:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
FreeLocale:	movem.l	d0-a6,-(a7)
		*tst.l	MyCatalog(a5)
		*beq.s	.NoCatalog

		if	executable!Debugger
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	MyCatalog(a5),d0
		jsr	ENPP_CloseCatalog(a4)
		else
		move.l	LocaleBase(a5),d0
		beq.s	.NoCatalog
		move.l	d0,a6
		move.l	MyCatalog(a5),d0
		jsr	_LVOCloseCatalog(a6)
		endc
.NoCatalog:	clr.l	MyCatalog(a5)
		movem.l	(a7)+,d0-a6
		rts

*---------------------------- Erstmal ignorieren -----------------------------*
*-----------------------------------------------------------------------------*
FirstLocaleInit:movem.l	d0-a6,-(a7)
		lea	LocalePuffer+2(a5),a4
		lea	ExternalStrings,a3
		move.w	#LENr_LastExternal,d1
		move.l	a3,a0
.NextString2:	move.l	a0,d0
		sub.l	a3,d0
		move.w	d0,(a4)+
.FindZero2:	tst.b	(a0)+
		bne.s	.FindZero2
	*	tst.b	(a0)
	*	beq.s	.SetAbsStrings
		subq.w	#1,d1
		bne.s	.NextString2
.Ok:		movem.l	(a7)+,d0-a6
		rts



*-----------------------------------------------------------------------------*
* Input:  D0.w = LocaleNr						      *
* Output: D0.l = StringAdr						      *
*-----------------------------------------------------------------------------*
GetLocaleString:
		movem.l	d1/d2/a0/a1/a6,-(a7)

	*------- LocaleString aus internem Catalog suchen ------*
		move.l	d0,d2
		sub.l	a0,a0
		lea	ExternalStrings,a1
		cmp.w	#LENr_LastExternal,d0
		bhi.s	.Error
		lea	LocalePuffer(a5),a0
		ext.l	d0
		add.l	d0,d0
		move.w	(a0,d0.l),d0			;kein ext.l weil immer
		lea	(a1,d0.w),a0
.Error:		move.l	a0,d0

	*---------- Nun LocaleString aus Catalog suchen ---------*
		move.l	LocaleBase(a5),d1
		beq.s	.Return
		move.l	d1,a6
		move.l	MyCatalog(a5),d1
		beq.s	.Return
		move.l	d1,a0
		move.l	d0,a1
		move.l	d2,d0				* Stringnummer
		subq.l	#1,d0
		ext.l	d0
		jsr	_LVOGetCatalogStr(a6)		*--> d0=valid String

.Return:	movem.l	(a7)+,d1/d2/a0/a1/a6
		rts

*-----------------------------------------------------------------------------*
* Input: *a0=TextAdr (Font)						      *
*	 a0=Text							      *
* Output:d0=Size							      *
*-----------------------------------------------------------------------------*
GetTextlength2:	movem.l	d1-a6,-(a7)
		bsr	GetLocaleString
		move.l	d0,a0
		bra.s	getTextlength3
GetTextlength:	movem.l	d1-a6,-(a7)
GetTextlength3:	lea	MyIntuiText(pc),a2
		move.l	Font(a5),8(a2)
		move.l	a0,12(a2)
		move.l	a2,a0
		move.l	IntBase(a5),a6
		jsr	_LVOIntuiTextLength(a6)
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Diese Routine berechnet die Size vom String in d0 und setzt falls diese gr  *
* ist d1 neu.								      *
* Input: d0=Localenr							      *
*	 d1=bisherige Width						      *
* Output:d1=Neuer Wert							      *
*-----------------------------------------------------------------------------*
NimmBiggerSize:	movem.l	d2-a6,-(a7)			*Input: d0=Nummer
		bsr	GetLocaleString
		move.l	d0,a0
		bsr	GetTextlength
		cmp.w	d0,d1
		bhi.s	.D1IstBigger
		move.l	d0,d1
		ext.l	d1
.D1IstBigger:	movem.l	(a7)+,d2-a6
		rts

*-----------------------------------------------------------------------------*
* Input: a0=Text
NimmBiggerSize2:movem.l	d2-a6,-(a7)			*Input: d0=Nummer
		bsr	GetTextlength
		cmp.w	d0,d1
		bhi.s	.D1IstBigger
		move.l	d0,d1
		ext.l	d1
.D1IstBigger:	movem.l	(a7)+,d2-a6
		rts



*-----------------------------------------------------------------------------*

		*------------------ Window ---------------*
WindowTags:	dc.l	WA_MinWidth
Win_MinWidth:	dc.l	0
		dc.l	WA_MinHeight
Win_MinHeight:	dc.l	0
		dc.l	WA_MaxWidth,$8000
		dc.l	WA_MaxHeight,$8000

		dc.l	WA_Left
Win_LeftPos:	dc.l	0
		dc.l	WA_Top
Win_TopPos:	dc.l	0
		dc.l	WA_Width
Win_Width:	dc.l	0
		dc.l	WA_Height
Win_Height:	dc.l	0
		dc.l	WA_IDCMP,IDCMP_VanillaKey!IDCMP_Changewindow!IDCMP_RawKey!IDCMP_Menupick!LISTVIEWIDCMP!IDCMP_NEWSIZE!BUTTONIDCMP!IDCMP_CLOSEWINDOW!IDCMP_REFRESHWINDOW
		dc.l	WA_Flags,Sizebbottom!WFLG_DRAGBAR!WFLG_DEPTHGADGET!WFLG_CLOSEGADGET!WFLG_SMART_REFRESH!WFLG_SIZEGADGET
		dc.l	WA_Title
LL_WindowTitle:	dc.l	0
		*dc.l	WA_ScreenTitle
		*dc.l	0
		dc.l	WA_NewLookMenus,1
		dc.l	WA_AutoAdjust,1
		dc.l	WA_Pubscreen
Pubadr:		dc.l	0
		*dc.l	WA_Zoom
		*dc.l	ZoomStruct
		dc.l	TAG_DONE
ZoomStruct:	dc.w	0,0,150,0
Ahawidth:	dc.l	399
Ahaheight:	dc.l	80


	*-------------- Gadgetvereinbarungen ----------------*
	* 1<<15 ($8000) - Flag fr Listviews, um gelschte Hhe an Font anzupassen
Refreshed_Gads:
	my_Redrawlist	GD_Length,0;	PFF_Length
	my_Redrawlist	GD_Position,0;	PFF_Position
	my_Redrawlist	GD_Time,0;	PFF_Time
	my_Redrawlist	GD_Name,0;	PFF_Name
	my_Redrawlist	GD_Text,PFF_SampleSaverOn
	my_Redrawlist	GD_SaveSample,PFF_SampleSaverOn
	my_Redrawlist	GD_Infolist,$8000
	my_Redrawlist	0,0


RejectGadgetsList:  * Liste, wann spezifische Gadgets anhand Prefs ausgeschaltet werden sollen
	dc.w	0			;GD_length 		`0` = `immer an`
	dc.w	0			;GD_Position
	dc.w	0			;GD_Time
	dc.w	0			;GD_Name
	dc.w	0			;GD_Infolist
	dc.w	PFF_SampleSaverOn	;GD_Slider
	dc.w	PFF_SampleSaverOn	;GD_SaveSample
	dc.w	PFF_SampleSaverOn	;GD_Text

GadgetTypes:
		dc.w	Text_Kind
		dc.w	Text_Kind
		dc.w	Text_Kind
		dc.w	Text_Kind
		dc.w	Listview_Kind
		dc.w	Slider_Kind
		dc.w	Button_Kind
		dc.w	Text_Kind

GadgetTags:
LengthTags:	dc.l	GTTX_Text,Puffer+LengthPuffer
		dc.l	GTTX_Border,1			*Length
		dc.l	0

PositionTags:	dc.l	GTTX_Text,Puffer+PositionPuffer
		dc.l	GTTX_Border,1			*Position
		dc.l	0

TimeTags:	dc.l	GTTX_Text,Puffer+TimePuffer
		dc.l	GTTX_Border,1			*Time
		dc.l	0

FileTags:	dc.l	GTTX_Text,Puffer+FileNamePuffer
		dc.l	GTTX_Border,1			*Name
		dc.l	0

		dc.l	GTLV_ShowSelected,0		*Formatliste
		dc.l	GTLV_CallBack,ListviewHook
		dc.l	0

		dc.l	GTSL_Min,MinFreq/FreqStep	*Slider
		dc.l	GTSL_Max,MaxFreq/FreqStep
		dc.l	PGA_Freedom,LORIENT_HORIZ
		dc.l	GA_RelVerify,1
SliderPos:	dc.l	GTSL_Level,2200
		dc.l	0

		dc.l	GT_Underscore,'_'		*Save Sample
		dc.l	Tag_Done

		dc.l	GTTX_Border,1
TextGadgetTags:	dc.l	GTTX_Text,Puffer+FrequencePuffer *Text
		dc.l	0

		dc.l	0


Gadgets:


GD_Length:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLG_Length:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_Length		;GadgetNr
		dc.l	Placetext_Left,0,0	;Flags,VisualInfo,Userdata

GD_Position:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLG_Position:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_Position		;GadgetNr
		dc.l	Placetext_Left,0,0	;Flags,VisualInfo,Userdata

GD_Time:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLG_Time:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_Time		;GadgetNr
		dc.l	Placetext_Left,0,0	;Flags,VisualInfo,Userdata

GD_Name:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLG_Name:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_Name		;GadgetNr
		dc.l	Placetext_Left,0,0	;Flags,VisualInfo,Userdata

GD_Infolist:	dc.w	0,0,0,0			;Left,Top,Width,Height
		dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_InfoList		;GadgetNr
		dc.l	0,0,0			;Flags,VisualInfo,Userdata

GD_Slider:	dc.w	0,0,0,0			;Left,Top,Width,Height
		dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_Slider		;GadgetNr
		dc.l	0,0,0			;Flags,VisualInfo,Userdata

GD_SaveSample:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLG_SaveSample:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_SaveSample	;GadgetNr
		dc.l	Placetext_In,0,0		;Flags,VisualInfo,Userdata

GD_Text:	dc.w	0,0,0,0			;Left,Top,Width,Height
LLG_Frequence:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_TextGadget	;GadgetNr
		dc.l	Placetext_Left,0,0	;Flags,VisualInfo,Userdata


MyIntuiText:	dc.w	0,0
		dc.w	0,0
		dc.l	0			*Font
		dc.l	0			*Text
		dc.l	0			*Next




	*------------------------- Menus -----------------------*
Menus:		dc.b	NM_Title,0
LLM_Project:	dc.l	0
		dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_Play:	dc.l	0
LLM_PlayKey:	dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_Stop:	dc.l	0
LLM_StopKey:	dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_SaveSample:	dc.l	0
LLM_SaveSampleKey:dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_ModuleCont:	dc.l	0
LLM_ModuleContKey:dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
		dc.l	NM_BARLABEL,0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_About:	dc.l	0
LLM_AboutKey:	dc.l	AboutKey
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_Hide:	dc.l	0
LLM_HideKey:	dc.l	HideKey
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
		dc.l	NM_BARLABEL,0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_Quit:	dc.l	0
		dc.l	QuitKey
		dc.w	0
		dc.l	0,0


		*---- Prefs ----*
		dc.b	NM_Title,0
LLM_Settings:	dc.l	0
		dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_Time:	dc.l	0
		dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_Sub,0
LLM_Vorwaerts:	dc.l	0
LLM_VorwaertsKey:dc.l	0
TimeVorwFlags:	dc.w	CHECKED!CHECKIT!Menutoggle
		dc.l	~1,0

		dc.b	NM_Sub,0
LLM_Rueckwaerts:dc.l	0
LLM_RueckwaertsKey:dc.l	0
TimeRueckFlags:	dc.w	CHECKIT!Menutoggle
		dc.l	~2,0

		dc.b	NM_ITEM,0
LLM_SamplesaverOn
		dc.l	0
		dc.l	0
SampleSaverOnFlags:
		dc.w	CHECKIT!Menutoggle
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_Backpic:	dc.l	0
		dc.l	0
BackPicFlags:	dc.w	CHECKIT!Menutoggle
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_ChooseBackpic:dc.l	0
		dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_ChooseFont:	dc.l	0
		dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
		dc.l	NM_BARLABEL,0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LLM_SaveConfig:dc.l	0
LLM_SaveConfigKey:dc.l	0
		dc.w	0
		dc.l	0,0


		dc.b	NM_END,0
		dc.l	0,0
		dc.w	0
		dc.l	0,0


MenuTags:	dc.l	GTMN_Newlookmenus,1
		dc.l	TAG_DONE


Listviewhook:	dcb.b	MLN_Size,0
		dc.l	Listview_hook
		dc.l	0
		dc.l	0


*----------------------------------------------------------------------------*
LocaleTabelle:
		dc.w	LENr_Quit,LLM_Quit-LocaleTabelle
		dc.w	LENr_Hide,LLM_Hide-LocaleTabelle
		dc.w	LENr_About,LLM_About-LocaleTabelle
		dc.w	LENr_Play,LLM_Play-LocaleTabelle
		dc.w	LENr_PlayKey,LLM_PlayKey-LocaleTabelle
		dc.w	LENr_Stop,LLM_Stop-LocaleTabelle
		dc.w	LENr_StopKey,LLM_StopKey-LocaleTabelle
		dc.w	LENr_SaveSampleMenu,LLM_SaveSample-LocaleTabelle
		dc.w	LENr_SaveSampleKey,LLM_SaveSampleKey-LocaleTabelle
		dc.w	LENr_ModuleCont,LLM_ModuleCont-LocaleTabelle
		dc.w	LENr_ModuleContKey,LLM_ModuleContKey-LocaleTabelle
		dc.w	LENr_Time,LLM_Time-LocaleTabelle

		dc.w	LENr_Vorwaerts,LLM_Vorwaerts-LocaleTabelle
		dc.w	LENr_VorwaertsKey,LLM_VorwaertsKey-LocaleTabelle
		dc.w	LENr_Rueckwaerts,LLM_Rueckwaerts-LocaleTabelle
		dc.w	LENr_RueckwaertsKey,LLM_RueckwaertsKey-LocaleTabelle

		dc.w	LENr_Size,LLG_Length-LocaleTabelle
		dc.w	LENr_Position,LLG_Position-LocaleTabelle
		dc.w	LENr_Time,LLG_Time-LocaleTabelle
		dc.w	LENr_Name,LLG_Name-LocaleTabelle
		dc.w	LENr_SaveSample,LLG_SaveSample-LocaleTabelle

		dc.w	LENr_SelectBackPic,LLM_ChooseBackPic-LocaleTabelle
		dc.w	LENr_BackPic,LLM_BackPic-LocaleTabelle
		dc.w	LENr_Frequence,LLG_Frequence-LocaleTabelle
		dc.w	LENr_WindowTitle,LL_WindowTitle-LocaleTabelle
		dc.w	LENr_Project,LLM_Project-LocaleTabelle
		dc.w	LENr_Settings,LLM_Settings-LocaleTabelle
		dc.w	LENr_SaveConfig,LLM_SaveConfig-LocaleTabelle

		dc.w	LENr_ChooseFont,LLM_ChooseFont-LocaleTabelle

		dc.w	LENr_SampleSaverOn,LLM_SampleSaveron-LocaleTabelle
		dc.w	0




*----------------------------------------------------------------------------*
InternalStrings:
MyProzessName:		dc.b	"EP_Moduleinfo.1",0
MyCreatorname:		dc.b	"Eagleeye of DEFECT",0
MySpecialInfo:		dc.b	"Showing many infos about the module.",0
EPUserPortName:		dc.b	"EAGLEPLAYERPORT",0
MyMsgPortName:		dc.b	"EP_Moduleinfo.Port",0

Helpnode_SaveConfig:	dc.b	"Save Config",0
HelpNode_BackPic:	dc.b	"BackPic",0
HelpNode_SelectBackPic:	dc.b	"SelectBackPic",0
HelpNode_Hide:		dc.b	"Hide",0
HelpNode_Quit:		dc.b	"Quit",0
HelpNode_About:		dc.b	"About",0
HelpNode_Slider:	dc.b	"Moduleinfo_Slider",0
Helpnode_Infoliste:	dc.b	"Moduleinfo_Infoliste",0
Helpnode_SaveSample:	dc.b	"Moduleinfo_SaveSample",0
Helpnode_Play:		dc.b	"Moduleinfo_Play",0
Helpnode_Vorwaerts:	dc.b	"Moduleinfo_Vorwaerts",0
Helpnode_Rueckwaerts:	dc.b	"Moduleinfo_Rueckwaerts",0
Helpnode_Modulecont:	dc.b	"Moduleinfo_ModuleCont",0
Helpnode_Stop:		dc.b	"Moduleinfo_Stop",0
Helpnode_ChooseFont:	dc.b	"Moduleinfo_ChooseFont",0
Helpnode_SamplesaverOn:	dc.b	"Moduleinfo_SamplesaverOn",0

ZiffernPuffer:		dc.b	"9999999999",0		;zur Breitenberechnung
Striche3:		dc.b	"---",0
ZeroBytes		= *-1

			if	test
DT_PicName:		dc.b	`SYS:prefs/patterns/misc`,0
Configdir:		dc.b	"EP:configs/",0
Enginedir:		dc.b	"EP:Engines/",0
			endc


QuitKey:		dc.b	"Q",0
HideKey:		dc.b	"H",0
AboutKey:		dc.b	"A",0
Fragezeichen:		dc.b	"?",0
ConfigName:		dc.b	"Moduleinfo.config",0
Catalogname:		dc.b	"EP_Moduleinfo.catalog",0
MyReqToolsname:		dc.b	"reqtools.library",0
MyASLname:		dc.b	"asl.library",0
MyDiskFontName:		dc.b	"diskfont.library",0
Datatypesname:		dc.b	"datatypes.library",0
Samplesaver:		dc.b	"Samplesaver",0
SampleMSGPortName:	dc.b	"EP_Samplesaver.Port",0
Unknown.MSG:		dc.b	"Unknown",0


ExternalStrings:
*-------------------------- Locale fr MakeCat -------------------------------*
LOCALE_START
*CATALOG	EP_Moduleinfo
*VERSION	38.2
*DATE		28.02.97


MSG_MI_WindowTitle	dc.b	"Moduleinfo",0
*D				'Moduleinfo',0
MSG_MI_Project		dc.b	"Project",0
*D				'Project',0
MSG_MI_Settings		dc.b	"Settings",0
*D				'Konfiguration',0
MSG_MI_About		dc.b	"About",0
*D				'ber',0
MSG_MI_Hide		dc.b	"Hide",0
*D				'Verstecken',0
MSG_MI_Quit		dc.b	"Quit",0
*D				'Ende',0
MSG_MI_BackPic		dc.b	"BackPic",0
*D				'Hintergrundbild',0
MSG_MI_SelectBackPic	dc.b	"Select BackPicture",0
*D				'Whle Hintergrundbild',0
MSG_MI_SaveConfig	dc.b	"Save Config",0
*D				'Speichere Konfiguration',0
MSG_MI_AboutText	dc.b	"Moduleinfo V2.02 by",10,10
			dc.b	"Jan Blumenthal",10
			dc.b	"Erich-Mhsam-Str. 34",10
			dc.b	"18069 Rostock",10
			dc.b	"Tel.: +49 (0)381/83979",10,10
			dc.b	"This engine can show some infos about",10
			dc.b	"the loaded module.",0

*D				'Moduleinfo V2.02 von',10,10
*D				'Jan Blumenthal',10
*D				'Erich-Mhsam-Str. 34',10
*D				'18069 Rostock',10
*D				'Tel.: +49 (0)381/83979',10,10
*D				'Dieses Engine zeigt einige Informationen',10
*D				'ber das geladene Modul an.',0
MSG_MI_Ok		dc.b	"_Ok",0
*D				'_Ok',0
MSG_MI_RequestTitle	dc.b	"Moduleinfo_Requester",0
*D				'Moduleinfo_Requester',0
MSG_MI_EPNotFound	dc.b	"Eagleplayer-Port not found!",0
*D				'Konnte den Eagleplayerport nicht finden',0
MSG_MI_Frequence	dc.b	"Frequency",0
*D				'Frequenz',0
MSG_MI_ModuleCont	dc.b	"Cont module",0
*D				'Modul weiterspielen',0
MSG_MI_ModuleContKey	dc.b	"C",0
*D				'W',0
MSG_MI_Play		dc.b	"Play",0
*D				'Spielen',0
MSG_MI_PlayKey		dc.b	"P",0
*D				'P',0
MSG_MI_Stop		dc.b	"Stop",0
*D				'Stopp',0
MSG_MI_StopKey		dc.b	"S",0
*D				'S',0
MSG_MI_SaveSample	dc.b	"Save S_ample",0
*D				'S_ample speichern',0
MSG_MI_SaveSampleMenu	dc.b	"Save Sample",0
*D				'Sample speichern',0
MSG_MI_SaveSampleKey	dc.b	"A",0
*D				'A',0
MSG_MI_Vorwaerts	dc.b	"Forward",0
*D				'Vorwrts',0
MSG_MI_VorwaertsKey	dc.b	"F",0
*D				'V',0
MSG_MI_Rueckwaers	dc.b	"Backwards",0
*D				'Rckwrts',0
MSG_MI_RueckwaertsKey	dc.b	"B",0
*D				'R',0
MSG_MI_Position		dc.b	"Position",0
*D				'Position',0
MSG_MI_Size		dc.b	"Size",0
*D				'Gre',0
MSG_MI_Name		dc.b	"Name",0
*D				'Name',0
MSG_MI_Time		dc.b	"Time",0
*D				'Zeit',0
MSG_MI_Soundsystem	dc.b	"Soundsystem: ",0
*D				'Soundsystem: ',0
MSG_MI_Ja		dc.b	"yes",0
*D				'ja',0
MSG_MI_Nein		dc.b	"no",0
*D				'nein',0
MSG_MI_Min		dc.b	" min. ",0
*D				' Min. ',0
MSG_MI_Sec		dc.b	" sec.",0
*D				' Sek.',0

MSG_MI_Songname		dc.b	"Songname: ",0
*D				'Songname: ',0
MSG_MI_Author		dc.b	"Author: ",0
*D				'Autor: ',0
MSG_MI_Duration		dc.b	"Duration: ",0
*D				'Spielzeit: ',0
MSG_MI_Loadsize		dc.b	"Loaded bytes: ",0
*D				'Geladene Bytes: ',0
MSG_MI_Calcsize		dc.b	"Calculated bytes: ",0
*D				'Berechnete Gre: ',0
MSG_MI_Songsize		dc.b	"Size of Songdata: ",0
*D				'Gre der Songdaten: ',0
MSG_MI_Samplessize	dc.b	"Size of Sampledata: ",0
*D				'Gre der Sampledaten: ',0
MSG_MI_Chipsize		dc.b	"Used Chipmemory: ",0
*D				'Benutzer Chipspeicher: ',0
MSG_MI_Othersize	dc.b	"Used other memory: ",0
*D				'Benutzer anderer Speicher: ',0
MSG_MI_SamplesAnz	dc.b	"Number of instruments: ",0
*D				'Instrumentenanzahl: ',0
MSG_MI_MaxSamples	dc.b	"Max. number of samples: ",0
*D				'Max. Anz von Instrumenten: ',0
MSG_MI_SynthSamples	dc.b	"Used synthsamples: ",0
*D				'Benutzte synthetische Instrumente: ',0
MSG_MI_MaxSynthsamples	dc.b	"Max. synthsamples: ",0
*D				'Max. Anzahl synthetischer Instrumente: ',0
MSG_MI_Length		dc.b	"Length of song: ",0
*D				'Lnge des Songs: ',0
MSG_MI_MaxLength	dc.b	"Max. length: ",0
*D				'Max. Lnge: ',0
MSG_MI_Patterns		dc.b	"Patterns in song: ",0
*D				'Pattern im Song: ',0
MSG_MI_MaxPatterns	dc.b	"Max. patterns: ",0
*D				'Max. Pattern: ',0
MSG_MI_UnpackedInfo	dc.b	"This is a packed soundmodule!",0
*D				'Dies ist ein gepacktes Soundmodul!',0
MSG_MI_Unpackedsystem	dc.b	"Unpacked soundformat: ",0
*D				'Entpacktes Soundformat: ',0
MSG_MI_Unpack		dc.b	"Unpacked filesize: ",0
*D				'Entpackte Filegre: ',0
MSG_MI_Subsongs		dc.b	"Subsongs in module: ",0
*D				'Untersongs im Modul: ',0
MSG_MI_MaxSubSong	dc.b	"Max. Subsongs: ",0
*D				'Max. Subsongs: ',0
MSG_MI_Voices		dc.b	"Used voices: ",0
*D				'Benutzte Stimmen: ',0
MSG_MI_MaxVoices	dc.b	"Max. voices: ",0
*D				'Max. Stimmen: ',0
MSG_MI_Steps		dc.b	"Steps in module: ",0
*D				'Schritte im Modul: ',0
MSG_MI_Maxsteps		dc.b	"Max. steps: ",0
*D				'Max. Schritte: ',0
MSG_MI_Prefix		dc.b	"Default fileprefix: ",0
*D				'Voreingestellter Fileprfix: ',0
MSG_MI_AboutReplayer	dc.b	"About the replayer: ",0
*D				'ber den Replayer: ',0
MSG_MI_ExtraInfo	dc.b	"Extra information: ",0
*D				'Extra Information: ',0
MSG_MI_Specialinfo	dc.b	"Special information: ",10,0
*D				'Spezielle Information: ',10,0
MSG_MI_Frequenz		dc.b	"Playing  frequency: ",0
*D				'Abspielfrequenz: ',0
MSG_MI_Boost		dc.b	"Volume  boost: ",0
*D				'Laustrkeerhhung: ',0
MSG_MI_Mode		dc.b	"Playing  mode: ",0
*D				'Abspielmodus: ',0

MSG_MI_OldSoundtracker	dc.b	"OldSoundtracker",0
*D				'OldSoundtracker',0
MSG_MI_Soundtracker	dc.b	"Soundtracker",0
*D				'Soundtracker',0
MSG_MI_Noisetracker	dc.b	"Noisetracker",0
*D				'Noisetracker',0
MSG_MI_ProTracker	dc.b	"Protracker",0
*D				'Protracker',0
MSG_MI_Instrumentenliste dc.b	10,"List of instruments:",0
*D				10,'Liste der Instrumente',0
MSG_MI_Bytes		dc.b	" Bytes",0
*D				' Bytes',0
MSG_MI_KeinSample	dc.b	"No Sample",0
*D				'Kein Instrument',0
MSG_MI_UnknownSize	dc.b	"Unknown Size",0
*D				'Unbekannte Gre',0
MSG_MI_ChooseFont	dc.b	"Choose Font",0
*D				'Schriftart auswhlen',0
MSG_MI_SamplesaverOn	dc.b	"Samplesaver",0
*D				'Sample-Speicherfunktionen',0
MSG_MI_Album		dc.b	"Album:",0
*D				'Album:',0
MSG_MI_Year		dc.b	"Date:",0
*D				'Datum:',0
MSG_MI_Comment		dc.b	"Comment:",0
*D				'Kommentar:',0
MSG_MI_Genre		dc.b	"Genre:",0
*D				'Stil:',0
MSG_MI_Bitrate		dc.b	"Bitrate:",0
*D				'Bitrate:',0

LOCALE_END
			dc.b	0		* <-- Kennung fr Ende



*-----------------------------------------------------------------------------*
		SECTION	BSSMErkPuffer,BSS
Puffer		ds.b	PufferEnd

	


