*****************************************************************************
**                                                                         **
** Engine: Messagewindow                                                   **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Author : Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 

	incdir	include:
	include	exec/exec_lib.i
	include	exec/libraries.i
	include	intuition/intuition.i
	include	intuition/intuition_LIB.i
	include	libraries/gadtools.i
	include	libraries/gadtools_lib.i
	include	dos/dos_lib.i
	include	libraries/dos.i
	include	graphics/graphics_lib.i
	include	misc/Eagleplayerengine.i
	include	misc/Buggsmacros.i
	;
Debug	= 0
Test = 0	;auf 0 lassen zur Nutzung mit dem Eagleplayer
		;zu Testzwecken meldet sich der Analyzer sonst selbst ab ,
		;interne Testfunktion

ver		macro
		dc.b	"1.02"
		endm
StructVer	macro
		dc.w	1,02
		endm
date		macro
		dc.b	"05-Apr-97"
		endm
StructDate	macro
		dc.b	05,04
		dc.w	1997
		endm

;===========================================================================
	section	0,code
;===========================================================================
win_breite = 480
maxmess = 200
;===========================================================================
BEGIN
	bra.w	fangan
	EUSN_Identifier
	dc.l	0		;eus_next

	ifne	debug
	dc.w	-2
	else
	dc.w	0		;eus_Usernr
	endc
myepbase
	dc.l	0		;eus_EPBase
	dc.l	0		;eus_Freetable
	dc.l	0		;eus_Taskadr
	dc.l	0		;eus_unused1
	dc.l	0		;eus_unused2
	dc.l	0		;eus_unused3
	dc.l	Tagliste	;eus_unused4
	dc.w	0		;eus_ticks
	dc.w	0		;eus_tickcounter
	dc.l	0		;eus_tickflags
eus_msgflags1
	dc.l	USMB_ChangeConfig!USMB_NewScrollText;eus_msgflags
	dc.l	MyAnalyzername	;eus_PName
	dc.l	MyBuggsname	;eus_Cname
	dc.l	myinfo
	dc.w	37		;eus_Kickstart
	dc.l	Eagleversion	;eus_EPVersion
	structver		;eus_version,revision
	dc.l	MyUsername	;eus_username
	dc.w	520		;eus_winx
	dc.w	72		;eus_winy
	dc.w	EUSB_openwin	;EUS_Flags, Window offen
	dc.w	0		;EUS_Special   = Winx
	dc.w	0		;           +2 = Winy
	dc.l	0		;EUS_Special2
	dc.l	0		;EUS_Special3
	structdate		;EUS_Creatordate
	dc.b	0		;EUS_Priority
	dc.b	EUTY_Messagewindow
	dc.w	0
	dc.l	0		;EUS_Reserved3
	dc.l	0		;EUS_Reserved4
	dc.l	0		;EUS_Reserved5
	dc.l	0		;EUS_Reserved6

		ifne	(*-begin)-EUS_SizeOF
		Aber Hallo
		endc

	dc.b	`$VER: Eagleplayer MessageWindow `
	ver
	dc.b	`, (`
	date
	dc.b	`) `,0
	even


Tagliste:	dc.l	EUT_SpecialinfoLNr,LNrE_SpecialInfo_Messagewindow
		*dc.l	EUT_AttnFlags,1<<6!1<<3
		dc.l	0


fangan
	move.l	4,a6

	lea	datas,a5
	move.l	a5,a0
	move.w	#dataslen-1,d0
.clr	move.b	#0,(a0)+
	dbf	d0,.clr

	suba.l	A1,A1
	JSR	_LVOfindtask(A6)
	move.l	d0,mytask(a5)

	lea	dos(pc),a1
	moveq	#37,d0			;Brauchen DOS V1.2,fr Message,falls
	jsr	_LVOopenlibrary(a6)	;Start von 1.2/1.3 aus
	move.l	d0,_dos(a5)
	beq	NODOS

	ifne	test
	cmp.w	#37,LIB_Version(a6)	;EXEC V37 ?
	bge.s	.Dos_ok		;ja->Weiter

	move.l	_DOS(a5),a6
	lea	confile(pc),a0
	move.l	a0,d1
	move.l	#mode_oldfile,d2
	jsr	_LVOopen(a6)
	tst.l	d0
	beq.s	.Blossraus	;Nicht einmal AUSGABE auf CON: funtioniert
	move.l	d0,d6
	move.l	d0,d1

	lea	conout(pc),a0
	move.l	a0,d2
	moveq	#conlen,d3
	jsr	_LVOwrite(a6)	;Ausgabe "Needs Amiga OS2.04 or higher"

	move.l	#250,d1		;~5 Sekunden warten
	jsr	_LVOdelay(a6)

	move.l	d6,d1		;Con schlieen
	jsr	_LVOclose(a6)
.blossraus
	bra	NoPort
	endc
.dos_ok
	move.l	4,a6
	jsr	_LVOcreatemsgport(a6)	;Messageport auf die schnelle Art
	move.l	d0,MSGport(a5)
	beq	NoPort

	lea	int(pc),a1
	moveq	#37,d0
	jsr	_LVOopenlibrary(a6)
	move.l	d0,intsave(a5)
	beq	NOINT

	lea	graf(pc),a1
	moveq	#37,d0
	jsr	_LVOopenlibrary(a6)
	move.l	d0,grafsave(a5)
	beq	NOGRAF

	lea	gad(pc),a1
	moveq	#37,d0
	jsr	_LVOopenlibrary(a6)
	move.l	d0,gadsave(a5)
	beq	nogadto

	moveq	#0,d7

	ifeq	test

	bsr	sendfirstmessage	;Message an Eagleplayer senden,da
					;der Analyzer gern mal die Struktur-
					;Adresse haben mchte
	blt	endme	;Fehler aufgetreten

	else

	move.l	#testmess,messbase(A5)
	move.l	#12,messagenum(A5)
	bsr	openwin
	bsr	domessages
	endc


	bsr	HandleActions		;Auf Usereingaben reagieren
endme
	move.l	d7,-(sp)
	bsr	deleteall
	bsr	closewin
	move.l	(sp)+,d7		;Error oder Exit-Message vom Player

	ifeq	test
	tst.l	d7
	blt.s	.nola

	bsr	sendlastmessage

.nola
	endc

	move.l	mypubscreen(a5),d0
	beq.s	.ok
	move.l	d0,a1
	suba.l	a0,a0
	jsr	_LVOunlockpubscreen(a6)
.ok
	move.l	gadsave(a5),a1
	move.l	4.w,a6
	jsr	_LVOcloselibrary(A6)
nogadto
	move.l	grafsave(a5),a1
	move.l	4.w,a6
	jsr	_LVOcloselibrary(a6)
NoGraf
	move.l	intsave(a5),a1
	move.l	4.w,a6
	jsr	_LVOcloselibrary(a6)
noint
	move.l	4.w,a6
	move.l	MSGport(a5),a0
	jsr	_LVOdeletemsgport(a6)
NoPort
	move.l	4.w,a6
	move.l	_dos(a5),a1
	jsr	_LVOcloselibrary(a6)
nodos
	moveq	#0,d0
	rts
************************************************************************
*                   Fenster ffnen                                     *
************************************************************************
Openwin
	tst.l	winhandle(a5)
	bne.w	.Error2

	move.l	intsave(a5),a6

	lea	begin(pc),a0
	move.l	eus_epbase(a0),d0
	beq.s	.noep
	move.l	d0,a0
	move.l	EPG_Pubscreen(a0),d0
.noep
	move.l	d0,a0

	jsr	_LVOlockpubscreen(A6)	;aktuellen Publicscreen rauskriegen
	tst.l	d0
	bne.s	.pubs

	suba.l	a0,a0
	jsr	_LVOlockpubscreen(A6)	;aktuellen Publicscreen rauskriegen
	tst.l	d0
	beq	.Error2			;sollte nicht auftreten

.pubs
	move.l	d0,mypubscreen(a5);fr UnLockpubscreen()
	move.l	d0,a1
	move.l	sc_font(a1),a0
	move.l	a0,fontatt(a5)

	move.w	ta_ysize(a0),d0		;Hhe des Screenfonts
	move.w	d0,d1
	add.w	#3,d1			;Berechnen der Gre fr ZIPwindow()
	move.w	d1,myhoehe1(a5)		;und eintragen

	lea	begin(pc),a1
	move.w	eus_special(a1),d0
	cmp.w	#80,d0
	bge.s	.ok
	move.w	#win_breite,d0
.ok
	move.w	d0,winwidth(a5)

	moveq	#0,d0
	move.w	eus_special+2(a1),d0
	cmp.w	#8+8+5,d0
	bge.s	.ok2
	move.w	#100,d0
.ok2
	add.w	myhoehe1(A5),d0
	move.l	d0,d1
	move.w	d0,win_height(A5)

	movem.l	d0-d6/a0-a6,-(sp)
	bsr	makemenus		;Mens basteln
	movem.l	(sp)+,d0-d6/a0-a6
	tst.l	d7
	blt.w	.Error

	lea	mytags(a5),a1		;WINDOW INIT

	move.l	#WA_Pubscreen,(a1)+
	move.l	mypubscreen(A5),(a1)+

	move.l	#WA_Newlookmenus,(a1)+
	move.l	#1,(a1)+

	move.l	#wa_Pubscreenfallback,(A1)+
	move.l	#1,(a1)+

	lea	begin(pc),a0
	moveq	#0,d0
	move.l	#wa_top,(a1)+
	move.w	eus_winy(a0),d0
	move.l	d0,(a1)+
	move.l	#wa_left,(a1)+
	move.w	eus_winx(a0),d0
	move.l	d0,(a1)+
	move.l	#wa_width,(a1)+		;Breite

	move.w	winwidth(A5),d0
	move.l	d0,(a1)+	;	20Spalten+15*8Pixel fr Gadgets+Rand

	move.l	#wa_height,(a1)+	;Hhe

	move.w	win_height(A5),d0
	move.l	d0,(a1)+

	move.l	#wa_minwidth,(a1)+
	move.l	#160,(a1)+
	move.l	#wa_minheight,(a1)+
	move.w	myhoehe1(a5),d1
	add.w	#8+8+5,d1
	move.l	d1,(a1)+
	move.l	#wa_maxwidth,(a1)+
	move.l	#1024,(a1)+
	move.l	#wa_maxheight,(a1)+
	move.l	#768,(a1)+
	move.l	#wa_flags,(a1)+
	move.l	#Windowsizing!Windowdrag!Windowdepth!Windowclose,(a1)+
	move.l	#WA_TITLE,(a1)+
	lea	mywinname(pc),a0
	move.l	a0,(a1)+
	move.l	#wa_zoom,(a1)+
	lea	myzoom(a5),a0
	move.w	#0,(a0)
	move.w	#79,2(a0)
	move.w	#168,4(a0)		;Breite des Zip-Windows im SMALL-MODE
	move.w	myhoehe1(a5),myhoehe2(a5)
	move.l	a0,(a1)+
	move.l	#wa_idcmp,(a1)+
 move.l	#idcmp_changewindow!gadgetdown!closewindow!vanillakey!menupick!refreshwindow,(a1)+
	move.l	#wa_autoadjust,(a1)+
	move.l	#1,(a1)+

	move.l	#WA_ScreenTitle,(a1)+
	move.l	#Project0STitle,(a1)+

	move.l	#TAG_DONE,(a1)+

	suba.l	a0,a0
	lea	mytags(a5),a1
	move.l	intsave(a5),a6
	jsr	_LVOopenwindowtaglist(a6)
	move.l	d0,Winhandle(a5)
	tst.l	d0
	bne.s	.winopened

	lea	mytags(a5),a1		;Fehler,nochmal auf Position 0/0
	move.l	#wa_top,(a1)+		;zu ffnen versuchen
	move.l	#0,(a1)+
	move.l	#wa_left,(a1)+
	move.l	#0,(a1)+

	suba.l	a0,a0
	lea	mytags(a5),a1
	move.l	intsave(a5),a6
	jsr	_LVOopenwindowtaglist(a6)	;wirst DU wohl aufgehen !
	move.l	d0,Winhandle(a5)
	tst.l	d0

	beq.w	.Error
.winopened
	move.l	d0,a0
	move.l	wd_userport(a0),d0	;User Port
	move.l	d0,port(a5)

	move.l	grafsave(A5),a6
	move.l	wd_rport(A0),a1
	lea	myfontatt(a5),a0
	jsr	_LVOAskfont(A6)

	lea	myfontatt(a5),a0
	jsr	_LVOOpenfont(A6)	
	tst.l	d0
	beq.s	.error
	move.l	d0,a1
	move.w	tf_baseline(A1),fontbase(A5)
	jsr	_LVOclosefont(A6)
	
	lea.l	myfontatt(a5),a0
	move.w	ta_ysize(a0),d1		;Hhe des Screenfonts
	move.w	d1,fonth(a5)
	add.w	myhoehe1(a5),d1
	move.l	winhandle(a5),a0
	move.b	wd_borderbottom(A0),d0
	ext.w	d0
	add.w	d0,d1
	add.w	#8+2,d1

	moveq	#0,d0
	moveq	#0,d2
	moveq	#0,d3
	move.l	intsave(a5),a6
	jsr	_LVOwindowlimits(A6)

	bsr	Addgad
	bsr	addmenus		;Men darstellen
	bsr	refresh
	move.l	intsave(a5),a6
	suba.l	a0,a0
	move.l	mypubscreen(a5),d0
	beq.s	.nopub
	move.l	d0,a1
	clr.l	mypubscreen(a5)
	jmp	_LVOunlockpubscreen(a6)	;PUBscreen freigeben
.nopub	
.error2
	rts
.error
;	bra	closewin
*******************************************************************
*                   Window schlieen                              *
*******************************************************************
Closewin
	tst.l	winhandle(a5)
	beq.s	.nowin

	bsr	freegad
	bsr	freemenus
	
	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	clr.l	Winhandle(a5)
	clr.l	port(a5)
	move.w	myhoehe1(a5),d0
	move.w	wd_height(a0),d1
	sub.w	d0,d1

	lea	begin(pc),a1
	move.w	wd_leftedge(a0),eus_winx(a1)
	move.w	wd_topedge(a0),eus_winy(a1)
	move.w	d1,eus_special+2(a1)
	move.w	wd_width(a0),eus_special(a1)
.noxy
	jsr	_LVOclosewindow(a6)
.nowin	rts
********************************************************************
*                  Init Message Struktur                           *
********************************************************************
Sendfirstmessage
	move.l	4,a6
	lea	Portname(pc),a1
	jsr	_LVOfindport(a6)
	tst.l	d0
	bne.s	.ok
	bsr	openwin
	lea	NoportMessage(pc),a0
	lea	my_easystruct(a5),a1
	move.l	a0,es_textformat(a1)
	lea	my_easygadget2(pc),a0
	move.l	a0,es_gadgetformat(a1)
	lea	my_easytitle(pc),a0
	move.l	a0,es_Title(a1)
	move.l	winhandle(a5),d0	;*Window
	beq.w	.error	;kann kein Window ffnen
	move.l	d0,a0
	suba.l	a2,a2			;*IDCMP_ptr
	suba.l	a3,a3			;*Arguments
	move.l	Intsave(a5),a6
	jsr	_LVOeasyrequestargs(a6)
	tst.l	d0
	beq.s	.error
	bra	SendFirstmessage
.ok
	move.l	d0,a0			;Portadresse

	move.l	msgport(a5),d3
	move.l	mytask(a5),d4
	moveq	#-1,d5
	move.w	#USclass_Newuserprg,d6

	ifne	debug

	bsr	allocmsg
	beq.s	.error
	move.l	d0,a1			;Messageadresse

	move.w	#UM_sizeof-20,mn_length(a1)
	move.b	#nt_message,ln_type(a1) ;Message-Typ
	lea	begin(pc),a2
	move.l	a2,um_result(A1)
	move.w	#-2,UM_UserNr(a1)

	move.l	#USM_Userprg,UM_Type(a1)

	move.l	d3,mn_replyport(a1)	;Portadresse,an die
						;zurckgesendet wird
	move.l	d3,UM_Userport(a1)
	move.l	d4,UM_TaskAdr(a1)
	move.l	d5,UM_Signal(a1)
	move.w	d6,UM_class(a1)

	move.l	4,a6
	jsr	_LVOputmsg(a6)

	else
	bsr	sendmess
	endc

	moveq	#0,d7
	rts
.error
	moveq	#-1,d7
	rts
*****************************************************************
allocmsg
	movem.l	d1-a6,-(sp)
	move.l	4,a6
	moveq	#UM_Sizeof,d0
	move.l	#$10001,d1
	jsr	_LVOallocmem(A6)
	movem.l	(sp)+,d1-a6
	tst.l	d0
	rts
*****************************************************************
freemsg
	moveq	#UM_sizeof,d0
	move.l	4,a6
	jsr	_LVOfreemem(A6)
	rts
*******************************************************************************
sendmess:
	bsr	allocmsg
	bne.s	.ok
	rts
.ok
	move.l	d0,a1			;Messageadresse

	move.w	#UM_sizeof-20,mn_length(a1)
	move.b	#nt_message,ln_type(a1) ;Message-Typ

	ifne	debug
	move.w	saveusernr(a5),UM_UserNr(a1)
	else
	lea	begin(pc),a2
	move.w	EUS_Usernr(A2),UM_UserNr(a1)
	endc
	move.l	#USM_Userprg,UM_Type(a1)

	move.l	d3,mn_replyport(a1)	;Portadresse,an die
						;zurckgesendet wird
	move.l	d3,UM_Userport(a1)
	move.l	d4,UM_TaskAdr(a1)
	move.l	d5,UM_Signal(a1)
	move.w	d6,UM_class(a1)

	move.l	4,a6
	jmp	_LVOputmsg(a6)

******************************************************************************
* Abschiedsgru an Eagleplayer,der dann wei,da der Analyzer geendet hat    *
******************************************************************************
Sendlastmessage:
	move.l	4,a6
	lea	Portname(pc),a1	;EaglePlayer finden
	jsr	_LVOfindport(a6)
	tst.l	d0
	beq.s	.ok	;Eagleplayer hat sich schon verabschiedet

	move.l	d0,a0			;Portadresse
	move.l	msgport(a5),d3
	moveq	#0,d4
	moveq	#0,d5
	move.w	#USclass_exit,d6
	bsr	sendmess
.wait
	move.l	MSGport(a5),a0
	jsr	_LVOwaitport(a6)
	move.l	MSGport(a5),a0
	jsr	_LVOgetmsg(a6)
	tst.l	d0
	beq.s	.wait
	move.l	d0,a1
	cmp.l	#USM_Userprg,UM_Type(a1)
	beq.s	.meine
.nichtmeine
	jsr	_LVOreplymsg(a6)
	bra.s	.wait
.meine
.ok
	rts
*******************************************************************************
*                        Mens erstellen                                      *
*******************************************************************************
MakeMenus
	move.l	gadsave(a5),A6

	move.l	mypubscreen(a5),a0
	suba.l	a1,a1
	jsr	_LVOgetvisualinfoa(a6)	;Visual Info vom Screen anfordern
	move.l	d0,vi(a5)
	tst.l	d0
	beq	.nomen

	lea	mymenus(A5),a0
	move.b	#nm_title,gnm_type(a0)
	lea	mylabel1(pc),a1
	move.l	a1,gnm_Label(a0)

	move.b	#nm_item,gnm_type+gnm_sizeof*1(a0)
	lea	mylabel0(pc),a1
	move.l	a1,gnm_Label+gnm_sizeof*1(a0)

	move.b	#nm_item,gnm_type+gnm_sizeof*2(a0)
	lea	mylabel2(pc),a1
	move.l	#NM_BARLABEL,gnm_Label+gnm_sizeof*2(a0)

	move.b	#nm_item,gnm_type+gnm_sizeof*3(a0)
	lea	mylabel2(pc),a1
	move.l	a1,gnm_Label+gnm_sizeof*3(a0)
	lea	mylabel21(pc),a1
	move.l	a1,gnm_CommKey+gnm_sizeof*3(a0)

	move.b	#nm_item,gnm_type+gnm_sizeof*4(a0)
	lea	mylabel3(pc),a1
	move.l	a1,gnm_Label+gnm_sizeof*4(a0)
	lea	mylabel31(pc),a1
	move.l	a1,gnm_CommKey+gnm_sizeof*4(a0)
	
	move.b	#nm_item,gnm_type+gnm_sizeof*5(a0)
	lea	mylabel4(pc),a1
	move.l	a1,gnm_Label+gnm_sizeof*5(a0)
	lea	mylabel41(pc),a1
	move.l	a1,gnm_CommKey+gnm_sizeof*5(a0)
	
	move.b	#nm_end,gnm_type+gnm_sizeof*6(a0)

	move.l	gadsave(a5),a6
	lea	mytags(a5),a1
	move.l	#gtmn_fullmenu,(a1)+
	move.l	#1,(a1)+
	move.l	#GTMN_Newlookmenus,(a1)+
	move.l	#1,(A1)+
	move.l	#tag_done,(a1)+
	lea	mytags(a5),a1

	jsr	_LVOcreatemenusA(a6)
	move.l	d0,menuadr(a5)
	tst.l	d0
	beq.s	.nomen
	move.l	d0,a0
	move.l	vi(a5),a1

	lea	mytags(a5),a2
	move.l	#GTMN_Newlookmenus,(a2)+
	move.l	#1,(A2)+
	move.l	#tag_done,(a2)+
	lea	mytags(a5),a2

	jsr	_LVOLayoutMenusA(a6)
	tst.l	d0
	beq.s	.free
	
	moveq	#0,d7
	rts
.free
	move.l	menuadr(a5),a0
	jsr	_LVOfreemenus(a6)
.nomen
	moveq	#-1,d7
	rts
********************* Visual Info Freigeben ***********************************
Freevi:
	move.l	vi(a5),a0
	jmp	_LVOfreevisualinfo(a6)
*********************** Men wechschmeisen ************************************
Freemenus
	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	jsr	_LVOclearmenustrip(A6)
	
	move.l	gadsave(a5),a6
	move.l	Menuadr(a5),d0
	beq.s	.end
	move.l	d0,a0
	jmp	_LVOfreemenus(a6)
.end
	bsr	Freevi	;Visual Info Wegschmeien
RET	rts
********************* Men anhngen *************************
Addmenus
	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	move.l	Menuadr(a5),a1
	jmp	_LVOsetmenustrip(a6)
***************************************************************************
*                    Gadget erstellen (Slider)                            *
***************************************************************************
Addgad
	move.l	winhandle(A5),a0
	moveq	#0,d5
	move.b	wd_borderbottom(a0),d5
	ext.w	d5
	neg.w	d5
	add.w	wd_height(a0),d5
	sub.w	myhoehe1(a5),d5
	sub.w	#5+5,d5
	divu	fonth(a5),d5
	move.w	d5,maxvisible(A5)

	suba.l	a0,a0
	lea	propclass(pc),a1
	lea	mytags(a5),a2
	move.l	#GA_ID,(a2)+
	move.l	#2,(A2)+
	move.l	#Ga_top,(A2)+
	moveq	#0,d0
	move.w	myhoehe1(a5),d0
	addq.w	#1,d0
	move.l	d0,(A2)+
	move.l	#GA_Width,(A2)+
	move.l	#10,(a2)+
	move.l	#Ga_left,(a2)+
	move.l	#12,(a2)+
	move.l	#Ga_relheight,(A2)+
	neg.l	d0
	sub.l	#12,d0
	move.l	d0,(a2)+
	move.l	#Ga_relright,(A2)+
	move.l	#-12,(a2)+
	move.l	#GA_rightBorder,(a2)+
	move.l	#1,(a2)+
	move.l	#GA_immediate,(a2)+
	move.l	#1,(a2)+
	move.l	#PGA_freedom,(a2)+
	move.l	#freevert,(A2)+
	move.l	#PGA_total,(a2)+
	move.l	messagenum(a5),(a2)+
	move.l	#PGA_visible,(A2)+
	move.l	d5,(a2)+
	move.l	#PGA_top,(a2)+
	move.l	#0,(a2)+
	move.l	#PGA_Newlook,(a2)+
	move.l	#1,(a2)+
	move.l	#PGA_Borderless,(a2)+
	move.l	#1,(a2)+
	move.l	#TAG_DONE,(A2)
	lea	mytags(a5),a2
	move.l	intsave(A5),a6
	jsr	_LVOnewobjecta(a6)	
	move.l	d0,myobject(A5)
	tst.l	d0
	beq.w	RET
	move.l	d0,a1
	move.l	winhandle(A5),a0
	moveq	#-1,d0
	jsr	_LVOaddgadget(A6)

	move.l	myobject(A5),a0
	move.l	winhandle(A5),a1
	moveq	#-1,d0
	suba.l	a2,a2
	jmp	_LVOrefreshglist(A6)
freegad
	move.l	myobject(a5),d0
	beq.w	RET
	move.l	d0,a1
	move.l	winhandle(A5),a0
	move.l	intsave(a5),a6
	jsr	_LVOremovegadget(A6)

	move.l	myobject(A5),a0
	jmp	_LVOdisposeobject(A6)
*************************************************************
*           Windowrefresh und Detaildarstellung             *
*************************************************************
Refresh:
	move.l	winhandle(a5),d0
	beq.w	RET
	move.l	d0,a0

	move.l	winhandle(A5),a4
	move.l	grafsave(a5),a6

	move.l	wd_rport(a4),a1
	moveq	#0,d0
	jsr	_LVOsetapen(A6)

	move.l	wd_rport(a4),a1
	moveq	#0,d0
	jsr	_LVOsetbpen(A6)

	move.l	wd_rport(a4),a1
	moveq	#1,d0			;RP_Jam2
	jsr	_LVOsetdrmd(A6)

	move.l	wd_rport(a4),a1

	move.b	wd_borderleft(a4),d0
	ext.w	d0			;x1
	move.b	wd_bordertop(a4),d1
	ext.w	d1			;y1

	move.b	wd_borderright(A4),d2
	ext.w	d2
	neg.w	d2
	add.w	wd_width(a4),d2		;x2

	move.b	wd_borderbottom(A4),d3
	ext.w	d3
	neg.w	d3
	add.w	wd_height(A4),d3	;y2
	jsr	_LVOrectfill(a6)

	move.l	gadsave(a5),a6
	move.l	wd_rport(a4),a0
	lea	mytags(a5),a3
	move.l	#GT_Visualinfo,(a3)+
	move.l	vi(a5),(a3)+
	move.l	#GTBB_recessed,(a3)+
	move.l	#1,(a3)+
	move.l	#tag_done,(a3)+
	lea	mytags(a5),a3		;TagList mu in A3 und A1 sein !!!!!!!
	move.l	a3,a1

	move.b	wd_borderleft(a4),d0
	ext.w	d0
	addq.w	#3,d0

	move.w	wd_height(a4),d3
	move.b	wd_borderbottom(a4),d1
	ext.w	d1
	sub.w	d1,d3
	move.b	wd_bordertop(a4),d1	;Top
	ext.w	d1
	addq.w	#3,d1
	sub.w	d1,d3
	subq.w	#3,d3

	move.b	wd_borderright(A4),d2
	ext.w	d2
	neg.w	d2
	add.w	wd_width(a4),d2
	sub.w	d0,d2
	subq.w	#3,d2
	jsr	_LVOdrawbevelboxa(a6)

	move.l	winhandle(A5),a0
	move.l	intsave(a5),a6
	jsr	_LVOrefreshwindowframe(A6)

	bra	domessages		;Messages ausgeben
*************************************************************
*           Nachrichtenbearbeitung                          *
*************************************************************
HandleActions
.ma
	move.l	4,a6
	move.l	port(a5),d0
	beq.s	.nowinport
	move.l	d0,a0
	jsr	_LVOgetmsg(a6)
	tst.l	d0
	bne	.msg
.nowinport
	move.l	msgport(a5),a0
	jsr	_LVOgetmsg(a6)
	tst.l	d0
	bne	.AN_msg
	
	moveq	#0,d0

	move.l	4,a6
	move.l	port(a5),d2
	beq.s	.maul
	move.l	d2,a0
	move.b	mp_sigbit(a0),d1
	bset	d1,d0
.maul
	move.l	msgport(a5),a0
	move.b	mp_sigbit(a0),d1
	bset	d1,d0
	jsr	_LVOwait(a6)
	bra	.ma
.AN_msg
	move.l	d0,a1

	move.l	MSGPort(a5),UM_Userport(a1)

	ifne	debug
	move.w	saveusernr(a5),UM_UserNr(a1)
	else
	lea	begin(pc),a2
	move.w	EUS_Usernr(A2),UM_UserNr(a1)
	endc

	move.l	mytask(a5),UM_TaskAdr(a1)
	moveq	#-1,d1
	move.l	d1,UM_Signal(a1)

	move.w	UM_class(a1),d3		<-
	move.l	UM_Type(a1),d7
	move.w	UM_Signal(a1),d5 	<-
	move.l	UM_structadr(a1),d6 	<-

	clr.w	UM_class(A1)

	move.l	UM_Result(a1),SaveResult(A5)

	move.l	UM_ArgString(A1),d0
	beq.s	.notanswered
	clr.l	UM_Argstring(a1)
	move.l	d0,Savestring(A5)
.notanswered
	cmp.w	#USclass_getconfig,d3		;when this command comes,set
						;the actual preferences into
						;the Eagleuser-Structure
						;(EUS_-structure at the be-
						;ginning of the program)
	bne	.noprev

	lea	begin(pc),a2

	moveq	#0,d0
	move.l	winhandle(A5),d1		;Window
	beq.s	.prnowin			;no Window opened,no change
						;of preferences
	move.l	d1,a0
	move.w	wd_leftedge(a0),eus_winx(a2)
	move.w	wd_topedge(a0),eus_winy(a2)
	move.w	myhoehe1(a5),d0
	move.w	wd_height(a0),d1
	sub.w	d0,d1
	move.w	d1,eus_special+2(a2)
	move.w	wd_width(a0),eus_special(a2)

	move.w	#eusb_openwin,d0		;set Flag: window is open
.prnowin
	move.w	d0,eus_flags(a2)		;Save Flags
	bra.s	.nopre2
.noprev
	move.w	#USCLASS_Dummy,UM_class(a1)
.nopre2
	cmp.w	#USclass_Show,d3
	beq.w	.win
	cmp.w	#USclass_Activate,d3
	bne.w	.nowin
.Win:
	move.l	Begin+EUS_EPBase(pc),a0
	move.l	EPG_SomePrefs(a0),d0
	btst	#EGPRF_Iconify,d0
	bne.w	.nowin
	push	all
	bsr	Openwin
	pop	all

	tst.l	Winhandle(A5)
	beq.s	.noshow
	move	d3,UM_Class(a1)
.noshow

.nowin
	cmp.w	#USclass_Hide,d3
	beq.s	.closewin
	cmp.w	#USclass_DeActivate,d3
	bne.s	.noclosewin
.Closewin:
	push	all
	bsr	Closewin
	pop	all
.noclosewin

	move.l	mn_replyport(a1),d0
	cmp.l	MSGport(a5),d0		 ;eine von uns abgeschickte Message ?
	beq.s	.noreply
	jsr	_LVOreplymsg(a6)
.noreply
	cmp.l	#USM_Eagleplayer,d7	;Hat EaglePlayer was zu melden ?
	beq	.mess
	bsr	freemsg
.mess
	cmp.w	#USclass_Dummy,d3	;leere Message,nur neue Analyzer-
	beq.w	.ma			;adresse bekommen

	cmp.w	#USClass_NewScrollText,d3	;oder wie auch immer die class
	bne.w	.nomess				;bne.s !	;heien wird


* Added by Eagleeye
	move.l	SaveString(a5),d0
	beq.w	.Ma
	move.l	d0,a3
	*tst.l	EPT_StringSize(A3)
	*beq.s	.NoLast
	move.l	LastText(a5),d0
	beq.w	.NoLast

		movem.l	d1-a6,-(a7)
		move.l	d0,a0
		lea	8(A0),a0
		lea	EPT_String(a3),a1
.NochmalBeide:	move.b	(a0)+,d1
.Nochmala1:	move.b	(a1)+,d0
		cmp.b	#"|",d0
		beq.s	.NochmalA1
		tst.b	d1
		beq.s	.dasWars
		cmp.b	d0,d1
		beq.s	.NochmalBeide
.dasWars:	movem.l	(a7)+,d1-a6
		tst.b	d0
		beq.w	.ma
.NoLast:
* Added by Eagleeye


	move.l	Savestring(A5),d0
	beq	.ma
	clr.l	savestring(A5)
	clr.l	LastText(a5)			* Added by Eagleeye
.messloop
	move.l	d0,a3

	move.l	EPT_Stringsize(a3),d0
	add.l	#30,d0
	move.l	#$10001,d1
	move.l	4,a6
	jsr	_LVOallocmem(A6)
	tst.l	d0
	beq	.nextmess

	tst.l	LastText(a5)			* Added by Eagleeye
	bne.s	.NichtAendern			* Added by Eagleeye
	move.l	d0,LastText(a5)			* Added by Eagleeye
.NichtAendern:

	move.l	d0,a4
	clr.l	(A4)
	lea	8(a4),a2
	lea	EPT_String(a3),a0
	moveq	#0,d1
	move.l	ept_stringsize(a3),d2
	move.w	d2,4(a4)
	add.w	#30,4(a4)			;Memsize

	sub.w	#EPT_String+1,d2
.addstring
	move.b	(a0)+,d0
	cmp.b	#"|",d0				* Added by Eagleeye
	beq.s	.NotThis			* Added by Eagleeye
	cmp.b	#32,d0
	blo.s	.endst
	addq.w	#1,d1
	move.b	d0,(A2)+
.NotThis:tst.b	d0
	dbeq	d2,.addstring
.endst
	*move.b	#32,(A2)			* Added by Eagleeye

	move.w	d1,6(a4)			;Stringsize

	move.l	messbase(a5),d0
	bne.s	.me
	move.l	a4,messbase(A5)
	move.l	#1,messagenum(A5)
	move.l	a4,d0
	bra.s	.nextmess
.me
	move.l	d0,a2
	move.l	messagenum(a5),d0
	cmp.l	#maxmess,d0
	blt.s	.nummessok

	move.l	messbase(A5),a1			;1. Mess
	move.l	(A1),a2				;2. Mess
	move.l	a2,messbase(A5)			;2. Mess -> 1. Mess

	moveq	#0,d0
	move.w	4(a1),d0			;Memsize
	move.l	4,a6
	jsr	_LVOfreemem(A6)
	bra.s	.oldnum
.nummessok
	addq.l	#1,messagenum(A5)
.oldnum
	move.l	(A2),d0
	beq.s	.last
	move.l	d0,a2
	bra.s	.oldnum
.last	move.l	a4,(a2)				;neue Struct eintragen

.nextmess
	move.l	a3,a1
	move.l	(a3),d6
	move.l	EPT_Stringsize(A1),d0
	move.l	4,a6
	jsr	_LVOfreemem(A6)
	move.l	d6,d0
	beq	.setpga
	bra.w	.messloop
.setpga
	tst.l	winhandle(A5)
	beq	.ma

	move.l	intsave(A5),a6
	lea	mytags(a5),a1
	move.l	#PGA_total,(a1)+
	move.l	messagenum(a5),d0
	move.l	d0,(a1)+
	move.l	#PGA_top,(a1)+
	sub.w	maxvisible(a5),d0
	bge.s	.okvis
	moveq	#0,d0
.okvis
	move.l	d0,(a1)+
	move.l	#TAG_Done,(A1)+
	lea	mytags(a5),a1
	move.l	myobject(A5),a0
	jsr	_LVOsetattrsA(A6)

	move.l	myobject(A5),a0
	move.l	winhandle(A5),a1
	moveq	#-1,d0
	suba.l	a2,a2
	jsr	_LVOrefreshglist(A6)

	bsr	domessages
	bra	.ma
.nomess
	cmp.w	#USclass_zipwin,d3
	bne.s	.nozip
.setzip
	move.l	winhandle(a5),d0
	beq	.ma
	move.l	d0,a0
	move.w	wd_height(a0),d0
	cmp.w	myhoehe1(a5),d0
	beq.w	.ma		;Window schon klein
.zip
	move.w	d0,-(sp)

	move.l	intsave(a5),a6
	jsr	_LVOzipwindow(a6)

	move.w	(sp)+,d4

	move.l	winhandle(a5),a2
.Zipwait:
	moveq	#1,d1
	move.l	_Dos(a5),a6
	jsr	_LVODelay(a6)

	cmp.w	wd_height(a2),d4
	beq.s	.zipwait

	bra	.ma
.nozip
	cmp.w	#USclass_unzipwin,d3
	bne.s	.nounzip
.clearzip
	move.l	winhandle(a5),d0
	beq	.ma
	move.l	d0,a0
	move.w	wd_height(a0),d0
	cmp.w	myhoehe1(a5),d0
	beq.s	.zip
	bra	.ma
.nounzip
	cmp.w	#USclass_exit,d3
	beq	.exit

	cmp.w	#USclass_NewConfig,d3	;is there a new config
	bne.w	.nonewcon		;no

	lea	begin(pc),a0		;start of program (EUS_-Structure)
	move.w	eus_flags(a0),d0	;get Flags
	btst	#eusf_openwin,d0	;Window open ?
	beq.s	.nowino
	bsr	openwin			;open it
	bra.s	.weio
.nowino
	bsr	closewin		;else close it
.weio
	lea	begin(pc),a0		;start of program (EUS_-Structure)
	move.l	winhandle(a5),d0	;windowaddress
	beq.s	.nothingtomove		;no Window , no movement

	move.l	d0,a1			;Window
	move.l	wd_wscreen(a1),a2	;Parent Screen

	move.w	eus_winx(a0),d0		;new X-position
	move.w	d0,d1			;save
	blt.s	.oldx			;less than 0 -> stop

	add.w	winwidth(A5),d1		;new position + Window-width
	cmp.w	sc_width(a2),d1		;bigger than Screenwidth ?
	bhi.s	.oldx			;then old X-position (Delta = 0)

	sub.w	wd_leftedge(a1),d0	;new - old X-position = Delta X
	bra.s	.gety
.oldx
	moveq	#0,d0			;Delta X = 0
.gety
	move.w	eus_winy(a0),d1		;new Y-position

	move.w	d1,d2			;save
	blt.s	.oldy			;less than 0 -> stop and take old

	add.w	win_height(a5),d2	;new position + window-height
	cmp.w	sc_height(a2),d2	;bigger than Screenheight ?
	bhi.s	.oldy

	sub.w	wd_topedge(a1),d1	;new - old Y-position = Delta Y
	bra.s	.setdeltas
.oldy	moveq	#0,d1

.setdeltas
	move.l	intsave(a5),a6		;Intuition
	move.l	a1,a0			;Winhandle
	jsr	_LVOmovewindow(A6)
.nothingtomove
	lea	begin(pc),a0
	move.w	eus_flags(a0),d0
	btst	#eusf_zipwin,d0		;Zipwindow ?
	bne	.setzip			;yes
	bra	.clearzip		;no
.nonewcon
	bra	.ma
.noeagle
	bra	.ma
.msg
	move.l	d0,a1
	move.l	im_class(a1),d7
	move.w	im_code(a1),d5 		<-
	move.l	im_Iaddress(a1),d6 	<-
	jsr	_LVOreplymsg(a6)

	cmp.l	#IDCMP_Changewindow,d7
	bne.s	.standard
.changewin
	move.l	winhandle(A5),a0
	moveq	#0,d0
	move.b	wd_borderbottom(a0),d0
	ext.w	d0
	neg.w	d0
	add.w	wd_height(a0),d0
	sub.w	myhoehe1(a5),d0
	sub.w	#5+5,d0
	divu	fonth(a5),d0
	move.w	d0,maxvisible(A5)

	move.l	intsave(A5),a6
	lea	mytags(a5),a1
	move.l	#PGA_Visible,(A1)+
	move.l	d0,(a1)+
	move.l	#TAG_Done,(A1)+
	lea	mytags(a5),a1
	move.l	myobject(A5),a0
	jsr	_LVOsetattrsA(A6)

	move.l	myobject(A5),a0
	move.l	winhandle(A5),a1
	moveq	#-1,d0
	suba.l	a2,a2
	jsr	_LVOrefreshglist(A6)
	bra	.ma
.standard
	cmp.l	#refreshwindow,d7
	bne.s	.testgads
	bsr	refresh
	bra	.ma
.testgads
	cmp.l	#gadgetdown,d7
	bne.s	.nogad
	cmp.l	myobject(A5),d6
	bne.w	.nogad

	bsr	domessages

.nogad
	cmp.l	#CloseWindow,d7
	bne	.noclo
.Closewinny
	if	Test=0

	bsr	closewin
	move.l	4,a6
	lea	Portname(pc),a1
	jsr	_LVOfindport(a6)
	tst.l	d0
	beq.s	.endme		;kein Eagleplayerport->Ende des Programmes
	move.l	d0,a0			;Portadresse
	move.l	msgport(a5),d3
	move.l	mytask(a5),d4
	moveq	#-1,d5
	move.w	#USclass_DeActivate,d6
	bsr	sendmess
	bra	.ma
	else
	bra	.endme
	endc
.noclo
	cmp.l	#menupick,d7
	bne.s	.nomenu
	move.w	d5,d0
	cmp.w	#menunull,d0
	beq	.ma
	and.w	#$7e0,d0
	beq.s	.flush

	cmp.w	#96,d0		;4. Item ? (Hide)
	beq	.Closewinny
	cmp.w	#128,d0		;5. Item ? (Quit)
	beq	.endme

	lea	Aboutmessage(pc),a0
	bsr	Merror
	bra	.ma
.flush
	bsr	deleteall
	bsr	refresh
	bra	.setpga
.nomenu
	ifne	test

	cmp.l	#Vanillakey,d7
	bne	.ma
	cmp.b	#`1`,d5
	bne.w	.nostart

.nostart
	endc

	bra	.ma
.endme
	moveq	#0,d7
	RTS
.exit	moveq	#-1,d7
	move.l	#0,eus_msgflags1
	rts
******************************************************************************
*          Messages ausgeben und auf releasen des Gadgets warten             *
******************************************************************************
domessages:
	move.w	#-1,merkpos(A5)
.doagain
	move.l	intsave(A5),a6
	lea	currpos(a5),a1
	move.l	#PGA_TOP,d0
	move.l	myobject(a5),a0
	jsr	_LVOgetattr(A6)
	tst.l	d0
	beq.w	.oops

	move.l	messbase(a5),d1
	beq	.oops				;keine Messages bisher
	move.l	d1,a3				;1. Mess
	move.l	currpos(A5),d0			;1. Mess auf Screen
	cmp.w	merkpos(A5),d0
	beq	.againtest
	tst.w	d0
	beq.s	.first
.next
	move.l	(a3),a3
	subq.l	#1,d0
	bne.s	.next
.first
	move.w	myhoehe1(a5),d7
	addq.w	#3,d7			;YPos

	move.w	fontbase(A5),d4
	add.w	d7,d4
	addq.w	#2,d4
	
	move.w	maxvisible(a5),d6
	beq	.oops
	cmp.w	messagenum+2(a5),d6
	ble.s	.oknum
	move.w	messagenum+2(A5),d6
.oknum
	subq.w	#1,d6

	move.l	grafsave(a5),a6
	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a4

	move.b	wd_borderleft(a1),d0
	ext.w	d0			;x1
	addq.w	#8,d0
	move.w	d0,startx(A5)

	move.b	wd_borderright(a1),d5
	ext.w	d5
	neg.w	d5
	add.w	wd_width(A1),d5
	sub.w	#9,d5
	move.w	d5,a2

	sub.w	d0,d5
.loop
	move.l	a4,a1
	move.w	d4,d1		;y
	move.w	startx(A5),d0	;x
	jsr	_LVOMove(A6)

	moveq	#1,d0
	move.l	a4,a1
	jsr	_LVOsetapen(A6)

	move.w	6(a3),d0
	move.w	d0,d3
.charloop
	move.l	a4,a1
	lea	8(a3),a0
	move.w	d3,d0
	jsr	_LVOtextlength(A6)

	cmp.w	d5,d0
	blt.s	.ok
	subq.w	#1,d3
	bra.s	.charloop
.ok
	move.w	d0,d2
	move.w	d3,d0

	lea	8(a3),a0
	move.l	a4,a1
	jsr	_LVOtext(A6)

	moveq	#0,d0
	move.l	a4,a1
	jsr	_LVOsetapen(A6)

	move.l	a4,a1
	move.w	startx(A5),d0	;x1
	add	d2,d0
	move.w	a2,d2		;x2
	move.w	d7,d1		;y1
	addq.w	#2,d1
	move.w	d4,d3		;y2
	addq.w	#2,d3
	jsr	_LVOrectfill(A6)


	add.w	fonth(a5),d7
	add.w	fonth(a5),d4

	move.l	(A3),a3
	dbf	d6,.loop
.againtest
	move.w	currpos+2(A5),merkpos(a5)
	move.l	myobject(a5),a0
	move.w	gg_flags(a0),d0
	and.w	#gflg_selected,d0
	beq.s	.oops

	move.l	_dos(A5),a6
	moveq	#1,d1
	jsr	_LVOdelay(A6)
	bra.w	.doagain
.oops
	rts
******************************************************************************
*                         alle Messages lschen                              *
******************************************************************************
deleteall
	ifeq	test
	move.l	4,a6
	move.l	messbase(A5),d6
.oldnum
	tst.l	d6
	beq.s	.nomore
	move.l	d6,a1			;1. Mess
	move.l	(A1),d6			;nchste Mess
	moveq	#0,d0
	move.w	4(a1),d0		;Memsize
	jsr	_LVOfreemem(A6)
	bra.s	.oldnum
.nomore
	clr.l	messbase(A5)
	clr.l	messagenum(A5)
	endc
	rts
******************************************************************************
*                       Ausgabe von Error-Messages                           *
*                 Input: a0 -> Zeiger auf Ausgabestring                      *
******************************************************************************
MERROR:
	movem.l	d0-a6,-(sp)
	lea	my_easystruct(a5),a1

	move.l	a0,es_textformat(a1)

	lea	my_easygadget(pc),a0
	move.l	a0,es_gadgetformat(a1)

	lea	my_easytitle(pc),a0
	move.l	a0,es_Title(a1)
	move.l	winhandle(a5),a0	;*Window
	suba.l	a2,a2			;*IDCMP_ptr
	suba.l	a3,a3			;*Arguments
	move.l	Intsave(a5),a6
	jsr	_LVOeasyrequestargs(a6)
	movem.l	(sp)+,d0-a6	
	rts
;*****************************************************************************
;*                        Daten und Initialisierungen                        *
;*****************************************************************************

int:	dc.b	`intuition.library`,0
gad:	dc.b	`gadtools.library`,0
graf:	dc.b	`graphics.library`,0
dos:	dc.b	`dos.library`,0
portname:	dc.b	`EAGLEPLAYERPORT`,0
Project0STitle: dc.b	'Messagewindow (Eagleplayer),  DEFECT Softworks',0

my_easygadget:	dc.b	`   OK   `,0
my_easygadget2:	dc.b	` Retry | Cancel `,0
MyAnalyzername:	dc.b	`EMessageWindow.0`,0
MyWinName:
my_easytitle:
MyUsername:	dc.b	`MessageWindow `,0

Aboutmessage:	dc.b	`    EaglePlayer Messwindow V`
		ver
		dc.b	` `,$0a
		dc.b	` 1993-1995 Henryk "BUGGS" Richter`,$0a
		dc.b	`This program belongs to the Eagleplayer`,10
		dc.b	`  package and may not be spread alone.`,0
NoportMessage:	dc.b	`Cannot find EaglePlayer Port`,0

	ifne	test
Confile:	dc.b	`CON:10/10/250/40/MessageWindow`,0
Conout:	dc.b	`Needs Amiga OS2.04 or higher to run`,0
Conlen = *-Conout
	endc

Mylabel0:	dc.b	`Flush`,0
Mylabel1:	dc.b	`Project`,0
Mylabel2:	dc.b	`About`,0
MyLabel3:	dc.b	`Hide`,0
MyLabel4:	dc.b	`Quit`,0
Mylabel21:	dc.b	`A`,0
MyLabel31:	dc.b	`H`,0
MyLabel41:	dc.b	`Q`,0

propclass:	dc.b	`propgclass`,0

mybuggsname	dc.b	`Buggs of DEFECT`,0
myinfo 	dc.b	`This engine displays the information- and errormessages of Eagleplayer `
	dc.b	`in a separate window.`,0
	even

	ifne	test
testmess:
	dc.l	test2
	dc.w	25,25
	dc.b	`Hallo, dies ist ein Test !`
test2	dc.l	test3
	dc.w	10,10
	dc.b	`hallo,test`
test3	dc.l	test4
	dc.w	10,10
	dc.b	`dfkdfssjfj`
test4	dc.l	test5
	dc.w	10,10
	dc.b	`dfkdfssjf1`
test5	dc.l	test6
	dc.w	10,10
	dc.b	`dfkdfssjf2`
test6	dc.l	test7
	dc.w	25,25
	dc.b	`dfkdfssjf3123456789454545407`
test7	dc.l	test8
	dc.w	10,10
	dc.b	`dfkdfssjf4`
test8	dc.l	test9
	dc.w	10,10
	dc.b	`dfkdfssjf5`
test9	dc.l	test10
	dc.w	10,10
	dc.b	`dfkdfssjf6`
test10	dc.l	test11
	dc.w	10,10
	dc.b	`dfkdfssjf7`
test11	dc.l	test12
	dc.w	10,10
	dc.b	`dfkdfssjf8`
test12	dc.l	0
	dc.w	10,10
	dc.b	`dfkdfssjf9`
	endc
;*********** Leertabellen (spter im BSS-Hunk) ***********************
		section	1,BSS
datas:
intsave:	rs.l	1
gadsave:	rs.l	1
grafsave:	rs.l	1
_dos		rs.l	1
LastText	rs.l	1
WinHandle:	rs.l	1
Port:		rs.l	1
MSGPort:	rs.l	1
Menuadr:	rs.l	1
win_height	rs.w	1
Mytask		rs.l	1
mypubscreen:	rs.l	1	;aktueller Publicscreen
fonth:		rs.l	1	;Fonthhe
fontbase:	rs.w	1	;Font Baseline
StartX		rs.w	1
fontatt:	rs.l	1	;Fontattr Strukturadresse (entweder die des
				;Screens oder die eigene,wenn Screenfont zu
				;gro)
vi:		rs.l	1	;Visualinfo

mytags:		rs.l	20*2
myzoom:		rs.w	3
myhoehe2:	rs.w	1
myhoehe1:	rs.w	1
winwidth:	rs.w	1
myfontatt:	rs.l	1
		rs.w	2

MY_Easystruct:	rs.l	1	;EASY-Request
		rs.l	1
		rs.l	1
		rs.l	1
		rs.l	1
		rs.l	1

myobject	rs.l	1
merkpos		rs.l	1
currpos		rs.l	1
messagenum	rs.l	1	;Gesamtanzahl
messbase	rs.l	1	;verkettete Liste der Messages
visible		rs.l	1
maxvisible	rs.w	1
myfont		rs.l	1
Mymenus:	rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.b	gnm_sizeof
		rs.w	1
SaveString	rs.l	1
SaveCommand	rs.l	1
SaveResult	rs.l	1
	ifne	debug
saveusernr	rs.w	1
	endc
DatasLen:	rs.w	0
		ds.b	DatasLen
	end
