*****************************************************************************
**                                                                         **
** Engine: Levelgraph                                                      **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 



;**********************************************************************
;**               Eagleplayer Levelgraph V2.1                        **
;**               1993 Henryk "BUGGS" Richter                       **
;**           this graphics by M.U.D.U / Defect                      **
;**       graphics for General Version by Ramon / Defect             **
;**               written using ASM-ONE V1.02                        **
;**    NOT FOR PUBLIC USE,COPYRIGHTED CODE,ALL RIGHTS RESERVED       **
;**********************************************************************
	;
	;Levelgraph2 entfernt sich selbst, wenn von unregistriertem EP
	;aus gestartet !
	;
	incdir	include:
	include	exec/exec_lib.i
	include	exec/libraries.i
	include	intuition/intuition.i
	include	intuition/intuition_LIB.i
	include	graphics/graphics_lib.i
	include	misc/Eagleplayerengine.i
	include	dos/dos_lib.i
	include	misc/Buggsmacros.i
	;
ver		macro
		dc.b	"2.02"
		endm
StructVer	macro
		dc.w	2,02
		endm
date		macro
		dc.b	"05-Apr-97"
		endm
StructDate	macro
		dc.b	05,04
		dc.w	1997
		endm


RealMeter = 1		;1=Real Mode, 0=old Mode
	;
Test = 0	;auf 0 lassen zur Nutzung mit dem Eagleplayer !!!!!
		;(zu Testzwecken meldet sich sonst der Analyzer selbst ab !)
debug = 0
;===========================================================================
	section	0,code
;===========================================================================
an_num = 8			;Anzahl der Balken (bloss nicht ndern)
an_zeilen = 32			;Keine nderung zulssig,siehe oben,siehe auch
				;GURU-LISTE
win_breite = (an_num*2+5)*8
;===========================================================================
BEGIN
	bra.w	fangan

	EUSN_Identifier
	dc.l	0		;eus_next

	ifne	debug
	dc.w	-2
	else
	dc.w	0		;eus_Usernr
	endc
MyEPBase
	dc.l	0		;eus_EPBase , DTBASE,use it,but not change it
	dc.l	0		;eus_Freetable
	dc.l	0		;eus_Taskadr
	dc.l	0		;eus_unused1
	dc.l	0		;eus_unused2
	dc.l	0		;eus_unused3
	dc.l	Tagliste	;eus_unused4
	dc.w	0		;eus_ticks
	dc.w	0		;eus_tickcounter
	dc.l	EUIB_OnlyPlay!EUIB_OnlyActive ;eus_tickflags
	dc.l	USMB_Zipwin!USMB_ChangeConfig!USMB_ChangeInterrupt;eus_msgflags

	dc.l	MyAnalyzername	;eus_PName
	dc.l	mybuggsname
	dc.l	myinfo
	dc.w	37		;eus_Kickstart
	dc.l	EAGLEVERSION	;eus_EPVersion
	structver		;eus_version,revision
	dc.l	MyUsername	;eus_username
	dc.w	304		;eus_winx
	dc.w	205		;eus_winy
	dc.w	EUSB_openwin	;window opened
	dc.l	0		;EUS_Special
	dc.l	0		;EUS_Special2
	dc.l	0		;EUS_Special3
	structdate		;EUS_Creatordate
	dc.b	-5		;EUS_Priority
	dc.b	0
	dc.w	0
	dc.l	0		;EUS_Reserved3
	dc.l	0		;EUS_Reserved4
	dc.l	0		;EUS_Reserved5
	dc.l	0		;EUS_Reserved6

		ifne	(*-begin)-EUS_SizeOF
		Aber Hallo
		endc

		dc.b	`$VER: Eagleplayer Levelgraph V`
		ver
		dc.b	` (`
		date
		dc.b	`)`,0
		even

Tagliste:	dc.l	EUT_SpecialinfoLNr,LNrE_SpecialInfo_Levelgraph
		*dc.l	EUT_AttnFlags,1<<6!1<<3
		dc.l	0

fangan
	move.l	4.w,a6			;Execbase laden

	lea	datas,a5		;allumfassendes Basisregister
	move.l	a5,a0
	move.w	#dataslen-1,d0		;BSS-Sektion vollstndig lschen
.clr	move.b	#0,(a0)+
	dbf	d0,.clr

	lea	pegelchipdata,a1	;Quelladresse der Bilddaten
	move.l	a1,pegeldata(a5)

	ifeq	debug
	lea	begin(pc),a0
	move.l	EUS_EPBase(a0),d0
	beq	Nosignal
	move.l	d0,a0
	lea	EPG_someprefs(a0),a0
	move.l	a0,flagsadr(A5)
	endc

	moveq	#-1,d0			;irgendein Signal
	jsr	_LVOallocsignal(a6)	;allokieren
	tst.l	d0
	blt	NoSignal
	move.l	d0,mysignal(a5)		;merken

	suba.l	A1,A1
	JSR	_LVOfindtask(A6)	;Task finden
	move.l	d0,mytask(a5)

					;Message Port initialisieren
	moveq	#-1,d0
	jsr	_LVOallocsignal(a6)	;MSG Signal zuweisen lassen
	tst.l	d0
	blt	nosignal2		;Fehler

	lea	MsgPort(a5),a4		;MSG Port Struktur initialisieren

	move.b	#nt_msgport,ln_type(a4)
	move.b	#0,ln_pri(a4)
	move.b	#pa_signal,mp_flags(a4)
	move.b	d0,mp_sigbit(a4)

	move.l	mytask(a5),mp_sigtask(a4);mp_SigTask

	lea	mp_msglist(a4),a1
	Newlist	a1			;macro in Lists.i

	lea	int(pc),a1
	moveq	#33,d0
	jsr	_LVOopenlibrary(a6)	;INTUITION V1.2
	tst.l	d0
	beq	NOINT
	move.l	d0,intsave(a5)

	lea	graf(pc),a1
	moveq	#33,d0
	jsr	_LVOopenlibrary(a6)	;GRAPHICS V1.2
	tst.l	d0
	beq	NOGRAF
	move.l	d0,grafsave(a5)

	moveq	#0,d7			;Rckgabewert

	bsr	sendfirstmessage	;Message an Eagleplayer senden,da
					;der Analyzer gern mal die Struktur-
					;Adresse usw. haben mchte
	blt	endme	;Fehler aufgetreten (Register D7 < 0),Programm beenden

	bsr	HandleActions		;Auf Usereingaben und Eagleplayer-
					;signale reagieren (Hauptprogramm
;========= Programmende =====================================================
endme
	move.l	d7,-(sp)
	bsr	closewin	;Fenster zu !
	move.l	(sp)+,d7		;Error oder Exit-Message vom Player ?

	blt.s	Ende	;kein Fehler,sondern Aufruf zum frhlichen ENDE
			;vom Eagleplayer erhalten

	bsr	Sendlastmessage	;einige letzte Worte,falls eigenmchtige Ver-
				;abschiedung (darf aber nicht auftreten
Ende
	move.l	mypubscreen(a5),d0	;Public Screen loslassen,falls nicht
	beq.s	.ok			;schon getan
	move.l	d0,a1
	suba.l	a0,a0
	move.l	intsave(A5),a6
	jsr	_LVOunlockpubscreen(a6)
.ok
	move.l	grafsave(a5),a1
	move.l	4.w,a6
	jsr	_LVOcloselibrary(a6)
NoGraf
	move.l	intsave(a5),a1
	move.l	4.w,a6
	jsr	_LVOcloselibrary(a6)
noint
	move.l	4.w,a6			;eigenen Port wieder entfernen

	lea	msgport(a5),a2
	move.b	mp_sigbit(a2),d0
	ext.w	d0
	ext.l	d0
	jsr	_LVOfreesignal(a6)
NoSignal2
	move.l	mysignal(a5),d0
	move.l	4.w,a6
	jsr	_LVOfreesignal(a6)
NoSignal
	moveq	#0,d0			;Returncode
	rts
************************************************************************
*                   Fenster ffnen                                     *
************************************************************************
Openwin:
	push	all

	tst.l	winhandle(a5)	;haben wir denn schon ein Fensterle ??
	bne.w	.Error

	move.l	intsave(a5),a6
	cmp.w	#37,lib_version(A6)
	bhs.s	.openwindow20
					;Fenster unter 1.3
	lea	mywindow(pc),a0

	moveq	#11,d1			;Font = 8 Pixel  +  3 Pixel Rand
	move.w	d1,myhoehe1(a5)

	lea	GadPic,a2
	move.w	d1,gg_topedge(a2)	;Gadget (Grafik) der Titelzeilen-
					;hhe anpassen (wegen Screenfont)
	addq.w	#3+3,gg_topedge(a2)	;1 tiefer setzen
	
	move.l	(a2),a2			;nchstes Gadget
	move.w	d1,gg_topedge(a2)	;Gadget (Grafik) der Titelzeilen-
					;hhe anpassen (wegen Screenfont)
	addq.w	#3+3,gg_topedge(a2)	;1 tiefer setzen

	add.w	#AN_zeilen+8,d1		;6 Y-Stufen des Analyzers + Rand
	move.w	d1,win_hoehe(A5)

	lea	begin(pc),a1
	move.w	eus_winx(a1),nw_leftedge(a0)
	move.w	eus_winy(a1),nw_topedge(a0)
	move.w	d1,nw_height(A0)
	jsr	_LVOopenwindow(a6)
	move.l	d0,winhandle(a5)
	tst.l	d0
	bne.w	.winopened

	lea	mywindow(pc),a0
	clr.w	nw_topedge(A0)
	clr.w	nw_leftedge(A0)

	jsr	_LVOopenwindow(a6)
	move.l	d0,winhandle(a5)
	tst.l	d0
	bne.w	.winopened
	bra	.error
.openwindow20		;Fenster unter 2.0 ffnen
			;Routine blieb implementiert,da unter 2.0 einige
			;neue Funktionen (Zipwindow) existieren und zudem ein
			;eigener Font gesetzt werden kann. Wenn dieser eine
			;andere Hhe hat,kann`s Probleme geben,deshalb die
			;2.0 kompatible Routine

	lea	begin(pc),a0
	move.l	eus_epbase(a0),d0
	beq.s	.noep
	move.l	d0,a0
	move.l	EPG_Pubscreen(a0),d0
.noep
	move.l	d0,a0

	jsr	_LVOlockpubscreen(A6)	;aktuellen Publicscreen rauskriegen
	tst.l	d0
	bne.s	.pub

	suba.l	a0,a0
	jsr	_LVOlockpubscreen(A6)	;aktuellen Publicscreen rauskriegen
	tst.l	d0
	beq	.Error			;sollte nicht auftreten (warum auch ?)
.pub
	move.l	d0,mypubscreen(a5)	;fr UnLockpubscreen() merken
	move.l	d0,a1
	move.l	sc_font(a1),a0

	bsr	getwinheight		;in D1 Windowhhe abholen 
					;(welch Service)

					;WINDOW INIT
	lea	mytags(a5),a1		;Zeiger auf Tagliste

	move.l	#WA_Pubscreen,(a1)+
	move.l	mypubscreen(A5),(a1)+

	move.l	#wa_Pubscreenfallback,(A1)+
	move.l	#1,(a1)+

	lea	begin(pc),a0		;Zeiger auf Struktur am Programmanfang
	moveq	#0,d0
	move.l	#wa_top,(a1)+		;Y-Position des Fensters

	move.w	eus_winy(a0),d0		;holen und eintragen
	move.l	d0,(a1)+

	move.l	#wa_left,(a1)+		;X-Position
	move.w	eus_winx(a0),d0
	move.l	d0,(a1)+

	move.l	#wa_width,(a1)+		;Breite
	move.l	#win_breite,(a1)+
	move.l	#wa_height,(a1)+	;Hhe
	move.l	d1,(a1)+
	move.w	d1,win_hoehe(A5)

	move.l	#wa_flags,(a1)+
	move.l	#Windowdrag!Windowdepth!Windowclose,(a1)+ ;das soll er knnen

	move.l	#WA_TITLE,(a1)+		;Windowname
	lea	mywinname(pc),a0
	move.l	a0,(a1)+
	move.l	#wa_zoom,(a1)+
	lea	myzoom(a5),a2
	move.w	eus_winy(a0),(a2)		;X-Position im ZIP-Mode
	move.w	eus_winx(a0),2(a2)	;Y-Position im ZIP-Mode

	move.w	#168,4(a2)		;Breite des Zip-Windows im SMALL-MODE
	move.w	myhoehe1(a5),myhoehe2(a5)
	move.l	a2,(a1)+
	move.l	#wa_idcmp,(a1)+
	move.l	#closewindow!menupick!refreshwindow,(a1)+ ;das wolln wir wissen
	move.l	#wa_autoadjust,(a1)+	;Gre notfalls einschrnken
	move.l	#1,(a1)+


	move.l	#WA_Screentitle,(a1)+
	move.l	#Project0STitle,(a1)+

	move.l	#TAG_DONE,(a1)+		;das war alles

	suba.l	a0,a0
	lea	mytags(a5),a1
	move.l	intsave(a5),a6
	jsr	_LVOopenwindowtaglist(a6)	;alloah Window !
	move.l	d0,Winhandle(a5)
	bne.s	.winopened

	lea	mytags(a5),a1		;Fehler,nochmal auf Position 0/0
	move.l	#wa_top,(a1)+		;zu ffnen versuchen
	move.l	#0,(a1)+
	move.l	#wa_left,(a1)+
	move.l	#0,(a1)+

	suba.l	a0,a0
	lea	mytags(a5),a1
	move.l	intsave(a5),a6
	jsr	_LVOopenwindowtaglist(a6)	;wirst DU wohl aufgehen !
	move.l	d0,Winhandle(a5)
	beq	.Error
.winopened
	move.l	d0,a0
	move.l	wd_userport(a0),a0	;User Port holen
	move.l	a0,port(a5)		;und sichern

	lea	my_bitmap(a5),a3
	bsr	makebitmap		;EXTRA Bitmap init

	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	lea	GadPic2,a1
	clr.l	(a1)
	lea	gadpic,a1

	moveq	#0,d0
	moveq	#-1,d1
	moveq	#0,d2
	jsr	_LVOaddglist(A6)

	bsr	addmenus		;Men darstellen
	bsr	refresh			;Rahmen zeichnen
.error
	move.l	intsave(a5),a6
	suba.l	a0,a0
	move.l	mypubscreen(a5),d0
	beq.s	.nopub
	move.l	d0,a1
	move.l	#0,mypubscreen(a5)
	jsr	_LVOunlockpubscreen(a6)	;PUBscreen freigeben
.nopub
	pop	all
	rts
*******************************************************************
*                   Window schlieen                              *
*******************************************************************
Closewin:
	push	all

	tst.l	winhandle(a5)	;Window gar nicht auf ?
	beq.s	.nowin	;nein,raus

	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	lea	gadpic,a1
	moveq	#-1,d0
	jsr	_LVOremoveglist(A6)

	bsr	freemenus	;Mens freigeben
	
	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	move.w	myhoehe1(a5),d0		;Window im ZIP-Modus ?
	cmp.w	wd_height(a0),d0
	beq.s	.nosetxy		;ja; X,Y-Position nicht merken
	lea	begin(pc),a1
	move.w	wd_topedge(a0),eus_winy(a1)
	move.w	wd_leftedge(a0),eus_winx(a1)
.nosetxy
	clr.l	Winhandle(a5)
	clr.l	port(a5)
	jsr	_LVOclosewindow(a6) ;Window schlieen
.nowin
	pop	all
	rts
********************************************************************
*    Init Message Struktur,Willkommensnachricht an Eagleplayer     *
********************************************************************
Sendfirstmessage
	move.l	4.w,a6
	lea	Portname(pc),a1
	jsr	_LVOfindport(a6)	;Eagleplayers Port finden
	tst.l	d0
	bne.s	.ok
					;Wenn dieser nicht gefunden werden
					;konnte,
	bsr	 openwin		;Fenster ffnen

					;und Requester erstellen,der mitteilt,
					;da kein Eagleplayer weit und breit
					;zu finden ist

	move.l	winhandle(a5),d0	;*Window
	beq.w	.error		;kann mein Window nicht ffnen,gleich rausgehen
	move.l	d0,a0

	lea	Noportitext(pc),a1	;*Bodytext (Itext-Struktur
	lea	retryitext(pc),a2	;*Positive Text
	lea	cancelitext(pc),a3	;*Negative Text
	moveq	#0,d0			;Idcmp True
	moveq	#0,d1			;Idcmp False
	move.w	#260,d2			;Breite
	move.w	#46,d3			;Hhe

	move.l	Intsave(a5),a6
	jsr	_LVOautorequest(a6)	;Requester unter 1.3
	tst.l	d0
	beq.s	.error			;Cancel->Ende des Programms

	bra	SendFirstmessage	;nochmal versuchen
.ok
	move.l	d0,a0			;Portadresse

	
	lea.l	msgport(a5),a1
	move.l	a1,d3			;Msgportadresse
	move.l	mytask(a5),d4		;Taskadresse
	move.l	mysignal(a5),d5		;Signalnummer
	move.w	#USclass_Newuserprg,d6	;Meldung,da ein neues Userprogramm an-
					;kommt

	ifne	debug

	lea	Mymessage(a5),a1	;Messageadresse
	moveq	#um_sizeof>>1-1,d0
.clr
	clr.w	(a1)+
	dbf	d0,.clr

	lea	Mymessage(a5),a1	;Messageadresse

	move.w	#UM_sizeof-20,mn_length(a1)
	move.b	#nt_message,ln_type(a1) ;Message-Typ
	lea	begin(pc),a2
	move.l	a2,um_result(a1)
	move.w	#-2,UM_UserNr(a1)
	move.l	#USM_Userprg,UM_Type(a1)

	move.l	d3,mn_replyport(a1)	;Portadresse,an die
						;zurckgesendet wird
	move.l	d3,UM_Userport(a1)
	move.l	d4,UM_TaskAdr(a1)
	move.l	d5,UM_Signal(a1)
	move.w	d6,UM_class(a1)

	move.b	#1,messagesent(a5)		;merken,da Nachricht gesendet

	move.l	4.w,a6
	jsr	_LVOputmsg(a6)

	else
	bsr	sendmess
	endc

	moveq	#0,d7			;alles klar
	rts				;Rcksprung
.error
	moveq	#-1,d7			;Fatal Error
	rts				;Ende
******************************************************************************
* Abschiedsgru an Eagleplayer,der dann wei,da der Analyzer geendet hat    *
******************************************************************************
;NUR ZU TESTZWECKEN,KEIN USERPROGRAMM SOLLTE SICH EIGENMCHTIG VERABSCHIEDEN,
;DA DER PLAYER SONST VERGEBLICH AUF DAS RCKSENDEN DER NACHRICHTEN WARTET
Sendlastmessage:
	move.l	4.w,a6
	lea	Portname(pc),a1	;EaglePlayer finden
	jsr	_LVOfindport(a6)
	tst.l	d0
	beq.s	.ok	;Eagleplayer hat sich schon verabschiedet

	move.l	d0,a0			;Portadresse
	lea.l	msgport(a5),a1
	move.l	a1,d3			;Messageport

	lea	Mymessage(a5),a1		;Messageadresse

	move.w	#UM_sizeof-20,mn_length(a1)	;Lnge
	clr.l	ln_succ(A1)
	clr.l	ln_pred(A1)
	move.b	#nt_message,ln_type(a1) 	;Typ: Message

	ifne	debug
	move.w	saveusernr(a5),UM_UserNr(a1)
	else
	lea	begin(pc),a2
	move.w	EUS_Usernr(A2),UM_UserNr(a1)
	endc

	move.l	#USM_Userprg,UM_Type(a1)	;Typ der Message

	move.l	d3,mn_replyport(a1)		;Portadresse,an die
						;zurckgesendet wird
	clr.l	UM_Userport(a1)		;Portadresse fr EaglePlayer
	clr.l	UM_TaskAdr(a1)		;Taskadresse
	clr.l	UM_Signal(a1)		;Signalnummer
	move.w	#Usclass_exit,UM_class(a1)	;Messageinhalt
				;z.B. USClass_Closewin,USclass_Newuserprg

	move.b	#1,messagesent(a5)		;merken,da Nachricht gesendet

	move.l	4.w,a6
	jsr	_LVOputmsg(a6)		;Nachricht losschicken
.wait					;auf Rckmeldung warten
	lea.l	MSGport(a5),a0
	jsr	_LVOwaitport(a6)
	lea.l	MSGport(a5),a0
	jsr	_LVOgetmsg(a6)
	tst.l	d0
	beq.s	.wait
	move.l	d0,a1
	cmp.l	#USM_Userprg,UM_Type(a1)
	beq.s	.meine
.nichtmeine
	jsr	_LVOreplymsg(a6)
	bra.s	.wait
.meine
.ok
	rts
*******************************************************************************
sendmess:
	lea	Mymessage(a5),a1		;Messageadresse
	moveq	#um_sizeof>>1-1,d0
.clr
	clr.w	(a1)+
	dbf	d0,.clr

	lea	Mymessage(a5),a1		;Messageadresse

	move.w	#UM_sizeof-20,mn_length(a1)	;Lnge
	move.b	#nt_message,ln_type(a1) 	;Typ: Message

	ifne	debug
	move.w	saveusernr(a5),UM_UserNr(a1)
	else
	lea	begin(pc),a2
	move.w	EUS_Usernr(A2),UM_UserNr(a1)
	endc

	move.l	#USM_Userprg,UM_Type(a1)	;Typ der Message

	move.l	d3,mn_replyport(a1)		;Portadresse,an die
						;zurckgesendet wird
	move.l	d3,UM_Userport(a1)		;Portadresse fr EaglePlayer
	move.l	d4,UM_TaskAdr(a1)		;Taskadresse
	move.l	d5,UM_Signal(a1)		;Signalnummer
	move.w	d6,UM_class(a1)			;Messageinhalt
				;z.B. USClass_Closewin,USclass_Newuserprg

	move.b	#1,messagesent(a5)		;merken,da Nachricht gesendet

	move.l	4.w,a6
	jsr	_LVOputmsg(a6)		;Nachricht losschicken
	rts
*********************** Men wechschmeisen ************************************
Freemenus
	move.l	intsave(a5),a6
	move.l	winhandle(a5),d0
	beq.s	.end
	move.l	d0,a0
	jsr	_LVOclearmenustrip(A6)	;Mens vom Window lsen
.end
	rts
*****************************************************************************
* Hhe des Hauptfensters berechnen unter Anpassung an den eingestellten Font*
*****************************************************************************
getwinheight:
	move.w	ta_ysize(a0),d0		;Hhe des Screenfonts
	move.w	d0,d1
	move.w	d0,fonth(a5)
	add.w	#3,d1			;Berechnen der Gre fr ZIPwindow()
	move.w	d1,myhoehe1(a5)		;und eintragen
	
	lea	GadPic,a0
	move.w	d1,gg_topedge(a0)	;Gadget (Grafik) der Titelzeilen-
					;hhe anpassen (wegen Screenfont)
	addq.w	#3+3,gg_topedge(a0)	;1 tiefer setzen

	move.l	(a0),a0
	move.w	d1,gg_topedge(a0)	;Gadget (Grafik) der Titelzeilen-
					;hhe anpassen (wegen Screenfont)
	addq.w	#3+3,gg_topedge(a0)	;1 tiefer setzen
	
	add.w	#AN_zeilen+8+4,d1	;32 Y-Stufen des Analyzers + Rand

	move.b	sc_wborbottom(A1),d0
	ext.w	d0
	add.w	d0,d1
	rts
	********************* Men anhngen *************************
Addmenus
	lea	ModeItem(pc),a1
	move.w	ItemFlags,d1
	lea	Pegelchipdata,a0
	move.b	begin+eus_special(pc),d0
	move.b	d0,modenr(A5)
	beq.s	.noset
	or.w	#Checked,d1
	move.l	Pegelchipdata2,a0
.noset
	move.l	a0,pegeldata(A5)
	move.l	a0,Data2
	move.w	d1,FlagsTO

	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	lea	projmenu(pc),a1
	jmp	_LVOsetmenustrip(a6)

	*************************************************************
makebitmap
	move.l	MyEPBase(pc),d0
	beq.s	.noep
	move.l	d0,a0
	move.b	EPG_Wordreserved7(a0),d0	;keyon ??
	bne.s	.noep

	lea	GadPic,a0
	lea	Pegelchipdata-Gadpic(a0),a0
	lea	pegelchipdata2-Pegelchipdata(a0),a1
	move.l	a0,(A1)				;nur ein Image

	move.w	4(A1),d0
	and.w	#~itemenabled,d0
	move.w	d0,4(a1)
.noep
	move.w	#an_num,(a3)		;bm_BytesPerRow
	move.w	#an_zeilen,bm_rows(a3)	;64 Zeilen

	move.b	#2,bm_depth(a3)		;2 Bitplanes

	moveq	#0,d7			;alles klar
ret	rts
	*************************************************************
	*            Rahmen zeichnen ,Windowrefresh                 *
	*************************************************************
Refresh
	move.l	winhandle(a5),d0
	beq	ret
	move.l	d0,a0

	move.w	myhoehe1(a5),d1		;Window im ZIP-Modus ?
	cmp.w	wd_height(a0),d1
	beq	ret			;ja,kein Refresh

	move.l	grafsave(a5),a6
	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	moveq	#1,d0
	jsr	_LVOsetapen(A6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	moveq	#0,d0
	jsr	_LVOsetbpen(A6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	moveq	#1,d0			;RP_Jam2
	jsr	_LVOsetdrmd(A6)

	move.b	rp_areaptsz(a1),d4
	move.l	rp_areaptrn(a1),d5

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1

	move.b	#1,rp_areaptsz(a1)
	lea	patt1(pc),a2
	move.l	a2,rp_areaptrn(a1)

	move.l	winhandle(A5),a0
	move.b	wd_borderleft(a0),d0
	ext.w	d0			;x1
	move.w	myhoehe1(A5),d1		;y1

	move.b	wd_borderright(a0),d2
	ext.w	d2			;x2
	neg.w	d2
	add.w	wd_width(a0),d2

	move.b	wd_borderbottom(a0),d3
	ext.w	d3			;y2
	neg.w	d3
	add.w	wd_height(a0),d3

	movem.l	d4-d5,-(sp)
	jsr	_LVOrectfill(a6)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1

	lea	patt2(pc),a0
	move.l	a0,rp_areaptrn(a1)

	move.l	winhandle(A5),a1
	move.l	wd_rport(a1),a1
	move.w	#3+8,d0
	move.w	myhoehe1(A5),d1		;y1
	addq.w	#4,d1
	jsr	_LVOmove(A6)

	movem.l	(Sp)+,d4-d5

	move.l	intsave(a5),a6
	move.l	winhandle(a5),a0
	jmp	_LVOrefreshwindowframe(a6)	;Fenster-Rahmen und Gadgets
						;in Ordnung bringen

	;***************************************************************
	;*                  Analyzing Routine                          *
	;***************************************************************

Analyze1
	ifne	RealMeter

	;*****************************************************************
	;*         neue Analyzing Routine, samplegesteuert               *
	;*****************************************************************

	;=============== Kanle auswerten =================================

	lea	AN_Struct(a5),a4;Analyzer Struktur
	moveq	#-1,d2				;Alle Kanle
	move.w	ups_flags(a4),d1
	and.w	#UPSB_Dmacon,d1			;Flag ob Kanle an/aus ?
	beq.s	.nodmacon
	move.w	UPS_Dmacon(a4),d2	;Ja,ranholen
.nodmacon

	lea	permerk(a5),a3	;SamplePeriod merken und Spielzeit der Samples
				;in 1/50 Sekunden

	;************************ 1. Stimme ********************************

Scope1:
	btst	#0,d2
	bne.s	.wei
	clr.l	UPS_voice1adr(a4)
	bra.s	.null
.wei
	move.l	UPS_Voice1Adr(a4),d1
	beq.s	.null
	move.l	d1,A1
	move.w	UPS_Voice1Per(a4),d1
	beq.s	.ok
	move.w	d1,(a3)
	move.w	#0,2(a3)
	bra.s	.copyto
.ok
	tst.w	(a3)		;berhaupt keine Sampleperiod bergeben ?
	bne.s	.copyto
.null
	lea	nulls(a5),a1
	bra.s	.no
.copyto
	moveq	#0,d4
	move.w	UPS_Voice1len(a4),d4
	add.l	d4,d4

;Anzahl der Bytes,die in 1/50 Sekunde vom DMA gelesen werden
;Bytes = 74074/Sampleperiod [ (1/(2.79*10-7)*50)/Sampleperiod ]
;Abwandlung : statt 74074: 65535

	move.w	2(a3),d0
	swap	d0		;=d0*65535
	divu	(a3),d0		;durch Sampleperiod
	cmp.w	d4,d0	;grer als Samplelnge ?
	blo.s	.cbm_ok
	tst.w	ups_voice1repeat(a4)
	beq.s	.cbm_loop
	lea	nulls(a5),a1
	subq.w	#1,2(a3)
	moveq	#0,d0
	bra.s	.cbm_ok
.cbm_loop
	tst.l	d4
	bne.s	.div
	move.w	#0,2(a3) ;Spielzeit des aktuellen Samples auf 0 (=Repeat)
	moveq	#0,d0
	bra.s	.cbm_ok
.div
	divu	d4,d0
	swap	d0
.cbm_ok
	add.w	d0,a1
	addq.w	#1,2(a3)
.no
	addq.l	#4,a3

	;************************ 4. Stimme ********************************

	lea	AN_Struct+UPS_Modulo*3(a5),a4 ;Analyzer Struktur 4.Stimme
Scope4:
	btst	#3,d2
	bne.s	.wei
	clr.l	UPS_voice1adr(a4)
	bra.s	.null
.wei
	move.l	UPS_Voice1Adr(a4),d1
	beq.s	.null
	move.l	d1,a2
	move.w	UPS_Voice1Per(a4),d1
	beq.s	.ok
	move.w	d1,(a3)
	move.w	#0,2(a3)
	bra.s	.copyto
.ok
	tst.w	(a3)		;berhaupt keine Sampleperiod bergeben ?
	bne.s	.copyto
.null
	lea	nulls(a5),a2
	bra.s	.no
.copyto
	moveq	#0,d4
	move.w	UPS_Voice1len(a4),d4
	add.l	d4,d4

	move.w	2(a3),d0
	swap	d0		;=d0*65535
	divu	(a3),d0		;durch Sampleperiod
	cmp.w	d4,d0	;grer als Samplelnge ?
	blo.s	.cbm_ok
	tst.w	ups_voice1repeat(a4)
	beq.s	.cbm_loop
	lea	nulls(a5),a2
	subq.w	#1,2(a3)
	moveq	#0,d0
	bra.s	.cbm_ok
.cbm_loop
	tst.l	d4
	bne.s	.div
	move.w	#0,2(a3) ;Spielzeit des aktuellen Samples auf 0 (=Repeat)
	moveq	#0,d0
	bra.s	.cbm_ok
.div
	divu	d4,d0
	swap	d0
.cbm_ok
	add.w	d0,a2

	addq.w	#1,2(a3)
.no
	bsr	copybitmap

	;-------------------- Werte bergeben ------------------
	move.w	d0,goto(a5)

	move.w	goto(A5),d1		;Wert,zu dem hingewandert wird
	beq.s	.godown			;keiner,also bernehmen
	cmp.w	d1,d0
	bgt.s	.sub			;Zielwert kleiner,also Sub
	add.w	#10,d0			;Zielwert grer,add
	cmp.w	d1,d0
	bge.s	.fertig
	bra.s	.ok
.sub	subq.w	#6,d0
	cmp.w	d1,d0
	bgt.s	.ok
.fertig
	clr.w	goto(A5)
.godown

	move.w	d0,d1

	ifeq	debug
	move.l	flagsadr(A5),a4
	else
	lea	begin(pc),a4
	move.l	EUS_EPBase(a4),a4
	lea	EPG_someprefs(a4),a4
	endc

	move.l	(a4),d6
	and.l	#EGPRB_MasterVolume,d6
	beq.s	.NoMaster

	lea	begin(pc),a0
	move.l	EUS_EPBase(a0),a0
	lea	EPG_Voice1vol(a0),a0

	mulu	(a0),d0
	lsr.w	#6,d0
	mulu	6(a0),d1
	lsr.w	#6,d1
.nomaster
	add.w	anmerk(a5),d0
	lsr.w	#1,d0
	add.w	anmerk+6(a5),d1
	lsr.w	#1,d1

	move.w	d0,anmerk(a5)		;1.Kanal
	move.w	d1,anmerk+6(a5)		;4.Kanal

	addq.l	#4,a3

	;************************ 2. Stimme ********************************
scope2
	lea	AN_Struct+UPS_Modulo(a5),a4 ;Analyzer Struktur 2.Stimme
	btst	#1,d2
	bne.s	.wei
	clr.l	UPS_voice1adr(a4)
	bra.s	.null
.wei
	move.l	UPS_Voice1Adr(a4),d1
	beq.s	.null
	move.l	d1,A1
	move.w	UPS_Voice1Per(a4),d1
	beq.s	.ok
	move.w	d1,(a3)
	move.w	#0,2(a3)
	bra.s	.copyto
.ok
	tst.w	(a3)		;berhaupt keine Sampleperiod bergeben ?
	bne.s	.copyto
.null
	lea	nulls(a5),a1
	bra.s	.no
.copyto
	moveq	#0,d4
	move.w	UPS_Voice1len(a4),d4
	add.l	d4,d4
	
	move.w	2(a3),d0
	swap	d0		;=d0*65535
	divu	(a3),d0		;durch Sampleperiod
	cmp.w	d4,d0	;grer als Samplelnge ?
	blo.s	.cbm_ok
	tst.w	ups_voice1repeat(a4)
	beq.s	.cbm_loop
	lea	nulls(a5),a1
	subq.w	#1,2(a3)
	moveq	#0,d0
	bra.s	.cbm_ok
.cbm_loop
	tst.l	d4
	bne.s	.div
	move.w	#0,2(a3) ;Spielzeit des aktuellen Samples auf 0 (=Repeat)
	moveq	#0,d0
	bra.s	.cbm_ok
.div
	divu	d4,d0
	swap	d0
.cbm_ok
	add.w	d0,a1
	addq.w	#1,2(a3)
.no
	addq.l	#4,a3

	;************************ 3. Stimme ********************************
scope3
	lea	AN_Struct+UPS_Modulo*2(a5),a4 ;Analyzer Struktur 3.Stimme

	btst	#2,d2
	bne.s	.wei
	clr.l	UPS_voice1adr(a4)
	bra.s	.null
.wei
	move.l	UPS_Voice1Adr(a4),d1
	beq.s	.null
	move.l	d1,a2
	move.w	UPS_Voice1Per(a4),d1
	beq.s	.ok
	move.w	d1,(a3)
	move.w	#0,2(a3)
	bra.s	.copyto
.ok
	tst.w	(a3)		;berhaupt keine Sampleperiod bergeben ?
	bne.s	.copyto
.null
	lea	nulls(a5),a2
	bra.s	.no
.copyto
	moveq	#0,d0
	move.w	UPS_Voice1len(a4),d4
	add.l	d4,d4

	move.w	2(a3),d0
	swap	d0		;=d0*65535
	divu	(a3),d0		;durch Sampleperiod
	cmp.w	d4,d0	;grer als Samplelnge ?
	blo.s	.cbm_ok
	tst.w	ups_voice1repeat(a4)
	beq.s	.cbm_loop
	lea	nulls(a5),a2
	subq.w	#1,2(a3)
	moveq	#0,d0
	bra.s	.cbm_ok
.cbm_loop
	tst.l	d4
	bne.s	.div
	move.w	#0,2(a3) ;Spielzeit des aktuellen Samples auf 0 (=Repeat)
	moveq	#0,d0
	bra.s	.cbm_ok
.div
	divu	d4,d0
	swap	d0
.cbm_ok
	add.w	d0,a2

	addq.w	#1,2(a3)
.no
	bsr	copybitmap

	move.w	d0,goto+2(a5)

	move.w	goto+2(A5),d1		;Wert,zu dem hingewandert wird
	beq.s	.godown			;keiner,also bernehmen
	cmp.w	d1,d0
	bgt.s	.sub			;Zielwert kleiner,also Sub
	add.w	#10,d0			;Zielwert grer,add
	cmp.w	d1,d0
	bge.s	.fertig
	bra.s	.ok
.sub	subq.w	#6,d0
	cmp.w	d1,d0
	bgt.s	.ok
.fertig
	clr.w	goto+2(A5)
.godown

	move.w	d0,d1

	ifeq	debug
	move.l	flagsadr(A5),a4
	else
	lea	begin(pc),a4
	move.l	EUS_EPBase(a4),a4
	lea	EPG_someprefs(a4),a4
	endc

	move.l	(a4),d6
	and.l	#EGPRB_MasterVolume,d6
	beq.s	.NoMaster

	lea	begin(pc),a3
	move.l	EUS_EPBase(a3),a3
	lea	EPG_Voice2vol(a3),a3

	mulu	(a3)+,d0
	lsr.w	#6,d0
	mulu	(a3),d1
	lsr.w	#6,d1
.nomaster

	add.w	anmerk+2(a5),d0
	lsr.w	#1,d0
	add.w	anmerk+4(a5),d1
	lsr.w	#1,d1

	move.w	d0,anmerk+2(a5)		;2.Kanal
	move.w	d1,anmerk+4(a5)		;3.Kanal

	bra.s	stelldar
;====== Berechnen des durchschnittlichen Lautstrkepegels des Samples ======
copybitmap
	moveq	#an_num*4-1,d7		;Schleifenzhler Balkenanzahl
	moveq	#0,d4
	moveq	#0,d6
	moveq	#0,d0
.mainloop
	move.b	(a1)+,d6
	ext.w	d6
	bgt.s	.ok
	neg.w	d6
.ok
	move.b	(a2)+,d4
	ext.w	d4
	bgt.s	.ok2
	neg.w	d4
.ok2
	add.w	d4,d6

	add.l	d6,d0

	dbf	d7,.mainloop

	lsr.l	#7,d0

	cmp.w	#63,d0
	bls.s	.rts
	moveq	#63,d0
.rts
	rts

	else

	;*************************************************************
	;*        Kanle auf altbekannte Weise auswerten             *
	;*************************************************************

	lea	anmerk(a5),a1			;Merkliste fr die Werte
	lea	goto(a5),a2

	lea	AN_Struct(a5),a0		;Analyzer Struktur


	lea	begin(pc),a3
	move.l	EUS_EPBase(a3),a3
	lea	EPG_Voice1vol(a3),a3

	moveq	#-1,d5				;alle Kanle an
	move.w	ups_flags(a0),d1		;Flags
	and.w	#UPSB_Dmacon,d1			;Flag ob Kanle an/aus ?
	beq.w	.nodmacon
	move.w	UPS_Dmacon(a0),d5		;echte Werte holen
.nodmacon
	moveq	#3,d3				;4 Kanle
anloo:
	moveq	#0,d0			;Lautstrke 0,falls Kanal aus

	move.w	(a1),d0			;alten Lautstrkewert holen

	asr.w	#1,d5			;einen Kanal rausrotieren
	bcc.s	.no			;wenn Bit nicht gesetzt,rausgehen


	tst.w	UPS_Voice1per(a0)	;Sampleperiod testen
	beq.s	.no	;Sampleperiod=0 -> kein neuer Instrumentenanschlag,
			;alten Lautstrkewert lassen

	move.w	UPS_Voice1Vol(a0),d1	;neuen Wert holen
	and.w	#$7f,d1
	cmp.w	#64,d1
	bls.s	.takethis
	moveq	#64,d1
.takethis

	ifeq	debug
	move.l	flagsadr(A5),a4
	else
	lea	begin(pc),a4
	move.l	EUS_EPBase(a4),a4
	lea	EPG_someprefs(a4),a4
	endc

	move.l	(a4),d6
	and.l	#EGPRB_MasterVolume,d6
	beq.s	.NoMaster

	mulu	(a3)+,d1
	lsr.w	#6,d1

.NoMaster:

	move.w	d1,(a2)

.no
	move.w	(A2),d1			;Wert,zu dem hingewandert wird
	beq.s	.godown			;keiner,also abfallen
	cmp.w	d1,d0
	bgt.s	.sub			;Zielwert kleiner,also Sub
	add.w	#10,d0			;Zielwert grer,add
	cmp.w	d1,d0
	bge.s	.fertig
	bra.s	.ok
.sub	subq.w	#6,d0
	cmp.w	d1,d0
	bgt.s	.ok
.fertig
	clr.w	(A2)

.godown
	subq.w	#1,d0			;Runterwandern lassen
	bge.s	.ok
	moveq	#0,d0			;nicht kleiner als 0 werden lassen
.ok
	move.w	d0,(a1)+		;Lautstrke merken
				  ;bernommene Werte lschen,damit Doppelaus-
	clr.w	UPS_Voice1Per(a0) ;wertung entfllt

	addq.l	#2,a2
	add.l	#UPS_Modulo,a0	;nchsten Kanal
	dbf	d3,anloo

	endc
stelldar
;============ Darstellen der Analyzerwerte =================================
	lea	anmerk(a5),a3		;Analyzer-Werte
	move.w	(a3),d3			;1.Kanal
	add.w	6(a3),d3		;4.Kanal

	lsr.w	#2,d3			;durch 4 (32 Schritte,aber 128 mgl.
					;Werte)
	bge.s	.okokok			;muss grer null sein
	moveq	#0,d3			;gleich null
.okokok
	cmp.w	#31,d3			;grer 31 ?
	blo.s	.okok			;nein,weiter
	moveq	#31,d3			;also gleich 31
.okok
	add.w	d3,d3			;mal 2
	lsl.w	#8,d3			;mal 256
					;(64*32 Pixel/8*2Bitplanes = 512
					;Bytes pro Grafik)

	lea	my_bitmap(a5),a0

	move.l	pegeldata(A5),a1
	add.w	d3,a1			;Offset addieren
	move.l	a1,bm_planes(a0)
	add.l	#256,a1			;2.Bitplane
	move.l	a1,bm_planes+4(a0)

	move.w	#12,d2			;X2->im Rastport
	bsr	.copybitm

	move.w	2(a3),d3		;2.Kanal
	add.w	4(a3),d3		;3.Kanal

	lsr.w	#2,d3
	bge.s	.oooop
	moveq	#0,d3
.oooop
	cmp.w	#31,d3
	blo.s	.okok2
	moveq	#31,d3
.okok2
	add.w	d3,d3			;mal 2
	lsl.w	#8,d3			;mal 256
					;(64*32 Pixel/8*2Bitplanes = 256 Bytes
					;pro Grafik)
	
	move.l	d4,a0			;Zieladresse in Bitmap

	lea	my_bitmap(a5),a0
	move.l	pegeldata(A5),a1	;Quelladresse
	add.w	d3,a1			;Offset addieren
	add.w	#256,d3
	move.l	a1,bm_planes(a0)
	add.l	#256,a1
	move.l	a1,bm_planes+4(a0)

	move.w	#12+64+16,d2		;X2->im Rastport
; ========= In das Window (dessen Rastport) kopieren =====================
.copybitm
	movem.l	d0-a6,-(sp)
	move.l	grafsave(a5),a6		;Graphics Library
	move.l	winhandle(a5),a1	;Fensteradresse

	move.l	wd_rport(a1),a1		;Rastport (Ziel)
	move.w	myhoehe1(a5),d3		;Y2
	addq.w	#3+3,d3			;ein kleines Stck tiefer

	lea	my_bitmap(a5),a0	;Bitmap (Quelle)
	moveq	#0,d0			;X1
	moveq	#0,d1			;Y1

	move.w	#an_num*8,d4		;Breite
	move.w	#an_zeilen,d5		;Hhe
		
	move.b	#$c0,d6		;Miniterm = nur kopieren , keine Verknpfung

	jsr	_LVObltbitmaprastport(a6)
	movem.l (sp)+,d0-a6
	rts
*******************************************************************
*    berprfen,ob Analyzerstruktur schon bergeben wurde und     *
* und ob der aktuelle Player Lautstrke und Sampleperiod bergibt *
*******************************************************************
AN_test
	ifne	RealMeter

	;**********************************************************
	;*                 neuer Anzeigemodus                     *
	;**********************************************************

	move.l	winhandle(a5),d0	;Window berhaupt offen ?
	beq.w	.noanalyze
	move.l	d0,a0

	move.w	myhoehe1(a5),d0
	cmp.w	wd_height(a0),d0	;Window im ZIP-Modus ?
	beq.w	.noanalyze

	move.l	an_structadr(a5),d0	;Strukturadresse vorhanden ?
	beq.w	.Noanalyze
	move.l	d0,a0

	tst.w	UPS_enabled(a0)		;Zugriff erlaubt ?
	bne.w	.noanalyze

	move.w	UPS_Flags(a0),d0	;alle bentigten Werte bergeben ?
	and.w	#UPSB_Per!UPSB_len!UPSB_adr,d0
	cmp.w	#UPSB_Per!UPSB_len!UPSB_adr,d0
	bne.s	.noanalyze

	lea.l	an_struct(a5),a1

	move.w	UPS_Flags(a0),UPS_Flags(a1)
	move.w	UPS_Dmacon(a0),UPS_Dmacon(a1)
	move.w	UPS_Voice1per(a0),UPS_Voice1per(a1)
	move.w	UPS_Voice2per(a0),UPS_Voice2per(a1)
	move.w	UPS_Voice3per(a0),UPS_Voice3per(a1)
	move.w	UPS_Voice4per(a0),UPS_Voice4per(a1)
	move.w	UPS_Voice1len(a0),UPS_Voice1len(a1)
	move.w	UPS_Voice2len(a0),UPS_Voice2len(a1)
	move.w	UPS_Voice3len(a0),UPS_Voice3len(a1)
	move.w	UPS_Voice4len(a0),UPS_Voice4len(a1)
	move.l	UPS_Voice1Adr(a0),UPS_Voice1adr(a1)
	move.l	UPS_Voice2Adr(a0),UPS_Voice2adr(a1)
	move.l	UPS_Voice3Adr(a0),UPS_Voice3adr(a1)
	move.l	UPS_Voice4Adr(a0),UPS_Voice4adr(a1)
	move.w	UPS_Voice1Repeat(a0),UPS_Voice1repeat(a1)
	move.w	UPS_Voice2Repeat(a0),UPS_Voice2repeat(a1)
	move.w	UPS_Voice3Repeat(a0),UPS_Voice3repeat(a1)
	move.w	UPS_Voice4Repeat(a0),UPS_Voice4repeat(a1)

	else

	;***********************************************************
	;*                  alte Methode                           *
	;***********************************************************

;========== Window offen mit voller Gre ? =======================
	move.l	winhandle(a5),d0	;Window berhaupt offen ?
	beq	.noanalyze		;nein,raus
	move.l	d0,a0

	move.w	myhoehe1(a5),d0		;Window im ZIP-Modus ?
	cmp.w	wd_height(a0),d0
	beq.s	.Noanalyze		;nein,raus

;============ Strukturadresse bekannt ? ===========================
	move.l	an_structadr(a5),d0
	beq.s	.Noanalyze		;nein,raus

	move.l	d0,a0

;================ Zugriff auf Struktur erlaubt ? ==================
	tst.w	UPS_enabled(a0)
	bne.s	.Noanalyze		;nein,raus

;======== Werte aus der Hauptstruktur holen und intern merken ==========
	lea.l	an_struct(a5),a1

	move.w	UPS_Flags(a0),d0	;Test,ob Player geforderte Daten
	move.w	d0,UPS_Flags(a1)	;berhaupt bergibt
	and.w	#UPSB_Per!UPSB_Vol,d0
	cmp.w	#UPSB_Per!UPSB_Vol,d0
	bne.s	.noanalyze		;nein,raus

					;Werte kopieren

	move.w	UPS_Voice1Per(a0),UPS_Voice1Per(a1)
	move.w	UPS_Voice2Per(a0),UPS_Voice2Per(a1)
	move.w	UPS_Voice3Per(a0),UPS_Voice3Per(a1)
	move.w	UPS_Voice4Per(a0),UPS_Voice4Per(a1)

	move.w	UPS_Voice1Vol(a0),UPS_Voice1Vol(a1)
	move.w	UPS_Voice2Vol(a0),UPS_Voice2Vol(a1)
	move.w	UPS_Voice3Vol(a0),UPS_Voice3Vol(a1)
	move.w	UPS_Voice4Vol(a0),UPS_Voice4Vol(a1)

	move.w	ups_dmacon(a0),ups_dmacon(a1)

	endc

	bra	Analyze1		;auswerten

.noanalyze
	rts
***************************************************************************
*           Nachrichtenbearbeitung ,Hauptprogramm                         *
***************************************************************************
HandleActions:
	bra.s	.ma

.ma2

	btst	d3,d0		;Signal: Analyzer ???
	beq.s	.ma		;nein
	bsr.w	An_test		;Analyzer nimmt Arbeit auf !

.ma

	move.l	4.w,a6
	move.l	port(a5),d0	;Fenster offen ?
	beq.s	.nowinport	;nein 
	move.l	d0,a0
	jsr	_LVOgetmsg(a6)	;Fenstermeldung abholen
	tst.l	d0		;Meldung bekommen ?
	bne	.msg		;ja,auswerten
.nowinport
	lea.l	msgport(a5),a0
	jsr	_LVOgetmsg(a6)	;Message vom Eagleplayer bekommen (oder eigene
	tst.l	d0		;abgeschickte zurck ?)
	bne	.AN_msg		;ja,auswerten
	
;--------- Signalmaske erstellen ,auf die gewartet wird ---------------

	moveq	#0,d0
	move.l	4.w,a6
	move.l	port(a5),d1	;Windowport
	beq.s	.no		;kein Fenster offen
	move.l	d1,a0
	move.b	mp_sigbit(a0),d1;Signalbit aus Messageport holen
	bset	d1,d0		;in Maske einfgen
.no
	lea.l	msgport(a5),a0	;2.Messageport
	move.b	mp_sigbit(a0),d1
	bset	d1,d0
	move.l	mysignal(a5),d3	;Signal fr Analyzer
	tst.l	an_structadr(a5);wenn keine Struktur vorhanden,wird auch nicht
	beq.s	.nowaitsig	;gewartet
	bset	d3,d0		;Signalbit fr Abarbeitung des Analyzers selbst
				;(Auswertungsroutine namens "ANALYZE1")
.nowaitsig
	jsr	_LVOwait(a6)	;auf Signale warten
	bra	.ma2
;================ Message an Analyzerport bekommen ===========================
.AN_msg

	move.l	d0,a1
				;persnliche Daten bekanntgeben
				;(ja,ja der Datenschutz...)

	move.l	a5,UM_Userport(a1)		;Trick:erst Basisadresse
						;sichern,dann Offset addieren
	add.l	#msgport,UM_UserPort(a1)	;wohin soll der Eagleplayer
						;senden ?-> an unseren MSGPORT!

	lea	begin(pc),a2			;Usernummer,nicht ndern,wird

	ifne	debug
	move.w	um_usernr(a1),saveusernr(A5)
	else
	move.w	EUS_Usernr(A2),UM_UserNr(a1)
	endc

	move.l	mytask(a5),UM_TaskAdr(a1)	;unsere Taskadresse

	move.l	mysignal(a5),d1			;Signal,auf das wir sehnschtig
 	move.l	d1,UM_Signal(a1)		;warten

	move.l	UM_Type(a1),d7			;Wem gehrt die Message ?
	move.l	UM_structadr(a1),d6 	<-	;Strukturadresse
	move.w	UM_class(a1),d3		<-	;Kommando

	cmp.w	#USclass_exit,d3
	bne.s	.noexi
	clr.l	UM_Signal(a1)
	clr.l	UM_Taskadr(a1)
.noexi
	cmp.w	#USclass_getconfig,d3		;wenn dieses Kommando,sofort
						;auswerten,bevor die Message
						;zurckgesendet wird
	bne	.noprev
	moveq	#0,d0
	move.l	winhandle(A5),d1		;Fenster
	beq.s	.prnowin			;kein Fenster,keine nderung
						;der Voreinstellungen
	or.w	#eusb_openwin,d0		;Flag: Fenster offen

	move.l	d1,a0				;Fenster
	move.w	myhoehe1(a5),d1			;Window im ZIP-Modus ?
	cmp.w	wd_height(a0),d1		;Reale Hhe mit brechneter fr
						;ZIP-Modus vergleichen
	bne.s	.getxy				;kein ZIP-Mode
	or.w	#eusb_zipwin,d0			;FLAG: ZIP-Modus
	bra.s	.prnowin			;Windowposition nicht auswerten
.getxy
	move.w	wd_leftedge(a0),eus_winx(a2)	;Fensterposition merken
	move.w	wd_topedge(a0),eus_winy(a2)
.prnowin
	move.w	d0,eus_flags(a2)		;Flags bergeben
.noprev

	cmp.w	#USclass_Show,d3	;Fenster ffnen
	beq.s	.win

	cmp.w	#USclass_Activate,d3	;Fenster ffnen
	bne.w	.nowin
.win
	move.l	Begin+EUS_EPBase(pc),a0
	move.l	EPG_SomePrefs(a0),d0
	btst	#EGPRF_Iconify,d0
	bne.w	.noclosewin

	bsr	Openwin			;Hallo da bin ich !
	bra	.noclosewin
.nowin
	cmp.w	#USclass_Hide,d3	;Fenster schlieen
	beq.s	.closewin
	cmp.w	#USclass_DeActivate,d3	;Fenster schlieen
	bne.s	.noclosewin
.closewin
	bsr	Closewin		;Window zu machen
.noclosewin
	lea	msgport(a5),a0
	move.l	mn_replyport(a1),d0
	cmp.l	a0,d0		;eine von uns abgeschickte Message ?
	beq.s	.noreply	;ja,keinesfalls nochmal auf den Weg schicken
	jsr	_LVOreplymsg(a6)
.noreply
	cmp.l	#USM_Userprg,d7		;Message zurckbekommen ?
	bne.s	.nomy
	move.b	#0,messagesent(a5)	;merken,da Message-Struktur frei
	bra	.mess			;eventl. Message vom Esagle auswerten
.nomy
	cmp.l	#USM_Eagleplayer,d7	;Hat EaglePlayer was zu melden ?
	bne	.noeagle		;n
.mess
	move.l	d6,an_structadr(a5)	;Analyzerstrukturadresse merken
	tst.l	d6
	bne.s	.noclr
	bsr	.ClearPic		;Wenn Adresse 0 -> Fenster lschen
.noclr
	cmp.w	#USclass_Dummy,d3	;leere Message,nur neue Analyzer-
	beq.w	.ma			;adresse bekommen

	cmp.w	#USclass_zipwin,d3
	bne.s	.nozip
.setzip

	move.l	winhandle(a5),d0
	beq	.ma
	move.l	d0,a0
	move.w	wd_height(a0),d0
	cmp.w	myhoehe1(a5),d0
	beq.w	.ma		;Window schon klein
.zip
	move.w	d0,d4

	move.l	intsave(a5),a6
	cmp.w	#37,lib_version(A6)
	blt	.ma
	jsr	_LVOzipwindow(a6)

	move.l	winhandle(a5),a2
.Zipwait:
	moveq	#1,d1

	lea	begin(pc),a6
	move.l	EUS_EPBASE(a6),a6
	move.l	DTG_Dosbase(A6),a6
	jsr	_LVODelay(a6)

	cmp.w	wd_height(a2),d4
	beq.s	.zipwait

	bra	.ma
.nozip
	cmp.w	#USclass_unzipwin,d3
	bne.s	.nounzip

.clearzip
	move.l	winhandle(a5),d0
	beq	.ma
	move.l	d0,a0
	move.w	wd_height(a0),d0
	cmp.w	myhoehe1(a5),d0
	beq.s	.zip
	bra	.ma
.nounzip

	cmp.w	#USclass_exit,d3	;Meldung,das Programm zu beenden
	beq	.exit			;alles dicht machen und verschwinden

	cmp.w	#USclass_NewConfig,d3	;Neu angekommene Config setzen ?
	bne.w	.nonewcon		;n

	lea	begin(pc),a0		;Anfang des Programms (EUS_-Struktur)
	move.w	eus_flags(a0),d0	;Flags holen
	btst	#eusf_openwin,d0	;Window open ?
	beq.s	.nowino
	bsr	openwin			;ffnen
	bra.s	.weio
.nowino
	bsr	closewin		;schlieen
.weio
	lea	begin(pc),a0		;Anfang des Programms (EUS_-Struktur)
	move.l	winhandle(a5),d0	;Fensteradresse
	beq.s	.nothingtomove		;kein Window , keine Windowbewegung

	move.l	d0,a1			;Window
	move.l	wd_wscreen(a1),a2	;Parent Screen

	move.w	eus_winx(a0),d0		;neue X-Position
	move.w	d0,d1			;sichern
	blt.s	.oldx			;kleiner 0 -> sofort aufhren

	add.w	#win_breite,d1		;neue Position + Windowbreite
	cmp.w	sc_width(a2),d1		;grer als Screenbreite ?
	bhi.s	.oldx			;dann alte X-Position (Delta = 0)

	sub.w	wd_leftedge(a1),d0	;neue - alte X-Position = Delta X
	bra.s	.gety
.oldx
	moveq	#0,d0			;Delta X = 0
.gety
	move.w	eus_winy(a0),d1		;neue Y-Position
	move.w	d1,d2			;sichern
	blt.s	.oldy		;kleiner 0 -> sofort aufhren

	add.w	win_hoehe(a5),d2	;neue Position + Windowhhe
	cmp.w	sc_height(a2),d2	;grer als Screenhhe ?
	bhi.s	.oldy

	sub.w	wd_topedge(a1),d1	;neue - alte Y-Position = Delta Y
	bra.s	.setdeltas
.oldy	moveq	#0,d1
.setdeltas
	move.l	intsave(a5),a6		;Intuition
	move.l	a1,a0			;Winhandle
	jsr	_LVOmovewindow(A6)
.nothingtomove
	lea	begin(pc),a0
	move.w	eus_flags(a0),d0
	btst	#eusf_zipwin,d0		;Zipwindow ?
	bne	.setzip			;yes
	bra	.clearzip		;no
.nonewcon
	bra	.ma
.noeagle
	bra	.ma
;======================== Meldung an IDCMP-Port ==========================
.msg
	move.l	d0,a1
	move.l	im_class(a1),d7
	move.w	im_code(a1),d5 		<-
	move.l	im_Iaddress(a1),d6 	<-
	jsr	_LVOreplymsg(a6)

	cmp.l	#refreshwindow,d7	;Fensterinhalt neu aufbauen ?
	bne.s	.testgads
	bsr	refresh			;Rahmen neu !
	bra	.ma
.testgads
	cmp.l	#menupick,d7		;Men aufgerufen ??
	bne.s	.nomenu
	move.w	d5,d0
	cmp.w	#menunull,d0		;kein Menpunkt ??
	beq	.ma

	and.w	#$7e0,d0

	cmp.w	#32,d0
	bne.s	.noabout
	bsr	Merror			;Infotext ausgeben (Requester)
	bra	.ma
.noabout
	cmp.w	#64,d0		;2. Item ? (Hide)
	beq	.closewinny	;Window schlieen und dies an Eagleplayer
				;signalisieren
	cmp.w	#96,d0		;3. Item ? (Quit)
	beq	.endme

	;--------------- Modusnderung -------------------------
	lea	ModeItem(pc),a1
	move.w	mi_flags(a1),d0
	and.w	#checked,d0
	lsr.w	#8,d0
	move.b	d0,modenr(A5)
	move.b	d0,begin+eus_special

	lea	Pegelchipdata,a0
	beq.s	.mode0
	move.l	Pegelchipdata2,a0
.mode0
	move.l	a0,pegeldata(A5)
	move.l	a0,Data2

	tst.l	an_structadr(a5)	;Strukturadresse vorhanden ?
	bne	.ma

	lea	GadPic,a0
	move.l	winhandle(a5),a1
	suba.l	a2,a2
	moveq	#2,d0
	move.l	intsave(a5),a6
	jsr	_LVOrefreshglist(A6)

	bra	.ma
.nomenu
	cmp.l	#CloseWindow,d7		;Fenster schlieen ?
	bne	.ma
.closewinny
	if	Test=0

	tst.b	messagesent(a5)		;Message zurck ?? (normalerweise ja)
	bne	.ma			;nein,weiter warten,bis Message zurck
					;ist und wieder genutzt werden kann

	bsr	closewin		;Fenster schlieen
	move.l	4.w,a6			;an Eagleplayer signalisieren
	lea	Portname(pc),a1
	jsr	_LVOfindport(a6)	;Eagleplayer finden
	tst.l	d0
	beq.s	.endme		;kein Eagleplayerport->Ende des Programmes
	move.l	d0,a0			;Portadresse

	lea.l	msgport(a5),a1
	move.l	a1,d3			;Messageport
	move.l	mytask(a5),d4		;Task
	move.l	mysignal(a5),d5		;Signal
	move.w	#USclass_DeActivate,d6	;Kommando
	bsr	sendmess		;senden
	bra	.ma

	else

	bra.w	.endme		;nur fr Testvarianten

	endc
.endme
	moveq	#0,d7		;Ende des Hauptprogrammes,darf nicht aufgerufen
	RTS			;werden
.exit	moveq	#-1,d7		;Exit-Message vom Eagleplayer erhalten,alles
	rts			;dichtmachen
	
;=== Ganze Bitmap lschen,hier ganz einfach: das Gadget liegt genau in dem ===
;=== Bereich,wo hineinkopiert wird,also Gadget refreshen->alles sauber     ===
.Clearpic
	tst.l	winhandle(a5)		;Fenster offen ?
	beq.s	.rts

	move.w	myhoehe1(a5),d0		;Window im ZIP-Modus ?
	cmp.w	wd_height(a0),d0
	beq.s	.rts

	movem.l	d0-a6,-(sp)
	bsr	refresh
	movem.l	(sp)+,d0-a6			;lschen
.rts
	rts
;===========================================================================
******************************************************************************
*                       Ausgabe von Error-Messages                           *
*                 Input: a0 -> Zeiger auf Ausgabestring                      *
******************************************************************************
MERROR:
	movem.l	d0-a6,-(sp)

	move.l	winhandle(a5),d0	;*Window
	beq.s	.noabout	;kein Window->raus,sollte aber nicht vorkommen,
				;da diese Funktion eh nur ber Men erreichbar
				;ist
	move.l	d0,a0

	lea	aboutitext(pc),a1	;*Bodytext (Itext-Struktur)
	suba.l	a2,a2			;*Positive Text (keiner)
	lea	okitext(pc),a3		;*Negative Text (ok)
	moveq	#0,d0			;Idcmp True
	moveq	#0,d1			;Idcmp False
	move.w	#466,d2			;Breite
	move.w	#69,d3			;Hhe

	move.l	Intsave(a5),a6
	jsr	_LVOautorequest(a6)	;Requester unter 1.3
.noabout
	movem.l	(sp)+,d0-a6	
	rts
;*****************************************************************************
;*                        Daten und Initialisierungen                        *
;*****************************************************************************

int:	dc.b	`intuition.library`,0
graf:	dc.b	`graphics.library`,0

portname:	dc.b	`EAGLEPLAYERPORT`,0

MyWinName:	dc.b	`Levelgraph`,0
MyAnalyzername:	dc.b	`ELevelgraph.1`,0
MyUsername:	dc.b	`Levelgraph    `,0
Project0STitle:	dc.b	'Levelgraph (Eagleplayer),  DEFECT Softworks',0

my_easylabel2:	dc.b	`Cancel`,0
my_easylabel3:	dc.b	`OK`,0
my_easylabel1:	dc.b	`Retry`,0

Aboutmessage:
	dc.b	`    Eagleplayer Levelgraph V`
	ver
	dc.b	`, 1995 DEFECT`,$0
Aboutmessage.1:
	dc.b	`the second mode is available in the reg. Version !`,0
Aboutmessage.2:
	dc.b	`  code & idea : Henryk "Buggs" Richter of DEFECT`,0
Aboutmessage.3:
	dc.b	`   graphics : Jrg "M.U.D.U" Krempien of DEFECT`,0

mybuggsname	dc.b	`Buggs of DEFECT`,0

myinfo		dc.b	`This scope displays the current Volume level in a nice way. `
		dc.b	`For registered users there exists a second mode with a nicer `
		dc.b	`layout.`,10
		dc.b	`graphics by Volker Kessler & Jrg "M.U.D.U" Krempien`,0
		
NoportMessage:	dc.b	`Cannot find EaglePlayer Port`,0
	even
Aboutitext
	dc.b	0
	dc.b	1
	dc.b	RP_Jam2
	dc.b	0
	dc.w	11
	dc.w	3
	dc.l	myfontatt
	dc.l	Aboutmessage
	dc.l	.about1
.about1
	dc.b	0
	dc.b	1
	dc.b	RP_Jam2
	dc.b	0
	dc.w	11
	dc.w	11
	dc.l	myfontatt
	dc.l	Aboutmessage.1
	dc.l	.about2
.about2
	dc.b	0
	dc.b	1
	dc.b	RP_Jam2
	dc.b	0
	dc.w	11
	dc.w	20
	dc.l	myfontatt
	dc.l	Aboutmessage.2
	dc.l	.about3
.about3
	dc.b	0
	dc.b	1
	dc.b	RP_Jam2
	dc.b	0
	dc.w	11
	dc.w	29
	dc.l	myfontatt
	dc.l	Aboutmessage.3
	dc.l	0
MyWindow:
	dc.w	0
	dc.w	0
	dc.w	win_breite
	dc.w	11+18+6
	dc.b	0
	dc.b	1
	dc.l	closewindow!menupick!refreshwindow
	dc.l	Windowdrag!Windowdepth!Windowclose
	dc.l	0
	dc.l	0
	dc.l	MYwinname
	dc.l	0
	dc.l	0
	dc.w	0,0
	dc.w	0,0
	dc.w	1
Noportitext
	dc.b	0
	dc.b	1
	dc.b	RP_Jam2
	dc.b	0
	dc.w	6
	dc.w	3
	dc.l	myfontatt
	dc.l	Noportmessage
	dc.l	0
Retryitext
	dc.b	0
	dc.b	1
	dc.b	RP_Jam2
	dc.b	0
	dc.w	6
	dc.w	3
	dc.l	myfontatt
	dc.l	my_easylabel1
	dc.l	0
Cancelitext
	dc.b	0
	dc.b	1
	dc.b	RP_Jam2
	dc.b	0
	dc.w	6
	dc.w	3
	dc.l	myfontatt
	dc.l	my_easylabel2
	dc.l	0
OKitext
	dc.b	0
	dc.b	1
	dc.b	RP_Jam2
	dc.b	0
	dc.w	6
	dc.w	3
	dc.l	myfontatt
	dc.l	my_easylabel3
	dc.l	0
myfontatt:
	dc.l	myfontname
	dc.w	8
	dc.w	0
myfontname:	dc.b	`topaz.font`,0
	even
projmenu:
	dc.l	0
	dc.w	0,0,60,0
	dc.w	menuenabled
	dc.l	projname
	dc.l	Modeitem
	dc.w	0,0,0,0
projname:
	dc.b	`Project`,0
	even
ModeItem
	dc.l	Aboutitem
	dc.w	0,0,120,10
FlagsTO
	dc.w	highitem!highcomp!itemenabled!itemtext!commseq!Checkit!Menutoggle
	dc.l	0
	dc.l	modetextstr
	dc.l	0
	dc.b	`M`
	dc.b	0
	dc.l	0
	dc.l	Menunull
Modetextstr:
	dc.b	0
	dc.b	1
	dc.b	RP_Jam2
	dc.b	0
	dc.w	20
	dc.w	1
	dc.l	Myfontatt
	dc.l	modename
	dc.l	0
modename:
	dc.b	`Mode 1`,0
	even
aboutitem:
	dc.l	hideitem
	dc.w	0,10,120,10
	dc.w	highitem!highcomp!itemenabled!itemtext!commseq
	dc.l	0
	dc.l	abouttextstr
	dc.l	0
	dc.b	`A`
	dc.b	0
	dc.l	0
	dc.l	Menunull
abouttextstr:
	dc.b	0
	dc.b	1
	dc.b	RP_Jam2
	dc.b	0
	dc.w	1
	dc.w	1
	dc.l	Myfontatt
	dc.l	aboutname
	dc.l	0
aboutname:
	dc.b	`About`,0
	even
Hideitem:
	dc.l	QuitItem
	dc.w	0,20,120,10
	dc.w	highitem!highcomp!itemenabled!itemtext!commseq
	dc.l	0
	dc.l	Hidetext
	dc.l	0
	dc.b	`H`
	dc.b	0
	dc.l	0
	dc.l	Menunull
Hidetext:
	dc.b	0
	dc.b	1
	dc.b	RP_Jam2
	dc.b	0
	dc.w	1
	dc.w	1
	dc.l	Myfontatt
	dc.l	Hidename
	dc.l	0
HideName:
	dc.b	`Hide`,0
	even
quititem:
	dc.l	0
	dc.w	0,30,120,10
	dc.w	highitem!highcomp!itemenabled!itemtext!commseq
	dc.l	0
	dc.l	quittext
	dc.l	0
	dc.b	`Q`
	dc.b	0
	dc.l	0
	dc.l	Menunull
Quittext:
	dc.b	0
	dc.b	1
	dc.b	RP_Jam2
	dc.b	0
	dc.w	1
	dc.w	1
	dc.l	Myfontatt
	dc.l	quitname
	dc.l	0
quitname:
	dc.b	`Quit`,0
	even
patt1	dc.w	%1010101010101010
	dc.w	%0101010101010101
patt2	dc.w	0,0
;*** Leertabellen (spter im BSS-Hunk) ,Diskettenplatzsparend untergebracht***
		section	1,BSS
		rsreset
datas:
flagsadr	rs.l	1
intsave:	rs.l	1	;Intuition
grafsave:	rs.l	1	;Graphics
WinHandle:	rs.l	1	;Fenster
Port:		rs.l	1	;Fenster IDCMP-Port
MsgPort:	rs.b	mp_size	;extra Messageport
Mysignal	rs.l	1	;Signalnummer
Mytask		rs.l	1	;Taskadresse
mypubscreen:	rs.l	1	;aktueller Publicscreen
fonth:		rs.l	1	;Fonthhe
Win_hoehe:	rs.w	1

mytags:		rs.l	20*2
myzoom:		rs.w	3	;left,top,width,height
myhoehe2:	rs.w	1
myhoehe1:	rs.w	1
winwidth:	rs.w	1	;Breite des Fensters

MY_Easystruct:	rs.l	1	;EASY-Request Struktur
		rs.l	1
		rs.l	1
		rs.l	1
		rs.l	1

MY_Bitmap:	rs.b	8	;Bitmap Struktur
		rs.l	1
		rs.l	1
		rs.l	6
permerk		rs.l	4
Nulls:		rs.l	20		;Null-Array
Anmerk:		rs.w	4		;4 Kanle = 4*Lautstrke
Goto:		rs.w	4		;4*Lautstrke,wo hinzuwandern ist

Mymessage:	rs.b	UM_sizeof	;Intuimessagestruktur
AN_Structadr:	rs.l	1		;vom Eagleplayer erhaltene Struktur
pegeldata	rs.l	1
AN_Struct:	rs.b	UPS_sizeof	;Lnge der eigenen Struktur
Messagesent:	rs.b	1		;Flag,ob Message losgeschickt
Modenr		rs.b	1		;Modus 0/1
	ifne	debug
saveusernr	rs.w	1
	endc
DatasLen:	rs.w	0		;Lnge des BSS-Blocks

		ds.b	DatasLen
	section	2,data_C
;====== Daten fr die Grafik,die als Gadget ins Window eingebunden wird ====
GadPic:
	dc.l	gadpic2
	dc.w	12,0
	dc.w	64,32
	dc.w	Gadgimage!gadghnone
	dc.w	0
	dc.w	boolgadget
	dc.l	Mode1Image
	dc.l	0
	dc.l	0
	dc.l	0
	dc.l	0
	dc.w	0
	dc.l	0
GadPic2:
	dc.l	0
	dc.w	12+16+64,0
	dc.w	64,32
	dc.w	Gadgimage!gadghnone
	dc.w	0
	dc.w	boolgadget
	dc.l	Mode1Image
	dc.l	0
	dc.l	0
	dc.l	0
	dc.l	0
	dc.w	0
	dc.l	0
Mode1Image
	dc.w	0,0
	dc.w	64,32,2
Data2
	dc.l	Pegelchipdata
	dc.b	03,00
	dc.l	0
pegelchipdata2
	dc.l	Daten2
ItemFlags
	dc.w	highitem!highcomp!itemenabled!itemtext!commseq!Checkit!Menutoggle
Pegelchipdata:
	DC.L	0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF40,$017FFF81,$01FFC100,$0043FF01,$00FE0000,$00007C01,$007E0000,$00001001,$00120000,$00000001,$00010000,$00000001,$0000C000,$00000001,$00002000,$00000001,$00001000,$00000001,$00000800,$00000001,$00000F00,$00000001,$000003E0,$00000001,$00000730,$00000001,$00000118,$00000001,$000000D0,$00000001,$0000005C,$00000001,$00000004,$00000001,$00000003,$00000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EFBE,$FBEFDFBC,$86FBEFFE,$FFEFBF78,$8A7DF7FF,$FFDF7EF0,$859FFFFF,$FFFFFBE0,$804FFF80,$00FFF780,$8081C000,$0003EF00,$80400000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$80008AA0,$00088000,$80008000,$01508000,$80008000,$00010000,$80000080,$0AAA0000,$8000A800,$08000000,$80008000,$08000000,$80008000,$08000000,$80000020,$08000000,$8002AAA0,$A8000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF40,$017FFF81,$01FFC100,$0043FF01,$00FE0000,$00007C01,$007E0000,$00001001,$00120000,$00000001,$00018000,$00000001,$00004000,$00000001,$00002000,$00000001,$00001000,$00000001,$00000800,$00000001,$00000F00,$00000001,$000007E0,$00000001,$00000330,$00000001,$00000138,$00000001,$000000EC,$00000001,$0000007C,$00000001,$0000000C,$00000001,$00000003,$00000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EFBE,$FBEFDFBC,$86FBEFFE,$FFEFBF78,$8B7DF7FF,$FFDF7EF0,$859FFFFF,$FFFFFBE0,$8067FF80,$00FFF780,$80A1C000,$0003EF00,$80400000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$80008AA0,$00088000,$80008000,$01508000,$80008000,$00010000,$80000080,$0AAA0000,$8000A800,$08000000,$80008000,$08000000,$80008000,$08000000,$80000000,$08000000,$8002AA80,$A8000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF40,$017FFF81,$01FFC100,$0043FF01,$00FF0000,$00007C01,$007F8000,$00001001,$00108000,$00000001,$00004000,$00000001,$00002000,$00000001,$00001000,$00000001,$00000800,$00000001,$00000400,$00000001,$00000700,$00000001,$000003E0,$00000001,$00000350,$00000001,$00000158,$00000001,$00000074,$00000001,$0000001C,$00000001,$00000004,$00000001,$00000003,$00000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EFBE,$FBEFDFBC,$86FBEFFE,$FFEFBF78,$8B5DF7FF,$FFDF7EF0,$85CFFFFF,$FFFFFBE0,$8061FF80,$00FFF780,$80B0C000,$0003EF00,$80500000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$8000AAA0,$00088000,$80008000,$01508000,$80008000,$00010000,$80000080,$0AAA0000,$8000A800,$08000000,$80008000,$08000000,$80008000,$08000000,$80000000,$08000000,$8002AAA0,$A8000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF40,$017FFF81,$01FFC100,$0043FF01,$00FFC000,$00007C01,$0079C000,$00001001,$00104000,$00000001,$00002000,$00000001,$00001000,$00000001,$00000800,$00000001,$00000400,$00000001,$00000200,$00000001,$00000380,$00000001,$000001F0,$00000001,$000001B8,$00000001,$000000BC,$00000001,$00000066,$00000001,$0000002C,$00000001,$0000000C,$00000001,$00000003,$00000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EFBE,$FBEFDFBC,$86EBEFFE,$FFEFBF78,$8B75F7FF,$FFDF7EF0,$85DBFFFF,$FFFFFBE0,$8068BF80,$00FFF780,$80B00000,$0003EF00,$805E0000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$8000A2A0,$00088000,$80008000,$01508000,$80008000,$00010000,$80000000,$0AAA0000,$8000AA00,$08000000,$80008000,$08000000,$80008000,$08000000,$80000000,$08000000,$8002AA80,$A8000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF40,$017FFF81,$01FFF100,$0043FF01,$00FFE000,$00007C01,$0078E000,$00001001,$00102000,$00000001,$00001000,$00000001,$00000800,$00000001,$00000400,$00000001,$00000200,$00000001,$00000100,$00000001,$000001C0,$00000001,$000000F8,$00000001,$000000D8,$00000001,$0000009C,$00000001,$00000062,$00000001,$0000002E,$00000001,$0000000C,$00000001,$00000003,$00000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EFBE,$FBEFDFBC,$86FBEFFE,$FFEFBF78,$8B7DF7FF,$FFDF7EF0,$85DEFFFF,$FFFFFBE0,$806C0F80,$00FFF780,$80B60000,$0003EF00,$805E0000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$8000AAA0,$00088000,$80008000,$01508000,$80008000,$00010000,$80000000,$0AAA0000,$8000AA00,$08000000,$80008000,$08000000,$80008000,$08000000,$80000000,$08000000,$8002AA80,$A8000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF40,$017FFF81,$01FFF100,$0043FF01,$00FEF000,$00007C01,$00783000,$00001001,$00100800,$00000001,$00000C00,$00000001,$00000400,$00000001,$00000200,$00000001,$00000100,$00000001,$00000080,$00000001,$000000E0,$00000001,$000000F0,$00000001,$0000005C,$00000001,$00000016,$00000001,$00000016,$00000001,$00000016,$00000001,$00000006,$00000001,$00000003,$00000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EFBE,$FBEFDFBC,$86FAEFFE,$FFEFBF78,$8B7C77FF,$FFDF7EF0,$85DF7FFF,$FFFFFBE0,$806F0F80,$00FFF780,$80B70000,$0003EF00,$805E0000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$8000A8A0,$00088000,$80008000,$01508000,$80008000,$00010000,$80000000,$0AAA0000,$8000AA00,$08000000,$80008000,$08000000,$80008000,$08000000,$80000020,$08000000,$8002AAA0,$A8000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF40,$017FFF81,$01FFFD00,$0043FF01,$00FE7C00,$00007C01,$00781800,$00001001,$00100400,$00000001,$00000200,$00000001,$00000300,$00000001,$00000100,$00000001,$00000080,$00000001,$00000040,$00000001,$000000F0,$00000001,$00000070,$00000001,$0000006C,$00000001,$0000002A,$00000001,$00000013,$00000001,$00000004,$00000001,$00000007,$00000001,$00000001,$00000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EFBE,$FBEFDFBC,$86FB2FFE,$FFEFBF78,$8B7DB7FF,$FFDF7EF0,$85DFDFFF,$FFFFFBE0,$806FC380,$00FFF780,$80B78000,$0003EF00,$805E0000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$8000AAA0,$00088000,$80008000,$01508000,$80008000,$00010000,$80000000,$0AAA0000,$8000AA80,$08000000,$80008000,$08000000,$80008000,$08000000,$80000020,$08000000,$8002AAA0,$A8000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF40,$017FFF81,$01FFDF00,$0043FF01,$00FE1E00,$00007C01,$00780600,$00001001,$00100200,$00000001,$00000100,$00000001,$00000080,$00000001,$00000080,$00000001,$00000040,$00000001,$00000020,$00000001,$00000070,$00000001,$00000038,$00000001,$00000036,$00000001,$0000002B,$00000001,$0000001B,$00000001,$0000000A,$80000001,$00000007,$00000001,$00000001,$00000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EFBE,$FBEFDFBC,$86FBCFFE,$FFEFBF78,$8B7DE7FF,$FFDF7EF0,$85DFF3FF,$FFFFFBE0,$806FE080,$00FFF780,$80B7C000,$0003EF00,$805E0000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$8000AA20,$00088000,$80008000,$01508000,$80008000,$00010000,$80000080,$0AAA0000,$8000AA80,$08000000,$80008000,$08000000,$80008000,$08000000,$80000020,$08000000,$8002AAA0,$28000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF40,$017FFF81,$01FFC780,$0043FF01,$00FE0780,$00007C01,$00780300,$00001001,$00100080,$00000001,$00000080,$00000001,$00000040,$00000001,$00000040,$00000001,$00000020,$00000001,$00000010,$00000001,$00000038,$00000001,$0000001C,$00000001,$00000037,$00000001,$00000015,$00000001,$0000001D,$80000001,$0000000A,$80000001,$00000003,$80000001,$00000001,$00000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7E7BE,$FBEFDFBC,$86FBE7FE,$FFEFBF78,$8B7DF3FF,$FFDF7EF0,$85DFF9FF,$FFFFFBE0,$806FF800,$00FFF780,$80B7C000,$0003EF00,$805E0000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$8000AAA0,$00088000,$80008000,$01508000,$80008000,$00010000,$80000080,$0AAA0000,$8000AA80,$08000000,$80008000,$08000000,$80008000,$08000000,$80000020,$08000000,$8002AAA0,$28000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFFC0,$017FFF81,$01FFC3C0,$0043FF01,$00FE01C0,$00007C01,$00780180,$00001001,$00100040,$00000001,$00000040,$00000001,$00000020,$00000001,$00000030,$00000001,$00000010,$00000001,$00000018,$00000001,$0000001C,$00000001,$0000001E,$00000001,$0000000B,$00000001,$0000000A,$00000001,$00000005,$80000001,$00000005,$00000001,$00000003,$80000001,0,$80000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EBBE,$FBEFDFBC,$86FBEDFE,$FFEFBF78,$8B7DF5FF,$FFDF7EF0,$85DFFE7F,$FFFFFBE0,$806FFC00,$00FFF780,$80B7C000,$0003EF00,$805E0000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000000,$00108000,$8000AA80,$00088000,$80008000,$01508000,$80008000,$00010000,$80000080,$0AAA0000,$8000AA80,$08000000,$80008000,$08000000,$80008000,$08000000,$80000020,$08000000,$8002AAA0,$A8000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFFE0,$017FFF81,$01FFC1F0,$0043FF01,$00FE01E0,$00007C01,$00780020,$00001001,$00100020,$00000001,$00000010,$00000001,$00000010,$00000001,$00000008,$00000001,$00000008,$00000001,$00000008,$00000001,$0000000E,$00000001,$0000000E,$00000001,$0000000D,$80000001,$0000000A,$C0000001,$00000006,$C0000001,$00000005,$60000001,$00000003,$C0000001,0,$80000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EEBE,$FBEFDFBC,$86FBEF7E,$FFEFBF78,$8B7DF77F,$FFDF7EF0,$85DFFF1F,$FFFFFBE0,$806FFF00,$00FFF780,$80B7C000,$0003EF00,$805E0000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$8000AAA0,$00088000,$80008000,$01508000,$80008000,$00010000,$80000080,$0AAA0000,$8000AA80,$08000000,$80008000,$08000000,$80008000,$08000000,$80000020,$08000000,$8002AAA0,$88000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFFE0,$017FFF81,$01FFC1F8,$0043FF01,$00FE00F0,$00007C01,$00780020,$00001001,$00100010,$00000001,$00000010,$00000001,$00000010,$00000001,$00000008,$00000001,$00000008,$00000001,$00000008,$00000001,$0000000E,$00000001,$0000000E,$00000001,$0000001B,$80000001,$0000000A,$80000001,$0000000D,$80000001,$00000001,$40000001,$00000003,$80000001,$00000001,$00000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EF3E,$FBEFDFBC,$86FBEF7E,$FFEFBF78,$8B7DF7BF,$FFDF7EF0,$85DFFF1F,$FFFFFBE0,$806FFF00,$00FFF780,$80B7C000,$0003EF00,$805E0000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$8000AAA0,$00088000,$80008000,$01508000,$80008000,$00010000,$80000080,$0AAA0000,$8000AA80,$08000000,$80008000,$08000000,$80008000,$08000000,$80000020,$08000000,$8002AAA0,$A8000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF78,$017FFF81,$01FFC17C,$0043FF01,$00FE0038,$00007C01,$00780008,$00001001,$00100008,$00000001,$00000008,$00000001,$00000008,$00000001,$00000004,$00000001,$00000004,$00000001,$00000004,$00000001,$00000007,$00000001,$00000007,$00000001,$0000000D,$80000001,$0000000A,$C0000001,$00000006,$C0000001,$00000005,$40000001,$00000003,$80000001,0,$80000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EF9E,$FBEFDFBC,$86FBEFDE,$FFEFBF78,$8B7DF7DF,$FFDF7EF0,$85DFFFC7,$FFFFFBE0,$806FFF80,$00FFF780,$80B7C000,$0003EF00,$805E0000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$8000AAA0,$00088000,$80008000,$01508000,$80008000,$00010000,$80000080,$0AAA0000,$8000AA80,$08000000,$80008000,$08000000,$80008000,$08000000,$80000020,$08000000,$8002AAA0,$A8000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF5C,$017FFF81,$01FFC11F,$0043FF01,$00FE000E,$00007C01,$00780004,$00001001,$00100004,$00000001,$00000004,$00000001,$00000002,$00000001,$00000002,$00000001,$00000002,$00000001,$00000002,$00000001,$00000007,$00000001,$00000003,$80000001,$00000006,$C0000001,$00000005,$40000001,$00000006,$C0000001,$00000005,$00000001,$00000001,$C0000001,0,$80000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EFB6,$FBEFDFBC,$86FBEFF6,$FFEFBF78,$8B7DF7F7,$FFDF7EF0,$85DFFFE3,$FFFFFBE0,$806FFF80,$00FFF780,$80B7C000,$0003EF00,$805E0000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$8000AAA0,$00088000,$80008000,$01508000,$80008000,$00010000,$80000080,$0AAA0000,$8000AA80,$08000000,$80008000,$08000000,$80008000,$08000000,$80000020,$08000000,$8002AAA0,$A8000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF47,$017FFF81,$01FFC10F,$8043FF01,$00FE0007,$00007C01,$00780002,$00001001,$00100002,$00000001,$00000001,$00000001,$00000001,$00000001,$00000001,$00000001,$00000001,$00000001,$00000001,$00000001,$00000003,$80000001,$00000003,$80000001,$00000003,$60000001,$00000002,$A0000001,$00000003,$60000001,$00000002,$A0000001,$00000001,$C0000001,0,$80000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EFBA,$FBEFDFBC,$86FBEFFC,$FFEFBF78,$8B7DF7FD,$FFDF7EF0,$85DFFFF8,$FFFFFBE0,$806FFF80,$00FFF780,$80B7C000,$0003EF00,$805E0000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$8000AAA0,$00088000,$80008000,$01508000,$80008000,$00010000,$80000080,$0AAA0000,$8000AA80,$08000000,$80008000,$08000000,$80008000,$08000000,$80000020,$08000000,$8002AAA0,$08000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF47,$017FFF81,$01FFC10F,$8043FF01,$00FE0003,$80007C01,$00780001,$00001001,$00100001,$00000001,$00000001,$00000001,$00000001,$00000001,$00000001,$00000001,$00000001,$00000001,$00000001,$00000001,$00000003,$80000001,$00000003,$80000001,$00000006,$C0000001,$00000005,$40000001,$00000002,$E0000001,$00000001,$60000001,$00000001,$C0000001,0,$80000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EFBC,$FBEFDFBC,$86FBEFFC,$FFEFBF78,$8B7DF7FD,$FFDF7EF0,$85DFFFF8,$FFFFFBE0,$806FFF80,$00FFF780,$80B7C000,$0003EF00,$805E0000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$8000AAA0,$00088000,$80008000,$01508000,$80008000,$00010000,$80000080,$0AAA0000,$8000AA80,$08000000,$80008000,$08000000,$80008000,$08000000,$80000020,$08000000,$8002AAA0,$88000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF41,$C17FFF81,$01FFC103,$E043FF01,$00FE0001,$C0007C01,$00780000,$80001001,$00100000,$80000001,0,$80000001,0,$80000001,0,$80000001,0,$80000001,0,$80000001,$00000001,$C0000001,$00000001,$C0000001,$00000003,$60000001,$00000002,$A0000001,$00000003,$60000001,$00000002,$A0000001,$00000001,$C0000001,0,$80000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EFBE,$7BEFDFBC,$86FBEFFE,$7FEFBF78,$8B7DF7FF,$7FDF7EF0,$85DFFFFE,$3FFFFBE0,$806FFF80,$00FFF780,$80B7C000,$0003EF00,$805E0000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$8000AAA0,$00088000,$80008000,$01508000,$80008000,$00010000,$80000080,$0AAA0000,$8000AA80,$08000000,$80008000,$08000000,$80008000,$08000000,$80000020,$08000000,$8002AAA0,$08000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF40,$717FFF81,$01FFC100,$F843FF01,$00FE0000,$E0007C01,$00780000,$40001001,$00100000,$40000001,0,$40000001,0,$40000001,0,$40000001,0,$40000001,0,$40000001,0,$E0000001,0,$E0000001,$00000001,$B0000001,$00000001,$50000001,$00000003,$A0000001,$00000002,$A0000001,$00000001,$C0000001,0,$80000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EFBE,$DBEFDFBC,$86FBEFFE,$DFEFBF78,$8B7DF7FF,$DFDF7EF0,$85DFFFFF,$8FFFFBE0,$806FFF80,$00FFF780,$80B7C000,$0003EF00,$805E0000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$8000AAA0,$00088000,$80008000,$01508000,$80008000,$00010000,$80000080,$0AAA0000,$8000AA80,$08000000,$80008000,$08000000,$80008000,$08000000,$80000020,$08000000,$8002AAA0,$08000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF40,$717FFF81,$01FFC100,$F843FF01,$00FE0000,$70007C01,$00780000,$20001001,$00100000,$20000001,0,$40000001,0,$40000001,0,$40000001,0,$40000001,0,$40000001,0,$E0000001,0,$E0000001,$00000003,$60000001,$00000002,$A0000001,$00000003,$60000001,$00000002,$A0000001,$00000001,$C0000001,0,$80000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EFBE,$EBEFDFBC,$86FBEFFE,$DFEFBF78,$8B7DF7FF,$DFDF7EF0,$85DFFFFF,$8FFFFBE0,$806FFF80,$00FFF780,$80B7C000,$0003EF00,$805E0000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$8000AAA0,$00088000,$80008000,$01508000,$80008000,$00010000,$80000080,$0AAA0000,$8000AA80,$08000000,$80008000,$08000000,$80008000,$08000000,$80000020,$08000000,$8002AAA0,$08000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF40,$1D7FFF81,$01FFC100,$7C43FF01,$00FE0000,$38007C01,$00780000,$10001001,$00100000,$10000001,0,$10000001,0,$20000001,0,$20000001,0,$20000001,0,$20000001,0,$70000001,0,$E0000001,$00000001,$B0000001,$00000001,$50000001,$00000001,$B0000001,0,$B0000001,$00000001,$C0000001,0,$80000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EFBE,$F3EFDFBC,$86FBEFFE,$F7EFBF78,$8B7DF7FF,$F7DF7EF0,$85DFFFFF,$E3FFFBE0,$806FFF80,$00FFF780,$80B7C000,$0003EF00,$805E0000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$8000AAA0,$00088000,$80008000,$01508000,$80008000,$00010000,$80000080,$0AAA0000,$8000AA80,$08000000,$80008000,$08000000,$80008000,$08000000,$80000020,$08000000,$8002AAA0,$08000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF40,$0F7FFF81,$01FFC100,$1F43FF01,$00FE0000,$0E007C01,$00780000,$08001001,$00100000,$08000001,0,$08000001,0,$08000001,0,$10000001,0,$10000001,0,$10000001,0,$70000001,0,$70000001,0,$D8000001,$00000001,$A8000001,$00000001,$B0000001,$00000001,$50000001,0,$E0000001,0,$80000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EFBE,$F9EFDFBC,$86FBEFFE,$FDEFBF78,$8B7DF7FF,$FDDF7EF0,$85DFFFFF,$F1FFFBE0,$806FFF80,$00FFF780,$80B7C000,$0003EF00,$805E0000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$8000AAA0,$00088000,$80008000,$01508000,$80008000,$00010000,$80000080,$0AAA0000,$8000AA80,$08000000,$80008000,0,$80008000,0,$80000020,$08000000,$8002AAA0,$A8000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF40,$03FFFF81,$01FFC100,$0FC3FF01,$00FE0000,$07807C01,$00780000,$02001001,$00100000,$04000001,0,$04000001,0,$04000001,0,$08000001,0,$08000001,0,$08000001,0,$38000001,0,$38000001,0,$EC000001,0,$A8000001,0,$D8000001,$00000001,$50000001,0,$E0000001,0,$40000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EFBE,$FB6FDFBC,$86FBEFFE,$FF6FBF78,$8B7DF7FF,$FEDF7EF0,$85DFFFFF,$FC7FFBE0,$806FFF80,$007FF780,$80B7C000,$0003EF00,$805E0000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$8000AAA0,$00088000,$80008000,$01508000,$80008000,$00010000,$80000080,$02AA0000,$8000AA80,0,$80008000,0,$80008000,0,$80000020,0,$8002AAA0,$A8000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF40,$03FFFF81,$01FFC100,$07C3FF01,$00FE0000,$03C07C01,$00780000,$02001001,$00100000,$02000001,0,$04000001,0,$04000001,0,$08000001,0,$08000001,0,$08000001,0,$38000001,0,$38000001,0,$D8000001,$00000001,$A8000001,$00000001,$B0000001,$00000003,$50000001,$00000001,$E0000001,0,$80000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EFBE,$FBAFDFBC,$86FBEFFE,$FF6FBF78,$8B7DF7FF,$FF5F7EF0,$85DFFFFF,$FC7FFBE0,$806FFF80,$007FF780,$80B7C000,$0003EF00,$805E0000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$8000AAA0,$00088000,$80008000,$01508000,$80008000,$00010000,$80000080,$02AA0000,$8000AA80,0,$80008000,0,$80008000,0,$80000020,$08000000,$8002AAA0,$A8000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF40,$01FFFF81,$01FFC100,$01E3FF01,$00FE0000,$01E07C01,$00780000,$00C01001,$00100000,$01000001,0,$01000001,0,$02000001,0,$02000001,0,$04000001,0,$08000001,0,$1C000001,0,$38000001,0,$6C000001,0,$28000001,0,$D8000001,0,$50000001,0,$E0000001,0,$80000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EFBE,$FBEFDFBC,$86FBEFFE,$FFCFBF78,$8B7DF7FF,$FFDF7EF0,$85DFFFFF,$FF3FFBE0,$806FFF80,$001FF780,$80B7C000,$0003EF00,$805E0000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$8000AAA0,$00088000,$80008000,$01508000,$80008000,$00010000,$80000080,$02AA0000,$8000AA80,0,$80008000,0,$80008000,0,$80000020,0,$8002AAA0,$A8000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF40,$017FFF81,$01FFC100,$00F3FF01,$00FE0000,$00787C01,$00780000,$00601001,$00100000,$00800001,0,$00800001,0,$01000001,0,$01000001,0,$02000001,0,$04000001,0,$0E000001,0,$1C000001,0,$76000001,0,$54000001,0,$DC000001,0,$A8000001,0,$E0000001,0,$40000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EFBE,$FBEFDFBC,$86FBEFFE,$FFE7BF78,$8B7DF7FF,$FFCF7EF0,$85DFFFFF,$FFCFFBE0,$806FFF80,$000FF780,$80B7C000,$0003EF00,$805E0000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$8000AAA0,$00088000,$80008000,$01508000,$80008000,$00010000,$80000080,$00AA0000,$8000AA80,0,$80008000,$08000000,$80008000,$08000000,$80000020,0,$8002AAA0,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF40,$017FFF81,$01FFC100,$007FFF01,$00FE0000,$003C7C01,$00780000,$00301001,$00100000,$00200001,0,$00400001,0,$00800001,0,$00800001,0,$01000001,0,$02000001,0,$07000001,0,$0E000001,0,$37000001,0,$6A000001,0,$6C000001,0,$AC000001,0,$70000001,0,$40000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EFBE,$FBEFDFBC,$86FBEFFE,$FFEDBF78,$8B7DF7FF,$FFDB7EF0,$85DFFFFF,$FFE7FBE0,$806FFF80,$0083F780,$80B7C000,$0003EF00,$805E0000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$8000AAA0,$00088000,$80008000,$00508000,$80008000,$00010000,$80000080,$08AA0000,$8000AA80,0,$80008000,$08000000,$80008000,0,$80000020,0,$8002AAA0,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF40,$017FFF81,$01FFC100,$005FFF01,$00FE0000,$001F7C01,$00780000,$000C1001,$00100000,$00100001,0,$00200001,0,$00600001,0,$00400001,0,$00800001,0,$01000001,0,$07800001,0,$07000001,0,$1B000001,0,$2B000001,0,$66000001,0,$14000001,0,$70000001,0,$40000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EFBE,$FBEFDFBC,$86FBEFFE,$FFEF3F78,$8B7DF7FF,$FFDE7EF0,$85DFFFFF,$FFFDFBE0,$806FFF80,$00E1F780,$80B7C000,$0000EF00,$805E0000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$8000AAA0,$00088000,$80008000,$01508000,$80008000,$00010000,$80000080,$082A0000,$8000AA80,$08000000,$80008000,0,$80008000,0,$80000020,$08000000,$8002AAA0,$A8000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF40,$017FFF81,$01FFC100,$0047FF01,$00FE0000,$0007FC01,$00780000,$00061001,$00100000,$00080001,0,$00180001,0,$00100001,0,$00200001,0,$00400001,0,$00800001,0,$03800001,0,$07800001,0,$1D000001,0,$34000001,0,$34000001,0,$34000001,0,$30000001,0,$40000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EFBE,$FBEFDFBC,$86FBEFFE,$FFEFBF78,$8B7DF7FF,$FFDF3EF0,$85DFFFFF,$FFFF7BE0,$806FFF80,$00F87780,$80B7C000,$00006F00,$805E0000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00008000,$8000AAA0,$00088000,$80008000,$01108000,$80008000,$00010000,$80000080,$082A0000,$8000AA80,$08000000,$80008000,0,$80008000,$08000000,$80000020,$08000000,$8002AAA0,$88000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF40,$017FFF81,$01FFC100,$004FFF01,$00FE0000,$0007FC01,$00780000,$00071001,$00100000,$00040001,0,$00080001,0,$00100001,0,$00200001,0,$00400001,0,$00800001,0,$03800001,0,$1F000001,0,$1B000001,0,$38000001,0,$44000001,0,$70000001,0,$30000001,0,$40000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EFBE,$FBEFDFBC,$86FBEFFE,$FFEF9F78,$8B7DF7FF,$FFDF3EF0,$85DFFFFF,$FFFF7BE0,$806FFF80,$00F03780,$80B7C000,$00006F00,$805E0000,$00007E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00008000,$8000AAA0,$00088000,$80008000,$01108000,$80008000,$00010000,$80000080,$082A0000,$8000AA80,0,$80008000,0,$80008000,0,$80000020,$08000000,$8002AAA0,$88000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF40,$017FFF81,$01FFC100,$0043FF01,$00FE0000,$0003FC01,$00780000,$0003B001,$00100000,$00020001,0,$00040001,0,$00080001,0,$00100001,0,$00200001,0,$00400001,0,$01C00001,0,$0F800001,0,$1D800001,0,$3D000001,0,$66000001,0,$34000001,0,$30000001,0,$40000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EFBE,$FBEFDFBC,$86FBEFFE,$FFEFB778,$8B7DF7FF,$FFDF6EF0,$85DFFFFF,$FFFFDBE0,$806FFF80,$00FD1780,$80B7C000,$00000F00,$805E0000,$00005E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$8000AAA0,$00088000,$80008000,$01508000,$80008000,$00010000,$80000080,$0A2A0000,$8000AA80,0,$80008000,0,$80008000,0,$80000020,$08000000,$8002AAA0,$88000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF40,$017FFF81,$01FFC100,$0043FF01,$00FE0000,$0000FC01,$00780000,$0001F001,$00100000,$00010001,0,$00020001,0,$00040001,0,$00080001,0,$00100001,0,$00200001,0,$00E00001,0,$03C00001,0,$02C00001,0,$1A800001,0,$2E000001,0,$3C000001,0,$20000001,0,$40000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EFBE,$FBEFDFBC,$86FBEFFE,$FFEFBF78,$8B7DF7FF,$FFDF7AF0,$85DFFFFF,$FFFFF3E0,$806FFF80,$00FFC780,$80B7C000,$00030F00,$805E0000,$00000E00,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$8000AAA0,$00008000,$80008000,$01408000,$80008000,$00010000,$80000080,$0A0A0000,$8000AA80,$08000000,$80008000,$08000000,$80008000,0,$80000020,0,$8002AAA0,$80000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0,0,0,0,$00000001,$00002FFF,$FFE80001,$0007FFFF,$FFFFC001,$007FFFFF,$FFFFFC01,$03FFFFFF,$FFFFFF01,$0FFFFFFF,$FFFFFF81,$3FFFFFFF,$FFFFFFE1,$3FFFFFFF,$FFFFFFF1,$1FFFFFFF,$FFFFFFE1,$0FFFFFFF,$FFFFFFC1,$07FFFF40,$017FFF81,$01FFC100,$0043FF01,$00FE0000,$00007C01,$00780000,$00007801,$00100000,$00004001,0,$00008001,0,$00020001,0,$00040001,0,$00080001,0,$00100001,0,$00F00001,0,$03E00001,0,$04C00001,0,$0C800001,0,$17000001,0,$3E000001,0,$20000001,0,$40000001,$00000001,$80000001,0,$00000001,$7FFFFFFF,-1,-1,-1,$80000000,0,$80002425,$42A80000,$80063FFF,$FFF8C000,$8067FFFE,$FFFFC400,$823FBFFE,$FFFBFF00,$89FFDF7E,$FDF7FFE0,$A7FFDFBE,$FBF7FFF8,$8DF7EFBE,$FBEFDFBC,$86FBEFFE,$FFEFBF78,$8B7DF7FF,$FFDF7EF0,$85DFFFFF,$FFFFF9E0,$806FFF80,$00FFE780,$80B7C000,$00038700,$805E0000,$00000600,$80080000,$00001800,$80000020,$00010000,$80000020,$00108000,$8000AAA0,$00088000,$80008000,$01508000,$80008000,$00010000,$80000080,$0A0A0000,$8000AA80,$08000000,$80008000,$08000000,$80008000,0,$80000020,$08000000,$8002AAA0,$80000000,$80000000,0,$80000000,0,$80000000,0,$80000000,0,$80000000,0
Daten2:
	DC.L	0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000000,$303,$61F80000,$80000FC3,$60000108,$88400303,$60008880,$888003,$60004000,$10003,$60020000,$2003,$60700000,$403,$600F0000,$803,$6000F800,$3,$600007C0,$3,$6000003C,$DB63,$60000003,$8000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$71FFFFFF,$FFFFFFFD,$71FFFFFF,$FFFFFFFD,$71FFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFCFC,$9E07FFFF,$7FFFF03C,$9FFFFEF7,$77BFFCFC,$9FFF777F,$FF777FFC,$9FFFBFFF,$FFFEFFFC,$9FFDFFFF,$FFFFDFFC,$9F8FFFFF,$FFFFFBFC,$9FF0FFFF,$FFFFF7FC,$9FFF07FF,$FFFFFFFC,$9FFFF83F,$FFFFFFFC,$9FFFFFC3,$FFFF249C,$9FFFFFFC,$7FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8E000000,$2,$8E000000,$2,$8E000000,$2,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000000,$303,$61F80000,$80000FC3,$60000108,$88400303,$60008880,$888003,$60004000,$10003,$60320000,$2003,$601F0000,$403,$6008F000,$803,$60000E00,$3,$600001E0,$3,$6000001E,$DB63,$60000001,$8000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$707FFFFF,$FFFFFFFD,$707FFFFF,$FFFFFFFD,$707FFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFCFC,$9E07FFFF,$7FFFF03C,$9FFFFEF7,$77BFFCFC,$9FFF777F,$FF777FFC,$9FFFBFFF,$FFFEFFFC,$9FCDFFFF,$FFFFDFFC,$9FE0FFFF,$FFFFFBFC,$9FF70FFF,$FFFFF7FC,$9FFFF1FF,$FFFFFFFC,$9FFFFE1F,$FFFFFFFC,$9FFFFFE1,$FFFF249C,$9FFFFFFE,$7FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8F800000,$2,$8F800000,$2,$8F800000,$2,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000000,$303,$61F80000,$80000FC3,$60000108,$88400303,$60008880,$888003,$600C4000,$10003,$60038000,$2003,$60107000,$403,$60080E00,$803,$600001C0,$3,$60000038,$3,$60000006,$DB63,$60000001,$8000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$700FFFFF,$FFFFFFFD,$700FFFFF,$FFFFFFFD,$700FFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFCFC,$9E07FFFF,$7FFFF03C,$9FFFFEF7,$77BFFCFC,$9FFF777F,$FF777FFC,$9FF3BFFF,$FFFEFFFC,$9FFC7FFF,$FFFFDFFC,$9FEF8FFF,$FFFFFBFC,$9FF7F1FF,$FFFFF7FC,$9FFFFE3F,$FFFFFFFC,$9FFFFFC7,$FFFFFFFC,$9FFFFFF9,$FFFF249C,$9FFFFFFE,$7FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FF00000,$2,$8FF00000,$2,$8FF00000,$2,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000000,$303,$61F80000,$80000FC3,$60000108,$88400303,$60038880,$888003,$6000C000,$10003,$60023000,$2003,$60100C00,$403,$60080380,$803,$60000060,$3,$60000018,$3,$60000006,$DB63,$60000001,$8000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7007FFFF,$FFFFFFFD,$7007FFFF,$FFFFFFFD,$7007FFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFCFC,$9E07FFFF,$7FFFF03C,$9FFFFEF7,$77BFFCFC,$9FFC777F,$FF777FFC,$9FFF3FFF,$FFFEFFFC,$9FFDCFFF,$FFFFDFFC,$9FEFF3FF,$FFFFFBFC,$9FF7FC7F,$FFFFF7FC,$9FFFFF9F,$FFFFFFFC,$9FFFFFE7,$FFFFFFFC,$9FFFFFF9,$FFFF249C,$9FFFFFFE,$7FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FF80000,$2,$8FF80000,$2,$8FF80000,$2,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000000,$303,$61F80000,$80000FC3,$60008108,$88400303,$6000E880,$888003,$60005800,$10003,$60020600,$2003,$60100180,$403,$60080040,$803,$60000030,$3,$6000000C,$3,$60000003,$DB63,$60000000,$8000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7001FFFF,$FFFFFFFD,$7001FFFF,$FFFFFFFD,$7001FFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFCFC,$9E07FFFF,$7FFFF03C,$9FFF7EF7,$77BFFCFC,$9FFF177F,$FF777FFC,$9FFFA7FF,$FFFEFFFC,$9FFDF9FF,$FFFFDFFC,$9FEFFE7F,$FFFFFBFC,$9FF7FFBF,$FFFFF7FC,$9FFFFFCF,$FFFFFFFC,$9FFFFFF3,$FFFFFFFC,$9FFFFFFC,$FFFF249C,$9FFFFFFF,$7FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFE0000,$2,$8FFE0000,$2,$8FFE0000,$2,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000000,$303,$61F82000,$80000FC3,$60001908,$88400303,$60008C80,$888003,$60004200,$10003,$60020180,$2003,$60100040,$403,$60080030,$803,$60000008,$3,$60000004,$3,$60000003,$DB63,$60000000,$8000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7000FFFF,$FFFFFFFD,$7000FFFF,$FFFFFFFD,$7000FFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFCFC,$9E07DFFF,$7FFFF03C,$9FFFE6F7,$77BFFCFC,$9FFF737F,$FF777FFC,$9FFFBDFF,$FFFEFFFC,$9FFDFE7F,$FFFFDFFC,$9FEFFFBF,$FFFFFBFC,$9FF7FFCF,$FFFFF7FC,$9FFFFFF7,$FFFFFFFC,$9FFFFFFB,$FFFFFFFC,$9FFFFFFC,$FFFF249C,$9FFFFFFF,$7FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFF0000,$2,$8FFF0000,$2,$8FFF0000,$2,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000000,$303,$61F81000,$80000FC3,$60000908,$88400303,$60008E80,$888003,$60004100,$10003,$60020080,$2003,$60100060,$403,$60080010,$803,$60000008,$3,$60000006,$3,$60000001,$DB63,$60000000,$8000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$70003FFF,$FFFFFFFD,$70003FFF,$FFFFFFFD,$70003FFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFCFC,$9E07EFFF,$7FFFF03C,$9FFFF6F7,$77BFFCFC,$9FFF717F,$FF777FFC,$9FFFBEFF,$FFFEFFFC,$9FFDFF7F,$FFFFDFFC,$9FEFFF9F,$FFFFFBFC,$9FF7FFEF,$FFFFF7FC,$9FFFFFF7,$FFFFFFFC,$9FFFFFF9,$FFFFFFFC,$9FFFFFFE,$FFFF249C,$9FFFFFFF,$7FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFFC000,$2,$8FFFC000,$2,$8FFFC000,$2,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000000,$303,$61F80800,$80000FC3,$60000508,$88400303,$60008B80,$888003,$60004080,$10003,$60020040,$2003,$60100020,$403,$60080010,$803,$6000000C,$3,$60000002,$3,$60000001,$DB63,$60000000,$8000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$70001FFF,$FFFFFFFD,$70001FFF,$FFFFFFFD,$70001FFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFCFC,$9E07F7FF,$7FFFF03C,$9FFFFAF7,$77BFFCFC,$9FFF747F,$FF777FFC,$9FFFBF7F,$FFFEFFFC,$9FFDFFBF,$FFFFDFFC,$9FEFFFDF,$FFFFFBFC,$9FF7FFEF,$FFFFF7FC,$9FFFFFF3,$FFFFFFFC,$9FFFFFFD,$FFFFFFFC,$9FFFFFFE,$FFFF249C,$9FFFFFFF,$7FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFFE000,$2,$8FFFE000,$2,$8FFFE000,$2,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000400,$303,$61F80200,$80000FC3,$60000108,$88400303,$60008880,$888003,$60004040,$10003,$60020020,$2003,$60100010,$403,$60080008,$803,$60000004,$3,$60000002,$3,$60000001,$DB63,$60000000,$8000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$700007FF,$FFFFFFFD,$700007FF,$FFFFFFFD,$700007FF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFBFF,$FFFFFCFC,$9E07FDFF,$7FFFF03C,$9FFFFEF7,$77BFFCFC,$9FFF777F,$FF777FFC,$9FFFBFBF,$FFFEFFFC,$9FFDFFDF,$FFFFDFFC,$9FEFFFEF,$FFFFFBFC,$9FF7FFF7,$FFFFF7FC,$9FFFFFFB,$FFFFFFFC,$9FFFFFFD,$FFFFFFFC,$9FFFFFFE,$FFFF249C,$9FFFFFFF,$7FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFFF800,$2,$8FFFF800,$2,$8FFFF800,$2,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000100,$303,$61F80080,$80000FC3,$60000148,$88400303,$600088C0,$888003,$60004020,$10003,$60020010,$2003,$60100008,$403,$60080004,$803,$60000002,$3,$60000002,$3,$60000001,$DB63,$60000000,$8000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$700003FF,$FFFFFFFD,$700003FF,$FFFFFFFD,$700003FF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFEFF,$FFFFFCFC,$9E07FF7F,$7FFFF03C,$9FFFFEB7,$77BFFCFC,$9FFF773F,$FF777FFC,$9FFFBFDF,$FFFEFFFC,$9FFDFFEF,$FFFFDFFC,$9FEFFFF7,$FFFFFBFC,$9FF7FFFB,$FFFFF7FC,$9FFFFFFD,$FFFFFFFC,$9FFFFFFD,$FFFFFFFC,$9FFFFFFE,$FFFF249C,$9FFFFFFF,$7FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFFFC00,$2,$8FFFFC00,$2,$8FFFFC00,$2,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000040,$303,$61F80020,$80000FC3,$60000128,$88400303,$60008890,$888003,$60004008,$10003,$60020008,$2003,$60100004,$403,$60080004,$803,$60000002,$3,$60000001,$3,$60000001,$DB63,$60000000,$8000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$700000FF,$FFFFFFFD,$700000FF,$FFFFFFFD,$700000FF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFBF,$FFFFFCFC,$9E07FFDF,$7FFFF03C,$9FFFFED7,$77BFFCFC,$9FFF776F,$FF777FFC,$9FFFBFF7,$FFFEFFFC,$9FFDFFF7,$FFFFDFFC,$9FEFFFFB,$FFFFFBFC,$9FF7FFFB,$FFFFF7FC,$9FFFFFFD,$FFFFFFFC,$9FFFFFFE,$FFFFFFFC,$9FFFFFFE,$FFFF249C,$9FFFFFFF,$7FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFFFF00,$2,$8FFFFF00,$2,$8FFFFF00,$2,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000010,$303,$61F80010,$80000FC3,$60000108,$88400303,$60008888,$888003,$60004004,$10003,$60020004,$2003,$60100002,$403,$60080002,$803,$60000001,$3,$60000001,$3,$60000000,$8000DB63,$60000000,$8000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7000007F,$FFFFFFFD,$7000007F,$FFFFFFFD,$7000007F,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFEF,$FFFFFCFC,$9E07FFEF,$7FFFF03C,$9FFFFEF7,$77BFFCFC,$9FFF7777,$FF777FFC,$9FFFBFFB,$FFFEFFFC,$9FFDFFFB,$FFFFDFFC,$9FEFFFFD,$FFFFFBFC,$9FF7FFFD,$FFFFF7FC,$9FFFFFFE,$FFFFFFFC,$9FFFFFFE,$FFFFFFFC,$9FFFFFFF,$7FFF249C,$9FFFFFFF,$7FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFFFF80,$2,$8FFFFF80,$2,$8FFFFF80,$2,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000008,$303,$61F80008,$80000FC3,$6000010C,$88400303,$60008884,$888003,$60004004,$10003,$60020002,$2003,$60100002,$403,$60080001,$803,$60000001,$3,$60000001,$3,$60000000,$8000DB63,$60000000,$8000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7000001F,$FFFFFFFD,$7000001F,$FFFFFFFD,$7000001F,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFF7,$FFFFFCFC,$9E07FFF7,$7FFFF03C,$9FFFFEF3,$77BFFCFC,$9FFF777B,$FF777FFC,$9FFFBFFB,$FFFEFFFC,$9FFDFFFD,$FFFFDFFC,$9FEFFFFD,$FFFFFBFC,$9FF7FFFE,$FFFFF7FC,$9FFFFFFE,$FFFFFFFC,$9FFFFFFE,$FFFFFFFC,$9FFFFFFF,$7FFF249C,$9FFFFFFF,$7FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFFFFE0,$2,$8FFFFFE0,$2,$8FFFFFE0,$2,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000004,$303,$61F80004,$80000FC3,$6000010A,$88400303,$60008882,$888003,$60004002,$10003,$60020002,$2003,$60100001,$403,$60080001,$803,$60000001,$3,$60000001,$3,$60000000,$8000DB63,$60000000,$8000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7000002F,$FFFFFFFD,$7000000F,$FFFFFFFD,$7000002F,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFFB,$FFFFFCFC,$9E07FFFB,$7FFFF03C,$9FFFFEF5,$77BFFCFC,$9FFF777D,$FF777FFC,$9FFFBFFD,$FFFEFFFC,$9FFDFFFD,$FFFFDFFC,$9FEFFFFE,$FFFFFBFC,$9FF7FFFE,$FFFFF7FC,$9FFFFFFE,$FFFFFFFC,$9FFFFFFE,$FFFFFFFC,$9FFFFFFF,$7FFF249C,$9FFFFFFF,$7FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFFFFF0,$2,$8FFFFFF0,$2,$8FFFFFF0,$2,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000000,$80000303,$61F80000,$80000FC3,$60000108,$88400303,$60008880,$80888003,$60004000,$80010003,$60020000,$80002003,$60100000,$80000403,$60080000,$80000803,$60000000,$80000003,$60000000,$80000003,$60000000,$8000DB63,$60000000,$8000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7000002B,$FFFFFFFD,$70000013,$FFFFFFFD,$7000002B,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$7FFFFCFC,$9E07FFFF,$7FFFF03C,$9FFFFEF7,$77BFFCFC,$9FFF777F,$7F777FFC,$9FFFBFFF,$7FFEFFFC,$9FFDFFFF,$7FFFDFFC,$9FEFFFFF,$7FFFFBFC,$9FF7FFFF,$7FFFF7FC,$9FFFFFFF,$7FFFFFFC,$9FFFFFFF,$7FFFFFFC,$9FFFFFFF,$7FFF249C,$9FFFFFFF,$7FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFFFFFC,$2,$8FFFFFFC,$2,$8FFFFFFC,$2,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000000,$20000303,$61F80000,$A0000FC3,$60000108,$A8400303,$60008880,$40888003,$60004000,$40010003,$60020000,$40002003,$60100000,$40000403,$60080000,$40000803,$60000000,$40000003,$60000000,$80000003,$60000000,$8000DB63,$60000000,$8000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$70000029,$FFFFFFFD,$70000015,$FFFFFFFD,$70000029,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$DFFFFCFC,$9E07FFFF,$5FFFF03C,$9FFFFEF7,$57BFFCFC,$9FFF777F,$BF777FFC,$9FFFBFFF,$BFFEFFFC,$9FFDFFFF,$BFFFDFFC,$9FEFFFFF,$BFFFFBFC,$9FF7FFFF,$BFFFF7FC,$9FFFFFFF,$BFFFFFFC,$9FFFFFFF,$7FFFFFFC,$9FFFFFFF,$7FFF249C,$9FFFFFFF,$7FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFFFFFE,$2,$8FFFFFFE,$2,$8FFFFFFE,$2,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000000,$10000303,$61F80000,$90000FC3,$60000108,$98400303,$60008880,$20888003,$60004000,$20010003,$60020000,$20002003,$60100000,$20000403,$60080000,$40000803,$60000000,$40000003,$60000000,$40000003,$60000000,$4000DB63,$60000000,$8000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7000002A,$7FFFFFFD,$70000015,$7FFFFFFD,$7000002A,$7FFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$EFFFFCFC,$9E07FFFF,$6FFFF03C,$9FFFFEF7,$67BFFCFC,$9FFF777F,$DF777FFC,$9FFFBFFF,$DFFEFFFC,$9FFDFFFF,$DFFFDFFC,$9FEFFFFF,$DFFFFBFC,$9FF7FFFF,$BFFFF7FC,$9FFFFFFF,$BFFFFFFC,$9FFFFFFF,$BFFFFFFC,$9FFFFFFF,$BFFF249C,$9FFFFFFF,$7FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFFFFFF,$80000002,$8FFFFFFF,$80000002,$8FFFFFFF,$80000002,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000000,$8000303,$61F80000,$88000FC3,$60000108,$98400303,$60008880,$10888003,$60004000,$10010003,$60020000,$20002003,$60100000,$20000403,$60080000,$20000803,$60000000,$40000003,$60000000,$40000003,$60000000,$4000DB63,$60000000,$8000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7000002A,$BFFFFFFD,$70000015,$3FFFFFFD,$7000002A,$BFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$F7FFFCFC,$9E07FFFF,$77FFF03C,$9FFFFEF7,$67BFFCFC,$9FFF777F,$EF777FFC,$9FFFBFFF,$EFFEFFFC,$9FFDFFFF,$DFFFDFFC,$9FEFFFFF,$DFFFFBFC,$9FF7FFFF,$DFFFF7FC,$9FFFFFFF,$BFFFFFFC,$9FFFFFFF,$BFFFFFFC,$9FFFFFFF,$BFFF249C,$9FFFFFFF,$7FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFFFFFF,$C0000002,$8FFFFFFF,$C0000002,$8FFFFFFF,$C0000002,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000000,$4000303,$61F80000,$84000FC3,$60000108,$88400303,$60008880,$8888003,$60004000,$10010003,$60020000,$10002003,$60100000,$10000403,$60080000,$20000803,$60000000,$20000003,$60000000,$40000003,$60000000,$4000DB63,$60000000,$8000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7000002A,$AFFFFFFD,$70000015,$4FFFFFFD,$7000002A,$AFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FBFFFCFC,$9E07FFFF,$7BFFF03C,$9FFFFEF7,$77BFFCFC,$9FFF777F,$F7777FFC,$9FFFBFFF,$EFFEFFFC,$9FFDFFFF,$EFFFDFFC,$9FEFFFFF,$EFFFFBFC,$9FF7FFFF,$DFFFF7FC,$9FFFFFFF,$DFFFFFFC,$9FFFFFFF,$BFFFFFFC,$9FFFFFFF,$BFFF249C,$9FFFFFFF,$7FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFFFFFF,$F0000002,$8FFFFFFF,$F0000002,$8FFFFFFF,$F0000002,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000000,$2000303,$61F80000,$82000FC3,$60000108,$8C400303,$60008880,$4888003,$60004000,$8010003,$60020000,$8002003,$60100000,$10000403,$60080000,$10000803,$60000000,$20000003,$60000000,$20000003,$60000000,$4000DB63,$60000000,$C000DB63,$60000000,$80007363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7000002A,$ABFFFFFD,$70000015,$53FFFFFD,$7000002A,$ABFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FDFFFCFC,$9E07FFFF,$7DFFF03C,$9FFFFEF7,$73BFFCFC,$9FFF777F,$FB777FFC,$9FFFBFFF,$F7FEFFFC,$9FFDFFFF,$F7FFDFFC,$9FEFFFFF,$EFFFFBFC,$9FF7FFFF,$EFFFF7FC,$9FFFFFFF,$DFFFFFFC,$9FFFFFFF,$DFFFFFFC,$9FFFFFFF,$BFFF249C,$9FFFFFFF,$3FFF249C,$9FFFFFFF,$7FFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFFFFFF,$FC000002,$8FFFFFFF,$FC000002,$8FFFFFFF,$FC000002,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000000,$303,$61F80000,$80800FC3,$60000108,$89400303,$60008880,$1888003,$60004000,$2010003,$60020000,$4002003,$60100000,$8000403,$60080000,$8000803,$60000000,$10000003,$60000000,$20000003,$60000000,$4000DB63,$60000000,$C000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7000002A,$A9FFFFFD,$70000015,$55FFFFFD,$7000002A,$A9FFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFCFC,$9E07FFFF,$7F7FF03C,$9FFFFEF7,$76BFFCFC,$9FFF777F,$FE777FFC,$9FFFBFFF,$FDFEFFFC,$9FFDFFFF,$FBFFDFFC,$9FEFFFFF,$F7FFFBFC,$9FF7FFFF,$F7FFF7FC,$9FFFFFFF,$EFFFFFFC,$9FFFFFFF,$DFFFFFFC,$9FFFFFFF,$BFFF249C,$9FFFFFFF,$3FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFFFFFF,$FE000002,$8FFFFFFF,$FE000002,$8FFFFFFF,$FE000002,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000000,$303,$61F80000,$80200FC3,$60000108,$88400303,$60008880,$888003,$60004000,$1010003,$60020000,$2002003,$60100000,$4000403,$60080000,$4000803,$60000000,$8000003,$60000000,$10000003,$60000000,$2000DB63,$60000000,$C000DB63,$60000000,$80007363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7000002A,$AAFFFFFD,$70000015,$55FFFFFD,$7000002A,$AAFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFCFC,$9E07FFFF,$7FDFF03C,$9FFFFEF7,$77BFFCFC,$9FFF777F,$FF777FFC,$9FFFBFFF,$FEFEFFFC,$9FFDFFFF,$FDFFDFFC,$9FEFFFFF,$FBFFFBFC,$9FF7FFFF,$FBFFF7FC,$9FFFFFFF,$F7FFFFFC,$9FFFFFFF,$EFFFFFFC,$9FFFFFFF,$DFFF249C,$9FFFFFFF,$3FFF249C,$9FFFFFFF,$7FFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFFFFFF,$FF800002,$8FFFFFFF,$FF800002,$8FFFFFFF,$FF800002,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000000,$303,$61F80000,$80080FC3,$60000108,$88500303,$60008880,$A88003,$60004000,$410003,$60020000,$802003,$60100000,$3000403,$60080000,$4000803,$60000000,$8000003,$60000000,$10000003,$60000000,$2000DB63,$60000000,$C000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7000002A,$AAFFFFFD,$70000015,$55FFFFFD,$7000002A,$AAFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFCFC,$9E07FFFF,$7FF7F03C,$9FFFFEF7,$77AFFCFC,$9FFF777F,$FF577FFC,$9FFFBFFF,$FFBEFFFC,$9FFDFFFF,$FF7FDFFC,$9FEFFFFF,$FCFFFBFC,$9FF7FFFF,$FBFFF7FC,$9FFFFFFF,$F7FFFFFC,$9FFFFFFF,$EFFFFFFC,$9FFFFFFF,$DFFF249C,$9FFFFFFF,$3FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFFFFFF,$FFE00002,$8FFFFFFF,$FFE00002,$8FFFFFFF,$FFE00002,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000000,$303,$61F80000,$80020FC3,$60000108,$88440303,$60008880,$988003,$60004000,$210003,$60020000,$402003,$60100000,$1800403,$60080000,$2000803,$60000000,$4000003,$60000000,$8000003,$60000000,$3000DB63,$60000000,$C000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7000002A,$AAFFFFFD,$70000015,$55FFFFFD,$7000002A,$AAFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFCFC,$9E07FFFF,$7FFDF03C,$9FFFFEF7,$77BBFCFC,$9FFF777F,$FF677FFC,$9FFFBFFF,$FFDEFFFC,$9FFDFFFF,$FFBFDFFC,$9FEFFFFF,$FE7FFBFC,$9FF7FFFF,$FDFFF7FC,$9FFFFFFF,$FBFFFFFC,$9FFFFFFF,$F7FFFFFC,$9FFFFFFF,$CFFF249C,$9FFFFFFF,$3FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFFFFFF,$FFF00002,$8FFFFFFF,$FFF00002,$8FFFFFFF,$FFF00002,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000000,$303,$61F80000,$80000FC3,$60000108,$88410303,$60008880,$8E8003,$60004000,$90003,$60020000,$302003,$60100000,$400403,$60080000,$1800803,$60000000,$2000003,$60000000,$C000003,$60000000,$1000DB63,$60000000,$E000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7000002A,$AAFFFFFD,$70000015,$55FFFFFD,$7000002A,$AAFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFCFC,$9E07FFFF,$7FFFF03C,$9FFFFEF7,$77BEFCFC,$9FFF777F,$FF717FFC,$9FFFBFFF,$FFF6FFFC,$9FFDFFFF,$FFCFDFFC,$9FEFFFFF,$FFBFFBFC,$9FF7FFFF,$FE7FF7FC,$9FFFFFFF,$FDFFFFFC,$9FFFFFFF,$F3FFFFFC,$9FFFFFFF,$EFFF249C,$9FFFFFFF,$1FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFFFFFF,$FFFC0002,$8FFFFFFF,$FFFC0002,$8FFFFFFF,$FFFC0002,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000000,$303,$61F80000,$80000FC3,$60000108,$88408303,$60008880,$8B8003,$60004000,$D0003,$60020000,$102003,$60100000,$600403,$60080000,$800803,$60000000,$3000003,$60000000,$C000003,$60000000,$1000DB63,$60000000,$E000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7000002A,$AAFFFFFD,$70000015,$55FFFFFD,$7000002A,$AAFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFCFC,$9E07FFFF,$7FFFF03C,$9FFFFEF7,$77BF7CFC,$9FFF777F,$FF747FFC,$9FFFBFFF,$FFF2FFFC,$9FFDFFFF,$FFEFDFFC,$9FEFFFFF,$FF9FFBFC,$9FF7FFFF,$FF7FF7FC,$9FFFFFFF,$FCFFFFFC,$9FFFFFFF,$F3FFFFFC,$9FFFFFFF,$EFFF249C,$9FFFFFFF,$1FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFFFFFF,$FFFE0002,$8FFFFFFF,$FFFE0002,$8FFFFFFF,$FFFE0002,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000000,$303,$61F80000,$80000FC3,$60000108,$88400303,$60008880,$88E003,$60004000,$18003,$60020000,$62003,$60100000,$180403,$60080000,$600803,$60000000,$1800003,$60000000,$6000003,$60000000,$1800DB63,$60000000,$E000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7000002A,$AAFFFFFD,$70000015,$55FFFFFD,$7000002A,$AAFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFCFC,$9E07FFFF,$7FFFF03C,$9FFFFEF7,$77BFFCFC,$9FFF777F,$FF771FFC,$9FFFBFFF,$FFFE7FFC,$9FFDFFFF,$FFF9DFFC,$9FEFFFFF,$FFE7FBFC,$9FF7FFFF,$FF9FF7FC,$9FFFFFFF,$FE7FFFFC,$9FFFFFFF,$F9FFFFFC,$9FFFFFFF,$E7FF249C,$9FFFFFFF,$1FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFFFFFF,$FFFF8002,$8FFFFFFF,$FFFF8002,$8FFFFFFF,$FFFF8002,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000000,$303,$61F80000,$80000FC3,$60000108,$88400303,$60008880,$889803,$60004000,$16003,$60020000,$3A003,$60100000,$C0403,$60080000,$700803,$60000000,$1800003,$60000000,$E000003,$60000000,$3000DB63,$60000000,$C000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7000002A,$AAFFFFFD,$70000015,$55FFFFFD,$7000002A,$AAFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFCFC,$9E07FFFF,$7FFFF03C,$9FFFFEF7,$77BFFCFC,$9FFF777F,$FF7767FC,$9FFFBFFF,$FFFE9FFC,$9FFDFFFF,$FFFC5FFC,$9FEFFFFF,$FFF3FBFC,$9FF7FFFF,$FF8FF7FC,$9FFFFFFF,$FE7FFFFC,$9FFFFFFF,$F1FFFFFC,$9FFFFFFF,$CFFF249C,$9FFFFFFF,$3FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFFFFFF,$FFFFC002,$8FFFFFFF,$FFFFC002,$8FFFFFFF,$FFFFC002,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000000,$303,$61F80000,$80000FC3,$60000108,$88400303,$60008880,$888003,$60004000,$10C03,$60020000,$7003,$60100000,$38403,$60080000,$1C0803,$60000000,$E00003,$60000000,$7000003,$60000000,$3800DB63,$60000000,$C000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7000002A,$AAFFFFFD,$70000015,$55FFFFFD,$7000002A,$AAFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFCFC,$9E07FFFF,$7FFFF03C,$9FFFFEF7,$77BFFCFC,$9FFF777F,$FF777FFC,$9FFFBFFF,$FFFEF3FC,$9FFDFFFF,$FFFF8FFC,$9FEFFFFF,$FFFC7BFC,$9FF7FFFF,$FFE3F7FC,$9FFFFFFF,$FF1FFFFC,$9FFFFFFF,$F8FFFFFC,$9FFFFFFF,$C7FF249C,$9FFFFFFF,$3FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFFFFFF,$FFFFF002,$8FFFFFFF,$FFFFF002,$8FFFFFFF,$FFFFF002,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000000,$303,$61F80000,$80000FC3,$60000108,$88400303,$60008880,$888003,$60004000,$10003,$60020000,$3C03,$60100000,$1C403,$60080000,$E0803,$60000000,$700003,$60000000,$7800003,$60000000,$3800DB63,$60000000,$C000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7000002A,$AAFFFFFD,$70000015,$55FFFFFD,$7000002A,$AAFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFCFC,$9E07FFFF,$7FFFF03C,$9FFFFEF7,$77BFFCFC,$9FFF777F,$FF777FFC,$9FFFBFFF,$FFFEFFFC,$9FFDFFFF,$FFFFC3FC,$9FEFFFFF,$FFFE3BFC,$9FF7FFFF,$FFF1F7FC,$9FFFFFFF,$FF8FFFFC,$9FFFFFFF,$F87FFFFC,$9FFFFFFF,$C7FF249C,$9FFFFFFF,$3FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFFFFFF,$FFFFFC02,$8FFFFFFF,$FFFFFC02,$8FFFFFFF,$FFFFFC02,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000000,$303,$61F80000,$80000FC3,$60000108,$88400303,$60008880,$888003,$60004000,$10003,$60020000,$2603,$60100000,$7C03,$60080000,$78803,$60000000,$380003,$60000000,$3C00003,$60000000,$3C00DB63,$60000000,$C000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7000002A,$AAFFFFFD,$70000015,$55FFFFFD,$7000002A,$AAFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFCFC,$9E07FFFF,$7FFFF03C,$9FFFFEF7,$77BFFCFC,$9FFF777F,$FF777FFC,$9FFFBFFF,$FFFEFFFC,$9FFDFFFF,$FFFFD9FC,$9FEFFFFF,$FFFF83FC,$9FF7FFFF,$FFF877FC,$9FFFFFFF,$FFC7FFFC,$9FFFFFFF,$FC3FFFFC,$9FFFFFFF,$C3FF249C,$9FFFFFFF,$3FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFFFFFF,$FFFFFF02,$8FFFFFFF,$FFFFFF02,$8FFFFFFF,$FFFFFF02,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0,0,0,$7FFFFFFF,-1,$60000000,$3,$60000000,$3,$60000000,$303,$61F80000,$80000FC3,$60000108,$88400303,$60008880,$888003,$60004000,$10003,$60020000,$2003,$60100000,$703,$60080000,$7803,$60000000,$F8003,$60000000,$1F00003,$60000000,$1E00DB63,$60000000,$E000DB63,$60000000,$7363,$60000000,$23E3,$60000000,$3,$7FFFFFFF,-1,0,$1,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7000002A,$AAFFFFFD,$70000015,$55FFFFFD,$7000002A,$AAFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$7FFFFFFF,$FFFFFFFD,$40000000,$1,$7FFFFFFF,-1,-1,-1,$80000000,0,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFFFC,$9FFFFFFF,$FFFFFCFC,$9E07FFFF,$7FFFF03C,$9FFFFEF7,$77BFFCFC,$9FFF777F,$FF777FFC,$9FFFBFFF,$FFFEFFFC,$9FFDFFFF,$FFFFDFFC,$9FEFFFFF,$FFFFF8FC,$9FF7FFFF,$FFFF87FC,$9FFFFFFF,$FFF07FFC,$9FFFFFFF,$FE0FFFFC,$9FFFFFFF,$E1FF249C,$9FFFFFFF,$1FFF249C,$9FFFFFFF,$FFFF8C9C,$9FFFFFFF,$FFFFDC1C,$9FFFFFFF,$FFFFFFFC,$80000000,0,-1,-2,$80000000,$2,$80000000,$2,$80000000,$2,$8FFFFFFF,$FFFFFFE2,$8FFFFFFF,$FFFFFFE2,$8FFFFFFF,$FFFFFFE2,$80000000,$2,$80000000,$2,$80000000,$2,$BFFFFFFF,-2,$80000000,0
