*****************************************************************************
**                                                                         **
** Engine: FFT-Analyzer                                                    **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 

;---------------------------------------------------------------------------------------------------
;---------------------         FFT Spektrum Analyzer fr Eagleplayer 2.0+        -------------------
;---------------------                   1996 Henryk Richter                    -------------------
;---------------------------------------------------------------------------------------------------
;kleine Optimierungen in der FFT Routine zwecks SpeedGewinn
;FFT_2 Routine durch neue (aus EMPYGui) ersetzt, c.a. 3-4% schneller bei normaler Fenstergre
;
ver		macro
		dc.b	"0.82"
		endm
StructVer	macro
		dc.w	0,82
		endm
date		macro
		dc.b	"05-Jul-98"
		endm
StructDate	macro
		dc.b	05,07
		dc.w	1998
		endm
;
;---------------------------- Globale Settings ---------------------------------------------------
Eagleplayer	equ		1		;Achtung ! falls 0 wird fr Beispieleingangswerte
						;die FPU benutzt, Programm lt sich ohne
						;Eagleplayer testen


debug		equ		0		;interessiert nur bei gesetztem "Eagleplayer"-Flag

UseCyber	equ		0		;WritePixelArray von CGFX benutzen (1)
						;oder nicht (0) = fast 2 mal schneller
						; mit WPA8/gfx als mit WPA/cgfx bei CGFX < 2.24

;---------------------------- FFT-,Mix- und Auswertungsroutinen ----------------------------------

Gamma	=	8		;N = 2^Gamma (Gamma > 2 wegen Extrabehandlungsroutinen)
N	=	2^Gamma		;Achtung: bei nderung von N in Power-Spectrum Routine entsprechend
				;         die LSR Befehle ndern, bei Werten >256 fr N die
				;         FFT Routine auf Longint umbauen, entsprechend
				;         auch die Mixroutine auf Longint-Ausgangswerte

Gamma_2	=	9		;analog zu Gamma (aber Gamma_2 > 3 durch extra LW-Routine)
N_2	=	2^Gamma_2	;analog zu N

Extra_Resolution = 4		;16 fach hhere Auflsung der Signale (statt bis 64 -> bis 1024)
Sinbase =	8		;auf 256 bezogen (statt -1..0..1) wegen Integer-rechnung

HalveSpectrum	=	1	;Nur die Hlfte des Spektrums ermitteln, da die neg. Frequenzen
				;fr die Auswertung des Analyzers unerheblich sind

correct		=	1	;Amplitudenkorrektur ein = 1 oder aus

	;eine von diesen dreien muss auf Flag "1" gesetzt sein
Linear		=	0	;Lineare Auswertung (X mal Ymax)
Log_y_X		=	0	;Ymax * (ln X / ln Xmax)
LogSpecial	=	1	;        ln (1 + (X*Basis-1)/Xmax)
				;Ymax * ---------------------------   (=Anzeige in dB)
				;               ln Basis
Amptabentries	=	64*2^[Extra_Resolution+2]
;---------------------------- Window Layout und Darstellungen -----------------------------------
RandAbstandH	=	4	;4 Pixel vom linken u. rechten Rand zu Boxen
RandAbstandV	=	4	;6 Pixel vom oberen u. unteren Rand zu Boxen
ZwischenRaum	=	0	;0 Pixel zwischen den Bevelboxen
BoxInnenAbstandH =	3	;3 Pixel zwischen Bevelbox und Anzeige
BoxInnenAbstandV =	2	;2 Pixel zwischen Bevelbox und Anzeige

MinInnerHeight	=	40	;jeweils ohne Gadgets
MinInnerWidth	=	100	;

DownSpeed	=	3
TimeOut		=	60

FreqBarExtra	=	6	;Anzeige der Frequenzen, Platz fr Bevelbox
Freq_Chars	=	2	;1k 2k usw.

;-------------------------------------- Definitionen fr die Gadgets ---------------------------

Num_Gadgets		=	5
Gadgets_Width		=	36
Gadgets_Height		=	16
Gadgets_Space		=	20	;Platz fr Gadgets, Bevelbox und Zusatzrand
BevelabstandH		=	3
BevelabstandV		=	2
NumGadentries		=	4	;2^x ist die max. Anzahl der Belegungen pro Gadget

		incdir	include:
		include	misc/Buggsmacros.i

		include	exec/exec_lib.i
		include	exec/memory.i
		include	exec/execbase.i
		include	graphics/graphics_LIB.i
		include	graphics/gfxbase.i
		include	graphics/displayinfo.i
		include	intuition/intuition.i
		include	intuition/intuition_LIB.i
	ifne	Eagleplayer
		include	misc/EagleplayerEngine.i
	endc
		include	libraries/mathffp_lib.i
		include	libraries/mathtrans_lib.i
		include	libraries/gadtools.i
		include	libraries/gadtools_lib.i
		include	dos/dos_lib.i

		include	cybergraphics/cybergraphics.i
		include	cybergraphics/cybergraphics_lib.i

;--------------------------- Definitionen fr Cybergfx-Untersttzung -------------------------

	STRUCTURE	myCyberBitMap,0		;Bitmap alike, ist allerdings nur fr interne
	WORD	CYM_BytesPerRow			;Nutzung, diese "faked" Bitmap wird nicht an externe
	WORD	CYM_Rows			;Programme bergeben, das Auslesen geschieht per
	BYTE	CYM_Flags	;unused		;"WritePixelArray"
	BYTE	CYM_Depth	;unused
	LONG	CYM_Memsize	;Lnge des allozierten Speichers
	APTR	CYM_Plane	;bei Chunky ist es eh nur eine Plane
	WORD	CYM_Pad		;Align auf 16 Bytes
	LABEL	CYM_SIZEOF


		section	0,code
Begin
		bra.w	fangan

	ifne	Eagleplayer

		EUSN_Identifier
		dc.l	0		;eus_next
	ifne	debug
		dc.w	-2
	else
		dc.w	0		;eus_Usernr
	endc
myEPBase:	dc.l	0		;eus_EPBase
		dc.l	0		;eus_Freetable
		dc.l	0		;eus_Taskadr
		dc.l	0		;eus_unused1
		dc.l	0		;eus_unused2
		dc.l	0		;eus_unused3
		dc.l	Tagliste	;eus_unused4
		dc.w	0		;eus_ticks
		dc.w	0		;eus_tickcounter
		dc.l	EUIB_OnlyPlay!EUIB_OnlyActive ;eus_tickflags
		dc.l	USMB_KillModule!USMB_Zipwin!USMB_ChangeConfig!USMB_ChangeInterrupt;eus_msgflags
		dc.l	ProcessName	;eus_PName
		dc.l	mybuggsname
		dc.l	myinfo
		dc.w	37		;eus_Kickstart
		dc.l	Eagleversion	;eus_EPVersion
		structver		;eus_version
		dc.l	WinName		;eus_username

		dc.w	268		;eus_winx
		dc.w	167		;eus_winy
		dc.w	EUSB_openwin

		dc.w	0		;special informations (Winwidth)
		dc.w	0		;special informations (Winheight)
	endc

gadgetson:	dc.b	1;0		;EUS_Special2 (Gadgets on/off = 1/0 )

	ifne	Eagleplayer
ModePref:	dc.b	9		;Nummer des aktuellen Anzeigemodus
	else
ModePref:	dc.b	9		;Nummer des aktuellen Anzeigemodus (default)
	endc

speedNmix	dc.b	0		;obere 4 Bis fr Framecounter, untere 4 Bits fr Mixrateindex
FreqBar		dc.b	1<<7!1<<6;0	;1. Anzeigebalken fr Frequenzen $80=an
					;2. Welche FFT benutzt wird ($40)

	ifne	Eagleplayer

		dc.l	0		;EUS_Special3
		structdate		;EUS_Creatordate
		dc.b	-5		;EUS_Priority
		dc.b	EUTY_Analyzer
		dc.w	0
		dc.l	0		;EUS_Reserved3
		dc.l	0		;EUS_Reserved4
		dc.l	0		;EUS_Reserved5
		dc.l	0		;EUS_Reserved6

		ifne	(*-begin)-EUS_SizeOF
		Aber Hallo
		endc


		dc.b	`$VER: FFT Analyzer `
		ver
		dc.b	` (`
		date
		dc.b	`) `,0

	even

Tagliste:	dc.l	EUT_SpecialinfoLNr,LNrE_SpecialInfo_FFTAnalyzer
		dc.l	EUT_AttnFlags,AFF_68020
		dc.l	0

	endc

fangan
		lea	datas,a5		
		move.l	a5,a0
		move.w	#dataslen-1,d0
clr$		clr.b	(a0)+
		dbf	d0,clr$

;		move.l	#16384*81,Mixfrequency(a5)	;44.1 kHz
;		move.l	#16384*112,Mixfrequency(a5)	;32 kHz
;		move.l	#16384*149,Mixfrequency(a5)	;24 kHz
		move.l	#16384*224,Mixfrequency(a5)	;15980 Hz =  8 kHz max.
							;bei nderung, auch die Frequenzanzeige-
							;liste anpassen, sonst stimmen
							;die Strings dann nicht !!!

		move.l	4.w,a6			;68020 Check
		move.w	attnflags(A6),d0
		and.w	#AFF_68020,d0
		beq	CloseProg

		moveq	#0,d2
		move.b	modepref(pc),d2
		bsr	NewCurrentmode		;default Modus initialisieren

		bsr	OpenLibs		;OpenLibs & diverse Inits
		beq	CloseProg		;ging nicht -> RAUS

		bsr	InitFFT			;Tabellen usw. init

	ifne	Eagleplayer
		moveq	#0,d7
		bsr	sendfirstmessage	;Message an Eagleplayer, "da bin ich"
		blt	CloseProg
	else
		bsr	OpenWin

		moveq	#22,d2			;Multicolor-CGFX
		bsr	NewCurrentmode		;Modus Init

		move.l	CurrentMode(pc),a0
		move.l	12(a0),a0
		jsr	(a0)			;Clear Window des aktuellen Modus

		move.l	CurrentMode(pc),a0
		move.l	(a0),a0
		jsr	(a0)			;Init des aktuellen Modus

		moveq	#7,d0
		bsr	Makevoltable		;Umrechnungstabelle zum Mixen der Channels

		bsr	ShowTheFuckingFFT
	endc

		bsr	HandleActions		;Auf Usereingaben reagieren
		blt.w	weiter$			;D7 = 0 oder -1

	ifne	Eagleplayer
		bsr	Sendlastmessage
	endc
weiter$

;-------------------------------------------------------------------------------------------------
; alles freigeben, was man vergessen haben knnte, man wei ja nie
; Alle Routinen safe to call
		bsr	closewin		;Window incl. extra Bitmap
		bsr	FreeOldModes
.Project0WError
CloseProg
		bsr	CloseLibs
		moveq	#0,d0
		rts		

;--------------------------------------------------------------------------------------------------
;------------------ Hauptloop fr die Anzeige der FFT Ergebnisse ----------------------------------
;--------------------------------------------------------------------------------------------------
ShowTheFuckingFFT:
		push	all

		;-------------------- Checks auf Validitt -------------------------
		move.l	winhandle(a5),d0	;Window berhaupt offen ?
		beq.w	.noanalyze

	ifne	Eagleplayer

		move.l	an_structadr(a5),d0	;Scope-Strukturadresse vorhanden ?
		beq.w	.Noanalyze		;nope, also passiv verhalten
		move.l	d0,a0

		tst.w	UPS_enabled(a0)		;Zugriff erlaubt ?
		bne.w	.noanalyze		;nope, also nix tun

		move.w	UPS_Flags(a0),d0	;alle bentigten Werte bergeben ?
		and.w	#UPSB_Per!UPSB_len!UPSB_adr!UPSB_vol,d0
		cmp.w	#UPSB_Per!UPSB_len!UPSB_adr!UPSB_vol,d0
		bne.s	.noanalyze		;noe, wieso auch....

	endc

		;--------------------------- 4 Stimmen auf 2 zusammenmixen ------------
		bsr	MixVoices		;Mixt 4 Stimmen zu 2 zusammen oder
						;skaliert 2 Stimmen auf
						;bentigte Abspielrate (momentan 16 kHz)
		
		;------------- FFT durchfhren und Power Spektrum ermitteln -----------
		tst.b	slowid(A5)		;wenn eingestellt, nur alle 2-3 Frames 
						;FFT und Anzeige
		bne.s	.skip

		move.l	Current_FFT(a5),d0	;256 Punkt oder 512 Punkt FFT durchfhren
		beq.s	.skip
		move.l	d0,a0
		jsr	(a0)			;in Outtab1 und Outtab2 sind nun
						;die Ergebnisse

		;------------------------ ins Fenster werfen --------------------------
		move.l	CurrentMode(pc),d0
		beq.s	.skip
		move.l	d0,a0
		move.l	4(a0),a0
		jsr	(a0)
.skip
.noanalyze
		pop	all
		rts

myInnerwidth:		dc.w	0
myInnerheight:		dc.w	0
Top_Offset:		dc.w	0
Left_Offset:		dc.w	0

myBox_width		dc.w	0
myBox_height		dc.w	0
myBox1_top		dc.w	0
myBox2_top		dc.w	0
myBox_left		dc.w	0
myCustomBitmap		dc.l	0
Updown			dc.w	0
DoubleLine		dc.w	0
Color0			dc.w	-1
Color1			dc.w	-1
Color2:			dc.w	-1			;schwarz, Hintergrundfarbe

;----------------------- aktueller Analyzer-Modus, mit Modus 0 vorinit --------------------------
CurrentMode:		dc.l	Modetab	;+16
;----------------------- Tabelle fr die einzelnen Analyzer-Modi --------------------------------
;------ alle Routinen mssen re-entrant sein, also auch zweimal hintereinander aufrufbar --------
;Aufbau: 1. LW InitRoutine  2. LW Scope-Routine  3. LW EndRoutine 4. LW ClearWindowRoutine
;        5. LW Flags
;
; Flags: Bit 0 - 2 Balkenreihen nebeneinander (wg. Frequenz-Anzeige)
;        Bit 1 - keine Frequenzanzeige ! (nur wegen dem sch*** Deli-Mode ;-)

ModeTab:
 dc.l	Mode01Init,Mode01Scope,Mode01End,ClearWindow,0 ;alle 2 Zeilen, monochrom, von auen nach innen
 dc.l	Mode01Init,Mode02Scope,Mode01End,ClearWindow,0 ;alle 2 Zeilen, monochrom, von innen nach auen
 dc.l	Mode01Init,Mode03Scope,Mode01End,ClearWindow,0 ;jede Zeile, monochrom, von auen nach innen
 dc.l	Mode04Init,Mode04Scope,Mode04End,ClearWindowBlack,0 ;jede Zeile, 2 aus 256 Farben, von auen nach innen
 dc.l	Mode05Init,Mode05Scope,Mode04End,ClearWindowBlack,0 ;jede Zeile, 2 aus 256 Farben, von innen nach auen
 dc.l	Mode06Init,Mode06Scope,Mode06End,ClearWindow,0	;mit maxDisplay, von auen nach innen,
							;alle 2 Zeilen, monochrom
 dc.l	Mode06Init,Mode07Scope,Mode06End,ClearWindow,0	;mit maxDisplay, von innen nach auen,
							;alle 2 Zeilen, monochrom
 dc.l	Mode01Init,Mode08Scope,Mode01End,ClearWindow,0 ;nur 1 Zeichen, monochrom, von innen nach auen
 dc.l	Mode09Init,Mode09Scope,Mode01End,ClearWindowHBM,1 ;Balken  2 Bits breit, monochrom,
							;von unten nach oben
 dc.l	Mode10Init,Mode10Scope,Mode01End,ClearWindow,0  ;Balken  2 Bits breit, monochrom,
							;von aussen nach innen
 dc.l	Mode11Init,Mode11Scope,Mode01End,ClearWindow,0  ;Balken  2 Bits breit, monochrom,
							;von innen nach aussen
 dc.l	Mode12Init,Mode12Scope,Mode01End,ClearWindowHBM,0 ;jede Zeile, monochrom, von unten nach oben
 dc.l	Mode12Init,Mode13Scope,Mode01End,ClearWindowHBM,0 ;jede 2. Zeile, monochrom, von unten nach oben
 dc.l	Mode13Init,Mode14Scope,Mode06End,ClearWindowHBM,0 ;jede 2. Zeile, monochrom, von unten nach oben
						     ;mit MaxDisplay
 dc.l	Mode01Init,Mode15Scope,Mode01End,ClearWindow,0 ;jede Zeile, monochrom, von innen nach auen
 dc.l	Mode01Init,Mode16Scope,Mode01End,ClearWindow,0 ;nur 1 Zeichen, monochrom, von auen nach innen
 dc.l	Mode17Init,Mode17Scope,Mode01End,ClearWindow,0 ;durchgezogene Linie, monochrom, von auen nach innen

 dc.l	Mode12Init,Mode18Scope,Mode01End,ClearWindowHBM,0 ;nur 1 Zeichen, monochrom, von unten nach oben
 dc.l	Mode19Init,Mode19Scope,Mode01End,ClearWindowHBMBlack,0 ;jede Zeile, 2 aus 256 Farben, von unten nach oben

 dc.l	Mode20Init,Mode20Scope,Mode20End,ClearWindowHBM,2 ;Amplituden horizontal, jede 2. Zeile, monochrom
 dc.l	Mode17Init,Mode21Scope,Mode01End,ClearWindow,0 ;durchgezogene Linie, monochrom, von innen nach auen

;--------- diese 3 nochmal wegen der CyberModi, die dieselben Nummern haben ---------
 dc.l	Mode04Init,Mode04Scope,Mode04End,ClearWindowBlack,0 ;jede Zeile, 2 aus 256 Farben, von auen nach innen
 dc.l	Mode05Init,Mode05Scope,Mode04End,ClearWindowBlack,0 ;jede Zeile, 2 aus 256 Farben, von innen nach auen
 dc.l	Mode19Init,Mode19Scope,Mode01End,ClearWindowHBMBlack,0 ;jede Zeile, 2 aus 256 Farben, von unten nach oben
 dc.l	Mode19Init,Mode19Scope,Mode01End,ClearWindowHBMBlack,0 ;jede Zeile, 2 aus 256 Farben, von unten nach oben

	dc.l	0,0,0,0	;22
	dc.l	0,0,0,0	;23
	dc.l	0,0,0,0	;24

	dc.l	0,0,0,0	;ab Modus 25

GadModeslist:	;jedes Gadget max. 15 mal belegt, sollte erstmal ausreichen

	dc.b	01,06,03,16,00,00,00,00,00,00,00,00,00,00,00,00		;letztes Byte immer 0 !
	dc.b	02,07,15,08,00,00,00,00,00,00,00,00,00,00,00,00
	dc.b	13,14,12,18,00,00,00,00,00,00,00,00,00,00,00,00
	dc.b	09,10,11,17,21,20,00,00,00,00,00,00,00,00,00,00
	dc.b	22,23,24,25,04,05,00,00,00,00,00,00,00,00,00,00

Mode01Init:
		move.w	mybox_height(pc),d0
		bsr	MakeAmplitudetab	;Amplitudentabelle fr Darstellung im Fenster berechnen

		bsr	FreeOldModes		;den Mll der anderen Modi beseitigen
		moveq	#1,d2			;Tiefe
		moveq	#0,d1			;Hhe
		move	myBox_height(pc),d1
		bsr	myAllocBitmap
		rts				;Returnwert schon gesetzt
Mode01Scope:
		move.l	myCustomBitmap(pc),d0
		beq	.skiphim2
		move.l	d0,a1
		tst.l	bm_planes(a1)
		beq	.skiphim2

		lea	OutTab1,a0
		move	#-1,Updown
		bsr	Auswert			;Bitmap lschen, skalieren
		move	myBox_height(pc),d4
		bsr	Showthem_1
		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d3	;Y2
		bsr	Intowindow

		lea	OutTab2,a0
		move	#1,Updown
		bsr	Auswert
		move	myBox_height(pc),d4
		bsr	Showthem_1

		move.l	Winhandle(A5),a0
		move	myBox2_top(pc),d3	;Y2
		bsr	Intowindow
.skiphim2	rts
Mode01End:	bra	myFreeBitmap		;alte Bitmap freigeben

Mode02Scope:
		move.l	myCustomBitmap(pc),d0
		beq	.skiphim2
		move.l	d0,a1
		tst.l	bm_planes(a1)
		beq	.skiphim2

		lea	OutTab1,a0
		move	#1,Updown
		bsr	Auswert			;Bitmap lschen, skalieren

		move	myBox_height(pc),d4
		bsr	Showthem_1
		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d3	;Y2
		bsr	Intowindow

		lea	OutTab2,a0
		move	#-1,Updown
		bsr	Auswert

		move	myBox_height(pc),d4
		bsr	Showthem_1
		move.l	Winhandle(A5),a0
		move	myBox2_top(pc),d3	;Y2
		bsr	Intowindow
.skiphim2	rts

Mode03Scope:
		move.l	myCustomBitmap(pc),d0
		beq	.skiphim2
		move.l	d0,a1
		tst.l	bm_planes(a1)
		beq	.skiphim2

		lea	OutTab1,a0
		move	#-1,Updown
		bsr	Auswert			;Bitmap lschen, skalieren

		move	myBox_height(pc),d4
		bsr	Showthem_2
		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d3	;Y2
		bsr	Intowindow

		lea	OutTab2,a0
		move	#1,Updown
		bsr	Auswert

		move	myBox_height(pc),d4
		bsr	Showthem_2
		move.l	Winhandle(A5),a0
		move	myBox2_top(pc),d3	;Y2
		bsr	Intowindow
.skiphim2	rts

Mode04Init:
		move.w	mybox_height(pc),d0
		lsr	#1,d0			;nur halbe Amplituden !
		subq	#1,d0
		bsr	MakeAmplitudetab	;Amplitudentabelle fr Darstellung im Fenster berechnen
		move	#1,doubleline

		bsr	FreeOldModes		;den Mll der anderen Modi beseitigen

		bsr	.allocpen		;Pen besorgen
		bmi.s	.fail			;in D0 kommt Farbnummer rurck

		moveq	#0,d2			;Bitplanetiefe des Pens rauskriegen
colloop$	addq	#1,d2
		lsr	#1,d0
		bne.s	colloop$

		moveq	#0,d1			;Hhe
		move	myBox_height(pc),d1
		bsr	myAllocBitmap
		beq	.fail

		bsr	InitTable
		rts				;Returnwert schon gesetzt
.fail		moveq	#0,d0
		rts
.allocpen
;		move.l	#202<<24,d1		;Red
;		move.l	#202<<24,d2		;Green
;		move.l	#240<<24,d3		;Blue
		move.l	#255<<24,d1		;Red
		move.l	#135<<24,d2		;Green
		move.l	#0<<24,d3		;Blue
		moveq	#0,d5
		bsr	AllocPen
		move	d0,Color1
		rts
Mode04Scope:
		move.l	myCustomBitmap(pc),d0
		beq	.skiphim2
		move.l	d0,a1
		tst.l	bm_planes(a1)
		beq	.skiphim2

		lea	OutTab1,a0
		move	#-1,Updown
		bsr	ClearBitmapNplNBlack
		bsr	Scale1			;in A2 TMPTab zurck von Scale

		moveq	#0,d7			;Offset: erste Zeile
		bsr	Showthem_3
		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d3	;Y2
		bsr	Intowindow

		lea	OutTab2,a0
		move	#1,Updown
		bsr	ClearBitmapNplNBlack
		bsr	Scale1			;in A2 TMPTab zurck von Scale

		moveq	#0,d7
		move	myBox_height(pc),d7
		subq	#1,d7			;letzte Zeile
		bsr	Showthem_3
		move.l	Winhandle(A5),a0
		move	myBox2_top(pc),d3	;Y2
		bsr	Intowindow
.skiphim2	rts

Mode04End	bsr	.freepens
		bsr	myfreebitmap
		bsr	FreeTable		;Spezialtabelle freigeben
		rts
.freepens
		move	Color1(pc),d0
		ext.l	d0
		bsr	FreePen
		moveq	#-1,d0
		move	d0,Color1
		rts

;---------------------------------------- Mode 5 ------------------------------------------------
Mode05Init:
		move.w	mybox_height(pc),d0
		lsr	#1,d0			;nur halbe Amplituden !
		subq	#1,d0
		bsr	MakeAmplitudetab	;Amplitudentabelle fr Darstellung im Fenster berechnen
		move	#1,doubleline

		bsr	FreeOldModes		;den Mll der anderen Modi beseitigen

		bsr	.allocpen		;Pen besorgen
		bmi.s	.fail			;in D0 kommt Farbnummer rurck

		moveq	#0,d2			;Bitplanetiefe des Pens rauskriegen
colloop$	addq	#1,d2
		lsr	#1,d0
		bne.s	colloop$

		moveq	#0,d1			;Hhe
		move	myBox_height(pc),d1
		bsr	myAllocBitmap
		beq	.fail

		bsr	InitTable
		rts				;Returnwert schon gesetzt
.fail		moveq	#0,d0
		rts
.allocpen
		move.l	#100<<24,d1		;Red
		move.l	#230<<24,d2		;Green
		move.l	#255<<24,d3		;Blue
;		move.l	#255<<24,d1		;Red
;		move.l	#135<<24,d2		;Green
;		move.l	#0<<24,d3		;Blue
		moveq	#0,d5
		bsr	AllocPen
		move	d0,Color1
		rts


Mode05Scope:
		move.l	myCustomBitmap(pc),d0
		beq	.skiphim2
		move.l	d0,a1
		tst.l	bm_planes(a1)
		beq	.skiphim2

		lea	OutTab1,a0
		move	#1,Updown
		bsr	ClearBitmapNplNBlack
		bsr	Scale1			;in A2 TMPTab zurck von Scale

		moveq	#0,d7
		move	myBox_height(pc),d7
		subq	#1,d7			;letzte Zeile
		bsr	Showthem_3
		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d3	;Y2
		bsr	Intowindow

		lea	OutTab2,a0
		move	#-1,Updown
		bsr	ClearBitmapNplNBlack
		bsr	Scale1			;in A2 TMPTab zurck von Scale

		moveq	#0,d7			;Offset: 1. Zeile
		bsr	Showthem_3
		move.l	Winhandle(A5),a0
		move	myBox2_top(pc),d3	;Y2
		bsr	Intowindow
.skiphim2	rts
;---------------------------------------- Mode 6 ----------------------------------------------
Mode06Init:
		move.w	mybox_height(pc),d0
		bsr	MakeAmplitudetab	;Amplitudentabelle fr Darstellung im Fenster berechnen

		bsr	FreeOldModes		;den Mll der anderen Modi beseitigen

		moveq	#0,d0
		move	myBox_width,d0
		lsr	#3,d0			;Num Balken  8 Pixel im Fenster
		bsr	InitMaxDisplay
		beq.s	fail$

		moveq	#1,d2			;Tiefe
		moveq	#0,d1			;Hhe
		move	myBox_height(pc),d1
		bsr	myAllocBitmap
fail$
		rts				;Returnwert schon gesetzt
Mode06Scope:
		move.l	myCustomBitmap(pc),d0
		beq	.skiphim2
		move.l	d0,a1
		tst.l	bm_planes(a1)
		beq	.skiphim2

		lea	OutTab1,a0
		move	#-1,Updown
		bsr	Auswert			;Bitmap lschen, skalieren
		move	myBox_height(pc),d4
		bsr	Showthem_1

		lea	TMPTab,a0		;A0 - neue Wertetab fr diesen Ausgabestream
		move.l	MaxDisplay1(a5),a1	;A1 - MaxDisplayTabelle fr diesen Ausgabekanal
		bsr	PrepareMaxDisplay
		move	myBox_height(pc),d4
		bsr	MaxDisplayShow1

		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d3	;Y2
		bsr	Intowindow

		lea	OutTab2,a0
		move	#1,Updown
		bsr	Auswert
		move	myBox_height(pc),d4
		bsr	Showthem_1

		lea	TMPTab,a0		;A0 - neue Wertetab fr diesen Ausgabestream
		move.l	MaxDisplay2(a5),a1	;A1 - MaxDisplayTabelle fr diesen Ausgabekanal
		bsr	PrepareMaxDisplay
		move	myBox_height(pc),d4
		bsr	MaxDisplayShow1

		move.l	Winhandle(A5),a0
		move	myBox2_top(pc),d3	;Y2
		bsr	Intowindow
.skiphim2	rts

Mode06End:
		bsr	FreeMaxDisplay
		bra	myFreeBitmap		;alte Bitmap freigeben

;---------------------------------------- Mode 7 ----------------------------------------------
Mode07Scope:
		move.l	myCustomBitmap(pc),d0
		beq	.skiphim2
		move.l	d0,a1
		tst.l	bm_planes(a1)
		beq	.skiphim2

		lea	OutTab1,a0
		move	#1,Updown
		bsr	Auswert			;Bitmap lschen, skalieren
		move	myBox_height(pc),d4
		bsr	Showthem_1

		lea	TMPTab,a0		;A0 - neue Wertetab fr diesen Ausgabestream
		move.l	MaxDisplay1(a5),a1	;A1 - MaxDisplayTabelle fr diesen Ausgabekanal
		bsr	PrepareMaxDisplay
		move	myBox_height(pc),d4
		bsr	MaxDisplayShow1

		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d3	;Y2
		bsr	Intowindow

		lea	OutTab2,a0
		move	#-1,Updown
		bsr	Auswert
		move	myBox_height(pc),d4
		bsr	Showthem_1

		lea	TMPTab,a0		;A0 - neue Wertetab fr diesen Ausgabestream
		move.l	MaxDisplay2(a5),a1	;A1 - MaxDisplayTabelle fr diesen Ausgabekanal
		bsr	PrepareMaxDisplay
		move	myBox_height(pc),d4
		bsr	MaxDisplayShow1

		move.l	Winhandle(A5),a0
		move	myBox2_top(pc),d3	;Y2
		bsr	Intowindow
.skiphim2	rts

;---------------------------------------- Mode 8 ----------------------------------------------
Mode08Scope:
		move.l	myCustomBitmap(pc),d0
		beq	.skiphim2
		move.l	d0,a1
		tst.l	bm_planes(a1)
		beq	.skiphim2

		lea	OutTab1,a0
		move	#1,Updown
		bsr	Auswert			;Bitmap lschen, skalieren
		move	myBox_height(pc),d4
		bsr	Showthem_4
		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d3	;Y2
		bsr	Intowindow

		lea	OutTab2,a0
		move	#-1,Updown
		bsr	Auswert
		move	myBox_height(pc),d4
		bsr	Showthem_4

		move.l	Winhandle(A5),a0
		move	myBox2_top(pc),d3	;Y2
		bsr	Intowindow
.skiphim2	rts

;---------------------------------------- Mode 9 ----------------------------------------------
Mode09Init:
		move.w	mybox_height(pc),d0
		add	d0,d0			;mal 2 (= gesamte Hhe des freien Bereichs)
		bsr	MakeAmplitudetab	;Amplitudentabelle fr Darstellung im Fenster berechnen

		moveq	#0,d0
		move	myBox_width,d0
		move	d0,d1
		lsr	#4,d1
		move	d1,scopeoffset
		lsr	#2,d0			;Num Balken  2 Pixel im Fenster, linker & rechter
						;Channel nebeneinander
		subq	#8,d0
		move	d0,Displaynum(a5)

		bsr	FreeOldModes		;den Mll der anderen Modi beseitigen
		moveq	#1,d2			;Tiefe
		moveq	#0,d1			;Hhe
		move	myBox_height(pc),d1
		add	d1,d1
		bsr	myAllocBitmap
		rts				;Returnwert schon gesetzt
Mode09Scope:
		move.l	myCustomBitmap(pc),d0
		beq	.skiphim2
		move.l	d0,a1
		tst.l	bm_planes(a1)
		beq	.skiphim2

		lea	OutTab1,a0
		move	#1,Updown
		bsr	ClearBitMap1pl
		move	Displaynum(a5),d0
		bsr	Scale1_1
		moveq	#0,d0
		move	myBox_height(pc),d4	;Nummer der letzten Zeile
		add	d4,d4
		moveq	#0,d1
		bsr	Showthem_9

		lea	OutTab2,a0
		move	Displaynum(a5),d0
		bsr	Scale1_1
		moveq	#0,d0
		move	scopeoffset,d0
		move	myBox_height(pc),d4	;Nummer der letzten Zeile
		add	d4,d4
		moveq	#0,d1
		bsr	Showthem_9

		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d3	;Y2
		bsr	Intowindow
.skiphim2	rts

;---------------------------------------- Mode 10 ----------------------------------------------
Mode10Init:
		move.w	mybox_height(pc),d0
		bsr	MakeAmplitudetab	;Amplitudentabelle fr Darstellung im Fenster berechnen

		moveq	#0,d0
		move	myBox_width,d0
		lsr	#1,d0			;Num Balken  2 Pixel im Fenster, linker & rechter
						;Channel nebeneinander
		move	d0,Displaynum(a5)

		bsr	FreeOldModes		;den Mll der anderen Modi beseitigen
		moveq	#1,d2			;Tiefe
		moveq	#0,d1			;Hhe
		move	myBox_height(pc),d1
		bsr	myAllocBitmap
		rts				;Returnwert schon gesetzt
Mode10Scope:
		move.l	myCustomBitmap(pc),d0
		beq	.skiphim2
		move.l	d0,a1
		tst.l	bm_planes(a1)
		beq	.skiphim2

		lea	OutTab1,a0
		move	#-1,Updown
		bsr	ClearBitMap1pl
		move	Displaynum(a5),d0
		bsr	Scale1_1

		moveq	#0,d0
		move	myBox_height(pc),d4	;Nummer der letzten Zeile
		moveq	#0,d1
		bsr	Showthem_9

		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d3	;Y2
		bsr	Intowindow


		lea	OutTab2,a0
		move	#1,Updown
		bsr	ClearBitMap1pl
		move	Displaynum(a5),d0
		bsr	Scale1_1

		moveq	#0,d0
		move	myBox_height(pc),d4	;Nummer der letzten Zeile
		moveq	#0,d1
		bsr	Showthem_9

		move.l	Winhandle(A5),a0
		move	myBox2_top(pc),d3	;Y2
		bsr	Intowindow

.skiphim2	rts

;---------------------------------------- Mode 11 ----------------------------------------------
Mode11Init:
		move.w	mybox_height(pc),d0
;		subq	#1,d0			;-1 wegen Mittellinie
		bsr	MakeAmplitudetab	;Amplitudentabelle fr Darstellung im Fenster berechnen

		moveq	#0,d0
		move	myBox_width,d0
		lsr	#1,d0			;Num Balken  2 Pixel im Fenster, linker & rechter
						;Channel nebeneinander
		move	d0,Displaynum(a5)

		bsr	FreeOldModes		;den Mll der anderen Modi beseitigen
		moveq	#1,d2			;Tiefe
		moveq	#0,d1			;Hhe
		move	myBox_height(pc),d1
		bsr	myAllocBitmap
		rts				;Returnwert schon gesetzt
Mode11Scope:
		move.l	myCustomBitmap(pc),d0
		beq	.skiphim2
		move.l	d0,a1
		tst.l	bm_planes(a1)
		beq	.skiphim2

		lea	OutTab1,a0
		move	#1,Updown
		bsr	ClearBitMap1pl
		move	Displaynum(a5),d0
		bsr	Scale1_1

		moveq	#0,d0
		move	myBox_height(pc),d4	;Nummer der letzten Zeile
		subq	#1,d4			;-1 wegen Mittellinie
		moveq	#1,d1
		bsr	Showthem_9



		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d3	;Y2
		bsr	Intowindow

		lea	OutTab2,a0
		move	#-1,Updown
		bsr	ClearBitMap1pl
		move	Displaynum(a5),d0
		bsr	Scale1_1

		moveq	#0,d0
		move	myBox_height(pc),d4	;Nummer der letzten Zeile
		moveq	#0,d1
		bsr	Showthem_9

		move.l	Winhandle(A5),a0
		move	myBox2_top(pc),d3	;Y2
		bsr	Intowindow

.skiphim2	rts

;---------------------------------------- Mode 12 ----------------------------------------------

Mode12Init:
		move.w	mybox_height(pc),d0
		add	d0,d0
		bsr	MakeAmplitudetab	;Amplitudentabelle fr Darstellung im Fenster berechnen

		bsr	FreeOldModes		;den Mll der anderen Modi beseitigen
		moveq	#1,d2			;Tiefe
		moveq	#0,d1			;Hhe
		move	myBox_height(pc),d1
		add	d1,d1
		bsr	myAllocBitmap
		rts				;Returnwert schon gesetzt
Mode12Scope:
		move.l	myCustomBitmap(pc),d0
		beq	.skiphim2
		move.l	d0,a1
		tst.l	bm_planes(a1)
		beq	.skiphim2

		bsr	ClearBitmap1pl

		lea	OutTab1,a0
		lea	OutTab2,a1
		bsr	Scale2			;in A2 TMPTab zurck

		move	#1,Updown
		move	myBox_height(pc),d4
		add	d4,d4
		bsr	Showthem_2

		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d3	;Y2
		bsr	Intowindow
.skiphim2	rts

;--------------------------------------- Modus 13 -------------------------------------------------
Mode13Scope
		move.l	myCustomBitmap(pc),d0
		beq	.skiphim2
		move.l	d0,a1
		tst.l	bm_planes(a1)
		beq	.skiphim2

		bsr	ClearBitmap1pl

		lea	OutTab1,a0
		lea	OutTab2,a1
		bsr	Scale2			;in A2 TMPTab zurck

		move	#1,Updown
		move	myBox_height(pc),d4
		add	d4,d4
		bsr	Showthem_1

		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d3	;Y2
		bsr	Intowindow
.skiphim2	rts

;--------------------------------------- Modus 14 -------------------------------------------------

Mode13Init:
		move.w	mybox_height(pc),d0
		add	d0,d0
		bsr	MakeAmplitudetab	;Amplitudentabelle fr Darstellung im Fenster berechnen

		bsr	FreeOldModes		;den Mll der anderen Modi beseitigen

		moveq	#0,d0
		move	myBox_width,d0
		lsr	#3,d0			;Num Balken  8 Pixel im Fenster
		bsr	InitMaxDisplay
		beq.s	fail$

		moveq	#1,d2			;Tiefe
		moveq	#0,d1			;Hhe
		move	myBox_height(pc),d1
		add	d1,d1
		bsr	myAllocBitmap
fail$
		rts				;Returnwert schon gesetzt
Mode14Scope:
		move.l	myCustomBitmap(pc),d0
		beq	.skiphim2
		move.l	d0,a1
		tst.l	bm_planes(a1)
		beq	.skiphim2

		bsr	ClearBitmap1pl

		lea	OutTab1,a0
		lea	OutTab2,a1
		bsr	Scale2			;in A2 TMPTab zurck

		move	#1,Updown
		move	myBox_height(pc),d4
		add	d4,d4
		bsr	Showthem_1

		lea	TMPTab,a0		;A0 - neue Wertetab fr diesen Ausgabestream
		move.l	MaxDisplay1(a5),a1	;A1 - MaxDisplayTabelle fr diesen Ausgabekanal
		bsr	PrepareMaxDisplay

		move	myBox_height(pc),d4
		add	d4,d4
		bsr	MaxDisplayShow1

		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d3	;Y2
		bsr	Intowindow
.skiphim2	rts

;--------------------------------------- Modus 15 -------------------------------------------------

Mode15Scope:
		move.l	myCustomBitmap(pc),d0
		beq	.skiphim2
		move.l	d0,a1
		tst.l	bm_planes(a1)
		beq	.skiphim2

		lea	OutTab1,a0
		move	#1,Updown
		bsr	Auswert			;Bitmap lschen, skalieren

		move	myBox_height(pc),d4
		bsr	Showthem_2
		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d3	;Y2
		bsr	Intowindow

		lea	OutTab2,a0
		move	#-1,Updown
		bsr	Auswert

		move	myBox_height(pc),d4
		bsr	Showthem_2
		move.l	Winhandle(A5),a0
		move	myBox2_top(pc),d3	;Y2
		bsr	Intowindow
.skiphim2	rts

;---------------------------------------- Mode 16 ----------------------------------------------
Mode16Scope:
		move.l	myCustomBitmap(pc),d0
		beq	.skiphim2
		move.l	d0,a1
		tst.l	bm_planes(a1)
		beq	.skiphim2

		lea	OutTab1,a0
		move	#-1,Updown
		bsr	Auswert			;Bitmap lschen, skalieren
		move	myBox_height(pc),d4
		bsr	Showthem_4
		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d3	;Y2
		bsr	Intowindow

		lea	OutTab2,a0
		move	#1,Updown
		bsr	Auswert
		move	myBox_height(pc),d4
		bsr	Showthem_4

		move.l	Winhandle(A5),a0
		move	myBox2_top(pc),d3	;Y2
		bsr	Intowindow
.skiphim2	rts

;---------------------------------------- Mode 17 ----------------------------------------------
Mode17Init:
		move.w	mybox_height(pc),d0
		bsr	MakeAmplitudetab	;Amplitudentabelle fr Darstellung im Fenster berechnen

		moveq	#0,d0
		move	myBox_width,d0
		subq	#8,d0			;Num Balken  1 Pixel im Fenster
		move	d0,Displaynum(a5)

		bsr	FreeOldModes		;den Mll der anderen Modi beseitigen

		moveq	#1,d2			;Tiefe
		moveq	#0,d1			;Hhe
		move	myBox_height(pc),d1
		bsr	myAllocBitmap
		rts				;Returnwert schon gesetzt
Mode17Scope:
		move.l	myCustomBitmap(pc),d0
		beq	.skiphim2
		move.l	d0,a1
		tst.l	bm_planes(a1)
		beq	.skiphim2

		lea	OutTab1,a0
		move	#-1,Updown
		bsr	ClearBitMap1pl
		move	Displaynum(a5),d0
		bsr	Scale1_1
		moveq	#0,d0
		move	myBox_height(pc),d4	;Nummer der letzten Zeile
		moveq	#0,d1
		bsr	Showthem_10

		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d3	;Y2
		bsr	Intowindow

		lea	OutTab2,a0
		move	#1,Updown
		bsr	ClearBitMap1pl
		move	Displaynum(a5),d0
		bsr	Scale1_1
		moveq	#0,d0
		move	myBox_height(pc),d4	;Nummer der letzten Zeile
		moveq	#0,d1
		bsr	Showthem_10

		move.l	Winhandle(A5),a0
		move	myBox2_top(pc),d3	;Y2
		bsr	Intowindow

.skiphim2	rts

;---------------------------------------- Mode 18 ----------------------------------------------
Mode18Scope:
		move.l	myCustomBitmap(pc),d0
		beq	.skiphim2
		move.l	d0,a1
		tst.l	bm_planes(a1)
		beq	.skiphim2

		bsr	ClearBitmap1pl

		lea	OutTab1,a0
		lea	OutTab2,a1
		bsr	Scale2			;in A2 TMPTab zurck

		move	#1,Updown
		move	myBox_height(pc),d4
		add	d4,d4
		bsr	Showthem_4

		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d3	;Y2
		bsr	Intowindow
.skiphim2	rts

;---------------------------------------- Mode 19 ------------------------------------------------
Mode19Init:
		move.w	mybox_height(pc),d0
		bsr	MakeAmplitudetab	;Amplitudentabelle fr Darstellung im Fenster berechnen
		move	#1,doubleline

		bsr	FreeOldModes		;den Mll der anderen Modi beseitigen

		bsr	.allocpen		;Pen besorgen
		bmi.s	.fail			;in D0 kommt Farbnummer rurck

		moveq	#0,d2			;Bitplanetiefe des Pens rauskriegen
colloop$	addq	#1,d2
		lsr	#1,d0
		bne.s	colloop$

		moveq	#0,d1			;Hhe
		move	myBox_height(pc),d1
		add	d1,d1
		bsr	myAllocBitmap
		beq	.fail

		bsr	InitTable
		rts				;Returnwert schon gesetzt
.fail		moveq	#0,d0
		rts
.allocpen
		move.l	#255<<24,d1		;Red
		move.l	#000<<24,d2		;Green
		move.l	#038<<24,d3		;Blue
;		move.l	#255<<24,d1		;Red
;		move.l	#135<<24,d2		;Green
;		move.l	#0<<24,d3		;Blue
		moveq	#0,d5
		bsr	AllocPen
		move	d0,Color1
		rts

Mode19Scope:
		move.l	myCustomBitmap(pc),d0
		beq	.skiphim2
		move.l	d0,a1
		tst.l	bm_planes(a1)
		beq	.skiphim2

		bsr	ClearBitmapNplNBlack

		lea	OutTab1,a0
		lea	OutTab2,a1
		bsr	Scale2			;in A2 TMPTab zurck

		move	#1,Updown
		moveq	#0,d7
		move	myBox_height(pc),d7
		add	d7,d7
		subq	#1,d7
		bsr	Showthem_3

		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d3	;Y2
		bsr	Intowindow
.skiphim2	rts

;---------------------------------------- Mode 20 ----------------------------------------------
Mode20Init:
		bsr	FreeOldModes		;den Mll der anderen Modi beseitigen

		moveq	#0,d0
		move	myBox_width,d0
		lsr	#1,d0			;eine Reihe nach links, eine nach rechts mach x/2
		and	#~15,d0			;Auf Wortbreite=16 Pixel align
		subq	#8,d0			;Platz in der Mitte
		bsr	MakeAmplitudetab	;Amplitudentabelle fr Darstellung im Fenster berechnen
		
		move.l	#Amptabentries*8,d0	;2 Worte pro Eintrag, fr links und rechts separat
		moveq	#MEMF_Any,d1
		move.l	4.w,a6
		jsr	_LVOAllocMem(A6)
		move.l	d0,Extramem1(a5)	;Tabelle fr Kanal 1
		beq	fail$			;Mem Error

	;----------------------- Amptab "etwas anders" umkopieren -------------------------------
		move.l	d0,a0
		lea	Amptabentries*4(a0),a2
		lea	Amplitudetab,a1
		move	#Amptabentries-1,d0
amptab$
		moveq	#0,d1
		move	(a1)+,d1
		divu	#16,d1			;divu, damit wir den Rest mitbekommen
		swap	d1			;untere 4 Bit (0..15)
		move.l	d1,d3

		move	d1,d2
		beq.s	ok$
		clr.w	d1
		clr.w	d3
bits$
						;nach rechts
		or	#1,d3			;unterstes Bit
		ror	d3			;rol -> oberstes Bit

						;nach links
		add	d1,d1			;nchstes Bit
		or.w	#1,d1			;Bit setzen

		subq	#1,d2			;Zhler-1
		bne.s	bits$			;Ende ?
ok$
		swap	d1
		move.l	d1,(a0)+		;oberes Wort:  Nibbles (Bitmuster bis 15) (<-)
						;unteres Wort: Zhler (in Worten  16 Bit)
		swap	d3
		move.l	d3,(a2)+		;oberes Wort:  Nibbles (Bitmuster bis 15) (->)
						;unteres Wort: Zhler (in Worten  16 Bit)
		dbf	d0,amptab$
	;----------------------------------------------------------------------------------------

		moveq	#1,d2			;Tiefe
		moveq	#0,d1			;Hhe
		move	myBox_height(pc),d1
		add	d1,d1			;komplette Hhe
		bsr	myAllocBitmap
						;0 = Mem Error
		beq.s	fail$

		bsr	ClearBitMap1pl
fail$
		rts				;Returnwert schon gesetzt
Mode20Scope:
		move.l	myCustomBitmap(pc),d0
		beq	.skiphim2
		move.l	d0,a1
		tst.l	bm_planes(a1)
		beq	.skiphim2
		move.l	Extramem1(a5),d0
		beq	.skiphim2
		move.l	d0,a3			;fr Skalierung, Amplitudentabelle

		lea	OutTab1,a0
;		bsr	ClearBitMap1pl
		move	mybox_height(pc),d0	;nur jede 2. Zeile von height*2 Zeilen darstellen
		bsr	Scale3_1

		bsr	Showthem_5l

		lea	Amptabentries*4(a3),a3

		lea	OutTab2,a0
		move	mybox_height(pc),d0	;nur jede 2. Zeile von height*2 Zeilen darstellen
		bsr	Scale3_1

		bsr	Showthem_5r

		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d3	;Y2
		bsr	Intowindow

.skiphim2	rts

Mode20End:
		move.l	Extramem1(a5),d0	;Tabelle fr Kanal 1
		beq	nomem$			;Mem Error
		move.l	d0,a1
		move.l	#Amptabentries*8,d0	;2 Worte pro Eintrag
		move.l	4.w,a6
		jsr	_LVOFreemem(A6)
		clr.l	Extramem1(a5)
nomem$
		bra	myFreeBitmap		;alte Bitmap freigeben

;---------------------------------------- Mode 21 ----------------------------------------------
Mode21Scope:
		move.l	myCustomBitmap(pc),d0
		beq	.skiphim2
		move.l	d0,a1
		tst.l	bm_planes(a1)
		beq	.skiphim2

		lea	OutTab1,a0
		move	#1,Updown
		bsr	ClearBitMap1pl
		move	Displaynum(a5),d0
		bsr	Scale1_1
		moveq	#0,d0
		move	myBox_height(pc),d4	;Nummer der letzten Zeile
		moveq	#0,d1
		bsr	Showthem_10

		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d3	;Y2
		bsr	Intowindow

		lea	OutTab2,a0
		move	#-1,Updown
		bsr	ClearBitMap1pl
		move	Displaynum(a5),d0
		bsr	Scale1_1
		moveq	#0,d0
		move	myBox_height(pc),d4	;Nummer der letzten Zeile
		moveq	#0,d1
		bsr	Showthem_10

		move.l	Winhandle(A5),a0
		move	myBox2_top(pc),d3	;Y2
		bsr	Intowindow

.skiphim2	rts


scopeoffset	dc.w	0

;--------------------------------------------------------------------------------------------
;                                       FreePen
;
; Pen des aktuellen Screens freigeben
; 
; Vorsicht, darf nur vor "CloseWindow" aufgerufen werden, da sonst u.U. der Screen nicht
; mehr existiert
;
;Input: D0 - Farbnummer (darf auch -1 sein)
;
FreePen:
		push	all
		move.l	mycmap(A5),d0
		beq	nocmap$
		move.l	d0,a0
		move.l	grafsave(A5),a6
		jsr	_LVOreleasepen(A6)
nocmap$
		pop	all
		rts
;--------------------------------------------------------------------------------------------
;                                       AllocPen
;
;Versucht, einen Pen des aktuellen Screens zu ergattern
;
;Input: D1/D2/D3 - Farbwerte
;       D5       - Flags Bit0=1 -> FEHLER, wenn Farbe nicht exakt zu bekommen
;OutPut: D0 - Farbnummer 0..255 oder -1 fr Fehler
;
AllocPen:
	push	d1-d7/a0-a6

	moveq	#-1,d0
	move.l	winhandle(a5),d4		;Window berhaupt offen ?
	beq.s	quit$
	move.l	d4,a1
	move.l	WD_WScreen(A1),a1
	move.l	sc_viewport+vp_colormap(a1),a0	;Viewport->Colormap
	move.l	a0,mycmap(A5)

	moveq	#-1,d0				;Number

	lea	mytags(A5),a1
	move.l	#OBP_Precision,(a1)+
	move.l	#PRECISION_EXACT,(a1)+

	btst	#0,d5
	beq.s	skipfail$

	move.l	#OBP_FailifBad,(A1)+
	move.l	#1,(a1)+
skipfail$
	clr.l	(a1)
	lea	mytags(A5),a1

	move.l	grafsave(A5),a6
	jsr	_LVOObtainBestPenA(A6)
	cmp.l	#255,d0
	bls.s	quit$

	move.l	mycmap(A5),a0
	jsr	_LVOreleasepen(A6)
	moveq	#-1,d0
quit$
	pop	d1-d7/a0-a6
	rts
;----------------------------------------------------------------------------------------------
;---------------------- eventl. Datenmll der anderen Modi beseitigen -------------------------
; nur zur Sicherheit, Routinen mssen re-entrant sein
;
FreeOldModes:
		bsr	myFreeCyberMap
		bsr	myFreeBitmap		;alte Bitmap freigeben
		bsr	FreeTable		;Spezialtabelle freigeben

		move	Color1(pc),d0
		ext.l	d0
		bsr	FreePen
		moveq	#-1,d0
		move	d0,Color1

		rts

;-------------------------------------------------------------------------------------------------
;--------- Tabelle fr Skalierung der Amplituden der Werte des Frequenzspektrums berechnen -------
;-------------------------------------------------------------------------------------------------
;Input: D0 - Maximaler Auschlag in Pixeln
;
;-------------------------------------------------------------------------------------------------

	ifne	Linear						;Lineare Auswertung (X mal Ymax)
MakeAmplitudetab:
		push	d0-d3/a0
		lea	Amplitudetab,a0
		move	myBox_height(pc),d1
		subq	#1,d1				;weil meist DBF-Schleifen
		move	#Amptabentries-1,d0	;Anzahl der Werte im Amplitudenspektrum
		moveq	#0,d2
Amptab$
		addq	#1,d2
		move	d2,d3
		mulu	d1,d3
		lsr	#4,d3
		cmp	d1,d3
		ble.s	.lo
		move	d1,d3
.lo
		move	d3,(a0)+
		dbf	d0,Amptab$

		pop	d0-d3/a0
		rts
	else
	ifne	Log_y_X						;Ymax * (ln X / ln Xmax)

MakeAmplitudetab:
		push	all
		move	d0,d7

		move.l	mathtrans(a5),a3		
		move.l	mathffp(a5),a4

		move.l	#64*2^[Extra_Resolution],d0	;Max. angenommener Wert fr die Amplituden des Spektrums
		move.l	a4,a6
		jsr	_LVOSPFlt(A6)		;in FFP
		move.l	a3,a6
		jsr	_LVOSPLog10(A6)		;log des Werts
		move.l	d0,d2
		moveq	#0,d0
		move	d7,d0
		subq	#1,d0
		move	d0,d5
		move.l	a4,a6
		jsr	_LVOSPFlt(A6)		;Float der Hhe der Box fr den Analyzer
		move.l	d2,d1
		jsr	_LVOSPDiv(A6)		;Division der Boxhhe durch den max. Wert des
						;Logarithmus = Boost Faktor fr die anderen Werte
		move.l	d0,d2
		
		moveq	#0,d3

		move	#Amptabentries-1,d4	;Anzahl der Werte im Amplitudenspektrum
		lea	Amplitudetab,a2
math$
		addq.l	#1,d3
		move.l	d3,d0
		move.l	a4,a6
		jsr	_LVOSPFlt(A6)		;x in FFP umwandeln
		move.l	a3,a6
		jsr	_LVOSPLog10(a6)		;log x
		move.l	d2,d1
		move.l	a4,a6
		jsr	_LVOSPMul(A6)
		jsr	_LVOSPFix(A6)
		cmp.w	d5,d0
		ble.s	math_take$
		move	d5,d0
math_take$	move	d0,(a2)+
		dbf	d4,math$
		pop	all
		rts
	else
	ifne	LogSpecial				;        ln (1 + (X*Basis-1)/Xmax)
							;Ymax * ---------------------------
							;                ln Basis

MakeAmplitudetab:
		push	all
		cmp	LastAmplitude(a5),d0
		beq.w	skipcalc$
		move	d0,LastAmplitude(a5)

		move	d0,d7

		move.l	mathtrans(a5),a3		
		move.l	mathffp(a5),a4


		move.l	#64*2^[Extra_Resolution],d0	;Max. angenommener Wert fr die Amplituden des Spektrums
		move.l	a4,a6
		jsr	_LVOSPFlt(A6)		;in FFP
		move.l	d0,d2			;Xmax

		moveq	#0,d0
		move	d7,d0
		subq	#1,d0
		move	d0,d5
		move.l	a4,a6
		jsr	_LVOSPFlt(A6)		;Float der Hhe der Box fr den Analyzer
		move.l	d0,d6			;Ymax

		moveq	#10,d0
		jsr	_LVOSPFlt(a6)
		move.l	d0,d7			;Basis

		moveq	#-1,d3			;X

		move	#Amptabentries-1,d4	;Anzahl der Werte im Amplitudenspektrum
		lea	Amplitudetab,a2
math$
		addq.l	#1,d3			;X von 0 bis ...

		moveq	#1,d0
		move.l	a4,a6
		jsr	_LVOSPFlt(A6)		;1
		move.l	d0,d1
		move.l	d7,d0
		jsr	_LVOSPSub(A6)		;Basis-1
		push	d0
		move.l	d3,d0
		jsr	_LVOSPFlt(A6)		;X in FFP umwandeln
		pop	d1
		jsr	_LVOSPMul(a6)		;X*(Basis-1)
		move.l	d2,d1
		jsr	_LVOSPDiv(a6)		;X*(Basis-1)/Xmax
		push	d0
		moveq	#1,d0
		jsr	_LVOSPFlt(A6)		;1
		pop	d1
		jsr	_LVOSPAdd(A6)		;X*(Basis-1)/Xmax + 1

		move.l	a3,a6
		jsr	_LVOSPLog10(a6)		;log (X*(Basis-1)/Xmax + 1)

;		push	d0
;		move.l	d7,d0
;		jsr	_LVOSPLog10(a6)		;log Basis
;		move.l	d0,d1
;		pop	d0
;		move.l	a4,a6
;		jsr	_LVOSPDiv(A6)		;log (...) / log Basis

		move.l	d6,d1
		move.l	a4,a6
		jsr	_LVOSPMul(A6)

		jsr	_LVOSPFix(A6)
		cmp.w	d5,d0
		ble.s	math_take$
		move	d5,d0
math_take$	move	d0,(a2)+
		dbf	d4,math$

skipcalc$
		pop	all
		rts
	else
	Fehler !! Keine Variante angegeben fr Amplitudentabelle !
	endc

	endc

	endc

;---------------------- Window Clear, eine Bitmap frs gesamte Fenster ----------------------------
ClearWindowHBM:
		push	all
		moveq	#0,d0
		bsr	Showbevel

		bsr	ClearMaxDisplay		;safe to Call

		move.l	myCustomBitmap(pc),d0
		beq	fail$
		move.l	d0,a1
		tst.l	bm_planes(a1)
		beq	fail$

		bsr	ClearBitmap1pl

		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d3	;Y2
		bsr	Intowindow
fail$
		pop	all
		rts
;------------------------------------------------------------------------------------------------
ClearWindow:
		push	all
		moveq	#0,d0
		bsr	Showbevel

		bsr	ClearMaxDisplay		;safe to Call

		move.l	myCustomBitmap(pc),d0
		beq	fail$
		move.l	d0,a1
		tst.l	bm_planes(a1)
		beq	fail$

		bsr	ClearBitmap1pl

		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d3	;Y2
		bsr	Intowindow

		move.l	Winhandle(A5),a0
		move	myBox2_top(pc),d3	;Y2
		bsr	Intowindow
fail$
		pop	all
		rts
;------------------------------------------------------------------------------------------------
ClearWindowBlack:
		push	all
		move	Color2(pc),d0
		bhs.s	ok$
		moveq	#1,d0
ok$
		bsr	Showbevel

		bsr	ClearMaxDisplay		;safe to Call

		move.l	myCustomBitmap(pc),d0
		beq	fail$
		move.l	d0,a1
		tst.l	bm_planes(a1)
		beq	fail$

		bsr	ClearBitmapNplNBlack

		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d3	;Y2
		bsr	Intowindow

		move.l	Winhandle(A5),a0
		move	myBox2_top(pc),d3	;Y2
		bsr	Intowindow
fail$
		pop	all
		rts
;---------------------- Window Clear, eine Bitmap frs gesamte Fenster ----------------------------
ClearWindowHBMBlack:
		push	all
		move	Color2(pc),d0
		bhs.s	ok$
		moveq	#1,d0
ok$
		bsr	Showbevel

		bsr	ClearMaxDisplay		;safe to Call

		move.l	myCustomBitmap(pc),d0
		beq	fail$
		move.l	d0,a1
		tst.l	bm_planes(a1)
		beq	fail$

		bsr	ClearBitmapNplNBlack

		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d3	;Y2
		bsr	Intowindow
fail$
		pop	all
		rts
;-------------------- Bitmap lschen, n Bitplanes, Hintergrund Farbe 1 = schwarz -----------------
ClearBitmapNplNBlack:
		push	d0-d5/a1/a2

		move.l	myCustomBitmap(pc),a1
		move	bm_bytesperrow(a1),d0
		lsr	#1,d0			;in Words umrechnen, sollte eh auf Word-aligned sein

		moveq	#0,d4
		move.b	bm_Depth(a1),d4
		subq	#1,d4			;1. Plane Sonderbehandlung
		beq	oneplane$

		move	bm_rows(a1),d1
		mulu	d1,d0

		lea.l	bm_planes(a1),a1
		moveq	#-1,d2			;schwatt
		subq	#1,d0			;-1 wg. DBF
;		subq	#1,d4			;Num Planes-1
;
;		move.l	(a1)+,a2
;		move	d0,d3
;clr1$		move.w	d2,(a2)+		;1. Plane einfrben
;		dbf	d3,clr1$
;
;clr2$
;		move.l	(a1)+,a2		;nchste Plane
;		move	d0,d3
;clr$		clr.w	(a2)+			;alle anderen Planes
;		dbf	d3,clr$
;		dbf	d4,clr2$

		move	Color2(pc),d5
clr2$
		moveq	#0,d2
		lsr	#1,d5
		bcc.s	no$
		moveq	#-1,d2
no$
		move.l	(a1)+,a2		;nchste Plane
		move	d0,d3
clr$		move.w	d2,(a2)+		;alle anderen Planes
		dbf	d3,clr$
		dbf	d4,clr2$




		pop	d0-d5/a1/a2
		rts
oneplane$
		subq	#1,d0

		move	bm_rows(a1),d1
		subq	#1,d1

		move.l	bm_planes(a1),a1
		moveq	#-1,d2			;schwatt
clr4$
		move	d0,d3
clr3$		move.w	d2,(a1)+		;1. Plane einfrben
		dbf	d3,clr3$
		dbf	d1,clr4$
		pop	d0-d5/a1/a2
		rts
;------------------------ Bitmap lschen, 1 Bitplane, Hintergrund Farbe 0 ------------------------
ClearBitMap1pl:
		push	d0/a1
		move.l	myCustomBitmap(pc),a1
		move	bm_bytesperrow(a1),d0
		mulu	bm_rows(a1),d0
		lsr.l	#2,d0
		subq	#1,d0
		move.l	bm_planes(a1),a1
clr$
		clr.l	(a1)+
		dbf	d0,clr$
		pop	d0/a1
		rts
;------------------------------- Auswertung des Spektrums ---------------------------------------
;------------ Streifendiagramm, Streifen vertikal, 8 Bit breit, 2 Farben  -----------------------
; Input: A0 - H(f), Werte in Wortbreite
;
Auswert:
		bsr	ClearBitmap1pl
		bsr	Scale1					;in A2 TMPTab
fail$		rts



;------------- Skalieren der Werte auf durch Fenstergre bestimmte Anzahl und Amplitude --------
;--------------------------- eine Eingangstab mit Wortgroen Werten -----------------------------
;Input:  a0 - Wertetab
;Output: A2 - Temporre Tabelle mit fertig skalierten Werten
Scale1:
		move	myBox_width,d0
		lsr	#3,d0			;Num Balken  8 Pixel im Fenster
;Input: D0.w - Anzahl der Werte, die rauskommen sollen
Scale1_1:
		push	d0-d7/a1/a3
		and.l	#$ffff,d0

		moveq	#0,d1
		move	Current_NumOut(A5),d1	;normalerweise N/2
		swap	d1
		lsr.l	#3,d1		;statt *2^13 einfach 2^16 / 2^3

		divu.l	d0,d1
		lsl.l	#3,d1
		swap	d1

		moveq	#0,d2
		moveq	#0,d3

		move	d0,d5
		lsr	#1,d5			;immer 2 Werte gleichzeitig bearbeitet

		subq	#1,d5
		lea	Amplitudetab,a3
		lea	TMPtab,a1
		lea	(a1),a2
scale$
		move	(a0,d2.w*2),d4
		add.l	d1,d2
		move	(a3,d4.w*2),d4
		swap	d4
		addx.w	d3,d2
		move	(a0,d2.w*2),d4
		add.l	d1,d2
		move	(a3,d4.w*2),d4
		move.l	d4,(a1)+
		addx.w	d3,d2
		dbf	d5,scale$

		pop	d0-d7/a1/a3
		rts

;------------- Skalieren der Werte auf durch Fenstergre bestimmte Anzahl und Amplitude --------
;------------- 2 Eingangstabellen additiv auf eine Ausgangstabelle, Wortgroe Werte -------------
;Input:  A0 - Wertetab1
;        A1 - Wertetab2
;
;Output: A2 - Temporre Tabelle mit fertig skalierten Werten
Scale2:
		move	myBox_width,d0
		lsr	#3,d0			;Num Balken  8 Pixel im Fenster
;Input: D0.w - Anzahl der Werte, die rauskommen sollen
Scale2_1:
		push	d0-d6/a3/a4
		and.l	#$ffff,d0

;		move.l	#N/2*8192,d1

		moveq	#0,d1
		move	Current_NumOut(A5),d1	;normalerweise N/2
		swap	d1
		lsr.l	#3,d1		;statt *2^13 einfach 2^16 / 2^3

		divu.l	d0,d1
		lsl.l	#3,d1
		swap	d1

		moveq	#0,d2
		moveq	#0,d3

		move	d0,d5
		lsr	#1,d5			;immer 2 Werte gleichzeitig bearbeitet
		subq	#1,d5
		lea	Amplitudetab,a3
		lea	TMPtab,a4
		lea	(a4),a2
scale$
		move	(a0,d2.w*2),d4
		move	(a1,d2.w*2),d6
		add.l	d1,d2
		move	(a3,d4.w*2),d4
		move	(a3,d6.w*2),d6
		addx.w	d3,d2
		add	d6,d4
		lsr	#1,d4
		swap	d4

		move	(a0,d2.w*2),d4
		move	(a1,d2.w*2),d6
		add.l	d1,d2
		move	(a3,d4.w*2),d4
		move	(a3,d6.w*2),d6
		addx.w	d3,d2
		add	d6,d4
		lsr	#1,d4
		move.l	d4,(a4)+
		dbf	d5,scale$

		pop	d0-d6/a3/a4
		rts

;------------- Skalieren der Werte auf durch Fenstergre bestimmte Anzahl und Amplitude --------
;                                  (fr "Deli"-Modus)
;Input:  A0 - Wertetab
;        A3 - Amplitudentabelle
;
;Output: A2 - Temporre Tabelle mit fertig skalierten Werten, 1 LW gro !
;
Scale3:
		move	myBox_width,d0
		lsr	#3,d0			;Num Balken  8 Pixel im Fenster
;Input: D0.w - Anzahl der Werte, die rauskommen sollen
Scale3_1:
		push	d0-d6/a3/a4
		and.l	#$ffff,d0

;		move.l	#N/2*8192,d1

		moveq	#0,d1
		move	Current_NumOut(A5),d1	;normalerweise N/2
		swap	d1
		lsr.l	#3,d1		;statt *2^13 einfach 2^16 / 2^3

		divu.l	d0,d1
		lsl.l	#3,d1
		swap	d1

		moveq	#0,d2
		moveq	#0,d3

		move	d0,d5
		lsr	#1,d5			;immer 2 Werte gleichzeitig bearbeitet
		subq	#1,d5
		lea	TMPtab,a4
		lea	(a4),a2
scale$
		move	(a0,d2.w*2),d4
		add.l	d1,d2
		move.l	(a3,d4.w*4),d4
		addx.w	d3,d2
		move.l	d4,(a4)+

		move	(a0,d2.w*2),d4
		add.l	d1,d2
		move.l	(a3,d4.w*4),d4
		addx.w	d3,d2
		move.l	d4,(a4)+
		dbf	d5,scale$

		pop	d0-d6/a3/a4
		rts

;------------------ Darstellungs Modus10, 1 Pixel breit, als durchgezogene Linie, ------------
;------------------          von oben nach unten oder umgekehrt mgl.              ------------
;Input: D0.l  - Offset horizontal (in Bytes)
;       D4.w  - Nummer der letzten Zeile
;	D1.w != 0 -> letzte Zeile mit $ff auffllen
Showthem_10
		push	d0-d7/a0-a5

		move.l	myCustomBitmap(pc),a0
		moveq	#0,d7
		move	bm_bytesperrow(a0),d7
		move.l	bm_planes(a0),a0

		move	Updown(pc),d5
		bmi.s	down$
						;d4 bereits Offset fr letzte Zeile
		subq	#1,d4			; auf
		mulu	d7,d4			;  letzte 
		add.l	d4,a0			;   Zeile setzen

		tst	d1
		beq.s	nofill$

		move	d7,d5
		subq	#1,d5
		lea	(a0,d7.w),a1
fill$
		st	(a1)+
		dbf	d5,fill$
nofill$
		neg	d7
down$
		ext.l	d7
		add.l	d0,a0

		move	DisplayNum(a5),d6
		subq	#1,d6

		move.b	#$80,d5
Showthem_10$
		move.l	a0,a3
		move.l	d7,d4

		move.w	(a2)+,d0	;aktueller Wert
		move.w	(a2),d1		;nchster Wert

		move.w	d0,d2		;aktuell
		sub.w	d1,d2		;aktueller Wert - nchster Wert

		beq.s	set$		;nur setzen von Wert 0 und 1
		bgt.s	show2$
					;negativ, also mssen wir, wenn in der letzten Zeile
					;angefangen wird, nach oben

		neg	d2		;wird positiv gemacht (Schleifenzhler)
		neg.l	d4
show2$
		moveq	#0,d3
		lsr	#1,d2
		addx.w	d2,d3		;2. Loop (ein Pixel weiter)

		muls	d7,d0		;Offset der Zeile
		add.l	d0,a3		;+ Adr in der Bitmap
points1$
		or.b	d5,(a3)
		sub.l	d4,a3
		dbf	d2,points1$

		subq.w	#1,d3
		blt.s	set2$

		ror.b	d5
		bcc.s	nozw3$
		addq.l	#1,a0
		addq.l	#1,a3
nozw3$
points2$
		or.b	d5,(a3)
		sub.l	d4,a3
		dbf	d3,points2$
		bra.s	wei4$

set$		muls	d7,d1		;Offset der Zeile
		add.l	d1,a3		;+ Adr in Bitmap
		or.b	d5,(a3)
set2$
		ror.b	#1,d5
		bcc.s	no3$
		addq.l	#1,a0
		addq.l	#1,a3
no3$
		or.b	d5,(a3)
wei4$
		dbf	d6,Showthem_10$

		pop	d0-d7/a0-a5
		rts


;.points1
;	or.b	d5,(a0,d6.w)
;	sub.w	d0,d6
;	dbf	d2,.points1
;
;	subq.w	#1,d3
;	blt.s	.set2
;
;	ror.b	d5
;	bcc.s	.nozw3
;	addq.l	#1,a0
;.nozw3
;	or.b	d5,(a0,d1.w)
;	add.w	d0,d1
;	dbf	d3,.nozw3
;	bra.s	.wei4
;.set
;	or.b	d5,(a0,d6.w)
;.set2
;	ror.b	#1,d5
;	bcc.s	.no3
;	addq.l	#1,a0
;.no3
;	or.b	d5,(a0,d1.w)
;.wei4
;	subq.l	#1,samrest(a5)	
;	bne.s	.wei5
;	move.l	samlen(A5),samrest(a5)		;Samplelnge
;	move.l	samadr(A5),a1
;.wei5
;	dbf	d7,.mainloop3
		
;--- Darstellung Modus9, balken  2 Pixel breit, von oben nach unten oder umgekehrt mgl. ----
;Input: D0.l  - Offset horizontal (in Bytes)
;       D4.w  - Nummer der letzten Zeile
;	D1.w != 0 -> letzte Zeile mit $ff auffllen
Showthem_9:
		push	d0-d7/a0-a5

		move.l	myCustomBitmap(pc),a0
		moveq	#0,d7
		move	bm_bytesperrow(a0),d7
		move.l	bm_planes(a0),a0

		move	Updown(pc),d5
		bmi.s	down$
						;d4 bereits Offset fr letzte Zeile
		subq	#1,d4			; auf
		mulu	d7,d4			;  letzte 
		add.l	d4,a0			;   Zeile setzen

		tst	d1
		beq.s	nofill$

		move	d7,d5
		subq	#1,d5
		lea	(a0,d7.w),a1
fill$
		st	(a1)+
		dbf	d5,fill$
nofill$
		neg.l	d7
down$
		sub.l	d7,a0
		add.l	d0,a0

		moveq	#0,d4

		move	DisplayNum(a5),d6
		lsr	#2,d6
		subq	#1,d6
Showthem_9$
		move.l	a0,a3
		movem.w	(a2)+,d0-d3	;3 Werte auf einmal holen (Burst rules)
loop$
		add.l	d7,a3		;eine Zeile tiefer/hher

		moveq	#$55,d5		;Inititalwert, Bits werden nur dann 0, wenn Unterlauf erreicht
		subq	#1,d0		;bis Underflow, dann Ende
		addx	d4,d0		;bei Underflow wieder +1, damit beim nchsten Durchlauf wieder
					;x Bit gesetzt
		subx.b	d4,d5		;bei d0=0 -> Bit lschen
		rol.b	#2,d5		;nchster Wert

		subq	#1,d1		;bis Underflow, dann Ende
		addx	d4,d1
		subx.b	d4,d5
		rol.b	#2,d5

		subq	#1,d2		;bis Underflow, dann Ende
		addx	d4,d2
		subx.b	d4,d5
		rol.b	#2,d5

		subq	#1,d3		;Zhler -1
		addx	d4,d3		;+1 wenn Unterlauf, damit immer 0, wenn schon 0 war
		subx.b	d4,d5		;Bit lschen, wenn Unterlauf, sonst 1
;		rol.b	#2,d5		;nchster Wert

		move.b	d5,(a3)
		bne.s	loop$		;wenn d5.b = 0 -> alle 4 fertig

		addq.l	#1,a0
		dbf	d6,Showthem_9$

		pop	d0-d7/a0-a5
		rts
;----------------- Darstellung Modus20,Amplituden horizontal, jede 2. Zeile ------------------------------
Showthem_5l:
		push	d0-d6/a0/a2/a3

		move.l	myCustomBitmap(pc),a0
		moveq	#0,d3
		move	bm_bytesperrow(a0),d3
		move.l	bm_planes(a0),a0

		move	mybox_height(pc),d4	;
		add	d4,d4			;nun
		subq	#2,d4			; auf
		mulu	d3,d4			;  vorletzte 
		add.l	d4,a0			;   Zeile setzen

		moveq	#0,d1
		move	mybox_width(pc),d1
		lsr	#3+1,d1			;in Bytes umrechnen und /2
		and	#~1,d1
		add.l	d1,a0			;in die Mitte zentrieren

		move	d1,d5
		lsr	#1,d5			;Anzahl der Worte pro Zeile

		move	mybox_height(pc),d0	;nur jede 2. Zeile von height*2 Zeilen darstellen
		subq	#2,d0			;(Hhe der Box mal 2 (=kompletter Bereich))/2 - 1
showthem5$
		move.l	a0,a3

		move	d5,d6			;max. Worte pro Zeile
		move.l	(a2)+,d1
		bne.s	wei$

		subq	#1,d6
		move	#1,-(a3)
clrit$
		clr	-(a3)
		dbf	d6,clrit$
		bra.s	next$
wei$
		sub	d1,d6			;Worte pro Zeile - Worte to Print

		subq	#1,d1
		blt.s	nibble$
high$
		move	#-1,-(a3)
		dbf	d1,high$
nibble$
		swap	d1
		move	d1,-(a3)

clrold$
		clr	-(a3)
		dbf	d6,clrold$
next$
		sub.l	d3,a0			;2 Zeilen hher
		move.b	#1,-1(a0)
		sub.l	d3,a0
		move.b	#1,-1(a0)

		dbf	d0,showthem5$

		pop	d0-d6/a0/a2/a3
		rts
Showthem_5r:
		push	d0-d6/a0/a2/a3

		move.l	myCustomBitmap(pc),a0
		moveq	#0,d3
		move	bm_bytesperrow(a0),d3
		move.l	bm_planes(a0),a0

		move	mybox_height(pc),d4	;
		add	d4,d4			;nun
		subq	#2,d4			; auf
		mulu	d3,d4			;  vorletzte 
		add.l	d4,a0			;   Zeile setzen

		moveq	#0,d1
		move	mybox_width(pc),d1
		lsr	#3+1,d1			;in Bytes umrechnen und /2
		addq	#1,d1
		and	#~1,d1
		add.l	d1,a0			;in die Mitte zentrieren

		move	d1,d5
		lsr	#1,d5			;Anzahl der Worte pro Zeile

		move	mybox_height(pc),d0	;nur jede 2. Zeile von height*2 Zeilen darstellen
		subq	#2,d0			;(Hhe der Box mal 2 (=kompletter Bereich))/2 - 1
showthem5$
		move.l	a0,a3

		move	d5,d6
		move.l	(a2)+,d1
		bne.s	wei$

		subq	#1,d6
		move	#$8000,(a3)+
clrit$
		clr	(a3)+
		dbf	d6,clrit$
		bra.s	next$
wei$
		sub	d1,d6			;Worte pro Zeile - Worte to Print

		subq	#1,d1
		blt.s	nibble$
high$
		move	#-1,(a3)+
		dbf	d1,high$
nibble$
		swap	d1
		move	d1,(a3)+

clrold$
		clr	(a3)+
		dbf	d6,clrold$
next$
		sub.l	d3,a0			;2 Zeilen hher
		move.b	#$80,(a0)
		sub.l	d3,a0
		move.b	#$80,(a0)
		dbf	d0,showthem5$

		pop	d0-d6/a0/a2/a3
		rts
;--- Darstellung Modus8, Nur eine benutzte Zeile, von oben nach unten oder umgekehrt mgl. ----
Showthem_4:
		move.l	myCustomBitmap(pc),a0
		moveq	#0,d3
		move	bm_bytesperrow(a0),d3
		move.l	bm_planes(a0),a0

		move	Updown(pc),d5
		bmi.s	down$

		subq	#1,d4			; auf
		mulu	d3,d4			;  letzte 
		add.l	d4,a0			;   Zeile setzen
		neg.l	d3
down$
		move	myBox_width,d0
		lsr	#3,d0			;Num Balken  8 Pixel im Fenster
		subq	#1,d0
showthem4$
		move	(a2)+,d1
		muls	d3,d1
		move.b	#$fe,(a0,d1.l)
		addq.l	#1,a0
		dbf	d0,showthem4$
		rts
;-------------------------------------------------------------------------------------------
;--- Darstellung Modus3, Balken  8 Pixel *2, ber effiziente Tabelle,                   ---
;--- universell entweder jede 1. oder 2.  Zeile (je nach Tab), von oben nach unten oder  ---
;--- umgekehrt mgl.                                                                      ---
;--- !!! erfordert interleaved Bitmap !!!                                                ---
;Input: D7.l - letzte Zeile
Showthem_3:
		push	all

		move.l	myCustomBitmap(pc),a0
		moveq	#0,d3
		moveq	#0,d6
		move	bm_bytesperrow(a0),d3	;Breite pro Plane in Bytes
		move.b	bm_depth(a0),d6
		lea.l	bm_planes(a0),a0	;alle Planes auf einmal (interleaved rules)

		move	Updown(pc),d4
		bmi.s	down_3$
	;---- von unten nach oben ----
		mulu	d3,d7					;auf letzte Zeile setzen als Offset
		neg.l	d3
down_3$
		add	d3,d3

		move.l	EffTab(A5),a1		;Tabelle fr die Werte
		move.l	EffTabSize(A5),d0
		lsr.l	#1,d0			;durch 2 (=Hlfte der Tab)
		moveq	#0,d1
		move	myBox_height(pc),d1	;wird noch variiert nach Modus
		add.l	d1,d1
		add.l	d1,a1			;addieren
		move.l	d0,a4			;=2. Tab
		add.l	a1,a4			;2. Teil der Tabelle fr  x1  < x2

		move	myBox_height(pc),d5	;wird noch variiert nach Modus
		lsl	#2,d5			;hhe der Box * 2 Bytes pro Eintrag * 2

		subq	#1,d6			;wg. DBF

		move.l	a0,a5			;Planes
		move	myBox_width,d0
		lsr	#4,d0			;Num Balken  2*8 Pixel im Fenster
		subq	#1,d0
showthem3$
		move	(a2)+,d1		;Wert max. Maximum-1
		move	(a2)+,d2		;dito
		cmp	d2,d1
		bgt.s	tab1$

		sub	d2,d1			;d2 wird noch bentigt als Schleifenzhler
						;Unterschied zwischen D1 und D2
						;D1 dann negativ oder 0 (wir wollen ja hoch)
		add	d1,d1			;weil jeweils Wrter (2 Bytes)

		move	d3,d4			;Breite einer Zeile (negativ)
;		asr	#1,d4			;weil d3 schon doppelt so gro
		muls	d2,d4			;mal Zeilen (= zurckgehen in der Bitmap)
		add.l	d7,d4			;letzte Zeile (oder 0 fr Erste Zeile)

		swap	d0
		move	d6,d0
		swap	d6
allplanes31$
		move.l	(a0)+,a3		;Bitplane
		lea	(a4,d1.w),a6		;1. Tabelle, Offset
		add.l	d4,a3			;Offset in der Bitplane
		add	d5,d1

		move	d2,d6
balken31$	move.w	(a6)+,(a3)
		sub.l	d3,a3			;nchste bzw. vorherige Zeile
		dbf	d6,balken31$

		dbf	d0,allplanes31$
		swap	d0
		swap	d6
		move.l	a5,a0			;1. Bitplane
		addq.l	#2,d7			;2 Spalten weiter
		dbf	d0,showthem3$
		bra.s	rts3$
tab1$
		sub	d1,d2			;d1 wird noch bentigt als Schleifenzhler
						;Unterschied zwischen D1 und D2
						;da wir in der Tabelle zurckgehen, kommt d2 = neg.
						;ganz praktisch
		add	d2,d2			;weil jeweils Wrter (2 Bytes)

		move	d3,d4			;Breite einer Zeile (negativ)
;		asr	#1,d4			;weil d3 doppelt so gro
		muls	d1,d4			;mal Zeilen (= zurckgehen in der Bitmap)
		add.l	d7,d4			;letzte Zeile (oder 0 fr Erste Zeile

		swap	d0
		move	d6,d0
		swap	d6
allplanes3$
		move.l	(a0)+,a3		;Bitplane
		add.l	d4,a3			;Offset in der Bitplane
		lea	(a1,d2.w),a6		;1. Tabelle, Offset
		add	d5,d2

		move	d1,d6
balken3$	move.w	(a6)+,(a3)
		sub.l	d3,a3			;nchste bzw. vorherige Zeile
		dbf	d6,balken3$

		dbf	d0,allplanes3$
		swap	d0
		swap	d6

		move.l	a5,a0			;1. Bitplane
		addq.l	#2,d7			;2 Spalten weiter
		dbf	d0,showthem3$

rts3$
		pop	all
		rts
;down_3$
;		rts
;--- Darstellung Modus1, Balken  8 Pixel, jede 2. Zeile, von oben nach unten oder umgekehrt mgl. ----
;Input: D4.w - letzte Zeile
Showthem_1:
		move.l	myCustomBitmap(pc),a0
		moveq	#0,d3
		move	bm_bytesperrow(a0),d3
		move.l	bm_planes(a0),a0

		move	Updown(pc),d5
		bmi.s	down$

		subq	#1,d4			; auf
		mulu	d3,d4			;  letzte 
		add.l	d4,a0			;   Zeile setzen
		neg.l	d3
down$
		add.l	d3,d3			;jeweils eine Zeile berspringen

		move	myBox_width,d0
		lsr	#3,d0			;Num Balken  8 Pixel im Fenster
		subq	#1,d0
showthem1$
		move.l	a0,a3
		move	(a2)+,d1
		lsr	#1,d1			;wg. berspringung jeder 2. Zeile
balken$
		move.b	#$fe,(a3)
		add.l	d3,a3			;nchste bzw. vorherige Zeile
		dbf	d1,balken$
		addq	#1,a0
		dbf	d0,showthem1$
		rts
;--- Darstellung Modus1, Balken  8 Pixel, von oben nach unten oder umgekehrt mgl. ----
;Input: D4.w - letzte Zeile
Showthem_2:
		move.l	myCustomBitmap(pc),a0
		moveq	#0,d3
		move	bm_bytesperrow(a0),d3
		move.l	bm_planes(a0),a0

		move	Updown(pc),d5
		bmi.s	down2$

		subq	#1,d4
		mulu	d3,d4			;  letzte 
		add.l	d4,a0			;   Zeile setzen
		neg.l	d3
down2$

		move	myBox_width,d0
		lsr	#3,d0			;Num Balken  8 Pixel im Fenster
		subq	#1,d0
showthem12$
		move.l	a0,a3
		move	(a2)+,d1
balken2$
		move.b	#$fe,(a3)
		add.l	d3,a3			;nchste bzw. vorherige Zeile
		dbf	d1,balken2$
		addq	#1,a0
		dbf	d0,showthem12$
		rts
;-------------------------------------------------------------------------------------------------
Intowindow:
		push	all

		move.l	grafsave(a5),a6
		move.l	wd_rport(a0),a1		;Rastport (Ziel)

		move	myBox_left(pc),d2

		move	myBox_width(pc),d4	;Breite
		move	mybitmap_height(a5),d5	;Hhe

		move.l	myCustomBitmap(pc),d0
		beq.s	fail$
		move.l	d0,a0

		moveq	#0,d0			;X1
		moveq	#0,d1			;Y1

		move.b	#$c0,d6		;Miniterm
		jsr	_LVObltbitmaprastport(a6)
fail$
		pop	all
		rts

;------------------------------------------------------------------------------------
;                           Funktion: Init Spitzenwertanzeige
;Input:  D0 - # of Items to be displayed
;Output: D0 != 0 -> OK
;            = 0 -> Failure (Out of Memory)
InitMaxDisplay:
		push	d1-a6
		and.l	#$fff,d0		;4096 Werte sollten reichen :-)
		beq.s	fail$
		move.l	d0,d7
		lsl.l	#3,d0			;*8 (1+1 Word per Entry, 2 channels)
		move.l	#MEMF_Any!MEMF_Clear,d1 
		move.l	4.w,a6
		jsr	_LVOAllocMem(A6)
		move.l	d0,MaxDisplay1(a5)	;Tabelle fr Kanal 1
		beq	fail$
		move	d7,MaxDisplayNum(a5)	;Anzahl speichern
		lsl	#2,d7			;*4 (2. Kanal)
		add.l	d7,d0
		move.l	d0,MaxDisplay2(a5)

		bsr	ClearMaxDisplay

		pop	d1-a6
		moveq	#1,d0
		rts
fail$
		clr.l	MaxDisplay1(a5)
		clr.l	MaxDisplay2(a5)
		clr	MaxDisplayNum(a5)
		pop	d1-a6
		moveq	#0,d0
		rts
;------------------------------------------------------------------------------------
;                           Funktion: Freigabe Spitzenwertanzeige (Speicher)
;Input:  -
;Output: -
FreeMaxDisplay:
		push	all
		move.l	MaxDisplay1(A5),d0
		beq	fail$
		move.l	d0,a1
		moveq	#0,d0
		move	MaxDisplayNum(A5),d0
		lsl.l	#3,d0
		move.l	4.w,a6
		jsr	_LVOFreemem(A6)
fail$
		clr.l	MaxDisplay1(a5)
		clr.l	MaxDisplay2(a5)
		clr	MaxDisplayNum(a5)
		pop	all
		rts

;-------------------------------------------------------------------------------------
;                      Funktion: lsche Tabelle der Spitzenwertanzeige
;Input:  -
;Output: -
ClearMaxDisplay:
		push	d0/a0/a1

		move.l	MaxDisplay1(a5),d0
		beq	fail$
		move.l	d0,a0
		move.l	MaxDisplay2(a5),a1
		move	MaxDisplayNum(a5),d0
		subq	#1,d0
loop$
		clr.l	(a0)+		;2 Words per Entry
		clr.l	(a1)+
		dbf	d0,loop$
fail$
		pop	d0/a0/a1
		rts
;-------------------------------------------------------------------------------------
;                Funktion: Spitzenwertanzeige fr einen Kanal vorbereiten,
;                          Vergleich mit neuen Werten und Update der Tab
;
;Input:  A0 - neue Wertetab fr diesen Ausgabestream
;        A1 - MaxDisplayTabelle fr diesen Ausgabekanal
;Output: A1 - Tab zur Weiterverarbeitung (Anzeige)
;
; Aufbau der Tabelle: 1. Wort aktuelle Amplitude
;                     2. Wort Zeit, die diese Amplitude besteht
;
PrepareMaxDisplay:
		push	all

		moveq	#TimeOut,d4
		moveq	#0,d5
		move.b	slowcount(a5),d5
		divu	d5,d4

		move	MaxDisplayNum(a5),d0
		subq	#1,d0
loop$
		move	(a0)+,d1	;neuer Wert
		move	(a1)+,d2	;alter Wert
		cmp	d1,d2
		ble.s	new$
				;alter Wert grer
		move	(a1),d3		;Timeout
		subq	#1,d3
		bge.s	old$		;Timeout zhlen

		subq	#DownSpeed,d2	;Ausschlag verringern
		blt.s	skip$		;0 erreicht
		move	d2,-2(a1)	;Ausschlag abspeichern
		addq.l	#2,a1
		bra.s	next$
skip$		clr.w	-2(a1)		;Ausschlag 0 erreicht
		addq.l	#2,a1
		bra.s	next$

old$		move	d3,(a1)+	;Timeout noch nicht erreicht
		bra.s	next$
new$
		move	d1,-2(a1)
		move	d4,(a1)+
next$
		dbf	d0,loop$
		pop	all
		rts
;-------------------------------------------------------------------------------------
;                Funktion: Spitzenwertanzeige fr einen Kanal ausgeben
;
;Input:  A1   - MaxDisplayTabelle fr diesen Ausgabekanal
;        D4.w - letzte Zeile
;Output: -
;
MaxDisplayShow1:
		push	all
		move.l	myCustomBitmap(pc),a0
		moveq	#0,d3
		move	bm_bytesperrow(a0),d3
		move.l	bm_planes(a0),a0	;1. Bitplane

		move	Updown(pc),d5
		bmi.s	down_3$

		subq	#1,d4			; auf
		mulu	d3,d4			;  letzte 
		add.l	d4,a0			;   Zeile setzen

		neg.l	d3			;negieren, dann geht`s hoch statt runter
down_3$

		move	MaxDisplayNum(a5),d0
		subq	#1,d0
showthem$
		move	(a1)+,d1
		and	#~1,d1
		muls	d3,d1
		move.b	#$fe,(a0,d1.l)
		addq.l	#2,a1
		addq.l	#1,a0
		dbf	d0,showthem$
		pop	all
		rts

;--------------------------------- Tabellen erzeugen --------------------------------------------
InitFFT:
		push	all

		move.b	FreqBar(pc),d0		;Welche FFT benutzt wird ($40)
		and.b	#$40,d0
		beq.s	pt256$

		move	#Gamma_2,Current_Gamma(A5)	;512 pt Trafo
		move	#N_2,Current_Num(a5)
		move	#N_2/2,Current_NumOut(a5)
		move.l	#FFT_2,Current_FFT(a5)
		bra.s	takept$
pt256$
		move	#Gamma,Current_Gamma(A5)	;256 pt Trafo
		move	#N,Current_Num(a5)
		move	#N/2,Current_NumOut(a5)
		move.l	#FFT,Current_FFT(a5)
takept$
		move	Current_Gamma(A5),d1	;Anzahl der Bits
		bsr	MakeBitreversetabs	;Bitspiegelungstabelle
		bsr	MakeSinCostabs		;kombinierte Sinus/Cosinustabelle incl. Bitspiegelung

		pop	all
		rts
;------------------------------- Volume Tabelle zum Mixen erzeugen ------------------------------
;--------------------------------- 8 Bit signed Inputs erwartet ---------------------------------
;Input: D0 - Skalierungswert: "7" fr 4 Kanle, "6" fr 2 Kanle bei "SpecialUPS"
Makevoltable:
		lea	VTab,a0
;		move.l	a0,d1		;wird nur bei 8 Bit Tabellen gebraucht, zum Speedup
;		add.l	#511,d1
;		and.l	#~511,d1
;		move.l	d1,VTabAddr
;		move.l	d1,a0

		and.l	#$f,d0

		moveq	#0,d3		;volume

.lop		moveq	#0,d4		;data
.lap		move.b	d4,d5
		ext	d5
		muls	d3,d5
		asr.l	d0,d5		;Volume=6 Bit + 1 Bit, damit Amplitude von 2 gemixten Kanlen
					;max. 128
		move	d5,(a0)+
		addq	#1,d4
		cmp	#256,d4
		bne.b	.lap
		addq	#1,d3
		cmp	#65,d3
		bne.b	.lop
		rts
;------------------------- UPS-Struktur auswerten ---------------------------------------------
MixVoices:
	ifne	Eagleplayer			;fr Tests beim "Eagleplayer" Flag aus

		move.b	slowid(A5),d0		;nur jedes 2. oder 3. Frame etwas ausgeben ?
		addq.b	#1,d0
		cmp.b	slowcount(a5),d0	;<- wird erst beim ffnen des Fensters gesetzt
						;   auf momentan 1-3
		blt.s	lo$
	endc
		moveq	#0,d0
lo$		move.b	d0,slowid(a5)

	ifne	Eagleplayer

		beq.s	lo1$			;ausfhren der Darstellung
		
		tst.b	SpecialUPS(A5)		;UPS vom Amplifier ?
		bne	skiphim$		;ja, also brauchen wir nix tun
lo1$

		move.l	AN_Structadr(a5),a4	;Analyzer Struktur

		moveq	#%0101,d2		;wenn schon gemixte Daten vom Amplifier vorliegen
		tst.b	SpecialUPS(A5)		;dann werden diese beiden Kanle benutzt anstelle
		bne.s	nodmacon$		;da vorher noch die 4 Kanle der UPS Struktur
						;zusammengemixed werden mssen, spart Zeit

		moveq	#-1,d2			;Alle Kanle, wenn DMAon/off nicht unterstzt vom
						;Replay
		move.w	ups_flags(a4),d1
		and.w	#UPSB_Dmacon,d1		;Kanle an/aus untersttzt ?
		beq.s	nodmacon$

		move.w	UPS_Dmacon(a4),d2	;Ja,zugehrige Werte ranholen

			;Bitabfolge ndern wegen anderer Abfragereihenfolge der Kanle in dieser
			;Engine (Stimmen 1,4,2,3 wg. 1&4 = links, 2&3=rechts)
		move	d2,d0
		move	d2,d1
		and	#1,d2		;Bit 0 -> Bit 0

		lsr	#2,d0
		and	#2,d0
		or	d0,d2		;Bit 3 -> Bit 1

		and	#%0110,d1
		lsl	#1,d1
		or	d1,d2		;(Bit 1 und 2) << 1
nodmacon$
		lea	vol64(pc),a2		;fr den Fall, da "Mastervolume" ausgeschaltet

		move.l	myEPBase(pc),a4
		lea	EPG_someprefs(a4),a4
		move.l	(a4),d6
		and.l	#EGPRB_MasterVolume,d6 ;Mastervolume switch im EP an ?
		beq.s	.NoMaster

		move.l	myEPBase(pc),a2
		lea	EPG_Voice1vol(a2),a2	;ok, Lautstrkewerte der einzelnen Stimmen verwenden
.NoMaster

		lea	permerk(a5),a3	;SamplePeriod merken und Spielzeit der Samples in 1/50 Sekunden
					;je 32 Bit = 1LW pro Kanal

		move.l	AN_Structadr(a5),a4	;Analyzer Struktur
		bsr	GetADRLENVOLandPER	;Daten Channel 1 holen

		move.l	a0,a1			;Adresse    fr Channel 1
		move.l	d0,d4			;Restlnge  ---- "" -----
		move	d3,d5			;Period     ---- "" -----
		move.w	d1,d6			;Lautstrke ---- "" -----

		addq.l	#4,a3
		move.l	AN_Structadr(a5),a4	;Analyzer Struktur
		lea	UPS_Modulo*3(a4),a4	;4. Stimme
		bsr	GetADRLENVOLandPER	;Daten Channel 2 holen

		tst.b	slowid(A5)		;nur jedes 2. oder 3. Frame was tun ?
		bne.s	skiphim1$

		lea	Realtab,a6		;Zieladresse = Eingangswerte der FFT,
						;Reihe 1
		bsr	Mixit			;Mixen von Channel 1 und 2 bzw. nur Zoom wenn 
						;lediglich ein Channel
skiphim1$

		addq.l	#4,a3
		move.l	AN_Structadr(a5),a4	;Analyzer Struktur
		lea	UPS_Modulo*1(a4),a4	;2. Stimme
		bsr	GetADRLENVOLandPER

		move.l	a0,a1			;Adresse    fr Channel 1
		move.l	d0,d4			;Restlnge  ---- "" -----
		move	d3,d5			;Period     ---- "" -----
		move.w	d1,d6			;Lautstrke ---- "" -----

		addq.l	#4,a3
		move.l	AN_Structadr(a5),a4	;Analyzer Struktur
		lea	UPS_Modulo*2(a4),a4	;3. Stimme
		bsr	GetADRLENVOLandPER

		tst.b	slowid(A5)		;nur jedes 2. oder 3. Frame etwas ausgeben ?
		bne.s	skiphim$

		lea	Imgtab,a6		;Zieladresse, Eingangswerte fr die FFT
		bsr	Mixit			;2x8 Bit auf 1x16 Bit mit 16 kHz samplingrate
						;und max. Amplitude 128 mixen
skiphim$
	else
;--------------------------------- Testroutine -------------------------------------------
		bsr	MakeIntab		;Beispielwerte erzeugen

		lea	Testtab1,a0		;Adresse Daten Kanal 1
		move	#256,d0			;Lnge Kanal 1 (derzeit noch nicht ausgewertet)
		move	#224,d3			;Period Kanal 1
		move	#64,d1			;Lautstrke Kanal 1

		lea	Testtab1,a1		;Adr
		move	#256,d4			;Len
		move	#224,d5			;Per
		move	#64,d6			;Vol

		lea	Realtab,a6		;Zieladresse
		bsr	Mixit			;2 aus einen zusammenmixen

		lea	Testtab2,a0
		move	#256,d0
		move	#224,d3
		move	#64,d1

		lea	Testtab2,a1
		move	#256,d4
		move	#224,d5
		move	#0,d6			;

		lea	Imgtab,a6
		bsr	Mixit
	endc
		rts
;------------------------------------------------------------------------------------------------
;----                                Mixt 2 Stimmen zusammen                                 ----
;------------------------------------------------------------------------------------------------
;Input:
; a1 - Stimme 1 aktuelle Adresse
; d4 - Stimme 1 Restlnge
; d5 - Stimme 1 Period
; d6 - Stimme 1 Lautstrke (0..64)
;
; a0 - Stimme 2 aktuelle Adresse
; d0 - Stimme 2 Restlnge
; d3 - Stimme 2 Period
; d1 - Stimme 2 Lautstrke (0..64)
;
Mixit:
		push	all
		move.l	Mixfrequency(a5),d7	;16384*Sampleper (Achtung: erst bei offenem Fenster richtig gesetzt!)

		move.l	A1,d2
		beq.w	onlyone$

		and.l	#$ffff,d5

		move.l	d7,d2
		divu.l	d5,d2			;Period Kanal 1
		move.l	d2,d5
		add.l	d5,d5
		add.l	d5,d5
		swap	d5			;gebrochene Zahl fr die Skalierung beim Mixen

;		move.l	VTabaddr(pc),a2
		lea.l	VTab,a2
		add	d6,d6
		lsl	#8,d6
		add.l	d6,a2
						;d6 nun frei
		cmp.l	#$ffff,d4
		blo.s	less1$
		move.l	#30000,d4
less1$

		move.l	a0,d2
		beq	onlyone2$

		and.l	#$ffff,d3

		move.l	d7,d2
		divu.l	d3,d2			;Period Kanal 2
		move.l	d2,d3
		add.l	d3,d3
		add.l	d3,d3
		swap	d3			;gebrochene Zahl fr die Skalierung beim Mixen

;		move.l	VTabaddr(pc),a3
		lea.l	VTab,a3
		add	d1,d1
		lsl	#8,d1
		add.l	d1,a3
						;d1 nun frei
		cmp.l	#$ffff,d0
		blo.s	less2$
		move.l	#30000,d0
less2$

;------------------------ Mixen von 2 Kanlen gleichzeitig ---------------------------
		moveq	#0,d1			;Zhler fr Offset
		moveq	#0,d6			;Zhler fr Offset
		moveq	#0,d2			;Dummy fr addx Befehl
						;D4-Lnge Kanal 1
						;D0-Lnge Kanal 2
						;D5-Skalierung Kanal 1
						;D3-Skalierung Kanal 2
						;A2-Voltab 2
						;A3-Voltab 1

;		move	#N/2-1,d7
		move	Current_Num(a5),d7	;N
		lsr	#1,d7			;/2
		subq	#1,d7			;-1
MixIt$
		move	d0,a4		;Sichern
		move	d4,a5		;Sichern
		clr.w	d0

		move.b	(a0,d1.w),d0
		add.l	d3,d1
		addx	d2,d1
		move	(a3,d0.w*2),d4

		move.b	(a1,d6.w),d0
		add.l	d5,d6
		addx	d2,d6
		move	(a2,d0.w*2),d0
		add	d0,d4
		swap	d4

		move.b	(a0,d1.w),d0
		add.l	d3,d1
		addx	d2,d1
		move	(a3,d0.w*2),d4

		move.b	(a1,d6.w),d0
		add.l	d5,d6
		addx	d2,d6
		move	(a2,d0.w*2),d0
		add	d0,d4

		move.l	d4,(a6)+	;1 zusammengemixtes Wort aus zwei Channels
					;max. Amplitude pro Kanal ist 64 statt normal
					;128 wegen Overflow-Mglichkeit bei FFT Summierung

		move	a4,d0		;Restore
		move	a5,d4		;Restore
		cmp	d0,d1
		ble.s	lo1$
		moveq	#0,d1
lo1$
		cmp	d4,d6
		ble.s	lo2$
		moveq	#0,d6
lo2$
		dbf	d7,MixIt$
		bra.s	end$
onlyone2$
		move.l	a1,a0
		move.l	d5,d3
		move.l	d4,d0
		move.l	a2,a3
		bra.s	less3$
onlyone$
		move.l	a0,d2
		beq.s	none$

		move.l	d7,d2
		divu 	d3,d2			;Period Kanal 2
		moveq	#0,d3
		move.w	d2,d3
		add.l	d3,d3
		add.l	d3,d3
		swap	d3			;gebrochene Zahl fr die Skalierung beim Mixen

;		move.l	VTabaddr(pc),a3
		lea.l	VTab,a3
		add	d1,d1
		lsl	#8,d1
		add.l	d1,a3
						;d1 nun frei
		cmp.l	#$ffff,d0
		blo.s	less3$
		move.l	#30000,d0
less3$
;------------------------ Skalieren (Samplerate+Lautstrke) von 1 Kanal  ---------------------------

		moveq	#0,d6
		moveq	#0,d1			;Zhler fr Offset
		moveq	#0,d2			;Dummy fr addx Befehl
						;D0-Lnge Kanal 2
						;D3-Skalierung Kanal 2
						;A3-Voltab 1
;		move	#N/2-1,d7
		move	Current_Num(a5),d7	;N
		lsr	#1,d7			;/2
		subq	#1,d7			;-1
MixIt2$
		move.b	(a0,d1.w),d6
		add.l	d3,d1
		addx	d2,d1
		move	(a3,d6.w*2),d4
		swap	d4
		move.b	(a0,d1.w),d6
		add.l	d3,d1
		addx	d2,d1
		move	(a3,d6.w*2),d4
		move.l	d4,(a6)+
		dbf	d7,MixIt2$
		bra.s	end$
none$
;		move	#N/2-1,d7
		move	Current_Num(a5),d7	;N
		lsr	#1,d7			;/2
		subq	#1,d7			;-1
clr$		clr.l	(a6)+
		dbf	d7,clr$
end$
		pop	all
		rts
	ifne	Eagleplayer
;------------------------------------------------------------------------------------------------
;--------------- Restadresse, Restlnge, Lautstrke und Period-Wert aus der UPS-Struktur --------
;--------------- auslesen                                                                --------
;------------------------------------------------------------------------------------------------
;Input: d2 = DMA Mask (Bit 0 = dieser Kanal)
;       a3 = Zwischenspeicher fr Period und Spielzeit in 1/50 s des Samples des 
;            aktuellen Kanals (macht zwei Wrter)
;       a4 = UPS_Strukturanfang des aktuellen Kanals
;       a2 = Lautstrketabelle (Wrter, je eines pro Kanal, 0...64)
;            Wenn Mastervolumeuntersttzung nicht erwnscht, dann siehe unten
;
;Output:  d2 = DMA Mask fr nchsten Kanal (um 1 Bit gegenber Eingangswert nach rechts
;              geshiftet)
;         a2 = Pointer auf Lautstrke fr nchsten Kanal (Wort)
;         a3 (unverndert)
;         a4 (unverndert)
;         a0 = Adresse des Samples
;         d0 = Restlnge
;         d1 = Lautstrke
;         d3 = Period
GetADRLENVOLandPER:
		push	d4
		suba.l	a0,a0

		lsr.w	#1,d2
		bcc.w	.no
		move.l	UPS_Voice1Adr(a4),d1
		beq.s	.null
		move.l	d1,A0
		move.w	UPS_Voice1Per(a4),d3
		beq.s	.ok
		move.w	d3,(a3)
		clr.w	2(a3)

		moveq	#0,d4
		moveq	#0,d0
		move.w	UPS_Voice1len(a4),d0
		add.l	d0,d0		;Samplelnge Words -> Samplelnge Bytes
		bra.s	.cbm_ok		;bra.s	.copyto
.ok
		move	(a3),d3		;berhaupt keine Sampleperiod bergeben ?
		bne.s	.copyto
.null
		suba.l	a0,a0		;lea	nulls(a5),a0
		moveq	#0,d0		;move.w	#700,d0
		moveq	#0,d1
		bra.s	.no
.copyto
		moveq	#0,d0
		move.w	UPS_Voice1len(a4),d0
		add.l	d0,d0		;Samplelnge Words -> Samplelnge Bytes

		moveq	#0,d4
		move.w	2(a3),d4
		cmp.w	#$180,d4	;nur zur Sicherheit
		blo.s	.hi1
		clr.w	2(A3)
		clr.w	d4
.hi1
		swap	d4		;=d4*65535
		lsr.l	#2,d4
		divu	(a3),d4		;durch Sampleperiod
		and.l	#$ffff,d4
		lsl.l	#2,d4
		cmp.l	d0,d4		;grer als Samplelnge ?
		blo.s	.cbm_ok

		tst.w	ups_voice1repeat(a4)
		beq.s	.cbm_loop

		suba.l	a0,a0		;lea	nulls(a5),a0
		subq.w	#1,2(a3)
		clr.w	(a3)
		moveq	#0,d4
		moveq	#0,d0		;move.w	#700,d0
		bra.s	.cbm_ok
.cbm_loop
		tst.l	d0
		bne.s	.divu
		clr.w	2(a3)
		moveq	#0,d4
		move.w	#700,d0
		bra.s	.cbm_ok
.divu
		divu	d0,d4
		swap	d4
;		clr.w	2(a3)		;bloss raus lassen, dann sieht es
					;nochmal so gut aus !!
		and.l	#$ffff,d4
.cbm_ok
		add.l	d4,a0			;Sampleadr
						;D0: Samplelen
						;D3: SamplePer

		move.w	UPS_Voice1vol(a4),d1	;

		mulu	(A2)+,d1		;Mastervolume
		lsr.w	#6,d1			;kann normalerweise auch rausgelassen werden

		cmp	#63,d1
		bls.s	.vol_ok
		moveq	#63,d1
.vol_ok
		addq.w	#1,2(a3)
.no
		pop	d4
		rts
	endc
;****************************************************************************************************
;*                                                                                                  *
;*     erste FFT Routine, die bis N=256 ausgelegt ist, und komplett mit WORD-Arithmetik arbeitet    *
;*                                                                                                  *
;****************************************************************************************************
FFT:
		push	all

		lea	Realtab,a0
		lea	Imgtab,a1
;------------------------------- InitWerte ------------------------------------------------------
		move	#N/2*2,d1	;N2=N/2 (*2 wg. wortweisem Speicherzugriff)
		move.l	#Gamma-1,d2	;NU1=Gamma-1
		moveq	#0,d3		;K=0

		lea	SinCostab,a3	;Sinus- und Cosinustabelle fr N Werte, auf 256 bezogen
					;256*sin(x).w, 256*cos(x).w
					;

;;
;************************** Erster Durchlauf der FFT, Werte fr Sin x / Cos x bekannt ***********
;---------------------------------------- mit sin x = 0 und cos x = 1 ---------------------------
		move	d1,a2		;d1 sichern, somit DBF-Schleife mglich.
		move	d1,d7		;N2
		lsr	#1,d1
		add	d3,d7		;K+N2
		subq	#1,d1		;Schleife fr I bis N2
;------------------------- Innere Schleife des ersten Durchlaufs, N/2 mal durchlaufen -----------
R1_Innerloop$
		move	(a0,d7.w),d0	;XReal(k+N2)
;		move	d0,a5
;		move.l	#$100,d5

		move	(a1,d7.w),d4	;XImag(k+N2)
;		move	d4,d6

;		muls	d5,d0		;Xreal*cos
;		muls	d5,d4		;XImag*cos
;		swap	d5		;Sinuswert (spart genau einen Speicherzugriff
					;          (=1 Takt<>min. 3-5 Takte auf 060)

;		muls	d5,d6		;XImag*sin
;		add.l	d6,d0		;Treal= XReal*cos+Ximag*sin
;		asr.l	#Sinbase,d0	;wg. Integer-rechnung

		move	(a0,d3.w),d6	;XReal(K)
		sub	d0,d6		;minus Treal
		move	d6,(a0,d7.w)	;XReal(K+N2)=XReal(k)-TReal

		add	d0,d6		;-> =XReal(k)
		add	d0,d6		;Xreal(k)+TReal
		move	d6,(a0,d3.w)

;		move	a5,d0		;xreal(k+n2)

					;ximag*cos (siehe oben) ist in d4
;		muls	d5,d0		;xreal*sin
;		sub.l	d0,d4		;timag = ximag*cos - xreal*sin
;		asr.l	#sinbase,d4	;wg. integer-rechnung

		move	(a1,d3.w),d0	;XImag(K)
		sub	d4,d0		;minus TImag
		move	d0,(a1,d7.w)	;XImag(K+N2)=XImag(k)-TImag

		add	d4,d0		;-> =XImag(k)
		addq	#2,d7		;k+N2=k+N2+1
		add	d4,d0		;XImag(k)+TImag
		move	d0,(a1,d3.w)

		addq	#2,d3		;k=k+1
		dbf	d1,R1_Innerloop$
		move	a2,d1

		moveq	#0,d3		;K=0
		lsr	#1,d1		;N2=N2/2
		subq	#1,d2
;------------------------------ Ende Sonderbehandlung des 1. Durchlaufs -------------------------



;********************* zweiter Durchlauf der FFT, Werte fr Sin x / Cos x bekannt ****************

;----------------------------------------- mit sin x = 0 und cos x = 1 ---------------------------
		move	d1,a2		;d1 sichern, somit DBF-Schleife mglich.
		move	d1,d7		;N2
		lsr	#1,d1
		add	d3,d7		;K+N2
		subq	#1,d1		;Schleife fr I bis N2
;------------------------- Innere Schleife des ersten Durchlaufs, N/2 mal durchlaufen -----------
R2_Innerloop1$
		move	(a0,d7.w),d0	;XReal(k+N2)
;		move	d0,a5
;		move.l	#$100,d5

		move	(a1,d7.w),d4	;XImag(k+N2)
;		move	d4,d6

;		muls	d5,d0		;Xreal*cos
;		muls	d5,d4		;XImag*cos
;		swap	d5		;Sinuswert (spart genau einen Speicherzugriff
					;          (=1 Takt<>min. 3-5 Takte auf 060)

;		muls	d5,d6		;XImag*sin
;		add.l	d6,d0		;Treal= XReal*cos+Ximag*sin
;		asr.l	#Sinbase,d0	;wg. Integer-rechnung

		move	(a0,d3.w),d6	;XReal(K)
		sub	d0,d6		;minus Treal
		move	d6,(a0,d7.w)	;XReal(K+N2)=XReal(k)-TReal

		add	d0,d6		;-> =XReal(k)
		add	d0,d6		;Xreal(k)+TReal
		move	d6,(a0,d3.w)

;		move	a5,d0		;xreal(k+n2)

					;ximag*cos (siehe oben) ist in d4
;		muls	d5,d0		;xreal*sin
;		sub.l	d0,d4		;timag = ximag*cos - xreal*sin
;		asr.l	#sinbase,d4	;wg. integer-rechnung

		move	(a1,d3.w),d0	;XImag(K)
		sub	d4,d0		;minus TImag
		move	d0,(a1,d7.w)	;XImag(K+N2)=XImag(k)-TImag

		add	d4,d0		;-> =XImag(k)
		addq	#2,d7		;k+N2=k+N2+1
		add	d4,d0		;XImag(k)+TImag
		move	d0,(a1,d3.w)

		addq	#2,d3		;k=k+1
		dbf	d1,R2_Innerloop1$
		move	a2,d1
		add	d1,d3		;k=k+N2

		move	d1,d7		;N2
		lsr	#1,d1
		add	d3,d7		;K+N2
		subq	#1,d1		;Schleife fr I bis N2
;----------------------------------------- mit sin x = 1 und cos x = 0 ---------------------------
R2_Innerloop2$
		move	(a0,d7.w),d0	;XReal(k+N2)
		move	d0,a5
;		move.l	#$1000000,d5

		move	(a1,d7.w),d4	;XImag(k+N2)
		move	d4,d6

;		muls	d5,d0		;Xreal*cos
;		muls	d5,d4		;XImag*cos
;		swap	d5		;Sinuswert (spart genau einen Speicherzugriff
					;          (=1 Takt<>min. 3-5 Takte auf 060)

;		muls	d5,d6		;XImag*sin
;		add.l	d6,d0		;Treal= XReal*cos+Ximag*sin
;		asr.l	#Sinbase,d0	;wg. Integer-rechnung
		move	d6,d0	;!!

		move	(a0,d3.w),d6	;XReal(K)
		sub	d0,d6		;minus Treal
		move	d6,(a0,d7.w)	;XReal(K+N2)=XReal(k)-TReal

		add	d0,d6		;-> =XReal(k)
		add	d0,d6		;Xreal(k)+TReal
		move	d6,(a0,d3.w)

		move	a5,d0		;xreal(k+n2)

					;ximag*cos (siehe oben) ist in d4
;		muls	d5,d0		;xreal*sin
;		sub.l	d0,d4		;timag = ximag*cos - xreal*sin
;		asr.l	#sinbase,d4	;wg. integer-rechnung
		move	d0,d4	;!!

		move	(a1,d3.w),d0	;XImag(K)
;		sub	d4,d0		;minus TImag
		add	d4,d0	;!!

		move	d0,(a1,d7.w)	;XImag(K+N2)=XImag(k)-TImag

;		add	d4,d0		;-> =XImag(k)
		sub	d4,d0	;!!
		addq	#2,d7		;k+N2=k+N2+1
;		add	d4,d0		;XImag(k)+TImag
		sub	d4,d0	;!!

		move	d0,(a1,d3.w)

		addq	#2,d3		;k=k+1
		dbf	d1,R2_Innerloop2$
		move	a2,d1

		moveq	#0,d3		;K=0
		lsr	#1,d1		;N2=N2/2
		subq	#1,d2
;------------------------------ Ende Sonderbehandlung des 2. Durchlaufs -------------------------


;********************************** Hauptschleife ***********************************************
Outerloop$
;-------------------------- Innere Schleife1, N/2 mal durchlaufen -------------------------------
Innerloop2$
		move	d1,a2		;d1 sichern, somit DBF-Schleife mglich.
		move	d1,d7		;N2
		lsr	#1,d1
		add	d3,d7		;K+N2
		subq	#1,d1		;Schleife fr I bis N2
;--------------- Innere Schleife2, je nach Iterationstiefe N/2 bis 1 mal durchlaufen ------------
Innerloop$
		move	d3,d4		;M=K / 2^NU1
		move	(a0,d7.w),d0	;XReal(k+N2)
		lsr	d2,d4		;
		move	d0,a5
		and	#~1,d4
		move.l	(a3,d4.w*2),d5	;sin(p)*2^16 + cos(p)

		move	(a1,d7.w),d4	;XImag(k+N2)
		move	d4,d6

		muls	d5,d0		;Xreal*cos
		muls	d5,d4		;XImag*cos
		swap	d5		;Sinuswert (spart genau einen Speicherzugriff
					;          (=1 Takt<>min. 3-5 Takte auf 060)

		muls	d5,d6		;XImag*sin
		add.l	d6,d0		;Treal= XReal*cos+Ximag*sin
		asr.l	#Sinbase,d0	;wg. Integer-rechnung

		move	(a0,d3.w),d6	;XReal(K)
		sub	d0,d6		;minus Treal
		move	d6,(a0,d7.w)	;XReal(K+N2)=XReal(k)-TReal

		add	d0,d6		;-> =XReal(k)
		add	d0,d6		;Xreal(k)+TReal
		move	d6,(a0,d3.w)

		move	a5,d0		;xreal(k+n2)

					;ximag*cos (siehe oben) ist in d4
		muls	d5,d0		;xreal*sin
		sub.l	d0,d4		;timag = ximag*cos - xreal*sin
		asr.l	#sinbase,d4	;wg. integer-rechnung

		move	(a1,d3.w),d0	;XImag(K)
		sub	d4,d0		;minus TImag
		move	d0,(a1,d7.w)	;XImag(K+N2)=XImag(k)-TImag

		add	d4,d0		;-> =XImag(k)
		addq	#2,d7		;k+N2=k+N2+1
		add	d4,d0		;XImag(k)+TImag
		move	d0,(a1,d3.w)

		addq	#2,d3		;k=k+1
		dbf	d1,Innerloop$
		move	a2,d1

		add	d1,d3		;k=k+N2
		cmp	#N*2-1,d3
		blt.s	Innerloop2$

;------------------eine Komplette Iteration fertig, nchste Reihe------------------------------
		moveq	#0,d3		;K=0
		lsr	#1,d1		;N2=N2/2

		dbf	d2,Outerloop$	;NU1=NU1-1 -> bis NU1 = 0,umlaufen, bei <0 fertig

;-- Bitspiegelung der Ausgangswerte,Folge 1 und Folge 2 trennen und Power Spectrum --------------
		lea	Realtab,a0
		lea	Imgtab-RealTab(a0),a1
		lea	OutTab1-RealTab(a0),a2
		lea	OutTab2-RealTab(a0),a3
		lea	Bitreversetab-RealTab(a0),a6		;Tabelle fr IBR(M)
		moveq	#1,d0
		move	#N-1,d1
trennen$
		move	(a6,d0.w*2),d6
		move	(a6,d1.w*2),d7

		move	(a0,d6.w*2),d2		;Xreal(n)
		move	(a0,d7.w*2),d3		;Xreal(N-n)

		move	(a1,d6.w*2),d4		;Ximag(n)
		move	(a1,d7.w*2),d5		;Ximag(N-n)
		asr	#1,d2
		asr	#1,d3
		asr	#1,d4
		asr	#1,d5

		add	d3,d2
		move	d2,d6			;Hr=R(n)+R(N-n)
		bpl.s	.hi1
		neg.w	d6
.hi1
		sub	d5,d4			;Hi=I(n)-I(N-n)
		move	d4,d7
		bpl.s	.hi2
		neg.w	d7
.hi2		add	d6,d7

	ifeq	correct
		lsr	#Gamma-Extra_Resolution,d7	;Werte von 64*(2^Gamma) auf 64*(2^4)
		and	#$fff,d7
	else
		lsr	#Gamma-Extra_Resolution-3,d7	;Werte von 64*(2^Gamma) auf 64*(2^4)
	endc
		move	d7,(a2)+		;H(f)

		sub	d3,d2
		sub	d3,d2			;Gi=R(n)-R(N-n)
		bpl.s	.hi3
		neg.w	d2
.hi3
		add	d5,d4
		add	d5,d4			;Gr=I(n)+I(N-n)
		bpl.s	.hi4
		neg.w	d4
.hi4		add	d2,d4

	ifeq	correct
		lsr	#Gamma-Extra_Resolution,d4	;Werte von 64*(2^Gamma) auf 64*(2^4)
		and	#$fff,d7
	else
		lsr	#Gamma-Extra_Resolution-3,d4	;Werte von 64*(2^Gamma) auf 64*(2^4)
	endc
		move	d4,(a3)+			;G(f)

		addq	#1,d0
	ifeq	HalveSpectrum		;bei Anzeige des Spektrums reichen an sich die
		dbf	d1,trennen$	;positiven Frequenzen, da X(-f) = X(f) bei
	else				;reellen Eingangswerten wie Samples
							
		subq	#1,d1
		cmp	#N/2+1,d0
		blt.s	trennen$
	endc

;----------------------- Amplitudenkorrektur -------------------------------------------------------
	ifne	correct
Korrektur:
		lea	OutTab1,a0
		lea	OutTab2,a1

	ifeq	HalveSpectrum		;siehe oben
		move	#N-1,d0		;
	else				;
		move	#N/2-1,d0
	endc

		move	#[[$10000>>[3+1]]/N]*20,d2
		move	#$10000>>3,d1
correct$
		movem.w	(a0),d3-d4
		movem.w	(a1),d5-d6

		mulu	d1,d3
		mulu	d1,d4
		swap	d4
		move	d4,d3
		and.l	#$0fff0fff,d3

		mulu	d1,d5
		mulu	d1,d6
		swap	d6
		move	d6,d5
		and.l	#$0fff0fff,d5

		move.l	d3,(a0)+
		move.l	d5,(a1)+

		add.w	d2,d1
		dbf	d0,correct$
	endc

;----------------------- In Outtab1 nun power spectrum 1 und in Outtab2 spectrum 2 -----------------
;----------- Werte von 0 bis 256, N/2 davon reprsentieren die positiven Frequenzen ----------------
End$
		pop	all
		rts

;****************************************************************************************************
;*                                                                                                  *
;*         zweite FFT Routine, die bis N=512 mit 2 Eingangsreihen bei Eingangswerten von -128...127 *
;*         ausgelegt ist, und bei der der letzte Durchlauf in Longwort-Arithmetik erfolgt           *
;*                                                                                                  *
;****************************************************************************************************
FFT_2:
		push	all
		
		lea	Realtab,a0
		lea	Imgtab,a1
;------------------------------- InitWerte ------------------------------------------------------
		move	#N_2/2*2,d1	;N2=N/2 (*2 wg. wortweisem Speicherzugriff)
		move.l	#Gamma_2-1-2,d2	;NU1=Gamma-1

;----------------------------------------------------------------------------------------------
;                                      optimierter Loop 1
;----------------------------------------------------------------------------------------------
;1. Optimierung: beim 1. Durchlauf lediglich sin=0, cos=1 fr alle W^P, somit multiplikationslos
opt1_Outerloop$
		;---------------------- 1. Trivialloop --------------------

		lea	(a0),a2		;&realk
		lea	(a1),a4		;&imagk
		lea	(a2,d1.w),a5	;&realk+N2
		lea	(a4,d1.w),a6	;&imagk+N2

		lsr	#1,d1
		move	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		subq	#1,d7		;Schleife fr I bis N2
opt1_trivial1loop$			;Trivialflle, sin = 0, cos = 1
		move	(a5),d0
		move	(a2),d4
		move	(a6),d6
		move	(a4),d5
		move	d4,d3
		add	d0,d4
		sub	d0,d3
		move	d5,d0
		add	d6,d5
		move	d4,(a2)+
		move	d3,(a5)+
		sub	d6,d0
		move	d5,(a4)+
		move	d0,(a6)+
		dbf	d7,opt1_trivial1loop$

;----------------------------------------------------------------------------------------------
;                                      optimierter Loop 2
;----------------------------------------------------------------------------------------------
;1. Optimierung: beim 2. Durchlauf erste Hlfte sin=0, cos=1, 2. Hlfte sin=1, cos=0
;
opt2_Outerloop$
		;---------------------- 1. Trivialloop --------------------

		lea	(a0),a2		;&realk
		lea	(a1),a4		;&imagk
		move	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		lea	(a2,d1.w),a5	;&realk+N2
		lsr	#1,d7
		lea	(a4,d1.w),a6	;&imagk+N2
		subq	#1,d7		;Schleife fr I bis N2
opt2_trivial1loop$			;Trivialflle, sin = 0, cos = 1
		move	(a5),d0
		move	(a2),d4
		move	(a6),d6
		move	(a4),d5
		move	d4,d3
		add	d0,d4
		sub	d0,d3
		move	d5,d0
		add	d6,d5
		move	d4,(a2)+
		move	d3,(a5)+
		sub	d6,d0
		move	d5,(a4)+
		move	d0,(a6)+
		dbf	d7,opt2_trivial1loop$

		;---------------------- 2. Trivialloop --------------------

		lea	(a2,d1.w),a2	;realk = data + k
		lea	(a4,d1.w),a4	;imagk = data + k
		lea	(a2,d1.w),a5	;realkN2 = realk + N2
		lea	(a4,d1.w),a6	;imagkN2 = imagk + N2

		lsr	#1,d1
		move	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		subq	#1,d7		;Schleife fr I bis N2
opt2_trivial2loop$			;Trivialflle, sin = 1, cos = 0
		move	(a6),d0
		move	(a2),d4
		move	(a5),d6
		move	(a4),d5
		move	d4,d3
		add	d0,d4		;resreal = *realk + treal;
		sub	d0,d3
		move	d5,d0
		sub	d6,d5		;resimag = *imagk - timag;
		move	d4,(a2)+	;*realk++ = resreal;
		move	d3,(a5)+	;*realkN2++ = resreal - treal - treal;
		add	d6,d0
		move	d5,(a4)+	;*imagk++ = resimag;
		move	d0,(a6)+	;*imagkN2++ = resimag + timag + timag;
		dbf	d7,opt2_trivial2loop$

;-----------------------------------------------------------------------------------------------
;                                       Hauptschleife
;-----------------------------------------------------------------------------------------------
;
;89 Instruktionen
;
Outerloop$
		move	d2,d7
		swap	d7

		move	d1,d3
		lea	SinCostab+8,a3	;Sinus- und Cosinustabelle fr N Werte, auf 256 bezogen, die Eintrge der ersten 2 Trivialschleifen abgezogen

		;---------------------- 1. Trivialloop --------------------

		lea	(a0),a2		;&realk
		lea	(a1),a4		;&imagk
		lea	(a2,d1.w),a5	;&realk+N2
		lea	(a4,d1.w),a6	;&imagk+N2

		move.w	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		lsr.w	#1,d7
		subq.w	#1,d7		;Schleife fr I bis N2
trivial1loop$				;Trivialflle, sin = 0, cos = 1
		move	(a5),d0		;treal = *realkN2
		move	(a6),d6		;timag = *imagkN2
		move	(a2),d4		;*realk
		move	(a4),d5		;*imagk
		add	d0,d4		;resreal = *realk + treal;
		add	d6,d5		;resimag = *imagk + timag;
		move	d4,(a2)+	;*realk++ = resreal;
		sub	d0,d4
		move	d5,(a4)+	;*imagk++ = resimag;
		sub	d6,d5
		sub	d0,d4
		sub	d6,d5
		move	d4,(a5)+	;*realkN2++ = resreal - treal - treal;
		move	d5,(a6)+	;*imagkN2++ = resimag - timag - timag;
		dbf	d7,trivial1loop$

		;---------------------- 2. Trivialloop --------------------

		lea	(a2,d1.w),a2	;realk = data + k
		lea	(a4,d1.w),a4	;imagk = data + k
		lea	(a2,d1.w),a5	;realkN2 = realk + N2
		lea	(a4,d1.w),a6	;imagkN2 = imagk + N2

		move.w	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		lsr.w	#1,d7
		subq.w	#1,d7		;Schleife fr I bis N2
trivial2loop$				;Trivialflle, sin = 1, cos = 0
		move	(a6),d0		;treal = *imagkN2
		move	(a5),d6		;timag = *realkN2
		move	(a2),d4		;*realk
		move	(a4),d5		;*imagk
		add	d0,d4		;resreal = *realk + treal;
		sub	d6,d5		;resimag = *imagk - timag;
		move	d4,(a2)+	;*realk++ = resreal;
		sub	d0,d4
		move	d5,(a4)+	;*imagk++ = resimag;
		add	d6,d5
		sub	d0,d4
		add	d6,d5
		move	d4,(a5)+	;*realkN2++ = resreal - treal - treal;
		move	d5,(a6)+	;*imagkN2++ = resimag + timag + timag;
		dbf	d7,trivial2loop$

		lsl	#2,d3
		;----------- langsamer Teil der Hauptschleife ------------------
;		 // outerloop 2, 1 bis N/4 mal durchlaufen
slow_outerloop$
		lea	(a2,d1.w),a2	;realk = data + k
		lea	(a4,d1.w),a4	;imagk = data + k
		lea	(a2,d1.w),a5	;realkN2 = realk + N2
		lea	(a4,d1.w),a6	;imagkN2 = imagk + N2

;		 // innerloop, N/2 bis 1 mal durchlaufen
					;for( i = 0; i < N2; i++)
		move.w	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		lsr.w	#1,d7		;
		subq.w	#1,d7		;Schleife fr I bis N2

		move.l	(a3)+,d5	;sin<<16 + cos
slowloop$				;Standardfall mit variablen sin/cos-Werten
		move	(a5),d0		;*realkN2
		move	(a6),d6		;*imagkN2
		move	d0,d4
		muls	d5,d0		;*realkN2 * cos
		move	d6,d2
		muls	d5,d6		;*imagkN2 * cos
		swap	d5		;cos<<16 + sin
		muls	d5,d4		;*realkN2 * sin
		muls	d5,d2		;*imagkN2 * sin

		add.l	d2,d0		;treal = (*realkN2 * *cos1 + *imagkN2 * *sin1);
		sub.l	d4,d6		;timag = *imagkN2 * *cos1 - *realkN2 * *sin1;
		move	(a4),d2		;*imagk
		asr.l	#SinBase,d0	;Integer Shift
		move	(a2),d4		;*realk
		asr.l	#SinBase,d6	;Integer Shift, Tabellen um 2^8 verschoben

		add	d0,d4		;resreal = *realk + treal;
		move	d4,(a2)+	;*realk++ = resreal;
		sub	d0,d4
		add	d6,d2		;resimag = *imagk + timag
		sub	d0,d4
		move	d2,(a4)+	;*imagk++ = resimag;
		move	d4,(a5)+	;*realkN2++ = resreal - treal - treal;
		sub	d6,d2
		swap	d5		;sin<<16 + cos
		sub	d6,d2
		move	d2,(a6)+	;*imagkN2++ = resimag - timag - timag;

		dbf	d7,slowloop$

		add	d1,d3		;k+= N2<<1;
		add	d1,d3		;

		cmp	#N_2*2-1,d3	;while( k < N )
		blt.s	slow_outerloop$

		move.l	d7,d2
		swap	d2
		lsr	#1,d1		;N2 >>= 1;
		subq	#1,d2
		bgt	Outerloop$
;		dbf	d2,Outerloop$	;NU1=NU1-1 -> bis NU1 = 0,umlaufen, bei <0 fertig

		moveq	#0,d3		;K=0

;=====================================================================================================
;================== Letzer Durchlauf der FFT-Routine, hier jetzt Rechnen mit Longwords ===============
;=====================================================================================================
;---- Punkt, an dem von Integer-Rechnung auf LongInt umgeschwenkt wird aus berlaufgrnden -----------

		lea	Realtab,a0
		lea	Imgtab,a1
;-------------------------- Innere Schleife1, N/2 mal durchlaufen -------------------------------
		lea	RealtabLONG,a4
		lea	ImgtabLONG-RealtabLONG(a4),a6

		lea	SinCostab,a3	;Sinus- und Cosinustabelle fr N Werte, auf 256 bezogen
LONG_Innerloop2$
		move	d1,a2		;d1 sichern, somit DBF-Schleife mglich.
		move	d1,d7		;N2
		lsr	#1,d1
		add	d3,d7		;K+N2
		subq	#1,d1		;Schleife fr I bis N2
;--------------- Innere Schleife2, je nach Iterationstiefe N/2 bis 1 mal durchlaufen ------------

		move.l	(a3)+,d5
LONG_Innerloop$
;		move	d3,d4		;M=K / 2^NU1

		move	(a0,d7.w),d0	;XReal(k+N2)

;		lsr	d2,d4		;

		move	d0,a5

;		and	#~1,d4
;		move.l	(a3,d4.w*2),d5	;sin(p)*2^16 + cos(p)

		move	(a1,d7.w),d4	;XImag(k+N2)
		move	d4,d6

		muls	d5,d0		;Xreal*cos
		muls	d5,d4		;XImag*cos
		swap	d5		;Sinuswert (spart genau einen Speicherzugriff
					;          (=1 Takt<>min. 3-5 Takte auf 060)

		muls	d5,d6		;XImag*sin
		add.l	d6,d0		;Treal= XReal*cos+Ximag*sin
		asr.l	#Sinbase,d0	;wg. Integer-rechnung

		move	(a0,d3.w),d6	;XReal(K)
		ext.l	d6
		sub.l	d0,d6		;minus Treal
		move.l	d6,(a4,d7.w*2)	;move	d6,(a0,d7.w)	;XReal(K+N2)=XReal(k)-TReal

		add.l	d0,d6		;-> =XReal(k)
		add.l	d0,d6		;Xreal(k)+TReal
		move.l	d6,(a4,d3.w*2)	;d6,(a0,d3.w)

		move	a5,d0		;xreal(k+n2)

					;ximag*cos (siehe oben) ist in d4
		muls	d5,d0		;xreal*sin
		sub.l	d0,d4		;timag = ximag*cos - xreal*sin
		asr.l	#sinbase,d4	;wg. integer-rechnung

		move	(a1,d3.w),d0	;XImag(K)
		ext.l	d0
		sub.l	d4,d0		;minus TImag
		move.l	d0,(a6,d7.w*2)	;d0,(a1,d7.w)	;XImag(K+N2)=XImag(k)-TImag

		add.l	d4,d0		;-> =XImag(k)
		addq	#2,d7		;k+N2=k+N2+1
		add.l	d4,d0		;XImag(k)+TImag
		move.l	d0,(a6,d3.w*2)	;d0,(a1,d3.w)

		addq	#2,d3		;k=k+1
		dbf	d1,LONG_Innerloop$
		move	a2,d1

		add	d1,d3		;k=k+N2
		cmp	#N_2*2-1,d3
		blt.s	LONG_Innerloop2$

;********* Bitspiegelung der Ausgangswerte,Folge 1 und Folge 2 trennen und Power Spectrum **********
Trennen_2:
		lea	RealtabLONG,a0
		lea	ImgtabLONG,a1
		lea	OutTab1,a2
		lea	OutTab2,a3
		lea	Bitreversetab,a6		;Tabelle fr IBR(M)
		moveq	#1,d0
		move	#N_2-1,d1
trennen$
		move	(a6,d0.w*2),d6
		move	(a6,d1.w*2),d7

		move.l	(a0,d6.w*4),d2		;Xreal(n)
		move.l	(a0,d7.w*4),d3		;Xreal(N-n)

		move.l	(a1,d6.w*4),d4		;Ximag(n)
		move.l	(a1,d7.w*4),d5		;Ximag(N-n)

		add.l	d3,d2
		move.l	d2,d6			;Hr=R(n)+R(N-n)
		bpl.s	.hi1
		neg.l	d6
.hi1
		sub.l	d5,d4			;Hi=I(n)-I(N-n)
		move.l	d4,d7
		bpl.s	.hi2
		neg.l	d7
.hi2		add.l	d6,d7
	ifeq	correct
		lsr.l	#Gamma_2-Extra_Resolution,d7	;Werte von 64*(2^Gamma) auf 64*(2^4)
		and	#$fff,d7
	else
		lsr.l	#Gamma_2-Extra_Resolution-3,d7	;Werte von 64*(2^Gamma) auf 64*(2^4)
	endc
		move	d7,(a2)+		;H(f)

		sub.l	d3,d2
		sub.l	d3,d2			;Gi=R(n)-R(N-n)
		bpl.s	.hi3
		neg.l	d2
.hi3
		add.l	d5,d4
		add.l	d5,d4			;Gr=I(n)+I(N-n)
		bpl.s	.hi4
		neg.l	d4
.hi4		add.l	d2,d4
	ifeq	correct
		lsr.l	#Gamma_2-Extra_Resolution,d4	;Werte von 64*(2^Gamma) auf 64*(2^4)
		and	#$fff,d4
	else
		lsr.l	#Gamma_2-Extra_Resolution-3,d4	;Werte von 64*(2^Gamma) auf 64*(2^4)
	endc
		move	d4,(a3)+		;G(f)

		addq	#1,d0
	ifeq	HalveSpectrum
		dbf	d1,trennen$
	else
		subq	#1,d1
		cmp	#N_2/2+1,d0
		blt.s	trennen$
	endc
;----------------------- Amplitudenkorrektur -------------------------------------------------------
	ifne	correct
Korrektur_2:
		lea	OutTab1,a0
		lea	OutTab2,a1

	ifeq	HalveSpectrum
		move	#N_2-1,d0
	else
		move	#N_2/2-1,d0
	endc

		move	#[[$10000>>[3+1]]/N_2]*20,d2
		move	#$10000>>3,d1
correct$
		movem.w	(a0),d3-d4
		movem.w	(a1),d5-d6

		mulu	d1,d3
		mulu	d1,d4
		swap	d4
		move	d4,d3
		and.l	#$0fff0fff,d3

		mulu	d1,d5
		mulu	d1,d6
		swap	d6
		move	d6,d5
		and.l	#$0fff0fff,d5

		move.l	d3,(a0)+
		move.l	d5,(a1)+

		add.w	d2,d1
		dbf	d0,correct$
	endc
;----------------------- In Outtab1 nun power spectrum 1 und in Outtab2 spectrum 2 -----------------
End$
		pop	all
		rts

;------------------------------- Erzeugen der Bitspiegelungstabelle --------------------------------
;Input:  d1 = Tiefe der FFT: (8 = 256 Punkt, 9 = 512 Punkt usw.)
;Output: Bitreversetab = Butterflytab (Bitspiegelungstabelle)
MakeBitreversetabs:
		push	d0-d7/a0

		moveq	#1,d0
		lsl	d1,d0
		subq	#1,d0

		lea	Bitreversetab,a0
		moveq	#0,d6
Innerloop1$
		moveq	#0,d3
		move	d6,d2
		move	d1,d7
		subq	#1,d7
Innerloop2$
		roxr	#1,d2
		roxl	#1,d3
		dbf	d7,Innerloop2$
		move	d3,(a0)+

		addq	#1,d6
		dbf	d0,Innerloop1$

		pop	d0-d7/a0
		rts
;----------------------- Erzeugen der Sinus-und Cosinustabelle ----------------------------------
;-- die Werte werden gleich bitgespiegelt berechnet, so da die Bitspiegelung zur Adressierung --
;-- der Sinus-bzw. Cosinustabelle entfllt                                                     --
;-- Formel: SINBASE*sin(2*P/GAMMA); P=Bitspiegelung(I); 0<I<N                                 --
;------------------------------------------------------------------------------------------------
;Input:  d1 = Tiefe der FFT: (8 = 256 Punkt, 9 = 512 Punkt usw.)
;        Bitreversetab = Butterflytab (Bitspiegelungstabelle)
;Output: SinCostab = kombinierte Sinus/Cosinustabelle, jedem Wort der Sinuswerte folgt
;                    das Cos-Pendant
;        Berechnung lediglich mit halber Lnge, da jeder 2. Wert ohnehin redundant
MakeSinCostabs:
		push	d0-d7/a0-a6

		moveq	#1,d7			;1
		lsl	d1,d7			;2^Gamma
		move.l	d7,d6			;=N
		lsr	#1,d7
		subq	#1,d7			;N-1 wg. dbf

		lea	SinCostab,a1
		lea	Bitreversetab-SinCostab(a1),a2

		move.l	mathtrans(a5),a3
		move.l	mathffp(a5),a4

		move.l	a4,a6
		move.l	#6283185,d0		;2**10^6
		jsr	_LVOSPFlt(a6)
		move.l	d0,d4

		move.l	#1000000,d0
		jsr	_LVOSPFlt(a6)		;10^6
		move.l	d0,d1

		move.l	d4,d0
		jsr	_LVOSPDiv(a6)		;2
		move.l	d0,d5

		move.l	d6,d0
		jsr	_LVOSPFlt(a6)		;N
		move.l	d0,d1

		move.l	d5,d0
		jsr	_LVOSPDiv(a6)		;2/N
		move.l	d0,d5

		move.l	#2^SINBASE,d0		;256
		jsr	_LVOSPFlt(A6)
		move.l	d0,d6

		moveq	#0,d4
sincostab$
		moveq	#0,d0
		move	(a2,d4.w*2),d0		;P=IBR(M)
		move.l	a4,a6
		jsr	_LVOSPFlt(A6)		;in FFP umwandeln
		move.l	d5,d1			;2/N
		jsr	_LVOSPMul(a6)		;2/N*P
		move.l	d0,d3
		move.l	a3,a6
		jsr	_LVOSPSin(a6)		;sin(2*P/N)
		move.l	d6,d1
		move.l	a4,a6
		jsr	_LVOSPMul(A6)		;256*sin(...)
		jsr	_LVOSPFix(a6)
		move	d0,(a1)+		;sin*256

		move.l	d3,d0
		move.l	a3,a6
		jsr	_LVOSPCos(a6)		;cos(2*P/GAMMA)
		move.l	d6,d1
		move.l	a4,a6
		jsr	_LVOSPMul(A6)		;256*cos(...)
		jsr	_LVOSPFix(a6)
		move	d0,(a1)+		;cos*256

		addq	#2,d4		
		dbf	d7,sincostab$

		pop	d0-d7/a0-a6
		rts

;		incdir	sources:engines/
;		include	EngineStuff.i
;;

	ifne	Eagleplayer

;------------------------------------------------------------------------------------------------
;----------------------- Routinen, die mit den Engines zu tun haben -----------------------------
;------------------------------------------------------------------------------------------------
;
********************************************************************
*                  Init Message Struktur                           *
* Meldung an Eagleplayer, dass Engine erfolgreich gestartet wurde  *
********************************************************************
Sendfirstmessage
		move.l	4,a6
		lea	Portname(pc),a1
		jsr	_LVOfindport(a6)
		tst.l	d0
		beq.s	.error

		move.l	d0,a0			;Portadresse

		move.l	msgport(a5),d3
		move.l	mytask(a5),d4
		move.l	mysignal(a5),d5
		move.w	#USclass_Newuserprg,d6
	
	ifne	debug

		bsr	allocmsg
		beq.s	.error
		move.l	d0,a1			;Messageadresse

		move.w	#UM_sizeof-20,mn_length(a1)
		move.b	#nt_message,ln_type(a1) ;Message-Typ
		lea	begin(pc),a2
		move.l	a2,um_result(a1)
		move.w	#-2,UM_UserNr(a1)
		move.l	#USM_Userprg,UM_Type(a1)

		move.l	d3,mn_replyport(a1)	;Portadresse,an die
						;zurckgesendet wird
		move.l	d3,UM_Userport(a1)
		move.l	d4,UM_TaskAdr(a1)
		move.l	d5,UM_Signal(a1)
		move.w	d6,UM_class(a1)

		move.l	4,a6
		jsr	_LVOputmsg(a6)

	else
		bsr	sendmess
	endc

		moveq	#0,d7
		rts
.error
		moveq	#-1,d7
		rts
******************************************************************************
* Abschiedsgru an Eagleplayer,der dann wei,da der Analyzer geendet hat    *
******************************************************************************
Sendlastmessage:
		move.l	4,a6
		lea	Portname(pc),a1	;EaglePlayer finden
		jsr	_LVOfindport(a6)
		tst.l	d0
		beq.s	.ok	;Eagleplayer hat sich schon verabschiedet

		move.l	d0,a0			;Portadresse
		move.l	msgport(a5),d3
		moveq	#0,d4
		moveq	#0,d5
		move.w	#USclass_exit,d6

		bsr	sendmess
.wait
		move.l	MSGport(a5),a0
		jsr	_LVOwaitport(a6)
		move.l	MSGport(a5),a0
		jsr	_LVOgetmsg(a6)
		tst.l	d0
		beq.s	.wait
		move.l	d0,a1
		cmp.l	#USM_Userprg,UM_Type(a1)
		beq.s	.meine
.nichtmeine
		jsr	_LVOreplymsg(a6)
		bra.s	.wait
.meine
.ok
		rts
*******************************************************************************
sendmess:
		bsr	allocmsg
		bne.s	.ok
		rts
.ok
		move.l	d0,a1			;Messageadresse

		move.w	#UM_sizeof-20,mn_length(a1)
		move.b	#nt_message,ln_type(a1) ;Message-Typ
		move.l	#USM_Userprg,UM_Type(a1)

	ifne	debug
		move.w	saveusernr(a5),UM_UserNr(a1)
	else
		lea	begin(pc),a2
		move.w	EUS_Usernr(A2),UM_UserNr(a1)
	endc

		move.l	d3,mn_replyport(a1)	;Portadresse,an die
						;zurckgesendet wird
		move.l	d3,UM_Userport(a1)
		move.l	d4,UM_TaskAdr(a1)
		move.l	d5,UM_Signal(a1)
		move.w	d6,UM_class(a1)

		clr.l	UM_Command(a1)
		clr.l	UM_Result(A1)
		clr.l	UM_ArgString(A1)

		move.l	4,a6
		jmp	_LVOputmsg(a6)
*****************************************************************
allocmsg
		movem.l	d1-a6,-(sp)
		move.l	4,a6
		moveq	#UM_Sizeof,d0
		move.l	#$10001,d1
		jsr	_LVOallocmem(A6)
		movem.l	(sp)+,d1-a6
		tst.l	d0
		rts
*****************************************************************
freemsg
		moveq	#UM_sizeof,d0
		move.l	4,a6
		jsr	_LVOfreemem(A6)
		rts

;------------------------------------------------------------------------------------------------
;-------------------------------- Message an EnginePort ------------------------------------------
;------------------------------------------------------------------------------------------------
AN_msg:
		move.l	d0,a1

		move.l	MSGPort(a5),UM_Userport(a1)
		lea	begin(pc),a2

	ifne	debug
		move.w	um_usernr(a1),saveusernr(A5)
	else
		lea	begin(pc),a2
		move.w	EUS_Usernr(A2),UM_UserNr(a1)
	endc

		move.l	mytask(a5),UM_TaskAdr(a1)
		move.l	mysignal(a5),d1
		move.l	d1,UM_Signal(a1)

		move.w	UM_class(a1),d3		<-
		move.l	UM_Type(a1),d7
		move.w	UM_Signal(a1),d5 	<-
		move.l	UM_structadr(a1),d6 	<-

		lea	USClasstable1(pc),a3
classloop1$
		movem.l	(a3)+,d0/a0
		tst.l	d0
		beq.s	notfound1$
		cmp	d3,d0
		bne	classloop1$
		moveq	#0,d0
		push	d1-a6
		jsr	(A0)			;Einsprung in Routine
		pop	d1-a6
		bra.s	reply$
notfound1$
		move	#USClass_Dummy,UM_Class(a1)
reply$
		push	all
		bsr	HandleStruct
		pop	all

		move.l	mn_replyport(a1),d0
		cmp.l	MSGport(a5),d0		 ;eine von uns abgeschickte Message ?
		beq.s	.noreply
		move.l	4.w,a6
		jsr	_LVOreplymsg(a6)
.noreply
		cmp.l	#USM_Eagleplayer,d7	;Hat EaglePlayer was zu melden ?
		beq	.mess

		bsr	freemsg
.mess
		lea	USClasstable2(pc),a3
classloop2$
		movem.l	(a3)+,d0/a0
		tst.l	d0
		beq.s	notfound2$
		cmp	d3,d0
		bne	classloop2$
		moveq	#0,d0
		push	d1-a6
		jsr	(A0)			;Einsprung in Routine
		pop	d1-a6
notfound2$
		rts
;-----------------------------------------------------------------------------------
	endc


;;

;-------------------------------------------------------------------------------------------------
;----------------------------- ankommende Messages auswerten -------------------------------------
;-------------------------------------------------------------------------------------------------
HandleActions:
		bra.s	.ma2
.ma
		btst	d3,d0
		beq.s	.ma2

		bsr.w	ShowTheFuckingFFT

		bclr	d3,d0
		tst.l	d0
		beq	waitsig$
.ma2
		move.l	4,a6
		move.l	port(a5),d0
		beq.s	nowinport$
		move.l	d0,a0
		jsr	_LVOgetmsg(a6)
		tst.l	d0
		bne	.msg
nowinport$
	ifne	Eagleplayer

		move.l	msgport(a5),a0
		jsr	_LVOgetmsg(a6)
		tst.l	d0
		beq	waitsig$
		bsr	AN_msg
		blt	.exit
		bra	.ma2
	endc
waitsig$
		move.l	4,a6
		moveq	#0,d0
		move.l	port(a5),d1
		beq.s	.noport
		move.l	d1,a0
		move.b	mp_sigbit(a0),d1
		bset	d1,d0
.noport
	ifne	Eagleplayer
		move.l	msgport(a5),a0
		move.b	mp_sigbit(a0),d1
		bset	d1,d0
	endc
		move.l	mysignal(a5),d3
		tst.l	an_structadr(A5)
		beq.s	.nowaitsig
		bset	d3,d0
.nowaitsig
		jsr	_LVOwait(a6)
		bra	.ma
;------------------------------------------------------------------------------------------------
;----------------------------- Message an Window-Port -------------------------------------------
;------------------------------------------------------------------------------------------------
.msg
		move.l	d0,a1
		move.l	im_class(a1),d7
		move.w	im_code(a1),d5 		<-
		move.l	im_Iaddress(a1),d6 	<-

		cmp.l	#IDCMP_NEWSIZE,d7
		bne.w	.standard

		move.l	winhandle(A5),a0

		move	wd_width(a0),d0
		cmp	LastWinWidth(A5),d0
		bne	resize$
		move	wd_height(a0),d0
		cmp	LastWinHeight(A5),d0
		beq	.nonewsize
resize$
		move	wd_width(a0),LastWinWidth(A5)
		move	wd_height(a0),LastWinHeight(a5)
		bsr.w	RefreshALL
.nonewsize
.standard

		jsr	_LVOreplymsg(a6)

;------------------------------------- Refreshwindow ------------------------------------------------
;		cmp.l	#IDCMP_refreshwindow,d7
;		bne.s	.noref
;		bra	.ma2
;
;		move.l	Winhandle(A5),a0
;		bsr	NewCoordinates
;
;		move.l	CurrentMode(pc),d0
;		beq.s	.skip2
;		move.l	d0,a0
;		move.l	12(a0),a0
;		jsr	(a0)		;Clear Window des aktuellen Modus
;.skip2
;		bra	.ma2
;.noref
;---------------------------------- Taste gedrckt ? ------------------------------------------------
		cmp.l	#IDCMP_Vanillakey,d7
		bne.w	nokeys$

		sub.b	#`0`,d5
		beq	.ma2
		cmp.b	#5,d5
		bhi	.ma2
					;nur 1-5 erlaubt
		moveq	#0,d0
		move.b	d5,d0
		bra	K_setmode$
nokeys$
;---------------------------------- Gadget gedrckt ? -----------------------------------------------
		cmp.l	#IDCMP_Gadgetup,d7
		bne.w	.nogads

		move.l	d6,a1	
		move.w	GG_GadgetID(a1),d0
		beq.w	.ma2

K_setmode$
		cmp	LastGadNr(a5),d0
		beq.s	switchon$

		clr	LastModeOff(A5)		;letzter Modus der aktuellen Liste: 0

		move	d0,LastGadNr(a5)
		subq	#1,d0
		lsl	#NumGadEntries,d0	;jedes Gadget max. 15 mal belegt, Modes in Bytes ausgedrckt

		lea	GadModeslist(pc),a0
		moveq	#0,d2
		move.b	(a0,d0.w),d2
		bra.s	setmode$
switchon$
		move	LastModeOff(A5),d1
		addq	#1,d1
		move	d1,LastModeOff(A5)

		subq	#1,d0
		lsl	#NumGadentries,d0	;jedes Gadget max. 15 mal belegt, Modes in Bytes ausgedrckt
		add	d0,d1

		moveq	#0,d2
		lea	GadModeslist(pc),a0

		move.b	(a0,d1.w),d2		;noch einer im Revolver ?
		bne.s	setmode$

		clr	LastModeOff(A5)		;na gut, von vorne
		move.b	(a0,d0.w),d2
setmode$
		move.b	d2,ModePref

		push	d2
		move.l	CurrentMode(pc),a0	;aktuellen Anzeigemodus freigeben
		move.l	8(a0),a0
		jsr	(a0)
		pop	d2

		bsr	NewCurrentMode
	
		move.l	CurrentMode(pc),a0
		move.l	12(a0),a0
		jsr	(a0)			;Clear Window des aktuellen Modus

		move.l	CurrentMode(pc),a0
		move.l	(a0),a0
		jsr	(a0)			;Init des aktuellen Modus

		bra	.ma2
.nogads
;------------------------------------- Close Window ------------------------------------------------
		cmp.l	#CloseWindow,d7
		bne	.noclo
.closewinny
	ifne 	Eagleplayer
		bsr	closewin
		move.l	4,a6
		lea	Portname(pc),a1
		jsr	_LVOfindport(a6)
		tst.l	d0
		beq.w	.endme			;kein Eagleplayerport->Ende des Programmes
		move.l	d0,a0			;Portadresse
		move.l	msgport(a5),d3
		move.l	mytask(a5),d4
		move.l	mysignal(a5),d5
		move.w	#USclass_DeActivate,d6
		bsr	sendmess
		bra	.ma2
	else
		bra.s	.endme
	endc
.noclo
		cmp.l	#menupick,d7
		bne.w	.nomenu

		cmp.w	#menunull,d5
		beq	.ma2
		bra.s	.nextme
.next
		move.w	mi_nextselect(a1),d5
		cmp.w	#menunull,d5
		beq	.ma2
.nextme
		move.w	d5,d0
		move.l	intsave(A5),a6
		move.l	Project0Menus(A5),a0
		jsr	_LVOitemaddress(a6)
		tst.l	d0
		beq	.ma2
		move.l	d0,a1

		and.w	#$7FF,d5	;$7e0 bei einem Men,
					;untere Bits bis $1f Anzeiger fr weitere Mens

		lea	MenuTab(pc),a0
nextfromtab$
		move	(a0)+,d0
		bmi.s	.next
		move.l	(a0)+,d1
		cmp	d5,d0		;Itemnummer vergleichen
		bne.s	nextfromtab$

		move.l	d1,a0

		push	d1-a6
		moveq	#0,d0
		jsr	(a0)
		pop	d1-a6
		tst.l	d0
		blt	.endme
		bra.s	.next
.nomenu
		bra	.ma2
.endme
		moveq	#0,d7		;beim Eagleplayer abmelden !
		RTS
.exit		moveq	#-1,d7
		rts
RefreshALL:
	push	all
;------------------------------- Initialisierungen ---------------------------------------------------
	move.l	CurrentMode(pc),d0
	beq.s	.skip1
	move.l	d0,a0
	move.l	8(a0),a0		;Free des aktuellen Modus
	jsr	(a0)
.skip1

	move.l	Winhandle(A5),a0
	bsr	NewCoordinates		;Koordinaten fr Scope-Funktionen rauskriegen

	move.l	CurrentMode(pc),d0
	beq.s	.skip
	move.l	d0,a0
	move.l	12(a0),a0
	jsr	(a0)			;Clear Window des aktuellen Modus

	move.l	CurrentMode(pc),a0
	move.l	(a0),a0
	jsr	(a0)			;Init des aktuellen Modus
.skip
	pop	all
	rts
;------------------------- Setzt aktuellen Anzeigemodus ------------------------------------------
;Input: d2 - Nummer oder 0, dann default Mode
NewCurrentmode:
	push	d2/a0

	push	d2
	move.l	CurrentMode(pc),d2
	beq.s	.none
	move.l	d2,a0			;aktuellen Anzeigemodus freigeben
	move.l	8(a0),a0
	jsr	(a0)
.none
	pop	d2


	bsr	CheckCyberGFX
	beq.s	normalMODES$

;	bra.s	normalMODES$		;;!!;;!!

	subq.w	#1,d2
	bge.s	Cmode$
	moveq	#0,d2			;defmode = 0
Cmode$

	lea	CyberModeTab(pc),a0
	mulu	#20,d2			;mal 20
	lea	(a0,d2.w),a0
	move.l	a0,Currentmode

	move.l	16(a0),d2
	bsr	ShowFreqList		;Frequenzliste update

	pop	d2/a0
	rts
normalMODES$
	subq.w	#1,d2
	bge.s	mode$
	moveq	#0,d2			;defmode = 0
mode$
	lea	ModeTab(pc),a0
	mulu	#20,d2			;mal 20
	lea	(a0,d2.w),a0
	move.l	a0,Currentmode

	move.l	16(a0),d2
	bsr	ShowFreqList		;Frequenzliste update

	pop	d2/a0
	rts
;------- testet den aktuellen Displaymodus, ob es ein Cybergraphics Screen ist -------------------
;Input: winhandle
;Output: D0 = 1 -> Cybergfx
;           = 0 -> non Cybergfx
CheckCyberGFX:
		push	d1-a6
		moveq	#0,d0
		move.l	Winhandle(A5),d1
		beq.s	exit$
		move.l	d1,a0
		move.l	wd_wscreen(a0),a0
		lea.l	sc_viewport(a0),a0

		move.l	grafsave(A5),a6
		jsr	_LVOGetVPModeID(A6)
		cmp.l	#INVALID_ID,d0
		beq	exit$
		move.l	CGFXsave(a5),d1
		beq	exit$
		move.l	d1,a6
		jsr	_LVOIsCyberModeID(A6)
		tst.l	d0
		beq	exit$

		pop	d1-a6
		moveq	#1,d0
		rts
exit$
		pop	d1-a6
		moveq	#0,d0
		rts
;---------------------------- Fenster schlieen, Pubscreen freigeben usw. ------------------------
Closewin:
		push	all

		move	Color2(pc),d0		;schwarz, Hintergrundfarbe
		ext.l	d0
		bsr	FreePen

		move.l	CurrentMode(pc),d0	;aktuellen Anzeigemodus freigeben
		beq.s	.skip
		move.l	d0,a0
		move.l	8(a0),a0
		jsr	(a0)
.skip
		bsr	RemoveGadgets		;Gadgets vom Fenster nehmen
		bsr	FreeFont		;System default Font freigeben (wenn alloziert)

		move.l	Project0Menus(A5),d0
		beq.s	Project0NMenu$

		move.l	Winhandle(a5),a0
		move.l	Intsave(A5),a6
		jsr	_LVOClearMenuStrip(a6)

		move.l	GadSave(a5),a6
		move.l	Project0Menus(A5),a0
		jsr	_LVOFreeMenus(a6)
Project0NMenu$

		move.l	Gadsave(a5),a6
		move.l	Vi(A5),d0
		beq.s	novi$
		move.l	d0,a0
		jsr	_LVOFreeVisualInfo(a6)
novi$

		move.l	intsave(a5),a6
		suba.l	a0,a0
		move.l	mypubscreen(a5),d0
		beq.s	.nopub
		move.l	d0,a1
		jsr	_LVOunlockpubscreen(a6)	;PUBscreen freigeben
.nopub	

		move.l	Winhandle(a5),d0
		beq	.Project0WError
		move.l	d0,a0

	ifne	Eagleplayer
		lea	Begin(pc),a2
		move.w	wd_leftedge(a0),d4
		move.w	d4,eus_winx(a2)
		move.w	wd_topedge(a0),d4
		move.w	d4,eus_winy(a2)
		move	myInnerwidth,d0
		move	d0,Eus_Special(a2)
		move	myInnerheight,d0
		move	d0,eus_special+2(a2)
	endc
		jsr	_LVOClosewindow(A6)
.Project0WError

		clr.l	Vi(A5)
		clr.l	Project0Menus(A5)
		clr.l	mypubscreen(a5)
		clr.l	Winhandle(A5)
		clr.l	Port(A5)
		clr.l	mycmap(a5)
		pop	all
		rts
;-------------------------------------------------------------------------------------------------

;------------------- Fenster ffnen und alles Weitere (Bitmaps usw.) initialisieren --------------
OpenWin:
		push	d1-a6

		tst.l	winhandle(a5)		;schon offen ?
		bne.w	.Error2

		move.l	intsave(a5),a6

	ifne	Eagleplayer
		move.l	myEPBase(pc),d0		;Abfrage fr den Fall, da sich die Engine im Debug-Modus befindet,
						;normalerweise immer gesetzt
		beq.s	.noep
		move.l	d0,a0
		move.l	EPG_Pubscreen(a0),d0
.noep
		move.l	d0,a0
	else
		suba.l	a0,a0
	endc
		jsr	_LVOlockpubscreen(A6)	;aktuellen Publicscreen rauskriegen
		move.l	d0,mypubscreen(a5);fr UnLockpubscreen()
		beq.w	.Error2
		move.l	d0,a0

		lea.l	Project0WindowTags(pc),a1
		move.l	a0,Pubhier-Project0WindowTags(a1)

		moveq	#0,d0
		move.b	sc_wbortop(a0),d0
		add.b	sc_wborbottom(a0),d0

		move	#MinInnerWidth,d5
		move	#MinInnerHeight,d6
		
		move.b	gadgetson(pc),d4
		beq.s	nogads$
		move	#RandAbstandH*2+BevelabstandH*2+[Gadgets_Width+2]*Num_Gadgets,d5 ;Space X
		add	#Gadgets_Space+BoxInnenAbstandV,d6				;Space Y
nogads$
		move.l	sc_font(a0),a3
		move.w	ta_ysize(a3),d3		;Hhe des Screenfonts
		add	d0,d3			;Bordergre

		bsr	GetFont
		move.l	d0,font(A5)
		move.l	d0,a3

		move.b	FreqBar(pc),d4
		bpl.s	nofreq$

		add.w	tf_ysize(a3),d6		;noch einmal Fonthhe reservieren fr Anzeige der
						;Frequenzen
		add	#FreqBarExtra+BevelabstandV,d6		;fr Bevelbox
nofreq$
		add	d6,d3
		move	d3,minheight

		moveq	#0,d4
		move.b	SC_WBorLeft(a0),d4
		add.b	SC_WBorRight(a0),d4
		add	#16,d4
		add	d5,d4			;Breite des Sizing-Gadgets abziehen
		move	d4,minwidth

		lea	begin(pc),a0
	ifne	Eagleplayer
		move.w	eus_winx(a0),LeftHier+2-Project0WindowTags(a1)	;WinPosi x
		move.w	eus_winy(a0),TopHier+2-Project0WindowTags(a1)	;WinPosi y
	endc

	ifne	Eagleplayer
		move	Eus_Special(a2),d0				;Win Innerwidth
		cmp	d5,d0
		bgt.s	.hisize1
		move	d5,d0
.hisize1
		move.w	d0,Widthhier+2-Project0WindowTags(a1)

		move	Eus_Special+2(a2),d0				;Win Innerheight
		cmp	d6,d0
		bgt.s	.hisize2
		move	d6,d0
.hisize2	move.w	d0,Heighthier+2-Project0WindowTags(a1)
	endc

		suba.l	a0,a0
		jsr	_LVOOpenWindowTagList(a6)
		move.l	d0,Winhandle(a5)
		beq	.Project0WError

		move.l	d0,a0
		move.l	wd_userport(a0),a0	;User Port
		move.l	a0,port(a5)

		move.l	gadsave(a5),A6

		move.l	mypubscreen(a5),a0
		suba.l	a1,a1
		jsr	_LVOgetvisualinfoa(a6)	;Visual Info vom Screen anfordern
		move.l	d0,vi(a5)
		beq	.Project0WError

		bsr	SetMenuFlags		;Prefs auslesen und in NewMenu-Strukturen setzen

		lea.l	Project0NewMenu0(pc),a0
		lea.l	MTags0(pc),a1
		jsr	_LVOCreateMenusA(a6)
		move.l	d0,Project0Menus(A5)
		beq	.Project0WError

		move.l	d0,a0
		move.l	Vi(A5),a1
		lea.l	mtags0(pc),a2
		jsr	_LVOLayoutMenusA(a6)

		move.l	Winhandle(a5),a0
		move.l	Project0Menus(A5),a1
		move.l	intsave(A5),a6
		jsr	_LVOSetMenuStrip(a6)

		move.l	intsave(a5),a6
		suba.l	a0,a0
		move.l	mypubscreen(a5),d0
		beq.s	.nopub
		move.l	d0,a1
		jsr	_LVOunlockpubscreen(a6)	;PUBscreen freigeben
		clr.l	mypubscreen(a5)
.nopub	

;------------------------------- Initialisierungen ---------------------------------------------------
		move.l	#0<<24,d1		;Red
		move.l	#0<<24,d2		;Green
		move.l	#0<<24,d3		;Blue
		moveq	#0,d5
		bsr	AllocPen
		move	d0,Color2		;schwarz, Hintergrundfarbe


		move.l	Winhandle(A5),a0
		bsr	NewCoordinates		;Koordinaten fr Scope-Funktionen rauskriegen

		moveq	#0,d2
		move.b	modepref(pc),d2
		bsr	NewCurrentmode		;wenn Fenster neu geffnet, Check auf CGFX oder
						;nicht, damit nicht versehentlich Chunky auf AGA
						;oder umgekehrt...

		move.l	CurrentMode(pc),d0
		beq.s	.skip
		move.l	d0,a0
		move.l	12(a0),a0
		jsr	(a0)			;Clear Window des aktuellen Modus

		move.l	CurrentMode(pc),a0
		move.l	(a0),a0
		jsr	(a0)			;Init des aktuellen Modus
.skip
.Error2
		clr	LastWinWidth(a5)
		clr	LastWinHeight(A5)

		pop	d1-a6
		moveq	#0,d0
		rts
.Project0WError
		bsr	Closewin
		pop	d1-a6
		moveq	#-1,d0
		rts
;----------------------------- System default Font rauskriegen ------------------------------------
;----------------- einfach Dummy-Rastport erzeugen und dessen Font abfragen -----------------------
GetFont:
	push	d1/a0-a6

;	tst.b	onsysfont(A5)
;	beq.s	stand$

	move.l	grafsave(A5),a6
	lea.l	MyRastPort(a5),a3
	move.l	a3,a1
	jsr	_LVOInitrastport(A6)
	move.l	a3,a1
	lea.l	Attr(a5),a0
	jsr	_LVOAskFont(A6)
	lea.l	Attr(a5),a0
	jsr	_LVOopenfont(A6)
	move.l	d0,fontadr(A5)
	beq.s	stand$			;sollte laut Doku nicht vorkommen
	pop	d1/a0-a6
	rts
stand$
	move.l	mypubscreen(A5),a1	;kein Font ? Na gut, aber der ScreenFont ist garantiert da...
	lea.l	sc_RastPort(a1),a1
	move.l	rp_Font(a1),d0
	pop	d1/a0-a6
	rts
FreeFont
	push	d0-d1/a0-a1/a6

	move.l	fontadr(A5),d0
	beq.s	nofree$
	move.l	d0,a1
	move.l	grafsave(A5),a6
	jsr	_LVOclosefont(A6)
nofree$
	pop	d0-d1/a0-a1/a6
	rts
;-------------------------- Prefs in die NewMenu-Strukturen einsetzen --------------------------------
SetMenuFlags:
		push	all
		lea.l	Project0NewMenu0(pc),a0

		move	GadgetsFlags-Project0NewMenu0(A0),d0
		and	#~Checked,d0
		move.b	gadgetson(pc),d1
		beq.s	nogads$
		or	#Checked,d0
nogads$		move	d0,GadgetsFlags-Project0NewMenu0(A0)

		move	FreqdispFlags-Project0NewMenu0(A0),d0
		and	#~Checked,d0
		move.b	FreqBar(pc),d1
		bpl.s	nofreq$
		or	#Checked,d0
nofreq$		move	d0,FreqdispFlags-Project0NewMenu0(A0)

		move	Item_512Pt+GNM_Flags-Project0NewMenu0(A0),d0
		and	#~Checked,d0

		move.b	FreqBar(pc),d2
		and.b	#$40,d2
		beq.s	nosetpt$
		or	#Checked,d0
nosetpt$	move	d0,Item_512Pt+GNM_Flags-Project0NewMenu0(A0)

		move.b	speedNmix(pc),d0
		move.b	d0,d1
		and.w	#$f,d1
		bne.s	nomix0$
		moveq	#3,d1			;Default Mixrate (>0 !!)
nomix0$		
		lsr.b	#4,d0
		bne.s	noSpeed0$		
		moveq	#2,d0			;Default Framerate
noSpeed0$		

		push	d0/d1

		lea	MixrateMUTALitems-Project0NewMenu0(A0),a1
		moveq	#3-1,d3
loop1$
		move	gnm_Flags(a1),d2
		and	#~Checked,d2

		subq.b	#1,d1
		bne.s	noset$
		or	#Checked,d2
noset$		move	d2,gnm_Flags(a1)
		lea	gnm_SIZEOF(a1),a1
		dbf	d3,loop1$

		lea	SpeedMUTALitems-Project0NewMenu0(A0),a1
		moveq	#3-1,d3
loop2$
		move	gnm_Flags(a1),d2
		and	#~Checked,d2

		subq.b	#1,d0
		bne.s	noset2$
		or	#Checked,d2
noset2$		move	d2,gnm_Flags(a1)
		lea	gnm_SIZEOF(a1),a1
		dbf	d3,loop2$

;------------------- gleich noch Prefs fr Mixfrequenz und Frame-Counter setzen ---------------------
		pop	d0/d1

		subq	#1,d1
		lsl	#3,d1
		lea	MixfrequencyTAB(pc),a0
		move.l	(a0,d1.w),Mixfrequency(a5)
		move.l	4(a0,d1.w),UsedFreqlist(a5)

;		move.l	#16384*224,Mixfrequency(a5)	;15980 Hz =  8 kHz max.

		move.b	d0,slowcount(a5)

		pop	all
		moveq	#0,d0
		rts

;-----------------------------------------------------------------------------------------------------
;----------------------------------- Open Libs & diverse Inits ---------------------------------------
;-----------------------------------------------------------------------------------------------------
OpenLibs:
		push	d1-a6

		move.l	4.w,a6

		suba.l	A1,A1
		JSR	_LVOfindtask(A6)
		move.l	d0,mytask(a5)

		moveq	#-1,d0
		jsr	_LVOallocsignal(a6)	;Signal allokieren
		move.l	d0,mysignal(a5)
		blt	CloseProg$

	ifne	Eagleplayer
		jsr	_LVOcreatemsgport(a6)	;Messageport auf die schnelle Art
		move.l	d0,MSGport(a5)
		beq	CloseProg$
	endc

		lea	int(pc),a1
		moveq	#37,d0
		jsr	_LVOopenlibrary(a6)
		move.l	d0,intsave(a5)
		beq.s	CloseProg$

		lea	dos(pc),a1
		moveq	#33,d0
		jsr	_LVOopenlibrary(a6)
		move.l	d0,dossave(A5)
		beq	CloseProg$

		lea	graf(pc),a1
		moveq	#37,d0
		jsr	_LVOopenlibrary(a6)
		move.l	d0,grafsave(a5)
		beq.s	Closeprog$

		lea	gad(pc),a1
		moveq	#37,d0
		jsr	_LVOopenlibrary(a6)
		move.l	d0,gadsave(a5)
		beq.s	CloseProg$

		lea	mathffp_s(pc),a1
		moveq	#33,d0
		jsr	_LVOopenlibrary(a6)
		move.l	d0,mathffp(a5)
		beq.s	CloseProg$

		lea	mathtrans_s(pc),a1
		moveq	#33,d0
		jsr	_LVOopenlibrary(a6)
		move.l	d0,mathtrans(a5)
		beq.s	CloseProg$

		lea	cybergfx_s(pc),a1
		moveq	#40,d0
		jsr	_LVOopenlibrary(a6)
		move.l	d0,CGFXsave(a5)

		pop	d1-a6
		moveq	#1,d0
		rts
Closeprog$
		pop	d1-a6
		moveq	#0,d0
		rts

;-----------------------------------------------------------------------------------------------------
;----------------------------------- Close Libs & Rest freigeben -------------------------------------
;-----------------------------------------------------------------------------------------------------
CloseLibs
		push	d0-a6

	ifne	Eagleplayer
		move.l	4.w,a6
		move.l	MSGport(a5),d0
		beq.s	noport$
		move.l	d0,a0
		jsr	_LVOdeletemsgport(a6)
noport$
	endc

		move.l	mysignal(a5),d0
		blt.s	nosig$
		jsr	_LVOfreesignal(a6)
nosig$

		move.l	CGFXsave(a5),d0
		beq.s	nocgfx$
		move.l	d0,a1
		jsr	_LVOCloselibrary(a6)
nocgfx$

		move.l	mathffp(a5),d0
		beq.s	noffp$
		move.l	d0,a1
		jsr	_LVOCloselibrary(a6)
noffp$

		move.l	mathtrans(a5),d0
		beq.s	notrans$
		move.l	d0,a1
		jsr	_LVOCloselibrary(a6)
notrans$

		move.l	intsave(A5),d0
		beq.s	noint$
		move.l	d0,a1
		jsr	_LVOCloselibrary(a6)
noint$

		move.l	grafsave(A5),d0
		beq.s	nogfx$
		move.l	d0,a1
		jsr	_LVOCloselibrary(a6)
nogfx$

		move.l	gadsave(A5),d0
		beq.s	nogad$
		move.l	d0,a1
		jsr	_LVOCloselibrary(a6)
nogad$
		pop	d0-a6
		rts

	ifne	Eagleplayer

;------------------------------------------------------------------------------------------
;------------------------- Tabellen der Messageclasses -----------------------------------------
; Aufruf der jeweiligen Funktionen:
; A5 - lokale Variablentabelle
; A1 - Pointer auf UM Message
; A2 - Pointer auf EUS Struktur
;
; alle Register drfen getrashed werden 
;
;--- Tabelle 1 fr die Aktionen vor dem Reply der Message
;- Return: je nach Class wird UM_Class(a1) gelscht

USClasstable1:
		dc.l	USClass_exit,ExitPrepare
		dc.l	USClass_getconfig,ConfigPrepare
		dc.l	USClass_Activate,ShowWindow
		dc.l	USClass_Show,ShowWindow
		dc.l	USclass_Hide,CloseWin
		dc.l	USclass_DeActivate,CloseWin
		dc.l	USClass_KillModule,CleanUpWindow
		dc.l	0,0

;--- Tabelle 2 fr die Aktionen nach dem Reply der Message
;- Return = 0  -> Ok
;- Return = -1 -> Programm beenden
;
USClasstable2:
		dc.l	USClass_exit,DoExit
		dc.l	0,0

;------------------------ Fensterinhalt lschen --------------------------------------
CleanUpWindow:
		move.l	winhandle(a5),d0
		beq.s	skip$

		move.l	CurrentMode(pc),d0
		beq.s	skip$
		move.l	d0,a0
		move.l	12(a0),a0		;Clear Window
		jsr	(a0)
skip$
		rts
;------------------------ die entsprechenden Funktionen -------------------------------------------
ExitPrepare:
		clr.l	UM_Signal(a1)			;nix mehr da !
		clr.l	UM_Taskadr(a1)
		move	#USClass_Dummy,UM_Class(a1)
		moveq	#0,d0
		rts

ConfigPrepare:	;when this command comes,set the current preferences into
		;the Eagleengine-Structure (EUS_-structure at the beginning of the program)

		moveq	#0,d0
		move.l	winhandle(A5),d1		;Window
		beq.s	.prnowin			;no Window opened,no change
							;of preferences
		or.w	#eusb_openwin,d0		;set Flag: window is open

		move.l	d1,a0				;Window

		move.w	wd_leftedge(a0),d4
		move.w	d4,eus_winx(a2)

		move.w	wd_topedge(a0),d4
		move.w	d4,eus_winy(a2)

		move	myInnerwidth,d4
		move	d4,Eus_Special(a2)

		move	myInnerheight,d4
		move	d4,eus_special+2(a2)
.prnowin
		move.w	d0,eus_flags(a2)		;Save Flags

		move	#USClass_Dummy,UM_Class(a1)
		moveq	#0,d0
		rts
ShowWindow:

		move.l	Begin+EUS_EPBase(pc),a0
		move.l	EPG_SomePrefs(a0),d0
		btst	#EGPRF_Iconify,d0
		bne.s	.ok$

		bsr	Openwin
		tst.l	Winhandle(A5)
		bne.s	ok$
		move	#USClass_Dummy,UM_Class(a1)	;Fehler: konnte Fenster nicht ffnen
ok$		moveq	#0,d0
		rts
;-------------------------------------------------------------------------------------------------
HandleStruct:
		sf	SpecialUPS(A5)
		
		move.l	d6,an_structadr(a5)	;Analyzerstrukturadresse merken
		tst.l	d6
		bne.s	noclr$

		move.l	winhandle(a5),d0
		beq.s	skip$

		move.l	myEPBase(pc),d0
		beq	skip$
		move.l	d0,a0
		move.l	EPG_SomePrefs(a0),d0
		and.l	#EGPRB_PausePlay,d0
		bne	skip$

		move.l	CurrentMode(pc),d0
		beq.s	skip$
		move.l	d0,a0
		move.l	12(a0),a0		;Clear Window
		jsr	(a0)
skip$
		bra.s	ret$
noclr$
		moveq	#7,d0
		bsr	Makevoltable		;Umrechnungstabelle zum Mixen

		lea	begin(pc),a0			;na, haben wir nicht einen passenden Amplifier,
		move.l	EUS_EPBase(a0),a0		;der uns das Mixen erbrigt bzw. vereinfacht ?
		move.l	EPG_ActiveAmplifier(a0),d0	;
		beq.s	ret$				;
		move.l	d0,a0				;

		cmp.l	#`4CHN`,EUS_AMIDNr(a0)		;FastRamAmplifier aktiv ?
		beq.s	set2$				;ok, take it
		
		cmp.l	#`14BT`,EUS_AMIDNr(a0)		;14 Bit Amplifier aktiv ?
		beq.s	set$				;ok, take it

		cmp.l	#`TOCC`,EUS_AMIDNr(a0)		;14 Bit Amplifier aktiv ?
		beq.s	set$				;ok, take it

		cmp.l	#`8BIT`,EUS_AMIDNr(a0)		;8 Bit Amplifier aktiv ?
		bne.s	ret$				;noe, das andere tuts also auch
set$
		*move.l	EUS_Reserved5(a0),d0
		move.l	EUS_AMUPSStruct(a0),d0
		beq.s	ret$
		move.l	d0,an_structadr(a5)
		st	SpecialUPS(A5)

		moveq	#6,d0
		bsr	Makevoltable

ret$		moveq	#0,d0
		rts
set2$
		*move.l	EUS_Reserved5(a0),d0
		move.l	EUS_AMUPSStruct(a0),d0
		beq.s	ret$
		move.l	d0,an_structadr(a5)
		bra	ret$
DoExit:
		moveq	#-1,d0
		rts
	endc

;Input: none
myFreeBitmap
		push	d1-a6
		move.l	myCustomBitmap(pc),d0
		beq.s	none$
		move.l	d0,a0
		move.l	grafsave(a5),a6
		jsr	_LVOFreeBitmap(A6)
none$		clr.l	myCustomBitmap
		pop	d1-a6
		tst.l	d0
		rts
;Input: d2: Tiefe
;       d1: Hhe
;       holt sich fr den Rest die Speicherzellen
;
myAllocBitmap:
		push	d1-a6
		move.l	myCustomBitmap,d0
		beq.s	.weiter
		bsr	myFreeBitmap
.weiter
		moveq	#0,d0			;Breite
		move	myBox_width(pc),d0
		move	d1,mybitmap_height(a5)
		addq	#1,d1				;1 Zeile mehr zur Sicherheit
		moveq	#0,d3				;Flags: Bitmap vorher lschen
		suba.l	a0,a0
		move.l	grafsave(a5),a6
		jsr	_LVOAllocBitmap(A6)
		move.l	d0,myCustomBitmap
		pop	d1-a6
		tst.l	d0
		rts
;
; Tabellen fr hohe Effizienz des Kopierens in die Bitmap besonders bei mehreren Farben
; 
; Hhe der Tabellen: 2*Hhe des Fensters, in welches kopiert werden soll
;
; Trick: Bis zur Hlfte ist die Tabelle 1 rechts (tab2 links) leer, der Rest ist mit den
;        Bitplanewerten fr die entsprechenden Farben gefllt. Das heit, ist der Level Nr.1
;        z.B. um 30 hher als Level 2, so wird in der Liste um 30 zurckgegangen und dann wird
;        die Anzahl der Werte von Level 1 in die Bitmap bertragen.
;
;   _
;   _         -
;   _         -
;   _         -
;   _         -
;   __        -
;   __       --
;   __       --
;   __       --
;   __       --
;   __       --
;
;   Tab1     Tab2
;------------------------------------------------------------------------------------------
; Tabelle erzeugen, derzeit nur 2 Farben
;
; Input:  Color0, Color1,mybox_height
; Return: 0 fr Fehler, sonst 1
;
InitTable:	push	d1-a6
						;bentigte Tiefe berechnen
		move	Color2(pc),d1		;Hintergrund
		move	Color1(pc),d0		;Vordergrund
;		moveq	#1,d1			;Hintergrund schwarz
;		moveq	#0,d0			;Vordergrund
		move	d1,d6			;col 0
		move	d0,d7			;col 1

		cmp	d1,d0			;Welche Farbe hat die grere Farbtiefe ?
		bhi	thiscol$
		move	d1,d0
thiscol$
		moveq	#0,d1
colloop$	addq	#1,d1
		lsr	#1,d0
		bne.s	colloop$

		tst	d1			;da kann doch was nicht sein ?!
		beq	fail$

		move	myBox_height(pc),d0		;wird noch variiert nach Modus
		add	d0,d0				;2 mal die Hhe der Box ntig

		move	d0,d2				;spter benutzt
		bsr	Alloctable
		beq	fail$

;--------------------------------- eigentliche Routine -----------------------------------------
		move.l	d0,a0			;1. Teil der Tabelle fr  x1 >= x2
		move.l	EffTabSize(a5),d0
		lsr	#1,d0
		move.l	d0,a1
		add.l	a0,a1			;2. Teil der Tabelle fr  x1  < x2

		lsr	#1,d2			;Hlfte der Tab
		subq	#1,d2			;Hhe der Tabelle
		subq	#1,d1			;Tiefe -1

		move	d1,d5

		push	D6/D7
bpl1$		moveq	#0,d4
		moveq	#0,d0
		lsr	#1,d7
		bcc.s	noset1$
		move	#$FE00,d4
		move	#$FEFE,d0
noset1$
		lsr	#1,d6
		bcc.s	noset2$
		or	#$01FF,d4
		or	#$0101,d0
noset2$

		move	d2,d3
tab1teil1$	move	d4,(a0)+		;eine Bitplane des Worts, 1. Tabelle, 1.Teil
		dbf	d3,tab1teil1$

		move	d2,d3
tab1teil2$	move	d0,(a0)+		;eine Bitplane des Worts, 1. Tabelle, 2.Teil
		dbf	d3,tab1teil2$
		dbf	d5,bpl1$		;alle Bitplanes
		pop	D6/D7

		move	d1,d5
bpl2$		moveq	#0,d4
		moveq	#0,d0
		lsr	#1,d7
		bcc.s	noset4$
		move	#$00FE,d4
		move	#$FEFE,d0
noset4$
		lsr	#1,d6
		bcc.s	noset3$
		or	#$FF01,d4
		or	#$0101,d0
noset3$
		move	d2,d3
tab2teil1$	move	d4,(a1)+		;eine Bitplane des Worts, 2. Tabelle, 1.Teil
		dbf	d3,tab2teil1$

		move	d2,d3
tab2teil2$	move	d0,(a1)+		;eine Bitplane des Worts, 2. Tabelle, 2.Teil
		dbf	d3,tab2teil2$
		dbf	d5,bpl2$		;alle Bitplanes

		pop	d1-a6
		moveq	#1,d0
		rts
fail$
		pop	d1-a6
		moveq	#0,d0
		rts
;------------------------------------------------------------------------------------------
; Function Alloctable, alloziert gengend Fastmem fr die o.g. Tabellen
;
; Input:   word D0 - Hhe der Box (in Pixeln)
;          word D1 - Tiefe der Bitmap (in Bits)
;
; OutPut:     D0.l - Adresse der Tabelle oder 0 fr Fehler
;
Alloctable:	push	d1-a6

		move.l	EffTab(a5),d7
		beq.s	no1$
		bsr	FreeTable
no1$
		add	d0,d0			;mal 2 (Wortbreite)
		mulu	d1,d0			;mal Tiefe
		add.l	d0,d0			;wg. 2 Tabellen
		move.l	d0,EffTabSize(a5)	;immer durch 2 teilbar
		moveq	#MEMF_Public,d1
		move.l	4,a6
		jsr	_LVOallocmem(a6)
		move.l	d0,EffTab(A5)
		pop	d1-a6
		tst.l	d0
		rts
;------------------------------------------------------------------------------------------
FreeTable:	push	all

		move.l	EffTab(a5),d0
		beq.s	no$
		move.l	d0,a1
		move.l	EffTabSize(A5),d0
		beq	no$
		move.l	4,a6
		jsr	_LVOfreemem(A6)
no$
		clr.l	EffTab(A5)
		clr.l	EffTabSize(A5)
		pop	all
		rts

;************************************************************************************************
;*                    Ab hier die Cybergraphics Anzeige- und Hilfsroutinen                      *
;* Achtung: Bei Hinzufgen eines neuen Modus am Ende der Tabelle einen Dummy-Eintrag in der     *
;*          normalen Modetab vornehmen (z.B. Clonen existierender Modi)                         *
;************************************************************************************************

CyberModeTab:
 dc.l	Mode01Init,Mode01Scope,Mode01End,ClearWindow,0 ;alle 2 Zeilen, monochrom, von auen nach innen
 dc.l	Mode01Init,Mode02Scope,Mode01End,ClearWindow,0 ;alle 2 Zeilen, monochrom, von innen nach auen
 dc.l	Mode01Init,Mode03Scope,Mode01End,ClearWindow,0 ;jede Zeile, monochrom, von auen nach innen
 dc.l	Mode04Init,Mode04Scope,Mode04End,ClearWindowBlack,0 ;jede Zeile, 2 aus 256 Farben, von auen nach innen
 dc.l	Mode05Init,Mode05Scope,Mode04End,ClearWindowBlack,0 ;jede Zeile, 2 aus 256 Farben, von innen nach auen
 dc.l	Mode06Init,Mode06Scope,Mode06End,ClearWindow,0	;mit maxDisplay, von auen nach innen,
							;alle 2 Zeilen, monochrom
 dc.l	Mode06Init,Mode07Scope,Mode06End,ClearWindow,0	;mit maxDisplay, von innen nach auen,
							;alle 2 Zeilen, monochrom
 dc.l	Mode01Init,Mode08Scope,Mode01End,ClearWindow,0 ;nur 1 Zeichen, monochrom, von innen nach auen
 dc.l	Mode09Init,Mode09Scope,Mode01End,ClearWindowHBM,1 ;Balken  2 Bits breit, monochrom,
							;von unten nach oben
 dc.l	Mode10Init,Mode10Scope,Mode01End,ClearWindow,0  ;Balken  2 Bits breit, monochrom,
							;von aussen nach innen
 dc.l	Mode11Init,Mode11Scope,Mode01End,ClearWindow,0  ;Balken  2 Bits breit, monochrom,
							;von innen nach aussen
 dc.l	Mode12Init,Mode12Scope,Mode01End,ClearWindowHBM,0 ;jede Zeile, monochrom, von unten nach oben
 dc.l	Mode12Init,Mode13Scope,Mode01End,ClearWindowHBM,0 ;jede 2. Zeile, monochrom, von unten nach oben
 dc.l	Mode13Init,Mode14Scope,Mode06End,ClearWindowHBM,0 ;jede 2. Zeile, monochrom, von unten nach oben
						     ;mit MaxDisplay
 dc.l	Mode01Init,Mode15Scope,Mode01End,ClearWindow,0 ;jede Zeile, monochrom, von innen nach auen
 dc.l	Mode01Init,Mode16Scope,Mode01End,ClearWindow,0 ;nur 1 Zeichen, monochrom, von auen nach innen
 dc.l	Mode17Init,Mode17Scope,Mode01End,ClearWindow,0 ;durchgezogene Linie, monochrom, von auen nach innen

 dc.l	Mode12Init,Mode18Scope,Mode01End,ClearWindowHBM,0 ;nur 1 Zeichen, monochrom, von unten nach oben
 dc.l	Mode19Init,Mode19Scope,Mode01End,ClearWindowHBMBlack,0 ;jede Zeile, 2 aus 256 Farben, von unten nach oben

 dc.l	Mode20Init,Mode20Scope,Mode20End,ClearWindowHBM,2 ;Amplituden horizontal, jede 2. Zeile, monochrom
 dc.l	Mode17Init,Mode21Scope,Mode01End,ClearWindow,0 ;durchgezogene Linie, monochrom, von innen nach auen

 dc.l	CMode02Init,CMode02Scope,CMode02End,CClearWindowBlack_1,0 ;Multicolor 2 Bit, von auen nach innen
 dc.l	CMode02Init,CMode03Scope,CMode02End,CClearWindowBlack_1,0 ;Multicolor 2 Bit, von innen nach auen

 dc.l	CMode04Init,CMode04Scope,CMode04End,CClearWindowBlack_1,2 ;Multicolor 1 Bit, FFTScope Modus

 dc.l	CMode05Init,CMode05Scope,CMode05End,CClearWindowBlack_1,2 ;Multicolor 2 Bit, FFTScope 3D Modus
; dc.l	CMode01Init,CMode01Scope,CMode01End,CClearWindowGray_1,0 ;alle 2 Zeilen, monochrom, von auen nach innen

CMode01Init:
		bsr	FreeOldModes		;den Mll der anderen Modi beseitigen

		move.w	mybox_height(pc),d0
		bsr	MakeAmplitudetab	;Amplitudentabelle fr Darstellung im Fenster berechnen

		moveq	#0,d0
		move	myBox_width,d0
		lsr	#1,d0			;Num Balken a` 2 Pixel im Fenster, linker & rechter
						;Channel nebeneinander
		move	d0,Displaynum(a5)

		move.l	Winhandle(A5),a0
		move.l	wd_rport(a0),a0		;Rastport (Ziel)

		bsr	MakeTmpRP
		beq	fail$

		moveq	#0,d1			;Hhe
		move	myBox_height(pc),d1
		moveq	#0,d2
		bsr	myAllocCyberMap
fail$
		rts				;Returnwert schon gesetzt
CMode01Scope:
		move.l	myCyberMap(a5),d0
		beq	.skiphim2

		lea	OutTab1,a0
		move	#-1,Updown

		bsr	ClearCyberBitmapGray
		move	Displaynum(a5),d0
		bsr	Scale1_1				;in A2 TMPTAB

		moveq	#0,d0
		move	myBox_height(pc),d4	;Nummer der letzten Zeile
		moveq	#0,d1
		bsr	CShowthem_9

		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d4	;Y2
		bsr	CIntowindow

		lea	OutTab2,a0
		move	#1,Updown
		bsr	ClearCyberBitmapgray
		move	Displaynum(a5),d0
		bsr	Scale1_1				;in A2 TMPTab
		moveq	#0,d0
		move	myBox_height(pc),d4	;Nummer der letzten Zeile
		moveq	#0,d1
		bsr	CShowthem_9

		move.l	Winhandle(A5),a0
		move	myBox2_top(pc),d4	;Y2
		bsr	CIntowindow
.skiphim2	rts
CMode01End:
		bsr	FreeTmpRP
		bra	myFreeCyberMap		;alte Bitmap freigeben

**

CMode02Init:
		bsr	FreeOldModes		;den Mll der anderen Modi beseitigen

		move.w	mybox_height(pc),d0
		bsr	MakeAmplitudetab	;Amplitudentabelle fr Darstellung im Fenster berechnen

		moveq	#0,d0
		move	myBox_width,d0
		lsr	#1,d0			;Num Balken a` 2 Pixel im Fenster, linker & rechter
						;Channel nebeneinander
		move	d0,Displaynum(a5)

		move.l	Winhandle(A5),a0
		move.l	wd_rport(a0),a0		;Rastport (Ziel)

		bsr	MakeTmpRP
		beq	fail$

		moveq	#0,d1			;Hhe
		move	myBox_height(pc),d1
		moveq	#0,d2
		bsr	myAllocCyberMap
		beq	fail$

		move	myBox_height(pc),d0
		lea	MulticolorPenTab1(pc),a0
		moveq	#0,d1
		bsr	AllocColorsandColorList	;Anzahl der Farben zurck
		tst.l	d0
		bmi.s	fail$			;ruft Fail auf, ist aber "OK"

		rts
fail$
		bsr	CMode02End
		moveq	#-1,d0
		rts				;Returnwert schon gesetzt
CMode02Scope:
		move.l	myCyberMap(a5),d0
		beq	.skiphim2

		lea	OutTab1,a0
		move	#-1,Updown

		bsr	ClearCyberBitmapBlack
		move	Displaynum(a5),d0
		bsr	Scale1_1				;in A2 TMPTAB

		moveq	#0,d0
		move	myBox_height(pc),d4	;Nummer der letzten Zeile
		moveq	#0,d1
		bsr	CShowthem_1

		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d4	;Y2
		bsr	CIntowindow

		lea	OutTab2,a0
		move	#1,Updown
		bsr	ClearCyberBitmapBlack
		move	Displaynum(a5),d0
		bsr	Scale1_1				;in A2 TMPTab
		moveq	#0,d0
		move	myBox_height(pc),d4	;Nummer der letzten Zeile
		moveq	#0,d1
		bsr	CShowthem_1

		move.l	Winhandle(A5),a0
		move	myBox2_top(pc),d4	;Y2
		bsr	CIntowindow
.skiphim2	rts

CMode02End:
		lea	MulticolorPenTab1(pc),a0
		bsr	FreeColorsandColorList

		bsr	FreeTmpRP

		bra	myFreeCyberMap		;alte Bitmap freigeben

**

CMode03Scope:
		move.l	myCyberMap(a5),d0
		beq	.skiphim2

		lea	OutTab1,a0
		move	#1,Updown

		bsr	ClearCyberBitmapBlack
		move	Displaynum(a5),d0
		bsr	Scale1_1				;in A2 TMPTAB

		moveq	#0,d0
		move	myBox_height(pc),d4	;Nummer der letzten Zeile
		moveq	#1,d1
		bsr	CShowthem_1

		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d4	;Y2
		move	myBox_height(pc),d3	;Height
		addq	#1,d3
		bsr	CIntowindow2

		lea	OutTab2,a0
		move	#-1,Updown
		bsr	ClearCyberBitmapBlack
		move	Displaynum(a5),d0
		bsr	Scale1_1				;in A2 TMPTab
		moveq	#0,d0
		move	myBox_height(pc),d4	;Nummer der letzten Zeile
		moveq	#0,d1
		bsr	CShowthem_1

		move.l	Winhandle(A5),a0
		move	myBox2_top(pc),d4	;Y2
		addq	#1,d4
		move	myBox_height(pc),d3	;Height
		subq	#1,d3
		bsr	CIntowindow2
.skiphim2	rts

**

CMode04Init:
		bsr	FreeOldModes		;den Mll der anderen Modi beseitigen

		moveq	#0,d0			;nach Anzahl der Farben richten
		lea	MulticolorPenTab2(pc),a0
		moveq	#1,d1
		bsr	AllocColorsandColorList	;Anzahl der Farben zurck
		move	d0,Displaynum(A5)
		bge	on$

		moveq	#0,d0			;nach Anzahl der Farben richten
		lea	MulticolorPenTab3(pc),a0	;also B/W
		moveq	#0,d1
		bsr	AllocColorsandColorList	;Anzahl der Farben zurck
		move	d0,Displaynum(A5)
		bmi	fail$
on$
		bsr	MakeAmplitudetab	;Amplitudentabelle fr Darstellung im Fenster berechnen

		move.l	Winhandle(A5),a0
		move.l	wd_rport(a0),a0		;Rastport (Ziel)
		bsr	MakeTmpRP
		beq	fail$

		moveq	#0,d1
		move	myBox_height(pc),d1	;Height
		add	d1,d1

		moveq	#1,d0
		moveq	#1,d2
		bsr	myAllocCyberMap
fail$
		rts				;Returnwert schon gesetzt
CMode04Scope:
		move.l	myCyberMap(a5),d0
		beq	.skiphim2

		move	myBox_height(pc),d0	;Height
		add	d0,d0
		lea	OutTab1,a0
		lea	OutTab2,a1
		bsr	Scale2_1				;in A2 TMPTAB

		move	myBox_height(pc),d4	;Nummer der letzten Zeile
		add	d4,d4
		move	Displaynum(a5),d0
		bsr	CShowthem_4

		move.l	grafsave(a5),a6
		moveq	#1,d0			;1 nach links
		moveq	#0,d1			;selbe Zeile
		move	myBox_Left(pc),d2
		move	myBox1_Top(pc),d3
		move	myBox_Width(pc),d4
		move	myBox_Height(pc),d5
		add	d5,d5
		add	d2,d4
		add	d3,d5
		subq	#1,d4
		subq	#1,d5
		move.l	Winhandle(A5),a1
		move.l	WD_RPort(a1),a1
		jsr	_LVOScrollRaster(a6)

		move.l	Winhandle(A5),a0
		move.l	wd_rport(a0),a0		;Rastport (Ziel)

		move.l	myCyberMap(A5),a1

		move	myBox_left(pc),d0	;DestX
		add	myBox_width(pc),d0
		subq	#1,d0
		move	myBox1_top(pc),d1	;DestY

		move	d0,d2
		addq	#1,d2

		move	d1,d3
		add	CYM_Rows(a1),d3		;Hhe
		subq	#1,d3

		move.l	CYM_Plane(a1),a2	;Chunky Plane

		lea	MyTmpRastPort(A5),a1
		move.l	grafsave(a5),a6
		jsr	_LVOwritepixelarray8(A6)

.skiphim2	rts

CMode04End:
		lea	MulticolorPenTab2(pc),a0
		bsr	FreeColorsandColorList

		bsr	FreeTmpRP

		bra	myFreeCyberMap		;alte Bitmap freigeben

**

; FFTScope 3D Modus
;       ..
; ..    ..
; ......--
; ....--
; ..--
; --
;

CMode05Init:
		bsr	FreeOldModes		;den Mll der anderen Modi beseitigen

		moveq	#0,d0
		move.w	mybox_height(pc),d0
;		subq	#1,d0
		divu	#3,d0
		bsr	MakeAmplitudetab	;Amplitudentabelle fr Darstellung im Fenster berechnen

;		move.w	mybox_height(pc),d0	;Hhe / 2
;
;		move	d0,d1			;Hhe / 2
;		add	d1,d1			;*2
;
;		mulu	d0,d0			;a
;		mulu	d1,d1			;b
;
;		add.l	d1,d0			;a+b
;		move.l	mathffp(a5),a6
;		jsr	_LVOSPFlt(A6)		;in FFP umwandeln
;		move.l	mathtrans(a5),a6
;		jsr	_LVOSPSqrt(A6)		;Wurzel aus a+b (Pythagoras)
;		move.l	mathffp(a5),a6
;		jsr	_LVOSPFix(A6)		;in Longint umwandeln
;		move	d0,Displaynum(A5)

		move.w	mybox_height(pc),d0	;Hhe / 2
		move	d0,Displaynum(A5)

		move.l	Winhandle(A5),a0
		move.l	wd_rport(a0),a0		;Rastport (Ziel)
		bsr	MakeTmpRP
		beq	fail$

		moveq	#0,d1			;Hhe
		move	myBox_height(pc),d1
		add	d1,d1			;Gesamthhe
		addq	#6,d1
		moveq	#0,d2
		bsr	myAllocCyberMap
		beq	fail$

		bsr	ClearCyberBitmapBlack

		move	myBox_height(pc),d0	;Anzahl der Farben = Hhe/2
;		lea	MulticolorPenTab1(pc),a0
		lea	MulticolorPenTab4(pc),a0
		moveq	#0,d1
		bsr	AllocColorsandColorList	;Anzahl der Farben zurck
fail$
		rts				;Returnwert schon gesetzt

CMode05Scope:
		move.l	myCyberMap(a5),d0
		beq	.skiphim2

		push	d0/d1/a1/a2
		move.l	myCyberMap(a5),a1

		move	CYM_BytesPerRow(a1),d0
		move	CYM_Rows(a1),d1
		subq	#1+6,d1
		mulu	d1,d0

		lsr.l	#4,d0
		subq	#2,d0

		moveq	#0,d2
		move	CYM_BytesPerRow(a1),d2
		addq	#2,d2
		
		move.l	CYM_plane(a1),a1
		move.l	a1,a2
		add.l	d2,a2
clr$
		move.l	(a2)+,(a1)+
		move.l	(a2)+,(a1)+
		move.l	(a2)+,(a1)+
		move.l	(a2)+,(a1)+
		dbf	d0,clr$

		move.l	myCyberMap(a5),a1
		move	CYM_BytesPerRow(a1),d1
		move	d1,d2
		subq	#2,d2

		move	CYM_Rows(a1),d0
		subq	#1+6,d0

		move.l	CYM_plane(a1),a1
		add.l	d2,a1
		move	Color2(pc),d3
		move	d3,d4
		lsl	#8,d4
		or.b	d3,d4
clr2$
		move	d4,(a1)
		add	d1,a1
		dbf	d0,clr2$

		pop	d0/d1/a1/a2

		move	myBox_height(pc),d0	;Height
		lsr	#1,d0
		addq	#1,d0
		lea	OutTab1,a0
		lea	OutTab2,a1
		bsr	Scale2_1				;in A2 TMPTAB

		move.l	myCyberMap(a5),a0
		moveq	#0,d0
		move	CYM_BytesPerRow(a0),d0
		subq	#1,d0

		move	myBox_height(pc),d4	;Nummer der letzten Zeile
		sub	d4,d0		;letzte Position - Anzahl zu setzender Zeichen

		add	d4,d4
		bsr	CShowthem_5

		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d4	;Y2
		move	myBox_height(pc),d3	;Height
		add	d3,d3
		bsr	CIntowindow2
.skiphim2	rts

CMode05End:
		lea	MulticolorPenTab4(pc),a0
		bsr	FreeColorsandColorList

		bsr	FreeTmpRP

		bra	myFreeCyberMap		;alte Bitmap freigeben

**

;--------------------- Darstellung CGFX-Modus5, FFTScope 3D ---------------------------
;Input: D0.l  - Offset horizontal (in Bytes)
;       D4.w  - Nummer der letzten Zeile
CShowthem_5:
		push	d0-d7/a0-a5

		move.l	myCyberMap(a5),a0
		moveq	#0,d7
		move	CYM_BytesPerRow(a0),d7
		move.l	CYM_plane(a0),a0

						;d4 bereits Offset fr letzte Zeile
		subq	#1,d4			; auf
		mulu	d7,d4			;  letzte 
		add.l	d4,a0			;   Zeile setzen

		neg.l	d7			;rckwrts zhlen !

		and	#~1,d0
		add.l	d0,a0			;X-Offset

		moveq	#0,d4

		move	DisplayNum(a5),d6
		and	#~1,d6
		add	d6,a2			;Anzahl der gezeichneten Punkte auf Ausgangstab add, damit Bsse hinten, Hhen vorn angezeigt
		lsr	#1,d6
		subq	#1,d6


		move.l	MulticolTab(a5),a4
		move.w	mybox_height(pc),d0
		subq	#1,d0
		move.l	(a4,d0.w*4),a4		;Farbeintrge wortweise
Showthem_5$
		move.w	-(a2),d0		;(a2)+,d0 fr Bsse vorn angezeigt, s.o.
		move	(a4,d0.w*2),d1		;Farbwert

		move.l	a0,a3
loop$
		move.w	d1,(a3)
		add.l	d7,a3		;eine Zeile tiefer/hher
		dbf	d0,loop$

		addq.l	#2,a0
		add.l	d7,a0
		add.l	d7,a0
		dbf	d6,Showthem_5$

		pop	d0-d7/a0-a5
		rts

;-------------------- Darstellung CGFX-Modus4, FFTScope --------------------------------
;Input: D0.l  - Anzahl der Farben
;       D4.w  - Nummer der letzten Zeile
CShowthem_4:
		push	d0-d7/a0-a5

		move.l	myCyberMap(a5),a0
		moveq	#0,d7
		move	CYM_BytesPerRow(a0),d7
		move.l	CYM_plane(a0),a0

		subq	#1,d4			; auf
		move	d4,d6			;
		mulu	d7,d4			;  letzte 
		add.l	d4,a0			;   Zeile setzen

		move.l	MulticolTab(a5),a4
		subq	#1,d0
		move.l	(a4,d0.w*4),a4		;Farbeintrge wortweise
Showthem_4$
		move.w	(a2)+,d0
		move	(a4,d0.w*2),d1
		move	d1,(a0)
		sub.l	d7,a0
		dbf	d6,Showthem_4$

		pop	d0-d7/a0-a5
		rts

;-- Darstellung CGFX-Modus1, balken alle 2 Pixel, von oben nach unten oder umgekehrt mgl. --
;Input: D0.l  - Offset horizontal (in Bytes)
;       D4.w  - Nummer der letzten Zeile
;	D1.w != 0 -> letzte Zeile mit $ff auffllen
CShowthem_1:
		push	d0-d7/a0-a5

		move.l	myCyberMap(a5),a0
		moveq	#0,d7
		move	CYM_BytesPerRow(a0),d7
		move.l	CYM_plane(a0),a0

		move	Updown(pc),d5
		bmi.s	down$
						;d4 bereits Offset fr letzte Zeile
		subq	#1,d4			; auf
		mulu	d7,d4			;  letzte 
		add.l	d4,a0			;   Zeile setzen

		tst	d1
		beq.s	nofill$

		move	Multicol_Pen1(A5),d1
		move	d7,d5
		lsr	#1,d5
		subq	#1,d5
		lea	(a0,d7.w),a1
fill$
		move.w	d1,(a1)+
		dbf	d5,fill$
nofill$

		neg.l	d7
down$
		sub.l	d7,a0			;eine Zeile hher
		add.l	d0,a0

		moveq	#0,d4

		move	DisplayNum(a5),d6
		lsr	#1,d6
		subq	#1,d6

		move.l	MulticolTab(a5),a4
Showthem_1$
		movem.w	(a2)+,d0-d1
		move.l	(a4,d0.w*4),a1
		move.l	(a4,d1.w*4),a6

		cmp	d1,d0
		bge.s	ok$
		move	d1,d0
ok$
		move.l	a0,a3
loop$
		add.l	d7,a3		;eine Zeile tiefer/hher

		move	(a1)+,d1
		swap	d1
		move	(a6)+,d1
		move.l	d1,(a3)

		dbf	d0,loop$

		addq.l	#4,a0
		dbf	d6,Showthem_1$

		pop	d0-d7/a0-a5
		rts
;-- Darstellung CGFX-Modus9, balken alle 2 Pixel, von oben nach unten oder umgekehrt mgl. --
;Input: D0.l  - Offset horizontal (in Bytes)
;       D4.w  - Nummer der letzten Zeile
;	D1.w != 0 -> letzte Zeile mit $ff auffllen
CShowthem_9:
		push	d0-d7/a0-a5

		move.l	myCyberMap(a5),a0
		moveq	#0,d7
		move	CYM_BytesPerRow(a0),d7
		move.l	CYM_plane(a0),a0

		move	Updown(pc),d5
		bmi.s	down$
						;d4 bereits Offset fr letzte Zeile
		subq	#1,d4			; auf
		mulu	d7,d4			;  letzte 
		add.l	d4,a0			;   Zeile setzen

		tst	d1
		beq.s	nofill$

		move	d7,d5
		subq	#1,d5
		lea	(a0,d7.w),a1
fill$
		move.b	#2,(a1)+
		dbf	d5,fill$
nofill$
		neg.l	d7
down$
		sub.l	d7,a0			;eine Zeile hher
		add.l	d0,a0

		moveq	#0,d4

		move	DisplayNum(a5),d6
		lsr	#2,d6
		subq	#1,d6

		moveq	#0,d4
		moveq	#0,d5
Showthem_9$
		move.l	a0,a3
		movem.w	(a2)+,d0-d3	;4 Werte auf einmal holen (Burst rules)
loop$
		add.l	d7,a3		;eine Zeile tiefer/hher

		subq	#1,d0
		sge	d4
		swap	d4

		subq	#1,d1
		sge	d4

		subq	#1,d2
		sge	d5
		swap	d5

		subq	#1,d3
		sge	d5

		and.l	#$00010001,d4
		and.l	#$00010001,d5

		movem.l	d4/d5,(a3)
		bne.s	loop$		;wenn d5.l = 0 -> alle 4 fertig

		addq.l	#8,a0
		dbf	d6,Showthem_9$

		pop	d0-d7/a0-a5
		rts
;--------------------------------------------------------------------------
;  Skalieren der Ausgangswerte fr Breite/8 Balken und Lschen der Bitmap
;Input:  A0 - Tabelle der FFT Ergebnisse
;Output: A2 - in Anzahl und Amplitude skalierte Werte
CAuswert:
		bsr	ClearCyberBitmapGray
		bra	Scale1					;in A2 TMPTab

;---------------------------------------------------------------------------
;                    Bitmap komplett schwarz bzw. grau einfrben
;
ClearCyberBitmapBlack:
		push	d0/d1/a1/a2
		move	Color2(pc),d0
		moveq	#0,d1
		move.b	d0,d1
		lsl	#8,d0
		or.w	d0,d1
		move.w	d1,d0
		swap	d1
		move	d0,d1
		bra	ClearCyberBitmap_1
ClearCyberBitmapGray:
		push	d0/d1/a1/a2
		moveq	#0,d1
		bra	ClearCyberBitmap_1
ClearCyberBitmap_1:
		move.l	myCyberMap(a5),a1

		move	CYM_BytesPerRow(a1),d0
		mulu	CYM_Rows(a1),d0
		move.l	d0,a2			;letzte Reihe

		lsr.l	#4,d0			;durch 16
		subq	#1,d0
		move.l	CYM_plane(a1),a1
		add.l	a1,a2

		move.l	d1,d2			;2*4 Pixel
		move.l	d1,d3			;3*4 Pixel
		move.l	d1,d4			;4*4 Pixel

		movem.l	d1-d4,(a1)		;falls 16 Pixel weg durch das lsr#4
clr$
		movem.l	d1-d4,-(a2)
		dbf	d0,clr$

		pop	d0/d1/a1/a2
		rts

;--------------------------------------------------------------------------
;                       Copy Data to Cybergraphx Window
;Input:  a0 - Window
;        d4 - Y-Position
;Output: -
CIntoWindow:
		push	all

	ifeq	UseCyber

		move.l	wd_rport(a0),a0		;Rastport (Ziel)

		move.l	myCyberMap(A5),d0
		beq.s	none$
		move.l	d0,a1

		move	myBox_left(pc),d0	;DestX
		move	d4,d1			;DestY

		move	d0,d2
		add	myBox_width(pc),d2	;Breite
;		add	CYM_BytesPerRow(a1),d2	;SrcMod
		subq	#1,d2

		move	d1,d3
		add	CYM_Rows(a1),d3		;Hhe
		subq	#1,d3

		move.l	CYM_Plane(a1),a2	;Chunky Plane

		lea	MyTmpRastPort(A5),a1
		move.l	grafsave(a5),a6
		jsr	_LVOwritepixelarray8(A6)

	else

		move.l	wd_rport(a0),a1		;Rastport (Ziel)

		move.l	myCyberMap(A5),d0
		beq.s	none$
		move.l	d0,a0

		moveq	#0,d0			;SrcX
		moveq	#0,d1			;SrcY
		move	CYM_BytesPerRow(a0),d2	;SrcMod

		move	myBox_left(pc),d3	;DestX

		move	myBox_width(pc),d5	;Breite
		move	CYM_Rows(a0),d6		;Hhe

		moveq	#RECTFMT_LUT8,d7

		move.l	CYM_Plane(a0),a0	;Chunky Plane

		move.l	CGFXsave(a5),a6
		jsr	_LVOWritePixelArray(a6)

	endc
none$
		pop	all
		rts

;--------------------------------------------------------------------------
;                       Copy Data to Cybergraphx Window
;Input:  a0 - Window
;        d4 - Y-Position
;        d3 - Height
;Output: -
CIntoWindow2:
		push	all

	ifeq	UseCyber

		move.l	wd_rport(a0),a0		;Rastport (Ziel)

		move.l	myCyberMap(A5),d0
		beq.s	none$
		move.l	d0,a1

		move	myBox_left(pc),d0	;DestX
		move	d4,d1			;DestY

		move	d0,d2
		add	myBox_width(pc),d2	;Breite
		subq	#1,d2

		add	d1,d3
;		add	CYM_Rows(a1),d3		;Hhe
		subq	#1,d3

		move.l	CYM_Plane(a1),a2	;Chunky Plane

		lea	MyTmpRastPort(A5),a1
		move.l	grafsave(a5),a6
		jsr	_LVOwritepixelarray8(A6)

	else

		move.l	wd_rport(a0),a1		;Rastport (Ziel)

		move.l	myCyberMap(A5),d0
		beq.s	none$
		move.l	d0,a0

		moveq	#0,d0			;SrcX
		moveq	#0,d1			;SrcY
		move	CYM_BytesPerRow(a0),d2	;SrcMod

		move	myBox_left(pc),d3	;DestX

		move	myBox_width(pc),d5	;Breite
		move	CYM_Rows(a0),d6		;Hhe

		moveq	#RECTFMT_LUT8,d7

		move.l	CYM_Plane(a0),a0	;Chunky Plane

		move.l	CGFXsave(a5),a6
		jsr	_LVOWritePixelArray(a6)

	endc
none$
		pop	all
		rts

;------------------------------------------------------------------------------------------------
;fr Modi, bei denen linker und rechter Kanal in der Anzeige  bereinander liegen
;
CClearWindowBlack_1:
		push	all
		move	Color2(pc),d0
		bhs.s	ok$
		moveq	#1,d0
ok$
		bsr	Showbevel

		bsr	ClearMaxDisplay		;safe to Call

		move.l	myCyberMap(a5),d0
		beq	fail$

		bsr	ClearCyberBitmapBlack

		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d4	;Y2
;		bsr	CIntoWindow

		move.l	Winhandle(A5),a0
		move	myBox2_top(pc),d4	;Y2
;		bsr	CIntoWindow
fail$
		pop	all
		rts
;------------------------------------------------------------------------------------------------
;fr Modi, bei denen linker und rechter Kanal in der Anzeige  bereinander liegen
;
CClearWindowGray_1:
		push	all
		moveq	#0,d0
		bsr	Showbevel

		bsr	ClearMaxDisplay		;safe to Call

		move.l	myCyberMap(a5),d0
		beq	fail$

		bsr	ClearCyberBitmapGray

		move.l	Winhandle(A5),a0
		move	myBox1_top(pc),d4	;Y2
		bsr	CIntoWindow

		move.l	Winhandle(A5),a0
		move	myBox2_top(pc),d4	;Y2
		bsr	CIntoWindow
fail$
		pop	all
		rts

;--------------Initialisiert temporren RastPort fr WritePixelarray8 ----------------
;Input: none (Globals)
;OutPut: D0 = 0 -> Fehler
MakeTmpRP:
		push	d1-a6

		lea	MyTmpRastPort(A5),a1
		lea	(a1),a2
		moveq	#RP_Sizeof-1,d0
CopyPort$	move.b	(a0)+,(a1)+
		dbf	d0,CopyPort$
		clr.l	RP_Layer(a2)

		moveq	#0,d0				;Breite
		move	myBox_width(pc),d0
		add	#15,d0
		and	#~15,d0
		moveq	#1,d1				;1 Zeile mehr zur Sicherheit
		moveq	#8,d2
		moveq	#0,d3				;Flags: Bitmap vorher lschen
		suba.l	a0,a0
		move.l	grafsave(a5),a6
		jsr	_LVOAllocBitmap(A6)
		move.l	d0,MyTmpRastPortBM(a5)
		move.l	d0,RP_Bitmap(a2)
		pop	d1-a6
		rts

;------------------ Bitmap fr WritePixelArray8 freigeben ---------------------

FreeTmpRP:
		push	all

		move.l	MyTmpRastPortBM(a5),d0
		beq.s	nomap$
		move.l	d0,a0
		move.l	grafsave(a5),a6
		jsr	_LVOFreeBitmap(A6)
		clr.l	MyTmpRastPortBM(a5)
nomap$
		pop	all
		rts

;------------------------------------------------------------------------------------------------

;Input: myCybermap
myFreeCyberMap:
		push	d1-a6
		move.l	myCyberMap(A5),d0
		beq.s	none$
		move.l	d0,a1
		move.l	CYM_Memsize(a1),d0
		move.l	4.w,a6
		jsr	_LVOFreeMem(A6)
none$		clr.l	myCyberMap(A5)
		pop	d1-a6
		tst.l	d0
		rts
;---------------------- Alloziert "faked" Bitmap fr Cybergfxroutinen ---------
;Input: d1.w: Hhe
;       d2:   Flags, Bit 0 = 1 -> Breite in D0 bergeben,sonst selbst bestimmen
;	d0.w: Breite in Pixels (wenn Flag = 1)
;       holt sich fr den Rest die Speicherzellen
;
myAllocCyberMap:
		push	d1-a6
		tst.l	myCyberMap(a5)
		beq.s	weiter$
		bsr	myFreeCyberMap
weiter$
		btst	#0,d2
		bne.s	skipwidth$
	
		moveq	#0,d0			;Breite
		move	myBox_width(pc),d0
skipwidth$

		move	d1,mybitmap_height(a5)

;		addq	#3,d0			;auf Langwortbreite align
;		and	#~3,d0			;

		add	#15,d0
		and	#~15,d0

		move	d1,d5
		addq	#1,d1			;1 Zeile mehr zur Sicherheit (muss ja keiner wissen)
		move	d0,d6

		mulu	d1,d0
		add.l	#CYM_SIZEOF,d0
		move.l	d0,d7

		moveq	#MEMF_Fast!MEMF_Public,d1
		move.l	4.w,a6
		jsr	_LVOAllocMem(A6)
		move.l	d0,myCyberMap(a5)
		beq.s	fail$
		move.l	d0,a1

		move.l	d7,CYM_Memsize(a1)	;fr Freigabe des Speichers
		move	d6,CYM_BytesPerRow(a1)	;Bytes pro Zeile
		move	d5,CYM_Rows(a1)		;Zeilen (eine mehr alloziert, aber nicht eingetragen)
		lea	CYM_Sizeof(a1),a0
		move.l	a0,CYM_Plane(a1)	;Chunky Plane
fail$
		pop	d1-a6
		tst.l	d0
		rts
*****************************************************************************************
* Farben allozieren fr Multicolor-Modus und Erstellung der Tabellen fr das Umkopieren *
*                                                                                       *
*****************************************************************************************
;Tabellenaufbau:
;0.l...(Hhe.l)*4 -> Pointer auf die einzelnen Tabellen
;Tabellen: - wortweise von unterster Zeile bis oberster Zeile Farbnummern Chunky
;          - 1. Tab - alles Hintergrund (=0)
;          - 2. Tab - 1. Eintrag mit Vordergrundfarbe, rest Hintergrund
;          usw.
;
;Input:  D0 - Hhe des Anzeigebereiches, 0=Anzahl der allozierten Farben als Hhe interpretieren und mit Faktor 1 skalieren
;        A0 - Farben- und Pentabelle
;        D1 - Flags, Bit0=1 -> Error, wenn Farben nicht alloziert werden knnen
;Output: D0 - Anzahl der allozierten Farben
;
AllocColorsandColorList:
		push	d1-a6
		move.l	a0,a4
		move.l	d1,d5

		moveq	#0,d6
		move	d0,d6

		moveq	#0,d7
allocPenLoop$
		lea	(a4),a0
allocPenLoop2$
		move	(a0),d0
		bmi.s	loopend$
		cmp	d0,d7
		beq.s	takeCol$
		lea	10(a0),a0
		bra	allocPenLoop2$
takeCol$
		moveq	#0,d1
		moveq	#0,d2
		moveq	#0,d3
		move	2(a0),d1
		move	4(a0),d2
		move	6(a0),d3
		swap	d1
		swap	d2
		swap	d3
		bsr	AllocPen
		move	d0,8(a0)
		bmi	fail$
		addq	#1,d7
		bra	allocPenLoop$
loopend$				;in D7 Anzahl der allozierten Farben
		move.l	d6,d0
		bne.s	use$
		move.l	d7,d6
		move.l	d7,d0
use$
		lsl	#2,d0		;Tabellenpointers

		move	d6,d1
		mulu	d1,d1		;Hhe
		add.l	d1,d1		;mal 2 wg. worten
		add.l	d1,d0		;+Pointers

		move.l	d0,MulticolTabSize(A5)
		moveq	#MEMF_Public,d1
		move.l	4.w,a6
		jsr	_LVOAllocMem(A6)
		move.l	d0,MulticolTab(a5)
		beq	fail$

		push	d7

		move.l	d0,a1

		move.l	d6,d0
		lsl.l	#2,d0		;Tabellenpointers
		lea	(a1,d0.l),a2	;1. Tab

		swap	d7
		divu.l	d6,d7		;Fraction
		swap	d7

		move	d6,d1
		subq	#1,d1

		moveq	#0,d5
		moveq	#0,d4
		lea	(a4),a0
allentries$
		move.l	a2,(a1)+	;Tab eintragen

		moveq	#0,d0
		moveq	#0,d3
one_list$
		addq	#1,d0
		cmp	d5,d0
		bgt.s	background$

		move	d3,d2
		mulu	#10,d2
		move	8(a0,d2),d2
		move.b	d2,(a2)+
		move.b	d2,(a2)+

		add.l	d7,d3
		addx	d4,d3
		bra.s	noBG$
background$
		move.b	Color2+1(pc),(a2)+
		move.b	Color2+1(pc),(a2)+
;		move	#$0101,(a2)+
noBG$
		cmp	d6,d0
		blt.s	one_list$

		addq	#1,d5		;aktuelle Hhe
		dbf	d1,allentries$

		lea	(A4),a0
		move.b	9(a0),d0
		lsl	#8,d0
		move.b	9(a0),d0
		move	d0,d1
		swap	d0
		move	d1,d0
		move.l	d0,Multicol_Pen1(A5)

		pop	d0

		pop	d1-a6
		rts
fail$
		move.l	a4,a0
		bsr	FreeColorsandColorList
		moveq	#-1,d0
		pop	d1-a6
		rts

FreeColorsandColorList:
		push	all
		move.l	a0,d0
		beq.s	readypens$

pen$		tst.w	(a0)
		bmi.s	readypens$
		move	8(a0),d0
		ext.l	d0
		bsr	FreePen
		move	#-1,8(a0)
		lea	10(a0),a0
		bra.s	pen$
readypens$

		move.l	MulticolTab(a5),d0
		beq.s	nomem$
		move.l	d0,a1
		move.l	MulticolTabSize(A5),d0
		move.l	4.w,a6
		jsr	_LVOFreeMem(a6)
		clr.l	MulticolTab(a5)
nomem$
		pop	all
		rts

MulticolorPenTab1:
;Aufbau: Pen_Pri.w,red.w,green.w,blue.w,Got_Num.w
;
;Pri: kleinste Pri -> als erstes allozieren, Pri von 0 bis num col, jede Prioritt
;     muss vorkommen
;
		dc.w	00,$00<<8,$79<<8,$00<<8,-1
		dc.w	21,$00<<8,$86<<8,$00<<8,-1
		dc.w	30,$00<<8,$94<<8,$00<<8,-1
		dc.w	05,$00<<8,$A1<<8,$00<<8,-1
		dc.w	04,$00<<8,$AF<<8,$00<<8,-1
		dc.w	03,$00<<8,$BC<<8,$00<<8,-1
		dc.w	11,$00<<8,$C9<<8,$00<<8,-1
		dc.w	14,$00<<8,$D7<<8,$00<<8,-1
		dc.w	08,$00<<8,$E4<<8,$00<<8,-1
		dc.w	09,$00<<8,$F2<<8,$00<<8,-1
		dc.w	10,$00<<8,$FF<<8,$00<<8,-1
		dc.w	06,$18<<8,$FF<<8,$00<<8,-1
		dc.w	12,$30<<8,$FF<<8,$00<<8,-1
		dc.w	13,$47<<8,$FF<<8,$00<<8,-1
		dc.w	07,$5F<<8,$FF<<8,$00<<8,-1
		dc.w	15,$77<<8,$FF<<8,$00<<8,-1
		dc.w	16,$8F<<8,$FF<<8,$00<<8,-1
		dc.w	17,$A6<<8,$FF<<8,$00<<8,-1
		dc.w	18,$BE<<8,$FF<<8,$00<<8,-1
		dc.w	19,$D6<<8,$FF<<8,$00<<8,-1
		dc.w	20,$EB<<8,$FF<<8,$00<<8,-1
		dc.w	01,$FF<<8,$FF<<8,$00<<8,-1
		dc.w	22,$FF<<8,$E3<<8,$00<<8,-1
		dc.w	23,$FF<<8,$C6<<8,$0c<<8,-1
		dc.w	24,$FF<<8,$AA<<8,$18<<8,-1
		dc.w	25,$FF<<8,$8E<<8,$24<<8,-1
		dc.w	26,$FF<<8,$71<<8,$31<<8,-1
		dc.w	27,$FF<<8,$55<<8,$3d<<8,-1
		dc.w	28,$FF<<8,$39<<8,$49<<8,-1
		dc.w	29,$FF<<8,$1C<<8,$55<<8,-1
		dc.w	02,$FF<<8,$00<<8,$61<<8,-1
		dc.w	31,$FF<<8,$00<<8,$6D<<8,-1
		dc.w	32,$FF<<8,$00<<8,$6D<<8,-1
		dc.w	-1,0,0,0,-1		;End Marke

;		dc.w	00,$00<<8,$FF<<8,0,-1
;		dc.w	10,$1A<<8,$FF<<8,0,-1
;		dc.w	08,$33<<8,$FF<<8,0,-1
;		dc.w	03,$4C<<8,$FF<<8,0,-1
;		dc.w	04,$66<<8,$FF<<8,0,-1
;		dc.w	05,$80<<8,$FF<<8,0,-1
;		dc.w	06,$99<<8,$FF<<8,0,-1
;		dc.w	07,$B3<<8,$FF<<8,0,-1
;		dc.w	19,$CC<<8,$FF<<8,0,-1
;		dc.w	09,$E6<<8,$FF<<8,0,-1
;		dc.w	01,$FF<<8,$FF<<8,0,-1
;		dc.w	11,$FF<<8,$E1<<8,0,-1
;		dc.w	12,$FF<<8,$C8<<8,0,-1
;		dc.w	13,$FF<<8,$AA<<8,0,-1
;		dc.w	14,$FF<<8,$8C<<8,0,-1
;		dc.w	15,$FF<<8,$73<<8,0,-1
;		dc.w	16,$FF<<8,$55<<8,0,-1
;		dc.w	17,$FF<<8,$37<<8,0,-1
;		dc.w	18,$FF<<8,$1E<<8,0,-1
;		dc.w	02,$FF<<8,$00<<8,0,-1

MulticolorPenTab2:
		dc.w	01,$00<<8,$00<<8,$00<<8,-1
		dc.w	03,$00<<8,$2C<<8,$40<<8,-1
		dc.w	04,$00<<8,$41<<8,$60<<8,-1
		dc.w	05,$00<<8,$57<<8,$80<<8,-1
		dc.w	06,$00<<8,$6D<<8,$9F<<8,-1
		dc.w	00,$00<<8,$83<<8,$BF<<8,-1
		dc.w	07,$00<<8,$98<<8,$DF<<8,-1
		dc.w	08,$00<<8,$AE<<8,$FF<<8,-1
		dc.w	09,$2B<<8,$91<<8,$FF<<8,-1
		dc.w	10,$55<<8,$74<<8,$FF<<8,-1
		dc.w	11,$80<<8,$57<<8,$FF<<8,-1
		dc.w	12,$AA<<8,$3A<<8,$FF<<8,-1
		dc.w	13,$D5<<8,$1D<<8,$FF<<8,-1
		dc.w	15,$FF<<8,$1A<<8,$F8<<8,-1
		dc.w	16,$FF<<8,$33<<8,$F0<<8,-1
		dc.w	17,$FF<<8,$4D<<8,$E9<<8,-1
		dc.w	18,$FF<<8,$66<<8,$E2<<8,-1
		dc.w	19,$FF<<8,$80<<8,$DA<<8,-1
		dc.w	20,$FF<<8,$99<<8,$D3<<8,-1
		dc.w	21,$FF<<8,$B3<<8,$CC<<8,-1
		dc.w	14,$FF<<8,$CC<<8,$C5<<8,-1
		dc.w	24,$FF<<8,$FF<<8,$B6<<8,-1
		dc.w	25,$FF<<8,$FF<<8,$B6<<8,-1
		dc.w	26,$FF<<8,$FF<<8,$B6<<8,-1
		dc.w	27,$FF<<8,$FF<<8,$B6<<8,-1
		dc.w	28,$FF<<8,$FF<<8,$B6<<8,-1
		dc.w	29,$FF<<8,$FF<<8,$B6<<8,-1
		dc.w	30,$FF<<8,$FF<<8,$B6<<8,-1
		dc.w	31,$FF<<8,$FF<<8,$B6<<8,-1
		dc.w	32,$FF<<8,$FF<<8,$B6<<8,-1
		dc.w	23,$FF<<8,$FF<<8,$B6<<8,-1
		dc.w	22,$FF<<8,$FF<<8,$B6<<8,-1
		dc.w	02,$FF<<8,$FF<<8,$B6<<8,-1
		dc.w	-1,0,0,0,-1		;End Marke


MulticolorPenTab3:
		dc.w	00,$00<<8,$00<<8,$32<<8,-1
		dc.w	01,$33<<8,$33<<8,$33<<8,-1
		dc.w	02,$44<<8,$44<<8,$44<<8,-1
		dc.w	03,$55<<8,$55<<8,$55<<8,-1
		dc.w	04,$66<<8,$66<<8,$66<<8,-1
		dc.w	05,$77<<8,$77<<8,$77<<8,-1
		dc.w	06,$88<<8,$88<<8,$88<<8,-1
		dc.w	07,$99<<8,$99<<8,$99<<8,-1
		dc.w	08,$AA<<8,$AA<<8,$AA<<8,-1
		dc.w	09,$BB<<8,$BB<<8,$BB<<8,-1
		dc.w	10,$CC<<8,$CC<<8,$CC<<8,-1
		dc.w	11,$DD<<8,$DD<<8,$DD<<8,-1
		dc.w	12,$EE<<8,$EE<<8,$EE<<8,-1
		dc.w	13,$FF<<8,$FF<<8,$FF<<8,-1
		dc.w	14,$FF<<8,$FF<<8,$FF<<8,-1
		dc.w	15,$FF<<8,$FF<<8,$FF<<8,-1
		dc.w	16,$FF<<8,$FF<<8,$FF<<8,-1
		dc.w	17,$FF<<8,$FF<<8,$FF<<8,-1
		dc.w	18,$FF<<8,$FF<<8,$FF<<8,-1
		dc.w	19,$FF<<8,$FF<<8,$FF<<8,-1
		dc.w	20,$FF<<8,$FF<<8,$FF<<8,-1
		dc.w	21,$FF<<8,$FF<<8,$FF<<8,-1
		dc.w	-1,0,0,0,-1		;End Marke

MulticolorPenTab4:
		dc.w	00,$1C<<8,$00<<8,$3D<<8,-1
		dc.w	01,$2D<<8,$08<<8,$39<<8,-1
		dc.w	02,$37<<8,$10<<8,$33<<8,-1
		dc.w	03,$3F<<8,$18<<8,$38<<8,-1
		dc.w	04,$47<<8,$20<<8,$3E<<8,-1
		dc.w	43,$4E<<8,$29<<8,$43<<8,-1
		dc.w	06,$56<<8,$31<<8,$49<<8,-1
		dc.w	07,$5E<<8,$39<<8,$4E<<8,-1
		dc.w	08,$65<<8,$41<<8,$54<<8,-1
		dc.w	09,$6D<<8,$49<<8,$59<<8,-1
		dc.w	10,$75<<8,$55<<8,$61<<8,-1
		dc.w	11,$79<<8,$61<<8,$69<<8,-1
		dc.w	12,$7D<<8,$6D<<8,$71<<8,-1
		dc.w	13,$82<<8,$75<<8,$79<<8,-1
		dc.w	14,$8A<<8,$79<<8,$82<<8,-1
		dc.w	15,$8A<<8,$82<<8,$86<<8,-1
		dc.w	16,$92<<8,$8A<<8,$8E<<8,-1
		dc.w	17,$96<<8,$92<<8,$92<<8,-1
		dc.w	18,$96<<8,$9A<<8,$9A<<8,-1
		dc.w	19,$9A<<8,$A2<<8,$9E<<8,-1
		dc.w	20,$A2<<8,$AA<<8,$A2<<8,-1
		dc.w	21,$A6<<8,$AE<<8,$A6<<8,-1
		dc.w	22,$AA<<8,$B6<<8,$AE<<8,-1
		dc.w	23,$AE<<8,$BE<<8,$B2<<8,-1
		dc.w	24,$B2<<8,$C6<<8,$BA<<8,-1
		dc.w	25,$B6<<8,$CE<<8,$BE<<8,-1
		dc.w	26,$BA<<8,$D6<<8,$C2<<8,-1
		dc.w	27,$BA<<8,$DB<<8,$C6<<8,-1
		dc.w	28,$BE<<8,$DF<<8,$C6<<8,-1
		dc.w	29,$BE<<8,$E3<<8,$CA<<8,-1
		dc.w	30,$BE<<8,$E3<<8,$CA<<8,-1
		dc.w	31,$C2<<8,$E7<<8,$CE<<8,-1
		dc.w	32,$C2<<8,$EB<<8,$D2<<8,-1
		dc.w	33,$C6<<8,$EF<<8,$D2<<8,-1
		dc.w	34,$C6<<8,$EF<<8,$D6<<8,-1
		dc.w	35,$CA<<8,$F3<<8,$D6<<8,-1
		dc.w	36,$CA<<8,$F7<<8,$DB<<8,-1
		dc.w	37,$CE<<8,$FB<<8,$DB<<8,-1
		dc.w	38,$CE<<8,$FB<<8,$DF<<8,-1
		dc.w	39,$D2<<8,$FF<<8,$DF<<8,-1
		dc.w	40,$D2<<8,$FF<<8,$E3<<8,-1
		dc.w	41,$D2<<8,$FF<<8,$E7<<8,-1
		dc.w	42,$D2<<8,$FF<<8,$E7<<8,-1
		dc.w	05,$D6<<8,$FF<<8,$EB<<8,-1
		dc.w	44,$D6<<8,$FF<<8,$EF<<8,-1
		dc.w	45,$DB<<8,$FF<<8,$EF<<8,-1
		dc.w	46,$DB<<8,$FF<<8,$F3<<8,-1
		dc.w	47,$DF<<8,$FF<<8,$F7<<8,-1
		dc.w	-1,0,0,0,-1		;End Marke





	* OLD STUFF Blue (FFTScope alike)
		dc.w	32,$00<<8,$00<<8,$32<<8,-1
		dc.w	03,$00<<8,$2C<<8,$40<<8,-1
		dc.w	04,$00<<8,$41<<8,$60<<8,-1
		dc.w	05,$00<<8,$57<<8,$80<<8,-1
		dc.w	06,$00<<8,$6D<<8,$9F<<8,-1
		dc.w	00,$00<<8,$83<<8,$BF<<8,-1
		dc.w	07,$00<<8,$98<<8,$DF<<8,-1
		dc.w	08,$00<<8,$AE<<8,$FF<<8,-1
		dc.w	09,$2B<<8,$91<<8,$FF<<8,-1
		dc.w	10,$55<<8,$74<<8,$FF<<8,-1
		dc.w	11,$80<<8,$57<<8,$FF<<8,-1
		dc.w	12,$AA<<8,$3A<<8,$FF<<8,-1
		dc.w	13,$D5<<8,$1D<<8,$FF<<8,-1
		dc.w	15,$FF<<8,$1A<<8,$F8<<8,-1
		dc.w	16,$FF<<8,$33<<8,$F0<<8,-1
		dc.w	17,$FF<<8,$4D<<8,$E9<<8,-1
		dc.w	18,$FF<<8,$66<<8,$E2<<8,-1
		dc.w	19,$FF<<8,$80<<8,$DA<<8,-1
		dc.w	20,$FF<<8,$99<<8,$D3<<8,-1
		dc.w	21,$FF<<8,$B3<<8,$CC<<8,-1
		dc.w	14,$FF<<8,$CC<<8,$C5<<8,-1
		dc.w	24,$FF<<8,$FF<<8,$B6<<8,-1
		dc.w	25,$FF<<8,$FF<<8,$B6<<8,-1
		dc.w	26,$FF<<8,$FF<<8,$B6<<8,-1
		dc.w	27,$FF<<8,$FF<<8,$B6<<8,-1
		dc.w	28,$FF<<8,$FF<<8,$B6<<8,-1
		dc.w	29,$FF<<8,$FF<<8,$B6<<8,-1
		dc.w	30,$FF<<8,$FF<<8,$B6<<8,-1
		dc.w	31,$FF<<8,$FF<<8,$B6<<8,-1
		dc.w	01,$FF<<8,$FF<<8,$B6<<8,-1
		dc.w	23,$FF<<8,$FF<<8,$B6<<8,-1
		dc.w	22,$FF<<8,$FF<<8,$B6<<8,-1
		dc.w	02,$FF<<8,$FF<<8,$B6<<8,-1
		dc.w	-1,0,0,0,-1		;End Marke




	* OLD STUFF brown
;		dc.w	06,$3D<<8,$00<<8,$1C<<8,-1
		dc.w	06,$0<<8,$00<<8,$1C<<8,-1
		dc.w	07,$40<<8,$05<<8,$20<<8,-1
		dc.w	08,$43<<8,$0B<<8,$23<<8,-1
		dc.w	09,$47<<8,$10<<8,$27<<8,-1
		dc.w	10,$4A<<8,$16<<8,$2A<<8,-1
		dc.w	11,$4D<<8,$1B<<8,$2E<<8,-1
		dc.w	12,$50<<8,$21<<8,$31<<8,-1
		dc.w	13,$53<<8,$26<<8,$35<<8,-1
		dc.w	14,$56<<8,$2B<<8,$38<<8,-1
		dc.w	15,$5A<<8,$31<<8,$3C<<8,-1
		dc.w	16,$5D<<8,$36<<8,$3F<<8,-1
		dc.w	17,$60<<8,$3C<<8,$43<<8,-1
		dc.w	18,$63<<8,$41<<8,$46<<8,-1
		dc.w	19,$66<<8,$47<<8,$4A<<8,-1
		dc.w	20,$69<<8,$4C<<8,$4D<<8,-1
		dc.w	21,$6D<<8,$51<<8,$51<<8,-1
		dc.w	22,$70<<8,$57<<8,$55<<8,-1
		dc.w	23,$73<<8,$5C<<8,$58<<8,-1
		dc.w	24,$76<<8,$62<<8,$5C<<8,-1
		dc.w	25,$79<<8,$67<<8,$5F<<8,-1
		dc.w	26,$7C<<8,$6D<<8,$63<<8,-1
		dc.w	27,$80<<8,$72<<8,$66<<8,-1
		dc.w	28,$83<<8,$77<<8,$6A<<8,-1
		dc.w	29,$86<<8,$7D<<8,$6D<<8,-1
		dc.w	30,$89<<8,$82<<8,$71<<8,-1
		dc.w	31,$8C<<8,$88<<8,$74<<8,-1
		dc.w	32,$8F<<8,$8D<<8,$78<<8,-1
		dc.w	33,$93<<8,$92<<8,$7B<<8,-1
		dc.w	34,$96<<8,$98<<8,$7F<<8,-1
		dc.w	35,$99<<8,$9D<<8,$82<<8,-1
		dc.w	36,$9C<<8,$A3<<8,$86<<8,-1
		dc.w	37,$9F<<8,$A8<<8,$89<<8,-1
		dc.w	38,$A2<<8,$AE<<8,$8D<<8,-1
		dc.w	39,$A6<<8,$B3<<8,$91<<8,-1
		dc.w	40,$A9<<8,$B8<<8,$94<<8,-1
		dc.w	41,$AC<<8,$BE<<8,$98<<8,-1
		dc.w	42,$AF<<8,$C3<<8,$9B<<8,-1
		dc.w	43,$B2<<8,$C9<<8,$9F<<8,-1
		dc.w	44,$B5<<8,$CE<<8,$A2<<8,-1
		dc.w	45,$B9<<8,$D4<<8,$A6<<8,-1
		dc.w	46,$BC<<8,$D9<<8,$A9<<8,-1
		dc.w	47,$BF<<8,$DE<<8,$AD<<8,-1
		dc.w	05,$C2<<8,$E4<<8,$B0<<8,-1
		dc.w	04,$C5<<8,$E9<<8,$B4<<8,-1
		dc.w	03,$C8<<8,$EF<<8,$B7<<8,-1
		dc.w	02,$CC<<8,$F4<<8,$BB<<8,-1
		dc.w	01,$CF<<8,$FA<<8,$BE<<8,-1
		dc.w	00,$D2<<8,$FF<<8,$C2<<8,-1
		dc.w	-1,0,0,0,-1		;End Marke
	

;************************************************************************************************
;*    Koordinaten fr Scopes aus aktuellem Fenster berechnen, Rahmen usw. zeichnen              *
;*                                                                                              *
;************************************************************************************************
;Input: A0 - Fenster
;
NewCoordinates:
		push	d1-a6

		move.w	wd_width(a0),d0
		moveq	#0,d1
		move.b	wd_borderleft(a0),d1
		move	d1,Left_Offset			;Offset vom linken Rahmen
		add.b	wd_Borderright(a0),d1
		sub	d1,d0
		move	d0,myInnerwidth			;Breite ohne Rahmen

		move	wd_height(a0),d0
		moveq	#0,d1
		move.b	wd_Bordertop(a0),d1
		move	d1,Top_Offset			;Offset von der Titelzeile ins freie Feld :-)
		add.b	wd_borderbottom(a0),d1
		sub	d1,d0
		move	d0,myInnerheight		;Hhe ohne Rahmen

		bsr	Backfill$			;10101010 - Muster in den Hintergrund
							;01010101

		move	myInnerwidth(pc),d2
		sub	#RandAbstandH*2+BoxInnenAbstandH*2,d2 ;Wieviel Platz ist im Fenster(chen) Hori
		move	myInnerheight(pc),d3
		sub	#RandAbstandV*2+BoxInnenAbstandV*2,d3 ;Wieviel Platz ist im Fenster(chen) Verti

		move	d2,d4
		and	#~15,d4
		move	d4,myBox_width			;Breite des Anzeigebereiches
		sub	d4,d2
		lsr	#1,d2
		
		move	#RandabstandH+BoxInnenAbstandH,d6
		add	Left_Offset(pc),d6
		add	d2,d6
		move	d6,myBox_Left			;Linkes Offset des Anzeigebereiches

		move	#RandabstandV+BoxInnenAbstandV,d1
		add	Top_Offset(pc),d1
		move	d1,myBox1_Top			;Oberes Offset des Anzeigebereiches

		move.b	gadgetson(pc),d0
		beq.s	nogads$

		sub	#Gadgets_Space,d3	;safe to call, alle Fensterminimalgren werden
						;grundstzlich vorher angepasst

		bsr	MakeGadgets$		;Positionen der Gadgets anpassen, Bevelbox malen
						;und Hintergrund subern
nogads$	
		move.b	FreqBar(pc),d0
		bpl.s	nofreq$

		move.l	font(A5),a0
		sub.w	tf_ysize(a0),d3		;noch einmal Fonthhe reservieren fr Anzeige der
						;Frequenzen
		sub	#FreqBarExtra,d3	;fr Bevelbox
		move	d3,FreqOffset(A5)

		move.l	Currentmode(pc),d0
		beq.s	nofreq$
		move.l	d0,a0
		move.l	16(a0),d2
		bsr	ShowFreqList		;Frequenzliste update
nofreq$
		sub	#ZwischenRaum,d3
		subq	#1,d3
		lsr	#1,d3
		move	d3,myBox_Height		;Hhe des Anzeigebereiches/2

		add	d3,d1
		add	#ZwischenRaum,d1
		move	d1,myBox2_Top		;wird nur benutzt, wenn 2 Anzeigefensterchen
						;bereinander fr die Modi, die von oben/unten zur
						;Mitte oder umgekehrt arbeiten

		move.l	winhandle(a5),a0
		move.l	intsave(A5),a6
		jsr	_LVORefreshwindowframe(A6)

		pop	d1-a6
		moveq	#0,d0
		rts

;--------------------------------------------------------------------------------------
;------ Positionen der Gadgets anpassen, Bevelbox malen	und Hintergrund subern -------

;Input: a0: Fenster, Koordinaten aus Innerwidth, Innerheight, Left_offset, Top_Offset,
;       vordefinierte Konstanten
;
MakeGadgets$
		push	all
		
		bsr	RemoveGadgets		;zur Sicherheit

		move.l	winhandle(A5),a0

		moveq	#Gadgets_Space-BevelabstandV,d2
		add.b	wd_borderbottom(a0),d2
		neg.w	d2
		add	myInnerheight(pc),d2	;Hhe - Platz fr die Gadgets - Borderhhe = Posi
		add	Top_Offset(pc),d2

		moveq	#0,d3
		move	myInnerwidth(pc),d3
		sub	#RandAbstandH*2+BevelabstandH*2+Gadgets_Width,d3 ;brig X fr die Gadgets
		divu	#Num_Gadgets-1,d3		;durch Anzahl der Gadgets = Space zwischen Gads

		move	Left_Offset(pc),d4
		add	#RandAbstandH+BevelabstandH,d4

		bsr	ShowGadbevel$

		lea	Gads(a5),a1
		lea	Gadslist,a0
		move.l	(a0)+,a2		;1. Image als Adresse, Rest als Offset
		moveq	#1,d1			;Gadget ID von 1 bis...

		moveq	#Num_Gadgets-1,d0
creategads$
		move	d4,gg_LeftEdge(a1)
		move	d2,gg_TopEdge(a1)
		move	#Gadgets_Width,gg_Width(A1)
		move	#Gadgets_Height,gg_Height(a1)
		move	#Gadgimage,gg_Flags(a1)
;		move	#GFLG_GADGHCOMP,gg_Flags(a1)
		move	#Relverify,gg_Activation(a1)
		move	#boolgadget,gg_GadgetType(a1)
		move.l	a2,gg_GadgetRender(a1)
;		add.l	(a0)+,a2		;nchstes Image
;		move.l	a2,gg_SelectRender(a1)
		add.l	(a0)+,a2		;nchstes Image
		clr.l	gg_GadgetText(a1)
		clr.l	gg_MutualExclude(a1)
		clr.l	gg_SpecialInfo(a1)
		move	d1,gg_GadgetID(a1)
		addq	#1,d1
		lea	gg_sizeof(a1),a3
		move.l	a3,(a1)
		move.l	a3,a1
		add	d3,d4
		dbf	d0,creategads$

		lea	-gg_sizeof(a1),a1
		clr.l	(a1)

		move.l	intsave(a5),a6
		move.l	winhandle(a5),a0
		lea	Gads(A5),a1
		moveq	#0,d0
		moveq	#-1,d1
		moveq	#0,d2
		jsr	_LVOaddglist(a6)
		st	gadson(a5)

		lea	Gads(A5),a0
		move.l	winhandle(a5),a1
		suba.l	a2,a2
		moveq	#Num_Gadgets,d0
		jsr	_LVOrefreshglist(a6)

		pop	all
		rts
;-------------------- Bevelbox fr Gadgets malen und Hintergrund kill -------------------------
;
ShowGadbevel$
		push	all

		move.l	grafsave(a5),a6
		move.l	winhandle(A5),a1
		move.l	wd_rport(a1),a1
		moveq	#0,d0
		moveq	#0,d1
		moveq	#RP_Jam2,d2
		jsr	_LVOsetabpenDrMd(A6)

		move.l	winhandle(A5),a1

		move	Left_Offset(pc),d0
		add.w	#RandAbstandH,d0	 ;Left

		moveq	#Gadgets_Space,d1
		add.b	wd_borderbottom(a1),d1
		neg.w	d1
		add	myInnerheight(pc),d1	;Hhe - Platz fr die Gadgets - Borderhhe = Posi
		add	Top_Offset(pc),d1

		move	#Gadgets_Height+bevelabstandV*2,d3	;Hhe

		move	myInnerwidth(pc),d2
		sub	#RandAbstandH*2,d2	;Breite

		push	d0-d3
		add.w	d0,d2
		add.w	d1,d3
		subq	#2,d2
		subq	#2,d3
		move.l	wd_rport(a1),a1
		jsr	_LVOrectfill(a6)
		pop	d0-d3

		move.l	winhandle(a5),a0
		move.l	wd_rport(a0),a0
		lea	mytags(a5),a3
		move.l	#GT_Visualinfo,(a3)+
		move.l	vi(a5),(a3)+
		move.l	#tag_done,(a3)+
		lea	mytags(a5),a3		;TagList mu in A3 und A1 sein !!!!!!!
		move.l	a3,a1			;!!!!!

		move.l	gadsave(a5),a6
		jsr	_LVOdrawbevelboxa(a6)
		pop	all
		rts
;Input: a0: Fenster, Koordinaten aus Innerwidth, Innerheight, Left_offset, Top_Offset
Backfill$
	push	all
	move.l	a0,a2

	move.l	grafsave(a5),a6
	move.l	wd_rport(a2),a1
	moveq	#1,d0
	moveq	#0,d1
	moveq	#RP_Jam2,d2
	jsr	_LVOsetabpenDrMd(A6)

	move.b	rp_areaptsz(a1),d4
	move.l	rp_areaptrn(a1),d5

	move.l	wd_rport(a2),a1

	move.b	#1,rp_areaptsz(a1)
	lea	patt1(pc),a0
	move.l	a0,rp_areaptrn(a1)

	move.w	Left_Offset(pc),d0	;x1
	move.w	Top_Offset(pc),d1	;y1

	move	myInnerwidth(pc),d2
	add	d0,d2
	subq	#1,d2
	move	myInnerheight(pc),d3
	add	d1,d3
	subq	#1,d3
	jsr	_LVOrectfill(a6)

	move.l	wd_rport(a2),a1
	move.b	d4,rp_areaptsz(a1)
	move.l	d5,rp_areaptrn(a1)
	pop	all
	rts
;------------------------------ Hngt Gadgets vom Fenster ab ----------------------------------------
RemoveGadgets:
		tst.b	gadson(a5)
		beq.s	skipfree$
		sf	gadson(a5)

		push	all

		move.l	intsave(a5),a6
		move.l	winhandle(a5),a0
		lea	Gads(a5),a1
		moveq	#Num_Gadgets,d0
		jsr	_LVORemoveGlist(a6)

		pop	all
skipfree$
		rts
;----------------------------------------------------------------------------------------------------
;Input: D0 - Nummer der Farbe
Showbevel:
		push	all
		move.l	d0,d7
		move.l	Winhandle(a5),d0
		beq.w	fail$
		move.l	d0,a0
		move	#RandabstandH,d0
		move	#RandabstandV,d1

		move	myInnerwidth(pc),d2
		sub	#RandAbstandH*2,d2
		move	myInnerheight(pc),d3
		sub	#RandAbstandV*2,d3

		move.b	gadgetson(pc),d6
		beq.s	nosub$
		sub	#Gadgets_Space,d3
nosub$
		move.b	FreqBar(pc),d6
		bpl.s	nofreq$

		move.l	font(A5),a1
		sub.w	tf_ysize(a1),d3		;noch einmal Fonthhe reservieren fr Anzeige der
						;Frequenzen
		sub	#FreqBarExtra+BevelabstandV,d3	;fr Bevelbox
nofreq$
		move.l	a0,a2
		move.l	grafsave(a5),a6
		move.l	wd_rport(a2),a1
		push	d0-d3
		move.l	d7,d0
		move.l	d7,d1
		moveq	#RP_Jam2,d2
		jsr	_LVOsetabpenDrMd(A6)

		movem.l	(a7),d0-d3

		add	Left_Offset(pc),d0
		add	Top_Offset(pc),d1
		add	d0,d2
		add	d1,d3
		subq	#1,d2
		subq	#1,d3
		jsr	_LVOrectfill(a6)
		pop	d0-d3

		add	Left_Offset(pc),d0
		add	Top_Offset(pc),d1

		move.l	wd_rport(a2),a0
		lea	mytags(a5),a3
		move.l	#GTBB_recessed,(a3)+
		move.l	#1,(a3)+
		move.l	#GT_Visualinfo,(a3)+
		move.l	vi(a5),(a3)+
		move.l	#tag_done,(a3)+
		lea	mytags(a5),a3		;TagList mu in A3 und A1 sein !!!!!!!
		move.l	a3,a1			;!!!!!

		move.l	gadsave(a5),a6
		jsr	_LVOdrawbevelboxa(a6)
fail$
		pop	all
		rts
;------------------------------------------------------------------------------------------------------
;------------------------------------------ Frequenzliste eintragen -----------------------------------
;Input: FreqBox_Y = Ypos der Box
;       Font      = Adresse des Fonts
;       Winhandle = Adresse des Fensters
;	D2.l	  = Flags
ShowFreqList:
		push	all
		tst.l	winhandle(a5)
		beq	getoff$

		move.b	FreqBar(pc),d0
		bpl	getoff$

		bsr	ShowFreqBevel$

		st	Freq_Off(a5)
		btst	#1,d2
		bne	getoff$		;keine Frequenzanzeige
		sf	Freq_Off(a5)

		btst	#0,d2
		bne	halved$
		sf	Freq_Halved(a5)

;		moveq	#0,d0
;		move	myInnerwidth(pc),d0
;		sub	#RandAbstandH*2,d0	;Wieviel Platz ist im Fenster(chen) Hori
;		move	Left_Offset(pc),d1
;		add.w	#RandAbstandH+BoxInnenAbstandH,d1	;Left

		moveq	#0,d0
		move	myBox_width(pc),d0
		move	myBox_Left(pc),d1	;Linkes Offset des Anzeigebereiches

		bsr	show$
getoff$
		pop	all
		rts
halved$
		moveq	#0,d0
		move	myBox_width(pc),d0
		move	myBox_Left(pc),d1	;Linkes Offset des Anzeigebereiches
		lsr	#1,d0
		sub	#12,d0

;		move	myInnerwidth(pc),d0
;		sub	#RandAbstandH*2,d0	;Wieviel Platz ist im Fenster(chen) Hori
;		lsr	#1,d0
;		subq	#4,d0
;		move	Left_Offset(pc),d1
;		add.w	#RandAbstandH+BoxInnenAbstandH,d1	;Left

		bsr	show$

		add	#12,d1
		add	d0,d1
		bsr	show$
		pop	all
		rts
show$
		push	all
		move.l	d1,d6
		move.l	d0,d7				;max. Breite des Anzeigefensters

		move.l	winhandle(A5),a4
		move.l	wd_Rport(a4),a4
		move.l	a4,a1
		move.l	Grafsave(A5),a6
		moveq	#1,d0
		moveq	#0,d1
		moveq	#RP_Jam2,d2
		jsr	_LVOsetabpenDrMd(A6)
	
		move.l	Font(A5),a0
		move.l	a4,a1
		jsr	_LVOSetFont(a6)			;Font setzen

;		moveq	#Freq_Chars,d0		;Anzahl der Zeichen
		move.l	UsedFreqlist(A5),a1
		move.l	8(a1),d0

		move.l	a4,a1
;		lea	Freq_referenz(pc),a0

		move.l	UsedFreqlist(a5),a0
		move.l	(a0),a0
		jsr	_LVOTextLength(a6)
		move.l	d0,d3
		lsr	#1,d3

		move.l	d7,d5
		sub	d3,d5
		sub	d3,d5
		bmi	forget$

		add	d0,d0			;mehr Platz pro Eintrag !
		divu	d0,d5			;Wie oft passt diese Lnge in die Breite
						;der Box rein ?
		cmp	#2,d5
		blo	forget$

		moveq	#2,d4			;nur 0   4   8 

		cmp	#3,d5
		blo	use$			;weniger als 3 brig -> 2 insg. anzeigen

		moveq	#3,d4			;0 2 4 6 8

		cmp	#5,d5
		blo.s	use$			;weniger als 5 brig ? -> 3 insg. anzeigen

		moveq	#5,d4

		cmp	#9,d5
		blo.s	use$			;weniger als 9 brig ? -> 5 insg. anzeigen

		moveq	#9,d4
use$
		move.l	d7,d5

		divu	d4,d5			;durch Anzahl -> Offset von einem zum nchsten

;		lea	Freqlist(pc),a3
		move.l	UsedFreqlist(a5),a3
		move.l	4(a3),a3

		subq	#1,d4
shownumbers$
		move	2(a3),d0		;Nummer des Eintrags
		beq.s	take$

		move.l	d7,d1
		sub	d3,d1
		sub	d3,d1

		mulu	d1,d0
		divu	#100,d0			;alles auf 100 bezogen
;		sub	d3,d0
take$
		add	d6,d0			;+ Offset

		move.l	Font(A5),a0
		move.w	TF_Baseline(a0),d1		;Char Baseline = Y-Posi
		add	FreqBox_Y(a5),d1		;+ BoxPosi
;		add	#FreqBarExtra/2,d1		;+ Boxabstand
		add	#2,d1				;+ Boxabstand

		move.l	a4,a1
		jsr	_LVOmove(a6)		

		lea	4(a3),a0

		move.l	UsedFreqlist(A5),a1
		move.l	8(a1),d0

		move.l	a4,a1
		jsr	_LVOText(A6)

		add	(a3),a3
		dbf	d4,shownumbers$
forget$
		pop	all
		rts
;------------------------------------------------------------------------------------------------------
;----- Positionen der Box fr die Frequenztabelle anpassen, Bevelbox malen und Hintergrund subern ----

;Input: a0: Fenster, Koordinaten aus Innerwidth, Innerheight, Left_offset, Top_Offset,
;       vordefinierte Konstanten
ShowFreqBevel$
		push	all
		move	FreqOffset(A5),d3

		move.l	grafsave(a5),a6
		move.l	winhandle(A5),a1
		move.l	wd_rport(a1),a1
		moveq	#0,d0
		moveq	#0,d1
		moveq	#RP_Jam2,d2
		jsr	_LVOsetabpenDrMd(A6)

		move.l	winhandle(A5),a1

		move	Left_Offset(pc),d0
		add.w	#RandAbstandH,d0	 ;Left

		move	Top_Offset(pc),d1	;Abstand von Titelzeile
		add	d3,d1			;+ Hhe der Box
		add	#FreqBarExtra/2+RandAbstandV+BevelabstandV,d1
		move	d1,FreqBox_Y(a5)

		moveq	#bevelabstandV*2,d3	;Platz fr Bevelbox
		move.l	font(A5),a3
		add.w	tf_ysize(a3),d3		;+ Fonthhe

		move	myInnerwidth(pc),d2
		sub	#RandAbstandH*2,d2	;Breite

		push	d0-d3
		add.w	d0,d2
		add.w	d1,d3
		subq	#2,d2
		subq	#2,d3
		move.l	wd_rport(a1),a1
		jsr	_LVOrectfill(a6)
		pop	d0-d3

		move.l	winhandle(a5),a0
		move.l	wd_rport(a0),a0
		lea	mytags(a5),a3
		move.l	#GTBB_recessed,(a3)+
		move.l	#1,(a3)+
		move.l	#GT_Visualinfo,(a3)+
		move.l	vi(a5),(a3)+
		move.l	#tag_done,(a3)+
		lea	mytags(a5),a3		;TagList mu in A3 und A1 sein !!!!!!!
		move.l	a3,a1			;!!!!!

		move.l	gadsave(a5),a6
		jsr	_LVOdrawbevelboxa(a6)
		pop	all
		rts

	ifeq	Eagleplayer
MakeIntab:	
		lea	Testtab1,a0
		lea	Testtab2,a1

		moveq	#83,d0			;Rechteckimpuls
.w1		move.b	#80,(a1)+
		dbf	d0,.w1

		move	#0,(a1)+

		moveq	#83,d0
.w2		move.b	#-80,(a1)+
		dbf	d0,.w2

		move	#0,(a1)+

		moveq	#84,d0
.w3		move.b	#80,(a1)+
		dbf	d0,.w3

		move	#N/2-1,d0
		moveq	#0,d1
		moveq	#0,d3
sincostab$					;3 Sinuswellen erzeugen
		fmove.w	d1,fp1
		fmul.x	#6.283185/2^3,fp1	;Frequenz
		fsin.x	fp1
		fmul.x	#64,fp1			;Amplitude

		fmove.w	d1,fp2
		fmul.x	#6.283185/2^5,fp2	;Frequenz
		fsin.x	fp2
		fmul.x	#32,fp2			;Amplitude
;		fadd.x	fp2,fp1

;		fmove.w	d1,fp2			;ein paar Sinuswellen versch.
;		fmul.x	#6.283185/2^4,fp2	;Frequenz zum rumspielen
;		fsin.x	fp2
;		fmul.x	#32,fp2
;		fadd.x	fp2,fp1

;		fmove.w	d1,fp2			;nochn Sinus
;		fmul.x	#6.283185/2^3,fp2	;
;		fsin.x	fp2
;		fmul.x	#16,fp2
;		fadd.x	fp2,fp1

		fmove.w	fp1,d2
		add	d3,d2			;RechteckWelle maximaler Frequenz

		move.b	d2,(a0)+
		move.b	d2,(a0)+

		neg.w	d3
		addq	#1,d1		
		dbf	d0,sincostab$
		rts
	endc

;-------------------------------- Menaktionen, alle Register sind gesichert -------------------
;Input: a1 - aktuelles Menuitem
;Output: D0 =  0 - alles ok
;           = -1 - Programm beenden (User Request)
;
Set24kHz:
		move.b	speedNmix(pc),d0
		and.b	#$f0,d0
		or.b	#1,d0
		move.b	d0,speedNmix
		bsr	SetMenuFlags

		move.l	Currentmode(pc),a0
		move.l	16(a0),d2
		bra	ShowFreqList		;Frequenzliste update
Set16kHz:
		move.b	speedNmix(pc),d0
		and.b	#$f0,d0
		or.b	#2,d0
		move.b	d0,speedNmix
		bsr	SetMenuFlags

		move.l	Currentmode(pc),a0
		move.l	16(a0),d2
		bra	ShowFreqList		;Frequenzliste update
Set8kHz:
		move.b	speedNmix(pc),d0
		and.b	#$f0,d0
		or.b	#3,d0
		move.b	d0,speedNmix
		bsr	SetMenuFlags

		move.l	Currentmode(pc),a0
		move.l	16(a0),d2
		bra	ShowFreqList		;Frequenzliste update
Set1Frame
		move.b	speedNmix(pc),d0
		and.b	#$0F,d0
		or.b	#$10,d0
		move.b	d0,speedNmix
		bra	SetMenuFlags
Set2Frames
		move.b	speedNmix(pc),d0
		and.b	#$0f,d0
		or.b	#$20,d0
		move.b	d0,speedNmix
		bra	SetMenuFlags
Set3Frames
		move.b	speedNmix(pc),d0
		and.b	#$0f,d0
		or.b	#$30,d0
		move.b	d0,speedNmix
		bra	SetMenuFlags

M_AboutRequest
		lea	AboutText(pc),a0
		bsr	Request
		rts
M_Hide
		bsr	closewin
	ifne	Eagleplayer
		move.l	4,a6
		lea	Portname(pc),a1
		jsr	_LVOfindport(a6)
		tst.l	d0
		beq	M_Quit
		move.l	d0,a0			;Portadresse
		move.l	msgport(a5),d3
		move.l	mytask(a5),d4
		move.l	mysignal(a5),d5
		move.w	#USclass_DeActivate,d6
		bsr	sendmess
		moveq	#0,d0
		rts
	else
		moveq	#-1,d0
		rts
	endc
M_Quit
		moveq	#-1,d0
		rts

ToggleGadgets:
		push	d0/d1
		move.w	mi_flags(a1),d0
		and.w	#checked,d0
		sne	d1
		and.b	#1,d1
		move.b	d1,gadgetson
		bsr	UpdateWindowlimits
		pop	d0/d1
		rts
ToggleFreqDisplay:
		push	d0-d2
		move.w	mi_flags(a1),d0
		and.w	#checked,d0
		sne	d1
		and.b	#$80,d1
		move.b	FreqBar(pc),d2
		and.b	#~$80,d2
		or.b	d2,d1
		move.b	d1,FreqBar
		bsr	UpdateWindowlimits
		pop	d0-d2
		rts
M_Set512pt:
		push	d0-d2

		move.w	mi_flags(a1),d0
		and.w	#checked,d0
		sne	d1
		and.b	#$40,d1
		move.b	FreqBar(pc),d2
		and.b	#~$40,d2
		or.b	d2,d1
		move.b	d1,FreqBar

		bsr	InitFFT

		pop	d0-d2
		rts

UpdateWindowlimits
		push	all

		move.l	winhandle(A5),a0

		move.b	gadgetson(pc),d1
		beq.w	offgads$

		move	#RandAbstandH*2+BevelabstandH*2+[Gadgets_Width+2]*Num_Gadgets,d2
		move	#MinInnerHeight+Gadgets_Space,d3
		bra	gads$
offgads$
		bsr	RemoveGadgets

		move	#MinInnerWidth,d2
		move	#MinInnerHeight,d3
gads$
		move.b	FreqBar(pc),d4		;Frequenzanzeige ?
		bpl.s	nofreq1$

		move.l	font(A5),a3
		add.w	tf_ysize(a3),d3		;noch einmal Fonthhe reservieren fr Anzeige der
						;Frequenzen
		add	#FreqBarExtra+BevelabstandV,d3	;fr Bevelbox
nofreq1$

		push	d2/d3

		cmp.w	myInnerwidth(pc),d2
		bgt.s	resize$

		move	myinnerwidth(pc),d2			;minwidth so lassen

		cmp.w	myInnerheight(pc),d3
		ble.s	hi1$					;minheight auch -> weiter
resize$
		cmp.w	myInnerheight(pc),d3
		bgt.s	noreheight$
		move	myinnerheight(pc),d3
noreheight$

		move.l	wd_wscreen(a0),a2

		moveq	#0,d0
		move.b	wd_borderleft(a0),d0
		add.b	wd_borderright(a0),d0
		add	d0,d2			;minwidth

		moveq	#0,d1
		move.b	wd_bordertop(a0),d1
		add.b	wd_borderbottom(a0),d1
		add	d1,d3			;minheight

		move	wd_leftedge(a0),d0
		move	d0,d4
		add	d2,d4			;Breite + Leftedge = max. Offset on screen
		cmp.w	sc_width(a2),d4
		blt.s	oldX$
		move	sc_width(a2),d0		;Screenbreite - Fensterbreite = o.k.- Wert
		sub	d2,d0
		subq	#1,d0
oldx$
		move	wd_topedge(a0),d1
		move	d1,d4
		add	d3,d4			;Breite + Leftedge = max. Offset on screen
		cmp.w	sc_height(a2),d4
		blt.s	oldY$
		move	sc_height(a2),d1	;Screenbreite - Fensterbreite = o.k.- Wert
		sub	d3,d1
		subq	#1,d1
oldY$
		move.l	intsave(A5),a6
		move.l	wd_width(a0),d5
		jsr	_LVOChangewindowbox(A6)

;----------------------------- hier folgt ein bser Hack -------------------------------

wait$
		move.l	dossave(a5),a6
		moveq	#2,d1
		jsr	_LVOdelay(a6)
		
		move.l	winhandle(A5),a0
		cmp.l	wd_width(a0),d5
		beq	wait$
;----------------------------------- Hack Ende -----------------------------------------
hi1$
		pop	d2/d3

		move.l	winhandle(A5),a0
		moveq	#0,d0
		move.b	wd_borderleft(a0),d0
		add.b	wd_borderright(a0),d0
		add	d2,d0

		moveq	#0,d1
		move.b	wd_bordertop(a0),d1
		add.b	wd_borderbottom(a0),d1
		add	d3,d1
		bra.w	limits$
limits$
		moveq	#0,d2
		moveq	#0,d3

		move.l	intsave(A5),a6
		move.l	winhandle(A5),a0
		jsr	_LVOwindowlimits(A6)

		bsr	RefreshALL

		pop	all
		moveq	#0,d0
		rts
******************************************************************************
*                       Ausgabe von Requestern                               *
*                 Input: a0 -> Zeiger auf Ausgabestring                      *
******************************************************************************
Request:
	movem.l	d0-a6,-(sp)
	lea	my_easystruct(a5),a1

	move.l	a0,es_textformat(a1)

	lea	my_easygadget(pc),a0
	move.l	a0,es_gadgetformat(a1)

	lea	my_easytitle(pc),a0
	move.l	a0,es_Title(a1)
	move.l	winhandle(a5),a0	;*Window
	suba.l	a2,a2			;*IDCMP_ptr
	suba.l	a3,a3			;*Arguments
	move.l	Intsave(a5),a6
	jsr	_LVOeasyrequestargs(a6)
	movem.l	(sp)+,d0-a6	
	rts
;----------------------------------- Strings ---------------------------------------
graf:		dc.b	`graphics.library`,0
int:		dc.b	`intuition.library`,0
gad:		dc.b	`gadtools.library`,0
mathffp_s	dc.b	`mathffp.library`,0
mathtrans_s	dc.b	`mathtrans.library`,0
dos:		dc.b	`dos.library`,0
cybergfx_s	dc.b	`cybergraphics.library`,0
Project0STitle:	dc.b	'FFT-Analyzer (Eagleplayer),  DEFECT Softworks',0

portname:	dc.b	`EAGLEPLAYERPORT`,0

my_easytitle:
WinName		dc.b	`Realtime Spectrum Analyzer`,0
ProcessName:	dc.b	`E_FFTSpectrumAnalyzer.1`,0
mybuggsname	dc.b	`Buggs of Defect`,0
myinfo		dc.b	`This engine shows the frequency spectrum of the music data using `
		dc.b	`a highly optimized Fast Fourier Transform algorithm.`,0

my_easygadget:	dc.b	`   OK   `,0

Abouttext:	
	dc.b	`     EaglePlayer FFT Spectrum Analyzer V`
	ver
	dc.b	` (`
	date
	dc.b	`)`,10
	dc.b	`                1996 Henryk "BUGGS" Richter`,10,10
	dc.b	`This engine shows the frequency spectrum of the music data using `,10
	dc.b	`a highly optimized Fast Fourier Transform algorithm.`,10
	dc.b	'Warning: FFT needs some time to be computed so don`t complain',10
	dc.b	'         about 100%% CPU usage on slow (<68040) systems, switch',10
	dc.b	'         down to 1/2 or 1/3 Speed in this case and reduce the',10
	dc.b	`         window size or buy a 68060 based CPU-board.`,10,10
	dc.b	'  The shown frequency range is linear from 0 Hz  to 8,16 or 24 kHz.',10,10
	dc.b	'And don`t forget: Each Gadget switches more than one mode so',10
	dc.b	'                  don`t hesitate to click onto them more than once.',10,0
	even

;----------------------------------- Strukturen ------------------------------------
	even
Project0WindowTags:
	DC.L	WA_Left
LeftHier	dc.l	0
	DC.L	WA_Top
TopHier		dc.l	0
	DC.L	WA_InnerWidth
Widthhier	dc.l	500
	DC.L	WA_InnerHeight
HeightHier	dc.l	200
	DC.L	WA_IDCMP,IDCMP_NEWSIZE!closewindow!menupick!refreshwindow!IDCMP_Gadgetup!IDCMP_VanillaKey
	DC.L	WA_Flags,WFLG_NOCAREREFRESH!Windowsizing!Windowdrag!Windowdepth!Windowclose
		;WFLG_SMART_REFRESH!Windowsizing!Windowdrag!Windowdepth!Windowclose
		;WFLG_SIMPLE_REFRESH!Windowsizing!Windowdrag!Windowdepth!Windowclose
	dc.l	WA_Pubscreen
Pubhier	dc.l	0
	dc.l	WA_Newlookmenus,1
	dc.l	WA_Pubscreenfallback,1
	dc.l	WA_MaxWidth,1024
	dc.l	WA_MaxHeight,768
	dc.l	WA_Title,WinName
	dc.l	WA_AutoAdjust,1

	dc.l	wa_minheight
		dc.w	0
minheight:	dc.w	50

	dc.l	wa_minwidth
		dc.w	0
minwidth:	dc.w	50
	DC.L	WA_ScreenTitle,Project0STitle

	dc.l	0
	DC.L	TAG_DONE

;-------------------- Mens --------------
ItemNum	macro
	dc.w	[[\1-Project0NewMenu0]/GNM_Sizeof-1]*32
	dc.l	\2
	endm

Menutab:				;Tabelle der Menaktionen
	ItemNum	Item_Gadgets,ToggleGadgets
	ItemNum	Item_FreqDisplay,ToggleFreqDisplay

	ItemNum	Item_24khz,Set24kHz
	ItemNum	Item_16khz,Set16kHz
	ItemNum	Item_8khz,Set8kHz


	ItemNum	Item_1Frame,Set1Frame
	ItemNum	Item_2Frames,Set2Frames
	ItemNum	Item_3Frames,Set3Frames

	ItemNum	Item_About,M_AboutRequest
	ItemNum	Item_Hide,M_Hide
	ItemNum	Item_Quit,M_Quit

	ItemNum	Item_512Pt,M_Set512pt

	dc.w	-1
	dc.l	0


Project0NewMenu0:			;Newmenu Struktur
	DC.B	NM_TITLE,0
	DC.L	Project0MName0		;Project
	DC.L	0
	DC.W	0
	DC.L	0,0

Item_Gadgets
	DC.B	NM_ITEM,0
	DC.L	Gadgets			;\/ Gadgets
	dc.l	Gadgetskey
GadgetsFlags
	DC.W	CHECKIT!Menutoggle
	DC.L	0,0

Item_FreqDisplay
	DC.B	NM_ITEM,0
	DC.L	FreqDisplay		;\/ Frequency Table
	dc.l	FreqDisplayKey
FreqdispFlags
	DC.W	CHECKIT!Menutoggle
	DC.L	0,0

	DC.B    NM_ITEM,0
	DC.L    NM_BARLABEL,0		;~~~~~~~~~~~
	DC.W    0
	DC.L    0,0

MixrateMUTALitems			;3. Item
Item_24khz:
	DC.B	NM_ITEM,0
	DC.L	Max24khz		;o  Max. 16 Khz
	dc.l	Max24khzkey
	DC.W	CHECKIT
	DC.L	%110000,0

Item_16khz:
	DC.B	NM_ITEM,0
	DC.L	Max16khz		;o  Max. 12 Khz
	dc.l	Max16khzkey
	DC.W	CHECKIT
	DC.L	%101000,0

Item_8khz:
	DC.B	NM_ITEM,0
	DC.L	Max8khz			;o  Max. 8 Khz
	dc.l	Max8khzkey
	DC.W	CHECKIT!CHECKED
	DC.L	%011000,0


	DC.B    NM_ITEM,0
	DC.L    NM_BARLABEL,0		;~~~~~~~~~~
	DC.W    0
	DC.L    0,0

SpeedMUTALitems				;4. (8.) Item
Item_1Frame
	DC.B	NM_ITEM,0
	DC.L	frame1			;o  full Speed
	dc.l	frame1key
	DC.W	CHECKIT
;	DC.L	%110000,0
	DC.L	%1100000000,0

Item_2Frames
	DC.B	NM_ITEM,0		;5. (9.) Item
	DC.L	frame2			;o  half Speed
	dc.l	frame2key
	DC.W	CHECKIT!CHECKED
;	DC.L	%101000,0
	DC.L	%1010000000,0

Item_3Frames
	DC.B	NM_ITEM,0		;6. (10.) Item
	DC.L	frame3			;o  1/3 Speed
	dc.l	frame3key
	DC.W	CHECKIT
;	DC.L	%011000,0
	DC.L	%0110000000,0

	DC.B    NM_ITEM,0
	DC.L    NM_BARLABEL,0		;~~~~~~~~~~
	DC.W    0
	DC.L    0,0

Item_512Pt
	DC.B	NM_ITEM,0		;9. (13.) Item
	DC.L	HighReso		;o  High Resolution
	dc.l	HighResoKey
	DC.W	CHECKIT!MENUTOGGLE
	dc.l	0,0

	DC.B    NM_ITEM,0
	DC.L    NM_BARLABEL,0		;~~~~~~~~~~
	DC.W    0
	DC.L    0,0

Item_About
    DC.B    NM_ITEM,0			;8. (12.) Item
    DC.L    Project0MName6		;About
    DC.L    Project0MComm6
    DC.W    0
    DC.L    0,0

Item_Hide
    DC.B    NM_ITEM,0			;9. (13.) Item
    DC.L    Project0MName7		;Hide
    DC.L    Project0MComm7
    DC.W    0
    DC.L    0,0

Item_Quit
    DC.B    NM_ITEM,0			;10. (14.) Item
    DC.L    Project0MName8		;Quit
    DC.L    Project0MComm8
    DC.W    0
    DC.L    0,0

    DC.B    NM_END,0
    DC.L    0,0
    DC.W    0
    DC.L    0,0

Gadgets		dc.b	`Gadgets`,0	;\/ Gadgets
Gadgetskey	dc.b	`G`
FreqDisplay	dc.b	`Frequency Table`,0
FreqDisplayKey	dc.b	`F`
Max24khz	dc.b	`max. 24 kHz`,0	;o  Max. 24 Khz
Max24khzkey	dc.b	`4`
Max16khz	dc.b	`max. 16 kHz`,0	;o  Max. 16 Khz
Max16khzkey	dc.b	`5`
Max8khz		dc.b	`max.  8 kHz`,0	;o  Max. 8 Khz	(DEFAULT)
Max8khzkey	dc.b	`6`
frame1		dc.b	`full Speed`,0	;o  full Speed
frame1key	dc.b	`1`
frame2		dc.b	`half Speed`,0	;o  half Speed	(DEFAULT)
frame2key	dc.b	`2`
frame3		dc.b	`1/3  Speed`,0	;o  1/3 Speed
frame3key	dc.b	`3`

HighReso	dc.b	`High Resolution`,0	;o  Higher Resolution
HighResoKey	dc.b	`R`

Project0MName0:		dc.b	'Project',0
Project0MName6:		DC.B    'About',0
Project0MComm6:		DC.B    'A',0
Project0MName7:		DC.B    'Hide',0
Project0MComm7:		DC.B    'H',0
Project0MName8:		DC.B    'Quit',0
Project0MComm8:		DC.B    'Q',0

	even
MTags0:
	DC.L	GTMN_Newlookmenus,1
	dc.l	TAG_DONE

patt1:
	dc.w	%1010101010101010
	dc.w	%0101010101010101

vol64	dc.w	64,64,64,64

MixfrequencyTAB:
	dc.l	16384*75,freqs1		;48372 Hz = 24 kHz max.
	dc.l	16384*112,freqs2	;31960 Hz = 16 kHz max.
	dc.l	16384*224,freqs3	;15980 Hz =  8 kHz max.

Gadslist:
	dc.l	Out2In_Image1			;1. Image: von aussen nach innen
	dc.l	In2Out_Image1-Out2In_Image1
	dc.l	Up_Image1-In2Out_Image1
	dc.l	Upline_Image1-Up_Image1
	dc.l	Color_Image1-Upline_Image1

;	dc.l	Out2In_Image2-Out2In_Image1
;	dc.l	In2Out_Image1-Out2In_Image2
;	dc.l	In2Out_Image2-In2Out_Image1
;	dc.l	Up_Image1-In2Out_Image2
;	dc.l	Up_Image2-Up_Image1
;	dc.l	Upline_Image1-Up_Image2
;	dc.l	Upline_Image2-Upline_Image1
;	dc.l	Color_Image1-Upline_Image2
;	dc.l	Color_Image2-Color_Image1

freqs1:	dc.l	Freq_referenz2,Freqlist1,3
freqs2:	dc.l	Freq_referenz2,Freqlist2,3
freqs3:	dc.l	Freq_referenz1,Freqlist3,2


Freq_referenz1:	dc.b	`9k`,0	;Referenz fr Breitentest des aktuellen Fonts, eigentlich nur
		even		;wichtig bei Proportionalfonts
Freq_referenz2:	dc.b	`19k`,0


Freqlist1:	dc.w	F_8k-*,0
		dc.b	`0  `,0
		even
F_8k		dc.w	F_4k-*,100*8/8
		dc.b	`24k`,0
		even
F_4k		dc.w	F_2k-*,100*4/8
		dc.b	`12k`,0
		even
F_2k		dc.w	F_6k-*,100*2/8
		dc.b	`6k `,0
		even
F_6k		dc.w	F_1k-*,100*6/8
		dc.b	`18k`,0
		even
F_1k		dc.w	F_3k-*,100*1/8
		dc.b	`3k `,0
		even
F_3k		dc.w	F_5k-*,100*3/8
		dc.b	`9k `,0
		even
F_5k		dc.w	F_7k-*,100*5/8
		dc.b	`15k`,0
		even
F_7k		dc.w	000000,100*7/8
		dc.b	`21k`,0
		even

Freqlist2:	dc.w	F_8k$-*,0
		dc.b	`0  `,0
		even
F_8k$		dc.w	F_4k$-*,100*8/8
		dc.b	`16k`,0
		even
F_4k$		dc.w	F_2k$-*,100*4/8
		dc.b	`8k `,0
		even
F_2k$		dc.w	F_6k$-*,100*2/8
		dc.b	`4k `,0
		even
F_6k$		dc.w	F_1k$-*,100*6/8
		dc.b	`12k`,0
		even
F_1k$		dc.w	F_3k$-*,100*1/8
		dc.b	`2k `,0
		even
F_3k$		dc.w	F_5k$-*,100*3/8
		dc.b	`6k `,0
		even
F_5k$		dc.w	F_7k$-*,100*5/8
		dc.b	`10k`,0
		even
F_7k$		dc.w	000000,100*7/8
		dc.b	`14k`,0
		even

Freqlist3:	dc.w	F_8k$-*,0
		dc.b	`0 `,0
		even
F_8k$		dc.w	F_4k$-*,100*8/8
		dc.b	`8k`,0
		even
F_4k$		dc.w	F_2k$-*,100*4/8
		dc.b	`4k`,0
		even
F_2k$		dc.w	F_6k$-*,100*2/8
		dc.b	`2k`,0
		even
F_6k$		dc.w	F_1k$-*,100*6/8
		dc.b	`6k`,0
		even
F_1k$		dc.w	F_3k$-*,100*1/8
		dc.b	`1k`,0
		even
F_3k$		dc.w	F_5k$-*,100*3/8
		dc.b	`3k`,0
		even
F_5k$		dc.w	F_7k$-*,100*5/8
		dc.b	`5k`,0
		even
F_7k$		dc.w	000000,100*7/8
		dc.b	`7k`,0
		even

	section	2,bss_f
;----------------------------------- BSS Daten ------------------------------------

datas:
		rsreset
intsave		rs.l	1
CGFXsave	rs.l	1
dossave		rs.l	1
grafsave	rs.l	1
gadsave		rs.l	1
mypubscreen	rs.l	1
vi		rs.l	1
Project0Menus	rs.l	1
mytask		rs.l	1
mysignal	rs.l	1
msgport		rs.l	1
Winhandle	rs.l	1
LastWinWidth	rs.w	1
LastWinHeight	rs.w	1
port		rs.l	1
mathffp		rs.l	1
mathtrans	rs.l	1
EffTab:		rs.l	1
EffTabSize	rs.l	1
MulticolTab:	rs.l	1
MulticolTabSize	rs.l	1
Multicol_Pen1:	rs.l	1		;Pen in der 1. benutzten Zeile
mycmap		rs.l	1
mytags:		rs.l	20*2
Permerk:	rs.l	4		;4 Kanle,je 2 Wrter
MaxDisplay1	rs.l	1
MaxDisplay2	rs.l	1
AN_Structadr:	rs.l	1
Mixfrequency	rs.l	1		;fr Mixroutine
UsedFreqlist	rs.l	1		;fr Anzeige der Frequenztabelle
LastAmplitude	rs.w	1		;Test, ob Amplitudenwerte neu berechnet werden mssen
MaxDisplayNum	rs.w	1
Displaynum	rs.w	1		;fr Mode9
Saveusernr	rs.w	1
mybitmap_height	rs.w	1		;Hhe der extra-Bitmap (fr copy ins Fenster)
slowid		rs.b	1		;Frame counter
slowcount	rs.b	1		;max. Frames
Gadson:		rs.b	1		;Gadgets schon im Fenster ?
SpecialUPS:	rs.b	1		;UPS Struktur der Amplifier ?
Gads:		rs.w	gg_sizeof*Num_Gadgets	;Gads werden von der ID her durchnumeriert
LastGadNr	rs.w	1		;letztes angeklicktes Gadget oder 0
LastModeOff	rs.w	1		;letzter Modus des zuletzt angeklicktem Gadgets
MY_Easystruct:	rs.l	1	;EASY-Request
		rs.l	1
		rs.l	1
		rs.l	1
		rs.l	1
Extramem1	rs.l	1		;extra Speicher fr Mode 20

MyRastPort	rs.b	rp_Sizeof	;nur, um System Default Font rauszubekommen
MyTmpRastPort	rs.b	rp_Sizeof	;extra Rastport fr WritePixelarray8
MyTmpRastPortBM	rs.l	1		;extra BitMap fr WritePixelarray8
Attr		rs.l	2		;Fontattr fr Rastport
fontadr		rs.l	1		;wenn extra Font alloziert
font		rs.l	1		;benutzer Font fr Frequenzanzeige
FreqBox_Y	rs.w	1		;Y-Position der Frequenzanzeige
Freq_Off	rs.b	1		;Frequenzanzeige berhaupt was dargestellt (Deli-Mode: nein) ?
Freq_Halved	rs.b	1		;Frequenzanzeige fr links und rechts getrennt dargetellt ?
FreqOffset	rs.w	1
myCyberMap	rs.l	1

Current_GAMMA	rs.w	1		;aktueller Gamma-Wert
Current_FFT	rs.l	1		;Welche FFT-Routine benutzen ?
Current_NumOut	rs.w	1		;wieviel Punkte werden am Ende abgegriffen ?
Current_Num	rs.w	1		;wieviel Punkte transformieren (2^Current_Gamma)


dataslen	rs.b	0
		ds.w	dataslen

	if	N>N_2			;um sicherzustellen, dass selbe Tabellen fr beide
					;FFT Routinen verwendet werden knnen

	ifeq	Eagleplayer
Testtab1		ds.w	N		;fr Inputwerte bei Testroutine
Testtab2		ds.w	N		;fr Inputwerte bei Testroutine
	endc

Realtab:		ds.w	N		;Werte, mit denen bei der FFT gerechnet wird
Imgtab			ds.w	N		;Werte, mit denen bei der FFT gerechnet wird
Bitreversetab		ds.w	N		;Bitumkehr nach Beendigung der FFT-Routine
SinCostab		ds.w	N*2		;Sinus/Cosinustabelle, sowie Bitspiegelung
OutTab1:		ds.w	N		;Ausgabewerte nach der FFT Reihe 1
OutTab2:		ds.w	N		;Ausgabewerte nach der FFT Reihe 2
	else

	ifeq	Eagleplayer
Testtab1		ds.w	N_2		;fr Inputwerte bei Testroutine
Testtab2		ds.w	N_2		;fr Inputwerte bei Testroutine
	endc

Realtab:		ds.w	N_2		;Werte, mit denen bei der FFT gerechnet wird
Imgtab			ds.w	N_2		;Werte, mit denen bei der FFT gerechnet wird
Bitreversetab		ds.w	N_2		;Bitumkehr nach Beendigung der FFT-Routine
SinCostab		ds.w	N_2*2		;Sinus/Cosinustabelle, sowie Bitspiegelung
OutTab1:		ds.w	N_2		;Ausgabewerte nach der FFT Reihe 1
OutTab2:		ds.w	N_2		;Ausgabewerte nach der FFT Reihe 2
	endc

RealtabLONG		ds.l	N_2
ImgtabLONG		ds.l	N_2

TMPtab:			ds.w	1000		;mehr gibts nicht ! Umrechnungstabelle fr x Balken im Fenster
Amplitudetab		ds.w	64*2^[Extra_Resolution+2]	;Umrechnung fr Darstellung ins Fenster
			ds.w	200		;Platz zur Sicherheit
;VTabaddr		dc.l	0		;Volumetabelle fr das Mixen ber die UPS-Struktur
VTab			ds.w	256*65;+512	;+512 damit Align auf feste Adresse mgl.


	section	3,data_c

Color_Image1:
	dc.w	0,0
	dc.w	$0024,$0010,$0003
	dc.l	Imagedata$
	dc.b	$07,$00
	dc.l	0

Imagedata$:
	dc.w	$7FFF,$FFFF,$E000,$8000,$0000,$1000,$8000,$0000,$3000,$8FFF,$FFFE,$3000,$8F9F,$C3E8,$3000,$8807,$0008,$3000,$8002,$0000,$3000,$8000,$0000,$3000,$8000,$0000,$3000,$8000,$0020,$3000,$8881,$0070,$3000,$8DC3,$A0F8,$3000,$8FFF,$FFFE,$3000,$8000,$0000,$3000,$BFFF,$FFFF,$F000,$7FFF,$FFFF,$E000,$0000,$0000
	dc.w	$0000,$7FFF,$FFFF,$E000,$4000,$0000,$0000,$4FFF,$FFFE,$0000,$4F9F,$E3E8,$0000,$4A0F,$8088,$0000,$4807,$0008,$0000,$4002,$0000,$0000,$4000,$0020,$0000,$4881,$0070,$0000,$49C3,$A0F8,$0000,$4FE7,$F1FC,$0000,$4FFF,$FFFE,$0000,$4000,$0000,$0000,$4000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000

Out2In_Image1:
	dc.w	0,0
	dc.w	$0024,$0010,$0003
	dc.l	Imagedata$
	dc.b	$07,$00
	dc.l	0

Imagedata$:
	dc.w	$7FFF,$FFFF,$E000,$8000,$0000,$1000,$8000,$0000,$3000,$8800,$0000,$3000,$8417,$F3EF,$3000,$8228,$0C10,$3000,$8140,$0000,$3000,$8080,$0000,$3000,$8000,$0000,$3000,$8100,$0010,$3000,$8288,$0E28,$3000,$8455,$D1C6,$3000,$8822,$2001,$3000,$8000,$0000,$3000,$BFFF,$FFFF,$F000,$7FFF,$FFFF,$E000,$0000,$0000
	dc.w	$0000,$7FFF,$FFFF,$E000,$4000,$0000,$0000,$47FF,$FFFF,$0000,$43E8,$0C10,$0000,$41C0,$0000,$0000,$4080,$0000,$0000,$4000,$0000,$0000,$4000,$0000,$0000,$4000,$0000,$0000,$4100,$0010,$0000,$4388,$0E38,$0000,$47DD,$DFFE,$0000,$4000,$0000,$0000,$4000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000

In2Out_Image1:
	dc.w	0,0
	dc.w	$0024,$0010,$0003
	dc.l	Imagedata$
	dc.b	$07,$00
	dc.l	0

Imagedata$:
	dc.w	$7FFF,$FFFF,$E000,$8000,$0000,$1000,$8000,$0000,$3000,$8000,$0000,$3000,$800E,$0000,$3000,$8011,$0810,$3000,$8220,$9428,$3000,$8540,$6244,$3000,$8880,$0183,$3000,$8540,$6244,$3000,$8220,$9428,$3000,$8011,$0810,$3000,$800E,$0000,$3000,$8000,$0000,$3000,$BFFF,$FFFF,$F000,$7FFF,$FFFF,$E000,$0000,$0000
	dc.w	$0000,$7FFF,$FFFF,$E000,$4000,$0000,$0000,$4000,$0000,$0000,$4000,$0000,$0000,$400E,$0000,$0000,$401F,$0810,$0000,$423F,$9C38,$0000,$477F,$FE7C,$0000,$423F,$9C38,$0000,$401F,$0810,$0000,$400E,$0000,$0000,$4000,$0000,$0000,$4000,$0000,$0000,$4000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000

Up_Image1:
	dc.w	0,0
	dc.w	$0024,$0010,$0003
	dc.l	Imagedata$
	dc.b	$07,$00
	dc.l	0

Imagedata$:
	dc.w	$7FFF,$FFFF,$E000,$8000,$0000,$1000,$8000,$0000,$3000,$8000,$0000,$3000,$8000,$0000,$3000,$8000,$0000,$3000,$8040,$0000,$3000,$80A0,$0000,$3000,$8111,$0010,$3000,$820A,$8228,$3000,$8404,$5544,$3000,$8800,$2083,$3000,$8000,$0000,$3000,$8000,$0000,$3000,$BFFF,$FFFF,$F000,$7FFF,$FFFF,$E000,$0000,$0000
	dc.w	$0000,$7FFF,$FFFF,$E000,$4000,$0000,$0000,$4000,$0000,$0000,$4000,$0000,$0000,$4000,$0000,$0000,$4000,$0000,$0000,$4040,$0000,$0000,$40E0,$0000,$0000,$41F1,$0010,$0000,$43FB,$8238,$0000,$47FF,$DF7C,$0000,$4000,$0000,$0000,$4000,$0000,$0000,$4000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000

Upline_Image1:
	dc.w	0,0
	dc.w	$0024,$0010,$0003
	dc.l	Imagedata$
	dc.b	$07,$00
	dc.l	0

Imagedata$:
	dc.w	$7FFF,$FFFF,$E000,$8000,$0000,$1000,$8000,$0000,$3000,$8000,$0000,$3000,$8000,$0000,$3000,$8000,$0000,$3000,$8000,$0000,$3000,$8200,$0000,$3000,$8202,$0000,$3000,$8A0A,$0020,$3000,$8A8A,$88AA,$3000,$8AAA,$AAAA,$3000,$8000,$0000,$3000,$8000,$0000,$3000,$BFFF,$FFFF,$F000,$7FFF,$FFFF,$E000,$0000,$0000
	dc.w	$0000,$7FFF,$FFFF,$E000,$4000,$0000,$0000,$4000,$0000,$0000,$4000,$0000,$0000,$4000,$0000,$0000,$4000,$0000,$0000,$4000,$0000,$0000,$4000,$0000,$0000,$4000,$0000,$0000,$4000,$0000,$0000,$4000,$0000,$0000,$4000,$0000,$0000,$4000,$0000,$0000,$4000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
