*****************************************************************************
**                                                                         **
** Engine: Extractor (handle archives with sound modules)                  **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Author : Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 


*----------------------------------------------------------------------------*
* Files mglichst nur nach t: ohne Dirs saven
* bei Extract:
*	 Auf T:<Filename> testen
*	 auf T:Dir <Filename> testen
*	 Filenamen zurckgeben
*


Executable	= 1
Test		= 0
Debugger	= 0
Extractortest	= 0			*Extractoren testen


	incdir	include:
	include	exec/exec_lib.i
	include	dos/dos_lib.i
	include	dos/dos.i
	include	exec/libraries.i
	include	exec/interrupts.i
	include	libraries/diskfont_lib.i
	include	intuition/intuition.i
	include	intuition/intuition_LIB.i
	include	graphics/graphics_lib.i
	include	misc/BuggsMacros.i
	include	misc/EagleplayerEngine.i
	include	libraries/asl_lib.i
	include	libraries/asl.i
	include	libraries/gadtools.i
	include	libraries/gadtools_lib.i
	include	libraries/locale_lib.i

	include "intuition/icclass.i"
	include "intuition/classes.i"
        include "intuition/classusr.i"
        include "intuition/imageclass.i"
	include	libraries/utility_lib.i




;===========================================================================
;		Definitionen & Vereinbarungen 
;===========================================================================
Defheight	=	198	;def. Innerheight
Defwidth	=	460	;def. Innerwidth
Defminwidth	=	120
Defminheight	=	70
ZoomWidth = 180
YOffset			= 8		* fr TopPos
StringGadgetOffset	= 8		* Zur Fonthhe fr Stringgadgetheight

TextPufferSize	= fib_sizeof
PfadPufferSize	= 150
OptionsPufferSize = 50
DazuBytes		= 100



		STRUCTURE	MY_ListStruct,0
		STRUCT		ML_Node,LN_Size
		ULONG		ML_Size
		LABEL		ML_Chars


		STRUCTURE	EP_ARCHIVE,0
		UWORD	EPAT_Name		* Offs. to Name fr Listview
		UWORD	EPAT_InfoLNr		* Offs. to Infotext fr Listview
		UWORD	EPAT_Suffix		* Offs. to Suffix
		UWORD	EPAT_Test		* TestValidArchive
		UWORD	EPAT_Seek		* OpenArchive
		UWORD	EPAT_ExNext		* ArchiveExNext
		UWORD	EPAT_DefPath		* Def. Pfad
		UWORD	EPAT_DefOptions		* Def. Options
		UWORD	EPAT_State		* Erlaubt oder nicht ?
		LABEL	EPAT_SizeOf

		*(only for internal use)
		STRUCTURE EPAI_ARCHIVEINFO,0	*only filled by Engine !!!
		WORD	EPAI_EngineNr
		APTR	EPAI_EPAT_Struct
		LONG	EPAI_StructSize
		LONG	EPAI_Handle
		*APTR	EPAI_ArchivePos
		LABEL	EPAI_SizeOf		*to be extended

		rsreset
		rs.b	1
*EPAIT_ARC	rs.b	1
EPAIT_ARJ	rs.b	1
EPAIT_HA	rs.b	1
EPAIT_LHA	rs.b	1
EPAIT_LhArc	rs.b	1
EPAIT_LZX	rs.b	1
EPAIT_RAR	rs.b	1
EPAIT_SHR	rs.b	1
;EPAIT_SQZ	rs.b	1
;EPAIT_Tar	rs.b	1
EPAIT_ZIP	rs.b	1
EPAIT_ZOO	rs.b	1
EPAIT_MaxId	EQU	EPAIT_Zoo


			rsreset
			rs.b	1
EPENr_FirstNummer	rs.b	0
EPENr_ArchiveList	rs.b	1
EPENr_ArchiveInfo	rs.b	1
EPENr_Pfad		rs.b	1
EPENr_Options		rs.b	1
EPENr_GetFile		rs.b	1

			rsreset
			rs.b	1
LENr_WindowTitle	rs.b	1
LENr_ScreenTitle	rs.b	1
LENr_ArchiveList	rs.b	1
LENr_ArchiveInfo	rs.b	1
LENr_Pfad		rs.b	1
LENr_Options		rs.b	1
LENr_Project		rs.b	1
LENr_Config		rs.b	1
LENr_About		rs.b	1
LENr_AboutKey		rs.b	1
LENr_Hide		rs.b	1
LENr_HideKey		rs.b	1
LENr_Quit		rs.b	1
*LENr_QuitKey		rs.b	1
LENr_Ok			rs.b	1
LENr_DefaultConfig	rs.b	1
LENr_DefaultConfigKey	rs.b	1
LENr_LoadConfig		rs.b	1
LENr_LoadConfigKey	rs.b	1
LENr_SaveConfig		rs.b	1
LENr_SaveConfigKey	rs.b	1
LENr_RequestTitle	rs.b	1
LENr_AboutText		rs.b	1
LENr_EPNotFound		rs.b	1

*LENr_InfoArc		rs.b	1
LENr_InfoArj		rs.b	1
LENr_InfoHa		rs.b	1
LENr_InfoLha		rs.b	1
LENr_InfoLhArc		rs.b	1
LENr_InfoLzx		rs.b	1
LENr_InfoRAR		rs.b	1
LENr_InfoSHR		rs.b	1
*LENr_InfoSQZ		rs.b	1
*LENr_InfoTar		rs.b	1
LENr_InfoZIP		rs.b	1
LENr_InfoZOO		rs.b	1


LENr_LastExternal	rs.b	0

*AbstandLinks	= 2		*Abstand der Gadgets vom Rand des Windows
*AbstandOben	= 3
GadgetAnz	= 4

win_breite	=	DefWidth

			rsreset
TextPuffer		rs.b	TextPufferSize
			if	test
			if	extractortest
ExtractorPuffer		rs.b	200
			endc
			endc
LocalePuffer		rs.w	LENr_LastExternal
GadgetMerkPuffer	rs.l	GadgetAnz+2
MyTags			rs.l	10*2
BufNewGad		rs.b	gng_sizeof	*Buffer fr Gadgetcreieren
MyFont			rs.l	2
MY_Easystruct		rs.l	5	;EASY-Request
Archivelist		rs.b	lh_size
Archiveinfo		rs.b	lh_size
CurrentSeconds		rs.l	1
CurrentMicros		rs.l	1
StartSeconds		rs.l	1
StartMicros		rs.l	1
MyFileAdr		rs.l	1
MyFileSize		rs.l	1
MyCatalog		rs.l	1
MyTaskAdr		rs.l	1
GadgetListadr		rs.l	1
MenuAdr			rs.l	1
VisualInfo		rs.l	1
MyPubScreen		rs.l	1
WinHandle		rs.l	1
WindowPort		rs.l	1
OldMenuAdr		rs.l	1
SelectedArchive		rs.l	1
MyMessage		rs.b	UM_SizeOf
MerkUserNr		rs.w	1
MsgUnterwegs		rs.l	1
ExitNow			rs.w	1
MsgPort			rs.l	1
UPrg_Struct		rs.l	1
Signal			rs.l	1
SignalBits		rs.l	1
Font			rs.l	1
FontX			rs.w	1
FontY			rs.w	1
OffX			rs.w	1
OffY			rs.w	1
WinPosX			rs.w	1
WinPosY			rs.w	1
WinHeight		rs.w	1
WinWidth		rs.w	1
ZoomPosX		rs.w	1
ZoomPosY		rs.w	1
InfoWidth		rs.w	1
InfoWidth2		rs.w	1
WindowDisabled		rs.w	1
IntBase			rs.l	1
GFXBase			rs.l	1
DosBase			rs.l	1
GadBase			rs.l	1
LocaleBase		rs.l	1
RealNumGadgets		rs.l	1
Result			rs.l	1		*Result bei GetGadgetattr
ZoomState		rs.b	1
ArchiveListeDa		rs.b	1
ArchiveInfoDa		rs.b	1
AllPfadPuffer		rs.b	(EPAIT_MaxId)*PfadPufferSize
AllOptionsPuffer	rs.b	(EPAIT_MaxId)*OptionsPufferSize
PufferEnd		rs.b	0


EB	macro
	if	test
	move.l	4,a6
	else
	move.l	4.w,a6
	endc
	ENDM

;===========================================================================
	section	0,code
;===========================================================================

		ifeq	Debugger
		if	test
Start		bsr	FirstEagleInit
		bsr	FirstInit

		ifne	extractortest

		lea	Puffer,a5


		*-----------------------------------------
		* Input: a0=Pfad
		* Output:d0=Error oder NULL
		*	 d1=Archivestructur (engineintern)
		*-----------------------------------------
		bsr	ClearRegs
		lea	Archivename,a0
		bsr	EP_TestValidArchive
		bne.s	.Error

		*------------------------------
		* Input: a0=Pfad des Archives
		* Output:d0=Error oder NULL
		*	 a0=Structadr
		*------------------------------
		bsr	Clearregs
		lea	ArchiveName,a0
		bsr	EP_OpenArchive
		bne.s	.Error
		move.l	a0,a4

		*----------------------------
		* Input: a0=StructAdr	
		*	 a1=Pfadadr (Ziel)
		*	 d1=Pfadsize
		* Output:d0=Error oder NULL
		*----------------------------
.NextEntry:	move.l	a4,-(a7)
		bsr	Clearregs
		move.l	(a7),a0
		lea	ExtractorPuffer+Puffer,a1
		move.w	#200-2,d1
		bsr	EP_ArchiveExNext
		move.l	(a7)+,a4
		beq.s	.NextEntry
	*	cmp.b	#EPR_BufferFull,d0
	*	bne.s	.RealError

		*--------------------
		* Input: a0=StructAdr
		*--------------------
		move.l	a4,a0
		move.l	a0,-(a7)
		bsr	Clearregs
		move.l	(a7)+,a0
		bsr	EP_CloseArchive


		*------------- Engines aufrufen ----------------*
		* In WorkPuffer steht dann der neue Filename    *
		* zB."Mod.Test" Das File wird vom EP gelscht.	*
		*-----------------------------------------------*
		* Input: a0=Pfad des Archives			*
		*	 a1=Pfad des Namens im Archive		*
		*	 a2=WorkPuffer fr Befehlspfad		*
		*	 d2=WorkPufferSize			*
		* Output:d0=Error oder NULL			*
		*-----------------------------------------------*
		bsr	ClearRegs
		lea	Puffer,a5
		lea	Archivename,a0
		lea	ArchiveEntryName,a1
		lea	ExtractorPuffer(a5),a2
		move.w	#200-2,d2
		bsr	EP_ExtractArchiveEntry



.Error:
		endc
		illegal

ClearRegs:	moveq	#0,d0
		moveq	#0,d1
		moveq	#0,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		moveq	#0,d6
		moveq	#0,d7
		sub.l	a0,a0
		sub.l	a1,a1
		sub.l	a2,a2
		sub.l	a3,a3
		sub.l	a4,a4
		sub.l	a5,a5
		sub.l	a6,a6
		rts

FirstEagleInit:	lea	EaglePuffer,a5
		move.l	a5,EUS_EPBase+EUS_Structure

		lea	MyIntuiname,a1
		EB
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,DTG_Intuitionbase(a5)

		lea	MyGFXname,a1
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,DTG_GFXbase(a5)

		lea	MyGadToolsname,a1
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,DTG_GadToolsbase(a5)

		lea	MyLocalename,a1
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,EPG_Localebase(a5)

		lea	MyDosname,a1
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,DTG_Dosbase(a5)
		rts
MyIntuiname:	dc.b	"intuition.library",0
MyGFXname:	dc.b	"graphics.library",0
MyGadtoolsname:	dc.b	"gadtools.library",0
MyLocalename:	dc.b	"locale.library",0
MyDosname:	dc.b	"dos.library",0
		even
EaglePuffer	ds.b	EPG_SizeOf
		endc
		endc

*-----------------------------------------------------------------------------*
*-----				Start Programm				------*
*-----------------------------------------------------------------------------*
EUS_Structure:	bra.w	FirstInit			;EUS_Jump
		EUSN_Identifier				;EUS_Identifier
		dc.l	0				;EUS_Next
		dc.w	0				;EUS_Usernr
EPBase		dc.l	0				;EUS_EPBase
		dc.l	0				;EUS_FreeTable
		dc.l	0				;EUS_TaskAdr = NULL
		dc.l	0				;EUS_UnUsed1
		dc.l	0				;EUS_UnUsed2
		dc.l	0				;EUS_UnUsed3
		dc.l	TagListe			;EUS_Taglist
		dc.w	0				;EUS_Ticks
		dc.w	0				;EUS_TickCounter
		dc.l	0				;EUS_TickFlags
		dc.l	USMB_WaitPointer!USMB_Configuration!USMB_SaveConfig!USMB_Zipwin!USMB_ChangeConfig!USMB_LoadConfig	;EUS_MsgFlags
		dc.l	MyProzessName			;EUS_PName
		dc.l	MyCreatorname			;EUS_Creator
		dc.l	MySpecialinfo			;EUS_AboutUPRG
		dc.w	37				;EUS_Kickstart
		dc.l	11				;EUS_EPVersion
		dc.w	1				;EUS_Version
		dc.w	2				;EUS_Revision
		dc.l	MyProzessName			;EUS_Username
		dc.w	200				;EUS_WinX
		dc.w	$62 14				;EUS_WinY
		dc.w	EUSB_Openwin			;EUS_Flags
EUS_Width	dc.w	DefWidth		;EUS_Special  -> InnerWidth
EUS_Height	dc.w	Defheight		;EUS_Special+2 -> InnerHeigth
		dc.l	0				;EUS_Special2
ZoomX		equ	EUS_Special2
ZoomY		equ	EUS_Special2+2
ZoomONOFF	equ	EUS_Special3
*Sysfontonoff	equ	EUS_Special+1

		dc.l	0				;EUS_Special3
		dc.b	30,09
		dc.w	1996				;EUS_Creatordate
		dc.b	0				;EUS_Prioritt
		dc.b	EUTY_Extractor			;EUS_Type
		dc.w	0				;EUS_Reserved2
		dc.l	0				;EUS_Reserved3
		dc.l	0				;EUS_Reserved4
		dc.l	0				;EUS_Reserved5
		dc.l	0				;EUS_Reserved6
		ifne	(*-EUS_Structure)-EUS_SizeOF
		Aber Hallo
		endc

		dc.b	"$VER: Eagleplayer-Extractor V1.2 (30 Sep 1996)",0
		even

TagListe:
		dc.l	EUT_TestValidArchive,EP_TestValidArchive
		dc.l	EUT_ExtractArchiveEntry,EP_ExtractArchiveEntry
		dc.l	EUT_OpenArchive,EP_OpenArchive
		dc.l	EUT_ArchiveExNext,EP_ArchiveExNext
		dc.l	EUT_CloseArchive,EP_CloseArchive
		dc.l	EUT_EPSubItems,EP_Menu

		dc.l	EUT_SpecialinfoLNr,LNrE_SpecialInfo_Extractor
		dc.l	0

*----------------------------------------------------------------------------*
FirstInit:	lea	Puffer,a5		;BSS lschen
		EB
		cmp.w	#37,LIB_Version(a6)	;EXEC V37 ?
		blo	Exit			;nein,raus
	*	bsr	ClrPuffer


		if	Debugger
		lea	EPUserPortName(pc),a1
		EB
		jsr	_LVOFindPort(a6)
		move.l	d0,a0
		tst.l	d0
		beq.w	Exit
		cmp.l	#"EPGL",36(a0)
		bne.w	Exit
		move.l	40(a0),EUS_Structure+EUS_EPBase
		endc



		move.l	EUS_Structure+EUS_EPBase(pc),d0
		beq.w	Exit




		move.l	a5,a0
		move.w	#PufferEnd-1,d0
.clr		clr.b	(a0)+
		dbf	d0,.clr

		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	DTG_Intuitionbase(a4),Intbase(a5)
		move.l	DTG_GFXBase(a4),GFXBase(a5)
		move.l	EPG_LocaleBase(a4),LocaleBase(a5)
		move.l	DTG_GadtoolsBase(a4),GadBase(a5)
		move.l	DTG_Dosbase(a4),DosBase(a5)



		lea	EUS_Structure(pc),a0
		move.b	ZoomOnOff(a0),ZoomState(a5)
		move	Eus_Winx(a0),WinPosX(a5)
		move	Eus_Winy(a0),WinPosY(a5)
		move	ZoomX(a0),ZoomPosX(a5)
		move	ZoomY(a0),ZoomPosY(a5)

		move.l	#EPAIT_LHA,SelectedArchive(a5)
		lea	ArchiveList(a5),a0
		Newlist	a0
		lea	ArchiveInfo(a5),a0
		Newlist	a0

		bsr	InsertDefaultConfig


	*---------------- Config laden ---------------*
.FullFertig:	bsr	InsertConfig
		bsr	FirstLocaleInit

		*bsr	InitLocale


		sub.l	a1,a1
		EB
		jsr	_LVOFindTask(a6)
		move.l	d0,MyTaskAdr(a5)



*-------------------------- Mesage an Eagleplayer schicken -----------------*
*---- Input:	;d1 = Enabled(0) oder Disabled(1)			----*
*----		d2 = US_Class						----*
*----		d3 = Command						----*
*----		d4 = ArgList						----*
*----		d5 = Result						----*
	if Executable+Debugger
		if debugger
		move.l	#EUS_Structure,d5
		else
		moveq	#0,d5
		endc
		moveq	#0,d1
		moveq	#USClass_NewUserPrg,d2
		moveq	#0,d3
		moveq	#0,d4
		if	debugger
		move.w	#-2,MerkUserNr(a5)
		endc
		bsr	SendeOneMessage
		if	debugger
		move.w	MyMessage+UM_UserNr(a5),MerkUserNr(a5)
		tst.l	d0
		endc
	else
		ifeq	extractortest
		bsr.w	OpenWin
		endc
	endc
		ifeq	extractortest
		beq.s	ExitEngine
	
	*------------ Hauptprogramm ablaufen lassen ------------*
		*move.w	EUS_Structure+EUS_Flags(pc),d0
		*btst	#EUSF_Show,d0
		*beq.s	.NoShow
		*bsr	OpenWin
.NoShow:	bsr.w	Warten
		endc



*-----------------------------------------------------------------------------*
ExitEngine:	lea	Puffer,a5

		bsr	WaitUserMessages
		bsr	CloseWin
		bsr	RemoveMsgPort

Exit:		moveq	#EPR_ErrorAddUserPrg,d0
		rts



**-----------------------------------------------------------------------------*
** Input: d0	= EPNr_Nummer
**	 d2/a2	= Arg1
**	 d3/a3	= Arg3
** Output:d0	= Error oder NULL
**-----------------------------------------------------------------------------*
*EP_Command:	lea	Puffer,a5
*		cmp.w	#EPNr_EngineItemCommand,d0
*		bne.s	.Return
*
*.Return:	moveq	#0,d0
*		rts
*
*


SendeOneMessage:
		movem.l	d1-a6,-(a7)
	if	executable+debugger
		bsr	CreateMsgPort
		beq.w	.Fehler
		bsr	WaitUserMessages

		*bsr	AllocMsg
		*beq	.fehler
		*move.l	d0,a1
		lea	MyMessage(a5),a1

	*------------ Exec-Message initialisieren -----------*
		move.w	#UM_Sizeof-20,MN_Length(a1)
		move.b	#NT_Message,LN_Type(a1)
		move.l	MsgPort(a5),MN_ReplyPort(a1)

	*------------ User-Message initialisieren -----------*
		if	debugger
		move.w	MerkUserNr(a5),UM_UserNr(a1)
		else
		move.w	EUS_Structure+EUS_UserNr(pc),UM_UserNr(a1)
		endc
		move.l	MyTaskAdr(a5),UM_TaskAdr(a1)
		move.l	Signal(a5),UM_Signal(a1)
		move.l	MsgPort(a5),UM_UserPort(a1)
		move.l	#USM_Userprg,UM_Type(a1)
		move.w	d1,UM_Enabled(a1)
		move.w	d2,UM_Class(a1)			;Kennung setzen
		move.l	d3,UM_Command(a1)
		move.l	d4,UM_ArgString(a1)
		move.l	d5,UM_Result(a1)

		*move.l	a1,ThisMessage(A5)

	*------------ Message senden -------------*
.RetryFindPort:	lea	EPUserPortName(pc),a1
		EB
		jsr	_LVOFindPort(a6)
		move.l	d0,a0
		tst.l	d0
		bne.s	.PortDa

	*----- Eagleplayer-Port nicht gefunden ----*
		moveq	#LENr_EPNotFound,d0
		bsr	TextRequest
		moveq	#0,d0
		bra.s	.Fehler
		*beq.s	.Fehler
		*bra.s	.RetryFindPort

.PortDa:	movem.l	d0/a0,-(a7)
		*move.l	ThisMessage(A5),a1
		lea	MyMessage(a5),a1

		move.l	UM_TaskAdr(a1),d0
		beq.s	.NoTask
		move.l	d0,a1
		moveq	#0,d0
		jsr	_LVOSetTaskPri(a6)	
.NoTask:	movem.l	(a7)+,d0/a0
		*move.l	ThisMessage(A5),a1
		lea	MyMessage(a5),a1
		jsr	_LVOPutMsg(a6)

		addq.l	#1,MsgUnterwegs(a5)

	*---------- Alles klar, Ende ----------*
.NoPort:	bsr	WaitUserMessages
		moveq	#-1,d0
.Fehler:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts
		endc


*-----------------------------------------------------------------------------*
CreateMsgPort:	movem.l	d1-d7/a1-a6,-(a7)
		move.l	MsgPort(a5),d0
		bne.s	.PortOk
		EB
		jsr	_LVOCreateMsgPort(a6)	;Messageport auf die schnelle Art
		move.l	d0,MSGport(a5)
		tst.l	d0
		beq.s	.PortOk
		move.l	d0,a1
		move.l	#MyMsgPortName,LN_Name(a1)
		jsr	_LVOAddPort(a6)


	*----------- SignalBits setzen ------------*
		move.l	MsgPort(a5),a0
		move.l	SignalBits(a5),d6
		moveq	#0,d0
		move.b	15(a0),d0
		bset	d0,d6
		move.l	d6,SignalBits(a5)

.PortOk:	movem.l	(a7)+,d1-d7/a1-a6
		move.l	MsgPort(a5),d0
		move.l	d0,a0
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
RemoveMsgPort:	movem.l	d0-a6,-(a7)

	*----------- SignalBits sperren ------------*
		move.l	MSGport(a5),d0
		beq.s	.PortOk
		move.l	d0,a1
		move.l	SignalBits(a5),d1
		moveq	#0,d0
		move.b	15(a1),d0
		bclr	d0,d1
		move.l	d1,SignalBits(a5)
		EB
		jsr	_LVORemPort(a6)

		move.l	MsgPort(a5),a0
		jsr	_LVODeleteMsgPort(a6)	;Messageport auf die schnelle Art
		clr.l	MsgPort(a5)
.PortOk:	movem.l	(a7)+,d0-a6
		rts

*----------------------- Gibt die Return-Structure frei -------------------*
FreeCommandStruct:
		movem.l d0/d1/a0/a1/a4/a6,-(a7)
		move.l	UPrg_Struct(a5),a4
.NextStruct:	moveq	#0,d0
		cmp.l	a4,d0
		beq.w	.Return
		move.l	a4,a1
		move.l	(a1),a4
		move.l	EPT_StringSize(a1),d0
		beq.s	.StructFree
		EB
		jsr	_LVOFreeMem(a6)
.StructFree:	bra.b	.NextStruct
.Return:
		clr.l	UPrg_Struct(a5)
		movem.l	(a7)+,d0/d1/a0/a1/a4/a6
		rts

*---------------------------------------------------------------------------*
*----- Wartet, bis alle Messages von den Userprogrammen wieder da sind -----*
*---------------------------------------------------------------------------*
WaitUserMessages:movem.l d0-a6,-(a7)

	if debugger
*		bsr.w	CopyEPBase
	endc

.WaitNochmal:	tst.l	MsgUnterwegs(a5)
		beq.w	.Return
		move.l	4,a6
		bsr	CreateMsgPort
		beq.s	.Return
		move.l	a0,a3
		jsr	_LVOWaitPort(a6)
		move.l	a3,a0
		jsr	_LVOGetMsg(a6)
		tst.l	d0
		beq.s	.WaitNochmal
		move.l	d0,a1
		bsr	UserMessage
		bra.s	.WaitNochmal
.Return:	movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
*ClrPuffer:	move.l	a5,a0
*		move.w	#PufferEnd-1,d0
*.clr		clr.b	(a0)+
*		dbf	d0,.clr
*CopyEPBase:	move.l	EUS_Structure+EUS_EPBase(pc),d0
*		beq.s	.Fertig
*		move.l	d0,a0
*		*move.l	a0,EPBase(a5)
*		move.w	#EPG_SizeOf/2-1,d0
*		move.l	a5,a1
*.CopyEP:	move.w	(a0)+,(a1)+
*		dbf	d0,.CopyEP
*.Fertig:	rts

*---------------------------------------------------------------------------*
*------------ Hier befindet sich nun die Schleife die Aktionen -------------*
*---------------------------------------------------------------------------*
Warten:		tst.w	ExitNow(a5)
		bne.w	Return

		move.l	MsgPort(a5),d0
		beq.s	WartenWinPort
		move.l	d0,a0
		EB
		jsr	_LVOGetmsg(a6)
		tst.l	d0			;Scrollen erlaubt
		beq.w	WartenWinPort
		bsr.w	UserMessage
		bra.w	Warten

SendExit:	moveq	#0,d1
		moveq	#USClass_Exit,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		bsr	SendeOneMessage
Return:		rts

WartenWinPort:	move.l	WindowPort(a5),d0
		beq.s	Wait
		move.l	d0,a0
		move.l	GadBase(a5),a6
		jsr	_LVOGT_GetIMsg(a6)
		tst.l	d0
		beq.s	Wait
		move.l	d0,a1
		bsr.w	GetMsg

		cmp.w	#EPNr_Engine,d0
		bne.s	Warten
		rts

*----------------------------------------------------------------------------*
*------------- Hier wait, bis einer der Message-Ports ->>> Message ----------*
*----------------------------------------------------------------------------*
Wait:		move.l	SignalBits(a5),d0
		or.w	#$1000,d0		;Break-Signal
		EB
		jsr	_LVOWait(a6)

	*------- War es ein Break Signal -----*
		btst	#12,d0			;Break-Signal
		bne.w	SendExit

	*------- War es ein UserMessage ------*
		move.l	MsgPort(a5),d2
		beq.s	.NoPort
		move.l	d2,a0
		moveq	#0,d1
		move.b	15(a0),d1
		btst	d1,d0
		bne.w	Warten			;EaglePort

	*----- war es eine Window-Message ----*
.NoPort:	move.l	WindowPort(a5),d2		;Testen ob Window-Port
		beq.s	.NoMain
		move.l	d2,a0
		move.b	15(a0),d1
		btst	d1,d0
		bne.w	WartenWinPort
.NoMain:	bra.w	Wait



*------------------------ Defaultconfig setzen -------------------------------*
InsertDefaultConfig:
		movem.l	d0-a6,-(a7)
		lea	ArchiverTabelle-EPAT_SizeOf(pc),a4
		lea	AllPfadPuffer-PfadPufferSize(a5),a2
		lea	AllOptionsPuffer-OptionsPufferSize(a5),a3
.PufferFullLoop:lea	EPAT_SizeOf(a4),a4
		tst.w	EPAT_Name(a4)
		beq.s	.Return
		lea	ArchiverTabelle(pc),a0
		lea	PfadPufferSize(a2),a2
		lea	OptionsPufferSize(a3),a3
		moveq	#0,d0
		move.w	EPAT_DefPath(a4),d0
		add.l	a0,d0
		move.l	d0,a0
		move.l	a2,a1
		move.w	#PfadPufferSize-1,d1
		bsr	StringCopy

		lea	ArchiverTabelle(pc),a0
		moveq	#0,d0
		move.w	EPAT_DefOptions(a4),d0
		add.l	a0,d0
		move.l	d0,a0
		move.l	a3,a1
		move.w	#OptionsPufferSize-1,d1
		bsr	StringCopy
		bra.s	.PufferFullLoop
.Return		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
InsertConfig:	movem.l	d1-a6,-(a7)

		moveq	#0,d7				*Dir Change
		move.l	EUS_Structure+EUS_EPBase(pc),a4
	if	executable+debugger
		move.l	EPG_ConfigDirArrayPtr(a4),d1
		beq.s	.NoConfigDir
	else
		move.l	#Configdir,d1
	endc
		move.l	Dosbase(a5),a6
		move.l	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.s	.NoConfigDir
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1

.NoConfigDir:	lea	ConfigName(pc),a1
		bsr	LadeFile
		move.l	d0,-(a7)
		tst.l	d1
		beq.s	.NoConfigDir2		
		move.l	Dosbase(a5),a6
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnlock(a6)
.NoConfigDir2:	move.l	(a7)+,d0
		tst.l	d0
		beq.w	.Error

		*-- Jetzt Config in Puffer setzen --*
		move.l	MyFileAdr(a5),d0
		beq.w	.Return
		move.l	d0,a3
.FindArcStart:	move.b	(a3)+,d0
		beq.w	.Return
		cmp.b	#".",d0
		bne.s	.FindArcStart

		*-- Jetzt ist der ein Archiver gefunden --*
		lea	-1(a3),a0
		bsr	ZeilenLen
		beq.w	.Return
		lea	(a3,d0.w),a3
		clr.b	(a0,d0.w)
		lea	ArchiverTabelle-EPAT_SizeOf(pc),a4
		moveq	#0,d3
.NextArchiver:	addq.l	#1,d3
		lea	EPAT_SizeOf(a4),a4
		tst.w	EPAT_Name(a4)
		beq.s	.FindArcStart
		lea	ArchiverTabelle(pc),a1
		moveq	#0,d0
		move.w	EPAT_Suffix(a4),d0
		add.l	a1,d0
		move.l	d0,a1
		bsr	StrCmp
		bne.s	.NextArchiver

		move.l	a3,a0				*Status festlegen
		bsr	ZeilenLen
		beq.s	.FindArcStart
		move.l	d0,d1
		clr.b	(a0,d0.w)
		move.w	#1,EPAT_State(a4)
		lea	On(pc),a1
		bsr	StrCmp
		beq.s	.StateOk
		lea	Off(pc),a1
		bsr	StrCmp
		bne.s	.FindArcStart
		clr.w	EPAT_State(a4)

.StateOk:	lea	1(a0,d1.w),a0
		lea	AllPfadPuffer-PfadPufferSize(a5),a1
		move.l	d3,d1
		mulu	#PfadPufferSize,d1
		lea	(a1,d1.w),a1
		bsr	ZeilenLen
		move.l	d0,d2
		clr.b	(a0,d0.w)
		subq.l	#1,d0
		move.l	d0,d1
		blt.w	.FindArcStart
		lea	1(a0,d2.w),a3
		bsr	StringCopy

		lea	(a3),a0
		lea	AllOptionsPuffer-OptionsPufferSize(a5),a1
		mulu	#OptionsPufferSize,d3
		lea	(a1,d3.w),a1
		bsr	ZeilenLen
		move.l	d0,d2
		subq.l	#1,d0
		move.l	d0,d1
		blt.w	.FindArcStart
		bsr	StringCopy
		lea	1(a3,d2.w),a3
		bra.w	.FindArcStart



.Return:	bsr	FreeFileMem
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts
.Error:		moveq	#EPR_ErrorInFile,d0
		bra.s	.Return

*-----------------------------------------------------------------------------*
SaveConfig:	movem.l	d1-a6,-(a7)

	ifeq	test
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_ConfigDirArrayPtr(a4),d1
		beq.s	.NoConfigDir
	else
		move.l	#Configdir,d1
	endc
		move.l	Dosbase(a5),a6
		moveq	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.s	.NoConfigDir
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1

.NoConfigDir:	move.l	d1,-(a7)
		lea	ConfigName(pc),a1
		move.l	a1,d1
		move.l	#1006,d2			*Mode_NewFile
		move.l	Dosbase(a5),a6
		jsr	_LVOOpen(a6)
		move.l	(a7)+,d1
		move.l	d0,-(a7)
		tst.l	d1
		beq.s	.NoConfigDir2
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnlock(a6)
.NoConfigDir2:	move.l	(a7)+,d6
		moveq	#EPR_FileNotFound,d0
		tst.l	d6
		beq.w	.Return

	*----------- Nun Config Schritt fr Schritt speichern ---------*
		lea	ConfigStart(pc),a0
		bsr	WriteText
		beq.w	.CloseConfig

		lea	ArchiverTabelle-EPAT_SizeOf(pc),a4
		moveq	#-1,d4
.NextArchiver:	lea	EPAT_SizeOf(a4),a4
		addq.l	#1,d4
		tst.w	EPAT_Name(a4)
		beq.s	.CloseConfig
		lea	ArchiverTabelle(pc),a0
		moveq	#0,d0
		move.w	EPAT_Suffix(a4),d0
		add.l	a0,d0
		move.l	d0,a0
		bsr	WriteText
		beq.s	.CloseConfig
		lea	NextLine(pc),a0
		bsr	WriteText
		beq.s	.CloseConfig

		*-- Zustand --*
		lea	Off(pc),a0
		tst.w	EPAT_State(a4)
		beq.s	.SaveOff
		lea	On(pc),a0
.SaveOff:	bsr	WriteText
		beq.s	.CloseConfig
		lea	NextLine(pc),a0
		bsr	WriteText
		beq.s	.CloseConfig

		*-- Pfad --*
		move.l	d4,d0
		lea	AllPfadPuffer(a5),a0
		mulu	#PfadPufferSize,d0
		lea	(a0,d0.w),a0
		bsr	WriteText
		beq.s	.CloseConfig
		lea	NextLine(pc),a0
		bsr	WriteText
		beq.s	.CloseConfig

		*-- Options --*
		move.l	d4,d0
		lea	AllOptionsPuffer(a5),a0
		mulu	#OptionsPufferSize,d0
		lea	(a0,d0.w),a0
		bsr	WriteText
		beq.s	.CloseConfig
		lea	NextLine-1(pc),a0
		bsr	WriteText
		beq.s	.CloseConfig

		bra.w	.NextArchiver

		*--- Datei Closen ---*
.CloseConfig:	move.l	d6,d1
		beq.s	.AllesOk
		move.l	Dosbase(a5),a6
		jsr	_LVOClose(a6)

.AllesOk:	moveq	#0,d0
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: a0=TextAdr
*	 d6=Handle
* Output:d0=Error
*-----------------------------------------------------------------------------*
WriteText:	movem.l	d1-a6,-(a7)
		moveq	#0,d0
		move.l	d6,d1
		beq.s	.Error
		bsr	BerechStringSize
		move.l	d0,d3
		beq.s	.Error
		move.l	a0,d2
		move.l	Dosbase(a5),a6
		jsr	_LVOWrite(a6)
		cmp.l	d0,d3
		beq.s	.Ok
		moveq	#0,d3
.Ok		move.l	d3,d0
.Error:		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*------------------------------ File Laden -----------------------------------*
* a1=Filenameadr
LadeFile:	movem.l	d1-a6,-(a7)
		moveq	#0,d6
		move.l	a1,d1
		move.l	#1005,d2
		move.l	Dosbase(a5),a6
		jsr	_LVOOpen(a6)
		move.l	d0,d6
		beq.s	.Error
		lea	TextPuffer(a5),a1
		move.l	a1,d2
		move.l	d6,d1
		jsr	_LVOExamineFH(a6)
		tst.l	d0
		beq.w	.Error

		move.l	TextPuffer+fib_size(a5),d5
		add.l	#DazuBytes,d5
		move.l	d5,d0
		move.l	#$10000,d1
		move.l	4,a6
		jsr	_LVOAllocMem(a6)
		move.l	d0,MyFileAdr(a5)
		beq.s	.Error
		move.l	d5,MyFileSize(a5)

		move.l	d6,d1
		move.l	d0,d2
		move.l	TextPuffer+fib_size(a5),d3
		move.l	Dosbase(a5),a6
		jsr	_LVORead(a6)
		cmp.l	d0,d3
		beq.s	.FreeHandle

.Error:		bsr	FreeFileMem
.FreeHandle:	move.l	d6,d1
		beq.s	.NoHandle
		move.l	Dosbase(a5),a6
		jsr	_LVOClose(a6)
.NoHandle:	move.l	MyFileAdr(a5),d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
FreeFileMem:	move.l	MyFileAdr(a5),d0
		beq.s	.NoMem
		move.l	d0,a1
		move.l	MyFileSize(a5),d0
		EB
		jsr	_LVOFreeMem(a6)
.NoMem:		clr.l	MyFileAdr(a5)	
		clr.l	MyFileSize(a5)
		rts

*-----------------------------------------------------------------------------*
* Berechnet, wie lange die Zeile im Text noch ist
* Input: a0=Zeile
* Output:d0=Lenght
ZeilenLen:	movem.l	d1/a0,-(a7)
		moveq	#-1,d0
.NextB		addq.l	#1,d0
		move.b	(a0)+,d1
		beq.s	.Ok
		cmp.b	#10,d1
		bne.s	.NextB
.Ok:		movem.l	(a7)+,d1/a0
		tst.l	d0
		rts



*-----------------------------------------------------------------------------*
* Vergleicht zwei Strings in a0 und a1 (A=a)				      *
* Input: a0=Text1							      *
* 	 a1=Text2							      *
* Output:d0=Null fr Gleich						      *
*-----------------------------------------------------------------------------*
StrCmp:		movem.l	d1/a0/a1,-(a7)
.Retry		move.b	(a0)+,d1
		beq.s	.Return		;0->Test bestanden,nun prfen,ob weitere
					;Argumente (z.B. Filter YES)

		cmp.b	#`A`,d1		;Kommando in Grobuchstaben
		blo.s	.NoD1Set		;umwandeln
		cmp.b	#`Z`,d1
		bhi.s	.NoD1Set
		bset	#5,d1		;bis auf Bit 5 alle bernehmen -> fertig

.NoD1Set:	move.b	(a1)+,d0	;Wert holen
		beq.s	.Error
		cmp.b	#10,d1
		beq.s	.Error
		cmp.b	#`A`,d0		;Kommando in Grobuchstaben
		blo.s	.NoBSet		;umwandeln
		cmp.b	#`Z`,d0
		bhi.s	.NoBSet
		bset	#5,d0		;bis auf Bit 5 alle bernehmen -> fertig
.NoBSet:	cmp.b	d1,d0
		beq.s	.Retry
.Error:		moveq	#EPR_ErrorInString,d0
		bra.s	.Fertig

.Return:	tst.b	(a1)
		bne.s	.Error
		moveq	#0,d0
.Fertig:	movem.l	(a7)+,d1/a0/a1
		tst.l	d0
		rts




*-----------------------------------------------------------------------------*
GetMsg:		lea	Puffer,a5
		*move.l	WindowPort(a5),d0
		*beq.w	.Return
		*move.l	d0,a0
		*move.l	GadBase(a5),a6
		*jsr	_LVOGT_getimsg(a6)
		*tst.l	d0
		*beq	.Return
		*move.l	d0,a1
		move.l	im_class(a1),d7
		moveq	#0,d5
		move.l	IM_Seconds(a1),CurrentSeconds(a5)
		move.l	IM_Micros(a1),CurrentMicros(a5)
		move.w	im_code(a1),d5 		<- Fr Tastatur / Selnummer Listview
		move.l	im_Iaddress(a1),d6 	<- Fr Gadgetabfrage
		move.l	im_seconds(a1),d2	<- fr Doppelclick
		move.l	im_micros(a1),d3	<- auch f. Doppelclick
		jsr	_LVOGT_ReplyIMsg(a6)

	*---------------- MSG auswerten -------------*
		cmp.l	#IDCMP_Changewindow,d7	;Refresh
		bne.s	.TestNewSize
		move.l	Winhandle(a5),a0
		move	OffY(A5),d0
		cmp	wd_height(a0),d0
		bne.s	.setposun
		move.w	wd_leftedge(a0),ZoomPosX(a5)
		move.w	wd_topedge(a0),ZoomPosY(a5)
		st	ZoomState(a5)
		bra.w	.Return
.Setposun:	move.w	wd_leftedge(a0),WinPosX(a5)
		move.w	wd_topedge(a0),WinPosY(a5)
		move.w	wd_Width(a0),WinWidth(a5)
		move.w	wd_Height(a0),WinHeight(a5)
		sf	ZoomState(a5)
		bra.w	.Return

.TestNewSize:	cmp.l	#NewSize,d7
		bne.s	.TestRefreshWindow

		move.l	Winhandle(a5),a0
		move	OffY(A5),d0
		cmp	WD_Height(a0),d0
		beq.s	.SizeNoMerk
		move.w	wd_Width(a0),WinWidth(a5)
		move.w	wd_Height(a0),WinHeight(a5)

.SizeNoMerk:	move.l	GadgetListAdr(a5),d0
		beq.s	.TestRefreshWindow
		move.l	d0,a1
		moveq	#0,d0
		move.w	RealNumGadgets(a5),d0
		move.l	Winhandle(a5),a0
		move.l	Intbase(a5),a6
		jsr	_LVORemoveGList(a6)
		bsr	FreeGadgets
		bsr	DeleteInfolist
	bra.w	.Return
*		bsr	Clearwindow
*		bsr	InitGadgets
*		bne.w	.Return
*		bsr	AddGads
*		*bne	.Return
*		bra.w	.Return

.TestRefreshWindow:
		cmp.l	#Refreshwindow,d7	;Refresh
		bne.s	.TestGadgetUp

	* ???
	*bsr	Clearwindow
	* ???

		tst.l	GadgetListadr(a5)	;wenn leer, wurde gerade eine
		bne.s	.NoSizeRefresh		;resize aufgerufen

		bsr	Clearwindow
		bsr	InitGadgets
		bne.w	.Return
		bsr	AddGads
		*bne	.Return

.NoSizeRefresh:

		move.l	Gadbase(a5),a6
		move.l	Winhandle(a5),a0	;*Window
		jsr	_LVOGT_beginrefresh(a6)

		move.l	Winhandle(a5),a0	;*Window
		moveq	#1,d0
		jsr	_LVOGT_Endrefresh(a6)

	bra.w	.return
*		move.l	GadgetListAdr(a5),a0
*		move.l	Winhandle(a5),a1
*		suba.l	a2,a2
*		moveq	#-1,d0
*		move.l	IntBase(a5),a6
*		jsr	_LVOrefreshglist(a6)
*
*		move.l	GadBase(a5),a6
*		move.l	Winhandle(a5),a0
*		sub.l	a1,a1
*		jsr	_LVOGT_RefreshWindow(a6)
*
*
*		bra.w	.Return

.TestGadgetUp:	cmp.l	#Gadgetup,d7
		bne.w	.TestMenu
		move.l	d6,a1
		move.w	GG_Gadgetid(a1),d4	;Nr des Gadgets
		cmp.w	#EPENr_Pfad,d4
		beq.w	.StringGG
		cmp.w	#EPENr_Options,d4
		beq.w	.StringGG
		cmp.w	#EPENr_ArchiveList,d4
		bne.w	.Return
		bsr	ArchiverListView
		bra.w	.Return

.StringGG:	bsr.w	StringPaths
		bra.w	.Return

.MenuLoop:	move.l	OldMenuAdr(a5),a1
		move.w	MI_NextSelect(A1),d5
		bra.s	.MenuNext
.TestMenu:	cmp.l	#MenuPick,d7
		bne.w	.TestRawKey
.MenuNext:	move.w	d5,d0
		cmp.w	#menunull,d0
		beq	.Return

		move.l	MenuAdr(a5),a0
		move.l	IntBase(a5),a6
		jsr	_LVOItemAddress(a6)
		move.l	d0,a1
		tst.l	d0
		beq	.Return
		move.l	d0,OldMenuAdr(a5)

		move.w	d5,d0
		move.w	d5,d1
		and.w	#$7e0,d0
		btst	#0,d1
		bne.s	.MenuTwo
		cmp.w	#64,d0		;2. Item ? (Hide)
		beq	.HideWindow	;Window schlieen und dies an Eagleplayer
					;signalisieren
		cmp.w	#$60,d0		;3. Item ? (Quit) (4.Item wegen Barla)
		beq	.QuitExtractor
		moveq	#LENr_AboutText,d0
		bsr	TextRequest		;Infotext ausgeben (Requester)
		bra	.Return

.MenuTwo:	tst.w	d0		;2. Item ? (Hide)
		beq.s	.DefaultConfig
		cmp.w	#64,d0
		beq.s	.LoadConfig
		cmp.w	#$60,d0
		bne.w	.Return
		bsr	SaveConfig
		bra.w	.Return

.DefaultConfig:	lea	ArchiverTabelle-EPAT_SizeOF(pc),a0
.DefaultNext:	lea	EPAT_SizeOF(a0),a0		* State neu setzen
		tst.w	EPAT_Name(a0)
		beq.s	.DefaultAll
		move.w	#1,EPAT_State(a0)
		bra.s	.DefaultNext
.DefaultAll:	bsr.w	InsertDefaultConfig
		bra.s	.RefreshList
.LoadConfig:	bsr.w	InsertConfig
.RefreshList:	bsr	DeleteArchiveList
		bsr	DeleteInfoList
		bsr.w	MakeArchiveList
		bsr.w	MakeArchiveInfo

		move.l	GadgetListAdr(a5),a0
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		moveq	#-1,d0
		move.l	IntBase(a5),a6
		jsr	_LVORefreshglist(a6)

		move.l	GadBase(a5),a6
		move.l	Winhandle(a5),a0
		sub.l	a1,a1
		jsr	_LVOGT_RefreshWindow(a6)

		bra	.Return

.TestRawkey:	cmp.l	#rawkey,d7
		bne	.TestCloseWindow
		
		cmp.b	#$18,d5			;"o" fr Optionen
		beq.s	.ActivateOpt
		cmp.b	#$19,d5			;"p" fr Optionen
		beq.s	.ActivatePfad
		cmp.b	#$45,d5			;ESC
		beq.w	.HideWindow
		cmp.b	#$4d,d5
		beq.s	.EinenRunter
		cmp.b	#$4c,d5
		beq.s	.EinenRauf
		cmp.b	#$44,d5
		beq.s	.ToggleZustand
		cmp.b	#$40,d5
		beq.s	.ToggleZustand
		bra.w	.Return

.ActivatePfad:	moveq	#EPENr_Pfad,d0
		bra.s	.Activate2
.ActivateOpt:	moveq	#EPENr_Options,d0
.Activate2:	bsr	GetGadgetAdr
		bne.w	.Return
		move.l	IntBase(a5),a6
		move.l	WinHandle(a5),d0
		beq.w	.Return
		move.l	d0,a1
		sub.l	a2,a2
		jsr	_LVOActivateGadget(a6)
		bra.w	.Return

.EinenRunter:	move.l	SelectedArchive(a5),d0
		cmp.l	#EPAIT_MaxId,d0
		beq.w	.Return
		addq.l	#1,d0
		moveq	#0,d1
		bsr	ChangeNowListViews
		bra.w	.Return

.EinenRauf:	move.l	SelectedArchive(a5),d0
		cmp.l	#2,d0
		blt.w	.Return
		subq.l	#1,d0
		moveq	#0,d1
		bsr	ChangeNowListViews
		bra.w	.Return

.ToggleZustand:	move.l	SelectedArchive(a5),d0
		cmp.l	#1,d0
		blt.w	.Return
		moveq	#1,d1
		bsr	ChangeNowListViews
		bra.w	.Return

.TestCloseWindow:cmp.l	#CloseWindow,d7
		bne	.Return

		
.HideWindow:	ifeq	executable+debugger
		move.w	#1,ExitNow(a5)
		moveq	#EPNr_Engine,d0
		bra.w	.Return
		else
		moveq	#0,d1
		moveq	#USClass_Hide,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		bsr	SendeOneMessage
		endc
		bra.w	.Return

.QuitExtractor:	move.w	#1,ExitNow(a5)
		ifeq	executable+debugger
		moveq	#EPNr_Engine,d0
		bra.s	.Return
		else
		moveq	#0,d1
		moveq	#USClass_Exit,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		bsr	SendeOneMessage
		endc
		moveq	#EPNr_Engine,d0
		bra.w	.Return2

.Return:	moveq	#0,d0
.Return2:	tst.l	d0
		rts


******************************************************************************
*---------------- Auswertung einer UserProgram-Message ----------------------*
******************************************************************************
*
*	Achtung 2. Ausgang der Routine bei Exit !!!!!!!!!!!!
*	Achtung 3. Ausgang der Routine bei UserQuitEagle !!!!!!!!!!!!
*
UserMessage:
		if Executable+Debugger
		move.l	d0,a1
		cmp.l	#USM_UserPrg,UM_Type(a1) ;Test auf Analyzer-MSG
		beq.w	.Auswertung
		cmp.l	#USM_Eagleplayer,UM_Type(a1) ;Test auf Analyzer-MSG
		bne.w	.ReplyIt3

	*--------------- Es ist ein Message angekommen ------------*
.Auswertung:	moveq	#0,d0
		move.w	UM_UserNr(a1),d0

		move.l	UM_ArgString(a1),UPrg_Struct(a5)
		moveq	#0,d0
		moveq	#0,d7
		move.w	UM_Class(a1),d7
		beq.w	.ReplyIt
		cmp.w	#USClass_NewUserPrg,d7
		beq.w	.NewConfig			;.NewUserPrg
		*cmp.w	#USClass_Activate,d7
		*beq.w	.OpenWindow
		cmp.w	#USClass_Show,d7
		beq.w	.OpenWindow
		*cmp.w	#USClass_DeActivate,d7
		*beq.w	.CloseWindow
		cmp.w	#USClass_Hide,d7
		beq.w	.CloseWindow
		cmp.w	#USClass_ZipWin,d7
		beq.w	.ZipWindow
		cmp.w	#USClass_UnZipWin,d7
		beq.w	.UnZipWindow
		cmp.w	#USClass_NewConfig,d7
		beq.w	.NewConfig
		cmp.w	#USClass_GetConfig,d7
		beq.w	.GetConfig
		cmp.w	#USClass_LoadConfig,d7
		beq.w	.LoadConfig
		cmp.w	#USClass_SaveConfig,d7
		beq.w	.SaveConfig
		cmp.w	#USClass_Exit,d7
		beq.w	.Exit
		cmp.w	#USClass_Command,d7
		beq.s	.Commando
		cmp.w	#USClass_SetWaitPointer,d7
		beq.w	.WaitPointer
		cmp.w	#USClass_ClearWaitPointer,d7
		beq.w	.ClearPointer
		moveq	#0,d0
		bra.w	.ReplyIt



	*-------- Ankommende Message sagt: "Kommando" ---*
.Commando:	move.l	UM_Command(a1),d0
		beq.w	.ReplyIt
		sub.l	a2,a2
		sub.l	a3,a3
		moveq	#0,d2
		moveq	#0,d3
		move.l	UM_ArgList(a1),d1
		cmp.w	#EPNr_EngineItemCommand,d0
		bne.s	.NormalesKommando
		tst.l	d1
		beq.w	.ReplyIt
		move.l	d1,a0
		move.l	ENA_Arg1(a0),d0			*Nummer des Items
		move.l	ENA_Next(a0),d1
.NormalesKommando:
		tst.l	d1
		beq.s	.Komm_NoMore
		move.l	d1,a0
		move.l	ENA_Arg1(a0),d2
		move.l	ENA_Arg2(a0),a2

		move.l	ENA_Next(a0),d1
		tst.l	d1
		beq.s	.Komm_NoMore
		move.l	d1,a0
		move.l	ENA_Arg1(a0),d3
		move.l	ENA_Arg2(a0),a3

.Komm_NoMore:	cmp.w	#EPNr_EngineShowState,d0
		beq.s	.OpenWindow
		bra.s	.ReplyIt


	*------- Ankommende Message sagt : "EXIT" -------*
.Exit:		move.w	#1,ExitNow(a5)
		bra.s	.ReplyIt		;Message replyen

	*----- Es wurde ein neue Config eingestellt -----*
.NewConfig:	move.w	EUS_Structure+EUS_Flags(pc),d0
		btst	#EUSF_Show,d0
		beq.s	.NewNoShow
		move.l	d0,-(a7)
		bsr.w	OpenWin
		move.l	(a7)+,d0
.NewNoShow:	btst	#EUSF_Activate,d0
		beq.s	.Activate
		btst	#EUSF_ZipWin,d0
		bne.s	.ZipWindow
		moveq	#USClass_Dummy,d0
		bra.s	.RePlyIt

	*-------- Extractor wird aktiviert -------*
.Activate:	moveq	#USClass_Activate,d0
		bra.s	.RePlyIt

	*-------- Extractor wird aktiviert -------*
.Deactivate:	moveq	#USClass_Deactivate,d0
		bra.s	.RePlyIt

	*------- Die Konfiguration wird gespeichert -----*
.LoadConfig:	bsr	InsertConfig
		moveq	#USClass_LoadConfig,d0
		bra.s	.ReplyIt

	*------- Die Konfiguration wird gespeichert -----*
.SaveConfig:	bsr	SaveConfig
		moveq	#USClass_SaveConfig,d0
		bra.s	.ReplyIt

	*- Der Eagleplayer mchte gerne die Config haben -*
.GetConfig:	bsr	MerkWindowSize
		moveq	#USClass_GetConfig,d0
		bra.s	.ReplyIt

	*------ Ankommende Message sagt : "CLOSE MY WINDOW" -----*
.CloseWindow:	bsr	CloseWin
		moveq	#USClass_Hide,d0
		bra.s	.ReplyIt

	*------ Angekommende Message sagt : "OPEN MY WINDOW" -----*
.OpenWindow:	bsr.w	OpenWin
		tst.l	d0
		beq.s	.CloseWindow
		moveq	#USClass_Show,d0
		bra.w	.ReplyIt

.WaitPointer:	bsr	WaitPointer
		bra.w	.ReplyIt

.ClearPointer:	bsr	ClearPointer
		bra.w	.ReplyIt

	*------ Ankommende Message sagt : "Zip my Window" -------*
.ZipWindow:	*bsr.w	ZipMyWindow
		moveq	#USClass_ZipWin,d0
		bra.s	.ReplyIt

	*------ Ankommende Message sagt : "UnZip my Window" -----*
.UnZipWindow:	*bsr.w	UnZipMyWindow
		moveq	#USClass_UnZipWin,d0


	*------- Message frs Replyen vorbereiten ------*
	*----------------- Class setzen ----------------*
.ReplyIt:	bsr.w	FreeCommandStruct
		move.l	a1,d1
		beq.s	.NoMSG
		clr.l	UM_Argstring(A1)
		move.l	a1,a0
		*move.l	UM_StructAdr(a1),StructAdr(a5)
		move.w	d0,UM_Class(a1)			;Dummy setzen
.ReplyIt3:	move.l	a1,d0
		beq.s	.NoMSG
		move.l	MSgPort(a5),a0
		cmp.l	14(a1),a0		;Reply-Port vergleichen
		beq.w	.ClearMerk
		EB
		jsr	_LVOReplymsg(a6)
.NoMSG:		rts

.ClearMerk:	subq.l	#1,MsgUnterwegs(a5)
		*bsr	freemsg			;meine Message, also freigeben
	endc
		rts

*-----------------------------------------------------------------------------*
MerkWindowSize:	movem.l	d0-a6,-(a7)
		lea	EUS_Structure(pc),a2
		move.w	EUS_Flags(a2),d0
		bclr	#EUSF_Show,d0			*Flags
		move.l	WinHandle(a5),d1
		beq.s	.GetNoWindow
		or.w	#EUSB_Show,d0

		move.w	WinPosX(a5),eus_winx(a2)	;Save Windowpostion
		move.w	WinPosY(a5),eus_winy(a2)
		move.w	WinWidth(a5),EUS_Special(a2)	;Save Windowpostion
		move.w	WinHeight(a5),EUS_Special+2(a2)
		move.w	ZoomposX(a5),Zoomx(a2)
		move.w	ZoomposY(A5),Zoomy(a2)
		move.b	Zoomstate(a5),ZoomONOFF(a2)
		*move.b	Onsysfont(A5),Sysfontonoff(a2)

.GetNoWindow:	move.w	d0,EUS_Flags(a2)
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
WaitPointer:	movem.l	a0/a1/a4/d0,-(a7)
		tst.l	WinHandle(a5)
		beq.s	.Return
		tst.w	WindowDisabled(a5)
		bne.s	.Return

		*--- Alle Menus disablen ---*
		*Input:a0=Window
		*      a1=Menu
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	WinHandle(a5),a0
		move.l	MenuAdr(a5),a1
		jsr	ENPP_SetWaitPointer(a4)

		move.w	#1,WindowDisabled(a5)

.Return:	movem.l	(sp)+,a0/a1/a4/d0
		rts


*-----------------------------------------------------------------------------*
ClearPointer:	movem.l	a0/a1/a4/d0,-(a7)
		tst.w	WindowDisabled(a5)
		beq.s	.Return

		*--- Alle Menus disablen ---*
		*Input:a0=Window
		*      a1=Menu
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	WinHandle(a5),a0
		move.l	MenuAdr(a5),a1
		jsr	ENPP_ClearWaitPointer(a4)


.Return:	clr.w	WindowDisabled(a5)
		movem.l	(sp)+,a0/a1/a4/d0
		rts

*------------------------------- TextRequest ---------------------------------*
* Input: d0=LocaleNummer						      *
*-----------------------------------------------------------------------------*
TextRequest:	movem.l	d0-a6,-(a7)
		bsr	GetLocaleString
		sub.l	a3,a3					*Arguments

		move.l	IntBase(a5),a6
		lea	My_Easystruct(a5),a1
		move.l	d0,es_textformat(a1)

		moveq	#LENr_Ok,d0
		bsr	GetLocaleString
		move.l	d0,ES_GadgetFormat(a1)
		moveq	#LENr_RequestTitle,d0
		bsr	GetLocaleString
		move.l	d0,es_Title(a1)
		move.l	Winhandle(a5),a0		;*Window
		suba.l	a2,a2				;*IDCMP_ptr
		jsr	_LVOEasyRequestArgs(a6)		;!! durch Reqtools
							;ersetzen
		movem.l	(sp)+,d0-a6	
		rts



*----------------------- Listview-Gadget wurde gedrckt ----------------------*
ArchiverListView:move.l	StartSeconds(a5),d0
		move.l	StartMicros(a5),d1
		move.l	CurrentSeconds(a5),d2
		move.l	CurrentMicros(a5),d3
		move.l	d2,StartSeconds(a5)
		move.l	d3,StartMicros(a5)
		move.l	SelectedArchive(a5),d4
		addq.l	#1,d5
		cmp.w	d4,d5
		bne.w	.EinfacherKlick
		move.l	IntBase(a5),a6
		jsr	_LVODoubleClick(a6)

	*------ Listviews & Stringgadgets refreshen ------*
		cmp.l	#1,d0			--> Einfacher Klick
		bne.w	.SchonDa
		clr.l	StartSeconds(a5)
		clr.l	StartMicros(a5)
		moveq	#1,d1
		bra.s	.DoppelKlick

.EinfacherKlick:moveq	#0,d1			--> Nur Anzeigen
.DoppelKlick:	move.l	d5,d0			--> Nummer
		bsr.w	ChangeNowListViews
.SchonDa:	rts

*-----------------------------------------------------------------------------*
* d0=Neue Nummer
* d1=Mode		0=Nur Anzeigen 1=Togglen
ChangeNowListViews:
		movem.l	d1-a6,-(a7)
		move.l	d1,d3
		tst.l	d3
		bne.s	.ToggleJa
		cmp.l	SelectedArchive(a5),d0
		beq.w	.Return				*Schon Da

.ToggleJa:	move.l	d0,d5

	*------- Pfad aus dem StringGadget holen ------*
		bsr	StringPaths

		cmp.l	SelectedArchive(a5),d0
		beq.s	.NoRefreshList

		lea	MyTags(a5),a3
		subq.l	#1,d0
		move.l	#GTLV_Selected,(a3)+
		move.l	d0,(a3)+
		move.l	#GTLV_MakeVisible,(a3)+
		move.l	d0,(a3)+
		clr.l	(a3)
		moveq	#EPENr_ArchiveList,d0
		bsr	GetGadgetAdr
		lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

.NoRefreshList:	move.l	d5,SelectedArchive(a5)
		move.l	d5,d0
		bsr	DeleteInfoList
		tst.l	d3
		beq.s	.NoToggle

		bsr	DeleteArchiveList
		lea	ArchiverTabelle-EPAT_SizeOf(pc),a0
		mulu	#EPAT_SizeOf,d0
		lea	(a0,d0.w),a0
		moveq	#0,d0			---> Off
		tst.w	EPAT_State(a0)
		bne.s	.StateOk
		moveq	#1,d0
.StateOk:	move.w	d0,EPAT_State(a0)
		bsr.w	MakeArchiveList


.NoToggle:	bsr	MakeArchiveInfo

		move.l	GadgetListAdr(a5),a0
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		moveq	#-1,d0
		move.l	IntBase(a5),a6
		jsr	_LVORefreshglist(a6)

		move.l	GadBase(a5),a6
		move.l	Winhandle(a5),a0
		sub.l	a1,a1
		jsr	_LVOGT_RefreshWindow(a6)
.Return:	movem.l	(a7)+,d1-a6
		rts


*-----------------------------------------------------------------------------*
OpenWin:	movem.l	d1-a6,-(a7)
		lea	Puffer,a5
		tst.l	WinHandle(a5)
		bne.s	.WindowDa

		bsr	InitLocale
		move.l	Intbase(a5),a6
		bsr	LockPubscreen		;Public Screen holen
		bne	.Error
		bsr	SetUpWin		;Fenster ffnen
		tst.l	d0
		bne	.Error
		*moveq	#EPENr_ArchiveList,d0
		*bsr	remlist
		*moveq	#EPENR_ArchiveList,d0
		*bsr	readdlist
		*bsr	UpdateInfoGadget
.Error:	
.WindowDa	move.l	WinHandle(a5),d0
		movem.l	(a7)+,d1-a6
		rts


UpdateInfoGadget
		rts

*************************************************************************
*            Fenster ffnen, Gadgets und Mens init                     *
*************************************************************************
SetUpWin:	movem.l d1-a6,-(sp)




		move.l	MyPubscreen(a5),d0
		beq.w	.Error
		move.l	d0,a0
		move.l  sc_Font(a0),a1
		move.w  ta_YSize(a1),d3
		addq.w  #1,d3
		move.b  sc_WBorTop(a0),d0
		ext.w   d0
		add.w	d3,d0
		move.w	d0,offy(a5)

		move.b  sc_WBorLeft(a0),d0
		ext.w   d0
		move.w	d0,offx(a5)

		*moveq	#0,d2
		*moveq	#0,d3
		*move.w	#Defwidth,d2
		*move.w	#DefHeight,d3

		bsr	ComputeFont




		*---- Min Breite des Windows berechnen ----*
		movem.l	d0/d3/d4/a0,-(a7)
		move.l	ArchiveListGD+8(pc),a0
		bsr	GetTextLenght
		move.l	d0,d3
		mulu	#3,d3
		add.w	#20,d3

		move.l	PfadStringInfo+8(pc),a0
		bsr	GetTextLenght
		move.w	d0,d4
		move.l	OptionsStringInfo+8(pc),a0
		bsr	GetTextLenght
		cmp.w	d0,d4
		blt.s	.D0WidthOk1
		move.l	d4,d0
.D0WidthOk1:	add.l	#100,d0
		cmp.l	d0,d3
		blt.s	.D0WidthOk2
		move.l	d3,d0
.D0WidthOk2:	moveq	#0,d1
		move.l	MyPubscreen(a5),a0
		move.b	sc_WBorLeft(a0),d1
		add.b	sc_WBorRight(a0),d1
		add.l	d1,d0
		move.l	d0,Win_MinWidth


		*---- Min Height des Windows berechnen ----*
		move.l	mypubscreen(A5),a0
		moveq	#0,d1
		move.b	sc_WBorBottom(a0),d1
		add.b	sc_WBorTop(a0),d1
		moveq	#0,d0
		move.w	FontY(a5),d0
		addq.l	#StringGadgetOffset,d0
		*bsr	computey
		mulu	#5,d0
		add.w	#3*5+YOffset,d0
		add.w	OffY(a5),d0
		add.w	d1,d0
		move.l	d0,Win_MinHeight
		movem.l	(a7)+,d0/d3/d4/a0

		moveq	#0,d2
		moveq	#0,d3
		move.w	EUS_Structure+EUS_Special(pc),d2
		move.w	EUS_Structure+EUS_Special+2(pc),d3
		bne.s	.NimmDiese

		moveq	#0,d0
		move.w	FontY(a5),d0
		mulu	#3,d0
		add.w	d0,d3

.NimmDiese:
*		move.l	MyPubscreen(a5),a0
*	moveq	#0,d0
*	move.w	FontY(a5),d0
*	mulu	#3,d0
**	sub.w	d0,d3
*		moveq	#0,d1
*		move.b	sc_WBorBottom(a0),d1
*		add.b	sc_WBorTop(a0),d1
*		sub.w	d1,d3
*		sub.w	#3*5+YOffset,d3
*		sub.w	OffY(a5),d3
;		subq.l	#StringGadgetOffset,d0

		cmp.w	Win_MinHeight+2(pc),d3
		bhi.s	.HeightOk
		move.l	Win_MinHeight(pc),d3
.HeightOk:	cmp.w	Win_MinWidth+2(pc),d2
		bhi.s	.WidthOk
		move.l	Win_MinWidth(pc),d2
.WidthOk:





		move.l	mypubscreen(A5),a0

		move.l	d2,ahawidth
		move.l	d3,ahaheight

		move.l	d2,d0
		move.l	d0,d4
		moveq	#0,d2
		add.w	d2,d0
		add.w	OffX(a5),d0
		move.b	sc_WBorRight(a0),d1
		ext.w	d1
		add.w	d1,d0
		cmp.w	sc_Width(a0),d0
		bls.s	.Project0WOk
		move.w	sc_Width(a0),d0
		sub.w	d4,d0
		move.w	d0,d2
.Project0WOk:	move.l	d3,d0
		move.l	d0,d4

;	lea	begin(pc),a1
;	move.w	eus_winy(a1),d3
;	add.w	d3,d0
;	add.w	OffY(A5),d0
;	move.b	sc_WBorBottom(a0),d1
;	ext.w	d1
;	add.w	d1,d0
;	cmp.w	sc_Height(a0),d0
;	bls.s	Project0HOk
;	move.w	sc_Height(a0),d0
;	sub.w	d4,d0
;	move.w	d0,d3

		*-- Menus creieren ---*
		move.l	GadBase(a5),a6
		lea	Menus(pc),a0
		lea	MenuTags(pc),a1
		jsr	_LVOCreateMenusA(a6)
		move.l	d0,MenuAdr(a5)
		tst.l	d0
		beq	.Error
		move.l	d0,a0
		move.l	VisualInfo(a5),a1
		lea	MenuTags(pc),a2
		jsr	_LVOLayoutMenusA(a6)

		moveq	#0,d0
		moveq	#0,d1
		moveq	#0,d2
		moveq	#0,d3
		moveq	#0,d7
		move	WinPosX(a5),d0
		move	WinPosY(a5),d1
		move	ZoomPosX(a5),d2
		move	ZoomPosY(a5),d3
		move.l	ahawidth(pc),d4
		move.l	ahaheight(pc),d5
		*move.l	#ZoomWidth,d6

		move.l	mypubscreen(A5),a0
		lea	sc_RastPort(a0),a0
		move.l	rp_Font(a0),a0
		move.w  tf_XSize(a0),d6
		mulu	#ZoomWidth,d6
		addq	#4,d6
		lsr	#3,d6
		move	offy(A5),d7
		tst.b	ZoomState(a5)
		beq.s	.Normal
		exg.l	d0,d2
		exg.l	d1,d3
		exg.l	d4,d6
		exg.l	d5,d7
.normal:	lea	WindowTags(pc),a1
		move.l	d0,Win_LeftPos-WindowTags(A1)
		move.l	d1,Win_TopPos-WindowTags(A1)
		move.l	d4,Win_Width-WindowTags(A1)
		move.l	d5,Win_Height-WindowTags(A1)
		move.w	d2,ZoomStruct-WindowTags(A1)
		move.w	d3,ZoomStruct+2-WindowTags(A1)
		move	d6,ZoomStruct+4-WindowTags(A1)
		move	d7,ZoomStruct+6-WindowTags(A1)

		move.l	IntBase(A5),a6
		move.l	mypubscreen(a5),Pubadr-WindowTags(a1)
		suba.l	a0,a0
		jsr	_LVOOpenWindowTagList(a6)
		move.l	d0,Winhandle(a5)
		tst.l	d0
		beq	.OpenWindowError



		move.l	WinHandle(a5),a0
		move.w	wd_leftedge(a0),WinPosX(a5)
		move.w	wd_topedge(a0),WinPosY(a5)
		move.w	wd_Width(a0),WinWidth(a5)
		move.w	wd_Height(a0),WinHeight(a5)


		bsr	InitGadgets
		bne	.GadgetError
		bsr	AddGads
		bne	.GadgetError

		move.l	Winhandle(a5),a0
		move.l	MenuAdr(a5),a1
		jsr	_LVOSetMenuStrip(a6)

		move.l	Winhandle(a5),a0
		move.l	WD_Userport(a0),a0	;User Port
		move.l	a0,WindowPort(a5)
		moveq	#0,d0

	*--------------- SignalBits setzen ---------------*
		move.l	SignalBits(a5),d6
		moveq	#0,d0
		move.b	15(a0),d0
		bset	d0,d6
		move.l	d6,SignalBits(a5)
		moveq	#0,d0


.SetUpReturn:	movem.l	(sp)+,d1-a6
		tst.l	d0
		rts

.GadgetError	bsr	Closedownwindow
.OpenWindowError:bsr	FreeMenus
.Error:		moveq	#EPR_UnknownError,d0
		bra.s	.SetUpReturn



*-----------------------------------------------------------------------------*
ComputeFont:	movem.l	d4-d7/a2-a6,-(a7)
		move.l	MyPubscreen(a5),d0
		beq.w	.Return
		move.l	d0,a0
		move.l	sc_RastPort+rp_Font(a0),a0

	move.w  tf_YSize(a0),d0

		lea	MyFont(a5),a1
		move.l	a1,Font(a5)
		move.l  LN_Name(a0),ta_Name(a1)
		move.w  tf_YSize(a0),ta_YSize(a1)
		move.w  tf_XSize(a0),FontX(a5)
		move.w  tf_YSize(a0),FontY(a5)
		clr.w	6(a1)

		move.l	MyPubscreen(A5),a0
		move.b	sc_WBorLeft(a0),d0
		ext.w	d0
		move.w	d0,OffX(a5)

		move.l	sc_font(A0),a1
		move.w	ta_YSize(a1),d0

		addq.w	#1,d0
		move.b	sc_WBorTop(a0),d1
		ext.w	d1
		add.w	d1,d0
		move.w	d0,OffY(A5)

*		tst.w	d2
*		beq.s	.Return
*		tst.w	d3
*		beq.s	.Return
*		move.w	d2,d0
*		bsr	ComputeX
*
*		add.w   OffX(a5),d0
*		move.b	sc_WBorRight(a0),d1
*		ext.w	d1
*		add.w	d1,d0
*		cmp.w	sc_Width(a0),d0
*	*	bhi.s	.UseTopaz
*	*	move.w	d0,d2
*
*		move.w	d3,d0
*		bsr	ComputeY
*		add.w	OffY(a5),d0
*		move.b	sc_WBorBottom(a0),d1
*		ext.w	d1
*		add.w	d1,d0
*		cmp.w	sc_Height(a0),d0
*	*	bhi.s	.UseTopaz
*	*	move.w	d0,d3

.Return:	movem.l	(a7)+,d4-d7/a2-a6
		rts

*.UseTopaz:	move.l	Font(a5),a0
*		move.l	#TopazName,ta_Name(a0)
*		move.w	#8,FontY(A5)
*		move.w	#8,FontX(a5)
*		move.w	#8,ta_YSize(a0)
*		bra.s	.Return



*----------------------------- Window lschen --------------------------------*
ClearWindow:	movem.l	d0-a6,-(a7)
		move.l	GFXBase(a5),a6
		move.l	Winhandle(a5),a1
		move.l	wd_rport(a1),a1
		moveq	#0,d0
		jsr	_LVOsetapen(a6)

		move.l	winhandle(A5),a1
		move.l	wd_rport(a1),a1
		moveq	#0,d0
		jsr	_LVOsetbpen(A6)

		move.l	winhandle(A5),a1
		move.l	wd_rport(a1),a1
		moveq	#1,d0			;RP_Jam2
		jsr	_LVOsetdrmd(a6)

		move.b	rp_areaptsz(a1),d4
		move.l	rp_areaptrn(a1),d5

		move.l	winhandle(A5),a1
		move.w	wd_width(A1),d2		;x2
		moveq	#0,d0
		move.b	wd_borderright(a1),d0
		sub.w	d0,d2

		move.w	wd_height(a1),d3
		moveq	#0,d0
		move.b	wd_borderbottom(a1),d0
		sub.w	d0,d3

		move.l	wd_rport(a1),a1

		move.w	Offx(a5),d0		;x1
		move.w	Offy(A5),d1		;y1
		jsr	_LVOrectfill(a6)

		move.l	winhandle(A5),a0
		move.l	IntBase(a5),a6
		jsr	_LVORefreshwindowframe(A6)
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
Closewin:	movem.l	d0-a6,-(a7)
		lea	Puffer,a5
		tst.l	WinHandle(a5)
		beq.s	.KeinWindow
		bsr	MerkWindowSize		*fr WinPos
		bsr	Closedownwindow
		bsr	MerkWindowSize		*Fr Show/Hide State
.KeinWindow:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
Closedownwindow:movem.l d0-a6,-(a7)

		move.l	WinHandle(a5),d0
		beq.s	.Return
		move.l	d0,a0
		move.l	86(a0),a1			;MsgPort des Windows
		move.l	SignalBits(a5),d1
		moveq	#0,d0
		move.b	15(a1),d0
		bclr	d0,d1
		move.l	d1,SignalBits(a5)

		bsr	DeleteArchivelist
		bsr	DeleteInfolist			*wegen StringGadgets
		move.l	IntBase(a5),a6
		move.l	Winhandle(a5),d0
		beq.s	.NoWindow
		move.l	d0,a0
		jsr	_LVOCloseWindow(a6)
.NoWindow:	clr.l	Winhandle(a5)
		clr.l	WindowPort(a5)

		bsr	FreeMenus
		bsr	FreeGadgets
		bsr	FreeLocale

		bsr	UnlockPubScreen
.Return:	movem.l (sp)+,d0-a6
		rts


*--------------------------- Gadgets freigeben -------------------------------*
FreeGadgets:	movem.l	d0-a6,-(a7)
		move.l	GadBase(a5),a6
		move.l	GadgetListAdr(a5),d0
		move.l	d0,a0
		beq	.NoGadgets
		jsr	_LVOFreeGadgets(a6)
.NoGadgets:	clr.l	GadgetListAdr(a5)

		lea	GadgetMerkPuffer(a5),a0
		move.l	#GadgetAnz-1,d1
.ClrPuffer:	clr.l	(a0)+
		dbf	d0,.ClrPuffer
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
FreeMenus:	movem.l	d0-a6,-(a7)
		move.l	IntBase(a5),a6
		move.l	MenuAdr(a5),d0
		move.l	d0,a0
		beq	.NoMenu
		move.l	Winhandle(a5),d0
		beq.s	.NoWindow
		move.l	d0,a0
		jsr	_LVOClearMenuStrip(a6)
.NoWindow:	move.l	GadBase(a5),a6
		move.l	MenuAdr(a5),a0
		jsr	_LVOFreeMenus(a6)
.NoMenu:	clr.l	MenuAdr(a5)
		movem.l	(a7)+,d0-a6
		rts

*----------------------------- Lock PubScreen --------------------------------*
LockPubScreen:	movem.l	d1-a6,-(a7)
		moveq	#EPR_UnknownError,d7
		move.l	IntBase(a5),a6
		lea	EUS_Structure(pc),a0
		move.l	EUS_EPBase(a0),d0
		beq.s	.KeinEP
		move.l	d0,a0
		move.l	EPG_Pubscreen(a0),d0
		*move.w	EPG_Wordreserved7(a0),word7(a5)
.KeinEp:	move.l	d0,a0
		jsr	_LVOLockPubScreen(a6)
		move.l	d0,MyPubscreen(a5)
		tst.l	d0
		beq.s	.Return

		move.l	Mypubscreen(a5),a0
		move.l	GadBase(a5),a6
		suba.l	a1,a1
		jsr	_LVOGetVisualInfoA(a6)
		move.l	d0,VisualInfo(a5)
		tst.l	d0
		beq.s	.Return
		moveq	#0,d7
.Return:	move.l	d7,d0
		movem.l	(a7)+,d1-a6
		rts

*------------------------------ Unlock PubScreen -----------------------------*
UnlockPubScreen:movem.l	d0-a6,-(a7)
		move.l	GadBase(a5),a6
		move.l	VisualInfo(a5),d0
		beq.s	.NoVisualInfo
		move.l	d0,a0
		jsr	_LVOFreeVisualInfo(a6)
		clr.l	VisualInfo(a5)
.NoVisualInfo:	move.l	IntBase(a5),a6
		suba.l	a0,a0
		move.l	Mypubscreen(a5),d0
		beq.s	.NoPublicScreen
		move.l	d0,a1
		jsr	_LVOUnlockPubScreen(a6)
.NoPublicScreen:clr.l	Mypubscreen(A5)
		movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
* In Der EUS-Structur sind die Angaben fr die innere Windowhhe und Breite --*
* Jetzt
* Input: --
InitGadgets:	movem.l	d1-a6,-(a7)
		lea	Puffer,a5

		moveq	#0,d0
		tst.l	GadgetListadr(a5)
		bne.w	.Return

		move.l	WinHandle(a5),d0
		beq.w	.Error
		move.l	d0,a0
		moveq	#0,d6
		moveq	#0,d7
		move.w	8(a0),d6
		move.w	10(a0),d7
		moveq	#0,d0
		move.b	WD_BorderLeft(a0),d0
		sub.w	d0,d6
		move.b	WD_BorderRight(a0),d0
		sub.w	d0,d6
	sub.w	#6,d6		;Abstand vom Rand
		move.b	WD_Bordertop(a0),d0
		sub.w	d0,d7
		move.b	WD_BorderBottom(a0),d0
		sub.w	d0,d7
		sub.w	OffY(a5),d7
		sub.w	#YOffset,d7


		*--- Das Archiverlistview ist 1/4 des Windows ---*
		lea	ArchiveListGD(pc),a0
		moveq	#0,d0
		move.w	d6,d0
		* Faktor, gibt an, da das linke Listview 1/3 Platz hat. *
		divu	#3,d0			*Width
		ext.l	d0
		subq.w	#4,d0
		move.w	d0,4(a0)		*Archivelist Width
		move.w	d7,6(a0)		*Archivelist Height
		move.w	#6,(a0)			*Archivelist Left
		move.w	#0,2(a0)		*Archivelist Top
		move.w	#0,2+ArchiveInfoGD-ArchiveListGD(a0)	*Archiveinfo Top
		move.w	FontY(a5),d1
		add.w	d1,2(a0)		*Wegen Listview berschrift
		add.w	d1,2+ArchiveInfoGD-ArchiveListGD(a0)
		addq.l	#8,d0
		move.w	d0,ArchiveInfoGD-ArchiveListGD(a0)	*Archiveinfo Left
		move.w	d0,OptionsStringInfo-ArchiveListGD(a0)	*Options Left
		move.w	d0,PfadStringInfo-ArchiveListGD(a0)	*PfadLeft

		*--- Das Archiverinfo ist 3/4 des Windows ---*
		sub.w	d0,d6
		*subq.l	#6,d6
		move.w	d6,4+ArchiveInfoGD-ArchiveListGD(a0)	*Width Archiveinfo
		move.w	d6,InfoWidth(a5)

		*---- Stringsize berechnen ----*
		move.l	PfadStringInfo+8(pc),a0
		bsr	GetTextLenght
		move.w	d0,d4
		move.l	OptionsStringInfo+8(pc),a0
		bsr	GetTextLenght
		cmp.w	d0,d4
		blt.s	.D0WidthOk1
		move.l	d4,d0
.D0WidthOk1:	lea	PfadStringInfo(pc),a0
		move.w	d6,d1
		sub.w	d0,d1			*Width fr Optionsstring
		subq.w	#3,d1
		move.w	d1,4+OptionsStringInfo-PfadStringInfo(a0)
		move.w	d1,4(a0)		*Width fr Pfad

		move.w	FontY(a5),d0
	addq.l	#StringGadgetOffset,d0
	*	bsr	computey
		move.w	d0,6+OptionsStringInfo-PfadStringInfo(a0)
		move.w	d0,6(a0)

		sub.w	d0,d7			*Optionstop
	*add.w	OffY(a5),d7	<-- Das wre korrect, aber sieht
	*subq.l	#3,d7		<-- doof aus.
		addq.l	#2,d7
		move.w	d7,2+OptionsStringInfo-PfadStringInfo(a0)

		sub.w	d0,d7			*Pfad Top
		subq.l	#3,d7
		move.w	d7,2(a0)

		subq.l	#3,d7			*Archiveinfoheight
		sub.w	OffY(a5),d7
		move.w	d7,6+ArchiveInfoGD-PfadStringInfo(a0)


		bsr	CreateGadgets				*d0=Return

.Return:	movem.l	(a7)+,d1-a6
		rts


.Error:		moveq	#EPR_UnknownError,d0
		bra.s	.Return

*-----------------------------------------------------------------------------*
* Input: --
* Output:d0=Error oder Null
*-----------------------------------------------------------------------------*
CreateGadgets:	movem.l	d1-a6,-(a7)
		moveq	#EPR_UnknownError,d7
		move.l	GadBase(A5),a6
		lea	GadgetListadr(a5),a0
		jsr	_LVOCreateContext(a6)
		move.l	d0,a3
		tst.l	d0
		beq.w	.Error

		moveq	#0,d3
		lea.l	GadgetTags(pc),a4
.NextGadget:	EB
		lea	Gadgets(pc),a0
		move.l	d3,d0
		mulu	#gng_SIZEOF,d0		* +2 wegen Locale !
		add.l	d0,a0
		lea.l	BufNewGad(a5),a1
		moveq	#GNG_SizeOf,d0
		jsr	_LVOCopyMem(a6)
		lea.l	BufNewGad(a5),a0
		move.l	VisualInfo(a5),GNG_VisualInfo(a0)
		move.l	Font(a5),GNG_TextAttr(a0)

		move.w	gng_TopEdge(a0),d0
		add.w	OffY(a5),d0
		addq.w	#YOffset,d0
		move.w	d0,gng_TopEdge(a0)

		move.w	gng_LeftEdge(a0),d0
		*bsr	computex
		add.w	OffX(a5),d0
		move.w	d0,gng_LeftEdge(a0)

		*move.w	gng_LeftEdge(a0),d0
		*bsr	computex
		*add.w	OffX(a5),d0
		*move.w	d0,gng_LeftEdge(a0)

		*move.w	gng_TopEdge(a0),d0
		*bsr	computey
		*add.w	OffY(a5),d0
		*move.w	d0,gng_TopEdge(a0)

		*move.w	gng_Width(a0),d0
		*bsr	computex
		*move.w	d0,gng_Width(a0)

		*move.w	gng_Height(a0),d0
		*bsr	computey
		*move.w	d0,gng_Height(a0)

		move.l	GadBase(a5),a6
		lea	GadgetTypes(pc),a0
		moveq	#0,d0
		move.l	d3,d1
		asl.l	#1,d1
		add.l	d1,a0
		move.w	(a0),d0
		move.l	a3,a0
		lea	BufNewGad(a5),a1
		move.l	a4,a2
		jsr	_LVOCreateGadgetA(a6)
		tst.l	d0
		beq.s	.Error

		*------- Gadgetadr im Puffer merken --------*
		move.l	d0,a3
		move.l	d3,d0
		asl.l	#2,d0
		lea.l	GadgetMerkPuffer(a5),a0
		add.l	d0,a0
		move.l	a3,(a0)

		*--- Start der nchsten Tagliste finden ----*
.FindTags:	tst.l	(a4)
		beq.s	.NochEinGadget
		addq.w	#8,a4
		bra.s	.FindTags

.NochEinGadget:	addq.w	#4,a4
		addq.w	#1,d3
		cmp.w	#GadgetAnz,d3
		bmi	.NextGadget
		moveq	#0,d7
.Return:	move.l	d7,d0
		movem.l	(a7)+,d1-a6
		rts

.Error:		bsr.w	FreeGadgets
		bra.s	.Return

*-----------------------------------------------------------------------------*
AddGads:	movem.l	d0-a6,-(sp)
		tst.l	WinHandle(a5)
		beq.s	.Return
		move.l	GadgetListAdr(a5),d0
		beq.s	.Return
		move.l	d0,a1

		moveq	#0,d1
.count:		move.l	d0,a0
		addq.l	#1,d1
		move.l	(A0),d0
		bne.s	.count
		move.w	d1,RealNumGadgets(a5)

		move.l	IntBase(a5),a6
		move.l	Winhandle(a5),a0
		moveq	#-1,d0
		moveq	#-1,d1
		sub.l	a2,a2
		jsr	_LVOAddGList(a6)

		bsr	MakeArchiveList
		bsr	MakeArchiveInfo


		lea	MyTags(a5),a3
		move.l	#GTLV_Selected,(a3)+
		move.l	SelectedArchive(a5),(a3)
		subq.l	#1,(a3)+
		clr.l	(a3)
		moveq	#EPENr_ArchiveList,d0
		bsr	GetGadgetAdr
		lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

		move.l	GadgetListAdr(a5),a0
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		moveq	#-1,d0
		move.l	IntBase(a5),a6
		jsr	_LVOrefreshglist(a6)

		move.l	GadBase(a5),a6
		move.l	Winhandle(a5),a0
		sub.l	a1,a1
		jsr	_LVOGT_RefreshWindow(a6)


.Return:	movem.l	(sp)+,d0-a6
		rts


*-------------------------- Entferne List vom Listview -----------------------*
* Input: D0=EPENr_Nummer						      *
*-----------------------------------------------------------------------------*
Remlist:	movem.l	d0-a6,-(sp)
		tst.l	Winhandle(a5)
		beq.s	.Return
		bsr	GetGadgetAdr			;Gadgetadresse in A0
		bne.s	.Return
		lea	Mytags(a5),a3
		move.l	#GTLV_Labels,(a3)+
		move.l	#-1,(a3)+
		clr.l	(a3)+
		lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)
.Return:	movem.l	(sp)+,d0-a6
		rts

*----------------------- Liste wieder an Gadget anhngen ---------------------*
* Input: d0=EPENr_Nummer						      *
*	 a0=List							      *
*-----------------------------------------------------------------------------*
Readdlist:	movem.l	d0-a6,-(sp)
		move.l	a0,a2
		tst.l	Winhandle(a5)
		beq.s	.Return

		bsr	GetGadgetAdr			;Gadgetadresse in A0
		bne.s	.Return
		lea	MyTags(a5),a3
		move.l	#GTLV_Labels,(a3)+
		move.l	a2,(a3)+
		clr.l	(a3)

*		tst.b	Clicked(a5)
*		beq.s	.nose
*		move.l	#GTLV_Selected,(a3)+
*		moveq	#0,d0
*		move.w	Num_Selected(a5),d0
*		move.l	d0,(a3)+
*		clr.l	(a3)
.nose:		lea	MyTags(a5),a3

		move.l	WinHandle(a5),a1
		sub.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)

.Return:	movem.l	(sp)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
StringPaths:	movem.l	d0-a6,-(a7)
		tst.l	WinHandle(a5)
		beq.w	.Return

*		lea	Mytags(a5),a3
*		move.l	#GTST_String,(a3)+
*		lea	Result(a5),a0
*		move.l	a0,(a3)+
*		clr.l	(a3)
*		moveq	#EPENr_Pfad,d0
*		bsr	GetGadgetAdr			;Gadgetadresse in A0
*		lea	MyTags(a5),a3
*		move.l	Winhandle(a5),a1
*		suba.l	a2,a2
*		move.l	GadBase(a5),a6
*		jsr	_LVOGT_GetGadgetAttrsa(a6)
	

		moveq	#EPENr_Pfad,d0
		bsr	GetGadgetAdr			;Gadgetadresse in A0
		bne.s	.Return
		move.l	gg_SpecialInfo(a0),a0
		move.l	(a0),a0		


		move.l	SelectedArchive(a5),d0
		lea	AllPfadPuffer-PfadPufferSize(a5),a1
		mulu	#PfadPufferSize,d0
		lea	(a1,d0.w),a1
	*	move.l	Result(a5),a0
		move.w	#PfadPufferSize-1,d1
		bsr	StringCopy

	*------- Options aus dem StringGadget holen ------*
		moveq	#EPENr_Options,d0
		bsr	GetGadgetAdr			;Gadgetadresse in A0
		bne.s	.Return
		move.l	gg_SpecialInfo(a0),a0
		move.l	(a0),a0		

*		lea	Mytags(a5),a3
*		move.l	#GTST_String,(a3)+
*		lea	Result(a5),a0
*		move.l	a0,(a3)+
*		clr.l	(a3)
*		moveq	#EPENr_Options,d0
*		bsr	GetGadgetAdr			;Gadgetadresse in A0
*		lea	MyTags(a5),a3
*		move.l	Winhandle(a5),a1
*		suba.l	a2,a2
*		move.l	GadBase(a5),a6
*		jsr	_LVOGT_GetGadgetAttrsa(a6)

		move.l	SelectedArchive(a5),d0
		lea	AllOptionsPuffer-OptionsPufferSize(a5),a1
		mulu	#OptionsPufferSize,d0
		lea	(a1,d0.w),a1
*		move.l	Result(a5),a0
		move.w	#OptionsPufferSize-1,d1
		bsr	StringCopy

.Return:	movem.l	(a7)+,d0-a6
		rts

******************************************************************************
*                     aktuelle Liste killen                                  *
******************************************************************************
DeleteInfolist:	movem.l	d0-a6,-(a7)

		moveq	#EPENr_ArchiveInfo,d0
		bsr	Remlist
		lea	ArchiveInfo(a5),a0
		bsr	Deletelist
		clr.b	ArchiveInfoDa(a5)
		*moveq	#EPENr_ArchiveInfo,d0
		*lea	ArchiveInfo(a5),a0
		*bsr	ReAddlist
		movem.l	(a7)+,d0-a6
		rts

DeleteArchivelist:
		movem.l	d0-a6,-(a7)
		moveq	#EPENr_ArchiveList,d0
		bsr	Remlist
		lea	ArchiveList(a5),a0
		bsr	Deletelist
		clr.b	ArchiveListeDa(a5)
		*moveq	#EPENr_ArchiveList,d0
		*lea	ArchiveList(a5),a0
		*bsr	ReAddlist
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: a0=List
*-----------------------------------------------------------------------------*
DeleteList:	movem.l	d0-a6,-(a7)
		move.l	a0,d4

.NextNode:	move.l	d4,a0
	;Macro remhead aus exec/lists.i 	A0-list A1-(destroyed) D0=node
		MOVE.L  (A0),A1
		MOVE.L  (A1),D0
		BEQ.S   .empty
		MOVE.L  D0,(A0)
		EXG.L   D0,A1
		MOVE.L  A0,LN_PRED(A1)

		move.l	d0,a1
		move.l	ML_Size(a1),d0
		beq.s	.NextNode
		EB
		jsr	_LVOFreemem(a6)
		bra.s	.NextNode
.empty:		movem.l	(sp)+,d0-a6
		rts


*----------------------------------------------------------------------------*
* Speicher fr Node-Struktur + String anfordern, an Liste anhngen und init  *
*									     *
* Input: a0=StringAdr							     *
* Output:d0=NUll=Error	L						     *
*----------------------------------------------------------------------------*
AllocListNode:	movem.l	d1-a6,-(sp)
		lea	Archivelist(a5),a4
		bra.s	AllocTheNode

AllocInfoNode:	movem.l	d1-a6,-(sp)
		lea	ArchiveInfo(a5),a4

AllocTheNode:	move.l	a0,a2
		bsr	BerechStringSize
		EB
		move.l	#$10000,d1
		add.l	#ML_Chars+10,d0
		move.l	d0,d3
		jsr	_LVOAllocmem(a6)
		tst.l	d0
		beq.s	.Error

		move.l	d0,a3
		move.l	a4,a0
		move.l	d0,a1			;(erspart Arbeit)
		addtail
		lea	ML_Chars(a3),a1
		move.l	a1,LN_Name(a3)
		move.l	d3,ML_Size(a3)

		move.w	d3,d1
		sub.w	#ML_Chars+10+1,d1
		move.l	a2,a0
		bsr	StringCopy

		move.l	a3,d0

.Error:		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*---------------------------- Node freigeben --------------------------------*
* Input: a0=Node
Freenode:	movem.l	d0-a6,-(sp)
		EB
		move.l	a0,d0
		beq.s	.Return
		move.l	ML_Size(a0),d0
		beq.s	.Return
		jsr	_LVOFreemem(a6)
.Return:	movem.l	(sp)+,d0-a6
		rts


*------------------------------ Make Archivelist ----------------------------*
* Die Liste mu leer sein !!!
* Input: --
* Output:d0=Error oder NULL
MakeArchiveList:movem.l	d1-a6,-(a7)
		moveq	#0,d0
		tst.b	ArchiveListeDa(a5)
		bne.s	.DasWars
		lea	ArchiverTabelle-EPAT_SizeOf(pc),a4
		lea	ArchiverTabelle(pc),a3
.NextNode:	lea	EPAT_SizeOf(a4),a4
		move.w	EPAT_Name(a4),d0
		beq.s	.DasWars
		lea	(a3,d0.w),a0
		lea	TextPuffer(a5),a1
		tst.w	EPAT_State(a4)
		bne.s	.Enabled
		move.b	#"(",(a1)+
.Enabled:	move.w	#TextPufferSize-3,d1
		bsr	StringCopy
		tst.w	EPAT_State(a4)
		bne.s	.Enabled2
		move.b	#")",(a1)+
		clr.b	(a1)
.Enabled2:	lea	TextPuffer(a5),a0
		bsr	AllocListNode
		beq.s	.Error
		bra.s	.NextNode

.DasWars:	moveq	#EPENr_Archivelist,d0
		lea	ArchiveList(a5),a0
		bsr	ReAddlist

		move.b	#1,ArchiveListeDa(a5)

.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

.Error:		moveq	#EPR_UnknownError,d0
		bra.s	.Return



*------------------------------ Make Archiveinfo ----------------------------*
* Die Liste mu leer sein !!!						     *
* Input: --								     *
* Output:d0=Error oder NULL						     *
*----------------------------------------------------------------------------*
MakeArchiveInfo:
		movem.l	d1-a6,-(a7)
		move.l	SelectedArchive(a5),d0
		subq.l	#1,d0
		move.l	d0,d4
		tst.b	ArchiveInfoDa(a5)
		bne.w	.DasWars
		lea	ArchiverTabelle(pc),a4
		mulu	#EPAT_SizeOf,d0
		lea	(a4,d0.w),a3
		move.w	EPAT_InfoLNr(a3),d0
		bsr	GetLocaleString
		move.l	d0,a0
		lea	ArchiveInfo(a5),a1
		bsr	TextToNodes
		bne.w	.Return

	*------------ Stringgadgets fllen ---------*
		lea	AllPfadPuffer(a5),a0
		move.l	d4,d0
		mulu	#PfadPufferSize,d0
		lea	(a0,d0.w),a0
		lea	Mytags(a5),a3
		move.l	#GTST_String,(a3)+
		move.l	a0,(a3)+

		moveq	#EPENr_Pfad,d0
		bsr	GetGadgetAdr			;Gadgetadresse in A0

		clr.l	(a3)+
		lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)


		lea	AllOptionsPuffer(a5),a0
		move.l	d4,d0
		mulu	#OptionsPufferSize,d0
		lea	(a0,d0.w),a0
		lea	MyTags(a5),a3
		move.l	#GTST_String,(a3)+
		move.l	a0,(a3)+
		clr.l	(a3)+

		moveq	#EPENr_Options,d0
		bsr	GetGadgetAdr			;Gadgetadresse in A0
		lea	MyTags(a5),a3
		move.l	Winhandle(a5),a1
		suba.l	a2,a2
		move.l	GadBase(a5),a6
		jsr	_LVOGT_SetGadgetAttrsa(a6)





.DasWars:	moveq	#EPENr_ArchiveInfo,d0
		lea	ArchiveInfo(a5),a0
		bsr	ReAddlist

		move.b	#1,ArchiveInfoDa(a5)
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

.KeinError:	moveq	#0,d0
		bra.s	.Return

*-----------------------------------------------------------------------------*
* a0=Text
* a1=Liste
* Output: d0=Error oder NULL
*-----------------------------------------------------------------------------*
TextToNodes:	movem.l	d1-a6,-(a7)
		move.l	a0,a4
		move.l	a1,a2



	*----------- Width des Listview rausfinden -----------*
	* Kleiner Trick, Gadget im ArchiveInfo ist immer das -*
	* grte					      *
	*-----------------------------------------------------*
		move.l	WinHandle(a5),d0
		beq.w	.Return
		move.l	d0,a0
		lea	WD_FirstGadget(a0),a2
		moveq	#0,d1
.FindIt:	move.l	(a2),d0
		beq.w	.AllesFound
		move.l	d0,a2
		move.w	GG_GadgetType(a2),d0		*GadgetID
		btst	#15,d0				*Systemgadget ?
		bne.s	.FindIt
		move.w	GG_Width(a2),d2
		cmp.w	d2,d1
		bhi.s	.FindIt
		cmp.w	InfoWidth(a5),d2
		beq.s	.FindIt
		move.w	GG_Width(a2),d1
		bra.s	.FindIt

.AllesFound:	sub.w	#5,d1			*move.w	InfoWidth(a5),d0
		move.w	d1,InfoWidth2(a5)




	*---- Text nach Leerzeichen durchsuchen und dann Width testen ----*
.TextSchleife:	move.l	a4,a3
		moveq	#-1,d1
		moveq	#0,d3
.NextB:		addq.l	#1,d1
		move.b	(a3)+,d2
		beq.s	.Zeilenende
		*cmp.b	#"-",d2
		*beq.s	.TestTrennung
		*cmp.b	#",",d2
		*beq.s	.TestTrennung
		cmp.b	#" ",d2
		beq.s	.TestTrennung

		cmp.b	#10,d2
		bne.s	.NextB
.ZeilenEnde:	tst.l	d1
		blt.s	.DasWars
		bsr	.TesteString
		beq.s	.NimmThisString
		bra.s	.EinKurzer

.TestTrennung:	*subq.l	#1,d1
		*blt.s	.DasWars
		*subq.l	#1,a3
		bsr	.TesteString
		beq.s	.NextB		
		*---- String zu lang 1 Word krzer ----*
.EinKurzer:	move.l	d1,d3
		subq.l	#1,a3
.EinKurzer_2:	subq.l	#1,d1
		blt.s	.NimmThisString2
		move.b	-(a3),d2
		*cmp.b	#"-",d2
		*beq.s	.NimmThisString
		*cmp.b	#",",d2
		*beq.s	.NimmThisString
		cmp.b	#" ",d2
		bne.s	.EinKurzer_2
		bra.s	.NimmThisString

		*--- a4=Textstart d1=Size ---*
.NimmThisString2:move.l	d3,d1
.NimmThisString:bsr.s	.ThisStringToNode
		beq.s	.Return				*No Mem
		tst.b	(a4,d1.w)
		beq.s	.DasWars
		lea	1(a4,d1.w),a4
		bra.s	.TextSchleife


.DasWars:	moveq	#0,d0
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*---------- Pat der String in a4 mit Size in d1 ins Listview ----------------*
.TesteString:	movem.l	d1-a6,-(a7)
		moveq	#EPR_ErrorInArguments,d0
		tst.l	d1
		blt.s	.TesteString_2
		move.b	(a4,d1.w),d2
		move.l	d2,-(a7)
		clr.b	(a4,d1.w)
		move.l	a4,a0
		bsr	GetTextLenght
		move.l	(a7)+,d2
		move.b	d2,(a4,d1.w)
		move.l	d0,d1
		moveq	#0,d0
		cmp.w	InfoWidth2(a5),d1
		blt.s	.TesteString_2
		moveq	#EPR_ErrorInString,d0
.TesteString_2:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*------- der String ab a3 wird mit der Lnge von D1 in die Node gehngt ------*
.ThisStringToNode:
		movem.l	d1-a6,-(a7)
		moveq	#0,d0
		tst.l	d1
		blt.s	.ThisError
		move.b	(a4,d1.w),d2
		move.l	d2,-(a7)
		clr.b	(a4,d1.w)
		move.l	a4,a0
		bsr	AllocInfoNode
		move.l	(a7)+,d2
		move.b	d2,(a4,d1.w)
.ThisError:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


		

*------------------------------- Get GadgetAdr -------------------------------*
* d0=0, wenn ok
GetGadgetAdr:	sub.l	a0,a0
		cmp.w	#GadgetAnz,d0
		bhi.s	.Error
		tst.l	GadgetListAdr(a5)
		beq.s	.Error
		lea	GadgetMerkPuffer(a5),a0
		subq.l	#EPENr_FirstNummer,d0
		asl.l	#2,d0
		tst.l	(a0,d0)
		beq.s	.Error
		move.l	(a0,d0),a0
		moveq	#0,d0
.Error:		tst.l	d0
		rts

*---------------- Berechnet die Gre des Strings in a0 ---------------------*
*------- >= a0=String							-----*
*------- => d0=Stringsize						-----*
*----------------------------------------------------------------------------*
BerechStringSize:move.l a0,-(a7)
		moveq	#0,d0
		cmp.l	d0,a0
		beq.s	.NoTest
		moveq	#-1,d0
.NextB:		addq.l	#1,d0
		tst.b	(a0)+
		bne.s	.NextB
.NoTest:	move.l	(a7)+,a0
		tst.l	d0
		rts

*----------------------------------------------------------------------------*
KillLastSchraeg:movem.l	d0/a0,-(a7)
		bsr	BerechStringSize
		lea	-1(a0,d0.w),a0
		cmp.b	#"/",(a0)
		bne.s	.NoSchreag
		clr.b	(a0)
.NoSchreag:	movem.l	(a7)+,d0/a0
		rts

*----------------------------------------------------------------------------*
StringCopy:	move.l	d0,-(a7)
		moveq	#0,d0
		cmp.l	a1,d0
		beq.s	.Return
		cmp.l	a0,d0
		beq.s	.Return
		tst.w	d1
		blt.s	.Return

.CopyIt:	clr.b	(a1)
		move.b	(a0)+,d0		;Copiere String bis 0 d1=Anz
		beq.b	.Return
		move.b	d0,(a1)+
		dbf	d1,.CopyIt
		clr.b	(a1)
.Return:	move.l	(a7)+,d0
		rts

*----------------------------------------------------------------------------*
CopyText:	move.l	d0,-(a7)
		moveq	#0,d0
		cmp.l	a1,d0
		beq.s	.Return
		cmp.l	a0,d0
		beq.s	.Return
		tst.w	d1
		blt.s	.Return

.CopyIt:	clr.b	(a1)
		move.b	(a0)+,d0		;Copiere String bis 0 d1=Anz
		move.b	d0,(a1)+
		dbf	d1,.CopyIt
		clr.b	(a1)
.Return:	move.l	(a7)+,d0
		rts

*----------------------------------------------------------------------------*
*ComputeX:	move.l	d1,-(sp)
*		move.w	FontX(a5),d1
*		bra.s	ComputeItX
*ComputeY:	move.l	d1,-(sp)
*		move.w	FontY(A5),d1
*		mulu	d1,d0
*		addq.w	#4,d0
*		lsr.w	#3,d0
*		move.l	(sp)+,d1
*		rts
*ComputeItX:	mulu	d1,d0
*		addq.w	#4,d0
*		lsr.w	#3,d0
*		move.l	(sp)+,d1
*		rts
*

*-----------------------------------------------------------------------------*

		*------------------ Window ---------------*
WindowTags:	dc.l	WA_MinWidth
Win_MinWidth:	dc.l	DefMinWidth
		dc.l	WA_MinHeight
Win_MinHeight:	dc.l	DefMinHeight
		dc.l	WA_MaxWidth,$8000
		dc.l	WA_MaxHeight,$8000

		dc.l	WA_Left
Win_LeftPos:	dc.l	0
		dc.l	WA_Top
Win_TopPos:	dc.l	0
		dc.l	WA_Width
Win_Width:	dc.l	0
		dc.l	WA_Height
Win_Height:	dc.l	0
		dc.l	WA_IDCMP,IDCMP_Changewindow!IDCMP_RawKey!IDCMP_Menupick!LISTVIEWIDCMP!IDCMP_NEWSIZE!BUTTONIDCMP!IDCMP_CLOSEWINDOW!IDCMP_REFRESHWINDOW
		dc.l	WA_Flags,sizebbottom!WFLG_DRAGBAR!WFLG_DEPTHGADGET!WFLG_CLOSEGADGET!WFLG_SMART_REFRESH!WFLG_SIZEGADGET
		dc.l	WA_Title
LL_WindowTitle:	dc.l	0
		dc.l	WA_ScreenTitle
LL_ScreenTitle	dc.l	0
		dc.l	WA_NewLookMenus,1
		dc.l	WA_AutoAdjust,1
		dc.l	WA_Pubscreen
Pubadr:		dc.l	0
		dc.l	WA_Zoom
		dc.l	ZoomStruct
		dc.l	TAG_DONE
ZoomStruct:	dc.w	0,0,150,0
Ahawidth:	dc.l	399
Ahaheight:	dc.l	80


	*-------------- Gadgetvereinbarungen ----------------*
GadgetTypes:	dc.w	Listview_Kind
		dc.w	Listview_Kind
		dc.w	String_Kind
		dc.w	String_Kind
		dc.w	Generic_Kind

GadgetTags:	dc.l	GTLV_ShowSelected,0		*Archivelist
		*dc.l	GTLV_CallBack,myhook
		dc.l	Tag_Done
		dc.l	Tag_Done			*Archiveinfo
		dc.l	GT_Underscore,'_'		*Pfadstring
		dc.l	GTST_String,0			<-- lokalisieren !!
		dc.l	GTST_MaxChars,PfadPufferSize
		dc.l	Tag_Done
		dc.l	GT_Underscore,'_'		*Optionsstring
		dc.l	GTST_String,0			<-- lokalisieren !!
		dc.l	GTST_MaxChars,OptionsPufferSize
		dc.l	Tag_Done
		dc.l	Tag_Done			*GetFile

Gadgets:
ArchiveListGD:	dc.w	0,0,0,0			;Left,Top,Width,Height
LL_ArchiveList:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_ArchiveList	;GadgetNr
		dc.l	0,0,0			;Flags,VisualInfo,Userdata

ArchiveInfoGD:
		dc.w	0,0,0,0			;Left,Top,Width,Height
LL_ArchiveInfo:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_ArchiveInfo	;GadgetNr
		dc.l	0,0,0			;Flags,VisualInfo,Userdata


PfadStringInfo:	dc.w	0,0,0,0			;Left,Top,Width,Height
LL_PfadInfo:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_Pfad		;GadgetNr
		dc.l	PLACETEXT_RIGHT,0,0	;Flags,VisualInfo,Userdata


OptionsStringInfo:dc.w	0,0,0,0			;Left,Top,Width,Height
LL_OptionsInfo:	dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_Options		;GadgetNr
		dc.l	PLACETEXT_RIGHT,0,0	;Flags,VisualInfo,Userdata

GetFileGadget:	dc.w	0,0,0,0			;Left,Top,Width,Height
		dc.l	0,0			;GadgetText,Font
		dc.w	EPENr_GetFile		;GadgetNr
		dc.l	0,0,0			;Flags,VisualInfo,Userdata

MyIntuiText:	dc.w	0,0
		dc.w	0,0
		dc.l	0			*Font
		dc.l	0			*Text
		dc.l	0			*Next

	*------------------------- Menus -----------------------*
Menus:		dc.b	NM_Title,0
LL_Project:	dc.l	0 Project.MSG		*<-- lokalisieren
		dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LL_About:	dc.l	0 About.MSG		*<-- lokalisieren
LL_AboutKey:	dc.l	0 AboutKey.MSG		*<-- lokalisieren
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
		dc.l	NM_BARLABEL,0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LL_Hide:	dc.l	0 Hide.MSG		*<-- lokalisieren
LL_HideKey:	dc.l	0 HideKey.MSG		*<-- lokalisieren
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LL_Quit:	dc.l	0 Quit.MSG		*<-- lokalisieren
LL_QuitKey:	dc.l	QuitKey.MSG		*<-- lokalisieren
		dc.w	0
		dc.l	0,0

	*------------------------- Menus -----------------------*
		dc.b	NM_Title,0
LL_Config:	dc.l	0			*<-- lokalisieren
		dc.l	0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LL_DefaultConfig:dc.l	0			*<-- lokalisieren
LL_DefaultConfigKey: dc.l 0			*<-- lokalisieren
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
		dc.l	NM_BARLABEL,0
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LL_LoadConfig:	dc.l	0			*<-- lokalisieren
LL_LoadConfigKey:dc.l	0			*<-- lokalisieren
		dc.w	0
		dc.l	0,0

		dc.b	NM_ITEM,0
LL_SaveConfig:	dc.l	0			*<-- lokalisieren
LL_SaveConfigKey:dc.l	0			*<-- lokalisieren
		dc.w	0
		dc.l	0,0
		dc.b	NM_END,0
		dc.l	0,0
		dc.w	0
		dc.l	0,0


MenuTags:	dc.l	GTMN_Newlookmenus,1
		dc.l	TAG_DONE

	*------- Activate ------*
EP_Menu:	dc.l	EPM_Show		;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$5B
		dc.l	0
		dc.l	.ActivateIText
		dc.l	0
		dc.b	0
		ds.b	7
		dc.l	0			*Kick2.04
.ActivateIText:	dc.b	0,3
		ds.w	2
		dc.w	1
		dc.l	0			*Topaz80
		dc.l	0			*Active.MSG (filled by EP)
		dc.l	0
		dc.w	EPNr_MainWindow	*EPNr_Engine
		dc.w	LNr_Active

	*------- Show-Window ------*
EPM_Show	dc.l	0 EPM_BarLabel		;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$5B
		dc.l	0
		dc.l	.ShowIText
		dc.l	0
		dc.b	0
		ds.b	7
		dc.l	0			*Kick2.04
.ShowIText:	dc.b	0,3
		ds.w	2
		dc.w	1
		dc.l	0			*Topaz80
		dc.l	0			*Active.MSG (filled by EP)
		dc.l	0
		dc.w	EPNr_EngineShowState
		dc.w	LNr_Show2



*----------------------------------------------------------------------------*
InternalStrings:
MyProzessName		dc.b	"EP_Extractor.1",0
MyCreatorname:		dc.b	"Eagleeye of DEFECT",0
MySpecialInfo:	dc.b	"This engine scans archives for using in the "
		dc.b	"menu and extract files from archives. "
		dc.b	"Currently, the extractor can handle the "
		dc.b	"following archives: Arj, Ha, Lha, LhArc, Lzx, "
		dc.b	"Rar, Shrink, Zip and Zoo. Please open the "
		dc.b "configurationwindow and set the correct archivpaths.",0
*D				'Dieses Engine scannt Archive wie Directories, '
*D				'bernimmt die Eintrge wie "normale Files"'
*D				' ins Menu und dearchiviert diese bei Anwahl. '
*D				'Zur Zeit werden folgende Archiver untersttzt: '
*D				'Arj, Ha, Lha, LhArc, Lzx, Rar, Shrink, Zip '
*D				'und Zoo. Bitte ffne das Konfigurationswindow '
*D				'und setze die richtigen Pfade fr die jeweiligen '
*D				'Decompressoren.',0
TopazName:		dc.b	"topaz.font",0
Configname:		dc.b	"Extractor.Config",0
Catalogname:		dc.b	"EP_Extractor.catalog",0
TPfad:			dc.b	"T:",0
On:			dc.b	"On",0
Off:			dc.b	"Off",0
QuitKey.MSG:		dc.b	"Q",0

			if	test
Configdir:		dc.b	"EP:configs",0
			endc
ConfigStart:		dc.b	"*",10,"*-- Extractor-Configuration --*"
			dc.b	10,"*",10
NextLine:		dc.b	10,0
EPUserPortName:		dc.b	"EAGLEPLAYERPORT",0
MyMsgPortName:		dc.b	"EP_Extractor.Port",0
*Extractorcon:		dc.b	"CON:0/20/640/400/Extractor-Output/Auto/Close",0

ExternalStrings:
*-------------------------- Locale fr MakeCat -------------------------------*
LOCALE_START
*CATALOG	EP_Extractor
*VERSION	38.2
*DATE		05.03.96

MSG_EX_WindowTitle		dc.b	"Extractor",0
*D				'Extractor',0
MSG_EX_ScreenTitle		dc.b	"Extractor (Eagleplayer),  DEFECT Softworks",0
*D				'Extractor (Eagleplayer),  DEFECT Softworks',0
MSG_EX_ArchiveListName	dc.b	"Archivelist",0
*D				'Archiverliste',0
MSG_EX_ArchiveInfoName	dc.b	"Archiveinformations",0
*D				'Archiverinformationen',0
MSG_EX_PfadName		dc.b	"_Path",0
*D				'_Pfad',0
MSG_EX_OptionsName		dc.b	"_Options",0
*D				'_Optionen',0
MSG_EX_Project		dc.b	"Project",0
*D				'Projekt',0
MSG_EX_Config		dc.b	"Config",0
*D				'Einstellungen',0
MSG_EX_About		dc.b	"About",0
*D				'ber',0
MSG_EX_AboutKey		dc.b	"A",0
*D				'',0
MSG_EX_Hide		dc.b	"Hide",0
*D				'Verstecken',0
MSG_EX_HideKey		dc.b	"H",0
*D				'V',0
MSG_EX_Quit		dc.b	"Quit",0
*D				'Ende',0
MSG_EX_Ok			dc.b	"Ok",0
*D				'Ok',0
MSG_EX_Default		dc.b	"Default config",0
*D				'Standardeinstellungen',0
MSG_EX_DefaultKey		dc.b	"D",0
*D				'S',0
MSG_EX_LoadConfig		dc.b	"Load config",0
*D				'Einstellungen laden',0
MSG_EX_LoadConfigKey	dc.b	"L",0
*D				'L',0
MSG_EX_SaveConfig		dc.b	"Save config",0
*D				'Einstellungen speichern',0
MSG_EX_SaveConfigKey	dc.b	"S",0
*D				'S',0
MSG_EX_RequestTitle		dc.b	"Extractor-Message",0
*D				'Extraktornachricht',0
MSG_EX_AboutText		dc.b	"Extractor V1.5 by",10,10
			dc.b	"Jan Blumenthal",10
			dc.b	"Erich-Mhsam-Str. 34",10
			dc.b	"18069 Rostock",10
			dc.b	"Tel.: +49 (0)381/83979",10,0
*D				'Extractor V1.5 von',10,10
*D				'Jan Blumenthal',10
*D				'Erich-Mhsam-Str. 34',10
*D				'18069 Rostock',10
*D				'Tel.: +49 (0)381/83979',10,0

MSG_EX_EPNotFound		dc.b	"Cannot find EaglePlayer Port",0
*D				'Eagleplayer nicht gefunden !',0

MSG_EX_ARJInfo	dc.b	'Arj was written by Robert K. Jung 1990-93 for MS-DOS computers. '
		dc.b	'It is not available for Amigas, just a quite simple decruncher tool, '
		dc.b	'programmed by Heaven MB.',10
		dc.b	'Arj is Shareware.',0
*D			'Arj wurde von Robert K. Jung 1990-93 fr MS-DOS PC`s geschrieben. '
*D			'Fr den Amiga ist lediglich ein (sehr drftiges) Entpackertool '
*D			'verfgbar, programmiert von Heaven MB.',10
*D			'Arj ist Shareware.',0

MSG_EX_HAInfo	dc.b	'Ha is an archiver offering very high compression results, '
		dc.b	'but lacks in terms of speed. In some cases it packs better than '
		dc.b	'LZX. It was written by Harri Hivola (1995). The amiga portation was done'
		dc.b	'by Pascal Lauly',10
		dc.b	'Ha is public domain (GNU public license)',0
*D			'HA ist ein Archiver mit extrem hoher Packeffizenz, allerdings geringer'
*D			'Geschwindigkeit. Geschrieben wurde es von Harri Hivola (1995). Ha ist '
*D			'fr verschiedene Rechnerplattformen verfgbar. Die '
*D			'Amigaversion, portiert von Pascal Lauly  luft nicht sehr stabil.',10
*D			'Ha ist Public Doman.',0

MSG_EX_LHAInfo	dc.b	'Lha is a high-performance file-compression '
		dc.b	'program available for nearly every computer platform. '
		dc.b	'Though it is some years old it is still the standard Amiga '
		dc.b	'archiver. (Aminet, PD-Disks) ',10
		dc.b	'Lha was written by Haruyasu Yoshizaki (1988) and '
		dc.b	'the Amiga version was programmed by Stefan Boberg '
		dc.b	'(1991).',10
		dc.b	'Lha is Shareware.',10
		dc.b	'At this time SFX-Archives aren`t supported.',0
*D			'Lha ist ein Archiver mit hchster Effizienz und '
*D			'auf allen Rechnerplattformen anzutreffen. Er '
*D			'hat sich beim Amiga zum Standardarchiver entwickelt, '
*D			'obwohl es bessere Archiver gibt.',10
*D			'Lha wurde 1988 von Haruyasu Yoshizaki ent'
*D			'wickelt und 1991 von Stefan Boberg auf den Amiga '
*D			'umgesetzt.',10
*D			'Lha ist Shareware.',10,10
*D			'SFX-Archive werden zur Zeit vom Extractor nicht '
*D			'entpackt.',0


MSG_EX_LhArcInfo	dc.b	'LhArc is a high-performance file-compression '
		dc.b	'program available for nearly every computer platform. '
		dc.b	'Though it is some years old it is still the standard Amiga '
		dc.b	'archiver. (Aminet, PD-Disks) ',10
		dc.b	'LhArc was written by Haruyasu Yoshizaki (1988) and '
		dc.b	'the Amiga version was programmed by Paolo Sibetti '
		dc.b	'(1990).',10
		dc.b	'Lha is Shareware.',10
		dc.b	'At this time SFX-Archives aren`t supported.',0
*D			'LhArc ist ein Archiver mit hchster Effizienz und '
*D			'auf allen Rechnerplattformen anzutreffen.',10
*D			'LhArc wurde 1988 von Haruyasu Yoshizaki ent'
*D			'wickelt und 1990 von Paolo Sibetti auf den Amiga '
*D			'umgesetzt.',10
*D			'LhArc ist Shareware.',10,10
*D			'SFX-Archive werden zur Zeit vom Extractor nicht '
*D			'entpackt.',0

MSG_EX_LZXInfo	dc.b	'LZX is the latest and greatest archiver for the Amiga. LZX is the most '
		dc.b	'compressive utility available, sporting some revolutionary new ideas in '
		dc.b	'data compression technology.  It also decompresses data faster than any '
		dc.b	'other popular Amiga archiver. ',10
		dc.b	'Authors: Jonathan Forbes and Tomi Poutanen',10
		dc.b	"LZX is Shareware.",0
*D			'LZX wurde 1995 von Data Compression Technologies '
*D			'geschrieben und entwickelt sich zum Standardarchiver '
*D			'auf dem Amiga. Es erreicht nicht zuletzt durch ausgeklgeltes '
*D			'Sortieren und Zusammenfgen der Files hchste Crunchraten.',10,10
*D			'LZX ist Shareware.',0


MSG_EX_RARInfo	dc.b	'Rar is a MS-DOS archiver with a kind of graphical user interface '
		dc.b	'and good compression results. For the Amiga there is only an '
		dc.b	'unpack utility by Eugene Roshal available.',10
		dc.b	'Rar is Shareware.',10
		dc.b	'Self Extracting archives are currently not supported ',0
*D			'Rar ist ein Archiver auf dem PC, der eine '
*D			'(graphische?!) Oberflche hat und recht sich gut '
*D			'bedient. Auf dem Amiga ist leider nur ein Unrar '
*D			'von Eugene '
*D			'Roshal verfgbar.'
*D			'Rar ist Shareware.',10
*D			'SFX-Archive werden zur Zeit nicht untersttzt.',0

MSG_EX_SHRInfo	dc.b	'Shrink is an amiga archiver offering excellent packing results but '
		dc.b	'packing AND depacking slowly due to the used algorithm. '
		dc.b	'Shrink was written by Matthias Meixner.',10
		dc.b	'Shrink is Shareware.',0
*D			'Shrink ist ein Amigaarchiver, der eine extrem hohe Effizienz bei einer '
*D			'(algorithmusbedingten) lausigen Geschwindigkeit. Shrink wurde von '
*D			'Matthias Meixner programmiert.',10
*D			'Shrink ist Shareware.',0

MSG_EX_ZIPInfo	dc.b	'Zip is probably the most used archiver on MS-DOS systems. '
		dc.b	'It offers good packing rates and a quite high speed. '
		dc.b	'The MS-DOS version is distributed by PKWare. The Amiga version is '
		dc.b	'Freeware. Furthermore there exist several programs using the zip '
		dc.b	'algorithm. (Gzip - popular unix file packer, Amiga XPK sublibrary called '
		dc.b	'XPKGZIP.library)',0
*D			'Zip ist in der MSDos-Welt einer der groen Standard'
*D			'archiver. Die Packraten sind sehr gut. Die PC-Version '
*D			'wird von PKWare vertrieben. Der Zip-Algorithmus wird in '
*D			'verschiedener Weise verwendet, einmal fr den hier untersttzten Archiver, '
*D			'weiterhin fr GZip, einen besonders auf Unix-Maschinen blichen Filepacker, '
*D			'auerdem gibt es auf dem Amiga auch noch die sehr empfehlenswerte '
*D			'XPKGZIP.library. ',10
*D			'Zip ist Freeware.',0

MSG_EX_ZOOInfo	dc.b	'Zoo is a quite old archiver. If anybody should still use this '
		dc.b	'antiquated tool he should better use LHA, LZX or Zip. '
		dc.b	'The PC-Version was written by Rahul Dhesi. '
		dc.b	'The Amiga-Version was ported by J. Brain Waters.',10
		dc.b	'Zoo is Shareware.',0
*D			'Zoo ist schon einer der lteren Archiver. Wer '
*D			'unbedingt Files archivieren mu, sollte auf LHA oder'
*D			' LZX zurckgreifen. Die PC-Version wurde von Rahul '
*D			' Dhesi geschrieben. '
*D			'Die Amiga-Version programmierte J. Brain Waters.',10
*D			'Zoo ist Shareware.',0

LOCALE_END

;MSG_EX_ARCInfo	dc.b	"Amigaarc wurde 1985-87 von System Enhancement "
;		dc.b	"Associates & chRaymond S. Brand geschrieben.",10
;		dc.b	"Arc ist Public Doman.",0
;*D			'Amigaarc wurde 1985-87 von System Enhancement '
;*D			'Associates & chRaymond S. Brand geschrieben.',10
;*D			'Arc ist Public Doman.',0

;MSG_EX_SQZInfo	dc.b	"SQZ wurde von J.I. Hammarberg (1993) geschrieben. "
;		dc.b	"Die Amigaversion ist z.Z. nicht hier.",10
;		dc.b	"Squeeze It ist Shareware.",0
;*D			'SQZ wurde von J.I. Hammarberg (1993) geschrieben. '
;*D			'Die Amigaversion ist z.Z. nicht hier.',10
;*D			'Squeeze It ist Shareware.',0


;MSG_EX_TarInfo	dc.b	"Tar ??",0
;		dc.b	"Tar ist Shareware.",0
;*D			'Tar ist ??. '
;*D			'Tar ist Shareware.',0
;

			dc.b	0

			even

LocaleTabelle:	dc.w	LENr_Archivelist,LL_Archivelist-LocaleTabelle
		dc.w	LENr_ArchiveInfo,LL_ArchiveInfo-LocaleTabelle
		dc.w	LENr_Pfad,LL_PfadInfo-LocaleTabelle
		dc.w	LENr_Options,LL_OptionsInfo-LocaleTabelle
		dc.w	LENr_Project,LL_Project-LocaleTabelle
		dc.w	LENr_About,LL_About-LocaleTabelle
		dc.w	LENr_AboutKey,LL_AboutKey-LocaleTabelle
		dc.w	LENr_Hide,LL_Hide-LocaleTabelle
		dc.w	LENr_HideKey,LL_HideKey-LocaleTabelle
		dc.w	LENr_Quit,LL_Quit-LocaleTabelle
	*	dc.w	LENr_QuitKey,LL_QuitKey-LocaleTabelle
		dc.w	LENr_WindowTitle,LL_WindowTitle-LocaleTabelle
		dc.w	LENr_ScreenTitle,LL_ScreenTitle-LocaleTabelle
		dc.w	LENr_Config,LL_Config-LocaleTabelle
		dc.w	LENr_DefaultConfig,LL_DefaultConfig-LocaleTabelle
		dc.w	LENr_DefaultConfigKey,LL_DefaultConfigKey-LocaleTabelle
		dc.w	LENr_LoadConfig,LL_LoadConfig-LocaleTabelle
		dc.w	LENr_LoadConfigKey,LL_LoadConfigKey-LocaleTabelle
		dc.w	LENr_SaveConfig,LL_SaveConfig-LocaleTabelle
		dc.w	LENr_SaveConfigKey,LL_SaveConfigKey-LocaleTabelle
		dc.w	0

*-----------------------------------------------------------------------------*
* Input: *a0=TextAdr (Font)						      *
*	 a0=Text							      *
* Output:d0=Size							      *
*-----------------------------------------------------------------------------*
GetTextLenght:	movem.l	d1-a6,-(a7)
		lea	MyIntuiText(pc),a2
		move.l	Font(a5),8(a2)
		move.l	a0,12(a2)
		move.l	a2,a0
		move.l	IntBase(a5),a6
		jsr	_LVOIntuiTextLength(a6)
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

Allocmem:	movem.l	d1/a0/a1/a6,-(a7)
		moveq	#0,d1				*EgalMem
		bset	#16,d1				;Kennung Mem-Clearen
		EB
		jsr	_LVOAllocMem(a6)
		movem.l	(a7)+,d1/a0/a1/a6
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
InitLocale:	movem.l	d0-a6,-(a7)

		*--- Catalog ffnen ---*
		tst.l	MyCatalog(a5)
		bne.s	.NoCatalog
		move.l	LocaleBase(a5),d0
		beq.s	.NoCatalog
		move.l	d0,a6
		suba.l	a0,a0
		suba.l	a2,a2
		lea	Catalogname(pc),a1
		jsr	_LVOOpenCatalogA(a6)		;_LVOopencatalogA
		move.l	d0,MyCatalog(a5)

.NoCatalog:	moveq	#5,d0
		lea	LocaleTabelle-4(pc),a0
		lea	LocaleTabelle(pc),a1
.NextOne:	lea	4(a0),a0
		move.w	(a0),d0
		beq.s	.DasWars
		move.w	2(a0),d1
		lea	(a1,d1.w),a2
		bsr	GetLocaleString
		move.l	d0,(a2)
		bra.s	.NextOne
.DasWars:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
FreeLocale:	movem.l	d0-a6,-(a7)
		tst.l	MyCatalog(a5)
		beq.s	.NoCatalog
		move.l	LocaleBase(a5),d0
		beq.s	.NoCatalog
		move.l	d0,a6
		move.l	MyCatalog(a5),d0
		jsr	_LVOCloseCatalog(a6)
.NoCatalog:	clr.l	MyCatalog(a5)
		movem.l	(a7)+,d0-a6
		rts

*---------------------------- Erstmal ignorieren -----------------------------*
*-----------------------------------------------------------------------------*
FirstLocaleInit:movem.l	d0-a6,-(a7)
		lea	LocalePuffer+2(a5),a4
		lea	ExternalStrings,a3
		move.w	#LENr_LastExternal,d1
		move.l	a3,a0
.NextString2:	move.l	a0,d0
		sub.l	a3,d0
		move.w	d0,(a4)+
.FindZero2:	tst.b	(a0)+
		bne.s	.FindZero2
	*	tst.b	(a0)
	*	beq.s	.SetAbsStrings
		subq.w	#1,d1
		bne.s	.NextString2
.Ok:		movem.l	(a7)+,d0-a6
		rts



*-----------------------------------------------------------------------------*
* Input:  D0.w = LocaleNr						      *
* Output: D0.l = StringAdr						      *
*-----------------------------------------------------------------------------*
GetLocaleString:
		movem.l	d1/d2/a0/a1/a6,-(a7)

	*------- LocaleString aus internem Catalog suchen ------*
		move.l	d0,d2
		sub.l	a0,a0
		lea	ExternalStrings,a1
		cmp.w	#LENr_LastExternal,d0
		bhi.s	.Error
		lea	LocalePuffer(a5),a0
		ext.l	d0
		add.l	d0,d0
		move.w	(a0,d0.l),d0			;kein ext.l weil immer
		lea	(a1,d0.w),a0
.Error:		move.l	a0,d0

	*---------- Nun LocaleString aus Catalog suchen ---------*
		move.l	LocaleBase(a5),d1
		beq.s	.Return
		move.l	d1,a6
		move.l	MyCatalog(a5),d1
		beq.s	.Return
		move.l	d1,a0
		move.l	d0,a1
		move.l	d2,d0				* Stringnummer
		subq.l	#1,d0
		ext.l	d0
		jsr	_LVOGetCatalogStr(a6)		*--> d0=valid String

.Return:	movem.l	(a7)+,d1/d2/a0/a1/a6
		rts


ARTM		MACRO
		dc.w	\1-ArchiverTabelle
		ENDM



*-----------------------------------------------------------------------------*
ArchiverTabelle:

*		ARTM	ARC.MSG			* Offs. to Name fr Listview
*		dc.w	LENr_InfoARC		* Offs. to Infotext fr Listview
*		ARTM	ARCSuffix		* Offs. to Suffix
*		ARTM	ARCTest			* TestValidArchive
*		dc.w	2			* SeekNr
*		ARTM	ARCExNext		* ArchiveExNext
*		ARTM	ARCDefPfad		* Def. Pfad
*		ARTM	ARCDefOptions		* Def. Options
*		dc.w	1			* State

		ARTM	ARJ.MSG			* Offs. to Name fr Listview
		dc.w	LENR_InfoARJ		* Offs. to Infotext fr Listview
		ARTM	ARJSuffix		* Offs. to Suffix
		ARTM	ARJTest			* TestValidArchive
		dc.w	0			* Seek
		ARTM	ARJExNext		* ArchiveExNext
		ARTM	ARJDefPfad		* Def. Pfad
		ARTM	ARJDefOptions		* Def. Options
		dc.w	0			* State

		ARTM	Ha.MSG			* Offs. to Name fr Listview
		dc.w	LENr_InfoHa		* Offs. to Infotext fr Listview
		ARTM	HASuffix		* Offs. to Suffix
		ARTM	HATest			* TestValidAAhive
		dc.w	4			* Seek
		ARTM	HAExNext		* AAhiveExNext
		ARTM	HADefPfad		* Def. Pfad
		ARTM	HADefOptions		* Def. Options
		dc.w	1			* State

		ARTM	LHA.MSG			* Offs. to Name fr Listview
		dc.w	LENr_InfoLHA		* Offs. to Infotext fr Listview
		ARTM	LHASuffix		* Offs. to Suffix
		ARTM	LHATest			* TestValidArchive
		dc.w	0			* Seek
		ARTM	LHAExNext		* ArchiveExNext
		ARTM	LHADefPfad		* Def. Pfad
		ARTM	LHADefOptions		* Def. Options
		dc.w	1			* State

		ARTM	LhArc.MSG		* Offs. to Name fr Listview
		dc.w	LENr_InfoLhArc		* Offs. to Infotext fr Listview
		ARTM	LhArcSuffix		* Offs. to Suffix
		ARTM	LHATest			* TestValidArchive
		dc.w	0			* Seek
		ARTM	LHAExNext		* ArchiveExNext
		ARTM	LHADefPfad		* Def. Pfad
		ARTM	LHADefOptions		* Def. Options
		dc.w	1			* State

		ARTM	LZX.MSG			* Offs. to Name fr Listview
		dc.w	LENr_InfoLZX		* Offs. to Infotext fr Listview
		ARTM	LZXSuffix		* Offs. to Suffix
		ARTM	LZXTest			* TestValidArchive
		dc.w	10			* Seek
		ARTM	LZXExNext		* ArchiveExNext
		ARTM	LZXDefPfad		* Def. Pfad
		ARTM	LZXDefOptions		* Def. Options
		dc.w	1			* State

		ARTM	RAR.MSG			* Offs. to Name fr Listview
		dc.w	LENr_InfoRAR		* Offs. to Infotext fr Listview
		ARTM	RARSuffix		* Offs. to Suffix
		ARTM	RARTest			* TestValidRARhive
		dc.w	$14			* Seek
		ARTM	RARExNext		* RARhiveExNext
		ARTM	RARDefPfad		* Def. Pfad
		ARTM	RARDefOptions		* Def. Options
		dc.w	1			* State

		ARTM	SHR.MSG			* Offs. to Name fr Listview
		dc.w	LENr_InfoSHR		* Offs. to Infotext fr Listview
		ARTM	SHRSuffix		* Offs. to Suffix
		ARTM	SHRTest			* TestValidSHRhive
		dc.w	$1a			* Seek
		ARTM	SHRExNext		* SHRhiveExNext
		ARTM	SHRDefPfad		* Def. Pfad
		ARTM	SHRDefOptions		* Def. Options
		dc.w	1			* State

*		ARTM	SQZ.MSG			* Offs. to Name fr Listview
*		dc.w	LENR_InfoSQZ		* Offs. to Infotext fr Listview
*		ARTM	SQZSuffix		* Offs. to Suffix
*		ARTM	SQZTest			* TestValidSQZhive
*		dc.w	0			* Seek
*		ARTM	SQZExNext		* SQZhiveExNext
*		ARTM	SQZDefPfad		* Def. Pfad
*		ARTM	SQZDefOptions		* Def. Options
*		dc.w	1			* State

*		ARTM	Tar.MSG			* Offs. to Name fr Listview
*		dc.w	LENr_InfoTar		* Offs. to Infotext fr Listview
*		ARTM	TarSuffix		* Offs. to Suffix
*		ARTM	TarTest			* TestValidSHRhive
*		dc.w	0			* Seek
*		ARTM	TarExNext		* SHRhiveExNext
*		ARTM	TarDefPfad		* Def. Pfad
*		ARTM	TarDefOptions		* Def. Options
*		dc.w	1			* State

		ARTM	ZIP.MSG			* Offs. to Name fr Listview
		dc.w	LENr_InfoZIP		* Offs. to Infotext fr Listview
		ARTM	ZIPSuffix		* Offs. to Suffix
		ARTM	ZIPTest			* TestValidZIPhive
		dc.w	0			* Seek
		ARTM	ZIPExNext		* ZIPhiveExNext
		ARTM	ZIPDefPfad		* Def. Pfad
		ARTM	ZIPDefOptions		* Def. Options
		dc.w	1			* State

		ARTM	ZOO.MSG			* Offs. to Name fr Listview
		dc.w	LENr_InfoZOO		* Offs. to Infotext fr Listview
		ARTM	ZOOSuffix		* Offs. to Suffix
		ARTM	ZOOTest			* TestValidZOOhive
		dc.w	$2a			* Seek
		ARTM	ZOOExNext		* ZOOhiveExNext
		ARTM	ZOODefPfad		* Def. Pfad
		ARTM	ZOODefOptions		* Def. Options
		dc.w	1			* State

		dc.w	0

	ifne	(*-Archivertabelle-2)/EPAT_SizeOf-EPAIT_MaxId
	Aber Hallo
	endc

*-----------------------------------------------------------------------------*
* Input: a0=StructAdr							      *
*	 a1=Pfadadr (Ziel)						      *
*	 d1=Pfadsize							      *
* Output:d0=Error oder NULL						      *
*-----------------------------------------------------------------------------*
EP_ArchiveExNext:
		movem.l	d1-a6,-(a7)
		lea	Puffer,a5
		moveq	#EPR_ErrorInFile,d7
		tst.l	d1
		blt.w	.Error
		moveq	#0,d6
		move.w	d1,d6		-> Zielpfadsize
		blt.s	.Error
		move.l	a1,d0
		beq.s	.Error
		move.l	d0,a3		-> Zielpfad
		move.l	a0,d0
		beq.w	.Error				*-- Keine Structur
		move.l	d0,a4		-> Struct

	*-----------------------------------------------*
	*	 interner Aufruf der Extractoren        *
	* Input: a3=Ziel				*
	*	 a4=EPAI_Info				*
	*	 d6=Zielsize				*
	* Output:d0=Error oder NULL			*
	*-----------------------------------------------*
		move.l	EPAI_EPAT_Struct(a4),d0
		beq.s	.Error
		move.l	d0,a0
		clr.b	(a3)				*erstmal NullSetzen
		lea	ArchiverTabelle(pc),a1
		moveq	#0,d0
		move.w	EPAT_ExNext(a0),d0
		add.l	a1,d0
		move.l	d0,a0
		move.l	d7,d0				*Def Error
		move.l	a3,-(a7)
		jsr	(a0)
		move.l	(a7)+,a3

		bsr	CorrectPfad

		move.l	d0,d7
		beq.s	.Return

		tst.b	(a3)
		beq.s	.Error

		clr.b	(a3)				*Bei Fehler lschen
.Error:		move.l	d7,d0
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
EXRet:		rts



CorrectPfad	move.l	a3,a0
.NextB:		move.b	(a0)+,d1
		beq.s	EXRet
		cmp.b	#"\",d1
		bne.s	.NoSchr
		moveq	#"/",d1
.NoSchr:	move.b	d1,-1(a0)
		bra.s	.NextB


*------------------------ Errortroutinen fr ExNext --------------------------*
EXN_SeekTest:	addq.l	#1,d0
		bne.s	EXN_AllesOk
EXN_UnknownArchive:
		moveq	#EPR_UnknownArchive,d0
		rts
EXN_Error:	moveq	#EPR_ErrorInFile,d0
		rts
EXN_ErrorBuffer:moveq	#EPR_BufferFull,d0
		rts
EXN_NoMoreEntries:
		moveq	#EPR_NoMoreEntries,d0
		*tst.b	d6
		*beq.s	.NoNameSize
		*clr.b	(a3)
.NoNameSize:	rts

EXN_AllesOk:	moveq	#0,d0
		rts


	*------------- Engines aufrufen ----------------*
	* In WorkPuffer steht dann der neue Filename    *
	* zB."Mod.Test" Das File wird vom EP gelscht.	*
	*-----------------------------------------------*
	* Input: a0=Pfad des Archives			*
	*	 a1=Pfad des Namens im Archive		*
	*	 a2=WorkPuffer fr Befehlspfad		*
	*	 d2=WorkPufferSize			*
	* Output:d0=Error oder NULL			*
	*-----------------------------------------------*
EP_ExtractArchiveEntry:
		movem.l	d1-a6,-(a7)
		lea	Puffer,a5
		move.l	a0,d4
		move.l	a1,d5
		move.l	a2,d6
		move.l	d2,d7

		bsr	FindExtractor
		bne.w	.Error

		*--- Pfad in WorkPuffer kopieren ---*
		move.l	a3,a0			*Archiverpfad
		move.l	d6,a1
		move.w	d7,d1
		subq.l	#3,d1			*Sicherheit + " "
		blt.w	.Error
		bsr	StringCopy
		move.b	#" ",(a1)+
		move.l	d5,a3		*--> Entry
		move.l	d4,a0
		bsr	CreateOptions		*Options kopieren 
		bne.w	.Error

		*---- T: Verzeichnis setzen ---*
		moveq	#0,d3
		lea	TPfad(pc),a0
		move.l	a0,d1
		move.l	#-2,d2
		move.l	Dosbase(a5),a6
		jsr	_LVOLock(a6)
		tst.l	d0
		beq.s	.Error
		move.l	d0,d1
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d3

		*--- HilfsWindow ffnen ---*
		*move.l	#ExtractorCon,d1
		*move.l	#1005,d2
		*jsr	_LVOOpen(a6)

		move.l	d3,-(a7)
		*move.l	d0,d2
		*move.l	d0,d3


		*----- Entpacken -----*
		move.l	d6,d1				*WorkPuffer
		moveq	#0,d2
		moveq	#0,d3
		move.l	Dosbase(a5),a6
		jsr	_LVOExecute(a6)

		*move.l	d2,d1
		*beq.s	.NoExtrWin
		*jsr	_LVOClose(a6)

.NoExtrWin:	move.l	(a7)+,d3
		move.l	d0,-(a7)
		move.l	d3,d1
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnLock(a6)
		move.l	(a7)+,d0			*Error von Execute
		tst.l	d0
		beq.s	.Error

	*------------ File vorhanden ? ----------*
		move.l	d6,a1				*WorkPuffer
		move.b	#'T',(a1)+
		move.b	#':',(a1)+
		move.l	d5,a0				*EntryName
		move.l	d7,d1
		bsr	StringCopy
		move.l	d6,d1
		moveq	#-2,d2
		move.l	Dosbase(a5),a6
		jsr	_LVOLock(a6)
		tst.l	d0
		beq.s	.Error
		move.l	d0,d1
		jsr	_LVOUnLock(a6)
		moveq	#0,d0
		bra.s	.Return

.Error:		move.l	#EPR_ExtractorNotFound,d0
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
* Input: a0=Pfad des Archives						      *
* Output:a2=OptionsPuffer						      *
*	 a3=PfadPuffer							      *
*	 a4=EPAT_Structure						      *
*	 d0=Error oder NULL						      *
*-----------------------------------------------------------------------------*
FindExtractor:	movem.l	d1-d7/a0/a1/a5/a6,-(a7)
		moveq	#EPR_ExtractorNotFound,d7
		bsr	BerechStringSize

	*-- Punkt finden --*
		lea	(a0,d0.w),a0
		move.l	d0,d1
.TestIt:	subq.l	#1,d1
		blt.s	.Error
		cmp.b	#".",-(a0)
		bne.s	.TestIt

		*lea	-4(a0,d0.w),a0
		lea	AllPfadPuffer-PfadPufferSize(a5),a3
		lea	AllOptionsPuffer-OptionsPufferSize(a5),a2
		lea	Archivertabelle-EPAT_SizeOf(pc),a4
		moveq	#0,d1
.NextOne:	addq.l	#1,d1
		lea	EPAT_SizeOf(a4),a4
		lea	PfadPufferSize(a3),a3
		lea	OptionsPufferSize(a2),a2
		tst.w	EPAT_Name(a4)
		beq.w	.Error
		lea	ArchiverTabelle(pc),a1
		move.w	EPAT_Suffix(a4),d0
		add.l	a1,d0
		move.l	d0,a1
		bsr	StrCMP
		bne.s	.NextOne

		tst.w	EPAT_State(a4)
		beq.s	.NextOne

		moveq	#0,d7
.Error:		move.l	d7,d0
.Return:	movem.l	(a7)+,d1-d7/a0/a1/a5/a6
		tst.l	d0
		rts




*-----------------------------------------------------------------------------*
* Creaiert einen Pfad aus "-l x "%1" wird "-l x "modules\di.nightmare"        *
* %1 = Name des Archives						      *
* %2 = Name des Entries							      *
* %3 = DestPfad								      *
* Input: a0=Archivename							      *
*	 a1=Dest							      *
*	 a2=Pfad der Optionen						      *
*	 a3=Entryname							      *
*	 d1=Size des Puffers						      *
* Output:d0=Error oder NULL						      *
*-----------------------------------------------------------------------------*
CreateOptions:	movem.l	d1-a6,-(a7)
		move.l	a0,d4
		moveq	#EPR_ErrorInString,d0
.NextB:		move.b	(a2)+,d2
		beq.s	.Fertig		
		cmp.b	#"%",d2
		bne.s	.CopyIt
		move.b	(a2)+,d2
		
		sub.b	#"1",d2
		blt.s	.Error
		cmp.b	#3,d2
		bhi.s	.Error
		move.l	d4,a0				*Archivepfad
		tst.b	d2
		beq.s	.CopyString
		move.l	a3,a0				*Entryname
		subq.b	#1,d2
		beq.s	.CopyString
		lea	TPfad(pc),a0			*TPfad
.CopyString:	bsr	StringCopy
		bra.s	.NextB

.CopyIt:	move.b	d2,(a1)+
		dbf	d1,.NextB
.Fertig:	clr.b	(a1)
		moveq	#0,d0
.Error:		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts



*-----------------------------------------------------------------------------*
* Input: a0=Pfad							      *
* Output:d0=Error oder NULL						      *
*	 d1=Archivestructur (engineintern)				      *
*-----------------------------------------------------------------------------*
EP_TestValidArchive:
		movem.l	d2-a6,-(a7)
		lea	Puffer,a5
		moveq	#EPR_UnknownArchive,d7
		bsr	KillLastSchraeg

		move.l	a0,d6
		bsr	FindExtractor
		bne.s	.Error

		*---- Archive ffnen -----*
		move.l	a0,d1
		move.l	#1005,d2
		move.l	Dosbase(a5),a6
		jsr	_LVOOpen(a6)
		move.l	d0,d6
		beq.s	.Error

		*---- 30 Bytes lesen ----*
		lea	TextPuffer(a5),a0
		move.l	a0,d2
		move.l	d6,d1
		moveq	#44,d3
		jsr	_LVORead(a6)
		cmp.l	d0,d3
		beq.s	.ReadOK
		move.l	d6,d1
		jsr	_LVOClose(a6)
		moveq	#EPR_ErrorInFile,d7
		bra.s	.Error

	*--- Interne Archiver ansprechen ---*
	* Input: d0=Def Error		    *
	*	 d1=Handle		    *
	* Output:d0=Error oder NULL	    *
	*-----------------------------------*
.ReadOk:	move.w	EPAT_Test(a4),d0
		lea	ArchiverTabelle(pc),a1
		add.l	a1,d0
		move.l	d0,a0
		move.l	d7,d0				*Def Error
		move.l	d6,d1				*Handle
		movem.l	d1-a6,-(a7)
		jsr	(a0)
		movem.l	(a7)+,d1-a6

		*----- Archive schlieen -----*
		move.l	d0,-(a7)
		move.l	d6,d0
		jsr	_LVOClose(a6)
		move.l	(a7)+,d0
		moveq	#0,d1
		move.l	d0,d7
		bne.s	.Error
		move.l	a4,d1				*Type vom FindExtraktor
.Error:		move.l	d7,d0
		movem.l	(a7)+,d2-a6
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
* Input: a0=Pfad des Archives						      *
* Output:d0=Error oder NULL						      *
*	 a0=Structadr							      *
*-----------------------------------------------------------------------------*
EP_OpenArchive:	movem.l	d1-d7/a1-a6,-(a7)
		lea	Puffer,a5
		sub.l	a4,a4
		bsr	EP_TestValidArchive
		bne.w	.Error

		moveq	#EPR_FileNotFound,d7
		move.l	d1,d5
		move.l	a0,d1
		move.l	#1005,d2
		move.l	Dosbase(a5),a6
		jsr	_LVOOpen(a6)
		move.l	d0,d6
		beq.w	.Error
		move.l	d0,a0

		moveq	#EPR_NotEnoughMem,d7
		moveq	#EPAI_SizeOF,d0
		bsr	AllocMem
		beq.s	.Close
		move.l	d0,a4
		move.l	d6,EPAI_Handle(a4)
		move.l	#EPAI_SizeOf,EPAI_StructSize(a4)
		move.l	d5,EPAI_EPAT_Struct(a4)

		*----- Seek fr ExNext setzen -----*
		move.l	d5,a1
		moveq	#0,d2
		move.w	EPAT_Seek(a1),d2
		beq.s	.ArchiveOk

		move.l	d6,d1				*Handle
		moveq	#0,d3				;Mode
		move.l	Dosbase(a5),a6
		jsr	_LVOSeek(a6)
		addq.l	#1,d0
		beq.w	.FreeMem
.ArchiveOk:	moveq	#0,d0
		bra.s	.Return

.FreeMem:	move.l	a4,d0
		beq.s	.Close
		move.l	a4,a1
		move.l	EPAI_StructSize(a4),d0
		beq.s	.Close
		EB
		jsr	_LVOFreeMem(a6)
.Close:		sub.l	a4,a4
		move.l	d6,d1
		beq.s	.Error
		move.l	Dosbase(a5),a6
		jsr	_LVOClose(a6)
.Error:		move.l	d7,d0
		sub.l	a4,a4
.Return:	move.l	a4,a0
		movem.l	(a7)+,d1-d7/a1-a6
		tst.l	d0
		rts



*-----------------------------------------------------------------------------*
* Input: a0=StructAdr							      *
*-----------------------------------------------------------------------------*
EP_CloseArchive:movem.l	d0-a6,-(a7)
		lea	Puffer,a5
		move.l	a0,a4
		move.l	a0,d1
		beq.s	.NoAdr
		move.l	EPAI_Handle(a4),d1
		beq.s	.NoHandle
		move.l	Dosbase(a5),a6
		jsr	_LVOClose(a6)
.NoHandle:	move.l	EPAI_StructSize(a4),d0
		move.l	a4,a1
		EB
		jsr	_LVOFreeMem(a6)
.NoAdr:		movem.l	(a7)+,d0-a6
		rts



;*------------------------------ Arc-Archive ----------------------------------*
;ArcTest:	cmp.w	#$1a08,TextPuffer(a5)
;		bne.s	.No
;		moveq	#0,d0
;.No		rts
;
;	*----------- Arc-Archive-ExNext -----------*
;ReadSize = 5
;ArcExNext:	move.l	EPAI_Handle(a4),d1
;		beq.w	EXN_Error
;		move.l	a3,d2
;		clr.b	(a3)
;		moveq	#0,d4			*Pos im LadePuffer
;		moveq	#0,d5			*Bytes, die real geladen wurden
;
;		*-- Ende des Filenamens finden --*
;		moveq	#0,d7
;		lea	-1(a3),a0
;.NochmehrLaden:	cmp.w	d6,d7
;		bhi.w	EXN_Error
;		addq.l	#1,a0
;		moveq	#1,d3
;		bsr	.LeseBytes
;		tst.l	d0
;		beq.w	EXN_NoMoreEntries
;		addq.l	#1,d7
;		tst.b	(a0)
;		bne.s	.NochmehrLaden
;
;		*-- unterschiedlich lange CrunchInfo durchtesten --*
;		lea	TextPuffer-4(a5),a0
;.NochmehrLaden2:moveq	#1,d3
;		bsr	.LeseBytes
;		cmp.l	d3,d0
;		bne.w	EXN_Error
;		addq.l	#1,d7
;		tst.b	(a0)
;		bne.s	.NochmehrLaden2
;
;
;		*----- Decr Size laden -----*
;		lea	TextPuffer-4(a5),a0
;		moveq	#4,d3
;		bsr	.LeseBytes
;		cmp.l	d0,d3
;		bne.w	EXN_Error
;		add.l	#$c+4,d7			*restlicher Header
;
;		moveq	#0,d0
;		move.b	3(a0),d0			;Offset zum nchsten
;		lsl.l	#8,d0				;File
;		move.b	2(a0),d0			;Offset zum nchsten
;		lsl.l	#8,d0				;File
;		move.b	1(a0),d0			;Offset zum nchsten
;		lsl.l	#8,d0				;File
;		move.b	(a0),d0
;		add.l	d0,d7		*d7=Offset vom Namenstart zum nchsten
;					*d5=gelesene Bytes
;		sub.w	d5,d7
;		move.l	d7,d2
;
;
;		moveq	#OFFSET_Current,d3
;		move.l	EPAI_Handle(a4),d1
;		move.l	Dosbase(a5),a6
;		jsr	_LVOSeek(a6)
;		bra.w	EXN_SeekTest
;
;*-----------------------------------------------------------------------------*
;* a0=Puffer
;* d3=Len
;*--------------------------
;* d4=Pos im gelesenen Puffer
;* d5=Alle geladenen Bytes
;.LeseBytes:	movem.l	d1-d3/d6-a6,-(a7)
;		move.l	a0,a1
;		move.l	d3,d6
;		tst.l	d5
;		beq.s	.ErstRead
;
;		move.l	d3,d1
;		moveq	#ReadSize,d0
;		sub.w	d4,d0			*Anz der verfgbaren Bytes
;		cmp.l	d3,d0
;		bhs.s	.ImPuffer
;
;		*-- Alle verfgbaren schon kopieren --*
;		sub	d0,d3
;		move.l	d0,d1			*Anz der noch zu kopierenden
;		lea	TextPuffer(a5),a0
;		lea	(a0,d4.w),a0
;		subq.l	#1,d1
;		bsr	CopyText
;
;.ErstRead:	move.l	d3,-(a7)
;		lea	TextPuffer(a5),a0
;		move.l	a0,d2
;		moveq	#0,d0
;		move.l	EPAI_Handle(a4),d1
;		beq.s	.Error
;		move.l	Dosbase(a5),a6
;		moveq	#ReadSize,d3
;		move.l	a1,-(a7)
;		jsr	_LVORead(a6)
;		move.l	(a7)+,a1
;		move.l	(a7)+,d1
;		cmp.l	#ReadSize,d0
;		bne.s	.Error2
;		add.l	d3,d5
;		moveq	#0,d4
;
;.ImPuffer:	lea	TextPuffer(a5),a0
;		lea	(a0,d4.w),a0
;		add.l	d1,d4
;		subq.l	#1,d1
;		bsr	CopyText
;		move.l	d6,d0
;.Error:		movem.l	(a7)+,d1-d3/d6-a6
;		tst.l	d0
;		rts
;
;.Error2:	moveq	#0,d0
;		bra.s	.Error
;


*------------------------------ Arj-Archive ----------------------------------*
ARJTest:	cmp.w	#$60ea,TextPuffer(a5)
		bne.s	.No
		moveq	#0,d1
		move.b	TextPuffer+3(a5),d1
		lsl.l	#8,d1
		move.b	TextPuffer+2(a5),d1
		cmp.w	#$22,d1
		blt.s	.No
		*and.l	#$2e41524a,d2
		*cmp.l	#".ARJ",d2
		*bne.w	.No
		moveq	#0,d0
.No		rts

	*----------- Arj-Archive-ExNext -----------*
ARJExNext:	move.l	EPAI_Handle(a4),d1
		beq.w	EXN_Error
		lea	TextPuffer(a5),a0
		clr.l	(a0)
		move.l	a0,d2
		moveq	#$22,d3				;FileHeader lesen
		move.l	Dosbase(a5),a6
		jsr	_LVORead(a6)
		cmp.l	#4,d0
		bls.w	EXN_NoMoreEntries			*Eintrge
		
		cmp.l	d3,d0				*--> Read Error
		bne.w	EXN_Error

		*-- RAR-Name lesen --*
	cmp.w	#$60ea,TextPuffer(a5)
	bne.w	EXN_Error
	moveq	#0,d3
	move.b	TextPuffer+3(a5),d3
	lsl.l	#8,d3
	move.b	TextPuffer+2(a5),d3
	sub.w	#$1f,d3
		move.l	EPAI_Handle(a4),d1
		cmp.w	d3,d6				*Puffer zu kurz
		blt.w	EXN_ErrorBuffer
		move.l	a3,d2
		move.l	Dosbase(a5),a6
		jsr	_LVORead(a6)			*Automatisch

		cmp.l	d3,d0				*nullterminiert
		bne.w	EXN_Error

		*---- SeekZeiger setzen ----*
		moveq	#0,d2
		tst.l	TextPuffer+$14(a5)
		beq.s	.OnlySeek
		move.b	TextPuffer+$13(a5),d2		;Offset zum CrStart
		lsl.l	#8,d2
		move.b	TextPuffer+$12(a5),d2
		lsl.l	#8,d2
		move.b	TextPuffer+$11(a5),d2
		lsl.l	#8,d2
		move.b	TextPuffer+$10(a5),d2
.OnlySeek:	add.l	#7,d2

		moveq	#OFFSET_Current,d3
		move.l	EPAI_Handle(a4),d1
		move.l	Dosbase(a5),a6
		jsr	_LVOSeek(a6)

		addq.l	#1,d0
		beq.w	EXN_NoMoreEntries
		cmp.l	#7,d2
		beq.w	ArjExNext
		moveq	#0,d0
		rts


*------------------------------- Ha-Archive ----------------------------------*
HaTest:		cmp.w	#"HA",TextPuffer(a5)
		bne.s	.No
		moveq	#0,d0
.No		rts


	*----------- Ha-Archive-ExNext -----------*
HAExNext:	subq.l	#1,d6
		*move.l	EPAI_Handle(a4),d1		*Fileheader laden
		*beq.w	EXN_Error
		*moveq	#0,d2
		*moveq	#OFFSET_Current,d3
		*move.l	Dosbase(a5),a6
		*jsr	_LVOSeek(a6)
		*move.l	d0,d6

		move.l	EPAI_Handle(a4),d1
		beq.w	EXN_Error
		lea	TextPuffer(a5),a0
		clr.l	(a0)
		move.l	a0,d2
		moveq	#$11,d3				;FileHeader lesen
		move.l	Dosbase(a5),a6
		jsr	_LVORead(a6)
		*cmp.l	#4,d0
		*bls.w	EXN_NoMoreEntries			*Eintrge
		tst.l	d0
		beq.w	EXN_NoMoreEntries
		cmp.l	d3,d0				*--> Read Error
		bne.w	EXN_Error

		move.l	a3,a2
		moveq	#0,d4				*Crunched size
		move.b	TextPuffer+$4(a5),d4
		lsl.l	#8,d4
		move.b	TextPuffer+$3(a5),d4
		lsl.l	#8,d4
		move.b	TextPuffer+$2(a5),d4
		lsl.l	#8,d4
		move.b	TextPuffer+$1(a5),d4

		*-- HA-Dirnamen lesen und danach Filenamen lesen --*
		*-- Problem: keine Lnge der Strings im Format   --*
		*-- angegeben. Folgt: Durchtesten.
		*-- Dirnamen endet mit FF00
		*-- Filenamen endet mit 00
		moveq	#0,d7				*Gelesene Bytes
		moveq	#0,d5
.RetryIt:	move.l	EPAI_Handle(a4),d1
		move.l	a3,a0
		move.l	a0,d2
		moveq	#30,d3
		add.l	d3,d7
		cmp.w	d3,d6				*Puffer zu kurz
		ble.w	EXN_ErrorBuffer
		clr.b	31(a3)
		jsr	_LVORead(a6)
		cmp.l	d0,d3				*das drfte eigentlich
		bne.w	EXN_NoMOreEntries		*nicht passieren ?
							*Dann fehlt eben einer
		sub.w	#30,d6

		subq.l	#1,d3
.RetryFindIt:	move.l	a3,a0
.FindIt:	addq.l	#1,d5
		tst.b	(a0)+
		beq.s	.JAaa
		dbf	d3,.FindIt

		lea	30(a3),a3
		bra.s	.RetryIt

		*---- Dir oder Filename gefunden ----*
.JAaa:		cmp.l	#1,d5			*Kein Dirname
		beq.s	.KeinDirName
		cmp.b	#$ff,-2(a0)
		bne.s	.Filename
		cmp.l	#1,d5			*Kein Dirname
		beq.s	.FileName
		clr.b	-2(a0)
		move.b	TextPuffer+$10(a5),d0	*wenn kein Dirname, ist $10(a5)
		cmp.b	-3(a0),d0		*=$31 und -3(a0) auch
		beq.s	.RetryIt2		*Kein Dirname !!
		cmp.b	#":",-3(a0)
		beq.s	.RetryIt2
		move.b	#"/",-2(a0)
		addq.l	#1,a0
.RetryIt2:	lea	-1(a0),a3		*Filename an Dirname laden
		bra.s	.RetryFindIt


	*--- Filename zusammenkopieren ---*
.KeinDirName:	bsr	BerechStringSize
		addq.l	#1,d0
		add.l	d0,d5
		lea	(a0,d0.w),a0
.Filename:	moveq	#0,d2
		move.b	(a0),d2			*Lnge des PCTypePuffers

		move.l	a2,a0
		bsr	BerechStringSize
		lea	(a2,d0.w),a1
		lea	1(a1),a0
		tst.b	(a0)
		bne.s	.SchonDa
		addq.l	#1,a0
.SchonDa:	moveq	#31,d1
		bsr	StringCopy

		subq.w	#1,d3
		bgt.s	.NoRead1
		moveq	#1,d3
		lea	TextPuffer(a5),a0
		move.l	a0,d2
		jsr	_LVORead(a6)
		addq.l	#1,d7
		moveq	#0,d2
		move.b	TextPuffer(a5),d2	*Lnge des Computertypheaders
.NoRead1:	add.l	d4,d2			*Crunchsize
					*D2 ist jetzt der rel Ptr vom Namenstart
					*in d7 = gelesene Bytes ab Header
		add.l	d5,d2
		addq.l	#1,d2
		sub.l	d7,d2
		moveq	#OFFSET_Current,d3
		move.l	EPAI_Handle(a4),d1
		move.l	Dosbase(a5),a6
		jsr	_LVOSeek(a6)
		bra.w	EXN_SeekTest


*-----------------------------------------------------------------------------*
LHATest:	lea	TextPuffer(a5),a0
		cmp.w	#"-l",2(a0)
		bne.w	.No
		move.w	4(a0),d2
		cmp.w	#"zh",d2			;??? stimmt das ?
		beq.w	.Found2
		and.w	#$fff8,d2
		cmp.w	#"h0",d2
		bne.w	.No
.Found2:	cmp.b	#"-",6(a0)
		bne.w	.No
		moveq	#0,d0
.No:		rts

LHAExNext:	move.l	EPAI_Handle(a4),d1
		beq.w	EXN_Error
		lea	TextPuffer(a5),a0
		clr.l	(a0)
		move.l	a0,d2
		moveq	#22,d3				;FileHeader lesen
		move.l	Dosbase(a5),a6
		jsr	_LVORead(a6)
		cmp.l	#1,d0
		bne.s	.LHA_TestD0D3
		tst.b	TextPuffer(a5)			*--> keine weiteren
		beq.w	EXN_NoMoreEntries		*Eintrge
.LHA_TestD0D3:	cmp.l	d3,d0				*--> Read Error
		bne.w	EXN_Error

		*-- Testen. ob LHA-Kennung vorhanden ist -*
		lea	TextPuffer(a5),a0
		tst.l	(a0)
		beq.w	EXN_NoMoreEntries
		cmp.w	#"-l",2(a0)
		bne.w	EXN_Error
		move.w	4(a0),d0
		cmp.w	#"zh",d0			;??? stimmt das ?
		beq.w	.LHA_ZHFound
		and.w	#$fff8,d0
		cmp.w	#"h0",d0
		bne.w	EXN_Error
.LHA_ZHFound:	cmp.b	#"-",6(a0)
		bne.w	EXN_Error

		*-- Name lesen --*
		moveq	#0,d3
		move.b	TextPuffer(a5),d3		;=0 -> Ende
		beq.w	EXN_NoMoreEntries
		sub.w	#22,d3				;Lnge des Namens
		blt.w	EXN_Error
		move.l	EPAI_Handle(a4),d1
		beq.w	EXN_Error

		moveq	#0,d4
		move.b	Textpuffer+21(a5),d4		;Lnge des Namens
		cmp.w	d4,d6				*Puffer zu kurz
		blt.w	EXN_ErrorBuffer

		clr.b	(a3,d3.w)			;Am Ende eine NULL
		move.l	a3,d2
		move.l	Dosbase(a5),a6
		jsr	_LVORead(a6)
		cmp.l	d3,d0
		bne.w	EXN_Error
		clr.b	(a3,d4.w)			;Null ans Ende setzen


		*------ Zeiger auf nchsten Eintrag setzen -----*
		move.l	EPAI_Handle(a4),d1		;Handle
		moveq	#0,d2
		move.b	TextPuffer+10(a5),d2		;Offset zum nchsten
		lsl.l	#8,d2				;File
		move.b	TextPuffer+9(a5),d2		;Offset zum nchsten
		lsl.l	#8,d2				;File
		move.b	TextPuffer+8(a5),d2		;Offset zum nchsten
		lsl.l	#8,d2				;File
		move.b	TextPuffer+7(a5),d2
		addq.l	#2,d2
		moveq	#0,d3				;Mode
		move.l	Dosbase(a5),a6
		jsr	_LVOSeek(a6)
		bra.w	EXN_SeekTest


*------------------------------- LZX-Archive ---------------------------------*
LZXTest:	move.l	TextPuffer(a5),d2
		lsr.l	#8,d2
		cmp.l	#"LZX",d2
		bne.s	.No
		moveq	#0,d0
.No:		rts

LZXExNext:	move.l	EPAI_Handle(a4),d1
		beq.w	EXN_Error
		lea	TextPuffer(a5),a0
		clr.l	(a0)
		move.l	a0,d2
		moveq	#$1f,d3				;FileHeader lesen
		move.l	Dosbase(a5),a6
		jsr	_LVORead(a6)
		tst.l	d0
		beq.w	EXN_NoMoreEntries			*Eintrge
		cmp.l	d3,d0				*--> Read Error
		bne.w	EXN_Error

		*-- LZX-Name lesen --*
		moveq	#0,d3
		move.b	TextPuffer+$1e(a5),d3		;Namensize
		beq.w	EXN_NoMoreEntries
		move.l	EPAI_Handle(a4),d1
		cmp.w	d3,d6				*Puffer zu kurz
		blt.w	EXN_ErrorBuffer
		move.l	a3,d2
		move.l	Dosbase(a5),a6
		jsr	_LVORead(a6)
		cmp.l	d3,d0
		bne.w	EXN_Error
		clr.b	(a3,d3.w)			;Null ans Ende setzen

		*---- SeekZeiger setzen ----*
		moveq	#0,d1
		move.b	TextPuffer+14(a5),d1		*Commentsize
		moveq	#0,d2
		move.b	TextPuffer+9(a5),d2		;Offset zum nchsten
		lsl.l	#8,d2				;File
		move.b	TextPuffer+8(a5),d2		;Offset zum nchsten
		lsl.l	#8,d2				;File
		move.b	TextPuffer+7(a5),d2		;Offset zum nchsten
		lsl.l	#8,d2				;File
		move.b	TextPuffer+6(a5),d2
		add.l	d1,d2				*Offset vom Namenende
		beq.w	EXN_AllesOk
		moveq	#0,d3
		move.l	EPAI_Handle(a4),d1
		move.l	Dosbase(a5),a6
		jsr	_LVOSeek(a6)
		bra.w	EXN_SeekTest

*------------------------------ Rar-Archive ----------------------------------*
RARTest:	move.l	TextPuffer(a5),d2
		cmp.l	#"Rar!",d2
		bne.w	.No
		moveq	#0,d0
.No		rts

RARExNext:	clr.b	(a3)				*erstmal NullSetzen
		move.l	EPAI_Handle(a4),d1
		beq.w	EXN_Error
		lea	TextPuffer(a5),a0
		clr.l	(a0)
		move.l	a0,d2
		moveq	#$20,d3				;FileHeader lesen
		move.l	Dosbase(a5),a6
		jsr	_LVORead(a6)
		tst.l	d0
		beq.w	EXN_NoMoreEntries		*Eintrge
		cmp.l	d3,d0				*--> Read Error
		bne.w	EXN_Error

		*-- RAR-Name lesen --*
		moveq	#0,d3
		move.b	TextPuffer+$1a(a5),d3		;Namensize
		beq.w	EXN_NoMoreEntries
		move.l	EPAI_Handle(a4),d1
		cmp.w	d3,d6				*Puffer zu kurz
		blt.w	EXN_ErrorBuffer
		move.l	a3,d2
		move.l	Dosbase(a5),a6
		jsr	_LVORead(a6)
		cmp.l	d3,d0
		bne.w	EXN_Error
		clr.b	(a3,d3.w)			;Null ans Ende setzen

		*---- SeekZeiger setzen ----*
		moveq	#0,d1
	*	move.b	TextPuffer+$1b(a5),d1		*Commentsize ???
		moveq	#0,d2
		move.b	TextPuffer+10(a5),d2		;Offset zum nchsten
		lsl.l	#8,d2				;File
		move.b	TextPuffer+9(a5),d2		;Offset zum nchsten
		lsl.l	#8,d2				;File
		move.b	TextPuffer+8(a5),d2		;Offset zum nchsten
		lsl.l	#8,d2				;File
		move.b	TextPuffer+7(a5),d2
		add.l	d1,d2				*Offset vom Namenende
		beq.w	EXN_AllesOk
		moveq	#0,d3
		move.l	EPAI_Handle(a4),d1
		move.l	Dosbase(a5),a6
		jsr	_LVOSeek(a6)
		bra.w	EXN_SeekTest


*------------------------------ Shrink-Archive -------------------------------*
SHRTest:	move.l	TextPuffer(a5),d2
		cmp.l	#"FORM",d2
		bne.w	.No
		cmp.l	#"CDAF",TextPuffer+8(a5)
		bne.w	.No
		cmp.l	#"shri",TextPuffer+$14(a5)
		bne.w	.No
		moveq	#0,d0
.No:		rts


ShrExNext:	move.l	EPAI_Handle(a4),d1
		beq.w	EXN_Error
		lea	TextPuffer(a5),a0
		clr.l	(a0)
		move.l	a0,d2
		moveq	#$1e,d3				;FileHeader lesen
		move.l	Dosbase(a5),a6
		jsr	_LVORead(a6)
		tst.l	d0
		beq.w	EXN_NoMoreEntries			*Eintrge
		cmp.l	d3,d0				*--> Read Error
		bne.w	EXN_Error
		cmp.l	#"FILE",TextPuffer(a5)
		bne.w	EXN_Error

		*-- Shrink-Name lesen --*
		move.l	TextPuffer+4(a5),d3		;Headersize
		sub.w	#13,d3
		bclr	#0,d3 *Wordaligned  -16=Namensize +8 Bodyinfo
		tst.l	d3
		beq.w	EXN_NoMoreEntries

		cmp.w	d3,d6				*Puffer zu kurz
		blt.w	EXN_ErrorBuffer

		move.l	EPAI_Handle(a4),d1
		cmp.w	d3,d6				*Puffer zu kurz
		blt.w	EXN_ErrorBuffer
		move.l	a3,d2
		move.l	Dosbase(a5),a6
		jsr	_LVORead(a6)
		cmp.l	d3,d0
		bne.w	EXN_Error

		cmp.l	#"NOTE",-8(a3,d3.w)
		bne.s	.ShrNoComment
		lea	-8(a3,d3.w),a0
		move.l	d3,d5
		move.l	a0,d4
		move.l	EPAI_Handle(a4),d1
		move.l	-4(a3,d3.w),d2
		addq.l	#1,d2
		bclr	#0,d2
		moveq	#0,d3
		jsr	_LVOSeek(a6)
		addq.l	#1,d0
		beq.w	EXN_Error
		move.l	d4,d2
		move.l	EPAI_Handle(a4),d1
		moveq	#8,d3
		jsr	_LVORead(a6)
		cmp.l	#8,d0
		bne.w	EXN_Error
		move.l	d5,d3

		*---- SeekZeiger setzen ----*
.ShrNoComment:	*cmp.l	#"BODY",-8(a3)
		*bne.s	EXN_Error
		lea	-4(a3),a0
		moveq	#0,d2
		move.b	(a0,d3.w),d2
		lsl.l	#8,d2
		move.b	1(a0,d3.w),d2
		lsl.l	#8,d2
		move.b	2(a0,d3.w),d2
		lsl.l	#8,d2
		move.b	3(a0,d3.w),d2
		addq.l	#1,d2
		bclr	#0,d2
		tst.l	d2
		blt.w	EXN_AllesOk

		clr.b	-8(a3,d3.w)			;Null ans Ende setzen
		moveq	#0,d3
		move.l	EPAI_Handle(a4),d1
		move.l	Dosbase(a5),a6
		jsr	_LVOSeek(a6)
		bra.w	EXN_SeekTest


**------------------------------ SQZ-Archive ----------------------------------*
*SQZTest:	move.l	TextPuffer(a5),d2
*		cmp.l	#"HLSQ",d2
*		bne.w	.No
*		moveq	#0,d0
*.No		rts
*
*SQZExNext:	moveq	#-1,d0
*		rts

**------------------------------- Tar-Archive ---------------------------------*
*TarTest:	rts
*
*TarExNext:	moveq	#-1,d0
*		rts
*

*------------------------------ ZIP-Archive ----------------------------------*
ZIPTest:	move.w	TextPuffer(a5),d2
		cmp.w	#"PK",d2
		bne.w	.No
		moveq	#0,d0
.No:		rts

	*----------- ZIP-Archive-ExNext -----------*
ZIPExNext:	move.l	EPAI_Handle(a4),d1
		beq.w	EXN_Error
		lea	TextPuffer(a5),a0
		clr.l	(a0)
		move.l	a0,d2
		moveq	#$1e,d3				;FileHeader lesen
		move.l	Dosbase(a5),a6
		jsr	_LVORead(a6)
		tst.l	d0
		beq.w	EXN_NoMoreEntries			*Eintrge
		cmp.l	d3,d0				*--> Read Error
		bne.w	EXN_Error

		*-- Zip-Name lesen --*
		cmp.w	#"PK",TextPuffer(a5)
		bne.w	EXN_Error
		moveq	#0,d3
		move.b	TextPuffer+$1a(a5),d3		;Namensize
		beq.w	EXN_NoMoreEntries
		move.l	EPAI_Handle(a4),d1
		cmp.w	d3,d6				*Puffer zu kurz
		blt.w	EXN_ErrorBuffer
		move.l	a3,d2
		move.l	Dosbase(a5),a6
		jsr	_LVORead(a6)
		cmp.l	d3,d0
		bne.w	EXN_Error
		clr.b	(a3,d3.w)			;Null ans Ende setzen

		*---- SeekZeiger setzen ----*
		moveq	#0,d1
	*	move.b	TextPuffer+$1b(a5),d1		*Commentsize ???
		moveq	#0,d2
		move.b	TextPuffer+$15(a5),d2		;Offset zum nchsten
		lsl.l	#8,d2				;File
		move.b	TextPuffer+$14(a5),d2		;Offset zum nchsten
		lsl.l	#8,d2				;File
		move.b	TextPuffer+$13(a5),d2		;Offset zum nchsten
		lsl.l	#8,d2				;File
		move.b	TextPuffer+$12(a5),d2
		add.l	d1,d2				*Offset vom Namenende
		beq.w	EXN_AllesOk
		moveq	#0,d3
		move.l	EPAI_Handle(a4),d1
		move.l	Dosbase(a5),a6
		jsr	_LVOSeek(a6)
		bra.w	EXN_SeekTest


*------------------------------ Zoo-Archive ----------------------------------*
ZooTest:	move.l	TextPuffer(a5),d2
		lsr.l	#8,d2
		cmp.l	#"ZOO",d2
		bne.w	.No
		moveq	#0,d0
.No:		rts

	*----------- Zoo-Archive-ExNext -----------*
ZOOExNext:	move.l	EPAI_Handle(a4),d1
		beq.w	EXN_Error
		lea	TextPuffer(a5),a0
		clr.l	(a0)
		move.l	a0,d2
		moveq	#$26,d3				;FileHeader lesen
		move.l	Dosbase(a5),a6
		jsr	_LVORead(a6)
		tst.l	d0
		beq.w	EXN_NoMoreEntries			*Eintrge
		cmp.l	d3,d0				*--> Read Error
		bne.w	EXN_Error

		*-- Zoo-Name lesen --*
	cmp.l	#$dca7c4fd,TextPuffer(a5)
	bne.w	EXN_Error
		moveq	#30,d3
		move.l	EPAI_Handle(a4),d1
		cmp.w	d3,d6				*Puffer zu kurz
		blt.w	EXN_ErrorBuffer
		move.l	a3,d2
		move.l	Dosbase(a5),a6
		jsr	_LVORead(a6)			*Automatisch
		tst.b	(a3)
		bne.s	.NormalTest
		cmp.l	d3,d0
		bne.w	EXN_NoMoreEntries

.NormalTest:	cmp.l	d3,d0				*nullterminiert
		bne.w	EXN_Error

		*---- SeekZeiger setzen ----*
		moveq	#0,d2
		move.b	TextPuffer+$d(a5),d2		;Offset zum CrStart
		lsl.l	#8,d2
		move.b	TextPuffer+$c(a5),d2
		lsl.l	#8,d2
		move.b	TextPuffer+$b(a5),d2
		lsl.l	#8,d2
		move.b	TextPuffer+$a(a5),d2

		moveq	#0,d1
		move.b	TextPuffer+$1b(a5),d1		;Crunchsize
		lsl.l	#8,d1
		move.b	TextPuffer+$1a(a5),d1
		lsl.l	#8,d1
		move.b	TextPuffer+$19(a5),d1
		lsl.l	#8,d1
		move.b	TextPuffer+$18(a5),d1

		add.l	d1,d2				*Offset vom Namenende
		beq.w	.NullInfo

		moveq	#OFFSET_BEGINNING,d3
		move.l	EPAI_Handle(a4),d1
		move.l	Dosbase(a5),a6
		jsr	_LVOSeek(a6)
		bra.w	EXN_SeekTest

.NUllInfo:	moveq	#-$c,d2
		moveq	#OFFSET_Current,d3
		move.l	EPAI_Handle(a4),d1
		move.l	Dosbase(a5),a6
		jsr	_LVOSeek(a6)
		addq.l	#1,d0
		bne.w	ZOOExNext
		bra.w	EXN_AllesOk


* %1 = Name des Archives						      *
* %2 = Name des Entries							      *
* %3 = DestPfad								      *

*-----------------------------------------------------------------------------*
*Arc.MSG		dc.b	"Arc",0
*ARCSuffix	dc.b	".arc",0
*ARCDefPfad	dc.b	"Arc",0
*ARCDefOptions	dc.b	'x "%1" "%2" "T:"',0

*-----------------------------------------------------------------------------*
ARJ.MSG		dc.b	"Arj",0
ARJSuffix	dc.b	".arj",0
ARJDefPfad	dc.b	"Arj",0
ARJDefOptions	dc.b	'x "%1" "%2" "%3"',0

*-----------------------------------------------------------------------------*
HA.MSG		dc.b	"Ha",0
HASuffix	dc.b	".ha",0
HADefPfad	dc.b	"Ha",0
HADefOptions	dc.b	'e "%1" "%2"',0

*-----------------------------------------------------------------------------*
LHA.MSG		dc.b	"Lha",0
LHASuffix	dc.b	".LHA",0
LHADefPfad	dc.b	"LHA",0
LHADefOptions	dc.b	'-N e "%1" "%2" "%3"',0

*-----------------------------------------------------------------------------*
LhArc.MSG	dc.b	"LhArc",0
LhArcSuffix	dc.b	".LZH",0
LhArcDefPfad	dc.b	"LHA",0
LhArcDefOptions	dc.b	'-N e "%1" "%2" "%3"',0

*-----------------------------------------------------------------------------*
LZX.MSG		dc.b	"Lzx",0
LZXSuffix	dc.b	".LZX",0
LZXDefPfad	dc.b	"LZX",0
LZXDefOptions	dc.b	'x "%1" "%2" "%3"',0

*-----------------------------------------------------------------------------*
RAR.MSG		dc.b	"Rar",0
RARSuffix	dc.b	".rar",0
RARDefPfad	dc.b	"UnRar",0
RARDefOptions	dc.b	'e "%1" "%2"',0

*-----------------------------------------------------------------------------*
SHR.MSG		dc.b	"Shrink",0
SHRSuffix	dc.b	".Shr",0
SHRDefPfad	dc.b	"Shrink",0
SHRDefOptions	dc.b	'x "%1" "%3" "%2"',0

*-----------------------------------------------------------------------------*
*SQZ.MSG		dc.b	"Squeeze It",0
*SQZSuffix	dc.b	".SQZ",0
*SQZDefPfad	dc.b	"UnSqueeze",0
*SQZDefOptions	dc.b	'x "%s" "%s" "T:"',0

*-----------------------------------------------------------------------------*
*TAR.MSG		dc.b	"Tar",0
*TARSuffix	dc.b	".tar",0
*TARDefPfad	dc.b	"TarSplitt",0
*TARDefOptions	dc.b	'x "%s" "%s" "T:"',0

*-----------------------------------------------------------------------------*
ZIP.MSG		dc.b	"Zip",0
ZIPSuffix	dc.b	".Zip",0
ZIPDefPfad	dc.b	"Unzip",0
ZIPDefOptions	dc.b	'-x -o "%1" "%2"',0

*-----------------------------------------------------------------------------*
ZOO.MSG		dc.b	"Zoo",0
ZooSuffix	dc.b	".zoo",0
ZooDefPfad	dc.b	"zoo",0
ZooDefOptions	dc.b	'-e "%1" "%2"',0


*-----------------------------------------------------------------------------*

		SECTION	BSSMErkPuffer,BSS
Puffer		ds.b	PufferEnd


		if	test
		if	extractortest
		SECTION	Archivenamen,Data

Archivename:

	;dc.b	"modules:__ Problemflle __/CruncherTests/Amiga_Modules.lha",0
	;dc.b	"modules:__ Problemflle __/CruncherTests/Amiga_Modules.lzx",0
	;dc.b	"modules:__ Problemflle __/CruncherTests/Amiga_Modules.shr",0
	;dc.b	"modules:__ Problemflle __/CruncherTests/Amiga_Modules.tar",0
	;dc.b	"modules:__ Problemflle __/CruncherTests/PC_Files.arj",0
	;dc.b	"modules:__ Problemflle __/CruncherTests/PC_Files.rar",0
	;dc.b	"modules:__ Problemflle __/CruncherTests/PC_Files2.rar",0
	;dc.b	"modules:__ Problemflle __/CruncherTests/PC_Modules.arc",0
	;dc.b	"modules:__ Problemflle __/CruncherTests/PC_Modules.arj",0
	;dc.b	"modules:__ Problemflle __/CruncherTests/PC_Modules.kom",0
	;dc.b	"modules:__ Problemflle __/CruncherTests/PC_Modules.lha",0
	;dc.b	"modules:__ Problemflle __/CruncherTests/PC_Modules.lzh",0
	;dc.b	"modules:__ Problemflle __/CruncherTests/PC_Modules.rar",0
	;dc.b	"modules:__ Problemflle __/CruncherTests/PC_Modules.sqz",0
	;dc.b	"modules:__ Problemflle __/CruncherTests/PC_Modules.zip",0
	;dc.b	"modules:__ Problemflle __/CruncherTests/PC_Modules.zoo",0
	;dc.b	"modules:hatest.ha",0
	;dc.b	"modules:hatest.ha",0
	;dc.b	"modules:atargatis.lzh",0
	dc.b	"modules:corehard.lha",0
	;dc.b	"modules:test2.ha",0
	;dc.b	"modules:arctest.arc",0
	;dc.b	"modules:zootest.zoo",0

ArchiveEntryname
		*dc.b	"Agnostic.mod",0
		*dc.b	"Agnostic.mtm",0
		*dc.b	"Agnostic.xm",0		;pc.lha|pc.rar|pc.zip|pc.zoo
		dc.b	"test/Di.nightmare",0
		*dc.b	"dir",0			*Zoo
		dc.b	"AllocAbs",0		*Ha|Arc


		endc
		endc
