*****************************************************************************
**                                                                         **
** Eagleripper: AIFF                                                       **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 


*-----------------------------------------------------------------------------*
*			     Eagleripper V1.0				      *
*				AIFF					      *
*-----------------------------------------------------------------------------*
Test	= 0
		incdir	include:
		include	misc/eagleplayerripper.i
		include	exec/exec_lib.i
			
	if	Test
	lea	data,a0
	*lea	AIFF8SVXTags,a0
	move.l	#datasize,d0
	move.l	a0,a5
	move.l	a0,a4
	move.l	d0,d4
	move.l	d0,d6
wait:	move.l	a5,a1
	move.l	a4,a0
	move.l	d4,d0
	move.l	(a1),d1
	*bsr	AIFFRipp1
	bsr	AIFCRipp1
	tst.l	d0
	beq.s	.Ja
	addq.l	#2,a5
	subq.l	#2,d6
	blt.s	.Err
	btst	#6,$bfe001
	bne.s	wait
.err:	moveq	#-1,d0
.ret:	illegal

.ja:	move.l	d1,d0
	bsr	GetModuleName
	bra.s	.Ret
	endc
		RIPPERHEADER	AIFF8SVXTags

	dc.b	"Eagleripper-AIFF-Sampleripper (AIFF, AIFC...) V1.0",10
	dc.b	"done by Eagleeye/DFT 28.08.97",0
	even

AIFF8SVXTags:	dc.l	RPT_Formatname,.Formatname
		dc.l	RPT_Ripp1,AIFFRipp1
		dc.l	RPT_RequestRipper,1
		dc.l	RPT_Version,1<<16!0
		dc.l	RPT_Creator,.Creator
		dc.l	RPT_GetModuleName,GetModuleName
		dc.l	RPT_Playername,.Playername
		dc.l	RPT_Prefix,.Prefix
		dc.l	RPT_Next,AIFCTags
		dc.l	0

.Creator:	dc.b	"???, adapted by DEFECT",0
.Playername:
.Formatname:	dc.b	"AIFF",0
.Prefix:	dc.b	"AIFF.",0
		even

AIFCTags:	dc.l	RPT_Formatname,.Formatname
		dc.l	RPT_Ripp1,AIFCRipp1
		dc.l	RPT_RequestRipper,1
		dc.l	RPT_Version,1<<16!0
		dc.l	RPT_Creator,.Creator
		dc.l	RPT_GetModuleName,GetModuleName
		dc.l	RPT_Playername,.Playername
		dc.l	RPT_Prefix,.Prefix
		dc.l	0

.Creator:	dc.b	"???, adapted by DEFECT",0
.Playername:	dc.b	"AIFF",0
.Formatname:	dc.b	"AIFC",0
.Prefix:	dc.b	"AIFC.",0
		even

*-----------------------------------------------------------------------------*
* Input: a0=Adr (start of memory)
*	 d0=Size (size of memory)
*	 a1=current adr
*	 d1=(a1.l)
* Output:d0=Error oder NULL
*	 d1=Size
*	 a0=Startadr (data)
*-----------------------------------------------------------------------------*
AIFFRipp1:	cmp.l	#"FORM",d1
		beq.s	.Ja
		rts

		*--- Jetzt testen, ob es ein AIFF-Sample sein kann ---*
.Ja:		move.l	a1,-(a7)
		add.l	d0,a0
		sub.l	a1,a0
		move.l	a0,d1			->> max. Size
		move.l	(a7)+,a0		;Startadr

		subq.l	#6,d1
		*subq.l	#8,d1		;haut bei vielen Files nicht hin !!!

		move.l	4(a1),d0
		cmp.l	d0,d1
		blo.s	.Error
		addq.l	#8,a1
		subq.l	#4,d1

		move.l	(a1)+,d0
		cmp.l	#"AIFF",d0
		bne.s	.Error

		*--- Chunks durchtesten ---*
.NextChunk:	move.l	(a1)+,d0
		move.l	(a1)+,d2
		addq.l	#1,d2
		bclr	#0,d2
		cmp.l	#4,d2
		blt.s	.Error
		subq.l	#8,d1
		cmp.l	d2,d1
		blo.s	.Error
		bsr	CheckChunkName
		bne.s	.Error
		move.l	-8(a1),d0
		lea	(a1,d2.l),a1
		sub.l	d2,d1
		cmp.l	#"SSND",d0
		beq.s	.Fertig
		bra.s	.NextChunk

.Fertig:	*move.l	a1,d1
		*sub.l	a0,d1
		move.l	4(a0),d1

		*addq.l	#6,d1
		addq.l	#8,d1		;haut bei vielen Files nicht hin !!!

		moveq	#0,d0
.Return:	rts
.Error:		moveq	#-1,d0
		rts

*-----------------------------------------------------------------------------*
* Input: a0=Adr (start of memory)
*	 d0=Size (size of memory)
*	 a1=current adr
*	 d1=(a1.l)
* Output:d0=Error oder NULL
*	 d1=Size
*	 a0=Startadr (data)
*-----------------------------------------------------------------------------*
AIFCRipp1:	cmp.l	#"FORM",d1
		beq.s	.Ja
		rts

		*--- Jetzt testen, ob es ein AIFF-Sample sein kann ---*
.Ja:		move.l	a1,-(a7)
		add.l	d0,a0
		sub.l	a1,a0
		move.l	a0,d1			->> max. Size
		move.l	(a7)+,a0		;Startadr

		subq.l	#6,d1
		*subq.l	#8,d1		;haut bei vielen Files nicht hin !!!

		move.l	4(a1),d0
		cmp.l	d0,d1
		blo.s	.Error
		addq.l	#8,a1
		subq.l	#4,d1

		move.l	(a1)+,d0
		cmp.l	#"AIFC",d0
		bne.s	.Error

		*--- Chunks durchtesten ---*
.NextChunk:	move.l	(a1)+,d0
		move.l	(a1)+,d2
		addq.l	#1,d2
		bclr	#0,d2
		cmp.l	#4,d2
		blt.s	.Error
		subq.l	#8,d1
		cmp.l	d2,d1
		blo.s	.Error
		bsr	CheckChunkName
		bne.s	.Error
		move.l	-8(a1),d0
		lea	(a1,d2.l),a1
		sub.l	d2,d1
		cmp.l	#"SSND",d0
		beq.s	.Fertig
		bra.s	.NextChunk

.Fertig:	*move.l	a1,d1
		*sub.l	a0,d1
		move.l	4(a0),d1

		*addq.l	#6,d1
		addq.l	#8,d1		;haut bei vielen Files nicht hin !!!

		moveq	#0,d0
.Return:	rts
.Error:		moveq	#-1,d0
		rts

*-----------------------------------------------------------------------------*
CheckChunkName:	movem.l	d1/d2,-(a7)
		move.l	d0,d1
		moveq	#3,d2
.NextByte:	cmp.b	#" ",d1
		blo.s	.Return
		cmp.b	#"z",d1
		bhi.s	.Return
		lsr.l	#8,d1
		dbf	d2,.NextByte
		moveq	#0,d0
.Return:	movem.l	(a7)+,d1/d2
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
* Input: a0=Start of Modul
*	 d0=Size
* Output:d0=Ptr to name or NULL
*-----------------------------------------------------------------------------*
GetModuleName:	move.l	a2,-(a7)
		move.l	a0,a2
		move.l	a0,a1
		move.l	(a1),d1
		move.l	d0,d3
		bsr	AIFFRipp1
		beq.s	.Ja
		move.l	d3,d0
		bsr	AIFCRipp1
		bne.s	.Error
.Ja

		*--- Name-Hunk finden ---*
		lea	12(a2),a2
.NextHunk:	move.l	(a2)+,d0
		move.l	(a2)+,d1
		cmp.l	#"SSND",d0
		beq.s	.Error
		cmp.l	#"NAME",d0
		beq.s	.NameFound
		lea	(a2,d1.l),a2
		bra.s	.NextHunk
.Error:		sub.l	a2,a2
.NameFound:	move.l	a2,d0		
		move.l	(a7)+,a2
		rts


	if	test
data:		incdir	"Modules:ADPCM-IFF-MPEG-Wave/"
		*ds.b	200

		incbin	AIFC.Dark
		*incbin	AIFF.Brother
		*incbin	AIFF.Dark
		*incbin	AIFF.HS_Plastic_Fantastic



		*incdir	"Modules:Verschiedenes/"
		*incbin	"BD.Motorhead 1"
		*incbin	"BD.Motorhead 2"
		*incbin	"BD.Motorhead 3"

		*incdir	modules:smus/
		*incbin	smus.painterman




datasize	= *-data
	endc
