*****************************************************************************
**                                                                         **
** Engine: Eagleripper                                                     **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 

*******************************************************************************
******									*******
******			Engine by Eagleeye & Buggs of DEFECT		*******
******									*******
*******************************************************************************
*## PASS3 ist bersichtlichkeit fr den User erstmal disabled, funzt aber!
*## nur Ptr im Menu richtig setzen !!!
Executable	= 1

		incdir	include:
		include	"misc/eagleplayer.i"
		include	"misc/eagleplayerengine.i"
		include	"misc/eagleplayerripper.i"
		include	"exec/exec_lib.i"
		include	"dos/dos_lib.i"
		include	"dos/dos.i"
		include	"libraries/reqtools.i"
		include	"libraries/reqtools_lib.i"


ver		macro
		dc.b	"1.01"
		endm
StructVer	macro
		dc.w	1,01
		endm
date		macro
		dc.b	"10-Feb-01"
		endm
StructDate	macro
		dc.b	10,02
		dc.w	2001
		endm



*--------------------------------- Rippmodi ----------------------------------*
Pass1			EQU	0	\
Pass2			EQU	1	 > Rippmodi & Bitnr fr Prefs
Pass3			EQU	2	/
SecurityMode		EQU	3	-> Bitnummer fr Prefsflags


NamePufferSize		EQU	MaxFilenameSize
DisplayGenauigkeit	EQU	100
Schrittweite		EQU	2			;word

*-----------------------------------------------------------------------------*
ERPSS_PassTable		EQU	ERPSS_Private1		*private for Ripper
ERPSS_PassTableSize	EQU	ERPSS_Private2		*private for Ripper
ERPSS_CurrentMode	EQU	ERPSS_Private3		*private for Ripper

PassMemDrauf		EQU	8			;mindestens 4 !!!!!

*---------------------------- Nummern frs PDMenu ----------------------------*
EPNr_Er_Barlabel	EQU	EPNr_FirstExternal
EPNr_Er_Pass1		EQU	EPNr_FirstExternal+1
EPNr_Er_Pass2		EQU	EPNr_FirstExternal+2
EPNr_Er_Pass3		EQU	EPNr_FirstExternal+3
EPNr_Er_Barlabel2	EQU	EPNr_FirstExternal+4
EPNr_Er_SecurityMode	EQU	EPNr_FirstExternal+5

*-----------------------------------------------------------------------------*

 STRUCTURE ER_Ripper,0
	APTR	ER_Next
	ULONG	ER_Segment
	LONG	ER_StructSize
	APTR	ER_Tags
	APTR	ER_Rippername
	LABEL	ER_SizeOF

		rsreset
		rs.b	EPG_SizeOF
FirstRipper	rs.l	1
Ripperloaded 	rs.w	1
HunkSize	rs.l	1
DisplayArgs	rs.l	1
Filename	rs.l	1
TextArgs	rs.l	3
MyRipperstruct	rs.b	ERPSS_SizeOF
PathPuffer	rs.b	MaxDirectorynamesize+2
NamePuffer	rs.b	NamePufferSize+2
PufferEnd	rs.b	0


*-----------------------------------------------------------------------------*
*-----				Start Programm				------*
*-----------------------------------------------------------------------------*
;UserStartPrg

		ifeq	executable
		bsr	InitEngine
		lea	data,a0
		move.l	#datasize,d0
		bsr	Rippen
		bsr	RippenCont
		bsr	ExitEngine
	*lea	NamePuffer(a5),a0
.Ende:		illegal
		endc

EUS_Structure:	moveq	#-1,d0				;EUS_Jump
		rts
		EUSN_Identifier				;EUS_Identifier
		dc.l	0				;EUS_Next
		dc.w	0				;EUS_Usernr
		dc.l	0				;EUS_EPBase
		dc.l	0				;EUS_FreeTable
		dc.l	0				;EUS_TaskAdr = NULL
		dc.l	0				;EUS_UnUsed1
		dc.l	0				;EUS_UnUsed2
		dc.l	0				;EUS_UnUsed3
		dc.l	TagListe			;EUS_Taglist
		dc.w	0				;EUS_Ticks
		dc.w	0				;EUS_TickCounter
		dc.l	0				;EUS_TickFlags
		dc.l	0				;EUS_MsgFlags
		dc.l	MyCreatorname			;EUS_PName
		dc.l	MyCreatorname			;EUS_Creator
		dc.l	MySpecialInfo			;EUS_AboutUPRG
		dc.w	37				;EUS_Kickstart
		dc.l	11				;EUS_EPVersion
		StructVer				;EUS_Version,EUS_Revision
		dc.l	MyMenuName			;EUS_Username
		dc.w	0				;EUS_WinX
		dc.w	0				;EUS_WinY
		dc.w	EUSB_Openwin			;EUS_Flags
		dc.w	0				;EUS_Special
		dc.w	0				;EUS_Special+2
PrefsFlags:	dc.l	1<<Pass1!1<<Pass2!0<<Pass3!1<<SecurityMode	;EUS_Special2
		dc.l	0				;EUS_Special3
		StructDate				;EUS_Creatordate
		dc.b	0				;EUS_Priority
		dc.b	EUTY_Ripper			;EUS_type
		dc.w	0				;EUS_Reserved2
		dc.l	0				;EUS_Reserved3
		dc.l	0				;EUS_Reserved4
		dc.l	0				;EUS_Reserved5
		dc.l	0				;EUS_Reserved6

		ifne	(*-EUS_Structure)-EUS_SizeOF
		Aber Hallo
		endc

	dc.b	"$VER: Eagleplayer-Ripper "
	ver
	dc.b	" ("
	date
	dc.b	")",0
	even

		ifeq	Executable
FirstEagleInit:	lea	EaglePuffer,a5
		move.l	a5,EUS_EPBase+EUS_Structure

		lea	MyIntuiname,a1
		move.l	4,a6
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,DTG_Intuitionbase(a5)

		lea	MyGFXname,a1
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,DTG_GFXbase(a5)

		lea	MyGadToolsname,a1
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,DTG_GadToolsbase(a5)

		lea	MyLocalename,a1
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,EPG_Localebase(a5)

		lea	MyDosname,a1
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,DTG_Dosbase(a5)

		lea	EP_List1,a0
		move.l	a0,EPG_ModulesList(a5)
		newlist a0
		lea	EP_List1,a0
		lea	EP_Entry1,a1
		move.l	#Name1,LN_Name(a1)
		addtail	a0,a1

		lea	EP_List1,a0
		lea	EP_Entry2,a1
		move.l	#Name2,LN_Name(a1)
		addtail	a0,a1

		lea	EP_List1,a0
		lea	EP_Entry3,a1
		move.l	#Name3,LN_Name(a1)
		addtail	a0,a1
		lea	Puffer,a5
		rts

MyIntuiname:	dc.b	"intuition.library",0
MyGFXname:	dc.b	"graphics.library",0
MyGadtoolsname:	dc.b	"gadtools.library",0
MyLocalename:	dc.b	"locale.library",0
MyDosname:	dc.b	"dos.library",0
Name1:		dc.b	"Module1",0
Name2:		dc.b	"Module2",0
Name3:		dc.b	"Module3",0

TestList:	dc.b	"MODLIST",10
		dc.b	"Modules:Agnostica",10
		dc.b	"'EP:Test' MP:01=1,02='8-Bit Amplifier',03='Animal'",10
		dc.b	'":Test3"'
TestListSize	= *-Testlist

		even
EaglePuffer	ds.b	EPG_SizeOf

EP_List1	ds.b	LH_Size
EP_Entry1	ds.b	LN_Size
EP_Entry2	ds.b	LN_Size
EP_Entry3	ds.b	LN_Size

		endc


*-----------------------------------------------------------------------------*
TagListe:	dc.l	EUT_Ripp,Rippen
		dc.l	EUT_RippCont,RippenCont
		dc.l	EUT_RippExt,RippenExt
		dc.l	EUT_EPSubItems,EP_Menu
		dc.l	EUT_Command,Commando
		dc.l	EUT_ExitEngine,ExitEngine
		dc.l	EUT_SpecialinfoLNr,LNrE_SpecialInfo_Eagleripper
		dc.l	EUT_LocaleTable,LocaleTable
		dc.l	EUT_InitEngine,InitEngine
		dc.l	EUT_FreeRipperStruct,FreeRippStruct
		dc.l	0

*-----------------------------------------------------------------------------*
InitEngine:
	ifeq	Executable
	move.l	#Unknown.MSG,LA_Unknown
	move.l	#Ripping.MSG,LA_Ripping
	move.l	#Security1.MSG,LA_Security1
	move.l	#Security2.MSG,LA_Security2
	move.l	#Gadgets.MSG,LA_Gadgets
	move.l	#Fr_SaveModule.MSG,LA_Fr_SaveModule
	move.l	#Sw_SaveModule.MSG,LA_SW_SaveModule

	bsr	FirstEagleInit
	endc
		lea	Puffer(pc),a5
		bsr	CopyEPBase

		lea	EPM_Pass1(pc),a0
		move.l	PrefsFlags(pc),d1
		bclr	#0,12(a0)
		btst	#Pass1,d1
		beq.s	.NoPass1
		bset	#0,12(a0)
.NoPass1:	bclr	#0,12+(EPM_Pass2-EPM_Pass1)(a0)
		btst	#Pass2,d1
		beq.s	.NoPass2
		bset	#0,12+(EPM_Pass2-EPM_Pass1)(a0)
.NoPass2:	bclr	#0,12+(EPM_Pass3-EPM_Pass1)(a0)
		btst	#Pass3,d1
		beq.s	.NoPass3
		bset	#0,12+(EPM_Pass3-EPM_Pass1)(a0)
.NoPass3	bclr	#0,12+(EPM_SecurityMode-EPM_Pass1)(a0)
		btst	#SecurityMode,d1
		beq.s	.NoSecurityMode
		bset	#0,12+(EPM_SecurityMode-EPM_Pass1)(a0)
.NoSecurityMode:moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
CopyEPBase:	movem.l	d0-a6,-(a7)
		move.l	EUS_Structure+EUS_EPBase(pc),a0
		move.l	a5,a1
		move.w	#EPG_SizeOf-1,d0
.CopyEP:	move.b	(a0)+,(a1)+
		dbf	d0,.CopyEP
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
ExitEngine:	lea	Puffer(pc),a5
		bsr	CopyEPBase
		bsr	FreeRipper
		moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
* Vom Eagleplayer wird ein Kommando (vom PDMenu) geschickt.
* wahrscheinlich "Pass1 ..."
*-----------------------------------------------------------------------------*
* Input: d0=EPNr_Nummer
*	 Rest = Parameter
* Output:d0=Error oder NULL
Commando:	lea	Puffer,a5

		cmp.w	#EPNr_EngineItemCommand,d0
		bne.s	.Return
		
		move.l	PrefsFlags(pc),d3
		cmp.w	#EPNr_Er_Pass1,d2
		bne.s	.Pass2
		and.l	#~(1<<Pass1),d3
		move.b	EPM_Pass1+12(pc),d4
		btst	#0,d4
		beq.s	.SetPrefs
		bset	#Pass1,d3
		bra.s	.SetPrefs

.Pass2:		cmp.w	#EPNr_Er_Pass2,d2
		bne.s	.Pass3
		and.l	#~(1<<Pass2),d3
		move.b	EPM_Pass2+12(pc),d4
		btst	#0,d4
		beq.s	.SetPrefs
		bset	#Pass2,d3
		bra.s	.SetPrefs

.Pass3:		cmp.w	#EPNr_Er_Pass3,d2
		bne.s	.SecurityMode
		and.l	#~(1<<Pass3),d3
		move.b	EPM_Pass3+12(pc),d4
		btst	#0,d4
		beq.s	.SetPrefs
		bset	#Pass3,d3
		bra.s	.SetPrefs

.SecurityMode:	cmp.w	#EPNr_Er_SecurityMode,d2
		bne.s	.Return
		and.l	#~(1<<SecurityMode),d3
		move.b	EPM_SecurityMode+12(pc),d4
		btst	#0,d4
		beq.s	.SetPrefs
		bset	#SecurityMode,d3

.SetPrefs:	move.l	d3,PrefsFlags
.Return:	moveq	#0,d0
		rts




*-----------------------------------------------------------------------------*
FreeRipper:	movem.l	d0-a6,-(a7)
		lea	FirstRipper(a5),a3
		move.l	(a3),d0
.NextRipper:	tst.l	d0
		beq.s	.Return
		move.l	d0,a3
		move.l	ER_Segment(a3),d1
		beq.s	.NoSegment
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOUnLoadSeg(a6)
.NoSegment:	move.l	ER_StructSize(a3),d0
		move.l	a3,a1
		move.l	(a3),d3
		move.l	4,a6
		jsr	_LVOFreemem(a6)
		move.l	d3,d0
		bra.s	.NextRipper

.Return:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: a0=StartMemAdr
*	 d0=MemSize
*	 a1=Filename
* Output:d0=Error oder NULL
*	 a0=ModuleStart
*	 d1=ModuleSize
*	 a1=RipperStruct		(only Read)
*-----------------------------------------------------------------------------*
Rippen:		lea	Puffer(pc),a5
		move.l	a1,Filename(a5)
		lea	Filename(a5),a1
		move.l	a1,DisplayArgs(a5)
		bsr	CopyEPBase
		bsr	LadeRipper

		*--- Rippen  Pass 1 ---*
		move.l	a0,a3
		move.l	d0,d3
		moveq	#Pass1,d4
		move.l	d4,d0
		bsr	MakeRippstruct
		bne.w	.Return
		move.l	a0,a4				*Ripperstruct
		btst	#Pass1,PrefsFlags+3
		beq.s	.Pass2

		move.l	a3,ERPSS_MemStart(a4)
		move.l	a3,ERPSS_Position(a4)
		move.l	d3,ERPSS_MemSize(a4)
		move.l	a4,a0
		bsr	RippThisModus
		beq.s	.Ok
		cmp.w	#EPR_Functionaborted,d0
		beq.s	.ErrorInD0
		
		*--- Rippen Pass 2---*
.Pass2:		btst	#Pass2,PrefsFlags+3
		beq.s	.Pass3

		move.l	a4,a0
		moveq	#Pass2,d4
		move.l	d4,d0
		bsr	AllocPassTable
		bne.s	.Pass3
		move.l	a3,ERPSS_MemStart(a4)
		move.l	a3,ERPSS_Position(a4)
		move.l	d3,ERPSS_MemSize(a4)
		move.l	a4,a0
		bsr	RippThisModus
		beq.s	.Ok
		cmp.w	#EPR_Functionaborted,d0
		beq.s	.ErrorInD0

		*--- Rippen Pass 3---*
.Pass3:		btst	#Pass3,PrefsFlags+3
		beq.s	.Error

		move.l	a4,a0
		moveq	#Pass3,d4
		move.l	d4,d0
		bsr	AllocPassTable
		bne.s	.Error

		move.l	a3,ERPSS_MemStart(a4)
		move.l	a3,ERPSS_Position(a4)
		move.l	d3,ERPSS_MemSize(a4)
		move.l	a4,a0
		bsr	RippThisModus
		cmp.w	#EPR_Functionaborted,d0
		beq.s	.ErrorInD0
		tst.l	d0
		bne.s	.Error
.Ok:		move.l	d4,ERPSS_CurrentMode(a4)
		bra.s	.Return

		*--- Nichts gefunden ---*
.Error:		moveq	#EPR_UnknownFormat,d0
.ErrorInD0:	move.l	a4,a0
		bsr	ErrorBeimRippen
.Return:	tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: a0=Ripperstruct (mit Startadr,End & Position)
* Output:d0=Error oder NULL
*	 a0=ModuleStart
*	 d1=ModuleSize
*	 a1=RipperStruct		(only Read)
*-----------------------------------------------------------------------------*
RippenCont:	lea	Puffer(pc),a5
		sub.l	a4,a4
		move.l	a1,d0
		beq.w	.Error
		move.l	d0,a4
		bsr	CopyEPBase
		move.l	a4,a0

		clr.l	ERPSS_FormatID(a4)
		clr.l	ERPSS_FormatName(a4)
		clr.l	ERPSS_ModuleName(a4)
		clr.l	ERPSS_Ripperstruct(a4)
		clr.l	ERPSS_Tags(a4)

		move.l	ERPSS_Position(a4),a1
		addq.l	#SchrittWeite,a1
		move.l	a1,ERPSS_Position(a4)
		move.l	ERPSS_MemStart(a4),d1
		add.l	ERPSS_MemSize(a4),d1
		cmp.l	d1,a1
		bhs.w	.Error

		tst.l	ERPSS_CurrentMode(a4)
		bne.s	.Pass2_2

		*---- Rippen Pass 1 ------*

		bsr	RippThisModus
		beq.s	.Ok
		cmp.w	#EPR_Functionaborted,d0
		beq.s	.ErrorInD0


		*---- Rippen Pass 2 ------*
		btst	#Pass2,PrefsFlags+3
		beq.s	.Pass3
		move.l	a4,a0
		moveq	#Pass2,d4
		move.l	d4,d0
		bsr	AllocPassTable
		bne.s	.Pass3
		move.l	a3,ERPSS_MemStart(a4)
		move.l	a3,ERPSS_Position(a4)
		move.l	d3,ERPSS_MemSize(a4)
.Pass2_2:	move.l	a4,a0
		cmp.l	#Pass2,ERPSS_CurrentMode(a4)
		bne.s	.Pass3_2
		bsr	RippThisModus
		beq.s	.Ok
		cmp.w	#EPR_Functionaborted,d0
		beq.s	.ErrorInD0

		*--- Rippen Pass 3---*
.Pass3:		btst	#Pass3,PrefsFlags+3
		beq.s	.Error
		move.l	a4,a0
		moveq	#Pass3,d4
		move.l	d4,d0
		bsr	AllocPassTable
		bne.s	.Error
		move.l	a3,ERPSS_MemStart(a4)
		move.l	a3,ERPSS_Position(a4)
		move.l	d3,ERPSS_MemSize(a4)
.Pass3_2:	move.l	a4,a0
		bsr	RippThisModus
		cmp.w	#EPR_Functionaborted,d0
		beq.s	.ErrorInD0
		tst.l	d0
		bne.s	.Error
.Ok:		move.l	d4,ERPSS_CurrentMode(a4)
		bra.s	.Return

.Error:		moveq	#EPR_UnknownFormat,d0
.ErrorInD0:	move.l	a4,a0
		bsr	ErrorBeimRippen		
.Return:	tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* input:a0=Ripperstruct
ErrorBeimRippen:bsr	FreeRippStruct
		sub.l	a1,a1
		sub.l	a0,a0
		moveq	#0,d1
		rts


*-----------------------------------------------------------------------------*
* Input: a0=Ripperstruct
RippenExt:	cmp.l	#0,a0
		beq.s	.KeinExtRipp
		move.l	a0,a4
		move.l	ERPSS_Tags(a4),a6
		move.l	#RPT_ExtRipp,d0
		bsr	FindTag
		beq.s	.KeinExtRipp

	*------------------------------------------*
	* Hier werden Zusatzfiles gesucht
	* Input: a0=Ripperstruct
	* Output:d0=Error oder NULL
	*------------------------------------------*
		move.l	a4,a0
		jsr	(a6)
		rts

.KeinExtRipp:	moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
* Input: a0=Ripperstruct (mit Startadr,End & Position)
* Output:d0=Error oder NULL
*	 a0=ModuleStart
*	 d1=ModuleSize
*	 a1=RipperStruct		(only Read)
*-----------------------------------------------------------------------------*
*#############################################################################*
* Benutze Register:
* 
* Input for Eagleripper
*----------------------
* a0=Adr (start of memory)
* d0=Size (size of memory)
* a1=current adr
* d1=(a1.l)
*
* Output from Eagleripper:
*-------------------------
* d0=Error oder NULL
* d1=Size
* d2=Samplesize (or NULL)
* a0=Startadr (data)
* a1=Sampleptr (sample or NULL)
*
* Intern:
*---------
* d3=Startadr der Passtable
* d4=Hunksize (current)
* d5=Inhalt von a1
* d6=Size of Memory
* d7=Restsize
* a3=Passtable
* a4=Ripperstruct
* a5=CurrentAdr
* a6=Start of Memory
*-----------------------------------------------------------------------------*
RippThisModus:	movem.l	d3-d7/a2-a6,-(a7)
		moveq	#EPR_UnknownFormat,d7
		move.l	a0,a4
		clr.l	ERPSS_FilePtr(a4)
		clr.l	ERPSS_FileSize(a4)

		move.l	ERPSS_PassTable(a4),d3
		beq.w	.Return
		move.l	d3,a1
		tst.l	(a1)
		beq.w	.Return

		*sub.l	a1,a1
		move.l	DisplayArgs(a5),a1
		bsr	Initcrunchdisplay
		move.l	ERPSS_MemSize(a4),d0
		bsr	GetHunkSize
		move.l	d0,Hunksize(a5)
		move.l	d0,d4

		move.l	ERPSS_MemStart(a4),d0
		beq.w	.Return
		move.l	d0,a6
		move.l	ERPSS_Position(a4),d0
		beq.w	.Return
		move.l	d0,a5

		move.l	ERPSS_MemSize(a4),d6
		beq.s	.Return
		move.l	d6,d7
		sub.l	a5,d7
		add.l	a6,d7

	*---- In Schleife bergehen -----*
.Retry:		subq.l	#Schrittweite,d4
		ble.s	.RefreshDisplay
.NeueAdr:	move.l	d3,a3
		move.l	(a5),d5
.NextRipper:	move.l	(a3)+,d0
		beq.s	.NextAdr
		move.l	d0,a2
		move.l	a5,a1
		move.l	a6,a0
		move.l	d6,d0
		move.l	d5,d1
		jsr	(a2)
		tst.l	d0
		beq.s	.ModFound
.NextRipper2:	bra.s	.NextRipper

.NextAdr:	addq.l	#SchrittWeite,a5
		subq.l	#SchrittWeite,d7
		ble.s	.Ende
		bra.s	.Retry

.RefreshDisplay:move.l	Puffer+HunkSize(pc),d4
		bsr	RefreshDisplay
		bne.s	.Ende
		bra.s	.NeueAdr

		*--- Returnwerte setzen ---*
.ModFound:	move.l	a5,ERPSS_Position(a4)
		move.l	a0,ERPSS_FilePtr(a4)
		move.l	d1,ERPSS_FileSize(a4)
		move.l	-4(a3),d0
		bsr	InsertFormatName
		beq.s	.Abbruch
		cmp.w	#2,d0
		bne.s	.Gefunden

		*--- Rippen fortsetzen ---*
		bsr	RemoveCrunchDisplay
		move.l	Puffer+DisplayArgs(pc),a1
		bsr	Initcrunchdisplay
		bsr	RefreshDisplay
		bne.s	.Ende
		bra.s	.NextRipper2

.Gefunden:	moveq	#0,d0
		move.l	ERPSS_FileSize(a4),d1
		move.l	a4,a1
		moveq	#0,d7
		bra.s	.Return

		*--- Crunchanzeige beenden ---*
.Abbruch:	moveq	#EPR_Functionaborted,d7
		bra.s	.Return
.Ende:		moveq	#EPR_UnknownFormat,d7
.Return:	lea	Puffer(pc),a5
		bsr	RemoveCrunchDisplay
		move.l	d7,d0
		movem.l	(a7)+,d3-d7/a2-a6
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
* ERPSS_FormatID enthaelt zur Zeit den Ptr auf die Ripproutine! Jetzt mssen*
* die einzelnen Ripper durchsucht werden.
* Input:a4=Ripperstruct
*	d0=Jump to Ripproutine
* Output:d0=NULL -> Abbruch
*-----------------------------------------------------------------------------*
InsertFormatName:
		movem.l	d1-a6,-(a7)
		lea	Puffer(pc),a5
		move.l	d0,d5

		*--- Jetzt Formatnamen suchen ---*
		lea	FirstRipper(a5),a3
		moveq	#-1,d4
.NextRipper:	addq.l	#1,d4
.NextRipper2:	move.l	(a3),d1
		beq.w	.Return
		move.l	d1,a3
		move.l	#RPT_Ripp1,d0
		move.l	ER_Tags(a3),a6
		bsr	FindTag
		beq.s	.Jump2
		cmp.l	a6,d5
		beq.s	.JumpFound

.Jump2:		move.l	#RPT_Ripp2,d0
		move.l	ER_Tags(a3),a6
		bsr	FindTag
		beq.s	.Jump3
		cmp.l	a6,d5
		beq.s	.JumpFound

.Jump3:		move.l	#RPT_Ripp3,d0
		move.l	ER_Tags(a3),a6
		bsr	FindTag
		beq.s	.NextRipper2
		cmp.l	a6,d5
		bne.s	.NextRipper

.JumpFound:	move.l	ER_Tags(a3),a6
		move.l	a3,ERPSS_RipperStruct(a4)
		move.l	a6,ERPSS_Tags(a4)

		move.l	#RPT_FormatName,d0
		bsr	FindTag
		move.l	a6,ERPSS_FormatName(a4)

		bsr	SetModulename

	*--- Filesize korrigieren ---*
		move.l	ERPSS_FileSize(a4),d0
		cmp.l	#-1,d0
		bne.s	.NoUnknown

		move.l	ERPSS_MemSize(a4),d0
		move.l	ERPSS_FilePtr(a4),d2
		sub.l	ERPSS_MemStart(a4),d2
		sub.l	d2,d0				*max RestSize
		move.l	d0,ERPSS_FileSize(a4)
		move.l	LA_Security2(pc),a2
		bra.s	.FilesizeOk

		*--- SecurityRequester abfragen ---*
		* 0=Abbruch
		* 1=Abspielen
		* 2=Save File
		* 3=Cont
.NoUnknown:	move.l	LA_Security1(pc),a2
.FileSizeOk:	bsr	Security
		cmp.w	#3,d0
		bne.s	.Return

		*--- Jetzt Image speichern ---*
		bsr	SaveToDisk
		bra.s	.FileSizeOk

.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: a4=Ripperstruct
* Output:
*-----------------------------------------------------------------------------*
SetModulename:	movem.l	d0-a6,-(a7)
		lea	NamePuffer(a5),a1
		move.l	a1,ERPSS_Modulename(a4)

		move.l	#NamePufferSize-2,d1

		*--- Vorsilbe rankopieren ---*
		move.l	ERPSS_Tags(a4),a6
		move.l	#RPT_Prefix,d0
		bsr	Findtag
		move.l	d2,a3
*	lea	prefix(pc),a3
		move.l	a3,a0


		bsr	BerechStringSize
		move.l	d0,d3
		beq.s	.NoPrefix1
		cmp.b	#".",(a0)
		beq.s	.NoPrefix1
		bsr	StringCopy

		*--- Name rankopieren ---*
.NoPrefix1:	move.l	LA_Unknown(pc),a2
		move.l	ERPSS_Tags(a4),a6
		move.l	#RPT_GetModuleName,d0
		bsr	Findtag
		beq.s	.KeinPrefix
		move.l	ERPSS_FilePtr(a4),a0
		move.l	ERPSS_FileSize(a4),d0
		movem.l	d1-a6,-(a7)
		jsr	(a6)
		movem.l	(a7)+,d1-a6
		move.l	d0,a0
*	lea	name(pc),a0

		tst.l	d0
		beq.s	.KeinPrefix
		tst.b	(a0)
		beq.s	.KeinPrefix
		move.l	a0,a2

		*--- Testen, ob selbe Vorsilbe ---*
		move.l	a1,-(a7)
		move.l	a3,a1
		cmp.b	#".",(a0)
		bne.s	.KeinPrefix1_2
		addq.l	#1,a0
		subq.l	#1,d3
.KeinPrefix1_2:	bsr	StrCmpd3		*testen, ob selbe Vorsilbe
		move.l	(a7)+,a1
		tst.l	d0
		bne.s	.KeinPrefix
		lea	(a2,d3.w),a2		;Prefix ignorieren
.KeinPrefix:	move.b	(a2),d4
		cmp.b	#"a",d4
		blo.s	.d4ok
		cmp.b	#"z",d4
		bhi.s	.d4ok
		bclr.b	#5,(a2)

.d4Ok:		*--- Testen, ob Nachsilbe schon als vorsilbe existiert ---*
		cmp.b	#".",(a3)
		bne.s	.KeineNAV
		move.l	a1,-(a7)
		move.l	a3,a0
		addq.l	#1,a0
		bsr	BerechStringSize
		move.l	d0,d3
		move.l	a2,a1
		bsr	StrCmpD3
		bne.s	.KeineNAV_2
		lea	1(a2,d3.w),a2
.KeineNAV_2:	move.l	(a7)+,a1	
.KeineNAV:	move.l	a2,a0
		bsr	StringCopy
		move.b	d4,(a2)
		cmp.l	#0,a3
		beq.s	.NoPrefix2

		*--- Testen, ob selbe Nachsilbe ---*
		lea	NamePuffer(a5),a2
		moveq	#-1,d3
.Nochmal:	addq.l	#1,d3
		cmp.l	a2,a1
		beq.s	.NachSilbeOk
		move.b	-(a1),d0
		cmp.b	#".",d0
		bne.s	.Nochmal

		

		move.l	a3,a0
		bsr	BerechStringSize
		move.l	d0,d3
		cmp.b	#".",(a0)
		beq.s	.NoPrefix2_1
		addq.l	#1,a1
		subq.l	#1,d3
.NoPrefix2_1:	bsr	StrCmpd3
		tst.l	d0
		bne.s	.NachSilbeOk_2
		subq.l	#1,a1
		cmp.b	#".",(a0)
		beq.s	.NoPrefix2
		clr.b	(a1)
.NachSilbeOk_2:	move.l	a1,a0			* Ende setzen
		bsr	BerechStringSize
		lea	(a0,d0.w),a1



		*--- Nachsilbe rankopieren ---*
.NachSilbeOk:	move.l	a3,d0
		beq.s	.NoPrefix2
		move.l	d0,a0
		cmp.b	#".",(a0)
		bne.s	.NoPrefix2
		bsr	StringCopy
.NoPrefix2:
		*lea	NamePuffer(a5),a1
		movem.l	(a7)+,d0-a6
		rts

*prefix	dc.b	".dat",0
*name:	dc.b	"dat.hallo.dat",0
*	even
*


*-----------------------------------------------------------------------------*
* Input: a0=String1
*	 a1=String2
*	 d3=Vergleichsize
* Output:d0=0 Strings gleich
*	 d0<>0 String ungleich
*-----------------------------------------------------------------------------*
StrCmpd3:	movem.l	d1/d3/a0/a1,-(a7)
		subq.w	#1,d3
		blt.s	.Error
		move.l	a0,d0
		beq.s	.Error
		move.l	a1,d0
		beq.s	.Error
.Repeat:	move.b	(a0)+,d1
		beq.s	.Ende1
		cmp.b	#`A`,d1		;Kommando in Grobuchstaben
		blo.s	.NoD1Set	;umwandeln
		cmp.b	#`Z`,d1
		bhi.s	.NoD1Set
		bset	#5,d1		;bis auf Bit 5 alle bernehmen -> fertig
.NoD1Set:	move.b	(a1)+,d0	;Wert holen
		beq.s	.Error
		cmp.b	#`A`,d0		;Kommando in Grobuchstaben
		blo.s	.NoBSet		;umwandeln
		cmp.b	#`Z`,d0
		bhi.s	.NoBSet
		bset	#5,d0		;bis auf Bit 5 alle bernehmen -> fertig
.NoBSet:	cmp.b	d1,d0
		bne.s	.Error
		dbf	d3,.Repeat
		moveq	#0,d0
		bra.s	.Return

.Error:		moveq	#-1,d0
.Return:	movem.l	(a7)+,d1/d3/a0/a1
		tst.l	d0
		rts			;---> Error in String !!!!

.Ende1:		tst.b	(a1)
		bne.s	.Error
		moveq	#0,d0
		bra.s	.Return

*---------------------------- Make Correct-Dir ------------------------------*
*---------------- Berechnet die Gre des Strings in a0 ---------------------*
*------- >= a0=String							-----*
*------- => d0=Stringsize						-----*
*----------------------------------------------------------------------------*
BerechStringSize:move.l a0,-(a7)
		moveq	#0,d0
		cmp.l	d0,a0
		beq.s	.NoTest
		moveq	#-1,d0
.NextB:		addq.l	#1,d0
		tst.b	(a0)+
		bne.s	.NextB
.NoTest:	move.l	(a7)+,a0
		tst.l	d0
		rts

*----------------------------------------------------------------------------*
StringCopy:	moveq	#0,d0
		cmp.l	a1,d0
		beq.s	.Return
		cmp.l	a0,d0
		beq.s	.Return
		tst.w	d1
		blt.s	.Return

.CopyIt:	clr.b	(a1)
		move.b	(a0)+,d0		;Copiere String bis 0 d1=Anz
		beq.b	.Return
		move.b	d0,(a1)+
		dbf	d1,.CopyIt
		clr.b	(a1)
.Return		moveq	#0,d0
STR_Return:	rts

*-----------------------------------------------------------------------------*
* Input: a2=Def-Text
*	 a4=ERPSS_RIPPERstruct
* Output:d0=0 --> Abbruch
*	   =1 --> Abspielen
*	   =2 --> Continue
*	   =3 --> SaveFile
*-----------------------------------------------------------------------------*
Security:	movem.l	d1-a6,-(a7)
		move.l	a4,a3
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		lea	Puffer(pc),a5

		moveq	#1,d0
		move.l	PrefsFlags(pc),d1
		btst	#SecurityMode,d1
		beq.s	.Return

		*--- Textrequester aufmachen ---*
		move.l	a2,a0
		move.l	a0,EPG_Arg1(a4)
		move.l	EPG_PubScreen(a4),EPG_Arg2(a4)
		clr.l	EPG_Arg3(a4)
		subq.l	#1,EPG_Arg3(a4)			;X-Koordinate

		move.l	LA_Gadgets(pc),EPG_Arg4(a4)
		clr.l	EPG_Arg5(a4)
		lea	TextArgs(a5),a0
		move.l	a0,EPG_Arg6(a4)

		*-- Args setzen --*
		move.l	LA_Unknown(pc),a1
		move.l	ERPSS_FormatName(a3),d0
		bne.s	.FormatOK
		move.l	a1,d0
.FormatOk:	move.l	d0,(a0)
		move.l	ERPSS_ModuleName(a3),4(a0)
		move.l	ERPSS_Filesize(a3),8(a0)

		moveq	#-1,d0
		move.l	d0,EPG_Arg7(a4)
		moveq	#8,d0
		move.l	d0,EPG_ArgN(a4)
		clr.l	EPG_Arg8(a4)

	if Executable
		jsr	ENPP_TextRequest(a4)
	else
		bsr	TextRequest
	endc

.Return:	movem.l	(a7)+,d1-a6
		rts

*-----------------------------------------------------------------------------*
* Input: a4=Ripperstruct
* Output:d0=Error oder NULL
*-----------------------------------------------------------------------------*
SaveToDisk:	movem.l	d1-a6,-(a7)
		move.l	a4,a3
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		lea	Puffer(pc),a5

		move.l	LA_Fr_SaveModule(pc),EPG_Arg1(a4)
		lea	PathPuffer(a5),a0
		move.l	a0,EPG_Arg2(a4)
		move.l	ERPSS_Modulename(a3),EPG_Arg3(a4)
		clr.l	EPG_Arg4(a4)
		moveq	#0,d0
		move.l	d0,EPG_Arg5(a4)

		move.l	LA_SW_SaveModule(pc),EPG_Arg6(a4)
		moveq	#6,d0
		move.l	d0,EPG_ArgN(a4)
		move.l	EPG_FileRequest(a4),a0
	if	Executable
		jsr	(a0)
	else
		moveq	#0,d0
	endc
		tst.l	d0
		bne.s	.Return

	*------------------- Save Mem to Disk ----------------------*
	*---- ARG1 = StartAdr					----*
	*---- ARG2 = Lnge					----*
	*---- ARG3 = PathAdr					----*
	*---- ARG4 = CrunchMode					----*
	*---- ARG5 = Flags					----*
	*----	Bit 0 = Soll ein Anzeige in Playerswindow 0=ja  ----*
	*----	Bit 1 = Immer deprotecten			----*
	*----	Bit 2 = Safe Save				----*
	*----							----*
	*----	Output:	Arg1 = Ergebnis (0=Alles ok)		----*
	*-----------------------------------------------------------*
		lea	PathPuffer(a5),a1		*Puffer
		move.l	a1,EPG_Arg3(a4)

		bsr	MakecorrectDir
		lea	PathPuffer(a5),a0
		bsr	BerechStringSize
		lea	(a0,d0.w),a1
		move.l	ERPSS_ModuleName(a3),a0
		move.l	a1,-(a7)
		moveq	#MaxFilenameSize,d1
		bsr	StringCopy


		move.l	ERPSS_FilePtr(a3),EPG_Arg1(a4)
		move.l	ERPSS_FileSize(a3),EPG_Arg2(a4)

		move.l	#-1,EPG_Arg4(a4)
		moveq	#%111,d0
		move.l	d0,EPG_Arg5(a4)
		moveq	#5,d0
		move.l	d0,EPG_ArgN(a4)
		move.l	EPG_SaveMem(a4),a0
	if	Executable
		jsr	(a0)
	endc
		move.l	(a7)+,a1
		clr.b	(a1)

	* Hier werden Zusatzfiles gespeichert
	* Input: a1=Dir
	*	 a2=first Filename
	*	 a3=ERPSS_Struct
	* Output:d0=Error oder NULL
		move.l	#RPT_ExtSave,d0
		move.l	ERPSS_Tags(a3),a6
		bsr	FindTag
		beq.s	.Return
		movem.l	d1-a6,-(a7)
		lea	PathPuffer(a5),a1
		move.l	ERPSS_ModuleName(a3),a2
		jsr	(a6)
		movem.l	(a7)+,d1-a6
		clr.b	(a1)

.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*---------------------------- Make Correct-Dir ------------------------------*
*----- Corrigiert den Dirnamen so, da Filenamen nur rankopiert werden ------*
*----- >-- a1=Diradresse						-----*
*----------------------------------------------------------------------------*
MakeCorrectDir:	move.l	a1,-(a7)
		tst.b	(a1)
		beq.s	.NoSchraeg
.NextB:		tst.b	(a1)+
		bne.s	.NextB
		subq.l	#2,a1
		cmp.b	#":",(a1)
		beq.s	.NoSchraeg
		cmp.b	#"/",(a1)+
		beq.s	.NoSchraeg
		move.b	#"/",(a1)+
		clr.b	(a1)
.NoSchraeg:	move.l	(a7)+,a1
		rts


*-----------------------------------------------------------------------------*
* Input: d0=Memsize
* Output :d0=Hunksize
*-----------------------------------------------------------------------------*
GetHunkSize:	move.l	d1,-(a7)
		moveq	#0,d1
		cmp.l	#$f000000,d0
		blo.s	.kleiner
		moveq	#8,d1
		lsr.l	d1,d0
.kleiner:	divu	#DisplayGenauigkeit,d0
		and.l	#$ffff,d0
		lsl.l	d1,d0
		move.l	(a7)+,d1
		tst.l	d0
		rts



*-------------------- Crunchanzeige initialisieren ---------------------------*
* Input: a1=Filename
InitCrunchDisplay:
		movem.l	d0-a6,-(a7)
		if	executable
		move.l	LA_Ripping(pc),a0
		move.l	EUS_Structure+EUS_EPBase(pc),a4
	* Input: a0=Test
	*	 a1=ScrollArgs oder NULL
		jsr	ENPP_InitDisplay(a4)
		endc
		movem.l	(a7)+,d0-a6
		rts

*----------------------- Crunchanzeige beenden -------------------------------*
RemoveCrunchDisplay:
		movem.l	d0-a6,-(a7)
		if	executable
		move.l	EUS_Structure+EUS_EPBase(pc),a0
		jsr	ENPP_RemoveDisplay(a0)
		endc
		movem.l	(a7)+,d0-a6
		rts

*------------------------ Mach mal n' Anzeige --------------------------------*
* Input: a4=Ripperstruct
*	 a5=Position
* Output:d0=Error oder NULL
RefreshDisplay:	movem.l	d1-a6,-(a7)
		*move.l	ERPSS_Position(a4),d1
		move.l	a5,d1
		sub.l	ERPSS_MemStart(a4),d1		d1=Size vom Start
		move.l	ERPSS_MemSize(a4),d0		d0=Gesamtsize


		swap	d0
		swap	d1
.NextBit:	btst	#15,d0
		bne.s	.LastOne
		rol.l	#1,d0
		rol.l	#1,d1
		bra.s	.NextBit

.LastOne:	and.l	#$ffff,d0
		and.l	#$ffff,d1
		*ext.l	d0
		*ext.l	d1
		*mulu	#DisplayGenauigkeit,d1
		mulu	#1000,d1
		divu	d0,d1



		if	executable
		move.l	d1,d0
		move.l	EUS_Structure+EUS_EPBase(pc),a0
		jsr	ENPP_FillDisplay(a0)
		else
		moveq	#0,d0
		btst	#7,$bfe001
		bne.s	.NotPressed
		moveq	#1,d0
.NotPressed:	endc
		tst.l	d0
		beq.s	.Return

		moveq	#EPR_UnknownFormat,d0
		moveq	#0,d1
		sub.l	a0,a0
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: d0=Modus (Pass1-3)
* Output:d0=Error oder NULL
*	 a0=Allocierte Rippstruct
*-----------------------------------------------------------------------------*
MakeRippStruct:	movem.l	d1-d7/a1-a6,-(a7)
		move.l	d0,d4
		bsr	AllocARippStruct
		move.l	d0,a0
		beq.s	.Error

		*--- Jetzt Passtabelle allocieren ---*
		move.l	d4,d0
		bsr	AllocPassTable
		beq.s	.Ok

.FreeStruct:	bsr	FreeRippStruct
.Error:		moveq	#EPR_NoMoreEntries,d0
.Ok:
		movem.l	(a7)+,d1-d7/a1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: a0=Ripperstruct
* Output:--
*-----------------------------------------------------------------------------*
FreeRippStruct:	movem.l	d0-a6,-(a7)
		lea	Puffer(pc),a5
		cmp.l	#0,a0
		beq.s	.Ret
		bsr	FreePassTable
		bsr	FreeARippStruct
.Ret:		movem.l	(a7)+,d0-a6
		rts




*-----------------------------------------------------------------------------*
* Input: --
* Output:d0=Error oder NULL
*	 a0=Allocierte Rippstruct
*-----------------------------------------------------------------------------*
AllocARippStruct:
		movem.l	d1-a6,-(a7)
		moveq	#ERPSS_SizeOf,d0
		move.l	#$10000,d1
		*bsr	AllocMem
		lea	MyRipperstruct(a5),a0
		move.l	a0,d0
		moveq	#ERPSS_SizeOf-1,d1
.Clr:		clr.b	(a0)+
		dbf	d1,.Clr
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: a0=Allocierte Rippstruct
* Output:--
*-----------------------------------------------------------------------------*
FreeARippStruct:movem.l	d0-a6,-(a7)
		cmp.l	#0,a0
		beq.s	.Ret
		moveq	#ERPSS_SizeOf,d0
		move.l	a0,a1
		*bsr	FreeMem
.Ret:		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Die Passtable wird dann entsprechend allociert
* Input: a0=Ripperstruct
*	 d0=Modus
* Output:d0=Error oder NULL
*-----------------------------------------------------------------------------*
AllocPassTable:	movem.l	d1-a6,-(a7)
		move.l	d0,d4
		moveq	#EPR_NoMoreEntries,d7
		cmp.l	#0,a0
		beq.s	.Return
		bsr	FreePassTable
		bsr	RipperAnz
		beq.s	.Return
		move.l	d0,d3
		lsl.l	#2,d0
		addq.l	#PassMemDrauf,d0
		move.l	d0,d2
		move.l	#$10000,d1
		moveq	#EPR_NotEnoughMem,d7
		bsr	AllocMem
		beq.s	.Return
		move.l	d0,ERPSS_Passtable(a0)
		move.l	d2,ERPSS_PasstableSize(a0)

		*--- Passtabelle fllen ---*
		move.l	d4,d0
		bsr	FillPassTable
		move.l	d0,d7

.Return:	move.l	d7,d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Die Passtable wird dann entsprechend freigegeben
* Input: a0=Ripperstruct
* Output:d0=Error oder NULL
*-----------------------------------------------------------------------------*
FreePassTable:	movem.l	d0-a6,-(a7)
		cmp.l	#0,a0
		beq.s	.Ret
		move.l	ERPSS_PassTable(a0),d0
		beq.s	.Return
		move.l	d0,a1
		move.l	ERPSS_PassTableSize(a0),d0
		beq.s	.Return
		bsr	FreeMem
.Return:	clr.l	ERPSS_Passtable(a0)
		clr.l	ERPSS_PasstableSize(a0)
.Ret:		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Die Passtable wird dann entsprechend gefllt
* Input: a0=Ripperstruct
*	 d0=Modus
* Output:d0=Error oder NULL
*-----------------------------------------------------------------------------*
FillPassTable:	movem.l	d1-a6,-(a7)
		moveq	#EPR_ErrorInArguments,d7
		move.l	d0,d4
		lea	FirstRipper(a5),a1
		move.l	ERPSS_PassTable(a0),d0
		beq.s	.Return
		move.l	d0,a2
		move.l	ERPSS_PassTableSize(a0),d3
		subq.l	#PassMemDrauf,d3
		lsr.l	#2,d3
		subq.l	#1,d3
		blt.s	.Return

.NextRipper:	move.l	(a1),d0
		beq.s	.Return
		move.l	d0,a1
		move.l	ER_Tags(a1),a6
		move.l	#RPT_Ripp1,d0
		add.l	d4,d0
		bsr	FindTag
		beq.s	.NextRipper
		move.l	a6,(a2)+
		dbf	d3,.NextRipper
		clr.l	(a2)
		moveq	#0,d7
.Return:	move.l	d7,d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Ermittelt die Anzahl der Ripper
* Input: d0=Modus
* Output:d0=Error oder NULL
*	 a0=Allocierte Rippstruct
*-----------------------------------------------------------------------------*
RipperAnz:	movem.l	d1-a6,-(a7)
		move.l	d0,d3
		lea	FirstRipper(a5),a0
		moveq	#-1,d4
.NextRipper:	addq.l	#1,d4
.NextRipper2:	move.l	(a0),d1
		beq.s	.Return
		move.l	d1,a0
		move.l	#RPT_Ripp1,d0
		add.l	d3,d0
		move.l	ER_Tags(a0),a6
		bsr	FindTag
		beq.s	.NextRipper2
		bra.s	.NextRipper

.Return:	move.l	d4,d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
* Input: d0=Size
*	 d1=Eigenschaften
* Output:d0=NULL oder Adr
*-----------------------------------------------------------------------------*
AllocMem:	movem.l	d1-a6,-(a7)
		move.l	4,a6
		jsr	_LVOAllocMem(a6)
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: d0=Size
*	 a1=Adr
* Output:--
*-----------------------------------------------------------------------------*
FreeMem:	movem.l	d0-a6,-(a7)
		move.l	4,a6
		jsr	_LVOFreeMem(a6)
		movem.l	(a7)+,d0-a6
		rts







*-----------------------------------------------------------------------------*
LadeRipper:	movem.l	d0-a6,-(a7)
		tst.w	Ripperloaded(a5)
		bne.w	.NoEngineDir

	if	Executable
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_EngineDirArrayPtr(a4),d1
		beq.s	.NoConfigDir
	else
		move.l	#Enginedir,d1
	endc
		move.l	DTG_Dosbase(a5),a6
		moveq	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.s	.NoConfigDir
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1

		*--- RipperDir setzen ---*
.NoConfigDir:	move.l	d1,-(a7)
		lea	Eaglerippers(pc),a0
		move.l	a0,d1
		move.l	DTG_Dosbase(a5),a6
		moveq	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,d6
		beq.s	.FreeEngineDir
		move.l	d6,d1
		jsr	_LVOCurrentDir(a6)
		move.l	d0,-(a7)

		moveq	#DOS_FIB,d1
		moveq	#0,d2
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOAllocDosObject(a6)
		move.l	d0,a4
		tst.l	d0
		beq.w	.FreeNoiseDir

		bsr	LadeNunRipper

		moveq	#DOS_FIB,d1
		move.l	a4,d2
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOFreeDosObject(a6)


.FreeNoiseDir:	move.l	(a7)+,d1
		beq.s	.NoNoiseDLock
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOCurrentDir(a6)
.NoNoiseDLock:	move.l	d6,d1
		beq.s	.FreeEngineDir
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOUnLock(a6)

.FreeEngineDir:	move.l	(a7)+,d1
		tst.l	d1
		beq.s	.NoEngineDir
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnlock(a6)

.NoEngineDir:	move.w	#1,Ripperloaded(a5)
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: a4=FIB
*	 d6=Handle
LadeNunRipper:
		movem.l	d0-a6,-(a7)

		move.l	a4,d2
		move.l	d6,d1			;Error beim Lock holen
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOExamine(a6)
		tst.l	d0
		beq.w	.Return


		lea	FirstRipper(a5),a2
.ExNext:	move.l	d6,d1			*Handle
		move.l	a4,d2
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOExNext(a6)
		tst.l	d0
		beq.w	.Return

		bsr	AllocERStruct
		beq.w	.Error

		*--- Namen kopieren ---*
		lea	fib_filename(a4),a0
		move.l	a0,d1
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOLoadSeg(a6)
		move.l	d0,ER_Segment(a3)
		tst.l	d0
		beq.w	.Error

		*---- Testen, ob Segment erlaube ist --*
		addq.l	#1,d0
		asl.l	#2,d0
		move.l	d0,a0


		*--- Eagleplayerripper ? ---*
		cmp.l	#$70ff4e75,(a0)
		bne.w	.Error
		cmp.l	#"EP_R",8(a0)
		bne.w	.Error
		cmp.l	#"IPPE",12(a0)
		bne.w	.Error
		cmp.l	#"RMOD",16(a0)
		bne.w	.Error
		cmp.l	#"ULE"<<8,20(a0)
		bne.w	.Error
		move.l	4(a0),ER_Tags(a3)

		*--- Nun fr ER_Struct fllen ---*
		move.l	ER_Tags(a3),a6
		move.l	#RPT_RequestRipper,d0
		bsr	FindTag
		move.l	a6,d1
		cmp.l	#RipperVersion,d1
		bhi.s	.FreeSegment

.SubRipper:	move.l	ER_Tags(a3),a6
		move.l	#RPT_Formatname,d0
		bsr	FindTag
		move.l	a6,ER_Rippername(a3)

		move.l	ER_Tags(a3),a6
		move.l	#RPT_Eaglebase,d0
		bsr	FindTag
		tst.l	d2
		beq.s	.NoEagleBase
		move.l	EUS_Structure+EUS_EPBase(pc),(a6)

.NoEaglebase:	*-- in Liste einfgen --*
		move.l	(a2),d0
		move.l	a3,(a2)
		move.l	d0,(a3)
		move.l	a3,a2


		*--- Test auf Subripper ---*
		move.l	ER_Tags(a3),a6
		move.l	#RPT_Next,d0
		bsr	FindTag
		beq.w	.ExNext

		bsr	AllocERStruct
		beq.w	.Error
		move.l	a6,ER_Tags(a3)
		bra.w	.SubRipper


.FreeSegment:	move.l	ER_Segment(a3),d1
		beq.s	.Error
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOUnLoadSeg(a6)
		clr.l	ER_Segment(a3)
.Error:		bsr	FreeERStruct
.NoFree		bra.w	.ExNext

.Return:	movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
* Input: --
* Output:d0/a3
AllocERStruct:	movem.l	d1-a2/a4-a6,-(a7)
		moveq	#ER_SizeOF,d0
		move.l	4,a6
		move.l	#$10000,d1
		jsr	_LVOAllocMem(a6)
		move.l	d0,a3
		tst.l	d0
		beq.s	.Return
		move.l	#ER_SizeOF,ER_StructSize(a3)
.Return:	movem.l	(a7)+,d1-a2/a4-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: a3=Struct
* Output:d0/a3
FreeERStruct:	movem.l	d0-a6,-(a7)
		move.l	a3,a1
		move.l	ER_StructSize(a3),d0
		beq.s	.Return
		move.l	4,a6
		jsr	_LVOFreeMem(a6)
.Return:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
FindTag:
FindTag2:	move.l	d3,-(a7)
		move.l	a7,d3

	*--------- Recursive FindTag-Routine ----------*
FindTag3:	moveq	#0,d2
		cmp.l	a6,d2
		beq.s	.Empty
		move.l	(a6)+,d2			;Tag rauslesen
		bne.s	.NoEmpty
.Empty:		cmp.l	d3,a7				;ak. Stack vergleichen
		beq.s	.TagNoFound
		move.l	(a7)+,a6
		bra.b	.NoMore
.NoEmpty:	cmp.l	d2,d0
		beq.s	.TagFound

	*----- Tag-Skip gefunden ???? -----*
		cmp.l	#Tag_Skip,d2
		bne.s	.NoSkip
		addq.l	#8,a6				;Diesen und nchsten
		addq.l	#4,a6				;Tag berspringen
		bra.s	.NoMore

	*------ Tag-More gefunden ???? -----*
.NoSkip:	cmp.l	#Tag_More,d2
		bne.s	.NoMore

		move.l	a6,-(a7)		;Adr der Tagliste sichern
		move.l	(a6),a6			;Neue Tagliste setzen
		bra.b	FindTag3
.NoMore:	addq.l	#4,a6
		bra.s	FindTag3
.TagFound:	move.l	(a6),a6
		move.l	a6,d2
.TagNoFound:	move.l	d3,a7
		move.l	(a7)+,d3
		tst.l	d2
		bne.s	.NoNull
		sub.l	a6,a6
.NoNull:	tst.l	d2
		rts



*----------------------------------------------------------------------------*
		ifeq	Executable
TextRequest:	movem.l	d1-a6,-(a7)
		move.l	EUS_Structure+EUS_EPBAse(pc),a5
		moveq	#0,d3
		lea	MyReqToolsName(pc),a1
		move.l	4,a6
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,a6
		tst.l	d0
		beq.s	.NoReq

		*---- ReqTools-Request ----*
		* Output: d0=Nummer des Gadgets
		*	  0 = ganz rechts
		*	  1 = von links nach rechts
		lea	TextRequestTags,a0	;Tags fr Textrequest
		move.l	EPG_Arg1(a5),a1		;Text
		move.l	EPG_Arg4(a5),a2		;Gadgetlist
		move.l	EPG_Arg6(a5),a4		;APTR to Arglist
		sub.l	a3,a3			;Reqtoolsinfo
		jsr	_LVOrtEZRequestA(a6)
		move.l	d0,d3

.CloseReq:	move.l	a6,a1
		move.l	4,a6
		jsr	_LVOCloseLibrary(a6)
.NoReq:		move.l	d3,d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts
TextRequestTags:dc.l	_RT_Underscore,"_"
		dc.l	0
MyReqToolsname:	dc.b	"reqtools.library",0
		even
		endc


*----------------------------------------------------------------------------*
*----------------------------------------------------------------------------*
*----------------------------------------------------------------------------*
*----------------------------------------------------------------------------*
	*------- Activate ------*
EP_Menu:	dc.l	EPM_Barlabel		;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$5B
		dc.l	0
		dc.l	.ActivateIText
		dc.l	0
		dc.b	0
		ds.b	7
		dc.l	0			*Kick2.04
.ActivateIText:	dc.b	0,3
		ds.w	2
		dc.w	1
		dc.l	0			*Topaz80
		dc.l	0			*Active.MSG (filled by EP)
		dc.l	0
		dc.w	EPNr_MainWindow	*EPNr_Engine
		dc.w	LNr_Active

	*------- Barlabel 1 ------*
EPM_Barlabel:	dc.l	EPM_Pass1		;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	6			;Hight-Size
		dc.w	$c0
		dc.l	0
		dc.l	.BarlabelImage
		dc.l	0
		dc.b	0
		ds.b	7
		dc.l	0			*Kick2.04
.BarlabelImage:	dc.b	0,2			*FronPen/BackPen
		dc.w	2,0			*DrawMode/KludgeFill // LeftEdge
		dc.w	2			*TopEdge
		dc.l	0			*Font
		dc.l	1			*ITIText
		dc.l	0			*NextText
		dc.w	0			*EPNr
		dc.w	0			*LocaleNr

	*--------- Pass 1 ---------*
EPM_Pass1:	dc.l	EPM_Pass2		;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$15B
		dc.l	0
		dc.l	.ActivateIText
		dc.l	0
		dc.b	0
		ds.b	7
		dc.l	0			*Kick2.04
.ActivateIText:	dc.b	0,3
		ds.w	2
		dc.w	1
		dc.l	0			*Topaz80
		dc.l	Pass1.MSG		*Active.MSG (filled by EP)
		dc.l	0
		dc.w	EPNr_Er_Pass1		*EPNr_Engine
		dc.w	LNrE_Pass1

	*--------- Pass 2 ---------*
EPM_Pass2:	dc.l	EPM_Barlabel2 *EPM_Pass3		;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$5B
		dc.l	0
		dc.l	.ActivateIText
		dc.l	0
		dc.b	0
		ds.b	7
		dc.l	0			*Kick2.04
.ActivateIText:	dc.b	0,3
		ds.w	2
		dc.w	1
		dc.l	0			*Topaz80
		dc.l	Pass2.MSG
		dc.l	0
		dc.w	EPNr_Er_Pass2		*EPNr_Engine
		dc.w	LNrE_Pass2

	*---------- Pass 3 ---------*
EPM_Pass3:	dc.l	EPM_Barlabel2		;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$5B
		dc.l	0
		dc.l	.ActivateIText
		dc.l	0
		dc.b	0
		ds.b	7
		dc.l	0			*Kick2.04
.ActivateIText:	dc.b	0,3
		ds.w	2
		dc.w	1
		dc.l	0			*Topaz80
		dc.l	Pass3.MSG		*Active.MSG (filled by EP)
		dc.l	0
		dc.w	EPNr_Er_Pass3		*EPNr_Engine
		dc.w	LNrE_Pass3


	*------- Barlabel 2 ------*
EPM_Barlabel2:	dc.l	EPM_SecurityMode	;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	6			;Hight-Size
		dc.w	$c0
		dc.l	0
		dc.l	.BarlabelImage
		dc.l	0
		dc.b	0
		ds.b	7
		dc.l	0			*Kick2.04
.BarlabelImage:	dc.b	0,2			*FronPen/BackPen
		dc.w	2,0			*DrawMode/KludgeFill // LeftEdge
		dc.w	2			*TopEdge
		dc.l	0			*Font
		dc.l	1			*ITIText
		dc.l	0			*NextText
		dc.w	0			*EPNr
		dc.w	0			*LocaleNr

	*---------- SecurityMode ---------*
EPM_SecurityMode:dc.l	0			;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$5B
		dc.l	0
		dc.l	.ActivateIText
		dc.l	0
		dc.b	0
		ds.b	7
		dc.l	0			*Kick2.04
.ActivateIText:	dc.b	0,3
		ds.w	2
		dc.w	1
		dc.l	0			*Topaz80
		dc.l	SecurityMode.MSG	*Active.MSG (filled by EP)
		dc.l	0
		dc.w	EPNr_Er_SecurityMode	*EPNr_Engine
		dc.w	LNrE_SecurityMode


*-----------------------------------------------------------------------------*
LocaleTable:	dc.w	LNrE_Ripping
		dc.l	Ripping.MSG
LA_Ripping:	dc.l	0

		dc.w	LNrE_Unknown
		dc.l	Unknown.MSG
LA_Unknown:	dc.l	0

		dc.w	LNrE_Security1
		dc.l	Security1.MSG
LA_Security1:	dc.l	0

		dc.w	LNrE_Security2
		dc.l	Security2.MSG
LA_Security2:	dc.l	0

		dc.w	LNrE_ER_SecurityGadgets
		dc.l	Gadgets.MSG
LA_Gadgets:	dc.l	0

		dc.w	LNr_Fr_SaveModule
		dc.l	0
LA_Fr_SaveModule:dc.l	0

		dc.w	LNr_Sw_SaveModule
		dc.l	0
LA_SW_SaveModule:dc.l	0

		dc.w	0


*-----------------------------------------------------------------------------*
Puffer		ds.b	PufferEnd

*------------------------------- Catalogtexte --------------------------------*
SecurityMode.MSG:dc.b	"Securitymode",0
Pass1.MSG:	dc.b	"Pass 1",0
Pass2.MSG:	dc.b	"Pass 2",0
Pass3.MSG:	dc.b	"Pass 3",0
Ripping.MSG:	dc.b	"Ripping %s",0

*--------------------------- Informationstexte -------------------------------*
Eaglerippers:	dc.b	"Eaglerippers",0
MyMenuName:	dc.b	"Eagleripper",0
MyCreatorname:	dc.b	"Eagleeye of DEFECT",0
MySpecialInfo:	dc.b	"This engine searchs modules in files or memory to "
		dc.b	"play it with Eagleplayer.",0
Security1.MSG:	dc.b	"Eagleripper has found a module.",10,10
		dc.b	"Formatname: %s",10
		dc.b	"Modulename: %s",10
		dc.b	"Filesize  : %ld Bytes",10,10
		dc.b	"Please select your option!",0
Security2.MSG:	dc.b	"Eagleripper has found a module.",10,10
		dc.b	"ATTENTION: THE SIZE CAN'T BE",10
		dc.b	"CALCULATED CORRECTLY!",10,10
		dc.b	"Formatname: %s",10
		dc.b	"Modulename: %s",10
		dc.b	"Filesize  : %ld Bytes",10,10
		dc.b	"Please select your option!",0
Unknown.MSG:	dc.b	"Unknown",0
Gadgets.MSG:	dc.b	"_Play|_Continue|_Save|C_ancel",0

		ifeq	Executable
Fr_SaveModule.MSG:dc.b	"Save module",0
Sw_SaveModule.MSG:dc.b	"Save module",0
Enginedir	dc.b	"EP:Engines",0
		endc

		even
		ifeq	Executable
data:	
		incdir	modules:
		*incbin	Mod.Agnostica.exam		;Example
		*incbin	Mod.Agnostica.exa2		;Example
		*incbin	Mod.Agnostica			;Example
		*incbin	S+S.Oriental
		incbin	TheSign.exe

		*incdir	"Modules:Trackerclones/"
		*incbin	"HCD.Blue_Vibrations"
		*incbin	"HCD.South Of Sense"
		*incbin	"KURT.Heavy_Metal"

		*incdir	"Modules:Verschiedenes/"
		*incbin	"JO.Guldkorn_Ingame"
		*incbin	"JO.Guldkorn_Intro"

		*incdir	"Modules:Verschiedenes/"

		*incbin	"BD.Motorhead 1"
		*incbin	"BD.Motorhead 2"
		*incbin	"BD.Motorhead 3"

		*incdir	"Modules:ADPCM-IFF-MPEG-Wave/"

		*incbin	IFF.Anrufb.Anonym             
		*incbin	IFF.Anrufb.Beatles            
		*incbin	IFF.Anrufb.BeichtStuhl        
		*incbin	IFF.Anrufb.Blhm_Anruf        
		*incbin	IFF.Anrufb.Boney_M            
		*incbin	IFF.Anrufb.Der_Hund           
		*incbin	IFF.Anrufb.Faust              
		*incbin	IFF.Anrufb.Grizmek            
		*incbin	IFF.Anrufb.Hallervorden       
		*incbin	IFF.Anrufb.Kohl&Bush          
		*incbin	IFF.Anrufb.Kohl_English       
		*incbin	IFF.Anrufb.Magnum             
		*incbin	IFF.Anrufb.Mcp                
		*incbin	IFF.Anrufb.Moser              
		*incbin	IFF.Anrufb.Nasa               
		*incbin	IFF.Anrufb.Nutte              
		*incbin	IFF.Anrufb.Papst2             
		*incbin	IFF.Anrufb.Putze              
		*incbin	IFF.Anrufb.Ruehmann           
		*incbin	IFF.Anrufb.Todesstern         
		*incbin	IFF.Anrufb.Werners-Rhrich    
		*incbin	IFF.Anrufb.Willy              
		*incbin	IFF.Anrufp.Die_Prinzen        
		*incbin	IFF.Bundy-Titelsong           
		*incbin	IFF.Hupe                      
		*incbin	IFF.KitomerII                 


datasize	= *-data
		endc


