*****************************************************************************
**                                                                         **
** Engine: Eagleplayer classic GUI                                         **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 



*************************************************************************
* Was noch gar nicht geht:
*--------------------------
* - StringGadget/AbortGadget/Yes-NoGadget/Retry-CancelGadget (AddAGadget)
*************************************************************************
*************************************************************************
*             OLD Eagleplayer - G U I    for   Eagleplayer 2.0          *
* (C) 1995 Henryk "Buggs" Richter & Jan "Eagleeye" Blumenthal		*
*                              CODE PRIVATE !                           *
*************************************************************************
*************************************************************************

ver		macro
		dc.b	"1.2"
		endm
StructVer	macro
		dc.w	1,2
		endm
date		macro
		dc.b	"11-Dec-96"
		endm
StructDate	macro
		dc.b	11,12
		dc.w	1996
		endm

Test		= 0

	incdir	include:
	include	exec/exec_lib.i
	include	dos/dos_lib.i
	include	exec/libraries.i
	include	exec/interrupts.i
	include	libraries/diskfont_lib.i
	include	intuition/intuition.i
	include	intuition/intuition_LIB.i
	include	graphics/graphics_lib.i
	include	misc/BuggsMacros.i
	include	misc/EagleplayerEngine.i
	include	libraries/asl_lib.i
	include	libraries/asl.i

	include "intuition/icclass.i"
	include "intuition/classes.i"
        include "intuition/classusr.i"
        include "intuition/imageclass.i"
	include	libraries/utility_lib.i

;===========================================================================
;		Definitionen & Vereinbarungen 
;===========================================================================

GD_BalLeft	equ	EPNr_FirstExternal+0
GD_Voice1	equ	EPNr_FirstExternal+1
GD_Voice2	equ	EPNr_FirstExternal+2
GD_Voice3	equ	EPNr_FirstExternal+3
GD_Voice4	equ	EPNr_FirstExternal+4

Scroller	=	1
SCR_DefXPos	=	38
SCR_DefYPos	=	33
SCR_DefHeight	=	11
SCR_DefWidth	=	308

Time		=	0

StopByte	=1		;definitiv aufhren
RandByte	=0		;Text bis zum linken Rand scroll
RandByte2	="|"		;nchstes Zeichen bis zum linken Rand scroll

MaxVolume	= EP_MaxVolume+1
VolumeAuf	= MaxVolume
VolumeSteps	= $ffff*1/VolumeAuf
VolumePosi	= $ffff

BalanceAuf	= [EP_MaxVolume+1]*2
BalanceSteps	= $ffff*1/BalanceAuf
BalancePosi	= $7fff

SpeedSchritt	= 330			;25 Einheiten pro 1 Verschiebung
SpeedDefault	= 25			;Wert -50 
SpeedAuf	= 50
SpeedSteps	= $ffff/SpeedAuf
SpeedPosi	= $8001	;$ffff/Speedauf*SpeedDefault
	*------------- Breiten der Regler -------------*

Volumebreite	= 208	;199
Volumehohe	= 7
Balancebreite	= 208
Balancehohe	= 7
SpeedBreite	= 15	;11		????199
SpeedReglerHohe	= 9			;Hohe des Reglers
SpeedHohe	= 44			;Hohe des Pro-Gadgets fr Border
Prohohe		= 9			;Hohe des Pro-Gadgets fr Border

	*---------- Koordinaten der Gadgets -----------*
LinkerAnfang	= 4
BZ		= 1			;Zwischenraum zwischen Gadgets (Hori)
Hz		= 1			;Zwischenraum zwischen Gadgets (Verti)
Reihe1		= 11			;Abstand von oberer Reihe bis Gadget
Reihe2		= Reihe1+17+Hz		;Abstand von oberer Reihe bis 2.Gadget

		rsreset
		rs.b	LinkerAnfang
SpeedHori	rs.b	15+bz
Voice1Hori	rs.b	19+bz
AboutHori	rs.b	18+bz
PlayerWindowHori rs.b	19+bz
DefVolumeHori	rs.b	46+bz
VolumeHori	rs.b	Volumebreite+bz
IconifyHori	rs.b	18+bz

DefBalanceHori	= DefVolumeHori
FilterHori	= IconifyHori
BalanceHori	= VolumeHori

		rsreset
		rs.b	AboutHori
PrevModuleHori	rs.b	22+bz
PrevSongHori	rs.b	22+bz
PrevPatternHori	rs.b	30+bz
ReplaySongHori	rs.b	26+bz
PlayModuleHori	rs.b	24+bz
PlayFasterHori	rs.b	28+bz
NextPatternHori	rs.b	30+bz
NextSongHori	rs.b	22+bz
NextModuleHori	rs.b	22+bz
StopPlayHori	rs.b	23+bz
EjectModuleHori	rs.b	23+bz
DisketteHori	rs.b	29	;30	;+bz
BorderBreite	rs.b	0

Voice2Hori	= Voice1Hori
Voice3Hori	= Voice1Hori
Voice4Hori	= Voice1Hori

		rsreset
		rs.b	Reihe1
SpeedVerti	rs.b	0
Voice1Verti	rs.b	11
Voice2Verti	rs.b	11
Voice3Verti	rs.b	11
Voice4Verti	rs.b	11

StatusVerti	= Reihe1
AboutVerti	= Reihe1
PlayerWindowVerti = Reihe1
DefVolumeVerti	= Reihe1
DefBalanceVerti	= Reihe1+9
IconifyVerti	= Reihe1
FilterVerti	= Reihe1+9
PrevModuleVerti	= Reihe2
PrevSongVerti	= Reihe2
PrevPatternVerti= Reihe2
ReplaySongVerti	= Reihe2
PlayModuleVerti	= Reihe2
PlayFasterVerti	= Reihe2
NextPatternVerti= Reihe2
NextSongVerti	= Reihe2
NextModuleVerti	= Reihe2
StopPlayVerti	= Reihe2
EjectModuleVerti= Reihe2
DisketteVerti	= Reihe2
VolumeVerti	= Reihe1
VolumeTVerti	= Reihe1
BalanceTVerti	= Reihe1+9
BalanceVerti	= Reihe1+9

BorderLinks	= AboutHori
BorderOben	= DisketteVerti+14+Hz
BorderUnten	= BorderOben+9+Hz
TextLinks	= BorderLinks+5
TextOben	= BorderOben+1+hz

Col0		= 0
Col1		= 1
Col2		= 2
Col3		= 3

*--------------------------- Window-Koordinaten ------------------------*
WindowLeft	= 0
WindowTop	= 10
Defwidth	= Borderbreite+5-8
Defheight	= BorderUnten+3-11-2

win_breite	=	DefWidth


AlignH	macro
	and	#$ff,\1
	mulu	d6,\1
	divu	#100,\1
	add	d4,\1
	endm

AlignV	macro
	and	#$ff,\1
	mulu	d7,\1
	divu	#100,\1
	add	d5,\1
	endm

EB	macro
	if	test
	move.l	4,a6
	else
	move.l	4,a6
	endc
	ENDM

;===========================================================================
	section	0,code
;===========================================================================

	if	Test
		rsreset
		rs.b	EPG_SizeOf
SurfaceWaitBits	rs.l	1
PrivatEnde	rs.b	0


	bsr	OpenDefaultLibs
	bsr	FirstInit
	moveq	#1,d0
	bsr	OpenAWindow
	lea	PrivatPuffer,a5
	jsr	GetWaitMask
	lea	PrivatPuffer,a5
	move.l	d0,SurfaceWaitBits(a5)
	lea	Aboutmessage(pc),a0		;zu Printendes Zeichen
	bsr	PrintText
	lea	Aboutmessage(pc),a0		;zu Printendes Zeichen
	bsr	NewScrollText
	lea	PrivatPuffer,a5


Wait:
	lea	PrivatPuffer,a5
	move.l	SurfaceWaitBits(a5),d0	
	move.l	4,a6
;	jsr	_LVOWait(a6)
	move.l	SurfaceWaitBits(a5),d1		;No SurfaceBits
	move.l	d0,d2
	and.l	d1,d2
	beq.s	.NoSurface
	jsr	SignalReceived
	lea	PrivatPuffer,a5


.NoSurface:
	bsr	scrollen
	bsr	ShowTime
.lop
	jsr	GetMsg				;Output: d0=ActionNr
	lea	PrivatPuffer,a5
	cmp.w	#EPNR_Quit,d0
	beq.s	.Quit
	tst	d0
	bne	.lop
	bra.w	Wait

.Quit:	moveq	#1,d0
	jsr	CloseAWindow
	lea	PrivatPuffer,a5
	jsr	FreeUserPrg
	illegal

OpenDefaultLibs:
	lea	PrivatPuffer,a5
	lea	int(pc),a1
	moveq	#37,d0
	move.l	4,a6
	jsr	_LVOopenlibrary(a6)
	move.l	d0,DTG_Intuitionbase(a5)

	lea	graf(pc),a1
	moveq	#37,d0
	jsr	_LVOopenlibrary(a6)
	move.l	d0,DTG_GFXBase(a5)
	move.l	a5,EUS_Structure+EUS_EPBase
	rts

PrivatPuffer	ds.b	PrivatEnde
		even

*******************************************************************
		movem.l	d1-d7/a1-a6,-(a7)
		move.l	EUS_TagList(a1),-(a7)		;Tagliste auf Stack
*		move.l	LoadFileName(a5),a1	;Ist das Label richtig ?
		move.l	#EUT_CheckForPlayer,-(a7)	;Tag auf Stack
		jsr	UserCallUp
		addq.l	#8,a7
		movem.l	(a7)+,d1-d7/a1-a6
*		beq.s	.NextUPrg		;beq=kein Tag
*		tst.l	d0			;d0=Fehlernummer
*		bne.s	.NextUPrg
*		move.l	a0,d0
*		beq.s	.NextUPrg
*******************************************************************


UserCallUp2:	movem.l	d1-a6,-(a7)
		bsr	UserCallUp
		movem.l	(a7)+,d1-a6
		rts

	*------- Auf Stack in -8 liegt Tag und -12 die Tagliste --------*
UserCallUp:	subq.l	#8,a7
		movem.l	d0/d2/a6,-(a7)
		move.l	12+8+8(a7),d0		;Liste
		beq.s	.NoList
		move.l	d0,a6
		move.l	12+8+4(a7),d0		;Tag
		bsr	FindTag2
;	moveq	#1,d2
;	lea	CheckForPlayer,a6
		tst.l	d2
		bne.s	.TagDa
.NoList:	movem.l	(a7)+,d0/d2/a6
		addq.l	#8,a7
		tst.l	8(a7)			;Liste ist leer
		rts

.TagDa:		move.l	#.UserReturn,16(a7)
		move.l	a6,12(a7)
		movem.l	(a7)+,d0/d2/a6
		rts

.UserReturn:	tst.l	8(a7)			;Z-Flag setzen (Liste da)
		rts


	*-----------------------------------------------------*
	*----------- Find-Tag Used Register d0/d2/a6 ---------*
	*-----------------------------------------------------*
FindTag2:	move.l	d3,-(a7)
		move.l	a7,d3

	*--------- Recursive FindTag-Routine ----------*
FindTag3:	moveq	#0,d2
		cmp.l	a6,d2
		beq.s	.Empty
		move.l	(a6)+,d2			;Tag rauslesen
		bne.s	.NoEmpty
.Empty:		cmp.l	d3,a7				;ak. Stack vergleichen
		beq.s	.TagNoFound
		move.l	(a7)+,a6
		bra.b	.NoMore
.NoEmpty:	cmp.l	d2,d0
		beq.s	.TagFound

	*----- Tag-Skip gefunden ???? -----*
		cmp.l	#Tag_Skip,d2
		bne.s	.NoSkip
		addq.l	#8,a6				;Diesen und nchsten
		addq.l	#4,a6				;Tag berspringen
		bra.s	.NoMore

	*------ Tag-More gefunden ???? -----*
.NoSkip:	cmp.l	#Tag_More,d2
		bne.s	.NoMore

		move.l	a6,-(a7)		;Adr der Tagliste sichern
		move.l	(a6),a6			;Neue Tagliste setzen
		bra.b	FindTag3
.NoMore:	addq.l	#4,a6
		bra.s	FindTag3
.TagFound:	move.l	(a6),a6
		move.l	a6,d2
.TagNoFound:	move.l	d3,a7
		move.l	(a7)+,d3
		tst.l	d2
		bne.s	.NoNull
		sub.l	a6,a6
.NoNull:	tst.l	d2
		rts

	endc

*-----------------------------------------------------------------------------*
*-----				Start Programm				------*
*-----------------------------------------------------------------------------*
;UserStartPrg
EUS_Structure:	moveq	#-1,d0				;EUS_Jump
		rts
		EUSN_Identifier				;EUS_Identifier
		dc.l	0				;EUS_Next
		dc.w	0				;EUS_Usernr
EPBase		dc.l	0				;EUS_EPBase
		dc.l	0				;EUS_FreeTable
		dc.l	0				;EUS_TaskAdr = NULL
		dc.l	0				;EUS_UnUsed1
		dc.l	0				;EUS_UnUsed2
		dc.l	0				;EUS_UnUsed3
		dc.l	TagListe			;EUS_Taglist
		dc.w	0				;EUS_Ticks
		dc.w	0				;EUS_TickCounter
		dc.l	EUIB_OnlyActive			;EUS_TickFlags
		dc.l	0				;EUS_MsgFlags
		dc.l	MyProzessName			;EUS_PName
		dc.l	MyCreatorname			;EUS_Creator
		dc.l	MySpecialInfo			;EUS_AboutUPRG
		dc.w	37				;EUS_Kickstart
		dc.l	10				;EUS_EPVersion
		structver				;EUS_Version,EUS_Revision
		dc.l	MyMenuName			;EUS_Username
		dc.w	0				;EUS_WinX
		dc.w	14				;EUS_WinY
		dc.w	EUSB_Openwin			;EUS_Flags
		dc.w	0			;EUS_Special  -> InnerWidth
		dc.w	0			;EUS_Special+2 -> InnerHeigth
		dc.l	0				;EUS_Special2
Winflags	equ	EUS_Special2		;Byte Flags frs Window
Time_mode	equ	EUS_Special2+1		;Byte Modus der Zeitanzeige

		dc.l	0				;EUS_Special3
		structdate				;EUS_Creatordate
		dc.b	0				;EUS_Prioritt
		dc.b	EUTY_MainWindow			;EUS_Type
		dc.w	0				;EUS_Reserved2
		dc.l	0				;EUS_Reserved3
		dc.l	0				;EUS_Reserved4
		dc.l	0				;EUS_Reserved5
		dc.l	0				;EUS_Reserved6
		ifne	(*-EUS_Structure)-EUS_SizeOF
		Aber Hallo
		endc

	dc.b	"$VER: Eagleplayer1x-GUI "
	ver
	dc.b	" ("
	date
	dc.b	")",0
	even
*----------------------------------------------------------------------------*
TagListe:	dc.l	EUT_InitEngine,FirstInit
		dc.l	EUT_ExitEngine,FreeUserPrg
		dc.l	EUT_OpenAWindow,OpenAWindow
		dc.l	EUT_CloseAWindow,CloseAWindow
		dc.l	EUT_DeActivate,CloseAWindow
*		dc.l	EUT_SetMenuStrip,SetMenuStrip
*		dc.l	EUT_ClearMenuStrip,ClearMenuStrip
		dc.l	EUT_GetMsg,GetMsg
		dc.l	EUT_GetWaitMask,GetWaitMask
		dc.l	EUT_EnableAll,EnableAll
		dc.l	EUT_DisableAll,DisableAll
		dc.l	EUT_GetConfig,GetConfig
		dc.l	EUT_NewConfig,NewConfig
	*	dc.l	EUT_UpdateVER,UpdateEPText		;|| Was soll das noch ?
	ifne	Scroller
		dc.l	EUT_NewScrollText,NewScrollText
		dc.l	EUT_PrintText,PrintText
		dc.l	EUT_Interrupt,ScrollANDTime
		dc.l	EUT_ClearTextWindow,ClearTextWindow
	endc
		dc.l	EUT_SignalReceived,SignalReceived
		dc.l	EUT_GetWindowHandle,GetWindowHandle
		dc.l	EUT_GetInterruptMask,GetInterruptMask

	*	dc.l	EUT_AddGadget,AddAGadget
	*	dc.l	EUT_RemoveGadget,RemoveAGadget
		dc.l	EUT_GetAbortMsg,GetAbortMsg
		dc.l	EUT_ChangeGui,ChangeGui		;nur Zustnde
		dc.l	EUT_ChangePrefs,ChangePrefs	;Zustnde,Slider
							;mit Refresh
		dc.l	EUT_GetPrefs,GetPrefs
*		dc.l	EUT_GetGuiMenuStrip,GetMenuStrip	;derzeit unbenutzt
*		dc.l	EUT_FreeGuiMenuStrip,FreeMenuStrip

		dc.l	EUT_InitDisplay,InitCrunchDisplay
		dc.l	EUT_FillDisplay,CrunchDisplay
		dc.l	EUT_RemoveDisplay,EndCrunchDisplay

		dc.l	EUT_SpecialinfoLNr,LNrE_SpecialInfo_Eagleplayer1Gui
		dc.l	0

*----------------------------------------------------------------------------*
FirstInit:	move.l	4,a6
		cmp.w	#37,LIB_Version(a6)	;EXEC V37 ?
		blo	Raus			;nein,raus
		lea	Datas,a5		;BSS lschen
		move.l	a5,a0
		move.w	#Dataslen-1,d0
.clr		clr.b	(a0)+
		dbf	d0,.clr

		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	DTG_Intuitionbase(a4),IntSave(a5)
		move.l	DTG_GFXBase(a4),GrafSave(a5)

		move	#10,SCR_font_max(A5) 
					;!! Wichtig: Inititalwert !!!!!!!!!
					;wegen Fontrequest immer einen
					;definierten Wert hier drin, wenn
					;zu gro fr die aktuelle Scroller-
					;gre, wird das eh abgefangen

		move.w	#Reihe1,lastbordertop(a5)
		move.w	#linkerAnfang,lastborderleft(a5)

		lea	Voice1Gadget(pc),a0
		move.l	a0,d4
		moveq	#0,d5
.positionloop
		move.l	d4,a0
		addq	#1,d5
		move.l	gg_NextGadget(a0),d4
		bne.s	.positionloop

		lea	Voice1Gadget(pc),a1
		move.l	a1,GD_FirstGadget(a5)
		move	d5,GD_Count(A5)

		suba.l	a1,a1
		EB
		jsr	_LVOFindTask(a6)
		move.l	d0,Mytask(a5)

		lea	Util(pc),a1
		moveq	#37,d0
		jsr	_LVOOpenlibrary(a6)
		move.l	d0,Utility(a5)
		tst.l	d0
		beq	NoUTL

		lea	Diskf(pc),a1
		moveq	#33,d0
		jsr	_LVOOpenlibrary(a6)
		move.l	d0,DiskFont(a5)
		tst.l	d0
		beq	NoDISKF
		moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
FreeUserPrg:	lea	Datas,a5
		moveq	#EPST_MainWindow,d0
		bsr	closeAWindow

	ifne	Scroller
		sub.l	a0,a0
		bsr	SetNewText
	endc
	
		move.l	DiskFont(a5),d0
		beq	NoDiskF
		move.l	d0,a1
		EB
		jsr	_LVOcloselibrary(a6)

NoDISKF:	move.l	Utility(a5),d0
		beq	noUtl
		move.l	d0,a1
		EB
		jsr	_LVOcloselibrary(a6)

NoUtl:
Raus		moveq	#EPR_ErrorAddUserPrg,d0
		rts

*-----------------------------------------------------------------------------*
* Input: d0.w=Type des windows
*	 a0  =WindowName
*	 a1  =ScreenName
* Output:d0 = Error oder NULL
*-----------------------------------------------------------------------------*
OpenAWindow:	lea	Datas,a5
		cmp.w	#EPST_MainWindow,d0
		bne.s	NoMainWindow
		move.l	a0,Eaglename(a5)
		move.l	a1,Eaglename+4(a5)
		lea	EUS_Structure(pc),a4
		tst.l	WinHandle(a5)
		bne.s	.Ok

		bsr.w	AllocSignal

.SignalDa:	bsr.w	OpenWin
		tst.l	WinHandle(a5)
		beq.s	.FreeSignal
.OK:		moveq	#0,d0
		rts

.FreeSignal:	bsr.w	FreeSignal
.NoSignal:	moveq	#EPR_CantOpenWin,d0
		rts

NoMainWindow:	moveq	#EPR_ErrorInArguments,d0
		rts

NoMem:		moveq	#EPR_NotEnoughMem,d0
		rts

*-----------------------------------------------------------------------------*
GetWindowHandle:move.l Datas+WinHandle,d0
		rts

GetMenuStrip:	lea	GuiMenu,a0
		rts

*-----------------------------------------------------------------------------*
* Input: d0 = Type des Windows
* Output: --
*-----------------------------------------------------------------------------*
CloseAWindow:	lea	Datas,a5
		cmp.w	#EPST_MainWindow,d0
		bne.s	NoMainWindow
		tst.l	WinHandle(a5)
		beq.s	.NoWindow
		bsr.w	GetConfig
		bsr.w	CloseWin
		bsr.w	FreeSignal
.NoWindow:	moveq	#0,d0
		rts


**-----------------------------------------------------------------------------*
** Input: a1 = MenuStrip
** Output --
**-----------------------------------------------------------------------------*
*SetMenuStrip:	lea	Datas,a5
*		tst.w	MenuOn(a5)
*		bne.s	.NoSet
*		tst.l	NextSelect(a5)		;Bei SetMenuStrip wird
*		bne.s	.NoSet			;PD-Multiselect gelscht
*		move.l	WinHandle(a5),d0
*		beq.s	MenuNoWindow
*		move.l	d0,a0
*		move.l	IntSave(a5),a6
*		move.l	a1,MenuStrip(a5)
*		jsr	_LVOSetMenuStrip(a6)
*		move.w	#1,MenuOn(a5)
*.NoSet:		moveq	#0,d0
*		rts

**-----------------------------------------------------------------------------*
** Input: --
** Output: --
**-----------------------------------------------------------------------------*
*ClearMenuStrip:	lea	Datas,a5
*		tst.w	MenuOn(a5)
*		beq.s	MenuNoWindow
*		move.l	WinHandle(a5),d0
*		beq.s	MenuNoWindow
*		move.l	d0,a0
*		move.l	IntSave(a5),a6
*		jsr	_LVOClearMenuStrip(a6)
*MenuNoWindow:	clr.w	MenuOn(a5)
*		rts
*

*-----------------------------------------------------------------------------*
* Input: --
* Output: d0 = AktionsNr oder Null
*-----------------------------------------------------------------------------*
GetMsg:		lea	Datas,a5
		suba.l	a1,a1
		move.l	NextSelect(a5),d0		;Multiselect bei PDMenus
		bne.s	.NextSelect

		*--- Msg holen ---*
		EB
		move.l	Port(a5),d0
		beq.w	.Return
		move.l	d0,a0
		jsr	_LVOGetMSG(a6)
		tst.l	d0
		beq	.TestLastNummer

	*----------- Auswertung der Window-Message -----------*

		*----- Teste EP-Messages --------*
		* Die Message wird nicht replyed *
		* Closewindow,Vanillakey,Menupick*
		* werden abgefragt.		 *
		*--------------------------------*
		* Input: a0=Nextselect or NULL
		* 	 a1=Message oder NULL
		* Output:d0=EPNr oder NULL
		*	 d1=NextSelect
		*	 a1=Message oder NULL
		*	 d2/a2=Arg1
		*	 d3/a3=Arg2
		*-------------------------------*
		move.l	d0,a1				*Message
		moveq	#0,d0
.NextSelect:	move.l	d0,a0
		move.l	EPBase(pc),a4
	ifeq	test
		jsr	ENPP_GetEPNrfromMessage(a4)	* In: a1=Message
	else
		moveq	#0,d0
		moveq	#0,d1
	endc
		movem.l	d0/d2,-(a7)

		move.l	d1,NextSelect(a5)

		move.l	a1,d0
		beq.s	.NoMsg
		move.l	im_class(a1),d7
		move.w	im_code(a1),d5 		<-
		move.l	im_Iaddress(a1),d6 	<-
		move.w	im_qualifier(a1),a4
		EB
		jsr	_LVOReplyMsg(a6)
.NoMsg:		movem.l	(a7)+,d0/d2
		tst.l	d0
		bne.w	.Rts


	ifne	test
		cmp.l	#IDCMP_Closewindow,d7
		bne.s	.noclose
		moveq	#EPNR_Quit,d0
		bra.w	.Rts
.noclose
	endc

;	*-------------- Refresh the Window --------------------*
;	* kann wahrscheinlich raus, wegen Smartrefresh Fenster *
;.TestRefreshWindow:
;		cmp.l	#idcmp_refreshwindow,d7
;		bne.s	.TestNewSize
;		bra.w	GetMsg
;
;	*--------------- neue Windowgre ----------------*
;.TestNewSize:	cmp.l	#idcmp_newsize,d7
;		bne.w	.TestGadgetUp
;		bsr.w	ResizeWindow
;		bra.w	GetMsg

	*-------------- Gadget losgelassen ? ---------------*
.TestGadgetUp:	cmp.l	#idcmp_gadgetup,d7
		bne.w	.TestGadgetDown

		clr.l	LastNummer(a5)
		clr.l	LastNummerGadAdr(A5)

		move.l	d6,a1
		move.w	GG_GadgetID(a1),d0
		beq.w	GetMsg

		cmp.w	#EPNr_AboutModule,d0
		beq	.switchmanager

		cmp.w	#EPNr_NextPattern,d0
		beq	.return
		cmp.w	#EPNr_PrevPattern,d0
		beq	.return

		cmp.w	#EPNr_Volume,d0			;Beim loslassen nochmal Volume/Balance holen
		beq.w	.TestDownVolume
		cmp.w	#EPNr_Balance,d0
		beq.w	.TestDownBalance
		cmp.w	#EPNr_Speed,d0
		beq.w	.testdownspeed

		cmp	#GD_BalLeft,d0
		beq.w	.balleft

		cmp	#EPNr_Filter,d0
		beq.w	.toggleFilter

		cmp	#EPNr_Iconify,d0
		beq.w	.toggleIconify

		cmp	#EPNr_Play,d0
		beq.w	.togglePlay

		move.l	d2,d4
		moveq	#1,d2
		cmp	#GD_Voice1,d0
		beq.s	.SwitchVoices
		moveq	#2,d2
		cmp	#GD_Voice2,d0
		beq.s	.SwitchVoices
		moveq	#3,d2
		cmp	#GD_Voice3,d0
		beq.s	.SwitchVoices
		moveq	#4,d2
		cmp	#GD_Voice4,d0
		beq.s	.SwitchVoices
		move.l	d4,d2

		bra	.rts
.switchManager:
		lea	.Managername(pc),a0
		
		*-- a0=Enginename
.SetEngine:	move.l	EUS_Structure+EUS_EPBase(pc),a4
		lea	EPG_FirstUserStruct(a4),a3
.NextEngine:	move.l	(a3),d0
		beq.s	.LoadIt
		move.l	d0,a3
		move.l	UPrgS_Name(a3),a1
		jsr	ENPP_StringCmp(a4)
		beq.s	.Enable
		bra.s	.NextEngine

.Enable:	moveq	#EPNr_Engine,d0
		move.l	UPrgS_EngineNr(a3),d2
		moveq	#-1,d3
		bra	.rts

.LoadIt:	move.l	a0,a2
		jsr	ENPP_CalcStringSize(a4)
		move.l	d0,d2
		moveq	#0,d3
		moveq	#EPNr_LoadEngine,d0
		bra	.rts

.Managername:	dc.b	`Manager`,0
		even
;d2: Voicenummer
;A2: -1
;d3: Zustand 0 aus, 1 an, -1 toggle
.switchvoices
		move	#EPNr_Voices,d0
		movea.l	#-1,a2
		move.w	gg_flags(a1),d3
		and.l	#gflg_selected,d3
		lsr	#7,d3
		eor.b	#1,d3
		bra	.rts
.toggleIconify:
.togglePlay:
.toggleFilter
		moveq	#-1,d2
		bra	.rts
.balleft
		moveq	#0,d2
		move	#EPNr_Balance,d0
		bra	.rts
	*------------- Gadget runtergedrckt -------------*
.TestGadgetDown:
		cmp.l	#idcmp_gadgetdown,d7
		bne.w	.Return

		move.l	d6,a1
		move.w	GG_GadgetID(a1),d0
		move.l	d0,LastNummer(a5)
		move.l	a1,LastNummerGadAdr(A5)

		cmp.w	#EPNr_Volume,d0
		beq.s	.testdownvolume
		cmp.w	#EPNr_Balance,d0
		beq.s	.testdownBalance
		cmp.w	#EPNr_Speed,d0
		beq.s	.testdownspeed

		cmp.w	#EPNr_NextPattern,d0
		beq.s	.patt_2
		cmp.w	#EPNr_PrevPattern,d0
		bne	GetMSG
.patt_2
	ifeq	test
		move.l	d0,-(a7)
		move.l	EPBase(pc),a6
		move.l	DTG_Dosbase(a6),a6
		moveq	#10,d1
		jsr	_LVODelay(a6)
		move.l	(a7)+,d0
	endc
		bra.w	.rts

		;Posi des Sliders holen
.TestDownSpeed:
		bsr.s	.getpot
		mulu	#SpeedAuf,d2
		divu	#$ffff,d2
		and.l	#$ffff,d2
		subq	#1,d2
		sub.w	#Speedauf/2,d2
		move	#$ffff,d4
		exg.l	d2,d4
		sub.w	d4,d2
		moveq	#EPRMB_DownGadget!EPRMB_NoGuiInfo,d1
		bra.w	.VolReturn
.TestDownVolume:
		bsr.s	.getpot
		mulu	#maxvolume,d2
		divu	#$ffff,d2
		and.l	#$ffff,d2
.setprop
		addq	#1,d2
		moveq	#EPRMB_DownGadget!EPRMB_NoGuiInfo,d1

		cmp	#EP_Maxvolume,d2
		blt	.Volreturn
		move	#EP_Maxvolume,d2
		bra.w	.VolReturn
.TestDownBalance
		bsr.s	.getpot
		mulu	#Balanceauf,d2
		divu	#$ffff,d2
		and.l	#$ffff,d2
		addq	#1,d2
		sub.l	#MaxVolume,d2
		bra.s	.setProp
;Input:  A1: Gadget
;Output: d2: Value (0...$ffff)
.getPot
		push	d0/a1
		moveq	#0,d2
		move.l	gg_specialInfo(a1),d0
		beq	.setvalue
		move.l	d0,a1
		move	pi_flags(a1),d0
		and	#FREEVERT,d0
		beq.s	.hori
		move	pi_Vertpot(a1),d2
		bra.s	.setvalue
.hori		move	pi_Horizpot(a1),d2
.setvalue	pop	d0/a1
		rts

.TestLastNummer:
		move.l	LastNummer(a5),d0
		beq.w	.Return
		move.l	LastNummerGadAdr(A5),a1
;		beq.w	.Return
		
	ifeq	test
		push	d0/a1
		move.l	EPBase(pc),a6
		move.l	DTG_Dosbase(a6),a6
		moveq	#1,d1
		jsr	_LVODelay(a6)
		pop	d0/a1
	endc

		cmp.w	#EPNr_PlayFaster,d0
		beq.w	.Rts

		cmp.w	#EPNr_NextPattern,d0
		beq.s	.PattWait
		cmp.w	#EPNr_PrevPattern,d0
		beq.s	.PattWait

		cmp.w	#EPNr_Volume,d0
		beq.w	.TestDownVolume
		cmp.w	#EPNr_Balance,d0
		beq.w	.TestDownBalance
		cmp.w	#EPNr_Speed,d0
		beq.w	.testdownspeed

		bra.s	.return

.Pattwait
	ifeq	test
		move.l	d0,-(a7)
		move.l	EPBase(pc),a6
		move.l	DTG_Dosbase(a6),a6
		moveq	#1,d1
		jsr	_LVODelay(a6)
		move.l	(a7)+,d0
	endc
		bra	.rts

	*------------------ Keine Nummer -----------------*
.Return:	moveq	#0,d0
	*------------------ Nummer zurck ----------------*
.rts:		moveq	#0,d1			*Flags
.VolReturn:	rts


*-----------------------------------------------------------------------------*
* Testet, ob ESC gedrckt wurde.
* Alle anderen Messages werden erstmal ignoriert.
GetAbortMsg:	lea	Datas,a5

		*--- Msg holen ---*
		EB
		move.l	Port(a5),d0
		beq.w	.NoOne
		move.l	d0,a0
		jsr	_LVOGetMSG(a6)
		tst.l	d0
		beq	.NoOne

		*--------- Daten aus Message holen --------*
		move.l	d0,a1
		move.l	im_class(a1),d7
		move.w	im_code(a1),d5 		<-
		move.l	im_Iaddress(a1),d6 	<-
		move.w	im_qualifier(a1),d4
		EB
		jsr	_LVOReplyMsg(a6)

		cmp.l	#$200000,d7			*VANILLAKEY
		bne	.NoOne
		cmp.w	#$1b,d5
		bne.s	.NoOne
		moveq	#EPNr_Abort,d1
		bra.s	.Ok

.NoOne:		moveq	#0,d1
.Ok:		moveq	#0,d0
		rts


*-----------------------------------------------------------------------------*
* Input:  --
* Output: d0 = SignalMask (ohne InterruptMask)
*-----------------------------------------------------------------------------*
GetWaitMask:	moveq	#0,d0
		lea	Datas,a5
		move.l	Port(a5),d1
		beq.s	.NoPort
		move.l	d1,a0
		move.b	mp_sigbit(a0),d1
		bset	d1,d0
.NoPort:	rts

*-----------------------------------------------------------------------------*
* Input: --
* Output:d0 = Signalmask (ohne WaitMask)
*-----------------------------------------------------------------------------*
GetInterruptMask:
		moveq	#0,d0
		lea	Datas,a5
		move.l	ScrollSignal(a5),d3	;fr Interrupt
		bset	d3,d0
		rts

*-----------------------------------------------------------------------------*
* Input:	d0 = SignaleSet
* Output:	d0 = ActionNr oder Null
*-----------------------------------------------------------------------------*
SignalReceived:	lea	Datas,a5
		move.l	ScrollSignal(a5),d3	;fr Interrupt
		btst	d3,d0
		beq.w	.Return
	ifne	Scroller
		bsr	Scrollen
	endc
	ifne	time
		bsr	ShowTime
	endc
.Return:	rts				;GetMsg wird trotzdem
						;aufgerufen

ScrollANDTime:
	ifne	Scroller
		bsr	Scrollen
	endc
	ifne	Time
		bsr	ShowTime
	endc
		moveq	#0,d0	
		move.b	SCR_Enable(a5),d0		*Scroller erlaubt ?
		rts					*ReturnMsg fr EP
	ifne	time
ShowTime:
		lea	Datas,a5
		move.l	WinHandle(a5),d0	;Window berhaupt offen ?
		beq	.Break
		move.l	d0,a0

		move	Timecount(a5),d0
		addq	#1,d0
		and	#15,d0
		move	d0,Timecount(a5)
		bne.w	.Break

		move.l	GrafSave(A5),a6

		move.l	wd_RPort(A0),a4
		move.l	a4,a1

		moveq	#0,d0
		jsr	_LVOSetAPen(A6)			; set the pen

		move	TimeX(A5),d0
		move	TimeY(a5),d1
		move	d0,d2
		add	TimeWx(a5),d2
		move	d1,d3
		add	TimeWy(a5),d3
		subq	#2,d2
		subq	#2,d3
		addq	#1,d0
		addq	#1,d1
		move.l	a4,a1
		jsr	_LVOrectfill(A6)		;Hintergrund killen

		moveq	#1,d0
		move.l	a4,a1
		jsr	_LVOSetAPen(A6)			; set the pen

		move.l	SCR_FontAdr(a5),d0
		bne.s	.ok
		move	SCR_Fontheight(A5),d0
		bsr	SC_OpenFont	;entsprechenden Font ffnen (D0:Hhe)
		move.l	SCR_FontAdr(a5),d0
		beq	.break
.ok		move.l	a4,a1
		move.l	d0,a0

		jsr	_LVOSetFont(a6)

		bsr	.createLine			;in A0 String zurck, in D0 Lnge
		move.l	d0,d6
		beq.s	.break
		move.l	a0,a3
.stringloop
		move.l	d6,d0
		move.l	a4,a1
		move.l	a3,a0
		jsr	_LVOTextLength(a6)
		sub	TimeWx(A5),d0
		ble.s	.take
		subq	#1,d6
		ble.s	.break
		bra.s	.stringloop
.take
		neg	d0				;Max. Breite - Breite des Texts
		lsr	#1,d0				;Differenz / 2 = Offset

		move.l	SCR_FontAdr(A5),a2
		move.w	TF_Baseline(a2),d1		;Char Baseline = Y-Posi
		move	TimeWY(A5),d2			;zentrieren des Zeichens
		sub	SCR_TextAttr+ta_ysize(a5),d2	;in vertikaler Richtung
		ble.s	.skip				;wenn Zeichen kleiner als
		moveq	#0,d3				;max. Wert
		lsr	#1,d2
		addx	d3,d2
		add	d2,d1

.skip:
		add	TimeX(A5),d0
		add	TimeY(A5),d1
		move.l	a4,a1
		jsr	_LVOMove(A6)

		move.l	d6,d0
		move.l	a3,a0
		move.l	a4,a1
		jsr	_LVOText(A6)
.break
		rts
.createline
	lea	TimeTMP(A5),a0
	clr.b	(a0)

	move.b	Time_mode+EUS_Structure(pc),d0
	beq.s	.EPTime

	move.l	#`00:00`,(a0)+
	clr.b	(A0)
.ret
	lea	TimeTMP(A5),a0
	bsr	BerechStringsize
	rts
.EPTime
	move.l	EUS_Structure+EUS_EPBase(pc),a1
	move.l	EPG_CurrentTime(a1),d1
	ble.s	.ret
	divu	#60,d1
	move	d1,d0			;Minutes
	swap	d1			;Seconds
	and.l	#$ff,d1
	and.l	#$ffff,d0
	bsr	.long
	move.b	#`:`,(a0)+
	divu	#10,d1
	add.b	#`0`,d1
	move.b	d1,(a0)+
	swap	d1
	add.b	#`0`,d1
	move.b	d1,(a0)+
	clr.b	(A0)
	bra.s	.ret
.Long
	push	d0-d4/a1
	moveq	#8,d1
	lea	dectable(pc),a1
	moveq	#0,d4
.loopl
	moveq	#-1,d3
	move.l	-(a1),d2
.loop2l
	addq.b	#1,d3
	sub.l	d2,d0
	bcc.s	.loop2l
	add.l	d2,d0
	cmp.l	#1,d2
	beq.s	.okl
	tst.b	d4
	bne.s	.okl
	tst.b	d3
	beq.s	.nol
.okl
	moveq	#1,d4
	add.b	#`0`,d3
	move.b	d3,(a0)+
.nol
	dbf	d1,.loopl
	pop	d0-d4/a1
	rts

	endc

	ifne	Scroller
*-----------------------------------------------------------------------------*
*                bergabe eines neuen ScrolTextes                  	      *
* Input: A0 - Text, der gescrollt werden soll                       	      *
*		0 - terminiert = Text im Kreis scrollen (automatisch	      *
*                                ein Space bei Restart eingefgt)  	      *
*               1 - terminiert = sofort stoppen                 	      *
*               2 - terminiert = Text bis zum vorderen Rand scrollen,	      *
*                                sollte im Text ein `|` auftauchen, wird das  *
*                                darauffolg.                                  *
*                                Zeichen bis links an den Rand gescrollt      *
*-----------------------------------------------------------------------------*
* Input:  A0 = Text
* Output: --
*-----------------------------------------------------------------------------*
NewScrollText:	lea	Datas,a5
		bsr	SetNewText
		beq.s	.NoAdr
	ifeq	test
		lea	EPT_String(a0),a0
	endc
;		move.l	a0,0
		sf	SCR_Enable(A5)	;Scroller stop
		bsr	ClearBM		;Bitmap komplett lschen
		move.l	a0,SCR_ScrolText(A5)
		move.l	a0,SCR_ScrolCurr(A5)	;Aktueller Text

	*-------------- (Re)Initialisierung des Scrollers -------------*
		clr	SCR_maxoff(A5)	;zur Behebung von Offsetnderungen
		clr.w	SCR_Offset0(a5)	;Offsets fr links/rechts Plazierung der Zeichen
		move	SCR_font_max(a5),d0
		add	d0,d0
		move.w	d0,SCR_Offset1(a5)	;min. 2 Zeichen Platz
		clr.w	SCR_StepsLeft(a5)	;wieviele Schritte noch bis zum nchsten Char
		clr.w	SCR_NumSteps(a5)	;vieviele Schritte schon gescrollt wurde
		move.w	SCR_Width(A5),SCR_StopSteps(A5) ;wieviele Schritte noch bis
						;Stop, nur, damit Feld <>0
		sf	SCR_StopID(A5)		;Stop aus
		st	SCR_Enable(A5)	;Scroller start
.NoAdr:		rts

*----------------------------------------------------------------------------*
* Die Scrollroutine wird vom Eagleplayer aufgerufen. Registersichern ist     *
* nicht erforderlich.							     *
*----------------------------------------------------------------------------*
Scrollen:	lea	Datas,a5

		tst.b	SCR_Enable(a5)			;Scroller erlaubt ?
		beq	.break				;n, raus

		move.l	WinHandle(a5),d0	;Window berhaupt offen ?
		beq	.Break
		move.l	d0,a0
		move.w	MyHoehe1(a5),d0		;Window im ZIP-Modus ?
		cmp.w	WD_height(a0),d0
		beq.w	.Break

	*------------------ Nun scrollen ------------*
	
		move.l	SCR_ScrolCurr(a5),d2		;ScrolText
		beq.w	.break

		tst.l	SCR_RastPort+rp_BitMap(a5)	;RastPort berhaupt valid ?
		beq	.break				;n, Abbruch	

		subq	#1,SCR_StepsLeft(A5)		;neues Zeichen ?
		bgt.w	.nonew				;n..
		clr	SCR_StepsLeft(A5)		;zur Sicherheit

	*-----------------  Overflow Check ---------------*
		move	SCR_Offset1(a5),d0
	*	cmp.w	#Scrol_Breite+SCR_font_max*2+SCR_font_max*2,d0	;ori !

		move	SCR_font_max(A5),d1

		move	d1,d3
		lsl	#2,d3			;mal 4
		add.w	SCR_Width(A5),d3
		cmp	d3,d0

		blo.s	.nores						;ori

	*	sub.w	#Scrol_Breite+SCR_font_max*2,d0			;ori

		sub.w	SCR_width(A5),d0
		sub.w	d1,d0
		sub.w	d1,d0

		sub	SCR_maxoff(A5),d0		;justify
		move	d0,SCR_Offset1(a5)		;reset Position rechts
	;	sub	#SCR_font_max*2,d0
		sub	d1,d0
		sub	d1,d0
		move	d0,SCR_maxoff(a5)		;justify
		clr.w	SCR_Offset0(a5)			;reset Position links

	*------------- Neues Zeichen holen --------------*
.nores:		move.l	d2,a0		;ScrolText
.nextChar:	move.b	(a0)+,d0
		*bne.s	.Char
		*move.l	SCR_ScrolText(a5),a0
		*move.b	#` `,d0		;automatisch ein Space einfgen, bevor
					;Restart
.Char:		cmp.b	#StopByte,d0	;1=Stop nach Ende
		bne.s	.nodis
.disable:	clr.b	SCR_Enable(a5)
		bra	.break
.nodis:		cmp.b	#RandByte,d0	;0=Bis an vorderen Rand scrollen ->STOP
		bne.s	.nobisvorn
		subq.l	#1,a0			;selbes Zeichen
		moveq	#` `,d0			;Leerzeichen
		st	SCR_StopID(A5)
		bra.s	.id

.nobisvorn:	cmp.b	#RandByte2,d0	;`|`=Kennung: nchstes Zeichen bis vorn
		bne.s	.nostopID	;           scrollen

		push	a0			;wir wollen jetzt rauskriegen
		lea	-1(a0),a1		;wie
		move.l	SCR_ScrolText(a5),a0	;breit
		sub.l	a0,a1			;der
		move.l	a1,d0			;Text
					;ist, der vor dem Rest am linken Rand
		lea.l	SCR_RastPort(a5),a1	;steht, sprich
		move.l	GrafSave(A5),a6		;z.B. "Playing ", der
		jsr	_LVOTextLength(A6)	;dann mit rausgescrollt
		add.w	SCR_width(A5),d0	;werden muss, bevor
		move	d0,SCR_StopSteps(a5)	;der Scroller stoppt
		pop	a0
		st	SCR_StopID(A5)
		bra.s	.nextChar

.noStopID:	move.l	a0,SCR_ScrolCurr(a5)

	*-------------- Zeichen printen --------------*
.id:		move	SCR_Offset0(a5),d1
		bsr	PrintChar		;Zeichen an linke Seite printen
		add	d2,SCR_Offset0(A5)	;Posi fr nchstes Zeichen

		move	SCR_Offset1(A5),d1
		add	SCR_Width(a5),d1
		bsr	PrintChar		;selbes Zeichen an Rechten Rand printen
		move	d2,SCR_StepsLeft(A5)	;Breite des Zeichens

	*--------------- Ins Fenster bertragen --------*
.nonew:		bsr	IntoWindow
		addq	#1,SCR_Offset1(A5)      ;Position, von der ins Fenster kopiert wird

	*----------------- Zhler erhhen -------------*
		addq	#1,SCR_NumSteps(a5)	;wieviele Pixels schon geprintet wurden

		tst.b	SCR_StopID(A5)		;Stoppen, wenn am vorderen Rand ?
		beq.s	.nostop			;n

		move.w	SCR_NumSteps(a5),d1	;Rand erreicht ?
		cmp.w	SCR_StopSteps(a5),d1	;
		blo.s	.nostop			;

		sf	SCR_Enable(a5)		;yup, Scroller aus

.nostop:
.break:		rts

*-----------------------------------------------------------------------------*
* Input: a0=New TextStructAdr (vom Eagleplayer bekommen)
* Output:d0=New StructAdr
*-----------------------------------------------------------------------------*
SetNewText:	push	a0/a1/d1/a4/a6
		move.l	SCR_TextStructAdr(a5),d0
		move.l	a0,SCR_TextStructAdr(a5)
	ifeq	test
		move.l	d0,a4
.NextStruct:	move.l	a4,d0
		beq.s	.Return
		move.l	d0,a1
		move.l	(a1),a4
		move.l	EPT_StringSize(a1),d0
		beq.s	.StructFree
		EB
		jsr	_LVOFreeMem(a6)
.StructFree:	bra.b	.NextStruct
	endc
.Return:	pop	a0/a1/d1/a4/a6
		move.l	SCR_TextStructAdr(a5),d0		;Flags setzen
		rts

**-----------------------------------------------------------------------------*
** Input: d1=Bytesize
**	 a0=SourcePuffer
**	 a0=TargetPuffer
**Output: --
**-----------------------------------------------------------------------------*
*StringCopy:	tst.l	d1
*		blt.s	.Err
*.StringCopy2:	move.b	(a0)+,(a1)+
*		dbf	d1,.StringCopy2
*		clr.b	(a1)			;Null terminieren
*.Err		rts

***********************************************************************************************
*                              Progress Display Routines                                      *
***********************************************************************************************
;A0: EP_Text Struct
InitCrunchDisplay:
		lea	Datas,a5
		clr.b	SCR_Enable(A5)	;Scroller stop
		clr.l	SCR_LastPrinted(a5)
		bsr	PrintText

		tst.l	WinHandle(a5)
		beq.s	.Return
		bsr	ClearBM
.return
		clr	lastcrunchpos(A5)
		moveq	#0,d0
		rts
;--------------------------- Promille (1/1000) - Wert in D0 -----------------------------------
CrunchDisplay:
		lea	Datas,a5

		tst.l	WinHandle(a5)
		beq.s	.Return
;		bsr	ClearBM

		push	d0
		moveq	#3,d0
		lea.l	SCR_RastPort(a5),a1
		move.l	GrafSave(a5),a6
		jsr	_LVOSetAPen(A6)			; set the pen
		pop	d0

		cmp	#1000,d0			;Zur Sicherheit
		blo.s	.lo
		move	#1000,d0
.lo
		move	SCR_Width(A5),d2
		mulu	d0,d2
		divu	#1000,d2		;X Max

		move	lastcrunchpos(A5),d0	;X Min
		move	d2,lastcrunchpos(a5)

		cmp	d2,d0
		bge.s	.print

;		moveq	#0,d0			;X Min
		moveq	#0,d1			;Y Min
		move	SCR_font_max(A5),d3	;Y Max
		lea.l	SCR_RastPort(a5),a1
		jsr	_LVOrectfill(A6)		;Hintergrund killen
.print
		move.l	SCR_LastPrinted(a5),d0
		beq.s	.Return
		move.l	d0,a0

		moveq	#1,d7
		bra	Printtext2
.Return
		moveq	#0,d0			;kein Fehler...
		rts
EndCrunchDisplay:
		lea	Datas,a5
		tst.l	WinHandle(a5)
		beq.s	.NoWindow
		bsr	ClearBM
		bsr	IntoWindow
.NoWindow	rts

*-----------------------------------------------------------------------------*
* Input: a0=TextStructAdr
* Output:d0=Error oder NULL
*-----------------------------------------------------------------------------*
PrintText:
		moveq	#0,d7
		lea	Datas,a5

		bsr	SetNewText
		beq.w	NoMem
		lea	EPT_String(a0),a0

* Input: D7=0 - Hintergrund killen, sonst nicht
PrintText2:	move.l	a0,a4
		move.l	a0,SCR_LastPrinted(a5)

		tst.l	WinHandle(a5)
		beq.w	.NoWindow

		tst.w	d7
		bne.s	.noclear
		bsr	ClearBM
.noclear

		lea	SCR_RastPort(a5),a3
	*------------- Modus Jam1 wegen Crunchanzeige, damit Hintergrund bleibt ------*
		move.l	a3,a1
		moveq	#RP_JAM1,d0
		move.l	GrafSave(a5),a6
		jsr	_LVOsetDrMd(A6)

		move.l	a3,a1
		moveq	#1,d0				;Foreground
		jsr	_LVOSetAPen(A6)

		move.l	a3,a1
		moveq	#0,d0				;Background
		jsr	_LVOSetBPen(A6)

	*--------------- Position festlegen --------------*
		move.l	a3,a1
		moveq	#2,d0			;X-Posi
		move.l	SCR_FontAdr(a5),a2
		move.w	TF_Baseline(a2),d1	;Char Baseline = Y-Posi

		move	SCR_Font_Max(a5),d2		;zentrieren des Zeichens
		sub	SCR_TextAttr+Ta_YSize(a5),d2	;in vertikaler Richtung
		ble.s	.Skip				;wenn Zeichen kleiner als
		moveq	#0,d3				;max. Wert
		lsr	#1,d2
		addx	d3,d2
		add	d2,d1
.Skip:		move.l	GrafSave(a5),a6
		jsr	_LVOMove(a6)

	*--------------- Textlnge berechnen ----------------*
		move.l	a4,a0
		bsr	BerechStringSize
		move.l	d0,d3
		bra.s	.jumpin
.RetryIt:
		subq.l	#1,d3
		move.l	d3,d0
.jumpin
		move.l	d0,d6
		move.l	a3,a1
		move.l	GrafSave(a5),a6
		move.l	a4,a0
		jsr	_LVOTextLength(a6)

		move.w	SCR_Width(a5),d4	;Breite <- !!!!
		sub	SCR_LimitWidth(a5),d4	;minus Limit
		subq.l	#4,d4			;kleiner Rand links/rechts
		ble.s	.Error			;check!
		cmp.w	d0,d4
		blt.s	.RetryIt

		move.l	a3,a1
		move.l	a4,a0
		move.l	d6,d0
		jsr	_LVOText(a6)

		clr.w	SCR_Offset1(a5)
		bsr	IntoWindow

	*------------------- Scrollen verbieten ----------------*
		clr.b	SCR_Enable(a5)	;Scroller stop
.NoWindow:	moveq	#0,d0
		rts

.Error:		moveq	#EPR_UnknownError,d0
		rts


*-----------------------------------------------------------------------------*
* Input:  --
* Output: --
*-----------------------------------------------------------------------------*
ClearTextWindow:lea	Datas,a5
		clr.b	SCR_Enable(A5)	;Scroller stop
		clr.l	SCR_LastPrinted(a5)
		bsr	ClearBM				;Bitmap komplett lschen
		bsr	IntoWindow
		rts
	endc

*-----------------------------------------------------------------------------*
* Input: --
*Output: --
*-----------------------------------------------------------------------------*
EnableAll:	lea	Datas,a5
		tst.w	GadgetsDa(a5)
		bne.s	.None

		move.l	IntSave(a5),a6
		move.l	WinHandle(a5),d0
		beq.s	.None
		move.l	d0,a0
		move.l	GD_FirstGadget(a5),a1
		move.w	GD_Count(a5),d0
		beq.s	.None
		jsr	_LVOAddGList(a6)

		move.l	WinHandle(A5),a0
		jsr	_LVORefreshWindowFrame(a6)	;weil manchmal was ber steht

*		bsr	SetMenuStrip

		move.w	#1,GadgetsDa(a5)
.None:		rts

*-----------------------------------------------------------------------------*
* Input: --
*Output: --
*-----------------------------------------------------------------------------*
DisableAll:	lea	Datas,a5
		tst.w	GadgetsDa(a5)
		beq.s	.None
		move.l	IntSave(a5),a6
		move.l	WinHandle(a5),d0
		beq.s	.None
		move.l	d0,a0
		move.l	GD_FirstGadget(a5),a1
		move.w	GD_Count(a5),d0
		beq.s	.None
		jsr	_LVORemoveGList(a6)
.None:
*		bsr	ClearMenuStrip
		clr.w	GadgetsDa(a5)
		rts



*-----------------------------------------------------------------------------*
* Input:	d0 = 0 -> registriert
*		     1 -> nicht reg.
*		a0 = APtr auf ?.??	z.B 2.00
* Output: --
*-----------------------------------------------------------------------------*
;UpdateEPText:	lea	EPVer1(pc),a1
;		moveq	#3,d0
;.CopyIt:	move.b	(a0)+,(a1)+
;		dbf	d0,.CopyIt
;		rts

*-----------------------------------------------------------------------------*
* Input: in EUS
* Output: --
*-----------------------------------------------------------------------------*
NewConfig:	lea	Datas,a5
		bsr	CloseWin

		move.w	EUS_Structure+EUS_Flags(pc),d0
		btst	#EUSF_Openwin,d0
		bne.s	.NoOpen
		bsr	OpenWin
.NoOpen:	rts

*-----------------------------------------------------------------------------*
* Input: --
* Output: EUS_
*-----------------------------------------------------------------------------*
GetConfig:	lea	Datas,a5
		lea	EUS_Structure(pc),a4
		clr.w	EUS_Flags(a4)
		move.l	WinHandle(a5),d0
		beq.s	.NoWin
		move.w	#EUSB_Openwin,EUS_Flags(a4)
		move.l	d0,a0
		moveq	#0,d0
		move.w	Wd_LeftEdge(a0),d0
		move.w	d0,EUS_WinX(a4)
		move.w	Wd_TopEdge(a0),d0
		move.w	d0,EUS_WinY(a4)

		moveq	#0,d1
		move.w	Wd_Width(a0),d0
		move.b	WD_BorderLeft(a0),d1
		sub.w	d1,d0
		move.b	WD_BorderRight(a0),d1
		sub.w	d1,d0
		move.w	d0,EUS_Special(a4)

		move.w	Wd_Height(a0),d0
		move.b	WD_BorderTop(a0),d1
		sub.w	d1,d0
		move.b	WD_BorderBottom(a0),d1
		sub.w	d1,d0
		move.w	d0,EUS_Special+2(a4)
.NoWin:		moveq	#0,d0
		rts



*-----------------------------------------------------------------------------*
AllocSignal:	tst.l	ScrollSignal(a5)
		bne.s	.SignalDa
		moveq	#-1,d0
		EB
		jsr	_LVOAllocSignal(a6)	;2. Signal allokieren (fr Interrupt)
		tst.l	d0
		blt	.SignalDa
		move.l	d0,ScrollSignal(a5)
.SignalDa:	rts

*-----------------------------------------------------------------------------*
FreeSignal:	move.l	ScrollSignal(a5),d0
		beq.s	.NoSignal
		EB
		jsr	_LVOFreeSignal(a6)
.NoSignal:	clr.l	ScrollSignal(a5)
		rts


		
*-----------------------------------------------------------------------------*




************************************************************************
*                   Fenster ffnen                                     *
************************************************************************
Openwin:
		tst.l	winhandle(a5)
		bne.w	.NoPub
		
	move.l	EPBase(pc),a0
	move.w	EPG_Volume(a0),d0
	move	d0,Lastvolume(a5)
	mulu	#maxbody,d0
	divu	#maxvolume,d0
	move	d0,VolumeProp+pi_HorizPot

	move.w	EPG_Balance(a0),d0
	add.w	#EP_MaxVolume,d0
	mulu	#maxbody,d0
	divu	#BalanceAuf,d0
	move	d0,BalanceProp+pi_HorizPot

		move.l	IntSave(a5),a6
		move.l	EPG_PubScreen(a0),a0
		jsr	_LVOlockpubscreen(a6)	;aktuellen Publicscreen rauskriegen
		tst.l	d0
		beq	.Error			;sollte nicht auftreten
		move.l	d0,MyPubScreen(a5)	;fr UnLockpubscreen()
		move.l	d0,a1
		move.l	sc_font(a1),a0

		move.w	ta_ysize(a0),d0		;Hhe des Screenfonts
		move.w	d0,d1
		add.w	#3,d1			;Berechnen der Gre fr ZIPwindow()
		move.w	d1,myhoehe1(a5)		;und eintragen
	
		moveq	#0,d0
		lea	MyTags(a5),a1		;WINDOW INIT

		move.l	#wa_top,(a1)+
	clr.w	(a1)+
	move.w	EUS_Structure+EUS_WinY(pc),(a1)+

		move.l	#wa_left,(a1)+
	clr.w	(a1)+
	move.w EUS_Structure+EUS_WinX(pc),(a1)+

		move.l	#wa_innerwidth,(a1)+	;Breite
		move.l	#win_breite,(a1)+	;20Spalten+15*8Pixel fr Gadgets+Rand

		move.l	#wa_innerheight,(a1)+	;Hhe
		move.l	#defheight,d1
		move.l	d1,(a1)+
		move.w	d1,win_hoehe(a5)

		move.l	#wa_flags,(a1)+
	move.l	#Windowdrag!Windowdepth!Windowclose!nocarerefresh,(a1)+
	move.l	#WA_TITLE,(a1)+

	ifeq	test
	move.l	Eaglename(a5),(a1)+
	else
	lea	mywinname(pc),a0
	move.l	a0,(a1)+
	endc

	move.l	#WA_ScreenTitle,(a1)+
	move.l	Eaglename+4(a5),(a1)+

	move.l	#WA_PubScreenName,(a1)+
	move.l	EPbase(pc),a0
	move.l	EPG_PubScreen(a0),(a1)+

	move.l	#WA_Newlookmenus,(a1)+
	move.l	#1,(a1)+

		move.l	#wa_idcmp,(a1)+
  move.l	#idcmp_rawkey!idcmp_menupick!idcmp_newsize!gadgetup!gadgetdown!closewindow!vanillakey!refreshwindow,(a1)+
		move.l	#wa_autoadjust,(a1)+
		move.l	#1,(a1)+

;		move.l	#wa_maxwidth,(A1)+
;		move.l	#1400,(a1)+
;		move.l	#wa_maxheight,(a1)+
;		move.l	#450,(a1)+

;		move.l	#wa_minwidth,(A1)+
		move.l	MyPubScreen(a5),a0

;		move.b	sc_wborleft(a0),d0
;		add.b	sc_wborright(a0),d0
;		ext.w	d0
;		ext.l	d0
;		add.l	#Defminwidth,d0
;		move.l	d0,(a1)+
;
;		move.l	#wa_minheight,(A1)+

		move.b	sc_BarHeight(a0),d1
		add.b	sc_wborbottom(a0),d1
		ext.w	d1
		ext.l	d1
		addq	#1,d1			;wg. sc_barheight
;		add.l	#Defminheight,d1
;		move.l	d1,(a1)+

		move.l	#wa_zoom,(a1)+
		lea	MyZoom(a5),a0
		move.w	EUS_Structure+EUS_WinX(pc),(a0)
		move.w	EUS_Structure+EUS_WinY(pc),2(a0)
		move.w	#220,4(a0)		;Breite des Zip-Windows im SMALL-MODE
		move	d1,6(a0)
		move	d1,myhoehe2(a5)

		move.l	a0,(a1)+
		move.l	#TAG_DONE,(a1)+

		suba.l	a0,a0
		lea	MyTags(a5),a1
		move.l	IntSave(a5),a6
		jsr	_LVOOpenWindowTagList(a6)
		move.l	d0,WinHandle(a5)
		tst.l	d0
		bne.s	.WinOpened

		lea	MyTags(a5),a1		;Fehler,nochmal auf Position 0/0
		move.l	#wa_top,(a1)+		;zu ffnen versuchen
		move.l	#0,(a1)+
		move.l	#wa_left,(a1)+
		move.l	#0,(a1)+

		suba.l	a0,a0
		lea	MyTags(a5),a1
		move.l	IntSave(a5),a6
		jsr	_LVOOpenWindowTagList(a6)	;wirst DU wohl aufgehen !
		move.l	d0,WinHandle(a5)
		tst.l	d0
		beq.w	.Error
.winopened:	move.l	d0,a0
		move.l	WD_UserPort(a0),a0	;User Port
		move.l	a0,Port(a5)

	*------- restliche Gadgets erzeugen und ans Fenster anhngen -------*
		bsr	MakeMaingadgets
		tst.l	d0
		beq.w	.Error
		move.l	d0,a1
		moveq	#-1,d0
		moveq	#-1,d1
		suba.l	a2,a2
		move.l	WinHandle(A5),a0
		jsr	_LVOAddglist(A6)

	*----------------------------------------------------------------*
		move.w	#1,GadgetsDa(a5)		;Gadgets enabled

	*----------------------- Backfill -------------------------------*
		bsr	BackFill

	*--------------------------------------------------------------------------*
	ifne	Scroller
		bsr	PrintScrolRahmen	;Rahmen+Position/Gre

		push	d2-d7
		addq	#1,d2
		addq	#1,d3
		subq	#2,d4
		subq	#2,d5
		lea	XenName(pc),a0				;Font Name
		moveq	#8,d0					;Hhe
		bsr	SC_MakeRastPort				;neuen Scrol
		pop	d2-d7
		tst.l	d0
		beq.s	.Error
	endc


	*----------------------------------------------------------------*
		move.l	WinHandle(a5),a1
		suba.l	a2,a2
		move.l	WD_FirstGadget(a1),a0
		move.l	IntSave(A5),a6
		jsr	_LVORefreshgadgets(A6)

		move.l	WinHandle(A5),a0
		jsr	_LVORefreshWindowframe(A6)

.Error:		move.l	IntSave(a5),a6
		suba.l	a0,a0
		move.l	MyPubScreen(a5),d0
		beq.s	.NoPub
		move.l	d0,a1
		move.l	#0,MyPubScreen(a5)
		jsr	_LVOunlockpubscreen(a6)	;PUBscreen freigeben
.NoPub:		rts


*******************************************************************
*                   Window schlieen                              *
*******************************************************************
Closewin:	tst.l	WinHandle(a5)
		beq.s	.nowin
*		bsr	ClearMenuStrip

		bsr	GetConfig

	*----------------- Fenster schlieen ----------------------------*
		move.l	IntSave(a5),a6
		move.l	WinHandle(a5),a0
		clr.l	WinHandle(a5)
		clr.l	Port(a5)
		jsr	_LVOclosewindow(a6)

	*----------------------------------------------------*
		bsr	FreeMaingadgets
		bsr	SC_FreeRastPort		;Scroller freigeben

		move.l	MyPubscreen(a5),d0	;sichergehen,da Publicscreen frei
		beq.s	.ok
		move.l	d0,a1
		suba.l	a0,a0
		move.l	IntSave(A5),a6
		jsr	_LVOunlockpubscreen(a6)
		clr.l	MyPubScreen(a5)
.ok:
.Nowin:		rts

BackFill:
		push	all
		move.l	WinHandle(A5),a4
		move.l	WD_RPort(a4),a1

		moveq	#0,d0
		move.l	GrafSave(A5),a6
		jsr	_LVOSetAPen(A6)			; set the pen

		move.l	wd_rPort(a4),a1
		move.b	wd_borderleft(a4),d0
		ext.w	d0
		move.b	wd_bordertop(a4),d1
		ext.w	d1
		move.b	wd_borderright(a4),d2
		ext.w	d2
		neg.w	d2
		move.b	wd_borderbottom(a4),d3
		ext.w	d3
		neg.w	d3
		subq	#1,d2
		subq	#1,d3
		add.w	wd_width(a4),d2
		add.w	wd_height(a4),d3
		jsr	_LVOrectfill(A6)		;Hintergrund killen
		pop	all
		rts
;--------------------- Routinen des Scrollers --------------------------------
; Init:                         SC_MakeRastPort (Parameter beachten!)
; neuer Text:                   NewScroltext (a0 : Text als ASCII)
; Aufruf (einmal pro VBlank) :  ScrollNow
; End:                          SC_FreeRastPort
; Lschen: 			bsr ClearBM + bsr IntoWindow
;
;
; public Areas des Scrollers: (drfen auch vom EP verndert werden)
;
; SCR_Limitwidth.w              Anzahl der Pixels, um die die Breite kleiner
;                               geprintet werden soll
; sf	SCR_Enable(a5)		Scroller verboten (nur lschen!!,nicht setzen)
;
PrintScrolrahmen:
		move.l	WinHandle(A5),d0
		beq.w	PSR_Return

		move.l	d0,a0
		move.l	wd_rPort(a0),a4

		moveq	#0,d0
		move.b	wd_bordertop(a0),d7	;Fonts > 120 ?? glaube ich kaum...
		move.b	d7,d0
		add.b	wd_borderbottom(a0),d7
		ext.w	d7
		neg.w	d7
		add.w	wd_height(a0),d7	;WA_Innerheight :)

		move	#SCR_DefYPos,d2		;Ypos ScrolRahmen
		move	#SCR_DefHeight,d4	;Hhe ...
		mulu	d7,d2			;top
		mulu	d7,d4			;height
		divu	#defheight,d2		;def Wert
		divu	#defheight,d4		;def Wert
		add	d0,d2			;Border dazu

		move.b	wd_borderleft(a0),d6
		move.b	d6,d0
		add.b	wd_borderright(a0),d6
		ext.w	d6
		neg.w	d6
		add.w	wd_width(a0),d6		;WA_Innerwidth :)

		move	#SCR_DefXPos,d3		;Xpos Scrolrahmen
		move	#SCR_DefWidth,d5	;Breite ....
		mulu	d6,d3			;top
		mulu	d6,d5			;height
		divu	#DefWidth,d3		;def Wert
		divu	#DefWidth,d5		;def Wert
		add	d0,d3			;Border dazu

		move.l	GrafSave(A5),a6
		move.l	a4,a1
		moveq	#0,d0
		jsr	_LVOsetAPEN(A6)

		push	d0-d4
		move.l	a4,a1
		move	d3,d0
		move	d2,d1

		move	d0,d2
		add	d5,d2

		move	d1,d3
		add	d4,d3
		subq	#1,d2
		subq	#1,d3
		jsr	_LVOrectfill(A6)		;Hintergrund killen
		pop	d0-d4

		rts

print2:		move.l	a4,a1			; rPort to a1
		move	d3,d0
		move	d2,d1
		add	d4,d1
		subq	#2,d1
		jsr	_LVOmove(A6)

		move.l	a4,a1
		moveq	#1,d0
		jsr	_LVOsetAPEN(A6)

		move.l	a4,a1
		move	d3,d0
		move	d2,d1
		jsr	_LVODraw(A6)

		move.l	a4,a1
		move	d3,D0
		add	d5,D0
		subq	#1,D0
		move	d2,d1
		jsr	_LVODraw(A6)

		move.l	a4,a1
		moveq	#2,d0
		jsr	_LVOsetAPEN(A6)

		move.l	a4,a1
		move	d3,D0
		add	d5,D0
		subq	#1,D0
		move	d2,d1
		add	d4,d1
		subq	#1,d1
		jsr	_LVODraw(A6)

		move.l	a4,a1
		move	d3,D0
		move	d2,d1
		add	d4,d1
		subq	#1,d1
		jsr	_LVODraw(A6)
PSR_Return:	rts

**************************************************************************
*                     Font des Scrollers ndern                          *
**************************************************************************
* Input: a0=Name
*	 d1=Height
SC_SetFont:	*lea	NameTemp(a5),a0
		*move.w	Hoehetemp(A5),d0
		move	d1,d6

		lea	SCR_Fontname(a5),a1
.Cop:		move.b	(a0)+,(a1)+
		bne.s	.Cop

		move.b	SCR_enable(a5),d7
		sf	SCR_Enable(a5)		;Scroller verboten

		tst.l	SCR_RastPort+rp_BitMap(a5) ;RastPort berhaupt valid ?
		beq	.Error1			;n, Abbruch	

		move.l	SCR_FontAdr(a5),d0
		beq.s	.OK1
		clr.l	SCR_FontAdr(a5)
		move.l	d0,a1
		move.l	GrafSave(a5),a6
		jsr	_LVOCloseFont(a6)
.Ok1:		move	d6,d0
		bsr	SC_OpenFont
		beq.s	.error1

		move.l	SCR_FontAdr(a5),a0
		lea	SCR_RastPort(a5),a1
		move.l	GrafSave(A5),a6
		jsr	_LVOSetFont(A6)

		bsr	ClearBM			;Bitmap komplett lschen
		move.b	d7,SCR_Enable(a5)
.Error1:	rts

**********************************************************************
*      angegebenen Font ffnen, bei Fehler Topaz 8 nehmen            *
* Input:  SCR_Fontname: Name des Fonts als ASCII-Text                *
*                   D0: Hhe des Fonts                               *
**********************************************************************
SC_OpenFont:	push	d1-a6
		move	d0,SCR_Fontheight(A5)
		beq.s	.topa
		cmp.w	SCR_font_max(a5),d0
		bhi.s	.topa
		move.l	SCR_FontAdr(a5),d1
		bne	.break

		lea	SCR_TextAttr(A5),a0
		clr.b	ta_Style(a0)
		move.b	#0,ta_Flags(a0)
		move.w	d0,ta_YSize(a0)
		lea	SCR_FontNAME(a5),a3
		move.l	a3,ta_name(A0)

		move.l	DiskFont(a5),d0
		beq.s	.topa
		move.l	d0,a6
		jsr	_LVOOpenDiskFont(A6)
		move.l	d0,SCR_FontAdr(a5)
		bne.s	.OK1
.topa:		lea	SCR_TextAttr(A5),a0
		lea	Topazname(pc),a3
		move.l	a3,ta_name(a0)
		move.w	#8,ta_ysize(A0)
		clr.b	ta_style(A0)
		clr.b	ta_Flags(A0)
		move.l	GrafSave(a5),a6
		jsr	_LVOOpenFont(A6)
		move.l	d0,SCR_FontAdr(a5)
.break
.OK1:		pop	d1-a6
		tst.l	d0
		rts

**********************************************************************
*           RastPortelemente (Font,Bitmap) freigeben                 *
**********************************************************************
SC_FreeRastPort:push	d0-a6

	*-------------------- Font -------------------------*
		move.l	SCR_FontAdr(a5),d0
		beq.s	.OK1
		clr.l	SCR_FontAdr(A5)
		move.l	d0,a1
		move.l	GrafSave(a5),a6
		jsr	_LVOCloseFont(A6)

	*-------------------- Bitmap -----------------------*
.OK1:		lea	SCR_Bitmap(A5),a3
		bsr	FreeBitmap

		lea	SCR_RastPort(A5),a0	;RastPort komplett killen
		move.w	#rp_sizeof-1,d0
.Clr:		clr.b	(a0)+
		dbf	d0,.clr

		clr.l	SCR_ScrolCurr(a5)
		sf	SCR_Enable(a5)
		pop	d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: a0=String
*Output: d0=Size of String
*-----------------------------------------------------------------------------*
BerechStringSize:
		move.l	a0,-(a7)
		moveq	#-1,d0
.NextB:		addq.l	#1,d0			;Lnge in D0
		tst.b	(a0)+
		bne.s	.NextB
		move.l	(a7)+,a0
		tst.l	d0
		rts



	ifne	Scroller
*********************************************************************
*   RastPort fr den Scrolltext und zugehrige Bitmap erzeugen,     *
*   so da fr den Scroller Systemfonts verwendet werden knnen     *
*                                                                   *
* Input:   A0: Pointer auf String mit dem Fontnamen (0=letzter Font *
*          D0: Hhe des Fonts                                       *
*          D3: Xpos                                                 *
*          D2: Ypos                                                 *
*          D5: Breite der Zeile                                     *
*          D4: Maxhhe der Zeile                                    *
* Output:  D0: <> 0 ---> alles OK                                   *
*********************************************************************
SC_MakeRastPort:push	d1-a6
		cmp	#40,d5
		bgt.s	.okok
		move.w	#40,d5
.okok:		move	d5,SCR_Width(A5)

		cmp	#8,d4
		bgt.s	.hi
		moveq	#8,d4
.hi:		move	d4,SCR_font_max(A5)

		move	d3,SCR_xpos(A5)
		move	d2,SCR_ypos(A5)

		move.l	a0,d1
		beq.s	.oldfont		;letzten genutzten Font holen

		lea	SCR_FontNAME(a5),a1
.cop:		move.b	(a0)+,(a1)+
		bne.s	.cop
		bra.s	.font

.oldfont:	move	SCR_Fontheight(A5),d0
.font:		bsr	SC_OpenFont	;entsprechenden Font ffnen (D0:Hhe)
		beq.s	.error1

		lea	SCR_Bitmap(A5),a0	;Bitmap

		moveq	#0,d0
		move	SCR_font_max(A5),d0	;Zeichenhhe
		lsl	#3,d0			;mal 8 (zur Sicherheit)

		add	SCR_Width(A5),d0	;add.l #Scrol_Breite*2,d0
		add	SCR_Width(A5),d0	;Breite

						;(Doppelte Zeilenlnge + Space)
		move.w	SCR_font_max(A5),d1	;Hhe
		moveq	#2,d2			;Tiefe 1
		bsr	AllocBitMap
		beq.s	.Error1

		lea.l	SCR_RastPort(a5),a3
		move.l	a3,a1

		move.l	GrafSave(a5),a6
		jsr	_LVOInitRastPort(A6)

		lea.l	SCR_Bitmap(a5),a0
		move.l	a0,rp_BitMap(a3)

		move.l	SCR_FontAdr(a5),a0
		move.l	a3,a1
		jsr	_LVOSetFont(A6)

		move.l	a3,a1
		moveq	#1,d0				;Foreground
		jsr	_LVOSetAPen(A6)

		move.l	a3,a1
		moveq	#0,d0				;Background
		jsr	_LVOSetBPen(A6)

		move.l	a3,a1				;RastPort
		move.l	#RP_JAM2,d0
		jsr	_LVOsetDrMd(A6)

		st	d0
.error1:	pop	d1-a6
		tst	d0
		rts

*-----------------------------------------------------------------------------*
ClearBM:	push	d0-d1/a0-a1/a6
		lea.l	SCR_RastPort(a5),a1
		tst.l	RP_Bitmap(a1)		;RastPort initialisiert ?
		beq.s	.Skip
		moveq	#0,d0			;Fill Color = BG
		move.l	GrafSave(a5),a6
		jsr	_LVOSetRast(a6)		;RastPort komplett lschen
.Skip:		pop	d0-d1/a0-a1/a6
		rts
***********************************************************************
*     Bitmap fr den RastPort initialisieren und Bitplanes setzen     *
* Input:                                                              *
*   Breite: D0                                                        *
*   Hhe:   D1                                                        *
*   Tiefe:  D2                                                        *
*   BitMap: A0                                                        *
***********************************************************************
AllocBitMap:	push	d1-a6

		move.l	GrafSave(a5),a6

		lea	(a0),a3
		lea	bm_planes(a3),a1
		moveq	#7,d5
.clr:		clr.l	(a1)+
		dbf	d5,.clr

		move.w	d0,d3		;Breite (Pix)
		add.w	#16,d3
		and.w	#~15,d3

		moveq	#0,d0
		move.b	d2,d0		;Tiefe (Bits)
		move	d2,-(sp)
		moveq	#0,d2
		move.w	d1,d2		;Hhe
		move.w	d1,d4
		moveq	#0,d1
		move.w	d3,d1		;Breite (Pix)
		jsr	_LVOInitBitmap(a6)
		move	(sp)+,d2

		move	bm_bytesperrow(A3),d3
		lsl.w	#3,d3
		move	bm_rows(a3),d4

		lea	bm_planes(A3),a3
		subq.w	#1,d2
.AllPlanes:	move.w	d3,d0
		move.w	d4,d1
		addq.w	#1,d1
		jsr	_LVOallocraster(A6)
		move.l	d0,(A3)+
		beq.s	.fail
		move.l	d0,a0	;;!!
		move.l	#1,(a0)
		dbf	d2,.allplanes
		pop	d1-a6
		moveq	#1,d0
		rts

.Fail:		pop	d1-a6
		moveq	#0,d0
		rts

**************************************************************
*                   Bitplane(s) freigeben                    *
**************************************************************
FreeBitmap:	push	d0-a6
		move.l	GrafSave(A5),a6
		moveq	#0,d2
		move.b	bm_depth(a3),d2
		subq.w	#1,d2

		move.w	bm_bytesperrow(a3),d3
		lsl.w	#3,d3
		lea	bm_planes(A3),a4
.allplanes:	move.w	d3,d0
		move.w	bm_rows(a3),d1
		move.l	(a4),d4
		beq.s	.noplane
		move.l	d4,a0
		addq.w	#1,d1
		jsr	_LVOfreeRaster(A6)
.noplane:	clr.l	(a4)+
		dbf	d2,.allplanes

		pop	d0-a6
		rts

***************************************************************************
*                   Daten ins Fenster kopieren                            *
***************************************************************************
IntoWindow:	push	d0-a6			;in den RastPort kopieren
		move.l	WinHandle(a5),d0
		beq.s	.nowin
		move.l	d0,a1			;Fenster
		move.l	wd_rPort(a1),a1		;RastPort (Ziel)

		move.w	SCR_xpos(a5),d2		;X2 (Ziel-X-Position)
		move.w	SCR_ypos(A5),d3		;Y-Position im Window

		lea	SCR_Bitmap(a5),a0	;Bitmap (Quelle)

		move.w	SCR_Offset1(a5),d0 ;X1 (abhngig von der Position des
					;Scrollers->nicht die Bitmap wird
					;gescrollt,es wird nur ein
					;anderer Ausschnitt gezeigt
		moveq	#0,d1		;Y1 - Position in der Bitmap

		move.w	SCR_width(A5),d4	;Breite <- !!!!
		sub	SCR_Limitwidth(A5),d4	;minus Limit
		ble.s	.nowin			;check!

		move.w	SCR_font_max(a5),d5	;Hhe

		move.b	#$c0,d6			;Miniterm (nur kopieren)

		move.l	GrafSave(a5),a6		;GRAPHICS Library
		jsr	_LVObltbitmapRastPort(a6)

.NoWin:		pop	d0-a6
		rts

*************************************************************
*  Text in Bitplane reinprinten ber RastPort               *
* Input:                                                    *
*    D0 : ASCII-Char                                        *
*    D1 : Position                                          *
* OutPut:                                                   *
*    D2 : Breite des Zeichens in Pixeln                     *
*************************************************************
PrintChar:	push	d0-d1/d3-a6

		lea.l	SCR_RastPort(a5),a3
		move.l	a3,a1
		lea	SCR_CharTMP(a5),a0
		move.b	d0,(A0)

		move.w	d1,d0			;X-Posi
		move.l	SCR_FontAdr(A5),a2
		move.w	tf_Baseline(a2),d1	;Char Baseline = Y-Posi

		move	SCR_font_max(A5),d2		;zentrieren des Zeichens
		sub	SCR_TextAttr+ta_ysize(a5),d2	;in vertikaler Richtung
		ble.s	.skip				;wenn Zeichen kleiner als
		moveq	#0,d3				;max. Wert
		lsr	#1,d2
		addx	d3,d2
		add	d2,d1

.skip:		move.l	GrafSave(A5),a6
		jsr	_LVOMove(A6)

		move.l	a3,a1
		lea	SCR_CharTMP(a5),a0
		moveq	#1,d0
		jsr	_LVOtext(A6)

		move.l	a3,a1
		lea	SCR_CharTMP(a5),a0
		moveq	#1,d0
		jsr	_LVOTextLength(A6)
		move	d0,d2

		pop	d0-d1/d3-a6
		rts
	endc

*-----------------------------------------------------------------------------*
*--------- Neue Gre, Gadgets neu erzeugen, Scroller update, Rahmen ziehen ---
*------------------------------------------------------------------------------
* Bei Windowmessage
;ResizeWindow:	tst.w	GadgetsDa(a5)		;gerade disabled ?
;		beq.s	.none
;
;		move.l	IntSave(a5),a6
;		move.l	WinHandle(a5),a0
;		move.l	GD_FirstGadget(a5),a1
;		move.w	GD_Count(a5),d0
;		beq.s	.none
;		jsr	_LVORemoveGList(a6)
;.None:		bsr	FreeMaingadgets
;
;	*------- restliche Gadgets erzeugen und ans Fenster anhngen -----*
;		bsr	MakeMaingadgets
;		tst.l	d0
;		beq	.Return
;		move.l	d0,a1
;		moveq	#-1,d0
;		moveq	#-1,d1
;		suba.l	a2,a2
;		move.l	WinHandle(A5),a0
;		jsr	_LVOAddglist(A6)
;
;		bsr	BackFill
;
;	*-----------------------------------------------------
;		bsr	SC_FreeRastPort		;Scroller freigeben
;	ifne	Scroller
;		bsr	PrintScrolRahmen	;Rahmen+Position/Gre
;
;		push	d2-d7
;		addq	#1,d2
;		addq	#1,d3
;		subq	#2,d4
;		subq	#2,d5
;		sub.l	a0,a0				;kein neuer Font
;		bsr	SC_MakeRastPort		;neuen Scrol
;		pop	d2-d7
;	endc
;
;
;	*	lea	Aboutmessage(pc),a0		;nur Testhalber, entfernen !!!
;	*	bsr	NewScrolText			;
;
;		move.l	IntSave(A5),a6
;	*	move.l	WinHandle(a5),a1
;	*	suba.l	a2,a2
;	*	move.l	wd_firstgadget(a1),a0
;	*	jsr	_LVORefreshgadgets(A6)		;Gadgets anzeigen
;
;		move.l	WinHandle(A5),a0
;		jsr	_LVORefreshWindowFrame(A6)	;weil manchmal was ber steht
;
;		move.w	#1,GadgetsDa(a5)		;gerade disabled ?
;
;	ifne	Scroller
;		move.l	SCR_LastPrinted(a5),d0
;		beq.s	.Return
;		move.l	d0,a0
;		bsr	PrintText2
;	endc
;.Return:	rts

;**************************************************************************
;* Input:  A0 : Window                                                    *
;*         D2 : Pos Y (vom Scroller)                                      *
;*         D4 : Hhe (vom Scroller)                                       *
;*         D3 : Pos X (vom Scroller)                                      *
;*         D5 : Breite (vom Scroller)                                     *
;* Output: selbe Register, Rest gesichert                                 *
;**************************************************************************
;CalcCoords
;		push	d0/d6-d7
;
;		move.l	a0,d0
;		beq.s	.fail
;
;		moveq	#0,d0
;		move.b	wd_bordertop(a0),d7	;Fonts > 120 ?? glaube ich kaum...
;		move.b	d7,d0
;		add.b	wd_borderbottom(a0),d7
;		ext.w	d7
;		neg.w	d7
;		add.w	wd_height(a0),d7	;WA_Innerheight :)
;
;		mulu	d7,d2			;top
;		mulu	d7,d4			;height
;		divu	#Defheight,d2		;def Wert
;		divu	#Defheight,d4		;def Wert
;		add	d0,d2			;Border dazu
;
;		move.b	wd_borderleft(a0),d6
;		move.b	d6,d0
;		add.b	wd_borderright(a0),d6
;		ext.w	d6
;		neg.w	d6
;		add.w	wd_width(a0),d6		;WA_Innerwidth :)
;
;		mulu	d6,d3			;top
;		mulu	d6,d5			;height
;		divu	#DefWidth,d3		;def Wert
;		divu	#DefWidth,d5		;def Wert
;		add	d0,d3			;Border dazu
;.fail
;		pop	d0/d6-d7
;		rts

*---------------------------------------------------------------------------*
* Eine Einstellung im Eagleplayer wurde verndert. Das Enginewird informiert*
* Input: d0=Nummer							    *
*	 d2								    *
* Output:?								    *
*---------------------------------------------------------------------------*
* Die Menus werden bis auf die, der Engine intern verwaltet.
* Achtung: Auf Messages testen, die ankommen, weil der Regler im Window ver-*
*	   schoben wurde.						    *
*---------------------------------------------------------------------------*
ChangePrefs:
		push	all

		lea	Datas,a5
;		move.l	LastNummer(a5),d7
;		beq.s	.NoLast
*		cmp.w	#EPNr_PlayFaster,d7
*		beq.w	.Return
*		cmp.w	#EPNr_NextPattern,d7
*		beq.w	.Return
*		cmp.w	#EPNr_PrevPattern,d7
*		beq.w	.Return
;		cmp.w	#EPNr_Volume,d7
;		beq.s	.Return
;		cmp.w	#EPNr_Balance,d7
;		beq.s	.Return

		*--- Gadget in Liste finden ---*
.NoLast:
		cmp	#EPNr_Speed,d0
		bne.s	.noe
		add	#SpeedAuf/2,d2
		bra.s	.ja
.noe
		cmp.w	#EPNr_Volume,d0
		beq.s	.Ja
		cmp.w	#EPNr_Balance,d0
		bne.w	.TesteScrollFont
		add.w	#EP_MaxVolume,d2

.Ja		move.l	GD_FirstGadget(A5),d3
		beq.w	.Return
		move.l	d3,a0
		move	GD_Count(a5),d3
		subq	#1,d3
		blt.w	.Return
.findgad:	cmp.w	gg_gadgetid(a0),d0
		beq.s	.found2
		move.l	(a0),d3
		beq.s	.Return
		move.l	d3,a0
		dbf	d3,.findgad
		bra.s	.Return
.found2:
		mulu	#maxbody,d2

		cmp	#EPnr_Speed,d0
		beq.s	.speed

		cmp	#EPNr_Volume,d0
		bne.s	.bal
		divu	#MaxVolume,d2
		bra.s	.set
.speed		divu	#SpeedAuf,d2
		move	#$ffff,d0
		exg.l	d2,d0
		sub.w	d0,d2
		bra.s	.set
.bal
		divu	#BalanceAuf,d2
.set
		move.l	gg_specialInfo(a0),d0
		beq	.return	
		move.l	d0,a1
		move	pi_flags(a1),d0
		and	#FREEVERT,d0
		beq.s	.hori
		move	pi_Horizpot(a1),d1
		bra.s	.setvalue
.hori
		move	d2,d1
		move	pi_Vertpot(a1),d2
.setvalue
		move	pi_flags(a1),d0
		move	pi_HorizBody(a1),d3
		move	pi_Vertbody(a1),d4
		moveq	#1,d5

		move.l	Winhandle(A5),a1
		suba.l	a2,a2
		move.l	intsave(a5),a6
		jsr	_LVONewModifyProp(a6)

		bra.w	.Return
.TesteScrollFont:
		cmp.w	#EPNr_ScrollFont,d0
		bne.s	.Return
		bsr	SC_SetFont
.Return:
		pop	all
		rts

*-----------------------------------------------------------------------------*
* Der Eagleplayer fragt was ab.
*-----------------------------------------------------------------------------*
GetPrefs:	lea	Datas,a5

	ifne	Scroller
		cmp.w	#EPNr_ScrollFont,d0
		bne.s	.Error
		moveq	#0,d0
		moveq	#8,d1				;Min Height
		move.w	SCR_font_max(a5),d2		;Max Wert
		move.w	SCR_TextAttr+Ta_YSize(a5),d3	;eing. Wert
		move.w	#EPFB_Proportional,d4		;Flags (Pro)
	endc

.Error:		moveq	#EPR_FunctionAborted,d0
		rts

****************************************************************************
* angegebenes Gadget enable/disable (OHNE REFRESH !!)                      *
* Input D0.w = Gadget ID                                                   *
*       D1.l = State (0=enable,1=disable)		                   *
****************************************************************************
ChangeGui:
		cmp	#EPNr_Voices,d0
		beq.s	.setvoi
		cmp	#EPNr_Balance,d0
		beq.s	.setbalance
		bra.s	.changegadget
.setbalance
		bsr.s	.changegadget
		move	#GD_Balleft,d0
		bra.s	.changegadget
.setvoi
		moveq	#100,d2
		tst.l	d1
		bne.s	.dis
		move.l	EUS_Structure+EUS_EPBase(pc),a1
		move	EPG_VoiceTableEntries(a1),d2
.dis
		subq	#1,d2
		bmi.s	.ret	
		move	#GD_Voice1,d0
		bsr.s	.changegadget

		subq	#1,d2
		bmi.s	.ret	
		move	#GD_Voice2,d0
		bsr.s	.changegadget

		subq	#1,d2
		bmi.s	.ret	
		move	#GD_Voice3,d0
		bsr.s	.changegadget

		subq	#1,d2
		bmi.s	.ret
		move	#GD_Voice4,d0
		bra.s	.changegadget
.ret
		rts
.changegadget
		push	d0-d2
		lea	datas,a5
		and.w	#1,d1			;nur 0/1 erlaubt

		move.l	GD_FirstGadget(A5),d2
		beq.s	.end2
		move.l	d2,a0
		move	GD_Count(a5),d2
		subq	#1,d2
		blt.s	.end2
.findgad:	cmp.w	gg_gadgetid(a0),d0
		beq.s	.found2
		move.l	(a0),d3
		beq.s	.end2
		move.l	d3,a0
		dbf	d2,.findgad
		bra.s	.end2
.found2:
		move	gg_Flags(a0),d0
		and	#~gflg_disabled,d0
		lsl	#8,d1			;GFLG_Disabled=$100
		or	d1,d0
		move	d0,gg_flags(A0)
.end2:	
		pop	d0-d2
		rts

****************************************************************************
* Alle Gadgets, die bisher fr das Hauptfenster erstellt wurden, freigeben *
****************************************************************************
FreeMaingadgets:
		push	d0-a6
		bsr	RemapColors				;Farben remappen

		pop	d0-a6
		rts
*************************************************************************
*          Gadgets fr das HauptFenster erstellen                       *
*************************************************************************
MakeMaingadgets:
		push	d1-a6
		bsr	RemapColors				;Farben remappen

		move.l	winhandle(a5),a0
		moveq	#0,d0
		move.b	wd_bordertop(a0),d0
		moveq	#0,d1
		move.b	wd_borderleft(a0),d1

		move.w	lastbordertop(a5),d2
		move.w	lastborderleft(a5),d3

		lea	Voice1Gadget(pc),a0
		move.l	a0,d4
		moveq	#0,d5
.positionloop
		move.l	d4,a0
		addq	#1,d5

		move	gg_leftedge(A0),d4
		sub	d3,d4
		add	d1,d4
		move	d4,gg_leftedge(A0)

		move	gg_topedge(A0),d4
		sub	d2,d4
		add	d0,d4
		move	d4,gg_topedge(A0)

		move.l	gg_NextGadget(a0),d4
		bne.s	.positionloop

		lea	Voice1Gadget(pc),a1
		move.l	a1,GD_FirstGadget(a5)
		move	d5,GD_Count(A5)

		move.w	d0,lastbordertop(a5)
		move.w	d1,lastborderleft(a5)

		move.l	a1,d0
		pop	d1-a6
		rts

	;*************************************************
	;**** Gadgets umarbeiten, wegen Farbenwechsel ****
	;*************************************************
RemapColors
		lea	Voice1Gadget(pc),a0

;		not.w	WinAnpass-WinHandle(a3)
;		tst.l	d7
;		beq.w	.NoClr
;
;
;	;Folgende Gadgetreihenfolge erzielen
;	; Dummy-> Speed -> Retry -> Cancel -> Plus -> Minus 
;
;		lea	BalReg1(pc),a1
;		clr.l	(a1)
;		clr.l	Balreg2-BalReg1(a1)
;
;		lea	SpeedReglerGadget(pc),a1
;		move.l	a1,DummyGadget-SpeedReglerGadget(a1)
;
;		lea	RetryGadget(pc),a1
;		move.l	a1,SpeedReglerGadget-RetryGadget(a1)
;
;		lea	PlusGadget(pc),a0
;		move.l	a0,CancelGadget-PlusGadget(a0)
;
;		lea	AbortGadget(pc),a0
;		move.l	a0,MinusGadget-AbortGadget(a0)
;
;	;	clr.l	AbortGadget-AbortGadget(a0)	;wichtig !!!
;		clr.l	(a0)


;.NoClr:		move.l	18(a4),a0

.NextGadget:	move.l	26(a0),d0		;IText-Structure
		beq.s	.NoIText
		move.l	d0,a1
		eor.b	#3,(a1)			;Farben umdrehen
.NoIText:	move.l	18(a0),d0		;FirstImage nach a1
		bsr.s	.BauItUm
		move.l	22(a0),d0
		bsr.s	.BauItUm
		move.l	(a0),d0			;Next Gadget
		beq.s	.NoUmbau		;BorderUmbau
		move.l	d0,a0
		bra.s	.NextGadget

	*------ Baue eine Image/Border-Structure um ------*
.BauItUm:	tst.l	d0
		beq.s	.Return
		move.l	d0,a1
		btst	#2,13(a0)
		bne.s	.NextImage

.BorderUmbau:	moveq	#0,d0
.NextBorder:	eor.b	#3,4(a1)
		move.l	12(a1),a1
		cmp.l	a1,d0
		bne.s	.NextBorder
.Return		rts

	*------ Schleife fr eine Image-Structure und UnterSchleifen -----*
.NextImage:	cmp.b	#1,14(a1)
		beq.s	.ToNextImage
		move.w	4(a1),d2		;Breite nach d2
		moveq	#0,d0

	*------- Parameter fr AllesUmsetzen berechnen ------*
.UmArbeit:	addq.w	#1,d0			;Anzahl der Bytes
		subq.w	#8,d2
		bhi.s	.UmArbeit
		btst	#0,d0
		beq.s	.NotSet
		addq.w	#1,d0
.NotSet:	mulu	6(a1),d0		;Lnge des 1.TeilImages nach d0
		bsr.w	AllesUmsetzen
.ToNextImage:	move.l	16(a1),d1
		beq.s	.Return
		move.l	d1,a1
		bra.s	.NextImage
.noumbau	rts

	;******************************************************
	;**** Gadgets entsprechend der Farbpalette umbauen ****
	;******************************************************
AllesUmsetzen:	movem.l	d0/a1,-(a7)
		move.l	10(a1),d2		;Adresse der Image-Daten
		beq.s	AllesUmsetzenRet
		move.l	d2,a1
AllesUmsetzen2:	move.l	d0,d3			;AllesUmSetzen2
		move.l	a1,a2
		add.l	d0,a2			;2.Daten nach a2
		subq.l	#1,d3
.BytesUmsetzen:	move.b	(a1),d1
		move.b	(a2),d2
		moveq	#7,d4
.BitsUmsetzen:	btst	d4,d1
		beq.s	.NotSet0		;Bit nicht gesetzt
		btst	d4,d2
		bne.s	.NextBit		;Bit nicht gesetzt
		bclr	d4,d1
		bset	d4,d2
		bra.s	.NextBit
.NotSet0:	btst	d4,d2
		beq.s	.NextBit
		bset	d4,d1
		bclr	d4,d2	
.NextBit:	dbf	d4,.BitsUmsetzen
		move.b	d1,(a1)+
		move.b	d2,(a2)+
		dbf	d3,.BytesUmsetzen
AllesUmsetzenRet:movem.l (a7)+,d0/a1
		rts
*****************************************************************************
*                        Daten und Initialisierungen                        *
*****************************************************************************
	ifne	test
Int:		dc.b	"intuition.library",0
Graf:		dc.b	"graphics.library",0
aslnam:		dc.b	"asl.library",0
	endc
util:		dc.b	"utility.library",0
diskf:		dc.b	"diskfont.library",0

	ifne	test
MyWinName:	dc.b	"Eagleplayer V"
EPVer1		dc.b	"x.xx",0
	endc
MyMenuName:	dc.b	"Eagleplayer1x-GUI",0
MyProzessName:dc.b	"Eagleplayer1x-GUI.1",0
MyCreatorname:dc.b	"DEFECT SOFTWORKS",0
MySpecialInfo:	dc.b	`This user interface is the good old Eagleplayer GUI `
		dc.b	`from Version 1 for those of you who wanted it back.`,0
TopazName:	dc.b	"topaz.font",0

XenName:
		dc.b	`XEN.font`,0
;		dc.b	`XENprop.font`,0
;		dc.b	`Buggs.font`,0
;		dc.b	`AsphaltNarrow.font`,0
;		dc.b	`Asphaltfixed.font`,0
;		dc.b	`Bcourier.font`,0
;		dc.b	`Helvetica.font`,0
;		dc.b	`XHelvetica.font`,0
;		dc.b	`Serpentine.font`,0
;		dc.b	`Scaiv.font`,0
;		dc.b	`DgSansserif.font`,0	
;		dc.b	`univershi.font`,0

	ifne	test
Aboutmessage:
	dc.b	`Playing |Mod.Welcome to Alzheim`,0

	dc.b	`......EaglePlayer Scroller  V2.00 `
	dc.b	`(C) 1995 Henryk "BUGGS" Richter ! `
	dc.b	`you can reach the Author at the following Address:`
	dc.b	` Henryk Richter  St.-Jantzen Ring 47`
	dc.b	` 18106 Rostock,`
	dc.b	` GERMANY........... `
	dc.b	`ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz`,0
	even
	endc

	dc.l	1,10,100,1000,10000,100000,1000000,10000000,100000000
dectable:

	even

	*------ Menu -------*
GuiMenu:	dc.l	0			;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$52
		dc.l	0
		dc.l	.IText
		ds.b	6
		dc.l	.SubItem1
		dc.l	0		*Kick2.0+ ??
.IText:		dc.w	3,0,0,1
		dc.l	0
		dc.l	.SubItem.MSG
		dc.l	0
		dc.w	0			;No Nummer


	*----- SubItem 1 -----*
.SubItem1:	dc.l	.SubItem2		;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$15b
		dc.l	0
		dc.l	.IText1
		ds.b	12
		dc.l	0		*Kick2.0+ ??
.IText1:	dc.w	3,0,20,1
		dc.l	0
		dc.l	.SubItem1.Msg
		dc.l	0	
		dc.w	EPNr_FirstExternal

	*----- SubItem 2 ----*
.SubItem2:	dc.l	0			;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$15b
		dc.l	0
		dc.l	.IText2
		ds.b	12
		dc.l	0		*Kick2.0+ ??
.IText2:	dc.w	3,0,20,1
		dc.l	0
		dc.l	.SubItem2.MSG
		dc.l	0	
		dc.w	EPNr_FirstExternal+2

.SubItem.MSG:	dc.b	"Eagleplayer1x-GUI Prefs",0
.SubItem1.MSG	dc.b	"Emboss Look",0
.SubItem2.MSG	dc.b	"Save Config",0

		even

	*--------------------------------------------------------------*
	*--------------------------------------------------------------*
	*---------  G A D G E T   -   S T R U K T U R E N  ------------*
	*--------------------------------------------------------------*
	*--------------------------------------------------------------*


	*-------- Voice 1 (Ein-Aus) String-Gadget -------*
Voice1Gadget:	dc.l	Voice2Gadget
		dc.w	Voice1Hori
		dc.w	Voice1Verti
		dc.w	19
		dc.w	11
		dc.w	$106
		dc.w	Relverify!GACT_TOGGLESELECT		;$102
		dc.w	1
		dc.l	.Voice1Image1
		dc.l	.Voice1Image2
		dc.l	0
		dc.l	0
		dc.l	0
		dc.w	GD_Voice1		;EPNr_Voices		;Voice1
		dc.l	0
.Voice1Image1:	dc.w	0
		dc.w	0
		dc.w	19
		dc.w	11
		dc.w	0
		dc.l	Voice1Gr1
		dc.b	3
		dc.b	0
		dc.l	0
.Voice1Image2:	dc.w	0
		dc.w	0
		dc.w	19
		dc.w	11
		dc.w	2
		dc.l	Voice1Gr2
		dc.b	3
		dc.b	0
		dc.l	0

	*------ Voice 2 (Ein-Aus) String-Gadget ------*
Voice2Gadget:	dc.l	Voice3Gadget
		dc.w	Voice2Hori
		dc.w	Voice2Verti
		dc.w	19
		dc.w	11
		dc.w	$106
		dc.w	Relverify!GACT_TOGGLESELECT	;$102
		dc.w	1
		dc.l	.Voice2Image1
		dc.l	.Voice2Image2
		dc.l	0
		dc.l	0
		dc.l	0
		dc.w	GD_Voice2		;Epnr_Voices		;Voice2
		dc.l	0
.Voice2Image1:	dc.w	0
		dc.w	0
		dc.w	19
		dc.w	11
		dc.w	0
		dc.l	Voice2Gr1
		dc.b	3
		dc.b	0
		dc.l	0
.Voice2Image2:	dc.w	0
		dc.w	0
		dc.w	19
		dc.w	11
		dc.w	2
		dc.l	Voice2Gr2
		dc.b	3
		dc.b	0
		dc.l	0

	*------- Voice 3 (Ein-Aus) String-Gadget --------*
Voice3Gadget:	dc.l	Voice4Gadget
		dc.w	Voice3Hori
		dc.w	Voice3Verti
		dc.w	19
		dc.w	11
		dc.w	$106
		dc.w	Relverify!GACT_TOGGLESELECT	;$102
		dc.w	1
		dc.l	.Voice3Image1
		dc.l	.Voice3Image2
		dc.l	0
		dc.l	0
		dc.l	0
		dc.w	GD_Voice3		;EPnr_Voices		;Voice3
		dc.l	0
.Voice3Image1:	dc.w	0
		dc.w	0
		dc.w	19
		dc.w	11
		dc.w	0
		dc.l	Voice3Gr1
		dc.b	3
		dc.b	0
		dc.l	0
.Voice3Image2:	dc.w	0
		dc.w	0
		dc.w	19
		dc.w	11
		dc.w	2
		dc.l	Voice3Gr2
		dc.b	3
		dc.b	0
		dc.l	0

	*--------- Voice 4 (Ein-Aus) String-Gadget ----------*
Voice4Gadget:	dc.l	Aboutgadget
		dc.w	Voice4Hori
		dc.w	Voice4Verti
		dc.w	19
		dc.w	11
		dc.w	$106
		dc.w	Relverify!GACT_TOGGLESELECT	;$102
		dc.w	1
		dc.l	.Voice4Image1
		dc.l	.Voice4Image2
		dc.l	0
		dc.l	0
		dc.l	0
		dc.w	GD_Voice4		;EPNr_Voices
		dc.l	0
.Voice4Image1:	dc.w	0
		dc.w	0
		dc.w	19
		dc.w	11
		dc.w	0
		dc.l	Voice4Gr1
		dc.b	3
		dc.b	0
		dc.l	0
.Voice4Image2:	dc.w	0
		dc.w	0
		dc.w	19
		dc.w	11
		dc.w	2
		dc.l	Voice4Gr2
		dc.b	3
		dc.b	0
		dc.l	0

	*------- About(Fragezeichen) - String-Gadget -------*
AboutGadget:	dc.l	PlayerWindowGadget
		dc.w	AboutHori
		dc.w	AboutVerti
		dc.w	18
		dc.w	18
		dc.w	6
		dc.w	1
		dc.w	1
		dc.l	.AboutImage1
		dc.l	.AboutImage2
		dc.l	0
		dc.l	0
		dc.l	0
		dc.w	EPNr_AboutEP
		dc.l	0
.AboutImage1:	dc.w	0
		dc.w	0
		dc.w	18
		dc.w	18
		dc.w	0
		dc.l	AboutGr1
		dc.b	3
		dc.b	0
		dc.l	0
.AboutImage2:	dc.w	0
		dc.w	0
		dc.w	18
		dc.w	18
		dc.w	2
		dc.l	AboutGr2
		dc.b	3
		dc.b	0
		dc.l	0


	*----------------- PlayerWindowGadget -----------------*
PlayerWindowGadget:dc.l	DefVolumeGadget
		dc.w	PlayerWindowHori
		dc.w	PlayerWindowVerti
		dc.w	19
		dc.w	18
		dc.w	6
		dc.w	1
		dc.w	1
		dc.l	.PlayerWImage1
		dc.l	.PlayerWImage2
		dc.l	0
		dc.l	0
		dc.l	0
		dc.w	EPNr_AboutModule
		dc.l	0
.PlayerWImage1:	dc.w	0
		dc.w	0
		dc.w	19
		dc.w	18
		dc.w	0
		dc.l	PlayerWindowGr1
		dc.b	3
		dc.b	0
		dc.l	0
.PlayerWImage2:	dc.w	0
		dc.w	0
		dc.w	19
		dc.w	18
		dc.w	2
		dc.l	PlayerWindowGr2
		dc.b	3
		dc.b	0
		dc.l	0

	*------------------- Def. VolumeGadget -------------------*
DefVolumeGadget:dc.l	DefBalanceGadget
		dc.w	DefVolumeHori
		dc.w	DefVolumeVerti
		dc.w	46
		dc.w	9
		dc.w	6
		dc.w	1
		dc.w	1
		dc.l	.DefVolumeImage1
		dc.l	.DefVolumeImage2
		dc.l	0
		dc.l	0
		dc.l	0
		dc.w	EPNr_VolumeDefault
		dc.l	0
.DefVolumeImage1:dc.w	0
		dc.w	0
		dc.w	46
		dc.w	9
		dc.w	0
		dc.l	DefVolumeGr1
		dc.b	3
		dc.b	0
		dc.l	0
.DefVolumeImage2:dc.w	0
		dc.w	0
		dc.w	46
		dc.w	9
		dc.w	0
		dc.l	DefVolumeGr2
		dc.b	3
		dc.b	0
		dc.l	0

	*------------------- Def BalanceGadget -------------------*
DefBalanceGadget:dc.l	VolumeReglerGadget
		dc.w	DefBalanceHori
		dc.w	DefBalanceVerti
		dc.w	46
		dc.w	9
		dc.w	6
		dc.w	1
		dc.w	1
		dc.l	.DefBalanceImage1
		dc.l	.DefBalanceImage2
		dc.l	0
		dc.l	0
		dc.l	0
		dc.w	GD_BalLeft
		dc.l	0
.DefBalanceImage1:dc.w	0
		dc.w	0
		dc.w	46
		dc.w	9
		dc.w	0
		dc.l	DefBalanceGr1
		dc.b	3
		dc.b	0
		dc.l	0
.DefBalanceImage2:dc.w	0
		dc.w	0
		dc.w	46
		dc.w	9
		dc.w	0
		dc.l	DefBalanceGr2
		dc.b	3
		dc.b	0
		dc.l	0


	*---------- Volume Proportional-Gadget (Volume-Regler) ----------*
VolumeReglerGadget:dc.l	BalanceReglerGadget
		dc.w	VolumeHori+2
		dc.w	VolumeVerti+1
		dc.w	Volumebreite-4
		dc.w	Volumehohe
		dc.w	$106				6
		dc.w	3
		dc.w	3
		dc.l	VolumeImage1
		dc.l	VolumeImage2
		dc.l	0
		dc.l	0
		dc.l	VolumeProp
		dc.w	EPnr_Volume
		dc.l	0
VolumeImage1:	dc.w	0
		dc.w	0
		dc.w	19
		dc.w	Volumehohe
		dc.w	0
VolReg1:	dc.l	VolumeReglerGr1
		dc.b	3
		dc.b	0
		dc.l	0
VolumeImage2:	dc.w	0
		dc.w	0
		dc.w	19
		dc.w	Volumehohe
		dc.w	2
VolReg2:	dc.l	VolumeReglerGr2
		dc.b	3
		dc.b	0
		dc.l	0
VolumeProp:	dc.w	FREEHORIZ+PROPBORDERLESS
		dc.w	VolumePosi
		dc.w	0
		dc.w	VolumeSteps
		dc.w	0
		dc.w	0
		dc.w	0
		dc.w	0
		dc.w	0
		dc.w	0
		dc.w	0

	*----------- Proportional-Gadget (Balance-Regler) -----------*
BalanceReglerGadget:dc.l IconifyGadget
		dc.w	BalanceHori+2
		dc.w	BalanceVerti+1
		dc.w	Balancebreite-4
		dc.w	Balancehohe
		dc.w	$106				6
		dc.w	3
		dc.w	3
		dc.l	BalanceImage1
		dc.l	BalanceImage2
		dc.l	0
		dc.l	0
		dc.l	BalanceProp
		dc.w	EPNr_Balance
		dc.l	0
BalanceImage1:	dc.w	0
		dc.w	0
		dc.w	19
		dc.w	Balancehohe
		dc.w	0
BalReg1		dc.l	BalanceReglerGr1	;Regler1
		dc.b	3
		dc.b	0
		dc.l	0
BalanceImage2:	dc.w	0
		dc.w	0
		dc.w	19
		dc.w	Balancehohe
		dc.w	2
BalReg2		dc.l	BalanceReglerGr2	;Regler2
		dc.b	3
		dc.b	0
		dc.l	0
BalanceProp:	dc.w	2+8
		dc.w	BalancePosi		;$7fff
		dc.w	0
		dc.w	Balancesteps
		dc.w	0
		dc.w	0
		dc.w	0
		dc.w	0
		dc.w	0
		dc.w	0
		dc.w	0


	*-------- Iconify - Gadget ----------*
IconifyGadget:	dc.l	FilterGadget
		dc.w	IconifyHori
		dc.w	IconifyVerti
		dc.w	18
		dc.w	9
		dc.w	6
		dc.w	1
		dc.w	1
		dc.l	.IconifyImage1
		dc.l	.IconifyImage2
		dc.l	0
		dc.l	0
		dc.l	0
		dc.w	EPNr_Iconify
		dc.l	0
.IconifyImage1:	dc.w	0
		dc.w	0
		dc.w	18
		dc.w	9
		dc.w	0
		dc.l	IconifyGr1
		dc.b	3
		dc.b	0
		dc.l	0
.IconifyImage2:	dc.w	0
		dc.w	0
		dc.w	18
		dc.w	9
		dc.w	2
		dc.l	IconifyGr2
		dc.b	3
		dc.b	0
		dc.l	0


	*--------- Swap Filter Gadget ---------*
FilterGadget:	dc.l	PrevModuleGadget
		dc.w	FilterHori
		dc.w	FilterVerti
		dc.w	18
		dc.w	9
		dc.w	6
		dc.w	1
		dc.w	1
		dc.l	.FilterImage1
		dc.l	.FilterImage2
		dc.l	0
		dc.l	0
		dc.l	0
		dc.w	EPNr_ToggleFilter
		dc.l	0
.FilterImage1:	dc.w	0
		dc.w	0
		dc.w	18
		dc.w	9
		dc.w	0
		dc.l	FilterGr1
		dc.b	3
		dc.b	0
		dc.l	0
.FilterImage2:	dc.w	0
		dc.w	0
		dc.w	18
		dc.w	9
		dc.w	2
		dc.l	FilterGr2
		dc.b	3
		dc.b	0
		dc.l	0


	*--------- Prev - Module - Gadget ---------*
PrevModuleGadget:dc.l	PrevSongGadget
		dc.w	PrevModuleHori
		dc.w	PrevModuleVerti
		dc.w	22		;KlickReihe2H1
		dc.w	15		;KlickReihe2v
		dc.w	$106				;6
		dc.w	1
		dc.w	1
		dc.l	.PrevModuleImage1
		dc.l	.PrevModuleImage2
		dc.l	0
		dc.l	0
		dc.l	0
		dc.w	EPNr_PrevModule
		dc.l	0
.PrevModuleImage1:dc.w	0
		dc.w	0
		dc.w	22
		dc.w	15
		dc.w	0
		dc.l	PrevModuleGr1
		dc.b	3
		dc.b	0
		dc.l	0
.PrevModuleImage2:dc.w	0
		dc.w	0
		dc.w	22
		dc.w	15
		dc.w	2
		dc.l	PrevModuleGr2
		dc.b	3
		dc.b	0
		dc.l	0

	*---------- Prev-Song - Gadget ----------*
PrevSongGadget:	dc.l	PrevPatternGadget
		dc.w	PrevSongHori
		dc.w	PrevSongVerti
		dc.w	22		;KlickReihe2H1
		dc.w	15		;KlickReihe2v
		dc.w	$106				6
		dc.w	1
		dc.w	1
		dc.l	.PrevSongImage1
		dc.l	.PrevSongImage2
		dc.l	0
		dc.l	0
		dc.l	0
		dc.w	EPNr_PrevSong
		dc.l	0
.PrevSongImage1:dc.w	0
		dc.w	0
		dc.w	22
		dc.w	15
		dc.w	0
		dc.l	PrevSongGr1
		dc.b	3
		dc.b	0
		dc.l	0
.PrevSongImage2:dc.w	0
		dc.w	0
		dc.w	22
		dc.w	15
		dc.w	2
		dc.l	PrevSongGr2
		dc.b	3
		dc.b	0
		dc.l	0

	*-------- Prev - Pattern  - Gadget ---------*
PrevPatternGadget:dc.l	ReplaySongGadget
		dc.w	PrevPatternHori
		dc.w	PrevPatternVerti
		dc.w	30		;KlickReihe2H2
		dc.w	15		;KlickReihe2v
		dc.w	$106				;6
		dc.w	GACT_Immediate!Relverify
		dc.w	1
		dc.l	.PrevPatternImage1
		dc.l	.PrevPatternImage2
		dc.l	0
		dc.l	0
		dc.l	0
		dc.w	EPNr_PrevPattern
		dc.l	0
.PrevPatternImage1:dc.w	0
		dc.w	0
		dc.w	30
		dc.w	15
		dc.w	0
		dc.l	PrevPatternGr1
		dc.b	3
		dc.b	0
		dc.l	0
.PrevPatternImage2:dc.w	0
		dc.w	0
		dc.w	30
		dc.w	15
		dc.w	2
		dc.l	PrevPatternGr2
		dc.b	3
		dc.b	0
		dc.l	0

	*---------- Replay-Play - String-Gadget ------------*
ReplaySongGadget:dc.l	PlayModuleGadget
		dc.w	ReplaySongHori
		dc.w	ReplaySongVerti
		dc.w	26		;KlickReihe2H3
		dc.w	15		;KlickReihe2v
		dc.w	$106				6
		dc.w	1
		dc.w	1
		dc.l	.ReplaySongImage1
		dc.l	.ReplaySongImage2
		dc.l	0
		dc.l	0
		dc.l	0
		dc.w	EPNr_ReplaySong
		dc.l	0
.ReplaySongImage1:dc.w	0
		dc.w	0
		dc.w	26
		dc.w	15
		dc.w	0
		dc.l	ReplaySongGr1
		dc.b	3
		dc.b	0
		dc.l	0
.ReplaySongImage2:dc.w	0
		dc.w	0
		dc.w	26
		dc.w	15
		dc.w	2
		dc.l	ReplaySongGr2
		dc.b	3
		dc.b	0
		dc.l	0

	*------------- Play - Gadget ------------*
PlayModuleGadget:dc.l	PlayFasterGadget
		dc.w	PlayModuleHori
		dc.w	PlayModuleVerti
		dc.w	24		;KlickReihe2H1
		dc.w	15		;KlickReihe2v
		dc.w	$106				6
		dc.w	1
		dc.w	1
		dc.l	.PlayModuleImage1
		dc.l	.PlayModuleImage2
		dc.l	0
		dc.l	0
		dc.l	0
		dc.w	EPNr_Play
		dc.l	0
.PlayModuleImage1:dc.w	0
		dc.w	0
		dc.w	24
		dc.w	15
		dc.w	0
		dc.l	PlayModuleGr1
		dc.b	3
		dc.b	0
		dc.l	0
.PlayModuleImage2:dc.w	0
		dc.w	0
		dc.w	24
		dc.w	15
		dc.w	2
		dc.l	PlayModuleGr2
		dc.b	3
		dc.b	0
		dc.l	0

	*------------ PlayFaster - Gadget -------------*
PlayFasterGadget:dc.l	NextPatternGadget
		dc.w	PlayFasterHori
		dc.w	PlayFasterVerti
		dc.w	28		;KlickReihe2H4
		dc.w	15		;KlickReihe2v
		dc.w	$106				;6
		dc.w	GACT_Immediate!Relverify
		dc.w	1
		dc.l	.PlayFasterImage1
		dc.l	.PlayFasterImage2
		dc.l	0
		dc.l	0
		dc.l	0
		dc.w	EPNr_PlayFaster
		dc.l	0
.PlayFasterImage1:dc.w	0
		dc.w	0
		dc.w	28
		dc.w	15
		dc.w	0
		dc.l	PlayFasterGr1
		dc.b	3
		dc.b	0
		dc.l	0
.PlayFasterImage2:dc.w	0
		dc.w	0
		dc.w	28
		dc.w	15
		dc.w	2
		dc.l	PlayFasterGr2
		dc.b	3
		dc.b	0
		dc.l	0

	*------------ NextPattern - Gadget -------------*
NextPatternGadget:dc.l	NextSongGadget
		dc.w	NextPatternHori
		dc.w	NextPatternVerti
		dc.w	30		;KlickReihe2H2
		dc.w	15		;KlickReihe2v
		dc.w	$106				;6
		dc.w	GACT_Immediate!Relverify
		dc.w	1
		dc.l	.NextPatternImage1
		dc.l	.NextPatternImage2
		dc.l	0
		dc.l	0
		dc.l	0
		dc.w	EPNr_NextPattern
		dc.l	0
.NextPatternImage1:dc.w	0
		dc.w	0
		dc.w	30
		dc.w	15
		dc.w	0
		dc.l	NextPatternGr1
		dc.b	3
		dc.b	0
		dc.l	0
.NextPatternImage2:dc.w	0
		dc.w	0
		dc.w	30
		dc.w	15
		dc.w	2
		dc.l	NextPatternGr2
		dc.b	3
		dc.b	0
		dc.l	0

	*------------ NextSong-Gadget - Gadget -------------*
NextSongGadget:	dc.l	NextModuleGadget
		dc.w	NextSongHori
		dc.w	NextSongVerti
		dc.w	22		;KlickReihe2H1
		dc.w	15		;KlickReihe2v
		dc.w	$106				6
		dc.w	1
		dc.w	1
		dc.l	.NextSongImage1
		dc.l	.NextSongImage2
		dc.l	0
		dc.l	0
		dc.l	0
		dc.w	EPNr_NextSong
		dc.l	0
.NextSongImage1:dc.w	0
		dc.w	0
		dc.w	22
		dc.w	15
		dc.w	0
		dc.l	NextSongGr1
		dc.b	3
		dc.b	0
		dc.l	0
.NextSongImage2:dc.w	0
		dc.w	0
		dc.w	22
		dc.w	15
		dc.w	2
		dc.l	NextSongGr2
		dc.b	3
		dc.b	0
		dc.l	0

	*------------ Next Module - Gadget ------------*
NextModuleGadget:dc.l	StopPlayGadget
		dc.w	NextModuleHori
		dc.w	NextModuleVerti
		dc.w	22		;KlickReihe2H1
		dc.w	15		;KlickReihe2v
		dc.w	$106				6
		dc.w	1
		dc.w	1
		dc.l	.NextModuleImage1
		dc.l	.NextModuleImage2
		dc.l	0
		dc.l	0
		dc.l	0
		dc.w	EPNr_NextModule
		dc.l	0
.NextModuleImage1:dc.w	0
		dc.w	0
		dc.w	22
		dc.w	15
		dc.w	0
		dc.l	NextModuleGr1
		dc.b	3
		dc.b	0
		dc.l	0
.NextModuleImage2:dc.w	0
		dc.w	0
		dc.w	22
		dc.w	15
		dc.w	2
		dc.l	NextModuleGr2
		dc.b	3
		dc.b	0
		dc.l	0

	*------------ Stop - Play - Gadget -------------*
StopPlayGadget:	dc.l	EjectModuleGadget
		dc.w	StopPlayHori
		dc.w	StopPlayVerti
		dc.w	23		;KlickReihe2H1
		dc.w	15		;KlickReihe2v
		dc.w	$106
		dc.w	1
		dc.w	1
		dc.l	.StopPlayImage1
		dc.l	.StopPlayImage2
		dc.l	0
		dc.l	0
		dc.l	0
		dc.w	EPNr_StopPlay
		dc.l	0
.StopPlayImage1:dc.w	0
		dc.w	0
		dc.w	23
		dc.w	15
		dc.w	0
		dc.l	StopPlayGr1
		dc.b	3
		dc.b	0
		dc.l	0
.StopPlayImage2:dc.w	0
		dc.w	0
		dc.w	23
		dc.w	15
		dc.w	2
		dc.l	StopPlayGr2
		dc.b	3
		dc.b	0
		dc.l	0

	*------------ Stop - Play - String-Gadget -------------*
EjectModuleGadget:dc.l	DisketteGadget
		dc.w	EjectModuleHori
		dc.w	EjectModuleVerti
		dc.w	23		;KlickReihe2H1+1
		dc.w	15		;KlickReihe2v
		dc.w	$106
		dc.w	1
		dc.w	1
		dc.l	.EjectModuleImage1
		dc.l	.EjectModuleImage2
		dc.l	0
		dc.l	0
		dc.l	0
		dc.w	EPNr_EjectModule
		dc.l	0
.EjectModuleImage1:dc.w	0
		dc.w	0
		dc.w	23
		dc.w	15
		dc.w	0
		dc.l	EjectModuleGr1
		dc.b	3
		dc.b	0
		dc.l	0
.EjectModuleImage2:dc.w	0
		dc.w	0
		dc.w	23
		dc.w	15
		dc.w	2
		dc.l	EjectModuleGr2
		dc.b	3
		dc.b	0
		dc.l	0

	*---------------- Diskette ------------------*
DisketteGadget:	dc.l	DummyGadget
		dc.w	DisketteHori
		dc.w	DisketteVerti
		dc.w	30		;KlickReihe2H2+1
		dc.w	15		;KlickReihe2v
		dc.w	6
		dc.w	1
		dc.w	1
		dc.l	.DisketteImage1
		dc.l	.DisketteImage2
		dc.l	0
		dc.l	0
		dc.l	0
		dc.w	EPNr_LoadModule
		dc.l	0
.DisketteImage1:dc.w	0
		dc.w	0
		dc.w	30
		dc.w	15
		dc.w	0
		dc.l	DisketteGr1
		dc.b	3
		dc.b	0
		dc.l	0
.DisketteImage2:dc.w	0
		dc.w	0
		dc.w	30
		dc.w	15
		dc.w	2
		dc.l	DisketteGr2
		dc.b	3
		dc.b	0
		dc.l	0


	*----------- DummyGadget fr Border -----------*
	*-- Mit diesem Gadget werden automatisch bei --*
	*-- einem UnZip alle Linien nachgezeichnet   --*
	*----------------------------------------------*
DummyGadget:	dc.l	SpeedReglerGadget
		dc.w	FilterHori+15
		dc.w	FilterVerti
		dc.w	1
		dc.w	1
		dc.w	3
		dc.w	1
		dc.w	1
		dc.l	TextBorder
		dc.l	0
		dc.l	0
		dc.l	0
		dc.l	0
		dc.w	0
		dc.l	0

	*--------- Proportional-Gadget (Speed-Regler) ---------*
SpeedReglerGadget:
		dc.l	0
		dc.w	SpeedHori+2
		dc.w	SpeedVerti+1
		dc.w	Speedbreite-4
		dc.w	SpeedHohe-2
		dc.w	$106
		dc.w	3
		dc.w	3
		dc.l	.SpeedImage1
		dc.l	.SpeedImage2
		dc.l	0
		dc.l	0
		dc.l	SpeedProp
		dc.w	EPNr_Speed
		dc.l	0
.SpeedImage1:	dc.w	0
		dc.w	0
		dc.w	SpeedBreite-4
		dc.w	SpeedReglerHohe
		dc.w	0
		dc.l	SpeedReglerGr1
		dc.b	3
		dc.b	0
		dc.l	0
.SpeedImage2:	dc.w	0
		dc.w	0
		dc.w	SpeedBreite-4
		dc.w	SpeedReglerHohe
		dc.w	2
		dc.l	SpeedReglerGr2
		dc.b	3
		dc.b	0
		dc.l	0
SpeedProp:	dc.w	4+8
		dc.w	0				;$7fff
		dc.w	SpeedPosi
		dc.w	0
		dc.w	SpeedSteps
		dc.w	0
		dc.w	0
		dc.w	0
		dc.w	0
		dc.w	0
		dc.w	0

*------------------------------ Border-Definitionen -------------------------*
TextBorder:	dc.w	-FilterHori-15
		dc.w	-FilterVerti
		dc.b	1
		dc.b	0
		dc.b	1
		dc.b	5
		dc.l	TextKoortab
		dc.l	TextBorder2

TextBorder2:	dc.w	-FilterHori-15
		dc.w	-FilterVerti
		dc.b	2
		dc.b	0
		dc.b	1
		dc.b	6
		dc.l	TextKoortab2
		dc.l	VolumeBorder

VolumeBorder:	dc.w	-FilterHori-15
		dc.w	-FilterVerti
		dc.b	1
		dc.b	0
		dc.b	1
		dc.b	5
		dc.l	VolumeKoortab
		dc.l	VolumeBorder2

VolumeBorder2:	dc.w	-FilterHori-15
		dc.w	-FilterVerti
		dc.b	2
		dc.b	0
		dc.b	1
		dc.b	6
		dc.l	VolumeKoortab2
		dc.l	Balanceborder

BalanceBorder:	dc.w	-FilterHori-15
		dc.w	-FilterVerti
		dc.b	1
		dc.b	0
		dc.b	1
		dc.b	5
		dc.l	BalanceKoortab
		dc.l	BalanceBorder2

BalanceBorder2:	dc.w	-FilterHori-15
		dc.w	-FilterVerti
		dc.b	2
		dc.b	0
		dc.b	1
		dc.b	6
		dc.l	BalanceKoortab2
		dc.l	SpeedBorder

SpeedBorder:	dc.w	-FilterHori-15
		dc.w	-FilterVerti
		dc.b	1
		dc.b	0
		dc.b	1
		dc.b	5
		dc.l	SpeedKoortab
		dc.l	SpeedBorder2

SpeedBorder2:	dc.w	-FilterHori-15
		dc.w	-FilterVerti
		dc.b	2
		dc.b	0
		dc.b	1
		dc.b	6
		dc.l	SpeedKoortab2
		dc.l	0

TextKoortab:	dc.w	BorderLinks
		dc.w	BorderOben
		dc.w	BorderLinks
		dc.w	BorderUnten
		dc.w	BorderLinks+1
		dc.w	BorderUnten
		dc.w	BorderLinks+1
		dc.w	BorderOben
		dc.w	BorderBreite+1
		dc.w	BorderOben

TextKoortab2:	dc.w	BorderLinks+1
		dc.w	BorderUnten
		dc.w	BorderBreite
		dc.w	BorderUnten
		dc.w	BorderBreite
		dc.w	BorderOben
		dc.w	BorderBreite
		dc.w	BorderOben+1
		dc.w	BorderBreite-1
		dc.w	BorderOben+1
		dc.w	BorderBreite-1
		dc.w	BorderUnten

VolumeKoortab:	dc.w	VolumeHori
		dc.w	VolumeVerti
		dc.w	VolumeHori
		dc.w	VolumeVerti+ProHohe-1
		dc.w	VolumeHori+1
		dc.w	VolumeVerti+ProHohe-1
		dc.w	VolumeHori+1
		dc.w	VolumeVerti
		dc.w	Volumehori+1+VolumeBreite-2
		dc.w	VolumeVerti

VolumeKoortab2:	dc.w	VolumeHori+1
		dc.w	VolumeVerti+ProHohe-1
		dc.w	VolumeHori+VolumeBreite-1
		dc.w	VolumeVerti+ProHohe-1
		dc.w	VolumeHori+VolumeBreite-1
		dc.w	VolumeVerti
		dc.w	VolumeHori+VolumeBreite-1
		dc.w	VolumeVerti+1
		dc.w	VolumeHori-1+(VolumeBreite-1)
		dc.w	VolumeVerti+1
		dc.w	VolumeHori-1+(VolumeBreite-1)
		dc.w	VolumeVerti+ProHohe-1


BalanceKoortab:	dc.w	BalanceHori
		dc.w	BalanceVerti
		dc.w	BalanceHori
		dc.w	BalanceVerti+ProHohe-1
		dc.w	BalanceHori+1
		dc.w	BalanceVerti+ProHohe-1
		dc.w	BalanceHori+1
		dc.w	BalanceVerti
		dc.w	Balancehori+1+BalanceBreite-2
		dc.w	BalanceVerti

BalanceKoortab2:dc.w	BalanceHori+1
		dc.w	BalanceVerti+ProHohe-1
		dc.w	BalanceHori+BalanceBreite-1
		dc.w	BalanceVerti+ProHohe-1
		dc.w	BalanceHori+BalanceBreite-1
		dc.w	BalanceVerti
		dc.w	BalanceHori+BalanceBreite-1
		dc.w	BalanceVerti+1
		dc.w	BalanceHori-1+(BalanceBreite-1)
		dc.w	BalanceVerti+1
		dc.w	BalanceHori-1+(BalanceBreite-1)
		dc.w	BalanceVerti+ProHohe-1


SpeedKoortab:	dc.w	SpeedHori
		dc.w	SpeedVerti
		dc.w	SpeedHori
		dc.w	SpeedVerti+SpeedHohe-1
		dc.w	SpeedHori+1
		dc.w	SpeedVerti+SpeedHohe-1
		dc.w	SpeedHori+1
		dc.w	SpeedVerti
		dc.w	Speedhori+1+SpeedBreite-2
		dc.w	SpeedVerti

SpeedKoortab2:	dc.w	SpeedHori+1
		dc.w	SpeedVerti+SpeedHohe-1
		dc.w	SpeedHori+SpeedBreite-1
		dc.w	SpeedVerti+SpeedHohe-1
		dc.w	SpeedHori+SpeedBreite-1
		dc.w	SpeedVerti
		dc.w	SpeedHori+SpeedBreite-1
		dc.w	SpeedVerti+1
		dc.w	SpeedHori-1+(SpeedBreite-1)
		dc.w	SpeedVerti+1
		dc.w	SpeedHori-1+(SpeedBreite-1)
		dc.w	SpeedVerti+SpeedHohe-1


;*********** Leertabellen (spter im BSS-Hunk) ***********************
		section	1,BSS
		rsreset
Datas:
Utility		rs.l	1
IntSave:	rs.l	1
GrafSave:	rs.l	1
WinHandle:	rs.l	1
Port:		rs.l	1
mycmap:		rs.l	1
Handle:		rs.l	1
ScrollSignal:	rs.l	1
Mytask		rs.l	1
mypubscreen:	rs.l	1	;aktueller Publicscreen
Eaglename:	rs.l	2
Win_Hoehe:	rs.w	1

mytags:		rs.l	30*2
myzoom:		rs.w	3
myhoehe2:	rs.w	1
myhoehe1:	rs.w	1	;Hhe der Titelzeile

Intmerk		rs.w	1
Intset		rs.w	1
inter:		rs.l	2
		rs.b	1	;2
		rs.b	1	;127
		rs.l	3

;------------------ Daten fr die Gadgets ----------------------------------
myGAD1:		rs.l	3		;zur Zeit max. 3 Bordergads
BD_myclass	rs.l	1		;fr Bordergadgets
GD_myclass	rs.l	1		;fr normale Gadgets

lastbordertop	rs.w	1		;fr Gadgetpositionen
lastborderleft	rs.w	1

GD_FirstGadget rs.l	1	;erstes Gadget im Hauptfenster ohne Bordergads
GD_Count	rs.l	1	;Anzahl der Gadgets (Buttons und Prop)

NextSelect	rs.l	1
LastNummer	rs.l	1
LastNummerGadAdr rs.l	1
*MenuOn		rs.w	1
GadgetsDa	rs.w	1
WindowMSG	rs.l	1
MenuStrip	rs.l	1

PattTime	rs.w	1		;wie lange gewartet wird, bis "NextPattern" gesendet wird
Lastvolume	rs.w	1

;------------------------------------- Daten fr den Scroller ---------------------------
DiskFont	rs.l	1	;Diskfont Library (wenn nicht da -> TOPAZ 8)

	ifne	Scroller

Nametemp	rs.b	30	;Name des Fonts,der vom Requester/Konfig kommt
Hoehetemp	rs.w	1	;Hhe des ............................

SCR_xpos	rs.w	1	;X-Pos im Fenster
SCR_ypos	rs.w	1	;Y-Pos im Fenster
SCR_Width	rs.w	1	;Breite des sichtbaren Scrollerbereiches
SCR_font_max	rs.w	1	;Max. Hoehe des Scrolfonts

SCR_Enable	rs.b	1	;Scroller erlaubt (<>0) oder verboten (=0)
SCR_CharTMP	rs.b	1	;Zeichen Temp. wg. LVOText
SCR_StopID	rs.b	1	;Stop, wenn fertig ja/nein
		rs.b	1
SCR_maxoff	rs.w	1	;justify
SCR_StepsLeft	rs.w	1	;wieviel Schritte noch bis zum nchsten Zeichen
SCR_NumSteps	rs.w	1	;wieviele Schritte insgesamt beim Scrollen
SCR_StopSteps	rs.w	1	;vieviele Schritte maximal bis stop ?
SCR_Offset0	rs.w	1	;Posi an linker Seite
SCR_Offset1	rs.w	1	;Posi rechter Teil
SCR_ScrolCurr	rs.l	1	;Pointer auf aktuelle Position im ScrolText
SCR_ScrolText	rs.l	1	;SCR_ScrolText
SCR_TextAttr	rs.b	ta_sizeof+4*2;TextAttr fr Openfont calls + Text extent space 
SCR_FontAdr	rs.l	1	;allozierter Font
SCR_RastPort	rs.b	rp_SIZEOF;eigener RastPort
SCR_Limitwidth	rs.w	1	;wieviel weniger Pixel als normal printen ?
SCR_Bitmap:	rs.b	8	;eigene Bitmap fr den RastPort
		rs.l	8
SCR_FontNAME	rs.b	30	;Name des Fonts (z.B. helvetica.font)
SCR_Fontheight	rs.w	1
SCR_LastPrinted rs.l	1	;Zuletzt ber Printtext ausgegeben
SCR_TextStructAdr rs.l	1	;Letzter Text, der vom EP kam
	endc
TimeTMP		rs.l	4	;sollte reichen fr Zeitanzeige

;----------------------- Daten fr die Crunchanzeige -----------------------------------
lastcrunchpos		rs.w	1

;------------------------ Daten fr die Zeitanzeige ---------------------------------------
	ifne	time
TimeY		rs.w	1	;fr Zeitanzeige
TimeX		rs.w	1
TimeWy		rs.w	1
TimeWx		rs.w	1
Timecount	rs.w	1
	endc

DatasLen:	rs.w	0
		ds.b	DatasLen

		section	img,data_C
	*-7*-----------------------------------------------------------------------*
	*------- Gadget-BinrZeichen EaglePlayer V1.52 by Eagleeye ------*
	*------- letzte nderung 21.04.1994			   ------*
	*----------------------------------------------------------------*
Voice1Gr1:	;19,11
		dc.w	$FFFF,$C000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000
		dc.w	$0000,$2000,$0000,$6000,$0060,$6000,$00E0,$6000
		dc.w	$0060,$6000,$0060,$6000,$0060,$6000,$0060,$6000
		dc.w	$00F0,$6000,$0000,$6000,$7FFF,$E000
Voice1Gr2:	dc.w	$0000,$2000,$0000,$6000,$0000,$6000,$0000,$6000
		dc.w	$0000,$6000,$0000,$6000,$0000,$6000,$0000,$6000
		dc.w	$0000,$6000,$0000,$6000,$7FFF,$E000
		dc.w	$FFFF,$C000,$C000,$0000,$C060,$0000,$C0E0,$0000
		dc.w	$C060,$0000,$C060,$0000,$C060,$0000,$C060,$0000
		dc.w	$C0F0,$0000,$C000,$0000,$8000,$0000


Voice2Gr1:	;19,11
		dc.w	$FFFF,$C000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000
		dc.w	$0000,$2000,$0000,$6000,$01F0,$6000,$0318,$6000
		dc.w	$0018,$6000,$00F0,$6000,$0180,$6000,$0300,$6000
		dc.w	$03F8,$6000,$0000,$6000,$7FFF,$E000
Voice2Gr2:	dc.w	$0000,$2000,$0000,$6000,$0000,$6000,$0000,$6000
		dc.w	$0000,$6000,$0000,$6000,$0000,$6000,$0000,$6000
		dc.w	$0000,$6000,$0000,$6000,$7FFF,$E000
		dc.w	$FFFF,$C000,$C000,$0000,$C1F0,$0000,$C318,$0000
		dc.w	$C018,$0000,$C0F0,$0000,$C180,$0000,$C300,$0000
		dc.w	$C3F8,$0000,$C000,$0000,$8000,$0000

Voice3Gr1:	dc.w	$FFFF,$C000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000
		dc.w	$0000,$2000,$0000,$6000,$01F0,$6000,$0318,$6000
		dc.w	$0018,$6000,$00F0,$6000,$0018,$6000,$0318,$6000
		dc.w	$01F0,$6000,$0000,$6000,$7FFF,$E000

Voice3Gr2:	dc.w	$0000,$2000,$0000,$6000,$0000,$6000,$0000,$6000
		dc.w	$0000,$6000,$0000,$6000,$0000,$6000,$0000,$6000
		dc.w	$0000,$6000,$0000,$6000,$7FFF,$E000
		dc.w	$FFFF,$C000,$C000,$0000,$C1F0,$0000,$C318,$0000
		dc.w	$C018,$0000,$C0F0,$0000,$C018,$0000,$C318,$0000
		dc.w	$C1F0,$0000,$C000,$0000,$8000,$0000

Voice4Gr1:	dc.w	$FFFF,$C000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000
		dc.w	$0000,$2000,$0000,$6000,$0070,$6000,$00F0,$6000
		dc.w	$01B0,$6000,$0330,$6000,$03F8,$6000,$0030,$6000
		dc.w	$0030,$6000,$0000,$6000,$7FFF,$E000
Voice4Gr2:	dc.w	$0000,$2000,$0000,$6000,$0000,$6000,$0000,$6000
		dc.w	$0000,$6000,$0000,$6000,$0000,$6000,$0000,$6000
		dc.w	$0000,$6000,$0000,$6000,$7FFF,$E000
		dc.w	$FFFF,$C000,$C000,$0000,$C070,$0000,$C0F0,$0000
		dc.w	$C1B0,$0000,$C330,$0000,$C3F8,$0000,$C030,$0000
		dc.w	$C030,$0000,$C000,$0000,$8000,$0000

AboutGr1:	;18/18
		dc.w	$FFFF,$8000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C200,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C200,$0000,$C000,$0000
		dc.w	$C000,$0000,$8000,$0000
		dc.w	$0000,$4000,$0000,$C000,$0000,$C000,$03E0,$C000
		dc.w	$07F0,$C000,$07F0,$C000,$03E0,$C000,$0000,$C000
		dc.w	$07E0,$C000,$03E0,$C000,$01E0,$C000,$01E0,$C000
		dc.w	$01E0,$C000,$01E0,$C000,$03E0,$C000,$07F8,$C000
		dc.w	$0000,$C000,$7FFF,$C000
AboutGr2:	dc.w	$0000,$4000,$0000,$C000,$0000,$C000,$0000,$C000
		dc.w	$0000,$C000,$0000,$C000,$0000,$C000,$0000,$C000
		dc.w	$0000,$C000,$0200,$C000,$0000,$C000,$0000,$C000
		dc.w	$0000,$C000,$0000,$C000,$0200,$C000,$0000,$C000
		dc.w	$0000,$C000,$7FFF,$C000
		dc.w	$FFFF,$8000,$C000,$0000,$C000,$0000,$C3E0,$0000
		dc.w	$C7F0,$0000,$C7F0,$0000,$C3E0,$0000,$C000,$0000
		dc.w	$C7E0,$0000,$C3E0,$0000,$C1E0,$0000,$C1E0,$0000
		dc.w	$C1E0,$0000,$C1E0,$0000,$C3E0,$0000,$C7F8,$0000
		dc.w	$C000,$0000,$8000,$0000



PlayerWindowGr1:	;19,18
		dc.w	$FFFF,$C000,$C000,$0000,$C000,$0000,$C008,$0000
		dc.w	$C060,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C060,$0000,$C008,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$8000,$0000
		dc.w	$0000,$2000,$0000,$6000,$0000,$6000,$0FF8,$6000
		dc.w	$07FC,$6000,$078E,$6000,$078E,$6000,$078E,$6000
		dc.w	$07FC,$6000,$07F8,$6000,$0780,$6000,$0780,$6000
		dc.w	$0780,$6000,$0780,$6000,$0780,$6000,$0FC0,$6000
		dc.w	$0000,$6000,$7FFF,$E000
PlayerWindowGr2:dc.w	$0000,$2000,$0000,$6000,$0000,$6000,$0008,$6000
		dc.w	$0060,$6000,$0000,$6000,$0000,$6000,$0000,$6000
		dc.w	$0060,$6000,$0008,$6000,$0000,$6000,$0000,$6000
		dc.w	$0000,$6000,$0000,$6000,$0000,$6000,$0000,$6000
		dc.w	$0000,$6000,$7FFF,$E000
		dc.w	$FFFF,$C000,$C000,$0000,$C000,$0000,$CFF8,$0000
		dc.w	$C7FC,$0000,$C78E,$0000,$C78E,$0000,$C78E,$0000
		dc.w	$C7FC,$0000,$C7F8,$0000,$C780,$0000,$C780,$0000
		dc.w	$C780,$0000,$C780,$0000,$C780,$0000,$CFC0,$0000
		dc.w	$C000,$0000,$8000,$0000


DefVolumeGr1:	;49,9
		dc.w	$FFFF,$FFFF,$FFF8,$C000,$0000,$0000,$C000,$0000
		dc.w	$0680,$C000,$000D,$5540,$C000,$3AAA,$AA80,$C075
		dc.w	$5555,$5540,$CAAA,$AAAA,$AA80,$C000,$0000,$0000
		dc.w	$8000,$0000,$0000
		dc.w	$0000,$0000,$0004,$0000,$0000,$000C,$0000,$0000
		dc.w	$07CC,$0000,$000F,$FFCC,$0000,$3FFF,$FFCC,$007F
		dc.w	$FFFF,$FFCC,$0FFF,$FFFF,$FFCC,$0000,$0000,$000C
		dc.w	$7FFF,$FFFF,$FFFC
DefVolumeGr2:	dc.w	$0000,$0000,$0004,$0000,$0000,$000C,$0000,$0000
		dc.w	$068C,$0000,$000D,$554C,$0000,$3AAA,$AA8C,$0075
		dc.w	$5555,$554C,$0AAA,$AAAA,$AA8C,$0000,$0000,$000C
		dc.w	$7FFF,$FFFF,$FFFC
		dc.w	$FFFF,$FFFF,$FFF8,$C000,$0000,$0000,$C000,$0000
		dc.w	$07C0,$C000,$000F,$FFC0,$C000,$3FFF,$FFC0,$C07F
		dc.w	$FFFF,$FFC0,$CFFF,$FFFF,$FFC0,$C000,$0000,$0000
		dc.w	$8000,$0000,$0000



DefBalanceGr1:	dc.w	$FFFF,$FFFF,$FFF8,$C000,$0000,$0000,$C600,$0000
		dc.w	$0140,$CAA0,$0000,$1A80,$C556,$0001,$5540,$CAAA
		dc.w	$A01A,$AA80,$C555,$54D5,$5540,$C000,$0000,$0000
		dc.w	$8000,$0000,$0000
		dc.w	$0000,$0000,$0004,$0000,$0000,$000C,$0E00,$0000
		dc.w	$01CC,$0FE0,$0000,$1FCC,$0FFE,$0001,$FFCC,$0FFF
		dc.w	$E01F,$FFCC,$0FFF,$FCFF,$FFCC,$0000,$0000,$000C
		dc.w	$7FFF,$FFFF,$FFFC
DefBalanceGr2:	dc.w	$0000,$0000,$0004,$0000,$0000,$000C,$0600,$0000
		dc.w	$014C,$0AA0,$0000,$1A8C,$0556,$0001,$554C,$0AAA
		dc.w	$A01A,$AA8C,$0555,$54D5,$554C,$0000,$0000,$000C
		dc.w	$7FFF,$FFFF,$FFFC
		dc.w	$FFFF,$FFFF,$FFF8,$C000,$0000,$0000,$CE00,$0000
		dc.w	$01C0,$CFE0,$0000,$1FC0,$CFFE,$0001,$FFC0,$CFFF
		dc.w	$E01F,$FFC0,$CFFF,$FCFF,$FFC0,$C000,$0000,$0000
		dc.w	$8000,$0000,$0000


VolumeReglerGr1:	;19,7
		dc.w	$FFFF,$C000,$C000,$0000,$C000,$0000,$C010,$0000
		dc.w	$C0E0,$0000,$C000,$0000,$8000,$0000
		dc.w	$0000,$2000,$0000,$6000,$00E0,$6000,$0100,$6000
		dc.w	$0000,$6000,$0000,$6000,$7FFF,$E000
VolumeReglerGr2:dc.w	$0000,$2000,$0000,$6000,$0000,$6000,$0010,$6000
		dc.w	$00E0,$6000,$0000,$6000,$7FFF,$E000
		dc.w	$FFFF,$C000,$C000,$0000,$C0E0,$0000,$C100,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000

BalanceReglerGr1:	;19,7
		dc.w	$FFFF,$C000,$C000,$0000,$C000,$0000,$C010,$0000
		dc.w	$C0E0,$0000,$C000,$0000,$8000,$0000
		dc.w	$0000,$2000,$0000,$6000,$00E0,$6000,$0100,$6000
		dc.w	$0000,$6000,$0000,$6000,$7FFF,$E000
BalanceReglerGr2:dc.w	$0000,$2000,$0000,$6000,$0000,$6000,$0010,$6000
		dc.w	$00E0,$6000,$0000,$6000,$7FFF,$E000
		dc.w	$FFFF,$C000,$C000,$0000,$C0E0,$0000,$C100,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000

SpeedReglerGr1:		;11,9
		dc.w	$FFC0,$C000,$C000,$C000,$C100,$CE00,$C000,$C000,$8000
		dc.w	$0020,$0060,$0060,$0E60,$1060,$0060,$0060,$0060,$7FE0
SpeedReglerGr2:	dc.w	$0020,$0060,$0060,$0060,$0160,$0E60,$0060,$0060,$7FE0
		dc.w	$FFC0,$C000,$C000,$CE00,$D000,$C000,$C000,$C000,$8000


IconifyGr1:	;18,9
		dc.w	$FFFF,$8000,$C000,$0000,$C038,$0000,$D8E8,$0000
		dc.w	$C380,$0000,$C006,$0000,$C780,$0000,$C300,$0000
		dc.w	$8000,$0000
		dc.w	$0000,$4000,$0000,$C000,$1FB8,$C000,$1BE8,$C000
		dc.w	$0FBC,$C000,$1F8E,$C000,$07BE,$C000,$0300,$C000
		dc.w	$7FFF,$C000
IconifyGr2:	dc.w	$0000,$4000,$0000,$C000,$0038,$C000,$18E8,$C000
		dc.w	$0380,$C000,$0006,$C000,$0780,$C000,$0300,$C000
		dc.w	$7FFF,$C000
		dc.w	$FFFF,$8000,$C000,$0000,$DFB8,$0000,$DBE8,$0000
		dc.w	$CFBC,$0000,$DF8E,$0000,$C7BE,$0000,$C300,$0000
		dc.w	$8000,$0000

FilterGr1:	;18,9
		dc.w	$FFFF,$8000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$8000,$0000
		dc.w	$0000,$4000,$0000,$C000,$1FFE,$C000,$19E6,$C000
		dc.w	$18C6,$C000,$19E6,$C000,$1FFE,$C000,$0000,$C000
		dc.w	$7FFF,$C000
FilterGr2:	dc.w	$0000,$4000,$0000,$C000,$0000,$C000,$0000,$C000
		dc.w	$0000,$C000,$0000,$C000,$0000,$C000,$0000,$C000
		dc.w	$7FFF,$C000
		dc.w	$FFFF,$8000,$C000,$0000,$DFFE,$0000,$D9E6,$0000
		dc.w	$D8C6,$0000,$D9E6,$0000,$DFFE,$0000,$C000,$0000
		dc.w	$8000,$0000


PrevModuleGr1:	;22,15
		dc.w	$FFFF,$F800,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000
		dc.w	$0000,$0400,$0000,$0C00,$0000,$0C00,$0000,$0C00
		dc.w	$0601,$8C00,$0607,$8C00,$061F,$8C00,$067F,$8C00
		dc.w	$061F,$8C00,$0607,$8C00,$0601,$8C00,$0000,$0C00
		dc.w	$0000,$0C00,$0000,$0C00,$7FFF,$FC00
PrevModuleGr2:	dc.w	$0000,$0400,$0000,$0C00,$0000,$0C00,$0000,$0C00
		dc.w	$0000,$0C00,$0000,$0C00,$0000,$0C00,$0000,$0C00
		dc.w	$0000,$0C00,$0000,$0C00,$0000,$0C00,$0000,$0C00
		dc.w	$0000,$0C00,$0000,$0C00,$7FFF,$FC00
		dc.w	$FFFF,$F800,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C601,$8000,$C607,$8000,$C61F,$8000,$C67F,$8000
		dc.w	$C61F,$8000,$C607,$8000,$C601,$8000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000



PrevSongGr1:	;22,15
		dc.w	$FFFF,$F800,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000
		dc.w	$0000,$0400,$0000,$0C00,$0000,$0C00,$0000,$0C00
		dc.w	$0006,$0C00,$001E,$0C00,$007E,$0C00,$01FE,$0C00
		dc.w	$007E,$0C00,$001E,$0C00,$0006,$0C00,$0000,$0C00
		dc.w	$0000,$0C00,$0000,$0C00,$7FFF,$FC00
PrevSongGr2:	dc.w	$0000,$0400,$0000,$0C00,$0000,$0C00,$0000,$0C00
		dc.w	$0000,$0C00,$0000,$0C00,$0000,$0C00,$0000,$0C00
		dc.w	$0000,$0C00,$0000,$0C00,$0000,$0C00,$0000,$0C00
		dc.w	$0000,$0C00,$0000,$0C00,$7FFF,$FC00
		dc.w	$FFFF,$F800,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C006,$0000,$C01E,$0000,$C07E,$0000,$C1FE,$0000
		dc.w	$C07E,$0000,$C01E,$0000,$C006,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000



PrevPatternGr1:	;30,15
		dc.w	$FFFF,$FFF8,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000
		dc.w	$0000,$0004,$0000,$000C,$0000,$000C,$0000,$000C
		dc.w	$0030,$0CCC,$00F0,$3CCC,$03F0,$FCCC,$0FF3,$FCCC
		dc.w	$03F0,$FCCC,$00F0,$3CCC,$0030,$0CCC,$0000,$000C
		dc.w	$0000,$000C,$0000,$000C,$7FFF,$FFFC
PrevPatternGr2:	dc.w	$0000,$0004,$0000,$000C,$0000,$000C,$0000,$000C
		dc.w	$0000,$000C,$0000,$000C,$0000,$000C,$0000,$000C
		dc.w	$0000,$000C,$0000,$000C,$0000,$000C,$0000,$000C
		dc.w	$0000,$000C,$0000,$000C,$7FFF,$FFFC
		dc.w	$FFFF,$FFF8,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C030,$0CC0,$C0F0,$3CC0,$C3F0,$FCC0,$CFF3,$FCC0
		dc.w	$C3F0,$FCC0,$C0F0,$3CC0,$C030,$0CC0,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000

ReplaySongGr1:	;26,15
		dc.w	$FFFF,$FF80,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000
		dc.w	$0000,$0040,$0000,$00C0,$0000,$00C0,$0000,$00C0
		dc.w	$0666,$00C0,$0667,$80C0,$0667,$E0C0,$0667,$F8C0
		dc.w	$0667,$E0C0,$0667,$80C0,$0666,$00C0,$0000,$00C0
		dc.w	$0000,$00C0,$0000,$00C0,$7FFF,$FFC0
ReplaySongGr2:	dc.w	$0000,$0040,$0000,$00C0,$0000,$00C0,$0000,$00C0
		dc.w	$0000,$00C0,$0000,$00C0,$0000,$00C0,$0000,$00C0
		dc.w	$0000,$00C0,$0000,$00C0,$0000,$00C0,$0000,$00C0
		dc.w	$0000,$00C0,$0000,$00C0,$7FFF,$FFC0
		dc.w	$FFFF,$FF80,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C666,$0000,$C667,$8000,$C667,$E000,$C667,$F800
		dc.w	$C667,$E000,$C667,$8000,$C666,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000

PlayModuleGr1:	;24,15
		dc.w	$FFFF,$FE00,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000
		dc.w	$0000,$0100,$0000,$0300,$0000,$0300,$0000,$0300
		dc.w	$0330,$0300,$033C,$0300,$033F,$0300,$033F,$C300
		dc.w	$033F,$0300,$033C,$0300,$0330,$0300,$0000,$0300
		dc.w	$0000,$0300,$0000,$0300,$7FFF,$FF00
PlayModuleGr2:	dc.w	$0000,$0100,$0000,$0300,$0000,$0300,$0000,$0300
		dc.w	$0000,$0300,$0000,$0300,$0000,$0300,$0000,$0300
		dc.w	$0000,$0300,$0000,$0300,$0000,$0300,$0000,$0300
		dc.w	$0000,$0300,$0000,$0300,$7FFF,$FF00
		dc.w	$FFFF,$FE00,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C330,$0000,$C33C,$0000,$C33F,$0000,$C33F,$C000
		dc.w	$C33F,$0000,$C33C,$0000,$C330,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000


PlayFasterGr1:	;28,15
		dc.w	$FFFF,$FFE0,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000
		dc.w	$0000,$0010,$0000,$0030,$0000,$0030,$0000,$0030
		dc.w	$0787,$8030,$01E1,$E030,$0078,$7830,$001E,$1E30
		dc.w	$0078,$7830,$01E1,$E030,$0787,$8030,$0000,$0030
		dc.w	$0000,$0030,$0000,$0030,$7FFF,$FFF0

PlayFasterGr2:	dc.w	$0000,$0010,$0000,$0030,$0000,$0030,$0000,$0030
		dc.w	$0000,$0030,$0000,$0030,$0000,$0030,$0000,$0030
		dc.w	$0000,$0030,$0000,$0030,$0000,$0030,$0000,$0030
		dc.w	$0000,$0030,$0000,$0030,$7FFF,$FFF0
		dc.w	$FFFF,$FFE0,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C787,$8000,$C1E1,$E000,$C078,$7800,$C01E,$1E00
		dc.w	$C078,$7800,$C1E1,$E000,$C787,$8000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000




NextPatternGr1:	;30,15
		dc.w	$FFFF,$FFF8,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000
		dc.w	$0000,$0004,$0000,$000C,$0000,$000C,$0000,$000C
		dc.w	$0CC0,$300C,$0CF0,$3C0C,$0CFC,$3F0C,$0CFF,$3FCC
		dc.w	$0CFC,$3F0C,$0CF0,$3C0C,$0CC0,$300C,$0000,$000C
		dc.w	$0000,$000C,$0000,$000C,$7FFF,$FFFC
NextPatternGr2:	dc.w	$0000,$0004,$0000,$000C,$0000,$000C,$0000,$000C
		dc.w	$0000,$000C,$0000,$000C,$0000,$000C,$0000,$000C
		dc.w	$0000,$000C,$0000,$000C,$0000,$000C,$0000,$000C
		dc.w	$0000,$000C,$0000,$000C,$7FFF,$FFFC
		dc.w	$FFFF,$FFF8,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$CCC0,$3000,$CCF0,$3C00,$CCFC,$3F00,$CCFF,$3FC0
		dc.w	$CCFC,$3F00,$CCF0,$3C00,$CCC0,$3000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000



NextSongGr1:	;22,15
		dc.w	$FFFF,$F800,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000
		dc.w	$0000,$0400,$0000,$0C00,$0000,$0C00,$0000,$0C00
		dc.w	$0180,$0C00,$01E0,$0C00,$01F8,$0C00,$01FE,$0C00
		dc.w	$01F8,$0C00,$01E0,$0C00,$0180,$0C00,$0000,$0C00
		dc.w	$0000,$0C00,$0000,$0C00,$7FFF,$FC00
NextSongGr2:	dc.w	$0000,$0400,$0000,$0C00,$0000,$0C00,$0000,$0C00
		dc.w	$0000,$0C00,$0000,$0C00,$0000,$0C00,$0000,$0C00
		dc.w	$0000,$0C00,$0000,$0C00,$0000,$0C00,$0000,$0C00
		dc.w	$0000,$0C00,$0000,$0C00,$7FFF,$FC00
		dc.w	$FFFF,$F800,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C180,$0000,$C1E0,$0000,$C1F8,$0000,$C1FE,$0000
		dc.w	$C1F8,$0000,$C1E0,$0000,$C180,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000


NextModuleGr1:	;22,15
		dc.w	$FFFF,$F800,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000
		dc.w	$0000,$0400,$0000,$0C00,$0000,$0C00,$0000,$0C00
		dc.w	$0601,$8C00,$0781,$8C00,$07E1,$8C00,$07F9,$8C00
		dc.w	$07E1,$8C00,$0781,$8C00,$0601,$8C00,$0000,$0C00
		dc.w	$0000,$0C00,$0000,$0C00,$7FFF,$FC00
NextModuleGr2:	dc.w	$0000,$0400,$0000,$0C00,$0000,$0C00,$0000,$0C00
		dc.w	$0000,$0C00,$0000,$0C00,$0000,$0C00,$0000,$0C00
		dc.w	$0000,$0C00,$0000,$0C00,$0000,$0C00,$0000,$0C00
		dc.w	$0000,$0C00,$0000,$0C00,$7FFF,$FC00
		dc.w	$FFFF,$F800,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C601,$8000,$C781,$8000,$C7E1,$8000,$C7F9,$8000
		dc.w	$C7E1,$8000,$C781,$8000,$C601,$8000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000

StopPlayGr1:	;23,15
		dc.w	$FFFF,$FC00,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000
		dc.w	$0000,$0200,$0000,$0600,$0000,$0600,$0000,$0600
		dc.w	$03FF,$8600,$03FF,$8600,$03FF,$8600,$03FF,$8600
		dc.w	$03FF,$8600,$03FF,$8600,$03FF,$8600,$0000,$0600
		dc.w	$0000,$0600,$0000,$0600,$7FFF,$FE00
StopPlayGr2:	dc.w	$0000,$0200,$0000,$0600,$0000,$0600,$0000,$0600
		dc.w	$0000,$0600,$0000,$0600,$0000,$0600,$0000,$0600
		dc.w	$0000,$0600,$0000,$0600,$0000,$0600,$0000,$0600
		dc.w	$0000,$0600,$0000,$0600,$7FFF,$FE00
		dc.w	$FFFF,$FC00,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C3FF,$8000,$C3FF,$8000,$C3FF,$8000,$C3FF,$8000
		dc.w	$C3FF,$8000,$C3FF,$8000,$C3FF,$8000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000

EjectModuleGr1:	;23,15
		dc.w	$FFFF,$FC00,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000
		dc.w	$0000,$0200,$0000,$0600,$0000,$0600,$0000,$0600
		dc.w	$0010,$0600,$0038,$0600,$007C,$0600,$01FF,$0600
		dc.w	$03FF,$8600,$0000,$0600,$03FF,$8600,$0000,$0600
		dc.w	$0000,$0600,$0000,$0600,$7FFF,$FE00
EjectModuleGr2:	dc.w	$0000,$0200,$0000,$0600,$0000,$0600,$0000,$0600
		dc.w	$0000,$0600,$0000,$0600,$0000,$0600,$0000,$0600
		dc.w	$0000,$0600,$0000,$0600,$0000,$0600,$0000,$0600
		dc.w	$0000,$0600,$0000,$0600,$7FFF,$FE00
		dc.w	$FFFF,$FC00,$C000,$0000,$C000,$0000,$C000,$0000
		dc.w	$C010,$0000,$C038,$0000,$C07C,$0000,$C1FF,$0000
		dc.w	$C3FF,$8000,$C000,$0000,$C3FF,$8000,$C000,$0000
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000

DisketteGr1:	;30,15
		dc.w	$FFFF,$FFF8,$C000,$0000,$C00F,$F800,$C00F,$C800
		dc.w	$C00F,$C800,$C00F,$F800,$C000,$0000,$C07F,$F800
		dc.w	$C0FF,$5C00,$C0FE,$BC00,$C0D5,$7C00,$C0EA,$FC00
		dc.w	$C000,$0000,$C000,$0000,$8000,$0000
		dc.w	$0000,$0004,$0000,$000C,$03F0,$070C,$07F0,$378C
		dc.w	$07F0,$378C,$07F0,$078C,$07FF,$FF8C,$0780,$078C
		dc.w	$0700,$A38C,$0701,$438C,$052A,$838C,$0715,$038C
		dc.w	$03FF,$FF0C,$0000,$000C,$7FFF,$FFFC
DisketteGr2:	dc.w	$0000,$0004,$0000,$000C,$000F,$F80C,$000F,$C80C
		dc.w	$000F,$C80C,$000F,$F80C,$0000,$000C,$007F,$F80C
		dc.w	$00FF,$5C0C,$00FE,$BC0C,$00D5,$7C0C,$00EA,$FC0C
		dc.w	$0000,$000C,$0000,$000C,$7FFF,$FFFC
		dc.w	$FFFF,$FFF8,$C000,$0000,$C3F0,$0700,$C7F0,$3780
		dc.w	$C7F0,$3780,$C7F0,$0780,$C7FF,$FF80,$C780,$0780
		dc.w	$C700,$A380,$C701,$4380,$C52A,$8380,$C715,$0380
		dc.w	$C3FF,$FF00,$C000,$0000,$8000,$0000

	end
