*****************************************************************************
**                                                                         **
** Engine: EMPYGUI24													   **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 

****************************************************************************************
*           Interface Layout System, basierend auf Custom-Images a la EMPY            *
*                                                                                      *
*            1998 Henryk "Buggs" Richter                                              *
*                                                                                      *
* EMPYGui2: TrueColor Images                                                           *
****************************************************************************************
;
;
Eagleplayer	=	1	;1 setzen fr Betrieb als Engine (auch wenn 0, werden
				;Eagleplayer Includes verlangt)
Inttest		=	0	;1 setzen, wenn Interrupttester laufen soll

FXTask		=	0	;1 setzen, wenn fr FX eigener Task verwendet werden soll
Semaphore	=	1	;1 =  Semaphore fr Zugriff auf "Showimage"-Funktion anlegen

ggfxdefaults	=	1	;1 setzen, wenn fr Dithermodus, Autodither, Autodither-Schwelle
				;und Histogrammtyp Guigfx-Defaults verwendet werden sollen
USEFPU		=	0
		;
ver		macro
		dc.b	"0.97"
		endm
structver	macro
		dc.w	0,97
		endm
date		macro
		dc.b	"10-Aug-98"
		endm
structdate	macro
		dc.b	10,8
		dc.w	1998
		endm
		;

;--------------- Typdefinitionen -----------
	rsreset
GLA_Dummy	rs.b	1	;als Trger von umzurechnenden Images verwendbar, z.B. Fonts usw.
GLA_Image	rs.b	1	;z.B. Fonts, Background Image, Bilder, die bei Initialisierung ins Fenster zu zeichnen sind
GLA_Button	rs.b	1	;Gadgets allgemein
GLA_WinDrag	rs.b	1	;Gadget zum Bewegen des Fensters, wird auch ber BOOPSI erzeugt
GLA_WinDepth	rs.b	1	;Gadget zum nach vorn/hinten Klicken des Fensters, wird auch ber BOOPSI erzeugt
GLA_WinClose	rs.b	1	;Gadget zum Fensterschlieen, wird auch ber BOOPSI erzeugt, kann 
				;durch normalen Button mit "EPNr_Quit" genauso gehandhabt werden
GLA_TextField	rs.b	1	;Textfield Objekt mit angehngtem TempImage und 
				;FontObjekt in MOL_UserData
GLA_Moused	rs.b	1	;Regler (Volume/Balance/Speed) mit angehngter REG_ Struktur
				;in MOL_UserData

;-------------- Fenster-Liste -----------------
;Vorsicht: es wird (noch) auf die Struktur direkt ohne Rcksicht auf diese
;          Definitionen zugegriffen bei "Openwin:"
	rsreset
WNL_Window	rs.l	1	;Pointer auf Fensterstruktur oder 0 fr Ende der Liste
WNL_Prefsflag	rs.l	1	;welches gesetzte Flag fr welche Fensterstruktur verwendet wird

;-------------- Fenster-Struktur -----------------
	rsreset
WIL_LeftEdge	rs.w	1	;Linker Rand, wird beim Schlieen neu gesetzt (n/a yet)
WIL_TopEdge	rs.w	1	;Oberer Rand, wird beim Schlieen neu gesetzt
WIL_Width	rs.w	1	;Breite
WIL_Height	rs.w	1	;Hhe
WIL_Flags	rs.l	1	;Window-Flags
WIL_IDCMP	rs.l	1	;Window-IDCMPFlags
WIL_Objects	rs.l	1	;Gadgets, Images usw.

;-------------- ObjektStruktur -----------------
	rsreset
MOL_Next	rs.l	1	;nchstes Objekt in der Liste
MOL_Type	rs.w	1	;Typ: GLA_Button, GLA_Image usw.
MOL_ID		rs.w	1	;ID Nummer, anhand dieser kann das Objekt wiedergefunden werden
MOL_Initialized	rs.l	1	;Gadget Struktur im Fenster (n/a yet)
MOL_Left	rs.w	1	;Leftedge bei Gadgets und Backdrop Images, sonst ignoriert
MOL_Top		rs.w	1	;Topedge
MOL_Width	rs.w	1	;Breite an sich nur bei Gadgets und Dummy-Objekten benutzt
MOL_Height	rs.w	1	;Hhe
MOL_Images	rs.l	1	;einfach verkettete Liste von Images (bei Buttons = 2)
MOL_Flags	rs.l	1	;Flags
				;GACT_TOGGLESELECT	;funktioniert (noch?) nicht
				;GACT_IMMEDIATE
				;GACT_RELVERIFY
				;GACT_FOLLOWMOUSE
				;GFLG_Disabled<<16
				;MFLG_Repeat==GFLG_LABELIMAGE<<16, bei GACT_IMMEDIATE nach kurzer Wartezeit Kommando wiederholen

MOL_React	rs.l	1	;Gadgets: Routine zur Abarbeitung des Events bei Anwahl
MOL_Command	rs.l	1	;bei simplen buttons: EPNr des Kommandos
MOL_CMDArg1	rs.l	1	;1. Argument zur EPNr (Sonderbedeutung bei GLA_Image)
MOL_CMDArg2	rs.l	1	;2. Argument zur EPNr (Sonderbedeutung bei GLA_Image)
MOL_UserData	rs.l	1	;undefiniert, i.d.R. frei verwendbar, wird aber nicht auf GG_Userdata bertragen !
				;verwendet z.B. fr Fontadresse bei Textdisplay-Objekten, Fontbreite bei Fonts,
				;REG_ Struktur fr Regler
;-------------- ImageStruktur -----------------
	rsreset
IML_Next	rs.l	1	;nchstes Objekt in der Liste
IML_Rendered	rs.l	1	;Bitmap Struktur mit umgerechnetem Image (somit flexibel bis zum Abwinken, z.B. Chunky oder 24 Bit Bitmaps durchaus mglich)
IML_Width	rs.w	1	;Breite
IML_Height	rs.w	1	;Hhe
IML_Type	rs.w	1	;Typ: momentan 	4 = 32 Bit 0RGB Chunky
				;               0 = 8 Bit Chunky
				;		5 = 32 Bit 0RGB Chunky, nicht in Bitmap umrechnen
				;
				;restliche Typen: (nicht mehr untersttzt)
				;	       1 = 4 Bit Chunky
				;              2 = 8 Bit Chunky, remapped in eine 8 Bit Chunky Bitmap, durch 16 teilbar !!!
				;              3 = 4 Bit Chunky, remapped in eine 8 Bit Chunky Bitmap, durch 16 teilbar !!!

IML_ColourMap	rs.l	1	;Farbtabelle (oder 0 fr default)
				;Aufbau: 1.Wort:   Anzahl der Farben
				;        2.-n. LW: 0RGB
				;fr Typ5 (32 Bit 0RGB) wird hier das DirectDrawHandle eingetragen

IML_Data	rs.l	1	;Pointer auf Imagerohdaten
IML_Sizeof	rs.b	0

;------------- Struktur fr Regler ------------

	rsreset
REG_Type	rs.w	1	;Typ (siehe unten)
REG_Enable	rs.w	1	;wenn <>0, dann Zugriff erlaubt (Test, ob Klick innerhalb des Radius erfolgte)
REG_XCenter	rs.w	1	;X-Position der Mitte des Reglers (bzw. beim Anklicken fr Horizontalregler)
REG_YCenter	rs.w	1	;Y-Position der Mitte des Reglers (bzw. beim Anklicken fr Vertikalregler)
REG_MinRadius	rs.w	1	;Minimaler Radius, in dem ein Klick akzeptiert wird bzw. min. Offset im Regler des Knopfes fr hori/verti Regler
REG_MaxRadius	rs.w	1	;Maximaler Radius, in dem ein Klick akzeptiert wird min. Offset im Regler des Knopfes fr hori/verti Regler
REG_KnobRadiusA	rs.w	1	;Radius fr den Knopf in X-Richtung (nur ellipsenfrmige Regler)
REG_KnobRadiusB	rs.w	1	;Radius fr den Knopf in Y-Richtung (nur ellipsenfrmige Regler)
REG_PhiMin	rs.w	1	;Bezugswinkel fr Bezugswert 0 (max. 360, Angabe in Grad) (nur kreisfrmige Regler)
REG_PhiTotal	rs.w	1	;maximaler ffnungswinkel (max. 360, Angabe in Grad) (nur kreisfrmige Regler)
REG_Minvalue	rs.w	1	;minimaler Ausgabewert
REG_Maxvalue	rs.w	1	;maximaler Ausgabewert

REG_PhiStore	rs.l	1	;Winkel, der besteht beim Anklicken (FFP) (nur kreisfrmige Regler)

REG_Value	rs.w	1	;aktueller Wert des Reglers

REGTYPE_Circle	EQU	0
REGTYPE_Hori	EQU	1

;--------------------------------------------------------------------------------------
MFLG_Repeat	EQU	$2000<<16

;--------------------------------------------------------------------------------------

FFT_Gamma	=	6		;N = 2^Gamma
FFT_N		=	2^FFT_Gamma	;Anzahl zu transformierender Punkte
FFT_Sinbase 	=	8		;auf 256 bezogen (statt -1...1) wegen Integer-rechnung
DownSpeed	=	2
TimeOut		=	60
FFT_ShowLess	=	39	;Begrenzen der Berechnung des Power-Spektrums auf diese Lnge (0 fr default-Wert)
FFT_Analyzertabsize	=	16384

FFT_Width	=	148
FFT_Height	=	38
FFT_Displayentries	=	37
AnalyzerBackColour = $000D100C
;------------------------- Macrodefinitionen ------------------------------------------
EB	macro
	move.l	Exec_base(a5),a6
	endm
IB	macro
	move.l	Int_base(a5),a6
	endm
DB	macro
	move.l	Dos_base(a5),a6
	endm
UB	macro
	move.l	Util_base(a5),a6
	endm
GB	macro
	move.l	Gfx_base(a5),a6
	endm
CallSys	macro
	jsr	_LVO\1(a6)
	endm

MO_Object	macro
		dc.l	\1
		dc.w	\2,\3
		dc.l	\4
		dc.w	\5,\6,\7,\8
		dc.l	\9,\10,\11,\12,\13,\14,\15
		endm

IM_Object	macro
		dc.l	\1,\2
		dc.w	\3,\4,\5
		dc.l	\6,\7
		endm

REG_Object	macro
		dc.w	\1,\2,\3,\4,\5,\6,\7,\8,\9,\10,\11,\12
		dc.l	\13
		dc.w	\14
		endm

;--------------------------- Includes laden -------------------------------------------
	incdir	include:
	include	exec/exec_lib.i
	include	exec/execbase.i
	include	dos/dos_lib.i
	include	dos/dostags.i
	include	dos/dos.i

	include	exec/libraries.i
	include	exec/interrupts.i

	include	intuition/intuition.i
	include	intuition/intuition_LIB.i
	include	graphics/graphics_lib.i
	include	graphics/view.i

	include	misc/BuggsMacros.i
	include	misc/EagleplayerEngine.i

	include	libraries/gadtools.i
	include	libraries/locale_lib.i

	include "intuition/icclass.i"
	include "intuition/classes.i"
        include "intuition/classusr.i"
        include "intuition/imageclass.i"
	include	libraries/utility_lib.i

	include	libraries/mathffp_lib.i
	include	libraries/mathtrans_lib.i

	include	guigfx/guigfx_lib.i
	include	guigfx/guigfx.i
	include	render/render.i
	
;-------------------------------------------------------------------------------
MI_Precisionselect	equ	EPNr_FirstExternal+8


	section	0,code

	basereg	Datas,a5

	ifne	Eagleplayer
*-----------------------------------------------------------------------------*
*-----				Start Programm				------*
*-----------------------------------------------------------------------------*
EUS_Structure:	moveq	#-1,d0				;EUS_Jump
		rts
		EUSN_Identifier				;EUS_Identifier
		dc.l	0				;EUS_Next
		dc.w	0				;EUS_Usernr
myEPBase	dc.l	0				;EUS_EPBase
		dc.l	0				;EUS_FreeTable
		dc.l	0				;EUS_TaskAdr = NULL
		dc.l	0				;EUS_UnUsed1
		dc.l	0				;EUS_UnUsed2
		dc.l	0				;EUS_UnUsed3
		dc.l	TagListe			;EUS_Taglist
		dc.w	0				;EUS_Ticks
		dc.w	0				;EUS_TickCounter
		dc.l	EUIB_OnlyActive			;EUS_TickFlags
		dc.l	USMB_NewModule!USMB_NewSong	;EUS_MsgFlags
		dc.l	MyProzessName			;EUS_PName
		dc.l	MyCreatorname			;EUS_Creator
		dc.l	MySpecialInfo			;EUS_AboutUPRG
		dc.w	39				;EUS_Kickstart (V3.0)
		dc.l	13	;EAGLEVERSION		;EUS_EPVersion
		structver				;EUS_Version,EUS_Revision
		dc.l	MyMenuName			;EUS_Username
		dc.w	0				;EUS_WinX
		dc.w	14				;EUS_WinY
		dc.w	EUSB_Openwin			;EUS_Flags
Prefsflags:	dc.l	PFlag_AnalyzerPower!PFlag_AnalyzerSolid!PFlag_Analyzer	;EUS_Special, Prefs flags

		dc.w	0				;EUS_Special2
		dc.w	0				;EUS_Special2

		dc.l	0				;EUS_Special3
		structdate				;EUS_Creatordate
		dc.b	0				;EUS_Prioritt
		dc.b	EUTY_MainWindow			;EUS_Type
		dc.w	0				;EUS_Reserved2
		dc.l	0				;EUS_Reserved3
		dc.l	0				;EUS_Reserved4
		dc.l	0				;EUS_Reserved5
		dc.l	0				;EUS_Reserved6
		ifne	(*-EUS_Structure)-EUS_SizeOF
		Aber Hallo
		endc

		dc.b	"$VER: Eagleplayer-EMPYGui V"
		ver
		dc.b	` (`
		date
		dc.b	`)`,0
		even

	endc
;--------------------------- Strings -----------------------------------
	ifeq	Eagleplayer
	bra	Start
	endc
MyMenuName:	dc.b	"EMPYGui24",0
MyProzessName:dc.b	"EMPYGui24.1",0
MyCreatorname:dc.b	`code and animations by Henryk "Buggs" Richter, graphics based on an EMPY advertisement picture by Thomas Klingler`,0

MySpecialInfo:	dc.b	`EMPY GUI is one of the new user interfaces introduced in Eagleplayer 2.0. `
		dc.b	`It styled like in SONY HiFi components. There are many options `
		dc.b	`to change the look to your personal taste and needs. `
		dc.b	`The original EMPY where the design came from was a commercial `
		dc.b	`modplayer by Alexander Kneer.`,0
		dc.b	0
SubItem.MSG:	dc.b	"EmpyGUI24-Prefs",0
SubItem1.MSG	dc.b	"greedy colour allocation",0

int_name:	dc.b	`intuition.library`,0
dos_name:	dc.b	`dos.library`,0
gfx_name:	dc.b	`graphics.library`,0
util_name:	dc.b	`utility.library`,0
mathffp_s:	dc.b	`mathffp.library`,0
mathtrans_s:	dc.b	`mathtrans.library`,0
guigfx_s:	dc.b	`guigfx.library`,0

butclass:	dc.b	`buttongclass`,0
frbutclass:	dc.b	`frbuttonclass`,0
imgclass	dc.b	`imageclass`,0

Help_ActiveAmplifier:	dc.b "BifatGui_ActiveAmplifier",0
DLViewername:		dc.b "Dirlistviewer",0
Managername:		dc.b "Manager",0
AmpManagername:		dc.b "Amplifiermanager",0
Moduleinfoname:		dc.b "Moduleinfo",0
Formatloadername:	dc.b "Formatloader",0
Patternname:		dc.b `Pattern: `,0
Subsongname:		dc.b `Subsong: `,0
FXTask_Name:		dc.b `EmpyGui24 FX`,0

txt_nomathffp:		dc.b	`mathffp.library not found!`,0
txt_nomathtrans:	dc.b	`mathtrans.library not found!`,0
txt_noggfx:		dc.b	`guigfx.library V11 not found!`,0
txt_nomem:		dc.b	`Error converting graphics!`,10
			dc.b	`Please make sure to have enough memory free.`,0

my_easytitle:	dc.b	`EMPYGui24 Message`,0
my_easygadget:	dc.b	`  OK  `,0
	cnop	0,4
;----------------------------- Daten ------------------------------------
	ifeq	Eagleplayer	;fr Testroutinen liegen die Flags hier, sonst in EUS Struktur
aha		dc.b	`Dies ist ein sehr sehr langer Text ! 01234567890`,0
aha2		dc.b	`Sound-Drecker !`,0
	cnop	0,4
Prefsflags:	dc.l	PFlag_Commandbar!PFlag_AnalyzerPos!PFlag_AnalyzerPower!PFlag_AnalyzerSolid!PFlag_Analyzer	;EUS_Special, Prefs flags
	endc


		cnop	0,4

	ifne	Eagleplayer
*----------------------------------------------------------------------------*
TagListe:
	ifne	USEFPU
		dc.l	EUT_AttnFlags,AFF_68020!AFF_68881
	else
		dc.l	EUT_AttnFlags,AFF_68020
	endc
		dc.l	EUT_InitEngine,Inits
		dc.l	EUT_ExitEngine,CloseLibs	;Libs und eventl. Fenster schlieen
		dc.l	EUT_OpenAWindow,OpenAWindow
		dc.l	EUT_CloseAWindow,CloseAWindow
		dc.l	EUT_DeActivate,CloseAWindow
;*		dc.l	EUT_SetMenuStrip,SetMenuStrip
;*		dc.l	EUT_ClearMenuStrip,ClearMenuStrip
		dc.l	EUT_GetMsg,HandleWindowEvents

		dc.l	EUT_GetWaitMask,GetWaitMask

;		dc.l	EUT_EnableAll,EnableAll
;		dc.l	EUT_DisableAll,DisableAll

		dc.l	EUT_GetConfig,GetConfig
;		dc.l	EUT_Saveconfig,Saveconfig
;		dc.l	EUT_NewConfig,NewConfig

	ifeq	FXTask
		dc.l	EUT_Interrupt,myIntserver
	endc
		dc.l	EUT_NewModule,NewModuleEvent
		dc.l	EUT_KillModule,KillModuleEvent
		dc.l	EUT_NewSong,NewModuleEvent	;sicherheitshalber alles updaten
		dc.l	EUT_Startint,UpdateUPS
		dc.l	EUT_Stopint,UpdateUPS

;		dc.l	EUT_SignalReceived,SignalReceived
		dc.l	EUT_GetWindowHandle,GetWindowHandle
		dc.l	EUT_GetInterruptMask,GetInterruptMask

;		dc.l	EUT_NewScrollText,NewScrollText
;		dc.l	EUT_PrintText,PrintText
;		dc.l	EUT_ClearTextWindow,ClearTextWindow

		dc.l	EUT_GetAbortMsg,GetAbortMsg
		dc.l	EUT_ChangeGui,ChangeGui		;nur Zustnde
		dc.l	EUT_ChangePrefs,ChangePrefs	;Zustnde,Slider
							;mit Refresh
;		dc.l	EUT_GetPrefs,GetPrefs

		dc.l	EUT_GetGuiMenuStrip,GetMenuStrip
;		*dc.l	EUT_FreeGuiMenuStrip,FreeMenuStrip

		dc.l	EUT_InitDisplay,InitCrunchDisplay	;diese 3
		dc.l	EUT_FillDisplay,CrunchDisplay		;fhren direkt
		dc.l	EUT_RemoveDisplay,EndCrunchDisplay	;auf Bearbeitungsroutine...

;		dc.l	EUT_SpecialinfoLNr,LNrE_SpecialInfo_BifatGui

		dc.l	0
	else

Start:
	lea	Datas,a5
	bsr	Inits				;Libs ffnen, Data Area lschen usw.
	bmi	error$

;	move.l	#$3c8efa35,d0
;	move.l	mathtrans(a5),a6
;	jsr	_LVOSPFieee(a6)

;	move.l	mathffp(a5),a6
;	jsr	_LVOSPFix(a6)

	bsr	OpenWin				;Fenster ffnen, Images umrechnen usw.
	bmi	error$

	ifeq	Eagleplayer			;Test fr Printtext
	lea	aha,a0
	move.l	#ID_Textname1,d0
	bsr	PrintText
	endc

	move.l	#ID_Play,d0
	bsr	Findgadget
	tst.l	d0
	beq	no$

		move.l	d0,a0

;		move.w	GG_Flags(a0),d0
;		and.l	#GFLG_ImageDisable,d0

		lea	MyTags(a5),a3
		move.l	#GA_Disabled,(a3)
		move.l	#0,4(A3)
		clr.l	8(A3)
		suba.l	a2,a2
		move.l	WinHandle(A5),a1
		IB
		jsr	_LVOSetGadgetAttrsa(A6)
no$

	bsr	HandleActions

	bsr	CloseWin

	bsr	CloseLibs

	moveq	#0,d0				;Programm ordnungsgem beendet
	rts
error$
	bsr	CloseWin

	bsr	CloseLibs

	moveq	#-1,d0				;Programm wegen Fehler abgebrochen
	rts

	endc

******************************************************************************
*                       Ausgabe von Error-Messages                           *
*                 Input: a0 -> Zeiger auf Ausgabestring                      *
******************************************************************************
MERROR:
	Push	All

	lea	datas,a5
	lea	my_easystruct(a5),a1

	move.l	a0,es_textformat(a1)

	lea	my_easygadget(pc),a0
	move.l	a0,es_gadgetformat(a1)

	lea	my_easytitle(pc),a0
	move.l	a0,es_Title(a1)
	move.l	winhandle(a5),a0	;*Window
	suba.l	a2,a2			;*IDCMP_ptr
	suba.l	a3,a3			;*Arguments
	IB
	CallSys	EasyRequestArgs

	Pop	All
	rts

	ifne	Eagleplayer
*-----------------------------------------------------------------------------*
* Testet, ob ESC gedrckt wurde.
* Alle anderen Messages werden erstmal ignoriert.
GetAbortMsg:	lea	Datas,a5
		moveq	#0,d0
		moveq	#0,d1
		rts

		*--- Msg holen ---*
		EB
;		move.l	Port(a5),d0
		beq.w	.NoOne
		move.l	d0,a0
		jsr	_LVOGetMsg(a6)
		tst.l	d0
		beq	.NoOne

		*--------- Daten aus Message holen --------*
		move.l	d0,a1
		move.l	im_Class(a1),d7
		move.w	im_Code(a1),d5 		;<-
		move.l	im_IAddress(a1),d6 	;<-
		move.w	im_Qualifier(a1),d4
		EB
		jsr	_LVOReplyMsg(a6)

		cmp.l	#RAWKEY,d7			*VANILLAKEY
		bne	.NoOne
		cmp.w	#$63,d5
		bne.s	.NoOne
		moveq	#EPNr_Abort,d1
		bra.s	.Ok

.NoOne:		moveq	#0,d1
.Ok:		moveq	#0,d0
		rts
*-----------------------------------------------------------------------------*
* Input: d0.w=Type des windows
*	 a0  =WindowName
*	 a1  =ScreenName
* Output:d0 = Error oder NULL
*-----------------------------------------------------------------------------*
OpenAWindow:	lea	Datas,a5
		cmp.w	#EPST_MainWindow,d0
		bne.s	NoMainWindow
;		move.l	a0,Eaglename(a5)	;Window Name interessiert nicht
		move.l	a1,myScreentitle(a5)

		lea	EUS_Structure(pc),a4

		tst.l	WinHandle(a5)
		bne.s	Ok$

		bsr.w	AllocSignal
		cmp.l	#-1,d0
		beq	NoSignal$

		bsr.w	OpenWin
		tst.l	WinHandle(a5)
		beq.s	FreeSignal$
Ok$:		moveq	#0,d0
		rts

FreeSignal$:	bsr.w	FreeSignal
NoSignal$:	moveq	#EPR_CantOpenWin,d0
		rts

NoMainWindow:	moveq	#EPR_ErrorInArguments,d0
		rts

NoMem:		moveq	#EPR_NotEnoughMem,d0
		rts

*-----------------------------------------------------------------------------*
GetWindowHandle:
		move.l WinHandle,d0
		rts

*-----------------------------------------------------------------------------*
GetMenuStrip:
		lea	GuiMenu,a0
		moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
AllocSignal:
		move.l	ScrollSignal(a5),d0
		bge.s	SignalDa$
		moveq	#-1,d0
		EB
		CallSys	AllocSignal		;2. Signal allokieren (fr Interrupt)
		move.l	d0,ScrollSignal(a5)
SignalDa$:	tst.l	d0
		rts

*-----------------------------------------------------------------------------*
FreeSignal:	move.l	ScrollSignal(a5),d0
		cmp.l	#-1,d0
		beq.s	NoSignal$
		EB
		CallSys	FreeSignal
NoSignal$:
		move.l	#-1,ScrollSignal(a5)
		rts
		
*-----------------------------------------------------------------------------*
* Input: d0 = Type des Windows
* Output: --
*-----------------------------------------------------------------------------*
CloseAWindow:	lea	Datas,a5
		cmp.w	#EPST_MainWindow,d0
		bne.s	NoMainWindow

		tst.l	WinHandle(a5)
		beq.s	NoWindow$
;		bsr.w	GetConfig
		bsr.w	CloseWin
		bsr.w	FreeSignal
		clr.l	LastMenu(A5)		;Men nicht mehr valid !
NoWindow$:	moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
* Input:  --
* Output: d0 = SignalMask (ohne InterruptMask)
*-----------------------------------------------------------------------------*
GetWaitMask:	moveq	#0,d0
		lea	Datas,a5

		move.l	WinHandle(a5),d1
		beq.s	NoPort$
		move.l	d1,a0
		move.l	wd_UserPort(a0),d1
		beq	NoPort$
		move.l	d1,a0
		move.b	MP_SIGBIT(a0),d1
		bset	d1,d0
NoPort$:	rts

*-----------------------------------------------------------------------------*
* Input: --
* Output:d0 = Signalmask (ohne WaitMask)
*-----------------------------------------------------------------------------*
GetInterruptMask:
		moveq	#0,d0
		lea	Datas,a5
		move.l	ScrollSignal(a5),d3	;fr Interrupt
		bset	d3,d0
		rts

*-----------------------------------------------------------------------------*
* Input:	d0 = SignaleSet
* Output:	d0 = ActionNr oder Null
*-----------------------------------------------------------------------------*
SignalReceived:	lea	Datas,a5
		move.l	ScrollSignal(a5),d3	;fr Interrupt
		btst	d3,d0
		beq.w	.Return

		bsr	myIntserver
.Return:	rts				;GetMsg wird trotzdem

*-----------------------------------------------------------------------------*

	endc

 ifeq	Eagleplayer

;*************************************************************************************
;*       Mainloop, Abfrage der Intuition-Messages, Verteiler fr Events aller Art    *
;*************************************************************************************

;------------------------------ Testroutine ------------------------------------------
;Input:  -
;Output: -
HandleActions:
	Push	All
MainLoop$
	bsr	HandleWindowEvents
	cmp	#EPNr_Quit,d0
	beq	End$
	tst	d0
	bne	MainLoop$

	move.l	WinHandle(A5),d0
	beq	nowin$
	move.l	d0,a0
	move.l	wd_UserPort(a0),d0
	move.l	d0,a0
	moveq	#0,d0
	move.b	MP_SIGBIT(a0),d1
	bset	d1,d0

	ifne	Inttest
	moveq	#1,d1
	DB
	CallSys	Delay
	bsr	myIntserver
	else
	EB
	CallSys	Wait
	endc
nowin$
	bra	MainLoop$
End$
	Pop	All
	rts

 endc
****************************************************************************************
*                           VBI-Messageverteiler                                       *
****************************************************************************************
;Input:  -
;Output: -
myIntserver:
		Push	All
		lea	Datas,a5

		addq.w	#1,Ticks(a5)

		lea	Interrupttable(pc),a0
next$
		move.l	(a0)+,d0
		beq	end$
		move.l	(a0)+,d1
		beq	doit$

		moveq	#0,d2
		move	Ticks(A5),d2
		divu	d1,d2
		and.l	#$ffff0000,d2
		bne	next$			;ok, mehr Ticks abwarten
doit$
		bsr	FindObject		;Gadget Objekt in Liste finden
		beq	next$

		Push	a0

		move.l	d0,a0
		move.l	MOL_React(a0),d0	;Einsprung holen
		beq	skip$
		move.l	d0,a1
		jsr	(a1)
skip$
		Pop	a0
		bra	next$
end$
		Pop	All
		moveq	#1,d0
		rts
;***************************************************************************************
;* bei "NewModule" Message alle Infos update, z.B. Modulname, Soundsystemname,         *
;* Tracknummer, Pattern, Subsongs usw.                                                 *
;***************************************************************************************
NewModuleEvent:
		Push	All
		bsr	DisableFXTask

		lea	Datas,a5

		lea	NewModuletable,a0
next$
		move.l	(a0)+,d0
		beq	end$
		bsr	FindObject		;Objekt in Liste finden
		beq	next$

		Push	a0

		move.l	d0,a0
		move.l	MOL_React(a0),d0	;Einsprung holen fr Abarbeitungsroutine
		beq	skip$
		move.l	d0,a1

		moveq	#0,d0
		jsr	(a1)
skip$
		Pop	a0
		bra	next$
end$
		bsr	EnableFXTask
		Pop	All
		rts
KillModuleEvent:
		Push	All
		bsr	DisableFXTask

		lea	Datas,a5
		clr.l	FFT_StructAdr(a5)	;

		lea	NewModuletable,a0
next$
		move.l	(a0)+,d0
		beq	end$
		bsr	FindObject		;Objekt in Liste finden
		beq	next$

		Push	a0

		move.l	d0,a0
		move.l	MOL_React(a0),d0	;Einsprung holen fr Abarbeitungsroutine
		beq	skip$
		move.l	d0,a1

		moveq	#1,d0
		jsr	(a1)
skip$
		Pop	a0
		bra	next$
end$
		bsr	EnableFXTask
		Pop	All
		rts

;***************************************************************************************
;*          bei "ChangePrefs" Message alle Infos update, z.B. Songend, Fadein/out      *
;***************************************************************************************
;Input:  D0 - EPNr oder 0, wird vom Eagleplayer durchgereicht
;        D1 - Flags zu der EPNr
;        D2 - Argumente1 zu der EPNr
;        D3 - Argumente2 zu der EPNr
;Output: -
ChangePrefs:
		Push	All
		lea	Datas,a5

		lea	NewPrefstable,a0
next$
		movem.l	(a0)+,d4/d5
		tst.l	d4
		beq.s	end$
		cmp.l	d0,d4
		bne.s	next$

		Push	All
		move.l	d5,a0
		jsr	(a0)
		Pop	All
		bra	next$
end$
		Pop	All
		rts
;****************************************************************************************
;*          bei "ChangeGui" Message alle Gadgets update, z.B. NextMod/NextSong/NextPatt *
;****************************************************************************************
;Input:  D0 - EPNr oder 0, wird vom Eagleplayer durchgereicht
;        D1 - Flags zu der EPNr
;        D2 - Argumente1 zu der EPNr
;        D3 - Argumente2 zu der EPNr
;Output: -
ChangeGui:
		Push	All
		lea	Datas,a5
		and.l	#1,d1			;nur 0/1 erlaubt

		lea	NewGuitable-3*4,a0
next$
		lea	3*4(a0),a0
		movem.l	(a0),d4/d5/d6
		tst.l	d4
		beq.s	end$
		cmp.w	d0,d4
		bne.s	next$

		move.l	d1,2*4(a0)

		Push	All
		move.l	d5,d0
		bsr	Findgadget
		move.l	d0,d7
		beq	no2$

		move.l	d0,a0
		lea	MyTags(a5),a3
		move.l	#GA_Disabled,(a3)
		move.l	d1,4(A3)
		clr.l	8(A3)
		suba.l	a2,a2
		move.l	WinHandle(A5),a1
		IB
		CallSys	SetGadgetAttrsA
		
		move.l	d7,a0
		move.l	WinHandle(A5),a1
		suba.l	a2,a2
		moveq	#1,d0
		IB
		CallSys	RefreshGList
no2$
		Pop	All
		bra	next$
end$
		Pop	All
		rts
;****************************************************************************************
;*          letzte "ChangeGui" Message auf nderungen des UI anwenden                   *
;****************************************************************************************
;Input:  -
;Output: -
SimChangeGui:
		Push	All
		lea	Datas,a5

		lea	NewGuitable-3*4,a0
next$
		lea	3*4(a0),a0
		movem.l	(a0),d4/d5/d6
		tst.l	d4
		beq.s	end$

		move.l	d6,d1

		Push	All
		move.l	d5,d0
		bsr	Findgadget
		move.l	d0,d7
		beq	no2$

		move.l	d0,a0
		lea	MyTags(a5),a3
		move.l	#GA_Disabled,(a3)
		move.l	d1,4(A3)
		clr.l	8(A3)
		suba.l	a2,a2
		move.l	WinHandle(A5),a1
		IB
		CallSys	SetGadgetAttrsA
		
		move.l	d7,a0
		move.l	WinHandle(A5),a1
		suba.l	a2,a2
		moveq	#1,d0
		IB
		CallSys	RefreshGList
no2$
		Pop	All
		bra	next$
end$
		Pop	All
		rts
;***************************************************************************************
;* "ChangePrefs" Message simulieren zum Update der Einstellungen bei ffnen des        *
;* Fensters und Statusnderungen                                                       *
;***************************************************************************************
;Input:  -
;Output: -
UpdatePrefs:
		Push	All

		lea	NewPrefstable,a0
next$
		movem.l	(a0)+,d4/d5
		tst.l	d4
		beq.s	end$

		Push	a0
		move.l	d5,a0
		jsr	(a0)
		Pop	a0
		bra	next$
end$
		Pop	All
		rts
;--------------------------------------------------------------------------------------
;-                    Abfragen an das Fenster beantworten                             -
;--------------------------------------------------------------------------------------
;Input:  -
;Output: D0 - EPNr oder 0, wird an Eagleplayer durchgereicht
;        D1 - Flags zu der EPNr
;        D2 - Argumente1 zu der EPNr
;        D3 - Argumente2 zu der EPNr
HandleWindowEvents:
		bsr	CloseTray		;Schublade schlieen

		Push	d4-a6
GetMsg:
		lea	Datas,a5
		suba.l	a1,a1
		move.l	NextSelect(a5),d0	;Multiselect bei PDMenus
		bne.s	NextSelect$

		move.l	WinHandle(A5),d0
		beq	nowin$
		move.l	d0,a0
		move.l	wd_UserPort(a0),d0
		move.l	d0,a0
		EB
		CallSys	GetMsg			;wird von der Handlingroutine replied
		tst.l	d0
		beq	nowin$
		move.l	d0,a1			*IntuiMessage

	*----------- Auswertung der Window-Message -----------*

	*----- Teste EP-Messages --------*
	* Die Message wird nicht replyed *
	* Closewindow,Vanillakey,Menupick*
	* werden abgefragt.		 *
	*--------------------------------*
	* Input: a0=Nextselect or NULL
	* 	 a1=Message oder NULL
	* Output:d0=EPNr oder NULL
	*	 d1=NextSelect
	*	 a1=Message oder NULL
	*	 d2/a2=Arg1
	*	 d3/a3=Arg2
	*-------------------------------*
	moveq	#0,d0
NextSelect$:
	move.l	d0,a0

	ifne	Eagleplayer
		move.l	myEPBase(pc),a4
		jsr	ENPP_GetEPNrfromMessage(a4)	* In: a1=Message
	else
		moveq	#0,d0
		moveq	#0,d1
	endc
		move.l	d1,NextSelect(a5)
	
		move.l	a1,d4
		beq	nomsg$

		lea	tmpIMsg(a5),a0		;Intuimsg kopieren
		lea	(a1),a2
		move.w	#im_SIZEOF-1,d4
copy$		move.b	(a2)+,(a0)+
		dbf	d4,copy$

		move.l	im_Class(a1),d7		;IDCMP-Class Tabelle 1 (vor Reply der MSG abgearbeitet wichtig bei z.B. IDCMP_Newsize)
		lea	IDCMPtable1(pc),a3
classloop1$
		movem.l	(a3)+,d4/a0
		tst.l	d4
		beq.s	notfound1$
		cmp	d7,d4
		bne	classloop1$
		moveq	#0,d0			;solche Msgs wie Menupick usw. werden ignoriert, ansonsten neue Kommandos
		Push	d4-a6			;<-
		jsr	(A0)			;Einsprung in Routine
		Pop	d4-a6			;<-
notfound1$
		Push	All
		EB
		CallSys	ReplyMsg		;Message Reply
		Pop	All

		tst.l	d0
		beq.w	msg$

		cmp.w	#EPNr_FirstExternal,d0	;externe Kommandos, also Kommandos, die nur
		blo.w	rts$			;das GUI und nicht den EP betreffen, aus-
		cmp.w	#EPNr_LastExternal,d0	;maskieren und gesondert behandeln
		bhi.w	rts$			;

;
		bsr	MenueAuswertung		;falls Custom-GUIPrefs Men
		bra	GetMsg
msg$
		lea	tmpIMsg(a5),a1
		move.l	im_Class(a1),d7		;IDCMP-Class Tabelle 2
		lea	IDCMPtable2(pc),a3
classloop3$
;		cmp.l	#IDCMP_GADGETDOWN,d7
;		beq	skip$
;		nop
;skip$
		movem.l	(a3)+,d4/a0
		tst.l	d4
		beq.s	notfound3$
		cmp	d7,d4
		bne	classloop3$
		moveq	#0,d0			;solche Msgs wie Menupick usw. werden ignoriert, ansonsten neue Kommandos zurckgegeben
		Push	d4-a6			;
		jsr	(A0)			;Einsprung in Routine
		Pop	d4-a6			;
notfound3$

		cmp.w	#EPNr_FirstExternal,d0	;interne Manahmen erfolgt ?
		blo.w	weiter$			;
		cmp.w	#EPNr_LastExternal,d0	;
		bls.w	GetMsg			;ja -> nochmal Message zu holen versuchen, sonst
						;ruft der EP bei Rckwert von `0` oder 
						;"Out of Range" die Routine erst
						;wieder bei einer neu eintreffenden MSG auf
weiter$
		
nomsg$
nowin$
rts$
		Pop	d4-a6
		move.l	d2,a2			;fix fr EP Bug
		rts
;*************************************************************************************
;*                               Gadget-Aktionen                                     *
;*************************************************************************************
;Input:  a1 - Kopie der IntuiMsg
;Output: D0 - EPNr oder 0
;        D1 - Flags zu der EPNr
;        D2 - Argumente1 zu der EPNr
;        D3 - Argumente2 zu der EPNr
HandleWinClose:
	move.l	#EPNr_Quit,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	rts

;*************************************************************************************
;*       fr Spezialflle, Direktabfrage, ob Mausklick innerhalb z.B. der Regler     *
;*************************************************************************************
;Input:  a1 - Kopie der IntuiMsg
;Output: D0 - EPNr oder 0
;        D1 - Flags zu der EPNr
;        D2 - Argumente1 zu der EPNr
;        D3 - Argumente2 zu der EPNr
HandleGadgets3:
	moveq	#0,d0
	
	move.l	im_IAddress(a1),d4	;leider hat Intuition da einen Bug, hier steht die Windowadresse drin :-(
	beq	Error$
	move.l	d4,a0			;also aktives Gadget selbst suchen...
	move.l	wd_FirstGadget(a0),d4
loop$
	beq	Error$
	move.l	d4,a0
	btst    #6,gg_Activation(a0)	; GACT_ACTIVEGADGET
	bne	this$
	move.l	gg_NextGadget(a0),d4
	bra	loop$
this$
	move.w	gg_GadgetID(a0),d0
	bsr	FindObject		;Gadget Objekt in Liste finden
	beq	Error$
	move.l	d0,a0

	bsr	InitRegler

	move.l	d0,a0
	move.l	MOL_React(a0),d0	;Custom Routine zur Reaktion auf Kommando ?
	beq	noRoutine$
	move.l	d0,a2
	jsr	(a2)			;Inputs: a0 = Objekt, a1=Kopie der Intuimsg
	bra	End$
noRoutine$
					;Standard-Befehlsabarbeitung
	move.l	MOL_Command(a0),d0
	moveq	#0,d1
	move.l	MOL_CMDArg1(a0),d2
	move.l	MOL_CMDArg2(a0),d3
End$
Error$
	rts
;*************************************************************************************
;*                               Gadget-Aktionen                                     *
;*************************************************************************************
;Input:  a1 - Kopie der IntuiMsg
;Output: D0 - EPNr oder 0
;        D1 - Flags zu der EPNr
;        D2 - Argumente1 zu der EPNr
;        D3 - Argumente2 zu der EPNr
HandleGadgets:
	moveq	#0,d0
	
	move.l	im_IAddress(a1),d4
	beq	Error$
	move.l	d4,a0
	move.w	gg_GadgetID(a0),d0
	bsr	FindObject		;Gadget Objekt in Liste finden
	beq	Error$
	move.l	d0,a0

	cmp.w	#GLA_Moused,MOL_Type(a0)	;Regler ?
	bne.s	noregler$
	move.l	MOL_UserData(a0),d0
	beq	noregler$			;wie jetzt ?
	move.l	d0,a2
	clr.w	REG_Enable(a2)			;schon initialisiert ?
noregler$

	move.l	MOL_React(a0),d0	;Custom Routine zur Reaktion auf Kommando ?
	beq	noRoutine$
	move.l	d0,a2
	jsr	(a2)			;Inputs: a0 = Objekt, a1=Kopie der Intuimsg
	bra	End$
noRoutine$
					;Standard-Befehlsabarbeitung
	move.l	MOL_Command(a0),d0
	moveq	#0,d1
	move.l	MOL_CMDArg1(a0),d2
	move.l	MOL_CMDArg2(a0),d3
End$
Error$
	rts
***************************************************************************************
*                         Regler Struktur beim ersten Klick update                    *
***************************************************************************************
;Inputs: A0 - Objekt
;        A1 - Kopie der Intuimsg
InitRegler:
	push	all
	cmp.w	#GLA_Moused,MOL_Type(a0)	;Regler ?
	bne.s	noregler$
	move.l	MOL_UserData(a0),d0
	beq	noregler$			;wie jetzt ?
	move.l	d0,a2
	tst.w	REG_Enable(a2)			;schon initialisiert ?
	bne	noenable$

	clr.w	REG_Enable(a2)

	cmp.w	#REGTYPE_Circle,REG_Type(a2)
	bne.s	nocircle$

	move	im_MouseX(a1),d0		;aktuelle Koordinaten der Maus holen
	sub	REG_XCenter(a2),d0		;zentrieren
	ext.l	d0				;wg. 060
	move	im_MouseY(a1),d1
	sub	REG_YCenter(a2),d1		;zentrieren
	ext.l	d1				;wg. 060
	bsr	ToPolar				;Radius, Winkel bestimmen

	move.l	d1,REG_PhiStore(a2)		;Winkel sichern

	cmp	REG_MinRadius(a2),d0
	blt.s	noenable$
	cmp	REG_MaxRadius(a2),d0
	bgt.s	noenable$
	
	move	#1,REG_Enable(a2)

	bra	noenable$
nocircle$
	move	im_MouseX(a1),REG_XCenter(a2)	;initiale X-Position merken
	move	REG_Value(a2),REG_PhiStore(a2)	;initialen Wert merken

	move	#1,REG_Enable(a2)
noenable$

noregler$
	pop	all
	rts
;------------------------ Aufruf bei "IDCMPUpdate" fr GACT_IMMEDIATE -----------------------
;Input:  a1 - Kopie der IntuiMsg
;Output: D0 - EPNr oder 0
;        D1 - Flags zu der EPNr
;        D2 - Argumente1 zu der EPNr
;        D3 - Argumente2 zu der EPNr
HandleGadgets2:
	move	PattTime(a5),d4		;Delay Schleife
	addq	#1,d4
	cmp	#2,d4
	blt.s	no3$
	moveq	#0,d4
no3$	move	d4,PattTime(A5)
	bne	rts$

	UB
	move.l	#GA_ID,d0
	move.l	im_Iaddress(a1),a0	; taglist to a0
	move.l	a1,d7
	jsr	_LVOFindTagItem(A6)	; look for the tag
	move.l	d7,a1
	tst.l	d0
	beq	Error$
	move.l	d0,a0
	move.l	4(a0),d0		; Gadget ID holen aus Tagliste

	bsr	FindObject		; Gadget Objekt in Liste finden
	beq	Error$
	move.l	d0,a0
	move.l	MOL_React(a0),d0	;Custom Routine zur Reaktion auf Kommando ?
	beq	noRoutine$
	move.l	d0,a2
	jsr	(a2)			;Inputs: a0 = Objekt, a1=Kopie der Intuimsg

	move	d4,PattTime(A5)
	bra	End$
noRoutine$
					;Standard-Befehlsabarbeitung
	move.l	MOL_Command(a0),d0
	moveq	#0,d1
	move.l	MOL_CMDArg1(a0),d2
	move.l	MOL_CMDArg2(a0),d3
End$
Error$
	rts
rts$
	move.l	#EPNr_FirstExternal,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	rts
;*******************************************************************************************
;*                         Routinen zur Behandlung der Regler                              *
;*******************************************************************************************
;Input:  a0 - Objekt
;        a1 - Kopie der IntuiMsg
;Output: -
HandleMoused:
	push	all

	move.l	MOL_UserData(a0),d0
	beq.w	noregler$
	move.l	d0,a2				;REG_Struktur

	cmp	#REGTYPE_Circle,REG_Type(a2)
	bne.w	nocircle$

	; delta phi berechnen aus neuem Winkel minus altem Winkel
	
	move	im_MouseX(a1),d0		;aktuelle Koordinaten der Maus holen
	sub	REG_XCenter(a2),d0		;zentrieren
	ext.l	d0				;wg. 060

	move	im_MouseY(a1),d1
	sub	REG_YCenter(a2),d1		;zentrieren
	ext.l	d1				;wg. 060
	bsr	ToPolar				;Radius(= d0), Winkel(= d1) bestimmen
	move.l	d1,d5

	move.l	REG_PhiStore(a2),d6		;alten Winkel holen

	move.l	mathffp(a5),a6
	move.l	d1,d0
	move.l	d6,d1
	jsr	_LVOSPSub(a6)			;d0 = (d0-d1)
	move.l	d0,d7				;delta phi

	move.l	d7,d1
	jsr	_LVOSPTst(A6)
	tst.l	d0
	beq	noregler$			;delta phi = 0 -> raus, keine nderung

	; Test auf berschreitung der Grenze zwischen 0 und 359
	; ggfalls Umrechnung des Drehwinkels

	move.l	d7,d1
	move.l	#$96CBE443,d0			;4.71238898 in FFP
	move.l	mathffp(a5),a6
	jsr	_LVOSPCmp(a6)
	tst.l	d0
	bmi	nobig$				;delta phi > 270 (3/2) ?

	move.l	#$C90FDB43,d1			;
	move.l	d7,d0
	move.l	mathffp(a5),a6
	jsr	_LVOSPSub(a6)			;delta phi = delta phi - 360 (2)
	move.l	d0,d7
nobig$
	move.l	d7,d1
	move.l	#$96CBE4C3,d0			;-4.71238898 in FFP
	move.l	mathffp(a5),a6
	jsr	_LVOSPCmp(a6)
	tst.l	d0
	bpl	nosmall$			;delta phi < -270 (-3/2) ?

	move.l	#$C90FDB43,d1			;
	move.l	d7,d0
	move.l	mathffp(a5),a6
	jsr	_LVOSPAdd(a6)			;delta phi = delta phi + 360 (2)
	move.l	d0,d7
nosmall$

	; Winkel umrechnen auf nderung des eingetragenen Wertes
;	move.l	d7,d0
;	move.l	mathtrans(a5),a6
;	jsr	_LVOSPTieee(A6)
;	move.l	d0,aha1
;	fmove.s	aha1,fp0

	move.w	REG_Maxvalue(a2),d0
	sub.w	REG_Minvalue(a2),d0		;Anzahl der Stufen aus Max-Min
	ext.l	d0
	move.l	mathffp(a5),a6		
	jsr	_LVOSPFlt(A6)			;in FFP

	move.l	d7,d1
	jsr	_LVOSPMul(A6)			;delta phi * NumValues
	move.l	d0,d7

	move.w	REG_PhiTotal(a2),d0
	beq.w	noregler$			;nur als Schussligkeitsschutz :-)
	ext.l	d0
	move.l	mathffp(a5),a6		
	jsr	_LVOSPFlt(A6)			;in FFP

	move.l	#$8efa353b,d1			;*/180, Umrechnung in Bogenma
	move.l	mathffp(a5),a6		
	jsr	_LVOSPMul(a6)
	move.l	d0,d1

	move.l	d7,d0
	jsr	_LVOSPDiv(a6)			;delta phi * NumValues / ffnungswinkel
	jsr	_LVOSPFix(a6)			;= Wertnderung
	tst.l	d0
	beq	no$
	move.l	d5,REG_PhiStore(a2)		;neuen Winkel sichern fr nchsten Durchlauf
no$
	add.w	REG_Value(a2),d0		;+ alter Wert = neuer Wert

minmax$
	cmp.w	REG_Minvalue(a2),d0		;min/max austesten und begrenzen
	bge.s	minok$
	move	REG_Minvalue(a2),d0
minok$

	cmp.w	REG_Maxvalue(a2),d0
	ble.s	maxok$
	move	REG_Maxvalue(a2),d0
maxok$
	move	d0,REG_Value(a2)
	bra.s	noregler$
nocircle$
	move	im_MouseX(a1),d0		;neuer X-Wert
	move	d0,d1
	sub	REG_XCenter(a2),d0		;minus alter X-Wert = delta x

	move	REG_Maxvalue(a2),d1
	sub	REG_Minvalue(a2),d1		;max. Anzahl Schritte

	muls	d1,d0

	move	REG_Maxradius(a2),d1
	sub	REG_Minradius(a2),d1		;max. Breite des Reglerbereiches

	divs	d1,d0				;delta Value
	
	add.w	REG_PhiStore(a2),d0		;+ alter Wert = neuer Wert

	cmp.w	REG_Minvalue(a2),d0		;min/max austesten und begrenzen
	bge.s	minok2$

	move	im_MouseX(a1),REG_XCenter(a2)
	move	REG_Minvalue(a2),d0
	move	d0,REG_PhiStore(a2)
minok2$

	cmp.w	REG_Maxvalue(a2),d0
	ble.s	maxok2$
	move	im_MouseX(a1),REG_XCenter(a2)
	move	REG_Maxvalue(a2),d0
	move	d0,REG_PhiStore(a2)
maxok2$
	move	d0,REG_Value(a2)
noregler$

	pop	all
	rts
;*******************************************************************************************
;* nderung in das Layout betreffenden Flags, diese ndern und ntigenfalls Refresh-Aktion *
;* Register brauchen nicht gesichert werden                                                *
;*******************************************************************************************
;Input:  (a1 - Kopie der IntuiMsg) - nicht verwendet
;        a0 - Objekt oder d0 - Flags, ob Refresh oder nicht
;Output: -
HandleToggles:
	move.l	a0,d1
	beq	nogad$

	move.l	MOL_CMDArg1(a0),d0		;zu alternierende Flags

	move.l	Prefsflags(pc),d1
	eor.l	d0,d1
	move.l	d1,Prefsflags

	move.l	MOL_CMDArg2(a0),d0
nogad$
	btst	#TOGGB_Winrefresh,d0
	beq.w	nowinrefresh$

	and.l	#TOGGF_ChangeImages,d0

	bsr	DisableFXTask
;	bsr	CloseWin
;------------------ komplette Closewin: Routine ---------------------------
	bsr	RemoveGads		;Gadgets entfernen

	bsr	FreeGadgets		;und freigeben

;	bsr	ClosemyWindow		;dann Fenster dichtmachen

	tst.l	d0
	beq	none$
	bsr	FreeImages		;dann Images freigeben (nicht ntig, dadurch schnellerer Refresh)
;
	bsr	FreePenShareMap		;GGFX Pensharemap freigeben 
none$


;	bsr	UnlockPubScreen		;Screen freigeben

	clr.l	mywindowlist(a5)
;-------------------------------------------------------------------------
 ;	bsr	OpenWin


		lea	Windowlist,a0
nextlist$
		move.l	(a0)+,d0
		beq	takefirst$
		move.l	(a0)+,d1		;Flags holen
		beq	thisWindowList$		;keine Flags -> also immer brauchbar
		move.l	d1,d2			;sichern

		and.l	Prefsflags(pc),d2	;mit Prefsflags ausmaskieren
		cmp.l	d1,d2			;alle Prefsflags richtig ?
		beq.l	thisWindowList$		;ja, nehmen

		bra	nextlist$
takefirst$				;nix gefunden, erstbeste Liste

		lea	Windowlist,a0		;
		move.l	(a0)+,d0		;
		beq	Error$			;
thisWindowList$
		move.l	d0,mywindowlist(A5)

;		bsr	LockPubScreen		;Pubscreen holen
;		bne	Error$

;		tst.l	mycmap(a5)
;		bne.s	okcol$
;
;		lea	GlobalColoursNorm(pc),a0
;		move.l	Prefsflags(pc),d1
;		and.l	#PFlag_PaletteMode,d1
;		beq.s	norm$
;		lea	GlobalColoursGrey(pc),a0
;norm$
		bsr	MakePenShareMap		;Drawhandle etc.
		bne	Error$

		move.l	mywindowlist(a5),a0
		bsr	CreateImages		;alle verwendeten Images umrechnen
		bne	Error$

;		move.l	mywindowlist(a5),a0
;		bsr	OpenWindow		;Fenster ffnen
;		bne	Error$

		move.l	mywindowlist(a5),a0
		move	WIL_Width(a0),d2	
		move	WIL_Height(a0),d3

		move.l	WinHandle(A5),a0
		move.w	wd_LeftEdge(A0),d0
		move.w	wd_TopEdge(A0),d1

		cmp	wd_Width(a0),d2
		bne	change$
		cmp	wd_Height(a0),d3
		beq	direct$
change$
		IB
		CallSys	ChangeWindowBox

		move.l	mywindowlist(a5),a0
		bsr	CreateGadgets		;Gadgets erzeugen
		bne	Error$

		bsr	InitPrinttextRastport	;fr Printtext Rastport vorbereiten
		bsr	InitRemoteVolRastport

		bsr	InitAnalyzerBuffer	;fr Analyzer Hintergrund lschen
		bne	Error$

		bsr	EnableFXTask
Nowinrefresh$
		move.l	#myNR_ToggleFlag,d0
Error$
	rts
direct$
		move.l	mywindowlist(a5),a0
		bsr	CreateGadgets		;Gadgets erzeugen
		bne	Error$

		bsr	InitPrinttextRastport	;fr Printtext Rastport vorbereiten
		bsr	InitRemoteVolRastport

		bsr	HandleWinRefresh

		bsr	EnableFXTask
		bra	nowinrefresh$
;********************************************************************************
;* Images neu berechnen, Gadgets erstellen und eintragen bei Vernderung der    *
;* Windowlist, notwendig da ChangeWindowBox() nicht Realtime arbeitet           *
;********************************************************************************
HandleChangewin:
		move.l	WinHandle(a5),d0
		beq	end$
		move.l	d0,a0
	ifne	Eagleplayer
		move.w	wd_LeftEdge(a0),EUS_Structure+EUS_WinX
		move.w	wd_TopEdge(a0),EUS_Structure+EUS_WinY
	endc
;		move.l	mywindowlist(a5),a0
;		bsr	ShowBackdrops		;Hintergrundbilder einzeichnen
;		bsr	NewModuleEvent		;Namen eintragen, Subsonganzahl usw.
;		bsr	UpdatePrefs		;Prefs wie Songend/Filter usw. darstellen
;		bsr	AddGads			;Gadgets reinlinken
end$
		move.l	#EPNr_FirstExternal,d0	;damit Rcksprung in Mainloop mglich
		moveq	#0,d1
		moveq	#0,d2
		moveq	#0,d3
		rts
;********************************************************************************
;*                   Getconfig Callup                                           *
;********************************************************************************
GetConfig:
		lea	datas,a5
		move.l	WinHandle(a5),d0
		beq	end$
		move.l	d0,a0
	ifne	Eagleplayer
		move.w	wd_LeftEdge(a0),EUS_Structure+EUS_WinX
		move.w	wd_TopEdge(a0),EUS_Structure+EUS_WinY
	endc
end$
		moveq	#0,d0
		rts
;********************************************************************************
;* Images neu berechnen, Gadgets erstellen und eintragen bei Vernderung der    *
;* Windowlist, notwendig da ChangeWindowBox() nicht Realtime arbeitet           *
;********************************************************************************
HandleWinRefresh:
		move.l	WinHandle(a5),d0
		beq	end$
		move.l	d0,a0

		move.l	mywindowlist(a5),a0
		bsr	ShowBackdrops		;Hintergrundbilder einzeichnen

		bsr	NewModuleEvent		;Namen eintragen, Subsonganzahl usw.

		bsr	AddGads			;Gadgets reinlinken bzw. refresh

		bsr	SimChangeGui		;einzelne Gadgets ein/aus

		bsr	UpdatePrefs		;Prefs wie Songend/Filter usw. darstellen
end$
		move.l	#EPNr_FirstExternal,d0	;damit Rcksprung in Mainloop mglich
		moveq	#0,d1
		moveq	#0,d2
		moveq	#0,d3
		rts
;****************************************************************************************
;*                          Auswertung der GUIMen-Aktionen                             *
;****************************************************************************************
;Input: D0 - EPNr
;       D2 - Zustand, wenn ToggleCheck
MenueAuswertung:
	push	d4-a6

	cmp	#MI_Precisionselect,d0
	bne.s	nopalette$

	move.l	#PFlag_PaletteMode,d0
	not.l	d0
	move.l	Prefsflags(pc),d1
	and.l	d0,d1
	not.l	d0

	tst	d2
	beq	not$
	or.l	d0,d1
not$
	move.l	d1,Prefsflags

	suba.l	a0,a0
	move.l	#TOGGF_WinRefresh!TOGGF_ChangeImages,d0
	bsr	HandleToggles
	bra	end$
nopalette$

end$
	pop	d4-a6
	rts
;****************************************************************************************
;* Text ausgeben, dazu in TempObjekt schreiben und danach dieses ins Fenster bertragen *
;****************************************************************************************
;Input:  D0 - ID des Objektes in welches der Text geprintet werden soll
;        A0 - UBYTE *OutputString , nullterminiert
;Output: D0 = 0, ok <-> sonst Fehler
PrintText:
	Push	d1-a6
	move.l	d0,d7			;Objektnummer sichern
	move.l	a0,a4			;Textadresse sichern

	bsr	FindObject		;entsprechendes Objekt finden
	beq	error$
	move.l	d0,a1

	moveq	#0,d6
	move	MOL_Width(a1),d6	;Breite ber alles
	
textloop$
	move.l	d7,d0			;Objektnummer sichern
	bsr	TextLength
	cmp	d6,d0			;Breite des Textes <= max. Breite ?
	ble	ok$			;ok, weiter
	lea	(a0),a2
loop0$
	tst.b	(a2)+
	bne	loop0$
	clr.b	-2(a2)			;Text um 1 Zeichen krzen
	bra	textloop$
ok$
	move	d0,d5			;Breite sichern (momentan nicht weiter verwendet)

	;--------------- Textfeld komplett lschen ----------------

	lea	mytags(a5),a0
	move.b	#` `,(a0)
	clr.b	1(a0)
	move.l	d7,d0			;Objektnummer holen
	bsr	TextLength
	tst	d0
	beq	error$			;Space darf nicht 0 Pixel breit sein

	divu	d0,d6			;Anzahl der hineinpassenden Chars rausfinden

	move	MOL_Width(a1),d1	;Breite ber alles
	move	d6,d2
	mulu	d0,d2			;Breite der ermittelten Anzahl von Spaces
	sub	d2,d1			;Offset
Clrloop$
	move.b	#` `,d0
	bsr	PrintChar		;D0 = ASCII-Char, D1=Xpos, A1=Zielobjekt
	add	d0,d1
	
	subq	#1,d6
	bne	Clrloop$

	move.b	#` `,d0
	moveq	#0,d1			;sicherheitshalber am Anfang 1. Zeichen auch lschen
	bsr	PrintChar		;D0 = ASCII-Char, D1=Xpos, A1=Zielobjekt

	;----------------------------------------------------------

	moveq	#0,d1			;Xpos von 0 an (linksorientiert)
loop$
	move.b	(a4)+,d0
	beq	end$
	bsr	PrintChar		;D0 = ASCII-Char, D1=Xpos, A1=Zielobjekt
	add	d0,d1
	bra	loop$
end$
	move.l	d7,d0			;Objektnummer holen
	bsr	FindObject		;entsprechendes Objekt finden
	beq	error$
	move.l	d0,a0
	move.l	MOL_Images(a0),d2	;Image vorhanden ?
	beq	error$
	move	MOL_Left(a0),d0		;Xpos
	move	MOL_Top(a0),d1		;Ypos
	move.l	d2,a0			;Image
	suba.l	a1,a1			;def. Rastport
	bsr	ShowImage

	Pop	d1-a6
	moveq	#0,d0
	rts
error$
	Pop	d1-a6
	moveq	#-1,d0
	rts
;*************************************************************************************
;*                      Textlnge in Pixels berechnen                                *
;*************************************************************************************
;Input:  D0 - ID des Objektes in welches der Text geprintet werden soll
;        A0 - UBYTE *OutputString , nullterminiert
;Output: D0 = 0 -> Fehler (oder leerer Text), sonst Breite
TextLength:
	Push	d1-a6

	bsr	FindObject		;entsprechendes Objekt finden
	beq	Error$
	move.l	d0,a1

	move.l	MOL_UserData(a1),d0	;Font eingetragen ?
	beq	Error$
	move.l	d0,a1			;Fontobjekt

	move.l	MOL_UserData(a1),d1	;nominale Breite von fixedfonts

	move.l	MOL_CMDArg1(a1),d0	;Propinfo ?
	beq	nonprop$
	move.l	d0,a2			;Byteweise Breiten der einzelnen Zeichen

	moveq	#0,d2
	move	MOL_Width(a1),d2
	divu	d1,d2			;Anzahl der Zeichen

	moveq	#0,d0			;resultierende Breite
loop$
	moveq	#0,d1
	move.b	(a0)+,d1
	beq	end$
	sub	#32,d1			;Zeichen <32 werden als Space dargestellt
	bpl	hi$
	moveq	#0,d1	
hi$	cmp	d2,d1
	blt	ok$
	moveq	#0,d1			;nicht im Font enthaltene Zeichen als Space dargestellt
ok$
	moveq	#0,d3
	move.b	(a2,d1.w),d3
	add	d3,d0
	bra	loop$

nonprop$
	moveq	#-1,d0
add$
	addq	#1,d0
	tst.b	(a0)+
	bne	add$
	
	mulu	d1,d0
end$
Error$
	Pop	d1-a6
	rts
;*************************************************************************************
;*                               Objekt suchen                                       *
;*************************************************************************************
;Input:  D0 - ID des Objektes
;Output: D0 = 0 -> Fehler, sonst Adresse
FindObject:
	Push	d1-a6
	move.l	mywindowlist(A5),d1
	beq	Error$
	move.l	d1,a0
	move.l	WIL_Objects(a0),d1
Loop$
	beq	Error$
	move.l	d1,a0

	cmp	MOL_ID(a0),d0
	beq	Found$
	move.l	MOL_Next(a0),d1
	bra	Loop$
Error$
	suba.l	a0,a0
Found$
	move.l	a0,d0
	Pop	d1-a6
	tst.l	d0
	rts
;*************************************************************************************
;*                         Gadget im aktuellen Fenster suchen                        *
;*************************************************************************************
;Input:  D0 - ID des Gadgets
;Output: D0 = 0 -> Fehler, sonst Adresse
Findgadget:
	Push	d1-a6
	move	d0,d1

	lea	Datas,a5		; Data Pointer
	move.l	Winhandle(a5),d0
	beq	Error$
	move.l	d0,a0			;also aktives Gadget selbst suchen...
	move.l	wd_FirstGadget(a0),d0
loop$
	beq	Error$
	move.l	d0,a0
	cmp.w	gg_GadgetID(a0),d1
	beq	this$
	move.l	gg_NextGadget(a0),d0
	bra	loop$
this$
Error$
	Pop	d1-a6
	tst.l	d0
	rts
;*************************************************************************************
;* Fenster ffnen mit entsprechenden Settings, Images erzeugen und einzeichnen,      *
;* Gadgets erzeugen und einbinden                                                    *
;*************************************************************************************
;Input:  -
;Output: D0 = 0->ok, sonst Error
OpenWin:
	Push	All

;	ifne	Eagleplayer

		lea	Windowlist,a0
nextlist$
		move.l	(a0)+,d0
		beq	takefirst$
		move.l	(a0)+,d1		;Flags holen
		beq	thisWindowList$		;keine Flags -> also immer brauchbar
		move.l	d1,d2			;sichern

		and.l	Prefsflags(pc),d2	;mit Prefsflags ausmaskieren
		cmp.l	d1,d2			;alle Prefsflags richtig ?
		beq.l	thisWindowList$		;ja, nehmen

		bra	nextlist$
takefirst$				;nix gefunden, erstbeste Liste

;	endc
	
		lea	Windowlist,a0		;
		move.l	(a0)+,d0		;
		beq	error$			;
thisWindowList$
		move.l	d0,mywindowlist(A5)


		bsr	LockPubScreen		;Pubscreen holen
		bne	error$

;		lea	GlobalColoursNorm(pc),a0
;		move.l	Prefsflags(pc),d1
;		and.l	#PFlag_PaletteMode,d1
;		beq.s	norm$
;		lea	GlobalColoursGrey(pc),a0
;norm$
		move.l	mywindowlist(a5),a0
		bsr	OpenWindow		;Fenster ffnen
		bne	error$

		bsr	MakePenShareMap		;GGFX Pensharemap erzeugen und mit allen Images initialisieren
		bne	error$

		move.l	mywindowlist(a5),a0
		bsr	CreateImages		;alle verwendeten Images umrechnen
		bne	error$

		bsr	CreateGadgets		;Gadgets erzeugen
		bne	error$

		bsr	InitPrinttextRastport	;fr Printtext Rastport vorbereiten
		bsr	InitRemoteVolRastport

		move.l	LastMenu(A5),d0
		beq	nomenu$
		move.l	d0,a1
		move.l	WinHandle(a5),a0
		IB
		CallSys	SetMenuStrip
nomenu$
		bsr	ShowBackdrops		;Hintergrundbilder einzeichnen

		bsr	NewModuleEvent		;Namen eintragen, Subsonganzahl usw.

		bsr	AddGads			;Gadgets reinlinken

		bsr	UpdatePrefs		;Prefs wie Songend/Filter usw. darstellen

		bsr	InitAnalyzerBuffer	;f. Analyzer Hintergrund lschen
		bne	error$
		bsr	InitAnalyzer

		bsr	UpdateUPS

		bsr	EnableFXTask
	Pop	All
	moveq	#0,d0
	rts
error$
	bsr	CloseWin		;Cleanup im Fehlerfall
	Pop	All
	moveq	#-1,d0
	rts

*****************************************************************************
*                Rastport vorbereiten fr Printtext-Routine                 *
*****************************************************************************
InitPrinttextRastport:
	Push	All
	;----------------- Rastport Init, Mem Allozierung --------
	lea.l	TempRastport3(a5),a0
	move	#rp_SIZEOF-1,d0
clrRP$
	clr.b	(a0)+
	dbf	d0,clrRP$

	lea.l	TempRastport3(a5),a1
	GB
	CallSys	InitRastPort		;Rastport Init
	Pop	All
	rts
*****************************************************************************
*                Rastport vorbereiten fr Remotemodus Volume                *
*****************************************************************************
InitRemoteVolRastport:
	Push	All
	;----------------- Rastport Init, Mem Allozierung --------
	lea.l	TempRastport4(a5),a0
	move	#rp_SIZEOF-1,d0
clrRP$
	clr.b	(a0)+
	dbf	d0,clrRP$

	lea.l	TempRastport4(a5),a1
	GB
	CallSys	InitRastPort		;Rastport Init
	Pop	All
	rts
*****************************************************************************
*   Rastport vorbereiten fr Analyzer, Bitmap fr ECS/AGA allozieren        *
*****************************************************************************
;Input: -
;Output: D0 = 0 -> ok
InitAnalyzerBuffer:
	Push	d1-a6

	lea	FFT_TrueBuffer,a0
	move.l	#FFT_Width*FFT_Height,d0
clear$
	move.l	#AnalyzerBackColour,(a0)+
	subq.l	#1,d0
	bne	clear$
	Pop	d1-a6
	moveq	#0,d0
	rts
*****************************************************************************
* Alle Gadgets, die bisher fr das Hauptfenster erstellt wurden, einbinden  *
*****************************************************************************
AddGads:
		Push	All
		tst.b	GD_GadgetsIn(a5)
		bne.s	None$

		move.l	WinHandle(a5),d0
		beq.s	None$
		move.l	d0,a0
		move.l	GD_FirstGadget(a5),a1
		move.w	GD_Count(a5),d1
		beq.s	None$
		moveq	#-1,d0
		suba.l	a2,a2
		IB
		CallSys	AddGList

		st	GD_GadgetsIn(a5)
None$
		move.l	WinHandle(A5),a0
		IB
		CallSys	RefreshWindowFrame
		Pop	All
		rts
*****************************************************************************
*             Alle Gadgets, aus dem Hauptfenster entfernen                  *
*****************************************************************************
RemoveGads:
		Push	All
		tst.b	GD_GadgetsIn(a5)
		beq.s	None$

		move.l	WinHandle(a5),d0
		beq.s	None$
		move.l	d0,a0
		move.l	GD_FirstGadget(a5),a1
		move.w	GD_Count(a5),d0
		beq.s	None$

		IB
		CallSys	RemoveGList
None$
		sf	GD_GadgetsIn(a5)
		Pop	All
		rts
*****************************************************************************
* Alle Gadgets, die bisher fr das Hauptfenster erstellt wurden, freigeben *
****************************************************************************
FreeGadgets:
		Push	d0-a6

		move	GD_Count(a5),d6
		subq.w	#1,d6
		blt.s	end$
		move.l	GD_FirstGadget(a5),d0
loop$:		beq.s	end$
		move.l	d0,a0
		move.l	(a0),d4				;next 

		move.l	gg_UserData(a0),d2		;Image Objekt
		IB
		CallSys	DisposeObject			;Gadget freigeben

		tst.l	d2
		beq.s	noI$
		move.l	d2,a0
		CallSys	DisposeObject			;zugehriges Image freigeben

noI$:		move.l	GD_MyClass(A5),d0
		beq.s	noC$
		move.l	d0,a0
		jsr	_LVOFreeClass(a6)		;Klasse lschen
		tst.l	d0				;noch in Benutzung ?
		beq.s	noC$				;yup, weiter
		clr.l	GD_MyClass(A5)		;Klasse lschen
noC$:		move.l	d4,d0
		dbf	d6,loop$

end$:		clr	GD_Count(A5)
		clr.l	GD_FirstGadget(A5)
		clr.l	GD_PreviousGad(a5)
		Pop	d0-a6
		rts


*************************************************************************
*          Boopsi Gadgets fr das HauptFenster erstellen                *
*************************************************************************
;Input:  a0 = Windowliste
;Output: d0 = 0->ok, sonst error
CreateGadgets:
		Push	d1-a6
		clr.l	GD_FirstGadget(A5)
		clr	GD_Count(A5)
		clr.l	GD_PreviousGad(a5)

		move.l	WinHandle(A5),d0	;Fenster offen ?
		beq	ErrorinGads$

		move.l	WIL_Objects(a0),d0
		beq	ErrorinGads$

nextobject$
		move.l	d0,a0			;1. Objekt

		move	MOL_Type(a0),d1
		cmp	#GLA_Button,d1
		beq	button$
		cmp	#GLA_WinDrag,d1
		beq	button$
		cmp	#GLA_WinClose,d1
		beq	button$
		cmp	#GLA_Moused,d1
		beq	button$
		cmp	#GLA_WinDepth,d1
		bne	noButton$
	nop
button$
		bsr	MakeButton$
noButton$
		;--- hier nchste Types abarbeiten ---

		move.l	MOL_Next(a0),d0
		bne	nextobject$

		Pop	d1-a6
		moveq	#0,d0
		rts
ErrorinGads$
		bsr	FreeGadgets		;im Fehlerfall alles allozierte freigeben

		Pop	d1-a6
		moveq	#-1,d0
		rts

;--------------------------------------------------------------------------------
;Input:  A0 = Objekt
;Output: d0 = 0->ok, sonst Fehler
MakeButton$
		Push	d1-a6
		move	MOL_Left(a0),d1
		move	MOL_Top(a0),d2
		move	MOL_Width(a0),d3
		move	MOL_Height(a0),d4
		moveq	#0,d5
		move.w	MOL_ID(a0),d5		;GA_ID
		move.w	MOL_Type(a0),d6		;Typ des Gadgets (Button, WDRAG usw.)
		move.l	MOL_Flags(a0),d7	;Flags
		move.l	MOL_Images(a0),a3	;Image(s)

		bsr	GetGadget$
		beq.s	error$

		tst.w	GD_Count(A5)		;Gadget verketten
		bne.s	notfirst$
		move.l	d0,GD_FirstGadget(A5)
notfirst$
		addq	#1,GD_Count(A5)
		move.l	d0,GD_PreviousGad(A5)	;GA_Previous

		Pop	d1-a6
		moveq	#0,d0
		rts
error$		Pop	d1-a6
		moveq	#-1,d0
		rts

GetGadget$	Push	d1-a6

		lea	mytags(a5),a2
		move.l	a3,d0
		beq	noimage$

		move.l	GD_MyClass(A5),d0
		bne.s	gotit$

		lea	ClassDispatcher$(pc),a1		; pointer to dispatcher
		bsr	Initmyclass
		move.l	d0,GD_MyClass(A5)
		beq	err2$
gotit$:
		move.l	d0,a0
		lea	mytags(a5),a2

		move.l	#IA_Width,(a2)+
		clr.w	(a2)+
;		move	IML_Width(a3),d0
		move	d3,(a2)+

		move.l	#IA_Height,(a2)+
		clr.w	(a2)+
;		move	IML_Height(a3),d0
		move	d4,(a2)+

		move.l	#IA_Data,(a2)+
		move.l	a3,(A2)+

;		move.l	#SYSIA_Which,(a2)+		;Hier: 0=enabled,1=disabled
;		move.l	d7,d0
;		and.b	#1,d0
;		move.l	d0,(A2)+

		move.l	#TAG_DONE,(A2)
		lea	mytags(a5),a2
		suba.l	a1,a1
		IB
		Push	d1-d5				;just to be sure...
		jsr	_LVONewObjectA(a6)
		Pop	d1-d5
		move.l	d0,GD_LastImage(A5)	;Image sichern, falls Button nicht alloziert werden kann
		beq	err2$

		lea	mytags(a5),a2
		move.l	#GA_UserData,(A2)+
		move.l	d0,(A2)+		;zum Freigeben Imageobjekt sichern
		move.l	#GA_Image,(a2)+
		move.l	d0,(A2)+	;Image, wird zum Draw ber eigene Klasse aufgerufen
noimage$
		move.l	#GA_Left,(A2)+
		ext.l	d1
		move.l	d1,(A2)+
		move.l	#GA_Top,(A2)+
		ext.l	d2
		move.l	d2,(A2)+
		move.l	#GA_Width,(A2)+
		ext.l	d3
		move.l	d3,(A2)+
		move.l	#GA_Height,(A2)+
		ext.l	d4
		move.l	d4,(A2)+
		move.l	#GA_ID,(a2)+
		move.l	d5,(A2)+

		move.l	GD_PreviousGad(A5),d0		;erstes Gadget ?
		beq.s	skipprev$			;ja, berspringen
		move.l	#GA_Previous,(A2)+
		move.l	d0,(a2)+
skipprev$

		move.l	#GA_ToggleSelect,(A2)+		;funktioniert (noch?) nicht
		move.l	d7,d0
		and.l	#GACT_TOGGLESELECT,d0
		sne	d0
		and.l	#~1,d0
		move.l	d0,(a2)+

		move.l	#GA_Immediate,(A2)+		;Flags.3
		move.l	d7,d0
		and.l	#GACT_IMMEDIATE,d0
		sne	d0
		and.l	#~1,d0
		move.l	d0,(a2)+

		move.l	d7,d0
		and.l	#MFLG_Repeat,d0
		beq.s	.noIDCMPUpdate

		move.l	#ICA_TARGET,(a2)+
		move.l	#ICTARGET_IDCMP,(A2)+

;		move.l	#ICA_Map,(a2)+
;		move.l	#Map,(a2)+

;		move.l	#ICSPECIAL_CODE,(a2)+		;bergabe der ObjektID fr
;		move.l	#-1,(a2)+			;Abfrage des aktiven Gadgets
.noIDCMPUpdate

		move.l	#GA_RelVerify,(A2)+		;Flags.2
		move.l	d7,d0
		and.l	#GACT_RELVERIFY,d0
		sne	d0
		and.l	#~1,d0
		move.l	d0,(a2)+

		move.l	#GA_FollowMouse,(a2)+
		move.l	d7,d0
		and.l	#GACT_FOLLOWMOUSE,d0
		sne	d0
		and.l	#1,d0
		move.l	d0,(a2)+

		move.l	#GA_Disabled,(A2)+		;Flags.1
		move.l	d7,d0
		and.l	#GFLG_Disabled<<16,d0
		sne	d0
		and.l	#1,d0
		move.l	d0,(A2)+

		cmp	#GLA_WinDrag,d6
		bne	nodrag$
		move.l	#GA_SysGType,(a2)+
		move.l	#GTYP_WDRAGGING,(a2)+
nodrag$

		cmp	#GLA_WinDepth,d6
		bne	nodepth$
		move.l	#GA_SysGType,(a2)+
		move.l	#GTYP_WDEPTH,(a2)+
nodepth$

		cmp	#GLA_WinClose,d6
		bne	noclose$
		move.l	#GA_SysGType,(a2)+
		move.l	#GTYP_CLOSE,(a2)+
noclose$

		move.l	#TAG_DONE,(A2)

;		lea	frbutclass(pc),a1		;ButtonClass
		lea	butclass(pc),a1
		suba.l	a0,a0				;Privclass keine
		lea	mytags(a5),a2			;Tags
		IB
		jsr	_LVONewObjectA(a6)
		tst.l	d0				;Objekt bekommen -> OK
		bne.s	reddy$				;OK, Sprung zurck

;.... Fehlerfall

		tst.l	GD_LastImage(a5)		;Image bekommen ? (JA !, sonst landen wir nicht hier)
		beq.s	noI$
		move.l	GD_LastImage(a5),a0
		IB
		jsr	_LVODisposeObject(a6)
noI$:
		move.l	GD_MyClass(A5),d0
		beq.s	noC$
		move.l	d0,a0
		IB
		jsr	_LVOFreeClass(a6)		;Klasse freigeben (Versuch)
		tst.l	d0
		beq.s	noC$				;Klasse in Benutzung->weiter
		clr.l	GD_MyClass(A5)
noC$:		moveq	#0,d0				;Fehler !

;......
reddy$
		clr.l	GD_LastImage(a5)		;zur Sicherheit lschen
err2$:
		Pop	d1-a6
		tst.l	d0
		rts

ClassDispatcher$:
		Push	d2-d7/a2-a6		; save registers
		move.l	a0,a4			; class to a4
		move.l	a1,a3			; msg to a3
		lea	Datas,a5		; Data Pointer

		moveq	#8,d4			; Minwidth
		moveq	#8,d5			; Minheight

		cmp.l	#OM_DISPOSE,(a3)	; delete an Object ?
		bne.s	noDis$

		clr.l	ig_ImageData(a2)
		bra	default$
noDis$:
		cmp.l	#OM_GET,(a3)
		bne.s	noGet$

		cmp.l	#IA_SupportsDisable,opg_AttrID(a3)	;own Disabling routines ?
		bne	default$		;default: call SuperClass

		move.l	opg_Storage(a3),d0
		beq	default$
		move.l	d0,a0

		moveq	#1,d0			; return TRUE
		move.l	d0,(a0)
		bra	Done$
noGet$
		cmp.l	#OM_NEW,(a3)		; user want a new object ?
		bne.s	noNew$
		bsr	MakeNew
		bra	Done$
noNew$:
		cmp.l	#IM_DRAW,(A3)		;IM_DRAW,(a3)		; must we draw  ?
		bne	default$		; no!

		move.l	ig_ImageData(a2),d0	; Image vorhanden ?
		beq	Done$
		move.l	d0,a0

		moveq	#0,d0			; left = 0
		moveq	#0,d1			; top = 0
		move.w	impd_OffsetX(a3),d0	; left = x offset
		move.w	impd_OffsetY(a3),d1	; top = y offset

		GB
		move.l	impd_RPort(a3),a1	; rPort to a1

		cmp.l	#IDS_DISABLED,impd_State(a3)
		bne	nondisabled$

		tst.l	IML_Next(a0)		;is there a selected Image ?
		beq.s	NoImg$			;-> NO, out
		move.l	IML_Next(a0),a0

		tst.l	IML_Next(a0)		;is there a "disabled" Image ?
		beq.s	NoImg$			;-> NO, out
		move.l	IML_Next(a0),a0

		bra	DoUnSEL$		;show "disabled"-Image
nondisabled$
		cmp.l	#IDS_SELECTED,impd_State(a3) ; selected Image ?
		bne	DoUnSEL$		;-> unselected Image

		tst.l	IML_Next(a0)		;is there a selected Image ?
		beq.s	DoUnSEL$		;-> NO
		move.l	IML_Next(a0),a0

DoUnSEL$:
		bsr	ShowImage		;Image-Struktur und Position erforderlich, 
						;sowie Rastport oder 0 in A1
NoImg$
		moveq	#1,d0			; return TRUE
		bra.s	Done$

default$:	move.l	a4,a0			; class to a0
		move.l	a3,a1			; msg to a1
		bsr	CallSuper		; call superclass
Done$:		Pop	d2-d7/a2-a6		; restore registers
		rts

*-----------------------------------------------------------------------------*
MakeNew:	
		UB
		move.l	#IA_Data,d0		; the tag we want
		moveq	#0,d1			; default = NULL
		move.l	ops_AttrList(a3),a0	; tags to a0
		jsr	_LVOGetTagData(A6)	; look for the tag
		move.l	d0,d5			; Image or Null

		move.l	#IA_Width,d0		; the tag we want
		moveq	#0,d1			; default = NULL
		move.l	ops_AttrList(a3),a0	; tags to a0
		jsr	_LVOGetTagData(A6)	; look for the tag
		move.l	d0,d6			; Image or Null

		move.l	#IA_Height,d0		; the tag we want
		moveq	#0,d1			; default = NULL
		move.l	ops_AttrList(a3),a0	; tags to a0
		jsr	_LVOGetTagData(A6)	; look for the tag
		move	d0,d7

;		move.l	#SYSIA_Which,d0		;Tag to be found
;		moveq	#0,d1			;default Return value
;		move.l	ops_AttrList(a3),a0	;Taglist
;		jsr	_LVOGetTagData(A6)	;Utility-LibCall
;		move	d0,d5

		move.l	a4,a0			;class to a0
		move.l	a3,a1			;msg to a1
		Push	d5-d7
		bsr	CallSuper		;call the superclass
		Pop	d5-d7
		move.l	d0,a0			;put object in a0
		tst.l	d0
		beq.s	.newErrorO		;failed!!!
		move.l	d5,ig_ImageData(a0)	;set Image(s)

		move.w	d6,ig_Width(a0)		;set width
		move.w	d7,ig_Height(a0)	;set height
;		move.b	d5,ig_PlanePick(A0)	;set Type
		bra	Done$			;return Object
.newErrorO:	moveq	#0,d0			; 0 for error
Done$:		rts
;		Pop	d2-d7/a2-a6		; restore registers
;		rts

*--------------------- Call Superclass ---------------------------------*
CallSuper:	Push	a2			; save a2
		move.l	cl_Super(a0),a0		; get superclass in a0
		pea.l	ourRet			; Push return address
		move.l	h_Entry(a0),-(sp)	; Push superclass dispatcher
		rts				; jump to super dispatcher
ourRet:		Pop	a2			; restore a2
		rts

*----------------------------------------------------------------------------*
* --- Initialize our private class. It set's up a class
* --- with "imageclass" as superclass.
Initmyclass:	Push	d1-d6/a0/a1/a2/a6	; save registers
		move.l	a1,d6

		IB
		suba.l	a0,a0			; class ID
		lea	imgclass(pc),a1		; points to "imageclass"
		suba.l	a2,a2			; no superclass pointer
		moveq	#0,d0			; 12 bytes instance data (MCP&UHack Sysipatches)
		moveq	#0,d1			; no flags
		CallSys	MakeClass		; make the class
		move.l	d0,a0			; put class in a0
		tst.l	d0
		beq.s	.noClass		; failed!!!
		move.l	d6,h_Entry(a0)		; set our dispatcher
.noClass:	Pop	d1-d6/a0/a1/a2/a6	; restore registers
		rts
;*************************************************************************************
;*                   Fenster schlieen, alles freigeben                              *
;*************************************************************************************
;Input:  -
;Output: -
CloseWin:
	bsr	GetConfig

	bsr	DisableFXTask

	bsr	RemoveGads		;Gadgets entfernen

	bsr	FreeGadgets		;und freigeben

	bsr	ClosemyWindow		;dann Fenster dichtmachen

	bsr	FreeImages		;dann Images freigeben

	bsr	FreePenShareMap		;GGFX Pensharemap freigeben 

	bsr	UnlockPubScreen		;Screen freigeben

	clr.l	mywindowlist(a5)
	rts

;--------------------------- Bilder einzeichnen ----------------------------------
;Input: d0 = XPos.w
;       d1 = YPos.w
;       a0 = ImageStruktur (IML_...)
;	a1 = Rastport (Ziel) oder 0, dann default (vom Fenster verwendet)
;Output: - (im Fehlerfall, z.B. kein Fenster offen, falsches Bitmapformat, wird Aufruf ignoriert)
ShowImage:
	Push	All

	ifne	FXTask

	ifne	Semaphore
	Push	d0/d1/a0/a1
	lea	Image_Semaphore(a5),a0
	EB
	CallSys	ObtainSemaphore
	Pop	d0/d1/a0/a1
	endc

	endc

	move.l	a1,d2
	bne.s	set$

	move.l	WinHandle(A5),d2
	beq	error$
	move.l	d2,a1
	move.l	wd_RPort(a1),a1			;Rastport (Ziel)
set$
	cmp	#5,IML_Type(a0)			;24 Bit Chunky-Images mit ggfx, dann IML_ColourMap
						;== DDrawHandle
	beq	Chunky24$

	cmp	#2,IML_Type(a0)			;8 Bit Chunky-Images mit WPA8
	beq	Chunky$
	cmp	#3,IML_Type(a0)			;8 Bit Chunky-Images mit WPA8
	beq	Chunky$

	;-------------------- Bitmap kopieren ------------------------------
	move.l	IML_Rendered(a0),d7
	beq	error$

	move	d0,d2				;Leftedge
	move	d1,d3				;Topedge

	moveq	#0,d0				;XPos in Quelle
	moveq	#0,d1				;YPos in Quelle

	move	IML_Width(a0),d4		;Breite
	move	IML_Height(a0),d5		;Hhe

	move.l	d7,a0

	move.b	#$c0,d6		;Miniterm

	GB
	CallSys	BltBitMapRastPort
	bra	ok$
Chunky$
	;-------------------- 8 Bit Chunky kopieren --------------------------

	move.l	IML_Rendered(a0),d7
	beq	error$
	move.l	d7,a2				;Array

;	move	IML_Width(a0),d2
;	move	IML_Height(a0),d3
;	add	d0,d2				;Xstart+Width=XStop
;	add	d1,d3				;Ystart+Height=YStop
;	subq	#1,d2
;	subq	#1,d3

;	move.l	a1,a0				;Rastport (Ziel)
;	lea.l	TempRastport5(a5),a1		;TempRP
;	GB
;	CallSys	WritePixelArray8
	bra	ok$
Chunky24$
	;---------------- 24 Bit 0RGB Chunky kopieren ----------------------
	ifne	FXTask
	ifeq	Semaphore
		Push	All
		EB
		CallSys	Forbid
		Pop	All
	endc
	endc

		move.l	guigfx(a5),a6
		move.l	IML_ColourMap(a0),d7	;ddh fr Truecolour Images
		beq	ok$
		move.l	IML_Data(a0),a1		;Buffer
		move.l	d7,a0			;ddh
		suba.l	a2,a2
		CallSys	DirectDrawTrueColorA	;DirectDrawTrueColorA(ddh,array,x,y,tags)(a0,a1,d0,d1,a2)

	ifne	FXTask
	ifeq	Semaphore
		Push	All
		EB
		CallSys	Permit
		Pop	All
	endc
	endc
ok$
error$

	ifne	FXTask
	ifne	Semaphore
		lea	Image_Semaphore(a5),a0
		EB
		CallSys	ReleaseSemaphore
	endc
	endc

	Pop	All
	rts
;*************************************************************************************
;*                      genau 1 Zeichen printen                                      *
;*************************************************************************************
;Input:  D0 - Char
;        D1 - XPosition
;        A1 - struct *Objekt
;Output: D0 = 0 -> Fehler, sonst Breite des Zeichens
PrintChar:
	Push	d1-a6
	move.l	MOL_Images(a1),d2
	beq	error$
	move.l	d2,a0
	move.l	IML_Rendered(a0),d2
	beq	error$
	move.l	d2,TempRastport3+rp_BitMap(a5)


	move.l	MOL_UserData(a1),d3	;Font eingetragen ?
	beq	error$
	move.l	d3,a1			;Fontobjekt

	move.l	MOL_UserData(a1),d7	;nominale Breite von fixedfonts

	moveq	#0,d2
	move	MOL_Width(a1),d2
	divu	d7,d2			;Anzahl der Zeichen

	and	#$ff,d0
	sub	#32,d0			;Zeichen <32 werden als Space dargestellt
	bpl	hi$
	moveq	#0,d0
hi$	cmp	d2,d0
	blt	ok$
	moveq	#0,d0			;nicht im Font enthaltene Zeichen als Space dargestellt
ok$
	move	d0,d4			;Zeichen nummer im Font
	mulu	d7,d4			;mal nominale Breite = XPos in Quelle

	move.l	MOL_CMDArg1(a1),d3	;Propinfo ?
	beq	nonprop$
	move.l	d3,a2			;Byteweise Breiten der einzelnen Zeichen

	move.b	(a2,d0.w),d7		;Propinfo->Char
nonprop$

	move.l	MOL_Images(a1),d2
	beq	error$
	move.l	d2,a1

	btst	#0,d1			;ungerade X-Position ?
	beq	noimpair$
					;ja, also alternatives Image fr diesen Fall suchen,
					;wegen Rasteranpassung

	tst.l	IML_Next(a1)		;kein alternatives Image angeboten -> normal weiter
	beq	noimpair$
	move.l	IML_Next(a1),a1
noimpair$
	move.l	IML_Rendered(a1),d2
	beq	error$
	move.l	d2,a0				;Bitmap (Quelle)

	move	d4,d0				;Xpos in Quelle
	move	d1,d2				;XPos in Ziel

	moveq	#0,d1				;YPos in Quelle
	moveq	#0,d3				;YPos in Ziel

	move	d7,d4				;Breite dieses Zeichens
	move	IML_Height(a1),d5		;Hhe

	lea	TempRastport3(a5),a1		;Rastport (Ziel)
	move.b	#$c0,d6				;Miniterm

	GB
	CallSys	BltBitMapRastPort

	moveq	#0,d0
	move	d7,d0
	Pop	d1-a6
	rts
error$
	moveq	#0,d0
	Pop	d1-a6
	rts


;--------------------- Hintergrundbilder einzeichnen -------------------------------
;Input:  a0 = Windowliste
;Output: -
ShowBackdrops:
	Push	All
	move.l	WIL_Objects(a0),d0
	beq	error$

nextobject$
	move.l	d0,a3			;Objekt

	cmp	#ID_Backdrop,MOL_ID(a3)
	bne	nobackdrop$

	move.l	MOL_Images(a3),d2
	beq	nobackdrop$
	move.l	d2,a0

	move	MOL_Left(a3),d0
	move	MOL_Top(a3),d1
	suba.l	a1,a1
	bsr	ShowImage		;Image-Struktur und Position erforderlich

nobackdrop$
	move.l	MOL_Next(A3),d0
	bne	nextobject$

error$
	Pop	All
	rts
;
;----------------------- Fenster ffnen --------------------------------------------
;Input:  a0 = Windowliste
;Output: d0 = 0->ok, sonst error
;
OpenWindow:
	Push	d1-a6
	move.l	a0,a4

	lea	mytags(a5),a1

	;definierte Werte
	ifeq	Eagleplayer
		move.l	#WA_Left,(a1)+
		moveq	#0,d0
		move	WIL_LeftEdge(a4),d0
		move.l	d0,(a1)+

		move.l	#WA_Top,(a1)+
		move	WIL_TopEdge(a4),d0
		move.l	d0,(a1)+
	else
		move.l	#WA_Left,(a1)+
		moveq	#0,d0
		move	EUS_Structure+EUS_WinX(pc),d0
		move.l	d0,(a1)+

		move.l	#WA_Top,(a1)+
		move	EUS_Structure+EUS_WinY(pc),d0
		move.l	d0,(a1)+
	endc

	move.l	#WA_InnerWidth,(a1)+
	move	WIL_Width(a4),d0
	move.l	d0,(a1)+

	move.l	#WA_InnerHeight,(a1)+
	move	WIL_Height(a4),d0
	move.l	d0,(a1)+

	move.l	#WA_Flags,(a1)+
	move.l	WIL_Flags(A4),(a1)+

	move.l	#WA_IDCMP,(a1)+
	move.l	WIL_IDCMP(A4),(a1)+

	;misc
	move.l	#WA_PubScreen,(a1)+	;der Pubscreen sollte garantiert keinen Fehler
	move.l	mypubscreen(a5),(a1)+	;erzeugen, da der Lock noch besteht
	
	move.l	#WA_NewLookMenus,(a1)+
	move.l	#1,(a1)+

	move.l	#WA_AutoAdjust,(a1)+	;wegen der automatischen Positionsverschiebung
	move.l	#1,(a1)+

	move.l	myScreentitle(a5),d0
	beq.s	notitle$
	move.l	#WA_ScreenTitle,(a1)+
	move.l	d0,(a1)+		;wird ausgehend vom EP neu gesetzt
notitle$

	;WA_Title gibts nicht wegen Borderless

	clr.l	(a1)
	lea	mytags(A5),a1

	suba.l	a0,a0
	IB
	CallSys	OpenWindowTagList
	move.l	d0,WinHandle(a5)
	beq	error$

	Pop	d1-a6
	moveq	#0,d0
	rts
error$
	Pop	d1-a6
	moveq	#-1,d0
	rts
;
;--------------------- Fenster schlieen -------------------------------------------
;Input:  -
;Output: -
;
ClosemyWindow:
	Push	All
	move.l	WinHandle(A5),d0
	beq	ok$

	move.l	d0,a0

	move.l	wd_MenuStrip(A0),LastMenu(A5)

	IB
	CallSys	ClearMenuStrip

	move.l	WinHandle(A5),a0
	CallSys	CloseWindow

	clr.l	WinHandle(A5)
ok$
	Pop	All
	rts
;--- Guigfx Pensharemap und Drawhandle erzeugen und mit allen Images initialisieren -----
;Input:  Bereich von START_IMAGES bis END_IMAGES, siehe auch dort
;Output: D0 = 0->ok, sonst error
MakePenShareMap:
	push	d1-a6
	move.l	winhandle(a5),d0		;Fenster geffnet ?
	beq	error$
	tst.l	drawhandle(a5)			;DrawHandle bereits vorhanden ?
	bne	ok$

	move.l	guigfx(A5),a6

	lea	mytags(a5),a0

	ifne	ggfxdefaults
		move.l	#GGFX_HSType,(a0)+
		move.l	#HSTYPE_12BIT_TURBO,(a0)+
	endc

	move.l	#TAG_DONE,(a0)+
	lea	mytags(a5),a0
	CallSys	CreatePenShareMapA		;PenShareMap erzeugen
	move.l	d0,psm(a5)			;
	beq	error$

	;Pensharemap init
	lea	START_IMAGES,a4
PSM_Loop$
	cmp	#4,IML_Type(a4)
	bne	noRGB32$

	move.l	IML_Data(A4),a1		;Array
	move	IML_Width(A4),d0	;Breite
	move	IML_Height(a4),d1	;Hhe

	lea	mytags(A5),a2
	move.l	#GGFX_PixelFormat,(a2)+
	move.l	#PIXFMT_0RGB_32,(a2)+
	move.l	#TAG_DONE,(A2)+
	lea	mytags(A5),a2

	move.l	psm(a5),a0
	CallSys	AddPixelArrayA
	bra	next$
noRGB32$
	cmp	#0,IML_Type(A4)		;Chunky 8 Bit ?
	bne	noChunky$
	move.l	IML_ColourMap(a4),d0	;Farbtabelle ?
	beq	noChunky$
	move.l	d0,a1

	lea	mytags(A5),a2
	move.l	#GGFX_PixelFormat,(a2)+
	move.l	#PIXFMT_CHUNKY_CLUT,(a2)+
	move.l	#GGFX_NumColors,(a2)+
	moveq	#0,d0
	move	(a1)+,d0
	move.l	d0,(a2)+
	move.l	#GGFX_Palette,(a2)+
	move.l	a1,(a2)+
	move.l	#TAG_DONE,(A2)+
	lea	mytags(A5),a2

	move.l	IML_Data(A4),a1		;Array
	move	IML_Width(A4),d0	;Breite
	move	IML_Height(a4),d1	;Hhe
	move.l	psm(a5),a0
	CallSys	AddPixelArrayA
noChunky$
next$
	add.l	#IML_Sizeof,a4
	cmpa.l	#END_IMAGES,a4
	blt	PSM_Loop$

	move.l	mypubscreen(a5),a0
	lea.l	sc_ViewPort(a0),a0		;Viewport->Colormap
	move.l	Gfx_base(a5),a6
	CallSys	GetVPModeID

	move.l	psm(a5),a0				;Pensharemap
	move.l	mypubscreen(a5),a1
	move.l	sc_ViewPort+vp_ColorMap(a1),a2	;Viewport->Colormap

	move.l	winhandle(a5),a1
	move.l	wd_RPort(a1),a1			;Rastport des Screens

	lea	mytags(a5),a3
	move.l	#GGFX_ModeID,(a3)+
	move.l	d0,(a3)+

	ifeq	ggfxdefaults
		move.l	#GGFX_DitherThreshold,(a3)+
		move.l	#60,(a3)+
		move.l	#GGFX_DitherMode,(A3)+
		move.l	#DITHERMODE_EDD,(a3)+
	endc

	move.l	Prefsflags(pc),d1
	and.l	#PFlag_PaletteMode,d1
	beq.s	norm$
	move.l	#OBP_Precision,(a3)+
	move.l	#PRECISION_EXACT,(a3)+
norm$
	move.l	#TAG_DONE,(a3)+
	lea	mytags(a5),a3

	move.l	guigfx(A5),a6
	CallSys	ObtainDrawHandleA
	move.l	d0,drawhandle(a5)
	beq	error$
ok$
	pop	d1-a6
	moveq	#0,d0
	rts
error$
	pop	d1-a6
	lea	txt_nomem(pc),a0
	bsr	MERROR

	moveq	#-1,d0
	rts

;-------------------------- Guigfx Pensharemap freigeben ---------------------------
FreePenShareMap:
	push	d1-a6
	move.l	guigfx(A5),a6

	move.l	drawhandle(A5),d0
	beq	nodraw$
	move.l	d0,a0
	CallSys	ReleaseDrawHandle
nodraw$

	move.l	psm(a5),d0
	beq	nopsm$
	move.l	d0,a0
	CallSys	DeletePenShareMap
nopsm$
	clr.l	drawhandle(A5)
	clr.l	psm(a5)
	pop	d1-a6
	tst.l	d0
	rts
;
;----------------------- Images umrechnen --------------------------------------
;Input:  a0 = Windowliste
;Output: d0 = 0->ok, sonst error
;
CreateImages:
	Push	d1-a6
	move.l	guigfx(A5),a6

	move.l	drawhandle(A5),d0
	beq	error$

	move.l	WIL_Objects(a0),d0
	beq	error$
	move.l	A0,CI_UsedWindowList(A5)

nextobject$
	move.l	d0,a3			;Objekt
	move.l	MOL_Images(a3),d0	;Image Struktur vorhanden ?
	beq	noimage$		;nein, nchstes Objekt

nextimage$
	move.l	d0,a0			;1. Image Struktur
	bsr	MakeImage		;Image umrechnen
	bne	error$
	move.l	IML_Next(a0),d0		;weitere Images ?
	bne	nextimage$		;ja, auch diese bearbeiten

noimage$
	move.l	MOL_Next(A3),d0
	bne	nextobject$

	Pop	d1-a6
	moveq	#0,d0
	rts
error$
	bsr	FreeImages

	lea	txt_nomem(pc),a0
	bsr	MERROR

	Pop	d1-a6
	moveq	#-1,d0
	rts
;
;----------------------- berechnete Images freigeben ----------------------------
;Input:  -
;Output: -
;
FreeImages:
	Push	All

	lea	Windowlist(pc),a0	;alle Windows durchgehen, um Images freizugeben
loop$
	move.l	(a0),d0
	beq	error$
	Push	a0
	move.l	d0,a0
	bsr	freelist$
	Pop	a0
	addq.l	#8,a0
	bra	loop$
error$
	clr.l	CI_UsedWindowList(a5)
	Pop	All
	rts

freelist$
	move.l	WIL_Objects(a0),d0
	beq	end$

nextobject$
	move.l	d0,a3			;Objekt
	move.l	MOL_Images(a3),d0	;Image Struktur vorhanden ?
	beq	noimage$		;nein, nchstes Objekt

nextimage$
	move.l	d0,a0			;1. Image Struktur
	bsr	FreeImage$		;Image umrechnen

	move.l	IML_Next(a0),d0		;weitere Images ?
	bne	nextimage$		;ja, auch diese bearbeiten

noimage$
	move.l	MOL_Next(A3),d0
	bne	nextobject$
end$
	rts

FreeImage$
	Push	All
	cmp	#5,IML_Type(a0)
	beq	Chunky24$

	move.l	IML_Rendered(A0),d0
	beq	norender$
	clr.l	IML_Rendered(A0)

	cmp	#2,IML_Type(a0)
	beq	Chunky$
	cmp	#3,IML_Type(a0)
	beq	Chunky$

	move.l	d0,a0
	GB
	CallSys	FreeBitMap
	bra.s	norender$
Chunky$
	move.l	d0,a1

	move	IML_Width(a0),d0
	mulu	IML_Height(a0),d0
	EB
	CallSys	FreeMem
	bra.s	norender$
Chunky24$
	move.l	IML_ColourMap(a0),d0
	beq	norender$
	clr.l	IML_ColourMap(a0)
	move.l	d0,a0
	move.l	guigfx(a5),a6
	CallSys	DeleteDirectDrawHandle
norender$
	Pop	All
	rts
;
;--------------------------- ein Image berechnen -------------------------------
;Input:  a0 = Image-Struktur
;Output: d0 = 0->ok, sonst error
;
MakeImage:
	Push	d1-a6
	tst.l	IML_Rendered(a0)	;Image bereits gerendert ?
	bne	ok$			;ok -> raus
	move.l	a0,a4		;sichern

	cmp	#5,IML_Type(a4)
	bne	notruedirect$

	tst.l	IML_ColourMap(a4)	;ddrawhandle vorhanden ?
	bne	ok$			;ok -> raus

	move.l	drawhandle(a5),a0	;drawhandle
	suba.l	a1,a1			;Tags
	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	move.w	IML_Width(A4),d0	;Source Width
	move.w	IML_Height(A4),d1	;Source Height
	move.l	d0,d2
	move.l	d1,d3
;	addq	#1,d2
;	addq	#1,d3

	move.l	guigfx(A5),a6
	CallSys	CreateDirectDrawHandleA
	move.l	d0,IML_ColourMap(a4)
	beq	fail$
	bra	ok$
notruedirect$
	cmp	#4,IML_Type(a4)
	bne	noTrue$

	move.l	IML_Data(A4),a0		;Array
	move	IML_Width(A4),d0	;Breite
	move	IML_Height(A4),d1	;Hhe

	lea	mytags(A5),a1
	move.l	#GGFX_PixelFormat,(a1)+
	move.l	#PIXFMT_0RGB_32,(a1)+
	move.l	#TAG_DONE,(a1)+
	lea	mytags(A5),a1

	move.l	guigfx(A5),a6
	CallSys	MakePictureA
	move.l	d0,d7
	beq	fail$
	bra	makepic$
noTrue$
	cmp	#0,IML_Type(A4)
	bne	ok$

	lea	mytags(A5),a2
	move.l	#GGFX_PixelFormat,(a2)+
	move.l	#PIXFMT_CHUNKY_CLUT,(a2)+

	move.l	IML_ColourMap(a4),d0	;Farbtabelle ?
	beq	no$
	move.l	d0,a1

	move.l	#GGFX_NumColors,(a2)+
	moveq	#0,d0
	move	(a1)+,d0
	move.l	d0,(a2)+
	move.l	#GGFX_Palette,(a2)+
	move.l	a1,(a2)+
no$
	move.l	#TAG_DONE,(A2)+
	lea	mytags(A5),a1

	move.l	IML_Data(A4),a0		;Array
	move	IML_Width(A4),d0	;Breite
	move	IML_Height(A4),d1	;Hhe

	move.l	guigfx(A5),a6
	CallSys	MakePictureA
	move.l	d0,d7
	beq	fail$
makepic$
	move.l	drawhandle(a5),a0	;drawhandle
	move.l	d7,a1			;picture
	lea	mytags(A5),a2		;tags
	move.l	#TAG_DONE,(a2)

	CallSys	CreatePictureBitMapA
	move.l	d0,IML_Rendered(a4)

	move.l	d7,a0
	CallSys	DeletePicture

	tst.l	IML_Rendered(a4)
	beq	fail$
ok$
	Pop	d1-a6
	moveq	#0,d0
	rts
fail$
	Pop	d1-a6
	moveq	#-1,d0
	rts

;----------------------- Pubscreen besorgen -----------------------------------
;Input:  -
;Output: D0 = 0->ok, sonst Fehler
LockPubScreen:
		Push	d1-a6
		bsr	UnlockPubScreen		;Screen freigeben

	ifne	Eagleplayer
		move.l	myEPBase(pc),d0		;Abfrage fr den Fall, da sich die Engine im Debug-Modus befindet,
						;normalerweise immer gesetzt
		beq.s	.noep
		move.l	d0,a0
		move.l	EPG_PubScreen(a0),d0
.noep
		move.l	d0,a0
	else
		suba.l	a0,a0
	endc

		IB
		CallSys	LockPubScreen		;aktuellen Publicscreen rauskriegen
		move.l	d0,mypubscreen(a5)	;fr UnLockpubscreen()
		beq	error$

		Pop	d1-a6	
		moveq	#0,d0
		rts
error$
		Pop	d1-a6	
		moveq	#-1,d0
		rts
;----------------------- Pubscreen freigeben -----------------------------------
;Input:  -
;Output: -
UnlockPubScreen:
		Push	All

		move.l	mypubscreen(a5),d0
		beq	none$

		IB

		move.l	d0,a1
		suba.l	a0,a0
		CallSys	UnlockPubScreen
		clr.l	mypubscreen(a5)
none$
		Pop	All
		rts
;------------------------------ FX Task starten ---------------------------------
	ifne	FXTask
InitFXTask:
		Push	all

		lea	mytags(A5),a0			;FX Proze starten
		move.l	a0,d1				;
		move.l	#NP_Entry,(a0)+			;
		move.l	#FXProcess,(a0)+		;
		move.l	#NP_Name,(A0)+			;
		move.l	#FXTask_Name,(A0)+		;
		move.l	#NP_Priority,(a0)+		;
		moveq	#-5,d0				;
		move.l	d0,(a0)+			;
		clr.l	(a0)				;
		DB
		CallSys	CreateNewProc			;
		tst.l	d0
		beq.s	fail$				;

		Pop	all
		moveq	#0,d0
		rts
fail$
		Pop	all
		moveq	#-1,d0
		rts
	endc
;------------------------------ FX Task beenden ---------------------------------
	ifne	FXTask
EndFXTask:
		Push	all
		st	FX_Quit(a5)

		lea	FXTask_Name(pc),a1		;Nachsehen, ob der FX Task noch da ist
		EB					;
		CallSys	FindTask			;
		tst.l	d0				;
		beq	ende$				;

		move.l	d0,a1
		EB
		moveq	#0,d0
		CallSys	SetTaskPri
wait$
		st	FX_Quit(a5)
		
		lea	FXTask_Name(pc),a1		;Nachsehen, ob der FX Task noch da ist
		EB					;
		CallSys	FindTask			;
		tst.l	d0				;
		beq	ende$				;

		moveq	#2,d1
		DB
		CallSys	Delay
		bra	wait$
ende$
		Pop	all				;
		rts					;
	endc
;------------------------ FX Task ---------------------------------------------
	ifne	FXTask
FXProcess:
		lea	Datas,a5
loop$
		tst.b	FX_Quit(a5)
;		moveq	#0,d0
;		move.l	#SIGBREAKF_CTRL_D,d1	;clear Signal after processing
;		EB
;		CallSys	SetSignal		;neue Kommandos ?
;		tst.l	d0
		bne	end$

		moveq	#1,d1
		DB
		CallSys	Delay

		tst.b	FX_Disable(a5)
		bne	disabled$
		st	FX_Enabled(a5)

	ifeq	Inttest
		bsr	myIntServer
	endc
		bra	loop$
disabled$
		sf	FX_Enabled(a5)
		bra	loop$
end$
		rts
	endc
;------------------------ FX Task enable --------------------------------------
EnableFXTask:
	ifne	FXTask
		Push	all
		lea	Datas,a5
		subq.b	#1,FX_Disable(a5)
		bgt	raus$
ena$
		sf	FX_Disable(a5)

		lea	FXTask_Name(pc),a1		;Nachsehen, ob der FX Task noch da ist
		EB					;
		CallSys	FindTask			;
		tst.l	d0				;
		beq	ende$				;

		move.l	d0,a1
		EB
		moveq	#0,d0
		CallSys	SetTaskPri
		move.l	d0,d7
wait$
		lea	FXTask_Name(pc),a1		;Nachsehen, ob der FX Task noch da ist
		EB					;
		CallSys	FindTask			;
		tst.l	d0				;
		beq	ende$				;
		
		tst.b	FX_Enabled(a5)
		bne	ende$
			
		moveq	#2,d1
		DB
		CallSys	Delay
		bra	wait$
ende$
		lea	FXTask_Name(pc),a1		;Nachsehen, ob der FX Task noch da ist
		EB					;
		CallSys	FindTask			;
		tst.l	d0				;
		beq	raus$				;

		move.l	d0,a1
		EB
		move.l	d7,d0
		CallSys	SetTaskPri
raus$
		Pop	all
		rts
	else
		rts
	endc
;------------------------ FX Task disable -------------------------------------
DisableFXTask:
	ifne	FXTask
		Push	all
		lea	Datas,a5
		addq.b	#1,FX_Disable(a5)

		lea	FXTask_Name(pc),a1		;Nachsehen, ob der FX Task noch da ist
		EB					;
		CallSys	FindTask			;
		tst.l	d0				;
		beq	ende$				;

		move.l	d0,a1
		EB
		moveq	#0,d0
		CallSys	SetTaskPri
		move.l	d0,d7
wait$
		lea	FXTask_Name(pc),a1		;Nachsehen, ob der FX Task noch da ist
		EB					;
		CallSys	FindTask			;
		tst.l	d0				;
		beq	ende$				;
		
		tst.b	FX_Enabled(a5)
		beq	ende$
			
		moveq	#2,d1
		DB
		CallSys	Delay
		bra	wait$
ende$
		lea	FXTask_Name(pc),a1		;Nachsehen, ob der FX Task noch da ist
		EB					;
		CallSys	FindTask			;
		tst.l	d0				;
		beq	raus$				;

		move.l	d0,a1
		EB
		move.l	d7,d0
		CallSys	SetTaskPri
raus$
		Pop	all
		rts
	else
		rts
	endc
;----------------------- Libs ffnen, etc. ------------------------------------
;Input:  -
;Output: D0 = 0->ok, sonst Error
Inits:	
	Push	d1-a6
	lea	Datas,a5

	lea	(a5),a0
	move.w	#datasize-1,d0
clrdatas$
	clr.b	(a0)+
	dbf	d0,clrdatas$

	move.l	#-1,ScrollSignal(a5)

	move.l	4.w,a6
	move.l	a6,Exec_base(a5)

;	EB
	lea	int_name,a1
	moveq	#39,d0
	CallSys	OpenLibrary
	move.l	d0,Int_base(a5)
	beq	error$

	lea	gfx_name,a1
	moveq	#39,d0
	CallSys	OpenLibrary
	move.l	d0,Gfx_base(a5)
	beq	error$

	lea	dos_name,a1
	moveq	#39,d0
	CallSys	OpenLibrary
	move.l	d0,Dos_base(a5)
	beq	error$

	lea	util_name,a1
	moveq	#39,d0
	CallSys	OpenLibrary
	move.l	d0,Util_base(a5)
	beq	error$

	lea	mathffp_s(pc),a1
	moveq	#33,d0
	jsr	_LVOopenlibrary(a6)
	move.l	d0,mathffp(a5)
	bne.s	okmathffp$
	lea	txt_nomathffp(pc),a0
	bsr	MERROR
	bra.s	error$
okmathffp$

	lea	mathtrans_s(pc),a1
	moveq	#33,d0
	jsr	_LVOopenlibrary(a6)
	move.l	d0,mathtrans(a5)
	bne.s	okmathtrans$
	lea	txt_nomathtrans(pc),a0
	bsr	MERROR
	bra	error$
okmathtrans$

	lea	guigfx_s(pc),a1
	moveq	#11,d0
	CallSys	OpenLibrary
	move.l	d0,guigfx(a5)
	bne	okggfx$
	lea	txt_noggfx(pc),a0
	bsr	MERROR
	bra	error$
okggfx$
	;---------------------- Menitems init ---------------------------------
	lea	SubItem1,a0
	move	mi_Flags(a0),d0
	and	#~CHECKED,d0
	move.l	Prefsflags(pc),d1
	and.l	#PFlag_PaletteMode,d1
	beq.s	nocheck1$
	or	#CHECKED,d0
nocheck1$
	move	d0,mi_Flags(a0)	

	;---------------------- Semaphore fr ShowImage ------------------------
	ifne	FXTask
	ifne	Semaphore
		lea	Image_Semaphore(a5),a0
		move.b	#NT_SIGNALSEM,LN_TYPE(a0)
		EB
		CallSys	InitSemaphore
	endc
	endc
	;---------------------- FX Task Init -----------------------------------
	ifne	FXTask
		bsr	InitFXTask
		bmi	error$
	endc

	Pop	d1-a6
	moveq	#0,d0
	rts
error$
	Pop	d1-a6
	moveq	#-1,d0
	rts

;--------------------------- Libs schlieen ---------------------------------------
;Input:  -
;Output: -
CloseLibs:
	Push	All
	lea	Datas,a5

	ifne	FXTask
		bsr	EndFXTask
	endc

	bsr	CloseWin		;Fenster sicherheitshalber nochmal zu schlieen versuchen

	EB

	move.l	Int_base(a5),d0
	beq.s	noint$
	move.l	d0,a1
	CallSys	CloseLibrary
	clr.l	Int_base(a5)
noint$

	move.l	Dos_base(a5),d0
	beq.s	nodos$
	move.l	d0,a1
	CallSys	CloseLibrary
	clr.l	Dos_base(a5)
nodos$

	move.l	guigfx(A5),d0
	beq	noggfx$
	move.l	d0,a1
	CallSys	CloseLibrary
noggfx$

	move.l	mathtrans(a5),d0
	beq	nomatht$
	move.l	d0,a1
	CallSys	CloseLibrary
	clr.l	mathtrans(a5)
nomatht$

	move.l	mathffp(a5),d0
	beq	nomathf$
	move.l	d0,a1
	CallSys	CloseLibrary
	clr.l	mathffp(a5)
nomathf$

	move.l	Gfx_base(a5),d0
	beq.s	nogfx$
	move.l	d0,a1
	CallSys	CloseLibrary
	clr.l	Gfx_base(a5)
nogfx$

	move.l	Util_base(a5),d0
	beq.s	noutil$
	move.l	d0,a1
	CallSys	CloseLibrary
	clr.l	Util_base(a5)
noutil$

	Pop	All
	rts

;------------------------------------------------------------------------------------
;--   Umwandlung kartesischer Koordinaten in Polarkoordinaten, MathLib Variante    --
;--       (c) 1997 Henryk Richter                                                  --
;------------------------------------------------------------------------------------
;Inputs:  D0 - X-Koordinate (Int)
;         D1 - Y-Koordinate (Int)
;         A5 - Basisregister
;Outputs: D0 - Radius (Int)
;         D1 - Winkel (FFP)
ToPolar:
	Push	d2-a6
	ext.l	d0
	ext.l	d1
	move.l	d0,d6		;x
	move.l	d1,d7		;y

	muls	d0,d0		;x
	muls	d1,d1		;y
	add.l	d1,d0		;x+y

	move.l	mathffp(a5),a6		
	jsr	_LVOSPFlt(A6)		;in FFP
	move.l	mathtrans(a5),a6
	jsr	_LVOSPSqrt(a6)		;Wurzel
	move.l	d0,d4			;Radius in Float
	move.l	mathffp(a5),a6		
	jsr	_LVOSPFix(A6)		;in Integer
	move.l	d0,d5			;Radius
	beq	ToPolar_1		;= 0 -> Phi = 0

	move.l	d7,d0			;y
	move.l	mathffp(a5),a6		
	jsr	_LVOSPFlt(a6)
;	move.l	d0,d1

	move.l	d4,d1			;Radius
	move.l	mathffp(a5),a6
	jsr	_LVOSPDiv(a6)		;R/y
	move.l	mathtrans(a5),a6		
	jsr	_LVOSPAsin(a6)		;phi = arcsin (R/Y)
	move.l	d0,d4			;Phi

	tst	d6			;x<0 ? (test if 2. and 3. quadrant)
	bgt.s	ToPolar_3

	move.l	d4,d0
	move.l	mathffp(a5),a6		
	jsr	_LVOSPNeg(A6)		;-phi

	move.l	#$C90FDB42,d1		;Pi in FFP
	move.l	mathffp(a5),a6		
	jsr	_LVOSPAdd(A6)
	move.l	d0,d4			;phi =  + phi (or  - phi for 2. quadrant with y > 0)
ToPolar_3:
	move.l	d4,d1
	move.l	mathffp(a5),a6		
	jsr	_LVOSPTst(a6)
	tst.l	d0			;phi < 0 ? (last step, case x<0 , y<0, 4. quadrant)
	bgt.s	ToPolar_2		

	move.l	#$C90FDB42,d1		;Pi in FFP
	move.l	d4,d0
	move.l	mathffp(a5),a6		
	jsr	_LVOSPAdd(A6)

	move.l	#$C90FDB42,d1		;Pi in FFP
	jsr	_LVOSPAdd(A6)
					;phi < 0 -> phi = 2* + phi
	move.l	d0,d4
ToPolar_2:
;	move.l	d4,d0
;	move.l	mathtrans(a5),a6
;	jsr	_LVOSPTieee(A6)
;	move.l	d0,aha1
;	fmove.s	aha1,fp0

	move.l	d4,d1			;Winkel (FFP)
	move.l	d5,d0			;Radius (LongInt)
	Pop	d2-a6
	rts

ToPolar_1:
	moveq	#0,d0			;Winkel 0
	move.l	mathffp(a5),a6		
	jsr	_LVOSPFlt(a6)		;in Float
	move.l	d0,d1

	move.l	d5,d0
	Pop	d2-a6
	rts

aha1	dc.l	0

;------------------------------------------------------------------------------------
;--       Umwandlung von Polarkoordinaten in kartesische Koordinaten (Math Libs)   --
;--       (c) 1997 Henryk Richter                                                  --
;------------------------------------------------------------------------------------
;Input:
;       D0 = radius (Int) oder RadiusX fr Ellipsen
;       D1 = angle (FFP)
;       D2 = RadiusY (Int) fr Ellipsen oder 0 fr Kreise
;       A5 = base register
;Output:
;       d0 = X-coordinate (int)
;       d1 = Y-coordinate (int)
ToKartesisch:
	Push	d2-a6

	tst.l	d2			;2.Radius ? (Ellipse)
	bne.s	ok$
	move.l	d0,d2
ok$
	move.l	d0,d6
	move.l	d1,d7

	
	move.l	d7,d0
	move.l	mathtrans(a5),a6
	jsr	_LVOSPSin(a6)
	move.l	d0,d4			;sin phi

	move.l	d2,d0			;RadiusY
	move.l	mathffp(a5),a6		
	jsr	_LVOSPFlt(a6)		;in Float

	move.l	d4,d1
	move.l	mathffp(a5),a6		
	jsr	_LVOSPMul(A6)		;R * sin phi = Y
	move.l	#$80000040,d1		;0.5 in Flt Format
	jsr	_LVOSPAdd(A6)
	jsr	_LVOSPFix(A6)
	move.l	d0,d5			;Y

	move.l	d7,d0
	move.l	mathtrans(a5),a6
	jsr	_LVOSPCos(a6)
	move.l	d0,d4			;cos phi

	move.l	d6,d0			;RadiusX
	move.l	mathffp(a5),a6		
	jsr	_LVOSPFlt(a6)		;in Float

	move.l	d4,d1
	move.l	mathffp(a5),a6
	jsr	_LVOSPMul(A6)		;R * cos phi = X
	move.l	#$80000040,d1		;0.5 in Flt Format
	jsr	_LVOSPAdd(A6)
	jsr	_LVOSPFix(A6)		;

	move.l	d5,d1
	Pop	d2-a6
	rts

;***********************************************************************************************
;********** selektiertes Gadget herausfinden und Testergebnis zurckgeben      *****************
;***********************************************************************************************
;Input: D0 - ID
TestActiveGadget:
		push	d1-a6
		move.l	WinHandle(a5),d1
		beq	notfound$
		move.l	d1,a0
		move.l	wd_FirstGadget(a0),d1
		beq	notfound$
nextgad$
		move.l	d1,a0
		cmp	gg_GadgetID(a0),d0
		beq	found$
		move.l	gg_NextGadget(a0),d1
		bne.s	nextgad$
notfound$
		pop	d1-a6
		moveq	#0,d0
		rts
found$
		move.w	gg_Flags(a0),d0
		and	#GFLG_SELECTED,d0
		beq	notfound$

		pop	d1-a6
		moveq	#1,d0
		rts
;***********************************************************************************************
;-----------------------------------------------------------------------------------------------
;-                                                                                             -
;- oberflchenspezifische Custom-Routinen wie Scopes, blinkende Anzeigen, Spezialgadgets usw.  -
;-                                                                                             -
;-----------------------------------------------------------------------------------------------
;***********************************************************************************************

;---------------------- Animation anzeigen ----------------------------------
;Inputs:
; D0 - ID der Liste der Images
; D1 - 0 = vorwrts
;      1 = rckwrts
; D2 - Delay in 1/50 s
;Output: -
ShowAnim:
		push	all
		bsr	DisableFXTask

		moveq	#0,d5
		move	d2,d5
		
		lea	Datas,a5

		bsr	FindObject		;Gadget Objekt in Liste finden
		beq	ok$
		tst	d1
		bne	backwards$
		
		move.l	d0,a2
		move.l	MOL_Images(a2),d0
		beq	ok$

		move.l	d0,a0			;1. Image: Normalzustand
loop$
		move.l	IML_Next(a0),d2
		beq	ok$			;kein nchstes Img

		move.l	d2,a0
		move	MOL_Left(a2),d0		;Xpos
		move	MOL_Top(a2),d1		;Ypos
		sub.l	a1,a1			;def. Rastport
		bsr	ShowImage

		push	all
		move.l	Dos_base(a5),a6
		move.l	d5,d1
		CallSys	Delay
		pop	all

		bra	loop$
backwards$
		move.l	d0,a2
		move.l	MOL_Images(a2),d0
		beq	ok$

		moveq	#-1,d3
count$
		addq	#1,d3
		move.l	d0,a0
		move.l	IML_Next(a0),d0
		bne	count$
loopR$
		bsr	getimage$

		move	MOL_Left(a2),d0		;Xpos
		move	MOL_Top(a2),d1		;Ypos
		sub.l	a1,a1			;def. Rastport
		bsr	ShowImage

		push	all
		move.l	Dos_base(a5),a6
		moveq	#1,d1
		CallSys	Delay
		pop	all

		dbf	d3,loopR$
		bra	ok$
getimage$
		move	d3,d1
		move.l	MOL_Images(a2),d0
seek$
		move.l	d0,a0
		move.l	IML_Next(a0),d0
		beq	none$
		dbf	d1,seek$
none$
		rts
ok$
		bsr	EnableFXTask
		pop	all
		rts

HandleCommandBarOn:
		move.l	Prefsflags(pc),d6
		or.l	#PFlag_CommandBar,d6
		move.l	d6,Prefsflags

		moveq	#1,d0
		bsr	HandleCommandBar2

		moveq	#ID_CommandBarAnim,d0
		moveq	#0,d1			;0=vorwrts; 1=rckwrts
		moveq	#4,d2
		bsr	ShowAnim

		rts

HandleCommandBarOff:
		move.l	Prefsflags(pc),d6
		and.l	#~PFlag_CommandBar,d6
		move.l	d6,Prefsflags

		moveq	#1,d0
		bsr	HandleCommandBar2

		moveq	#ID_CommandBarAnim,d0
		moveq	#1,d1			;0=vorwrts; 1=rckwrts
		moveq	#4,d2
		bsr	ShowAnim

		rts

;----------------------------------------------------------------------------------------------
;-------- je nach Prefs untere Klapplade ffnen/schlieen, Gagdets enable/disable -------------
;----------------------------------------------------------------------------------------------
HandleCommandBar:
		moveq	#0,d0
HandleCommandBar2:
		move.l	d0,d7
;		bsr	HandleToggles

		lea	CommandBarTab1,a4	;
		moveq	#0,d4			;aus = erstes Image der Animation

		move.l	Prefsflags(pc),d6
		and.l	#PFlag_CommandBar,d6
		beq	off$

		lea	CommandBarTab2,a4	;
		moveq	#1,d4			;an = letztes Image der Animation
off$
		;Gadgets off
disable$
		move	(a4)+,d0
		beq	end$

		bsr	Findgadget
		tst.l	d0
		beq	no2$

		move.l	d0,a0
		lea	MyTags(a5),a3
		move.l	#GA_Disabled,(a3)
		move.l	#1,4(A3)
		clr.l	8(A3)
		suba.l	a2,a2
		move.l	WinHandle(A5),a1
		IB
		jsr	_LVOSetGadgetAttrsa(A6)
no2$
		bra	disable$
end$
		;korrekte Grafik
		tst.l	d7
		bne	nogfx$

		moveq	#ID_CommandBarAnim,d0
		bsr	FindObject
		beq	error$
		move.l	d0,a1
		move.l	MOL_Images(a1),d0
		beq	error$
		move.l	d0,a0
		
		tst.l	d4
		beq	first$
loop$
		move.l	(a0),d0
		beq	first$
		move.l	d0,a0
		bra	loop$
first$
		move	MOL_Left(a1),d0		;Xpos
		move	MOL_Top(a1),d1		;Ypos
		sub.l	a1,a1			;def. Rastport
		bsr	ShowImage
nogfx$

		;Gadgets on
loop1$
		move	(a4)+,d0
		beq	end2$

		bsr	Findgadget
		tst.l	d0
		beq	no1$

		move.l	d0,a0
		lea	MyTags(a5),a3
		move.l	#GA_Disabled,(a3)
		move.l	#0,4(A3)
		clr.l	8(A3)
		suba.l	a2,a2
		move.l	WinHandle(A5),a1
		IB
		jsr	_LVOSetGadgetAttrsa(A6)
no1$
		bra	loop1$
end2$

error$
		rts
;----------------------------------------------------------------------------------------------
;-------------------- nchste/vorherige Position --------------- ------------------------------
;----------------------------------------------------------------------------------------------
HandleNextPattern:
HandlePrevPattern:
		Push	d4-a6

		Push	All
		bsr	PatternDisp
		Pop	All

		move.w	#-10,PattTime(a5)

		move.l	MOL_Command(a0),d0
		moveq	#0,d1
		move.l	MOL_CMDArg1(a0),d2
		move.l	MOL_CMDArg2(a0),d3

		Pop	d4-a6
		rts
;----------------------------------------------------------------------------------------------
;-------------------- Schublade ffnen und EPNR_LoadModule an EP ------------------------------
;----------------------------------------------------------------------------------------------
HandleLoadModule:
		bsr	OpenTray

		moveq	#EPNr_LoadModule,d0
		moveq	#0,d1
		moveq	#0,d2
		moveq	#0,d3
		rts
;----------------------------------------------------------------------------------------------
;------------------------------- Schublade ffnen ---------------------------------------------
;----------------------------------------------------------------------------------------------
OpenTray:
		push	all
		lea	Datas,a5
		tst.b	TrayOpen(a5)
		bne	ok$
		st	TrayOpen(a5)

		moveq	#ID_TrayAnim,d0
		moveq	#0,d1
		moveq	#1,d2
		bsr	ShowAnim
ok$
		pop	all
		rts
;----------------------------------------------------------------------------------------------
;------------------------------- Schublade schlieen ------------------------------------------
;----------------------------------------------------------------------------------------------
CloseTray:
		push	all
		lea	Datas,a5
		tst.b	TrayOpen(a5)
		beq	ok$
		sf	TrayOpen(a5)

		moveq	#ID_TrayAnim,d0
		moveq	#1,d1
		moveq	#1,d2
		bsr	ShowAnim
ok$
		pop	all
		rts
;-------------------------------- Spektrum Analyzer Poweron/off -----------------------------
; Inputs: a0 = Objekt, a1=Kopie der Intuimsg
HandleAnalyzerPower:
		bsr	HandleToggles

		bsr	UpdateAnalyzerPrefs

		bsr	LitAnalyzer
		move.l	#myNR_ToggleFlag,d0
		rts
LitAnalyzer:
		push	all
		lea	Datas,a5
		
		move.l	#ID_AnalyzerLit,d0	
		bsr	FindObject		;Gadget Objekt in Liste finden
		beq	nextob5$
		move.l	d0,a0
		move.l	MOL_Images(a0),d2
		beq	nextob5$
		move	MOL_Left(a0),d0		;Xpos
		move	MOL_Top(a0),d1		;Ypos
		move.l	d2,a0			;Image
		move.l	IML_Next(a0),d2		;2. Image
		beq	egal3$
		move.l	Prefsflags(pc),d6
		and.l	#PFlag_AnalyzerPower,d6
		beq	egal3$
		move.l	d2,a0
egal3$		sub.l	a1,a1			;def. Rastport
		bsr	ShowImage
nextob5$
		pop	all
		rts
;-------------------------------- Schalter des Spektrum Analyzers -----------------------------
; Inputs: a0 = Objekt, a1=Kopie der Intuimsg
HandleAnalyzerSwitches:
		move.l	MOL_CMDArg1(a0),d0

		move.l	Prefsflags(pc),d1
		and.l	#~PFlags_Analyzer,d1
		or.l	d0,d1
		move.l	d1,Prefsflags
		
		bsr	UpdateAnalyzerPrefs

		move.l	#myNR_ToggleFlag,d0
		rts
UpdateAnalyzerPrefs:
		push	all
		lea	datas,a5
		move.l	Prefsflags(pc),d6
		and.l	#PFlag_AnalyzerPower,d6
		
		lea	AnalyzerPrefstab(pc),a0

		move.l	Prefsflags(pc),d0
		and.l	#PFlags_Analyzer,d0
		beq	default$
		
		lea	-APT_Length(a0),a0
next$
		lea	APT_Length(a0),a0
		move.l	(a0),d1
		and.l	d0,d1
		beq.s	next$
default$
		lea	4(a0),a3		;Switches

		moveq	#0,d0
		move	(a3)+,d0	
		bsr	FindObject		;Gadget Objekt in Liste finden
		beq	nextob3$
		move.l	d0,a0
		move.l	MOL_Images(a0),d2
		beq	nextob3$
		move	MOL_Left(a0),d0		;Xpos
		move	MOL_Top(a0),d1		;Ypos
		move.l	d2,a0			;Image
		move.l	IML_Next(a0),d2		;2. Image
		beq	egal$
		move.l	d2,a0
egal$		sub.l	a1,a1			;def. Rastport
		bsr	ShowImage
nextob3$
		moveq	#3-1,d7
switches$
		moveq	#0,d0
		move	(a3)+,d0	
		bsr	FindObject		;Gadget Objekt in Liste finden
		beq	nextob$
		move.l	d0,a0
		move.l	MOL_Images(a0),d2
		beq	nextob$
		move	MOL_Left(a0),d0		;Xpos
		move	MOL_Top(a0),d1		;Ypos
		move.l	d2,a0			;Image
		sub.l	a1,a1			;def. Rastport
		bsr	ShowImage
nextob$
		dbf	d7,switches$

		moveq	#0,d0
		move	(a3)+,d0	
		bsr	FindObject		;Gadget Objekt in Liste finden
		beq	nextob4$
		move.l	d0,a0
		move.l	MOL_Images(a0),d2
		beq	nextob4$
		move	MOL_Left(a0),d0		;Xpos
		move	MOL_Top(a0),d1		;Ypos
		move.l	d2,a0			;Image
		move.l	IML_Next(a0),d2		;2. Image
		beq	egal2$
		tst.l	d6
		beq	egal2$
		move.l	d2,a0
egal2$		sub.l	a1,a1			;def. Rastport
		bsr	ShowImage
nextob4$
		moveq	#3-1,d7
led$
		moveq	#0,d0
		move	(a3)+,d0	
		bsr	FindObject		;Gadget Objekt in Liste finden
		beq	nextob2$
		move.l	d0,a0
		move.l	MOL_Images(a0),d2
		beq	nextob2$
		move	MOL_Left(a0),d0		;Xpos
		move	MOL_Top(a0),d1		;Ypos
		move.l	d2,a0			;Image
		sub.l	a1,a1			;def. Rastport
		bsr	ShowImage
nextob2$
		dbf	d7,led$

		move.l	(a3)+,FFT_CurrentMode(a5)

		move.l	#ID_AnalyzerPLED,d0	
		bsr	FindObject		;Gadget Objekt in Liste finden
		beq	nextob5$
		move.l	d0,a0
		move.l	MOL_Images(a0),d2
		beq	nextob5$
		move	MOL_Left(a0),d0		;Xpos
		move	MOL_Top(a0),d1		;Ypos
		move.l	d2,a0			;Image
		move.l	IML_Next(a0),d2		;2. Image
		beq	egal3$
		tst.l	d6
		beq	egal3$
		move.l	d2,a0
egal3$		sub.l	a1,a1			;def. Rastport
		bsr	ShowImage
nextob5$

		pop	all
		move.l	#myNR_ToggleFlag,d0
		rts
;-------------------------------- Dirlistviewer show/hide -------------------------------------
HandleDLViewer:
		lea	DLViewername(pc),a0
		bra	SetEngine

;------------------------------- Manager show/hide ----------------------------------------
HandleManager:
		lea	Managername(pc),a0
		bra	SetEngine

;----------------------------- Amplifiermanager show/hide ----------------------------------
HandleAmpManager:
		lea	AmpManagername(pc),a0
		bra	SetEngine
HandleModuleinfo:
		lea	Moduleinfoname(pc),a0
		bra	SetEngine
HandleFormatloader:
		lea	Formatloadername(pc),a0
		bra	SetEngine

;----------------------- angegebene Engine an/aus ----------------------------------------
SetEngine:
	ifne	Eagleplayer
		
		*-- a0=Enginename
.SetEngine:	move.l	EUS_Structure+EUS_EPBase(pc),a4
		lea	EPG_FirstUserStruct(a4),a3
.NextEngine:	move.l	(a3),d0
		beq.s	.LoadIt
		move.l	d0,a3
		move.l	UPrgS_Name(a3),a1
		jsr	ENPP_StringCmp(a4)
		beq.s	.Enable
		bra.s	.NextEngine

.Enable:	moveq	#EPNr_Engine,d0
		move.l	UPrgS_EngineNr(a3),d2
		moveq	#-1,d3
		bra.s	.rts

.LoadIt:	move.l	a0,a2
		jsr	ENPP_CalcStringSize(a4)
		move.l	d0,d2
		moveq	#0,d3
		moveq	#EPNr_LoadEngine,d0
.rts		rts
	else
		moveq	#0,d0
		rts
	endc

;---------------------------- Aktiven Amplifier show/hide -------------------------------------
HandleActiveAmplifier:
	ifne 	Eagleplayer
		move.l	#EPNR_HelpLink,d0
		move.l	#EPNr_FirstEngine,d2
		lea	Help_ActiveAmplifier(pc),a0
		move.l	a0,d3
		move.l	EUS_Structure+EUS_EPBase(pc),a0
		move.l	EPG_SomePrefs(a0),d1
		btst	#EGPRF_Help,d1
		bne.w	rts$

		move.l	EUS_Structure+EUS_EPBase(pc),a0
		move.l	EPG_ActiveAmplifier(a0),d0
		beq.w	fail$
		move.l	d0,a0
		moveq	#0,d2
		move.w	EUS_UserNr(a0),d2
		beq.w	fail$
		moveq	#-1,d3
		move.l	#EPNr_EngineShowState,d0
rts$
		rts
	endc
fail$
		move.l	#EPNr_LastExternal,d0
		rts
;----------------------------------------------------------------------------------------------
;---------------------------------- Speedregler -----------------------------------------------
;----------------------------------------------------------------------------------------------
HandleSpeed:
		bsr	HandleMoused

		move.l	MOL_UserData(a0),d0
		beq.w	noregler$			;sollte nicht passieren
		move.l	d0,a2				;REG_Struktur
		tst	REG_Enable(a2)
		bne	noregler$

		move	REG_Maxvalue(a2),d3
		lsr	#1,d3
		move	d3,REG_Value(a2)
noregler$

		moveq	#ID_Speed,d0
		moveq	#ID_Speedanim,d1
		moveq	#ID_Speedknob,d2
		bsr	ShowSpeed
		
		moveq	#ID_Speed,d0
		bsr	FindObject
		beq	error$
		move.l	d0,a0
		move.l	MOL_UserData(a0),d0
		beq	error$
		move.l	d0,a1

		move.l	#EPNr_Speed,d0
		moveq	#0,d1
		moveq	#0,d2
		move	REG_Value(a1),d2
		move	REG_Maxvalue(a1),d3
		lsr	#1,d3
		sub	d3,d2
		moveq	#0,d3
error$
		rts
NewSpeed:
		push	all
		moveq	#ID_Speed,d0
		bsr	TestActiveGadget
		bne	error$

		moveq	#ID_Speed,d0
		bsr	FindObject
		beq	error$
		move.l	d0,a0
		move.l	MOL_UserData(a0),d0
		beq	error$
		move.l	d0,a0

	ifne	Eagleplayer
		move.l	myEPBase(pc),a1
		move.w	EPG_Speed(a1),d1
		add	#25,d1
	else
		moveq	#20,d1
	endc
		move.w	d1,REG_Value(a0)

		moveq	#ID_Speed,d0
		moveq	#ID_Speedanim,d1
		moveq	#ID_Speedknob,d2
		bsr	ShowSpeed
error$
		pop	all
		rts


ShowSpeed:
		push	all
		move.l	d1,d6
		move.l	d2,d7

		bsr	FindObject
		beq	error$
		move.l	d0,a0
		move.l	MOL_UserData(a0),d0
		beq	error$
		move.l	d0,a1		;REG_ Struktur

		move.l	d6,d0
		beq	nobody$

		bsr	FindObject
		beq	error$
		move.l	d0,a2
		move.l	MOL_Images(a2),d0
		beq	error$
		move.l	d0,a3			;1. Image von zweien

		move.w	REG_Value(a1),d0	;Abfrage, welches zu verwenden ist
		and.l	#2,d0
		beq.s	first$
		move.l	IML_Next(a3),d0
		beq	first$
		move.l	d0,a3
first$
		move	MOL_Left(a2),d0		;Xpos
		move	MOL_Top(a2),d1		;Ypos
		push	a0/a1
		move.l	a3,a0			;Image
		sub.l	a1,a1			;def. Rastport
		bsr	ShowImage
		pop	a0/a1
nobody$
		move.w	REG_Value(a1),d3	;aktueller Wert
		
		move	REG_Maxradius(a1),d1
		sub	REG_Minradius(a1),d1		;max. Breite des Reglerbereiches
		muls	d1,d3

		move	REG_Maxvalue(a1),d1
		sub	REG_Minvalue(a1),d1		;max. Anzahl Schritte

		divs	d1,d3

		add	REG_MinRadius(a1),d3
		
		move.l	d7,d0
		bsr	FindObject
		beq	error$
		move.l	d0,a0
		add	MOL_Left(a0),d3
		move	MOL_Top(a0),d1

		move.l	MOL_Images(a0),d0
		beq	error$
		move.l	d0,a0

		move	d3,d0
		sub.l	a1,a1			;def. Rastport
		bsr	ShowImage
error$
		pop	all
		rts
;----------------------------------------------------------------------------------------------
;-------------------------------- Volumeregler im Remote-Modus --------------------------------
;----------------------------------------------------------------------------------------------
;HandleRemoteVolume:
;		clr.b	MuteID(A5)
;
;		bsr	HandleMoused
;
;;		bsr	ShowRemoteVolume
;		
;		moveq	#ID_RVolume,d0
;		bsr	FindObject
;		beq	error$
;		move.l	d0,a0
;		move.l	MOL_UserData(a0),d0
;		beq	error$
;		move.l	d0,a1
;
;		move.l	#EPNr_Volume,d0
;		moveq	#0,d1
;		moveq	#0,d2
;		move	REG_Value(a1),d2
;		lsl	#2,d2			;wg. 0...255
;		cmp	#255,d2
;		bls.s	Vol0$
;		move	#255,d2
;Vol0$
;		moveq	#0,d3
;error$
;		rts

;Input: Globals verwendet
;ShowRemoteVolume:
;		push	d1-a6
;		moveq	#ID_VolumeTMP,d0
;		bsr	FindObject
;		beq	error$
;		move.l	d0,a0
;		move.l	MOL_Images(a0),d0
;		beq	error$
;		move.l	d0,a0
;		move.l	IML_Rendered(a0),d0
;		beq	error$
;		move.l	d0,TempRastport4+rp_BitMap(a5)
;
;		moveq	#ID_RVolume,d0
;		moveq	#ID_Volumeanim,d1
;		move.l	d1,d6
;		move.l	d2,d7
;
;		bsr	FindObject
;		beq	error$
;		move.l	d0,a0
;		move.l	MOL_UserData(a0),d0
;		beq	error$
;		move.l	d0,a1
;
;		move.l	d6,d0
;		beq	nobody$
;
;		bsr	FindObject
;		beq	error$
;		move.l	d0,a2
;		move.l	MOL_Images(a2),d0
;		beq	error$
;		move.l	d0,a3			;1. Image von zweien
;
;		move.w	REG_Value(a1),d0	;Abfrage, welches zu verwenden ist
;		and.l	#2,d0
;		beq.s	first$
;		move.l	IML_Next(a3),d0
;		beq	first$
;		move.l	d0,a3
;first$
;		moveq	#0,d0
;		moveq	#0,d1
;		push	a0/a1
;		move.l	a3,a0			;Image
;		lea	TempRastport4(A5),a1	;def. Rastport
;		bsr	ShowImage
;		pop	a0/a1
;nobody$
;		move.w	REG_Value(a1),d0	;aktueller Wert
;		lea	RemoteColouredPixels,a3
;		move	(a3)+,d1		;Anzahl ber alles
;		move	(a3,d0.w*2),d0		;wieviele Pixels hell zeichnen ?
;		lea	RemotePixelCoords,a3
;		lea	TempRastport4(A5),a4	;def. Rastport
;		tst	d0
;		beq.s	zero$
;
;		subq	#1,d0
;
;		lea	Colourmap(A5),a0
;		move	22(a0),d2
;draw1$
;		bsr	draw$
;		subq	#1,d1
;		dbf	d0,draw1$
;zero$
;		subq	#1,d1
;		bmi.s	ready$
;
;		lea	Colourmap(A5),a0
;		move	20(a0),d2
;draw2$
;		bsr	draw$
;		dbf	d1,draw2$
;
;		moveq	#ID_VolumeTMP,d0
;		bsr	FindObject
;		beq	error$
;		move.l	d0,a0
;		move	MOL_Left(a0),d0		;Xpos
;		move	MOL_Top(a0),d1		;Ypos
;		move.l	MOL_Images(a0),a0
;		suba.l	a1,a1
;		bsr	ShowImage
;ready$
;		pop	d1-a6
;		rts
;----------------------- Pixel in Rastport einzeichnen ------------------
;Inputs: a3 - Koordinatentabelle
;        a4 - Rastport
;        d2 - Farbe
;draw$
;		push	d0-a2/a4-a6
;		move.l	a4,a1
;
;		move	d2,d0
;		GB
;		jsr	_LVOSetAPen(A6)
;
;		move.l	a4,a1
;		move	(a3)+,d0		;x
;		move	(a3)+,d1		;y
;		GB
;		jsr	_LVOWritePixel(A6)		
;		pop	d0-a2/a4-a6
;		rts
;
;error$
;		pop	d1-a6
;		rts
;
;----------------------------------------------------------------------------------------------
;-------------------------- Lautstrkeknopf bei Muting blinken lassen -------------------------
;----------------------------------------------------------------------------------------------
HandleMuting:
		tst.b	MuteID(A5)
		beq.w	end$

		moveq	#ID_Volumeknob,d2
		move.b	MuteTMP(a5),d0
		eor.b	#1,d0
		move.b	d0,MuteTMP(a5)
		beq.s	number1$

		moveq	#ID_Volumeknob2,d2
number1$
		moveq	#ID_Volume,d0
		moveq	#0,d1
		bsr	ShowVolume
end$
		rts

;----------------------------------------------------------------------------------------------
;--------------------------------Muting an/aus ------------------------------------------------
;----------------------------------------------------------------------------------------------
;Input:  a1 - Kopie der IntuiMsg
;Output: D0 - EPNr oder 0
;        D1 - Flags zu der EPNr
;        D2 - Argumente1 zu der EPNr
;        D3 - Argumente2 zu der EPNr
HandleMute:
		move.b	MuteID(A5),d0
		eor.b	#1,d0
		move.b	d0,MuteID(A5)

		bra	MuteVolume

;----------------------------------------------------------------------------------------------
;-------------------------------- Balanceregler -----------------------------------------------
;----------------------------------------------------------------------------------------------
;Input:  a1 - Kopie der IntuiMsg
;Output: D0 - EPNr oder 0
;        D1 - Flags zu der EPNr
;        D2 - Argumente1 zu der EPNr
;        D3 - Argumente2 zu der EPNr
HandleBalance:
		bsr	HandleMoused
		moveq	#ID_Balance,d0
		moveq	#ID_Balanceanim,d1
		moveq	#ID_Balanceknob,d2
		bsr	ShowVolume
		
		moveq	#ID_Balance,d0
		bsr	FindObject
		beq	error$
		move.l	d0,a0
		move.l	MOL_UserData(a0),d0
		beq	error$
		move.l	d0,a1

		move.l	#EPNr_Balance,d0
		moveq	#0,d1
		moveq	#0,d2
		move	REG_Value(a1),d2
		move	REG_Maxvalue(a1),d3
		lsr	#1,d3
		sub	d3,d2			;nun -32...32
		lsl	#3,d2			;wg. -255...255

		cmp	#EP_MaxVolume,d2
		ble.s	no1$
		move	#EP_MaxVolume,d2
no1$
		cmp	#-EP_MaxVolume,d2	;fix fr Bereichsangabe bei Balance
		bge.s	no$
		move	#-EP_MaxVolume,d2
no$
		ext.l	d2
		
		moveq	#0,d3
error$
		rts
NewBalance:
		push	all
		moveq	#ID_Balance,d0
		bsr	TestActiveGadget
		bne	error$

		moveq	#ID_Balance,d0
		bsr	FindObject
		beq	error$
		move.l	d0,a0
		move.l	MOL_UserData(a0),d0
		beq	error$
		move.l	d0,a0

	ifne	Eagleplayer
		move.l	myEPBase(pc),a1
		move.w	EPG_Balance(a1),d1
		add	#255,d1
		lsr.w	#3,d1
	else
		moveq	#20,d1
	endc
		move.w	d1,REG_Value(a0)

		moveq	#ID_Balance,d0
		moveq	#ID_Balanceanim,d1
		moveq	#ID_Balanceknob,d2
		bsr	ShowVolume
error$
		pop	all
		rts

;----------------------------------------------------------------------------------------------
;-------------------------------- Volume/Balanceregler anzeigen -------------------------------
;----------------------------------------------------------------------------------------------
;Input:
; D0 - ID fr Basisobjekt (Gadget)
; D1 - ID fr Hintergrundimages (2) oder 0, wenn Neuzeichnen nicht erwnscht
; D2 - ID fr Knopfimage (1)
ShowVolume:
		push	d1-a6

		move.l	d1,d6
		move.l	d2,d7

		bsr	FindObject
		beq	error$
		move.l	d0,a0
		move.l	MOL_UserData(a0),d0
		beq	error$
		move.l	d0,a1

		move.l	d6,d0
		beq	nobody$

		bsr	FindObject
		beq	error$
		move.l	d0,a2
		move.l	MOL_Images(a2),d0
		beq	error$
		move.l	d0,a3			;1. Image von zweien

		move.w	REG_Value(a1),d0	;Abfrage, welches zu verwenden ist
		and.l	#2,d0
		beq.s	first$
		move.l	IML_Next(a3),d0
		beq	first$
		move.l	d0,a3
first$
		move	MOL_Left(a2),d0		;Xpos
		move	MOL_Top(a2),d1		;Ypos
		push	a0/a1
		move.l	a3,a0			;Image
		suba.l	a1,a1			;def. Rastport
		bsr	ShowImage
		pop	a0/a1
nobody$
		move.l	a1,a4

		move.w	REG_Value(a4),d0	;aktueller Wert
		ext.l	d0
		move.l	mathffp(a5),a6		
		jsr	_LVOSPFlt(A6)			;in FFP
		move.l	d0,d6

		move.w	REG_PhiTotal(a4),d0
		ext.l	d0
		move.l	mathffp(a5),a6		
		jsr	_LVOSPFlt(A6)			;in FFP

		move.l	#$8efa353b,d1			;*/180, Umrechnung in Bogenma
		move.l	mathffp(a5),a6
		jsr	_LVOSPMul(a6)
		move.l	d0,d1			;*/180, Umrechnung in Bogenma

		move.l	d6,d0
		move.l	mathffp(a5),a6
		jsr	_LVOSPMul(a6)		;Wert*ffnungswinkel
		move.l	d0,d6

		move.w	REG_Maxvalue(a4),d0
		sub.w	REG_Minvalue(a4),d0	;Anzahl der Stufen aus Max-Min
		ext.l	d0
		move.l	mathffp(a5),a6		
		jsr	_LVOSPFlt(A6)		;in FFP
		move.l	d0,d1

		move.l	d6,d0
		jsr	_LVOSPDiv(A6)		;Wert*ffnungswinkel / Anzahl der Stufen
		move.l	d0,d6

		move	REG_PhiMin(a4),d0
		ext.l	d0
		move.l	mathffp(a5),a6		
		jsr	_LVOSPFlt(A6)		;in FFP
		move.l	#$8efa353b,d1		;*/180, Umrechnung in Bogenma
		move.l	mathffp(a5),a6		
		jsr	_LVOSPMul(a6)

		move.l	d6,d1
		jsr	_LVOSPSub(a6)		;phi0 - Drehwinkel
		move.l	d0,d1

		move	REG_KnobRadiusA(a4),d0
		ext.l	d0
		move	REG_KnobRadiusB(a4),d2
		ext.l	d2
		bsr	ToKartesisch

		move.w	d0,d2
		add	REG_XCenter(a4),d2
		move	d1,d0
		move.w	REG_YCenter(a4),d1	;Ypos
		sub	d0,d1

		move.l	d7,d0
		bsr	FindObject
		beq	error$
		move.l	d0,a0
		move.l	MOL_Images(a0),d0
		beq	error$
		move.l	d0,a0

		move	d2,d0			;Xpos
		suba.l	a1,a1			;def. Rastport
		bsr	ShowImage
error$
		pop	d1-a6
		rts

;----------------------------------------------------------------------------------------------
;-------------------------------- Volumeregler ------------------------------------------------
;----------------------------------------------------------------------------------------------
;Input:  a1 - Kopie der IntuiMsg
;Output: D0 - EPNr oder 0
;        D1 - Flags zu der EPNr
;        D2 - Argumente1 zu der EPNr
;        D3 - Argumente2 zu der EPNr
HandleVolume:
		bsr	HandleMoused
MuteVolume:
		moveq	#ID_Volume,d0
		moveq	#ID_Volumeanim,d1

		moveq	#ID_Volumeknob2,d2
		tst.b	MuteID(a5)
		bne.s	mute$
		moveq	#ID_Volumeknob,d2
mute$
		bsr	ShowVolume
		
		moveq	#ID_Volume,d0
		bsr	FindObject
		beq	error$
		move.l	d0,a0
		move.l	MOL_UserData(a0),d0
		beq	error$
		move.l	d0,a1

		move.l	#EPNr_Volume,d0
		moveq	#0,d1
		moveq	#0,d2

		tst.b	MuteID(a5)
		bne.s	Vol0$
		move	REG_Value(a1),d2
		lsl	#2,d2			;wg. 0...255
		cmp	#255,d2
		bls.s	Vol0$
		move	#255,d2
Vol0$
		moveq	#0,d3
error$
		rts

;------------------------ Prefs-Update fr Lautstrke ---------------------------------
NewVolume:
		push	all
;		moveq	#ID_RVolume,d0		;Remote
;		bsr	FindObject
;		beq	noremote$
;		move.l	d0,a0
;
;		moveq	#ID_RVolume,d0
;		bsr	TestActiveGadget
;		bne	error$
;
;		move.l	MOL_UserData(a0),d0
;		beq	error$
;		move.l	d0,a0
;
;	ifne	Eagleplayer
;		move.l	myEPBase(pc),a1
;		move.w	dtg_SndVol(a1),d1
;;		move.w	EPG_Volume(a1),d1
;	else
;		moveq	#20,d1
;	endc
;		move.w	d1,REG_Value(a0)
;
;		bsr	ShowRemoteVolume
;		bra	error$
noremote$
		moveq	#ID_Volume,d0
		bsr	TestActiveGadget
		bne	error$

		moveq	#ID_Volume,d0		;Normal
		bsr	FindObject
		beq	error$
		move.l	d0,a0
		move.l	MOL_UserData(a0),d0
		beq	error$
		move.l	d0,a0

	ifne	Eagleplayer
		move.l	myEPBase(pc),a1
;		move.w	EPG_Volume(a1),d1
		move.w	dtg_SndVol(a1),d1
	else
		moveq	#20,d1
	endc
		tst.b	MuteID(A5)		;Abfrage, ob Muting an ist, wenn
						;ja und bergebene Lautstrke = 0,
						;dann Regler nicht ndern
		beq.s	setvol$
		tst.w	d1
		beq.s	novol$
setvol$
		move.w	d1,REG_Value(a0)
novol$
		moveq	#ID_Volume,d0
		moveq	#ID_Volumeanim,d1

		moveq	#ID_Volumeknob,d2
		tst.b	MuteID(a5)
		beq.s	this$
		tst.b	MuteTMP(a5)
		beq.s	this$
		moveq	#ID_Volumeknob2,d2
this$
		bsr	ShowVolume
error$
		pop	all
		rts
*-----------------------------------------------------------------------------*
* Input: d0=Tag
*	 d0=Ergebnis
*-----------------------------------------------------------------------------*
FindPlTag:	Push	d1-a6			;Suche Tag im aktuellen Player
	ifne	Eagleplayer
		move.l	EUS_Structure+EUS_EPBase(pc),a6
		move.l	EPG_PlayerTagList(a6),d2
		beq	notfound$
		move.l	d2,a6
		bsr	FindTag
		move.l	a6,d0
	else	
		moveq	#0,d0
	endc
		Pop	d1-a6
		tst.l	d0
		rts
notfound$
		Pop	d1-a6
		moveq	#0,d0
		rts

FindMITag:	Push	d1-a6			;Suche Tag im aktuellen Moduleinfo
	ifne	Eagleplayer
		move.l	EUS_Structure+EUS_EPBase(pc),a6
		move.l	EPG_ModuleInfoTagList(a6),d2
		beq	notfound$
		move.l	d2,a6
		bsr	FindTag
		move.l	a6,d0
	else
		moveq	#10,d0
	endc
		Pop	d1-a6
		tst.l	d0
		rts
notfound$
		Pop	d1-a6
		moveq	#0,d0
		rts
FindTag:
FindTag2:	move.l	d3,-(a7)
		move.l	a7,d3

	*--------- Rekursive FindTag-Routine aus Eagleplayer Sourcecode ----------*
FindTag3:	moveq	#0,d2
		cmp.l	a6,d2
		beq.s	.Empty
		move.l	(a6)+,d2			;Tag rauslesen
		bne.s	.NoEmpty
.Empty:		cmp.l	d3,a7				;ak. Stack vergleichen
		beq.s	.TagNoFound
		move.l	(a7)+,a6
		bra.b	.NoMore
.NoEmpty:	cmp.l	d2,d0
		beq.s	.TagFound

	*----- Tag-Skip gefunden ???? -----*
		cmp.l	#TAG_SKIP,d2
		bne.s	.NoSkip
		addq.l	#8,a6				;Diesen und nchsten
		addq.l	#4,a6				;Tag berspringen
		bra.s	.NoMore

	*------ Tag-More gefunden ???? -----*
.NoSkip:	cmp.l	#TAG_MORE,d2
		bne.s	.NoMore

		move.l	a6,-(a7)		;Adr der Tagliste sichern
		move.l	(a6),a6			;Neue Tagliste setzen
		bra.b	FindTag3
.NoMore:	addq.l	#4,a6
		bra.s	FindTag3
.TagFound:	move.l	(a6),a6
		move.l	a6,d2
.TagNoFound:	move.l	d3,a7
		move.l	(a7)+,d3
		tst.l	d2
		bne.s	.NoNull
		sub.l	a6,a6
.NoNull:	tst.l	d2
		rts

;****************************************************************************************
;*     LED Zeile fr Aussteuerungsanzeige, Abwicklung ber Eagleplayer UPS Struktur     *
;****************************************************************************************
;Achtung: in dieser Routine wird momentan angenommen, dass beide LED Zeilen um 2 Punkte
;         in der Vertikalen versetzt liegen, falls dies nicht erwnscht ist, bitte Objekt
;         fr 2. Zeile anlegen...
;---------------------- Input: A0 - Pointer auf Objekt ----------------------------------
DoLevelmeter:
	ifne	Eagleplayer
		move.l	myEPBase(pc),a1
		move.l	EPG_SomePrefs(a1),d6
		btst	#EGPRF_NowPlay,d6
		beq	error$

;		move.l	EPG_UPS_Structure(a1),d0	;spielt ein Modul ?
;		beq	error$				;nein, Fehler
;		move.l	d0,a4
;		move.l	d0,AN_StructAdr(a5)

		move.l	AN_StructAdr(a5),d0
		beq	error$
		move.l	d0,a4

		moveq	#-1,d2			;Alle Kanle, wenn DMAon/off nicht unterstzt vom
						;Replay
		move.w	UPS_Flags(a4),d1
		and.w	#UPSB_DMACon,d1		;Kanle an/aus untersttzt ?
		beq.s	nodmacon$
		move.w	UPS_DMACon(a4),d2	;Ja,zugehrige Werte ranholen

			;Bitabfolge ndern wegen anderer Abfragereihenfolge der Kanle in dieser
			;Engine (Stimmen 1,4,2,3 wg. 1&4 = links, 2&3=rechts)
		move	d2,d0
		move	d2,d1
		and	#1,d2		;Bit 0 -> Bit 0

		lsr	#2,d0
		and	#2,d0
		or	d0,d2		;Bit 3 -> Bit 1

		and	#%0110,d1
		lsl	#1,d1
		or	d1,d2		;(Bit 1 und 2) << 1
nodmacon$

		lea	vol64(pc),a2		;fr den Fall, da "Mastervolume" ausgeschaltet

		move.l	EPG_SomePrefs(a1),d6
		and.l	#EGPRB_Mastervolume,d6 ;Mastervolume switch im EP an ?
		beq.s	.NoMaster

		lea	EPG_Voice1Vol(a1),a2	;ok, Lautstrkewerte der einzelnen Stimmen verwenden
.NoMaster

		lea	PermerkLevelmeter(a5),a3;SamplePeriod merken und Spielzeit der Samples in 1/50 Sekunden
						;je 32 Bit = 1LW pro Kanal

	;--------------------- linke Kanle bearbeiten ----------------------
		move.l	AN_StructAdr(a5),a4	;Analyzer Struktur
		bsr	GetADRLENVOLandPER	;Daten Channel 1 holen

		move.l	a0,a1			;Adresse    fr Channel 1
		move.l	d0,d4			;Restlnge  ---- "" -----
		move	d3,d5			;Period     ---- "" -----
		move.w	d1,d6			;Lautstrke ---- "" -----

		addq.l	#4,a3
		move.l	AN_StructAdr(a5),a4	;Analyzer Struktur
		lea	UPS_Modulo*3(a4),a4	;4. Stimme
		bsr	GetADRLENVOLandPER	;Daten Channel 2 holen

		move.b	SlowIDLevel(a5),d3
		eor.b	#1,d3
		move.b	d3,SlowIDLevel(a5)
		bne	skip1$

		moveq	#0,d7
		bsr	ShowLevel
skip1$
	;--------------------- rechte Kanle bearbeiten ----------------------

		addq.l	#4,a3
		move.l	AN_StructAdr(a5),a4	;Analyzer Struktur
		lea	UPS_Modulo*1(a4),a4	;2. Stimme
		bsr	GetADRLENVOLandPER

		move.l	a0,a1			;Adresse    fr Channel 2
		move.l	d0,d4			;Restlnge  ---- "" -----
		move	d3,d5			;Period     ---- "" -----
		move.w	d1,d6			;Lautstrke ---- "" -----

		addq.l	#4,a3
		move.l	AN_StructAdr(a5),a4	;Analyzer Struktur
		lea	UPS_Modulo*2(a4),a4	;3. Stimme
		bsr	GetADRLENVOLandPER

		tst.b	SlowIDLevel(a5)		;jedes Frame jeweils abwechselnd
		beq	skip2$			;eine der beiden Zeilen darstellen

		moveq	#3,d7			;um 2 Zeilen nach unten verschieben
		bsr	ShowLevel
skip2$

error$
	else
;----------- Testroutine, Zeile bis Maximum und wieder von vorn darstellen -----------------
		move.l	MOL_Images(a0),d0
		beq	error$
		move.l	d0,a1

		move.l	MOL_UserData(a0),d0
		addq.l	#1,d0
		cmp.l	#16,d0
		ble	use$
		moveq	#0,d0
use$
		move.l	d0,MOL_UserData(a0)

		subq	#1,d0
		bmi.s	thisimage$
findimage$
		move.l	IML_Next(a1),d1
		beq	thisimage$
		move.l	d1,a1
		dbf	d0,findimage$
thisimage$
		move	MOL_Left(a0),d0		;Xpos
		move	MOL_Top(a0),d1		;Ypos
		move.l	a1,a0			;Image
		suba.l	a1,a1			;def. Rastport
		bsr	ShowImage

		addq	#3,d1
		bsr	ShowImage
error$
	endc
		rts
;----------------------------------------------------------------------------------------
;                        Ausschlag berechnen und anzeigen
;
;Formel zur Ermittlung der Signalleistung in dB:

;          (      n          )
;          (      _          )
;          ( 1    \  |x[]| )
;          ( -    /          )
;          ( n              )
;          (     =0         )
;          (                 )
;    10 lg ( --------------- )
;          (                 )
;          (                 )
;          (      Ydef       )
;          (                 )
;          (                 )
;
;Input:  a1 - Adresse Kanal1
;        d4 - Lnge   Kanal1 (ignoriert, da eh nur 64 Bytes aufgerechnet)
;        d5 - Period  Kanal1 (ignoriert)
;        d6 - Volume  Kanal1
;
;        a0 - Adresse Kanal2
;        d0 - Lnge   Kanal2 (ignoriert, da eh nur 64 Bytes aufgerechnet)
;        d3 - Period  Kanal2 (ignoriert) 
;        d1 - Volume  Kanal2
;
;        d7 - Offset in Y-Richtung fr Graphik
;Output: -
ShowLevel:
	Push	All

	move.l	d7,-(sp)
	moveq	#7,d7

	move	#128-1,d3	;128 Bytes aufrechnen

	moveq	#0,d2		;Zhler 2. Kanal

	move.l	a1,d0
	bne	a1ok$
	moveq	#8,d7
	move.l	a0,a1
	move.l	a0,d0
	beq	zero$
a1ok$
	move.l	a0,d0
	bne	a0ok$
	move.l	a1,a0
	moveq	#8,d7
a0ok$

	moveq	#0,d0		;Zhler 1. Kanal
addloop$
	move.b	(a1)+,d5
	ext.w	d5
	muls	d5,d5
	add.l	d5,d0

	move.b	(a0)+,d5
	ext.w	d5
	muls	d5,d5
	add.l	d5,d2

	dbf	d3,addloop$

				;max. Amplitude: $200000 = 128 * 128
	lsr.l	#5,d0
	lsr.l	#5,d2		;max. Amplitude: 65536 = +3dB
	
	mulu	d6,d0		;Volume Kanal1
	mulu	d1,d2		;Volume Kanal1
	add.l	d2,d0
	lsr.l	d7,d0
				;Amplitude: 0....32768
	moveq	#0,d2

	lea	LevelmeterTab(pc),a0
	moveq	#16-1,d1
loop$
	cmp	(a0)+,d0	;aktueller Wert kleiner als Schwellwert fr entsprechenden Dezibelwert ?
	blt.s	found$
	addq	#1,d2
	dbf	d1,loop$
found$

zero$	
	move.l	(sp)+,d7

		moveq	#ID_Levelmeter,d0
		bsr	FindObject
		beq	error$
		move.l	d0,a0
		
		move.l	MOL_Images(a0),d0
		beq	error$
		move.l	d0,a1

		subq	#1,d2
		bmi.s	thisimage$
findimage$
		move.l	IML_Next(a1),d1
		beq	thisimage$
		move.l	d1,a1
		dbf	d2,findimage$
thisimage$
		move	MOL_Left(a0),d0		;Xpos
		move	MOL_Top(a0),d1		;Ypos
		add	d7,d1

		move.l	a1,a0			;Image
		suba.l	a1,a1			;def. Rastport
		bsr	ShowImage
error$
	Pop	All
	rts
;****************************************************************************************
;*                           FFT Spektrum Analyzer                                      *
;****************************************************************************************
;Achtung: momentan wird mit statischen Feldern gearbeitet, bei FFT-Lngen >128 Datentabellen
;         anpassen !
;;!!
UpdateUPS:
		push	all
	ifne	Eagleplayer
		lea	Datas,a5
		sf	SpecialUPS(A5)
		sf	FFT_Stopanalyzer(a5)
		clr.l	FFT_Structadr(A5)
		
		move.l	myEPBase(pc),a1
		move.l	EPG_SomePrefs(a1),d6
		btst	#EGPRF_NowPlay,d6
		beq	stop$

		move.l	EPG_UPS_Structure(a1),d0	;spielt ein Modul ?
		beq	no1$				;nein, Fehler
		move.l	d0,AN_StructAdr(a5)
		move.l	d0,FFT_StructAdr(a5)
no1$
		move.l	EPG_ActiveAmplifier(a1),d0	;
		beq.s	ret$				;
		move.l	d0,a0				;

		cmp.l	#`4CHN`,EUS_AMIDNr(a0)		;FastRamAmplifier aktiv ?
		beq.s	set2$				;ok, take it
		
		cmp.l	#`14BT`,EUS_AMIDNr(a0)		;14 Bit Amplifier aktiv ?
		beq.s	set$				;ok, take it

		cmp.l	#`TOCC`,EUS_AMIDNr(a0)		;14 Bit Amplifier aktiv ?
		beq.s	set$				;ok, take it

		cmp.l	#`8BIT`,EUS_AMIDNr(a0)		;8 Bit Amplifier aktiv ?
		bne.s	ret$				;noe, das andere tuts also auch
set$
		move.l	EUS_AMUPSStruct(a0),d0
		beq.s	ret$
		move.l	d0,FFT_Structadr(a5)
		move.l	d0,AN_Structadr(a5)
		st	SpecialUPS(A5)
		bra	ret$
stop$
		moveq	#0,d0
		move.l	d0,FFT_Structadr(a5)
		move.l	d0,AN_Structadr(a5)

		st	FFT_Stopanalyzer(a5)
		move.b	#80,FFT_Stoptime(A5)

		moveq	#ID_Levelmeter,d0
		bsr	FindObject
		beq	ret$
		move.l	d0,a0
		
		move	MOL_Left(a0),d0		;Xpos
		move	MOL_Top(a0),d1		;Ypos
		move.l	MOL_Images(a0),d2
		beq	ret$
		move.l	d2,a0			;Image
		suba.l	a1,a1			;def. Rastport
		bsr	ShowImage
		addq	#3,d1
		bsr	ShowImage
	endc
ret$
		pop	all
		rts
set2$:
		move.l	EUS_AMUPSStruct(a0),d0
		beq.s	ret$
		move.l	d0,FFT_Structadr(a5)
		bra.s	ret$
InitAnalyzer:
		Push	all
;		move.l	#16384*81,FFT_Mixfrequency(a5)	;44.1 kHz
		move.l	#16384*112,FFT_Mixfrequency(a5)	;32 kHz = 16 kHz max., 8 kHz davon ausgewertet
;		move.l	#16384*149,FFT_Mixfrequency(a5)	;24 kHz
;		move.l	#16384*224,FFT_Mixfrequency(a5)	;15980 Hz =  8 kHz max.

		sf	FFT_slowid(a5)			;

	ifeq	FXTask
		move.b	#2,FFT_slowcount(a5)		;nur jedes 2. Frame was tun
	else
		move.b	#1,FFT_slowcount(a5)		;jedes Frame was tun
	endc	

		clr.l	FFT_Permerk(A5)
		clr.l	FFT_Permerk+4(A5)
		clr.l	FFT_Permerk+8(A5)
		clr.l	FFT_Permerk+12(A5)
		sf	SpecialUPS(A5)
		move	#128,FFT_Current_Num(a5)	;Lnge der berechneten FFT

		move	#FFT_Displayentries,FFT_NumDisplay(a5)	;Anzahl der angezeigten Balken

		tst.l	FFT_CurrentMode(a5)
		bne.s	set$
		bsr	UpdateAnalyzerPrefs
set$
		bsr	MakeBitreversetabs		;
		bsr	MakeSinCostabs			;sin/cos mit eingerechneter Bitspiegelung
		bsr	MakeSinCostabs2			;
		bsr	MakeAnalyzertab			;logarithmische Umrechnungstabelle erzeugen

		Pop	all
		rts
HandleAnalyzer:
		Push	all
		lea	Datas,a5

		tst.b	FFT_Stopanalyzer(a5)
		bne.w	Stop$

	ifne	Eagleplayer
		move.l	myEPBase(pc),a1
		move.l	EPG_SomePrefs(a1),d6
		btst	#EGPRF_NowPlay,d6
		beq	error$

		move.l	Prefsflags(pc),d6
		and.l	#PFlag_AnalyzerPower,d6
		beq	error$

		tst.l	FFT_Structadr(a5)
;		bne.s	ok$
;		move.l	AN_Structadr(A5),FFT_Structadr(a5)
		beq	error$
;ok$
	endc
;		bsr	InitAnalyzer

		;	Zielmap
		moveq	#ID_AnalyzerMap,d0
		bsr	FindObject		;Objekt in Liste finden
		beq	error$		
		move.l	d0,a4			;
		move.l	MOL_Images(a4),d0
		beq	error$
		move.l	d0,a0

		;	Grafik der einzelnen Zustnde
		moveq	#ID_Analyzerstates,d0
		bsr	FindObject		;Objekt in Liste finden
		beq	error$		
		move.l	d0,a1			;
		move.l	MOL_Images(a1),d0
		beq	error$
		move.l	d0,a1

		bsr	FFT_MixVoices

		tst.b	FFT_slowid(A5)		;nur jedes 2. oder 3. Frame was tun ?
		bne.s	nofft1$
		bsr	FFT_Main

		lea	FFT_OutTable(a5),a2	;Datenfeld
		move	FFT_NumDisplay(a5),d0	;Anzahl der angezeigten Balken

		move.l	FFT_CurrentMode(a5),d1
		beq	error$
		move.l	d1,a3
		jsr	(a3)

		move	MOL_Left(a4),d0
		move	MOL_Top(a4),d1
		suba.l	a1,a1
		move.l	MOL_Images(a4),a0
		bsr	ShowImage
nofft1$
error$
		Pop	all
		rts
stop$
		move.l	Prefsflags(pc),d6
		and.l	#PFlag_AnalyzerPower,d6
		beq	nofft1$

		move.b	FFT_Stoptime(a5),d0
		ble.s	nofft1$
		subq.b	#1,d0
		move.b	d0,FFT_Stoptime(a5)
		beq	KillDisplay$

		move.b	FFT_slowid(A5),d0		;nur jedes 2. oder 3. Frame etwas ausgeben ?
		addq.b	#1,d0
		cmp.b	FFT_slowcount(a5),d0	;<- wird erst beim ffnen des Fensters gesetzt
						;   auf momentan 1-3
		blt.s	lo$

		moveq	#0,d0
lo$		move.b	d0,FFT_slowid(a5)
		bne	nofft1$

		;	Zielmap
		moveq	#ID_AnalyzerMap,d0
		bsr	FindObject		;Objekt in Liste finden
		beq	error$		
		move.l	d0,a4			;
		move.l	MOL_Images(a4),d0
		beq	error$
		move.l	d0,a0

		;	Grafik der einzelnen Zustnde
		moveq	#ID_Analyzerstates,d0
		bsr	FindObject		;Objekt in Liste finden
		beq	error$		
		move.l	d0,a1			;
		move.l	MOL_Images(a1),d0
		beq	error$
		move.l	d0,a1

		lea	FFT_OutTable(a5),a2	;Datenfeld
		move	FFT_NumDisplay(a5),d0	;Anzahl der angezeigten Balken
		move	d0,d1
		subq	#1,d1
		move.l	a2,a3
clr$
		clr.w	(a3)+
		dbf	d1,clr$

		move.l	FFT_CurrentMode(a5),d1
		beq	error$
		move.l	d1,a3
		jsr	(a3)

		move	MOL_Left(a4),d0
		move	MOL_Top(a4),d1
		suba.l	a1,a1
		move.l	MOL_Images(a4),a0
		bsr	ShowImage

		bra	nofft1$
KillDisplay$
		bsr	LitAnalyzer
		bra	nofft1$

;---------- Darstellung Modus 1 (normal) ------------
;Inputs: d0 - Anzahl der Balken
;        a0 - Image-Struct Zielgrafik
;        a1 - Image-Struct Quellgrafik (einzelne Zustnde)
;        a2 - Datenfeld
Mode01Scope:
		push	all
		moveq	#0,d2
		move.w	IML_Width(a0),d2	;Breite Zeilmap
		lsl	#3,d2			;Breite * 4 (32 Bit 0RGB) * 2 (berspringen jeder 2. Zeile)
		
		moveq	#0,d3
		move.w	IML_Width(a1),d3	;Zeilenbreite Quellmap
		lsl	#2,d3			;32 Bit pro Eintrag

		move.l	IML_Data(a0),a0
		move.l	IML_Data(a1),a1

;		lsr	#1,d0		;
		subq	#1,d0
show$
		move.w	(a2)+,d4
		move.l	a0,a4
		mulu	d3,d4

		moveq	#FFT_Height/2-1,d1
		lea	(a1,d4.l),a3
show1$
		movem.l	(a3)+,d5-d7/a6		;4 LW pro Eintrag
		movem.l	d5-d7/a6,(a4)
		add.l	d2,a4			;nchste Zeile
		dbf	d1,show1$

		adda.l	#16,a0
		dbf	d0,show$
		pop	all

		bsr	PrepareMaxDisplay
		moveq	#0,d1
		lea	FFT_MaxDisplaytab(a5),a2
		bsr	MaxDisplay1

		rts
;---------- Darstellung Modus 2 (upside down) ------------
;Inputs: d0 - Anzahl der Balken
;        a0 - Image-Struct Zielgrafik
;        a1 - Image-Struct Quellgrafik (einzelne Zustnde)
;        a2 - Datenfeld
Mode02Scope:
		push	all
		moveq	#0,d2
		move.w	IML_Width(a0),d2	;Breite Zeilmap
		lsl	#3,d2			;Breite * 4 (32 Bit 0RGB) * 2 (berspringen jeder 2. Zeile)
		
		moveq	#0,d3
		move.w	IML_Width(a1),d3	;Zeilenbreite Quellmap
		lsl	#2,d3			;32 Bit pro Eintrag

		move	IML_Width(a0),d4
		lsl	#2,d4
		move	IML_Height(a0),d5
		subq	#2,d5
		mulu	d5,d4
		move.l	IML_Data(a0),a0
		add.l	d4,a0
		move.l	IML_Data(a1),a1

;		lsr	#1,d0		;
		subq	#1,d0
show$
		move.w	(a2)+,d4
		move.l	a0,a4
		mulu	d3,d4

		moveq	#FFT_Height/2-1,d1
		lea	(a1,d4.l),a3
show1$
		movem.l	(a3)+,d5-d7/a6		;4 LW pro Eintrag
		movem.l	d5-d7/a6,(a4)
		sub.l	d2,a4			;nchste Zeile
		dbf	d1,show1$

		adda.l	#16,a0
		dbf	d0,show$
		pop	all

		bsr	PrepareMaxDisplay
		moveq	#1,d1
		lea	FFT_MaxDisplaytab(a5),a2
		bsr	MaxDisplay1
		rts
;---------- Darstellung Modus 3 (horizontal) ------------
;Inputs: d0 - Anzahl der Balken
;        a0 - Image-Struct Zielgrafik
;        a1 - Image-Struct Quellgrafik (einzelne Zustnde)
;        a2 - Datenfeld
Mode03Scope:
		push	all
		move.l	IML_Next(a1),d2		;2. Image fr Hori-Mode
		beq	error$
		move.l	d2,a1
		
		moveq	#0,d2
		move.w	IML_Width(a0),d2	;Breite Zeilmap
		move	d2,d6
		lsl	#2,d2
		move	IML_Height(a0),d5
		move	d5,d0
		lsr	#1,d0			;Hhe Zielmap/2

		mulu	d2,d5			;letzte Zeile Zielmap

		mulu	#3,d2
		neg.l	d2
		
		moveq	#0,d3
		move.w	IML_Width(a1),d3	;Zeilenbreite Quellmap
		lsl	#2,d3

		move.l	IML_Data(a1),a1
		move.l	IML_Data(a0),a0
		add.l	d5,a0

		subq	#1,d6

		move.l	a0,a4
show$
		move	(a2)+,d4
		mulu	d3,d4
		lea	(a1,d4.l),a3

		move	d6,d1
show1$
		move.l	(a3)+,(a4)+
		dbf	d1,show1$

		add.l	d2,a4			;nchste Zeile
		dbf	d0,show$
error$
		pop	all
		rts
;---------- Darstellung Modus 4 (see through) ------------
;Inputs: d0 - Anzahl der Balken
;        a0 - Image-Struct Zielgrafik
;        a1 - Image-Struct Quellgrafik (einzelne Zustnde)
;        a2 - Datenfeld
Mode04Scope:
	;Puffer lschen
		push	all

		moveq	#0,d3
		move.w	IML_Width(a0),d3	;Breite Zeilmap
		move	d3,d0
		lsr	#2,d0
		subq	#1,d0			;Anzahl der Pixel/4 - 1

		lsl	#2,d3			;1 Pixel = 4 Bytes

		move	IML_Height(a0),d6
		lsr	#1,d6
		subq	#1,d6

		move.l	IML_Data(A1),a1
		move.l	IML_Data(A0),a0

		movem.l	(a1),d2/d4/d5/a2
clr1$
		move	d0,d1
clr2$
		movem.l	d2/d4/d5/a2,(a0)
		adda.l	#16,a0
		dbf	d1,clr2$
		add.l	d3,a0
		dbf	d6,clr1$
		pop	all

	;Daten einzeichnen
		push	all

		moveq	#0,d2
		move.w	IML_Width(a0),d2	;Breite Zeilmap
		lsl	#2,d2
		move	IML_Height(a0),d5
;		subq	#1,d5
		mulu	d2,d5			;Offset letzte Zeile
		add	d2,d2			;jede 2. Zeile berspringen

		move.w	IML_Width(a1),d3	;Zeilenbreite Quellmap
		lsl	#2,d3
		move	IML_Height(a1),d4
;		subq	#1,d4			;Nummer letzte Zeile
		move	d4,d6
		lsr	#1,d6
		subq	#1,d6
		mulu	d3,d4			;mal Breite
;		sub.l	#16,d4

		move.l	IML_Data(a0),a0

		move.l	IML_Data(a1),a1

		subq	#1,d0

		add.l	d4,a1			;letzte Zeile ist Adresse der Ausgangsdaten
		add.l	d5,a0			;letzte Zeile Zielmap
show$
		move	(a2)+,d1
		beq.s	next$
		neg.w	d1
		cmp.w	#-20,d1
		bgt.s	lo$
		moveq	#-19,d1
lo$
		move	d2,d4
		muls	d1,d4
		asl	#4,d1			;jeder Eintrag in Quellmap ist 4 Punkte a 32 bit breit
		lea.l	(a1,d1.w),a3		;
		movem.l	(a3),d5-d7/a6

		lea	(a0,d4.l),a4
		movem.l	d5-d7/a6,(a4)
next$
		adda.l	#16,a0
		dbf	d0,show$
		pop	all

		bsr	PrepareMaxDisplay
		moveq	#0,d1
		lea	FFT_MaxDisplaytab(a5),a2
		bsr	MaxDisplay1
		rts

;---------- Darstellung Spitzenwertanzeige ------------
;Inputs: d0 - Anzahl der Balken
;        d1 - Richtung: 0=nach oben 1=nach unten
;        a0 - Image-Struct Zielgrafik
;        a1 - Image-Struct Quellgrafik (einzelne Zustnde)
;        a2 - Datenfeld
MaxDisplay1:
		push	all

		moveq	#0,d2
		move.w	IML_Width(a0),d2	;Breite Zeilmap
		lsl	#2,d2
		move	IML_Height(a0),d5
;		subq	#1,d5
		mulu	d2,d5			;Offset letzte Zeile
		add	d2,d2			;jede 2. Zeile berspringen

		tst	d1
		beq	ok1$
		neg	d2
ok1$
		move.w	IML_Width(a1),d3	;Zeilenbreite Quellmap
		lsl	#2,d3
		move	IML_Height(a1),d4
;		subq	#1,d4			;Nummer letzte Zeile
		mulu	d3,d4			;mal Breite
;		sub.l	#16,d4

		move.l	IML_Data(a0),a0
		tst	d1
		bne	ok2$
		add.l	d5,a0			;letzte Zeile Zielmap
ok2$
		move.l	IML_Data(a1),a1
		add.l	d4,a1			;letzte Zeile ist Adresse der Ausgangsdaten

		subq	#1,d0
show$
		move	(a2)+,d1
		beq.s	next$
		neg.w	d1
		cmp.w	#-20,d1
		bgt.s	lo$
		moveq	#-19,d1
lo$
		move	d2,d4
		muls	d1,d4
		asl	#4,d1			;jeder Eintrag in Quellmap ist 4 Punkte a 32 bit breit
		lea.l	(a1,d1.w),a3		;
		movem.l	(a3),d5-d7/a6

		lea	(a0,d4.l),a4
		movem.l	d5-d7/a6,(a4)
next$
		addq.l	#2,a2
		adda.l	#16,a0
		dbf	d0,show$
		pop	all
		rts
;-------------------------------------------------------------------------------------
;                Funktion: Spitzenwertanzeige fr einen Kanal vorbereiten,
;                          Vergleich mit neuen Werten und Update der Tab
;
;Input:  A2 - neue Wertetab fr diesen Ausgabestream
;Output: -
;
; Aufbau der Tabelle: 1. Wort aktuelle Amplitude
;                     2. Wort Zeit, die diese Amplitude besteht
;
PrepareMaxDisplay:
		push	all
		move.l	a2,a0
		lea	FFT_MaxDisplaytab,a1

		moveq	#TimeOut,d4
		moveq	#0,d5
		move.b	FFT_slowcount(a5),d5
		divu	d5,d4

		move	FFT_NumDisplay(a5),d0
		subq	#1,d0
loop$
		move	(a0)+,d1	;neuer Wert
		move	(a1)+,d2	;alter Wert
		cmp	d1,d2
		ble.s	new$
				;alter Wert grer
		move	(a1),d3		;Timeout
		subq	#1,d3
		bge.s	old$		;Timeout zhlen

		subq	#DownSpeed,d2	;Ausschlag verringern
		blt.s	skip$		;0 erreicht
		move	d2,-2(a1)	;Ausschlag abspeichern
		addq.l	#2,a1
		bra.s	next$
skip$		move.w	#0,-2(a1)	;Ausschlag 0 erreicht
		addq.l	#2,a1
		bra.s	next$

old$		move	d3,(a1)+	;Timeout noch nicht erreicht
		bra.s	next$
new$
		move	d1,-2(a1)
		move	d4,(a1)+
next$
		dbf	d0,loop$
		pop	all
		rts
;----------------------------------------------------------------------------------------------
;
; FFT-Routine: 128 Punkt Integer FFT rckgefhrt auf 64 Punkt FFT reellwertiger Eingangswerte
;
; Algorithmus: N/4 * ld N/2 komplexe Operationen = 192 <> N*ld N Operationen bei Radix 2 = 896
; (Routine selbst unoptimiert, knapp 50% der Multiplikationen redundant...)
;
	IFEQ	USEFPU
FFT_Main:
		Push	all
		
		lea	FFT_Realtab,a0
		lea	FFT_Imgtab,a1
;------------------------------- InitWerte ------------------------------------------------------
		move	#FFT_N/2*2,d1	;N2=N/2 (*2 wg. wortweisem Speicherzugriff)
		move.l	#FFT_Gamma-1-2,d2	;NU1=Gamma-1

;----------------------------------------------------------------------------------------------
;                                      optimierter Loop 1
;----------------------------------------------------------------------------------------------
;1. Optimierung: beim 1. Durchlauf lediglich sin=0, cos=1 fr alle W^P, somit multiplikationslos
opt1_Outerloop$
		;---------------------- 1. Trivialloop --------------------

		lea	(a0),a2		;&realk
		lea	(a1),a4		;&imagk
		lea	(a2,d1.w*2),a5	;&realk+N2
		lea	(a4,d1.w*2),a6	;&imagk+N2

		lsr	#1,d1
		move	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		subq	#1,d7		;Schleife fr I bis N2
opt1_trivial1loop$			;Trivialflle, sin = 0, cos = 1
		move.l	(a5),d0
		move.l	(a2),d4
		move.l	(a6),d6
		move.l	(a4),d5
		move.l	d4,d3
		add.l	d0,d4
		sub.l	d0,d3
		move.l	d5,d0
		add.l	d6,d5
		move.l	d4,(a2)+
		move.l	d3,(a5)+
		sub.l	d6,d0
		move.l	d5,(a4)+
		move.l	d0,(a6)+
		dbf	d7,opt1_trivial1loop$

;----------------------------------------------------------------------------------------------
;                                      optimierter Loop 2
;----------------------------------------------------------------------------------------------
;1. Optimierung: beim 2. Durchlauf erste Hlfte sin=0, cos=1, 2. Hlfte sin=1, cos=0
;
opt2_Outerloop$
		;---------------------- 1. Trivialloop --------------------

		lea	(a0),a2		;&realk
		lea	(a1),a4		;&imagk
		move	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		lea	(a2,d1.w*2),a5	;&realk+N2
		lsr	#1,d7
		lea	(a4,d1.w*2),a6	;&imagk+N2
		subq	#1,d7		;Schleife fr I bis N2
opt2_trivial1loop$			;Trivialflle, sin = 0, cos = 1
		move.l	(a5),d0
		move.l	(a2),d4
		move.l	(a6),d6
		move.l	(a4),d5
		move.l	d4,d3
		add.l	d0,d4
		sub.l	d0,d3
		move.l	d5,d0
		add.l	d6,d5
		move.l	d4,(a2)+
		move.l	d3,(a5)+
		sub.l	d6,d0
		move.l	d5,(a4)+
		move.l	d0,(a6)+
		dbf	d7,opt2_trivial1loop$

		;---------------------- 2. Trivialloop --------------------

		lea	(a2,d1.w*2),a2	;realk = data + k
		lea	(a4,d1.w*2),a4	;imagk = data + k
		lea	(a2,d1.w*2),a5	;realkN2 = realk + N2
		lea	(a4,d1.w*2),a6	;imagkN2 = imagk + N2

		lsr	#1,d1
		move	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		subq	#1,d7		;Schleife fr I bis N2
opt2_trivial2loop$			;Trivialflle, sin = 1, cos = 0
		move.l	(a6),d0
		move.l	(a2),d4
		move.l	(a5),d6
		move.l	(a4),d5
		move.l	d4,d3
		add.l	d0,d4		;resreal = *realk + treal;
		sub.l	d0,d3
		move.l	d5,d0
		sub.l	d6,d5		;resimag = *imagk - timag;
		move.l	d4,(a2)+	;*realk++ = resreal;
		move.l	d3,(a5)+	;*realkN2++ = resreal - treal - treal;
		add.l	d6,d0
		move.l	d5,(a4)+	;*imagk++ = resimag;
		move.l	d0,(a6)+	;*imagkN2++ = resimag + timag + timag;
		dbf	d7,opt2_trivial2loop$

;-----------------------------------------------------------------------------------------------
;                                       Hauptschleife
;-----------------------------------------------------------------------------------------------
;
;89 Instruktionen
;
Outerloop$
		move.w	d2,d7
		swap	d7
		move	d1,d3
		lea	SinCostab+8*2,a3 ;Sinus- und Cosinustabelle fr N Werte, auf 256 bezogen, die Eintrge der ersten 2 Trivialschleifen abgezogen

		;---------------------- 1. Trivialloop --------------------

		lea	(a0),a2		;&realk
		lea	(a1),a4		;&imagk
		lea	(a2,d1.w*2),a5	;&realk+N2
		lea	(a4,d1.w*2),a6	;&imagk+N2

		move	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		lsr	#1,d7
		subq	#1,d7		;Schleife fr I bis N2
trivial1loop$				;Trivialflle, sin = 0, cos = 1
		move.l	(a5),d0		;treal = *realkN2
		move.l	(a6),d6		;timag = *imagkN2
		move.l	(a2),d4		;*realk
		move.l	(a4),d5		;*imagk
		add.l	d0,d4		;resreal = *realk + treal;
		add.l	d6,d5		;resimag = *imagk + timag;
		move.l	d4,(a2)+	;*realk++ = resreal;
		sub.l	d0,d4
		move.l	d5,(a4)+	;*imagk++ = resimag;
		sub.l	d6,d5
		sub.l	d0,d4
		sub.l	d6,d5
		move.l	d4,(a5)+	;*realkN2++ = resreal - treal - treal;
		move.l	d5,(a6)+	;*imagkN2++ = resimag - timag - timag;
		dbf	d7,trivial1loop$

		;---------------------- 2. Trivialloop --------------------

		lea	(a2,d1.w*2),a2	;realk = data + k
		lea	(a4,d1.w*2),a4	;imagk = data + k
		lea	(a2,d1.w*2),a5	;realkN2 = realk + N2
		lea	(a4,d1.w*2),a6	;imagkN2 = imagk + N2

		move	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		lsr	#1,d7
		subq	#1,d7		;Schleife fr I bis N2
trivial2loop$				;Trivialflle, sin = 1, cos = 0
		move.l	(a6),d0		;treal = *imagkN2
		move.l	(a5),d6		;timag = *realkN2
		move.l	(a2),d4		;*realk
		move.l	(a4),d5		;*imagk
		add.l	d0,d4		;resreal = *realk + treal;
		sub.l	d6,d5		;resimag = *imagk - timag;
		move.l	d4,(a2)+	;*realk++ = resreal;
		sub.l	d0,d4
		move.l	d5,(a4)+	;*imagk++ = resimag;
		add.l	d6,d5
		sub.l	d0,d4
		add.l	d6,d5
		move.l	d4,(a5)+	;*realkN2++ = resreal - treal - treal;
		move.l	d5,(a6)+	;*imagkN2++ = resimag + timag + timag;
		dbf	d7,trivial2loop$

		lsl	#2,d3
		;----------- langsamer Teil der Hauptschleife ------------------
;		 // outerloop 2, 1 bis N/4 mal durchlaufen
slow_outerloop$
		lea	(a2,d1.w*2),a2	;realk = data + k
		lea	(a4,d1.w*2),a4	;imagk = data + k
		lea	(a2,d1.w*2),a5	;realkN2 = realk + N2
		lea	(a4,d1.w*2),a6	;imagkN2 = imagk + N2

;		 // innerloop, N/2 bis 1 mal durchlaufen
					;for( i = 0; i < N2; i++)
		move	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		lsr	#1,d7		;
		subq	#1,d7		;Schleife fr I bis N2

;		move.l	(a3)+,d5	;sin<<16 + cos
slowloop$				;Standardfall mit variablen sin/cos-Werten
		move.l	(a5),d0		;*realkN2
		move.l	(a6),d6		;*imagkN2
		move.l	d0,d4
		muls.l	4(a3),d0	;*realkN2 * cos
		move.l	d6,d2
		muls.l	4(a3),d6	;*imagkN2 * cos
;		swap	d5		;cos<<16 + sin
		muls.l	(a3),d4		;*realkN2 * sin
		muls.l	(a3),d2		;*imagkN2 * sin

		add.l	d2,d0		;treal = (*realkN2 * *cos1 + *imagkN2 * *sin1);
		sub.l	d4,d6		;timag = *imagkN2 * *cos1 - *realkN2 * *sin1;
		move.l	(a4),d2		;*imagk
		asr.l	#FFT_SinBase/2,d0	;Integer Shift
		asr.l	#FFT_SinBase/2,d0	;Integer Shift
		move.l	(a2),d4		;*realk
		asr.l	#FFT_SinBase/2,d6	;Integer Shift, Tabellen um 2^8 verschoben
		asr.l	#FFT_SinBase/2,d6	;Integer Shift, Tabellen um 2^8 verschoben

		add.l	d0,d4		;resreal = *realk + treal;
		move.l	d4,(a2)+	;*realk++ = resreal;
		sub.l	d0,d4
		add.l	d6,d2		;resimag = *imagk + timag
		sub.l	d0,d4
		move.l	d2,(a4)+	;*imagk++ = resimag;
		move.l	d4,(a5)+	;*realkN2++ = resreal - treal - treal;
		sub.l	d6,d2
;		swap	d5		;sin<<16 + cos
		sub.l	d6,d2
		move.l	d2,(a6)+	;*imagkN2++ = resimag - timag - timag;

		dbf	d7,slowloop$

		addq.l	#8,a3

		add	d1,d3		;k+= N2<<1;
		add	d1,d3		;

		cmp	#FFT_N*2-1,d3	;while( k < N )
		blt.s	slow_outerloop$

		swap	d7
		move.w	d7,d2
		lsr	#1,d1		;N2 >>= 1;
		dbf	d2,Outerloop$	;NU1=NU1-1 -> bis NU1 = 0,umlaufen, bei <0 fertig

;-------------- Folge 1 und Folge 2 trennen, Bitreverse bercksichtigen  ---------------------
;hllisch langsam, wird aber in diesem Programm nur 32 mal durchlaufen...

		lea	FFT_Realtab,a0
		lea	FFT_Imgtab,a1
		lea	FFT_OutTable,a2
		lea	FFT_OutTableI,a4

		lea	SinTab2,a3
		lea	CosTab2,a5

		moveq	#1,d0
		move	#FFT_N-1,d1

		move.l	(a0),d2
		add.l	(a1),d2
		move	d2,(a2)+		;Gleichanteil
		clr	(a4)+			;=Real(0)+Imag(0)

		lea	Bitreversetab,a6	;Tabellen fr IBR(M)
trennen$
		move	(a6,d0.w*2),d6
		move	(a6,d1.w*2),d7

		move.l	(a0,d6.w*4),d2		;Xreal(n)
		move.l	(a0,d7.w*4),d3		;Xreal(N-n)

		move.l	(a1,d6.w*4),d4		;Ximag(n)
		move.l	(a1,d7.w*4),d5		;Ximag(N-n)

		asr.l	#5,d2			;alle durch
		asr.l	#5,d3			; 2 dividieren, hier noch
		asr.l	#5,d4			; ein paar bit mehr wg. 
		asr.l	#5,d5			; Genauigkeitserweiterung

		add	d3,d2			;R(n)+R(N-n)
		move.w	d2,(a2)
		sub	d3,d2
		sub	d3,d2			;R(n)-R(N-n)
		move	d2,d3			;R(n)-R(N-n)

		ext.l	d2
		ext.l	d3
		muls.l	(a3,d0.w*4),d2		;sin n/N * ( R(n)-R(N-n) )
		muls.l	(a5,d0.w*4),d3		;cos n/N * ( R(n)-R(N-n) )
		asr.l	#FFT_Sinbase/2,d2
		asr.l	#FFT_Sinbase/2,d2
		asr.l	#FFT_Sinbase/2,d3
		asr.l	#FFT_Sinbase/2,d3
		sub	d2,(a2)

		clr	(a4)
		sub	d3,(a4)			;-[ cos n/N * ( R(n)-R(N-n) ) ]

		sub.l	d5,d4			;I(n)-I(N-n)
		add	d4,(a4)			;+I(n)-I(N-n)
		add.l	d5,d4
		add.l	d5,d4			;I(n)+I(N-n)
		move.l	d4,d5

		ext.l	d4
		ext.l	d5
		muls.l	(a3,d0.w*4),d4		;sin n/N * ( I(n)+I(N-n) )
		muls.l	(a5,d0.w*4),d5		;cos n/N * ( I(n)+I(N-n) )
		asr.l	#FFT_Sinbase/2,d4
		asr.l	#FFT_Sinbase/2,d4
		asr.l	#FFT_Sinbase/2,d5
		asr.l	#FFT_Sinbase/2,d5
		sub	d4,(a4)+		;-[ sin n/N * ( I(n)+I(N-n) ) ]

		add	d5,(a2)+		;+[ cos n/N * ( I(n)+I(N-n) ) ]

		subq	#1,d1
		addq	#1,d0

		ifne	FFT_ShowLess
		cmp	#FFT_ShowLess+2,d0
		else
		cmp	#FFT_N,d0
		endc
		blt.w	trennen$

;		move	(a0),d2			;Xr(0)
;		move	(a1),d4			;Xi(0)
;		sub	d4,d2			;Xr(0)-Xi(0)
;		lea	OutTab1R(pc),a0		;Xr(0)+Xi(0)
;		sub	(a0),d2			;Xr(0)-Xi(0)-(Xr(0)+Xi(0))

		move.l	(a1),d4
		add	d4,d4
		neg	d4
		move	d4,(a2)+
		clr	(a4)+
;		clr	(a2)+
	ELSE
FFT_Main:
		Push	all
		
		lea	FFT_Realtab,a0
		lea	FFT_Imgtab,a1
;------------------------------- InitWerte ------------------------------------------------------
		move	#FFT_N/2*2,d1	;N2=N/2 (*2 wg. wortweisem Speicherzugriff)
		move.l	#FFT_Gamma-1-2,d2	;NU1=Gamma-1

;----------------------------------------------------------------------------------------------
;                                      optimierter Loop 1
;----------------------------------------------------------------------------------------------
;1. Optimierung: beim 1. Durchlauf lediglich sin=0, cos=1 fr alle W^P, somit multiplikationslos
opt1_Outerloop$
		;---------------------- 1. Trivialloop --------------------

		lea	(a0),a2		;&realk
		lea	(a1),a4		;&imagk
		lea	(a2,d1.w*2),a5	;&realk+N2
		lea	(a4,d1.w*2),a6	;&imagk+N2

		lsr	#1,d1
		move	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		subq	#1,d7		;Schleife fr I bis N2
opt1_trivial1loop$			;Trivialflle, sin = 0, cos = 1
		move.l	(a5),d0
		move.l	(a2),d4
		move.l	(a6),d6
		move.l	(a4),d5
		fmove.l	d0,fp0
		fmove.l	d4,fp4
		fmove.l	d6,fp6
		fmove.l	d5,fp5
		fmove.x	fp4,fp3
		fadd.x	fp0,fp4
		fsub.x	fp0,fp3
		fmove.x	fp5,fp0		
		fadd.x	fp6,fp5
		fmove.s	fp4,(a2)+
		fmove.s	fp3,(a5)+
		fsub.x	fp6,fp0
		fmove.s	fp5,(a4)+
		fmove.s	fp0,(a6)+
		dbf	d7,opt1_trivial1loop$

;----------------------------------------------------------------------------------------------
;                                      optimierter Loop 2
;----------------------------------------------------------------------------------------------
;1. Optimierung: beim 2. Durchlauf erste Hlfte sin=0, cos=1, 2. Hlfte sin=1, cos=0
;
opt2_Outerloop$
		;---------------------- 1. Trivialloop --------------------

		lea	(a0),a2		;&realk
		lea	(a1),a4		;&imagk
		move	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		lea	(a2,d1.w*2),a5	;&realk+N2
		lsr	#1,d7
		lea	(a4,d1.w*2),a6	;&imagk+N2
		subq	#1,d7		;Schleife fr I bis N2
opt2_trivial1loop$			;Trivialflle, sin = 0, cos = 1
		fmove.s	(a5),fp0
		fmove.s	(a2),fp4
		fmove.s	(a6),fp6
		fmove.s	(a4),fp5
		fmove.x	fp4,fp3
		fadd.x	fp0,fp4
		fsub.x	fp0,fp3
		fmove.x	fp5,fp0
		fadd.x	fp6,fp5
		fmove.s	fp4,(a2)+
		fmove.s	fp3,(a5)+
		fsub.x	fp6,fp0
		fmove.s	fp5,(a4)+
		fmove.s	fp0,(a6)+
		dbf	d7,opt2_trivial1loop$

		;---------------------- 2. Trivialloop --------------------

		lea	(a2,d1.w*2),a2	;realk = data + k
		lea	(a4,d1.w*2),a4	;imagk = data + k
		lea	(a2,d1.w*2),a5	;realkN2 = realk + N2
		lea	(a4,d1.w*2),a6	;imagkN2 = imagk + N2

		lsr	#1,d1
		move	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		subq	#1,d7		;Schleife fr I bis N2
opt2_trivial2loop$			;Trivialflle, sin = 1, cos = 0
		fmove.s	(a6),fp0
		fmove.s	(a2),fp4
		fmove.s	(a5),fp6
		fmove.s	(a4),fp5
		fmove.x	fp4,fp3
		fadd.x	fp0,fp4		;resreal = *realk + treal;
		fsub.x	fp0,fp3
		fmove.x	fp5,fp0
		fsub.x	fp6,fp5		;resimag = *imagk - timag;
		fmove.s	fp4,(a2)+	;*realk++ = resreal;
		fmove.s	fp3,(a5)+	;*realkN2++ = resreal - treal - treal;
		fadd.x	fp6,fp0
		fmove.s	fp5,(a4)+	;*imagk++ = resimag;
		fmove.s	fp0,(a6)+	;*imagkN2++ = resimag + timag + timag;
		dbf	d7,opt2_trivial2loop$

;-----------------------------------------------------------------------------------------------
;                                       Hauptschleife
;-----------------------------------------------------------------------------------------------
;
;89 Instruktionen
;
Outerloop$
		move.w	d2,d7
		swap	d7
		move	d1,d3
		lea	SinCostab+8*2,a3 ;Sinus- und Cosinustabelle fr N Werte, auf 256 bezogen, die Eintrge der ersten 2 Trivialschleifen abgezogen

		;---------------------- 1. Trivialloop --------------------

		lea	(a0),a2		;&realk
		lea	(a1),a4		;&imagk
		lea	(a2,d1.w*2),a5	;&realk+N2
		lea	(a4,d1.w*2),a6	;&imagk+N2

		move	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		lsr	#1,d7
		subq	#1,d7		;Schleife fr I bis N2
trivial1loop$				;Trivialflle, sin = 0, cos = 1
		fmove.s	(a5),fp0	;treal = *realkN2
		fmove.s	(a6),fp6	;timag = *imagkN2
		fmove.s	(a2),fp4	;*realk
		fmove.s	(a4),fp5	;*imagk
		fadd.x	fp0,fp4		;resreal = *realk + treal;
		fadd.x	fp6,fp5		;resimag = *imagk + timag;
		fmove.s	fp4,(a2)+	;*realk++ = resreal;
		fsub.x	fp0,fp4
		fmove.s	fp5,(a4)+	;*imagk++ = resimag;
		fsub.x	fp6,fp5
		fsub.x	fp0,fp4
		fsub.x	fp6,fp5
		fmove.s	fp4,(a5)+	;*realkN2++ = resreal - treal - treal;
		fmove.s	fp5,(a6)+	;*imagkN2++ = resimag - timag - timag;
		dbf	d7,trivial1loop$

		;---------------------- 2. Trivialloop --------------------

		lea	(a2,d1.w*2),a2	;realk = data + k
		lea	(a4,d1.w*2),a4	;imagk = data + k
		lea	(a2,d1.w*2),a5	;realkN2 = realk + N2
		lea	(a4,d1.w*2),a6	;imagkN2 = imagk + N2

		move	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		lsr	#1,d7
		subq	#1,d7		;Schleife fr I bis N2
trivial2loop$				;Trivialflle, sin = 1, cos = 0
		fmove.s	(a6),fp0	;treal = *imagkN2
		fmove.s	(a5),fp6	;timag = *realkN2
		fmove.s	(a2),fp4	;*realk
		fmove.s	(a4),fp5	;*imagk
		fadd.x	fp0,fp4		;resreal = *realk + treal;
		fsub.x	fp6,fp5		;resimag = *imagk - timag;
		fmove.s	fp4,(a2)+	;*realk++ = resreal;
		fsub.x	fp0,fp4
		fmove.s	fp5,(a4)+	;*imagk++ = resimag;
		fadd.x	fp6,fp5
		fsub.x	fp0,fp4
		fadd.x	fp6,fp5
		fmove.s	fp4,(a5)+	;*realkN2++ = resreal - treal - treal;
		fmove.s	fp5,(a6)+	;*imagkN2++ = resimag + timag + timag;
		dbf	d7,trivial2loop$

		lsl	#2,d3
		;----------- langsamer Teil der Hauptschleife ------------------
;		 // outerloop 2, 1 bis N/4 mal durchlaufen
slow_outerloop$
		lea	(a2,d1.w*2),a2	;realk = data + k
		lea	(a4,d1.w*2),a4	;imagk = data + k
		lea	(a2,d1.w*2),a5	;realkN2 = realk + N2
		lea	(a4,d1.w*2),a6	;imagkN2 = imagk + N2

;		 // innerloop, N/2 bis 1 mal durchlaufen
					;for( i = 0; i < N2; i++)
		move	d1,d7		;d1 sichern, somit DBF-Schleife mglich.
		lsr	#1,d7		;
		subq	#1,d7		;Schleife fr I bis N2

;		move.l	(a3)+,d5	;sin<<16 + cos
slowloop$				;Standardfall mit variablen sin/cos-Werten
		fmove.s	(a5),fp0	;*realkN2
		fmove.s	(a6),fp6	;*imagkN2
		fmove.x	fp0,fp4
		fmul.s	4(a3),fp0	;*realkN2 * cos
		fmove.x	fp6,fp2
		fmul.s	4(a3),fp6	;*imagkN2 * cos
;		swap	d5		;cos<<16 + sin
		fmul.s	(a3),fp4	;*realkN2 * sin
		fmul.s	(a3),fp2	;*imagkN2 * sin

		fadd.x	fp2,fp0		;treal = (*realkN2 * *cos1 + *imagkN2 * *sin1);
		fsub.x	fp4,fp6		;timag = *imagkN2 * *cos1 - *realkN2 * *sin1;
		fmove.s	(a4),fp2	;*imagk
;		asr.l	#FFT_SinBase/2,d0	;Integer Shift
;		asr.l	#FFT_SinBase/2,d0	;Integer Shift
		fmove.s	(a2),fp4		;*realk
;		asr.l	#FFT_SinBase/2,d6	;Integer Shift, Tabellen um 2^8 verschoben
;		asr.l	#FFT_SinBase/2,d6	;Integer Shift, Tabellen um 2^8 verschoben

		fadd.x	fp0,fp4		;resreal = *realk + treal;
		fmove.s	fp4,(a2)+	;*realk++ = resreal;
		fsub.x	fp0,fp4
		fadd.x	fp6,fp2		;resimag = *imagk + timag
		fsub.x	fp0,fp4
		fmove.s	fp2,(a4)+	;*imagk++ = resimag;
		fmove.s	fp4,(a5)+	;*realkN2++ = resreal - treal - treal;
		fsub.x	fp6,fp2
;		swap	d5		;sin<<16 + cos
		fsub.x	fp6,fp2
		fmove.s	fp2,(a6)+	;*imagkN2++ = resimag - timag - timag;

		dbf	d7,slowloop$

		addq.l	#8,a3

		add	d1,d3		;k+= N2<<1;
		add	d1,d3		;

		cmp	#FFT_N*2-1,d3	;while( k < N )
		blt.w	slow_outerloop$

		swap	d7
		move.w	d7,d2
		lsr	#1,d1		;N2 >>= 1;
		dbf	d2,Outerloop$	;NU1=NU1-1 -> bis NU1 = 0,umlaufen, bei <0 fertig

;-------------- Folge 1 und Folge 2 trennen, Bitreverse bercksichtigen  ---------------------
;hllisch langsam, wird aber in diesem Programm nur 32 mal durchlaufen...

		lea	FFT_Realtab,a0
		lea	FFT_Imgtab,a1
		lea	FFT_OutTable,a2
		lea	FFT_OutTableI,a4

		lea	SinTab2,a3
		lea	CosTab2,a5

		moveq	#1,d0
		move	#FFT_N-1,d1

		move.l	(a0),d2
		add.l	(a1),d2
		move	d2,(a2)+		;Gleichanteil
		clr	(a4)+			;=Real(0)+Imag(0)

		lea	Bitreversetab,a6	;Tabellen fr IBR(M)
trennen$
		move	(a6,d0.w*2),d6
		move	(a6,d1.w*2),d7

		fmove.s	(a0,d6.w*4),fp2		;Xreal(n)
		fmove.s	(a0,d7.w*4),fp3		;Xreal(N-n)

		fmove.s	(a1,d6.w*4),fp4		;Ximag(n)
		fmove.s	(a1,d7.w*4),fp5		;Ximag(N-n)

		fmove.l	fp2,d2
		fmove.l	fp3,d3
		fmove.l	fp4,d4
		fmove.l	fp5,d5

		asr.l	#5,d2			;alle durch
		asr.l	#5,d3			; 2 dividieren, hier noch
		asr.l	#5,d4			; ein paar bit mehr wg. 
		asr.l	#5,d5			; Genauigkeitserweiterung

		add	d3,d2			;R(n)+R(N-n)
		move.w	d2,(a2)
		sub	d3,d2
		sub	d3,d2			;R(n)-R(N-n)
		move	d2,d3			;R(n)-R(N-n)

		ext.l	d2
		ext.l	d3
		muls.l	(a3,d0.w*4),d2		;sin n/N * ( R(n)-R(N-n) )
		muls.l	(a5,d0.w*4),d3		;cos n/N * ( R(n)-R(N-n) )
		asr.l	#FFT_Sinbase/2,d2
		asr.l	#FFT_Sinbase/2,d2
		asr.l	#FFT_Sinbase/2,d3
		asr.l	#FFT_Sinbase/2,d3
		sub	d2,(a2)

		clr	(a4)
		sub	d3,(a4)			;-[ cos n/N * ( R(n)-R(N-n) ) ]

		sub.l	d5,d4			;I(n)-I(N-n)
		add	d4,(a4)			;+I(n)-I(N-n)
		add.l	d5,d4
		add.l	d5,d4			;I(n)+I(N-n)
		move.l	d4,d5

		ext.l	d4
		ext.l	d5
		muls.l	(a3,d0.w*4),d4		;sin n/N * ( I(n)+I(N-n) )
		muls.l	(a5,d0.w*4),d5		;cos n/N * ( I(n)+I(N-n) )
		asr.l	#FFT_Sinbase/2,d4
		asr.l	#FFT_Sinbase/2,d4
		asr.l	#FFT_Sinbase/2,d5
		asr.l	#FFT_Sinbase/2,d5
		sub	d4,(a4)+		;-[ sin n/N * ( I(n)+I(N-n) ) ]

		add	d5,(a2)+		;+[ cos n/N * ( I(n)+I(N-n) ) ]

		subq	#1,d1
		addq	#1,d0

		ifne	FFT_ShowLess
		cmp	#FFT_ShowLess+2,d0
		else
		cmp	#FFT_N,d0
		endc
		blt.w	trennen$

;		move	(a0),d2			;Xr(0)
;		move	(a1),d4			;Xi(0)
;		sub	d4,d2			;Xr(0)-Xi(0)
;		lea	OutTab1R(pc),a0		;Xr(0)+Xi(0)
;		sub	(a0),d2			;Xr(0)-Xi(0)-(Xr(0)+Xi(0))

		move.l	(a1),d4
		add	d4,d4
		neg	d4
		move	d4,(a2)+
		clr	(a4)+
;		clr	(a2)+

	ENDC

;------------------------------ Power-Spektrum bilden ---------------------------------------

		lea	FFT_OutTable+6,a0
		lea	FFT_OutTableI+6,a1
		lea	FFT_Analyzertab,a2
		lea	FFT_OutTable,a3
		lea	FFT_Emphasistable,a4

		ifne	FFT_ShowLess
		moveq	#FFT_ShowLess-1,d0
		else
		move	#FFT_N+1-1,d0
		endc
		clr	d3
power$
		move	(a0),d1
		tst.w	d1
		bge.s	.hi
		neg	d1
.hi
;		muls	d1,d1
		move	(a1)+,d2
		tst.w	d2
		bge.s	.hi2
		neg	d2
.hi2
;		muls	d2,d2
		add.w	d1,d2
		ext.l	d2
		mulu.l	(a4)+,d2
		swap	d2

		moveq	#19,d3
		cmp	#FFT_Analyzertabsize,d2
		bhs.s	set$

;		lea	AnalyzerTab2(pc),a2	;Testroutine
;		moveq	#16-1,d1
;loop$
;		cmp.w	(a2)+,d2	;aktueller Wert kleiner als Schwellwert fr entsprechenden Dezibelwert ?
;		blt.s	found$
;		addq	#1,d3
;		dbf	d1,loop$
;found$

		move.b	(a2,d2.w),d3
set$
		move.w	d3,(a3)+

		dbf	d0,power$
End$
		Pop	all
		rts
;--------- UPS-Struktur auswerten, Stimmen mixen und auf Real/Imgtabelle aufteilen  -----------
FFT_MixVoices:
		Push	all
	ifne	Eagleplayer			;fr Tests beim "Eagleplayer" Flag aus

		move.b	FFT_slowid(A5),d0		;nur jedes 2. oder 3. Frame etwas ausgeben ?
		addq.b	#1,d0
		cmp.b	FFT_slowcount(a5),d0	;<- wird erst beim ffnen des Fensters gesetzt
						;   auf momentan 1-3
		blt.s	lo$
	endc
		moveq	#0,d0
lo$		move.b	d0,FFT_slowid(a5)

	ifne	Eagleplayer

		beq.s	lo1$			;ausfhren der Darstellung, ansonsten ggfalls UPSDaten auswerten
		
		tst.b	SpecialUPS(A5)		;UPS vom Amplifier ?
		bne	skipmix$		;ja, also brauchen wir nix tun
lo1$
		move.l	FFT_Structadr(a5),a4	;Analyzer Struktur

		moveq	#%0101,d2		;wenn schon gemixte Daten vom Amplifier vorliegen
		tst.b	SpecialUPS(A5)		;dann werden diese beiden Kanle benutzt anstelle
		bne.s	nodmacon$		;da vorher noch die 4 Kanle der UPS Struktur
						;zusammengemixed werden mssen, spart Zeit

		moveq	#-1,d2			;Alle Kanle, wenn DMAon/off nicht unterstzt vom
						;Replay
		move.w	ups_flags(a4),d1
		and.w	#UPSB_Dmacon,d1		;Kanle an/aus untersttzt ?
		beq.s	nodmacon$

		move.w	UPS_Dmacon(a4),d2	;Ja,zugehrige Werte ranholen

			;Bitabfolge ndern wegen anderer Abfragereihenfolge der Kanle in dieser
			;Engine (Stimmen 1,4,2,3 wg. 1&4 = links, 2&3=rechts)
		move	d2,d0
		move	d2,d1
		and	#1,d2		;Bit 0 -> Bit 0

		lsr	#2,d0
		and	#2,d0
		or	d0,d2		;Bit 3 -> Bit 1

		and	#%0110,d1
		lsl	#1,d1
		or	d1,d2		;(Bit 1 und 2) << 1
nodmacon$
		lea	FFT_vol64(pc),a2		;fr den Fall, da "Mastervolume" ausgeschaltet

		move.l	myEPBase(pc),a4
		lea	EPG_someprefs(a4),a4
		move.l	(a4),d6
		and.l	#EGPRB_MasterVolume,d6 ;Mastervolume switch im EP an ?
		beq.s	.NoMaster

		move.l	myEPBase(pc),a2
		lea	EPG_Voice1vol(a2),a2	;ok, Lautstrkewerte der einzelnen Stimmen verwenden
.NoMaster

		lea	FFT_Permerk(a5),a3	;SamplePeriod merken und Spielzeit der Samples in 1/50 Sekunden
					;je 32 Bit = 1LW pro Kanal

		move.l	FFT_Structadr(a5),a4	;Analyzer Struktur
		bsr	GetADRLENVOLandPER	;Daten Channel 1 holen

		tst.b	FFT_slowid(A5)		;nur jedes 2. oder 3. Frame was tun ?
		bne.s	nomix1$
		lea	FFT_Realtab,a6		;Zieladresse = Eingangswerte der FFT,
						;Reihe 1
		bsr	FFT_ClearArea
		bsr	FFT_Mixit			;Mixen von Channel 1 und 2 bzw. nur Zoom wenn 
						;lediglich ein Channel
nomix1$

		addq.l	#4,a3
		move.l	FFT_Structadr(a5),a4	;Analyzer Struktur
		lea	UPS_Modulo*3(a4),a4	;4. Stimme
		bsr	GetADRLENVOLandPER	;Daten Channel 2 holen

		tst.b	FFT_slowid(A5)		;nur jedes 2. oder 3. Frame was tun ?
		bne.s	nomix2$
		lea	FFT_Realtab,a6		;Zieladresse = Eingangswerte der FFT,
						;Reihe 1
		bsr	FFT_Mixit			;Mixen von Channel 1 und 2 bzw. nur Zoom wenn 
						;lediglich ein Channel
nomix2$

skiphim1$

		addq.l	#4,a3
		move.l	FFT_Structadr(a5),a4	;Analyzer Struktur
		lea	UPS_Modulo*1(a4),a4	;2. Stimme
		bsr	GetADRLENVOLandPER

		tst.b	FFT_slowid(A5)		;nur jedes 2. oder 3. Frame was tun ?
		bne.s	nomix3$
		bsr	FFT_Mixit			;Mixen von Channel 1 und 2 bzw. nur Zoom wenn 
						;lediglich ein Channel
nomix3$
		addq.l	#4,a3
		move.l	FFT_Structadr(a5),a4	;Analyzer Struktur
		lea	UPS_Modulo*2(a4),a4	;3. Stimme
		bsr	GetADRLENVOLandPER

		tst.b	FFT_slowid(A5)		;nur jedes 2. oder 3. Frame was tun ?
		bne.s	nomix4$
		bsr	FFT_Mixit			;Mixen von Channel 1 und 2 bzw. nur Zoom wenn 
						;lediglich ein Channel

		lea	FFT_Imgtab,a4

		tst.b	SpecialUPS(A5)		;dann werden diese beiden Kanle benutzt anstelle
		bne.s	scale2$			;da vorher noch die 4 Kanle der UPS Struktur

		bsr	FFT_ScaleInputs		;Zum Schlu Werte*64 um 6 Bit nach rechts shiften 
						;und in FFT_Realtab und FFT_Imgtab aufteilen fr N/2 FFT
						;reeller Eingangswerte
		bra.s	weiter$
scale2$
		bsr	FFT_ScaleInputs2
weiter$
nomix4$
skipmix$
	else
;--------------------------------- Testroutine -------------------------------------------
		bsr	MakeIntab		;Beispielwerte erzeugen

		lea	Testtab1,a0		;Adresse Daten Kanal 1
		move	#256,d0			;Lnge Kanal 1 (derzeit noch nicht ausgewertet)
		move	#112,d3			;Period Kanal 1
		move	#64,d1			;Lautstrke Kanal 1

		lea	FFT_Realtab,a6		;Zieladresse
		bsr	FFT_ClearArea
		bsr	FFT_Mixit			;2 aus einen zusammenmixen

		lea	Testtab1,a0		;Adresse Daten Kanal 1
		move	#256,d0			;Lnge Kanal 1 (derzeit noch nicht ausgewertet)
		move	#20,d3			;Period Kanal 1
		move	#64,d1			;Lautstrke Kanal 1

		lea	FFT_Realtab,a6		;Zieladresse
		bsr	FFT_Mixit			;2 aus einen zusammenmixen

		lea	Testtab2,a0
		move	#256,d0
		move	#112,d3
		move	#64,d1
		bsr	FFT_Mixit			;2 aus einen zusammenmixen

		lea	Testtab2,a0
		move	#256,d0
		move	#224,d3
		move	#64,d1			;
		bsr	FFT_Mixit
		lea	FFT_Imgtab,a4

		tst.b	SpecialUPS(A5)		;dann werden diese beiden Kanle benutzt anstelle
		bne.s	scale2$			;da vorher noch die 4 Kanle der UPS Struktur
		bsr	FFT_ScaleInputs
		bra.s	weiter$
scale2$
		bsr	FFT_ScaleInputs2
weiter$
	endc
		Pop	all
		rts
;------------------------------------------------------------------------------------------------
;----                                Mixt 2 Stimmen zusammen                                 ----
;------------------------------------------------------------------------------------------------
;Input:
; a0 - Stimme 1 aktuelle Adresse
; d0 - Stimme 1 Restlnge (momentan ignoriert)
; d3 - Stimme 1 Period
; d1 - Stimme 1 Lautstrke (0..64)
; a6 - Zieladresse
; Vtab           - Lautstrketabelle
; Mixfrequency.l - 16384*Per
; Current_Num    - Anzahl der auszugebenden Samplewerte
FFT_Mixit:
		push	all
		move.l	a0,d2
		beq.s	none$

		move.l	FFT_Mixfrequency(a5),d7	;16384*Sampleper (Achtung: erst bei offenem Fenster richtig gesetzt!)
		move.l	d7,d2
		divu 	d3,d2			;Period Kanal 2
		moveq	#0,d3
		move.w	d2,d3
		add.l	d3,d3
		add.l	d3,d3
		swap	d3			;gebrochene Zahl fr die Skalierung beim Mixen

;------------------------ Skalieren (Samplerate+Lautstrke) von 1 Kanal  ---------------------------
		lea	FFT_Windowtable,a1
		moveq	#0,d6
		moveq	#0,d5			;Zhler fr Offset
		moveq	#0,d2			;Dummy fr addx Befehl
						;D0-Lnge Kanal 2
						;D3-Skalierung Kanal 2
						;A3-Voltab 1
;		move	#N/2-1,d7
		move	FFT_Current_Num(a5),d7	;N
		lsr	#1,d7			;/2
		subq	#1,d7			;-1

		move	d1,d0
FFT_Mixit2$
		move	(a1)+,d1
		move.b	(a0,d5.w),d6
		mulu	d0,d1
		add.l	d3,d5
		swap	d1
		ext.w	d6
		addx	d2,d5
		muls	d1,d6			;Wert mal Lautstrke
		add	d6,(a6)+

		move	(a1)+,d1
		move.b	(a0,d5.w),d6
		mulu	d0,d1
		add.l	d3,d5
		swap	d1
		ext.w	d6
		addx	d2,d5
		muls	d1,d6			;Wert mal Lautstrke
		add	d6,(a6)+
		dbf	d7,FFT_Mixit2$
none$
		pop	all
		rts
;Input:
; A6          - Adresse
; Current_Num - Lnge
FFT_ClearArea:
		push	d7/a6
		move	FFT_Current_Num(a5),d7	;N (Anzahl der Wrter)
		lsr	#1,d7			;/2
		subq	#1,d7			;-1
clr$		clr.l	(a6)+
		dbf	d7,clr$
		pop	d7/a6
		rts
;
;gemixte Werte skalieren und in FFT-Eingangstabellen fr Real-und Imaginrteil aufsplitten
;bei 4 Kanlen wird auf Werte von max. -256 bis 255 skaliert
; 
;Input:
; A6          - Adresse FFT_Realtab
; A4          - Adresse FFT_Imgtab
; Current_Num - Lnge
FFT_ScaleInputs:				;Zum Schlu Werte*64 um 7 Bit nach rechts shiften
		push	all
		move	FFT_Current_Num(a5),d7	;N (Anzahl der Wrter)
		lsr	#2,d7			;durch 4
		subq	#1,d7

		lea	(A6),a0
loop$
		movem.w	(a6)+,d0-d3
		asr.l	#3,d0
		asr.l	#3,d2
		asr.l	#3,d1
		asr.l	#3,d3
		movem.l	d0/d2,(a0)		;1./3. Wort
		movem.l	d1/d3,(a4)		;2./4. Wort

		addq.l	#8,a0			;2 LWrter berspringen
		addq.l	#8,a4			;2 LWrter berspringen
		dbf	d7,loop$
		pop	all
		rts
;2 Kanle auf -2048...2048 skalieren
FFT_ScaleInputs2:				;Zum Schlu Werte*64 um 6 Bit nach rechts shiften
		push	all
		move	FFT_Current_Num(a5),d7	;N (Anzahl der Wrter)
		lsr	#2,d7			;durch 4
		subq	#1,d7

		lea	(A6),a0
loop$
		movem.w	(a6)+,d0-d3
		asr.l	#2,d0
		asr.l	#2,d2
		asr.l	#2,d1
		asr.l	#2,d3
		movem.l	d0/d2,(a0)		;1./3. Wort
		movem.l	d1/d3,(a4)		;2./4. Wort

		addq.l	#8,a0			;2 LWrter berspringen
		addq.l	#8,a4			;2 LWrter berspringen
		dbf	d7,loop$
		pop	all
		rts
;-------------- Erzeugen der logarithmischen Umrechnungstsabelle -----------------------
MakeAnalyzertab:
		push	all
		lea	AnalyzerTab2,a0
		lea	FFT_Analyzertab,a1

		move	#FFT_Analyzertabsize-1,d0
		moveq	#0,d2
		moveq	#0,d1
loop$
		cmp.w	(a0),d1
		blt.s	noadd$
		addq	#1,d2
		addq.l	#2,a0
noadd$
		addq	#1,d1
		move.b	d2,(a1)+
		dbf	d0,loop$

		pop	all
		rts
;----------------------- Erzeugen der Bitspiegelungstabelle ----------------------------
MakeBitreversetabs:
		lea	Bitreversetab,a0
		move	#FFT_N-1,d5
		moveq	#FFT_Gamma,d6		;Anzahl der Bits
		moveq	#0,d1
Innerloop1$
		moveq	#0,d3
		move	d1,d2
		move	d6,d7
		subq	#1,d7
Innerloop2$
		roxr	#1,d2
		roxl	#1,d3
		dbf	d7,Innerloop2$
		move	d3,(a0)+

		addq	#1,d1
		dbf	d5,Innerloop1$
		rts
;----------------------- Erzeugen der Sinus-und Cosinustabelle ----------------------------------
;-- die Werte werden gleich bitgespiegelt berechnet, so da die Bitspiegelung zur Adressierung --
;-- der Sinus-bzw. Cosinustabelle entfllt                                                     --
;-- Formel: SINBASE*sin(2*P/GAMMA); P=Bitspiegelung(I); 0<I<N                                 --
;------------------------------------------------------------------------------------------------
;Input:  d1 = Tiefe der FFT: (8 = 256 Punkt, 9 = 512 Punkt usw.)
;        Bitreversetab = Butterflytab (Bitspiegelungstabelle)
;Output: SinCostab = kombinierte Sinus/Cosinustabelle, jedem Wort der Sinuswerte folgt
;                    das Cos-Pendant
;        Berechnung lediglich mit halber Lnge, da jeder 2. Wert ohnehin redundant
MakeSinCostabs:
	IFNE	USEFPU
		Push	All

		lea	SinCostab,a0
		lea	Bitreversetab,a2

		move	#FFT_N/2-1,d0		;nur die Hlfte der Sin/Cos Werte werden wirklich gebraucht, der Rest eh sonst bersprungen
		moveq	#0,d1
sincostab$
		move	(a2,d1.w*2),d3		;P=IBR(M)

		fmove.w	d3,fp1

	if	FFT_Gamma=6
		fmul.x	#6.283185/2^6,fp1	;hier statt 8 "GAMMA" eintragen, sch.. ASM-One
	else
	if	FFT_Gamma=7
		fmul.x	#6.283185/2^7,fp1	;hier statt 8 "GAMMA" eintragen, sch.. ASM-One
	else
	if	FFT_Gamma=9
		fmul.x	#6.283185/2^9,fp1	;hier statt 8 "GAMMA" eintragen, sch.. ASM-One
	else
	if	FFT_Gamma=8
		fmul.x	#6.283185/2^8,fp1	;hier statt 8 "GAMMA" eintragen, sch.. ASM-One
	else
		Fehler in Gamma !
	endc
	endc
	endc
	endc

		fmove.x	fp1,fp2
		fsin.x	fp1
;		fmul.x	#256,fp1		;sinbase
;		fmul.x	#4096,fp1		;sinbase
		fcos.x	fp2
;		fmul.x	#256,fp2		;sinbase
;		fmul.x	#4096,fp2		;sinbase
;		fmove.l	fp1,d2
;		move.l	d2,(a0)+		;sin
		fmove.s	fp1,(a0)+

;		fmove.l	fp2,d2
;		move.l	d2,(a0)+		;cos
		fmove.s	fp2,(a0)+

		addq	#2,d1		
		dbf	d0,sincostab$
		Pop	All
		rts
	ELSE
		push	d0-d7/a0-a6
		moveq	#FFT_Gamma,d1

		moveq	#1,d7			;1
		lsl	d1,d7			;2^Gamma
		move.l	d7,d6			;=N
		lsr	#1,d7
		subq	#1,d7			;N-1 wg. dbf

		lea	SinCostab,a1
		lea	Bitreversetab-SinCostab(a1),a2

		move.l	mathtrans(a5),a3
		move.l	mathffp(a5),a4

		move.l	a4,a6
		move.l	#6283185,d0		;2**10^6
		jsr	_LVOSPFlt(a6)
		move.l	d0,d4

		move.l	#1000000,d0
		jsr	_LVOSPFlt(a6)		;10^6
		move.l	d0,d1

		move.l	d4,d0
		jsr	_LVOSPDiv(a6)		;2
		move.l	d0,d5

		move.l	d6,d0
		jsr	_LVOSPFlt(a6)		;N
		move.l	d0,d1

		move.l	d5,d0
		jsr	_LVOSPDiv(a6)		;2/N
		move.l	d0,d5

		move.l	#2^FFT_SINBASE,d0	;256
		jsr	_LVOSPFlt(A6)
		move.l	d0,d6

		moveq	#0,d4
sincostab1$
		moveq	#0,d0
		move	(a2,d4.w*2),d0		;P=IBR(M)
		move.l	a4,a6
		jsr	_LVOSPFlt(A6)		;in FFP umwandeln
		move.l	d5,d1			;2/N
		jsr	_LVOSPMul(a6)		;2/N*P
		move.l	d0,d3
		move.l	a3,a6
		jsr	_LVOSPSin(a6)		;sin(2*P/N)
		move.l	d6,d1
		move.l	a4,a6
		jsr	_LVOSPMul(A6)		;256*sin(...)
		jsr	_LVOSPFix(a6)
		move.l	d0,(a1)+		;sin*256

		move.l	d3,d0
		move.l	a3,a6
		jsr	_LVOSPCos(a6)		;cos(2*P/GAMMA)
		move.l	d6,d1
		move.l	a4,a6
		jsr	_LVOSPMul(A6)		;256*cos(...)
		jsr	_LVOSPFix(a6)
		move.l	d0,(a1)+		;cos*256

		addq	#2,d4		
		dbf	d7,sincostab1$

		pop	d0-d7/a0-a6
		rts
	ENDC
;----------------------- Erzeugen der Sinus-und Cosinustabelle ----------------------------------
;-- die Werte werden gleich bitgespiegelt berechnet, so da die Bitspiegelung zur Adressierung --
;-- der Sinus-bzw. Cosinustabelle entfllt                                                     --
;-- Formel: SINBASE*sin(2*P/GAMMA); P=Bitspiegelung(I); 0<I<N                                 --
;------------------------------------------------------------------------------------------------
;Input:  d1 = Tiefe der FFT: (8 = 256 Punkt, 9 = 512 Punkt usw.)
;        Bitreversetab = Butterflytab (Bitspiegelungstabelle)
;Output: SinCostab = kombinierte Sinus/Cosinustabelle, jedem Wort der Sinuswerte folgt
;                    das Cos-Pendant
MakeSinCostabs2:
		push	d0-d7/a0-a6
		moveq	#FFT_Gamma,d1

		moveq	#1,d7			;1
		lsl	d1,d7			;2^Gamma
		move.l	d7,d6			;=N
		subq	#1,d7			;N-1 wg. dbf

		lea	Sintab2,a1
		lea	Costab2,a2

		move.l	mathtrans(a5),a3
		move.l	mathffp(a5),a4

		move.l	a4,a6
		move.l	#3141592,d0		;*10^6
		jsr	_LVOSPFlt(a6)
		move.l	d0,d4

		move.l	#1000000,d0
		jsr	_LVOSPFlt(a6)		;10^6
		move.l	d0,d1

		move.l	d4,d0
		jsr	_LVOSPDiv(a6)		;2
		move.l	d0,d5

		move.l	d6,d0
		jsr	_LVOSPFlt(a6)		;N
		move.l	d0,d1

		move.l	d5,d0
		jsr	_LVOSPDiv(a6)		;2/N
		move.l	d0,d5

		move.l	#2^FFT_SINBASE,d0	;256
		jsr	_LVOSPFlt(A6)
		move.l	d0,d6

		moveq	#0,d4
sincostab$
		moveq	#0,d0
		move	d4,d0

		move.l	a4,a6
		jsr	_LVOSPFlt(A6)		;in FFP umwandeln
		move.l	d5,d1			;2/N
		jsr	_LVOSPMul(a6)		;2/N*P
		move.l	d0,d3
		move.l	a3,a6
		jsr	_LVOSPSin(a6)		;sin(2*P/N)
		move.l	d6,d1
		move.l	a4,a6
		jsr	_LVOSPMul(A6)		;256*sin(...)
		jsr	_LVOSPFix(a6)
		move.l	d0,(a1)+		;sin*256

		move.l	d3,d0
		move.l	a3,a6
		jsr	_LVOSPCos(a6)		;cos(2*P/GAMMA)
		move.l	d6,d1
		move.l	a4,a6
		jsr	_LVOSPMul(A6)		;256*cos(...)
		jsr	_LVOSPFix(a6)
		move.l	d0,(a2)+		;cos*256

		addq	#1,d4		
		dbf	d7,sincostab$

		pop	d0-d7/a0-a6
		rts

	ifeq	Eagleplayer
;-------------------------- Testroutine ----------------------------------------
MakeIntab:	
		lea	Testtab1,a0
		lea	Testtab2,a1

		moveq	#83,d0			;Rechteckimpuls
.w1		move.b	#127,(a1)+
		dbf	d0,.w1

		move	#0,(a1)+

		moveq	#83,d0
.w2		move.b	#-128,(a1)+
		dbf	d0,.w2

		move	#0,(a1)+

		moveq	#84,d0
.w3		move.b	#127,(a1)+
		dbf	d0,.w3

		move	#256-1,d0
		moveq	#0,d1
		moveq	#0,d3
sincostab$					;3 Sinuswellen erzeugen
		fmove.w	d1,fp1
		fmul.x	#6.283185/2^3,fp1	;Frequenz
		fsin.x	fp1
		fmul.x	#128,fp1			;Amplitude

		fmove.w	d1,fp2
		fmul.x	#6.283185/2^5,fp2	;Frequenz
		fsin.x	fp2
		fmul.x	#32,fp2			;Amplitude
;		fadd.x	fp2,fp1

;		fmove.w	d1,fp2			;ein paar Sinuswellen versch.
;		fmul.x	#6.283185/2^4,fp2	;Frequenz zum rumspielen
;		fsin.x	fp2
;		fmul.x	#32,fp2
;		fadd.x	fp2,fp1

		fmove.w	d1,fp2			;nochn Sinus
		fmul.x	#6.283185/2^3,fp2	;
		fsin.x	fp2
		fmul.x	#64,fp2
		fadd.x	fp2,fp1

		fmove.w	fp1,d2
		add	d3,d2			;RechteckWelle maximaler Frequenz

		move.b	d2,(a0)+
;		move.b	d2,(a0)+

		neg.w	d3
		addq	#1,d1		
		dbf	d0,sincostab$
		rts
Testtab1		ds.w	1024		;fr Inputwerte bei Testroutine
Testtab2		ds.w	1024		;fr Inputwerte bei Testroutine
	endc

;****************************************************************************************
;*                   Blinkanzeige fr Laden/Speichern gepackter Mods                    *
;****************************************************************************************
InitCrunchDisplay:
		Push	d1-a6
		bsr	CloseTray

		lea	Datas,a5

		moveq	#ID_LoadingLED,d0
		bsr	FindObject		;Objekt in Liste finden
		beq	error$		
		move.l	d0,a0
		clr.l	MOL_UserData(a0)

		Pop	d1-a6
		moveq	#0,d0
		rts
error$
		Pop	d1-a6
		moveq	#-1,d0
		rts
CrunchDisplay:
		Push	d1-a6

		lea	Datas,a5

		moveq	#ID_LoadingLED,d0
		bsr	FindObject		;Objekt in Liste finden
		beq	error$		
		move.l	d0,a0
		move.l	MOL_UserData(a0),d1
		eor.l	#1,d1
		move.l	d1,MOL_UserData(a0)

		bsr	DisableFXTask

		moveq	#ID_LoadingLED,d0
		bsr	ShowPrefsChange

		bsr	EnableFXTask
error$
		Pop	d1-a6
		moveq	#0,d0			;kein Fehler...
		rts
EndCrunchDisplay:
		Push	d1-a6

		lea	Datas,a5

		moveq	#0,d1
		moveq	#ID_LoadingLED,d0
		bsr	ShowPrefsChange

		Pop	d1-a6
		moveq	#0,d0			;kein Fehler...
		rts

;*************************************************************************************
;*                        Prefsnderungen                                            *
;*************************************************************************************

;--------------------------------------------------------------------------------------
;Input: d1 = 0 -> default Image darstellen, sonst 2. Image
;       d0 = ID des zu suchenden Images
ShowPrefsChange:
		Push	All
		
		bsr	FindObject		;Objekt in Liste finden
		beq	Error$		
		move.l	d0,a0
		move.l	MOL_Images(a0),d2
		beq	Error$

		tst.l	d1
		beq	nosecond$

		move.l	d2,a1
		move.l	IML_Next(a1),d2		;2. Image vorhanden ?
		beq	Error$
nosecond$
		move	MOL_Left(a0),d0		;Xpos
		move	MOL_Top(a0),d1		;Ypos
		move.l	d2,a0			;Image
		suba.l	a1,a1			;def. Rastport
		bsr	ShowImage
Error$
		Pop	All
		rts

;-------------------------- nderung bei Fadein-Einstellung --------------------------
;Input:  -
;Output: -
HandleFadein:
	ifne	Eagleplayer
		move.l	myEPBase(pc),a1
		move.l	EPG_SomePrefs(a1),d1
		and.l	#EGPRB_Fadein,d1
	else
		move.l	#EGPRB_Fadein,d1	;testhalber "an" setzen
	endc
		moveq	#ID_FadeinLED,d0
		bsr	ShowPrefsChange
		rts
HandleRandom:
	ifne	Eagleplayer
		move.l	myEPBase(pc),a1
		move.l	EPG_SomePrefs(a1),d1
		and.l	#EGPRB_Randommodule,d1
	else
		move.l	#EGPRB_Randommodule,d1	;testhalber "an" setzen
	endc
		moveq	#ID_RandomLED,d0
		bsr	ShowPrefsChange
		rts
HandleSongend:
	ifne	Eagleplayer
		move.l	myEPBase(pc),a1
		move.l	EPG_SomePrefs(a1),d1
		and.l	#EGPRB_Songend,d1
	else
		move.l	#EGPRB_Songend,d1	;testhalber "an" setzen
	endc
		moveq	#ID_SongendLED,d0
		bsr	ShowPrefsChange
	rts
HandleFilter:
	ifne	Eagleplayer
		move.l	myEPBase(pc),a1
		moveq	#0,d1
		move.b	dtg_LED(a1),d1
	else
		moveq	#1,d1			;testhalber "an" setzen
	endc
		moveq	#ID_FilterLED,d0
		bsr	ShowPrefsChange
		rts
HandleTimeout:
	ifne	Eagleplayer
		moveq	#0,d1
		
		move.l	myEPBase(pc),a1
		move.l	EPG_Timeout(a1),d2
		ble	not$

		moveq	#ID_Timeout,d0
		bsr	FindObject
		beq	wei$
		move.l	d0,a0
		move.l	d2,MOL_UserData(a0)		;last timeout value
wei$
		moveq	#1,d1
not$
	else
		move.l	#1,d1				;testhalber "an" setzen
	endc

		moveq	#ID_TimeoutLED,d0
		bsr	ShowPrefsChange
		rts

;------------ Input: A0 - Pointer auf Objekt --------------------------------
ChangeRandom:
	ifne	Eagleplayer
		moveq	#3,d2			;default: set random

		move.l	myEPBase(pc),a1
		move.l	EPG_SomePrefs(a1),d1
		and.l	#EGPRB_Randommodule,d1
		beq.s	setran$
		moveq	#2,d2			;if random -> set loadnext
setran$
		move.l	MOL_Command(a0),d0
		moveq	#0,d1
	endc
		rts
;------------ Input: A0 - Pointer auf Objekt --------------------------------
ChangeTimeout:
	ifne	Eagleplayer
		moveq	#-1,d2

		move.l	myEPBase(pc),a1
		move.l	EPG_Timeout(a1),d1
		bgt	set0$

		move.l	MOL_UserData(a0),d2	;last timeout value
		bne	set0$
		move.l	#180,d2			;kein letzter Wert -> 180 sek. default
set0$
		move.l	MOL_Command(a0),d0
		moveq	#0,d1
	endc
		rts
;------------ Input: A0 - Pointer auf Objekt --------------------------------
HandleModname:
;		move.l	#MI_Songname,d0
;		bsr	FindMITag
		tst	d0
		bne	nix$

	ifne	Eagleplayer
		move.l	myEPBase(pc),a1
		tst.l	EPG_PlayerTagList(a1)
		beq	nix$
		move.l	EPG_Songname(a1),d0
		beq.s	nix$
	else
		bra.s	nix$
	endc

			lea	Modnametmp(a5),a0
			move.l	d0,a1
			moveq	#30-1,d1
copy$
			move.b	(a1)+,(a0)+
			dbeq	d1,copy$
			clr.b	(a0)
			bra	print$
nix$
			lea	Modnametmp(a5),a0
			clr.b	(a0)
print$
		lea	Modnametmp(a5),a0
		move.l	#ID_Textname1,d0
		bsr	PrintText
		rts		

;------------ Input: A0 - Pointer auf Objekt --------------------------------
TrackDisp1:
		tst	d0
		bne	naafing1$

	ifne	Eagleplayer
		move.l	myEPBase(pc),a4
		move.l	EPG_MODNr(a4),d0
		ble	naafing1$		;kein Module ?
		and.l	#$1fff,d0
		addq.l	#1,d0
	else
		moveq	#17,d0
	endc
		moveq	#4,d1
		lea	tracktmp1(a5),a0
		bsr	HexDez
		bra	next$
naafing1$
		lea	tracktmp1(a5),a0
		move.b	#`-`,(a0)+
		move.b	#`-`,(a0)+
		move.b	#`-`,(a0)+
		move.b	#`-`,(a0)+
next$
		move.b	#`/`,(a0)+
		clr.b	(a0)
		
		lea	tracktmp1(a5),a0
		move.l	#ID_TextTrack1,d0
		bsr	PrintText
		rts
;------------------------------------------------------------------------------------------
TrackDisp2:
	ifne	Eagleplayer
		move.l	myEPBase(pc),a4
;		move.l	EPG_MODS(a4),d0		;Anzahl der Files im aktuellen Verzeichnis
		move.l	EPG_Entries(a4),d0	;Anzahl aller Eintrge im aktuellen Verzeichnis
		ble	naafing1$		;keine Moduleliste ?
		and.l	#$1fff,d0
	else
		move.l	#752,d0
	endc
		moveq	#4,d1
		lea	tracktmp2(a5),a0
		bsr	HexDez
		bra	next$
naafing1$
		lea	tracktmp2(a5),a0
		move.b	#`-`,(a0)+
		move.b	#`-`,(a0)+
		move.b	#`-`,(a0)+
		move.b	#`-`,(a0)+
next$
		clr.b	(a0)
		
		lea	tracktmp2(a5),a0
		move.l	#ID_TextTrack2,d0
		bsr	PrintText
		rts
;------------ Input: A0 - Pointer auf Objekt --------------------------------
SubsongDisp:
	ifne	Eagleplayer
		move.l	myEPBase(pc),a4
		moveq	#0,d0
		move.w	EPG_SubSongs(a4),d0
		ble	naafing1$		;keine Subsongs ?
	else
		moveq	#1,d0
	endc
		lea	SubsongTmp+3(a5),a0
		move.b	#`/`,(a0)+
		moveq	#3,d1
		bsr	HexDez
		clr.b	(a0)
		bra	next$
naafing1$
		lea	SubsongTmp+3(a5),a0
		move.b	#`/`,(a0)+
		move.b	#`-`,(a0)+
		move.b	#`-`,(a0)+
		move.b	#`-`,(a0)+
		clr.b	(a0)+
next$
	ifne	Eagleplayer
		moveq	#0,d0
		move.w	dtg_SndNum(a4),d0
		ble	naafing2$		;keine Subsongs ?
	else
		moveq	#1,d0
	endc
		lea	SubsongTmp(a5),a0
		moveq	#3,d1
		bsr	HexDez
		bra	print$
naafing2$
		lea	SubsongTmp(a5),a0
		move.b	#`-`,(a0)+
		move.b	#`-`,(a0)+
		move.b	#`-`,(a0)+
print$
		lea	SubsongTmp2(a5),a0
		lea	Subsongname(pc),a1
copy1$		move.b	(a1)+,(a0)+
		bne.s	copy1$
		subq.l	#1,a0
		
		lea	SubsongTmp(a5),a1
copy2$		move.b	(a1)+,(a0)+
		bne.s	copy2$

		lea	SubsongTmp2(a5),a0
		move.l	#ID_TextSubsong1,d0
		bsr	PrintText
		rts
;------------ Input: A0 - Pointer auf Objekt --------------------------------
InitPatternDisp:
		tst	d0
		bne	keinepos2$

		move.l	#MI_Length,d0
		bsr	FindMITag
		beq.s	keinepos2$

		lea	PattTmp+3(a5),a0
		move.b	#`/`,(a0)+
		moveq	#3,d1
		bsr	HexDez
		clr.b	(a0)
		bra	PatternDisp
keinepos2$
		lea	PattTmp+3(a5),a0
		move.b	#`/`,(a0)+
		move.b	#`-`,(a0)+
		move.b	#`-`,(a0)+
		move.b	#`-`,(a0)+
		clr.b	(a0)
		bra	PatternDisp
;------------ Input: A0 - Pointer auf Objekt --------------------------------
PatternDisp:
		move.l	#EP_GetPositionNr,d0
		bsr	FindPlTag
		beq.s	keinepos$
		Push	d1-a6
		move.l	d0,a6
	ifne	Eagleplayer
		move.l	myEPBase(pc),a5
		moveq	#0,d0
		jsr	(a6)
	endc
		Pop	d1-a6

		lea	PattTmp(a5),a0
		moveq	#3,d1
		bsr	HexDez
		bra.s	disp$
keinepos$
		lea	PattTmp(a5),a0
		move.b	#`-`,(a0)+
		move.b	#`-`,(a0)+
		move.b	#`-`,(a0)+
disp$
		lea	PattTmp2(a5),a0
		lea	Patternname(pc),a1
copy1$
		move.b	(a1)+,(a0)+
		bne.s	copy1$
		subq.l	#1,a0
		
		lea	PattTmp(a5),a1
copy2$		move.b	(a1)+,(a0)+
		bne.s	copy2$

		lea	PattTmp2(a5),a0
		move.l	#ID_TextPattern1,d0
		bsr	PrintText
		rts
;------------ Input: A0 - Pointer auf Objekt --------------------------------
ShowSoundsys:
			lea	soundsystmp(A5),a0
			clr.b	(a0)

			tst	d0
			bne	noname$

		ifne	Eagleplayer
			move.l	myEPBase(pc),a2
			move.l	EPG_SoundSystemname(a2),d1
			beq	noname$
		else
			move.l	#aha2,d1
		endc
			move.l	d1,a1
			moveq	#30-1,d1
copy$
			move.b	(a1)+,(a0)+
			dbeq	d1,copy$

		ifne	Eagleplayer
			move.l	EPG_ActiveAmplifier(a2),d1
			beq	noamplifier$
		else
			bra	noamplifier$
		endc
			move.l	d1,a1
			move.l	EUS_UserName(a1),d1
			beq	noamplifier$
			move.l	d1,a1

			move.b	#` `,-1(a0)
			move.b	#`(`,(a0)+
			
			moveq	#32-1,d1
copy2$
			move.b	(a1)+,(a0)+
			dbeq	d1,copy2$
			move.b	#`)`,-1(a0)
noamplifier$

			clr.b	(a0)
noname$
			lea	soundsystmp(A5),a0
			move.l	#ID_TextSoundsys1,d0
			bsr	PrintText
			rts
;------------ Input: A0 - Pointer auf Objekt --------------------------------
HandlePauseLED:
		move.l	MOL_Images(a0),d2
		beq	noimage$

		move.l	MOL_UserData(a0),d0
		eor.l	#1,d0
		move.l	d0,MOL_UserData(a0)
		beq	nosecond$

		ifne	Eagleplayer
			move.l	myEPBase(pc),a1
			move.l	EPG_SomePrefs(a1),d1
			btst	#EGPRF_PausePlay,d1
			beq	nosecond$
		endc

		move.l	d2,a1
		move.l	IML_Next(a1),d2
		beq	noimage$
nosecond$
		move	MOL_Left(a0),d0		;Xpos
		move	MOL_Top(a0),d1		;Ypos
		move.l	d2,a0			;Image
		suba.l	a1,a1			;def. Rastport
		bsr	ShowImage
noimage$
		rts
;--------- Input: A0 - Pointer auf Objekt --------------------------------
HandlePlayLED:
		move.l	MOL_Images(a0),d2
		beq	noimage$

		move.l	MOL_UserData(a0),d0
		eor.l	#1,d0
		move.l	d0,MOL_UserData(a0)
		beq	nosecond$

		ifne	Eagleplayer
			move.l	myEPBase(pc),a1
			move.l	EPG_SomePrefs(a1),d1
			btst	#EGPRF_NowPlay,d1
			beq	nosecond$
		endc

		move.l	d2,a1
		move.l	IML_Next(a1),d2
		beq	noimage$
nosecond$
		move	MOL_Left(a0),d0		;Xpos
		move	MOL_Top(a0),d1		;Ypos
		move.l	d2,a0			;Image
		suba.l	a1,a1			;def. Rastport
		bsr	ShowImage
noimage$
		rts
;--------- Input: A0 - Pointer auf Objekt --------------------------------
HandleShowTime:
		lea	timetmp(A5),a0
		bsr	Createline$

		lea	timetmp(A5),a0
		move.l	#ID_TimeDisplay,d0
		bsr	PrintText
		rts
Createline$
	ifne	Eagleplayer
		move.l	EUS_Structure+EUS_EPBase(pc),a1
		tst.l	EPG_CurrentTime(a1)
		ble.s	def$

		move.l	Prefsflags(pc),d1
		and.l	#PFfag_TimeBackwards,d1		;Zeit rckwrts laufen lassen ?
		beq.s	normal$

		move.l	EPG_Duration(a1),d1		;berechnete Spielzeit in sec.
		ble.s	normal$
		move.b	#`-`,(a0)+
		
		sub.l	EPG_CurrentTime(a1),d1		;- gespielte Zeit
		bge	use$
		moveq	#0,d1				;falls ber die berechnete Zeit gespielt, -0 anzeigen
		bra	use$
normal$
		move.l	EPG_CurrentTime(a1),d1
	else
		move.l	#123,d1
	endc
use$
	divu	#60,d1
	move	d1,d0			;Minutes
	swap	d1			;Seconds
	and.l	#$ff,d1
	and.l	#$ffff,d0
	bsr	long$
	move.b	#`m`,(a0)+
	divu	#10,d1
	add.b	#`0`,d1
	move.b	d1,(a0)+
	swap	d1
	add.b	#`0`,d1
	move.b	d1,(a0)+
	move.b	#`s`,(a0)+
	clr.b	(A0)
	rts
def$	move.b	#`0`,(a0)+
	move.b	#`m`,(a0)+
	move.b	#`0`,(a0)+
	move.b	#`0`,(a0)+
	move.b	#`s`,(a0)+
	clr.b	(a0)
	rts
long$
	Push	d0-d4/a1
	moveq	#8,d1
	lea	dectable(pc),a1
	moveq	#0,d4
loopl$
	moveq	#-1,d3
	move.l	-(a1),d2
loop2l$
	addq.b	#1,d3
	sub.l	d2,d0
	bcc.s	loop2l$
	add.l	d2,d0
	cmp.l	#1,d2
	beq.s	okl$
	tst.b	d4
	bne.s	okl$
	tst.b	d3
	beq.s	nol$
okl$
	moveq	#1,d4
	add.b	#`0`,d3
	move.b	d3,(a0)+
nol$
	dbf	d1,loopl$
	Pop	d0-d4/a1
	rts
;-------------------------------------------------------------------------------
;- Input: d0 = Zahl
;-        d1 = Anzahl der Stellen, leading Zeroes nicht wegschneiden
;-        a0 = Puffer
;-------------------------------------------------------------------------------
HexDez:
	Push	d0-d7/a1
	lea	dectable2(pc),a1
	move	d1,d2
	lsl	#2,d2
	add.w	d2,a1			;Stelle raussuchen

	subq	#1,d1
loopl$
	moveq	#-1,d3
	move.l	-(a1),d2
loop2l$
	addq.b	#1,d3
	sub.l	d2,d0
	bcc.s	loop2l$
	add.l	d2,d0
	add.b	#`0`,d3
	move.b	d3,(a0)+
	dbf	d1,loopl$

	Pop	d0-d7/a1
	rts
dectable2:
	dc.l	1,10,100,1000,10000,100000,1000000,10000000,100000000
dectable:

;------------------------------------------------------------------------------------------------
;--------------- Restadresse, Restlnge, Lautstrke und Period-Wert aus der UPS-Struktur --------
;--------------- auslesen                                                                --------
;------------------------------------------------------------------------------------------------
;Input: d2 = DMA Mask (Bit 0 = dieser Kanal)
;       a3 = Zwischenspeicher fr Period und Spielzeit in 1/50 s des Samples des 
;            aktuellen Kanals (macht zwei Wrter)
;       a4 = UPS_Strukturanfang des aktuellen Kanals
;       a2 = Lautstrketabelle (Wrter, je eines pro Kanal, 0...64)
;            Wenn Mastervolumeuntersttzung nicht erwnscht, dann siehe unten
;
;Output:  d2 = DMA Mask fr nchsten Kanal (um 1 Bit gegenber Eingangswert nach rechts
;              geshiftet)
;         a2 = Pointer auf Lautstrke fr nchsten Kanal (Wort)
;         a3 (unverndert)
;         a4 (unverndert)
;         a0 = Adresse des Samples
;         d0 = Restlnge
;         d1 = Lautstrke
;         d3 = Period
GetADRLENVOLandPER:
		Push	d4
		suba.l	a0,a0

		lsr.w	#1,d2
		bcc.w	.no
		move.l	UPS_Voice1Adr(a4),d1
		beq.s	.null
		move.l	d1,A0
		move.w	UPS_Voice1Per(a4),d3
		beq.s	.ok
		move.w	d3,(a3)
		clr.w	2(a3)

		moveq	#0,d4
		moveq	#0,d0
		move.w	UPS_Voice1Len(a4),d0
		add.l	d0,d0		;Samplelnge Words -> Samplelnge Bytes
		bra.s	.cbm_ok		;bra.s	.copyto
.ok
		move	(a3),d3		;berhaupt keine Sampleperiod bergeben ?
		bne.s	.copyto
.null
		suba.l	a0,a0		;lea	nulls(a5),a0
		moveq	#0,d0		;move.w	#700,d0
		moveq	#0,d1
		bra.s	.no
.copyto
		moveq	#0,d0
		move.w	UPS_Voice1Len(a4),d0
		add.l	d0,d0		;Samplelnge Words -> Samplelnge Bytes

		moveq	#0,d4
		move.w	2(a3),d4
		cmp.w	#$180,d4	;nur zur Sicherheit
		blo.s	.hi1
		clr.w	2(A3)
		clr.w	d4
.hi1
		swap	d4		;=d4*65535
		lsr.l	#2,d4
		divu	(a3),d4		;durch Sampleperiod
		and.l	#$ffff,d4
		lsl.l	#2,d4
		cmp.l	d0,d4		;grer als Samplelnge ?
		blo.s	.cbm_ok

		tst.w	UPS_Voice1Repeat(a4)
		beq.s	.cbm_loop

		suba.l	a0,a0		;lea	nulls(a5),a0
		subq.w	#1,2(a3)
		clr.w	(a3)
		moveq	#0,d4
		moveq	#0,d0		;move.w	#700,d0
		bra.s	.cbm_ok
.cbm_loop
		tst.l	d0
		bne.s	.divu
		clr.w	2(a3)
		moveq	#0,d4
		move.w	#700,d0
		bra.s	.cbm_ok
.divu
		divu	d0,d4
		swap	d4
;		clr.w	2(a3)		;bloss raus lassen, dann sieht es
					;nochmal so gut aus !!
		and.l	#$ffff,d4
.cbm_ok
		add.l	d4,a0			;Sampleadr
						;D0: Samplelen
						;D3: SamplePer

		move.w	UPS_Voice1Vol(a4),d1	;

		mulu	(A2)+,d1		;Mastervolume
		lsr.w	#6,d1			;kann normalerweise auch rausgelassen werden

		cmp	#63,d1
		bls.s	.vol_ok
		moveq	#63,d1
.vol_ok
		addq.w	#1,2(a3)
.no
		Pop	d4
		rts
;********************************************************************************************
;*                                                                                          *
;*                                   Datenbereich                                           *
;*                                                                                          *
;********************************************************************************************
vol64	dc.w	64,64,64,64	;fr Behandlung der UPS Struktur (Analyzer, Levelmeter usw.)

;--------- Flags fr diese Engine und deren verschiedene Einstellungen  ---------------------

PFlag_Analyzer		EQU	1<<24	;1 - Analyzer an
PFlag_AnalyzerPos	EQU	1<<25	;1 - Analyzer oben
PFlag_Minimized		EQU	1<<26	;1 - nur Name / Powerschalter
PFlag_Remote		EQU	1<<27	;1 - Remote Control
PFfag_TimeBackwards	EQU	1<<28	;1 - Zeit rckwrts laufen lassen
PFlag_AnalyzerPower	EQU	1<<29	;1 - Analyzer an
PFlag_PaletteMode	EQU	1<<30	;1 - Allozierung der Farben im "Exakt" Modus
PFlag_CommandBar	EQU	1<<31	;1 - Untere Klappe geffnet

PFlag_AnalyzerSolid	EQU	1<<10	;Analyzer-Modi
PFlag_AnalyzerShower	EQU	1<<11	;
PFlag_AnalyzerHori	EQU	1<<12	;
PFlag_AnalyzerSeethrough EQU	1<<13	;
PFlags_Analyzer		EQU	1<<10!1<<11!1<<12!1<<13

myNR_ToggleFlag	EQU	EPNr_FirstExternal+1	;Prefsflag umkehren, in MOL_CMDArg1 Flag(s) als
                                                ;Langwort, in MOL_CMDArg2 Flags dazu, z.B.
                                                ;ob Windowrefresh (close/reopen) ntig

		BITDEF	TOGG,Winrefresh,0	;Winrefresh ja oder nein bei ToggleFlag
		BITDEF	TOGG,ChangeImages,1	;Palette ndern oder nicht

	*------ Menu -------*
GuiMenu:	dc.l	0			;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$52
		dc.l	0
		dc.l	.IText
		ds.b	6
		dc.l	SubItem1
		dc.l	0		*Kick2.0+ ??
.IText:		dc.w	3,0,0,1
		dc.l	0
		dc.l	SubItem.MSG
		dc.l	0
		dc.w	0			;No Nummer

	*----- SubItem 1 -----*
SubItem1:	dc.l	0			;Next
		dc.w	0			;Left Edge
		dc.w	0			;Verti Pos.
		dc.w	0			;Width-Size (Negationbreite)
		dc.w	10			;Hight-Size
		dc.w	$15b
		dc.l	0
		dc.l	.IText1
		ds.b	12
		dc.l	0			;*Kick2.0+ ??
.IText1:	dc.w	3,0,20,1
		dc.l	0
		dc.l	SubItem1.Msg
		dc.l	0	
		dc.w	MI_Precisionselect
		
	even
;---------------------------------------------------------------------------------------------
;-                         Tabelle fr Vblank-Messageverteiler                               -
;- 1. LW: ID des aufzurufenden Objekts (in `MOL_React` Pointer auf abzuarbeitende Routine)   -
;- 2. LW: Anzahl der abzuwartenden Ticks pro Aufruf                                          -
;---------------------------------------------------------------------------------------------
Interrupttable:
	ifeq	FXTask
		dc.l	ID_PlayIndicator,50
		dc.l	ID_PauseIndicator,50
		dc.l	ID_TimeDisplay,10
		dc.l	ID_TextPattern1,10
		dc.l	ID_Levelmeter,1
		dc.l	ID_Volumeknob2,40
		dc.l	ID_AnalyzerMap,0
		dc.l	0,0
	else
		dc.l	ID_PlayIndicator,30
		dc.l	ID_PauseIndicator,30
		dc.l	ID_TimeDisplay,8
		dc.l	ID_TextPattern1,7
		dc.l	ID_Levelmeter,0
		dc.l	ID_Volumeknob2,20
		dc.l	ID_AnalyzerMap,0
		dc.l	0,0
	endc
;---------------------------------------------------------------------------------------------
;-                  Tabelle fr Aktionen bei "NewModule"                                     -
;---------------------------------------------------------------------------------------------
NewModuletable:
	dc.l	ID_Textname1
	dc.l	ID_TextSoundsys1
	dc.l	ID_TextPatternInit1
	dc.l	ID_TextSubsong1
	dc.l	ID_TextTrack1
	dc.l	ID_TextTrack2
	dc.l	ID_TimeDisplay
	dc.l	ID_Speedknob
	dc.l	ID_AnalyzerLit
	dc.l	0

;---------------------------------------------------------------------------------------------
;-                  Tabelle fr Aktionen bei "Changeprefs"                                   -
;- 1. LW: PrefsItem                                                                          -
;- 2. LW: aufzurufende Routine                                                               -
;---------------------------------------------------------------------------------------------
NewPrefstable:
	dc.l	EPNr_FadeIn,HandleFadein
	dc.l	EPNr_ProgramMode,HandleRandom
	dc.l	EPNr_SongEnd,HandleSongend
	dc.l	EPNr_Filter,HandleFilter
	dc.l	EPNr_PlayTime,HandleTimeout
	dc.l	EPNr_SongName,HandleModname
	dc.l	EPNr_Prefix,HandleModname

	dc.l	EPNr_Volume,NewVolume
	dc.l	EPNr_Balance,NewBalance
	dc.l	EPNr_Speed,NewSpeed

	dc.l	EPNr_FirstExternal,LitAnalyzer
	dc.l	EPNr_FirstExternal,UpdateAnalyzerPrefs
	dc.l	EPNr_FirstExternal,HandleCommandBar ;untere Klapplade ffnen/schlieen, Gagdets enable/disable
	dc.l	0,0

;---------------------------------------------------------------------------------------------
;-                  Tabelle fr Aktionen bei "Changegui"                                     -
;- 1. LW: EPNr                                                                               -
;- 2. LW: interne ID des Objektes                                                            -
;- 3. LW: momentaner Zustand, 0 = enabled                                                    -
;---------------------------------------------------------------------------------------------
NewGuitable:
	dc.l	EPNr_NextModule,ID_NextMod,0
	dc.l	EPNr_NextSong,ID_NextSong,0
	dc.l	EPNr_NextPattern,ID_NextPos,0
	dc.l	EPNr_PrevModule,ID_PrevMod,0
	dc.l	EPNr_PrevSong,ID_PrevSong,0
	dc.l	EPNr_PrevPattern,ID_PrevPos,0
	dc.l	0,0
;------------------------------------------------------------------------------------------
;------------------------- Tabellen der Messageclasses -----------------------------------------
; Aufruf der jeweiligen Funktionen:
; A5 - lokale Variablentabelle
; A1 - Pointer auf IntuiMessage
;
; alle Register drfen getrashed werden 
;
;--- Tabelle 1 fr die Aktionen vor dem Reply der Message
IDCMPtable1:
		dc.l	0,0
;--- Tabelle 2 fr die Aktionen nach dem Reply der Message
IDCMPtable2:
		dc.l	IDCMP_IDCMPUPDATE,HandleGadgets2
		dc.l	IDCMP_GADGETDOWN,HandleGadgets
		dc.l	IDCMP_GADGETUP,HandleGadgets
		dc.l	IDCMP_MOUSEMOVE,HandleGadgets3
		dc.l	IDCMP_CLOSEWINDOW,HandleWinClose
		dc.l	IDCMP_CHANGEWINDOW,HandleChangewin
		dc.l	IDCMP_REFRESHWINDOW,HandleWinRefresh
		dc.l	0,0

;--------- ID Nummern der verschiedenen Objekte, anhand derer sie in der Liste ---------------
;--------- wiedergefunden werden knnen                                        ---------------
		rsreset
ID_None			rs.b	1
ID_Backdrop		rs.b	1	;StandardNummer, wird gesucht fr Backdrop Images
					;kann auch mehrfach vorkommen
ID_PauseIndicator	rs.b	1	;BlinkAnzeige fr Pause
ID_PlayIndicator	rs.b	1	;BlinkAnzeige fr Play
ID_TimeDisplay		rs.b	1	;Spielzeitanzeige
ID_DiskButton		rs.b	1
ID_PowerButton		rs.b	1	;Quit
ID_Record		rs.b	1	;save Module
ID_Pause		rs.b	1	;Pause
ID_Play			rs.b	1	;
ID_Stop			rs.b	1
ID_Font1		rs.b	1	;8*6 Font
ID_Font2		rs.b	1	;5*4 Font
ID_Textname1		rs.b	1	;Graphikobjekt fr Namensanzeige
ID_TextSoundsys1	rs.b	1	;Graphikobjekt fr SoundsystemAnzeige
ID_TextPattern1		rs.b	1	;Graphikobjekt fr PatternnummerAnzeige
ID_TextPatternInit1	rs.b	1	;Dummyobjekt fr PatternnummerAnzeige
ID_TextSubsong1		rs.b	1	;Graphikobjekt fr SubSongNummerAnzeige
ID_TextTrack1		rs.b	1	;Trackanzeige Teil 1 (grogeschrieben)
ID_TextTrack2		rs.b	1	;Trackanzeige Teil 2 (kleingeschrieben)
ID_AnalyzerOnOff	rs.b	1	;Analyzer ein/aus switch
ID_ZipWinOnOff		rs.b	1	;ZipWindow (minimized) ein/aus switch
ID_AnalyzerUp		rs.b	1	;Analyzer nach oben switch
ID_RemoteOnOff		rs.b	1	;Remote an/aus switch
ID_NextMod		rs.b	1	;
ID_NextSong		rs.b	1	;
ID_NextPos		rs.b	1	;
ID_PrevMod		rs.b	1	;
ID_PrevSong		rs.b	1	;
ID_PrevPos		rs.b	1	;
ID_Songend		rs.b	1	;Songend (wird invers dargestellt, wegen des Loop-Images)
ID_Filter		rs.b	1	;default Filter setting
ID_Random		rs.b	1	;switch zwischen Nextmodule/RandomModule
ID_Timeout		rs.b	1	;setzt Max Playtime entweder auf vorgegebenen Wert oder 0
ID_Fadein		rs.b	1	;Fadein an/aus

ID_SongendLED		rs.b	1	;Indikator-LED`s fr verschiedene Prefszustnde
ID_FilterLED		rs.b	1	;
ID_RandomLED		rs.b	1	;
ID_TimeoutLED		rs.b	1	;
ID_FadeinLED		rs.b	1	;
ID_LoadingLED		rs.b	1	;blink-LED beim Laden/Speichern gepackter Mods
ID_SetTimeout		rs.b	1	;
ID_Levelmeter		rs.b	1	;Aussteuerungsanzeige
ID_SetTimeBackwards	rs.b	1	;Zeitanzeige vorwrts/rckwrts
ID_Volume		rs.b	1	;Lautstrkeregler
ID_RVolume		rs.b	1	;Lautstrkeregler fr Remote
ID_Volumeknob		rs.b	1	;LED fr den Lautstrkeregler
ID_Volumeknob2		rs.b	1	;LED fr den Lautstrkeregler (muted)
ID_Volumeanim		rs.b	1	;die beiden Zustnde der Lautstrkeregelung
ID_VolumeTMP		rs.b	1	;Temporrer Puffer fr Lautstrke der Fernbedienung
ID_Balance		rs.b	1	;Balanceregler
ID_Balanceknob		rs.b	1	;LED fr den Balanceregler
ID_Balanceanim		rs.b	1	;die beiden Zustnde der Balanceregelung
ID_Mute			rs.b	1	;Mute an/aus
ID_Speed		rs.b	1	;Speedregler
ID_Speedanim		rs.b	1	;Anim fr Speedregler
ID_Speedknob		rs.b	1	;Knopf (Knpfe) fr Speedregler
ID_ShowActiveAmplifier	rs.b	1	;momentan aktiven Amplifier anzeigen
ID_ShowDLViewer		rs.b	1	;Dirlistviewer an/aus
ID_AnalyzerMap		rs.b	1	;temp. Array fr Analyzer-Imagedaten
ID_Analyzerstates	rs.b	1	;Bitmaps fr versch. Ausschlge des Analyzers
ID_SolidSwitch		rs.b	1	;Schalter: SolidMode
ID_ShowerSwitch		rs.b	1	;Schalter: ShowerMode
ID_HoriSwitch		rs.b	1	;Schalter: HorizontalMode
ID_SeethroughSwitch	rs.b	1	;Schalter: LineMode
ID_SolidLED		rs.b	1	;LED fr Solid
ID_ShowerLED		rs.b	1	;LED
ID_HoriLED		rs.b	1	;LED
ID_SeethroughLED	rs.b	1	;LED
ID_SolidSwitchI		rs.b	1	;Image fr Schalter: SolidMode
ID_ShowerSwitchI	rs.b	1	;Image fr Schalter: ShowerMode
ID_HoriSwitchI		rs.b	1	;Image fr Schalter: HorizontalMode
ID_SeethroughSwitchI	rs.b	1	;Image fr Schalter: LineMode
ID_AnalyzerPSW		rs.b	1	;Power Switch Analyzer
ID_AnalyzerPLED		rs.b	1	;LED Power Switch Analyzer
ID_AnalyzerLit		rs.b	1	;Beleuchtung Analyzer
ID_ShowManager		rs.b	1	;Manager an/aus
ID_ShowAmpManager	rs.b	1	;Amplifiermanager an/aus
ID_ShowModinfo		rs.b	1	;Moduleinfo an/aus
ID_ShowFormatloader	rs.b	1	;Formatloader an/aus
ID_TrayAnim		rs.b	1	;Animation fr Schublade
ID_CommandBarAnim	rs.b	1	;Animation fr Kommandoklappe
ID_CommandBarOn		rs.b	1	;Klappe auf
ID_CommandBarOff	rs.b	1	;Klappe zu

;-------------------------- Beschreibungen des Fensters ----------------------------
;abhngig von aktuellen Prefs: Gre, Objekte, Fonts usw.
;momentan eine globale Farbpalette vorgesehen, aber auch das soll kein Prob. sein
;
;momentane Einschrnkungen: - es mssen jeweils die Modi mit GESETZTEN Flags zuerst stehen,
;                             da sonst auf andere Einstellungen zurckgegriffen wird, siehe
;                             bei "OpenWin:"
;                           - die Flags und IDCMP-Flags mssen in der momentanen Arbeitsweise
;                             grundstzlich gleich sein fr alle Modi, da beim Umschalten das
;                             Fenster NICHT mehr geschlossen wird, sondern lediglich die
;                             Gre angepat wird (wesentlich schneller)
;
;
Windowlist:
;		dc.l	remote,PFlag_Remote
		dc.l	minimized,PFlag_Minimized
		dc.l	withanalyzerUp,PFlag_Analyzer!PFlag_AnalyzerPos
		dc.l	withanalyzerDown,PFlag_Analyzer

	ifeq	Eagleplayer
;		dc.l	withanalyzerUp,0	;testhalber
;		dc.l	minimized,0		;testhalber
	endc
		dc.l	normal,0					;Flags=0 -> default
;		dc.l	withanalyzerUp,0	;testhalber
		dc.l	0,0						;Ende der Liste

;-------------------------------------------------

minimized:
	dc.w	100	;Left
	dc.w	100	;Top
	dc.w	345	;Width
	dc.w	32	;Height
	dc.l	WFLG_BORDERLESS!WFLG_SMART_REFRESH
	dc.l	IDCMP_IDCMPUPDATE!IDCMP_MOUSEMOVE!IDCMP_REFRESHWINDOW!IDCMP_CHANGEWINDOW!IDCMP_CLOSEWINDOW!IDCMP_VANILLAKEY!IDCMP_RAWKEY!IDCMP_MENUPICK!BUTTONIDCMP!IDCMP_GADGETDOWN
	dc.l	minimizedObj

minimizedObj:
;MOL_Next,MOL_Type,MOL_ID,MOL_Initialized,MOL_Left,MOL_Top,MOL_Width
;MOL_Height,MOL_Images,MOL_Flags,MOL_React,MOL_Command,MOL_CMDArg1,MOL_CMDArg2,MOL_UserData
;Flags: GACT_Immediate, GACT_RELVERIFY, GACT_Toggleselect

	MO_Object	PowerObject15,GLA_Image,ID_Backdrop,0,0,0,0,0,BackImage3,0,0,0,0,0,0
PowerObject15
	MO_Object	ZipWinObject15,GLA_WinClose,ID_PowerButton,0,27,2,35,21,PowerImage3,GACT_RELVERIFY,0,EPNr_Quit,0,0,0
ZipWinObject15
	MO_Object	WinUpfrontObject15,GLA_Button,ID_ZipWinOnOff,0,283,0,19,14,ZipWinImage1,GACT_RELVERIFY,HandleToggles,myNR_ToggleFlag,PFlag_Minimized,TOGGF_Winrefresh,0
WinUpfrontObject15
	MO_Object	DragObject15,GLA_WinDepth,ID_None,0,301,0,18,14,WinUpfrontImage1,0,0,0,0,0,0
DragObject15
	MO_Object	DragObject25,GLA_WinDrag,0,0,0,0,20,32,0,0,0,0,0,0,0
DragObject25
	MO_Object	FontObject15,GLA_WinDrag,0,0,325,0,20,32,0,0,0,0,0,0,0
FontObject15:		;bei Fontobjekten UserData.w = Breite pro Char
	MO_Object	NameTempObject15,GLA_Image,ID_Font1,0,0,0,2688,12,FontImage1,0,0,0,Font1_Prop,0,12
NameTempObject15:	;bei Textdisplayobjekten UserData.l = Adresse des Fonts
	MO_Object	0,GLA_TextField,ID_Textname1,0,85,9,176,12,NametempMImage1,0,HandleModname,0,0,0,FontObject15


;;-------------------------------------------------
;
withanalyzerDown:
	dc.w	100	;Left
	dc.w	100	;Top
	dc.w	534	;Width
	dc.w	197	;Height
	dc.l	WFLG_BORDERLESS!WFLG_SMART_REFRESH
	dc.l	IDCMP_IDCMPUPDATE!IDCMP_MOUSEMOVE!IDCMP_REFRESHWINDOW!IDCMP_CHANGEWINDOW!IDCMP_CLOSEWINDOW!IDCMP_VANILLAKEY!IDCMP_RAWKEY!IDCMP_MENUPICK!BUTTONIDCMP!IDCMP_GADGETDOWN
	dc.l	withanalyzerdownObj

withanalyzerdownObj:
;MOL_Next,MOL_Type,MOL_ID,MOL_Initialized,MOL_Left,MOL_Top,MOL_Width
;MOL_Height,MOL_Images,MOL_Flags,MOL_React,MOL_Command,MOL_CMDArg1,MOL_CMDArg2,MOL_UserData
;Flags: GACT_Immediate, GACT_RELVERIFY, GACT_Toggleselect
LevelmeterObject1:
	MO_Object	AnalyzerstatesObject1,GLA_Image,ID_Levelmeter,0,321,75,119,2,LevelmeterImage0,0,DoLevelmeter,0,0,0,0
AnalyzerstatesObject1:
	MO_Object	AnalyzerMapObject1,GLA_Image,ID_Analyzerstates,0,122,141,19*4,20,AnalyzerStatesImage,0,0,0,0,0,0
AnalyzerMapObject1:
	MO_Object	Backobject1,GLA_Image,ID_AnalyzerMap,0,122,141,148,38,AnalyzerMapImage,0,HandleAnalyzer,0,0,0,0
Backobject1:
	MO_Object	BackObject2,GLA_Image,ID_Backdrop,0,0,0,0,0,BackImage1,0,0,0,0,0,0
BackObject2:
	MO_Object	DragObject1,GLA_Image,ID_Backdrop,0,0,129,0,0,BackImage2,0,0,0,0,0,0
DragObject1:
	MO_Object	DragObject2,GLA_WinDrag,0,0,0,0,20,197,0,0,0,0,0,0,0
DragObject2:
	MO_Object	PowerObject1,GLA_WinDrag,0,0,514,0,20,197,0,0,0,0,0,0,0
PowerObject1:
	MO_Object	VolumeObject1,GLA_WinClose,ID_PowerButton,0,25,73,36,21,PowerImage1,GACT_RELVERIFY,0,EPNr_Quit,0,0,0
VolumeObject1:
	MO_Object	VolumeknobObject1,GLA_Moused,ID_Volume,0,459,21,41,35,0,GACT_RELVERIFY!GACT_FOLLOWMOUSE,HandleVolume,EPNr_Volume,0,0,VolumeRegler
VolumeknobObject1:
	MO_Object	VolumeknobObject2,GLA_Image,ID_Volumeknob,0,459,21,5,5,VolumeknobImage1,0,0,0,0,0,0
VolumeknobObject2:
	MO_Object	VolumeanimObject1,GLA_Image,ID_Volumeknob2,0,459,21,5,5,VolumeknobImage2,0,HandleMuting,0,0,0,0
VolumeanimObject1:
	MO_Object	SpeedObject1,GLA_Image,ID_Volumeanim,0,459,21,41,35,VolumeImage1,0,0,0,0,0,0
SpeedObject1:
	MO_Object	SpeedanimObject1,GLA_Moused,ID_Speed,0,374,82,75,12,0,GACT_RELVERIFY!GACT_FOLLOWMOUSE,HandleSpeed,EPNr_Speed,0,0,SpeedRegler
SpeedanimObject1:
	MO_Object	SpeedknobObject1,GLA_Image,ID_Speedanim,0,374,82,75,12,SpeedImage1,0,0,0,0,0,0
SpeedknobObject1:
	MO_Object	LEDLoadingObject1,GLA_Image,ID_Speedknob,0,374,85,3,7,SpeedknobImage1,0,0,0,0,0,0
LEDLoadingObject1:
	MO_Object	PauseObject1,GLA_Image,ID_LoadingLED,0,145,52,12,7,LEDLoadingImage1,0,0,0,0,0,0
PauseObject1:
	MO_Object	PlayObject1,GLA_Button,ID_Pause,0,212,84,27,21,PauseImage1,GACT_RELVERIFY,0,EPNr_Play,0,0,0
PlayObject1:
	MO_Object	StopObject1,GLA_Button,ID_Play,0,239,84,40,21,PlayImage1,GACT_RELVERIFY,0,EPNr_Play,1,0,0
StopObject1:
	MO_Object	RecordObject1,GLA_Button,ID_Stop,0,278,84,29,21,StopImage1,GACT_RELVERIFY,0,EPNr_StopPlay,1,0,0
RecordObject1:
	MO_Object	SolidSwitchObject1,GLA_Button,ID_Record,0,173,84,27,21,RecordImage1,GACT_RELVERIFY,0,EPNr_SaveModule,0,0,0
SolidSwitchObject1:
	MO_Object	ShowerSwitchObject1,GLA_Button,ID_SolidSwitch,0,309,156,41,21,0,GACT_IMMEDIATE,HandleAnalyzerSwitches,0,PFlag_AnalyzerSolid,0,0
ShowerSwitchObject1:
	MO_Object	HoriSwitchObject1,GLA_Button,ID_ShowerSwitch,0,349,156,40,21,0,GACT_IMMEDIATE,HandleAnalyzerSwitches,0,PFlag_AnalyzerShower,0,0
HoriSwitchObject1:
	MO_Object	SeethroughSwitchObject1,GLA_Button,ID_HoriSwitch,0,389,156,39,21,0,GACT_IMMEDIATE,HandleAnalyzerSwitches,0,PFlag_AnalyzerHori,0,0
SeethroughSwitchObject1:
	MO_Object	SolidLEDObject1,GLA_Button,ID_SeethroughSwitch,0,428,156,43,21,0,GACT_IMMEDIATE,HandleAnalyzerSwitches,0,PFlag_AnalyzerSeethrough,0,0
SolidLEDObject1:
	MO_Object	ShowerLEDObject1,GLA_Image,ID_SolidLED,0,310,152,39,4,SolidLEDImage1,0,0,0,0,0,0
ShowerLEDObject1:
	MO_Object	HoriLEDObject1,GLA_Image,ID_ShowerLED,0,350,152,39,4,ShowerLEDImage1,0,0,0,0,0,0
HoriLEDObject1:
	MO_Object	SeethroughLEDObject1,GLA_Image,ID_HoriLED,0,390,152,38,4,HoriLEDImage1,0,0,0,0,0,0
SeethroughLEDObject1:
	MO_Object	SolidImageObject1,GLA_Image,ID_SeethroughLED,0,429,152,39,4,SeethroughLEDImage1,0,0,0,0,0,0
SolidImageObject1:
	MO_Object	ShowerImageObject1,GLA_Image,ID_SolidSwitchI,0,309,156,41,21,SolidSwitchImage1,GACT_IMMEDIATE,HandleAnalyzerSwitches,0,PFlag_AnalyzerSolid,0,0
ShowerImageObject1:
	MO_Object	HoriImageObject1,GLA_Image,ID_ShowerSwitchI,0,349,156,40,21,ShowerSwitchImage1,GACT_IMMEDIATE,HandleAnalyzerSwitches,0,PFlag_AnalyzerShower,0,0
HoriImageObject1:
	MO_Object	SeethroughImageObject1,GLA_Image,ID_HoriSwitchI,0,389,156,39,21,HoriSwitchImage1,GACT_IMMEDIATE,HandleAnalyzerSwitches,0,PFlag_AnalyzerHori,0,0
SeethroughImageObject1:
	MO_Object	AnalyzerPSWObject1,GLA_Image,ID_SeethroughSwitchI,0,428,156,43,21,SeethroughSwitchImage1,GACT_IMMEDIATE,HandleAnalyzerSwitches,0,PFlag_AnalyzerSeethrough,0,0
AnalyzerPSWObject1:
	MO_Object	AnalyzerPLEDObject1,GLA_Button,ID_AnalyzerPSW,0,27,156,32,15,AnalyzerPSWImage1,GACT_RELVERIFY,HandleAnalyzerPower,0,PFlag_AnalyzerPower,0,0
AnalyzerPLEDObject1:
	MO_Object	AnalyzerLitObject1,GLA_Image,ID_AnalyzerPLED,0,25,152,36,5,AnalyzerPLEDImage1,0,0,0,0,0,0
AnalyzerLitObject1:
	MO_Object	DiskObject1,GLA_Image,ID_AnalyzerLit,0,114,141,164,43,AnalyzerLitImage1,0,LitAnalyzer,0,0,0,0
DiskObject1:
	MO_Object	AnalyzerUpObject1,GLA_Button,ID_DiskButton,0,170,28,34,22,DiskImage1,GACT_RELVERIFY,HandleLoadModule,EPNr_LoadModule,0,0,0
AnalyzerUpObject1:
	MO_Object	NextModObject1,GLA_Button,ID_AnalyzerUp,0,488,129,18,13,AnalyzerUpImage1,GACT_RELVERIFY,HandleToggles,myNR_ToggleFlag,PFlag_AnalyzerPos,TOGGF_Winrefresh,0
NextModObject1:
	MO_Object	NextSongObject1,GLA_Button,ID_NextMod,0,341,83,28,10,NextModImage1,GACT_RELVERIFY,0,EPNr_NextModule,1,0,0
NextSongObject1:
	MO_Object	NextPosObject1,GLA_Button,ID_NextSong,0,341,95,28,10,NextSongImage1,GFLG_Disabled<<16!GACT_RELVERIFY,0,EPNr_NextSong,1,0,0
NextPosObject1:
	MO_Object	PrevModObject1,GLA_Button,ID_NextPos,0,403,95,28,10,NextPosImage1,GACT_IMMEDIATE!MFLG_Repeat,HandleNextPattern,EPNr_NextPattern,1,0,0
PrevModObject1:
	MO_Object	PrevSongObject1,GLA_Button,ID_PrevMod,0,313,83,28,10,PrevModImage1,GACT_RELVERIFY,0,EPNr_PrevModule,1,0,0
PrevSongObject1:
	MO_Object	PrevPosObject1,GLA_Button,ID_PrevSong,0,313,95,28,10,PrevSongImage1,GFLG_Disabled<<16!GACT_RELVERIFY,0,EPNr_PrevSong,1,0,0
PrevPosObject1:
	MO_Object	PauseIndicatorObject1,GLA_Button,ID_PrevPos,0,375,95,28,10,PrevPosImage1,GACT_IMMEDIATE!MFLG_Repeat,HandlePrevPattern,EPNr_PrevPattern,1,0,0
PauseIndicatorObject1:
	MO_Object	PlayIndicatorObject1,GLA_Image,ID_PauseIndicator,0,247,73,10,8,PauseIndicatorImage1,0,HandlePauseLED,0,0,0,0
PlayIndicatorObject1:
	MO_Object	LEDSongendObject1,GLA_Image,ID_PlayIndicator,0,260,73,11,7,PlayIndicatorImage1,0,HandlePlayLED,0,0,0,0
LEDSongendObject1:
	MO_Object	LEDFilterObject1,GLA_Image,ID_SongendLED,0,71,73,15,5,LEDSongendImage1,0,0,0,0,0,0
LEDFilterObject1:
	MO_Object	LEDRandomObject1,GLA_Image,ID_FilterLED,0,92,73,14,5,LEDFilterImage1,0,0,0,0,0,0
LEDRandomObject1:
	MO_Object	LEDTimeoutObject1,GLA_Image,ID_RandomLED,0,111,73,14,5,LEDRandomImage1,0,0,0,0,0,0
LEDTimeoutObject1:
	MO_Object	LEDFadeinObject1,GLA_Image,ID_TimeoutLED,0,131,73,14,5,LEDTimeoutImage1,0,0,0,0,0,0
LEDFadeinObject1:
	MO_Object	SongendObject1,GLA_Image,ID_FadeinLED,0,150,73,16,5,LEDFadeinImage1,0,0,0,0,0,0
SongendObject1:
	MO_Object	FilterObject1,GLA_Button,ID_Songend,0,72,79,13,11,KnobImage1,GACT_RELVERIFY,0,EPNr_SongEnd,-1,0,0
FilterObject1:
	MO_Object	RandomObject1,GLA_Button,ID_Filter,0,92,79,13,11,KnobImage1,GACT_RELVERIFY,0,EPNr_Filter,-1,0,0
RandomObject1:
	MO_Object	TimeoutObject1,GLA_Button,ID_Random,0,112,79,13,11,KnobImage1,GACT_RELVERIFY,ChangeRandom,EPNr_ProgramMode,3,0,0
TimeoutObject1:
	MO_Object	FadeinObject1,GLA_Button,ID_Timeout,0,132,79,13,11,KnobImage1,GACT_RELVERIFY,ChangeTimeout,EPNr_PlayTime,100,0,0
FadeinObject1:
	MO_Object	FontObject1,GLA_Button,ID_Fadein,0,152,79,13,11,KnobImage1,GACT_RELVERIFY,0,EPNr_FadeIn,-1,0,0
FontObject1:		;bei Fontobjekten UserData.w = Breite pro Char
	MO_Object	NameTempObject1,GLA_Image,ID_Font1,0,0,0,2688,12,FontImage1,0,0,0,Font1_Prop,0,12
NameTempObject1:	;bei Textdisplayobjekten UserData.l = Adresse des Fonts
	MO_Object	TimeDisplayObject1,GLA_TextField,ID_Textname1,0,240,15,200,12,NametempNImage1,0,HandleModname,0,0,0,FontObject13
TimeDisplayObject1:
	MO_Object	SetTimeBackwardsObject1,GLA_TextField,ID_TimeDisplay,0,240,45,72,12,TimeTempNImage1,0,HandleShowTime,0,0,0,FontObject13
SetTimeBackwardsObject1:
	MO_Object	TrackTempObject1,GLA_Button,ID_SetTimeBackwards,0,218,45,21,10,0,GACT_RELVERIFY,HandleToggles,myNR_ToggleFlag,PFfag_TimeBackwards,0,0
TrackTempObject1:
	MO_Object	AnalyzerOnOffObject1,GLA_TextField,ID_TextTrack1,0,240,29,60,12,TrackNImage1,0,TrackDisp1,0,0,0,FontObject13
AnalyzerOnOffObject1:
	MO_Object	ZipWinObject1,GLA_Button,ID_AnalyzerOnOff,0,454,0,18,14,AnalyzerOnOffImage1,GACT_RELVERIFY,HandleToggles,myNR_ToggleFlag,PFlag_Analyzer,TOGGF_Winrefresh,0
ZipWinObject1:
	MO_Object	WinUpfrontObject1,GLA_Button,ID_ZipWinOnOff,0,471,0,19,14,ZipWinImage1,GACT_RELVERIFY,HandleToggles,myNR_ToggleFlag,PFlag_Minimized,TOGGF_Winrefresh,0
WinUpfrontObject1:
	MO_Object	TrayAnimObject1,GLA_WinDepth,ID_None,0,489,0,18,14,WinUpfrontImage1,0,0,0,0,0,0
TrayAnimObject1:
	MO_Object	CommandBarAnimObject1,GLA_Image,ID_TrayAnim,0,25,21,154,47,TrayAnimImage1,0,0,0,0,0,0
CommandBarAnimObject1:
	MO_Object	CommandBarOnObject1,GLA_Image,ID_CommandBarAnim,0,200,110,326,16,CommandBarAnimImage1,0,0,0,0,0,0
CommandBarOnObject1:
	MO_Object	CommandBarOffObject1,GLA_Button,ID_CommandBarOn,0,200,110,70,10,CommandBarImage1,GACT_RELVERIFY,HandleCommandBarOn,myNR_ToggleFlag,0,TOGGF_WinRefresh,0
CommandBarOffObject1:
	MO_Object	CBTManagerObject1,GLA_Button,ID_CommandBarOff,0,200,110,70,18,0,GFLG_Disabled<<16!GACT_RELVERIFY,HandleCommandBarOff,myNR_ToggleFlag,PFlag_CommandBar,0,0
CBTManagerObject1:
	MO_Object	CBTAmpManagerObject1,GLA_Button,ID_ShowManager,0,270,112,43,11,CBTManagerImage1,GFLG_Disabled<<16!GACT_RELVERIFY,HandleManager,0,0,0,0
CBTAmpManagerObject1:
	MO_Object	CBTModinfoObject1,GLA_Button,ID_ShowAmpManager,0,319,112,56,11,CBTAmpManagerImage1,GFLG_Disabled<<16!GACT_RELVERIFY,HandleAmpManager,0,0,0,0
CBTModinfoObject1:
	MO_Object	CBTFormatloaderObject1,GLA_Button,ID_ShowModinfo,0,381,112,52,11,CBTModinfoImage1,GFLG_Disabled<<16!GACT_RELVERIFY,HandleModuleinfo,0,0,0,0
CBTFormatloaderObject1:
	MO_Object	BalanceObject1,GLA_Button,ID_ShowFormatloader,0,439,112,63,11,CBTFormatloadImage1,GFLG_Disabled<<16!GACT_RELVERIFY,HandleFormatloader,0,0,0,0
BalanceObject1:
	MO_Object	BalanceknobObject1,GLA_Moused,ID_Balance,0,469,84,21,20,0,GACT_RELVERIFY!GACT_FOLLOWMOUSE,HandleBalance,EPNr_Balance,0,0,BalanceRegler
BalanceknobObject1:
	MO_Object	BalanceanimObject1,GLA_Image,ID_Balanceknob,0,469,84,5,4,BalanceknobImage1,0,0,0,0,0,0
BalanceanimObject1:
	MO_Object	MuteObject1,GLA_Image,ID_Balanceanim,0,469,84,21,20,BalanceImage1,0,0,0,0,0,0
MuteObject1:
	MO_Object	SetTimeoutObject1,GLA_Button,ID_Mute,0,465,60,11,11,Muteknob1,GACT_RELVERIFY,HandleMute,0,0,0,0
SetTimeoutObject1:
	MO_Object	FontObject2,GLA_Button,ID_SetTimeout,0,129,104,18,9,SetTimeoutImage1,GACT_RELVERIFY,0,EPNr_PlayTime,0,0,0
FontObject2:
	MO_Object	SoundSysTempObject1,GLA_Image,ID_Font2,0,0,0,582,8,FontImage2,0,0,0,0,0,6
SoundSysTempObject1:	;bei Textdisplayobjekten UserData.l = Adresse des Fonts
	MO_Object	PatternTempObject1,GLA_TextField,ID_TextSoundsys1,0,241,59,200,8,SoundSystemNImage1,0,ShowSoundsys,0,0,0,FontObject22
PatternTempObject1:
	MO_Object	PatternInitTempObject1,GLA_TextField,ID_TextPattern1,0,343,47,100,8,PatternNImage1,0,PatternDisp,0,0,0,FontObject22
PatternInitTempObject1:
	MO_Object	SubsongTempObject1,GLA_Dummy,ID_TextPatternInit1,0,343,47,100,8,0,0,InitPatternDisp,0,0,0,0
SubsongTempObject1:
	MO_Object	TrackTempObject2,GLA_TextField,ID_TextSubsong1,0,343,31,100,8,PatternNImage1,0,SubsongDisp,0,0,0,FontObject22
TrackTempObject2:
	MO_Object	ShowActiveAmplifierObject1,GLA_TextField,ID_TextTrack2,0,285,31,40,8,Track2NImage1,0,TrackDisp2,0,0,0,FontObject22
ShowActiveAmplifierObject1:
	MO_Object	ShowDLViewerObject1,GLA_Button,ID_ShowActiveAmplifier,0,217,57,22,9,0,GACT_RELVERIFY,HandleActiveAmplifier,0,0,0,0
ShowDLViewerObject1:
	MO_Object	0,GLA_Button,ID_ShowDLViewer,0,217,28,22,14,0,GACT_RELVERIFY,HandleDLViewer,0,0,0,0

;-------------------------------------------------
normal:
	dc.w	100	;Left
	dc.w	100	;Top
	dc.w	534	;Width
	dc.w	129	;Height
	dc.l	WFLG_BORDERLESS!WFLG_SMART_REFRESH
	dc.l	IDCMP_IDCMPUPDATE!IDCMP_MOUSEMOVE!IDCMP_REFRESHWINDOW!IDCMP_CHANGEWINDOW!IDCMP_CLOSEWINDOW!IDCMP_VANILLAKEY!IDCMP_RAWKEY!IDCMP_MENUPICK!BUTTONIDCMP!IDCMP_GADGETDOWN
	dc.l	normalobj

normalobj:
;MOL_Next,MOL_Type,MOL_ID,MOL_Initialized,MOL_Left,MOL_Top,MOL_Width
;MOL_Height,MOL_Images,MOL_Flags,MOL_React,MOL_Command,MOL_CMDArg1,MOL_CMDArg2,MOL_UserData
;Flags: GACT_Immediate, GACT_RELVERIFY, GACT_Toggleselect

	MO_Object	DragObject12,GLA_Image,ID_Backdrop,0,0,0,0,0,BackImage1,0,0,0,0,0,0
DragObject12:
	MO_Object	DragObject22,GLA_WinDrag,0,0,0,0,20,197,0,0,0,0,0,0,0
DragObject22:
	MO_Object	PowerObject12,GLA_WinDrag,0,0,514,0,20,197,0,0,0,0,0,0,0
PowerObject12:
	MO_Object	VolumeObject12,GLA_WinClose,ID_PowerButton,0,25,73,36,21,PowerImage1,GACT_RELVERIFY,0,EPNr_Quit,0,0,0
VolumeObject12:
	MO_Object	VolumeknobObject12,GLA_Moused,ID_Volume,0,459,21,41,35,0,GACT_RELVERIFY!GACT_FOLLOWMOUSE,HandleVolume,EPNr_Volume,0,0,VolumeRegler
VolumeknobObject12:
	MO_Object	VolumeknobObject22,GLA_Image,ID_Volumeknob,0,459,21,5,5,VolumeknobImage1,0,0,0,0,0,0
VolumeknobObject22:
	MO_Object	VolumeanimObject12,GLA_Image,ID_Volumeknob2,0,459,21,5,5,VolumeknobImage2,0,HandleMuting,0,0,0,0
VolumeanimObject12:
	MO_Object	SpeedObject12,GLA_Image,ID_Volumeanim,0,459,21,41,35,VolumeImage1,0,0,0,0,0,0
SpeedObject12:
	MO_Object	SpeedanimObject12,GLA_Moused,ID_Speed,0,374,82,75,12,0,GACT_RELVERIFY!GACT_FOLLOWMOUSE,HandleSpeed,EPNr_Speed,0,0,SpeedRegler
SpeedanimObject12:
	MO_Object	SpeedknobObject12,GLA_Image,ID_Speedanim,0,374,82,75,12,SpeedImage1,0,0,0,0,0,0
SpeedknobObject12:
	MO_Object	LEDLoadingObject12,GLA_Image,ID_Speedknob,0,374,85,3,7,SpeedknobImage1,0,0,0,0,0,0
LEDLoadingObject12:
	MO_Object	PauseObject12,GLA_Image,ID_LoadingLED,0,145,52,12,7,LEDLoadingImage1,0,0,0,0,0,0
PauseObject12:
	MO_Object	PlayObject12,GLA_Button,ID_Pause,0,212,84,27,21,PauseImage1,GACT_RELVERIFY,0,EPNr_Play,0,0,0
PlayObject12:
	MO_Object	StopObject12,GLA_Button,ID_Play,0,239,84,40,21,PlayImage1,GACT_RELVERIFY,0,EPNr_Play,1,0,0
StopObject12:
	MO_Object	RecordObject12,GLA_Button,ID_Stop,0,278,84,29,21,StopImage1,GACT_RELVERIFY,0,EPNr_StopPlay,1,0,0
RecordObject12:
	MO_Object	DiskObject12,GLA_Button,ID_Record,0,173,84,27,21,RecordImage1,GACT_RELVERIFY,0,EPNr_SaveModule,0,0,0
DiskObject12:
	MO_Object	LevelmeterObject12,GLA_Button,ID_DiskButton,0,170,28,34,22,DiskImage1,GACT_RELVERIFY,HandleLoadModule,EPNr_LoadModule,0,0,0
LevelmeterObject12:
	MO_Object	NextModObject12,GLA_Image,ID_Levelmeter,0,321,75,119,2,LevelmeterImage0,0,DoLevelmeter,0,0,0,0
NextModObject12:
	MO_Object	NextSongObject12,GLA_Button,ID_NextMod,0,341,83,28,10,NextModImage1,GACT_RELVERIFY,0,EPNr_NextModule,1,0,0
NextSongObject12:
	MO_Object	NextPosObject12,GLA_Button,ID_NextSong,0,341,95,28,10,NextSongImage1,GACT_RELVERIFY,0,EPNr_NextSong,1,0,0
NextPosObject12:
	MO_Object	PrevModObject12,GLA_Button,ID_NextPos,0,403,95,28,10,NextPosImage1,GACT_IMMEDIATE!MFLG_Repeat,HandleNextPattern,EPNr_NextPattern,1,0,0
PrevModObject12:
	MO_Object	PrevSongObject12,GLA_Button,ID_PrevMod,0,313,83,28,10,PrevModImage1,GACT_RELVERIFY,0,EPNr_PrevModule,1,0,0
PrevSongObject12:
	MO_Object	PrevPosObject12,GLA_Button,ID_PrevSong,0,313,95,28,10,PrevSongImage1,GACT_RELVERIFY,0,EPNr_PrevSong,1,0,0
PrevPosObject12:
	MO_Object	PauseIndicatorObject12,GLA_Button,ID_PrevPos,0,375,95,28,10,PrevPosImage1,GACT_IMMEDIATE!MFLG_Repeat,HandlePrevPattern,EPNr_PrevPattern,1,0,0
PauseIndicatorObject12:
	MO_Object	PlayIndicatorObject12,GLA_Image,ID_PauseIndicator,0,247,73,10,8,PauseIndicatorImage1,0,HandlePauseLED,0,0,0,0
PlayIndicatorObject12:
	MO_Object	LEDSongendObject12,GLA_Image,ID_PlayIndicator,0,260,73,11,7,PlayIndicatorImage1,0,HandlePlayLED,0,0,0,0
LEDSongendObject12:
	MO_Object	LEDFilterObject12,GLA_Image,ID_SongendLED,0,71,73,15,5,LEDSongendImage1,0,0,0,0,0,0
LEDFilterObject12:
	MO_Object	LEDRandomObject12,GLA_Image,ID_FilterLED,0,92,73,14,5,LEDFilterImage1,0,0,0,0,0,0
LEDRandomObject12:
	MO_Object	LEDTimeoutObject12,GLA_Image,ID_RandomLED,0,111,73,14,5,LEDRandomImage1,0,0,0,0,0,0
LEDTimeoutObject12:
	MO_Object	LEDFadeinObject12,GLA_Image,ID_TimeoutLED,0,131,73,14,5,LEDTimeoutImage1,0,0,0,0,0,0
LEDFadeinObject12:
	MO_Object	SongendObject12,GLA_Image,ID_FadeinLED,0,150,73,16,5,LEDFadeinImage1,0,0,0,0,0,0
SongendObject12:
	MO_Object	FilterObject12,GLA_Button,ID_Songend,0,72,79,13,11,KnobImage1,GACT_RELVERIFY,0,EPNr_SongEnd,-1,0,0
FilterObject12:
	MO_Object	RandomObject12,GLA_Button,ID_Filter,0,92,79,13,11,KnobImage1,GACT_RELVERIFY,0,EPNr_Filter,-1,0,0
RandomObject12:
	MO_Object	TimeoutObject12,GLA_Button,ID_Random,0,112,79,13,11,KnobImage1,GACT_RELVERIFY,ChangeRandom,EPNr_ProgramMode,3,0,0
TimeoutObject12:
	MO_Object	FadeinObject12,GLA_Button,ID_Timeout,0,132,79,13,11,KnobImage1,GACT_RELVERIFY,ChangeTimeout,EPNr_PlayTime,100,0,0
FadeinObject12:
	MO_Object	FontObject12,GLA_Button,ID_Fadein,0,152,79,13,11,KnobImage1,GACT_RELVERIFY,0,EPNr_FadeIn,-1,0,0
FontObject12:		;bei Fontobjekten UserData.w = Breite pro Char
	MO_Object	NameTempObject12,GLA_Image,ID_Font1,0,0,0,2688,12,FontImage1,0,0,0,Font1_Prop,0,12
NameTempObject12:	;bei Textdisplayobjekten UserData.l = Adresse des Fonts
	MO_Object	TimeDisplayObject12,GLA_TextField,ID_Textname1,0,240,15,200,12,NametempNImage1,0,HandleModname,0,0,0,FontObject13
TimeDisplayObject12:
	MO_Object	SetTimeBackwardsObject12,GLA_TextField,ID_TimeDisplay,0,240,45,72,12,TimeTempNImage1,0,HandleShowTime,0,0,0,FontObject13
SetTimeBackwardsObject12:
	MO_Object	TrackTempObject12,GLA_Button,ID_SetTimeBackwards,0,218,45,21,10,0,GACT_RELVERIFY,HandleToggles,myNR_ToggleFlag,PFfag_TimeBackwards,0,0
TrackTempObject12:
	MO_Object	AnalyzerOnOffObject12,GLA_TextField,ID_TextTrack1,0,240,29,60,12,TrackNImage1,0,TrackDisp1,0,0,0,FontObject13
AnalyzerOnOffObject12:
	MO_Object	ZipWinObject12,GLA_Button,ID_AnalyzerOnOff,0,454,0,18,14,AnalyzerOnOffImage1,GACT_RELVERIFY,HandleToggles,myNR_ToggleFlag,PFlag_Analyzer,TOGGF_Winrefresh,0
ZipWinObject12:
	MO_Object	WinUpfrontObject12,GLA_Button,ID_ZipWinOnOff,0,471,0,19,14,ZipWinImage1,GACT_RELVERIFY,HandleToggles,myNR_ToggleFlag,PFlag_Minimized,TOGGF_Winrefresh,0
WinUpfrontObject12:
	MO_Object	TrayAnimObject12,GLA_WinDepth,ID_None,0,489,0,18,14,WinUpfrontImage1,0,0,0,0,0,0
TrayAnimObject12:
	MO_Object	CommandBarAnimObject12,GLA_Image,ID_TrayAnim,0,25,21,154,47,TrayAnimImage1,0,0,0,0,0,0
CommandBarAnimObject12:
	MO_Object	CommandBarOnObject12,GLA_Image,ID_CommandBarAnim,0,200,110,326,16,CommandBarAnimImage1,0,0,0,0,0,0
CommandBarOnObject12:
	MO_Object	CommandBarOffObject12,GLA_Button,ID_CommandBarOn,0,200,110,70,10,CommandBarImage1,GACT_RELVERIFY,HandleCommandBarOn,myNR_ToggleFlag,0,TOGGF_WinRefresh,0
CommandBarOffObject12:
	MO_Object	CBTManagerObject12,GLA_Button,ID_CommandBarOff,0,200,110,70,18,0,GFLG_Disabled<<16!GACT_RELVERIFY,HandleCommandBarOff,myNR_ToggleFlag,PFlag_CommandBar,0,0
CBTManagerObject12:
	MO_Object	CBTAmpManagerObject12,GLA_Button,ID_ShowManager,0,270,112,43,11,CBTManagerImage1,GFLG_Disabled<<16!GACT_RELVERIFY,HandleManager,0,0,0,0
CBTAmpManagerObject12:
	MO_Object	CBTModinfoObject12,GLA_Button,ID_ShowAmpManager,0,319,112,56,11,CBTAmpManagerImage1,GFLG_Disabled<<16!GACT_RELVERIFY,HandleAmpManager,0,0,0,0
CBTModinfoObject12:
	MO_Object	CBTFormatloaderObject12,GLA_Button,ID_ShowModinfo,0,381,112,52,11,CBTModinfoImage1,GFLG_Disabled<<16!GACT_RELVERIFY,HandleModuleinfo,0,0,0,0
CBTFormatloaderObject12:
	MO_Object	BalanceObject12,GLA_Button,ID_ShowFormatloader,0,439,112,63,11,CBTFormatloadImage1,GFLG_Disabled<<16!GACT_RELVERIFY,HandleFormatloader,0,0,0,0
BalanceObject12:
	MO_Object	BalanceknobObject12,GLA_Moused,ID_Balance,0,469,84,21,20,0,GACT_RELVERIFY!GACT_FOLLOWMOUSE,HandleBalance,EPNr_Balance,0,0,BalanceRegler
BalanceknobObject12:
	MO_Object	BalanceanimObject12,GLA_Image,ID_Balanceknob,0,469,84,5,4,BalanceknobImage1,0,0,0,0,0,0
BalanceanimObject12:
	MO_Object	MuteObject12,GLA_Image,ID_Balanceanim,0,469,84,21,20,BalanceImage1,0,0,0,0,0,0
MuteObject12:
	MO_Object	SetTimeoutObject12,GLA_Button,ID_Mute,0,465,60,11,11,Muteknob1,GACT_RELVERIFY,HandleMute,0,0,0,0
SetTimeoutObject12:
	MO_Object	FontObject22,GLA_Button,ID_SetTimeout,0,129,104,18,9,SetTimeoutImage1,GACT_RELVERIFY,0,EPNr_PlayTime,0,0,0
FontObject22:
	MO_Object	SoundSysTempObject12,GLA_Image,ID_Font2,0,0,0,582,8,FontImage2,0,0,0,0,0,6
SoundSysTempObject12:	;bei Textdisplayobjekten UserData.l = Adresse des Fonts
	MO_Object	PatternTempObject12,GLA_TextField,ID_TextSoundsys1,0,241,59,200,8,SoundSystemNImage1,0,ShowSoundsys,0,0,0,FontObject22
PatternTempObject12:
	MO_Object	PatternInitTempObject12,GLA_TextField,ID_TextPattern1,0,343,47,100,8,PatternNImage1,0,PatternDisp,0,0,0,FontObject22
PatternInitTempObject12:
	MO_Object	SubsongTempObject12,GLA_Dummy,ID_TextPatternInit1,0,343,47,100,8,0,0,InitPatternDisp,0,0,0,0
SubsongTempObject12:
	MO_Object	TrackTempObject22,GLA_TextField,ID_TextSubsong1,0,343,31,100,8,PatternNImage1,0,SubsongDisp,0,0,0,FontObject22
TrackTempObject22:
	MO_Object	ShowActiveAmplifierObject12,GLA_TextField,ID_TextTrack2,0,285,31,40,8,Track2NImage1,0,TrackDisp2,0,0,0,FontObject22
ShowActiveAmplifierObject12:
	MO_Object	ShowDLViewerObject12,GLA_Button,ID_ShowActiveAmplifier,0,217,57,22,9,0,GACT_RELVERIFY,HandleActiveAmplifier,0,0,0,0
ShowDLViewerObject12:
	MO_Object	0,GLA_Button,ID_ShowDLViewer,0,217,28,22,14,0,GACT_RELVERIFY,HandleDLViewer,0,0,0,0

;;-------------------------------------------------
;
;remote:
;	dc.w	100	;Left
;	dc.w	100	;Top
;	dc.w	56	;Width
;	dc.w	148	;Height
;	dc.l	WFLG_BORDERLESS!WFLG_SMART_REFRESH
;	dc.l	IDCMP_MOUSEMOVE!IDCMP_REFRESHWINDOW!IDCMP_CHANGEWINDOW!IDCMP_CLOSEWINDOW!IDCMP_VANILLAKEY!IDCMP_RAWKEY!IDCMP_MENUPICK!BUTTONIDCMP!IDCMP_GADGETDOWN
;	dc.l	remoteobjects
;
;remoteobjects:
;;MOL_Next,MOL_Type,MOL_ID,MOL_Initialized,MOL_Left,MOL_Top,MOL_Width
;;MOL_Height,MOL_Images,MOL_Flags,MOL_React,MOL_Command,MOL_CMDArg1,MOL_CMDArg2,MOL_UserData
;;Flags: GACT_Immediate, GACT_RELVERIFY, GACT_Toggleselect
;
;	MO_Object	RemoteSwitchObject14,GLA_Image,ID_Backdrop,0,0,0,0,0,RemoteBackground,0,0,0,0,0,0
;RemoteSwitchObject14:
;	MO_Object	DiskObject14,GLA_Button,ID_RemoteOnOff,0,7,9,18,9,RemoteOffImage1,GACT_RELVERIFY,HandleToggles,myNR_ToggleFlag,PFlag_Remote,TOGGF_Winrefresh,0
;DiskObject14:
;	MO_Object	DragObject14,GLA_Button,ID_DiskButton,0,30,9,18,9,RemoteFileImage1,GACT_RELVERIFY,0,EPNr_LoadModule,0,0,0
;DragObject14:
;	MO_Object	NextModObject14,GLA_WinDrag,ID_None,0,0,130,56,18,0,0,0,0,0,0,0
;
;NextModObject14:
;	MO_Object	NextSongObject14,GLA_Button,ID_NextMod,0,29,64,18,9,RemoteNextmodImage1,GACT_RELVERIFY,0,EPNr_NextModule,1,0,0
;NextSongObject14:
;	MO_Object	NextPosObject14,GLA_Button,ID_NextSong,0,29,53,18,9,RemoteNextsongImage1,GACT_RELVERIFY,0,EPNr_NextSong,1,0,0
;NextPosObject14:
;	MO_Object	PrevModObject14,GLA_Button,ID_NextPos,0,29,78,18,9,RemoteNextPattImage1,GACT_RELVERIFY,HandleNextPattern,EPNr_NextPattern,1,0,0
;PrevModObject14:
;	MO_Object	PrevSongObject14,GLA_Button,ID_PrevMod,0,7,64,18,9,RemotePrevmodImage1,GACT_RELVERIFY,0,EPNr_PrevModule,1,0,0
;PrevSongObject14:
;	MO_Object	SaveModObject14,GLA_Button,ID_PrevSong,0,7,53,18,9,RemotePrevsongImage1,GACT_RELVERIFY,0,EPNr_PrevSong,1,0,0
;SaveModObject14:
;	MO_Object	PlayObject14,GLA_Button,ID_Record,0,7,78,18,9,RemoteSavemodImage1,GACT_RELVERIFY,0,EPNr_SaveModule,0,0,0
;PlayObject14:
;	MO_Object	PauseObject14,GLA_Button,ID_Play,0,17,102,20,7,RPlayImage1,GACT_RELVERIFY,0,EPNr_Play,1,0,0
;PauseObject14:
;	MO_Object	VolumeObject14,GLA_Button,ID_Pause,0,17,111,20,8,RPauseImage1,GACT_RELVERIFY,0,EPNr_Play,0,0,0
;VolumeObject14:
;	MO_Object	VolumeanimObject14,GLA_Moused,ID_RVolume,0,9,95,38,30,0,GACT_RELVERIFY!GACT_FOLLOWMOUSE,HandleRemoteVolume,EPNr_Volume,0,0,RemoteVolumeRegler
;VolumeanimObject14:
;	MO_Object	VolumeTMPObject14,GLA_Image,ID_Volumeanim,0,9,95,38,30,RemoteVolumeImage1,0,0,0,0,0,0
;VolumeTMPObject14:
;	MO_Object	SongendObject14,GLA_Image,ID_VolumeTMP,0,9,95,38,30,RemoteVolumeImageTMP,0,0,0,0,0,0
;SongendObject14:
;	MO_Object	FilterObject14,GLA_Button,ID_Songend,0,8,32,10,8,RemoteknobImage1,GACT_RELVERIFY,0,EPNr_SongEnd,-1,0,0
;FilterObject14:
;	MO_Object	RandomObject14,GLA_Button,ID_Filter,0,22,32,10,8,RemoteknobImage1,GACT_RELVERIFY,0,EPNr_Filter,-1,0,0
;RandomObject14:
;	MO_Object	LEDSongendObject14,GLA_Button,ID_Random,0,36,32,10,8,RemoteknobImage1,GACT_RELVERIFY,ChangeRandom,EPNr_ProgramMode,3,0,0
;LEDSongendObject14:
;	MO_Object	LEDFilterObject14,GLA_Image,ID_SongendLED,0,8,23,10,6,LEDRSongendImage1,0,0,0,0,0,0
;LEDFilterObject14:
;	MO_Object	LEDRandomObject14,GLA_Image,ID_FilterLED,0,22,23,10,6,LEDRFilterImage1,0,0,0,0,0,0
;LEDRandomObject14:
;	MO_Object	LEDLoadingObject14,GLA_Image,ID_RandomLED,0,36,23,10,6,LEDRRandomImage1,0,0,0,0,0,0
;LEDLoadingObject14:
;	MO_Object	PauseIndicatorObject14,GLA_Image,ID_LoadingLED,0,31,109,4,2,RLEDLoadingImage1,0,0,0,0,0,0
;PauseIndicatorObject14:
;	MO_Object	PlayIndicatorObject14,GLA_Image,ID_PauseIndicator,0,26,109,4,2,RLEDPausingImage1,0,HandlePauseLED,0,0,0,0
;PlayIndicatorObject14:
;	MO_Object	0,GLA_Image,ID_PlayIndicator,0,20,109,4,2,RLEDPlayingImage1,0,HandlePlayLED,0,0,0,0


;---------------------------- Definitionen fr Regler -------------------------------
;REG_Type,REG_Enable,REG_XCenter,REG_YCenter,REG_MinRadius,REG_MaxRadius,REG_KnobRadiusA
;REG_KnobRadiusB,REG_PhiMin,REG_PhiTotal,REG_Minvalue,REG_Maxvalue,REG_PhiStore,REG_Value

VolumeRegler:		REG_Object	REGTYPE_Circle,0,476,37,0,22,15,13,240,300,0,64,0,0
BalanceRegler:		REG_Object	REGTYPE_Circle,0,477,93,0,11,6,6,220,260,0,64,0,0

VolumeReglerAU:		REG_Object	REGTYPE_Circle,0,476,105,0,22,15,13,240,300,0,64,0,0
BalanceReglerAU:	REG_Object	REGTYPE_Circle,0,477,161,0,11,6,6,220,260,0,64,0,0

SpeedRegler:		REG_Object	REGTYPE_Hori,0,0,0,3,68,0,0,0,0,0,50,0,0

;;-------------------------------------------------
;
withanalyzerUp:
	dc.w	100	;Left
	dc.w	100	;Top
	dc.w	534	;Width
	dc.w	197	;Height
	dc.l	WFLG_BORDERLESS!WFLG_SMART_REFRESH
	dc.l	IDCMP_IDCMPUPDATE!IDCMP_MOUSEMOVE!IDCMP_REFRESHWINDOW!IDCMP_CHANGEWINDOW!IDCMP_CLOSEWINDOW!IDCMP_VANILLAKEY!IDCMP_RAWKEY!IDCMP_MENUPICK!BUTTONIDCMP!IDCMP_GADGETDOWN
	dc.l	withanalyzerUpObj

withanalyzerUpObj:
;MOL_Next,MOL_Type,MOL_ID,MOL_Initialized,MOL_Left,MOL_Top,MOL_Width
;MOL_Height,MOL_Images,MOL_Flags,MOL_React,MOL_Command,MOL_CMDArg1,MOL_CMDArg2,MOL_UserData
;Flags: GACT_Immediate, GACT_RELVERIFY, GACT_Toggleselect

	MO_Object	BackObject23,GLA_Image,ID_Backdrop,0,0,68,0,0,BackImage1,0,0,0,0,0,0
BackObject23:
	MO_Object	DragObject13,GLA_Image,ID_Backdrop,0,0,0,0,0,BackImage2,0,0,0,0,0,0
DragObject13:
	MO_Object	DragObject23,GLA_WinDrag,0,0,0,0,20,197,0,0,0,0,0,0,0
DragObject23:
	MO_Object	PowerObject13,GLA_WinDrag,0,0,514,0,20,197,0,0,0,0,0,0,0
PowerObject13:
	MO_Object	VolumeObject13,GLA_WinClose,ID_PowerButton,0,25,141,36,21,PowerImage1,GACT_RELVERIFY,0,EPNr_Quit,0,0,0
VolumeObject13:
	MO_Object	VolumeknobObject13,GLA_Moused,ID_Volume,0,459,89,41,35,0,GACT_RELVERIFY!GACT_FOLLOWMOUSE,HandleVolume,EPNr_Volume,0,0,VolumeReglerAU
VolumeknobObject13:
	MO_Object	VolumeknobObject23,GLA_Image,ID_Volumeknob,0,459,89,5,5,VolumeknobImage1,0,0,0,0,0,0
VolumeknobObject23:
	MO_Object	VolumeanimObject13,GLA_Image,ID_Volumeknob2,0,459,89,5,5,VolumeknobImage2,0,HandleMuting,0,0,0,0
VolumeanimObject13:
	MO_Object	SpeedObject13,GLA_Image,ID_Volumeanim,0,459,89,41,35,VolumeImage1,0,0,0,0,0,0
SpeedObject13:
	MO_Object	SpeedanimObject13,GLA_Moused,ID_Speed,0,374,150,75,12,0,GACT_RELVERIFY!GACT_FOLLOWMOUSE,HandleSpeed,EPNr_Speed,0,0,SpeedRegler
SpeedanimObject13:
	MO_Object	SpeedknobObject13,GLA_Image,ID_Speedanim,0,374,150,75,12,SpeedImage1,0,0,0,0,0,0
SpeedknobObject13:
	MO_Object	LEDLoadingObject13,GLA_Image,ID_Speedknob,0,374,153,3,7,SpeedknobImage1,0,0,0,0,0,0
LEDLoadingObject13:
	MO_Object	PauseObject13,GLA_Image,ID_LoadingLED,0,145,120,12,7,LEDLoadingImage1,0,0,0,0,0,0
PauseObject13:
	MO_Object	PlayObject13,GLA_Button,ID_Pause,0,212,152,27,21,PauseImage1,GACT_RELVERIFY,0,EPNr_Play,0,0,0
PlayObject13:
	MO_Object	StopObject13,GLA_Button,ID_Play,0,239,152,40,21,PlayImage1,GACT_RELVERIFY,0,EPNr_Play,1,0,0
;	MO_Object	StopObject13,GLA_Button,ID_Play,0,219,152,40,21,PlayImage1,GFLG_Disabled<<16!GACT_RELVERIFY,0,EPNr_Play,1,0,0
StopObject13:
	MO_Object	RecordObject13,GLA_Button,ID_Stop,0,278,152,29,21,StopImage1,GACT_RELVERIFY,0,EPNr_StopPlay,1,0,0
RecordObject13:
	MO_Object	SolidSwitchObject13,GLA_Button,ID_Record,0,173,152,27,21,RecordImage1,GACT_RELVERIFY,0,EPNr_SaveModule,0,0,0
SolidSwitchObject13:
	MO_Object	ShowerSwitchObject13,GLA_Button,ID_SolidSwitch,0,309,27,41,21,0,GACT_IMMEDIATE,HandleAnalyzerSwitches,0,PFlag_AnalyzerSolid,0,0
ShowerSwitchObject13:
	MO_Object	HoriSwitchObject13,GLA_Button,ID_ShowerSwitch,0,349,27,40,21,0,GACT_IMMEDIATE,HandleAnalyzerSwitches,0,PFlag_AnalyzerShower,0,0
HoriSwitchObject13:
	MO_Object	SeethroughSwitchObject13,GLA_Button,ID_HoriSwitch,0,389,27,39,21,0,GACT_IMMEDIATE,HandleAnalyzerSwitches,0,PFlag_AnalyzerHori,0,0
SeethroughSwitchObject13:
	MO_Object	SolidLEDObject13,GLA_Button,ID_SeethroughSwitch,0,428,27,43,21,0,GACT_IMMEDIATE,HandleAnalyzerSwitches,0,PFlag_AnalyzerSeethrough,0,0
SolidLEDObject13:
	MO_Object	ShowerLEDObject13,GLA_Image,ID_SolidLED,0,310,23,39,4,SolidLEDImage1,0,0,0,0,0,0
ShowerLEDObject13:
	MO_Object	HoriLEDObject13,GLA_Image,ID_ShowerLED,0,350,23,39,4,ShowerLEDImage1,0,0,0,0,0,0
HoriLEDObject13:
	MO_Object	SeethroughLEDObject13,GLA_Image,ID_HoriLED,0,390,23,38,4,HoriLEDImage1,0,0,0,0,0,0
SeethroughLEDObject13:
	MO_Object	SolidImageObject13,GLA_Image,ID_SeethroughLED,0,429,23,39,4,SeethroughLEDImage1,0,0,0,0,0,0
SolidImageObject13:
	MO_Object	ShowerImageObject13,GLA_Image,ID_SolidSwitchI,0,309,27,41,21,SolidSwitchImage1,GACT_IMMEDIATE,HandleAnalyzerSwitches,0,PFlag_AnalyzerSolid,0,0
ShowerImageObject13:
	MO_Object	HoriImageObject13,GLA_Image,ID_ShowerSwitchI,0,349,27,40,21,ShowerSwitchImage1,GACT_IMMEDIATE,HandleAnalyzerSwitches,0,PFlag_AnalyzerShower,0,0
HoriImageObject13:
	MO_Object	SeethroughImageObject13,GLA_Image,ID_HoriSwitchI,0,389,27,39,21,HoriSwitchImage1,GACT_IMMEDIATE,HandleAnalyzerSwitches,0,PFlag_AnalyzerHori,0,0
SeethroughImageObject13:
	MO_Object	AnalyzerPSWObject13,GLA_Image,ID_SeethroughSwitchI,0,428,27,43,21,SeethroughSwitchImage1,GACT_IMMEDIATE,HandleAnalyzerSwitches,0,PFlag_AnalyzerSeethrough,0,0
AnalyzerPSWObject13:
	MO_Object	AnalyzerPLEDObject13,GLA_Button,ID_AnalyzerPSW,0,27,27,32,15,AnalyzerPSWImage1,GACT_RELVERIFY,HandleAnalyzerPower,0,PFlag_AnalyzerPower,0,0
AnalyzerPLEDObject13:
	MO_Object	AnalyzerLitObject13,GLA_Image,ID_AnalyzerPLED,0,25,23,36,5,AnalyzerPLEDImage1,0,0,0,0,0,0
AnalyzerLitObject13:
	MO_Object	DiskObject13,GLA_Image,ID_AnalyzerLit,0,114,12,164,43,AnalyzerLitImage1,0,LitAnalyzer,0,0,0,0
DiskObject13:
	MO_Object	AnalyzerUpObject13,GLA_Button,ID_DiskButton,0,170,96,34,22,DiskImage1,GACT_RELVERIFY,HandleLoadModule,EPNr_LoadModule,0,0,0
AnalyzerUpObject13:
	MO_Object	LevelmeterObject13,GLA_Button,ID_AnalyzerUp,0,488,0,18,13,AnalyzerDownImage1,GACT_RELVERIFY,HandleToggles,myNR_ToggleFlag,PFlag_AnalyzerPos,TOGGF_Winrefresh,0
LevelmeterObject13:
	MO_Object	NextModObject13,GLA_Image,ID_Levelmeter,0,321,143,119,2,LevelmeterImage0,0,DoLevelmeter,0,0,0,0
NextModObject13:
	MO_Object	NextSongObject13,GLA_Button,ID_NextMod,0,341,151,28,10,NextModImage1,GACT_RELVERIFY,0,EPNr_NextModule,1,0,0
NextSongObject13:
	MO_Object	NextPosObject13,GLA_Button,ID_NextSong,0,341,163,28,10,NextSongImage1,GACT_RELVERIFY,0,EPNr_NextSong,1,0,0
NextPosObject13:
	MO_Object	PrevModObject13,GLA_Button,ID_NextPos,0,403,163,28,10,NextPosImage1,GACT_IMMEDIATE!MFLG_Repeat,HandleNextPattern,EPNr_NextPattern,1,0,0
PrevModObject13:
	MO_Object	PrevSongObject13,GLA_Button,ID_PrevMod,0,313,151,28,10,PrevModImage1,GACT_RELVERIFY,0,EPNr_PrevModule,1,0,0
PrevSongObject13:
	MO_Object	PrevPosObject13,GLA_Button,ID_PrevSong,0,313,163,28,10,PrevSongImage1,GACT_RELVERIFY,0,EPNr_PrevSong,1,0,0
PrevPosObject13:
	MO_Object	PauseIndicatorObject13,GLA_Button,ID_PrevPos,0,375,163,28,10,PrevPosImage1,GACT_IMMEDIATE!MFLG_Repeat,HandlePrevPattern,EPNr_PrevPattern,1,0,0
PauseIndicatorObject13:
	MO_Object	PlayIndicatorObject13,GLA_Image,ID_PauseIndicator,0,247,141,10,8,PauseIndicatorImage1,0,HandlePauseLED,0,0,0,0
PlayIndicatorObject13:
	MO_Object	LEDSongendObject13,GLA_Image,ID_PlayIndicator,0,260,141,11,7,PlayIndicatorImage1,0,HandlePlayLED,0,0,0,0
LEDSongendObject13:
	MO_Object	LEDFilterObject13,GLA_Image,ID_SongendLED,0,71,141,15,5,LEDSongendImage1,0,0,0,0,0,0
LEDFilterObject13:
	MO_Object	LEDRandomObject13,GLA_Image,ID_FilterLED,0,92,141,14,5,LEDFilterImage1,0,0,0,0,0,0
LEDRandomObject13:
	MO_Object	LEDTimeoutObject13,GLA_Image,ID_RandomLED,0,111,141,14,5,LEDRandomImage1,0,0,0,0,0,0
LEDTimeoutObject13:
	MO_Object	LEDFadeinObject13,GLA_Image,ID_TimeoutLED,0,131,141,14,5,LEDTimeoutImage1,0,0,0,0,0,0
LEDFadeinObject13:
	MO_Object	SongendObject13,GLA_Image,ID_FadeinLED,0,150,141,16,5,LEDFadeinImage1,0,0,0,0,0,0
SongendObject13:
	MO_Object	FilterObject13,GLA_Button,ID_Songend,0,72,147,13,11,KnobImage1,GACT_RELVERIFY,0,EPNr_SongEnd,-1,0,0
FilterObject13:
	MO_Object	RandomObject13,GLA_Button,ID_Filter,0,92,147,13,11,KnobImage1,GACT_RELVERIFY,0,EPNr_Filter,-1,0,0
RandomObject13:
	MO_Object	TimeoutObject13,GLA_Button,ID_Random,0,112,147,13,11,KnobImage1,GACT_RELVERIFY,ChangeRandom,EPNr_ProgramMode,3,0,0
TimeoutObject13:
	MO_Object	FadeinObject13,GLA_Button,ID_Timeout,0,132,147,13,11,KnobImage1,GACT_RELVERIFY,ChangeTimeout,EPNr_PlayTime,100,0,0
FadeinObject13:
	MO_Object	FontObject13,GLA_Button,ID_Fadein,0,152,147,13,11,KnobImage1,GACT_RELVERIFY,0,EPNr_FadeIn,-1,0,0
FontObject13:		;bei Fontobjekten UserData.w = Breite pro Char
	MO_Object	NameTempObject13,GLA_Image,ID_Font1,0,0,0,2688,12,FontImage1,0,0,0,Font1_Prop,0,12
NameTempObject13:	;bei Textdisplayobjekten UserData.l = Adresse des Fonts
	MO_Object	TimeDisplayObject13,GLA_TextField,ID_Textname1,0,240,83,200,12,NametempNImage1,0,HandleModname,0,0,0,FontObject13
TimeDisplayObject13:
	MO_Object	SetTimeBackwardsObject13,GLA_TextField,ID_TimeDisplay,0,240,113,72,12,TimeTempNImage1,0,HandleShowTime,0,0,0,FontObject13
SetTimeBackwardsObject13:
	MO_Object	TrackTempObject13,GLA_Button,ID_SetTimeBackwards,0,218,113,21,10,0,GACT_RELVERIFY,HandleToggles,myNR_ToggleFlag,PFfag_TimeBackwards,0,0
TrackTempObject13:
	MO_Object	AnalyzerOnOffObject13,GLA_TextField,ID_TextTrack1,0,240,97,60,12,TrackNImage1,0,TrackDisp1,0,0,0,FontObject13
AnalyzerOnOffObject13:
	MO_Object	ZipWinObject13,GLA_Button,ID_AnalyzerOnOff,0,454,68,18,14,AnalyzerOnOffImage1,GACT_RELVERIFY,HandleToggles,myNR_ToggleFlag,PFlag_Analyzer,TOGGF_Winrefresh,0
ZipWinObject13:
	MO_Object	WinUpfrontObject13,GLA_Button,ID_ZipWinOnOff,0,471,68,19,14,ZipWinImage1,GACT_RELVERIFY,HandleToggles,myNR_ToggleFlag,PFlag_Minimized,TOGGF_Winrefresh,0
WinUpfrontObject13:
	MO_Object	TrayAnimObject13,GLA_WinDepth,ID_None,0,489,68,18,14,WinUpfrontImage1,0,0,0,0,0,0
TrayAnimObject13:
	MO_Object	CommandBarAnimObject13,GLA_Image,ID_TrayAnim,0,25,89,154,47,TrayAnimImage1,0,0,0,0,0,0
CommandBarAnimObject13:
	MO_Object	CommandBarOnObject13,GLA_Image,ID_CommandBarAnim,0,200,178,326,16,CommandBarAnimImage1,0,0,0,0,0,0
CommandBarOnObject13:
	MO_Object	CommandBarOffObject13,GLA_Button,ID_CommandBarOn,0,200,178,70,10,CommandBarImage1,GACT_RELVERIFY,HandleCommandBarOn,myNR_ToggleFlag,0,TOGGF_WinRefresh,0
CommandBarOffObject13:
	MO_Object	CBTManagerObject13,GLA_Button,ID_CommandBarOff,0,200,178,70,18,0,GFLG_Disabled<<16!GACT_RELVERIFY,HandleCommandBarOff,myNR_ToggleFlag,PFlag_CommandBar,0,0
CBTManagerObject13:
	MO_Object	CBTAmpManagerObject13,GLA_Button,ID_ShowManager,0,270,180,43,11,CBTManagerImage1,GFLG_Disabled<<16!GACT_RELVERIFY,HandleManager,0,0,0,0
CBTAmpManagerObject13:
	MO_Object	CBTModinfoObject13,GLA_Button,ID_ShowAmpManager,0,319,180,56,11,CBTAmpManagerImage1,GFLG_Disabled<<16!GACT_RELVERIFY,HandleAmpManager,0,0,0,0
CBTModinfoObject13:
	MO_Object	CBTFormatloaderObject13,GLA_Button,ID_ShowModinfo,0,381,180,52,11,CBTModinfoImage1,GFLG_Disabled<<16!GACT_RELVERIFY,HandleModuleinfo,0,0,0,0
CBTFormatloaderObject13:
	MO_Object	AnalyzerstatesObject13,GLA_Button,ID_ShowFormatloader,0,439,180,63,11,CBTFormatloadImage1,GFLG_Disabled<<16!GACT_RELVERIFY,HandleFormatloader,0,0,0,0
AnalyzerstatesObject13:
	MO_Object	AnalyzerMapObject13,GLA_Image,ID_Analyzerstates,0,122,12,19*4,20,AnalyzerStatesImage,0,0,0,0,0,0
AnalyzerMapObject13:
	MO_Object	BalanceObject13,GLA_Image,ID_AnalyzerMap,0,122,12,148,38,AnalyzerMapImage,0,HandleAnalyzer,0,0,0,0
BalanceObject13:
	MO_Object	BalanceknobObject13,GLA_Moused,ID_Balance,0,469,152,21,20,0,GACT_RELVERIFY!GACT_FOLLOWMOUSE,HandleBalance,EPNr_Balance,0,0,BalanceReglerAU
BalanceknobObject13:
	MO_Object	BalanceanimObject13,GLA_Image,ID_Balanceknob,0,469,152,5,4,BalanceknobImage1,0,0,0,0,0,0
BalanceanimObject13:
	MO_Object	MuteObject13,GLA_Image,ID_Balanceanim,0,469,152,21,20,BalanceImage1,0,0,0,0,0,0
MuteObject13:
	MO_Object	SetTimeoutObject13,GLA_Button,ID_Mute,0,465,128,11,11,Muteknob1,GACT_RELVERIFY,HandleMute,0,0,0,0
SetTimeoutObject13:
	MO_Object	FontObject23,GLA_Button,ID_SetTimeout,0,129,172,18,9,SetTimeoutImage1,GACT_RELVERIFY,0,EPNr_PlayTime,0,0,0
FontObject23:
	MO_Object	SoundSysTempObject13,GLA_Image,ID_Font2,0,0,0,582,8,FontImage2,0,0,0,0,0,6
SoundSysTempObject13:	;bei Textdisplayobjekten UserData.l = Adresse des Fonts
	MO_Object	PatternTempObject13,GLA_TextField,ID_TextSoundsys1,0,241,127,200,8,SoundSystemNImage1,0,ShowSoundsys,0,0,0,FontObject23
PatternTempObject13:
	MO_Object	PatternInitTempObject13,GLA_TextField,ID_TextPattern1,0,343,115,100,8,PatternNImage1,0,PatternDisp,0,0,0,FontObject23
PatternInitTempObject13:
	MO_Object	SubsongTempObject13,GLA_Dummy,ID_TextPatternInit1,0,343,115,100,8,0,0,InitPatternDisp,0,0,0,0
SubsongTempObject13:
	MO_Object	TrackTempObject23,GLA_TextField,ID_TextSubsong1,0,343,99,100,8,PatternNImage1,0,SubsongDisp,0,0,0,FontObject23
TrackTempObject23:
	MO_Object	ShowActiveAmplifierObject13,GLA_TextField,ID_TextTrack2,0,285,99,40,8,Track2NImage1,0,TrackDisp2,0,0,0,FontObject23
ShowActiveAmplifierObject13:
	MO_Object	ShowDLViewerObject13,GLA_Button,ID_ShowActiveAmplifier,0,217,125,22,9,0,GACT_RELVERIFY,HandleActiveAmplifier,0,0,0,0
ShowDLViewerObject13:
	MO_Object	0,GLA_Button,ID_ShowDLViewer,0,217,96,22,14,0,GACT_RELVERIFY,HandleDLViewer,0,0,0,0
;
;RemoteSwitchObject13:
;	MO_Object	SpeedObject13,GLA_Button,ID_RemoteOnOff,0,23,137,22,13,0,GACT_RELVERIFY,HandleToggles,myNR_ToggleFlag,PFlag_Remote,TOGGF_Winrefresh,0
;

;---------------------------- Imagedefinitionen -------------------------------------
;
;nachfolgend bis END_IMAGES nur "IML_"-Imagestrukturen unterbringen, wichtig !!!
;
;IML_Next,IML_Rendered,IML_Width,IML_Height,IML_Type,IML_ColourMap,IML_Data
START_IMAGES:

BackImage1:		IM_Object	0,0,534,129,4,0,Data_BackImageMain

DiskImage1:		IM_Object	DiskImage2,0,34,22,4,0,Data_DiskImage1 ;bei Buttons jeweils mglichst 
									       ;min. 2 Images angeben, (<2 wird auch toleriert)
DiskImage2:		IM_Object	0,0,34,22,4,0,Data_DiskImage2          ;vorraussichtlich auf 3 erweitern
									       ;(disabled Buttons)
PowerImage1:		IM_Object	PowerImage2,0,36,21,4,0,Data_PowerImage1
PowerImage2:		IM_Object	0,0,36,21,4,0,Data_PowerImage2

VolumeImage1:		IM_Object	VolumeImage2,0,41,35,4,0,Data_Volume1
VolumeImage2:		IM_Object	0,0,41,35,4,0,Data_Volume2

VolumeknobImage1:	IM_Object	0,0,5,5,4,0,Data_Volumeknob1
VolumeknobImage2:	IM_Object	0,0,5,5,4,0,Data_Volumeknob2

BalanceImage1:		IM_Object	BalanceImage2,0,21,20,4,0,Data_Balance1
BalanceImage2:		IM_Object	0,0,21,20,4,0,Data_Balance2
BalanceknobImage1:	IM_Object	0,0,5,4,4,0,Data_Balanceknob1

SpeedImage1:		IM_Object	SpeedImage2,0,75,12,4,0,Data_Speed1
SpeedImage2:		IM_Object	0,0,75,12,4,0,Data_Speed2
SpeedknobImage1:	IM_Object	0,0,3,7,4,0,Data_Speedknob1

LEDLoadingImage1:	IM_Object	LEDLoadingImage2,0,12,7,4,0,Data_LEDLoading1
LEDLoadingImage2:	IM_Object	0,0,12,7,4,0,Data_LEDLoading2

PauseImage1:		IM_Object	PauseImage2,0,27,21,4,0,Data_Pause1
PauseImage2:		IM_Object	0,0,27,21,4,0,Data_Pause2

PlayImage1:		IM_Object	PlayImage2,0,40,21,4,0,Data_Play1
PlayImage2:		IM_Object	0,0,40,21,4,0,Data_Play2

StopImage1:		IM_Object	StopImage2,0,29,21,4,0,Data_Stop1
StopImage2:		IM_Object	0,0,29,21,4,0,Data_Stop2

RecordImage1:		IM_Object	RecordImage2,0,27,21,4,0,Data_Record1
RecordImage2:		IM_Object	0,0,27,21,4,0,Data_Record2

AnalyzerDownImage1:	IM_Object	AnalyzerDownImage2,0,18,13,4,0,Data_AnalyzerDown1
AnalyzerDownImage2:	IM_Object	0,0,18,13,4,0,Data_AnalyzerDown2

AnalyzerUpImage1:	IM_Object	AnalyzerUpImage2,0,18,13,4,0,Data_AnalyzerUp1
AnalyzerUpImage2:	IM_Object	0,0,18,13,4,0,Data_AnalyzerUp2

LevelmeterImage0:	IM_Object	LevelmeterImage1,0,119,2,4,0,Data_Levelmeter0
LevelmeterImage1:	IM_Object	LevelmeterImage2,0,119,2,4,0,Data_Levelmeter1
LevelmeterImage2:	IM_Object	LevelmeterImage3,0,119,2,4,0,Data_Levelmeter2
LevelmeterImage3:	IM_Object	LevelmeterImage4,0,119,2,4,0,Data_Levelmeter3
LevelmeterImage4:	IM_Object	LevelmeterImage5,0,119,2,4,0,Data_Levelmeter4
LevelmeterImage5:	IM_Object	LevelmeterImage6,0,119,2,4,0,Data_Levelmeter5
LevelmeterImage6:	IM_Object	LevelmeterImage7,0,119,2,4,0,Data_Levelmeter6
LevelmeterImage7:	IM_Object	LevelmeterImage8,0,119,2,4,0,Data_Levelmeter7
LevelmeterImage8:	IM_Object	LevelmeterImage9,0,119,2,4,0,Data_Levelmeter8
LevelmeterImage9:	IM_Object	LevelmeterImage10,0,119,2,4,0,Data_Levelmeter9
LevelmeterImage10:	IM_Object	LevelmeterImage11,0,119,2,4,0,Data_LevelmeterA
LevelmeterImage11:	IM_Object	LevelmeterImage12,0,119,2,4,0,Data_LevelmeterB
LevelmeterImage12:	IM_Object	LevelmeterImage13,0,119,2,4,0,Data_LevelmeterC
LevelmeterImage13:	IM_Object	LevelmeterImage14,0,119,2,4,0,Data_LevelmeterD
LevelmeterImage14:	IM_Object	LevelmeterImage15,0,119,2,4,0,Data_LevelmeterE
LevelmeterImage15:	IM_Object	LevelmeterImage16,0,119,2,4,0,Data_LevelmeterF
LevelmeterImage16:	IM_Object	0,0,119,2,4,0,Data_Levelmeter10

NextPosImage1:		IM_Object	NextPosImage2,0,28,10,4,0,Data_NextPos1
NextPosImage2:		IM_Object	NextPosImage3,0,28,10,4,0,Data_NextPos2
NextPosImage3:		IM_Object	0,0,28,10,4,0,Data_NextPos3
PrevPosImage1:		IM_Object	PrevPosImage2,0,28,10,4,0,Data_PrevPos1
PrevPosImage2:		IM_Object	PrevPosImage3,0,28,10,4,0,Data_PrevPos2
PrevPosImage3:		IM_Object	0,0,28,10,4,0,Data_PrevPos3

NextSongImage1:		IM_Object	NextSongImage2,0,28,10,4,0,Data_NextSong1
NextSongImage2:		IM_Object	NextSongImage3,0,28,10,4,0,Data_NextSong2
NextSongImage3:		IM_Object	0,0,28,10,4,0,Data_NextSong3
PrevSongImage1:		IM_Object	PrevSongImage2,0,28,10,4,0,Data_PrevSong1
PrevSongImage2:		IM_Object	PrevSongImage3,0,28,10,4,0,Data_PrevSong2
PrevSongImage3:		IM_Object	0,0,28,10,4,0,Data_PrevSong3

NextModImage1:		IM_Object	NextModImage2,0,28,10,4,0,Data_NextMod1
NextModImage2:		IM_Object	NextModImage3,0,28,10,4,0,Data_NextMod2
NextModImage3:		IM_Object	0,0,28,10,4,0,Data_NextMod3
PrevModImage1:		IM_Object	PrevModImage2,0,28,10,4,0,Data_PrevMod1
PrevModImage2:		IM_Object	PrevModImage3,0,28,10,4,0,Data_PrevMod2
PrevModImage3:		IM_Object	0,0,28,10,4,0,Data_PrevMod3

PauseIndicatorImage1:	IM_Object	PauseIndicatorImage2,0,10,8,4,0,Data_PauseIndicator1
PauseIndicatorImage2:	IM_Object	0,0,10,8,4,0,Data_PauseIndicator2

PlayIndicatorImage1:	IM_Object	PlayIndicatorImage2,0,11,7,4,0,Data_PlayIndicator1
PlayIndicatorImage2:	IM_Object	0,0,11,7,4,0,Data_PlayIndicator2

;Highlighted und normales Image bei Songend vertauscht, da EMPY das als RepeatModule handhabt
LEDSongendImage1:	IM_Object	LEDSongendImage2,0,15,5,4,0,Data_LEDSongend2
LEDSongendImage2:	IM_Object	0,0,15,5,4,0,Data_LEDSongend1

LEDFilterImage1:	IM_Object	LEDFilterImage2,0,14,5,4,0,Data_LEDFilter1
LEDFilterImage2:	IM_Object	0,0,14,5,4,0,Data_LEDFilter2

LEDRandomImage1:	IM_Object	LEDRandomImage2,0,14,5,4,0,Data_LEDRandom1
LEDRandomImage2:	IM_Object	0,0,14,5,4,0,Data_LEDRandom2

LEDTimeoutImage1:	IM_Object	LEDTimeoutImage2,0,14,5,4,0,Data_LEDTimeout1
LEDTimeoutImage2:	IM_Object	0,0,14,5,4,0,Data_LEDTimeout2

LEDFadeinImage1:	IM_Object	LEDFadeinImage2,0,16,5,4,0,Data_LEDFadein1
LEDFadeinImage2:	IM_Object	0,0,16,5,4,0,Data_LEDFadein2

KnobImage1:		IM_Object	KnobImage2,0,13,11,4,0,Data_Knob1
KnobImage2:		IM_Object	0,0,13,11,4,0,Data_Knob2

FontImage1:		IM_Object	FontImage11,0,2688,12,0,Data_Font1Palette,Data_Font1
FontImage11:		IM_Object	0,0,2688,12,0,Data_Font1Palette,Data_Font11

FontImage2:		IM_Object	0,0,582,8,0,Data_Font2Palette,Data_Font2

NametempNImage1:	IM_Object	0,0,200,12,0,0,Data_NametempN1
TimeTempNImage1:	IM_Object	0,0,72,12,0,0,Data_TimetempN1
TrackNImage1:		IM_Object	0,0,60,12,0,0,Data_TracktempN1
SoundSystemNImage1:	IM_Object	0,0,200,8,0,0,Data_NametempN1
PatternNImage1:		IM_Object	0,0,100,8,0,0,Data_NametempN1
Track2NImage1:		IM_Object	0,0,40,8,0,0,Data_NametempN1


AnalyzerOnOffImage1:	IM_Object	AnalyzerOnOffImage2,0,18,14,4,0,Data_AnalyzerOnOffImage1
AnalyzerOnOffImage2:	IM_Object	0,0,18,14,4,0,Data_AnalyzerOnOffImage2

ZipWinImage1:		IM_Object	ZipWinImage2,0,19,14,4,0,Data_ZipWinImage1
ZipWinImage2:		IM_Object	0,0,19,14,4,0,Data_ZipWinImage2

WinUpfrontImage1:	IM_Object	WinUpfrontImage2,0,18,14,4,0,Data_WinUpfrontImage1
WinUpfrontImage2:	IM_Object	0,0,18,14,4,0,Data_WinUpfrontImage2

TrayAnimImage1:		IM_Object	TrayAnimImage2,0,154,47,4,0,Data_TrayAnim1
TrayAnimImage2:		IM_Object	TrayAnimImage3,0,154,47,4,0,Data_TrayAnim2
TrayAnimImage3:		IM_Object	0,0,154,47,4,0,Data_TrayAnim3

CommandBarAnimImage1:	IM_Object	CommandBarAnimImage2,0,326,16,4,0,Data_CommandBarAnim1
CommandBarAnimImage2:	IM_Object	CommandBarAnimImage3,0,326,16,4,0,Data_CommandBarAnim2
CommandBarAnimImage3:	IM_Object	0,0,326,16,4,0,Data_CommandBarAnim3

CommandBarImage1:	IM_Object	CommandBarImage2,0,326,16,4,0,Data_CommandBarAnim1
CommandBarImage2:	IM_Object	0,0,326,16,4,0,Data_CommandBarSelected

CBTManagerImage1:	IM_Object	CBTManagerImage2,0,43,11,4,0,Data_CBTManager1
CBTManagerImage2:	IM_Object	0,0,43,11,4,0,Data_CBTManager2

CBTAmpManagerImage1:	IM_Object	CBTAmpManagerImage2,0,56,11,4,0,Data_CBTAmpManager1
CBTAmpManagerImage2:	IM_Object	0,0,56,11,4,0,Data_CBTAmpManager2

CBTModinfoImage1:	IM_Object	CBTModinfoImage2,0,52,11,4,0,Data_CBTModinfo1
CBTModinfoImage2:	IM_Object	0,0,52,11,4,0,Data_CBTModinfo2

CBTFormatloadImage1:	IM_Object	CBTFormatloadImage2,0,63,11,4,0,Data_CBTFormatload1
CBTFormatloadImage2:	IM_Object	0,0,63,11,4,0,Data_CBTFormatload2

BackImage3:		IM_Object	0,0,345,32,4,0,Data_Minimizedbackground
PowerImage3:		IM_Object	PowerImage31,0,35,21,4,0,Data_MinimizedPower1
PowerImage31:		IM_Object	0,0,35,21,4,0,Data_MinimizedPower2
NametempMImage1:	IM_Object	0,0,176,12,0,0,Data_NameTempN1

Muteknob1:		IM_Object	Muteknob2,0,11,11,4,0,Data_muteknob1
Muteknob2:		IM_Object	0,0,11,11,4,0,Data_muteknob2

SetTimeoutImage1:	IM_Object	SetTimeoutImage2,0,18,9,4,0,Data_Timeoutknob1
SetTimeoutImage2:	IM_Object	0,0,18,9,4,0,Data_Timeoutknob2

;
;
;
; Images fr den Analyzer
BackImage2:		IM_Object	0,0,534,68,4,0,Data_BackImageAnalyzer

AnalyzerMapImage:	IM_Object	0,0,148,38,5,0,FFT_TrueBuffer
AnalyzerstatesImage:	IM_Object	AnalyzerstatesImage2,0,19*4,20,5,0,Data_Analyzerstates
AnalyzerstatesImage2:	IM_Object	0,0,148,20,5,0,Data_Analyzerstates2

;AnalyzerstatesImage2:	IM_Object	0,0,32*4,17,3,0,Data_Analyzerstates2
;

SolidSwitchImage1:	IM_Object	SolidSwitchImage2,0,41,21,4,0,Data_SolidSwitch1
SolidSwitchImage2:	IM_Object	0,0,41,21,4,0,Data_SolidSwitch2

SeethroughSwitchImage1:	IM_Object	SeethroughSwitchImage2,0,43,21,4,0,Data_SeethroughSwitch1
SeethroughSwitchImage2:	IM_Object	0,0,43,21,4,0,Data_SeethroughSwitch2

ShowerSwitchImage1:	IM_Object	ShowerSwitchImage2,0,40,21,4,0,Data_ShowerSwitch1
ShowerSwitchImage2:	IM_Object	0,0,40,21,4,0,Data_ShowerSwitch2

HoriSwitchImage1:	IM_Object	HoriSwitchImage2,0,39,21,4,0,Data_HoriSwitch1
HoriSwitchImage2:	IM_Object	0,0,39,21,4,0,Data_HoriSwitch2

SolidLEDImage1:		IM_Object	SolidLEDImage2,0,39,4,4,0,Data_SolidLED1
SolidLEDImage2:		IM_Object	0,0,39,5,4,0,Data_SolidLED2

SeethroughLEDImage1:	IM_Object	SeethroughLEDImage2,0,39,4,4,0,Data_SeethroughLED1
SeethroughLEDImage2:	IM_Object	0,0,39,5,4,0,Data_SeethroughLED2

ShowerLEDImage1:	IM_Object	ShowerLEDImage2,0,39,4,4,0,Data_ShowerLED1
ShowerLEDImage2:	IM_Object	0,0,39,5,4,0,Data_ShowerLED2

HoriLEDImage1:		IM_Object	HoriLEDImage2,0,38,4,4,0,Data_HoriLED1
HoriLEDImage2:		IM_Object	0,0,38,5,4,0,Data_HoriLED2

AnalyzerPLEDImage1:	IM_Object	AnalyzerPLEDImage2,0,36,5,4,0,Data_AnalyzerPLed1
AnalyzerPLEDImage2:	IM_Object	0,0,36,5,4,0,Data_AnalyzerPLed2

AnalyzerPSWImage1:	IM_Object	AnalyzerPSWImage2,0,32,15,4,0,Data_AnalyzerPSwitch1
AnalyzerPSWImage2:	IM_Object	0,0,32,15,4,0,Data_AnalyzerPSwitch2

AnalyzerLitImage1:	IM_Object	AnalyzerLitImage2,0,164,43,4,0,Data_AnalyzerLit1
AnalyzerLitImage2:	IM_Object	0,0,164,43,4,0,Data_AnalyzerLit2

END_IMAGES:
;---------------------------------------------------------------------------------------------------






;ProportionalTabelle fr groen Font (font1)
Font1_Prop:
 dc.b    08,03,07,10,09,11,10,05,06,06,05,08,03,08,03,11,07,03,08,07,07,08,08,08,08,08,04,04,08,08,08,08,12,09,09,09,09
;           !  "  #  $  %  &    (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D

 dc.b    08,08,09,10,04,05,09,07,11,09,11,09,11,09,08,09,09,08,11,09,09,10,06,11,06,09,11,05,08,06,07,08,07,06,08,07,03
;        E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i

 dc.b    04,06,04,10,07,07,06,07,05,06,05,07,07,11,08,07,06,05,03,05,08,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12
;        j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~  #                              

 dc.b    12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,04,07,07,08,07,03,07,08,11,05,07,08,12,11,09,06,07,06,06
;                                                                                  

 dc.b    05,07,08,04,04,04,05,07,12,12,12,07,09,09,09,09,09,09,12,09,08,08,08,08,04,04,04,04,09,09,10,10,10,10,10,07,12
;                                                                                

 dc.b    08,08,08,08,08,08,07,07,07,07,07,07,07,11,07,07,07,07,07,04,04,04,04,07,07,07,07,07,07,07,07,08,07,07,07,07,08
;                                                                                

 dc.b    09,09
;          


;logarithmische Skala fr Levelmeter-Display, 10 * lg (x/xdef), somit "echte" Leistungsanzeige
LevelmeterTab:
	dc.w	1,3,5,10,19,36,66,123,228,423,784,1453,2694,4993,9256,16384

;logarithmische Skala fr Analyzer-Display, 20 * lg (x/xdef)
;bei Modifikationen FFT_Analyzertabsize beachten
AnalyzerTab2:
; dc.w 00006,00014,00025,00045,00091,00142,00253,00450,00800,01423,01950,02530,03185,04500,08978,16384
 ;      -60   -50   -45   -40   -35   -30   -25   -20   -15   -10    -7    -5           0     6    12

 dc.w 0031,00050,00079
 ;     -40   -36   -32
 dc.w 00126,00158,00200,00251,00317,00399,00502,00632,00796,01002,01261,01588,02000,02518
 ;      -28   -26   -24   -22   -20   -18   -16   -12   -12   -10    -8    -6    -4    -2
 dc.w 3174,04489,16384
 ;       0     3    15

	even

;Koordinaten der im Remote-Modus zu setzenden Pixel
RemotePixelCoords:
	dc.w	9,28,7,27,6,26,5,25,4,24,3,23,2,22,2,21,1,20,1,19,0,18,0,17,0,16,0,15,0,14
	dc.w	0,13,0,12,1,11,1,10,2,9,2,8,3,7,4,6,5,5,6,4,7,3,8,3,9,2,10,2,11,1,12,1,13,1
	dc.w	14,0,15,0,16,0,17,0,18,0,19,0,20,0,21,0,22,0,23,1,24,1,25,1,26,2,27,2,28,3
	dc.w	29,3,30,4,31,5,32,6,33,7,34,8,34,9,35,10,35,11,36,12,36,13,36,14,36,15,36,16
	dc.w	36,17,36,18,35,19,35,20,34,21,34,22,33,23,32,24,31,25,30,26,29,27,27,28

;Welcher Lautstrkewert gilt fr welche Anzahl von zu setzenden hellen Pixels ?
RemoteColouredPixels:
	dc.w	73	;max. Anzahl
	dc.w	00,01,02,03,03,04,05,06,08,09,10,12,13,15,16,17,19,20,21,22
	dc.w	23,24,25,26,27,29,30,31,32,33,34,35,37
	dc.w	39,40,41,42,43,44,45,47,48,49,50,51,52,53,54,55,57,58,59,61
	dc.w	62,64,65,66,67,69,70,71,72,72,73,73,73

;Tabelle, falls Mastervolume nicht eingeschaltet ist, fr UPS Handling
FFT_vol64:	dc.w	64,64,64,64

;Tabelle fr Umschaltung der AnalyzerModi
;Aufbau:
; 1. LW:      entsprechendes Flag
; 2. W:      gesetzter Schalter
; 3./4./5.W: offene Schalter
; 6. W:      eingeschaltete LED
; 7./8./9.W: ausgeschaltete LED`s
; 10. LW:     Display-Routine
AnalyzerPrefstab:
 dc.l	PFlag_AnalyzerSolid
 dc.w	ID_SolidSwitchI,ID_ShowerSwitchI,ID_HoriSwitchI,ID_SeethroughSwitchI
 dc.w	ID_SolidLED,ID_ShowerLED,ID_HoriLED,ID_SeethroughLED
 dc.l	Mode01Scope

APT_Length=*-AnalyzerPrefstab

 dc.l	PFlag_AnalyzerShower
 dc.w	ID_ShowerSwitchI,ID_SolidSwitchI,ID_HoriSwitchI,ID_SeethroughSwitchI
 dc.w	ID_ShowerLED,ID_SolidLED,ID_HoriLED,ID_SeethroughLED
 dc.l	Mode02Scope

 dc.l	PFlag_AnalyzerHori
 dc.w	ID_HoriSwitchI,ID_SolidSwitchI,ID_ShowerSwitchI,ID_SeethroughSwitchI
 dc.w	ID_HoriLED,ID_ShowerLED,ID_SolidLED,ID_SeethroughLED
 dc.l	Mode03Scope

 dc.l	PFlag_AnalyzerSeethrough
 dc.w	ID_SeethroughSwitchI,ID_SolidSwitchI,ID_ShowerSwitchI,ID_HoriSwitchI
 dc.w	ID_SeethroughLED,ID_SolidLED,ID_ShowerLED,ID_HoriLED
 dc.l	Mode04Scope

 dc.l	~0 ;Default
 dc.w	ID_SolidSwitchI,ID_ShowerSwitchI,ID_HoriSwitchI,ID_SeethroughSwitchI
 dc.w	ID_SolidLED,ID_ShowerLED,ID_HoriLED,ID_SeethroughLED
 dc.l	Mode01Scope

;Tabelle fr Umschaltung der Kommandozeile
;Aufbau:
; Liste der abzuschaltenden Gadgets mit ID.w, 0-terminiert,
; danach Liste der einzuschaltenden Gadgets mit ID.w, 0-terminiert
CommandBarTab1:
	dc.w	ID_CommandBarOff,ID_ShowManager,ID_ShowAmpManager,ID_ShowModinfo,ID_ShowFormatloader,0
	dc.w	ID_CommandBarOn,0
CommandBarTab2:
	dc.w	ID_CommandBarOn,0
	dc.w	ID_CommandBarOff,ID_ShowManager,ID_ShowAmpManager,ID_ShowModinfo,ID_ShowFormatloader,0

;Hanning Window fr gemixte Werte
	if	FFT_N<>64
		Printt	"He Du ! Denk an die FFT_Windowtable:"
	endc
FFT_Windowtable:
;	incdir	sources:fft/
	incdir  ep:src/Engines/EmpyTrue/
	include	hanning128.txt
;	include	hanning256.txt

;Emphasis fr Hhenanhebung nach der FFT, normiert auf 65536=1
	if	FFT_Displayentries<>37
		Printt	"He Du ! Denk an die FFT_Emphasistable:"
	endc
FFT_Emphasistable:
	dc.l	43690
	dc.l	46811
	dc.l	54613
	dc.l	65536
	dc.l	69078
	dc.l	79705
	dc.l	81477
	dc.l	83248
	dc.l	85019
	dc.l	86790
	dc.l	88562
	dc.l	90333
	dc.l	92104
	dc.l	93875
	dc.l	95647
	dc.l	97418
	dc.l	99189
	dc.l	100960
	dc.l	100960
	dc.l	102732
	dc.l	104503
	dc.l	106274
	dc.l	108045
	dc.l	109817
	dc.l	111588
	dc.l	113359
	dc.l	115130
	dc.l	116902
	dc.l	118673
	dc.l	120444
	dc.l	120444
	dc.l	120444
	dc.l	120444
	dc.l	118673
	dc.l	116902
	dc.l	115130
	dc.l	113359

	section	1,data
gfx:
	incdir  EP:Src/Engines/EmpyTrue/
;	incdir	sources:engines/empytrue/
;	incdir	eps:sources/engines/empytrue/
	include	EmpyTruegfx.s
Gfxsize=*-gfx

	section	2,data
gfx2:
	include	EmpyTruegfx2.s
Gfxsize2=*-gfx2


	section	3,bss
Datas:
Exec_base	ds.l	1
Int_base	ds.l	1
Dos_base	ds.l	1
Gfx_base	ds.l	1
Util_base	ds.l	1
mathffp		ds.l	1
mathtrans	ds.l	1
guigfx		ds.l	1

mytags:		ds.l	20*2		;temporres Tagarray, nur valid fr einen Aufruf, wird
					;von praktisch allen Routinen verwendet, also mglichst
					;direkt vor Aufruf der entsprechenden Systemfunktion
					;verwenden
; Fensterbezogene Daten
mywindowlist:	ds.l	1		;momentan benutzte Windowliste
WinHandle:	ds.l	1
mypubscreen:	ds.l	1
mycmap:		ds.l	1		;fr Farballozierung
myScreentitle:	ds.l	1
tmpIMsg		ds.b	im_SIZEOF
ScrollSignal	ds.l	1		;Signal fr z.B. Blinken der Playbesttigung, Analyzer etc.
LastMenu	ds.l	1		;letztes verwendetes Men, falls Window open/close von Engine selbst ausgelst
AcceptRefresh	ds.b	1
		ds.b	1
PattTime	ds.w	1		;Delay fr IDCMPUPDATE Requests


; EP bezogene Daten
NextSelect	ds.l	1		;falls mehrere Menitems selektiert wurden...

; Daten fr Image-Berechnungen 
psm		ds.l	1
drawhandle	ds.l	1

Renderdepth	ds.w	1		;max. Tiefe der allozierten Farben
CI_UsedWindowList	ds.l	1	;Windowlist, die beim Erzeugen der Images verwendet wurde
CI_ScreenDepth		ds.b	1	;Tiefe des Screens merken, damit nicht stndig GetBitmapattr aufgerufen werden muss
			ds.b	1
TempDataArray		ds.l	1	;temporres Array fr die umgerechneten Chunkies
TempDataArraySize	ds.l	1	;Gre
TempBitmap1:	ds.l	1		;temporrer Pointer fr allozierte Bitmap
TempBitmap2:	ds.l	1		;temporre Bitmap fr WritePixelarray8
TempRastport1	ds.b	rp_SIZEOF	;imaginrer Rastport fr WritePixelarray8
TempRastport2	ds.b	rp_SIZEOF	;tempRastport fr WritePixelarray8

TempRastport3	ds.b	rp_SIZEOF	;tempRastport fr Printtext
TempRastport4	ds.b	rp_SIZEOF	;tempRastport fr Remote Volume

; Daten fr Gadgets
GD_FirstGadget:	ds.l	1		;erstes erzeugtes Gadget
GD_Count:	ds.w	1		;Anzahl der Gadgets, die erzeugt wurden
GD_PreviousGad:	ds.l	1		;fr Verkettung der Boopsi-Gadgets
GD_MyClass:	ds.l	1		;Custom-Class fr Gadget-Images
GD_LastImage:	ds.l	1		;hier Custom-Image gesichert, falls Fehler beim allozieren des Button-Objektes
GD_GadgetsIn:	ds.b	1		;Flag, ob Gadgets im Hauptfenster eingebunden
TrayOpen	ds.b	1		;Flag, ob Schublade offen/geschlossen

; Daten des Interruptservers
Ticks:		ds.w	1		;rundlaufender Zhler

; Daten fr diverse Unterroutinen
Modnametmp:	ds.b	32		;ASCII-Zwischenspeicher fr Namensanzeige
soundsystmp:	ds.b	64		;ASCII-Zwischenspeicher fr Soundsystemanzeige
timetmp:	ds.b	10		;ASCII-Zwischenspeicher fr Zeitanzeige
PattTmp2:	ds.b	20		;ASCII-Zwischenspeicher fr Patternnummeranzeige
PattTmp:	ds.b	10		;ASCII-Zwischenspeicher fr Patternnummeranzeige
SubsongTmp2:	ds.b	20		;ASCII-Zwischenspeicher fr Patternnummeranzeige
SubsongTmp:	ds.b	10		;ASCII-Zwischenspeicher fr Patternnummeranzeige
tracktmp1:	ds.b	6		;
tracktmp2:	ds.b	6
PermerkLevelmeter:	ds.l	4	;4 Kanle,je 2 Wrter fr Levelmeter
SlowIDLevel:		ds.b	1
MuteID:			ds.b	1	;Muting an: <>0
MuteTMP:		ds.b	1	;fr Blinken der LED des Lautstrkereglers
			ds.b	1

AN_StructAdr:		ds.l	1	;UPS Struktur zwischenspeichern
LM_LastValue		ds.w	1	;letzter Levelmeter-Wert fr Averaging
;--------------Daten fr Error-Requester-------------
MY_Easystruct:	ds.l	1	;EASY-Request
		ds.l	1
		ds.l	1
		ds.l	1
		ds.l	1


	ifne	FXTask
; Daten fr den FX Task
FX_Disable		ds.b	1	;Flag vom Hauptprozess ob FX erlaubt sind
FX_Enabled		ds.b	1	;Flag vom FX Task, ob aktiv
FX_Quit			ds.b	1	;Flag vom Hauptprozess, wenn FX Task zu beenden ist
			ds.b	1
	ifne	Semaphore
Image_Semaphore:	ds.b	SS_Size	;Semaphore zur Vermeidung gleichzeitigen Zugriffs auf
					;ShowImage Funktion bei Verwendung des FX Tasks
	endc
	endc

; Daten fr den FFT-Analyzer
PermerkFFT:		ds.l	4	;4 Kanle,je 2 Wrter fr Analyzer
FFT_NumDisplay:		ds.w	1	;Anzahl der angezeigten Frequenzen
FFT_CurrentMode:	ds.l	1	;Bearbeitungsroutine aktueller Modus
FFT_slowid:		ds.b	1
FFT_slowcount:		ds.b	1
FFT_Stopanalyzer:	ds.b	1
FFT_Stoptime:		ds.b	1
FFT_Permerk:		ds.l	4
FFT_Mixfrequency	ds.l	1
FFT_Current_Num		ds.w	1
SpecialUPS:		ds.b	1
			ds.b	1
FFT_OutTable:		ds.w	FFT_N*2	;Tabelle der Ausgangswerte der FFT (momentan 32 verwendet)
FFT_OutTableI:		ds.w	FFT_N*2
FFT_Realtab:		ds.l	FFT_N*2
FFT_Imgtab:		ds.l	FFT_N*2
Bitreversetab		ds.w	FFT_N
SinCostab		ds.l	FFT_N*2
;------- Umrechnung der N Punkte Trafo auf ursprngliche 2 N Punkte Eingangswerte ---------
SinTab2:		ds.l	FFT_N
CosTab2:		ds.l	FFT_N
FFT_StructAdr:		ds.l	1	;UPS Struktur zwischenspeichern
FFT_MaxDisplaytab:	ds.l	FFT_N	;davon momentan lediglich 32 Werte verwendet

			ds.l	FFT_Width*2
FFT_TrueBuffer:		ds.l	FFT_Width*FFT_Height	;Breite*Hhe*4 Bytes pro Pixel
			ds.l	FFT_Width*2
FFT_Analyzertab:	ds.b	FFT_Analyzertabsize

datasize	EQU	*-Datas
