*****************************************************************************
**                                                                         **
** Engine: DirlistViewer                                                   **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 


*******************************************************************************
Executable		= 1
DebuggerTest		= 0
*-----------------------------------------------------------------------------*

		incdir	include:
		include	"misc/eagleplayer.i"
		include	"misc/eagleplayerengine.i"
	
		incdir	"include:"
		include	"intuition/intuition.i"
		include	"intuition/intuition_lib.i"
		include	"exec/exec_lib.i"
		include	"dos/dos_lib.i"
		include	"graphics/graphics_lib.i"
		include	"libraries/gadtools_lib.i"
		include	"libraries/gadtools.i"

*-----------------------------------------------------------------------------*
*------- Flags nicht ndern, sind nur in den UserUtils fr Bedeutung ---------*
*-----------------------------------------------------------------------------*
TitlePufferSize		= 200
GadgetAnz		= 1
Ticks			= 150
TickFlags		= 0
MsgFlags		= USMB_WaitPointer!USMB_Zipwin!USMB_ChangeConfig!USMB_NewDirectory!USMB_NewModule!USMB_KillModule
AbstandLinks		= 3
AbstandOben		= 2

	*---------- Auwertungen von USClasses ---------*
ClassNewDirectory	= 1
ClassNewScrollText	= 0
ClassZipWindow		= 0

AlwaysFillListView	= 0
OwnVanillaKey		= 1
SignalUsed		= 0
InitGadgets		= 1			;Structuren vor Init verndern
InitGadgets2		= 0			;Listviews initialisieren
Inner_Special		= 1			;Size ist in EUS_Special
ZoomStruct		= 0
AbsoluteFont		= 0
RectFill		= 1
Raster			= 0			;gerasteter Hintergrund
BevelBox		= 0
OwnRefresh		= 0
WithListview		= 1
WithScrollBalkenRight	= 0			;rechten Scrollbalken nutzen
WithScrollBalkenBottom	= 0			;unteren Scrollbalken nutzen
WithCursorRight		= 0			;mit Pfeil-Gadgets
WithCursorBottom	= 0			;mit Pfeil-Gadgets

*---------------------------------------------------------------------------*


*------------------------- Nummern der Aktionen ------------------------------*
		rsreset
NrDummy		rs.b	1
NrAbout		rs.b	1
NrHide		rs.b	1
NrQuit		rs.b	1
NrFirstGadget	rs.b	0			;Nummer des 1. Gadgets
NrListView	rs.b	1
NrLastGadget	rs.b	0
NrRefreshList	rs.b	1
NrAuswahl	rs.b	1
NrTop		rs.b	1
NrBotom		rs.b	1
NrUp		rs.b	1
NrDown		rs.b	1
NrPageUp	rs.b	1
NrPageDown	rs.b	1
NrParent	rs.b	1
NrSetDir	rs.b	1
NrLinks		rs.b	1
NrRechts	rs.b	1
NrMaxNummern	rs.b	0


;Vanillakey
IDCMPFlags	= RAWKEY!VANILLAKEY!IDCMP_NewSize!LISTVIEWIDCMP!IDCMP_MENUPICK!IDCMP_CLOSEWINDOW!IDCMP_REFRESHWINDOW
;WindowFlags	= WFLG_SMART_Refresh!WFLG_SIZEBBOTTOM!WFLG_SIZEGADGET!WFLG_DRAGBAR!WFLG_DEPTHGADGET!WFLG_CLOSEGADGET!WFLG_ACTIVATE
WindowFlags	= WFLG_NoCareRefresh!WFLG_SIZEBBOTTOM!WFLG_SIZEGADGET!WFLG_DRAGBAR!WFLG_DEPTHGADGET!WFLG_CLOSEGADGET!WFLG_ACTIVATE



IconifyLeft	EQU	30
IconifyTop	EQU	100
IconifyWidth	EQU	200
WindowLeft	EQU	30
WindowTop	EQU	40
WindowInnerWidth EQU	300
WindowInnerHeight EQU	180
MaxWindowWidth	EQU	2000
MaxWindowHeight	EQU	1000
MinWindowWidth	EQU	160
MinWindowHeight	EQU	80


*----------------------------------------------------------------------------*
* Hast Du vielleicht vergessen, ein Engine auszuwhlen		!!!!!!!!!!!! *
* Hast Du vielleicht vergessen, ein Userprogramm auszuwhlen  !!!!!!!!!!!!!! *
		include	"misc/MyUserMacros.i"
* Hast Du vielleicht vergessen, ein Userprogramm auszuwhlen  !!!!!!!!!!!!!! *
* Hast Du vielleicht vergessen, ein Userprogramm auszuwhlen  !!!!!!!!!!!!!! *
*----------------------------------------------------------------------------*

*------------------ Vereinbarungen fr internen Puffer -----------------------*
		rsreset
		rs.b	EPG_SizeOf

TitlePuffer	rs.b	TitlePufferSize

*----------------- Definitionen fr FreeTable zum Rauswerfen ----------------*
FreeTable	rs.b	0
FSWindow	rs.l	1
WinHandle	rs.l	1
FSMsgPort	rs.l	1
MsgPort		rs.l	1
FSVisualInfo	rs.l	1
VisualInfo	rs.l	1
FSGadgetAdr	rs.l	1
WinGadgetsAdr	rs.l	1
FSMenuAdr	rs.l	1
WinMenuAdr	rs.l	1
FSPubScreenAdr	rs.l	1
PubScreenAdr	rs.l	1
		rs.l	1			;Ende der FreeTable
FSListAdr	rs.l	2			;darf nicht mit in die Free

	*----------------- weitere Definitionen -----------------*
		if	debugger
MerkUserNr	rs.w	1
		endc

Signal		rs.l	1
SignalBits	rs.l	1
TaskAdr		rs.l	1
UPrg_Struct	rs.l	1
WinMSGPort	rs.l	1
WinRastPort	rs.l	1
WinHoehe	rs.w	1
WinMenuOn	rs.w	1
ItemAddi	rs.w	1
OffX		rs.w	1
OffY		rs.w	1
WindowDisabled	rs.w	1
MyFirstGadget	rs.l	1
GadgetPuffer	rs.b	Gng_SizeOf
GadgetDefinitionen rs.l	GadgetAnz
EPBase		rs.l	1
StructAdr	rs.l	1
CurrentSeconds	rs.l	1
CurrentMicros	rs.l	1
StartSeconds	rs.l	1
StartMicros	rs.l	1
ExitNow		rs.w	1
KickStart	rs.w	1
Kick2On		rs.w	1
Kick3On		rs.w	1
OldTaste	rs.l	1
MsgUnterwegs	rs.l	1
DirListAdr	rs.l	1
GfxBase		rs.l	1

*ListViewStruct	rs.b	LH_Size
ListViewNr	rs.w	1
Eintrage	rs.l	1
Dirs		rs.l	1
*ThisMessage	rs.l	1

ENA_Args1	rs.b	ENA_String+34

MyMessage	rs.b	UM_SizeOf		;Message fr Eagleplayer
BevelBoxTags:	rs.l	3
Pufferend	rs.b	0


EXECBase	MACRO
		if	executable
		move.l	4.w,a6
		else
		move.l	4,a6
		endc
		ENDM


*-----------------------------------------------------------------------------*
*-----				Start Programm				------*
*-----------------------------------------------------------------------------*
;UserStartPrg
EUS_Structure:	bra.w	UserStart			;EUS_Jump
		EUSN_Identifier				;EUS_Identifier
		dc.l	0				;EUS_Next
		ifne	debugger
		dc.w	-2				;EUS_Usernr
		else
		dc.w	0				;EUS_Usernr
		endc

		dc.l	0				;EUS_EPBase
		dc.l	0				;EUS_FreeTable
		dc.l	0				;EUS_TaskAdr
		dc.l	0				;EUS_UnUsed1
		dc.l	0				;EUS_UnUsed2
		dc.l	0				;EUS_UnUsed3
		dc.l	Tagliste			;EUS_Taglist
		dc.w	Ticks				;EUS_Ticks
		dc.w	0				;EUS_TickCounter
		dc.l	TickFlags			;EUS_TickFlags
		dc.l	MsgFlags			;EUS_MsgFlags
		dc.l	MyProzessName			;EUS_PName
		dc.l	MyCreatorname			;EUS_Creator
		dc.l	MySpecialInfo			;EUS_AboutUPRG
		dc.w	37				;EUS_Kickstart
		dc.l	8				;EUS_EPVersion
		dc.w	2				;EUS_Version
		dc.w	0				;EUS_Revision
		dc.l	0				;EUS_Username
		dc.w	WindowLeft			;EUS_WinX
		dc.w	WindowTop			;EUS_WinY
		dc.w	EUSB_Openwin			;EUS_Flags
		dc.w	WindowInnerWidth		;EUS_Special
		dc.w	WindowInnerHeight		;EUS_Special+2
		dc.l	0				;EUS_Special2
		dc.l	0				;EUS_Special3
		dc.b	30,09
		dc.w	1996				;EUS_Creatordate
		dc.b	0				;EUS_Priority
		dc.b	EUTY_DirViewer			;EUS_Reserved1
		dc.w	0				;EUS_Reserved2
		dc.l	0				;EUS_Reserved3
		dc.l	0				;EUS_Reserved4
		dc.l	0				;EUS_Reserved5
		dc.l	0				;EUS_Reserved6

		ifne	(*-EUS_Structure)-EUS_SizeOF
		Aber Hallo
		endc

		dc.b	"$VER: Eagleplayer-Dirlistviewer V2.0 (30 Sep 1996)",0
		even


Tagliste:	dc.l	EUT_SpecialinfoLNr,LNrE_SpecialInfo_DirListViewer
		dc.l	EUT_LocaleTable,LocaleTable
		*dc.l	EUT_AttnFlags,1<<6!1<<3
		dc.l	0


UserStart:	if	executable
		move.w	EUS_Structure+EUS_UserNr(pc),d0	;d0=0, nicht von
		beq.w	NoSignal			;Eagleplayer gestartet
		move.l	EUS_Structure+EUS_EPBase(pc),a0
		tst.l	DTG_GadToolsBase(a0)
		beq.w	NoKickStart20
		else
		bsr	OpenGFX
		beq.w	Ende
		bsrifeq	DebuggerHelp,Executable
		endc
		lea	Puffer,a5
		bsr	ClrPuffer

		lea	MyMenus(pc),a0
		move.l	LA_About(pc),LAN_About-MyMenus(a0)
		move.l	LA_AboutKey(pc),LAN_AboutKey-MyMenus(a0)
		move.l	LA_Hide(pc),LAN_Hide-MyMenus(a0)
		move.l	LA_HideKey(pc),LAN_HideKey-MyMenus(a0)
		move.l	LA_Quit(pc),LAN_Quit-MyMenus(a0)
		move.l	LA_RefreshList(pc),LAN_RefreshList-MyMenus(a0)
		*move.l	LA_RefreshListKey(pc),LAN_RefreshListKey-MyMenus(a0)
		move.l	LA_Project(pc),LAN_Project-MyMenus(a0)

		ifeq	DebuggerTest
		move.l	EUS_Structure+EUS_EPBase(pc),a0
		move.l	DTG_GfxBase(a0),GFXBase(a5)
		endc

	*-------------- Kickstart testen --------------*
		Execbase
		move.w	20(a6),KickStart(a5)
		clr.w	Kick2On(a5)
		clr.w	Kick3On(a5)
		cmp.w	#37,KickStart(a5)
		blo.w	NoKickstart20
		move.w	#1,Kick2On(a5)
		cmp.w	#39,Kickstart(a5)
		blo.s	.NoKick3
		move.w	#1,Kick3On(a5)

	*------------ Task suchen & finden ------------*
.NoKick3:	sub.l	a1,a1
		jsr	_LVOFindTask(a6)
		move.l	d0,TaskAdr(a5)
		beq.w	NoSignal

	*- Signal fr Interruptansteuerung des Eagleplayers -*
	*------------------ allokieren ----------------------*
	if	SignalUsed
		moveq	#0,d6
		moveq	#-1,d0
		jsr	_LVOAllocSignal(a6)	;Signal allokieren
		tst.l	d0
		blt	NoSignal
		move.l	d0,Signal(a5)
		bset	d0,d6
		move.l	d6,SignalBits(a5)
	endc

	*--------------- Liste initialisieren ----------------*
	*	if	withlistview
	*	lea	ListViewStruct(a5),a0
	*	newlist	a0
	*	endc

*------------------------- Message an Eagleplayer schicken -----------------*
*---- Input:	;d1 = Enabled(0) oder Disabled(1)			----*
*----		d2 = US_Class						----*
*----		d3 = Command						----*
*----		d4 = ArgList						----*
*----		d5 = Result						----*
	if Executable+Debugger
		if debugger
		move.l	#EUS_Structure,d5
		else
		moveq	#0,d5
		endc
		moveq	#0,d1
		moveq	#USClass_NewUserPrg,d2
		moveq	#0,d3
		moveq	#0,d4
		if	debugger
		move.w	#-2,MerkUserNr(a5)
		endc
		bsrif	SendeOneMessage,Executable+Debugger
		if	debugger
		move.w	MyMessage+UM_UserNr(a5),MerkUserNr(a5)
		tst.l	d0
		endc
	else
		bsr.w	OpenMyWindow
	endc
		beq.s	NoEaglePlayer
	
	ifeq	AlwaysFillListView
		bsrif	FirstFillListViews,WithListView
	endc

	*------------ Hauptprogramm ablaufen lassen ------------*
		bsr.w	Warten

	*------------ Engine offiziel beenden ------------*
CloseWin:	bsrif	WaitUserMessages,Executable+Debugger
		bsr.w	CloseMyWindow
		bsrif	DeleteListViewList,WithListView


*----------------------------------------------------------------------------*
*--- Eagleplayer hat die erste Message nicht beantwortet oder ist nicht da --*
*----------------------------------------------------------------------------*
NoEagleplayer:	if	SignalUsed
		move.l	Signal(a5),d0
		Execbase
		jsr	_LVOFreeSignal(a6)
		endc
NoSignal:	bsrifeq	DebuggerHelpEnd,Debugger+Executable

	*----------- Ende des Engine ------------*
Ende:		moveq	#0,d0
	if Executable
		rts
	else
		illegal
	endc


*---------------------------------------------------------------------------*
*------------ Hier befindet sich nun die Schleife die Aktionen -------------*
*---------------------------------------------------------------------------*
Warten:		tst.w	ExitNow(a5)
		bne.w	Return
		move.w	ItemAddi(a5),d4
		beq.w	.MenuFertig
		bsr.w	PullMenu
		bra.s	Warten

.MenuFertig:	move.l	MsgPort(a5),d0
		beq.s	WartenWinPort
		move.l	d0,a0
		Execbase
		jsr	_LVOGetmsg(a6)
		tst.l	d0			;Scrollen erlaubt
		beq.w	WartenWinPort
		bsr.w	UserMessage
		bra.w	Warten

WartenWinPort:	move.l	WinMsgPort(a5),d0
		beq.s	Wait
		move.l	d0,a0
		move.l	DTG_GadToolsBase(a5),a6
		jsr	_LVOGT_GetIMsg(a6)
		tst.l	d0
		beq.s	Wait
		bsr.w	WindowMessage
		bra.w	Warten

*----------------------------------------------------------------------------*
*------------- Hier wait, bis einer der Message-Ports ->>> Message ----------*
*----------------------------------------------------------------------------*
Wait:		if executable+debugger
		move.l	SignalBits(a5),d0
		or.w	#$1000,d0		;Break-Signal
		Execbase
		jsr	_LVOWait(a6)

	*------- War es ein Break Signal -----*
		btst	#12,d0			;Break-Signal
		bne.w	Return
		else
		;btst	#6,$bfe001
		;beq.w	Return
		endc

	*------- War es ein UserMessage ------*
		move.l	MsgPort(a5),d2
		beq.s	.NoPort
		move.l	d2,a0
		moveq	#0,d1
		move.b	15(a0),d1
		btst	d1,d0
		bne.w	Warten			;EaglePort

	*----- war es eine Window-Message ----*
.NoPort:	move.l	WinMsgPort(a5),d2		;Testen ob Window-Port
		beq.s	.NoMain
		move.l	d2,a0
		move.b	15(a0),d1
		btst	d1,d0
		bne.w	WartenWinPort
.NoMain:	if	executable+debugger
		bra.w	Wait
		else
		bra.w	Warten
		endc




******************************************************************************
*------------------- Auswertung einer Window-Message ------------------------*
******************************************************************************
WindowMessage:	move.l	d0,a1
		move.l	IM_IAddress(a1),d5
		moveq	#0,d4
		move.w	IM_Code(a1),d4
		move.l	IM_Class(a1),d3
		beq.w	Return
		move.l	IM_Seconds(a1),CurrentSeconds(a5)
		move.l	IM_Micros(a1),CurrentMicros(a5)
		moveq	#0,d2
		move.w	IM_Qualifier(a1),d2
		move.l	DTG_GadToolsBase(a5),a6
		jsr	_LVOGT_ReplyIMsg(a6)

		moveq	#-2,d0
.SchiebeBit:	addq.l	#2,d0
		asr.l	#1,d3
		bne.s	.SchiebeBit

		lea	IDCMPTab(pc),a0
		move.w	(a0,d0.w),d1
		lea	(a0,d1.w),a0
		jmp	(a0)


*---------------------------------------------------------------------------*
VanillaTaste:
	*------ Bei Vanillakey die Buchstaben nach Shift umbauen -----*
	*--- ConvertToAscii 
		moveq	#0,d3
		move.w	d4,d3
		move.w	d2,d0
		and.w	#-4,d0
		cmp.w	d2,d0
		beq.s	.NoShift
		cmp.w	#"a",d3
		blo.s	.NoShift
		cmp.w	#"z",d3
		bhi.s	.NoShift
		sub.w	#$20,d3

.NoShift:	lea	TastaturTabelle(pc),a3
.NextTest:	move.b	(a3)+,d1
		beq.w	Return
		moveq	#0,d0
		move.b	(a3)+,d0
		cmp.b	d1,d3			;stimmt der AsciiCode
		bne.s	.NextTest
		bra.w	JumpTo

	*---------------------------------------------------------*
RawTaste:	*move.l	OldTaste(a5),d3
		*move.l	d4,OldTaste(a5)

		btst	#3,d2
		bne.s	.Control
		btst	#0,d2
		bne.s	.Shift
		btst	#1,d2
		bne.s	.Shift

		*cmp.w	#$63,d3
		*beq.s	.Control

		moveq	#NrUp,d0
		cmp.b	#$4c,d4
		beq.s	JumpTo

		moveq	#NrDown,d0
		cmp.b	#$4d,d4
		beq.s	JumpTo

		moveq	#NrLinks,d0
		cmp.b	#$4f,d4
		beq.s	JumpTo

		moveq	#NrRechts,d0
		cmp.b	#$4e,d4
		beq.s	JumpTo

		bra.w	Return


.Control:	*move.l	d3,OldTaste(a5)
		moveq	#NrTop,d0
		cmp.b	#$4c,d4
		beq.s	JumpTo

		moveq	#NrBotom,d0
		cmp.b	#$4d,d4
		beq.s	JumpTo

		bra.w	Return

.Shift:	*move.l	d3,OldTaste(a5)
		moveq	#NrPageUp,d0
		cmp.b	#$4c,d4
		beq.s	JumpTo

		moveq	#NrPageDown,d0
		cmp.b	#$4d,d4
		beq.s	JumpTo

		bra.w	Return


*		dc.b	"8",NrUp
*		dc.b	"2",NrDown
*		dc.b	"7",NrTop
*		dc.b	"1",NrBotom
*		dc.b	"9",NrPageUp
*		dc.b	"3",NrPageDown


*		moveq	#-1,d0
*.w
*		move.w	d0,$dff180
*		dbf	d0,.w
*		rts
*

*---------------------- d0 = Nummer der Aktion -----------------------------*
JumpTo:		lea	AktionTab(pc),a0
		move.l	a0,a1
		move.l	d0,d1
		add.w	d1,d1
		cmp.w	#NrMaxNummern*2,d1
		bhi.w	Return
		move.w	(a0,d1.w),a0
		add.l	a1,a0
		jmp	(a0)


******************************************************************
*allocmsg
*	movem.l	d1-a6,-(sp)
*	move.l	4,a6
*	moveq	#UM_Sizeof,d0
*	move.l	#$10001,d1
*	jsr	_LVOallocmem(A6)
*	movem.l	(sp)+,d1-a6
*	tst.l	d0
*	rts
******************************************************************
*freemsg
*	moveq	#UM_sizeof,d0
*	move.l	4,a6
*	jsr	_LVOfreemem(A6)
*	rts

*---------------------------------------------------------------------------*
*-- Eine Message nach dem angegebenen Engine senden und Warten, bis --*
*-------- diese wieder zurckkommt und auswerten der ReturnMessage ---------*
*--- Die SS_StructAdr wird automatisch gesetzt, sowie Type und Replyport ---*
*---- _LVOPutMsg(a6)							----*
*----									----*
*---- Input:	d1 = Enabled(0) oder Disabled(1)			----*
*----		d2 = US_Class						----*
*----		d3 = Command						----*
*----		d4 = ArgList						----*
*----		d5 = Result						----*
*----									----*
*---- OutPut:	d0 = Fehler						----*
*---------------------------------------------------------------------------*
		if Executable+Debugger
SendeOneMessage:
		movem.l	d1/a0/a1/a6,-(a7)
		bsr	CreateMsgPort
		beq.w	.Fehler
		bsrif	WaitUserMessages,Executable+Debugger

		*bsr	AllocMsg
		*beq	.fehler
		*move.l	d0,a1
		lea	MyMessage(a5),a1

	*------------ Exec-Message initialisieren -----------*
		move.w	#UM_Sizeof-20,MN_Length(a1)
		move.b	#NT_Message,LN_Type(a1)
		move.l	MsgPort(a5),MN_ReplyPort(a1)

	*------------ User-Message initialisieren -----------*
		if	debugger
		move.w	MerkUserNr(a5),UM_UserNr(a1)
		else
		move.w	EUS_Structure+EUS_UserNr(pc),UM_UserNr(a1)
		endc
		move.l	TaskAdr(a5),UM_TaskAdr(a1)
		move.l	Signal(a5),UM_Signal(a1)
		move.l	MsgPort(a5),UM_UserPort(a1)
		move.l	#USM_Userprg,UM_Type(a1)
		move.w	d1,UM_Enabled(a1)
		move.w	d2,UM_Class(a1)			;Kennung setzen
		move.l	d3,UM_Command(a1)
		move.l	d4,UM_ArgString(a1)
		move.l	d5,UM_Result(a1)

		*move.l	a1,ThisMessage(A5)

	*------------ Message senden -------------*
.RetryFindPort:	lea	EPUserPortName(pc),a1
		Execbase
		jsr	_LVOFindPort(a6)
		move.l	d0,a0
		tst.l	d0
		bne.s	.PortDa

	*----- Eagleplayer-Port nicht gefunden ----*
		move.l	Winhandle(a5),a0	;Window
		lea	EPFind_EasyStruct(pc),a1 ;EasyStruct
		sub.l	a2,a2			;IDCMP-Ptr
		sub.l	a3,a3			;Arguments
		move.l	DTG_IntuitionBase(a5),a6
		jsr	_LVOEasyRequestArgs(a6)
		tst.l	d0
		beq.s	.Fehler
		bra.s	.RetryFindPort

.PortDa:	movem.l	d0/a0,-(a7)
		*move.l	ThisMessage(A5),a1
		lea	MyMessage(a5),a1

		move.l	UM_TaskAdr(a1),d0
		beq.s	.NoTask
		move.l	d0,a1
		moveq	#0,d0
		jsr	_LVOSetTaskPri(a6)	
.NoTask:	movem.l	(a7)+,d0/a0
		*move.l	ThisMessage(A5),a1
		lea	MyMessage(a5),a1
		jsr	_LVOPutMsg(a6)

		addq.l	#1,MsgUnterwegs(a5)

	*---------- Alles klar, Ende ----------*
.NoPort:	bsrif	WaitUserMessages,Executable+Debugger
		moveq	#-1,d0
.Fehler:	movem.l	(a7)+,d1/a0/a1/a6
		tst.l	d0
		rts
		endc


*---------------------------------------------------------------------------*
*----- Wartet, bis alle Messages von den Engine wieder da sind -----*
*---------------------------------------------------------------------------*
		if Executable+Debugger
WaitUserMessages:movem.l d0-a6,-(a7)

	if debugger
		bsr.w	CopyEPBase
	endc

.WaitNochmal:	tst.l	MsgUnterwegs(a5)
		beq.w	.Return
		move.l	4,a6
		bsr	CreateMsgPort
		beq.s	.Return
		move.l	a0,a3
		jsr	_LVOWaitPort(a6)
		move.l	a3,a0
		jsr	_LVOGetMsg(a6)
		tst.l	d0
		beq.s	.WaitNochmal
		move.l	d0,a1
		bsr	UserMessage
		bra.s	.WaitNochmal
.Return:	movem.l	(a7)+,d0-a6
		rts
		endc



*-----------------------------------------------------------------------------*
*-----------------------------------------------------------------------------*
;		include	"misc/MyUserUtils.i"	;lieber weglassen !!!
*-----------------------------------------------------------------------------*
	*-------------- Engine wieder entfernen, da       --------------*
	*-------------- zu altes Kickstart benutzt wird ----------------*
	*-------------- Mal kurz eine Message raushauen ----------------*
NoKickstart20:	move.l	DTG_Dosbase(a5),a6
		lea	Kickstart20Path(pc),a0
		move.l	a0,d1
		move.l	#1005,d2			;Mode_OldFile
		jsr	_LVOOpen(a6)
		tst.l	d0
		beq.s	.NoHandle
		move.l	d0,d6
		move.l	d0,d1

	*------------ Text ausgeben --------------*
		lea	Kickstart20Text(pc),a0
		move.l	a0,d2
		moveq	#Kickstart20TextLen,d3
		jsr	_LVOWrite(a6)

	*---------- warte mal ein bischen --------*
		move.l	#250,d1				;~5 Sekunden warten
		jsr	_LVODelay(a6)

	*-------- Fenster wieder closen ----------*
		move.l	d6,d1
		jsr	_LVOClose(a6)
.NoHandle:	bra.w	NoEaglePlayer

*-----------------------------------------------------------------------------*
ClrPuffer:	move.l	a5,a0
		move.w	#PufferEnd-1,d0
.clr		clr.b	(a0)+
		dbf	d0,.clr
CopyEPBase:	move.l	EUS_Structure+EUS_EPBase(pc),a0
		move.l	a0,EPBase(a5)
		move.w	#EPG_SizeOf/2-1,d0
		move.l	a5,a1
.CopyEP:	move.w	(a0)+,(a1)+
		dbf	d0,.CopyEP
		rts

	if Executable+Debugger

*-----------------------------------------------------------------------------*
CreateMsgPort:	pushlibs
		move.l	MsgPort(a5),d0
		bne.s	.PortOk
		Execbase
		jsr	_LVOCreateMsgPort(a6)	;Messageport auf die schnelle Art
		move.l	d0,MSGport(a5)
		tst.l	d0
		beq.s	.PortOk
		move.l	d0,a0
		move.l	#MyMsgPortName,LN_Name(a0)

	*----------- SignalBits setzen ------------*
		move.l	SignalBits(a5),d6
		moveq	#0,d0
		move.b	15(a0),d0
		bset	d0,d6
		move.l	d6,SignalBits(a5)

.PortOk:	poplibs
		move.l	MsgPort(a5),d0
		move.l	d0,a0
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
RemoveMsgPort:	pushlibs
		move.l	MSGport(a5),d0
		beq.s	.PortOk
		move.l	d0,a0

	*----------- SignalBits sperren ------------*
		move.l	SignalBits(a5),d1
		moveq	#0,d0
		move.b	15(a1),d0
		bclr	d0,d1
		move.l	d1,SignalBits(a5)

		clr.l	MsgPort(a5)
		Execbase
		jsr	_LVODeleteMsgPort(a6)	;Messageport auf die schnelle Art
.PortOk:	poplibs
		rts

*----------------------- Gibt die Return-Structure frei -------------------*
FreeCommandStruct:
		movem.l d0/d1/a0/a1/a4/a6,-(a7)
		move.l	UPrg_Struct(a5),a4
.NextStruct:	moveq	#0,d0
		cmp.l	a4,d0
		beq.w	.Return
		move.l	a4,a1
		move.l	(a1),a4
		move.l	EPT_StringSize(a1),d0
		beq.s	.StructFree
		Execbase
		jsr	_LVOFreeMem(a6)
.StructFree:	bra.b	.NextStruct
.Return:
		clr.l	UPrg_Struct(a5)
		movem.l	(a7)+,d0/d1/a0/a1/a4/a6
		rts
	endc

*----------------------- Setze Free-Struct in die Globals --------------------*
SetFreeStruct:	lea	FreeTable(a5),a0
		move.l	a0,EUS_Structure+EUS_FreeTable
		move.l	#EUSM_Window,FSWindow(a5)
		move.l	#EUSM_VisualInfo,FSVisualInfo(a5)
		move.l	#EUSM_PubScreenAdr,FSPubScreenAdr(a5)
	if	EID_MenuPic
		move.l	#EUSM_MenuStrip,FSMenuAdr(a5)
	endc
	if	EID_GadgetDown+EID_GadgetUp
		move.l	#EUSM_GadgetAdr,FSGadgetAdr(a5)
	endc
	*if	withlistview
	*	move.l	#EUSM_MemListAdr,FSListAdr(a5)
	*	lea	ListViewStruct(a5),a0
	*	move.l	a0,FSListAdr+4(a5)
	*endc
		rts



*---------------------------------------------------------------------------*
*------------------ Es wurde ein Break-Signal geschickt --------------------*
*------------------------ Hauptroutine wird verlassen ----------------------*
QuitUserProgramm:moveq	#0,d1
		moveq	#USClass_Exit,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		bsrif	SendeOneMessage,Executable+Debugger
		move.w	#1,ExitNow(a5)
		rts

*---------------------------------------------------------------------------*
Hide:		ifeq	executable+debugger
		move.w	#1,ExitNow(a5)
		endc
		moveq	#0,d1
		moveq	#USClass_Deactivate,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		bsrif	SendeOneMessage,Executable+Debugger
		rts


*---------------------------------------------------------------------------*
About:		movem.l	d0-a6,-(a7)

		moveq	#0,d1
		moveq	#USClass_LockEP,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		bsrif	SendeOneMessage,Executable+Debugger

	if	executable+Debugger
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	LA_DLV_About(pc),a1
		move.l	a1,EPG_Arg1(a4)
		move.l	EPG_PubScreen(a4),EPG_Arg2(a4)
		clr.l	EPG_Arg3(a4)
		subq.l	#1,EPG_Arg3(a4)			;X-Koordinate
		clr.l	EPG_Arg4(a4)
		move.l	LA_DLV_EasyTitle(pc),a0
		move.l	a0,EPG_Arg5(a4)
		clr.l	EPG_Arg6(a4)
		moveq	#-1,d0
		move.l	d0,EPG_Arg7(a4)
		moveq	#8,d0
		move.l	d0,EPG_ArgN(a4)
		move.l	#4,EPG_Arg8(a4)
		jsr	ENPP_TextRequest(a4)
	else
		move.l	WinHandle(a5),a0	;Window
		lea	About_EasyStruct(pc),a1	;EasyStruct
		sub.l	a2,a2			;IDCMP_Ptr
		sub.l	a3,a3			;Arguments
		move.l	DTG_IntuitionBase(a5),a6
		jsr	_LVOEasyRequestArgs(a6)
	endc

		moveq	#0,d1
		moveq	#USClass_UnLockEP,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		bsrif	SendeOneMessage,Executable+Debugger

		movem.l	(a7)+,d0-a6
		rts


*----------------------------- Gadget wurde losgelassen ----------------------*
		if	EID_GadgetUp
GadUp:		move.l	d5,a1
		moveq	#0,d0
		move.w	GG_GadgetID(a1),d0
		bra.w	JumpTo
		endc

*------------------------ Es wurde eine Taste gedrckt -----------------------*
		if	EID_VanillaKey
		ifeq	OwnVanillaKey
VanillaTaste:
	*------ Bei Vanillakey die Buchstaben nach Shift umbauen -----*
	*--- ConvertToAscii 
		moveq	#0,d3
		move.w	d4,d3
		move.w	d2,d0
		and.w	#-4,d0
		cmp.w	d2,d0
		beq.s	.NoShift
		cmp.w	#"a",d3
		blo.s	.NoShift
		cmp.w	#"z",d3
		bhi.s	.NoShift
		sub.w	#$20,d3

.NoShift:	lea	TastaturTabelle(pc),a3
.NextTest:	move.b	(a3)+,d1
		beq.w	Return
		move.b	(a3)+,d0
		cmp.b	d1,d3			;stimmt der AsciiCode
		bne.s	.NextTest
		bra.w	JumpTo
		endc
		endc


*---------------------------- Pull-Down-Menu aktiviert -----------------------*
		if	EID_MenuPic
Pullmenu:	clr.w	ItemAddi(a5)
		move.l	WinMenuAdr(a5),d1
		beq.w	Return
		move.l	d1,a0
		move.l	d4,d0
		beq.w	Return
		move.w	d4,d7
		cmp.w	#-1,d0
		beq.w	Return
		move.l	DTG_IntuitionBase(a5),a6
		jsr	_LVOItemAddress(A6)
		tst.l	d0
		beq	Return
		move.l	d0,a1
		move.w	MI_NextSelect(a1),ItemAddi(a5)

	*----------- MenuJumpTabelle durchgehen ------------*
	* in der Tabelle befinden sich in Reihenfolge die   *
	* Nummer der Aktionen fr JumpTo		    *
	*---------------------------------------------------*
		lea	MenuNummernOverTab(pc),a0		;Tabelle fr Menu 1
		move.l	d7,d6
.FindMenu:	move.w	(a0)+,d5
		and.b	#31,d6
		beq.w	.MenuOk
		subq.b	#1,d6
		bra.s	.FindMenu

.MenuOk:	lea	(a0,d5.w),a0
		and.w	#$7e0,d7
		lsr.l	#5,d7
		add.w	d7,d7
		move.w	(a0,d7),d0			;AktionsNummer
		bra.w	JumpTo
		endc


******************************************************************************
*---------------- Auswertung einer Engine-Message ---------------------------*
******************************************************************************
*
*	Achtung 2. Ausgang der Routine bei Exit !!!!!!!!!!!!
*	Achtung 3. Ausgang der Routine bei UserQuitEagle !!!!!!!!!!!!
*
UserMessage:	if Executable+Debugger
	;	lea	TextPuffer(a5),a0		;Sicherheitshalber
		move.l	d0,a1
		cmp.l	#USM_UserPrg,UM_Type(a1) ;Test auf Analyzer-MSG
		beq.w	.Auswertung
		cmp.l	#USM_Eagleplayer,UM_Type(a1) ;Test auf Analyzer-MSG
		bne.w	.ReplyIt3

	*--------------- Es ist ein Message angekommen ------------*
.Auswertung:	moveq	#0,d0
		move.w	UM_UserNr(a1),d0

		move.l	UM_ArgString(a1),UPrg_Struct(a5)
		moveq	#0,d0
		moveq	#0,d7
		move.w	UM_Class(a1),d7
		beq.w	.ReplyIt
		cmp.w	#USClass_NewUserPrg,d7
		beq.w	.NewConfig			;.NewUserPrg
		cmp.w	#USClass_Activate,d7
		beq.w	.OpenWindow
		cmp.w	#USClass_Show,d7
		beq.w	.OpenWindow
		cmp.w	#USClass_DeActivate,d7
		beq.w	.CloseWindow
		cmp.w	#USClass_Hide,d7
		beq.w	.CloseWindow
	if	ClassZipWindow
		cmp.w	#USClass_ZipWin,d7
		beq.w	.ZipWindow
		cmp.w	#USClass_UnZipWin,d7
		beq.w	.UnZipWindow
	endc
		cmp.w	#USClass_NewConfig,d7
		beq.w	.NewConfig
		cmp.w	#USClass_GetConfig,d7
		beq.w	.GetConfig
		cmp.w	#USClass_Exit,d7
		beq.w	.Exit
	if	ClassNewDirectory
		cmp.w	#USClass_NewDirectory,d7
		beq.w	.NewDirectory

		cmp.w	#USClass_RemModulesList,d7
		beq.w	.RemDirectory
	endc
	if	ClassNewScrollText
		cmp.w	#USClass_NewScrollText,d7
		beq.s	.NewScrollText
	endc
		cmp.w	#USClass_SetWaitPointer,d7
		beq.w	.WaitPointer
		cmp.w	#USClass_ClearWaitPointer,d7
		beq.w	.ClearPointer

		cmp.w	#USClass_NewModule,d7
		beq.s	.NewModule
		cmp.w	#USClass_KillModule,d7
		beq.s	.KillModule

	;	cmp.w	#USClass_Command,d7
	;	beq.w	.UserCommand
	;	cmp.w	#USClass_Answer,d7
	;	beq.s	.UserAnswer
	;	cmp.w	#USClass_QuitEagle,d7
	;	beq.s	.UserQuitEagle
	;	move.w	d7,d0
		moveq	#0,d0
		bra.w	.ReplyIt

	*------ Es wurde ein neues Module geladen -------*
.NewModule:	movem.l	d0/a1,-(a7)
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_ModNr(a4),d1
		beq.w	.Unknown2
		cmp.l	#-1,d1
		beq.s	.Unknown2
		lea	EPG_FirstFileStruct(a4),a0
.Retry:		move.l	(a0),d0
		beq.s	.Unknown
		move.l	d0,a0
		cmp.w	EFP_ModuleNr(a0),d1
		bne.s	.Retry
		move.l	EPG_Moduleslist(a4),a1
		move.l	EPG_Entries(a4),d2
		lea	EFP_Node(a0),a0
		moveq	#0,d0
.Retry2:	subq.l	#1,d2
		blt.s	.Unknown
		move.l	(a1),d1
		beq.s	.Unknown
		move.l	d1,a1
		cmp.l	a0,a1
		beq.s	.Unknown
		addq.l	#1,d0
		bra.s	.Retry2
.Unknown:	move.w	d0,ListViewNr(a5)
		bsr	FillListViewS2
.Unknown2:	bsr	TitleAufbau
		movem.l	(a7)+,d0/a1
		bra.w	.ReplyIt

.KillModule:	bsr	TitleAufbau
		bra.w	.ReplyIt

	*----- Es wurde ein neues Directory geladen -----*
	if	ClassNewDirectory
.NewDirectory:
		
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_Entries(a4),Eintrage(a5)
		clr.w	ListViewNr(a5)

		bsr.w	FillListViews
		bsr	TitleAufbau
		moveq	#USClass_NewDirectory,d0
		bra.s	.ReplyIt
	endc

.RemDirectory:	bsr	ClearListViews
		bra.s	.ReplyIt
		
		
	*-------- Es wird ein neuer Text gescollt -------*
	if	ClassNewScrollText
.NewScrollText:	bsr.w	InsertScrollText
		bra.s	.ReplyIt
	endc

	*------- Ankommende Message sagt : "EXIT" -------*
.Exit:		move.w	#1,ExitNow(a5)
		bra.s	.ReplyIt		;Message replyen

	*----- Es wurde ein neue Config eingestellt -----*
.NewConfig:	move.w	EUS_Structure+EUS_Flags(pc),d0
		btst	#EUSF_Openwin,d0
		beq.s	.CloseWindow
	if ClassZipWindow
		btst	#EUSF_ZipWin,d0
		bne.s	.ZipWindow
	endc
		bra.s	.OpenWindow

	*- Der Eagleplayer mchte gerne die Config haben -*
.GetConfig:	lea	EUS_Structure(pc),a2
		moveq	#0,d0
		move.l	WinHandle(a5),d1
		beq.s	.GetNoWindow
		or.w	#EUSB_OpenWin,d0
		move.l	d1,a0
		move.l	4(a0),EUS_WinX(a2)

		bsr.w	GetSizeToSpecial
	if	ClassZipWindow
		move.w	10(a0),d1
		cmp.b	55(a0),d0		;Hhe vergleichen
		bne.s	.GetNoWindow
		or.w	#EUSB_ZipWin,d0
	endc
.GetNoWindow:	move.w	d0,EUS_Flags(a2)
		moveq	#USClass_GetConfig,d0
		bra.s	.ReplyIt

.WaitPointer:	bsr	WaitPointer
		bra.w	.ReplyIt

.ClearPointer:	bsr	ClearPointer
		bra.w	.ReplyIt


	*------ Ankommende Message sagt : "CLOSE MY WINDOW" -----*
.CloseWindow:	bsr	CloseMyWindow
		moveq	#USClass_DeActivate,d0
		bra.s	.ReplyIt
				
	*------ Angekommende Message sagt : "OPEN MY WINDOW" -----*
.OpenWindow:	move.l	EUS_Structure+EUS_EPBase(pc),a0
		move.l	EPG_SomePrefs(a0),d0
		btst	#EGPRF_Iconify,d0
		bne.s	.CloseWindow

		bsr.w	OpenMyWindow
		moveq	#USClass_Activate,d0
		tst.l	WinHandle(a5)
		bne.s	.ReplyIt
		moveq	#USClass_Deactivate,d0
	if ClassZipWindow
		bra.w	.ReplyIt

	*------ Ankommende Message sagt : "Zip my Window" -------*
.ZipWindow:	bsr.w	ZipMyWindow
		moveq	#USClass_ZipWin,d0
		bra.s	.ReplyIt

	*------ Ankommende Message sagt : "UnZip my Window" -----*
.UnZipWindow:	bsr.w	UnZipMyWindow
		moveq	#USClass_UnZipWin,d0
	endc


	*------- Message frs Replyen vorbereiten ------*
	*----------------- Class setzen ----------------*
.ReplyIt:	bsr.w	FreeCommandStruct
		move.l	a1,d1
		beq.s	.NoMSG
		clr.l	UM_Argstring(A1)
		move.l	a1,a0
		move.l	UM_StructAdr(a1),StructAdr(a5)
		move.w	d0,UM_Class(a1)			;Dummy setzen
.ReplyIt3:	move.l	a1,d0
		beq.s	.NoMSG
		move.l	MSgPort(a5),a0
		cmp.l	14(a1),a0		;Reply-Port vergleichen
		beq.w	.ClearMerk
		Execbase
		jsr	_LVOReplymsg(a6)
.NoMSG:		rts

.ClearMerk:	subq.l	#1,MsgUnterwegs(a5)
		*bsr	freemsg			;meine Message, also freigeben
		endc
Return:		rts

*-----------------------------------------------------------------------------*
WaitPointer:	movem.l	a0/a1/a4/d0,-(a7)
		tst.l	WinHandle(a5)
		beq.s	.Return
		tst.w	WindowDisabled(a5)
		bne.s	.Return

		*--- Alle Menus disablen ---*
		*Input:a0=Window
		*      a1=Menu
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	WinHandle(a5),a0
		move.l	WinMenuAdr(a5),a1
		jsr	ENPP_SetWaitPointer(a4)

		move.w	#1,WindowDisabled(a5)

.Return:	movem.l	(sp)+,a0/a1/a4/d0
		rts


*-----------------------------------------------------------------------------*
ClearPointer:	movem.l	a0/a1/a4/d0,-(a7)
		tst.w	WindowDisabled(a5)
		beq.s	.Return

		*--- Alle Menus disablen ---*
		*Input:a0=Window
		*      a1=Menu
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	WinHandle(a5),a0
		move.l	WinMenuAdr(a5),a1
		jsr	ENPP_ClearWaitPointer(a4)


.Return:	clr.w	WindowDisabled(a5)
		movem.l	(sp)+,a0/a1/a4/d0
		rts

*-----------------------------------------------------------------------------*
Titleaufbau:	movem.l	d0-a6,-(a7)
		tst.l	WinHandle(a5)
		beq.s	.Return

		move.l	EUS_Structure+EUS_EPBase(pc),a2

		lea	WindowTitle(pc),a0
		move.w	#TitlePufferSize-2,d1
		lea	TitlePuffer(a5),a1
		bsr	StringCopy

		cmp.l	#10,d1
		blo.s	.Set
		moveq	#0,d0
		move.w	ListViewNr(a5),d0
		tst.l	EPG_Entries(a2)
		beq.s	.NoAdd
		addq.l	#1,d0
.NoAdd:		*add.l	EPG_Dirs(a2),d0
		bsr	Hexdez
		
		move.b	#"/",(a1)+

		cmp.l	#10,d1
		blo.s	.Set
		move.l	EPG_Entries(a2),d0
		bsr	Hexdez

.Set:		move.l	EPG_TitlePuffer(a2),a2

		lea	TitlePuffer(a5),a1
		move.l	WinHandle(a5),a0
		move.l	DTG_IntuitionBase(a5),a6
		jsr	_LVOSetWindowTitles(a6)

.Return:	movem.l	(a7)+,d0-a6
		rts

*----------------------------------------------------------------------------*
StringCopy:	moveq	#0,d0
		cmp.l	a1,d0
		beq.s	.Return
		cmp.l	a0,d0
		beq.s	.Return
		tst.w	d1
		blt.s	.Return

.CopyIt:	clr.b	(a1)
		move.b	(a0)+,d0		;Copiere String bis 0 d1=Anz
		beq.b	.Return
		move.b	d0,(a1)+
		dbf	d1,.CopyIt
		clr.b	(a1)
.Return		moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
* Input: d0=Zahl
*	 a1=OutputPuffer
* Output:a1=Ende des Outputpuffers
*-----------------------------------------------------------------------------*
Hexdez:		tst.l	d0
		beq.s	.TypeNull
		movem.l	d0-d4/a0,-(a7)
		lea	hexdeztab(pc),a0
		moveq	#0,d4
		moveq	#9,d3
.HexDez1:	move.l	(a0)+,d1
		moveq	#0,d2
.HexDez2:	addq.l	#1,d2
		sub.l	d1,d0
		bcc.s	.Hexdez2
		add.l	d1,d0
		add.b	#$2f,d2
		cmp.b	#$30,d2
		bne.s	.Printealle
		tst.b	d4
		beq.s	.PrinteNoZiffer
.Printealle:	moveq	#1,d4
		move.b	d2,(a1)+
.PrinteNoZiffer:dbf	d3,.Hexdez1
		clr.b	(a1)
		movem.l	(a7)+,d0-d4/a0
		rts
.TypeNull	move.b	#$30,(a1)+
		clr.b	(a1)
		rts

	*-------- Hilfstabelle fr Hex-Dez-Umwandelung --------*
Hexdeztab:	dc.l	1000000000,100000000,10000000,1000000,100000,10000
		dc.l	1000,100,10,1

*-----------------------------------------------------------------------------*
*-----				Open Window				------*
*-----------------------------------------------------------------------------*
OpenMyWindow:	movem.l	d1-a6,-(a7)
		tst.l	Winhandle(a5)
		bne.w	.Return

	*----------- Publicscreen allokieren ------------*
		bsr	LockPubScreen		;Public Screen holen
		beq.w	.Return

	*----------- Menus und Gadgets erzeugen ---------*
		bsrif	CreateGadgets,EID_GadgetDown+EID_GadgetUp
		beqif	.CloseAll,EID_GadgetDown+EID_GadgetUp
		bsrif	CreateMenus,EID_MenuPic
		beqif	.CloseAll,EID_MenuPic

	*----------------- Window ffnen ----------------*
		moveq	#11,d1
		move.l	PubScreenAdr(a5),d0
		beq.s	.NoPubScreen
		move.l	d0,a0
		move.l	SC_Font(a0),a0
		move.w	TA_YSize(a0),d1
		addq.w	#3,d1
.NoPubScreen:	lea	WindowTags(pc),a1
		move.w	d1,WinHoehe(a5)
		move.l	MyFirstGadget(a5),MyWa_Gadgets-WindowTags+4(a1)
	if ZoomStruct
		move.w	d1,WindowZoom+6-WindowTags(a1)
	endc
		move.l	PubscreenAdr(a5),MyWA_PubScreenAdr-WindowTags+4(a1)
		move.w	EUS_Structure+EUS_WinX(pc),MyWA_Left-WindowTags+6(a1)
		move.w	EUS_Structure+EUS_WinY(pc),MyWA_Top-WindowTags+6(a1)
	if	Inner_Special
		move.l	EUS_Structure+EUS_Special(pc),d0
		bne.s	.SpecialZero
		move.w	#WindowInnerWidth,(EUS_Structure+EUS_Special)-WindowTags(a1)
		move.w	#WindowInnerHeight,(EUS_Structure+EUS_Special+2)-WindowTags(a1)
.SpecialZero:	move.w	EUS_Structure+EUS_Special(pc),MyWA_InnerWidth-WindowTags+6(a1)
		move.w	EUS_Structure+EUS_Special+2(pc),MyWA_InnerHeight-WindowTags+6(a1)
	endc
		sub.l	a0,a0
		move.l	DTG_Intuitionbase(a5),a6
		jsr	_LVOOpenWindowTagList(a6)
		move.l	d0,Winhandle(a5)
		tst.l	d0
		bne	.WindowOk


	*----------------- Window ffnen ----------------*
		lea	WindowTags(pc),a1
		move.l	PubscreenAdr(a5),MyWA_PubScreenAdr-WindowTags+4(a1)
		clr.l	MyWA_Left-WindowTags+4(a1)
		clr.l	MyWA_Top-WindowTags+4(a1)
	if	EWF_SizeBright+EWF_SizeBottom
		move.w	#WindowInnerWidth,MyWA_InnerWidth-WindowTags+6(a1)
		move.w	#WindowInnerWidth,(EUS_Structure+EUS_Special)-WindowTags(a1)
		move.w	#WindowInnerHeight,MyWA_InnerHeight-WindowTags+6(a1)
		move.w	#WindowInnerHeight,(EUS_Structure+EUS_Special+2)-WindowTags(a1)
	endc
		sub.l	a0,a0
		move.l	DTG_Intuitionbase(a5),a6
		jsr	_LVOOpenWindowTagList(a6)
		move.l	d0,Winhandle(a5)


	*-------- Scrollbalken adden oder auch nicht --------*
.WindowOk:	tst.l	d0
		bne.s	.WindowOk2

	*-------- Menus und Gadgets wieder freigeben --------*
.CloseAll:	bsr.w	CloseMyWindow
		bra.s	.Return

	*-------------- Merkzellen in Globals setzen --------*
.WindowOk2:	move.l	WinHandle(a5),a0
		move.l	WD_RPort(a0),a1
		move.l	a1,WinRastPort(a5)
		move.l	WD_UserPort(a0),a0
		move.l	a0,WinMsgPort(a5)


	*--------------- SignalBits setzen ---------------*
		move.l	SignalBits(a5),d6
		moveq	#0,d0
		move.b	15(a0),d0
		bset	d0,d6
		move.l	d6,SignalBits(a5)

	*-------- Menu setzen und Window refeshen --------*
		bsrif	FillWindow,Raster


		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_ModNr(a4),d0
		beq.s	.NoNr
		sub.w	#EPNr_FirstModule-1,d0
.NoNr		move.w	d0,ListViewNr(a5)

	if	AlwaysFillListView
		bsrif	FillListViews,WithListView
	else
		bsrif	FillListViews2,WithListView
	endc
		bsrif	SetMenuStrip,EID_MenuPic

		move.l	DTG_GadToolsBase(a5),a6
		move.l	Winhandle(a5),a0
		suba.l	a1,a1
		jsr	_LVOGT_RefreshWindow(a6)

		bsrif	UpDateWindow,OwnRefresh

		bsr	TitleAufbau

.Return:	movem.l	(a7)+,d1-a6
		move.l	WinHandle(a5),d0
		rts


*----------------------------------------------------------------------------*
*-----			Window schlieen und Positionen merken		-----*
*----------------------------------------------------------------------------*
*----------------------------------------------------------------------------*
CloseMyWindow:	movem.l	d0-a6,-(a7)
		move.l	Winhandle(a5),d0
		beq.s	.NoWindow
		move.l	d0,a0

		lea	EUS_Structure(pc),a1
		move.w	WD_LeftEdge(a0),EUS_WinX(a1)
		move.w	WD_TopEdge(a0),EUS_WinY(a1)
		bsrif	GetSizeToSpecial,Inner_Special


	*------------- Signalbits lschen ------------*
		move.l	WinHandle(a5),a0
		move.l	86(a0),a1			;MsgPort des Windows
		move.l	SignalBits(a5),d1
		moveq	#0,d0
		move.b	15(a1),d0
		bclr	d0,d1
		move.l	d1,SignalBits(a5)


		clr.l	WinHandle(a5)
		clr.l	WinRastport(a5)
		clr.l	WinMSGPort(a5)
		move.l	DTG_Intuitionbase(a5),a6
		jsr	_LVOCloseWindow(a6)

	*-------- Alle Variablen und Strukturen freigeben ---------*
.NoWindow:	bsrif	FreeMenus,EID_MenuPic
		bsrif	FreeGadgets,EID_GadgetDown+EID_GadgetUp
		bsr.w	FreePubScreen

		movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
		if	ClassZipWindow
ZipMyWindow:	pushlibs
		tst.l	WinHandle(a5)
		bne.s	.ChangeWindow

	*----------- Window-Strukture ndern ----------*
	*--- Blo wie die Hhe des Windows angeben ----*
		bsr.w	OpenMyWindow

	*-------------- Window nur unzippen -----------*
.ChangeWindow:	move.l	WinHandle(a5),d0
		beq.s	.Return
		move.l	d0,a0
		move.w	10(a0),d0
		cmp.b	55(a0),d0
		beq.s	.Return
		move.l	DTG_Intuitionbase(a5),a6
		jsr	_LVOZipWindow(a6)
.Return:	poplibs
		rts


*-----------------------------------------------------------------------------*
UnZipMyWindow:	pushlibs
		tst.l	WinHandle(a5)
		bne.s	.ChangeWindow

	*----------- Window-Strukture ndern ----------*
	*--- Blo wie die Hhe des Windows angeben ----*
		bsr.w	OpenMyWindow
		bra.s	.Return

	*-------------- Window nur unzippen -----------*
.ChangeWindow:	move.l	WinHandle(a5),a0
		move.w	10(a0),d0
		cmp.b	55(a0),d0
		bne.s	.Return
		move.l	DTG_Intuitionbase(a5),a6
		jsr	_LVOZipWindow(a6)
.Return:	poplibs
		rts
		endc


*----------------------------- Fill-Window -------------------------------*
		if raster+rectfill
FillWindow:	movem.l	d0-a6,-(a7)
		tst.l	WinHandle(a5)
		beq.w	.Return
		move.l	DTG_GfxBase(a5),a6

	*------------ Zeichenstifte festlegen -------------*
		move.l	WinRastport(a5),d0
		beq.w	.Return
		move.l	d0,a1				;Rastport
	if raster
		moveq	#1,d0
	else
		moveq	#0,d0
	endc
		jsr	_LVOSetAPen(a6)
		move.l	WinRastPort(a5),a1
		moveq	#0,d0
		jsr	_LVOSetBPen(a6)

	*-------------- Zeichenmodus festlegen -------------*
		move.l	WinRastport(a5),a1
		moveq	#1,d0			;RP_Jam2
		jsr	_LVOSetDRmd(a6)

	*-------------- RastPort initialisieren ------------*
	if raster
		move.l	WinRastport(a5),a1
		move.b	29(a1),d4			;rp_areaptsz(a1),d4
		move.l	8(a1),d5			;rp_areaptrn(a1),d5
		move.b	#1,29(a1)			;rp_areaptsz
		lea	FillMuster1(pc),a0
		move.l	a0,8(a1)		;rp_areaptrn
	endc

	*------------- erstes Rectfill ausfhren -----------*
		move.l	WinHandle(a5),a0
		moveq	#0,d0				;x1
		add.b	54(a0),d0

		moveq	#0,d1				;y1
		move.b	55(a0),d1

		moveq	#0,d2
		sub.b	56(a0),d2
		ext.w	d2
		add.w	8(a0),d2			;x2

		moveq	#0,d3
		sub.b	57(a0),d3
		ext.w	d3
		add.w	10(a0),d3			;y2
		subq.w	#1,d2
		subq.w	#1,d3

		jsr	_LVORectfill(a6)

	
	*-------------- RastPort zurcksetzen ------------*
	if	raster
		movem.l	d4-d5,-(sp)
		move.l	WinRastPort(a5),a1
		lea	FillMuster2(pc),a0
		move.l	a0,8(a1)			;rp_areaptrn
		move.l	WinHandle(a5),a0

		moveq	#HoriRandBorder,d6
		moveq	#VertiRandBorder,d7
		moveq	#0,d0				;x1
		add.b	54(a0),d0
		add.w	d6,d0

		moveq	#0,d1				;y1
		move.b	55(a0),d1
		add.w	d7,d1

		moveq	#0,d2
		sub.b	56(a0),d2
		ext.w	d2
		add.w	8(a0),d2			;x2
		sub.w	d6,d2

		moveq	#0,d3
		sub.b	57(a0),d3
		ext.w	d3
		add.w	10(a0),d3			;y2
		sub.w	d7,d3
		subq.w	#1,d2
		subq.w	#1,d3

		jsr	_LVORectFill(a6)
		
	*------ Koordinaten fr Schwarz setzen -----*
		move.l	WinHandle(a5),a0
		move.l	WinRastPort(a5),a1
		moveq	#11,d0			;X-Position
		moveq	#0,d1
		move.b	55(a0),d1		;y1
		addq.w	#4,d1
		jsr	_LVOMove(a6)
		movem.l	(Sp)+,d4-d5
		move.l	WinRastPort(A5),a1
		move.b	d4,29(a1)			;rp_areaptsz
		move.l	d5,8(a1)			;rp_areaptrn
		move.l	WinRastPort(A5),a1
		moveq	#0,d0
		jsr	_LVOSetAPen(a6)
	endc

	*---------------- Kick2.0 BevelBox zeichnen --------------*
	if BevelBox
		move.l	DTG_GadToolsBase(a5),a6
		move.l	WinHandle(a5),a0

		moveq	#HoriRandBorder,d6
		moveq	#VertiRandBorder,d7
		moveq	#0,d0				;x1
		add.b	54(a0),d0
		add.w	d6,d0

		moveq	#0,d1				;y1
		move.b	55(a0),d1
		add.w	d7,d1

		moveq	#0,d2
		sub.b	56(a0),d2
		ext.w	d2
		add.w	8(a0),d2			;x2
		sub.w	d6,d2

		moveq	#0,d3
		sub.b	57(a0),d3
		ext.w	d3
		add.w	10(a0),d3			;y2
		sub.w	d7,d3

		sub.w	d0,d2
		sub.w	d1,d3

		move.l	WinRastPort(a5),a0
		lea	BevelBoxTags(a5),a3		;Tags mssen auch nach
		move.l	a3,a1				;a3
		move.l	#GT_Visualinfo,(a3)
		move.l	VisualInfo(a5),4(a3)
		jsr	_LVODrawBevelBoxA(a6)
	endc

.Return:	movem.l	(a7)+,d0-a6
		rts
		endc


*----------------------------------------------------------------------------*
RefreshMyWindow:pushlibs

		bsrif	FillWindow,Raster+RectFill

		move.l	DTG_GadToolsBase(a5),a6
		move.l	WinHandle(a5),d0
		beq.s	.Return
		move.l	d0,a0
		sub.l	a1,a1
		jsr	_LVOGT_BeginRefresh(a6)

		move.l	WinHandle(a5),a0
		moveq	#1,d0
		jsr	_LVOGT_EndRefresh(a6)

		bsrif	UpDateWindow,OwnRefresh

		bsrif	RefreshList,WithListView

.Return:	poplibs
		rts

*----------------------------------------------------------------------------*
	if	EWF_SizeBright+EWF_SizeBottom
ReSizeMyWindow:

	if	withlistview
		movem.l	d0-a6,-(a7)
		bsrif	FillWindow,Raster+RectFill
		move.l	DTG_IntuitionBase(a5),a6
		move.l	WinHandle(a5),d0
		move.l	d0,a0
		beq.s	.Return
	if	Inner_Special
		lea	EUS_Structure+EUS_Special(pc),a2
		move.l	8(a0),(a2)
	endc

	*-------------- Letztes SystemGadget finden ---------------*
		move.l	WD_FirstGadget(a0),a2
.FindIt:	move.w	GG_GadgetType(a2),d0
		btst	#15,d0
		beq.s	.GadgetDa
		move.l	a2,d6
		move.l	(a2),a2
		bra.s	.FindIt
.GadgetDa:	move.l	WD_FirstGadget(a0),a1
		move.l	a1,d5				;firstSystemGadget

		moveq	#-1,d0
		jsr	_LVORemoveGList(a6)


		bsr.w	FreeGadgets
		bsr.w	CreateGadgets

		move.l	d5,a1				;FirstGadget
		move.l	d6,a0
		move.l	WinGadgetsAdr(a5),(a0)		;Ketten verbinden

		move.l	WinHandle(a5),a0
		moveq	#0,d0
		moveq	#-1,d1
		moveq	#0,d2
		move.l	DTG_IntuitionBase(a5),a6
		jsr	_LVOAddGList(a6)

	if	WithListView
		bsr.w	FillListViews2
		move.l	DTG_GadToolsBase(a5),a6
		move.l	Winhandle(a5),d0
		beq.s	.Return
		move.l	d0,a0
		suba.l	a1,a1
		jsr	_LVOGT_RefreshWindow(a6)

	endc

		move.l	WinHandle(a5),a0
		move.l	DTG_IntuitionBase(a5),a6
		jsr	_LVORefreshWindowFrame(a6)


.Return:	movem.l	(a7)+,d0-a6
		rts
		endc
		endc


*-----------------------------------------------------------------------------*
		if	inner_special
GetSizeToSpecial:pushlibs
		move.l	WinHandle(a5),d0
		beq.s	.Return
		move.l	d0,a0
		moveq	#0,d0
		sub.b	54(a0),d0
		sub.b	56(a0),d0
		ext.w	d0
		add.w	8(a0),d0

		moveq	#0,d1
		sub.b	55(a0),d1
		sub.b	57(a0),d1
		ext.w	d1
		add.w	10(a0),d1
		lea	EUS_Structure(pc),a0
		move.w	d0,EUS_Special(a0)
		move.w	d1,EUS_Special+2(a0)
.Return:	poplibs
		rts
		endc


*-----------------------------------------------------------------------------*
		if	EID_GadgetDown+EID_GadgetUp
CreateGadgets:	movem.l d1-a6,-(a7)
		move.l	DTG_IntuitionBase(a5),a6
	;	tst.l	Winhandle(a5)
	;	bne.w	.Return
		tst.l	MyFirstGadget(a5)
		bne.w	.Return

	*----------- z.B Koordinaten setzen -----------*
		bsrif	InitGadgetsStructs,InitGadgets

		lea	MyFirstGadget(a5),a4
* GA_Top setzen
* GA_Relheight setzen
* GA_Top setzen
	
		if	WithScrollBalkenRight
		lea	WithScrollBalkenRightTags(pc),a2
		move.l	SichtbarVert(a5),76(a2)
		move.l	SichtbarVertAll(a5),84(a2)

;		move.l	WinHandle(a5),a0
;		moveq	#0,d0
;		move.b	55(a0),d0
;		addq.w	#1,d0
;		move.l	d0,d5
;		move.l	d0,12(a2)		;Hhe setzen
;
;		moveq	#0,d0
;		move.b	56(a0),d0
;		subq.l	#6,d0
;		move.l	d0,28(a2)		;Breite setzen
;		subq.l	#2,d0
;		move.l	d0,20(a2)		;Links setzen
;
;		move.l	d5,d0
;		neg.l	d0
;	;	sub.b	57(a0),d0
;		sub.w	#11,d0
;		ext.w	d0
;		ext.l	d0
;		move.l	d0,36(a2)
;
;		moveq	#0,d0
;		sub.b	56(a0),d0
;		ext.w	d0
;		ext.l	d0
;		addq.l	#5,d0
;		move.l	d0,44(a2)

		lea	EPPropClass(pc),a1
		sub.l	a0,a0
		jsr	_LVONewObjectA(a6)	
		move.l	d0,ScrollObjectRight(a5)
		tst.l	d0
		beq.w	.Return
		move.l	d0,(a4)
		move.l	d0,a4
	move.l	(a4),d0
	endc

	*------------------ Nun Bottom-Balken adden ------------------*
		if	WithScrollBalkenBottom

		lea	WithScrollBalkenBottomTags(pc),a2
		move.l	SichtbarHori(a5),76(a2)
		move.l	SichtbarHoriAll(a5),84(a2)
;		move.l	WinHandle(a5),a0
;
;		moveq	#0,d0
;		move.b	57(a0),d0
;		addq.w	#1,d0
;	;	move.l	d0,12(a2)		;Hhe setzen
;
;		moveq	#0,d0
;		move.b	54(a0),d0
;		move.l	d0,28(a2)		;Breite setzen
;	;	sub.b	56(a0),d0
;		sub.w	#61,d0
;		ext.w	d0
;		ext.l	d0
;	;	move.l	d0,20(a2)		;Links setzen
;
;		move.b	57(a0),d0
;		neg.b	d0
;	;	sub.w	#11,d0
;		ext.w	d0
;		ext.l	d0
;	;	move.l	d0,36(a2)
;
;		moveq	#0,d0
;		sub.b	57(a0),d0
;		ext.w	d0
;		ext.l	d0
;		addq.l	#5,d0
;	;	move.l	d0,44(a2)


		lea	EPPropClass(pc),a1
		sub.l	a0,a0
		jsr	_LVONewObjectA(a6)	
		move.l	d0,ScrollObjectBottom(a5)
		tst.l	d0
		beq.w	.Return
		move.l	d0,(a4)
		move.l	d0,a4
	endc

	*------------- nun die normalen Gadgets createn ------------*
		move.l	PubScreenAdr(a5),a0
		move.l	SC_Font(a0),a1
		move.w	TA_YSize(a1),d3
		addq.w	#1,d3
		move.b	SC_WBorTop(a0),d0
		ext.w	d0
		add.w	d3,d0
		move.w	d0,OffY(a5)
		move.w	#3,OffX(a5)

		moveq	#0,d3
		moveq	#0,d2
	ifeq	inner_special
		move.w	#WindowInnerWidth,d2
		move.w	#WindowInnerHeight,d3
	else
		move.w	EUS_Structure+EUS_Special(pc),d2
		move.w	EUS_Structure+EUS_Special+2(pc),d3
	endc
		move.l	PubScreenAdr(a5),a0
		move.l	d2,d0
		move.l	d0,d4

		moveq	#0,d2
		add.w	d2,d0
		addq	#3,d0
		move.b	SC_WBorRight(a0),d1
		ext.w	d1
		add.w	d1,d0
		cmp.w	SC_Width(a0),d0
		bls.s	.WidthOk
		move.w	sc_Width(a0),d0
		sub.w	d4,d0
		move.w	d0,d2
.WidthOk:	move.l	d3,d0
		move.l	d0,d4

		move.w	EUS_Structure+EUS_Winy(pc),d3
		add.w	d3,d0

		add.w	OffY(a5),d0
		move.b	SC_WBorBottom(a0),d1
		ext.w	d1
		add.w	d1,d0
		cmp.w	sc_Height(a0),d0
		bls.s	.SetGPtr
		move.w	SC_Height(a0),d0
		sub.w	d4,d0
		move.w	d0,d3

	*-------------- GadgetList-Ptr festlegen --------------*
.SetGPtr:	move.l	DTG_GadToolsBase(a5),a6
		lea	WinGadgetsAdr(a5),a0		;aktueller Gadgetptr
		jsr	_LVOCreateContext(a6)
		move.l	d0,a3
		tst.l	d0
		beq	.Return
		moveq	#0,d3			;Ptr fr GadgetAdrTabelle
		lea	NewGadgetTags(pc),a4

*----- Dir Gadgets nun nacheinander in GadgetPuffer kopieren und dann ------*
*----------- ber GadTools eine ordentliche Struktur erzeugen --------------*
.NextGadget:	Execbase
		lea	NewGadgetStrukturen(pc),a0
		move.l	d3,d0				;Nummer des Gadgets
		mulu	#GNG_SizeOf,d0
		add.l	d0,a0
		lea	GadgetPuffer(a5),a1
		moveq	#GnG_SizeOf,d0
		jsr	_LVOCopyMem(a6)


	*--- in der neuen Structur nun die Koordinaten neu festlegen ---*
		lea	GadgetPuffer(a5),a0
		move.l	VisualInfo(a5),GNG_VisualInfo(a0)
	if AbsoluteFont
		move.l	Font(a5),gng_TextAttr(a0)
	endc
		move.w	OffX(a5),d0
		add.w	d0,GNG_LeftEdge(a0)
		move.w	OffY(a5),d0
		add.w	d0,GNG_TopEdge(a0)

	*----------------------- Gadget nun createn ---------------------*
		move.l	DTG_GadToolsBase(a5),a6
		lea	NewGadgetTypes(pc),a0
		moveq	#0,d0
		move.l	d3,d1
		asl.l	#1,d1
		add.l	d1,a0
		move.w	(a0),d0
		move.l	a3,a0
		lea	GadgetPuffer(a5),a1
		move.l	a4,a2
		jsr	_LVOCreateGadgetA(a6)
		tst.l	d0
		beq.s	.Return

	*-- tabelle anlegen, in der alle Gadgetadressen enthalten sind --*
.GadgetOk:	move.l	d0,a3
		move.l	d3,d0
		asl.l	#2,d0
		lea	GadgetDefinitionen(a5),a0
		add.l	d0,a0
		move.l	a3,(a0)

	*--------------- TagListEnde suchen-------------*
.FindLastTagItem:tst.l	(a4)
		beq.s	.IncGNr
		addq.l	#8,a4
		bra.s	.FindLastTagItem

.IncGNr:	addq.l	#4,a4
		addq.w	#1,d3
		cmp.w	#GadgetAnz,d3
		bmi	.NextGadget

	*---- ActivationsFlags eventuell neu setzen ----*
	*- nur fr Gadgets, die ein/ausschaltbar sind --*
;		lea	ActivationTab(pc),a2
;.NextGadgetActi:move.w	(a2)+,d0
;		beq.s	.FlagsIO
;		bsr	FindGadget			;Gadgetadresse in A0
;		move.w	GG_Activation(a0),d0
;		or.w	(a2)+,d0
;		move.w	d0,GG_activation(a0)
;		bra.s	.NextGadgetActi
;ActivationTab:	dc.w	0



	*--------------- 1. Gadgetende suchen-------------*
		lea	MyFirstGadget(a5),a0
.FindLastPtr:	tst.l	(a0)
		beq.s	.MyLastFound
		move.l	(a0),a0
		bra.s	.FindLastPtr
.MyLastFound:	move.l	WinGadgetsAdr(a5),(a0)

	;	bsrif	FillListViews,WithListview
	;	bsrif	ChangeGadgets,InitGadgets2

.Return:	movem.l	(a7)+,d1-a6
		move.l	MyFirstGadget(a5),d0
		rts
		endc


*-----------------------------------------------------------------------------*
		if	InitGadgets
InitGadgetsStructs:
	move.l	PubscreenAdr(a5),d1
	beq.s	.lo
	move.l	d1,a0
	moveq	#0,d1
	add.b	sc_wborleft(a0),d1
	move.w	d1,ListViewGadget
.lo

	if	withlistview
		pushlibs
	if	EWF_SizeBright+EWF_SizeBottom
		bsrif	GetSizeToSpecial,Inner_Special
		lea	ListViewGadget+4(pc),a0

		if	Inner_Special
		move.l	EUS_Structure+EUS_Special(pc),d1
		else
		move.l	InnerKoordinaten(pc),d1		;Koor fr Default
		endc

.SetDefaults:	move.l	d1,(a0)				;Breite,Hhe setzen
		sub.w	#AbstandLinks*2,(a0)
		sub.w	#AbstandOben*2,2(a0)
		endc
	ifeq	EWF_SizeBright+EWF_SizeBottom
		tst.w	Kick3On(a5)
		bne.s	.Kick30
		move.w	#ListView20Height,ListViewGadget+6
	endc
.Kick30:	endc
		poplibs
		rts
		endc


*----------------------------------------------------------------------------*
	if withlistview
RefreshList:	pushlibs

		*--- Kommando an EP schicken ---*
		lea	ENA_Args1(a5),a0
		move.l	#-1,ENA_Arg1(a0)
		move.l	a0,d4
		moveq	#0,d1
		moveq	#USClass_Command,d2
		move.l	#EPNr_LoadModule,d3		*EP-Kommando
		moveq	#0,d5
		bsr	SendeOneMessage


*		bsr.w	FillListViews
*		move.l	DTG_GadToolsBase(a5),a6
*		move.l	Winhandle(a5),d0
*		beq.s	.Return
*		move.l	d0,a0
*		suba.l	a1,a1
*		jsr	_LVOGT_RefreshWindow(a6)

.Return:	poplibs
		rts
	endc

*-----------------------------------------------------------------------------*
	if	Withlistview
FillListViews:	bsr.w	UpdateListViewList
FillListViews2:	movem.l	d0-a6,-(a7)
		move.l	DTG_GadToolsBase(a5),a6
		move.l	Winhandle(a5),d0
		beq.s	.Return
		move.l	d0,a1
		moveq	#NrListView,d0
		bsr	FindGadget			:NotFound







*.next:	move.w	16(a0),d0		*Type
*	move.l	18(a0),a1		*Gadgetrender
*	move.l	08(a1),a1
*	move.l	(a0),d0
*	beq.s	.ok
*	move.l	d0,a0
*	bra	.next
*.ok:	movem.l	(a7)+,a0/a1

*	move.l	a0,-(a7)
*	move.l	WinHandle(a5),a0
*	move.l	62(a0),a0
*.next:	move.w	16(a0),d0
*	move.l	(a0),d0
*	beq.s	.ok
*	move.l	d0,a0
*	bra	.next
*.ok:
*
*	move.l	(a7)+,a0


		move.l	Eintrage(a5),d0
		lea	ListViewTags(pc),a3

	move.l	EUS_Structure+EUS_EPBAse(pc),a2
	move.l	EPG_Entries(a2),Eintrage(a5)
	move.l	EPG_ModulesList(a2),a2

	*	lea	ListViewStruct(a5),a2
		move.l	a2,4(a3)
		move.w	ListViewNr(a5),14(a3)
		move.w	ListViewNr(a5),22(a3)
		sub.l	a2,a2
		jsr	_LVOGT_SetGadgetAttrsA(a6)

.Return:	movem.l	(a7)+,d0-a6
		rts
	endc

*-----------------------------------------------------------------------------*
	if	Withlistview
ClearListViews:	pushlibs
		move.l	DTG_GadToolsBase(a5),a6
		move.l	Winhandle(a5),d0
		beq.s	.Return
		move.l	d0,a1
		moveq	#NrListView,d0
		bsr	FindGadget

		lea	ListViewTags(pc),a3
		move.l	#-1,4(a3)
		clr.l	12(a3)
		clr.l	20(a3)
		sub.l	a2,a2
		jsr	_LVOGT_SetGadgetAttrsA(a6)

		bsr.w	RefreshMyWindow
.Return:	clr.w	ListViewNr(a5)
		poplibs
		rts
	endc

*----------------------------------------------------------------------------*
* Achtung: darauf achten, ob Gadgets vom Window removed wurden !!!!!! -------*
		if	EID_GadgetDown+EID_GadgetUp
FreeGadgets:	pushlibs
	;	tst.l	WinHandle(a5)			;nur freigeben, wenn
	;	bne.s	.Return				;Window zu ist

	*--------------- Nun die Gadgets freigeben -------------*
		move.l	DTG_GadToolsBase(a5),a6
		move.l	WinGadgetsAdr(a5),d0
		beq	.NoGadgets
		move.l	d0,a0
		clr.l	WinGadgetsAdr(a5)
		jsr	_LVOFreeGadgets(a6)
		lea	GadgetDefinitionen(a5),a0
		moveq	#GadgetAnz-1,d0
		blt.s	.NoGadgets
.ClrPtrs:	clr.l	(a0)+
		dbf	d0,.ClrPtrs

	*----------- Nun oberen ScrollBalken freigeben ---------*
.NoGadgets:	if	WithScrollBalkenRight+WithScrollBalkenBottom
		move.l	DTG_Intuitionbase(a5),a6
		endc
		if WithScrollBalkenRight
		move.l	ScrollObjectRight(a5),d0
		beq.s	.NoRight
		move.l	d0,a0
		clr.l	ScrollObjectRight(a5)
		jsr	_LVODisposeObject(a6)
		endc

	*---------- Nun unteren Scrollbalken entfernen ----------*
.NoRight:	if	WithScrollBalkenBottom
		move.l	ScrollObjectBottom(a5),d0
		beq.s	.NoBottom
		move.l	d0,a0
		clr.l	ScrollObjectBottom(a5)
		jsr	_LVODisposeObject(a6)
		endc

	*---------- Nun die normalen Gadgets freigeben ----------*
.NoBottom:	clr.l	MyFirstGadget(a5)
.Return:	poplibs
		rts
		endc


*-----------------------------------------------------------------------------*
		if	EID_GadgetDown+EID_GadgetUp
FindGadget:	lea	GadgetDefinitionen(a5),a0
		subq.l	#NrFirstGadget,d0
		lsl.l	#2,d0
		move.l	(a0,d0.w),a0
		lsr.l	#2,d0
		rts
		endc


*----------------------------------------------------------------------------*
*------		Public Screen ranholen und Visual Info anfordern	-----*
*----------------------------------------------------------------------------*
LockPubScreen:	pushlibs
		clr.l	VisualInfo(a5)
		move.l	EPBase(a5),a0
		move.l	EPG_Pubscreen(a0),a0
		move.l	DTG_Intuitionbase(a5),a6
		jsr	_LVOLockPubScreen(a6)
		move.l	d0,PubscreenAdr(a5)
		tst.l	d0
		beq.s	.Error

		move.l	PubscreenAdr(a5),a0
		move.l	DTG_GadToolsbase(a5),a6
		sub.l	a1,a1
		jsr	_LVOGetVisualInfoA(a6)
		move.l	d0,VisualInfo(a5)
		tst.l	d0
		beq.w	.Error
.Error:		poplibs
		move.l	VisualInfo(a5),d0
		rts

*----------------------------------------------------------------------------*
*------		Public Screen ranholen und Visual Info anfordern	-----*
*----------------------------------------------------------------------------*
FreePubScreen:	pushlibs
		move.l	DTG_GadToolsBase(a5),a6
		move.l	VisualInfo(a5),d0
		beq.s	.NoVisualInfo
		move.l	d0,a0
		clr.l	VisualInfo(a5)
		jsr	_LVOFreeVisualInfo(a6)
.NoVisualInfo:	move.l	DTG_Intuitionbase(a5),a6
		sub.l	a0,a0
		move.l	PubScreenAdr(a5),d0
		beq.s	.NoPub
		move.l	d0,a1
		clr.l	PubScreenAdr(a5)
		jsr	_LVOUnlockPubScreen(a6)
.NoPub:		poplibs
		rts


*-----------------------------------------------------------------------------*
*-----				Menustrip setzen			------*
*-----------------------------------------------------------------------------*
		if	EID_MenuPic
SetMenuStrip:	pushlibs
		tst.w	WinMenuOn(a5)
		bne.s	.NoMenus
		move.l	Winhandle(a5),d0
		beq.s	.NoMenus
		move.l	d0,a0
		move.l	WinMenuAdr(a5),d0
		beq.s	.NoMenus
		move.l	d0,a1
		move.l	DTG_Intuitionbase(a5),a6
		jsr	_LVOSetMenuStrip(a6)
		move.l	DTG_Gadtoolsbase(a5),a6
		move.l	Winhandle(a5),a0
		sub.l	a1,a1
		jsr	_LVOGT_RefreshWindow(a6)
		move.w	#1,WinMenuOn(a5)
.NoMenus:	poplibs
		rts
		endc

*-----------------------------------------------------------------------------*
*-----				Menustrip lschen			------*
*-----------------------------------------------------------------------------*
		if	EID_MenuPic
ClearMenuStrip:	pushlibs
		tst.w	WinMenuOn(a5)
		beq.s	.NoMenus
		move.l	Winhandle(a5),d0
		beq.s	.NoMenus
		move.l	d0,a0
		move.l	WinMenuAdr(a5),d0
		beq.s	.NoMenus
		move.l	d0,a1
		move.l	DTG_Intuitionbase(a5),a6
		jsr	_LVOClearMenuStrip(a6)
		move.l	DTG_Gadtoolsbase(a5),a6
		move.l	Winhandle(a5),a0
		sub.l	a1,a1
		jsr	_LVOGT_RefreshWindow(a6)
.NoMenus:	clr.w	WinMenuOn(a5)
		clr.w	ItemAddi(a5)
		poplibs
		rts
		endc


*-----------------------------------------------------------------------------*
		if	EID_MenuPic
CreateMenus:	movem.l	d1/a0-a2/a6,-(a7)

	*--------------- Menus erstellen -----------------*
		move.l	WinMenuAdr(a5),d0
		bne.s	.Return
		move.l	DTG_GadToolsBase(a5),a6
		lea	MyMenus(pc),a0
		lea	MenuTags(pc),a1
		jsr	_LVOCreateMenusA(a6)
		move.l	d0,WinMenuAdr(a5)
		tst.l	d0
		beq.s	.Return

	*------------ Menu dem Screen anpassen -----------*
		move.l	d0,a0
		move.l	VisualInfo(a5),d0
		beq.s	.Return
		move.l	d0,a1
		lea	MenuTags(pc),a2
		jsr	_LVOLayoutMenusA(a6)
		tst.l	d0
		bne.s	.Return

	*------------ Menus wieder freigeben -------------*
		move.l	WinMenuadr(a5),a0
		clr.l	WinMenuadr(a5)
		jsr	_LVOFreemenus(a6)


.Return:	movem.l	(a7)+,d1/a0-a2/a6
		tst.l	d0
		rts
		endc

*-----------------------------------------------------------------------------*
		if	EID_MenuPic
FreeMenus:	pushlibs
		move.l	WinMenuAdr(a5),d0
		beq.s	.Return
		clr.l	WinMenuAdr(a5)
		move.l	d0,a0
		bsr.w	ClearMenuStrip
		move.l	DTG_GadToolsBase(a5),a6
		jsr	_LVOFreeMenus(a6)
.Return:	poplibs
		rts
		endc




	*----- Hintergrundpattern fr Schraffierungen ------*
		if	raster
FillMuster1:	dc.w	%1010101010101010
		dc.w	%0101010101010101
FillMuster2:	dc.w	0,0
		endc

*-----------------------------------------------------------------------------*
		if	WithScrollBalkenRight
WithScrollBalkenRightTags:
.4		dc.l	GA_ID,2
.12		dc.l	GA_Top,12		;Hhe des ScreenFonts
.20		dc.l	GA_Width,10
.28		dc.l	GA_Left,12
.36		dc.l	GA_RelHeight,-13-12
.44		dc.l	GA_RelRight,-12
.52		dc.l	GA_RightBorder,1
.60		dc.l	GA_Immediate,1
.68		dc.l	PGA_Freedom,Freevert
.76		dc.l	PGA_Total,20		;MessageNum
.84		dc.l	PGA_Visible,5		;Anzahl fr ScrollBalken
		dc.l	PGA_Top,0		;soll 0 sein
		dc.l	PGA_NewLook,1
		dc.l	0
		endc

		if	WithScrollBalkenBottom
WithScrollBalkenBottomTags:
.4		dc.l	GA_ID,2
.12		dc.l	GA_Top,0		;Wert egal
.20		dc.l	GA_Height,6
.28		dc.l	GA_Left,2
.36		dc.l	GA_RelWidth,-13-12
.44		dc.l	GA_RelBottom,-7
		dc.l	GA_BottomBorder,1
		dc.l	GA_Immediate,1
		dc.l	PGA_Freedom,Freehoriz
		dc.l	PGA_Total,12		;MessageNun
		dc.l	PGA_Visible,10		;Anzahl fr ScrollBalken
		dc.l	PGA_Top,0		;soll 0 sein
		dc.l	PGA_NewLook,1
		dc.l	0
		endc


	*--------- Definitionien fr EasyStruct ------------*
		ifeq	executable+debugger
About_EasyStruct:dc.l	0
		dc.l	0
		dc.l	MYEasyTitle
		dc.l	Kickstart20Text		;AboutRequester
		dc.l	EG_Ok

	ifeq	executable
Registered_EasyStruct:
		dc.l	0
		dc.l	0
		dc.l	MyEasyTitle
		dc.l	OnlyRegistered.Msg		;AboutRequester
		dc.l	EG_Ok
	endc
		endc

EPFind_EasyStruct:dc.l	0
		dc.l	0
		dc.l	MyEasyTitle
		dc.l	EPPortNotFound		;Cannot find Eagleplayerport
		dc.l	EG_RetryCancel

*ScreenTitle:	dc.b "Dirlistviewer (Eagleplayer),  DEFECT Softworks",0
MyCreatorname:	dc.b	"Eagleeye of DEFECT",0
EPUserPortname:	dc.b	"EAGLEPLAYERPORT",0
		if	WithScrollBalkenRight+WithScrollBalkenBottom
EPPropClass:	dc.b	"propgclass",0
		endc
EPPortNotFound:	dc.b	"Cannot find EaglePlayer Port",0
Kickstart20Text:dc.b	"This Userprogram needs Amiga-OS2.04 or higher to run !!!",0
Kickstart20TextLen	= *-Kickstart20Text
EG_Ok:		dc.b	"   OK   ",0
EG_RetryCancel:	dc.b	" Retry | Cancel ",0
;EG_YesNo:	dc.b	"Yes|Cancel",0
		even
;;


*-----------------------------------------------------------------------------*
*--------------- Nun kommen die Userprogrammtypischen Routinen ---------------*
*-----------------------------------------------------------------------------*
*-----------------------------------------------------------------------------*
*----------------------------------------------------------------------------*
FirstFillListViews:movem.l d0-a6,-(a7)
		moveq	#0,d1
		moveq	#USClass_LockEP,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		bsrif	SendeOneMessage,Executable+Debugger
		bsr.w	FillListViews
		moveq	#0,d1
		moveq	#USClass_UnLockEP,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		bsrif	SendeOneMessage,Executable+Debugger
		movem.l	(a7)+,d0-a6
		rts


*----------------------------------------------------------------------------*
UpdateListViewList:
		moveq	#0,d0
		rts

*
*		movem.l d1-a6,-(a7)
*		bsr.w	DeleteListViewList
*
*	*--------------- Macro NewList icnlude:exec/lists.i" --------------*
*		lea	ListViewStruct(a5),a2
*		move.l  a2,lh_tailpred(a2)
*		addq.l  #4,a2			;get address of lh_tail
*		clr.l   (a2)			;clear lh_tail
*		move.l  a2,-(a2)		;address of lh_tail to lh_head
*
*	*-------------- Speicher fr Liste besorgen ----------*
*		move.l	EUS_Structure+EUS_EPBase(pc),a4
*		lea	EPG_FirstFileStruct(a4),a2
*		move.l	EPG_Entries(a4),d5
*		beq.w	.ItsAll
*		move.l	d5,Eintrage(a5)
*		move.l	d5,d0
*		mulu	#LN_Size,d0
*		move.l	EPG_Dirs(a4),d1
*		move.l	d1,Dirs(a5)
*		mulu	#Namenlange+2,d1
*		add.l	d1,d0
*		add.l	#200,d0				;Sicherheit
*		move.l	#$10001,d1
*		Execbase
*		jsr	_LVOAllocMem(a6)
*		tst.l	d0
*		beq.s	.ItsAll
*		move.l	d0,DirListAdr(a5)
*		subq.l	#1,d5
*		move.l	d0,a3
*
*	*---------- Meine PublicScreenliste aufbauen ----------*
*.NextEntry:	move.l	(a2),d0
*		beq.s	.ItsAll
*		move.l	d0,a2
*
*	*----------- Macro Addtail aud include:exec/lists.i ---------*
*		lea	ListViewStruct(a5),a0	;inserted
*		addq.l	#LH_Tail,a0
*		move.l	LN_Pred(a0),d0
*		move.l	a3,LN_Pred(a0)
*		exg	d0,a0
*		movem.l	d0/a0,(a3)
*		move.l	a3,(a0)
*
*	*----------- Handelt es sich um ein File ------------*
*		lea	EFP_NamePuffer(a2),a0
*		move.b	EFP_Flags(a2),d0
*		btst	#EFPF_Dirname,d0
*		bne.s	.Dirname
*		move.l	a0,LN_Name(a3)
*		lea	LN_Size(a3),a3
*		dbf	d5,.NextEntry
*		bra.s	.ItsAll
*
*.Dirname:	lea	LN_Size(a3),a1
*		move.l	a1,LN_Name(a3)
*		btst	#4,EFP_MI_Flags+1(a2)
*		beq.s	.NotAllowed
*		move.b	#"-",(a1)+
*		move.b	#">",(a1)+
*		bra.s	.StringOk
*.NotAllowed:	move.b	#"$",(a1)+
*		move.b	#">",(a1)+
*.StringOk:	move.b	#" ",(a1)+
*		moveq	#Namenlange-2,d1
*		move.l	EUS_Structure+EUS_EPBase(pc),a6
*		jsr	ENPP_StringCopy(a6)
*	;	move.b	#">",(a1)+
*		clr.b	(a1)
*		lea	LN_Size+Namenlange+2(a3),a3
*		dbf	d5,.NextEntry
*
*.ItsAll:	movem.l	(a7)+,d1-a6
*		tst.l	d0
*		rts

*----------------------------------------------------------------------------*
DeleteListViewList:pushlibs
		bsr	ClearListViews

	*---------- Meine PublicScreenliste aufbauen ----------*
		move.l	DirListAdr(a5),d0
		beq.s	.NoList
		clr.l	DirListAdr(a5)
		move.l	d0,a1
		move.l	Eintrage(a5),d0
		beq.s	.NoList
		clr.l	Eintrage(a5)
		mulu	#LN_Size,d0
		move.l	Dirs(a5),d1
		mulu	#Namenlange+2,d1
		add.l	#200,d1				;Sicherheit
		add.l	d1,d0
		Execbase
		jsr	_LVOFreeMem(a6)
.NoList:	*lea	ListViewStruct(a5),a0
		*newlist	a0
		poplibs
		rts


*-------------- Anzahl der angezeigten Items im Listview berechnen -----------*
BerechGadAnz:


	movem.l	d1/a0/a1,-(a7)

	moveq	#NrListView,d0
	bsr	FindGadget			:NotFound

	move.l	WinHandle(a5),a1
	move.l	50(a1),a1		*Rastport
	move.l	52(a1),a1		*Font
	move.w	20(a1),d0
	moveq	#0,d1
	move.w	10(a0),d1
	divu	d0,d1
	moveq	#0,d0
	move.w	d1,d0
	movem.l	(a7)+,d1/a0/a1
	rts
*
*
*	moveq	#1,d0				;Default
*
*	*-------------- Ersten KlickGadget im Listview finden ---------------*
*		move.l	WinHandle(a5),d1
*		beq.s	.Return
*		move.l	d1,a0
*
*		lea	WD_FirstGadget(a0),a2
*.FindIt:	move.l	(a2),d1
*		beq.s	.Return
*		move.l	d1,a2
*		cmp.w	#$101,GG_GadgetType(a2)
*		bne.s	.FindIt
*
*	*-------------- Zhlen, wieviele Listview-KlickGadgets --------------*
*		moveq	#0,d0
*.AddNext:	addq.l	#1,d0
*		move.l	(a2),d1
*		beq.s	.Return
*		move.l	d1,a2
*		cmp.w	#$101,GG_GadgetType(a2)
*		beq.s	.AddNext
*
*;		move.l	WinHandle(a5),d0
*;		beq.s	.Return
*;		move.l	d0,a1
*;		move.l	WD_WScreen(a1),a0
*;		move.l	SC_Font(a0),a0
*;		move.w	TA_YSize(a0),d1
*;	;	addq.w	#3,d1			;Hhe fr Font
*;		moveq	#0,d0
*;		move.w	10(a1),d0		;Hhe des Windows holen
*;		tst.w	Kick3On(a5)
*;		bne.s	.NoKick30
*;		sub.w	d1,d0			;unteren AnzeigeBalken abziehen
*;.NoKick30:	sub.w	#AbstandOben*2+3,d0	;nun Size des ListViews
*;		divu	d1,d0			;d0=Anzahl der angezeigten
*;						;Listviewgadgets
*;		ext.l	d0
*.Return:	rts
*

*------------ verndere die Einstellungen des Listviewgadgets ---------------*
Top:		moveq	#0,d5
		bra.s	SetListView
Botom:		move.l	EinTrage(a5),d5
		subq.l	#1,d5
		bra.s	SetListView
Up:		moveq	#0,d5
		move.w	ListViewNr(a5),d5
		ble.w	Return
		subq.l	#1,d5
		bra.s	SetListView
Down:		moveq	#0,d5
		move.w	ListViewNr(a5),d5
		addq.l	#1,d5
		cmp.l	Eintrage(a5),d5
		bhs.w	Return
		*addq.l	#1,d5
		bra.s	SetListView


PageUp:		bsr.s	BerechGadAnz
		moveq	#0,d5
		move.w	ListViewNr(a5),d5
		sub.w	d0,d5
		bhi.s	.IO
		moveq	#0,d5
.Io:		bra.s	SetListView

PageDown:	bsr.w	BerechGadAnz
		moveq	#0,d5
		move.w	ListViewNr(a5),d5
		add.w	d0,d5
		cmp.l	EinTrage(a5),d5
		blo.s	.IO
		move.l	EinTrage(a5),d5
		subq.l	#1,d5
.Io:		bra.w	SetListView


*------------- Selectierten Eintrag im ListviewGadget neu setzen ------------*
*---- d5 = Nummer des Eintrages						-----*
SetListView:	tst.l	Eintrage(a5)
		beq.s	.Return

		move.l	DTG_GadToolsBase(a5),a6
		move.l	Winhandle(a5),d0
		beq.s	.Return
		move.l	d0,a1
		moveq	#NrListView,d0
		bsr	FindGadget			:NotFound

		lea	ListViewTags(pc),a3

	move.l	EUS_Structure+EUS_EPBAse(pc),a2
	move.l	EPG_ModulesList(a2),a2
		move.l	a2,4(a3)
		move.w	d5,14(a3)
		move.w	d5,22(a3)
		move.w	d5,ListViewNr(a5)
		sub.l	a2,a2
		jsr	_LVOGT_SetGadgetAttrsA(a6)

		bsr	TitleAufbau
.Return:	rts

*----------------------------- Parent ausfhren -----------------------------*
Parent:		moveq	#0,d5
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		lea	EPG_FirstFileStruct(a4),a2
		move.l	(a2),d0
		beq.s	.Return
		move.l	d0,a2
		move.b	EFP_Flags(a2),d0
		btst	#EFPF_Parent,d0
		bne.w	Auswahl2
.Return:	rts

*------------- Nur ausfhren, wenn selectierter Eintrag ein File ist ----------*
Rechts:		moveq	#0,d5
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_Moduleslist(a4),a2
		move.w	ListviewNr(a5),d1
.Next:		move.l	(a2),d0
		beq.s	.Return
		move.l	d0,a2
		dbf	d1,.Next
		move.w	ListviewNr(a5),d5
		lea	-EFP_Node(a2),a2
		moveq	#0,d0
		move.b	EFP_Flags(a2),d0
		btst	#EFPF_FileName,d0
		bne.s	.FileName
		btst	#EFPF_DirName,d0
		bne.w	Auswahl2
		bra.s	.Return
.Filename:	moveq	#0,d1
		moveq	#USClass_Command,d2
		move.l	#EPNR_NextPattern,d3
		moveq	#0,d4
		moveq	#0,d5
		bsrif	SendeOneMessage,Executable+Debugger
.Return		rts

Links:		moveq	#0,d5
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_Moduleslist(a4),a2
		move.w	ListviewNr(a5),d1
.Next:		move.l	(a2),d0
		beq.s	.Return
		move.l	d0,a2
		dbf	d1,.Next
		move.w	ListviewNr(a5),d5
		lea	-EFP_Node(a2),a2
		moveq	#0,d0
		move.b	EFP_Flags(a2),d0
		btst	#EFPF_FileName,d0
		bne.s	.FileName
		btst	#EFPF_Parent,d0
		bne.w	Auswahl2
		bra.s	.Return
.Filename:	moveq	#0,d1
		moveq	#USClass_Command,d2
		move.l	#EPNR_PrevPattern,d3
		moveq	#0,d4
		moveq	#0,d5
		bsrif	SendeOneMessage,Executable+Debugger
.Return		rts


*------------- Nur ausfhren, wenn selectierter Eintrag ein Dir ist ----------*
SetDir:		moveq	#0,d5
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		move.l	EPG_Moduleslist(a4),a2
		move.w	ListviewNr(a5),d1
.Next:		move.l	(a2),d0
		beq.s	.Return
		move.l	d0,a2
		dbf	d1,.Next
		move.w	ListviewNr(a5),d5
		lea	-EFP_Node(a2),a2
		moveq	#0,d0
		move.b	EFP_Flags(a2),d0
		btst	#EFPF_DirName,d0
		bne.s	Auswahl2
		btst	#EFPF_ArchiveDir,d0
		bne.s	Auswahl2
.Return:	rts

*----------------------- Listview-Gadget wurde gedrckt ----------------------*
ListView:	move.l	StartSeconds(a5),d0
		move.l	StartMicros(a5),d1
		move.l	CurrentSeconds(a5),d2
		move.l	CurrentMicros(a5),d3
		move.l	d2,StartSeconds(a5)
		move.l	d3,StartMicros(a5)
		move.w	ListViewNr(a5),d5
		move.w	d4,ListViewNr(a5)
		cmp.w	d4,d5
		bne.w	TitleAufbau
		move.l	DTG_IntuitionBase(a5),a6
		jsr	_LVODoubleClick(a6)
		cmp.l	#1,d0
		bne.w	Return

	*-------- Doubleklick in erforderlicher Zeit ----------*
Auswahl:	moveq	#0,d5
		move.w	ListViewNr(a5),d5
Auswahl2:	*tst.l	EinTrage(a5)
		*beq.w	.Return
		clr.l	StartSeconds(a5)
		clr.l	StartMicros(a5)

	*------------ Text suchen -----------*
		move.l	d5,d0

		move.l	EUS_Structure+EUS_EPBase(pc),a0
		move.l	EPG_ModulesList(a0),a0
		*lea	ListViewStruct(a5),a0
.GiveStruct:	move.l	(a0),a0
		dbf	d0,.GiveStruct
		moveq	#0,d5
		move.w	-EFP_Node+EFP_ModuleNr(a0),d5
		btst	#4,-EFP_Node+EFP_MI_Flags+1(a0)
		bne.s	.ItemErlaubt

*	bra.w	.ItemErlaubt			;;!! musste ich erstmal so machen
*		move.l	LN_Name(a0),a0
*		cmp.b	#"$",(a0)
*		bne.s	.ItemErlaubt


*Zur Zeit disabled
		moveq	#0,d1
		moveq	#USClass_LockEP,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		bsrif	SendeOneMessage,Executable+Debugger

	if	executable+Debugger
		move.l	EUS_Structure+EUS_EPBase(pc),a4
		lea	OnlyRegistered.Msg(pc),a1
		move.l	a1,EPG_Arg1(a4)
		move.l	EPG_PubScreen(a4),EPG_Arg2(a4)
		clr.l	EPG_Arg3(a4)
		subq.l	#1,EPG_Arg3(a4)			;X-Koordinate
		clr.l	EPG_Arg4(a4)
		lea	MyEasyTitle(pc),a0
		move.l	a0,EPG_Arg5(a4)
		clr.l	EPG_Arg6(a4)
		moveq	#-1,d0
		move.l	d0,EPG_Arg7(a4)
		moveq	#7,d0
		move.l	d0,EPG_ArgN(a4)
		jsr	ENPP_TextRequest(a4)
	else
		move.l	WinHandle(a5),a0	;Window
		lea	Registered_EasyStruct(pc),a1	;EasyStruct
		sub.l	a2,a2			;IDCMP_Ptr
		sub.l	a3,a3			;Arguments
		move.l	DTG_IntuitionBase(a5),a6
		jsr	_LVOEasyRequestArgs(a6)
	endc

		moveq	#0,d1
		moveq	#USClass_UnLockEP,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		bsrif	SendeOneMessage,Executable+Debugger
		bra.w	.Return
*Zur Zeit disabled



.ItemErlaubt:
	if Executable+Debugger
		moveq	#0,d7
		move.w	#EPT_String,d7
		move.l	d7,d0
		move.l	#$10001,d1
		Execbase
		jsr	_LVOAllocMem(a6)
		move.l	d0,d4
		beq.s	.Return
		move.l	d0,a0
		move.l	d7,EPT_StringSize(a0)
		move.l	d5,EPT_Result1(a0)

	*--------- Message abschicken ---------*
		moveq	#0,d1
		moveq	#USClass_Command,d2
		moveq	#0,d3
		move.w	#EPNr_Module,d3
		moveq	#0,d5
		bsrif	SendeoneMessage,Executable+Debugger
		bsr	TitleAufbau
	endc
.Return:	rts


*--------- Hookfunktion, um aktuellen Amplifier  farblich hervorzuheben ------*
*---------------- derzeit noch kein Support fr "disabled"-Gadgets -----------*
*benutzte Globals:
* - grafsave+datas = Graphics Base
*
*Erkennung, ob Zeile hervorzuheben oder nicht:
* - EPG_ActiveAmplifier heranziehen und EUS_Creator vergleichen
*
* Input:a0:Hook
*	a1:Message
*	a2:Node
* Output:?
*-----------------------------------------------------------------------------*
Listview_Hook:	movem.l	d1-a6,-(a7)
		lea	Puffer,a5

		move.l	lvdm_MethodID(a1),d1
		cmp.l	#LV_Draw,d1
		bne.w	.Error
		move.l	a1,a4
		move.l	lvdm_RastPort(a4),d7
		beq.w	.Error

		move.l	lvdm_DrawInfo(A4),d0
		beq.w	.Error
		move.l	d0,a1
		move.l	dri_Pens(a1),a1
		move.l	ln_name(A2),a3

		*--- Textpen auswhlen ---*
		move	textpen*2(a1),d0		;Schwarz
		move.b	-EFP_Node+EFP_Flags(a2),d6	;Eintragtyp
		btst	#EFPF_FileName,d6
		bne.w	.FarbeOk
		*move	FILLPEN*2(a1),d0		;Blau
		move	FillTextPen*2(a1),d0		;Weiss
		btst	#EFPF_DirName,d6
		bne.w	.FarbeOk
		*move	FILLPEN*2(a1),d0		;Blau
		btst	#EFPF_Parent,d6
		bne.w	.FarbeOk
		move	textpen*2(a1),d0		;Schwarz

.FarbeOk:	move	backgroundpen*2(a1),d6

		cmp.l	#LVR_SELECTED,lvdm_State(a4)
		bne.s	.normalBG

		move	FILLPEN*2(a1),d6
	;	move	Filltextpen*2(a1),d0

.normalBG:	move	d6,d1
		moveq	#RP_Jam1,d2
		move.l	d7,a1
		move.l	GFXBase(a5),a6			;Graphics Base
		jsr	_LVOsetabpendrmd(A6)

		move.w	lvdm_bounds+ra_minx(a4),d0
		move.w	lvdm_bounds+ra_miny(a4),d1
		move.l	d7,a1
		add	rp_TxBaseline(a1),d1
		jsr	_LVOMove(A6)

		move.l	d7,a1
		moveq	#RP_Jam2,d0
		jsr	_LVOsetdrmd(A6)

		move.w	lvdm_bounds+ra_maxx(a4),d5		;Begrenzung des Textes
		sub	lvdm_bounds+ra_minx(a4),d5		;auf Breite des
		blt	.Error					;Listviews, solange

		move.l	a3,a0					;Text
		moveq	#-1,d3					;bis der Text passt
.lop1:		addq	#1,d3
		tst.b	(a0)+
		bne.s	.lop1
.charloop:	move.l	d7,a1
		move.l	a3,a0					;Text
		move.w	d3,d0
		jsr	_LVOtextlength(A6)
		cmp.w	d5,d0
		blt.s	.ok
		subq.w	#1,d3
		bra.s	.charloop
.ok:		move	d0,d4
		move.w	d3,d0
		move.l	a3,a0					;Text
		move.l	d7,a1
		jsr	_LVOtext(A6)

		move.l	d7,a1
		move	d6,d0
		move	d6,d1
		moveq	#0,d2
		jsr	_LVOsetabpendrmd(A6)

		move	lvdm_bounds+ra_minx(a4),d0
		add	d4,d0
		move	lvdm_bounds+ra_miny(a4),d1
		move	lvdm_bounds+ra_maxx(a4),d2
		move	lvdm_bounds+ra_maxy(a4),d3
		move.l	d7,a1
		jsr	_LVORectfill(a6)	;freien Platz nach dem Text lschen

		movem.l	(a7)+,d1-a6
		moveq	#LVCB_OK,d0
		rts

.Error:		movem.l	(a7)+,d1-a6
		moveq	#LVCB_Unknown,d0
		rts

*-----------------------------------------------------------------------------*
		ifeq	Executable
OpenGFX:	lea	Mygfxname2,a1
		move.l	4,a6
		moveq	#0,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,Puffer+Gfxbase
		tst.l	d0
		rts
Mygfxname2:	dc.b	"graphics.library",0
		even
		endc
*-------------------------- Variablenvereinbarungen --------------------------*
IDCMPTab:	IDCT	EID_SizeVerify,Return			;SizeVerify
		IDCT	EID_NewSize,ReSizeMyWindow		;NewSize
		IDCT	EID_RefreshWindow,RefreshMyWindow	;RefreshWindow
		IDCT	EID_MouseButtons,Return			;MouseButtons
		IDCT	EID_MouseMove,Return			;MouseMove
		IDCT	EID_GadgetDown,Return			;GadgetDown
		IDCT	EID_GadgetUp,GadUp			;GadgetUp
		IDCT	EID_ReqSet,Return			;ReqSet
		IDCT	EID_MenuPic,PullMenu			;MenuPic
		IDCT	EID_CloseWindow,Hide			;CloseWindow
		IDCT	EID_RawKey,Rawtaste			;RawKey
		IDCT	EID_ReqVerify,Return			;ReqVerify
		IDCT	EID_ReqClear,Return			;ReqClear
		IDCT	EID_MenuVerify,Return			;MenuVerify
		IDCT	EID_NewPrefs,Return			;NewPrefs
		IDCT	EID_DiskInserted,Return			;DiskInserted
		IDCT	EID_DiskRemoved,Return			;DiskRemoved
		IDCT	EID_WBenchMessage,Return		;WBenchMessage
		IDCT	EID_ActivateWindow,Return		;ActivateWindow
		IDCT	EID_InActivateWindow,Return		;InActivateWindow
		IDCT	EID_Deltamove,Return			;Deltamove
		IDCT	EID_Vanillakey,VanillaTaste		;Vanillakey
		IDCT	EID_IntuiTicks,Return			;IntuiTicks
		IDCT	EID_IDCMPUpdate,Return			;IDCMPUpdate
		IDCT	EID_MenuHelp,Return			;MenuHelp
		IDCT	EID_ChangeWindow,Return			;ChangeWindow
		IDCT	EID_GadgetHelp,Return			;GadgetHelp
		IDCT	EID_NoMessageTyp1,Return		;Kein MessageTyp
		IDCT	EID_NoMessageTyp2,Return		;Kein MessageTyp
		IDCT	EID_NoMessageTyp3,Return		;Kein MessageTyp
		IDCT	EID_NoMessageTyp4,Return		;Kein MessageTyp
		IDCT	EID_NoMessageTyp5,Return		;Kein MessageTyp


*----------------- Userprogrammspezifische Definitionen ---------------------*
WindowTags:
MyWA_Left:	dc.l	WA_Left,0
MyWA_Top:	dc.l	WA_Top,0
MyWA_MaxWidth:	dc.l	WA_MaxWidth,MaxWindowWidth
MyWA_MaxHeight:	dc.l	WA_MaxHeight,MaxWindowHeight
MyWA_MinWidth:	dc.l	WA_MinWidth,MinWindowWidth
MyWA_MinHeight:	dc.l	WA_MinHeight,MinWindowHeight
MyWA_InnerWidth:dc.l	WA_InnerWidth,WindowInnerWidth
MyWA_InnerHeight:dc.l	WA_InnerHeight,WindowInnerHeight
MyWA_IDCMP:	dc.l	WA_IDCMP,IDCMPFlags
MyWA_Flags:	dc.l	WA_Flags,WindowFlags
MyWA_Gadgets:	dc.l	WA_Gadgets,0
MyWA_NewLookMenus:dc.l	WA_NewLookMenus,1
MYWA_AutoAdjust:dc.l	WA_AutoAdjust,1
MyWA_PubScreenAdr:dc.l	WA_Pubscreen,0
		dc.l	0

AktionTab:	UPT	Return			;Return
		UPT	About
		UPT	Hide
		UPT	QuitUserProgramm
		UPT	ListView
		UPT	RefreshList

		UPT	Auswahl
		UPT	Top
		UPT	Botom
		UPT	Up
		UPT	Down
		UPT	PageUp
		UPT	PageDown
		UPT	Parent
		UPT	SetDir
		UPT	Links
		UPT	Rechts

		if	(*-AktionTab)/2-NrMaxNummern
	Du hast einen Eintrag vergessen
		endc


TastaturTabelle:dc.b	"R",NrRefreshList
		dc.b	"Q",NrQuit
		dc.b	$1b,NrHide
		dc.b	"H",NrHide
		dc.b	"A",NrAbout
		dc.b	13,NrAuswahl
		dc.b	"5",NrAuswahl
		dc.b	10,NrDown
		dc.b	11,NrUp
		dc.b	"8",NrUp
		dc.b	"2",NrDown
		dc.b	"7",NrTop
		dc.b	"1",NrBotom
		dc.b	"9",NrPageUp
		dc.b	"3",NrPageDown
		dc.b	8,NrParent
		dc.b	0
		even

*------ Tabelle, die auf die Tabellen der einzelnen MenuTabellen zeigt ------*
MenuNummernOverTab:dc.w	.Menu1-(MenuNummernOverTab+2)
.Menu1:		dc.w	NrRefreshList
		dc.w	NrDummy
		dc.w	NrAbout
		dc.w	NrHide
		dc.w	NrDummy
		dc.w	NrQuit

	*---------------- Definition fr MenuTitle --------------*
MyMenus:	dc.b	NM_Title	;GNM_Type
		dc.b	0		;GNM_Pad
LAN_Project:	dc.l	0 ProjectName.MSG	;GNM_Label
		dc.l	0		;GNM_CommKey
		dc.w	0		;GNM_Flags
		dc.l	0		;GNM_MutualExclude
		dc.l	0		;GNM_UserData

	*--------------- Definition fr RefreshList -------------*
		dc.b	NM_Item		;GNM_Type
		dc.b	0		;GNM_Pad
LAN_RefreshList:dc.l	RefreshList.MSG	;GNM_Label
LAN_RefreshListKey:dc.l	RefreshList.Key	;GNM_CommKey
		dc.w	0		;GNM_Flags
		dc.l	0		;GNM_MutualExclude
		dc.l	0		;GNM_UserData

	*----------------- Definition fr Linie -----------------*
		dc.b	NM_Item		;GNM_Type
		dc.b	0		;GNM_Pad
		dc.l	NM_Barlabel	;GNM_Label
		dc.l	0		;GNM_CommKey
		dc.w	0		;GNM_Flags
		dc.l	0		;GNM_MutualExclude
		dc.l	0		;GNM_UserData

	*---------------- Definition fr About ------------------*
		dc.b	NM_Item		;GNM_Type
		dc.b	0		;GNM_Pad
LAN_About:	dc.l	0 About.MSG	;GNM_Label
LAN_AboutKey:	dc.l	0 About.Key	;GNM_CommKey
		dc.w	0		;GNM_Flags
		dc.l	0		;GNM_MutualExclude
		dc.l	0		;GNM_UserData

	*---------------- Definition fr Hide -------------------*
		dc.b	NM_Item		;GNM_Type
		dc.b	0		;GNM_Pad
LAN_Hide:	dc.l	0 Hide.MSG	;GNM_Label
LAN_HideKey:	dc.l	0 Hide.Key	;GNM_CommKey
		dc.w	0		;GNM_Flags
		dc.l	0		;GNM_MutualExclude
		dc.l	0		;GNM_UserData

	*----------------- Definition fr Linie -----------------*
		dc.b	NM_Item		;GNM_Type
		dc.b	0		;GNM_Pad
		dc.l	NM_Barlabel	;GNM_Label
		dc.l	0		;GNM_CommKey
		dc.w	0		;GNM_Flags
		dc.l	0		;GNM_MutualExclude
		dc.l	0		;GNM_UserData

	*---------------- Definition fr Quit -------------------*
		dc.b	NM_Item		;GNM_Type
		dc.b	0		;GNM_Pad
LAN_Quit:	dc.l	0 Quit.MSG	;GNM_Label
		dc.l	Quit.Key	;GNM_CommKey
		dc.w	0		;GNM_Flags
		dc.l	0		;GNM_MutualExclude
		dc.l	0		;GNM_UserData

	*---------------- Keine weiteren Eintrge ---------------*
		dc.w	0

MenuTags:	dc.l	GTMN_Fullmenu,1
		dc.l	GTMN_NewLookMenus,1
		dc.l	0

*RefreshList.Key:dc.b	"R",0
RefreshList.Key:dc.b	"L",0
*About.Key:	dc.b	"A",0
*Hide.Key:	dc.b	"H",0
Quit.Key:	dc.b	"Q",0
		even




	*------------------ Gadget-Definitionen -----------------*
NewGadgetStrukturen:
ListViewGadget:	dc.w	AbstandLinks,AbstandOben,100,10		;Left,Top,Width,Height
		dc.l	0,0			;GadgetText,Font
		dc.w	NrListView		;GadgetNr
		dc.l	0,0,0			;Flags,VisualInfo,Userdata

NewGadgetTypes:	dc.w	ListView_Kind

NewGadgetTags:	dc.l	GTLV_ShowSelected,0
		dc.l	GTLV_CallBack,Listviewhook
		dc.l	0

ListViewTags:	dc.l	GTLV_Labels,0
		dc.l	GTLV_Selected,0
		dc.l	GTLV_MakeVisible,0
		dc.l	0

Listviewhook:	dcb.b	MLN_Size,0
		dc.l	Listview_hook
		dc.l	0
		dc.l	0

*-----------------------------------------------------------------------------*
LocaleTable:		dc.w	LNr_PM_Hide
			dc.l	0
LA_Hide:		dc.l	0
			dc.w	LNr_HideKey
			dc.l	0
LA_HideKey:		dc.l	0

			dc.w	LNr_PM_Quit
			dc.l	0
LA_Quit:		dc.l	0

			dc.w	LNr_PM_About
			dc.l	0
LA_About:		dc.l	0
			dc.w	LNr_AboutKey
			dc.l	0
LA_AboutKey:		dc.l	0

			dc.w	LNr_PM_Projecttitle
			dc.l	0
LA_Project:		dc.l	0

*			dc.w	LNrE_RefreshList
*			dc.l	RefreshList.MSG
*LA_RefreshList:		dc.l	0

			dc.w	LNr_PM_LoadModule
			dc.l	RefreshList.MSG
LA_RefreshList:		dc.l	0

*			dc.w	LNrE_RefreshListKey
*			dc.l	RefreshList.Key
*LA_RefreshListKey:	dc.l	0

			dc.w	LNrE_DLV_EasyTitle
			dc.l	MyEasyTitle
LA_DLV_EasyTitle:	dc.l	0

			dc.w	LNrE_DLV_About
			dc.l	AboutDLV.MSG
LA_DLV_About:		dc.l	0

			dc.w	0			;Und Tsch


	*----------------- Informationstexte ---------------------*
Kickstart20Path:dc.b	"CON:10/20/250/80/Dirlistviewer",0
WindowTitle:	dc.b	"Dirlistviewer ",0
MyMsgPortName:	dc.b	"EP_DirlistViewerPort",0
MyProzessName:	dc.b	"EP_DirlistViewer.1",0
MyEasyTitle:	dc.b	"DirlistViewer Message",0
MySpecialInfo:	dc.b	"For watching the actually directorylist",0
*ProjectName.MSG:dc.b	"Project",0
*RefreshList.MSG:dc.b	"RefreshList",0
RefreshList.MSG:	dc.b	"Load Module",0
*About.MSG:	dc.b	"About",0
*Hide.MSG:	dc.b	"Hide",0
*Quit.MSG:	dc.b	"Quit",0

AboutDLV.Msg:
 dc.b	"EaglePlayer DirListViewer",10
 dc.b	" 1993-96 Jan Blumenthal / Eagleeye of DEFECT",10
 dc.b	"------------------------------------------------",10,10
 dc.b	"This piece belongs to the Shareware Version of the Eagleplayer",10
 dc.b	"Package and may not be spread alone !!!",10,10
 dc.b	"you can reach the Author at the following Address:",10
 dc.b	"Jan Blumenthal",10
 dc.b	"Erich-Mhsam-Str. 34",10
 dc.b	"18069 Rostock",10
 dc.b	"Germany",0


OnlyRegistered.Msg:
 dc.b	"EaglePlayer DirListViewer",10
 dc.b	" 1993-96 Jan Blumenthal / Eagleeye of DEFECT",10
 dc.b	"------------------------------------------------",10,10
 dc.b	"This function is only available for registered users. Please send",10
 dc.b	"a donation of $20 to the authors. The registered users will get",10
 dc.b	"2 discs with the actuall Eagleplayer with KeyFile.",10,10
 dc.b	"You can reach the Authors at the following Address:",10,10
 dc.b	"Jan Blumenthal                 Henryk Richter",10
 dc.b	"Erich-Mhsam-Str. 34          Stephan-Jantzen-Ring 47",10
 dc.b	"18069 Rostock                  18106 Rostock",10
 dc.b	"Germany                        Germany",10
 dc.b	"Tel/Fax: +49 (0)381/83979     Tel: +49 (0)381/1208867",10,10
 dc.b	"E-Mail: buggs@baltic.e-technik.uni-rostock.de",0


	even

*----------------------------------------------------------------------------*
*--- Bss-Section und fr Debugger die Routinen zum ffnen der Libraries -----*
		include	"misc/MyUserHelp.i"
*----------------------------------------------------------------------------*
