*****************************************************************************
**                                                                         **
** Eagleplayer 2.04 - Main source code                                     **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
*****************************************************************************




*****************************************************************************
*
* Runtime behaviour with disabled LoadFast (Default):
*
* DTP_Check1	2200 Bytes gelesen, checken
*		eigene LoadRoutine wird benutzt
* DTP_Check2	komplettes File geladen, checken
*		Module liegt im Chip-Mem
* EP_Check3	2200 Bytes gelesen, checken
*		Module wird in Egal-Ram geladen
* EP_Check4	2200 Bytes gelesen, checken
*		Module wird in ChipRam geladen
*		(nur bei eingeschalteten LoadFast)
* EP_Check5	komplettes File in EgalRam geladen, checken
*		Module liegt im EgalRam
* EP_Check6	Wie Check1, wird aber erst nach EP_Check4-Aufruf erkannt,
*               vorgesehen fr Player, die mehrere Formate untersttzen, die
*               aber von anderen Playern besser beherrscht werden
*
* Runtime behaviour with enabled LoadFast:
*--------------------------------------------------------
* - DTP_Check1
* - EP_Check3
* - EP_Check4
* - EP_Check6
*	* Module is loaded to Chip memory, if required
* - EP_Check5
* - DTP_Check2
*	* Module is copied to ChipRAM if stored in FastRAM
*
*
* EP_Check4 erlaubt bei eingeschalteten LoadFast ein unbedingtes ChipRam-
* Loading.
*
*****************************************************************************
* Keyfile Tests:
*
*                 Used Globals: EPG_Wordreserved8   -> <>0 = Program corrupt
*                               EPG_Wordreserved7   ->   1 = Keyfile correct
*                               EPG_Wordreserved7+1 -> <>0 = Program corrupt
*                               EPG_Wordreserved7+1 -> <>0 = Program corrupt
*                               EPG_Wordreserved6   ->   0 = FindTaskDummy not
*                                                            done->Program
*                                                            corrupt
*
*
*                 Enignes:	Space-Scope crashes after 4 Minutes of
*                                           playing (kills EXECBase)
*                               Quadrascope after 5 Minutes (kills Dos.library
*                                ->_LVOOpen and _LVOinfo)
*                               Analyzer after 3 Minutes -> kills graphics.
*                               library _LVOBltbitmaprastport und _LVObltbitmap
*
*                               All registered Engines quit themselves
*                               when keyfile not installed !!
*
*
*                 All Points checked by any ANTI-CRACK Routine are 
*                 marked with "+-+-" followed by the Number of the Routine
*                 checking this !
*                 Check for 4.w,a6<->4,a6
*                       - Allocmenumem<->PRO_Initplayer
*			- Freedirmem<->ChangeEngine
*
*		  Check if keyon was changed: (Table of Offsets)
*		  KeyBeq1-KeyBeq8
*                 KeyBne1-KeyBne5
*                 KeyBeqTable
*                 KeyBneTable
*                 FindTaskDummy routine does the checking !
*
* Attention!!! All functions "tst.b keyon(a5)->BNE/BEQ" must not have
* ".s"/".b". Due to code size checking routines ".w" must be ensured!
*
*----------------------------------------------------------------------------*
*-----              ---------> EAGLEPLAYER V2.04 <-----------           -----*
*-----                           -------------                          -----*
*-----                                                                  -----*
*----- Program, Engine and extended player design developed by          -----*
*----- Eagleeye & Buggs of DEFECT                                       -----*
*-----                                                                  -----*
*----- Date:  2004/10/12                                                -----*
*----- Time:  22:00 Uhr                                                 -----*
*----------------------------------------------------------------------------*
Executable	= 1
BetaVersion	= 0
Betachar	= ``
Guru		= 1				;Reboot in case of hacked keyfile ?
Removecrashes	= 1				;Remove crashed engines

Master		= 0				;Is this the authors version ?



EP_Version	macro
		dc.b	"2.04"
		endm

EPM_Date	macro
		dc.b	"12.10.2004"
		endm
CD_V		= 2
CD_VP1		= 0
CD_VP2		= 3

EP_Revision	macro
		dc.b	"2.4"
		endm

CD_Tag		= 12
CD_Monat	= 10
CD_Jahr		= 2004


*----------------------------------------------------------------------------*
		incdir	"ep:include/"
		include	"Misc/EaglePlayer.i"
		*include	"Misc/EagleRipper.i"
		include	"Misc/EaglePlayerEngine.i"
		include	"Misc/EaglePlayerConverter.i"
		include	"Misc/EaglePlayerFormatloader.i"
		include	"Misc/EaglePlayerSamplesaver.i"
		include	"Misc/EaglePlayerRipper.i"



	*************************************
	**** EaglePlayer Include-Datei	 ****
	**** Datum: 09.01.1993 21:55 Uhr ****
	**** Konstanten,Variablen	 ****
	*************************************

	ifnd	_LVOWait
		include	"exec/exec_lib.i"
	endc
		include	"exec/lists.i"
		include	"exec/interrupts.i"
		include	devices/timer.i	
		include	libraries/timer_lib.i	

	ifnd	_LVOOpenWindow
	include	"intuition/intuition_lib.i"
	endc

	ifnd	_LVOText
	include	"graphics/graphics_lib.i"
	endc

	ifnd	_LVOOpenCatalogA
	include	"libraries/locale_lib.i"
	endc

	ifnd	_LVOLoadSeg
	include	"dos/dos_lib.i"
	endc

	ifnd	_LVOOpenDiskFont
	include	"libraries/DiskFont_lib.i"
	endc

	ifnd	_LVOCxMsgId
	include	"libraries/commodities_lib.i"
	endc

	ifnd	_LVOAllocASLRequest
	include	"libraries/asl_lib.i"
	endc

	ifnd	_LVORemoveAppMenuItem
	include	"libraries/wb_lib.i"
	endc

	ifnd	_LVOCreateGadgetA
	include	"libraries/gadtools_lib.i"
	endc

	ifnd	_LVOFindToolType
	include	"libraries/icon_lib.i"
	endc

	ifnd	_LVOPPCrunchBuffer
	include	"libraries/powerpacker_lib.i"
	endc

	ifnd	_LVOCmCheckCrunched
	include	"libraries/crm_lib.i"
	endc

	ifnd	_LVOXFDAllocBufferInfo
	include	"libraries/xfdmaster.i"
	include	"libraries/xfdmaster_lib.i"
	endc

	ifnd	_LVOOpenAmigaGuideAsyncA
	include	libraries/amigaguide_lib.i
	endc

	*------- Nun nur noch private Includes benutzen ------*
		incdir	"ep:src/"



UmbauTest	= 0				;Flag fr ModuleChange, im
						;Eagleplayer ohne Bedeutung
MemDrauf	= 2000				;Mem der zum Module dazuaddiert
						;werden soll
MinMenuSize	= 5000				;minimaler Mem fprs Dir
DefaultMenuSize	= 30000				;Mem frs Dirs
NewMenuMemSize	= 15000

MenuItemAnz	= 147		;150 mit EjectPlayers usw.
TextPufferSize	= 3000
ScrollPufferSize = 1000
ScrollArgsAnz	= 16
ScrollZahler	= 350				*Anzahl der 1/50 Sec
TextRequestArgsAnz = 16
Namenlange	= MaxFilenameSize
DirPufferSize	= MaxDirectorynameSize
PathPufferSize	= MaxDirectorynameSize+MaxFilenameSize
LHAPathPufferSize = MaxDirectorynameSize
HotKeyPufferSize= 100
Passwordpuffersize = 100
ModulesTitlePufferSize = MaxFilenameSize+70
MenuFontPufferSize = MaxFilenameSize
ModulesFontPufferSize = MaxFilenameSize
ArexxPufferSize	= 2000
Pubscreensize	= 100
MaxUmbauBytes 	= 200				;Anzahl der Worte in Puffer
Composerpuffersize = 100			;Size fr den Composerpuffer
PlBatchSize	= 20				;Anzahl der max mglichen Player
						;die gleichzeitig ladbar sind
DirAbortSize	= 10
MaxLoadFiles	= 100
MessagePuSize	= 300				;Size des Messagepuffers
FirstBytes	= 1024 ;2200			;Anzahl der Bytes bei Check 1

DefaultRasterLines = 8
MaxRasterLines	= 200
DefaultDBFLoops	= 400
MaxDBFLoops	= 20000

AnzInternalPlayers= 41			;Anzahl der internen Player
AnzMaxEngines	= 62
UPrg_Debugger	= -2			;Kennung Debugger
UPrg_FirstEntry	= -3			;Kennung ersten Eintrag suchen
UPrg_NewBatch	= -4			;Kennung fr neuen Batcheintrag

MinDeliVersion	= 10			;Version, ab die geladen werden soll
MaxDeliVersion	= 18			;Version die nicht mehr supported wird
MaxAnzeigeNr	= 38			;max. Anzahl von Buchstaben im
					;TextWindow
MaxErrorNr	= 56			;max Fehlernummer

KeyFileVersion	= 1
KeyPufferSize	= 1000

; fr Keyfile ?
MaxVorNameSize	= 30
MaxNachNameSize	= 30
MaxStreetSize	= 40
MaxOrtSize	= 40
MaxPlzSize	= 20
MaxCountrySize	= 20
MaxTelefonSize	= 20
MaxPseudoSize	= 20
MaxGroupSize	= 20
MaxDatumSize	= 20
MaxRegisterSize	= 20
MaxReihenSize	= 20


Mode_OldFile	= 1005
Mode_NewFile	= 1006

TagUserID	= $70ff4e75

ExecBase	MACRO
		if	executable
		move.l	4.w,a6
		else
		move.l	4,a6
		endc
		ENDM




	*-------------- Modes for Configurations ------------*
Mode_Arexx	equ	1		0
Mode_CLI	equ	2		1
Mode_Config	equ	4		2
Mode_ToolTypes	equ	8		3
*Mode_Engine	equ	16		4
Mode_Quit	equ	32

******************************************************************************
*		    Neuartige Arexx/StatusAuswerttabelle 		     *
* Ich hoffe, ich mu diesen Schei nicht noch mal umbauen !!		     *
* Die Statuskommandos fr UserProgramme und Player werden aufgrund anderer   *
* Datenzusammensetzung extra in Tabellen zusmamengefat			     *
******************************************************************************
		rsreset
EPRT_Proggy	rs.w	1		;ChangeProgramm rel. JumpTo oder NULL
EPRT_SaveConfig	rs.w	1		;Prg. zum Configsaven
EPRT_Status	rs.w	1		;Offs/Jump/Konst
EPRT_StrLNr	rs.w	1		;LocaleNr
EPRT_Flags	rs.b	1		;Config/ARexx/Cli/ToolTypes
EPRT_Args	rs.b	1		;Bit0-3=Arg1 Bit4-7=Arg2
EPRT_SSFlags	rs.b	1		;Save & StatusFlags
EPRT_TypeFlags	rs.b	1		;Type-Flags
EPRT_StatusChars rs.b	3		;Kennung fr Status "ply"
EPRT_Reserved	rs.b	1		;belegt bei Stringgadget
EPRT_LNr	rs.w	1		;Nummer des LocaleStrings fr Scroller
EPRT_SizeOf	rs.b	0


	*------------- SS-Flags /Save&StatusFlags --------------*
	* Diese Flags geben an, ob zu welcher Gruppe das Status *
	* Komando gehrt					*
EPRTSSF_Global	EQU	0			;Status fr Player 
EPRTSSF_Module	EQU	1			;Status fr Module 
EPRTSSF_Player	EQU	2			;Status fr Player 
EPRTSSF_Engine	EQU	3			;Status fr Engine
EPRTSSF_Other	EQU	4			;Statuskommando gehrt nicht 
						;zum Rest
EPRTSSB_Global	EQU	1<<EPRTSSF_Global	;Status fr Player 
EPRTSSB_Module	EQU	1<<EPRTSSF_Module	;Status fr Module 
EPRTSSB_Player	EQU	1<<EPRTSSF_Player	;Status fr Player 
EPRTSSB_Engine	EQU	1<<EPRTSSF_Engine	;Status fr Engine
EPRTSSB_Other	EQU	1<<EPRTSSF_Other	;Status fr Engine

EPSI_Global	EQU	"g"
EPSI_Module	EQU	"m"
EPSI_Player	EQU	"p"
EPSI_Engine	EQU	"e"
EPSI_UserPrg	EQU	"u"
EPSI_Other	EQU	"o"


	*----------------------- Type-Flags --------------------*
	* Diese Flags geben an, wie der Statuswert, z.B. aus    *
	* welchen Offsets von A5, gelesen werden kann		*
EPRTTF_String	EQU	0			;EPRT_Status ist Offs im Puffer
EPRTTF_Zahl	EQU	1			;EPRT_Status ist Offs im Puffer
EPRTTF_Zustand	EQU	2			;EPRT_Status ist Offs im Puffer
EPRTTF_Proggy	EQU	3			;EPRT_Status ist Offs ab JumpTo
EPRTTF_Byte	EQU	4			;Offset ist ein Byte gro
EPRTTF_Word	EQU	5			;Offset ist ein Word gro
EPRTTF_LongWord EQU	6			;Offset ist ein Langword gro
EPRTTB_String	EQU	1<<EPRTTF_String	;EPRT_Status ist Offs im Puffer
EPRTTB_Zahl	EQU	1<<EPRTTF_Zahl		;EPRT_Status ist Offs im Puffer
EPRTTB_Zustand	EQU	1<<EPRTTF_Zustand	;EPRT_Status ist Offs im Puffer
EPRTTB_Proggy	EQU	1<<EPRTTF_Proggy	;EPRT_Status ist Offs ab JumpTo
EPRTTB_Byte	EQU	1<<EPRTTF_Byte		;Offset ist ein Byte gro
EPRTTB_Word	EQU	1<<EPRTTF_Word		;Offset ist ein Word gro
EPRTTB_LongWord EQU	1<<EPRTTF_LongWord	;Offset ist ein Langword gro


	*------------------------ Argumenttypes -----------------*
	*- Gibt an, ob Arg1 angegeben sein mu und was frn Arg -*
EPRTAF_String1	EQU	0
EPRTAF_Zustand1	EQU	1
EPRTAF_Zahl1	EQU	2		;$Hex/Dez/%Dual
EPRTAF_Must1	EQU	3
EPRTAF_String2	EQU	4
EPRTAF_Zustand2	EQU	5
EPRTAF_Zahl2	EQU	6		;$Hex/Dez/%Dual
EPRTAF_Must2	EQU	7
EPRTAB_String1	EQU	1<<EPRTAF_String1
EPRTAB_Zustand1	EQU	1<<EPRTAF_Zustand1
EPRTAB_Zahl1	EQU	1<<EPRTAF_Zahl1
EPRTAB_Must1	EQU	1<<EPRTAF_Must1
EPRTAB_String2	EQU	1<<EPRTAF_String2
EPRTAB_Zustand2	EQU	1<<EPRTAF_Zustand2
EPRTAB_Zahl2	EQU	1<<EPRTAF_Zahl2
EPRTAB_Must2	EQU	1<<EPRTAF_Must2


	*------------ Global-RexxTabelleFlags ------------*
EPRTF_NoArexx	EQU	0
EPRTF_NoCli	EQU	1
EPRTF_NoConfig	EQU	2
EPRTF_NoToolTypes EQU	3
EPRTF_Key	EQU	4
EPRTF_Switch	EQU	5			*EPNr ist On/OFF -> EPRT ist
						*ein Prg,Status=A5Offst
					*nein	*SaveConfig =EPG_SomePrefs
EPRTF_StatusSave EQU	6			*Beim Configsaven wird der
						*Status gesaved
EPRTF_StringGadget	EQU	7			*Normalerweise Eingabe im
						*StringGadget
						*EPRT_Proggy=SpecialProggy
						*EPRT_SaveConfig=1.hchste Zahl
						*		 2.max. Strings
						*EPRT_OffsetImPuffer
						*	Byte,Longword ... im
						*	Status angegeben
						*EPRT_Reserved=Offset fr
						*LNr_LocaleStr im Gadget
						*bei Zahl mu die Merkadr
						*ein Langwort sein !!!
EPRTB_NoArexx	EQU	1<<EPRTF_NoArexx
EPRTB_NoCli	EQU	1<<EPRTF_NoCli
EPRTB_NoConfig	EQU	1<<EPRTF_NoConfig
EPRTB_NoToolTypes EQU	1<<EPRTF_NoToolTypes
EPRTB_Key	EQU	1<<EPRTF_Key
EPRTB_Switch	EQU	1<<EPRTF_Switch
EPRTB_StatusSave EQU	1<<EPRTF_StatusSave
EPRTB_StringGadget	EQU	1<<EPRTF_StringGadget

***************************************************************************
***************************************************************************
***************************************************************************
***************************************************************************





ReqDirOffset	= 6		;Req
ReqFileOffset	= 10		;Req
ReqPathOffset	= 14		;Req


*----------- Testroutinen ob modifizierter Eagleplayer vorliegt ------------*
*
*	KeyTest1: (vor wait)		getestet bei PlayModule:
*	KeyOn				-++-		ShowPlayers:
*	KeyOn				-++-		PlayModule:
*	KeyOn				-++-		JumpTo
*	KeyOn				-++-		LoadThis:
*	KeyOn				-++-		Arexx:
*
*
*
*



*------------------------- Konstanten fr Gadgets ---------------------------*
MaxVolume	= 64
MaxSpeed	= 25			;Wert -25 - 25


		*-------------- Screennotify-Library --------------*
_LVOAddCloseScreenClient	EQU	-$1e
_LVORemCloseScreenClient	EQU	-$24
_LVOAddPubScreenClient		EQU	-$2a
_LVORemPubScreenClient		EQU	-$30
_LVOAddWorkbenchClient		EQU	-$36
_LVORemWorkbenchClient		EQU	-$3c
		*--- Message sent to clients ---*
 Structure MyScreenNotifyMessage,0
	STRUCT	SN_Message,20			* ExecMessage
	ULONG	snm_Type			* READ ONLY!!
	APTR	snm_Value			* READ ONLY!!



_LVOFileRequest	= -84		;Req
_LVOTextRequest	= -174		;Req
_LVOPurgeFiles	= -$72		;Req

_LVOXpkPackerInfo	= -30
_LVOXpkExamine		= -36
_LVOXpkPack		= -42
_LVOXpkUnpack		= -48
_LVOXpkOpen		= -54
_LVOXpkRead		= -60
_LVOXpkWrite		= -66
_LVOXpkSeek		= -72
_LVOXpkClose		= -78
_LVOXpkQuery		= -84
_LVOCreateArgString	= -126


		*-------------- ReqTools ------------*
			Rsreset
			rs.b	-30
_LVOrtAllocRequestA	rs.b	-6
_LVOrtFreeRequest	rs.b	-6
_LVOrtFreeReqBuffer	rs.b	-6
_LVOrtChangeReqAttrA	rs.b	-6
_LVOrtFileRequestA	rs.b	-6
_LVOrtFreeFileList	rs.b	-6
_LVOrtEZRequestA	rs.b	-6
_LVOrtGetStringA	rs.b	-6
_LVOrtGetLongA		rs.b	-6
_LVOrtInternalGetPasswordA	rs.b	-6
_LVOrtInternalEnterPasswordA	rs.b	-6
_LVOrtFontRequestA	rs.b	-6
_LVOrtPaletteRequestA	rs.b	-6
_LVOrtReqHandlerA	rs.b	-6
_LVOrtSetWaitPointer	rs.b	-6
_LVOrtGetVScreenSize	rs.b	-6
_LVOrtSetReqPosition	rs.b	-6
_LVOrtSpread		rs.b	-6
_LVOrtScreenToFrontSafely rs.b	-6

_RT_LeftOffset		EQU	$80000004
_RT_TopOffset		EQU	$80000005
_RT_PubScrName		EQU	$80000006
_RT_Window		EQU	$80000001
_RT_Underscore		EQU	$8000000B
_RT_TextAttr		EQU	$8000000F
RTEZ_ReqTitle		EQU	$80000014
RTEZ_Flags		EQU	$80000016

*--------------------------------- AmigaGuide -------------------------------*
    STRUCTURE NewAmigaGuide,0
	APTR		nag_Lock	; Lock on the document directory
	APTR		nag_Name	; Name of document file
	APTR		nag_Screen	; Screen to place windows within
	APTR		nag_PubScreen	; Public screen name to open on
	APTR		nag_HostPort	; Application's ARexx port name
	APTR		nag_ClientPort	; Name to assign to the clients ARexx port
	APTR		nag_BaseName	; Base name of the application
	ULONG		nag_Flags	; Flags
	APTR		nag_Context	; NULL terminated context table
	APTR		nag_Node	; Node to align on first (defaults to Main)
	LONG		nag_Line	; Line to align on
	APTR		nag_Extens	; Tag array extens
	APTR		nag_Client	; Private! MUST be NULL
    LABEL NewAmigaGuide_SIZEOF

HTF_Load_Index	= 1
HTF_LoadAll	= 2
HTF_Cache_Node	= 4
HTF_CACHE_DB	= 8
HTF_UnIQUE	= 16
HTF_NoActivate	= 32




*--------------------------------------------------------------------------*
			rsreset
Menu			rs.b	0
EPHM_NextMenu		rs.l	1
EPHM_LeftEdge		rs.w	1
EPHM_TopEdge		rs.w	1
EPHM_Width		rs.w	1
EPHM_Height		rs.w	1
EPHM_Flags		rs.w	1
EPHM_MenuName		rs.l	1
EPHM_FirstItem		rs.l	1
EPHM_JazzX		rs.w	1
EPHM_JazzY		rs.w	1
EPHM_BeatX		rs.w	1
EPHM_BeatY		rs.w	1
			rs.l	1	;ab Kick2.0+
EPHM_LocaleNr		rs.w	1
EPHM_SizeOf		rs.b	0

			rsreset
EPMI_NextItem		rs.l	1
EPMI_LeftEdge		rs.w	1
EPMI_TopEdge		rs.w	1
EPMI_Width		rs.w	1
EPMI_Height		rs.w	1
EPMI_Flags		rs.w	1
EPMI_MutualExclude	rs.l	1
EPMI_ItemFill		rs.l	1
EPMI_SelectFill		rs.l	1
EPMI_Command		rs.b	1
EPMI_KludgeFill00	rs.b	1
EPMI_SubItem		rs.l	1
EPMI_NextSelect		rs.w	1
			rs.l	1	;ab Kick2.0+
EPMI_ITFrontPen		rs.b	1	;I-TextStrukture
EPMI_ITIBackPen		rs.b	1
EPMI_ITDrawMode		rs.b	1
EPMI_ITKludgeFill	rs.b	1
EPMI_ITLeftEdge		rs.w	1
EPMI_ITTopEdge		rs.w	1
EPMI_ITITextFont	rs.l	1
EPMI_ITIText		rs.l	1
EPMI_ITNextText		rs.l	1
EPMI_EPNr		rs.w	1
EPMI_LNr		rs.w	1
EPMI_SizeOf		rs.b	0



*--------------------- CLI-Errors -----------------------------------*
			rsreset
			rs.b	1
Cli_Err_Exists		rs.b	1
Cli_Err_Signals		rs.b	1
Cli_Err_Dos		rs.b	1
Cli_Err_GFX		rs.b	1
Cli_Err_Intuition	rs.b	1

**-------------------------------------------------------------------------*


		rsreset
EPKF_Identifier rs.b	6		;dc.b	"CrM!",0,0,0,0
EPKF_DeFileSize rs.l	1		;DeFileSize
EPKF_CrFileSize	rs.l	1		;Crunched FileSize
EPKF_Struct	rs.l	1		;Offset zur folgenden Structure-Start
					;+2000+(23434*2)
EPKF_AllChkSum	rs.w	1		;Chksumme des Keyfiles
EPKF_AllDecodeK	rs.b	1		;Befehle der Decodierung
EPKF_AllDecode1	rs.b	1		;Entschlsselung fr next Bytes
EPKF_AllDecode2	rs.b	1		;Entschlsselung fr next Bytes
EPKF_AllDecode3	rs.b	1		;Entschlsselung fr next Bytes
EPKF_AllDecode4	rs.b	1		;Entschlsselung fr next Bytes
EPKF_CodeStart	rs.b	1		;Beginn der Verschlsselung


	*-----------------------------------------------------------------*
	*------ Jetzt wrden `n paar Strings kommen oder auch nicht ------*
	*-----------------------------------------------------------------*


	*----------------------- Checksummenheader -----------------------*
	*--- Alle Checksummen nochmal zusammengefat und extra codiert ---*
	*-----------------------------------------------------------------*
		rsreset
EPKF_ChkKey1	rs.w	1		;ChkSum of Verschlsselung 1
EPKF_ChkKey2	rs.w	1		;ChkSum of Verschlsselung 2
EPKF_ChkKey3	rs.w	1		;ChkSum of Verschlsselung 3


	*---------- Entschlsselung 1. fr die nchsten Bytes -------------*
EPKF_V1DecodeK	rs.b	1		;Befehle der Decodierung
EPKF_V1Decode1	rs.b	1		;Entschlsselung fr next Bytes
EPKF_V1Decode2	rs.b	1		;Entschlsselung fr next Bytes
EPKF_V1Decode3	rs.b	1		;Entschlsselung fr next Bytes
EPKF_V1Decode4	rs.b	1		;Entschlsselung fr next Bytes
		rs.b	1		;unused
EPKF_KVersion	rs.w	1		;KeyFileVersion
EPKF_NachNameChk rs.w	1		;CheckSumme des Namens
EPKF_EPVersion	rs.w	1		;min. Eagleplayer-Version
EPKF_VornameOffs rs.w	1		;Offset zu VornameString
EPKF_RegNr	rs.l	1		;Nr des Registrierten Users
EPKF_CountryChk	rs.w	1		;CheckSumme des Landes
EPKF_DateOffs	rs.w	1		;Offset to DatumsString
EPKF_VNameSize	rs.w	1		;Size of VornameString
EPKF_GroupChk	rs.w	1		;Checksumme fr Group
EPKF_PseudoSize	rs.w	1		;Size of PseudoString
EPKF_Empty	rs.l	1		;unused (Wert egal)

EPKF_V1ChkSum	rs.w	1		;ChkSumme fr Header-KeyFiles

	*------------- Entschlsselung 2. fr die nchsten Bytes ----------*
EPKF_V2DecodeK	rs.b	1		;Befehle der Decodierung
EPKF_V2Decode1	rs.b	1		;Entschlsselung fr next Bytes
EPKF_V2Decode2	rs.b	1		;Entschlsselung fr next Bytes
EPKF_V2Decode3	rs.b	1		;Entschlsselung fr next Bytes
EPKF_V2Decode4	rs.b	1		;Entschlsselung fr next Bytes
EPKF_V2Empty	rs.b	1
EPKF_OrtChk	rs.w	1		;Chk des Ortes
EPKF_CountrySize rs.w	1		;Size of Countrystring
EPKF_PlzSize	rs.w	1		;Size of PostleitzahlString
EPKF_RegNr2	rs.l	1		;Nr des Registrierten Users
EPKF_OrtSize	rs.w	1		;Size of StreetString
EPKF_PseudoOffs	rs.w	1		;Offset zu Pseudo
EPKF_VornameChk	rs.w	1		;Checksumme des Vornamens
EPKF_NachNameSize rs.w	1		;Size of Nachname
EPKF_GroupOffs	rs.w	1		;Offset zu Group-KeyStart
EPKF_TelefonChk	rs.w	1		;Checksumme from TefefonString
EPKF_CountryOffs rs.w	1		;Offset to Country-String
EPKF_DateSize	rs.w	1		;Size des Datums

EPKF_V2ChkSum	rs.w	1		;ChkSumme fr Entschl. 1-KeyFiles


	*------------ Entschlsselung 3. fr die nchsten Bytes -----------*
EPKF_V3Unused	rs.b	1
EPKF_V3DecodeK	rs.b	1		;Befehle der Decodierung
EPKF_V3Decode1	rs.b	1		;Entschlsselung 1
EPKF_V3Decode2	rs.b	1		;Entschlsselung 2
EPKF_V3Decode3	rs.b	1		;Entschlsselung 3
EPKF_V3Decode4	rs.b	1		;Entschlsselung 4
EPKF_OrtOffs	rs.w	1		;Offset to Ortstring
EPKF_GroupSize	rs.w	1		;Size fr Group
EPKF_PseudoChk	rs.w	1		;Checksumme of Pseudo
EPKF_PlzOffs	rs.w	1		;Offset to Plz-String
EPKF_StreetSize	rs.w	1		;Size of StreetString
EPKF_DateChk	rs.w	1		;Checksumme des Datums
EPKF_NachNameOffs rs.w	1		;Offset zu VornameString
EPKF_StreetChk	rs.w	1		;Checksumme der Strae
EPKF_RegNr3	rs.l	1		;Nr des Registrierten Users
EPKF_TelefonSize rs.w	1		;Size of TefefonString
EPKF_PlzChk	rs.w	1		;Checksumme of PostleitzahlString
EPKF_StreetOffs	rs.w	1		;Offset to Streetstring
EPKF_TelefonOffs rs.w	1		;Offset to TefefonString

EPKF_Reserved1	rs.w	1		;Must 0, wenn entcodiert
EPKF_Reserved2	rs.w	1		;Must 0, wenn entcodiert
EPKF_Reserved3	rs.w	1		;Must 0, wenn entcodiert
EPKF_Reserved4	rs.w	1		;Must 0, wenn entcodiert
EPKF_Reserved5	rs.w	1		;Must 0, wenn entcodiert

EPKF_V3ChkSum	rs.w	1		;ChkSumme fr Entschl. 2-KeyFiles

EPKF_SizeOF	rs.b	0


*------------------ Macrodefinitionen fr Changetester ---------------------*
* 1. Offset zu nchster Testroutine
* 2. Offset zu Teststring
* 3. Offset zu Guru-Routine
* 4. Kennungen der Testaktionen
KeyCheck1	=	$568496
KeyCheck2	=	$27656
KeyCheck3	=	$8899646
KeyCheck4	=	$9986

KEYTABM	MACRO
		dc.l	KeyCheck1+(\1-*-14)
		dc.l	KeyCheck2-(\2-Return)
		dc.l	KeyCheck3-(\3-Return)
	ENDM

KEYTABM2 MACRO
		dc.w	KeyCheck4-\1
	ENDM



*-------------------- Defines for checking keyfile and program modifications ---------------------*
KTBA5	=	$4a2d		;tst.b (4)
KTBA4	=	$4a2c		;tst.b (4)
KTBA3	=	$4a2b		;tst.b (4)
KTBA2	=	$4a2a		;tst.b (4)
KTBA1	=	$4a29		;tst.b (4)
KTBA0	=	$4a28		;tst.b (4)

KTWA5	=	$4a6d		;tst.w (4)
KTWA4	=	$4a6c		;tst.w (4)
KTWA3	=	$4a6b		;tst.w (4)
KTWA2	=	$4a6a		;tst.w (4)
KTWA1	=	$4a69		;tst.w (4)
KTWA0	=	$4a68		;tst.w (4)

KTLA5	=	$4aad		;tst.l (4)
KTLA4	=	$4aac		;tst.l (4)
KTLA3	=	$4aab		;tst.l (4)
KTLA2	=	$4aaa		;tst.l (4)
KTLA1	=	$4aa9		;tst.l (4)
KTLA0	=	$4aa8		;tst.l (4)

KCBA5	=	$0c2d		;cmp.b (6)
KCBA4	=	$0c2c		;cmp.b (6)
KCBA3	=	$0c2b		;cmp.b (6)
KCBA2	=	$0c2a		;cmp.b (6)
KCBA1	=	$0c29		;cmp.b (6)
KCBA0	=	$0c28		;cmp.b (6)

KCWA5	=	$0c6d		;cmp.w (6)
KCWA4	=	$0c6c		;cmp.w (6)
KCWA3	=	$0c6b		;cmp.w (6)
KCWA2	=	$0c6a		;cmp.w (6)
KCWA1	=	$0c69		;cmp.w (6)
KCWA0	=	$0c68		;cmp.w (6)

KCLA5	=	$0cad		;cmp.l (8)
KCLA4	=	$0cac		;cmp.l (8)
KCLA3	=	$0cab		;cmp.l (8)
KCLA2	=	$0caa		;cmp.l (8)
KCLA1	=	$0ca9		;cmp.l (8)
KCLA0	=	$0ca8		;cmp.l (8)

KBE	=	$6700		;beq.w (4)
KBN	=	$6600		;bne.w (4)
KBO	=	$6500		;blo.w (4)
KBT	=	$6d00		;blt.w (4)
KBG	=	$6e00		;bgt.w (4)
KBH	=	$6200		;bhi.w (4)
KBS	=	$6400		;bhs.w (4)

KDW	=	13		;dc.w  (2)

* EPNr_LastInternal * 33 = Puffer fr Str-Strings + /K,
* EPNr_LastInternal * 4  = Puffer fr Args
* EPNr_LastInternal * 2  = Puffer fr Strnummern
CLITemplatesize	= EPNr_LastInternal*33+EPNr_LastInternal*4+EPNr_LastInternal*2+12
CliTemplateOffset EQU	EPNr_LastInternal*4+EPNr_LastInternal*2+8
CliArgOffset	EQU	EPNr_LastInternal*2+4

*---------------------------------------------------------------------------*
 STRUCTURE EPDIR,0
	STRUCT	EPD_Identifier,8	;"EAGLEDIR"
	LONG	EPD_EPVersion		;min. Eagleplayerversion
	LONG	EPD_Dirs		;Anz der Dirs
	LONG	EPD_Files		;Anz der Files
	LONG	EPD_FirstDir		;Offset to FirstDirname-EPDIR
	LONG	EPD_FirstFile		;Offset to FirstFileName-EPDIR
	LONG	EPD_Flags		;Flags zum EPDir
	LONG	EPD_EPDirVersion
	WORD	EPD_Type		;Type des EPDirs
	LONG	EPD_Special1
	LONG	EPD_Special2
	LONG	EPD_Special3
	LONG	EPD_Reserved1
	LONG	EPD_Reserved2
	LONG	EPD_Reserved3
	LABEL	EPD_SIZEOF

* bei der ersten Version des EPDirs ist EPD_Flags der letzte Eintrag *
* Version 2: ist erweitert

EPDF_HideAll		EQU	0
EPDF_ShowDirNames	EQU	1
EPDF_NotSorted		EQU	2	;=1, die Namen sind nicht sortiert

EPDB_HideAll		EQU	1<<EPDF_HideAll
EPDB_ShowDirNames	EQU	1<<EPDF_ShowDirNames
EPDB_NotSorted		EQU	1<<EPDF_NotSorted

EPDT_Directory		EQU	0
EPDT_LHAArchive		EQU	1

*---------------------------------------------------------------------------*


	*---------------- Types fr Createfilespuffer -----------------*
EPCFP_ReqLib		EQU	1
EPCFP_ReqToolsLib	EQU	2
EPCFP_ArgList		EQU	3
EPCFP_EPDir		EQU	4
EPCFP_UserList		EQU	5
EPCFP_DirScan		EQU	6
EPCFP_LHAScan		EQU	7
EPCFP_Arexx		EQU	8

	*--------- Flags fr Textrequester & Stringrequest ---------*
EPTRF_Zahl		EQU	0		* only Stringrequest
EPTRF_String		EQU	1		* only Stringrequest
EPTRF_Center		EQU	2
EPTRF_TestTimout	EQU	3
EPTRF_Invisible		EQU	4		* only Stringrequest

EPTRB_Zahl		EQU	1<<EPTRF_Zahl
EPTRB_String		EQU	1<<EPTRF_String
EPTRB_Center		EQU	1<<EPTRF_Center
EPTRB_TestTimout	EQU	1<<EPTRF_TestTimout
EPTRB_Invisible		EQU	1<<EPTRF_Invisible


	*----------- Listetypen ---------*
LTY_Eagleplayer	EQU	1
LTY_Delitracker	EQU	2
LTY_APlayer	EQU	3
LTY_BananaPlay	EQU	4
LTY_Hippoplayer	EQU	5
LTY_Empy	EQU	6			= Multiplayer
LTY_Smartplay	EQU	7
LTY_Archive	EQU	8
LTY_Melgu	EQU	9
LTY_DASMod	EQU	10


			rsreset
MEP_Flags		rs.b	1	;Struktur der MenuItemTabelle
MEP_TCode		rs.b	1
MEP_ActionNr		rs.b	1
MEP_LocaleNr		rs.b	1
MEP_SizeOf		rs.b	0


*------------------ Macro-Definitionen fr diverse Tabellen ------------------*
*-----------------------------------------------------------------------------*
*----------------------------- Macro-Definitionen ----------------------------*
*-----------------------------------------------------------------------------*


	*------------- Macro fr Menus -----------*
MIN		MACRO
		dc.b	\1			;Flags
		dc.b	\2			;TastaturCode
		dc.b	\3			;ActionNr
		dc.b	\4-LNr_PM_ProjectTitle	;LocaleNr
		ENDM

	*-------------- Macro fr GetLocaleString ------------*
LA0		MACRO
		IFEQ	Executable
		move.l	d0,-(a7)
		move.w	#\1,d0
		jsr	A5GetLocaleStringA0(a5)
		move.l	(a7)+,d0
		ELSE
		jsr	A5GetLocaleStringA0(a5)
		dc.w	\1
		ENDC
		ENDM

LA1		MACRO
		IFEQ	Executable
		move.l	d0,-(a7)
		move.w	#\1,d0
		jsr	A5GetLocaleStringA1(a5)
		move.l	(a7)+,d0
		ELSE
		jsr	A5GetLocaleStringA1(a5)
		dc.w	\1
		ENDC
		ENDM

LA2		MACRO
		IFEQ	Executable
		move.l	d0,-(a7)
		move.w	#\1,d0
		jsr	A5GetLocaleStringA2(a5)
		move.l	(a7)+,d0
		ELSE
		jsr	A5GetLocaleStringA2(a5)
		dc.w	\1
		ENDC
		ENDM

LA3		MACRO
		IFEQ	Executable
		move.l	d0,-(a7)
		move.w	#\1,d0
		jsr	A5GetLocaleStringA3(a5)
		move.l	(a7)+,d0
		ELSE
		jsr	A5GetLocaleStringA3(a5)
		dc.w	\1
		ENDC
		ENDM

LD0		MACRO
		IFEQ	Executable
		move.w	#\1,d0
		jsr	A5GetLocaleStringD0(a5)
		ELSE
		jsr	A5GetLocaleStringD0(a5)
		dc.w	\1
		ENDC
		ENDM

JTM		MACRO
		dc.l	\1-JumpTo
		ENDM

JRM		MACRO
		dc.l	\1-JumpReturn
		ENDM

UPTM		MACRO
		dc.l	\1-(UnterProgTab-4)
		ENDM



	*---------------- Struktur AppMessage ---------------*
		rsreset
am_Message	rs.b	20		;standard message structure
am_Type		rs.w	1		;message type
am_UserData	rs.l	1		;application specific
am_ID		rs.l	1		;application definable ID
am_NumArgs	rs.l	1		;# of elements in arglist
am_ArgList	rs.l	1		;the arguements themselves
am_Version	rs.w	1		;will be AM_VERSION
am_Class	rs.w	1		;message class
am_MouseX	rs.w	1		;mouse x position of event
am_MouseY	rs.w	1		;mount y position of event
am_Seconds	rs.l	1		;current system clock time
am_Micros	rs.l	1		;current system clock time
am_Reserved	rs.b	8		;avoid recompilation
am_End		rs.b	0




	ifne epg_sizeof/4*4<>epg_sizeof
	error
	endc



NPT_BYTE	MACRO
\1		EQU	SOFFSET-\2
SOFFSET		SET	SOFFSET-\2
		ENDM

NPT_WORD	MACRO
\1		EQU	SOFFSET-\2*2
SOFFSET		SET	SOFFSET-\2*2
		ENDM

NPT_LONG	MACRO
\1		EQU	SOFFSET-\2*4
SOFFSET		SET	SOFFSET-\2*4
		ENDM





*-----------------------------------------------------------------------------*
*---------------- Vereinbarungen fr den negativen Merkpuffer ----------------*
*-----------------------------------------------------------------------------*
SOFFSET		SET		0
		NPT_Byte	NegEagleplayerJumpTabelle,-ENPP_SizeOf
		NPT_Word	MenuInitOk,1
		*NPT_Byte	MenuItemPuffer,MenuItems*Size
		NPT_Word	LocalePuffer,(LNr_LastExternal+1)
		NPT_Word	hey,-LNr_LastInternal

		STRUCT	DirPuffer, -DirPufferSize			;Puffer fr Dir		(Req.Library)
		STRUCT	DirPuffer2, -DirPufferSize			;Puffer fr Dir		(Req.Library)
		STRUCT	SaveDirPuffer, -DirPufferSize			;Puffer fr SaveDir	(Req.Library)
		STRUCT	PlayersDir, -DirPufferSize			;Dir fr add Players
		STRUCT	EngineDir, -DirPufferSize			;Dir fr AddEngines
		STRUCT	DeletingDir, -DirPufferSize			;Dir fr Deleting File
		STRUCT	InstrDir, -DirPufferSize			;Dir fr Instrumente
		STRUCT	EagleplayerDir, -DirPufferSize			;Dir fr den Eagleplayer
		STRUCT	ComposerPuffer, -Composerpuffersize		;Authornamenpuffer
		STRUCT	TextRequestTags, -30				;+StringGadget
		STRUCT	PubScreenName, -Pubscreensize			;Puffer fr PubscreenName
		STRUCT	PubScreenName2, -Pubscreensize			;Puffer fr PubscreenName
		STRUCT	ModulesTitlePuffer, -ModulesTitlePufferSize	;Title fr Modules-PullDownMenu-Name
		STRUCT	ListPuffer, -DirPufferSize			;Puffer fr Liste
		STRUCT	LHADirPuffer, -DirPufferSize			;fr TestAufsteigendArchive

		NPT_Byte	NegPufferEnd,0


*-----------------------------------------------------------------------------*
*------------------------------ Buffer definitions ---------------------------*
*-----------------------------------------------------------------------------*



		*----------------------------------------------*
		*--------------- Positive Part ----------------*
		*----------------------------------------------*
		rsreset
		rs.b	EPG_SizeOf

Infoblock	rs.b	260		;Infoblock (<- /4teilbare Adresse)
					;First-Ladeblock des Modules
DiskInfoblock	rs.b	260		;Alter DiskInfoblock
MessagePuffer	rs.b	MessagePusize	;Speicher fr Message (max 100)

WBTitlePuffer	rs.b	256		;TextPuffer fr WBScreenLeiste


	*------------------ Fr Scroller ------------------*
ScrollPuffer	rs.b	ScrollPufferSize
ScrollANewText	rs.l	1		;Zhler fr neuen ScrollText
ScrollLastLNrAdr rs.l	1 		*Adr des Strings, der als letztes bei
ScrollArgs	rs.l	ScrollArgsAnz
SegmentFileName	rs.l	1
					*createPlayName erzeugt wurde

TextRequestArgs rs.l	TextRequestArgsAnz

PathPuffer	rs.b	PathPufferSize	;Puffer fr Path   (frei fr Phade)
LHAPathPuffer	rs.b	LHAPathPufferSize ;Puffer fr LHAPath

*UserBatchPufferNr rs.l	1		;Mu davor liegen
*UserBatchPuffer
*		rs.l	AnzMaxEngines	 ;--- oberes beachten Adr + Size
*		;rs.l	AnzMaxEngines*2 ;--- oberes beachten Adr + Size

Pro_Temp1	rs.l	128
Pro_Temp2	rs.l	128

TextPuffer	rs.b	TextPufferSize	;Adresse fr den Info-Text
TextPufferEnd	rs.b	0

	*---------- Datenbereich fr Timer.device Untersttzung -----------*
TimerDevice	rs.l	1
TimerPort	rs.b	MP_Size
TimerInt	rs.b	IS_Size
TimerRequest	rs.b	IOTV_Size
Timer_Lasttime	rs.l	2		;EClock TimerVal Struktur
Timer_Timerval	rs.l	1		;aktuelle Zeit
TimerOpen	rs.b	1		;ob Timer.device geffnet werden konnte
TimerIntFlag	rs.b	1		;0=off,1=on,2=stopped

	*---------- Vereinbarungen fr benutze Player ---------*
EP_UPSStructure	rs.b	UPS_SizeOf
		rs.b	UPS_SizeOf*4	;Sicherheit !!!
InternPlayersStructs rs.b	AnzInternalPlayers*(EPPl_Sizeof+NamenLange+4)

FilePuffer	rs.b	Namenlange+2	;Puffer fr den Namen	(Req.Library)
FilePufferReq	rs.b	Namenlange+2	;kann immer gendert werden
LHAFilePuffer	rs.b	Namenlange+2	;Puffer fr den Namen
SaveFilePuffer	rs.b	Namenlange+2	;Puffer fr Save-Namen
PlayersFile	rs.b	Namenlange+2	;NamenPuffer fr AddPlayer
EngineFile	rs.b	Namenlange+2	;NamenPuffer fr AddEngines
DeletingFile	rs.b	Namenlange+2	;NamenPuffer fr Delete File
AppFilePuffer	rs.b	Namenlange+2	;Puffer fr den Namen bei AppWindowLoad
*ConfigFileName	rs.b	Namenlange+2	;Puffer fr ConfigNamen
FontName	rs.b	Namenlange+2	;Name des benutzten Fonts
FontName2	rs.b	Namenlange+2	;Name des ladenen Fonts
TitleNamePuffer	rs.b	Namenlange+2	;Puffer fr Namen des geladene Files
TitleNamePuffer2 rs.b	Namenlange+2	;Puffer fr Namen des geladene LFFiles
EPG_SongnamePuffer rs.b	Namenlange+2

SoundsystemPuffer rs.b	Namenlange+2	;Puffer fr Soundsystemnamen
SongNamePuffer	rs.b	Namenlange+70	;Puffer fr Songnamen

NotifyRequest	rs.b	48
EM_ProjectMenu	rs.b	EPHM_SizeOF	*dc.l	EM_CommandMenu
EM_CommandMenu	rs.b	EPHM_SizeOf	*ds.b	26
EM_EngineMenu	rs.b	EPHM_SizeOf	*dc.w	LNr_PM_ProjectTitle
EM_SpecialMenu	rs.b	EPHM_SizeOF
EM_MenuTitleSize	EQU	4*EPHM_SizeOf

KeyVornamePuffer rs.b	MaxVornameSize
KeyNamePuffer	rs.b	MaxNachNameSize
KeyStreetPuffer	rs.b	MaxStreetSize
KeyOrtPuffer	rs.b	MaxOrtSize
KeyPlzPuffer	rs.b	MaxPlzSize
KeyCountryPuffer rs.b	MaxCountrySize
KeyTelefonPuffer rs.b	MaxTelefonSize
KeyPuffer	rs.b	KeyPufferSize


PasswordPuffer	rs.b	Passwordpuffersize
AmigaguideStruct rs.b	NewAmigaGuide_SIZEOF
SaveConfigPuffer rs.b	2		;\ zusammen lassen !!!!!!!!!!!!!!!!!!!
ArexxPuffer 	rs.b	ArexxPufferSize	;/ ReturnTexte fr Arexx-Meldungen  !!
EmptyPuffer	rs.l	10		;Puffer fr Nullen(mu immer leer sein)

EgalMerkZelle	rs.l	1

UB_MerkZahler	rs.w	1
UB_MerkPuffer	rs.w	MaxUmbauBytes+10

HotKeyPuffer	rs.b	HotKeyPufferSize
MenuFontPuffer	rs.b	MenuFontPufferSize
ModulesFontPuffer rs.b	ModulesFontPufferSize
ScrollfontPuffer rs.b	ModulesFontPufferSize
SelectFontPuffer rs.b	Namenlange+2
MenuFont	rs.b	8
ModulesFont	rs.b	8
ScrollFont	rs.b	8
ModulesfontUsed	rs.b	8		;Font der RefreshMenu genutzt wird
ModulesFontHeight rs.w	1
ModulesFontAdr	rs.l	1

CliError	rs.w	1		;Errorkennung beim Starten
MerkDMA		rs.w	1		;DMA

OpenStartWin	rs.w	1		;Soll Window beim Start geffnet werden
KeyDiffi4	rs.w	1
AppIconHandle	rs.l	1		;Handle fr AppIcon
AppItemHandle	rs.l	1		;Handle fr AppItem
AppIconObject	rs.l	1
DummyAdr	rs.l	1		:MemAdr fr Pseudo-Allocmem
MainCatalog	rs.l	1
EngineCatalog	rs.l	1
PlayerCatalog	rs.l	1
EPG_CrmBase	rs.l	1		;CRM-Library Basisaddi
EPG_ScreenNotifyBase rs.l 1
EPG_AmigaGuideBase rs.l 1
HelpHandle	rs.l	1
ScreenNotifyPort rs.l	1
ScreenNotifyHandle rs.l 1

FormatLoad_Tags	rs.l	1
FormatLoad_PlayerAdr rs.l 1

EngineVerbotPtr	rs.l	1
EngineVerbotSize rs.l	1
RealTimeOut	rs.l	1		;e.g. EPG_TimeOut, blo unter Berck
					;sichtigung von TimeMode
KeyDiffi1	rs.l	1
SaveMerkArg3	rs.l	1		;Merkadresse fr Save (Phadadresse)

XPK_CrunchMode	rs.w	3
XPK_ErrBuf	rs.b	80		;ErrorBuffer fr XPK
XPK_ExamineBuf	rs.b	94
		rs.b	20

KeyReturn	rs.l	1
Commoditiesport	rs.l	1
NotifyPort	rs.l	1
ImmerEins_2	rs.l	1		;Eins fr FirstKeyDecoding
Itemhandle	rs.l	1
BrokerFehler	rs.l	1
Brokerstruct	rs.l	1
BrokerPort	rs.l	1
AppItemPort	rs.l	1
KeyDiffi2	rs.l	1
MyBroker	rs.b	26		;nb_sizeof


	*--------------------- Fr Surface ----------------*
WindowOffen	rs.l	1

SetMenuNew	rs.w	1		;statt ResetMenuStrip -> SetMenuStrip
MenuAdr		rs.l	1		;Adr des MenuStrips
MenuOn		rs.w	1
MenuDisabled	rs.w	1
MenuVerbot	rs.w	1		;kein Men setzen/berechnen
NoWait		rs.w	1		;kein Warten auf EngineMsg
ClearMouseVerbot rs.w	1		;den Waitpointer zurcksetzen verbieten
OnWaitMouse	rs.w	1		;Waitmouse an/aus
EnableVerbot	rs.w	1		;enablen verboten
RefreshMenuVerbot rs.w	1		;kein Men setzen/berechnen
PlSelected	rs.l	1		;fr DelPlayer
UpdatePlayerList rs.l	1		;Soll die Playerliste berprft werden
WinMerk		rs.l	1		;War window mal offen
UMG_UPrgSAdr	rs.l	1		;UPrgS_Adr des Gui oder 0 -> no window
UMG_Tags	rs.l	1		;		-++-
UMG_WinHandle	rs.l	1
UMG_AppStrukAdr	rs.l	1
UMG_SignalBits	rs.l	1
UMG_InterruptBits rs.l	1
UMG_InterruptAdr rs.l	1

Old_UMGNr	rs.l	1		;Adr der UPrgS_Struktur
SendeNummer	rs.l	1

UPlG_WinHandle	rs.l	1
CFP_PathArrayPtr rs.l	1

*UPG_UPrgSAdr	rs.l	1
*UPG_Tags	rs.l	1
*UPG_WinHandle	rs.l	1
*UPG_AppStrukAdr	rs.l	1
*
*UUG_UPrgSAdr	rs.l	1
*UUG_Tags	rs.l	1
*UUG_WinHandle	rs.l	1
*UUG_AppStrukAdr rs.l	1
*
*ULG_UPrgSAdr	rs.l	1
*ULG_Tags	rs.l	1
*ULG_WinHandle	rs.l	1
*ULG_AppStrukAdr	rs.l	1


	*------------------------------------------------------------*
StringSize	rs.l	1		;StringSize fr add User
CR_Adr		rs.l	1		;CrunchHelpAdr
CR_Size		rs.l	1		;CrunchHelpSize
CrA_Error	rs.l	1		;Wurde Crunch aborted

CrunchPosition	rs.l	1		;rechte pos der Crunchanzeige

Key_Chksumme	rs.w	1		;Checksumme der 1 Structure des K-Files
Key_Struct	rs.l	1		;Adresse der EPKF_Structure
KeyAdr		rs.l	1		;Adresse des Key-Files
KeySize		rs.l	1		;Size des KeyFiles
FaultRegs	rs.l	4		;Argumentenpuffer fr SmallModule
KeyUserNr	rs.l	1		;UserNummer

KeyDiffi3	rs.l	1
FR_Title	rs.l	1
FR_Dir		rs.l	1
FR_Filename	rs.l	1
FR_WinHandle	rs.l	1
FR_Flags	rs.l	1

	*----------- Unterprogramme des Eagleplayers ----------*
A5ClearCache		rs.w	3		;jmp x.l
A5ClearMouse		rs.w	3
A5ClearMouse2		rs.w	3
A5WaitMouse		rs.w	3
A5OpenLib		rs.w	3
A5CloseLib		rs.w	3
A5HelpMe		rs.w	3
A5Help2			rs.w	3
A5HelpLink2		rs.w	3
A5Documentation2	rs.w	3
A5GibArg		rs.w	3
A5CloseHelp		rs.w	3
A5CloseWorkbenchLib	rs.w	3
A5SendeAllScrollMessage	rs.w	3
A5SendeAllPrintMessage	rs.w	3
A5ScrollNew		rs.w	3
A5ScrollNewText		rs.w	3
A5ScrollNewFehler	rs.w	3
A5MakeCorrectText	rs.w	3
A5SetCiaBTimer		rs.w	3
A5CloseCiaBTimer	rs.w	3
A5FreeOldModule		rs.w	3
A5PrintText		rs.w	3
A5FileRequest		rs.w	3
A5FileRequest2		rs.w	3
A5FontRequest		rs.w	3
A5MakeCorrectDir	rs.w	3
A5SetTimer		rs.w	3
A5SaveMem		rs.w	3
A5HexDez		rs.w	3
A5HexDez2		rs.w	3
A5SetOldDir		rs.w	3
A5IOErr			rs.w	3
A5Delay			rs.w	3
A5Delay3		rs.w	3
A5LoadFile		rs.w	3
A5TestAufDisabledKeys	rs.w	3
A5LoadFile2		rs.w	3
A5LoadThis		rs.w	3
A5NewExtLoad		rs.w	3
A5LoadModule		rs.w	3
A5LoadStructModule	rs.w	3
A5LoadEngineSegment	rs.w	3
A5AllesRaus		rs.w	3
A5TitleAufbau		rs.w	3
A5Iconify		rs.w	3
A5AddApps		rs.w	3
A5RemoveApps		rs.w	3
A5SetWindowZustand	rs.w	3
A5OpenMainWindow	rs.w	3
A5CloseMainWindow	rs.w	3
A5PlaySampleEndAudstruct rs.w	3
A5PlaySampleRestoreModule rs.w	3
A5GetStartSong		rs.w	3

A5FindTag		rs.w	3
A5FindTag2		rs.w	3
A5CallUp		rs.w	3
A5CallUp3		rs.w	3
A5UserCallUp3		rs.w	3
A5UserCallUp4		rs.w	3
A5UserCallUp5		rs.w	3
A5UserFindTag		rs.w	3
A5DecodeD0		rs.w	3
A5DeletePlayer2		rs.w	3
A5DeleteAll2		rs.w	3
A5InsertInList		rs.w	3
A5SetTableLocale	rs.w	3
A5JaGuru		rs.w	3
A5LoadDefaultGui	rs.w	3
A5Engine		rs.w	3

A5CopyText		rs.w	3
A5CopyText2		rs.w	3
A5CopyFileName		rs.w	3
A5CopyLoadedFileToNew	rs.w	3
A5KeyChangeInit		rs.w	3
A5StringCopy		rs.w	3
A5StringCopy2		rs.w	3
A5CopySendText		rs.w	3
A5TestAufArchive	rs.w	3
A5TestAufsteigendArchive rs.w	3
A5TestJumpDir		rs.w	3
A5SetDirJumpPtr		rs.w	3
A5KEYRoutinenTester	rs.w	3
A5InitCommodity		rs.w	3
A5CloseCommodity	rs.w	3
A5ClearMenuStrip	rs.w	3
A5SetMenuStrip		rs.w	3
A5EnableMenu		rs.w	3
A5DisableMenu		rs.w	3
A5InitMenus		rs.w	3
A5FreeMenus		rs.w	3
A5RefreshMenu		rs.w	3
A5SaveNachT		rs.w	3
A5ClearEngineZustand	rs.w	3
A5SetEngineZustand	rs.w	3
A5SetMutalExclude	rs.w	3
A5InitScreenNotify	rs.w	3
A5EndScreenNotify	rs.w	3
A5ScreenNotifyMessage	rs.w	3
A5EnableAll		rs.w	3
A5DisableAll		rs.w	3
A5NervRequest1		rs.w	3
A5NervRequest2		rs.w	3

A5GetMenuItemAdr	rs.w	3
A5GuiChanged		rs.w	3

*A5ModuleChanged	rs.w	3
*A5DirChanged		rs.w	3

A5MakeEPGSongName	rs.w	3
A5KeyTestReturn		rs.w	3
A5SendeOneMessage	rs.w	3
A5SendeAllMessage	rs.w	3
A5SendeAllMessage2	rs.w	3
A5WaitUserPorts		rs.w	3
A5TestUserAndQuit	rs.w	3
A5DeleteEngine		rs.w	3
A5DeleteAllEngines	rs.w	3
A5FreeAllEngineStructs	rs.w	3
A5WriteEnginePrefsToUPrg rs.w	3
A5FindEUSStruct		rs.w	3
A5FindUserStruct	rs.w	3
A5InsertEngineNodeName	rs.w	3
A5InsertPlayerInList	rs.w	3
A5GetPlayerName		rs.w	3
A5FindFreeUserNr	rs.w	3
A5ClearUserMessage	rs.w	3
A5InsertStructAdr	rs.w	3
A5InsertModulesList	rs.w	3
*A5RefreshUserMenu	rs.w	3
A5FindFileName		rs.w	3
A5TextRequest		rs.w	3
A5CopyTextToArexxPuffer rs.w	3
A5LoadDirIn		rs.w	3
A5LoadPlayerBatch	rs.w	3
A5SortAmplifiers	rs.w	3
A5LoadStartEngines	rs.w	3
A5CheckLoadVerbot	rs.w	3
A5InitEngineVerbot	rs.w	3
A5EndEngineVerbot	rs.w	3
A5FindUserASCStruct	rs.w	3

A5NervRequestCounter	rs.w	3

A5KillLastSchraeg	rs.w	3
A5CreateFilesPuffer	rs.w	3
A5RescanDir		rs.w	3
A5FreeDirPuffer		rs.w	3
A5FreeConfigDir		rs.w	3
A5LoadProgrammModule	rs.w	3
A5LoadNeededPlayer	rs.w	3
A5UpdateDeliEmu		rs.w	3
A5CreateLoadPath	rs.w	3
A5CreateDirAusPath	rs.w	3
A5FreeLFModule		rs.w	3
A5AllocMem		rs.w	3
A5DecodeD02		rs.w	3
A5ClearSS_Struct	rs.w	3


A5ClearTextWindow	rs.w	3
A5GetFileName		rs.w	3
A5GetFileName2		rs.w	3
A5GetFileName3		rs.w	3
A5GetPassword		rs.w	3
A5GetStringGadget	rs.w	3
A5BerechStringSize	rs.w	3
A5BerechStringSize2	rs.w	3
A5ScreenToFront		rs.w	3
A5WindowToFront		rs.w	3
A5KeyTestAufEngine	rs.w	3
A5GetPassword2		rs.w	3
A5LoadProgrammList	rs.w	3
A5LoadList		rs.w	3

A5AddAbortGadget	rs.w	3
A5KeyFehler		rs.w	3
A5GetAbortMsg		rs.w	3
A5RemoveAbortGadget	rs.w	3

A5TestAufFaults		rs.w	3

A5Key_DecKeyFile1	rs.w	3
A5Key_DecKeyFile2	rs.w	3
A5ClearProTemps		rs.w	3
A5Key_DecKeyFile3	rs.w	3
A5FreeAudio		rs.w	3
A5Key_EndC		rs.w	3
A5AllocAudio		rs.w	3
A5Key_Verl11		rs.w	3
A5Key_Chk1		rs.w	3
A5CopyMemQuick		rs.w	3
A5Key_Verl12		rs.w	3
A5Key_Verl13		rs.w	3

A5LoadAppIcon		rs.w	3
A5FreeAppIcon		rs.w	3

A5StartInterrupt	rs.w	3
A5StopInterrupt		rs.w	3
A5StopInterrupt2	rs.w	3
A5StartNotify		rs.w	3
A5EndNotify		rs.w	3
A5KeyTestNext		rs.w	3
A5SetFileReqMode	rs.w	3
A5Return		rs.w	3
A5FreeOldFileReq	rs.w	3

A5TestAufCrmFile	rs.w	3

	*--------- New
A5GetLocaleStringA0	rs.w	3
A5GetLocaleStringA1	rs.w	3
A5GetLocaleStringA2	rs.w	3
A5GetLocaleStringA3	rs.w	3
A5GetLocaleStringd0	rs.w	3
A5GetLocaleString	rs.w	3
A5FirstLocaleInit	rs.w	3

A5InitCrunchDisplay	rs.w	3
A5FillCrunchDisplay	rs.w	3
A5RemoveCrunchDisplay	rs.w	3

A5ActivateAUser		rs.w	3
A5DeActivateAUser	rs.w	3
A5GetMainWindowHandle	rs.w	3
A5GetMainWindowTags	rs.w	3
A5PlayerChecker		rs.w	3
A5UserCallUp		rs.w	3
A5StrCmp		rs.w	3
A5StrCmp2		rs.w	3
A5StrCmp3		rs.w	3
A5DezHex		rs.w	3
A5GetNumber		rs.w	3
A5ParentDir		rs.w	3
A5ParentArchiveDir		rs.w	3
A5ExtractArchiveEntry	rs.w	3
A5ExtractFirstArchiveEntry	rs.w	3
*A5ExtraktFirstLHA	rs.w	3
A5Warten		rs.w	3
A5WartenReplayPort	rs.w	3
A5CopyMessage2		rs.w	3
A5LoadAutoDir		rs.w	3
A5LoadEngine		rs.w	3
A5WaitForStartMsg	rs.w	3
A5LoadPlayer		rs.w	3
A5LoadPlayer2		rs.w	3
A5SetOldDir2		rs.w	3
*A5RefreshModulesMenu	rs.w	3
*A5SetUserConfig	rs.w	3
A5SaveConfigText	rs.w	3
A5CopyZahlToArexxPuffer	rs.w	3
*A5ADDEngine2		rs.w	3
*A5AddUser2		rs.w	3
A5LoadOnePlayer		rs.w	3
A5AllocMem2		rs.w	3
A5FreeMem		rs.w	3
A5FreeCliStruct		rs.w	3
A5EndSound		rs.w	3
A5InitSound		rs.w	3
A5FreeLoadModule	rs.w	3
A5FreeLoadModule2	rs.w	3
A5LadeLFModule		rs.w	3
A5LFModuleLoaded	rs.w	3
A5CreatePlayname	rs.w	3
A5AllesRaus2		rs.w	3
A5DeleteAllOther2	rs.w	3
A5ClearSegment		rs.w	3
*A5EngineSetName		rs.w	3
*A5AddEngine3		rs.w	3
A5DecodeStruct2		rs.w	3
A5FreePlayers		rs.w	3
A5AllocMenuMem		rs.w	3
A5FreeDirMem		rs.w	3
A5FindPlayerStruct	rs.w	3
A5LoadPlayers2		rs.w	3
A5PrintSongNr		rs.w	3
A5LCopyText		rs.w	3
A5CloseDatei		rs.w	3
A5AllocModuleMem	rs.w	3
A5CheckSoundsys		rs.w	3
A5FreeExtLoad		rs.w	3
A5PrintDisabled		rs.w	3
A5DeleteAllOtherPlayers	rs.w	3
A5EPP_SetVolume		rs.w	3
A5EPP_SetBalance	rs.w	3
A5EPP_SetVoices		rs.w	3
A5SetVoicesinEPG	rs.w	3
A5DecodeNames		rs.w	3
A5PrintBytes		rs.w	3
A5CopyToInfoB		rs.w	3
A5CopyToInfoB2		rs.w	3
A5ClrInfoBuffer		rs.w	3
A5CrunchMem		rs.w	3
A5PPDecrunch		rs.w	3
A5LHDecrunch		rs.w	3
A5StoneDecrunch		rs.w	3
A5Exploding		rs.w	3
A5DecrunchPack		rs.w	3
A5DecrunchSTC404	rs.w	3
A5LoadSegment		rs.w	3
A5Rippen		rs.w	3
A5DeleteTFile		rs.w	3
A5DeleteTFile2		rs.w	3
A5RenameTFile		rs.w	3
A5NextModule		rs.w	3
A5PrevModule		rs.w	3
A5SucheStruktur		rs.w	3
A5GetModuleNr		rs.w	3
A5InitPlayer		rs.w	3
A5CalcDuration		rs.w	3
A5DisabledKeys		rs.w	3
A5HoleLock		rs.w	3
A5FreeLock		rs.w	3
A5FreeMultiPuffer	rs.w	3
*A5AddUserSetAnz	rs.w	3
A5KeyTester1		rs.w	3
A5CopyMessage		rs.w	3
A5ChangeEngine		rs.w	3
A5FreeCommandStruct	rs.w	3
A5CloseWin		rs.w	3
A5OpenOldEngines	rs.w	3
A5LoadConfig		rs.w	3
A5GetArgs		rs.w	3
A5InitLoadConfig	rs.w	3
A5ChangeA6_2		rs.w	3
A5ClearTickCounter	rs.w	3
A5Changea6_3		rs.w	3

A5CommodityMsg		rs.w	3
A5ArexxMsg		rs.w	3
A5AppMessage		rs.w	3

A5EngineMessage		rs.w	3
A5TestValidEPNr		rs.w	3
A5KommandoAuswertung	rs.w	3
A5KommandoAuswertung2	rs.w	3
A5JumpTo		rs.w	3
A5LoadParentDir		rs.w	3
A5AboutTextRequester	rs.w	3
*A5SetErrorText		rs.w	3


A5RoutEnd		rs.b	0





	*------------------ Ende der Kommunikation ---------------------*
CloseStackAdr	rs.l	1		;Stackadr fr Quit

Crmd0Add	rs.l	1		;HelpAdr zur Codierung von CRM-Decrunch
OverwriteArgs	rs.l	1

KeyFault	rs.l	1		;Keyfile has a fault

Rexx_Message	rs.l	1
FirstArg	rs.l	1
TestBits	rs.l	1			;Bits die angeben, unter wel.
						;Mode getestet wird (CLI/Arexx)
Arexx_Error	rs.l	1		;Fehler aufgetreten ??? 0=nein
;StatusKommando	rs.l	1		;Adr des nchsten Arguments

CrmDecrunch	rs.l	1		;Wo ist die DecrunchRoutine

MerkGanse	rs.w	1
REXX_MsgPort	rs.b	80

UPrg_Result1	rs.l	1		;Returnwert fr EPT_Arg1
UPrg_Result2	rs.l	1		;Returnwert fr EPT_Arg2
UPrg_ReturnStruct rs.l	1		;Pointer to Return-Structure
UPrg_Struct	rs.l	1		;Pointer to Structure
UPrg_WinHandle	rs.l	1		;Pointer to Winhandle
UserType	rs.l	1		;Wert der in UM_Result steht

KeyCrSize	rs.l	1		;VergleichsSize des KeyFiles

GetInfoAdr	rs.l	1		;Adr der Module-Info-Struktur
FirstEngine	rs.l	1
NewEngineSegment rs.l	1
StartEngineNr	rs.w	1
LastEngine	rs.l	1
LoadEngineArgs	rs.l	1
LE_WinX		rs.w	1
LE_WinY		rs.w	1
LE_Flags	rs.w	1
LE_Special	rs.l	1
LE_Special2	rs.l	1
LE_Special3	rs.l	1

KeyFaultWait	rs.l	1		;Keyfile has a fault

OldVolume	rs.w	1
OldLoadAdr	rs.l	1
PlayerPath	rs.l	1
MenuTiefe	rs.l	1		;Tiefe des Menus
KeyDisabled	rs.l	1
FirstPlayer	rs.l	1

PlayerList	rs.b	LH_SIZE
EngineList	rs.b	LH_SIZE
ModulesList	rs.b	LH_SIZE

PlayerPubScreen		rs.l	1
PlayerVisualInfo	rs.l	1
PlayerScreenZahler	rs.l	1

LPM_Counter	rs.l	1

PlayerAnz	rs.w	1
OldPlayerAnz	rs.w	1
MerkAdr		rs.l	1		;Nur fr kurze ZwischenSpeicher
TextFont	rs.l	1		;Adr der geffneten Font-Structure
TextFont2	rs.l	1		;Adr der neuen geffneten Font-Structure
BalkenAuf	rs.w	1		;Auflsung des PropBalkens
LastItemNr	rs.l	1		;Anzahl der Eintrge bei MultiSelect
LastItemUsed	rs.l	1		;Wieviele Eintrge sind schon benutzt
FindTagStackAdr	rs.l	1		;StackAdr bei Aufruf von FindTag
KeyCrmHelp	rs.l	1		;Kennung fr CRM-Files

EPP_PlAdr	rs.l	1		;Adr fr PlayerBatchDatei
EPP_PlSize	rs.l	1		;Size fr PlayerBatchDatei

Message		rs.l	1		;StartMessage der Workbench
Segment		rs.l	1		;SegmentAdr meines Prozesses
ListMemAdr	rs.l	1		;Adr der ProgrammListe  (MELGU-Liste)
ListMemSize	rs.l	1		;Gre der ProgrammListe
MenuMemAdr	rs.l	1
MenuMemSize	rs.l	1
MenuMemZeiger	rs.l	1
MenuMemZeigerItem rs.l	1		:Ende of ItemMenu


EPInitLoadConfigLock rs.l 1
FirstMenuPtr	rs.l	1		*das erste Langwort ist der Ptr auf den
					*nchsten Block
					*das zweite Langwort ist die AllocSize
					*das dritte Langwort ist die Current
					*Adr in diesem Puffer
					*das vierte Langwort ist die Restsize


UserConfigNr	rs.l	1		;Wieviele User-Configs angegeben
ConfigAdr	rs.l	1		;Adresse der Configdatei
ConfigSize	rs.l	1		;Size der -++-
ConfigPfadAdr	rs.l	1		;Adresse des Configpfades
ConfigPfadSize	rs.l	1		;Size der -++-
ConfigError	rs.l	1		;Error im String
EagleIconAdr	rs.l	1
KommandoLine	rs.l	1		;Liniennummer, in der der Fehler auft.
KommandoMode	rs.l	1		;mode von -++- (Cli/Config/Tooltypes)
KommandoStringAdr rs.l	1
KommandoBuch	rs.l	1

JumpToMerk	rs.l	8
LOP_Dir		rs.l	1

TempNP		rs.l	1		;nur benutzt, wenn Amplifier sortiert
					;werden mssen, sonst frei

		ifeq	Executable
OldASMLock	rs.l	1
		endc

*--------------------------------------------------------------------------*
PlayerNameAnz	rs.l	1		;Anzahl der geladenen PlayerBatch-Player
PlayerNameAdrs	rs.l	PlBatchSize*2	;Namanadr der geladenen Player
					;Sowie Adressen der TagListen
LoadNameAdr	rs.l	2		;NamenAdr des benutzten Players
					;sowie Adresse der TagList
LastLoadedTagList rs.l	1		;Adr des Tagliste beim Playerladen


LHAFileRequestAddr rs.l	1		;Hilfsmerkzelle fr Filerequest
LHAFileRequestByte rs.l	1		;damit auch bei Modules:jamesbrown.LHA
					;ein Filereq in Modules: geht

PPAdr		rs.l	1		;Adresse wo PPDatei liegt
PPSize		rs.l	1		;PP-Lnge beim Laden
XPK_ErrorKennung rs.l	1

MinSubSong	rs.w	1
MaxSubSong	rs.w	1
ConfigSongNr	rs.l	1

CliArgs		rs.l	1
CliArgStruct	rs.l	1

KeyDummy	rs.l	1		;Wert total egal

Am_Merk		rs.l	1		;Merkzelle fr ArexxMultiSelect
UnterwegsNr	rs.w	1		;Wieviele Messages sind unterwegs
EngineAnz	rs.l	1		;Highest Nr of Engine
LoadedEngines	rs.l	1		;gel. Engines
CloseMainWindowMSG	rs.l	1	;Message bei USClass_Deactivate
BatchNewUserDa	rs.w	1		;Ist die first MSG des neuen Users da ???
SS_StructAdr	rs.l	1		;Adr der Analyzer-Struktur
MyTaskAdr	rs.l	1		;Task-Adresse
StatusModuleInfo rs.l	1		;Moduleinfotaglist bei Status
OldWBDirLock	rs.l	1		;WB-DirLock
Start_Dosbase	rs.l	1		;Dosbase bei WB-Start
MyPubScreen	rs.l	1		;Adr des PubScreens
FremdPubScreen	rs.l	1		;Adr des Textrequester-PubScreens
XPKHandle	rs.l	1		;XPK-FileHandle
LHStruckAdr	rs.l	1		;Adr der LH_Struktur
SampleCounter	rs.l	1		;Anz der Samplereservierungen

ARegisterTable	rs.l	7		;Argumentspeicher fr AboutRegister
PlAddMerk	rs.l	1		;MerkAdr ob geladener Player vorher
					;angewhlt war
SignalBits	rs.l	1		;Signalbits aller Ports
SongEndBits	rs.l	1		;Signalbits fr Songende
MerkZelle	rs.l	1		;Merkzelle (immer vernderbar)

LastModulesEintrag rs.l	1		;Adr des Letzen Menupunktes im Menu
LoadErrorNr	rs.l	1		;ErrorNr beim Laden
SSDirAdr	rs.l	1		;Adr des Dirnamens beim Saven
					;fr Zurcksetzen des Dirnamens
FileNameAdr	rs.l	1		;Adresse des aktuellen Namens
Eintrage	rs.l	1		;Eintrge bei CreateFilesPuffer
SortEinAdr	rs.l	1
FilesFarbe	rs.w	1
DirsFarbe	rs.w	1


SecondsZahler	rs.l	1		;Aktueller Stand der Sekunden
SecondsZahler2	rs.l	1		;Aktueller Stand der Sekunden
MicrosZahler	rs.l	1		;Aktueller Stand der MSekunden

TextReqSecondsZahler	rs.l	1	;Aktueller Stand bei TextReqstart
TextReqMicrosZahler	rs.l	1	;Aktueller Stand bei TextReqstart
TextReqSecondsZahler2	rs.l	1	;Aktueller Stand bei TextReqend
TextReqMicrosZahler2	rs.l	1	;Aktueller Stand bei TextReqend

SpeedSize	rs.w	1		;Speed -25 --- 25
ExtLoad_LastDirAdr rs.l	1
MT_InstrKennung:rs.w	1
MT_LInstrKennung:rs.w	1
ConvertedSize	rs.l	1
STExtraMem	rs.l	1
Pro_SaveAdr	rs.l	1		;fr Saven
Pro_SaveSize	rs.l	1		;fr Saven
SavePackInd	rs.l	1		;fr Saven
Ori_Data	rs.l	1
KriptCode	rs.l	1
Unic_Temp	rs.l	1
SampleData	rs.l	1
SampleDataSize	rs.l	1
SamplePointer	rs.l	1

ReqToolsAdr2	rs.l	1
ReqToolsAdr11	rs.l	1

SampleStructure	rs.b	EPS_SizeOf
PlayerAdrSample	rs.l	1
PS_AmplTaglist	rs.l	1
PS_AudioStruct	rs.l	1
PS_StructAdr	rs.l	1
PS_BalanceOn	rs.w	1
PS_VolumeOn	rs.w	1
PS_VoicesOn	rs.w	1
PlaySampleStruct rs.l	1
SampleSaverTags rs.l	1

ModulesHori	rs.w	1		;Horizontale Position des derzeitigen
ModulesRechts	rs.w	1		;Menubreite des Anzeigefensters
ModulesVerti	rs.w	1		;Vertikale Position des Menus
MaxModulesHori	rs.w	1		;Max Screen-Breite fr MenuAufbau


MenuFileName	rs.l	1		;Adr des Namens (der als letztes aus
					;dem Pull-Down-Menu aufgerufen wurde
LoadedMenuFileName rs.l	1		;Adr des Filenamens im PD-Puffer
					;der geladen wurde, sinnvoll fr das
					;Laden von Modulen aus Archiven

OldDir		rs.l	1		;Lock des alten Directories
OldPlDir	rs.l	1		;Lock des alten Directories
File		rs.l	1		;Adr des Files
FileSizeNeu	rs.l	1		;Gre des Files
RippStruct	rs.l	1
RippStart	rs.l	1
RippSize	rs.l	1
SchonGerippt	rs.w	1
XPKHelpAdr	rs.l	1		;XPKHelpMemAdr
XPKHelpSize	rs.l	1		;XPKHelpMemSize
FileLoadSize	rs.l	1		;LoadSize des Files
LoadFileBytes	rs.w	1		;Kennung fr Load-Routine
MerkLoadFileBytes rs.w	1		;SucherheitsKenn fr LoadR bei EXTLoad
LoadPlayerAdr	rs.l	1		;Adr der TagStruktur des zu lad. Moduls
LoadPlayerStart	rs.l	1		;Adr der Struktur des zu ladenen Moduls
LoadFilePath	rs.l	1		;Adr des Paths
LoadFileName	rs.l	1		;Adr des zu ladenen FileNamens
LoadFileMem	rs.l	1		;Eigenschaften des Speichers
LoadPlayerKennung rs.w	1		;Kennung ob Player oder CustomFile
LoadPlayerExists rs.w	1		;Kennung ob Player bereits existiert
LoadPlayerSKenn	rs.w	1		;Kennung fr CheckSoundsys
LoadPlayerVersion rs.l	1		;VersionsNummer des zu ladenen Players
LoadplayerError rs.l	1		;Error beim Laden des Player/Engines
TFilePtr	rs.l	1		;Adr des Filenamens bei Check1_3-Patch
TDirPtr		rs.l	1		;Adr des Dirnamens bei Check1_3-Patch

ArchiveEngineNr rs.w	1		;Nummer der Engine, die das Archiv er-
					;kannt hat.

DT_AmplifierstructSize rs.l	1
DT_AmplifierStruct	rs.l	1
DT_NoteStruct		rs.l	1

DT_AddValue		rs.l	1 	;falls bei DT_FreeListData Nummer
				; nicht gefunden, jeweils eins draufaddieren,
				;damit bei InitPlayer mit moveq #0,d0 und
				;GetListData das Richtige rauskommt

LoadedEngineAnz	rs.l	1
ScanPlayerAnz	rs.l	1
NervCounter	rs.l	1


DirJumpPtr	rs.l	1		;Ptr fr max Mutterverzeichnis mit /

RndSeed		rs.l	1		;Merkezellen fr PlayRandomModule
Rndseed2	rs.l	1
RandomVersuche	rs.l	1		;Versuche beim PlayRandom

StatusLong	rs.l	2		;StatusKommando
StatusVoiceNummer rs.l	1		;Nummer der Voice
StatusNextArg	rs.l	1		;NextArg fr Status

EPDir_SMemAdr	rs.l	1		;SaveMemAdr
EPDir_SMemSize	rs.l	1		;SaveMemSize
EPDir_Ptr	rs.l	1		;Adr des Dirnamens beim Dir laden
EPDir_Files	rs.l	1		;Anzahl der Mods beim EPDir
EPDir_Dirs	rs.l	1		;Anzahl der Dirs im EPDir
ArchiveError	rs.l	1
ListPathAdr	rs.l	1		;Adr des Pfades in der Liste

LastLoadError	rs.l	1		;Letzte Fehlermeldung beim Laden
ExtErrNumber	rs.l	1		;Error-Meldung bei ExtLoad

SendeAllCommand	rs.l	1
SaveHandle	rs.l	1		;Save-Handle fr Config-Saven

LFPuffer	rs.l	MaxLoadFiles*4	;MerkPuffer fr zu ladenen Files
LFNummer	rs.l	1
LFExtraMem	rs.l	2
LFFormatName	rs.l	1
LFSamplePtr	rs.l	1
LFStartSong	rs.l	1

MDPuffer	rs.l	MaxLoadFiles*4	;MerkPuffer fr geladene Files
MDNummer	rs.l	1
MDExtraMem	rs.l	2
MDFormatName	rs.l	1
MDSamplePtr	rs.l	1
MDStartSong	rs.l	1

PlayerAdr	rs.l	1		;Adr des Players fr playendes Modul
LastModuleNr rs.w	1		;Nr des zuletzt gel. Modules

FirstModulesEintrag rs.l 1		;Adr der ersten File-Struktur


	*------ Variablen fr Gadget/Menu sperren/erlauben ------*
OnLoadDirIn	rs.w	1		;Directory geladen 1=Ja
OnModulesIn	rs.w	1		;Sind Module(Files) im Dir
PPDa		rs.w	1		;PP ladbar ???
LHDa		rs.w	1		;LH ladbar ???
XPKDa		rs.w	1		;XPK ladbar ???
CrMDa		rs.w	1		;XPK ladbar ???
Kick2On		rs.w	1		;Kennung 2.0 oder higher
Kick3On		rs.w	1		;Kennung 3.0 oder higher
ModuleLoaded	rs.w	1
WindowChanged	rs.w	1
PlayFasterOn	rs.w	1
NextSongOn	rs.w	1		;SongUmschaltung mglich
NextPatternOn	rs.w	1		;Patternumschaltung mglich
PrevPatternOn	rs.w	1		;Patternumschaltung mglich
SpeedOn		rs.w	1		;Speed verstellbar
SpeedDOn	rs.w	1		;Default-Speed verstellbar
SaveOn		rs.w	1		;Module Savebar
VolumeOn	rs.w	1
BalanceOn	rs.w	1
VoicesOn	rs.w	1

InternVoicePuffer rs.b	EP_MaxVoices*3

LastFadeVolume	rs.w	1		;fr FadeOut Zwischenspeicherung
PlayerFlagsDa	rs.w	1
PlayerFlags	rs.l	1

RasterLines	rs.l	1
DBFLoops	rs.l	1

NewCrunchName	rs.l	1
PathAdr		rs.l	1

HelpChange	rs.w	1		;Der Helpmodus wird gendert
GadgetsRemoved	rs.w	1		;Gadgets removed
PlGadgetsRemoved rs.w	1		;PlayerWindow Gadgets removed

OnlyEinmal	rs.w	1		;Kennung fr NextSong
MerkSubSongs	rs.l	1		;Merkbits der gespielten Songs

AbortTimes	rs.w	1		;Anz der Waits
AbortTimer	rs.w	1		;akt. Posi ds Waits

	*-------------- Preferences - Merkzellen --------------*
PlayerPathAdr	rs.l	1		;Adr des PlayerPaths
ModulePathAdr	rs.l	1		;Adr des ModulePaths
ConfigPathAdr	rs.l	1		;Adr des ConfigPath
UserPrPathAdr	rs.l	1		;Adr des EP-UserProgrammPath
InstPathAdr	rs.l	1		;Adr des Instrumenten-Paths
ModuleNameAdr	rs.l	1		;Adr des zu ladenen Modul-Namens

KickStart	rs.w	1		;Nr des Kickstarts

KeyOn		rs.b	1		;Keyfile ok und vorhanden (Modulechange)
		rs.b	1
NotRausWerf	rs.b	1		;Flag fr Load Before, dass das
					;aktuelle Mod nicht rausgeworfen wird

					;+-+-
Menusetting	rs.b	1		;Mu, weil KeyOn eigentlich wortgre
					;h ??-> ich habe einfach hier die
					;Unterscheidung zwischen Direnabled
					;und Disabled draus gemacht
					;einfach nach "HierDuEimer" suchen

Code		rs.b	1
CodePara1	rs.b	1
CodePara2	rs.b	1
CodePara3	rs.b	1
CodePara4	rs.b	1

SongEndVerbot	rs.b	1
DirTrotzDem	rs.b	1		;Soll Dir trotzdem geladen werden

MustRandomModule rs.b	1		;RandomModule laden
OnFilereqVerbot	rs.b	1		;kein Filerequester ausfhren
NurEinString	rs.b	1		;Bei LoadModule="mmm" "mmm"
					;damit '911 is a Joke' (ohne Gnse) als
					;ein Filename erkannt wird
FunctionAbortedNow rs.b	1
NewEngineVerbot	rs.b	1		;Verbot, an Manager Nachrichten zu senden
NoMessages	rs.b	1		;nur fr SendeAll
KillAllPlayer	rs.b	1		;Auch Structuren lschen
PathToPathAdr	rs.b	1
RippedFile	rs.b	1
NewListLoaded	rs.b	1		;Kennung neue DeliListe

TimingMode	rs.b	1
WaitingMode	rs.b	1
ProgrammMode	rs.b	1		;ProgrammMode (0=no,1=prev,2=next,3=r)
FileReqMode	rs.b	1		;ProgrammMode (0=no,1=req,2=reqt,3=asl)
IconifyMode	rs.b	1		;Kennung, welches Iconify
CrunchMode	rs.b	1		;Kennung, welcher CrunchMode
OldDirJumpProgramMode rs.b	1

NurLFLoad	rs.b	1		;Soll 2 Module geladen werden
PlayMemory	rs.b	1		;Wird ein Module aus dem Speicher geladen
NotifyActive	rs.b	1		;Ist Notify aktiviert worden
FileReqModeUsed	rs.b	1		;bei LoadConfig FileReq eingestellt
MenuMemUsed	rs.b	1		;bei LoadConfig MenuMem eingestellt
DelAllOther	rs.b	1		;Sollen alle Player gelscht werden
OnLoadFast	rs.b	1		;LoadFast-Loading eingeschaltet
OnLHAInMenu	rs.b	1		;Soll LHA-Liste ins PD-Menu
LHALoaded	rs.b	1		;Wurde ein LHA-File geladen ??? 1=ja

	*------------- Allgemeine Preferences ---------------*
ImmerEins	rs.b	1		;Immer eins
OnQuickStart	rs.b	1		;QuickStart eingeschaltet
OnLoadBefore	rs.b	1		;LoadBefore eingeschaltet
OnLoadAlways	rs.b	1		;Load Always, wenn Loadnext fehl geht
OnLoadDir	rs.b	1		;Dir on  (Default on=0)
OnMultiSelectIn	rs.b	1		;MMenu durch MultiSelect belegt
OnScrollInfos	rs.b	1		;Infos Anzeigen (0=on)
OnRandomSong	rs.b	1		;RandomPlay ON/Off fr SubSongs
OnFadeIn	rs.b	1		;FadeIn ON/Off
OnFadeOut	rs.b	1		;FadeOut ON/Off
OnQuiteagle	rs.b	1		;FadeOut ON/Off
OnOverwrite	rs.b	1		;Overwrite ON/Off
OnSongEnd	rs.b	1		;Songend on/off 1=on
OnRandomStart	rs.b	1		;Songend on/off 1=on
OnDirjump	rs.b	1		;Songend on/off 1=on
OnTimeMode	rs.b	1
OnCalcDuration	rs.b	1
OnMasterVolume	rs.b	1		;UserProgramm Volume
OnSaveT		rs.b	1		;Save T: on
OnEPDir		rs.b	1		;Use EPDir
OnShowDirNames	rs.b	1		;Show DirNames
OnAutoSubSong	rs.b	1		;AutoSubSong
OnHideAll	rs.b	1		;Hide All
OnUseSongName	rs.b	1		;Use Songname
OnUsePrefix	rs.b	1		;Use Songname
OnPBits		rs.b	1		;Protection-Bits setzen
OnProtect	rs.b	1		;Module Protection
OnAutoPassword	rs.b	1
OnAutomaticSave	rs.b	1
OnSSDir		rs.b	1
OnSampleMode	rs.b	1
OnSaveAsProT	rs.b	1
OnSmallModule	rs.b	1
OnNotify	rs.b	1
OnScanAlways	rs.b	1
OnEjectPlayer	rs.b	1
OnEjectEngine	rs.b	1
OnPlayerBatch	rs.b	1
OnXFDDecrunch	rs.b	1
OnXFDLoadSeg	rs.b	1
OnSafeSave	rs.b	1
OnBigModule	rs.b	1
OnModuleFault	rs.b	1
OnAllocChannels	rs.b	1
OnSoftInt	rs.b	1
ForceSoftInt	rs.b	1
OnLockModule	rs.b	1
OnNoGui		rs.b	1
OnExtractfirstModule rs.b	1

OnWindowZustand	rs.b	1		;Einstellflag von JumpTo/Prefs

OnUseArexxPuffer	rs.b	1		;beim Replyen der ArexxMsg wird
					;der ArexxPuffer genutzt
OnHelp		rs.b	1
OnGuiMessage	rs.b	1

OnCrunchDisplay	rs.b	1
TypeDelPlayer	rs.b	1		;WindowAufbau bei DelPlayer
NurDisablen	rs.b	1

OnIconify	rs.b	1		;Player im Iconify-Modus

	*-------------- Variablen fr das Playing --------------*
OnAllWindowsClosed	rs.b	1		;wurden alle anderen Userprogramme clos
CrunchKennung	rs.b	1		;Welcher Cruncher beim Laden
TimerOn		rs.b	1		;Timer Initialisiert
TimerFremd	rs.b	1		;Lauft ein fremder Interrupt
PlayOn		rs.b	1		;Wird das Modul gespielt
CryptOn		rs.b	1		;Wurde das Module vorm Crunchen gespielt
SavePlayOn	rs.b	1		;Wurde das Module vorm Saven gespielt
InitOn		rs.b	1		;Player initialisiert
AudioOn		rs.b	1		;Audio-Kanle allociert
AudioEnabled	rs.b	1		;Darf auf Audiokanle zugegriffen werden
NachTGesaved	rs.b	1		;Wurde dieses Module nach T: gesaved
NachTGesaved2	rs.b	1		;Wurde dieses Module nach T: gesaved
Sortieren	rs.b	1		;Mu richtig einsortiert werden
DupLock		rs.b	1		;Soll Lock geduplockt werden
Hiden		rs.b	1		;Mu gehidet werden
BatchLoading	rs.b	1		;Pl aus BatchDat laden (kein Replace)
RealExit	rs.b	1		;Sollen Engines komplett raus
DirJumpNewDir	rs.b	1		;Bei LoadStructModule wurde ein Parent
					;ausgefhrt

CFP_Flags	rs.b	1		;Flags fr dieses Item
CX_Priority	rs.b	1		;Prioritt der Commodity
CX_IEventErlaubt rs.b	1		;Ist IEvenErlaubt
DracoOn		rs.b	1


	*-------------------- Sonstiges ---------------------*
OnRemoveAbort	rs.b	1		;Soll AbortGadget gleich removed werden
OnAbortGadget	rs.b	1		;AbortGadget gerade geadded
OnStringGadget	rs.b	1		;StringGadget gerade aktiviert
SongEndNow	rs.b	1		;SongEnd Found
TimeOverNow	rs.b	1		;TimeOver Found
BreakMode	rs.b	1
OnAllowSampleinfo	rs.b	1	;Sampleinfo Erlaubt/Verboten
NumSofts	rs.b	1
PufferEnd	rs.b	0		;Ende des Puffers

*****************************************************************************





	ifeq	Executable
DebugStart
 		jsr	EPPlayerStart
		jsr	Player
		illegal
	endc




******************************************************************************
		Section	EaglePlayerStart,Code
EPPlayerStart:	bra.b	.Start

		dc.b	"$VER: Eagleplayer "
		EP_Version
		dc.b	", Rev: "
		EP_Revision
		dc.b	", Date: "
		*EPM_Date
		%getdate
		dc.b	", Time: "
		%gettime
		dc.b	0
		even


******************************************************************************
.Start:		lea	BSSStart,a0
		move.w	#(BSSEnd-BSSStart)-1,d0
.ClearBuffer:	clr.b	(a0)+
		dbf	d0,.ClearBuffer

		lea	BSSCStart,a0
		move.w	#(BSSCEnd-BSSCStart)-1,d0
.ClearCBuffer:	clr.b	(a0)+
		dbf	d0,.ClearCBuffer
		lea	BSSMerkPuffer,a5


		lea	DTG_GetListData(a5),a0
		lea	JumpTab,a1
		lea	JumpReturn-JumpTab(a1),a2
		move.l	a5,PufferAdr-JumpReturn(a2)
		move.l	a5,PufferAdr2-JumpReturn(a2)
		move.l	a2,d1
		moveq	#JumpTabSize,d0
.PufferUmbau:	move.l	(a1)+,(a0)
		add.l	d1,(a0)+
		dbf	d0,.PufferUmbau

	*---------- interne Unterprogramm-Tabelle creieren -----------*
		lea	A5ClearCache(a5),a0
		lea	A5UnterPrgTab,a1
		move.l	a5,PufferAdr3-A5UnterPrgTab(a1)
		lea	JumpTo,a2
		move.l	a2,d1
		move.w	#(A5RoutEnd-A5ClearCache)/6-1,d0
.PrgUmbau:	move.w	#$4ef9,(a0)+
		move.l	(a1)+,(a0)
		add.l	d1,(a0)+
		dbf	d0,.PrgUmbau

	*--------- Neue Gobals-UnterprogrammTabelle creieren ---------*
		lea	ENPP_AllocSampleStruct(a5),a0
		lea	JumpReturn,a2
		move.l	a2,d1
		move.w	#(ENPP_AllocSampleStruct-ENPP_SizeOf)/6-1,d0
.PufferUmbau2:	move.w	#$4ef9,(a0)+
		move.l	(a1)+,(a0)
		add.l	d1,(a0)
		subq.l	#8,a0
		dbf	d0,.PufferUmbau2

		ExecBase
		move.w	20(a6),KickStart(a5)
		clr.w	Kick2On(a5)
		clr.w	Kick3On(a5)
		cmp.w	#37,KickStart(a5)
		blo.s	.NoKick2
		not.w	Kick2On(a5)
.NoKick2:	cmp.w	#39,Kickstart(a5)
		blo.s	.NoKick3
		not.w	Kick3On(a5)


*-------------- Do not change! Do not change! Do not change! ---------------*
*-------------- Do not change! Do not change! Do not change! ---------------*
*-------------- Do not change! Do not change! Do not change! ---------------*
.NoKick3:	jsr	ClearCache	;A4000-Kompatibilitt
*-------------- Do not change! Do not change! Do not change! ---------------*
*-------------- Do not change! Do not change! Do not change! ---------------*
*-------------- Do not change! Do not change! Do not change! ---------------*

		jsr	A5FirstLocaleInit(a5)		*ist schon

	ifeq	Executable
	rts
	endc

		ExecBase
		move.l	$114(a6),a0
		tst.l	$ac(a0)
		bne.w	NoWBStart
		lea	$5c(a0),a0
		jsr	_LVOWaitPort(a6)
		move.l	$114(a6),a0
		lea	$5c(a0),a0
		jsr	_LVOGetMsg(a6)
		move.l	d0,Message(a5)
		move.l	d0,a4

	*----- Dos.library ffnen -----*
		LA1	LNr_Dosname
		lea	$17a(a6),a0
		jsr	_LVOFindName(a6)
		move.l	d0,a6
		move.l	d0,Start_Dosbase(a5)

	*----- WBStartup-Args -----*
	* erstes Argument = Lock & Name des Programms
	* zweites Arg     = Lock & Name des 1. Modules
		move.l	36(a4),a2		;Arglist laden
		move.l	28(a4),d0		;NumArgs lesen
		beq.s	WBStart
		move.l	(a2),d1			;Lock Duplizieren
		beq.s	WBStart
		move.l	Start_Dosbase(a5),a6
		jsr	_LVODuplock(a6)
		move.l	d0,d1
		move.l	d0,OldWBDirLock(a5)
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1				;Altes Dir merken
		jsr	_LVOUnlock(a6)			;und freigeben
		
	*--- Module ber WBArg ---*
;;		move.l	28(a4),d0		;NumArgs lesen
;		cmp.l	#2,d0
;		blt.s	WBStart
;		move.l	36(a4),a2		;Arglist laden
;		move.l	8(a2),d1
;		move.l	Start_Dosbase(a5),a6
;		jsr	_LVODuplock(a6)
;		move.l	d0,StartModuleLock
;		move.l	12(a2),StartmoduleName


WBStart:	bsr	Player
WBStartEnde:	move.l	Start_Dosbase(a5),a6
		move.l	OldWBDirLock(a5),d1		;My VerzeichnisLock
		beq.s	.NoWBDir
		jsr	_LVOUnlock(a6)

.NoWBDir:	move.l	a6,a1
		ExecBase
		jsr	_LVOCloseLibrary(a6)

		move.l	Message(a5),d7
		move.l	Segment(a5),a4
		ExecBase

	*------ Bei WB_Start hierher springen -----*
		jsr	_LVOForbid(a6)
		move.l	d7,a1
		jmp	_LVOReplyMsg(a6)



*-----------------------------------------------------------------------------*
InitCliArgs:	movem.l	d0-a6,-(a7)

		*--- Puffer fr Clitemplate besorgen ---*
	* max STRsize = 30
	* 3 Byte fr /K, /K,
	* Argarray
	* 10 Bytes extra
		move.l	#CliTemplateSize,d0
		move.l	#$10001,d1
		move.l	4,a6
		cmp.w	#37,20(a6)
		blo.w	.NoBase
		jsr	_LVOAllocMem(a6)
		sub.l	a6,a6
		move.l	d0,d6
		move.l	d0,CliArgs(a5)
		beq.w	.Error
		move.l	d0,a1
		move.l	d0,a2
		move.l	#CliTemplateSize-CliTemplateOffset-10,d5
		add.l	#CliTemplateOffset,a1		*Offset zum Template

		*--------- CliTemplate erzeugen ------------*
		lea	KommandoTabelle-EPRT_SizeOf,a4
.NextCommand:	lea	EPRT_SizeOf(a4),a4
		cmp.w	#-1,(a4)
		beq.s	.AllCommands
		tst.b	EPRT_Args(a4)
		move.b	EPRT_Flags(a4),d0
		btst	#EPRTF_NoCLI,d0
		bne.s	.NextCommand
		move.w	EPRT_StrLNr(a4),d0
		beq.s	.NextCommand
		move.w	d0,(a2)+
		jsr	A5GetLocaleString(a5)
		cmp.w	#30,d5
		ble.w	.Error
		jsr	A5StringCopy(a5)
		moveq	#30,d2
		sub.w	d1,d2
		sub.w	d2,d5
		subq.l	#2,d5
		blt.s	.Error
		move.b	#"/",(a1)+
		move.b	#"K",(a1)+

		*move.b	EPRT_Args(a4),d0
		*and.b	#$f0,d0
		*beq.s	.NextArg
		*subq.l	#2,d5
		*blt.s	.Error
		*move.b	#"/",(a1)+
		*move.b	#"K",(a1)+


.NextArg:	subq.l	#1,d5
		blt.s	.Error
		move.b	#",",(a1)+
		bra.s	.NextCommand


.AllCommands:	clr.b	-(a1)
		LA1	LNr_Dosname
		Execbase
		moveq	#37,d0
		jsr	_LVOOpenLibrary(a6)
		move.l	d0,a6
		tst.l	d0
		beq.s	.Error

		move.l	d6,d1
		move.l	d6,d2
		add.l	#CliTemplateOffset,d1		*Template
		add.l	#CliArgOffset,d2		*ArgArray
		moveq	#0,d3
		jsr	_LVOReadArgs(a6)
		move.l	d0,CliArgStruct(a5)
		tst.l	d0
		bne.s	.OK

	*-------- Error -> wieder freigeben ----------*
.Error:		move.l	CliArgs(a5),d0
		beq.s	.OK
		move.l	d0,a1
		move.l	#CliTemplateSize,d0
		move.l	a6,-(a7)
		Execbase
		jsr	_LVOFreeMem(a6)
		move.l	(a7)+,a6
		clr.l	CliArgs(a5)

.Ok:		move.l	a6,d0
		beq.s	.NoBase
		move.l	d0,a1
		EXECbase
		jsr	_LVOCloseLibrary(a6)

.NoBase:	movem.l	(a7)+,d0-a6
		rts



	*------ ############## CLI-START ############# -----*
NoWBStart:	bsr	InitCliArgs
Player:		LA1	LNr_Dosname
		lea	DTG_Dosbase(a5),a3
		moveq	#37,d0
		jsr	A5OpenLib(a5)
		beq.w	.Error


		*----- aktuelles Dir setzen -----*
	if Executable
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOGetProgramDir(a6)
	else
		lea	TextPuffer(a5),a0
		move.l	#"EP:"<<8,(a0)
		move.l	a0,d1
		moveq	#-2,d2
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOLock(a6)
.NoLock:
	endc
		moveq	#0,d5
		tst.l	d0
		beq.s	.NoNewLock
		move.l	d0,d1
		jsr	_LVODupLock(a6)
		move.l	d0,d1
		beq.s	.NoNewLock
		move.l	d0,d5
		jsr	_LVOCurrentDir(a6)
.NoNewLock:	move.l	d0,-(a7)

	*---------- Eagleplayer-Mainpfad setzen -----------*
		*move.l	DTG_Dosbase(a5),a6
		lea	EagleplayerDir(a5),a0
		move.l	a0,EPG_EagleplayerDirArrayPtr(a5)
		move.l	d5,d1
		beq.s	.NoNewLock2
		move.l	a0,d2
		move.l	#DirPufferSize-2,d3
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVONameFromLock(a6)
		lea	EagleplayerDir(a5),a1
		jsr	A5MakeCorrectDir(a5)
.NoNewLock2:


		*----- Setze AssignADD zu LOCALE: -----*
		moveq	#0,d4
		move.l	#17,d1			; LDF_Read!LDF_Assigns
		jsr	_LVOLockDoslist(a6)
		move.l	d0,d1
		beq.s	.NoAssignLock
		LA0	LNr_LocaleAssign
		move.l	a0,d2
		moveq	#17,d3			; LDF_Read!LDF_Assigns
		jsr	_LVOFindDosEntry(a6)
		move.l	d0,-(a7)
		moveq	#17,d1			; LDF_Read!LDF_Assigns
		jsr	_LVOUnlockDoslist(a6)
		move.l	(a7)+,d0
		tst.l	d0
		beq.s	.NoAssignLock


		move.l	d5,d1
		jsr	_LVODupLock(a6)
		move.l	d0,d4
		beq.s	.NoAssignLock
		move.l	d4,d2
		LA0	LNr_LocaleAssign
		move.l	a0,d1
		jsr	_LVOAssignAdd(a6)		;Kein Unlock !!!
.NoAssignLock:	move.l	d4,-(a7)

		bsr	.OldPlayer


		move.l	(a7)+,d2
		tst.l	d2
		beq.s	.NoAssignRem
		LA0	LNr_LocaleAssign
		move.l	a0,d1
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVORemAssignList(a6)

.NoAssignRem:	move.l	(a7)+,d1
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnLock(a6)
		moveq	#0,d0
		rts
.Error:		moveq	#-1,d0
		rts


	*------------------ Main Program --------------------*
.OldPlayer:	*----- Is Eagleplayer already running ? -----*
		move.b	#$42,Menusetting(a5)	;+-+- siehe oben, mu sein
		LA1	LNr_EPEnginePort
		ExecBase
		jsr	_LVOFindPort(a6)
		tst.l	d0
		beq.w	.EpNichtDa


		*------ Textpuffer lschen -------*
		lea	TextPuffer(a5),a1
		lea	1(a1),a0
		move.w	#UM_SizeOf-2,d1
		clr.b	(a1)
		jsr	A5CopyText2(a5)


		*---------- Cli-Start -----------*
		move.w	#LNr_Str_LoadModule,d0
		jsr	A5GetArgs(a5)
		beq.w	.SendMess



		jsr	A5InitCommodity(a5)
		jsr	A5CloseCommodity(a5)


		moveq	#2,d0			;CBERR_DUP=2 ;uniqueness violation
*	ifeq	UB_Test
		cmp.l	BrokerFehler(a5),d0
		beq.w	.NoMess
*	endc

		move.w	#Cli_Err_Exists,CLIError(a5)
		bra.w	.NoMess

	*-- Dem anderen Eagleplayer werden die WBArgs geschickt ---*
.SendMess:	sub.l	a4,a4
		clr.l	UPrg_Struct(a5)

		moveq	#0,d7			;Size fr EPT_String
		tst.l	CliArgs(a5)
		beq.s	.WBStart


		moveq	#EPRTAB_String1!EPRTAB_Must1,d0
		lea	TextPuffer(a5),a1
		moveq	#EPNr_LoadModule,d6
		bsr	GibArg			;>- d0=Fehler oder Null
		tst.l	d0
		bne.w	.NoMess
		move.l	a0,d4			;Start of Filename
		clr.b	(a0,d1.w)
		move.l	d1,d7			*Stringsize
		bra.s	.SendeCliMess

	*----------- WBStart -----------*
.WBStart:	move.l	Message(a5),d0
		beq.w	.NoMess
		move.l	d0,a0
		move.l	28(a0),d2		;NumArgs lesen
		cmp.l	#2,d2
		blt.w	.NoMess
		subq.l	#1,d2
		move.l	36(a0),a3		;Arglist laden
		addq.l	#8,a3

.SendeCliMess:	LA1	LNr_EPEnginePort
		ExecBase
		jsr	_LVOFindPort(a6)
		move.l	d0,d5
		beq.w	.NoMess

		*---- MsgPort errichten und Message schicken -----*
		Execbase
		jsr	_LVOCreateMsgPort(a6)
		move.l	d0,a4
		tst.l	d0
		beq.w	.NoMess
		move.l	d0,a1
		jsr	_LVOAddPort(a6)

		moveq	#EPT_String+4,d0
		add.l	d7,d0			*d7=CliStringsize
		move.l	d0,d6
		jsr	A5AllocMem(a5)
		tst.l	d0
		beq.w	.FreePort
		move.l	d0,UPrg_Struct(a5)
		move.l	d0,a2

		tst.l	d7
		bne.s	.CliMessage

		moveq	#EPT_String+4,d0
		move.l	d0,d6
		jsr	A5AllocMem(a5)
		tst.l	d0
		beq.w	.FreeStructs

	*---------- Message initialisieren -------*
		move.l	d0,(a2)				*Arglisten verketten
		move.l	#EPNr_InsertModulesList,UM_Command+TextPuffer(a5)
		move.l	#3,UM_Result+TextPuffer(a5)	*MultiSelectType
		move.l	a2,UM_ArgString+TextPuffer(a5)	*Structure merken
		move.l	d2,ENA_Arg1(a2)			*Anz der Files
		move.l	d6,ENA_Size(a2)
		move.l	(a2),a2
		move.l	a3,ENA_Arg1(a2)			*ArgList
		move.l	#EPT_StringSize+4,ENA_Size(a2)
		bra.s	.SendeMessage

	*-------------------- Cli-Argument ----------------------*
.CliMessage:	lea	TextPuffer(a5),a0		*Pfad kopieren
		move.l	d7,ENA_Arg1(a2)
		lea	EPT_String(a2),a1
		move.l	d7,d1
		subq.l	#1,d1
		jsr	A5StringCopy2(a5)
		lea	TextPuffer(a5),a1		*Puffer lschen
		lea	1(a1),a0
		move.w	#UM_SizeOf-2,d1
		clr.b	(a1)
		jsr	A5CopyText2(a5)
		move.l	#EPNr_LoadModule,UM_Command+TextPuffer(a5)
		move.l	a2,UM_ArgString+TextPuffer(a5)	*Structure merken
		move.l	d6,ENA_Size(a2)

	*------------------- Message abschicken ---------------*
.SendeMessage:	move.l	#USM_ExternalPrg,UM_Type+TextPuffer(a5)
		move.w	#USClass_Command,UM_Class+TextPuffer(a5)
		lea	TextPuffer(a5),a1
		move.l	d5,a0				*EPEnginePort
		move.l	a4,14(a1)
		move.w	#UM_SizeOf,18(a1)

		execbase
		jsr	_LVOPutmsg(a6)
		clr.l	UPrg_Struct(a5)
		move.l	a4,a0
		jsr	_LVOWaitport(a6)
		move.l	a4,a0
		jsr	_LVOGetMsg(a6)
		move.l	d0,a0
		tst.l	d0
		beq.s	.FreePort
		move.l	UM_ArgString(a0),UPrg_Struct(a5)
.FreeStructs:	jsr	A5FreeCommandStruct(a5)
.FreePort:	move.l	a4,d0
		beq.s	.NoMess
		move.l	a4,a1
		Execbase
		jsr	_LVORemPort(a6)
		move.l	a4,a0
		jsr	_LVODeleteMsgPort(a6)

.NoMess:	jsr	A5FreeCliStruct(a5)	*brauch erst hier freigebeben
						*werden, wegen Fehler
		bra.w	EagleEnd


	*------------------ Find-Task -----------------*
	*--- und checke ob noch alle Keyon(A5) korrekt drin sind ! ---*
.EpNichtDa:	move.w	#CLI_Err_Signals,CLIError(a5)
		jsr	A5Changea6_3(a5)		;+-+- siehe unten
		sub.l	a1,a1
		jsr	_LVOFindTask(a6)		;FAKE und trotzdem
							;FindTask
		move.l	d0,MyTaskAdr(a5)


	*------ Signal-Bit fr SongEnd allocieren ------*
		moveq	#0,d6
		Execbase
		moveq	#-1,d0
		move.l	d0,d5
		jsr	_LVOAllocSignal(a6)
		cmp.l	d0,d5
		beq.w	EagleEnd
		move.l	d0,SongEndBits(a5)
		bset	d0,d6
		move.l	d6,SignalBits(a5)

	*------- Signal-Bit fr ReplayUser-Port allocieren ------*
		moveq	#-1,d0
		jsr	_LVOAllocSignal(a6)
		cmp.l	d0,d5
		beq.w	FreeSongEndBits
		lea	EPReplayEnginePort,a1
		move.b	d0,15(a1)
		bset	d0,d6
		move.l	d6,SignalBits(a5)
		*------- REplay-UserPort ffnen -----*
		move.l	MyTaskAdr(a5),16(a1)	;TaskAdr nach Port
		lea	20(a1),a2
		move.l	a2,8(a2)		;NewList initialisieren
		addq.l	#4,a2
		clr.l	(a2)
		move.l	a2,-(a2)
		jsr	_LVOAddPort(a6)


	*------- Signal-Bit fr User-Port allocieren ------*
		moveq	#-1,d0
		jsr	_LVOAllocSignal(a6)
		cmp.l	d0,d5
		beq.w	FreeReplayEnginePort
		lea	EPEnginePort,a1
		move.b	d0,15(a1)
		bset	d0,d6
		move.l	d6,SignalBits(a5)
		*------- User-Programm-Port ffnen -----*
		move.l	MyTaskAdr(a5),16(a1)	;TaskAdr nach Port
		lea	20(a1),a2
		move.l	a2,8(a2)		;NewList initialisieren
		addq.l	#4,a2
		clr.l	(a2)
		move.l	a2,-(a2)
		jsr	_LVOAddPort(a6)



	*----------- RexxSysLibrary ffnen ----------*
		LA1	LNr_RexxSysName
		lea	EPG_RexxSysbase(a5),a3
		moveq	#0,d0
		jsr	A5OpenLib(a5)
		beq.w	.NoRexxSys

	*---- Signal-Bit fr Arexx-Port allocieren --*
		moveq	#-1,d0
		ExecBase
		jsr	_LVOAllocSignal(a6)
		cmp.l	d0,d5
		beq.w	CloseRexxSys
		lea	Rexx_MsgPort(a5),a1
		move.b	d0,15(a1)
		move.l	SignalBits(a5),d6
		bset	d0,d6
		move.l	d6,SignalBits(a5)

	*---------- Arexx-Programm-Port ffnen -------*
		LA0	LNr_EPArexxPort
		move.l	a0,10(a1)
		move.b	#4,8(a1)
		move.l	MyTaskAdr(a5),16(a1)	;Task Adr nach Port

		lea	20(a1),a2
		move.l	a2,8(a2)		;NewList initialisieren
		addq.l	#4,a2
		clr.l	(a2)
		move.l	a2,-(a2)
		ExecBase
		jsr	_LVOAddPort(a6)

.NoRexxSys:	tst.w	Kick2On(a5)
		beq.s	.NoAppPort

	*------------ App-Port einfgen ----------*
		moveq	#-1,d0
		jsr	_LVOAllocSignal(a6)
		cmp.l	d0,d5
		beq.w	FreeArexxPort		;Error
		lea	EPAppPort,a1
		move.b	d0,15(a1)
		move.l	SignalBits(a5),d6
		bset	d0,d6
		move.l	d6,SignalBits(a5)

	*--------- App-Programm-Port ffnen -------*
		move.l	MyTaskAdr(a5),16(a1)	;Task Adr nach Port
		lea	20(a1),a2
		move.l	a2,8(a2)		;NewList initialisieren
		addq.l	#4,a2
		clr.l	(a2)
		move.l	a2,-(a2)
		jsr	_LVOAddPort(a6)


	*-------------- Dos-Library ffnen ------------*
.NoAppPort:	move.w	#CLI_Err_Dos,CLIError(a5)




	*----------- Notify-Port einsetzen ------------*
		tst.w	Kick2On(a5)
		beq.s	.NoNotifyPort
		ExecBase
		jsr	_LVOCreateMSGPort(a6)
		move.l	d0,NotifyPort(A5)
		beq.s	.NoNotifyPort

		move.l	d0,a1
		moveq	#0,d1
		move.b	15(a1),d1
		move.l	SignalBits(a5),d6
		bset	d1,d6
		move.l	d6,SignalBits(a5)


		jsr	A5StartNotify(a5)

	*--------------- Defaults setzen --------------*
.NoNotifyPort:	jsr	A5KeyChangeInit(a5)


	*------------------------------------------------------------------*
	*------ a4=adresse der Userprogramm-Struktur oder Null ---------------*
	*------ d1=UPrgS_UFlags					------------*
	*------ d2=UserNummer					------------*
	*------ a1=Namenadresse des Userprogramms			------------*
	*---------------------------------------------------------------------------*
*		jsr	A5FindFreeUserNr(a5)
*		beq.s	.NoWindow
*		move.l	d0,d2
*		lea	MainWindowEngine,a4
*		move.l	a4,EPG_FirstUserStruct(a5)
*		addq.l	#1,EngineAnz(a5)
*		moveq	#UPrgB_Engine,d1
*		move.w	d2,EUS_UserNr(a4)
*		move.l	EUS_UserName(a4),a1
*		jsr	A5SetNowUserName(a5)
*		bne.s	.NoWindow
*		move.l	d2,d0
*		jsr	A5FindUserStruct(a5)
*		bne.s	.NoWindow
*		jsr	A5ActivateAUser(a5)
*
		lea	WBTitlePuffer(a5),a0
		move.l	a0,EPG_TitlePuffer(a5)

		lea	EngineList(a5),a0
		move.l	a0,EPG_EngineList(a5)
		Newlist	a0
		lea	ModulesList(a5),a0
		move.l	a0,EPG_ModulesList(a5)
		Newlist a0

		bsr	FirstPlayerInit

		moveq	#1,d0
		move.b	d0,OnShowDirNames(a5)
		move.b	d0,ImmerEins(a5)
		move.l	d0,ImmerEins_2(a5)
		move.b	d0,OnAllocChannels(a5)
		move.b	d0,OnSoftInt(a5)
		move.l	d0,WinMerk(a5)
		move.b	d0,OnWindowZustand(a5)

		move.b	d0,OnHideall(a5)
		move.b	d0,OnLoaddir(a5)
		move.b	d0,OnFadeout(a5)
		move.b	d0,OnFadein(a5)
		move.b	d0,OnScrollinfos(a5)
		move.b	d0,OnQuickStart(a5)
		move.b	d0,OnPlayerbatch(a5)
		move.b	d0,OnSaveT(a5)
		move.b	d0,OnLoadFast(a5)
		move.b	d0,OnSongend(a5)
		move.b	d0,OnCalcDuration(a5)
		move.b	d0,OnModuleFault(a5)
		*move.b	d0,OnWindowZustand(a5)
		*move.b	d0,WinMerk+3(a5)
		move.b	d0,OnQuitEagle(a5)

		move.l	#EGPRB_LoadFast!EGPRB_AllocChannels!EGPRB_SoftInt!EGPRB_CalcDuration!EGPRB_Fadein!EGPRB_Fadeout!EGPRB_Songend,EPG_SomePrefs(a5)

		move.l	#DefaultDBFLoops,DBFLoops(a5)
		moveq	#DefaultRasterLines,d0
		move.l	d0,RasterLines(a5)

		lea	EP_UPSStructure(a5),a1
		*move.l	a1,EPG_UPS_Structure(a5)
		move.l	a1,StructAdr

		lea	EPG_SongnamePuffer(a5),a1
		move.l	a1,EPG_Songname(a5)

		move.b	#EPNRP_NoNextModule,ProgrammMode(a5)
		move.b	#EPNrI_AppIcon,IconifyMode(a5)
		move.b	#EPNrT_TimerDevice,TimingMode(a5)
		move.b	#EPNrW_Automaticwait,WaitingMode(a5)
		move.b	#EPNrC_Uncrunched,CrunchMode(a5)
		move.b	#-1,OldDirJumpProgramMode(a5)

		*---- neuen Voicepuffer fllen ----*
		lea	InternVoicePuffer(a5),a0
		move.l	a0,EPG_VoiceTable(a5)
		move.w	#EP_MaxVoices,d1
	*	move.w	#EP_MaxVolume,d0
		move.w	#EP_DefVolume,d0
		move.w	d0,EPG_Volume(a5)
		move.w	d0,EPG_LeftBalance(a5)
		move.w	d0,EPG_RightBalance(a5)
		move.w	d1,EPG_VoiceTableEntries(a5)
		lea	(a0,d1.w),a0
		subq.l	#1,d1
.FillVoicePuffer:				* Volume wird bei EPP_SetVoices
		move.b	#EP_MaxVolume,(a0)+	* runtergerechnet
		move.b	#1,(a0)+
		dbf	d1,.FillVoicePuffer


	*	moveq	#MaxVolume,d0
		moveq	#EP_DefVolume*64/255,d0
		move.w	d0,DTG_SndVol(a5)
		move.w	d0,DTG_SndLBal(a5)
		move.w	d0,DTG_SndRBal(a5)
		jsr	A5SetVoicesInEPG(a5)






;		lea	A5EPP_AllocSampleStruct(a5),a1
;		move.l	a1,EPG_NewJumpTab(a5)

		move.l	#1368,Crmd0Add(a5)


		move.l	#"EPGL",d3
		LA0	LNr_DefaultHotkey
		lea	HotkeyPuffer(a5),a1
		move.l	d3,KeyCrmHelp-HotkeyPuffer(a1)
		move.w	#HotKeyPufferSize-1,d1
		jsr	A5StringCopy2(a5)

		move.l	d3,EPG_Identifier(a5)
		move.l	#EagleVersion,EPG_EagleVersion(a5)

		LA0	LNr_ModulesTitle
		jsr	A5BerechStringSize(a5)
		move.l	d0,d1
		lea	ModulesTitlePuffer(a5),a1		
		sub.l	#"EPGL"-"ErM!",KeyCrmHelp-ModulesTitlePuffer(a1)
		jsr	A5StringCopy2(a5)
		move.b	#" ",(a1)+
		move.b	#"(",(a1)+

		LA0	LNr_TopazName
		lea	Fontname(a5),a1
		moveq	#31,d1
		move.l	A5Return+2(a5),KeyReturn-Fontname(a1)
		jsr	A5StringCopy2(a5)


		move.l	#"SQSH",XPK_CrunchMode(a5)
		move.l	#DefaultMenuSize,MenuMemSize(a5)
		move.w	#15,EPG_Voices(a5)

		clr.l	EPG_TimeOut(a5)
		clr.w	SpeedSize(a5)

	*------------------- Playerdefaults setzen -----------------*
		*move.w	#AnzInternalPlayers,PlayerAnz(a5)
		*lea	FirstInternal,a0
		*move.l	a0,FirstPlayer(a5)

	*------------------- Enginedefaults setzen -----------------*
*
* [][]
*
*		move.l	#AnzInternalEngines,EngineAnz(a5)
*		lea	FirstInternalEngine,a0
*		move.l	a0,FirstEngine(a5)
*

*Interne Amplifier setzen
*---------------- nur vorlufig -------------------
	lea	FirstAmplifier,a0
	move.l	a0,EPG_AmplifierList(a5)
*--------------------------------------------------
	

		LA0	LNr_InstrumentsDir
		lea	InstrDir(a5),a1
		move.w	#DirPufferSize-2,d1
		jsr	A5StringCopy2(a5)
		LA0	LNr_DefPubScreen
		lea	PubScreenName(a5),a1
		move.l	a1,EPG_PubScreen(a5)
		move.w	#PubScreenSize-2,d1
		jsr	A5StringCopy2(a5)

	*------------ Intuition-Library ffnen ------------*
		move.w	#Cli_Err_Intuition,CLIError(a5)
		LA1	LNr_Intuiname
		lea	DTG_IntuitionBase(a5),a3
		moveq	#37,d0
		jsr	A5OpenLib(a5)
		beq.w	FreeMenuMem

	*------- Graphics-Library ffnen --------*
		move.w	#Cli_Err_Gfx,CLIError(a5)
		La1	LNr_Graphname
		lea	DTG_GFXBase(a5),a3
		moveq	#37,d0
		jsr	A5OpenLib(a5)
		beq.w	Closeintui

		jsr	InitRandom			;Init fr Randomroutinen

	*----------- CiaB-Resource ffnen ---------*
		LA1	LNr_DracoResource
		moveq	#0,d0
		ExecBase
		jsr	_LVOOpenResource(a6)
		tst.l	d0
		beq.s	.NoDraco
		move.b	#1,DracoOn(a5)
.NoDraco:

	*----------- CiaB-Resource ffnen ---------*
	*	move.w	#EPR_CantAllocCia,CliError(a5)
		clr.w	CliError(a5)			;Kein Fehler
		LA1	LNr_Ciabname
		moveq	#0,d0
		ExecBase
		jsr	_LVOOpenResource(a6)
		move.l	d0,EPG_CiaBBase(a5)
		*beq.w	CloseSInter

*	ifeq	ub_test
	*----- Scroll-Interrupt initialisieren ----*
		moveq	#5,d0				;ScrollInterrupt
		lea	ScrollInterrupt,a1		;eingeben
		jsr	_LVOAddIntServer(a6)
*	endc
		clr.w	CliError(a5)			;Kein Fehler

	*-------- Open DiskFont.Library ---------*
		lea	EPG_DiskFontBase(a5),a3
		LA1	LNr_DiskFontName
		moveq	#37,d0
		jsr	A5OpenLib(a5)

	*-------- GadTools-Library ffnen -------*
		LA1	LNr_GadToolsName
		lea	DTG_GadToolsBase(a5),a3
		moveq	#37,d0
		jsr	A5OpenLib(a5)


		*move.l	#EPP_OpenCatalog,0

	*-------- Locale.Library & Cataloge ffnen -------*
		LA1	LNr_LocaleName
		lea	EPG_LocaleBase(a5),a3
		moveq	#38,d0
		jsr	A5OpenLib(a5)

		bsr	OpenCatalogs


		move.w	#LNr_ChipRamAmplifier,d0
		jsr	A5GetLocaleString(a5)
		lea	FirstAmplifier,a1
		move.l	d0,EUS_AboutEngine(a1)
		move.w	#LNr_FastRamAmplifier,d0
		jsr	A5GetLocaleString(a5)
		move.l	4(a1),a1
		move.l	d0,EUS_AboutEngine(a1)



	*------------ Powerpacker-Library ffnen ---------*
		La1	LNr_PPName
		lea	EPG_PPBase(a5),a3
		moveq	#35,d0
		jsr	A5OpenLib(a5)
		move.w	d0,PPDa(a5)
		swap	d0
		move.w	d0,PPDa(a5)

	*-------- XPKMaster.Library ffnen --------*
		LA1	LNr_XPKName
		lea	EPG_XPKBase(a5),a3
		moveq	#0,d0
		jsr	A5OpenLib(a5)
		move.w	d0,XPKDa(a5)
		swap	d0
		move.w	d0,XPKDa(a5)

	*----------- CrM.Library ffnen -----------*
		LA1	LNr_CrMName
		lea	EPG_CrMBase(a5),a3
		moveq	#4,d0
		jsr	A5OpenLib(a5)
		move.w	d0,CrMDa(a5)
		swap	d0
		move.w	d0,CrMDa(a5)

	*----------- Icon-Library ffnen ----------*
		LA1	LNr_IconName
		lea	EPG_IconBase(a5),a3
		moveq	#37,d0
		jsr	A5OpenLib(a5)

		moveq	#EPNrF_ReqTools,d2
		jsr	A5SetFileReqMode(a5)


	*------------ LH-Library ffnen -----------*
		La1	LNr_LhName
		lea	EPG_LHBase(a5),a3
		moveq	#0,d0
		jsr	A5OpenLib(a5)
		move.w	d0,LHDa(a5)
		swap	d0
		move.w	d0,LHDa(a5)



*	ifeq	Executable
*		move.l	DTG_Intuitionbase(a5),a6
*		jsr	_LVOWBenchtofront(a6)
*	endc

	move.l	a7,CloseStackAdr(a5)

		jsr	A5GuiChanged(a5)


	**** -------->>> Playerpfad setzn <<<--------- ****
		LA0	LNr_EaglePlayerDir
		lea	PlayersDir(a5),a1
		move.w	#DirPufferSize-2,d1
		jsr	A5StringCopy2(a5)

	**** ------>>> Enginespfad setzen <<<-------- ****
		clr.l	LastEngine(a5)


	*--------------- Setze Default Enginedir ----------------*
		move.l	DTG_Dosbase(a5),a6
*		lea	EngineDir(a5),a0
*		move.l	a0,d1
*		move.l	#DirPufferSize-2,d2
*		jsr	_LVOGetCurrentDirName(a6)
*		lea	EngineDir(a5),a1
*		jsr	A5MakeCorrectDir(a5)		
*		lea	EngineDir(a5),a0
*		jsr	A5BerechStringSize(a5)
*		lea	(a0,d0.w),a1
*		LA0	LNr_EngineDir
*		jsr	A5StringCopy(a5)
*		lea	EngineDir(a5),a1
*		jsr	A5MakeCorrectDir(a5)
*		lea	EngineDir(a5),a0
*		move.l	a0,EPG_EngineDirArrayPtr(a5)


		LA0	LNr_EngineDir
		lea	EngineDir(a5),a1
		move.l	a1,EPG_EngineDirArrayPtr(a5)
		jsr	A5StringCopy(a5)


	*--------------- Setze Default Playerdir ----------------*
*		move.l	DTG_Dosbase(a5),a6
*		lea	PlayersDir(a5),a0
*		move.l	a0,d1
*		move.l	#DirPufferSize-2,d2
*		jsr	_LVOGetCurrentDirName(a6)
*		lea	PlayersDir(a5),a1
*		jsr	A5MakeCorrectDir(a5)		
*		lea	PlayersDir(a5),a0
*		jsr	A5BerechStringSize(a5)
*		lea	(a0,d0.w),a1
*		LA0	LNr_EaglePlayerDir
*		jsr	A5StringCopy(a5)
*		lea	PlayersDir(a5),a1
*		jsr	A5MakeCorrectDir(a5)
*		lea	PlayersDir(a5),a0
*		move.l	a0,EPG_PlayerDirArrayPtr(a5)

		LA0	LNr_EagleplayerDir
		lea	PlayersDir(a5),a1
		move.l	a1,EPG_PlayerDirArrayPtr(a5)
		jsr	A5StringCopy(a5)



		lea	CRMDeCrunch-1368(a5),a0
		lea	XPK_CrunchTags,a1
		lea	FirstKeyDecode-XPK_CrunchTags(a1),a1
		add.l	CRmD0Add(a5),a0
		move.l	a1,(a0)

	*------ KeyFile von Devs: laden -----*
		LA1	LNr_Devsname
		LA2	LNr_KeyName
		moveq	#1,d0
		moveq	#7,d1
		jsr	A5LoadFile(a5)
		tst.l	d0
		beq.w	.KeyFileOk
		cmp.w	#EPR_ErrorDecrunching,d0
		beq.w	.KeyFault

	*----- KeyFile vom aktuellen Pfad laden -----*
		lea	EmptyPuffer(a5),a1
		LA2	LNr_KeyName
		moveq	#1,d0
		moveq	#7,d1
		jsr	A5LoadFile(a5)
		tst.l	d0
		beq.w	.KeyFileOk
		cmp.w	#EPR_ErrorDecrunching,d0
		bne.w	.LoadC

	*---------------- KeyfileDaten merken -------------*
		move.l	File(a5),KeyAdr(a5)
		move.l	FileSizeNeu(a5),KeySize(a5)
		clr.l	File(a5)
		clr.l	FileSizeNeu(a5)
.KeyFault2:	bsr.w	FreeKeyFile

	*----- Testrequest "Eagleplayer.Key" has a fault" -----*
.KeyFault:	lea	PubScreenName(a5),a1
		move.l	a1,EPG_Arg2(a5)
		LA0	LNr_TR_KeyHasAFault
		move.l	a0,EPG_Arg1(a5)
		clr.l	EPG_Arg3(a5)
		subq.l	#1,EPG_Arg3(a5)
		clr.l	EPG_Arg4(a5)			;Gadgets
		clr.l	EPG_Arg5(a5)			;Windowname
		clr.l	EPG_Arg6(a5)
		move.l	#EPTRB_Center,EPG_Arg8(a5)
		moveq	#-1,d0
		move.l	d0,EPG_Arg7(a5)
		moveq	#7,d0
		move.l	d0,EPG_ArgN(a5)
		move.l	EPG_Textrequest(a5),a0
		jsr	(a0)
		bra.s	.FreeKeyFile
		*jmp	A5CloseWin(a5)

	*--------- Setze alle erlaubten Sachen frei ---------*
.KeyFileOk:	move.l	File(a5),KeyAdr(a5)
		move.l	FileSizeNeu(a5),KeySize(a5)
		clr.l	File(a5)
		clr.l	FileSizeNeu(a5)
		move.l	KeyAdr(a5),a0
		cmp.l	#"EKEY",(a0)
		bne.w	.KeyFault2
.FreeKeyfile:	bsr.w	FreeKeyFile

	*------------------ Config laden --------------*
.LoadC:		moveq	#64,d1
		ExecBase				;bsr.w	DecodeStruct1
		bsr.w	Changea6_1
		move.l	#5400,d0
		move.l	#$10001,d1
		jsr	-$198(a6)
		move.l	d0,DummyAdr(a5)
		beq.w	CloseWin

		lea	CRM_Decrunch,a0
		move.l	a0,CRMDecrunch(a5)
		moveq	#-1,d0
		move.l	d0,KeyFault(a5)

	*------- Default-Topaz-Font laden -------*
		lea	Fontname(a5),a1
		move.l	a1,EPG_Arg1(a5)
		moveq	#9,d0
		move.l	d0,EPG_Arg2(a5)


		moveq	#Mode_Config,d0
		move.l	d0,TestBits(a5)

		*bsr.w	SetMenuFont		;nur durch config
		*bsr.w	SetModulesFont



	*----------- Arg in Tooltypes suchen ----------*
		move.l	Message(a5),d0		;WBStartMSG
		beq.s	.CliStart
		move.l	d0,a0
		move.l	36(a0),d0		;Arglist laden
		beq.s	.CliStart
		move.l	d0,a2
		move.l	28(a0),d0		;NumArgs lesen
		beq.s	.CliStart
		move.l	4(a2),d1			;Name des Eagleplayers
		move.l	d1,a0
		bne.s	.NameOk
.CliStart:	lea	TextPuffer(a5),a0
		move.l	a0,d1
		move.l	#TextPufferSize-2,d2
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOGetProgramName(a6)
		lea	TextPuffer(a5),a0
		tst.l	d0
		bne.s	.NameOk
		LA0	LNr_Prozessname
.NameOk:	move.l	EPG_IconBase(a5),a6
		jsr	_LVOGetDiskObject(a6)
		move.l	d0,EagleIconAdr(a5)
		jsr	A5InitLoadConfig(a5)
		jsr	A5LoadConfig(a5)
		clr.w	CliError(a5)



		move.l	EagleIconAdr(a5),d0
		beq.s	.NoIcon
		move.l	d0,a0
		move.l	EPG_IconBase(a5),a6
		jsr	_LVOFreeDiskObject(a6)
.NoIcon:	clr.l	EagleIconAdr(a5)
		jsr	A5FreeCliStruct(a5)

;
;*
;* ACHTUNG !!!! KEYTESTER1
;* Codetest !!
KeyTest1:	tst.l	KeyFault(a5)
		beq.w	CloseWin
;* Codetest !!
;* ACHTUNG !!!! KEYTESTER1
;
		clr.w	ClearMouseVerbot(a5)
		jsr	A5ClearMouse2(a5)



		moveq	#0,d0
		jsr	A5ClearCache(a5)

		
		tst.b	KeyOn(a5)
		bne.s	.Noreq
		move.l	#9,NervCounter(a5)
		*move.w	#LNr_TR_RegisteredStart,d0
		*jsr	A5NervRequest2(a5)
.NoReq:


		LA0	LNr_EPVersion
		move.l	A0,ScrollArgs(a5)
		moveq	#LNr_Welcome,d0
		jsr	A5ScrollNew(a5)
		jsr	A5PrintDisabled(a5)
	*lea	string,a0
	*moveq	#Mode_config,d0
	*jsr	A5Kommandoauswertung(a5)

		bra.w	Warten


*----------------------------------------------------------------------------*
*------------- Hier wait, bis einer der Message-Ports ->>> Message ----------*
*----------------------------------------------------------------------------*
Wait:	

*
* ACHTUNG !!!! KEYTESTER1
* Codetest !!
*KeyTest1:	tst.l	KeyFault(a5)
*		beq.w	CloseWin
* Codetest !!
* ACHTUNG !!!! KEYTESTER1

		tst.l	KeyDisabled(a5)
		bne.w	CloseWin


		move.l	SignalBits(a5),d0
		or.l	UMG_SignalBits(a5),d0
		or.l	UMG_InterruptBits(a5),d0
		or.w	#$1000,d0		;Break-Signal
		ExecBase
		jsr	_LVOWait(a6)


		btst	#12,d0			;Break-Signal
		bne.w	CloseWin

*		cmp.l	ScrollMask(a5),d0
*		beq.s	ScrollIt

	*------- Testen welcher Port --------*
		lea	EPReplayEnginePort,a0		;Testen ob USER-Port
		moveq	#0,d1
		move.b	15(a0),d1
		btst	d1,d0
		bne.w	WartenReplayPort

		lea	EPEnginePort,a0			;Testen ob USER-Port
		moveq	#0,d1
		move.b	15(a0),d1
		btst	d1,d0
		bne.w	WartenUserPort

		move.l	ScreenNotifyPort(a5),d2
		beq.s	.NoSNotify
		move.l	d2,a0				;Testen ob Broker-Port
		move.b	15(a0),d1
		btst	d1,d0
		bne.w	WartenSNotifyPort


.NoSNotify:	lea	EPAppPort,a0			;Testen ob App-Port
		move.b	15(a0),d1
		btst	d1,d0
		bne.w	WartenAppport

		lea	Rexx_MSGPort(a5),a0		;Testen ob Arexx-Port
		move.b	15(a0),d1
		btst	d1,d0
		bne.w	WartenArexxPort

	*------------- externes Gui-uptesten --------------*
		move.l	d0,d1
		jsr	A5GetMainWindowTags(a5)
		exg	d0,d1
		tst.l	d1
		beq.s	.NoExtInter
		move.l	UMG_SignalBits(a5),d1
		and.l	d0,d1
		beq.s	.NoExtGui
		move.l	d1,d0
		bra.w	WartenGuiPort2

	*--------------- externen Scroller ----------------*
.NoExtGui:	move.l	UMG_InterruptBits(a5),d1
		and.l	d0,d1
		beq.s	.NoExtInter
		move.l	UMG_InterruptAdr(a5),d0
		beq.s	Warten
		move.l	d0,a0
		jsr	(a0)
		move.l	PufferAdr,a5
		tst.l	d0
		bne.s	.NoNew
		tst.l	ScrollANewText(a5)
		bne.s	.NoNew
		move.l	#1,ScrollANewText(a5)
.NoNew:		bra.s	Warten


.NoExtInter:	move.l	BrokerPort(a5),d2
		beq.s	.NoBroker
		move.l	d2,a0				;Testen ob Broker-Port
		move.b	15(a0),d1
		btst	d1,d0
		bne.w	WartenAppport

.NoBroker:	move.l	NotifyPort(a5),d2
		beq.s	.NoNotify
		move.l	d2,a0				;Testen ob Broker-Port
		move.b	15(a0),d1
		btst	d1,d0
		bne.w	WartenNotify

.NoNotify:	move.l	SongEndBits(a5),d1
		btst	d1,d0
		bne.s	Warten			->> Test auf SongEnde SongEndFound

		bra.w	Wait


*----------------------------------------------------------------------------*
*------------- Aktuelle Message in den IntuiMessagePuffer copieren ----------*
*----------------------------------------------------------------------------*
Warten:		moveq	#0,d0
		tst.l	UpdatePlayerList(a5)
		bne.w	UpdateMyPlayerList

		tst.b	SongEndNow(a5)
		bne.w	.BreakSongNow
		tst.l	ScrollLastLNrAdr(a5)
		bne.s	.NoScrollNew
		cmp.l	#ScrollZahler,ScrollANewText(a5)
		blt.s	.NoScrollNew
		jsr	A5CreatePlayName(a5)
		clr.l	ScrollANewText(a5)
		bra.s	Warten

.BreakSongNow	jmp	BreakSongNow

.NoScrollNew
	;	moveq	#1,d0
	;	tst.b	SongEndNow(a5)
	;	bne.w	.BreakSongNow

		moveq	#2,d0
		tst.b	TimeOverNow(a5)
		bne.w	.BreakSongNow

WartenReplayPort:lea	EPReplayEnginePort,a0
		ExecBase
		jsr	_LVOGetmsg(a6)
		tst.l	d0			;Scrollen erlaubt
		beq.w	WartenUserPort
		jsr	A5EngineMessage(a5)
		jmp	A5Warten(a5)

WartenUserPort:	lea	EPEnginePort,a0
		ExecBase
		jsr	_LVOGetmsg(a6)
		tst.l	d0			;Scrollen erlaubt
		beq.w	WartenSNotifyPort
		jsr	A5EngineMessage(a5)
		jmp	A5Warten(a5)

WartenSNotifyPort:
		move.l	ScreenNotifyPort(a5),d0
		beq.s	WartenGuiPort
		move.l	d0,a0
		ExecBase
		jsr	_LVOGetMsg(a6)
		tst.l	d0
		beq.s	WartenGuiPort
		jsr	A5ScreenNotifyMessage(a5)
		jmp	A5Warten(a5)

WartenGuiPort:	moveq	#0,d0
WartenGuiPort2:	move.l	d0,d1
		jsr	A5GetMainWindowTags(a5)
		beq.s	WartenArexxPort
		move.l	d0,-(a7)		;Tagliste auf Stack
		move.l	d1,d0			;SignalSet
		move.l	#EUT_GetMsg,-(a7)	;Tag auf Stack
		jsr	A5UserCallUp(a5)
		addq.l	#8,a7
		move.l	PufferAdr,a5
		beq.s	WartenArexxPort		;beq=kein Tag
		tst.l	d0			;d0=Fehlernummer
		beq.w	WartenArexxPort		;-> keine Nummer
		move.b	#1,OnGuiMessage(a5)
		jsr	A5JumpTo(a5)
		clr.b	OnGuiMessage(a5)
		jmp	A5Warten(a5)

WartenArexxPort:tst.l	EPG_RexxSysbase(a5)
		beq.w	WartenAppPort
		lea	Rexx_MsgPort(a5),a0
		ExecBase
		jsr	_LVOGetmsg(a6)
		tst.l	d0
		beq.s	WartenAppPort
		jsr	A5ArexxMsg(a5)
		jmp	A5Warten(a5)


WartenAppPort:	tst.w	Kick2On(a5)
		beq.w	WartenCommodity
		tst.l	EPG_WorkbenchBase(a5)		;WB-Lib schlieen
		beq.w	WartenCommodity
		lea	EPAppPort,a0
		ExecBase
		jsr	_LVOGetmsg(a6)
		tst.l	d0
		beq.s	WartenCommodity
		jsr	A5AppMessage(a5)
		jmp	A5Warten(a5)


	*------ warten auf den Commodity-Port ------*
WartenCommodity:move.l	BrokerPort(a5),d0
		beq.w	WartenNotify
		move.l	d0,a0
		ExecBase
		jsr	_LVOGetMsg(a6)
		tst.l	d0
		beq.w	WartenNotify
		jsr	A5CommodityMsg(a5)
		jmp	A5Warten(a5)

	*------- warten auf den Notify-Port --------*
WartenNotify:	tst.w	Kick2On(a5)
		beq.w	Wait
		move.l	NotifyPort(a5),d0
		beq.w	Wait
		move.l	d0,a0
		ExecBase
		jsr	_LVOGetMsg(a6)
		tst.l	d0
		beq.w	Wait

	*- Es ist eine Notify-Message eingetroffen -*
		jsr	A5CopyMessage(a5)
		tst.b	OnNotify(a5)
		beq.w	.ToWarten
		jsr	A5RescanDir(a5)

.ToWarten:	jmp	A5Warten(a5)







******************* Check auf Zeicherkette **********************
** INPUT:	a1 = Zeichenkette (mit Leerzeichen)		*
** OutPut	a1 = Start of next String			*
**		d0 = Start of String				*
**		d1 = Length of String				*
*****************************************************************
FindFileName:	movem.l	d2-d7/a0/a3/a6,-(a7)
		moveq	#0,d0
		moveq	#0,d1			;Length of String
		cmp.l	a1,d1
		beq.w	.Err

		move.b	#32,MerkGanse(a5)

	*------- Alle Leerzeichen killen -------*
.FindAllLeer:	tst.b	(a1)
		beq.s	.Err
		cmp.b	#33,(a1)+
		blo.s	.FindAllLeer
		subq.l	#1,a1

	*------ Gnsefschen oder so finden ------*
		move.l	a1,a0
		sub.l	a1,a1
.Finddata:	move.l	a0,d2
		move.b	(a0),d1
		beq.s	.Err		;0=Ende -> Fehler
		cmp.b	#10,d1
		beq.s	.Err
		cmp.b	#'"',d1
		beq.s	.Ganse
		cmp.b	#"'",d1
		beq.s	.Ganse
		cmp.b	#"`",d1
		beq.s	.Ganse

		tst.b	NurEinString(a5)
		beq.s	.Loop
		move.l	a0,d0			;Start of String
		moveq	#-1,d1
.NES_Loop:	addq.l	#1,d1
		move.b	(a0)+,d2
		beq.s	.NES_Ende
		cmp.b	#10,d2
		bne.s	.NES_Loop
.NES_Ende:	sub.l	a1,a1
		bra.s	.Err




.Ganse:		move.b	d1,MerkGanse(a5)
		addq.l	#1,a0
		move.l	a0,d2			;neu !!!

.Loop:		move.b	(a0),d1			;ist gelesener Wert = EndWert
		beq.s	.Ende
		cmp.b	MerkGanse(a5),d1	;Also '"' oder null
		beq.s	.Jo			;---> Stringende found
		cmp.b	#10,d1
		beq.s	.Ende
		addq.l	#1,a0
		bra.b	.Loop

	*---- StringEnde, testen, ob Gansefe da sein mssen ---*
.Ende:		cmp.b	#32,MerkGanse(a5)
		bne.s	.Err
.Jo:		move.l	a0,d1			;Length nach d1
	*	subq.l	#1,d1			;End of String
		sub.l	d2,d1			;minus Start
		move.l	d2,d0			;String-Anfang setzen

	*------ noch ein Argument vorrtig -------*
		addq.l	#1,a0
.FNextArg:	move.b	(a0)+,d2
		beq.s	.NoNext
		cmp.b	#32,d2
		beq.s	.FNextArg
		subq.l	#1,a0
		move.l	a0,a1			;Adr from next
.NoNext:

	*--- Stringdaten nach Arg-Zellen setzen --*
.Err:		movem.l	(a7)+,d2-d7/a0/a3/a6
		rts

*-------------------- Arexx-Message zurckgeben ------------------------------*
*----------------- d6/d7 = Returnwerte fr ReplyMessage ----------------------*
ReplyArexxMsg:	move.l	d0,-(a7)
		move.l	Rexx_Message(a5),d0
		beq.s	.NoMessage
		move.l	d0,a1			;Messageadresse holen

		moveq	#18,d7			;Fehler nach d7
		move.l	Arexx_Error(a5),d6
		bne.s	.JaFehler

	*------ d0=Lnge des Rckgabewertes -------*
		moveq	#0,d7			;Kein Returnwert
		lea	ArexxPuffer(a5),a3
		tst.b	(a3)
		bne.s	.ArexxPuffer
		tst.b	OnUseArexxPuffer(a5)
		bne.s	.ArexxPuffer
		lea	ScrollPuffer(a5),a3
.ArexxPuffer:	move.l	a3,a0
		jsr	A5BerechStringSize(a5)

*	*---- Das "|" von Playing entfernen -----*
*		lea	(a3,d0.w),a0
*		move.l	d0,d1
*		moveq	#0,d4
*.Nochmal1:	addq.l	#1,d4
*		move.b	-(a0),d2
*		cmp.b	#"|",d2
*		beq.s	.JaJetzt
*		subq.l	#1,d1
*		bne.s	.Nochmal1
*		moveq	#0,d4
*		bra.s	.Fertig
*.JaJetzt:	move.l	d4,d1
*		lea	1(a0),a1
*		lea	2(a0),a0
*		move.l	a0,a2
*		jsr	A5StringCopy2(a5)		
*.Fertig:

	*--- Testen, ob Rckgabewerte gewnscht ---*
		move.l	28(a1),d1		;Action-Flags holen
		and.l	#$20000,d1		;Flag testen,das angibt,ob Rckgabe der
		beq.s	.JaFehler		;Ergebnisse gewnscht wird

		tst.l	d0			;ReturnWerte angegeben
		beq.s	.JaFehler

		move.l	a3,a0
		*lea	ScrollPuffer(a5),a0	;Zeiger auf Rckgabestring
						;in D0 nun Lnge
		move.l	EPG_RexxSysBase(a5),a6
		jsr	_LVOCreateArgString(a6)	;Argumentstring erstellen (A0,D0)
		move.l	d0,d7			;in D7 sichern

*	*---- Das "|" von playing wieder einfgen -----*
*


.JaFehler:	move.l	Rexx_Message(a5),a1
		move.l	d6,32(a1)		;Rckgabewerte (Fehler)
		move.l	d7,36(a1)		;Rckgabewerte (String)

	 	ExecBase
		jsr	_LVOReplymsg(a6)
.NoMessage:	clr.l	Rexx_Message(a5)
		move.l	(a7)+,d0
		rts

********************** Stringvergleich **************************
**  Zeiger auf Quellwerte in a0,zu vergleichende Kette in a2   **
**  Rckgabe: 2.Argument in A1 (wenn vorhanden,sonst 0         **
**           in D0 Ergebnis,0=Ok,<>0 Fehler,Flags sind gesetzt **
*****************************************************************
StrCmp:		move.l	a0,d0
		beq.s	StrCmpErr
		move.l	a2,d0
		beq.s	StrCmpErr

		move.l	a0,a1
.Finddata:	move.b	(a1),d0		;Spaces berspringen
		beq.s	StrCmpErr	;0=Ende -> Fehler

		*-- Bit change !!!!!!!!!!!!!!!!
		cmp.b	#32,d0		* normalerweise Erkennung fr Next Arg
		bne.s	StrCmp2		* aber eigentlich nur, wenn anderer Str
					* keine 32
		addq.l	#1,a1
		bra.s	.Finddata

StrCmp2:	move.b	(a2)+,d1
		beq.s	StrCheckArgs	;0->Test bestanden,nun prfen,ob weitere
					;Argumente (z.B. Filter YES)

		cmp.b	#`A`,d1		;Kommando in Grobuchstaben
		blo.s	.NoD1Set		;umwandeln
		cmp.b	#`Z`,d1
		bhi.s	.NoD1Set
		bset	#5,d1		;bis auf Bit 5 alle bernehmen -> fertig

.NoD1Set:	move.b	(a1)+,d0	;Wert holen
		beq.s	StrCmpErr
		cmp.b	#10,d1
		beq.s	StrCmpErr
		cmp.b	#`A`,d0		;Kommando in Grobuchstaben
		blo.s	.NoBSet		;umwandeln
		cmp.b	#`Z`,d0
		bhi.s	.NoBSet
		bset	#5,d0		;bis auf Bit 5 alle bernehmen -> fertig
.NoBSet:	cmp.b	d1,d0
		beq.s	StrCmp2
StrCmpErr:	moveq	#-1,d0
		rts			;---> Error in String !!!!

	*-------- Checkt, ob noch Argumente da sein --------*
StrCheckArgs:	tst.b	(a1)
		beq.s	.KeineArgs
		cmp.b	#10,(a1)
		beq.s	.KeineArgs

		cmp.b	#32,(a1)+	;Leerzeichen ?
		bne.s	StrCmpErr	;ja,es kommen wahrscheinlich weitere Daten
		tst.b	(a1)
		bne.s	.Ok
.KeineArgs:	suba.l	a1,a1
.Ok		moveq	#0,d0
		rts


*--------------------------- normaler Stringvergleich ------------------------*
* Input: a0=String1
*	 a1=String2
* Output:d0=0 Strings gleich
*	 d0<>0 String ungleich
*-----------------------------------------------------------------------------*
EPP_StringCMP:
StrCmp3:	movem.l	d1/a0/a1,-(a7)
		move.l	a0,d0
		beq.s	.Error
		move.l	a1,d0
		beq.s	.Error
.Repeat:	move.b	(a0)+,d1
		beq.s	.Ende1
		cmp.b	#`A`,d1		;Kommando in Grobuchstaben
		blo.s	.NoD1Set	;umwandeln
		cmp.b	#`Z`,d1
		bhi.s	.NoD1Set
		bset	#5,d1		;bis auf Bit 5 alle bernehmen -> fertig
.NoD1Set:	move.b	(a1)+,d0	;Wert holen
		beq.s	.Error
		cmp.b	#`A`,d0		;Kommando in Grobuchstaben
		blo.s	.NoBSet		;umwandeln
		cmp.b	#`Z`,d0
		bhi.s	.NoBSet
		bset	#5,d0		;bis auf Bit 5 alle bernehmen -> fertig
.NoBSet:	cmp.b	d1,d0
		beq.s	.Repeat
.Error:		moveq	#-1,d0
.Return:	movem.l	(a7)+,d1/a0/a1
		tst.l	d0
		rts			;---> Error in String !!!!

.Ende1:		tst.b	(a1)
		bne.s	.Error
		moveq	#0,d0
		bra.s	.Return




	*------------- Verschlsselung 2 von Struct 2 aufheben -----------*
DecodeStruct3:	lea	TextPuffer+2600(a5),a3
		move.l	Key_Struct-(TextPuffer+2600)(a3),d0
		beq.s	.ok
		move.l	d0,a4
		move.b	EPKF_V3DecodeK(a4),Code-(TextPuffer+2600)(a3)
		move.b	EPKF_V3Decode1(a4),CodePara1(a5)
		move.b	EPKF_V3Decode2(a4),CodePara2(a5)
		move.b	EPKF_V3Decode3(a4),CodePara3-(TextPuffer+2600)(a3)
		move.b	EPKF_V3Decode4(a4),CodePara4-(TextPuffer+2600)(a3)
		move.l	Key_Struct-(TextPuffer+2600)(a3),a4
		lea	EPKF_OrtOffs(a4),a0
		moveq	#EPKF_V3ChkSum-EPKF_OrtOffs,d0
		lea	ArexxMsg(pc),a2
		lea	DecodeAndChkSum-ARexxMsg(a2),a2
		jsr	(a2)
		cmp.w	EPKF_V3ChkSum(a4),d0
		beq.w	.Ok
		clr.l	KeyFault-(TextPuffer+2600)(a3)
.Ok		rts

****** Zeichenkette (Dez/Hex/Dual) in Zahl konvertieren *******
** INPUT:  a0-Zeichenkette                                   **
** RESULT: A1-nchstes Argument (oder 0)                     **
**         D1-Ausgabewert als Dualzahl                       **
**         D0-Indikator (-1=Fehler,0=ok)                     **
***************************************************************
; Algorithmus:
; Dualzahl = (ASCII - "0")*10^n + (ASCII - "0")*10^n-1 + ... + (ASCII - "0")*10^1 + (ASCII - "0")*10^0 
; also :
; solange Zahlenwert >= "0"
; altes Ergebnis mal 10 + neuen Zahlenwert
; "0" = Ascii 48 ($30)
Getnumber:	movem.l	d2-d3,-(sp)
		move.l	a0,a1
		moveq	#0,d1
		moveq	#0,d0

		moveq	#0,d3
		cmp.b	#`-`,(a1)
		bne.s	.NoNeg	;ASCIIloop
		moveq	#1,d3
		addq.l	#1,a1

.NoNeg:		cmp.b	#"$",(a1)
		beq.s	.HexZahl
		cmp.b	#"%",(a1)
		beq.w	.DualZahl

	*------ Eine Dezimalzahl konvertieren -------*
.ASCIIloop:	move.b	(a1)+,d0
		beq.s	.null
		cmp.b	#10,d0
		beq.s	.null
		cmp.b	#`9`,d0
		bhi.w	.err
		cmp.b	#32,d0		;Space
		beq.s	.Fertig
		cmp.b	#",",d0		;Space
		beq.s	.Fertig

		sub.b	#`0`,d0
		blt	.err
		move.l	d1,d2

		add.l	d1,d1
		add.l	d1,d1
		add.l	d2,d1
		add.l	d1,d1

		add.l	d0,d1
		bra	.ASCIIloop

.null:		suba.l	a1,a1
.out:		tst.l	d3		;Zahl negativ ?
		beq.s	.nokleiner	;n
		neg.l	d1		;doch
.nokleiner:	movem.l	(sp)+,d2-d3
		moveq	#0,d0		;alles klar
		rts

.Fertig:	;addq.l	#1,a1
		tst.b	(a1)
		beq.s	.null
		bra.s	.out

	*------ Eine HexZahl konvertieren -------*
.HexZahl:	moveq	#16,d2
		addq.l	#1,a1
.NextHex:	move.b	(a1)+,d0
		beq.s	.Null
		cmp.b	#10,d0
		beq.s	.Null
		cmp.b	#" ",d0
		beq.s	.Fertig
		cmp.b	#",",d0
		beq.s	.Fertig
		subq.l	#1,d2			;zuviele Ziffern !!!
		beq.s	.Err
		cmp.b	#"0",d0
		blo.s	.err
		cmp.b	#"9"+1,d0
		blo.s	.NormalAnd
		cmp.b	#"A",d0
		blo.s	.Err
		cmp.b	#"F",d0
		bhi.s	.Err
		sub.b	#7,d0
.NormalAnd:	sub.w	#"0",d0
		rol.l	#4,d1
		or.w	d0,d1
		bra.w	.NextHex

	*------- Eine Dualzahl konvertieren ------*
.Dualzahl:	moveq	#33,d2			;berlaufzhler bei Dual
		addq.l	#1,a1
.NextDual:	move.b	(a1)+,d0
		beq.s	.Null
		cmp.b	#10,d0
		beq.s	.Null
		cmp.b	#" ",d0
		beq.s	.Fertig
		cmp.b	#",",d0
		beq.s	.Fertig
		subq.l	#1,d2			;zuviele Ziffern !!!
		beq.s	.Err
		sub.b	#"0",d0
		blt.s	.Err
		rol.l	#1,d1
		cmp.b	#1,d0
		bhi.s	.Err
		bne.s	.NoBset
		bset	#0,d1
.NoBset:	bra.w	.NextDual

	*------- Error beim Umwandeln -------*
.Err		movem.l	(sp)+,d2-d3
		moveq	#0,d1
		moveq	#-1,d0		;Error setzen
		rts




	ifeq	executable
	rts
	endc
******************************************************************************
*---------------- Auswertung einer UserProgram-Message ----------------------*
******************************************************************************
*
*	Achtung 2. Ausgang der Routine bei Exit !!!!!!!!!!!!
*	Achtung 3. Ausgang der Routine bei UserQuitEagle !!!!!!!!!!!!
*
EngineMessage:	lea	ArexxPuffer(a5),a0		;Sicherheitshalber
		move.l	d0,a1
		cmp.l	#USM_Engine,UM_Type(a1) ;Test auf Analyzer-MSG
		beq.w	.Auswertung
		cmp.l	#USM_Eagleplayer,UM_Type(a1) ;Test auf Analyzer-MSG
		beq.w	.Auswertung
		cmp.l	#USM_ExternalPrg,UM_Type(a1) ;Test auf Analyzer-MSG
		beq.s	.ExternalMSG
		bra.w	.ReplyIt3

	*--------------- Es ist ein Message angekommen ------------*
.Auswertung:	moveq	#0,d0
		move.w	UM_EngineNr(a1),d0
		cmp.w	#UPrg_Debugger,d0
		beq.s	.ExternalMSG
		jsr	A5FindUserStruct(a5)
		bne.w	.ReplyIt3
		lea	UPrgS_Message(a0),a0
				;Adr der Message fr das USERProgramm das dem
				;USERProgramm (PutMSG) geschickt wird

		move.l	UM_EnginePort(a1),UM_EnginePort(a0)
		move.l	UM_TaskAdr(a1),UM_TaskAdr(a0)
		move.l	UM_Signal(a1),UM_Signal(a0)
		move.w	UM_Enabled(a1),UM_Enabled(a0)
		move.w	UM_EngineNr(a1),UM_EngineNr(a0)

		cmp.l	#USM_Eagleplayer,UM_Type(a1) ;Test auf Analyzer-MSG
		beq.w	.Antwort

.ExternalMSG:	move.l	UM_ArgList(a1),UPrg_Struct(a5)
		clr.l	UM_ArgList(a1)
		moveq	#0,d0
		move.w	UM_Class(a1),d0
		move.l	d0,d7
		cmp.w	#USClass_SizeOf,d0
		bhi.w	.ReplyIt
		lea	.CommandTable(pc),a2
		move.w	d0,d1
		add.w	d1,d1
		move.w	(a2,d1.w),d1
		lea	.CommandTable(pc,d1.w),a2
		jmp	(a2)

.CommandTable:	dc.w	.ReplyIt-.CommandTable		;Dummy
		dc.w	.Activate-.CommandTable		;Activate
		dc.w	.DeActivate-.CommandTable	;DeActivate
		dc.w	.Exit-.CommandTable		;Exit
		dc.w	.ZipWindow-.CommandTable	;ZipWindow
		dc.w	.UnZipWindow-.CommandTable	;UnZipWindow
		dc.w	.NewEngine-.CommandTable	;NewEngine
		dc.w	.ReplyIt-.CommandTable		;GetConfig
		dc.w	.ReplyIt-.CommandTable		;NewConfig
		dc.w	.LockEP-.CommandTable		;LockEP
		dc.w	.ReplyIt-.CommandTable		;UnLockEP
		dc.w	.UserCommand-.CommandTable	;Command
		dc.w	.UserAnswer-.CommandTable	;Answer
		dc.w	.UserQuitEagle-.CommandTable	;QuitEagle
		dc.w	.ReplyIt-.CommandTable		;NewModule
		dc.w	.ReplyIt-.CommandTable		;NewSong
		dc.w	.ReplyIt-.CommandTable		;NewPreference
		dc.w	.ReplyIt-.CommandTable		;StartInt
		dc.w	.ReplyIt-.CommandTable		;StopInt
		dc.w	.ReplyIt-.CommandTable		;PlaySample
		dc.w	.ReplyIt-.CommandTable		;NewScrollText
		dc.w	.ReplyIt-.CommandTable		;NewDirectory
		dc.w	.ReplyIt-.CommandTable		;NewPlayer
		dc.w	.ReplyIt-.CommandTable		;NewEngineLoaded
		dc.w	.ReplyIt-.CommandTable		;Kill Module
		dc.w	.ReplyIt-.CommandTable		;Surface
		dc.w	.ReplyIt-.CommandTable		;ActiveSurface
		dc.w	.ReplyIt-.CommandTable		;NewAmplifierlist
		dc.w	.ShowWindow-.CommandTable	;Show
		dc.w	.HideWindow-.CommandTable	;Hide
		dc.w	.ReplyIt-.CommandTable		;SaveConfig
		dc.w	.ReplyIt-.CommandTable		;RemPlayerList
		dc.w	.ReplyIt-.CommandTable		;RemEnginesList
		dc.w	.ReplyIt-.CommandTable		;RemModulesList
		dc.w	.ReplyIt-.CommandTable		;LoadConfig
		dc.w	.ReplyIt-.CommandTable		;SetWaitPointer
		dc.w	.ReplyIt-.CommandTable		;ClearWaitPointer
		dc.w	.ReplyIt-.CommandTable		;EngineCommand
		if	(*-.CommandTable-1)/2-USClass_SizeOf
		huhu
		endc

*------------------------------------------------------------------------*
.LockEP:	moveq	#0,d6
		move.w	UM_EngineNr(a1),d6
		moveq	#0,d7			;Zhler fr Messages
		bsr.w	.ReplyIt
		jsr	A5WaitUserPorts(a5)
.LockWait:	lea	EPEnginePort,a0
		move.l	a0,a3
		ExecBase
		jsr	_LVOWaitPort(a6)
		move.l	a3,a0
		jsr	_LVOGetMsg(a6)
		tst.l	d0
		beq.w	.LockWait

	*---------- Testen auf Unlock ---------*
		move.l	d0,a1
		cmp.w	#USClass_UnLockEP,UM_Class(a1)
		bne.s	.AufStack
		cmp.w	UM_EngineNr(a1),d6
		beq.s	.UnLockEP
.AufStack:	move.l	a1,-(a7)
		addq.l	#1,d7
		bra.s	.LockWait

	*-- Nun alle inzwischen angekommenden Msg auswerten --*
.UnLockEP:	tst.l	d7
		beq.w	.ReplyIt
		move.l	(a7)+,d0
		movem.l	d0-a6,-(a7)
		jsr	A5EngineMessage(a5)
		movem.l	(a7)+,d0-a6
		subq.l	#1,d7
		bra.w	.UnLockEP



*------------------------------------------------------------------------*
.UserQuitEagle:	moveq	#1,d6			;Kennung fr PullDownHacken
		jsr	A5ChangeEngine(a5)
		moveq	#USClass_Dummy,d0

		clr.l	UM_StructAdr(a1)
		clr.w	UM_Class(a1)			;Dummy setzen

		move.l	a1,d0
		lea	EPEnginePort,a0
		cmp.l	14(a1),a0		;Reply-Port vergleichen
		beq.w	.ClearMerk
		lea	EPReplayEnginePort,a0
		cmp.l	14(a1),a0		;Reply-Port vergleichen
		beq.w	.ClearMerk

		jsr	A5CopyMessage(a5)
		jmp	A5CloseWin(a5)

*------------------------------------------------------------------------*
.UserAnswer:	bra.w	.ReplyIt

*		clr.l	EPG_Arg1(a5)
*		clr.l	EPG_Arg3(a5)
*		move.l	UM_ArgString(a1),d0
*		beq.s	.UserANoStruct
*		move.l	d0,a0
*		move.l	EPT_Result1(a0),EPG_Arg1(a5)
*		move.l	EPT_Result2(a0),EPG_Arg3(a5)
*.UserANoStruct:	move.l	d0,UPrg_Struct(a5)
*
*		move.l	UM_Command(a1),d0		;CommandNr
*		beq.s	.NoJump
*		cmp.w	#UCM_MaxID,d0
*		bhi.s	.NoJump
*
*		lea	UserCommandTabelle,a0
*		subq.l	#1,d0
*		mulu	#12,d0
*		lea	(a0,d0.l),a0			;Werte fr dieses Komm
*		moveq	#0,d0
*		move.w	8(a0),d0
*		move.l	d0,EPG_ArgN(a5)
*		move.l	A5JumpTo+2(a5),a2
*		move.l	4(a0),d0			;Auswertung (Return)
*		beq.s	.NoJump
*		add.l	d0,a2				;Langwortsize
*		movem.l	d1-a6,-(a7)
*		moveq	#0,d0
*		move.w	10(a0),d0			;Activationsnummer
*		jsr	(a2)
*		movem.l	(a7)+,d1-a6
*
*	*------ Return-Structure freigeben ------*
*.NoJump:	jsr	A5FreeCommandStruct(a5)
*		moveq	#USClass_Answer,d0
*		bra.w	.ReplyIt


	*------ Eine Command-Structure ist angekommen ------*
.UserCommand:	move.l	a1,-(a7)
		move.l	UM_UserWindow(a1),UPrg_WinHandle(a5)
		move.l	UM_Result(a1),UserType(a5)	*fr InsertList
		move.l	a1,a3

	*------- Playmememulation --------*
	* UCM_PlayMem=EPNr_MinPlayTime=91 *
	*---------------------------------*
		move.l	UM_Command(a3),d0
		cmp.w	#91,d0
		bne.s	.NoEmulation
		cmp.l	#USM_ExternalPrg,UM_Type(a1) ;Test auf Analyzer-MSG
		bne.s	.NoEmulation
		cmp.w	#-1,UM_UserNr(a1)
		bne.s	.NoEmulation
		cmp.w	#-1,UM_Signal(a1)
		bne.s	.NoEmulation
		moveq	#EPNr_PlayMem,d0

.NoEmulation:	jsr	A5TestValidEPNr(a5)
		beq.w	.CommandError
		move.l	d0,d6
		cmp.w	#EPNR_Engine,d0
		bne.s	.Command_NoMerkMsg
		move.l	a1,CloseMainWindowMSG(a5)
.Command_NoMerkMsg:

		move.l	UPrg_Struct(a5),d1
		*move.l	UM_ArgList(a3),d1	;07.11.96
		*beq.s	.CommandError
		move.l	d1,a4

	*-------------------------------------*
	* Auswertungseinsprung fr LoadConfig *
	* a1=Kommandoargs		      *
	* a4=KommandoStructure		      *
	* d6=Nummer			      *
	* Testbits gesetzt		      *
	*-------------------------------------*
		*clr.b	ScrollPuffer(a5)
		clr.l	UPrg_Result1(a5)		;Returnmeldung/Zahl
		clr.l	UPrg_Result2(a5)		;Returnmeldung/Zahl
		move.l	a4,UPrg_Struct(a5)
		move.l	a4,a1
		lea	KommandoTabelle-EPRT_SizeOf,a4
		mulu	#EPRT_SizeOf,d0
		lea	(a4,d0.w),a4
		moveq	#0,d0
		clr.l	TestBits(a5)
		move.l	d6,-(a7)
		jsr	A5KommandoAuswertung2(a5)
		move.l	(a7)+,d6
		cmp.w	#EPNr_Engine,d6
		bne.s	.Command_NoMerkMsg2		*Wenn CloseMainWindow
		tst.l	CloseMainWindowMSG(a5)		*Null ist, wurde bei
		bne.s	.CommandClr			*Engine: das Engine
		move.l	(a7)+,a1	*Msg wurde schon replayed
		sub.l	a1,a1
		bra.s	.CommandNo

.CommandClr:	clr	CloseMainWindowMSG(a5)		*auf Stack killen
.Command_NoMerkMsg2:
		jsr	A5FreeCommandStruct(a5)

	*------ Lnge des Strings berechnen ------*
		move.l	(a7)+,a1			*Message
		movem.l	d1-d5/d7-a6,-(a7)
		lea	ScrollPuffer(a5),a0
		jsr	A5BerechStringSize(a5)
		*beq.s	.CommandoNoAlloc
		add.w	#EPT_String+4,d0
		move.l	d0,d6
		jsr	A5AllocMem(a5)
		jsr	A5ClearMouse(a5)
		movem.l	(a7)+,d1-d5/d7-a6
		move.l	d0,UM_ArgString(a1)		;Structure merken
		beq.s	.CommandNo
		move.l	a1,-(a7)
		lea	ScrollPuffer(a5),a0
		move.l	d6,d1
		sub.w	#EPT_String+4,d1
		move.l	d0,a1
		move.l	UPrg_Result1(a5),EPT_Result1(a1) ;Returnmeldung/Zahl
		move.l	UPrg_Result2(a5),EPT_Result2(a1) ;Returnmeldung/Zahl
		move.l	d6,EPT_StringSize(a1)
		lea	EPT_String(a1),a1
		jsr	A5CopySendText(a5)
		bra.s	.CommandOk


.CommandError:	move.w	#EPR_ErrorInArguments,d0
.CommandOk:	move.l	(a7)+,a1				*Message
.CommandNo:	jsr	A5FreeCommandStruct(a5)
		moveq	#USClass_Answer,d0
		bra.w	.ReplyIt


*		clr.l	EPG_Arg1(a5)
*		clr.l	EPG_Arg3(a5)
*		move.l	UM_ArgString(a1),d0
*		beq.s	.UserNoStruct
*		move.l	d0,a0
*		move.l	EPT_Result1(a0),EPG_Arg1(a5)
*		move.l	EPT_Result2(a0),EPG_Arg3(a5)
*.UserNoStruct:	move.l	d0,UPrg_Struct(a5)
*		clr.l	UPrg_ReturnStruct(a5)		;Returnmeldung/Zahl
*		moveq	#EPR_ErrorInArguments,d0
*		move.l	UM_Command(a1),d1		;CommandNr
*		beq.s	.NoCommandNr
*		cmp.w	#EngineCommandAnz,d1
*		bhi.s	.NoCommandNr
*		move.l	d1,d0
*		lea	UserCommandTabelle,a0
*		subq.l	#1,d0
*		mulu	#12,d0
*		lea	(a0,d0.l),a0			;Werte fr dieses Komm
*		moveq	#0,d0
*		move.w	8(a0),d0
*		move.l	d0,EPG_ArgN(a5)
*		move.l	A5JumpTo+2(a5),a2
*		move.l	(a0),d0				;Langwortsize
*		add.l	d0,a2
*		clr.l	UPrg_Result1(a5)		;Returnmeldung/Zahl
*		clr.l	UPrg_Result2(a5)		;Returnmeldung/Zahl
*		clr.b	ArexxPuffer(a5)
*		movem.l	d1-a6,-(a7)
*		moveq	#0,d0
*		move.w	10(a0),d0			;Activationsnummer
*		jsr	(a2)
*		movem.l	(a7)+,d1-a6
*.NoCommandNr:	jsr	A5FreeCommandStruct(a5)		;Alte Struct freigeben
*		cmp.w	#MaxErrorNr,d0
*		blo.s	.ErrorOk
*		moveq	#EPR_UnknownError,d0
*.ErrorOk:	move.l	d0,UM_Result(a1)		;Fehlermeldung
*		clr.l	UPrg_WinHandle(a5)
*		move.l	UPrg_ReturnStruct(a5),d0
*		move.l	d0,UM_ArgString(a1)
*		bne.s	.StructDa
*
*	*------ Lnge des Strings berechnen ------*
*		lea	ArexxPuffer(a5),a0
*		jsr	A5BerechStringSize(a5)
*		add.w	#EPT_String+4,d0
*		move.l	d0,d6
*
*		movem.l	d1-a6,-(a7)
*		jsr	A5AllocMem(a5)
*		jsr	A5ClearMouse(a5)
*		movem.l	(a7)+,d1-a6
*		move.l	a1,a4
*		move.l	d0,UM_ArgString(a1)		;Structure merken
*		beq.s	.NoStruct
*
*	*------- Return-werte merken -------*
*		move.l	d0,a0
*		move.l	d6,EPT_StringSize(a0)
*		move.l	UPrg_Result1(a5),EPT_Result1(a0) ;Returnmeldung/Zahl
*		move.l	UPrg_Result2(a5),EPT_Result2(a0) ;Returnmeldung/Zahl
*		lea	EPT_String(a0),a1
*		move.l	d6,d1
*		sub.w	#EPT_String+5,d1
*		ble.s	.NoStruct
*		lea	ArexxPuffer(a5),a0
*		jsr	A5StringCopy2(a5)
*
*.NoStruct:	move.l	a4,a1				;Return-Message
*.StructDa:	moveq	#USClass_Answer,d0
		bra.w	.ReplyIt


	*------- Ankommende Message sagt : "EXIT" -------*
.Exit:		jsr	A5FreeCommandStruct(a5)	;Alte Struct freigeben
		clr.l	UM_EnginePort(a0)		;UserPort in my Message
		clr.l	UM_StructAdr(a1)	;no USER-Structure
		move.w	#USClass_Exit,UM_Class(a1)	;Exit setzen (vom Cli)
		move.w	#1,UM_Enabled(a1)		;User not enabled

	;	moveq	#0,d0			;Config des UserProgramms in
	;	move.w	UM_EngineNr(a1),d0	;CPN-Puffer setzen, um bei
	;	jsr	A5SetConfigInCPN(a5)	;UserBatch und NewLoad alte
	;					;Prefs zu haben

		*---- Aktuelle Prefs in UPrgS_Speichern -----*
		moveq	#0,d0
		move.w	UM_EngineNr(a1),d0
		jsr	A5WriteEnginePrefsToUPrg(a5)
.ExitNoStr:
		movem.l	d0-a6,-(sp)
		moveq	#0,d0
		move.w	UM_EngineNr(a1),d0
		jsr	A5FindEUSStruct(a5)
		bne.s	.goon			;keine EUS Struct gefunden
		move.l	a0,a4
		tst.l	EUS_Jmp(a4)		;interne AM werden (noch?)
		beq.s	.goon			;nicht gekillt

		cmp.b	#EUTY_Amplifier,eus_type(a4)
		bne.s	.goon			;kein Amplifier -> weiter

		move.l	a4,d1				;zu killender Amplifier
		cmp.l	EPG_ActiveAmplifier(A5),d1	;aktiv ?
		bne.s	.goon				;n, weiter
		jsr	A5AllesRaus(a5)
		jsr	A5GuiChanged(a5)
.goon
		movem.l	(sp)+,d0-a6

		moveq	#0,d0
		move.w	UM_EngineNr(a1),d0
		move.l	d0,-(a7)
		bsr.w	.ReplyIt3

		move.l	(a7),d0

		jsr	A5FindUserStruct(a5)
		bne.s	.ExitError
		move.l	UPrgS_Name(a0),ScrollArgs(a5)
		LA0	LNr_Quit
		jsr	A5ScrollNewText(a5)
.ExitError:	move.l	(a7)+,d0
		jsr	A5DeleteEngine(a5)		;!!!!!!!!!!!!!!!!!!!
		rts					;!!!!!!!!!!!!!!!!!!!
							;!!!!!!!!!!!!!!!!!!!
		

	*----- Es wurde ein neues Engine gestartet -----*
.NewEngine:	jsr	A5FreeCommandStruct(a5)		;Alte Struct freigeben
		move.w	UM_EngineNr(a1),d0
		cmp.w	#UPrg_Debugger,d0
		bne.s	.NoNewDebugger
		move.l	UM_Result(a1),d1
		beq.w	.Exit
		move.l	d1,a0

	*---- Neues Userprogramm (Debugger in EUS_Liste einfgen) ----*
		movem.l	a0/a1,-(a7)
		move.l	a0,a2
		moveq	#UPrg_Debugger,d0	;UserNr
		and.l	#$ffff,d0
		move.l	EUS_UserName(a2),a0	;Filename fr PDMenu
		sub.l	a3,a3			;NextArg
		sub.l	a1,a1			;UPrgS
		jsr	A5LoadEngine(a5)

		movem.l	(a7)+,a0/a1


		move.w	EUS_UserNr(a0),d0
		move.l	d0,d1
		move.w	#UPrg_Debugger,EUS_UserNr(a0)	;UserKennung setzen
		jsr	A5FindUserStruct(a5)
		bne.w	.ReplyIt3
		move.w	d1,UM_EngineNr(a1)
		move.l	d1,d0
		lea	UPrgS_Message(a0),a0
		move.l	UM_EnginePort(a1),UM_EnginePort(a0)
		move.l	UM_TaskAdr(a1),UM_TaskAdr(a0)
		move.l	UM_Signal(a1),UM_Signal(a0)
		move.w	UM_Enabled(a1),UM_Enabled(a0)
		move.w	UM_EngineNr(a1),UM_EngineNr(a0)

.NoNewDebugger:	jsr	A5FindEUSStruct(a5)
		bne.w	.ReplyIt3
		move.l	a0,a4

*	*------ Falls eine Config fr dieses Engine vorhanden ist ------*
*	*------ wird diese gestartet ------*
*		moveq	#0,d0
*		move.w	UM_EngineNr(a1),d0
*		*jsr	A5SetOneUserConfig(a5)
*

	*----------------- [][] EUS_Struct in A4 --------------------
	*--------------- Amplifier in Liste einfgen ---------------
		movem.l	d0-a6,-(sp)
		cmp.b	#EUTY_Amplifier,EUS_Type(a4)
		bne.s	.NoAmplifier

		move.w	EUS_AMPriority(a4),d0	;sollte ber die Prefs
						;schon auf richtigen
						;Wert gesetzt sein
		move.l	EPG_AmplifierList(a5),d1
		move.l	d1,d2
		beq.s	.Set1			;sollte nicht passieren
.Loop:		move.l	a0,a1
		move.l	d1,a0
		cmp.w	EUS_AMPriority(a0),d0
		bgt.s	.set2
		move.l	EUS_Identifier(a0),d1	;Next Amplifier
		bne.s	.loop			;keiner
		move.l	a4,EUS_Identifier(a0)	;also hinten an...
		bra.s	.NewAmplifier
.Set2:		cmp.l	a0,d2			;als ersten NP einfgen ?
		bne.s	.normal			;n

		move.l	a0,EUS_Identifier(a4)	;Rest hinten anhngen
		bra.s	.set1			;und neuer erster Platz

.Normal:	move.l	eus_identifier(a1),eus_identifier(a4)
		move.l	a4,eus_identifier(a1)
		bra.w	.NewAmplifier

		*-- Message an Amplifiermanager ---*
.Set1:		move.l	a4,EPG_AmplifierList(a5)	;erster NP in Liste
.NewAmplifier:	moveq	#USClass_NewAmplifierlist,d0
		jsr	A5SendeAllMessage(a5)
.noAmplifier:	movem.l	(sp)+,d0-a6


		*---- Engine Enablen ----*
		move.w	UM_EngineNr(a1),d0
		jsr	A5FindUserStruct(a5)
		bne.w	.ReplyIt3
		move.l	UPrgS_UFlags(a0),d0
		bclr	#UPrgF_Disabled,d0		*NewEngineTask da
		move.l	d0,UPrgS_UFlags(a0)		*ins PD-Menu
		jsr	A5RefreshMenu(a5)

	*----- Flags lesen und testen, ob Window geffnet werden soll ----*
		move.w	EUS_Flags(a4),d0
		btst	#EUSF_Show,d0
		beq.s	.NewEn2
		tst.b	OnIconify(a5)
		bne.s	.NewEn2

		movem.l	d0/a0,-(a7)
		move.l	UPrgS_EngineNr(a0),d0
		moveq	#1,d1			;noch disabled
		moveq	#USClass_Show,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		jsr	A5SendeOneMessage(a5)
		movem.l	(a7)+,d0/a0

.NewEn2:	btst	#EUSF_ZipWin,d0
		bne.w	.ZipWindow
		btst	#EUSF_OpenWin,d0
		bne.s	.Activate
		moveq	#USClass_Dummy,d0
		*moveq	#USClass_NewConfig,d0
		bra.w	.ReplyIt


	*------ Ankommende Message sagt : "Deactiviere mich" -----*
.DeActivate:	jsr	A5FreeCommandStruct(a5)	;Alte Struct freigeben
		moveq	#1,d6			;Kennung fr PullDownHacken
		move.l	a1,CloseMainWindowMSG(a5)
		jsr	A5ChangeEngine(a5)	;d7=class
		move.l	CloseMainWindowMSG(a5),a1
		moveq	#USClass_DeActivate,d0
		bra.w	.ReplyIt
				
	*------ Angekommende Message sagt : "Activiere mich" -----*
.Activate:	jsr	A5FreeCommandStruct(a5)	;Alte Struct freigeben
		moveq	#0,d6			;Kennung fr PullDownHacken
		jsr	A5ChangeEngine(a5)
		moveq	#USClass_Activate,d0
		bra.w	.ReplyIt

	*------ Angekommende Message sagt : "Zeige das Window" -----*
.ShowWindow:	jsr	A5FreeCommandStruct(a5)	;Alte Struct freigeben
		move.w	UM_EngineNr(a1),d0
		jsr	A5FindUserStruct(a5)		
		bne.w	.RePlyIt3
		move.l	a0,a4

		*---- Zeige Window ------*
		move.l	UPrgS_UFlags(a4),d4
		bset	#UPrgF_Show,d4
		move.l	d4,UPrgS_UFlags(a4)
		move.l	UPrgS_SubItem(a4),d0
		beq.s	.Show3
		move.l	d0,a0
		move.l	(a0),d0
		beq.s	.Show2
		move.l	d0,a0
		jsr	A5ClearMenuStrip(a5)
		bset	#0,12(a0)
.Show2:		jsr	A5SetMenuStrip(a5)
		LA0	LNr_Show
		move.l	UPrgS_Name(a4),ScrollArgs(a5)
		jsr	A5ScrollNewText(a5)
.Show3:		moveq	#USClass_Show,d0
		bra.w	.ReplyIt

	*------ Angekommende Message sagt : "Verberge das Window" -----*
.HideWindow:	jsr	A5FreeCommandStruct(a5)	;Alte Struct freigeben
		move.w	UM_EngineNr(a1),d0
		jsr	A5FindUserStruct(a5)		
		bne.w	.RePlyIt3
		move.l	a0,a4

		*---- Zeige Window ------*
		move.l	UPrgS_UFlags(a4),d4
		bclr	#UPrgF_Show,d4
		move.l	d4,UPrgS_UFlags(a4)

		move.l	UPrgS_SubItem(a4),d0
		beq.s	.Hide3
		move.l	d0,a0
		move.l	(a0),d0
		beq.s	.Hide2
		move.l	d0,a0
		jsr	A5ClearMenuStrip(a5)
		bclr	#0,12(a0)
.Hide2:		jsr	A5SetMenuStrip(a5)
		LA0	LNr_Hide
		move.l	UPrgS_Name(a4),ScrollArgs(a5)
		jsr	A5ScrollNewText(a5)
.Hide3:		moveq	#USClass_Hide,d0
		bra.w	.ReplyIt






	*------ Ankommende Message sagt : "Zip my Window" -------*
.ZipWindow:	jsr	A5FreeCommandStruct(a5)	;Alte Struct freigeben
		moveq	#0,d6			;Kennung fr PullDownHacken
		jsr	A5ChangeEngine(a5)
		moveq	#USClass_ZipWin,d0
		bra.s	.ReplyIt

	*------ Ankommende Message sagt : "UnZip my Window" -----*
.UnZipWindow:	jsr	A5FreeCommandStruct(a5)	;Alte Struct freigeben
		moveq	#0,d6			;Kennung fr PullDownHacken
		jsr	A5ChangeEngine(a5)
		moveq	#USClass_UnZipWin,d0
		bra.w	.ReplyIt

	*------- Message frs Replyen vorbereiten ------*
.ReplyIt:	move.l	a1,d1
		beq.s	.NoMSG
		move.l	a1,a0
		jsr	A5InsertStructAdr(a5)

	*----------------- Class setzen ----------------*
.ReplyIt2:	move.l	a1,d1
		beq.s	.NoMSG
		move.w	d0,UM_Class(a1)			;Dummy setzen

.ReplyIt3:	move.l	a1,d0
		beq.s	.NoMSG
		lea	EPEnginePort,a0
		cmp.l	14(a1),a0		;Reply-Port vergleichen
		beq.w	.ClearMerk
		lea	EPReplayEnginePort,a0
		cmp.l	14(a1),a0		;Reply-Port vergleichen
		beq.w	.ClearMerk

		jsr	A5CopyMessage(a5)
.NoMSG:		rts


	*-------- Eine Message ist zurckgekommen ---------*
.Antwort:	move.w	#1,NoWait(a5)		*damit bei ScrollNewText nicht
		moveq	#0,d0			*umsonst gewartet wird.
		move.w	UM_Class(a1),d0
		cmp.w	#USClass_Show,d0
		beq.s	.AntShow
		*cmp.w	#USClass_Hide,d0
		*beq.s	.AntHide
		jsr	A5FreeCommandStruct(a5)
		bra.s	.AntReplyIt3

		*---- Zeige Window ------*
.AntShow:	move.w	UM_EngineNr(a1),d0
		jsr	A5FindUserStruct(a5)		
		bne.w	.AntRePlyIt3
		move.l	a0,a4

		move.l	UPrgS_UFlags(a4),d4
		bset	#UPrgF_Show,d4
		move.l	d4,UPrgS_UFlags(a4)
		move.l	UPrgS_SubItem(a4),d0
		beq.s	.AntShow3
		move.l	d0,a0
		move.l	(a0),d0
		beq.s	.AntShow2
		move.l	d0,a0
		jsr	A5ClearMenuStrip(a5)
		bset	#0,12(a0)
.AntShow2:	jsr	A5SetMenuStrip(a5)
		LA0	LNr_Show
		move.l	UPrgS_Name(a4),ScrollArgs(a5)
		jsr	A5ScrollNewText(a5)
.AntShow3:	*bra.w	.AntReplyIt3

.AntReplyIt3:	clr.w	NoWait(a5)
		bra.w	.ReplyIt3

*		*----- Schliee Window ------*
*.AntHide:	move.w	UM_EngineNr(a1),d0
*		jsr	A5FindUserStruct(a5)		
*		bne.w	.RePlyIt3
*		move.l	a0,a4
*
*		move.l	UPrgS_UFlags(a4),d4
*		bclr	#UPrgF_Show,d4
*		move.l	d4,UPrgS_UFlags(a4)
*
*		move.l	UPrgS_SubItem(a4),d0
*		beq.s	.AntHide3
*		move.l	d0,a0
*		move.l	(a0),d0
*		beq.s	.AntHide2
*		move.l	d0,a0
*		jsr	A5ClearMenuStrip(a5)
*		bclr	#0,12(a0)
*.AntHide2:	jsr	A5SetMenuStrip(a5)
*		LA0	LNr_Hide
*		move.l	UPrgS_Name(a4),ScrollArgs(a5)
*		jsr	A5ScrollNewText(a5)
*.AntHide3:	bra.w	.ReplyIt3




	*------ Vom Analyzer replyte Message ------*
.ClearMerk:	movem.l	d0-a6,-(a7)
		move.w	UM_EngineNr(a1),d0
		ble.s	.NoUser
		tst.w	UnterwegsNr(a5)
		ble.s	.NoClearSub
		subq.w	#1,UnterwegsNr(a5)
.NoClearSub:	jsr	A5FindEUSStruct(a5)
		bne.s	.NoUser

		movem.l	a0/a1,-(a7)		*Wenn schon gequittet
		move.l	EUS_PName(a0),d0	*dann keine Pri setzen
		beq.s	.NotFound
		move.l	d0,a1
		ExecBase
		jsr	_LVOFindTask(a6)
.NotFound:	movem.l	(a7)+,a0/a1
		tst.l	d0
		beq.s	.NoUser

		moveq	#0,d0
		move.b	EUS_Priority(a0),d0
		ExecBase
		move.l	UM_TaskAdr(a1),d1
		beq.s	.NoUser
		move.l	d1,a1
		jsr	_LVOSetTaskPri(a6)
.NoUser:	movem.l	(a7)+,d0-a6
		rts




*-------------------- Copieren Message in MessagePuffer ----------------------*
CopyMessage:	move.l	d0,a1
		tst.l	d0
		beq.w	CopyMsgReturn
CopyMessage2:	move.l	a1,d0
		beq.s	CopyMSGReturn
		lea	MessagePuffer(a5),a0	;Message in alloc. Speicher
		moveq	#20-1,d1
		add.w	18(a1),d1		;Lnge der Message
		cmp.w	#MessagePuSize-1,d1
		blo.s	.Ok
		move.w	#MessagePuSize-1,d1
.Ok		jsr	A5CopyText2(a5)		;Vr=d1/a0/a1
		move.l	d0,a1
		ExecBase
		jsr	_LVOReplyMsg(a6)	;Message-Speicher freigeben
		lea	MessagePuffer(a5),a1
CopyMsgReturn:	rts


	*############################################*
	*------------- Programm beenden -------------*
	*############################################*
CloseWin:	move.l	CloseStackAdr(a5),a7
		clr.w	CliError(a5)
		move.l	#Mode_Quit,Testbits(a5)
		jsr	A5WaitMouse(a5)
		jsr	A5ClearMenuStrip(a5)
		move.w	#1,MenuVerbot(a5)
		move.w	#1,RefreshMenuVerbot(a5)
		jsr	A5AllesRaus(a5)
		jsr	A5FreeLFModule(a5)
		jsr	A5FreeAudio(a5)
		jsr	A5CloseHelp(a5)
		jsr	A5FreeDirPuffer(a5)

	*--------------- Userprogramme raushauen -----------------*

		jsr	FreeBatchPlMem

		jsr	A5CloseMainWindow(a5)
		jsr	A5RemoveApps(a5)


		jsr	A5DeleteAllEngines(a5)
		jsr	A5FreeAllEngineStructs(a5)

*		moveq	#AnzMaxEngines-1,d2
*		moveq	#1,d0
*.NextEngine:	jsr	A5DeleteEngine(a5)
*		addq.l	#1,d0
*		dbf	d2,.NextEngine

		clr.l	LoadNameAdr(a5)
		move.b	#1,KillAllPlayer(a5)
		jsr	A5FreePlayers(a5)

	ifeq	Executable
		move.l	DTG_IntuitionBase(a5),a6
		jsr	_LVOWBenchtoback(a6)
	endc

		move.l	EPInitLoadConfigLock(a5),d1
		beq.s	CloseLH
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnLock(a6)

CloseLH:	lea	EPG_LHBase(a5),a0
		jsr	A5CloseLib(a5)

		lea	EPG_IconBase(a5),a0
		jsr	A5CloseLib(a5)

		lea	EPG_XFDMasterBase(a5),a0
		jsr	A5CloseLib(a5)

		lea	EPG_PPBase(a5),a0
		jsr	A5CloseLib(a5)

		lea	EPG_XPKBase(a5),a0
		jsr	A5CloseLib(a5)

		lea	EPG_CRMBase(a5),a0
		jsr	A5CloseLib(a5)

		lea	EPG_WorkbenchBase(a5),a0
		jsr	A5CloseLib(a5)

		bsr	CloseCatalogs
		lea	EPG_LocaleBase(a5),a0
		jsr	A5CloseLib(a5)

		jsr	A5FreeOldFileReq(a5)

		moveq	#5,d0			;ScrollInterrupt closen
		lea	ScrollInterrupt,a1
		ExecBase
*	ifeq	ub_test
		jsr	_LVORemIntServer(a6)
*	endc


CloseSInter:	lea	DTG_GadToolsBase(a5),a0	;GadTools-Library closen
		jsr	A5CloseLib(a5)

		move.l	TextFont(a5),d0
		beq.s	.NoFont
		move.l	d0,a1
		move.l	DTG_GfxBase(a5),a6
		jsr	_LVOCloseFont(a6)
.NoFont:	lea	EPG_DiskFontBase(a5),a0
		jsr	A5CloseLib(a5)
		lea	DTG_GFXBase(a5),a0	;Graphics-Library closen
		jsr	A5CloseLib(a5)
CloseIntui:	lea	DTG_IntuitionBase(a5),a0	;Intuition-Library closen
		jsr	A5CloseLib(a5)
FreeMenuMem:	jsr	A5FreeDirMem(a5)
		jsr	A5FreeConfigDir(a5)

	*---------- Notify-Port freigeben -----------*
		*tst.w	Kick2On(a5)
		*beq.s	CloseDos
		jsr	A5EndNotify(a5)
		move.l	NotifyPort(a5),d0
		beq.s	CloseDos
		move.l	d0,a0
		ExecBase
		jsr	_LVODeleteMSGPort(a6)
		clr.l	NotifyPort(a5)

CloseDos:	ifeq	Executable
		move.l	OldAsmLock(a5),d1
		beq.s	.NoLock
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnLock(a6)
		endc
.NoLock	

	*------ Commodity-Port freigeben ------*
FreeCommodity:	jsr	A5CloseCommodity(a5)
		jsr	A5EndScreenNotify(a5)

	*------ Fehler beim Initialisieren des App-Ports/AppWindows -----*
		tst.w	Kick2On(a5)
		beq.s	FreeArexxPort

		lea	EPAppPort,a3		;AppPort schlieen
		move.l	a3,a1
		ExecBase
		jsr	_LVORemPort(a6)

;		lea	EPAppPort(pc),a1	;AppPort signal schlieen
		move.l	a3,a1
		moveq	#0,d0
		move.b	15(a1),d0
		jsr	_LVOFreeSignal(a6)

FreeArexxPort:	tst.l	EPG_RexxSysBase(a5)	;RexxSys-Library closen
		beq.s	FreeUserPort

		lea	Rexx_MsgPort(a5),a1
		ExecBase
		jsr	_LVORemPort(a6)
		lea	Rexx_MsgPort(a5),a1
		moveq	#0,d0
		move.b	15(a1),d0
		jsr	_LVOFreeSignal(a6)

CloseRexxSys	lea	EPG_RexxSysBase(a5),a0		;RexxSys-Library closen
		jsr	A5CloseLib(a5)


FreeUserPort:	lea	EPEnginePort,a3
		move.l	a3,a1
		ExecBase
		jsr	_LVORemPort(a6)
		move.l	a3,a1
		moveq	#0,d0
		move.b	15(a1),d0
		jsr	_LVOFreeSignal(a6)

FreeReplayEnginePort:
		lea	EPReplayEnginePort,a3
		move.l	a3,a1
		ExecBase
		jsr	_LVORemPort(a6)
		move.l	a3,a1
		moveq	#0,d0
		move.b	15(a1),d0
		jsr	_LVOFreeSignal(a6)


FreeSongEndBits:move.l	SongEndBits(a5),d0
		jsr	_LVOFreeSignal(a6)

EagleEnd:	jsr	A5CloseCommodity(a5)


		lea	EPG_CommoditiesBase(a5),a0
		jsr	A5CloseLib(a5)

		moveq	#0,d0
		move.w	CliError(a5),d0
		beq.w	.Return

	*------ Es ist ein Fehler aufgetreten ------*
		add.w	#LNr_Err_Exists-1,d0
		jsr	A5GetLocaleString(a5)
		jsr	A5BerechStringSize(a5)
		beq.s	.Return
		move.l	a0,a4
		move.l	d0,d4

		jsr	A5FreeCliStruct(a5)	*brauch erst hier freigebeben
						*werden, wegen Fehler
						*wird sonst schon frher freig
	*------ Error-Window ffnen ------*
		LA0	LNr_ErrorConWin
		move.l	a0,d1
		move.l	DTG_Dosbase(a5),a6
		move.l	#1005,d2
		jsr	_LVOOpen(a6)
		move.l	d0,d7
		beq.s	.CloseDos

	*------ FehlerText ausgeben ------*
		move.l	d0,d1
		move.l	a4,d2
		move.l	d4,d3
		jsr	_LVOWrite(a6)

		move.w	#300,d1
		jsr	_LVODelay(a6)

		move.l	d7,d1
		jsr	_LVOClose(a6)

	*------ Close Dos.Library -----*
.CloseDos:	ExecBase
		tst.l	d7
		bne.w	.return
.Return		rts


*-------------------- Key-File-Speicher wieder freigeben --------------------*
FreeKeyFile:	movem.l	d0-a6,-(a7)
		move.l	KeyAdr(a5),d0
		beq.s	.NoKey
		move.l	d0,a1
		move.l	KeySize(a5),d0
		ExecBase
		jsr	_LVOFreeMem(a6)
.NoKey:		clr.l	KeySize(a5)
		clr.l	KeyAdr(a5)
		movem.l	(a7)+,d0-a6
		rts	

*-----------------------------------------------------------------------------*
FreeCliStruct:	movem.l	d0-a6,-(a7)
		move.l	CliArgStruct(a5),d1
		beq.s	.NoCliStruct
		move.l	DTG_Dosbase(a5),d0
		beq.s	.NoCliStruct
		move.l	d0,a6
		jsr	_LVOFreeArgs(a6)
		clr.l	CliArgStruct(a5)
.NoCliStruct:	move.l	CliArgs(a5),d0
		beq.s	.NoCliArgs
		move.l	d0,a1
		move.l	#CliTemplateSize,d0
		move.l	4,a6
		jsr	_LVOFreemem(a6)
		clr.l	CliArgs(a5)
.NoCliArgs:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
OpenCatalogs:	movem.l	d1-a6,-(a7)
		moveq	#EPR_ErrorInFile,d7

		*--- Main-Catalog ffnen ---*
		tst.l	MainCatalog(a5)
		bne.s	.NoMainCatalog
		LA1	LNr_MainCatalog
		jsr	ENPP_OpenCatalog(a5)
		move.l	d0,MainCatalog(a5)

		*--- Engine-Catalog ffnen ---*
.NoMainCatalog:	tst.l	EngineCatalog(a5)
		bne.s	.NoEngineCatalog
		LA1	LNr_EngineCatalog
		jsr	ENPP_OpenCatalog(a5)
		move.l	d0,EngineCatalog(a5)

		*--- Player-Catalog ffnen ---*
.NoEngineCatalog:tst.l	PlayerCatalog(a5)
		bne.s	.AllesKlar
		LA1	LNr_PlayerCatalog
		jsr	ENPP_OpenCatalog(a5)
		move.l	d0,PlayerCatalog(a5)

.AllesKlar:	moveq	#0,d7
.Return:	move.l	d7,d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
CloseCatalogs:	movem.l	d0-a6,-(a7)

		move.l	MainCatalog(a5),d0
		jsr	ENPP_CloseCatalog(a5)
		clr.l	MainCatalog(a5)

		move.l	EngineCatalog(a5),d0
		jsr	ENPP_CloseCatalog(a5)
		clr.l	EngineCatalog(a5)

		move.l	PlayerCatalog(a5),d0
		jsr	ENPP_CloseCatalog(a5)
		clr.l	PlayerCatalog(a5)

		movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
*------------------------ AppWindow-Message auswerten ------------------------*
*-----------------------------------------------------------------------------*
AppMessage:	move.l	d0,-(a7)		;Message auf Stack legen
		move.l	d0,a1

		jsr	A5WaitMouse(a5)

		move.l	AM_Numargs(a1),d3
		move.l	am_Arglist(a1),a2
		cmp.w	#$7,am_type(a1)		:Test ob AppWindowMSG
		beq.w	.AppWindow
		cmp.w	#$8,am_type(a1)		:Test ob AppIconMSG
		beq.s	.AppIcon
		cmp.w	#$9,am_type(a1)		:Test ob AppIconMSG
		bne.w	.AppReply

	*--------- Returnmeldung von AppItem ---------*
		tst.l	d3
		bne.w	.DoVomStack
		bra.b	.AppIcon2

	*--------- Returnmeldung von AppIcon ---------*
.AppIcon:	tst.l	d3
		bne.s	.AppWindow
.AppIcon2:	clr.b	OnIconify(a5)
		jsr	A5Iconify(a5)
		jsr	A5ClearMouse(a5)
.DoVomStack:	bra.w	.AppReply

	*--------- Directory setzen ---------*
.AppWindow:	subq.l	#1,d3			; NumArgs
		beq.s	.OnlyOneIcon

	*------- Wurden mehrere Icons rbergeschoben ------*
	*--------- App-MultiSelect ----------*
	*-- Multiselect in DirPuffer bernehmen --*
		move.l	a2,a0			;MultiSelectAdr
		sub.l	a1,a1			;Adr Menufilenames
		moveq	#10,d0			;Filerequestertype = App
		move.l	d3,d1
		addq.l	#1,d1			*Arg Anz
		moveq	#0,d2			;Use Internal Puffer
		jsr	A5CreateFilesPuffer(a5)	;Selectierte Dateien ins PMenu
		bra.w	.SetMouse


.OnlyOneIcon:	move.l	(a2),d1			;Lock
		beq.w	.SetMouse
		move.l	4(a2),a0		;NamenAdr nach a0
		tst.b	(a0)			;Testen ob File oder Dir
		beq.w	.DirFirstName

	*------ Nur ein File-Icon rbergeschoben --------*
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVODuplock(a6)
		move.l	d0,d4
		move.l	d0,d1
		lea	TextPuffer(a5),a0
		move.l	a0,d2
		move.l	#DirPufferSize-2,d3
		jsr	_LVONameFromLock(a6)
		move.l	d4,d1
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d5



		tst.b	KeyOn(a5)
		beq.w	.NoArchiveDir




		move.l	a2,-(a7)
		lea	TextPuffer(a5),a0
		move.l	a0,LoadFilePath(a5)
		move.l	4(a2),a2
		jsr	A5CreateLoadPath(a5)
		move.l	(a7)+,a2
		lea	PathPuffer(a5),a0
		jsr	A5TestAufArchive(a5)
		bne.s	.NoArchiveDir

		lea	DirPuffer(a5),a1
		move.w	#DirPufferSize-2,d1
		jsr	A5StringCopy2(a5)
		jsr	A5LoadDirIn(a5)
		move.l	d5,d1
		tst.l	d0
		beq.s	.CloseLHALock




	*------- Filename setzen -------*
.NoArchiveDir:	move.l	4(a2),a0
		lea	AppFilePuffer(a5),a1
		move.l	a1,a2
		jsr	A5StringCopy(a5)
		move.l	a2,DTG_FileArrayPtr(a5)
		lea	EmptyPuffer(a5),a1		;Dir-Pointer
		move.l	d5,-(a7)
		bsr.w	LoadFremdModule
		move.l	(a7)+,d1
.CloseLHALock:	move.l	DTG_Dosbase(a5),a6
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnLock(a6)
		bra.s	.SetMouse



	*-------- Ein Dir laden ---------*
.DirFirstName:	move.l	DTG_Dosbase(a5),a6
		jsr	_LVODuplock(a6)
		move.l	d0,d5
		beq.s	.SetMouse
		move.l	d0,d1
		lea	DirPuffer(a5),a0
		move.l	a0,d2
		move.l	#DirPuffersize-2,d3
		jsr	_LVONameFromLock(a6)
		move.l	d5,d1
		jsr	_LVOUnLock(a6)		;Altes Dir unlocken

	*------------ nur ein Dir laden ----------*
		move.b	#1,DirTrotzDem(a5)
		jsr	A5LoadAutoDir(a5)


.SetMouse:	jsr	A5ClearMouse(a5)
.AppReply:	move.l	(a7)+,a1
		ExecBase
		jsr	_LVOReplyMSG(a6)
		rts


*---------------------------------------------------------------------------*
Changea6_1:	movem.l	d0-a6,-(a7)
		link	a4,#4
		moveq	#10,d0
		lea	JumpTo(pc),a0
		add.l	d1,a0
		lea	DecodeStruct1-Jumpto+$198-64-10(a0),a0
		add.l	d0,a0
		move.l	a0,60(a4)
		unlk	a4
		movem.l	(a7)+,d0-a6
		rts



*--------------------------------------------------------------------------*
KeyChangeInit:	movem.l	d0-a6,-(a7)
		jsr	A5ClearCache(a5)
		lea	ConfigAdr(a5),a4
		move.l	#KeyCheck1-KeyCheck2,d0
		moveq	#3,d4
		jsr	A5Delay(a5)
		move.l	d0,KeyDiffi1-ConfigAdr(a4)
		move.l	d0,KeyDiffi2-ConfigAdr(a4)
		moveq	#4,d0
		jsr	A5Return(a5)
		add.l	d0,d0
		add.l	EmptyPuffer-ConfigAdr(a4),d0
		lea	(a4,d0.l),a3
		add.l	#KeyCheck2,KeyDiffi1-ConfigAdr-8(a3)
		jsr	A5Return(a5)		


		lea	(a3,d0.l),a3
		sub.l	#KeyCheck1-KeyCheck2*2,KeyDiffi2-ConfigAdr-16(a3)

		moveq	#2,d0
		jsr	A5Return(a5)
		move.l	#KeyCheck3-8,KeyDiffi3-ConfigAdr-16(a3)

		moveq	#8,d0
		jsr	A5Return(a5)
		move.w	#KeyCheck4-4,KeyDiffi4-ConfigAdr-16(a3)
		add.w	d0,KeyDiffi3-ConfigAdr-16(a3)
		jsr	A5Return(a5)
		subq.w	#4,KeyDiffi4-ConfigAdr-16(a3)
		add.w	d0,KeyDiffi4-ConfigAdr-16(a3)
		movem.l	(a7)+,d0-a6
		rts


*---------------------- Warten fr GadgetOperationen ----------------------*
Delay:		movem.l	d0-a5,-(a7)
		move.l	DTG_Dosbase(a5),a6
		moveq	#1,d1
		jsr	_LVODelay(a6)
		movem.l	(a7)+,d0-a5
		rts

*------------------------ Wartet x 1/10 Sekunden --------------------------*
Delay3:		movem.l	d0-a6,-(a7)
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVODelay(a6)
		movem.l	(a7)+,d0-a6
		rts








*----------------------------------------------------------------------------*
*-------------------------- Timer-Interrupt uber Timer B --------------------*
*--------------------------    Zhlfrequenz 716 Khz      --------------------*
*----------------------------------------------------------------------------*
SetCiaBTimer:	tst.b	TimerOn(a5)
		bne.w	SetTimerReturn

	*-- Welcher Interrupt wird genutzt --*
		lea	TimerInterrupt,a1
		cmp.b	#EPNrT_CiaTiming,TimingMode(a5)
		beq.s	.CiaTimer

	*-----     Timer.device starten   -----*
		cmp.b	#EPNrT_TimerDevice,TimingMode(a5)
		bne.s	.noDevice

		bsr	OpenTimer
		bne.w	SetTimerError		;String anpassen !!!

		bra.w	TimerInitTheRest
.noDevice

	*----- VBlank-Interrupt einbinden -----*
		moveq	#5,d0				;ScrollInterrupt
		ExecBase
		jsr	_LVOAddIntServer(a6)
		bra.w	TimerInitTheRest

	*------- Interrupt einbinden --------*
.CiaTimer:	move.l	EPG_CiaBBase(a5),d0
		beq.w	SetTimerError
		move.l	d0,a6
		moveq	#0,d0
		jsr	-6(A6)
		tst.l	d0
		bne.w	SetTimerError

		move.b	#1,TimerOn(a5)

	*----- Pro-Speed Schritt = 25 Zeiteinheiten abzug/addi -----*
	*----- Setze Timer nach Speed und DTG_Timer ----------------*
SetTimer:	tst.b	TimerOn(a5)
		beq.s	SetTimerReturn

		cmp.b	#EPNrT_TimerDevice,TimingMode(a5)	 ;nur bei CiaTiming
		bne.s	.nodevice

		bsr	SetTimerDevice
		bra.s	SetTimerReturn
.nodevice
		cmp.b	#EPNrT_CiaTiming,TimingMode(a5)	 ;nur bei CiaTiming
		bne.s	SetTimerReturn
		moveq	#0,d0
		move.w	DTG_Timer(a5),d0

		move.w	EPG_Speed(a5),d1
		beq.s	.ok
		bmi.s	.lospeed

		;Speed > 0 (praktisch bis 350% des Originalwerts)
		;Formel: TimerOLD = X * (Speedwert[0...2.5] + 1 )
		mulu	#20,d0				;Genauigkeit
		add	#20,d1			;somit von 0->2.5 auf 1 -> 3.5
		divu	d1,d0
		bra.s	.ok
.lospeed
		;Speed < 0
		;Formel: TimerOLD / 1 = X / Speedwert[1->3.5
		neg	d1
		add	#20,d1
		mulu	d1,d0
		divu	#20,d0
.ok
;		mulu.w	#330,d1			;SpeedSchritt
;		sub.w	d1,d0

		move.w	#$a00,d1		;Testen ob timer-wert zu klein
		cmp.w	d1,d0
		bhi.s	.NoKleiner
		move.w	d1,d0
.NoKleiner:
		move.b	d0,$bfd400		;Timer B low
		ror.l	#8,d0
		move.b	d0,$bfd500		;Timer B high
		move.b	#%10010001,$bfde00	;Timer starten
		move.b	#$81,$bfdd00
		move.w	#$A000,$dff09a
TimerInitTheRest:move.b	#1,TimerOn(a5)
SetTimerReturn:	jsr	A5KeyTester1(a5)
		moveq	#0,d0
		rts
SetTimerError:	moveq	#EPR_CantAllocCia,d0
		rts

*----------------------------------------------------------------------------*
*-------------------------- Timer wieder schlieen --------------------------*
*----------------------------------------------------------------------------*
CloseCiaBTimer:	movem.l	d0-a6,-(a7)
		lea	TimerInterrupt,a1
		tst.b	TimerOn(a5)
		beq.s	.CloseIt

		cmp.b	#EPNrT_CiaTiming,TimingMode(a5) ;nur bei CiaTiming
		beq.s	.CiaTiming

		cmp.b	#EPNrT_TimerDevice,TimingMode(a5) ;nur bei CiaTiming
		bne.s	.VBITiming

	*-------- Es wurde Timer.device benutzt --------*

		bsr	CloseTimer
		bra.s	.CloseIt
.VBITiming:
	*-------- Es wurde VBlank-Timing benutzt --------*
		moveq	#5,d0			;ScrollInterrupt closen
		ExecBase
		jsr	_LVORemIntServer(a6)
		bra.s	.CloseIt

	*-------- Es wurde CIA-Timing benutzt --------*
.CiaTiming:	move.l	EPG_CiaBBase(a5),d0
		beq.s	.CloseIt
		move.l	d0,a6
		moveq	#0,d0
		jsr	-12(a6)
.CloseIt:	clr.b	TimerOn(a5)
		movem.l	(a7)+,d0-a6
		rts		
	

Return:		rts


;-----------------------------------------------------------------------------------
;                       Timer.device ffnen, Timer starten
;-----------------------------------------------------------------------------------
OpenTimer:
	sf	TimerOpen(A5)

	lea	TimerPort(a5),a0
	move.w	#MP_Size-1,d0
.clearport
	dbf	d0,.clearport

	lea	TimerInt(a5),a0
	move.w	#IS_Size-1,d0
.clearint
	clr.b	(a0)+
	dbf	d0,.clearint

	lea	TimerRequest(a5),a0
	move.w	#IOTV_Size-1,d0
.clearreq
	clr.b	(a0)+
	dbf	d0,.clearreq

	lea	TimerInt(a5),a0			;Softint init
	lea	TimerRoutine(pc),a1
	move.l	a1,IS_Code(a0)
	move.b	#NT_INTERRUPT,ln_Type(a0)
	move.b	#0,ln_Pri(a0)			;-32,-16,0,16,32

	lea	TimerPort(a5),a1		;Port init
	move.b	#NT_MSGPORT,ln_Type(a1)
	move.b	#PA_SOFTINT,mp_Flags(a1)
	move.l	a0,mp_SigTask(a1)		;Softint eintragen
	lea	mp_msglist(a1),a1
	Newlist	a1				;macro in Lists.i

	lea	TimerRequest(a5),a0		;Timerequest init
	lea	TimerPort(a5),a1		;
	move.l	a1,mn_ReplyPort(a0)
	move.w	#IOTV_Size,mn_Length(a0)

	lea	timer_name(pc),a0
	moveq	#UNIT_WAITECLOCK,d0
	lea	TimerRequest(a5),a1
	moveq	#0,d1
	ExecBase
	jsr	_LVOOpenDevice(a6)
	tst.l	d0
	bne	.error
	st	TimerOpen(a5)

	move.b	#1,TimerIntFlag(a5)		;Timerint: laufen

	bsr	SetTimerDevice

	bsr	StartTimer			;und los

	moveq	#0,d0
	rts
.error
	moveq	#-1,d0
	rts
;-----------------------------------------------------------------------------------
;          aktuelle Zeit holen, sowie gegebene DTG_Timer-Werte notfalls umrechnen
;-----------------------------------------------------------------------------------
SetTimerDevice:
	tst.b	TimerOpen(a5)
	beq.w	.notimer

	lea	TimerRequest(a5),a1
	move.l	io_Device(a1),a6
	lea	Timer_Lasttime(a5),a0
	jsr	_LVOReadEClock(A6)		;Return: in D0 Taktfrequenz

		moveq	#0,d1
		move.w	DTG_Timer(a5),d1

		move.w	EPG_Speed(a5),d2
		beq.s	.ok
		bmi.s	.lospeed

		;Speed > 0 (praktisch bis 350% des Originalwerts)
		;Formel: TimerOLD = X * (Speedwert[0...2.5] + 1 )
		mulu	#20,d1				;Genauigkeit
		add	#20,d2			;somit von 0->2.5 auf 1 -> 3.5
		divu	d2,d1
		bra.s	.ok
.lospeed
		;Speed < 0
		;Formel: TimerOLD / 1 = X / Speedwert[1->3.5
		neg	d2
		add	#20,d2
		mulu	d2,d1
		divu	#20,d1
.ok
		and.l	#$ffff,d1

		move.w	#$a00,d2		;Testen ob timer-wert zu klein
		cmp.w	d2,d1
		bhi.s	.NoKleiner
		move.w	d2,d1
.NoKleiner:

	cmp.l	#709379,d0			;PAL Amiga ?
	beq	.palok				;ok, Rechnungen berspringen
	cmp.l	#715909,d0			;NTSC Amiga ?
	beq	.palok				;ok, Rechnungen berspringen

	move.l	d0,d2

	ExecBase
	move.w	296(A6),d0			;attnflags(A6),d0
	and.w	#2,d0				;AFF_68020,d0;020 required
	beq	.palok


	move.l	#709379,d0		;Clock Source

	dc.l	$4c010401		*mulu.l	d1,d1:d0
	dc.l	$4c420401		*divu.l	d2,d1:d0;-> Timerval new

	move.l	d0,d1
.palok
	move.l	d1,Timer_Timerval(a5)
.notimer
	rts
;-----------------------------------------------------------------------------------
;                       Timerequest init/reinit
;-----------------------------------------------------------------------------------
;EPG_Speed fehlt
StartTimer:
	movem.l	d0-a6,-(Sp)

	lea	TimerRequest(a5),a1
	move.w	#TR_ADDREQUEST,io_Command(a1)
	clr.b	io_Flags(a1)

	move.l	Timer_Lasttime(a5),d0		;High Order
	move.l	Timer_Lasttime+4(a5),d1		;Low Order

	move.l	Timer_Timerval(A5),d2
	bne.s	.ok
	move.l	#14187,d2			;normale 50 Hz VBI
.ok
	moveq	#0,d3
	add.l	d2,d1
	addx.l	d3,d0

	move.l	d0,Timer_Lasttime(a5)
	move.l	d1,Timer_Lasttime+4(a5)
	
	move.l	d0,IOTV_TIME+EV_HI(a1)
	move.l	d1,IOTV_TIME+EV_LO(a1)

	move.l	io_Device(a1),a6
	jsr	DEV_BeginIO(A6)

	movem.l	(sp)+,d0-a6
	rts
;-----------------------------------------------------------------------------------
;                       Timer stoppen, Timer.device schlieen
;-----------------------------------------------------------------------------------
CloseTimer:
	tst.b	TimerOpen(A5)
	beq.s	.notimer

	cmp.b	#2,TimerIntFlag(A5)
	beq	.ok
	sf	TimerIntFlag(A5)		;Beenden-Flag setzen
.warten
	cmp.b	#2,TimerIntFlag(A5)
	beq	.ok

	moveq	#1,d1
	move.l	DTG_Dosbase(a5),a6
	jsr	_LVODelay(a6)

	bra	.warten
.ok
	lea	TimerRequest(A5),a0
	move.l	a0,a1
	ExecBase
	jsr	_LVOCloseDevice(a6)
	sf	TimerOpen(A5)
.notimer
	rts

;-----------------------------------------------------------------------------------
;                                 Timer Interrupt
;-----------------------------------------------------------------------------------
TimerRoutine:
	movem.l	d1-a6,-(sp)

	lea	BSSMerkPuffer,a5
	cmp.b	#2,TimerIntFlag(A5)		;Beenden-Flag gesetzt ?
	beq	.error				;ja, raus

	lea	TimerPort(a5),a0
	move.l	4.w,a6
	jsr	_LVOgetmsg(a6)
	tst.l	d0
	beq	.error				;Msg nicht da ? -> Fehler
.loop
	tst.b	TimerIntFlag(a5)		;Routine beenden ?
	beq	.error				;ja, weiter

	;--------------- Hier jetzt der UpCall fr die Interruptroutine --------------

	move.b	#1,numsofts(A5)
	jsr	SoftProgramm
	
;	move	#$f0f,$dff180

	;-----------------------------------------------------------------------------

	bsr	StartTimer			;Timer restarten

;	lea	TimerPort(a5),a0
;	move.l	4.w,a6
;	jsr	_LVOgetmsg(a6)
;	tst.l	d0
;	bne	.loop				;neue Msg da ? -> Routine wiederum abarbeiten

	movem.l	(sp)+,d1-a6
	moveq	#0,d0
	rts
.error
	move.b	#2,TimerIntFlag(A5)

	movem.l	(sp)+,d1-a6
	rts

;-----------------------------------------------------------------------------------
;                                    Strings
timer_name:	dc.b	`timer.device`,0
		cnop	0,4



********************** Auswerten der Config-Messages ***********************
**** Kommandos (Vergleichswerte unbedingt groschreiben !!!)		****
**** Offset to String,Arg-Type1.b,Arg-Type2.b,Offset to AuswertProggy	****
**** dann CLI/Rexx.b/KickStart.b, 4 Offsets/Args fr Auswertproggy	****
****************************************************************************
**** ARG Type = 0 no Argument						****
****		 1 Argument=String					****
****		 2 Argument=Zustand (Yes/No)				****
****		 3 Argument=Zahl (Hex/Dez/Dual)				****
****	Bit 7=1 Argument mu da sein					****
**** ------------------------------------------------------------------ ****
**** CLI/Rexx  Bit 0 = 1 kein Arexx					****
****		Bit 1 = 1 kein CLI					****
****		Bit 2 = 1 keine Config					****
****		Bit 3 = 1 kein ToolType					****
****		Bit 4 = 1 kein Engine-Action				****
****************************************************************************
ArexxMSG:	clr.b	ArexxPuffer(a5)
		clr.b	OnUseArexxPuffer(a5)
		move.l	d0,Rexx_Message(a5)	;Adresse der Message sichern
		move.l	d0,a0
		move.l	40(a0),a0	;Zeiger auf Kommando als Zeichenkette
		moveq	#Mode_Arexx,d0

		move.b	#1,NurEinString(a5)
		jsr	A5KommandoAuswertung(a5)
		clr.b	NurEinString(a5)

		clr.l	Arexx_Error(a5)
		tst.l	d0
		beq.s	.ReplyMessage

		clr.b	OnUseArexxPuffer(a5)
		jsr	A5ScrollNewFehler(a5)
		cmp.w	#EPR_CommandError,d0
		beq.s	.BigFehler
		cmp.w	#EPR_ErrorinArguments,d0
		bne.s	.ReplyMessage
.BigFehler:	move.l	#10,Arexx_Error(a5)		;(RC-Error)
.ReplyMessage:	bsr.w	ReplyArexxMsg
		rts



*-----------------------------------------------------------------------------*
* Diese Routinen dienen zum Auswerten von Arexx & Configstrings!              *
* Input:  d0=TestBits							      *
*	  a0=Kommandostring						      *
* Output: d0=Fehler oder NULL						      *
*-----------------------------------------------------------------------------*
* interne Registervergabe:
* a0/a1/d0/d1	= zum Arbeiten
* a2/a3/d0/d1	= Input fr Specialroutine
* a4		= KommandoTabelle
* a5		= Puffer
* a6		= ?
*-----------------------------------------------------------------------------*
KommandoAuswertung:
		move.l	d0,TestBits(a5)
		moveq	#0,d6		;Eagleplayernummer
		clr.b	ArexxPuffer(a5)


	*------ Kommando in der Tabelle finden -----*
		lea	KommandoTabelle-EPRT_SizeOf,a4
.NextString:	addq.l	#1,d6			;Eagleplayernummer erhhen
		lea	EPRT_SizeOf(a4),a4
		cmp.w	#-1,EPRT_Proggy(a4)
		beq.w	KA_ErrorInArgs
		move.w	EPRT_StrLNr(a4),d0
		beq.s	.NextString
		move.l	a0,-(a7)
		jsr	A5GetLocaleString(a5)
		move.l	(a7)+,a0
		tst.l	d0
		beq.s	.NextString
		move.l	d0,a2
		jsr	A5StrCmp(a5)
		bne.s	.NextString

*-------------------------------------*
* Auswertungseinsprung fr LoadConfig *
* a1=Kommandoargs		      *
* a4=KommandoStructure		      *
* d6=Nummer			      *
* Testbits gesetzt		      *
*-------------------------------------*
KommandoAuswertung2:
		cmp.w	#EPNr_LastInternal,d6
		ble.s	.NummerOk
		moveq	#0,d6


	*--- Ist Kommando berhaupt erlaubt ---*
.NummerOk:	moveq	#EPR_InvalidNr,d0
		moveq	#0,d1
		move.b	EPRT_Flags(a4),d1
		and.l	TestBits(a5),d1
		bne.w	KA_KeyError


	*----------- Auf Key testen -----------*
		move.b	EPRT_Flags(a4),d0
		btst	#EPRTF_Key,d0
		beq.s	.ArgAuswertung
		tst.b	KeyOn(a5)
		bne.s	.ArgAuswertung
		moveq	#EPR_FunctionNotEnabled,d0
		cmp.l	#Mode_Config,TestBits(a5)
		bne.s	KA_KeyError
		moveq	#0,d0
		bra.s	KA_KeyError
		

	*############### Argumente auswerten ####################*
.ArgAuswertung:	moveq	#0,d2
		moveq	#0,d3
		sub.l	a2,a2
		sub.l	a3,a3
		move.b	EPRT_Args(a4),d0	;-> d0=ArgFlags a1=ArgString
		bsr	GibArg			;>- d0=Fehler oder Null
		bne.s	KA_KeyError		;>- d1=Zahl,Zustand,StringSize
		move.l	d1,d2			;>- a0=StringBeginn
		move.l	a0,a2			;>- a1=Start of next Arg

		move.b	EPRT_Args(a4),d0	;-> d0=ArgFlags
		ror.l	#4,d0			;-> a1=ArgString
		bsr	GibArg			;>- d0=Fehler oder Null
		bne.s	KA_KeyError		;>- d1=Zahl,Zustand,StringSize
		move.l	d1,d3			;>- a0=StringBeginn
		move.l	a0,a3

	*--------- Nochmal auf Key testen -------*
		lea	EPG_ArgN(a5),a0
		move.b	EPRT_Flags(a4),d0
		btst	#EPRTF_Key,d0
		beq.s	.OkJump
		tst.b	KeyOn(a5)
		bne.s	.OkJump
		moveq	#EPR_FunctionNotEnabled,d0
		cmp.l	#Mode_Config,TestBits(a5)
		bne.s	KA_KeyError
		moveq	#0,d0
		bra.s	KA_KeyError

	*############### Nun ins Programm hpfen #################*
	* d0	= Eagleplayernummer				  *
	* d1	= Specialflags					  *
	* a1	= NextArg					  *
	* a2/d2 = Arg1						  *
	* a3/d3 = Arg2						  *
	*#########################################################*
.OkJump:	move.w	d6,d0
		moveq	#0,d1

		tst.b	KeyOn-EPG_ArgN(a0)
		beq.s	.Rexx_KeyOk
		tst.l	Key_Struct-EPG_ArgN(a0)
		beq.w	JaGuru3
.Rexx_KeyOk:	movem.l	d1-a6,-(a7)
		jsr	A5JumpTo(a5)
		movem.l	(a7)+,d1-a6		;Bei KM_Quit auch ndern
KA_KeyError:	move.l	d0,ConfigError(a5)	;normale ErrorMeldung !!!
		rts

KA_ErrorInArgs:	moveq	#EPR_ErrorInArguments,d0
		bra.s	KA_KeyError



*-----------------------------------------------------------------------------*
*--------- Wandle ein Kommandoarg in zu verarbeitende Werte um   -------------*
* Input: d0=Argflags							      *
*	 a1=Kommando							      *
*	 d6=Nummer
* Output:d0=Fehler oder Null						      *
*	 d1=Zahl,StringSize,Zustand oder Null				      *
*	 a0=Stringadr oder NULL						      *
*	 a1=NextArg							      *
*-----------------------------------------------------------------------------*
GibArg:		movem.l	d2-d7/a2-a6,-(a7)

		move.b	NurEinString(a5),d1	\
		move.l	d1,-(a7)		 \
		cmp.w	#EPNr_AscEngine,d6	  > added damit AscEngine geht
		bne.s	.NoOnlyEinString	 /
		clr.b	NurEinString(a5)	/

.NoOnlyEinString:
		sub.l	a0,a0
		moveq	#0,d1
		and.w	#EPRTAB_String1!EPRTAB_Zustand1!EPRTAB_Zahl1!EPRTAB_Must1,d0
		beq.s	.DasWars

		move.l	a1,d1		;weiteres Argument ? ("YES" oder "NO")
		bne.s	.WerteAus	;nein ,Fehler
		btst	#EPRTAF_Must1,d0
		beq.s	.DasWars
.ErrorinArgs:	moveq	#EPR_ErrorInArguments,d0	;Must1 fehlt !
		bra.s	.rts
.DasWars:	moveq	#0,d0
.rts:
		move.l	(a7)+,d2		;added damit AscEngine geht
		move.b	d2,NurEinString(a5)	;added damit AscEngine geht

		movem.l	(a7)+,d2-d7/a2-a6
		tst.l	d0
		rts

.WerteAus:	and.w	#EPRTAB_String1!EPRTAB_Zustand1!EPRTAB_Zahl1,d0
		beq.s	.ErrorInArgs

		tst.l	UPrg_Struct(a5)
		bne.w	.EngineStructure

		subq.w	#1,d0
		beq.w	.TestaufString
		subq.w	#1,d0
		bne.w	.TestaufZahlWert

	*------------- Argument auf Zustand testen ---------------*
		move.l	a1,a0		;Zeiger auf 2.Argument

	*----- Test auf Hi-Zustand -----*
		LA2	LNr_Yes		;ist 2.Argument "YES" ?
		jsr	A5StrCmp(a5)
		beq.w	.YesArgument
		LA2	LNr_On		;ist 2.Argument "ON" ?
		jsr	A5StrCmp(a5)
		beq.w	.YesArgument
		LA2	LNr_1		;ist 2.Argument "1" ?
		jsr	A5StrCmp(a5)
		beq.w	.YesArgument

	*------ Test auf Low-Zustand -----*
		LA2	LNr_No		;ist 2.Argument "NO" ?
		jsr	A5StrCmp(a5)
		beq.w	.NoArgument
		LA2	LNr_Off		;ist 2.Argument "OFF" ?
		jsr	A5StrCmp(a5)
		beq.w	.NoArgument
		LA2	LNr_0		;ist 2.Argument "0" ?
		jsr	A5StrCmp(a5)
		beq.w	.NoArgument

	*--------- Test auf Toggle --------*
		cmp.l	#Mode_Config,TestBits(a5)
		beq.w	.ErrorInArgs
		LA2	LNr_Toggle	;ist 2.Argument "Toggle" ?
		jsr	A5StrCmp(a5)
		beq.w	.ToggleArgument
		LA2	LNr_Toggle2	;ist 2.Argument "-1" ?
		jsr	A5StrCmp(a5)
		bne.w	.ErrorInArgs
.ToggleArgument:sub.l	a0,a0
		moveq	#-1,d1
		bra.w	.DasWars

.NoArgument:	sub.l	a0,a0
		moveq	#0,d1
		bra.w	.DasWars

.YesArgument:	sub.l	a0,a0
		moveq	#1,d1
		bra.w	.DasWars

	*----------- Test auf Zahlwert ------------*
	***** Zeichenkette in Zahl konvertieren ****
	** INPUT:  a0-Zeichenkette                **
	** RESULT: A1-nchstes Argument (oder 0)  **
	**         D1-Ausgabewert als Dualzahl    **
	**         D0-Indikator (-1=Fehler,0=ok)  **
	********************************************
.TestaufZahlWert:move.l	a1,a0		;Zeiger auf 2.Argument
		jsr	A5Getnumber(a5)	;Zeichenkette in Long-Zahl umwandeln
		tst.l	d0
		bne.w	.ErrorInArgs
		sub.l	a0,a0
		bra.w	.DasWars

	*------------ Test auf String -------------*
	********** Check auf Zeichenkette **********
	** INPUT: a1 = Zeichenkette (mit Leerz.)  **
	** OutPut:a1 = Start of next String	  **
	**	  d0 = Start of String		  **
	**	  d1 = Length of String		  **
	********************************************
.TestAufString:	jsr	A5FindFileName(a5)
		tst.l	d0
		beq.w	.ErrorInArgs
		move.l	d0,a0
		bra.w	.DasWars

	*- Die Argumente werden aus einer EngineStructure geholt -*
.EngineStructure:
		sub.l	a0,a0
		move.l	ENA_Arg1(a1),d1		* Zustand, Zahl oder Strsize
		subq.w	#1,d0
		bne.w	.EngineArgOk
		tst.l	d1
		beq.w	.ErrorinArgs
		move.l	ENA_Arg2(a1),d0
		beq.s	.MitENAString
		move.l	d1,a0
		move.l	d0,d1
		bra.s	.EngineArgOk
.MitENAString:	lea	ENA_String(a1),a0
		jsr	A5BerechStringSize(a5)
		*cmp.l	d0,d1			*Achtung PubScreenManager
		*bne.w	.ErrorInArgs
.EngineArgOk:	move.l	ENA_Next(a1),a1
		bra.w	.DasWars


*----------------------------------------------------------------------------*
* Testet, ob die Nummer in d0 berhaupt erlaubt ist			     *
* Input: d0=EPNr.							     *
* Ouput: d0=EPNr oder NULL						     *
*----------------------------------------------------------------------------*
TestValidEPNr:	move.l	d1,-(a7)
		cmp.w	#EPNr_LastInternal,d0
		blo.w	.NummerOk

		*----------- Player testen -----------*
		cmp.w	#EPNr_FirstPlayer,d0
		blt.s	.NoPlayer
		move.l	PlayerAnz(a5),d1
		add.w	#EPNR_FirstPlayer,d1
		cmp.w	d1,d0
		blt.s	.NummerOk

		*----------- Engine testen ----------*
.NoPlayer:	cmp.w	#EPNr_FirstEngine,d0
		blt.s	.NoEngine
		cmp.w	#EPNr_LastEngine,d0
		blt.s	.NummerOk

		*------ Module testen ------*
.NoEngine:	cmp.w	#EPNr_FirstModule,d0
		blt.s	.NoModule
		move.l	EPG_Entries(a5),d1
		add.w	#EPNr_FirstModule,d1
		cmp.w	d1,d0
		blt.s	.NummerOk
.NoModule:	moveq	#0,d0
.NummerOk:	move.l	(a7)+,d1
		tst.l	d0
		rts



****************************************************************************
****		In die entsprechenden Unterprogramme springen		****
****************************************************************************
	*############### Nun ins Programm hpfen #################*
	* d0	= Eagleplayernummer				  *
	* d1	= Specialflags					  *
	* a1	= NextArg					  *
	* a2/d2 = Arg1						  *
	* a3/d3 = Arg2						  *
	*#########################################################*
JumpTo:		*jsr	A5TestValidEPNr(a5)
		*beq.s	.JumpToArgError
		movem.l	d0-d3/a0-a3,JumpToMerk(a5)
		lea	KommandoTabelle,a4

		lea	TextPuffer(a5),a0
		tst.b	KeyOn-TextPuffer(a0)		;KeyON modifiziert ???
		beq.s	.JumpOk
		tst.l	Key_Struct-TextPuffer(a0)
		beq.w	JaGuru2

.JumpOk:	sub.l	a0,a0
		tst.l	d0
		beq.w	.JumpToArgError

		cmp.w	#EPNr_LastInternal,d0
		blo.w	.JumpNow

	*----------- Player aufgerufen -----------*
		cmp.w	#EPNr_FirstPlayer,d0
		blo.s	.NoPlayer
		cmp.w	#EPNr_LastPlayer,d0
		bhi.s	.NoPlayer
		sub.w	#EPNr_FirstPlayer,d0
		move.w	d0,d2			;Nummer in d1
		move.w	#EPNr_Player,d0
		bra.s	.D2IsArg

	*----------- Engine aufgerufen ----------*
.NoPlayer:	cmp.w	#EPNr_FirstEngine,d0
		blo.s	.NoEngine
		cmp.w	#EPNr_LastEngine,d0
		bhi.s	.NoEngine
		sub.w	#EPNr_FirstEngine-1,d0
		move.w	d0,d2
		move.w	#EPNr_Engine,d0
		bra.s	.D2isArg

	*------ Modul ber PullmDown-Men aufgerufen ------*
.NoEngine:	cmp.w	#EPNr_FirstModule,d0
		blo.s	.NoModule
		cmp.w	#EPNr_LastModule,d0
		bhi.s	.NoModule
		*sub.w	#EPNr_FirstModule,d0
		move.w	d0,d2
		move.w	#EPNr_Module,d0
		bra.s	.D2isArg

	*-------- Nummer fr externes Gui-Menu ----*
.NoModule:	cmp.w	#EPNr_FirstExternal,d0
		blo.s	.NoExternal
		cmp.w	#EPNr_LastExternal,d0
		bhi.s	.NoExternal

		jsr	A5GetMainWindowTags(a5)
		beq.w	.JumpToArgError
		move.l	d0,-(a7)		;Tagliste auf Stack
		move.l	#EUT_Command,-(a7)	;Tag auf Stack
		movem.l	JumpToMerk(a5),d0-d3/a0-a3
		jsr	A5UserCallUp(a5)
		addq.l	#8,a7
		move.l	PufferAdr(pc),a5
		beq.w	.JumpToEnd		;beq=kein Tag
		tst.l	d0
		bne.w	.JumpToError
		bra.w	.JumpToEnd



.NoExternal:

	*--------- KommandoTabelleadr holen ---------*
.D2IsArg:	and.l	#$ffff,d2
		move.l	d2,JumpToMerk+8(a5)
.JumpNow:	cmp.w	#EPNr_LastInternal,d0
		bhi.w	.JumpToArgError
		and.l	#$ffff,d0
		moveq	#0,d6
		move.w	d0,d6
		mulu	#EPRT_SizeOf,d0
		lea	-EPRT_SizeOf(a4,d0.l),a0

		tst.b	OnGuiMessage(a5)
		beq.s	.NoHelp
		cmp.w	#EPNR_Help,d6
		beq.s	.NoHelp
		tst.b	OnHelp(a5)
		bne.s	.HelpMe

	*------ Testbits holen /Key testen --------*
.NoHelp:	moveq	#0,d1
		move.b	EPRT_Flags(a0),d1		;verstt der Aufruf
		and.l	TestBits(a5),d1			;gegen TestBits ?
		bne.s	.JumpToArgError
		move.b	EPRT_Flags(a0),d0
		btst	#EPRTF_Key,d0
		beq.s	.KeyOk
		moveq	#-5,d0
		lea	A5JumpTo(a5),a4
		tst.b	KeyOn-A5JumpTo(a4)
		bne.s	.KeyOk
		cmp.l	#Mode_Config,TestBits(a5)	;NEWR
		bne.s	.KeyOk
		add.w	#EPR_FunctionNotEnabled+5,d0
		bra.s	.JumpToError


.KeyOk:		jsr	A5NervRequest1(a5)
		moveq	#0,d0
		move.b	EPRT_Flags(a0),d0		*Preference extra
		btst	#EPRTF_Switch,d0
		bne.s	.Preferences

		move.b	EPRT_Flags(a0),d0		*StringGadgets extra
		btst	#EPRTF_StringGadget,d0
		bne.w	.StringGadgets

.SG_Jump:	moveq	#0,d0
		move.w	EPRT_Proggy(a0),d0
		beq.s	.JumpToEnd
		*ext.l	d0			;absolut addieren !!!
		move.l	d0,a0
		add.l	A5JumpTo+2(a5),a0
		pea	.JumptoEnd(pc)
		pea	(a0)
		movem.l	JumpToMerk(a5),d0-d3/a0-a3
		rts

.HelpMe:	move.l	a0,a4
		movem.l	JumpToMerk(a5),d0-d3/a0-a3
		jsr	A5HelpMe(a5)
		bra.s	.JumpToEnd

	*------------ Rcksprung fr Userprogramme -------------*
.JumpToArgError:moveq	#EPR_ErrorInArguments,d0
.JumpToError:	jsr	A5ScrollNewFehler(a5)
.JumptoEnd:	jsr	A5ClearMouse(a5)
		tst.l	d0
		rts


	*-------------------------------------------------------*
	*----- Die eingestellte Preference wird gendert.  -----*
	* Input: d0=Nummer					*
	*	 d2=Zustand 0=Aus 1=Ein				*
	* Ouput: --						*
	*-------------------------------------------------------*
.Preferences:	move.l	a0,-(a7)

	*cmp.w	#epnr_epdir,d6
	*bne.s	.NoEP
	*nop
.NoEP		move.w	EPRT_StrLNr(a0),d5
		move.w	EPRT_Status(a0),d3		* in Merkzelle setzen
		beq.s	.JumpToArgError

		cmp.b	#-1,d2
		bne.s	.NoToggle
		moveq	#1,d2
		move.b	(a5,d3.w),d7
		beq.s	.NoToggle
		moveq	#0,d2
.NoToggle:	cmp.b	(a5,d3.w),d2
		beq.w	.NoChange
		move.b	d2,(a5,d3.w)

	*-------- Flag in EPG_SomePrefs setzen -------*
		moveq	#0,d7
		move.w	EPRT_SaveConfig(a0),d7
		beq.s	.NoFlag
		move.l	EPG_SomePrefs(a5),d3
		bclr	d7,d3
		tst.b	d2
		beq.s	.NoSetFlag
		bset	d7,d3
.NoSetFlag:	move.l	d3,EPG_SomePrefs(a5)

	*-------- Hilfsproggy aufrufen -------*
.NoFlag:	moveq	#0,d7
		move.w	EPRT_Proggy(a0),d7
		beq.s	.NoJump
		*ext.l	d7
		add.l	A5JumpTo+2(a5),d7
		move.l	d7,a1
		movem.l	d1-a6,-(a7)
		jsr	(a1)
		movem.l	(a7)+,d1-a6
		tst.l	d0
		beq.s	.NoJump
		move.l	(a7)+,a0
		bra.s	.JumpToError

	*----------- Menus ndern ------------*
.NoJump:	move.l	d6,d0
		jsr	A5GetMenuItemAdr(a5)
		bne.s	.NoItem1
		move.b	12(a0),d3
		and.b	#1,d3
		cmp.b	d3,d2
		beq.s	.NoItem1
		jsr	A5ClearMenuStrip(a5)
		bclr	#0,12(a0)
		or.b	d2,12(a0)
		jsr	A5SetMenuStrip(a5)

	*-------- Menustrukture setzen -------*
.NoItem1:	move.w	#MenuItemAnz,d1
		lea	MenuItems-MEP_SizeOf,a0
.NoItem1Next:	subq.w	#1,d1
		beq.s	.NoItem
		lea	MEP_SizeOf(a0),a0
		moveq	#0,d0
		move.b	MEP_ActionNr(a0),d0		*da d0.b mehrdeutig ist
		cmp.b	d6,d0				*mu .w verglichen wer.
		bne.s	.NoItem1Next
		bclr	#1,MEP_Flags(a0)
		tst.w	d2
		beq.s	.NoItem
		bset	#1,MEP_Flags(a0)

	*------ Engines benachrichtigen -----*
		*--- Gui ---*
.NoItem:	movem.l	d1/d2/a3,-(a7)
		jsr	A5GetMainWindowTags(a5)
		beq.s	.NoTags
		move.l	d0,-(a7)		;Tagliste auf Stack
		move.l	d6,d0			;EPNr
		ext.l	d0
		move.l	d2,d1			;ein=1/Aus=0
		moveq	#-1,d2			;Nicht ndern
		move.l	#EUT_ChangePrefs,-(a7)	;Tag auf Stack
		jsr	A5UserCallUp(a5)
		addq.l	#8,a7
		move.l	PufferAdr,a5
.NoTags:	movem.l	(a7)+,d1/d2/a3

		*--- Andere Engines ---*
		cmp.l	#Mode_Config,TestBits(a5)
		beq.w	.NoChange
		move.l	#USClass_NewPreference,d0
		move.l	d6,SendeAllCommand(a5)
		jsr	A5SendeAllMessage2(a5)
		clr.l	SendeAllCommand(a5)






	*--------- ScrollText bauen ----------*
.NoChange:	move.l	(a7)+,a0
		move.w	EPRT_LNr(a0),d0
		ble.s	.NoText
		jsr	A5GetLocaleString(a5)
		move.l	a0,ScrollArgs(a5)
		LA0	LNr_Off_Extern
		tst.l	d2
		beq.s	.TextOk
		LA0	LNr_On_Extern
.TextOk:	jsr	A5ScrollNewText(a5)
.NoText:	moveq	#0,d0				;Kein Error
		bra.w	.JumpToEnd
* wird von Stringgadget benutzt !!!

	*-------------------------------------------------------*
	*-- Alle Routinen, die Stringgadgets nutzen, werden   --*
	*-- hier verwaltet.					*
	* Input: d0=Nummer					*
	*	 d2=Zustand 0=Aus 1=Ein				*
	* Ouput: --						*
	*-------------------------------------------------------*
.StringGadgets:	move.l	a0,a4
		move.b	EPRT_Args(a4),d6
		movem.l	JumpToMerk(a5),d0-d3/a0-a3	;Args holen
		moveq	#0,d7

		cmp.w	#EPNr_PlayTime,JumpToMerk+2(a5)
		bne.s	.SG_NoPlayTime
		tst.l	d2
		bge.w	.SG_NoPlayTime
		moveq	#0,d2
		bra.w	.DontStringGadget

.SG_NoPlayTime:	tst.l	d2
		bne.w	.DontStringGadget
		cmp.l	d2,a2
		bne.w	.DontStringGadget
		cmp.l	#Mode_Config,TestBits(a5)
		beq.w	.NoText				*.JumpToArgError

*------------------------- Stringgadget fr Mainwindow ----------------------*
*-----	d0 = Mode 0=Ziffern 1=Text !2=Invisible				-----*
*-----  d1 = MinValue (bei Ziffern)					-----*
*-----	d2 = max. Lnge des Strings oder MaxValue			-----*
*-----	a0 = Puffer fr Text oder ZellenAdr				-----*
*-----	a1 = TextFmT							-----*
*-----  a2 = TextFmtArgs						-----*
*-----	a3 = Requestertitle						-----*
*----- Output:								-----*
*-----	d0 = Ergebnis 0=Ok, sonst Error					-----*
*-----  d1 = Anzahl der eingebenen Zeichen oder Long			-----*
*----------------------------------------------------------------------------*
		moveq	#0,d0
		add.b	EPRT_Reserved(a4),d0
		add.w	#LNr_SG_Publicscreen,d0
		jsr	A5GetLocaleString(a5)		*InfoText
		move.l	a0,ScrollArgs(a5)
		move.w	EPRT_SaveConfig(a4),d2		*MaxValue oder MaxLen
		move.w	EPRT_Status(a4),d3
		btst	#EPRTAF_Zahl1,d6
		bne.s	.SG_Zahl

		*--- Mode String ----*
		cmp.w	#TextPufferSize-2,d2		*max Lnge
		blo.s	.SG_SizeOK
		move.w	#TextPufferSize-2,d2
.SG_SizeOk:	move.l	d2,d1
		lea	(a5,d3.w),a0
		lea	TextPuffer(a5),a1
		jsr	A5StringCopy2(a5)
		moveq	#EPTRB_String,d0		*Mode=Text
		cmp.w	#EPNr_Password,JumpToMerk+2(a5)
		bne.s	.SG_LosJetzt
		moveq	#EPTRB_Invisible!EPTRB_Center!EPTRB_String,d0
		clr.b	TextPuffer(a5)
		bra.s	.SG_LosJetzt

		*--- Mode Ziffern ---*
.SG_Zahl:	move.l	(a5,d3.w),d0
		move.l	d0,TextPuffer(a5)		*Def setzen
		moveq	#EPTRB_Zahl,d0			*Mode=Ziffern
		moveq	#1,d1
		cmp.w	#EPNr_Rasterlines,JumpToMerk+2(a5)
		beq.s	.SG_LosJetzt2
		cmp.w	#EPNr_DBFLoops,JumpToMerk+2(a5)
		beq.s	.SG_LosJetzt2
.SG_Losjetzt:	moveq	#0,d1				*MinValue
.SG_LosJetzt2:	LA1	LNr_PleaseEnter			*TextFmt
		lea	TextPuffer(a5),a0		*Puffer
		lea	ScrollArgs(a5),a2
		sub.l	a3,a3
		jsr	A5GetStringGadget(a5)
		sub.l	a2,a2
		tst.l	d0
		bne.w	.JumpToError
		move.l	d1,d2				;Anz der Zeichen ?
		move.l	d1,d0

	*------- Stringsize berechnen -------*
		move.w	EPRT_SaveConfig(a4),d1
		lea	TextPuffer(a5),a2
		btst	#EPRTAF_Zahl1,d6
		beq.s	.DontStringGadget		*--> Stringmode
		move.l	(a2),d2
		sub.l	a2,a2

.DontStringGadget:
		move.l	a4,a0
		btst	#EPRTAF_Zahl1,d6
		bne.s	.NoCopy
		move.w	EPRT_Status(a4),d0
		lea	(a5,d0.w),a1
		move.l	a2,a0
		move.l	d2,d1
		subq.w	#1,d1
		cmp.w	EPRT_SaveConfig(a4),d2
		blo.s	.StringSizeOk
		move.w	EPRT_SaveConfig(a4),d1
.StringSizeOk:	jsr	A5StringCopy2(a5)
.NoCopy:	move.l	d2,JumpToMerk+8(a5)
		move.l	a2,JumpToMerk+24(a5)
		move.l	a4,a0
		bra.w	.SG_Jump


	*------------- Decodestruct3 ------------*
InitLoadConfig:	moveq	#64,d1
		ExecBase				;bsr.w	DecodeStruct3
		jsr	A5Changea6_2(a5)
		move.l	DummyAdr(a5),a1
		move.l	#5400,d0
		jsr	-210(a6)
		clr.l	DummyAdr(a5)

		*moveq	#EPNr_LoadConfig,d6		*aus CLI-Tooltypes
		moveq	#LNr_Str_Config,d0		*Configpfad holen
		jsr	A5GetArgs(a5)
		bne.s	.LoadEnvFile

		*------ String rauslesen ------*
		* >> a1=Nchsten Arg		*
		* Out: d1=Size
		*      a0=Adr
		moveq	#EPRTAB_String1!EPRTAB_Must1,d0
		move.l	a2,-(a7)
		lea	TextPuffer(a5),a1
		bsr	GibArg			;>- d0=Fehler oder Null
		move.l	(a7)+,a2
		tst.l	d0
		bne.w	.LoadEnvFile		;>- d1=Zahl,Zustand,StringSize
		move.l	a0,a3
		move.l	d1,d3
		addq.l	#2,d3
		move.l	d3,d0
		jsr	A5AllocMem(a5)
		beq.s	.LoadEnvFile
		jsr	A5FreeConfigDir(a5)
		move.l	d0,ConfigPfadAdr(a5)
		move.l	d3,ConfigPfadSize(a5)
		subq.l	#3,d3
		move.l	d3,d1
		move.l	d0,a1
		move.l	a3,a0
		jsr	A5StringCopy2(a5)
		bra.w	.CorrectPfad2

.LoadEnvFile:
		LA1	LNr_Envname
		LA2	LNr_ConfigDirName
		moveq	#1,d0
		moveq	#7,d1			;kein Check, keine Anzeige
		movem.l	a1-a4,-(a7)
		jsr	A5LoadFile(a5)
		movem.l	(a7)+,a1-a4
		tst.l	d0
		beq.w	.CorrectPfad

		LA1	LNr_Envarcname
		LA2	LNr_ConfigDirName
		moveq	#1,d0
		moveq	#7,d1			;kein Check, keine Anzeige
		movem.l	a1-a4,-(a7)
		jsr	A5LoadFile(a5)
		movem.l	(a7)+,a1-a4
		tst.l	d0
		beq.w	.CorrectPfad

		LA1	LNr_SName
		LA2	LNr_ConfigDirName
		moveq	#1,d0
		moveq	#7,d1			;kein Check, keine Anzeige
		movem.l	a1-a4,-(a7)
		jsr	A5LoadFile(a5)
		movem.l	(a7)+,a1-a4
		tst.l	d0
		beq.w	.CorrectPfad

		sub.l	a1,a1
		LA2	LNr_ConfigDirName
		moveq	#1,d0
		moveq	#7,d1			;kein Check, keine Anzeige
		movem.l	a1-a4,-(a7)
		jsr	A5LoadFile(a5)
		movem.l	(a7)+,a1-a4
		tst.l	d0
		bne.s	.DefConfig

		move.l	FileSizeNeu(a5),d0
		addq.l	#4,d0
		move.l	d0,d5
		jsr	A5AllocMem(a5)
		bne.s	.goon

		move.l	File(a5),ConfigPfadAdr(a5)
		move.l	FileSizeNeu(a5),ConfigPfadSize(a5)
		jsr	A5FreeConfigDir(A5)
		bra	.NormalPfad

.goon
		movem.l	d0/d5,-(sp)
		move.l	File(a5),a1
		move.l	d0,a0
		move.l	FileSizeNeu(a5),d1
		subq.w	#1,d1
		jsr	A5CopyText2(a5)

		move.l	File(a5),ConfigPfadAdr(a5)
		move.l	FileSizeNeu(a5),ConfigPfadSize(a5)
		jsr	A5FreeConfigDir(A5)

		movem.l	(sp)+,d0/d5
		move.l	d0,ConfigPfadAdr(a5)
		move.l	d5,ConfigPfadSize(a5)
		bra	.CorrectPfad


.DefConfig:	move.l	EPG_EagleplayerDirArrayPtr(a5),LoadFilePath(a5)
		LA2	LNr_ConfigDir
		jsr	A5CreateLoadPath(a5)
		lea	PathPuffer(a5),a0
		jsr	A5BerechStringSize(a5)
		addq.l	#4,d0
		move.l	d0,d5
		jsr	A5AllocMem(a5)
		beq.w	.NormalPfad
		jsr	A5FreeConfigDir(a5)
		move.l	d0,EPG_ConfigDirArrayPtr(a5)
		move.l	d0,ConfigPfadAdr(a5)
		move.l	d5,ConfigPfadSize(a5)
		move.l	d0,a3
		move.l	d0,a1
		lea	PathPuffer(a5),a0
		move.w	d5,d1
		subq.l	#3,d1
		jsr	A5StringCopy2(a5)
		move.l	a3,a0

		*-- Testen, ob Verzeichnis da ist --*
		move.l	EPG_ConfigDirArrayPtr(a5),d1
		move.l	#-2,d2
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.s	.NimmEPAssign
		jsr	_LVOUnLock(a6)
		bra.s	.NoPfad


.NimmEPAssign:	LA0	LNr_EPAssign
		move.l	a0,d1
		move.l	#-2,d2
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.s	.NoPfad
		jsr	_LVOCurrentDir(a6)
		move.l	d0,EPInitLoadConfigLock(a5)
		jsr	A5FreeConfigDir(a5)




*------------------------- 	Pfad aufbauen	----------------------------*
*----- Input:	LoadFilePath=Diradresse, ungleich Pathpuffer		----*
*-----		a2=Filename						----*
*----- Output:	Pathpuffer=creierter Path				----*


*	*--------------- Setze Default Configdir ----------------*
*		move.l	DTG_Dosbase(a5),a6
*		lea	TextPuffer(a5),a0
*		move.l	a0,d1
*		move.l	#DirPufferSize-2,d2
*		jsr	_LVOGetCurrentDirName(a6)
*		lea	TextPuffer(a5),a1
*		jsr	A5MakeCorrectDir(a5)
*		lea	TextPuffer(a5),a0
*		jsr	A5BerechStringSize(a5)
*		lea	(a0,d0.w),a1
*		LA0	LNr_ConfigDir
*		jsr	A5StringCopy(a5)
*
*
*		lea	TextPuffer(a5),a0
*		jsr	A5BerechStringSize(a5)
*		addq.l	#4,d0
*		move.l	d0,d5
*		jsr	A5AllocMem(a5)
*		beq.w	.NormalPfad
*		jsr	A5FreeConfigDir(a5)
*		move.l	d0,EPG_ConfigDirArrayPtr(a5)
*		move.l	d0,ConfigPfadAdr(a5)
*		move.l	d5,ConfigPfadSize(a5)
*		move.l	d0,a3
*		move.l	d0,a1
*		lea	TextPuffer(a5),a0
*		move.w	d5,d1
*		subq.l	#3,d1
*		jsr	A5StringCopy2(a5)
*		move.l	a3,a0
*		bra.s	.SetConfigAdr


.NormalPfad:	LA0	LNr_ConfigDir
.SetConfigAdr:	move.l	a0,EPG_ConfigDirArrayPtr(a5)
		bra.s	.NoPfad

	*------------ Korrigieren Configdir -------------*
.CorrectPfad:	move.l	File(a5),ConfigPfadAdr(a5)
		move.l	FileSizeNeu(a5),ConfigPfadSize(a5)
		move.l	File(a5),EPG_ConfigDirArrayPtr(a5)
.CorrectPfad2:	clr.l	File(a5)
		clr.l	FileSizeNeu(a5)

		move.l	ConfigPfadAdr(a5),a0
		move.l	a0,EPG_ConfigDirArrayPtr(a5)
.Retry		move.b	(a0)+,d0
		beq.s	.NoPfad
		cmp.b	#10,d0
		beq.s	.Clr
		cmp.b	#13,d0
		bne.s	.Retry
.Clr		clr.b	-1(a0)
.NoPfad:
;		subq.l	#2,a0
;		cmp.b	#`:`,(a0)
;		beq.s	.exit
;		cmp.b	#`/`,(a0)
;		beq.s	.exit
;		addq.l	#1,a0
;		move.b	#`/`,(a0)
;.exit		clr.b	1(a0)

		rts


PlaySample:	jmp	PlaySample2

***********************************************************************
* Der Eagleplayer wurde vorher zurckgesetzt und wird praktisch neu   *
* geladen.
* Config befindet sich:
* a1=Dir
* a2=Name
* in ToolTypesArgs(a5)  = Tooltypes
* in CliArgs(a5)	= CliArgs
*************************************************************************
LoadConfig:	jsr	A5DecodeStruct2(a5)

	*------- selektierte Config laden ------*
		move.l	EPG_ConfigDirArrayPtr(a5),a1
		LA2	LNr_ConfigName
		moveq	#1,d0
		moveq	#7,d1			;kein Check, keine Anzeige
		movem.l	a1-a4,-(a7)
		jsr	A5LoadFile(a5)
		movem.l	(a7)+,a1-a4
		*tst.l	d0
		*bne.w	.Pass4

		move.l	File(a5),ConfigAdr(a5)
		move.l	FileSizeNeu(a5),ConfigSize(a5)
		clr.l	File(a5)
		clr.l	FileSizeNeu(a5)
		move.b	#1,OnFilereqVerbot(a5)

	*------- Config einarbeiten -------*
		move.l	Rexx_Message(a5),-(a7)
		clr.l	Rexx_Message(a5)


	*#################### PASS 1 ##################*
	* allgemeine Prefs,Stringgadgets,Pfade
	*##############################################*
		moveq	#0,d6
	*	moveq	#EPNr_Dirmemsize-1,d6
		lea	KommandoTabelle-EPRT_SizeOf,a4
	*lea	KommandoTabelle-EPRT_SizeOf+EPRT_SizeOf*(EPNr_dirmemsize-1),a4
		lea	ConfigTabelle-4(pc),a3	* Ist dieses Kommando erlaubt
.Pass1_Next:	addq.l	#1,d6

	cmp.w	#EPNr_Programmode,d6
	bne.s	.NoNONO
	nop
.NoNONO


;	cmp.w	#EPNr_LoadList,d6
;	bne.s	.NoNONO
;	nop
;.NoNONO
		lea	EPRT_SizeOf(a4),a4
		btst	#EPRTF_NoConfig,EPRT_Flags(a4)
		bne.s	.Pass1_Next
		cmp.w	#-1,(a4)
		beq.s	.Pass2_Window

.Pass1_Retry:	move.w	EPRT_StrLNr(a4),d0		* Error, keine String-Kennung
		beq.s	.Pass1_Next
		move.l	a3,a0
.Pass1_Check:	lea	4(a0),a0		* -> Ja
		move.w	(a0),d1			* EPNr der Verbottabelle
		beq.s	.Pass1_Ok
		cmp.w	d1,d6
		bne.s	.Pass1_Check		* -> nein
		bra.s	.Pass1_Next
.Pass1_Ok:	jsr	A5GetArgs(a5)		* Argumente aus Config holen
		bne.s	.Pass1_Next		* Args im TextPuffer
		move.l	#Mode_Config,TestBits(a5)

		*-------------------------------------*
		* Auswertungseinsprung fr LoadConfig *
		* a1=Kommandoargs		      *
		* a4=KommandoStructure		      *
		* d6=Nummer			      *
		* Testbits gesetzt		      *
		*-------------------------------------*
		movem.l	a3/a4/d6,-(a7)
		lea	TextPuffer(a5),a1
		jsr	A5KommandoAuswertung2(a5)
		movem.l	(a7)+,a3/a4/d6
		bsr	LoadConfigError
		bne.w	.Pass2_Window		*.Pass4
		cmp.w	#EPNr_Voices,d6
		beq.s	.Pass1_Retry
		bra.s	.Pass1_Next

	*#################### PASS 2 ##################*
	* Enginedir scannen
	* Gui laden
.Pass2_Window:	move.w	#1,MenuVerbot(a5)
		move.w	#1,EnableVerbot(a5)
		bsr	ScanEngineDir
		clr.l	TestBits(a5)
		tst.b	OnNoGui(a5)
		bne.s	.Pass2_NoGui
		moveq	#EPNr_LoadEngine,d6
		moveq	#LNr_Str_LoadGui,d0
		jsr	A5GetArgs(a5)		* Argumente aus Config holen
		bne.s	.Pass2_2		* Args im TextPuffer
		lea	KommandoTabelle+(EPRT_SizeOf*(EPNr_LoadEngine-1)),a4

		*-------------------------------------*
		* Auswertungseinsprung fr LoadConfig *
		* a1=Kommandoargs		      *
		* a4=KommandoStructure		      *
		* d6=Nummer			      *
		* Testbits gesetzt		      *
		*-------------------------------------*
		movem.l	a3/a4,-(a7)
		lea	TextPuffer(a5),a1
		jsr	A5KommandoAuswertung2(a5)
		movem.l	(a7)+,a3/a4
		tst.l	d0
		beq.s	.Pass2_Ok
		bsr	LoadConfigError
		bne.w	.Pass4
.Pass2_Ok:	tst.b	OnIconify(a5)
		bne.s	.Pass2_Iconify
		*tst.l	WinMerk(a5)
		*beq.s	.Pass3
		move.b	WinMerk+3(a5),OnWindowZustand(a5)
		jsr	A5SetWindowZustand(a5)
		bra.s	.Pass3

	*--- Keine Config oder keinen Eintrag in der Config ----*
.Pass2_2:	LA0	LNr_DefaultGui
		sub.l	a1,a1
		sub.l	a2,a2
		sub.l	a3,a3
		moveq	#0,d0
		jsr	A5LoadEngine(a5)
		bne.s	.Pass3
		bra.s	.Pass2_Ok

.Pass2_NoGui:	tst.b	OnIconify(a5)
		beq.s	.Pass2_NoIconify
		
.Pass2_Iconify:	jsr	A5Iconify(a5)
.Pass2_NoIconify:move.l	#1,WinMerk(a5)

	*#################### PASS 3 ##################*
	* Engine & AddEngine unterscheiden
	* Hier alle Kommandos fter au
	* Player/Engines laden
.Pass3:		jsr	A5WaitMouse(a5)
		move.w	#1,ClearMouseVerbot(a5)

		*lea	ConfigTabelle-4(pc),a0
		lea	ConfigTabelle(pc),a0	*EPNr_LoadEngine weglassen
	
.Pass3_Next:	lea	4(a0),a0
.Pass3_Retry:	move.w	(a0),d6			;EPNr
		beq.s	.Pass4
		move.w	2(a0),d0		;LocaleNummer
		jsr	A5GetArgs(a5)		* Argumente aus Config holen
		bne.s	.Pass3_Next		* Args im TextPuffer
		lea	KommandoTabelle-EPRT_SizeOf,a4
		move.l	d6,d0
		mulu	#EPRT_SizeOf,d0
		lea	(a4,d0.w),a4
		*-------------------------------------*
		* Auswertungseinsprung fr LoadConfig *
		* a1=Kommandoargs		      *
		* a4=KommandoStructure		      *
		* d6=Nummer			      *
		* Testbits gesetzt		      *
		*-------------------------------------*
		movem.l	a0/a3/a4,-(a7)
		lea	TextPuffer(a5),a1
		clr.l	TestBits(a5)
		jsr	A5KommandoAuswertung2(a5)
		movem.l	(a7)+,a0/a3/a4
		bsr	LoadConfigError
		bne.s	.Pass4
		bra.s	.Pass3_Retry

	*#################### PASS 3 ##################*
.Pass4:		clr.l	TestBits(a5)

		lea	EngineDir(a5),a1
		jsr	A5MakeCorrectDir(a5)
		lea	PlayersDir(a5),a1
		jsr	A5MakeCorrectDir(a5)
		lea	SaveDirPuffer(a5),a1
		jsr	A5MakeCorrectDir(a5)

		jsr	A5LoadStartEngines(a5)
		jsr	A5SortAmplifiers(a5)
		jsr	A5InitCommodity(a5)
		jsr	A5InitScreenNotify(a5)
		jsr	A5LoadPlayerBatch(a5)

	*----------------- Player laden ---------------*
		tst.b	OnPlayerBatch(a5)
		bne.s	.Pass4_LoadMod
		jsr	A5LoadPlayers2(a5)

	*---------- entsprechendes Module laden --------*
	*--- Module ber WBArg ---*
.Pass4_LoadMod:	move.l	Message(a5),d0
		beq.s	.Pass4_TesteRandom
		move.l	d0,a0
		move.l	28(a0),d2		;NumArgs lesen
		cmp.l	#2,d2
		blt.s	.Pass4_TesteRandom
		subq.l	#1,d2
		move.l	36(a0),d3		;Arglist laden
		addq.l	#8,d3
		move.l	#3,UserType(a5)		*MultiSelectType
		jsr	A5InsertModulesList(a5)
		bra.s	.Pass4_ModuleOk

.Pass4_TesteRandom:
		moveq	#0,d2
		moveq	#1,d3
		jsr	A5LoadList(a5)


		*clr.l	StartModuleLock
		tst.b	OnRandomStart(a5)
		beq.s	.Pass4_NormalMode
		move.b	#1,MustRandomModule(a5)
.Pass4_NormalMode:
		moveq	#LNr_Str_LoadModule,d0
		*moveq	#EPNr_LoadModule,d6
		jsr	A5GetArgs(a5)		* Argumente aus Config holen
		bne.w	.Pass4_ModuleOk		* Args im TextPuffer
		lea	KommandoTabelle+(EPRT_SizeOf*(EPNr_LoadModule-1)),a4
		moveq	#EPNr_LoadModule,d6
		movem.l	a3/a4,-(a7)
		lea	TextPuffer(a5),a1
		jsr	A5KommandoAuswertung2(a5)
		movem.l	(a7)+,a3/a4
		bsr	LoadConfigError
.Pass4_ModuleOk:jsr	A5LoadDirIn(a5)

	*-------- Configmem freigegeben ---------*
		move.l	ConfigAdr(a5),d0
		beq.w	.NoConfigAdr
		move.l	d0,a1
		move.l	ConfigSize(a5),d0
		beq.w	.NoConfigAdr
		ExecBase
		jsr	_LVOFreeMem(a6)
.NoConfigAdr:	clr.l	ConfigAdr(a5)
		clr.l	ConfigSize(a5)
		move.l	(a7)+,Rexx_Message(a5)
		moveq	#LNr_LoadConfig,d0
		jsr	A5ScrollNew(a5)
.rts		clr.w	MenuVerbot(a5)
		clr.w	EnableVerbot(a5)
		clr.b	MustRandomModule(a5)
		clr.b	OnFilereqVerbot(a5)
		jsr	A5EnableAll(a5)
		jsr	A5GuiChanged(a5)

		clr.l	TestBits(a5)
		rts




ConfigTabelle:	dc.w	EPNr_LoadEngine,LNr_Str_LoadEngine
		*dc.w	EPNr_LoadEngineDir,LNr_Str_LoadEngineDir
		*dc.w	EPNr_LoadEngine,LNr_Str_LoadGui
		dc.w	EPNR_LoadPlayer,LNr_Str_LoadPlayer
		dc.w	EPNr_LoadModule,LNr_Str_Module
		dc.w	0


*----------------- Sortiere die Amplifier nach Prioritt --------------------*
SortAmplifiers:	move.l	EPG_AmplifierList(a5),d7
		clr.l	EPG_AmplifierList(a5)
.SortAmloop:	tst.l	d7
		beq.s	.NoneAmplifier
		move.l	d7,a4

		move.l	eus_identifier(a4),d7
		clr.l	EUS_identifier(a4)

		bsr	.AM_FuegeEIN	;diesen Amplifier (A4) in Liste
		bra.s	.SortAMloop

		*---- Message an Amplifiermanager ----*
.NoneAmplifier:	moveq	#USClass_NewAmplifierlist,d0
		jsr	A5SendeAllMessage(a5)
		rts

		*---- Angegebenen Amplifier in Liste einfgen ----*
		* bergabe: A4 - Amplifier
		* Rckgabe: keine
.AM_Fuegeein:	movem.l	d0-d2/a0-a5,-(sp)
		move.w	EUS_AMPriority(a4),d0	;sollte ber die Prefs
						;schon auf richtigen
						;Wert gesetzt sein
		move.l	EPG_AmplifierList(a5),d1
		move.l	d1,d2
		beq.s	.Set1			;sollte nicht passieren
.Loop:		move.l	a0,a1
		move.l	d1,a0
		cmp.w	EUS_AMPriority(a0),d0
		bgt.s	.set2
		move.l	EUS_Identifier(a0),d1	;Next Amplifier
		bne.s	.loop			;keiner
		move.l	a4,EUS_Identifier(a0)	;also hinten an...
		bra.s	.NewAmplifier
.set2:		cmp.l	a0,d2			;als ersten NP einfgen ?
		bne.s	.normal			;n
		move.l	a0,EUS_Identifier(a4)	;Rest hinten anhngen
		bra.s	.set1			;und neuer erster Platz
.normal:	move.l	eus_identifier(a1),eus_identifier(a4)
		move.l	a4,eus_identifier(a1)
		bra.w	.NewAmplifier
.set1:		move.l	a4,EPG_AmplifierList(A5)	;erster NP in Liste
.NewAmplifier:	movem.l	(sp)+,d0-d2/a0-a5
		rts



*----------------------- Gibt den Error der Config aus ----------------------*
LoadConfigError:tst.l	d0
		beq.w	.Return2
		cmp.w	#EPR_InvalidNr,d0	;ConfigMode nicht erlaubt
		beq.s	.Return3
		cmp.w	#EPR_FileReqCancelled,d0
		beq.s	.Return3
		cmp.w	#EPR_FunctionAborted,d0
		beq.s	.Return3

		movem.l	d6/a4,-(a7)
		*cmp.w	#EPR_ErrorInArguments,d0
		*beq.s	.YesError
		*cmp.w	#EPR_CommandError,d0
		*bne.w	.Return

	*----------------- Error-Requester ausgeben -------------*
.YesError:	add.w	#LNr_Ft1-1,d0
		jsr	A5GetLocaleString(a5)
		move.l	KommandoMode(a5),d0
		cmp.w	#Mode_Config,d0
		beq.s	.ConfigMode
		cmp.w	#Mode_ToolTypes,d0
		beq.s	.ToolTypes
		moveq	#0,d0
		bra.s	.Return

.ToolTypes:	move.l	a0,ScrollArgs+4(a5)		*Fehlertext
		move.l	KommandoStringAdr(a5),ScrollArgs(a5)
		LA0	LNr_TR_ToolTypes
	ifeq	executable
		move.l	d6,ScrollArgs+8(a5)
	endc
		bsr.s	.Request
		bra.s	.Return

.ConfigMode:	move.l	a0,ScrollArgs+8(a5)		*Fehlertext
		move.l	KommandoStringAdr(a5),a1
		bsr	CopyLineToTextPuffer
		lea	TextPuffer(a5),a0
		move.l	a0,ScrollArgs+4(a5)
		move.b	KommandoBuch+3(a5),(a0)
		move.l	KommandoLine(a5),ScrollArgs(a5)
		LA0	LNr_TR_Config				;Text
	ifeq	executable
		move.l	d6,ScrollArgs+12(a5)
	endc
		bsr.s	.Request
		*bra.s	.Return


.Return:	movem.l	(a7)+,d6/a4
.Return3:	tst.l	d0
		seq	d0
.Return2:	tst.b	d0
		rts

	*----------------------------------------------------*
.Request:	move.l	a0,EPG_Arg1(a5)				;Text
		lea	PubScreenName(a5),a0
		move.l	a0,EPG_Arg2(a5)				;PubScreen
		clr.l	EPG_Arg3(a5)
		subq.l	#1,EPG_Arg3(a5)				;Pos
		LA0	LNr_GA_Config
		move.l	a0,EPG_Arg4(a5)				;Gadgets
		LA0	LNr_EagleplayerRequest
		move.l	a0,EPG_Arg5(a5)				;Title
		lea	ScrollArgs(a5),a0
		move.l	a0,EPG_Arg6(a5)				;Args
		moveq	#-1,d0
		move.l	d0,EPG_Arg7(a5)				;Imagedatas
		moveq	#7,d0
		move.l	d0,EPG_ArgN(a5)
		clr.l	EPG_Arg8(a5)
		jmp	A5TextRequest(a5)



* Geht die gesammte Konfig sowie die Tooltypes und CliArgs nach dem ang.
* Kommandostring durch.
* Input: d0=LocaleStringNr
* Output:TextPuffer=Argumentstart	`module "Test"` (Begin bei ")
*	 d0=Null oder Error
GetArgs2:	movem.l	d1-a6,-(a7)			;a0=Localestring
		moveq	#0,d6
		bra.b	GetArgs3
GetArgs:	movem.l	d1-a6,-(a7)
		move.w	d0,d6
		jsr	A5GetLocaleString(a5)
GetArgs3:	move.l	#1,KommandoLine(a5)
		clr.l	KommandoMode(a5)
		clr.b	NurEinString(a5)
		move.l	a0,a2

	*----------- Arg aus Cli-Args suchen ----------*
		tst.w	d6
		beq.s	.NoCliArgs
		move.l	CliArgs(a5),d0
		beq.s	.NoCliArgs
		move.l	d0,a0			*Strnummer im Puffer
		moveq	#-4,d1
.NimmNextCli:	addq.l	#4,d1
		move.w	(a0)+,d0		*suchen
		beq.s	.NoCliArgs
		cmp.w	d0,d6
		bne.s	.NimmNextCli
		move.l	CliArgs(a5),a0
		lea	CliArgOffset(a0),a0
		move.l	(a0,d1.w),d0
		beq.s	.NoCliArgs
		clr.l	(a0)
		move.l	d0,a0
		move.l	#Mode_Cli,KommandoMode(a5)
	move.b	#1,NurEinString(a5)
		bra.s	.CopyIt

	*----------- Arg in Tooltypes suchen ----------*
.NoCliArgs:	move.l	EagleIconAdr(a5),d1
		beq.s	.Config
		move.l	d1,a0
		move.l	54(a0),d1
		beq.s	.Config
		move.l	d1,a0			;ToolType-Array
		move.l	a2,a1
		move.l	EPG_Iconbase(a5),a6
		jsr	_LVOFindToolType(a6)
		move.l	d0,a0
		beq.w	.Config
		move.l	#Mode_ToolTypes,KommandoMode(a5)
.CopyIt:	lea	TextPuffer(a5),a1
		move.w	#TextPufferSize-2,d1
		jsr	A5StringCopy2(a5)
		move.l	a2,KommandoStringAdr(a5)
	move.b	#1,NurEinString(a5)
		moveq	#0,d0
		bra.w	.rts



	*--------- Arg in Cli-Kommandos suchen --------*
.Config:	move.l	ConfigAdr(a5),d0
		beq.w	.ItsAll
		move.l	d0,a4


.NextKommandostart:
		move.b	(a4)+,d0
		beq.w	.ItsAll
		cmp.b	#" ",d0
		beq.s	.NextKommandostart
		cmp.b	#10,d0
		beq.w	.AddLine
		cmp.b	#9,d0		;Tab
		beq.s	.NextKommandostart
		cmp.b	#"*",d0
		beq.w	.IgnoreLine
		cmp.b	#";",d0
		beq.w	.IgnoreLine

	*--------- typischer C-Kommentar -----------*
	* gleich, wegen mehrerer Durchlufe lschen *
		cmp.b	#"/",d0
		bne.s	.TestKommando
		move.b	(a4)+,d0
		beq.w	.ItsAll
		cmp.b	#"*",d0
		bne.s	.ErrorInComment
		move.b	#" ",-2(a4)
.FindCommentEnd:move.b	#" ",-1(a4)
.FindComment2:	move.b	(a4)+,d0
		beq.s	.ItsAll
		cmp.b	#10,d0
		bne.s	.FindCommendNo
		addq.l	#1,KommandoLine(a5)		;fr Errormeldung
		bra.s	.FindComment2
.FindCommendNo:	cmp.b	#"*",d0
		bne.s	.FindCommentEnd
		move.b	(a4)+,d0
		beq.s	.ItsAll
		cmp.b	#"/",d0
		bne.s	.FindCommentEnd
		move.b	#" ",-2(a4)
		move.b	#" ",-1(a4)
		bra.s	.NextKommandostart

	*------------ mglicher Start eines Kommandos -------------*
.ErrorInComment:subq.l	#1,a4
.TestKommando:	lea	-1(a4),a0
		move.l	a2,-(a7)
		bsr	StrCmp
		move.l	(a7)+,a2
		bne.s	.IgnoreLine

	*------------ Kommando lschen -----------*
		lea	-1(a4),a0
		move.l	a0,KommandoStringAdr(a5)
		move.b	(a0),KommandoBuch+3(a5)
		*move.b	#"*",-1(a4)
		move.b	#"*",(a0)


	*----------- Kommando kopieren und lschen ----------*
		move.l	#Mode_Config,KommandoMode(a5)	;fr Errormeldung
		bsr	CopyLineToTextPuffer
		moveq	#0,d0
		bra.s	.rts

	*----------- Bi zur nchsten Zeile gehen -----------*
.IgnoreLine:	move.b	(a4)+,d0
		beq.s	.ItsAll
		cmp.b	#10,d0
		bne.s	.IgnoreLine
.AddLine	addq.l	#1,KommandoLine(a5)		;fr Errormeldung
		bra.w	.NextKommandoStart


.ItsAll:	moveq	#1,d0
.Rts:		movem.l	(a7)+,d1-a6
		rts
		

CopyLineToTextPuffer
		lea	TextPuffer(a5),a0
		moveq	#0,d0
		cmp.l	d0,a1
		beq.s	.NoArgs
		move.w	#TextPufferSize-2,d1
.CopyArgs:	move.b	(a1)+,d0
		beq.s	.NoArgs
		cmp.b	#10,d0
		beq.s	.NoArgs
		move.b	d0,(a0)+
		dbf	d1,.CopyArgs
.NoArgs:	clr.b	(a0)
		rts



*-----------------------------------------------------------------------------*
* Das Playerdirectory wird ebenfalls gescannt.
*
* d5=DosObject
* d6=Dirlock
* d7=MemAdr
ScanEngineDir:


		*---- ScanMem ----*
		move.b	#1,NoMessages(a5)
		move.l	#5000,d0
		jsr	A5AllocMem(a5)
		move.l	d0,d7
		beq.w	.Error

		*tst.b	OnEjectPlayer(a5)
		*bne.w	.ScanEngines


		*----- PlayerdirLock holen -----*
		lea	PlayersDir(a5),a0
		jsr	A5KillLastSchraeg(a5)
		move.l	a0,d1
		moveq	#-2,d2
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOLock(a6)
		move.l	d0,d6
		beq.w	.FreeMem


		*--- AllocDosObject ----*
		moveq	#1,d1				*DOS_EXALLCONTROL
		moveq	#0,d2				*Tags
		jsr	_LVOAllocDosObject(a6)
		move.l	d0,d5
		tst.l	d0
		beq.w	.UnLock1

		*---- ExamineAll ----*
.RetrySchreiben1:move.l	d6,d1
		move.l	d7,d2
		move.l	#5000-2,d3
		moveq	#3,d4				;Name
		*move.l	DosObject(a5),d5
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOExAll(a6)


		*---- Namen in die Structuren setzen ----*
		move.l	d0,-(a7)
		move.l	d7,a4
.RetryLesen1:	tst.l	8(a4)				*ED_Type
		bgt.s	.DirName1
		move.l	4(a4),a2			*ED_Name

		lea	PlayersDir(a5),a0
		move.l	a0,Loadfilepath(a5)
		jsr	A5CreateLoadPath(a5)

		clr.l	LoadPlayerVersion(a5)
		lea	PathPuffer(a5),a3
		sub.l	a2,a2
		jsr	A5InsertPlayerInList(a5)
		tst.l	d0
		beq.s	.Dirname1
		addq.l	#1,ScanPlayerAnz(a5)

.DirName1:	move.l	(a4),d0				*ED_Next
		beq.s	.PufferDurch1
		move.l	d0,a4
		bra.s	.RetryLesen1

.PufferDurch1:	move.l	(a7)+,d0			* d0=0 -> ItsAll
		tst.l	d0
		bne.s	.RetrySchreiben1


*		*---- ExAllEnd ----*
*.Fehler:	move.l	DirLock(a5),d1
*		lea	TextPuffer(a5),a0
*		move.l	a0,d2
*		move.l	#TextPufferSize-2,d3
*		moveq	#1,d4				;Name
*		move.l	DosObject(a5),d5
*		move.l	Dosbase(a5),a6
*		jsr	_LVOExAllEnd(a6)
*
		*----- FreeDosObject -----*
.FreeDosObject1:move.l	d5,d2
		beq.s	.UnLock1
		move.l	DTG_Dosbase(a5),a6
		moveq	#1,d1				*DOS_EXALLCONTROL
		jsr	_LVOFreeDosObject(a6)
		moveq	#0,d5

		*----- UNLock -----*
.UnLock1:	move.l	d6,d1
		beq.w	.Error
		move.l	DTG_DosBase(a5),a6
		jsr	_LVOUnLock(a6)
		moveq	#0,d6




		*----------- Enginedir scannen -----------*
		*----- DirLock holen -----*
.ScanEngines:	lea	EngineDir(a5),a0
		jsr	A5KillLastSchraeg(a5)
		move.l	a0,d1
		moveq	#-2,d2
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOLock(a6)
		move.l	d0,d6
		beq.w	.FreeMem


		*--- AllocDosObject ----*
		moveq	#1,d1				*DOS_EXALLCONTROL
		moveq	#0,d2				*Tags
		jsr	_LVOAllocDosObject(a6)
		move.l	d0,d5
		tst.l	d0
		beq.w	.UnLock2

		*---- ExamineAll ----*
		addq.w	#1,RefreshMenuVerbot(a5)
.RetrySchreiben2:move.l	d6,d1
		move.l	d7,d2
		move.l	#5000-2,d3
		moveq	#3,d4				;Name
		*move.l	DosObject(a5),d5
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOExAll(a6)

		*---- Namen in die Structuren setzen ----*
		move.l	d0,-(a7)
		move.l	d7,a4
.RetryLesen2:	tst.l	8(a4)				*ED_Type
		bgt.s	.DirName2
		move.l	4(a4),a2			*ED_Name

		lea	EngineDir(a5),a0
		move.l	a0,Loadfilepath(a5)
		jsr	A5CreateLoadPath(a5)

		moveq	#UPrg_NewBatch,d0
		lea	PathPuffer(a5),a0
		sub.l	a1,a1
		sub.l	a2,a2
		sub.l	a3,a3
		jsr	A5LoadEngine(a5)
.DirName2:	move.l	(a4),d0				*ED_Next
		beq.s	.PufferDurch2
		move.l	d0,a4
		bra.s	.RetryLesen2

.PufferDurch2:	move.l	(a7)+,d0			* d0=0 -> ItsAll
		tst.l	d0
		bne.s	.RetrySchreiben2


*		*---- ExAllEnd ----*
*.Fehler:	move.l	DirLock(a5),d1
*		lea	TextPuffer(a5),a0
*		move.l	a0,d2
*		move.l	#TextPufferSize-2,d3
*		moveq	#1,d4				;Name
*		move.l	DosObject(a5),d5
*		move.l	Dosbase(a5),a6
*		jsr	_LVOExAllEnd(a6)
*
		*----- FreeDosObject -----*
.FreeDosObject2:subq.w	#1,RefreshMenuVerbot(a5)
		move.l	d5,d2
		beq.s	.UnLock2
		move.l	DTG_Dosbase(a5),a6
		moveq	#1,d1				*DOS_EXALLCONTROL
		jsr	_LVOFreeDosObject(a6)
		moveq	#0,d5

		*----- UNLock -----*
.UnLock2:	move.l	d6,d1
		beq.s	.Error
		move.l	DTG_DosBase(a5),a6
		jsr	_LVOUnLock(a6)
		moveq	#0,d6




		*---- FreeMem -----*
.FreeMem:	move.l	d7,a1
		move.l	#5000,d0
		jsr	A5FreeMem(a5)

.Error:		clr.b	NoMessages(a5)
		rts



*-----------------------

*		lea	InfoBlock(a5),a1
*		move.l	a1,d2
*		move.l	d6,d1
*		jsr	_LVOExamine(a6)
*		tst.l	d0
*		beq.w	.ItsAll
*
*		*------- Dir scannen -------*
*		addq.w	#1,RefreshMenuVerbot(a5)
*.NextItem:	lea	InfoBlock(a5),a0
*		move.l	a0,d2
*		move.l	d6,d1
*		move.l	DTG_Dosbase(a5),a6
*		jsr	_LVOExNext(a6)
*		tst.l	d0
*		beq.w	.ItsAll2
*
*		tst.l	InfoBlock+4(a5)
*		bgt.w	.NextItem
*
*		lea	EngineDir(a5),a0
*		move.l	a0,Loadfilepath(a5)
*		lea	InfoBlock+8(a5),a2
*		jsr	A5CreateLoadPath(a5)
*
*		moveq	#UPrg_NewBatch,d0
*		lea	PathPuffer(a5),a0
*		sub.l	a1,a1
*		sub.l	a2,a2
*		sub.l	a3,a3
*		jsr	A5LoadEngine(a5)
*		bra.w	.NextItem
*
*.ItsAll2:	subq.w	#1,RefreshMenuVerbot(a5)
*.ItsAll:	move.l	d6,d1
*		move.l	DTG_Dosbase(a5),a6
*		jsr	_LVOUnLock(a6)
*.Error:		rts
*
*



	*############################################*
	*############# Quit EaglePlayer #############*
	*############################################*
Quit:		bsr.w	ReplyArexxMsg
		jmp	A5CloseWin(a5)


Hide:		tst.w	Kick2On(a5)
		beq.s	Quit
		moveq	#USClass_Hide,d0	;User-Type (Dumy) Prg stoppen
		jsr	A5SendeAllMessage(a5)
		jsr	A5CloseMainWindow(a5)
		rts


*-----------------------------------------------------------------------------*
* d2=Neue PositionNr
SetPosition:	moveq	#EPR_NoModuleLoaded,d7
		tst.l	PlayerAdr(a5)
		beq.w	.Error
		move.l	d2,d3
		move.l	#EP_SetPosition,d0
		jsr	A5CallUp(a5)
		bne.s	.Return

		*-- Es gibt keinen SetPositionTag, Mal versuchen, ob ein Durchschalten
		*-- mittels Prev/Next was bringt
		* d3=neue Position
		* d4=Max Length
		* d5=Counter
		* d6=aktuelle PositionsNr
		* d7=Fehlernr, spter PatternTag
		tst.w	PrevPatternOn(a5)
		beq.w	.Error2
		tst.w	NextPatternOn(a5)			* Kann berhaupt weiter geschaltet werden?
		beq.w	.Error2
		move.l	#EP_GetPositionNr,d0			* Kann die aktuelle Pattern gelesen werden
		jsr	A5Callup(a5)
		beq.s	.Error2
		move.l	d0,d6
		move.l	EPG_ModuleInfoTagList(a5),d0		* Kann die Lnge gelesen werden
		beq.s	.Error2
		move.l	d0,a6
		move.l	#MI_Length,d0
		jsr	a5FindTag2(a5)
		beq.s	.Error2
		move.l	d2,d4
		moveq	#EPR_ErrorInArguments,d7
		cmp.l	d4,d3					* Max. Position kleiner als neue Position
		bhi.s	.Error

		*-- Pattern zurckschalten
		move.l	d6,d5
		sub.l	d3,d5
		move.l	#DTP_PrevPatt,d7
		cmp.l	d3,d6
		bhi.s	.UsePrev
		*-- Pattern hochschalten
		move.l	d3,d5
		sub.l	d6,d5
		move.l	#DTP_NextPatt,d7
		*-
.UsePrev:	*addq.l	#2,d5					* Counter, falsch was schief luft
.PatternSchleif:
		move.l	d7,d0
		jsr	A5CallUp(a5)
		beq.s	.Error2
		subq.l	#1,d5
		bne.s	.PatternSchleif
.Return:	move.l	#EP_GetPositionNr,d0
		jsr	A5CallUp(a5)
		beq.w	AllesOK
		move.l	d0,ScrollArgs(a5)
		LA0	LNr_CurrentPosition
		jmp	A5PrintText(a5)


.Error3:	moveq	#EPR_FunctionAborted,d7
		bra.s	.Error
.Error2:	moveq	#EPR_NotImplemented,d7
.Error:		move.l	d7,d0
		jmp	A5ScrollNewFehler(a5)

*-----------------------------------------------------------------------------*
GiveScreenMode:
SetScreenMode:
		moveq	#0,d0
		rts

Help:		jmp	A5Help2(a5)
HelpLink:	jmp	A5HelpLink2(a5)
Documentation:	jmp	A5Documentation2(a5)

**-------------------------- ASL-ScreenMode-Requester ------------------------*
**---- Input :	a0=ASL_FileRequester-Title				-----*
**----		a1=Dir-Path						-----*
**----		a2=FileName						-----*
**----		a3=Window						-----*
**----		d0=1 Select Dir						-----*
**----		  =0 Select File					-----*
**----		d1=1 MultiSelect					-----*
**----		  =0 kein MultiSelect					-----*
**---- OutPut:	d0=0 -> Cancel/Error					-----*
**----		d0=1 -> Ok gedrckt					-----*
**----------------------------------------------------------------------------*
*ASL_Request:	movem.l	d1-a6,-(a7)
*
*		bsr	MakeList
*
*.Retry:		lea	ASL_Tags(a5),a4			;TagListe sichern
*		move.l	a4,a0
*		move.l	#$80080005,(a0)+		*ASLFO_Width
*		move.l	#350,(a0)+
*		move.l	#$80080006,(a0)+		*ASLFO_Height
*		move.l	#400,(a0)+
*		move.l	#$8008006d,(a0)+		*ASLFO_WidthGadget
*		move.l	#1,(a0)+
*		move.l	#$8008006e,(a0)+		*ASLFO_HeightGadget
*		move.l	#1,(a0)+
*		move.l	#$8008006f,(a0)+		*ASLFO_DepthGadget
*		move.l	#1,(a0)+
*		move.l	#$80080070,(a0)+		*ASLFO_OverscanGadget
*		move.l	#1,(a0)+
*		move.l	#$80080071,(a0)+		*ASLFO_AutoScrollGadget
*		move.l	#1,(a0)+
*
*		move.l	#$80080028,(a0)+		*ASLFO_Screen
*		move.l	ScreenAdr(a5),(a0)+
*
**		move.l	#$8008007b,(a0)+	*ASLSM_CustomSMList    equ ASL_TB+123  ; Exec list of struct DisplayMode
**		move.l	#Liste,(a0)+
*
*		lea	DefScreen,a1
*		move.l	#$80080064,(a0)+
*		move.l	(a1)+,(a0)+
*		move.l	#$80080065,(a0)+
*		move.l	(a1)+,(a0)+
*		move.l	#$80080066,(a0)+
*		move.l	(a1)+,(a0)+
*		move.l	#$80080067,(a0)+
*		addq.l	#2,a0
*		move.w	(a1)+,(a0)+
*		move.l	#$80080068,(a0)+
*		addq.l	#2,a0
*		move.w	(a1)+,(a0)+
*		move.l	#$80080069,(a0)+
*		addq.l	#2,a0
*		move.w	(a1)+,(a0)+
*
*
*
*
*	*	move.l	#$80080001,(a0)+		*ASLFO_TitleText
*	*	lea	Titletext(a5),a1
*	*	move.l	a1,(a0)+
*		clr.l	(a0)
*
*		lea	MyAslName(pc),a1
*		lea	DTG_AslBase(a5),a3
*		bsr.w	OpenLib
*		beq.w	.NoASL_Struct
*		move.l	d0,a6
*
*		move.l	a4,a0
*		moveq	#2,d0				;Type = ScreenRequester
*		jsr	_LVOAllocAslRequest(a6)
*		move.l	d0,a3				;ASLRequesterStructure
*		beq.w	.NoASL_Struct
*
*		move.l	d0,a0
*		sub.l	a1,a1
*		jsr	_LVOAslRequest(a6)
*		move.l	d0,d7
*
*
*	*------------- alten Screen lschen ---------*
*		move.l	ScreenAdr(a5),d0
*		beq.s	.NoScreen
*		move.l	d0,a0
*		move.l	DTG_Intuitionbase(a5),a6
*		jsr	_LVOCloseScreen(a6)
*		clr.l	ScreenAdr(a5)
*.NoScreen:	tst.l	d7
*		beq.w	.Weg
*
*
*	move.l	#2000,4(a3)
*	move.l	#2000,8(a3)
*
*	*--------- Screen ffnen ----------*
*		lea	DefScreen,a0
*		move.l	(a3),(a0)+			*ULONG sm_DisplayID	; Display mode ID
*		move.l	4(a3),(a0)+			*ULONG sm_DisplayWidth	; Width of display in pixels
*		move.l	8(a3),(a0)+			*ULONG sm_DisplayHeight	; Height of display in pixels
*		move.w	12(a3),(a0)+			*UWORD sm_DisplayDepth	; Number of bit-planes of display
*		move.w	14(a3),(a0)+			*UWORD sm_OverscanType	; Type of overscan of display
*		move.w	16(a3),(a0)+			*UWORD sm_AutoScroll	; Display should auto-scroll?
*
*		
*		lea	Tags(a5),a4
*
*		move.l	#$80000032,(a4)+		;SA_DisplayID
*		move.l	(a3),(a4)+
*		move.l	#$80000023,(a4)+		;SA_Width
*		move.l	4(a3),(a4)+
*		move.l	#$80000024,(a4)+		;SA_Height
*		move.l	8(a3),(a4)+
*		move.l	#$80000025,(a4)+		;SA_Depth
*		clr.w	(a4)+
*		move.w	12(a3),(a4)+
*
*		move.l	#$80000034,(a4)+		;SA_Overscan
*		clr.w	(a4)+
*		move.w	14(a3),(a4)+
*
*		move.l	#$80000039,(a4)+		;SA_AutoScroll
*		clr.w	(a4)+
*		move.w	16(a3),(a4)+
*
*		move.l	#$8000003b,(a4)+		;SA_FullPalette
*		move.l	#1,(a4)+
*
*		move.l	#$80000028,(a4)+		;SA_Title
*		lea	Title,a1
*		move.l	a1,(a4)+
*
*		move.l	#$8000002d,(a4)+		;SA_Type
*		move.l	#2,(a4)+			;Type-Publicscreen
*	*	move.l	#$8000002b,(a4)+		;Font
*	*	lea	MenuFont,a1
*	*	move.l	a1,(a4)+
*
*		move.l	#$8000002f,(a4)+		;Pubname
*		lea	PubName,a1
*		move.l	a1,(a4)+
*		clr.l	(a4)
*
*		sub.l	a0,a0
*		lea	Tags(a5),a1
*		move.l	DTG_Intuitionbase(a5),a6
*		jsr	_LVOOpenScreenTagList(a6)
*		move.l	d0,ScreenAdr(a5)
*
*.Weg:		move.l	a3,a0				;ASLRequesterStructure
*		jsr	_LVOFreeAslRequest(a6)
*		move.l	d7,d0
*		bne.w	.Retry
*
*
*.NoASL_Struct:	movem.l	(a7)+,d1-a6
*		tst.l	d0
*		rts
*		
*		rts
*
*ASL_ScreenRequest:
*










*----------------- Erste Decodierung des KeyFiles ----------------------------*
Key_DecKeyFile1:lea	EPKF_CodeStart(a4),a0
		move.l	EPKF_CrFileSize(a4),d0
		move.l	d0,KeyCrSize-(TextPuffer+4)(a3)
		moveq	#7,d1
		lsl.l	#1,d1
		add.l	d1,KeyCrSize-(TextPuffer+4)(a3)

		sub.l	#EPKF_CodeStart-EPKF_Struct+1,d0
.DecodeIt2:	eor.b	d0,(a0)+
		dbf	d0,.DecodeIt2
		rts



*-----------------------------------------------------------------------------*
*--------------------- Der Volume-Wert wird neu eingestellt ------------------*
*-----------------------------------------------------------------------------*
VolumeHigher:	moveq	#0,d1
		move.w	EPG_Volume(a5),d2	*### Menu Arexx
		cmp.w	#EP_MaxVolume,d2
		bhs.s	VolumeDefault
		addq.l	#1,d2
		bra.s	Volume
VolumeLower:	moveq	#0,d1
		moveq	#0,d2			*### Menu/Arexx
		tst.w	EPG_Volume(a5)
		blt.s	Volume
		move.w	EPG_Volume(a5),d2
		subq.w	#1,d2
		bra.s	Volume
VolumeDefault:	moveq	#0,d1
		move.w	#EP_MaxVolume,d2
Volume:		cmp.w	#EP_MaxVolume,d2
		bhi.w	Vol_ErrorInArguments
		move.w	d2,EPG_Volume(a5)	*### Per Arexx/Config eingest.
		ext.l	d2
		lsl.l	#6,d2
		divu	#EP_MaxVolume,d2
		ext.l	d2
		move.w	d2,DTG_SndVol(a5)
		movem.l	d1/d2,-(a7)
		jsr	A5EPP_SetVolume(a5)
		btst	#EPRMF_NoGuiInfo,d1
		bne.s	.NoCallUp
		move.w	EPG_Volume(a5),d2
		ext.l	d2
		move.l	#EUT_ChangePrefs,d7
		move.w	#EPNr_Volume,d0
		jsr	A5UserCallUp4(a5)
.NoCallUp:	move.l	(a7)+,d1
		move.l	(a7)+,ScrollArgs(a5)	*### VolumeRegler/Arexx/Config
		LA0	LNr_Volume
		*btst	#EPRMF_DownGadget,d1
		*bne.w	PrintText
		*jmp	A5ScrollNewText(a5)
		jmp	A5PrintText(a5)
Vol_ErrorInArguments:
		moveq	#EPR_ErrorinArguments,d0
		rts




*-----------------------------------------------------------------------------*
*--------------------- Der Balance-Wert wird neu eingestellt -----------------*
*-----------------------------------------------------------------------------*
BalanceRight:	move.w	#EP_MaxVolume,d2		*### Menu Arexx
		move.w	EPG_Balance(a5),d3
		cmp.w	#EP_MaxVolume,d3
		bgt.s	.Balance
		addq.l	#1,d3
		move.l	d3,d2
.Balance:	moveq	#0,d1
		bra.s	Balance
BalanceLeft:	move.w	#-EP_MaxVolume,d2		*### Menu Arexx
		move.w	EPG_Balance(a5),d3
		cmp.w	#-EP_MaxVolume,d3
		ble.s	.Balance
		subq.l	#1,d3
		move.l	d3,d2
.Balance:	moveq	#0,d1
		bra.s	Balance
BalanceDefault:	moveq	#0,d2
		moveq	#0,d1
Balance:	move.l	d1,d6
		cmp.w	#EP_MaxVolume,d2
		bgt.w	Vol_ErrorInArguments
		cmp.w	#-EP_MaxVolume,d2
		blt.w	Vol_ErrorInArguments
		move.w	d2,EPG_Balance(a5)	*### Per Arexx/Config eingest.
		move.l	d2,d1
		movem.l	d2/d6,-(a7)
		btst	#EPRMF_NoGuiInfo,d6
		bne.s	.NoCallUp
		move.w	EPG_Balance(a5),d2
		move.l	#EUT_ChangePrefs,d7
		move.w	#EPNr_Balance,d0
		jsr	A5UserCallUp4(a5)
.NoCallUp:	movem.l	(a7)+,d2/d6
		move.w	#EP_MaxVolume,d1	*### BalanceRegler/Arexx/Config
		move.w	#EP_MaxVolume,d0
		tst.l	d2
		beq.s	.SetNew
		blt.s	.SetLeft
		sub.w	d2,d1			;Links wird leiser
		bra.s	.SetNew
.SetLeft:	add.w	d2,d0			;rechts wird leiser
.SetNew:	ext.l	d0
		ext.l	d1
		move.w	d1,EPG_LeftBalance(a5)
		move.w	d0,EPG_RightBalance(a5)
		lsl.l	#6,d1
		divu	#EP_MaxVolume,d1
		lsl.l	#6,d0
		divu	#EP_MaxVolume,d0
		move.w	d1,DTG_SndLBal(a5)
		move.w	d0,DTG_SndRBal(a5)
		jsr	A5EPP_SetBalance(a5)
		LA0	LNr_Balance
		move.w	EPG_Balance(a5),d0
		ext.l	d0
		lsl.l	#6,d0
		divs	#EP_MaxVolume,d0
		ext.l	d0
		move.l	d0,ScrollArgs(a5)
		btst	#EPRMF_DownGadget,d6
		bne.w	PrintText
		jmp	A5ScrollNewText(a5)


*-----------------------------------------------------------------------------*
*--------------------- Der Speed-Wert wird neu eingestellt -------------------*
*-----------------------------------------------------------------------------*
SpeedFaster:	moveq	#MaxSpeed,d2		*### Menu Arexx
		move.w	SpeedSize(a5),d3
		cmp.w	#MaxVolume,d3
		bgt.s	.Speed
		addq.l	#1,d3
		move.l	d3,d2
.Speed:		moveq	#0,d1
		bra.s	Speed
SpeedSlower:	moveq	#-MaxSpeed,d2		*### Menu Arexx
		move.w	SpeedSize(a5),d3
		cmp.w	#-MaxSpeed,d3
		ble.s	.Speed
		subq.l	#1,d3
		move.l	d3,d2
.Speed		moveq	#0,d1
		bra.s	Speed
SpeedDefault:	moveq	#0,d2
		moveq	#0,d1
Speed:		move.l	d1,d6
		cmp.w	#MaxSpeed,d2
		bgt.w	Vol_ErrorInArguments
		cmp.w	#-MaxSpeed,d2
		blt.w	Vol_ErrorInArguments
		move.w	d2,SpeedSize(a5)	*### Per Arexx/Config eingest.
		move.w	d2,EPG_Speed(a5)
		move.l	d2,d1
		movem.l	d2/d6,-(a7)
		btst	#EPRMF_NoGuiInfo,d6
		bne.s	.NoCallUp
		move.l	#EUT_ChangePrefs,d7
		move.w	#EPNr_Speed,d0
		jsr	A5UserCallUp4(a5)
.NoCallUp:	movem.l	(a7)+,d2/d6
		tst.b	PlayOn(a5)
		beq.w	.NoPlay
		move.l	d2,d3
		move.l	#EP_SetSpeed,d0
		move.l	d6,-(a7)
		jsr	A5CallUp(a5)
		jsr	A5SetTimer(a5)
		move.l	(a7)+,d6
.NoPlay:	LA0	LNr_Speed
		move.w	EPG_Speed(a5),d0
		ext.l	d0
		move.l	d0,ScrollArgs(a5)
		btst	#EPRMF_DownGadget,d6
		bne.w	PrintText
		jmp	A5ScrollNewText(a5)


*------------ Belegten Speicher frs Pull-Down-Menu allocieren ------------*
AllocMenuMem:	movem.l	d1-a6,-(a7)		;|
		move.b	#1,MenuMemused(a5)	;| Allocmenumem mu so bleiben!
		move.l	MenuMemAdr(a5),d0	;| Allocmenumem+16=move.l 4,a6
		bne.s	.Return			;|
		move.l	4,a6			;+-+- Abfrage 1 !!
		move.l	MenuMemSize(a5),d0
		beq.s	.Return
		jsr	A5AllocMem(a5)
		move.l	d0,MenuMemZeiger(a5)
		move.l	d0,MenuMemAdr(a5)
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*------------------------ Gibt Directory-Speicher frei ----------------------*
FreeDirMem:	movem.l	d0-a6,-(a7)		;|
		jsr	A5FreeDirPuffer(a5)	;|
		move.l	MenumemAdr(a5),d0	;|
		beq.s	.NoMem			;| Offset: 22
		move.l	d0,a1			;|
		move.l	MenuMemSize(a5),d0	;|
		beq.s	.Nomem			;|
		move.l	4.w,a6			;+-+- Abfrage 2 (2c78)
		jsr	_LVOFreeMem(a6)
.NoMem:		clr.l	MenuMemSize(a5)
		clr.l	MenuMemZeiger(a5)
		clr.l	MenuMemAdr(a5)
		movem.l	(a7)+,d0-a6
		rts


**--------------------------------------------------------------------------*
*SetDirMemSize:	cmp.l	#MinMenuSize,d2
*		blo.s	FunctionAborted
*		bclr	#0,d2
*		cmp.l	MenuMemSize(a5),d2		;gleich gro ???
*		beq.s	.Aborted
*		move.l	d2,-(a7)
*		jsr	A5FreeDirMem(a5)
*		move.l	(a7)+,MenuMemSize(a5)
*		cmp.l	#Mode_Config,TestBits(a5)
*		beq.s	.ItsOk
*		jsr	A5AllocMenuMem(a5)
*		bne.w	LoadAutoDir
*		moveq	#EPR_NotEnoughMem,d0		;Out of Mem
*		jmp	A5ScrollNewFehler(a5)
*.ItsOk:		moveq	#0,d0
*		rts
*
*.Aborted:	cmp.l	#Mode_Config,TestBits(a5)
*		beq.s	.ItsOk
*
*FunctionAborted:moveq	#EPR_Functionaborted,d0
*		jmp	A5ScrollNewFehler(a5)




*------------------------------ Setze Menufont ------------------------------*
SetMenuFont:	tst.l	d2			*bereits im Puffer
		bne.s	.RefreshMenuF
		lea	MenuFontPuffer(a5),a0
		lea	SelectFontPuffer(a5),a1
		jsr	A5StringCopy(a5)
		lea	SelectFontPuffer(a5),a0
		move.l	a0,a2
		moveq	#6,d1			;Min
		moveq	#0,d2			;Max
		move.w	MenuFont+4(a5),d3	;eing.
		moveq	#EPFB_Proportional,d4
		jsr	A5FontRequest(a5)
		bne.w	ScrollNewFehler
		move.l	d1,d3

		move.l	d1,d3
		bra.s	.FontOk
.RefreshMenuF:
		clr.b	(a2,d2.w)		;Ende markieren
.FontOk:	tst.l	d3
		beq.s	.Return

		jsr	A5ClearMenuStrip(a5)
		move.l	a2,a0
		lea	MenuFontPuffer(a5),a1
		move.l	a1,MenuFont(a5)
		jsr	A5StringCopy(a5)
		move.w	d3,MenuFont+4(a5)
		clr.w	MenuFont+6(a5)
		jsr	A5RefreshMenu(a5)
.Return:	bra.w	FontScroller

*---------------------------- Setzte Modulesfont ----------------------------*
SetModulesFont:	tst.l	d2			*bereits im Puffer
		bne.s	.RefreshMenuF
		lea	ModulesFontPuffer(a5),a0
		lea	SelectFontPuffer(a5),a1
		jsr	A5StringCopy(a5)
		lea	SelectFontPuffer(a5),a0
		moveq	#6,d1			;Min
		moveq	#0,d2			;Max
		move.w	ModulesFont+4(a5),d3	;eing.
		moveq	#EPFB_Proportional,d4
		jsr	A5FontRequest(a5)
		bne.w	ScrollNewFehler
		lea	SelectFontPuffer(a5),a2
		move.l	d1,d3
		bra.s	.FontOk
.RefreshMenuF:	clr.b	(a2,d2.w)		;Ende markieren
.FontOk:	tst.l	d3
		beq.s	.Return
		jsr	A5ClearMenuStrip(a5)
		move.l	a2,a0
		lea	ModulesFontPuffer(a5),a1
		move.l	a1,ModulesFont(a5)
		jsr	A5StringCopy(a5)
		move.w	d3,ModulesFont+4(a5)
		clr.w	ModulesFont+6(a5)
		jsr	A5RefreshMenu(a5)
.Return:	bra.w	FontScroller

*---------------------------- Setzte Modulesfont ----------------------------*
SetScrollFont:	tst.l	d2			*bereits im Puffer
		bne.s	.RefreshMenuF
		lea	ScrollFontPuffer(a5),a0
		lea	SelectFontPuffer(a5),a1
		jsr	A5StringCopy(a5)

		*------------- Gui bescheid sagen -----------*
		* d1=Min Height
		* d2=Max Height
		* d3=Eing. Height
		* d4=Flags
		move.l	#EUT_GetPrefs,d7
		move.w	#EPNr_ScrollFont,d0
		jsr	A5UserCallUp4(a5)		*>- d1= act. Height
		beq.s	FontReturn			*>- d2= act. Height
		lea	SelectFontPuffer(a5),a0
		jsr	A5FontRequest(a5)
		bne.w	ScrollNewFehler
		move.l	d1,d3
		lea	SelectFontPuffer(a5),a2
		bra.s	.FontOk
.RefreshMenuF:	clr.b	(a2,d2.w)		;Ende markieren
.FontOk:	tst.l	d3
		beq.s	FontReturn
		move.l	a2,a0
		lea	ScrollFontPuffer(a5),a1
		move.l	a1,ScrollFont(a5)
		jsr	A5StringCopy(a5)
		move.w	d3,ScrollFont+4(a5)
		clr.w	ScrollFont+6(a5)

		*------------- Gui bescheid sagen -----------*
		move.l	#EUT_ChangePrefs,d7
		move.w	#EPNr_ScrollFont,d0
		lea	ScrollFontPuffer(a5),a0
		move.w	ScrollFont+4(a5),d1		;Height
		jsr	A5UserCallUp4(a5)
FontScroller:	LA0	LNr_OperationSuccesful
		jsr	A5ScrollNewText(a5)
		moveq	#0,d0
		rts

FontReturn:	moveq	#EPR_Functionaborted,d0
		jmp	A5ScrollNewFehler(a5)


*-----------------------------------------------------------------------------*
* Es kann ein Font ausgewhlt werden.					      *
* Input: a0=def. Font							      *
*	 d1=Min Height							      *
*	 d2=Max Height							      *
*	 d3=Eing. Height						      *
*	 d4=Flags							      *
* Output:d0=Error oder NULL						      *
*	 d1=Height der Font						      *
*	 im def. Puffer ist der Fontname drin				      *
*-----------------------------------------------------------------------------*
ASL_TB	equ (TAG_USER+$80000)
ASLFO_TitleText       equ ASL_TB+1   ; Title of requester
ASLFO_InitialName     equ ASL_TB+10  ; Initial contents of Name gadget
ASLFO_MinHeight       equ ASL_TB+16  ; Minimum font height to display
ASLFO_MaxHeight       equ ASL_TB+17  ; Maximum font height to display
ASLFO_FilterFunc      equ ASL_TB+49  ; Function to filter fonts
ASLFO_InitialSize     equ ASL_TB+11  ; Initial contents of Size gadget

FontRequest:	movem.l	d2-a6,-(a7)
		move.b	FileReqMode(a5),d0
		cmp.b	#EPNrF_Asl,d0
		beq.w	.AslLibrary
.doREQTO
		move.l	a0,d6
		moveq	#0,d4
		moveq	#EPR_FileReqCancelled,d7		;Fehler
		cmp.l	#Mode_Config,Testbits(a5)
		beq.s	.Return

		moveq	#EPR_CantFindReqTools,d7
		LA1	LNr_ReqToolsname
		lea	EPG_ReqToolsBase(a5),a3
		moveq	#38,d0
		jsr	A5OpenLib(a5)
		beq.w	.Return

		*---- ReqTools-FontRequest ----*
		* Output: d0=Nummer des Gadgets
		*	  0 = ganz rechts
		*	  1 = von links nach rechts
		moveq	#EPR_Functionaborted,d7
		moveq	#2,d0
		sub.l	a0,a0
		move.l	EPG_ReqToolsBase(a5),a6
		jsr	_LVORTAllocRequestA(a6)
		move.l	d0,a4
		tst.l	d0
		beq.s	.Return

		move.l	a4,a1
		LA3	LNr_SelectFont		*Title
		*lea	Tags,a0			;Tags
		sub.l	a0,a0
		jsr	_LVORTFontRequestA(a6)
		tst.l	d0
		beq.s	.FreeRequest

		*- Font aus Struktur rauslesen -*
		*move.l	rtfo_DefaultFont(a4),a0
		*lea	rtfo_Attr(a4),a0	;Fontstruct
		lea	16(a4),a0		;Fontstruct
		move.w	4(a0),d4		;Height
		move.l	(a0),a0			;Name
		move.l	d6,a1		
		jsr	A5StringCopy(a5)
		moveq	#0,d7			;kein Error

.FreeRequest:	move.l	a4,a1
		jsr	_LVORTFreeRequest(a6)
.Return:	move.l	d7,d0
		move.l	d4,d1			;Height
		movem.l	(a7)+,d2-a6
		tst.l	d0
		rts

.AslLibrary
	moveq	#EPR_FileReqCancelled,d7	;Fehler

	move.l	DTG_AslBase(a5),d0		;sollte nicht
	beq	.doREQTO			;vorkommen
	move.l	d0,a6

	movem.l	d1-d4/a0,-(sp)
	moveq	#1,d0				;ASL_FontRequest,d0
	suba.l	a0,a0
	jsr	_LVOAllocAslRequest(A6)
	movem.l	(sp)+,d1-d4/a0
	move.l	d0,d5
	beq.w	.doREQTO

	lea	TextRequestArgs(A5),a1
	move.l	#ASLFO_TitleText,(a1)+
	LA2	LNr_SelectFont		*Title
	move.l	a2,(A1)+

	and.l	#$fff,d1
	beq.s	.skip
	move.l	#ASLFO_MinHeight,(a1)+
	move.l	d1,(a1)+
.skip
	and.l	#$fff,d2
	beq.s	.skip2
	move.l	#ASLFO_maxHeight,(a1)+
	move.l	d2,(a1)+
	move.w	d2,.sonstwo
	move.l	#ASLFO_FilterFunc,(a1)+
	lea	.myhook(pc),a2
	move.l	a2,(a1)+
.skip2

	move.l	#ASLFO_Initialname,(a1)+
	move.l	a0,(a1)+
	move.l	a0,d6

	and.l	#$fff,d3
	beq.s	.skip3
	move.l	#ASLFO_InitialSize,(a1)+
	move.l	d3,(a1)+
.skip3
	clr.l	(a1)
	lea	TextRequestArgs(A5),a1
	move.l	d0,a0
	jsr	_LVOAslRequest(a6)
	tst.l	d0
	beq.s	.free

	move.l	d5,a0
	move.w	8+4(a0),d4		;fo_attr+ta_ysize(a0),d4;Height
	move.l	8+0(a0),a0		;fo_attr+ta_name(a0),a0	;Name
	move.l	d6,a1		
	jsr	A5StringCopy(a5)
	moveq	#0,d7			;kein Error
.free
	move.l	d5,a0
	jsr	_LVOFreeAslRequest(A6)
	bra	.return
.myhook					;Filterhook, um zu groe Fonts nicht
					;anzuzeigen
	dcb.b	mln_size,0
	dc.l	.my_hook
	dc.l	0
	dc.l	0
.sonstwo	dc.w	0
.my_hook
	move.l	d1,-(sp)
	move.w	.sonstwo(pc),d1
	moveq	#0,d0
	cmp.w	4(a1),d1		;ta_ysize(a1),d1
	blt.s	.hi
	moveq	#1,d0
.hi		
	move.l	(sp)+,d1
	rts


*------------------------- neuen PublicScreen setzen ----------------------*
	*----------- existiert dieser Screen ----------*
PublicScreen:
		lea	PubScreenName2(a5),a0
		tst.b	(a0)
		bne.s	.HoleLock

	*--------- Workbench eintragen -------*
		LA0	LNr_DefPubScreen
		lea	PubScreenName2(a5),a1
		move.w	#PubScreenSize-2,d1
		jsr	A5StringCopy2(a5)
		lea	PubScreenName2(a5),a0
.HoleLock:	move.l	DTG_Intuitionbase(a5),a6
		jsr	_LVOLockPubScreen(a6)
		tst.l	d0
		beq.w	.Error

		move.l	d0,-(a7)
		lea	PubScreenName2(a5),a0
		lea	PubScreenName(a5),a1
		move.w	#Pubscreensize-2,d1
		jsr	A5StringCopy2(a5)

	*-------------- Alles andere closen -----------*
		*moveq	#USClass_DeActivate,d0	;User-Type (Dumy) Prg stoppen
		*jsr	A5SendeAllMessage(a5)
		moveq	#USClass_Hide,d0
		jsr	A5SendeAllMessage(a5)
		jsr	A5CloseMainWindow(a5)

	*-------------- Alles andere ffnen -----------*
		jsr	A5OpenMainWindow(a5)
		jsr	A5WaitMouse(a5)
		jsr	A5OpenOldEngines(a5)
		jsr	A5ScreenToFront(a5)

	*-------------- Publicscreenname --------------*
		move.l	(a7)+,a1
		sub.l	a0,a0
		move.l	DTG_Intuitionbase(a5),a6
		jsr	_LVOUnlockPubScreen(a6)		;PUBscreen freigeben

		move.w	#LNr_PublicScreen,d0
		lea	PubScreenName(a5),a0
		move.l	a0,ScrollArgs(a5)
		jmp	A5ScrollNew(a5)

.Error:		moveq	#EPR_ErrorInArguments,d0
		jmp	A5ScrollNewFehler(a5)




*-------------------------------------------------------------------------*
* ConfigPuffer:
*	 0 Bytes Name
*	14 KoorX
*	16 KoorY
*	18 Flags
*	20 Special
*	24 SizeOF
*-------------------------------------------------------------------------*
*-------------------------------------------------------------------------*
*- Alle aktiven UserProgramme, die in der BatchDatei sind werden gesaved -*
*-------------------------------------------------------------------------*
*SC_GiveLBName:	move.l	a0,a2
*		tst.b	OnEngineBatch(a5)
*		beq.s	.NoMoreEngines
*
*		lea	EPG_FirstUserStruct(a5),a3
*.RetryInStruct:	move.l	(a3),d0
*		beq.s	.NoMoreEngines
*		move.l	d0,a3
*		move.l	UPrgS_UFlags(a3),d1
*		and.l	#UprgB_Engine+UPrgB_OldBatch,d1
*		subq.l	#UprgB_Engine+UPrgB_OldBatch,d1
*		bne.s	.RetryInStruct
*
*	*------ Wir haben jetzt ein Engine, welches in der Batch -----*
*	*------ Datei vorkommt und aktiv ist, also gesaved wird   -----*
*		move.l	a2,a0				;String "LoadEngine"
*		jsr	A5SaveConfigText(a5)
*		bne.s	.NoMoreEngines
*		lea	ArexxPuffer(a5),a1
*		move.b	#" ",(a1)+
*		move.b	#'"',(a1)+
*
*		moveq	#13,d1
*		move.l	UPrgS_BatchName(a3),a0
*		jsr	A5StringCopy(a5)
*		move.b	#'"',(a1)+
*		move.b	#10,(a1)+
*		clr.b	(a1)
*
*		lea	ArexxPuffer(a5),a0
*		jsr	A5SaveConfigText(a5)
*		bne.s	.NoMoreEngines
*		bra.s	.RetryInStruct
*.NoMoreEngines:rts

**------------------ Setze die User-Config in einen Puffer ----------------*
*KM_SetUserConfig:lea	UserConfigPuffer(a5),a0
*		move.l	UserConfigNr(a5),d0
*		moveq	#AnzMaxEngines,d1
*		cmp.l	d1,d0
*		bhi.w	.Error
*		mulu	#CPN_PufferSize,d0
*		lea	(a0,d0.l),a3
*		move.l	a3,a1
*		move.l	EPG_Arg1(a5),a0
*		move.l	EPG_Arg2(a5),d1
*		moveq	#14,d0
*		cmp.l	d0,d1
*		blo.s	.Stringok
*		move.l	d0,d1
*.Stringok:	jsr	A5StringCopy2(a5)
*
*
**---------------------------- Test auf String ----------------------------*
******************** Check auf Zeicherkette **********************
*** INPUT:	a1 = Zeichenkette (mit Leerzeichen)		*
*** OutPut	a1 = Start of next String			*
***		d0 = Start of String				*
***		d1 = Length of String				*
******************************************************************
*		move.l	FirstArg(a5),a1
*		jsr	A5FindFileName(a5)
*		moveq	#0,d0
*		cmp.l	a1,d0
*		beq.s	.NoMoreArgs
*
*********** Zeichenkette in Zahl konvertieren ******************
*** INPUT:  a0-Zeichenkette                                   **
*** RESULT: A1-nchstes Argument (oder 0)                     **
***         D1-Ausgabewert als Dualzahl                       **
***         D0-Indikator (-1=Fehler,0=ok)                     **
****************************************************************
*		move.l	a1,a0		;Zeiger auf 2.Argument
*		jsr	A5Getnumber(a5)	;Zeichenkette in Long-Zahl umwandeln
*		tst.l	d0
*		bne.w	.ErrorInArgs
*		move.w	d1,CPN_WinX(a3)
*		moveq	#0,d0
*		cmp.l	a1,d0
*		beq.s	.NoMoreArgs
*
*	*------ Y-Koordinate rauskriegen --------*
*		move.l	a1,a0		;Zeiger auf 2.Argument
*		jsr	A5Getnumber(a5)	;Zeichenkette in Long-Zahl umwandeln
*		tst.l	d0
*		bne.w	.ErrorInArgs
*		move.w	d1,CPN_WinY(a3)
*		moveq	#0,d0
*		cmp.l	a1,d0
*		beq.s	.NoMoreArgs
*
*	*------- Engine-Flags rauskriegen -------*
*		move.l	a1,a0		;Zeiger auf 2.Argument
*		jsr	A5Getnumber(a5)	;Zeichenkette in Long-Zahl umwandeln
*		tst.l	d0
*		bne.w	.ErrorInArgs
*		move.w	d1,CPN_Flags(a3)
*		moveq	#0,d0
*		cmp.l	a1,d0
*		beq.s	.NoMoreArgs
*
*	*--- Engine-Special-Zelle rauskriegen ---*
*		move.l	a1,a0		;Zeiger auf 2.Argument
*		jsr	A5Getnumber(a5)	;Zeichenkette in Long-Zahl umwandeln
*		tst.l	d0
*		bne.w	.ErrorInArgs
*		move.l	d1,CPN_Special(a3)
*		moveq	#0,d0
*		cmp.l	a1,d0
*		beq.s	.NoMoreArgs
*
*	*--- Engine-Special-Zelle rauskriegen ---*
*		move.l	a1,a0		;Zeiger auf 2.Argument
*		jsr	A5Getnumber(a5)	;Zeichenkette in Long-Zahl umwandeln
*		tst.l	d0
*		bne.w	.ErrorInArgs
*		move.l	d1,CPN_Special2(a3)
*		moveq	#0,d0
*		cmp.l	a1,d0
*		beq.s	.NoMoreArgs
*
*	*--- Engine-Special-Zelle rauskriegen ---*
*		move.l	a1,a0		;Zeiger auf 2.Argument
*		jsr	A5Getnumber(a5)	;Zeichenkette in Long-Zahl umwandeln
*		tst.l	d0
*		bne.w	.ErrorInArgs
*		move.l	d1,CPN_Special3(a3)
*
*
*	*---- Alle Argumente in Puffer aufgenommen ----*
*.NoMoreArgs:	addq.l	#1,UserConfigNr(a5)
*		moveq	#0,d0
*		rts
*
*.ErrorInArgs:	moveq	#EPR_ErrorInArguments,d0
*		rts
*.Error:		moveq	#EPR_NoMoreEngines,d0
*CF_Return:	rts
*

**----------- Setze die Userprogramm-Config in UserProgramm ----------------*
*SetUserConfig:	movem.l	d0-a6,-(a7)
*		move.l	#AnzMaxEngines-1,d6
*		moveq	#0,d0
*
*	*----- Config fr nchstes Engine suchen ----*
*.NextEngine:	addq.l	#1,d0				;laufende User-Nummer
*		*jsr	A5SetOneUserConfig(a5)
*		dbf	d6,.NextEngine		
*.Return:	movem.l	(a7)+,d0-a6
*		rts
*
**----------------- UserProgrammname in ConfigPuffer finden -------------*
**	Diese Routine wird beim USClass_NewEngine aufgerufen 		*
** Input = d0 UserNr							*
**-----------------------------------------------------------------------*
*SetOneUserConfig:movem.l d0-a6,-(a7)
*		jsr	A5FindEUSStruct(a5)
*		bne.s	.NoConfigs
*		move.l	a0,a4
*		lea	UserConfigPuffer-CPN_PufferSize(a5),a3
*;		move.l	UserConfigNr(a5),d7
*;		ble.s	.NoConfigs
*;		subq.l	#1,d7
*
*		move.l	#AnzMaxEngines-1,d7
*
*.FindNext:	lea	CPN_PufferSize(a3),a3		;Ak Puffer finden
*		move.l	a3,a1
*		tst.b	(a1)				;Puffer nicht benutzt ?
*		beq.s	.ZuDBF
*
*		move.l	EUS_UserName(a4),a2
*
*		jsr	A5StrCmp2(a5)
*		beq.s	.EngineFound
*.ZuDbf:		dbf	d7,.FindNext
*.NoConfigs:	movem.l	(a7)+,d0-a6
*		rts
*
*	*----- Eine Config fr dieses Engine wurde gefunden -----*
*.EngineFound:	clr.b	(a3)				;Kennung fr ConfigPu
*		move.w	CPN_Flags(a3),EUS_Flags(a4)
*		move.w	CPN_WinX(a3),EUS_WinX(a4)
*		move.w	CPN_WinY(a3),EUS_WinY(a4)
*		move.l	CPN_Special(a3),EUS_Special(a4)
*		move.l	CPN_Special2(a3),EUS_Special2(a4)
*		move.l	CPN_Special3(a3),EUS_Special3(a4)
*
*	*------- Haken erstmal lschen -------*
*		move.w	EUS_UserNr(a4),d0
*		jsr	A5FindUserStruct(a5)
*		bne.s	.NotAOpenUser
*
*;		move.l	a3,UPrgS_CPNAdr(a0)		;ConfigAdr sichern
*
*		move.w	EUS_Flags(a4),d0
*		bclr.b	#0,UPrgS_Flags(a0)		;Hacken lschen
*
*		btst	#EUSF_ZipWin,d0
*		bne.s	.OpenZipWindow
*
*		btst	#EUSF_OpenWin,d0
*		beq.s	.NotAOpenUser
*
*	*----- Hacken wieder setzen -------*
*.OpenZipWindow:	bset.b	#0,UPrgS_Flags(a0)		;Hacken setzen
*
*
**---------------------------------------------------------------------------*
**-- Eine Message nach dem angegebenen Userprogramm senden und Warten, bis --*
**-------- diese wieder zurckkommt und auswerten der ReturnMessage ---------*
**--- Die SS_StructAdr wird automatisch gesetzt, sowie Type und Replyport ---*
**---- _LVOPutMsg(a6)							----*
**----									----*
**---- Input:	d0 = UserNr						----*
**----		d1 = Enabled(0) oder Disabled(1)			----*
**----		d2 = US_Class						----*
**----		d3 = Command						----*
**----		d4 = ArgList						----*
**----		d5 = Result						----*
**----									----*
**---- OutPut:	a0 = Adresse der Struktur				----*
**----		d0 = Fehler						----*
**---------------------------------------------------------------------------*
*	*----- Message an User-Programm senden ----*
*.NotAOpenUser:	moveq	#0,d0
*		move.w	EUS_UserNr(a4),d0
*		moveq	#0,d1
*		moveq	#USClass_NewConfig,d2
*		moveq	#0,d3
*		moveq	#0,d4
*		moveq	#0,d5
*		jsr	A5SendeOneMessage(a5)
*		subq.l	#1,UserConfigNr(a5)
*		bra.b	.NoConfigs
*
*
*		

*-------------------------------------------------------------------------*
SC_Engine:	moveq	#AnzMaxEngines-1,d5
		moveq	#1,d4				;laufende User-Nummer

.NextVoice:	move.l	a0,a4
		move.l	d4,d0
		jsr	A5FindUserStruct(a5)
		bne.w	.NoUserFound
		move.l	a0,a2
		move.l	UPrgS_EUSAdr(a2),d0		;indirect Batch
		beq.w	.NoUserFound
		move.l	d0,a0

		cmp.l	#TagUserID,(a0)
		bne.s	.TaskUser


	*--------- TagUser-Configroutine aufrufen --------*
		move.l	EUS_TagList(a0),d0
		beq.w	.NoUserFound
		move.l	d0,a6
		move.l	#EUT_GetConfig,d0
		moveq	#0,d3			;Error fr d0
		jsr	A5CallUp3(a5)
		beq.w	.NoUserFound

	*------ In Config-Datei "Engine Name" schreiben -------*
		move.l	a4,a0				;Engine schreiben
		jsr	A5SaveConfigText(a5)
		bne.w	.Return
		lea	ArexxPuffer(a5),a1
		move.b	#" ",(a1)+
		move.b	#'"',(a1)+
		move.l	UPrgS_Name(a2),a0		;Namen schreiben
		move.l	UPrgS_EUSAdr(a2),a2
		moveq	#20,d1
		jsr	A5StringCopy2(a5)
		move.b	#'"',(a1)+
		move.b	#' ',(a1)+
		bra.s	.SaveConfigRest

	*---------------- Config fr TaskUser saven --------------*
.TaskUser:	move.l	EUS_MsgFlags(a0),d0
		btst	#USMF_ChangeConfig,d0
		beq.w	.NoUserFound

		move.l	a4,a0
		jsr	A5SaveConfigText(a5)
		bne.w	.Return
		lea	ArexxPuffer(a5),a1
		move.b	#" ",(a1)+
		move.b	#'"',(a1)+

		move.l	UPrgS_Name(a2),a0
		move.l	UPrgS_EUSAdr(a2),a2
		moveq	#20,d1
		jsr	A5StringCopy2(a5)
		move.b	#'"',(a1)+
		move.b	#' ',(a1)+

*---------------------------------------------------------------------------*
*-- Eine Message nach dem angegebenen Userprogramm senden und Warten, bis --*
*-------- diese wieder zurckkommt und auswerten der ReturnMessage ---------*
*--- Die SS_StructAdr wird automatisch gesetzt, sowie Type und Replyport ---*
*---- _LVOPutMsg(a6)							----*
*----									----*
*---- Input:	d0 = UserNr						----*
*----		d1 = Enabled(0) oder Disabled(1)			----*
*----		d2 = US_Class						----*
*----		d3 = Command						----*
*----		d4 = ArgList						----*
*----		d5 = Result						----*
*----									----*
*---- OutPut:	a0 = Adresse der Struktur				----*
*----		d0 = Fehler						----*
*---------------------------------------------------------------------------*
		movem.l	d1-d6,-(a7)
		move.l	d4,d0
		moveq	#0,d1
		moveq	#USClass_GetConfig,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		jsr	A5SendeOneMessage(a5)
		movem.l	(a7)+,d1-d6
		tst.l	d0
		bne.s	.NoUserFound

	*------ X-Koordinate sichern -------*
.SaveConfigRest:move.l	a1,a0
		moveq	#0,d0
		move.w	EUS_WinX(a2),d0
		jsr	A5HexDez(a5)
		move.b	#' ',(a0)+

	*------- Y-Koordinate sichern ------*
		moveq	#0,d0
		move.w	EUS_WinY(a2),d0
		jsr	A5HexDez(a5)
		move.b	#' ',(a0)+

	*-------- Flags sichern ------*
		moveq	#0,d0
		move.w	EUS_Flags(a2),d0
		jsr	A5HexDez(a5)
		move.b	#' ',(a0)+

	*------- Flags sichern -------*
		move.l	EUS_Special(a2),d0
		jsr	A5HexDez(a5)
		move.b	#10,(a0)+
		clr.b	(a0)

		lea	ArexxPuffer(a5),a0
		jsr	A5SaveConfigText(a5)
		bne.s	.Return
.NoUserFound:	addq.l	#1,d4
		move.l	a4,a0
		dbf	d5,.NextVoice
.Return:	moveq	#0,d0
		rts


*-------- suche Task und checke nebenbei so ziemlich alle keyon(a5) !! ------*
FindTaskDummy:						;+-+-+-
		movem.l	d1-a6,-(sp)

		lea	KeyBeqTable-100,a0
		lea	EPG_Wordreserved7-100(A5),a1
		lea	FreeBatchPlMem-150,a2
		lea	100(a0),a0
		add.l	#150,a2
		moveq	#keybeqcount-1,d0
		move.l	#$4a2d<<16+keyon-8,d3
		addq.l	#8,d3
.check		move.l	(a0)+,d1
		move.l	(a2,d1.l),d2
		sub.l	d3,d2		;tst.b	keyon(a5)
		add.b	d2,101(a1)			;wordreserved7+1
		move.b	4(a2,d1.l),d2
		sub.b	#$67,d2				;beq.w
		add.b	d2,101(a1)			;wordreserved7+1
		move.b	5(a2,d1.l),d2			;beq.w 2. Teil
		add.w	d2,102(a1)			;wordreserved8+1
		move.w	6(a2,d1.l),d2
		bne.s	.ok
		addq.w	#1,102(a1)			;wordreserved8+1
.ok
		addq.b	#1,98(A1)			;wordreserved6
		dbf	d0,.check

		lea	KeyBneTable-100,a0
		moveq	#keybnecount-1,d0
		lea	100(a0),a0
.check2		move.l	(a0)+,d1
		move.l	(a2,d1.l),d2
		sub.l	d3,d2				;tst.b	keyon(a5)
		add.b	d2,101(a1)			;wordreserved7+1
		move.b	4(a2,d1.l),d2
		sub.b	#$66,d2				;bne.w
		add.b	d2,101(a1)			;wordreserved7+1
		move.b	5(a2,d1.l),d2			;bne.w 2. Teil
		add.w	d2,102(a1)			;wordreserved8+1
		move.w	6(a2,d1.l),d2
		bne.s	.ok2
		addq.w	#1,102(a1)			;wordreserved8+1
.ok2
		addq.b	#1,98(A1)			;wordreserved6
		dbf	d0,.check2

		ExecBase
		suba.l	a1,a1
		move.l	#_LVOFindtask-21,d0
		jsr	21(A6,d0.w)
		movem.l	(sp)+,d1-a6
		rts



	*------------- Verschlsselung 2 von Struct 1 aufheben -----------*
DecodeStruct1:	lea	TextPuffer+2400(a5),a3
		move.l	Key_Struct-(TextPuffer+2400)(a3),d0
		beq.s	.Ok
		move.l	d0,a4
		move.b	EPKF_V1DecodeK(a4),Code-(TextPuffer+2400)(a3)
		move.b	EPKF_V1Decode1(a4),CodePara1-(TextPuffer+2400)(a3)
		move.b	EPKF_V1Decode2(a4),CodePara2-(TextPuffer+2400)(a3)
		move.b	EPKF_V1Decode3(a4),CodePara3(a5)
		move.b	EPKF_V1Decode4(a4),CodePara4(a5)
		lea	EPKF_KVersion(a4),a0
		moveq	#EPKF_V1ChkSum-EPKF_KVersion,d0

		move.l	A5StringCopy+2(a5),a2

	;	lea	StringCopy(pc),a2
		lea	DecodeAndChkSum-Stringcopy(a2),a2
		jsr	(a2)

	;	cmp.w	EPKF_V1ChkSum(a4),d0
	;	beq.w	.Ok
	;	clr.l	KeyFault-(TextPuffer+2400)(a3)
.Ok:		move.l	DTG_Intuitionbase-(TextPuffer+2400)(a3),d0
		rts


*-----------------------------------------------------------------------------*
FreeConfigDir:	movem.l	d0-a6,-(a7)
		move.l	ConfigPfadAdr(a5),d0
		beq.s	.NoConfigDir
		move.l	d0,a1
		move.l	ConfigPfadSize(a5),d0
		beq.s	.NoConfigDir
		EXECBase
		jsr	_LVOFreeMem(a6)
.NoConfigDir:	clr.l	ConfigPfadAdr(a5)
		clr.l	ConfigPfadSize(a5)
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
SaveConfig:	jsr	A5WaitMouse(a5)
		LA0	LNr_SW_SaveConfig
		jsr	A5PrintText(a5)
		tst.l	d2
		beq.w	.FileReq



		*------ Strings vorbereiten ----*
		move.l	d3,d5
		move.l	a2,a1
		subq.l	#1,d2
		move.l	d2,d3
		jsr	A5GetFilename(a5)
		cmp.l	a1,a2
		beq.w	.OpenConfig
		move.l	a1,a0
		jsr	A5BerechStringSize(a5)
		move.l	d0,d4

		move.l	d0,d1
		subq.l	#2,d1
		move.l	a1,a0
		lea	(TextPuffer+TextPufferSize)-Namenlange-50(a5),a1
		jsr	A5StringCopy2(a5)


		move.l	a2,a0
		lea	(TextPuffer+TextPufferSize)-DirPufferSize-Namenlange-100(a5),a1
		move.w	#DirPufferSize-2,d1
		jsr	A5StringCopy2(a5)

		lea	(TextPuffer+TextPufferSize)-DirPufferSize-Namenlange-100(a5),a1
		move.w	#DirPufferSize-2,d5
		sub.w	d1,d5
		sub.w	d4,d5
		clr.b	(a1,d5)
		bra.s	.SetConfig	

*		move.l	a2,a1
*		clr.b	SaveFilePuffer(a5)
*		lea	SaveDirPuffer(a5),a0
*		lea	1(a2,d2.w),a3
*		cmp.w	#DirPufferSize,d3
*		blo.s	.DirSizeOk
*		move.l	#DirPuffersize,d3
*.DirSizeOk:	jsr	A5CreateDirAusPath(a5)
*		cmp.l	a0,a3
*		beq.w	.OpenConfig
*		move.l	a0,a1			;Start of Filename
*
*
*
*.OnlyFilename:	lea	SaveFilePuffer(a5),a0
*		jsr	A5CopyFileName(a5)
*		tst.l	d5			;Multiselect ????
*		beq.w	.OpenConfig
*

	*------- Filerequester ----------*
.FileReq:	move.l	EPG_ConfigDirArrayPtr(a5),a0
		lea	(TextPuffer+TextPufferSize)-DirPufferSize-Namenlange-100(a5),a1
		move.w	#DirPufferSize-2,d1
		jsr	A5StringCopy2(a5)

		LA0	LNr_ConfigName
		lea	(TextPuffer+TextPufferSize)-Namenlange-50(a5),a1
		jsr	A5StringCopy(a5)

	lea	(TextPuffer+TextPufferSize)-DirPufferSize-Namenlange-100(a5),a1
	lea	(TextPuffer+TextPufferSize)-Namenlange-50(a5),a2
		LA0	LNr_FR_SaveConfig
		jsr	A5GetMainWindowHandle(a5)
		move.l	d0,a3
		moveq	#0,d0			;Kennung ->> File zu laden
		jsr	A5FileRequest2(a5)
		bne.w	ScrollNewFehler

.SetConfig:
	lea	(TextPuffer+TextPufferSize)-DirPufferSize-Namenlange-100(a5),a0
		jsr	A5BerechStringSize(a5)
		addq.l	#2,d0
		move.l	d0,d5
		jsr	A5AllocMem(a5)
		beq.w	.Error
		jsr	A5FreeConfigDir(a5)
		move.l	d0,EPG_ConfigDirArrayPtr(a5)
		move.l	d0,ConfigPfadAdr(a5)
		move.l	d5,ConfigPfadSize(a5)

	lea	(TextPuffer+TextPufferSize)-DirPufferSize-Namenlange-100(a5),a0
		*move.l	a0,LoadFilePath(a5)
		move.l	d0,a1
		move.l	d5,d1
		subq.l	#3,d1
		jsr	A5StringCopy2(a5)


		lea	(TextPuffer+TextPufferSize)-Namenlange-50(a5),a2
.OpenConfig:	move.l	EPG_ConfigDirArrayPtr(a5),LoadFilePath(a5)
		jsr	A5CreateLoadPath(a5)
		lea	PathPuffer(a5),a0
		move.l	a0,a2
		jsr	A5BerechStringSize(a5)
		move.l	d0,d2

	*------------ Config speichern ----------*
		lea	TextPuffer(a5),a1
		move.l	a2,a0
		move.l	d2,d1
		subq.l	#1,d1
		jsr	A5StringCopy2(a5)
		lea	TextPuffer(a5),a1
		move.l	a1,d1
		move.l	#1006,d2
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOOpen(a6)
		move.l	d0,SaveHandle(a5)
		tst.l	d0
		beq.w	.Error

	*-- Engines anweisen, alle notwendigen Einstellungen --
	*-- in die Merkzellen zu setzen und falls notwendig  --
	*-- eigene Prefs speichern			     --
		moveq	#USClass_GetConfig,d0
		jsr	A5SendeAllMessage(a5)
		moveq	#USClass_SaveConfig,d0
		jsr	A5SendeAllMessage(a5)

		lea	EngineDir(a5),a1
		jsr	A5MakeCorrectDir(a5)
		lea	PlayersDir(a5),a1
		jsr	A5MakeCorrectDir(a5)
		lea	SaveDirPuffer(a5),a1
		jsr	A5MakeCorrectDir(a5)


	*------------- Config-Kopf speichern ----------*
		LA0	LNr_SaveKopf
		jsr	A5SaveConfigText(a5)
		bne.w	.Error


	*---------------- Fonts speichern -------------*
		LA0	LNr_Str_MenuFont
		lea	MenuFont(a5),a1
		bsr	SaveFont
		LA0	LNr_Str_ModulesFont
		lea	ModulesFont(a5),a1
		bsr	SaveFont
		LA0	LNr_Str_ScrollFont
		lea	ScrollFont(a5),a1
		bsr	SaveFont
		
*;***************************************************************************
*;**** SaveKennung:	0 = NoSave					****
*;****			1 = Arexx-Commando				****
*;****			2 = Proggy					****
*;***************************************************************************
*; Es werden beim saven der Config die Routinen des Arexx-Statuses auf-
*; gerufen. Um ein Aufrufen mancher Routinen ber Arexx zu verhindern,
*; wird die Statustabelle nach vorne erweitert.
*
**--------- Nun die Config nacheinander Befehl fr Befehl durchgehen ----------*
*		rsreset
*EPRT_Proggy	rs.w	1		;ChangeProgramm rel. JumpTo oder NULL
*EPRT_SaveConfig	rs.w	1		;Prg. zum Configsaven
*EPRT_Status	rs.w	1		;Offs/Jump/Konst
*EPRT_StrLNr	rs.w	1		;LocaleNr
*EPRT_Flags	rs.b	1		;Config/ARexx/Cli/ToolTypes
*EPRT_Args	rs.b	1		;Bit0-3=Arg1 Bit4-7=Arg2
*EPRT_SSFlags	rs.b	1		;Save & StatusFlags
*EPRT_TypeFlags	rs.b	1		;Type-Flags
*EPRT_StatusChars rs.b	3		;Kennung fr Status "ply"
*EPRT_Reserved	rs.b	1
*EPRT_SizeOf	rs.b	0

		clr.l	StatusVoiceNummer(a5)
		clr.l	StatusNextArg(a5)

		lea	KommandoTabelle-EPRT_SizeOf,a4
	*	lea	KommandoTabelle+(EPRT_SizeOf*(EPNr_ModulesFont-2)),a4
		moveq	#0,d7
.NextCommand:	addq.l	#1,d7			;EPNr !!!
		lea	EPRT_SizeOf(a4),a4
		move.w	EPRT_Proggy(a4),d0
		cmp.w	#-1,d0
		beq.w	.AllCommandsSaved
		move.w	EPRT_StrLNr(a4),d0
		beq.s	.NextCommand
		jsr	A5GetLocaleString(a5)
		beq.s	.NextCommand
		move.b	EPRT_Flags(a4),d0
		btst	#EPRTF_NoConfig,d0
		bne.w	.NextCommand

	*--------- Welche AuswertArt wird benutzt --------*
		btst	#EPRTF_StatusSave,d0
		bne.w	.Arexx
		btst	#EPRTF_Switch,d0  * Switchschalter ???
		bne.w	.NextCommand	* lieber Fehler wegen EPG_Someprefs

	*------ Es wird ein Auswertprogramm gestartet -----*
		moveq	#0,d0
		move.w	EPRT_SaveConfig(a4),d0
		beq.s	.NextCommand
		movem.l	d1-a6,-(a7)
		add.l	A5JumpTo+2(a5),d0
		move.l	d0,a3
		move.l	d7,d0
		cmp.w	#EPNr_LastInternal,d7
		blo.s	.EPNr_Ok
		moveq	#0,d0
.EPNr_Ok:	jsr	(a3)
		movem.l	(a7)+,d1-a6
		bne.w	.Error
		bra.s	.WriteNextC
		*bra.b	.WriteLine


*---------- Es wird ein Status-Kommando des Arexx-Portes aufgerufen --------*
.Arexx:		move.b	EPRT_TypeFlags(a4),d0
		
	*Achtung A4 darf nicht 0 sein !!!
	*sonst Player/Module/Engine Status
		movem.l	d0/a0,-(a7)
		moveq	#EPRTSSF_Global,d5	* a4=KommandoTabelle
		moveq	#0,d4			* d4=Player/EngineNummer
		lea	EPRT_StatusChars(a4),a3
		moveq	#3,d3
		bsr	GibStatusVonA4		* d5=Statustype
		movem.l	(a7)+,d4/a0
		tst.l	d0
		bne.w	.Error

		*--------- Kommando speichern -------*
		lea	TextPuffer(a5),a1
		lea	ArexxPuffer(a5),a3	*Default wert
		tst.b	(a3)
		bne.s	.ErgOk
		btst	#EPRTTF_String,d4
		bne.s	.ErgOk
		move.b	#"*",(a1)+
		move.b	#"0",(a3)+
		clr.b	(a3)
.ErgOk:		move.w	#TextPufferSize-3,d1
		jsr	A5StringCopy2(a5)
		move.b	#" ",(a1)+
		clr.b	(a1)
		lea	TextPuffer(a5),a0
		jsr	A5SaveConfigText(a5)
		bne.s	.Error

		lea	SaveCnZeile(pc),a3
		lea	ArexxPuffer(a5),a0
		btst	#EPRTTF_String,d4
		beq.s	.GlobalString
		move.b	#'"',-(a0)
		subq.l	#1,a3
.GlobalString:	jsr	A5SaveConfigText(a5)
		bne.s	.Error
		move.l	a3,a0
		bra.s	.WriteLine2

.WriteLine:	lea	SaveCnZeile(pc),a0
.WriteLine2:	jsr	A5SaveConfigText(a5)
		bne.s	.Error
.WriteNextC:	bra.w	.NextCommand

	*---------------- Datei closen -----------------*
.AllCommandsSaved:
		clr.b	ArexxPuffer(a5)
		clr.b	OnUseArexxPuffer(a5)
		move.l SaveHandle(a5),d1
		beq.s	.NoLock
		move.l	DTG_Dosbase(a5),d6
		jsr	_LVOClose(a6)
.NoLock:	clr.l	SaveHandle(a5)
		moveq	#LNr_SaveConfig,d0
		jmp	A5ScrollNew(a5)

	*------------- Error beim schreiben --------------*
.Error:		clr.b	ArexxPuffer(a5)
		clr.b	OnUseArexxPuffer(a5)
		move.l SaveHandle(a5),d1
		beq.s	.Nohandle2
		move.l	DTG_Dosbase(a5),d6
		jsr	_LVOClose(a6)
		clr.l	SaveHandle(a5)
.NoHandle2:	moveq	#EPR_WriteError,d0
		jmp	A5ScrollNewFehler(a5)

	*-----------------------------------------------------------*
	*----- Save den Text in A0 in die Datei von SaveHandle -----*
	*-----------------------------------------------------------*
SaveConfigText:	movem.l	d1/d2/d4-a6,-(a7)
		move.l	SaveHandle(a5),d1
		beq.s	.Error
		jsr	A5BerechStringSize(a5)
		move.l	d0,d3
		beq.s	.Error
		move.l	a0,d2
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOWrite(a6)
		cmp.l	d0,d3				;--> bne.w WriteError
		bne.s	.Error
		moveq	#0,d0
.Return		movem.l	(a7)+,d1/d2/d4-a6
		tst.l	d0
		rts
.Error:		moveq	#EPR_WriteError,d0
		bra.b	.Return

	*------------ NextLine ---------*
		dc.b	'"'
SaveCNZeile:	dc.b	10,0
		even

*-----------------------------------------------------------------------------*
* Die Prefs fr einen Font wird gespeichert.
* Input: a0=STR_String
*	 a1=FontStructure
*-----------------------------------------------------------------------------*
SaveFont:	move.l	a1,a3
		lea	TextPuffer(a5),a1
		tst.l	(a3)
		beq.s	.Stern
		tst.w	4(a3)
		beq.s	.Stern
		move.l	(a3),a2
		tst.b	(a2)
		bne.s	.Normal
.Stern:		move.b	#"*",(a1)+
.Normal:	jsr	A5StringCopy(a5)
		move.b	#" ",(a1)+
		move.b	#'"',(a1)+
		move.l	(a3),d0
		beq.s	.NoFont
		move.l	d0,a0
		jsr	A5StringCopy(a5)
.NoFont:	move.b	#'"',(a1)+
		move.b	#' ',(a1)+
		move.l	a1,a0
		moveq	#0,d0
		move.w	4(a3),d0
		jsr	A5Hexdez(a5)
		move.b	#10,(a0)+
		clr.b	(a0)
		lea	TextPuffer(a5),a0
		jsr	A5SaveConfigText(a5)
		rts

*-----------------------------------------------------------------------------*
SC_Engines:	lea	EPG_FirstUserStruct(a5),a4
.NextUser:	move.l	(a4),d0
		beq.w	.Error
		move.l	d0,a4

		LA0	LNr_Str_LoadEngine
		cmp.l	UMG_UPrgSAdr(a5),a4
		bne.s	.NormalUser
		LA0	LNr_Str_LoadGui
.NormalUser:	lea	TextPuffer(a5),a1
		jsr	A5StringCopy(a5)
		move.b	#' ',(a1)+
		move.b	#'"',(a1)+
		move.l	UPrgS_Name(a4),a0
		jsr	A5StringCopy(a5)
		move.b	#'"',(a1)+
		move.b	#' ',(a1)+

		lea	UPrgS_Winx(a4),a3
		moveq	#0,d4
		move.w	UPrgS_CFlags(a4),d4
		move.l	UPrgS_EUSAdr(a4),d0	;-> Batchconfig
		beq.s	.FlagsOk
		move.l	d0,a3
		lea	EUS_WinX(a3),a3
		moveq	#-1,d4			;alle Angaben
.FlagsOk:	move.l	a1,a0
		moveq	#0,d0			;WinX
		move.w	(a3)+,d0
		btst	#0,d4
		beq.s	.Flag1No
		jsr	A5Hexdez(a5)
		move.b	#' ',(a0)+

.Flag1No:	moveq	#0,d0			;WinY
		move.w	(a3)+,d0
		btst	#1,d4
		beq.s	.Flag2No
		jsr	A5Hexdez(a5)
		move.b	#' ',(a0)+

.Flag2No:	moveq	#0,d0			;Flags
		move.w	(a3)+,d0
		btst	#UPrgF_Active,UPrgS_UFlags+3(a4) ;Sonst geht SaveConfig
		beq.s	.Flag2_No_2			;bei Iconify nicht
		or.w	#EUSB_Activate,d0
.Flag2_No_2:	btst	#UPrgF_Show,UPrgS_UFlags+3(a4) ;Sonst geht SaveConfig
		beq.s	.Flag2_No_3
		or.w	#EUSB_Show,d0
.Flag2_No_3:	btst	#2,d4
		beq.s	.Flag3No
		jsr	A5Hexdez(a5)
		move.b	#' ',(a0)+

.Flag3No:	move.l	(a3)+,d0		;Special1
		btst	#3,d4
		beq.s	.Flag4No
		jsr	A5Hexdez(a5)
		move.b	#' ',(a0)+

.Flag4No:	move.l	(a3)+,d0		;Special2
		btst	#4,d4
		beq.s	.Flag5No
		jsr	A5Hexdez(a5)
		move.b	#' ',(a0)+

.Flag5No:	move.l	(a3)+,d0		;Special3
		btst	#5,d4
		beq.s	.Flag6No
		jsr	A5Hexdez(a5)
		move.b	#' ',(a0)+

.Flag6No:	move.b	#10,(a0)+
		clr.b	(a0)
		lea	TextPuffer(a5),a0
		jsr	A5SaveConfigText(a5)
		beq.w	.NextUser
.Error:		tst.l	d0
		rts











*-----------------------------------------------------------------------------*
SC_FastUser:	move.w	#EUS_SizeOf,d4
		bra.s	SC_FastUser2
SC_ChipUser:	moveq	#0,d4
SC_FastUser2:	jsr	A5SaveConfigText(a5)		;Commando sichern
		lea	FirstAmplifier,a1
		lea	(a1,d4.w),a1

		lea	ArexxPuffer(a5),a0
		moveq	#0,d0
		move.w	EUS_Flags(a1),d0			;EUS_Flags
		move.b	#" ",(a0)+
		jsr	A5Hexdez(a5)
		move.b	#" ",(a0)+
		move.l	EUS_AMPriority(a1),d0
		jsr	A5Hexdez(a5)
		move.b	#10,(a0)+
		clr.b	(a0)
		lea	ArexxPuffer(a5),a0
		jmp	A5SaveConfigText(a5)

SetFastConfig:	move.w	#EUS_SizeOf,d4
		bra.s	SetFastConfig2
SetChipConfig:	moveq	#0,d4
SetFastConfig2:	lea	FirstAmplifier,a0
		move.w	d2,EUS_Flags(a0,d4.w)
		move.l	d3,EUS_AMPriority(a0,d4.w)
		moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
SC_LoadList:	jsr	A5SaveConfigText(a5)		;Kommando
		lea	ArexxPuffer(a5),a1
		move.b	#' ',(a1)+
		move.b	#'"',(a1)+

		lea	ListPuffer(a5),a0
		move.w	#DirPufferSize-2,d1
		move.l	a1,-(a7)
		jsr	A5StringCopy2(a5)
		move.l	a1,a2
		move.l	(a7)+,a1
		jsr	A5GetFileName(a5)
		move.l	a1,d0
		beq.s	.NoParentList

		move.l	EPG_FirstFileStruct(a5),d0
		beq.s	.ClrFilename
		move.l	d0,a0
		moveq	#0,d0
		move.b	EFP_Flags(a0),d0
		btst	#EFPF_ParentList,d0
		bne.s	.NoParentList

.ClrFilename:	clr.b	(a1)
		move.l	a1,a2
.NoParentList:	move.l	a2,a1
		move.b	#'"',(a1)+
		move.b	#10,(a1)+
		clr.b	(a1)
		lea	ArexxPuffer(a5),a0
		jmp	A5SaveConfigText(a5)


*-------------------------------------------------------------------------*
*				STATUS V2.0				  *
* Input:								  *
* a1=NextArg								  *
* a2=Arg1	(p 1 nam) -> Start von p				  *
* d2=Arg1Size	Size von p						  *
* a3=Arg2								  *
* d3=Arg2Size								  *
* Output:								  *
* im ArexxPuffer steht das Ergebnis der Operation			  *
* z.B. Yes/No , Eagleplayer/Eagleplayers oder 10			  *
*-------------------------------------------------------------------------*
			rsreset
EPLST_Identifier	rs.b	3
EPLST_Mode		rs.b	1
EPLST_Tag		rs.l	1
EPLST_SizeOf		rs.b	0		\ nicht
EPLST_EPFlags		rs.b	2		/ ndern !
EPLST_SizeOf2		rs.b	0

		rsreset
EENST_Identifier	rs.b	3
EENST_Mode		rs.b	1
EENST_Offset		rs.b	2
EENST_SizeOf		rs.b	0

EENSTM_String		EQU	1
EENSTM_Word		EQU	2
EENSTM_LongWord		EQU	3
EENSTM_Zustand		EQU	4
EENSTM_Proggy		EQU	5
EENSTM_StringPuffer	EQU	6
EENSTM_PufferWord	EQU	7

PLAB			Macro
			dc.b	"\1"		;EPLST_Identifier
			dc.b	\2		;EPLST_Mode
			dc.l	\3		;EPLST_Tag
			endm

PLAB2			Macro
			dc.b	"\1"		;EPLST_Identifier
			dc.b	\2		;EPLST_Mode
			dc.l	\3		;EPLST_Tag
			dc.w	\4		;EPLST_EPFlags
			endm
*--------------------------------------------------------------------------*
* d2=Zahlwert  type+Kommando	bsp: mfil				   *
* d3=Nummer der PLayer/Engine/Voice					   *
* In dieser Routine wird nicht weiter geprft, ob die Angaben richtig sind.*
* Engines sollten schon die richtigen Kommandos schicken.		   *
*--------------------------------------------------------------------------*
Status2:
		move.l	d2,StatusLong(a5)
		bset	#5,StatusLong(a5)	;"MFIL" -> "mFIL"
		moveq	#1,d2
		move.l	d3,d4			;Nummer des Players/Engines 
		lea	StatusLong+1(a5),a3	;Kommando "fil"
		moveq	#3,d3

		move.b	StatusLong(a5),d1
		moveq	#EPRTSSF_Module,d5
		cmp.w	#EPSI_Module,d1
		beq.s	.ModeOk
		moveq	#EPRTSSF_Global,d5
		cmp.w	#EPSI_Global,d1
		beq.s	.ModeOk

		moveq	#EPRTSSF_Player,d5
		cmp.w	#EPSI_Player,d1
		beq.s	.ModeOk
		moveq	#EPRTSSF_Engine,d5
		cmp.w	#EPSI_UserPrg,d1
		beq.s	.ModeOk
		cmp.w	#EPSI_Engine,d1
		beq.s	.ModeOk
		moveq	#EPR_ErrorInArguments,d0
		jmp	A5ScrollNewFehler(a5)

.ModeOk:	moveq	#0,d0
		bsr	Status
		move.l	d0,-(a7)
		lea	ArexxPuffer(a5),a0
		lea	ScrollPuffer(a5),a1
		move.w	#ScrollPufferSize-2,d1
		jsr	A5StringCopy2(a5)

KeyTestReturn:	move.l	(a7)+,d0		;Nicht ndern !!!
		tst.l	d0			;!!!
		rts				;!!!

*--------------------------------------------------------------------------*
* d0=Nummer
* d2/a2=Arg1 "m" oder "p" als String
* d3/a3=Arg2 Player/Enginenummer oder statuskommando
*--------------------------------------------------------------------------*
NewStatus:
	*############### Argumente auswerten ####################*
.ArgAuswertung:


		clr.b	NurEinString(a5)
		move.l	a2,a1

		moveq	#0,d2
		moveq	#0,d3
		sub.l	a2,a2
		sub.l	a3,a3
		moveq	#EPRTAB_String1!EPRTAB_Must1,d0
		bsr	GibArg			;>- d0=Fehler oder Null
		bne.w	Status_ErrorInArgs	;>- d1=Zahl,Zustand,StringSize
		move.l	d1,d2			;>- a0=StringBeginn
		move.l	a0,a2			;>- a1=Start of next Arg

		moveq	#EPRTAB_String1!EPRTAB_Must1,d0
		bsr	GibArg			;>- d0=Fehler oder Null
		bne.w	Status_ErrorInArgs	;>- d1=Zahl,Zustand,StringSize
		move.l	d1,d3			;>- a0=StringBeginn
		move.l	a0,a3

		moveq	#EPNr_Status,d0

Status:		tst.l	d0
		beq.s	.SucheKommando
		clr.l	StatusVoiceNummer(a5)
		move.l	a1,StatusNextArg(a5)
		move.b	(a2),d1
		bset	#5,d1

		moveq	#0,d4
		moveq	#EPRTSSF_Module,d5
		cmp.w	#EPSI_Module,d1
		beq.s	.SucheKommando
		moveq	#EPRTSSF_Global,d5
		cmp.w	#EPSI_Global,d1
		beq.s	.SucheKommando

		moveq	#EPRTSSF_Player,d5
		cmp.w	#EPSI_Player,d1
		beq.s	.HoleNummer
		moveq	#EPRTSSF_Engine,d5
		cmp.w	#EPSI_UserPrg,d1
		beq.s	.HoleNummer
		cmp.w	#EPSI_Engine,d1
		bne.w	Status_ErrorInArgs
.HoleNummer:	move.l	a3,a0
		move.l	d3,d0
		jsr	A5DezHex(a5)
		beq.w	Status_ErrorInArgs
		move.l	d0,d4			;Nummer fr Player & Engines
		jsr	A5FindFileName(a5)
		tst.l	d0
		beq.w	Status_ErrorInArgs
		move.l	d0,a3			;Arg3 nach Arg2
		move.l	d1,d3

	*------------- General & Modulestatus --------------*
.SucheKommando:	cmp.w	#3,d3
		bne.w	Status_ErrorInArgs
		lea	KommandoTabelle-EPRT_SizeOf,a4
.NextEPNr:	lea	EPRT_SizeOf(a4),a4
		cmp.w	#-1,(a4)
		beq.w	GibStatusVonA42
		move.b	EPRT_SSFlags(a4),d0
		btst	d5,d0
		beq.s	.NextEPNr
		lea	EPRT_StatusChars(a4),a0
		move.b	(a3),d0
		bset	#5,d0
		cmp.b	(a0)+,d0
		bne.s	.NextEPNr
		move.b	1(a3),d0
		bset	#5,d0
		cmp.b	(a0)+,d0
		bne.s	.NextEPNr
		move.b	2(a3),d0
		bset	#5,d0
		cmp.b	(a0)+,d0
		bne.s	.NextEPNr
		bra.s	GibStatusVonA4



	*------------ Statuskommando ausfhren -----------*
	* a4=KommandoTabelle				  *
	* d5=Statustype Global,Module EPRTSSF_Global	  *
	* d4=optional Player/Enginenummer		  *
	* a2=Arg1 (Statustype)				  *
	* a3=Arg2 (Statuskommando)			  *
	*-------------------------------------------------*
	*--------- Einsprung fr SaveConfig !!!!!!        *
GibStatusVonA42:sub.l	a4,a4
GibStatusVonA4:	lea	StatusLong+1(a5),a0	;Kommando "fil"
		move.b	(a3),(a0)
		move.b	1(a3),1(a0)
		move.b	2(a3),2(a0)
		bset	#5,(a0)
		bset	#5,1(a0)
		bset	#5,2(a0)
		move.l	a0,a3

		move.b	#1,OnUseArexxPuffer(a5)
		moveq	#0,d3
		moveq	#0,d0
		cmp.l	a4,d0
		beq.s	.skip
		move.b	EPRT_TypeFlags(a4),d0
		move.w	EPRT_Status(a4),d3
.skip
		moveq	#0,d1
		cmp.l	a4,d1
		bne.s	.UseKommandoTabelle
		cmp.b	#EPRTSSF_Player,d5
		beq.w	.PlayerStatus
		cmp.b	#EPRTSSF_Engine,d5
		beq.w	.Enginestatus
		cmp.b	#EPRTSSF_Module,d5
		beq.s	.Modulestatus
		bra.w	Status_ErrorInArgs

		*------------ Global bzw. Modulestatus ----------*
.UseKommandoTabelle:
		btst	#EPRTTF_Proggy,d0
		bne.s	.GlobalProggy
		btst	#EPRTTF_String,d0
		bne.s	.GlobalString

		move.l	d0,d1
		and.w	#EPRTTB_Byte!EPRTTB_Word!EPRTTB_LongWord,d0
		beq.w	Status_ErrorInArgs
		moveq	#0,d2
		move.b	(a5,d3.w),d2
		btst	#EPRTTF_Byte,d0
		bne.s	.GlobalWas
		move.w	(a5,d3.w),d2
		btst	#EPRTTF_Word,d0
		bne.s	.GlobalWas
		move.l	(a5,d3.w),d2
.GlobalWas:	btst	#EPRTTF_Zahl,d1
		bne.s	.GlobalZahl
		btst	#EPRTTF_Zustand,d1
		beq.w	Status_ErrorInArgs

		*-------- Zustand -------*
.GlobalZustand:	LA0	LNr_No			*auch Player & Enginezustand
		tst.l	d2
		beq.s	.GlobalNo
		LA0	LNr_Yes
.GlobalNo:	jmp	A5CopyTextToArexxPuffer(a5)

.GlobalZahl:	move.l	d2,d0
		jmp	A5CopyZahlToArexxPuffer(a5)

.GlobalProggy:	add.l	A5JumpTo+2(a5),d3
		move.l	d3,a0
		moveq	#0,d0
		bra.w	.GlobalJump

.GlobalString:	lea	(a5,d3.w),a0
		jmp	A5CopyTextToArexxPuffer(a5)






	*---------------------------------------------------*
	*--------- Auswertung des Modulesstatusses ---------*
	*---------------------------------------------------*
.ModuleStatus:	moveq	#0,d7
		moveq	#0,d6
		move.l	PlayerAdr(a5),a2
		lea	ModuleStatusTabelle-EPLST_Sizeof,a4
		bra.s	.ModuleStatus2

	*---------------------------------------------------*
	*---------- Auswertung des Playerstatusses ---------*
	*---------------------------------------------------*
.Playerstatus:	lea	PlayerStatusTabelle-EPLST_SizeOf2,a4
		move.l	d4,d0				;Playernummer
		jsr	A5FindPlayerStruct(a5)
		bne.w	Status_ErrorInArgs
		move.l	EPPl_TagList(a0),a2		;PLTagListe
		moveq	#2,d7
		moveq	#PlayerStatusFlagsAnz+2,d6

		*---- Find Playerschleife -----*
.ModuleStatus2:	clr.l	StatusModuleInfo(a5)
		move.l	a2,a6
		move.l	#EP_Get_ModuleInfo,d0
		jsr	A5CallUp3(a5)
		bne.s	.PlayerMInfoDa

		move.l	a2,a6
		move.l	#EP_NewModuleInfo,d0
		jsr	A5FindTag2(a5)
		beq.s	.PlayerNextCommand
		move.l	a6,a0
.PlayerMInfoDa:	move.l	a0,StatusModuleInfo(a5)

.PlayerNextCommand:
		subq.l	#1,d6
		bne.s	.PlayerUseFlags
		moveq	#0,d7
.PlayerUseFlags:lea	EPLST_SizeOF(a4,d7.w),a4
		tst.b	(a4)
		beq.w	Status_ErrorInArgs

		move.b	(a3),d0
		cmp.b	EPLST_Identifier(a4),d0
		bne.s	.PlayerNextCommand
		move.b	1(a3),d0
		cmp.b	EPLST_Identifier+1(a4),d0
		bne.s	.PlayerNextCommand
		move.b	2(a3),d0
		cmp.b	EPLST_Identifier+2(a4),d0
		bne.s	.PlayerNextCommand

		move.b	EPLST_Mode(a4),d0
		beq.w	Status_ErrorInArgs
		cmp.b	#EENSTM_Proggy,d0
		beq.w	.PlayerJump

		move.l	EPLST_Tag(a4),d0		;Tag
		beq.w	.PlayerEPFlags
		lea	(a5,d0.w),a0
		cmp.b	#EENSTM_StringPuffer,EPLST_Mode(a4)
		beq.w	.CopyString

		cmp.b	#EENSTM_PufferWord,EPLST_Mode(a4)
		beq.w	.PlayerZahl2



		move.l	a2,a6
		jsr	A5FindTag2(a5)			;Tagliste
		bne.s	.PlayerTagDa

		move.l	StatusModuleInfo(a5),d0
		beq.s	.PlayerEPFlags2
		move.l	d0,a6
		move.l	EPLST_Tag(a4),d0		;Tag
		jsr	A5FindTag2(a5)
		beq.s	.PlayerEPFlags2

.PlayerTagDa:	move.l	a6,d2
		cmp.l	#MI_UnpackedSystem,EPLST_Tag(a4)
		bne.s	.PlayerNoUnpacked
		cmp.l	#MIUS_SizeOF,d2
		bhi.s	.PlayerNoUnpacked
		move.w	#LNr_OldSoundTracker+1,d0
		sub.l	d2,d0
		jsr	A5GetLocaleString(a5)
		move.l	a0,d2
.PlayerNoUnpacked:				*d2=Wert des Tags !!!
		move.b	EPLST_Mode(a4),d0
		beq.w	Status_ErrorInArgs
		cmp.b	#EENSTM_Zustand,d0
		beq.w	.GlobalZustand
		cmp.b	#EENSTM_String,d0
		beq.s	.PlayerString
		cmp.b	#EENSTM_LongWord,d0
		beq.s	.PlayerZahl
		and.l	#$ffff,d2
.PlayerZahl:	move.l	d2,d0
		jmp	A5CopyZahlToArexxPuffer(a5)

.PlayerZahl2:	moveq	#0,d2
		move.w	(a0),d2
		bra.s	.PlayerZahl

.PlayerString:	move.l	d2,a0
.CopyString:	jmp	A5CopyTextToArexxPuffer(a5)

.PlayerEPFlags:	tst.l	d7
		beq.w	Status_ErrorInArgs
.PlayerEPFlags2:moveq	#0,d2
		cmp.b	#EENSTM_String,EPLST_Mode(a4)
		beq.w	.PlayerString
		cmp.b	#EENSTM_Zustand,EPLST_Mode(a4)
		bne.w	.PlayerZahl

		moveq	#0,d3				;No
		tst.l	d7
		beq.s	.PlayerEPFlagsNo

		move.l	#EP_Flags,d0
		move.l	a2,a6
		jsr	A5FindTag2(a5)			;hier wird d2 verndert
		beq.s	.PlayerEPFlagsNo
		moveq	#0,d0
		move.w	EPLST_EPFlags(a4),d0
		move.l	a6,d1
		btst	d0,d1
		beq.s	.PlayerEPFlagsNo
		moveq	#1,d3
.PlayerEPFlagsNo:move.l	d3,d2
		bra.w	.GlobalZustand
		
	*---------------------------------------------------*
	*---------- Auswertung des Enginestatusses ---------*
	*---------------------------------------------------*
.Enginestatus:	lea	EngineStatusTabelle-EENST_Sizeof,a4
		move.l	d4,d0
		jsr	A5FindEUSStruct(a5)
		bne.w	Status_EngineError
		move.l	a0,a2

.EngineNextCommand:
		lea	EENST_SizeOF(a4),a4
		tst.b	(a4)
		beq.w	Status_ErrorInArgs

		move.b	(a3),d0
		cmp.b	(a4),d0
		bne.s	.EngineNextCommand
		move.b	1(a3),d0
		cmp.b	1(a4),d0
		bne.s	.EngineNextCommand
		move.b	2(a3),d0
		cmp.b	2(a4),d0
		bne.s	.EngineNextCommand

		moveq	#0,d3
		move.w	EENST_Offset(a4),d3
		move.b	EENST_Mode(a4),d0
		beq.s	Status_ErrorInArgs
		cmp.w	#EENSTM_Proggy,d0
		beq.s	.EngineJump
		cmp.w	#EENSTM_String,d0
		beq.s	.EngineString
		moveq	#0,d1
		move.w	(a2,d3.w),d1
		cmp.w	#EENSTM_Word,d0
		beq.s	.EngineWord
		move.l	(a2,d3.w),d1
.EngineWord:	move.l	d1,d0
		jmp	A5CopyZahlToArexxPuffer(a5)

.EngineString:	move.l	(a2,d3.w),a0
		jmp	A5CopyTextToArexxPuffer(a5)

.PlayerJump:	move.l	EPLST_Tag(a4),d3
.EngineJump:	add.l	A5JumpTo+2(a5),d3		*auch PlayerJump
		move.l	d3,a0
		moveq	#0,d0
		moveq	#0,d1
		moveq	#0,d2
.GlobalJump:	jsr	(a0)			*Input: d4=Player/EngineNr
		tst.l	d0			*Output:d0=Error oder NULL
		bne.s	Status_ErrorInArgs2	*	d1=Mode (LW oder ZuSt)
		cmp.w	#EENSTM_LongWord,d1	*	d2=Zahl oder Zustand
		beq.w	.PlayerZahl
		cmp.w	#EENSTM_String,d1
		beq.w	.PlayerString
		cmp.w	#EENSTM_Zustand,d1
		beq.w	.GlobalZustand

Status_EngineError:
		moveq	#EPR_EngineNotFound,d0
		bra.s	Status_ErrorInArgs2

Status_ErrorInArgs:
		moveq	#EPR_ErrorInArguments,d0
Status_ErrorInArgs2:
		jsr	A5ScrollNewFehler(a5)
		lea	ScrollPuffer(a5),a0
		move.l	d0,-(a7)
		jsr	A5CopyTextToArexxPuffer(a5)
		move.l	(a7)+,d0
		rts


*---------------- Testet, ob Eagleplayer verndert wurde ------------------*
KeyTester1:	movem.l	d0-a6,-(a7)
		move.l	A5JumpTo+2(a5),a0
		lea	TextPuffer(a5),a1
		cmp.w	#$4aad,KeyTest1-Jumpto(a0)
		bne.s	.Error
		move.w	#KeyFault-1000,d0
		moveq	#1,d1
		add.w	#1000,d0
		add.w	d0,d1
		cmp.w	KeyTest1+2-Jumpto(a0),d0
		bne.w	.Error
		move.w	#$3468,d0
		add.w	#$3298,d0
		cmp.w	KeyTest1+4-Jumpto(a0),d0
		beq.s	.Ok
.Error:		jsr	A5JaGuru(a5)

		addq	#1,d1
.Ok:		move.l	d1,KeyDummy(a5)
		movem.l	(a7)+,d0-a6
		rts



*-------------------- Engine & Playerproggys fr den Status -----------------*
* Input: d0-d2 = 0							     *
*	 d4=Nummer							     *
*	 a2=Playertagliste bzw. EngineEUSStructure			     *
* Output:d0=Fehler oder NULL						     *
*	 d1=Mode							     *
*	 d2=Zahlwert (LONG) oder Zustand				     *
*----------------------------------------------------------------------------*
EngineGiveWinOffen:
		move.l	d4,d0
		jsr	A5FindUserStruct(a5)
		bne.s	.WinOk
		moveq	#0,d0				;kein Fehler
		moveq	#EENSTM_Zustand,d1
		moveq	#0,d2				;Zustand NO
		btst	#0,12(a0)
		bne.s	.WinOk
		moveq	#1,d2				;Zustand NO
.WinOk:		rts

EngineGiveType:	moveq	#0,d0
		moveq	#EENSTM_LongWord,d1
		moveq	#0,d2
		move.b	EUS_Type(a2),d2
		rts

EngineGiveDate:	move.l	EUS_CreatorDate(a2),d6
		bra.b	EngineGiveDate2
PlayerGiveDate:	move.l	a2,a6
		move.l	#EP_Date,d0
		jsr	A5FindTag2(a5)
		beq.w	NewUnknown2
		move.l	a6,d6
EngineGiveDate2:rol.l	#8,d6
		moveq	#0,d0
		move.b	d6,d0
		lea	TextPuffer(a5),a0
		move.l	a0,d2
		jsr	A5Hexdez(a5)
		move.b	#".",(a0)+
		rol.l	#8,d6
		moveq	#0,d0
		move.b	d6,d0
		jsr	A5Hexdez(a5)
		move.b	#".",(a0)+
		swap	d6
		moveq	#0,d0
		move.w	d6,d0
		jsr	A5Hexdez(a5)
PlayerGiveDate2:moveq	#0,d0
		moveq	#EENSTM_String,d1
		rts

	*!!!!!!!!!!!!!!! ACHTUNG!GURU! !!!!!!!!!!!!!!!!!!*
JaGuru2:   ifne guru
		moveq	#2,d2
		move.l	$3286(a5),d1
		add.w	d0,d1
		lea	(a5,d1.w),a0
		rol.l	#2,d3
		add.l	d2,d2
		add.l	EmptyPuffer(a5),d2
		move.l	d2,a1
		move.l	d1,(a1)				;JAhhh Guru !!!!!
		rts
	    else
FarbEffect:	moveq	#-1,d0
.Warning:	move.w	d0,$dff180
		dbf	d0,.Warning
		rts
	    endc



	*---- Testen, ob bei diesem Soundsystem SubSongs verfgbar sind ----*
PlayerGiveSubSongs:
		moveq	#1,d7				;Ja
		move.l	a2,a6
		move.l	#EP_Flags,d0
		jsr	A5FindTag2(a5)
		beq.w	.NoFlags
		move.l	a6,d0
		btst	#EPF_NextSong,d0
		bne.w	.Ok
.NoFlags:	move.l	a2,a6
		move.l	#DTP_SubSongRange,d0
		jsr	A5FindTag2(a5)
		bne.w	.Ok
		move.l	a2,a6
		move.l	#DTP_NextSong,d0
		jsr	A5FindTag2(a5)
		bne.w	.OK
		moveq	#0,d7
.OK:		moveq	#EENSTM_Zustand,d1
		move.l	d7,d2
		moveq	#0,d0
		rts

PlayerGivePlayerZustand:
* d4=Nummer
		moveq	#0,d7				;Nein
		move.l	d4,d0
		jsr	A5FindPlayerStruct(a5)
		bne.s	.Error
		btst	#EPPlF_Enabled,EPPl_Flags+1(a0)	;Test auf Enabled
		beq.s	.Nein

		move.l	a2,a6
		move.l	#EP_Flags,d0
		jsr	A5FindTag2(a5)
		beq.s	.Enabled
		move.l	a6,d0
		btst	#EPF_Disable,d0
		bne.s	.Nein
.Enabled:	moveq	#1,d7				;Ja
.Nein:		move.l	d7,d2
		moveq	#0,d0
		moveq	#EENSTM_Zustand,d1
.Error:		rts


PlayerGiveTagListe:
		move.l	a2,d2
		moveq	#0,d0
		moveq	#EENSTM_LongWord,d1
		rts

PlayerGiveSpeedZustand:
		moveq	#1,d7
		move.l	#DTP_StartInt,d0
		move.l	a2,a6
		jsr	A5FindTag2(a5)
		bne.w	.Ok
		move.l	a2,a6
		move.l	#EP_SetSpeed,d0
		jsr	A5FindTag2(a5)
		bne.w	.Ok
		move.l	a2,a6
		move.l	#DTP_Faster,d0
		jsr	A5FindTag2(a5)
		bne.w	.Ok
		moveq	#0,d7
.Ok:		moveq	#EENSTM_Zustand,d1
		move.l	d7,d2
		moveq	#0,d0
		rts

PlayerGiveName:	move.l	d4,d0
		jsr	A5FindPlayerStruct(a5)
		bne.s	.Error
		move.l	a0,a4
		lea	TextPuffer(a5),a0
		jsr	A5GetPlayerName(a5)
		move.l	a0,d2
		moveq	#0,d0
		moveq	#EENSTM_String,d1
.Error		rts

PlayerGivePacked:
		moveq	#EPF_Packable,d6
		bra.s	PlayerGivePacked2

PlayerGiveRestart:
		moveq	#EPF_Restart,d6
PlayerGivePacked2:
		moveq	#0,d7
		move.l	a2,a6
		move.l	#EP_Flags,d0
		jsr	A5FindTag2(a5)
		beq.w	.No
		move.l	a6,d0
		btst	d6,d0
		beq.w	.No
		moveq	#1,d7
.No:		moveq	#EENSTM_Zustand,d1
		move.l	d7,d2
		moveq	#0,d0
		rts


	*--------- Nun kommen die globalen Statusproggys ---------
GlobalGiveEPAdr:move.l	a5,d2
		moveq	#0,d0
		moveq	#EENSTM_LongWord,d1
		rts
GlobalGiveVoices:
		move.l	StatusVoiceNummer(a5),d0
		bne.s	.VoiceDa
		move.l	StatusNextArg(a5),d0
		beq.s	.Error
		move.l	d0,a1
		jsr	A5FindFileName(a5)
		move.l	d0,a0			*Start
		move.l	d1,d0			*Size
		jsr	A5DezHex(a5)
		beq.w	.Error
.VoiceDa:	tst.l	d0
		beq.s	.Error
		cmp.w	#EP_MaxVoices,d0
		bhi.s	.Error
		subq.l	#1,d0
		add.w	d0,d0
		moveq	#0,d2
		lea	InternVoicePuffer+EP_MaxVoices(a5),a0
		tst.b	1(a0,d0.w)
		beq.s	.VoiceOff
		move.b	(a0,d0.w),d2			;Volume
.VoiceOff:	moveq	#0,d0
		moveq	#EENSTM_Longword,d1
		rts

.Error:		moveq	#EPR_ErrorInArguments,d0
		rts

GlobalGiveSongNr:
		tst.w	NextSongOn(a5)
		beq.w	NewUnknown2
		moveq	#0,d2
		move.w	DTG_SndNum(a5),d2
		sub.w	EPG_FirstSnd(a5),d2
		addq.l	#1,d2
		moveq	#EENSTM_LongWord,d1
		moveq	#0,d0
		rts

**--------------------- Gibt einen Eagleplayer-String zurck -----------------*
*KM_AboutEP:	LA0	LNr_EPVersion
*		move.l	a0,ScrollArgs(a5)
*		LA0	LNr_EPBy
*		lea	ScrollArgs(a5),a1
*		jsr	A5MakeCorrectText(a5)
*		jmp	A5CopyTextToArexxPuffer(a5)
*

*------------------------------------------------------------------------*
ModuleGiveAbout:tst.l	PlayerAdr(a5)
		beq.w	NewUnknown2
		bsr.w	AboutModule
		lea	ScrollPuffer(a5),a0
		bra.w	ModuleGiveAbout2
ModuleGivePlayerNr:
		move.l	PlayerAdr(a5),d1
		beq.w	NewUnknown2
		move.l	d1,a2
		lea	EPG_FirstPlayerStruct(a5),a0
		moveq	#0,d2
.NextPlayer:	move.l	EPPl_Next(a0),d1
		move.l	d1,a0
		beq.w	NewUnknown2
		addq.l	#1,d2				;PlayerNr
		move.l	EPPl_TagList(a0),a1
		cmp.l	a1,a2
		bne.b	.NextPlayer
.HeIsIt:	moveq	#0,d0
		moveq	#EENSTM_LongWord,d1
		rts

ModuleGivePfad:	tst.l	SaveHandle(a5)
		bne.s	.SaveDir
		tst.l	PlayerAdr(a5)
		beq.w	NewUnknown2
.SaveDir:	sub.l	a2,a2
		tst.l	EPG_ModNr(a5)
		beq.s	.NoFile
		lea	TitleNamePuffer(a5),a2
.NoFile:	lea	DirPuffer(a5),a1
		move.l	a1,LoadFilePath(a5)
		bsr.w	CreateLoadPath
		lea	PathPuffer(a5),a0
ModuleGiveAbout2:move.l	a0,d2
		moveq	#0,d0
		moveq	#EENSTM_String,d1
		rts

ModuleGiveMinSubSong
		moveq	#0,d2
		move.w	MinSubSong(a5),d2
		bra	ModuleGiveSubSong
ModuleGiveMaxSubSong
		moveq	#0,d2
		move.w	MaxSubSong(a5),d2
ModuleGiveSubSong:
		tst.l	PlayerAdr(a5)
		beq.w	NewUnknown2
		tst.w	NextSongOn(a5)
		beq.w	NewUnknown2
		*tst.w	MinSubSong(a5)
		*bne.s	.NoAdd1
		*addq.l	#1,d2
.NoAdd1:	moveq	#EENSTM_LongWord,d1
		moveq	#0,d0
		rts
		
ModuleGivePositionsNr:
		move.l	#EP_GetPositionNr,d0
		jsr	A5CallUp(a5)
		beq.s	NewUnknown2
		move.l	d0,d2
		moveq	#EENSTM_LongWord,d1
		moveq	#0,d0
		rts
ModuleGiveCheck:move.l	#EP_CheckModule,d0
		jsr	A5CallUp(a5)
		beq.s	NewUnknown2
		move.l	d0,d2
		moveq	#0,d0
		moveq	#EENSTM_Zustand,d1
		rts
ModuleGivePatternAnz:move.l #MI_Pattern,d0
		bra.s	ModuleFindTag3
ModuleGiveLength:move.l	#MI_Length,d0
		bra.s	ModuleFindTag3
ModuleGiveSteps:move.l	#MI_Steps,d0
		bra.s	ModuleFindTag3
ModuleGiveSamples:move.l #MI_Samples,d0
		bra.s	ModuleFindTag3

ModuleGiveSongName:move.l #MI_Songname,d0
		bra.s	ModuleFindTag2
ModuleGiveAutorName:move.l #MI_Authorname,d0
*		bra.s	ModuleFindTag2

ModuleFindTag2:	move.l	GetInfoAdr(a5),a6
		jsr	A5FindTag2(a5)
		beq.w	NewUnknown2			;Error
		move.l	a6,d2
		moveq	#0,d0
		moveq	#EENSTM_String,d1
		rts
ModuleFindTag3:	move.l	GetInfoAdr(a5),a6
		jsr	A5FindTag2(a5)
		beq.w	NewUnknown2			;Error
		move.l	a6,d2
		moveq	#0,d0
		moveq	#EENSTM_LongWord,d1
		rts
NewUnknown2:	moveq	#0,d2
		moveq	#0,d0
		moveq	#EENSTM_String,d1
		rts
*NewUnknown:	LA0	LNr_Unknown
*		move.l	a0,d2
*		moveq	#0,d0
*		moveq	#EENSTM_String,d1
*		rts



*-------------------------------------------------------------------------*
JaGuru3:   ifne guru
		moveq	#2,d2
		move.l	$3286(a5),d1
		add.w	d0,d1
		lea	(a5,d1.w),a0
		rol.l	#2,d3
		add.l	d2,d2
		add.l	EmptyPuffer(a5),d2
		move.l	d2,a1
		move.l	d1,(a1)				;JAhhh Guru !!!!!
		rts
	    else
		moveq	#-1,d0
.Warning:	move.w	d0,$dff180
		dbf	d0,.Warning
		rts
	    endc



*------------------------------------------------------------------------*
CopyZahlToArexxPuffer:lea ArexxPuffer(a5),a0
		clr.b	(a0)
		jsr	A5HexDez(a5)
		moveq	#0,d0
		rts

CopyTextToArexxPuffer:lea ArexxPuffer(a5),a1
		clr.b	(a1)
		move.w	#ArexxPufferSize-2,d1
		jsr	A5StringCopy2(a5)
		lea	ArexxPuffer(a5),a0
		moveq	#0,d0
		rts








***************************************************************************
*---------------------------- Delete File --------------------------------*
***************************************************************************
DeleteFile:	jsr	A5WaitMouse(a5)
		LA0	LNr_SW_DeleteFile
		jsr	A5PrintText(a5)
		moveq	#0,d6				;erster Versuch

		tst.l	d2
		beq.s	.FileReq
		move.l	a2,a0
		move.l	d2,d1
		subq.w	#1,d1
		lea	PathPuffer(a5),a1
		jsr	A5StringCopy2(a5)
		lea	PathPuffer(a5),a0
		move.l	a0,d1
		bra.s	.DeleteIt

.FileReq:	LA0	LNr_FR_DeleteFile
		lea	DeletingDir(a5),a1
		lea	DeletingFile(a5),a2
		jsr	A5GetMainWindowHandle(a5)
		move.l	d0,a3
		moveq	#0,d0			;Kennung ->> File zu laden
		jsr	A5FileRequest2(a5)
		bne.w	ToScrollNewFehler

		lea	DeletingDir(a5),a1
		jsr	A5HoleLock(a5)
		beq.w	.Error
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOCurrentDir(a6)
		move.l	d0,OldDir(a5)

	*---------- File lschen ---------*
		lea	DeletingFile(a5),a0
.DeleteIt:	move.l	a0,d1
		move.l	d1,d5
.RetryDelete:	move.l	DTG_Dosbase(a5),a6
		jsr	_LVODeleteFile(a6)
		addq.l	#1,d0
		tst.l	d0
		bne.s	.Error

		jsr	A5SetOldDir(a5)

		lea	DeletingFile(a5),a0
		move.l	a0,ScrollArgs(a5)
		LA0	LNr_Deleted
		jmp	A5ScrollNewText(a5)


	*--- Testen, ob File protected ist ---*
.Error:		tst.l	d6
		bne.s	.RealError
		jsr	A5IOErr(a5)
		cmp.w	#222,d0
		bne.w	.RealError

	*----- Fragen, nach deprotecten ------*
		lea	DeletingFile(a5),a1
		jsr	FrageDeprotection
		bne.w	.RealError

	*---------- File deprotecten ---------*
		lea	DeletingFile(a5),a0
		move.l	a0,d1
		move.l	DTG_Dosbase(a5),a6
		moveq	#0,d2
		jsr	_LVOSetProtection(a6)

	*----------- Nochmal lschen ---------*
		moveq	#1,d6
		move.l	d5,d1
		bra.w	.RetryDelete

.RealError:	jsr	A5SetOldDir(a5)
		moveq	#EPR_ErrorDeletingFile,d0
		jmp	A5ScrollNewFehler(a5)



*****************************************************************************
*---------------------------- Add UserProgram ------------------------------*
*****************************************************************************
*AddEngineDir:	moveq	#0,d0
*		rts

*		jsr	A5WaitMouse(a5)
*		LA0	LNr_SW_AddEngine
*		jsr	A5PrintText(a5)
*
*		tst.l	d2
*		beq.s	.FileRequest
*		move.l	a2,a1
*		move.l	d2,d3
*		*subq.l	#1,d3
*		lea	EngineDir(a5),a0	;A0=Wohin mit Players.
*		jsr	A5CreateDirAusPath(a5)	;A1=Path d3=Lnge
*
*		cmp.l	#Mode_Config,TestBits(a5)
*		bne.s	.LoadIt
*		moveq	#0,d0
*		rts
*
*
*
*	;**** a0 = FileRequester-Title		    ****
*	;**** a1 = Directorypath		    ****
*	;**** a2 = Filename	 		    ****
*	;**** a3 = Window	 		    ****
*	;**** d0 = 1  SelectDir			    ****
*	;****	   0  SelectFile		    ****
*.FileRequest:	LA0	LNr_FR_AddEngineDir
*		lea	EngineDir(a5),a1
*		sub.l	a2,a2
*		jsr	A5GetMainWindowHandle(a5)
*		move.l	d0,a3
*		moveq	#1,d0			;Kennung ->> Dir zu laden
*		jsr	A5FileRequest2(a5)
*		bne.w	ToScrollNewFehler
*
*
*	*---------- Jetzt das Dir adden ---------*
*.LoadIt:	lea	EngineDir(a5),a1
*		jsr	A5HoleLock(a5)
*		beq.w	.EngineNotFound
*		move.l	DTG_Dosbase(a5),a6
*		jsr	_LVOCurrentDir(a6)
*		move.l	d0,OldDir(a5)
*		lea	Infoblock(a5),a0
*		move.l	d7,d1
*		move.l	a0,d2
*		jsr	_LVOExamine(a6)
*		move.l	EngineAnz(a5),d1
*		move.l	d1,-(a7)
*
*		moveq	#-1,d6
*		cmp.l	d6,d0
*		bne.w	.FreeOldUserDir
*
*		jsr	A5AddAbortGadget(a5)
*		jsr	A5WaitMouse(a5)
*
*	*---- Recursive UserProgramm LoadRoutine -----*
*.NextEngine:	jsr	A5GetAbortMsg(a5)
*		bne.s	.FreeOldUserDir
*		cmp.l	#AnzMaxEngines,EngineAnz(a5)	;User-Mem full
*		beq.w	.FreeOldUserDir
*		lea	Infoblock(a5),a0
*		move.l	a0,d2
*		move.l	d7,d1
*		move.l	DTG_Dosbase(a5),a6
*		jsr	_LVOExNext(a6)
*		tst.l	d0
*		beq.w	.FreeOldUserDir
*		moveq	#-1,d6
*		cmp.l	d6,d0			;andere Fehlermeldung als -1
*		bne.s	.NextEngine
*		jsr	A5ADDEngine2(a5)
*		tst.l	d0
*		beq.s	.NextEngine		;Fehler -> NextEngine
*		jsr	A5EngineSetName(a5)
*		bra.b	.NextEngine
*
*
*.FreeOldUserDir:jsr	A5SetOldDir(a5)
*		move.l	(a7)+,d7
*		jsr	A5RemoveAbortGadget(a5)
*		jmp	A5AddUserSetAnz(a5)
*
*.EngineNotFound:moveq	#EPR_FileNotFound,d0
*		jmp	A5ScrollNewText(a5)
*
*


*		move.l	FirstArg(a5),a1
*		jsr	A5FindFileName(a5)
*		moveq	#0,d0
*		cmp.l	a1,d0
*		beq.s	.NoMoreArgs
*
*********** Zeichenkette in Zahl konvertieren ******************
*** INPUT:  a0-Zeichenkette                                   **
*** RESULT: A1-nchstes Argument (oder 0)                     **
***         D1-Ausgabewert als Dualzahl                       **
***         D0-Indikator (-1=Fehler,0=ok)                     **
****************************************************************
*		move.l	a1,a0		;Zeiger auf 2.Argument
*		jsr	A5Getnumber(a5)	;Zeichenkette in Long-Zahl umwandeln
*		tst.l	d0
*		bne.w	.ErrorInArgs
*		move.w	d1,CPN_WinX(a3)
*		moveq	#0,d0
*		cmp.l	a1,d0
*		beq.s	.NoMoreArgs
*
*	*------ Y-Koordinate rauskriegen --------*
*		move.l	a1,a0		;Zeiger auf 2.Argument
*		jsr	A5Getnumber(a5)	;Zeichenkette in Long-Zahl umwandeln
*		tst.l	d0
*		bne.w	.ErrorInArgs
*		move.w	d1,CPN_WinY(a3)
*		moveq	#0,d0
*		cmp.l	a1,d0
*		beq.s	.NoMoreArgs
*
*	*------- Engine-Flags rauskriegen -------*
*		move.l	a1,a0		;Zeiger auf 2.Argument
*		jsr	A5Getnumber(a5)	;Zeichenkette in Long-Zahl umwandeln
*		tst.l	d0
*		bne.w	.ErrorInArgs
*		move.w	d1,CPN_Flags(a3)
*		moveq	#0,d0
*		cmp.l	a1,d0
*		beq.s	.NoMoreArgs
*
*	*--- Engine-Special-Zelle rauskriegen ---*
*		move.l	a1,a0		;Zeiger auf 2.Argument
*		jsr	A5Getnumber(a5)	;Zeichenkette in Long-Zahl umwandeln
*		tst.l	d0
*		bne.w	.ErrorInArgs
*		move.l	d1,CPN_Special(a3)
*		moveq	#0,d0
*		cmp.l	a1,d0
*		beq.s	.NoMoreArgs
*
*	*--- Engine-Special-Zelle rauskriegen ---*
*		move.l	a1,a0		;Zeiger auf 2.Argument
*		jsr	A5Getnumber(a5)	;Zeichenkette in Long-Zahl umwandeln
*		tst.l	d0
*		bne.w	.ErrorInArgs
*		move.l	d1,CPN_Special2(a3)
*		moveq	#0,d0
*		cmp.l	a1,d0
*		beq.s	.NoMoreArgs
*
*	*--- Engine-Special-Zelle rauskriegen ---*
*		move.l	a1,a0		;Zeiger auf 2.Argument
*		jsr	A5Getnumber(a5)	;Zeichenkette in Long-Zahl umwandeln
*		tst.l	d0
*		bne.w	.ErrorInArgs
*		move.l	d1,CPN_Special3(a3)
*
*
*	*---- Alle Argumente in Puffer aufgenommen ----*
*.NoMoreArgs:	addq.l	#1,UserConfigNr(a5)
*		moveq	#0,d0
*		rts
*
*.ErrorInArgs:	moveq	#EPR_ErrorInArguments,d0
*		rts
*.Error:		moveq	#EPR_NoMoreEngines,d0
*CF_Return:	rts
*
*

*****************************************************************************
*---------------------------- Add UserProgram ------------------------------*
*****************************************************************************
AddEngine:	clr.l	LoadedEngines(a5)
		jsr	A5WaitMouse(a5)
		LA0	LNr_Sw_AddEngine
		jsr	A5PrintText(a5)
		tst.l	d2
		beq.w	.FileReq
		cmp.l	#Mode_config,Testbits(a5)
		beq.w	.FileReq			*Quittet auch !!!

		*---- Engine laden ----*
		move.l	a1,a3				*Filename kopieren
		move.l	a2,a0
		lea	TextPuffer+1000(a5),a1
		move.l	d2,d1
		subq.w	#1,d1
		jsr	A5StringCopy2(a5)
		lea	TextPuffer+1000(a5),a0
		bra.s	.LoadEngineNow

		** a0 = FileRequester-Title  ****
		** a1 = Directorypath	     ****
		** a2 = Filename	     ****
		** a3 = Window	 	     ****
		** d0 = 1  SelectDir	     ****
		**	   0  SelectFile     ****
.FileReq:	LA0	LNr_Fr_AddEngine
		lea	EngineDir(a5),a1
		lea	EngineFile(a5),a2
		jsr	A5GetMainWindowHandle(a5)
		move.l	d0,a3
		moveq	#2,d0			;Kennung ->> File zu laden
		jsr	A5FileRequest2(a5)
		bne.w	ToScrollNewfehler
		cmp.l	#1,d1
		bhi.s	.MultiSelect

		lea	Enginefile(a5),a0	;Filename
		sub.l	a3,a3			;NextArg
.LoadEngineNow:	moveq	#0,d0			;UserNr
		sub.l	a1,a1			;UPrgS
		sub.l	a2,a2			;EUS
		jsr	A5LoadEngine(a5)
		bne.w	.ScrollNewFehler
		lea	EngineFile(a5),a0
		move.l	a0,ScrollArgs(a5)
		moveq	#LNr_SW_AddEngine,d0
		jmp	A5ScrollNew(a5)


*--------------------- Schleife fr MultiSelect -----------------------------*
.MultiSelect:	moveq	#0,d1
		move.l	EngineAnz(a5),d1
		movem.l	a0/d1,-(a7)
		move.l	a0,a3
.NextEinTrag:	move.l	DTG_Dosbase(a5),a6
		move.l	EFP_NameDirLock(a3),d7
		bne.s	.LockUsed

		lea	EngineDir(a5),a1
		move.l	EFP_DirArrayPtr(a3),d0
		beq.s	.NoDirLock
		move.l	d0,a0
		move.w	#DirPufferSize-2,d1
		jsr	A5StringCopy2(a5)
		bra.s	.NoDirLock


	*------- DirName in DirPuffer copieren -------*
.LockUsed:	clr.b	EngineDir(a5)			;Dirpointer lschen
		move.l	d7,d1
		lea	EngineDir(a5),a0
		move.l	a0,d2
		move.l	#DirPufferSize-2,d3
		jsr	_LVONameFromLock(a6)

	*----------- Engine laden ------------*
.NoDirLock:	move.l	EFP_IT_IText(a3),a0
		movem.l	d1-a6,-(a7)
		sub.l	a3,a3			;NextArg
		moveq	#0,d0			;UserNr
		sub.l	a1,a1
		sub.l	a2,a2
		jsr	A5LoadEngine(a5)
		movem.l	(a7)+,d1-a6

	*---------- Noch einen Eintrag -------*
.NoLock:	move.l	(a3),d0
		beq.s	.FreeMulti
		move.l	d0,a3
		bra.w	.NextEinTrag

.FreeMulti:	movem.l	(a7)+,a0/d1
		move.l	d1,d7
		moveq	#1,d0				;no internal Puffer
		jsr	A5FreeMultiPuffer(a5)
		move.l	LoadedEngines(a5),d0
		move.l	d0,ScrollArgs(a5)
		LA0	LNr_EnginesAdded
		jmp	A5ScrollNewText(a5)

.ScrollNewFehler:jmp	A5ScrollNewFehler(a5)





*-----------------------------------------------------------------------------*
* Diese Routine ldt das angegebene Engine in den Speicher, allociert eine    *
* UPrgS_Structur, setzt die Prefs und das Enginemenu.			      *
* LastUserPrg= letzte neue EUS_Structur (alte Funktion)			      *
** LastUserNr = letzte neue UserNr (alte Funktion)			      *
*-----------------------------------------------------------------------------*
* Input: d0=UserNr oder NULL (fr Batch bzw. Debugger)			      *
*	 a0=Filename oder NUll fr Enginefile(a5)			      *
*	 a1=UPrgS-Strukture (fr Batch bzw. Debugger)			      *
*	 a2=EUS-Strukture (fr Debugger)				      *
*	 a3=Args fr EngineConfig					      *
* Output:d0=Error oder NULL						      *
*	 d1=UserNr							      *
*-----------------------------------------------------------------------------*
* Engine normal laden							      *
* wenn der Pfad eine Null ergeben sollte, wird bei einem false nochmal im     *
* Enginedir nachgeschaut.						      *
* a0=Pfadname								      *
* a3=Args oder NULL							      *
* d0=a1=a2=a3=0								      *
*-----------------------------------------------------------------------------*
* Batcheintrag in PD-Menu:						      *
* d0=Uprg_NewBatch							      *
* a0=Pfad fr spteres Laden						      *
* a3=Args oder NULL							      *
* a1=a2=0								      *
*-----------------------------------------------------------------------------*
* Batcheintrag laden:							      *
* d0=Batchnummer -> wird geladen und entsprechend gesetzt		      *
* a1=UPrgS-Structure							      *
* a0=a2=a3=0								      *
*-----------------------------------------------------------------------------*
* Debuggereintrag setzen:						      *
* D0=UPrg_Debugger							      *
* a2=EUS-Struktur							      *
* a0=a1=a3=0								      *
*-----------------------------------------------------------------------------*
* ########################################################################### *
* ACHTUNG: Es wird kein SetMenuStrip oder GuiChanged usw. aufgerufen          *
* ########################################################################### *
*-----------------------------------------------------------------------------*
LoadEngine:	movem.l	d2-a6,-(a7)
		move.l	a3,LoadEngineArgs(a5)
	*	clr.l	LastEngine(a5)
		clr.l	NewEngineSegment(a5)
		clr.l	OldLoadAdr(a5)		;letztes UPrg in Verkettung
		move.w	d0,StartEngineNr(a5)
		moveq	#EPR_ErrorAddEngine,d7
		move.l	d0,d5
		move.l	a2,a4
		cmp.w	#UPrg_Debugger,d0
		beq.w	.NoLoadExe
		cmp.w	#UPrg_NewBatch,d0	*neue Batch ins Menu
		bne.w	.TestUserNr

		*----- Batcheintrag ins Menu bernehmen ----*
		moveq	#EPR_NoMoreEngines,d7
		jsr	A5FindFreeUserNr(a5)
		beq.w	.ErrorInD7
		move.l	d0,d5

		moveq	#UPrgB_BatchName,d1	*Flags
		moveq	#0,d2			*Lock
		sub.l	a4,a4			*EUS
		bsr	AllocUPrgS		*Achtung !!!!
		bne.w	.ErrorInD0		*bei Freigabe Verkettung
		
		bsr.w	SetEngineConfig		*a0=name
		move.l	d0,d2
		move.l	d5,d0
		jsr	A5FindUserStruct(a5)
		bne.w	.ErrorInD0
		move.w	d2,UPrgS_CFlags(a0)
		btst	#0,d2
		beq.s	.Ba2
		move.w	LE_WinX(a5),UPrgS_WinX(a0)
.Ba2		btst	#1,d2
		beq.s	.Ba3
		move.w	LE_WinY(a5),UPrgS_WinY(a0)
.Ba3		btst	#2,d2
		beq.s	.Ba4
		move.w	LE_Flags(a5),UPrgS_EUSFlags(a0)
.Ba4		btst	#3,d2
		beq.s	.Ba5
		move.l	LE_Special(a5),UPrgS_Special1(a0)
.Ba5		btst	#4,d2
		beq.s	.Ba6
		move.l	LE_Special2(a5),UPrgS_Special2(a0)
.Ba6		btst	#5,d2
		beq.s	.Ba7
		move.l	LE_Special3(a5),UPrgS_Special3(a0)
.Ba7		btst	#7,d2			*
		beq.w	.BatchAuch
		move.l	a0,a1
		lea	UPrgS_NamePuffer(a1),a0
		*bra.w	.BatchAuch

		*---- Eintrag aus Batch reinladen ----*
.TestUserNr:	moveq	#0,d2
		move.l	a2,a4			;EUS-Struktur
		cmp.l	a2,d2
		bne.w	.NoLoadExe		;schon da
		cmp.l	a1,d2			;keine UPrgS-Strukture
		beq.s	.LoadExe
		cmp.l	UPrgS_EngineNr(a1),d0
		bne.w	.ErrorInd7
		lea	UPrgS_NamePuffer(a1),a0

		*---- Engine reinladen ----*
.LoadExe:	moveq	#0,d0			;wahrscheinlich nur Debugger
		cmp.l	a0,d0
		beq.w	.ErrorInD7
	*	lea	FirstEngine-EUS_Next(a5),a4	;weil MerkAdr -> 4(a4)
	*	tst.l	LastEngine(a5)
	*	beq.s	.LoadFirst
	*	move.l	LastEngine(a5),a4
.LoadFirst:	moveq	#EUS_Next,d4
		movem.l	d5/d7/a0/a2,-(a7)
		move.l	a0,-(a7)			*Ausgabe "Loading .."
		move.l	a0,a1
		bsr	GetFilename
		move.l	a1,ScrollArgs(a5)
		LA0	LNr_Loading
		jsr	A5PrintText(a5)
		move.l	(a7)+,a0
		lea	EagleUser.MSG,a6
		move.l	a0,d1
		jsr	A5LoadEngineSegment(a5)		;Engine geladen
		movem.l	(a7)+,d5/d7/a0/a2
		tst.l	d0
		bne.w	.NoLoadExe

		move.l	LoadPlayerError(a5),d0
		bne.w	.ErrorBeimSegmentladen

		moveq	#EUS_Next,d4
		lea	EngineDir(a5),a1
		tst.b	(a1)
		beq.w	.ErrorInD7
		move.l	a1,LoadFilePath(a5)
		movem.l	d5/d7/a0/a2,-(a7)
		move.l	a0,a2
		jsr	A5CreateLoadPath(a5)
		lea	PathPuffer(a5),a0
		move.l	a0,d1
		lea	EagleUser.MSG,a6
		jsr	A5LoadEngineSegment(a5)		;Engine geladen
		movem.l	(a7)+,d5/d7/a0/a2
		tst.l	d0
		beq.w	.ErrorBeimSegmentLaden
		lea	PathPuffer(a5),a0
		bra.b	.NoCopyToPath

.NoLoadExe:	lea	PathPuffer(a5),a1
		move.w	#PathPufferSize-2,d1
		jsr	A5Stringcopy2(a5)
.NoCopyToPath:	*move.l	a4,LastEngine(a5)		;Engine merken
		lea	TextPuffer+300(a5),a3
		move.l	a4,d3
		move.b	EUS_Priority(a4),d2
		ext.w	d2
		ext.l	d2
		asr.l	#2,d3
		subq.l	#1,d3
		move.l	d3,d6
		move.l	#500,d4
		add.l	EUS_UnUsed1(a4),d4	;ist doch mal anders fr
						;registrierte User
		lea	FirstEngine(a5),a0
		tst.b	KeyOn-FirstEngine(a0)
		bne.w	.KeyIsDa
************************************************
* Zur Zeit disabled
* Ausserdem kacken dabei manche Debuggerengines ab
*
*	* Testen, ob es sich irgendwie um eine registrierte Version handelt *
		moveq	#EPR_FunctionNotEnabled,d7
		*tst.w	EUS_Flags(a4)
		*beq.w	.ErrorInD7
		tst.l	EUS_Unused1(a4)
		bne.w	.ErrorInD7
		tst.l	EUS_Unused2(a4)
		bne.w	.ErrorInD7
		cmp.w	#UPrg_Debugger,EUS_UserNr(a4)
		beq.s	.Debugger
		tst.l	EUS_EPBase(a4)
		bne.w	.ErrorInD7
.Debugger:	tst.l	EUS_Next(a4)
		bne.w	.ErrorInD7
		;tst.b	EUS_Reserved1(a4)		;ist jetzt EUS_Type
		;bne.w	.ErrorInD7			;ist jetzt EUS_Type
		*tst.w	EUS_Reserved2(a4)
		*bne.w	.ErrorInD7
		*tst.l	EUS_Reserved3(a4)
		*bne.w	.ErrorInD7
		tst.l	EUS_Reserved4(a4)
		bne.w	.ErrorInD7
		move.l	EUS_Creator(a4),a0
.FindCEnd:	tst.b	(a0)+
		bne.s	.FindCEnd
		cmp.b	#$ed,(a0)
		beq.w	.ErrorInD7
		cmp.b	#$ce,(a0)
		beq.w	.ErrorInD7
		cmp.b	#$af,(a0)
		beq.w	.ErrorInD7
		cmp.b	#$00,(a0)
		beq.w	.ErrorInD7

		*----- Normal das Engine in die Liste einfgen -----*
		*----- Freie Enginenummer finden ----*
.KeyIsDa:	bsr	FindBatchEintrag
		cmp.w	#UPrg_Debugger,d5
		beq.s	.DochNummer
		move.l	d5,d0
		bne.s	.NummerDa
		moveq	#EPR_NoMoreEngines,d7
.DochNummer:	jsr	A5FindFreeUserNr(a5)
		beq.w	.ErrorInD7
.NummerDa:	ext.l	d0
		move.l	d0,d1
		move.l	d0,d5
		move.l	EUS_PName(a4),a0
		jsr	A5KeyTestAufEngine(a5)	;gleichzeitig Test auf Key
		;jsr	A5BerechStringSize(a5)
		tst.l	d0
		beq.s	.TN_TagUser
		tst.l	(a4)			*den Tasknamen nur bei Task
		beq.s	.TN_TagUser		*Enginens korrigieren, da sonst
		cmp.l	#TagUserID,(a4)		*Fehler auftreten knnen
		beq.s	.TN_TagUser
		move.b	d1,-1(a0,d0.l)
		add.b	#"0",-1(a0,d0.l)	;Tasknamen korrigieren !!!
.TN_TagUser:	move.l	a5,EUS_EPBase(a4)
		clr.l	EUS_FreeTable(a4)
		clr.w	EUS_TickCounter(a4)
		clr.l	EUS_UnUsed1(a4)
		clr.l	EUS_UnUsed2(a4)
		move.w	EUS_UserNr(a4),d0	;old Nr 0 oder Debugger
		ext.l	d0
		move.w	d1,EUS_UserNr(a4)	;Nummer -> Structure
	*	cmp.w	#UPrg_Debugger,d0
	*	beq.w	.DebuggerStruct

		*------- Config einfgen --------*
		move.l	d0,d2			*Struct Da --> Batcheintrag
		jsr	A5FindUserStruct(a5)	*neu geladen
		bne.s	.NormalSuche
		move.w	UPrgS_CFlags(a0),d0
		lea	UPrgS_Winx(a0),a0
		bra.s	.PrefsSchonDa
.NormalSuche:	move.l	d2,d0
		move.l	EUS_UserName(a4),a0
		bsr.w	SetEngineConfig
		lea	LE_WinX(a5),a0
.PrefsSchonDa:	btst	#0,d0
		beq.s	.En2		
		move.w	(a0),EUS_WinX(a4)
.En2		btst	#1,d0
		beq.s	.En3
		move.w	2(a0),EUS_WinY(a4)
.En3		btst	#2,d0
		beq.s	.En4
		move.w	4(a0),EUS_Flags(a4)
.En4:		*tst.b	OnIconify(a5)
		*beq.s	.NoIconify
		*bclr	#EUSF_Show,EUS_Flags+1(a4)
.NoIconify:	or.w	#EUSB_OpenWin,EUS_Flags(a4)
		btst	#3,d0
		beq.s	.En5
		move.l	6(a0),EUS_Special(a4)
.En5		btst	#4,d0
		beq.s	.En6
		move.l	10(a0),EUS_Special2(a4)
.En6		btst	#5,d0
		beq.s	.En7
		move.l	14(a0),EUS_Special3(a4)

.En7:		move.l	#EUT_LocaleTable,d0
		move.l	EUS_TagList(a4),a6
		jsr	A5FindTag2(a5)
		move.l	a6,a0
		jsr	A5SetTableLocale(a5)

		*---- Fr TagenginePrgs keine CreateProc ---*
		moveq	#EPR_ErrorAddEngine,d7
		tst.l	(a4)
		beq.s	.TagUser
		cmp.l	#TagUserID,(a4)
		bne.s	.TaskUser
.TagUser:	move.l	#EUT_InitEngine,d0
		move.l	EUS_TagList(a4),a6
		moveq	#-1,d3		;Error fr d0
		jsr	A5CallUp3(a5)
		beq.s	.NoInitEngine	;Tag nicht gefunden -> nicht ntig
		tst.l	d0
		bne.w	.ErrorInD7

		*--- Versionsnummern updaten ---*
.NoInitEngine:	move.l	#EUT_UpdateVer,d0
		move.l	EUS_TagList(a4),a6
		LA0	LNr_EPVersion
		jsr	A5CallUp3(a5)
.DebuggerStruct:moveq	#UPrgB_Engine!UPrgB_TagUser,d1
		bra.s	.AllocUPrgS

		*--- Prozess fr TaskEngine starten ----*
.TaskUser:	cmp.w	#UPrg_Debugger,StartEngineNr(a5)
		beq.w	.Debugger_2

		move.l	EUS_PName(a4),d1
		*move.l	DTG_Dosbase(a5),a6
		move.l	DTG_Dosbase-(TextPuffer+300)(a3),a6
		lea	NewProcTags(pc),a0
		move.l	d1,28(a0)			;NP_name
		move.l	d2,20(a0)			;NP_Pri
		move.l	d3,4(a0)			;NP_Seglist
		move.l	d4,12(a0)			;NP_Stacksize
		move.l	a0,d1
		jsr	_LVOCreateNewProc(a6)
		moveq	#EPR_UnknownError,d7
		tst.l	d0
		beq.w	.ErrorInD7
.Debugger_2:	moveq	#UPrgB_Engine!UPrgB_Disabled,d1

		*-- UPrgS-Structure allocieren und Menu setzen --*
.AllocUPrgS:	move.w	EUS_UserNr(a4),d0
		moveq	#0,d2			*Lock
		lea	PathPuffer(a5),a0
		bsr	AllocUPrgS		*Achtung !!!!
		bne.w	.ErrorInD0		*bei Freigabe Verkettung


	*-------------- Taguser-Activieren -----------*
		move.l	d5,d0
		jsr	A5FindUserStruct(a5)
		bne.w	.ErrorInD7
		btst	#UPrgF_TagUser,UPrgS_UFlags+3(a0)
		beq.s	.BatchAuch
		move.l	UPrgS_EUSAdr(a0),a6
		cmp.b	#EUTY_MainWindow,EUS_Type(a6)	*Gui's noch nicht ak.
		beq.s	.BatchAuch

		move.l	a0,a3
		move.l	#EUT_Activate,d0
		move.l	EUS_TagList(a4),a6
		moveq	#-1,d3
		jsr	A5CallUp3(a5)
		beq.s	.HakenSetzen
		tst.l	d0
		bne.s	.BatchAuch

.HakenSetzen:	moveq	#USClass_RemEnginesList,d0
		jsr	A5SendeAllMessage(a5)

		move.l	a3,a0
		jsr	A5SetEngineZustand(a5)
		bset	#UPrgF_Active,UPrgS_UFlags+3(a3)
		jsr	A5InsertEngineNodeName(a5)

		moveq	#USClass_NewEngineLoaded,d0
		jsr	A5SendeAllMessage(a5)


		*btst	#EUSF_Show,EUS_Flags+1(a4)
		*beq.s	.BatchAuch
		*bset	#UPrgF_Show,UPrgS_UFlags+3(a3)

	*------------- Userprogramme benachrichten --------------*
.BatchAuch:	cmp.w	#UPrg_Debugger,StartEngineNr(a5)
		beq.w	.NoWait
		move.l	d5,d0
		jsr	A5WaitForStartMsg(a5)
		jsr	A5RefreshMenu(a5)

.NoWait:	moveq	#USClass_NewEngineLoaded,d0
		jsr	A5SendeAllMessage(a5)
		move.w	d5,d0
		jsr	A5FindUserStruct(a5)
		bne.s	.ErrorInD0
		jsr	A5ActivateAUser(a5)
		tst.l	d0
		beq.s	.EngineOk
		cmp.l	#-1,d0
		bne.s	.EngineOk
		moveq	#0,d0
.EngineOk:	addq.l	#1,LoadedEngines(a5)
		bra.s	.Return


	*------ Segment lschen , weil nicht gestartet ------*
.ErrorBeimSegmentLaden
		move.l	LoadPlayerError(a5),d0
		bne.s	.ErrorInD0
.ErrorInD7:	move.l	d7,d0
.ErrorInD0:	move.l	NewEngineSegment(a5),d1
		beq.s	.NoSegment
		move.l	d1,a4
		move.w	EUS_UserNr(a4),d0
		jsr	A5FindUserStruct(a5)
		bne.s	.Err_NoUser
		clr.l	UPrgS_EUSAdr(a0)
		clr.l	UPrgS_SubItem(a0)
		move.l	#UPrgB_Batchname,UPrgS_UFlags(a0)
.Err_NoUser:	cmp.w	#UPrg_Debugger,EUS_UserNr(a4)
		beq.s	.NoSegment
		cmp.w	#UPrg_Debugger,StartEngineNr(a4)
		beq.s	.NoSegment
		move.l	d6,d1
		beq.s	.NoSegment
		move.l	DTG_Dosbase-(TextPuffer+300)(a3),a6
		jsr	_LVOUnLoadSeg(a6)
.NoSegment:	moveq	#0,d1				;UserNr
.Return:	clr.l	LoadEngineArgs(a5)
		clr.l	NewEngineSegment(a5)
		movem.l	(a7)+,d2-a6
		tst.l	d0
		rts

NewProcTags:
.4		dc.l	$800003e9,0		;NP_seglist
.12		dc.l	$800003f3,0		;NP_StackSize
.20		dc.l	$800003f5,0		;NP_Priority
.28		dc.l	$800003f4,0		;NP_Name
*.28		dc.l	$800003f2,0		;NP_CurrentDir
		dc.l	0

*----------------------------------------------------------------------------*
* Falls dieses Engine in der Batchliste existiert, wird die Struktur gesetzt.*
FindBatchEintrag:
		movem.l	d0-d4/d6-a6,-(a7)
		lea	EPG_FirstUserStruct(a5),a3
.NextB:		move.l	(a3),d0
		beq.w	.NoMore
		move.l	d0,a3
		btst	#UPrgF_BatchName,UPrgS_UFlags+3(a3)
		beq.s	.NextB
		move.l	UPrgS_Name(a3),a0		*Filename
		lea	PathPuffer(a5),a1
		jsr	A5GetFilename(a5)
		jsr	A5StrCMp3(a5)
		bne.s	.NextB
		move.l	a3,a0
		move.l	a4,UPrgS_EUSAdr(a3)
		bsr	InsertSubItems

		move.l	UPrgS_EngineNr(a3),d5

		moveq	#UPrgB_Engine!UPrgB_TagUser,d0
		tst.l	(a4)				;Flags richtig setzen
		beq.s	.TagUser
		cmp.l	#TagUserID,(a4)
		beq.s	.TagUser
		moveq	#UPrgB_Engine!UPrgB_Disabled,d0
.TagUser:	move.l	d0,UPrgS_UFlags(a3)




		move.w	UPrgS_CFlags(a3),d0
		btst	#0,d0
		beq.s	.En2		
		move.w	UPrgS_WinX(a3),EUS_WinX(a4)
.En2		btst	#1,d0
		beq.s	.En3
		move.w	UPrgS_WinY(a3),EUS_WinY(a4)
.En3		btst	#2,d0
		beq.s	.En4
		move.w	UPrgS_EUSFlags(a3),EUS_Flags(a4)
.En4		btst	#3,d0
		beq.s	.En5
		move.l	UPrgS_Special1(a3),EUS_Special(a4)
.En5		btst	#4,d0
		beq.s	.En6
		move.l	UPrgS_Special2(a3),EUS_Special2(a4)
.En6		btst	#5,d0
		beq.s	.En7
		move.l	UPrgS_Special3(a3),EUS_Special3(a4)
.EN7:
.NoMore:	movem.l	(a7)+,d0-d4/d6-a6
		rts


*---------------------------------------------------------------------------*
* Allokiert die UPRgS-Struktur und fllt diese mit den gegebenen Werten.    *
* Input:  d0=UserNr							    *
*	  d1=UPrgS_UFlags						    *
*	  d2=Lock des Engines oder NULL					    *
*	  a0=Pfad des Engines (zum Puffern, fr spteres Batch)		    *
*	  a4=EUS-Struktur oder NULL					    *
* Output: d0=Error oder NULL						    *
*---------------------------------------------------------------------------*
* ACHTUNG: Es wird kein SetMenuStrip oder GuiChanged usw. aufgerufen        *
*---------------------------------------------------------------------------*
AllocUPrgS:	movem.l	d1-a6,-(a7)
		ext.l	d0
		move.l	d1,d6				;Flags
		move.l	d2,d5				;Lock
		move.l	a0,a3
		moveq	#EPR_ErrorInArguments,d2
		tst.l	d0
		beq.w	.Error
		jsr	A5ClearMenuStrip(a5)
		move.l	d0,d4				;UserNr

		jsr	A5FindUserStruct(a5)		;bei Batchloading
		beq.w	.NoError

	*------------ Verkettung neu setzen ----------*
		move.l	a3,a1
		jsr	A5GetFilename(a5)
		move.l	a1,a0
		jsr	A5BerechStringSize(a5)
		move.l	d0,d7
		addq.l	#4,d7

		lea	EPG_FirstUserStruct-UPrgS_NextUPrg(a5),a2
.TestNextUser:	move.l	UPrgS_NextUPrg(a2),d1
		beq.s	.LastStructFound
		move.l	d1,a0
		move.l	UPrgS_Name(a0),a0
		bsr	TestSortStrings
		tst.l	d0
		bgt.s	.LastStructFound
		move.l	d1,a2
		bra.s	.TestNextUser

	*---- Speicher fr UPrg-Struktur besorgen ----*
.LastStructFound:move.l	a3,a0
		jsr	A5BerechStringSize(a5)
		move.l	d0,d1
		movem.l a1/a2/d1,-(a7)
		add.l	#UPrgS_NamePuffer+4,d0
		add.l	d7,d0
		move.l	d0,d3
		jsr	A5AllocMem(a5)
		moveq	#EPR_NotEnoughMem,d2
		movem.l	(a7)+,a2/a1/d1
		tst.l	d0
		beq.w	.Error
		move.l	d0,a0


		move.w	#UPrgS_NamePuffer+4,d0
		lea	(a0,d0.w),a1
		lea	(a1,d1.w),a1
		move.l	a1,UPrgS_Node+LN_Name(a0)



		moveq	#USClass_RemEnginesList,d0
		jsr	A5SendeAllMessage(a5)

		*- Enginetypische Eigenschaften setzen -*
		move.l	(a2),UPrgS_NextUPrg(a0)
		move.l	a0,UPrgS_NextUPrg(a2)		*Verkettung

		*-- Noden verknpfen --*
		* Input: a0=Liste							      *
		*	 a1=Neue Node							      *
		*	 a2=Node, die davorsteht					      *
		*--------------------------------
		movem.l	a0/a1/a2,-(a7)
		lea	UPrgS_Node(a0),a1
		lea	UPrgS_Node(a2),a2
		lea	EPG_FirstUserStruct+UPrgS_Node(a5),a0
		cmp.l	a2,a0
		bne.s	.NoFirst
		sub.l	a2,a2
.NoFirst:	lea	EngineList(a5),a0
		jsr	A5InsertInList(a5)
		movem.l	(a7)+,a0/a1/a2


		move.l	a0,-(a7)			*Pfad kopieren
		lea	UPrgS_NamePuffer(a0),a0
		move.l	a3,a1
		subq.w	#1,d1
		jsr	A5CopyText2(a5)
		move.l	(a7)+,a0

		move.l	d3,UPrgS_Size(a0)
		move.w	d4,UPrgS_EngineNr+2(a0)
*		move.l	d4,LastUserNr(a5)
		move.w	#EPNr_Engine,UPrgS_EPNr(a0)
		lea	UPrgS_NamePuffer(a0),a1
		bsr	GetFilename
		move.l	a1,UPrgS_Name(a0)		;Menuname setzen
		move.l	a4,UPrgS_EUSAdr(a0)		;EUS_Addi setzen


	*--------------- Defaults setzen -----------*
		move.w	#$5b,UPrgS_Flags(a0)
		bsr	InsertSubItems

		lea	UPrgS_IText(a0),a1		;IText setzen
		move.l	a1,UPrgS_IAdr(a0)

		*moveq	#3,d0
		*tst.w	Kick3On(a5)
		*beq.s	.NoKick30
		*move.w	#$100,d0
.NoKick30:	*move.w	d0,UPrgS_IText(a0)		;IText-Defaults setzen
		*move.l	#$140001,UPrgS_IText+4(a0)

		addq.l	#1,EngineAnz(a5)		*beachten
.NoError:	moveq	#0,d2				;Kein Fehler
		move.l	d6,UPrgS_UFlags(a0)
		move.l	a4,UPrgS_EUSAdr(a0)
		move.l	a4,d0
		beq.s	.NoEUS
		addq.l	#1,LoadedEngineAnz(a5)		*beachten
.NoEUS:		jsr	A5InsertEngineNodeName(a5)
.Error:		move.l	d2,d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*------------------------ EnginesubMenu einfgen -----------------------------*
* Input: a0=UPrgS_Struct
*	 a4=EUSAdr oder NULL
* Output:a0=Anfang der SubItemmenus
*-----------------------------------------------------------------------------*
InsertSubItems:	movem.l	d0/d2/a1/a6/a0,-(a7)
		move.l	a4,d0
		beq.s	.NoSubItems
		move.l	EUS_Taglist(a4),a6
		move.l	#EUT_EPSubItems,d0
		jsr	A5FindTag2(a5)
		beq.s	.NoSubItems
		move.l	a6,UPrgS_SubItem(a0)
		and.w	#-1-$108,UPrgS_Flags(a0)	*Hakenflags lschen
		move.l	a6,a0

		*--- Nun die Items lokalisieren ---*
.NextOne:	move.w	EPMI_LNr(a6),d0
		beq.s	.Nichtdieses
		jsr	A5GetLocaleString(a5)
		lea	InternalStrings,a1		*original lassen !
		cmp.l	d0,a1
		beq.s	.NichtDieses
		move.l	d0,EPMI_ITIText(a6)
.Nichtdieses:	move.l	(a6),d0
		beq.s	.NoSubItems
		move.l	d0,a6
		bra.s	.NextOne

.NoSubItems:	movem.l	(a7)+,d0/d2/a1/a6/a0
		rts

*----------------------------------------------------------------------------*
* Die LocaleTabelle wird gesetzt.					     *
* Input: a0=Tabelle oder NULL						     *
* Aufbau der Tabelle:	1.w	LocaleNummer				     *
*			1.l	Orig. Language (engischer Text)		     *
*			1.l	neuer Text bzw. falls kein Catalog orig.Ptr  *
* Ende mit NULL								     *
* Output: None								     *
*----------------------------------------------------------------------------*
SetTableLocale:	movem.l	d0-a6,-(a7)
		move.l	a0,d0
		beq.s	.Return
		move.l	a0,a2
.NextEintrag:	move.w	(a2)+,d0
		beq.s	.Return
		jsr	A5GetLocaleString(a5)
		move.l	(a2)+,d1			*Orig Text
		lea	InternalStrings,a1		*StringError ?
		cmp.l	d0,a1
		beq.s	.OrigText
		move.l	d0,d1
.OrigText:	move.l	d1,(a2)+
		bra.s	.NextEintrag

.Return:	movem.l	(a7)+,d0-a6
		rts


*----------------------------------------------------------------------------*
* Teste, ob der Name in a1 im Alphabet hher liegt als Name in a0	     *
* Input: a0=name1							     *
*	 a1=Name2							     *
* Output:d0=0 Name1(a0) ist vor Name2(a1)				     *
*	 d0=1 Name2(a1) ist vor Name1(a0)				     *
*	 d0=-1 Name1(a0) ist gleich Name2(a1)
*----------------------------------------------------------------------------*
TestSortStrings:movem.l	d1/d2/d3/a0/a1,-(a7)
		moveq	#0,d0
		moveq	#Namenlange-1,d2
.NextBuchSt:	move.b	(a0)+,d3
		move.b	(a1)+,d1
		cmp.b	#"a",d3
		blt.s	.NoSub1
		cmp.b	#"z",d3
		bgt.s	.NoSub1
		bclr	#5,d3
.NoSub1		cmp.b	#"a",d1
		blt.s	.NoSub2
		cmp.b	#"z",d1
		bgt.s	.NoSub2
		bclr	#5,d1
.NoSub2:	cmp.b	d3,d1
		blt.s	.NoThis
		bgt.s	.SetToLast
		dbf	d2,.NextBuchSt
		moveq	#-1,d0
		bra.s	.SetToLast
.NoThis:	moveq	#1,d0
.SetToLast:	movem.l	(a7)+,d1/d2/d3/a0/a1
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
* Kopiert den Namen des Engines mit (), falls ntig, in den NodePuffer
*-----------------------------------------------------------------------------*
* Input: a0=UPrgS_Struct
*-----------------------------------------------------------------------------*
* Die Stringlnge mte immer hinhauen, da sie mal berechnet wurde.
InsertEngineNodeName:
		movem.l	d0/d1/d2/d3/a0/a1,-(a7)
		moveq	#1,d2				;disabled
		move.l	UPrgS_UFlags(a0),d3
		move.l	UPrgS_Node+LN_Name(a0),d0
		beq.s	.Return
		move.l	d0,a1
		tst.l	UPrgS_EUSAdr(a0)
		move.l	UPrgS_Name(a0),a0
		beq.s	.Off
		btst	#UPrgF_Batchname,d3
		bne.s	.Off
		btst	#UPrgF_Active,d3
		bne.s	.On
		*bne.s	.On
		*btst	#UPrgF_Disabled,d3
		*beq.s	.On
.Off:		moveq	#0,d2
.On:		tst.w	d2
		bne.s	.NoOff1
		move.b	#"(",(a1)+
.NoOff1:	jsr	A5StringCopy(a5)
		tst.w	d2
		bne.s	.NoOff2
		move.b	#")",(a1)+
.NoOff2:	clr.b	(a1)

.Return:	movem.l	(a7)+,d0/d1/d2/d3/a0/a1
		rts



* Input: a1=Pfad des Engines
* output:a1=start des filenamens
GetFilename:	move.l	a0,-(a7)
		move.l	a1,a0
		sub.l	a1,a1
		jsr	A5BerechStringSize(a5)
		*subq.l	#1,d0
		beq.s	.No
		lea	(a0,d0.w),a0
.NextB:		move.b	-(a0),d1
		beq.s	.No
		cmp.b	#"/",d1
		beq.s	.Yes
		cmp.b	#":",d1
		beq.s	.Yes
		subq.l	#1,d0
		bne.s	.NextB
		subq.l	#1,a0
.Yes:		lea	1(a0),a1
.No:		move.l	(a7)+,a0
		rts

* Input: a1=Pfad des Engines
* output:a1=start des filenamens
GetFilename2:	move.l	a0,-(a7)
		move.l	a1,a0
		sub.l	a1,a1
		jsr	A5BerechStringSize(a5)
		*subq.l	#1,d0
		beq.s	.No
		lea	(a0,d0.w),a0
.NextB:		move.b	-(a0),d1
		cmp.b	#32,d1
		blo.s	.No
		cmp.b	#"/",d1
		beq.s	.Yes
		cmp.b	#":",d1
		beq.s	.Yes
		subq.l	#1,d0
		bne.s	.NextB
		subq.l	#1,a0
.Yes:		lea	1(a0),a1
.No:		move.l	(a7)+,a0
		rts

* wertet auch PC typische Verzeichnisse aus "\"
* Input: a1=Pfad des Engines
* output:a1=start des filenamens
GetFilename3:	move.l	a0,-(a7)
		move.l	a1,a0
		sub.l	a1,a1
		jsr	A5BerechStringSize(a5)
		*subq.l	#1,d0
		beq.s	.No
		lea	(a0,d0.w),a0
.NextB:		move.b	-(a0),d1
		beq.s	.No
		cmp.b	#"/",d1
		beq.s	.Yes
		cmp.b	#"\",d1
		beq.s	.Yes
		cmp.b	#":",d1
		beq.s	.Yes
		subq.l	#1,d0
		bne.s	.NextB
		subq.l	#1,a0
.Yes:		lea	1(a0),a1
.No:		move.l	(a7)+,a0
		rts

**-----------------------------------------------------------------------------*
** Aktiviere Eagleplayer-Guis.						      *
** Input: d0=UserNr							      *
** Output:none								      *
**-----------------------------------------------------------------------------*
*ActivateGuis:	movem.l	d0-a6,-(a7)
*		jsr	A5FindUserStruct(a5)
*		bne.s	.NoGui
*
*		btst	#UPrgF_Engine,UPrgS_UFlags+3(a0)
*		beq.s	.NoGui
*
*	*------ Wurde ein TagUser hinzugefgt --------*
*	* TagUser werden nicht als Prozess gestartet. *
*	* Alle Gui's sind u.a TagUser		      *
*		move.l	UPrgS_EUSAdr(a0),d0		;EUS_Adr ?
*		beq.s	.NoGui
*		move.l	a0,a3
*		move.l	d0,a1
*		moveq	#0,d0
*		cmp.l	#TagUserID,(a1)			;wirklich TagUser
*		bne.w	.NoGui
*		cmp.b	#EUTY_MainWindow,EUS_Type(a1)
*		bne.s	.NoGui
*
*	*------------- User-Config setzen ------------*
*		moveq	#0,d0				;Aktivieren ?
*		*move.w	EUS_Flags(a1),d0
*		*btst	#EUSF_Openwin,d0
*		*beq.s	.NoGui
*
*	*----------- Normales TagEngine --------------*
*		jsr	A5ActivateAUser(a5)		;Gui aktivieren ?
*		bne.s	.NoGui				;ja
*
*
*		*move.l	#EUT_Activate,d0
*		*move.l	EUS_TagList(a1),a6
*		*moveq	#-1,d3			;Error fr d0
*		*jsr	A5CallUp3(a5)
*		*beq.s	.NowActive		;Tag nicht gefunden -> nicht ntig
*		*tst.l	d0
*		*bne.s	.NoGui			;Error -> nicht setzen
*.NowActive:	jsr	A5SetEngineZustand(a5)	;Hacken setzen bei OpenWin
*.NoGui:		movem.l	(a7)+,d0-a6
*		rts
*

*----------------------------------------------------------------------------*
* Es werden max. 2 Sekunden bis zur Ankunft der StartMessage gewartet.	     *
*----------------------------------------------------------------------------*
* Input: a0=UPrgS_Struct						     *
*Output: d0=?								     *
*----------------------------------------------------------------------------*
WaitForStartMsg:
		movem.l	d0-a6,-(a7)
		jsr	A5FindUserStruct(a5)
		bne.s	.Return
		move.l	a0,a4
		move.l	UPrgS_EusAdr(a4),d0
		beq.s	.Return
		move.l	d0,a3
		tst.l	(a3)				;TagUser --> weg
		beq.s	.Return
		cmp.l	#TagUserID,(a3)			;TagUser --> weg
		beq.s	.Return
		moveq	#100,d7
		addq.w	#1,RefreshMenuVerbot(a5)
.Retry:		lea	EPEnginePort,a0
		ExecBase
		jsr	_LVOGetmsg(a6)
		tst.l	d0			;Scrollen erlaubt
		beq.w	.Delay
		movem.l	d7/a4,-(a7)
		jsr	A5EngineMessage(a5)
		movem.l	(a7)+,d7/a4
		move.l	UPrgS_UFlags(a4),d0
		btst	#UPrgF_Disabled,d0
		beq.s	.Return2
.Delay:		jsr	A5Delay(a5)
		subq.l	#1,d7
		bne.s	.Retry
.Return2:	subq.w	#1,RefreshMenuVerbot(a5)
.Return:	movem.l	(a7)+,d0-a6
		rts

*----------------- Setze die User-Config in Argumentzellen ------------------*
* Falls LoadEngineArgs NULL sein sollte, wird in der Config nach dem Namen   *
* des Engines gesucht und 
* Input: a0=Name des Engine
* Output:d0=Changemask
SetEngineConfig:movem.l	d1-a6,-(a7)
		moveq	#0,d7
		move.l	LoadEngineArgs(a5),d1
	beq.s	.NoMore
*		bne.s	.ArgsOK
*		cmp.l	d1,a0
*		beq.w	.NoMore
*
*
*		move.l	a0,a1
*		bsr	GetFileName
*		move.l	a1,a0
*
*		*--- Config nach dem Namen des Userprgs durchsuchen ---*
*		bsr	GetArgs2
*		bne.w	.NoMore			* Args im TextPuffer
*		move.l	a1,d1
*		beq.w	.NoMore

.ArgsOk:	move.l	d1,a1
		*cmp.l	#Mode_Config,TestBits(a5)
		*bne.s	.NoZustand
		*moveq	#EPRTAB_Zustand1!EPRTAB_Must1,d0
		*bsr	GibArg			;>- d0=Fehler oder Null
		*tst.l	d0
		*bne.s	.NoMore			;>- d1=Zahl,Zustand,StringSize
		*lsl.l	#7,d1
		*or.b	d1,d7

.NoZustand:	moveq	#EPRTAB_Zahl1!EPRTAB_Must1,d0
		bsr	GibArg			;>- d0=Fehler oder Null
		tst.l	d0
		bne.s	.NoMore			;>- d1=Zahl,Zustand,StringSize
		move.w	d1,LE_WinX(a5)
		bset	#0,d7

		moveq	#EPRTAB_Zahl1!EPRTAB_Must1,d0
		bsr	GibArg			;>- d0=Fehler oder Null
		tst.l	d0
		bne.s	.NoMore			;>- d1=Zahl,Zustand,StringSize
		move.w	d1,LE_WinY(a5)
		bset	#1,d7

		moveq	#EPRTAB_Zahl1!EPRTAB_Must1,d0
		bsr	GibArg			;>- d0=Fehler oder Null
		tst.l	d0
		bne.s	.NoMore			;>- d1=Zahl,Zustand,StringSize
		move.w	d1,LE_Flags(a5)
		bset	#2,d7

		moveq	#EPRTAB_Zahl1!EPRTAB_Must1,d0
		bsr	GibArg			;>- d0=Fehler oder Null
		tst.l	d0
		bne.s	.NoMore			;>- d1=Zahl,Zustand,StringSize
		move.l	d1,LE_Special(a5)
		bset	#3,d7

		moveq	#EPRTAB_Zahl1!EPRTAB_Must1,d0
		bsr	GibArg			;>- d0=Fehler oder Null
		tst.l	d0
		bne.s	.NoMore			;>- d1=Zahl,Zustand,StringSize
		move.l	d1,LE_Special2(a5)
		bset	#4,d7

		moveq	#EPRTAB_Zahl1!EPRTAB_Must1,d0
		bsr	GibArg			;>- d0=Fehler oder Null
		tst.l	d0
		bne.s	.NoMore			;>- d1=Zahl,Zustand,StringSize
		move.l	d1,LE_Special3(a5)
		bset	#5,d7
.NoMore:	move.l	d7,d0
		movem.l	(a7)+,d1-a6
		rts

*-----------------------------------------------------------------------------*
* Es werden alle Engines reingeladen, die in der Config angegeben wurden.     *
*-----------------------------------------------------------------------------*
LoadStartEngines:
		movem.l	d0-a6,-(a7)

		jsr	A5InitEngineVerbot(a5)

.NextEngine:	clr.l	TestBits(a5)
		moveq	#0,d5
		moveq	#LNr_Str_LoadEngine,d0
		*moveq	#EPNr_LoadEngine,d6
		jsr	A5GetArgs(a5)		* Argumente aus Config holen
		beq.w	.Ok1			* Args im TextPuffer

		moveq	#1,d5
		moveq	#LNr_Str_LoadGui,d0
		*moveq	#EPNr_LoadEngine,d6
		jsr	A5GetArgs(a5)		* Argumente aus Config holen
		bne.w	.DasWars		* Args im TextPuffer

.Ok1:		lea	KommandoTabelle+(EPRT_SizeOf*(EPNr_LoadEngine-1)),a4

	*------ Testen, ob Engineconfig nur in die Batch soll oder ------*
	*------ ob das ganze Engine geladen werden soll -----------------*
		lea	TextPuffer(a5),a1
		moveq	#EPRTAB_String1!EPRTAB_Must1,d0	*### Name des Engines
		bsr	GibArg			;>- d0=Fehler oder Null
		bne.s	.NextEngine		;>- d1=Zahl,Zustand,StringSize

		move.l	d1,d4			*Len of Enginename
		move.l	a0,a4			*Adr of Enginename
		move.l	a1,a3			*FirstArg(a5)
		clr.b	(a4,d4.w)		*nullterminieren

		moveq	#EPRTAB_Zahl1!EPRTAB_Must1,d0	*### WINX
		bsr	GibArg			;>- d0=Fehler oder Null
		bne.s	.NextEngine		;>- d1=Zahl,Zustand,StringSize


		moveq	#EPRTAB_Zahl1!EPRTAB_Must1,d0	*### WinY
		bsr	GibArg			;>- d0=Fehler oder Null
		bne.s	.NextEngine		;>- d1=Zahl,Zustand,StringSize

		moveq	#EPRTAB_Zahl1!EPRTAB_Must1,d0	*### Flags
		bsr	GibArg			;>- d0=Fehler oder Null
		bne.s	.NextEngine		;>- d1=Zahl,Zustand,StringSize

		tst.l	d5
		beq.s	.LadenWennSoll
		tst.b	OnNoGui(a5)
		bne.s	.ConfigInBatch

.LadenWennSoll:	btst	#0,d1			;laden oder nicht
		beq.s	.ConfigInBatch

		jsr	A5CheckLoadVerbot(a5)
		bne.s	.ConfigInBatch

		move.l	a4,a0
		moveq	#0,d0			;UserNr
		sub.l	a1,a1
		sub.l	a2,a2
		jsr	A5LoadEngine(a5)
		bra.s	.NextEngine

	*-------------- die Enginenbatchconfig wird gesetzt --------*
.ConfigInBatch:	movem.l	d0-a6,-(a7)
		move.l	a3,LoadEngineArgs(a5)

		jsr	A5FindUserASCStruct(a5)
		bne.s	.ConfigNoMore

		move.l	a4,a0
		bsr	SetEngineConfig
		move.w	d0,UPrgS_CFlags(a3)
		btst	#0,d0
		beq.s	.Ba2
		move.w	LE_WinX(a5),UPrgS_WinX(a3)
.Ba2		btst	#1,d0
		beq.s	.Ba3
		move.w	LE_WinY(a5),UPrgS_WinY(a3)
.Ba3		btst	#2,d0
		beq.s	.Ba4
		move.w	LE_Flags(a5),UPrgS_EUSFlags(a3)
.Ba4		btst	#3,d0
		beq.s	.Ba5
		move.l	LE_Special(a5),UPrgS_Special1(a3)
.Ba5		btst	#4,d0
		beq.s	.Ba6
		move.l	LE_Special2(a5),UPrgS_Special2(a3)
.Ba6		btst	#5,d0
		beq.s	.Ba7
		move.l	LE_Special3(a5),UPrgS_Special3(a3)
.Ba7	
.ConfigNoMore:	movem.l	(a7)+,d0-a6
		bra.w	.NextEngine



.DasWars:	jsr	A5EndEngineVerbot(a5)

		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Sucht eine Enginestruktur, von der nur der Name bekannt ist
* Input: a4=Name des Engines
* Output:d0=Error oder NULL
*	 a3=Struct
*-----------------------------------------------------------------------------*
FindUserAscStruct:
		movem.l	d1-a2/a4-a6,-(a7)
		moveq	#EPR_EngineNotFound,d7
		lea	EPG_FirstUserStruct(a5),a3
.ConfigNext:	move.l	(a3),d0
		beq.s	.Return
		move.l	d0,a3
		move.l	UPrgS_Name(a3),d0
		beq.s	.ConfigNext
		move.l	d0,a2
		move.l	a4,a0			*Name in 
		jsr	A5StrCmp(a5)
		bne.s	.ConfigNext
		moveq	#0,d7
.Return:	move.l	d7,d0
		movem.l	(a7)+,d1-a2/a4-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: -
* Output:d0=Error oder NULL
*-----------------------------------------------------------------------------*
InitEngineVerbot:
		movem.l	d0-a6,-(a7)
		clr.l	EngineVerbotPtr(a5)
		clr.l	EngineVerbotSize(a5)

		move.w	#EPNr_NoEngine,d6
		move.w	#LNr_Str_NoEngine,d0
		jsr	A5GetArgs(a5)		* Argumente aus Config holen
		bne.s	.Return			* Args im TextPuffer

		lea	TextPuffer(a5),a0
		jsr	A5BerechStringSize(a5)
		beq.s	.Return
		addq.l	#2,d0
		move.l	d0,d3
		jsr	A5AllocMem(a5)
		beq.w	.Return
		move.l	d0,EngineVerbotPtr(a5)
		move.l	d3,EngineVerbotSize(a5)
		move.l	d0,a1

		* aus "'Dirlistviewer' 'Playerloader'"
		*     'Dirlistviewer' 'Playerloader' machen
		lea	TextPuffer(a5),a0
		move.b	(a0)+,d0
		cmp.b	#'"',d0
		beq.s	.Ja
		cmp.b	#"'",d0
		beq.s	.Ja
		cmp.b	#"`",d0
		bne.s	.Nein
.Ja		move.b	-4(a0,d3.w),d1
		cmp.b	d0,d1
		bne.s	.Nein
		subq.l	#2,d3
		bra.s	.Doch

.Nein:		lea	TextPuffer(a5),a0
.Doch:		move.l	d3,d1
		subq.l	#3,d1
		jsr	A5StringCopy2(a5)
.Return:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: -
* Output:d0=Error oder NULL
*-----------------------------------------------------------------------------*
EndEngineVerbot:movem.l	d0-a6,-(a7)
		move.l	EngineVerbotPtr(a5),d0
		beq.s	.Return
		move.l	d0,a1
		move.l	EngineVerbotSize(a5),d0
		jsr	A5FreeMem(a5)
.Return:	clr.l	EngineVerbotPtr(a5)
		clr.l	EngineVerbotSize(a5)
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input: a0=Enginename
* Output:d0=Error oder NULL
*-----------------------------------------------------------------------------*
CheckLoadVerbot:movem.l	d1-a6,-(a7)
		move.l	a4,d0
		beq.s	.Return
		move.l	EngineVerbotPtr(a5),a1

******************* Check auf Zeicherkette **********************
** INPUT:	a1 = Zeichenkette (mit Leerzeichen)		*
** OutPut	a1 = Start of next String			*
**		d0 = Start of String				*
**		d1 = Length of String				*
*****************************************************************
.Next:		move.l	a1,d0
		beq.s	.Return
		jsr	A5FindFileName(a5)
		move.l	d0,a0
		move.b	(a0,d1.w),d3		;Leerzeichen oder Kommas
		clr.b	(a0,d1.w)


		********************** Stringvergleich **************************
		**  Zeiger auf Quellwerte in a0,zu vergleichende Kette in a2   **
		**  Rckgabe: 2.Argument in A1 (wenn vorhanden,sonst 0         **
		**           in D0 Ergebnis,0=Ok,<>0 Fehler,Flags sind gesetzt **
		*****************************************************************
		move.l	d0,a0
		move.l	a4,a2
		movem.l	a1/d1/a0/d3,-(a7)
		jsr	A5StrCmp(a5)
		movem.l	(a7)+,a1/d1/a0/d3
		move.b	d3,(a0,d1.w)

		tst.l	d0
		bne.s	.Next
		moveq	#-1,d0
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*
*
*	;******************************************************
*	;**** Fge der Liste von UserProgrammen eine hinzu ****
*	;******************************************************
*AddEngine2:	lea	InfoBlock+8(a5),a0
*AddEngine3:	lea	EagleUser.MSG,a6
*		move.l	a0,d1
*
*	*---- Letztes Userprogramm finden Nicht verndern !!!!!!! -------*
*		lea	FirstEngine-EUS_Next(a5),a4	;weil MerkAdr -> 4(a4)
*		tst.l	LastEngine(a5)
*		beq.s	.First
*		move.l	LastEngine(a5),a4
*.First:		moveq	#EUS_Next,d4
*		jsr	A5LoadEngineSegment(a5)			;Engine geladen
*		beq.w	EUS_Return			;--> nein
*
*
*
***------ Ein neues Userprogramm starten, mu in Liste sein a4=EUS_Struct ------*
*InsertDebuggerEUS:lea	TextPuffer+300(a5),a3
*		move.l	a4,d3
*		move.b	EUS_Priority(a4),d2
*		ext.w	d2
*		ext.l	d2
*		asr.l	#2,d3
*		subq.l	#1,d3
*		move.l	d3,d6
*		move.l	#500,d4
*		add.l	EUS_UnUsed1(a4),d4	;ist doch mal anders fr
*						;registrierte User
*		lea	FirstEngine(a5),a0
*		tst.b	KeyOn-FirstEngine(a0)
*		bne.s	.LoadAll
*
*	;* Testen, ob es sich irgendwie um eine registrierte Version handelt *
*	;	tst.w	EUS_Flags(a4)
*	;	beq.w	.ClearSegment
*
*		tst.l	EUS_Unused1(a4)
*		bne.w	.ClearSegment
*		tst.l	EUS_Unused2(a4)
*		bne.w	.ClearSegment
*		cmp.w	#UPrg_Debugger,EUS_UserNr(a4)
*		beq.s	.Debugger
*		tst.l	EUS_EPBase(a4)
*		bne.w	.ClearSegment
*.Debugger:	tst.l	EUS_Next(a4)
*		bne.w	.ClearSegment
*		;tst.b	EUS_Reserved1(a4)		;ist jetzt EUS_Type
*		;bne.w	.ClearSegment			;ist jetzt EUS_Type
*		tst.w	EUS_Reserved2(a4)
*		bne.w	.ClearSegment
*		tst.l	EUS_Reserved3(a4)
*		bne.w	.ClearSegment
*		tst.l	EUS_Reserved4(a4)
*		bne.w	.ClearSegment
*
*		move.l	EUS_Creator(a4),a0
*.FindCEnd:	tst.b	(a0)+
*		bne.s	.FindCEnd
*		cmp.b	#$ed,(a0)
*		beq.w	.ClearSegment
*		cmp.b	#$ce,(a0)
*		beq.w	.ClearSegment
*		cmp.b	#$af,(a0)
*		beq.w	.ClearSegment
*		cmp.b	#$00,(a0)
*		beq.w	.ClearSegment
*
*	*----- Normal das UserProgramm in die Liste einfgen -----*
*	*--------------- Freie Usernummer finden -----------------*
*.LoadAll:	move.l	BatchUserNr(a5),d0
*
*
*	*----- Normal das UserProgramm in die Liste einfgen -----*
*	*--------------- Freie Usernummer finden -----------------*
*		move.l	BatchUserNr(a5),d0
*		bne.s	.NummerDa
*		jsr	A5FindFreeUserNr(a5)
*		beq.w	.ClearSegment
*.NummerDa:	move.l	d0,d1
*
*		move.l	EUS_PName(a4),a0
*		jsr	A5KeyTestAufEngine(a5)	;gleichzeitig Test auf Key
*	;	jsr	A5BerechStringSize(a5)
*		move.b	d1,-1(a0,d0.l)
*		add.b	#"0",-1(a0,d0.l)	;Tasknamen korrigieren !!!
*
*
*		move.l	a5,EUS_EPBase(a4)
*		clr.l	EUS_FreeTable(a4)
*		clr.w	EUS_TickCounter(a4)
*		clr.l	EUS_UnUsed1(a4)
*		clr.l	EUS_UnUsed2(a4)
*
*		move.w	EUS_UserNr(a4),d0
*		move.w	d1,EUS_UserNr(a4)	;Nummer -> Structure
*		cmp.w	#UPrg_Debugger,d0
*		beq.s	.NoCreate
*
*	*--------- Fr Taguser-Prgs keine CreateProc ---------*
*	* 
*		tst.l	(a4)
*		beq.s	.TagUser
*		cmp.l	#TagUserID,(a4)
*		bne.s	.TaskUser
*.TagUser:	move.l	#EUT_InitEngine,d0
*		move.l	EUS_TagList(a4),a6
*		moveq	#-1,d3		;Error fr d0
*		jsr	A5CallUp3(a5)
*		beq.s	.NoInitUPrg	;Tag nicht gefunden -> nicht ntig
*		tst.l	d0
*		bne.s	.ClearSegment
*
*	*------------- Versionsnummern updaten --------------*
*.NoInitUPrg:	move.l	#EUT_UpdateVer,d0
*		move.l	EUS_TagList(a4),a6
*		LA0	LNr_EPVersion
*		jsr	A5CallUp3(a5)
*		bra.s	.NoCreate
*
*
*	*---------- Prozess fr TaskUser starten ------------*
*.TaskUser:	move.l	EUS_PName(a4),d1
*	;	move.l	DTG_Dosbase(a5),a6
*		move.l	DTG_Dosbase-(TextPuffer+300)(a3),a6
*		jsr	_LVOCreateProc(a6)
*		tst.l	d0
*		beq.s	.ClearSegment
*
*.NoCreate:	move.l	a4,LastEngine(a5)		;Engine merken
*		rts
*
*	*------ Segment lschen , weil nicht gestartet ------*
*.ClearSegment:	cmp.w	#UPrg_Debugger,EUS_UserNr(a4)
*		beq.s	.NoSegment
*		move.l	d6,d1
*		beq.s	.NoSegment
*		move.l	DTG_Dosbase-(TextPuffer+300)(a3),a6
*		jsr	_LVOUnLoadSeg(a6)
*.NoSegment:	move.l	OldLoadAdr(a5),a4
*		clr.l	EUS_Next(a4)
*EUS_Return:	moveq	#0,d0
*		rts
*


**---------------------------------------------------------------------------*
**-------------------- Set Engine Namen ins Pull-Down-Menu -----------------*
**---------------------------------------------------------------------------*
*UserBatchName:	moveq	#UPrgB_BatchName,d1
*		sub.l	a4,a4
*		jsr	A5FindFreeUserNr(a5)
*		beq.w	SetNowUserReturn
*		move.l	d0,d2
*		bra.s	SetNowUserName
*
*EngineSetName:	moveq	#UPrgB_Engine,d1
*		moveq	#0,d2
*		move.w	EUS_UserNr(a4),d2
*		move.l	EUS_UserName(a4),a1
*
*


;*------------ Userprogramm rauswerfen / a4=Pointer auf Engine ------------*
;EjectEngine:	moveq	#0,d0
;		cmp.l	a4,d0
;		beq.s	.NoEngine
;
;.NoEngine:	moveq	#EPR_ErrorInArguments,d0
;		rts
;

*---------------------------------------------------------------------------*
*------------------------ XPK-CrunchMode festlegen -------------------------*
XPKCruncher:	lea	XPK_CrunchMode(a5),a0
		move.l	A0,ScrollArgs(a5)
		LA0	LNr_XPKCrunchMode
		lea	TextPuffer(a5),a0
		move.w	#LNr_XPKCrunchMode,d0
		jmp	A5ScrollNew(a5)


*-------------------------- Set Save-Directory -----------------------------*
SetInstrumentsDir1:	jmp	SetInstrumentsDir

SetSaveDir:	LA0	LNr_SW_SaveDir
		jsr	A5PrintText(a5)

		tst.l	d2
		beq.s	.FileRequest
		move.l	a2,a1
		move.l	d2,d3
		subq.l	#1,d3
		lea	SaveDirPuffer(a5),a0	;A0=Wohin mit Players.
		jsr	A5CreateDirAusPath(a5)	;A1=Path d3=Lnge
		bra.s	.Ok

.FileRequest:	LA0	LNr_Fr_SaveDir
		lea	SaveDirPuffer(a5),a1
		sub.l	a2,a2
		jsr	A5GetMainWindowHandle(a5)
		move.l	d0,a3				;-> WinHandle
		moveq	#1,d0				;Kennung Dir selcten
		jsr	A5FileRequest2(a5)
		bne.w	ScrollNewFehler
.Ok:		moveq	#LNr_SaveDirOK,d0
		jmp	A5ScrollNew(a5)



*--------------------------------------------------------------------------*
*--------------------------------------------------------------------------*
*--------------------------------------------------------------------------*
SaveModulePrefs:moveq	#EPR_NotImplemented,d0
		jmp	A5ScrollNewFehler(a5)

*--------------------------------------------------------------------------*
*--------------------------------------------------------------------------*
*--------------------------------------------------------------------------*
SaveModule:	moveq	#EPR_SaveError,d0
		tst.l	PlayerAdr(a5)
		beq.w	ScrollNewFehler

		lea	TextPuffer(a5),a0
		tst.b	KeyOn-TextPuffer(a0)
		bne.s	.KeyDa
		move.w	#LNr_TR_RegisteredSaveModule,d0
		jsr	A5NervRequest2(a5)
		bra.w	FunktionNotEnabled
.KeyDa:

KEY_SaveModule_TBA53:
KeyBeq5:
		tst.b	KeyOn(a5)
		beq.w	FunctionNotImplemented			;.w lassen !
		jsr	A5WaitMouse(a5)
		LA0	LNr_SW_SaveModule
		jsr	A5PrintText(a5)

		tst.l	d2
		beq.s	.FileReq

	*----------- Filename wurde angegeben -------*
		move.l	a2,a1
		move.l	d2,d3
		subq.l	#1,d3
		lea	SaveDirPuffer(a5),a0	;A0=Wohin mit Players.
		jsr	A5CreateDirAusPath(a5)	;A1=Path d3=Lnge
		move.l	a0,a1
		lea	SaveFilePuffer(a5),a0
		jsr	A5CopyFileName(a5)
		bra.w	SaveIt




	*-------------- Save-Dir festlegen --------------*
.FileReq:	clr.l	SSDirAdr(a5)
		tst.b	OnSSDir(a5)
		beq.s	.NoSSDir1
		lea	SaveDirPuffer(a5),a1
		tst.b	(a1)
		beq.s	.NoSetSchr
.FindDirEnd:	tst.b	(a1)+
		bne.s	.FindDirEnd
		subq.l	#1,a1
		cmp.b	#":",-1(a1)
		beq.s	.NoSetSchr
		cmp.b	#"/",-1(a1)
		beq.s	.NoSetSchr
		move.b	#"/",(a1)+
.NoSetSchr:	move.l	a1,SSDirAdr(a5)
		move.l	#DTP_PlayerName,d0
		jsr	A5FindTag(a5)
		beq.s	.NoSSDir1
		move.l	a6,a0
		moveq	#Namenlange-2,d1
		jsr	A5StringCopy2(a5)		;an SaveDir ranhngen

	*------ Namen durchtesten (auf ":" und "/" ------*
		move.l	SSDirAdr(a5),a0
.TestNextDB:	addq.l	#1,a0
		tst.b	(a0)
		beq.s	.NoSSDir1
		cmp.b	#":",(a0)
		beq.s	.SetToUStr
		cmp.b	#"/",(a0)
		bne.s	.TestNextDB
.SetToUStr:	move.b	#"_",(a0)
		bra.s	.TestNextDB

	*-------- Namen des Save-Files festlegen --------*
.NoSSDir1:	lea	TitlenamePuffer(a5),a4
		lea	SaveFilePuffer(a5),a1

		tst.b	OnUseSongname(a5)
		beq.s	.NoUseSong
		move.l	GetInfoAdr(a5),a6
		move.l	#MI_Songname,d0
		jsr	A5FindTag2(a5)
		beq.s	.NoUseSong
		move.l	a6,a4

.NoUseSong:	tst.b	OnUsePrefix(a5)
		beq.w	.NoPrefix

		move.l	GetInfoAdr(a5),a6
		move.l	#MI_Prefix,d0
		jsr	A5FindTag2(a5)
		beq.s	.NoPrefix
		move.l	a6,a0
		cmp.b	#".",(a0)
		bne.s	.AmAnfang
		move.l	a4,a0
		jsr	A5BerechStringSize(a5)
		lea	(a4,d0.w),a0
		subq.l	#1,d0
		blt.s	.AmAnfang
.AmEnde_1:	cmp.b	#".",-(a0)
		beq.s	.AmEnde_2
		dbf	d0,.AmEnde_1
		move.l	a4,a0				*ganzen Namen
		jsr	A5BerechStringSize(a5)
.AmEnde_2:	move.l	a4,a0
		lea	SaveFilePuffer(a5),a1
		move.w	d0,d1
		subq.w	#1,d1
		jsr	A5StringCopy2(a5)
		move.l	a6,a0
		jsr	A5StringCopy(a5)
		bra.s	.NoName



.AmAnfang:	move.l	a4,a0
		jsr	A5StringCopy(a5)

		moveq	#Namenlange-2,d0	;File ohne Prefix kopieren
		sub.w	d1,d0
		move.l	d0,d1
		subq.l	#1,d1
		move.l	a4,a0
		lea	TextPuffer(a5),a1
		jsr	A5Stringcopy2(a5)
		clr.b	(a1)

		lea	TextPuffer(a5),a2
		lea	SaveFilePuffer(a5),a0
		jsr	A5StrCmp(a5)
		lea	SaveFilePuffer(a5),a1
		beq.s	.NoPrefix
.FindPrEnd:	tst.b	(a1)+
		bne.s	.FindPrEnd
		subq.l	#1,a1

.NoPrefix:	move.l	a4,d0				;NoSongName
		beq.s	.NoName
		move.l	d0,a0
		moveq	#Namenlange-2,d1
		jsr	A5StringCopy2(a5)

	;**** a0 = FileRequester-Title		    ****
	;**** a1 = Directorypath		    ****
	;**** a2 = Filename	 		    ****
	;**** a3 = Window	 		    ****
	;**** d0 = 1  SelectDir			    ****
	;****	   0  SelectFile		    ****
.NoName:	tst.b	OnAutomaticSave(a5)
		bne.s	SaveIt
		LA0	LNr_Fr_SaveModule		;TitleName
		lea	SaveDirPuffer(a5),a1		;Dir-Ptr

*----------------------------------------------------------------------*
		move.b	KeyOn-SaveDirPuffer(a1),d1
KEY_SaveModule_TBA14:
		beq.w	DeleteFile
*----------------------------------------------------------------------*


		lea	SaveFilePuffer(a5),a2		;Keine Filename
		jsr	A5GetMainWindowHandle(a5)
		move.l	d0,a3				;-> WinHandle
		moveq	#0,d0				;Kennung File Saven
		jsr	A5FileRequest2(a5)
		beq.w	SaveIt
		move.l	SSDirAdr(A5),d1
		beq.w	ScrollNewFehler
		move.l	d1,a0
		clr.b	(a0)
		bra.w	ScrollNewFehler


	*---- Erstmal testen, ob Directory existiert ---*
SaveIt:		lea	SaveFilePuffer(a5),a0
		move.l	a0,DTG_FileArrayPtr(a5)
		lea	SaveDirPuffer(a5),a0
		move.l	a0,DTG_DirArrayPtr(a5)
		move.l	a0,d1
		move.l	DTG_Dosbase(a5),a6
		moveq	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,-(a7)
		tst.l	d0
		bne.s	.FreeDirLock


	*------------ Verzeichnis erzeugen -------------*
		lea	SaveDirPuffer(a5),a0
		jsr	A5BerechStringSize(a5)
		cmp.b	#"/",-1(a0,d0.w)
		bne.s	.NoSchr
		clr.b	-1(a0,d0.w)
.NoSchr:	move.l	a0,d1
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOCreateDir(a6)
		move.l	d0,d1
		beq.s	.FreeDirLock
		jsr	_LVOUnLock(a6)

.FreeDirLock:	move.l	(a7)+,d1
		tst.l	d1
		beq.s	.NoDirLock

		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOUnLock(a6)



	*--- Mu getestet werden, ob File existiert ----*
.NoDirLock:	moveq	#0,d7

Keybeq6
		tst.b	KeyOn(a5)
		beq.w	WriteError			;.w lassen !
		bsr.w	CopySaveDir
		bsr.w	CopySaveFile




	*--------- Fragen, ob als nichtprotracker saven ---------*
		tst.b	OnSaveAsProT(a5)
		beq.w	.NoPTSave
		move.l	#EP_SaveAsPT,d0
		jsr	A5FindTag(a5)
		bne.s	.NoPTSave
		LA0	LNr_TR_SaveAsPT
		move.l	a0,EPG_Arg1(a5)
		lea	PubScreenName(a5),a0
		move.l	a0,EPG_Arg2(a5)
		clr.l	EPG_Arg3(a5)
		subq.l	#1,EPG_Arg3(a5)
		LA0	LNr_GA_Yes
		move.l	a0,EPG_Arg4(a5)
		clr.l	EPG_Arg5(a5)
		move.l	#DTP_PlayerName,d0
		jsr	A5FindTag(a5)
		move.l	a6,a1
		lea	TextRequestArgs(a5),a0
		move.l	a1,4(a0)
		lea	SaveFilePuffer(a5),a1
		move.l	a1,(a0)
		move.l	a0,EPG_Arg6(a5)
		moveq	#-1,d0
		move.l	d0,EPG_Arg7(a5)
		moveq	#7,d0
		move.l	d0,EPG_ArgN(a5)
		clr.l	EPG_Arg8(a5)
		jsr	A5TextRequest(a5)
		moveq	#EPR_Functionaborted,d0
		move.l	EPG_Arg1(a5),d1
		subq.l	#1,d1
		bne.w	ScrollNewFehler




	*-------------------- Test auf Overwrite --------------------*
.NoPTSave:	tst.b	OnOverWrite(a5)
		bne.s	.ReplaceIt

	*--------- Existiert das file bereits ----------*
		lea	PathPuffer(a5),a0
		move.l	a0,d1
		moveq	#-2,d2
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.w	.ReplaceIt
		jsr	_LVOUnlock(a6)

	*------ Gadget-Abfrage "Overwrite file ?" ------*
		LA0	LNr_TR_Overwrite
		move.l	a0,EPG_Arg1(a5)
		lea	PubScreenName(a5),a0
		move.l	a0,EPG_Arg2(a5)
		clr.l	EPG_Arg3(a5)
		subq.l	#1,EPG_Arg3(a5)
		LA0	LNr_GA_Yes
		move.l	a0,EPG_Arg4(a5)
		clr.l	EPG_Arg5(a5)
		lea	SaveFilePuffer(a5),a1
		lea	TextRequestArgs(a5),a0
		move.l	a1,(a0)
		move.l	a0,EPG_Arg6(a5)
		moveq	#-1,d0
		move.l	d0,EPG_Arg7(a5)
		moveq	#7,d0
		move.l	d0,EPG_ArgN(a5)
		clr.l	EPG_Arg8(a5)
		jsr	A5Textrequest(a5)
		moveq	#EPR_Functionaborted,d0
		move.l	EPG_Arg1(a5),d1
		subq.l	#1,d1
		bne.w	ScrollNewFehler

	*---------------- File wird ersetzt ----------------*
.ReplaceIt:	lea	SaveDirPuffer(a5),a1		;Dir-Ptr
		lea	SaveFilePuffer(a5),a2		;Keine Filename
		move.l	a1,EPG_Arg1(a5)
		move.l	a2,EPG_Arg2(a5)
		clr.l	EPG_Arg4(a5)
		moveq	#4,d0
		move.l	d0,EPG_ArgN(a5)			;CrunchMode


		move.l	#EP_Save,d0
		tst.b	OnSaveAsProT(a5)
		beq.s	.NormalNoPT
		move.l	#EP_SaveAsPT,d0
.NormalNoPt:	jsr	A5CallUp(a5)			;d2=1, wenn gefunden
		bne.w	.SaveOk				;d0<>0 --=>Fehler

*------------------- Interne Save-Routine benutzen ------------------------*
*----------------- Testen, ob calcsize angegeben wird ---------------------*
		move.l	#EP_Flags,d0
		jsr	A5FindTag(a5)
		moveq	#EPR_SaveError,d0
		tst.l	d2				;keine Flags ???
		beq.w	.SaveOk				;nein --> Fehler
		move.l	a6,d1
		btst	#EPF_Save,d1
		beq.s	.SaveOk

		move.l	#EP_ModuleRestore,d0
		jsr	A5FindTag(a5)
		beq.s	.NoStopInt

		move.b	PlayOn(a5),SavePlayOn(a5)

		jsr	A5StopInterrupt(a5)
		move.l	#EP_ModuleRestore,d0
		jsr	A5CallUp(a5)

	*------------ Save-Size laden ------------*
.NoStopInt:	move.l	GetInfoAdr(a5),d0
		beq.s	.NoInfoAdr
		move.l	d0,a6
		move.l	#MI_calcsize,d0
		jsr	A5Findtag2(a5)
		beq.s	.NoInfoAdr
		move.l	a6,d3
		bra.b	.UseCalcSize

.NoInfoAdr:	move.l	MDPuffer+4(a5),d3		;--> Size laden
.UseCalcSize:	move.l	MDPuffer(a5),EPG_Arg1(a5)
		move.l	d3,EPG_Arg2(a5)
		move.l	DTG_PathArrayPtr(a5),EPG_Arg3(a5)
		clr.l	EPG_Arg4(a5)
		subq.l	#1,EPG_Arg4(a5)
		clr.l	EPG_Arg5(a5)
		moveq	#5,d0
		move.l	d0,EPG_ArgN(a5)			;CrunchMode
		move.l	EPG_SaveMem(a5),a0
		jsr	(a0)


		move.l	d0,-(a7)
		move.l	#EP_ModuleChange,d0
		jsr	A5CallUp(a5)
		tst.b	SavePlayOn(a5)
		beq.s	.HoleD0VomStack
		jsr	A5StartInterrupt(a5)
.Holed0VomStack:move.l	(a7)+,d0


	*------------- Wurde das Saven erfolgreich beendet ? --------------*
.SaveOk:	move.l	d0,-(a7)
		move.l	SSDirAdr(a5),d0
		beq.s	.SaveOk_NoSSDir
		move.l	d0,a0
		clr.b	(a0)				;Dir zurcksetzen
.SaveOk_NoSSDir:tst.w	Kick2On(a5)
		beq.s	.LoadDirJa
		tst.b	OnNotify(a5)
		bne.s	.NoDirWeilNotify
.LoadDirJa:	jsr	A5LoadDirIn(a5)
.NoDirWeilNotify:move.l	(a7)+,d0
		tst.l	d0
		bne.w	ScrollNewFehler

		LA0	LNr_SaveOk
		jmp	A5ScrollNewText(a5)


*------------------- Sperre den ausgewhlten Player ---------------------*
* d2=Nummer des Players
* d3=Zustand
PlayerZustand:	move.l	d2,d0				;Nummer
		move.l	d2,d5
		jsr	A5FindPlayerStruct(a5)
		bne.w	.Error
	

		*---- Engines benachrichten ---*
		moveq	#USClass_RemPlayerList,d0
		jsr	A5SendeAllMessage(a5)

		move.l	a0,a4
.WiederDisablen:move.w	EPPl_Flags(a4),d4
		tst.l	d3
		bge.s	.NoToggle
		moveq	#0,d3				*Diabled
		btst	#EPPLF_Enabled,d4
		bne.s	.NoToggle
		moveq	#1,d3		

		*-- Nun testen, ob Player in dem genannten Zustand --*
.NoToggle:	tst.l	d3
		bne.w	.EnableIt


		*-- Der Player wird disabled --*
		tst.b	OnEjectPlayer(a5)
		beq.s	.NichtQuitten
		tst.l	EPPL_Taglist(a4)
		bne.s	.Quitten
.NichtQuitten:	btst	#EPPLF_Enabled,d4
		beq.w	.NoChange

		*-- Der Player wird disabled --*
		tst.b	OnEjectPlayer(a5)
		beq.s	.NormalDisable
.Quitten:	move.l	a4,a0
		move.b	#1,NurDisablen(a5)
		jsr	A5DeletePlayer2(a5)
		clr.b	NurDisablen(a5)
		LA3	LNr_Disabled
		bclr	#EPPLF_Enabled,d4
		bra.w	.ZustandNeu

.NormalDisable:

* a4=Adr des Players EPPL_Taglist Taglist
*    bei Customplayer=CU_Tagliste
* Playeradr=Adr der Tagliste 

		move.l	PlayerAdr(a5),a6
		move.l	#DTP_Customplayer,d0
		jsr	A5FindTag2(a5)
		beq.w	.NoCustomSong

		move.l	EPPL_Taglist(a4),d0
		cmp.l	#CU_Tagliste,d0
		bne.s	.NoCustomSong
		bra.s	.ClearCustom

.NoCustomSong:	move.l	EPPl_TagList(a4),d0
		beq.s	.NoThis
		cmp.l	PlayerAdr(a5),d0
		bne.s	.NoThis
.ClearCustom:	jsr	A5WaitMouse(a5)
		jsr	A5AllesRaus(a5)
		jsr	A5GuiChanged(a5)
.NoThis:	bclr	#EPPLf_Enabled,d4
		LA3	LNr_Disabled
		bra.w	.ZustandNeu

.EnableIt:	btst	#EPPLF_Enabled,d4
		bne.w	.NoChange


		*--- Mu der Player noch geladen werden ---*
		tst.l	EPPl_TagList(a4)
		bne.s	.SchonDa
		lea	EPPl_PlayerName(a4),a0
		lea	PathPuffer(a5),a1
		move.w	#PathPufferSize-2,d1
		jsr	A5StringCopy2(a5)
		lea	PathPuffer(a5),a1
		jsr	A5GetFileName(a5)
		cmp.b	#"(",(a1)
		bne.s	.NoKlammer
		lea	1(a1),a0
		jsr	A5StringCopy(a5)
		clr.b	-1(a1)
.NoKlammer:	lea	PathPuffer(a5),a0
		move.l	a0,a2
		jsr	A5BerechStringSize(a5)
		move.l	d0,d2
		subq.l	#1,d2
		blt.s	.NoChange
		move.l	d5,-(a7)
		bsr	AddPlayer
		move.l	(a7)+,d5
		tst.l	d0
		bne.s	.Error
		move.l	d5,d0				;Nummer
		jsr	A5FindPlayerStruct(a5)
		bne.w	.Error
		LA3	LNr_Enabled
		move.l	a0,a4
		lea	TextPuffer(a5),a0
		jsr	A5GetPlayerName(a5)
		bra.s	.NoChange


.SchonDa:	LA3	LNr_Enabled
		bset	#EPPLF_Enabled,d4
.ZuStandNeu:	move.w	d4,EPPl_Flags(a4)

		*-- Namen wieder zusammensetzen --*
		lea	TextPuffer(a5),a0
		jsr	A5GetPlayerName(a5)
		tst.l	d3
		bne.s	.NoDisabled
		move.b	#"(",(a1)+
.NoDisabled:	moveq	#Namenlange,d1
		jsr	A5StringCopy2(a5)
		tst.l	d3
		bne.s	.NoDisabled2
		move.b	#")",(a1)+
.NoDisabled2:	clr.b	(a1)




*		move.l	#DTP_PlayerName,d0
*		move.l	EPPl_TagList(a4),a6
*		jsr	A5FindTag2(a5)
*		lea	EPPl_PlayerName(a4),a1
*		tst.l	d3
*		bne.s	.NoDisabled
*		move.b	#"(",(a1)+
*.NoDisabled:	move.l	a6,a0
*		move.l	EPPl_Size(a4),d1		*Bei internen Player
*		bne.s	.NoIntern			*keine Sizeangabe
*		moveq	#EPPl_Size+Namenlange+4,d1
*.NoIntern:	sub.l	#EPPl_SizeOf-5,d1
*		jsr	A5StringCopy2(a5)
*		tst.l	d3
*		bne.s	.NoDisabled2
*		move.b	#")",(a1)+
*.NoDisabled2:	clr.b	(a1)



		*------ Engines benachrichten -----*
.NoChange:	moveq	#USClass_NewPlayer,d0
		jsr	A5SendeAllMessage(a5)

		lea	TextPuffer(a5),a0
		jsr	A5GetPlayerName(a5)
		move.l	a0,ScrollArgs(a5)
		move.l	a3,a0
		jmp	A5ScrollNewText(a5)


		*--- es ist ein Fehler in den Argumenten ---*
.Error:		*moveq	#EPR_CommandError,d0
ConfigFehler:	jmp	A5ScrollNewFehler(a5)


*-------------------------------------------------------------------------*
* Input: a0=Wohin der name soll
*	 a4=EPPL_Struct
* Output: A0 = TextPuffer = Playername
*	  a1 = Start nach Dirname
GetPlayerName:	movem.l	a2/d0/d1,-(a7)
		move.l	a0,-(a7)
		lea	EPPl_PlayerName(a4),a1
		jsr	A5GetFileName(a5)
		move.l	a1,a2
		cmp.b	#"(",(a1)
		bne.s	.A1Ok
		addq.l	#1,a1
.A1Ok:		move.l	a1,a0
		move.l	(a7),a1
		jsr	A5Stringcopy(a5)
		cmp.b	#")",-1(a1)
		bne.s	.NoKlammer
		clr.b	-1(a1)
.NoKlammer:	move.l	(a7)+,a0
		move.l	a2,a1
		movem.l	(a7)+,a2/d0/d1
		rts


*-------------------- Lade eine Player-Konfiguration ---------------------*
* d2=Nummer des Players
PlayerConfig:	move.l	d2,d0
		jsr	A5FindPlayerStruct(a5)
		bne.w	.Return
		jsr	A5WaitMouse(a5)
		move.l	EPPl_TagList(a0),a6
		move.l	#DTP_UserConfig,d0
		jsr	A5CallUp3(a5)
		beq.w	FunctionNotImplemented
		LA0	LNr_OperationSuccesful
		tst.l	d0
		bne.s	ConfigFehler
		jsr	A5ScrollNewText(a5)
		moveq	#0,d0
.Return:	rts


*-------------------- Lade eine Player-Konfiguration ---------------------*
* d2=Nummer des Players
LoadPlayerConfig:
		move.l	d2,d0
		jsr	A5FindPlayerStruct(a5)
		bne.w	.Return
		jsr	A5WaitMouse(a5)
		move.l	EPPl_TagList(a0),a6
		move.l	#EP_LoadPlConfig,d0
		jsr	A5CallUp3(a5)
		beq.w	FunctionNotImplemented
		moveq	#0,d0
.Return:	rts

*-------------------- Lade eine Player-Konfiguration ---------------------*
* d2=Nummer des Players
SavePlayerConfig:
		move.l	d2,d0
		jsr	A5FindPlayerStruct(a5)
		bne.w	.Return
		jsr	A5WaitMouse(a5)
		move.l	EPPl_TagList(a0),a6
		move.l	#EP_SavePlConfig,d0
		jsr	A5CallUp3(a5)
		beq.w	FunctionNotImplemented
		moveq	#0,d0
.Return:	rts


	*------------- Verschlsselung 2 von Struct 2 aufheben -----------*
DecodeStruct2:	lea	TextPuffer+1700(a5),a3
		move.l	Key_Struct-(TextPuffer+1700)(a3),d0
		beq.s	.Ok
		move.l	d0,a4
		move.b	EPKF_V2DecodeK(a4),Code-(TextPuffer+1700)(a3)
		move.b	EPKF_V2Decode1(a4),CodePara1(a5)
		move.b	EPKF_V2Decode2(a4),CodePara2(a5)
		move.b	EPKF_V2Decode3(a4),CodePara3-(TextPuffer+1700)(a3)
		move.b	EPKF_V2Decode4(a4),CodePara4-(TextPuffer+1700)(a3)
		move.l	Key_Struct-(TextPuffer+1700)(a3),a4
		lea	EPKF_OrtChk(a4),a0
		moveq	#EPKF_V2ChkSum-EPKF_OrtChk,d0
		lea	SaveModule(pc),a2
		lea	DecodeAndChkSum-SaveModule(a2),a2
		jsr	(a2)
		cmp.w	EPKF_V2ChkSum(a4),d0
		beq.w	.Ok
		clr.l	KeyFault-(TextPuffer+1700)(a3)
.Ok		rts


*------------------ Suche Player in Liste (d0=PlayerNummer) ------------------*
* Input: d0=Nummer de Players in der Liste
* Output:d0=Error oder NULL
*	 a0=PlayerStructure
*-----------------------------------------------------------------------------*
FindPlayerStruct:
		movem.l	d1/d7/a1,-(a7)
		moveq	#EPR_ErrorInArguments,d7
		sub.l	a0,a0
		subq.l	#1,d0
		blt.s	.Error
		lea	EPG_FirstPlayerStruct(a5),a1
.Such2:		move.l	(a1),d1
		beq.w	.Error
		move.l	d1,a1
		dbf	d0,.Such2
		move.l	a1,a0
		moveq	#0,d7
.Error:		move.l	d7,d0
		movem.l	(a7)+,d1/d7/a1
		tst.l	d0
		rts

*------------------- Suche Player in Liste (d0=TagListe) ---------------------*
* Input: d0=TagListe
* Output:d0=Error oder NULL
*	 a0=PlayerStructure
*-----------------------------------------------------------------------------*
FindPlayerStruct2:
		movem.l	d1/d7/a1,-(a7)
		moveq	#EPR_ErrorInArguments,d7
		sub.l	a0,a0
		lea	EPG_FirstPlayerStruct(a5),a1
.Such2:		move.l	(a1),d1
		move.l	d1,a1
		beq.w	.Error
		cmp.l	EPPl_TagList(a1),d0
		bne.s	.Such2
		move.l	a1,a0
		moveq	#0,d7
.Error:		move.l	d7,d0
		movem.l	(a7)+,d1/d7/a1
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Es wird nachgeguckt, ob alle TaskUser noch valid sind.
UpdateMyPlayerList:
		lea	EPG_FirstPlayerStruct(a5),a4
.NextPlayer:	move.l	(a4),d0
.NextPlayer2:	beq.s	.Return
		move.l	d0,a4
		tst.l	EPPl_TaskAdr(a4)
		beq.s	.NextPlayer
		move.l	EPPl_Node+LN_Name(a4),a1
		Execbase
		jsr	_LVOFindTask(a6)
		tst.l	d0
		bne.s	.NextPlayer
		move.l	a4,a0
		move.l	(a4),-(a7)
		bsr	DeletePlayer2
		move.l	(a7)+,d0
		tst.l	d0
		bra.s	.NextPlayer2
.Return:	clr.l	UpdatePlayerList(a5)
		jmp	A5Warten(a5)

*---------------------- ausgewhlten Player lschen ----------------------*
DeletePlayer:	move.l	d2,d0
		jsr	A5FindPlayerStruct(a5)
		move.b	#1,KillAllPlayer(a5)
		bsr	DeletePlayer2
		clr.b	KillAllPlayer(a5)
		rts

DeletePlayer2:	movem.l	d1-a6,-(a7)			*A0=PlayerStruct
		moveq	#EPR_CantDeletingPlayer,d7
		move.l	a0,a4
		move.l	a0,d0
		beq.w	.Error

		*tst.l	EPPl_Segment(a4)		;Weil batchplayer
		*beq.s	.Error

		move.l	EPPl_TagList(a4),a6
		move.l	#DTP_InternalPlayer,d0
		jsr	A5FindTag2(a5)
		bne.w	.Error

		*-- Spielt dieser Player gerade --*
		move.l	EPPl_TagList(a4),d0
		cmp.l	PlayerAdr(a5),d0		;durch rausnehmen
		bne.s	.NoThisPlayer			;des Players
		tst.b	DelAllOther(a5)
		bne.s	.Return
		*bne.s	.NoThisPlayer
		movem.l	d0-a6,-(a7)
		jsr	A5WaitMouse(a5)
		jsr	A5AllesRaus(a5)
		jsr	A5GuiChanged(a5)
		movem.l	(a7)+,d0-a6


		*---- Engines benachrichten ----*
.NoThisPlayer:	tst.b	NurDisablen(a5)		;Wenn Player durch disablen
		bne.s	.NurDis1		;entfernt wird -> kein MSG
		moveq	#USClass_RemPlayerList,d0
		jsr	A5SendeAllMessage(a5)

		lea	TextPuffer(a5),a0
		move.l	a0,ScrollArgs(a5)
		jsr	A5GetPlayerName(a5)
		LA0	LNr_Deleted
		jsr	A5ScrollNewText(a5)

.NurDis1:	bsr	FreeThisPlayer

		*---- Engines benachrichten ----*
		tst.b	NurDisablen(a5)
		bne.s	.KeinError

		tst.b	TypeDelPlayer(a5)
		bne.s	.KeinError

		moveq	#USClass_NewPlayer,d0
		jsr	A5SendeAllMessage(a5)

.KeinError:	moveq	#0,d7
.Return:	move.l	d7,d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

		*---- Engines benachrichten ----*
.Error:		tst.b	TypeDelPlayer(a5)
		bne.s	.KeinError2

		moveq	#USClass_NewPlayer,d0
		jsr	A5SendeAllMessage(a5)

.KeinError2:	move.l	d7,d0
		jsr	A5ScrollNewFehler(a5)
		bra.s	.Return

*--------------------------- Delete All Players --------------------------*
DeleteAllPlayers:
		clr.l	LoadNameAdr(a5)
		clr.b	DelAllOther(a5)
		move.b	#1,KillAllPlayer(a5)
		bsr	DeleteAll2
		clr.b	KillAllPlayer(a5)
		rts

DeleteAll2:	tst.l	PlayerAdr(a5)			;durch rausnehmen
		beq.s	.NoPlayer			;des Players
		move.l	#DTP_InternalPlayer,d0
		jsr	A5FindTag(a5)
		bne.s	.NoPlayer
		tst.b	DelAllOther(a5)
		bne.s	.NoPlayer
		jsr	A5WaitMouse(a5)
		jsr	A5AllesRaus(a5)
		jsr	A5GuiChanged(a5)
.NoPlayer:	jsr	A5FreePlayers(a5)

		moveq	#LNr_DeleteAllPlayer,d0
		jmp	A5ScrollNew(a5)


*------------------------ Playerliste mit Nodes fllen -----------------------*
* Setzt die internen Player alleine in die Playerliste.
FirstPlayerInit:movem.l	d0-a6,-(a7)

		lea	EPG_FirstPlayerStruct(a5),a4
		lea	PlayerList(a5),a0
		move.l	a0,EPG_PlayerList(a5)
		Newlist a0
		lea	FirstInternal,a3
		lea	InternPlayersStructs(a5),a2
		moveq	#AnzInternalPlayers-1,d1
.MakePlayerList:move.l	a2,(a4)
		clr.l	(a2)
		lea	PlayerList(a5),a0
		lea	EPPl_Node(a2),a1
		addtail
		move.l	12(a3),a6
		move.l	a6,EPPl_TagList(a2)
		move.l	#DTP_PlayerName,d0
		jsr	A5FindTag2(a5)

		or.w	#EPPLB_Enabled,EPPl_Flags(a2)
		lea	EPPl_PlayerName(a2),a1
		move.l	a1,EPPl_Node+LN_Name(a2)
		tst.w	4(a3)
		bne.s	.StateOn1
		clr.w	EPPl_Flags(a2)
		move.b	#"(",(a1)+
.StateOn1:	move.l	a6,a0
		jsr	A5StringCopy(a5)
		tst.w	4(a3)
		bne.s	.StateOn2
		move.b	#")",(a1)+
.StateOn2:	clr.b	(a1)

		move.l	(a3),d0
		beq.s	.NoMorePlayers
		move.l	d0,a3
		move.l	a2,a4
		lea	(EPPl_Sizeof+NamenLange+4)(a2),a2
		dbf	d1,.MakePlayerList

.NoMorePlayers:	move.w	#AnzInternalPlayers,PlayerAnz(a5)
		move.l	#AnzInternalPlayers,ScanPlayerAnz(a5)
		movem.l	(a7)+,d0-a6
		rts



*--------------------------- Lsche alle Players --------------------------*
FreePlayers:	moveq	#USClass_RemPlayerList,d0
		jsr	A5SendeAllMessage(a5)

	addq.b	#1,NoMessages(a5)

		lea	EPG_FirstPlayerStruct(a5),a4
		moveq	#0,d5
.NextPlayer:	addq.l	#1,d5
		move.l	a4,a3
		move.l	EPPl_Next(a4),d0
		beq.s	.SetDefaults
		move.l	d0,a4			;a4 = Pointer auf zu Struct des
						;     zu lschenden Players
	*------ Darf dieser Player gelscht werden ?? -----*
		move.l	EPPl_TagList(a4),a6
		move.l	#DTP_InternalPlayer,d0
		jsr	A5FindTag2(a5)
		bne.s	.NextPlayer

	*--- Testen, ob es sich bei EjectPlayer um den benutzten handelt ---*
		*move.l	EPPl_TagList(a4),d0
		*beq.s	.Loeschen

*		move.l	EPPl_TagList(a4),d0
*		bne.s	.NormalLoaded
*		tst.b	KillAllPlayer(a5)
*		beq.s	.NextPlayer
*		bra.s	.Loeschen

.NormalLoaded:	cmp.l	#Mode_Quit,Testbits(a5)
		beq.s	.Loeschen
		tst.b	KillAllPlayer(a5)
		bne.s	.Loeschen




		tst.b	DelAllOther(a5)	;alle anderen Player lschen
		beq.s	.EjectImRunMode	;falls 1, darf der aktuelle Player
					;nicht gelscht werden !!!

		tst.l	PlayerAdr(a5)
		beq.s	.EjectImRunMode
		cmp.l	LoadNameAdr+4(a5),d0	;nicht lschen
		beq.s	.NextPlayer
		cmp.l	PlayerAdr(a5),d0
		beq.s	.NextPlayer
		move.l	EPPl_TagList(a4),d0
	beq.s	.EjectImRunMode
		cmp.l	PlayerAdr(a5),d0
		beq.s	.NextPlayer

.EjectImRunMode:tst.b	OnEjectPlayer(a5)
		beq.s	.NextPlayer
		tst.l	EPPL_Taglist(a4)
		beq.s	.NextPlayer
		move.l	d5,d2
		moveq	#0,d3
		move.l	d5,-(a7)
		bsr	PlayerZustand
		move.l	(a7)+,d5
		bra.s	.NextPlayer



	*------ Liste neu setzen ------*
.Loeschen:	addq.b	#1,KillAllPlayer(a5)
		bsr	FreeThisPlayer
		subq.b	#1,KillAllPlayer(a5)
		move.l	a3,a4
		bra.s	.NextPlayer









*.EjectImRunMode:tst.b	OnEjectPlayer(a5)
*		beq.s	.NextPlayer
*		tst.l	EPPl_Taglist(a4)
*		beq.s	.NextPlayer
*
*		move.l	d5,d2
*		moveq	#0,d3
*		move.l	d5,-(a7)
*		bsr	PlayerZustand
*		move.l	(a7)+,d5
*
*		bra.s	.NextPlayer		
*


	*--------------------- Setze die Player-Defaults ---------------*
.SetDefaults:	lea	EPG_FirstPlayerStruct(a5),a0
		moveq	#0,d0
.FindNextPl:	move.l	EPPl_Next(a0),d1
		beq.s	.ItsAll
		move.l	d1,a0
		addq.l	#1,d0
		bra.s	.FindNextPl
.ItsAll:	move.w	d0,PlayerAnz(a5)
		move.l	d0,ScanPlayerAnz(a5)
		*cmp.w	#AnzInternalPlayers,d0
		*bne.s	.NoClrAdr
		*clr.l	LoadNameAdr(a5)
		*clr.l	LoadNameAdr+4(a5)

	*------------- Engines benachrichten --------------*
.NoClrAdr:
	subq.b	#1,NoMessages(a5)
		moveq	#USClass_NewPlayer,d0
		jsr	A5SendeAllMessage(a5)
		rts


*-------------------------- Gibt diesen Player frei --------------------------*
* Input: a4=verkettete PlayerStructadr					      *
*-----------------------------------------------------------------------------*
FreeThisPlayer:	movem.l	d0-a6,-(a7)

		lea	EPG_FirstPlayerStruct(a5),a2
.NextPlayer:	move.l	(a2),d0
		beq.w	.Return
		move.l	a2,a3
		move.l	d0,a2
		cmp.l	d0,a4
		bne.s	.NextPlayer

		tst.b	KillAllPlayer(a5)
		beq.s	.VerkettungNicht

		move.l	EPPl_Next(a4),EPPl_Next(a3)	;Verkettung neu setzen


		*--- Verkettung der Nodes neu setzen ---*
		lea	EPPl_Node(a4),a1
		REMOVE

		*--- Player zu Ende ---*
.VerkettungNicht:
		move.l	EPPl_TagList(a4),a6
		move.l	#EP_EjectPlayer,d0
		jsr	A5CallUp3(a5)

		moveq	#100,d4
.NextVersuch:	move.l	EPPl_TaskAdr(a4),d0
		beq.s	.NoTask
		move.l	EPPl_Node+LN_Name(a4),a1
		ExecBase
		jsr	_LVOFindTask(a6)
		tst.l	d0
		beq.s	.NoTask
		move.l	d0,a1
		move.l	#$1000,d0
		Execbase
		jsr	_LVOSignal(a6)

		moveq	#1,d1
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVODelay(a6)
		dbf	d4,.NextVersuch

		move.l	EPPl_TaskAdr(a4),a1		*bei Fehler Task
		EXECBASE				*beenden
		jsr	_LVORemTask(a6)


		*-- Segment freigeben --*
.NoTask:	move.l	EPPl_Segment(a4),d1
		beq.s	.NoSegment
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOUnLoadSeg(a6)
		subq.l	#1,PlayerAnz(a5)

		*---- ExtraMem freigeben ----*
.NoSegment:	move.l	EPPl_ExtraMem(a4),d0
		beq.s	.NoExtraMem
		move.l	d0,a1
		move.l	EPPl_ExtraMemSize(a4),d0
		beq.s	.NoExtraMem
		Execbase
		jsr	_LVOFreeMem(a6)

.NoExtraMem:	clr.l	EPPl_ExtraMem(a4)
		clr.l	EPPl_ExtramemSize(a4)
		clr.l	EPPl_Segment(a4)
		clr.l	EPPl_TaskAdr(a4)
		clr.l	EPPl_TagList(a4)

		tst.b	KillAllPlayer(a5)
		beq.s	.Return

		move.l	a4,a1
		move.l	EPPl_Size(a4),d0
		beq.s	.Return
		Execbase
		jsr	_LVOFreeMem(a6)
		subq.l	#1,ScanPlayerAnz(a5)
.Return:	movem.l	(a7)+,d0-a6
		rts

**--------------------------- Lsche alle Players --------------------------*
*FreePlayers:	lea	FirstPlayer(a5),a4
*
*	*------------- Engines benachrichten --------------*
*		moveq	#USClass_RemPlayerList,d0
*		jsr	A5SendeAllMessage(a5)
*
*
*
*.NextPlayer:	move.l	a4,a3
*		move.l	(a4),d0
*		beq.s	.SetDefaults
*		move.l	d0,a4			;a4 = Pointer auf zu lschenden
*						;Player
*	*------ Darf dieser Player gelscht werden ?? -----*
*		move.l	12(a4),a6
*		move.l	#DTP_InternalPlayer,d0
*		jsr	A5FindTag2(a5)
*		bne.s	.NextPlayer
*
*	*--- Testen, ob es sich bei EjectPlayer um den benutzten handelt ---*
*		move.l	12(a4),d0
*		tst.b	DelAllOther(a5)
*		beq.s	.Loeschen
*		tst.l	PlayerAdr(a5)
*		beq.s	.Loeschen
*		cmp.l	LoadNameAdr+4(a5),d0	;nicht lschen
*		beq.s	.NextPlayer
*		cmp.l	PlayerAdr(a5),d0
*		beq.s	.NextPlayer
*		
*
*	*------ Liste neu setzen ------*
*.Loeschen:	move.l	(a4),(a3)		;Verkettung neu setzen
*
*	*----- Segment freigeben ------*
*		move.l	12(a4),a6
*		move.l	#EP_EjectPlayer,d0
*		jsr	A5CallUp3(a5)
*		move.l	a4,d1
*		asr.l	#2,d1
*		subq.l	#1,d1
*		move.l	DTG_Dosbase(a5),a6
*		jsr	_LVOUnLoadSeg(a6)
*		move.l	a3,a4
*		bra.s	.NextPlayer
*
*	*--------------------- Setze die Player-Defaults ---------------*
*.SetDefaults:	lea	FirstPlayer(a5),a0
*		moveq	#0,d0
*.FindNextPl:	move.l	(a0),d1
*		beq.s	.ItsAll
*		move.l	d1,a0
*		addq.l	#1,d0
*		bra.s	.FindNextPl
*.ItsAll:	move.w	d0,PlayerAnz(a5)
*		cmp.w	#AnzInternalPlayers,d0
*		bne.s	.NoClrAdr
*		clr.l	LoadNameAdr(a5)
*		clr.l	LoadNameAdr+4(a5)
*
*	*------------- Userprogramme benachrichten --------------*
*.NoClrAdr:	moveq	#USClass_NewPlayer,d0
*		jsr	A5SendeAllMessage(a5)
*		rts
*



*-----------------------------------------------------------------------------*
*-----------------------------------------------------------------------------*
AddPlayerDir:	jsr	A5WaitMouse(a5)
		LA0	LNr_SW_AddPlayer
		jsr	A5PrintText(a5)
		move.w	PlayerAnz(a5),OldPlayerAnz(a5)

		tst.l	d2
		beq.s	.FileReq

		move.l	a2,a1
		move.l	d2,d3
		subq.l	#1,d3
		lea	PlayersDir(a5),a0	;A0=Wohin mit Players.
		jsr	A5CreateDirAusPath(a5)	;A1=Path d3=Lnge
		bra.w	.LoadIt

.FileReq:	LA0	LNr_Fr_AddPlayer		;TitleName
		lea	PlayersDir(a5),a1		;Dir-Ptr
		sub.l	a2,a2				;Keine Filename
		jsr	A5GetMainWindowHandle(a5)
		move.l	d0,a3				;WinHandle --> a3
		moveq	#1,d0				;Kennung Dir laden
		jsr	A5FileRequest2(a5)
		bne.w	ScrollNewFehler

.LoadIt:	moveq	#0,d0
		cmp.l	#Mode_Config,TestBits(a5)
		beq.w	PlayerRet
		jsr	A5LoadPlayers2(a5)
		beq.s	.NoPlayer

		move.w	PlayerAnz(a5),d0
		sub.w	OldPlayerAnz(a5),d0
.NoPlayer:	bra.w	PrintLoadPlayers


*----------------------------------------------------------------------------*
*----------------------------------------------------------------------------*
AddPlayer:	jsr	A5WaitMouse(a5)

		tst.l	d2
		beq.s	.FileReq

		moveq	#0,d3
		move.l	a2,a1
		jsr	A5GetFileName(a5)
		cmp.l	a2,a1
		beq.s	.NurName


		*--- Diranteil in Dirpuffer kopieren ---*
		move.l	d2,d3
		subq.l	#1,d3
		move.l	a2,a1
		lea	PlayersDir(a5),a0	;A0=Wohin mit Players.
		jsr	A5CreateDirAusPath(a5)	;A1=Path d3=Lnge

		move.l	a0,a1
.NurName:	lea	PlayersFile(a5),a0
		jsr	A5CopyFileName(a5)
		bra.w	LoadOnePlayer




.FileReq:	LA0	LNr_SW_AddPlayer
		jsr	A5PrintText(a5)
		LA0	LNr_Fr_AddPlayer
		lea	PlayersDir(a5),a1
		lea	PlayersFile(a5),a2
		jsr	A5GetMainWindowHandle(a5)
		move.l	d0,a3
		moveq	#2,d0			;Kennung ->> File zu laden
		jsr	A5FileRequest2(a5)
		bne.w	ScrollNewFehler
		cmp.l	#1,d1
		ble.w	LoadOnePlayer		;nur einen laden

.LoadPlayer	moveq	#0,d0
		cmp.l	a0,d0
		beq.w	LoadOnePlayer
		move.w	PlayerAnz(a5),d0
		movem.l	d0/a0,-(a7)

	*-------- Schleife fr MultiSelect ----------*
	*------ Engines benachrichten ------*
	moveq	#USClass_RemPlayerList,d0
	jsr	A5SendeAllMessage(a5)
	addq.b	#1,NoMessages(a5)


		move.l	a0,a3
.NextEinTrag:	move.l	DTG_Dosbase(a5),a6
		move.l	EFP_NameDirLock(a3),d7
		bne.s	.LockUsed

		lea	PlayersDir(a5),a1
		move.l	EFP_DirArrayPtr(a3),d0
		beq.s	.NoDirLock
		move.l	d0,a0
		move.w	#DirPufferSize-2,d1
		jsr	A5StringCopy2(a5)
		bra.s	.NoDirLock

	*------- DirName in DirPuffer copieren -------*
.LockUsed:	clr.b	PlayersDir(a5)			;Dirpointer lschen
		move.l	d7,d1
		lea	PlayersDir(a5),a0
		move.l	a0,d2
		move.l	#DirPufferSize-2,d3		;DirPuffersize
		jsr	_LVONameFromLock(a6)

	*----------- Player laden ------------*
.NoDirLock:	move.l	EFP_IT_IText(a3),a0
		lea	PlayersFile(a5),a1
		jsr	A5StringCopy(a5)
		movem.l	d1-a6,-(a7)
		jsr	A5LoadOnePlayer(a5)
		movem.l	(a7)+,d1-a6

	*---------- Noch einen Eintrag -------*
		move.l	(a3),d0
		beq.s	.FreeMulti
		move.l	d0,a3
		bra.w	.NextEinTrag

.FreeMulti:	movem.l	(a7)+,a0/d1
		moveq	#1,d0				;no internal Puffer
		jsr	A5FreeMultiPuffer(a5)
		move.w	PlayerAnz(a5),d0
		sub.w	d1,d0

PrintLoadPlayers:

	*------ Engines benachrichten ------*
	subq.b	#1,NoMessages(a5)
	move.l	d0,-(a7)
	moveq	#USClass_NewPlayer,d0
	jsr	A5SendeAllMessage(a5)
	move.l	(a7)+,d0

	*-------- Zeigt, wie viele Player geladen wurden ------*
		move.l	d0,ScrollArgs(a5)
		LA0	LNr_PlayersAdded
		jsr	A5ScrollNewText(a5)
		moveq	#0,d0
PlayerRet:	rts


*------------------------- Einen Player reinladen -----------------------*
LoadOnePlayer:	lea	PlayersFile(a5),a0
		move.l	a0,ScrollArgs(a5)
		LA0	LNr_Loading
		jsr	A5PrintText(a5)

		move.l	EPG_EagleplayerDirArrayPtr(a5),a1
		move.l	DTG_Dosbase(a5),a6
		jsr	A5HoleLock(a5)
		move.l	d0,LOP_Dir(a5)
		beq.s	.LOP1_No
		move.l	d0,d1
		jsr	_LVOCurrentDir(a6)
		move.l	d0,LOP_Dir(a5)
.LOP1_No:

		lea	PlayersDir(a5),a1
		jsr	A5HoleLock(a5)
		beq.w	.Error
		jsr	_LVOCurrentDir(a6)
		move.l	d0,OldDir(a5)

		*- original Playerdir setzen falls Player nicht im akt. -*
		*- Verz gefunden werden kann -*
		lea	PlayersFile(a5),a0
		move.l	a0,d1
		moveq	#-2,d2
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOLock(a6)
		move.l	d0,d3
		move.l	d0,d1
		beq.s	.NoPlFound
		jsr	_LVOUnLock(a6)
.NoPlFound:	tst.l	d3
		bne.s	.FiFound
		LA1	LNr_EaglePlayerDir
		lea	PlayersDir(a5),a0
		jsr	A5StrCmp(a5)
		beq.s	.FiFound


		*jsr	A5SetOldDir(a5)
		bsr	.SetOldDir

		LA1	LNr_EaglePlayerDir
		move.l	a1,d1
		moveq	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,d3
		beq.s	.FiFound
		move.l	d0,d1
		jsr	_LVOCurrentDir(a6)
		move.l	d0,OldDir(a5)
.FiFound:

		

		lea	PlayersFile(a5),a0
		move.l	a0,d1
		jsr	A5LoadPlayer2(a5)		;Load ext. EaglePlayer
		beq.s	.Error2
		move.w	LoadPlayerExists(a5),d0
		bne.s	.AddNoPlayer

		*jsr	A5SetOldDir(a5)
		bsr	.SetOldDir
		bsr	.LOPOldDir
		addq.w	#1,PlayerAnz(a5)
		addq.l	#1,ScanPlayerAnz(a5)

		*------ Engines benachrichten ------*
		moveq	#USClass_NewPlayer,d0
		jsr	A5SendeAllMessage(a5)

		lea	Playersfile(a5),a0
		move.l	a0,ScrollArgs(a5)
.Dochnurgeladen:LA0	LNr_Loaded
		jmp	A5ScrollNewText(a5)


	*----------- Player existiert, ersetzen ?? ---------------*
.AddNoPlayer:	bsr	.SetOldDir
		*jsr	A5SetOldDir(a5)
		bsr	.LOPOldDir
		move.w	LoadPlayerExists(a5),d0
		subq.w	#1,d0
		beq.s	.exists
		addq.w	#1,PlayerAnz(a5)
		addq.l	#1,ScanPlayerAnz(a5)

		*------ Engines benachrichten ------*
		moveq	#USClass_NewPlayer,d0
		jsr	A5SendeAllMessage(a5)

		lea	Playersfile(a5),a0
		move.l	a0,ScrollArgs(a5)
		cmp.w	#3,LoadPlayerExists(a5)
		beq.s	.Dochnurgeladen
		LA0	LNr_Reloaded
		jmp	A5ScrollNewText(a5)

.Exists:	moveq	#EPR_PlayerExists,d0
		jmp	A5ScrollNewFehler(a5)

.Error2:	*jsr	A5SetOldDir(a5)
		bsr	.SetOldDir
		bsr	.LOPOldDir
.Error:		move.l	LoadPlayerError(a5),d0
		bne.s	.ErrorDa
		moveq	#EPR_ErrorAddPlayer,d0
.ErrorDa:	jmp	A5ScrollNewFehler(a5)


.LOPOldDir:	move.l	LOP_Dir(a5),d1
		beq.s	.LOPReturn
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnlock(a6)
.LOPReturn:	clr.l	LOP_Dir(a5)
		rts

.SetOldDir:	move.l	OldDir(a5),d1
		beq.s	.SOD_Return
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOCurrentDir(a6)
.SOD_Return:	clr.l	OldDir(a5)
		rts

*------------------- User-Programm wurde geschlossen --------------------*
*----------- a1 = Adresse der UM_Struktur Message-Struktur --------------*
*----------- d6 = Zustand des Userprogramms -----------------------------*
*----------- d7 = USClass -----------------------------------------------*
ChangeEngine:	movem.l	d0-a6,-(a7)
	lea	TextPuffer+400(a5),a2			;irgendwas
		move.w	d6,UM_Enabled(a1)			;User enabled

		move.l	a1,a4

		jsr	A5ClearMenuStrip(a5)
		sub.l	a0,a0
		move.w	UM_EngineNr(a4),d0
		jsr	A5FindUserStruct(a5)
		bne.s	.NoTypeUserName

;	lea	Freedirmem-12,a1		;A2 da oben nicht vergessen
	move.l	A5FreeDirMem+2(a5),a1
	moveq	#12,d0
	sub.l	d0,a1
	add.l	EmptyPuffer(a5),a1

	move.w	22+12(a1),d0			;
	lsr.w	#2,d0				;
	sub.w	#$2c78>>2,d0			;
	add.w	d0,EPG_Wordreserved8-(TextPuffer+400)(a2)	;+-+- Check 2

		cmp.w	#USClass_NewEngine,d7		;nicht bei Neustart
		bne.s	.NoNewEngine

		tst.b	OnIconify(a5)
		beq.s	.NoIconify
		move.l	UPrgS_EUSAdr(a0),d0
		beq.s	.NoIconify
		move.l	d0,a1
		btst	#EUSF_Show,EUS_Flags+1(a1)
		beq.s	.NoIconify
		bset	#UPrgF_Show,UPrgS_UFlags+3(a0)
		bclr	#EUSF_Show,EUS_Flags+1(a1)
.NoIconify:	tst.w	d6			*Wird wieder entfernt
		bne.s	.NoTypeUserName
.NoNewEngine:	moveq	#0,d3			*Engine off
		tst.w	d6
		bne.s	.CloseWin
		moveq	#1,d3			*Engine on
.CloseWin:	moveq	#0,d2
		move.w	UM_EngineNr(a4),d2
		jsr	A5Engine(a5)
.NoTypeUserName:jsr	A5SetMenuStrip(a5)
		movem.l	(a7)+,d0-a6
		rts


	

**---------------------- Nun Engine raushauen ----------------------------*
** Result1=UserNummer(EPG_Arg1)
*UPrg_QuitEngine:move.l	EPG_Arg1(a5),d0
*		jsr	A5FindUserStruct(a5)		
*		bne.w	ArgumentError
*
*		move.l	EPG_Arg1(a5),d0
*		*jsr	A5CreateQuitName(a5)
*
*		move.l	CloseMainWindowMSG(a5),d0
*		beq.s	.NoReply
*		move.l	d0,a1
*		lea	EPEnginePort,a0
*		cmp.l	14(a1),a0		;Reply-Port vergleichen
*		beq.w	.NoReply
*		lea	EPReplayEnginePort,a0
*		cmp.l	14(a1),a0		;Reply-Port vergleichen
*		beq.w	.NoReply
*		clr.l	UM_StructAdr(a1)
*		jsr	A5CopyMessage2(a5)
*		clr.l	CloseMainWindowMSG(a5)
*.NoReply:	move.l	EPG_Arg1(a5),d7		;UserNr
*		move.l	d7,d0
*		moveq	#1,d1
*		move.l	#USClass_Exit,d2
*		moveq	#0,d3
*		moveq	#0,d4
*		moveq	#0,d5
*		jsr	A5SendeOneMessage(a5)
*		bne.w	ScrollNewFehler
*
*		move.l	d7,d0
*		jsr	A5DeleteEngine(a5)
*		bra.w	ScrollUserName
*

**----------------- User-Programme ber Arexx ein/ausschalten --------------*
*KM_Engine:	move.l	EPG_Arg1(a5),d0
*		ble.w	ArgumentError
*		jsr	A5ClearMenuStrip(a5)
*		jsr	A5FindUserStruct(a5)		
*		bne.w	ArgumentError
*
*		move.l	EPG_Arg1(a5),d0				;UserNr
*		bclr.b	#0,UPrgS_Flags(a0)			;Hacken lschen
*		tst.l	EPG_Arg3(a5)
*		beq.s	.User2
*		jsr	A5SetEngineZustand(a5)
*.User2:	jsr	A5SetMenuStrip(a5)
*
*
*		moveq	#0,d1
*		move.b	OnEjectEngine(a5),d1
*		move.l	d1,-(a7)
*		clr.b	OnEjectEngine(a5)
*		bsr.s	KM_Engine2
*		move.l	(a7)+,d1
*		move.b	d1,OnEjectEngine(a5)
*		rts

*-------------- Das Fenster des Engines wird geschlossen/geffnet ------------*
* d2=Nummer des Engines
* d3=Zustand des Windows
EngineShowState:
		move.l	d2,d0
		jsr	A5FindUserStruct(a5)		
		bne.w	.Fehler
		move.l	a0,a4

		*---- Zeige oder Verberge ------*
		moveq	#EPR_EngineNotFound,d0
		move.l	UPrgS_UFlags(a4),d4
		btst	#UPrgF_BatchName,d4
		bne.w	.Fehler
		tst.l	d3
		bge.s	.NoToggle
		moveq	#0,d3				*Diabled
		btst	#UPrgF_Show,d4
		bne.s	.NoToggle
		moveq	#1,d3		

.NoToggle:	tst.l	UPrgS_SubItem(a4)
		beq.s	.NoSubItems
		jsr	A5ClearMenuStrip(a5)
		move.l	UPrgS_SubItem(a4),a0
		move.l	(a0),d0
		beq.s	.DochNicht
		move.l	d0,a0
		bclr	#0,12(a0)
		tst.l	d3
		beq.s	.DochNicht
		bset	#0,12(a0)
.DochNicht:	jsr	A5SetmenuStrip(a5)
.NoSubItems:	bset	#UPrgF_Show,d4
		LA0	LNr_Show
		moveq	#USClass_Show,d0
		tst.l	d3
		bne.s	.TextOk
		moveq	#USClass_Hide,d0
		LA0	LNr_Hide
		bclr	#UPrgF_Show,d4
.TextOk:	move.l	d4,UPrgS_UFlags(a4)
		exg	d0,d2				*Nr=d0 Class=d2
		move.l	d2,d1				*Enabled
		subq.l	#1,d1
		moveq	#0,d4				*ArgList
		moveq	#0,d5
		move.l	a0,-(a7)
		jsr	A5SendeOneMessage(a5)
		move.l	(a7)+,a0
		tst.l	d0
		bne.w	.Fehler

		move.l	UPrgS_Name(a4),ScrollArgs(a5)
		jmp	A5ScrollNewText(a5)


.Fehler:	jmp	A5ScrollNewFehler(a5)


*-----------------------------------------------------------------------------*
* fr das angegebene Engine wird die Configroutine aufgerufen.		      *
* Besitzt das Engine einen Tag EUT_Config, wird dort hingehpft. Gibt es      *
* keinen, wird Show/Hide gemacht.					      *
*-----------------------------------------------------------------------------*
EngineConfig:	move.l	d2,d0
		jsr	A5FindUserStruct(a5)		
		bne.w	.Error
		move.l	a0,a4
		moveq	#EPR_EngineNotFound,d0
		move.l	UPrgS_EusAdr(a4),d1
		beq.s	.Error
		move.l	d1,a3
		move.l	EUS_TagList(a3),a6
		move.l	#EUT_Config,d0
		jsr	A5FindTag2(a5)
		beq.w	EngineShowState

		move.l	UPRgS_Name(a4),ScrollArgs(a5)
		LA0	LNr_Configurating
		jsr	A5PrintText(a5)


		*---- USClass-Command abfangen ----*
		move.l	EUS_TagList(a3),-(a7)
		move.l	#EUT_Config,-(a7)
		moveq	#0,d1
		sub.l	a3,a3
		jsr	A5UserCallUp(a5)
		bne.s	.CommandOk
		moveq	#0,d0
.CommandOk:	move.l	PufferAdr(pc),a5
		addq.l	#8,a7
		tst.l	d0
		bne.s	.Error
		LA0	LNr_OperationSuccesful
		jmp	A5ScrollNewText(a5)

.Error:		jmp	A5ScrollNewFehler(a5)



*-----------------------------------------------------------------------------*
* Dir Config fr die Engines wird geladen / gespeichert			      *
*-----------------------------------------------------------------------------*
LoadEngineConfig:move.l	#USClass_LoadConfig,d4
		LA0	LNr_SW_LoadConfig
		LA1	LNr_LoadConfig
		bra.s	LoadCon2
SaveEngineConfig:move.l	#USClass_SaveConfig,d4
		LA0	LNr_SW_SaveConfig
		LA1	LNr_SaveConfig
LoadCOn2:	jsr	A5PrintText(a5)
		move.l	d2,d0				*UserNr
		move.l	d4,d2				*USClass
		moveq	#0,d1
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		jsr	A5SendeOneMessage(a5)
		bne.w	ScrollNewFehler
		
		move.l	a1,a0
		jmp	A5ScrollNewText(a5)

*-----------------------------------------------------------------------------*
* Aufruf ber Arexx
ASCEngine:	move.l	a2,a4
		clr.b	(a2,d2.w)
		jsr	A5FindUserAscStruct(a5)
		bne.w	ScrollNewFehler
		moveq	#EPR_EngineNotLoaded,d0
		*tst.l	UPrgS_EUSAdr(a3)
		*beq.w	ScrollNewFehler
		move.l	UPrgS_EngineNr(a3),d2
		bra.w	Engine		


*----- Ein Kommando aus dem Menu des EPEngine-SubItems wurde aufgerufen ------*
* d2=Nummer des Engines
* d3=Nummer des MenuItem.w & State.w
EngineItemCommand:
		move.l	d2,d0
		jsr	A5FindUserStruct(a5)		
		bne.w	.Fehler
		move.l	a0,a4

		*---- Zeige oder Verberge ------*
		moveq	#EPR_EngineNotFound,d0
		move.l	UPrgS_UFlags(a4),d5
		btst	#UPrgF_BatchName,d5
		bne.w	.Fehler

		moveq	#0,d2
		move.w	d3,d2				*Nummer des Menus
		swap	d3				*Zustand im .w
		ext.l	d3

		cmp.w	#EPNr_MainWindow,d2		*Kennung fr Activate
		beq.s	.EngineZustand
		cmp.w	#EPNr_EngineShowState,d2
		bne.s	.CommandoOk

		move.l	UPrgS_EngineNr(a4),d2
		bra.w	EngineShowState


		*------ Arg-Structure creieren ------*
.CommandoOk:	moveq	#EPT_String+4,d0
		jsr	A5AllocMem(a5)
		tst.l	d0
		beq.s	.MemFehler
		move.l	d0,d4
		move.l	d0,a0
		move.l	d2,ENA_Arg1(a0)
		move.l	d3,ENA_Arg2(a0)
		move.l	#EPT_String+4,ENA_Size(a0)

		move.l	UPrgS_EngineNr(a4),d0
		moveq	#USClass_Command,d2
		move.l	d2,d1				*Enabled
		subq.l	#1,d1
		move.l	#EPNr_EngineItemCommand,d3	*CommandoNr.
		moveq	#0,d5
		jsr	A5SendeOneMessage(a5)
		tst.l	d0
		bne.w	.Fehler

		LA0	LNr_EngineCommandDone
		jmp	A5ScrollNewText(a5)

.MemFehler:	moveq	#EPR_NotEnoughMem,d0
.Fehler:	jmp	A5ScrollNewFehler(a5)


	*------------------ Enginezustand ------------------*
.EngineZustand:	move.l	UPrgS_EngineNr(a4),d2

*---------------------------------------------------------------------------*
*--------------- Im Pull-Down-Menu wurde ein Item an/ausgewhlt ------------*
* d0=Nummer
* d2=EngineNr
* d3=Zustand
* d4=Message oder Null d4<>0 --> Message noch senden
Engine:		moveq	#0,d4
		move.l	d2,d0
		move.l	d2,d5
		move.l	d2,d7
		jsr	A5FindUserStruct(a5)		
		bne.w	.Fehler

	* Zustand setzen *
		moveq	#USClass_Activate,d6
		tst.l	d3
		bgt.s	.D6Ok
		beq.s	.D6Set
		btst	#UPrgF_Active,UPrgS_UFlags+3(a0)
		beq.s	.D6Ok
.D6Set:		moveq	#USClass_DeActivate,d6
.D6Ok:


	*--------- Mu das Engine noch geladen werden --------*
		move.l	UPrgS_UFlags(a0),d1
		btst	#UPrgF_Batchname,d1
		beq.s	.Loaded
		cmp.w	#USClass_DeActivate,d6		*Batch gilt als
		beq.w	.TypeUserName			*Deactivate

		addq.w	#1,RefreshMenuVerbot(a5)
		movem.l	d1-a6,-(a7)
		move.l	UPrgS_EngineNr(a0),d0
		move.l	a0,a1
		lea	UPrgS_NamePuffer(a0),a0		;Pfad
		sub.l	a2,a2				;EUS
		sub.l	a3,a3				;Args
		jsr	A5LoadEngine(a5)
		movem.l	(a7)+,d1-a6
		subq.w	#1,RefreshMenuVerbot(a5)
		tst.l	UPrgS_SubItem(a0)
		bne.s	.DochRefresh
		btst	#UPrgF_Gui,UPrgS_UFlags+3(a0)
		beq.s	.NoNewGui
		jsr	A5RefreshMenu(a5)
		bra.w	.SetMenu


.DochRefresh:
		jsr	A5RefreshMenu(a5)
.NoNewGui:

		tst.l	d0
		beq.w	.SetMenu
		*beq.w	.TypeUserName
		jsr	A5ClearMenuStrip(a5)
		jsr	A5ClearEngineZustand(a5)		;Hacken lschen
		bclr	#UPrgF_Active,UPrgS_UFlags+3(a0)	* Merk lschen
.Fehler:	jsr	A5SetMenuStrip(a5)
		jmp	A5ScrollNewFehler(a5)


	*---- Engine raushauen oder nur activieren/deactivieren ----*
.Loaded:	tst.b	OnEjectEngine(a5)
		beq.w	.BleibDrinnen
		move.l	d5,d0
		jsr	A5FindUserStruct(a5)
		bne.w	.Fehler
		cmp.w	#USClass_Activate,d6
		beq.w	.BleibDrinnen
		*btst	#0,UPrgS_Flags(a0)
		*bne.w	.BleibDrinnen


	*---------- Nun Engine raushauen --------*
		move.l	UPrgS_EUSAdr(a0),d0		*Amplifier bleiben drin
		beq.w	.BleibDrinnen
		move.l	d0,a1
		*cmp.b	#EUTY_Amplifier,EUS_Type(a1)
		*beq.s	.BleibDrinnen
		move.l	UPrgS_Name(a0),ScrollArgs(a5)
		LA0	LNr_Quit
		lea	ScrollArgs(a5),a1
		jsr	A5MakecorrectText(a5)
		move.l	CloseMainWindowMSG(a5),d0
		beq.s	.NoReply
		move.l	d0,a1
		lea	EPEnginePort,a0
		cmp.l	14(a1),a0		;Reply-Port vergleichen
		beq.w	.NoReply
		lea	EPReplayEnginePort,a0
		cmp.l	14(a1),a0		;Reply-Port vergleichen
		beq.w	.NoReply
		clr.l	UM_StructAdr(a1)
		jsr	A5CopyMessage2(a5)
		clr.l	CloseMainWindowMSG(a5)
.NoReply:
	;------------- Wenn Amplifier, dann erstmal Mod killen ----------------

		movem.l	d0-a6,-(sp)
		move.l	d7,d0
		jsr	A5FindEUSStruct(a5)
		bne.s	.goon			;keine EUS Struct gefunden
		move.l	a0,a4
		tst.l	EUS_Jmp(a4)		;interne AM werden (noch?)
		beq.s	.goon			;nicht gekillt

		cmp.b	#EUTY_Amplifier,eus_type(a4)
		bne.s	.goon			;kein Amplifier -> weiter

		move.l	a4,d1				;zu killender Amplifier
		cmp.l	EPG_ActiveAmplifier(A5),d1	;aktiv ?
		bne.s	.goon				;n, weiter
		jsr	A5AllesRaus(a5)
		jsr	A5GuiChanged(a5)
.goon
		movem.l	(sp)+,d0-a6

		move.l	d5,d0
		moveq	#1,d1
		move.l	#USClass_Exit,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		jsr	A5SendeOneMessage(a5)
		bne.w	.Fehler
		move.l	d7,d0
		jsr	A5WriteEnginePrefsToUPrg(a5)
		jsr	A5DeleteEngine(a5)
		lea	ScrollPuffer(a5),a0
		bra.w	.ScrollIt

*---------------------------------------------------------------------------*
*-- Eine Message nach dem angegebenen Userprogramm senden und Warten, bis --*
*-------- diese wieder zurckkommt und auswerten der ReturnMessage ---------*
*--- Die SS_StructAdr wird automatisch gesetzt, sowie Type und Replyport ---*
*---- _LVOPutMsg(a6)							----*
*----									----*
*---- Input:	d0 = UserNr						----*
*----		d1 = Enabled(0) oder Disabled(1)			----*
*----		d2 = US_Class						----*
*----		d3 = Command						----*
*----		d4 = ArgList						----*
*----		d5 = Result						----*
*----									----*
*---- OutPut:	a0 = Adresse der Struktur				----*
*----		d0 = Fehler						----*
*---------------------------------------------------------------------------*
.BleibDrinnen:	move.l	d5,d0
		move.l	d6,d2
		move.l	d6,d1
		sub.l	#1,d1
		tst.l	d4			* die Message ist schon weg
		bne.s	.SetMenu
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		jsr	A5SendeOneMessage(a5)
		tst.l	d0
		bne.w	.Fehler

	*----------- Menus ndern ------------*
.SetMenu:	moveq	#USClass_RemEnginesList,d0
		jsr	A5SendeAllMessage(a5)

		jsr	A5ClearMenuStrip(a5)
		jsr	A5ClearEngineZustand(a5)
		bclr	#UPrgF_Active,UPrgS_UFlags+3(a0)
		cmp.w	#USClass_DeActivate,d6
		beq.s	.SetMenu2
		jsr	A5SetEngineZustand(a5)
		bset	#UPrgF_Active,UPrgS_UFlags+3(a0)
.SetMenu2:	jsr	A5SetMenuStrip(a5)

		jsr	A5InsertEngineNodeName(a5)
		moveq	#USClass_NewEngineLoaded,d0
		jsr	A5SendeAllMessage(a5)


*--------------------------------------------------------------------------*
.TypeUserName:	move.l	d7,d0
		jsr	A5FindUserStruct(a5)
		bne.w	.Fehler
		move.l	UPrgS_Name(a0),a0		;TextAdr laden
		move.l	a0,ScrollArgs(a5)
		LA0	LNr_Off_Extern
		cmp.w	#USClass_Deactivate,d6
		beq.s	.ScrollIt
		LA0	LNr_On_Extern
.ScrollIt:	jmp	A5ScrollNewText(a5)



FindNameStart:	move.b	(a0)+,d1
		beq.s	.ItsAll
		cmp.b	#" ",d1
		beq.s	FindNameStart
.ItsAll:	subq.l	#1,a0
		rts

*-----------------------------------------------------------------------------*
* Input: d0 = EngineNr
WriteEnginePrefsToUPrg:
		movem.l	d0-a6,-(a7)
		jsr	A5FindUserStruct(a5)
		bne.s	.ExitNoStr
		move.l	UPrgS_EusAdr(a0),d0
		beq.s	.ExitNoStr
		move.l	d0,a4
		move.w	EUS_Winx(a4),UPrgS_WinX(a0)
		move.w	EUS_WinY(a4),UPrgS_WinY(a0)
		move.w	EUS_Flags(a4),UPrgS_EUSFlags(a0)
		bclr	#0,UPrgS_EUSFlags+1(a0)		;deactivieren
		move.l	EUS_Special(a4),UPrgS_Special1(a0)
		move.l	EUS_Special2(a4),UPrgS_Special2(a0)
		move.l	EUS_Special3(a4),UPrgS_Special3(a0)
		move.w	#$3f,UPrgS_CFlags(a0)

.ExitNoStr:	movem.l	(a7)+,d0-a6
		rts

*------------------------ AboutEagleplayer-Textrequest ----------------------*
About:		lea	RegTab,a2
		moveq	#6,d0
.SetNames:	move.w	(a2)+,d1
		lea	(a5,d1.w),a1
		move.w	(a2)+,d2
		move.l	a1,a0
		bsr	FindNameStart
		move.l	a0,(a1,d2.w)		;d2=Offset to ARegistertable
		dbf	d0,.SetNames
		jsr	A5AboutTextRequester(a5)
		LA0	LNr_EPVersion
		move.l	A0,ScrollArgs(a5)
		moveq	#LNr_Welcome,d0
		jmp	A5ScrollNew(a5)

	*--------------------------- About Prg -----------------*
AbortTextRequester:
		LA0	LNr_AboutEagleplayer
		jsr	A5PrintText(a5)


.GlobalInfos:	LA0	LNr_AboutGlobal
		move.l	a0,EPG_Arg1(a5)
		lea	PubScreenName(a5),a0
		move.l	a0,EPG_Arg2(a5)
		clr.l	EPG_Arg3(a5)
		subq.l	#1,EPG_Arg3(a5)
		LA0	LNr_GA_Global
		move.l	a0,EPG_Arg4(a5)
		LA0	LNr_GlobalInfosTitle
		move.l	a0,EPG_Arg5(a5)
		clr.l	EPG_Arg6(a5)
		move.l	#EPTRB_Center,EPG_Arg8(a5)
		moveq	#-1,d0
		move.l	d0,EPG_Arg7(a5)
		moveq	#7,d0
		move.l	d0,EPG_ArgN(a5)
		jsr	A5TextRequest(a5)
		move.l	EPG_Arg1(a5),d0
		beq.s	.QuitAbout
		subq.l	#1,d0
		beq.w	.Credits
		subq.l	#1,d0
		beq.w	.Distribution
		subq.l	#1,d0
		beq.s	.Looking
		subq.l	#1,d0
		beq.w	.Register
.QuitAbout:	rts

	*------ We`re still looking for ------*
.Looking:	LA0	LNr_AboutLooking
		move.l	a0,EPG_Arg1(a5)
		lea	PubScreenName(a5),a0
		move.l	a0,EPG_Arg2(a5)
		clr.l	EPG_Arg3(a5)
		subq.l	#1,EPG_Arg3(a5)
		LA0	LNr_GA_Looking
		move.l	a0,EPG_Arg4(a5)
		LA0	LNr_LookingTitle
		move.l	a0,EPG_Arg5(a5)
		clr.l	EPG_Arg6(a5)
		moveq	#-1,d0
		move.l	d0,EPG_Arg7(a5)
		moveq	#7,d0
		move.l	d0,EPG_ArgN(a5)
		move.l	#EPTRB_Center,EPG_Arg8(a5)
		jsr	A5TextRequest(a5)
		move.l	EPG_Arg1(a5),d0
		beq.s	.QuitAbout
		subq.l	#1,d0
		beq.w	.Credits
		subq.l	#1,d0
		beq.s	.Distribution
		subq.l	#1,d0
		beq.w	.GlobalInfos
		subq.l	#1,d0
		beq.w	.Register
		rts

	*----- About Eagleplayer "Distribution" -----*
.Distribution:	LA0	LNr_AboutDistribution
		move.l	a0,EPG_Arg1(a5)
		lea	PubScreenName(a5),a0
		move.l	a0,EPG_Arg2(a5)
		clr.l	EPG_Arg3(a5)
		subq.l	#1,EPG_Arg3(a5)
		LA0	LNr_GA_Distribution
		move.l	a0,EPG_Arg4(a5)
		LA0	LNr_DistributionTitle
		move.l	a0,EPG_Arg5(a5)
		clr.l	EPG_Arg6(a5)
		moveq	#-1,d0
		move.l	d0,EPG_Arg7(a5)
		moveq	#7,d0
		move.l	d0,EPG_ArgN(a5)
		move.l	#EPTRB_Center,EPG_Arg8(a5)
		jsr	A5TextRequest(a5)
		move.l	EPG_Arg1(a5),d0
		beq.w	.QuitAbout
		subq.l	#1,d0
		beq.s	.Credits
		subq.l	#1,d0
		beq.w	.Looking
		subq.l	#1,d0
		beq.w	.GlobalInfos
		subq.l	#1,d0
		beq.s	.Register
		rts

	*------ About Eagleplayer "Credits" ------*
.Credits:	LA0	LNr_AboutCredits
		move.l	a0,EPG_Arg1(a5)
		lea	PubScreenName(a5),a0
		move.l	a0,EPG_Arg2(a5)
		clr.l	EPG_Arg3(a5)
		subq.l	#1,EPG_Arg3(a5)
		LA0	LNr_GA_Credits
		move.l	a0,EPG_Arg4(a5)
		LA0	LNr_CreditsTitle
		move.l	a0,EPG_Arg5(a5)
		clr.l	EPG_Arg6(a5)
		moveq	#-1,d0
		move.l	d0,EPG_Arg7(a5)
		moveq	#7,d0
		move.l	d0,EPG_ArgN(a5)
		clr.l	EPG_Arg8(a5)
		jsr	A5TextRequest(a5)
		move.l	EPG_Arg1(a5),d0
		beq.w	.QuitAbout
		subq.l	#1,d0
		beq.w	.Distribution
		subq.l	#1,d0
		beq.w	.Looking
		subq.l	#1,d0
		beq.w	.GlobalInfos
		subq.l	#1,d0
		beq.s	.Register
		rts

	*----- About Eagleplayer "Register" ------*
.Register:	LA0	LNr_AboutRegister
		tst.b	KeyOn(a5)
		beq.s	.NoRegistered
		LA0	LNr_AboutRRegister
.NoRegistered:	move.l	a0,EPG_Arg1(a5)
		lea	PubScreenName(a5),a0
		move.l	a0,EPG_Arg2(a5)
		clr.l	EPG_Arg3(a5)
		subq.l	#1,EPG_Arg3(a5)
		LA0	LNr_GA_Register
		move.l	a0,EPG_Arg4(a5)
		LA0	LNr_RegisterTitle
		move.l	a0,EPG_Arg5(a5)
		lea	ARegisterTable(a5),a0
		move.l	a0,EPG_Arg6(a5)
		moveq	#-1,d0
		move.l	d0,EPG_Arg7(a5)
		moveq	#7,d0
		move.l	d0,EPG_ArgN(a5)
		move.l	#EPTRB_Center,EPG_Arg8(a5)
		jsr	A5TextRequest(a5)
		move.l	EPG_Arg1(a5),d0
		beq.w	.QuitAbout
		subq.l	#1,d0
		beq.w	.Credits
		subq.l	#1,d0
		beq.w	.Distribution
		subq.l	#1,d0
		beq.w	.Looking
		subq.l	#1,d0
		beq.w	.GlobalInfos
		rts


*--------------------------- Remove AppIcon & AppItem ------------------*
RemoveApps:	movem.l	d0-d1/a0/a1/a6,-(a7)
		move.l	AppIconHandle(a5),d0
		beq.s	.NoAppIcon
		move.l	d0,a0
		move.l	EPG_Workbenchbase(a5),d0
		beq.s	.NoAppItem
		move.l	d0,a6
		jsr	_LVORemoveAppIcon(a6)
		clr.l	AppIconHandle(a5)
.NoAppIcon:	jsr	A5FreeAppIcon(a5)
		move.l	AppItemHandle(a5),d0
		beq.s	.NoAppItem
		move.l	d0,a0
		move.l	EPG_Workbenchbase(a5),a6
		jsr	_LVORemoveAppMenuItem(a6)
		clr.l	AppItemHandle(a5)
.NoAppItem:	jsr	A5CloseWorkbenchLib(a5)
		movem.l	(a7)+,d0-d1/a0/a1/a6
		rts

*------------------------- Setze AppIcon bzw. AppItem --------------------*
AddApps:	movem.l	d1/d2/d7/a0-a6,-(a7)
		moveq	#EPR_LibraryNotFound,d7
		LA1	LNr_WBName
		lea	EPG_WorkbenchBase(a5),a3
		moveq	#37,d0
		jsr	A5OpenLib(a5)
		tst.l	d0
		beq.s	.Return

		moveq	#EPR_UnknownError,d7

		cmp.b	#EPNrI_AppItem,IconifyMode(a5)
		beq.s	.AppItem

		tst.l	AppIconHandle(a5)
		bne.s	.AppsOk

		jsr	A5LoadAppIcon(a5)
		lea	EP_AppIconDO,a3		;Disk Object Struktur
		tst.l	d0
		beq.s	.NoDiskAppIcon
		move.l	d0,a3
.NoDiskAppIcon:	moveq	#1,d0			;id
		moveq	#0,d1			;Userdata
		LA0	LNr_Prozessname		;text
		lea	EPAppPort,a1		;MessagePort
		sub.l	a2,a2			;Lock
		sub.l	a4,a4			;Taglist in A4 ????? (nicht Systemuntersttzt)

		move.l	EPG_WorkbenchBase(a5),a6
		jsr	_LVOAddAppIconA(a6)
		move.l	d0,AppIconHandle(a5)
		bra.b	.Test

	*------------- App-Item ------------*
.AppItem:	tst.l	AppItemHandle(a5)
		bne.s	.AppsOk
		moveq	#1,d0			;id
		moveq	#0,d1			;Userdata
		LA0	LNr_Prozessname		;text
		lea	EPAppPort,a1		;MessagePort
		suba.l	a2,a2			;Lock
		move.l	EPG_WorkbenchBase(a5),a6
		sub.l	a4,a4
		jsr	_LVOAddAppMenuItemA(a6)
		move.l	d0,AppItemhandle(a5)
.Test:		tst.l	d0
		beq.w	.AppsOk
.AppsOk:	moveq	#0,d7
.Return:	move.l	d7,d0
		movem.l	(a7)+,d1/d2/d7/a0-a6
		rts

*------------------------ SetIconify per Userprogramm ---------------------*
*------------------------------ Iconify Mode ------------------------------*
SetIconifyMode:	cmp.b	IconifyMode(a5),d2	;nichts neues
		beq.s	.Return
		*move.b	d2,IconifyMode(a5)
		cmp.w	#EPNrI_MaxId,d2
		bhi.s	.Error

	*------ Eagleplayer befindet sich im Iconify--Modus -------*
	*-------------------- den Modus umschalten ----------------*
		moveq	#0,d1
		tst.b	OnIconify(a5)
		beq.s	.SetNormal
		movem.l	d1/d2,-(a7)
		jsr	A5RemoveApps(a5)
		movem.l	(a7)+,d1/d2
		moveq	#1,d1
.SetNormal:	move.b	d2,IconifyMode(a5)
		tst.b	d1
		beq.s	.Return
		jsr	A5AddApps(a5)
.Return:	move.w	#EPNr_IconifyMode,d0
		jsr	A5SetMutalExclude(a5)
		moveq	#0,d0
		move.b	IconifyMode(a5),d0
		add.b	#LNr_AppIcon,d0
		jmp	A5ScrollNew(a5)
.Error:		moveq	#EPR_ErrorInArguments,d0
		jmp	A5ScrollNewFehler(a5)


*-------------------- Window-Iconify switchen --------------------------*
Iconify:	cmp.l	#Mode_Config,Testbits(a5)
		beq.w	.Welcome

		addq.w	#1,ClearMouseVerbot(a5)
		tst.b	OnIconify(a5)
		beq.w	.UnIconify

	*################# ICONIFY ausfhren ###############*
	*-------- AppIcon & Workbenchs-Library ffnen ------*
		jsr	A5WaitMouse(a5)
		moveq	#USClass_Hide,d0	;User-Type (Dumy) Prg stoppen
		jsr	A5SendeAllMessage(a5)
		move.l	WindowOffen(a5),WinMerk(a5)
		jsr	A5CloseMainWindow(a5)

	*-------------- Iconify setzen ----------*
		jsr	A5AddApps(a5)
		bne.w	ToScrollNewFehler
		bra.s	.Welcome


	*############## UnIconify ausfhren ############*
.UnIconify:	move.l	EPG_SomePrefs(a5),d0
		bclr	#EGPRF_Iconify,d0
		move.l	d0,EPG_SomePrefs(a5)

		lea	PubScreenName2(a5),a0
		tst.b	(a0)
		beq.s	.normal

		move.l	DTG_Intuitionbase(a5),a6
		jsr	_LVOLockPubScreen(a6)
		tst.l	d0
		beq.s	.useWB
		move.l	d0,a1
		sub.l	a0,a0
		jsr	_LVOUnlockPubScreen(a6)		;PUBscreen freigeben

	*---------- zuletzt eingestellten Pubscreen eintragen ----------*
		lea	PubScreenName2(a5),a0
		lea	PubScreenName(a5),a1
		move.w	#PubScreenSize-2,d1
		jsr	A5StringCopy2(a5)
		bra.s	.normal
.useWB
	*--------- Workbench eintragen -------*
		LA0	LNr_DefPubScreen
		lea	PubScreenName(a5),a1
		move.w	#PubScreenSize-2,d1
		jsr	A5StringCopy2(a5)
.normal
		jsr	A5OpenOldEngines(a5)
		jsr	A5ScreenToFront(a5)

*		tst.b	OnNoGui(a5)
*		beq.s	.NormalUn
*.NoGui:		moveq	#0,d2
*		jsr	A5LoadModule(a5)
*		subq.w	#1,ClearMouseVerbot(a5)
*		jsr	A5ClearMouse(a5)
*		rts
*


.NormalUn:	jsr	A5RemoveApps(a5)
		move.l	WinMerk(a5),d0
		beq.s	.Welcome
		jsr	A5LoadDefaultGui(a5)
.Welcome:	LA0	LNr_EPVersion
		move.l	A0,ScrollArgs(a5)
		moveq	#LNr_Welcome,d0
.IconifyEnde:
	subq.w	#1,ClearMouseVerbot(a5)
		jmp	A5ScrollNew(a5)




*---------------------------------------------------------------------------*
*-- Eine Message nach dem angegebenen Userprogramm senden und Warten, bis --*
*-------- diese wieder zurckkommt und auswerten der ReturnMessage ---------*
*--- Die SS_StructAdr wird automatisch gesetzt, sowie Type und Replyport ---*
*---- _LVOPutMsg(a6)							----*
*----									----*
*---- Input:	d0 = UserNr						----*
*----		d1 = Enabled(0) oder Disabled(1)			----*
*----		d2 = US_Class						----*
*----		d3 = Command						----*
*----		d4 = ArgList						----*
*----		d5 = Result						----*
*----									----*
*---- OutPut:	a0 = Adresse der Struktur				----*
*----		d0 = Fehler						----*
*---------------------------------------------------------------------------*
*------------- ffnet alle User-Programme, die abgehackt sind -----------*
OpenOldEngines:moveq	#1,d6
		moveq	#AnzMaxEngines-1,d7

.NextUPrg:	move.l	d6,d0
		jsr	A5FindUserStruct(a5)
		bne.s	.Keine_Message
		move.l	UPrgS_UFlags(a0),d0

		tst.l	UPrgS_SubItem(a0)		*nur Show machen, wenn
		beq.s	.NormalShow			*Haken im UFlags
		btst	#UPrgF_Show,d0
		beq.s	.Keine_Message
		bra.s	.ShowIt

	*------------------ Was fr Engine-Typ --------------------*
.NormalShow:	btst	#UPrgF_Active,d0		;Test ob im Iconify
		beq.s	.Keine_Message

.ShowIt:	move.l	UPrgS_EUSAdr(a0),d0	\
		beq.w	.NextUPrg		 \
		move.l	d0,a1			  \
		tst.l	(a1)			  \
		beq.s	.TagUser		   \
		cmp.l	#TagUserID,(a1)		   > Bei Gui's kein
		bne.s	.TaskUser		  /  Activate
.TagUser:	cmp.l	UMG_UPrgSAdr(a5),a0	 /
		beq.s	.Keine_Message		/


.TaskUser:	move.l	d6,d0
		moveq	#0,d1
		moveq	#USClass_Show,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		jsr	A5SendeOneMessage(a5)

.Keine_Message:	addq.l	#1,d6
		dbf	d7,.NextUprg
		rts












**--- Schliee alle Userprogramme auer das mit Nummer in UM_EngineNr(a1) ---*
*KM_CloseOtherEngine:
*		move.w UM_EngineNr(a1),d1
*		ble.w	ErrInvalidNr
*		moveq	#AnzMaxEngines-1,d3
*		jsr	A5ClearMenuStrip(a5)
*		moveq	#1,d5
*		move.l	MerkCloseAll(a5),d4
*		move.w	d3,MerkCloseAllNr(a5)
*
*.FindEngine:	cmp.w	d5,d1
*		beq.s	.NoClose
*
*		lsl.l	#1,d4
*
*		move.l	d5,d0
*		jsr	A5FindUserStruct(a5)
*		bne.s	.NoClose
*
*	*------- Close Window und merke Position --------*
*		btst	#0,UPrgS_Flags(a0)
*		beq.s	.NoClose
*		or.b	#1,d4
*		bclr.b	#0,UPrgS_Flags(a0)
*
**---------------------------------------------------------------------------*
**-- Eine Message nach dem angegebenen Userprogramm senden und Warten, bis --*
**-------- diese wieder zurckkommt und auswerten der ReturnMessage ---------*
**--- Die SS_StructAdr wird automatisch gesetzt, sowie Type und Replyport ---*
**---- _LVOPutMsg(a6)							----*
**----									----*
**---- Input:	d0 = UserNr						----*
**----		d1 = Enabled(0) oder Disabled(1)			----*
**----		d2 = US_Class						----*
**----		d3 = Command						----*
**----		d4 = ArgList						----*
**----		d5 = Result						----*
**----									----*
**---- OutPut:	a0 = Adresse der Struktur				----*
**----		d0 = Fehler						----*
**---------------------------------------------------------------------------*
*		movem.l	d0-a4,-(a7)
*		move.l	d5,d0
*		moveq	#1,d1			;disablen
*		move.l	#USClass_DeActivate,d2
*		moveq	#0,d3
*		moveq	#0,d4
*		moveq	#0,d5
*		jsr	A5SendeOneMessage(a5)
*		movem.l	(a7)+,d0-a4
*
*.NoClose:	addq.l	#1,d5
*		dbf	d3,.FindEngine
*
*
*.NoMoreUPrgs:	;ror.l	#1,d4
*		move.l	d4,MerkCloseAll(a5)
*		move.b	#1,OnAllWindowsClosed(a5)
*		jsr	A5SetMenuStrip(a5)
*		jsr	A5CreatePlayName(a5)
*		jmp	A5ScrollNewText(a5)
*		
*	*	LA0	LNr_ICloseAllUser(pc),a0
*	*	jmp	A5ScrollNewText(a5)
*	*	jmp	A5CopyScrollTextToArexxPuffer(a5)
*
**---------------------------- Open all Engines -------------------------*
*KM_OpenAllOtherEngine:
*		move.w UM_EngineNr(a1),d1
*		ble.w	ErrInvalidNr
*
*		moveq	#AnzMaxEngines-1,d3
*		jsr	A5ClearMenuStrip(a5)
*
*		move.l	MerkCloseAll(a5),d4
*		move.w	MerkCloseAllNr(a5),d5
*		subq.w	#1,d5
*		moveq	#1,d6
*
*.FindEngine:	cmp.w	d6,d1
*		beq.s	.NoOpen2
*
*		move.l	d6,d0
*		jsr	A5FindUserStruct(a5)
*		bne.s	.NoOpen
*
*	*------ Close Window und merke Position ------*
*		btst	d5,d4
*		beq.s	.NoOpen
*		bset.b	#0,UPrgS_Flags(a0)
*		
*
**---------------------------------------------------------------------------*
**-- Eine Message nach dem angegebenen Userprogramm senden und Warten, bis --*
**-------- diese wieder zurckkommt und auswerten der ReturnMessage ---------*
**--- Die SS_StructAdr wird automatisch gesetzt, sowie Type und Replyport ---*
**---- _LVOPutMsg(a6)							----*
**----									----*
**---- Input:	d0 = UserNr						----*
**----		d1 = Enabled(0) oder Disabled(1)			----*
**----		d2 = US_Class						----*
**----		d3 = Command						----*
**----		d4 = ArgList						----*
**----		d5 = Result						----*
**----									----*
**---- OutPut:	a0 = Adresse der Struktur				----*
**----		d0 = Fehler						----*
**---------------------------------------------------------------------------*
*		movem.l	d0-a4,-(a7)
*		move.l	d6,d0
*		moveq	#0,d1
*		move.l	#USClass_Activate,d2
*		moveq	#0,d3
*		moveq	#0,d4
*		moveq	#0,d5
*		jsr	A5SendeOneMessage(a5)
*		movem.l	(a7)+,d0-a4
*
*.NoOpen:	lsl.l	#1,d4
*.NoOpen2:	addq.l	#1,d6
*		dbf	d3,.FindEngine
*.NoMore:	clr.l	MerkCloseAll(a5)
*		clr.b	OnAllWindowsClosed(a5)
*		jsr	A5SetMenuStrip(a5)
*		jsr	A5CreatePlayName(a5)
*		jmp	A5ScrollNewText(a5)
*		
*	*	LA0	LNr_IOpenAllUser(pc),a0
*	*	jmp	A5ScrollNewText(a5)
*	*	jmp	A5CopyScrollTextToArexxPuffer(a5)
*


*------------------------------------------------------------------------*
*-------------------------------- SetSong -------------------------------*
*------------------------------------------------------------------------*
*------------------------------------------------------------------------*
* Testformate:	TFMX	StartNr: 0-xx
*		HP7	StartNr: 1-
*
* Problem: da der User nicht merken soll, ob die Songnummern bei 0 oder 1
*	   anfangen, mssen diese ab 1 beginnen und im EP korrigiert werden
*
SetSong:	cmp.l	#Mode_Config,TestBits(a5)
		bne.s	.NoConfig
		move.l	d2,ConfigSongNr(a5)
		moveq	#0,d0
		rts

.NoConfig:	move.l	d2,d4
		tst.l	PlayerAdr(a5)
		beq.w	NoModuleLoaded
		tst.w	NextSongOn(a5)
		beq.w	FunktionNotEnabled

		move.l	#DTP_SubSongRange,d0
		jsr	A5FindTag(a5)
		beq.s	.SubFirst

		subq.w	#1,d4
		add.w	EPG_FirstSnd(a5),d4

		*tst.w	EPG_FirstSnd(a5)	;aus Argument=1 mach SongNr 0
		*bne.s	.NoZeroTest
		*subq.l	#1,d4

.NoZeroTest:	cmp.w	EPG_FirstSnd(a5),d4
		blt.s	SetSongErr
		cmp.w	MaxSubSong(a5),d4
		bhi.w	SetSongErr

.SubFirst:	sub.w	EPG_FirstSnd(a5),d4
		move.l	d4,EPG_Arg1(a5)

		*move.w	MaxSubSong(a5),d0
		*add.w	MinSubSong(a5),d0
		*cmp.w	d0,d4
		*bhs.w	SetSongErr

	*------- Keine SongUmschaltung im Player ------*
SetNoSubSongRange:jsr	A5StopInterrupt(a5)
		jsr	A5EndSound(a5)
		move.l	EPG_Arg1(a5),d0
		blt	SetSongErr
		add.w	EPG_FirstSnd(a5),d0
		move.w	d0,DTG_SndNum(a5)
		bra.b	NextSongInit

SetSongErr:	moveq	#EPR_InvalidNr,d0
		jmp	A5ScrollNewFehler(a5)

*-------------------------------------------------------------------------*
*-------------------------------- NextSong -------------------------------*
*-------------------------------------------------------------------------*
NextSong:	tst.l	PlayerAdr(a5)
		beq.w	NoModuleLoaded
		tst.w	NextSongOn(a5)
		beq.w	FunktionNotEnabled

		tst.w	MaxSubSong(a5)
		beq.s	.NoSubSongRange
		*move.l	#DTP_SubSongRange,d0
		*jsr	A5FindTag(a5)
		*beq.s	.NoSubSongRange

		tst.b	OnRandomSong(a5)
		bne.w	SetRandomSong

		move.w	DTG_SndNum(a5),d0
		cmp.w	MaxSubSong(a5),d0
		bhs.w	NextSongErr

.NoSubSongRange:move.w	DTG_SndNum(a5),d4
		move.l	#DTP_NextSong,d0
		jsr	A5CallUp(a5)
		beq.s	.NoNextSong
		cmp.w	DTG_SndNum(a5),d4
		bne.w	PrintSongNr
		addq.w	#1,DTG_SndNum(a5)
		bra.w	PrintSongNr

	*------- Keine SongUmschaltung im Player -------*
.NoNextSong:	jsr	A5StopInterrupt(a5)
		jsr	A5EndSound(a5)
		addq.w	#1,DTG_SndNum(a5)
NextSongInit:	jsr	A5InitSound(a5)
		bne.w	TestError
		jsr	A5StartInterrupt(a5)

		jsr	A5PrintSongNr(a5)
AllesOk:	moveq	#0,d0
		rts

NextSongErr:	clr.w	OnlyEinmal(a5)
		moveq	#-1,d0
Return2		rts

*--------------------------------------------------------------------------*
*--------------------------------- PrevSong -------------------------------*
*--------------------------------------------------------------------------*
PrevSong:	tst.l	PlayerAdr(a5)
		beq.w	NoModuleLoaded

		tst.w	NextSongOn(a5)
		beq.w	FunktionNotEnabled	;NextSongErr

		tst.w	MaxSubSong(a5)
		beq.s	.NoSubSongRange
		*move.l	#DTP_SubSongRange,d0
		*jsr	A5FindTag(a5)
		*beq.s	.NoSubSongRange

		tst.b	OnRandomSong(a5)
		bne.s	SetRandomSong

.NoSubSongRange:move.w	MinSubSong(a5),d1
		move.w	DTG_SndNum(a5),d4
		beq.s	NextSongErr
		cmp.w	d1,d4
		ble.s	NextSongErr

		move.l	#DTP_PrevSong,d0
		jsr	A5CallUp(a5)
		beq.s	.NoPrevSong
		cmp.w	DTG_SndNum(a5),d4
		bne.s	PrintSongNr
		subq.w	#1,DTG_SndNum(a5)
		bra.s	PrintSongNr

	*------- Keine SongUmschaltung im Player ------*
.NoPrevSong:	jsr	A5ClearTextWindow(a5)
		jsr	A5StopInterrupt(a5)
		jsr	A5EndSound(a5)
		subq.w	#1,DTG_SndNum(a5)
		jsr	A5InitSound(a5)
		bne.w	TestError
		jsr	A5StartInterrupt(a5)

PrintSongNr:
	*------------- Userprogramme benachrichten --------------*
		moveq	#USClass_NewSong,d0
		jsr	A5SendeAllMessage(a5)

		moveq	#0,d0
		move.w	DTG_SndNum(a5),d0
		sub.w	EPG_FirstSnd(a5),d0
		addq.w	#1,d0
		move.l	d0,ScrollArgs(a5)
		LA0	LNr_Song
		jmp	A5PrintText(a5)


*---------------- Der nchste Sub-Song wird zufllig gesucht ------------*
SetRandomSong:	bsr.s	SetRandomSongNr
		bra.w	SetNoSubSongRange


SetRandomSongNr:move.l	#DTP_SubSongRange,d0
		jsr	A5FindTag(a5)
		beq.s	.ItsAll

		move.l	MerkSubSongs(a5),d0
		move.w	MaxSubSong(a5),d1
		sub.w	MinSubSong(a5),d1
		move.l	d1,d3

		moveq	#0,d2
.SetBits:	bset	d1,d2
		dbf	d1,.SetBits

		cmp.l	d0,d2
		beq.s	.ItsAll

.Nochmal:	moveq	#0,d1
		moveq	#0,d2
		move.b	$dff007,d1
	;	jsr	A5Delay(a5)
		move.b	$dff006,d2
		add.w	d2,d1
	;	jsr	A5Delay(a5)
		move.b	$dff014,d2
		add.w	d2,d1
		and.w	#$1f,d1

		*cmp.w	MaxSubSong(a5),d1
		cmp.w	d3,d1
		bhi.s	.Nochmal

		btst	d1,d0
		bne.s	.Nochmal
		bset	d1,d0
		move.l	d0,MerkSubSongs(a5)
	*	addq.l	#1,d1
		move.l	d1,EPG_Arg1(a5)
		rts

.ItsAll:	clr.l	MerkSubSongs(a5)
		tst.w	OnlyEinmal(a5)
		beq.s	SetRandomSongNr
		clr.w	OnlyEinmal(a5)
ThisReturn:	rts

**----------------------------------------------------------------------------*
**-------------------------- Down Prev/Next Pattern --------------------------*
**----------------------------------------------------------------------------*
*DownNextPattern:lea	NextPatternGadget,a4
*		moveq	#0,d4
*		bra.s	DownTypePattern
*DownPrevPattern:lea	PrevPatternGadget,a4
*		moveq	#1,d4
*DownTypePattern:tst.l	PlayerAdr(a5)
*		beq.w	NoModuleLoaded
*
*	*--- Erstmal testen, ob entsprechende Zeit abgelaufen ist ---*
*		moveq	#10,d3
*.WaitFirst:	jsr	A5Delay(a5)
*		btst	#7,13(a4)
*		beq.s	.Return
*		dbf	d3,.WaitFirst
*
*	*-------------- Nun Next/PrevPattern aufrufen ---------------*
*.RetryCall:	movem.l	d4/a4,-(a7)
*		tst.l	d4
*		bne.s	.CallPrev
*		bsr.s	NextPattern
*		bra.s	.PatternOk
*.CallPrev:	bsr.s	PrevPattern
*.PatternOk:	;lea	ArexxPuffer(a5),a0
*		;jsr	A5PrintText(a5)
*		movem.l	(a7)+,d4/a4
*		moveq	#3,d3
*.Wait:		jsr	A5Delay(a5)
*		dbf	d3,.Wait
*
*	*----------- Testen, ob Gadget noch gedrckt ist ------------*
*		btst	#7,13(a4)
*		bne.s	.RetryCall
*
*.Return:	moveq	#0,d0
*		rts


*----------------------------------------------------------------------------*
*--------------------------- Prev/Next Pattern ------------------------------*
*----------------------------------------------------------------------------*
NextPattern:	move.l	#DTP_NextPatt,d0
		bra.s	TypePattern
PrevPattern:	move.l	#DTP_PrevPatt,d0
TypePattern	tst.l	PlayerAdr(a5)
		beq.w	NoModuleLoaded
		tst.b	PlayOn(a5)
		bne.s	.PlayOk
		movem.l	d0-a6,-(a7)
		jsr	A5StartInterrupt(a5)
		movem.l	(a7)+,d0-a6
.PlayOk:	jsr	A5CallUp(a5)
		beq.w	FunctionNotImplemented
		move.l	#EP_GetPositionNr,d0
		jsr	A5CallUp(a5)
		beq.w	AllesOK

		move.l	d0,ScrollArgs(a5)
		LA0	LNr_CurrentPosition
		jmp	A5PrintText(a5)

*----------------------------------------------------------------------------*
*-------- Dir neu laden, falls eingestellt und Fehlermeldung ausgeben -------*
*----------------------------------------------------------------------------*
*LoadNewDir:	tst.b	OnAutoDir(a5)
*		beq.s	.Warten
*		jsr	A5LoadAutoDir(a5)
*.Warten:	jmp	A5Warten(a5)
*

LoadAutoDir:	jsr	A5LoadDirIn(a5)
		jsr	A5ClearMouse(a5)
		cmp.w	#EPR_DirNotChanged,d0
		beq.w	ThisReturn
		tst.l	d0
		bne.w	ToScrollNewFehler
		LA0	LNr_NewDirLoaded
		jmp	A5ScrollNewText(a5)

*--------------------------------------------------------------------------*
LoadParentDir:	move.l	EPG_FirstFileStruct(a5),d0
		beq.s	.Return
		move.l	d0,a0
		moveq	#0,d0
		move.b	EFP_Flags(a0),d0
		btst	#EFPF_Parent,d0
		beq.s	.Return

		jsr	A5ParentDir(a5)
		jsr	A5LoadAutoDir(a5)
.Return:	rts


	;*******************************************
	;**** Load File To Mem			****
	;**** d0=MemEigenschaften		****
	;**** d1=0 Bit	0=1 keine CheckRoutine	****
	;****		1=1 keine Anzeige im Win****
	;****		2=1 Nr nicht erhhen	****
	;****		3=1 keine Path creieren	****
	;**** a1=Pfad ohne Filename		****
	;**** a2=Adresse des Namens		****
	;*******************************************
LoadFile:	*clr.w	ScrollVerbot(a5)		;Scrollen erlauben
		move.l	a1,LoadFilePath(a5)
		move.b	d1,LoadFileBytes(a5)
		move.l	a2,LoadFileName(a5)
		clr.b	LHALoaded(a5)

	*----- Soll Module erst in FastRam geladen werden ???? ------*
		btst	#0,LoadFileBytes(a5)
		bne.w	.NoLoadToFast
		tst.b	OnLoadFast(a5)
		beq.s	.NoLoadToFast
		moveq	#1,d0				;Fastmem eingestellt
.NoLoadToFast:	move.l	d0,d3
		move.l	FormatLoad_Tags(a5),d0
		beq.s	.NoFormatMem
		move.l	d0,a6
		move.l	#FL_Memtype,d0
		jsr	A5FindTag2(a5)
		beq.s	.NoFormatMem
		move.l	a6,d3
.NoFormatMem:	move.l	d3,d0
		move.l	d0,LoadFileMem(a5)

		btst	#1,d1				;Keine Anzeige ????
		bne.s	.Load2

	*-------- Print "Now Loading .... " --------*
		LA0	LNr_Loading
		move.l	a1,-(a7)
		move.l	a2,a1
		jsr	A5GetFileName(a5)
		move.l	a1,ScrollArgs(a5)
		jsr	A5PrintText(a5)
		move.l	(a7)+,a1
.Load2:		btst	#3,LoadFileBytes(a5)		;keinen Phad creieren ?
		bne.w	LoadFile2

	*-------------- Mal schauen nach LHA-Dir --------------*
		btst	#2,LoadFileBytes(a5)	;NR nicht erhhen=files laden
		bne.w	.Load2_MakePfad

		tst.l	Formatload_PlayerAdr(a5)
		bne.w	.Load2_MakePfad

		*--- Wenn hier eine Null zurckkommt, ist das aktuelle Dir ---*
		*--- ein Archiv und das angewhlte File ist ein Eintrag    ---*
		*--- im Archiv -----------------------------------------------*
		move.l	a1,a0
		*lea	PathPuffer(a5),a0		;wenn es sich um ein
		jsr	A5TestAufArchive(a5)		;LHA-Archiv handelt,darf
		beq.s	.ExtractLHA2			;kein Pfad creiert werden

		*--- rekursiv in Verzeichnisse absteigen, um auch folgende ---*
		*--- Mglichkeiten abzutesten ---*
		*--- "Modules:Crunchertests/Amiga_Modules.lha/tests/mod.toll"
		jsr	A5TestaufsteigendArchive(a5)
		bne.s	.Testekomplett
		move.l	a0,-(a7)
		clr.b	-1(a1)
		move.l	a1,a0
		lea	LHADirPuffer(a5),a1
		move.w	#DirPufferSize-2,d1
		jsr	A5StringCopy2(a5)
		lea	LHADirPuffer(a5),a1
		jsr	A5MakeCorrectDir(a5)
		lea	LHADirPuffer(a5),a0
		jsr	A5BerechStringSize(a5)
		lea	(a0,d0.w),a1
		move.l	MenuFileName(a5),a0
		jsr	A5StringCopy2(a5)
		lea	LHADirPuffer(a5),a1
		move.l	a1,MenuFileName(a5)
		move.l	(a7)+,a1
		bra.s	.ExtractLHA2


		*--- Hier wird getestet, ob das angegebene Module ein ---*
		*--- Archive ist ---*
.Testekomplett:	jsr	A5CreateLoadPath(a5)
		lea	PathPuffer(a5),a0		;handelt es sich um ein
		jsr	A5TestAufArchive(a5)		;LHA-Archiv
		bne.s	LoadFile2
.MalSehen:

		tst.b	OnExtractFirstModule(a5)	*Nur erstes Module ent-
		bne.s	.ExtractFirstModule		*packen --> Suchen


		*--- Wenn hier eine Null zurckkommt, ist der aktuelle Ein- --*
		*--- trag ein neues Archiv -----------------------------------*
		*---- File im PDMenu angewhlt --> LHA Als Dir scannen -----*
		lea	PathPuffer(a5),a0
		lea	DirPuffer(a5),a1
		move.w	#DirPufferSize-2,d1
		jsr	A5StringCopy2(a5)
		jsr	A5LoadDirIn(a5)
		tst.l	d0
		bne.s	.Error
		moveq	#EPR_ArchiveScanned,d0
.Error:		rts

.ExtractLHA:	tst.b	OnExtractFirstModule(a5)	*Nur erstes Module ent-
		bne.s	.ExtractFirstModule		*packen --> Suchen

.ExtractLHA2:	movem.l	d2/a1,-(a7)
		jsr	A5ExtractArchiveEntry(a5)
		movem.l	(a7)+,d2/a1
		tst.l	d0
		beq.w	.LHAExtracted
		rts



.ExtractFirstModule:
		movem.l	d2/a1,-(a7)
		lea	PathPuffer(a5),a1		;handelt es sich um ein
		jsr	A5ExtractFirstArchiveEntry(a5)
		movem.l	(a7)+,d2/a1
		tst.l	d0
		beq.s	.LHAExtracted
		rts

.LHAExtracted:	move.b	#1,LHALoaded(a5)
		bra.s	LoadFile2

*		btst	#2,LoadFileBytes(a5)	;NR nicht erhhen=files laden
*		bne.s	.Load2_CP
*		tst.b	KeyOn(a5)		;nicht registriert=Files laden
*		beq.s	.Load2_CP
*
*		lea	PathPuffer(a5),a0		;wenn es sich um ein
*		jsr	A5TestAufArchive(a5)		;LHA-Archiv handelt,darf
*		beq.s	LoadFile2			;kein Pfad creiert werden
*
*
*.Load2_CP:	jsr	A5CreateLoadPath(a5)
*		tst.b	KeyOn(a5)
*		beq.s	LoadFile2
*		lea	PathPuffer(a5),a0		;handelt es sich um ein
*		jsr	A5TestAufArchive(a5)		;LHA-Archiv
*		bne.s	LoadFile2
*		lea	PathPuffer(a5),a0
*		lea	DirPuffer(a5),a1
*		move.w	#DirPufferSize-2,d1
*		jsr	A5StringCopy2(a5)
*		jsr	A5LoadDirIn(a5)
*		moveq	#EPR_LHAArchivScanned,d0
*		rts

;**** LoadFileBytes Bit0=Soll Gecheckt werden
;****		    Bit1=Soll Was ins Fenster geprintet werden
;****		    Bit2=Soll SubLFNummer erhht werden
;****		    Bit3=Soll Ein Phad zusammengebastelt werden
;**** LoadFileMem   = MemEigenschaften 

.Load2_MakePfad:jsr	A5CreateLoadPath(a5)
LoadFile2:	clr.l	LastLoadError(a5)
		clr.l	PPSize(a5)		;Kennung(Kein PP-File)
		clr.l	File(a5)		;Kennung Kein Mem
		clr.l	FileSizeNeu(a5)		*neu
		clr.b	CrunchKennung(a5)
		clr.l	EPG_ChkSegment(a5)
		clr.l	RippStart(a5)
		clr.l	RippSize(a5)
		clr.w	SchonGerippt(a5)

		btst	#2,LoadFileBytes(a5)
		bne.s	.NoInc
		moveq	#EPR_BufferFull,d0
		cmp.l	#MaxLoadFiles-1,LFNummer(a5)
		bhi.w	.Return2

		addq.l	#1,LFNummer(a5)
	;	jsr	A5ClearProTemps(a5)

.NoInc:		lea	PathPuffer(a5),a2
		btst	#3,LoadFileBytes(a5)
		beq.s	.UsePathName
		move.l	LoadFilePath(a5),a2

.UsePathName:	btst	#0,LoadFileBytes(a5)
		bne.w	.NoClrPlayerAdr
		clr.l	LoadPlayerAdr(a5)

	*----- Alten TextPuffer lschen ------*
.NoClrPlayerAdr:lea	TextPuffer(a5),a1
		lea	1(a1),a0
		clr.b	(a1)
		move.w	#FirstBytes-2,d1
		jsr	A5Copytext2(a5)

		move.l	a2,d5

	*------------ Lock holen ---------*
.NoLoad:	clr.w	LoadPlayerKennung(a5)
		move.l	d5,XPK_FileName


		*--- Extract Files fr ExtLoading aus Archiven ---*
		btst	#2,LoadFileBytes(a5)
		bne.s	.NoExtractExtLoad
		cmp.l	#1,LFNummer(a5)
		beq.s	.NoExtractExtLoad
		tst.b	LHALoaded(a5)
		beq.s	.NoExtractExtLoad

		*- Pfad im Archiv rauskriegen -*
	*- a1=Archivepfad
	*- Menufilename = Adr im Archiv
		move.l	MenuFileName(a5),-(a7)
		move.l	ExtLoad_LastDirAdr(a5),a0
		clr.b	(a0)
		lea	DirPuffer(a5),a0
		jsr	A5BerechStringSize(a5)
		lea	PathPuffer(a5),a0
		lea	1(a0,d0.w),a0
		move.l	a0,MenuFilename(a5)

		lea	DirPuffer(a5),a1
		jsr	A5ExtractArchiveEntry(a5)
		move.l	(a7)+,MenuFileName(a5)
		tst.l	d0
		bne.w	.Return2
		lea	PathPuffer(a5),a2
		move.l	a2,XPK_Filename


.NoExtractExtLoad:

*-----------------------------------------------*
* alte LHADir-Routine & Extract aus Archive ?
*		tst.b	LHALoaded(a5)
*		bne.s	.KeinLHA
*	bra.s	.keinlha
*		btst	#2,LoadFileBytes(a5)
*		bne.s	.KeinLHA
*
*	*--- Falls File in LHA-Archiv mssen die Namen wieder ausein ---*
*	*--- geflckt werden !!!				     ---*
*		move.l	d5,a0
*		jsr	A5ParentArchiveDir(a5)		;a0=adresse wo
*		bne.s	.KeinLHA
*		move.b	(a0),d2
*		clr.b	(a0)+
*		move.l	a0,a1
*
*		lea	PathPuffer(a5),a0
*		btst	#3,LoadFileBytes(a5)
*		beq.s	.LHAUsePathName
*		move.l	LoadFilePath(a5),a0
*.LHAUsePathName:jsr	A5TestAufArchive(a5)
*		bne.s	.KeinLHA2
*
*
*		movem.l	d2/a1,-(a7)
*		move.l	a1,a0
*		jsr	A5ExtractArchiveEntry(a5)
*		movem.l	(a7)+,d2/a1
*		tst.l	d0
*		beq.w	LoadFile2
*		cmp.b	#-1,d0
*		bne.w	.Return2
*
*.KeinLHA2:	move.b	d2,-(a1)

.KeinLHA:

*-----------------------------------------------------*
* nicht benutzte LoadSegroutine (funktioniert)
* wird nach dem Rippen gemacht.
*
		*----- Segmente laden und testen -----*
*		btst	#0,LoadFileBytes(a5)
*		bne.w	.NoSegment
*		move.l	XPK_FileName(pc),d1
*		jsr	A5LoadSegment(a5)
*		beq.w	.NoSegment
*		move.l	d0,EPG_ChkSegment(a5)
*		move.l	d0,File(a5)
*
*		clr.l	LoadPlayerStart(a5)
*		clr.l	LoadPlayerAdr(a5)	;Kennung(No LoadPlayer found)
*.Seg_Retry:	move.l	#EP_CheckSegment,d4
*		jsr	A5CheckSoundsys(a5)
*		beq.w	.Seg_Found
*
*		*--- Im Segment rippen ---*
*		*-----------------------------------------------------------------------------*
*		* Aufruf ber Taglist. Falls Module gefunden, werden a0/a1/d1 entsprechend ge-*
*		* setzt. Die Ripperstruct wird zum spteren ExtRipp gebraucht.
*		*-----------------------------------------------------------------------------*
*		* Input: a0=MemAdr
*		*	 d0=MemSize
*		*	 a1=Hook fr Crunchanzeige
*		*	 d5=Tag
*		* Output:d0=Error oder NULL
*		*	 a0=ModuleAdr
*		*	 d1=ModuleSize
*		*	 a1=RipperStruct
*		move.l	EPG_ChkSegment(a5),a0
*		moveq	#-1,d0
*		move.l	#EUT_RippSegment,d5
*		jsr	A5Rippen(a5)
*		bne.s	.UnloadSegment
*		move.l	a0,RippStart(a5)
*		move.l	a0,RippStruct(a5)
*		move.l	d1,RippSize(a5)
*		move.l	#-1,FileSizeNeu(a5)
*		move.l	EPG_ChkSegment(a5),File(a5)
*		clr.l	EPG_ChkSegment(a5)
*		bra.w	.GeripptesEinbinden
*
*
*
*		*-- normaler Player wir Ron Klaren wurde gefunden --*
*.Seg_Found:	tst.l	LoadPlayerAdr(a5)
*		bne.s	.Seg_NoMerk
*		move.l	a6,LoadPlayerAdr(a5)
*.Seg_NoMerk:	move.l	#-1,FileSizeNeu(a5)
*		bra.w	.NoError
*
*
*
*.UnloadSegment:	move.l	d0,-(a7)
*		clr.l	FileSizeNeu(a5)
*		clr.l	LoadPlayerAdr(a5)
*		clr.l	LoadPlayerStart(a5)
*		clr.l	File(a5)
*		move.l	EPG_ChkSegment(a5),d1
*		asr.l	#2,d1
*		subq.l	#1,d1
*		move.l	DTG_Dosbase(a5),a6
*		jsr	_LVOUnLoadSeg(a6)
*		clr.l	EPG_ChkSegment(a5)
*		moveq	#0,d6
*		moveq	#0,d7
*		move.l	(a7)+,d0
*		cmp.w	#EPR_FunctionAborted,d0
*		beq.w	ScrollNewFehler
*.NoSegment


	*------- Normales File laden ------*
		move.l	XPK_FileName(pc),d1
		moveq	#-2,d2
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOLock(a6)
		move.l	d0,d6
		beq.w	OpenError
	*------- FileInfoBlock laden -------*
		move.l	d0,d1
		lea	InfoBlock(a5),a0
		move.l	a0,d2
		jsr	_LVOExamine(a6)
	*----------- Lock freigeben ---------*
		move.l	d0,-(a7)
		move.l	d6,d1
		jsr	_LVOUnlock(a6)
		move.l	(a7)+,d0
		tst.l	d0
		beq.w	OpenError
				
		*--- Testen, ob Startsong erforderlich ist ---*
		btst	#0,LoadFileBytes(a5)
		bne.w	.NoStartSongTest
		lea	InfoBlock(a5),a0
		jsr	A5GetStartSong(a5)
		move.l	d0,LFStartSong(a5)
.NoStartSongTest:


		lea	TextPuffer(a5),a0
		tst.b	KeyOn-TextPuffer(a0)		;KeyON modifiziert ???
		beq.s	.KeyOk
		move.l	Key_Struct-TextPuffer(a0),d0
		beq.w	JaGuru3


.KeyOk:		moveq	#0,d7
		move.l	InfoBlock+124(a5),d1

		btst	#0,LoadFileBytes(a5)
		bne.w	.NoShortTest

		cmp.l	#50,d1
		blo.w	ErrModuleToShort

.NoShortTest:	move.l	d1,FileSizeNeu(a5)
		move.l	d1,FileLoadSize(a5)

		btst	#0,LoadFileBytes(a5)
		bne.w	.NoSetChkSize
		move.l	d1,DTG_ChkSize(a5)

	*-------------- File ffnen ------------*
.NoSetChkSize:	move.l	a2,d1
		move.l	#1005,d2
		jsr	_LVOOpen(a6)
		move.l	d0,d7
		beq.w	OpenError		
	*------------ 1500 Bytes lesen ---------*
		move.l	#FirstBytes,d3
		lea	TextPuffer(a5),a0
		move.l	a0,d2
		move.l	d7,d1
		jsr	_LVORead(a6)
		moveq	#-1,d1
		cmp.l	d1,d0
		beq.w	ReadError1		
		move.l	d0,d6			;Anzahl merken

	*-------- Auf LHA-Files checken ---------*
	*----- d0=0 -->	LHA vorhanden(File laden-*
	*-----   =-1 -> Kein LHA-File, Weiter   -*
	*-----   =Error -> 
		*jsr	A5ExtraktFirstLHA(a5)
		*beq.w	LoadFile2
		*cmp.b	#-1,d0
		*bne.w	.Return2

	*-------------- Erster Test fr Player-Checker --------------*
	* 
		move.l	#FirstBytes,d0		;
		move.l	FileSizeNeu(a5),d1	;
		lea	TextPuffer(a5),a0	;
		jsr	A5PlayerChecker(a5)	;


	*-------- Auf PP-Dateien checken --------*
		moveq	#12,d3
		lea	TextPuffer(a5),a0
		moveq	#7,d1

	*---------- Stonecracker S404 -----------*
		move.l	8(A0),d0		;DecrunchedSize
		move.l	12(a0),d2		;CrunchedSize
		add.l	#12,d2
		cmp.l	#"S404",(a0)		;StoneCracker V4.10
		beq.w	.NoSeekPP
		subq.l	#1,d1

		move.l	8(a0),d0		;DecrunchSize
		move.l	4(a0),d2
		add.l	d3,d2
		cmp.l	#"PACK",(a0)				= 6
		beq.w	.NoSeekPP

		subq.l	#1,d1

	*--------- Test auf CrunchMania-Files --------*
		jsr	A5TestAufCRMFile(a5)
		bne.w	.NoSeekPP

	*-------------- Test Fimp-Files --------------*
		move.l	4(a0),d0		;DecrunchSize
		move.l	8(a0),d2		;CrunchedSize
		add.l	#50,d2
		subq.l	#1,d1
		cmp.l	#"IMP!",(a0)		;Fimp-Imploded = 4
		bne.s	.NoImploded
.Crm:		move.l	d0,FileSizeNeu(a5)
		move.b	d1,CrunchKennung(a5)
		cmp.l	FileLoadSize(a5),d2
		blo.w	ErrModuleToShort
		cmp.l	d2,d0			;Entpackt Kleiner als gepackt ?
		blo.w	ErrorDecrunch		;ja dann Fehler
		bra.w	.NoCheck

	*------- Test auf StoneCracker V4.0 Files -----*
.NoImploded:
		move.l	8(A0),d2		;CrunchedSize
		add.l	#12,d2
		subq.l	#1,d1
		cmp.l	#"S401",(a0)		;StoneCracker V4.01 = 3
		beq.w	.NoSeekPP

	*------------- Test auf LH-Library ------------*
		subq.l	#1,d1
		cmp.l	#"SFHD",(a0)		;LH = 2
		beq.w	.NoSeekPP
		cmp.l	#"SFCD",(a0)		;LH2= 2
		beq.w	.NoSeekPP

	*--------- Test auf Powerpacker-Files ---------*
		subq.l	#1,d1
		jsr	TestAufPP
		tst.l	d0
		bne.w	.PP

	*-------- Check auf XPK-gepackte Dateien --------*
		cmp.l	#"XPKF",(a0)
		bne.w	.Check
		move.l	4(a0),d2		;Module krzer als gepackt
		addq.l	#8,d2

		cmp.l	FileSizeNeu(a5),d2
		blo.w	ErrModuleToShort

	*-------- Check auf XPK-Gepackte Files --------*
	*-------- Informationen ber die Datei bekommen -------*
		clr.b	CrunchKennung(a5)
		clr.l	XPK_ErrorKennung(a5)

		lea	XPK_ExamineBuf(a5),a1
		lea	1(a1),a0
		clr.b	(a1)
		moveq	#94-2,d1
		jsr	A5CopyText2(a5)

		lea	XPK_ExamineBuf(a5),a0
		lea	XPK_TagList(pc),a1
		move.l	EPG_XPKBase(a5),d0
		beq.w	ErrorXPKNotFound
		move.l	d0,a6
		jsr	_LVOXPKExamine(a6)
		move.l	d0,XPK_ErrorKennung(a5)
		bne.w	ErrorXPKDecrunch2


		move.l	XPK_ExamineBuf+38(a5),d0
		btst	#0,d0				;Password needed
		beq.w	.NoPassword
		jsr	A5GetPassword(a5)
.NoPassword	move.l	XPK_ExamineBuf+4(a5),d3		;XF_ULen
		move.l	d3,FileSizeNeu(a5)

		clr.l	XPKHelpAdr(a5)

		move.l	LoadFileMem(a5),d4		;Chip-Mem besorgen

		btst	#0,LoadFileBytes(a5)
		beq.w	.NoXPKAdd2000

	*-- Speicher allokieren, in den nachher das File kopiert wird --*
		move.l	d3,XPKHelpSize(a5)
		jsr	A5AllocModuleMem(a5)
		beq.w	ErrorAllocMem
		move.l	d0,XPKHelpAdr(a5)


		moveq	#1,d4			;Egal-Mem
.NoXPKAdd2000:	add.l	#MemDrauf,d3
		jsr	A5AllocModuleMem(a5)
		beq.w	ErrorAllocMem
		move.l	d0,File(a5)

	*------------- XPK-File ffnen ---------*
.RetryRead:	lea	XPK_TagList(pc),a1
		move.l	XPK_ExamineBuf+38(a5),d0
		btst	#0,d0			;Password needet
		beq.s	.NoPassword2
		lea	XPK_PTagList(pc),a1
		lea	PasswordPuffer(a5),a0
		move.l	a0,4(a1)
.NoPassword2:	lea	XPKHandle(a5),a0
		clr.l	(a0)
		move.l	EPG_XPKBase(a5),a6
		jsr	_LVOXPKOpen(a6)
		move.l	d0,XPK_ErrorKennung(a5)
		bne.w	.CloseXPK

	*------- Print "XDecrunching ...." --------*
		LA0	LNr_Decrunching
		move.l	LoadFileName(a5),a1
		jsr	A5GetFileName(a5)
		move.l	a1,ScrollArgs(a5)
		sub.l	a1,a1
		jsr	A5InitCrunchDisplay(a5)
	*	jsr	A5PrintText(a5)


	*--------------- Datei lesen -------------*

		moveq	#0,d5
		move.l	XPK_ExamineBuf+4(a5),d4		;XF_ULen
	move.l	d4,d2
	divu	#1000,d2
	ext.l	d2
	addq.l	#1,d2

.NextChunk:	moveq	#-1,d0
		move.l	XPKHandle(a5),a0
		move.l	EPG_XPKBase(a5),a6
		move.l	File(a5),a1
		add.l	d5,a1
		jsr	_LVOXPKRead(a6)
		tst.l	d0
		ble.s	.CloseXPK2

		move.l	d5,d3
		add.l	d0,d5


		move.l	d5,d0
		divu	d2,d0
		ext.l	d0
		jsr	A5FillCrunchDisplay(a5)
		tst.l	d0
		bne.s	.AbortXPK

		cmp.l	d5,d4
		bhi.s	.NextChunk
		bra.b	.CloseXPK

.AbortXPK:	move.b	#1,FunctionAbortedNow(a5)
		moveq	#-19,d0


	*----------- Probefile closen ------------*
.CloseXPK2:	*move.l	d0,-(a7)
		*tst.l	d0
		*blt.s	.XPK_DiError
		add.l	d5,d0
		*divu	d2,d0
		*ext.l	d0
		*jsr	A5FillCrunchDisplay(a5)
.XPK_DiError:	*move.l	(a7)+,d0

		tst.l	PlayerAdr(a5)
		beq.s	.NoModule
		cmp.l	#-7,d0
		bne.s	.NoModule			;Error=No mem
		movem.l	d0-a6,-(a7)
		jsr	A5AllesRaus(a5)
		jsr	A5GuiChanged(a5)
		movem.l	(a7)+,d0-a6
		move.l	XPKHandle(a5),a0
		move.l	EPG_XPKBase(a5),a6
		jsr	_LVOXPKClose(a6)		
		bra.w	.RetryRead

.NoModule:	move.l	d0,XPK_ErrorKennung(a5)
.CloseXPK:	move.l	XPKHandle(a5),a0
		move.l	EPG_XPKBase(a5),a6
		jsr	_LVOXPKClose(a6)		

	*------ wenn erforderlich in XPKHelpMem kopieren ------*
		move.l	XPKHelpAdr(a5),d0
		beq.s	.XPKNoHelp
		move.l	d0,a1
		move.l	File(a5),a0
		move.l	FileSizeNeu(a5),d0
		jsr	A5CopyMemQuick(a5)
		move.l	File(a5),a1
		move.l	FileSizeNeu(a5),d0
		add.l	#MemDrauf,d0
		ExecBase
		jsr	_LVOFreeMem(a6)
		move.l	XPKHelpAdr(a5),File(a5)
		move.l	XPKHelpSize(a5),FileSizeNeu(a5)


.XPKNoHelp:	move.l	#1000,d0
		jsr	A5FillCrunchDisplay(a5)

		bsr	CloseDatei
		clr.l	XPKHelpAdr(a5)
		clr.l	XPKHelpSize(a5)

		jsr	A5RemoveCrunchDisplay(a5)

		tst.l	XPK_ErrorKennung(a5)
		beq.w	.FileDecrunched			;DTP_Check2
		bra.w	ErrorXPKDecrunch


*------------------------------- old Routine ---------------------------------*
*------------------------------- old Routine ---------------------------------*
*------------------------------- old Routine ---------------------------------*
;		move.l	LoadFileMem(a5),d4		;Chip-Mem besorgen
;
;		btst	#0,LoadFileBytes(a5)
;		bne.w	.NoXPKAdd2000
;		add.l	#MemDrauf,d3
;.NoXPKAdd2000:	jsr	A5AllocModuleMem(a5)
;		beq.w	ErrorAllocMem
;		move.l	d0,File(a5)
;
;	*------------- XPK-File ffnen ---------*
;.RetryRead:	lea	XPK_TagList(pc),a1
;		move.l	XPK_ExamineBuf+38(a5),d0
;		btst	#0,d0			;Password needet
;		beq.s	.NoPassword2
;		lea	XPK_PTagList(pc),a1
;		lea	PasswordPuffer(a5),a0
;		move.l	a0,4(a1)
;.NoPassword2:	lea	XPKHandle(a5),a0
;		clr.l	(a0)
;		move.l	EPG_XPKBase(a5),a6
;		jsr	_LVOXPKOpen(a6)
;		move.l	d0,XPK_ErrorKennung(a5)
;		tst.l	d0
;		bne.s	.CloseXPK
;
;	*------- Print "XDecrunching ...." --------*
;		lea	IDecrunch-1(pc),a0
;		move.l	LoadFileName(a5),a2
;		lea	TextPuffer(a5),a1
;		moveq	#0,d0
;		jsr	A5LCopyText(a5)
;		move.l	a2,a0
;		jsr	A5StringCopy(a5)
;		clr.b	(a1)
;		lea	TextPuffer(a5),a0
;		jsr	A5PrintText(a5)	;Print "Now Decrunch..."
;
;	*--------------- Datei lesen -------------*
;		moveq	#0,d5
;		move.l	XPK_ExamineBuf+4(a5),d4		;XF_ULen
;.NextChunk:	moveq	#-1,d0
;		move.l	XPKHandle(a5),a0
;		move.l	EPG_XPKBase(a5),a6
;		move.l	File(a5),a1
;		add.l	d5,a1
;		jsr	_LVOXPKRead(a6)
;		tst.l	d0
;		ble.s	.CloseXPK2
;		move.l	d5,d3
;		add.l	d0,d5
;		cmp.l	d5,d4
;		bhi.s	.NextChunk
;		bra.b	.CloseXPK
;
;	*----------- Probefile closen ------------*
;.CloseXPK2:	tst.l	PlayerAdr(a5)
;		beq.s	.NoModule
;		cmp.l	#-7,d0
;		bne.s	.NoModule			;Error=No mem
;		movem.l	d0-a6,-(a7)
;		jsr	A5AllesRaus(a5)
;		jsr	A5GuiChanged(a5)
;		movem.l	(a7)+,d0-a6
;		move.l	XPKHandle(a5),a0
;		move.l	EPG_XPKBase(a5),a6
;		jsr	_LVOXPKClose(a6)		
;		bra.w	.RetryRead
;
;.NoModule:	move.l	d0,XPK_ErrorKennung(a5)
;.CloseXPK:	move.l	XPKHandle(a5),a0
;		move.l	EPG_XPKBase(a5),a6
;		jsr	_LVOXPKClose(a6)		
;		tst.l	XPK_ErrorKennung(a5)
;		beq.w	.FileDecrunched			;DTP_Check2
;		bra.w	ErrorXPKDecrunch
;

	*------------- Zeiger setzen ---------------*
.PP		cmp.l	#FirstBytes,d6		;wenn weniger als 1000 Bytes
		beq.s	.SeekPP
		move.l	InfoBlock+124(a5),d0		;Lnge holen
		subq.l	#4,d0
		add.l	d0,a0			;Position auf Decrunchlnge
		moveq	#0,d0
		move.b	(a0)+,d0
		rol.l	#8,d0
		move.b	(a0)+,d0
		rol.l	#8,d0
		move.b	(a0)+,d0

		move.l	FileSizeNeu(a5),d2		;<<-!!
		bra.s	.NoSeekPP

.SeekPP		moveq	#1,d0			;Kennung PP
		move.l	d7,d1
		moveq	#-5,d2
		moveq	#1,d3
		jsr	_LVOSeek(a6)
		moveq	#-1,d1
		cmp.l	d1,d0			;alte Position,nein--> Error
		beq.w	ReadError1
	*--------------- PP-Lnge laden ----------------*
		move.l	#4,d3			;Lnge in FileInfoPuffer laden
		lea	InfoBlock(a5),a0
		move.l	a0,d2
		move.l	d7,d1
		jsr	_LVORead(a6)
		cmp.l	d3,d0
		bne.w	ReadError1		;Lnge geladen

	*---------- Zeiger wieder zurck setzen ----------*
		move.l	d7,d1
		move.l	#FirstBytes,d2
		moveq	#-1,d3
		jsr	_LVOSeek(a6)
		moveq	#-1,d3
		cmp.l	d3,d0			;alte Position,nein--> Error
		beq.w	ReadError1

		move.l	Infoblock(a5),d0
		and.l	#$ffffff,d0
		moveq	#1,d1
		move.l	FileSizeNeu(a5),d2

	*------- d2 = Crunched Size ---------*
.NoSeekPP:
		cmp.l	FileSizeNeu(a5),d2
		bhi.w	ErrModuleToShort
		move.b	d1,CrunchKennung(a5)
		move.l	d0,PPSize(a5)

	*-------- Mem zum Entpacken besorgen --------*
		move.l	LoadFileMem(a5),d4		;Chip-Mem besorgen
		move.l	PPSize(a5),d3
		btst	#0,LoadFileBytes(a5)
		bne.w	.NoAdd2000_2
		add.l	#MemDrauf,d3

	;	tst.b	OnLoadFast(a5)			;LoadFast ??????????
	;	beq.s	.NoAdd2000_2
	;	moveq	#1,d4

.NoAdd2000_2:	jsr	A5AllocModuleMem(a5)
		beq.w	ErrorAllocMem
		move.l	d0,PPAdr(a5)			;Adr des PPFiles im Mem
		moveq	#1,d4				;Egal-Mem fr PPLoading
		bra.w	.HoleLadeMem



	*------------------ Soundsystem checken -----------------*
	*---------------------- DTP-Check 1 ---------------------*
	*--------------------------------------------------------*
.Check:		moveq	#0,d0
		btst	#0,LoadFileBytes(a5)
		bne.w	.NoCheck
		clr.l	LoadPlayerStart(a5)
.Check1_2:	clr.l	LoadPlayerAdr(a5)	;Kennung(No LoadPlayer found)
.Check1_3:	lea	TextPuffer(a5),a0
		move.l	a0,DTG_ChkData(a5)

		move.l	Formatload_PlayerAdr(a5),d0
		beq.s	.NoFL
		move.l	d0,a6
		move.l	#EP_Check7,d0
		jsr	A5FindTag2(a5)
		beq.s	.NoFL
		movem.l	d1-a6,-(a7)
		move.l	FormatLoad_Tags(a5),a0
		jsr	(a6)
		movem.l	(a7)+,d1-a6
		tst.l	d0
	*bne.s	.NoFL		;bei Formatload nur den angewhlten Player
	bne.w	.NoCheck	;laden
		move.l	FormatLoad_PlayerAdr(a5),a6
		bra.s	.Check1_Ext

.NoFL:		clr.l	LoadPlayerStart(a5)
		clr.l	LoadPlayerAdr(a5)	;Kennung(No LoadPlayer found)
		move.l	#DTP_Check1,d4
		jsr	A5CheckSoundsys(a5)
		bne.s	.EP_Check3

	*------- Externe Load-Routine benutzen -------*
.Check1_Ext:	moveq	#-1,d0				;Test auf CustomSong
		cmp.l	FileSizeNeu(a5),d0		;bei -1 in FileSizeNeu
		beq.w	.NoError			;LoadPlayersize nicht
	move.l	FileSizeNeu(a5),d3
	movem.l	d3-a6,-(a7)
		move.l	a6,LoadPlayerAdr(a5)		;verndern
		move.b	LoadFilebytes(a5),d0
		move.b	d0,MerkLoadFileBytes(a5)

		jsr	A5NewExtLoad(a5)
		*move.l	#DTP_ExtLoad,d0
		*moveq	#0,d3
		*jsr	A5CallUp3(a5)

		move.b	MerkLoadFileBytes(a5),d1
		move.b	d1,LoadFilebytes(a5)
	movem.l	(a7)+,d3-a6
	move.l	d3,FileSizeNeu(a5)
		tst.l	d2
		beq.s	.NoError			;Externload gefunden

		tst.l	d0				;nein-> normal laden
		beq.w	.NoError
		jsr	A5FreeExtLoad(a5)
	move.l	d3,FileSizeNeu(a5)
		bra.w	.Check1_3

.NoError:	jsr	A5CloseDatei(a5)
		moveq	#-1,d0
		cmp.l	FileSizeNeu(a5),d0			;fr MDPuffer
		beq.w	LF_NoCheck2		;.NoCheck2
		clr.l	FileSizeNeu(a5)
		btst	#2,LoadFileBytes(a5)
		bne.s	.ExtNoInc
		subq.l	#1,LFNummer(a5)
.ExtNoInc:	moveq	#0,d0
.Return2:	rts

	*--------------------------------------------------------*
	*-------------- Hier auf EP_Check3 testen ---------------*
	*--------------------------------------------------------*
.EP_Check3:	tst.l	d7			;Falls d7=7 (keine Datei)
		beq.w	UnknownSS2		;UNknown Format
		moveq	#0,d0
		btst	#0,LoadFileBytes(a5)
		bne.w	.NoCheck
		clr.l	LoadPlayerStart(a5)
.EP_Check1_2:	clr.l	LoadPlayerAdr(a5)	;Kennung(No LoadPlayer found)
.EP_Check1_3:	lea	TextPuffer(a5),a0
		move.l	a0,DTG_ChkData(a5)
		move.l	#EP_Check3,d4
		jsr	A5CheckSoundsys(a5)
		beq.s	.EP_Check3Ok

	*--------------------------------------------------------*
	*-------------- Hier auf EP_Check4 testen ---------------*
	*--------------------------------------------------------*
		lea	TextPuffer(a5),a0
		move.l	a0,DTG_ChkData(a5)
		move.l	#EP_Check4,d4
		jsr	A5CheckSoundsys(a5)
		bne.s	.noEPCheck4
		moveq	#2,d0				;ChipMem
		bra.s	.EP_Check4Ok

.EP_Check3Ok:	moveq	#1,d0
.EP_Check4Ok:	move.l	a6,LoadPlayerAdr(a5)		;verndern
		move.l	d0,LoadFileMem(a5)
		bra.b	.NoClrLAdr
.noEPCheck4:
		moveq	#0,d0
		btst	#0,LoadFileBytes(a5)
		bne.w	.NoCheck
		clr.l	LoadPlayerStart(a5)
		clr.l	LoadPlayerAdr(a5)	;Kennung(No LoadPlayer found)
		lea	TextPuffer(a5),a0
		move.l	a0,DTG_ChkData(a5)
		move.l	#EP_Check6,d4
		jsr	A5CheckSoundsys(a5)
		beq	.Check1_Ext

	*----- Hier fortsetzen des Ladens -----*
.NoCheck:	btst	#0,LoadFileBytes(a5)
		bne.w	.NoClrLAdr
		clr.l	LoadPlayerAdr(a5)	;Kennung(No LoadPlayer found)
.NoClrLAdr:	move.l	LoadFileMem(a5),d4

	*---------- Module-Mem holen ---------*
.HoleLadeMem:	move.l	FileSizeNeu(a5),d3
		btst	#0,LoadFileBytes(a5)
		bne.w	.NoAdd2000

	;	tst.b	OnLoadFast(a5)			;LoadFast
	;	beq.s	.NoLoadFast			;LoadFast
	;	moveq	#1,d4				;LoadFast
.NoLoadFast:	move.b	CrunchKennung(a5),d0
		beq.s	.Add2000
		cmp.b	#4,d0
		blt.s	.NoAdd2000
		cmp.b	#6,d0				;ST-Pack
		beq.s	.NoAdd2000
.Add2000:	add.l	#MemDrauf,d3
.NoAdd2000:	jsr	A5AllocModuleMem(a5)
		beq.w	ErrorAllocMem
		move.l	d0,File(a5)


	*------- Bisher geladene Daten in allocierten Speicher copieren ------*
		lea	TextPuffer(a5),a1
		move.l	d0,a0
		move.l	d6,d1
		subq.l	#1,d1
		jsr	A5CopyText2(a5)

	*----- Restlichen Daten reinladen -----*
		move.l	d6,d0
		cmp.l	#FirstBytes,d0
		blt.s	.AllReadIn
		move.l	FileLoadSize(a5),d3
		sub.l	d0,d3
		move.l	d7,d1
		move.l	a0,d2			;a0=Ende des umcopierten Mems
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVORead(a6)
		moveq	#-1,d1
		cmp.l	d1,d0
		beq.w	ReadError1
		
	*-------- Datei schlieen ---------*
.AllReadIn:	jsr	A5CloseDatei(a5)
		tst.b	CrunchKennung(a5)	;XFDMaster erledigt den Rest
		beq.w	.CheckUncrunched	;.DTP_Check2

		btst	#1,LoadFileBytes(a5)
		bne.s	.NoType

		cmp.b	#4,CrunchKennung(a5)
		bne.s	.Normal
		LA0	LNr_Exploding
		bra.s	.Normal2
.Normal		LA0	LNr_Decrunching
.Normal2:	move.l	LoadFileName(a5),a1
		jsr	A5GetFileName(a5)
		move.l	a1,ScrollArgs(a5)
		jsr	A5PrintText(a5)	

	*------ PP-File ??? ------*
.NoType:	move.b	CrunchKennung(a5),d0
		subq.b	#1,d0
		bne.s	.NoPP
		jsr	A5PPDecrunch(a5)
		bra.s	.EntPackt

	*------ LH-File ??? ------*
.NoPP:		subq.b	#1,d0
		bne.s	.NoLH
		jsr	A5LHDecrunch(a5)
		bra.s	.EntPackt

	*----- Stone-File ??? -----*
.NoLH:		subq.b	#1,d0
		bne.s	.NoStone
		jsr	A5StoneDecrunch(a5)
		bra.s	.Entpackt

	*------- Imploder-File ??? ------*
.NoStone:	subq.b	#1,d0
		bne.s	.NoImpl
		jsr	A5Exploding(a5)
		bra.s	.FileDecrunched			;DTP_Check2

	*------- Crunch-Mania-File ------*
.NoImpl:	subq.b	#1,d0
		bne.w	.NoCrm
		move.l	CRMDeCrunch(a5),a0
		jsr	(a0)				;bsr.w	Crm_Decrunch
		bra.s	.Entpackt

	*------ Test auf ST-SongPacker ("PACK") ------*
.NoCRM:		subq.b	#1,d0
		bne.w	.NoPack
		jsr	A5DecrunchPack(a5)
		bra.w	.Entpackt3
.noPack
	*------ Test auf Stonecracker S404 ------*
		jsr	A5DecrunchSTC404(a5)
		bra.s	.entpackt3

.EntPackt:	tst.b	d0
		bne.w	ErrorDecrunch
.EntPackt3:	jsr	A5FreeLoadModule2(a5)
		move.l	PPAdr(a5),File(a5)
		move.l	PPSize(a5),FileSizeNeu(a5)
		clr.l	PPSize(a5)
		clr.l	PPAdr(a5)

.CheckUncrunched:
*******************************************************************************
* 1.  Call "xfdAllocBufferInfo()".					      *
* 2.  Get file size, allocate buffer with that size and load file to buffer.  *
* 3.  Call "xfdRecogBuffer()" with xfdbi_SourceBuffer and xfdbi_SourceBufLen  *
*     initialized.							      *
* 4.  Check xfdbi_PackerFlags for XFDPFB_PASSWORD, go on with 6. if not set.  *
* 5.  Get password (maximum length is xfdbi_MaxSpecialLen) and store a pointer*
*     to it in xfdbi_Special.						      *
* 6.  Initialize xfdbi_TargetBufMemType and call "xfdDecrunchBuffer()".	      *
* 7.  Release memory of xfdbi_SourceBuffer.				      *
* 8.  Work with decrunched file.					      *
* 9.  Release memory in xfdbi_TargetBuffer.				      *
* 10. Call "xfdFreeBufferInfo()".					      *
*******************************************************************************
* Bis hier her wurden alle Files entpackt, nun nochmal Test auf XFDMaster-    *
* Library, ob noch einmal gepackt ???					      *
* Dadurch doppeltes entpacken mglich					      *
*******************************************************************************
* Wenn nicht erwnscht, XFD-Check dann Label FileDecrunched zu Label	      *
* EndlichDecrunched:, und Label 					      *
*******************************************************************************
	*--------------- XFDCrunchInfo allokieren -------------*
.FileDecrunched:tst.b	OnXFDDecrunch(a5)
		beq.w	.EndlichDecrunched

	*----------- XFDMaster-Library ffnen ----------*
		LA1	LNr_XFDMasterName
		lea	EPG_XFDMasterBase(a5),a3
		moveq	#33,d0
		jsr	A5OpenLib(a5)
		beq.w	.EndlichDecrunched
		move.l	d0,a6
		jsr	_LVOXFDAllocBufferInfo(a6)
		move.l	d0,a4
		tst.l	d0
		beq.w	.EndlichDecrunched

	*------------- XFDMaster-Check aufrufen ---------------*
		move.l	EPG_XFDMasterBase(a5),a6
		move.l	a4,a0
		cmp.w	#37,20(a6)
		blo.s	.XFDKeineFlags	 ;Diesen Eintrag gibts erst ab V37
		move.w	#1,48(a0)		;auch externe Decruncher 
.XFDKeineFlags:	move.l	File(a5),XFDBI_SourceBuffer(a0)
		move.l	FileSizeNeu(a5),XFDBI_SourceBufLen(a0)
		movem.l	d2-a6,-(a7)
		jsr	_LVOXFDRecogBuffer(a6)
		movem.l	(a7)+,d2-a6
		tst.l	d0
		bne.w	.XFDPacker

	*------------- XFDCrunchInfo freigeben ----------------*
.XFDNoPacker:	move.l	a4,a1
		jsr	_LVOXFDFreeBufferInfo(a6)
		bra.w	.EndlichDecrunched

	*------------------------------------------------------*
	*--- Handelt es sich wirklich um einen DatenPacker ----*
	*--- BITDEF	XFDPF,DATA,2	= data file packer ----*
	*------------------------------------------------------*
.XFDPacker:	move.l	a4,a0
		moveq	#0,d1
		move.w	XFDBI_PackerFlags(a0),d1
		*btst	#2,d1			;Auf DatenPacker testen
		*beq.w	.XFDNoPacker
		btst	#4,d1			;Auf Password testen
		beq.s	.XFDNoPassword

	*---------------- Password eingeben -------------------*
		moveq	#0,d0
		move.w	XFDBI_MaxSpecialLen(a4),d0
		cmp.w	#199,d0
		blo.s	.XFDPLOk
		move.w	#199,d0
.XFDPLOk:	lea	PasswordPuffer(a5),a1
		clr.b	(a1,d0.w)
		movem.l	d0-a6,-(a7)
		jsr	A5GetPassword2(a5)
		movem.l	(a7)+,d0-a6
		lea	PasswordPuffer(a5),a1
		move.l	a1,XFDBI_Special(a4)

	*---------- Printe "Decrunching ..." -------------*
.XFDNoPassword:	btst	#1,LoadFileBytes(a5)
		bne.s	.XFDNoType
		LA0	LNr_Decrunching
		move.l	LoadFileName(a5),a1
		jsr	A5GetFileName(a5)
		move.l	a1,ScrollArgs(a5)
		jsr	A5PrintText(a5)

.XFDNoType:	move.l	a4,a0
		moveq	#1,d0			;Egal-Mem
		move.l	d0,XFDBI_TargetBufMemType(a0)
		move.l	EPG_XFDMasterBase(a5),a6
		movem.l	d2-a6,-(a7)
		jsr	_LVOXFDDecrunchBuffer(a6)
		movem.l	(a7)+,d2-a6
		tst.l	d0
		bne.s	.Ok
		bsr.w	XFDFreeDecrunched
		bra.w	ErrorDecrunch

	*----------- Memory vom LoadFile freigeben ------------*
.Ok		move.l	File(a5),a1
		move.l	FileSizeNeu(a5),d0
		btst	#0,LoadFileBytes(a5)
		bne.w	.XFDNoAdd2000
		add.l	#MemDrauf,d0
.XFDNoAdd2000:	ExecBase
		jsr	_LVOFreeMem(a6)


	*--------- neuen Speicher fr File allokieren ---------*
		move.l	LoadFileMem(a5),d4
		move.l	a4,a0
		move.l	XFDBI_TargetBufSaveLen(a0),d3
		move.l	d3,FileSizeNeu(a5)
		btst	#0,LoadFileBytes(a5)
		bne.w	.XFDNoAdd2000_2
		add.l	#MemDrauf,d3
.XFDNoAdd2000_2:move.l	a4,-(a7)
		jsr	A5AllocModuleMem(a5)
		move.l	(a7)+,a4
		move.l	d0,File(a5)
		tst.l	d0
		bne.s	.XFDModOk

	*----------------- Kein Speicher mehr -----------------*
		bsr.w	XFDFreeDecrunched
		bra.w	ErrorAllocMem


	*------------------- File umkopieren ------------------*
.XFDModOk:	move.l	a4,a1
		move.l	XFDBI_TargetBuffer(a1),a0
		move.l	XFDBI_TargetBufSaveLen(a1),d0
		move.l	File(a5),a1
		jsr	A5CopyMemQuick(a5)

	*----------------- Target-Mem freigeben ---------------*
		bsr.w	XFDFreeDecrunched
		bra.w	.FileDecrunched			;nochmal testen



*------------- Nun mten wohl alle Entpacker erkannt sein ----------------*
.EndlichDecrunched:btst	#0,LoadFileBytes(a5)
		bne.w	LFDTP_Check2

		tst.l	LoadPlayerAdr(a5)
		bne.w	lfDTP_Check2

	*-------------- Erster Test fr Player-Checker --------------*
	* 
		move.l	FileSizeNeu(a5),d0	;
		move.l	d0,d1			;
		move.l	File(a5),a0		;
		jsr	A5PlayerChecker(a5)	;

		tst.b	OnSaveT(a5)
		beq.w	LFDTP_Check2


*		move.w	#keyon-100,d0		;+-+-
*		tst.b	100(a5,d0.w)		;konnte kein Label mehr
*		beq.w	LFDTP_Check2		;unterbringen, also habe



	*------- Variablen richtig setzen -------*
	;***********************************
	;****	Pfad aufbauen		****
	;**** LoadFilePath=Diradresse	****
	;**** a2=Filename		****
		move.l	DTG_FileArrayPtr(a5),TFilePtr(a5)
		move.l	DTG_DirArrayPtr(a5),TDirPtr(a5)
		LA0	LNr_TName
		move.l	a0,DTG_DirArrayPtr(a5)
		move.l	a0,LoadFilePath(a5)
		LA2	LNr_EPTName
		addq.l	#2,a2
		move.l	a2,DTG_FileArrayPtr(a5)
		jsr	A5CreateLoadPath(a5)

		move.l	Formatload_PlayerAdr(a5),d0
		beq.w	.okDTP_Check1normal
		move.l	d0,a6
		move.l	#EP_Check8,d0
		jsr	A5FindTag2(a5)
		bne.w	.OpenTError

		move.l	Formatload_PlayerAdr(a5),a6
		move.l	#EP_Check7,d0
		jsr	A5FindTag2(a5)
		beq.w	.OpenTError
		*movem.l	d1-a6,-(a7)
		*move.l	FormatLoad_Tags(a5),a0
		*jsr	(a6)
		*movem.l	(a7)+,d1-a6
		*tst.l	d0
		*bne.w	.OpenTError
		move.l	FormatLoad_PlayerAdr(a5),a6
		bra.s	.okDTP_Check1


.okDTP_Check1normal:
		clr.l	LoadPlayerStart(a5)
		move.l	File(a5),DTG_ChkData(a5)
		move.l	FileSizeNeu(a5),DTG_ChkSize(a5)
		move.l	#DTP_Check1,d4
		jsr	A5CheckSoundsys(a5)
		beq.s	.okDTP_Check1

		clr.l	LoadPlayerStart(a5)
		move.l	File(a5),DTG_ChkData(a5)
		move.l	FileSizeNeu(a5),DTG_ChkSize(a5)
		move.l	#EP_Check6,d4
		jsr	A5CheckSoundsys(a5)
		bne.w	.OpenTError
.okDTP_Check1
		move.l	a6,LoadPlayerAdr(a5)

*		move.w	#keyon-100,d0		;+-+-
*		tst.b	100(a5,d0.w)		;konnte kein Label mehr
*		bne.w	.SaveT_registriert	;unterbringen, also habe
*		move.w	#LNr_TR_RegisteredNormal,d0
*		jsr	A5NervRequest2(a5)
.SaveT_registriert:
						;ich es einfach so gemacht

		move.l	File(a5),a0
		move.l	FileSizeNeu(a5),d0
		jsr	A5SaveNachT(a5)
		bne.s	.OpenTError

*		clr.b	NachTGesaved(a5)
*		LA0	LNr_EPTName
*		move.l	a0,d1
*		move.l	#1006,d2
*		move.l	DTG_Dosbase(a5),a6
*		jsr	_LVOOpen(a6)
*		move.l	d0,d7
*		beq.s	.OpenTError
*		move.l	d0,d1
*		move.b	#1,NachTGesaved(a5)
*		move.l	File(a5),d2
*		move.l	FileSizeNeu(a5),d3
*		jsr	_LVOWrite(a6)
*		move.l	d0,d6
*		move.l	d7,d1
*		jsr	_LVOClose(a6)
*		jsr	A5FreeLoadModule2(a5)
*		moveq	#0,d7
*		move.l	LoadPlayerAdr(a5),a6
*		cmp.l	d6,d3
*		bne.s	.OpenTError

		move.l	Formatload_PlayerAdr(a5),d0
		beq.w	.Check1_Ext
		move.l	d0,a6
		move.l	#EP_Check7,d0
		jsr	A5FindTag2(a5)
		beq.w	.OpenTError
		movem.l	d1-a6,-(a7)
		move.l	FormatLoad_Tags(a5),a0
		jsr	(a6)
		movem.l	(a7)+,d1-a6
		move.l	Formatload_PlayerAdr(a5),a6
		tst.l	d0
		beq.w	.Check1_Ext



.OpenTError:	move.l	TDirPtr(a5),DTG_DirArrayPtr(a5)
		move.l	TDirPtr(a5),LoadFilepath(a5)
		move.l	TFilePtr(a5),a2
		move.l	a2,DTG_FileArrayPtr(a5)
		jsr	A5CreateLoadPath(a5)

		clr.l	LoadPlayerAdr(a5)
		lea	PathPuffer(a5),a0
		move.l	a0,DTG_PathArrayPtr(a5)

	*------------------------------------------------------------*
	*------------------------------------------------------------*
	*--- Soundsystem checken bei geladenen/entpackten Dateien ---*
	*------------------------------------------------------------*
	*------------------------------------------------------------*
LFDTP_Check2:	jsr	A5DeleteTFile(a5)
		clr.b	CrunchKennung(a5)
		move.l	File(a5),a4
		moveq	#0,d0
		btst	#0,LoadFileBytes(a5)
		bne.w	.NoCheck2

		tst.l	LoadPlayerAdr(a5)
		bne.w	.NoCheck2

	*--------------------- Auf EP_Check8 testen ---------------------*
	* Bei EP_Check8 wird im Grunde kein Check vorgenommen. Dieser    *
	* Aufruf dient lediglich zum Initialisieren der LoadDaten und zum*
	* Nachweis, dass der entsprechende Player auch Formatload unter- *
	* sttzt.							 *
	*----------------------------------------------------------------*
		move.l	Formatload_PlayerAdr(a5),d0
		beq.s	.NoFL
		move.l	d0,a6
		move.l	#EP_Check8,d0
		jsr	A5FindTag2(a5)
		beq.s	.NoFL

		movem.l	d1-a6,-(a7)
		move.l	FormatLoad_Tags(a5),a0
		jsr	(a6)
		movem.l	(a7)+,d1-a6
		tst.l	d0
	*bne.s	.NoFL			;bei formatload nur den angegebenen
	bne.w	UnknownPPFormat		;Player benutzen

		move.l	FormatLoad_PlayerAdr(a5),a6
		bra.w	.PlayerFound

	*--------------------- Auf EP_Check5 testen ---------------------*
	* Bei EP_Check5 ist der Speichertyp egal, daher hier immer ein	 *
	* Check	!!! Desweiteren ist der Speichertyp bereits festgelegt ! *
	*----------------------------------------------------------------*
.NoFL:		tst.l	Formatload_PlayerAdr(a5)
		bne.w	UnknownPPFormat

		clr.l	LoadPlayerStart(a5)
		move.l	File(a5),DTG_ChkData(a5)
		move.l	FileSizeNeu(a5),DTG_ChkSize(a5)
		move.l	#EP_Check5,d4
		jsr	A5CheckSoundsys(a5)
		beq.w	.PlayerFound

	*--------------------- Auf EP_Check3 testen ---------------------*
	* Bei EP_Check3 ist der Speichertyp egal, daher hier immer ein	 *
	* Check	!!! Diese Funktion ist eingebaut, damit bei eingeschalte *
	* tem LoadFast auch gepackte Module erkannt werden, wo der Player*
	* nur EP_Check3 und DTP_Check2 untersttzt.			 *
	*----------------------------------------------------------------*
		clr.l	LoadPlayerStart(a5)
		move.l	File(a5),DTG_ChkData(a5)
		move.l	FileSizeNeu(a5),DTG_ChkSize(a5)
		move.l	#EP_Check3,d4
		jsr	A5CheckSoundsys(a5)
		beq.w	.PlayerFound

	*--------------------- Auf DTP_Check2 testen --------------------*
		clr.l	LoadPlayerStart(a5)
		move.l	File(a5),DTG_ChkData(a5)
		move.l	FileSizeNeu(a5),DTG_ChkSize(a5)
		move.l	#DTP_Check2,d4
		jsr	A5CheckSoundsys(a5)
		bne.w	FileRippen			UnknownPPFormat
		move.l	a6,LoadPlayerAdr(a5)

	*----- Jetzt mu das Module in den Chip-Ram kopiert werden ------*
	*------- Memtyp feststellen -------*
		move.l	File(a5),a1
		ExecBase
		jsr	_LVOTypeOfMem(a6)
		btst	#1,d0			;es handelt sich bereits um
		bne.w	.NoCheck2		;Chipram
		move.l	FileSizeNeu(a5),d0
		add.l	#MemDrauf,d0
		moveq	#3,d1			;ChipRam Public holen
		jsr	_LVOAllocMem(a6)
		tst.l	d0
		bne.s	.ok_got_mem

		tst.b	NotRausWerf(a5)		;aktuelles Mod drin lassen ?
		bne	ErrorAllocMem2

		movem.l	d0-a6,-(a7)
		jsr	A5AllesRaus(a5)
		jsr	A5GuiChanged(a5)
		movem.l	(a7)+,d0-a6

		move.l	FileSizeNeu(a5),d0
		add.l	#MemDrauf,d0
		moveq	#3,d1			;ChipRam Public holen
		ExecBase
		jsr	_LVOAllocMem(a6)
		tst.l	d0
		beq	ErrorAllocMem2
.ok_got_mem
	*-------- Speicher besorgen ------*
		move.l	d0,a4
		move.l	d0,a1
		move.l	File(a5),a0
		move.l	FileSizeNeu(a5),d0
		add.l	#MemDrauf,d0
		jsr	A5CopyMemQuick(a5)

	*--- alten Speicher freigeben ----*
		move.l	File(a5),a1
		move.l	FileSizeNeu(a5),d0
		add.l	#MemDrauf,d0
		move.l	4,a6
		jsr	_LVOFreeMem(a6)
		move.l	a4,File(a5)

	*--- Nochmal checken, weil in einigen Playern in der Checkroutine ---*
	*---- Sprungadressen gemerkt werden, die ja jetzt nicht da sind -----*
	*--------------------- Auf DTP_Check2 testen --------------------*
		clr.l	LoadPlayerAdr(a5)
		clr.l	LoadPlayerStart(a5)
		move.l	File(a5),DTG_ChkData(a5)
		move.l	FileSizeNeu(a5),DTG_ChkSize(a5)
		move.l	#DTP_Check2,d4
		jsr	A5CheckSoundsys(a5)
		bne.w	UnknownPPFormat
.PlayerFound:	move.l	a6,LoadPlayerAdr(a5)


.NoCheck2:
LF_NoCheck2:	btst	#2,LoadFileBytes(a5)
		bne.s	LF_NoInc2

		move.l	LFNummer(a5),d0
		subq.l	#1,d0
		lea	LFPuffer(a5),a0
		rol.l	#4,d0
		add.l	d0,a0
		move.l	File(a5),(a0)+
		move.l	FileSizeNeu(a5),(a0)+

*

	*-- LFPuffer
	*-- nderungen, wegen Ripper & Decruncher
	*-- 1.l = Adr des Modules/Files
	*-- 2.l = Size des Modules/Files
	*-- 3.l = Adr des Memorystarts
	*-- 4.l = AllocSize
		move.l	File(a5),(a0)+			;AllocAdr
		moveq	#0,d0
		btst	#0,LoadFileBytes(a5)
		bne.w	.NoLFMemDrauf
		cmp.l	#-1,FileSizeNeu(a5)		;Segment !!!
		beq.s	.NoLFMemDrauf
		move.l	#MemDrauf,d0
.NoLFMemDrauf:	add.l	FileSizeNeu(a5),d0
		move.l	d0,(a0)				;AllocSize
*


LF_NoInc2:	btst	#0,LoadFileBytes(a5)
		bne.w	LF_Return
		
		move.b	LoadFilebytes(a5),d0
		move.b	d0,MerkLoadFileBytes(a5)

		move.l	LoadPlayerAdr(a5),a6

		jsr	A5NewExtLoad(a5)
		*move.l	#DTP_ExtLoad,d0
		*moveq	#0,d3
		*jsr	A5CallUp3(a5)
		beq.w	LF_Return

 *wegen AddListData & Freelistdata
 move.l LFPuffer(a5),File(a5)
 move.l	LFPuffer+4(a5),FileSizeNeu(a5)
		move.b	MerkLoadFileBytes(a5),d1
		move.b	d1,LoadFilebytes(a5)
		tst.l	d0
		bne.w	LF_Check2_2		:bne.s	ErrorExtLoad
LF_Return:	moveq	#0,d0
		rts




	*-------- ExtLoading ist schiefgegangen -----*
LF_Check2_2:	move.l	d0,ExtErrNumber(a5)
		jsr	A5FreeExtLoad(a5)	;event. geladene files freigebe

	;************************************************************
	;**** Bei internen Playern ist das weiterchecken sinnlos ****
	;**** auerdem kann so eine ErrLoadingInstr-Meldung raus ****
	;**** gegeben werden					 ****
	;************************************************************
		move.l	LoadPlayerAdr(a5),a6
		move.l	#DTP_InternalPlayer,d0
		jsr	A5FindTag2(a5)
		beq.s	.NoInternal

	*-------- Module rausschmeien --------*
.ErrExt:	subq.l	#1,LFNummer(a5)
		jsr	A5FreeLoadModule(a5)
		move.l	ExtErrNumber(a5),d0
		cmp.l	#MaxErrorNr,d0
		blo.s	.ErrOK
		moveq	#EPR_ErrorExtLoad,d0
.ErrOK:		rts

	;********************************************
	;**** Bei externen Playern weiterchecken ****
	;********************************************
.NoInternal:	move.l	File(a5),DTG_ChkData(a5)
		move.l	FileSizeNeu(a5),DTG_ChkSize(a5)
		move.l	#DTP_Check2,d4
		jsr	A5CheckSoundsys(a5)
		beq.s	.JaDochNoch

		move.l	File(a5),DTG_ChkData(a5)
		move.l	FileSizeNeu(a5),DTG_ChkSize(a5)
		move.l	#EP_Check5,d4
		jsr	A5CheckSoundsys(a5)
		bne.w	.ErrExt				UnknownPPFormat
.JaDochNoch:	move.l	a6,LoadPlayerAdr(a5)
		bra.w	LF_NoInc2



		*--- Im Segment rippen ---*
		*-----------------------------------------------------------------------------*
		* Aufruf ber Taglist. Falls Module gefunden, werden a0/a1/d1 entsprechend ge-*
		* setzt. Die Ripperstruct wird zum spteren ExtRipp gebraucht.
		*-----------------------------------------------------------------------------*
		* Input: a0=MemAdr
		*	 d0=MemSize
		*	 a1=Hook fr Crunchanzeige
		*	 d5=Tag
		* Output:d0=Error oder NULL
		*	 a0=ModuleAdr
		*	 d1=ModuleSize
		*	 a1=RipperStruct
FileRippen:	tst.w	SchonGerippt(a5)
		bne.w	RP_TestList

		bsr	ConvertModule
		beq.w	LFDTP_Check2
		

*-----------------------------------------------------------------------------*
* Routinen, die alle Engines anhpft, die vom angegebenen Type sind active    *
* sind und den entsprechenden Tag haben.				      *
*-----------------------------------------------------------------------------*
* Input: d0/d1/d2/a0/a1/a2=Args						      *
*	 d3=Enginetype							      *
*	 d4=FirstEngineNr (bei der das Suchen beginnt)			      *
*	 d5=Tag								      *
* Output:d0/d1/d2/a0/a1/a2=Args						      *
*	 d3=Error oder NULL						      *
*	 d4=EngineNr							      *
*-----------------------------------------------------------------------------*

		*--- Ist es vielleicht ne Liste? ---*
RP_TestList:	jsr	A5LoadProgrammList(a5)	;ne Liste braucht nicht gerippt
		beq.w	UnknownPPFormat		;werden

		moveq	#0,d4
RP_NextRipper:	clr.l	Rippstruct(a5)
		move.l	LoadFileName(a5),a1
		jsr	A5GetFileName(a5)
		move.l	a1,ScrollArgs(a5)
		move.l	File(a5),a0
		move.l	FileSizeNeu(a5),d0
		move.l	#EUT_Ripp,d5
		jsr	A5Rippen(a5)
		bne.w	.LoadSegment
		move.l	a0,RippStart(a5)
		move.l	d1,RippSize(a5)
		move.l	a1,RippStruct(a5)
		*bra.s	.GeripptesEinbinden

		*--- ExtRipp ----*
		move.l	RippStruct(a5),a0
		move.l	ERPSS_EngineNr(a0),d4
		moveq	#EUTY_Ripper,d3			*Type
		move.l	#EUT_RippExt,d5
		jsr	A5UserCallUp5(a5)
		tst.l	d3
		bne.s	.GeripptesEinbinden
		tst.l	d0				*Error oder NULL
		bne.w	.LoadSegment


*-----------------------------------------------------------------------------*
* Die im Ripper gefundenen Module mssen hier in die Eagleplayermerkzellen ge-*
* speichert werden. Problem ist u.a. ExtLoad
*-----------------------------------------------------------------------------*
.GeripptesEinbinden:

		*--- angegebenen Player laden ---*
		move.l	RippStruct(a5),a1
		move.l	ERPSS_Tags(a1),d0
		beq.s	.RP_NoPlayerLoad
		move.l	d0,a6
		move.l	#RPT_Playername,d0
		jsr	A5FindTag2(a5)
		beq.s	.RP_NoPlayerLoad

		lea	EPG_FirstPlayerStruct(a5),a4
.RP_NextPlayer:	move.l	(a4),d0
		beq.s	.RP_LoadPlayer
		move.l	d0,a4
		lea	PlayersFile(a5),a0
		jsr	A5GetplayerName(a5)	a1=Playername
		move.l	a6,a0
		jsr	A5StrCMP3(a5)
		bne.s	.RP_Nextplayer
		tst.l	EPPL_TagList(a4)
		bne.s	.RP_NoPlayerLoad

.RP_LoadPlayer:	move.l	a6,a0
		lea	PlayersFile(a5),a1
		jsr	A5StringCopy(a5)
		move.b	#1,BatchLoading(a5)
		jsr	A5LoadOnePlayer(a5)

.RP_NoPlayerLoad:	move.l	RippStruct(a5),a1
		move.l	ERPSS_ModuleName(a1),d0
		beq.s	.NoModuleName
		move.l	d0,a0			;eventuellen Player laden !!!
		jsr	A5LoadNeededPlayer(a5)

.NoModuleName:	move.l	RippStruct(a5),a1
		move.l	ERPSS_FileSize(a1),d0
		move.l	ERPSS_FileSize(a1),d1
		move.l	ERPSS_FilePtr(a1),a0
		jsr	A5PlayerChecker(a5)



		*-- Player fr Module finden und auf richtigen Speicher --*
		*-- typ achten. --*

	*--------------------- Auf EP_Check5 testen ---------------------*
	* Bei EP_Check5 ist der Speichertyp egal, daher hier immer ein	 *
	* Check	!!! Desweiteren ist der Speichertyp bereits festgelegt ! *
	*----------------------------------------------------------------*
		clr.l	LoadPlayerStart(a5)
		move.l	RippStart(a5),DTG_ChkData(a5)
		move.l	RippSize(a5),DTG_ChkSize(a5)
		move.l	#EP_Check5,d4
		jsr	A5CheckSoundsys(a5)
		beq.w	.RP_PlayerFound


	*--------------------- Auf EP_Check3 testen ---------------------*
	* Bei EP_Check3 ist der Speichertyp egal, daher hier immer ein	 *
	* Check	!!! Diese Funktion ist eingebaut, damit bei eingeschalte *
	* tem LoadFast auch gepackte Module erkannt werden, wo der Player*
	* nur EP_Check5 und DTP_Check2 untersttzt.			 *
	*----------------------------------------------------------------*
		clr.l	LoadPlayerStart(a5)
		move.l	RippStart(a5),DTG_ChkData(a5)
		move.l	RippSize(a5),DTG_ChkSize(a5)
		move.l	#EP_Check3,d4
		jsr	A5CheckSoundsys(a5)
		beq.w	.RP_PlayerFound



	*--------------------- Auf DTP_Check2 testen -----------*
	* Bei DTP_Check2 ist das Module entpackt und im ChipMem *
	*------------------------------------------------------*
		clr.l	LoadPlayerStart(a5)
		move.l	RippStart(a5),DTG_ChkData(a5)
		move.l	RippSize(a5),DTG_ChkSize(a5)
		move.l	#DTP_Check2,d4
		jsr	A5CheckSoundsys(a5)
		beq.w	.RP_ModuleInChip


	*--------------------- Auf EP_Check4 testen -----------*
	* Bei EP_Check4 werden 2200 Bytes geladen und das Module *
	* wird bei eingeschaltetem LoadFast in ChipRam geladen *
	*------------------------------------------------------*
		clr.l	LoadPlayerStart(a5)
		move.l	RippStart(a5),DTG_ChkData(a5)
		move.l	RippSize(a5),DTG_ChkSize(a5)
		move.l	#EP_Check4,d4
		jsr	A5CheckSoundsys(a5)
		beq.w	.RP_ModuleInChip


		move.l	RippStart(a5),a0
		move.l	RippSize(a5),d0
		bsr	ConvertModule2
		beq.w	LFDTP_Check2



		*--- Testen, ob Check1player ---*
		move.l	RippStruct(a5),a1
		move.l	#Firstbytes,d0
		move.l	ERPSS_FileSize(a1),d1
		move.l	ERPSS_FilePtr(a1),a0
		jsr	A5PlayerChecker(a5)


	* ACHTUNG: NORMALERWEISE PFAD WIEDER ZURUECKSETZEN !!!!
	* NACH CEHCK1 (KANN HIER entfallen)
		LA0	LNr_TName
		move.l	a0,DTG_DirArrayPtr(a5)
		move.l	a0,LoadFilePath(a5)
		LA2	LNr_EPTName
		addq.l	#2,a2
		move.l	a2,DTG_FileArrayPtr(a5)
		jsr	A5CreateLoadPath(a5)

		clr.l	LoadPlayerStart(a5)
		move.l	#DTP_Check1,d4
		jsr	A5CheckSoundsys(a5)
		bne.w	.RP_UnknownFormat

		tst.b	OnSaveT(a5)
		beq.w	.RP_UnknownFormat

		move.l	RippStart(a5),a0
		move.l	RippSize(a5),d0
		jsr	A5SaveNachT(a5)
		bne.w	.RP_UnknownFormat
		move.l	RippStruct(a5),a2
		move.l	ERPSS_ModuleName(a2),d0
		beq.s	.RPST_NoModuleName
		move.l	d0,FilenameAdr(a5)
.RPST_NoModuleName:
		bra.w	.RP_PlayerFound


.RP_ModuleInChip:
		move.l	a6,LoadPlayerAdr(a5)
		move.l	RippStart(a5),a1
		ExecBase
		jsr	_LVOTypeOfMem(a6)
		btst	#1,d0			;es handelt sich bereits um
		bne.w	.RP_ChipDa
		move.l	RippSize(a5),d0
		add.l	#MemDrauf,d0
		moveq	#3,d1			;ChipRam Public holen
		jsr	_LVOAllocMem(a6)
		tst.l	d0
		bne.s	.RP_GotMem

		clr.l	LoadPlayerAdr(a5)


		tst.b	NotRausWerf(a5)		;aktuelles Mod drin lassen ?
		bne	ErrorAllocMem2


		movem.l	d0-a6,-(a7)
		jsr	A5AllesRaus(a5)
		jsr	A5GuiChanged(a5)
		movem.l	(a7)+,d0-a6

		move.l	RippSize(a5),d0
		moveq	#3,d1			;ChipRam Public holen
		add.l	#MemDrauf,d0
		ExecBase
		jsr	_LVOAllocMem(a6)
		tst.l	d0
		beq	ErrorAllocMem2

	*-------- Speicher besorgen ------*
.RP_GotMem:	move.l	d0,a4
		move.l	d0,a1
		move.l	RippStart(a5),a0
		move.l	RippSize(a5),d0
		*add.l	#MemDrauf,d0		;ist doch nur kopieren !!
		jsr	A5CopyMemQuick(a5)

	*--- alten Speicher freigeben ----*
		move.l	File(a5),d0
		beq.s	.RP_NoFile
		move.l	d0,a1
		move.l	FileSizeNeu(a5),d0
		beq.s	.RP_NoFile
		cmp.l	#-1,d0
		beq.s	.RP_NoFile
		move.l	4,a6
		add.l	#MemDrauf,d0
		jsr	_LVOFreeMem(a6)
		bra.s	.RP_NoSegment

.RP_NoFile:	move.l	EPG_ChkSegment(a5),d0
		asr.l	#2,d1
		subq.l	#1,d1
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOUnLoadSeg(a6)
.RP_NoSegment:	clr.l	EPG_ChkSegment(a5)
		move.l	a4,File(a5)
		move.l	a4,RippStart(a5)
		move.l	RippSize(a5),FileSizeNeu(a5)


	*--- Nochmal checken, weil in einigen Playern in der Checkroutine ---*
	*---- Sprungadressen gemerkt werden, die ja jetzt nicht da sind -----*
	*--------------------- Auf DTP_Check2 testen --------------------*
		clr.l	LoadPlayerAdr(a5)
		clr.l	LoadPlayerStart(a5)
		move.l	File(a5),DTG_ChkData(a5)
		move.l	FileSizeNeu(a5),DTG_ChkSize(a5)
		move.l	#EP_Check4,d4
		jsr	A5CheckSoundsys(a5)
		beq.w	.RP_PlayerFound

		clr.l	LoadPlayerStart(a5)
		move.l	File(a5),DTG_ChkData(a5)
		move.l	FileSizeNeu(a5),DTG_ChkSize(a5)
		move.l	#DTP_Check2,d4
		jsr	A5CheckSoundsys(a5)
		bne.w	.RP_UnknownFormat




.RP_PlayerFound:move.l	a6,LoadPlayerAdr(a5)
.RP_ChipDa:	move.l	LFNummer(a5),d0
		subq.l	#1,d0
		lea	LFPuffer(a5),a0
		rol.l	#4,d0
		add.l	d0,a0
		move.l	RippStart(a5),(a0)+
		move.l	RippSize(a5),(a0)+
		move.l	File(a5),(a0)+			;AllocAdr
		moveq	#0,d0
		btst	#0,LoadFileBytes(a5)
		bne.w	.RP_NoLFMemDrauf
		cmp.l	#-1,FileSizeNeu(a5)		;Segment !!!
		beq.w	.RP_NoLFMemDrauf
		move.l	#MemDrauf,d0
.RP_NoLFMemDrauf:add.l	FileSizeNeu(a5),d0
		move.l	d0,(a0)				;AllocSize
		move.b	#1,RippedFile(a5)
		bra	LF_NoInc2		;--> EXTLoading !!!




.RP_UnknownFormat:
		LA0	LNr_TR_RippError
		move.l	a0,EPG_Arg1(a5)
		lea	PubScreenName(a5),a0
		move.l	a0,EPG_Arg2(a5)
		clr.l	EPG_Arg3(a5)
		subq.l	#1,EPG_Arg3(a5)
		LA0	LNr_GA_Config
		move.l	a0,EPG_Arg4(a5)
		clr.l	EPG_Arg5(a5)			*Title
		move.l	RippStruct(a5),a0			*FormatName
		move.l	ERPSS_FormatName(a0),ScrollArgs(a5)
		move.l	ERPSS_Modulename(a0),d0
		bne.s	.RP_StringDa1
.RP_Unknown:	LA0	LNr_Unknown
		bra.s	.RP_Unknown2
.RP_StringDa1:	move.l	d0,a0
		tst.b	(a0)
		beq.s	.RP_Unknown
.RP_Unknown2:	move.l	a0,ScrollArgs+4(a5)

		lea	ScrollArgs(a5),a0
		move.l	a0,EPG_Arg6(a5)
		
		move.l	#EPTRB_Center,EPG_Arg8(a5)
		moveq	#-1,d0
		move.l	d0,EPG_Arg7(a5)
		moveq	#7,d0
		move.l	d0,EPG_ArgN(a5)
		jsr	A5TextRequest(a5)
		beq.w	.RP_FreeRipperstruct


		*---- Rippen fortfhren ----*
		move.l	RippStruct(a5),a1
		move.l	ERPSS_EngineNr(a1),d4
		move.l	RippStart(a5),a0
		addq.l	#2,a0
		move.l	FileSizeNeu(a5),d0
		subq.l	#2,d0
		ble.w	UnKnownPPFormat
		move.l	#EUT_RippCont,d5
		jsr	A5Rippen(a5)
		bne.w	.RP_NimmNextRipper
		move.l	a0,RippStart(a5)
		move.l	d1,RippSize(a5)
		move.l	a1,RippStruct(a5)
		bra.w	.GeripptesEinbinden

.RP_NimmNextRipper:
		move.l	RippStruct(a5),a1
		move.l	ERPSS_EngineNr(a1),d4
		addq.l	#1,d4
		bra.w	RP_NextRipper


.RP_FreeRipperstruct:
		move.l	Rippstruct(a5),d0
		beq.s	.RP_Free
		move.l	d0,a0
		moveq	#EUTY_Ripper,d3
		move.l	ERPSS_EngineNr(a0),d4
		move.l	#EUT_FreeRipperstruct,d5
		jsr	A5UserCallUp5(a5)
.RP_Free:	clr.l	Rippstruct(a5)

	*----------------------------------------------------------------*
	* Wenn Rippen im File gescheitert ist, wird nochmal LoadSeg ver  *
	* sucht und das File entpackt.
	*----------------------------------------------------------------*
		*----- Segmente laden und testen -----*
.LoadSegment:	move.b	OnEjectPlayer(a5),d0
		move.l	d0,-(a7)
		clr.b	OnEjectPlayer(a5)
		bsr	UnknownPPFormat
		move.l	(a7)+,d0
		move.b	d0,OnEjectPlayer(a5)


		tst.l	LoadFileName(a5)
		beq.w	.Seg_NoSegment

		LA0	LNr_Loading			* um Schrift
		move.l	LoadFileName(a5),ScrollArgs(a5) *"Ripping ..." zu
		jsr	A5PrintText(a5)			*berschreiben

		btst	#0,LoadFileBytes(a5)
		bne.w	.Seg_NoSegment
		move.l	XPK_FileName(pc),d1
		jsr	A5LoadSegment(a5)
		beq.w	.Seg_NoSegment
		move.l	d0,EPG_ChkSegment(a5)
		move.l	d0,File(a5)

		clr.l	LoadPlayerStart(a5)
		clr.l	LoadPlayerAdr(a5)	;Kennung(No LoadPlayer found)
.Seg_Retry:	move.l	#EP_CheckSegment,d4
		jsr	A5CheckSoundsys(a5)
		beq.w	.Seg_Found

		*--- Im Segment rippen ---*
		*-----------------------------------------------------------------------------*
		* Aufruf ber Taglist. Falls Module gefunden, werden a0/a1/d1 entsprechend ge-*
		* setzt. Die Ripperstruct wird zum spteren ExtRipp gebraucht.
		*-----------------------------------------------------------------------------*
		* Input: a0=MemAdr
		*	 d0=MemSize
		*	 a1=Hook fr Crunchanzeige
		*	 d5=Tag
		* Output:d0=Error oder NULL
		*	 a0=ModuleAdr
		*	 d1=ModuleSize
		*	 a1=RipperStruct
		move.l	EPG_ChkSegment(a5),a0
		moveq	#-1,d0
		move.l	#EUT_RippSegment,d5
		jsr	A5Rippen(a5)
		bne.s	.UnloadSegment
		move.l	a0,RippStart(a5)
		move.l	a0,RippStruct(a5)
		move.l	d1,RippSize(a5)
		move.l	#-1,FileSizeNeu(a5)
		move.l	EPG_ChkSegment(a5),File(a5)
		clr.l	EPG_ChkSegment(a5)
		bra.w	.GeripptesEinbinden



		*-- normaler Player wie Ron Klaren wurde gefunden --*
.Seg_Found:	tst.l	LoadPlayerAdr(a5)
		bne.s	.Seg_NoMerk
		move.l	a6,LoadPlayerAdr(a5)
.Seg_NoMerk:	move.l	#-1,FileSizeNeu(a5)
		moveq	#0,d7
		move.l	#1,LFNummer(a5)
		bra.w	LF_NoCheck2			*.NoError



.UnloadSegment:	move.l	d0,-(a7)
		clr.l	FileSizeNeu(a5)
		clr.l	LoadPlayerAdr(a5)
		clr.l	LoadPlayerStart(a5)
		clr.l	File(a5)
		move.l	EPG_ChkSegment(a5),d1
		asr.l	#2,d1
		subq.l	#1,d1
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOUnLoadSeg(a6)
		clr.l	EPG_ChkSegment(a5)
		moveq	#0,d6
		moveq	#0,d7
		move.l	(a7)+,d0
		cmp.w	#EPR_FunctionAborted,d0
		beq.w	ScrollNewFehler

.Seg_NoSegment:	moveq	#EPR_UnknownFormat,d0
		jmp	A5ScrollNewFehler(a5)

*-----------------------------------------------------------------------------*
* Fr Kopatibilitt mit Archiven
* Problem: LHA-Pfad Modules:Crunchertest/TFMX-Mods.lzx
*
* Input: a6=Tagliste
NewExtLoad:	movem.l	d1/d3-a5,-(a7)
	tst.b	LHALoaded(a5)
	beq.w	.Normal

		tst.b	OnExtractFirstModule(a5)
		beq.w	.NoFirstModule
		lea	DirPuffer(a5),a0
		jsr	A5BerechStringSize(a5)
		lea	(a0,d0.w),a0
		move.l	a0,-(a7)

		lea	DirPuffer(a5),a1
		jsr	A5MakeCorrectDir(a5)
		move.l	a1,a0
		jsr	A5BerechStringSize(a5)
		lea	(a0,d0.w),a1
		move.l	DTG_FileArrayPtr(a5),a0
		move.w	#DirPufferSize-2,d1
		jsr	A5StringCopy2(a5)		

		move.l	a1,ExtLoad_LastDirAdr(a5)
		move.b	#"/",(a1)+

		lea	ArexxPuffer+1000(a5),a0
		jsr	A5StringCopy2(a5)		

		lea	DirPuffer(a5),a1
		jsr	A5GetFileName(a5)
	*	clr.b	(a1)

		move.l	DTG_FileArrayPtr(a5),-(a7)
	move.l	a1,-(a7)

		move.l	a1,a0
		lea	FilePuffer(a5),a1
		move.l	a1,DTG_FileArrayPtr(a5)
		jsr	A5StringCopy(a5)
		lea	FilePuffer(a5),a0
		lea	ArexxPuffer+1000+DirPufferSize(a5),a1
		jsr	A5StringCopy(a5)
	move.l	(a7)+,a1
	clr.b	(a1)


		move.l	#DTP_ExtLoad,d0
		moveq	#0,d3
		jsr	A5CallUp3(a5)

		move.l	(a7)+,DTG_FileArrayPtr(a5)

		move.l	(a7)+,a0
		clr.b	(a0)

		movem.l	d0/d2,-(a7)
		lea	FilePuffer(a5),a1
		move.l	a1,MenuFilename(a5)
		lea	ArexxPuffer+1000+DirPufferSize(a5),a0
		jsr	A5StringCopy(a5)
		movem.l	(a7)+,d0/d2
		bra.w	.Return

*	move.l	MEnuFilename(a5),a0
*	move.l	DTG_FileArrayPtr(a5),a0
*	lea	LHAPathPuffer(a5),a0
*	lea	PathPuffer(a5),a0
*	lea	DirPuffer(a5),a0


.NoFirstModule:	lea	DirPuffer(a5),a0
		jsr	A5BerechStringSize(a5)
		lea	(a0,d0.w),a0
		move.l	a0,ExtLoad_LastDirAdr(a5)

		lea	DirPuffer(a5),a1
		jsr	A5MakeCorrectDir(a5)
		lea	DirPuffer(a5),a0
		jsr	A5BerechStringSize(a5)
		lea	(a0,d0.w),a1
		move.l	DTG_FileArrayPtr(a5),a0
		move.w	#DirPufferSize-2,d1
		jsr	A5StringCopy2(a5)

		lea	DirPuffer(a5),a1
		jsr	A5GetFileName(a5)
		clr.b	(a1)


		move.l	DTG_FileArrayPtr(a5),a1
		move.l	a1,-(a7)
		jsr	A5GetFileName(a5)
		move.l	a1,DTG_FileArrayPtr(a5)


		move.l	#DTP_ExtLoad,d0
		moveq	#0,d3
		jsr	A5CallUp3(a5)

		move.l	(a7)+,DTG_FileArrayPtr(a5)
		move.l	ExtLoad_LastDirAdr(a5),a0
		clr.b	(a0)
		bra.s	.Return

.Normal:	move.l	#DTP_ExtLoad,d0
		moveq	#0,d3
		jsr	A5CallUp3(a5)


.Return:	movem.l	(a7)+,d1/d3-a5
		tst.l	d2
		rts


	;****************************************************************
	;**** Werte zurck setzen, die durch EXTLoad verbogen wurden ****
	;**** und belegten Speicher durch geladene Files freigeben   ****
	;****************************************************************
FreeExtLoad:	movem.l	d0-a6,-(a7)

		move.l	LoadPlayerAdr(a5),a6
		move.l	#EP_FreeExtLoad,d0
		moveq	#0,d3
		jsr	A5CallUp3(a5)

		move.l	LFPuffer(a5),File(a5)
		move.l	LFPuffer+4(a5),FileSizeNeu(a5)

*
		move.l	LFNummer(a5),d7
		subq.l	#2,d7
		blt.s	.FreeExtReturn
		*lea	LFPuffer+8(a5),a0
		lea	LFPuffer+16(a5),a0
.NextFile:	*move.l	(a0),d0
		move.l	8(a0),d0
		beq.s	.NextFile2
		move.l	d0,a1
		*move.l	4(a0),d0
		move.l	12(a0),d0
		beq.s	.NextFile2
		move.l	a0,-(a7)
		jsr	A5FreeMem(a5)
		move.l	(a7)+,a0
.NextFile2:
		clr.l	(a0)+
		clr.l	(a0)+
		clr.l	(a0)+		;Neu
		clr.l	(a0)+		;Neu
		dbf	d7,.NextFile


*


		moveq	#1,d0
		move.l	d0,LFNummer(a5)
.FreeExtReturn:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
ConvertModule:	move.l	File(a5),a0
		move.l	FileSizeNeu(a5),d0

ConvertModule2:	movem.l	d1-a6,-(a7)
		move.l	File(a5),a4
		move.l	FileSizeNeu(a5),d5
		move.l	d5,-(a7)
		moveq	#EUTY_Converter,d3
		moveq	#0,d4
		move.l	#EUT_ConvertModule,d5
		jsr	A5UserCallUp5(a5)
		move.l	(a7)+,d5
		tst.l	d3
		bne.w	.Error
		tst.l	d0
		beq.w	.Error

		move.l	#2,LoadFileMem(a5)
		clr.b	LoadFileBytes(a5)

		move.w	#1,SchonGerippt(a5)
		cmp.l	File(a5),a0		;fr Codieren Wanton,Prorunner
		beq.s	.IstGleich

		add.l	#Memdrauf,d0		;Memdrauf muss sein !!!!!
		cmp.l	d0,d2
		bne.s	.FreeIt

		btst	#CVB_FreeOriginal,d1
		beq.s	.Ransetzen
		movem.l	d0/d2/a0-a2,-(a7)
		move.l	a4,File(a5)		* bei DTG_LoadFile
		move.l	d5,FileSizeNeu(a5)	* wird File versaut !
		bsr	FreeLoadModule2
		bsr	FreeExtLoad
		movem.l	(a7)+,d0/d2/a0-a2
.RanSetzen:	move.l	File(a5),LFExtraMem(a5)
		move.l	FileSizeNeu(a5),LFExtraMem+4(a5)
		tst.l	FileSizeNeu(a5)
		beq.s	.NoMemDrauf
		add.l	#MemDrauf,LFExtraMem+4(a5)
.NoMemDrauf:	move.l	a0,File(a5)
		move.l	d0,FileSizeNeu(a5)
		sub.l	#MemDrauf,FileSizeNeu(a5)
.IstGleich:	move.l	a1,LFFormatName(a5)
		move.l	a2,LFSamplePtr(a5)
		moveq	#0,d0
		bra.s	.Return
	*	bra.w	LFDTP_Check2


.FreeIt:	move.l	a0,a1
		move.l	d2,d0
		jsr	A5Freemem(a5)
.Error:		moveq	#EPR_UnknownFormat,d0
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Speichere Datei nach T:EP_Tempfile (Loadname)
* Input: a0=Fileadr
*	 d0=Filesize
* Output:d0=NULL oder Error
*-----------------------------------------------------------------------------*
SaveNachT:	movem.l	d1-d6/a0-a6,-(a7)
		bsr	DeleteTFile
		moveq	#EPR_FileNotFound,d5
		move.l	a0,a3
		move.l	d0,d3
		clr.b	NachTGesaved(a5)
		LA0	LNr_EPTName
		move.l	a0,d1
		move.l	#1006,d2
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOOpen(a6)
		move.l	d0,d7
		beq.s	.Error
		move.l	d0,d1
		move.b	#1,NachTGesaved(a5)
		move.l	a3,d2
		jsr	_LVOWrite(a6)
		move.l	d0,d6
		move.l	d7,d1
		jsr	_LVOClose(a6)
		jsr	A5FreeLoadModule2(a5)
		moveq	#0,d7
		move.l	LoadPlayerAdr(a5),a6
		cmp.l	d6,d3
		bne.s	.Error
		moveq	#0,d5
.Error:		movem.l	(a7)+,d1-d6/a0-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: d0=CheckType
* Outpput:a6=Tagliste oder NULL
*Formatload_Check:sub.l	a6,a6
*		tst.l	Formatload_Tags(a5)
*		beq.s	.Return
*		move.l	Formatload_Tags(a5),a6
*		jsr	A5FindTag2(a5)
*		
*
*.Return:	rts
*



*--------------------- alten Memory freigeben -------------------------*
*----- Gibt Memory des TargetBuffer und XFDInfoStruct wieder frei -----*
*----------------------------------------------------------------------*
XFDFreeDecrunched:
		move.l d0,-(a7)
		move.l	a4,d0
		beq.s	.nofree
		move.l	d0,a0
		move.l	XFDBI_TargetBuffer(a0),d0
		beq.s	.XFDNoFile
		move.l	d0,a1
		move.l	XFDBI_TargetBufLen(a0),d0
		beq.s	.XFDNoFile
		ExecBase
		jsr	_LVOFreeMem(a6)
.XFDNoFile:	clr.l	XFDBI_TargetBuffer(a4)
		clr.l	XFDBI_TargetBufLen(a4)
		clr.l	XFDBI_TargetBufSaveLen(a4)

	*------------- XFDCrunchInfo freigeben ----------------*
.XFDNoPacker:	move.l	EPG_XFDMasterBase(a5),a6
		move.l	a4,a1
		jsr	_LVOXFDFreeBufferInfo(a6)
		sub.l	a4,a4
.nofree
		move.l	(a7)+,d0
		tst.l	d0
		rts

XPK_PTagList:	dc.l	$80005874,0		;Passwordadr
XPK_TagList:	dc.l	$80005851		;XPK_InName
XPK_FileName:	dc.l	0			;The file name to be read
;		dc.l	$80005875,BSSMerkPuffer+XPK_ErrBuf	;XPK_GetError
;		dc.l	$80005877,-1		;XPK_PassThru ; Will pass through uncompressed data
		dc.l	0,0

*---------------------------------------------------------------------------*
*------------------------- 	Pfad aufbauen	----------------------------*
*----- Input:	LoadFilePath=Diradresse, ungleich Pathpuffer		----*
*-----		a2=Filename						----*
*----- Output:	Pathpuffer=creierter Path				----*
*---------------------------------------------------------------------------*
CreateLoadPath:	lea	PathPuffer(a5),a1
		tst.b	PathToPathAdr(a5)
		beq.s	.PathOk
		move.l	PathAdr(a5),d0
		move.l	d0,a1
		beq.s	.Return
.PathOk:	clr.b	(a1)
		move.l	LoadFilePath(a5),d0
		beq.s	.NextB
		move.l	d0,a0
		tst.b	(a0)
		beq.s	.NextB				;NoPath
.SucheDirEnd:	move.b	(a0)+,d0
		move.b	d0,(a1)+
		bne.s	.SucheDirEnd
		subq.l	#2,a1
		cmp.b	#":",(a1)
		beq.s	.device
		cmp.b	#"/",(a1)
		beq.s	.device
		addq.l	#1,a1
		move.b	#"/",(a1)
.Device		addq.l	#1,a1
.NextB:		moveq	#0,d0			;Enforcer
		cmp.l	d0,a2
		beq.s	.FileEnd
		move.b	(a2)+,d0		;Namen copieren
		beq.s	.FileEnd
		move.b	d0,(a1)+
		bra.s	.NextB
.FileEnd:	clr.b	(a1)
.Return:	rts

*-----------------------------------------------------------------------------*
*------------------------- Load ProgrammMode-Module --------------------------*
*-----------------------------------------------------------------------------*
LoadProgrammModule:
		movem.l	d1-a6,-(a7)
		moveq	#0,d0
		move.b	ProgrammMode(a5),d0
		cmp.b	#EPNrP_NoNextModule,d0
		beq.s	.NoMode
		cmp.b	#EPNrP_PrevModule,d0
		beq.s	.PrevIt
		*cmp.b	#EPNrP_NextModule,d0
		*bne.s	.NoMode
		jsr	A5NextModule(a5)	;Random ist automatisch
		bra.s	.NoMode

	*--------- es wird das vorherige Module abgespielt -------*
.PrevIt:	jsr	A5PrevModule(a5)
.NoMode:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts



*-----------------------------------------------------------------------------*
*-------------------------------- Next Module --------------------------------*
*-----------------------------------------------------------------------------*
NextModule:	tst.l	LFNummer(a5)
		bne.w	LFModuleLoaded
		moveq	#EPR_NoMoreEntries,d0
		tst.l	EPG_Mods(a5)
		beq.w	.Return
		cmp.b	#EPNrP_RandomModule,ProgrammMode(a5)
		beq.w	NextModuleRandom

.RetryDir:	move.l	EPG_FirstFileStruct(a5),a0 * folgendes verhindern
		move.b	EFP_Flags(a0),d1	   * 1. Dir gescannt 
		move.w	LastModuleNr(a5),d2	   * nchster Vers. Parent
		bne.s	.NoParent
		btst	#EFPF_Parent,d1		   * 1. Module not found
		beq.w	.NoParent		   * -> d2=0
		move.l	(a0),d1
		beq.s	.NoParent
		move.l	d1,a0
.NoParent:	moveq	#EFPF_All,d0
		tst.b	OnDirJump(a5)
		bne.s	.FlagOk
.RetryFile:	moveq	#EFPF_FileName,d0
		move.l	FirstModulesEintrag(a5),a0
.FlagOk:	tst.w	d2
		beq.s	.LoadIt
		jsr	A5SucheStruktur(a5)
		tst.l	d0
		bne.w	ToScrollNewFehler
		move.l	a2,a0
.LoadIt:	cmp.l	#0,a0
		beq.s	.Return
		move.b	EFP_Flags(a0),d1		*solange suchen, bis 
		jsr	A5LoadStructModule(a5)

		cmp.w	#EPR_InvalidNr,d0		;darf nur bei DirJump
		beq.s	.InvalidNr
		tst.l	d0
		bne.s	.Return

.InvalidNr:	tst.b	DirJumpNewDir(a5)
		bne.s	.RetryFile
		tst.b	OnDirJump(a5)
		beq.s	.Return
		btst	#EFPF_FileName,d1		*nchster Filename
		bne.w	.Return
		btst	#EFPF_ArchiveFile,d1
		bne.w	.Return
		tst.l	EPG_Mods(a5)
		beq.s	.RetryDir
		move.w	LastModuleNr(a5),d2
		bra.s	.RetryFile
.Return:	rts

NextModuleRandom:
		*move.l	PlayerAdr(a5),d1
		*move.l	d1,-(a7)
		bsr	PlayRandomModule
		*move.l	(a7)+,d1
		*tst.l	d0
		*bne.s	.Ret
		*tst.b	OnDirJump(a5)
		*beq.s	.Ret
		*cmp.l	PlayerAdr(a5),d1
		*bne.s	.Ret
		*clr.b	OnDirJump(a5)
		*bsr	PlayRandomModule
		*move.b	#1,OnDirJump(a5)		
.Ret:		rts
*-----------------------------------------------------------------------------*
*-------------------------------- Prev Module --------------------------------*
*-----------------------------------------------------------------------------*
PrevModule:	tst.l	LFNummer(a5)
		bne.w	LFModuleLoaded
		moveq	#EPR_NoMoreEntries,d0
		tst.l	EPG_Mods(a5)
		beq.s	.Return
		cmp.b	#EPNrP_RandomModule,ProgrammMode(a5)
		beq.w	NextModuleRandom

.RetryDir:	move.l	LastModulesEintrag(a5),a0
		move.w	LastModuleNr(a5),d2
		moveq	#EFPF_All,d0
		tst.b	OnDirJump(a5)
		bne.s	.FlagOk
.RetryFile:	moveq	#EFPF_FileName,d0
.FlagOk:	tst.w	d2
		beq.s	.LoadIt
		jsr	A5SucheStruktur(a5)
		tst.l	d0
		bne.w	ToScrollNewFehler
		move.l	a1,a0
.LoadIt:	cmp.l	#0,a0
		beq.s	.Return
		move.b	EFP_Flags(a0),d1		*solange suchen, bis 
		jsr	A5LoadStructModule(a5)

		cmp.w	#EPR_InvalidNr,d0		;darf nur bei DirJump
		beq.s	.InvalidNr
		bne.s	.Return

.InvalidNr:	tst.b	DirJumpNewDir(a5)
		bne.s	.RetryFile
		tst.b	OnDirJump(a5)
		beq.s	.Return

		btst	#EFPF_FileName,d1		*nchster Filename
		bne.w	.Return
		btst	#EFPF_ArchiveFile,d1
		bne.w	.Return
		tst.l	EPG_Mods(a5)
		beq.s	.RetryDir
		move.w	LastModuleNr(a5),d2
		bra.s	.RetryFile
.Return:	rts





*---------------------------------------------------------------------------*
*---------------------------- Load ModuleNr --------------------------------*
* d2 = ModNr
*---------------------------------------------------------------------------*
*---------------------------------------------------------------------------*
LoadModuleNr:

	clr.l	DirJumpPtr(a5)
		*tst.l	d2
		*ble.w	LoadModule			;-> FileRequester
		*addq.w	#1,d2
		moveq	#EFPF_All,d0
		*add.w	#EPNr_FirstModule,d2
		jsr	A5SucheStruktur(a5)
		tst.l	d0
		bne.w	ToScrollNewFehler
	bsr	LoadStructModule
	move.l	d0,-(a7)
	jsr	A5SetDirJumpPtr(a5)
	move.l	(a7)+,d0
	tst.l	d0
	rts


*-----------------------------------------------------------------------------*
*----- Lade Module/Dir/..., welches in interner Struktur ab a0 steht    ------*
*-----	Input:	a0 = StructAdr						------*
*-----------------------------------------------------------------------------*
LoadStructModule:
		movem.l	d1-a6,-(a7)
		clr.b	DirJumpNewDir(a5)
		move.l	a0,a3
		move.l	DTG_Dosbase(a5),a6
		move.l	EFP_NameDirLock(a3),d7
		bne.s	.LockUsed

		lea	DirPuffer(a5),a1
		move.l	EFP_DirArrayPtr(a3),d0
		beq.s	.NoDirLock
		move.l	d0,a0
		move.w	#DirPufferSize-2,d1
		jsr	A5StringCopy2(a5)
		bra.s	.NoDirLock

	*------- DirName in DirPuffer copieren -------*
.LockUsed:	move.l	d7,d1
		lea	DirPuffer(a5),a0
		move.l	a0,d2
		move.l	#DirPufferSize-2,d3
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVONameFromLock(a6)

.NoDirLock:	moveq	#0,d0
		move.b	EFP_Flags(a3),d0
		btst	#EFPF_FileName,d0
		bne.w	.FileName			;+-+- globales Label !
		btst	#EFPF_DirName,d0
		bne.w	.DirName
		btst	#EFPF_Parent,d0
		bne.w	.ParentDir
		moveq	#EPR_ErrorInArguments,d0
		bra.w	.ScrollError

	*------------ Es wurde Parent aufgerufen ----------*
.ParentDir:	move.l	EFP_NameDirLock(a3),d1
		beq.s	.NoParentLock
		lea	DirPuffer(a5),a0
		move.l	a0,d2
		move.l	#DirPufferSize-2,d3
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVONameFromLock(a6)
		bra.w	.DirNameOk		

.NoParentLock:
;KK
		btst	#EFPF_ParentList,d0
		beq.s	.ParentNoList
		lea	ListPuffer(a5),a0
		lea	DirPuffer(a5),a1
		move.w	#DirPufferSize-2,d1
		jsr	A5StringCopy2(a5)
		jsr	A5FreeDirPuffer(a5)
		lea	DirPuffer(a5),a1
		jsr	A5GetFileName(a5)
		move.l	a1,d0
		beq.s	.ParentNoList
		clr.b	(a1)
		jsr	A5LoadDirIn(a5)
		bra.w	.NewDirLoaded

.ParentNoList:	lea	DirPuffer(a5),a0
		jsr	A5TestJumpDir(a5)
		bne.w	.ScrollError
;LL



		btst	#EFPF_ArchiveDir,d0
		beq.w	.NormalParent
		lea	DirPuffer(a5),a0
		move.b	keyon-dirpuffer(a0),d0	;+-+-
		beq.w	Warten			;wegen Mglichkeit,des
						;Erlaubens des Selektierens
						;von Dirs -> BRA ungerade Adr
						;-> GURU

		jsr	A5ParentArchiveDir(a5)
		bne.s	.ClearSchr
		cmp.b	#":",(a0)
		bne.s	.ClearSchr
		addq.l	#1,a0
.ClearSchr:	clr.b	(a0)
		jsr	A5FreeDirPuffer(a5)
		jsr	A5LoadAutoDir(a5)
		tst.l	d0
		bne.w	.ScrollError
		bra.w	.ItsOk

.NormalParent:	jsr	A5LoadParentDir(a5)
.NewDirLoaded:	LA0	LNr_NewDirLoaded
		jsr	A5ScrollNewText(a5)
		move.b	#1,DirJumpNewDir(a5)
		bra.w	.ItsOk

	*----------- Es wurde ein Dir aufgerufen ----------*
.DirName:	tst.l	EFP_NameDirLock(a3)
		bne.s	.DirNameOk
		move.l	EFP_IT_IText(a3),a0
		move.l	a0,-(a7)
		sub.l	a2,a2			;FileName
		lea	DirPuffer(a5),a1
		move.l	a1,LoadFilePath(a5)
		bsr.w	CreateLoadPath
		move.l	(a7)+,a0
		move.w	#DirPufferSize-2,d1
		jsr	A5StringCopy2(a5)
		lea	PathPuffer(a5),a0
		lea	DirPuffer(a5),a1
		move.w	#DirPufferSize-2,d1
		jsr	A5StringCopy2(a5)
.DirNameOk:	clr.b	OnMultiSelectIn(a5)
		jsr	A5LoadDirIn(a5)
		tst.l	d0
		beq.s	.NewDirLoaded
		cmp.w	#EPR_DirNotChanged,d0
		beq.w	.ItsOk
		move.l	d0,-(a7)
		jsr	A5ParentDir(a5)
		jsr	A5LoadAutoDir(a5)
		move.w	LastModuleNr(a5),d2
		add.l	EPG_Dirs(a5),d2
		moveq	#EFPF_DirName,d0
		jsr	A5SucheStruktur(a5)
		move.l	(a7)+,d0
.ScrollError:	jsr	A5ScrollNewFehler(a5)
		bra.w	.Return

	*------------- File laden ------------*
.FileName:	lea	DirPuffer(a5),a1
		move.l	EFP_PathArrayPtr(a3),d0
		beq.s	.FileNoPath
		move.l	d0,a0
		cmp.b	#":",(a0)
		bne.s	.NormalDevice
		* fr Delilisten bei Meeting Pearls
		* :pearls/mods/mod.traller
		* Da wird dann der Devicename der Liste verwendet
		tst.b	OnMultiSelectIn(a5)
		beq.s	.NormalDevice
		lea	ListPuffer(a5),a0
		moveq	#Namenlange-2,d1
.CopyDoppel:	move.b	(a0)+,d0
		beq.s	.NoMoreDoppel
		move.b	d0,(a1)+
		cmp.b	#":",d0
		beq.s	.NoMoreDoppel
		dbf	d1,.CopyDoppel
.NoMoreDoppel:	move.l	EFP_PathArrayPtr(a3),a0
		addq.l	#1,a0				;Doppelpunkt weg
.NormalDevice:	move.w	#DirPufferSize-2,d1
		jsr	A5StringCopy2(a5)
		lea	DirPuffer(a5),a1
		jsr	A5GetFilename(a5)
		move.l	a1,d0
		beq.s	.FileNoPath
		clr.b	(a1)

*		move.l	EFP_PathArrayPtr(a3),d0
*		beq.s	.FileNoPath
*		move.l	d0,a2
*		move.l	d0,a0
*		jsr	A5BerechStringSize(a5)
*		move.l	d0,d2
*		clr.b	MustRandomModule(a5)		;Recursive Schleife
*		moveq	#0,d3				;verhindern
*		move.l	EFP_IT_IText(a3),a1
*		move.l	a1,MenuFileName(a5)
*		movem.l	d1-a6,-(a7)
*		move.l	a1,-(a7)
*		bsr	LoadModule
*		move.l	(a7)+,a1
*		tst.l	d0
*		bne.s	.Guru
*		move.l	a1,LoadedMenuFileName(a5)
*		bra.s	.Guru

.FileNoPath:	move.l	EFP_IT_IText(a3),a1
		move.l	a1,a2
		move.l	a1,MenuFileName(a5)
		movem.l	d1-a6,-(a7)
		move.l	a1,-(a7)
		jsr	A5LoadThis(a5)
		move.l	(a7)+,a1
		tst.l	d0
		bne.s	.Guru
		move.l	a1,LoadedMenuFileName(a5)
		jsr	A5CreatePlayName(a5)

.Guru:		movem.l	(a7)+,d1-a6
		move.l	d7,d1
		beq.s	.Return

	*--------- Dir-Lock freigeben --------*
		move.l	d0,-(a7)
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		move.l	d1,EFP_NameDirLock(a3)
		move.l	(a7)+,d0

.ItsOk:		moveq	#0,d0
.Return:	jsr	A5ClearMouse(a5)
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
*-------------- Ein zufllig ausgewhltes Module abspielen -------------------*
*-----------------------------------------------------------------------------*
PlayRandomModule:
		clr.l	RandomVersuche(a5)
RetryRandomModule:
		jsr	A5GetAbortMSG(a5)
		bne.s	.KeinAbort
		tst.l	d1
		beq.s	.KeinAbort
		moveq	#EPR_FunctionAborted,d0
		bra.w	.ErrorInD0

.KeinAbort:	moveq	#0,d0
		move.l	EPG_Entries(a5),d1

		tst.b	OnDirJump(a5)
		bne.s	.ModTest1
		moveq	#EPR_NoMoreEntries,d0
		move.l	EPG_Mods(a5),d1
.ModTest1:	beq.w	.Return
		cmp.w	#1,d1
		bne.s	.MoreThanOne

		tst.l	Playeradr(a5)
		beq.w	.Return

	*---- bei nur einem Modul in der Liste erstes File laden ----
		lea	EPG_FirstFileStruct(a5),a3
		tst.b	OnDirJump(a5)
		bne.w	.RandomOk
.NextItem2:	move.l	(a3),d0
		beq.w	.Return
		move.l	d0,a3
		moveq	#0,d0
		move.b	EFP_Flags(a3),d0
		btst	#EFPF_FileName,d0
		bne	.Randomok
		bra.s	.NextItem2

.MoreThanOne:	move.w	d1,d5
		lea	EPG_FirstFileStruct(a5),a3
		tst.l	(a3)
		beq.w	.Return
		move.l	(a3),a3



		*--- Falls aktuelles Modul aus einem Archiv kommt und --*
		*--- ExtractFirstModule eingeschaltet ist, mu der File *
		*    name dem des Archives entsprechen, da sonst die    *
		*    Randomkennung nicht gesetzt werden kann, da Module *
		* name und Archivename sich unterscheiden*
		tst.b	OnExtractFirstModule(a5)
		beq.s	.NoEFM


		move.l	LoadedMenuFileName(a5),a2
		lea	DirPuffer(a5),a0
		move.l	a0,Loadfilepath(a5)
		jsr	A5CreateLoadPath(a5)
		lea	PathPuffer(a5),a0
		jsr	A5TestAufArchive(a5)
		bne.s	.NoEFM
		lea	PathPuffer(a5),a1
		jsr	A5GetFilename(a5)
		move.l	a1,d0
		bra.w	.EFM

.NoEFM:
***		move.l	FileNameAdr(a5),d0		;Derzeitiger Name
***		beq.w	.Notfound

	*------ Aktuelles Modul in der Liste kennzeichnen ------*
.EFM:		subq.w	#1,d5
.Findactual:	lea	TitleNamePuffer(a5),a2
***		move.l	d0,a2

		tst.b	OnDirJump(a5)
		bne.s	.Findacok
		move.b	EFP_Flags(a3),d6	;ist es ein File ?
		btst	#EFPF_FileName,d6
		beq.s	.NextFIL		;nein, ein DIR/Parent !!!!

.Findacok:	move.l	EFP_IT_IText(a3),d6
		beq.s	.NotFound
		move.l	d6,a1
		move.l	EFP_StructSize(a3),d4	;Namenlange-2
		sub.l	#EFP_NamePuffer+3,d4
.NextB2:	move.b	(a1)+,d3
		cmp.b	(a2)+,d3
		bne.s	.FindNext
		tst.b	d3
		beq.s	.Found
		dbf	d4,.NextB2

.Findnext:	move.l	(a3),d2
		beq.s	.NotFound
		move.l	d2,a3
		dbf	d5,.FindActual
		bra.s	.NotFound

.NextFIL:	move.l	(a3),d2
		beq.s	.NotFound
		move.l	d2,a3
		bra.s	.FindActual

.Found:		move.b	#1,EFP_NameRKennung(a3)		;Aktuelles Mod
							;kennzeichnen

	*-------- Nun Random-Zhler berechnen -----------*
.Notfound:	moveq	#0,d2
		cmp.w	#100,d1
		blt.s	.DoLess
		divu	#100,d1
		addq.w	#2,d1
		bsr	Rnd2
		move.w	d0,d2
		mulu	#100,d2
		moveq	#100,d1			;max. 100 niederwertiger Teil
.DoLess:	addq.w	#1,d1
		bsr	Rnd			;niederwertiger Teil < 100
		move.w	d0,d1
		beq.s	.NoSub
		subq.w	#1,d1
.NoSub:		add.w	d2,d1			;hherwertiger Teil


		tst.b	DracoOn(a5)
		bne.s	.skip
		moveq	#0,d0
		move.b	$dff007,d0		;Test
		and.b	#$15,d0			;wert einfach so
		add.l	d0,d1
		move.b	$dff006,d0		;Test
		and.b	#$15,d0
		add.l	d0,d1
.skip:


	*-- Test, ob alle Modules bereits ein RandomPlay hinter sich haben --*
		lea	EPG_FirstFileStruct(a5),a3
		tst.l	(a3)
		beq.w	.Return
.NextRandom:	move.l	(a3),d0
		beq.s	.AllTested
		move.l	d0,a3
		moveq	#0,d0
		tst.b	OnDirjump(a5)
		bne.s	.NextR2
		move.b	EFP_Flags(a3),d0
		btst	#EFPF_Filename,d0
		beq.s	.NextRandom
.NextR2:	tst.b	EFP_NameRKennung(a3)
		beq.s	.NextItem		;Schleife geht bei alten Song
	;	beq.s	.VonAnfang		;los
		bra.b	.NextRandom
.AllTested:	bsr.w	ClearRandomMerks
		bra.w	RetryRandomModule ;verhindern, da spielendes
					 ;Module sofort wiedergeladen wird

	*----------- Nun Module raussuchen ---------*
	* d1 = Randomzhler			    *
.VonAnfang:	lea	EPG_FirstFileStruct(a5),a3
.NextItem:	move.l	(a3),d0
		beq.s	.VonAnfang
		move.l	d0,a3
		moveq	#0,d0
		tst.b	OnDirjump(a5)
		bne.w	.NextItemDJ2
		move.b	EFP_Flags(a3),d0
		btst	#EFPF_FileName,d0
		beq.s	.NextItem
.NextItemDJ2:	tst.b	EFP_NameRKennung(a3)
		bne.s	.NextItem		;Wenn Random bereits gewesen
						;--> Keine Zhler-Erhhung
		dbf	d1,.NextItem

	*---------- Vergleiche die gefunden Namen ----------*
	* Ist gefundener Name, der des spielenden Modules ? *
***		move.l	FileNameAdr(a5),d0		;Derzeitiger Name
***		beq.s	.RandomOk
***		move.l	d0,a0
		lea	TitleNamePuffer(a5),a0
		move.l	EFP_IT_IText(a3),a1
		jsr	A5StrCmp3(a5)
		bne.s	.RandomOk
		addq.l	#1,RandomVersuche(a5)
		bra.w	RetryRandomModule


	*---------- Testen, ob LHA-Archiv erwischt wurde -----------*
	* LHA-Archive werden als Directories betrachtet und nicht   *
	* in den RandomPlayMode mit einbezogen			    *
.RandomOk:	addq.l	#1,RandomVersuche(a5)
		move.b	#1,EFP_NameRKennung(a3)
		move.l	d0,d4
		move.l	EFP_PathArrayPtr(a3),d1
		move.l	d1,a0
		bne.s	.PfadGegeben


		lea	DirPuffer(a5),a0
		tst.w	Kick2On(a5)
		beq.s	.RandomNo20
		move.l	EFP_NameDirLock(a3),d1
		beq.s	.RandomNo20
		lea	TextPuffer(a5),a0
		move.l	a0,d2
		move.l	#DirPufferSize-2,d3
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVONameFromLock(a6)
		lea	TextPuffer(a5),a0
.RandomNo20:	move.l	a0,LoadFilePath(a5)
		move.l	EFP_IT_IText(a3),a2
		jsr	A5CreateLoadPath(a5)
		lea	PathPuffer(a5),a0
.PfadGegeben:	jsr	A5TestAufArchive(a5)
		bne.s	.NoLHADirFound

		*--- File ist ein Archive, laden ? ---*
		tst.b	OnDirjump(a5)
		bne.w	.NoLHADirFound

		tst.b	OnExtractFirstModule(a5)	*Nur erstes Module ent-
		bne.s	.NoLHADirFound			*packen --> Suchen

	tst.b	MustRandomModule(a5)
	bne.s	.KeinFehler
		
	move.l	RandomVersuche(a5),d1	* n ;wenn nur ein File im Dir und
	cmp.l	EPG_Mods(a5),d1		* n ;dieses ist ein Archiv
	bhs	.Error .NoLHADirFound		* n ;dann trotzdem laden !!!
	tst.l	d0
	beq.w	.Notfound


	*--- Es wurde ein noch nicht abgespieltes Module ausgesucht ---*
.NoLHADirFound:	move.l	a3,a0
		jsr	A5LoadStructModule(a5)
		cmp.w	#EPR_InvalidNr,d0
		beq.w	.NotFound
		tst.b	DirJumpNewDir(a5)		;Parent gemacht
		bne.w	PlayRandomModule		;Neues Dir !!!!
		tst.l	d0
.Return:	rts

.Error:		moveq	#EPR_NoModuleloaded,d0
.ErrorinD0:	jmp	A5ScrollNewFehler(a5)
.KeinFehler:	moveq	#0,d0
		rts

*-------------------- Lscht alle Random-Kennungen im MenuPuffer -----------*
ClearRandomMerks:movem.l d0-a6,-(a7)
		lea	EPG_FirstFileStruct(a5),a3
		tst.l	(a3)
		beq.w	.Return
.NextRandom:	move.l	(a3),d0
		beq.s	.Return
		move.l	d0,a3
		clr.b	EFP_NameRKennung(a3)
		bra.b	.NextRandom
.Return:	movem.l	(a7)+,d0-a6
		rts

*------------------- Zufallsgenerator nach `bekanntem` Prinzip -------------*
RND2:		lea	RndSeed2(a5),a0
		bra.s	A_Rnd

RND:		lea	RndSeed(a5),a0
A_Rnd:		move.l	(a0),d0
		add.l	d0,d0
		bhi.s	.over
		eor.l	#$1d872b41,d0
.over:		move.l	d0,(a0)
		and.l	#$ffff,d0
		divu	d1,d0
		swap	d0
		rts

*------------------ ein paar Durchlufe fr die Randomroutine --------------*
*------------------ damit nie dieselben Anfangsmodule kommen ---------------*
InitRandom:	move.l	DTG_IntuitionBase(a5),a6
		lea	SecondsZahler2(a5),a0
		lea	MicrosZahler(a5),a1
		jsr	_LVOCurrentTime(a6)

		move.l	MicrosZahler(a5),d3
		divu	#10000,d3
		divu	#100,d3
		and.w	#$fff,d3
.W		bsr	Rnd
		dbf	d3,.w

		move.l	MicrosZahler(a5),d3
		moveq	#10,d0
		lsr.l	d0,d3
		and.w	#$fff,d3
.W2		bsr	Rnd2
		dbf	d3,.W2
		rts

*------------ Suche nach Eintrag der vor dem von FileNameAdr liegt ----------*
* Input:	d0=Type							     *
*		d2=zu suchende EintragNr !!!!! nicht ModuleNr.		     *
* OutPut:	d0=Error oder NULL					     *
*		a0=Struktur fr des Eintrages (nicht des Moduls)	     *
*		a1=Structur fr prev Module (nur bei Filename)		     *
*		a2=Struktur fr Next Module (nur bei Filename)		     *
*----------------------------------------------------------------------------*
*EFPF_FileName		EQU	0
*EFPF_DirName		EQU	1
*EFPF_Parent		EQU	2
*EFPF_ArchiveDir	EQU	3
*EFPF_ArchiveFile	EQU	4
*EFPF_All		EQU	-1

SucheStruktur:	movem.l	d1-d7/a3-a6,-(a7)
		move.l	d0,d6
		sub.l	a0,a0
		sub.l	a1,a1
		sub.l	a2,a2
		moveq	#EPR_DirIsEmpty,d7
	*	tst.l	EPG_Mods(a5)
	*	beq.s	.Error

*	subq.w	#1,d2
*	blt.s	.Error
		moveq	#EPR_ErrorInArguments,d7
		lea	EPG_FirstFileStruct(a5),a0
		move.l	LastModulesEintrag(a5),d5	*Prev Module
.NextItem:	move.l	a0,a1
		move.l	(a1),d0
		beq.s	.Error
		move.l	d0,a0			*a0=gesuchte FileStruct
		cmp.w	EFP_ModuleNr(a0),d2
		beq.s	.ModuleFound
		move.b	EFP_Flags(a0),d0		*solange suchen, bis 
		btst	#EFPF_FileName,d0		*nchster Filename
		beq.w	.NextItem
		move.l	a0,d5
		bra.s	.NextItem


.ModuleFound:

	*-- Next & Prev bei Directories finden --*
		move.l	EPG_FirstFileStruct(a5),a4
		cmp.l	a4,a0
		bne.s	.NimmThisLast
		move.l	LastModulesEintrag(a5),a1		;Letzter Module
.NimmThisLast:	move.l	(a0),d0
		bne.s	.NimmNormalNext
		move.l	EPG_FirstFileStruct(a5),d0
.NimmNormalNext:move.l	d0,a2
		cmp.l	#EFPF_All,d6			;stimmt Type
		beq.s	.StructOk
		cmp.l	#EFPF_Dirname,d6		;stimmt Type
		beq.s	.StructOk

	*-- Next & Prev bei FileEintrgen finden --*
		move.l	d5,a1				*Prev setzen
		move.l	(a0),d0
.RetryFileName:	bne.s	.NimmNormalNext2
		move.l	FirstModulesEintrag(a5),d0
.NimmNormalNext2:
		move.l	d0,a2
		move.l	(a2),d0
		move.b	EFP_Flags(a2),d1		*solange suchen, bis 
		btst	#EFPF_FileName,d1		*nchster Filename
		beq.w	.RetryFileName			*gefunden

		*cmp.l	#EFPF_FileName,d6			;stimmt Type
		*beq.s	.StructOk



.StructOk:	moveq	#0,d7
.Error:		move.l	d7,d0
		movem.l	(a7)+,d1-d7/a3-a6
		tst.l	d0
		rts






*------------- Spiele den Speicher ab Adr (EPG_Arg1;EPG_Arg2) ----------------*
PlayMem:	bsr.s	.PlayMem
		clr.b	PlayMemory(a5)
		tst.l	d0
		bne.w	ToScrollNewFehler
		rts

.PlayMem:	jsr	A5FreeLFModule(a5)
		jsr	A5ClearProTemps(a5)
		lea	Pathpuffer(a5),a0
		move.l	a0,DTG_PathArrayPtr(a5)
		lea	DirPuffer(a5),a0
		move.l	a0,DTG_DirArrayPtr(a5)
		move.b	#1,PlayMemory(a5)
		clr.b	LoadFileBytes(a5)
		clr.b	NurLFLoad(a5)
		clr.l	PPAdr(a5)
		clr.l	PPSize(a5)
		clr.l	File(a5)
		clr.l	LFNummer(a5)
		clr.l	LoadPlayerStart(a5)
		clr.l	LoadPlayerAdr(a5)
		clr.w	LoadPlayerSKenn(a5)		;Player
		clr.l	EPG_ChkSegment(a5)
		clr.b	RippedFile(a5)
		clr.l	LoadFileName(a5)

	move.l	UPrg_Struct(a5),d0
	beq.w	UnknownPPFormat
	move.l	d0,a0
	move.l	ENA_Arg2(a0),d3			*Size des Modules
		*move.l	EPG_Arg3(a5),d3
		*beq.w	UnknownPPFormat
		move.l	d3,DTG_ChkSize(a5)
		move.l	d3,LFPuffer+4(a5)
		move.l	d3,FileSizeNeu(A5)

	*------ entsprechenden Memory besorgen -------*
		moveq	#2,d4				;Chip-Mem besorgen
		tst.b	OnLoadFast(a5)
		beq.s	.NoLoadToFast
		moveq	#1,d4				;Fastmem eingestellt
.NoLoadToFast:	add.l	#MemDrauf,d3
*
		move.l	d3,LFPuffer+12(a5)
*
		jsr	A5AllocModuleMem(a5)
		beq.w	ErrorAllocMem2
		move.l	d0,DTG_ChkData(a5)
		move.l	d0,File(a5)
		move.l	d0,LFPuffer(a5)
*
		move.l	d0,LFPuffer+8(a5)
*

	*--------- Speicherbereich kopieren ----------*
	move.l	d0,a1				*Ziel
	move.l	UPrg_Struct(a5),a0
	move.l	ENA_Arg2(a0),d0			*Size
	move.l	ENA_Arg1(a0),a0			*Startadr
		*move.l	EPG_Arg1(a5),a0
		*move.l	d0,a1
		*move.l	EPG_Arg3(a5),d0
	;	move.l	4,a6
	;	jsr	_LVOCopyMem(a6)
		jsr	A5CopyMemQuick(a5)



	*---- Namen setzen, falls keiner angegeben ist ----*
		moveq	#Namenlange,d1
		LA0	LNr_Unknown
		move.l	UPrg_Struct(a5),d0
		beq.s	.NoUPrg_Struct
		move.l	d0,a1
		move.l	ENA_Size(a1),d0
		beq.s	.NoUPrg_Struct
		cmp.w	#ENA_String,d0
		ble.s	.NoUPrg_Struct
		lea	ENA_String(a1),a1
		tst.b	(a1)
		beq.s	.NoUPrg_Struct
		sub.w	#ENA_String,d0
		move.l	d0,d1
		move.l	a1,a0
.NoUPrg_Struct:	lea	TitleNamePuffer2(a5),a1		;nach TitlenameAdr2
		jsr	A5StringCopy2(a5)

		lea	TitleNamePuffer2(a5),a0
		lea	FilePuffer(a5),a1		;nach FilePuffer
		move.l	a1,DTG_FileArrayPtr(a5)
		jsr	A5StringCopy2(a5)

		lea	TitleNamePuffer2(a5),a0
		jsr	A5LoadNeededPlayer(a5)



	*----------- Soundsystem checken -----------*
		addq.l	#1,LFNummer(a5)

	*-------------- Erster Test fr Player-Checker --------------*
	* 
		move.l	FileSizeNeu(a5),d0		;
		move.l	FileSizeNeu(a5),d1		;
		move.l	File(a5),a0		;
		jsr	A5PlayerChecker(a5)	;


	*--------------------- Auf EP_Check5 testen ---------------------*
	* Bei EP_Check5 ist der Speichertyp egal, daher hier immer ein	 *
	* Check	!!! Desweiteren ist der Speichertyp bereits festgelegt ! *
	*----------------------------------------------------------------*
		clr.l	LoadPlayerStart(a5)
		move.l	LFPuffer(a5),DTG_ChkData(a5)
		move.l	LFPuffer+4(a5),DTG_ChkSize(a5)
		move.l	#EP_Check5,d4
		jsr	A5CheckSoundsys(a5)
		beq.w	.PlayerFound

	*--------------------- Auf EP_Check3 testen ---------------------*
	* Bei EP_Check3 ist der Speichertyp egal, daher hier immer ein	 *
	* Check	!!! Diese Funktion ist eingebaut, damit bei eingeschalte *
	* tem LoadFast auch gepackte Module erkannt werden, wo der Player*
	* nur EP_Check3 und DTP_Check2 untersttzt.			 *
	*----------------------------------------------------------------*
		clr.l	LoadPlayerStart(a5)
		move.l	LFPuffer(a5),DTG_ChkData(a5)
		move.l	LFPuffer+4(a5),DTG_ChkSize(a5)
		move.l	#EP_Check3,d4
		jsr	A5CheckSoundsys(a5)
		beq.w	.PlayerFound

	*--------------------- Auf DTP_Check2 testen --------------------*
		clr.l	LoadPlayerStart(a5)
		move.l	LFPuffer(a5),DTG_ChkData(a5)
		move.l	LFPuffer+4(a5),DTG_ChkSize(a5)
		move.l	#DTP_Check2,d4
		jsr	A5CheckSoundsys(a5)
		bne.w	FileRippen		*UnknownPPFormat
		move.l	a6,LoadPlayerAdr(a5)

	*----- Jetzt mu das Module in den Chip-Ram kopiert werden ------*
	*------- Memtyp feststellen -------*
		move.l	LFPuffer(a5),a1
		ExecBase
		jsr	_LVOTypeOfMem(a6)
		btst	#1,d0			;es handelt sich bereits um
		bne.s	.NoCheck2		;Chipram
*
	*move.l	LFPuffer+4(a5),d0
	*add.l	#MemDrauf,d0
	move.l	LFPuffer+12(a5),d0

		moveq	#3,d1			;ChipRam holen
		ExecBase
		jsr	_LVOAllocMem(a6)
		tst.l	d0
		beq.w	ErrorAllocMem2

	*-------- Speicher besorgen ------*
		move.l	d0,a4
		move.l	d0,a1
	*move.l	LFPuffer(a5),a0
	*move.l	LFPuffer+4(a5),d0
	*add.l	#MemDrauf,d0
	move.l	LFPuffer+8(a5),a0
	move.l	LFPUffer+12(a5),d0
		jsr	A5CopyMemQuick(a5)

	*--- alten Speicher freigeben ----*
	*move.l	LFPuffer(a5),a1
	*move.l	LFPuffer+4(a5),d0
	*add.l	#MemDrauf,d0
	move.l	LFPuffer+8(a5),a1
	move.l	LFPuffer+12(a5),d0
		move.l	4,a6
		jsr	_LVOFreeMem(a6)
		move.l	a4,LFPuffer(a5)
	move.l	a4,LFPuffer+8(a5)

	*--- Nochmal checken, weil in einigen Playern in der Checkroutine ---*
	*---- Sprungadressen gemerkt werden, die ja jetzt nicht da sind -----*
	*--------------------- Auf DTP_Check2 testen --------------------*
		clr.l	LoadPlayerAdr(a5)
		clr.l	LoadPlayerStart(a5)
		clr.w	LoadPlayerSKenn(a5)		;alte Kennung laden
		move.l	LFPuffer(a5),DTG_ChkData(a5)
		move.l	LFPuffer+4(a5),DTG_ChkSize(a5)
		move.l	#DTP_Check2,d4
		jsr	A5CheckSoundsys(a5)
		*bne.w	FileRippen		*UnknownPPFormat
		bne.w	UnknownPPFormat		*mu ja erkannt werden !!!
.PlayerFound:	move.l	a6,LoadPlayerAdr(a5)
.NoCheck2:

;		move.l	DTG_ChkSize(a5),LFPuffer+4(a5)
;		move.l	#DTP_Check2,d4
;		jsr	A5CheckSoundsys(a5)
;		beq.s	.PlayerFound
;
;		move.l	LFPuffer(a5),DTG_ChkData(a5)
;		move.l	LFPuffer+4(a5),DTG_ChkSize(a5)
;		move.l	#EP_Check5,d4
;		jsr	A5CheckSoundsys(a5)
;		*bne.w	FileRippen		*UnknownPPFormat
;		bne.w	UnknownPPFormat		*Mu ja erkannt werden
;.PlayerFound:	move.l	a6,LoadPlayerAdr(a5)

		move.l	LoadPlayerAdr(a5),a6
		jsr	A5NewExtLoad(a5)
		*move.l	LoadPlayerAdr(a5),a6
		*move.l	#DTP_ExtLoad,d0
		*jsr	A5CallUp3(a5)
		beq.s	.NoExtLoad
		tst.l	d0
		beq.s	.NoExtLoad

	*----------- ExtLoading freigeben ----------*
		move.l	d0,-(a7)
		jsr	A5FreeExtLoad(a5)
		bsr.w	UnknownPPFormat
		move.l	(a7)+,d0
		bra.s	.Return

.NoExtLoad:	jsr	A5LFModuleLoaded(a5)
		moveq	#0,d0
.Return:	tst.l	d0
		rts




	;*************************************************************
	;**** Copiert den Dir-Anteil des Phades nach Puffer in a0 ****
	;**** Input =	a0 Puffer frs Dir			  ****
	;****		a1 Puffer wo Path steht			  ****
	;****		d3 Lnge des Phades			  ****
	;**** Output	a0 Startadr des Filenames		  ****
	;*************************************************************
CreateDirAusPath:movem.l d0-d2/d4-d7/a1-a6,-(a7)
		move.l	a1,a3
		move.l	a1,a2
		clr.b	(a0)
		tst.l	d3
		blt.s	.KeineSize

		lea	1(a1,d3.l),a1
		subq.l	#1,d3
.NextB		subq.l	#1,a1
		cmp.b	#"/",(a1)
		beq.s	.Found
		cmp.b	#":",(a1)
		beq.s	.Found
		dbf	d3,.NextB
		*addq.l	#1,d3
		bra.b	.NoDir
.Found:		addq.l	#1,a1
		move.l	a1,a2

	*------ Directory copieren ------*
		move.l	a3,a1			;Adr des Phades
		addq.l	#1,d3
		move.l	d3,d1			;RestSize fr DirCopy
		blt.s	.NoDir
		jsr	A5CopyText2(a5)
		clr.b	(a0)+
.NoDir:		move.l	a2,a0
.KeineSize:	movem.l	(a7)+,d0-d2/d4-d7/a1-a6
		rts



	;**************** Filename copieren ******************
	;**** Input	a1 = Start of String		  ****
	;****		a0 = Wohin mit Filename		  ****
	;****		d3 = Length des DirsStrings	  ****
	;****	Arg1	   = max Length des phades	  ****
	;****	d2	   = max Length des phades	  ****
	;*****************************************************
CopyFilename:	movem.l	d0-a6,-(a7)
		clr.b	(a0)
		tst.w	d3
		blt.s	.NoFilename
		addq.l	#1,d3
	;moveq	#31,d1
		move.l	d2,d1
;		addq.l	#1,d1
		sub.l	d3,d1
		blt.s	.NoFilename			;changed 27.01.97
	*	beq.s	.NoFilename
		cmp.w	#Namenlange-2,d1
		blo.s	.LengthOk
		moveq	#Namenlange-2,d1
.LengthOk:	jsr	A5CopyText2(a5)
		clr.b	(a0)
.NoFileName:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* d2=Len of Author
* a2=Adr of Name
SetAuthor:	move.l	a2,a0
		lea	ComposerPuffer(a5),a1
		move.l	a1,EPG_Author(a5)
		move.l	d2,d1
		subq.l	#1,d1
		bsr	StringCopy2
		bsr	TitleAufbau
		moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
* Die Args sehen folgendermaen aus!
* Arg1=Adr des Listdirs
* Arg2=Adr des Listfiles
* Arg3=Adr der Modulesliste (je nach Gruppe)
* Arg4=Adr der Autorenliste (Autorenprefs)
* Arg5=Adr der Gruppenliste (Gruppenprefs)
LoadPysionList:	moveq	#EPR_ErrorInArguments,d7
		move.l	UPrg_Struct(a5),a4
		move.l	ENA_Arg1(a4),a0
		lea	ListPuffer(a5),a1
		move.w	#DirPufferSize-2,d1
		jsr	A5StringCopy2(a5)

	lea	ListPuffer(a5),a1
	jsr	A5MakecorrectDir(a5)
		move.l	ENA_Next(a4),d0
		beq.s	.Return
		move.l	d0,a4

	lea	ListPuffer(a5),a0
	jsr	A5BerechStringSize(a5)
	lea	(a0,d0.w),a1
	
		move.l	ENA_Arg1(a4),a0
		jsr	A5StringCopy2(a5)

		move.l	ENA_Next(a4),d0
		beq.s	.Return
		move.l	d0,a4
		move.l	ENA_Arg1(a4),d0
		beq.s	.Return
		move.l	d0,a0
*
*		lea	ListPuffer(a5),a1
*		jsr	A5MakeCorrectDir(a5)
*		lea	ListPuffer(a5),a0
*		jsr	A5BerechStringSize(a5)
*		lea	(a0,d0.w),a1
*		move.l	ENA_Arg2(a4),a0
*		jsr	A5StringCopy2(a5)
*		move.l	ENA_Next(a4),d0
*		beq.s	.Return
*		move.l	d0,a4
*		move.l	ENA_Arg2(a4),d1
*		move.l	ENA_Arg1(a4),a0
*

	*----------- Dir laden und setzen ------------*
	*------ Puffer fr Pull-Down-Menu creieren und setzen -------*
		moveq	#18,d0				;Mode LHA-Scan
		moveq	#0,d2				;Internal Puffer
		sub.l	a1,a1
		jsr	A5CreateFilesPuffer(a5)
		move.l	d0,d7
.Return:	move.l	d7,d0
		beq.s	.NoError
		jmp	A5ScrollNewFehler(a5)

.NoError:	move.b	#1,NewListLoaded(a5)
		move.w	#LNr_NewListLoaded,d0
		jmp	A5ScrollNew(a5)

.Error:		moveq	#EPR_NotEnoughArguments,d0
		jmp	A5ScrollNewFehler(a5)

*-----------------------------------------------------------------------------*
* d2=Pfadlnge
* a2=Pfadadr
* d3=1	nur Pfad setzen
LoadList:	tst.l	d2			;bei Aufruf aus LoadConfig
		beq.s	.NoCopy

		move.l	a2,a0
		lea	ListPuffer(a5),a1
		move.w	d2,d1
		cmp.w	#DirPufferSize-2,d1
		blo.s	.SizeOk
		move.w	#DirPufferSize-2,d1
.SizeOk:	subq.l	#1,d1
		jsr	A5StringCopy2(a5)
		tst.l	d3
		bne.w	.Return

.NoCopy:	cmp.l	#Mode_Config,TestBits(a5)
		beq.w	.Return

		lea	ListPuffer(a5),a1
		jsr	A5GetFileName(a5)
		move.l	a1,d0
		beq.s	.Filereq
		tst.b	(a1)
		bne.s	.FilenameDa
.Filereq	tst.l	d3			;Wenn d3 hier noch 1=Kennung
		bne.s	.Return			;dass von loadConfig aufgerufen

		*--- Filerequest ---*
		LA0	LNr_FR_LoadList
		lea	ListPuffer(a5),a1
		lea	TextPuffer(a5),a2
		jsr	A5GetMainWindowHandle(a5)
		move.l	d0,a3
		moveq	#0,d0			;Kennung ->> File zu laden
		jsr	A5FileRequest2(a5)
		bne.w	.Error

		lea	ListPuffer(a5),a1
		jsr	A5MakeCorrectDir(a5)
		lea	ListPuffer(a5),a0
		jsr	A5BerechStringSize(a5)
		lea	(a0,d0.w),a1
		lea	TextPuffer(a5),a0
		jsr	A5StringCopy(a5)

		*--- Jetzt Liste laden ---*
.FilenameDa:	lea	ListPuffer(a5),a1
		sub.l	a2,a2
		moveq	#1,d0
		moveq	#15,d1			;kein Check, keine Anzeige
		movem.l	a1-a4,-(a7)
		jsr	A5LoadFile(a5)
		movem.l	(a7)+,a1-a4
		tst.l	d0
		bne.s	.Error

		jsr	A5LoadProgrammList(a5)
		tst.l	d0
		beq.s	.Return

		move.l	d0,-(a7)
		move.l	File(a5),a1
		move.l	FileSizeNeu(a5),d0
		jsr	A5Freemem(a5)
		move.l	(a7)+,d0
		clr.l	File(a5)
		clr.l	FileSizeNeu(a5)
.Error:		jmp	A5ScrollNewFehler(a5)

.Return:	moveq	#0,d0
		rts


*---------------------------------------------------------------------------*
*---------------------------------------------------------------------------*
*------------------------------- Load Module -------------------------------*
*---------------------------------------------------------------------------*
*---------------------------------------------------------------------------*
* d2=Pfadlnge
* a2=Pfadadr
LoadModule:	tst.l	d2
		ble.s	.FileReq

		*------ Strings vorbereiten ----*
		move.l	d3,d5
		move.l	a2,a1
	subq.l	#1,d2
		move.l	d2,d3
		jsr	A5GetFilename(a5)
		cmp.l	a1,a2
		beq.s	.OnlyFilename
		move.l	a2,a1
		clr.b	FilePuffer(a5)
		*lea	(a2,d2.w),a0
		lea	1(a2,d2.w),a3
		*cmp.l	a0,a3
		*beq.s	.Only


		lea	DirPuffer(a5),a0
		cmp.w	#DirPufferSize,d3
		blo.s	.DirSizeOk
		move.l	#DirPuffersize,d3
.DirSizeOk:	jsr	A5CreateDirAusPath(a5)
		cmp.l	a0,a3
		beq.s	.LoadIt
		move.l	a0,a1			;Start of Filename
.OnlyFilename:	lea	FilePuffer(a5),a0
		jsr	A5CopyFileName(a5)
		tst.l	d5			;Multiselect ????
		beq.s	.LoadIt

		*-------- MultiSelect ?? -------*
		move.l	a3,a0			;MultiSelectAdr
		moveq	#11,d0			;Filerequestertype = Arexx
		moveq	#0,d1			;SpecialInfo
		moveq	#0,d2			;Use Internal Puffer
		jsr	A5CreateFilesPuffer(a5)	;Selectierte Dateien ins PMenu
		bne.w	ToScrollNewFehler
		bra.s	.LoadIt


		*---- Filerequester ausfhren ---*
.FileReq:	moveq	#0,d5
		moveq	#0,d0
		cmp.l	#Mode_Config,TestBits(a5)
		beq.s	.Return
		jsr	A5WaitMouse(a5)
		LA0	LNr_SW_SelectFile
		jsr	A5PrintText(a5)
		jsr	A5FileRequest(a5)
		bne.w	ToScrollNewFehler

	*--------------------------------------------------*
	* in DirPuffer ist das Directory vom File	   *
	* in FilePuffer ist der Filename vom File	   *
	*---- Load Module (a2=Adr des Namens) -----*
.LoadIt:	lea	DirPuffer(a5),a0
		jsr	A5KillLastSchraeg(a5)
		jsr	A5SetDirJumpPtr(a5)
		tst.b	MustRandomModule(a5)
		bne.s	.OnlyDir
		lea	FilePuffer(a5),a2
		lea	FilePuffer(a5),a1
		moveq	#0,d0
		tst.b	(a2)
		beq.s	.OnlyDir
		move.l	d5,-(a7)
		jsr	A5LoadThis(a5)
		move.l	(a7)+,d5
		move.l	d0,-(a7)			* Directory reinladen
		tst.l	d5
		bne.s	.NoDirLoading

		tst.b	OnExtractFirstModule(a5)
		beq.s	.NormalDir
		lea	DirPuffer(a5),a0	;ist Dir wirklich Archive ???
		jsr	A5TestAufArchive(a5)
		bne.s	.NormalDir
		lea	DirPuffer(a5),a1
		jsr	A5GetFilename(a5)
		clr.b	(a1)
.NormalDir:	jsr	A5LoadDirIn(a5)

.NoDirLoading:	move.l	(a7)+,d0
.DirDa		cmp.w	#EPR_DirNotChanged,d0
		beq.s	.NoError
		tst.l	d0
		bne	ToScrollNewFehler

	*------- Scroll "Playing ..." --------*
.NoError:	jsr	A5CreatePlayname(a5)
.Return:	rts

.OnlyDir:	jsr	A5LoadDirIn(a5)
		tst.b	MustRandomModule(a5)
		beq.s	.DirDa
		move.l	EPG_Mods(a5),d0
		beq.s	.Return

		move.b	OnDirJump(a5),d1
		move.l	d1,-(a7)
		clr.b	OnDirJump(a5)
		bsr	PlayRandomModule
		move.l	(a7)+,d1
		move.b	d1,OnDirJump(a5)		
		*cmp.w	#EPR_UnknownFormat,d0		;\
		*bne.s	.DirDa				; > 
		*moveq	#0,d0				;/
		bra.s	.DirDa

*----------------------------------------------------------------------------*
* a2=Pfad des Modules
* d3=Taglist des Formatloaders
Formatload:	move.l	d3,Formatload_Tags(a5)

		lea	Dirpuffer(a5),a0
		jsr	A5BerechStringSize(a5)
		move.l	d0,d3
		addq.l	#8,d0
		jsr	A5AllocMem(a5)
		move.l	d0,a3
		tst.l	d0
		beq.s	.NoMem
		move.l	a3,a1
		lea	DirPuffer(a5),a0
		move.l	d3,d1
		jsr	A5StringCopy2(a5)
.NoMem:		movem.l	a3/d3,-(a7)

		*------ Strings vorbereiten ----*
		moveq	#0,d3
		move.l	a2,a1
		jsr	A5GetFileName(a5)
		cmp.l	a2,a1
		beq.s	.NurName


		*--- Diranteil in Dirpuffer kopieren ---*
		move.l	d2,d3
		subq.l	#1,d3
		move.l	a2,a1
		lea	DirPuffer(a5),a0	;A0=Wohin mit Players.
		jsr	A5CreateDirAusPath(a5)	;A1=Path d3=Lnge

		move.l	a0,a1
.NurName:	lea	FilePuffer(a5),a0
		jsr	A5CopyFileName(a5)

		move.l	Formatload_Tags(a5),d0
		beq.s	.Error
		move.l	d0,a6
		move.l	#FL_Playername,d0
		jsr	A5FindTag2(a5)
		beq.s	.Error

		moveq	#0,d4
.RetryIt:	lea	EPG_FirstPlayerStruct(a5),a4
.Next:		move.l	(a4),d0
		beq.s	.LoadPlayer
		move.l	d0,a4

		lea	TextPuffer(a5),a0
		jsr	A5GetplayerName(a5)	a1=Playername
		move.l	a6,a0
		*move.l	EPPL_Node+LN_Name(a4),a0
		*move.l	a6,a1
		jsr	A5StrCMP3(a5)
		bne.s	.Next
		bra.s	.PlayerFound

.LoadPlayer:	tst.l	d4
		bne.s	.Error
		move.l	a6,a0
		lea	PlayersFile(a5),a1
		jsr	A5StringCopy(a5)

		move.b	#1,BatchLoading(a5)
		move.l	a6,-(a7)
		jsr	A5LoadOnePlayer(a5)
		move.l	(a7)+,a6
		moveq	#1,d4
		bra.s	.RetryIt


.PlayerFound:	move.l	EPPL_Taglist(a4),Formatload_PlayerAdr(a5)


		lea	FilePuffer(a5),a2
		move.l	a2,MenuFileName(a5)
		move.l	a2,DTG_FileArrayPtr(a5)
		lea	DirPuffer(a5),a1
		bsr.w	LoadFormatLoad
		bra.s	.Return
.Error:		moveq	#EPR_UnknownFormat,d0
		jsr	A5ScrollNewFehler(a5)
.Return:	movem.l	(a7)+,a3/d3
		move.l	d0,-(a7)
		move.l	a3,d0
		beq.s	.NoMem2
		move.l	a3,a0
		lea	Dirpuffer(a5),a1
		move.l	d3,d1
		jsr	A5StringCopy2(a5)
		move.l	a3,a1
		move.l	d3,d0
		addq.l	#8,d0
		jsr	A5FreeMem(a5)

.Nomem2:	move.l	(a7)+,d0
		tst.l	d0
		rts


*----------------------------------------------------------------------------*
LoadThis:	move.l	a2,MenuFileName(a5)
		move.l	a1,DTG_FileArrayPtr(a5)
		lea	DirPuffer(a5),a1
LoadFremdModule:clr.l	FormatLoad_Tags(a5)
		clr.l	FormatLoad_PlayerAdr(a5)
LoadFormatload:	move.l	a1,DTG_DirArrayPtr(a5)
		lea	PathPuffer(a5),a0
		move.l	a0,DTG_PathArrayPtr(a5)


		*clr.w	ScrollVerbot(a5)
		jsr	A5WaitMouse(a5)
		jsr	A5FreeLFModule(a5)



	*---- Namen im ModulesPuffer finden und setzen ----*
		movem.l	a0-a2,-(a7)
		move.l	DTG_FileArrayPtr(a5),a0
		jsr	A5GetModuleNr(a5)
		move.w	d0,LastModuleNr(a5)
		beq.w	.NoStruct
		*move.l	d0,d2
		*add.l	EPG_Dirs(a5),d2
		*moveq	#EFPF_FileName,d0
		*jsr	A5SucheStruktur(a5)
		*move.l	EFP_IT_IText(a0),MenuFileName(a5)
.NoStruct:	movem.l	(a7)+,a0-a2



		clr.b	PlayMemory(a5)
		clr.l	LFNummer(a5)		;Nummer fr LoadFile clearen
		clr.l	LFExtraMem(a5)
		clr.l	LFExtraMem+4(a5)
		clr.l	LFFormatname(a5)
		clr.l	LFSamplePtr(a5)
		clr.l	LFStartSong(a5)

		moveq	#EPR_FileNotFound,d0
		moveq	#0,d1			;Kein Filename ????
		cmp.l	a2,d1
		beq.w	ScrollNewFehler
		tst.b	(a2)
		beq.w	ScrollNewFehler

		moveq	#2,d0			;Memtyp
		moveq	#0,d1
		move.l	a2,FileNameAdr(a5)

		move.l	a2,a0			;eventuellen Player laden !!!
		clr.l	PlayerNameAnz(a5)	;Anzahl im Puffer lschen
		jsr	A5LoadNeededPlayer(a5)
	addq.w	#1,ClearMouseVerbot(a5)

		movem.l	d0-a6,-(a7)
		move.w	#EPNr_LockModule,d0
		moveq	#0,d2
		jsr	A5JumpTo(a5)
		movem.l	(a7)+,d0-a6


		clr.b	NewListLoaded(a5)	;fr DeliList
		clr.b	RippedFile(a5)
		clr.l	LoadErrorNr(a5)
		jsr	A5LoadFile(a5)
		move.l	d0,LoadErrorNr(a5)

		subq.w	#1,ClearMouseVerbot(a5)

		tst.l	LoadPlayerAdr(a5)
		beq.s	.LHADirScanned

		tst.l	d0
		beq.s	.ModuleLoadOK


	*------- LF-Puffer lschen --------*
.LHADirscanned:	move.w	#MaxLoadFiles*4,d1
		lea	LFPuffer(a5),a1
.ClrLFPuffer:	clr.l	(a1)+
		dbf	d1,.ClrLFPuffer	
		clr.l	LFExtraMem(a5)
		clr.l	LFExtraMem+4(a5)
		clr.l	LFFormatname(a5)
		clr.l	LFSamplePtr(a5)
		clr.l	LFStartSong(a5)

		clr.l	Formatload_Tags(a5)
		tst.b	NewListLoaded(a5)
		bne.s	.NewList

		jsr	A5DeleteAllOtherPlayers(a5)
		moveq	#-1,d1
		cmp.l	d0,d1
		beq.w	ScrollNewText
		tst.l	d0
		bne.s	.ErrorIstOk
		moveq	#EPR_UnknownFormat,d0
.ErrorIstOk:	jmp	A5ScrollNewFehler(a5)	;D0=Fehlermeldung

.NewList:	move.w	#LNr_NewListLoaded,d0
		jmp	A5ScrollNew(a5)

	*--------- Namen fr LF-Module copieren ---------*
.ModuleLoadOK:
		move.l	FileNameAdr(a5),a1
		tst.b	LHALoaded(a5)
		beq.s	.NOLHA
		move.l	MenuFileName(a5),a1
.NoLHA:		jsr	A5GetFilename(a5)
		*move.l	a1,FileNameAdr(a5)
		move.l	a1,a0
		lea	TitleNamePuffer2(a5),a1		;nach TitlenameAdr2
		moveq	#Namenlange-2,d1
		jsr	A5StringCopy2(a5)


LFModuleLoaded:	tst.b	NurLFLoad(a5)
		bne.w	NM_Return

		jsr	A5AllesRaus(a5)
		jsr	A5RenameTFile(a5)

		move.w	#MaxLoadFiles*4,d0
		lea	LFPuffer(a5),a1
		lea	MDPuffer(a5),a0
.CopyPu		move.l	(a1),(a0)+
		clr.l	(a1)+
		dbf	d0,.CopyPu	
		move.l	LFExtraMem(a5),MDExtraMem(a5)
		move.l	LFExtraMem+4(a5),MDExtraMem+4(a5)
		move.l	LFFormatName(a5),MDFormatName(a5)
		move.l	LFSamplePtr(a5),MDSamplePtr(a5)
		move.l	LFStartSong(a5),MDStartSong(a5)


		clr.l	File(a5)
		clr.l	FileSizeNeu(a5)
		clr.l	PPAdr(a5)
		clr.l	PPSize(a5)


		move.l	LoadPlayerAdr(a5),PlayerAdr(a5)
		jsr	InitPlayerMerkeName		;NamenAdr merken

		lea	TitleNamePuffer2(a5),a0
		lea	TitleNamePuffer(a5),a1
		jsr	A5StringCopy(a5)


	*------- Player initialisieren ------*
		jsr	A5InitPlayer(a5)
		jsr	A5MakeEPGSongName(a5)
		jsr	A5DeleteAllOtherPlayers(a5)
		tst.l	d0
		bne.w	ErrorInitPlayer

		*--- Richtigen Soundsystemnanem setzen ---*
		bsr	SetzeSystemname


		*-- bei gerippten Modulen den Songnamen nehmen --*
		tst.b	RippedFile(a5)
		beq.s	.NotRipped
		move.l	GetInfoAdr(a5),a6
		move.l	#MI_Songname,d0
		jsr	A5FindTag2(a5)
		beq.s	.NotRipped
		move.l	a6,a0
		lea	TitleNamePuffer(a5),a1
		jsr	A5StringCopy(a5)
		move.b	TitleNamePuffer(a5),d0
		cmp.b	#"a",d0
		blt.s	.NotRipped
		cmp.b	#"z",d0
		bhi.s	.NotRipped
		bclr	#5,d0
		move.b	d0,TitlenamePuffer(a5)

.NotRipped:	lea	TitleNamePuffer(a5),a0
		lea	FilePuffer(a5),a1
		jsr	A5StringCopy(a5)
		clr.b	RippedFile(a5)

	;********************************************
	;**** Module geladen und nun starten ??? ****
	;********************************************
		*move.w	DTG_SndNum(a5),FirstSubSong(a5)

	*------ Durch Config eingestellten Song spielen ------*
		tst.w	NextSongOn(a5)
		beq.w	.NormalInit
		move.l	ConfigSongNr(a5),d4
		bne.s	.ConfigSongNr

	*------ Einen zuflligen Song auswhlen ------*
		tst.b	OnRandomSong(a5)
		beq.s	.NormalInit
		move.l	#DTP_SubSongRange,d0
		jsr	A5FindTag(a5)
		beq.s	.NormalInit
		bsr.w	SetRandomSongNr
		move.l	EPG_Arg1(a5),d4

.ConfigSongNr:	sub.w	EPG_FirstSnd(a5),d4
		;subq.l	#1,d4
		move.l	#DTP_SubSongRange,d0		;Subsongrange ???
		jsr	A5FindTag(a5)
		beq.s	.SetSongNr			;nein, dann setzen
		cmp.w	MaxSubSong(a5),d4		;testen, ob Song mgl.
		bhi.w	.NormalInit
.SetSongNr:	add.w	d4,DTG_SndNum(a5)
		moveq	#0,d1
		move.w	DTG_SndNum(a5),d1
		move.l	MerkSubSongs(a5),d0
		bset	d1,d0
		move.l	d0,MerkSubSongs(a5)

	*-------- Normale Init-Routine -------*
.NormalInit:	clr.l	ConfigSongNr(a5)
		jsr	A5InitSound(a5)
		move.l	d0,d3


		jsr	A5TestAufFaults(a5)
		bne.w	ErrorInitPlayer2


		jsr	A5TitleAufbau(a5)
		jsr	A5GuiChanged(a5)
		lea	TitlenamePuffer(a5),a0
		moveq	#0,d0
		move.w	LastModuleNr(a5),d0
		move.l	d0,EPG_ModNr(a5)
		jsr	A5ClearTextWindow(a5)

		moveq	#USClass_NewModule,d0
		jsr	A5SendeAllMessage(a5)


		tst.l	d3				;Init-Error ???
		bne.w	TestError

		tst.b	OnQuickstart(a5)
		beq.w	QuickStartOff
		bra.s	PlayModule

	;*********************
	;**** Play Module ****
	;*********************
PlayModuleJumpto:
		tst.l	d2
		beq.w	PausePlay
		tst.l	d2
		bgt.s	PlayIt

PlayModule:	tst.l	PlayerAdr(a5)
		beq.w	NoModuleLoaded
		tst.b	InitOn(a5)
		beq.w	TestError


		tst.b	PlayOn(a5)
		bne.w	PausePlay

PlayIt:		tst.l	PlayerAdr(a5)
		beq.w	NoModuleLoaded
		tst.b	InitOn(a5)
		beq.w	TestError

Keybeq8:	tst.b	KeyOn(a5)			;KeyON modifiziert ???
		beq.w	.KeyOk				;.w lassen !
		move.l	Key_Struct(a5),d0
		beq.w	JaGuru3

.KeyOk:	
		jsr	A5ClearTextWindow(a5)
		tst.b	OnFadeIn(a5)
		beq.s	.NoWaitmouse
		jsr	A5WaitMouse(a5)
.NoWaitmouse:	jsr	A5StartInterrupt(a5)
		bne.w	ToScrollNewFehler
		jsr	A5KeyTester1(a5)

QuickStartOff:	jsr	A5LadeLFModule(a5)
		jmp	A5CreatePlayName(a5)



*---------------------------------------------------------------------------*
LadeLFModule:	movem.l	d1-a6,-(a7)
		tst.b	NotRausWerf(a5)
		bne.s	.Error2
.LadeLFModule2:	lea	NurLFLoad(a5),a0
		move.b	#1,(a0)
	*	tst.b	KeyOn-NurLFLoad(a0)
	*	beq.s	.ClrNurLF

		tst.b	OnLoadBefore(a5)
		beq.s	.ClrNurLf

		jsr	A5GetAbortMsg(a5)
		bne.s	.Error
		tst.l	d1
		beq.s	.LoadNext
.Error:		cmp.w	#EPR_Functionaborted,d0		;1. Durchlauf
		bne.s	.ClrNurLF

.LoadNext:	st	NotRausWerf(a5)			;aktuelles Mod drin lassen

		move.b	ProgrammMode(a5),d0
		move.l	d0,-(a7)
		cmp.b	#EPNrP_NoNextModule,d0
		bne.s	.PM_Ok
		move.b	#EPNrP_NextModule,ProgrammMode(a5)
.PM_Ok:		jsr	A5LoadProgrammModule(a5)
		move.l	(a7)+,d1
		move.b	d1,ProgrammMode(a5)
		sf	NotRausWerf(a5)			;Flag aus

		tst.l	LFNummer(a5)			;Mod ok
		bne.s	.ClrNurLF
		cmp.w	#EPR_NotEnoughMem,d0		;Out of Mem
		beq.s	.ClrNurLF

		tst.b	OnLoadAlways(a5)
		beq.s	.ClrNurLf

	*	lea	PMLoadAlways+12(pc),a1
	*	btst	#0,(a1)
	*	bne.s	.ClrNurLf
		jsr	A5AddAbortGadget(a5)
		beq.s	.LadeLFModule2

.ClrNurLF:	clr.b	NurLFLoad(a5)
		jsr	A5RemoveAbortGadget(a5)
.Error2:	movem.l	(a7)+,d1-a6
		jsr	A5CreatePlayName(a5)
NM_Return:	rts


*---------------------------------------------------------------------------*
CreatePlayname:	movem.l	d1-d7/a1-a6,-(a7)
		LA0	LNr_FT11
		tst.l	PlayerAdr(a5)
		beq.s	.PlayOk
		LA0	LNr_Playing
		tst.b	PlayOn(a5)
		bne.s	.PlayOK
		LA0	LNr_NowLoaded
.PlayOK:	move.l	a0,-(a7)
		lea	ScrollArgs(a5),a1
		lea	TitleNamePuffer(a5),a2
		move.l	a2,(a1)
		jsr	A5MakecorrectText(a5)
		lea	ScrollPuffer(a5),a0
		jsr	A5ScrollNewText(a5)
		move.l	(a7)+,ScrollLastLNrAdr(a5)
		movem.l	(a7)+,d1-d7/a1-a6
		rts

*----------------------------------------------------------------------------*
SetzeSystemName:clr.b	SoundSystemPuffer(a5)

		move.l	Formatload_Tags(a5),d0
		beq.s	.NoFormatTags
		move.l	d0,a6
		move.l	#FL_Flags,d0
		jsr	A5FindTag2(a5)
		beq.s	.NoFlags
		btst	#FLB_MiSoundsystem,d2
		bne.s	.NoFormatTags

.NoFlags:	move.l	Formatload_Tags(a5),d0
		beq.s	.NoFormatTags
		move.l	d0,a6
		move.l	#FL_Formatname,d0
		jsr	A5FindTag2(a5)
		bne.s	.PrintSys

.NoFormatTags:	move.l	MDFormatname(a5),d0		;fr Converter
		move.l	d0,a6
		bne.s	.PrintSys
		move.l	#MI_SoundSystem,d0

		move.l	GetInfoAdr(a5),d0
		beq.w	.NoMiStruct
		move.l	d0,a6
		move.l	#MI_SoundSystem,d0
		jsr	A5FindTag2(a5)
		bne.s	.PrintSys

.NoMiStruct:	move.l	#DTP_PlayerName,d0
		jsr	A5FindTag(a5)
		bne.s	.PrintSys
		moveq	#-1,d0
		cmp.l	MDPuffer+4(a5),d0
		bne.s	.Return
		lea	CU_Name,a6
.PrintSys:	lea	SoundSystemPuffer(a5),a1
		move.l	a1,EPG_Soundsystemname(a5)
		move.l	a6,a0
		jsr	A5StringCopy(a5)
.Return:	rts



*------------------- Gibt die ModuleNr eines Eintrags zurck ----------------*
* Input: a0 = Name des Modules
* Output:d0 = Nummer des Modules 
GetModuleNr:	movem.l	d1-a6,-(a7)
		moveq	#0,d6
		*tst.l	PlayerAdr(a5)
		*beq.w	.SetIt
		tst.b	(a0)
		beq.s	.Setit
		lea	EPG_FirstFileStruct(a5),a3
.NextModule:	move.l	(a3),d1
		beq.w	.SetIt
		move.l	d1,a3

		moveq	#0,d2
		move.b	EFP_Flags(a3),d2
		btst	#EFPF_Filename,d2
		beq.s	.NextModule

		addq.l	#1,d7				;Zhler erhhen
		move.l	EFP_IT_IText(a3),a1		;Namenpuffer nach a0
		jsr	A5StrCMP3(a5)
		bne.s	.NextModule
		move.w	EFP_ModuleNr(a3),d6
.SetIt:		move.l	d6,d0
		movem.l	(a7)+,d1-a6
		rts


	****************************************************
	**** Speicher fr Module/PPSpeicher besorgen 	****
	**** d4=Kennung ob Fast/Chip/Egal d3=MemSize	****
	**** d0=0 Error d0<>0 MemAdresse		****
	****************************************************
AllocModuleMem:	moveq	#0,d5				;Kennung 1. Versuch
.NextMemAlloc:	move.l	d3,d0
		move.l	d4,d1
		jsr	A5AllocMem2(a5)
		bne.s	.AllocReturn

		tst.l	d5				;Schon altes Modul
		bne.b	.ErrAllocMem			;entfernt ???
		tst.b	NurLFLoad(a5)			;Nur 2. Module laden
		bne.s	.ErrAllocMem

		*btst	#0,LoadFileBytes(a5)
		*bne.w	.NoRaus

		movem.l	d0-a6,-(a7)
		jsr	A5AllesRaus(a5)
		jsr	A5GuiChanged(a5)
		movem.l	(a7)+,d0-a6
		moveq	#1,d5
		bra.s	.NextMemAlloc

.ErrAllocMem:	moveq	#0,d0
.AllocReturn:	rts


	*---------------------------------*
	*--------- Play-Faster -----------*
	*---------------------------------*
PlayFaster:	tst.l	PlayerAdr(a5)
		beq.w	NoModuleLoaded
		tst.b	PlayOn(a5)
		bne.w	.Playok
		bsr	PlayModule
.PlayOk:	tst.b	PlayOn(a5)
		beq.w	NoModuleLoaded


		tst.b	SongEndNow(a5)
		bne.s	.Ret
		tst.b	TimeOverNow(a5)
		bne.s	.Ret

	*	jsr	A5Delay(a5)

		moveq	#10,d5
.PlayFaster:	move.l	d5,-(a7)
		move.l	#DTP_Interrupt,d0
		moveq	#0,d3
		jsr	A5CallUp(a5)
		move.l	(a7)+,d5
		dbf	d5,.PlayFaster

	;	tst.b	SongEndNow(a5)
	;	bne.s	.Ret				;SongEndFound
	;	tst.b	TimeOverNow(a5)
	;	bne.s	.Ret				;TimeOverFound

	*	lea	PlayFasterGadget+13,a0		;Abfrage ob Gadget
	*	btst.b	#7,(a0)				;noch gedrckt
	*	bne.s	PlayFaster
.Ret:		rts					;bra.s	warten


	*--------------------------------*
	*--------- Pause Play -----------*
	*--------------------------------*
PausePlay:	tst.l	PlayerAdr(a5)
		beq.w	NoModuleLoaded
		jsr	A5ClearTextWindow(a5)
		tst.b	OnFadeOut(a5)
		beq.s	.NoWaitmouse
		jsr	A5WaitMouse(a5)
	;	jsr	A5StopInterrupt(a5)
.NoWaitmouse:	moveq	#1,d7
		jsr	A5StopInterrupt2(a5)
		lea	TitleNamePuffer(a5),a0
		move.l	a0,ScrollArgs(a5)
		LA0	LNr_Pause
		jsr	A5ScrollNewText(a5)
		move.l	a0,ScrollLastLNrAdr(a5)
		rts

*----------------------------------------------------------------------------*
*----------------------------------------------------------------------------*
*------------- Es wurde ein Songende(0) bzw TimeOut(2) aktiviert ------------*
*-------------------- Der Song soll unterbrochen werden ---------------------*
*----------------------------------------------------------------------------*
BreakSongNow:	tst.b	OnLockModule(a5)
		bne.w	.BreakReturn

		move.w	#1,ClearMouseVerbot(a5)
		move.b	d0,BreakMode(a5)

;	*------- Testen, ob TimeMode aktiviert ist --------*
;		cmp.b	#2,BreakMode(a5)	;ist eine Zeit abgelaufen
;		bne.s	.SwitchSong
;		tst.b 	OnTimeMode(a5)
;		beq.s	.SwitchSong
;		move.l	#EP_Flags,d0
;		jsr	A5FindTag(a5)
;		beq.s	.SwitchSong
;		move.l	a6,d0
;		btst	#EPF_SongEnd,d0		;Player hat kein Songende
;		beq.s	.SwitchSong		;Zeit gelten lassen
;		jmp	A5Warten(a5)


	*---------- Nchsten Song/Module abspielen ---------*
.SwitchSong:	cmp.b	#2,BreakMode(a5)
		beq.s	.TimeOut

	*- Timeout ist aktiviert, testen ob min. TimeOut erfllt ist -*
		move.l	EPG_CurrentTime(a5),d0
	;	addq.l	#1,d0
		cmp.l	EPG_MinTimeOut(a5),d0
		blo.w	.BreakReturn

.TimeOut:	tst.b	OnRandomSong(a5)
		bne.s	.SubSongs
		tst.b	OnAutoSubSong(a5)
		beq.s	.NoSubSongs
.SubSongs:	tst.b	NextSongOn(a5)
		beq.s	.NoSubSongs

	*------- NextSong nur einmal aufrufen --------*
	*---- und testen, ob NextSong erfolgreich ----*
		move.w	#1,OnlyEinmal(a5)		;Kennung fr NextSong
		bsr.w	NextSong
		tst.w	OnlyEinmal(a5)			;0=error
		bne.w	.BreakReturn

		cmp.b	#EPNrP_NoNextModule,ProgrammMode(a5)	;LoadNext ???
		beq.s	.SetFirstSong			;nein --> weiter im Mod
		move.l	EPG_Mods(a5),d0			;nur 1 Module
		subq.l	#1,d0
		bne.s	.NoSubSongs			;wieder alle Songs

	*---------- ersten Song abspielen ----------*
.SetFirstSong:	tst.b	OnRandomSong(a5)
		bne.w	.TimeOut
		clr.l	EPG_Arg1(a5)
		addq.l	#1,EPG_Arg1(a5)
		bsr.w	SetSong
		tst.l	d0
		beq.w	.BreakReturn
		cmp.w	#EPR_FunctionNotEnabled,d0
		bne.w	.BreakReturn
		bra.s	.StopInterrupt

	*----------- nchstes Module abspielen -----------*
.NoSubSongs:	cmp.b	#EPNrP_NoNextModule,ProgrammMode(a5)
		beq.s	.StopInterrupt
		jsr	A5WaitMouse(a5)
		move.l	EPG_Mods(a5),d0
		subq.l	#1,d0
		beq.w	.BreakReturn


	*----------- Bei LoadAlways AbortMSg abfangen --------*

	*-- Test auf folgendes Ereignis --*
	*-- Dir mit Eintrgen di keine Module sind und Zeit ist
	*-- um
*	move.l	#200,d1
*	bsr	Delay3
		tst.b	SongEndVerbot(a5)
		bne.w	.BreakReturn

		addq.l	#1,LPM_Counter(a5)
		cmp.l	#1,LPM_Counter(a5)
		beq.s	.LPM_Ja
*		tst.b	OnLoadAlways(a5)
*		bne.s	.LPM_Ja
		jsr	A5GetAbortMSG(a5)
		bne.s	.LPM_Nein
		tst.l	d1
		beq.s	.LPM_Ja
.LPM_Nein:	move.b	#1,SongEndVerbot(a5)
		bra.w	.BreakReturn


.LPM_Ja:
		jsr	A5LoadProgrammModule(a5)
	*	tst.b	OnLoadAlways(a5)
	*	beq.s	.BreakReturn
		tst.l	LoadErrorNr(a5)
		beq.s	.BreakReturn

		tst.b	OnLoadAlways(a5)
		beq.s	.BreakReturn
	*	beq.s	.LPM_Nein

		jsr	A5AddAbortGadget(a5)
		beq.s	.NoSubSongs
		bra.s	.BreakReturn

	*	lea	PMLoadAlways+12(pc),a1
	*	btst	#0,(a1)
	*	beq.s	.BreakReturn
	*	bra.s	.NoSubSongs


	*--------------- Interrupt stoppen ---------------*
.StopInterrupt:	jsr	A5WaitMouse(a5)
		jsr	A5StopInterrupt(a5)

		LA0	LNr_SongIsOver
		move.b	BreakMode(a5),d0
		beq.s	.TextOk
		LA0	LNr_TimeIsOver
.TextOk:	jsr	A5ScrollNewText(a5)

		cmp.b	#2,BreakMode(a5)	;bei RestartSong und Songende
		bne.s	.Breakreturn		;den Song neu initialisieren
		jsr	A5InitSound(a5)
		beq.s	.BreakReturn

	*------- Init-Sound Error -------*
		moveq	#EPR_CorruptModule,d0
		bra.s	.BreakFehler

.BreakReturn:	moveq	#0,d0			;kein Fehler
.BreakFehler:	clr.w	OnlyEinmal(a5)
		clr.w	ClearMouseVerbot(a5)
		clr.b	TimeOverNow(a5)
		clr.b	SongEndNow(a5)
		clr.b	BreakMode(a5)
		jsr	A5RemoveAbortGadget(a5)
		jsr	A5ClearMouse(a5)
		tst.l	d0
		bne.s	.Error

		*jmp	A5Warten(a5)
		jmp	A5WartenReplayPort(a5)


.Error:		jsr	A5ScrollNewFehler(a5)
		*jmp	A5Warten(a5)
		jmp	A5WartenReplayPort(a5)



*--------------------------- Replay-Song -------------------------------*
ReplaySong:	tst.l	PlayerAdr(a5)
		beq.w	NoModuleLoaded

		jsr	A5ClearTextWindow(a5)

		jsr	A5WaitMouse(a5)
		moveq	#0,d3
		move.l	#DTP_Stop,d0
		jsr	A5CallUp(a5)
		bne.s	.RePlay2

		jsr	A5StopInterrupt(a5)
		jsr	A5EndSound(a5)
		jsr	A5InitSound(a5)
		bne.w	TestError
.RePlay2	jsr	A5StartInterrupt(a5)
		bne.w	ToScrollNewFehler
		moveq	#LNr_ReplaySong,d0
		jmp	A5ScrollNew(a5)


	;*******************
	;**** Stop Play ****
	;*******************
StopPlay:	tst.l	PlayerAdr(a5)
		beq.s	NoModuleLoaded
		tst.b	PlayOn(a5)
		beq.w	AllesOk				;Warten

		jsr	A5ClearTextWindow(a5)

		jsr	A5WaitMouse(a5)
		moveq	#0,d3
		move.l	#DTP_Stop,d0
		jsr	A5CallUp(a5)
		bne.s	.Stop2
		jsr	A5StopInterrupt(a5)
		jsr	A5InitSound(a5)
		bne.w	TestError
.Stop2		moveq	#LNr_StopPlay,d0
		jmp	A5ScrollNew(a5)



	;**********************
	;**** Eject Module ****
	;**********************
EjectModule:	jsr	A5FreeLFModule(a5)
		tst.l	PlayerAdr(a5)
		beq.s	NoModuleLoaded

		jsr	A5ClearTextWindow(a5)		;sollte Ok sein

		jsr	A5WaitMouse(a5)
		jsr	A5AllesRaus(a5)
		jsr	A5DeleteAllOther2(a5)
		jsr	A5GuiChanged(a5)
		moveq	#LNr_EjectModule,d0
		jmp	A5ScrollNew(a5)


NoModuleLoaded:	moveq	#EPR_NoModuleLoaded,d0
		jmp	A5ScrollNewFehler(a5)

FunktionNotEnabled:moveq #EPR_FunctionNotEnabled,d0
		jmp	A5ScrollNewFehler(a5)


;********************************************************
;**** 		    LoadMem Freigeben 		     ****
;********************************************************
;*** wenn ungepackt geladen -> 2000 Bytes draufadden ***
	*------ Decrunch-Speicher freigeben ------*
FreeLoadModule:	jsr	A5DeleteTFile(a5)
		jsr	A5DeleteAllOtherPlayers(a5)
		move.l	PPAdr(a5),d0
		beq.w	FreeLoadModule2
		move.l	d0,a1
		move.l	PPSize(a5),d0
		beq.s	FreeLoadModule2
		btst	#0,LoadFileBytes(a5)
		bne.w	.NoAdd2000_2
		add.l	#MemDrauf,d0
.NoAdd2000_2:	jsr	A5FreeMem(a5)
		clr.l	PPAdr(a5)
		clr.l	PPSize(a5)

		move.l	LFExtraMem(a5),d0
		beq.s	FreeLoadModule2
		move.l	d0,a1
		move.l	LFExtraMem+4(a5),d0
		jsr	A5Freemem(a5)
		clr.l	LFExtraMem(a5)
		clr.l	LFExtraMem+4(a5)

	;**** Mem des geladenen Files freigeben ****
FreeLoadModule2:move.l	File(a5),d0
		beq.s	.Ret
		move.l	d0,a1
		move.l	FileSizeNeu(a5),d0
		beq.s	.Ret
		cmp.l	#-1,d0
		bne.s	.NoSegment
		move.l	a1,d1
		asr.l	#2,d1
		subq.l	#1,d1
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOUnLoadSeg(a6)
		bra.s	.Ret

.NoSegment:	btst	#0,LoadFileBytes(a5)
		bne.w	.NoAdd2000
		tst.b	CrunchKennung(a5)
		bne.s	.NoAdd2000
		add.l	#MemDrauf,d0
.NoAdd2000:	clr.b	CrunchKennung(a5)
		jsr	A5FreeMem(a5)

.Ret:		clr.l	File(a5)
		clr.l	FileSizeNeu(a5)
		clr.l	EPG_ChkSegment(a5)

	*--------- XPK-HelpMemory freigeben ---------*
		move.l	XPKHelpAdr(a5),d0
		beq.s	.NoHelp
		move.l	d0,a1
		move.l	XPKHelpSize(a5),d0
		jsr	A5FreeMem(a5)

.NoHelp:	clr.l	XPKHelpAdr(a5)
		clr.l	XPKHelpSize(a5)
		rts


	;********************************************
	;**** Fehlermeldungen whrend des Ladens ****
	;********************************************
TestError:	moveq	#EPR_CorruptModule,d0
		jmp	A5ScrollNewFehler(a5)

ErrInvalidNr:	moveq	#EPR_InvalidNr,d0
		jmp	A5ScrollNewFehler(a5)
		*jmp	A5CopyScrollTextToArexxPuffer(a5)

FunctionNotImplemented:
		moveq	#EPR_NotImplemented,d0
		jmp	A5ScrollNewFehler(a5)
		*jmp	A5CopyScrollTextToArexxPuffer(a5)

ErrorInitPlayer2:bsr.w	EjectModule
		moveq	#EPR_CorruptModule,d0
		jmp	A5ScrollNewFehler(a5)

ErrorInitPlayer:moveq	#-1,d1
		cmp.l	d0,d1
		bne.s	.Normal
		moveq	#EPR_ErrorInstallPlayer,d0
.Normal:	move.l	d0,-(a7)
		jsr	A5AllesRaus2(a5)
		jsr	A5DeleteAllOther2(a5)	;alle Player deleten
		jsr	A5GuiChanged(a5)
		move.l	(a7)+,d0
		jmp	A5ScrollNewFehler(a5)

ErrorExtLoad2:	jsr	A5CloseDatei(a5)
		bra.b	ErrorExtLoad3
ErrorExtLoad:	jsr	A5FreeLoadModule(a5)
ErrorExtLoad3:	moveq	#EPR_ErrorExtLoad,d0
		btst	#2,LoadFileBytes(a5)
		beq.s	SubLFNummer		;Return
		rts

UnknownSS1:	jsr	A5CloseDatei(a5)
UnknownSS2:	moveq	#EPR_UnknownFormat,d0
		btst	#2,LoadFileBytes(a5)
		bne.s	SubReturn
SubLFNummer:	subq.l	#1,LFNummer(a5)
SubReturn:	rts				;bra.w	ScrollNewFehler

UnknownPPFormat:moveq	#0,d7

		jsr	A5LoadProgrammList(a5)

		jsr	A5FreeLoadModule(a5)
		bra.s	UnknownSS1

ErrorDecrunch:	jsr	A5FreeLoadModule(a5)
		moveq	#EPR_ErrorDecrunching,d0
		btst	#2,LoadFileBytes(a5)
		beq.s	SubLFNummer
		rts		

ErrModuleToShort:
		jsr	A5CloseDatei(a5)
		moveq	#EPR_ModuleTooShort,d0
		btst	#2,LoadFileBytes(a5)
		beq.w	SubLFNummer
		rts		

ErrorXPKDecrunch:jsr	A5FreeLoadModule(a5)
ErrorXPKDecrunch2:

		moveq	#EPR_XPKError,d0
		tst.b	FunctionAbortedNow(a5)
		beq.s	.NormalError
		moveq	#EPR_FunctionAborted,d0
.NormalError:	btst	#2,LoadFileBytes(a5)
		beq.w	SubLFNummer
		rts		

ErrorXPKNotFound:moveq	#EPR_XPKMasterNotFound,d0
		btst	#2,LoadFileBytes(a5)
		beq.w	SubLFNummer
		rts		

ErrorAllocMem:	jsr	A5CloseDatei(a5)
ErrorAllocMem2:	jsr	A5FreeLoadModule(a5)
		moveq	#EPR_NotEnoughMem,d0
		btst	#2,LoadFileBytes(a5)
		beq.w	SubLFNummer
		rts

ReadError1:	jsr	A5CloseDatei(a5)
		jsr	A5IOErr(a5)
		jsr	A5FreeLoadModule(a5)
		move.l	d0,LastLoadError(a5)
		moveq	#EPR_FileNotFound,d0
		btst	#2,LoadFileBytes(a5)
		beq.w	SubLFNummer
		rts

	*------ es ist beim Saven ein Fehler aufgetreten -------*
*ConfigWriteError:move.l	SaveHandle(a5),d7
*		clr.l	SaveHandle(a5)
WriteError:	jsr	A5CloseDatei(a5)
		beq.s	.NoDelete
		move.l	DTG_PathArrayPtr(a5),d1
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVODeleteFile(a6)
.NoDelete:	;bsr.w	SetErrorText
		bsr.b	OpenError2
		moveq	#EPR_WriteError,d0
		rts

	*---- es ist beim ffnen einer Datei ein Fehler aufgetreten ----*
OpenError:	jsr	A5IOerr(a5)
		move.l	d0,LastLoadError(a5)
	*jsr	A5SetErrorText(a5)
		btst	#2,LoadFileBytes(a5)
		bne.s	OpenError2
		subq.l	#1,LFNummer(a5)
OpenError2:
	*	lea	TextPuffer(a5),a0
	*	lea	ILoadError(pc),a1
	*	moveq	#IFileReqReady-ILoadError-1,d1
	*	jsr	A5CopyText2(a5)
	*	subq.l	#2,a0
	*	move.l	a0,a1
	*	move.b	#$20,(a0)+
	*	moveq	#14,d1
	*	jsr	A5CopyText2(a5)
	*	move.b	#2,(a0)
	*	lea	TextPuffer(a5),a0
		moveq	#EPR_FileNotFound,d0
		rts

CloseDatei:	moveq	#0,d0
		move.l	d7,d1
		beq.w	.Return
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOClose(a6)

	*---------- entpacktes LHA-File lschen --------*
		tst.b	LHALoaded(a5)
		beq.w	.NoLHA

		LA0	LNr_TName
		move.l	a0,d1
		move.l	#1005,d2
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.s	.NoTLock
		jsr	_LVOCurrentDir(a6)
		move.l	d0,-(a7)
		lea	PathPuffer(a5),a1
		jsr	A5GetFileName(a5)
		move.l	a1,d1
		lea	(a1),a0				\  sonst werden teil-
		jsr	A5TestAufArchive(a5)		 > weise Archive ge-
		move.l	DTG_Dosbase(a5),a6
		tst.l	d0
		beq.s	.NoTLock2				/  lscht.
		jsr	_LVODeleteFile(a6)
.NoTLock2:	move.l	(a7)+,d1
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnLock(a6)
.NoTLock:

		


.RetryDelete:

*	move.l	LoadFilePath(a5),a0
		lea	PathPuffer(a5),a0		\  sonst werden teil-
		jsr	A5TestAufArchive(a5)		 > weise Archive ge-
		beq.s	.NoLHA				/  lscht.


		lea	PathPuffer(a5),a0
		move.l	a0,d1
		move.l	DTG_Dosbase(a5),a6
		moveq	#0,d2
		jsr	_LVOSetProtection(a6)


		lea	PathPuffer(a5),a0
		move.l	a0,d1
		jsr	_LVODeleteFile(a6)

		lea	PathPuffer(a5),a0
		jsr	A5ParentArchiveDir(a5)
		bne.s	.NoLHA
		cmp.b	#":",(a0)			;Error ?
		beq.s	.NoLHA
		clr.b	(a0)
		bra.s	.RetryDelete



.NoLHA:		;clr.b	LHALoaded(a5)			;sonst geht ExtLoad
		moveq	#0,d7				;nicht
		moveq	#-1,d0
.Return		rts


*-------- Zur Irrefhrung noch ein "EKEY" ins geladene File setzen ----------*
Key_DecKeyFile2:move.l	#"EKEY"-$5687adef,d0		;irre
		add.l	#$5687adef,d0			;Irre
		move.l	d0,(a4)				;irre
		eor.w	#$ade6,4(a4)			;irre
		eor.l	#$169ae4b2,EPKF_DeFileSize(a4)	;irre
		rts


* d2=-1 ---> Reset all Voices
* d2=VoiceNr a2=-1 dann Volumewert ignorieren
* d3=Volumewert
* (a1)=Zustand
Voices:		tst.w	d2
		ble.w	.ResetAll

		moveq	#EPR_ErrorInArguments,d0
		move.w	EPG_VoiceTableEntries(a5),d4
		cmp.w	d2,d4
		blt.w	.NoTable
		move.l	d2,ScrollArgs(a5)	;VoiceNr
		add.w	d2,d2			;VoiceNr verdoppeln
		add.w	d4,d2			;Start of InternPuffer
		cmp.l	#EP_MaxVolume,d3
		bhi.w	.NoTable
		move.l	EPG_VoiceTable(a5),d1
		beq.w	.NoTable
		move.l	d1,a0
	cmp.l	#-1,a2
	beq.s	.OnlyZustand
		move.b	d3,-2(a0,d2.w)		;ConfigVolumewert setzen

		*------ Zustand rauslesen ------*
		* a1=Nchsten Arg		*
		moveq	#EPRTAB_Zustand1!EPRTAB_Must1,d0
		movem.l	d2/d3/a0,-(a7)
		bsr	GibArg			;>- d0=Fehler oder Null
		movem.l	(a7)+,d2/d3/a0
		tst.l	d0
		bne.s	.NoTable		;>- d1=Zahl,Zustand,StringSize
		move.l	d1,d3
.OnlyZustand:	move.b	d3,-1(a0,d2.w)
		lea	-2(a0,d2.w),a3
		jsr	A5EPP_SetVoices(a5)

		La0	LNr_VoiceOff
		tst.l	d3
		beq.s	.Reset2
	*	cmp.l	#-1,a2
	*	beq.s	.OnlyZustand2
		LA0	LNr_VoiceX
		moveq	#0,d3
		move.b	(a3),d3
		move.l	d3,a1
.OnlyZustand2:	move.l	a1,ScrollArgs+4(a5)
.Reset2:	move.l	a0,-(a7)
		move.l	#EUT_ChangePrefs,d7
		move.w	#EPNr_Voices,d0
		jsr	A5UserCallUp4(a5)
		moveq	#EPNr_Voices,d0
		jsr	A5SetMutalExclude(a5)
		move.l	(a7)+,a0
		jsr	A5ScrollNewText(a5)
.NoTable:	rts


	*------------- Reset all Voices ---------------*
.ResetAll:	lea	InternVoicePuffer(a5),a0
		move.w	#EP_MaxVoices,d1
		lea	(a0,d1.w),a1
		subq.l	#1,d1
.FillVoicePuffer:
		move.b	d3,(a0)+			* eing. Lautstrke
		move.b	d3,(a1)+			* tats. Lautstrke
		move.b	#1,(a1)+			* Voice on
		dbf	d1,.FillVoicePuffer
		jsr	A5EPP_SetVoices(a5)
		LA0	LNr_ResetVoices
		bra.s	.Reset2	


*------------------------- Stringgadget fr Mainwindow ----------------------*
*-----	d0 = Mode 0=Ziffern 1=Text !2=Invisible				-----*
*-----  d1 = MinValue (bei Ziffern)					-----*
*-----	d2 = max. Lnge des Strings oder MaxValue			-----*
*-----	a0 = Puffer fr Text oder ZellenAdr				-----*
*-----	a1 = TextFmT							-----*
*-----  a2 = TextFmtArgs						-----*
*-----	a3 = Requestertitle						-----*
*----- Output:								-----*
*-----	d0 = Ergebnis 0=Ok, sonst Error					-----*
*-----  d1 = Anzahl der eingebenen Zeichen oder Long			-----*
*----------------------------------------------------------------------------*
	;*****************************************************
	;**** Gadget-Initialisierung fr Password-Eingabe ****
	;*****************************************************
GetPassword:	moveq	#PasswordPufferSize-2,d0		;Length
GetPassword2:	movem.l	d1-a6,-(a7)
		tst.b	OnAutoPassword(a5)
		bne.s	.Return


		cmp.l	#PasswordPufferSize-2,d0
		bls.s	.SizeOk
		moveq	#PasswordPufferSize-2,d0
.SizeOk:	move.l	d0,d2
		

		*--- Sicherheitskopie ---*
		lea	PasswordPuffer(a5),a0
		lea	TextPuffer(a5),a1
		moveq	#PasswordPufferSize-2,d1
		jsr	A5StringCopy2(a5)

		lea	PasswordPuffer(a5),a0
		lea	1(a0),a1
		clr.b	(a1)
		moveq	#PasswordPufferSize-3,d1
		jsr	A5CopyText2(a5)


	*------- String-Gadget aktivieren ------*
		LA1	LNr_SG_Password
		move.l	a1,ScrollArgs(a5)
		lea	PasswordPuffer(a5),a0
		LA1	LNr_PleaseEnter
		lea	ScrollArgs(a5),a2
		sub.l	a3,a3
		moveq	#EPTRB_String!EPTRB_Invisible,d0	;Text+Invisible
		moveq	#0,d1
		*moveq	#PasswordPufferSize-2,d2
		jsr	A5GetStringGadget(a5)
		tst.l	d0
		beq.s	.Return

		*--- Sicherheitskopie ---*
		lea	TextPuffer(a5),a0
		lea	PasswordPuffer(a5),a1
		moveq	#PasswordPufferSize-2,d1
		jsr	A5StringCopy2(a5)

.Return:	movem.l	(a7)+,d1-a6
SetPassword:	LA0	LNr_Password
		jmp	A5ScrollNewText(a5)


*----------------------------------------------------------------------------*
SetPlayTime:	cmp.l	EPG_MinTimeOut(a5),d2
		bhi.s	.OK
		move.l	d2,EPG_MinTimeOut(a5)
.OK:		move.l	d2,EPG_TimeOut(a5)
		bra.s	SetPrefsTime

SetMinPlayTime:	cmp.l	EPG_TimeOut(a5),d2
		blo.s	.OK
		move.l	d2,EPG_TimeOut(a5)
.OK:		move.l	d2,EPG_MinTimeOut(a5)
SetPrefsTime:	bsr	SetRealyTime


		move.l	#EUT_ChangePrefs,d7
		move.w	#EPNr_PlayTime,d0
		moveq	#0,d1
		move.l	EPG_Timeout(a5),d1
		moveq	#0,d2			;aus
		jsr	A5UserCallUp4(a5)


		move.w	EPRT_Status(a4),d0
		move.l	(a5,d0.w),ScrollArgs(a5)
		moveq	#0,d0
		add.b	EPRT_Reserved(a4),d0
		add.w	#LNr_SG_Publicscreen+1,d0
		jmp	A5ScrollNew(a5)

SetRealyTime:	movem.l	d1-a6,-(a7)
		move.l	EPG_MinTimeOut(a5),d0
		cmp.l	EPG_TimeOut(a5),d0
		blo.s	.OK
		move.l	d0,EPG_TimeOut(a5)
.OK:		move.l	d0,EPG_MinTimeOut(a5)


	*-- Unter Bercksichtigung des TimeMode die max PlayTime festlegen --*
	*----------- damit nicht bei BreakSongNow der Player hngt ----------*
		move.l	EPG_TimeOut(a5),d3
		tst.b 	OnTimeMode(a5)
		beq.s	.MerkeThisTime
		move.l	#EP_Flags,d0
		jsr	A5FindTag(a5)
		beq.s	.MerkeThisTime
		move.l	a6,d0
		btst	#EPF_SongEnd,d0		;Player hat kein Songende
		beq.s	.MerkeThisTime		;Zeit gelten lassen
		moveq	#0,d3
.MerkeThisTime:	move.l	d3,RealTimeOut(a5)

*	move.l	EPG_CurrentTime
*		lea	SecondsZahler(a5),a0
*		lea	MicrosZahler(a5),a1
*		move.l	DTG_IntuitionBase(a5),a6
*		jsr	_LVOCurrentTime(a6)
*		sub.l	d3,SecondsZahler(a5)

		movem.l	(a7)+,d1-a6
		moveq	#0,d0
		rts






	*---------------- Toggle Filter ---------------*
ToggleFilter:	LA0	LNr_FT11
		tst.b	DracoOn(a5)
		bne.s	.FilterEnd
		tst.l	EPG_ActiveAmplifier(a5)
		bne.s	.Doch
		tst.b	AudioEnabled(a5)
		beq.s	.FilterEnd
.Doch:		LA1	LNr_Filter
		move.l	a1,ScrollArgs(a5)
		btst.b	#1,$bfe001
		beq.s	.Filteroff
		LA0	LNr_On_Extern		;Filter On=hell=1
		bclr.b	#1,$bfe001
		bra.s	.FilterEnd
.FilterOff:	LA0	LNr_Off_Extern
		bset.b	#1,$bfe001
.FilterEnd:	jmp	A5ScrollNewText(a5)


*------------------ Hilfsprogramm fr Keyfiledecodierung -------------------*
Key_DecKeyFile3:move.l	EPKF_Struct(a4),d4
		move.l	EPKF_CrFileSize(a4),d0
		eor.l	#$a4659fec,EPKF_CrFileSize(a4)
		eor.l	#$fed975da,d4
		move.w	EPKF_AllChkSum(a4),d5

	*---- Jetzt wird Key-File entcodiert in KeyPuffer copiert ----*
		sub.l	#(EPKF_CodeStart+1)-EPKF_Struct,d0
		cmp.l	#KeyPufferSize,d0
		blo.s	.SizeOk
		move.l	#KeyPufferSize,d0
.SizeOk:	lea	KeyPuffer-8(a5),a2
		addq.l	#8,a2
		rts


LoadFast:	jsr	A5FreeLFModule(a5)
;		bra.s	Loadbefore
;                    !! zusammen lassen !!
;	*-------- Zusatzprogramm fr Load Before --------*
LoadBefore:	tst.b	OnLoadBefore(a5)
		bne.w	LadeLFModule
		jmp	A5FreeLFModule(a5)

	*--------------- Dirjump ---------------*
DirJump:	move.l	a0,-(a7)
		clr.l	DirJumpPtr(a5)
		tst.b	OnDirJump(a5)
		beq.s	.Zurueck

		*--- Randomplay einschalten ---*
		move.b	ProgrammMode(a5),d0
		movem.l	d0-a6,-(a7)
		move.w	#EPNr_ProgramMode,d0
		moveq	#EPNrP_RandomModule,d2
		jsr	A5JumpTo(a5)
		movem.l	(a7)+,d0-a6
		move.b	d0,OldDirJumpProgramMode(a5)


		lea	DirPuffer(a5),a0
		jsr	A5BerechStringSize(a5)
		lea	(a0,d0.w),a0
		move.l	a0,DirJumpPtr(a5)
		move.l	(a7)+,a0
		moveq	#0,d0
		rts

		*-- ProgramMode zuruecksetzen --*
.Zurueck:	clr.l	DirJumpPtr(a5)
		tst.b	OldDirJumpProgramMode(a5)
		blt.s	.NichtGesetzt
		movem.l	d0-a6,-(a7)
		move.w	#EPNr_ProgramMode,d0
		move.b	OldDirJumpProgramMode(a5),d2
		jsr	A5JumpTo(a5)
		movem.l	(a7)+,d0-a6
.NichtGesetzt:	move.l	(a7)+,a0
		move.b	#-1,OldDirJumpProgramMode(a5)
		moveq	#0,d0
		rts

	*--------------- Dirjump ---------------*
SetDirJumpPtr:	move.l	a0,-(a7)
		clr.l	DirJumpPtr(a5)
		tst.b	OnDirJump(a5)
		beq.s	.Return

		lea	DirPuffer(a5),a0
		jsr	A5BerechStringSize(a5)
		lea	(a0,d0.w),a0
		move.l	a0,DirJumpPtr(a5)
.Return:	move.l	(a7)+,a0
		moveq	#0,d0
		rts


	*---------- Zusatzprogramm fr HideAll ----------*
HideAll:	jsr	A5FreeDirPuffer(a5)
		jsr	A5LoadDirIn(a5)
		moveq	#0,d0
		rts

LockModule:	tst.l	PlayerAdr(a5)
		beq.s	.Error
		LA0	LNr_ModuleLocked
		tst.b	OnLockModule(a5)
		bne.s	.Ok
		LA0	LNr_ModuleUnlocked
.Ok:		jmp	A5ScrollNewText(a5)

.Error:		clr.b	OnLockModule(a5)
		moveq	#EPR_FunctionNotEnabled,d0
		rts

NoGui:		tst.b	OnNoGui(a5)
		bne.s	.EjectGui

		jsr	A5LoadDefaultGui(a5)

		LA0	LNr_EPVersion
		move.l	A0,ScrollArgs(a5)
		LA0	LNr_Welcome
		jmp	A5ScrollNewText(a5)

.EjectGui:	move.l	UMG_UPrgSAdr(a5),d0
		beq.s	.Ok
		move.l	d0,a0
		move.l	UPrgS_EngineNr(a0),d0
		moveq	#1,d1
		move.l	#USClass_Exit,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		jsr	A5SendeOneMessage(a5)
		bne.w	.Ok
		move.l	d7,d0
		jsr	A5WriteEnginePrefsToUPrg(a5)
		jsr	A5DeleteEngine(a5)
		lea	ScrollPuffer(a5),a0
		jmp	A5ScrollNewText(a5)

.Ok:		LA0	LNr_OperationSuccesful
		jmp	A5ScrollNewText(a5)

	*------- Zusatzprogramm fr Extract first Module -------*
ExtractFirstModule:
		tst.b	OnExtractFirstModule(a5)
		beq.s	.Return

		tst.b	OnLHAInMenu(a5)		:LHA-Dir im PD-Menu
		beq.s	.Return
		lea	DirPuffer(a5),a0
		jsr	A5ParentDir(a5)
		jsr	A5LoadDirIn(a5)
.Return:	moveq	#0,d0
		rts

	*-------- Zusatzprogramm fr SwapFilter ---------*
SetFilter:	tst.b	DracoOn(a5)
		bne.s	.Off
		bset.b	#1,$bfe001
		tst.b	DTG_Led(a5)
		beq.s	.Off
		bclr.b	#1,$bfe001
.Off:		moveq	#0,d0
		rts

	*----------- Zusatzprogramm fr LoadDir ---------*
LoadDir:	tst.b	OnLoadDir(a5)
		bne.s	.LoadDirIn
		jsr	A5FreeDirPuffer(a5)
		jsr	A5GuiChanged(a5)			;Eject Dir-Menu
		moveq	#0,d0
		rts
.LoadDirIn:	jsr	A5LoadDirIn(a5)
		moveq	#0,d0
		rts

EjectPlayers:	tst.b	OnEjectPlayer(a5)
		beq.s	.NoEject
		jsr	A5DeleteAllOtherPlayers(a5)
.NoEject:	moveq	#0,d0
		rts

	*-------- XFD-Decrunch/LoadSeg ---------*
SetXFDLibrary:	move.b	OnXFDLoadSeg(a5),d0
		add.b	OnXFDDecrunch(a5),d0
		bne.s	.NoClose
		lea	EPG_XFDMasterBase(a5),a0
		jsr	A5CloseLib(a5)
.NoClose:	moveq	#0,d0
		rts
		


*-------- Vergleiche zwei Speicherbereich (a0/a0) mit Size-1 (d0) ---------*
Vergleich:	cmpm.b	(a0)+,(a1)+
		bne.s	.NoGleich
		dbf	d0,Vergleich
		moveq	#0,d0
		rts

.NoGleich:	moveq	#1,d0
		rts


*---------- On/Off Text von Adr a1 nach Adr a0 copieren 6 Zeichen ----------*
CopyText:	moveq	#5,d1
CopyText2:	cmp.l	#0,a0
		beq.s	.NoCopy
		cmp.l	#0,a1
		beq.s	.NoCopy
		tst.l	d1
		blt.s	.NoCopy
.Copy:		move.b	(a1)+,(a0)+
		dbf	d1,.Copy
.NoCopy:	rts

LCopyText:	addq.l	#1,d0			;Copiere String bis 0 oder $20
		cmp.b	#32,d0
		beq.w	STR_Return
		move.b	(a0)+,d0
		beq.w	STR_Return
		move.b	d0,(a1)+
		bra.s	LCopyText

*----------------------------------------------------------------------------*
StringCopy:	moveq	#Namenlange,d1
StringCopy2:	moveq	#0,d0
		cmp.l	a1,d0
		beq.s	.Return
		cmp.l	a0,d0
		beq.s	.Return
		tst.w	d1
		blt.s	.Return

.CopyIt:	clr.b	(a1)
		move.b	(a0)+,d0		;Copiere String bis 0 d1=Anz
		beq.b	.Return
		move.b	d0,(a1)+
		dbf	d1,.CopyIt
		clr.b	(a1)
.Return		moveq	#0,d0
STR_Return:	rts

CopySendText:	moveq	#0,d0
		cmp.l	a1,d0
		beq.s	.Return
		cmp.l	a0,d0
		beq.s	.Return

.CopyIt:	clr.b	(a1)
		move.b	(a0)+,d0		;Copiere String bis 0 d1=Anz
		beq.b	.Return
		cmp.b	#"|",d0
		beq.s	.NextB
		move.b	d0,(a1)+
.NextB:		dbf	d1,.CopyIt
		clr.b	(a1)
.Return		moveq	#0,d0
		rts

*----------- Entcodiere einen Text und berechne die Checksumme -----------*
DecodeAndChkSum:movem.l	d1-a6,-(a7)
		tst.l	d0
		beq.s	.NoDecode
		move.l	a0,a3
		subq.l	#1,d0
		move.l	d0,d3
		move.l	d0,d1
.DecodeIt:	move.b	(a0),d0
		jsr	A5DecodeD0(a5)
		move.b	d0,(a0)+
		dbf	d1,.DecodeIt

		moveq	#0,d0
.ChkSumIt:	moveq	#0,d1
		move.b	(a3)+,d1
		add.w	d1,d0
		dbf	d3,.ChkSumIt

.NoDecode:	movem.l	(a7)+,d1-a6
		rts






*###################### Es wird ein Fehlertext gescrollt ###################*
* Input: d0=LocaleNr.
ScrollNew:	jsr	A5GetLocaleString(a5)
		move.l	d0,a0
		jmp	A5ScrollNewText(a5)


*###################### Es wird ein Fehlertext gescrollt ###################*
* Input: d0=Fehlernr.
ScrollNewFehler:movem.l	a0/d0,-(a7)
		lea	XPK_ErrBuf(a5),a0
		cmp.l	#EPR_XPKError,d0
		beq.s	.XPKError
		add.w	#LNr_FT1-1,d0
		jsr	A5GetLocaleString(a5)
		move.l	d0,a0
.XPKError:	bsr.b	ScrollNewText
		movem.l	(a7)+,a0/d0
		rts


ToScrollNewFehler:jmp	A5ScrollNewFehler(a5)



*###################### Scrolle Text, der ab Adr a0 steht ###################*
* Input: a0=Textadresse
ScrollNewTextA2:move.l	a2,a0
ScrollNewText:	*tst.w	ScrollVerbot(a5)
		*bne.s	.Return2
		tst.b	OnScrollInfos(a5)
		beq.w	PrintText

		movem.l	d0-a6,-(a7)
		lea	ScrollArgs(a5),a1
		jsr	A5MakeCorrectText(a5)
		bne.s	.Return
		cmp.l	#Mode_Config,TestBits(a5)
		beq.s	.Return
		*jsr	A5ClearTextWindow(a5)		*aut.
		clr.l	ScrollANewText(a5)
		clr.l	ScrollLastLNrAdr(a5)

	*------------- Userprogramme benachrichten --------------*
		jsr	A5SendeAllScrollMessage(a5)
.Return:	movem.l	(a7)+,d0-a6
.Return2:	moveq	#0,d0
		rts



*################## Printe-InfoText ins gelschte Textwindow ###############*
* Input: a0=Textadresse
PrintTexta2:	move.l	a2,a0
PrintText:	movem.l	d1-a6,-(a7)
		move.l	PufferAdr(pc),a5		;wegen EPP_PrintText
		lea	ScrollArgs(a5),a1
		jsr	A5MakeCorrectText(a5)
		bne.s	.Return

	*------ Nur das printen, was links stehen soll -----*
		jsr	A5BerechStringSize(a5)
		beq.s	.Return
		lea	ScrollPuffer(a5),a1
		lea	(a1,d0.w),a0
.FindStart:	subq.l	#1,a0
		subq.l	#1,d0
		blt.s	.NormalString
		cmp.b	#"|",(a0)
		bne.s	.FindStart
.NormalString:	addq.l	#1,a0
		clr.l	ScrollANewText(a5)
		clr.l	ScrollLastLNrAdr(a5)
		jsr	A5SendeAllPrintMessage(a5)
.Return:	movem.l	(a7)+,d1-a6
		moveq	#0,d0
		rts


*############################ Make Correct Text ############################*
* Diese Routine erstellt einen kompletten Scrolltext und setzt die fehlenden*
* Werte korrekt ein.							    *
* Input: a0 = PrintText							    *
*	 a1 = Argumenttable						    *
*	 *a2 = Ziel							    *
*	 *d0 = Lnge des Ziels						    *
* Output: d0=Fehler oder NULL						    *
*###########################################################################*
MakeCorrectText:movem.l	d1-d7/a1-a6,-(a7)
		lea	.CopyRoutine(pc),a2
		lea	ScrollPuffer(a5),a3
		cmp.l	a3,a0
		beq.s	.Ende
		Execbase
		jsr	_LVORawDoFMT(a6)
.Ende:		movem.l	(a7)+,d1-d7/a1-a6
		lea	ScrollPuffer(a5),a0
		moveq	#0,d0
		rts

.CopyRoutine:	move.l	a0,-(a7)
		move.l	PufferAdr(pc),a0
		lea	ScrollPuffer+ScrollPufferSize-2(a0),a0
		cmp.l	a0,a3
		beq.s	.CR_Ende
		move.b	d0,(a3)+
		clr.b	(a3)
.CR_Ende:	move.l	(a7)+,a0
		rts



*--------------------------------------------------------------------------*
*------------------- Lsche das Anzeigefeld des Windows -------------------*
*--------------------------------------------------------------------------*
ClearTextWindow:movem.l d0-a6,-(a7)
		move.l	#EUT_ClearTextWindow,d0
		moveq	#0,d3			;Error fr d0
		jsr	A5UserCallUp3(a5)
.NoUserGui:	movem.l	(a7)+,d0-a6
		rts



*--------------------------------------------------------------------------*
*--------------- Scroll-Timer (Sendet Scroll Signal -> EPTask) ------------*
*--------------------------------------------------------------------------*
ScrollTimer:	movem.l	d1-a6,-(a7)
		move.l	PufferAdr(pc),a5

	*-------- Zhler fr neuen Scrolltext --------*
		tst.l	ScrollLastLNrAdr(a5)
		bne.s	.NoNewZahler
		tst.l	ScrollANewText(a5)
		beq.s	.NoNewZahler
		addq.l	#1,ScrollANewText(a5)
		cmp.l	#ScrollZahler,ScrollANewText(a5)
		blt.s	.NoNewZahler
		move.l	SongEndBits(a5),d1		*--> Signal schicken
		moveq	#0,d0
		bset	d1,d0
		ExecBase
		move.l	MyTaskAdr(a5),a1
		jsr	_LVOSignal(a6)

.NoNewZahler:	tst.b	PlayOn(a5)
		beq.s	.NoPlay

		lea	SecondsZahler2(a5),a0
		lea	MicrosZahler(a5),a1
		move.l	DTG_IntuitionBase(a5),a6
		jsr	_LVOCurrentTime(a6)

		move.l	SecondsZahler2(a5),d0
		sub.l	SecondsZahler(a5),d0
		move.l	d0,EPG_CurrentTime(a5)

		tst.b	OnLockModule(a5)
		bne.s	.NoPlay

		tst.l	RealTimeOut(a5)			;PlayTime-Modus=on ???
		beq.s	.NoPlay
		tst.b	TimeOverNow(a5)		;bereits aktiviert
		bne.s	.NoPlay			;wegen CurrentTime kein neuer
						;Test

		move.l	RealTimeOut(a5),d1
		beq.s	.NoPlay
		cmp.l	d1,d0
		blo.s	.NoPlay

		tst.b	SongEndVerbot(a5)
		bne.s	.NoPlay

		move.b	#1,TimeOverNow(a5)
		move.l	SongEndBits(a5),d1
		moveq	#0,d0
		bset	d1,d0
		ExecBase
		move.l	MyTaskAdr(a5),a1
		jsr	_LVOSignal(a6)

.NoPlay:
*		tst.w	ScrollKenn(a5)
*		bne.s	.ScrollKennOk
*
*		move.w	ScrollNameZahler(a5),d0
*		addq.w	#1,d0
*		cmp.w	#300,d0
*		blo.s	.MerkZahler
*		move.w	#1,ScrollPrintName(a5)
*		moveq	#0,d0
*.Merkzahler:	move.w	d0,ScrollNameZahler(a5)
*
*	*-------- Testen, ob gescrollt werden mu oder nicht ---------*
*.ScrollKennOk:	*tst.w	ScrollVerbot(a5)
*		*bne.s	KeinScrollen
*		tst.l	WindowOffen(a5)
*		beq.s	KeinScrollen
*		*tst.w	ScrollPrintName(a5)		;Nur Signal senden
*		*bne.s	.ScrollDoch
*		tst.w	Scrollkenn(a5)
*		beq.s	KeinScrollen
*.ScrollDoch:	move.l	ScrollBits(a5),d1
*		moveq	#0,d0
*		bset	d1,d0
*
*		ExecBase
*		move.l	MyTaskAdr(a5),a1
*		jsr	_LVOSignal(a6)

*--------------------------------------------------------------------------*
*---------------- Signale zu den einzelnen Analyzern senden ---------------*
*--------------------------------------------------------------------------*
KeinScrollen:
		cmp.l	#Mode_Quit,Testbits(a5)
		beq.w	.NoUser

		lea	EPG_FirstUserStruct(a5),a4
.NextUser:	move.l	(a4),d0
		beq.w	.NoUser
		move.l	d0,a4

	*--------- Handelt es sich um ein Userprogramm ---------*
		move.l	UPrgS_UFlags(a4),d0
		btst	#UPrgF_Engine,d0
		beq.w	.NextUser

	*-------- Ist Signal fr Userprogramm erwnscht --------*
		move.l	UPrgS_EUSAdr(a4),d0
		beq.s	.NextUser
		move.l	d0,a1
		move.l	EUS_TickFlags(a1),d0
		beq.s	.NextUser
		btst	#EUIF_Always,d0			;Always Signal
		bne.s	.SendSignal

	*----- Soll Signal nur beim Playen gesendet werden  ----*
		btst	#EUIF_OnlyPlay,d0
		beq.s	.NoPlayTest
		tst.b	PlayOn(a5)
		beq.s	.NextUser

	*- Soll Signal nur bei activen Proggy geschickt werden -*
.NoPlayTest:	btst	#EUIF_OnlyActive,d0
		beq.s	.NoActiveTest
		btst	#UPrgF_Active,UPrgS_UFlags+3(a4)
		beq.s	.NextUser

	*------------ Nun mu noch gezhlt werden --------------*
.NoActiveTest:	btst	#EUIF_TickCounter,d0
		beq.s	.SendSignal
		addq.w	#1,EUS_TickCounter(a1)
		move.w	EUS_TickCounter(a1),d1
		cmp.w	EUS_Ticks(a1),d1
		blo.s	.NextUser
		clr.w	EUS_TickCounter(a1)

	*---------- Nun Signal losschicken -----------*
.SendSignal:	cmp.l	UMG_UPrgSAdr(a5),a4
		bne.s	.TaskUser
		*cmp.l	#TagUserID,(a1)
		*beq.s	.TagUser
		*tst.l	(a1)
		*bne.s	.TaskUser

	*-------------- Signale fr TagUser -------------*
.TagUser:	move.l	UMG_InterruptBits(a5),d0
		ExecBase
		move.l	MyTaskAdr(a5),a1
		jsr	_LVOSignal(a6)
		bra.s	.NoTask

	*-------------- Signal fr TaskUser -------------*
.TaskUser:	lea	UPrgS_Message(a4),a0
		tst.w	UM_Enabled(a0)			:Task not Enabled
		bne.s	.NoTask
		move.l	UM_TaskAdr(a0),d0
		beq.s	.NoTask
		move.l	d0,a1
		move.l	UM_Signal(a0),d1
		blt.s	.NoTask
		moveq	#0,d0
		bset	d1,d0
		ExecBase
		jsr	_LVOSignal(a6)
.NoTask:	bra.w	.NextUser


.NoUser		movem.l	(a7)+,d1-a6
		moveq	#0,d0
		rts
			




*------------------------ Verschlsselt Byte in d0 --------------------------*
DecodeD0:	movem.l	d1-a6,-(a7)
		moveq	#0,d1
		move.b	Code(a5),d1
		lea	CodePara1+4(a5),a1
		moveq	#3,d4
.NextCode:	moveq	#0,d3
		move.b	-(a1),d3
		rol.b	#2,d1
		move.b	d1,d2
		and.b	#3,d2
		beq.s	.Add
		subq.b	#1,d2
		beq.s	.Sub
		subq.b	#1,d2
		beq.s	.Ror

	*------ Verschlsselung EOR ------*
		eor.b	d3,d0
		bra.b	.DbfIt
		
	*------ Verschlsselung ROR ------*
.Ror		rol.b	d3,d0
		bra.b	.DbfIt

	*------ Verschlsselung SUB ------*
.Sub		add.b	d3,d0
		bra.b	.DbfIt

	*------ Verschlsselung ADD ------*
.Add		sub.b	d3,d0
.DbfIt:		dbf	d4,.NextCode
		movem.l	(a7)+,d1-a6
		rts


*---------------------------------------------------------------------------*
*---------------------------- String-Vereinbarungen ------------------------*
*---------------------------------------------------------------------------*
PufferAdr:	dc.l	0
*StartModuleLock	dc.l	0
*StartModuleName	dc.l	0

		
*----------------------------------------------------------------------------*
*-------------------- Mem Freigeben d0=Memsize a1=Memadr --------------------*
*----------------------------------------------------------------------------*
FreeLFModule:	movem.l	d1-a6,-(a7)
		tst.l	LFNummer(a5)
		beq.s	.NoDelete
		jsr	A5DeleteAllOtherPlayers(a5)
.NoDelete:	lea	LFPuffer(a5),a4
		bra.s	FreeAModule

FreeOldModule:	movem.l	d1-a6,-(a7)
		move.w	#$8000,EPG_Speed(a5)
		clr.w	EPG_FirstSnd(a5)
		clr.w	EPG_SubSongs(a5)
		clr.l	EPG_PlayerTagList(a5)
		clr.l	EPG_ModNr(a5)
		clr.l	PlayerAdr(a5)
		clr.b	TitlenamePuffer(a5)		;Filename

		move.l	EPG_SomePrefs(a5),d0
		bclr	#EGPRF_PausePlay,d0
		bclr	#EGPRF_NowPlay,d0
		move.l	d0,EPG_SomePrefs(a5)

		lea	MDPuffer(a5),a4
*

*----------------- Gibt den Speicher der internen ModListe frei -------------*
* A4=Puffer (LFPuffer oder MDPuffer)
FreeAModule:	move.l	a4,a3
		move.l	MDNummer-MDPuffer(a4),d4	;Anzahl der Files
		ble.s	.FreeExtra

.NextBlock:	move.l	8(a4),d1
		beq.s	.Next
		move.l	d1,a1
		move.l	12(a4),d0
		beq.s	.Next
		cmp.l	#-1,d0
		beq.s	.Segment

		jsr	A5FreeMem(a5)
		bra.s	.Next

.Segment:	move.l	DTG_Dosbase(a5),a6
		asr.l	#2,d1
		subq.l	#1,d1
		jsr	_LVOUnLoadSeg(a6)
.Next:		clr.l	(a4)+
		clr.l	(a4)+
		clr.l	(a4)+
		clr.l	(a4)+
		subq.l	#1,d4
		bgt.s	.NextBlock

.FreeExtra:	move.l	MDExtraMem(a5),d0
		beq.s	.ClrDatas
		move.l	d0,a1
		move.l	MDExtraMem+4(a5),d0
		beq.s	.ClrDatas
		jsr	A5FreeMem(a5)

	*---------- Variablen lschen -----------*
.ClrDatas:	clr.l	MDNummer-MDPuffer(a3)
		clr.l	(a3)
		clr.l	4(a3)
		clr.l	8(a3)
		clr.l	12(a3)
		clr.l	MDExtraMem(a5)
		clr.l	MDExtraMem+4(a5)
		clr.l	MDFormatname(a5)
		clr.l	MDSamplePtr(a5)
		movem.l	(a7)+,d1-a6
		moveq	#0,d0
		rts

*

*----------------------------------------------------------------------------*
*-------------------------- Allocmem - Unterprogramme -----------------------*
*----------------------------------------------------------------------------*
AllocChip:	moveq	#3,d1
		bra.b	Allocmem2
Allocmem:	moveq	#1,d1
Allocmem2:	bset	#16,d1				;Kennung Mem-Clearen
		ExecBase
		jsr	_LVOAllocMem(a6)
AllocReturn:	tst.l	d0
		rts

FreeMem:	ExecBase
		jmp	_LVOFreeMem(a6)





*******************************************************************************

*-----------------------------------------------------------------------------*
* Die Menus und Gadgets werden erlaubt oder gesperrt.			      *
*-----------------------------------------------------------------------------*
GuiChanged:	movem.l	d0-a6,-(a7)
		tst.w	WindowChanged(a5)
		bne.w	.ChangeAll
		cmp.l	#Mode_Config,TestBits(a5)
		beq.w	.NothingToChange

	*---- Testen, ob was gendert werden mu ----*
		lea	GuiChangeTab(pc),a3
.Simu:		move.w	(a3)+,d0		;Nummer laden
		beq.w	.NothingToChange
		move.w	(a3)+,d2
		tst.w	(a5,d2.w)
		beq.b	.SimuDisabledTest
		btst	#15,d0
		bne.s	.Simu
		bra.b	.ChangeAll
.SimuDisabledTest:
		btst	#15,d0
		beq.b	.Simu


	*----------------------- Alles ndern --------------------*
.ChangeAll:	clr.w	WindowChanged(a5)
		jsr	A5DisableAll(a5)

	*------------------ Menus ndern -------------------*
	*	jsr	A5GetMainWindowHandle(a5)
	*	beq.s	.NoInternMenus
	* Menus immer ndern !!!
		tst.w	HelpChange(a5)
		bne.s	.CH_HelpMenus
		tst.w	MenuInitOk(a5)
		beq.w	.NoInternMenus
.CH_Normal:	lea	GuiChangeTab(pc),a3
.CH_Menus1:	move.w	(a3)+,d0		;Nummer laden
		beq.w	.NoInternMenus
		move.w	(a3)+,d2
		bclr	#15,d0
		jsr	A5GetMenuItemAdr(a5)	;d0=Error oder NULL
		bne.b	.CH_Menus1		;a0=MenuItem
.CH_RetryVoi:	bset	#7,-4(a3)
		bset	#4,13(a0)		;Enablen
		tst.b	OnHelp(a5)
		bne.s	.CH_TestVoices
		tst.w	(a5,d2.w)
		bne.s	.CH_TestVoices
		bclr	#4,13(a0)		;Disablen
		bclr	#7,-4(a3)
.CH_TestVoices:	cmp.b	#EPNr_Voices,-3(a3)
		bne.s	.CH_Menus1
		move.l	(a0),d0
		beq.s	.CH_Menus1
		move.l	d0,a0
		cmp.w	#EPNr_Voices,EPMI_EPNr(a0)
		beq.s	.Ch_RetryVoi
		move.l	(a0),d0			*Barlabel --> ResetVoices
		beq.w	.CH_Menus1
		move.l	d0,a0
		bra.s	.CH_RetryVoi

	*-------- Die Menus beim Helpmode umbauen ----------*
.CH_HelpMenus:	tst.b	KeyOn(a5)
;		bne.s	.CH_Normal
	bra.s	.CH_Normal

* Da auf das Sperren der Funktionen verzichtet wurde, sind die folgenden
* 9 Zeilen disabled
* NEWR
;		moveq	#0,d6
;		lea	Kommandotabelle-EPRT_SizeOf,a1
;.CH_HelpNext:	lea	EPRT_SizeOf(a1),a1
;		addq.l	#1,d6
;		cmp.w	#EPNr_LastInternal,d6
;		beq.s	.NoInternMenus
;
;		move.l	d6,d0
;		jsr	A5GetMenuItemAdr(a5)
;
;		bne.s	.CH_HelpNext
;		cmp.w	#EPNr_CrunchMode,d6
;		beq.s	.CH_Crunch
;		move.b	EPRT_Flags(a1),d0
;		btst	#EPRTF_Key,d0
;		beq.s	.CH_HelpNext
;		bclr.b	#4,EPMI_Flags+1(a0)
;		tst.b	OnHelp(a5)
;		beq.s	.CH_HelpNext
;		bset.b	#4,EPMI_Flags+1(a0)
;		bra.s	.CH_HelpNext
;
;.CH_Crunch:	moveq	#4,d1
;.CH_CrSchleif:	bclr.b	#4,EPMI_Flags+1(a0)
;		tst.b	OnHelp(a5)
;		beq.s	.CH_CrDBF
;		bset.b	#4,EPMI_Flags+1(a0)
;.CH_CrDBF:	move.l	(a0),d0
;		beq.s	.CH_HelpNext
;		move.l	d0,a0
;		dbf	d1,.CH_CrSchleif
;		bra.s	.CH_HelpNext

	*------------- Nun die Guis ansteuern -------------*
.NoInternMenus:	lea	GuiChangeTab(pc),a3
		move.l	#EUT_ChangeGui,d0
		jsr	A5UserFindTag(a5)
		beq.s	.AllesChanged
		move.l	d2,a6
.CH_Guis:	move.w	(a3)+,d0		;Nummer laden
		beq.b	.AllesChanged
		move.w	(a3)+,d2
		bclr	#15,d0

		tst.b	OnHelp(a5)
		bne.s	.CH_AnBleiben
		tst.w	(a5,d2.w)
		beq.b	.CH_GuisClr

	*	bset	#7,-4(a3)
.CH_AnBleiben:	moveq	#0,d1			;Enablen
		movem.l	a3/a5/a6,-(a7)
		jsr	(a6)
		movem.l	(a7)+,a3/a5/a6
		bra.b	.Ch_Guis

.CH_GuisClr:
	*	bclr	#7,-4(a3)
		moveq	#1,d1			;Disablen
		movem.l	a3/a5/a6,-(a7)
		jsr	(a6)
		movem.l	(a7)+,a3/a5/a6
		bra.b	.Ch_Guis


.AllesChanged:	jsr	A5EnableAll(a5)

.NothingToChange:movem.l (a7)+,d0-a6
		rts



*-----------------------------------------------------------------------------*
*Diese Routinen werden erlaubt, wenn die entsprechenden Bedingungen geg. sind *
*Bit 15 von EPNr --> Letzte Einstellung
*-----------------------------------------------------------------------------*
GuiChangeTab:	dc.w	EPNr_PrevPattern,PrevPatternOn
		dc.w	EPNr_Play,ModuleLoaded
		dc.w	EPNr_PlayFaster,PlayFasterOn
		dc.w	EPNr_SaveModule,SaveOn
		dc.w	EPNr_AboutModule,ModuleLoaded	;Offset.w-Tabelle
		dc.w	EPNr_ReplaySong,ModuleLoaded
		dc.w	EPNr_StopPlay,ModuleLoaded
		dc.w	EPNr_EjectModule,ModuleLoaded
;NEWR		dc.w	EPNr_CrunchMode,KeyOn
	*	dc.w	EPNr_PPCrunched,PPDa
	*	dc.w	EPNr_LHCrunched,LHDa
	*	dc.w	EPNr_XPKCrunched,XPKDa
	*	dc.w	EPNr_CrMCrunched,CrMDa
		dc.w	EPNr_PrevModule,OnModulesIn
		dc.w	EPNr_PrevSong,NextSongOn
		dc.w	EPNr_NextPattern,NextPatternOn
		dc.w	EPNr_NextSong,NextSongOn
		dc.w	EPNr_NextModule,OnModulesIn
		dc.w	EPNr_Voices,VoicesOn
		dc.w	EPNr_Volume,VolumeOn
		dc.w	EPNr_VolumeDefault,VolumeOn
		dc.w	EPNr_VolumeLower,VolumeOn
		dc.w	EPNr_VolumeHigher,VolumeOn
		dc.w	EPNr_Balance,BalanceOn
		dc.w	EPNr_BalanceDefault,BalanceOn
		dc.w	EPNr_BalanceLeft,BalanceOn
		dc.w	EPNr_BalanceRight,BalanceOn
		dc.w	EPNr_Speed,SpeedOn
		dc.w	EPNr_SpeedFaster,SpeedOn
		dc.w	EPNr_SpeedSlower,SpeedOn
		dc.w	EPNr_SpeedDefault,SpeedDOn
		dc.w	0







*------------------ Verschlsselung 1 von Struct 3 aufheben ----------------*
Key_Verl13:	lea	EPKF_V3Decodek(a4),a0
		moveq	#EPKF_V3ChkSum-EPKF_V3DecodeK-1,d1
		move.l	a0,a2
.DecodeStr3:	move.b	(a0),d0
		jsr	A5DecodeD02(a5)
		move.b	d0,(a0)+
		dbf	d1,.DecodeStr3

	*---------- Checksumme der dritten Structure ----------*
		moveq	#EPKF_V3ChkSum-EPKF_V3DecodeK-1,d2
		moveq	#0,d0
.ChkSumStr3:	moveq	#0,d1
		move.b	(a2)+,d1
		add.w	d1,d0
		dbf	d2,.ChkSumStr3
		rts


*----------------------------- About Module ----------------------------*
AboutModule:	lea	TextPuffer(a5),a1
		tst.l	PlayerAdr(a5)
		beq.w	About

	*------ Loaded Name printen -----*
.AboutModule2:	LA0	LNr_NowLoaded
		jsr	A5StringCopy(a5)
		subq.l	#4,a1			*  wegen    |%s
		lea	TitleNamePuffer(a5),a0

	*------ Print Songname ------*
		move.l	GetInfoAdr(a5),d0
		beq.s	.NoSongname
		move.l	d0,a6
		move.l	#MI_SongName,d0
		jsr	A5Findtag2(a5)
		beq.s	.NoSongName
		tst.b	(a6)
		beq.s	.NoSongName
		move.l	a6,a0
.NoSongName:	moveq	#1,d2
		jsr	A5CopyToInfoB2(a5)

	*------- Authoren printen ------*
		move.l	GetInfoAdr(a5),d0
		beq.s	.NoAuthor
		move.l	d0,a6
		move.l	#MI_AuthorName,d0
		jsr	A5FindTag2(a5)
		beq.s	.NoAuthor
		tst.b	(a6)
		beq.s	.NoAuthor
		move.b	#" ",(a1)+
		move.b	#"b",(a1)+
		move.b	#"y",(a1)+
		move.b	#" ",(a1)+
		moveq	#1,d2
		jsr	A5CopyToInfoB(a5)
.NoAuthor:	move.b	#" ",(a1)+
		move.b	#"(",(a1)+
		subq.l	#2,a1

		move.l	EPG_SoundSystemname(a5),a6
		tst.b	(a6)
		beq.s	.PrintSize

*		move.l	MDFormatname(a5),d0		;fr Converter
*		move.l	d0,a6
*		bne.s	.NameFound
*
*		move.l	GetInfoAdr(a5),d0
*		beq.w	.NoMiStructSS
*		move.l	d0,a6
*		move.l	#MI_SoundSystem,d0
*		jsr	A5FindTag2(a5)
*		bne.s	.NameFound
*
*.NoMIStructSS:	move.l	#DTP_PlayerName,d0
*		jsr	A5FindTag(a5)
*		bne.s	.NameFound			PrintSize
*		moveq	#-1,d1
*		move.l	MDPuffer+4(a5),d0
*		cmp.l	d1,d0
*		bne.s	.PrintSize
*		lea	CU_Name,a6
.NameFound:	addq.l	#2,a1
		move.l	a6,a0
		jsr	A5StringCopy(a5)
		move.b	#")",(a1)+

	*------------ Printe GesamtSize -----------*
	*---- Lnge in Structure angegeben ???? ----*
.PrintSize:	move.l	EPG_ModuleSize(a5),d0
		cmp.l	#-1,d0
		beq.w	.PrintDuration
		move.b	#",",(a1)+
		move.l	d0,d3
		jsr	A5PrintBytes(a5)

*----- Check, ob Unterschied zwischen geladenem Module und calc- Size ------*
		move.l	GetInfoAdr(a5),d0
		beq.w	.PrintDuration
		move.l	d0,a6
		move.l	#MI_CalcSize,d0
		jsr	A5FindTag2(a5)
		beq.w	.PrintDuration
		move.l	a6,d0
		move.l	a6,d2
		move.l	a6,d4
		sub.l	d0,d3
		beq.w	.PrintEffi
		ble.s	.Kleiner		;Module kleiner als berechnet

	*------ Print "Hey your module is ...." -----*
		LA0	LNr_ModuleHey
		move.w	#TextPufferSize-200,d1
		jsr	A5StringCopy2(a5)
		move.l	d3,d0
		jsr	A5PrintBytes(a5)
		LA0	LNr_ModuleLonger
		move.w	#TextPufferSize-200,d1
		jsr	A5StringCopy2(a5)
		bra.b	.CalcSizeEnd

	*------ Module krzer -----*
.Kleiner:	LA0	LNr_ModuleWarning
		move.w	#TextPufferSize-200,d1
		jsr	A5StringCopy2(a5)
		not.l	d3
		move.l	d3,d0
		jsr	A5PrintBytes(a5)
		LA0	LNr_ModuleShorter
		move.w	#TextPufferSize-200,d1
		jsr	A5StringCopy2(a5)

	*----- Print EndText -----*
.CalcSizeEnd:	LA0	LNr_ModuleAs
		move.w	#TextPufferSize-200,d1
		jsr	A5StringCopy2(a5)
		move.l	d2,d0
		jsr	A5PrintBytes(a5)
		move.b	#")",(a1)+

	*------- Print Pack-Effiziens ------*
.PrintEffi:	move.l	GetInfoAdr(a5),d0
		beq.w	.PrintDuration
		move.l	d0,a6
		move.l	#MI_Unpacked,d0
		jsr	A5FindTag2(a5)
		beq.w	.PrintDuration
		move.l	a6,d3
		LA0	LNr_ThisIsA
		jsr	A5StringCopy(a5)
		move.l	GetInfoAdr(a5),a6
		move.l	#MI_UnPackedSystem,d0
		jsr	A5FindTag2(a5)			;gefunden ?
		move.l	a6,d0
		beq.s	.Module.MSG
		cmp.w	#MIUS_SizeOf+1,d0		;System Grer als max?
		bhi.s	.Stringangegeben

		move.l	d0,d1
		move.w	#LNr_OldSoundTracker+1,d0
		sub.l	d1,d0
		jsr	A5GetLocaleString(a5)

.Stringangegeben:
		jsr	A5StringCopy(a5)
.Module.MSG:	LA0	LNr_Module
		jsr	A5StringCopy(a5)

		LA0	LNr_OriginalSize
		jsr	A5StringCopy(a5)
		move.l	d3,d0				;Unpacked size nach d0
		jsr	A5PrintBytes(a5)
		move.b	#",",(a1)+

		LA0	LNr_PackedSize
		jsr	A5StringCopy(a5)
		move.l	d4,d0				;Calcsize nach d0
		jsr	A5PrintBytes(a5)
		move.b	#",",(a1)+

		LA0	LNr_BytesWon
		jsr	A5StringCopy(a5)
		move.l	d3,d0
		sub.l	d4,d0
		move.l	d0,d4
		jsr	A5PrintBytes(a5)

;		move.b	#" ",(a1)+
;		move.b	#"(",(a1)+
;		mulu	#100,d4
;		divu	d3,d4
;		moveq	#0,d0
;		move.w	d4,d0
;		jsr	A5Hexdez2(a5)
;		move.b	#"%",(a1)+
;		move.b	#")",(a1)+
		move.b	#".",(a1)+
		move.b	#" ",(a1)+
		moveq	#2,d7
		bra.b	.PrintDuration2

	*------ Print Duration ------*
.PrintDuration:	moveq	#0,d7
.PrintDuration2:move.l	EPG_Duration(a5),d2
		beq.s	.PrintSubSongs
		LA0	LNr_Duration
		add.l	d7,a0
		jsr	A5StringCopy(a5)
		move.l	d2,d0
		cmp.l	#60,d2
		blo.s	.OnlySeconds
		divu	#60,d0
		and.l	#$ffff,d0
		jsr	A5HexDez2(a5)
		mulu	#60,d0
		sub.w	d0,d2
		LA0	LNr_Minuts
		jsr	A5StringCopy(a5)
		move.l	d2,d0
.OnlySeconds:	jsr	A5HexDez2(a5)
		LA0	LNr_Seconds
		jsr	A5StringCopy(a5)
		moveq	#0,d7

	*--------- Print SubSongs ----------*
.PrintSubSongs:	tst.w	EPG_SubSongs(a5)
		beq.s	.PrintLength
		LA0	LNr_SubSongs
		add.l	d7,a0
		jsr	A5StringCopy(a5)
		moveq	#0,d0
		add.w	EPG_SubSongs(a5),d0
		jsr	A5HexDez2(a5)
		moveq	#0,d7


	*------ Print Length ------*
.PrintLength:	move.l	GetInfoAdr(a5),d0
		beq.w	.PrintSteps
		move.l	d0,a6
		move.l	#MI_Length,d0
		jsr	A5FindTag2(a5)
		beq.s	.PrintSteps
		LA0	LNr_Length
		add.l	d7,a0
		jsr	A5StringCopy(a5)
		move.l	a6,d0
		jsr	A5HexDez2(a5)
		moveq	#0,d7

	*------- Print Steps ------*
.PrintSteps:	move.l	GetInfoAdr(a5),d0
		beq.w	.PrintPattern
		move.l	d0,a6
		move.l	#MI_Steps,d0
		jsr	A5FindTag2(a5)
		beq.s	.PrintPattern
		LA0	LNr_Steps
		add.l	d7,a0
		jsr	A5StringCopy(a5)
		move.l	a6,d0
		jsr	A5HexDez2(a5)
		moveq	#0,d7

	*------ Print Pattern ------*
.PrintPattern:	move.l	GetInfoAdr(a5),d0
		beq.s	.PrintVoices
		move.l	d0,a6
		move.l	#MI_Pattern,d0
		jsr	A5FindTag2(a5)
		beq.s	.PrintVoices
		LA0	LNr_Pattern
		add.l	d7,a0
		jsr	A5StringCopy(a5)
		move.l	a6,d0
		jsr	A5HexDez2(a5)
		moveq	#0,d7

	*------ Print Voices ------*
.PrintVoices:	move.l	GetInfoAdr(a5),d0
		beq.s	.PrintSamples
		move.l	d0,a6
		move.l	#MI_MaxVoices,d0		;nicht gefunden
		jsr	A5FindTag2(a5)			;--> max 4 Voices
		beq.s	.PrintSamples
		moveq	#4,d0
		cmp.l	d0,a6
		beq.s	.PrintSamples

		move.l	GetInfoAdr(a5),a6
		move.l	#MI_Voices,d0			;nicht gefunden
		jsr	A5FindTag2(a5)			;--> max 4 Voices
		beq.s	.PrintSamples
		LA0	LNr_Voices
		add.l	d7,a0
		jsr	A5StringCopy(a5)
		move.l	a6,d0
		jsr	A5HexDez2(a5)
		moveq	#0,d7

	*-------- Print Samples ------*
.PrintSamples:	move.l	GetInfoAdr(a5),d0
		beq.s	.PrintSynth
		move.l	d0,a6
		move.l	#MI_Samples,d0
		jsr	A5FindTag2(a5)
		beq.s	.PrintSynth
		LA0	LNr_Samples
		add.l	d7,a0
		jsr	A5StringCopy(a5)
		move.l	a6,d0
		jsr	A5HexDez2(a5)
		moveq	#0,d7

	*------ Print Synth-Samples ------*
.PrintSynth:	move.l	GetInfoAdr(a5),d0
		beq.s	.PrintSongSize
		move.l	d0,a6
		move.l	#MI_SynthSamples,d0
		jsr	A5FindTag2(a5)
		beq.s	.PrintSongSize
		move.l	a6,d0
		LA0	LNr_SynthSamples
		add.l	d7,a0
		jsr	A5StringCopy(a5)
		move.l	a6,d0
		jsr	A5HexDez2(a5)
		moveq	#0,d7

	*------ Print Song-Size ------*
.PrintSongSize:	move.l	GetInfoAdr(a5),d0
		beq.s	.PrintSampleSize
		move.l	d0,a6
		move.l	#MI_SongSize,d0
		jsr	A5FindTag2(a5)
		beq.s	.PrintSampleSize
		LA0	LNr_SongSize
		add.l	d7,a0
		jsr	A5StringCopy(a5)
		move.l	a6,d0
		jsr	A5HexDez2(a5)
		LA0	LNr_Bytes
		jsr	A5StringCopy(a5)
		moveq	#0,d7

	*------- Print Sample-Size -------*
.PrintSampleSize:move.l	GetInfoAdr(a5),d0
		beq.s	.PrintSpecial
		move.l	d0,a6
		move.l	#MI_SamplesSize,d0
		jsr	A5FindTag2(a5)
		beq.w	.PrintSpecial
		LA0	LNr_SamplesSize
		add.l	d7,a0
		jsr	A5StringCopy(a5)
		move.l	a6,d0
		jsr	A5HexDez2(a5)
		LA0	LNr_Bytes
		jsr	A5StringCopy(a5)
		moveq	#0,d7


	*------- Print Special-Text ------*
.PrintSpecial:	moveq	#0,d7
		move.l	GetInfoAdr(a5),d0
		beq.s	.PrintAdapted
		move.l	d0,a6
		move.l	#MI_SpecialInfo,d0
		jsr	A5FindTag2(a5)
		beq.w	.PrintAdapted
		move.b	#".",(a1)+
		move.b	#" ",(a1)+
		moveq	#1,d2
		jsr	A5CopyToInfoB(a5)
		moveq	#1,d7

	*------ Printe Creator ------*
.PrintAdapted:	move.l	#DTP_Creator,d0
		jsr	A5FindTag(a5)
		beq.s	.Ende
		LA0	LNr_Creator
		add.l	d7,a0
		jsr	A5StringCopy(a5)
		move.l	a1,a2
		moveq	#0,d2
		jsr	A5CopyToInfoB(a5)
		clr.b	(a1)
.Adapted2:	tst.b	(a2)+
		beq.s	.Ende
		cmp.b	#10,(a2)
		bne.s	.Adapted2
		move.b	#32,(a2)
		bra.s	.Adapted2

	*------ Ende of About Module ------*
.Ende		move.b	#".",(a1)+
		move.b	#"|",(a1)+		;hier bis links scrollen
		*move.l	a1,a0
		*move.b	#" ",(a1)+
		*moveq	#36,d1
		*jsr	A5StringCopy2(a5)
		clr.b	(a1)
		
		lea	TextPuffer(a5),a0
		jmp	A5ScrollNewText(a5)

	*---- Copiert String von Adr a6 nach a1 mit max Lnge ----*
CopyToInfoB:	move.l	a6,a0
CopyToInfoB2:	lea	TextPufferEnd(a5),a3
		sub.l	a1,a3
		move.l	a3,d1
		subq.l	#2,d1		

	tst.l	d2
	beq.s	.NoTest
		move.l	a0,-(a7)
		moveq	#0,d2
.NextB:		move.b	(a0)+,d0
		cmp.b	#31,d0
		blo.s	.Klein
		addq.l	#1,d2
		bra.b	.NextB
.Klein:		tst.l	d2
		beq.s	.NoSub
		subq.l	#1,d2
.NoSub:		cmp.l	d1,d2			;Testen ob d0 kleiner als d1
		bhi.s	.Nod2			;nein
		move.l	d2,d1
.Nod2:		move.l	(a7)+,a0
.NoTest:	jmp	A5Stringcopy2(a5)

	*----- Printed Anzahl der Bytes ------*
PrintBytes:	move.b	#" ",(a1)+
		jsr	A5HexDez2(a5)
		LA0	LNr_Bytes
		jmp	A5StringCopy(a5)



*------------------ Workbench-Title-Leisten-Text aufbauen --------------------*
TitleAufbau:	movem.l	d1-a6,-(a7)
		LA0	LNr_EPTitle
		lea	WBTitlePuffer(a5),a1
		jsr	A5StringCopy(a5)

		tst.l	PlayerAdr(a5)
		bne.w	.PrintSongName
		LA0	LNr_FT11
		moveq	#127,d1
		jsr	A5StringCopy2(a5)
		bra.w	.SetTitle2

	*------ Song bzw. ModuleNamen printen ------*
.PrintSongName	lea	TitleNamePuffer(a5),a0
		tst.b	OnUseSongname(a5)
		beq.s	.NoUseSong

		move.l	GetInfoAdr(a5),d0
		beq.s	.NoUseSong
		move.l	d0,a6
		move.l	#MI_Songname,d0
		jsr	A5FindTag2(a5)
		beq.s	.NoUseSong
		tst.b	(a6)
		beq.s	.NoUseSong
		move.l	a6,a0
.NoUseSong:	moveq	#Namenlange-2,d1
		jsr	A5StringCopy2(a5)

		tst.l	EPG_Author(a5)
		beq.s	.NoAuthor
		LA0	LNr_by
		jsr	A5StringCopy(a5)
		move.l	EPG_Author(a5),a0
		jsr	A5StringCopy(a5)


	*------ Soundsystem printen ------*
.NoAuthor:	move.b	#" ",(a1)+
		move.b	#"(",(a1)+
		subq.l	#2,a1

		move.l	EPG_SoundSystemName(a5),a6
		tst.b	(a6)
		beq.s	.PrintLenght
*		move.l	MDFormatname(a5),d0		;fr Converter
*		move.l	d0,a6
*		bne.s	.PrintSys
*
*		move.l	GetInfoAdr(a5),d0
*		beq.w	.NoMiStruct
*		move.l	d0,a6
*		move.l	#MI_SoundSystem,d0
*		jsr	A5FindTag2(a5)
*		bne.s	.PrintSys
*
*.NoMiStruct:	move.l	#DTP_PlayerName,d0
*		jsr	A5FindTag(a5)
*		bne.s	.PrintSys
*		moveq	#-1,d0
*		cmp.l	MDPuffer+4(a5),d0
*		bne.s	.PrintLenght
*		lea	CU_Name,a6
.PrintSys:	addq.l	#2,a1
		move.l	a6,a0
		moveq	#100,d1
		jsr	A5LCopyText(a5)
		move.b	#")",(a1)+

	*------ Printe LoadSize, die durch das Module benutzt wird -----*
	*------------ Testen ob in Loaded Size angegeben wird ----------*
.PrintLenght:	move.l	EPG_ModuleSize(a5),d0
		cmp.l	#-1,d0
		beq.s	.SetTitle
.GetSize:	move.b	#" ",(a1)+
		jsr	A5Hexdez2(a5)

	*------- Print Bytes -------*
		LA0	LNr_Bytes
		moveq	#9,d1
		jsr	A5StringCopy2(a5)

*-------------------------- Titlezeile setzen -----------------------*
.SetTitle	move.b	#".",(a1)+
.SetTitle2:	clr.b	(a1)
		move.l	DTG_IntuitionBase(a5),a6


		jsr	A5GetMainWindowHandle(a5)
		beq.s	ret_ret_Return
		move.l	d0,a0


		LA1	LNr_WindowTitleRegistered
KeyBne4
		tst.b	KeyOn(a5)
		bne.w	.Key			;.w lassen !
		LA1	LNr_WindowTitleGeneric
.Key:		lea	WBTitlePuffer(a5),a2
		jsr	_LVOSetWindowTitles(a6)
ret_ret_Return
		movem.l	(a7)+,d1-a6
		moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
* Fr Prefix und Titleaufbau
*-----------------------------------------------------------------------------*
* d6=Nummer
* d2=Zustand
UpdateSongname:	movem.l	d1-a6,-(a7)
		jsr	A5TitleAufbau(a5)
		jsr	A5MakeEPGSongname(a5)

		cmp.l	#Mode_Config,TestBits(a5)
		beq.w	.NoChange

		move.l	#EUT_ChangePrefs,d7
		move.l	d6,d0			;EPNr_
		moveq	#0,d1
		move.l	d2,d1
		moveq	#0,d2			;aus
		jsr	A5UserCallUp4(a5)

.NoChange:	movem.l	(a7)+,d1-a6
		moveq	#0,d0
		rts


*-----------------------------------------------------------------------------*
MakeEPGSongName:movem.l	d0-a6,-(a7)
		lea	EPG_SongnamePuffer(a5),a1
		move.l	a1,EPG_Songname(a5)
		clr.b	(a1)

		lea	TitleNamePuffer(a5),a0		;Filename
		tst.b	OnUseSongname(a5)
		beq.s	.NoUseSong

		move.l	GetInfoAdr(a5),d0
		beq.s	.NoUseSong
		move.l	d0,a6
		move.l	#MI_Songname,d0
		jsr	A5FindTag2(a5)
		beq.s	.NoUseSong
		tst.b	(a6)
		beq.s	.NoUseSong
		move.l	a6,a0
.NoUseSong:	moveq	#Namenlange,d1

	;jsr	A5BerechStringSize(a5)
		;move.l	d0,d1
		;subq.l	#1,d1
		;blt.s	.Return

		;tst.b	OnUsePrefix(a5)
		;beq.s	.OhnePrefix
		;USW
.OhnePrefix:
		jsr	A5StringCopy2(a5)


.Return:	movem.l	(a7)+,d0-a6
		rts



	*----------------------------------------------------------------*
	*--------- Initialisiere ein Soundsystem mit einem Modul --------*
	*----------------------------------------------------------------*
InitPlayer:	moveq	#1,d0
		move.w	d0,SpeedOn(a5)		;Speed verstellbar
		move.w	d0,SpeedDOn(a5)		;SpeedDefault mglich
		move.w	d0,SaveOn(a5)
;	move.w	d0,WhileInit(a5)
		clr.w	VolumeOn(a5)
		clr.w	BalanceOn(a5)
		clr.w	VoicesOn(a5)
;		clr.w	EPAudioAlloc(a5)
		clr.w	PlayerFlagsDa(a5)
		clr.l	PlayerFlags(a5)
		clr.l	EPG_CurrentTime(a5)
		clr.l	EPG_Duration(a5)
		clr.l	EPG_ModuleSize(a5)
		clr.l	DT_AmplifierstructSize(a5)
		clr.l	DT_AmplifierStruct(a5)
		clr.l	DT_NoteStruct(a5)
		clr.l	EPG_UPS_Structure(a5)

		clr.b	ComposerPuffer(a5)
		clr.l	EPG_Author(a5)
* [][] Variablen vorsichtshalber lschen !!!! Wichtig !!!!!!!!!!!!
	clr.l	EPG_AmplifierTagList(a5)
	clr.l	EPG_ActiveAmplifier(A5)
	clr.l	EPG_AudioStruct(A5)
	clr.l	EPG_AmplifierTagList(A5)
*
		sf	OnAllowSampleinfo(A5)	;Sampleinfo verboten

		clr.l	MerkSubSongs(a5)
		clr.w	DTG_SndNum(a5)
		move.w	#$8000,EPG_Speed(a5)
		moveq	#-1,d0

		clr.w	PlayFasterOn(a5)
		clr.w	EPG_FirstSnd(a5)
		clr.w	EPG_SubSongs(a5)
		clr.l	EPG_PlayerTagList(a5)
		clr.l	EPG_ModuleInfoTagList(a5)
		bsr.w	InitInternalSS

	*----- TimerWert setzen Pal oder NTSC ----*

;		move.w	#$377c,d0
		move.w	#1773447/125,d0

		move.l	DTG_GfxBase(a5),a1
		btst	#2,$cf(a1)		Test auf Pal/NTSC Maschine
		bne.s	.SetTimer

;		move.w	#$36fa,d0		CIA Clock fr NTSC
		move.w	#1789773/125,d0		CIA Clock fr NTSC
		
.SetTimer	move.w	d0,DTG_Timer(a5)


	*-- Unter Bercksichtigung des TimeMode die max PlayTime festlegen --*
	*----------- damit nicht bei BreakSongNow der Player hngt ----------*
		bsr.w	SetRealyTime

;		move.l	EPG_TimeOut(a5),d3
;		tst.b 	OnTimeMode(a5)
;		beq.s	.MerkeThisTime
;		move.l	#EP_Flags,d0
;		jsr	A5FindTag(a5)
;		beq.s	.MerkeThisTime
;		move.l	a6,d0
;		btst	#EPF_SongEnd,d0		;Player hat kein Songende
;		beq.s	.MerkeThisTime		;Zeit gelten lassen
;		moveq	#0,d3
;.MerkeThisTime:	move.l	d3,RealTimeOut(a5)



	*----- InitPlayer aufrufen ----*
		;move.l	PlayerFlags(a5),d0
		;btst	#EPF_EPAudioAlloc,d0
		;beq.s	.OldAlloc
		;move.w	d6,EPAudioAlloc(a5)
.OldAlloc:	move.l	#DTP_InitPlayer,d0
		moveq	#-1,d3			;Error-Nr in d0
		jsr	A5CallUp(a5)
		bne.s	.InitOk


	*--- Wenn kein InitPlayer, dann testen AudioChannells setzen ---*
	* Soll AudioAlloc erst bei StartInterrupt aufgerufen werden ?   *
		;tst.w	EPAudioAlloc(a5)
		;bne.s	.InitOk

.AudioAlloc:	move.l	#EP_InitAmplifier,d0
		jsr	A5FindTag(a5)
		beq.s	.InitNoAmpl
		moveq	#0,d0
		bra.s	.InitOk

.InitNoAmpl:	*tst.l	EPG_ActiveAmplifier(a5)
		*bne.s	.Return
		jsr	A5AllocAudio(a5)
		bne.w	.Error
.InitOk:	jsr	A5ClearCache(a5)
		move.l	d0,-(a7)
		move.l	PlayerAdr(a5),d0
		bsr	FindPlayerStruct2
		bne.s	.NoooooStruct			*Wie kann das sein ?
		move.l	a0,a3
		jsr	A5UpdateDeliEmu(a5)
.NoooooStruct:	move.l	(a7)+,d0
		jsr	A5DeleteTFile(a5)
		tst.b	OnAllocChannels(a5)
		bne.s	.MustAlloc
		cmp.w	#EPR_CantAllocAudio,d0
		beq.s	.NoAlloc
.MustAlloc:	tst.l	d0
		bne.w	.Error

.NoAlloc:

	*-------- Flags laden und auswerten ---------*
		moveq	#1,d6
		move.l	#EP_Flags,d0
		jsr	A5FindTag(a5)
		beq.s	.NoFlags
		move.l	a6,PlayerFlags(a5)
		move.w	d6,PlayerFlagsDa(a5)
		move.l	a6,d0
		btst	#EPF_VolBalVoi,d0
		beq.s	.NoFlags
		move.w	d6,VolumeOn(a5)
		move.w	d6,BalanceOn(a5)
		move.w	d6,VoicesOn(a5)
		bra.s	.NoVoices

	*-- Untersttzt der Player Volume/Balance/Voices --*
.NoFlags:	move.l	#DTP_Volume,d0
		jsr	A5FindTag(a5)
		beq.s	.NoVolume		
		move.w	d6,VolumeOn(a5)
.NoVolume:	move.l	#DTP_Balance,d0
		jsr	A5FindTag(a5)
		beq.s	.NoBalance
		move.w	d6,BalanceOn(a5)

.NoBalance:	move.l	#EP_Voices,d0
		jsr	A5FindTag(a5)
		beq.s	.NoVoices
		move.w	d6,VoicesOn(a5)
.NoVoices:

	*----------------------- Playtime berechnen -------------------*
		jsr	A5CalcDuration(a5)	;Spielzeit fr Tracker berechnen
		move.l	#EP_ModuleChange,d0
		jsr	A5CallUp(a5)
		jsr	A5ClearCache(a5)

	*----- Test, ob bei diesem Module saven mglich ist -----*
		lea	WindowOffen(a5),a0
*		tst.b	KeyOn-WindowOffen(a0)
*		beq.s	.NoSave				;--> Kein Saven
		move.l	#EP_Save,d0
		jsr	A5FindTag(a5)
		bne.s	.SaveOk
		move.l	#EP_Flags,d0
		jsr	A5FindTag(a5)
		beq.s	.NoSave
		move.l	a6,d0
		move.l	PlayerFlags(a5),d0
		btst	#EPF_Save,d0
		bne.s	.SaveOk
.NoSave:	clr.w	SaveOn(a5)

	*----- Test, bei diesem Player Speed variabel ist -----*
.SaveOk:	move.w	SpeedSize(a5),d4	;SpeedNr
		move.l	#DTP_StartInt,d0
		jsr	A5FindTag(a5)
		beq.s	.NoFound		;No Found

		move.l	#EP_SetSpeed,d0
		jsr	A5FindTag(a5)
		bne.s	.NoFound

		move.w	#$8000,d4		;Kein DefaultSpeed
		move.l	#DTP_Faster,d0
		jsr	A5FindTag(a5)
		bne.s	.NoDFound
		clr.w	SpeedOn(a5)		;kein Speed verstellbar
		addq.l	#1,d4			;Kein Speed
.NoDFound:	clr.w	SpeedDOn(a5)		;kein Default-Speed
.NoFound:	move.w	d4,EPG_Speed(a5)
		bsr.w	ClrVolumes
		clr.w	MinSubSong(a5)
		clr.w	MaxSubSong(a5)
		clr.l	GetInfoAdr(a5)
		clr.l	SS_StructAdr(a5)
		clr.l	GetInfoAdr(a5)
		clr.w	NextSongOn(a5)
		clr.w	NextPatternOn(a5)
		clr.w	PrevPatternOn(a5)

	*----------- ModuleInfoadr besorgen --------*
		move.l	#EP_NewModuleInfo,d0
		jsr	A5FindTag(a5)
		bne.s	.ModInfoFound
		move.l	#EP_Get_ModuleInfo,d0
		jsr	A5CallUp(a5)
		beq.s	.NoInfo
		move.l	a0,a6
.ModInfoFound:	move.l	a6,GetInfoAdr(a5)
		move.l	a6,EPG_Moduleinfotaglist(a5)
		move.l	#MI_AuthorName,d0
		jsr	A5FindTag2(a5)
		beq.s	.NoAuthor
		move.l	a6,EPG_Author(a5)

.NoAuthor:	move.l	GetInfoAdr(a5),a6
		move.l	EPG_SomePrefs(a5),d0
		tst.b	OnCalcDuration(a5)	;wenn nicht erlaubt, auch
		beq.s	.NoInfo			;nicht setzen !!!
		move.l	#MI_Duration,d0
		jsr	A5FindTag2(a5)
		beq.s	.NoInfo
		move.l	a6,d0
		blt.s	.NoInfo
		move.l	d0,EPG_Duration(a5)


	*----- Structure-Adresse allocieren -----*
.NoInfo:	jsr	A5ClearCache(a5)
		lea	EP_UPSStructure(a5),a0
		move.l	#EP_Flags,d0
		jsr	A5FindTag(a5)
		beq.s	.NoFlagsForUPS
		move.l	a6,d0
		btst	#EPF_InternalUPSStructure,d0
		bne.s	.EPStructOk
.NoFlagsForUPS:	move.l	#EP_StructInit,d0
		moveq	#0,d3
		jsr	A5CallUp(a5)
		beq.s	.NoStruc
.EPStructOk:	move.l	a0,SS_StructAdr(a5)
		move.l	a0,EPG_UPS_Structure(a5)
		bsr.w	ClearSS_Struct


.NoStruc:	move.l	#DTP_Interrupt,d0
		jsr	A5FindTag(a5)
		beq.s	.NoPlayFaster
		move.w	#-1,PlayFasterOn(a5)

	*---- Gibt es eine Patternumschaltung -----*
.NoPlayFaster:	move.l	#DTP_PrevPatt,d0
		jsr	A5FindTag(a5)
		beq.s	.NoPrevPatt
		move.w	#-1,PrevPatternOn(a5)

.NoPrevPatt:	move.l	#DTP_NextPatt,d0
		jsr	A5FindTag(a5)
		beq.s	.NoNextPatt
		move.w	#-1,NextPatternOn(a5)


	*---- Min und max Song festlegen -----*
.NoNextPatt:	move.l	#DTP_SubSongRange,d0
		moveq	#0,d3
		jsr	A5CallUp(a5)
		bne.s	.SubSongs

		move.l	#DTP_NewSubSongRange,d0
		jsr	A5FindTag(a5)
		beq.s	.NoNewSubSongR
		move.w	(a6)+,d0
		move.w	(a6)+,d2
		move.w	(a6)+,d1
		bra.s	.SubSongs2

	*---- Testen ob Player SubSongs untersttzt ----*
.NoNewSubSongR:	move.l	#DTP_NextSong,d0
		jsr	A5FindTag(a5)
		beq.s	.NoSubSongs
		moveq	#-1,d0
		move.w	d0,EPG_FirstSnd(a5)
		move.w	d0,EPG_SubSongs(a5)
		not.w	NextSongOn(a5)
		bra.b	.NoSubSongs

.SubSongs:	move.l	d0,d2				;Startsong
.SubSongs2:	cmp.w	#7,d0
		bne.s	.NoJamesPond
		cmp.w	d0,d1
		bne.s	.NoJamesPond
		moveq	#1,d0
		moveq	#1,d2
		bra.s	.JamesPond
.NoJamesPond:	cmp.w	d0,d1
		beq.s	.OneSubSong
.JamesPond:	not.w	NextSongOn(a5)
.OneSubSong:	move.w	d0,MinSubSong(a5)
		move.w	d1,MaxSubSong(a5)
		*move.w	d0,DTG_SndNum(a5)
		move.w	d2,DTG_SndNum(a5)
		move.w	d2,EPG_FirstSnd(a5)
		*move.w	d0,EPG_FirstSnd(a5)

	sub.w	d0,d1
	addq.w	#1,d1
*		sub.w	d0,d1
*		tst.w	d0
*		bne.s	.NoAddi1
*		*beq.s	.NoAddi1
*		addq.w	#1,d1
*.NoAddi1:	tst.w	d1
*		bne.s	.NochAddi1
*		addq.w	#1,d1
.NochAddi1:	move.w	d1,EPG_SubSongs(a5)

		*--- Vom User aus definierter Startsong ---*
		move.l	MDStartSong(a5),d0
		ble.s	.NoNewStartSong
		cmp.w	MaxSubSong(a5),d0
		bhi.s	.NoNewStartSong
		subq.w	#1,d0
		add.w	MinSubSong(a5),d0
		move.w	d0,DTG_SndNum(a5)
.NoNewStartSong:

.NoSubSongs:	move.l	PlayerAdr(a5),EPG_PlayerTagList(a5)
		move.l	MDNummer(a5),EPG_LoadedFiles(a5)
		move.l	EPG_SomePrefs(a5),d0
		bset	#EGPRF_NowPlay,d0
		bset	#EGPRF_PausePlay,d0
		move.l	d0,EPG_SomePrefs(a5)

	*----------------- ModuleSize berechnen ---------------*
		move.l	GetInfoAdr(a5),d0
		beq.w	.NoSizeStruct
		move.l	d0,a6
		move.l	#MI_LoadSize,d0
		jsr	A5FindTag2(a5)
		beq.s	.NoSizeStruct
		move.l	a6,d0
		bra.b	.TesteSize

	*------ Test auf ExtLoad, wenn ja -->> keine Size Angabe -----*
.NoSizeStruct:	move.l	#DTP_Extload,d0
		jsr	A5FindTag(a5)
		bne.b	.UnknownSize

	*----- Testen ob Lnge -1 --> CustomSong -----*
		move.l	MDPuffer+4(a5),d0
		beq.s	.UnknownSize
.TesteSize:	moveq	#-1,d1
		cmp.l	d0,d1
		bne.s	.SetSize		;--> CustomSong ohne SizeAngabe
.UnknownSize:	moveq	#-1,d0
.SetSize:	move.l	d0,EPG_ModuleSize(a5)


*
* [][]
* Auf Amplifier testen
* Achtung Engines benachrichtigen !
*
	move.l	#EP_InitAmplifier,d0	;Output: d0=NUll oder Error
					;  Tagliste in EPGL_AmplifierTagList
	moveq	#-1,d3			;Error-Nr in d0
	jsr	A5CallUp(a5)
	beq.s	.noAmplifier		;D2=0 -> Tag nicht gefunden

	tst.l	d0
	bne	Errorinitplayer		;keine 0 in D0 zurck -> Fehler beim
					;Init der Tagliste

	tst.l	EPG_AmplifierTagList(a5)
	beq.w	Errorinitplayer		;Return ok, aber keine Taglist -> Fehler


*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
* Bei nderungen auch PlaySample ndern !!!!!!!!!!!!!!!
*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

	move.l	EPG_AmplifierList(a5),d1

	;sucht einfach die Liste von vorn bis hinten durch
	;(da die Amplifier bereits nach Prioritt sortiert sind)
.AMsuch_loop
	beq.s	.AM_nonefound
	move.l	d1,a0			;EUS_Start Struktur

	move.w	EUS_Flags(a0),d2	;Amplifier erlaubt ?
	and.b	#EUSB_Disable,d2
	bne.s	.AMsuch_next		;nein

	move.l	EUS_SpecialJumpTab(a0),d2
	beq.s	.AMsuch_next
	move.l	d2,a0
	move.l	AMJ_Init(a0),d2		;Einsprung fr Init
	beq.s	.AMsuch_next
	move.l	d2,a1

	move.l	EPG_AmplifierTagList(a5),a0
	movem.l	d1-a6,-(sp)
	jsr	(A1)			;Test & Init
	movem.l	(sp)+,d1-a6
	tst.l	d0
	beq.s	.AM_found
.AMsuch_next
	move.l	d1,a0
	move.l	EUS_Identifier(a0),d1
	bra.s	.AMsuch_loop
.AM_found
	move.l	d1,EPG_ActiveAmplifier(A5)

	tst.l	SS_StructAdr(a5)
	bne.s	.noAmplifier

	move.l	d1,a0
	*move.l	EUS_Reserved5(a0),SS_StructAdr(a5)
	move.l	EUS_AMUPSStruct(a0),SS_StructAdr(a5)
	move.l	EUS_AMUPSStruct(a0),EPG_UPS_Structure(a5)

	bsr.w	ClearSS_Struct
	moveq	#1,d0
	move.w	d0,VolumeOn(a5)
	move.w	d0,BalanceOn(a5)
	move.w	d0,VoicesOn(a5)

	bra.s	.noAmplifier
.AM_Nonefound
	moveq	#EPR_NoAmplifier,d0	;kein passender AM gefunden
	bra	Errorinitplayer

.noAmplifier

*-------------------------------------------------------

		*bsr	UpdateDeliInfoTags


	*------------- Userprogramme benachrichtigen -------------*
	*-- wird spter gemacht
		st	OnAllowSampleinfo(A5)	;Sampleinfo erlaubt

		moveq	#0,d0
		move.w	#-1,ModuleLoaded(a5)
.Error:		;clr.w	WhileInit(a5)
		tst.l	d0
		rts




*----------------- Lsche die aktuelle InternalSoundStrukture --------------*
InitInternalSS:	lea	EP_UPSStructure(a5),a1
		move.l	a1,EPG_UPS_Structure(a5)
		moveq	#UPS_SizeOf-1,d0
.Clear:		clr.b	(a1)+
		dbf	d0,.Clear

		lea	EP_UPSStructure(a5),a1
		move.w	#UPSB_Adr!UPSB_LEN!UPSB_Per!UPSB_Vol!UPSB_DMACON,UPS_Flags(a1)
		move.w	EPG_Voices(a5),UPS_DmaCon(a1)
		rts



	*--------------------------------------------------------*
	*---- Initialisiere ein Soundsystem mit einem Modul -----*
	*--------------------------------------------------------*
InitSound:	movem.l	d1-a6,-(a7)
		clr.b	InitOn(a5)
		clr.l	EPG_CurrentTime(a5)
* [][]
	tst.l	EPG_ActiveAmplifier(A5)
	bne.s	.skip
	tst.b	AudioEnabled(a5)
	beq.s	.skip
	tst.b	DracoOn(a5)
	bne.s	.skip
		move.w	#15,$dff096
.skip

	*---------- Flags setzen ---------*
		move.l	EPG_SomePrefs(a5),d0
		bclr	#EGPRF_PausePlay,d0
		move.l	d0,EPG_SomePrefs(a5)

	*---------- SubSongTest ---------*
		*move.l	#DTP_SubSongRange,d0
		*jsr	A5FindTag(a5)
		*beq.s	.NoTest
		move.l	#DTP_SubSongTest,d0
		jsr	A5CallUp(a5)
		beq.s	.NoTest
		tst.l	d0
		bne.s	.InitReturn

	*----- Normale Init-Routine -----*
.NoTest:	moveq	#0,d3
		move.l	#DTP_InitSound,d0
		jsr	A5CallUp(a5)

		jsr	A5ClearCache(a5)

		move.b	#1,InitOn(a5)
		bsr.w	SetFilter
		bsr.w	RetteDma

		clr.b	SongEndNow(a5)
		clr.b	TimeOverNow(a5)
		clr.b	SongEndVerbot(a5)

		moveq	#0,d0
.InitReturn:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

RetteDma:

* [][] DMA Hack
	tst.l	EPG_ActiveAmplifier(A5)
	bne.s	.skip
	tst.b	AudioEnabled(a5)
	beq.s	.skip

		move.l	d0,-(a7)
		move.w	$dff002,d0
		and.w	#15,d0
		move.w	d0,MerkDMA(a5)
		bsr.w	DTWaitAudioDma
		move.w	#15,$dff096
		bsr.w	DTWaitAudioDma
		move.l	(a7)+,d0
.skip
		rts

SetzeDMA:
* [][]
	tst.l	EPG_ActiveAmplifier(A5)
	bne.s	.skip
	tst.b	AudioEnabled(a5)
	beq.s	.skip
		move.l	d0,-(a7)
		move.w	MerkDma(a5),d0
		or.w	#$8000,d0
		bsr.w	DTWaitAudioDma
		move.w	d0,$dff096
		bsr.w	DTWaitAudioDma
		move.l	(a7)+,d0
.skip
		rts

	*-----------------------------------------------------*
	*------------------ Setze Interrupt ------------------*
	*-----------------------------------------------------*
StartInterrupt:	movem.l	d1-a6,-(a7)
		move.l	PufferAdr(pc),a5
		tst.b	PlayOn(a5)
		bne.w	.Return2
		clr.b	TimerOn(a5)
		clr.b	TimerFremd(a5)

*
* [][] Start Int fr Amplifier
*
	move.l	EPG_ActiveAmplifier(A5),d0
	beq.s	.noAM

	move.l	d0,a0
	move.l	EUS_SpecialJumpTab(a0),d0
	beq.s	.noAm
	move.l	d0,a0
	move.l	AMJ_Startint(a0),d0		;Einsprung fr Start Interrupt
	beq.s	.noAm
	move.l	d0,a0
	movem.l	d1-a6,-(sp)
	jsr	(a0)
	movem.l	(sp)+,d1-a6
	tst.l	d0
	bne	.Return
.noAM

	*-------- Mssen Audio-Kanle noch allokiert werden ---------*
		;tst.w	EPAudioAlloc(a5)
		;beq.s	.AudioAllokiert
		;jsr	A5AllocAudio(a5)
		;bne.w	.Return


	*--------- So, nun geht's los ----------*
.AudioAllokiert:bsr.w	SetzeDma

		tst.w	VolumeOn(a5)
		beq.s	.NoFadeIn1
	;	move.l	#DTP_Volume,d0
	;	jsr	A5FindTag(a5)
	;	beq.s	.NoFadeIn1
		tst.b	OnFadeIn(a5)
		beq.s	.NoFadeIn1			;FadeAus
		move.w	DTG_SndVol(a5),MerkZelle(a5)
		clr.w	DTG_SndVol(a5)			;vorsichtshalber auf
.NoFadeIn1:	jsr	A5EPP_SetVolume(a5)		;Null setzen
		moveq	#0,d3
		move.l	#DTP_StartInt,d0
		jsr	A5CallUp(a5)
		beq.s	.SetMy
		move.b	#1,TimerFremd(a5)
		moveq	#0,d0
		bra.s	.ReturnOk

	*---------- Setze Internen Interrupt ---------*
.SetMy:		move.l	#DTP_Interrupt,d0
		jsr	A5FindTag(a5)
		lea	MusicAdr(pc),a1
		move.l	a6,(a1)

		jsr	A5SetCiaBTimer(a5)
		tst.b	d0
		bne.w	.Return
		move.b	#1,TimerOn(a5)
.ReturnOk:	;tst.l	EPG_TimeOut(a5)
		;beq.s	.NoPlayTime
		lea	SecondsZahler(a5),a0
		lea	MicrosZahler(a5),a1
		move.l	DTG_IntuitionBase(a5),a6
		jsr	_LVOCurrentTime(a6)
		move.l	SecondsZahler(a5),d0
		sub.l	EPG_CurrentTime(a5),d0
		move.l	d0,SecondsZahler(a5)

.NoPlayTime:	move.b	#1,PlayOn(a5)

		jsr	A5EPP_SetVoices(a5)

	*-------------- Flags setzen -------------*
		move.l	EPG_SomePrefs(a5),d0
		bset	#EGPRF_NowPlay,d0
		bclr	#EGPRF_PausePlay,d0
		move.l	d0,EPG_SomePrefs(a5)
	;	bset	#EGPRF_NowPlay,EPG_SomePrefs+3(a5)

		moveq	#USClass_StartInt,d0	;User-Programme starte
		jsr	A5SendeAllMessage(a5)

		jsr	A5ClearTickCounter(a5)

	;	move.l	#DTP_Volume,d0
	;	jsr	A5FindTag(a5)
	;	beq.s	.Return2

		tst.w	VolumeOn(a5)
		beq.s	.Return2

		tst.b	OnFadeIn(a5)
		beq.s	.Return2
		move.w	MerkZelle(a5),d4
		beq.s	.Return2
		move.l	d4,-(a7)
		moveq	#0,d5
.NextVol:	move.w	d5,DTG_SndVol(a5)	
		jsr	A5EPP_SetVolume(a5)
		jsr	A5Delay(a5)
		addq.l	#1,d5
		dbf	d4,.NextVol
		move.l	(a7)+,d0
		move.w	d0,DTG_SndVol(a5)

.Return2:	moveq	#0,d0
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

	*---------------------------------------------------------*
	*--------------- Stoppe Interrupts wieder ----------------*
	*---------------------------------------------------------*
StopInterrupt2:	movem.l	d0-a6,-(a7)
		bra.s	StopInterrupt3
StopInterrupt:	movem.l	d0-a6,-(a7)
		moveq	#0,d7
StopInterrupt3:	move.l	PufferAdr(pc),a5
		tst.b	PlayOn(a5)
		beq.w	.Return
		clr.b	PlayOn(a5)

		move.w	DTG_SndVol(a5),d4
		move	d4,LastFadeVolume(a5)
		beq.s	.NoFadeOut

		tst.w	VolumeOn(a5)
		beq.s	.NoFadeOut

	;	move.l	#DTP_Volume,d0
	;	jsr	A5FindTag(a5)
	;	beq.s	.NoFadeOut

		tst.b	OnFadeOut(a5)
		beq.s	.NoFadeOut

.NextVol:	move.w	d4,DTG_SndVol(a5)	
		jsr	A5EPP_SetVolume(a5)
		jsr	A5Delay(a5)
		dbf	d4,.NextVol

	*------------- Flags setzen --------------*
.NoFadeOut:	move.l	EPG_SomePrefs(a5),d0
		bclr	#EGPRF_NowPlay,d0
		tst.l	d7
		beq.s	.NoPause
		bset	#EGPRF_PausePlay,d0
.NoPause:	move.l	d0,EPG_SomePrefs(a5)

		moveq	#USClass_StopInt,d0	;User-Type Prg stoppen
		jsr	A5SendeAllMessage(a5)

		tst.b	TimerFremd(a5)
		bne.s	.CloseFremd
		jsr	A5CloseCiaBTimer(a5)
		bra.s	.Closevaris
.CloseFremd:	move.l	#DTP_StopInt,d0
		moveq	#0,d3
		jsr	A5CallUp(a5)
.CloseVaris:	bsr.w	RetteDMA
		clr.b	TimerOn(a5)
		clr.b	TimerFremd(a5)

	*----- Mssen Audio-Kanle noch freigegeben werden -----*
		;tst.w	EPAudioAlloc(a5)
		;beq.s	.??????				;.Return
		;jsr	A5FreeAudio(a5)
* [][] Stop Amplifier
*
	move.l	EPG_ActiveAmplifier(A5),d0
	beq.s	.noAM

	move.l	d0,a0
	move.l	EUS_SpecialJumpTab(a0),d0
	beq.s	.noAm
	move.l	d0,a0
	move.l	AMJ_Stopint(a0),d0		;Einsprung fr Start Interrupt
	beq.s	.noAM
	move.l	d0,a0
	movem.l	d1-a6,-(sp)
	jsr	(a0)
	movem.l	(sp)+,d1-a6
.noAM:
		move	LastFadeVolume(a5),DTG_SndVol(a5)

		tst.l	PlayerAdrSample(a5)
		beq.s	.Return
		jsr	A5PlaySampleEndAudstruct(a5)
		jsr	A5PlaySampleRestoreModule(a5)

.Return:	movem.l	(a7)+,d0-a6
		rts

	*------------------------------------------------------------*
	*------- Modul entfernen und Speicher initialisieren --------*
	*------------------------------------------------------------*
AllesRaus:	movem.l	d0-a6,-(a7)
		tst.l	PlayerAdr(a5)
		beq.w	AllesReturn

		jsr	A5StopInterrupt(a5)

	*--------- Userprogramme benachrichtigen -----------*
		moveq	#USClass_KillModule,d0
		jsr	A5SendeAllMessage(a5)


*
* [][]
* Endroutine aufrufen

;------------------------------- noch nicht vorgesehen ---------------------
;	move.l	#EP_EndAmplifier,d0
;	moveq	#-1,d3
;	jsr	A5CallUp(a5)
;---------------------------------------------------------------------------
*
* Bei nderungen auch PlaySample ndern !!!!!!!!!!!!!!!
*
	move.l	EPG_ActiveAmplifier(A5),d0
	beq.s	.noAM

	move.l	d0,a0
	move.l	EUS_SpecialJumpTab(a0),d0
	beq.s	.noAM
	move.l	d0,a0
	move.l	AMJ_End(a0),d0		;Einsprung fr EndAmplifier
	beq.s	.noAM
	move.l	d0,a0
	movem.l	d1-a6,-(sp)
	jsr	(a0)
	movem.l	(sp)+,d1-a6
	bra.s	.am
.noAM
	bsr.w	ClrVolumes
.am

* Variablen lschen !!!
	clr.l	EPG_AmplifierTagList(a5)
	clr.l	EPG_ActiveAmplifier(A5)
	clr.l	EPG_AudioStruct(A5)
	clr.l	EPG_AmplifierTagList(A5)
*

		move.l	#EP_Free_ModuleInfo,d0
		moveq	#0,d3
		jsr	A5CallUp(a5)
		clr.l	GetInfoAdr(a5)

		move.l	#EP_StructEnd,d0
		moveq	#0,d3
		jsr	A5CallUp(a5)
		clr.l	SS_StructAdr(a5)
		jsr	A5EndSound(a5)
		bsr.w	InitInternalSS

	*----------------- EndPlayer aufrufen --------------*
		move.l	#DTP_EndPlayer,d0
		moveq	#0,d3
		jsr	A5CallUp(a5)

		sf	OnAllowSampleinfo(A5)	;Sampleinfo erlaubt
		clr.l	EPG_PlayerTagList(a5)

	*--------- Userprogramme benachrichtigen -----------*
*		moveq	#USClass_KillModule,d0
*		jsr	A5SendeAllMessage(a5)

	*--- Kein EndPlayer ->> Eigene Routine benutzen ----*
		jsr	A5FreeAudio(a5)

		clr.l	SampleCounter(a5)
		jsr	FreeSampleInfo		;SampleInfo freigeben

.EndOk:		movem.l	(a7)+,d0-a6

	*----------------- Fehler bei InitPlayer ----------------*
AllesRaus2:	movem.l	d0-a6,-(a7)
		jsr	A5FreeOldModule(a5)
		jsr	A5KEYRoutinenTester(a5)
		jsr	A5TitleAufbau(a5)
		jsr	A5DeleteTFile2(a5)

	*------------ Lock Module aufheben ---------*
		movem.l	d0-a6,-(a7)
		move.w	#EPNr_LockModule,d0
		moveq	#0,d2
		jsr	A5JumpTo(a5)
		movem.l	(a7)+,d0-a6


	*----- DT-EmulationsMemory aufheben ----*
		move.l	DT_AmplifierStruct(a5),d0
		beq.s	.DT_NoEmu
		move.l	d0,a1
		move.l	DT_AmplifierstructSize(a5),d0
		Execbase
		jsr	_LVOFreeMem(a6)
.DT_NoEmu:	clr.l	DT_AmplifierstructSize(a5)
		clr.l	DT_AmplifierStruct(a5)
		clr.l	DT_NoteStruct(a5)

* [][] Variablen lschen !!!
	clr.l	EPG_AmplifierTagList(a5)
	clr.l	EPG_ActiveAmplifier(A5)
	clr.l	EPG_AudioStruct(A5)
	clr.l	EPG_AmplifierTagList(A5)
*
*		clr.l	CU_SubTagList

		clr.b	ComposerPuffer(a5)
		clr.l	EPG_UPS_Structure(a5)
		clr.l	EPG_Author(a5)
		clr.l	EPG_PlayerTagList(a5)
		clr.l	EPG_ModuleInfoTagList(a5)
		clr.l	EPG_LoadedFiles(a5)
		clr.l	EPG_SampleInfoStructure(a5)
		clr.l	EPG_ModuleSize(a5)
		clr.l	SampleCounter(a5)
		clr.w	SpeedOn(a5)			;Kein Speed verstellbar
		clr.w	SpeedDOn(a5)
		clr.w	NextSongOn(a5)			;Keine SubSongs mglich
		clr.w	NextPatternOn(a5)		;Kein NextPattern
		clr.w	PrevPatternOn(a5)		;Kein PrevPattern
		clr.w	SaveOn(a5)
		clr.w	VolumeOn(a5)
		clr.w	BalanceOn(a5)
		clr.w	VoicesOn(a5)
		clr.w	PlayFasterOn(a5)
	;	clr.w	EPAudioAlloc(a5)
		clr.w	PlayerFlagsDa(a5)
	*	clr.w	FirstSubSong(a5)
		clr.l	PlayerFlags(a5)
		clr.l	EPG_CurrentTime(a5)
		clr.b	TitlenamePuffer(a5)
		clr.b	InitOn(a5)
		clr.b	SongEndNow(a5)
		clr.b	TimeOverNow(a5)
		clr.b	SongEndVerbot(a5)
		clr.b	LHALoaded(a5)
		clr.b	SoundsystemPuffer(a5)
		*clr.b	RippedFile(a5)
		clr.w	MerkDma(a5)
		clr.w	ModuleLoaded(a5)
		move.w	#$8000,EPG_Speed(a5)
		clr.w	EPG_FirstSnd(a5)
		clr.w	EPG_SubSongs(a5)
		clr.l	EPG_ModNr(a5)
		clr.l	LoadedMenuFileName(a5)
		sf	OnAllowSampleinfo(A5)	;Sampleinfo verboten

AllesReturn:	movem.l	(a7)+,d0-a6
		rts


	*-----------------------------------------------*
	*--------------- Alle Volumes lschen ----------*
	*-----------------------------------------------*
EndSound:	movem.l	d0-a6,-(a7)
		move.l	#DTP_EndSound,d0
		moveq	#0,d3
		jsr	A5CallUp(a5)
		bne.s	.EndReturn
		bsr.b	ClrVolumes
.EndReturn:	clr.b	InitOn(a5)

* [][]
	tst.l	EPG_ActiveAmplifier(A5)
	bne.s	.skip
	tst.b	AudioEnabled(a5)
	beq.s	.skip
		move.w	#15,$dff096
.skip

		movem.l	(a7)+,d0-a6
		rts

	*---------- Alle AudioDaten lschen -----------*
ClrVolumes:
* [][]
	tst.l	EPG_ActiveAmplifier(A5)
	bne.s	.skip
	tst.b	AudioEnabled(a5)
	beq.s	.skip
		lea	$dff0a0,a0
		move.w	#15,-10(a0)

		moveq	#3,d0
.ClrIt:		clr.l	(A0)+		;adr
		move.w	#2,(a0)+	;len
		move.w	#$600,(a0)+	;per
		clr.w	(A0)+		;vol
		lea	6(a0),a0	;pad
		dbf	d0,.ClrIt
.skip
		rts

	*-------- Alle Structdaten bis UPS_DmaCon lschen ---------*
ClearSS_Struct:	move.l	SS_StructAdr(a5),d0
		beq.s	.ClearReturn
		move.l	d0,a0
		moveq	#UPS_DmaCon/4-1,d0
.CLearStruct:	clr.l	(a0)+
		dbf	d0,.ClearStruct
.ClearReturn:	rts


*-----------------------------------------------------------------------*
*		d0 Bit 0-3 = Set Voices Bit=1 Voice on			*
RefreshVolumes:	movem.l	d0-a6,-(a7)
		tst.l	EPG_ActiveAmplifier(A5)
		bne	.Return
		tst.b	AudioEnabled(a5)
		beq.s	.Return

		tst.w	PlayerFlagsda(a5)
		beq.s	.Return
		move.l	PlayerFlags(a5),d0
		btst	#EPF_VolBalVoi,d0
		beq.s	.Return

		move.l	SS_StructAdr(a5),a0
		lea	$dff0a0,a5
		moveq	#3,d1
.SetNew		moveq	#0,d0
		move.w	UPS_Voice1Vol(a0),d0
		jsr	Pro_SetVoices
		moveq	#UPS_Modulo,d0
		add.l	d0,a0
		addq.l	#8,a5
		addq.l	#8,a5
		dbf	d1,.SetNew
.Return:	movem.l	(a7)+,d0-a6
		rts

	*---------------------------------------*
	*--------- Setze Volume neu ------------*
	*---------------------------------------*
EPP_SetVolume:	movem.l	d1-a6,-(a7)
		jsr	A5SetVoicesInEPG(a5)
		move.l	#DTP_Volume,d0
		moveq	#0,d3
		jsr	A5CallUp(a5)
		bsr.s	RefreshVolumes
		movem.l	(a7)+,d1-a6
		moveq	#0,d0
		rts

	*---------------------------------------*
	*----------- Setze Balance neu ---------*
	*---------------------------------------*
EPP_SetBalance:	movem.l	d1-a6,-(a7)
		jsr	A5SetVoicesInEPG(a5)
		move.l	#DTP_Balance,d0
		moveq	#0,d3
		jsr	A5CallUp(a5)
		bsr.s	RefreshVolumes
		movem.l	(a7)+,d1-a6
		moveq	#0,d0
		rts

	*---------------------------------------*
	*----------- Setze Voices neu ----------*
	*---------------------------------------*
EPP_SetVoices:	movem.l	d0-a6,-(a7)
		jsr	A5SetVoicesInEPG(a5)
		moveq	#0,d3
		move.w	EPG_Voices(a5),d3
		move.l	#EP_Voices,d0
		jsr	A5CallUp(a5)
		bsr.w	RefreshVolumes
		movem.l	(a7)+,d0-a6
		rts

	*---------------------------------------*
	*---- Setz die Voices in die Globals ---*
	*---------------------------------------*
SetVoicesInEPG:	movem.l	d0-a6,-(a7)

		*----- neuen Eagleplayervolume setzn ----*
		*EPG_Volume		= 0-255
		*EPG_LeftBalance	= 0-255
		*EPG_RightBalance	= 0-255
		*Balancesize		= -255 to +255
		*Voicetable
		*----------
		*Puffer mit Bytezellen, die die Stimmenvolume enthalten
		*danach Puffer fr dieselben Zellen, aber nur Zustand
		*wird bentigt fr Ein/Aus-TasterPuffer mit Bytezellen, die die Stimmenvolume enthalten
		*Puffer1  dc.b Volumewert (berechnet aus Volume,Balance ...
		*Puffer2  dc.b ConfigVolumewert,Zustand

		move.l	EPG_VoiceTable(a5),a0
		moveq	#EP_MaxVoices-1,d1
		lea	1(a0,d1.w),a1
.FillPuffer:	move.b	(a1)+,d0
		tst.b	(a1)+
		beq.s	.Off
		move.b	d0,(a0)+
		bra.s	.On
.Off:		clr.b	(a0)+
.On:		dbf	d1,.FillPuffer




	*--------------- Linke Volume -------------*
.NoIntern:	moveq	#0,d0
		move.w	DTG_SndLBal(a5),d0
		mulu	DTG_SndVol(a5),d0
		lsr.w	#6,d0

		moveq	#0,d1
		move.b	InternVoicePuffer+EP_MaxVoices(a5),d1	;Voice1-Volume
		mulu	d0,d1
		divu	#EP_MaxVolume,d1
		move.w	d1,EPG_Voice1Vol(a5)

		moveq	#0,d1
		move.b	InternVoicePuffer+EP_MaxVoices+6(a5),d1 ;Voice4-Volume
		mulu	d0,d1
		divu	#EP_MaxVolume,d1
		move.w	d1,EPG_Voice4Vol(a5)

	*-------------- Rechte Volume -------------*
		moveq	#0,d0
		move.w	DTG_SndRBal(a5),d0
		mulu	DTG_SndVol(a5),d0
		lsr.w	#6,d0

		moveq	#0,d1
		move.b	InternVoicePuffer+EP_MaxVoices+2(a5),d1 ;Voice1-Volume
		mulu	d0,d1
		divu	#EP_MaxVolume,d1
		move.w	d1,EPG_Voice2Vol(a5)

		moveq	#0,d1
		move.b	InternVoicePuffer+EP_MaxVoices+4(a5),d1 ;Voice4-Volume
		mulu	d0,d1
		divu	#EP_MaxVolume,d1
		move.w	d1,EPG_Voice3Vol(a5)

	*--- Voice-Flags setzen und eventuell Volume lschen ----*
		lea	EPG_Voice4Vol(a5),a2
		lea	InternVoicePuffer+EP_MaxVoices+4(a5),a1
		moveq	#0,d3
		moveq	#3,d1
.NextVoice:	bset	#0,d3
		tst.b	(a1,d1.w)
		bne.s	.VoiceOn
		clr.w	(a2)
		bclr	#0,d3
.VoiceOn:	asl.l	#1,d3
		subq.l	#1,a1
		subq.l	#2,a2
		dbf	d1,.NextVoice
		asr.l	#1,d3
		move.w	d3,EPG_Voices(a5)
		move.w	d3,EP_UPSStructure+UPS_DmaCon(a5)

		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Routinen, die alle Engines anhpft, die vom angegebenen Type sind active    *
* sind und den entsprechenden Tag haben.				      *
*-----------------------------------------------------------------------------*
* Input: d0/d1/d2/a0/a1/a2=Args						      *
*	 d3=Enginetype							      *
*	 d4=FirstEngineNr (bei der das Suchen beginnt)			      *
*	 d5=Tag								      *
* Output:d0/d1/d2/a0/a1/a2=Args						      *
*	 d3=Error oder NULL						      *
*	 d4=EngineNr							      *
*-----------------------------------------------------------------------------*
UserCallUp5:	movem.l	d5-d7/a3-a6,-(a7)
		move.l	PufferAdr(pc),a5
		lea	-4*6(a7),a7
		movem.l	d0/d1/d2/a0/a1/a2,(a7)

		tst.l	d4
		blt.s	.NoMoreEntries

		*lea	EPG_FirstUserStruct(a5),a4
.NextEngine:	cmp.l	#AnzMaxEngines,d4
		bhi.s	.NoMoreEntries
		move.l	d4,d0
		*beq.s	.NextEngine
		jsr	A5FindUserStruct(a5)
		addq.l	#1,d4
		tst.l	d0
		bne.s	.NextEngine
		move.l	a0,a4
		move.l	UPrgS_UFlags(a4),d7
		btst	#UPrgF_Engine,d7
		beq.w	.NextEngine
		btst	#UPrgF_Active,d7
		beq.w	.NextEngine
		move.l	UPrgS_EusAdr(a4),d7
		beq.s	.NextEngine
		move.l	d7,a3
		tst.l	d3
		beq.s	.NoTypeTest
		cmp.b	EUS_Type(a3),d3
		bne.s	.NextEngine

	*----------- Nun reinhppen ------------*
.NoTypeTest:	movem.l	(a7),d0/d1/d2/a0/a1/a2
		movem.l	d3-d7/a3-a6,-(a7)
		move.l	EUS_TagList(a3),-(a7)		;Tagliste auf Stack
		move.l	d5,-(a7)			;Tag auf Stack
		jsr	A5UserCallUp(a5)
		addq.l	#8,a7
		movem.l	(a7)+,d3-d7/a3-a6
		beq.s	.NextEngine		;beq=kein Tag
		cmp.l	#EUT_ConvertModule,d5
		beq.s	.Converter
		cmp.w	#EPR_FunctionAborted,d0
		beq.s	.Abort
		cmp.w	#EPR_NoMoreEntries,d0
		beq.s	.Abort
		tst.l	d0			;d0=Fehlernummer
		bne.s	.NextEngine
	*	move.l	UPrgS_EngineNr(a4),d4
.ItsOk:		moveq	#0,d3
		bra.s	.Return

.Converter:	tst.l	d0			;d0=Filesize oder NULL
		beq.s	.NextEngine
		bra.s	.ItsOk

.Abort:		move.l	d0,d3
		bra.s	.Error

.NoMoreEntries:	moveq	#0,d0
		moveq	#EPR_EngineNotFound,d3
.Error:		moveq	#-5,d4			*Fr nochmaliges Aufrufen
.Return:	lea	4*6(a7),a7
		movem.l	(a7)+,d5-d7/a3-a6
		tst.l	d3
		rts


	*-----------------------------------------------------*
	*-------------- Call-Up Aufruf fr Player ------------*
	*----- Input:  d0 = Adr der Routine		------*
	*----- OutPut: d2 = Hingesprungen = 1		------*
	*-----------------------------------------------------*
UserCallUp3:	movem.l	d0/a6,-(a7)
		moveq	#0,d2
		jsr	A5GetMainWindowTags(a5)
		beq.s	.Notags
		move.l	d0,a6
		move.l	(a7),d0
		bsr.b	CallUp3
.NoTags:	addq.l	#4,a7
		move.l	(a7)+,a6
		rts

	*----------------- Callup fr Engines -----------------*
	* d0=Nummer d7=tag
UserCallUp4:	move.l	d0,-(a7)
		*moveq	#0,d2
		jsr	A5GetMainWindowTags(a5)
		beq.s	.NoGui
		move.l	d0,-(a7)		;Tagliste auf Stack
		move.l	4(a7),d0		;EPNr
		ext.l	d0
		move.l	d7,-(a7)		;Tag auf Stack
		jsr	A5UserCallUp(a5)
		addq.l	#8,a7
.NoGui:		addq.l	#4,a7
.Ok:		move.l	PufferAdr,a5
		*tst.l	d0			;Z-Flag gesetzt -> kein Tag
		rts


CallUp3:	bsr	DeliCallUp2		*DeliTaskEmulation
		bne.s	CallupReturn		*DeliTaskEmulation
		jsr	A5FindTag2(a5)
		bra.b	CallUp4
CallUp:		bsr	DeliCallUp		*d2=1 Routine found
		bne.s	CallUpReturn		*DeliTaskEmulation
		jsr	A5FindTag(a5)
CallUp4:	tst.l	d2
		beq.s	CallUpReturn
		move.l	d3,d0
		moveq	#0,d2
		cmp.l	a6,d2
		beq.s	CallUpReturn
		movem.l	d3-d7/a1-a6,-(a7)
		moveq	#0,d1
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		moveq	#0,d6
		moveq	#0,d7
		jsr	(a6)
		moveq	#1,d2
		movem.l	(a7)+,d3-d7/a1-a6
CallUpReturn:	tst.l	d2
		rts

	*------- Auf Stack in -8 liegt Tag und -12 die Tagliste --------*
UserCallUp:	subq.l	#8,a7
		movem.l	d0/d2/a6,-(a7)
		move.l	12+8+8(a7),d0		;Liste
		beq.s	.NoList
		move.l	d0,a6
		move.l	12+8+4(a7),d0		;Tag
		jsr	A5FindTag2(a5)
;	moveq	#1,d2
;	lea	CheckForPlayer,a6
		tst.l	d2
		bne.s	.TagDa
.NoList:	movem.l	(a7)+,d0/d2/a6
		addq.l	#8,a7
		tst.l	8(a7)			;Liste ist leer
		rts

.TagDa:		move.l	#.UserReturn,16(a7)
		move.l	a6,12(a7)
		movem.l	(a7)+,d0/d2/a6
		rts

.UserReturn:	tst.l	8(a7)			;Z-Flag setzen (Liste da)
		rts


	*-----------------------------------------------------*
	*----------- Find-Tag Used Register d0/d2/a6 ---------*
	*-----------------------------------------------------*
UserFindTag:	move.l	d0,-(a7)
		jsr	A5GetMainWindowTags(a5)
		beq.s	.NoTags
		move.l	d0,a6
		move.l	(a7),d0
		bsr.b	FindTag2
.NoTags:	addq.l	#4,a7
		rts

FindTag:	move.l	PlayerAdr(a5),a6
		tst.l	PlayerAdrSample(a5)
		beq.s	FindTag2
		move.l	PlayerAdrSample(a5),a6
FindTag2:	move.l	d3,-(a7)
		move.l	a7,d3

	*--------- Recursive FindTag-Routine ----------*
FindTag3:	moveq	#0,d2
		cmp.l	a6,d2
		beq.s	.Empty
		move.l	(a6)+,d2			;Tag rauslesen
		bne.s	.NoEmpty
.Empty:		cmp.l	d3,a7				;ak. Stack vergleichen
		beq.s	.TagNoFound
		move.l	(a7)+,a6
		bra.b	.NoMore
.NoEmpty:	cmp.l	d2,d0
		beq.s	.TagFound

	*----- Tag-Skip gefunden ???? -----*
		cmp.l	#Tag_Skip,d2
		bne.s	.NoSkip
		addq.l	#8,a6				;Diesen und nchsten
		addq.l	#4,a6				;Tag berspringen
		bra.s	.NoMore

	*------ Tag-More gefunden ???? -----*
.NoSkip:	cmp.l	#Tag_More,d2
		bne.s	.NoMore

		move.l	a6,-(a7)		;Adr der Tagliste sichern
		move.l	(a6),a6			;Neue Tagliste setzen
		bra.b	FindTag3
.NoMore:	addq.l	#4,a6
		bra.s	FindTag3
.TagFound:	move.l	(a6),a6
		move.l	a6,d2
.TagNoFound:	move.l	d3,a7
		move.l	(a7)+,d3
		tst.l	d2
		bne.s	.NoNull
		sub.l	a6,a6
.NoNull:	tst.l	d2
		rts


*-----------------------------------------------------------------------------*
* Input:d0=Tag
*	a6=Taglist
* Output:d0/d1/a0/a1 Returnwerte
*	 Z-Flag -> TaskUser
*-----------------------------------------------------------------------------*
DeliCallUp:	move.l	PlayerAdr(a5),a6
DeliCallUp2:	movem.l	d0/a6,-(a7)
		move.l	#DTP_MsgPort,d0
		jsr	A5FindTag2(a5)
		bne.s	.DeliTask
		movem.l	(a7)+,d0/a6
		moveq	#0,d2
		rts



		*--- Message allokieren ---*
.DeliTask:	movem.l	(a7)+,d0/a6
		movem.l	d3/d4/a3/a4,-(a7)

		move.l	d2,a0
		move.l	(a0),d3
		beq.w	.Error			*MsgPort
		move.l	d0,d4

		jsr	A5FindTag2(a5)
		beq.w	.Error

		cmp.l	#EP_InitAmplifier,d0	*DT-Amplifier Emulation sonst
		beq.w	.SoStarten		*Endlos Schleife im Player
		cmp.l	#DTP_Interrupt,d0	*viel zu langsam
		beq.w	.SoStarten


		moveq	#DTMN_Size,d0
		jsr	A5AllocMem(a5)
		beq.s	.MemError
		move.l	d0,a1
		lea	EPReplayEnginePort,a3		*Replyport setzen
		move.l	a3,14(a1)
		move.w	#DTMN_Size,18(a1)


		move.l	d3,a0
		move.l	d2,DTMN_Function(a1)
		EXECBASE
		jsr	_LVOPutMsg(a6)


		*------ Auf ReplyMsg warten ------*
.WaitNochmal:	Execbase
		lea	EPReplayEnginePort,a3
		move.l	a3,a0
		jsr	_LVOWaitPort(a6)
		move.l	a3,a0
		jsr	_LVOGetMsg(a6)
		tst.l	d0
		beq.s	.WaitNochmal
		move.l	d0,a1
		cmp.w	#DTMN_Size,18(a1)
		beq.s	.MsgWiederDa
		jsr	A5EngineMessage(a5)
		bra.s	.WaitNochmal



.MsgWiederDa:	move.l	DTMN_Result(a1),-(a7)
		moveq	#DTMN_Size,d0
		Execbase
		jsr	_LVOFreeMem(a6)
		move.l	(a7)+,d0

		cmp.l	#EP_Get_ModuleInfo,d4
		beq.s	.JaA0
		cmp.l	#EP_StructInit,d4
		bne.s	.Nein
.JaA0:		move.l	d0,a0
.Nein:		movem.l	(a7)+,d4/d3/a3/a4
		tst.l	d2
		rts



.MemError:	moveq	#0,d2
		moveq	#EPR_NotEnoughMem,d0
	movem.l	(a7)+,d4/d3/a3/a4
		rts

.Error:		movem.l	(a7)+,d4/d3/a3/a4
		moveq	#0,d2
		moveq	#EPR_NotImplemented,d0		Flag !!
		rts

.SoStarten:	move.l	d2,a0
		move.l	a5,-(a7)
		jsr	(a0)	
		move.l	(a7)+,a5	*InitDeliNotePlayer
		movem.l	(a7)+,d4/d3/a3/a4
		moveq	#1,d2		*d0 wird gesetzt
		rts


	;************************
	;**** Check Soundsys ****
	;**** d0=Tag-Kennung ****
	;**** Check1/Check2  ****
	;************************
CheckSoundsys:	movem.l	d1-a4,-(a7)

	*-- Wird CheckSoundsystem zum ersten Mal aufgerufen ??? --*
		move.w	LoadPlayerSKenn(a5),d5		;alte Kennung laden
		move.l	LoadPlayerStart(a5),a4
		tst.l	LoadPlayerAdr(a5)
		bne.s	.CheckNow
		lea	EPG_FirstPlayerStruct(a5),a4

	*----- Erstaufruf von CheckSoundsys ------*

	cmp.l	#EP_Check5,d4
	bne.s	.l
	nop
.l
		moveq	#0,d5
.CheckNow:	bsr.s	.CheckPlayers
		beq.s	.OkReturn
		moveq	#-1,d5
		cmp.w	LoadPlayerSKenn(a5),d5
		beq.s	.OkReturn
		lea	EPG_FirstPlayerStruct(a5),a4
		bsr.b	.CheckPlayers
.OkReturn:	movem.l	(a7)+,d1-a4
		tst.l	d0
		rts

	move.w	EPPl_Flags(a4),d0		Pointer auf Tag-Struk
	nop
	nop

	;**** Nun wird auf die einzelnen Soundsystem gecheckt ****
.CheckPlayers:	move.w	d5,LoadPlayerSKenn(a5)
.NextPlayer:	move.l	EPPl_Next(a4),d0
		beq.s	.NoPlayer
		move.l	d0,a4

	cmp.l	#EP_Check5,d4
	bne.s	.l2
	move.l	EPPl_TagList(a4),d0		Pointer auf Tag-Struk
	cmp.l	#ST_Tagliste,d0
	bne.s	.l2
	nop
.l2
		btst	#EPPlF_Enabled,EPPl_Flags+1(a4)	;Test auf Enabled
		beq.s	.NextPlayer

	;* Testen ob derzeitiger Player checkErlaubnis (Internal-Player) hat *
		move.l	EPPl_TagList(a4),d0		Pointer auf Tag-Struk
		move.l	d0,a6
		beq.s	.NextPlayer
		move.l	#EP_Flags,d0
		jsr	A5FindTag2(a5)
		beq.s	.NoFlags
		move.l	a6,d0
		btst	#EPF_Disable,d0
		bne.s	.NextPlayer

.NoFlags:	move.l	EPPl_TagList(a4),a6		Pointer auf Tag-Struk
		move.l	#DTP_InternalPlayer,d0
		jsr	A5FindTag2(a5)
		beq.s	.NoInternal

	;**** Dieser Player ist intern, d3=0 --> Externe Player sind dran ****
		tst.l	d5
		beq.s	.NextPlayer
		bra.b	.CheckThis

	;*** Dieser Player ist extern, d3<>0 ---> Interne Player sind dran ***
.NoInternal:	tst.l	d5
		bne.s	.NextPlayer

	;**** Sprung zur Check-Routine ****
.CheckThis:	move.l	EPPl_TagList(a4),a6		Pointer auf Tag-Struk
		move.l	d4,d0
		*jsr	A5FindTag2(a5)
		*beq.s	.NextPlayer
		*moveq	#-1,d3
		*jsr	A5CallUp2(a5)			;Sprung zur Check-Rout
		moveq	#-1,d3
		jsr	A5CallUp3(a5)
		beq.s	.NextPlayer
		jsr	A5ClearCache(a5)
		tst.l	d0
		bne.b	.NextPlayer
		move.l	EPPl_TagList(a4),a6		;Pointer auf Tag-Struk
		move.w	d5,LoadPlayerSKenn(a5)		;Kenn (Internal/custom)
		move.l	a4,LoadPlayerStart(a5)		;beim nchsten Check
		moveq	#0,d0				;hier weiter machen
		rts
.NoPlayer:	moveq	#1,d0
		rts

	*--------------- Alloc Audiokanle ---------------*
RetryAlloc:	jsr	A5ClearMouse(a5)
		moveq	#EPR_CantAllocAudio,d7				;Default Cancel

	*----- AudioChannels nochmal versuchen zu allokieren ----*
.Retry:		LA0	LNr_TR_AudioAlloc
		move.l	a0,EPG_Arg1(a5)
		lea	PubScreenName(a5),a0
		move.l	a0,EPG_Arg2(a5)
		clr.l	EPG_Arg3(a5)
		subq.l	#1,EPG_Arg3(a5)
		LA0	LNr_GA_Yes
		move.l	a0,EPG_Arg4(a5)
		clr.l	EPG_Arg5(a5)
		clr.l	EPG_Arg6(a5)
		clr.l	EPG_Arg8(a5)
		moveq	#-1,d0
		move.l	d0,EPG_Arg7(a5)
		moveq	#7,d0
		move.l	d0,EPG_ArgN(a5)
		jsr	A5TextRequest(a5)
		beq.s	.Fehler

	*-------------- Nochmal versuchen -----------*
		bsr.b	AllocAudio2
		bne.s	.Retry
		move.l	d0,d7

.Fehler:	move.l	d7,d0				;Fehler
		tst.l	d0
		rts


	*--------- Versuch die Audio-Channells zu Allocieren --------*
AllocAudio2:	moveq	#0,d0
		tst.b	AudioOn(a5)
		bne.b	AReturn
		clr.b	AudioEnabled(a5)
		LA0	LNr_AudioName
		lea	IORequest,a1
		moveq	#0,d0
		moveq	#0,d1
		ExecBase
		jsr	_LVOOpenDevice(a6)
		tst.l	d0
		bne.b	AReturn
		not.b	AudioOn(a5)
		move.b	#1,AudioEnabled(a5)
AReturn:	tst.l	d0
		rts

*------------------------ Eagleplayer-Subroutine Alloc-Audio ---------------*
* Input: --
* Output: d0=Fehler oder NULL
AllocAudio:	movem.l	d1-a6,-(a7)
		move.l	PufferAdr(pc),a5

	*	sub.l	a1,a1
	*	Execbase
	*	jsr	_LVOFindTask(a6)
	*	move.l	d0,d1
		moveq	#0,d0

	*	cmp.l	MyTaskAdr(a5),d1
	*	bne.s	.Return

	* [][] AudioKanle bei Amplifier nicht allokieren
		tst.l	EPG_ActiveAmplifier(a5)
		bne.s	.Return

		tst.b	OnAllocChannels(a5)
		bne.s	.AllocIt
		move.b	#1,AudioEnabled(a5)
		bra.s	.Return


.AllocIt:	bsr.s	AllocAudio2
		beq.s	.Return
		bsr.w	RetryAlloc
.Return:	movem.l	(a7)+,d1-a6
		rts




*------------------ Alloc Amigaaudio (Amplifier-Subroutine -----------------*
* Input: --
* Output: d0=Fehler oder NULL
EPP_AllocAmigaAudio:
		movem.l	d1-a6,-(a7)
		move.l	PufferAdr(pc),a5
		moveq	#0,d0
		tst.b	OnAllocChannels(a5)
		beq.s	.Return
.AllocIt:	bsr.s	AllocAudio2
		beq.s	.Return
		bsr.w	RetryAlloc
.Return		movem.l	(a7)+,d1-a6
		rts


*------------------------- Free Audiokanle --------------------------------*
* Input: --
* Output: --
EPP_FreeAmigaAudio:
FreeAudio:	movem.l	d0-a6,-(a7)
		move.l	PufferAdr(pc),a5

	*	sub.l	a1,a1
	*	Execbase
	*	jsr	_LVOFindTask(a6)

	*	cmp.l	MyTaskAdr(a5),d0
	*	bne.s	.Return


	* [][] AudioKanle bei Amplifier nicht allokieren
	* ---- > freigeben kann man aber trotzdem !!!
		*tst.l	EPG_ActiveAmplifier(A5)
		*bne.s	.Return

		tst.b	AudioOn(a5)
		beq.b	.Return
	;	bclr	#1,$bfe001
		clr.b	AudioOn(a5)
		lea	IORequest,a1
		ExecBase
		jsr	_LVOCloseDevice(a6)
.Return:	clr.b	AudioEnabled(a5)
		movem.l	(a7)+,d0-a6
		rts



	;**********************************
	;**** Timer-Interrupt (Player) ****
	;**********************************
TimerProgramm:	movem.l	d1-a6,-(a7)
		move.l	PufferAdr(pc),a5

		tst.b	ForceSoftInt(A5)
		bne.s	.dosoft

		tst.b	OnSoftInt(a5)
		beq.s	NoSoftProgramm
.dosoft
		addq.b	#1,numsofts(a5)	;Anzahl, wie oft der Interrupt
					;schon autrat,bevor der Softint
					;zur Ausfhrung gelangt (z.B. MED)
					;".b" sollte eigentlich langen, sonst
					;hat`s eh keinen Sinn mehr....
		lea	SoftInterrupt,a1
		ExecBase
		jsr	_LVOCause(a6)
		movem.l	(a7)+,d1-a6
		moveq	#0,d0
		rts

	;**********************************
	;**** Timer-Interrupt (Player) ****
	;**********************************
SoftProgramm:
		move.l	a5,-(sp)
		move.l	PufferAdr(pc),a5
.lop
		bsr.s	.softprog
		subq.b	#1,numsofts(a5)
		bgt.s	.lop
		clr.b	numsofts(A5)	;nur zur Sicherheit
		move.l	(sp)+,a5
		rts
.SoftProg
		movem.l	d1-a6,-(a7)
NoSoftProgramm:	moveq	#0,d0
		moveq	#0,d1
		moveq	#0,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		moveq	#0,d6
		moveq	#0,d7
		move.l	MusicAdr(pc),a0
		cmp.l	a0,d0
		beq.s	.NoJsr
		pea	.NoJsr(pc)
		pea	(a0)
		sub.l	a0,a0
		sub.l	a1,a1
		sub.l	a2,a2
		sub.l	a3,a3
		sub.l	a4,a4
		sub.l	a5,a5
		sub.l	a6,a6
		rts

.NoJSR:		movem.l	(a7)+,d1-a6
		moveq	#0,d0
		rts

MusicAdr:	dc.l	0				;Adresse fr Interrupt

	;**************************
	;**** Fehler-Meldungen ****
	;**************************
ErrNoModule:	moveq	#EPR_NoModuleLoaded,d0
		rts
ErrAllocTimer:	jsr	A5FreeAudio(a5)
		moveq	#EPR_CantAllocCia,d0
		rts

**-----------------------------------------------------------------------------*
**------------------------- Userprogramm-GetListData --------------------------*
**-----------------------------------------------------------------------------*
*KM_GetListData:	movem.l	d1-a6,-(Sp)
*		sub.l	a4,a4
*		moveq	#EPR_NoModuleLoaded,d7
*		tst.l	PlayerAdr(a5)
*		beq.w	.Return
*
*	*------- Argumentstruktur initialisieren -------*
*		moveq	#EPR_NotEnoughMem,d7
*		moveq	#EPT_String+Namenlange,d0
*		ExecBase
*		move.l	#$10001,d1
*		jsr	_LVOAllocmem(A6)
*		tst.l	d0
*		beq	.Return
*
*	*--- Hauptfile in spezieller Struktur bergeben ---*
*		move.l	d0,a2
*		move.l	d0,a4
*		move.l	#EPT_String+Namenlange,EPT_Stringsize(a2)
*		clr.l	EPT_Next(a2)
*		move.l	MDPuffer(a5),EPT_Result1(a2)		;Arg1 (Adr)
*		move.l	MDPuffer+4(a5),EPT_Result2(a2)		;Arg2 (Size)
*
*	*----------- den Filenamen bergeben --------------*
*	* Auf jeden fall sollte eine Kennung bergeben	   *
*	* werden, durch die erkannt wird, welcher Replayer *
*	* genutzt wird. Der entsprechende Player wird dann *
*	* geladen !!					   *
*	****************************************************
*		moveq	#31,d1
*		lea	TitlenamePuffer(a5),a0
*		lea	EPT_String(a2),a1
*		jsr	A5StringCopy2(a5)
*
*
*	*-- Nun die Argumentenstrukturen fr EXTLoading fllen --*
*		move.l	a4,a2
*		lea	MDPuffer(a5),a3
*		move.l	MDNummer(a5),d6
*		subq.l	#2,d6
*		blo.s	.NoExtLoading
*
*	*---- Speicher fr nchste Argumentstruktur besorgen ----*
*.Fill:		ExecBase
*		move.l	#EPT_String,d0
*		move.l	#$10001,d1
*		jsr	_LVOAllocMem(a6)
*		move.l	d0,a1
*		tst.l	d0
*		beq.w	.OutOfMem
*
*	*----------- nchste Argumentstruktur fllen ------------*
*		move.l	d0,(a2)
*		move.l	d0,a2
*		addq.l	#8,a3
*		move.l	(a3),EPT_Result1(a1)
*		move.l	4(a3),EPT_Result2(a1)
*		move.l	#EPT_String,EPT_StringSize(a1)
*		dbf	d6,.Fill
*
*.NoExtLoading:	moveq	#0,d7			;Kein Error
*.Return:	move.l	a4,UPrg_ReturnStruct(a5)
*		move.l	d7,d0
*		movem.l	(sp)+,d1-a6
*		tst.l	d0
*		rts
*
*
*	*-- Anderen Argumentstrukturen freigeben --*
*.OutOfMem:	move.l	EPT_String(a4),d0
*		move.l	a4,a1
*		move.l	(a4),a4
*		ExecBase
*		jsr	_LVOFreeMem(a6)
*		moveq	#0,d0
*		cmp.l	d0,a4
*		bne.s	.OutOfMem
*		sub.l	a4,a4
*		bra.s	.Return
*
*
*

	;*******************************************
	;**** <- d0=Nummmer des geladenen Files ****
	;**** -> a0=Adr des Files,d0=Size 0=Err ****
	;*******************************************
GetListData:	movem.l	d1/a1/a5,-(a7)
		move.l	PufferAdr(pc),a5
		moveq	#0,d1
		move.l	d1,a0
		cmp.l	MDNummer(a5),d0
		bgt.s	.Error
		lea	MDPuffer(a5),a0
		asl.l	#4,d0
		add.l	d0,a0
		move.l	(a0)+,a1
		move.l	(a0)+,d1
.Error		move.l	d1,d0
		move.l	a1,a0
		movem.l	(a7)+,a5/a1/d1
		rts

	;*******************************************
	;**** <- d0=Nummmer des geladenen Files ****
	;**** -> a0=Adr des Files,d0=Size 0=Err ****
	;*******************************************
GetLoadListData:movem.l	d1/a1/a5,-(a7)
		move.l	PufferAdr(pc),a5
		moveq	#0,d1
		move.l	d1,a0
		cmp.l	LFNummer(a5),d0
		bgt.s	.Error
		lea	LFPuffer(a5),a0
		asl.l	#4,d0
		add.l	d0,a0
		move.l	(a0)+,a1
		move.l	(a0)+,d1
.Error		move.l	d1,d0
		move.l	a1,a0
		movem.l	(a7)+,a5/a1/d1
		rts

*-----------------------------------------------------------------------------*
* Input: d0=Filesize
*	 a0=FilePtr
*	 d1=Memsize	\ nur, wenn beim rippen neuer Speicherbereich allokiert
*	 a1=Memptr	/ wird
* Output:d0=Error oder NULL
SetListData:	movem.l	d1-a6,-(a7)
		moveq	#EPR_Bufferfull,d7
		move.l	PufferAdr(pc),a5
		move.l	LFNummer(a5),d2
		cmp.l	#MaxLoadFiles,d2
		bge.s	.Return
		lea	LFPuffer(a5),a2
		asl.l	#4,d2
		add.l	d2,a2

		move.l	a0,(a2)+
		move.l	d0,(a2)+
		move.l	a1,(a2)+
		move.l	d1,(a2)+
		addq.l	#1,LFNummer(a5)
		moveq	#0,d7

.Return:	move.l	d7,d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: d0=Def Type
* Output:d0=current Type
*	 a0=Outputmessage for Errorrequest
*-----------------------------------------------------------------------------*
GetHardwareType:movem.l	d1-d7/a1-a6,-(a7)
		move.l	PufferAdr(pc),a5
		move.l	d0,d2
		LA1	EPR_AmigaNeeded
		moveq	#EPHT_Amiga,d0
		tst.b	DracoOn(a5)
		beq.s	.TypeOk
		LA1	EPR_DracoNeeded
		moveq	#EPHT_Draco,d0
.TypeOk:	sub.l	a0,a0
		cmp.l	d0,d2
		beq.s	.Return
		move.l	a1,a0
.Return:	movem.l	(a7)+,d1-d7/a1-a6
		tst.l	d0
		rts

	*-------------------------------------------------------------*
	*- interne Subfunktion fr Delitracker.Player (DTG_SetTimer) -*
	*-------------------------------------------------------------*
SetTimer2:	movem.l	d0-a6,-(a7)
		move.l	PufferAdr(pc),a5
		jsr	A5SetTimer(a5)
		movem.l	(a7)+,d0-a6
		rts

	;**** Global-Routine, ab Delitracker V1.37 und Eagleplayer V?.?? ****
	;**** wird von den internen Trackern benutzt ****
DTWaitAudioDMA:	movem.l	d0-a6,-(sp)
		move.l	PufferAdr(pc),a5
		move.b	WaitingMode(a5),d1
		beq.s	.AutomaticWait
		move.l	RasterLines(a5),d0
		subq.w	#1,d0
		cmp.w	#MaxRasterLines-1,d0
		blo.s	.RasterOk
		move.w	#MaxRasterLines-1,d0
.RasterOk:	subq.w	#1,d1
		beq.s	.WaitLines

	*--------- DMA-Wait eingestellt ---------*
		move.l	DBFLoops(a5),d0
		bhi.s	.hi1
		move.l	#300,d0
.hi1
		cmp.l	#MaxDBFLoops,d0
		blo.s	.Wait
		move.l	#MaxDBFLoops,d0

.Wait:		subq.l	#1,d0
		bne.s	.Wait
		bra.s	.WaitEnd

	*---------- Automatic-Wait --------------*
.AutomaticWait:	ExecBase			;Exec
		move.w	296(a6),d1		;Attn Flags

		moveq	#3,d0
		and.w	#3,d1			;68020 Prozessor ?
		beq.s	.WaitLines		;n, Warte 4 Zeilen, reicht fr 68000

		moveq	#DefaultRasterLines-1,d0
		tst.b	TimerOn(a5)
		beq.s	.WaitLines

		tst.b	TimerFremd(a5)	;eigener Timer ?
		bne.s	.WaitLines	;nein,also wieder mal eine Warteroutine
					;nach dem Stile wie immer (weil wir ja
					;nicht wissen, ob der Timer an oder aus
					;ist)
		cmp.b	#EPNrT_CiaTiming,TimingMode(a5)	;Cia-Timer ist nicht allokiert !!!
		bne.s	.WaitLines

		moveq	#25-1,d3	;0,35 Zeilen pro Wartezyklus,entspricht
.Wait_CIA_1:	move.b	$bfd400,d1	;hier also 8-9 Zeilen im 15 KHz Modus !
		and.b	#$f0,d1
.Wait_CIA_2:	move.b	$bfd400,d0
		and.b	#$f0,d0
		cmp.b	d0,d1
		beq.s	.Wait_CIA_2
		dbf	d3,.Wait_CIA_1
		bra.s	.waitend

*------- 8 Zeilen warten (wie sonst auch), reicht bei 68030 allemal -------*
.WaitLines:	move.b	$dff006,d1
.WaitLines2:	cmp.b	$dff006,d1
		beq.s	.WaitLines2
		dbf	d0,.WaitLines

.Waitend:	movem.l	(sp)+,d0-a6
		rts	



;**** LoadFileBytes Bit0=Soll gecheckt werden
;****		    Bit1=Soll Was ins Fenster geprintet werden
;****		    Bit2=Soll SubLFNummer erhht werden
;**** LoadFileMem   = MemEigenschaften 

*----------------------------- New LoadFile ----------------------------*
*---- Input	ARG1 = MemEigenschaften					*
*----		Path = DTG_PathArrayPtr					*
*---- OutPut	D0   = Fehler						*
*-----------------------------------------------------------------------*
EPP_NewLoadFile:movem.l	d1-a6,-(a7)
		move.l	PufferAdr(pc),a5
		moveq	#1,d0
		cmp.l	EPG_ArgN(a5),d0
		bne.w	NotEnoughArguments
		move.l	EPG_Arg1(a5),d0
;		beq.w	ErrorInArguments
		clr.l	EPG_ArgN(a5)
		clr.l	EPG_Arg1(a5)
		bra.b	EPP_NewLoad2

	*------------------- Ldt File ----------------------*
DTLoadFile:	movem.l	d1-a6,-(a7)
		move.l	PufferAdr(pc),a5
		moveq	#2,d0
EPP_NewLoad2:	bsr.w	CutSuffix
		tst.b	PlayMemory(a5)
		bne.w	SIMU_ExtLoad
		tst.l	RippStruct(a5)
		bne.w	.TestExtRipper

		move.l	d0,LoadFileMem(a5)
		move.b	#3,LoadFileBytes(a5)
		move.l	DTG_PathArrayPtr(a5),LoadFilePath(a5)
		move.l	DTG_PathArrayPtr(a5),a0

	move.l	LoadFileName(a5),-(a7)
	movem.l	d0/a0,-(a7)
	move.l	a0,a1
	jsr	A5GetFileName(a5)
	move.l	a1,ScrollArgs(a5)
	move.l	a1,LoadFileName(a5)
	LA0	LNr_Loading
	jsr	A5PrintText(a5)
	movem.l	(a7)+,d0/a0


		jsr	A5LoadFile2(a5)
	move.l	(a7)+,LoadFileName(a5)
		tst.l	d0
		beq.s	.Ende

		bsr.w	CheckLoadError
		bne.s	.Ende			;nicht behebbarer Error

	*---- Silben nacheinander wegkrzen, dann laden ----*
		lea	SilbenTab(pc),a2
		move.l	a2,a3
		moveq	#-1,d0			;unmglicher Fehler
.NextSilbe:	bsr.w	CheckLoadError
		bne.s	.Ende			;nicht behebbarer Error
		bsr.w	CutSuffix
		moveq	#-1,d0
		move.w	(a2)+,d0
		beq.s	.Error
		lea	(a3,d0.w),a0
		bsr	CopyString
		movem.l	a2/a3,-(a7)
		jsr	A5LoadFile2(a5)
		movem.l	(a7)+,a2/a3
		tst.l	d0
		bne.s	.NextSilbe
.Ende:		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

.Error:		moveq	#EPR_FileNotFound,d0
		bra.s	.Ende

.TestExtRipper:	move.l	LFNummer(a5),d0
		cmp.l	#1,d0
		ble.s	.Error
		moveq	#0,d0
		bra.s	.Ende

	*---- Testet, ob bei LoadFile ein Fehler aufgetreten ist, ----*
	*---- bei dem es sich nicht lohnt weiterzuladen		  ----*
CheckLoadError:	movem.l	d1-a6,-(a7)
		lea	.InterneErrors(pc),a0
		bsr.b	.TestIt
		bne.s	.ErrorFound
		move.l	LastLoadError(a5),d0
		lea	.DosErrors(pc),a0
		bsr.b	.TestIt
.ErrorFound:	move.l	d1,d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

.TestIt:	moveq	#0,d1
		move.w	(a0)+,d1
		beq.s	.NotFound
		cmp.l	d0,d1
		bne.s	.TestIt
.NotFound:	tst.l	d1
		rts

	*---- Fehlermeldungen, bei denen ein neues Laden unsinnig ist ----*
.InterneErrors:	dc.w	EPR_NotEnoughMem,EPR_CorruptModule,EPR_ErrorDecrunching
		dc.w	EPR_LoadError,EPR_XPKError,EPR_XPKMasterNotFound
		dc.w	EPR_ModuleTooShort,EPR_PPNotFound,EPR_LHNotFound
		dc.w	EPR_ErrorLoadingInstruments,EPR_FunctionNotEnabled
		dc.w	EPR_Passwordfailed,EPR_NotImplemented
		dc.w	EPR_NeedHigherKickstart,EPR_CrmNotFound
		dc.w	EPR_ExtractorNotFound,EPR_ErrorInArchive
		dc.w	EPR_NoAmplifier,EPR_FatalError,EPR_LibraryNotFound,0

	*----- Fehlermeldungen, bei denen ein neues Laden unsinnig ist ----*
.DosErrors:	dc.w	103,202,204,210,212,213,218,219,224,226,0

SilbenTab:	dc.w	PointPP-SilbenTab
		dc.w	PointIm-SilbenTab
		dc.w	PointLH-SilbenTab
		dc.w	PointSTC-SilbenTab
		dc.w	PointXPK-SilbenTab
		dc.w	PointCRM-SilbenTab
		dc.w	PointPack-SilbenTab
		dc.w	0 ;Wichtig (Kennung fr CutSuffix)
PointPP:	dc.b	".pp",0
PointIm:	dc.b	".im",0
PointLH:	dc.b	".lh",0
PointSTC:	dc.b	".stc",0
PointCRM:	dc.b	".crm",0
PointXPK:	dc.b	".xpk",0
PointPack:	dc.b	".pack",0
		even


*---------------------------------------------------------------------------*
*-------------- Es wird ein Module aus dem Memory abgespielt ---------------*
*---------------------------------------------------------------------------*
SIMU_ExtLoad:	moveq	#EPR_ErrorInArguments,d7
		move.l	d0,d6				;MemEigenschaften

	*----- Schleife zum Simulieren von EXTLoading -----*
*
	*lea	LFPuffer-8(a5),a3
	lea	LFPuffer-16(a5),a3
		move.l	LFNummer(a5),d1
;		subq.l	#1,d1
;		blo.s	.Return
		lea	UPrg_Struct(a5),a4
.FindLast:	lea	16(a3),a3
		*addq.l	#8,a3
		move.l	(a4),d0
		beq.s	.Return
		move.l	d0,a4
		dbf	d1,.FindLast

	*-------- Speicher allocieren und copieren --------*
		moveq	#EPR_NotEnoughMem,d7
		move.l	EPT_Result2(a4),d0
		move.l	d6,d1				;Memeigenschaften
		jsr	A5AllocMem2(a5)
		beq.s	.Return
		move.l	d0,(a3)				;LFPuffer
		move.l	d0,8(a3)			;LFPuffer
		move.l	EPT_Result2(a4),4(a3)		;LFPufferSize
		move.l	EPT_Result2(a4),12(a3)		;LFPufferSize

		move.l	EPT_Result1(a4),a0
		move.l	d0,a1
		move.l	EPT_Result2(a4),d0
		ExecBase
		jsr	_LVOCopyMem(a6)		;lieber lassen !!!
		moveq	#0,d7

		addq.l	#1,LFNummer(a5)
*

	*-------- Return to Eagleplayer ---------*
.Return:	move.l	d7,d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts





	;**** Kopiert angewhlten Filename an das Ende des Strings in ****
	;**** PathArray ****
CopySaveFile:	movem.l	d0/d1/a0/a1/a5,-(a7)
		lea	SaveFilePuffer(a5),a0
		bra.b	CopyFile2

* EP-Einsprung *
EPP_CopyFile:	movem.l	d0/d1/a0/a1/a5,-(a7)
		move.l	PufferAdr(pc),a5
		move.l	DTG_FileArrayPtr(a5),a0
		tst.b	LHALoaded(a5)
		beq.s	CopyFile1_2
		lea	ArexxPuffer+1000(a5),a1
		move.l	a1,a0
		bra.s	CopyFile2
		
* DT-Einsprung *
CopyFile:	movem.l	d0/d1/a0/a1/a5,-(a7)
		move.l	PufferAdr(pc),a5
CopyFile1_2:	move.l	DTG_FileArrayPtr(a5),a0
CopyFile2:	move.l	PufferAdr(pc),a5
		move.l	DTG_PathArrayPtr(a5),a1
.NextB		tst.b	(a1)+
		bne.s	.NextB
		subq.l	#1,a1
		cmp.b	#":",-1(a1)
		beq.s	.OK
		cmp.b	#"/",-1(a1)
		beq.s	.OK
		move.b	#"/",(a1)+
		clr.b	(a1)
.Ok:		moveq	#Namenlange-2,d1
		jsr	A5StringCopy2(a5)
		clr.b	(a1)
		movem.l	(a7)+,d0/d1/a0/a1/a5
		rts
		
	*-- Copiert das DIR des angewhlten Files nach Ende von PathArray --*
CopySaveDir	movem.l	d0/d1/a0/a1/a5,-(a7)
		lea	SaveDirPuffer(a5),a0
		bra.b	CopyDir2

*EP-Einsprung
EPP_CopyDir:	movem.l	d0/d1/a0/a1/a5,-(a7)
		move.l	PufferAdr(pc),a5
		move.l	DTG_DirArrayPtr(a5),a0
		tst.b	LHALoaded(a5)
		beq.s	CopyDir2
		LA0	LNr_TName
		bra.s	CopyDir2



*DT-Einsprung
CopyDir:	movem.l	d0/d1/a0/a1/a5,-(a7)
		move.l	PufferAdr(pc),a5
		move.l	DTG_DirArrayPtr(a5),a0
CopyDir2:	move.l	PufferAdr(pc),a5
		move.l	DTG_PathArrayPtr(a5),a1
		clr.b	(a1)
		tst.b	(a0)
		beq.s	.OK
		move.w	#PathPufferSize-2,d1
		jsr	A5StringCopy2(a5)
		cmp.b	#":",-1(a1)
		beq.s	.OK
		cmp.b	#"/",-1(a1)
		beq.s	.OK
		move.b	#"/",(a1)+
.Ok		clr.b	(a1)
		movem.l	(a7)+,d0/d1/a0/a1/a5
		rts

*---------------------------------------------------------------------------*
*------------------------- 	Pfad aufbauen	----------------------------*
*-----	LoadFilePath=Diradresse						----*
*-----	a2=Filename							----*
*---------------------------------------------------------------------------*

*--------------- Copiert String ans Ende von DTG_Path-Array -----------------*
CopyString:	movem.l	d0-a6,-(a7)
		move.l	PufferAdr(pc),a5

		move.l	DTG_PathArrayPtr(a5),a1
.NextB		tst.b	(a1)+
		bne.s	.NextB
		subq.l	#1,a1
		move.w	#PathPufferSize-2,d1
		jsr	A5StringCopy2(a5)

		movem.l	(a7)+,d0-a6
		rts





*------ Entfernt am Ende des Strings der in Path-Array Steht ggf ".pp" -------*
CutSuffix:	movem.l	d0-a6,-(a7)
		move.l	PufferAdr(pc),a5

	*------ .PP wegkrzen ------*
		lea	SilbenTab(pc),a2
		move.l	a2,a3
.NextSilbe:	move.w	(a2)+,d0
		beq.s	.Ende
		lea	(a3,d0.w),a0
		bsr.w	.CutIt
		bne.s	.NextSilbe
.Ende:		movem.l	(a7)+,d0-a6
		rts

	;**** SubProgramm fr CutSuffix ****
.CutIt:		move.l	DTG_PathArrayPtr(a5),a1
.NextB1:	tst.b	(a1)+
		bne.s	.NextB1

.NextB2:	tst.b	(a0)+
		bne.s	.NextB2

		subq.l	#1,a0
		subq.l	#1,a1
.NextTest:	move.b	-(a0),d0
		beq.s	.EndungFound
		cmp.b	-(a1),d0
		beq.s	.NextTest
		moveq	#1,d0
		rts
.EndungFound:	clr.b	(a1)			;Endung krzen
		moveq	#0,d0
		rts
		

*-------------------- Entcodiere das gesammte KeyFile --------------------*
Key_EndC:	moveq	#0,d4
		move.l	a2,d3
		subq.l	#1,d0
		move.l	d0,d2
		move.l	d0,d1
.DecodeIt:	moveq	#0,d0
		move.b	(a0)+,d0
		jsr	A5DecodeD02(a5)
		add.w	d0,d4
		move.b	d0,(a2)+
		dbf	d1,.DecodeIt
		rts


*----------------------------------------------------------------------------*
*------------------------------- DTG_SongEnd -------------------------------*
*----------------------------------------------------------------------------*
DT_SongEnd:	movem.l	d0-a6,-(a7)
		move.l	PufferAdr(pc),a5
		tst.b	OnSongEnd(a5)
		beq.s	.NoOn

		tst.b	SongEndVerbot(a5)
		bne.s	.NoOn


		move.l	SongEndBits(a5),d1
		moveq	#0,d0
		bset	d1,d0

		ExecBase
		move.l	MyTaskAdr(a5),a1
		jsr	_LVOSignal(a6)

		move.b	#1,SongEndNow(a5)
.NoOn:		movem.l	(a7)+,d0-a6
		rts


*----------------------------------------------------------------------------*
*------------------------- Jump Tab fr PufferUmbau -------------------------*
*----------------------------------------------------------------------------*
JumpTab:	dc.l	GetListData-JumpReturn
		dc.l	DTLoadFile-JumpReturn
		dc.l	CopyDir-JumpReturn
		dc.l	CopyFile-JumpReturn
		dc.l	CopyString-JumpReturn
		dc.l	AllocAudio-JumpReturn
		dc.l	FreeAudio-JumpReturn
		dc.l	StartInterrupt-JumpReturn
		dc.l	StopInterrupt-JumpReturn
		dc.l	DT_SongEnd-JumpReturn
		dc.l	CutSuffix-JumpReturn
		dc.l	SetTimer2-JumpReturn
		dc.l	DTWaitAudioDMA-JumpReturn
		dc.l	DT_LockScreen-JumpReturn
		dc.l	DT_UnLockScreen-JumpReturn

	*--------- EaglePlayer-Globals --------*
		dc.l	DT_NotePlayer-JumpReturn
		dc.l	DT_AllocListData-JumpReturn
		dc.l	DT_FreeListData-JumpReturn
		dc.l	EPP_SaveMem-JumpReturn	;Save Mem to Disk  (Don`t use)
		dc.l	EPP_FileReq-JumpReturn	;FileRequester     (Don`t use)
		dc.l	EPP_TextRequest-JumpReturn		   (Don`t use)
		dc.l	EPP_LoadExecutable-JumpReturn ;Load % Decrunch   (Don`t use)
		dc.l	EPP_NewLoadFile-JumpReturn	;new DTG_LoadFile with Parameters
		dc.l	EPP_ScrollText-JumpReturn	;Scroll Text
		dc.l	EPP_LoadPlConfig-JumpReturn	;Loads a Config from Env:Eagleplayer/..
		dc.l	EPP_SavePlConfig-JumpReturn	;Saves a Config to EnvArc:Eagleplayer/..
		dc.l	EPP_FindTag-JumpReturn		;Finds a Tag
		dc.l	EPP_FindAuthor-JumpReturn	;Find Author

		dc.l	EPP_Hexdez-JumpReturn		;Convert Dual to Dezimal (Ascii)
		dc.l	PrintText-JumpReturn		;Print Text into the Mainwindow
		dc.l	EPP_ModuleChange-Jumpreturn	;Change Playroutine in Module
		dc.l	EPP_ModuleRestore-JumpReturn	;Restore Playroutine in Module

		dc.l	0			;EPG_FTPRReserved8

JumpTabSize	= (*-JumpTab)/4-1

*-----------------------------------------------------------------------------*
* Input: --
* Output:d0=Screenadr oder NULL
DT_LockScreen:	movem.l	d1-a6,-(a7)
		move.l	PufferAdr(pc),a5
		move.l	PlayerPubScreen(a5),d2
		bne.s	.NoNewAlloc
		move.l	EPG_PubScreen(a5),a0
		move.l	DTG_IntuitionBase(a5),a6
		jsr	_LVOLockPubScreen(a6)
		move.l	d0,d2
		bne.s	.ScreenDa
		suba.l	a0,a0
		move.l	DTG_IntuitionBase(a5),a6
		jsr	_LVOLockPubScreen(a6)
		move.l	d0,d2
		beq.s	.PubScreenOk
.ScreenDa:	move.l	d2,PlayerPubScreen(a5)
		move.l	d2,a0
		sub.l	a1,a1
		move.l	DTG_GadToolsBase(a5),a6
		jsr	_LVOGetVisualInfoA(a6)
		move.l	d0,PlayerVisualInfo(a5)
		tst.l	d0
		beq.s	DT_KeinVisualInfo
.NoNewAlloc:	addq.l	#1,PlayerScreenZahler(a5)
.PubScreenOk:	move.l	d2,d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
DT_UnLockScreen:movem.l	d1-a6,-(a7)
		move.l	PufferAdr(pc),a6
		move.l	PlayerPubScreen(a5),d2
		beq.s	DT_KeinScreen
		subq.l	#1,PlayerScreenZahler(a5)
		bne.s	DT_KeinScreen
		move.l	PlayerVisualInfo(a5),d0
		beq.s	DT_KeinVisualInfo
		move.l	d0,a0
		move.l	DTG_GadToolsBase(a5),a6
		jsr	_LVOFreeVisualInfo(a6)
		clr.l	PlayerVisualInfo(a5)
DT_KeinVisualInfo:sub.l	a0,a0
		move.l	d2,a1
		move.l	DTG_IntuitionBase(a5),a6
		jsr	_LVOUnlockPubScreen(a6)
		clr.l	PlayerPubScreen(a5)
DT_KeinScreen:	movem.l	(a7)+,d1-a6
		moveq	#0,d0
		rts



EPP_LoadPlConfig:
EPP_SavePlConfig:


		*--- Requester ffnen ---*
IllegalFunction:movem.l	d1-a6,-(a7)
		move.l	PufferAdr(pc),a5
		LA0	LNr_TR_IllegalFunction
		move.l	a0,EPG_Arg1(a5)
		lea	PubScreenName(a5),a0
		move.l	a0,EPG_Arg2(a5)
		clr.l	EPG_Arg3(a5)
		subq.l	#1,EPG_Arg3(a5)
		LA0	LNr_GA_Ok
		move.l	a0,EPG_Arg4(a5)
		clr.l	EPG_Arg5(a5)
		clr.l	EPG_Arg6(a5)
		move.l	#EPTRB_Center,EPG_Arg8(a5)
		moveq	#-1,d0
		move.l	d0,EPG_Arg7(a5)
		moveq	#7,d0
		move.l	d0,EPG_ArgN(a5)
		jsr	A5TextRequest(a5)
		sub.l	a0,a0				*Zur Sicherheit
		movem.l	(a7)+,d1-a6
		moveq	#EPR_FunctionAborted,d0
		rts

*-----------------------------------------------------------------------------*
* Diese Function allokiert Speicher (wie angegeben) und fgt diesen in die    *
* Liste fr GetListData ein. Der Speicher wird mit FreeListData wieder freige *
* geben.
*-----------------------------------------------------------------------------*
* Input: d0=Speichersize
*	 d1=Speicheranforderungen
* Outout:d0=Memadr oder ZERO
*-----------------------------------------------------------------------------*
DT_AllocListData:
		movem.l	d1-a6,-(a7)
		lea	LFPuffer(a5),a2
* if Betaversion
*	movem.l	d0-a6,-(a7)
*	lea	Addlist.msg(pc),a0
*	bsr	textreq
*	movem.l	(a7)+,d0-a6
* endc
		move.l	d0,d2
		move.l	PufferAdr(pc),a5
		jsr	A5AllocMem(a5)
		beq.s	.Return
		moveq	#0,d1
		exg	d0,d1

		*cmp.l	#MaxLoadFiles-1,MDNummer(a5)
		cmp.l	#MaxLoadFiles-1,MDNummer-MDPuffer(a2)
		bhi.w	.Return

		*move.l	MDNummer(a5),d0
		move.l	MDNummer-MDPuffer(a2),d0
		*addq.l	#1,d0
		*lea	MDPuffer(a5),a0
		lea	(a2),a0
		rol.l	#4,d0
		add.l	d0,a0
		move.l	d1,(a0)+			; usesize
		move.l	d2,(a0)+			;
		move.l	d1,(a0)+			; allocsize *Adr
		move.l	d2,(a0)+			;	    *Size
		
		*addq.l	#1,MDNummer(a5)
		addq.l	#1,MDNummer-MDPuffer(a2)
		move.l	d1,d0

.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


 if betaversion
textreq:
	move.l	a0,EPG_ARG1(a5)
	move.l	d0,Args
	move.l	#pubscreen,EPG_Arg2(a5)
	clr.l	EPG_Arg3(a5)
	clr.l	EPG_Arg4(a5)
	clr.l	EPG_Arg5(a5)
	move.l	#args,EPG_Arg6(a5)
	clr.l	EPG_Arg7(a5)
	clr.l	EPG_Arg8(a5)
	move.l	#8,EPG_ArgN(a5)
			*----	ARG1 = TextAdresse						----*
			*----	ARG2 = Pointer to Pubscreenname (only Kick2.0)			----*
			*----	ARG3 = Position on Screen (x.w & y.w)				----*
			*----	ARG4 = Pointer to Gadgetnames					----*
			*----	ARG5 = Pointer to Requestername					----*
			*----	ARG6 = Pointer to ArgumentListe					----*
			*----	ARG7 = Pointer to ImageDatas					----*
			*----	ARG8 = Flags		EPTRF_Center...				----*
			*----				EPTRF_TestTimeOut			----*
	jsr	A5Textrequest(a5)
		rts

args:		dc.l	0,0
pubscreen:	dc.b	"Workbench",0
freelist.MSG:	dc.b	"Freelistdata called!",10
		dc.b	"with Arg1 %ld",0
freelist2.MSG:	dc.b	"Freelistdata called!",10
		dc.b	"ZERO-POINTER!!!!!!!!",10
		dc.b	"with Arg1 %ld",0
addlist.msg:	dc.b	"Addlistdata called!",10
		dc.b	"with Arg1 %ld",0
		even
 endc

*-----------------------------------------------------------------------------*
*Diese Funktion gibt den Speicher wieder frei, der mit AllocListData allokiert*
*wurde. A1=Adr des Memory's oder NULL fr alle
*-----------------------------------------------------------------------------*
* Input: A1=Speicherblock
*-----------------------------------------------------------------------------*
DT_FreeListData:
		movem.l	d0-a6,-(a7)
		lea	LFPuffer(a5),a2
* if betaversion
*	movem.l	d0-a6,-(a7)
*	move.l	a1,d0
*	lea	freelist.msg(pc),a0
*	bsr	textreq
*	movem.l	(a7)+,d0-a6
* endc
		move.l	PufferAdr(pc),a5
		move.l	a1,d0
		beq.s	.Alle

		*--- Nur einen Block freigeben ---*
		moveq	#MaxLoadFiles-1,d1
*		lea	MDPuffer-4*4(a5),a4
		lea	-4*4(a2),a4
.Suche		lea	4*4(a4),a4
		move.l	(a4),d0
		cmp.l	d0,a1
		beq.s	.Found
		dbf	d1,.Suche

*		addq.l	#1,DT_AddValue(a5)
		bra.s	.Return
.Found
	move.l	d1,-(a7)
		move.l	d0,a1
		move.l	4(a4),d0
		ExecBase
		jsr	_LVOFreeMem(a6)
		clr.l	(a4)
		clr.l	4(a4)
		clr.l	8(a4)
		clr.l	12(a4)
	move.l	(a7)+,d1

		*-- Rest vorkopieren --*
		subq.l	#1,d1
		rol.l	#2,d1
		subq.l	#1,d1
		blt.s	.NoCopy
.CopyIt:	move.l	16(a4),(a4)
		clr.l	16(a4)
		addq.l	#4,a4
		dbf	d1,.CopyIt

.NoCopy:	bra.s	.Return

		*--- Alle Speicherbereiche freigeben ---*
.Alle:
 if betaversion
	movem.l	d0-a6,-(a7)
	move.l	a1,d0
	lea	freelist.msg(pc),a0
	bsr	textreq
	movem.l	(a7)+,d0-a6
 endc

		*lea	MDPuffer(a5),a4
		*move.l	MDNummer(a5),d4
		lea	(a2),a4
		move.l	MDNummer-MDPuffer(a2),d4
.Next:		subq.l	#1,d4
		blt.s	.Last
		move.l	(a4),d0
		beq.s	.NichtD
		move.l	d0,a1
		move.l	4(a4),d0
		ExecBase
		jsr	_LVOFreeMem(a6)		
.NichtD:	clr.l	(a4)+
		clr.l	(a4)+
		clr.l	(a4)+
		clr.l	(a4)+
		bra.s	.Next

.Last:		*clr.l	MDNummer(a5)
		clr.l	MDNummer-MDPuffer(a2)

.Return:	movem.l	(a7)+,d0-a6
		rts


*------------------------------- Hexdez ----------------------------*
*---- Input:	d0=Hexzahl					----*
*----		d1=Flags	Bit 0: 1=Hidezero		----*
*----				Bit 1: 1=use negativ		----*
*----		a0=OutputPuffer					----*
*-------------------------------------------------------------------*
EPP_Hexdez:	movem.l	d0-a6,-(a7)
		move.l	PufferAdr(pc),a5
		btst	#1,d1
		beq.s	.NoNegativ
		tst.l	d0
		bge.s	.NoNegativ
		move.b	#"-",(a0)+
		neg.l	d0
.NoNegativ:	btst	#0,d1
		beq.s	.HideZero
		bsr.s	.Hexdez
		bra.s	.Ok
.HideZero:	jsr	A5Hexdez(a5)
.Ok		movem.l	(a7)+,d0-a6
		rts

	*--------- Routine, die die Hexdez mit nullstellen ausgibt -------*
.Hexdez:	movem.l	d0-d4/a1,-(a7)
		lea	Hexdeztab,a1
		moveq	#0,d4
		moveq	#9,d3
.HexDez1:	move.l	(a1)+,d1
		moveq	#0,d2
.HexDez2:	addq.l	#1,d2
		sub.l	d1,d0
		bcc.s	.Hexdez2
		add.l	d1,d0
		add.b	#$2f,d2
		move.b	d2,(a0)+
		dbf	d3,.Hexdez1
		clr.b	(a0)
		movem.l	(a7)+,d0-d4/a1
		rts

*----------------------------- Find-Tag -----------------------------*
*---- a0 = Tagliste						-----*
*---- d0 = Tag							-----*
*------------------------------->  d0 = TagWert			-----*
*------------------------------->  d1 = Ergebnis (0=nein 1=ja)	-----*
*--------------------------------------------------------------------*
EPP_FindTag:	movem.l	d2-d7/a1-a6,-(a7)
		move.l	PufferAdr(pc),a5
		move.l	a0,a6
		moveq	#0,d1
		bsr	.FindTag
		*moveq	#0,d0
		*tst.l	d2
		*beq.s	.Return
		move.l	a6,d0
.Return:	movem.l	(a7)+,d2-d7/a1-a6
		tst.l	d1
		rts

.FindTag:	move.l	d3,-(a7)
		move.l	a7,d3

	*--------- Recursive FindTag-Routine ----------*
.FindTag3:	moveq	#0,d2
		cmp.l	a6,d2
		beq.s	.Empty
		move.l	(a6)+,d2			;Tag rauslesen
		bne.s	.NoEmpty
.Empty:		cmp.l	d3,a7				;ak. Stack vergleichen
		beq.s	.TagNoFound
		move.l	(a7)+,a6
		bra.b	.NoMore
.NoEmpty:	cmp.l	d2,d0
		beq.s	.TagFound

	*----- Tag-Skip gefunden ???? -----*
		cmp.l	#Tag_Skip,d2
		bne.s	.NoSkip
		addq.l	#8,a6				;Diesen und nchsten
		addq.l	#4,a6				;Tag berspringen
		bra.s	.NoMore

	*------ Tag-More gefunden ???? -----*
.NoSkip:	cmp.l	#Tag_More,d2
		bne.s	.NoMore

		move.l	a6,-(a7)		;Adr der Tagliste sichern
		move.l	(a6),a6			;Neue Tagliste setzen
		bra.w	.FindTag3
.NoMore:	addq.l	#4,a6
		bra.w	.FindTag3
.TagFound:	move.l	(a6),a6
		move.l	a6,d2
		moveq	#1,d1
.TagNoFound:	move.l	d3,a7
		move.l	(a7)+,d3
		tst.l	d2
		bne.s	.NoNull
		sub.l	a6,a6
.NoNull:	tst.l	d2
		rts


*--------------------------------------------------------------------*
*------------------ Composer eines Musicstckes finden --------------*
*---- ARG1 = Start des Samples					-----*
*---- ARG2 = Offset to next Samples				-----*
*---- ARG3 = Length of Samplename				-----*
*---- ARG4 = Sampleanzahl					-----*
*---- Ergebnis = Arg1 = Pointer to Author			-----*
*----	  Arg2 = Size of Authorname				-----*
*--------------------------------------------------------------------*
	*--------- Composer finden ----------*
EPP_FindAuthor:	movem.l	d0-a6,-(a7)
		move.l	PufferAdr(pc),a5
		move.l	EPG_ArgN(a5),d0
		subq.l	#4,d0
		bne.w	.NoAuthor



	*-- mit hherer Prioritt "Composed by" suchen --*
		move.l	EPG_Arg1(a5),a1
		move.l	EPG_Arg4(a5),d0
		subq.l	#1,d0

.CompNext:	move.l	a1,a2
		move.l	EPG_Arg3(a5),d1
		subq.l	#1,d1
.CompNextB:	cmp.b	#"c",(a2)
		bne.s	.NoComposed
		cmp.b	#"o",1(a2)
		bne.s	.NoComposed
		cmp.b	#"m",2(a2)
		bne.s	.NoComposed
		cmp.b	#"p",3(a2)
		bne.s	.NoComposed
		cmp.b	#"o",4(a2)
		bne.s	.NoComposed
		cmp.b	#"s",5(a2)
		bne.s	.NoComposed
		cmp.b	#"e",6(a2)
		bne.s	.NoComposed
		cmp.b	#"d",7(a2)
		bne.s	.NoComposed
		addq.l	#8,a2		;Problem: Im Module steht "composed at
		subq.l	#8,d1		--> kein Autor, der wahre Autor steht
		blt.s	.NormalBy	im Sample davor --> nach composed noch
		moveq	#1,d5		mal durchsuchen --> d5=1
		bra.s	.NextBuch
.NoComposed:	addq.l	#1,a2
		dbf	d1,.CompNextB

	*------ Offset to next sample ------*
		move.l	EPG_Arg2(a5),d1
		lea	(a1,d1.l),a1
		dbf	d0,.CompNext




.NormalBy:	moveq	#0,d5		;Kennung, kein weiterer Durchlauf
		move.l	EPG_Arg1(a5),a1
		move.l	EPG_Arg4(a5),d0
		subq.l	#1,d0


	*-------- Suche die einzelnen Samplenamen nach by durch -------*
.NextComSample:	move.l	a1,a2
		move.l	EPG_Arg3(a5),d1
		subq.l	#1,d1
.NextBuch:	cmp.b	#"b",(a2)
		beq.s	.TestY
		cmp.b	#"B",(a2)
		bne.s	.TextNextKennung
.TestY:		cmp.b	#"y",1(a2)
		beq.s	.yesY
		cmp.b	#"Y",1(a2)
		bne.s	.TextNextKennung
.yesY
		cmp.b	#"e",2(a2)
		beq.s	.TextNextKennung
		cmp.b	#"E",2(a2)
		bne.s	.FindNextString2

.TextNextKennung:cmp.b	#"",(a2)
		beq.s	.ByAmAnfang		;.FindNextString2
		cmp.b	#"(",(a2)
		bne.s	.Schl
		cmp.b	#"c",1(a2)
		beq.s	.TestKl2
		cmp.b	#"C",1(a2)
		bne.s	.Schl
.TestKl2:	cmp.b	#")",2(a2)
		bne.s	.Schl
		addq.l	#1,a2
		subq.l	#1,d1
		bra.s	.ByAmAnfang		;.FindNextString2
.Schl:		addq.l	#1,a2
		dbf	d1,.NextBuch
.GoNEXTSample
	*------ Offset to next sample ------*
		move.l	EPG_Arg2(a5),d1
		lea	(a1,d1.l),a1
		dbf	d0,.NextComSample
		tst.l	d5		;weil bei "Composed nichts gefunden
		bne.w	.NormalBy	;wurde, nochmal ganz von vorne
		bra.w	.FindComposer2

.FindNextString2:move.l	EPG_Arg3(a5),d2		;kurzer Test auf Strings wie
		subq.l	#1,d2			;fabyth
		cmp.l	d2,d1
		beq.s	.ByAmAnfang
		cmp.b	#"A",-1(a2)
		blo.s	.ByAmAnfang
		cmp.b	#"Z",-1(a2)
		blo.s	.Schl
		cmp.b	#"a",-1(a2)
		blo.s	.ByAmAnfang
		cmp.b	#"z",-1(a2)
		blo.s	.Schl
.ByAmAnfang:	moveq	#0,d2
		addq.l	#2,a2
		subq.l	#2,d1
		ble.s	.GoNextString
		bra.b	.FindNextString

	*------- Suche jetzt Author-String nach "by" ------*
.NextSample2:	move.l	EPG_Arg3(a5),d1
		subq.l	#1,d1
		move.l	a2,a1
.FindNextString:move.b	(a2)+,d2
		cmp.b	#`.`,d2		`by ...` berspringen
		beq.s	.NextString
		cmp.b	#$20,d2
		bhi.s	.Found
.NextString:
		dbf	d1,.FindNextString
.goNextString
		move.l	EPG_Arg2(a5),d1
		lea	(a1,d1.l),a2
		dbf	d0,.NextSample2
		bra.w	.FindComposer2

	*------- Testen, ob bestimmte Schlsselwrter ---------*
.Found:		cmp.b	#":",d2			;":" raus
		beq.s	.NextString

		cmp.b	#`G`,d2			;"Gryzor" raus
		bne.s	.noGRY
		cmp.b	#`r`,(a2)
		bne.s	.noGRY
		cmp.b	#`y`,1(a2)
		bne.s	.noGRY
		cmp.b	#`z`,2(a2)
		bne.s	.noGRY
		cmp.b	#`o`,3(a2)
		beq	.GoNEXTSample
.noGRY:	

		cmp.b	#"1",d2			;1995 by
		bne.s	.No1995
		cmp.b	#"9",(a2)
		bne.s	.No1995
		cmp.b	#"8",1(a2)
		beq.s	.Yes198x
		cmp.b	#"9",1(a2)
		bne.s	.No1995
.Yes198x:	cmp.b	#" ",3(a2)
		bne.s	.No1995
		cmp.b	#"b",4(a2)
		bne.s	.No1995
		cmp.b	#"y",5(a2)
		bne.s	.No1995
		addq.l	#6,a2
		subq.l	#6,d1
		blt.w	.gonextSample
		bra.s	.NextString

.No1995:		

		cmp.b	#"t",d2
		bne.s	.NoTheRaveb
		cmp.b	#"h",(a2)
		bne.s	.NoTheRaveb
		cmp.b	#"e",1(a2)
		bne.s	.NoTheRaveb
		cmp.b	#" ",2(a2)
		beq.s	.RBLeer
		cmp.b	#".",2(a2)
		bne.s	.NoTheRaveb
.RBLeer:	cmp.b	#".",3(a2)
		bne.s	.NoTheRaveb
		*cmp.b	#".",4(a2)
		*bne.s	.NoTheRaveB
		addq.l	#3,a2
		subq.l	#3,d1
		blt.w	.gonextSample
		bra.w	.NextString
.NoTheraveb:


		cmp.b	#`m`,d2			;"me" raus
		beq.s	.yoME
		cmp.b	#`M`,d2
		bne.s	.noME
.yoME		cmp.b	#`e`,(A2)
		beq.w	.GoNEXTSample
		cmp.b	#`E`,(A2)
		beq.w	.GoNEXTSample
.noME

		cmp.b	#`o`,d2			;"(c)composed"
		bne.s	.nocompos
		cmp.b	#`m`,(A2)
		bne.s	.nocompos
		cmp.b	#`p`,1(A2)
		bne.s	.nocompos
		cmp.b	#`o`,2(A2)
		bne.s	.nocompos
		cmp.b	#`s`,3(A2)
		bne.s	.nocompos	
		subq	#1,d1
		bra.w	.NextBuch
.nocompos


	;	cmp.b	#"o",d2
	;	bne.s	.NoOf
	;	cmp.b	#"f",d2
	;	beq.s	.NextString

.NoOf:		subq.l	#1,a2


;	move.l	EPG_Arg3(a5),d1	;max. Lnge ist nicht immer komplette
	add	#1,d1		; Lnge des Namens !!!

		bra.b	.Author1Found

	*----- Suche Composer nach der Intuitracker-Mglichkeit -----*
.FindComposer2:	move.l	EPG_Arg1(a5),a2
		move.l	EPG_Arg4(a5),d1
		subq.l	#1,d1
.Such:		cmp.b	#`#`,(a2)
		beq.s	.Author2Found
		add.l	EPG_Arg2(a5),a2
		dbf	d1,.such

	*------- Kein Author found -----*
.NoAuthor:	moveq	#0,d0
		sub.l	a0,a0
		bra.b	.Return

	*------ Author found und Namen copieren -------*
.Author2Found:	move.l	EPG_Arg3(a5),d1
		subq.l	#1,d1
		addq.l	#1,a2
.Author1Found:	move.l	a2,a0
		lea	ComposerPuffer(a5),a1
;		subq.l	#2,d1

.c_CopyIt:	move.b	(a0)+,d0
		cmp.b	#32,d0
		blo.s	.c_ret
		move.b	d0,(a1)+
		dbf	d1,.c_CopyIt
.c_ret		clr.b	(a1)

		lea	Composerpuffer(a5),a0
		move.l	a0,a1
		moveq	#-1,d0
.TestSize:	addq.l	#1,d0
		tst.b	(a1)+
		bne.s	.TestSize

.Return		move.l	d0,EPG_Arg2(a5)
		move.l	a0,EPG_Arg1(a5)
		movem.l	(a7)+,d0-a6
		rts



*--------------------------- Filerequester -----------------------------*
*---- Input	ARG1 = FileRequester-Title				*
*----		ARG2 = DirectoryPath					*
*----		ARG3 = Filename						*
*----		ARG4 = Window						*
*----		ARG5 = FileRequesterType 1=SelectDirs 0=SelectFiles	*
*----		ARG6 = OutPut Text (for Eagleplayer-Window)		*
*---- OutPut	D0   = Fehler						*
*-----------------------------------------------------------------------*
EPP_FileReq:	movem.l	d1-a6,-(a7)
		move.l	PufferAdr(pc),a5

		move.l	EPG_ArgN(a5),d0
		subq.l	#6,d0
		bne.w	ErrorInArguments

		jsr	A5WaitMouse(a5)
		LA0	LNr_SW_SelectFile
		move.l	EPG_ARG6(a5),d0
		beq.s	.NoText
		move.l	d0,a0
.NoText:	jsr	A5PrintText(a5)

	;**** a0 = FileRequester-Title		    ****
	;**** a1 = Directorypath		    ****
	;**** a2 = Filename	 		    ****
	;**** a3 = Window	 		    ****
	;**** d0 = 1  SelectDir			    ****
	;****	   0  SelectFile		    ****
		moveq	#0,d3
		move.l	EPG_Arg2(a5),a1			;Directory
		move.l	EPG_Arg3(a5),d0			;Filename
		move.l	d0,a2
		bne.s	.FileNameOk
		tst.l	EPG_Arg5(a5)
		bne.s	.FileNameOk

		*--- Wenn ein kompletter Pfad angegeben werden soll, ----*
		*--- mu dieser fr die Filerequester auseinander-   ----*
		*--- gepflckt.
		jsr	A5GetFileName(a5)
		move.l	a1,a0
		move.l	a1,a2
		lea	FilePufferReq(a5),a1
		jsr	A5StringCopy(a5)
		move.l	a2,a4
		move.b	(a2),d3
		clr.b	(a2)
		move.l	EPG_Arg2(a5),a1
		lea	FilePufferReq(a5),a2

.FileNameOk:	move.l	d3,-(a7)
		move.l	EPG_Arg4(a5),a3			;WinHandle
		move.l	EPG_Arg5(a5),d0			;FileReq-Type
		move.l	EPG_Arg1(a5),a0			;FileRequesterTitle
		jsr	A5FileRequest2(a5)
		move.l	(a7)+,d3
		tst.l	d0
		beq.s	.OkGedr
		tst.b	d3
		beq.s	.Ok
		move.b	d3,(a4)
		bra.w	.Ok

		*-- Bei Filename=0 wird Filename ans Dir kopiert --*
.OkGedr		tst.l	EPG_Arg5(a5)
		bne.s	.Dirs
		tst.l	EPG_Arg3(a5)			;Filename
		bne.s	.Dirs
		move.l	EPG_Arg2(a5),a1
		jsr	A5MakeCorrectDir(a5)
		move.l	EPG_Arg2(a5),a0
		jsr	A5BerechStringSize(a5)
		lea	(a0,d0.w),a1
		lea	FilePufferReq(a5),a0
		jsr	A5StringCopy(a5)

.Dirs:		LA0	LNr_OperationSuccesful
		jsr	A5ScrollNewText(a5)
		moveq	#0,d0
.Ok		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts




*------------------ Scrollt Text ins AnzeigeWindow ---------------------*
*---- Input	ARG1=Adr des Textes					*
*----		ARG2=Length of Text					*
*---- OutPut	d0=Fehler						*
*-----------------------------------------------------------------------*
EPP_ScrollText:	movem.l	d1-a6,-(a7)
		move.l	PufferAdr(pc),a5
		move.l	EPG_ArgN(a5),d0
		subq.l	#2,d0
		bne.w	NotEnoughArguments

		*tst.l	WindowOffen(a3)
		*beq.w	ErrorOpenWin

		move.l	EPG_Arg1(a5),d0
		beq.w	ErrorInArguments
		move.l	d0,a1
		lea	TextPuffer(a5),a0
		move.l	EPG_Arg2(a5),d1
		beq.w	ErrorInArguments
		jsr	A5ScrollNewText(a5)
		movem.l	(a7)+,d1-a6
		moveq	#0,d0
		rts


*------------------------ Load a Executable ----------------------------*
*---- Input	ARG1 = Adr des PathNames				*
*---- OutPut	ARG1 = Segment (in BCPL) or ZERO			*
*----		D0   = Fehler						*
*-----------------------------------------------------------------------*
EPP_LoadExecutable:movem.l d1-a6,-(a7)
		move.l	PufferAdr(pc),a5
		move.l	EPG_ArgN(a5),d0
		subq.l	#1,d0
		bne.s	NotEnoughArguments
		
		move.l	EPG_Arg1(a5),d1
		beq.s	ErrorInArguments
		clr.l	EPG_Arg1(a5)
		jsr	A5LoadSegment(a5)
		beq.w	FileIsNotExecutable
		asr.l	#2,d0
		subq.l	#1,d0
		move.l	d0,EPG_Arg1(a5)
		movem.l	(a7)+,d1-a6
		moveq	#0,d0
		rts

NotEnoughArguments:
		movem.l	(a7)+,d1-a6
		moveq	#EPR_NotEnoughArguments,d0
		rts
FileIsNotExecutable:
		movem.l	(a7)+,d1-a6
		moveq	#EPR_FileIsNotExecutable,d0
		rts
ErrorInArguments:movem.l (a7)+,d1-a6
ErrorInArguments2:moveq	#EPR_ErrorinArguments,d0
		rts

ErrorOpenWin:	movem.l	(a7)+,d1-a6
		moveq	#EPR_CantOpenWin,d0
		rts


*-----------------------------------------------------------------------------*
* Vorteil: alle Cataloge knnen in einem Verzeichnis liegen bzw. in mehreren
*	   verteilt sein und werden trotzdem gefunden.
* Input: a1=Catalogname
* Output:d0=Catalog
*-----------------------------------------------------------------------------*
EPP_OpenCatalog:movem.l d1-a6,-(a7)
		move.l	PufferAdr(pc),a5


		move.l	a1,-(a7)
		move.l	EPG_EagleplayerDirArrayPtr(a5),d1
		move.l	DTG_Dosbase(a5),a6
		move.l	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,d1
		beq.s	.NoDir
		jsr	_LVOCurrentDir(a6)
.NoDir:		move.l	(a7)+,a1
		move.l	d0,-(a7)

		move.l	EPG_LocaleBase(a5),d0
		beq.s	.NoLocale
		move.l	d0,a6
		sub.l	a0,a0
		sub.l	a2,a2
		*lea	Catalogname(pc),a1
		jsr	_LVOOpenCatalogA(a6)		;_LVOopencatalogA

.NoLocale:	move.l	(a7)+,d1
		move.l	d0,-(a7)

		tst.l	d1
		beq.s	.NoDir2
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnlock(a6)
.NoDir2:	move.l	(a7)+,d0


.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts



*-----------------------------------------------------------------------------*
* Input: d0=Catalogname
* Output:
*-----------------------------------------------------------------------------*
EPP_CloseCatalog:movem.l d1-a6,-(a7)
		move.l	PufferAdr(pc),a5

		tst.l	d0
		beq.s	.Return
		move.l	EPG_LocaleBase(a5),d1
		beq.s	.Return
		move.l	d1,a6
		jsr	_LVOCloseCatalog(a6)

.Return:	movem.l	(a7)+,d1-a6
		moveq	#0,d0
		rts








*---------------------- Initialisiere ein Commodity ------------------------*
InitCommodity:	movem.l	d0-a6,-(a7)
		*tst.w	Kick2On(a5)
		*beq.w	.Return
		tst.l	BrokerPort(a5)
		bne.w	.Return

		LA1	LNr_Commodityname
		lea	EPG_Commoditiesbase(a5),a3
		moveq	#37,d0
		jsr	A5OpenLib(a5)
		beq	.Return

		ExecBase
		jsr	_LVOCreateMSGPort(a6)	;MSGport fr Broker erschaffen (lassen)
		move.l	d0,BrokerPort(a5)
		beq	.Return

		move.l	EPG_Commoditiesbase(a5),a6
		lea	MyBroker(a5),a0
		move.b	#5,(a0)			;Broker-Version
		LA1	LNr_Prozessname
		move.l	a1,2(a0)		;Name fr CommodityExchange
		LA1	LNr_CommoTitle
		move.l	a1,6(a0)
		LA1	LNr_commoText
		move.l	a1,10(a0)
		move.w	#3,14(a0)		;unique setzen
		move.w	#4,16(a0)		;Flags setzen
		move.b	CX_Priority(a5),18(a0)	;Prioritt setzen
		move.l	BrokerPort(a5),a1
		moveq	#0,d0
		moveq	#1,d6
		move.b	15(a1),d0		;Signalbit dieses MSGports merken
		asl.l	d0,d6

		move.l	a1,20(a0)		;Port setzen
		LA2	LNr_EPCommodityname	;Portname setzen
		move.l	a2,10(a1)



		lea	BrokerFehler(a5),a1
		move.l	a1,d0
		jsr	_LVOCxBroker(a6)	;Broker init

		lea	BrokerFehler(a5),a1
		tst.l	(a1)			;BrokerFehler beim Einbinden aufgetreten ?
		bne	CloseCommodity2		;ja -> Ende
		move.l	d0,Brokerstruct(a5)
		beq.s	CloseCommodity2


	*----------- Hotkey hinzufgen ----------*
		moveq	#1,d0			;CX_Filter
		lea	HotkeyPuffer(a5),a0	;"rawkey Ctrl Alt E"
		tst.b	(a0)
		beq.s	.NoNewObject
		sub.l	a1,a1
		jsr	_LVOCreateCxObj(a6)
		move.l	d0,d5
		move.l	d0,a1
		beq.s	.NoNewObject
		move.l	Brokerstruct(a5),a0
		jsr	_LVOAttachCxObj(a6)	;Hotkey-CXObject dem Broker

	*----------- IEvent hinzufgen ----------*
		moveq	#3,d0			;CX_SEND
		move.l	BrokerPort(a5),a0	;Arg1 (Port)
		sub.l	a1,a1
		addq.l	#1,a1			;Arg2 (Rawkey)
		jsr	_LVOCreateCxObj(a6)
		move.l	d0,a1
		beq.s	.NoNewObject
		move.l	d5,a0
	*move.l	Brokerstruct(a5),a0
		jsr	_LVOAttachCxObj(a6)	;Hotkey-CXObject dem Broker

	*----------- Translate hinzufgen ----------*
		moveq	#5,d0			;CX_TRANSLATE
		sub.l	a0,a0
		sub.l	a1,a1
		jsr	_LVOCreateCxObj(a6)
		move.l	d0,a1
		beq.s	.NoNewObject
		move.l	d5,a0
	*move.l	Brokerstruct(a5),a0
		jsr	_LVOAttachCxObj(a6)	;Hotkey-CXObject dem Broker
						;hinzufgen



	*----------- Eagleplayer-Commodity initialisieren --------*
.NoNewObject:	move.l	Brokerstruct(a5),d0
		beq.s	.Return
		move.l	d0,a0
		moveq	#1,d0
		move.l	EPG_Commoditiesbase(a5),a6
		jsr	_LVOActivateCXObj(a6)	;Broker aktivieren

		move.l	BrokerPort(a5),a1
		moveq	#0,d0
		move.b	15(a1),d0
		move.l	SignalBits(a5),d6
		bset	d0,d6
		move.l	d6,SignalBits(a5)

.Return:	movem.l	(a7)+,d0-a6
		rts



*------------------------ Gebe das Commodity wieder frei --------------------*
CloseCommodity:	movem.l	d0-a6,-(a7)
CloseCommodity2:move.l	EPG_CommoditiesBase(a5),d0
		beq.s	.CloseCXPort
		move.l	d0,a6

	*----- Alle CX-Object lschen -----*
		move.l	BrokerStruct(a5),d0
		beq.s	.CloseCXPort
		move.l	d0,a0
		jsr	_LVODeleteCXObjAll(a6)
.CloseCXPort:	ExecBase
		move.l	BrokerPort(a5),d0
		beq.s	.PortFree
		move.l	d0,a0


		move.l	SignalBits(a5),d1		;Signale lschen
		moveq	#0,d0
		move.b	15(a0),d0
		bclr	d0,d1
		move.l	d1,SignalBits(a5)

		jsr	_LVODeleteMsgPort(a6)

	*--- Commoditiesmerkzelen closen ---*
.PortFree:	clr.l	BrokerPort(a5)
		clr.l	BrokerStruct(a5)
		movem.l	(a7)+,d0-a6
		rts

*----------------------------------------------------------------------------*
Hotkey:		jsr	A5CloseCommodity(a5)
		lea	HotKeyPuffer+7(a5),a0		;"rawkey "
		move.l	a2,a1
		move.l	d2,d1
		subq.l	#1,d1
		blt.s	.NoKey
		jsr	A5CopyText2(a5)
.NoKey:		clr.b	(a0)
		move.l	#"rawk",HotKeyPuffer(a5)
		move.w	#"ey",HotKeyPuffer+4(a5)
		move.b	#" ",HotKeyPuffer+6(a5)
		cmp.l	#Mode_Config,TestBits(a5)
		beq.s	.NoSet
		jsr	A5InitCommodity(a5)
.NoSet:		moveq	#0,d0
		rts

*----------------------------------------------------------------------------*
CommodityPriority:
		cmp.b	#-28,d2
		ble.s	.No
		cmp.b	#28,d2
		bgt.s	.No
		move.b	d2,CX_Priority(a5)
		move.l	EPG_CommoditiesBase(a5),d0
		beq.s	.No
		move.l	d0,a6
		move.l	BrokerStruct(a5),d0
		beq.s	.No
		move.l	d0,a0
		moveq	#0,d0
		move.b	CX_Priority(a5),d0
		jsr	_LVOSetCXObjPri(a6)
		moveq	#0,d0
		rts

.No:		moveq	#0,d0
		cmp.l	#Mode_Config,TestBits(a5)
		beq.s	.No2
		moveq	#EPR_FunctionNotEnabled,d0
.No2:		rts


*-----------------------------------------------------------------------------*
InitScreenNotify:
	ifne	executable
		movem.l d0-a6,-(a7)
	*	tst.l	UPrg_WinHandle(a5)
	*	beq.s	.NoScreenNotify

	* ist Window auf der Workbench
	* Auf Workbench PubScreen testen

		LA1	LNr_ScreenNotifyname
		lea	EPG_ScreenNotifyBase(a5),a3
		moveq	#0,d0
		jsr	A5OpenLib(a5)
		beq.s	.Error

		Execbase
		move.l	ScreenNotifyPort(a5),d0
		bne.s	.PortDa
		jsr	_LVOCreateMsgPort(a6)
		move.l	d0,ScreenNotifyPort(a5)
		tst.l	d0
		beq.s	.Error
		move.l	d0,a4
		LA0	LNr_EPScreenNotifyPort
		move.l	a0,10(a4)			;LN_Name
		move.l	a4,a1
		move.l	SignalBits(a5),d0
		moveq	#0,d1
		move.b	15(a1),d1
		bset	d1,d0
		move.l	d0,SignalBits(a5)
		jsr	_LVOAddPort(a6)

.PortDa:	moveq	#0,d0
		move.l	ScreenNotifyPort(a5),a0
		move.l	EPG_ScreenNotifyBase(a5),a6
		move.l	ScreenNotifyHandle(a5),d0
		bne.s	.HandleDa
		jsr	_LVOAddWorkbenchClient(a6)
.HandleDa:	move.l	d0,ScreenNotifyHandle(a5)
		tst.l	d0
		bne.s	.NoScreenNotify
.Error:		bsr	EndScreenNotify
.NoScreenNotify:movem.l	(a7)+,d0-a6
	endc
		rts

*-----------------------------------------------------------------------------*
EndScreenNotify:
		movem.l	d0-a6,-(a7)
		move.l	ScreenNotifyHandle(a5),d0
		beq.s	.NoHandle
		move.l	d0,a0
		move.l	EPG_ScreenNotifyBase(a5),a6
		jsr	_LVORemWorkbenchClient(a6)
.NoHandle:	clr.l	ScreenNotifyHandle(a5)
		move.l	ScreenNotifyPort(a5),d0
		beq.s	.NoPort
		move.l	d0,a1
		move.l	SignalBits(a5),d0
		moveq	#0,d1
		move.b	15(a1),d1
		bclr	d1,d0
		move.l	d0,SignalBits(a5)
		Execbase
		jsr	_LVORemPort(a6)
		move.l	ScreenNotifyPort(a5),a0
		jsr	_LVODeleteMSGPort(a6)
.NoPort:	clr.l	ScreenNotifyPort(a5)
		lea	EPG_ScreenNotifyBase(a5),a0	;WB-Lib schlieen
		jsr	A5CloseLib(a5)
		movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
* d0=Message
ScreenNotifyMessage:
		move.l	d0,a1
		cmp.l	#3,snm_Type(a1)
		bne.w	.RePlyIt
		tst.l	snm_value(a1)
		bne.w	.RePlyIt

		movem.l d0-a6,-(a7)
		moveq	#USClass_Hide,d0	;User-Type (Dumy) Prg stoppen
		jsr	A5SendeAllMessage(a5)
		tst.l	WindowOffen(a5)
		beq.s	.NoClose
		move.l	WindowOffen(a5),WinMerk(a5)
		jsr	A5CloseMainWindow(a5)
.NoClose:	movem.l	(a7)+,d0-a6

.Nochmal:	execbase
		jsr	_LVOReplyMSG(a6)
		move.l	ScreenNotifyPort(a5),d0
		beq.s	.NoPort
		move.l	d0,a0
		jsr	_LVOWaitPort(a6)
		move.l	ScreenNotifyPort(a5),a0
		jsr	_LVOGetMsg(a6)
		tst.l	d0
		move.l	d0,a1
		beq.s	.NoPort
		cmp.l	#3,snm_Type(a1)
		bne.s	.Nochmal
		tst.l	snm_value(a1)
		beq.s	.Nochmal

		movem.l	d0-a6,-(a7)
		tst.b	OnIconify(a5)
		beq.s	.OpenWindowNoI
		*clr.b	OnIconify(a5)
		*jsr	A5Iconify(a5)		;Deiconifyzieren
		bra.s	.IconifyOk

.OpenWindowNoI:	tst.l	WinMerk(a5)
		beq.s	.NoOpenMainWindow
		jsr	A5OpenMainWindow(a5)
.NoOpenMainWindow:clr.l	WinMerk(a5)
		jsr	A5OpenOldEngines(a5)
.IconifyOk:	jsr	A5ScreenToFront(a5)
		LA0	LNr_EPVersion
		move.l	A0,ScrollArgs(a5)
		moveq	#LNr_Welcome,d0
		jsr	A5Scrollnew(a5)
		movem.l	(a7)+,d0-a6

.RePlyIt:	execbase
		jsr	_LVOReplyMSG(a6)
.NoPort:	rts	

*---------------------------------------------------------------------------*
SetWindowZustand:
		cmp.l	#Mode_Config,TestBits(a5)
		bne.w	.NormalToggle
		clr.l	WinMerk(a5)
		move.b	OnWindowZustand(a5),WinMerk+3(a5)
		moveq	#0,d0
		rts

.NormalToggle:	moveq	#0,d0
		tst.b	OnWindowZustand(a5)
		bne	.OpenIt
		bsr	CLoseMainWindow
		LA0	LNr_OperationSuccesful
		bra.s	.IstDa

.OpenIt:	bsr	OpenMainWindow
		LA0	LNr_EPVersion
		move.l	A0,ScrollArgs(a5)
		LA0	LNr_Welcome
.IstDa:		tst.l	D0
		bne.s	.NoTExt
		jsr	A5ScrollNewText(a5)
.NoText:	rts

*--------------------------- Open Main-Window ------------------------------*
OpenMainWindow:
		movem.l	d1-a6,-(a7)
		moveq	#0,d0
		cmp.l	#Mode_Config,TestBits(a5)
		beq.w	WindowReturn
		tst.b	OnIconify(a5)
		bne.w	WindowReturn
		

.OpenNormal:	bsr.w	RemoveApps		;Appicon & AppItem closen


		*LA0	LNr_WindowTitleMaster
		*cmp.l	#30010,ARegisterTable+6*4(a5)
		*beq.s	KeyEY2
		*cmp.l	#280673,ARegisterTable+6*4(a5)
		*beq.s	KeyEy2

		LA0	LNr_WindowTitleRegistered
KeyBne5:	tst.b	KeyOn(a5)		\
		bne.w	.Reg			 > ACHTUNG ;.w lassen !
		LA0	LNr_WindowTitleGeneric	/
.Reg:		tst.l	WindowOffen(a5)
		bne.w	.WindowOffen

		jsr	A5InitMenus(a5)
		move.w	#1,WindowChanged(a5)
		jsr	A5GuiChanged(a5)

	*----------- externes Window ffnen -------------*
	* Input: a0=Windowtitle				 *
	*	 a1=PubScreen				 *
	*------------------------------------------------*
		lea	PubScreenName(a5),a1
		move.l	FremdPubScreen(a5),d0
		beq.s	.NormalPubScreen
		move.l	d0,a1
.NormalPubScreen:move.l	#EUT_OpenAWindow,d0
		moveq	#EPST_MainWindow,d3	;Commando fr d0
		jsr	A5UserCallUp3(a5)
		beq.w	.OpenWinError	;Tag nicht gefunden -> nicht ntig
		tst.l	d0
		bne.w	WindowReturn	;Error -> nicht setzen


	*-------------- Gui vorbereiten ----------*
		move.l	#EUT_ChangePrefs,d7		*Scrollfont setzen
		move.w	#EPNr_ScrollFont,d0
		lea	ScrollFontPuffer(a5),a0
		tst.b	(a0)
		beq.s	.NoScrollFont
		move.w	ScrollFont+4(a5),d1		;Height
		beq.s	.NoScrollFont
		jsr	A5UserCallUp4(a5)
.NoScrollFont:


	*-- externes Window als Applikationswindow einfgen --*
		move.l	#EUT_GetWindowHandle,d0
		moveq	#EPST_MainWindow,d3	;Error fr d0
		jsr	A5UserCallUp3(a5)
		beq.s	.NoWindowHandle
		move.l	d0,UMG_WinHandle(a5)
		tst.l	d0
		beq.s	.NoWindowHandle
		bsr	InsertAppWindow
		move.l	d0,UMG_AppStrukadr(a5)


	*------------------- Signalbits anfordern --------------------*
.NoWindowHandle:move.l	#EUT_GetWaitMask,d0
		moveq	#0,d3			;Error fr d0
		jsr	A5UserCallUp3(a5)
		beq.s	.NoSignals
		move.l	d0,UMG_SignalBits(a5)

	*------------------ InterruptBit anfordern -------------------*
.NoSignals:	move.l	#EUT_GetInterruptMask,d0
		moveq	#0,d3			;Error fr d0
		jsr	A5UserCallUp3(a5)
		beq.s	.NoInterruptBits
		move.l	d0,UMG_InterruptBits(a5)

	*------------------- InterruptAdr anfordern --------------------*
.NoInterruptBits:move.l	#EUT_Interrupt,d0
		moveq	#0,d3			;Error fr d0
		jsr	A5UserFindTag(a5)
		beq.s	.NoInterrupt
		move.l	a6,UMG_InterruptAdr(a5)


.NoInterrupt:	subq.l	#1,WindowOffen(a5)
		*jsr	A5InitMenus(a5)
		jsr	A5RefreshMenu(a5)

	*--------------- Window in Vordergrund bringenn -------------*
		jsr	A5WindowToFront(a5)

		jsr	A5Titleaufbau(a5)
		jsr	A5EnableAll(a5)
	*	jsr	A5SetMenuStrip(a5)

	*	move.w	#1,ScrollPrintName(a5)
	*	bsr.w	Scrollen
	*	clr.w	CliError(a5)

;???		clr.b	OnIconify(a5)			;!!!!!!!!!!!!!

.WindowOffen:	moveq	#0,d0
		move.b	#1,OnWindowZustand(a5)
		bra.s	WindowReturn

.OpenWinError:	bsr	FreeMenus
		moveq	#EPR_CantOpenWin,d0
		
		clr.b	OnWindowZustand(a5)
WindowReturn:	movem.l	(a7)+,d1-a6
		rts


*-------------------------- Close PlayerWindow -----------------------------*
*-------------------------- Close PlayerWindow -----------------------------*

*		movem.l	d1-a6,-(a7)
*
*		lea	PlayerTitleR(pc),a0
*KeyBne5:	tst.b	KeyOn(a5)		\
*		bne.w	.Reg			 > ACHTUNG ;.w lassen !
*		lea	PlayerTitleG(pc),a0	/
*.Reg:		tst.l	PlWindowOffen(a5)
*		bne.w	.WindowOffen
*
*	*----------- externes Window ffnen -------------*
*	* Input: a0=Windowtitle				 *
*	*	 a1=PubScreen				 *
*	*------------------------------------------------*
*		lea	PubScreenName(a5),a1
*		move.l	FremdPubScreen(a5),d0
*		beq.s	.NormalPubScreen
*		move.l	d0,a1
*.NormalPubScreen:move.l	#EUT_OpenAWindow,d0
*		moveq	#EPST_PlayerWindow,d3	;Commando fr d0
*		jsr	A5UserCallUp3(a5)
*		beq.w	.OpenWinError	;Tag nicht gefunden -> nicht ntig
*		tst.l	d0
*		bne.w	.WindowReturn	;Error -> nicht setzen
*
*	*-- externes Window als Applikationswindow einfgen --*
*		move.l	#EUT_GetWindowHandle,d0
*		moveq	#EPST_PlayerWindow,d3	;Error fr d0
*		jsr	A5UserCallUp3(a5)
*		beq.s	.NoWindowHandle
*		move.l	d0,UPlG_WinHandle(a5)
*		tst.l	d0
*		beq.s	.NoWindowHandle
*		bsr	InsertAppWindow
*		move.l	d0,UPlG_AppStrukadr(a5)
*
*
*	*------------------- Signalbits anfordern --------------------*
*.NoWindowHandle:move.l	#EUT_GetWaitMask,d0
*		moveq	#0,d3			;Error fr d0
*		jsr	A5UserCallUp3(a5)
*		beq.s	.NoSignals
*		move.l	d0,UPlG_SignalBits(a5)
*
*
*.NoSignals:	subq.l	#1,PlWindowOffen(a5)
*.WindowOffen:	moveq	#0,d0
*		bra.s	.WindowReturn
*
*.OpenWinError:	moveq	#EPR_CantOpenWin,d0
*.WindowReturn:	movem.l	(a7)+,d1-a6
*		rts
*


*---------------------------- Close MainWindow -----------------------------*
CloseMainWindow:movem.l	d0-a6,-(a7)
		jsr	A5FreeMenus(a5)
		tst.l	WindowOffen(a5)
		beq.s	.NoWindow


		move.l	UMG_AppStrukAdr(a5),d0
		bsr.s	RemoveAppWindow

		move.l	#EUT_CloseAWindow,d0
		moveq	#EPST_MainWindow,d3	;Windowtype fr d0
		jsr	A5UserCallUp3(a5)
		clr.l	UMG_WinHandle(a5)
		clr.l	UMG_AppStrukadr(a5)
		clr.l	UMG_SignalBits(a5)
		clr.l	UMG_InterruptBits(a5)
		clr.l	UMG_InterruptAdr(a5)
.NoWindow:	clr.l	WindowOffen(a5)
		clr.b	OnWindowZustand(a5)
		movem.l	(a7)+,d0-a6
		rts



*-----------------------------------------------------------------------------*
*--------------- Window in Applicationsliste einfgen --------------------*
*-----------------------------------------------------------------------------*
* Input: d0=WindowPtr oder NUll
InsertAppWindow:movem.l	d1-a6,-(a7)
		tst.l	d0
		beq.s	.Return
		move.l	d0,a0
		lea	EPAppPort,a1

	*------- Workbenchs-Library ffnen ------*
		move.l	a0,-(a7)
		LA1	LNr_WBName
		lea	EPG_WorkbenchBase(a5),a3
		moveq	#37,d0
		jsr	A5OpenLib(a5)
		move.l	(a7)+,a0
		tst.l	d0
		beq.s	.Return

	*--------------- Window einfgen ------------*
		move.l	d0,a6
		moveq	#-1,d0
		moveq	#0,d1
		lea	EPAppPort,a1
		sub.l	a2,a2			;TagItem-Liste (Null setzen)
		jsr	_LVOAddAppWindowA(a6)

.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
* Input: d0=AppStruk oder Null
*-----------------------------------------------------------------------------*
RemoveAppWindow:movem.l	d0-d2/a0-a2/a6,-(a7)
		tst.l	d0
		beq.s	.NoWindow
		move.l	d0,a0
		move.l	EPG_WorkbenchBase(a5),d0 ;AppWindow-Struktur freigeben
		beq.s	.NoWindow
		move.l	d0,a6
		jsr	_LVORemoveAppWindow(a6)
.NoWindow:	bsr.w	CloseWorkbenchLib
		movem.l	(a7)+,d0-d2/a0-a2/a6
		rts

*--------------- Workbench.Library immer versuchen zu schlieen --------------*
CloseWorkbenchLib:
	*	move.l	AppStrukAdr(a5),d0
	*	add.l	PlAppStrukAdr(a5),d0
	*	add.l	TextAppStrukAdr(a5),d0
		add.l	UMG_AppStrukAdr(a5),d0
	*	add.l	ULG_AppStrukAdr(a5),d0
	*	add.l	UPG_AppStrukAdr(a5),d0
	*	add.l	UUG_AppStrukAdr(a5),d0

		add.l	AppIconHandle(a5),d0
		add.l	AppItemHandle(a5),d0
		bne.s	.NoCloseWb

		lea	EPG_WorkbenchBase(a5),a0	;WB-Lib schlieen
		jsr	A5CloseLib(a5)

.NoCloseWb:	rts





*-------------- Delete File in T: (TFile beim Laden) -------------------------*
DeleteTFile:	movem.l	d0/d1/a0/a1/a6,-(a7)
		tst.b	NachTGesaved(a5)
		beq.s	.NoTSave
		LA0	LNr_EPTName
		move.l	a0,d1
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVODeleteFile(a6)
.NoTSave:	clr.b	NachTGesaved(a5)
		movem.l	(a7)+,d0/d1/a0/a1/a6
		rts

*--------------------- Delete File in T: (=++ Initplayer) --------------------*
DeleteTFile2:	movem.l	d0/d1/a0/a1/a6,-(a7)
		tst.b	NachTGesaved2(a5)
		beq.s	.NoTSave
		LA0	LNr_EPTName2
		move.l	a0,d1
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVODeleteFile(a6)
.NoTSave:	clr.b	NachTGesaved2(a5)
		movem.l	(a7)+,d0/d1/a0/a1/a6
		rts

*-------------------------- Rename TFile -------------------------------------*
RenameTFile:	movem.l	d1-a6,-(a7)
		moveq	#0,d0
		tst.b	NachTGesaved(a5)
		beq.s	.Return
		jsr	A5DeleteTFile2(a5)
		LA0	LNr_EPTName
		move.l	a0,d1
		LA0	LNr_EPTName2
		move.l	a0,d2
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVORename(a6)
		tst.l	d0
		beq.s	.Return
		move.b	NachTGesaved(a5),NachTGesaved2(a5)
		move.l	DTG_FileArrayPtr(a5),a0
		LA0	LNr_EPTName2
		addq.l	#2,a0
		move.l	a0,DTG_FileArrayPtr(a5)
.Return:	movem.l	(a7)+,d1-a6
		rts

	*--------------------------------*
	*--------- Clear Cache ----------*
	*--------------------------------*
ClearCache:	movem.l	d0/d1/a0/a1/a5/a6,-(a7)
		move.l	PufferAdr(pc),a5
		ExecBase
		tst.w	Kick2On(a5)
		beq.s	.NoKick2
		jsr	_LVOCacheClearU(a6)
.NoKick2:	movem.l	(a7)+,d0/d1/a0/a1/a5/a6
		rts


	*------------------------------------------------------*
	* Definiert den selbstdef. Mousepfeil in allen Windows *
	*------------------------------------------------------*
WaitMouse:	movem.l	d0-a6,-(sp)
		tst.w	OnWaitMouse(a5)
		bne.s	.Return

	*------------- bei externem Gui -----------------*
		move.l	#EUT_SetWaitPointer,d0
		jsr	A5UserCallUp3(a5)
		bne.s	.WindowOk
		jsr	A5GetMainWindowHandle(a5)
		tst.l	d0
		beq.s	.WindowOk
		move.l	d0,a0
		move.l	DTG_Intuitionbase(a5),a6
		tst.w	Kick3On(a5)
		bne.s	.Use30
		lea	WaitPointer,a1
		moveq	#16,d0
		moveq	#16,d1
		moveq	#-6,d2
		moveq	#0,d3
		jsr	_LVOSetPointer(a6)
		bra.s	.WindowOk
.Use30:		lea	PointerTags(pc),a1
		jsr	_LVOSetWindowPointerA(a6)

.WindowOk:	moveq	#USClass_SetWaitPointer,d0
		jsr	A5SendeAllMessage(a5)
		jsr	A5DisableMenu(a5)

		move.w	#1,OnWaitMouse(a5)

.Return:	movem.l	(sp)+,d0-a6
		rts

PointerTags:	dc.l	$80000098,1,0


	*----------------------------------------------------*
	* Lscht den selbstdef. Mousepfeil in allen Windows -*
	*----------------------------------------------------*
ClearMouse2:	jsr	A5DecodeNames(a5)
ClearMouse:	movem.l	d0-a6,-(a7)
		tst.w	ClearMouseVerbot(a5)
		bne.s	.Return2
		tst.w	OnWaitMouse(a5)
		beq.s	.Return

	*------------- bei externem Gui -----------------*
		jsr	A5EnableMenu(a5)

		moveq	#USClass_ClearWaitPointer,d0
		jsr	A5SendeAllMessage(a5)

		move.l	#EUT_ClearWaitPointer,d0
		jsr	A5UserCallUp3(a5)
		bne.s	.Return
		jsr	A5GetMainWindowHandle(a5)
		tst.l	d0
		beq.s	.Return
		move.l	d0,a0
		move.l	DTG_Intuitionbase(a5),a6
		jsr	_LVOClearPointer(a6)

.Return:	clr.w	OnWaitMouse(a5)
.Return2:	movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
* Diese Routine sperrt die Menus/Gadgets des angegebenen Windows und setzt    *
* einen WaitPointer
* Input:a0=WindowHandle
*	a1=MenuAdr
*	a2=??
*Output:d0=Error oder NULL
EPP_SetWaitPointer:
		movem.l	d1-a6,-(a7)
		move.l	PufferAdr(pc),a5
		move.l	a0,a4
		move.l	a1,a3


		*---------- Menus sperren ----------*
		move.l	a4,d0
		beq.s	.Return
		move.l	d0,a0
		move.l	DTG_IntuitionBase(a5),a6
		jsr	_LVOClearMenuStrip(a6)

		move.l	a3,d0
		beq.s	.NoMenu
		move.l	d0,a1
.NextMenu:	bclr	#0,13(a1)
		move.l	(a1),d0
		move.l	d0,a1
		bne.s	.NextMenu

		move.l	a4,a0
		move.l	a3,a1
		jsr	_LVOSetMenuStrip(a6)


.NoMenu:

*		*--- Alle Gadgets removen ---*
*		lea	GadgetMerkPuffer(a5),a4
*		moveq	#GadgetAnz,d7
*.NextGadget:	move.l	(a4)+,d0
*		beq.s	.NoAdr
*		move.l	d0,a0
*		move.l	WinHandle(a5),a1
*		sub.l	a2,a2
*		lea	RemoveTags(pc),a3
*		move.l	GadToolsBase(a5),a6
*.NoAdr:		subq.l	#1,d7
*		bne.s	.NextGadget


		*------- WaitPointer setzen ------*
		move.l	a4,a0
		move.l	DTG_IntuitionBase(a5),a6
		tst.w	Kick3On(a5)
		bne.s	.Use30
		lea	WaitPointer,a1
		moveq	#16,d0
		moveq	#16,d1
		moveq	#-6,d2
		moveq	#0,d3
		jsr	_LVOSetPointer(a6)
		bra.s	.Return
.Use30:		lea	PointerTags(pc),a1
		jsr	_LVOSetWindowPointerA(a6)

.Return:	moveq	#0,d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
* Diese Routine sperrt die Menus/Gadgets des angegebenen Windows und setzt    *
* einen WaitPointer
* Input:a0=WindowHandle
*	a1=MenuAdr
*	a2=??
*Output:d0=Error oder NULL
EPP_ClearWaitPointer:
		movem.l	d1-a6,-(a7)
		move.l	PufferAdr(pc),a5
		move.l	a0,a4
		move.l	a1,a3


		*---------- Menus sperren ----------*
		move.l	a4,d0
		beq.s	.Return
		move.l	d0,a0
		move.l	DTG_IntuitionBase(a5),a6
		jsr	_LVOClearMenuStrip(a6)

		move.l	a3,d0
		beq.s	.NoMenu
		move.l	d0,a1
.NextMenu:	bset	#0,13(a1)
		move.l	(a1),d0
		move.l	d0,a1
		bne.s	.NextMenu

		move.l	a4,a0
		move.l	a3,a1
		jsr	_LVOSetMenuStrip(a6)


.NoMenu:

*		*--- Alle Gadgets removen ---*
*		lea	GadgetMerkPuffer(a5),a4
*		moveq	#GadgetAnz,d7
*.NextGadget:	move.l	(a4)+,d0
*		beq.s	.NoAdr
*		move.l	d0,a0
*		move.l	WinHandle(a5),a1
*		sub.l	a2,a2
*		lea	RemoveTags(pc),a3
*		move.l	GadToolsBase(a5),a6
*.NoAdr:		subq.l	#1,d7
*		bne.s	.NextGadget


		*------- WaitPointer setzen ------*
		move.l	a4,a0
		move.l	DTG_Intuitionbase(a5),a6
		jsr	_LVOClearPointer(a6)

.Return:	moveq	#0,d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts












	*----------------------------------------------------*
	*------- Removed alle Gadgets aus dem Window --------*
	*----------------------------------------------------*
DisableAll:	movem.l d0-a6,-(a7)
		jsr	A5ClearMenuStrip(a5)
		tst.w	GadgetsRemoved(a5)
		bne.s	.Return
		move.l	#EUT_DisableAll,d0
		jsr	A5UserCallUp3(a5)
		beq.s	.Return
		move.w	#1,GadgetsRemoved(a5)
.Return:	movem.l	(a7)+,d0-a6
JumpReturn:	rts


	*----------------------------------------------------*
	*-------- Added wieder alle Gadgets zum Window ------*
	*----------------------------------------------------*
EnableAll:	movem.l	d0-a6,-(a7)
		tst.w	EnableVerbot(a5)
		bne.s	.Return2
		jsr	A5SetMenuStrip(a5)
		tst.w	GadgetsRemoved(a5)
		beq.w	.Return
		move.l	#EUT_EnableAll,d0
		jsr	A5UserCallUp3(a5)
.Return:	clr.w	GadgetsRemoved(a5)
.Return2:	movem.l	(a7)+,d0-a6
		rts


	*--------------------------------*
	*--------- Set MenuStrip --------*
	*--------------------------------*
SetMenuStrip:	movem.l	d0-a6,-(a7)
		tst.w	MenuVerbot(a5)
		bne.s	.Return
		tst.w	RefreshMenuVerbot(a5)
		bne.s	.Return
		tst.w	EnableVerbot(a5)
		bne.s	.Return

		cmp.l	#Mode_Config,TestBits(a5)
		beq.s	.Return
		tst.l	WindowOffen(a5)
		beq.s	.Return

		tst.w	MenuOn(a5)
		bne.s	.MenuOk

		*-- externes Menu ---*
		move.l	#EUT_SetMenuStrip,d0
		jsr	A5UserCallUp3(a5)
		bne.s	.EngineMenuOk

		*-- internes Menu --*
		tst.w	MenuInitOk(a5)
		beq.s	.Return
		tst.l	MenuAdr(a5)
		beq.s	.Return
		move.l	DTG_Intuitionbase(a5),a6
		jsr	A5GetMainWindowHandle(a5)
		beq.s	.Return
		move.l	d0,a0
		lea	EM_ProjectMenu(a5),a1
		tst.w	SetMenuNew(a5)
		beq.s	.OnlyReset
		jsr	_LVOSetMenuStrip(a6)
		bra.s	.MenuOk
.OnlyReset	jsr	_LVOResetMenuStrip(a6)
.MenuOk:	clr.w	SetMenuNew(a5)
.EngineMenuOk:	move.w	#1,MenuOn(a5)
.Return:	movem.l	(a7)+,d0-a6			;Nicht ndern !!!
		rts

	*-----------------------------------------------*
	*------------- Clear Menu Strip ----------------*
	*-----------------------------------------------*
ClearMenuStrip:	movem.l	d0-a6,-(a7)
		tst.w	MenuOn(a5)
		beq.s	.NoWin
		tst.l	WindowOffen(a5)
		beq.s	.NoWin

		jsr	A5GetMainWindowTags(a5)
		move.l	#EUT_ClearMenuStrip,d0
		jsr	A5UserCallUp3(a5)
		bne.s	.NoWin

		tst.w	MenuInitOk(a5)
		beq.s	.NoWin
		move.l	DTG_IntuitionBase(a5),a6
		jsr	A5GetMainWindowHandle(a5)
		beq.s	.NoWin
		move.l	d0,a0
		jsr	_LVOClearMenuStrip(a6)		:Menu lschen
.NoWin:		clr.w	MenuOn(a5)
		movem.l	(a7)+,d0-a6
		rts

	*--------- Disable Menus ---------*
DisableMenu:	movem.l	d0/a1,-(a7)
		tst.w	MenuInitOk(a5)
		beq.s	.Return2

		tst.w	MenuDisabled(a5)
		bne.s	.Return

		*--- Alle Menus disablen ---*
		jsr	A5ClearMenuStrip(a5)
		lea	EM_ProjectMenu(a5),a1
.NextMenu:	bclr	#0,13(a1)
		move.l	(a1),d0
		move.l	d0,a1
		bne.s	.NextMenu
		jsr	A5SetMenuStrip(a5)

.Return:	move.w	#1,MenuDisabled(a5)
.Return2:	movem.l	(a7)+,d0/a1
		rts


	*--------- Disable Menus ---------*
EnableMenu:	movem.l	d0/a1,-(a7)

		tst.w	MenuInitOk(a5)
		beq.s	.Return

		tst.w	MenuDisabled(a5)
		beq.s	.Return

		*--- Alle Menus disablen ---*
		jsr	A5ClearMenuStrip(a5)
		lea	EM_ProjectMenu(a5),a1
.NextMenu:	bset	#0,13(a1)
		move.l	(a1),d0
		move.l	d0,a1
		bne.s	.NextMenu
		jsr	A5SetMenuStrip(a5)

.Return:	clr.w	MenuDisabled(a5)
		movem.l	(a7)+,d0/a1
		rts



*-----------------------------------------------------------------------------*
* Die Message des Engineguis wird ausgewertet. Dabei wird nur auf CloseWindow *
* Vanillakey & Menupick getestet-					      *
*									      *
* Input: a0=Nextselect or NULL						      *
*	 a1=Message oder NULL (z.Z die Adr fr NextItem)		      *
* Output:d0=EPNr oder NULL						      *
*	 d1=NextSelect							      *
*	 a1=Message oder NULL						      *
*	 d2/a2=Arg1							      *
*	 d3/a3=Arg2							      *
*-----------------------------------------------------------------------------*
GetEPNrfromMessage:
		movem.l	d4-d7/a1/a4-a6,-(a7)
		move.l	PufferAdr(pc),a5		*Defaults setzen
		moveq	#0,d0
		moveq	#0,d2
		moveq	#0,d3
		sub.l	a2,a2
		sub.l	a3,a3
		cmp.l	a1,d0
		bne.w	.TesteMessage
		move.l	a0,d5
		bra.w	.PDNextItem

	*--------------- Close the Window ----------------*
.TesteMessage:	move.l	20(a1),d7			*im_class
		move.w	24(a1),d5 			*im_code
		*move.l	28(a1),a0 			*im_Iaddress
		move.w	26(a1),d4			*im_qualifier
		cmp.l	#$200,d7			*CloseWindow
		bne	.TestVanillaKey
		move.w	#EPNr_Quit,d0
		bra.w	.rts


	*------------------- Vanillakey -------------------*
.TestVanillaKey:cmp.l	#$200000,d7			*VANILLAKEY
		bne	.TestRawkey
		moveq	#0,d3				;Shift gedrckt ?
		move.w	d5,d3				;dann beachten
		move.w	d4,d0
		and.w	#-4,d0
		cmp.w	d4,d0
		beq.s	.Va_NoShift
		cmp.w	#"a",d3
		blo.s	.Va_NoShift
		cmp.w	#"z",d3
		bhi.s	.Va_NoShift
		sub.w	#$20,d3
.Va_NoShift:	lea	.Va_AuswertTable-2(pc),a3
.Va_NextProggy:	addq.l	#2,a3
		move.b	(a3),d0
		beq.w	.Error
		cmp.b	d3,d0
		bne.s	.Va_NextProggy
		moveq	#0,d0
		move.b	1(a3),d0
		beq.w	.Error
		cmp.w	#EPNr_LockModule,d0
		beq.s	.ToggleKey
		cmp.w	#EPNr_Iconify,d0
		bne.s	.rts
.ToggleKey:	moveq	#-1,d2
		bra.s	.rts

.Va_AuswertTable:
		*dc.b	"p",EPNr_PlayerManager
		dc.b	"a",EPNr_LoadPlayer
		dc.b	"e",EPNr_LoadEngine
		dc.b	"i",EPNr_Iconify
;		dc.b	"h",EPNr_Hide		;nicht mehr bentigt...
		dc.b	"r",EPNr_RescanDir
		dc.b	"\",EPNr_LoadParentDir
		dc.b	"l",EPNr_LockModule
		dc.b	$1b,EPNr_Iconify	;EPNr_Hide
		dc.w	0
		even

	*------------------- Vanillakey -------------------*
.TestRawkey:	cmp.l	#$400,d7			*Rawkey
		bne	.TestPullDown
		cmp.b	#$5f,d5
		bne.s	.Error
		moveq	#EPNr_Help,d0
		moveq	#-1,d2
		bra.s	.Rts

	*----------------- Pull-Down-Menu -----------------*
.TestPullDown:	cmp.l	#$100,d7			*MenuPick
		bne	.Error
		tst.w	MenuInitOk(a5)
		beq.s	.Error
.PDNextItem:	move.l	d5,d0				* ItemAdr
		beq.s	.Error
		bsr	GetEPNrfromMenuItem		* In: a1=MenuItem
		bne.w	.pdrts				* Out: d0=NUll oder Nr

	*------------------ Keine Nummer -----------------*
.Error:		moveq	#0,d0				* keine Nummer
.Rts:		moveq	#0,d1				* NextSelect
.PDRts:		movem.l	(a7)+,d4-d7/a1/a4-a6
		tst.l	d0
		rts


*------- Die entsprechende EPNr aus dem Menu wird zusammengebastelt ----------*
* Input :d0=Itemid
* Output:d0=EPNr oder NULL
*	 d1=next Item
*	 d2/a2=Arg1
*	 d3/a3=Arg2	EPNr_FileReqMode=d0 d2=Nummer
GetEPNrfromMenuItem:
		move.l	d4,-(a7)

		move.w	d0,d5
		lea	EM_ProjectMenu(a5),a0
		move.l	DTG_IntuitionBase(a5),a6
		jsr	_LVOItemAddress(a6)
		moveq	#0,d1
		tst.l	d0
		beq.w	.Error
		move.l	d0,a0

		*--- Testen auf Engine-SubItem ---*
		move.w	d5,d2
		and.w	#$1f,d2
		cmp.w	#2,d2
		bne.s	.DochKeinEM

		move.w	EPMI_EPNr(a0),d3	*CommandoNr
		cmp.w	#EPNr_Engine,d3
		beq.s	.DochKeinEM

		swap	d3
		move.w	#0,d3				;Zustand des Hakens
		btst	#0,13(a0)			;ins higher Byte setzen
		beq.s	.Komm_NoAn
		btst	#0,12(a0)
		beq.s	.Komm_Noan
		move.w	#1,d3				;an
.Komm_NoAn:	swap	d3
		move.w	EPMI_NextSelect(a0),d1
		move.w	d5,d2
		and.w	#$7e0,d2		*Nummer des Engines im Menu
		lsr.w	#5,d2

		*-- Testen, ob gewhltes Menuitem ein Engine ist --*
		movem.l	a6/d2,-(a7)
		moveq	#2,d4
		jsr	A5GetMainWindowTags(a5)
		beq.s	.KeinGuiMenu
		move.l	d0,a6
		move.l	#EUT_GetGuiMenuStrip,d0
		jsr	A5FindTag2(a5)
		beq.s	.KeinGuiMenu
		moveq	#3,d4
.KeinGuiMenu:	movem.l	(a7)+,a6/d2
		cmp.w	d4,d2			*die ersten beiden Eintrge
		blt.s	.DochKeinEM

		move.l	EM_EngineMenu+EPHM_FirstItem(a5),a0
.NextMenu:	move.l	(a0),d0
		beq.w	.Error
		move.l	d0,a0
		subq.l	#1,d2
		bne.s	.NextMenu
		move.l	UPrgS_EngineNr-UPrgS_NextItem(a0),d2 ;UserNr
		beq.w	.Error
		move.w	#EPNr_EngineItemCommand,d0
		bra.w	.EngineSubItem2




.DochKeinEM:	moveq	#0,d2
		moveq	#0,d3
.KeinEngineMenu:moveq	#0,d0
		move.w	EPMI_EPNr(a0),d0		;EPNr.
		beq.w	.Normal


		*--- Arg setzen ---*
		moveq	#0,d2				;aus
		btst	#0,13(a0)			;berhaupt Haken ?
		beq.s	.NoAn				;--> nein
		btst	#0,12(a0)			;Haken gesetzt
		beq.s	.Noan
		moveq	#1,d2				;an


.NoAn:		cmp.w	#EPNr_Engine,d0
		bne.s	.NoEngine
		move.l	d2,d3
		move.l	UPrgS_EngineNr-UPrgS_NextItem(a0),d2		;UserNr
		bra.s	.Normal

.NoEngine:	move.w	#LNr_PM_UnCrunched,d4
		cmp.w	#EPNr_CrunchMode,d0
		beq.s	.NimmLocale

		move.w	#LNr_PM_NoNewModule,d4
		cmp.w	#EPNr_ProgramMode,d0
		beq.s	.NimmLocale

		move.w	#LNr_PM_CiaTiming,d4
		cmp.w	#EPNr_TimingMode,d0
		beq.s	.NimmLocale

		move.w	#LNr_PM_AutomaticWait,d4
		cmp.w	#EPNr_WaitingMode,d0
		beq.s	.NimmLocale

		move.w	#LNr_PM_AppIcon,d4
		cmp.w	#EPNr_IconifyMode,d0
		beq.s	.NimmLocale

		move.w	#LNr_PM_Req,d4
		cmp.w	#EPNr_FilerequesterMode,d0
		beq.s	.NimmLocale

		move.w	#LNr_PM_Voice1-1,d4
		cmp.w	#EPNr_Voices,d0
		bne.s	.TestIconify
		subq.l	#1,a2				;Volume unverndert
		move.l	d2,d3				;jetzt Arg2
		move.w	EPMI_LNr(a0),d2
		sub.w	d4,d2				;d2=Arg 1=appicon...
		cmp.w	#5,d2
		bne.s	.Normal
		moveq	#-1,d2
		move.w	#EP_MaxVolume,d3
		bra.s	.Normal

.TestIconify:	cmp.w	#EPnr_Play,d0
		beq.s	.Toggle
		cmp.w	#EPNr_Iconify,d0
		bne.s	.Normal
.Toggle:	moveq	#-1,d2				*Toggle
		bra.s	.Normal


		*--- D2 gibt den spez. Wert fr EPNr an ---*
.NimmLocale:	move.l	d2,d3				;jetzt Arg2
		move.w	EPMI_LNr(a0),d2
		sub.w	d4,d2				;d2=Arg 1=appicon...
.Normal:	move.w	EPMI_NextSelect(a0),d1
.EngineSubItem2:cmp.w	#$ffff,d1
		bne.s	.Error
		moveq	#0,d1
.Error:		move.l	(a7)+,d4
		tst.l	d0
		rts







*----------------------------------------------------------------------------*
* Die Modulesliste wird so weit wie mglich ins PD-Menu bernommen	     *
*----------------------------------------------------------------------------*
InitModulesMenu:movem.l	d0-a6,-(a7)
		bsr.w	FreeModulesTitle
		clr.l	ModulesFontAdr(a5)

		*---- Font von Disk laden -------*
		move.l	UMG_WinHandle(a5),d0
		beq.w	.Error
		move.l	d0,a1
		move.l	46(a1),a4			;ScreenAdr
		move.l	40(a4),a1			;default Fontadr
		move.w	4(a1),d0
		addq.w	#2,d0
		move.w	d0,ModulesFontHeight(a5)

		lea	ModulesFont(a5),a0
		move.l	(a0),d0
		bne.s	.DiskFontDa
.NimmDefFont:	move.l	40(a4),a1			;default Fontadr
.NimmUsedFont:	move.l	(a1),ModulesFontUsed(a5)
		move.w	4(a1),ModulesFontUsed+4(a5)
		bra.s	.NoDiskFont

.DiskFontDa:	move.w	4(a0),d3			;eingest. Hhe
		move.l	EPG_DiskFontBase(a5),d0
		beq.s	.NimmDefFont
		move.l	d0,a6
		jsr	_LVOOpenDiskFont(a6)
		move.l	d0,ModulesFontAdr(a5)
		tst.l	d0
		beq.s	.NimmDefFont
		addq.w	#2,d3
		move.w	d3,ModulesFontHeight(a5)
		lea	ModulesFont(a5),a1
		bra.s	.NimmUsedFont

.NoDiskFont:
		moveq	#0,d5
		move.w	14(a4),d5			;height of screen
		moveq	#0,d0
		move.b	30(a4),d0			;Hhe der Titleleiste
		sub.w	d0,d5
		subq.w	#4,d5				* fr ob/un Rand
		move.w	ModulesFontHeight(a5),d0	;Hhe des Fonts
		beq.w	.Error
		divu	d0,d5			;Anzahl der Mods per Menu
		and.l	#$ffff,d5
		cmp.w	#63,d5
		bls.s	.D5Ok
		moveq	#63,d5
.D5Ok:		cmp.w	#63,d5
		blo.s	.D5Ok2
		moveq	#63,d5
.D5Ok2:		*move.l	d5,MenuTiefe(a5)	* Anzahl der Eintrage per Menu

		move.l	EPG_Entries(a5),d4
		beq.w	.Error
		divu	d5,d4
		move.l	d4,d2
		swap	d2
		tst.w	d2
		beq.s	.MenuAnzOk
		addq.w	#1,d4
.MenuAnzOk:	ext.l	d4
		cmp.w	#27,d4
		ble.s	.D4Ok1
		moveq	#27,d4
.D4Ok1:

	*	moveq	#0,d2
	*	move.b	30(a4),d2		* TopPos fr 1.Item

		moveq	#0,d3
		move.w	12(a4),d3
		lea	EM_SpecialMenu(a5),a0
		moveq	#0,d6
		move.w	4(a0),d6		* -Left SpecialMenu
		add.w	8(a0),d6		* -Width SpecialMenu
		addq.l	#5,d6			* Kleinen Abstand zu Special
		sub.w	d6,d3
		move.l	d3,d0
		divu	d4,d3
		cmp.w	#15,d3
		bhi.s	.MinWidthOk
		moveq	#15,d3
		divu	d3,d0
		move.l	d0,d4			* Menuanz korrigieren
		*addq.l	#1,d4
.MinWidthOk:	cmp.w	#60,d3
		blo.s	.MaxWidthOK
		moveq	#60,d3

		*---- Width bei 1-2 Menus auf "Modules" anpassen ----*
.MaxWidthOK:	*addq.w	#1,d4			* max. Anzahl der Menus
	
		*---- Titlenamen zusammenbauen ----*
		LA0	LNr_ModulesTitle
		lea	ModulesTitlePuffer(a5),a1
		move.w	#ModulesTitlePufferSize-2,d1
		jsr	A5Stringcopy2(a5)
		move.l	a1,a0
		move.l	EPG_Entries(a5),d0
		jsr	A5Hexdez(a5)
		move.l	a0,a1
		LA0	LNr_Entry
		cmp.l	#1,EPG_Entries(a5)
		beq.s	.OnlyOneEntry
		LA0	LNr_Entries
.OnlyOneEntry:	jsr	A5StringCopy2(a5)
		cmp.w	#1,d4
		bne.s	.WidthOk

		lea	ModulesTitlePuffer(a5),a1
		move.l	UMG_WinHandle(a5),a0
		move.l	46(a0),a0			*Screen
		move.l	40(a0),d0
		beq.s	.WidthOk
		move.l	d0,TextPuffer+8(a5)
		lea	TextPuffer(a5),a0
		clr.l	(a0)
		clr.l	(a0)
		move.l	a1,12(a0)
		clr.l	16(a0)
		move.l	DTG_IntuitionBase(a5),a6
		jsr	_LVOIntuiTextLength(a6)
		addq.l	#8,d0
		move.l	d0,d1
		add.w	d6,d1				;Max
		move.l	UMG_WinHandle(a5),a0
		move.l	46(a0),a0			;ScreenAdr
		cmp.w	12(a0),d1
		bhi.s	.WidthOk
		move.l	d0,d3
.WidthOK:


	* d3=Width des Menus
	* d4=Anzahl der Menus
	* d5=Anzahl der Items per Menu
	* d6=LeftPos des Menus
	*---------------------------------
	* Workvaries:
	* a3=Menutitlestrukturen
	* a4=ModulesStrukturen
	* d6=max Breite der Items
	* d2=TopPos
		ext.l	d3
		ext.l	d4
		ext.l	d5
		tst.l	d5
		beq.w	.Error				*Keine Mods

		lea	EPG_FirstFileStruct(a5),a4
	*	lea	FirstModulesEintrag(a5),a4
		lea	EM_SpecialMenu(a5),a3
.NextMenu:	moveq	#EPHM_SizeOf,d0
		jsr	A5AllocMem(a5)
		beq.w	.Error
		move.l	d0,(a3)				*Verkettung
		move.l	d0,a3
		move.l	d5,d7
		moveq	#0,d2
		move.l	DTG_IntuitionBase(a5),a6
		movem.l	d6/a3,-(a7)
		move.l	d3,d6				*Breite der Items
	*	subq.l	#4,d6
		lea	EPHM_FirstItem(a3),a3
		bsr	.SetMenuPass1
		clr.l	(a3)				;alte Verkettung clren
		addq.l	#4,d6
		move.l	4(a7),a3
		lea	EPHM_FirstItem(a3),a3
	
		moveq	#0,d1
		move.l	UMG_WinHandle(a5),a0
		move.l	46(a0),a0			;ScreenAdr
		move.w	12(a0),d0			;Width
		sub.w	d6,d0
		sub.w	2(a7),d0			;d0=pos -> Platz da
		bhi.s	.LeftOk
		move.l	d0,d1
	*	subq.l	#1,d1
		subq.l	#8,d1
	*move.w	12(a0),d3
	*sub.w	2(a7),d3

.LeftOk:	bsr	.SetMenuPass2
		move.l	4(a7),a3
		move.w	d3,EPHM_Width(a3)		*Width
		cmp.l	d6,d3
		blo.s	.WidthMOk
		move.w	d6,EPHM_Width(a3)		*Width
.WidthMOk:	movem.l	(a7)+,d6/a3
		move.w	d6,EPHM_LeftEdge(a3)		*LeftPos
		move.w	d2,EPHM_Height(a3)		*Hhe merken
		move.w	#1,EPHM_Flags(a3)
		add.w	d3,d6

		lea	EmptyPuffer(a5),a0
		move.l	a0,EPHM_MenuName(a3)
		subq.l	#1,d4
		bne.w	.NextMenu
		lea	ModulesTitlePuffer(a5),a0
		move.l	EM_SpecialMenu(a5),a1
		move.l	a0,EPHM_MenuName(a1)
		bra.s	.OK


	*------------- Items in Menu setzen ------------*
	* Strukturen verketten und max Lenght berechnen *
.SetMenuPass1:	clr.l	(a3)				;alte Verkettung clren
		move.l	(a4),d0
		beq.s	.SetMenuPass1_3
		move.l	d0,a4

		move.w	FilesFarbe(a5),EFP_IT_FrontPen(a4)
		btst	#EFPF_FileName,EFP_Flags(a4)
		bne.s	.FileLookOk
		move.w	DirsFarbe(a5),EFP_IT_FrontPen(a4)
.FileLookOk:


		lea	EFP_MI_NextItem(a4),a0
		move.l	a0,(a3)
		move.l	a0,a3
		move.w	d2,EFP_MI_TopEdge(a4)		;TopPos
		move.w	ModulesFontHeight(a5),d0
		move.w	d0,EFP_MI_Height(a4)		;Height
		add.w	d0,d2
		lea	EFP_IT_FrontPen(a4),a0		;IText-Structure
		jsr	_LVOIntuiTextLength(a6)
		cmp.l	d6,d0
		blo.s	.SetMenuPass1_2
		move.l	d0,d6
.SetMenuPass1_2:subq.l	#1,d7
		bne.s	.SetMenuPass1
.SetMenuPass1_3:rts


		*--------- Item-Breite setzen ----------*
		* nur die Selectbreite der Items setzen *
.SetMenuPass2:	move.l	(a3),d0
		beq.s	.SetMenuPass1_3
		move.l	d0,a3
		move.w	d1,EPMI_LeftEdge(a3)		;Left
		move.w	d6,EPMI_Width(a3)		;Width
		bra.s	.SetMenuPass2

.Error:		bsr	FreeModulesTitle
.Ok:		move.l	ModulesFontAdr(a5),d0
		beq.s	.NoDiskFont2
		move.l	d0,a0
		move.l	DTG_GFXBase(a5),d0
		beq.s	.NoDiskFont2
		move.l	d0,a6
		jsr	_LVOCloseFont(a6)
.NoDiskFont2:	clr.l	ModulesFontAdr(a5)
		movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
FreeModulesTitle:
		movem.l	d0-a6,-(a7)
		jsr	A5ClearMenuStrip(a5)
		move.l	EM_SpecialMenu(a5),d4
.NextMenu:	beq.s	.NoMore
		move.l	d4,a1
		move.l	(a1),d4
		move.l	4,a6
		moveq	#EPHM_SizeOf,d0
		jsr	_LVOFreeMem(a6)
		tst.l	d4
		bra.s	.NextMenu
.NoMore:	clr.l	EM_SpecialMenu(a5)
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
FreeMenus:	bsr	FreeModulesTitle	*mit ClearMenuStrip

	*--------- Gui-Menu freigeben -------*
		move.l	EM_EngineMenu+EPHM_FirstItem(a5),d0
		beq.s	.NoGuiMenu
		move.l	d0,a0			*load engine
		move.l	(a0),d0
		beq.s	.NoGuiMenu
		move.l	d0,a0			*GuiMenu
		tst.l	EPMI_SubItem(a0)
		beq.s	.NoGuiMenu
		clr.l	(a0)			*NextPtr lschen
		move.l	#EUT_FreeGuiMenuStrip,d0
		jsr	A5UserCallUp3(a5)

.NoGuiMenu:	move.l	MenuAdr(a5),d0
		beq.s	.NoMenu
		move.l	d0,a1
		move.l	#MenuItemAnz*EPMI_SizeOf,d0
		Execbase
		jsr	_LVOFreeMem(a6)
.NoMenu:	clr.l	MenuAdr(a5)
		clr.w	MenuInitOk(a5)

		lea	EM_ProjectMenu(a5),a0
		move.w	#EM_MenuTitleSize-1,d0
.Clr:		clr.b	(a0)+
		dbf	d0,.Clr
		rts


*-----------------------------------------------------------------------------*
* Der Haken eines Engines wird gelscht.
* Input: a0=UPrgS_Struct
ClearEngineZustand:
		cmp.l	#0,a0
		beq.s	.Error

		move.l	a0,-(a7)
		move.l	UPrgS_EUSAdr(a0),a0
		cmp.l	#0,a0
		beq.s	.Error2
		bclr	#EUSF_Activate,EUS_Flags+1(a0)
.Error2:	move.l	(a7)+,a0

		tst.l	UPrgS_SubItem(a0)
		bne.s	.SubItems
		bclr	#0,UPrgS_Flags(a0)
.Error:		rts

.SubItems:	move.l	a0,-(a7)
		move.l	UPrgS_SubItem(a0),a0
		bclr	#0,12(a0)
		move.l	(a7)+,a0
		rts

*-----------------------------------------------------------------------------*
* Der Haken eines Engines wird gesetzt.
*-----------------------------------------------------------------------------*
SetEngineZustand:
		cmp.l	#0,a0
		beq.s	.Error

		move.l	a0,-(a7)
		move.l	UPrgS_EUSAdr(a0),a0
		cmp.l	#0,a0
		beq.s	.Error2
		bset	#EUSF_Activate,EUS_Flags+1(a0)
.Error2:	move.l	(a7)+,a0

		tst.l	UPrgS_SubItem(a0)
		bne.s	.SubItems
		bset	#0,UPrgS_Flags(a0)
.Error:		rts

.SubItems:	move.l	a0,-(a7)
		move.l	UPrgS_SubItem(a0),a0
		bset	#0,12(a0)
		move.l	(a7)+,a0
		rts




PD_FirstHoriAdd2 = 2			;\
PD_Verti_DazuAdd = 2			;Wert der der Fonthhe dazuaddiert wird
PD_Hori_DazuSub	= 10			;damit SubMenus nicht total neben den
					;anderen Menus hngen
PD_ITextHori	= 2


	
		

*-----------------------------------------------------------------------------*
* Das gesamte PD-Menu wird neu layoutet.
*-----------------------------------------------------------------------------*
RefreshMenu:	movem.l	d0-a6,-(a7)
		tst.w	MenuInitOk(a5)
		beq.w	.Return
		tst.w	RefreshMenuVerbot(a5)
		bne.w	.Return

		cmp.l	#Mode_Config,TestBits(a5)
		beq.w	.Return

		jsr	A5GetMainWindowHandle(a5)
		beq.w	.Return
		move.l	d0,a0
		jsr	A5ClearMenuStrip(a5)
		move.l	46(a0),a0			;ScreenAdr
		sub.l	a1,a1
		move.l	DTG_GadToolsbase(a5),a6
		jsr	_LVOGetVisualInfoA(a6)
		move.l	d0,a4
		move.l	d0,a1
		tst.l	d0
		beq.w	.Return

		moveq	#62,d1				;Anz -2
		lea	EPG_FirstUserStruct(a5),a2
		move.l	EM_EngineMenu+EPHM_FirstItem(a5),a0 Add Engine
		move.l	(a0),a0				*GuiMenu oder Barl
		tst.l	EPMI_SubItem(a0)
		beq.s	.NextEngine
		move.l	(a0),a0
		subq.w	#1,d1
.NextEngine:	clr.l	(a0)	;alten NextPtr lschen ;;##!!##?? Crash !
				;passiert bei mir jedes Mal, wenn ich
				;den 8 Bit Amplifier debugge und das 2.
				;Mal starte. Scheint auch das Problem zu
				;sein, dass EP beim Start ab und zu
				;hngenbleibt !
		subq.l	#1,d1
		beq.s	.NoMoreEngines
		move.l	(a2),d0
		beq.s	.NoMoreEngines
		move.l	d0,a2
		move.l	UPrgS_UFlags(a2),d0
		btst	#UPrgF_Disabled,d0
		bne.s	.NextEngine
		lea	UPrgS_NextItem(a2),a3
		move.l	a3,(a0)
		move.l	a3,a0
		bra.s	.NextEngine

.NoMoreEngines:	bsr.w	FreeModulesTitle

	*--------- Menufont setzen --------*
		moveq	#0,d6
		lea	.MenuTags+8(pc),a2
		clr.l	(a2)			*Tag
		clr.l	4(a2)			*Tagwert
		tst.b	MenuFontPuffer(a5)
		beq.s	.NoMenuFont
		tst.l	MenuFont(a5)
		beq.s	.NoMenuFont
		tst.w	MenuFont+4(a5)
		beq.s	.NoMenuFont

	*---------- Font ffnen ----------*
		lea	Menufont(a5),a0
		clr.w	6(a0)
		move.l	EPG_DiskFontbase(a5),d0
		beq.s	.NoMenuFont
		move.l	d0,a6
		jsr	_LVOOpenDiskFont(a6)
		move.l	d0,d6
		beq.s	.NoMenufont

		lea	MenuFont(a5),a0
		move.l	#$80080031,(a2)		*def Font
		move.l	a0,4(a2)
.NoMenuFont:	lea	EM_ProjectMenu(a5),a0
		clr.l	EM_SpecialMenu(a5)		;Ptr zu Modulesmenu
		lea	.MenuTags(pc),a2
		move.l	a4,a1
		move.l	DTG_GadToolsbase(a5),a6
		jsr	_LVOLayoutMenusA(a6)

		move.l	a4,a0
		move.l	DTG_GadToolsbase(a5),a6
		jsr	_LVOFreeVisualInfo(a6)

		*--------- Menufont closen ---------*
		move.l	d6,d0
		beq.s	.NoFont2
		move.l	d0,a1
		move.l	DTG_GFXBase(a5),d0
		beq.s	.NoFont2
		move.l	d0,a6
		jsr	_LVOCloseFont(a6)

	*--- Front/BackPen fr ModulesMenu rauskriegen -----*
.NoFont2:	lea	EM_ProjectMenu(a5),a0
		move.l	18(a0),a0			;FirstItem
		move.l	18(a0),a0
		move.w	(a0),d0				;Font&BackPen

		move.w	d0,FilesFarbe(a5)

		move.w	#$302,DirsFarbe(a5)
		cmp.b	#2,d0
		bne.s	.DirVorderOk
		move.w	#$103,DirsFarbe(a5)

.DirVorderOk:	bsr.w	InitModulesMenu

		addq.w	#1,MenuVerbot(a5)
		move.w	#EPNr_TimingMode,d0
		jsr	A5SetMutalExclude(a5)
		move.w	#EPNr_WaitingMode,d0
		jsr	A5SetMutalExclude(a5)
		move.w	#EPNr_ProgramMode,d0
		jsr	A5SetMutalExclude(a5)
		move.w	#EPNr_CrunchMode,d0
		jsr	A5SetMutalExclude(a5)
		move.w	#EPNr_FileRequesterMode,d0
		jsr	A5SetMutalExclude(a5)
		move.w	#EPNr_IconifyMode,d0
		jsr	A5SetMutalExclude(a5)
		move.w	#EPNr_Voices,d0
		jsr	A5SetMutalExclude(a5)
		subq.w	#1,MenuVerbot(a5)

		move.w	#1,SetMenuNew(a5)
		jsr	A5SetMenuStrip(a5)
.Return:	movem.l	(a7)+,d0-a6
		rts


.MenuTags:	dc.l	$80080043,1		;newlockmenus
		dc.l	0,0			;GTMN_TextAttr
		dc.l	0		*## Achtung Fontsetzung ###



*-----------------------------------------------------------------------------*
* Setzt von der angegebenen EPNr das Menu richtig (wegen Mutalexclude)	      *
* Input: d0=EPNr							      *
*-----------------------------------------------------------------------------*
SetMutalExclude:
	*movem.l	d0-a6,-(a7)
		move.l	d0,d3
		jsr	A5GetMainWindowHandle(a5)
		beq.w	.NoWindow
		move.l	d3,d0
		jsr	A5GetMenuItemAdr(a5)	;d0=Error oder NULL
		bne.w	.NoWindow
		moveq	#EPNrF_MaxId,d2
		move.b	FileReqMode(a5),d1
		cmp.w	#EPNr_FileRequesterMode,d3
		beq.s	.OkThis

		moveq	#EPNrC_MaxId,d2
		move.b	CrunchMode(a5),d1
		cmp.w	#EPNr_CrunchMode,d3
		beq.s	.OkThis

		moveq	#EPNrW_MaxId,d2
		move.b	WaitingMode(a5),d1
		cmp.w	#EPNr_WaitingMode,d3
		beq.s	.OkThis

		moveq	#EPNrT_MaxId,d2
		move.b	TimingMode(a5),d1
		cmp.w	#EPNr_TimingMode,d3
		beq.s	.OkThis

		moveq	#EPNrP_MaxId,d2
		move.b	ProgrammMode(a5),d1
		cmp.w	#EPNr_ProgramMode,d3
		beq.s	.OkThis

		moveq	#EPNrI_MaxId,d2
		move.b	IconifyMode(a5),d1
		cmp.w	#EPNr_IconifyMode,d3
		beq.s	.OkThis

		cmp.w	#EPNr_Voices,d3
		bne.s	.NoWindow
		jsr	A5ClearMenuStrip(a5)
		lea	InternVoicePuffer+EP_MaxVoices(a5),a1
		moveq	#3,d1
.SetVoices:	addq.l	#1,a1
		move.b	(a1)+,d2
		bclr	#0,12(a0)
		or.b	d2,12(a0)
		move.l	(a0),d0
		beq.s	.SetMenu
		move.l	d0,a0
		dbf	d1,.SetVoices
		bra.s	.SetMenu






.OkThis:	move.l	a0,a1
.Schleif:	tst.b	d1
		beq.s	.ThisItem
		move.l	(a0),d0
		beq.s	.NoWindow
		move.l	d0,a0
		subq.b	#1,d1
		bra.s	.Schleif
.ThisItem:	btst	#0,12(a0)		;bereits gesetzt
		bne.s	.NoWindow

	*----- Setzte das eine Item und lsche die anderen -----*
		jsr	A5ClearMenuStrip(a5)
		bset	#0,12(a0)
.ClrNextItem:	cmp.l	a0,a1
		beq.s	.NoClrIt
		bclr	#0,12(a1)
.NoClrIt	move.l	(a1),d0
		beq.s	.SetMenu
		move.l	d0,a1
		subq.b	#1,d2
		bge.s	.ClrNextItem
.SetMenu:	jsr	A5SetMenuStrip(a5)

.NoWindow:	*movem.l	(a7)+,d0-a6
		rts
		


*-----------------------------------------------------------------------------*
*-----------------------------------------------------------------------------*
* Flags =	$01	=	Switch On/Off				      *
*		$02	=	Abgehackt				      *
*		$04	=	\					      *
*		$08	=	 - Anzahl der folgende Items fr MutalExclude *
*		$10	=	/					      *
*		$20	=	Barlabel				      *
*		$40	=	Neues SubMenu				      *
*		$80	=	Ende des Menus				      *
*-----------------------------------------------------------------------------*
* Die ActionNummer und die LocaleNummer entsprechen der jeweiligen Nummer     *
* Ausnahme: 0 = Keine Action						      *
*-----------------------------------------------------------------------------*
InitMenus:	movem.l	d1-a6,-(a7)

		tst.w	MenuInitOk(a5)
		bne.w	.Return2

		move.l	MenuAdr(a5),d0
		bne.s	.MenuAdrOk
		move.l	#MenuItemAnz*EPMI_SizeOf,d0
		jsr	A5Allocmem(a5)
		move.l	d0,MenuAdr(a5)
		bne.s	.MenuAdrOk
		moveq	#EPR_NotEnoughMem,d0
		bra.w	.Return3

		*---- Im Merkpuffer initialisieren -----*
.MenuAdrOk:	lea	EM_ProjectMenu(a5),a1
		move.w	#LNr_PM_ProjectTitle,EPHM_LocaleNr(a1)
		move.w	#LNr_PM_CommandTitle,EPHM_LocaleNr+(EM_CommandMenu-EM_ProjectMenu)(a1)
		move.w	#LNr_PM_EngineTitle,EPHM_LocaleNr+(EM_EngineMenu-EM_ProjectMenu)(a1)
		move.w	#LNr_PM_SpecialTitle,EPHM_LocaleNr+(EM_SpecialMenu-EM_ProjectMenu)(a1)
		lea	EM_CommandMenu(a5),a0
		move.l	a0,(a1)
		lea	EM_EngineMenu(a5),a1
		move.l	a1,(a0)
		lea	EM_SpecialMenu(a5),a0
		move.l	a0,(a1)


		lea	EM_ProjectMenu(a5),a4
		move.l	MenuAdr(a5),a3
		lea	MenuItems,a2
		moveq	#0,d7				;Nr-Zhler
		moveq	#3,d6				:Menus zhlen
.NextHMenu:	move.l	a3,EPHM_FirstItem(a4)		;First Item
		move.w	#1,EPHM_Flags(a4)		;Flags setzen
		move.l	d6,-(a7)
		bsr.s	.NeuesMenu
		move.l	(a7)+,d6

		move.w	EPHM_LocaleNr(a4),d0
		jsr	A5GetLocaleString(a5)
		move.l	a0,EPHM_MenuName(a4)

		move.l	EPHM_NextMenu(a4),d0
		beq.w	.Return2
		move.l	d0,a4
		dbf	d6,.NextHMenu
.Return2:

		*---- GuiMenu einfgen -----*
		moveq	#-1,d3
		move.l	#EUT_GetGuiMenuStrip,d0
		jsr	A5UserCallUp3(a5)
		tst.l	d2
		beq.s	.NoGuiMenu
		tst.l	d0
		bne.s	.NoGuiMenu
		move.l	EM_EngineMenu+EPHM_FirstItem(a5),a1	*Add engine
		*move.l	(a1),a1					*Barlabel
		move.l	(a1),(a0)		*nach Barlabel Gui Menu
		move.l	a0,(a1)			*Verkettung setzen

.NoGuiMenu:	moveq	#0,d0	
		move.w	#1,MenuInitOk(a5)
.Return3:	movem.l	(a7)+,d1-a6
		tst.l	d0
.Return:	rts





	*------------------ Fr Haupt und Untermenus ----------------*
.NeuesMenu:	moveq	#-1,d6				;Itemzhler im Menu
		moveq	#0,d5				;Rckwrtszhler
.NextItem:	addq.l	#1,d6				;1 Item mehr
		cmp.w	#64,d6
		beq.s	.Return
		moveq	#$52,d0				;Text/Enabled
		moveq	#0,d1
		move.b	MEP_Flags(a2),d1			;Flags
		btst	#5,d1
		beq.s	.NoBarLabel
		move.w	#$c0,EPMI_Flags(a3)
		move.l	#$00020002,EPMI_ITFrontPen(a3)
		move.w	#$2,EPMI_ITTopEdge(a3)		;Left=Breite Top=Hhe
		move.l	#1,EPMI_ITIText(a3)
		bra.w	.BarLabelFertig

.NoBarlabel:	tst.b	1(a2)				;Charakter
		beq.s	.NoCharakter
		or.w	#4,d0				;Charakter setzen
.NoCharakter:	move.w	#PD_ITextHori,EPMI_ITLeftEdge(a3)
		btst	#0,d1
		beq.s	.NoAbgehakt1
		or.w	#9,d0				;abhacken
		add.w	#18,EPMI_ITLeftEdge(a3)
.NoAbgehakt1:	btst	#1,d1
		beq.s	.NoAbgehakt2
		or.w	#$108,d0			;abhacken
.NoAbgehakt2:	move.w	d0,EPMI_Flags(a3)		;Flags setzen
		move.b	MEP_TCode(a2),EPMI_Command(a3)
		clr.w	EPMI_EPNr(a3)

		*--- auf Keyfile testen ---*
		moveq	#0,d0
		move.b	MEP_ActionNr(a2),d0
*	cmp.b	#EPNR_SaveT,d0
*	bne.s	.k
*	nop
.k		move.b	d0,EPMI_EPNr+1(a3) ;ActionNr setzen

* Da auf das Sperren der Funktionen verzichtet wurde, sind die folgenden
* 9 Zeilen disabled
* NEWR
;		beq.s	.KeyDa_Weiter
;		tst.b	KeyOn(a5)
;		bne.w	.KeyDa_Weiter
;		mulu	#EPRT_SizeOf,d0
;		lea	Kommandotabelle-EPRT_SizeOf,a0
;		move.b	EPRT_Flags(a0,d0.w),d0
;		btst	#EPRTF_Key,d0
;		beq.s	.KeyDa_Weiter
;		bclr.b	#4,EPMI_Flags+1(a3)
.KeyDa_Weiter:


*		*--- aktuellen Zustand setzen ---*
*		mulu	#EPRT_SIzeOf,d0
*		lea	Kommandotabelle-EPRT_SizeOf,a0
*		lea	(a0,d0.w),a0
*		btst	#0,d1
*		beq.s	.NoAbg2
*		move.w	EPRT_Status(a0),d0
*		beq.s	.NoAbg2
*		move.b	(a5,d0.w),d5		*Mode
*		move.l	d1,-(a7)
*		ror.l	#2,d1
*		and.w	#7,d1
*		bne.s	.NoAbg3
*	*	beq.s	.SetNoMutal
*	*.SetNoMutal:
*		tst.b	d5
*		beq.s	.NoAbg3
*		bset	#0,EPMI_Flags(a3)
*.NoAbg3:	move.l	(a7)+,d1
*
*

.NoAbg2:	moveq	#0,d0
		move.b	MEP_LocaleNr(a2),d0
		beq.s	.NoLocaleString
		add.w	#LNr_PM_ProjectTitle,d0
		cmp.w	#LNr_PM_LastMenuItem,d0
		bhs.s	.NoLocaleString
		move.w	d0,EPMI_LNr(a3)
		jsr	A5GetLocaleString(a5)
		move.l	a0,EPMI_ITIText(a3)		;LocaleString speichern

	*-------------------- MutalExclude -----------------*
.NoLocaleString:
		ror.l	#2,d1
		and.w	#7,d1
		beq.s	.NoNewMutal1
		ext.l	d1
		move.l	d1,d5				;Anz der Excludes
		subq.w	#1,d5
		moveq	#0,d1
		moveq	#-1,d0
.SetzeBits:	addq.l	#1,d0
		bset	d0,d1
		dbf	d5,.SetzeBits
		move.l	d1,d5
		rol.l	d6,d5				;Jetzt die richtige
.NoNewMutal1:	tst.w	d5				;Maske in d5
		beq.s	.NoNewMutal2
		btst	d6,d5
		beq.s	.NoMoreExcludes
		bclr	d6,d5
		move.l	d5,EPMI_MutualExclude(a3)
		bclr.b	#3,EPMI_Flags+1(a3)
		bset	d6,d5
		bra.s	.NoNewMutal2

	*--------- IText-Struktur vorinitialisieren --------*
.NoMoreExcludes:moveq	#0,d5
.NoNewMutal2:	move.b	MEP_Flags(a2),d1			;Flags
		move.l	#$01030000,EPMI_ITFrontPen(a3)	;FrontP,BackP,DrawMode
		move.w	#1,EPMI_ITTopEdge(a3)
.BarLabelFertig:lea	EPMI_ITFrontPen(a3),a0
		move.l	a0,EPMI_ItemFill(a3)
		move.w	#$ffff,EPMI_NextSelect(a3)
		tst.w	Kick3On(a5)
		bne.s	.NoKick30_1
		clr.b	EPMI_ITFrontPen(a3)		;Farbe fr 1.3 setzen
.NoKick30_1:	lea	EPMI_SizeOf(a3),a3
		lea	MEP_SizeOf(a2),a2
		btst	#6,d1
		bne.s	.SubMenu
		btst	#7,d1				;Ende des Menus
		bne.w	.Return
		move.l	a3,EPMI_NextItem-EPMI_SizeOf(a3)
		bra.w	.NextItem

.SubMenu:	movem.l	d1/d5/d6/a3/a4,-(a7)
		move.l	a3,EPMI_SubItem-EPMI_SizeOf(a3)	;SubZeiger in vorherige
		bsr.w	.NeuesMenu			;Struckture setzen
		movem.l	(a7)+,d1/d5/d6/a0/a4
		btst	#7,d1				;Ende des HMenus
		bne.w	.Return
		move.l	a3,EPMI_NextItem-EPMI_SizeOf(a0)
		bra.w	.NextItem


*-----------------------------------------------------------------------------*
* Bei Unregistriertem Eagleplayer werden die EPNr, die in der Tabelle angegeben*
* sind, nicht erlksaubt




	*------------------------------------------------------------*
	*----------------- Decrunch-Routine einbinden ---------------*
	*------------------------------------------------------------*
		Include	"EP_Decrunch.s"
		even
Pufferadr2:	dc.l	0



	***************************************************
	***** Include-Datei "EP_ModuleChange.S" laden *****
	***************************************************
		include	"EP_ModuleChange.S"




*--------- Lade Players (path in a0) und copiere Path nach PlayersDir ------*
LoadPlayers:	lea	PlayersDir(a5),a1
		move.w	#DirPufferSize-2,d1
		jsr	A5StringCopy2(a5)
LoadPlayers2:	lea	PlayersDir(a5),a1
		jsr	A5HoleLock(a5)
		beq.w	.Return

		jsr	_LVOCurrentDir(a6)
		move.l	d0,OldPlDir(a5)
		lea	Infoblock(a5),a0
		move.l	d7,d1
		move.l	a0,d2
		jsr	_LVOExamine(a6)
		addq.l	#1,d0
		tst.l	d0
		bne.w	.LoadEnde

		jsr	A5AddAbortGadget(a5)
		jsr	A5WaitMouse(a5)

		La0	LNr_SW_AddPlayer
		jsr	A5PrintText(a5)

	*------- Recursive Player LoadRoutine -------*
.NextPlayer:	move.w	#1,ClearMouseVerbot(a5)
		jsr	A5GetAbortMsg(a5)
		bne.s	.LoadEnde
		tst.l	d1
		bne.s	.LoadEnde

		lea	Infoblock(a5),a0
		move.l	a0,d2
		move.l	d7,d1
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOExNext(a6)
		tst.l	d0
		beq.w	.LoadEnde
		moveq	#-1,d6
		cmp.l	d6,d0			;andere Fehlermeldung als -1
		bne.s	.NextPlayer

	*	move.w	#1,ScrollVerbot(a5)
		jsr	A5LoadPlayer(a5)
	*	clr.w	ScrollVerbot(a5)
		tst.l	d0
		beq.s	.NextPlayer

		addq.w	#1,PlayerAnz(a5)
		addq.l	#1,ScanPlayerAnz(a5)
		bra.s	.NextPlayer

.LoadEnde:	jsr	A5RemoveAbortGadget(a5)
		clr.w	ClearMouseVerbot(a5)

	*------------- Userprogramme benachrichten --------------*
		moveq	#USClass_NewPlayer,d0
		jsr	A5SendeAllMessage(a5)

		jsr	A5ClearMouse(a5)
		move.l	OldPlDir(a5),d1
		jsr	A5SetOldDir2(a5)
		moveq	#1,d0
.Return:	rts



*-------------------------------- Name nach a1 ------------------------------*
HoleLock:	move.l	a1,d1
		move.l	a1,-(a7)
		move.l	DTG_Dosbase(a5),a6
		moveq	#-2,d2
		jsr	_LVOLock(a6)
		move.l	(a7)+,a1
		move.l	d0,d7
		move.l	d0,d1
		rts

*------------------------------ Gebe Lock in d1 zurck ---------------------*
FreeLock:	movem.l	d0-a6,-(a7)
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOUnLock(a6)
		movem.l	(a7)+,d0-a6
		moveq	#0,d1
		rts

*-------------------- Setze Dir-Zeiger auf alten Wert ---------------------*
SetOldDir:	move.l	OldDir(a5),d1
SetOldDir2:	tst.l	d1
		beq.s	SetNoDir
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOCurrentDir(a6)
		move.l	d0,d1
		jsr	_LVOUnLock(a6)
		clr.l	OldDir(a5)
SetNoDir:	rts



*---------------------------- Libraries schlieen ----------------------------*
CloseLib:	move.l	(a0),d0
		beq.s	SetNoDir
		clr.l	(a0)
		move.l	d0,a1
		ExecBase
		jmp	_LVOCloseLibrary(a6)

*------------------------ Libraries ffnen d0=Versionsnummer -----------------*
OpenLib:	movem.l	d1-a6,-(a7)
		move.l	d0,d1
		move.l	(a3),d0
		bne.s	.NoOpen
		move.l	d1,d0
		ExecBase
		jsr	_LVOOpenLibrary(a6)
.NoOpen:	move.l	d0,(a3)
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

ToScrollNewFehler2:
		jmp	A5ScrollNewFehler(a5)
FunctionAborted2:moveq	#EPR_Functionaborted,d0
		jmp	A5ScrollNewFehler(a5)

*---------------------------------------------------------------------------*
DecodeNames:	lea	at,a3
		moveq	#5,d7

	*----------- Info-Text printen ------------*
.NextString:	lea	TextPuffer(a5),a1
		move.l	Key_Struct-TextPuffer(a1),d0
	if	Betaversion
		beq.w	.DisableIt
	else
		beq.w	.NoStruct
	endc
		move.l	d0,a4
		move.w	8(a3),d0			;DecodeOffset laden
		lea	(a4,d0),a2
		lea	Code-TextPuffer(a1),a1
		move.b	(a2),(a1)			;Code(a5)
		move.b	1(a2),CodePara1-Code(a1)	
		move.b	2(a2),CodePara2-Code(a1)
		move.b	3(a2),CodePara3-Code(a1)
		move.b	4(a2),CodePara4-Code(a1)

	*---- String decodieren ----*
		move.w	(a3),d0				;Offset holen
		move.w	(a4,d0),d0			;Offset von a4-Start
		lea	(a4,d0.w),a0

		moveq	#0,d1
		move.w	2(a3),d1			;Size laden
		move.w	(a4,d1),d1
		beq.s	.NoSize

		lea	(a0,d1.w),a0			;Ende des Strings
		move.w	6(a3),d2
		lea	(TextPuffer-1652)-Code(a1),a1
		lea	(a1,d2.w),a1

		lsr.l	#1,d1
		subq.w	#1,d1
		moveq	#0,d2

.EntcodeString:	moveq	#0,d0
		move.b	-(a0),d0
		jsr	A5DecodeD0(a5)
		add.w	d0,d2
		move.b	d0,(a1)+
		moveq	#0,d0
		move.b	-(a0),d0
		jsr	A5DecodeD0(a5)
		add.w	d0,d2
		dbf	d1,.EntcodeString

		clr.b	(a1)				;End of string

		move.w	4(a3),d1
		move.w	(a4,d1.w),d1			;ChkSumme laden
		cmp.w	d1,d2
		bne.w	.NoSize
		lea	TextPuffer(a5),a1
		clr.l	KeyFault-TextPuffer(a1)
.NoSize:	moveq	#10,d0
		add.l	d0,a3
		dbf	d7,.NextString

	*------- Registrations-Nr printen ------*
		lea	TextPuffer(a5),a0
		move.l	EPKF_RegNr2(a4),d1
		eor.l	#$ef54689e,d1
		move.l	EPKF_RegNr(a4),d0
		cmp.l	d0,d1
	;	bne.w	.ChkSumError
	;	move.l	EPKF_RegNr3(a4),d1
	;	eor.l	#$af56681e,d1
	;	cmp.l	d0,d1
		bne.w	.ChkSumError

		jsr	A5TestAufDisabledKeys(a5)
		move.l	d0,KeyDisabled-TextPuffer(a0)
		beq.s	.Ok
.ChkSumError:	clr.l	Keyfault-TextPuffer(a0)
.Ok:		move.l	d1,(ARegisterTable+6*4)-TextPuffer(a0)	;Key Nummer
		tst.l	d1
		bne.s	.NoStruct

*	if	Betaversion
*		lsl.l	#1,d1
*		move.l	#(KeyNummer<<1)+3000,d2
*		add.l	#3000,d1
*		cmp.l	d2,d1
*		beq.s	.NoStruct
.DisableIt:	lea	TextPuffer(a5),a0
		move.l	#1,KeyDisabled-TextPuffer(a0)
*	endc

.NoStruct:	moveq	#0,d0
		rts


*------------------------ CrunchMode festlegen -----------------------------*
SetCrunchMode:	move.b	d2,CrunchMode(a5)
		moveq	#EPNR_CrunchMode,d0
		jsr	A5SetMutalExclude(a5)
		move.b	CrunchMode(a5),d2
		ext.w	d2
		add.w	#LNr_Uncrunched,d2
		move.l	d2,d0
		jmp	A5ScrollNew(a5)


*------------------------------ Set Timing-Mode -----------------------------*
SetTimingMode:	cmp.b	TimingMode(a5),d2
		beq.s	.NoPlay2
		move.b	TimerOn(a5),d1
		beq.s	.NoPlay
		jsr	A5StopInterrupt(a5)
.NoPlay:	move.b	d2,TimingMode(a5)
		tst.b	d1
		beq.s	.NoPlay2
		jsr	A5StartInterrupt(a5)
.NoPlay2:	moveq	#EPNR_TimingMode,d0
		jsr	A5SetMutalExclude(a5)
		move.b	TimingMode(a5),d0
		ext.w	d0
		add.w	#LNr_CiaTiming,d0
		jmp	A5ScrollNew(a5)

*----------------------------- Set Waiting-Mode -----------------------------*
SetWaitingMode:	move.b	d2,WaitingMode(a5)
		moveq	#EPNR_WaitingMode,d0
		jsr	A5SetMutalExclude(a5)
		move.b	WaitingMode(a5),d0
		ext.w	d0
		add.w	#LNr_AutomaticWait,d0
		jmp	A5ScrollNew(a5)


*--------------------------------------------------------------------------*
SetDBFLoops:	cmp.l	#MaxDBFLoops,d2
		bhi.w	FunctionAborted2
		tst.l	d2
		beq.w	FunctionAborted2
		move.l	d2,DBFLoops(a5)
		move.l	d2,ScrollArgs(a5)
		LA0	LNr_DBFLoops
		jmp	A5ScrollNewText(a5)


*--------------------------------------------------------------------------*
SetRasterLines:	cmp.l	#MaxRasterLines,d2
		bhi.w	FunctionAborted2
		tst.l	d2
		beq.w	FunctionAborted2
		move.l	d2,RasterLines(a5)
		move.l	d2,ScrollArgs(a5)
		LA0	LNr_RasterLines
		jmp	A5ScrollNewText(a5)


;****************************************************************
;*  		Hex-Dez-Routine fr Hexwerte bis 32-Bit		*
;* a0 = Puffer d0=Hexzahl (Hide Null) 				*
;****************************************************************
Hexdez2:	move.l	a1,a0
		bsr.b	Hexdez
		move.l	a0,a1
		rts
Hexdez:		tst.l	d0
		beq.s	.TypeNull
		movem.l	d0-d4/a1,-(a7)
		lea	hexdeztab(pc),a1
		moveq	#0,d4
		moveq	#9,d3
.HexDez1:	move.l	(a1)+,d1
		moveq	#0,d2
.HexDez2:	addq.l	#1,d2
		sub.l	d1,d0
		bcc.s	.Hexdez2
		add.l	d1,d0
		add.b	#$2f,d2
		cmp.b	#$30,d2
		bne.s	.Printealle
		tst.b	d4
		beq.s	.PrinteNoZiffer
.Printealle:	moveq	#1,d4
		move.b	d2,(a0)+
.PrinteNoZiffer:dbf	d3,.Hexdez1
		clr.b	(a0)
		movem.l	(a7)+,d0-d4/a1
		rts
.TypeNull	move.b	#$30,(a0)+
		clr.b	(a0)
		rts
		
;****************************************************************
;*  		Dez-Hex-Routine fr Hexwerte bis 32-Bit		*
;* a0 = Puffer d0=Anzahl der Zeichen 				*
;****************************************************************
DezHex:		movem.l	d1-d3/a0/a1,-(a7)
		moveq	#10,d1
		sub.l	d0,d1
		add.l	d1,d1
		add.l	d1,d1
		lea	Hexdeztab(pc),a1	;Hilfstabelle-Adresse nach a0
		add.l	d1,a1
		move.l	d0,d3			;10 Stellen
		subq.l	#1,d3
		blt.s	.DezFehler
		moveq	#0,d1			;Vorsichtshalber lschen
		moveq	#0,d0			;Vorsichtshalber lschen
.DezHex2:	moveq	#0,d1
		move.b	(a0)+,d1		;Wert rauslesen
		beq.s	.DezHex7
		cmp.b	#$39,d1
		bgt.s	.DezFehler
		sub.b	#$30,d1			;Ascii-Offset wegaddieren
		bvs.s	.DezFehler

		moveq	#0,d2
		subq.l	#1,d1
		blt.s	.NoAdd
.MuluSimu:	add.l	(a1),d2		;Wert aus der Tabelle laden
	;	mulu	d1,d2			;multiplizieren
		dbf	d1,.MuluSimu


.NoAdd:		add.l	d2,d0			;zu d0 addieren
		addq.l	#4,a1
		dbf	d3,.Dezhex2
.DezHex7:	moveq	#1,d4
.DezEnd:	movem.l	(a7)+,d1-d3/a0/a1
		tst.l	d4
		rts
.DezFehler:	moveq	#0,d4
		moveq	#0,d0
		bra.s	.DezEnd

	*-------- Hilfstabelle fr Hex-Dez-Umwandelung --------*
Hexdeztab:	dc.l	1000000000,100000000,10000000,1000000,100000,10000
		dc.l	1000,100,10,1



*----------------------- Gibt die Return-Structure frei -------------------*
FreeCommandStruct:
		movem.l d0-a6,-(a7)
		move.l	UPrg_Struct(a5),d4
.NextStruct:	beq.s	.Return
		move.l	d4,a1
		move.l	ENA_Next(a1),d4
	*	beq.s	.StructFree
		move.l	ENA_Size(a1),d0
		beq.s	.StructFree
		ExecBase
		jsr	_LVOFreeMem(a6)
.StructFree:	tst.l	d4
		bra.b	.NextStruct
.Return:	clr.l	UPrg_Struct(a5)
		movem.l	(a7)+,d0-a6
		rts


*------------------------- Starte Dos-Notifikation ---------------------------*
StartNotify:	movem.l	d0-a6,-(a7)
		*tst.w	Kick2On(a5)
		*beq.s	.Return
		move.l	NotifyPort(a5),d0
		beq.s	.Return
		jsr	A5EndNotify(a5)
		lea	NotifyRequest(a5),a0
		moveq	#1,d1
		move.l	d1,12(a0)	
		move.l	d0,16(a0)
		LA2	LNr_EPNotifyname		;Portname setzen
		move.l	a2,10(a0)
		lea	DirPuffer(a5),a1
		move.l	a1,(a0)
		move.l	a0,d1
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOStartNotify(A6)
		move.b	#1,NotifyActive(a5)
.Return:	movem.l	(a7)+,d0-a6
		rts


	*----------- Notify-Port freigeben -------------*
EndNotify:	movem.l	d0-a6,-(a7)
		tst.l	NotifyPort(a5)
		beq.w	.Return
		tst.b	NotifyActive(a5)
		beq.s	.Return
		lea	NotifyRequest(a5),a0
		move.l	a0,d1
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOEndNotify(a6)
.Return:	clr.b	NotifyActive(a5)
		movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
* Decrunche ein Segment
* Input: d1=Name des Files
* Output:d0=Segmentadr !!! (nicht BCPL) oder NULL
*-----------------------------------------------------------------------------*
LoadSegment:	movem.l	d1-a6,-(a7)

		move.l	d1,d7
		move.l	d1,a1
		jsr	A5GetFileName(a5)
		move.l	a1,SegmentFileName(a5)

		move.l	d7,d1
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOLoadSeg(a6)
		tst.l	d0
		beq.w	.Return

		addq.l	#1,d0
		asl.l	#2,d0

	*----- Test auf Imploder V4.0-File oder ungepackten Player -----*
		move.l	d0,a3
		cmp.l	#$49fa005e,4(a3)
		bne.s	.XFDRetryCheck
		cmp.w	#$3c3c,8(a3)
		bne.s	.XFDRetryCheck
		cmp.l	#$61564e91,12(a3)
		bne.s	.XFDRetryCheck
		cmp.l	#$7c006150,16(a3)
		bne.s	.XFDRetryCheck
		cmp.l	#$4cdf7fff,94(a3)
		bne.s	.XFDRetryCheck
		cmp.w	#$4e75,98(a3)
		bne.s	.XFDRetryCheck

	*------- Print "Decrunching ...." --------*
		move.l	a1,-(a7)
		LA0	LNr_Decrunching
		move.l	SegmentFileName(a5),a1
		jsr	A5GetFileName(a5)
		move.l	a1,ScrollArgs(a5)
		jsr	A5PrintText(a5)
		move.l	(a7)+,a1


		move.w	#$4ef9,94(a3)
		lea	.ImpProg(pc),a0
		move.l	a0,96(a3)
		jsr	A5ClearCache(a5)
		jsr	(a3)				;EntPacke ImploderFile
		jsr	A5ClearCache(a5)
		move.l	d0,a3




*******************************************************************************
* 1.  Call xfdAllocSegmentInfo().					      *
* 2.  LoadSeg() file.							      *
* 3.  Call xfdRecogSegment() with xfdsi_SegList initialized.		      *
* 4.  Check xfdsi_PackerFlags for XFDPFB_PASSWORD, go on with 6. if not set.  *
* 5.  Get password (maximum length is xfdsi_MaxSpecialLen) and store a pointer*
*     to it in xfdsi_Special.						      *
* 6.  Call xfdDecrunchSegment().					      *
* 7.  Work with decrunched segment list.				      *
* 8.  UnloadSeg() segment list.						      *
* 10. Call xfdFreeSegmentInfo().					      *
*******************************************************************************
	*--------------- XFDSegmentInfo allokieren -------------*
.XFDRetryCheck:	move.l	a3,d0
		beq.w	.Return

		tst.b	OnXFDLoadSeg(a5)
		beq.w	.XFD_Ende

	*----------- XFDMaster-Library ffnen ----------*
		move.l	a3,-(a7)
		LA1	LNr_XFDMasterName
		lea	EPG_XFDMasterBase(a5),a3
		moveq	#33,d0
		jsr	A5OpenLib(a5)
		move.l	(a7)+,a3
		tst.l	d0
		beq.w	.XFD_Ende
		move.l	d0,a6
		jsr	_LVOXFDAllocSegmentInfo(a6)
		move.l	d0,XFDSegmentInfo(a5)
		beq.w	.XFD_Ende


	*------------- XFDMaster-Check aufrufen ---------------*
		move.l	EPG_XFDMasterBase(a5),a6
		move.l	XFDSegmentInfo(a5),a0
		move.l	a3,d0
		lsr.l	#2,d0
		subq.l	#1,d0
		move.l	d0,XFDSI_SegList(a0)
		movem.l	d2-a6,-(a7)
		jsr	_LVOXFDRecogSegment(a6)
		movem.l	(a7)+,d2-a6
		tst.l	d0
		bne.w	.XFDPackerFound

.XFDFreeInfo:	bsr.w	XFDFreeSegMentInfo
		bra.w	.XFD_Ende

	*------------------------------------------------------*
	*--- Handelt es sich wirklich um einen DatenPacker ----*
	*--- BITDEF	XFDPF,DATA,2	= data file packer ----*
	*------------------------------------------------------*
.XFDPackerFound:move.l	XFDSegmentInfo(a5),a0
		moveq	#0,d0
		moveq	#0,d1
		move.w	XFDSI_PackerFlags(a0),d1
		btst	#0,d1			;Auf DatenPacker testen
		beq.w	.XFDFreeInfo
		btst	#4,d1			;Auf Password testen
		beq.s	.XFDNoPassword

	*---------------- Password eingeben -------------------*
		moveq	#0,d0
		move.w	XFDSI_MaxSpecialLen(a0),d0
		cmp.w	#Passwordpuffersize-1,d0
		blo.s	.XFDPLOk
		move.w	#Passwordpuffersize-1,d0
.XFDPLOk:	lea	PasswordPuffer(a5),a1
		clr.b	(a1,d0.w)
		movem.l	d0-a6,-(a7)
		jsr	A5GetPassword2(a5)
		movem.l	(a7)+,d0-a6
		lea	PasswordPuffer(a5),a1
		move.l	XFDSegmentInfo(a5),a0
		move.l	a1,XFDSI_Special(a0)

	*------- Segment entpacken und Segment-Info freigeben --------*
	*------- Print "Decrunching ...." --------*
.XFDNoPassword:	LA0	LNr_Decrunching
		move.l	d7,a1
		jsr	A5GetFileName(a5)
		move.l	a1,ScrollArgs(a5)
		jsr	A5PrintText(a5)

		move.l	XFDSegmentInfo(a5),a0
		move.l	EPG_XFDMasterBase(a5),a6
		movem.l	d2-a6,-(a7)
		jsr	_LVOXFDDecrunchSegment(a6)
		movem.l	(a7)+,d2-a6
		move.l	XFDSegmentInfo(a5),a0
		move.l	XFDSI_SegList(a0),d1
		addq.l	#1,d1
		lsl.l	#2,d1
		move.l	d1,a3
		bsr.w	XFDFreeSegMentInfo
		tst.l	d0
		bne.w	.XFDRetryCheck
.XFD_Ende:	move.l	a3,d0
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

.ImpProg:	movem.l	(a7)+,d0-a6
		movem.l	(a7)+,d0			;StartAdresse
		rts


*--------------------------- XFDCrunchInfo freigeben -------------------------*
XFDFreeSegMentInfo:movem.l d0-a6,-(a7)
		move.l	EPG_XFDMasterBase(a5),d0
		beq.s	.XFDNoBase
		move.l	d0,a6
		move.l	XFDSegmentInfo(a5),d0
		beq.s	.XFDNoBase
		move.l	d0,a1
		jsr	_LVOXFDFreeSegmentInfo(a6)
.XFDNoBase:	clr.l	XFDSegmentInfo(a5)
		movem.l	(a7)+,d0-a6
		rts

*----------------------------------------------------------------------------*
*-------------------- Loadplayer a4=Adresse fr PlayerAdr -------------------*
*----------------------------------------------------------------------------*
LoadPlayer:	lea	InfoBlock+8(a5),a0
		move.l	a0,d1
LoadPlayer2:	lea	Delirium.Msg(pc),a6
		moveq	#0,d4
LoadEngineSegment:move.l a6,d6
		clr.l	LoadplayerError(a5)
		clr.w	LoadPlayerExists(a5)	;Kennung ob Player bereits
						;vorhanden (nach test)

						;0=neu geladen
						;1=rbergeladen
						;2=exitiert bereits mit grerer
						;Versionsnummer
						;3=existierte als Batch
		clr.l	LastLoadedTagList(a5)
		move.l	d1,PlayerPath(a5)
		jsr	A5LoadSegment(a5)
		beq.w	.LoadError

	*----- Test ob Player oder Userprogramm ----*
		move.l	d0,a3		
		move.l	d6,a0
		tst.l	d4
		beq.w	.DTPlayer

	*---------- Auf Userprogramm testen --------*
	* 
		cmp.w	#$6000,(a3)
		beq.w	.TaskEngine
		cmp.l	#TagUserID,(a3)		;Kein Nullen Test !!!!
		bne.w	.NoEP_Player
		bra.s	.TagUser
.TaskEngine:	move.w	2(a3),d1
		ble.w	.NoEP_Player
.TagUser:	move.l	(a0),d1
		cmp.l	EUS_Identifier(a3),d1
		bne.w	.NoEP_Player
		move.l	4(a0),d1
		cmp.l	EUS_Identifier+4(a3),d1
		bne.w	.NoEP_Player

		*move.w	8(a0),d1
		*cmp.w	EUS_Identifier+8(a3),d1
		*bne.w	.NoEP_Player

* [][] Fr Amplifierverkettung freimachen

		clr.l	EUS_Identifier(a3)
		clr.l	EUS_Identifier+4(a3)
		clr.w	EUS_Identifier+8(a3)

	*------ Test, ob hhere EaglePlayer-Version verlangt wird -----*
		moveq	#EPR_NeedNewerEP,d0
		cmp.l	#EagleVersion,EUS_EPVersion(a3)
		bhi.w	.NoEP_Player2

	*------ Test auf Kick 2.0 -----*
		moveq	#EPR_NeedHigherKickstart,d0
		move.w	EUS_KickStart(a3),d1
		cmp.w	KickStart(a5),d1
		bgt.w	.NoEP_Player2			;Kickstart grer


	*---- Test, ob bessere CPU/FPU verlangt wird ----*
		move.l	EUS_TagList(a3),d0
		beq.s	.NoTagList
		move.l	d0,a6
		move.l	#EUT_AttnFlags,d0
		jsr	A5FindTag2(a5)
		beq.s	.NoTagList
		move.l	a6,d0
		bsr	TestCPUFPU
		bne.w	.NoEP_Player2
.NoTagList:

	*------ Setze Player/UserProgramm in Liste -----*
	*	move.l	d0,(a4,d4.l)
	*	move.l	a4,OldLoadAdr(a5)
	*	move.l	d0,a4
	*	clr.l	(a4,d4.l)			;NextPtr clr
	move.l	a3,d0
	move.l	d0,NewEngineSegment(a5)
	move.l	d0,a4
		bra.w	.LoadEnde

	*---------- Auf Eagleplayer testen -----------*
.DTPlayer:	cmp.w	#$6000,(A3)
		beq.s	.ItsOk_1
		move.l	(a0),d1
		cmp.l	(a3),d1
		bne.w	.NoEP_Player

.ItsOk_1:	cmp.l	#"EPPL",4(a3)
		bne.s	.NoNewEPPL
		cmp.l	#"AYER",8(a3)
		beq.s	.Yep
.NoNewEPPL:	move.l	4(a0),d1
		cmp.l	4(a3),d1
		bne.w	.NoEP_Player

		move.l	8(a0),d1
		cmp.l	8(a3),d1
		bne.w	.NoEP_Player

.Yep:		move.l	d0,OldLoadAdr(a5)
		move.l	d0,a4
		clr.l	(a4)				;next Pointer lschen

	*---- Test, ob bessere CPU/FPU verlangt wird ----*
		move.l	12(a4),a6
		move.l	#EP_AttnFlags,d0
		jsr	A5FindTag2(a5)
		beq.s	.NoAttn
		move.l	a6,d0
		bsr	TestCPUFPU
		bne.w	.NoEP_Player2


	*------- Test, ob hhere Kickstart-Version bentigt wird -------*
.NoAttn:	move.l	12(a4),a6
		move.l	#EP_KickVersion,d0
		jsr	A5FindTag2(a5)
		beq.s	.NoKick
		moveq	#EPR_NeedHigherKickstart,d0
		cmp.w	KickStart(a5),a6	;PlKVersion kleiner als Kick
		blo.w	.NoEP_Player2

	*------ Test, ob hhere EaglePlayer-Version verlangt wird ------*
.NoKick:	move.l	12(a4),a6
		move.l	#EP_PlayerVersion,d0
		jsr	A5FindTag2(a5)
		beq.s	.NoEPVersion
		moveq	#EPR_NeedNewerEP,d0
		cmp.w	#EagleVersion,a6
		bhi.w	.NoEP_Player

	*------ Test, ob hhere DeliTracker-Version verlangt wird ------*
.NoEPVersion:	move.l	12(a4),a6
		move.l	#DTP_RequestDTVersion,d0
		jsr	A5FindTag2(a5)
		beq.s	.NoVersion
		move.w	a6,d1
		blt.s	.NoVersion
		cmp.w	#MinDeliVersion,a6
		blo.w	.NoEP_Player
		move.l	a6,d1
		move.l	12(a4),a6
		move.l	#EP_PlayerVersion,d0
		jsr	A5FindTag2(a5)
		bne.s	.NoVersion

		cmp.w	#MaxDeliVersion,d1	;V2.0 nicht mehr laden
		bhs.w	.NoEP_Player

		bsr	CheckDeliPlayer
		bne.w	.NoEP_Player

.NoVersion:	cmp.w	#37,KickStart(a5)
		bhi.s	.NoKickTest

	*------- wird Kick2.0 verlangt -------*
		move.l	12(a4),a6
		move.l	#DTP_RequestV37,d0
		jsr	A5FindTag2(a5)
		bne.w	.NoEP_Player

		*---- Delibase setzen ----*
.NoKickTest:	move.l	12(a4),a6
		move.l	#EP_EagleBase,d0
		jsr	A5FindTag2(a5)
		beq.s	.NoEagleBase
		move.l	a5,(a6)

.NoEagleBase:	move.l	12(a4),a6
		move.l	#DTP_DeliBase,d0
		jsr	A5FindTag2(a5)
		beq.s	.NoDeliBase
		move.l	a5,(a6)

.NoDeliBase:	tst.w	LoadPlayerKennung(a5)		;CustomFile ????
		bne.w	.Custom				;Ja

		clr.l	LoadPlayerVersion(a5)
		move.l	12(a4),a6
		move.l	#DTP_PlayerVersion,d0
		jsr	A5FindTag2(a5)
		beq.s	.NoPlayerVersion
		move.l	a6,d0
		and.w	#$ffff,d0
		move.l	d0,LoadPlayerVersion(a5)

.NoPlayerVersion:move.l	12(a4),a6
		move.l	#DTP_CustomPlayer,d0
		jsr	A5FindTag2(a5)
		bne.w	.NoEP_Player

		move.l	12(a4),a6
		move.l	#EP_LocaleTable,d0
		jsr	A5FindTag2(a5)
		move.l	a6,a0
		jsr	A5SetTableLocale(a5)

		move.l	12(a4),a6
		move.l	#DTP_PlayerName,d0
		jsr	A5FindTag2(a5)
		beq.w	.NoEP_Player


		*---------------------------*
		lea	PlayersDir(a5),a1
		jsr	A5MakeCorrectDir(a5)
		move.l	a1,a0
		jsr	A5BerechStringSize(a5)
		lea	(a1,d0.w),a1
		move.l	PlayerPath(a5),a0
		jsr	A5StringCopy(a5)

		movem.l	a3/a2,-(a7)
		lea	PlayersDir(a5),a3
		move.l	a4,a2
		jsr	A5InsertPlayerInList(a5)
		movem.l	(a7)+,a3/a2

		move.l	d0,-(a7)
		lea	PlayersDir(a5),a1
		jsr	A5GetFileName(a5)
		clr.b	(a1)
		move.l	(a7)+,d0

		tst.b	d0
		beq.s	.NoEP_Player
		bra.b	.Config


	*------- Check ob CustomSong einen CustomTag hat --------*
.Custom:	move.l	OldLoadAdr(a5),d0
		beq.s	.Config
		move.l	d0,a6
		move.l	12(a6),a6
		move.l	#DTP_CustomPlayer,d0
		jsr	A5FindTag2(a5)			;CustomPlayer
		beq.s	.NoEP_Player
.Config:	move.l	OldLoadAdr(a5),d0
		beq.s	.Config_No
		move.l	d0,a6
		move.l	12(a6),a6
		move.l	#DTP_Config,d0
		jsr	A5CallUp3(a5)
.Config_No:	jsr	A5ClearCache(a5)
		move.l	OldLoadAdr(a5),a4

		*------ Engines benachrichten ------*
		moveq	#USClass_NewPlayer,d0
		jsr	A5SendeAllMessage(a5)
.LoadEnde:	moveq	#1,d0
		rts

.NoEP_Player2:	move.l	d0,LoadplayerError(a5)
.NoEP_Player:	move.l	a3,d1
		beq.s	.LoadError
		asr.l	#2,d1
		subq.l	#1,d1
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOUnLoadSeg(a6)

.LoadError:	moveq	#0,d0
.Return:	rts


Delirium.MSG:	dc.l	$70ff4e75
		dc.b	"DELIRIUM"
EagleUser.MSG:	EUSN_Identifier


*-----------------------------------------------------------------------------*
*-----------------------------------------------------------------------------*
*-----------------------------------------------------------------------------*
*-----------------------------------------------------------------------------*


*-----------------------------------------------------------------------------*
* Der Player wird einsortiert.						      *
* Input: a2=erstes Segment (volle Adresse)				      *
*	 a3=kompletten Pfad							      *
* Output:d0=Null=Error oder 1						      *
*-----------------------------------------------------------------------------*
InsertPlayerInList:
		movem.l	d1-a6,-(a7)
		move.l	a2,OldLoadAdr(a5)
		move.l	a3,PlayerPath(a5)
		move.l	a3,a1
		jsr	A5GetFileName(a5)
		move.l	a1,a6


		clr.l	MerkAdr(a5)
		lea	EPG_FirstPlayerStruct(a5),a4
.NextPlayer:	moveq	#0,d2
		move.l	a4,MerkAdr(a5)
		move.l	(a4),d0
		beq.w	.Change
		move.l	d0,a4

		btst	#EPPlF_Enabled,EPPl_Flags+1(a4)	;Test auf Enabled
		bne.s	.Erlaubt
		lea	TextPuffer(a5),a0
		jsr	A5GetPlayerName(a5)		
		lea	TextPuffer(a5),a1
		bra.b	.Disabled2
		
.Erlaubt:	move.l	EPPl_Node+LN_Name(a4),a1
.Disabled2:	move.l	a6,a2			;NameAdr aus NewPlayer
.NextB:		move.b	(a1)+,d0
		move.b	(a2)+,d1
		cmp.b	#"a",d0
		blt.s	.NoSub1
		cmp.b	#"z",d0
		bgt.s	.NoSub1
		bclr	#5,d0
.NoSub1		cmp.b	#"a",d1
		blt.s	.NoSub2
		cmp.b	#"z",d1
		bgt.s	.NoSub2
		bclr	#5,d1
.NoSub2:	*addq.l	#1,d2
		*cmp.l	#6,d2
		*bne.s	.NoNop
		*nop
.NoNop		cmp.b	d1,d0
		blo.s	.NextPlayer	;blt
		bhi.s	.Change		;bgt
		tst.b	d0			;Gleicher Name !!!!
		bne.s	.NextB


		*--- Der Name des geladenen Players entspricht jetzt dem ---*
		*--- mit der EPPL_Structure
		tst.l	EPPl_TagList(a4)
		beq.w	.VersionGr

		tst.b	BatchLoading(a5)	;soll replaced werden
		bne.s	.AllReadyE


		*---- Test ob hhere Version, dann laden ---*
		move.l	MerkAdr(a5),a4
		move.l	(a4),a4
		move.l	EPPl_TagList(a4),a6
		move.l	#DTP_PlayerVersion,d0
		jsr	A5FindTag2(a5)
		move.l	LoadPlayerVersion(a5),d0
		cmp.l	a6,d0
		bhs.s	.VersionGr

.AllReadyE	move.w	#1,LoadPlayerExists(a5)
		bra.w	.NoName



.VersionGr:	*subq.l	#1,ScanPlayerAnz(a5)
		move.b	#1,TypeDelPlayer(a5)		*A4=Struct
		move.l	a4,a0

		*------ Engines benachrichten ------*
		moveq	#USClass_RemPlayerList,d0
		jsr	A5SendeAllMessage(a5)

		move.w	#2,LoadPlayerExists(a5)
		tst.l	EPPL_Taglist(a4)
		bne.s	.LPE_Ok
		move.w	#3,LoadPlayerExists(a5)
.LPE_Ok:	move.b	#1,KillAllPlayer(a5)
		jsr	A5DeletePlayer2(a5)
		clr.b	KillAllPlayer(a5)
		tst.l	d0
		bne.w	.ErrDelPlayer

		clr.l	PlSelected(a5)
		clr.b	TypeDelPlayer(a5)


	*--------- Insert Player in Liste (mittendrin) ---------------*
	*--------- Der geladene Player wird einsortiert --------------*
.Change:
		*------ Engines benachrichten ------*
		moveq	#USClass_RemPlayerList,d0
		jsr	A5SendeAllMessage(a5)


		move.l	PlayerPath(a5),a0
		jsr	A5BerechStringSize(a5)
		addq.l	#4,d0


		*-- Player in NodeStructure einfgen --*
		* Achtung: Bei ScanEngineDir wird ebenfalls eine EPPL_Structure
		* gesetzt !!!!
		add.l	#EPPl_SizeOf,d0
		move.l	d0,d3
		jsr	A5AllocMem(a5)
		beq.w	.ErrDelPlayer
		move.l	d0,a4

		move.l	d3,EPPl_Size(a4)
		
		tst.l	OldLoadAdr(a5)
		beq.s	.Disabled
		move.w	#EPPLB_Enabled,EPPl_Flags(a4)
.Disabled:	sub.l	#EPPl_SizeOf-1,d3
		move.l	d3,d1

		*--- Pfad kopieren ---*
		move.l	PlayerPath(a5),a1
		jsr	A5GetFileName(a5)
		move.l	a1,a2
		move.l	a1,d1
		lea	EPPl_PlayerName(a4),a1
		move.l	PlayerPath(a5),a0
		sub.l	a0,d1
		subq.l	#1,d1
		jsr	A5StringCopy2(a5)

		move.l	a2,a0
		tst.l	OldLoadAdr(a5)
		bne.w	.Enabled3
		move.b	#"(",(a1)+
.Enabled3:	move.l	a0,-(a7)
		move.l	a2,a0
		jsr	A5BerechStringSize(a5)
		subq.l	#1,d0
		move.l	d0,d1
		move.l	(a7)+,a0
		jsr	A5StringCopy2(a5)
		tst.l	OldLoadAdr(a5)
		bne.s	.Enabled4
		move.b	#")",(a1)+
		clr.b	(a1)
.Enabled4


*		lea	EPPl_PlayerName(a4),a1
*
*		tst.l	OldLoadAdr(a5)
*		bne.w	.Enabled3
*		move.b	#"(",(a1)+
*.Enabled3:	move.l	PlayerPath(a5),a0
*		jsr	A5StringCopy2(a5)
*		tst.l	OldLoadAdr(a5)
*		bne.s	.Enabled4
*		move.b	#")",(a1)+
*		clr.b	(a1)
*.Enabled4:
		lea	EPPl_PlayerName(a4),a1
		jsr	A5GetFileName(a5)
		move.l	a1,EPPl_Node+LN_Name(a4)

		sub.l	a2,a2
		move.l	MerkAdr(a5),d0
		lea	EPG_FirstPlayerStruct(a5),a0
		cmp.l	d0,a0
		beq.s	.Ch_NoFirst
		move.l	d0,a2
		lea	EPPl_Node(a2),a2
.Ch_NoFirst:	lea	PlayerList(a5),a0
		lea	EPPl_Node(a4),a1			;Neue Node
		jsr	A5InsertInList(a5)



		move.l	MerkAdr(a5),a1
		move.l	OldLoadAdr(a5),a6
		move.l	(a1),d0
		move.l	a4,(a1)
		move.l	d0,(a4)
		move.l	a6,d1
		beq.s	.NoSegment
		asr.l	#2,d1
		subq.l	#1,d1
		move.l	d1,EPPl_Segment(a4)
		move.l	12(a6),a6
		move.l	a6,LastLoadedTagList(a5)
		move.l	a6,EPPl_TagList(a4)


.NoSegment:	bsr	DeliPlayer2		*Der Player wird bei Warten
		*bne.s	.RemovePlayer		*ber UpdatePlayerlist rausge-

		moveq	#1,d0
		movem.l	(a7)+,d1-a6
		bra.s	.Return



		*------ Engines benachrichten ------*
.ErrDelPlayer:	moveq	#USClass_NewPlayer,d0
		jsr	A5SendeAllMessage(a5)
.NoName:	movem.l	(a7)+,d1-a6
		moveq	#0,d0
.Return:	tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Falls undefinierte Flags oder zwei Prozessoren angegeben werden, wird ein
* Fehler zurckgegeben.
* Input: d0=Required.w
*	 *d1=Istzustand.w
TestCPUFPU:	movem.l	d1/d2/d3/a6,-(a7)
		Execbase
		move.w	296(a6),d1
		move.w	d0,d2
		move.w	d1,d3


		*--- Unbekannte CPU/FPU-Flags ? ----*
		and.w	#$ff00,d0		;wenn d0 ungleich 0, dann ist
		tst.w	d0			;ein unbekannter CPU angeben
		bne.s	.Error

		*--- CPU-Type testen ---*
		and.w	#$8f,d1			;FPU-Flags ausschlieen
		move.w	d2,d0
		and	#$8f,d0			;CPU Flags angegeben ?
		beq	.FPUtest		;nein, weiter
		and	d1,d0
		tst.w	d0
		beq.s	.Drehen

.FPUtest
		*--- FPU-Type testen ---*
		move.w	d2,d0
		and.l	#$70,d0			;FPU-Flags angegeben ?
		beq	.ok			;nein, also fertig

		move.w	d3,d1
		and.w	#$70,d1			;CPU-Flags ausschlieen

		and	d1,d0
		beq.s	.Error
		moveq	#0,d0
		bra.s	.ok
.Drehen:	seq	d0
		beq.w	.Error
.Error:		moveq	#EPR_NeedhigherCPUFPU,d0
.Ok
		movem.l	(a7)+,d1/d2/d3/a6
		tst.l	d0
		rts



*-----------------------------------------------------------------------------*
* Testet, ob dieser Player unzulssige Tags benutzt.
* Input: 12(a4) = TagList
* Output: d0=Error oder NULL
*-----------------------------------------------------------------------------*
CheckDeliPlayer:movem.l	d1-a6,-(a7)

		lea	.ShitTags(pc),a3
.NextTag:	move.l	12(a4),a6
		move.l	(a3)+,d0
		beq.s	.NoMore
		jsr	A5FindTag2(a5)
		beq.s	.NextTag

		*--- Requester ffnen ---*
		LA0	LNr_TR_EmulatorError
		move.l	a0,EPG_Arg1(a5)
		lea	PubScreenName(a5),a0
		move.l	a0,EPG_Arg2(a5)
		clr.l	EPG_Arg3(a5)
		subq.l	#1,EPG_Arg3(a5)
		LA0	LNr_GA_Ok
		move.l	a0,EPG_Arg4(a5)
		clr.l	EPG_Arg5(a5)			*Title

		move.l	SegmentFileName(a5),ScrollArgs(a5)

		move.l	d0,ScrollArgs+4(a5)
		lea	ScrollArgs(a5),a0
		move.l	a0,EPG_Arg6(a5)

		move.l	#EPTRB_Center,EPG_Arg8(a5)
		moveq	#-1,d0
		move.l	d0,EPG_Arg7(a5)
		moveq	#7,d0
		move.l	d0,EPG_ArgN(a5)
		jsr	A5TextRequest(a5)
		moveq	#EPR_ErrorAddPlayer,d0

.NoMore:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

.ShitTags:	dc.l	DTP_Convert
		dc.l	DTP_NotePlayer
		dc.l	DTP_NoteInfo
		dc.l	DTP_NoteSignal
		*dc.l	DTP_Process
		*dc.l	DTP_Priority
		*dc.l	DTP_StackSize
		*dc.l	DTP_MsgPort
		dc.l	0


*-----------------------------------------------------------------------------*
* Testet, ob eine Delitracker V2.0 Emlulation ntig ist.
* Input: 12(a4) = TagList
* Output: d0=Error oder NULL
*-----------------------------------------------------------------------------*
CheckNeededEmulation:
		movem.l	d1-a6,-(a7)

		lea	.EmuTags(pc),a3
.NextTag:	move.l	EPPL_Taglist(a4),a6
		move.l	(a3)+,d0
		beq.s	.NoMore
		jsr	A5FindTag2(a5)
		beq.s	.NextTag
		move.l	d2,d0
.NoMore:	movem.l	(a7)+,d1-a6
		rts

.EmuTags:	dc.l	DTP_Flags
		dc.l	DTP_Description
		dc.l	DTP_NoteStruct
		dc.l	DTP_Process
		dc.l	DTP_Priority
		dc.l	DTP_StackSize
		dc.l	DTP_MsgPort
		dc.l	DTP_Appear
		dc.l	DTP_Disappear
		dc.l	DTP_ModuleName
		dc.l	DTP_FormatName
		dc.l	DTP_AuthorName
		dc.l	DTP_InitNote	
		dc.l	DTP_Patterns	
		dc.l	DTP_Duration	
		dc.l	DTP_SampleData	
		dc.l	DTP_MiscText	
		dc.l	0

*---------- Jetzt werden alle DeliTracker2-Player an den Ep angepat ---------*
* Problem: Wenn kein Mem mehr ist, wird Player nicht gequitted, aber dann ist
*	   sowieso alles egal
* Input: a3=PlayerStructure
* Output:d0=Error oder NULL
DeliPlayer2:	movem.l	d1-a6,-(a7)
		move.l	a4,a3


		move.l	EPPl_TagList(a3),d0
		beq.w	.AllesKlar
		*move.l	d0,a6
		*move.l	#DTP_RequestDTVersion,d0
		*jsr	A5FindTag2(a5)
		*beq.s	.TestAufTask
		*cmp.w	#14,d2			*Normaler alter Player
		*ble.w	.TestAufTask

		bsr	CheckNeededEmulation
		beq.w	.AllesKlar

	* folgendes wird getan:
	*	1. alle nicht EP-Tags werden in konforme umgebaut  *
	*	2. dazu werden 2 Taglisten geschaffen, die vor die *
	*	   anderen gehngt werden			   *
	*----------------------------------------------------------*
	* Im einzelnen:
	* PlayerTaglist:
	*	EP_NewModuleInfo	Ptr zur neuen Liste
	*	EP_Check3		wenn DTP_Check1 und PLYB_AnyMem
	*	EP_Check5		wenn DTP_Check2 und PLYB_AnyMem
	*	EP_InitAmplifier	Ptr auf Proggy im EP der die ori.
	*				DT-Structure auswerted und eine
	*				EP-Structure zurckgibt
	*	EP_Show			DTP_Appear
	*	EP_Hide			DTP_Disappear
	*	EP_Flags		
	*			EPF_Songend , wenn PLYB_Songend
	*			EPF_Restart ,  
	*			EPF_Disable ,
	*			EPF_NextSong , DTP_SubSongRange,DTP_NextSong...
	*			EPF_PrevSong ,		-++-
	*			EPF_NextPatt , DTP_NextPatt
	*			EPF_PrevPatt , DTP_PrevPatt
	*			EPF_Volume ,   DTP_Volume DTP_NoteStruct
	*			EPF_Balance ,  DTP_Balance DTP_NoteStruct
	*			EPF_Voices ,   DTP_NoteStruct
	*			EPF_Save ,           /
	*			EPF_Analyzer ,	DTP_NoteStruct ???
	*			EPF_ModuleInfo , EP_NewModuleInfo
	*			EPF_SampleInfo ,   /
	*			EPF_Packable ,   DTP_Check2
	*			EPF_VolVoices ,    /
	*			EPF_InternalUPSStructure ,  /
	*			EPF_RestartSong , DTP_InitSound
	*			EPF_LoadFast ,    PLYB_AnyMem
	*			EPF_EPAudioAlloc ,   /
	*			EPF_VolBalVoi ,      /
	*			EPF_CalcDuration ,  DTP_PlayTime
	*	TagMore			original DTP_TagListe
	*-----------------------------------------------------------*
	* ModuleInfoTaglist
	*	MI_Authorname		DTP_Authorname
	*	MI_SoundSystem		DTP_FormatName
	*	MI_SongName		DTP_ModuleName
	*	MI_Extrainfo		DTP_Description
	*	MI_Duration		DTP_PlayTime
	*	MI_Pattern		DTP_Pattern
	*	TagMore			FutureKomp. fr EP_ModuleInfo
	*-----------------------------------------------------------*

		*-- Mem fr Taglisten anfordern --*
.NoDeliBase:	move.l	#9*8+8*8+20,d0
		jsr	A5AllocMem(a5)
		beq.w	.Error2
		move.l	d0,EPPl_ExtraMem(a3)
		move.l	#9*8+8*8+20,EPPl_ExtraMemSize(a3)
		jsr	A5UpdateDeliEmu(a5)

		*--- Falls Task, dann starten -----*
.TestAufTask:	move.l	EPPl_TagList(a3),a6		*Process-Code
		move.l	#DTP_Process,d0
		jsr	A5FindTag2(a5)
		beq.s	.AllesKlar
		lea	DT_ProcessTags(pc),a1
		*move.l	a6,4(a1)

		move.l	EPPl_TagList(a3),a6		*Process-StackSize
		move.l	#DTP_StackSize,d0
		jsr	A5FindTag2(a5)
		bne.s	.StackOk
		move.l	#4096,a6
.StackOk:	move.l	a6,12(a1)
		move.l	EPPl_Node+LN_Name(a3),20(a1)	*Name setzen

		move.l	a1,d1				*Process starten
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOCreateNewProc(a6)
		move.l	d0,a0
		tst.l	d0
		beq.s	.Error
		move.l	a3,$58(a0)			*EPPl_Struct setzen

		*--- Warten, bis MSG-Port gesetzt ist ---*
.WaitPort:	jsr	A5Delay(a5)
		move.l	EPPl_Node+LN_Name(a3),a1
		Execbase
		jsr	_LVOFindTask(a6)		;beendet
		beq.s	.AllesKlar
		tst.l	EPPL_MsgPort(a3)
		beq.s	.WaitPort

.AllesKlar:	moveq	#0,d0
.Return:	movem.l	(a7)+,d1-a6
		rts

		*--- Fehler bei CreateProc ---*
.Error:		move.l	EPPl_ExtraMem(a3),d0
		beq.s	.Error_2
		move.l	d0,a1
		move.l	EPPl_ExtraMemSize(a3),d0
		beq.s	.Error_2
		jsr	A5FreeMem(a5)
.Error_2:	clr.l	EPPl_ExtraMem(a3)
		clr.l	EPPl_ExtraMemSize(a3)
		addq.l	#1,UpdatePlayerList(a5)
		moveq	#EPR_UnknownError,d0
		bra.s	.Return

.Error2:	addq.l	#1,UpdatePlayerList(a5)
		moveq	#EPR_NotEnoughMem,d0
		bra.s	.Return


DT_ProcessTags:	dc.l	$800003eb,DT_TaskStart		*NP_Entry
		dc.l	$800003f3,0			*NP_StackSize
		dc.l	$800003f4,0			*NP_Name
		dc.l	0



*-----------------------------------------------------------------------------*
* Der Delitracker startet seine Tasks in einer eigenen Unterroutine und creiert
* dort den MsgPort, setzt die Prioritt und fngt die ersten Messages ab. So
* bekommt er vor allem mit, wann der Task beendet ist.
*-----------------------------------------------------------------------------*
DT_TaskStart:	move.l	PufferAdr(pc),a5
		ExecBase
		sub.l	a1,a1
		jsr	_LVOFindTask(a6)
		move.l	d0,a4
		move.l	d0,a2
.WaitStruct:	move.l	$58(a4),d0
		bne.s	.StructOk
		moveq	#1,d1
		move.l	DTG_DosBase(a5),a6
		jsr	_LVODelay(a6)
		bra.s	.WaitStruct

.StructOk:	*--- MsgPort setzen ---*
		clr.l	$58(a4)
		move.l	d0,a4				*EPPl_Struct
		move.l	a2,EPPl_TaskAdr(a4)
		move.l	#DTP_MsgPort,d0
		move.l	EPPl_Taglist(a4),a6		*SegmentAdr
		jsr	A5FindTag2(a5)
		beq.l	.Return
		move.l	a6,a2
		ExecBase
		jsr	_LVOCreateMsgPort(a6)
		tst.l	d0
		beq.l	.Return
		move.l	d0,(a2)				*store MsgPort
		move.l	d0,EPPl_MsgPort(a4)		*MsgPort merken


		*--- TaskPri setzen ---*
		move.l	#DTP_Priority,d0		*Taskpri setzen
		move.l	EPPl_TagList(a4),a6
		jsr	A5FindTag2(a5)
		beq.s	.TaskPri_ZERO
		move.l	a6,d0
		move.l	EPPl_TaskAdr(a4),a1
		Execbase
		jsr	_LVOSetTaskPri(a6)

		*--- Jump in Process ---*
.TaskPri_ZERO:	move.l	#DTP_Process,d0		*Taskpri setzen
		move.l	EPPl_TagList(a4),a6
		jsr	A5FindTag2(a5)
		beq.s	.RecieveLastMsg
		move.l	a6,a2
		movem.l	a4/a5,-(a7)
		jsr	(a2)
		movem.l	(a7)+,a4/a5

		*--- Alle noch ankommenden Msg's replyen ---*
.RecieveLastMSG:move.l	EPPl_MsgPort(a4),d0		*MsgPort
		beq.s	.Return
		move.l	d0,a0
		ExecBase
		jsr	_LVOGetMsg(a6)
		tst.l	d0
		beq.s	.DeleteMsgPort
		move.l	d0,a1
		jsr	_LVOReplyMsg(a6)
		bra.s	.RecieveLastMSG

		*--------- Delete Msg-Port -----------*
.DeleteMsgPort:	move.l	EPPl_MsgPort(a4),d0		*MsgPort
		beq.s	.Return
		move.l	d0,a0
		ExecBase
		jsr	_LVODeleteMsgPort(a6)
		clr.l	EPPl_MsgPort(a4)

.Return:	addq.l	#1,UpdatePlayerList(a5)
		move.l	SongEndBits(a5),d1
		moveq	#0,d0
		bset	d1,d0
		ExecBase
		move.l	MyTaskAdr(a5),a1
		jsr	_LVOSignal(a6)
		rts




*-----------------------------------------------------------------------------*
* Input: a3=EPPl_Structure
UpDateDeliEmu:	movem.l	d0-a6,-(a7)


		*-- Alles Zurcksetzen --*
		move.l	EPPl_ExtraMem(a3),d0	;--> Keine DeliEmulation
		beq.w	.Return
		move.l	d0,a4

		move.l	EPPl_Segment(a3),d0
		addq.l	#1,d0
		asl.l	#2,d0
		move.l	d0,a0
		move.l	12(a0),a0
		move.l	a0,EPPl_TagList(a3)


		*-- PlayerTaglist bauen --*
		move.l	#DTP_NoteStruct,d0
		move.l	EPPl_TagList(a3),a6
		jsr	A5FindTag2(a5)
		move.l	a6,d4

		moveq	#0,d7			;EP_Flags
		move.l	EPPl_TagList(a3),a6
		move.l	#DTP_Flags,d0
		jsr	A5FindTag2(a5)		*Keine Flags -> kein Songend
		*beq.s	.NoFlags				kein AnyMem
		move.l	a6,d6

		*---- DT-Flags auswerten ----*
		btst	#PLYB_AnyMem,d6
		bne.s	.FastRam
		tst.l	d4
		beq.s	.NoCheck2
.FastRam:	bset	#EPF_LoadFast,d7
		move.l	#DTP_Check1,d0
		move.l	EPPl_TagList(a3),a6
		jsr	A5FindTag2(a5)
		beq.s	.NoCheck1
		move.l	#EP_Check3,(a4)+
		move.l	a6,(a4)+
.NoCheck1:	move.l	#DTP_Check2,d0
		move.l	EPPl_TagList(a3),a6
		jsr	A5FindTag2(a5)
		beq.s	.NoCheck2
		move.l	#EP_Check5,(a4)+
		move.l	a6,(a4)+
.NoCheck2:	btst	#PLYB_SongEnd,d6
		beq.s	.NoFlags
		bset	#EPF_Songend,d7

		*---- Amplifierinit -----*
.NoFlags:	move.l	#DTP_NoteStruct,d0
		move.l	EPPl_TagList(a3),a6
		jsr	A5FindTag2(a5)
		beq.s	.NoAmplifier
		move.l	(A6),a6
		*move.l	npl_flags(A6),d0		;
		move.l	4(a6),d0		;
		and.l	#1,d0				;NTSF_Dummy
		bne	.NoAmplifier

		move.l	#EP_InitAmplifier,(a4)+
		move.l	#InitDeliNotePlayer,(a4)+

		*----- Show/Hide ------*
.NoAmplifier:	move.l	#DTP_Appear,d0
		move.l	EPPl_TagList(a3),a6
		jsr	A5FindTag2(a5)
		beq.s	.NoShow
		move.l	#EP_Show,(a4)+
		move.l	a6,(a4)+
.NoShow:	move.l	#DTP_Disappear,d0
		move.l	EPPl_TagList(a3),a6
		jsr	A5FindTag2(a5)
		beq.s	.NoHide
		move.l	#EP_Hide,(a4)+
		move.l	a6,(a4)+

		*---- Jetzt werden die EP_Flags getestet -----*
.NoHide:	move.l	#DTP_Duration,d0
		move.l	EPPl_TagList(a3),a6
		jsr	A5FindTag2(a5)
		beq.s	.NoPlayTime
		bset	#EPF_CalcDuration,d7

.NoPlayTime:	move.l	#DTP_NextPatt,d0		*NextPatt
		move.l	EPPl_TagList(a3),a6
		jsr	A5FindTag2(a5)
		beq.s	.NoNextPatt
		bset	#EPF_NextPatt,d7
.NoNextPatt:	move.l	#DTP_PrevPatt,d0		*PrevPatt
		move.l	EPPl_TagList(a3),a6
		jsr	A5FindTag2(a5)
		beq.s	.NoPrevPatt
		bset	#EPF_PrevPatt,d7

.NoPrevPatt:	move.l	#DTP_Volume,d0			*Volume
		move.l	EPPl_TagList(a3),a6
		jsr	A5FindTag2(a5)
		bne.s	.EPFl_Volume
		tst.l	d4				*NotePlayer
		beq.s	.NoVolume
		bset	#EPF_VolBalVoi,d7
		bset	#EPF_Balance,d7
		bset	#EPF_Voices,d7
.EPFl_Volume:	bset	#EPF_Volume,d7

.NoVolume:	move.l	#DTP_Balance,d0			*Balance
		move.l	EPPl_TagList(a3),a6
		jsr	A5FindTag2(a5)
		beq.s	.NoBalance
		bset	#EPF_Balance,d7

.NoBalance:	move.l	#DTP_Check2,d0			*Packable
		move.l	EPPl_TagList(a3),a6
		jsr	A5FindTag2(a5)
		beq.s	.NoPackable
		bset	#EPF_Packable,d7

.NoPackable:	move.l	#DTP_InitSound,d0		*RestartSong
		move.l	EPPl_TagList(a3),a6
		jsr	A5FindTag2(a5)
		beq.s	.NoRestartSong
		bset	#EPF_RestartSong,d7

.NoRestartSong:	move.l	#DTP_NextSong,d0		*NextSong
		move.l	EPPl_TagList(a3),a6
		jsr	A5FindTag2(a5)
		bne.s	.NextSong
		move.l	#DTP_SubsongRange,d0
		move.l	EPPl_TagList(a3),a6
		jsr	A5FindTag2(a5)
		bne.s	.UndPrevSong
		move.l	#DTP_NewSubsongRange,d0
		move.l	EPPl_TagList(a3),a6
		jsr	A5FindTag2(a5)
		beq.s	.NoNextSong

.UndPrevSong:	bset	#EPF_PrevSong,d7
.NextSong:	bset	#EPF_NextSong,d7

.NoNextSong:	move.l	#DTP_PrevSong,d0		*PrevSong
		move.l	EPPl_TagList(a3),a6
		jsr	A5FindTag2(a5)
		beq.s	.NoPrevSong
		bset	#EPF_PrevSong,d7

		*---- EP_Flags setzen ----*
.NoPrevSong:	tst.l	d7
		beq.s	.NoEPFlags
		move.l	#EP_Flags,d0
		move.l	EPPl_TagList(a3),a6
		jsr	A5FindTag2(a5)
		move.l	a6,d0
		or.l	d7,d0
		move.l	#EP_Flags,(a4)+
		move.l	d0,(a4)+

		*---- Moduleinfo setzen -----*
.NoEPFlags:	move.l	#EP_NewModuleInfo,(a4)+
		lea	16(a4),a0
		move.l	a0,(a4)+
		move.l	#Tag_More,(a4)+
		move.l	EPPl_TagList(a3),(a4)+
		clr.l	(a4)+

		*----- Jetzt beginnt Moduleinfo -----*
		move.l	#DTP_ModuleName,d0
		move.l	EPPl_TagList(a3),a6
		jsr	A5FindTag2(a5)
		beq.s	.NoModuleName
		move.l	a6,d0
		beq.s	.NoModulename
		move.l	(a6),d0
		beq.s	.NoModuleName
		move.l	#MI_Songname,(a4)+
		move.l	d0,(a4)+

.NoModulename:	move.l	#DTP_Authorname,d0
		move.l	EPPl_TagList(a3),a6
		jsr	A5FindTag2(a5)
		beq.s	.NoAuthorname
		move.l	a6,d0
		beq.s	.NoAuthorname
		move.l	(a6),d0
		beq.s	.NoAuthorname
		move.l	#MI_Authorname,(a4)+
		move.l	d0,(a4)+

.NoAuthorname:	move.l	#DTP_FormatName,d0
		move.l	EPPl_TagList(a3),a6
		jsr	A5FindTag2(a5)
		beq.s	.NoFormatname
		move.l	a6,d0
		beq.s	.NoFormatName
		move.l	(a6),d0
		beq.s	.NoFormatName
		move.l	#MI_SoundSystem,(a4)+
		move.l	d0,(a4)+

.NoFormatName:	move.l	#DTP_Description,d0
		move.l	EPPl_TagList(a3),a6
		jsr	A5FindTag2(a5)
		beq.s	.NoDescription
		move.l	a6,d0
		*beq.s	.NoDescription
		*move.l	(a6),d0
		beq.s	.NoDescription
		move.l	#MI_ExtraInfo,(a4)+
		move.l	d0,(a4)+
.NoDescription:	*move.l	#DTP_PlayTime,d0
		*move.l	EPPl_TagList(a3),a6
		*jsr	A5FindTag2(a5)
		*beq.s	.NoMIPlayTime
		*move.l	#MI_Duration,(a4)+
		*move.l	a6,(a4)+

.NoMIPlayTime:	move.l	#DTP_Patterns,d0
		move.l	EPPl_TagList(a3),a6
		jsr	A5CallUp3(a5)
		beq.s	.NoPattern
		move.l	#MI_Pattern,(a4)+
		move.l	d0,(a4)+


.NoPattern:	move.l	#EP_NewModuleInfo,d0
		move.l	EPPl_TagList(a3),a6
		jsr	A5FindTag2(a5)
		beq.s	.NoNewModuleInfo
		move.l	#Tag_More,(a4)+
		move.l	a6,(a4)+



.NoNewModuleInfo:
		clr.l	(a4)+

		move.l	EPPl_ExtraMem(a3),EPPl_TagList(a3)
.Return:	movem.l	(a7)+,d0-a6
		rts

**-----------------------------------------------------------------------------*
*UpdateDeliInfoTags:
*		movem.l	d0-a6,-(a7)
*		move.l	EPG_PlayerTagList(a5),d0
*		beq.s	.Return
*		move.l	d0,a3
*		*tst.l	EPPl_ExtraMem(a3)		;Keine Emulation
*		*beq.s	.Return
*.Return:	movem.l	(a7)+,d0-a6
*		rts

*-----------------------------------------------------------------------------*
* Diese Routine wird aufgerufen bei DeliTrackerPlayern DTP_NoteStruct und mu *
* die Initialisierung von InitAmplifier bernehmen.
* Input: --
* Output: 
InitDeliNotePlayer:
		move.l	PufferAdr(pc),a5
		moveq	#EPAMB_Direct!EPAMB_WaitForStruct,d7
		lea	DT_AudTagListe(pc),a3
	
		move.l	MDPuffer(a5),d0
		beq.w	.NoChip
		move.l	d0,a1
		Execbase
		jsr	_LVOTypeOfMem(a6)
		btst	#1,d0
		beq.s	.Nochip
		or.w	#EPAMB_ChipRam,d7
.NoChip:	move.l	d7,20(a3)			;Flags

		*--- Notestructure zurcksetzen ---*
		move.l	#DTP_NoteStruct,d0
		jsr	A5FindTag(a5)
		beq.w	.Error

		move.l	(a6),d0			--> Ptr zur MainStructure
		beq.w	.Error
		move.l	d0,a0

		moveq	#EPAMB_8Bit,d0
		move.l	4(a0),d7		;Flags aus DT Struktur holen
		btst	#10,d7			;NSTB_Unsigned
		beq.s	.nounsigned
		moveq	#EPAMB_8BitUnsigned,d0
.nounsigned
		or.l	20(a3),d0
		move.l	d0,20(a3)		;Flags sichern

		move.l	(a0),d0			--> Erste StimmenStructure
.ClrNextVoice:	beq.s	.AllCleared
		move.l	d0,a0
		clr.l	4(a0)
		clr.l	8(a0)
		clr.w	14(a0)

		clr.l	$10(a0)
		clr.l	$14(a0)
		clr.l	$18(a0)
		clr.l	$1C(a0)
		clr.l	$20(a0)
		clr.l	$24(a0)

		clr.l	$28(a0)
		clr.l	$2c(a0)
		clr.l	$30(a0)
		clr.l	$34(a0)
		clr.l	$38(a0)
		clr.l	$3c(a0)
		
		move.l	(a0),d0
		bra.s	.ClrNextVoice

	*				4,8,     14  $10
	*NoteStruct0: dc.l NoteStruct1,0,0,$80010000,0,0,0,0,0,0,0,0,0,0,0,0

	*move.l	DTG_ChkData(a5),a0
	*move.l	MDPUffer(a5),a0
	*move.l	a0,DTG_ChkData(a5)

.AllCleared:	move.l	#DTP_InitNote,d0
		jsr	A5CallUp(a5)
		beq.s	.NoInit
		tst.l	d0
		bne.w	.Error


		*---- Wieviele Stimmen bentigt die Structure ---*
.NoInit:	move.l	#DTP_NoteStruct,d0
		jsr	A5FindTag(a5)
		beq.w	.Error
		move.l	(a6),d0
		beq.s	.Error
		move.l	d0,a0
		move.l	d0,a2			--> NoteStructure
		move.l	d0,DT_NoteStruct(a5)

		move.l	(a0),d0			--> Einzelnen Structuren
		beq.s	.Error
		moveq	#-1,d0
		moveq	#0,d2			;ignorierte Stimmen
.NextVoice:	addq.l	#1,d0
		move	12(a0),d1		;Stereo Position
		cmp	#-32768,d1
		bne.s	.noignore
		addq	#1,d2
		bra.s	.ignore
.noignore
		moveq	#0,d2			;resetten, falls nach unbenutzten Kanlen noch benutzte kommen
.ignore
		move.l	(a0),d1
		move.l	d1,a0
		bne.s	.NextVoice
		sub	d2,d0

		tst.l	d0
		beq.s	.Error

		move.l	d0,4(a3)
		move.l	d0,d4
		mulu	#as_sizeof,d0
		add.w	#50,d0
		move.l	d0,d3
		jsr	A5AllocMem(a5)
		beq.s	.Error
		move.l	d3,DT_AmplifierstructSize(a5)
		move.l	d0,DT_AmplifierStruct(a5)
		move.l	d0,12(a3)
		move.l	d0,a1
		move.l	d0,a0


		*--------- Left/Right noch setzen ---------*
		subq.l	#1,d4
		move.l	DT_NoteStruct(a5),a1
		move.l	(a1),a1
.SetLeftRight:	move.b	13(a1),d0
		ext.w	d0
		move.w	d0,AS_LeftRight(a0)
		lea	AS_SizeOf(a0),a0
		move.l	(a1),a1
		dbf	d4,.SetLeftRight


		*move.w	#01,AS_Leftright(a0)			;1. Kanal links
		*move.w	#-1,AS_Leftright+as_sizeof*1(a0)	;2. Kanal rechts
		*move.w	#-1,AS_Leftright+as_sizeof*2(a0)	;3. Kanal rechts
		*move.w	#01,AS_Leftright+as_sizeof*3(a0)	;4. Kanal links


		lea	DT_AudTagliste(pc),a0
		move.l	a0,EPG_Amplifiertaglist(a5)
		moveq	#0,d0
		rts

.Error:		moveq	#-1,d0
		rts



DT_AudTagliste:	dc.l	EPAMT_Numstructs,4
.12		dc.l	EPAMT_Audiostructs,0		;Audstruct0
.20		dc.l	EPAMT_Flags,0
		dc.l	0



*-----------------------------------------------------------------------------*
DT_NotePlayer:	
;NSTB_Period	EQU 1		;* Amiga period supplied instead of frequency
;NSTF_Period	EQU 1<<1
;NSTB_ExtPeriod	EQU 2		;* Extended period (period*4) supplied instead of frequency
;NSTF_ExtPeriod	EQU 1<<2
;NSTB_EvenLength EQU 4		;* Samplelength supplied as WORD instead of LONG
;NSTF_EvenLength EQU 1<<4
		movem.l	d0-a6,-(a7)
		move.l	PufferAdr(pc),a5
		move.l	DT_NoteStruct(a5),d0
		beq.w	.Return
		move.l	d0,a4
		move.l	4(a4),d7	;Flags
;		move.l	d7,0
		
		move.l	(a4),d0
		beq.w	.Return
		move.l	d0,a4

		*--------- neue Note (= DMA off) ---------*
		move.l	a4,a0
		move.w	DT_AudTagliste+6(pc),d2
		subq.w	#1,d2
		moveq	#0,d1
		moveq	#1,d3
.pass1		move.b	11(a0),d0
		and.b	#2,d0		;NCHF_Sample
		beq.s	.skip
		or.l	d3,d1		;DMA Mask
.skip		lsl.l	#1,d3
		move.l	(a0),d0
		beq.s	.Last1
		move.l	d0,a0		*add #NoteStruct1-NoteStruct0,a0
		dbf	d2,.pass1
.Last1:
		tst.l	d1
		beq.s	.nostopDMA
		moveq	#0,d0		;D0.w neg=enable ; 0/pos=disable
					;D1 = Maske (LONG !!)
		jsr	ENPP_DmaMask(a5)
		moveq	#0,d0		;D0.w neg=enable ; 0/pos=disable
.nostopDMA:	move.l	d1,-(a7)

		*---------- Neue Note setzen -------------*
		move.l	a4,a0
		move.w	DT_AudTagliste+6(pc),d2		;num Channels
		subq.w	#1,d2
		moveq	#0,d1
.pass2		move.b	11(a0),d0
		and.b	#2,d0				;NCHF_Sample
		beq.s	.skip2

		move.l	$10(A0),d0			;SampleStart
;		move.l	d0,0			;!!
		jsr	ENPP_PokeAdr(A5)

		moveq	#0,d0
		move.w	$14(a0),d0
		btst	#4,d7
		bne.s	.pokeword1
		move.l	$14(A0),d0			;NCH_SampleLength ;SampleLen
		lsr.l	#1,d0				;Bytes -> Words
.pokeword1:
		jsr	ENPP_PokeLen(a5)
.skip2:		addq	#1,d1
		move.l	(a0),d0
		beq.s	.Last2
		move.l	d0,a0		;add #NoteStruct1-NoteStruct0,a0
		dbf	d2,.pass2
.Last2:

		*-------- Volume/Period neu setzen -------*
		move.l	a4,a0
		move.w	DT_AudTagliste+6(pc),d2
		subq.w	#1,d2
		moveq	#0,d1
.pass3
		move.b	11(a0),d0
		and.b	#$10,d0				;NCHF_Volume
		beq.s	.skip3

		move	$24(a0),d0			;Volume
		jsr	ENPP_PokeVol(a5)
.skip3:		move.b	11(a0),d0
		and.b	#8,d0				;NCHF_Frequency
		beq.s	.skip4

		moveq	#0,d0
		move.w	$20(A0),d0			;Period (or Frequency)
		btst	#2,d7
		bne.s	.extper				;4*Period ?
		btst	#1,d7				
		bne.s	.per				;1*Period ?

							;Frequenz in Period umrechnen
		moveq	#0,d0
		move.l	$20(a0),d3			;Frequenz
		beq	.per				;== 0 ? -> weiter
		lsr.l	#1,d3
		move.l	#3546895/2,d0		;Amiga Audiorate
		divu	d3,d0			;
		and.l	#$ffff,d0
		bra.s	.per
.extper
		lsr	#2,d0				;noch ersetzen durch DirektWrite bei 4*Per
.per
		jsr	ENPP_PokePer(a5)
.skip4:		addq	#1,d1
		move.l	(a0),d0
		beq.s	.Last3
		move.l	d0,a0		;add.w #NoteStruct1-NoteStruct0,a0
		dbf	d2,.pass3
.Last3:

		*----- DMA starten (wenn erforderlich) ----*
		move.l	(a7)+,d1
		tst.l	d1
		beq.s	.nostartDMA
		move	#$8000,d0	;D0.w neg=enable ; 0/pos=disable
					;D1 = Maske (LONG !!)
		jsr	ENPP_DmaMask(a5)

		*------ Repeatadr/Repeatlen poken --------*
.NostartDMA:	move.l	a4,a0
		move.w	DT_AudTagliste+6(pc),d2
		subq.w	#1,d2
		moveq	#0,d1
.pass4		move.b	11(a0),d0
		and.b	#4!32!64,d0			;NCHF_Repeat
		beq.s	.skip5
;		bra.s	.skip5

		move.l	$18(a0),d0			;RepeatStart
		jsr	ENPP_PokeAdr(A5)

		moveq	#0,d0
		move.w	$1c(a0),d0			;Repeatlen
		btst	#4,d7
		bne.s	.pokeword2
		move.l	$1c(A0),d0			;NCH_SampleLength ;SampleLen
		lsr.l	#1,d0				;Bytes -> Words
.pokeword2:
		jsr	ENPP_PokeLen(a5)
;		bra.s	.next5
.skip5:
;		move.b	11(a0),d0
;		and.b	#2!4,d0				;NCHF_Sample
;;		beq.s	.next5
;		moveq	#0,d0
;		jsr	ENPP_PokeAdr(a5)
;		jsr	ENPP_PokeLen(a5)
;.next5
		clr.b	11(a0)
		addq	#1,d1
		move.l	(a0),d0
		beq.s	.Last
		move.l	d0,a0		*add #NoteStruct1-NoteStruct0,a0
		dbf	d2,.pass4
.Last:

.Return:
		jsr	ENPP_Amplifier(a5)

		*moveq	#0,d1
		*moveq	#0,d0
		movem.l	(a7)+,d0-a6
		rts



*---------------------- Inserte einen Eintrag in eine Liste ------------------*
* Input: a0=Liste							      *
*	 a1=Neue Node							      *
*	 a2=Node, die davorsteht oder NULL fr erste			      *
*-----------------------------------------------------------------------------*
InsertInList:	movem.l	d0/a0/a3,-(a7)

		*-- Erster Eintrag --*
		move.l	a2,d0
		bne.s	.NoFirst
		ADDHEAD
		bra.s	.Return

		*-- Letzter Eintrag --*
.NoFirst:	cmp.l	LH_TailPred(a0),a2
		bne.s	.NoLast
		ADDTAIL
		bra.s	.Return

.NoLast:	move.l	LN_Succ(a2),d0			;Vorgnger in a2
		beq.s	.Return
		move.l	d0,a3				;Nachfolger in a3

		move.l	a1,LN_Succ(a2)			;Verk. zum Vorgnger
		move.l	a1,LN_Pred(a3)			;Verk. zum Nachfolger

		move.l	a2,LN_Pred(a1)
		move.l	a3,LN_Succ(a1)

.Return:	movem.l	(a7)+,d0/a0/a3
		rts

*----------------------------------------------------------------------------*
SetProgramMode:	move.b	d2,ProgrammMode(a5)
		and.l	#$ffffffffee7,EPG_SomePrefs(a5)	;Prefs-Flags setzen
		tst.w	d2
		beq.s	.ProggyOK
		moveq	#EGPRF_LoadPrev,d1
		subq.w	#1,d2
		beq.s	.SetFlag
		moveq	#EGPRF_LoadNext,d1
		subq.w	#1,d2
		beq.s	.SetFlag
		moveq	#EGPRF_RandomModule,d1
.SetFlag:	move.l	EPG_SomePrefs(a5),d0
		bset	d1,d0
		move.l	d0,EPG_SomePrefs(a5)
.ProggyOk:	moveq	#EPNR_ProgramMode,d0
		jsr	A5SetMutalExclude(a5)

		cmp.l	#Mode_Config,TestBits(a5)
		beq.w	.NoChange

		move.l	#EUT_ChangePrefs,d7
		move.w	#EPNr_ProgramMode,d0
		moveq	#0,d1
		move.b	ProgrammMode(a5),d1
		moveq	#0,d2			;aus
		jsr	A5UserCallUp4(a5)

.NoChange:	move.b	#-1,OldDirJumpProgramMode(a5)
		move.b	ProgrammMode(a5),d0
		ext.w	d0
		add.w	#LNr_NoNewModule,d0
		jmp	A5ScrollNew(a5)


*---------------------------------------------------------------------------*
Changea6_2:	movem.l	d0-a6,-(a7)
		link	a2,#4
		move.l	A5JumpTo+2(a5),a0
	;	lea	JumpTo(pc),a0
		add.l	d1,d1
		add.l	d1,a0
		lea	DecodeStruct3-Jumpto+210-128(a0),a0
		move.l	a0,60(a2)
		unlk	a2
		movem.l	(a7)+,d0-a6
		rts


*----------------------------------------------------------------------------*





*********** Definitionen fr Textrequester *********
**** %s	= String				****
**** %d = Zahl (dezimal und hidenull)		****
**** %D = Zahl (dezimal und kein hidenull)	****
**** %h = Zahl (hexadezimal)			****
**** %u = Zahl (Dual)				****
****************************************************
*-------------------------------- TextRequest ------------------------------*
*----	ARG1 = TextAdresse						----*
*----	ARG2 = Pointer to Pubscreenname (only Kick2.0)			----*
*----	ARG3 = Position on Screen (x.w & y.w)				----*
*----	ARG4 = Pointer to Gadgetnames					----*
*----	ARG5 = Poniter to Requestername					----*
*----	ARG6 = Pointer to ArgumentListe					----*
*----	ARG7 = Pointer to ImageDatas					----*
*---------------------------------------------------------------------------*
;		include	"EP_Textrequest.S"
*********** Definitionen fr Textrequester *********
**** %s	= String				****
**** %d = Zahl (dezimal und hidenull)		****
**** %D = Zahl (dezimal und kein hidenull)	****
**** %h = Zahl (hexadezimal)			****
**** %u = Zahl (Dual)				****
****************************************************
*-------------------------------- TextRequest ------------------------------*
*----	ARG1 = TextAdresse						----*
*----	ARG2 = Pointer to Pubscreenname (only Kick2.0)			----*
*----	ARG3 = Position on Screen (x.w & y.w)				----*
*----	ARG4 = Pointer to Gadgetnames					----*
*----	ARG5 = Pointer to Requestername					----*
*----	ARG6 = Pointer to ArgumentListe					----*
*----	ARG7 = Pointer to ImageDatas					----*
*----	ARG8 = Flags		EPTRF_Center...				----*
*----				EPTRF_TestTimeOut			----*
*----  OutPut:								----*
*----	ARG1 = GadgetNr							----*
*---------------------------------------------------------------------------*
EPP_TextRequest:movem.l	d1-a6,-(a7)
		move.l	PufferAdr,a5

		*----- Enginegui abfragen -----*
		*move.l	#EUT_OpenAWindow,d0
		*moveq	#EUTY_TextRequest,d1
		*jsr	A5UserCallUp(a6)


		*--------- interner Textrequest ---------*
		move.l	EPG_Arg1(a5),a4		;TextAdr
		clr.l	EPG_Arg1(a5)

		lea	EPG_ReqToolsBase(a5),a3
		LA1	LNr_ReqToolsName
		moveq	#38,d0
		jsr	A5OpenLib(a5)
		move.l	d0,a6
		tst.l	d0
		beq.w	.NoReqTools

		*---- ReqTools-Request ----*
		* Output: d0=Nummer des Gadgets
		*	  0 = ganz rechts
		*	  1 = von links nach rechts
		lea	TextRequestTags(a5),a0	;Tags fr Textrequest
		move.l	EPG_Arg8(a5),d3
		tst.l	EPG_Arg3(a5)
		blt.s	.NoPos
		move.l	#_RT_LeftOffset,(a0)+
		move.w	EPG_Arg3(a5),(a0)+
		addq.l	#2,a0
		move.w	EPG_Arg3+2(a5),(a0)+
		addq.l	#2,a0
.NoPos:		move.l	EPG_Arg2(a5),d0
		beq.s	.NoPub
		move.l	#_RT_PubScrName,(a0)+
		move.l	d0,(a0)+
.NoPub:		*move.l	#_RT_TextAttr,(a0)+
		*lea	GlobalFont(a5),a1
		*move.l	a1,(a0)+
		move.l	#RTEZ_ReqTitle,(a0)+
		LA1	LNr_EagleplayerRequest
		move.l	EPG_Arg5(a5),d0		;Requestertitle
		beq.s	.NoName
		move.l	d0,a1
.NoName:	move.l	a1,(a0)+
		btst	#EPTRF_Center,d3
		beq.w	.NoCenter
		move.l	#$80000016,(a0)+		*RTEZ_Flags (Center)
		move.l	#4,(a0)+			*EZREQF_Centertext
.NoCenter:	*move.l	#RTEZ_Flags,(a0)+
		*move.l	#EZREQF_CenterText,(a0)+
		move.l	#_RT_Underscore,(a0)+
		move.l	#"_",(a0)+
		clr.l	(a0)

		move.l	DTG_IntuitionBase(a5),a6
		lea	TextReqSecondsZahler(a5),a0
		lea	TextReqMicrosZahler(a5),a1
		jsr	_LVOCurrentTime(a6)

		lea	TextRequestTags(a5),a0	;Tags fr Textrequest
		move.l	a4,a1			;Text
		move.l	EPG_Arg4(a5),d0
		move.l	d0,a2		;Gadgetlist
		bne.s	.GadgetsOk
		LA2	LNr_GA_Ok
.GadGetsOk:	move.l	EPG_Arg6(a5),a4		;APTR to Arglist
		sub.l	a3,a3			;Reqtoolsinfo
		move.l	EPG_ReqToolsBase(a5),a6
		jsr	_LVOrtEZRequestA(a6)
		move.l	d0,EPG_Arg1(a5)

		btst	#EPTRF_TestTimout,d3
		beq.s	.NoReqTools
		move.l	DTG_IntuitionBase(a5),a6
		lea	TextReqSecondsZahler2(a5),a0
		lea	TextReqMicrosZahler2(a5),a1
		jsr	_LVOCurrentTime(a6)
		move.l	TextReqMicrosZahler2(a5),d0
		sub.l	TextReqMicrosZahler(a5),d0
		cmp.l	#1000,d0
		bhi.s	.NoReqTools
		move.l	#EPR_FunctionNotEnabled,EPG_Arg1(a5)
.NoReqTools:	move.l	EPG_Arg1(a5),d0
		movem.l	(sp)+,d1-a6
		rts


*TextRequestTags:
*		*dc.l	$80000004,0			;_RT_LeftOffset,0
*		*dc.l	_RT_TopOffset,0
*		*dc.l	_RT_PubscrName,0
*		*dc.l	_RT_Window,0
*		dc.l	_RT_Underscore,"_"
*		*dc.l	_RT_TextAttr,0		;Def.: ScreenFont
*		dc.l	RTEZ_ReqTitle,MessageTitle
*		*dc.l	RTEZ_Flags,EZREQF_CenterText	;Text wird zentriert
*		dc.l	0
*
*Args:		dc.l	Module.MSG
*		dc.l	1234
*		dc.l	0
*		even
*
*
*Gadgettexte:	dc.b	"  _Ja  |  _Vielleicht  |  _Nein  ",0
*MessageTitle:	dc.b	"Eagleplayer-Message",0
*Message:	dc.b	"Das Module '%s' kann nicht als",10
*		dc.b	"ProTracker-Module gespeichert werden",10,10
*		dc.b	"Das Module hat die Lnge %ld Bytes.",10,0
*MyReqToolsName:	dc.b	"reqtools.library",0
*Module.MSG:	dc.b	"Mod.Condom_Corruption",0
*


*	*	bsr.w	.TextR
*		movem.l	(a7)+,d1-a6
*		move.l	EPG_Arg1(a5),d0
*		rts
*


*-----------------------------------------------------------------------------*
* Falls unregistriert wird Nervi ausgegeben.
* Input: d6=EPNummer
NervRequest1:	movem.l	d0-a6,-(a7)
		tst.b	KeyOn(a5)
		bne.s	.Return

		cmp.w	#EPNr_SaveModule,d6
		beq.s	.Return

		lea	KommandoTabelle,a0
		mulu	#EPRT_SizeOf,d6
		lea	-EPRT_SizeOf(a0,d6.l),a0
		move.b	EPRT_Flags(a0),d0
		btst	#EPRTF_Key,d0
		beq.s	.Return

		move.w	#LNr_TR_RegisteredNormal,d0
		jsr	A5NervRequest2(a5)
.Return:	movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
* Jetzt wird der Nervrequest ausgeben.
* Input: d0=Nummer des Textes
NervRequest2:	movem.l	d0-a6,-(a7)

		tst.b	OnHelp(a5)		;um Rekursion der in einigen
		bne.w	.Return			;Zeilen erscheinenden Routine
						;zu verhindern
		cmp.l	#Mode_Config,TestBits(a5)
		beq.w	.Return
		move.l	d0,d7
.Retry:		move.l	d7,d0
		jsr	A5GetLocaleString(a5)
		move.l	a0,EPG_Arg1(a5)				;Text
		lea	PubScreenName(a5),a0
		move.l	a0,EPG_Arg2(a5)				;PubScreen
		clr.l	EPG_Arg3(a5)
		subq.l	#1,EPG_Arg3(a5)				;Pos
		LA0	LNr_GA_Registered
		move.l	a0,EPG_Arg4(a5)				;Gadgets
		LA0	LNr_NervRequest
		move.l	a0,EPG_Arg5(a5)				;Title
		lea	ScrollArgs(a5),a0
		move.l	a0,EPG_Arg6(a5)				;Args
		moveq	#-1,d0
		move.l	d0,EPG_Arg7(a5)				;Imagedatas
		moveq	#7,d0
		move.l	d0,EPG_ArgN(a5)
		clr.l	EPG_Arg8(a5)

		jsr	A5TextRequest(a5)
		tst.l	d0
		bne.s	.CloseHelp

		*---- Registrierung ----*
		move.w	#LNr_Registration,d0
		jsr	A5GetLocaleString(a5)
		move.l	a0,a3
		moveq	#0,d2
		move.w	#EPNr_HelpLink,d0
		jsr	A5Jumpto(a5)
		bra.s	.Retry

.CloseHelp:	tst.b	OnHelp(a5)
		beq.s	.Return
		moveq	#EPNr_Help,d0
		moveq	#-1,d2
		jsr	A5JumpTo(a5)

.Return:	movem.l	(a7)+,d0-a6
		rts

	*--------------------------------------------------*
	*------------ Include EP-Unterprogramme -----------*
	*--------------------------------------------------*
;		include	"EP_Unterprogramme2.S"


*-------------------------------------------------------------------------*
FirstKeyDecode:	lea	TextPuffer+4(a5),a3
		add.l	#"CrM!"-"ErM!",KeyCrmHelp-TextPuffer+4(a3)

		move.l	File-(TextPuffer+4)(a3),a4
		move.l	a4,a1
		move.l	PPAdr-(TextPuffer+4)(a3),a0
		move.l	FileSizeNeu-(TextPuffer+4)(a3),d1
		jsr	A5CopyText2(a5)

		move.l	PPAdr-(TextPuffer+4)(a3),a4
		move.l	FileSizeNeu-(TextPuffer+4)(a3),d1


		jsr	A5Key_DecKeyFile1(a5)
		jsr	A5Key_DecKeyFile2(a5)

	*----- Code-Merkzellen setzen -----*
		move.b	EPKF_AllDecodeK(a4),Code-(TextPuffer+4)(a3)
		move.b	EPKF_AllDecode1(a4),CodePara1-(TextPuffer+4)(a3)
		move.b	EPKF_AllDecode2(a4),CodePara2-(TextPuffer+4)(a3)
		move.b	EPKF_AllDecode3(a4),CodePara3-(TextPuffer+4)(a3)
		move.b	EPKF_AllDecode4(a4),CodePara4-(TextPuffer+4)(a3)
		lea	EPKF_Codestart+1(a4),a0		;Start des Decodenen


		jsr	A5Key_DecKeyFile3(a5)



		lea	-(EPKF_Codestart+1)(a2,d4.l),a4	;KeyStructAdr im KeyPuffer


		movem.l	d1-a6,-(a7)
		jsr	A5Key_EndC(a5)
		cmp.w	d5,d4
		bne.w	.ChkSumError


		jsr	A5Key_Verl11(a5)
		jsr	A5Key_Chk1(a5)
		cmp.w	EPKF_ChkKey1(a4),d0
		bne.w	.ChkSumError

		jsr	A5Key_Verl12(a5)
		cmp.w	EPKF_ChkKey2(a4),d0
		bne.w	.ChkSumError

		jsr	A5Key_Verl13(a5)
		cmp.w	EPKF_ChkKey3(a4),d0
		bne.w	.ChkSumError

;		move.l	File-(TextPuffer+4)(a3),KeyAdr(a5)
;		move.l	FileSizeNeu-(TextPuffer+4)(a3),KeySize(a5)



		move.b	ImmerEins(a5),KeyOn-(TextPuffer+4)(a3)	;Key Ok !?!?!

								;+-+-
								;nun auch in
								;den Globals
								;verstecken
	move.b	ImmerEins(a5),EPG_Wordreserved7-(TextPuffer+4)(a3)

	moveq	#$52-7,d0				;fr Men
	move.b	d0,Menusetting-(TextPuffer+4)(a3)	;erlauben
	addq.b	#7,Menusetting-(TextPuffer+4)(a3)	;von Dirnamen

		move.l	EmptyPuffer(a5),d0
		bra.b	.ReturnIt

.ChkSumError:	move.l	ImmerEins_2(a5),d0
.ReturnIt:	move.l	a4,Key_Struct-(TextPuffer+4)(a3)
		movem.l	(a7)+,d1-a6
		rts






*------------------------- Stringgadget fr Mainwindow ----------------------*
*-----	d0 = Flags 0=Ziffern 1=Text !2=Invisible			-----*
*-----  d1 = MinValue (bei Ziffern)					-----*
*-----	d2 = max. Lnge des Strings oder MaxValue			-----*
*-----	a0 = Puffer fr Text oder ZellenAdr				-----*
*-----	a1 = TextFmT							-----*
*-----  a2 = TextFmtArgs						-----*
*-----	a3 = Requestertitle						-----*
*----- Output:								-----*
*-----	d0 = Ergebnis 0=Ok, sonst Error					-----*
*-----  d1 = Anzahl der eingebenen Zeichen oder Value			-----*
*----------------------------------------------------------------------------*
GetStringGadget:movem.l	d2-a6,-(a7)
		move.l	d0,d3
		move.l	d1,d4
		moveq	#0,d0
		moveq	#0,d1
		cmp.l	#Mode_Config,TestBits(a5)
		beq.w	.NoGui

		move.l	d2,d5
		move.l	a0,a4
		move.l	a1,d6
		move.l	#EUT_StringGadget,d0
		jsr	A5UserCallUp3(a5)
		bne.w	.Ok

		cmp.l	d2,a3
		bne.s	.TitleOk
		LA3	LNr_EagleplayerRequest		*Title setzen
.TitleOk:	move.l	a3,-(a7)
		lea	EPG_ReqToolsBase(a5),a3
		LA1	LNr_ReqToolsName
		moveq	#38,d0
		jsr	A5OpenLib(a5)
		move.l	(a7)+,a3
		move.l	d0,a6
		tst.l	d0
		bne.s	.LibOk
		moveq	#EPR_CantFindReqTools,d0
		bra.w	.Ok


	*--------- internes StringGadget ----------*
.LibOk:		lea	TextRequestTags(a5),a0
		move.l	#$80000001,(a0)+		;_RT_Window
		jsr	A5GetMainWindowHandle(a5)
		move.l	d0,(a0)+
		move.l	#$80000026,(a0)+		*TextFmt
		move.l	d6,(a0)+
		move.l	#$80000027,(a0)+		*TextFmtArgs
		move.l	a2,(a0)+
		move.l	#$80000050,(a0)+		*AllowEmpty
		move.l	#1,(a0)+
		btst	#EPTRF_Invisible,d3
		beq.s	.NoInvisible
		move.l	#$80000024,(a0)+		*Invisible
		move.l	#1,(a0)+
.NoInvisible:	btst	#EPTRF_Center,d3
		beq.s	.NoCenter
		move.l	#$80000064,(a0)+		*CenterText
		move.l	#1,(a0)+
.NoCenter:	move.l	#$8000000B,(a0)+		*Underscore
		move.l	#"_",(a0)+
		btst	#0,d3
		bne.s	.NoZahl
		tst.l	d5
		beq.s	.NoZahl
		move.l	#$8000001e,(a0)+		*MinLong
		move.l	d4,(a0)+
		move.l	#$8000001f,(a0)+		*MaxLong
		move.l	d5,(a0)+
.NoZahl:	clr.l	(a0)

	jsr	A5WaitMouse(a5)

		move.l	a4,a1				*Puffer
		move.l	d5,d0				*MaxChars
		move.l	a3,a2				*Title
		sub.l	a3,a3				*Reqtoolsinfo
		lea	TextRequestTags(a5),a0
		btst	#EPTRF_Zahl,d3
		bne.s	.Long
		jsr	_LVOrtgetstringA(a6)	;d0=1 --> ok
		bra.s	.ReqOk
.Long:		jsr	_LVOrtgetlongA(a6)	;d0=1 --> ok
.ReqOk:
	jsr	A5ClearMouse(a5)

		tst.l	d0
		beq.s	.Error
		moveq	#0,d0
		move.l	(a4),d1
		bra.s	.Ok

.Error:		moveq	#EPR_FileReqCancelled,d0
		bra.s	.Ok

.NoGui:		moveq	#EPR_CantAddGadget,d0
.Ok:		movem.l	(a7)+,d2-a6
		tst.l	d0
		rts







*-----------------------------------------------------------------------*
* Es wurde ein Fehler im Code des Programms gefunden			*
* Der Einsprung der Routine erfolgt ber RTS				*
KeyFehler:	if	Guru
		move.l	d6,d2
		lea	EmptyPuffer-4(a5),a1
		moveq	#4,d3
		add.l	(a1),d4
		move.l	d2,-(a7)
		jsr	A5Return(a5)
		tst.l	d0
		beq.s	.NoError
		moveq	#4,d4
.NoError:	move.l	(a7),d2
		add.l	d3,d1
		rts
	else
		moveq	#6,d0
.Blink:		move.w	#$f00,$dff180
		dbf	d0,.Blink
		rts
	endc


*-------------------- Abortgadget fr Player/Engineladen -------------------*
*----------------------------------------------------------------------------*
AddAbortGadget:	movem.l	d1-a6,-(a7)
		moveq	#0,d0
		tst.b	OnAbortGadget(a5)
		bne.s	.Error
		
		move.l	#EUT_AddAbortGadget,d0
		jsr	A5UserCallUp3(a5)
		bne.s	.Ok

.NoGui:		moveq	#EPR_CantAddGadget,d0
.Ok:		tst.l	d0
		bne.s	.Error
		move.b	#1,OnAbortGadget(a5)
.Error:		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts




*-------------------- Abortgadget fr Player/Engineladen --------------------*
*----- Output:								-----*
*-----	d0 = Error oder NULL
*-----	d1 = 0 ---> Keine AbortMsg					-----*
*-----  d1 = 1 ---> Abort
*----------------------------------------------------------------------------*
GetAbortMsg:	movem.l	d2-a6,-(a7)
		move.l	PufferAdr3(pc),a5
		moveq	#0,d1			;default = kein Abort
		moveq	#0,d7			;kein Abbruch mglich
		*moveq	#EPR_Functionaborted,d7
		*tst.b	OnAbortGadget(a5)
		*beq.s	.Return

		move.l	#EUT_GetAbortMSG,d0
		jsr	A5UserCallUp3(a5)
		*bne.w	.Return

		*move.l	d0,d7
.Return:	*move.l	d7,d0
		moveq	#0,d0
		movem.l	(a7)+,d2-a6
		tst.l	d0
		rts


*-------------------- Abortgadget fr Player/Engineladen -------------------*
*----------------------------------------------------------------------------*
RemoveAbortGadget:	
		movem.l	d0-a6,-(a7)
		tst.b	OnAbortGadget(a5)
		beq.s	.ok
		
		move.l	#EUT_RemoveAbortGadget,d0
		jsr	A5UserCallUp3(a5)
	*	bne.s	.Ok

	*	moveq	#EPR_FatalError,d0
.Ok:		clr.b	OnAbortGadget(a5)
		movem.l	(a7)+,d0-a6
		rts


*-----------------------------------------------------------------------------*
* Input: d0=Localenr
* Output:d0=Text oder Null
EPP_GetLocaleString:
		movem.l	d1-d7/a1-a6,-(a7)
		move.l	PufferAdr3(pc),a5
		jsr	A5GetLocaleString(a5)
		lea	InternalStrings,a1		*Default (fr Fehler)
		move.l	d0,a0
		cmp.l	d0,a1
		bne.s	.NoError
		moveq	#0,d0
.NoError:	movem.l	(a7)+,d1-d7/a1-a6
		tst.l	d0
		rts


*---------------------------------------------------------------------------*
* Input: a0 = def. String						    *
*	 a1 = Argumenttable						    *
*	 a2 = Ziel							    *
*	 d0 = Lnge des Ziels						    *
* Output:d0 = Error oder Null
EPP_RawToFormat:movem.l	d1-a6,-(a7)
		move.l	PufferAdr3(pc),a5

		move.l	a2,a3
		lea	.CopyRoutine(pc),a2
		move.l	a3,d0
		beq.s	.Ende
		cmp.l	a0,a3
		beq.s	.Ende
		Execbase
		jsr	_LVORawDoFMT(a6)
.Ende:		movem.l	(a7)+,d1-a6
		moveq	#0,d0
		rts

.CopyRoutine:	move.l	a0,-(a7)
		move.l	PufferAdr(pc),a0
		*lea	ScrollPuffer+ScrollPufferSize-2(a0),a0
		*cmp.l	a0,a3
		*beq.s	.CR_Ende
		move.b	d0,(a3)+
		clr.b	(a3)
.CR_Ende:	move.l	(a7)+,a0
		rts



	*------------------- Save Mem to Disk ----------------------*
	*---- ARG1 = StartAdr					----*
	*---- ARG2 = Lnge					----*
	*---- ARG3 = PathAdr					----*
	*---- ARG4 = CrunchMode					----*
	*---- ARG5 = Flags					----*
	*----	Bit 0 = Soll ein Anzeige in Playerswindow 0=ja  ----*
	*----	Bit 1 = Immer deprotecten			----*
	*----	Bit 2 = Safe Save				----*
	*-----------------------------------------------------------*
EPP_SaveMem:	movem.l	d1-a6,-(a7)
		move.l	PufferAdr3(pc),a5
		clr.l	OldDir(a5)
		moveq	#EPR_Functionaborted,d0
		move.l	EPG_ArgN(a5),d1
		subq.l	#5,d1
		beq.s	.ArgsOk
		addq.l	#2,d1
		bne.w	.SaveReturn
		clr.l	EPG_Arg4(a5)			;kein Crunchen
		move.b	CrunchMode(a5),EPG_Arg4+3(a5)
		clr.l	EPG_Arg5(a5)			;Anzeige ja
		*bset	#0,EPG_Arg5+3(a5)
.ArgsOk:	clr.l	EPG_Arg6(a5)
		clr.l	EPG_Arg7(a5)
		clr.l	EPG_Arg8(a5)
		move.l	EPG_Arg3(a5),SaveMerkArg3(a5)

		lea	CrunchMode(a5),a0
		moveq	#0,d1
		move.b	(a0),d1
		move.l	EPG_Arg4(a5),d0			;0=No crunchen
		beq.s	.NoCrunch
		cmp.b	#4,d0
		blo.s	.UseThisCrunchMode
		move.l	d1,d0
.UseThisCrunchMode:move.l d0,EPG_Arg4(a5)

		tst.b	KeyOn(a5)
		bne.s	.KeyDa
		move.w	#LNr_TR_RegisteredSaveModule,d0
		jsr	A5NervRequest2(a5)
		bra.w	.OpenError
.KeyDa:	

		move.l	EPG_Arg3(a5),a1
		jsr	A5GetFileName(a5)
		move.l	a1,NewCrunchName(a5)
		jsr	A5CrunchMem(a5)
		clr.l	NewCrunchName(a5)
		tst.l	d0
		bne.w	.SaveReturn

	*--------- Save-File ffnen ----------*
.NoCrunch:	move.l	EPG_Arg3(a5),a1
		jsr	A5GetFileName(a5)

		LA0	LNr_EPDirName
		jsr	ENPP_StringCMP(a5)
		beq.s	.NoPrintName
		move.l	a1,ScrollArgs(a5)
		LA0	LNr_Saving
		jsr	A5PrintText(a5)

.NoPrintName:	bclr	#2,EPG_Arg5+3(a5)
		move.l	EPG_Arg3(a5),d1
		lea	CrunchMode(a5),a0
		tst.b	KeyOn-CrunchMode(a0)
		beq.w	.OpenError
		tst.b	OnSafeSave(a5)			;btst#2,EPG_Arg5+3(a5)
		beq.w	.NoSafeSave1

	;*************************************************************
	;**** Copiert den Dir-Anteil des Phades nach Puffer in a0 ****
	;**** Input =	a0 Puffer frs Dir			  ****
	;****		a1 Puffer wo Path steht			  ****
	;****		d3 Lnge des Phades			  ****
	;**** Output	a0 Startadr des Filenames		  ****
	;*************************************************************
		lea	TextPuffer(a5),a0
		move.l	d1,a1
		moveq	#-1,d3
.SaveFindTextEnd:addq.l	#1,d3
		tst.b	(a1)+
		bne.s	.SaveFindTextEnd

		move.l	d1,a1
		jsr	A5CreateDirAusPath(a5)
		move.l	a0,EPG_Arg3(a5)		;Pfad neu festlegen, weil Dir ges

		lea	TextPuffer(a5),a0	;neuer Dirpuffer
		move.l	a0,d1
		move.l	DTG_Dosbase(a5),a6
		moveq	#-2,d2
		jsr	_LVOLock(a6)

		move.l	EPG_Arg3(a5),d1
		tst.l	d0
		beq.s	.NoSafeSave1
		move.l	d0,d1
		jsr	_LVOCurrentDir(a6)
		move.l	d0,OldDir(a5)
		LA0	LNr_EPTName
		addq.l	#2,a0
		move.l	a0,d1
		bset	#2,EPG_Arg5+3(a5)
.NoSafeSave1:	move.l	#1006,d2			;--> New File
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOOpen(a6)
		move.l	d0,d7
		bne.w	.OpenOk



	*--- Testen, ob File protected ist ---*
		jsr	A5IOErr(a5)
		cmp.w	#222,d0				;gegen Lschen geschtzt
		beq.w	.FileSowasVon
		cmp.w	#223,d0				;gegen berschreiben geschtzt
		bne.w	.OpenError

.FileSowasVon:	btst	#1,EPG_Arg5+3(a5)		;SafeSave=Deprotection
		bne.w	.Deprotecten

	*----- Fragen, nach deprotecten ----*
		btst	#1,EPG_Arg5+3(a5)
		bne.w	.Deprotecten
		lea	SaveFilePuffer(a5),a1
		bsr.w	FrageDeprotection
		bne.w	.OpenError

	*---------- File deprotecten ---------*
.Deprotecten:	LA0	LNr_EPTName
		addq.l	#2,a0
		move.l	a0,d1
		btst	#2,EPG_Arg5+3(a5)
		bne.w	.YesSafeSave2
		move.l	EPG_Arg3(a5),d1
.YesSafeSave2:	move.l	DTG_Dosbase(a5),a6
		moveq	#0,d2
		jsr	_LVOSetProtection(a6)

	*- Noch einmal versuchen, zu ffnen --*
		La0	LNr_EPTName
		addq.l	#2,a0
		move.l	a0,d1
		btst	#2,EPG_Arg5+3(a5)
		bne.w	.YesSafeSave3
		move.l	EPG_Arg3(a5),d1
.YesSafeSave3:	move.l	#1006,d2			;--> New File
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOOpen(a6)
		move.l	d0,d7
		beq.w	.OpenError

	*---------- Daten schreiben ----------*
.OpenOk:	move.l	EPG_Arg1(a5),d2
		move.l	d7,d1
		move.l	EPG_Arg2(a5),d3
		jsr	_LVOWrite(a6)
		move.l	d0,d6

	*------------- Datei closen ----------*
		move.l	d7,d1
		jsr	_LVOClose(a6)
		cmp.l	d6,d3
		bne.w	.WriteError


	*-------- Protectionbits setzen --------*
		La0	LNr_EPTName
		addq.l	#2,a0
		move.l	a0,d1
		btst	#2,EPG_Arg5+3(a5)
		bne.w	.YesSafeSave4
		move.l	EPG_Arg3(a5),d1
.YesSafeSave4:	moveq	#2,d2
		tst.b	OnPBits(a5)
		beq.s	.NoDelProtection
		btst	#1,EPG_Arg5+3(a5)
		bne.w	.NoDelProtection
		moveq	#7,d2				;nur lesbar !!!
.NoDelProtection:move.l	DTG_Dosbase(a5),a6
		jsr	_LVOSetProtection(a6)


	*----------- Commentare setzen ---------*
		LA0	LNr_EPTName
		addq.l	#2,a0
		move.l	a0,d1
		btst	#2,EPG_Arg5+3(a5)
		bne.w	.YesSafeSave5
		move.l	EPG_Arg3(a5),d1
.YesSafeSave5:	LA0	LNr_CommentText
		move.l	a0,d2
		jsr	_LVOSetComment(a6)

	*- Tempfile ins richtige File umbennen -*
		btst	#2,EPG_Arg5+3(a5)
		beq.w	.NoSafeSave6
		move.l	EPG_Arg3(a5),d1			;altes Files lschen
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVODeleteFile(a6)
		La0	Lnr_EPTName
		addq.l	#2,a0
		move.l	a0,d1
		move.l	EPG_Arg3(a5),d2
		jsr	_LVORename(a6)
.NoSafeSave6:	moveq	#0,d0
		bra.s	.SaveReturn

	*----- Es trat ein Fehler beim Schreiben der Datei auf ! -----*
.WriteError:	La0	LNr_EPTName
		addq.l	#2,a0
		move.l	a0,d1
		btst	#2,EPG_Arg5+3(a5)
		bne.w	.WriteErrorSafe
		move.l	EPG_Arg3(a5),d1
.WriteErrorSafe:move.l	DTG_Dosbase(a5),a6
		jsr	_LVODeleteFile(a6)

;		btst	#2,EPG_Arg5+3(a5)
;		beq.w	.OpenError
;		
;	*--------- altes File berschreiben (Fragen) ---------*
;		move.l	SaveMerkArg3(a5),EPG_Arg3(a5)	;Arg3 zurcksetzen
;


.OpenError:	moveq	#EPR_SaveError,d0
.SaveReturn:	move.l	d0,-(a7)
		jsr	A5SetOldDir(a5)
		bsr	FreeCrunchMem
		move.l	(a7)+,d0
		move.l	SaveMerkArg3(a5),EPG_Arg3(a5)	;Arg3 zurcksetzen
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*----------------------------------------------------------------------------*
*-------------- Warten auf Hotkey/Message vom Exchange Programm -------------*
CommodityMSG:	move.l	d0,a4
		move.l	d0,a0
		move.l	EPG_Commoditiesbase(a5),a6
		jsr	_LVOCxMSGType(a6)
		move.l	a4,a1			;Message-Ptr

		cmp.l	#64,d0			;Handelt es sich um ein Command
		beq	.Commando

	*------ Es wurde das angegebene Hotkey bettigt -----*
		cmp.l	#32,d0			;Hotkey
		bne.w	.Reply
		tst.b	CX_IEventErlaubt(a5)	;Ist IEvenErlaubt
		bne.w	.Reply

		*tst.l	WindowOffen(a5)
		*beq.s	.OpenWindow

		tst.b	OnNoGui(a5)
		bne.s	.NoGui

		movem.l	d0-a6,-(a7)
		moveq	#EPNr_Iconify,d0
		moveq	#-1,d2
		jsr	A5JumpTo(a5)
		movem.l	(a7)+,d0-a6
		bra.w	.Reply

.NoGui:		jsr	A5LoadDefaultGui(a5)
		bra.w	.Reply
		

*Jetzt		tst.b	OnAllWindowsClosed(a5)
*Jetzt		bne.s	.OpenWindow		*	NormalOpenWin
*Jetzt		bra.s	.CloseWindow

*		tst.b	OnIconify(a5)
*		bne.w	.OpenWindow
*		tst.l	WindowOffen(a5)
*		beq.w	.OpenWindow
*		bra.s	.CloseMainWindow
*
*
*.NormalOpenWin:	movem.l	d0-a6,-(a7)
*		tst.l	WindowOffen(a5)
*		bne.s	.NormalClose
*		jsr	A5OpenMainWindow(a5)
*		jsr	A5ScreenToFront(a5)
*		bra.s	.NormalOK
*.NormalClose:	jsr	A5CloseMainWindow(a5)
*.NormalOk:	movem.l	(a7)+,d0-a6
*		bra.w	.Reply

	*---------- Es handelt sich um ein Kommando ---------*
.Commando:	move.l	a4,a0
		jsr	_LVOcxmsgid(a6)
		move.l	a4,a1
		cmp.l	#25,d0			;Programm zum 2.Male aufgerufen ?
		beq	.OpenWindow			
		cmp.l	#23,d0			;Beenden ?
		beq	.Exit
		cmp.l	#17,d0			;Aktivieren ?
		beq.w	.Enable
		cmp.l	#15,d0			;Deaktivieren ?
		beq.w	.Disable
		cmp.l	#19,d0			;Openwindow
		beq.s	.OpenWindow
		cmp.l	#21,d0			;CloseMainWindow
		bne.w	.Reply

	*------- Window closen -------*
.CloseWindow:

		movem.l	d0-a6,-(a7)
		moveq	#EPNr_Iconify,d0
		moveq	#1,d2
		jsr	A5JumpTo(a5)
		movem.l	(a7)+,d0-a6
		bra.s	.Reply

*Jetzt		movem.l d0-a6,-(a7)
*Jetzt		moveq	#USClass_Hide,d0	;User-Type (Dumy) Prg stoppen
*Jetzt		jsr	A5SendeAllMessage(a5)
*Jetzt		jsr	A5CloseMainWindow(a5)
*Jetzt		move.b	#1,OnAllWindowsClosed(a5)
*Jetzt		movem.l	(a7)+,d0-a6
*Jetzt		bra.s	.Reply

	*------- Window ffnen -------*
.OpenWindow:	tst.l	UMG_UPrgSAdr(a5)
		bne.s	.OpenWindow2
		tst.b	OnNoGui(a5)
		bne.s	.OpenWindow2_2
		move.l	#1,WinMerk(a5)
* 02.08.97	tst.b	OnIconify(a5)
*		bne.s	.OpenWindow2
.FileRequest:	jsr	A5LoadDefaultGui(a5)
		LA0	LNr_EPVersion
		move.l	A0,ScrollArgs(a5)
		LA0	LNr_Welcome
		jsr	A5ScrollNewText(a5)
.OpenWindow2:	move.l	#1,WinMerk(a5)
		movem.l	d0-a6,-(a7)
		moveq	#EPNr_Iconify,d0
		moveq	#0,d2
		jsr	A5JumpTo(a5)
		movem.l	(a7)+,d0-a6
		bra.s	.Reply

.OpenWindow2_2:	tst.b	OnIconify(a5)
		bne.s	.OpenWindow2
		bra.s	.FileRequest

*Jetzt		movem.l	d0-a6,-(a7)
*Jetzt		tst.b	OnIconify(a5)
*Jetzt		beq.s	.OpenWindowNoI
*Jetzt		clr.b	OnIconify(a5)
*Jetzt		jsr	A5Iconify(a5)		;Deiconifyzieren
*Jetzt		bra.s	.IconifyOk
*Jetzt
*Jetzt.OpenWindowNoI:	jsr	A5LoadDefaultGui(a5)
*Jetzt		jsr	A5OpenOldEngines(a5)
*Jetzt.IconifyOk:	jsr	A5ScreenToFront(a5)
*Jetzt		LA0	LNr_EPVersion
*Jetzt		move.l	A0,ScrollArgs(a5)
*Jetzt		moveq	#LNr_Welcome,d0
*Jetzt		jsr	A5Scrollnew(a5)
*Jetzt		clr.b	OnAllWindowsClosed(a5)
*Jetzt		movem.l	(a7)+,d0-a6
*Jetzt		bra.s	.Reply

	*------- Broker deaktivieren ------*
.Disable:	move.b	#1,CX_IEventErlaubt(a5)
		bra.s	.Reply

	*-------- Broker aktivieren --------*
.Enable:	clr.b	CX_IEventErlaubt(a5)

	*----- Reply-Commodity-Message -----*
.Reply		jsr	A5CopyMessage2(a5)
		rts

	*----- Commodity sagt "EXIT" ------*
.Exit:		jsr	A5CopyMessage2(a5)
		jmp	A5CloseWin(a5)

*-----------------------------------------------------------------------------*
* Das Default-Gui wird geladen, falls. Sollte NOGUi eingestellt sein, wird ein File- *
* requester geffnet und eventuell das Modul geladen.			      *
*-----------------------------------------------------------------------------*
LoadDefaultGui:	movem.l	d0-a6,-(a7)

		*--- DefaultGui laden falls keins vorhanden ---*
		jsr	A5GetMainWindowTags(a5)
		bne.s	.OpenWindow

		tst.b	OnNoGui(a5)
		bne.s	.NoGui

		*---- Erstmal schauen, ob Gui da ist ----*
		lea	EPG_FirstUserStruct(a5),a3
.NextEngine:	move.l	(a3),d0
		move.l	d0,a3
		beq.s	.Dochladen
		LA1	LNr_DefaultGui
		move.l	UPrgS_Node+LN_Name(a3),a0
		jsr	ENPP_StringCmp(a5)
		tst.l	d0
		bne.s	.NextEngine
		move.l	UprgS_EngineNr(a3),d2
		moveq	#1,d3
		jsr	A5Engine(a5)
		bra.s	.EngineDa

		* Input: d0=UserNr oder NULL (fr Batch bzw. Debugger)
		*	 a0=Filename oder NUll fr Enginefile(a5)
		*	 a1=UPrgS-Strukture (fr Batch bzw. Debugger)
		*	 a2=EUS-Strukture (fr Debugger)
		*	 a3=Args fr EngineConfig
		* Output:d0=Error oder NULL
		*	 d1=UserNr
.Dochladen:	moveq	#0,d0
		LA0	LNr_DefaultGui
		sub.l	a1,a1
		sub.l	a2,a2
		sub.l	a3,a3
		jsr	A5LoadEngine(a5)

.EngineDa:	tst.b	OnIconify(a5)
		bne.s	.IconifyOn
		*tst.l	WinMerk(a5)
		*beq.s	.Return
.OpenWindow:	jsr	A5OpenMainWindow(a5)
.IconifyOn:	move.l	#1,WinMerk(a5)
		bra.s	.Return

.NoGui:		moveq	#0,d2
		jsr	A5LoadModule(a5)
		jsr	A5ClearMouse(a5)

.Return:	movem.l	(a7)+,d0-a6
		rts

*-------------------------------------------------------------------------*
*------------------ Soll dieses File deprotected werden ------------------*
*-------------------------------------------------------------------------*
FrageDeprotection:movem.l d2-a6,-(a7)
		move.l	EPG_Arg1(a5),-(a7)
		move.l	EPG_Arg2(a5),-(a7)
		move.l	EPG_Arg3(a5),-(a7)
		move.l	EPG_Arg4(a5),-(a7)
		move.l	EPG_Arg5(a5),-(a7)
		move.l	EPG_Arg6(a5),-(a7)
		move.l	EPG_Arg7(a5),-(a7)
		move.l	EPG_Arg8(a5),-(a7)
		move.l	EPG_ArgN(a5),-(a7)
		La0	LNr_TR_Protection
		move.l	a0,EPG_Arg1(a5)
		lea	PubScreenName(a5),a0
		move.l	a0,EPG_Arg2(a5)
		clr.l	EPG_Arg3(a5)
		subq.l	#1,EPG_Arg3(a5)
		LA0	LNr_GA_Yes
		move.l	a0,EPG_Arg4(a5)
		clr.l	EPG_Arg5(a5)
		lea	OverwriteArgs(a5),a0
		move.l	a1,(a0)
		move.l	a0,EPG_Arg6(a5)
		moveq	#-1,d0
		move.l	d0,EPG_Arg7(a5)
		moveq	#7,d0
		move.l	d0,EPG_ArgN(a5)
		clr.l	EPG_Arg8(a5)
		jsr	A5TextRequest(a5)
		moveq	#EPR_Functionaborted,d0
		move.l	EPG_Arg1(a5),d1
		move.l	(a7)+,EPG_ArgN(a5)
		move.l	(a7)+,EPG_Arg8(a5)
		move.l	(a7)+,EPG_Arg7(a5)
		move.l	(a7)+,EPG_Arg6(a5)
		move.l	(a7)+,EPG_Arg5(a5)
		move.l	(a7)+,EPG_Arg4(a5)
		move.l	(a7)+,EPG_Arg3(a5)
		move.l	(a7)+,EPG_Arg2(a5)
		move.l	(a7)+,EPG_Arg1(a5)
		subq.l	#1,d1
		movem.l	(a7)+,d2-a6
		tst.l	d1
		rts



*------------------ Packe doch mal ein bischen Memory -----------------------*
*----- Input:								-----*
*----- Arg1	= StartAdresse des MemoryBlock				-----*
*----- Arg2	= Lnge des MemoryBlock					-----*
*----- Arg3	= PathArrayPtr fr Save					-----*
*----- Arg4	= Crunchmode						-----*
*----- Arg5	= Flags							-----*
*----- OutPut:								-----*
*----- Arg1	= StartAdresse des gecrunchten Memblockes		-----*
*----- Arg2	= Lnge des gecrunchten Memblockes			-----*
*----- Arg3	= PathArrayPtr fr Save					-----*
*----- Arg4	= Crunchmode						-----*
*----- Arg5	= Flags							-----*
*----- Arg6	= StartAdresse des MemoryBlock				-----*
*----- Arg7	= Lnge des MemoryBlock					-----*
*----- Arg8	= Lnge des allocierten Crunch-MemoryBlocks		-----*
*----------------------------------------------------------------------------*
CrunchMem:	movem.l	d1-a6,-(a7)

		clr.l	CrunchPosition(a5)

		clr.l	CR_Adr(a5)
		clr.l	CR_Size(a5)
		clr.l	CrA_Error(a5)		;Error von AbortGadget
		clr.l	EPG_Arg8(a5)

		moveq	#-1,d0
		lea	EPG_Arg4(a5),a1
		tst.b	KeyOn-EPG_Arg4(a1)
		beq.w	.None

		move.l	(a1),d0
		beq.w	.None

	*--- darf eine Ausschrift geprintet werden -----*
		btst	#0,EPG_Arg5+3(a5)
		bne.s	.NoPrint

		move.l	d0,-(a7)
		move.l	NewCrunchName(a5),d0
		move.l	d0,a0
		bne.s	.NameOk
		lea	TitlenamePuffer(a5),a0
.NameOk:	move.l	a0,ScrollArgs(a5)
		LA0	LNr_Crunching
		sub.l	a1,a1
		jsr	A5InitCrunchDisplay(a5)
		move.l	(a7)+,d0


	*------- welcher Crunchmode wird benutzt -------*
.NoPrint:	cmp.b	#EPNrC_PPCrunched,d0		;PP-Crunch
		beq.w	.PackePP
		cmp.b	#EPNrC_LHCrunched,d0		;LH-Crunch
		beq.w	.PackeLH
		cmp.b	#EPNrC_XPKCrunched,d0		;XPK-Crunch
		beq.w	.PackeXPK
	*	cmp.b	#EPNrC_FimpCrunched,d0		;FIMP-Crunch
	*	beq.w	.PackeFimp
		cmp.b	#EPNrC_CrMCrunched,d0		;CRM-Crunch
		beq.w	.PackeCrM
		bra.w	.None

*----------------------------------------------------------------------------*
*----- OutPut:								-----*
*----- Arg1	= StartAdresse des gecrunchten Memblockes		-----*
*----- Arg2	= Lnge des gecrunchten Memblockes			-----*
*----- Arg3	= PathArrayPtr fr Save					-----*
*----- Arg4	= Crunchmode						-----*
*----- Arg5	= Flags							-----*
*----- Arg6	= StartAdresse des MemoryBlock				-----*
*----- Arg7	= Lnge des MemoryBlock					-----*
*----- Arg8	= Lnge des allocierten Crunch-MemoryBlocks		-----*
	*-------------- Packe nach XPK -----------------*
.PackeXPK:	jsr	A5AddAbortGadget(a5)
		move.l	EPG_Arg2(a5),d0			;Outbutsize berechnen
		move.l	d0,d1
		divu	#32,d1
		and.l	#$ffff,d1
		add.l	d1,d0
		add.l	#512+512,d0			;2*XPK_Margin + Sicher
		move.l	d0,d6
		jsr	A5AllocMem(a5)
		move.l	d0,EPG_Arg6(a5)
		tst.l	d0
		beq.w	.MemError
		move.l	d6,EPG_Arg8(a5)			;FreeMemSize

		lea	XPK_CrunchTags(pc),a0
		move.l	EPG_Arg1(a5),12(a0)		;Data
		move.l	EPG_Arg2(a5),4(a0)		;Datasize
		move.l	EPG_Arg8(a5),20(a0)		;OutData
		move.l	EPG_Arg6(a5),28(a0)		;OutData
		lea	XPK_ErrBuf(a5),a1
		move.l	a1,36(a0)			;ErrorBuffer
		lea	EPG_Arg7(a5),a1
		move.l	a1,52(a0)			;OutPutsize
		lea	XPK_CrunchMode(a5),a1
		move.l	a1,44(a0)			;Cruncher angeben
		lea	PasswordPuffer(a5),a1
		move.l	a1,60(a0)

	*----- Datastream packen ------*
		lea	XPK_CrunchTags(pc),a0
		moveq	#EPR_XPKMasterNotFound,d0
		move.l	EPG_XPKBase(a5),d1
		beq.w	.None
		move.l	d1,a6
		jsr	_LVOXPKPack(a6)
		move.l	EPG_Arg6(a5),EPG_Arg1(a5)
		move.l	d0,d1
		moveq	#EPR_XPKError,d0
		tst.l	d1
		beq.w	.PackOk
		move.l	#1,CrA_Error(a5)			;1=Abort
		bra.w	.MemError2

*----------------------------------------------------------------------------*
*----- OutPut:								-----*
*----- Arg1	= StartAdresse des gecrunchten Memblockes		-----*
*----- Arg2	= Lnge des gecrunchten Memblockes			-----*
*----- Arg3	= PathArrayPtr fr Save					-----*
*----- Arg4	= Crunchmode						-----*
*----- Arg5	= Flags							-----*
*----- Arg6	= StartAdresse des MemoryBlock				-----*
*----- Arg7	= Lnge des MemoryBlock					-----*
*----- Arg8	= Lnge des allocierten Crunch-MemoryBlocks		-----*
	*-------------- Packe nach PP -----------------*
.PackePP:	moveq	#EPR_PPNotFound,d0
		tst.l	EPG_PPbase(a5)
		beq.w	.None
		move.l	EPG_Arg2(a5),d0

	*-------- Speicher fr Crunchpuffer allocieren -------*
		add.l	#100,d0				;Sicherheit !?!?!
		move.l	d0,d6
		jsr	A5AllocMem(a5)
		move.l	d0,EPG_Arg6(a5)
		beq	.MemError
		move.l	d6,EPG_Arg8(a5)			;AllocSize

	*----------- CrunchInfo holen ------------*
		moveq	#4,d0				;Effizience
		moveq	#0,d1				;Large
		lea	PP_CrunchAnzeige(pc),a0		;CallBack-Function
		move.l	a5,a1
		move.l	EPG_PPBase(a5),a6
		jsr	_LVOPPAllocCrunchInfo(a6)
		move.l	d0,a4
		beq.w	.MemError2

		move.l	4,a6
		move.l	EPG_Arg1(a5),a0
		move.l	EPG_Arg6(a5),a1
		tst.b	OnProtect(a5)
		beq.s	.PPNoProtect5
		addq.l	#2,a1
.PPNoProtect5:	addq.l	#8,a1
		move.l	a1,-(a7)
		move.l	EPG_Arg2(a5),d0
	;	jsr	_LVOCopyMem(a6)
		jsr	A5CopyMemQuick(a5)

	*------------- Speicher copieren --------*
		bsr.w	Module_Crypt2
		jsr	A5AddAbortGadget(a5)

	*-------------- Datas crunchen ----------*
		move.l	a4,a0				;CrunchStruct
		move.l	(a7)+,a1
		move.l	EPG_Arg2(a5),d0
		move.l	EPG_PPBase(a5),a6
		jsr	_LVOPPCrunchBuffer(a6)
		move.l	d0,-(a7)

	*---------- Namen zusammensetzen ---------*
		move.l	#"PP20",d2
		tst.b	OnProtect(a5)
		beq.s	.PPNoProtect
		or.l	#"PX20",d2
.PPNoProtect:	tst.b	OnSampleMode(a5)
		beq.s	.PPNoSampleMode
		move.b	#"S",d2
.PPNoSampleMode:move.l	EPG_Arg6(a5),a3
		move.l	d2,(a3)+
		tst.b	OnProtect(a5)
		beq.s	.PPNoProtect2
		addq.l	#2,a3

	*----------- Efficience setzen -----------*
.PPNoProtect2:	move.l	a4,a0
		moveq	#0,d2
		move.b	1(a0),d2
		lsl.l	#8,d2
		move.b	3(a0),d2
		lsl.l	#8,d2
		move.b	5(a0),d2
		lsl.l	#8,d2
		move.b	7(a0),d2
		move.l	d2,(a3)				;Efficience setzen

	*----- Crunch-Info wieder freigeben ------*
		move.l	a4,a0
		move.l	EPG_PPBase(a5),a6
		jsr	_LVOPPFreeCrunchInfo(a6)
		move.l	(a7)+,d0
		tst.l	d0
		beq.w	.MemError2
		cmp.l	#-1,d0
		beq.w	.MemError2
		move.l	d0,d6

	*------ Module crypten und Chk setzen ----*
		tst.b	OnProtect(a5)
		beq.s	.PPSetDecrunch
		jsr	A5RemoveAbortGadget(a5)
		jsr	A5GetPassword(a5)
	*------------- File protecten -----------*
		move.l	EPG_PPBase(a5),a6
		lea	PasswordPuffer(a5),a0
		jsr	_LVOPPCalcPasskey(a6)
	*------------ File encrypten ------------*
		move.l	d0,d1
		move.l	EPG_Arg6(a5),a0
		lea	10(a0),a0
		move.l	d6,d0
		subq.l	#1,d0
		and.l	#$fffffc,d0
		jsr	_LVOPPDecrypt(a6)
	*----------- Checksumme setzen ----------*
		lea	PasswordPuffer(a5),a0
		jsr	_LVOPPCalcCheckSum(a6)
		move.l	EPG_Arg6(a5),a0
		move.w	d0,4(a0)			;Chksumme setzen


	*---------- Decrunchsize setzen ---------*
.PPSetDecrunch:	move.l	d6,d0
		move.l	EPG_Arg6(a5),a0
		tst.b	OnProtect(a5)
		beq.s	.PPNoProtect3
		addq.l	#2,d0
.PPNoProtect3:	addq.l	#8,d0
		add.l	d0,a0
;		move.b	EPG_Arg2+1(a5),-4(a0)
;		move.b	EPG_Arg2+2(a5),-3(a0)
;		move.b	EPG_Arg2+3(a5),-2(a0)
;		move.b	#2,-1(a0)
		move.l	d0,EPG_Arg7(a5)			;CrunchSize setzen
		bra.w	.PackOk




*----------------------------------------------------------------------------*
*----- OutPut:								-----*
*----- Arg1	= StartAdresse des gecrunchten Memblockes		-----*
*----- Arg2	= Lnge des gecrunchten Memblockes			-----*
*----- Arg3	= PathArrayPtr fr Save					-----*
*----- Arg4	= Crunchmode						-----*
*----- Arg5	= Flags							-----*
*----- Arg6	= StartAdresse des MemoryBlock				-----*
*----- Arg7	= Lnge des MemoryBlock					-----*
*----- Arg8	= Lnge des allocierten Crunch-MemoryBlocks		-----*
	*-------------- Packe nach LH -----------------*
.PackeLH:	move.l	EPG_Arg2(a5),d0
		move.l	d0,d1
		lsr.l	#2,d1
		add.l	d1,d0
		move.l	d0,d6

	*-------- Speicher fr Crunchpuffer allocieren -------*
		jsr	A5AllocMem(a5)
		move.l	d0,EPG_Arg6(a5)
		beq	.MemError
		move.l	d6,EPG_Arg8(a5)			;AllocSize

	*-------- Speicher fr Crunchstruktur allocieren -------*
		moveq	#0,d0
		move.l	EPG_LHBase(a5),a6
		jsr	-$1E(a6)
		move.l	d0,a0
		tst.l	d0
		beq	.MemError2

		bsr.w	Module_Crypt

	*------------------ Module packen ----------------*
		move.l	EPG_Arg1(a5),(a0)
		move.l	EPG_Arg2(a5),4(a0)
		moveq	#12,d0
		add.l	EPG_Arg6(a5),d0
		move.l	d0,8(a0)
		move.l	a0,a4
		move.l	EPG_Arg8(a5),12(a0)
		move.l	EPG_LHBase(a5),a6
		jsr	-$2a(a6)			;Crunchen !!!!!!!

	*------------ Crunchstruktur freigeben -----------*
		move.l	d0,-(a7)		;D0=CrunchSize
		move.l	a4,a0
		move.l	EPG_LHBase(a5),a6
		jsr	-$24(a6)

		bsr.w	Module_Decrypt

		move.l	(a7)+,d0
		tst.l	d0
		beq.w	.MemError2

		move.l	EPG_Arg6(a5),a4
		move.l	#"SFCD",d1
		tst.b	OnSampleMode(a5)
		bne.s	.LHSampleMode

		move.l	#"SFHD",d1
.LHSampleMode:	move.l	d1,(a4)
		move.l	EPG_Arg2(a5),4(a4)		;Decrunchsize
		move.l	d0,8(a4)			;Crunchsize
		move.l	d0,EPG_Arg7(a5)			;CrunchSize
		add.l	#12,EPG_Arg7(a5)
		bra.w	.PackOk

*----------------------------------------------------------------------------*
*----- OutPut:								-----*
*----- Arg1	= StartAdresse des gecrunchten Memblockes		-----*
*----- Arg2	= Lnge des gecrunchten Memblockes			-----*
*----- Arg3	= PathArrayPtr fr Save					-----*
*----- Arg4	= Crunchmode						-----*
*----- Arg5	= Flags							-----*
*----- Arg6	= StartAdresse des MemoryBlock				-----*
*----- Arg7	= Lnge des MemoryBlock					-----*
*----- Arg8	= Lnge des allocierten Crunch-MemoryBlocks		-----*

	*-------- Speicher fr Crunchpuffer allocieren -------*
.PackeCRM:	tst.l	EPG_CrmBase(a5)
		beq.w	.NoMemError

		move.l	EPG_Arg2(a5),d0			;max. Crunchsize
		clr.l	EPG_Arg7(a5)
		jsr	A5AllocMem(a5)
		move.l	d0,EPG_Arg6(a5)
		beq	.MemError
		move.l	EPG_Arg2(a5),EPG_Arg8(a5)

		move.l	EPG_Arg2(a5),d0			;max. Crunchsize
		jsr	A5AllocMem(a5)
		move.l	d0,CR_Adr(a5)
		beq	.MemError2
		move.l	EPG_Arg2(a5),CR_Size(a5)


	*------ Nun CRMCrunchInfo allocieren ------*
		moveq	#2,d0				;CrunchMode (LZH)
		tst.b	OnSampleMode(a5)
		beq.s	.CRMNoSampleMode
		bset	#4,d0				;SampleMode setzen
.CRMNoSampleMode:tst.b	OnProtect(a5)
		beq.s	.CRMNoProtect
		bset	#5,d0

		move.l	d0,-(a7)
		sub.l	a0,a0
		moveq	#3,d0			;cm_RemoveAll
		move.l	EPG_CrmBase(a5),a6
		jsr	_LVOCMProcessPW(a6)
		lea	PasswordPuffer(a5),a0
		moveq	#1,d0				;cm_AddPW
		jsr	_LVOCMProcessPW(a6)
		move.l	(a7)+,d0

.CRMNoProtect:	lea	CrM_CrunchTags(pc),a0
		move.l	d0,4(a0)			;Crunch-Flags setzen
		move.l	EPG_CrmBase(a5),a6
		jsr	_LVOCMAllocCrunchStructA(a6)
		move.l	d0,a4
		beq.w	.MemError3


	;	move.l	4,a6
		move.l	EPG_Arg1(a5),a0
		move.l	CR_Adr(a5),a1
		move.l	EPG_Arg2(a5),d0
	;	jsr	_LVOCopyMem(a6)
		jsr	A5CopyMemQuick(a5)


	*--------- CRM-Struktur fllen -----------*

;	APTR	cmcr_Src		;Source Start
;	ULONG	cmcr_SrcLen		;Source Len
;	APTR	cmcr_Dest		;Destination Start
;	ULONG	cmcr_DestLen		;Destination Len (maximum)
;	APTR	cmcr_DataHdr		;DataHeader
;	APTR	cmcr_DisplayHook	;Hook to display ToGo/Gain Counters
		jsr	A5AddAbortGadget(a5)

		moveq	#14,d4
		move.l	a4,a0
		move.l	CR_Adr(a5),(a0)
		move.l	EPG_Arg2(a5),4(a0)
		move.l	EPG_Arg6(a5),8(a0)
		add.l	d4,8(a0)
		move.l	EPG_Arg8(A5),12(a0)
	;	sub.l	d4,12(a0)
		move.l	EPG_Arg6(a5),16(a0)
		lea	CRM_AnzeigeHook(pc),a1
	;	move.l	a5,16(a1)
		move.l	a1,20(a0)

	*--------- Nun den Puffer packen ---------*
		move.l	EPG_CrmBase(a5),a6
		jsr	_LVOCMCrunchData(A6)
		move.l	d0,-(a7)

	;	lea	12(a4),a1
	;	bsr.w	CRM_CrunchAnzeige
	;	moveq	#8,d1
	;	jsr	A5Delay3(a5)
		move.l	44(a4),d3
		bsr.w	.FreeCrunchHelp

	*-------- Crunch-Struktur freigeben -------*
		move.l	a4,a0
		move.l	EPG_CrmBase(a5),a6
		jsr	_LVOCmFreeCrunchStruct(a6)
		move.l	(a7)+,d0
		tst.l	d0
		beq.s	.MemError2

		add.l	d4,d3
		move.l	d3,EPG_Arg7(a5)

	*-------- Nun eventuell protecten --------*
;		tst.b	OnProtect(a5)
;		beq.s	.PackOk
;		move.l	EPG_Arg6(a5),a0
;		move.l	EPG_Arg6(a5),a1
;		lea	14(a1),a1
;		lea	PasswordPuffer(a5),a2
;		moveq	#4,d0				;cm_EnCrypt=4
;		jsr	_LVOCMCryptData(a6)
		bra.s	.PackOk



	*------------ Es ist ein 3. MemError aufgetreten -----------*
.MemError3:	bsr.w	.FreeCrunchHelp

	*------------ Es ist ein 2. MemError aufgetreten -----------*
.MemError2:	move.l	EPG_Arg6(a5),d0
		beq.s	.NoMemError
		move.l	d0,a1
		move.l	EPG_Arg8(a5),d0
		beq.s	.NoMemError
		ExecBase
		jsr	_LVOFreeMem(a6)
.NoMemError:	clr.l	EPG_Arg8(a5)
		clr.l	EPG_Arg6(a5)
.MemError:	moveq	#EPR_NotEnoughMem,d0
		tst.l	CrA_Error(a5)			;1=Abort
		beq.s	.None
		moveq	#EPR_CrunchAborted,d0
		bra.s	.None

.PackOk:	move.l	EPG_Arg6(a5),EPG_Arg1(a5)
		move.l	EPG_Arg7(a5),EPG_Arg2(a5)
		moveq	#0,d0
.None:		jsr	A5RemoveAbortGadget(a5)
		jsr	A5RemoveCrunchDisplay(a5)
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


.FreeCrunchHelp:move.l	CR_Adr(a5),d0
		beq.s	.HelpNoMemError
		move.l	d0,a1
		move.l	CR_Size(a5),d0
		beq.s	.HelpNoMemError
		ExecBase
		jsr	_LVOFreeMem(a6)
.HelpNoMemError:clr.l	CR_Adr(a5)
		clr.l	CR_Size(a5)
		rts

*----------------- Gib doch mal ein bischen Memory frei ---------------------*
*----- Input:								-----*
*----- Arg1	= StartAdresse des gecrunchten Memblockes		-----*
*----- Arg2	= Lmge des gecrunchten Memblockes			-----*
*----- Arg3	= PathArrayPtr fr Save					-----*
*----- Arg4	= CrunchMode	0=egal -1=not crunched			-----*
*----- Arg5	= StartAdresse des MemoryBlock				-----*
*----- Arg6	= Lnge des MemoryBlock					-----*
*----- Arg7	= Lnge des allocierten Crunch-MemoryBlocks		-----*
*----- OutPut:								-----*
*----- Arg1	= StartAdresse des MemoryBlock				-----*
*----- Arg2	= Lnge des MemoryBlock					-----*
*----------------------------------------------------------------------------*
FreeCrunchMem:	movem.l	d0-a6,-(a7)
		move.l	EPG_Arg1(a5),d0
		beq.s	.None
		move.l	d0,a1
		move.l	EPG_Arg8(a5),d0
		beq.s	.None
		ExecBase
		jsr	_LVOFreeMem(a6)
		move.l	EPG_Arg6(a5),EPG_Arg1(a5)
		move.l	EPG_Arg7(a5),EPG_Arg2(a5)
		clr.l	EPG_Arg6(a5)
		clr.l	EPG_Arg7(a5)
		clr.l	EPG_Arg8(a5)
.None		movem.l	(a7)+,d0-a6
		rts

*--------------------------------------------------------------------------*
XPK_CrunchTags:	dc.l	$80005870 ;XPK_InLen	;len of data in input buffer */
.4		dc.l	0
		dc.l	$80005853 ;XPK_InBuf	; Unblocked buffer - must also supply InLen */
.12		dc.l	0
		dc.l	$80005871 ;XPK_OutBufLen	; len of output buffer */
.20		dc.l	0
		dc.l	$80005862 ;XPK_OutBuf	; Unblocked buffer - must also supply OutBufLen */
.28		dc.l	0
		dc.l	$80005875 ;XPK_GetError	; ti_Data points to buffer for error message */
.36		dc.l	0
		dc.l	$8000587a ;XPK_PackMethod	; Do a FindMethod before packing */
.44		dc.l	0
		dc.l	$80005872 ;XPK_GetOutLen
.52		dc.l	0
		dc.l	$80005874 ;XPK_Password
.60		dc.l	0
		dc.l	$80005879 ;XPK_ChunkHook
		dc.l	XPK_AnzeigeHook

		dc.l	0

XPK_AnzeigeHook:dc.l	0,0
		dc.l	XPK_CrunchAnzeige,0
		dc.l	0

CRM_CrunchTags:	dc.l	$80000001			;CMCS_Algo
		dc.l	2!16				;Flags
		dc.l	0

CRM_AnzeigeHook:dc.l	0,0
		dc.l	CRM_CrunchAnzeige,0
		dc.l	0



*------------------------ Crunchanzeige im Statuswindow ---------------------*
PP_CrunchAnzeige:movem.l d1-a6,-(a7)
		moveq	#0,d7				;Error
		movem.l	60(a7),d0-d3
		move.l	d0,d2				;Position
		bra.s	CR_CrunchAnzeige

*------------------------ Crunchanzeige im Statuswindow ---------------------*
XPK_CrunchAnzeige:movem.l d1-a6,-(a7)
		moveq	#-1,d7
		move.l	24(a1),d2
		bra.s	CR_CrunchAnzeige

*------------------------ Crunchanzeige im Statuswindow ---------------------*
CRM_CrunchAnzeige:movem.l d1-a6,-(a7)
		moveq	#0,d7				;Error
		move.l	PufferAdr3(pc),a5
		move.l	EPG_Arg2(a5),d2
		sub.l	(a1),d2				;Position

	*----------------- d0=Bisher gepackte Size ------------------*
CR_CrunchAnzeige:
		move.l	PufferAdr3(pc),a5


		move.l	EPG_Arg2(a5),d0
		divu	#1000,d0
		bne.s	.NoZero
		moveq	#1,d0
.NoZero:	divu	d0,d2
		ext.l	d2
		move.l	d2,d0



		*mulu	#1000,d2
		*move.l	EPG_Arg2(a5),d0
		*divu	d0,d2
		*ext.l	d2
		*move.l	d2,d0

		*lea	TitlenamePuffer(a5),a0
		*move.l	a0,ScrollArgs(a5)
		*LA0	LNr_Crunching
		sub.l	a0,a0
		sub.l	a1,a1
		jsr	A5FillCrunchDisplay(a5)

		move.l	d0,CrA_Error(a5)		;Error von AbortGadget
		bne.s	.Error				;1=Msg


		not.l	d7
.Error:		move.l	d7,d0				;Error ? (0=Ja)
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*
*		move.l	RastPort(a5),d1
*		beq.s	.NoRectFill
*		move.l	d1,a1
*
*		tst.b	OnIconify(a5)
*		bne.s	.NoRectFill
*
*
*		move.l	EPG_Arg2(a5),d0
*
*		move.l	DTG_GFXBase(a5),a6
*		movem.l	d0-a6,-(a7)
*		move.l	Rastport(a5),a1
*		moveq	#3,d0
*		jsr	_LVOSetAPen(a6)
*		movem.l	(a7)+,d0-a6
*
*
*	;--> d0=Bis hier gecrunchte Bytes
*	;--> d1=Davon gepackt
*	;--> d2=Gre des zu packenden Speichers
*	;--> d3=My Puffer
*
*
*	*-------------- Balken zeichnen -----------*
*	*  Linke Pos ausrechnen nach Gl:     Bis hier gecruncht * max. Anzeige
*	*				    -----------------------------------
*	*						Gesammtsize
*	*
*		cmp.l	#$ffff,d0
*		blo.s	.NoLSR
*		lsr.l	#4,d0
*		lsr.l	#4,d2
*.NoLSR:		mulu	#BorderBreite-AbortWidth-4-Borderlinks,d2
*		divu	d0,d2
*
*		and.l	#$ffff,d2
*
*		move.l	CB_Left(a5),d0			;Left Position
*		add.w	#Borderlinks+1-4,d2
*		add.w	WinBBreite(a5),d2
*		move.l	d2,CB_Left(a5)
*		cmp.l	d0,d2
*		beq.s	.NoRectFill
*
*		moveq	#BorderOben+1-11,d1		;Pos von Oben
*		add.w	WinHoehe(a5),d1
*		moveq	#BorderOben+9-11,d3		;Pos nach Unten
*		add.w	WinHoehe(a5),d3
*
*		move.l	DTG_GfxBase(a5),a6
*		jsr	_LVORectFill(a6)
*
*
*		btst	#0,EPG_Arg5+3(a5)
*		bne.s	.NoRectFill
*
*		lea	TitlenamePuffer(a5),a0
*		move.l	a0,ScrollArgs(a5)
*		LA0	LNr_Crunching
*		jsr	A5PrintText(a5)
*
.NoRectFill:	jsr	A5GetAbortMsg(a5)
*		move.l	d0,CrA_Error(a5)		;Error von AbortGadget
*		bne.s	.Error				;1=Msg
*
*
*		not.l	d7
*.Error:		move.l	d7,d0				;Error ? (0=Ja)
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts



*-----------------------------------------------------------------------------*
* Wird EPR_NotImplemented zurckgegeben, kann dieses Gui keine Crunch-*
* anzeigen machen.
* Input: a0=ScrollText
*	 a1=ScrollTextArgs bei Null sind Args = ScrollArgs
* Output:d0=Error oder NULL
*-----------------------------------------------------------------------------*
InitCrunchDisplay:
		movem.l	d1-a6,-(a7)
		move.l	PufferAdr3(pc),a5
		moveq	#0,d0
		tst.b	OnCrunchDisplay(a5)
		bne.s	.Return
		move.l	a1,d0
		bne.s	.ArgsDa
		lea	ScrollArgs(a5),a1
.ArgsDa:	jsr	A5MakeCorrectText(a5)



	*----------- ArgListe allocieren -------------*
		lea	ScrollPuffer(a5),a0
		move.l	#EUT_PrintText,d7
		bsr	AllocScrollStruct
		move.l	d0,a0
		beq.s	.KeinText

		move.l	d4,a0

		*-- Gui anrufen --*
.KeinText:	move.l	#EUT_InitDisplay,d7
		jsr	A5UserCallUp4(a5)
		beq.s	.Error
		tst.l	d0
		bne.s	.Return
		move.b	#1,OnCrunchDisplay(a5)
		clr.b	FunctionAbortedNow(a5)
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts
.Error:		moveq	#EPR_NotImplemented,d0
		bra.s	.Return

*-----------------------------------------------------------------------------*
* Wird ein Fehler zurckgegeben bedeutet das ein unbedingtes Abbrechen !
* Input: a0=ScrollText
*	 d0=Stand in Promille 50%=500
* Output:d0=Error oder NULL
*-----------------------------------------------------------------------------*
FillCrunchDisplay:
		movem.l	d1-a6,-(a7)
		move.l	PufferAdr3(pc),a5
		tst.b	OnCrunchDisplay(a5)
		beq.s	.Error

		*-- Gui anrufen --*
		move.l	#EUT_FillDisplay,d7
		jsr	A5UserCallUp4(a5)
		beq.s	.KeinTag			*-> Kein tag
		tst.l	d0
		bne.s	.Return				*-> Error


.KeinTag:	move.l	#EUT_GetAbortMSG,d7
		jsr	A5UserCallUp4(a5)
		beq.w	.Return
		tst.l	d1
		beq.s	.Return
		move.l	#EPR_FunctionAborted,d0

.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

.Error:		moveq	#0,d0				*-> Keine Abbruchbed.
		bra.s	.Return


*-----------------------------------------------------------------------------*
* Input: --
* Output:--
*-----------------------------------------------------------------------------*
RemoveCrunchDisplay:
		movem.l	d0-a6,-(a7)
		move.l	PufferAdr3(pc),a5
		moveq	#0,d0
		tst.b	OnCrunchDisplay(a5)
		beq.s	.Return

		*-- Gui anrufen --*
		move.l	#EUT_RemoveDisplay,d7
		jsr	A5UserCallUp4(a5)

.Return:	clr.b	OnCrunchDisplay(a5)
		movem.l	(a7)+,d0-a6
		rts



*----------------------------------------------------------------------------*
*----------------------------- Crypt SFCD-Formate ---------------------------*
*----------------------------------------------------------------------------*
Module_Crypt2:	movem.l	d0-a6,-(a7)
		tst.b	OnSampleMode(a5)
		beq.s	Module_NoCrypt
		move.l	EPG_Arg6(a5),a0
		tst.b	OnProtect(a5)
		beq.s	.NoProtect
		addq.l	#2,a0
.NoProtect:	addq.l	#8,a0
		bra.s	Module_Crypt3

Module_Crypt:	movem.l	d0-a6,-(a7)
		tst.b	OnSampleMode(a5)
		beq.s	Module_NoCrypt
		move.b	PlayOn(a5),CryptOn(a5)
		jsr	A5StopInterrupt(a5)

.NoStop:	move.l	EPG_Arg1(a5),a0

Module_Crypt3:	move.l	EPG_Arg2(a5),d0
		subq.l	#1,d0
		move.b	(a0)+,d1
.Crypt:		move.b	(a0),d2
		move.b	d2,d3
		sub.b	d1,d2
		move.b	d2,(a0)+
		move.b	d3,d1
		subq.l	#1,d0
		bne.s	.Crypt
Module_NoCrypt:	movem.l	(a7)+,d0-a6
		rts


*---------------------------- Decrypt SFCD-Formate ---------------------------*
*-----	a0 = Startadresse						-----*
*-----	d0 = Lnge des Files						-----*
*----------------------------------------------------------------------------*
Module_Decrypt:	movem.l	d0-a6,-(sp)
		tst.b	OnSampleMode(a5)
		beq.s	.NoStartSound

		move.l	EPG_Arg1(a5),a0
		move.l	EPG_Arg2(a5),d0

		subq.l	#1,d0
		move.l	a0,a1
		move.l	d0,d3
		move.b	(a0)+,d1
.Crypt:		move.b	(a0),d2
		add.b	d1,d2
		move.b	d2,(a0)+
		move.b	d2,d1
		subq.l	#1,d0
		bne.s	.Crypt
		move.l	a1,a0
		move.l	d3,d0

		tst.b	CryptOn(a5)
		beq.s	.NoStartSound
		jsr	A5StartInterrupt(a5)
		clr.b	CryptOn(a5)
.NoStartSound:	movem.l	(sp)+,d0-a6
		rts


*-- Screen nach vorne schalten, auf dem das Mainwindow des Eagleplayers ist --*
ScreenToFront:	movem.l	d0-a6,-(a7)
		jsr	A5GetMainWindowHandle(a5)
		beq.s	.NoScreen
		move.l	d0,a0
		move.l	46(a0),a0
		move.l	DTG_IntuitionBase(a5),a6
		jsr	_LVOScreenToFront(a6)
.NoScreen:	movem.l	(a7)+,d0-a6
		rts




*------------------- Player in Liste suchen und finden ----------------------*
*-----	a0=Name des Files						-----*
*----------------------------------------------------------------------------*
LoadNeededPlayer:movem.l d0-a6,-(a7)
		tst.b	OnPlayerBatch(a5)
		beq.w	.Ende

		lea	EPP_PlAdr(a5),a1
		move.l	(a1),d0
		beq.w	.Ende
	;	tst.b	KeyOn-EPP_PlAdr(a1)
	;	beq.w	.Ende
		move.l	d0,a1

	*------------- Teste die Bytes durch --------------*
.NextZeileTest:	move.l	a1,a4
.NextTestInBat:	move.b	(a1)+,d0
		beq.w	.Ende
		cmp.b	#"/",d0				;Commentar
		beq.w	.C_Commantar
		cmp.b	#";",d0				;Commentar
		beq.w	.NextZeile
		cmp.b	#" ",d0				;Leerzeichen
		beq.s	.NextTestInBat
		cmp.b	#9,d0				;Tab-Zeichen
		beq.s	.NextTestInBat
		cmp.b	#10,d0				;nchste Zeile
		beq.s	.NextZeileTest
		cmp.b	#"|",d0				;nchste Zeile
		beq.s	.NextTestInBat
		cmp.b	#"=",d0				;nchste Zeile
		beq.w	.NextZeile
	;	cmp.b	#'"',d0				;nchste Zeile
	;	beq.w	.NextZeile
		cmp.b	#"*",d0
		beq.w	.SternchenAnfang

	*---------------- Sternchen Ende -----------------*		
	*------ Jetzt sind beide Strings am Anfang -------*
		move.l	a0,a2
		subq.l	#1,a1
.VergleichVorwarts:move.b (a1)+,d0
		beq.w	.Ende
		cmp.b	#9,d0
		beq.s	.BisSternchenEnde
		cmp.b	#10,d0
		beq.s	.BisSternchenEnde
		bsr.w	CMP_A2_d0
		addq.l	#1,a2
		beq.s	.VergleichVorwarts
		cmp.b	#"*",d0
		beq.s	.KurzelFound

	*----------- Sternchen noch suchen --------------*
.BisSternchenEnde:move.b (a1)+,d0
		beq.w	.Ende
		cmp.b	#"*",d0
		bne.s	.BisSternchenEnde
		bra.s	.NextTestInBat



	*--- Ende des Strings finden, der in der Batch-Datei steht ----*
	*--- String finden: Bsr: *.sdata			   ----*
.SternchenAnfang:move.b	(a1),d0
		beq.w	.Ende
		cmp.b	#"=",d0
		beq.s	.SternEnd_1
		cmp.b	#"|",d0
		beq.s	.SternEnd_1
		cmp.b	#9,d0
		beq.s	.SternEnd_1
		cmp.b	#" ",d0
		beq.s	.SternEnd_1
		addq.l	#1,a1
		bra.s	.SternchenAnfang

	*------- Jetzt Ende des Namens finden BSP: hallo.sdata ----------*
.SternEnd_1:	move.l	a0,a2
.SternEnd_2:	move.b	(a2),d0
		beq.s	.VergleichRuckwarts
		addq.l	#1,a2
		bra.s	.SternEnd_2


	*------------- Jetzt sind beide Strings am Ende ------------*
.VergleichRuckwarts:move.b -(a1),d0
		cmp.b	#"*",d0
		beq.s	.KurzelFound
		subq.l	#1,a2
		bsr.w	CMP_A2_d0
		beq.s	.VergleichRuckwarts
	;	addq.l	#1,a1			;Wieso ???
	;	bra.w	.NextTestInBat

		*-- Ende dieses Eintrages in Batch finden --*
.Vglr_2:	move.b	(a1)+,d0
		beq.w	.Ende
		cmp.b	#10,d0
		beq.w	.NextZeileTest
		cmp.b	#"|",d0
		bne.s	.Vglr_2
		bra.w	.NextTestInBat

	*----------- Jetzt noch Namen fr Replayer finden ----------*
.KurzelFound:	move.b	(a1)+,d0
		beq.w	.Ende
		*cmp.b	#10,d0
		*beq.s	.NextTestInBat
		cmp.b	#"=",d0
		bne.s	.KurzelFound
		move.l	a1,a2				:Merken Pfadbeginn

	*----------- Erstes Gansefchen finden --------*
.FindGanse:	move.b	(a1)+,d0
		beq.w	.Ende
		cmp.b	#'"',d0
		bne.w	.NextTestInBat


	*----------- Erstes Gansefchen finden --------*
		move.l	a1,a3				;Anfang des Namens
.FindGanse2:	move.b	(a1)+,d0
		beq.w	.Ende
		cmp.b	#'"',d0
		bne.s	.FindGanse2
		

	*------- Player laden und nchsten suchen ------*
		clr.b	-1(a1)				;Ende des Namens setzen
		movem.l	d0/d2-a6,-(a7)
		move.l	a2,a0

	;*************************************************************
	;**** Copiert den Dir-Anteil des Phades nach Puffer in a0 ****
	;**** Input =	a0 Puffer frs Dir			  ****
	;****		a1 Puffer wo Path steht			  ****
	;****		d3 Lnge des Phades			  ****
	;**** Output	a0 Startadr des Filenames		  ****
	;*************************************************************
		move.l	a1,d3				;pathlnge rauskriegen
		sub.l	a0,d3
		subq.l	#1,d3
		move.l	a3,a1
		lea	PlayersDir(a5),a0
		jsr	A5CreateDirAusPath(a5)


		lea	PlayersFile(a5),a1
		moveq	#Namenlange-2,d1
		jsr	A5StringCopy2(a5)


*--------------------------------------------------------------------------*



		move.l	PlayerAdr(a5),d1	;aktuelle TagListe
		beq.s	.YesLoadPlayer		;kein Player --> dann laden ?!
		cmp.l	LoadNameAdr(a5),a4	;Player bereits vorhanden
		beq.s	.PlayerDa



.YesLoadPlayer:	move.l	a3,d1				;Name des Players
		move.b	#1,BatchLoading(a5)
		jsr	A5LoadOnePlayer(a5)
		move.l	LastLoadedTagList(a5),d1	;Tagliste nach d1
.PlayerDa:	movem.l	(a7)+,d0/d2-a6
		clr.b	BatchLoading(a5)

	*------------- PlayerDaten setzen ------------*
		tst.l	d1
		beq.s	.NoMerkThis
		move.l	a0,-(a7)
		lea	PlayerNameAdrs(a5),a0
		move.l	PlayerNameAnz(a5),d0
		cmp.w	#PlBatchSize,d0
		bhs.s	.NoAddNameAdr
		addq.l	#1,PlayerNameAnz(a5)
.NoAddNameAdr:	lsl.l	#3,d0
		move.l	a4,(a0,d0.w)		;Namenadresse merken
		move.l	d1,4(a0,d0.w)		;Tagliste merken
		move.l	(a7)+,a0


.NoMerkThis:	move.b	#'"',-1(a1)

	*--- Namen lschen um Reloading zu vermeiden ---*
		tst.b	OnEjectPlayer(a5)
		bne.s	.NextZeile
		move.l	a1,d0
		sub.l	a4,d0
		subq.l	#1,d0
.ClearName:	move.b	#" ",(a4)+
		dbf	d0,.ClearName

	*------------- nchste Zeile finden -------------*
.NextZeile:	move.b	(a1)+,d0
		beq.s	.Ende
		cmp.b	#10,d0
		bne.s	.NextZeile
		bra.w	.NextZeileTest

	*----------- Ende des C-Kommentars finden --------*
.C_Commantar:	cmp.b	#"*",(a1)			;kein C-Kommentar
		bne.w	.NextTestInBat
		addq.l	#1,a1
.FindCEnde:	move.b	(a1)+,d0
		beq.s	.Ende
		cmp.b	#"*",d0
		bne.s	.FindCEnde
		cmp.b	#"/",(a1)
		bne.s	.FindCEnde
		addq.l	#1,a1
		bra.w	.NextTestInBat

.Ende:		movem.l	(a7)+,d0-a6
		rts


*----------------------------------------------------------------------------*
* Vergleicht den Inhalt von a2 mit d0 unter Bercksichtigung des Ascii-Codes *
*--------------- d0 = Returnwert fr Ascii behandelten Code -----------------*
*--------------- d1 = Returnwert fr Ascii behandelten Code -----------------*
*----------------------------------------------------------------------------*
CMP_A2_D0:	moveq	#0,d1
		move.b	(a2),d1
		cmp.b	#"a",d1
		blo.s	.NoD1
		cmp.b	#"z",d1
		bhi.s	.NoD1
		bclr	#5,d1
.NoD1:		cmp.b	#"a",d0
		blo.s	.NoD0
		cmp.b	#"z",d0
		bhi.s	.NoD0
		bclr	#5,d0
.NoD0:		cmp.b	d0,d1
		rts



*--------------------- nur per jsr xx(a5) erreichbar -------------------*
* KeyReturn = Adr fr Return:						*
* KeyDiffi1 = $568496							*
* KeyDiffi2 = $27656							*
* KeyDiffi3 = $8899646							*
* EmptyPuffer = dc.l 0							*
* ArexxTabelle --> a3							*
*-----------------------------------------------------------------------*
KEY_RoutinenTester:lea	A5UnterPrgTab,a3
		moveq	#0,d4
		move.l	EPG_Arg1(a5),d0
		beq.s	.NoTest
		move.l	EPG_Arg2(a5),d4
.NoTest		move.l	EPG_Arg3(a5),d2
		move.l	EmptyPuffer(a5),d1
		lea	(a3,d1.w),a3
		move.l	KEYReturn(a5),a2
		lea	KeyTestTab-A5UnterPrgTab(a3),a3

	*------ TestOffset rauslesen ------*
		moveq	#0,d1
		sub.l	a0,a0
		move.l	a3,a4
		moveq	#3,d4
		sub.l	a6,a6
KeyTestNext:	move.l	(a3)+,d5		;Offset zu nchsten Test
		move.l	(a3)+,d3		;Offset zu TestString
		move.l	(a3)+,d6		;Offset zu Guru
		add.l	d3,d4
		sub.l	KeyDiffi2(a5),d3	;-KeyDiffi
		neg.l	d3
		tst.l	d3
		bne.s	.NoEnde
		jsr	A5KeyTestReturn(a5)
.NoEnde:	sub.l	KeyDiffi3(a5),d6
		add.l	d6,d4
		sub.l	KeyDiffi1(a5),d5
		mulu	EmptyPuffer(a5),d2
		lea	(a2,d3.l),a0		;TestAdr
		jsr	A5Return(a5)
		ror.l	#4,d3
		add.l	a2,d6
		ror.l	#1,d5
		move.l	d2,EgalMerkZelle(a5)
.ChkKey:	move.w	(a3)+,d4
		add.w	d4,d2
		move.w	KeyDiffi4(a5),d0
		sub.w	d4,d0
		sub.w	(a0)+,d0		;cmp.w	(a3)+,(a0)+ vortuschen
		beq.s	.AllesKlar
		jsr	A5KeyFehler(a5)
.AllesKlar:	dbf	d5,.ChkKey
		tst.l	d0
		jmp	A5KeyTestNext(a5)


*-------------------------- Nun ein Userprogramm laden -----------------------*
LoadUserBatchPrg:
	moveq	#0,d0
	rts
*		movem.l d1-a6,-(a7)
*		moveq	#EPR_LoadError,d7
*
*
******************** Check auf Zeicherkette **********************
*** INPUT:	a1 = Zeichenkette (mit Leerzeichen)		*
*** OutPut	a1 = Start of next String			*
***		d0 = Start of String				*
***		d1 = Length of String				*
******************************************************************
*	*-------- Ende des PDMenu-Namens finden --------*
*		move.l	a0,a1
*		movem.l	d2-d7/a0/a2-a6,-(a7)
*		jsr	A5FindFileName(a5)
*		movem.l	(a7)+,d2-d7/a0/a2-a6
*		tst.l	d1
*		beq.s	.Error
*
*	*-------- Path fr Userprogramm finden --------*
*		movem.l	d2-d7/a0/a2-a6,-(a7)
*		jsr	A5FindFileName(a5)
*		movem.l	(a7)+,d2-d7/a0/a2-a6
*
*
*	;*************************************************************
*	;**** Copiert den Dir-Anteil des Phades nach Puffer in a0 ****
*	;**** Input =	a0 Puffer frs Dir			  ****
*	;****		a1 Puffer wo Path steht			  ****
*	;****		d3 Lnge des Phades			  ****
*	;**** Output	a0 Startadr des Filenames		  ****
*	;*************************************************************
*		lea	EngineDir(a5),a0
*		move.l	d1,d3
*		lea	PlayersDir(a5),a0
*		jsr	CreateDirAusPath
*
*
*		lea	EngineFile(a5),a1
*		moveq	#31,d1
*		jsr	A5StringCopy2(a5)
*
*		movem.l	d1-a6,-(a7)
*		jsr	AddUser2			;Userprogramm laden
*		movem.l	(a7)+,d1-a6
*		move.l	d0,d7
*.Error:		move.l	d7,d0
*		movem.l	(a7)+,d1-a6
*		tst.l	d0
*		rts
*
*

*--------------------- Playernameadr bei InitPlayer merken -------------------*
InitPlayerMerkeName:movem.l d0-a6,-(a7)

		jsr	A5NervRequestCounter(a5)


		tst.b	OnEjectPlayer(a5)
		beq.s	.NoPlBatch
		move.l	PlayerNameAnz(a5),d0
		beq.s	.NoPlBatch
		subq.l	#1,d0
		move.l	PlayerAdr(a5),d1
		lea	PlayerNameAdrs-8(a5),a0
.NextTest:	addq.l	#8,a0
		cmp.l	4(a0),d1		;richtige PlayerAdr finden
		beq.s	.Yeah
		dbf	d0,.NextTest
.Yeah:		move.l	(a0),LoadNameAdr(a5)		;Name merken
		move.l	4(a0),LoadNameAdr+4(a5)		;PlayerAdr merken
		jsr	A5DeleteAllOtherPlayers(a5)
.NoPlBatch:	movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Nervrequest fr alle User, die kein Keyfile haben
*-----------------------------------------------------------------------------*
NervRequestCounter:
		movem.l	d0-a6,-(a7)
		lea	DirPuffer(a5),a0
		moveq	#1,d1
		move.w	#LNr_TR_RegisteredStart-3,d0
		bset	#1,d1
		sub.l	d1,NervCounter(a5)
		bne.s	.NoRequest
		add.l	d1,d0
		tst.b	KeyOn-DirPuffer(a5)
		bne.s	.NoRequest
		jsr	A5NervRequest2(a5)
.NoRequest:	movem.l	(a7)+,d0-a6
		rts

*--------------------- Lsche alle nicht benutzen Player ---------------------*
DeleteAllOther2:movem.l	d0-a6,-(a7)
		clr.l	LoadNameAdr(a5)
		clr.l	LoadNameAdr+4(a5)

		tst.l	PlayerAdr(a5)
		beq.s	.NoMod

	*--------- Erst Module Raushauen --------*
		move.l	#DTP_InternalPlayer,d0
		jsr	A5FindTag(a5)
		bne.s	.NoMod
		jsr	A5WaitMouse(a5)
		jsr	A5AllesRaus(a5)
		jsr	A5GuiChanged(a5)
.NoMod:		bra.s	DeleteAllOtherPlayers2

*-----------------------------------------------------------------------------*
DeleteAllOtherPlayers:
		movem.l d0-a6,-(a7)
DeleteAllOtherPlayers2:
		tst.b	OnEjectPlayer(a5)
		beq.s	.NoDelete
		clr.b	DelAllOther(a5)			;Kennung fr DeleteAll
		tst.l	PlayerAdr(a5)
		beq.s	.AllDel
		move.l	#DTP_InternalPlayer,d0
		jsr	A5FindTag(a5)
		bne.s	.AllDel
		move.b	#1,DelAllOther(a5)		;Kennung fr DeleteAll
.AllDel:	jsr	A5DeleteAll2(a5)
.NoDelete:	clr.b	DelAllOther(a5)			;Kennung lschen
		movem.l	(a7)+,d0-a6
		rts



*-----------------------------------------------------------------------------*
*------	d0 = KeyFilenummer						------*
*------ Nummer des Keys = W1+17643-W2+54831
TestAufDisabledKeys:
		movem.l	d1-a6,-(a7)
		moveq	#0,d7
		lea	TextPuffer(a5),a0
		move.l	(A5DisabledKeys+2)-TextPuffer(a0),a1
.NoEnabled:	move.w	(a1)+,d1
		move.w	(a1)+,d2
		add.w	#54831,d2
		add.w	#17643,d1
		sub.w	d2,d1
		beq.s	.ItsAll
		cmp.w	d1,d0
		bne.s	.NoEnabled
		moveq	#EPR_ErrorInString,d7
.ItsAll:	move.l	d7,d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*--------------------- Set Filerequester-Mode d0=Nummer ---------------------*
SetFileReqMode:	LA3	LNr_Reqname
		moveq	#0,d7				;Kein Error
		move.l	d0,d6
		cmp.b	FileReqMode(a5),d2		;0=Error
		beq.w	.UseThis
		move.l	d2,d5
		cmp.b	#EPNrF_Req,d2
		beq.s	.UseReqLib
		cmp.b	#EPNrF_ReqTools,d2
		beq.s	.UseReqToolsLib
		cmp.b	#EPNrF_Asl,d2
		beq.s	.UseASLLib
		bra.w	.UseOldMode
		
	*----------- Req.Library ffnen ------------*
.UseReqLib:	moveq	#EPR_CantFindReq,d7
		move.l	a3,a1
		lea	EPG_ReqBase(a5),a3
		moveq	#0,d0
		jsr	A5OpenLib(a5)
		beq.w	.UseOldMode
		bra.w	.FreeOldLib


	*--------- ReqTools-Library ffnen ---------*
.UseReqToolsLib:
		clr.l	ReqToolsAdr11(a5)
		clr.l	ReqToolsAdr2(a5)
		moveq	#EPR_CantFindReqTools,d7
		LA1	Lnr_ReqToolsname
		lea	EPG_ReqToolsBase(a5),a3
		moveq	#38,d0
		jsr	A5OpenLib(a5)
		beq.w	.UseOldMode

	*------ File-Requester-Strukture besorgen -----*
		move.l	EPG_ReqToolsBase(a5),a6
		sub.l	a0,a0
		moveq	#0,d0				;Struktur-Type
		jsr	_LVORTAllocRequestA(a6)
		move.l	d0,ReqToolsAdr11(a5)
		tst.l	d0
		beq.s	.ReqToolsError

	*------ File-Requester-Strukture besorgen -----*
		sub.l	a0,a0
		moveq	#0,d0				;Struktur-Type
		jsr	_LVORTAllocRequestA(a6)
		move.l	d0,ReqToolsAdr2(a5)
		tst.l	d0
		bne.s	.FreeOldLib

	*--------- Struktur-Speicherr freigeben -------*
		move.l	ReqToolsAdr11(a5),a1
		jsr	_LVORTFreeRequest(a6)
		clr.l	ReqToolsAdr11(a5)

	*---- ReqTools-Filerequester freigeben ----*
.ReqToolsError:	lea	EPG_ReqToolsBase(a5),a0
		jsr	A5CloseLib(a5)
		bra.s	.UseOldMode



	*----------- ASL.Library ffnen ------------*
.UseASLLib:	moveq	#EPR_NeedHigherKickstart,d7
		tst.w	Kick2On(a5)
		beq.s	.UseOldMode
		moveq	#EPR_CantFindASL,d7
		LA1	LNr_ASLName
		lea	DTG_ASLBase(a5),a3
		moveq	#37,d0
		jsr	A5OpenLib(a5)
		beq.w	.UseOldMode


	*-------- Fehler ausgeben, falls vorhanden -------*
.FreeOldLib:	moveq	#0,d7
		bsr.w	FreeOldFileReq
		move.b	d5,FileReqMode(a5)
		move.b	#1,FileReqModeUsed(a5)

		move.w	#EPNR_FileRequesterMode,d0
		jsr	A5SetMutalExclude(a5)

		move.l	#EUT_ChangePrefs,d0
		move.w	#EPNr_FileRequesterMode,d3
		moveq	#0,d1
		move.b	FileReqMode(a5),d1
		jsr	A5UserCallUp3(a5)

	*------- Hacken im Pull-Down-Menu setzen ---------*
.UseOldMode:	
.UseThis:	tst.l	d7
		beq.s	.Ok
		move.l	d7,d0
		jmp	A5ScrollNewFehler(a5)

.Ok:		moveq	#0,d0
		move.b	FileReqMode(a5),d0
		add.w	#LNr_ReqLib,d0
		jmp	A5ScrollNew(a5)


*	;*************************************************************
*	;**** Copiert den Dir-Anteil des Phades nach Puffer in a0 ****
*	;**** Input =	a0 Puffer frs Dir			  ****
*	;****		a1 Puffer wo Path steht			  ****
*	;****		d3 Lnge des Phades			  ****
*	;**** Output	a0 Startadr des Filenames		  ****
*	;*************************************************************
*		movem.l	a1/d1,-(a7)
*		move.l	d5,a0				;Filename
*		move.w	#298,d1
*.ChangePath2:	tst.b	(a0)
*		beq.s	.ChangeEnd2
*		cmp.b	#"\",(a0)+
*		bne.s	.ZuSchrDBF2
*		move.b	#"/",-1(a0)
*.ZuSchrDBF2:	dbf	d1,.ChangePath2
*
*
*	*--- Filenamen in FilePuffer copieren ---*
*.ChangeEnd2:	move.l	d5,a0
*		jsr	A5ParentArchiveDir(a5)
*		bne.s	.NoAdd
*		addq.l	#1,a0				;realy Filename !!!
*.NoAdd:		lea	FilePuffer(a5),a1		;Zielnamen in Filepuffer
*		jsr	A5StringCopy(a5)
*
*		move.l	d5,a0
*		lea	LHAPathPuffer(a5),a1
*		move.b	#'T',(a1)+
*		move.b	#':',(a1)+
*		move.w	#LHAPathPufferSize-2,d1
*		jsr	A5StringCopy2(a5)		;only Filename in LHA
*
*		movem.l	(a7)+,d1/a1
*
*		LA0	LNr_LHAEnd
*		jsr	A5StringCopy(a5)		
*
*
*
*
*
*.Return:	movem.l	(a7)+,d1-a6
*		tst.l	d0
*		rts
*
*
;;;;;;;;;;;;;;;;;;;;;;;
		

*	*------------- Entpackt ein LHA-File -------------*
*	*-------- Auf LHA-Files checken ---------*
*	*----- d0=0 -->	LHA vorhanden(File laden-*
*	*-----   =-1 -> Kein LHA-File, Weiter   -*
*	*-----   =Error -> 
*ExtraktFirstLHA:tst.b	KeyOn(a5)
*		bne.w	LHANotCrunched
*		btst	#2,LoadFileBytes(a5)		;nur bei ModuleLoading
*		bne.w	LHANotCrunched
*		clr.b	LHALoaded(a5)
*
*	*------------- Test auf LHA-File -----------------*
*		lea	TextPuffer(a5),a0
*		cmp.w	#"-l",2(a0)
*		bne.w	LHANotCrunched
*		move.w	4(a0),d0
*		and.w	#$fff8,d0
*		cmp.w	#"h0",d0
*		bne.w	LHANotCrunched
*		cmp.b	#"-",6(a0)
*		bne.w	LHANotCrunched
*		jsr	A5CloseDatei(a5)
*
*	*----------- Namen aus Archiv laden -------------*
*	* PathPuffer	= Pfad des Archives		-*
*	* ArexxPuffer	= Befehlspfad fr LHA		-*
*	* FilenamePuffer= Name der zu entpackenden Datei *
*	* 
*		lea	ArexxPuffer(a5),a1		;Befehlspfad copieren
*		LA0	.LHAPfad
*		move.w	#ArexxPuffersize-2,d1
*		jsr	A5StringCopy2(a5)
*
*		lea	PathPuffer(a5),a0		;Archive-Pfad
*		jsr	A5StringCopy2(a5)
*		move.b	#'"',(a1)+
*		move.b	#' ',(a1)+
*		move.b	#'"',(a1)+
*
*		lea	TextPuffer+22(a5),a0		;Pfad in Archiv copieren
*		moveq	#0,d1
*		move.b	-1(a0),d1
*		subq.l	#1,d1
*		blt.w	LHANotCrunched
*.ChangePath:	cmp.b	#"\",(a0)+
*		bne.s	.ZuSchrDBF
*		move.b	#"/",-1(a0)
*.ZuSchrDBF	dbf	d1,.ChangePath
*
*		lea	TextPuffer+22(a5),a0		;Pfad in Archiv copieren
*		moveq	#0,d1
*		move.b	-1(a0),d1
*		subq.l	#1,d1
*		move.l	a1,a2
*		jsr	A5StringCopy2(a5)
*
*	;*************************************************************
*	;**** Copiert den Dir-Anteil des Phades nach Puffer in a0 ****
*	;**** Input =	a0 Puffer frs Dir			  ****
*	;****		a1 Puffer wo Path steht			  ****
*	;****		d3 Lnge des Phades			  ****
*	;**** Output	a0 Startadr des Filenames		  ****
*	;*************************************************************
*		move.l	a1,-(a7)
*		move.l	a2,a0
*		jsr	A5BerechStringSize(a5)
*		move.l	d0,d3
*		lea	LHAPathPuffer(a5),a0
*		move.b	#'T',(a0)+
*		move.b	#':',(a0)+
*		move.l	a2,a1
*		jsr	A5CreateDirAusPath(a5)
*
*	*--- Filenamen in FilePuffer copieren ---*
*		lea	FilePuffer(a5),a1		;Zielnamen in Filepuffer
*		jsr	A5StringCopy(a5)
*
*		move.l	(a7)+,a1
*
*		LA0	LNr_LHAEnd
*		jsr	A5StringCopy(a5)		
*
*
*	*--- Schrift ausgeben "Extracting ..." --*
*		LA0	Lnr_Extracting
*		lea	FilePuffer(a5),a0
*		move.l	a0,ScrollArgs(a5)
*		jsr	A5PrintText(a5)
*
*
*	*----------- Nun entpacken --------------*
*		lea	ArexxPuffer(a5),a1
*		move.l	a1,d1
*		moveq	#0,d2
*		moveq	#0,d3
*		move.l	DTG_Dosbase(a5),a6
*		jsr	_LVOExecute(a6)
*		move.l	d0,d1
*		moveq	#0,d0
*		tst.l	d1
*		bne.s	.OK
*		move.l	#EPR_CantLoadLHA,d0
*
*	*------- neuen LoadPfad festlegen -------*
*.Ok:		move.l	d0,-(a7)
*		clr.l	FileSizeNeu(a5)
*		clr.l	File(a5)
*		moveq	#2,d0				;LoadFile zurcksetzen
*		move.l	d0,LoadFileMem(a5)
*		clr.b	LoadFileBytes(a5)
*		clr.l	LFnummer(a5)
*		move.b	#1,LHALoaded(a5)
*		lea	FilePuffer(a5),a2		;Filename copieren
*		move.l	a2,FileNameAdr(a5)
*		move.l	a2,LoadFileName(a5)
*		lea	LHAPathPuffer(a5),a0
*		move.l	a0,LoadFilePath(a5)
*		jsr	A5CreateLoadPath(a5)
*		lea	FilePuffer(a5),a0
*		jsr	A5LoadNeededPlayer(a5)
*
*		move.l	(a7)+,d0		;Nicht ndern !!!
*		tst.l	d0			;!!!
*		rts				;!!!
*
*
*	*-------- Kein LHA-File -----------*
*LHANotCrunched:	moveq	#-1,d0
*		rts
*
*
		even
PufferAdr3:	dc.l	0

*****************************************************************************
*---------------------------- Load PLBatchDatei ----------------------------*
*****************************************************************************
LoadPlayerBatch:*-- Dirnamen rausspikken --*

*		move.l	a2,a1
*		move.l	d2,d3
*		move.l	ConfigPfadAdr(a5),d0
*		move.l	d0,a0
*		bne.s	.NoDef
*		LA0	LNr_ConfigDir
*.NoDef:		jsr	A5CreateDirAusPath(a5)	;A1=Path d3=Lnge
*		move.l	a0,a1
*		LA0	LNr_PlayerBatchName
*		jsr	A5CopyFileName(a5)
*
*		cmp.l	#Mode_Config,TestBits(a5)
*		beq.s	.Return
*
		clr.l	LoadNameAdr(a5)
		clr.l	LoadNameAdr+4(a5)
		move.l	ConfigPfadAdr(a5),d0
		move.l	d0,a1
		bne.s	.NoDef
		LA1	LNr_ConfigDir
.NoDef:		LA2	LNr_PlayerBatchName
		moveq	#1,d0
		moveq	#7,d1
		jsr	A5LoadFile(a5)
		bne.s	.Error

		bsr.w	FreeBatchPlMem			*Old Mem

		move.l	File(a5),EPP_PlAdr(a5)
		move.l	FileSizeNeu(a5),EPP_PlSize(a5)
		clr.l	File(a5)
		clr.l	FileSizeNeu(a5)
.Return:	moveq	#0,d0
		rts

	*--------- MenuItem sperren -------*
.Error:		move.l	d0,-(a7)
		moveq	#EPNr_PlayerBatch,d0
		jsr	A5GetMenuItemAdr(a5)	;d0=Error oder NULL
		bne.b	.Error2
		jsr	A5ClearMenuStrip(a5)
		bclr	#4,13(a0)		;Disablen
		bclr	#0,12(a0)		;Haken weg
		jsr	A5SetMenuStrip(a5)
	*--------- Gui benachrichtigen ------*
.Error2:	move.l	#EUT_ChangePrefs,d7
		move.w	#EPNr_PlayerBatch,d0
		moveq	#1,d1			;disable
		moveq	#0,d2			;aus
		jsr	A5UserCallUp4(a5)
		move.l	(a7)+,d0
		jmp	A5ScrollNewFehler(a5)




******************************************************************************
**-------------------------- Load EngineBatchDatei --------------------------*
******************************************************************************
*LoadEngineBatch:jsr	A5WaitMouse(a5)
*		LA0	LNr_SW_EngineBatch
*		jsr	A5PrintText(a5)
*
*	*---------- Dirnamen rausspikken --------*
*		tst.l	d2
*		beq.s	.FileRequest
*		move.l	a2,a1		
*		lea	UPrgBatchDir(a5),a0	;Dir-Ptr
*		move.l	d2,d3
*		blt.s	.FileRequest
*		jsr	A5CreateDirAusPath(a5)	;A1=Path d3=Lnge
*		move.l	a0,a1
*		lea	UPrgBatchFile(a5),a0
*		jsr	A5CopyFileName(a5)
*		bra.w	.LoadEngineBatch
*
*	*--------------- Filerequester -------------*
*.Filerequest:	cmp.l	#Mode_Config,TestBits(a5)
*		beq.s	.Return
*
*	;**** a0 = FileRequester-Title		    ****
*	;**** a1 = Directorypath		    ****
*	;**** a2 = Filename	 		    ****
*	;**** a3 = Window	 		    ****
*	;**** d0 = 1  SelectDir			    ****
*	;****	   0  SelectFile		    ****
*		LA0	LNr_FR_EngineBatch
*		lea	UPrgBatchDir(a5),a1
*		lea	UPrgBatchFile(a5),a2
*		jsr	A5GetMainWindowTags(a5)
*		move.l	d0,a3
*		moveq	#0,d0			;Kennung ->> File zu laden
*		jsr	A5FileRequest2(a5)
*		bne.w	EngineBatchError
*
*	*-------------- Batch-Datei reinladen ---------------*
*.LoadEngineBatch:
*		cmp.l	#Mode_Config,TestBits(a5)
*		beq.s	.Return
*
*
*	;	clr.l	LastLoadPlayer(a5)
*		moveq	#1,d0
*		moveq	#7,d1
*		lea	UPrgBatchDir(a5),a1
*		lea	UPrgBatchFile(a5),a2
*		jsr	A5LoadFile(a5)
*		bne.w	EngineBatchError
*
*		bsr.w	FreeBatchUPrgMem
*
*		move.l	File(a5),EPP_UPrgAdr(a5)
*		move.l	FileSizeNeu(a5),EPP_UPrgSize(a5)
*		clr.l	File(a5)
*		clr.l	FileSizeNeu(a5)
*
*		bsr.w	InsertEngineBatch
*
*		LA0	LNr_SW_EngineBatch
*		jsr	A5ScrollNewText(a5)
*.Return:	moveq	#0,d0
*		rts
*

*------------------------------ Clear Segment -----------------------------*
*---- d6 = Segmentadr							---*
*---- Achtung: Diese Routine wird nur aufgerufen, wenn ein reg. Engine ---*
*---- in unreg. EP geladen wurde !!!					---*
ClearSegment:	movem.l	a1/a3,-(a7)
		move.l	d6,d1
		beq.s	.NoSegment

		addq.l	#1,d6
		asl.l	#2,d6
		move.l	d6,a0
		cmp.w	#UPrg_Debugger,EUS_UserNr(a0)
		beq.s	.Debugger
		move.l	DTG_Dosbase-(TextPuffer+300)(a3),a6
		lea	100(a6),a3
		jsr	_LVOUnLoadSeg-100(a3)
.NoSegment:	move.l	OldLoadAdr(a5),a4
	;	clr.l	EUS_Next(a4)
		moveq	#0,d6
.Debugger:	movem.l	(a7)+,a1/a3
		rts



**---------- Unterprogramm fr Preference-Punkt "Use UPrg_Batch -------------*
*SetBatchInMenu:	tst.b	OnEngineBatch(a5)
*		bne.w	InsertEngineBatch
*ClearOldBatches:
*	moveq	#0,d0
*	rts
**		jsr	A5ClearMenuStrip(a5)
*
*
*	*-------- Alle Nullen durch '"' ersetzen ---------*
*	*---- um Enginebatch auf ursprnglichen Zustand zu bringen ---*
*		move.l	EPP_UPrgAdr(a5),d0
*		beq.s	.NoMore
*		move.l	d0,a0
*		move.l	EPP_UPrgSize(a5),d0
*		subq.l	#2,d0
*		blt.s	.NoMore
*.TestB:		tst.b	(a0)+
*		bne.s	.NoNull
*		move.b	#'"',-1(a0)
*.NoNull:	dbf	d0,.TestB
*
*	*------ Verkettung fr Userprogrammstruktur aktualisieren ------*
*.RetryAll:	lea	EPG_FirstUserStruct-UPrgS_NextUPrg(a5),a4
*.TestNextStruct:moveq	#0,d0
*		cmp.l	a4,d0
*		beq.s	.NoMore
*		move.l	a4,a3
*		move.l	UPrgS_NextUPrg(a4),d0
*		beq.s	.NoMore
*		move.l	d0,a4
*		move.l	UPrgS_UFlags(a4),d0
*		btst	#UPrgF_BatchName,d0
*		beq.s	.TestNextStruct
*
*	*--------- Dieses ist ein BatchEintrag ---------*
*		move.l	UPrgS_NextUPrg(a4),UprgS_NextUPrg(a3)
*		subq.l	#1,EngineAnz(a5)
*
*	*-- Userprogramm-Struktur rauswerfen --*
*		move.l	a4,a1
*		move.l	#ddUPrgS_SizeOf,d0
*		ExecBase
*		jsr	_LVOFreeMem(a6)
*		move.l	UPrgS_NextUPrg(a3),a4
*		bra.s	.RetryAll
*
*.NoMore:	clr.w	EPP_Used(a5)
*		*jsr	A5RefreshUserMenu(a5)
*		jsr	A5RefreshMenu(a5)
*		moveq	#0,d0
*		rts

*-------------------------------------------------------------------------*
InsertEngineBatch:
	moveq	#0,d0
	rts
*		movem.l d0-a6,-(a7)
*		tst.b	OnEngineBatch(a5)
*		beq.w	.Ende
*
*		tst.w	EPP_Used(a5)
*		bne.w	.Ende
*
*		cmp.l	#AnzMaxEngines,EngineAnz(a5)	;User-Mem full
*		beq.w	.Ende
*
*		lea	EPP_UPrgAdr(a5),a1
*		move.l	(a1),d0
*		beq.w	.Ende
*		tst.b	KeyOn-EPP_UPrgAdr(a1)
*		beq.w	.Ende
*		move.l	d0,a1
*		move.w	#1,EPP_Used(a5)
*
*	*------------- Teste die Bytes durch --------------*
*.NextZeileTest:	move.l	a1,a4				;Zeilenanfang setzen
*.NextTestInBat:	move.b	(a1)+,d0
*		beq.w	.Ende
*		cmp.b	#"/",d0				;Commentar
*		beq.w	.C_Commantar
*		cmp.b	#";",d0				;Commentar
*		beq.w	.NextZeile
*		cmp.b	#" ",d0				;Leerzeichen
*		beq.s	.NextTestInBat
*		cmp.b	#"	",d0			;Tab-Zeichen
*		beq.s	.NextTestInBat
*		cmp.b	#10,d0				;nchste Zeile
*		beq.s	.NextZeileTest
*		cmp.b	#"|",d0				;nchste Zeile
*		beq.s	.NextTestInBat
*		cmp.b	#"=",d0				;nchste Zeile
*		beq.w	.NextZeile
*		cmp.b	#'"',d0
*		bne.w	.NextTestInBat
*
*
*	*----- Nun beginnt der Name des Engines ----*
*		move.l	a1,a0
*.FindGanseEnd:	move.b	(a0)+,d0
*		beq.s	.Ende
*		cmp.b	#'"',d0
*		bne.s	.FindGanseEnd
*		clr.b	-1(a0)
*
*	*------- Name ins Pull-Down-Menu setzen ---------*
*		move.l	a0,-(a7)
*		moveq	#0,d1				;Kennung (nicht geladen)
*		sub.l	a4,a4				;Kein Engine
*		jsr	UserBatchName			;a1=Name
*		move.l	(a7)+,a1
*		tst.l	d0
*		bne.s	.Ende
*		move.l	LastUserNr(a5),d0
*		jsr	A5FindUserStruct(a5)
*		bne.s	.Ende
*
*	*----------- Anfang des Pfades finden -----------*
*.FindPathAnf:	move.b	(a1)+,d0
*		beq.s	.Ende
*		cmp.b	#'"',d0
*		bne.s	.FindPathAnf
*		move.l	a1,UPrgS_NameAdr(a0)
*
*	*----------- Anfang des Pfades finden -----------*
*.FindPathEnd:	move.b	(a1)+,d0
*		beq.s	.Ende
*		cmp.b	#'"',d0
*		bne.s	.FindPathEnd
*		clr.b	-1(a1)
*
*	*------------- nchste Zeile finden -------------*
*.NextZeile:	move.b	(a1)+,d0
*		beq.s	.Ende
*		cmp.b	#10,d0
*		bne.s	.NextZeile
*		bra.w	.NextZeileTest
*
*	*----------- Ende des C-Kommentars finden --------*
*.C_Commantar:	cmp.b	#"*",(a1)			;kein C-Kommentar
*		bne.w	.NextTestInBat
*		addq.l	#1,a1
*.FindCEnde:	move.b	(a1)+,d0
*		beq.s	.Ende
*		cmp.b	#"*",d0
*		bne.s	.FindCEnde
*		cmp.b	#"/",(a1)
*		bne.s	.FindCEnde
*		addq.l	#1,a1
*		bra.w	.NextTestInBat
*
*
*.Ende:		*jsr	A5RefreshUserMenu(a5)
*		jsr	A5RefreshMenu(a5)
*		movem.l	(a7)+,d0-a6
*		rts
*

**-------------------------------------------------------------------------*
**----- Es wird ein Puffer gefllt in dem die Namen der Userprogramme	--*
**----- gespeichert werden, die beim Start geladen werden sollen 	--*
**-------------------------------------------------------------------------*
*KM_SetLBName:	lea	UserBatchPufferNr(a5),a0
*		moveq	#EPR_NoMoreEngines,d0
*		move.l	(a0)+,d1
*		cmp.l	#AnzMaxEngines,d1
*		bhs.s	.Return
*		lsl.l	#2,d1
*		move.l	EPG_Arg1(a5),a1
*		move.l	a1,(a0,d1.l)	;Adresse des BatchNamens merken
*
*		moveq	#EPR_ErrorInString,d0
*		move.l	EPG_Arg2(a5),d1
*		blt.s	.Return
*		clr.b	1(a1,d1.l)
*		addq.l	#1,-4(a0)		;Nummer erhhen
*		moveq	#0,d0
*.Return:	rts
*
*


*-------------------------------------------------------------------------*
*------- Nun werden die in der Config angegebenen Engines geladen -------*
*-------------------------------------------------------------------------*
*		lea	UserBatchPufferNr(a5),a4
*		move.l	(a4)+,d5			;Nummer der Engines
*		beq.s	.NoUserBatches
*		tst.b	OnEngineBatch(a5)
*		beq.s	.NoUserBatches
*
*	*------ Name von Config nun in BatchDatei (Also in UprgS) -----*
*	*-------------------- Struktur suchen -------------------------*
*.NextTest:	move.l	(a4)+,a0			;Adr in Config
*;		move.l	(a4)+,d3		;Size of String
*
*		lea	EPG_FirstUserStruct(a5),a3
*.RetryInStruct:	move.l	(a3),d0
*		beq.s	.NextUserBatch
*		move.l	d0,a3
*		move.l	UPrgS_UFlags(a3),d1
*		btst	#UPrgF_Batchname,d1
*		beq.s	.RetryInStruct
*		move.l	UPrgS_Name(a3),a2
*		jsr	A5StrCmp(a5)
*		bne.s	.RetryInStruct
*
*	*---------------- Engine gefunden ----------------*
*		move.l	UPrgS_EngineNr(a3),d0
*		jsr	A5ClearMenuStrip(a5)
*		jsr	A5LoadBatchUPrg(a5)		;laden und glcklich sein
*
*.NextUserBatch:	subq.l	#1,d5
*		bne.s	.NextTest
*		clr.l	UserBatchPufferNr(a5)
*		jsr	A5SetMenuStrip(a5)
*.NoUserBatches:	moveq	#0,d0
*		rts
*


*--------------------------------------------------------------------------*
*------------ d0 = Usernr -------------------------------------------------*
*		movem.l	d1-a6,-(a7)
*		move.l	d0,d7
*		jsr	A5FindUserStruct(a5)
*		bne.w	.Error
*		move.l	UPrgS_NameAdr(a0),a0
*		jsr	A5BerechStringSize(a5)
*		subq.l	#1,d0
*		move.l	d0,EPG_Arg2(a5)		;Length, mu sein
*		blt.w	.Error
*		move.l	d0,d3
*		move.l	a0,a1
*		lea	EngineDir(a5),a0		;Dir-Ptr
*		jsr	A5CreateDirAusPath(a5)	;A1=Path d3=Lnge
*
*		move.l	a0,a1
*		lea	EngineFile(a5),a0
*		jsr	A5CopyFileName(a5)
*
*		move.l	d7,BatchUserNr(a5)
*		move.w	#1,BatchNewUserDa(a5)
*
*		jsr	LoadBatchUPrg2
*		tst.l	d0
*		bne.s	.Error
*
*	*------- Testen, ob letztes Engine ein TagUser -------*
*		move.l	BatchUserNr(a5),d0
*		jsr	A5FindUserStruct(a5)
*		bne.s	.Error
*	move.l	UPrgS_EUSAdr(a0),d0
*	beq.s	.WaitNochmal
*	move.l	d0,a0
*	cmp.l	#TagUserID,(a0)
*	beq.w	.OkMsgDa
*
*
*	*----------- Auf Message "New Engine warten ----------*
*.WaitNochmal:	tst.w	BatchNewUserDa(a5)
*		beq.w	.OkMsgDa
*		move.l	4,a6
*		lea	EPEnginePort,a3
*		move.l	a3,a0
*		jsr	_LVOWaitPort(a6)
*		move.l	a3,a0
*		jsr	_LVOGetMsg(a6)
*		tst.l	d0
*		beq.s	.WaitNochmal
*		move.l	d0,a1
*		jsr	EngineMessage
*		bra.s	.WaitNochmal
*
*
*.OkMSGDa:	move.l	BatchUserNr(a5),d7
*		clr.l	BatchUserNr(a5)
*		jsr	A5WaitUserPorts(a5)
*		move.l	d7,d0
*		jsr	A5FindUserStruct(a5)
*		bne.s	.Error
*		move.l	#UPrgB_Engine+UPrgB_OldBatch,UPrgS_UFlags(a0)
*.Error:		clr.w	BatchNewUserDa(a5)
*		movem.l	(a7)+,d1-a6
*		tst.l	d0
*		rts
*



*--------------- Testet, ob Engine erlaubt ist oder nicht -------------------*
*----- a4 = Ptr to Segmentadr ------------------------------------------------*
*------------------------ Keine Register verndern !! ------------------------*
KeyTestAufEngine:movem.l d1-d3/d5-a6,-(a7)
		move.l	a0,d0				; added by Buggs
		beq	.LoadAll2			;

		jsr	A5BerechStringSize(a5)
		move.l	d0,StringSize(a5)

*
*
		move.l	#$1800,d4		;Stackgre der Engines
*		move.b	KeyOn-(TextPuffer+300)(a3),d0
*		beq.s	.TesteMal
*		moveq	#0,d0
*		add.l	d4,d0
*		tst.b	(a0)
*		beq.s	.LoadAll
*		add.b	(a0),d0
*		bra.s	.LoadAll
*
*	;* Testen, ob es sich irgendwie um eine registrierte Version handelt *
*.TesteMal:	lea	KeyUserTable(pc),a1
*		moveq	#5,d5
*.TestNext:	move.l	EmptyPuffer-(TextPuffer+300)(a3),d1
*		move.w	(a1)+,d0
*		move.l	(a4,d0.w),d0
*		sub.l	d1,d0
*		beq.s	.NoClearSegment
*		jsr	A5ClearSegment(a5)
*.NoClearSegment:dbf	d5,.TestNext
*		moveq	#EUS_Reserved2-10,d0
*		cmp.b	10(a4,d0),d1
*		beq.s	.NoClearSegment3
*		jsr	A5ClearSegment(a5)
*.NoClearSegment3:move.w	(a1)+,d0
*		move.l	(a4,d0.w),a0
*		jsr	A5BerechStringSize(a5)
*		moveq	#3,d5
*.TestNextByte:	move.b	(a1)+,d1
*		add.b	#56,d1
*		cmp.b	1(a0,d0.w),d1
*		bne.s	.NoClearSegment2
*		jsr	A5ClearSegment(a5)
*.NoClearSegment2:dbf	d5,.TestNextByte
.LoadAll:	move.l	StringSize(a5),d0
.LoadAll2:
		movem.l	(a7)+,d1-d3/d5-a6
		rts


**--------- KeyTestTable zum Testen auf registrierte Userprogramme -----------*
*KeyUserTable:	dc.w	EUS_Unused1,EUS_Unused2,EUS_EPBase,EUS_Next
*		dc.w	EUS_Reserved2,EUS_Reserved3-2
*		dc.w	EUS_Creator
*		dc.b	$ed-56,$ce-56,$af-56,$00-56


*-------- Tabelle in der allen USClasses MSgFlags zugeordnet werden ---------*
MsgFlagTabelle:	dc.b	0			;USClass_Dummy
		dc.b	0			;USClass_Activate
		dc.b	0			;USClass_DeActivate
		dc.b	0			;USClass_Exit
		dc.b	USMF_ZipWin+1		;USClass_Zipwin
		dc.b	USMF_ZipWin+1		;USClass_Unzipwin
		dc.b	31			;USClass_NewEngine
		dc.b	USMF_ChangeConfig+1	;USClass_GetConfig
		dc.b	USMF_ChangeConfig+1	;USClass_NewConfig
		dc.b	31			;USClass_LockEP
		dc.b	31			;USClass_UnLockEP
		dc.b	USMF_Command+1		;USClass_Command
		dc.b	USMF_Command+1		;USClass_Answer
		dc.b	0			;USClass_QuitEagle
		dc.b	USMF_NewModule+1	;USClass_NewModule
		dc.b	USMF_NewSong+1		;USClass_NewSong
		dc.b	USMF_NewPreference+1	;USClass_NewPreference
		dc.b	USMF_ChangeInterrupt+1	;USClass_StartInt
		dc.b	USMF_ChangeInterrupt+1	;USClass_StopInt
		dc.b	USMF_PlaySample+1	;USClass_PlaySample
		dc.b	USMF_NewScrollText+1	;USClass_NewScrollText
		dc.b	USMF_NewDirectory+1	;USClass_NewDirectory
		dc.b	USMF_NewPlayer+1	;USClass_NewPlayer
		dc.b	USMF_NewEngineLoaded+1	;USClass_NewEngineLoaded
		dc.b	USMF_KillModule+1	;USClass_KillModule
		dc.b	0			;USClass_Surface
		dc.b	0			;USClass_ActiveSurface
		dc.b	USMF_AmplifiersChanged+1 ;USClass_NewAmplifierlist
		dc.b	0			;USClass_Show
		dc.b	0			;USClass_Hide
		dc.b	USMF_ChangeConfig+1	;USClass_SaveConfig
		dc.b	USMF_RemPlayerList+1	;USclass_RemPlayerList
		dc.b	USMF_RemEnginesList+1	;USclass_RemEnginesList
		dc.b	USMF_RemModulesList+1	;USclass_RemModulesList
		dc.b	USMF_LoadConfig+1	;USclass_LoadConfig
		dc.b	USMF_WaitPointer+1	;USclass_SetWaitPointer
		dc.b	USMF_WaitPointer+1	;USclass_ClearWaitPointer
		dc.b	0			;USclass_EngineCommand
	if	(*-MsgFlagTabelle)-USClass_SizeOf-1
	Aber Hallo !!
	endc
		even




*---------------------- EUS-Userprogramm-Struktur finden ------------------*
*--------------------- d0=Nummer des Userprogramms ------------------------*
FindEUSStruct:	movem.l	d1/a3,-(a7)
		jsr	A5FindUserStruct(a5)
		sub.l	a3,a3
		tst.l	d0
		bne.s	.Fehler
		moveq	#EPR_ErrorInArguments,d0
		move.l	UPrgS_EUSAdr(a0),d1
		beq.s	.Fehler
		moveq	#0,d0				;Kein Fehler
		move.l	d1,a3

.Fehler:	move.l	a3,a0
		movem.l	(a7)+,d1/a3
		tst.l	d0				;Fehler ???
		rts

*------------------------ Userprogramm-Struktur finden --------------------*
*--------------------- d0=Nummer des Userprogramms ------------------------*
FindUserStruct:	movem.l	d1-d2/d7/a1/a4,-(a7)
		moveq	#EPR_ErrorInArguments,d7
		sub.l	a0,a0
		*and.l	#$ffff,d0

		moveq	#AnzMaxEngines-1,d1
		lea	EPG_FirstUserStruct-UPRgS_NextUPrg(a5),a4
.NextUserStr:	move.l	UPrgS_NextUPrg(a4),d2
		beq.s	.NoUser
		move.l	d2,a4
		cmp.w	#UPrg_FirstEntry,d0	;nur erster Eintrag gesucht ?
		beq.s	.UserFound
		cmp.w	UPrgS_EngineNr+2(a4),d0
		beq.s	.UserFound
		dbf	d1,.NextUserStr
		bra.s	.NoUser

.UserFound:	move.l	a4,a0
		moveq	#0,d7
.NoUser:	move.l	d7,d0
		movem.l	(a7)+,d1-d2/d7/a1/a4
		tst.l	d0
		rts


*---------------------------------------------------------------------------*
*--- Alle Counter werden auf ihren max. Wert gesetzt, damit jedes sofort ---*
*--- ein Signal bekommt							----*
*---------------------------------------------------------------------------*
ClearTickCounter:movem.l d0/a0/a1,-(a7)
		lea	EPG_FirstUserStruct(a5),a0
.NextUser:	move.l	(a0),d0
		beq.s	.NoMore
		move.l	d0,a0
		move.l	UPrgS_EUSAdr(a0),d0
		beq.s	.NextUser
		move.l	d0,a1
		move.w	EUS_Ticks(a1),EUS_TickCounter(a1)
		bra.s	.NextUser

.NoMore:	movem.l	(a7)+,d0/a0/a1
		rts


*---------------------- ArgListe allocieren --------------------------------*
AllocScrollStruct:
		move.l	a0,-(sp)

		move.l	a0,d3
		move.l	a0,a1
		jsr	A5BerechStringSize(a5)
		tst.l	d0
		beq.s	.NextUPrg
		add.l	#EPT_String+8,d0
		move.l	d0,d6				;Size
		jsr	A5AllocMem(a5)
		tst.l	d0
		beq.s	.NextUPrg
		move.l	d0,d4				;ArgList
		move.l	d0,a1
		move.l	d6,EPT_StringSize(a1)
		move.l	d3,a0				;TextAdr
		move.l	d6,d1
		sub.l	#EPT_String+9,d1
		lea	EPT_String(a1),a1
		cmp.l	#EUT_PrintText,d7
		beq.s	.PrintText
		jsr	A5StringCopy2(a5)
		bra.s	.Ret
.PrintText:	jsr	A5CopySendText(a5)
.Ret:		moveq	#-1,d0
.NextUPrg:
		move.l	(sp)+,a0
		rts

*---------------------------------------------------------------------------*
*-- Eine Message nach dem angegebenen Userprogramm senden und warten, bis --*
*-------- diese wieder zurckkommt und auswerten der ReturnMessage ---------*
*--- Die SS_StructAdr wird automatisch gesetzt, sowie Type und Replyport ---*
*---- _LVOPutMsg(a6)							----*
*----									----*
*---------------------------------------------------------------------------*
SendeAllPrintMessage:
		movem.l	d0-a6,-(a7)
		move.l	#EUT_PrintText,d7
		bra.b	SendeTheseMSGs
SendeAllScrollMessage:
		movem.l	d0-a6,-(a7)
		move.l	#EUT_NewScrollText,d7
SendeTheseMSGs:	tst.w	UnterwegsNr(a5)			;vorsichtshalber
		bne.w	.NoMoreEntries			;nichts schicken !!!

		jsr	A5WaitUserPorts(a5)

		lea	EPG_FirstUserStruct(a5),a3
.NextUPrg:	move.l	(a3),d0
		beq.w	.NoMoreEntries
		move.l	d0,a3
		move.l	UPrgS_UFlags(a3),d0
		btst	#UPrgF_Engine,d0
		beq.s	.NextUPrg
		move.l	UprgS_EUSAdr(a3),d0
		beq.s	.NextUPrg
		move.l	d0,a1

	*--------------------- Tag-User ------------------*
		cmp.l	#TagUserID,(a1)
		bne.s	.TaskUser
		move.l	EUS_TagList(a1),d0
		beq.s	.NextUPrg
		move.l	d0,a6
		move.l	d7,d0
		jsr	A5FindTag2(a5)
		beq.s	.NextUPrg

	*----------- ArgListe allocieren -------------*
		bsr	AllocScrollStruct
		beq.s	.NextUPrg
	move.l	a0,-(a7)
		move.l	d4,a0			;Struct
		move.l	UPrgS_EUSAdr(a3),a2
		move.l	EUS_TagList(a2),a6
		move.l	d7,d0
		jsr	A5CallUp3(a5)
	move.l	(a7)+,a0
		bra.s	.NextUPrg

	*------------------- Task User -------------------*
.TaskUser:	move.l	EUS_MsgFlags(a1),d0
		btst	#USMF_NewScrollText,d0
		beq.s	.NextUPrg

	*----------- ArgListe allocieren -------------*
	*	move.l	d7,-(a7)
	*	move.l	#EUT_PrintText,d7
		bsr	AllocScrollStruct
	*	move.l	(a7)+,d7
	*	tst.l	d0
		beq.s	.NextUPrg

		move.l	UPrgS_EngineNr(a3),d0
		moveq	#0,d1
		moveq	#USClass_NewScrollText,d2	;USClass
		move.w	#EPNr_ScrollText,d3		;Commando
		moveq	#0,d5				;Result
		jsr	A5SendeOneMessage(a5)
		bra.w	.NextUPrg

	*------ Warte auf Reply-Messages der User-Ports ------*
.NoMoreEntries:	jsr	A5WaitUserPorts(a5)
		movem.l	(a7)+,d0-a6
		rts

*---------------------------------------------------------------------------*
*------------- Eine Message nach allen Engines und Warten, bis -------------*
*-------- diese wieder zurckkommt und auswerten der ReturnMessage ---------*
*--- Die SS_StructAdr wird automatisch gesetzt, sowie Type und Replyport ---*
*---- _LVOPutMsg(a6)							----*
*----									----*
*---- Input:	d0 = US_Class						----*
*----									----*
*---------------------------------------------------------------------------*
SendeAllMessage:clr.l	SendeAllCommand(a5)
SendeAllMessage2:
		tst.b	NoMessages(a5)
		bne.s	.Return

		movem.l	d0-a6,-(a7)
		addq.w	#1,ClearMouseVerbot(a5)
		move.l	d0,d5
		jsr	A5WaitUserPorts(a5)

		lea	EPG_FirstUserStruct(a5),a1
.NextUPrg:	move.l	(a1),d0
		beq.s	.NoMoreEntries
		move.l	d0,a1
		move.l	UPrgS_UFlags(a1),d0
		btst	#UPrgF_Engine,d0
		beq.w	.NextUPrg

	*------------------ Was fr Engine-Typ --------------------*
		move.l	UPrgS_EUSAdr(a1),d0	\
		beq.w	.NextUPrg		 \
		move.l	d0,a0			  \
		tst.l	(a0)			   \
		beq.s	.TagUser		    \
		cmp.l	#TagUserID,(a0)		     > Bei Gui's kein
		bne.s	.TaskUser		    /  Deactivate
.TagUser:	cmp.w	#USClass_DeActivate,d5	   /
		bne.s	.TaskUser		  /
		cmp.l	UMG_UPrgSAdr(a5),a1	 /
		beq.s	.NextUPrg		/


.TaskUser:	move.l	d5,-(a7)
		move.l	UPrgS_EngineNr(a1),d0
		moveq	#0,d1
		move.l	d5,d2
		move.l	SendeAllCommand(a5),d3
		moveq	#0,d4
		moveq	#0,d5
		jsr	A5SendeOneMessage(a5)
		move.l	(a7)+,d5
		bra.s	.NextUPrg

	*------ Warte auf Reply-Messages der User-Ports ------*
.NoMoreEntries:	jsr	A5WaitUserPorts(a5)
		subq.w	#1,ClearMouseVerbot(a5)
		movem.l	(a7)+,d0-a6
.Return:	rts


*---------------------------------------------------------------------------*
*-- Eine Message nach dem angegebenen Userprogramm senden und Warten, bis --*
*-------- diese wieder zurckkommt und auswerten der ReturnMessage ---------*
*--- Die SS_StructAdr wird automatisch gesetzt, sowie Type und Replyport ---*
*---- _LVOPutMsg(a6)							----*
*----									----*
*---- Input:	d0 = UserNr						----*
*----		d1 = Enabled(0) oder Disabled(1)			----*
*----		d2 = US_Class						----*
*----		d3 = Command						----*
*----		d4 = ArgList						----*
*----		d5 = Result						----*
*----									----*
*---- OutPut:	a0 = Adresse der Struktur				----*
*----		d0 = Fehler						----*
*---------------------------------------------------------------------------*
SendeOneMessage:movem.l	d1-d7/a1-a6,-(a7)

	move.l	UPrg_Struct(a5),-(a7)
	clr.l	UPrg_Struct(a5)

		sub.l	a4,a4
		jsr	A5WaitUserPorts(a5)
	move.l	d0,SendeNummer(a5)
		jsr	A5FindUserStruct(a5)
		bne.w	.Fehler
		move.l	a0,a4
		move.l	UPrgS_UFlags(a0),d0
		btst	#UPrgF_Engine,d0
		beq.w	.Fehler

	*------------------ Was fr Engine-Typ --------------------*
		btst	#UPrgF_TagUser,UprgS_UFlags+3(a0)
		beq.w	.TaskUser
		move.l	UPrgS_EUSAdr(a0),d7	;
		beq.w	.Fehler
		move.l	d7,a1
		tst.l	(a1)
		beq.s	.TagUser
		cmp.l	#TagUserID,(a1)
		bne.w	.TaskUser

	*---- Erst mal testen, ob bei eventuellem (de)aktivieren -* \
	*-------------- UserGuis verndert werden ----------------* |
.TagUser:	cmp.l	#USClass_NewConfig,d2			    |
		bne.s	.NoNewConfig				    |
		btst	#EUSF_OpenWin,EUS_Flags+1(a1)
		bne.s	.ActivateAUser
.NoNewConfig:	cmp.l	#USClass_Activate,d2			    |
		bne.s	.TagNoActivate				    |
.ActivateAUser:	jsr	A5ActivateAUser(a5)			    |
		beq.w	.NoFehler				    |
.TagNoActivate:	jsr	A5GetMainWindowHandle(a5)			    |
		move.l	d0,d1					    |
		cmp.l	#USClass_DeActivate,d2			     >  Geil
		beq.s	.TagDeActivate				    |   wa ?
		moveq	#0,d1					    |
		cmp.l	#USClass_Exit,d2			    |
		bne.s	.NoTagExit2				    |
.TagDeActivate:	move.l	SendeNummer(a5),-(a7)
		jsr	A5DeActivateAUser(a5)			    |
		move.l	(a7)+,SendeNummer(a5)
	move.l	a0,-(a7)
		move.l	SendeNummer(a5),d0	* Engine auf einmal nicht
		jsr	A5FindEUSStruct(a5)	* mehr da ???
	move.l	(a7)+,a0
	move.l	d0,-(a7)

		tst.l	d1					    |
		beq.s	.NoTagExit_1				    /
		jsr	A5OpenMainWindow(a5)
.NoTagExit_1:	
	move.l	(a7)+,d0
	tst.l	d0	
	bne.w	.NoFehler		*

.NoTagExit2:
		*---- USClass-Command abfangen ----*
		cmp.l	#USClass_Command,d2
		bne.s	.TagNoCommand

		move.l	d4,-(a7)
		move.l	EUS_TagList(a1),-(a7)
		move.l	#EUT_Command,-(a7)

		move.l	d4,a0
		move.l	d3,d0			*EPNr
		move.l	ENA_Arg1(a0),d2		*Arg1
		move.l	ENA_Arg2(a0),d3		*Arg2
		lea	ENA_String(a0),a2	*Arg1String
		moveq	#0,d1
		sub.l	a3,a3
		jsr	A5UserCallUp(a5)
		bne.s	.CommandOk
		moveq	#EPR_Functionaborted,d0
.CommandOk:	addq.l	#8,a7
		move.l	(a7)+,d4
		move.l	PufferAdr(pc),a5

		move.l	UPrg_Struct(a5),-(a7)
		move.l	d4,UPrg_Struct(a5)
		jsr	A5FreeCommandStruct(a5)
		move.l	(a7)+,UPrg_Struct(a5)
		tst.l	d0
		bra.s	.CommandErrorTest

	*--------------- USClass in Tag umwandeln ---------------*
.TagNoCommand:	movem.l	d2/a0,-(a7)
		lea	ClassToTaskTable(pc),a6
		lsl.l	#2,d2
		move.l	(a6,d2.w),d0			;Tag gelesen
		beq.w	.NoFehler_1
		move.l	EUS_TagList(a1),a6
		jsr	A5CallUp3(a5)
.NoFehler_1:	movem.l	(a7)+,a0/d3
		cmp.w	#USClass_Exit,d3
		bne.s	.NoExit1
		moveq	#0,d0
.NoExit1:	cmp.w	#USClass_Activate,d3
		beq.s	.SetHaken
		cmp.w	#USClass_Deactivate,d3
		bne.s	.NormalErrorTest

		move.w	MenuOn(a5),d5
		moveq	#0,d0
		*tst.l	d0
		*bne.s	.NormalErrorTest
		jsr	A5ClearMenustrip(a5)
		jsr	A5ClearEngineZustand(a5)
		bclr	#UPrgF_Active,UPrgS_UFlags+3(a0)
		tst.w	d5
		beq.s	.NormalErrorTest
		jsr	A5SetMenustrip(a5)
		bra.s	.NormalErrorTest

.SetHaken:	move.w	MenuOn(a5),d5
		tst.l	d0
		bne.s	.NormalErrorTest
		jsr	A5ClearMenustrip(a5)
		jsr	A5SetEngineZustand(a5)
		bset	#UPrgF_Active,UPrgS_UFlags+3(a0)
		tst.w	d5
		beq.s	.NormalErrorTest
		jsr	A5SetMenustrip(a5)

.NormalErrorTest:tst.l	d2
.CommandErrorTest:beq.w	.NoFehler		;=nicht gefunden -> kein error
		bra.w	.Fehler			;Fehler in d0





	*------ Will dieses Userprogramm diese Message haben -------*
.TaskUser:	lea	MsgFlagTabelle(pc),a1
		moveq	#EPR_FunctionAborted,d0
		moveq	#0,d6
		move.b	(a1,d2.w),d6
		beq.s	.Senden
		move.l	UPrgS_EUSAdr(a0),d7
		beq.w	.Fehler
		move.l	d7,a1
		move.l	EUS_MsgFlags(a1),d7
		subq.b	#1,d6
		btst	d6,d7
		beq.w	.Fehler


	*------- Mal schauen, ob Userprogramm noch existiert -------*
.Senden:	if removecrashes
		jsr	A5TestUserAndQuit(a5)
		bne.w	.Fehler
		endc

		lea	UPrgS_Message(a0),a0
		move.l	a0,a1
		jsr	A5ClearUserMessage(a5)

		move.w	d1,UM_Enabled(a1)
		move.w	d2,UM_Class(a1)			;Kennung setzen
		move.l	d3,UM_Command(a1)
		move.l	d4,UM_ArgString(a1)
		move.l	d5,UM_Result(a1)

	*- Testen, ob SS_Struct doch leer sein mu -*
		cmp.w	#USClass_Activate,d2
		beq.s	.StructOk
		cmp.w	#USClass_UnZipWin,d2
		beq.s	.StructOk
		cmp.w	#USClass_Exit,d2
		beq.s	.ClrStruct
		cmp.w	#USClass_ZipWin,d2
		beq.s	.ClrStruct
		cmp.w	#USClass_Deactivate,d2
		beq.s	.ClrStruct
		move.l	UPrgS_UFlags(a4),d0
		btst	#UPrgF_Active,d0			;Window erlaubt
		bne.s	.StructOk
.ClrStruct:	clr.l	UM_StructAdr(a1)

	*------------ Message senden -------------*
.StructOk:	move.l	UM_EnginePort(a1),d0
		beq.s	.NoPort
		move.l	d0,a0
		ExecBase

		movem.l	d0-a5,-(a7)
		move.l	UM_TaskAdr(a1),d0
		beq.s	.NoTask
		move.l	d0,a1
		moveq	#0,d0
		jsr	_LVOSetTaskPri(a6)		
.NoTask:	movem.l	(a7)+,d0-a5
		jsr	_LVOPutMsg(a6)

		addq.w	#1,UnterwegsNr(a5)

	*---------- Alles klar, Ende ----------*
.NoPort:	jsr	A5WaitUserPorts(a5)
.NoFehler:	moveq	#0,d0
.Fehler:	move.l	a4,a0

		move.l	(a7)+,UPrg_Struct(a5)

		movem.l	(a7)+,d1-d7/a1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
ClassToTaskTable:
 dc.l 0			;USClass_Dummy		;no class (maybe new StructAdr)
 dc.l EUT_Activate	;USClass_Activate	;Start Work e.g. Open Window
 dc.l EUT_DeActivate	;USClass_DeActivate	;e.g. Close Window (just Pause,NO Exit!)
 dc.l EUT_ExitEngine	;USClass_Exit		;Exit Engine (only to Engine)
 dc.l EUT_ZipAWin	;USClass_Zipwin
 dc.l EUT_UnZipAWin	;USClass_Unzipwin
 dc.l 0 ;EUT_NewEngine	;USClass_NewEngine	;Return-Message bei Engine-Start
 dc.l EUT_GetConfig	;USClass_GetConfig	;EUS_Flags,EUS_Winx,EUS_Winy,EUS_special have
					;to be initialized by Userprogram  before
					;replying the Message
 dc.l EUT_NewConfig	;USClass_NewConfig ;EUS_Flags,EUS_Winx,EUS_Winy,EUS_special
					;countain new Values (the Userprogram has to
					;utilize this new datas)
 dc.l 0 ;EUT_LockEP	;USClass_LockEP	;Eagleplayer sets Waiting Pointer and
					;does nothing until USCLASS_UNLOCKEP
					;comes, be shure to unlock the EP
					;again (be carefully, call UnLock only
					;as often as you called Lock)
 dc.l 0 ;EUT_UnLockEP	;USClass_UnLockEP ;Free Eagleplayer to work on
 dc.l EUT_Command	;USClass_Command ;Command to Eagleplayer, future
					;use (e.g. NextPattern,Stop)
 dc.l 0 ;EUT_Answer	;USClass_Answer	;Command came back, in UM_Arg and
					;UM_Arg2 results
 dc.l 0 ;EUT_QuitEagle	;USClass_QuitEagle ;Makes the Eagleplayer quit
 dc.l EUT_NewModule	;USClass_NewModule
 dc.l EUT_NewSong	;USClass_NewSong
 dc.l EUT_NewPreference	;USClass_NewPreference
 dc.l EUT_StartInt	;USClass_StartInt
 dc.l EUT_StopInt	;USClass_StopInt
 dc.l EUT_PlaySample	;USClass_PlaySample
 dc.l EUT_NewScrollText	;USClass_NewScrollText
 dc.l EUT_NewDirectory	;USClass_NewDirectory
 dc.l EUT_NewPlayer	;USClass_NewPlayer
 dc.l EUT_NewEngineLoaded ;USClass_NewEngineLoaded
 dc.l EUT_KillModule	;USClass_KillModule
 dc.l 0	;EUT_MainWindow	;USClass_MainWindow
 dc.l 0 ;EUT_ActiveSurface	;USClass_ActiveSurface
 dc.l EUT_NewAmplifierList	;USClass_NewAmplifierlist
 dc.l EUT_Show			;USClass_Show
 dc.l EUT_Hide			;USClass_Hide
 dc.l EUT_SaveConfig		;USClass_SaveConfig
 dc.l EUT_RemPlayerList
 dc.l EUT_RemEnginesList
 dc.l EUT_RemModulesList
 dc.l EUT_LoadConfig
 dc.l EUT_SetWaitPointer
 dc.l EUT_ClearWaitPointer
 dc.l EUT_EngineCommand

 if	(*-ClassToTaskTable-4)/4-USClass_SizeOf
 Hallo
 endc



*----------------------------------------------------------------------------*
* Dieses Engine wird aktiviert. Hier wird getestet, ob es sich um ein Gui    *
* handelt, da dann das alte Gui entfernt werden mu !			     *
* Input: a0=UPrgS (falls d0=UMG_UPrgSAdr) dann entfernen		     *
*----------------------------------------------------------------------------*
ActivateAUser:	movem.l d1-a6,-(a7)
		moveq	#-1,d0

		tst.b	OnNoGui(a5)
		bne.w	.NoGuiAllowed
	
	*------------------- User activieren -----------------*
	*        Auf Main-Gui testen          *
		move.l	UPrgS_EUSAdr(a0),d1
		beq.s	.NoUserMainGui
		move.l	d1,a1
		cmp.b	#EUTY_MainWindow,EUS_Type(a1)
		bne.s	.NoUserMainGui
		move.l	a0,a3

	*-------------- Altes Gui deactivieren --------------*
		move.l	WindowOffen(a5),-(a7)
		move.l	UMG_UPrgSAdr(a5),-(a7)
		move.l	UMG_UPrgSAdr(a5),a0
		jsr	A5DeactivateAUser(a5)
		move.l	a3,UMG_UPrgSAdr(a5)
		or.w	#UPrgB_Gui!UPrgB_Active,UPrgS_UFlags+2(a3)
		move.l	a3,a0
		jsr	A5SetEngineZustand(a5)		*Haken
		jsr	A5InsertEngineNodeName(a5)
		move.l	UPrgS_EUSAdr(a3),a0
		move.l	EUS_TagList(a0),a6
		move.l	a6,UMG_Tags(a5)
		move.l	#EUT_Activate,d0
		moveq	#-1,d3				;Error fr d0
		jsr	A5CallUp3(a5)
		move.l	(a7)+,d3
		move.l	(a7)+,d1
		tst.l	d2
		beq.s	.NoActivate
		tst.l	d0
		bne.s	.ActivateError
.NoActivate:	clr.l	Old_UMGNr(a5)
		
		moveq	#0,d0
		tst.l	d3
		beq.s	.DochOeffnen
		tst.l	d1				;Window ffnen ?
		beq.s	.NoUserMainGui
.DochOeffnen:	jsr	A5OpenMainWindow(a5)

.NoUserMainGui:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

	*----------------- Fehler bei Activate -----------------*
.ActivateError:	move.l	UMG_UPrgSAdr(a5),a0
		and.w	#-1-(UPrgB_Gui!UPrgB_Active),UPrgS_UFlags+2(a0)
		jsr	A5ClearEngineZustand(a5)
		clr.l	UMG_UPrgSAdr(a5)
		clr.l	UMG_Tags(a5)
.NoOpen:	movem.l	(a7)+,d1-a6
		moveq	#-1,d0
		rts

.NoGuiAllowed:	movem.l	(a7)+,d1-a6
		moveq	#EPR_FunctionNotEnabled,d0
		rts

*----------------------------------------------------------------------------*
* Hier wird getestet, ob es sich um ein Gui Handelt, denn dann mu da Window*
* geclosed und die Variablen gelscht werden.				     *
* Input: a0=UPrgS (falls a0=UMG_UPrgSAdr) dann entfernen			     *
*----------------------------------------------------------------------------*
DeActivateAUser:movem.l	d1-a6,-(a7)
		moveq	#0,d0
		cmp.l	a0,d0
		beq.s	.KeinUMG
		cmp.l	UMG_UPrgSAdr(a5),a0
		bne.s	.KeinUMG
		move.l	UPrgS_EngineNr(a0),Old_UMGNr(a5)

		jsr	A5CloseMainWindow(a5)
		clr.l	UMG_UPrgSAdr(a5)
		clr.l	UMG_Tags(a5)

		sub.l	a3,a3
		sub.l	a2,a2
		sub.l	a1,a1
		move.l	UPrgS_EngineNr(a0),d2
		moveq	#0,d3				*deactivate
		moveq	#0,d1
		moveq	#EPNr_Engine,d0
		jsr	A5JumpTo(a5)

		move.w	#1,WindowChanged(a5)	;fr GuiChange
.KeinUMG:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts







*----------------------------------------------------------------------------*
*---- Testet, ob Userprogramme noch aktiv sind und wenn nicht werden sie ----*
*---- entfernt !							-----*
*---- Input:	a0 = Ptr to 1 = Ptr to Engine				-----*
*---- OutPut:	d0 = Io oder Error 					-----*
*----------------------------------------------------------------------------*
	if removecrashes
TestUserAndQuit:movem.l	d1/a0/a1/a4,-(a7)
		move.l	a0,a4
		move.l	UPrgS_EUSAdr(a4),d0		;fr UserBatch
	 	beq.w	.UserIo
		move.l	d0,a1
		cmp.w	#UPrg_Debugger,EUS_UserNr(a1)
		beq.w	.UserIo

		move.l	UPrgS_UFlags(a4),d0
		btst	#UPrgF_Engine,d0
		bne.w	.UserIo


	*--------------- Wenn Engine-TagUser --> immer ok -----------*
		tst.l	(a1)				;
		beq	.UserIO
		cmp.l	#TagUserID,(a1)
		bne.w	.UserIO

		move.l	EUS_PName(a1),d0
		beq.w	.UserIo				;drfte nicht auftreten
		move.l	d0,a1
		ExecBase
		jsr	_LVOFindTask(a6)
		tst.l	d0
		beq.s	.NoTask

		move.l	d0,a1
		moveq	#0,d0
		move.b	15(a1),d0
		beq.s	.NoUser
		cmp.b	#6,d0
		beq.s	.NoUser
		cmp.b	#4,d0
		bne.w	.UserIo
		move.l	22(a1),d0
		bne.w	.UserIo

	;TS_INVALID  EQU     0
	;TS_ADDED    EQU     TS_INVALID+1
	;TS_RUN	    EQU     TS_ADDED+1
	;TS_READY    EQU     TS_RUN+1
	;TS_WAIT     EQU     TS_READY+1
	;TS_EXCEPT   EQU     TS_WAIT+1
	;TS_REMOVED  EQU     TS_EXCEPT+1


	*------------- Userprogramm nun freigeben -----------*
.NoUser:	;jsr	_LVORemTask(a6)		;bei Bedarf mitreinnehmen
.NoTask:	movem.l	d2-d7/a2-a3/a6,-(a7)
		move.l	UPrgS_EUSAdr(a4),a3
		move.l	EUS_FreeTable(a3),d0
		beq.s	.NurSperren
		move.l	d0,a3
		moveq	#1,d7

	*--- Nun Schritt fr Schritt die Tabelle freigeben --*
.NextEntry:	move.l	(a3),d1
		move.l	d7,(a3)+		;Ignore reinsetzen
		move.l	(a3),d0
		beq.s	.FreeSegment
		clr.l	(a3)+
		subq.l	#8,d1
		subq.l	#2,d1
		blt.s	.FreeSegment
		cmp.w	#EUSM_MaxNummer-EUSM_Interrupt,d1
		bhi.s	.NextEntry
		add.w	d1,d1
		move.w	.FreeTabelle(pc,d1.w),d1
		lea	.FreeTabelle(pc,d1.w),a0
		move.l	d0,a1
		ExecBase
		jsr	(a0)
		bra.s	.NextEntry

*------------------- Tabelle fr die einzelnen FreeRoutinen -----------------*
.FreeTabelle:	dc.w	FU_Interrupt-.FreeTabelle
		dc.w	FU_SubTask-.FreeTabelle
		dc.w	FU_Segment-.FreeTabelle
		dc.w	FU_MsgPort13-.FreeTabelle
		dc.w	FU_MsgPort-.FreeTabelle
		dc.w	FU_Msg-.FreeTabelle
		dc.w	FU_Lock-.FreeTabelle
		dc.w	FU_Device-.FreeTabelle
		dc.w	FU_LibraryBase-.FreeTabelle
		dc.w	FU_Window-.FreeTabelle
		dc.w	FU_Screen-.FreeTabelle
		dc.w	FU_Raster-.FreeTabelle
		dc.w	FU_Font-.FreeTabelle
		dc.w	FU_MemAdr-.FreeTabelle
		dc.w	FU_MemListAdr-.FreeTabelle
		dc.w	FU_MenuStrip-.FreeTabelle
		dc.w	FU_GadgetAdr-.FreeTabelle
		dc.w	FU_VisualInfo-.FreeTabelle
		dc.w	FU_PubScreenAdr-.FreeTabelle

	*----------------- Segment freigeben ----------------*
.FreeSegment:	;move.l	UPrgS_EngineNr(a4),d0		;aus Sicherheitsgrnden
		;jsr	A5DeleteEngine(a5)		;nur Sperren
		;bra.s	.UserWeg

	*--------- Userprogramm hat keine FreeTable ---------*
.NurSperren:	clr.l	UPrgS_Message+UM_EnginePort(a4)
		clr.l	UPrgS_Message+UM_TaskAdr(a4)

	*-------- User wurde vollstndig rausgeworfen -------*
.UserWeg:	moveq	#EPR_UserprogramNotFound,d0
		movem.l	(a7)+,d2-d7/a2-a3/a6
		bra.s	.Return

.UserIO:	moveq	#0,d0
.Return:	movem.l	(a7)+,d1/a0/a1/a4
		tst.l	d0
FU_MemSize:	rts				;drfte nie auftreten


*--------------------- Gibt PublicScreen wieder frei ----------------------*
FU_MemListAdr:	rts

*---------------------- Gibt MenuStrip wieder frei ------------------------*
FU_MenuStrip:

*------------------- Gibt GadgetStructuren wieder frei --------------------*
FU_GadgetAdr:

*---------------------- Gibt VisualInfo wieder frei -----------------------*
FU_VisualInfo:	rts
		;move.l	DTG_IntuitionBase(a5),a6
		;jmp	_LVOFreeVisualInfo(a6)

*--------------------- Gibt PublicScreen wieder frei ----------------------*
FU_PubScreenAdr:rts
		;move.l	DTG_Intuitionbase(a5),a6
		;jmp	_LVOUnlockPubScreen(a6)

*-------------------- Gibt den Interrupt wieder frei ----------------------*
FU_Interrupt:	moveq	#5,d0
		jmp	_LVORemIntServer(a6)

*--------------------- Es wird ein SubTask removed ------------------------*
FU_SubTask:	move.l	d0,a2
		jmp	_LVORemTask(a6)

*---------------------- Es wird ein Segment entfernt ----------------------*
FU_Segment:	move.l	d0,d1
		move.l	DTG_Dosbase(a5),a6
		jmp	_LVOUnloadSeg(a6)

*----------------------- Es wird ein MSgPort entfernt ---------------------*
FU_MsgPort13:	rts
	;	move.l	d0,a0
	;	jmp	_LVORemPort(a6)

*----------------- Es wird ein MsgPort entfern und gelscht ---------------*
FU_MsgPort:	move.l	d0,a0
		jmp	_LVODeleteMsgPort(a6)

*--------------------------- Es wird ein Msg replyed ----------------------*
FU_Msg:		jmp	_LVOReplyMsg(a6)

*------------------------ Ein Lock wird freigegeben -----------------------*
FU_Lock:	move.l	d0,d1
		move.l	DTG_Dosbase(a5),a6
		jmp	_LVOUnLock(a6)

*----------------------- Ein Device wird freigegeben ----------------------*
FU_Device:	jmp	_LVOCloseDevice(a6)

*------------------------ Ein Library wird geclosed -----------------------*
FU_LibraryBase:	jmp	_LVOCloseLibrary(a6)

*----------------------- Ein Window wird geschlossen ----------------------*
FU_Window:	move.l	d0,a0
		move.l	DTG_Intuitionbase(a5),a6
		jmp	_LVOCloseWindow(a6)

*---------------------- Es wird ein Screen geschlossen --------------------*
FU_Screen:	move.l	d0,a0
		move.l	DTG_Intuitionbase(a5),a6
		jmp	_LVOCloseScreen(a6)

*--------------------- Es wird ein Raster freigegeben ---------------------*
FU_Raster:	;move.l	DTG_GfxBase(a5),a6
		;jmp	_LVOFreeRaster(a6)
		rts

*----------------------- Es wird ein Font freigegeben ---------------------*
FU_Font:	;move.l	DTG_GfxBase(a5),a6
		;jmp	_LVOCloseFont(a6)
		rts

*----------------------- Es wird Speicher freigegeben ---------------------*
FU_MemAdr:	cmp.l	#EUSM_Arg1,(a3)
		bne.s	.NoMem		
		move.l	d7,(a3)+			;Ignore setzen
		move.l	(a3),d0
		clr.l	(a3)+
		jsr	_LVOFreeMem(a6)
.NoMem:		rts
	endc

*---------------------------------------------------------------------------*
*----- Wartet, bis alle Messages von den Userprogrammen wieder da sind -----*
*---------------------------------------------------------------------------*
WaitUserPorts:	movem.l	d0-a6,-(a7)
.WaitNochmal:	tst.w	UnterwegsNr(a5)
		beq.w	.NoMsgs
		tst.w	NoWait(a5)		*Die gesendete Msg wird gerade
		bne.s	.NoMsgs			*als Antwort ausgewertet.
		move.l	4,a6
		lea	EPReplayEnginePort,a3
		move.l	a3,a0
		jsr	_LVOWaitPort(a6)
		move.l	a3,a0
		jsr	_LVOGetMsg(a6)
		tst.l	d0
		beq.s	.WaitNochmal
		move.l	d0,a1
		jsr	A5EngineMessage(a5)
		bra.s	.WaitNochmal
.NoMsgS:	movem.l	(a7)+,d0-a6
		rts

*----------- Lscht alle nicht benutzen Werte in der UserMessage -----------*
*------------------ a0 = Pointer auf UserMessage ---------------------------*
ClearUserMessage:clr.l	(a0)
		clr.l	4(a0)
		clr.l	8(a0)
		move.b	#5,8(a0)			;Message Type
		clr.l	12(a0)
		clr.l	16(a0)
		clr.l	UM_Type(a0)
		clr.w	UM_Class(a0)
		clr.l	UM_Command(a0)
		clr.l	UM_ArgString(a0)
		clr.l	UM_Result(a0)
		clr.l	UM_UserWindow(a0)
		move.l	#EPReplayEnginePort,14(a0)	;Reply-Port setzen
		move.l	#USM_EaglePlayer,UM_Type(a0)

*---------------------------- Messageadr in a0 -----------------------------*
InsertStructAdr:move.l	d0,-(a7)

	*- Testen, ob SS_Struct doch leer sein mu -*
		tst.b	PlayOn(a5)
		beq.s	.ClrStruct
		move.l	SS_StructAdr(a5),UM_StructAdr(a0)
		move.w	UM_Class(a0),d0
		beq.s	.StructOk
		cmp.w	#USClass_Activate,d0
		beq.s	.StructOk
		cmp.w	#USClass_UnZipWin,d0
		beq.s	.StructOk
		cmp.w	#USClass_Exit,d0
		beq.s	.ClrStruct
		cmp.w	#USClass_ZipWin,d0
		beq.s	.ClrStruct
		cmp.w	#USClass_Deactivate,d0
		bne.w	.StructOk			;ClrStruct
	;	move.l	UPrgS_UFlags(a4),d0
	;	btst	#UPrgF_Active,d0		;Window erlaubt
	;	bne.s	.StructOk
.ClrStruct:	clr.l	UM_StructAdr(a0)
.StructOk:	move.l	(a7)+,d0
		rts

*---------------------------------------------------------------------------*
*RefreshUserMenu:rts
*		movem.l	d0-a6,-(a7)
*		jsr	A5ClearMenuStrip(a5)
*
*		jsr	A5GetMainWindowHandle(a5)
*		beq.w	.Return
*		move.l	d0,a0
*		move.l	46(a0),a0
*		moveq	#0,d5
*		move.w	14(a0),d5			;Hhe des Screens
*		moveq	#0,d7
*		move.b	30(a0),d7
*		sub.w	d7,d5
*		sub.w	#SUserPVerti+PrEngineVerti1,d5	;Bisheriges Menu abziehen
*		divu	#MenuBuchHoehe,d5		;Hhe des TopazFonts
*		and.l	#$ffff,d5
*		cmp.w	#63,d5
*		blo.s	.D5Ok2
*		moveq	#63,d5
*.D5Ok2:		subq.l	#1,d5
*		tst.l	d5
*		blt.s	.Return
*
*		tst.l	EngineAnz(a5)
*		beq.w	.Return
*
*	*----------- Userprogramm-Strip setzen -----------*
*		lea	Topaz80-SIAddEngineDir(a3),a2
**		moveq	#EPNr_Engine,d1			;Nummer der Aktion
*	move.w	#EPNr_FirstEngine,d1
*		moveq	#PrEngineVerti1-10,d2
*		lea	EPG_FirstUserStruct-UPrgS_NextUPrg(a5),a4
*.NextEngine:	move.l	UPrgS_NextUPrg(a4),d0			;UPrgS_NextUPrg
*		move.l	d0,(a3)
*		beq.s	.SetStrich
*		addq.l	#4,(a3)
*		move.l	d0,a4
*		lea	UPrgS_NextItem(a4),a3
*
*	*---- Wichtige Werte in Item-Struktur fllen -----*
*		move.w	d1,UPrgS_EPNr(a4)		;ActivationsNummer
*		move.l	a2,UPrgS_Font(a4)
*		add.w	#10,d2
*		move.w	d2,UPrgS_Verti(a4)		;Verti setzen
*		addq.l	#1,d1
*		dbf	d5,.NextEngine
*
*
*.SetStrich:	cmp.w	#EPNr_FirstEngine,d1			;Kein Engine
*	*	cmp.w	#EPNr_Engine1,d1			;Kein Engine
*		beq.s	.Return
*		lea	WackelIText2-Topaz80(a2),a0
*		move.l	a0,SIUserWackel-WackelIText2(a0)
*
*
*.Return:	jsr	A5SetMenuStrip(a5)
*ReturnWithd0a6	movem.l	(a7)+,d0-a6
*		rts



*----------------------------------------------------------------------------*
*-------------------- Suche ein freie UserNummer raus -----------------------*
*-------------------------- OutPut: d0=UserNr oder 0 ------------------------*
FindFreeUserNr:	movem.l	d1-a6,-(a7)
		moveq	#1,d1
		moveq	#AnzMaxEngines-1,d2
.FindFreeNumber:move.l	d1,d0
		jsr	A5FindUserStruct(a5)
		bne.s	.Found
		addq.l	#1,d1
		dbf	d2,.FindFreeNumber
		moveq	#0,d1
.Found:		move.l	d1,d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


*--------------------------- Delete All Engines -----------------------------*
DeleteAllEngines:

	*--------------- Userprogramme raushauen -----------------*
		move.b	#1,NewEngineVerbot(a5)
		moveq	#USClass_Exit,d0
		jsr	A5SendeAllMessage(a5)

		moveq	#AnzMaxEngines,d0
.NextEngine:	jsr	A5DeleteEngine(a5)
		subq.l	#1,d0
		bne.s	.NextEngine
		clr.b	NewEngineVerbot(a5)
		rts

*--------------------------- Enginestruktur rauswerfen -----------------------*
* Es werden alle Enginestructuren entfernt. Die Engines mssen vorher entfern *
* worden sein!								      *
*-----------------------------------------------------------------------------*
FreeAllEngineStructs:
		move.l	EPG_FirstUserStruct(a5),d0
.NextEngine:	tst.l	d0
		beq.s	.NoMore
		move.l	d0,a1
		move.l	(a1),a4
		move.l	UPrgS_Size(a1),d0
		beq.s	.NextE2
		ExecBase
		jsr	_LVOFreeMem(a6)
.NextE2:	move.l	a4,d0
		bra.s	.NextEngine
.NoMore:	clr.l	EPG_FirstUserStruct(a5)
		rts


*-----------------------------------------------------------------------------*
* Input: d2=EngineNr
*-----------------------------------------------------------------------------*
DeleteOneEngine:move.l	d2,d0
		move.l	d0,-(a7)
		moveq	#1,d1			;noch disabled
		moveq	#USClass_Exit,d2
		moveq	#0,d3
		moveq	#0,d4
		moveq	#0,d5
		jsr	A5SendeOneMessage(a5)
		move.l	(a7)+,d0

		move.b	#1,RealExit(a5)
		bsr	DeleteEngine
		clr.b	RealExit(a5)
		rts





*------------------------- Ein Userprogramm lschen ------------------------*
*--- Die Message, die dem Engine mitteilt, da es raus soll, mu schon  ----*
*--- abgeschickt worden sein !!!!!!!!!!!!!!!!!!!!!!!			----*
*----	Input:	d0 = Nummer des Programms				----*
*---------------------------------------------------------------------------*
DeleteEngine:	movem.l	d0-a6,-(a7)
		tst.l	EngineAnz(a5)
		beq.w	.Error

*	tst.l	EUS_Jmp(??)			;bra.s (bra.b) to the real start of the
*	beq.s	.Internal ;USClass lschen !!!
*
*
*		moveq	#0,d0
*[][]		move.w	UM_EngineNr(a1),d0	;CPN-Puffer setzen, um bei
*		jsr	A5FindEUSStruct(a5)
*		bne.s	.??????		;Error !!!
*		move.l	a0,a4
* Engine aus Liste raushauen
*
* tst.l EPG_ActiveAmplifier(a5)
* auf Allesraus achten
*
*;------------------- Message an Amplifiermanager -----------------------
*	moveq	#USClass_NewAmplifierlist,d0
*	jsr	A5SendeAllMessage(a5)

* [][] Hallo, auf internal Engine testen !!!!!!!
*		
		move.l	d0,-(sp)
		jsr	A5FindEUSStruct(a5)
		bne.s	.goon			;keine EUS Struct gefunden
		move.l	a0,a4
		tst.l	EUS_Jmp(a4)		;interne AM werden (noch?)
		beq.s	.goon			;nicht gekillt

		cmp.b	#EUTY_Amplifier,eus_type(a4)
		bne.s	.goon			;kein Amplifier -> weiter
		move.l	EPG_AmplifierList(a5),d1
		beq.s	.goon			;nur zur Sicherheit
		cmp.l	a4,d1
		beq.s	.killfirst
.loop1:		move.l	d1,a0
		move.l	EUS_Identifier(a0),d1	;nchster Amplifier
		beq.s	.goon			;Amplifier nicht in Liste gefunden
		cmp.l	a4,d1
		bne.s	.loop1
.kill			;A0 zeigt auf Vorgnger des aktuellen Amplifier
			;also Nachfolger des aktuellen -> Nachfolger des
			;Vorgngers
		move.l	EUS_Identifier(a4),EUS_Identifier(A0)
		bra.s	.found1

	*aha, der erste -> Next Amplifier auf EPG_.., fertig
.Killfirst:	move.l	EUS_Identifier(a4),EPG_AmplifierList(A5)
.Found1:	move.l	a4,d1				;zu killender Amplifier
		cmp.l	EPG_ActiveAmplifier(A5),d1	;aktiv ?
		bne.s	.weiter				;n, weiter
		jsr	A5AllesRaus(a5)
		jsr	A5GuiChanged(a5)

	*---------- Message an Amplifiermanager --------
.weiter:	tst.b	NewEngineVerbot(a5)
		bne.s	.goon
		moveq	#USClass_NewAmplifierlist,d0
		jsr	A5SendeAllMessage(a5)
.goon:		move.l	(sp)+,d0







		*jsr	A5ClearMenuStrip(a5)
		jsr	A5FindUserStruct(a5)
		bne.w	.Error

		suba.l	a3,a3			;;Buggs eingefgt
		move.l	a0,a4
		move.l	UPrgS_EUSAdr(a0),d0
		beq.w	.NoEngine
		move.l	d0,a3


*	*------ Verkettung fr Userprogramm aktualisieren ------*
*.NormalesUPrg:	lea	FirstEngine-EUS_Next(a5),a0
*.TestNextEUS:	cmp.l	EUS_Next(a0),a3
*		beq.s	.Found
*		move.l	EUS_Next(a0),d0
*		beq.s	.NoEngine		;Batchname !!!
*		move.l	d0,a0
*		bra.s	.TestNextEUS
*
*.Found:		move.l	EUS_Next(a3),a1		;Pointer auf User nach zu lschenden
*		move.l	a1,EUS_Next(a0)
*
	*--------------- Wenn Engine-TagUser --> nie Task -----------*
		tst.l	(a3)			;
		beq	.NoEngine	;notFound
		cmp.l	#TagUserID,(a3)
		beq.s	.NotFound

	*-------- Userprogramm Quitten --------*
.TestAufTask:	cmp.w	#Uprg_Debugger,EUS_UserNr(a3)
		beq.s	.NotFound
		move.l	EUS_PName(a3),d0
		beq.s	.NotFound
		move.l	d0,a1
		ExecBase
		jsr	_LVOFindTask(a6)
		tst.l	d0
		beq.s	.NotFound
		jsr	A5Delay(a5)
		bra.b	.TestAufTask

.NotFound:	cmp.w	#UPrg_Debugger,EUS_UserNr(a3) ;Userprogramm im Debugger ?
		beq.s	.NoEngine
		move.l	a3,d1
		beq.s	.NoEngine
		clr.l	UPrgS_EUSAdr(a4)
		clr.l	UPrgS_Message+UM_EnginePort(a4)
		clr.l	UPrgS_Message+UM_TaskAdr(a4)
		clr.l	UPrgS_Message+UM_Signal(a4)
		tst.l	UPrgS_SubItem(a4)
		beq.s	.NSM
		jsr	A5ClearMenuStrip(a5)
		clr.l	UPrgS_SubItem(a4)
.NSM:		asr.l	#2,d1
		subq.l	#1,d1			;SegMentadresse
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOUnLoadSeg(a6)
		subq.l	#1,LoadedEngineAnz(a5)

	*------ Verkettung fr Userprogrammstruktur aktualisieren ------*
.NoEngine:	tst.b	RealExit(a5)
		bne.s	.NoBatch
		*move.l	a3,d0		*Sonst wird beim Deactivieren eines
		*beq.s	.NoBatch	*Guis der Eintrag entfernt

;;Buggs eingefgt bzw. besser gesagt, rausgenommen: wenn das hier drin ist,
;kommt es unweigerlich zum Enforcer-Hit beim Beenden, ist zwar harmlos
;aber strend
*cmp.w	#UPrg_Debugger,EUS_UserNr(a3) ;Userprogramm im Debugger ?
*beq.s	.NoBatch

		*move.l	UPrgS_UFlags(a4),d0
		*btst	#UPrgF_OldBatch,d0
		*beq.s	.NoBatch

	*---- es handelt sich um einen Eintrag, der in der Batchliste ist ----*
		jsr	A5ClearMenuStrip(a5)

	*----- Engine aus Node-Verknpung entfernen -----*
		clr.l	UPrgS_SubItem(a4)
		clr.l	UPrgS_EUSAdr(a4)
		*lea	UPrgS_NamePuffer(a4),a1		*ist sowieso schon
		*jsr	A5GetFilename(a5)
		*move.l	a1,UPrgS_Name(a4)
		clr.l	UPrgS_Message+UM_EnginePort(a4)
		clr.l	UPrgS_Message+UM_TaskAdr(a4)
		clr.l	UPrgS_Message+UM_Signal(a4)
		move.w	#$5b,UPrgS_Flags(a4)
		move.l	#UPrgB_BatchName,UPrgS_UFlags(a4)
		*addq.l	#1,EngineAnz(a5)
		jsr	A5SetMenuStrip(a5)

		tst.b	NewEngineVerbot(a5)
		bne.s	.NoMsg1
		moveq	#USClass_RemEnginesList,d0
		jsr	A5SendeAllMessage(a5)
.NoMsg1:	move.l	a4,a0
		jsr	A5InsertEngineNodeName(a5)

		tst.b	NewEngineVerbot(a5)
		bne.s	.NoMsg2
		moveq	#USClass_NewEngineLoaded,d0
		jsr	A5SendeAllMessage(a5)
.NoMsg2:	bra.s	.Error

.NoBatch:	jsr	A5ClearMenuStrip(a5)

	*----- Engine aus Node-Verknpung entfernen -----*
		clr.l	UPrgS_SubItem(a4)
		clr.l	UPrgS_Message+UM_EnginePort(a4)	; verhindern, da ein
		clr.l	UPrgS_Message+UM_TaskAdr(a4)	;gequitteter Manager
		clr.l	UPrgS_Message+UM_Signal(a4)	;eine Msg bekommt
		tst.b	NewEngineVerbot(a5)
		bne.s	.NoMsg3
		moveq	#USClass_RemEnginesList,d0
		jsr	A5SendeAllMessage(a5)
.NoMsg3:	lea	EPG_FirstUserStruct-UPrgS_NextUPrg(a5),a0
.TestNextStruct:cmp.l	UPrgS_NextUPrg(a0),a4
		beq.s	.UserStructFound
		move.l	UPrgS_NextUPrg(a0),d0
		beq.s	.Error2
		move.l	d0,a0
		bra.s	.TestNextStruct

.UserStructFound:move.l	UPrgS_NextUPrg(a4),a1		;Pointer auf User nach zu lschenden
		move.l	a1,UPrgS_NextUPrg(a0)
		subq.l	#1,EngineAnz(a5)

		lea	UPrgS_Node(a4),a1		*Node entfernen
		REMOVE

	*-- Userprogramm-Struktur rauswerfen --*
		move.l	a4,a1
		move.l	UPrgS_Size(a1),d0
		beq.s	.Error2
		ExecBase
		jsr	_LVOFreeMem(a6)

.Error2:	jsr	A5RefreshMenu(a5)


		tst.b	NewEngineVerbot(a5)
		bne.s	.NoMsg4
		moveq	#USClass_NewEngineLoaded,d0
		jsr	A5SendeAllMessage(a5)

	*-------- Userprogramm ist weg --------*
.NoMsg4:
.Error:		*jsr	A5RefreshUserMenu(a5)
		*jsr	A5RefreshMenu(a5)
		movem.l	(a7)+,d0-a6
		rts





;========== OffsetTabelle, wo die Keyon(A5)-abfragen erfolgen ================
;gleichzeitig Check auf korrekte Filelnge, denn wenn irgendwas gendert wurde,
;findet man auf diesen Offsets nur Mll !!
KeyBeqTable	*dc.l	KeyBeq1-FreeBatchPlMem
		*dc.l	KeyBeq2-FreeBatchPlMem
		*dc.l	KeyBeq3-FreeBatchPlMem
		*dc.l	KeyBeq4-FreeBatchPlMem
		dc.l	KeyBeq5-FreeBatchPlMem
		dc.l	KeyBeq6-FreeBatchPlMem
		*dc.l	KeyBeq7-FreeBatchPlMem
		dc.l	KeyBeq8-FreeBatchPlMem
keybeqcount=4	*8
KeyBneTable
*		dc.l	KeyBne1-FreeBatchPlMem
*		dc.l	KeyBne2-FreeBatchPlMem
*		dc.l	KeyBne3-FreeBatchPlMem			;entfllt
		dc.l	KeyBne4-FreeBatchPlMem
		dc.l	KeyBne5-FreeBatchPlMem
keybnecount=2

*-------------------- Gibt Batch-Mem fr Engines frei ---------------------*
FreeBatchPlMem:movem.l d0-a6,-(a7)
		move.l	EPP_PlAdr(a5),d0
		beq.s	.NoMem
		move.l	d0,a1
		move.l	EPP_PlSize(a5),d0
		beq.s	.Nomem
		ExecBase
		jsr	_LVOFreeMem(a6)
.NoMem:		clr.l	EPP_PlAdr(a5)
		clr.l	EPP_PlSize(a5)
		movem.l	(a7)+,d0-a6
		rts

**-------------------- Gibt Batch-Mem fr Engines frei ---------------------*
*FreeBatchUPrgMem:movem.l d0-a6,-(a7)
*		bsr.w	ClearOldBatches
*		move.l	EPP_UPrgAdr(a5),d0
*		beq.s	.NoMem
*		move.l	d0,a1
*		move.l	EPP_UPrgSize(a5),d0
*		beq.s	.Nomem
*		ExecBase
*		jsr	_LVOFreeMem(a6)
*.NoMem:		clr.l	EPP_UPrgAdr(a5)
*		clr.l	EPP_UPrgSize(a5)
*		clr.w	EPP_Used(a5)
*		movem.l	(a7)+,d0-a6
*		rts

*----------------------------------------------------------------------------*
*--- Copiert die Datei, die in File/FileSizeNeu beschrieben wird in einen um ---*
*--- d0 Bytes lngeren Puffer, der andere wird freigegeben. -----------------*
*--- Input: d0 = AddMem							-----*
*--- OutPut:d0 = Fehler							-----*
*----------------------------------------------------------------------------*
CopyLoadedFileToNew:movem.l d1-a6,-(a7)
		move.l	FileSizeNeu(a5),d1
		beq.s	.Error
		add.l	d1,d0
		move.l	d0,d4
		jsr	A5AllocMem(a5)
		beq.s	.FreeOld
		move.l	d0,a1
		move.l	d0,a2
		move.l	FileSizeNeu(a5),d0
		move.l	File(a5),a0
.CopyFile:	move.b	(a0)+,(a1)+
		subq.l	#1,d0
		bne.s	.CopyFile
		bsr.s	.FreeIt
		move.l	d4,FileSizeNeu(a5)
		move.l	a2,File(a5)
		moveq	#0,d0
		bra.s	.Return

.FreeOld:	bsr.s	.FreeIt
.Error:		moveq	#EPR_ErrorInArguments,d0
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts


.FreeIt		move.l	File(a5),d0
		beq.s	.NoFileAdr
		move.l	d0,a1
		move.l	FileSizeNeu(a5),d0
		beq.s	.NoFileAdr
		ExecBase
		jsr	_LVOFreeMem(a6)
.NoFileAdr:	clr.l	File(a5)
		clr.l	FileSizeNeu(a5)
		rts


*--------------- Schnelle CopyMemroutine zum Module kopieren -----------------*
*------	d0 = Size							------*
*------	a0 = SourceAdr							------*
*------	a1 = DestinationAdr						------*
*------------- Adressen mssen gerade sein !!!!!!!!!!!!!!!!!!!! --------------*
CopyMemQuick:	movem.l	d0-a6,-(a7)
		ExecBase
		move.l	d0,d7
		and.b	#$f8,d0
		lea	(a0,d0.l),a2
		lea	(a1,d0.l),a3
		tst.l	d0
		beq.s	.NoBigMem
		jsr	_LVOCopyMemQuick(a6)
.NoBigMem:	and.w	#$7,d7
		beq.s	.NoMem
.CopyMem:	move.b	(a2)+,(a3)+
		dbra	d7,.CopyMem
.NoMem:		movem.l	(a7)+,d0-a6
		rts



*---------------------------------------------------------------------------*
*-------------------- Unterprogramme fr externe Player --------------------*
*---------------------------------------------------------------------------*
EPP_AllocSampleStruct:
		movem.l d1-a6,-(a7)
		moveq	#EPS_SizeOf,d0
		moveq	#0,d1
		jsr	A5AllocMem(a5)
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-------------------- Besorgt eine SampleInfo-Struktur ----------------------*
GetSampleInfo:	movem.l	d1-d7/a1-a6,-(a7)
		moveq	#EPR_NoModuleLoaded,d7
		tst.b	OnAllowSampleinfo(A5)
		beq.s	.Return
		tst.l	PlayerAdr(a5)
		beq.s	.Return

		moveq	#0,d7
		tst.l	EPG_SampleInfoStructure(a5)
		bne.s	.ok
		*cmp.l	#1,SampleCounter(a5)
		*bgt.s	.ok

		move.l	#EP_SampleInit,d0
		jsr	A5CallUp(a5)
		move.l	d0,d7			;Error in d0
		move.l	EPG_SampleInfoStructure(a5),a0
.Return:	move.l	d7,d0
		beq.s	.Ok
		suba.l	a0,a0
		clr.l	Samplecounter(a5)
		bsr.s	FreeSampleInfo
		move.l	#-1,samplecounter(a5)
.Ok:		addq.l	#1,SampleCounter(a5)
		move.l	d7,d0
		movem.l	(a7)+,d1-d7/a1-a6
		move.l	a0,UPrg_Result1(a5)
		tst.l	d0
		rts

*---------------- Gibt eine SampleInfoStruktur wieder frei ------------------*
FreeSampleInfo:	movem.l	d0-a6,-(a7)
		move.l	EPG_SampleInfoStructure(a5),d0
		beq.s	.Return
		tst.l	PlayerAdr(a5)
		beq.s	.Return
		subq.l	#1,SampleCounter(a5)
		bgt.s	.Return

	*----- Hier werden die einzelnen Structuren freigegeben -----*
.NextInfo:	move.l	d0,a1
		move.l	(a1),a3
		moveq	#EPS_SizeOf,d0
		ExecBase
		jsr	_LVOFreeMem(a6)
		move.l	a3,d0
		bne.s	.Nextinfo

		clr.l	EPG_SampleInfoStructure(a5)
		clr.l	SampleCounter(a5)
.Return:	movem.l	(a7)+,d0-a6
		rts



EPP_NewLoadFile2:
		moveq	#0,d0
		rts


*-------------------- Das Directory wird nochmals geladen -----------------*
RescanDir:	moveq	#0,d0
		jsr	A5FreeDirPuffer(a5)

		move.b	OnScanAlways(a5),d0
		move.l	d0,-(a7)
		move.b	#1,OnScanAlways(a5)
		jsr	A5LoadDirIn(a5)
		move.l	(a7)+,d1
		move.b	d1,OnScanAlways(a5)
		tst.l	d0
		bne.w	ToScrollNewFehler2

		LA0	LNr_NewDirLoaded
		jsr	A5ScrollNewText(a5)
		tst.l	d0
		rts

*-------------------------- Playtime berechnen -----------------------------*
CalcDuration:
		movem.l	d0-a6,-(a7)
		lea	TextPuffer(a5),a0
		move.w	#900,d1
		tst.b	OnCalcDuration-TextPuffer(a0)
		beq.w	.NoMod

	moveq	#0,d6

		lea	Pro_Initplayer,a0
		move.l	MT_Data-Pro_InitPlayer(a0),d0
		beq.w	.NoMod

		move.l	d0,a0

	lea	positionstemp(pc),a4
	moveq	#127,d0
.clr
	clr.b	(a4)+
	dbf	d0,.clr

	moveq	#0,d4
;	move.b	$3b6(a0),d4	;$3b6=950
	move.b	50(a0,d1.w),d4		Songlnge
	subq.w	#1,d4
	lea	(a0),a1
;	lea	$3b8(a0),a0	;$3b8=952
	lea	52(a0,d1.w),a0		1. Songposition
	add.l	a0,d4
	move.l	d4,maxpos

	moveq	#25,d0			Default Tempo
	add.w	#100,d0

;	move.l	#1773447,d2		Tempo clock fr PAL
	move.l	#1003407,d2		Tempo clock fr PAL
	add.l	#0770040,d2
	divu	d0,d2
	moveq	#0,d0
	move.w	d2,d0			-> D0=Tempo Counts

	moveq	#6,d1			Default Speed
	lea	temp1(pc),a3
	clr.w	(A3)

	lea	temp2(pc),a4

	clr.l	(A4)
	clr.l	4(A4)

	clr.l	8(A4)
	clr.l	12(A4)

	clr.l	16(A4)
	clr.l	20(A4)

	clr.l	24(A4)
	clr.l	28(A4)

	clr.w	breakflag
	clr.w	breakpos

	subq.l	#1,a0
.dosong
		move.w	breakpos(pc),d3
		moveq	#0,d2
		addq.l	#1,a0
		move.b	(a0),d2
		mulu	#1024,d2
		add.l	#$43c,d2
		lea	(a1,d2.l),a2		nchstes Pattern
		moveq	#0,d2
		move.b	d3,d2
		move.w	d2,(a3)			Pattpos

		lsl.w	#4,d2			mal 16 Bytes pro Position
		add.w	d2,a2			neue Position
		moveq	#63,d7			Positionen im nchsten Pattern
		sub.w	d3,d7			minus Startposition

	lea	temp2,a4
	clr.l	(A4)
	clr.l	4(A4)

	clr.l	8(A4)
	clr.l	12(A4)

	clr.l	16(A4)
	clr.l	20(A4)

	clr.l	24(A4)
	clr.l	28(A4)

	clr.l	newpos
	clr.w	breakflag
	clr.w	breakpos
	move.w	d3,(a3)

	moveq	#0,d5

	move.l	maxpos(pc),d4
	cmp.l	a0,d4
	blt.w	.end
.dopatt
	add.l	d0,d6
	addq.w	#1,d5			Counter + 1
	cmp.w	d1,d5
	bcs	.dopatt			Nonew

	moveq	#0,d5
	lea	temp2,a4
	bsr	.testcmd
	blt.s	.end

	moveq	#4,d5
	addq.l	#4,a2
	addq.l	#8,a4
	bsr	.testcmd
	blt.s	.end

	moveq	#8,d5
	addq.l	#4,a2
	addq.l	#8,a4
	bsr	.testcmd
	blt.s	.end

	moveq	#12,d5
	addq.l	#4,a2
	addq.l	#8,a4
	bsr	.testcmd
	blt.s	.end
	addq.l	#4,a2
	addq.l	#8,a4

	addq.w	#1,(a3)			Pattpos

	move.l	newpos(pc),d2
	beq.s	.ok
	move.l	d2,a0
	clr.l	newpos
	bra	.dosong
.ok
	tst.w	breakflag
	bne	.dosong

	moveq	#0,d5
	dbf	d7,.dopatt

	move.l	maxpos(pc),d4
	cmp.l	a0,d4
	bgt.w	.dosong
.end
	cmp.l	#-2,d2
	bne.s	.notclr
	moveq	#0,d6
.notclr
	lsr.l	#1,d6
	divu	#$376b,d6
	and.l	#$ffff,d6
	divu	#50>>1,d6
	and.l	#$ffff,d6			in D6 nun Spielzeit in Sekunden

		lea	EPG_Duration-102(a5),a1
		move.l	d6,102(a1)
.NoMod:		movem.l	(a7)+,d0-a6
		rts
.testcmd
	move.b	2(a2),d2
	and.b	#$f,d2
	beq.w	.nocmd

	cmp.b	#$b,d2				------ Positionjump -----
	bne.s	.nojump
		moveq	#0,d2
		move.b	3(a2),d2		Position holen
		and.b	#$7f,d2

		moveq	#0,d3
		move.b	$3b6(A1),d3			Songlnge holen
		subq.w	#1,d3
		move.l	a4,-(sp)
		lea	$3b8(a1),a4
		add.w	d3,a4
		move.l	a4,d3

		lea	positionstemp(pc),a4
		addq.b	#1,(A4,d2.w)
		cmp.b	#64,(A4,d2.w)
		blo.s	.okjum
		moveq	#-1,d3				;ENDE Signal
.okjum							;siehe 2 Zeilen tiefer
		move.l	(sp)+,a4
		cmp.l	#-1,d3
		beq.s	.endit2

		cmp.l	a0,d3
		beq	.endit

		add.w	#$3b8,d2		+ Position im Songfile
		add.l	a1,d2
		move.l	d2,d4
		cmp.l	a0,d2			minus alte Position
		bge.s	.hijump			ok, hher
.endit
		moveq	#-1,d2			Fehler: Song zuende
		rts
.endit2
		moveq	#-2,d2			Fehler: Loop im Song
		rts
.hijump	
		subq.l	#1,d2
		move.l	d2,newpos
		bra	.nocmd
.nojump

	cmp.b	#$d,d2				------ Patternbreak -------
	bne.s	.nobreak

		moveq	#0,d3
		move.b	3(a2),d3		Position im nchsten Pattern
		move.b	d3,d2
		lsr.b	#4,d3
		mulu	#10,d3
		and.b	#$f,d2
		add.b	d2,d3
		and.w	#$ff,d3
		move.w	d3,breakpos
		move.w	#1,breakflag
		bra	.nocmd
.nobreak

	cmp.b	#$f,d2				------ Speed/Tempo ------
	bne.s	.nospd

		moveq	#0,d2
		move.b	3(a2),d2
		cmp.b	#$20,d2
		bhs.s	.tempo
		move.b	d2,d1			Speed
		bra	.nocmd
.tempo		move.l	#1773447,d0		Tempo clock fr PAL
		divu	d2,d0
		and.l	#$ffff,d0
		bra	.nocmd
.nospd

	cmp.b	#$e,d2
	bne.w	.noe
		move.b	3(a2),d2		Patterndelay
		and.b	#$f0,d2
		cmp.b	#$E0,d2
		bne.s	.nopatdelay

		move.b	3(a2),d2		Delaytime holen
		and.w	#$f,d2
		addq.w	#1,d2
		mulu	d1,d2			Counter mal Zeit = Zeit in
						;Noten
		mulu	d0,d2			Noten mal Ticks

		add.l	d2,d6			auf Gesamtzeit addieren
		bra	.nocmd
.nopatdelay
		cmp.b	#$60,d2			Patternrepeat
		bne.s	.nopatrep

		move.b	3(a2),d2
		and.b	#$f,d2
		beq.s	.setnew
		
		TST.B	4(A4)
		BEQ.s	.pt_jumpcnt
		subq.b	#1,4(A4)

		bne.s	.pt_jmploop
		bra.s	.nocmd
.pt_jmploop
		move.b	(a0),d2
		mulu	#1024,d2
		add.l	#$43c,d2
		lea	(a1,d2.l),a2		Pattern
		move.w	2(a4),d3
		moveq	#0,d2
		move.b	d3,d2
		move.w	d2,(a3)			Pattpos
		lsl.w	#4,d2			mal 16 Bytes pro Position
		add.w	d2,a2			neue Position
		add.w	d5,a2			aktueller Kanal
		moveq	#63,d7			Positionen im nchsten Pattern
		sub.w	d3,d7			minus Startposition

	move.l	d0,d2				einen Waitloop drauf, dann
	mulu	d1,d2				pat es !
	add.l	d2,d6

		bra.s	.nocmd
.pt_jumpcnt
		tst.w	6(a4)
		bne.s	.nocmd2

		MOVE.B	D2,4(A4)
		move.w	#1,6(a4)
		BRA.B	.pt_jmploop
.setnew
		move.w	(a3),2(a4)		Pattpos->Repeatpos
		clr.w	4(a4)
		clr.w	6(A4)
		bra.w	.nocmd
.nopatrep

.noe
.nocmd
	moveq	#0,d2
	rts
.nocmd2
	moveq	#0,d2
	rts
	
temp1	ds.w	1		;Pattpos
temp2	ds.w	4*4
			;1.W -> Repeatpos
			;2.W -> loopcount
breakflag
	dc.w	0
breakpos
	dc.w	0
newpos	dc.l	0
maxpos	dc.l	0
positionstemp	ds.b	130		;hier sind alle Positionen
					;eingetragen, in denen wir
					;schon mal waren



*----------------------------------------------------------------------------*
*----	Input: d2=Lock des Dirs						-----*
*----  Output: a0=Adr des Dirnamensanfangs				-----*
*----------------------------------------------------------------------------*
HoleAppDirName:	movem.l	d0-d7/a1-a6,-(a7)
		move.l	d2,d1
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVODupLock(a6)
		move.l	d0,d1
		move.l	d0,d7

		lea	TextPuffer(a5),a0
		move.l	a0,d2
		move.l	#300,d3			;DirPuffersize
		jsr	_LVONameFromLock(a6)

		move.l	d7,d1
		jsr	_LVOUnLock(a6)

	*--------------- Kick13-Methode --------------*
		lea	TextPuffer(a5),a0
		move.l	a0,a1
		tst.b	(a0)
		beq.s	.Return
.NextB:		tst.b	(a0)+
		bne.s	.NextB			;Ende erreicht

	*----- Anfang des letzten Dirs finden --------*
.SubB:		cmp.b	#"/",(a0)
		beq.s	.Found
		cmp.b	#":",(a0)
		beq.s	.Doppel
		cmp.l	a0,a1
		beq.s	.Found
		subq.l	#1,a0
		bra.s	.SubB

.Doppel:	tst.b	1(a0)
		bne.s	.Found
		lea	TextPuffer-1(a5),a0
.Found:		addq.l	#1,a0
.Return:	movem.l	(a7)+,d0-d7/a1-a6
		rts




*---------------------------------------------------------------------------*
*--------- Fhrt mit dem Dir ein Parent durch und speichert Name -----------*
*---- wenn LHA-Parent gesetzt ist, mu in a0 die Pfadadresse stehen --------*
*---------------------------------------------------------------------------*
ParentDir:	movem.l	d0-a6,-(a7)
		tst.b	DirPuffer(a5)
		bne.s	.Kick13Test
		bra.s	.ret20
.Retest20:
		tst.w	Kick2On(a5)
		bne.s	.ret20

		clr.b	1(a0)
		bra.w	.Return


.ret20:		tst.w	Kick2On(a5)
		beq.w	.Return


	*-------- Lock von meinem Dir holen ----------*
		lea	DirPuffer(a5),a0
		move.l	DTG_Dosbase(a5),a6
		move.l	a0,d1
		moveq	#-2,d2				;Leselock
		jsr	_LVOLock(a6)
		tst.l	d0
		beq.w	.Return

	*----------- Testen, auf Parent-Dir ----------*
		move.l	d0,d7
		move.l	d0,d1
		jsr	_LVOParentDir(a6)
		move.l	d0,-(a7)


	*------- DirName in DirPuffer copieren -------*
		move.l	d0,d1
		lea	DirPuffer(a5),a0
		move.l	a0,d2
		move.l	#DirPufferSize-2,d3		;DirPuffersize
		jsr	_LVONameFromLock(a6)

	*------------ My DirLock freigeben -----------*
		move.l	d7,d1
		jsr	_LVOUnLock(a6)
		move.l	(a7)+,d0
		tst.l	d0
		beq.s	.Return

	*---------- Wurzel-Dir lock freigeben --------*
		move.l	d0,d1
		jsr	_LVOunLock(a6)
		bra.s	.Return

	*--------------- Kick13-Methode --------------*
.Kick13Test:	lea	DirPuffer(a5),a0
		move.l	a0,a1
		tst.b	(a0)
		beq.s	.Return
.NextB:		tst.b	(a0)+
		bne.s	.NextB			;Ende erreicht
		subq.l	#2,a0
		move.l	a0,d0

	*----- Anfang des letzten Dirs finden --------*
.SubB:		cmp.b	#"/",(a0)
		beq.s	.Clear2
		cmp.b	#":",(a0)
;		beq.s	.Retest20
		beq.s	.SpeTest		; **** neu ++++
		cmp.l	a0,a1
		beq.s	.ClearThis
		subq.l	#1,a0
		bra.s	.SubB

.SpeTest:	cmp.l	d0,a0			; **** neu ++++
		beq.w	.ReTest20		; **** neu ++++
.Clear2:	tst.b	1(a0)			;Ende des Dirpuffers
		bne.s	.Clear			;Schregstrich war am Ende des
		clr.b	(a0)			;Dirpuffers
		bra.s	.Kick13Test

.ClearThis:	clr.b	(a0)
		bra.s	.Return

.Clear:		clr.b	1(a0)			;DirPtr lschen

.Return:	movem.l	(a7)+,d0-a6
		rts



*----------------- Fhrt mit dem LHA-Pfad ein Parent durch -----------------*
*--- Input: a0 = Pfadadresse						----*
*--- Output:d0 = Error der NULL						----*
*---	    d1 = Size of LHA-Filenamesize				----*
*---	    a0 = Addi wo "/" steht					----*
*--- (LHAPathPuffer) = Filename						----*
*---------------------------------------------------------------------------*
ParentArchiveDir:
		movem.l	d2-d7/a1-a6,-(a7)
		moveq	#EPR_FunctionNotEnabled,d7
		*tst.b	KeyOn(a5)
		*beq.s	.Return
		moveq	#EPR_UnknownArchive,d7
		moveq	#0,d1
		move.l	a0,a4
		jsr	A5BerechStringSize(a5)
		*beq.s	.Return
		lea	(a0,d0.w),a2
		moveq	#-1,d6
.NextB:		addq.l	#1,d6
		cmp.l	a2,a4
		beq.s	.Return
		move.b	-(a2),d0
	;	cmp.b	#":",d0			;Error ?
	;	beq.s	.Return
		cmp.b	#":",d0			;Error ?
		beq.s	.EinB
		cmp.b	#"/",d0
		bne.s	.NextB
.EinB:		lea	1(a2),a0
		lea	LHAPathPuffer(a5),a1
		move.w	#DirPufferSize-2,d1
		jsr	A5StringCopy2(a5)

		move.l	a2,a0
		moveq	#0,d7
		move.l	d6,d1			;Filenamesize
.Return:	move.l	d7,d0
		movem.l	(a7)+,d2-d7/a1-a6
		tst.l	d0
		rts



*------------------ Verschlsselung 1 von Struct 2 aufheben ----------------*
Key_Verl12:	lea	EPKF_V2Decodek(a4),a0
		moveq	#EPKF_V2ChkSum-EPKF_V2DecodeK-1,d1
		move.l	a0,a2
.DecodeStr2:	move.b	(a0),d0
		jsr	A5DecodeD02(a5)
		move.b	d0,(a0)+
		dbf	d1,.DecodeStr2

	*---------- Checksumme der zweiten Structure ----------*
		moveq	#EPKF_V2ChkSum-EPKF_V2DecodeK-1,d2
		moveq	#0,d0
.ChkSumStr2:	moveq	#0,d1
		move.b	(a2)+,d1
		add.w	d1,d0
		dbf	d2,.ChkSumStr2
		rts



*-------- Testet, ob der Phad in a0 ein Parent durchfhren kann ------------*
*---	Input:	a0 = Phadadresse					----*
*---------------------------------------------------------------------------*
TestAufParent:	movem.l	d1-a6,-(a7)

	*-------- Lock von meinem Dir holen ----------*
		move.l	DTG_Dosbase(a5),a6
		move.l	a0,d1
		moveq	#-2,d2				;Leselock
		jsr	_LVOLock(a6)
		tst.l	d0
		beq.w	.Return

	*----------- Testen, auf Parent-Dir ----------*
		move.l	d0,d7
		move.l	d0,d1
		jsr	_LVOParentDir(a6)
		move.l	d0,-(a7)

	*------------ My DirLock freigeben -----------*
		move.l	d7,d1
		jsr	_LVOUnLock(a6)
		move.l	(a7)+,d0
		tst.l	d0
		beq.s	.Return

	*---------- Wurzel-Dir lock freigeben --------*
		move.l	d0,d1
		jsr	_LVOunLock(a6)
		moveq	#1,d0				;Parent mgloch

.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts




**-------------------------------------------------------------------------*
*KM_GetModList:	moveq	#EPR_DirIsEmpty,d7
*		move.l	EPG_Mods(a5),d0
*		beq.w	.NoMods
*		moveq	#EPR_NotEnoughMem,d7
*		mulu	#230,d0
*		add.l	#EPT_String+1000,d0		;Sicherheit
*		move.l	d0,d3
*		jsr	A5AllocMem(a5)
*		move.l	d0,UPrg_ReturnStruct(a5)
*		beq.w	.NoMods
*		move.l	d0,a4
*		move.l	d3,EPT_StringSize(a4)
*		move.l	EPG_Mods(a5),EPT_Result1(a4)
*		lea	EPT_String(a4),a4
*		lea	EmptyPuffer(a5),a3		;DirPuffer
*		tst.b	OnMultiSelectIn(a5)
*		bne.s	.DirPufferOK
*		lea	DirPuffer(a5),a3
*
*	*--------- Schleife fr Modulesliste ----------*
*.DirPufferOk:	move.l	EPG_FirstFileStruct(a5),a2
*.DirSchl:	move.l	EFP_Flags(a2),d0
*		btst	#EFPF_Filename,d0
*		beq.s	.NextEntry
*
*
*		move.l	EFP_NameDirLock(a2),d1
*		bne.s	.LockUsed
*		move.l	a4,a1
*		move.l	EFP_DirArrayPtr(a2),d0
*		beq.s	.NoNameFrom
*		move.l	d0,a0
*		move.w	#DirPufferSize-2,d1
*		jsr	A5StringCopy2(a5)
*		bra.s	.SetNameNow
*
*.LockUsed:	tst.w	Kick2On(a5)
*		beq.s	.SetNameNow
*		move.l	a4,d2		
*		move.l	#199,d3				;DirPuffersize
*		jsr	_LVONameFromLock(a6)
*		bra.s	.SetnameNow
*.NoNameFrom:	move.l	a3,a0
*		move.l	a4,a1
*		move.w	#199,d1
*		jsr	A5StringCopy2(a5)
*.SetNameNow:	move.l	a4,a0
*		jsr	A5MakeCorrectDir(a5)
*		lea	EFP_NamePuffer(a2),a0
*.NextB		tst.b	(a4)+
*		bne.s	.NextB
*		subq.l	#1,a1
*		move.l	a4,a1
*		moveq	#32,d1
*		jsr	A5StringCopy2(a5)
*		move.l	a1,a4
*		clr.b	(a4)+
*
*.NextEntry:	move.l	(a2),d0
*		move.l	d0,a2
*		bne.s	.DirSchl
*
*		moveq	#0,d7
*
*
*
*	*---------- Struktur ist fertig oder fehlerhaft ----------*
*.NoMods:	move.l	d7,d0
*		tst.l	d0
*		rts
*
**-------------------------------------------------------------------------*
*KM_ClearList:	jsr	A5FreeDirPuffer(a5)
*		moveq	#0,d0
*		rts



*-------------------------- Neue Liste hinzufgen ------------------------*
* d2=NumArgs
* a3=StructAdr
* (ListType)=Type fr Createfilespuffer
InsertModulesList:
		move.l	#EPR_ErrorInArguments,d7
		move.l	d3,a3
		cmp.l	#3,UserType(a5)			* bei ASL 1. File
		bne.s	.MultiSelect
		cmp.l	#1,d2				* mehr als 1 Arg.
		bne.s	.MultiSelect

	*---- Bei MultiSelect bei WBArgs nur 1. Module laden ----*
		move.l	(a3),d1				*Lock
		beq.w	.NoStruct
		lea	TextPuffer(a5),a0
		move.l	a0,d2
		move.l	#TextPufferSize-2,d3
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVONameFromLock(a6)
		tst.l	d0
		beq.w	.NoStruct
		lea	TextPuffer(a5),a1
		jsr	A5MakeCorrectDir(a5)
		lea	TextPuffer(a5),a0
		jsr	A5BerechStringSize(a5)
		lea	(a0,d0.w),a1		
		move.l	4(a3),a0
		jsr	A5StringCopy(a5)

		lea	TextPuffer(a5),a0
		move.l	a0,a2
		jsr	A5BerechStringSize(a5)
		move.l	d0,d2
		moveq	#EPNr_LoadModule,d0
		sub.l	a1,a1
		moveq	#0,d3
		sub.l	a3,a3
		jsr	A5JumpTo(a5)
		move.l	d0,d7
		bra.s	.NoStruct

	*---------- Die Liste in EPPuffer aufnehmen ----------*
.MultiSelect:	move.l	a3,a0			* MultiSelectZeiger
		cmp.l	#0,a0
		beq.s	.NoStruct
		sub.l	a1,a1
		move.l	d2,d1			* Anzahl der Items
		blt.s	.NoStruct
		move.l	a0,-(a7)
		jsr	A5WaitMouse(a5)
		LA0	LNr_LoadingList
		jsr	A5PrintText(a5)
		move.l	(a7)+,a0
		moveq	#0,d2			;Use Internal Puffer
		move.l	UserType(a5),d0		* Type fr Createfilespuffer
		jsr	A5CreateFilesPuffer(a5)
		move.l	d0,d7
		bne.s	.NoStruct
		La0	LNr_OperationSuccesful
		jsr	A5ScrollNewText(a5)
		jsr	A5ClearMouse(a5)
.NoStruct:	move.l	d7,d0
		rts


*-------------- Der vorhandenen Liste einen Eintrag anhngen -----------------*
* Input: a2=Adr des Pfaded
*	 d3=Flags
*		Bit 0=Sortieren(1) oder nicht(0) (def)
*		Bit 1=Hiden(1)	   oder nicht(0) (def)
* Output:d0=Error oder NULL
*-----------------------------------------------------------------------------*
AddEntry:	movem.l	d1-a6,-(a7)
		moveq	#EPR_ErrorInArguments,d0
		tst.l	d3
		beq.w	.Return
		

		clr.b	Sortieren(a5)
		btst	#0,d2
		bne.s	.SortierenJa
		move.b	#1,Sortieren(a5)
.SortierenJa:	clr.b	Hiden(a5)		;Hiden erlaubt
		btst	#1,d2
		bne.s	.HidenNein
		move.b	#1,Hiden(a5)
.HidenNein:	


		move.b	#EFPB_Filename,CFP_Flags(a5)
		move.l	a3,a0
		jsr	A5TestAufArchive(a5)
		bne.s	.NoArchive
		move.b	#EFPB_ArchiveFile,CFP_Flags(a5)
.NoArchive:


*		btst	#EFPF_ArchiveFile,CFP_Flags(a5)
*		bne.s	.NameSizeOk
*		cmp.w	#Namenlange-1,d1
*		blo.s	.NameSizeOk
*		moveq	#Namenlange-1,d1
.NameSizeOk:	move.l	a0,a1
		jsr	A5BerechStringSize(a5)
		move.l	d0,d1
		jsr	A5GetFilename(a5)
		move.l	a1,a0

		bsr.w	TestAufHide		;Name wird gehidet
		beq.w	.Return
		move.l	a3,a0

*####
*#### ACHTUNG! PYSION benutzt eigene Routine !!!!!!!
*####
*#### ACHTUNG! CreateFilesPuffer benutzt hnliche Routine

	*---- Speicher fr MenuStruktur allocieren ---*
		movem.l	d1/a0/a6,-(a7)
*###
* ???		tst.l	d7			;InternalPuffer ?? 0=Ja
*		bne.s	.NoInternalAlloc
*###

*		btst	#EFPF_ArchiveFile,CFP_Flags(a5)
*		beq.s	.NormalFile
		move.l	d3,d1
		bsr.w	AllocLHAMenuStruct
*		bra.s	.UseMem
*
*.NormalFile:	bsr.w	AllocMenuStruct
*		bra.s	.UseMem
*.NoInternalAlloc:move.l	#EFP_NamePufferEnd,d0
*		jsr	A5AllocMem(a5)		;Private Struktur allocieren
.UseMem:	movem.l	(a7)+,d1/a0/a6
.SetParent:	tst.l	d0
		beq.w	.OutOfMem		;FreeMultiPuffer
		move.l	d0,a1			;StrukturAdr nach a1
		move.l	d0,a3

		tst.l	EFP_StructSize(a1)
		bne.s	.StruckSizegesetzt
		move.l	#EFP_NamePufferEnd,EFP_StructSize(a1)
		add.l	d3,EFP_StructSize(a1)
.StruckSizegesetzt:

		move.b	CFP_Flags(a5),EFP_Flags(a1)
*		move.l	ListPathAdr(a5),EFP_DirArrayPtr(a1)
*		move.w	ArchiveEngineNr(a5),EFP_ArchiveEngineNr(a1)
		clr.w	EFP_ArchiveEngineNr(a1)

	*-------------- Lock duplizieren -------------*
*		movem.l	d1/a0/a1,-(a7)
*		move.l	d2,d1
*		beq.s	.SetNoLock
*		tst.b	DupLock(a5)		;0=Locks duplizieren
*		bne.s	.SetNoDupLock
*		move.l	DTG_Dosbase(a5),a6
*		jsr	_LVODupLock(a6)
*		move.l	d0,d1
*.SetNoDupLock:	move.l	d1,EFP_NameDirLock(a3)	;Dir-Lock merken
*.SetNoLock:	movem.l	(a7)+,d1/a0/a1


	*------ Namen nach Namenpuffer copieren -------*
*		btst	#EFPF_ArchiveFile,CFP_Flags(a5)
*		bne.s	.NameSizeOk2
*		cmp.w	#Namenlange-1,d1
*		blo.s	.NameSizeOk2
*		moveq	#Namenlange-1,d1
*.NameSizeOk2:

		lea	EFP_NamePuffer(a3),a1
		move.l	d3,d1
		subq.l	#1,d1
		blt.s	.No
		jsr	A5StringCopy2(a5)

.No		lea	EFP_NamePuffer(a3),a1
		move.l	a1,EFP_PathArrayPtr(a3)
		btst	#EFPF_ArchiveFile,CFP_Flags(a5)
		bne.s	.NameArchive
		jsr	A5GetFilename(a5)
.NameArchive:	move.l	a1,EFP_IT_IText(a3)
		move.l	a1,EFP_Node+LN_Name(a3)

	*-------------- Menustructure setzen --------------*
*		move.l	CFP_PathArrayPtr(a5),EFP_PathArrayPtr(a3)
.Pysion_Einsprung:
*		addq.l	#1,d4			;Kennung, ein File mehr
		lea	ModulesFontUsed(a5),a1
		move.l	a1,EFP_IT_ITextFont(a3)
*		move.w	d4,EFP_ModuleNr(a3)
 addq.l #1,EPG_Entries(a5)
 move.l EPG_Entries(a5),d4
 move.w	d4,EFP_ModuleNr(a3)

		add.w	#EPNr_FirstModule,EFP_ModuleNr(a3)

		move.w	#$52,EFP_MI_Flags(a3)
		move.w	#1,EFP_IT_TopEdge(a3)
		move.w	#2,EFP_IT_LeftEdge(a3)
		*move.w	#$102,EFP_IT_FrontPen(a3)
		*btst	#EFPF_FileName,CFP_Flags(a5)
		*bne.s	.DirLockOk
		*move.w	#$302,EFP_IT_FrontPen(a3)
.DirLockOk:	lea	EFP_IT_FrontPen(a3),a1
		move.l	a1,EFP_MI_ItemFill(a3)


		jsr	A5ClearMenuStrip(a5)
		moveq	#USClass_RemModulesList,d0	;keine Eintrge mehr
		jsr	A5SendeAllMessage(a5)

		lea	ModulesList(a5),a0
		move.l	a0,EPG_ModulesList(a5)
		Newlist a0

		bsr.w	SortEin
		bsr	InsertNoden
		jsr	A5RefreshMenu(a5)

		moveq	#USClass_NewDirectory,d0
		jsr	A5SendeAllMessage(a5)

		moveq	#0,d0
		bra.s	.Return


.OutOfMem:	moveq	#EPR_NotEnoughMem,d0
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
FreeDirPuffer2:
		sub.l	a0,a0
		sub.l	a1,a1
		moveq	#5,d0
		moveq	#0,d1
		moveq	#0,d2
		jsr	A5CreateFilespuffer(a5)

*		bsr	FreeDirPuffer
		moveq	#0,d0
		rts

*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*
* Manahmen zum schnelleren Laden der Dirs.
*	AllocMenuMem2	=Kein Clr mehr
*	SortEin		=Keine Schleife mehr
*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*


*----- Einen Puffer initialisieren, der die Multiselecteintrge bernimmt ----*
*----	Input:	a0 = Zeiger auf Multiselect				  ----*
*----		a1 = Adr des Menufilenames (only Internal)		  ----*
*----		d0 = Filerequester 10=App 11=Arexx ;Sonst Mode in D0	  ----*
*----		d1 = SpecialInfo fr Requester (Para2)			  ----*
*----		d2 = Use Internal Puffer (0=jes)			  ----*
*----	Ouput:	d0 = ErrorNr. d0=0 ->> alles ok				  ----*
*----		d1 = Anzahl der Eintrge				  ----*
*----		a0 = PufferAdr						  ----*
*-----------------------------------------------------------------------------*
*---------- Die Funktion arbeitetmit eingestelltem Filerequester -------------*
CreateFilesPuffer:movem.l d2-d7/a1-a6,-(a7)
		move.l	EPG_FirstFileStruct(a5),-(a7)
		clr.l	EPG_FirstFileStruct(a5)		;Keine Struktur
		clr.w	ArchiveEngineNr(a5)
		lea	EPG_FirstFileStruct(a5),a2
		move.l	a2,SortEinAdr(a5)
		clr.l	CFP_PathArrayPtr(a5)
		clr.l	Eintrage(a5)		;Wieviele Eintrge getestet/bernommen
		clr.b	Sortieren(a5)		;Sortieren erlaubt
		clr.b	DupLock(a5)		;0=Locks duplizieren
		tst.l	d2
		beq.s	.SetInPMenu
		move.b	#1,Sortieren(a5)
.SetInPMenu:	clr.b	Hiden(a5)		;Hiden erlaubt
		move.b	#EFPB_FileName,CFP_Flags(a5) ;Kennung File !!!!
		move.l	a0,a4
		moveq	#0,d4			;Anzahl der Items
		move.l	d0,d5			;Kennung des Filerequesters
		move.l	d1,d6			;Para2
		move.l	a1,d3
		move.l	d2,d7			;InternalPufferuse
		bne.s	.NoClear

		jsr	A5FreeDirPuffer(a5)

		moveq	#USClass_RemModulesList,d0
		jsr	A5SendeAllMessage(a5)


	*	jsr	A5AllocMenuMem(a5)	;MenuMem, falls nicht da, alloc
	*	beq	.OutOfMem

	*----- Routinen tesen un dvorinitialisieren -----*
.NoClear:	cmp.b	#1,d5			;Req.Library
		beq.s	.InitReqLib
;		cmp.b	#2,d5			;ReqTools.Library
;		beq.s	.InitReqTools
;		cmp.b	#3,d5			;ASL.Library
;		beq.s	.InitAsl
;		cmp.b	#4,d5			;KDFreq.Library
;		beq.s	.InitArp
;		cmp.b	#10,d5			;APP_MultiSelect
;		beq.s	.InitApp
		cmp.b	#11,d5			;Arexx_MultiSelect
		beq.s	.InitArexx
;		cmp.b	#12,d5			;WBStartUp_MultiSelect
;		beq.s	.InitWBStartUp
		cmp.b	#13,d5			;EPDir
		beq.s	.InitEPDir
		cmp.b	#14,d5			;DirLoading
		beq.s	.TestParent
		cmp.b	#15,d5			;UserListe
		beq.w	.InitUserList
		cmp.b	#16,d5			;LHA-Dir
		beq.w	.InitLHADir
		cmp.b	#17,d5			;Modulesliste (EP/DT)
		beq.w	.InitModulesliste
		cmp.b	#18,d5			;Pysion interne Liste
		beq.w	.InitModulesListe		;(per Kommando?)
		bra.w	.NextItem

	*-------- FirstAbfrage fr ReqLibrary --------*
.InitReqLib:	move.l	d6,a0
		move.l	ReqFileOffset(a0),a0	;Selected File
		tst.b	(a0)
		beq.w	.NextItem
		moveq	#0,d2			;Lock auf
		moveq	#Namenlange-1,d1
		bra.w	.SetVollNameIn



	;	move.l	(a4),d0			;Testen ob kein MultiSelect-
	;	beq.w	.ItsAll			;Eintrag vorliegt
	;	move.l	d0,a3			;Testen ob nur 1 Eintrag
	;	move.l	(a3),d0
	;	beq.w	.ItsAll
		bra.w	.NextItem		;Starte die Schleife



	*---- FirstAbfrage fr ArexxMultiSelect ------*
.InitArexx:	subq.l	#1,a4
		bra.w	.NextItem		;Starte die Schleife


	*------------ Firstabfrage fr EPDir ---------*
.InitEPDir:	btst	#EPDF_NotSorted,d6	;Flags testen
		bne.s	.InitEPNoSortier
		move.b	#1,Sortieren(a5)	;Sortieren verboten
.InitEPNoSortier:btst	#EPDF_HideAll,d6	;Flags testen
		beq.s	.InitEPNoHide
		move.b	#1,Hiden(a5)		;Hiden verboten
.InitEPNoHide:	moveq	#0,d2			;lock auf Null setzen
	;	bra.s	.TestParent		;weiter mit Test


	*--------- Soll Parent mit ins Menu ----------*
.TestParent:	lea	DirPuffer(a5),a0
		bsr.w	TestAufParent
		beq.w	.NextItem
		move.b	#EFPB_Parent,CFP_Flags(a5)
.MakeParent2:	bsr.w	AllocMenuStruct
		beq.w	.FreeMultiPuffer

		moveq	#0,d2			;DirLock
		LA0	LNr_Parent		;NameAdr
		moveq	#Namenlange-1,d1
		addq.l	#1,EPDIR_Dirs(a5)	;Pseudoerhhung
		bra.w	.SetParent

*----------------------- Enginelist wird bergeben ---------------------------*
.InitUserList:	move.l	UPrg_Struct(a5),a0
		move.l	a0,ListMemAdr(a5)
		move.l	EPT_StringSize(a0),ListMemSize(a5)
		bra.w	.NextItem


	*--------------- Init LHA-Directory --------------*
.InitLHADir:	tst.l	d7
		bne.w	.FreeMultiPuffer

	*------------- Engines aufrufen -----------------*
	* Input: a0=Pfad
	* Output:d0=Error oder NULL
	*------------------------------------------------*
		movem.l d1-d7/a1-a6,-(a7)
		lea	DirPuffer(a5),a0
		moveq	#0,d4				*FirstSearchEngineNr
		moveq	#EUTY_Extractor,d3		*Type
		move.l	#EUT_OpenArchive,d5		*Tag
		jsr	A5UserCallUp5(a5)
		subq.w	#1,d4
		move.w	d4,ArchiveEngineNr(a5)
		movem.l	(a7)+,d1-d7/a1-a6
		tst.l	d0
		bne.w	.FreeLHAPuffer
		move.l	a0,a4

		move.b	#EFPB_Parent+EFPB_ArchiveDir,CFP_Flags(a5)	;Kennung Dir !!!!
		bra.s	.MakeParent2

.InitModulesListe:
		move.b	#1,Hiden(a5)		;Hiden verboten
		move.b	#1,Sortieren(a5)	;nicht sortieren !!!
		lea	ListPuffer(a5),a0
		move.l	a0,CFP_PathArrayPtr(a5)

		move.b	#EFPB_Parent!EFPB_ParentList,CFP_Flags(a5)
		bsr.w	AllocMenuStruct
		beq.w	.FreeMultiPuffer

		LA0	LNr_Parent		;NameAdr
		moveq	#Namenlange-1,d1
		addq.l	#1,EPDIR_Dirs(a5)	;Pseudoerhhung
		bra.w	.SetParent



	*---------- Schleife fr MultiEintrge -------*
	* Zu den einzelnen Filerequester-routinen springen*
	*----- um Namenadr und Dir-Lock zu erhalten ------*
.NextItem:	clr.l	ListPathAdr(a5)
		clr.l	CFP_PathArrayPtr(a5)
		move.b	#EFPB_FileName,CFP_Flags(a5) ;Kennung File !!!!
		tst.b	OnAbortGadget(a5)
		beq.s	.NoAbortTest
		bsr.w	TestDirAbortMsg
		bne.w	.SetInMenu


.NoAbortTest:	cmp.b	#1,d5			;Req.Library
		beq.s	.NameFromReqLib
		cmp.b	#2,d5			;ReqTools.Library
		beq.s	.NameFromReqTools
		cmp.b	#3,d5			;ASL.Library
		beq.w	.NameFromAsl
;		cmp.b	#4,d5			;ARP.Library
;		beq.s	.NameFromARP
		cmp.b	#5,d5			;fr FreeDirPuffer
		beq.w	.NameFromNichts
		cmp.b	#10,d5			;APP_MultiSelect
		beq.w	.NameFromAPP
		cmp.b	#11,d5			;Arexx_MultiSelect
		beq.w	.NameFromArexx
;		cmp.b	#12,d5			;WBStartUp_MultiSelect
;		beq.s	.NameFromWBSTartUp
		cmp.b	#13,d5			;EPDir
		beq.w	.NameFromEPDir
		cmp.b	#14,d5			;Dir-Loading
		beq.w	.NameFromLoading
		cmp.b	#15,d5			;UserListe
		beq.w	.NameFromUserListe
		cmp.b	#16,d5			;LHA-Dir
		beq.w	.NameFromLHA
		cmp.b	#17,d5			;Modulesliste (DT/EP)
		beq.w	.NameFromModuleliste
		cmp.b	#18,d5			;Pysion interne Liste
		beq.w	.NameFromPysionListe
		bra.w	.ItsAll


	*------- Name und NULL-Dirlock bergeben ------*
.NameFromReqLib:moveq	#0,d2			;Dir-Lock
		cmp.l	a4,d2
		beq.w	.SetInMenu
		move.l	a4,a0
		move.l	(a4),a4			;Alle Items
		addq.l	#8,a0
		addq.l	#4,a0
		moveq	#Namenlange-1,d1
	lea	DirPuffer(a5),a1
		bra.w	.SetVollNameIn


	*------- Name und NULL-Dirlock bergeben ------*
.NameFromReqTools:moveq #0,d2			;Dir-Lock
		cmp.l	a4,d2
		beq.w	.SetInMenu
		move.l	a4,a0
		move.l	4(a0),d1
		move.l	8(a0),a0
		move.l	(a4),a4			;Alle Items
	lea	DirPuffer(a5),a1
		bra.w	.SetVollNameIn

	*------- Name und NULL-Dirlock bergeben ------*
.NameFromApp:
.NameFromASL:	moveq	#0,d2			;Dir-Lock
		cmp.l	a4,d2
		beq.w	.SetInMenu
		cmp.l	Eintrage(a5),d6		;Alle Eintrge ?
		beq.w	.SetInMenu
		tst.l	(a4)
		beq.w	.SetInMenu
		moveq	#Namenlange-1,d1
		move.l	(a4),d2			;Lock holen
		move.l	4(a4),a0		;NamenAdresse (if 0=Dir)
		addq.l	#8,a4
		sub.l	a1,a1
		tst.b	(a0)
		bne.w	.SetVollNameIn
		move.b	#EFPB_DirName,CFP_Flags(a5)	;Kennung Dir !!!!

	*--------- Erstmal Name aus FileInfoBlock holen -----*
		bsr.w	HoleAppDirName
		sub.l	a1,a1			;DirPuffer
		bra.w	.SetVollNameIn

.NameFromNichts:bra.w	.SetInMenu


*	*------ APPName und AppDirlock bergeben ------*
*.NameFromApp:	tst.l	(a4)
*		beq.w	.SetInMenu
*		moveq	#Namenlange-1,d1
*		move.l	(a4),d2
*		move.l	4(a4),a0		;NamenAdresse (if 0=Dir)
*		addq.l	#8,a4
*		tst.b	(a0)
*		bne.w	.SetVollNameIn
*		move.b	#EFPB_DirName,CFP_Flags(a5)	;Kennung Dir !!!!
*
*	*--------- Erstmal Name aus FileInfoBlock holen -----*
*		bsr.w	HoleAppDirName
*		sub.l	a1,a1			;DirPuffer
*		bra.w	.SetVollNameIn



	*------- Name und NULL-Dirlock bergeben ------*
.NameFromArexx:	move.l	a4,a1
		jsr	FindFileName		;Input a0=String
		tst.l	d0			;d1=Size
		beq.w	.SetInMenu
		move.l	a1,a4
		move.l	d0,a0			;Namenadr
		moveq	#0,d2			;Lock auf Null setzen
		bra.w	.SetVollNameIn


	*------- Name und NULL-Dirlock bergeben ------*
.NameFromEPDir:
;		move.l	d4,d1
;		moveq	#0,d0
;		tst.l	EPG_FirstFileStruct(a5)
;		beq.s	.EPDirNoParent
;		move.l	EPG_FirstFileStruct(a5),a0
;		move.b	EFP_Flags(a0),d0
;		btst	#EFPF_Parent,d0
;		beq.s	.EPDirNoParent
;		subq.l	#1,d1			;Nummer erniedriegen

.EPDirNoParent:	cmp.l	EPDir_Dirs(a5),d4
		bhs.w	.EPTestNames
		move.b	#EFPB_DirName,CFP_Flags(a5)	;Kennung Dir !!!!
		bra.s	.EPSetDirName

.EPTestNames:	move.l	EPDir_Dirs(a5),d0
		add.l	EPDir_Files(a5),d0
		cmp.l	d0,d4			;echte Nummer (d4 oder d4-1)
		bhs.w	.SetInMenu
.EPSetDirName:	moveq	#0,d1
		move.b	(a4)+,d1		;Size of String
		blt.w	.SetInMenu
		move.l	a4,a0
		lea	(a4,d1.w),a4

		move.l	File(a5),a1		;Check fr altes EPDir
		cmp.l	#9,EPD_EPVersion(a1)
		blo.w	.EPDirNormal
		cmp.w	#EPDT_LHAArchive,EPD_Type(a1)
		bne.s	.EPDirNormal
		move.b	#EFPB_FileName+EFPB_ArchiveFile,CFP_Flags(a5)
		bra.s	.EPDirSizeOk

.EPDirNormal:	cmp.w	#Namenlange-1,d1
		bhi.w	.FreeMultiPuffer
.EPDirSizeOk:	subq.l	#1,d1
		moveq	#0,d2			;lock auf Null setzen
		lea	DirPuffer(a5),a1
		bra.w	.SetVollNameIn



;.TestNames:	move.l	EPDir_Dirs(a5),d1
;		add.l	EPDir_Files(a5),d1
;		cmp.l	d1,d4
;		bhi.w	.SetInMenu
;		moveq	#0,d1
;		move.b	(a4)+,d1		;Size of String
;		blt.w	.SetInMenu
;		move.l	a4,a0
;		lea	(a4,d1.w),a4
;		cmp.w	#Namenlange-1,d1
;		bhi.w	.FreeMultiPuffer
;		subq.l	#1,d1
;		moveq	#0,d2			;lock auf Null setzen
;		bra.s	.SetVollNameIn
;

	*------------ Name vom ExNext beim Dirladen ------*
.NameFromLoading:lea	InfoBlock(a5),a0
		move.l	a0,d2
		move.l	d6,d1
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOExNext(a6)
		tst.l	d0
		beq.w	.SetInMenu
		moveq	#0,d2			;Lock setzen
		moveq	#Namenlange-1,d1
		lea	DirPuffer(a5),a1
		lea	InfoBlock+8(a5),a0	;Nameadr
		tst.l	InfoBlock+4(a5)
		blt.w	.SetVollNameIn
		move.b	#EFPB_DirName,CFP_Flags(a5)	;Kennung Dir !!!!
		bra.w	.SetVollNameIn

	*----------------- Name from UserListe -----------------*
.NameFromUserListe:
		cmp.l	EinTrage(a5),d6		;noch mehr Eintrge
		beq.w	.SetInMenu

	;	move.b	#1,DupLock(a5)		;Lock nicht duplizieren !!!
		move.b	#1,Sortieren(a5)	;nicht sortieren !!!


	;*************************************************************
	;**** Copiert den Dir-Anteil des Phades nach Puffer in a0 ****
	;**** Input =	a0 Puffer frs Dir			  ****
	;****		a1 Puffer wo Path steht			  ****
	;****		d3 Lnge des Phades			  ****
	;**** Output	a0 Startadr des Filenames		  ****
	;*************************************************************
		move.l	a4,a0
		jsr	A5BerechStringSize(a5)
		move.l	d0,d3
		blt.w	.ItsAll
		move.l	a4,a1
		move.l	a4,ListPathAdr(a5)
		lea	1(a4,d3.l),a4
		lea	PathPuffer(a5),a0
		jsr	A5CreateDirAusPath(a5)
	move.l	a0,a2
		lea	PathPuffer(a5),a1	;Namen copieren, um Dir zu
		jsr	A5StringCopy(a5)	;versauen
	clr.b	(a2)	;Nur Dir im Listenpuffer !!!

		lea	PathPuffer(a5),a0	;Namenadr
		moveq	#0,d2
		moveq	#Namenlange-1,d1
		lea	DirPuffer(a5),a1
		bra.w	.SetVollNameIn




*----------------------------- LHA-File durchgucken --------------------------*
.NameFromLHA:	

		movem.l d1-d7/a1-a6,-(a7)
		lea	LHAPathPuffer(a5),a1
		clr.b	(a1)
		moveq	#0,d1
		move.w	#LHAPathPufferSize-2,d1
		move.l	a4,a0			*	 a0=Name oder NULL
		moveq	#0,d4
		move.w	ArchiveEngineNr(a5),d4
		moveq	#EUTY_Extractor,d3		*Type
		move.l	#EUT_ArchiveExNext,d5		*Tag
		jsr	A5UserCallUp5(a5)
		movem.l	(a7)+,d1-d7/a1-a6
	*	bne.s	.NameCloseArchive2
		tst.l	d0
		bne.s	.NameCloseArchive
		move.b	#EFPB_FileName+EFPB_ArchiveFile,CFP_Flags(a5)
		lea	LHAPathPuffer(a5),a0
		jsr	A5BerechStringSize(a5)
		move.l	d0,d1
		beq.s	.NameCloseArchive
		moveq	#0,d2				;Lock
		bra.w	.SetVollNameIn

.NameCloseArchive2:move.l d3,d0
.NameCloseArchive:
		movem.l d0-a6,-(a7)
		move.l	a4,a0				*a0=ArchiveStruct
		moveq	#0,d4
		move.w	ArchiveEngineNr(a5),d4
		moveq	#EUTY_Extractor,d3		*Type
		move.l	#EUT_CloseArchive,d5		*Tag
		jsr	A5UserCallUp5(a5)
		movem.l	(a7)+,d0-a6
		cmp.w	#EPR_NoMoreEntries,d0
		bne.w	.FreeLHAPuffer
		bra.w	.SetInMenu

*		move.l	a4,d1
*		beq.w	.SetInMenu
*		lea	TextPuffer(a5),a0
*		move.l	a0,d2
*		moveq	#22,d3				;FileHeader lesen
*		move.l	DTG_Dosbase(a5),a6
*		jsr	_LVORead(a6)
*		cmp.l	#1,d0
*		bne.s	.NameLHA_TNL
*		tst.b	TextPuffer(a5)
*		beq.s	.LHACloseLHA
*.NameLHA_TNL:	cmp.l	d3,d0
*		bne.w	.FreeLHAPuffer
*
*	*----------- Testen. ob LHA-Kennung vorhanden ist ----------*
*		lea	TextPuffer(a5),a0
*		cmp.w	#"-l",2(a0)
*		bne.w	.FreeLHAPuffer
*		move.w	4(a0),d0
*		cmp.w	#"zh",d0			;??? stimmt das ?
*		beq.w	.NFLHAFound
*		and.w	#$fff8,d0
*		cmp.w	#"h0",d0
*		bne.w	.FreeLHAPuffer
*.NFLHAFound:	cmp.b	#"-",6(a0)
*		bne.w	.FreeLHAPuffer
*
*		*-- Name lesen --*
*		moveq	#0,d3
*		move.b	TextPuffer(a5),d3		;=0 -> Ende
*		bne.s	.NameLHA_Next
*.LHACloseLHA:	move.l	a4,d1
*		move.l	DTG_Dosbase(a5),a6
*		jsr	_LVOClose(a6)
*		bra.w	.SetInMenu
*
*.FreeLHAPuffer2	move.l	(sp)+,d4
*		bra	.FreeLHAPuffer
*
*.NameLHA_Next:	sub.w	#22,d3				;Lnge des Namens
*
*		move.l	a4,d1
*		beq.w	.FreeLHAPuffer
*
*		move.l	d4,-(sp)
*		moveq	#0,d4
*		move.b	Textpuffer+21(a5),d4		;richtige Lnge des
*							;Namens
*
*		lea	LHAPathPuffer(a5),a0
*		clr.b	(a0,d3.w)			;Am Ende eine NULL
*		move.l	a0,d2
*		move.l	DTG_Dosbase(a5),a6
*		jsr	_LVORead(a6)
*		cmp.l	d3,d0
*		bne.w	.FreeLHAPuffer2
*		
*		lea	LHAPathPuffer(a5),a0
*		clr.b	(a0,d4.w)			;Null ans Ende setzen
*		move.l	(sp)+,d4
*
*
*		*------ Zeiger auf nchsten Eintrag setzen -----*
*		move.l	a4,d1				;Handle
*		moveq	#0,d2
*		move.b	TextPuffer+10(a5),d2		;Offset zum nchsten
*		lsl.l	#8,d2				;File
*		move.b	TextPuffer+9(a5),d2		;Offset zum nchsten
*		lsl.l	#8,d2				;File
*		move.b	TextPuffer+8(a5),d2		;Offset zum nchsten
*		lsl.l	#8,d2				;File
*		move.b	TextPuffer+7(a5),d2
*		addq.l	#2,d2
*		move.l	d3,-(a7)
*		moveq	#0,d3				;Mode
*		move.l	DTG_Dosbase(a5),a6
*		jsr	_LVOSeek(a6)
*		move.l	(a7)+,d3
*		moveq	#-1,d1
*		cmp.l	d0,d1
*		beq.w	.FreeLHAPuffer
*
*		*---- Namelnge berechnen ----*
*		subq.l	#1,d3
*		blt.w	.FreeLHAPuffer
*		moveq	#-1,d1
*		lea	LHAPathPuffer(a5),a0
*.NameLHA_TFN:	addq.l	#1,d1
*		tst.b	(a0)+
*		beq.s	.NameLHA_Found
*		dbf	d3,.NameLHA_TFN
*
*.NameLHA_Found:	move.b	#EFPB_FileName+EFPB_ArchiveFile,CFP_Flags(a5)
*		lea	LHAPathPuffer(a5),a0
*		moveq	#0,d2				;Lock
*	;	bra.s	.SetVollNameIn
*



*-----------------------------------------------------------------------------*
.NameFromPysionListe:
		move.l	a4,d0
		beq.w	.SetInMenu
		move.l	(a4),a4
		move.l	(a4),d0
		beq.w	.SetInMenu
		*move.l	22(a4),a1
		*move.l	30(a4),a1
		move.l	26(a4),a1
		bra.s	.NameFromModulesliste2


*-----------------------------------------------------------------------------*
* Input: d0/a0=Adr/Size der Liste
*	 d2=Offset vom Start
*	 d1=Listentyp
* Output:d0=Error(-1) oder NULL Ende=1
*	 d2=neue Position
*	 a1=Pfad des Eintrages
*	 a3=ModulesPrefs oder NULL
*-----------------------------------------------------------------------------*
.NameFromModuleliste:
		move.l	File(a5),a0
		move.l	FileSizeNeu(a5),d0
		move.l	d6,d2
		move.l	a4,d1
		bsr	Py_GetNextItemFromList
		tst.l	d0
		blt.w	.FreeMultiPuffer
		bhi.w	.SetInMenu
		move.l	d2,d6

.NameFromModulesliste2:
		move.l	a1,a0
		jsr	A5BerechStringSize(a5)
		beq.w	.FreeMultiPuffer
		move.l	d0,d1
		add.l	#EFP_NamePufferEnd-(Namenlange),d0
		move.l	d0,d2
		bsr	AllocAStruct
		tst.l	d0
		beq.w	.OutOfMem
		move.l	d0,a3
		subq.l	#1,d1

		move.l	d2,EFP_StructSize(a3)

		lea	EFP_NamePuffer(a3),a1
		move.l	a1,EFP_PathArrayPtr(a3)
		jsr	A5StringCopy2(a5)
		lea	EFP_NamePuffer(a3),a1
		jsr	A5GetFileName(a5)
		move.l	a1,EFP_IT_IText(a3)
		move.l	a1,EFP_Node+LN_Name(a3)
		cmp.l	EFP_PathArrayPtr(a3),a1
		bne.s	.Py_PathOK
		clr.l	EFP_PathArrayPtr(a3)
.Py_PathOK:	*addq.l	#1,Eintrage(a5)
		move.b	#EFPB_FileName,EFP_Flags(a3) ;Kennung File !!!!
		bra.w	.Pysion_Einsprung


*********************************************************************
*********************************************************************
*********************************************************************
*********************************************************************
*********************************************************************
*********************************************************************
*********************************************************************


	*--- Der Name wird jetzt in die Strukture gesetzt ---*
	*------ Testen, welcher Speicher verlangt wird ------*
.SetVollNameIn:	addq.l	#1,Eintrage(a5)

		btst	#EFPF_ArchiveFile,CFP_Flags(a5)
		bne.s	.NameSizeOk
		cmp.w	#Namenlange-1,d1
		blo.s	.NameSizeOk
		moveq	#Namenlange-1,d1
.NameSizeOk:	bsr.w	TestAufHide		;Name wird gehidet
		beq.w	.NextItem


*####
*#### ACHTUNG! PYSION benutzt eigene Routine !!!!!!!
*####
*#### ACHTUNG! ADDENTRY benutzt hnliche Routine

	*---- Speicher fr MenuStruktur allocieren ---*
		movem.l	d1/a0/a6,-(a7)
		tst.l	d7			;InternalPuffer ?? 0=Ja
		bne.s	.NoInternalAlloc

		btst	#EFPF_ArchiveFile,CFP_Flags(a5)
		beq.s	.NormalFile
		bsr.w	AllocLHAMenuStruct
		bra.s	.UseMem

.NormalFile:	bsr.w	AllocMenuStruct
		bra.s	.UseMem
.NoInternalAlloc:move.l	#EFP_NamePufferEnd,d0
		jsr	A5AllocMem(a5)		;Private Struktur allocieren
.UseMem:	movem.l	(a7)+,d1/a0/a6
.SetParent:	tst.l	d0
		beq.w	.OutOfMem		;FreeMultiPuffer
		move.l	d0,a1			;StrukturAdr nach a1
		move.l	d0,a3

		tst.l	EFP_StructSize(a1)
		bne.s	.StruckSizegesetzt
		move.l	#EFP_NamePufferEnd,EFP_StructSize(a1)
.StruckSizegesetzt:

		move.b	CFP_Flags(a5),EFP_Flags(a1)
		move.l	ListPathAdr(a5),EFP_DirArrayPtr(a1)
		move.w	ArchiveEngineNr(a5),EFP_ArchiveEngineNr(a1)

	*-------------- Lock duplizieren -------------*
		movem.l	d1/a0/a1,-(a7)
		move.l	d2,d1
		beq.s	.SetNoLock
		tst.b	DupLock(a5)		;0=Locks duplizieren
		bne.s	.SetNoDupLock
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVODupLock(a6)
		move.l	d0,d1
.SetNoDupLock:	move.l	d1,EFP_NameDirLock(a3)	;Dir-Lock merken
.SetNoLock:	movem.l	(a7)+,d1/a0/a1


	*------ Namen nach Namenpuffer copieren -------*
		btst	#EFPF_ArchiveFile,CFP_Flags(a5)
		bne.s	.NameSizeOk2
		cmp.w	#Namenlange-1,d1
		blo.s	.NameSizeOk2
		moveq	#Namenlange-1,d1
.NameSizeOk2:	lea	EFP_NamePuffer(a3),a1
		move.l	a1,EFP_IT_IText(a3)
		move.l	a1,EFP_Node+LN_Name(a3)
		jsr	A5StringCopy2(a5)

	*-------------- Menustructure setzen --------------*
		move.l	CFP_PathArrayPtr(a5),EFP_PathArrayPtr(a3)
.Pysion_Einsprung:
		addq.l	#1,d4			;Kennung, ein File mehr
		lea	ModulesFontUsed(a5),a1
		move.l	a1,EFP_IT_ITextFont(a3)
		move.w	d4,EFP_ModuleNr(a3)
		add.w	#EPNr_FirstModule-1,EFP_ModuleNr(a3)
		move.w	#$52,EFP_MI_Flags(a3)
		move.w	#1,EFP_IT_TopEdge(a3)
		move.w	#2,EFP_IT_LeftEdge(a3)
		*move.w	#$102,EFP_IT_FrontPen(a3)
		*btst	#EFPF_FileName,CFP_Flags(a5)
		*bne.s	.DirLockOk
		*move.w	#$302,EFP_IT_FrontPen(a3)
.DirLockOk:	lea	EFP_IT_FrontPen(a3),a1
		move.l	a1,EFP_MI_ItemFill(a3)


		bsr.w	SortEin
		bra.w	.NextItem			;einsortiert werden


	*- MultiSelect ist erledigt, nun ins Menu setzen-*
.SetInMenu:	tst.l	d7			;InternalPuffer --> Setzen (0)
		bne.w	.ItsAll


	*--------------- Merkzellen setzen -----------*
		movem.l	d0-a6,-(a7)
		move.l	d4,-(a7)

	*--------- Ersten Mod-Eintrag finden ---------*
		moveq	#0,d4			;EPG_Mods
		moveq	#0,d5			;EPG_Dirs
		sub.l	a0,a0
		lea	EPG_FirstFileStruct(a5),a3
		moveq	#0,d6
.SucheNextFile:	move.l	(a3),d0
		beq.s	.SetAdr
		move.l	d0,a3
		moveq	#0,d0
		move.b	EFP_Flags(a3),d0

	*--------- Ist dieser Eintrag ein File ---------*
		btst	#EFPF_FileName,d0
		beq.s	.Suche_NoFile
		tst.l	d6
		bne.s	.Suche_NoFirst
		move.l	a3,a0
		moveq	#1,d6
.Suche_NoFirst:	addq.l	#1,d4
		bra.s	.SucheNextFile

	*--------- Ist dieser Eintrag ein File ---------*
.Suche_NoFile:	btst	#EFPF_DirName,d0
		bne.s	.Suche_DirFound
		btst	#EFPF_Parent,d0
		beq.s	.SucheNextFile
.Suche_DirFound:addq.l	#1,d5
		bra.s	.SucheNextFile

	*--------------- Sachen merken ----------------*
.SetAdr:	move.l	d4,EPG_Mods(a5)
		move.l	d5,EPG_Dirs(a5)
		move.l	a0,FirstModulesEintrag(a5)
		move.w	d6,OnModulesIn(a5)
		move.l	a3,LastModulesEintrag(a5)


		bsr	InsertNoden
		move.l	(a7)+,d0		;Anzahl der Mods

		move.l	d0,EPG_Entries(a5)
		*bsr.w	RefreshModulesMenu
		jsr	A5RefreshMenu(a5)
		movem.l	(a7)+,d0-a6
		tst.l	d4
		beq.s	.FreeMultiPuffer	;--> Keine Mods ???
		move.b	#1,OnMultiSelectIn(a5)
		move.w	#1,OnLoadDirIn(a5)

		move.l	EPG_Entries(a5),d4		;Anzahl der Eintrge
		bra.s	.ItsAll


	*------- Es ist ein Fehler aufgetreten -------*
.OutOfMem:	tst.l	d7
		bne.s	.FreeMultiPuffer
		LA0	LNr_FT32			*LEPR_ErrorLoadingDir
		jsr	A5PrintText(a5)
		moveq	#10,d1
		jsr	A5Delay3(a5)
		bra.w	.SetInMenu		

	*------------ LHA-Fehler aufgetreten -------------*
.FreeLHAPuffer:	move.l	EPG_FirstFileStruct(a5),a0
		move.l	d7,d0
		jsr	A5FreeMultiPuffer(a5)
		moveq	#0,d4
		moveq	#EPR_ErrorinArchive,d0
		bra.s	.ItsAll2

	*------------ Fehler aufgetreten -------------*
.FreeMultiPuffer:move.l	EPG_FirstFileStruct(a5),a0
		move.l	d7,d0
		jsr	A5FreeMultiPuffer(a5)
		moveq	#0,d4

	*-------- Unterroutine verlassen --------*
.ItsAll:	moveq	#EPR_ErrorInArguments,d0
.ItsAll2:	move.l	d4,d1			;Anzahl der Umbauten
		beq.s	.AnError
		moveq	#0,d0
.AnError:	move.l	EPG_FirstFileStruct(a5),a0
		tst.l	d7
		beq.s	.NoChangeFile2
		move.l	(a7),EPG_FirstFileStruct(a5)
.NoChangeFile2:	addq.l	#4,a7
		tst.l	d7
		bne.s	.NoDirCh
		tst.b	OnAbortGadget(a5)
		bne.s	.NoDirCh
		jsr	A5GuiChanged(a5)

	*------------- Engines benachrichten --------------*
		move.l	d0,-(a7)
		moveq	#USClass_NewDirectory,d0
		jsr	A5SendeAllMessage(a5)
		move.l	(a7)+,d0

.NoDirCh:	movem.l	(a7)+,d2-d7/a1-a6
		tst.l	d0
		rts



*----------------------- Noden verknpfen ------------------------------------*
InsertNoden:	sub.l	a2,a2			*fr erste Node
		lea	EPG_FirstFileStruct(a5),a3
.NextNode:	move.l	(a3),d0
		beq.s	.NodenAll
		move.l	d0,a3
		lea	EFP_Node(a3),a1			;Neue Node
		lea	ModulesList(a5),a0
		jsr	A5InsertInList(a5)
		move.l	a1,a2
		bra.s	.NextNode
.NodenAll:	rts




*------- Gibt den belegten Speicher fr den MultiSelectPuffer frei ---------*
*----- Input:	a0 = Adresse des Puffers				----*
*-----		d0 = Internal Puffer = 0				----*
*---------------------------------------------------------------------------*
FreeMultiPuffer:movem.l	d0-a6,-(a7)
		moveq	#0,d4
		move.l	a0,a4
		tst.l	d0
		bne.s	.NoInternal
		jsr	A5FreeDirPuffer(a5)
		bra.s	.ItsAll

	*------- Fremden MultiSpeicher lschen -------*
.NoInternal:	cmp.l	d4,a4
		beq.s	.ItsAll
		move.l	a4,a1
		move.l	EFP_NameDirLock(a1),d1
		beq.s	.NoLock
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOUnLock(a6)
.NoLock:
	*	moveq	#EFP_NamePufferEnd,d0
		move.l	EFP_StructSize(a4),d0
		move.l	a4,a1
		move.l	(a4),a4
		ExecBase
		jsr	_LVOFreeMem(a6)
		bra.s	.NoInternal


.ItsAll:	movem.l	(a7)+,d0-a6
		rts

****************************************************************************
* Zusatzprogramme fr Pysionloading



*-----------------------------------------------------------------------------*
* Input: a0/d0=Liste im Speicher
* Output:d1=Listtype oder NULL
*	 d2=Position in der Liste
*-----------------------------------------------------------------------------*
Py_CheckListType:
		movem.l	d0/d3-a6,-(a7)
		moveq	#0,d2
		tst.l	d0
		beq.w	.Return
		cmp.l	#8,d0			;Size zu klein
		blt.w	.Return
		move.l	a0,d0
		beq.w	.Return

		*--- Auf Eagleplayerliste testen --*
		cmp.l	#"EP-L",(a0)
		bne.s	.NoEPList
		cmp.l	#"IST"<<8!10,4(a0)
		bne.s	.NoEPList
		moveq	#8,d2
		moveq	#LTY_Eagleplayer,d1
		*clr.b	EPInsertEntryType(a5)
		bra.w	.Return

		*--- Auf Delitrackerliste testen --*
.NoEPList:	cmp.l	#"MODL",(a0)
		bne.s	.NoDTList
		cmp.l	#"IST"<<8!10,4(a0)
		bne.s	.NoDTList
		moveq	#8,d2
		moveq	#LTY_Delitracker,d1
		bra.w	.Return

		*---- AccessiblePlayer ----*
.NoDTList:	cmp.l	#"@*Ap",(a0)
		bne.s	.NoAPlayer
		cmp.l	#"ML*@",4(a0)
		bne.s	.NoAPlayer
		moveq	#8,d2
.APlayerNext:	addq.l	#1,d2
		move.b	(a0,d2.w),d0
		beq.w	.UnknownType
		cmp.b	#"@",d0
		bne.s	.APlayerNext
		moveq	#LTY_APlayer,d1
		bra.w	.Return

		*--- Bananaplay ----*
.NoAPlayer:	cmp.l	#"BP20",(a0)
		bne.s	.NoBananaPlayer
		cmp.l	#"LIST",4(a0)
		bne.s	.NoBananaPlayer
		move.l	#$74,d2
		moveq	#LTY_BananaPlay,d1
		bra.w	.Return

		*--- Hippoplayer ----*
.NoBananaPlayer:cmp.l	#"HIPP",(a0)
		bne.s	.NoHippoplayer
		cmp.w	#$524f,4(a0)
		bne.s	.NoHippoplayer
		tst.b	8(a0)
		bne.s	.NoHippoplayer
		move.l	#$9,d2
		moveq	#LTY_Hippoplayer,d1
		bra.s	.Return

		*--- Empy + Multiplayer ---*
.NoHippoplayer:	cmp.l	#"PROG",(a0)
		bne.s	.NoEmpy
		cmp.l	#"RAM"<<8!10,4(a0)
		bne.s	.NoEmpy
		move.l	#$8,d2
		moveq	#LTY_Empy,d1
		bra.s	.Return

		*--- Smartplay ---*
.NoEmpy:	cmp.l	#"SPP2",(a0)
		bne.s	.NoSSP
		cmp.w	#$2000,4(a0)
		bne.s	.NoSSP
		move.l	#$6,d2
		moveq	#LTY_Smartplay,d1
		bra.s	.Return

		*--- MELGU ---*
.NoSSP:		cmp.l	#"EPLS",(a0)
		bne.s	.NoMELGU
		moveq	#8,d2
		moveq	#LTY_MELGU,d1
		bra.s	.Return

		*--- DASMod ---*
.NoMELGU:	cmp.l	#"DASP",(a0)
		bne.s	.NoDasM
		cmp.l	#"MODL",4(a0)
		bne.s	.NoDasM
		moveq	#$C,d2
		moveq	#LTY_DASMod,d1
		bra.s	.Return

		*--- Unknown List ---*
.NoDasM:

.UnknownType:	moveq	#0,d2
		moveq	#0,d1

.Return:	movem.l	(a7)+,d0/d3-a6
		tst.l	d1
		rts


*-----------------------------------------------------------------------------*
* Input: d0/a0=Memdaten der Liste
*	 d1=Type der Liste
*	 d2=Position
* Output:d0=Error(-1) oder NULL Ende=1
*	 d2=neue Position
*	 a1=Pfad des Eintrages
*	 a3=ModulesPrefs oder NULL
*-----------------------------------------------------------------------------*
Py_GetNextItemFromList:
*** a4!!!
		movem.l	d1/d3-d7/a0/a2/a4/a5-a6,-(a7)
		sub.l	a1,a1
		sub.l	a3,a3
		sub.l	a4,a4
		cmp.l	#LTY_Eagleplayer,d1
		beq.w	.Eagleplayer
		cmp.l	#LTY_DeliTracker,d1
		beq.w	.DeliTracker
		cmp.l	#LTY_APlayer,d1
		beq.w	.APlayer
		cmp.l	#LTY_BananaPlay,d1
		beq.w	.BananaPlay
		cmp.l	#LTY_Hippoplayer,d1
		beq.w	.Hippoplayer
		cmp.l	#LTY_Empy,d1
		beq.w	.Empy
		cmp.l	#LTY_Smartplay,d1
		beq.w	.Smartplay
		cmp.l	#LTY_MELGU,d1
		beq.w	.MELGU
		cmp.l	#LTY_DASMod,d1
		beq.s	.DasMod
		moveq	#-1,d0
		bra.w	.Return



		*----- DASMod -----*
.DASMod:	cmp.l	d0,d2
		bhs.w	.Ende
		lea	(a0,d2.l),a0		*Anfang der Structure
***		lea	$70(a0),a1
***		move.l	a0,-(a7)
***		lea	Unknown(pc),a0
***		bsr	StrCMP
***		beq.s	.DASKeinAuthor
***		lea	-3(a1),a3
***		move.b	#"9",-3(a3)
***		move.b	#"6",-2(a3)
***		move.b	#"=",-1(a3)
***.DASKeinAuthor:	move.l	(a7)+,a0
		lea	$82(a0),a1
		bsr	Py_ReadLong
		add.l	d0,d2
		add.l	#$86,d2
		lea	4(a1),a1		*Pfad
		moveq	#0,d0
		bra.w	.KeineModPrefs


		*---- MELGU -----*
.MELGU:		cmp.l	d0,d2
		bhs.w	.Ende

		moveq	#0,d0
		lea	6(a0,d2.l),a0
		move.l	a0,a1
		jsr	A5BerechStringSize(a5)
		add.l	d0,d2
		addq.l	#8,d2
		clr.b	(a1,d0.l)
		lea	1(a0,d0.w),a0
		jsr	A5BerechStringSize(a5)
		add.l	d0,d2			*Lnge des Commentars
		moveq	#0,d0
		bra.w	.KeineModPrefs



		*--------- Smartplay --------*
.Smartplay:	cmp.l	d0,d2
		bhs.w	.Ende
		lea	(a0,d2.l),a1
		add.l	#$ca,d2
		sub.l	a3,a3
		bra.w	.KeineModPrefs


		*---------- Empy ------------*
.Empy:		cmp.l	d0,d2
		bhs.w	.Ende
		lea	(a0,d2.l),a1
		cmp.b	#9,(a1)
		bne.s	.No9
		addq.l	#3,d2
		bra.s	.Empy
.No9:		bsr	Py_ReadLong
		cmp.l	#"DIR ",d0
		bne.s	.NoDir
		addq.l	#4,d2
		move.l	a0,a3
		lea	(a0,d2.l),a0
		bsr	Py_BerechStringSize2
		tst.l	d0
		beq.w	.Error
		move.l	d0,d1
		add.l	d0,d2
		addq.l	#1,d2				*Enter
		subq.l	#1,d1
		lea	PathPuffer(a5),a1
		jsr	A5StringCopy2(a5)
		lea	PathPuffer(a5),a1
		jsr	A5MakeCorrectDir(a5)
		move.l	a3,a0

.NoDir:		lea	(a0,d2.l),a0
		lea	PathPuffer(a5),a1
		jsr	A5GetFileName(a5)
		clr.b	(a1)
		bsr	Py_BerechStringsize2
		beq.w	.Error
		move.l	d0,d1
		add.l	d0,d2
		addq.l	#1,d2				*Enter
		subq.l	#1,d1
		jsr	A5StringCopy2(a5)
		sub.l	a3,a3
		lea	PathPuffer(a5),a1
		bra.w	.KeineModPrefs

		*-------- Hippoplayer -------*
.Hippoplayer:	cmp.l	d0,d2
		bhs.w	.Ende
		lea	(a0,d2.l),a1
		moveq	#0,d1
		move.b	(a1)+,d1
		beq.w	.Error
		add.l	d1,d2
		addq.l	#2,d2
		sub.l	a3,a3
		bra.w	.KeineModPrefs


		*------- Bananaplay --------*
.BananaPlay:	lea	(a0,d2.l),a0
		bsr	Py_BerechStringSize2
		beq.w	.Ende
		move.l	a0,a1
		sub.l	a3,a3
		add.l	d0,d2
		add.l	#(9*4)+2,d2		; 9*4 Infos 1=Leerkennung
		bclr	#0,d2			; + 1 zum gerademachen
		bra.w	.KeineModPrefs


		*-------- APlayer --------*
.APlayer:	subq.l	#1,d2
.APlayerNext:	addq.l	#1,d2
		move.b	(a0,d2.l),d0
		beq.w	.Ende
		cmp.b	#"@",d0
		beq.s	.a_NewPath
		cmp.b	#10,d0
		beq.s	.APlayerNext
		bra.w	.NormalName

.A_NewPath:	lea	(a0,d2.l),a1
		bsr	Py_ReadLong
		cmp.l	#"@*Pa",d0
		bne.s	.A_NoNewPath
		addq.l	#4,a1
		bsr	Py_ReadLong
		cmp.l	#"th*@",d0
		bne.s	.A_NoNewPath

		*-- neuer Pfad --*
		cmp.b	#10,4(a1)
		bne.w	.Error
		add.l	#9,d2

		move.l	a0,-(a7)
		lea	(a0,d2.l),a0
		bsr	Py_BerechStringSize2
		move.l	(a7)+,a0
		tst.l	d0
		beq.w	.Error
		move.l	d0,d1
		subq.l	#1,d1
		movem.l	d0/a0,-(a7)
		lea	PathPuffer(a5),a1
		lea	(a0,d2.l),a0
		jsr	A5StringCopy2(a5)
		lea	PathPuffer(a5),a1
		jsr	A5MakeCorrectDir(a5)
		movem.l	(a7)+,d0/a0
		add.l	d0,d2
		bra.s	.APlayerNext

.A_NoNewPath:	lea	(a0,d2.l),a1
		bsr	Py_ReadLong
		cmp.l	#"@*Na",d0
		bne.s	.NormalName
		addq.l	#4,a1
		bsr	Py_ReadLong
		cmp.l	#"mes*",d0
		bne.s	.NormalName
		cmp.b	#"@",4(a1)
		bne.w	.Error
		cmp.b	#10,5(a1)
		bne.w	.Error
		add.l	#10,d2
		bra.s	.Normal2

.NormalName:	lea	PathPuffer(a5),a1
		jsr	A5GetFileName(a5)
		clr.b	(a1)
.Normal2:	lea	(a0,d2.l),a0
		bsr	Py_BerechStringSize2
		beq.w	.Error
		movem.l	d0/a0,-(a7)
		lea	PathPuffer(a5),a0
		jsr	A5BerechStringSize(a5)
		lea	(a0,d0.l),a1
		movem.l	(a7)+,d0/a0
		add.l	d0,d2
		move.l	d0,d1
		subq.l	#1,d1
		jsr	A5StringCopy2(a5)

		lea	PathPuffer(a5),a1
		sub.l	a3,a3
		bra.w	.KeineModPrefs

		*******************************************
		*--- Jetzt original Routine aus Pysion ---*
		*--- bis auf Py_ Labelvorstze
		*******************************************
.DeliTracker:
.Eagleplayer:	cmp.l	d0,d2
		bhs.w	.Ende
		move.l	d0,d4
		cmp.l	#0,a0
		beq.w	.Ende
		add.l	d2,a0
.EP_EineZeile2:	cmp.b	#10,(a0)
		beq.s	.EP_EineZeile
		bsr	Py_BerechStringSize2
		beq.w	.Error

	*--- Auf Gruppen/Autorenprefs achten ---*
		cmp.l	#4,d0
		blo.w	.EP_NoAG
		move.l	a0,a1
		move.l	d0,d1
		bsr	Py_ReadLong
		exg	d0,d1
		cmp.l	#"@GRO",d1
		beq.w	.EP_Gruppen
		cmp.l	#"@AUT",d1
		bne.w	.EP_NoAG
***		lea	Autorlist+AGL_List(a5),a4
		bra.s	.EP_AG

.EP_EineZeile:	addq.l	#1,a0
		addq.l	#1,d2
		bra.s	.EP_EineZeile2

	*- Input:a0=Zeilenstart
	*-	 d0=Lnge des Strings
	*Output: d0=Error(-1) oder NULL Ende=1
	*	 d2=neue Position
	*	 a1=Pfad des Eintrages
	*	 a3=ModulesPrefs oder NULL
.EP_Gruppen:
***		lea	Gruppenlist+AGL_List(a5),a4
.EP_AG:		sub.l	d2,a0			;Start
		add.l	d0,d2
		addq.l	#1,d2			;enter nach @GROUPS

.EP_OtherNext:	move.l	a0,-(a7)
		cmp.l	d4,d2
		bhs.w	.EP_AGEnd
		cmp.l	#0,a0
		beq.w	.EP_AGEnd
		lea	(a0,d2.l),a1
		bsr	Py_ReadLong
		cmp.l	#"@END",d0
		beq.s	.EP_AGEnd
		lea	(a0,d2.l),a0
		bsr	Py_BerechStringSize2
		beq.w	.EP_AGEnd2
		move.l	a4,-(a7)
		bsr	Py_EPNextEntry
		move.l	a4,d1
		move.l	(a7)+,a4
		move.l	d0,-(a7)
		bne.s	.EPG_Next
		move.l	a1,a0
***		bsr	AG_InsertItem
***		tst.l	d0
***		beq.s	.EPG_Next
***		lea	AGS_MEStruct(a0),a6
***		move.l	a4,-(a7)
***		move.l	d1,a4
***		bsr	InsertModulesPrefs
***		move.l	(a7)+,a4
.EPG_Next:	move.l	(a7)+,d0
		move.l	(a7)+,a0
		tst.l	d0
		bne.s	.Ende2
		bra.s	.EP_OtherNext

.EP_AGEnd:	lea	(a0,d2.l),a0
		addq.l	#1,d2			;Enter nach @END
.EP_AGEnd2:	bsr	Py_BerechStringSize2
		add.l	d0,d2
		move.l	d4,d0
		move.l	(a7)+,a0
		bra.w	.Eagleplayer


	*a0=Adr des Stings
	*d0=Lnge des Strings
.EP_NoAG:	bsr	Py_EPNextEntry
		bra.s	.return

.KeineModPrefs:	moveq	#0,d0
		bra.s	.Return

.Error:		moveq	#-1,d0
		bra.s	.Ende2

		*--- keine weiteren Eintrge ---*
.Ende:		moveq	#1,d0
.Ende2:		sub.l	a1,a1
		sub.l	a3,a3

.Return:	movem.l	(a7)+,d1/d3-d7/a0/a2/a4/a5-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: a0=Start der Zeile
*	 d0=Lnge des Strings (Entry/Gruppe/Autor)
* Output:d0=Error(-1) oder NULL Ende=1
*	 d2=neue Position
*	 a1=Pfad des Eintrages
*	 a3=ModulesPrefs oder NULL
*	 a4=Moduleseigenschaften
*-----------------------------------------------------------------------------*
Py_EPNextEntry:	movem.l	d1/d3-d7/a0/a2/a5-a6,-(a7)
		sub.l	a4,a4
		sub.l	a3,a3

		move.b	(a0,d0.w),d3
		clr.b	(a0,d0.w)
		add.l	d0,d2
		addq.l	#1,d2
		move.l	a0,a1

		cmp.b	#10,d3				*Kennung kein ModPrefs
		beq.w	.KeineModPrefs

		cmp.b	#"'",d3
		beq.s	.Ja
		cmp.b	#'"',d3
		beq.s	.Ja
		cmp.b	#"`",d3
		bne.s	.Normal
.Ja:		addq.l	#1,d2				*Ganse adden
		addq.l	#1,a0

		*-- Ist noch soviel Platz in der Datei ?
.Normal:	move.l	d2,d3
		addq.l	#4,d3
		cmp.l	d4,d3
		bhs.s	.KeineModPrefs

		addq.l	#1,d2				*Leerzeichen
		lea	1(a0,d0.l),a0			*Start of Prefs
		cmp.b	#"M",(a0)
		bne.s	.CheckEigen
		cmp.b	#"P",1(a0)
		bne.s	.CheckEigen
		cmp.b	#":",2(a0)
		bne.s	.CheckEigen
		addq.l	#3,a0
		move.l	a0,-(a7)
		bsr	Py_BerechStringSize3
		clr.b	(a0,d0.l)
		move.l	a0,a3
		move.l	(a7)+,a0
		add.l	d1,d2
		addq.l	#4,d2			;Leerzeichen,MP:


		move.l	d2,d3
		addq.l	#4,d3
		cmp.l	d4,d3
		bhs.s	.KeineModPrefs

		lea	1(a0,d1.l),a0			*Start of Prefs
.CheckEigen:	cmp.b	#"M",(a0)
		bne.s	.KeineModPrefs
		cmp.b	#"E",1(a0)
		bne.s	.KeineModPrefs
		cmp.b	#":",2(a0)
		bne.s	.KeineModPrefs

		addq.l	#3,a0
		bsr	Py_BerechStringSize3
		clr.b	(a0,d0.l)
		move.l	a0,a4
		add.l	d1,d2			;Size mit Ganse
		addq.l	#4,d2			;Leerzeichen,MP
.KeineModPrefs:	moveq	#0,d0
		movem.l	(a7)+,d1/d3-d7/a0/a2/a5-a6
		tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Input: a1=Adresse
* Output:d0=Longinhalt ab a1
*-----------------------------------------------------------------------------*
Py_ReadLong:	move.b	(a1),d0
		lsl.l	#8,d0
		move.b	1(a1),d0
		lsl.l	#8,d0
		move.b	2(a1),d0
		lsl.l	#8,d0
		move.b	3(a1),d0
		tst.l	d0
		rts


*----------------------------------------------------------------------------*
* Berechnet die Stringlnge und setzt den Anfang korrect.
* Sucht bis Zeichen kommen <20 oder bis die Ganse, die am Anfang stehen mssen
* zuende sind.
* Input: a0=Stringanfang
* Output:d0=StringSize oder NULL
*	 a0=neue Startadresse des Strings
*----------------------------------------------------------------------------*
Py_BerechStringSize2:movem.l a0/d1/d2,-(a7)
		moveq	#0,d0
		cmp.l	d0,a0
		beq.s	.NoTest

		moveq	#-1,d0
		moveq	#'"',d1
		cmp.b	(a0),d1
		beq.s	.ja
		moveq	#"'",d1
		cmp.b	(a0),d1
		beq.s	.ja
		moveq	#"`",d1
		cmp.b	(a0),d1
		beq.s	.ja
		moveq	#0,d1
		bra.s	.NextB
.Ja:		addq.l	#1,a0
.NextB:		addq.l	#1,d0
		move.b	(a0)+,d2
		beq.s	.NoTest
		cmp.b	d2,d1
		beq.s	.GanseTest
		cmp.b	#32,d2
		bhs.s	.NextB
.NoTest:	movem.l	(a7)+,d1/d2/a0
		tst.l	d0
		rts

.GanseTest:	movem.l	(a7)+,d1/d2/a0
		addq.l	#1,a0
		tst.l	d0
		rts

*----------------------------------------------------------------------------*
* Berechnet die Stringlnge und setzt den Anfang korrect.
* Sucht Ende dieses Strings Ganse drfen auch innerhalb auftreten.
* Input: a0=Stringanfang
* Output:d0=StringSize oder NULL "L"=1 l=1
*	 d1=Size des Strings "L"=3 l=1
*	 a0=neue Startadresse des Strings
*----------------------------------------------------------------------------*
Py_BerechStringSize3:
		movem.l a0/d2-d3,-(a7)
		moveq	#-1,d1
		moveq	#0,d0
		cmp.l	d0,a0
		beq.s	.Return

		moveq	#-1,d0
		moveq	#'"',d3
		cmp.b	(a0),d3
		beq.s	.Ganse
		moveq	#"'",d3
		cmp.b	(a0),d3
		beq.s	.Ganse
		moveq	#"`",d3
		cmp.b	(a0),d3
		beq.s	.Ganse
		moveq	#0,d3
		bra.s	.NoGanse
.Ganse:		addq.l	#1,a0
		addq.l	#1,d1
.NoGanse:	bsr	.Berech

		tst.b	d3
		beq.s	.Return

		movem.l	(a7)+,d2-d3/a0
		addq.l	#1,a0
		addq.l	#1,d1
		tst.l	d0
		rts

.Return:	movem.l	(a7)+,d2-d3/a0
		tst.l	d0
		rts

* Input: d0=Zhler
*	 d3=Gansekenn
.Berech:	addq.l	#1,d0
		addq.l	#1,d1
		move.b	(a0)+,d2
		beq.s	.NoTest
		cmp.b	d2,d3
		beq.s	.NoTest		;GanseTest

		cmp.b	#'"',d2
		beq.s	.ja
		cmp.b	#"'",d2
		beq.s	.ja
		cmp.b	#"`",d2
		beq.s	.Ja
		tst.b	d3
		bne.s	.Berech
		cmp.b	#32,d2
		bhi.s	.Berech
		bra.s	.Notest

.Ja:		move.l	d3,-(a7)
		move.l	d2,d3
		bsr	.Berech
		move.l	(a7)+,d3
		*tst.b	d3
		*beq.s	.NoTest
		bra.s	.Berech
		*tst.b	d2
		*beq.s	.Error		?

.NoTest		tst.l	d0
		rts


*---------------------------------------------------------------------------*
; STRUCTURE EPDIR,0
;	LONG	EPD_EPVersion		;min. Eagleplayerversion
;	LONG	EPD_Dirs		;Anz der Dirs
;	LONG	EPD_Files		;Anz der Files
;	LONG	EPD_FirstDir		;Offset to FirstDirname-EPDIR
;	LONG	EPD_FirstFile		;Offset to FirstFileName-EPDIR
;	LONG	EPD_Flags		;Flags zum EPDir
;	LABEL	EPD_SIZEOF
;
;EPDF_HideAll		EQU	1
;EPDF_ShowDirNames	EQU	2
;

*------------------------ Speichere ein EP-Directory ab -------------------*
SaveEPDir:	movem.l	d0-a6,-(a7)
		tst.b	OnEPDir(a5)
		beq.w	.Return
		move.l	EPG_Entries(a5),d3
		tst.l	d3
		ble.w	.Return


	*----- Datentrger schreibgeschtzt ? -----*
		moveq	#0,d5
		lea	Dirpuffer(a5),a0
		move.l	a0,d1
		move.l	DTG_Dosbase(a5),a6
		moveq	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,d4
		beq.s	.Weiter
		move.l	d4,d1
		lea	TextPuffer(a5),a0
		move.l	a0,d2
		jsr	_LVOInfo(a6)
		tst.l	d0
		beq.s	.WPUnLock
		cmp.l	#80,TextPuffer+8(a5)
		bne.s	.WPUnLock
		moveq	#1,d5
.WPUnLock:	move.l	d4,d1
		jsr	_LVOUnLock(a6)
		tst.l	d5
		bne.w	.Return		


	*---------- Anzahl der Dirs ausrechnen ----------*
.Weiter:	subq.l	#1,d3
		moveq	#0,d4				;File-Anzahl
		moveq	#0,d5				;Dir-Anzahl
		lea	EPG_FirstFileStruct(a5),a3
.TestNext2:	move.l	(a3),d0
		beq.w	.Return
		move.l	d0,a3
		moveq	#0,d0
		move.b	EFP_Flags(a3),d0
		btst	#EFPF_Filename,d0
		beq.s	.TestDir
		addq.l	#1,d4				;FileAnz +1
		bra.s	.NextTest
.TestDir:	btst	#EFPF_DirName,d0
		beq.s	.NextTest
		addq.l	#1,d5				;DirAnz +1
.NextTest:	dbf	d3,.TestNext2


		move.l	d4,d3
		add.l	d5,d3
		move.l	d3,d0
		tst.b	OnLHAInMenu(a5)
		bne.s	.LHAIn
		mulu	#Namenlange+1,d0		;Size fr alle Namen
		bra.s	.SizeIsOk

.LHAIn:		mulu	#DirPufferSize,d0			;fr LHA

.SizeIsOk:	moveq	#EPD_SizeOf,d6
		add.l	d6,d0
		move.l	d0,EPDir_SMemSize(a5)
		jsr	A5AllocMem(a5)
		move.l	d0,a4
		beq.w	.Return
		move.l	a4,EPDir_SMemAdr(a5)
		move.l	#"EAGL",(a4)
		move.l	#"EDIR",4(a4)

		moveq	#EagleVersion,d0			;Eagleversion
		move.l	d0,EPD_EPVersion(a4)
		move.l	d4,EPD_Files(a4)
		move.l	d5,EPD_Dirs(a4)
		move.l	d6,EPD_FirstDir(a4)

		move.w	#EPDT_Directory,EPD_Type(a4)
		tst.b	OnLHAInMenu(a5)
		beq.s	.SaveNoLHA
		move.w	#EPDT_LHAArchive,EPD_Type(a4)
.SaveNoLHA:


		lea	DiskInfoBlock+132(a5),a1
		lea	EPD_Special1(a4),a0
		move.l	(a1)+,(a0)+
		move.l	(a1)+,(a0)+
		move.l	(a1)+,(a0)+



		moveq	#0,d0
		tst.b	OnHideAll(a5)
		beq.s	.NoHideAll
		moveq	#EPDB_HideAll,d0
.NoHideAll:	tst.b	OnShowDirNames(a5)
		beq.s	.NoShow
		or.b	#EPDB_ShowDirNames,d0
.NoShow:	move.l	d0,EPD_Flags(a4)

	*--------- Dirs in Puffer setzen --------*
		add.l	d6,a4
		lea	EPG_FirstFileStruct(a5),a3
		move.l	(a3),a2
		moveq	#0,d0
		move.b	EFP_Flags(a2),d0
		btst	#EFPF_Parent,d0
		beq.s	.NoParent
		move.l	a2,a3

	*--------- Dirs in Puffer setzen --------*
.NoParent:	subq.l	#1,d5
		blt.s	.NoDirs
		bsr.w	FillEPDirPuffer
		tst.l	(a3)
		beq.s	.NoFiles
		moveq	#EPD_SizeOf,d6
		bra.s	.SetDirs

	*-------- Files in Puffer setzen --------*
.NoDirs:	moveq	#0,d6
.SetDirs:	move.l	d4,d5
		subq.l	#1,d5
		move.l	a4,a0
		move.l	EPDIR_SMemAdr(a5),a2
		sub.l	a2,a0
		move.l	a0,EPD_FirstFile(a2)		;Offset zu first Files
		move.l	d6,EPD_FirstDir(a2)		;Dir Offset ok ????
		bsr.w	FillEPDirPuffer


	*------------- Jetzt EPDir saven -------------*
	*------------------- Save Mem to Disk ----------------------*
	*---- ARG1 = StartAdr					----*
	*---- ARG2 = Lnge					----*
	*---- ARG3 = PathAdr					----*
	*---- ARG4 = CrunchMode					----*
	*---- ARG5 = Flags					----*
.NoFiles:	move.l	EPDir_SMemAdr(a5),EPG_Arg1(a5)
		sub.l	EPDir_SMemAdr(a5),a4
		move.l	a4,EPG_Arg2(a5)

	;***********************************
	;****	Pfad aufbauen		****
	;**** LoadFilePath=Diradresse	****
	;**** a2=Filename		****
		tst.b	OnLHAInMenu(a5)
		beq.s	.NormalEPDir
		move.l	EPDir_Ptr(a5),a0
		lea	PathPuffer(a5),a1
		move.w	#DirPufferSize-2,d1
		jsr	A5StringCopy2(a5)
		lea	PathPuffer(a5),a0
		jsr	A5ParentArchiveDir(a5)
		beq.s	.ItsOk
		lea	PathPuffer(a5),a0
		jsr	A5BerechStringSize(a5)
		move.l	d0,d1
.ItsOk:		cmp.b	#24,d1
		blo.s	.CopyDran
		moveq	#24,d1
.CopyDran:	lea	1(a0,d1.w),a1
		LA0	LNr_EPDirName
		jsr	A5StringCopy(a5)
		bra.s	.SaveItEPDir

.NormalEPDir:	move.l	EPDir_Ptr(a5),a0
		move.l	a0,LoadFilePath(a5)
		LA2	LNr_EPDirName
		jsr	A5CreateLoadPath(a5)

.SaveItEPDir:	lea	PathPuffer(a5),a0
		move.l	a0,EPG_Arg3(a5)
		moveq	#5,d0
		move.l	d0,EPG_ArgN(a5)
		moveq	#3,d0
		move.l	d0,EPG_Arg5(a5)			;Flags
		clr.l	EPG_Arg4(a5)			;not crunched
		move.l	EPG_SaveMem(a5),a0
		jsr	(a0)

	*------- Eventuell Message vom Notify-Port holen -------*
		tst.w	Kick2On(a5)
		beq.s	.NoNotify
		move.l	NotifyPort(a5),d0
		beq.s	.NoNotify
		move.l	d0,a0
		ExecBase
		jsr	_LVOGetMsg(a6)
		tst.l	d0
		beq.w	.NoNotify
		jsr	A5CopyMessage(a5)

	*- Kennung im DiskInfoBlock setzen, da dies nun das aktuelle -*
	*---------------------- Verzeichnis ist -----------------------*
.NoNotify:	move.l	EPDir_Ptr(a5),d1
		move.l	DTG_Dosbase(a5),a6
		moveq	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,d7			;lock nach d7
		beq.w	.FreeEPMem
		lea	DiskInfoBlock(a5),a0
		move.l	a0,d2
		move.l	d7,d1			;Error beim Lock holen
		jsr	_LVOExamine(a6)
		move.l	d7,d1
		jsr	_LVOUnLock(a6)


	*------------- EP-Mem freigeben ------------*
.FreeEPMem:	move.l	EPDir_SMemAdr(a5),d0
		beq.s	.Hoppla
		move.l	d0,a1
		move.l	EPDir_SMemSize(a5),d0
		beq.s	.Hoppla
		ExecBase
		jsr	_LVOFreeMem(a6)
.Hoppla:	clr.l	EPDir_SMemAdr(a5)
		clr.l	EPDir_SMemSize(a5)
.Return:	movem.l	(a7)+,d0-a6
		rts


	*--- Schleife zum Zusammmenbauen des Dirs ----*
FillEPDirPuffer:move.l	(a3),d0
		beq.w	.FreeEPMem
		move.l	d0,a3
		lea	EFP_Namepuffer(a3),a0
		move.l	a4,a2
		addq.l	#1,a4

	*-------- Lnge eines Namens berechnen -------*
		moveq	#-1,d0
		moveq	#Namenlange,d2
		tst.b	OnLHAInMenu(a5)
		beq.s	.NextB
		move.w	#DirPufferSize-2,d2
.NextB:		addq.l	#1,d0
		move.b	(a0)+,d1
		move.b	d1,(a4)+
		beq.s	.Stop
		dbf	d2,.NextB
.Stop:		subq.l	#1,a4
		;cmp.w	#Namenlange,d0			;Zu lang ???
		;bhi.s	.FreeEPMem
		move.b	d0,(a2)				;Size merken

	*------------ Noch mehr Eintrge -------------*
		dbf	d5,FillEPDirPuffer
.FreeEPMem:	rts


*-----------------------------------------------------------------------------*
*------------------------ Lade ein Eagleplayer-Dir ein -----------------------*
*------------ d1 = Mode  0=Directory					------*
*------------		 1=LHA-Archiv					------*
*-----------------------------------------------------------------------------*
LoadEPDir:	movem.l	d1-a6,-(a7)
		moveq	#EPR_FunctionAborted,d0
		tst.b	OnEPDir(a5)
		beq.w	.Error
		move.l	d1,d6
		beq.s	.NormalEPDir
		move.l	EPDir_Ptr(a5),a0
		lea	PathPuffer(a5),a1
		move.w	#PathPufferSize-2,d1
		jsr	A5StringCopy2(a5)
		lea	PathPuffer(a5),a0
		jsr	A5ParentArchiveDir(a5)
		beq.s	.ItsOk
		lea	PathPuffer(a5),a0
		jsr	A5BerechStringSize(a5)
		move.l	d0,d1
.ItsOK:		cmp.b	#24,d1
		blo.s	.CopyDran
		moveq	#24,d1
.CopyDran:	lea	1(a0,d1.w),a1
		LA0	LNr_EPDirName
		jsr	A5StringCopy(a5)
		moveq	#1,d0
		moveq	#15,d1
		lea	PathPuffer(a5),a1
		lea	DiskInfoBlock+8(a5),a2
		bra.s	.LoadItEPDir


.NormalEPDir:	moveq	#1,d0				;Mem
		moveq	#7,d1				;LoadFileBytes
		LA2	LNr_EPDirName
		move.l	EPDIr_Ptr(a5),a1
.LoadItEPDir:	movem.l	d1-a6,-(a7)
		jsr	A5LoadFile(a5)
		movem.l	(a7)+,d1-a6
		tst.l	d0
		bne.w	.Error

		tst.l	d6
		beq.s	.NormalDir
		move.l	File(a5),a0
		cmp.l	#11,EPD_EPVersion(a0)
		blo.w	.FreeEPMem
		lea	DiskInfoBlock+132(a5),a1
		lea	EPD_Special1(a0),a0

		cmpm.l	(a1)+,(a0)+
		bne.w	.FreeEPMem
		cmpm.l	(a1)+,(a0)+
		bne.w	.FreeEPMem
		cmpm.l	(a1)+,(a0)+
		bne.w	.FreeEPMem
		bra.s	.EPLHADir

.NormalDir:	lea	InfoBlock+132(a5),a0
		lea	DiskInfoBlock+132(a5),a1
		cmpm.l	(a0)+,(a1)+
		bne.w	.FreeEPMem
		cmpm.l	(a0)+,(a1)+
		bne.w	.FreeEPMem
		move.l	(a0),d0			;Sekunden von ".EPDIR"
		move.l	(a1),d1			;Sekunden vom Dir
		cmp.l	d0,d1
		bhi.w	.FreeEPMem
		moveq	#$30,d2
		add.l	d2,d1
		cmp.l	d0,d1
		blo.w	.FreeEPMem
		
	*------ Stimmt die Kennung ------*
.EPLHADir:	move.l	File(a5),a0
		cmp.l	#"EAGL",(a0)
		bne.w	.FreeEPMem
		cmp.l	#"EDIR",4(a0)
		bne.w	.FreeEPMem

		cmp.l	#EagleVersion,EPD_EPVersion(a0)
		bhi.w	.FreeEPMem

	*-------- Ist das Dir mit HideAll gespeichert worden -------*
		tst.b	OnHideAll(a5)		;0=Ja
		bne.s	.OhneHidegesaved
		btst	#EPDF_HideAll,EPD_Flags+3(a0)
		bne.w	.FreeEPMem
		bra.s	.NoHideTest

.OhneHidegesaved:
		btst	#EPDF_HideAll,EPD_Flags+3(a0)
		beq.w	.FreeEPMem


	*-------- Ist das Dir mit ShowDirNames gespeichert worden -------*
.NoHideTest:	tst.b	OnShowDirNames(a5)		;0=Ja
		beq.s	.NoShowTest
		btst	#EPDF_ShowDirNames,EPD_Flags+3(a0)
		beq.w	.FreeEPMem

.NoShowTest:	move.l	EPD_Files(a0),EPDir_Files(a5)
		move.l	EPD_Dirs(a0),EPDir_Dirs(a5)
		move.l	EPD_Files(a0),d5
		add.l	EPD_Dirs(a0),d5
		blt.w	.FreeEPMem


	*--------------------- Kein Abort-Gadget --------------------*
		movem.l	a0/d5,-(a7)
		jsr	A5WaitMouse(a5)
		jsr	A5RemoveAbortGadget(a5)
		jsr	A5ClearTextWindow(a5)

	*--- Schrift ausgeben "Loading ..." --*
		lea	DiskInfoBlock+8(a5),a0
		move.l	a0,ScrollArgs(a5)
		LA0	LNr_Scanning
		jsr	A5PrintText(a5)
		movem.l	(a7)+,a0/d5

	*------ Puffer fr Pull-Down-Menu creieren und setzen -------*
		moveq	#13,d0				;Mode EPDir
		move.l	EPD_Flags(a0),d1		;Flags laden
		moveq	#0,d2				;Internal Puffer
		tst.l	EPD_FirstDir(a0)
		bne.s	.UseDirOffs
		add.l	EPD_FirstFile(a0),a0
		bra.s	.UseFileOffs
.UseDirOffs:	add.l	EPD_FirstDir(a0),a0
.UseFileOffs:	sub.l	a1,a1
		jsr	A5CreateFilesPuffer(a5)

.ReturnEP:	move.l	d0,-(a7)
		move.l	File(a5),d0
		beq.s	.Hoppla
		move.l	d0,a1
		move.l	FileSizeNeu(a5),d0
		beq.s	.Hoppla
		ExecBase
		jsr	_LVOFreeMem(a6)
.Hoppla:	clr.l	File(a5)
		clr.l	FileSizeNeu(a5)
		move.l	(a7)+,d0

		clr.b	OnMultiSelectIn(a5)
.Error:		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

.FreeEPMem:	moveq	#EPR_ErrorInArguments,d0
		bra.s	.ReturnEP



*---------------- Soll eine MSG vom Abortgadget geholt werden ---------------*
TestDirAbortMsg:subq.w	#1,AbortTimer(a5)
		bne.s	.NoThisTime
		move.w	AbortTimes(a5),AbortTimer(a5)
		jmp	A5GetAbortMsg(a5)

.NoThisTime:	moveq	#0,d0
		rts



	;************************************
	;**** Bestimme die Fehlermeldung ****
	;************************************
IOErr:		move.l	DTG_Dosbase(a5),a6
		jmp	_LVOIoErr(a6)

	*--------- Printe Dos-Error-Meldung ins kleine Window ---------*
*SetErrorText:	jsr	A5IoErr(a5)
*		lea	IIoErr+14(pc),a0
*		jsr	A5Hexdez(a5)
*		move.b	#$20,(a0)+
*		move.b	#$21,(a0)+
*		clr.b	(a0)
*		lea	IIoErr(pc),a0
*		rts

JaGuru:		ifne guru

		moveq	#0,d0
		moveq	#2,d2
		lea	TextPuffer(a5),a2
		add.w	d0,d1
		move.l	$1346(a5),d3
		add.w	d1,d2
		lsr.l	#1,d3
		lea	(a2,d0.l),a1
		move.l	$4568(a2),d4
		add.w	d4,d2
		sub.w	d0,d4
		add.w	d3,d4
		add.w	d2,d1
		sub.l	a2,a1
		move.l	d2,4(a1)			;Guru !!!!
		move.l	(a1),d3
		rts
	else
		jsr	FarbEffect
		moveq	#0,d0
		rts
	endc


*----------------------- Puffer vergleichen und umtauschen ------------------*
SortEin:	tst.b	Sortieren(a5)
		bne.w	.SetLast

		movem.l	d3/d4/a1-a4,-(a7)
		lea	EPG_FirstFileStruct(a5),a2
		subq.l	#1,d4
		*tst.b	Sortieren(a5)
		*bne.w	.SetLast
	;	tst.b	OnSortin(a5)
	;	beq.w	.SetLast

	*--------------- Parent nicht mit sortieren ----------------*
		moveq	#0,d0
		move.l	(a2),d1
		beq.s	.NoParent
		move.l	d1,a0
		move.b	EFP_Flags(a0),d0
		btst	#EFPF_Parent,d0
		beq.s	.NoParent
		move.l	a0,a2

	*----------- Soll ein Directory eingeordnet werden ---------*
.NoParent:	move.b	EFP_Flags(a3),d0
		moveq	#EFPB_DirName,d3	;Was nur sein darf
		btst	#EFPF_DirName,d0	;bne=Bit=1
		bne.s	.NextText

	*------------- Anfang der Filenametabelle finden -----------*
		moveq	#0,d3
.NextFilename:	move.l	(a2),d0
		beq.s	.NextText
		move.l	d0,a4
		move.b	EFP_Flags(a4),d1
		btst	#EFPF_DirName,d1
		beq.s	.NextText
		move.l	a4,a2
		bra.s	.NextFilename
		
	*----------- Letzter Eintrag ??? ---------------*
.NextText:	move.l	a2,a4
		tst.l	(a4)
		beq.s	.SetToLast

	*-- Wird nach Dir geordnet und file gefunden ---*
		move.l	(a2),a2
		tst.l	d3
		beq.s	.NoDir
		move.b	EFP_Flags(a2),d0	;Nach Dir gesucht
		btst	#EFPF_FileName,d0	;Noch Dir-File
		bne.s	.Tausche

.NoDir:		move.l	EFP_Node+LN_Name(a3),a0
		move.l	EFP_Node+LN_Name(a2),a1

		*lea	EFP_NamePuffer(a3),a0	;Adresse des new Namens
		*lea	EFP_NamePuffer(a2),a1

		moveq	#Namenlange-1,d2
.NextBuchSt:	move.b	(a0)+,d0
		move.b	(a1)+,d1
		cmp.b	#"a",d0
		blt.s	.NoSub1
		cmp.b	#"z",d0
		bgt.s	.NoSub1
		bclr	#5,d0
.NoSub1		cmp.b	#"a",d1
		blt.s	.NoSub2
		cmp.b	#"z",d1
		bgt.s	.NoSub2
		bclr	#5,d1
.NoSub2:	cmp.b	d0,d1
		blt.s	.NoThis
		bgt.s	.Tausche
		dbf	d2,.NextBuchSt
.NoThis:	dbf	d4,.NextText
.SetToLast:	move.l	a3,(a4)
		movem.l	(a7)+,d3/d4/a1-a4
		rts

	*--------- 2 Puffer tauschen ----------*
.Tausche:	move.l	a2,(a3)
		bra.b	.SetToLast

	*--- Der Name wird nicht einsortiert sonder gleich gesetzt ----*
.SetLast:	move.l	SortEinAdr(a5),a1
		move.l	a3,(a1)
		move.l	a3,SortEinAdr(a5)
		rts


*--------------------------------------------------------------------------*
*------------------ Test, ob File gehidet werden soll ---------------------*
*--------------------------------------------------------------------------*

* Achtung: Register sichern !!!!!!!!!!!!!!!!!!
* Input: a0=Filename
* Output:d0=1 -> nicht zu hiden
*	 d0=0 -> hiden
EPP_TestAufHide:move.l	PufferAdr3(pc),a5
		moveq	#1,d0
		movem.l	d1/d2/d4/a0/a1/a3,-(a7)
		move.l	a0,a3			;Adr des Namens
		move.l	a0,d4
		lea	HideTabMitLHA,a0
		bra.s	TH_FindEnde

TestAufHide:	moveq	#1,d0			;File OK
		tst.b	OnHideAll(a5)
		beq.w	TH_HideReturn
		tst.b	Hiden(a5)
		bne.w	TH_HideReturn

		btst	#EFPF_DirName,CFP_Flags(a5)
		bne.w	TH_HideReturn


	*--------------- Test auf Hide ----------------*
		movem.l	d1/d2/d4/a0/a1/a3,-(a7)

		move.l	a0,a3			;Adr des Namens
		move.l	a0,d4

		lea	HideTab,a0		;gehided
		btst	#EFPF_ArchiveFile,CFP_Flags(a5) ;in LHA-Archiven
		beq.s	TH_FindEnde
		move.l	a3,a0
TH_HideLHAArchive:jsr	A5BerechStringSize(a5)	;fr Files wie
		lea	(a0,d0.w),a0		; "Hallo\Slz\Laber\smpl.test"
		tst.l	d0
		beq.s	TH_HideLHAArc3
		addq.l	#1,d0
TH_HideLHAArc1:	subq.l	#1,d0
		blt.s	TH_HideLHAArc3
		move.b	-(a0),d1
		cmp.b	#"\",d1
		beq.s	TH_HideLHAArc2
		cmp.b	#":",d1
		beq.s	TH_HideLHAArc2
		cmp.b	#"/",d1
		bne.s	TH_HideLHAArc1
TH_HideLHAArc2:	lea	1(a0),a3
		move.l	a3,d4
TH_HideLHAArc3:	lea	HideTabMITLHA,a0



	*--------- Ende des Namens nach a3 -------*
TH_FindEnde	tst.b	(a3)+
		bne.s	TH_FindEnde
		subq.l	#1,a3

TH_TesteWeiter:	move.l	d4,a1			;Name des Namens
		moveq	#0,d0
		move.b	(a0)+,d0
		btst	#7,d0
		beq.s	TH_Testen			;Keine Addition

	*---- Am Ende Testen -----*
		move.l	a3,a1
		bclr	#7,d0
		subq.l	#1,a1
		sub.l	d0,a1

	*------ Now Testen ------*
TH_Testen:	move.b	(a0)+,d1
		move.b	(a1)+,d2
		beq.s	TH_NextTest
		cmp.b	#97,d2
		blt.s	TH_NoSub
		sub.b	#$20,d2
TH_NoSub:	cmp.b	d1,d2
		bne.s	TH_NextTest
		dbf	d0,TH_Testen
		moveq	#0,d0
		subq.l	#1,EPDIR_Files(a5)
TH_HideEnd:	movem.l	(a7)+,d1/d2/d4/a0/a1/a3
TH_HideReturn:	tst.l	d0
		rts

TH_NextTest:	tst.b	(a0)+
		bne.s	TH_NextTest
		tst.b	(a0)
		bne.s	TH_TesteWeiter
		moveq	#1,d0
		bra.s	TH_HideEnd

*--------------------------------------------------------------------------*
*--------------------------------------------------------------------------*
*------------------------ Ein Directory wird geladen ----------------------*
*--------------------------------------------------------------------------*
*--------------------------------------------------------------------------*
LoadDirIn:	movem.l	d1-a6,-(a7)
		clr.l	ArchiveError(a5)
		moveq	#EPR_FunctionAborted,d7
	*	tst.b	OnDirScanVerbot(a5)
	*	bne.s	.Return
		tst.b	OnLoaddir(a5)
		beq.w	.Return

		tst.b	DirTrotzDem(a5)
		bne.s	.LoadTrotzDem

		tst.b	OnMultiSelectIn(a5)
		bne.w	.Return
.LoadTrotzDem:	clr.b	DirTrotzDem(a5)
		cmp.l	#Mode_Config,TestBits(a5)
		beq.w	.Return

	*--- Dir-Lock holen d1=Adresse des Pfades -> d0=Lock --*
		moveq	#EPR_ErrorLoadingDir,d7
		lea	DirPuffer(a5),a0	;Dir-Adresse nach d1
		jsr	A5KillLastSchraeg(a5)
		move.l	a0,d1
		move.l	a0,EPDir_Ptr(a5)
		move.l	DTG_Dosbase(a5),a6
		moveq	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,d6			;Lock nach d6
		bne.w	.LockOk
		jsr	A5FreeDirPuffer(a5)
		bra.w	.Return


.LockOK:	lea	InfoBlock(a5),a0
		move.l	a0,d2
		move.l	d6,d1			;Error beim Lock holen
		jsr	_LVOExamine(a6)
		tst.l	d0
		bne.w	.FileInfoOk
.NoLHA:		jsr	A5FreeDirPuffer(a5)
.NoLHA2:	bra.w	.CloseLock


	*--------------------------------------------------*
	*------ Alten und neuen Infoblock vergleichen -----*
	*------------ ersten paar Bytes testen ------------*
.FileInfoOk:	tst.b	OnScanAlways(a5)
		bne.s	.LoadIn

		moveq	#1,d0				;35 / 64
		lea	InfoBlock(a5),a0
		lea	DiskInfoBlock(a5),a1
.CmpNext1:	cmpm.l	(a0)+,(a1)+
		bne.b	.LoadIn
		dbf	d0,.CmpNext1

	*---------- Namen testen --------*
		lea	InfoBlock+8(a5),a1
		lea	DiskInfoBlock+8(a5),a0
		jsr	A5StrCmp3(a5)
		tst.l	d0
		bne.s	.LoadIn

	*------------ nchsten paar Bytes testen ------------*
		moveq	#6,d0				;35 / 64
		lea	InfoBlock+116(a5),a0
		lea	DiskInfoBlock+116(a5),a1
.CmpNext2:	cmpm.l	(a0)+,(a1)+
		bne.b	.LoadIn
		dbf	d0,.CmpNext2

	*---------- Kommentar testen --------*
		lea	InfoBlock+144(a5),a1
		lea	DiskInfoBlock+144(a5),a0
		jsr	A5StrCmp3(a5)
		tst.l	d0
		bne.s	.LoadIn

		moveq	#EPR_DirNotChanged,d7
		bra.w	.CloseLock

	*-------------- Auf Archive testen ------------*
.LoadIn:	tst.l	InfoBlock+4(a5)
		bgt.s	.LoadARealDir
		tst.b	OnExtractFirstModule(a5)
		bne.s	.NoLHA2
		*tst.b	KeyOn(a5)
		*beq.w	.NoLHA
		lea	DirPuffer(a5),a0	;ist Dir wirklich Archive ???
		jsr	A5TestAufArchive(a5)
		bne.s	.NoLHA

.LoadARealDir:	jsr	A5WaitMouse(a5)
		jsr	A5StartNotify(a5)
		moveq	#0,d7			;Keine Fehlernummer
		jsr	A5FreeDirPuffer(a5)
		move.w	#144,d1			;Neuen auf alten infoblock copy
		lea	InfoBlock(a5),a1
		lea	DiskInfoBlock(a5),a0
		jsr	A5CopyText2(a5)

		lea	DirPuffer(a5),a0
		move.l	a0,d2
		move.l	#DirPufferSize-2,d3
		move.l	d6,d1
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVONameFromLock(a6)



	*---------------------------------------------------------------*
	*--------------------- LHA-Directory Einschub ------------------*
	*---------------------------------------------------------------*
		tst.l	InfoBlock+4(a5)		;Es handelt sich um ein Dir
		bgt.w	.LoadNormalDir2
		tst.b	OnScanAlways(a5)
		bne.s	.ScanLHAIn
		moveq	#1,d1			;Kennung -> LHA-Archiv
		bsr.w	LoadEPDir
		tst.l	d0
		bne.s	.ScanLHAIn
		move.b	#1,OnLHAInMenu(a5)		:LHA-Dir im PD-Menu
	*	bra.w	.CloseLock
		bra.w	.NewDir

	*----------- Abort-Gadget setzen -------------*
.ScanLHAIn:	tst.l	ArchiveError(a5)		;Sicherheit
		bne.w	.CloseLock
		jsr	A5FreeDirPuffer(a5)
		jsr	A5ClearTextWindow(a5)
		jsr	A5AddAbortGadget(a5)
		move.w	#DirAbortSize,AbortTimes(a5)
		move.w	#DirAbortSize,AbortTimer(a5)

		lea	DiskInfoBlock+8(a5),a0
		move.l	a0,ScrollArgs(a5)
		LA0	LNr_Scanning
		jsr	A5PrintText(a5)


	*----------- Dir laden und setzen ------------*
	*------ Puffer fr Pull-Down-Menu creieren und setzen -------*
		moveq	#16,d0				;Mode LHA-Scan
		move.l	d6,d1				;Lock laden
		moveq	#0,d2				;Internal Puffer
		sub.l	a0,a0				;MultiSelect
		sub.l	a1,a1
		jsr	A5CreateFilesPuffer(a5)
		move.l	d0,d7
		bne.w	.ArchiveError
		move.b	#1,OnLHAInMenu(a5)		:LHA-Dir im PD-Menu
		bra.w	.SaveEPDir

.ArchiveError:	lea	DirPuffer(a5),a0
		jsr	A5ParentArchiveDir(a5)
		bne.w	.NewDir
		tst.l	d1
		beq.w	.NewDir
		cmp.b	#":",(a0)
		bne.s	.Ar_ClearSchr
		addq.l	#1,a0
.Ar_ClearSchr:	clr.b	(a0)
		move.l	d7,ArchiveError(a5)
		bra.w	.LoadTrotzDem

	*-----------------------------------------------------------------*
	*----------- fortfhrende Routine fr NormalDirLoading -----------*
	*-----------------------------------------------------------------*
.LoadNormalDir2:tst.b	OnScanAlways(a5)
		bne.s	.ScanIn

		moveq	#0,d1			;Kennung -> Directory
		bsr.w	LoadEPDir
		tst.l	d0
	*	beq.w	.CloseLock
		beq.w	.NewDir

	*----------- Abort-Gadget setzen -------------*
.ScanIn:	jsr	A5ClearTextWindow(a5)
		jsr	A5AddAbortGadget(a5)
		move.w	#DirAbortSize,AbortTimes(a5)
		move.w	#DirAbortSize,AbortTimer(a5)

	*--- Schrift ausgeben "Loading ..." --*
		lea	DiskInfoBlock+8(a5),a0
		move.l	a0,ScrollArgs(a5)
		LA0	LNr_Scanning
		jsr	A5PrintText(a5)


		moveq	#EPR_FileNotFound,d7
		lea	InfoBlock(a5),a0
		move.l	a0,d2
		move.l	d6,d1			;Error beim Lock holen
		jsr	_LVOExamine(a6)
		tst.l	d0
		beq.s	.NewDir

		move.w	#144,d1			;Neuen auf alten infoblock copy
		lea	InfoBlock(a5),a1
		lea	DiskInfoBlock(a5),a0
		jsr	A5CopyText2(a5)

	*----------- Dir laden und setzen ------------*
	*------ Puffer fr Pull-Down-Menu creieren und setzen -------*
		moveq	#14,d0				;Mode DirLoading
		move.l	d6,d1				;Lock laden
		moveq	#0,d2				;Internal Puffer
		sub.l	a0,a0
		sub.l	a1,a1
		jsr	A5CreateFilesPuffer(a5)
	;	moveq	#EPR_DirIsEmpty,d7
		move.l	d0,d7
		bne.s	.NewDir

	*-------------- Schnell mal das Dir saven ----------------*
.SaveEPDir:	clr.b	OnMultiSelectIn(a5)
		move.w	#1,OnLoadDirIn(a5)
		bsr.w	SaveEPDir
		moveq	#0,d7				;Keine Fehler

	*------------- Engines benachrichten --------------*
.NewDir:	*wird bei Createfilespuffer gemacht
		*moveq	#USClass_NewDirectory,d0
		*jsr	A5SendeAllMessage(a5)

	*---- Wenn Dir neu gescannt wurde, dann ModNr setzen ----*
		clr.l	EPG_ModNr(a5)
		tst.b	OnScanAlways(a5)
		bne.s	.CloseLock
		lea	TitlenamePuffer(a5),a0
		jsr	A5GetModuleNr(a5)
		move.l	d0,EPG_ModNr(a5)
		move.w	d0,LastModuleNr(a5)

	*------------- Lock des Dirs wieder freigeben ------------*
.CloseLock:	move.l	d6,d1
		beq.s	.Return
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOUnLock(a6)
.Return:	jsr	A5RemoveAbortGadget(a5)
		jsr	A5SetMenuStrip(a5)
		jsr	A5ClearMouse(a5)
		move.l	ArchiveError(a5),d0
		bne.s	.ErrorDa
		move.l	d7,d0
.ErrorDa:	movem.l	(a7)+,d1-a6
		tst.l	d0
ABReturn:	rts




*-----------------------------------------------------------------------------*
*-------------------- Besorge Speicher aus eigener Liste ---------------------*
*-----------------------------------------------------------------------------*
AllocLHAMenuStruct:
		movem.l d1/a1,-(a7)
		move.w	#EFP_NamePufferEnd,d0
		cmp.w	#Namenlange,d1
		bls.s	.NameSizeOk

		sub.w	#Namenlange-1,d1
		bclr	#0,d1				;gerade machen
		add.l	d1,d0

.NameSizeOk:	move.l	d3,-(a7)
		move.l	#700,d3
		bsr.s	AllocAStruct
		move.l	(a7)+,d3
		tst.l	d0
		beq.s	.NoAddi
		move.l	d0,a1
		move.l	d1,EFP_StructSize(a1)		;EFP_NamePufferEnd
.NoAddi:	movem.l	(a7)+,d1/a1			;wird noch geaddet !!!
		tst.l	d0
		rts


*-----------------------------------------------------------------------------*
* Input: d0=Size des Items
* Output:d0=Adr oder NULL
*-----------------------------------------------------------------------------*
AllocMenuStruct:move.l	#EFP_NamePufferEnd,d0
AllocAStruct:	movem.l	d1/a4,-(a7)
		cmp.l	#NewMenuMemSize-20,d0
		bhi.s	.Error

		*--- neuen Block allokieren ---*
		* 1.l = next Ptr
		* 2.l = Size
		* 3.l = CurrentAdr
		* 4.l = RestSize
		*------------------------------*
		lea	FirstMenuPtr(a5),a4
.NextPuffer:	move.l	(a4),d1
		bne.s	.IstDa
		bsr	AllocNewPuffer
		beq.s	.AllocReturn
.IstDa:		move.l	d1,a4
		move.l	12(a4),d1
		cmp.l	d0,d1
		blo.s	.NextPuffer

		move.l	8(a4),d1			*CurrentAdr
		add.l	d0,8(a4)			*new CurrentAdr
		sub.l	d0,12(a4)			*RestSize
		exg	d1,d0

.AllocReturn:	movem.l	(a7)+,d1/a4
		tst.l	d0
		rts

.Error:		moveq	#0,d0
		bra.s	.AllocReturn

*-----------------------------------------------------------------------------*
* Input: a4=Ptr des vorherigen Puffers
* Output:d1=Null fr Error oder CurrentAdr
*	 a4=Ptr zum Puffer
*-----------------------------------------------------------------------------*
AllocNewPuffer:	movem.l	d0/a0/a1,-(a7)
		move.l	#NewMenuMemSize,d0
		jsr	A5AllocMem(a5)			*gleich gelscht
		move.l	d0,d1
		beq.s	.Return
		move.l	d0,(a4)				*Verkettung

		move.l	d0,a4
		move.l	#NewMenuMemSize,4(a4)		*AllocSize
		add.l	#16,d0
		move.l	d0,8(a4)			*CurrentAdr
		move.l	#NewMenuMemSize-20,12(a4)	*RestSize
.Return:	movem.l	(a7)+,d0/a0/a1
		tst.l	d1
		rts




*AllocMenuMem2:	move.l	d1,-(a7)
*		move.l	d0,-(a7)
*		tst.l	MenuMemSize(a5)
*		beq.s	.AllocReturn
*		
*		move.l	MenuMemZeiger(a5),d1	;Fehler ?!?!
*		beq.s	.AllocReturn
*
*	*-------- Vergleichen, ob Speicher voll --------*
*		add.l	d0,MenuMemZeiger(a5)
*		move.l	d1,d0
*		move.l	MenuMemAdr(a5),d1
*		beq.s	.AllocReturn
*		add.l	MenuMemSize(a5),d1
*		sub.l	d3,d1
*		cmp.l	MenuMemZeiger(a5),d1
*		blo.s	.AllocReturn
*
*	*---------- allocierten Speicher lschen -------*
*		move.l	(a7),d1			Lnge laden
*		move.l	d0,a0
*		subq.l	#1,d1
*.ClrBuffer	clr.b	(a0)+
*		dbf	d1,.ClrBuffer
*		move.l	(a7)+,d1		;d0=vom Stack
*		move.l	(a7)+,d1		;d1 zurckretten
*		move.l	(a7)+,d3		;d3 zurckretten
*		tst.l	d0
*		rts
*
*	*-------------- Kein Speicher mehr -------------*
*.AllocReturn:	move.l	(a7)+,d1		;d0=vom Stack
*		move.l	(a7)+,d1		;d1 retten
*		move.l	(a7)+,d3
*		moveq	#0,d0
*		rts
*


*----------------------------------------------------------------------------*
*------------------------ Alle Puffer wieder freigeben ----------------------*
*----------------------------------------------------------------------------*
FreeDirPuffer:	movem.l	d0-a6,-(a7)
		lea	EPG_FirstFileStruct(a5),a4
		tst.w	OnLoadDirIn(a5)
		bne.b	.ClearMenu
		tst.b	OnMultiSelectIn(a5)
		beq.s	.SendeMsg
		
	*--------- Menu lschen ---------*
.ClearMenu:	jsr	A5ClearMenuStrip(a5)
		tst.w	MenuOn(a5)
		bne.w	.ErrorReturn
		clr.l	EM_SpecialMenu(a5)
		move.w	#1,SetMenuNew(a5)	;Menu richtig neu machen
		jsr	A5SetMenuStrip(a5)

	*----- FileInfoBlock lschen ----*
		lea	DiskInfoBlock(a5),a0
		move.w	#144,d0
.ClearOld:	clr.b	(a0)+
		dbf	d0,.ClearOld


	*------- Message schicken -------*
.SendeMsg:	tst.l	EPG_Entries(a5)		;Engines wissen bereits
		beq.s	.NextLock		;bescheid
		moveq	#USClass_RemModulesList,d0	;keine Eintrge mehr
		jsr	A5SendeAllMessage(a5)
		clr.l	EPG_Entries(a5)			;damit Engine wei

	*----- Alle Locks freigeben -----*
.NextLock:	move.l	(a4),d0
		beq.s	.NoMods
		move.l	d0,a4
		move.l	EFP_NameDirLock(a4),d1
		beq.s	.NextLock
		move.l	DTG_Dosbase(a5),a6
		jsr	_LVOUnLock(a6)
		bra.s	.NextLock

	*----- Menuspeicher vom 2. bis x. Block freigeben -----*
.NoMods:	move.l	FirstMenuPtr(a5),d4	*der erste Block bleibt bis zum
		beq.s	.ClearFirstBlock	*Quit EP
		move.l	d4,a4
		move.l	(a4),d4
.NextMemBlock:	tst.l	d4
		beq.s	.ClearFirstBlock
		move.l	d4,a1
		move.l	4(a1),d0		*Size
		move.l	(a1),d4
		Execbase
		jsr	_LVOFreeMem(a6)
		bra.s	.NextMemBlock

.ClearFirstBlock:
		move.l	FirstMenuPtr(a5),d0
		beq.s	.FreeListMem
		move.l	d0,a0
		move.l	4(a0),d0		*AllocSize
		blt.s	.FreeListMem
		lea	16(a0),a1
		move.l	a1,8(a0)		*CurrentAdr
		sub.l	#16,d0
		move.l	d0,12(a0)		*RestSize
		lea	16(a0),a0
		clr.l	(a4)			*Next Puffer
.ClrIt:		clr.b	(a0)+
		subq.l	#1,d0
		bne.s	.ClrIt
		
*		move.l	MenuMemAdr(a5),d0
*		beq.s	.FreeListMem
*		move.l	d0,a0
*		move.l	MenuMemSize(a5),d0
*		beq.s	.FreeListMem
*		subq.l	#1,d0
*.ClearPuffer:	clr.b	(a0)+
*		dbf	d0,.ClearPuffer

	*-------- ListenMem freigeben ---------*
.FreeListMem:	move.l	ListMemAdr(a5),d0
		beq.s	.Return
		move.l	d0,a1
		move.l	ListMemSize(a5),d0
		beq.s	.Return
		ExecBase
		jsr	_LVOFreeMem(a6)


	*------- Variablen lschen ------*
.Return:	lea	ModulesList(a5),a0
		move.l	a0,EPG_ModulesList(a5)
		Newlist a0

		moveq	#USClass_NewDirectory,d0
		jsr	A5SendeAllMessage(a5)

		clr.w	OnLoadDirIn(a5)
		clr.w	OnModulesIn(a5)
		clr.w	LastModuleNr(a5)
		clr.b	OnMultiSelectIn(a5)
		clr.b	OnLHAInMenu(a5)
		clr.l	ListMemAdr(a5)
		clr.l	ListMemSize(a5)
		clr.l	EPG_FirstFileStruct(a5)
		clr.l	FirstModulesEintrag(a5)
		clr.l	MenuFileName(a5)
	*	clr.l	ScrollNameZahler(a5)
		clr.l	EPG_Entries(a5)
		clr.l	EPG_Mods(a5)
		clr.l	EPG_Dirs(a5)
		clr.l	EPG_ModNr(a5)

		clr.l	LHAFileRequestAddr(a5)	;Hilfsmerkzelle fr Filerequest
		clr.w	LHAFileRequestByte(a5)	;damit auch bei
					;"modules:jamesbrown.lha" ein filereq.
					;im Verzeichnis "Modules:" geht 

		move.l	MenuMemAdr(a5),MenuMemZeiger(a5)
.ErrorReturn:	movem.l	(a7)+,d0-a6
		rts

*FreeNextMenu:	move.l	a3,MenuMemZeiger(a5)
*		rts

*-----------------------------------------------------------------------------*
* Ldt eine Delitrackermoduleliste ein
* Input: File=Adr der Liste
*	 FileSizeneu= Size + eventuell Sicherheitsbytes (je nach Flags)
*-----------------------------------------------------------------------------*
LoadProgrammList:
		movem.l	d1-a6,-(a7)
		moveq	#EPR_UnknownFormat,d0
		move.l	File(a5),d1
		beq.w	.Return
		move.l	d1,a0
		move.l	FileSizeNeu(a5),d0
		bsr	Py_CheckListtype
		beq.s	.Return
		move.l	d1,d5
		move.l	d2,d4

		tst.b	NewListLoaded(a5)
		bne.w	.Return

		movem.l	a0/a1/d0,-(a7)
		move.l	LoadFilePath(a5),d1
		move.l	LoadFileName(a5),d0
		beq.s	.NameOk
		move.l	d0,a2
		jsr	A5CreateLoadPath(a5)
		lea	PathPuffer(a5),a0
		move.l	a0,d1
.NameOk		move.l	DTG_Dosbase(a5),a6
		moveq	#-2,d2
		jsr	_LVOLock(a6)
		move.l	d0,d6
		move.l	d0,d1
		beq.s	.NoLock
		lea	ListPuffer(a5),a1
		move.l	a1,d2
		move.w	#DirPufferSize,d3
		jsr	_LVONameFromLock(a6)
		move.l	d6,d1
		jsr	_LVOUnLock(a6)
.NoLock:	movem.l	(a7)+,a0/a1/d0


		*-- Es wurde eine Moduleliste geladen --*
*----- Einen Puffer initialisieren, der die Multiselecteintrge bernimmt ----*
*----	Input:	a0 = Zeiger auf Multiselect				  ----*
*----		a1 = Adr des Menufilenames (only Internal)		  ----*
*----		d0 = Filerequester 10=App 11=Arexx ;Sonst Mode in D0	  ----*
*----		d1 = SpecialInfo fr Requester (Para2)			  ----*
*----		d2 = Use Internal Puffer (0=jes)			  ----*
		moveq	#17,d0			;Moduleliste
		move.l	d4,d1
		moveq	#0,d2			;nicht sortieren
		move.l	d5,a0			;Listentyp

		jsr	A5CreateFilesPuffer(a5)
		tst.l	d0
		bne.s	.Return

		move.b	#1,NewListLoaded(a5)
		moveq	#0,d0
.Return:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts




*-----------------------------------------------------------------------------*
* Wenn das Archiv nicht gescannt werden soll, mu der erste richtige Name ge- *
* funden werden.							      *
* Input: a1=Archivepfad							      *
* Output:Menufilename=Archivepfad
*	 Menufilename=LHAPathPuffer
*-----------------------------------------------------------------------------*
ExtractFirstArchiveEntry:
		movem.l	d1-a6,-(a7)

		btst	#2,LoadFileBytes(a5)		;nur bei ModuleLoading
		bne.w	.Return


		moveq	#EPR_UnknownArchive,d7

	*------------- Engines aufrufen -----------------*
	* Input: a0=Pfad
	* Output:d0=Error oder NULL
	*------------------------------------------------*
		movem.l d1-d3/d5-d7/a1-a6,-(a7)
		move.l	a0,a1
		moveq	#0,d4				*FirstSearchEngineNr
		moveq	#EUTY_Extractor,d3		*Type
		move.l	#EUT_OpenArchive,d5		*Tag
		jsr	A5UserCallUp5(a5)
		movem.l	(a7)+,d1-d3/d5-d7/a1-a6
		tst.l	d0
		bne.w	.Error
		move.l	a0,a4

		subq.w	#1,d4
		move.w	d4,ArchiveEngineNr(a5)
		move.b	#EFPB_ArchiveDir,CFP_Flags(a5)	;Kennung Dir !!!!


		*--- Nun alle Entries durchtesten (Hideall) ---*
		clr.b	Hiden(a5)			;Hiden erlaubt
.ExNext:	movem.l d1-d7/a1-a6,-(a7)
		lea	LHAPathPuffer(a5),a1
		clr.b	(a1)
		moveq	#0,d1
		move.w	#LHAPathPufferSize-2,d1
		move.l	a4,a0			*	 a0=Name oder NULL
		moveq	#0,d4
		move.w	ArchiveEngineNr(a5),d4
		moveq	#EUTY_Extractor,d3		*Type
		move.l	#EUT_ArchiveExNext,d5		*Tag
		jsr	A5UserCallUp5(a5)
		movem.l	(a7)+,d1-d7/a1-a6
	*	bne.s	.NameCloseArchive2		*Kein Aufruf d3=Fehler
		tst.l	d0
		bne.s	.NameCloseArchive
		move.b	#EFPB_FileName+EFPB_ArchiveFile,CFP_Flags(a5)
		moveq	#EPR_ErrorInArguments,d0
		lea	LHAPathPuffer(a5),a0
		tst.b	(a0)
		beq.s	.NameCloseArchive
		bsr	TestAufHide
		beq.s	.ExNext

		lea	LHAPathPuffer(a5),a0
		move.l	a0,MenuFileName(a5)
		lea	ArexxPuffer+1000(a5),a1
		move.w	#DirPufferSize-2,d1
		jsr	A5StringCopy2(a5)
		moveq	#0,d0
		bra.s	.NameCloseArchive

.NameCloseArchive2:move.l d3,d0
.NameCloseArchive:movem.l d0-a6,-(a7)
		move.l	a4,a0				*a0=ArchiveStruct
		moveq	#0,d4
		move.w	ArchiveEngineNr(a5),d4
		moveq	#EUTY_Extractor,d3		*Type
		move.l	#EUT_CloseArchive,d5		*Tag
		jsr	A5UserCallUp5(a5)
		movem.l	(a7)+,d0-a6

.Error:		movem.l	(a7)+,d1-a6
		tst.l	d0
		beq.s	ExtractArchiveEntry
.Return:	rts


*-----------------------------------------------------------------------------*
* Ein Eintrag aus dem Archiv wird entpackt. Dabei ist in PathPuffer der       *
* Archivepfad und in MenuFileName=Adresse des Entrypfads im Archive           *
*-----------------------------------------------------------------------------*
* a1=Archivepfad
ExtractArchiveEntry:
		btst	#2,LoadFileBytes(a5)		;nur bei ModuleLoading
		bne.w	.Return
		move.l	a1,a3
*		clr.b	LHALoaded(a5)

	*--- Schrift ausgeben "Extracting ..." --*
		LA0	LNr_Extracting
		move.l	MenuFileName(a5),a1
		jsr	A5GetFilename(a5)
		move.l	a1,ScrollArgs(a5)
		jsr	A5PrintText(a5)

		move.l	MenuFileName(a5),a0
		lea	LHAPathPuffer(a5),a1
		move.w	#LHAPathPufferSize-2,d1
		cmp.l	a0,a1
		beq.s	.NoCopy
		jsr	A5StringCopy2(a5)

	*------------- Engines aufrufen ----------------*
	* In WorkPuffer steht dann der neue Filename    *
	* zB."T:Mod.Test" Das File wird vom EP gelscht.*
	*-----------------------------------------------*
	* Input: a0=Pfad des Archives			*
	*	 a1=Pfad des Namens im Archive		*
	*	 a2=WorkPuffer fr Befehlspfad		*
	*	 d2=WorkPufferSize			*
	* Output:d0=Error oder NULL			*
	*-----------------------------------------------*
.NoCopy:	*lea	PathPuffer(a5),a0
		move.l	a3,a0
		lea	LHAPathPuffer(a5),a1
		lea	ArexxPuffer(a5),a2
		move.l	#ArexxPufferSize-2,d2
		moveq	#0,d4				*FirstSearchEngineNr
		moveq	#EUTY_Extractor,d3		*Type
		move.l	#EUT_ExtractArchiveEntry,d5	*Tag
		jsr	A5UserCallUp5(a5)
	*	jsr	EP_ExtractArchiveEntry
		tst.l	d0
		bne.s	.Return


		lea	LHAPathPuffer(a5),a0
		lea	ArexxPuffer+1000(a5),a1
		move.l	a1,MenuFileName(a5)
		move.w	#DirPufferSize-2,d1
		jsr	A5StringCopy2(a5)

		lea	ArexxPuffer(a5),a0
		lea	PathPuffer(a5),a1
		move.w	#PathPufferSize-2,d1
		jsr	A5StringCopy2(a5)
*^^	bra.s	.NoMemChange
*^^
*^^
*^^	*------- neuen LoadPfad festlegen -------*
*^^		lea	ArexxPuffer(a5),a1
*^^		jsr	A5GetFileName(a5)
*^^		move.l	a1,a0
*^^		jsr	A5LoadNeededPlayer(a5)		;fr den Fall:
*^^
*^^		*lea	FilePuffer(a5),a1
*^^		*move.l	a1,DTG_FileArrayPtr(a5)
*^^		jsr	A5StringCopy(a5)
*^^
*^^		lea	ArexxPuffer(a5),a0
*^^		lea	PathPuffer(a5),a1
*^^		move.w	#PathPufferSize-2,d1
*^^		jsr	A5StringCopy2(a5)
*^^
*^^		lea	ArexxPuffer(a5),a0
*^^		lea	LHAPathPuffer(a5),a1
*^^		move.w	#LHAPathPufferSize-2,d1
*^^		jsr	A5StringCopy2(a5)
*^^
*^^		clr.l	FileSizeNeu(a5)
*^^		clr.l	File(a5)
*^^
*^^*	cmp.l	#1,LFNummer(a5)
*^^*	bne.s	.NoMemChange
*^^*
*^^*		moveq	#2,d0				;LoadFile zurcksetzen
*^^*		tst.b	OnLoadFast(a5)
*^^*		beq.s	.NoLoadToFast
*^^*		moveq	#1,d0				;Fastmem eingestellt
*^^*.NoLoadToFast:	move.l	d0,LoadFileMem(a5)

.NoMemChange:

	*	clr.b	LoadFileBytes(a5)		;Wieso
	*	subq.l	#1,LFNummer(a5)			;Nur SUB !!!
		move.b	#1,LHALoaded(a5)
*		lea	FilePuffer(a5),a2		;Filename copieren
*		move.l	a2,FileNameAdr(a5)
		move.l	a2,LoadFileName(a5)
		*lea	LHAPathPuffer(a5),a0
		lea	PathPuffer(a5),a0
		move.l	a0,LoadFilePath(a5)
		*lea	FilePuffer(a5),a0
		*jsr	A5LoadNeededPlayer(a5)		;fr den Fall:
							;"Modules/hh/FC13.Lll"
		moveq	#0,d0
		rts

	*-------- Kein Archive-Eintrag -----------*
.Return:	moveq	#EPR_ErrorDecrunching,d0
		rts

*-----------------------------------------------------------------------------*
*--------------- Testen, in dem Pfad ein Archivepfad versteckt ist -----------*
* Bsp: "Modules:Crunchertests/Amiga_Modules.lha/tests/mod.toll"		      *
* Input: a0 = ArchiveDir						      *
* Output:d0 = Returnwert (Error oder NULL)				      *
* 	 a1 = Adr, ab der der Pfad im Archive beginnt, nach "/"		      *
*-----------------------------------------------------------------------------*
TestAufsteigendArchive:
		movem.l	d1-d7/a0/a2-a6,-(a7)
		tst.b	(a0)
		beq.s	.Error

		*jsr	A5BerechStringSize(a5)
		*lea	(a0,d0.w),a1

		jsr	A5TestAufArchive(a5)		;LHA-Archiv handelt,darf
		beq.s	.Return
		move.l	a0,a1
		jsr	A5GetFileName3(a5)
		cmp.l	a0,a1
		beq.s	.Error
		cmp.b	#":",-1(a1)
		beq.s	.Error
		move.b	-1(a1),d0
		movem.l	d0/a1,-(a7)
		clr.b	-1(a1)
		jsr	A5TestAufsteigendArchive(a5)
		movem.l	(a7)+,d1/a2
		move.b	d1,-1(a2)

.Return:	movem.l	(a7)+,d1-d7/a0/a2-a6
		tst.l	d0
		rts

.Error:		moveq	#EPR_UnknownArchive,d0
		sub.l	a1,a1
		bra.s	.Return

*---------------------- LHA-Dir als Dir aufnehmen ----------------------------*
* Input: a0 = ArchivePfad						      *
* Output:d0 = Returnwert						      *
*	 *d1 = EngineNr							      *
*-----------------------------------------------------------------------------*
TestAufArchive:	movem.l	d1-a4,-(a7)
		moveq	#0,d1
		moveq	#EPR_UnknownArchive,d0

	*------------- Engines aufrufen -----------------*
	* Input: a0=Pfad
	* Output:d0=Error oder NULL
	*------------------------------------------------*
		moveq	#0,d4				*FirstSearchEngineNr
		moveq	#EUTY_Extractor,d3		*Type
		move.l	#EUT_TestValidArchive,d5	*Tag
		jsr	A5UserCallUp5(a5)

		tst.l	d3
		beq.s	.Return
		move.l	d3,d0				*Error


.Return:	movem.l	(a7)+,d1-a4
		tst.l	d0
		rts



*---------------- Testrequest "Eagleplayer.Key" ist gesperrt" ---------------*
PrintDisabled:	tst.l	KeyDisabled(a5)
		beq.s	.Return
		lea	PubScreenName(a5),a1
		move.l	a1,EPG_Arg2(a5)
		LA0	LNr_TR_KeyIsDisabled
		move.l	a0,EPG_Arg1(a5)
		clr.l	EPG_Arg3(a5)
		subq.l	#1,EPG_Arg3(a5)
		clr.l	EPG_Arg4(a5)			;Gadgets
		clr.l	EPG_Arg5(a5)			;Windowname
		clr.l	EPG_Arg6(a5)
		move.l	#EPTRB_Center,EPG_Arg8(a5)
		moveq	#-1,d0
		move.l	d0,EPG_Arg7(a5)
		moveq	#7,d0
		move.l	d0,EPG_ArgN(a5)
		move.l	EPG_Textrequest(a5),a0
		jsr	(a0)
		*jsr	A5CloseWin(a5)
		jsr	A5Warten(a5)
.Return:	rts


	*--------------------------------------------------*
	*------------ Include EP-Unterprogramme -----------*
	*--------------------------------------------------*
;		include	"EP_Unterprogramme1.S"

*----------------------------- Test auf Faults ------------------------------*
TestAufFaults:	movem.l	d1-a6,-(a7)

	*---------- Lnge des Moduls und calcsize vergleichen -------*
		move.l	MDPuffer+4(a5),d3
		moveq	#-1,d0
		cmp.l	d0,d3
		beq.s	.Custom
		move.l	#DTP_ExtLoad,d0			;mu Loadsize verwendet
		jsr	A5FindTag(a5)			;werden ????
		beq.s	.NoLoadSize

	*----------- Loadsize mu verwendet werden ----------*
.Custom:	move.l	#MI_LoadSize,d0
		move.l	GetInfoAdr(a5),a6
		jsr	A5FindTag2(a5)
		beq.w	.TestFaults
		move.l	a6,d3

	*-------------- Berechnete Lnge holen --------------*
.NoLoadSize:	LA1	LNr_ModuleLonger
		move.l	#MI_CalcSize,d0
		move.l	GetInfoAdr(a5),a6
		jsr	A5FindTag2(a5)
		beq.w	.TestFaults
		move.l	a6,d1
		cmp.l	d1,d3
		beq.w	.TestFaults
		bhi.s	.BigModule


	*------------- Ausschrift "Module ist zu kurz" -------------*
		moveq	#0,d0				;Kein Fehler
		tst.b	OnSmallModule(a5)
		beq.w	.TestFaults
		LA1	LNr_ModuleShorter
		bra.s	.SetRequester

	*------------- Ausschrift "Module ist zu lang" -------------*
.BigModule:	tst.b	OnBigModule(a5)
		beq.s	.TestFaults
		exg	d1,d3

.SetRequester:	sub.l	d3,d1
		lea	FaultRegs(a5),a2
		move.l	d1,4(a2)
		move.l	a1,8(a2)
		lea	Titlenamepuffer(a5),a1
		move.l	a1,(a2)

		LA0	LNr_TR_SmallModule
		move.l	a0,EPG_Arg1(a5)
		lea	PubScreenName(a5),a0
		move.l	a0,EPG_Arg2(a5)
		clr.l	EPG_Arg3(a5)
		subq.l	#1,EPG_Arg3(a5)
		LA0	LNr_GA_SmallModule
		move.l	a0,EPG_Arg4(a5)
		clr.l	EPG_Arg5(a5)
		move.l	a2,EPG_Arg6(a5)			;Argumenttable
		moveq	#-1,d0
		move.l	d0,EPG_Arg7(a5)			;Image prinnten
		moveq	#7,d0
		move.l	d0,EPG_ArgN(a5)
		clr.l	EPG_Arg8(a5)
		jsr	ENPP_Textrequest(a5)
		moveq	#EPR_Functionaborted,d0
		move.l	EPG_Arg1(a5),d1
		subq.l	#1,d1
		bne.w	.TestReturn			;Abort loading


.TestFaults:	tst.b	OnModuleFault(a5)
		beq.s	.OK

		move.l	#EP_CheckModule,d0
		jsr	A5CallUp(a5)
		beq.s	.OK
		tst.l	d0
		beq.s	.Ok

	*------------- Ausschrift "Module hat some faults" -------------*
		lea	FaultRegs(a5),a2
		move.l	d0,4(a2)			;Anzahl der Fehler
		lea	Titlenamepuffer(a5),a1
		move.l	a1,(a2)

		LA0	LNr_TR_ModuleFault
		move.l	a0,EPG_Arg1(a5)
		lea	PubScreenName(a5),a0
		move.l	a0,EPG_Arg2(a5)
		clr.l	EPG_Arg3(a5)
		subq.l	#1,EPG_Arg3(a5)
		LA0	LNr_GA_SmallModule
		move.l	a0,EPG_Arg4(a5)
		clr.l	EPG_Arg5(a5)
		move.l	a2,EPG_Arg6(a5)			;Argumenttable
		moveq	#-1,d0
		move.l	d0,EPG_Arg7(a5)			;Image prinnten
		moveq	#7,d0
		move.l	d0,EPG_ArgN(a5)
		clr.l	EPG_Arg8(a5)
		jsr	A5TextRequest(a5)
		moveq	#EPR_Functionaborted,d0
		move.l	EPG_Arg1(a5),d1
		subq.l	#1,d1
		bne.w	.TestReturn			;Abort loading

.Ok:		moveq	#0,d0			;Kein Fehler
.TestReturn:	movem.l	(a7)+,d1-a6
		tst.l	d0
		rts




WindowToFront:	movem.l	d0-a6,-(a7)
		jsr	A5GetMainWindowHandle(a5)
		beq.s	.NoWindow
		move.l	d0,a0
	;	jsr	A5ScreenToFront(a5)
		move.l	DTG_IntuitionBase(a5),a6
		jsr	_LVOWindowToFront(a6)
.NoWindow:	movem.l	(a7)+,d0-a6
		rts



*----------------------------------------------------------------------------*
*---------------------- FileRequester (mit LoadDir-Funktion) ----------------*
*----- OutPut:	FilePuffer	= selected File				-----*
*-----		DirPuffer	= selected Dir				-----*
*----- 		d0 = 0=Fehler, sonst OK					-----*
*----------------------------------------------------------------------------*
FileRequest:	movem.l	d1-a6,-(a7)
		moveq	#EPR_FileReqCancelled,d7		;Fehler
		tst.b	OnFilereqVerbot(a5)
		bne.w	.ItsAll

	*--- Falls LHA-Archiv aktiv ist, mu  Dir zurckgesetzt werden ---*
		clr.l	LHAFileRequestAddr(a5)	;Hilfsmerkzelle fr Filerequest
		clr.w	LHAFileRequestByte(a5)	;damit auch bei
					;"modules:jamesbrown.lha" ein filereq.
					;im Verzeichnis "Modules:" geht 
		lea	DirPuffer(a5),a0
		jsr	A5TestAufArchive(a5)
		bne.s	.NoLHAMenu

		*tst.b	KeyOn(a5)
		*beq.s	.NoLHAMenu
		lea	DirPuffer(a5),a0
		jsr	A5KillLastSchraeg(a5)
		jsr	A5ParentArchiveDir(a5)
		move.b	(a0),LHAFileRequestByte(a5)
		move.l	a0,LHAFileRequestAddr(a5)
		addq.l	#1,a0
		lea	FilePuffer(a5),a1
		move.l	a0,-(a7)
		jsr	A5StringCopy(a5)
		move.l	(a7)+,a0
		clr.b	(a0)

	*------------ Auf FileRequester testen ------------*
.NoLHAMenu:	moveq	#0,d0
		move.b	FileReqMode(a5),d0
		cmp.b	#EPNrF_Req,d0
		beq.s	.ReqLibrary
		cmp.b	#EPNrF_ReqTools,d0
		beq.w	.ReqToolsLibrary
		cmp.b	#EPNrF_Asl,d0
		beq.w	.AslLibrary
		bra.w	.ItsAll


*------------------------------ Req-Library --------------------------------*
.ReqLibrary:	lea	DirPuffer(a5),a1
		lea	FilePuffer(a5),a2
		lea	ReqPuffer,a0
		move.l	a1,ReqDirOffset(a0)
		move.l	a2,ReqFileOffset(a0)
		move.l	UPrg_WinHandle(a5),d0
		bne.s	.ReqUserWindow
		jsr	A5GetMainWindowHandle(a5)
.ReqUserWindow:	move.l	d0,ReqPathOffset+4(a0)
		move.l	EPG_ReqBase(a5),d2
		beq.w	.ItsAll
		move.l	d2,a6
		jsr	_LVOFileRequest(a6)
		move.l	Req_MultiAdr1,d1

	*------------ Allgemeine Sachen setzen -----------*
		tst.l	d0			;Filerequester gecancelt
		beq.w	.ItsAll
		tst.l	d1			;Adresse fr MultiSelect
		beq.w	.LoadDirNow

	*-- Multiselect in DirPuffer bernehmen --*
	*------- CreateFilesPuffer -------*
		move.l	d1,a0			;MultiSelectZeiger
		moveq	#1,d0			;Filereq "Req"
		lea	ReqPuffer,a1
		move.l	a1,d1			;Para
		moveq	#0,d2			;external Puffer
		jsr	A5CreateFilesPuffer(a5)	;Selectierte Dateien ins PMenu
	;	move.l	d1,d6			;Anzahl der Files
		move.l	d0,d7			;Fehler ???
		bra.w	.ItsAll


*------------------------- Filerequester per ReqTools -----------------------*
;   STRUCTURE rtFileList,0
;      APTR  rtfl_Next
;      ULONG rtfl_StrLen
;      APTR  rtfl_Name
;      LABEL rtFileList_SIZE
.ReqToolsLibrary:

		lea	EPG_ReqToolsBase(a5),a3
		LA1	LNr_ReqToolsName
		moveq	#38,d0
		jsr	A5OpenLib(a5)
		move.l	d0,a6
		tst.l	d0
		beq.w	.ItsAll

		*move.l	EPG_ReqToolsBase(a5),d0
		*beq.w	.ItsAll
		*move.l	d0,a6
	*------------ Dir festlegen --------------*
		lea	ReqToolsTags_2(pc),a0
		move.l	4(A0),d0
		beq.s	.doit
		move.l	d0,a2				;Dirpuffer
		lea	DirPuffer(a5),a1
.repeat
		move.b	(a1)+,d0
		cmp.b	(A2)+,d0
		bne.s	.doit
		tst.b	d0
		beq.s	.skipit
		bra.s	.repeat
.doit
		lea	DirPuffer2(a5),a1
		move.l	a1,4(a0)
		lea	Dirpuffer(a5),a2
.copydirreqto
		move.b	(a2)+,(a1)+
		bne.s	.copydirreqto

		move.l	ReqToolsAdr11(a5),d0
		beq.w	.ItsAll
		move.l	d0,a1
		jsr	_LVORtChangeReqAttrA(a6)
.skipit
	*-------- File-Requester ausfhren -------*
		lea	FilePuffer(a5),a0			;Pointer auf Req. Wind
		lea	PathPuffer(a5),a1			;Pointer auf Req. Wind
		move.l	a1,a2
		jsr	A5StringCopy(a5)		;alten Filenamen kopierne

		move.l	ReqToolsAdr11(a5),a1
		LA3	LNr_Fr_LoadModule
		lea	ReqToolsTags(pc),a0		;Tag-Liste
		move.l	UPrg_WinHandle(a5),d0
		bne.s	.ReqToolsWin
		jsr	A5GetMainWindowHandle(a5)
.ReqToolsWin:	move.l	d0,4(a0)		;WinHandle setzen
		jsr	_LVORTFileRequestA(a6)
		tst.l	d0
		beq.w	.ItsAll			;Canceled !!!

	*-- Testen, ob wirklich mehrfachauswahl --*
		moveq	#0,d7			;kein Error
		move.l	d0,a3
		tst.l	(a3)
		beq.s	.FreeReqToolsList

	*------- CreateFilesPuffer -------*
		move.l	d0,a0			;MultiSelectZeiger
		moveq	#2,d0			;Filereq "ReqTools"
		move.l	a4,d1			;Para
		moveq	#0,d2			;internal Puffer
		jsr	A5CreateFilesPuffer(a5)	;Selectierte Dateien ins PMenu
	;	move.l	d1,d6			;Anzahl der Files
		move.l	d0,d7			;Fehler ???

.FreeReqToolsList:move.l 8(a3),a0		;Filenamen kopieren
		move.l	4(a3),d1
		lea	FilePuffer(a5),a1
		jsr	A5StringCopy(a5)
		move.l	a3,a0
		move.l	(a3),d5
		jsr	_LVORTFreeFileList(a6)

		move.l	ReqToolsAdr11(a5),a1	;DirPuffer kopieren !!!
		move.l	16(a1),a0
		lea	DirPuffer(a5),a1
		move.w	#DirPufferSize-2,d1
		jsr	A5StringCopy2(a5)

		tst.l	d5
		bne.w	.ItsAll
		bra.s	.LoadDirNow

*--------------------------------------------------------------------------*
*-------------------------- ASL-File/Dir-Requester --------------------------*
*---- Input :	a0=ASL_FileRequester-Title				-----*
*----		a1=Dir-Path						-----*
*----		a2=FileName						-----*
*----		a3=Window						-----*
*----		d0 = Bit 0 = 1  SelectDir				-----*
*----			     0  SelectFile				-----*
*----		     Bit 1 = 1  MultiSelect				-----*
*----		d1=0-> internal Puffer/0<>external Puffer		-----*
*---- OutPut:	d0=0 -> Cancel/Error					-----*
*----		d0=1 -> Ok gedrckt					-----*
*----------------------------------------------------------------------------*
.AslLibrary:	La0	LNr_Fr_LoadModule
		lea	DirPuffer(a5),a1
		lea	FilePuffer(a5),a2
		move.l	UPrg_WinHandle(a5),d0
		bne.s	.ASLWin
		jsr	A5GetMainWindowHandle(a5)
.ASLWin:	move.l	d0,a3
		moveq	#2,d0				;Multiselect Files
		moveq	#0,d1				;internal Puffer
		bsr.w	ASL_Request
		move.l	d0,d7
		bne.s	.ItsAll
		cmp.l	#1,d1
		bhi.s	.FileReqOk
	;
	;

	*------ aktuelles Directory einladen -----*
.LoadDirNow:	clr.b	OnMultiSelectIn(a5)
		;lea	DirPuffer(a5),a1
		;jsr	A5MakeCorrectDir(a5)

	*------------ Testen. ob LHA-Archiv ausgewhlt wurde ---------*
		tst.b	KeyOn(a5)
		beq.s	.NoLHADir
		lea	DirPuffer(a5),a0
		move.l	a0,LoadFilePath(a5)
		lea	FilePuffer(a5),a2
		jsr	A5CreateLoadPath(a5)
		lea	PathPuffer(a5),a0
		jsr	A5TestAufArchive(a5)
		bne.s	.NOLHADir		
		tst.b	OnExtractFirstModule(a5)
		bne.s	.NoLHADir

		lea	PathPuffer(a5),a0
		lea	DirPuffer(a5),a1
		move.w	#DirPufferSize-2,d1
		jsr	A5StringCopy2(a5)

.NoLHADir:	jsr	A5LoadDirIn(a5)
		tst.b	OnLHAInMenu(a5)
		beq.s	.FileReqOk
		clr.b	FilePuffer(a5)
		moveq	#EPR_ArchiveScanned,d7
		bra.s	.FileReqOk2

	*----------- Filerequester beenden -------*
.FileReqOK:	moveq	#0,d7			;kein Error
.FileReqOk2:	lea	DirPuffer(a5),a0
		jsr	A5KillLastSchraeg(a5)
		jsr	A5SetDirJumpPtr(a5)

	;	lea	DirPuffer(a5),a1
	;	jsr	A5MakeCorrectDir(a5)	;wegen LHA weggenommen, testen

.ItsAll:	;cmp.w	#EPR_FilereqCancelled,d7	;Fehler
		;bne.s	.NoHelpAddr
		tst.b	OnMultiSelectIn(a5)	;bei MultiSelect darf Dir nicht
		bne.s	.NoHelpAddr		;gendert werden
		move.l	LHAFileRequestAddr(a5),d0	;wird bei FreeDirPuffer
		beq.s	.NoHelpAddr			;gelscht
		move.l	d0,a0
		move.b	LHAFileRequestByte(a5),(a0)

.NoHelpAddr:	move.l	d7,d0
		movem.l	(a7)+,d1-a6
		tst.l	d0			;0=Ok / sonst Fehler
		rts


*---------------------- FileRequester2 (ohne LoadDir-Funktion) --------------*
*----- Input:	a0 = FileRequester-Title				-----*
*-----		a1 = Directorypath					-----*
*-----		a2 = Filename						-----*
*-----		a3 = Window						-----*
*-----		d0 = Bit 0 = 1  SelectDir				-----*
*-----			     0  SelectFile				-----*
*-----		     Bit 1 = 1  MultiSelect				-----*
*----- OutPut:	d0 = 0=Fehler, sonst OK					-----*
*-----		d1 = Anzahl der Files					-----*
*-----		a0 = MultiSelectAdr					-----*
*----------------------------------------------------------------------------*
FileRequest2:	movem.l	d2-d7/a1-a6,-(a7)
		moveq	#EPR_FileReqCancelled,d7	;Fehler
		cmp.l	#Mode_Config,TestBits(a5)
		beq.w	.ItsAll
		tst.b	OnFilereqVerbot(a5)
		bne.w	.ItsAll

		move.l	a0,FR_Title(a5)
		move.l	a1,FR_Dir(a5)
		move.l	a2,FR_Filename(a5)
		move.l	a3,FR_WinHandle(a5)
		move.l	d0,FR_Flags(a5)
		moveq	#0,d6				;Anzahl bei MultiSelect
		move.l	d0,d5				;Flags

	*------------ Auf FileRequester testen ------------*
		moveq	#0,d0
		move.b	FileReqMode(a5),d0
		cmp.b	#EPNrF_Req,d0
		beq.s	.ReqLibrary
		cmp.b	#EPNrF_ReqTools,d0
		beq.w	.ReqToolsLibrary
		cmp.b	#EPNrF_Asl,d0
		beq.w	.AslLibrary
		bra.w	.ItsAll

*------------------- FileRequester (Req.Library) ---------------------------*
.ReqLibrary:	moveq	#$14,d1
		btst	#0,d5
		beq.s	.ReqLibFile
		move.w	#$2014,d1
.ReqLibFile:	btst	#1,d5
		beq.s	.NoMulti
		bset	#1,d1				;MultiSelect-Flag
.NoMulti:	lea	ReqFileRequester2,a4
		move.l	a1,ReqDirOffset(a4)		;DirBuffer setzen
		move.l	a2,ReqFileOffset(a4)		;FileBuffer setzen
		move.l	a0,2(a4)			;Title Namen setzen
		move.w	d1,PlFlags-ReqFileRequester2+2(a4) ;Flags setzen
		move.l	a3,ReqPathOffset+4(a4)		;WinHandle setzen
		move.l	a4,a0
		move.l	EPG_ReqBase(a5),d2
		beq.w	.ItsAll
		move.l	d2,a6
		jsr	_LVOFileRequest(a6)
		sub.l	a0,a0			;MultiSelectPuffer
		tst.l	d0
		beq.w	.ItsAll


*----- Einen Puffer initialisieren, der die Multiselecteintrge bernimmt ----*
*----	Input:	a0 = Zeiger auf Multiselect				  ----*
*----		d0 = Filerequester 10=App 11=Arexx ;Sonst Mode in D0	  ----*
*----		d1 = Size of String (Arexx...)				  ----*
*----		d2 = Use Internal Puffer (0=jes)			  ----*
*----	Ouput:	d0 = Anzahl der Eintrge				  ----*
*----		a0 = PufferAdr						  ----*
*-----------------------------------------------------------------------------*
	*------- CreateFilesPuffer -------*
		btst	#1,d5
		beq.w	.FileReqOk
		move.l	Req_MultiAdr2,d0
		beq.w	.FileReqOk
		move.l	d0,a0			;MultiSelectZeiger
		moveq	#1,d0			;Filereq "Req"
		move.l	a4,d1			;Para
		moveq	#1,d2			;external Puffer
		jsr	A5CreateFilesPuffer(a5)	;Selectierte Dateien ins PMenu
		move.l	d1,d6
		bra.w	.FileReqOk

*------------------------- Filerequester per ReqTools -----------------------*
;   STRUCTURE rtFileList,0
;      APTR  rtfl_Next
;      ULONG rtfl_StrLen
;      APTR  rtfl_Name
;      LABEL rtFileList_SIZE
.ReqToolsLibrary:move.l	EPG_ReqToolsBase(a5),d0
		beq.w	.ItsAll
		move.l	d0,a6
	*------------ Dir festlegen --------------*
		lea	ReqToolsTags2_2(pc),a0
		move.l	FR_Dir(a5),a1
		move.l	a1,4(a0)
		move.l	ReqToolsAdr2(a5),d0
		beq.w	.ItsAll
		move.l	d0,a1
		jsr	_LVORtChangeReqAttrA(a6)


	*-------- File-Requester ausfhren -------*
		move.l	FR_FileName(a5),a0	;alten Filenamen kopieren
		lea	PathPuffer(a5),a1
		move.l	a1,a2
		jsr	A5StringCopy(a5)


	*-- Flags fr das Filerequester setzen ---*
		moveq	#8,d1			;DirAuswahl
		btst	#0,d5
		bne.s	.ReqToolsNoFile
		moveq	#0,d1			;Files und kein Multi
.ReqToolsNoFile:btst	#1,d5
		beq.s	.ReqToolsNoMulti
		moveq	#1,d1			;MultiSelect-Flag fr Dirs
.ReqToolsNoMulti:lea	ReqToolsTags2(pc),a0		;Tag-Liste
		move.l	d1,12(a0)
		move.l	FR_WinHandle(a5),4(a0)	;WinHandle setzen
		move.l	Fr_Title(a5),a3
		move.l	a3,d0
		bne.s	.ReqToolsTitle
		LA3	LNr_Fr_LoadModule
.ReqToolsTitle:	lea	PathPuffer(a5),a2
		move.l	ReqToolsAdr2(a5),a1
		jsr	_LVORTFileRequestA(a6)

	*---- Dirnamen kopieren, falls nicht cancelled--*
		move.l	d0,-(a7)
		tst.l	d0
		beq.s	.ReqToolsCan


	*------ Filenamen kopieren, falls erwnscht -----*
		tst.l	FR_Flags(a5)		;nur wenn normal Filename
		bne.s	.ReqToolsCan2
		lea	PathPuffer(a5),a0
		move.l	FR_Filename(a5),a1
		jsr	A5StringCopy(a5)

.ReqToolsCan2:	move.l	ReqToolsAdr2(a5),a1	;DirPuffer kopieren !!!
		move.l	16(a1),a0
		move.l	FR_Dir(a5),a1
		move.w	#DirPufferSize-2,d1
		jsr	A5StringCopy2(a5)


.ReqToolsCan:	;clr.b	PathPuffer(a5)
;		move.l	ReqToolsAdr2(a5),a1
;		jsr	_LVORtFreeReqBuffer(a6)
		move.l	(a7)+,d0
		tst.l	d0
		beq.s	.ItsAll			;Cancelled !!!

	*-- Testen, ob wirklich Mehrfachauswahl --*
		move.l	FR_Flags(a5),d1
		btst	#0,d1
		bne.s	.FileReqOk		;Dir-Auswahl
		btst	#1,d1
		beq.s	.FileReqOk		;Kein MultiSelect

		sub.l	a0,a0			;Kein Puffer !!!
		moveq	#0,d7			;kein Error
		move.l	d0,a3
		tst.l	(a3)
		beq.s	.FreeReqToolsList	;nur ein File selected ?

	*------- CreateFilesPuffer -------*
		move.l	d0,a0			;MultiSelectZeiger
		moveq	#2,d0			;Filereq "ReqTools"
		move.l	a4,d1			;Para
		moveq	#1,d2			;external Puffer
		jsr	A5CreateFilesPuffer(a5)	;Selectierte Dateien ins PMenu
		move.l	d1,d6			;Anzahl der Files
		move.l	d0,d7			;Fehler ???

.FreeReqToolsList:move.l a0,-(a7)		;Adr fr MultiSelectPuffer
		move.l	4(a3),d1
		move.l	8(a3),a0		;Filenamen kopieren
		move.l	FR_FileName(a5),a1
		jsr	A5StringCopy2(a5)
		move.l	a3,a0
		jsr	_LVORTFreeFileList(a6)
		move.l	(a7)+,a0
		bra.s	.FileReqOk


*-------------------------- ASL-File/Dir-Requester --------------------------*
*---- Input :	a0=ASL_FileRequester-Title				-----*
*----		a1=Dir-Path						-----*
*----		a2=FileName						-----*
*----		a3=Window						-----*
*----		d0 = Bit 0 = 1  SelectDir				-----*
*----			     0  SelectFile				-----*
*----		     Bit 1 = 1  MultiSelect				-----*
*----		d1=0-> internal Puffer/0<>external Puffer		-----*
*---- OutPut:	d0=0 -> Cancel/Error					-----*
*----		d0=1 -> Ok gedrckt					-----*
*----------------------------------------------------------------------------*
.AslLibrary:	move.l	Fr_Title(a5),a0
		move.l	a0,d0
		bne.s	.ASLTitle
		LA0	LNr_Fr_SelectFile
.ASLTitle:	move.l	FR_Dir(a5),a1
		move.l	FR_Filename(a5),a2
		move.l	FR_WinHandle(a5),a3
		move.l	FR_Flags(a5),d0
		moveq	#1,d1			;external Puffer
		bsr.w	ASL_Request
		move.l	d1,d6
		move.l	d0,d7
		bne.s	.ItsAll
		

	*------------- Filerequester verlassen ---------*
.FileReqOk:	moveq	#0,d7			;kein Error
.ItsAll:	move.l	d6,d1			;Anzahl beim Multiselect
		move.l	d7,d0			;FehlerNr
		movem.l	(a7)+,d2-d7/a1-a6
		jsr	A5MakeCorrectDir(a5)
		tst.l	d0
		rts

	*--------------- ReqToolsTags fr Filerequester 1 -----------*
ReqToolsTags:	dc.l	$80000001		;Window-Pointer
		dc.l	0
		dc.l	$80000000+40		;FileRequest-Flags
		dc.l	$10!$1			;Select Files
		dc.l	0,0
ReqToolsTags_2:	dc.l	$80000000+50		;New Dir
		dc.l	0,0

	*--------------- ReqToolsTags fr Filerequester 2 -----------*
ReqToolsTags2:	dc.l	$80000001		;Window-Pointer
		dc.l	0
		dc.l	$80000000+40		;FileRequest-Flags
		dc.l	$1			;Select Files
		dc.l	0
ReqToolsTags2_2:dc.l	$80000000+50		;New Dir
		dc.l	0,0

*---------------------------- Make Correct-Dir ------------------------------*
*----- Corrigiert den Dirnamen so, da Filenamen nur rankopiert werden ------*
*----- >-- a1=Diradresse						-----*
*----------------------------------------------------------------------------*
MakeCorrectDir:	move.l	a1,-(a7)
		tst.b	(a1)
		beq.s	.NoSchraeg
.NextB:		tst.b	(a1)+
		bne.s	.NextB
		subq.l	#2,a1
		cmp.b	#":",(a1)
		beq.s	.NoSchraeg
		cmp.b	#"/",(a1)+
		beq.s	.NoSchraeg
		move.b	#"/",(a1)+
		clr.b	(a1)
.NoSchraeg:	move.l	(a7)+,a1
		rts

*----------------------------------------------------------------------------*
KillLastSchraeg:movem.l	d0/a0,-(a7)
		jsr	A5BerechStringSize(a5)
		lea	-1(a0,d0.w),a0
		cmp.b	#"/",(a0)
		bne.s	.NoSchreag
		clr.b	(a0)
.NoSchreag:	movem.l	(a7)+,d0/a0
		rts



*---------------------------- Make Correct-Dir ------------------------------*
*---------------- Berechnet die Gre des Strings in a0 ---------------------*
*------- >= a0=String							-----*
*------- => d0=Stringsize						-----*
*----------------------------------------------------------------------------*
BerechStringSize:move.l a0,-(a7)
		moveq	#0,d0
		cmp.l	d0,a0
		beq.s	.NoTest
		moveq	#-1,d0
.NextB:		addq.l	#1,d0
		tst.b	(a0)+
		bne.s	.NextB
.NoTest:	move.l	(a7)+,a0
		tst.l	d0
		rts

*---------------------------- Make Correct-Dir ------------------------------*
*---------------- Berechnet die Gre des Strings in a0 ---------------------*
*------- >= a0=String							-----*
*------- => d0=Stringsize						-----*
*----------------------------------------------------------------------------*
BerechStringSize2:move.l a0,-(a7)
		moveq	#0,d0
		cmp.l	d0,a0
		beq.s	.NoTest
		moveq	#-1,d0
.NextB:		addq.l	#1,d0
		cmp.b	#20,(a0)+
		bhs.s	.NextB
.NoTest:	move.l	(a7)+,a0
		tst.l	d0
		rts





*-------------------------- ASL-File/Dir-Requester --------------------------*
*---- Input :	a0=ASL_FileRequester-Title				-----*
*----		a1=Dir-Path						-----*
*----		a2=FileName						-----*
*----		a3=Window						-----*
*----		d0 = Bit 0 = 1  SelectDir				-----*
*----			     0  SelectFile				-----*
*----		     Bit 1 = 1  MultiSelect				-----*
*----		d1=0-> internal Puffer/0<>external Puffer		-----*
*----		d7=Default ErrorNr					-----*
*---- OutPut:	d0=0 -> Cancel/Error					-----*
*----		d0=1 -> Ok gedrckt					-----*
*----------------------------------------------------------------------------*
ASL_Request:	movem.l	d2-d7/a1-a6,-(a7)
		moveq	#0,d6
		lea	ASL_Tags(pc),a4			;TagListe sichern
		move.l	a0,12(a4)			;WindowTitle setzen
		move.l	a1,20(a4)			;DirPath setzen
		move.l	a2,28(a4)			;Filenamen setzen
		move.l	a3,4(a4)			;WindowPointer
		move.l	d1,d4
		move.l	d0,d5
		moveq	#0,d2	;1=mit Patterngadget
		btst	#1,d0
		beq.s	.NoMulti
		moveq	#8,d2	;9=mit PatternGadget	;Multiselect an
.NoMulti:	move.l	d2,36(a4)			;MultiSelect ????
		moveq	#1,d2				;Tag_Ignore
		move.l	#$80080008,d3
		btst	#0,d0
		beq.s	.NoDir
		move.l	#$80080016,d2
		moveq	#1,d3				;Tag_Ignore
.NoDir:		move.l	d2,40(a4)			;File or Dir ????
		move.l	d3,24(a4)			;Tag fr Filename
		moveq	#37,d0
		lea	DTG_AslBase(a5),a3
		LA1	LNr_AslName
		jsr	A5OpenLib(a5)
		beq.s	.NoASL_Struct
		move.l	d0,a6

		move.l	a4,a0
		moveq	#0,d0				;Type = FileRequester
		jsr	_LVOAllocAslRequest(a6)
		tst.l	d0
		move.l	d0,a3				;ASLRequesterStructure
		beq.s	.NoASL_Struct

		move.l	d0,a0
		move.l	a4,a1
		jsr	_LVOAslRequest(a6)
		moveq	#0,d6			;Anzahl der Files bei Multi
		sub.l	a4,a4			;MultiSelect Adr
		tst.l	d0			;Ergebnis merken
		beq.s	.Error

	*-------- Wurde MultiSelect benutzt ----------*
		moveq	#0,d7			;Kein Error
		move.l	4(a3),a0		;Selected File
		btst	#0,d5
		bne.s	.NoFile
		move.l	ASL_Tags+28(pc),a1
		jsr	A5StringCopy(a5)	;Filename copieren
.NoFile:	move.l	8(a3),a0		;Selected Dir
		move.l	ASL_Tags+20(pc),a1
		move.w	#DirPufferSize-2,d1
		jsr	A5StringCopy2(a5)	;Filename copieren
		moveq	#1,d6
		move.l	32(a3),d0
		cmp.l	#1,d0
		bls.s	.Error
		move.l	d0,d1			;Anzahl der Argumente

	*------- Bei MultiSelect Puffer fllen -------*
	*------- CreateFilesPuffer -------*
		btst	#1,d5			;MultiSelect
		beq.s	.Error
		moveq	#EPR_ErrorInArguments,d7
		move.l	d4,d2			;external/internal Puffer
		move.l	36(a3),d0
		beq.s	.Error
		move.l	d0,a0			;MultiSelectZeiger
		moveq	#3,d0			;Filereq "ASL"
		jsr	A5CreateFilesPuffer(a5)	;Selectierte Dateien ins PMenu
		move.l	d1,d6			;Anzahl der Files
		move.l	d0,d7			;Fehler ???
		move.l	a0,a4			:MultiSelectAdr


.Error:		move.l	a3,a0				;ASLRequesterStructure
		jsr	_LVOFreeAslRequest(a6)
		move.l	d7,d0
.NoASL_Struct:	move.l	a4,a0
		move.l	d6,d1			;Anzahl der Files bei Multi
		movem.l	(a7)+,d2-d7/a1-a6
		tst.l	d0
		rts


	*------- ASL-Tags fr FileRequester ------*
ASL_Tags:	dc.l	$80080002,0		;Ptr to Window		 4
		dc.l	$80080001,0		;Pointer to WindowName	 12
		dc.l	$80080009,0		;Ptr to Dirname		 20
		dc.l	$80080008,0		;Ptr to Filename	 28
		dc.l	$80080014,0	8	;Fkt Flags (MultiSelect) 36
		dc.l	$80080016,1		;Ext Flags (no files)	 44
		dc.l	$80080005,200		;Widht			 52
		dc.l	$80080006,200		;Height			 60
	;	dc.l	$8008000a,HideIt	;ASL_Pattern		 68
		dc.l	0




*---------------------------------------------------------------------------*
FreeOldFileReq:	movem.l	d0-a6,-(a7)
		moveq	#0,d0
		move.b	FileReqMode(a5),d0
		cmp.b	#EPNrF_Req,d0
		beq.s	.CloseReq
		cmp.b	#EPNrF_ReqTools,d0
		beq.s	.CloseReqTools
		cmp.b	#EPNrF_Asl,d0
		beq.w	.CloseAsl
		bra.w	.Ok

	*------ Req-Filerequester freigeben -------*
.CloseReq:	lea	ReqPuffer,a0
		move.l	EPG_ReqBase(a5),d0
		beq.s	.NoReq
		move.l	d0,a6
		jsr	_LVOPurgeFiles(a6)
		lea	ReqFileRequester2,a0
		jsr	_LVOPurgeFiles(a6)
	*-- Alten ReqPuffer ordentlich initialisieren --*
.NoReq:		lea	Req_Clr1,a4
		move.l	a4,a1
		clr.b	(a1)
		lea	1(a4),a0
		move.w	#ReqFileRequester2-Req_Clr1-2,d1
		jsr	A5CopyText2(a5)

		lea	Req_Clr2-Req_Clr1(a4),a4
		move.l	a4,a1
		lea	1(a4),a0
		move.w	#ReqFileRequester2-Req_Clr1-2,d1
		jsr	A5CopyText2(a5)


		clr.l	Req_MultiAdr1-Req_Clr2(a4)
		clr.l	Req_MultiAdr2-Req_Clr2(a4)
		lea	EPG_ReqBase(a5),a0
		jsr	A5CloseLib(a5)
		bra.s	.Ok

	*---- ReqTools-Filerequester freigeben ----*
.CloseReqTools:	move.l	EPG_ReqToolsBase(a5),d0
		beq.s	.NoReqTools
		move.l	d0,a6

	*------ File-Requester-Struktur freigeben ****
		move.l	ReqToolsAdr11(a5),d0
		beq.s	.ReqToolsNo1
		move.l	d0,a1

;		jsr	_LVORTFreeReqBuffer(a6)
;	*--------- Struktur-Speicher freigeben -------*
;		move.l	ReqToolsAdr1(a5),a1

		jsr	_LVORTFreeRequest(a6)

	*------ File-Requester-Struktur freigeben ****
.ReqToolsNo1:	move.l	ReqToolsAdr2(a5),d0
		beq.s	.NoReqTools
		move.l	d0,a1

;		jsr	_LVORTFreeReqBuffer(a6)
;	*--------- Struktur-Speicher freigeben -------*
;		move.l	ReqToolsAdr2(a5),d0
;		beq.s	.NoReqTools
;		move.l	d0,a1

		jsr	_LVORTFreeRequest(a6)
.NoReqTools:	clr.l	ReqToolsAdr11(a5)
		clr.l	ReqToolsAdr2(a5)
		lea	EPG_ReqToolsBase(a5),a0
		jsr	A5CloseLib(a5)
		bra.s	.Ok


	*------ ASL-Filerequester freigeben -------*
.CloseASL:	lea	DTG_ASLBase(a5),a0
		jsr	A5CloseLib(a5)


	*-------- FilerequesterMode lschen -------*
.Ok:		jsr	A5ClearMenuStrip(a5)
		clr.b	FileReqMode(a5)
		jsr	A5SetMenuStrip(a5)
		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Ermittelt, ob im Comment des Files ein StartSong angegeben ist
*-----------------------------------------------------------------------------*
* Input: a0=Infoblock
* Output:d0=Startsong bzw. 0
*-----------------------------------------------------------------------------*
GetStartSong:	movem.l	d1-a6,-(a7)
		lea	144(a0),a0
		moveq	#0,d0
		cmp.b	#"S",(a0)
		bne.s	.Return
		cmp.b	#"S",1(a0)
		bne.s	.Return
		cmp.b	#"=",2(a0)
		beq.s	.NimmSong
		cmp.b	#":",2(a0)
		bne.s	.Return

.NimmSong:	lea	3(a0),a0
		jsr	A5Getnumber(a5)	;Zeichenkette in Long-Zahl umwandeln
		beq.s	.Ok
		moveq	#0,d1
.Ok:		move.l	d1,d0	
.Return:	movem.l	(a7)+,d1-a6
		rts







*------ offset,size,offset to chk, offset im puffer+1652,decodeoffs ------*
AT:
 dc.w	EPKF_VornameOffs,EPKF_VNameSize,EPKF_VornameChk,KeyVornamePuffer-(TextPuffer-1652)
 dc.w	EPKF_V2DecodeK
 dc.w	EPKF_NachNameOffs,EPKF_NachNameSize,EPKF_NachNameChk,KeyNamePuffer-(TextPuffer-1652)
 dc.w	EPKF_V1DecodeK
 dc.w	EPKF_StreetOffs,EPKF_StreetSize,EPKF_StreetChk,KeyStreetPuffer-(TextPuffer-1652)
 dc.w	EPKF_V3DecodeK
 dc.w	EPKF_OrtOffs,EPKF_OrtSize,EPKF_OrtChk,KeyOrtPuffer-(TextPuffer-1652)
 dc.w	EPKF_V2DecodeK
 dc.w	EPKF_PlzOffs,EPKF_PlzSize,EPKF_PlzChk,KeyPlzPuffer-(TextPuffer-1652)
 dc.w	EPKF_V3DecodeK
 dc.w	EPKF_CountryOffs,EPKF_CountrySize,EPKF_CountryChk,KeyCountryPuffer-(TextPuffer-1652)
 dc.w	EPKF_V1DecodeK
 dc.w	EPKF_TelefonOffs,EPKF_TelefonSize,EPKF_TelefonChk,KeyTelefonPuffer-(TextPuffer-1652)
 dc.w	EPKF_V2DecodeK




*-------------- Offset to Next Test, TestOffset, GuruOffset ----------------*
* nur Wortsprnge testen
KeyTestTab:
*		KEYTABM		.SM2,KEY_KM_SaveModule_TBA51,Return
*		KEYTABM2	KTBA5
*		KEYTABM2	KeyOn
*		KEYTABM2	KBE
*		KEYTABM2	(FunctionNotimplemented-KEY_KM_SaveModule_TBA51-6)
*
*.SM2:		KEYTABM		.SM3,KEY_KM_SaveModule_TBA02,Return
*		KEYTABM2	KTBA0
*		KEYTABM2	(KeyOn-WindowOffen)
*		KEYTABM2	KBE
*		KEYTABM2	(ScrollNewFehler-KEY_KM_SaveModule_TBA02-6)
		

.SM3:		KEYTABM		.SM4,KEY_SaveModule_TBA53,Return
		KEYTABM2	KTBA5
		KEYTABM2	KeyOn
		KEYTABM2	KBE
		KEYTABM2	(FunctionNotimplemented-KEY_SaveModule_TBA53-6)

.SM4:		KEYTABM		.Ende,KEY_SaveModule_TBA14,Return
		KEYTABM2	KBE
		KEYTABM2	(DeleteFile-Key_SaveModule_TBA14-2)



.Ende		KEYTABM		.Ende,Return,Return	;Ende !!!





*---- Nummer des Keys = W1+17643-W2+54831
DisabledKeys:
		*dc.w	13-17643+6751,6751-54831	;Kostanikow
		dc.w	-10879,$4430

		*dc.w	87-17643+6751,6751-54831	;Boxterberg
		dc.w	-10805,$4430

		*dc.w	86-17643+13712,13712-54831	;Michael Kleps
		dc.w	86-17643+13712,$5f61		;Michael Kleps

		*dc.w	30014-17643+13712,13712-54831
		dc.w	30014-17643+13712,$5f61

		*dc.w	30015-17643+463,463-54831
		dc.w	30015-17643+463,$2ba0

		*dc.w	30020-17643+400,400-54831	;AmigaInside-CD
		dc.w	30020-17643+400,$2b61		;AmigaInside-CD

		*dc.w	30016-17643+15,15-54831
		dc.w	30016-17643+15,$29e0

		*dc.w	30017-17643+(-1031),-1031-54831
		dc.w	30017-17643+(-1031),$25ca

		*dc.w	30008-17643+(-1234),-1234-54831	;Cliff !
		dc.w	30008-17643+(-1234),$24ff	;Cliff !

		*dc.w	300-17643+(-4312),-4312-54831	
		dc.w	300-17643+(-4312),$18f9	

		*dc.w	300-17643+(-312),-312-54831
		dc.w	307-17643+(-312),$2899

		*dc.w	184-17643+(-2114),-2114-54831	;Steen Busgaard, wanderte durch
		dc.w	184-17643+(-2114),$218F		;diverse Crackboxen

		*dc.w	30010-17643+(-4000),-4000-54831	;Eagleeye
		dc.w	30010-17643+(-4000),$1a31

		*dc.w	30013-17643+(-356),-356-54831	;Ihli
		dc.w	30013-17643+(-356),$286d

		*dc.w	30400-17643+(2412),2412-54831	;Widrat Lars
		dc.w	30400-17643+(2412),$333d

		*dc.w	30018-17643+(-623),-623-54831	;Roloff
		dc.w	30018-17643+(-623),$2762

		*dc.w	31054-17643+(-1567),-1567-54831	;Club
		dc.w	31054-17643+(-1567),$23b2

		*dc.w	280673-17643+(-1287),-1287-54831 ;Buggs
		dc.w	$4861-17643+(-1287),$24ca	*entspricht auch 18529

		*dc.w	100000-17643+(1592),1592-54831 ;Buggs 2
		dc.w	$86a0-17643+(1592),$3009	*entspricht auch 34464

		*dc.w	30001-17643+(1734),1734-54831 ;Copper
		dc.w	30001-17643+(1734),$3097


		*dc.w	0-17643+(-4312),-4312-54831	;Ende
		dc.w	0-17643+(-4312),$18f9		;Ende




*------------------ kleiner Scherz am Rande -----------------------------*
ChangeA6_3:	movem.l	d0-a6,-(a7)
		link	a1,#4
		lea	40(a1),a2
		move.l	A5JumpTo+2(a5),a0
		lea	FindTaskDummy-Jumpto+294(a0),a0
		move.l	a0,20(a2)		294=_LVOFindTask
		unlk	a1
		movem.l	(a7)+,d0-a6
		rts

*------------------------ Unterprogramm-Tabelle ---------------------------*
A5UnterPrgTab:
		JTM	ClearCache
		JTM	ClearMouse
		JTM	ClearMouse2
		JTM	WaitMouse
		JTM	OpenLib
		JTM	CloseLib
		JTM	HelpMe
		JTM	Help2
		JTM	HelpLink2
		JTM	Documentation2
		JTM	GibArg
		JTM	CloseHelp
		JTM	CloseWorkbenchLib
		JTM	SendeAllScrollMessage
		JTM	SendeAllPrintMessage
		JTM	ScrollNew
		JTM	ScrollNewText
		JTM	ScrollNewFehler
		JTM	MakeCorrectText
		JTM	SetCiaBTimer
		JTM	CloseCiaBTimer
		JTM	FreeOldModule
		JTM	PrintText
		JTM	FileRequest
		JTM	FileRequest2
		JTM	FontRequest
		JTM	MakeCorrectDir
		JTM	SetTimer
		JTM	EPP_SaveMem
		JTM	HexDez
		JTM	HexDez2
		JTM	SetOldDir
		JTM	IOErr
		JTM	Delay
		JTM	Delay3
		JTM	LoadFile
		JTM	TestAufDisabledKeys
		JTM	LoadFile2
		JTM	LoadThis
		JTM	NewExtLoad
		JTM	LoadModule
		JTM	LoadStructModule
		JTM	LoadEngineSegment
		JTM	AllesRaus
		JTM	TitleAufbau
		JTM	Iconify
		JTM	AddApps
		JTM	RemoveApps
		JTM	SetWindowZustand
		JTM	OpenMainWindow
		JTM	CloseMainWindow
		JTM	PlaySampleEndAudstruct
		JTM	PlaySampleRestoreModule
		JTM	GetStartSong

		JTM	FindTag
		JTM	FindTag2
		JTM	CallUp
		JTM	CallUp3
		JTM	UserCallUp3
		JTM	UserCallUp4
		JTM	UserCallUp5
		JTM	UserFindTag
		JTM	DecodeD0
		JTM	DeletePlayer2
		JTM	DeleteAll2
		JTM	InsertInList
		JTM	SetTableLocale
		JTM	JaGuru
		JTM	LoadDefaultGui
		JTM	Engine
		JTM	CopyText
		JTM	CopyText2
		JTM	CopyFileName
		JTM	CopyLoadedFileToNew
		JTM	KeyChangeInit
		JTM	StringCopy
		JTM	StringCopy2
		JTM	CopySendText
		JTM	TestAufArchive
		JTM	TestAufsteigendArchive
		JTM	TestJumpDir
		JTM	SetDirJumpPtr
		JTM	Key_RoutinenTester
		JTM	InitCommodity
		JTM	CloseCommodity
		JTM	ClearMenuStrip
		JTM	SetMenuStrip
		JTM	EnableMenu
		JTM	DisableMenu
		JTM	InitMenus
		JTM	FreeMenus
		JTM	RefreshMenu
		JTM	SaveNachT
		JTM	ClearEngineZustand
		JTM	SetEngineZustand
		JTM	SetMutalExclude
		JTM	InitScreenNotify
		JTM	EndScreenNotify
		JTM	ScreenNotifyMessage

		JTM	EnableAll
		JTM	DisableAll

		JTM	NervRequest1
		JTM	NervRequest2

		JTM	GetMenuItemAdr		;Windowroutinen
		JTM	GuiChanged		;Windowroutinen

		*JTM	ModuleChanged
		*JTM	DirChanged
		JTM	MakeEPGSongName
		JTM	KeyTestReturn
		JTM	SendeOneMessage
		JTM	SendeAllMessage
		JTM	SendeAllMessage2
		JTM	WaitUserPorts
		JTM	TestUserAndQuit
		JTM	DeleteEngine
		JTM	DeleteAllEngines
		JTM	FreeAllEngineStructs
		JTM	WriteEnginePrefsToUPrg
		JTM	FindEUSStruct
		JTM	FindUserStruct
		JTM	InsertEngineNodeName
		JTM	InsertPlayerInList
		JTM	GetPlayerName
		JTM	FindFreeUserNr
		JTM	ClearUserMessage
		JTM	InsertStructAdr
		JTM	InsertModulesList
*		JTM	RefreshUserMenu
		JTM	FindFileName
		JTM	EPP_TextRequest
		JTM	CopyTextToArexxPuffer
		JTM	LoadDirIn
		JTM	LoadPlayerBatch
		JTM	SortAmplifiers
		JTM	LoadStartEngines
		JTM	CheckLoadVerbot
		JTM	InitEngineVerbot
		JTM	EndEngineVerbot
		JTM	FindUserASCStruct

		JTM	NervRequestCounter

		JTM	KillLastSchraeg
		JTM	CreateFilesPuffer
		JTM	RescanDir
		JTM	FreeDirPuffer
		JTM	FreeConfigDir
		JTM	LoadProgrammModule
		JTM	LoadNeededPlayer
		JTM	UpdateDeliEmu
		JTM	CreateLoadPath
		JTM	CreateDirAusPath
		JTM	FreeLFModule
		JTM	AllocMem
		JTM	DecodeD02
		JTM	ClearSS_Struct

		JTM	ClearTextWindow
		JTM	GetFilename
		JTM	GetFilename2
		JTM	GetFilename3
		JTM	GetPassword
		JTM	GetStringGadget
		JTM	BerechStringSize
		JTM	BerechStringSize2
		JTM	ScreenToFront
		JTM	WindowToFront
		JTM	KeyTestAufEngine
		JTM	GetPassword2
		JTM	LoadProgrammList
		JTM	LoadList

		JTM	AddAbortGadget
		JTM	KeyFehler
		JTM	GetAbortMsg
		JTM	RemoveAbortGadget
		JTM	TestAufFaults

		JTM	Key_DecKeyFile1
		JTM	Key_DecKeyFile2
		JTM	ClearProTemps
		JTM	Key_DecKeyFile3
		JTM	FreeAudio
		JTM	Key_EndC
		JTM	AllocAudio
		JTM	Key_Verl11
		JTM	Key_Chk1
		JTM	CopyMemQuick
		JTM	Key_Verl12
		JTM	Key_Verl13

		JTM	LoadAppIcon
		JTM	FreeAppIcon

		JTM	StartInterrupt
		JTM	StopInterrupt
		JTM	StopInterrupt2
		JTM	StartNotify
		JTM	EndNotify
		JTM	KeyTestNext
		JTM	SetFileReqMode
		JTM	Return
		JTM	FreeOldFileReq

		JTM	TestAufCrmFile

	*------ New
		JTM	GetLocaleStringA0
		JTM	GetLocaleStringA1
		JTM	GetLocaleStringA2
		JTM	GetLocaleStringA3
		JTM	GetLocaleStringd0
		JTM	GetLocaleString
		JTM	FirstLocaleInit

		JTM	InitCrunchDisplay
		JTM	FillCrunchDisplay
		JTM	RemoveCrunchDisplay

		JTM	ActivateAUser
		JTM	DeActivateAUser
		JTM	GetMainWindowHandle
		JTM	GetMainWindowTags
*		JTM	GetPlWindowHandle
		JTM	PlayerChecker
		JTM	UserCallUp
		JTM	StrCmp
		JTM	StrCmp2
		JTM	StrCmp3
		JTM	DezHex
		JTM	GetNumber
		JTM	ParentDir
		JTM	ParentArchiveDir
		JTM	ExtractArchiveEntry
		JTM	ExtractFirstArchiveEntry
*		JTM	ExtraktFirstLHA
		JTM	Warten
		JTM	WartenReplayPort

		JTM	CopyMessage2
*		JTM	InsertDebuggerEUS
		JTM	LoadAutoDir
		JTM	LoadEngine
		JTM	WaitForStartMsg
		JTM	LoadPlayer
		JTM	LoadPlayer2
		JTM	SetOldDir2
*		JTM	RefreshModulesMenu
*		JTM	SetUserConfig
		JTM	SaveConfigText
		JTM	CopyZahlToArexxPuffer
*		JTM	ADDEngine2
*		JTM	AddUser2
		JTM	LoadOnePlayer
		JTM	AllocMem2
		JTM	FreeMem
		JTM	FreeCliStruct
		JTM	EndSound
		JTM	InitSound
		JTM	FreeLoadModule
		JTM	FreeLoadModule2
		JTM	LadeLFModule
		JTM	LFModuleLoaded
		JTM	CreatePlayname
		JTM	AllesRaus2
		JTM	DeleteAllOther2
		JTM	ClearSegment

*		JTM	EngineSetName
*		JTM	AddEngine3
		JTM	DecodeStruct2
		JTM	FreePlayers
		JTM	AllocMenuMem
		JTM	FreeDirMem
		JTM	FindPlayerStruct
		JTM	LoadPlayers2
		JTM	PrintSongNr
		JTM	LCopyText
		JTM	CloseDatei
		JTM	AllocModuleMem
		JTM	CheckSoundsys
		JTM	FreeExtLoad
		JTM	PrintDisabled
		JTM	DeleteAllOtherPlayers
		JTM	EPP_SetVolume
		JTM	EPP_SetBalance
		JTM	EPP_SetVoices
		JTM	SetVoicesinEPG
		JTM	DecodeNames
		JTM	PrintBytes
		JTM	CopyToInfoB
		JTM	CopyToInfoB2
		JTM	ClrInfoBuffer
		JTM	CrunchMem
		JTM	PPDecrunch
		JTM	LHDecrunch
		JTM	StoneDecrunch
		JTM	Exploding
		JTM	DecrunchPack
		JTM	DecrunchSTC404
		JTM	LoadSegment
		JTM	Rippen
		JTM	DeleteTFile
		JTM	DeleteTFile2
		JTM	RenameTFile
		JTM	NextModule
		JTM	PrevModule
		JTM	SucheStruktur
		JTM	GetModuleNr
		JTM	InitPlayer
		JTM	CalcDuration
		JTM	DisabledKeys
		JTM	HoleLock
		JTM	FreeLock
		JTM	FreeMultiPuffer
*		JTM	AddUserSetAnz
		JTM	KeyTester1
		JTM	CopyMessage
		JTM	ChangeEngine
		JTM	FreeCommandStruct
		JTM	CloseWin
		JTM	OpenOldEngines
		JTM	LoadConfig
		JTM	GetArgs
		JTM	InitLoadConfig
		JTM	ChangeA6_2
		JTM	ClearTickCounter
		JTM	ChangeA6_3
		JTM	CommodityMsg
		JTM	ArexxMsg
		JTM	AppMessage
		JTM	EngineMessage
		JTM	TestValidEPNr
		JTM	KommandoAuswertung
		JTM	KommandoAuswertung2
		JTM	JumpTo
		JTM	LoadParentDir
		JTM	AbortTextRequester
*		JTM	SetErrorText

	ifne (*-A5UnterPrgTab)/4-(A5RoutEnd-A5Clearcache)/6
		Du hast was vergessen !!!!!!!
	endc


	*----------- Vereinbarungen fr PlayerJumpTabelle -----------*
A5JumpTabelle2:	JRM	EPP_AllocSampleStruct
		JRM	EPP_NewLoadFile2		;You must Freemem it !!!
		JRM	MakeCorrectDir
		JRM	EPP_TestAufHide
		JRM	ClearCache
		JRM	CopyMemQuick
		JRM	GetPassword
		JRM	StringCopy2
		JRM	ScreenToFront
		JRM	WindowToFront
	;	JRM	Return
	;	JRM	Return

	*--------- old DeliTracker-Globals ---------*
		JRM	GetListData
		JRM	DTLoadFile
		JRM	EPP_CopyDir
		JRM	EPP_CopyFile
		JRM	CopyString
		JRM	AllocAudio
		JRM	FreeAudio
		JRM	StartInterrupt
		JRM	StopInterrupt
		JRM	DT_SongEnd
		JRM	CutSuffix
		JRM	SetTimer2
		JRM	DTWaitAudioDMA

	*--------- old EaglePlayer-Globals --------*
		JRM	EPP_SaveMem		;Save Mem to Disk
		JRM	EPP_FileReq		;FileRequester
		JRM	EPP_TextRequest
		JRM	EPP_LoadExecutable	;Load % Decrunch
		JRM	EPP_NewLoadFile		;new DTG_LoadFile with Parameters
		JRM	EPP_ScrollText		;Scroll Text
		JRM	EPP_LoadPlConfig	;Loads a Config from Env:Eagleplayer/..
		JRM	EPP_SavePlConfig	;Saves a Config to EnvArc:Eagleplayer/..
		JRM	EPP_FindTag		;Finds a Tag
		JRM	EPP_FindAuthor		;Find Author

		JRM	EPP_Hexdez		;Convert Dual to Dezimal (Ascii)
		JRM	PrintText		;Print Text into the Mainwindow
		JRM	EPP_ModuleChange	;Change Playroutine in Module
		JRM	EPP_ModuleRestore	;Restore Playroutine in Module

		JRM	StringCopy2			;StringCopy
		JRM	BerechStringSize		;CalcStringSize
		JRM	EPP_StringCMP			;StringCMP

		JRM	EPP_DMAMask
		JRM	EPP_PokeAdr
		JRM	EPP_PokeLen
		JRM	EPP_PokePer
		JRM	EPP_PokeVol
		JRM	EPP_PokeCommand
		JRM	EPP_Amplifier

		JRM	GetAbortMsg
		JRM	GetEPNrfromMessage	;In:a1=Message

		JRM	InitCrunchDisplay
		JRM	FillCrunchDisplay
		JRM	RemoveCrunchDisplay
		JRM	EPP_GetLocaleString

		JRM	EPP_SetWaitPointer
		JRM	EPP_ClearWaitPointer

		JRM	EPP_OpenCatalog
		JRM	EPP_CloseCatalog

		JRM	EPP_AllocAmigaAudio
		JRM	EPP_FreeAmigaAudio

		JRM	EPP_RawToFormat
		JRM	EPP_FindAmplifier
		JRM	UserCallup5
		JRM	GetLoadListData
		JRM	SetListData
		JRM	GetHardwareType
	ifne (*-A5JumpTabelle2)/4-(ENPP_AllocSampleStruct-ENPP_SizeOf)/6
		Du hast was vergessen !!!!!!!
	endc





*-----------------------------------------------------------------------------*
* Aufruf ber Taglist. Falls Module gefunden, werden a0/a1/d1 entsprechend ge-*
* setzt. Die Ripperstruct wird zum spteren ExtRipp gebraucht.
*-----------------------------------------------------------------------------*
* Input: a0=MemAdr
*	 d0=MemSize
*	 d5=Tag
* Output:d0=Error oder NULL
*	 a0=ModuleAdr
*	 d1=ModuleSize
*	 a1=RipperStruct
Rippen:		btst	#0,LoadFileBytes(a5)		;
		bne.w	.Error

		movem.l	d2-d7/a2-a6,-(a7)
		move.l	a0,d6
		move.l	d0,d7
		clr.l	RippStart(a5)
		clr.l	RippSize(a5)

	move.l	a1,-(a7)
		move.l	LoadFileName(a5),a1
	*	tst.b	LHALoaded(a5)
	*	beq.s	.NOLHA
	*	move.l	MenuFileName(a5),a1
.NoLHA:		jsr	A5GetFilename(a5)
		move.l	a1,ScrollArgs(a5)
	move.l	(a7)+,a1


	*------- Ripperaufruf -------*
	* Input: a0=MemAdr
	*	 d0=MemSize
	* Output:d0=Error oder NULL
	*	 a0=ModuleAdr
	*	 d1=ModuleSize
	*	 a1=RipperStruct
.NoBuffering:	*moveq	#0,d4				*FirstSearchEngineNr
.NextEngine:	move.l	d6,a0				*FileAdr
		move.l	d7,d0				*FileSize
		moveq	#EUTY_Ripper,d3			*Type
		jsr	A5UserCallUp5(a5)
		tst.l	d3
		bne.s	.NoMoreEntries
		tst.l	d0				*Error oder NULL
		bne.s	.NextEngine
		moveq	#0,d3
		cmp.l	d3,a1
		beq.s	.NoMoreEntries
		subq.l	#1,d4
		move.l	d4,ERPSS_EngineNr(a1)

		*--------- Module wurde gefunden --------*
.NoMoreEntries:	move.l	d3,d0
		movem.l	(a7)+,d2-d7/a2-a6
.Return:	tst.l	d0
		rts

.Error:		moveq	#EPR_FunctionAborted,d0
		bra.s	.Return


*----------------------------- PlayerChecker ------------------------------*
* Input: d0=geladene Size
*	 d1=CheckSize
*	 a0=Adresse
* Output: -
************ wenn Mod im TextPuffer liegt, Vorsicht, wegen TextPuffer
************ bei AddPlayer
*****************************************
PlayerChecker:	btst	#0,LoadFileBytes(a5)		;
		bne.w	.NoPlayerChecker1

		movem.l	d0-a6,-(a7)

		move.l	d0,d5				;CheckSize
		move.l	d1,d6				;FileSizeNeu
		move.l	a0,d7				;Adresse

	*--- File umkopieren, weil AddPlayer den TextPuffer benutzt ---*
		sub.l	a4,a4			;Memory fr FirstBytesBuffer
		lea	TextPuffer(a5),a0
		cmp.l	a0,d7
		bne.s	.NoBuffering

		move.l	#FirstBytes,d0
		jsr	A5AllocMem(a5)
		beq.w	.NoPlayer
		move.l	d0,a4
		move.l	d0,a1
		move.l	d7,a0
		move.l	#FirstBytes,d0
		jsr	A5CopyMemQuick(a5)

	*------------- Engines aufrufen -----------------*
.NoBuffering:	moveq	#0,d4				*FirstSearchEngineNr
.NextUPrg:	move.l	d5,d0				*CheckSize
		move.l	d6,d1				*FileSize
		move.l	d7,a0				*FileAdr
		move.l	d5,-(a7)
		moveq	#EUTY_PlayerLoader,d3		*Type
		move.l	#EUT_CheckForPlayer,d5		*Tag
		move.l	LoadFileName(a5),a1		*Name des Files
		move.l	EPG_FirstPlayerStruct(a5),a2	*PlayerList
		jsr	A5UserCallUp5(a5)
		move.l	(a7)+,d5
		tst.l	d3
		bne.s	.NoMoreEntries
		move.l	a0,d0
		beq.s	.NextUPrg

	*--------------- Angegebene Player laden ---------------*
		movem.l	d0-a6,-(a7)
		move.l	a0,a2
.NextPlayer:	lea	EPT_String(a2),a0
		moveq	#Namenlange-2,d1
		lea	PlayersFile(a5),a1
		jsr	A5StringCopy2(a5)

		move.l	a2,-(a7)
		move.b	#1,BatchLoading(a5)	;soll replaced werden
		jsr	A5LoadOnePlayer(a5)
		clr.b	BatchLoading(a5)	;soll replaced werden
		move.l	(a7)+,a2

		move.l	(a2),d4
		move.l	a2,a1
		move.l	EPT_StringSize(a2),d0
		beq.s	.NoFree
		Execbase
		jsr	_LVOFreemem(a6)
.NoFree:	move.l	d4,a2
		tst.l	d4
		bne.s	.NextPlayer
		movem.l	(a7)+,d0-a6
		bra.w	.NextUPrg		;keine weiteren Player


	*--------------- Hilfpuffer wieder freigeben -------------*
.NoMoreEntries:	move.l	a4,d0
		beq.s	.NoPlayer
		move.l	d0,a0
		move.l	d7,a1
		move.l	#FirstBytes,d0
		jsr	A5CopyMemQuick(a5)
		move.l	a4,a1
		move.l	#FirstBytes,d0
		EXECBase
		jsr	_LVOFreeMem(a6)

.NoPlayer:
		movem.l	(a7)+,d0-a6
.NoPlayerChecker1:
		rts


*	*--------------- Userprogramme durchtesten ------------*
*.NoBuffering:	lea	EPG_FirstUserStruct(a5),a3
*.NextUPrg:	move.l	(a3),d7
*		beq.w	.NoMoreEntries
*		move.l	d7,a3
*		move.l	UPrgS_UFlags(a3),d7
*		btst	#UPrgF_Engine,d7
*		beq.w	.NextUPrg
*		btst	#UPrgF_Active,d7
*		beq.w	.NextUPrg
*
*
*	*	btst	#0,UPrgS_Flags(a3)	;auf Activitt testen
*	*	beq.s	.NextUPrg
*
*
*		move.l	UPrgS_EusAdr(a3),d7
*		beq.s	.NextUPrg
*		move.l	d7,a1
*
**		move.l	FileSizeNeu(a5),d1
**		move.l	File(a5),a0
*	move.l	d6,d0
*	move.l	d5,d1
*	move.l	d4,a0
*	
*		move.l	FirstPlayer(a5),a2
*		movem.l	d1-d7/a1-a6,-(a7)
*		move.l	EUS_TagList(a1),-(a7)		;Tagliste auf Stack
*		move.l	LoadFileName(a5),a1	;Ist das Label richtig ?
*		move.l	#EUT_CheckForPlayer,-(a7)	;Tag auf Stack
*		jsr	A5UserCallUp(a5)
*		addq.l	#8,a7
*		movem.l	(a7)+,d1-d7/a1-a6
*		beq.s	.NextUPrg		;beq=kein Tag
*		tst.l	d0			;d0=Fehlernummer
*		bne.s	.NextUPrg
*



*----------------------------------------------------------------------------*
* Input: -
* Output: d0=WindowHandle bzw. UserWindowHandle oder NULL		     *
*----------------------------------------------------------------------------*
GetMainWindowHandle:
		move.l	UMG_WinHandle(a5),d0
.NimmUMG:	rts

*----------------------------------------------------------------------------*
* Input: -
* Output: d0=WindowHandle bzw. UserWindowHandle oder NULL		     *
*----------------------------------------------------------------------------*
GetMainWindowTags:
		move.l	UMG_Tags(a5),d0
.NimmUMG:	rts


*----------------------------------------------------------------------------*
* Input: -
* Output: d0=WindowHandle bzw. UserWindowHandle oder NULL		     *
*----------------------------------------------------------------------------*
GetPlWindowHandle:
		move.l	UPlG_WinHandle(a5),d0
.NimmUMG:	rts

*----------------------------------------------------------------------------*
*----------------------------------------------------------------------------*
*----------------------------------------------------------------------------*

* [][] Poke Einsprnge fr Indirektzugriff auf Audio Strukturen
*      (DMA Simulation)
EPP_DMAMask:
		;in D0 enable/disable
		;       $8000/0
		;in D1 Maske der Stimmen von 0 bis n (Bit 0=ch0, Bit1=ch1 usw.)
	movem.l	d0-a6,-(sp)

	lea	BSSMerkPuffer,a5
	move.l	EPG_AudioStruct(A5),d2
	beq.w	.err
	move.l	d2,a0

	move.l	d1,d4

	moveq	#0,d2
.loop
	lsr.l	#1,d4
	bcs.s	.set
	beq.w	.err
	add.w	#AS_Sizeof,d2
	bra.s	.loop
.set
	lea	(A0,d2.w),a1		;Audstruct 0-n

	move.l	AS_ChangeFlags(a1),d3
	or.b	#ASChB_DMA,d3
	move.l	d3,AS_ChangeFlags(a1)

	tst.w	d0			;wenn D0 neg ($8000)
	smi	d3			;dann setze d3
	ext.w	d3			;komplett

					;soll DMA an ?
	beq.s	.not			;nein, weiter

	tst.w	AS_DMABit(A1)		;luft DMA schon ?
	bne.s	.not			;ja, weiter

					;bei DMA Start  werden
					;die ADR/Size Werte
					;fr den DMA bernommen

	move.l	AS_RepeatAdr(A1),AS_Currentadr(A1)
	clr.l	AS_CurrentPos(A1)
	clr.l	AS_CurrentFPos(A1)
	move.l	AS_RepeatSize(A1),AS_Samplesize(A1)
	clr.b	AS_NoLoop(a1)
	move.w	d3,AS_DMABit(a1)

	move.l	AS_ChangeFlags(a1),d5
	or.b	#ASChB_Adr!ASChB_Len,d5
	move.l	d5,AS_ChangeFlags(a1)

	tst.l	AS_Int(a1)		;"Interrupt" bei neuem Sample ?
	beq.s	.noint

	movem.l	d0-a6,-(sp)		;nur zur Sicherheit
	move.l	as_int(a1),a1
	ExecBase
	jsr	_LVOCause(a6)
	movem.l	(sp)+,d0-a6		;man weiss ja nie...
.noINT

.not
	move.w	d3,AS_DMABit(a1)
	add.w	#AS_Sizeof,d2
	bra.w	.loop
.err
	move.l	EPG_ActiveAmplifier(a5),d2
	beq.s	.err3
	move.l	d2,a0
	move.l	EUS_SpecialJumpTab(a0),d2
	beq.s	.err3
	move.l	d2,a0
	move.l	AMJ_DMAMask(a0),d2		;Einsprung fr DMACON
	beq.s	.err3
	move.l	d2,a0
	jsr	(A0)				;Jump
.err3
	movem.l	(sp)+,d0-a6
	rts

EPP_PokeVol:
			;in D0  Lautstrkewert
			;in D1 Stimmennummer von 0 an
	movem.l	d0-a6,-(sp)

	lea	BSSMerkPuffer,a5
	move.l	EPG_AudioStruct(A5),d2
	beq.s	.err
	move.l	d2,a0

	moveq	#$3f,d2			;max. 64
	and.w	d1,d2
	mulu	#AS_Sizeof,d2
	lea	(A0,d2.w),a0		;Audstruct 0-n

	move.l	AS_ChangeFlags(a0),d3
	or.b	#ASChB_Vol,d3
	move.l	d3,AS_ChangeFlags(a0)

	cmp.w	#64,d0
	blo.s	.lower
	moveq	#64,d0
.lower

	move.w	d0,AS_LeftVolume(a0)	;Lautstrke sichern
	move.w	d0,AS_RightVolume(a0)	;Lautstrke sichern
.err
	move.l	EPG_ActiveAmplifier(a5),d2
	beq.s	.err3
	move.l	d2,a0
	move.l	EUS_SpecialJumpTab(a0),d2
	beq.s	.err3
	move.l	d2,a0
	move.l	AMJ_PokeVol(a0),d2		;Einsprung fr DMACON
	beq.s	.err3
	move.l	d2,a0
	jsr	(A0)				;Jump
.err3
	movem.l	(sp)+,d0-a6
	rts

;=========================== ENPP_PokePer ==================================

EPP_PokePer:		;in D0  Periodenwert
			;in D1 Stimmennummer von 0 an
	movem.l	d0-a6,-(sp)

	lea	BSSMerkPuffer,a5
	move.l	EPG_AudioStruct(A5),d2
	beq.s	.err
	move.l	d2,a0

	moveq	#$3f,d2			;max. 64
	and.w	d1,d2
	mulu	#AS_Sizeof,d2
	lea	(A0,d2.w),a0		;Audstruct 0-n

	move.l	AS_ChangeFlags(a0),d3
	or.b	#ASChB_Per,d3
	move.l	d3,AS_ChangeFlags(a0)

	lsl	#2,d0
	move.w	d0,AS_Period(a0)	;Periode sichern
.err
	move.l	EPG_ActiveAmplifier(a5),d2
	beq.s	.err3
	move.l	d2,a0
	move.l	EUS_SpecialJumpTab(a0),d2
	beq.s	.err3
	move.l	d2,a0
	move.l	AMJ_PokePer(a0),d2		;Einsprung fr DMACON
	beq.s	.err3
	move.l	d2,a0
	jsr	(A0)				;Jump
.err3
	movem.l	(sp)+,d0-a6
	rts

;=========================== ENPP_PokeLen ====================================

EPP_PokeLen:		;in D0.l Samplelnge in Worten
			;in D1.b Stimmennummer von 0 bis n
	movem.l	d0-a6,-(sp)

	lea	BSSMerkPuffer,a5
	move.l	EPG_AudioStruct(A5),d2
	beq.s	.err
	move.l	d2,a0

	moveq	#$3f,d2			;max. 64
	and.w	d1,d2
	mulu	#AS_Sizeof,d2
	lea	(A0,d2.w),a0		;Audstruct 0-n

	move.l	d0,d2
	add.l	d2,d2

	sne	AS_LoopFlag(A0)		;wegen Problemen mit Sonic Arranger
					;wurden die beiden Zeilen unten
					;ersetzt
					;	cmp.l	#2,d2
					;	shi	AS_LoopFlag(A0)
;	and.b	#ASLoopB_PingPong,AS_LoopFlag(a0)
	and.b	#ASLoopB_Forwards,AS_LoopFlag(a0)
					;1=Loop vorwrts
	move.l	d2,AS_RepeatSize(a0)	;Lnge sichern (in Bytes)

	move.l	AS_ChangeFlags(a0),d3
	or.b	#ASChB_RepLen,d3
	move.l	d3,AS_ChangeFlags(a0)
.err
	move.l	EPG_ActiveAmplifier(a5),d2
	beq.s	.err3
	move.l	d2,a0
	move.l	EUS_SpecialJumpTab(a0),d2
	beq.s	.err3
	move.l	d2,a0
	move.l	AMJ_PokeLen(a0),d2		;Einsprung fr DMACON
	beq.s	.err3
	move.l	d2,a0
	jsr	(A0)				;Jump
.err3
	movem.l	(sp)+,d0-a6
	rts

;=========================== ENPP_PokeAdr ====================================

EPP_PokeAdr:		;in D0 Sampleadresse
			;in D1 Stimmennummer von 0 an
	movem.l	d0-a6,-(sp)

	lea	BSSMerkPuffer,a5
	move.l	EPG_AudioStruct(A5),d2
	beq.s	.err
	move.l	d2,a0

	moveq	#$3f,d2			;max. 64
	and.w	d1,d2
	mulu	#AS_Sizeof,d2
	lea	(A0,d2.w),a0		;Audstruct 0-n

	move.l	d0,AS_RepeatAdr(a0)	;Lnge sichern

	move.l	AS_ChangeFlags(a0),d3
	or.b	#ASChB_RepAdr,d3
	move.l	d3,AS_ChangeFlags(a0)
.err
	move.l	EPG_ActiveAmplifier(a5),d2
	beq.s	.err3
	move.l	d2,a0
	move.l	EUS_SpecialJumpTab(a0),d2
	beq.s	.err3
	move.l	d2,a0
	move.l	AMJ_PokeAdr(a0),d2		;Einsprung fr DMACON
	beq.s	.err3
	move.l	d2,a0
	jsr	(A0)				;Jump
.err3
	movem.l	(sp)+,d0-a6
	rts


*-----------------------------------------------------------------------------*
* Input: d0=Command
*	 d1=Args	(Filter d1=0 -> off  d1=1 -> on   d1=-1 -> toggle)
*	 d2=Args ??? fr die Zukunft?
EPP_PokeCommand:
	movem.l	d0-a6,-(sp)

	move.l	PufferAdr2(pc),a5
	move.l	EPG_ActiveAmplifier(a5),d7
	beq.s	.Err3
	move.l	d7,a0
	move.l	EUS_SpecialJumpTab(a0),d7
	beq.s	.Err3
	move.l	d7,a0
	move.l	AMJ_Command(a0),d7		;Einsprung fr das Kommando
	beq.s	.Err3
	move.l	d7,a0
	jsr	(a0)				;Jump
.Err3:
	movem.l	(sp)+,d0-a6
	rts

*-----------------------------------------------------------------------------*
* Achtung DT_NotePlayer auch aktualisieren !!!
EPP_Amplifier:
	movem.l	d0-a6,-(sp)

	move.l	PufferAdr2(pc),a5
	move.l	EPG_ActiveAmplifier(a5),d7
	beq.s	.Err3
	move.l	d7,a0
	move.l	EUS_SpecialJumpTab(a0),d7
	beq.s	.Err3
	move.l	d7,a0
	move.l	AMJ_Amplifier(a0),d7		;Einsprung fr das Kommando
	beq.s	.Err3
	move.l	d7,a0
	jsr	(a0)				;Jump
.Err3:
	movem.l	(sp)+,d0-a6
	rts

;------------------------------------------------------------------------------------------------
;------ durchsucht alle verfgbaren Amplifier, ob sie in der Lage sind, die Anforderungen   -----
;------ des Replays zu erfllen, wenn nicht kann in dieser Situation das Replay darauf      -----
;------ reagieren und z.B. die Samples auf 8 Bit runterrechnen, falls kein Amplifier        -----
;------ aktiv ist, der 16 Bit Samples beherrscht                                            -----
;------------------------------------------------------------------------------------------------
;Input:  A0 - Tagliste, dieselbe, die auch bei EP_InitAmplifier verwendet wird
;Output: D0 - Adresse des gefundenen Amplifiers oder 0
;
EPP_FindAmplifier:
	movem.l	d1-a6,-(sp)
	move.l	a0,a4

	move.l	PufferAdr2(pc),a5
	move.l	EPG_AmplifierList(a5),d1

	;sucht einfach die Liste von vorn bis hinten durch
	;(da die Amplifier bereits nach Prioritt sortiert sind)
.AMsuch_loop
	beq.s	.AM_nonefound
	move.l	d1,a0			;EUS_Start Struktur

	move.w	EUS_Flags(a0),d2	;Amplifier erlaubt ?
	and.b	#EUSB_Disable,d2
	bne.s	.AMsuch_next		;nein

	move.l	EUS_SpecialJumpTab(a0),d2
	beq.s	.AMsuch_next
	move.l	d2,a0
	move.l	AMJ_CheckFeatures(a0),d2;Einsprung fr CheckFeatures
	beq.s	.AMsuch_next
	move.l	d2,a1

	move.l	a4,a0
	movem.l	d1-a6,-(sp)
	jsr	(A1)			;Test auf verlangte Features
	movem.l	(sp)+,d1-a6
	tst.l	d0
	beq.s	.AM_found
.AMsuch_next
	move.l	d1,a0
	move.l	EUS_Identifier(a0),d1
	bra.s	.AMsuch_loop
.AM_found
	move.l	d1,d0
	movem.l	(sp)+,d1-a6
	tst.l	d0			;ok, ein Amplifier gefunden
	rts
.AM_Nonefound
	movem.l	(sp)+,d1-a6
	moveq	#0,d0			;kein Amplifier gefunden
	rts

;================ Interne Player nun in eigener Sektion ======================
;--- diese 3 Routinen mssen EP-Intern bleiben, wegen der Relokation ---------


*-------------------- Die ConvertierungsPuffer lschen --------------------*
ClearProTemps:	movem.l	d0/a0/a5,-(a7)
		move.l	PufferAdr2,a5
		clr.l	Unic_Temp(a5)
		lea	pro_temp1(A5),a0
		move.w	#255,d0
.ClrTemps:	clr.l	(a0)+
		dbf	d0,.ClrTemps
		movem.l	(a7)+,d0/a0/a5
		rts

*------------------ Verschlsselung 1 von Struct 1 aufheben ---------------*
Key_Verl11:	lea	EPKF_V1Decodek(a4),a0
		moveq	#EPKF_V1ChkSum-EPKF_V1DecodeK-1,d1

		move.l	a0,a2
.DecodeStr1:	move.b	(a0),d0
		jsr	A5DecodeD02(a5)
		move.b	d0,(a0)+
		dbf	d1,.DecodeStr1
		rts

ClrInfoBuffer:	move.l	a0,-(a7)
		lea	Pro_InfoBuffer,a0
		clr.l	-4(a0)
		clr.l	12(a0)
		clr.l	20(a0)
		clr.l	28(a0)
		clr.l	36(a0)
		clr.l	44(a0)
		clr.l	52(a0)
		clr.l	60(a0)
		clr.l	68(a0)
		clr.l	100(a0)
		clr.l	108(a0)
		clr.l	116(a0)
		clr.l	124(a0)
		clr.l	132(a0)
		move.l	(a7)+,a0
		rts


*----------------------------------------------------------------------------*
* Fr interne Menus werden hier die Menuitems gesucht .			     *
* Input: d0 = EP-Nummer
*Output: d0 = Error oder NULL
*	 a0 = ItemStruct
*----------------------------------------------------------------------------*
GetMenuItemAdr:	movem.l	d1/d2/a3/a4,-(a7)
		tst.w	d0
		beq.s	.NoMenu
		tst.w	MenuInitOk(a5)
		beq.s	.NoMenu

	*----------- Titlemenus durchtesten ------------*
		tst.l	MenuAdr(a5)
		beq.s	.NoMenu

		lea	EM_ProjectMenu(a5),a4
.NextMenu:	move.l	18(a4),d1
		beq.s	.KeineItems
		bsr.s	.TestStrip
		beq.s	.NoMore			;--> Found
.KeineItems:	move.l	(a4),d1
		move.l	d1,a4
		bne.b	.NextMenu
.NoMenu:	moveq	#EPR_ErrorInArguments,d0
		sub.l	a0,a0
		bra.b	.Zurueck


	*-- Einzelnen Strips & Unterstrips durchtesten --*
.TestStrip:	move.l	d1,a3
		cmp.w	EPMI_EPNr(a3),d0
		beq.s	.Found
		move.l	EPMI_SubItem(a3),d1
		beq.s	.NoSubItem
		move.l	a3,-(sp)
		bsr.b	.TestStrip
		move.l	(sp)+,d1
		tst.l	d0
		beq.s	.Found
		move.l	d1,a3
.NoSubItem:	move.l	(a3),d1
		beq.s	.NotFound
		bra.b	.TestStrip

.NoMore:	move.l	a3,a0
		moveq	#0,d0
.Zurueck:	movem.l	(a7)+,d1/d2/a3/a4
.NotFound:	tst.l	d0
		rts
.Found		moveq	#0,d0
		rts


**----------------------------------------------------------------------------*
** Fr interne Menus werden hier die Menuitems gesucht .			     *
** Input: d0 = EP-Nummer
**Output: d0 = Error oder NULL
**	 a0 = ItemStruct
**----------------------------------------------------------------------------*
*GetMenuItemAdr:	movem.l	d1/d2/a3/a4,-(a7)
*		tst.w	d0
*		beq.s	.NoMenu
*		tst.w	MenuInitOk(a5)
*		beq.s	.NoMenu
*
*	*----------- Titlemenus durchtesten ------------*
*		tst.l	MenuAdr(a5)
*		lea	EM_ProjectMenu(a5),a4
*.NextMenu:	move.l	18(a4),d1
*		beq.s	.KeineItems
*		bsr.s	.TestStrip
*		beq.s	.NoMore			;--> Found
*.KeineItems:	move.l	(a4),d1
*		move.l	d1,a4
*		bne.b	.NextMenu
*.NoMenu:	moveq	#EPR_ErrorInArguments,d0
*		sub.l	a0,a0
*		bra.b	.Zurueck
*
*
*
*	*-- Einzelnen Strips & Unterstrips durchtesten --*
*.TestStrip:	move.l	d1,a3
*		cmp.w	EPMI_EPNr(a3),d0
*		beq.s	.Found
*		move.l	EPMI_SubItem(a3),d1
*		beq.s	.NoSubItem
*		move.l	a3,-(a7)
*		bsr.b	.TestStrip
*		addq.l	#4,a7
*		beq.s	.Found
*		move.l	-4(a7),a3
*.NoSubItem:	move.l	(a3),d1
*		beq.s	.NotFound
*		bra.b	.TestStrip
*
*.NoMore:	move.l	a3,a0
*		moveq	#0,d0
*.Zurueck:	movem.l	(a7)+,d1/d2/a3/a4
*.NotFound:	tst.l	d0
*.Found:		rts
*

*-----------------------------------------------------------------------------*
* Testet, ob das bei dem aktellen Dir noch ein Parent gemacht werden darf.    *
* Bsp: Noise-Protracker angewhlt im PD_Menu angewhlt.			      *
*	|- Tekkno							      *
*	|- Jazz								      *
*	|- Hardcore							      *
* Dann darf nur innerhalb des NoiseProtrackerverzeichnisses gesprungen werden *
*-----------------------------------------------------------------------------*
TestJumpDir:	movem.l	d1/a0/a1,-(a7)
		moveq	#0,d0
		tst.b	OnDirJump(a5)
		beq.s	.NoDirJump
		jsr	A5BerechStringSize(a5)
		lea	(a0,d0.w),a0
		move.l	DirJumpPtr(a5),d0
		beq.s	.NoDirJump
		move.l	d0,a1
		moveq	#0,d0
		cmp.l	a0,a1
		beq.s	.ParentDis
		cmp.b	#"/",(a0)+
		bne.s	.NoDirJump
		cmp.l	a0,a1
		bne.s	.NoDirJump
.ParentDis:	moveq	#EPR_InvalidNr,d0
.NoDirJump:	movem.l	(a7)+,d1/a0/a1
		tst.l	d0
		rts

*---------------------------- Erstmal ignorieren -----------------------------*
*-----------------------------------------------------------------------------*
FirstLocaleInit:movem.l	d0-a6,-(a7)
		lea	InternalStrings,a3
		lea	LocalePuffer(a5),a4
		move.w	#-LNr_LastInternal+LNr_FirstInternal,d1
		move.l	a3,a0
.NextString:	move.l	a0,d0
		sub.l	a3,d0
		move.w	d0,-(a4)
.FindZero:	tst.b	(a0)+
		bne.s	.FindZero
	*	tst.b	(a0)
	*	beq.s	.NowExternal
		subq.w	#1,d1
		bne.s	.NextString

.NowExternal:	lea	LocalePuffer+2(a5),a4
		lea	ExternalStrings,a3
		move.w	#LNr_LastExternal,d1
		move.l	a3,a0
.NextString2:	move.l	a0,d0
		sub.l	a3,d0
		move.w	d0,(a4)+
.FindZero2:	tst.b	(a0)+
		bne.s	.FindZero2
	*	tst.b	(a0)
	*	beq.s	.SetAbsStrings
		subq.w	#1,d1
		bne.s	.NextString2
.SetAbsStrings:	lea	EPEnginePort,a3
		lea	FillNameTab,a4
.SetAbsStrings2:move.w	(a4)+,d0
		beq.s	.Ok
		lea	(a3,d0.w),a2
		move.l	(a2),d0
		jsr	A5GetLocaleString(a5)
		move.l	a0,(a2)
		bra.s	.SetAbsStrings2
.Ok:		movem.l	(a7)+,d0-a6
		rts

*-----------------------------------------------------------------------------*
* Input:  d0	= StringNummer						      *
* Output: A0	= StringAdr						      *
*-----------------------------------------------------------------------------*
GetLocaleString:bsr.s	GetALocaleString
		move.l	d0,a0
		rts

*-----------------------------------------------------------------------------*
* Input:  Stack+4.w = Nummer						      *
* Output: A0	    = StringAdr						      *
*-----------------------------------------------------------------------------*
GetLocaleStringA0:IFEQ	Executable
		bsr.s	GetALocaleString
		move.l	d0,a0
		rts
		ELSE
		move.l	d0,-(a7)
		move.l	4(a7),a0		;d0 & Rcksprung
		moveq	#0,d0
		move.w	(a0),d0
		addq.l	#2,4(a7)		;Rcksprungadr erhhen
		bsr.s	GetALocaleString
		move.l	d0,a0
		move.l	(a7)+,d0
		rts
		ENDC

*-----------------------------------------------------------------------------*
* Input:  Stack+4.w = Nummer						      *
* Output: A1	    = StringAdr						      *
*-----------------------------------------------------------------------------*
GetLocaleStringA1:IFEQ	Executable
		bsr.s	GetALocaleString
		move.l	d0,a1
		rts
		ELSE
		move.l	d0,-(a7)
		move.l	4(a7),a1		;d0 & Rcksprung
		moveq	#0,d0
		move.w	(a1),d0
		addq.l	#2,4(a7)		;Rcksprungadr erhhen
		bsr.s	GetALocaleString
		move.l	d0,a1
		move.l	(a7)+,d0
		rts
		ENDC

*-----------------------------------------------------------------------------*
* Input:  Stack+4.w = Nummer						      *
* Output: A2	    = StringAdr						      *
*-----------------------------------------------------------------------------*
GetLocaleStringA2:IFEQ	Executable
		bsr.s	GetALocaleString
		move.l	d0,a2
		rts
		ELSE
		move.l	d0,-(a7)
		move.l	4(a7),a2		;d0 & Rcksprung
		moveq	#0,d0
		move.w	(a2),d0
		addq.l	#2,4(a7)		;Rcksprungadr erhhen
		bsr.s	GetALocaleString
		move.l	d0,a2
		move.l	(a7)+,d0
		rts
		ENDC

*-----------------------------------------------------------------------------*
* Input:  Stack+4.w = Nummer						      *
* Output: A3	    = StringAdr						      *
*-----------------------------------------------------------------------------*
GetLocaleStringA3:IFEQ	Executable
		bsr.s	GetALocaleString
		move.l	d0,a3
		rts
		ELSE
		move.l	d0,-(a7)
		move.l	4(a7),a3		;d0 & Rcksprung
		moveq	#0,d0
		move.w	(a3),d0
		addq.l	#2,4(a7)		;Rcksprungadr erhhen
		bsr.s	GetALocaleString
		move.l	d0,a3
		move.l	(a7)+,d0
		rts
		ENDC

*-----------------------------------------------------------------------------*
* Input:  Stack+4.w = Nummer						      *
* Output: D0	    = StringAdr						      *
*-----------------------------------------------------------------------------*
GetLocaleStringD0:IFEQ	Executable
		bsr.s	GetALocaleString
		rts
		ELSE
		move.l	a0,-(a7)
		move.l	4(a7),a0		;d0 & Rcksprung
		moveq	#0,d0
		move.w	(a0),d0
		addq.l	#2,4(a7)		;Rcksprungadr erhhen
		bsr.s	GetALocaleString
		move.l	(a7)+,a0
		rts
		ENDC

*-----------------------------------------------------------------------------*
* Input:  D0.w = LocaleNr						      *
* Output: D0.l = StringAdr						      *
*-----------------------------------------------------------------------------*
GetALocaleString:
		movem.l	d1/d2/a0/a1/a6,-(a7)
		lea	InternalStrings,a1		*Default (fr Fehler)
		tst.w	d0
		blt.s	.Internal

		*--- LocaleString aus EP_Main Catalog suchen --*
		cmp.w	#LNr_LastExternal,d0
		bhi.s	.PlayerEngineLNr
		move.l	d0,d1
		lea	ExternalStrings,a1
		lea	LocalePuffer(a5),a0
		ext.l	d1
		add.l	d1,d1
		move.w	(a0,d1.l),d1			;kein ext.l weil immer
		lea	(a1,d1.w),a1

		*--- Nun LocaleString aus Catalog suchen --*
		subq.l	#1,d0
		move.l	MainCatalog(a5),d1
.ExternalCatalog:move.l	d1,a0
		beq.s	.CopyToDo

		move.l	EPG_LocaleBase(a5),d1
		beq.s	.CopyToDo
		move.l	d1,a6
		and.l	#$ffff,d0
		jsr	_LVOGetCatalogStr(a6)
		bra.s	.NoLocale

.PlayerEngineLNr:
		cmp.w	#LNr_FirstPlayer,d0
		bhs.s	.PlayerCatalog

		cmp.w	#LNrE_LastEngine,d0
		bhi.s	.Error
		sub.w	#LNr_FirstEngine,d0
		move.l	EngineCatalog(a5),d1
		bra.s	.ExternalCatalog

.PlayerCatalog:	cmp.w	#LNrP_LastPlayer,d0
		bhi.s	.Error
		sub.w	#LNr_FirstPlayer,d0
		move.l	PlayerCatalog(a5),d1
		bra.s	.ExternalCatalog

		*--------- interner Catalog -------*
.Internal:	cmp.w	#LNr_LastInternal,d0
		bhi.s	.JetztSuchen
.Error:		moveq	#LNr_STRINGERROR,d0
.JetztSuchen:	lea	LocalePuffer(a5),a0
		ext.l	d0
		add.l	d0,d0
		move.w	(a0,d0.l),d0			;kein ext.l weil immer
		lea	(a1,d0.w),a1
.CopyToDo:	move.l	a1,d0

.NoLocale:	movem.l	(a7)+,d1/d2/a0/a1/a6
		rts


*-----------------------------------------------------------------------------*
Documentation2:	moveq	#EPR_LibraryNotFound,d7
		lea	EPG_AmigaGuideBase(a5),a3
		LA1	LNr_AmigaGuideName
		moveq	#0,d0
		jsr	A5OpenLib(a5)
		move.l	d0,a6
		tst.l	d0
		beq.w	.No

		move.l	HelpHandle(a5),d0
		bne.w	.CloseDoc

		bsr	ClrAmigaguideStruct

		lea	AmigaguideStruct(a5),a0
		LA1	LNr_MainGuideName
		move.l	a1,nag_name(a0)
		*move.l	#HTF_Load_Index,nag_flags(a0)
		*move.l	#HTF_Load_Index!HTF_NoActivate,nag_flags(a0)
		move.l	EPG_PubScreen(a5),nag_Pubscreen(a0)
		moveq	#0,d0
		move.l	EPG_AmigaGuideBase(a5),a6
		jsr	_LVOOpenAmigaGuideAsyncA(a6)
		move.l	d0,HelpHandle(a5)
		tst.l	d0
		beq.s	.No

		moveq	#5,d1
		jsr	A5Delay3(a5)


		LA0	LNr_MainGuideName
		move.l	a0,ScrollArgs(a5)
		LA0	LNr_MainLink
		move.l	a0,ScrollArgs(a5)
		LA0	LNr_GuideALink
		lea	ScrollArgs(a5),a1
		jsr	A5MakeCorrectText(a5)



		move.l	HelpHandle(a5),a0
		lea	ScrollPuffer(a5),a1
		move.l	a1,d0
		moveq	#0,d1
		move.l	EPG_AmigaGuideBase(a5),a6
		jsr	_LVOSendAmigaGuideCmdA(a6)
		LA0	LNr_Documentationloaded
		jmp	A5ScrollNewText(a5)

.No:		moveq	#EPR_NoHelpFile,d0
		jmp	A5ScrollNewFehler(a5)


.CloseDoc:	tst.b	OnHelp(a5)
		bne.s	.Return
		move.l	HelpHandle(a5),d0
		beq.s	.Nohandle
		move.l	d0,a0
		move.l	EPG_AmigaGuideBase(a5),d0
		beq.s	.NoHandle
		move.l	d0,a6
		jsr	_LVOCloseAmigaGuide(a6)
.NoHandle:	clr.l	HelpHandle(a5)
		lea	EPG_AmigaGuideBase(a5),a0
		jsr	A5CloseLib(a5)
.Return:	LA0	LNr_OperationSuccesful
		jmp	A5ScrollNewText(a5)


ClrAmigaGuideStruct:
		lea	AmigaguideStruct(a5),a1
		lea	1(a1),a0
		clr.b	(a1)
		moveq	#NewAmigaGuide_SIZEOF-2,d1
		jmp	A5CopyText2(a5)


*----------------------------------------------------------*
* Amigaguide-Docs anschauen (Programm bleibt nicht stehen) *
*----------------------------------------------------------*
Help2:		movem.l	d1-a6,-(a7)
		moveq	#0,d7
		tst.b	OnHelp(a5)
		beq.w	.Close

		moveq	#EPR_LibraryNotFound,d7
		lea	EPG_AmigaGuideBase(a5),a3
		LA1	LNr_AmigaGuideName
		moveq	#0,d0
		jsr	A5OpenLib(a5)
		move.l	d0,a6
		tst.l	d0
		beq.s	.Ok

		*----- Eagleplayer.Dok ffnen ----*
		move.l	HelpHandle(a5),d0
		bne.s	.HandleDa

		bsr	ClrAmigaGuideStruct

		moveq	#EPR_NoHelpFile,d7
*		LA0	LNr_DocumentationDir
*		move.l	a0,d1
*		move.l	#-2,d2
*		move.l	DTG_Dosbase(a5),a6
*		jsr	_LVOLock(a6)
*		move.l	d0,d4
*		beq.s	.Close
*		lea	PathPuffer(a5),a0
*		move.l	d4,d1
*		move.l	a0,d2
*		move.l	#PathPuffersize-2,d3
*		jsr	_LVONameFromLock(a6)
*		move.l	d4,d1
*		jsr	_LVOUnLock(a6)


		lea	AmigaguideStruct(a5),a0
		LA1	LNr_MainGuideName
*		lea	PathPuffer(a5),a1
		move.l	a1,nag_name(a0)
		move.l	#HTF_Load_Index!HTF_NoActivate,nag_flags(a0)

*		jsr	A5GetMainWindowhandle(a5)
*		tst.l	d0
*		beq.s	.NoScreen
*		move.l	d0,a1
*		move.l	46(a1),d0			;ScreenAdr
*.NoScreen:	move.l	d0,nag_Screen(a0)


		move.l	EPG_PubScreen(a5),nag_Pubscreen(a0)
		moveq	#0,d0
		move.l	EPG_AmigaGuideBase(a5),a6
		jsr	_LVOOpenAmigaGuideAsyncA(a6)
.HandleDa:	moveq	#0,d7
		move.l	d0,HelpHandle(a5)
		bne.s	.Ok
		moveq	#EPR_NoHelpFile,d7
.Close:		jsr	A5CloseHelp(a5)
.Ok:		move.w	#1,WindowChanged(a5)
		move.w	#1,HelpChange(a5)
		jsr	A5GuiChanged(a5)
		clr.w	HelpChange(a5)
		move.l	d7,d0
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts

* Achtung: Beim Schlieen der Guide beachten, da Documentation auf sein kann
*          Hat weiter keinen Einflu!
CloseHelp:	move.l	HelpHandle(a5),d0
		beq.s	.Nohandle
		move.l	d0,a0
		move.l	EPG_AmigaGuideBase(a5),d0
		beq.s	.NoHandle
		move.l	d0,a6
		jsr	_LVOCloseAmigaGuide(a6)
.NoHandle:	clr.l	HelpHandle(a5)
		lea	EPG_AmigaGuideBase(a5),a0
		jsr	A5CloseLib(a5)
		clr.b	OnHelp(a5)
		rts		


*--------------------- Gib dem Guide mal ein Kommando ----------------------*
* d0=Nummer
* d2=ModuleNr...
HelpMe:		sub.l	a3,a3
		*sub.l	d3,d3
		sub.l	a0,a0

	* Einsprung fr Helplink
	*	
	*	a0 = Nodename (optional)
	*	a3 = Guidename
HelpMe2:	moveq	#0,d4
		move.w	d0,d4
		move.l	d2,d5
		move.b	#1,OnHelp(a5)			*On
		jsr	A5Help2(a5)
		bne.w	.Error

		move.l	a0,d1
		bne.w	.NimmA0

		*----- Enginehelp ------*
		cmp.w	#EPNr_Engine,d4
		bne.s	.NoEngine1
.FuerActive:	move.l	d5,d0
		jsr	A5FindUserStruct(a5)
		bne.w	.Error
		move.l	UPrgS_EUSAdr(a0),d0
		beq.s	.UPrg_NoTaglist
		move.l	d0,a6
		move.l	EUS_TagList(a6),d0
		beq.s	.UPrg_NoTagList
		move.l	d0,a6
		move.l	#EUT_Helpnodename,d0
		jsr	A5FindTag2(a5)
		bne.s	.UPrgS_NameDa
.UPrg_NoTagList:move.l	UPrgS_Name(a0),a6
.UPrgS_NameDa:	move.l	a6,a0
		LA3	LNr_EngineGuideName
		bra.w	.NimmA0

		*---- Playerhelp -----*
.NoEngine1:	cmp.w	#EPNr_Player,d4
		bne.s	.NoPlayer
		move.l	d5,d0
		jsr	A5FindPlayerStruct(a5)
		bne.w	.Error
		move.l	EPPl_Taglist(a0),d0
		beq.s	.EPP_NoTaglist
		move.l	d0,a6
		move.l	#EP_Helpnodename,d0
		jsr	A5FindTag2(a5)
		bne.s	.EPP_NameDa
.EPP_NoTaglist:	move.l	a0,a4
		lea	TextPuffer(a5),a0
		jsr	A5getPlayername(a5)
		lea	TextPuffer(a5),a6
.EPP_NameDa:	move.l	a6,a0
		LA3	LNr_PlayerGuideName
		bra.w	.NimmA0

	*################ Engine-Submenu #################*
.NoPlayer:	cmp.w	#EPNr_EngineItemCommand,d4
		bne.w	.NoEngineCommand
		LA3	LNr_EngineGuideName
		move.l	d5,d0
		jsr	A5FindUserStruct(a5)
		bne.w	.Error
		move.l	a0,a1
		lea	UPrgS_SubItem(a0),a0
.SucheItem:	move.l	(a0),d0
		beq.w	.NoItemFound
		move.l	d0,a0
		cmp.w	EPMI_EPNr(a0),d3
		bne.s	.SucheItem

		*-- Active --*
		cmp.w	#EPNr_MainWindow,d3
		bne.s	.EMC_NoActive
		jsr	A5ClearMenuStrip(a5)
		bclr	#0,12(a0)
		move.l	UPrgS_UFlags(a1),d0
		btst	#UPrgF_Active,d0
		beq.s	.EMIA_SetMenu
		bset	#0,12(a0)
.EMIA_SetMenu:	jsr	A5SetMenuStrip(a5)
		bra.w	.FuerActive

		*-- Show --*
.EMC_NoActive:	cmp.w	#EPNr_EngineShowState,d3
		bne.s	.EMC_NoShow
		jsr	A5ClearMenuStrip(a5)
		bclr	#0,12(a0)
		move.l	UPrgS_UFlags(a1),d0
		btst	#UPrgF_Show,d0
		beq.s	.EMIS_SetMenu
		bset	#0,12(a0)
.EMIS_SetMenu:	jsr	A5SetMenuStrip(a5)
		LA0	LNr_Showlink
		bra.w	.NimmA0

		* Alle weiteren Eintrge setzen sich aus dem Namen des
		* Engines und der Nummer des Items nach dem Item zeigen
		* EPNr_FirstExternal = 1
		*-- Enginename als Nodename (in Englisch betrachtet)
		*BSP: Eagleexotic --> Active		(DT: Aktiv)
		*		  --> Zeigen
		*		  --> Select ExoticPath (DT: Whle Exoticpfad)
		*
		* Nodename: Eagleexotic_1
		*----------------------------------------------------------*
.EMC_NoShow:	*---- Haken in Enginemenu rcksetzen ----*
		movem.l	a0/a1,-(a7)
		move.l	UPrgS_EUSAdr(a1),d0
		beq.w	.EMC_NoItemFound
		move.l	d0,a1		
		move.l	EUS_TagList(a1),d0
		beq.s	.EMC_NoItemFound
		move.l	d0,a6
		move.l	#EUT_UpdateEngineMenu,d0
		jsr	A5ClearMenuStrip(a5)
		jsr	A5CallUp3(a5)
		jsr	A5SetMenuStrip(a5)
.EMC_NoItemFound:movem.l (a7)+,a2/a3		* a2=Item a3=UPrgS

		move.l	UPrgS_Name(a3),a0
		move.l	UPrgS_EUSAdr(a3),d0
		beq.w	.JaUPrg_NameDa
		move.l	d0,a6
		move.l	EUS_TagList(a6),d0
		beq.w	.JaUPrg_NameDa
		move.l	d0,a6
		move.l	#EUT_Helpnodename,d0
		jsr	A5FindTag2(a5)
		beq.w	.JaUPrg_NameDa
		move.l	a6,a0
.JaUPrg_NameDa:	lea	TextPuffer(a5),a1
		move.w	#TextPufferSize-2,d1
		jsr	A5StringCopy2(a5)
		move.b	#"_",(a1)+

		move.l	a1,a0
		moveq	#0,d0
		move.w	EPMI_EPNr(a2),d0
		sub.w	#EPNr_FirstExternal-1,d0
		jsr	A5Hexdez(a5)

		lea	TextPuffer(a5),a0
		LA3	LNr_EngineGuideName
		bra.s	.NimmA0

.NoEngineCommand:cmp.w	#EPNr_Documentation,d4
		bne.s	.NoDokumentation
		LA3	LNr_MainGuideName
		LA0	LNr_MainLink
		bra.s	.NimmA0

	*############### Normalhelp (Fadein,Loadmodule) ##################*
.NoDokumentation:move.w	EPRT_StrLNr(a4),d0
		jsr	A5GetLocaleString(a5)
		LA3	LNr_MainGuideName
.NimmA0:	move.l	a0,ScrollArgs+4(a5)		*Nodename
		move.l	a3,ScrollArgs(a5)		*Guidename
		LA0	LNr_GuideALink
		lea	ScrollArgs(a5),a1
		jsr	A5MakeCorrectText(a5)

		move.l	HelpHandle(a5),d0
		beq.s	.No
		move.l	d0,a0
		lea	ScrollPuffer(a5),a1		*Kommando
		move.l	a1,d0
		moveq	#0,d1
		move.l	EPG_AmigaGuideBase(a5),a6
		jsr	_LVOSendAmigaGuideCmdA(a6)

		*move.l	#50,d1
		*jsr	A5Delay3(a5)


	*################ Haken im PD-Menu zurcksetzen ###################*
.No:		*----- Normaler Prefshaken (Fadein) -----*
		move.l	d4,d0
		jsr	A5GetMenuItemAdr(a5)
		bne.w	.NoItemFound
		move.l	d4,d0
		cmp.w	#EPNr_Engine,d0
		beq.w	.EngineItem
.NoEngine:	lea	KommandoTabelle,a1
		and.l	#$ffff,d0
		mulu	#EPRT_SizeOf,d0
		lea	-EPRT_SizeOf(a1,d0.l),a1
		move.b	EPRT_Flags(a1),d0		*Preference extra
		btst	#EPRTF_Switch,d0
		beq.s	.SetMutal
		move.w	EPRT_Status(a1),d3
		move.b	(a5,d3.w),d2
		move.b	12(a0),d3
		and.b	#1,d3
		cmp.b	d3,d2
		beq.s	.NoItemFound
		jsr	A5ClearMenuStrip(a5)
		bclr	#0,12(a0)
		or.b	d2,12(a0)
		jsr	A5SetMenuStrip(a5)
		bra.s	.NoItemFound

.EngineItem:	move.l	d5,d0
		jsr	A5FindUserStruct(a5)
		bne.s	.NoItemFound
		jsr	A5ClearMenuStrip(a5)
		jsr	A5ClearEngineZustand(a5)
		btst	#UPrgF_Active,UPrgS_UFlags+3(a0)
		beq.s	.EngineNoOn
		jsr	A5SetEngineZustand(a5)
.EngineNoOn:	jsr	A5SetMenuStrip(a5)
		bra.s	.NoItemFound


.SetMutal:	move.l	d4,d0
		jsr	A5SetMutalExclude(a5)
.NoItemFound:	moveq	#0,d0
		rts

.Error:		jsr	A5ScrollNewFehler(a5)
		bra.w	.No

*-----------------------------------------------------------------------------*
* Fr Aufruf aus dem Manager.
* Input: d2    (Arg1) = Eagleplayercommandnummer
*			bei Playern EPNr_Firstplayer++
*			bei Engines EPNr_FirstEngine++
*	 a3/d3 (Arg2) = Nodename
*	 a1	      = NextArg
*	 a4	      = Commandstructure
*-----------------------------------------------------------------------------*
HelpLink2:	*---- richtige EPNummer setzen ----*
		move.l	a3,a0
		move.l	a3,d0
		bne.s	.NodenameDa

		moveq	#0,d3
		sub.l	a3,a3
		moveq	#EPRTAB_String1!EPRTAB_Must1,d0
		jsr	A5GibArg(a5)		;>- d0=Fehler oder Null
		bne.w	.NoNodeName
		move.l	d1,d3			;>- a0=StringBeginn
		move.l	a0,a3
		
.NodenameDa:	tst.l	d3
		beq.s	.NoClr
		clr.b	(a3,d3.w)
.NoClr:		LA3	LNr_MainGuideName
.NoNodename:	move.l	d2,d0
		cmp.w	#EPNr_FirstPlayer,d0
		blo.s	.NoPlayer
		cmp.w	#EPNr_LastPlayer,d0
		bhi.s	.NoPlayer
		sub.w	#EPNr_FirstPlayer,d0
		move.w	d0,d2			;Nummer in d1
		move.w	#EPNr_Player,d0
		LA3	LNr_PlayerGuideName
		bra.s	.NoEngine

		*---- Engine aufgerufen ----*
.NoPlayer:	cmp.w	#EPNr_FirstEngine,d0
		blo.s	.NoEngine
		cmp.w	#EPNr_LastEngine,d0
		bhi.s	.NoEngine
		sub.w	#EPNr_FirstEngine-1,d0
		move.w	d0,d2
		move.w	#EPNr_Engine,d0
		LA3	LNr_EngineGuideName

		*--- Kommando in der Tabelle finden ---*
.NoEngine:	move.l	d0,d1
		lea	KommandoTabelle-EPRT_SizeOf,a4
		mulu	#EPRT_SizeOf,d1
		lea	(a4,d1.w),a4
		bra.w	HelpMe2

*-----------------------------------------------------------------------------*
* Input: d2=EPS_Samplestruct
*	 d3=Samplesavertags
PlaySample2:	move.l	d2,a2
		tst.l	EPS_Adr(a2)
		beq.w	.ErrorInArgs
		tst.l	EPS_Length(a2)
		beq.w	.ErrorInArgs

		movem.l	d0-a6,-(a7)
		jsr	A5StopInterrupt(a5)
		movem.l	(a7)+,d0-a6

		lea	SampleStructure(a5),a0
		clr.l	EPS_Adr(a0)
		clr.l	EPS_Length(a0)

		move.l	d2,PlaySampleStruct(a5)
		move.l	d3,SampleSaverTags(a5)
		move.l	EPG_AmplifierTagList(a5),PS_AmplTaglist(a5)
		move.l	EPG_AudioStruct(a5),PS_AudioStruct(a5)
		move.l	SS_StructAdr(a5),PS_StructAdr(a5)
		move.w	BalanceOn(a5),PS_BalanceOn(a5)
		move.w	VolumeOn(a5),PS_VolumeOn(a5)
		move.w	VoicesOn(a5),PS_VoicesOn(a5)

		*-- Aus Allesraus --*
		bsr	PlaySampleEndAudstruct

		*--- eigene AS_Struct initialisieren ---*
		move.l	d2,a2
		move.l	d3,a3
		bsr	PlaySampleInitAudStruct

		*-- aus Initplayer --*
		move.l	EPG_AmplifierList(a5),d1
		;sucht einfach die Liste von vorn bis hinten durch
		;(da die Amplifier bereits nach Prioritt sortiert sind)
.AMsuch_loop:	beq.s	.AM_nonefound
		move.l	d1,a0			;EUS_Start Struktur
		move.w	EUS_Flags(a0),d2	;Amplifier erlaubt ?
		and.b	#EUSB_Disable,d2
		bne.s	.AMsuch_next		;nein

		move.l	EUS_SpecialJumpTab(a0),d2
		beq.s	.AMsuch_next
		move.l	d2,a0
		move.l	AMJ_Init(a0),d2		;Einsprung fr Init
		beq.s	.AMsuch_next
		move.l	d2,a1

		move.l	EPG_AmplifierTagList(a5),a0
		movem.l	d1-a6,-(sp)
		jsr	(A1)			;Test & Init
		movem.l	(sp)+,d1-a6
		tst.l	d0
		beq.s	.AM_found
.AMsuch_next:	move.l	d1,a0
		move.l	EUS_Identifier(a0),d1
		bra.s	.AMsuch_loop

.AM_found:	move.l	d1,EPG_ActiveAmplifier(A5)
		move.l	d1,a0
		*move.l	EUS_Reserved5(a0),SS_StructAdr(a5)
		move.l	EUS_AMUPSStruct(a0),SS_StructAdr(a5)

		jsr	A5ClearSS_Struct(a5)
		moveq	#1,d0
		move.w	d0,VolumeOn(a5)
		move.w	d0,BalanceOn(a5)
		move.w	d0,VoicesOn(a5)

.AmplifierDa:	move.l	#PlaySampleTags,PlayerAdrSample(a5)
		move.l	#PlaySampleTags,EPG_PlayerTagList(a5)
		jsr	A5StartInterrupt(a5)
		bsr	PlaySampleInit
		moveq	#0,d0
		rts





	*---- Error oder altes Module wird wieder hergestellt ------*
.AM_Nonefound	moveq	#EPR_NoAmplifier,d0	;kein passender AM gefunden
		jsr	A5PlaySampleRestoreModule(a5)
		bra	.Return

.ErrorInArgs:	moveq	#EPR_ErrorInArguments,d0
.Return:	tst.l	d0
		rts

*-----------------------------------------------------------------------------*
* Aufruf wie bei Allesraus:
PlaySampleEndAudstruct:
		movem.l	d1-a6,-(sp)
		move.l	EPG_ActiveAmplifier(A5),d0
		beq.s	.KillModnoAM
		move.l	d0,a0
		move.l	EUS_SpecialJumpTab(a0),d0
		beq.s	.KillModNoAm
		move.l	d0,a0
		move.l	AMJ_End(a0),d0		;Einsprung fr EndAmplifier
		beq.s	.KillModNoAm
		move.l	d0,a0
		jsr	(a0)
.KillModnoAM:	clr.l	EPG_ActiveAmplifier(A5)
		movem.l	(sp)+,d1-a6
		rts


*-----------------------------------------------------------------------------*
* Hier wird alte Audstruct wieder hergestellt.
* Output:d0=Error oder NULL
PlaySamplerestoreModule:
		movem.l	d1-a6,-(a7)
		move.l	PS_AmplTaglist(a5),EPG_AmplifierTagList(a5)
		move.l	PS_AudioStruct(a5),EPG_AudioStruct(A5)
		move.l	PS_StructAdr(a5),SS_StructAdr(a5)
		move.w	PS_BalanceOn(a5),BalanceOn(a5)
		move.w	PS_VolumeOn(a5),VolumeOn(a5)
		move.w	PS_VoicesOn(a5),VoicesOn(a5)

		tst.l	PS_AmplTagList(a5)
		beq.s	.noAmplifier

	move.l	EPG_AmplifierList(a5),d1

	;sucht einfach die Liste von vorn bis hinten durch
	;(da die Amplifier bereits nach Prioritt sortiert sind)
.AMsuch_loop
	beq.s	.AM_nonefound
	move.l	d1,a0			;EUS_Start Struktur

	move.w	EUS_Flags(a0),d2	;Amplifier erlaubt ?
	and.b	#EUSB_Disable,d2
	bne.s	.AMsuch_next		;nein

	move.l	EUS_SpecialJumpTab(a0),d2
	beq.s	.AMsuch_next
	move.l	d2,a0
	move.l	AMJ_Init(a0),d2		;Einsprung fr Init
	beq.s	.AMsuch_next
	move.l	d2,a1

	move.l	EPG_AmplifierTagList(a5),a0
	movem.l	d1-a6,-(sp)
	jsr	(A1)			;Test & Init
	movem.l	(sp)+,d1-a6
	tst.l	d0
	beq.s	.AM_found
.AMsuch_next
	move.l	d1,a0
	move.l	EUS_Identifier(a0),d1
	bra.s	.AMsuch_loop
.AM_found
	move.l	d1,EPG_ActiveAmplifier(A5)

	tst.l	SS_StructAdr(a5)
	bne.s	.noAmplifier

	move.l	d1,a0
	*move.l	EUS_Reserved5(a0),SS_StructAdr(a5)
	move.l	EUS_AMUPSStruct(a0),SS_StructAdr(a5)

	jsr	A5ClearSS_Struct(a5)
	moveq	#1,d0
	move.w	d0,VolumeOn(a5)
	move.w	d0,BalanceOn(a5)
	move.w	d0,VoicesOn(a5)

	bra.s	.noAmplifier
.AM_Nonefound
	moveq	#EPR_NoAmplifier,d0	;kein passender AM gefunden
	bra	.Return


.noAmplifier:	moveq	#0,d0



.Return:
		*--- Konvertiertes Sample freigeben ---*
		lea	SampleStructure(a5),a0
		move.l	EPS_Adr(a0),d0
		beq.s	.NoExtraMem
		move.l	d0,a1
		move.l	EPS_Length(a0),d0
		beq.s	.NoExtraMem
		Execbase
		jsr	_LVOFreeMem(a6)
.NoExtraMem:	lea	SampleStructure(a5),a0
		clr.l	EPS_Adr(a0)
		clr.l	EPS_Length(a0)

		clr.l	PlayerAdrSample(a5)
		clr.l	PS_AmplTaglist(a5)
		clr.l	PS_AudioStruct(a5)
		clr.l	PS_StructAdr(a5)
		clr.l	PlaySampleStruct(a5)
		clr.l	SampleSaverTags(a5)
		clr.w	PS_BalanceOn(a5)
		clr.w	PS_VolumeOn(a5)
		clr.w	PS_VoicesOn(a5)
		move.l	PlayerAdr(a5),EPG_PlayerTagList(a5)
		movem.l	(a7)+,d1-a6
		tst.l	d0
		rts





*-----------------------------------------------------------------------------*
PlaySampleTags:	dc.l	DTP_InitSound,PlaySampleInit
		dc.l	DTP_Interrupt,PlaySampleInterrupt
		dc.l	EP_SetPlayFrequency,PlaySampleFreq
		dc.l	EP_Sampleplayer,1
		dc.l	0

*-----------------------------------------------------------------------------*
PlaySampleInit:	
		moveq	#$3,d1
		move.l	#$0,d0
		jsr	ENPP_DmaMask(a5)

		move.l	PlaySampleStruct(a5),a4
		move.l	EPS_Adr(a4),d0
		moveq	#0,d1
		jsr	ENPP_PokeAdr(a5)
		moveq	#1,d1
		jsr	ENPP_PokeAdr(a5)

		move.l	EPS_Length(a4),d0
		lsr.l	#1,d0
		jsr	ENPP_PokeLen(a5)
		moveq	#0,d1
		jsr	ENPP_PokeLen(a5)

		move.l	SampleSaverTags(a5),a6
		move.l	#SS_DefFreqPtr,d0
		jsr	A5FindTag2(a5)
		beq.s	.NoDef
		move.l	(a6),d0
		beq.s	.NoDef
		bsr	PlaySampleFreq
		bra.s	.PerOk

.NoDef:		move.l	EPS_Period(a4),d0
		bne.s	.PerDa
		move.l	#400,d0
.PerDa:		moveq	#0,d1
		jsr	ENPP_PokePer(a5)
		moveq	#1,d1
		jsr	ENPP_PokePer(a5)

.PerOk:		moveq	#64,d0
		jsr	ENPP_PokeVol(a5)
		moveq	#64,d1
		jsr	ENPP_PokeVol(a5)

		moveq	#3,d1
		move.l	#$8003,d0
		jsr	ENPP_DmaMask(a5)
		rts

*-----------------------------------------------------------------------------*
PlaySampleInterrupt:
		move.l	PufferAdr3(pc),a5
		jsr	ENPP_Amplifier(a5)
		moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
PlaySampleFreq:	move.l	#3579546,d1
		divu	d0,d1
		move.l	d1,d0

		moveq	#0,d1
		jsr	ENPP_PokePer(a5)
		moveq	#1,d1
		jsr	ENPP_PokePer(a5)
		rts



*-----------------------------------------------------------------------------*
* Input: a2=EPS_Samplestruct
*	 a3=Samplesavertags
PlaySampleInitAudstruct:
		movem.l	d0-a6,-(a7)
		moveq	#0,d5
.Retry:		moveq	#EPAMB_WaitforStruct!EPAMB_Direct!EPAMB_8Bit,d7
		move.w	EPS_Flags(a2),d0
		btst	#USIF_8Bit,d0
		bne.s	.Bit8
		moveq	#EPAMB_WaitforStruct!EPAMB_Direct!EPAMB_16Bit,d7
.Bit8:	btst	#USIF_Intel,d0
	bne.s	.Konvertieren
		*btst	#USIF_Intel,d0
		*beq.s	.NoIntel
		*bset	#EPAMF_Intel,d7
.NoIntel:	btst	#USIF_Unsigned,d0
		beq.s	.NoUnsigned
		bset	#EPAMF_8BitUnsigned,d7
.NoUnsigned:

		move.l	EPS_Adr(a2),a1
		Execbase
		jsr	_LVOTypeOfMem(a6)
		btst	#1,d0
		beq.s	.Nochip
		or.w	#EPAMB_ChipRam,d7
.NoChip:	move.l	d7,PlaySampleAMFlags

		lea	PlaySampleAudstruct(pc),a0	;Audio Struktur vorbereiten
		lea	(a0),a1
		move.w	#as_sizeof*4-1,d0
.clr:		clr.b	(a1)+
		dbf	d0,.clr

		move.w	#01,AS_Leftright(a0)			;1. Kanal links
		move.w	#-1,AS_Leftright+as_sizeof*1(a0)	;2. Kanal rechts

		lea	PlaySampleAudTagliste(pc),a0
		jsr	ENPP_FindAmplifier(a5)
		bne.w	.Ok

		*--- Sample auf 8Bit runterrechnen ---*
.Konvertieren:	tst.l	d5
		bne.w	.Ok
		moveq	#1,d5
		move.l	a2,a4
		move.w	EPS_Flags(a2),d3
		btst	#USIF_8Bit,d3		;an 8Bit liegt das nicht
		bne.w	.Ok
		btst	#USIF_16Bit,d3		;16Bit ? nein-> dann weg
		beq.w	.Ok


		*--- Lnge des Mem ausrechen ---*
		moveq	#USIB_8Bit,d2		;verlangt
		move.l	EPS_Length(a4),d0
		lsr.l	#1,d0
		move.l	#$10001,d1
		move.l	d0,d6
		move.l	4,a6
		jsr	_LVOAllocMem(a6)
		move.l	d0,a2
		tst.l	d0
		beq.w	.Ok
		
		*- Originalsample jetzt in verlangtes Format konvertieren -*
		move.w	EPS_Flags(a4),d3
		move.l	EPS_Length(a4),d1
		lsr.l	#1,d1
		move.l	EPS_Adr(a4),a0
		move.l	a2,a1

	*-- d1=sourcelen
	*-- d2=Verlangtflags
	*-- d3=sourceflags
.Next16:	move.b	(a0)+,d0		;Source Byte/Word auf
		move.b	(a0)+,d4
		btst	#USIF_Intel,d3
		beq.s	.NoSourceIntel
		exg	d0,d4
.NoSourceIntel:	btst	#USIF_Unsigned,d3
		beq.s	.NoSourceUnsigned
		add.b	#$80,d0
.NoSourceUnsigned:
		move.b	d0,(a1)+
		subq.l	#1,d1
		bhi.s	.Next16



		*-- Zeiger auf falsche Structure setzen --*
		lea	SampleStructure(a5),a0
		move.l	a2,EPS_Adr(a0)
		move.w	d2,EPS_Flags(a0)
		clr.w	EPS_Type(a0)
		move.l	d6,EPS_Length(a0)

		move.l	EPS_SampleName(a4),EPS_SampleName(a0)
		*move.l	EPS_Repeat(a4),d0
		*lsr.l	#1,d0
		*move.l	d0,EPS_Repeat(a0)
		*move.l	EPS_Replen(a4),d0
		*lsr.l	#1,d0
		*move.l	d0,EPS_Replen(a0)
		move.l	EPS_Period(a4),EPS_Period(a0)
		move.l	EPS_Volume(a4),EPS_Volume(a0)
		move.w	EPS_Finetune(a4),EPS_Finetune(a0)
		move.w	EPS_MaxNameLen(a4),EPS_MaxNameLen(a0)
		lea	SampleStructure(a5),a2
		move.l	a2,PlaySampleStruct(a5)
		bra.w	.Retry


.Ok:		lea	PlaySampleAudTagliste(pc),a0
		move.l	a0,EPG_AmplifierTagList(a5)

		movem.l	(a7)+,d0-a6
		rts


PlaySampleAudTagliste:
		dc.l	EPAMT_Numstructs,2
		dc.l	EPAMT_Audiostructs,PlaySampleAudstruct
		dc.l	EPAMT_Flags
PlaySampleAMFlags:dc.l	0
		dc.l	0

PlaySampleAudstruct:
		ds.b	as_sizeof*4

*--------------------------------------------------------------------------------------------------------------*
LoadAppIcon:	movem.l	d1-a6,-(a7)
		jsr	A5FreeAppIcon(a5)

		LA1	LNr_Iconname
		lea	EPG_Iconbase(a5),a3
		moveq	#37,d0
		jsr	A5OpenLib(a5)
		beq.w	.Return

		LA0	LNr_AppIconName
		move.l	EPG_IconBase(a5),a6
		jsr	_LVOGetDiskObject(a6)
		move.l	d0,AppIconObject(a5)
.Return:	movem.l	(a7)+,d1-a6
		move.l	AppIconObject(a5),d0
		rts

*--------------------------------------------------------------------------------------------------------------*
FreeAppIcon:	movem.l	d0-a6,-(a7)
		move.l	EPG_IconBase(a5),d0
		beq.s	.Return
		move.l	d0,a6
		move.l	AppIconObject(a5),d0
		beq.s	.Return
		move.l	d0,a0
		jsr	_LVOFreeDiskObject(a6)
.Return:	clr.l	AppIconObject(a5)
		movem.l	(a7)+,d0-a6
		rts


























USAB		Macro
		dc.b	"\1"		;EENST_Identifier
		dc.b	\2		;EENST_Mode
		dc.w	\3		;EENST_Offset
		endm

PlayerStatusTabelle:
		PLAB2	vol,EENSTM_Zustand,DTP_Volume,EPF_Volume
		PLAB2	bal,EENSTM_Zustand,DTP_Balance,EPF_Balance
		PLAB2	voi,EENSTM_Zustand,EP_Voices,EPF_Voices
		PLAB2	jmp,EENSTM_Zustand,DTP_NextPatt,EPF_NextPatt
		PLAB2	upr,EENSTM_Zustand,EP_StructInit,EPF_Analyzer
		PLAB2	mii,EENSTM_Zustand,EP_Get_ModuleInfo,EPF_ModuleInfo
		PLAB2	sai,EENSTM_Zustand,EP_SampleInit,EPF_SampleInfo
		PLAB2	msa,EENSTM_Zustand,EP_Save,EPF_Save
		PLAB2	sge,EENSTM_Zustand,0,EPF_SongEnd
		PLAB2	lfa,EENSTM_Zustand,0,EPF_LoadFast
PlayerStatusFlagsAnz = (*-PlayerStatusTabelle)/EPLST_SizeOf2

		PLAB	nam,EENSTM_Proggy,PlayerGiveName-Jumpto
		PLAB	cre,EENSTM_String,DTP_Creator
		PLAB	ver,EENSTM_Word,DTP_PlayerVersion
		PLAB	kic,EENSTM_LongWord,EP_KickVersion
		PLAB	pve,EENSTM_LongWord,EP_Playerversion
		PLAB	cfg,EENSTM_Zustand,DTP_UserConfig
		PLAB	csa,EENSTM_Zustand,EP_SavePlConfig
		PLAB	clo,EENSTM_Zustand,EP_LoadPlConfig
		PLAB	plf,EENSTM_Zustand,DTP_Interrupt
		PLAB	mch,EENSTM_Zustand,EP_ModuleChange
		PLAB	mrs,EENSTM_Zustand,EP_ModuleRestore
		PLAB	dat,EENSTM_Proggy,PlayerGiveDate-Jumpto
		PLAB	tgl,EENSTM_Proggy,PlayerGiveTagListe-Jumpto
		PLAB	spd,EENSTM_Proggy,PlayerGiveSpeedZustand-Jumpto
		PLAB	sub,EENSTM_Proggy,PlayerGiveSubSongs-Jumpto
		PLAB	pos,EENSTM_Zustand,EP_GetPositionNr
		PLAB	msp,EENSTM_Zustand,EP_SaveAsPT
		PLAB	psa,EENSTM_Zustand,EP_PlaySample
		PLAB	pat,EENSTM_Zustand,EP_PatternInit
		PLAB	amp,EENSTM_Zustand,EP_InitAmplifier
		PLAB	rst,EENSTM_Proggy,PlayerGiveRestart-Jumpto
		PLAB	pck,EENSTM_Proggy,PlayerGivePacked-Jumpto
		PLAB	msm,EENSTM_LongWord,MI_MaxSamples
		PLAB	msy,EENSTM_LongWord,MI_MaxSynthSamples
		PLAB	mle,EENSTM_LongWord,MI_MaxLength
		PLAB	mpa,EENSTM_LongWord,MI_MaxPattern
		PLAB	mst,EENSTM_LongWord,MI_MaxSteps
		PLAB	mso,EENSTM_LongWord,MI_MaxSubSongs
		PLAB	mss,EENSTM_String,MI_UnpackedSystem
		PLAB	mpr,EENSTM_String,MI_Prefix
		PLAB	mab,EENSTM_String,MI_About
		PLAB	mmr,EENSTM_Longword,MI_PlayFrequency
		PLAB	mvb,EENSTM_Longword,MI_VolumeBoost
		PLAB	mpm,EENSTM_String,MI_PlayMode
		dc.w	0
		even

*--------------------- Moduleabhngige Einstellungen ------------------------*
ModuleStatusTabelle:
		*PLAB	pat,EENSTM_Proggy,ModuleGivePfad-JumpTo	;Modulepath
		PLAB	dir,EENSTM_StringPuffer,DirPuffer	;ModuleDir
		PLAB	fil,EENSTM_StringPuffer,TitlenamePuffer	;Modulename
		PLAB	pnr,EENSTM_Proggy,ModuleGivePlayerNr-JumpTo	;ak. Playernummer
		*PLAB	num,EENSTM_Longword,EPG_ModNr		;Position in Liste
	*	PLAB	min,EENSTM_PufferWord,MinSubSong	;min Anzahl Subsongs
	*	PLAB	max,EENSTM_PufferWord,MaxSubSong	;max Anzahl Subsongs
		PLAB	min,EENSTM_Proggy,ModuleGiveMinSubSong-JumpTo	;min Anzahl Subsongs
		PLAB	max,EENSTM_Proggy,ModuleGiveMaxSubSong-JumpTo	;max Anzahl Subsongs
		PLAB	aut,EENSTM_Proggy,ModuleGiveAutorName-JumpTo ;Authorname
		PLAB	son,EENSTM_Proggy,ModuleGiveSongName-JumpTo  ;Songname
		PLAB	len,EENSTM_Proggy,ModuleGiveLength-JumpTo    ;Length
		PLAB	dpt,EENSTM_Proggy,ModuleGivePatternAnz-JumpTo ;Difference Pattern
		PLAB	stp,EENSTM_Proggy,ModuleGiveSteps-JumpTo     ;Steps
		PLAB	sam,EENSTM_Proggy,ModuleGiveSamples-JumpTo   ;Samples
		PLAB	chk,EENSTM_Proggy,ModuleGiveCheck-JumpTo     ;CheckMod
	*	PLAB	pon,EENSTM_Proggy,ModuleGivePositionsNr-JumpTo ;PositionsNr
		dc.w	0
		even

EngineStatusTabelle:
		USAB	nam,EENSTM_String,EUS_UserName
		USAB	abo,EENSTM_String,EUS_AboutUPrg
		USAB	cre,EENSTM_String,EUS_Creator
		USAB	ver,EENSTM_Word,EUS_Version
		USAB	eve,EENSTM_LongWord,EUS_EPVersion
		USAB	kis,EENSTM_Word,EUS_KickStart
		USAB	rev,EENSTM_Word,EUS_Revision
		USAB	prz,EENSTM_String,EUS_PName
		USAB	win,EENSTM_Proggy,EngineGiveWinOffen-Jumpto
		USAB	co1,EENSTM_LongWord,EUS_Special
		USAB	co2,EENSTM_LongWord,EUS_Special2
		USAB	co3,EENSTM_LongWord,EUS_Special3
		USAB	kox,EENSTM_Word,EUS_WinX
		USAB	koy,EENSTM_Word,EUS_WinY
		USAB	dat,EENSTM_Proggy,EngineGiveDate-JumpTo
		USAB	typ,EENSTM_Proggy,EngineGiveType-JumpTo
		dc.w	0
		even









******************************************************************************
*
*
*
*
*
*	*- Nr,ProggyOffset,MenuOffset,A5Offset,0=nein,Prefsword,LNr ----*
*	*------ 0=nein (bit0=Zustand umgedreht; bit1=nur mit Key -------*
*
*
*PRMA		macro
*		ifne	\4
*		dc.w	\1!1<<15		;Nummer
*		else
*		dc.w	\1
*		endc
*		dc.w	\2-JumpTo		;Prg
*		dc.w	\3			;Offset
*		dc.w	\5			;LNr
*		endm
*
*	*----- AktionNr,HelpProggy,ZelleInA5,0=Ohne Key|1=Mit Key ------*
*PrefsTab:	PRMA EPNr_AutomaticSave,JumpTo,OnAutomaticSave,1,LNr_AutomaticSave
*		PRMA EPNr_Protect,JumpTo,OnProtect,1,LNr_Protect
*		PRMA EPNr_PBits,JumpTo,OnPBits,1,LNr_PBits
*		PRMA EPNr_SSDir,JumpTo,OnSSDir,1,LNr_SSDir
*		PRMA EPNr_Overwrite,JumpTo,OnOverwrite,1,LNr_Overwrite
*		PRMA EPNr_SafeSave,JumpTo,OnSafeSave,1,LNr_SafeSave
*		PRMA EPNr_SampleMode,JumpTo,OnSampleMode,1,LNr_SampleMode
*		PRMA EPNr_SaveAsProT,JumpTo,OnSaveAsProT,1,LNr_SaveAsProTracker
*
*		PRMA EPNr_LoadDir,LoadDir,OnLoadDir,0,LNr_LoadDir
*		PRMA EPNr_EPDir,JumpTo,OnEPDir,1,LNr_EPDir
*		PRMA EPNr_AutoDir,JumpTo,OnAutoDir,0,LNr_AutoDir
*		PRMA EPNr_Notify,JumpTo,OnNotify,0,LNr_Notify
*		PRMA EPNr_ScanAlways,JumpTo,OnScanAlways,0,LNr_ScanAlways
*		PRMA EPNr_HideAll,HideAll,OnHideAll,0,LNr_HideAll
*
*		PRMA EPNr_FadeOut,JumpTo,OnFadeOut,0,LNr_FadeOut
*		PRMA EPNr_Fadein,JumpTo,OnFadein,0,LNr_Fadein
*		PRMA EPNr_Filter,SetFilter,DTG_Led,0,LNr_Filter
*		PRMA EPNr_MasterVolume,JumpTo,OnMasterVolume,1,LNr_MasterVolume
*		PRMA EPNr_ScrollInfos,JumpTo,OnScrollInfos,0,LNr_ScrollInfos
*		PRMA EPNr_SongName,TitleAufbau,OnUseSongName,1,LNr_Songname
*		PRMA EPNr_UsePrefix,JumpTo,OnUsePrefix,1,LNr_Prefix
*		PRMA EPNr_SaveT,JumpTo,OnSaveT,1,LNr_SaveT
*		PRMA EPNr_LoadFast,LoadFast,OnLoadFast,0,LNr_LoadFast
*
*		PRMA EPNr_EjectPlayer,JumpTo,OnEjectPlayer,0,LNr_EjectPlayers
*		PRMA EPNr_EjectEngine,JumpTo,OnEjectEngine,1,LNr_EjectEngine
*		PRMA EPNr_PlayerBatch,JumpTo,OnPlayerBatch,0,LNr_PlayerBatch
*		PRMA EPNr_EngineBatch,Pr_SetBatchInMenu,OnEngineBatch,1,LNr_EngineBatch
*
*		PRMA EPNr_SongEnd,JumpTo,OnSongend,0,LNr_SongEnd
*		PRMA EPNr_TimeMode,SetRealyTime,OnTimeMode,0,LNr_TimeMode
*		PRMA EPNr_CalcDuration,JumpTo,OnCalcDuration,0,LNr_CalcDuration
*		PRMA EPNr_RandomStart,JumpTo,OnRandomStart,0,LNr_RandomStart
*		PRMA EPNr_Quickstart,JumpTo,OnQuickstart,0,LNr_Quickstart
*		PRMA EPNr_RandomSong,JumpTo,OnRandomSong,1,LNr_RandomSong
*		PRMA EPNr_LoadBefore,LoadBefore,OnLoadBefore,1,LNr_LoadBefore
*		PRMA EPNr_AutoSubSong,JumpTo,OnAutoSubSong,1,LNr_AutoSubSong
*		PRMA EPNr_LoadAlways,JumpTo,OnLoadAlways,1,LNr_LoadAlways
*
*		PRMA EPNr_SmallModule,JumpTo,OnSmallModule,1,LNr_SmallModule
*		PRMA EPNr_BigModule,JumpTo,OnBigModule,1,LNr_BigModule
*		PRMA EPNr_ModuleFault,JumpTo,OnModuleFault,1,LNr_ModuleFault
*
*		PRMA EPNr_AllocChannels,JumpTo,OnAllocChannels,0,LNr_AllocChannels
*		PRMA EPNr_SoftInt,JumpTo,OnSoftInt,0,LNr_SoftInt
*
*		PRMA EPNr_XFDDecrunch,JumpTo,OnXFDDecrunch,0,LNr_XFDDecrunch
*		PRMA EPNr_XFDLoadSeg,JumpTo,OnXFDLoadSeg,0,LNr_XFDLoadSeg
*		PRMA EPNr_AutoPassword,JumpTo,OnAutoPassword,1,LNr_AutoPassword
*		PRMA EPNr_LHAExtractor,JumpTo,OnUseLHA,0,LNr_LHAExtractor
*
*		dc.w 0
*
*



.LNr_Alert1Text:	dc.b	0,200,15,"EaglePlayer Error-Message !!!",0,1
			dc.b	0,190,22,"-------------------------------",0,1
Alert1Ende:
Alert2Text:		dc.b	0,30,75,"Quit EaglePlayer"
			dc.b	"                        "
			dc.b	"                Quit EaglePlayer",0,0
Alert2Ende:	*Even


	;******************************************************
	;**** Internal- & ExternalString(intern) einbinden ****
	;******************************************************
InternalStrings:
.LNr_StringError	dc.b	"STRING-ERROR !!!",0
.LNr_EPVersion		EP_Version
			dc.b	0

Dosname:
.LNr_Dosname		dc.b	"dos.library",0
.LNr_Intuiname		dc.b	"intuition.library",0
.LNr_IconName		dc.b	"icon.library",0
.LNr_Graphname		dc.b	"graphics.library",0
.LNr_GadToolsName	dc.b	"gadtools.library",0
.LNr_LocaleName		dc.b	"locale.library",0
.LNr_Reqname		dc.b	"req.library",0
.LNr_ASLName		dc.b	"asl.library",0
.LNr_ReqToolsName	dc.b	"reqtools.library",0
.LNr_LhName		dc.b	"lh.library",0
.LNr_PPName		dc.b	"powerpacker.library",0
.LNr_WBName		dc.b	"workbench.library",0
.LNr_DiskFontName	dc.b	"diskfont.library",0
.LNr_ScreenNotifyName	dc.b	"screennotify.library",0
.LNr_AmigaGuideName	dc.b	"amigaguide.library",0
.LNr_CommodityName	dc.b	`commodities.library`,0
.LNr_XPKName		dc.b	"xpkmaster.library",0
.LNr_XFDMasterName	dc.b	"xfdmaster.library",0
.LNr_CrMName		dc.b	"CrM.library",0
.LNr_Audioname		dc.b	"audio.device",0
.LNr_CiaBname		dc.b	"ciab.resource",0
.LNr_TopazName		dc.b	"topaz.font",0
.LNr_RexxSysName	dc.b	"rexxsyslib.library",0

ProzessName:
.LNr_Prozessname	dc.b	"Eagleplayer",0
.LNr_EPEnginePort	dc.b	"EAGLEPLAYERPORT",0
.LNr_EPReplayEnginePort	dc.b	"EAGLEPLAYERREPLAYPORT",0
.LNr_EPAppPort		dc.b	"EAGLEPLAYERAPPPORT",0
.LNr_EPArexxPort	dc.b	"rexx_EP",0
.LNr_EPScreenNotifyPort	dc.b	"EP_SCREENNOTIFYPORT",0
.LNr_InterruptName	dc.b	"EP_INTERRUPT",0
.LNr_TimerName		dc.b	"EP_CIAINT",0
.LNr_SoftIntName	dc.b	"EP_SOFTINT",0
.LNr_EPAudioName	dc.b	"EP_AUDIO",0
.LNr_EPNotifyName	dc.b	"EP_NOTIFY",0
.LNr_EPCommodityName	dc.b	"EP_COMMODITY",0
.LNr_CommoTitle		dc.b	" 1993-97 J. Blumenthal & H. Richter",0
.LNr_CommoText		dc.b	"A very cool Soundplayer",0
.LNr_SaveKopf		dc.b	"/* Eagleplayer V"
			EP_Version
			dc.b	" Configuration-File */",10,10,0
.LNr_EngineDir		dc.b	"Engines/",0
.LNr_EaglePlayerDir	dc.b	"Eagleplayers/",0
.LNr_MainGuideName	dc.b	"EP_Main.Guide",0
.LNr_EngineGuideName	dc.b	"EP_Engine.Guide",0
.LNr_PlayerGuideName	dc.b	"EP_Player.Guide",0
.LNr_GuideALink		dc.b	'ALINK "%s/%s"',0
.LNr_MainLink		dc.b	'MAIN',0
.LNr_ShowLink		dc.b	'SHOW',0
.LNr_InstrumentsDir	dc.b	"ST-01:",0
.LNr_TName		dc.b	"T:",0
.LNr_EPTName		dc.b	"T:EP_TempModule",0
.LNr_EnvName		dc.b	"Env:",0
.LNr_EnvarcName		dc.b	"EnvArc:",0
.LNr_SName		dc.b	"S:",0
.LNr_DevsName		dc.b	"Devs:",0
.LNr_LocaleAssign	dc.b	"LOCALE",0
.LNr_EPDir		dc.b	"EP:",0
.LNr_ConfigDir		dc.b	"Configs/",0
.LNr_EPDirName		dc.b	".EPDir",0
.LNr_ConfigDirName	dc.b	"EP-Configpath",0
.LNr_ConfigName		dc.b	"Eagleplayer.Config",0
.LNr_KeyName		dc.b	"Eagleplayer.Key",0
.LNr_PlayerBatch	dc.b	"Eagleplayer.Batch",0
.LNr_MainCatalog	dc.b	"EP_Main.catalog",0
.LNr_EngineCatalog	dc.b	"EP_Engine.catalog",0
.LNr_PlayerCatalog	dc.b	"EP_Player.catalog",0
.LNr_DefaultGui		dc.b	"Bifatgui",0

.LNr_WindowTitleR	dc.b	"EaglePlayer V"
			EP_Version
			if	BetaVersion
			dc.b	Betachar	;""
			endc
		if	master
			dc.b	" Master",0
		else
			dc.b	" Registered",0
		endc
.LNr_WindowTitleG	dc.b	"EaglePlayer V"
			EP_Version
			if	BetaVersion
			dc.b	Betachar		;""
			endc
			dc.b	" Generic",0
.LNr_EPTitle		dc.b	"EP "
			EP_Version
			dc.b	":",0
.LNr_CommentText	dc.b	"Saved with Eagleplayer V"
			EP_Version
			dc.b	" !",0
.LNr_Yes		dc.b	"yes",0
.LNr_On			dc.b	"on",0
.LNr_No			dc.b	"no",0
.LNr_Off		dc.b	"off",0
.LNr_1			dc.b	"1",0
.LNr_0			dc.b	"0",0
.LNr_Toggle		dc.b	"toggle",0
.LNr_Toggle2		dc.b	"-1",0

.LNr_DefaultHotkey	dc.b	"rawkey ctrl alt e",0
.LNr_DefPubScreen	dc.b	"Workbench",0



		*-------- Vergleichsstrings fr die Configuration ------*
.LNr_Str_Status		dc.b	"Status",0

		*----------- Windows ----------*
.LNr_Str_Popup		dc.b	"CX_Popup",0		;no CLI/Config
.LNr_Str_FastPlay	dc.b	"Fastplay",0		;no Cli/Config

.LNr_Str_HotKey		dc.b	"CX_Popkey",0		;key an 2.0
.LNr_Str_Priority	dc.b	"CX_Priority",0
.LNr_Str_ChipRamAmplifier dc.b	"ChipRamAmplifier",0	;no CLI/Arexx ...
.LNr_Str_FastRamAmplifier dc.b	"FastRamAmplifier",0	;no CLI/Arexx ...
.LNr_Str_PrintText	dc.b	"Printtext",0
.LNr_Str_ScrollText	dc.b	"Scrolltext",0
.LNr_Str_MenuFont	dc.b	"Menufont",0
.LNr_Str_ModulesFont	dc.b	"Modulesfont",0
.LNr_Str_ScrollFont	dc.b	"Scrollfont",0
.LNr_Str_Help		dc.b	"Help",0

.LNr_Str_DeleteFile	dc.b	"DeleteFile",0		;no Cli/Config
.LNr_Str_Iconify	dc.b	"Iconify",0		;no Cli/Config
.LNr_Str_LoadConfig	dc.b	"LoadConfig",0		;no Config
.LNr_Str_SaveConfig	dc.b	"SaveConfig",0		;no Cli/Config
.LNr_Str_Config		dc.b	"Config",0
.LNr_Str_AboutEP	dc.b	"AboutEP",0		;no Cli/Config
.LNr_Str_Hide		dc.b	"Hide",0		;no Cli/Config
.LNr_Str_Quit		dc.b	"Quit",0		;no Cli/Config

.LNr_Str_LoadGui	dc.b	"LoadGui",0
.LNr_Str_DeleteGui	dc.b	"DeleteGui",0

.LNr_Str_LoadPlayer	dc.b	"LoadPlayer",0
.LNr_Str_LoadPlayerDir	dc.b	"LoadPlayerDir",0
.LNr_Str_DeletePlayer	dc.b	"DeletePlayer",0	;no Cli/Config
.LNr_Str_DeleteAllPlayer dc.b	"DeleteAllPlayer",0	;no Cli/Config
.LNr_Str_Enable		dc.b	"Enable",0		;no Cli/Config
.LNr_Str_LoadPlayerConfig dc.b	"LoadPlayerConfig",0	;no Cli/Config
.LNr_Str_SavePlayerConfig dc.b	"SavePlayerConfig",0	;no Cli/Config
.LNr_Str_PlayerConfig	dc.b	"Playerconfig",0	;no Cli/Config

.LNr_Str_LoadEngine	dc.b	"LoadEngine",0
.LNr_Str_LoadEngineDir	dc.b	"LoadEngineDir",0	;no Cli/Config
.LNr_Str_DeleteEngine	dc.b	"DeleteEngine",0	;no Cli/Config
.LNr_Str_DeleteAllEngines dc.b	"DeleteAllEngines",0	;no Cli/Config

.LNr_Str_XPKPackmethod	dc.b	"XPKPackmethod",0
.LNr_Str_Password	dc.b	"Password",0
.LNr_Str_Instruments	dc.b	"Instruments",0

.LNr_Str_Module		dc.b	"Module",0		;no Cli/Config mit Nr
.LNr_Str_LoadModule	dc.b	"LoadModule",0		;mit Pfad
.LNr_Str_SaveModule	dc.b	"SaveModule",0		;no Cli/Config
.LNr_Str_SaveModulePrefs dc.b	"SaveModulePrefs",0	;no Cli/Config
.LNr_Str_SaveDir	dc.b	"SaveDir",0		;no Arexx/Engine
.LNr_Str_Eject		dc.b	"Eject",0		;no Cli/Config
.LNr_Str_PrevSong	dc.b	"PrevSong",0		;no Cli/Config
.LNr_Str_NextSong	dc.b	"NextSong",0		;no Cli/Config
.LNr_Str_SubSong	dc.b	"SubSong",0
.LNr_Str_PrevPattern	dc.b	"PrevPatt",0		;no Cli/Config
.LNr_Str_NextPattern	dc.b	"NextPatt",0		;no Cli/Config
.LNr_Str_PrevModule	dc.b	"PrevModule",0		;no Cli/Config
.LNr_Str_NextModule	dc.b	"NextModule",0		;no Cli/Config
.LNr_Str_Pause		dc.b	"Pause",0		;no Cli/Config
.LNr_Str_Play		dc.b	"Play",0		;no Cli/Config
.LNr_Str_Stop		dc.b	"Stop",0		;no Cli/Config
.LNr_Str_ReplaySong	dc.b	"ReplaySong",0		;no Cli/Config
.LNr_Str_AboutModule	dc.b	"Aboutmodule",0		;no Cli/Config

.LNr_Str_PubScreen	dc.b	"PubScreen",0
.LNr_Str_Filter		dc.b	"Filter",0
.LNr_Str_ToggleFilter	dc.b	"ToggleFilter",0
.LNr_Str_FadeIn		dc.b	"FadeIn",0
.LNr_Str_FadeOut	dc.b	"FadeOut",0
.LNr_Str_QuitEagle	dc.b	"QuitEagle",0
.LNr_Str_SaveT		dc.b	"SaveT",0
.LNr_Str_ScrollInfos	dc.b	"ScrollInfos",0
.LNr_Str_LoadFast	dc.b	"LoadFast",0
.LNr_Str_SongName	dc.b	"SongName",0
.LNr_Str_Prefix		dc.b	"Prefix",0
.LNr_Str_EjectPlayer	dc.b	"EjectPlayers",0
.LNr_Str_EjectEngine	dc.b	"EjectEngines",0
.LNr_Str_PlayerBatch	dc.b	"PlayerBatch",0
