#include <dos/dos.h>
#include <exec/types.h>
#include <clib/alib_protos.h>

#ifndef BozDate
#define BozDate

struct HMS
{
	LONG hours;
	BYTE minutes;
	BYTE seconds;
};

LONG MINUTES_PER_DAY=1440; /* 60*24 */
LONG TICKS_PER_MINUTE=TICKS_PER_SECOND*60;

LONG BozCompareDates(struct DateStamp *BCDa,struct DateStamp *BCDb)
{
	LONG doff,moff,toff;

	if( !( (BCDa!=0) & (BCDb!=0) ) )
	{
		return(0);
	} /* if */

	doff=BCDb->ds_Days-BCDa->ds_Days;
	moff=BCDb->ds_Minute-BCDa->ds_Minute;
	toff=BCDb->ds_Tick-BCDa->ds_Tick;

	return( (doff*MINUTES_PER_DAY*TICKS_PER_MINUTE) + (moff*TICKS_PER_MINUTE) + toff );
}

struct HMS *TicksToHMS(LONG Ticks,struct HMS *DestHMS)
{
	DestHMS->seconds=(Ticks/50)%60;
	DestHMS->minutes=(Ticks/3000)%60;
	DestHMS->hours=Ticks/180000;
	return(DestHMS);
}

LONG HMSToTicks(struct HMS *SourceHMS)
{
	LONG ticks=0;
	ticks+=SourceHMS->seconds*50;
	ticks+=SourceHMS->minutes*3000;
	ticks+=SourceHMS->hours*180000;
	return(ticks);
}

struct HMS *SecsToHMS(LONG Secs,struct HMS *DestHMS)
{
	DestHMS->seconds=(Secs)%60;
	DestHMS->minutes=(Secs/60)%60;
	DestHMS->hours=Secs/3600;
	return(DestHMS);
}

LONG HMSToSecs(struct HMS *SourceHMS)
{
	LONG Secs=0;
	Secs+=SourceHMS->seconds;
	Secs+=SourceHMS->minutes*60;
	Secs+=SourceHMS->hours*3600;
	return(Secs);
}

LONG CompareHMS(struct HMS *HMSa,struct HMS *HMSb )
{
	LONG seca=0,secb=0;
	seca+=HMSa->seconds;
	seca+=HMSa->minutes*60;
	seca+=HMSa->hours*3600;

	secb+=HMSb->seconds;
	secb+=HMSb->minutes*60;
	secb+=HMSb->hours*3600;

	return(secb-seca);
}

void AddHMS(struct HMS *Left,struct HMS *Right)
{
	LONG leftticks=HMSToTicks(Left),rightticks=HMSToTicks(Right);
	leftticks+=rightticks;
	TicksToHMS(leftticks,Left);
}

void addzero(char *str)
{
	if(str[1]==0)
	{
		str[1]=str[0];
		str[0]='0';
	}
}

char *HMSToStr(struct HMS *sourceHMS,char *str)
{
	char hour[4]={0,0,0,0},min[4]={0,0,0,0},sec[4]={0,0,0,0};
	sprintf(hour,"%d",sourceHMS->hours);
	sprintf(min,"%d",sourceHMS->minutes);
	sprintf(sec,"%d",sourceHMS->seconds);
	addzero(sec);
	if( sourceHMS->hours )
	{
		addzero(min);
		sprintf(str,"%s:%s:%s",hour,min,sec);
	}
	else sprintf(str,"%s:%s",min,sec);
	
	return(str);
}

void DsToHMS(struct DateStamp *BCD,struct HMS *destHMS)
{
	destHMS->minutes=BCD->ds_Minute%60;
	destHMS->hours=(BCD->ds_Minute-destHMS->minutes)/60;
	destHMS->seconds=BCD->ds_Tick/TICKS_PER_SECOND;
}

#endif // End of ifndef BozDate
