;APS00000000000000000000000000000000000000000000000000000000000000000000000000000000
;==============================================================
;==============================================================
;==============================================================
;==============================================================
;==============================================================
;
;
;
;
;              S A M P L E    P R O C E S S O R
;
;
;
;
;
;==============================================================
;==============================================================
;==============================================================
;==============================================================
;==============================================================


testout_enable = 0	; realtime debugging output




sample_processor
	move.l	MTSprocStruct+wd_Wnd(a5),d0
	bne	window_activation

;=== Fenster ffnen
	lea	MTSprocStruct(a5),a4
	bsr	init_sp_audio
	beq.s	.norm
	bsr.s	.Refresh
	beq.s	.norm
	bsr	OpenWD
	bne.s	.norm
;=== Left-Top/Right-Bottom der Bevelbox berechnen
	movem.l	MTsprocStruct+wd_LeftTop(a5),d0-d1
	lea	MTsprocBevels(pc),a0
	add.w	(a0)+,d0
	add.w	(a0)+,d1
	move.w	d0,d2
	move.w	d1,d3
	addq.w	#2,d0
	addq.w	#1,d1
	add.w	(a0)+,d2
	add.w	(a0)+,d3
	subq.w	#3,d2
	subq.w	#2,d3
	movem.w	d0-d3,sp_bevelcoords(a5)
	bsr	RefreshDisplay
	POSITIV
.norm	bsr	sprocwdclose
	NEGATIV



.Refresh

;=== Men Strukturen
	move.l	wd_NewMenu0(a4),a0

	move.b	sp_cuttobuf(a5),d0
	move.w	#MTsprocNMcuttobuf,d1
	jsr	PutCheckmarkJ(a5)

	move.b	sp_autozoom(a5),d0
	move.w	#MTsprocNMautozom,d1
	jsr	PutCheckmarkJ(a5)

	move.b	filtermode(a5),d0
	ext.w	d0
	move.b	.transtab(pc,d0.w),d0
	move.w	#MTsprocNMfignonoff,d1
	moveq	#2,d2
	jsr	MutualXcluderJ(a5)
	bra.s	.skiptt


		dc.b	1
.transtab	dc.b	0,2
		even
.skiptt

	move.l	wd_GTags(a4),a0
	move.l	sp_rate(a5),MTsprocGTrate(a0)




;=== Window Title initialisieren

	subq.w	#8,sp

	moveq	#loc_sproctitle,d0
	jsr	getcatstringJ(a5)
	move.l	a1,(sp)
	moveq	#sproctitle_len,d2

	moveq	#loc_sp_display,d0
	jsr	getcatstringJ(a5)
	move.l	a1,4(sp)
	move.l	a1,a0
	bsr	stringlength
	add.l	d0,d2
	move.w	d2,display_pos(a5)
	moveq	#display_titlelen+1,d0	; value plus a Nullbyte
	add.l	d2,d0

	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	move.l	d0,sproctitle(a5)
	beq.s	.nosproctitle
	move.l	MTsprocStruct+wd_WindowTags(a5),a0
	move.l	d0,MTsprocWT(a0)
	move.l	d0,a1

	move.l	(sp)+,a0		; copy windowtitle
	moveq	#sproctitle_len-1,d0
	bsr	copytitle

	move.l	(sp)+,a0		; "Display" kopieren
	COPYWITHOUTZERO
	clr.b	display_titlelen(a1)


;=== Defaultwert einsetzen

	moveq	#0,d0			; Display = 0
	moveq	#7,d1
	move.l	sproctitle(a5),a0
	adda.w	display_pos(a5),a0
	bsr	decout_nolead
	POSITIV

.nosproctitle
	addq.w	#8,sp
	NEGATIV





add_audio_signal
	tst.b	sp_playmode(a5)
	beq.s	.rts
	move.b	audiosignal(a5),d1
	bmi.s	.rts
	bset	d1,d0
.rts	rts

check_audio_signal
	tst.b	sp_playmode(a5)
	beq.s	.rts
	move.b	audiosignal(a5),d1
	bmi.s	.rts
	btst	d1,d0
	beq.s	.rts
	bclr	d1,d0
	move.l	d0,-(sp)
	bsr	cycle_ready
	move.l	(sp)+,d0
.rts	rts


SprocIDCMP
	dc.w	.count-1
	dc.l	$00000004
	dr.l	window_refresh
	dc.l	$00000008
	dr.l	Sprocmousebuttons
	dc.l	$00000010
	dr.l	Sprocmousemove
	dc.l	$00000040
	dr.l	Sprocgadgetup
	dc.l	$00000100
	dr.l	Sprocmenupick
	dc.l	$00000200
	dr.l	Sprocwdclosegad
	dc.l	$00000400
	dr.l	mainrawkey
	dc.l	$00400000
;	dr.l	sprocintuiticks
	dr.l	Generalintuiticks
	dc.l	$04000000
	dr.l	sprocgadgethelp
.count = (*-SprocIDCMP-2)/8


;==============================================================
;
;  Intuiticks
;
;==============================================================

sprocintuiticks

	IFNE	testout_enable
	bsr	testout
	ENDC


;	lea	AudioIOLeft(a5),a0
;	lea	AudioRead(pc),a1
;	moveq	#$44/4-1,d0
;.copy	move.l	(a0)+,(a1)+
;	dbf	d0,.copy

;	lea	AudioRead(pc),a1
;	move.w	#2,$1c(a1)
;	move.l	(a5),a6
;	jsr	SendIO(a6)
;	lea	AudioRead(pc),a1
;	addq.l	#1,adr1
;	tst.b	$1f(a1)
;	bne.s	.error

;	lea	AudioRead(pc),a1
;	jsr	WaitIO(a6)

;	addq.l	#1,adr1+4
;	move.l	AudioRead+$22(pc),d0
;	beq.s	.noread

;	addq.l	#1,adr1+8
;	move.l	adr,a0
;	move.l	d0,(a0)+
;	move.l	a0,adr


;.noread
;.error

	move.l	a4,a0
	jmp	all_purpose_intuiticksJ(a5)


;adr1	dc.l	0,0,0

;adr	dc.l	puf

;AudioRead
;	ds.b	$44




;==============================================================
;
;  GADGETHELP Event
;
;==============================================================

sprocgadgethelp
;	lea	.helpoffsets(pc),a0
	lea	.loc_helpoffsets(pc),a1
	lea	MTsprocStruct(a5),a2
	jmp	gadgethelpJ(a5)

	IFEQ	1

.helpoffsets
	dr.l	display_scrollerH
	dr.l	sample_to_editH
	dr.l	sproc_openH
	dr.l	sproc_zoominH
	dr.l	sproc_zoomoutH
	dr.l	sproc_cutH
	dr.l	sproc_copyH
	dr.l	sproc_pasteH
	dr.l	sproc_joinH
	dr.l	sproc_playallH
	dr.l	sproc_playrangeH
	dr.l	sproc_stopH
	dr.l	smp_looptypeH
	dr.l	range_allH
	dr.l	show_allH
	dr.l	sproc_playdisplayH
	dr.l	sproc_cutoutH
	dr.l	sproc_samplerateH

	ENDC

.loc_helpoffsets
	dc.w	l_display_scrollerH
	dc.w	l_sample_to_editH
	dc.w	l_sproc_openH
	dc.w	l_sproc_zoominH
	dc.w	l_sproc_zoomoutH
	dc.w	l_sproc_cutH
	dc.w	l_sproc_copyH
	dc.w	l_sproc_pasteH
	dc.w	l_sproc_joinH
	dc.w	l_sproc_playallH
	dc.w	l_sproc_playrangeH
	dc.w	l_sproc_stopH
	dc.w	l_smp_looptypeH
	dc.w	l_range_allH
	dc.w	l_show_allH
	dc.w	l_sproc_playdisplayH
	dc.w	l_sproc_cutoutH
	dc.w	l_sproc_samplerateH




;==============================================================
;
;  Close window
;
;==============================================================

Sprocwdclosegad
Sprocwdclose
	bsr	unload_routine
	bsr	sproc_stop_routine

	bsr	free_sp_audio
	lea	MTSprocStruct(a5),a4
	bsr	CloseWD

	lea	sproctitle(a5),a0
	jmp	MyFreeVectorJ(a5)


;==============================================================
;
;  MOUSEMOVE Event
;
;==============================================================

Sprocmousemove
	cmpa.l	a4,a3
	beq.s	.freespace

	lea	.mmovetab(pc),a0
	lea	MTsprocStruct(a5),a1
	jmp	mousemoverJ(a5)
.mmovetab
	dc.w	.mmovesize-1

	bra	display_scroller
	dc.w	GD_display

.mmovesize = (*-.mmovetab-2)/6


;=== Mouse ist auf keinem Gadget gedrckt, sondern irgendwo im Fenster

.freespace
	tst.b	sp_lmbpressed(a5)
	beq	.not_pressed

;=== d6 ist die Mouse-X-Position; wird auf die Bevelbox angepat

	cmp.w	sp_bevelcoords(a5),d6
	bmi.s	.l_out
	cmp.w	sp_bevelcoords+4(a5),d6
	ble.s	.in
;=== zu weit rechts
	move.w	sp_bevelcoords+4(a5),d6
	bra.s	.in
;=== zu weit links
.l_out	move.w	sp_bevelcoords(a5),d6
.in

	move.w	d6,d0
	bsr	get_realx_left
	move.w	sp_firstmousex(a5),d3
	cmp.w	d3,d0
	bpl.s	.right_hand


;=== Links vom Startpunkt

	move.w	sp_lastmousex(a5),d2
	move.w	d0,sp_lastmousex(a5)

	cmp.w	d3,d2
	bpl.s	.wasleftright

	cmp.w	d2,d0
	beq.s	.drawnothing
	bmi.s	.right

.skipr
;=== Maus wird nach rechts bewegt (linke Seite)
;=== Maus wird nach links bewegt (rechte Seite)

	moveq	#1,d2
	bra.s	.draw


;=== Maus war direkt vorher links/rechts, ist aber jetzt rechts/links
.wasleftright
;=== Links/Rechts vom Startwert schwarz (Range lschen)
	move.l	sp_rangestop(a5),d0
	move.l	d1,sp_rangestop(a5)
	move.l	sp_rangestart(a5),d1
	moveq	#1,d2
	bsr	draw_range

;=== Rechts/Links vom Startwert wei
	move.l	sp_rangestop(a5),d0
	move.l	sp_rangestart(a5),d1
	moveq	#2,d2
	bsr	draw_range
	bra.s	.ready



.right_hand
	beq.s	.startpoint

;=== Rechts vom Startpunkt

	move.w	d6,d0
	bsr	get_realx_right
	move.w	sp_lastmousex(a5),d2
	move.w	d0,sp_lastmousex(a5)
	cmp.w	d2,d0
	bmi.s	.skipr

	cmp.w	d3,d2
	bmi.s	.wasleftright

;=== Maus wird nach links bewegt (linke Seite)
;=== Maus wird nach rechts bewegt (rechte Seite)
.right	moveq	#2,d2
.draw	move.l	sp_rangestop(a5),d0
	move.l	d1,sp_rangestop(a5)
	bsr	draw_range
	bra.s	.ready

;=== Maus steht genau auf dem Anfangspunkt
.startpoint
	move.l	sp_rangestop(a5),d0
	move.l	d1,sp_rangestop(a5)
	moveq	#1,d2
	bsr	draw_range

	move.w	d6,d0
	bsr	get_realx_right
	move.w	d0,sp_lastmousex(a5)
	bra.s	.right


.ready

.drawnothing

.not_pressed
	rts




	IFNE	testout_enable

testout
	movem.l	d0-d1,-(sp)

	lea	textbuf(pc),a0
	move.l	sp_rangestart(a5),d0
	moveq	#7,d1
	bsr	decout_nolead
	lea	textbuf+8(pc),a0
	move.l	sp_rangestop(a5),d0
	moveq	#7,d1
	bsr	decout_nolead
	lea	textbuf+16(pc),a0
	move.l	sp_frames(a5),d0
	moveq	#7,d1
	bsr	decout_nolead
	lea	textbuf+24(pc),a0
	move.l	sp_graph+479*4,d0
	moveq	#7,d1
	bsr	decout_nolead

	move.l	MTsprocStruct+wd_Wnd(a5),a1
	move.l	$32(a1),a1
	movem.w	sp_bevelcoords(a5),d0-d1
	move.l	gfxbas(a5),a6
	jsr	Move(a6)
	lea	textbuf(pc),a0
	moveq	#24,d0
	jsr	Text(a6)

	movem.l	(sp)+,d0-d1
	rts

textbuf	dcb.b	48,0


	ENDC



;==============================================================
;
;  MOUSEBUTTONS Event
;
;==============================================================

Sprocmousebuttons
	tst.l	sp_sample(a5)
	beq	.rts
	cmp.b	#$e8,d5
	beq.s	.released
	cmp.b	#$68,d5
	bne	.rts

;=== LMB pressed

	cmp.w	sp_bevelcoords(a5),d6		; left
	bmi	.out
	cmp.w	sp_bevelcoords+2(a5),d7		; top
	bmi	.out
	cmp.w	sp_bevelcoords+4(a5),d6		; right
	bgt	.out
	cmp.w	sp_bevelcoords+6(a5),d7		; bottom
	bgt	.out

	move.w	d6,-(sp)
	st	sp_lmbpressed(a5)

;=== zuerst die alte Range lschen
	bsr	clear_range

;=== jetzt den Startpunkt zeichnen
	move.w	(sp),d0
	bsr.s	get_realx_left

	move.w	d0,sp_firstmousex(a5)	; merken fr MOUSEMOVE
	move.w	d0,sp_lastmousex(a5)
	move.l	d1,sp_rangestart(a5)

	move.w	(sp)+,d0
	bsr.s	get_realx_right
	move.l	d1,sp_rangestop(a5)

	bsr	do_range
	bra.s	.out


;=== LMB released

.released
	sf	sp_lmbpressed(a5)


	move.l	sp_rangestart(a5),d0
	move.l	sp_rangestop(a5),d1

	cmp.l	d0,d1
	bpl.s	.ok
	move.l	d1,sp_rangestart(a5)	; vertauschen, so da links =
	move.l	d0,sp_rangestop(a5)	; RangeStart, rechts = RangeStop

	move.w	sp_firstmousex(a5),d0	; Wenn der rechte Rand
	bsr	get_realx_right		; Rangestop ist, mu zur Range
	move.l	d1,sp_rangestop(a5)	; ein Pixel breit addiert werden

.ok

;	bsr	testout

	tst.b	sp_autozoom(a5)
	beq.s	.out
	bsr	sproc_zoomin
.out

.rts	rts





;==============================================================
;
;  APen setzen frs Sample-Processor-Window
;
;==============================================================

SetSprocAPen	; d0=APen
	move.l	MTsprocStruct+wd_Wnd(a5),a1
	move.l	$32(a1),a1
	move.l	gfxbas(a5),a6
	jmp	SetAPen(a6)




;==============================================================
;
;  Sample-Offset zur Mouse-x-Position holen (nach links hin)
;
;==============================================================

get_realx_left	; d0.w=mouse-x
		; zurck: d0.w=real-mouse-x, d1.l=Entry aus sp_graph
	move.l	sp_graphD(a5),a1
	move.l	a1,a0
	move.w	d0,d1
	sub.w	sp_bevelcoords(a5),d1
	lsl.w	#2,d1
	adda.w	d1,a0
	move.l	(a0),d1

.left	cmpa.l	a1,a0
	bls.s	.out
	cmp.l	-(a0),d1
	bne.s	.out
	subq.w	#1,d0
	bra.s	.left
.out	rts




;==============================================================
;
;  Sample-Offset zur Mouse-x-Position holen (nach rechts hin)
;
;==============================================================

get_realx_right	; d0.w=mouse-x
		; zurck: d0.w=real-mouse-x, d1.l=Entry aus sp_graph

	move.l	sp_graphD(a5),a0
	lea	481*4(a0),a1
	move.w	d0,d1
	sub.w	sp_bevelcoords(a5),d1
	lsl.w	#2,d1
	adda.w	d1,a0
	move.l	(a0)+,d1

.right	cmpa.l	a1,a0
	bcc.s	.out2
	cmp.l	(a0)+,d1
	bne.s	.out
	addq.w	#1,d0
	bra.s	.right
.out2	subq.w	#1,d0
.out	move.l	-(a0),d1
	rts




;==============================================================
;
;  Zu einem Sample-Offset die Mouse-X-Position holen
;
;==============================================================

get_mouse_x	; d0.l=Sample-Offset
		; zurck: d0.w=mouse-x, a0=^Graph mit Offset

	move.w	d2,-(sp)
	move.l	sp_graphD(a5),a0
	move.w	sp_bevelcoords(a5),d1
	move.w	#480-1,d2
.loop	cmp.l	(a0)+,d0
	bls.s	.itis
	addq.w	#1,d1
	dbf	d2,.loop
	subq.w	#1,d1
.itis	move.w	d1,d0
	subq.w	#4,a0
	move.w	(sp)+,d2
	rts




;==============================================================
;
;  Range lschen
;
;==============================================================

clear_range
	move.l	sp_rangestart(a5),d0
	bmi.s	.norange
	move.l	sp_rangestop(a5),d1
	moveq	#1,d2
	bsr	draw_range

.norange
	rts




;==============================================================
;
;  GADGET_UP Event
;
;==============================================================

Sprocgadgetup
	lea	.SprocGadgetTab(pc),a0
	jmp	gadgetjsrJ(a5)
.SprocGadgetTab
	dr.w	.nop_gadget	; display_scroller
	dr.w	.nop_gadget	; sample_to_edit
	dr.w	sproc_open
	dr.w	sproc_zoomin
	dr.w	sproc_zoomout
	dr.w	sproc_cut
	dr.w	sproc_copy
	dr.w	sproc_paste
	dr.w	sproc_join
	dr.w	sproc_playall
	dr.w	sproc_playrange
	dr.w	sproc_stop
	dr.w	smp_looptype
	dr.w	range_all
	dr.w	show_all
	dr.w	sproc_playdisplay
	dr.w	sproc_cutout
	dr.w	sproc_samplerate

.nop_gadget
	rts




;==============================================================
;
;  MENUPICK Event
;
;==============================================================

Sprocmenupick
	lea	.Sprocmenutab(pc),a0
	jmp	menuhandlerJ(a5)
.Sprocmenutab
	dr.w	menu_sample
	dr.w	menu_flags
	dr.w	menu_sprocedit


menu_sample
	lea	.sampletab(pc),a0
	jmp	item_activatorJ(a5)
.sampletab
	dr.w	sproc_open
	dr.w	sproc_unload
	dr.w	*
	dr.w	sproc_s_raw
	dr.w	sproc_s_aiff
	dr.w	sproc_s_maud
	dr.w	*
	dr.w	sprocwdclose


menu_flags
	lea	.flagstab(pc),a0
	jmp	item_activatorJ(a5)
.flagstab
	dr.w	cuttobuffer
	dr.w	autozoom
	dr.w	sp_endian
	dr.w	sp_filter
	dr.w	*
	dr.w	sproc_rate


menu_sprocedit
	lea	.sprocedittab(pc),a0
	jmp	item_activatorJ(a5)
.sprocedittab
	dr.w	octave_up
	dr.w	octave_down
	dr.w	*
	dr.w	volume_200
	dr.w	volume_50
	dr.w	volume_any
	dr.w	*
	dr.w	sampleboost
	dr.w	samplefilter
	dr.w	sampleflip




;==============================================================
;
;  Sample Rate Presets
;
;==============================================================

sproc_rate
	lea	.sprocratetab(pc),a0
	jmp	subitem_activatorJ(a5)
.sprocratetab
	dr.w	sproc_r11025
	dr.w	sproc_r22050
	dr.w	sproc_r44100


;==============================================================
;
;  Scrollbar
;
;==============================================================

display_scroller
	tst.l	sp_sample(a5)
	beq.s	.empty

	bsr	GetScrollerSproc
	move.b	scrollershift(a5),d4
	lsl.l	d4,d0


	add.l	d0,d0
	move.l	rightmargin(a5),d1
	sub.l	leftmargin(a5),d1
	move.l	d0,leftmargin(a5)
	add.l	d1,d0
	move.l	d0,rightmargin(a5)
	bsr	RefreshDisplay

;=== Range nachzeichnen
	bra	do_range

.empty	rts


;==============================================================
;
;  Sample String Gadget
;
;==============================================================

;sample_to_edit
;	bsr	sproc_stop_routine
;	bsr	unload_safereq
;	bne.s	load_new_sample

;=== cancel
;	bra	sproc_alright



;==============================================================
;
;  Sample GetFile Gadget
;
;==============================================================

sproc_open
	bsr	sproc_stop_routine
	bsr	unload_safereq
	beq.s	.cancel

	lea	rt_spload_struct(pc),a4
	bsr	FileRequester
	beq.s	.cancel

	lea	rt_spload_name(a5),a0
	moveq	#1,d0
	moveq	#GD_editsmp,d1
	bsr	SetTextSproc
	bra.s	.load_new_sample

.cancel	bra	sproc_load_cancelled




.load_new_sample
	move.w	#loc_loadingsmp,d0
	jsr	sproc_statusJ(a5)

	jsr	SprocBusyPointerJ(a5)

	lea	rt_spload_name(a5),a1
	lea	rt_sp_path(a5),a0
	jsr	CompleteFilenameJ(a5)
	move.l	d1,a2
	lea	sp_loadsample(a5),a3
	bsr	loadfile_public
	beq	.load_error

	move.l	(a3),a2
	cmp.l	#'FORM',(a2)
	bne	raw_file

;=== AIFF Sample
	cmp.l	#'AIFF',8(a2)
	bne	.maud

	move.l	#'COMM',d0
	bsr	GetMemIffChunk
	beq	.aifmiss0
	move.l	2(a0),-(sp)		; Frames
	lea	8(a0),a0
	bsr	get_extended
	move.l	d0,-(sp)		; Sampling Rate

;=== Instrument Chunk
	move.l	#'INST',d0
	bsr	GetMemIffChunk
	subq.w	#8,sp			; fr loopstart, loopend
	bne.s	.inst
	clr.w	-(sp)			; no looping
	bra.s	.noloop
.inst	move.w	8(a0),-(sp)		; playMode (Looptype)
	beq.s	.noloop
	movem.w	10(a0),d3-d4		; beginLoop, endLoop

;=== Marker Chunk
	move.l	#'MARK',d0
	bsr	GetMemIffChunk
	beq.s	.nomarkchunk

	move.w	(a0)+,d2		; numMarkers
	beq.s	.nomarkchunk
.markerloop
	move.w	(a0)+,d1		; MarkerId
	move.l	(a0)+,d0
	cmp.w	d3,d1
	bne.s	.next1
	move.l	d0,2(sp)		; beginloop
	bra.s	.next2
.next1	cmp.w	d4,d1
	bne.s	.next2
	move.l	d0,6(sp)		; endloop
.next2	moveq	#0,d0
	move.b	(a0),d0
	lea	2(a0,d0.w),a0
	subq.w	#1,d2
	bne.s	.markerloop

.goon	move.l	#'SSND',d0
	bsr	GetMemIffChunk
	beq.s	.aifmiss2
	addq.w	#8,a0
	move.l	a0,sp_sampledata(a5)

	move.w	(sp)+,d0
	move.b	d0,sp_looptype(a5)
	move.l	(sp)+,sp_loopstart(a5)
	move.l	(sp)+,sp_loopend(a5)
	move.l	(sp)+,sp_rate(a5)
	move.l	(sp)+,sp_frames(a5)
	bra	.noendian

.noloop
.nomarkchunk
	move.l	$e(sp),d0		; Frames
	move.l	d0,2(sp)		; beginloop und
	move.l	d0,6(sp)		; endloop
	bra.s	.goon

.aifmiss2
	lea	$a+8(sp),sp
	move.w	#loc_missingSSND,d0
	bra	.missingchunk
;.aifmiss1
;	addq.w	#8,sp
;	move.w	#loc_missingINST,d0
;	bra	.missingchunk
.aifmiss0
	move.w	#loc_missingCOMM,d0
	bra	.missingchunk



;=== MAUD 16bit Sample
.maud	cmp.l	#'MAUD',8(a2)
	bne	raw_file

	move.l	#'MHDR',d0
	bsr	GetMemIffChunk
	beq.s	.maudmiss0

	cmp.w	#1,16(a0)		; number of tracks
	bne	.load_error2
	cmp.w	#16,4(a0)		; 16 bit ?
	bne	.only16bit
	move.l	(a0),-(sp)		; # Frames
	move.l	8(a0),-(sp)		; sampling rate

	move.l	#'MDAT',d0
	bsr	GetMemIffChunk
	beq.s	.maudmiss1
	move.l	a0,sp_sampledata(a5)

	move.l	(sp)+,sp_rate(a5)
	clr.l	sp_loopstart(a5)
	move.l	(sp),sp_loopend(a5)
	move.l	(sp)+,sp_frames(a5)
	clr.b	sp_looptype(a5)		; no loop


;=== Endian-Men disablen
.noendian
	move.l	MTsprocStruct+wd_Wnd(a5),a0
	move.w	#endian_menu,d0
	move.l	intbas(a5),a6
	jsr	OffMenu(a6)
	sf	sproc_endian(a5)	; MAUD und AIFF haben immer
	bra	header_ready		; hi-endian (motorola)

.maudmiss1
	addq.w	#8,sp
	move.w	#loc_missingMDAT,d0
	bra.s	.missingchunk
.maudmiss0
	move.w	#loc_missingMHDR,d0
;	bra.s	.missingchunk





;=== Fehlermeldungen

.missingchunk	; d0=locale-Stringnumber of missing-string
	move.w	#loc_ohno,d1
	jsr	EZrequestJ(a5)
	bra.s	.load_error2

.only16bit
	move.w	#loc_only16bit,d0
	move.w	#loc_iforgot,d1
	jsr	EZrequestJ(a5)

.load_error2
	lea	sp_loadsample(a5),a3
	bsr	unloadfile

.load_error
	lea	loaderror_txt(pc),a1
	move.w	#loc_loaderror,d0
	jsr	sproc_statusJ(a5)

	jmp	SprocActivePointerJ(a5)




.missCOMM_body	dc.b	'COMM Chunk not found.',0
.missSSND_body	dc.b	'SSND Chunk not found.',0
.missMHDR_body	dc.b	'MHDR Chunk not found.',0
.missMDAT_body	dc.b	'MDAT Chunk not found.',0

.only16_body	dc.b	'Currently only 16bit Samples allowed.',0
rt_spload_title dc.b	'Load 16-bit Sample',0
rt_sproc_pat	dc.b	'#?.(dump|aif|maud)',0
		even






;=== DUMP File (ist keins von den anderen)
raw_file
	move.l	#44100,sp_rate(a5)
	move.l	(a3),sp_sampledata(a5)
	move.l	4(a3),d0
	lsr.l	#1,d0
	move.l	d0,sp_frames(a5)
	move.l	d0,sp_loopend(a5)
	clr.l	sp_loopstart(a5)
	clr.b	sp_looptype(a5)

	move.l	MTsprocStruct+wd_Wnd(a5),a0
	move.w	#endian_menu,d0
	move.l	intbas(a5),a6
	jsr	OnMenu(a6)



;=== Hier wird hingesprungen, wenn der Header berarbeitet ist

header_ready
	clr.l	leftmargin(a5)
	move.l	sp_frames(a5),d0
	add.l	d0,d0
	move.l	d0,rightmargin(a5)
	moveq	#-1,d0
	move.l	d0,sp_rangestart(a5)

	moveq	#0,d0
	move.b	sp_looptype(a5),d0
	moveq	#GD_smploop,d1
	bsr	SetCycleSproc

	move.l	sp_rate(a5),d0
	bsr	sproc_ratejump

	st	realloc_flag(a5)
	sf	sample_changed(a5)

	tst.l	MTsdsStruct+wd_Wnd(a5)	; SampleDump Gadget ggf. enablen
	beq.s	.notopen
	moveq	#GD_smpbuffer,d1
	bsr	EnableGadSds
.notopen

	lea	rt_spload_name(a5),a0	; Samplename zum Save-Buffer
	lea	rt_spsave_name(a5),a1	; kopieren
	COPYTILLZERO

	lea	sp_sample(a5),a3
	bsr	unload_kern		; altes Sample unloaden
	move.l	sp_loadsample(a5),sp_sample(a5)		; Sample
	move.l	sp_loadsample+4(a5),sp_sample+4(a5)	; bernehmen
	clr.l	sp_loadsample(a5)

	bsr	RefreshDisplay
	bsr	UpdateSprocScroller
	jsr	SprocActivePointerJ(a5)
	jmp	sproc_alrightJ(a5)






GetMemIffChunk	; d0=ChunkID, a3=^File
		; zurck: a0=^Chunk (hinter ID+size)

	move.l	(a3),a0
	move.l	a0,a1
	adda.l	4(a3),a1
	lea	$c(a0),a0
.next	cmp.l	(a0)+,d0
	beq.s	.found
	adda.l	(a0)+,a0
	cmpa.l	a1,a0
	bcs.s	.next
	move.l	d0,d1		; Chunk in d1 fr Fehlermeldung
	NEGATIV
.found	addq.w	#4,a0
	POSITIV





rt_spload_struct
	dc.w	rt_spload_fr
	dc.w	MTsprocStruct
	dr.w	rt_sproc_pat
;	dr.w	rt_spload_title
	dc.w	loc_sploadtitle
	dc.w	rt_spload_name
	dc.w	rt_sp_path
	dc.l	rt_load_flags



sproc_load_cancelled
	move.l	loadcancel_txtD(a5),a1
	move.w	#loc_loadcancel,d0
	jmp	sproc_statusJ(a5)






;==============================================================
;
;  Bevelbox-Inhalt neu zeichnen
;
;==============================================================

RefreshDisplay

;=== zuerst den Ausschnitt lschen
	movem.w	sp_bevelcoords(a5),d0-d3
	move.l	MTsprocStruct+wd_Wnd(a5),a1
	move.l	$32(a1),a1
	move.l	a1,-(sp)
	move.l	gfxbas(a5),a6
	jsr	EraseRect(a6)

;=== Mittellinie in Blau
	moveq	#3,d0
	bsr	SetSprocAPen
;=== Mittellinie zeichnen
	movem.w	sp_bevelcoords(a5),d0-d2
	add.w	#64,d1
	move.w	d1,d3
	move.l	(sp),a1
	jsr	Move(a6)
	move.w	d2,d0
	move.w	d3,d1
	move.l	(sp),a1
	jsr	Draw(a6)

;=== Graphen berechnen
	tst.l	sp_sample(a5)
	beq	.nosample

	move.l	rightmargin(a5),d0
	sub.l	leftmargin(a5),d0
	lsr.l	#1,d0		; auf Frames runterrechnen
	move.l	d0,d3
	move.l	#480,d1
	move.l	utilbas(a5),a6
	jsr	UDivMod32(a6)
	move.l	d0,d5		; d5=(right-left)/480
	add.l	d5,d5		; wegen 16bit
	move.w	d1,d4		; Rest in d4
	add.w	d4,d4

	move.l	sp_graphD(a5),a0
	move.l	a0,a2
	move.l	leftmargin(a5),d3
	moveq	#0,d2
	move.w	#479,d1		; Schleifenzhler
	move.w	#480*2,d6	; Konstante
.calcloop
	move.l	d3,(a0)+
	add.l	d5,d3
	add.w	d4,d2
	cmp.w	d6,d2
	bcs.s	.noadd
	sub.w	d6,d2
	addq.l	#2,d3
.noadd	dbf	d1,.calcloop

	move.l	d3,(a0)+	; einen dahinter (d3 ist Offset direkt
				; hinter dem Sample)

;=== Graph in Schwarz

	move.l	leftmargin(a5),d0
	move.l	rightmargin(a5),d1
	moveq	#1,d2
	bsr.s	draw_range

;=== "Display" im Windowtitle refreshen

	move.l	rightmargin(a5),d0
	sub.l	leftmargin(a5),d0
	moveq	#display_titlelen-1,d1
	move.l	sproctitle(a5),a0
	adda.w	display_pos(a5),a0
	bsr	decout_nolead
	bsr	set_wdtitle_sproc


;=== Loop-points zeichnen









.nosample
	addq.w	#4,sp
	rts



;==============================================================
;
;  Graph-Bereich zeichnen
;
;==============================================================

draw_range	; d0.l=range-start, d1.l=range-stop (dahinter)
		; d2.l=APen

	cmp.l	leftmargin(a5),d1
	bmi	.noneed
	cmp.l	rightmargin(a5),d0
	bpl	.noneed

	cmp.l	d0,d1
	bcc.s	.ok
	exg	d0,d1
.ok

	movem.l	d0-d7/a2-a3,-(sp)


	move.l	d2,d0
	bsr	SetSprocAPen


	move.l	(sp),d0
	bsr	get_mouse_x
	move.w	d0,d4			; d4 = Start-x-wert
	move.l	a0,a2			; a2 = ^Graph mit Offset

	move.l	4(sp),d0
	bsr	get_mouse_x
	move.w	d0,d7			; d7 = End-x-wert


	move.l	MTsprocStruct+wd_Wnd(a5),a1
	move.l	$32(a1),-(sp)
	move.l	gfxbas(a5),a6

;=== jetzt den Graphen zeichnen
	moveq	#64,d5		; fester y-Offset
	moveq	#9,d6		; feste Shift-zahl zum Runterrechnen
	move.l	sp_sampledata(a5),a3
	move.l	(a2)+,d2
	move.w	(a3,d2.l),d1
	neg.w	d1
	asr.w	d6,d1
	add.w	d5,d1
	add.w	sp_bevelcoords+2(a5),d1
	move.w	d4,d0
	move.l	(sp),a1
	jsr	Move(a6)

.drawloop
	move.w	(a3,d2.l),d1		; Sample-Wert in d1
	neg.w	d1			; KoKreuz verkehrt
	asr.w	d6,d1			; heruntershiften
	add.w	d5,d1			; Nullniveau addieren
	add.w	sp_bevelcoords+2(a5),d1	; Window-Y-Offset dazu
	move.w	d4,d0			; x-Koordinate
	move.l	(sp),a1
	jsr	Draw(a6)
	cmp.w	d7,d4
	bcc.s	.out

.next	addq.w	#1,d4
	move.l	(a2)+,d3
	cmp.l	d2,d3			; gerade Linie ?
	bne.s	.goon
	cmp.w	d7,d4
	bcs.s	.next

.goon	move.l	d3,d2
	bra.s	.drawloop

.out	addq.w	#4,sp


	movem.l	(sp)+,d0-d7/a2-a3
.noneed
	rts




;==============================================================
;
;  Unload
;
;==============================================================

sproc_unload
	bsr.s	unload_safereq
	beq.s	.rts
	bsr.s	unload_routine

	move.l	MTsprocStruct+wd_Wnd(a5),a0
	move.w	#endian_menu,d0
	move.l	intbas(a5),a6
	jsr	OffMenu(a6)

	lea	unloaded_txt(pc),a1
	move.w	#loc_smpunloaded,d0
	jmp	sproc_statusJ(a5)

.rts	rts


unload_safereq
	tst.b	sample_changed(a5)
	beq.s	.direct
	move.w	#loc_smpchanged,d0
	move.w	#loc_yesnooo,d1
	jsr	EZrequestJ(a5)
	beq.s	.cancel
	sf	sample_changed(a5)
.direct	POSITIV
.cancel	NEGATIV


unload_routine	; zurck: d0=pos/neg (Requester OK/CANCEL)

	tst.l	MTsprocStruct+wd_Wnd(a5)
	beq.s	.notopen

	sf	sample_changed(a5)

	moveq	#0,d0
	bsr	sproc_ratejump

	moveq	#-1,d0
	move.l	d0,sp_rangestart(a5)
	clr.l	sp_frames(a5)

	lea	sp_sample(a5),a3
	bsr.s	unload_kern
	bsr	RefreshDisplay
	bsr	UpdateSprocScroller

	tst.l	MTsdsStruct+wd_Wnd(a5)
	beq.s	.notopen
	tst.b	smpbuffer(a5)
	beq.s	.okay
	bsr	smp_buffer	; auf "dump from file" stellen
	moveq	#0,d0
	moveq	#GD_smpbuffer,d1
	bsr	SetCheckboxSds
.okay	moveq	#GD_smpbuffer,d1
	jsr	DisableGadSdsJ(a5)
.notopen
	rts


unload_kern	; a3=^Sampleaddresse und Lnge
	bsr	unloadfile
	bsr	free_chipsample
	bra	FreeZoomHist


safe_body	dc.b	'Sample has been changed.',10
		dc.b	'May we erase it anyway ?',0


unloaded_txt	dc.b	'Sample unloaded.',0
playall_txt	dc.b	'Playing Sound...',0
playrange_txt	dc.b	'Playing Range...',0
playdis_txt	dc.b	'Playing Display...',0
replayerror_txt	dc.b	'Replay error.',0
stopsample_txt	dc.b	'Sample stopped.',0
rangecut_txt	dc.b	'Range cut.',0
copied_txt	dc.b	'Range copied.',0
save_aiff_txt	dc.b	'Saving AIFF',0
save_maud_txt	dc.b	'Saving MAUD',0
save_dump_txt	dc.b	'Saving Dump',0
saveerror_txt	dc.b	'Save error!',0
loaderror_txt	dc.b	'Load error!',0
loading_txt	dc.b	'Loading...',0

rt_spsaiff_tit	dc.b	'Save 16-bit AIFF',0
rt_spsmaud_tit	dc.b	'Save 16-bit MAUD',0
rt_spsraw_tit	dc.b	'Save 16-bit DUMP',0

		even


;==============================================================
;
;  Save AIFF
;
;==============================================================

sproc_s_aiff
	lea	save_aiff_txt(pc),a1
	move.w	#loc_savingaiff,d0
	lea	.rt_spsaiff_struct(pc),a4
	moveq	#5,d1
	bra	sp_saver
.rt_spsaiff_struct
	dc.w	rt_spsave_fr
	dc.w	MTsprocStruct
	dr.w	.rt_spsaiff_pat
;	dr.w	.rt_spsaiff_tit
	dc.w	loc_spsaveaiff
	dc.w	rt_spsave_name
	dc.w	rt_sp_path
	dc.l	rt_save_flags

.rt_spsaiff_pat	dc.b	'#?.(aif|aiff)',0
		even



;==============================================================
;
;  Save MAUD
;
;==============================================================

sproc_s_maud
	lea	save_maud_txt(pc),a1
	move.w	#loc_savingmaud,d0
	lea	.rt_spsmaud_struct(pc),a4
	moveq	#6,d1
	bra.s	sp_saver
.rt_spsmaud_struct
	dc.w	rt_spsave_fr
	dc.w	MTsprocStruct
	dr.w	.rt_spsmaud_pat
;	dr.w	.rt_spsmaud_tit
	dc.w	loc_spsavemaud
	dc.w	rt_spsave_name
	dc.w	rt_sp_path
	dc.l	rt_save_flags

.rt_spsmaud_pat	dc.b	'#?.maud',0
		even


;==============================================================
;
;  Save DUMP
;
;==============================================================

sproc_s_raw
	lea	save_dump_txt(pc),a1
	move.w	#loc_savingdump,d0
	lea	.rt_spsraw_struct(pc),a4
	moveq	#2,d1
	bra.s	sp_saver
.rt_spsraw_struct
	dc.w	rt_spsave_fr
	dc.w	MTsprocStruct
	dr.w	.rt_spsraw_pat
;	dr.w	.rt_spsraw_tit
	dc.w	loc_spsavedump
	dc.w	rt_spsave_name
	dc.w	rt_sp_path
	dc.l	rt_save_flags

.rt_spsraw_pat	dc.b	'#?.dump',0
		even

sp_saver	; d1=type: 2=DUMP, 5=AIFF, 6=MAUD
		; d0=locale-number der statusmsg
		; a1=^StatusMsg, a4=^rt_struct

	move.l	d1,-(sp)

	tst.l	sp_sample(a5)
	beq	.nosample

	jsr	sproc_statusJ(a5) ; d0 und a1 = statusmsg und locale-number

	bsr	FileRequester
	beq	.cancel

;	moveq	#0,d1
;	move.w	fr_name(a4),d1
;	add.l	a5,d1
	move.l	a4,a0
	move.l	#1006,d2
	jsr	OpenFileFromFRJ(a5)
;	move.l	dosbas(a5),a6
;	jsr	Open(a6)
	move.l	d0,d1
	beq	.openerror
	move.l	d1,-(sp)

	jsr	SprocBusyPointerJ(a5)

	lea	savertab(pc),a0
	move.l	4(sp),d0
	add.w	d0,d0
	adda.w	d0,a0
	adda.w	(a0),a0

	move.l	sp_frames(a5),d0
	move.l	sp_rate(a5),d1
	move.l	sp_loopstart(a5),d2
	move.l	sp_loopend(a5),d3
	move.b	sp_looptype(a5),d4
	moveq	#16,d5
	lea	rt_spsave_name(a5),a1

	jsr	(a0)
;zurck: d0=Length, a0=^Address
	move.l	dosbas(a5),a6
	move.l	d0,d3
	beq.s	.noheader
	move.l	a0,d2
	move.l	(sp),d1
	jsr	Write(a6)
.noheader

	move.l	(sp),d1
	move.l	sp_sampledata(a5),d2
	move.l	sp_frames(a5),d3
	add.l	d3,d3
	jsr	Write(a6)

	move.l	(sp)+,d1
	jsr	Close(a6)
	sf	sample_changed(a5)
	jsr	SprocActivePointerJ(a5)

.cancel
	jsr	sproc_alrightJ(a5)
	bra.s	.out

.openerror
	lea	saveerror_txt(pc),a1
	move.w	#loc_saveerror,d0
	jsr	sproc_statusJ(a5)
	bra.s	.out

.nosample
	bsr	nosample

.out	addq.w	#4,sp
	rts

.headersavertab
	dr.w	.saver_dump
	dr.w	.saver_aiff
	dr.w	.saver_maud

.saver_dump
	moveq	#0,d0
	rts

.saver_maud
	lea	saver_maud(pc),a0
	bra.s	.jump_in

.saver_aiff
	; d0.l=synthe_length
	; d1.l=synthe_rate
	; d2.l=synthe_lstart
	; d3.l=synthe_lend
	; d4.b=looptype
	; d5.b=saverbits
	; a1=^Filename

	lea	saver_aiff(pc),a0
.jump_in	;a0=^routine
	move.l	sp_frames(a5),d0
	move.l	sp_rate(a5),d1
	move.l	sp_loopstart(a5),d2
	move.l	sp_loopend(a5),d3
	move.b	sp_looptype(a5),d4
	moveq	#16,d5
	lea	rt_spsave_name(a5),a1
	jmp	(a0)


;==============================================================
;
;  Hineinzoomen
;
;==============================================================

sproc_zoomin
	tst.l	sp_sample(a5)
	beq	nosample
	move.l	sp_rangestart(a5),d0
	bmi	norange_error
	move.l	sp_rangestop(a5),d1
	cmp.l	d0,d1
	beq.s	larger_range

	moveq	#zh_sizeof,d0
	moveq	#1,d1
	move.l	(a5),a6
	jsr	AllocMem(a6)
	tst.l	d0
	beq.s	.nomem
	move.l	d0,a2

	lea	zoomhist_root(a5),a0
.stackloop
	move.l	(a0),d0
	beq.s	.found
	move.l	d0,a0
	bra.s	.stackloop
.found	move.l	a2,(a0)
	clr.l	(a2)+
	move.l	leftmargin(a5),(a2)+
	move.l	rightmargin(a5),(a2)+

	move.l	sp_rangestart(a5),leftmargin(a5)
	move.l	sp_rangestop(a5),rightmargin(a5)
	moveq	#-1,d0
	move.l	d0,sp_rangestart(a5)
	bsr	RefreshDisplay
	bra	UpdateSprocScroller

.nomem
	bra	nomemory

larger_range
	move.w	#loc_larger,d0
	move.w	#loc_saywhat,d1
	jmp	EZrequestJ(a5)


large_body	dc.b	'Please mark a larger range',0
		even




;==============================================================
;
;  Herauszoomen
;
;==============================================================

sproc_zoomout
	tst.l	sp_sample(a5)
	beq	nosample

	lea	zoomhist_root(a5),a0
	move.l	(a0),d0
	beq	.noprev

.stackloop
	move.l	(a0),a1
	move.l	(a1),d0
	beq.s	.found
	move.l	a1,a0
	bra.s	.stackloop
.found	move.l	zh_left(a1),leftmargin(a5)
	move.l	zh_right(a1),rightmargin(a5)
	clr.l	(a0)

	moveq	#zh_sizeof,d0
	move.l	(a5),a6
	jsr	FreeMem(a6)

	move.l	sp_frames(a5),d0
	add.l	d0,d0
	cmp.l	leftmargin(a5),d0
	bls.s	.again
	cmp.l	rightmargin(a5),d0
	bcc.s	.okay

.again
	move.l	rightmargin(a5),d1
	sub.l	leftmargin(a5),d1
	move.l	d0,rightmargin(a5)
	sub.l	d1,d0
	bcs.s	.toobig
	move.l	d0,leftmargin(a5)
	bra.s	.okay

.toobig
	lea	zoomhist_root(a5),a0
	move.l	(a0),d1
	bne.s	.stackloop
	clr.l	leftmargin(a5)
	move.l	sp_frames(a5),d0
	add.l	d0,d0
	move.l	d0,rightmargin(a5)

.okay
	bsr	RefreshDisplay
	bsr.s	UpdateSprocScroller
	bsr	do_range


.out	rts

.noprev
	move.w	#loc_maxdisplay,d0
	move.w	#loc_roger,d1
	jmp	EZrequestJ(a5)

noprev_body	dc.b	'We are at maximum display.',0
noprev_gadfmt	dc.b	'_Roger and Over',0
		even


;==============================================================
;
;  Scroller updaten
;
;==============================================================

UpdateSprocScroller
	tst.l	sp_sample(a5)
	beq.s	.empty

	move.l	sp_frames(a5),d2	; d2=Total
	move.l	rightmargin(a5),d3
	lsr.l	#1,d3
	move.l	leftmargin(a5),d0
	lsr.l	#1,d0			; d0=Top
	sub.l	d0,d3			; d3=Visible

	moveq	#0,d4
.shiftloop
	cmp.l	#$8000,d2		; Scrollgadget vertrgt nur
	bcs.s	.okay			; signed-16bit Werte
	lsr.l	#1,d2
	addq.b	#1,d4
	bra.s	.shiftloop
.okay	move.b	d4,scrollershift(a5)
	lsr.l	d4,d0
	lsr.l	d4,d3

;	move.l	d2,d1
;	lsl.l	d4,d1
;	cmp.l	sp_frames(a5),d1
;	beq.s	.do
;	addq.l	#1,d2	;fr den Sample-Rest, der bersteht

.do	move.l	MTsprocStruct+wd_GTags(a5),a0
	move.l	d0,MTsprocGTtop(a0)
	move.l	d2,MTsprocGTtotal(a0)
	move.l	d3,MTsprocGTvisible(a0)
	moveq	#GD_display,d1
	jmp	SetScrollerSprocJ(a5)

.empty	moveq	#0,d0
	moveq	#2,d2
	moveq	#2,d3
	bra.s	.do


;==============================================================
;
;  Zoom History freigeben
;
;==============================================================

FreeZoomHist	;wird auch von FreeSomething aufgerufen
	move.l	(a5),a6
	lea	zoomhist_root(a5),a2
	move.l	(a2),d0
	beq.s	.nofree
	clr.l	(a2)
.loop	move.l	d0,a2
	move.l	(a2),-(sp)
	move.l	a2,a1
	moveq	#zh_sizeof,d0
	jsr	FreeMem(a6)
	move.l	(sp)+,d0
	bne.s	.loop
.nofree	rts




;==============================================================
;
;  CUT Range
;
;==============================================================

sproc_cut
	tst.l	sp_rangestart(a5)
	bmi	norange_error

	jsr	SprocBusyPointerJ(a5)
	bsr	sproc_stop_routine
	tst.b	sp_cuttobuf(a5)
	beq.s	.nocopy
	bsr	sp_copy
.nocopy
	move.l	sp_rangestart(a5),d0
	move.l	sp_rangestop(a5),d1
	sub.l	d0,d1
	move.l	sp_frames(a5),d0
	add.l	d0,d0
	sub.l	d1,d0
	move.l	d0,-(sp)
	moveq	#1,d1
	move.l	(a5),a6
	jsr	AllocMem(a6)
	tst.l	d0
	beq	.nomem
	move.l	d0,-(sp)
	move.l	d0,a2

;=== Sampledata links von der Range kopieren
	move.l	sp_rangestart(a5),d0
	beq.s	.skip1
	move.l	sp_sampledata(a5),a0
	move.l	a2,a1
	adda.l	d0,a2
	jsr	CopyMem(a6)
.skip1

;=== Sampledata rechts von der Range kopieren
	move.l	sp_rangestop(a5),d1
	move.l	sp_sampledata(a5),a0
	adda.l	d1,a0
	move.l	sp_frames(a5),d0
	add.l	d0,d0
	sub.l	d1,d0
	beq.s	.skip2
	move.l	a2,a1
	jsr	CopyMem(a6)
.skip2

;=== Altes Sample unloaden
	lea	sp_sample(a5),a3
	bsr	unloadfile

	move.l	(sp)+,(a3)	;Dabei wird der ursprngl. Header
	move.l	(sp)+,d0	;(AIFF,MAUD) abgeschnitten!
	move.l	d0,4(a3)
	lsr.l	#1,d0
	move.l	d0,sp_frames(a5)
	move.l	(a3),sp_sampledata(a5)

	move.l	sp_rangestart(a5),d0
	lsr.l	#1,d0
	move.l	sp_rangestop(a5),d1
	lsr.l	#1,d1

;=== Ist die Loop vor der Range ?
	cmp.l	sp_loopend(a5),d0
	bcc.s	.gofurther

;=== Ist die Loop hinter der Range ?
	cmp.l	sp_loopstart(a5),d1
	bhi.s	.not1
	move.l	d1,d2
	sub.l	d0,d2
	sub.l	d2,sp_loopstart(a5)
	sub.l	d2,sp_loopend(a5)
	bra.s	.gofurther

;=== Loopstart korrigieren
.not1	cmp.l	sp_loopstart(a5),d0	; d0=rangestart
	bcc.s	.not2
	move.l	d0,sp_loopstart(a5)

;=== Loopend korrigieren
.not2	cmp.l	sp_loopend(a5),d1
	bls.s	.not3
	move.l	d0,sp_loopend(a5)
	bra.s	.gofurther
.not3	move.l	d1,d2
	sub.l	d0,d2
	sub.l	d2,sp_loopend(a5)

.gofurther

;=== Display korrigieren
;	sub.l	d0,d1
;	add.l	d1,d1			; d1=Rangestop-Rangestart .b
	



	moveq	#-1,d0
	move.l	d0,sp_rangestart(a5)	; -1 = "keine range"


	move.l	4(a3),d0
;=== Rechten Display-Rand abchecken
	cmp.l	rightmargin(a5),d0
	bcc.s	.okay
	move.l	d0,rightmargin(a5)
.okay

	st	realloc_flag(a5)
	st	sample_changed(a5)
	bsr	RefreshDisplay
	bsr	UpdateSprocScroller
	lea	rangecut_txt(pc),a1
	move.w	#loc_rangecut,d0
	jsr	sproc_statusJ(a5)
.out	jsr	SprocActivePointerJ(a5)
.rts	rts

.nomem	addq.w	#4,sp
	bsr	nomemory
	bra.s	.out





;==============================================================
;
;  COPY Range
;
;==============================================================

sproc_copy
	tst.l	sp_rangestart(a5)
	bmi	norange_error

	jsr	SprocBusyPointerJ(a5)
	bsr.s	sp_copy
	lea	copied_txt(pc),a1
	move.w	#loc_rangecopied,d0
	jsr	sproc_statusJ(a5)
	jmp	SprocActivePointerJ(a5)


sp_copy
	bsr.s	FreeSprocBuffer
	move.l	sp_rangestart(a5),d1
	move.l	sp_rangestop(a5),d0
	sub.l	d1,d0
	beq.s	.nocopy
	move.l	d0,sp_buffersize(a5)
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	move.l	d0,sp_buffer(a5)
	beq.s	.neg
;=== Bereich kopieren
	move.l	d0,a1
	move.l	sp_sampledata(a5),a0
	adda.l	sp_rangestart(a5),a0
	move.l	sp_buffersize(a5),d0
	jsr	CopyMem(a6)
.nocopy	POSITIV

.neg	NEGATIV

FreeSprocBuffer
	lea	sp_buffer(a5),a0
	jmp	MyFreeVectorJ(a5)




;==============================================================
;
;  PASTE Range
;
;==============================================================

sproc_paste
	tst.l	sp_frames(a5)
	beq.s	.paste_all

	rts

	st	realloc_flag(a5)
	st	sample_changed(a5)
	rts


.paste_all
	move.l	sp_buffer(a5),d2
	beq.s	.empty

	lea	sp_loadsample(a5),a3
	move.l	sp_buffersize(a5),d0
	move.l	d0,4(a3)
	moveq	#1,d1
	move.l	(a5),a6
	jsr	AllocMem(a6)
	move.l	d0,(a3)
	beq	nomemory

	move.l	d0,a1
	move.l	d2,a0
	move.l	4(a3),d0
	jsr	CopyMem(a6)

	bra	raw_file


.empty
	move.w	#loc_bufempty,d0
	moveq	#loc_howtrue,d1
	jmp	EZrequestJ(a5)



;==============================================================
;
;  MIX Range
;
;==============================================================

sproc_join
	rts

	st	realloc_flag(a5)
	st	sample_changed(a5)
	rts





;==============================================================
;
;  Sample Rate Gadget
;
;==============================================================

sproc_samplerate
	jsr	GetIntegerSprocJ(a5)
	move.l	#28860*2,d1
	cmp.l	d1,d0
	bpl.s	.oflow
	move.l	#1000,d1
	cmp.l	d1,d0
	bpl.s	.go

.oflow	move.l	d1,d0
.go	bra.s	sproc_rate_change




;==============================================================
;
;  Fest eingestellte Sampleraten
;
;==============================================================

sproc_r11025
	move.l	#11025,d0
	bra.s	sproc_rate_change

sproc_r44100
	move.l	#44100,d0
	bra.s	sproc_rate_change

sproc_r22050
	move.l	#22050,d0

sproc_rate_change
	cmp.l	sp_rate(a5),d0
	beq.s	sproc_ratejump
	st	sample_changed(a5)
sproc_ratejump
	cmp.l	#28867,sp_rate(a5)
	scc	d1
	move.l	d0,sp_rate(a5)
	cmp.l	#28867,d0
	scc	d2
	move.b	d2,half_rate(a5)
	eor.b	d2,d1
	move.b	d1,realloc_flag(a5)

	moveq	#GD_rate,d1
	jmp	SetIntegerSprocJ(a5)


free_chipsample
	lea	chip_sample(a5),a0
	jmp	MyFreeVectorJ(a5)




;==============================================================
;
;  Play All Button
;
;==============================================================

sproc_playall
	tst.l	sp_frames(a5)
	beq.s	nosample

	lea	playall_txt(pc),a1
	move.w	#loc_playingall,d0
	jsr	sproc_statusJ(a5)
	moveq	#0,d0
	move.l	sp_frames(a5),d1
	moveq	#1,d2
	bra.s	play_16bit
nosample
	move.w	#loc_nosample,d0
	move.w	#loc_letsload,d1
	jmp	EZrequestJ(a5)






play_16bit	;d0/d1=Start/End-points in Frames fr Oneshot
		;d2=playmode

	movem.l	d0-d2,-(sp)

;=== alten Sound stoppen
	bsr	sproc_stop_routine

	tst.b	realloc_flag(a5)
	beq.s	.noalloc

;=== reallocation
	bsr	free_chipsample

	move.l	sp_frames(a5),d0
	tst.b	half_rate(a5)
	beq.s	.cando1
	lsr.l	#1,d0
.cando1	lsr.l	#1,d0
	beq	.dont
	add.l	d0,d0

	moveq	#2,d1
	jsr	MyAllocVecJ(a5)
	move.l	d0,chip_sample(a5)
	beq	.nomem
	sf	realloc_flag(a5)

	jsr	SprocBusyPointerJ(a5)

	move.l	sp_sampledata(a5),a0
	move.l	chip_sample(a5),a1
	move.l	sp_frames(a5),d0
	tst.b	half_rate(a5)
	beq.s	.cando2

;=== Copy mit halbierter Samplerate
	lsr.l	#2,d0
	add.l	d0,d0
.copy1	move.b	(a0)+,(a1)+
	addq.w	#3,a0
	subq.l	#1,d0
	bne.s	.copy1
	bra.s	.cont1

;=== Copy mit normaler Samplerate
.cando2	lsr.l	#1,d0
	add.l	d0,d0
.copy4	move.b	(a0)+,(a1)+
	addq.w	#1,a0
	subq.l	#1,d0
	bne.s	.copy4


.cont1
	jsr	SprocActivePointerJ(a5)


.noalloc
;=== Period vorberechnen
	move.l	#3579546,d0
	move.l	sp_rate(a5),d1
	tst.b	half_rate(a5)
	beq.s	.normal
	lsr.l	#1,d1
.normal	LONGDIVU
	move.w	d0,currentperiod(a5)

;=== Oneshot-Part abspielen
	move.l	(sp),d0
	move.l	4(sp),d1
	tst.b	half_rate(a5)
	beq.s	.cando3
	lsr.l	#1,d0
	lsr.l	#1,d1
.cando3	and.b	#$fe,d0
	and.b	#$fe,d1

	move.l	chip_sample(a5),a2
	adda.l	d0,a2
	move.l	a2,currentstart(a5)
	sub.l	d0,d1
	move.l	d1,samples_todo(a5)


;=== Filter abfragen
	lea	$bfe001,a0
	move.b	(a0),d0
	and.b	#$02,d0
	move.b	d0,oldfilter(a5)
	tst.b	filtermode(a5)
	beq.s	.ignore
	bmi.s	.filter_on
;=== Filter Off
	bset	#1,(a0)
	bra.s	.ignore
.filter_on
	bclr	#1,(a0)
.ignore


	bsr	playsample
	beq.s	.write_error

	move.l	audioioStereo(a5),a1
	move.w	#7,$1c(a1)		; CMD_START
	clr.b	$1e(a1)
	move.l	$14(a1),a6
	jsr	BeginIO(a6)
	move.l	audioioStereo(a5),a1
	tst.b	$1f(a1)
	bne.s	.write_error

	clr.l	sample_counter(a5)
	move.b	11(sp),sp_playmode(a5)


.out	lea	$c(sp),sp
	rts

.write_error
	bsr	cycle_error
	bra.s	.neg
.nomem
	bsr.s	nomemory
.dont
.neg
	lea	replayerror_txt(pc),a1
	move.w	#loc_replayerror,d0
	jsr	sproc_statusJ(a5)
	bra.s	.out

noplay_body	dc.b	'Cannot play sample!',0
checkdiz_gadfmt dc.b	'_I will check this',0
nosample_body	dc.b	'No sample loaded',0
loadone_gadfmt	dc.b	'_Let''s load one',0
nobuf_body	dc.b	'The copybuffer is still empty.',0
range_body	dc.b	'Please mark a range first',0
letsgo_gadfmt	dc.b	'Let''s go',0
		even

playsample
	move.l	samples_todo(a5),d0
	beq	.nomore

	move.l	currentstart(a5),a0
	move.l	samples_todo(a5),d0
	move.l	#$20000,d3
	cmp.l	d3,d0
	bcs.s	.shot1
	move.l	d3,d0
.shot1	sub.l	d0,samples_todo(a5)
	add.l	d0,currentstart(a5)

	move.l	audioioLeft(a5),a1
	bsr.s	.fillchannel
	move.l	audioioRight(a5),a1
	bsr.s	.fillchannel

	move.l	audioioLeft(a5),a1
	move.l	$14(a1),a6
	jsr	BeginIO(a6)
	move.l	audioioLeft(a5),a1
	move.b	$1f(a1),d0
	bne.s	.err

	move.l	audioioRight(a5),a1
	jsr	BeginIO(a6)
	move.l	audioioRight(a5),a1
	move.b	$1f(a1),d0
	bne.s	.err

.nomore
	POSITIV
.err	NEGATIV

.fillchannel
	move.w	#3,$1c(a1)		; CMD_WRITE
	move.b	#$10,$1e(a1)		; PERVOL
	move.l	a0,$22(a1)
	move.l	d0,$26(a1)
	move.w	currentperiod(a5),$2a(a1)
	move.w	#$40,$2c(a1)		; Volume
	move.w	#1,$2e(a1)		; Cycles
	rts


cycle_ready

	clr.w	-(sp)
	move.l	(a5),a6
.getloop
	move.l	AudioReply(a5),a0
	jsr	GetMsg(a6)
	tst.l	d0
	beq.s	.getout
	cmp.l	AudioIOLeft(a5),d0
	bne.s	.getloop
	st	(sp)
	bra.s	.getloop
.getout
	tst.w	(sp)+
	beq.s	.rts


	tst.b	sp_looptype(a5)
	beq.s	.noloop
	tst.b	sp_playmode(a5)		; Bei PlayRange wird der
	bmi.s	.noloop			; Looptype ignoriert

	tst.l	samples_todo(a5)
	bne.s	.nextpiece

;=== Forward Loop
	move.l	sp_loopstart(a5),d0
	move.l	sp_loopend(a5),d1
	tst.b	half_rate(a5)
	beq.s	.cando4
	lsr.l	#1,d0
	lsr.l	#1,d1
.cando4	and.b	#$fe,d0
	and.b	#$fe,d1

	move.l	chip_sample(a5),a2
	adda.l	d0,a2
	move.l	a2,currentstart(a5)
	sub.l	d0,d1
	move.l	d1,samples_todo(a5)

.nextpiece
	bsr	playsample
	beq.s	cycle_error
.rts	rts

.noloop
	tst.l	samples_todo(a5)
	bne.s	.nextpiece

	bsr.s	RestoreFilter
	jmp	sproc_alrightJ(a5)

cycle_error
	move.w	#loc_noplay,d0
	move.w	#loc_checkdiz,d1
	jmp	EZrequestJ(a5)



RestoreFilter
	tst.b	filtermode(a5)
	beq.s	.ignore
	lea	$bfe001,a0
	move.b	oldfilter(a5),d0
	and.b	#$fd,(a0)
	or.b	d0,(a0)
.ignore	rts



;==============================================================
;
;  Play Range
;
;==============================================================

sproc_playrange
	tst.l	sp_frames(a5)
	beq	nosample

	move.l	sp_rangestart(a5),d0
	bmi.s	norange_error
	cmp.l	sp_rangestop(a5),d0
	beq	larger_range
	lea	playrange_txt(pc),a1
	move.w	#loc_playingrng,d0
	jsr	sproc_statusJ(a5)
	move.l	sp_rangestart(a5),d0
	move.l	sp_rangestop(a5),d1
	lsr.l	#1,d0
	lsr.l	#1,d1
	moveq	#-1,d2
	bra	play_16bit

norange_error
	move.w	#loc_norange,d0
	move.w	#loc_letsgo,d1
	jmp	EZrequestJ(a5)


;==============================================================
;
;  Play Display
;
;==============================================================

sproc_playdisplay
	tst.l	sp_frames(a5)
	beq	nosample
	lea	playdis_txt(pc),a1
	move.w	#loc_playingdis,d0
	jsr	sproc_statusJ(a5)
	move.l	leftmargin(a5),d0
	move.l	rightmargin(a5),d1
	lsr.l	#1,d0
	lsr.l	#1,d1
	moveq	#-1,d2
	bra	play_16bit


;==============================================================
;
;  Stop Sound
;
;==============================================================

sproc_stop
	tst.l	sp_frames(a5)
	beq	nosample
	bsr.s	sproc_stop_routine
	lea	stopsample_txt(pc),a1
	move.w	#loc_smpstopped,d0
	jmp	sproc_statusJ(a5)


sproc_stop_routine
	move.l	audioioStereo(a5),d0
	beq	.notopen
	move.l	d0,a0
	tst.l	$14(a0)
	beq.s	.notopen


	tst.b	sp_playmode(a5)
	beq.s	.noabort
	clr.b	sp_playmode(a5)

;=== Sound anhalten
	move.l	audioioLeft(a5),a1
	move.l	(a5),a6
	jsr	CheckIO(a6)
	tst.l	d0
	bne.s	.noabl
	move.l	audioioLeft(a5),a1
	jsr	AbortDeviceJ(a5)
.noabl
	move.l	audioioRight(a5),a1
	move.l	(a5),a6
	jsr	CheckIO(a6)
	tst.l	d0
	bne.s	.noabr
	move.l	audioioRight(a5),a1
	jsr	AbortDeviceJ(a5)
.noabr
	move.l	audioioStereo(a5),a1
	move.l	(a5),a6
	jsr	CheckIO(a6)
	tst.l	d0
	bne.s	.noabs
	move.l	audioioStereo(a5),a1
	jsr	AbortDeviceJ(a5)
.noabs

.noabort
	move.l	audioioStereo(a5),a1
	move.w	#6,$1c(a1)		; CMD_STOP
	move.l	(a5),a6
	jsr	SendIO(a6)
	move.l	audioioStereo(a5),a1
	jsr	WaitIO(a6)

	bsr	RestoreFilter

.notopen
	rts



;==============================================================
;
;  Audio Device initialisieren
;
;==============================================================

init_sp_audio

	move.l	(a5),a6
	jsr	CreateMsgPort(a6)
	move.l	d0,AudioReply(a5)
	beq	.neg
	move.l	d0,a0
	move.b	$f(a0),audiosignal(a5)
	move.b	#$20,$9(a0)		; Pri


;=== Stereo-IORequest initialisieren
	moveq	#$44,d0
	jsr	CreateIORequest(a6)
	move.l	d0,audioioStereo(a5)
	beq	.neg

	move.l	d0,a1
	move.b	#30,$9(a1)		; Pri
	move.w	#$20,$1c(a1)		; ADCMD_ALLOCATE
	move.b	#$40,$1e(a1)
	clr.w	$20(a1)
	lea	channelopts(pc),a0
	move.l	a0,$22(a1)
	moveq	#channeloptslen,d0	; Lnge von Channelopts
	move.l	d0,$26(a1)

;=== Audio ffnen
	lea	audnam(pc),a0
	jsr	OpenDevice(a6)		; Flags und Unit not used
	tst.l	d0
	bne.s	.neg2



;=== Left-IORequest initialisieren
	moveq	#$44,d0
	move.l	AudioReply(a5),a0
	jsr	CreateIORequest(a6)
	move.l	d0,audioioLeft(a5)
	beq.s	.neg

	move.l	d0,a1
	move.l	AudioIOStereo(a5),a0
	moveq	#$44,d0
	jsr	CopyMem(a6)
	moveq	#$09,d0
	move.l	AudioIOLeft(a5),a0
	and.l	d0,$18(a0)		; Unit ausmaskieren



;=== Right-IORequest initialisieren
	moveq	#$44,d0
	move.l	AudioReply(a5),a0
	jsr	CreateIORequest(a6)
	move.l	d0,audioioRight(a5)
	beq.s	.neg

	move.l	d0,a1
	move.l	AudioIOStereo(a5),a0
	moveq	#$44,d0
	jsr	CopyMem(a6)
	moveq	#$06,d0
	move.l	AudioIORight(a5),a0
	and.l	d0,$18(a0)		; Unit ausmaskieren



	POSITIV


.neg2	move.l	audioioStereo(a5),a0
	clr.l	$14(a0)
.neg
	move.w	#loc_noaudio,d0
	move.w	#loc_sigh,d1
	jsr	EZrequestJ(a5)
	NEGATIV


;audioio
;	dc.l	0,0		;succ,pred
;	dc.b	0,20		;type,pri
;	dc.l	0		;name
;	dc.l	0		;AudioReply
;	dc.w	$44		;length audioio
;
;	dc.l	0,0		;intern (device + unit)
;io-extension
;	dc.w	$20		;COMMAND.w
;	dc.b	$40,0		;Flags.b, Error.b
;audiospezifische Daten
;	dc.w	0		;ioa_AllocKey
;	dc.l	0,4		;Data, Length
;	dc.w	$100		;Period
;	dc.w	$40		;Volume
;	dc.w	1		;Cycles
;Write-Message
;	dc.l	0,0
;	dc.b	5,0		;Message, Pri
;	dc.l	0		;name
;	dc.l	0		;ReplyPort
;	dc.w	0		;Length of Message

audio_body	dc.b	'Cannot allocate Audio Device!',0
channelopts	dc.b	$03,$05,$0a,$0c	;$01,$02,$04,$08
channeloptslen = *-channelopts
audnam		dc.b	'audio.device',0
		even



;==============================================================
;
;  Audio Device releasen
;
;==============================================================

free_sp_audio

	move.l	(a5),a6

	move.l	audioioRight(a5),d0
	beq.s	.noright
	move.l	d0,a0
	jsr	DeleteIORequest(a6)
	clr.l	audioioRight(a5)
.noright

	move.l	audioioLeft(a5),d0
	beq.s	.noleft
	move.l	d0,a0
	jsr	DeleteIORequest(a6)
	clr.l	audioioLeft(a5)
.noleft


;=== Audio Device freigeben
	move.l	audioioStereo(a5),d0
	beq.s	.nostereo
	move.l	d0,a1
	tst.l	$14(a1)
	beq.s	.nodevice
	jsr	CloseDevice(a6)
.nodevice

	move.l	audioioStereo(a5),a0
	jsr	DeleteIORequest(a6)
	clr.l	audioioStereo(a5)
.nostereo



;=== Replyport freigeben
	move.l	AudioReply(a5),d0
	beq.s	.noreply
	move.l	d0,a0
	jsr	DeleteMsgPort(a6)
	clr.l	AudioReply(a5)
.noreply
	st	audiosignal(a5)

	rts




;==============================================================
;
;  Looptype Cycle-Gadget
;
;==============================================================

smp_looptype
	jsr	GetCycleSprocJ(a5)
	move.b	d0,sp_looptype(a5)

	bra	RefreshDisplay




;==============================================================
;
;  Cut To Buffer Checkmark
;
;==============================================================

cuttobuffer
	move.w	#cuttobuffer_menu,d0
	bsr	SprocCheckmark
	move.b	d0,sp_cuttobuf(a5)
	rts




;==============================================================
;
;  Autozoom Checkmark
;
;==============================================================

autozoom
	move.w	#autozoom_menu,d0
	bsr	SprocCheckmark
	move.b	d0,sp_autozoom(a5)
	rts




;==============================================================
;
;  Range All
;
;==============================================================

range_all
	tst.l	sp_sample(a5)
	beq	nosample

	move.l	leftmargin(a5),sp_rangestart(a5)
	move.l	rightmargin(a5),sp_rangestop(a5)
	bra.s	do_range




;==============================================================
;
;  Show All
;
;==============================================================

show_all
	tst.l	sp_sample(a5)
	beq	nosample
	bsr	FreeZoomHist
	clr.l	leftmargin(a5)
	move.l	sp_frames(a5),d0
	add.l	d0,d0
	move.l	d0,rightmargin(a5)
	bsr	RefreshDisplay
	bsr	UpdateSprocScroller

;	bra.s	do_range




;==============================================================
;
;  Normale Range zeichnen
;
;==============================================================

do_range
	move.l	sp_rangestart(a5),d0
	bmi.s	.rts
	move.l	sp_rangestop(a5),d1
	moveq	#2,d2			; Range in wei zeichnen
	bra	draw_range
.rts	rts



;==============================================================
;
;  Sample Endian
;
;==============================================================

sp_endian
	not.b	sproc_endian(a5)

	jsr	SprocBusyPointerJ(a5)


	move.l	sp_sampledata(a5),a0
	move.l	sp_frames(a5),d0
.changeloop
	move.w	(a0),d1
	ror.w	#8,d1
	move.w	d1,(a0)+
	subq.l	#1,d0
	bne.s	.changeloop


	st	realloc_flag(a5)
	bsr	RefreshDisplay
	bsr	do_range
	jmp	SprocActivePointerJ(a5)




;==============================================================
;
;  Octave upsample
;
;==============================================================

sp_filter
	moveq	#f_ignore_menu,d0
	bsr	SprocCheckmark
	bne.s	.filter_ignore

	move.w	#f_on_menu,d0
	bsr	SprocCheckmark
	bne.s	.filter_on

;	bra.s	.filter_off


.filter_off
	move.b	#1,filtermode(a5)
	rts

.filter_ignore
	sf	filtermode(a5)
	rts

.filter_on
	st	filtermode(a5)
	rts




;==============================================================
;
;  Octave upsample
;
;==============================================================

octave_up
	tst.l	sp_sample(a5)
	beq	nosample

	bsr	sproc_stop_routine

	move.l	sp_frames(a5),d0
	lsr.l	#1,d0
	beq	.dont
	add.l	d0,d0
	moveq	#1,d1
	move.l	(a5),a6
	jsr	AllocMem(a6)
	tst.l	d0
	beq	.nomem
	move.l	d0,-(sp)

	jsr	SprocBusyPointerJ(a5)

	move.l	(sp),a1
	move.l	sp_sampledata(a5),a0
	move.l	sp_frames(a5),d0
	lsr.l	#1,d0
.copy	move.w	(a0)+,(a1)+
	addq.w	#2,a0
	subq.l	#1,d0
	bne.s	.copy

	lea	sp_sample(a5),a3
	bsr	unloadfile

	move.l	(sp)+,sp_sampledata(a5)
	move.l	sp_sampledata(a5),sp_sample(a5)
	move.l	sp_frames(a5),d0
	lsr.l	#1,d0
	move.l	d0,sp_frames(a5)
	add.l	d0,d0
	move.l	d0,sp_sample+4(a5)

	move.l	sp_rangestart(a5),d0
	bmi.s	.norange
	lsr.l	#2,d0
	add.l	d0,d0
	move.l	d0,sp_rangestart(a5)

	move.l	sp_rangestop(a5),d0
	lsr.l	#2,d0
	add.l	d0,d0
	move.l	d0,sp_rangestop(a5)

.norange
	move.l	sp_loopstart(a5),d0
	lsr.l	#1,d0
	move.l	d0,sp_loopstart(a5)

	move.l	sp_loopend(a5),d0
	lsr.l	#1,d0
	move.l	d0,sp_loopend(a5)

	move.l	leftmargin(a5),d0
	lsr.l	#1,d0
	move.l	d0,leftmargin(a5)

	move.l	rightmargin(a5),d0
	lsr.l	#1,d0
	move.l	d0,rightmargin(a5)

	move.w	#loc_upsampled,d0
	jsr	sproc_statusJ(a5)
	bra.s	oct_cont

.dont	rts
.nomem
	bra	nomemory

oct_cont
	st	realloc_flag(a5)
	st	sample_changed(a5)

	bsr	RefreshDisplay
	bsr	UpdateSprocScroller
	bsr	do_range
	jmp	SprocActivePointerJ(a5)


;==============================================================
;
;  Octave downsample
;
;==============================================================

octave_down
	tst.l	sp_sample(a5)
	beq	nosample
	bsr	sproc_stop_routine

	move.l	sp_frames(a5),d0
	lsl.l	#2,d0
	moveq	#1,d1
	move.l	(a5),a6
	jsr	AllocMem(a6)
	tst.l	d0
	beq	.nomem
	move.l	d0,-(sp)

	jsr	SprocBusyPointerJ(a5)

	move.l	(sp),a1
	move.l	sp_sampledata(a5),a0
	move.l	sp_frames(a5),d0
.copy	move.w	(a0),(a1)+
	move.w	(a0)+,(a1)+
	subq.l	#1,d0
	bne.s	.copy

	lea	sp_sample(a5),a3
	bsr	unloadfile

	move.l	(sp)+,sp_sampledata(a5)
	move.l	sp_sampledata(a5),sp_sample(a5)
	move.l	sp_frames(a5),d0
	add.l	d0,d0
	move.l	d0,sp_frames(a5)
	add.l	d0,d0
	move.l	d0,sp_sample+4(a5)

	move.l	sp_rangestart(a5),d0
	bmi.s	.norange
	add.l	d0,d0
	move.l	d0,sp_rangestart(a5)

	move.l	sp_rangestop(a5),d0
	add.l	d0,d0
	move.l	d0,sp_rangestop(a5)

.norange
	move.l	sp_loopstart(a5),d0
	lsr.l	#1,d0
	add.l	d0,d0
	move.l	d0,sp_loopstart(a5)

	move.l	sp_loopend(a5),d0
	lsr.l	#1,d0
	add.l	d0,d0
	move.l	d0,sp_loopend(a5)

	move.l	leftmargin(a5),d0
	lsr.l	#1,d0
	add.l	d0,d0
	move.l	d0,leftmargin(a5)

	move.l	rightmargin(a5),d0
	lsr.l	#1,d0
	add.l	d0,d0
	move.l	d0,rightmargin(a5)

	move.w	#loc_downsampled,d0
	jsr	sproc_statusJ(a5)
	bra	oct_cont

.nomem
	bra	nomemory



sampledown_txt	dc.b	'Sound is now downsampled.',0
sampleup_txt	dc.b	'Sound is now upsampled.',0
sampleboost_txt	dc.b	'Sample is boosted.',0
samplefilter_txt dc.b	'Sample is filtered.',0
sampleflip_txt	dc.b	'Sample is flipped.',0
vol200_txt	dc.b	'Sample Volume doubled.',0
vol50_txt	dc.b	'Sample Volume halved.',0
volany_txt	dc.b	'Sample Volume stretched.',0
volumeany_title	dc.b	'Please enter volume percentage',0

		even


;==============================================================
;
;  Sample boosten
;
;==============================================================

sampleboost
	tst.l	sp_sample(a5)
	beq	nosample
	bsr	sproc_stop_routine
	jsr	SprocBusyPointerJ(a5)

	move.l	sp_frames(a5),d2
	move.l	sp_sampledata(a5),a0
	moveq	#0,d0
.boostloop
	move.w	(a0),d1
	add.w	d0,(a0)+
	move.w	(a0),d0
	sub.w	d1,d0
	asr.w	#2,d0
	subq.l	#1,d2
	bne.s	.boostloop

.ready
	move.w	#loc_boosted,d0
	jsr	sproc_statusJ(a5)
	bra	oct_cont



;==============================================================
;
;  Sample filtern
;
;==============================================================


samplefilter
	tst.l	sp_sample(a5)
	beq	nosample
	bsr	sproc_stop_routine
	jsr	SprocBusyPointerJ(a5)

	move.l	sp_frames(a5),d2
	move.l	sp_sampledata(a5),a0
	moveq	#0,d0
.filterloop
	move.w	(a0),d1
	sub.w	d0,(a0)+
	move.w	(a0),d0
	sub.w	d1,d0
	asr.w	#1,d0
	subq.l	#1,d2
	bne.s	.filterloop

.ready
	move.w	#loc_filtered,d0
	jsr	status_displayJ(a5)
	bra	oct_cont




;==============================================================
;
;  Sample backwards
;
;==============================================================


sampleflip
	tst.l	sp_sample(a5)
	beq	nosample
	bsr	sproc_stop_routine
	jsr	SprocBusyPointerJ(a5)

	move.l	sp_frames(a5),d2
	add.l	d2,d2
	move.l	sp_sampledata(a5),a0
	lea	(a0,d2.l),a1
.fliploop
	move.w	(a0),d0
	move.w	-(a1),(a0)+
	move.w	d0,(a1)
	subq.l	#4,d2
	bhi.s	.fliploop

.ready
	move.w	#loc_flipped,d0
	jsr	status_displayJ(a5)
	bra	oct_cont




;==============================================================
;
;  Sample Volume verdoppeln
;
;==============================================================

volume_200
	tst.l	sp_sample(a5)
	beq	nosample
	bsr	sproc_stop_routine
	jsr	SprocBusyPointerJ(a5)

	move.l	sp_frames(a5),d4
	add.l	d4,d4
	move.l	sp_sampledata(a5),a0
	move.w	#$7fff,d1		; highest sample-value
	move.w	#$8000,d2		; lowest sample-value
.200loop
	move.w	(a0),d0
	add.w	d0,d0
	bvc.s	.noflow
	bmi.s	.nega
	move.w	d2,(a0)+
	bra.s	.cont
.nega	move.w	d1,d0
.noflow	move.w	d0,(a0)+
.cont	subq.l	#2,d4
	bhi.s	.200loop

	move.w	#loc_vol200,d0
	jsr	status_displayJ(a5)
	bra	oct_cont



;==============================================================
;
;  Sample Volume halbieren
;
;==============================================================

volume_50
	tst.l	sp_sample(a5)
	beq	nosample
	bsr	sproc_stop_routine
	jsr	SprocBusyPointerJ(a5)

	move.l	sp_frames(a5),d4
	add.l	d4,d4
	move.l	sp_sampledata(a5),a0
.50loop
	move.w	(a0),d0
	asr.w	#1,d0
	move.w	d0,(a0)+
	subq.l	#2,d4
	bhi.s	.50loop

	move.w	#loc_vol50,d0
	jsr	status_displayJ(a5)
	bra	oct_cont





;==============================================================
;
;  Sample Volume je nach Eingabe vervielfachen
;
;==============================================================

volume_any
	tst.l	sp_sample(a5)
	beq	nosample
	bsr	sproc_stop_routine

;=== Long-Requester fordert User auf, Prozentsatz einzugeben
	move.w	#loc_volpercent,d0
	moveq	#120,d1
	jsr	rtLongJ(a5)
	beq.s	.cancelled

	move.w	d1,-(sp)
	jsr	SprocBusyPointerJ(a5)
	move.w	(sp)+,d1

	move.l	sp_frames(a5),d4
	add.l	d4,d4
	move.l	sp_sampledata(a5),a0
.anyloop
	move.w	(a0),d0
	muls	d1,d0
	divs	#100,d0
	move.w	d0,(a0)+
	subq.l	#2,d4
	bhi.s	.anyloop

	move.w	#loc_volany,d0
	jsr	status_displayJ(a5)
	bra	oct_cont

.cancelled
	rts





;==============================================================
;
;  cut out range
;
;==============================================================

sproc_cutout

	tst.l	sp_rangestart(a5)
	bmi	norange_error

	jsr	SprocBusyPointerJ(a5)
	bsr	sproc_stop_routine

	move.l	sp_rangestop(a5),d0
	sub.l	sp_rangestart(a5),d0
	move.l	d0,-(sp)
	moveq	#1,d1
	move.l	(a5),a6
	jsr	AllocMem(a6)
	tst.l	d0
	beq	.nomem
	move.l	d0,-(sp)


;=== Sampledata kopieren
	move.l	d0,a1
	move.l	sp_sampledata(a5),a0
	adda.l	sp_rangestart(a5),a0
	move.l	4(sp),d0
	jsr	CopyMem(a6)


;=== Altes Sample unloaden
	lea	sp_sample(a5),a3
	bsr	unloadfile

;=== Dabei wird der ursprngl. Header (AIFF,MAUD) abgeschnitten!
	move.l	(sp)+,(a3)
	move.l	(sp)+,d0
	move.l	d0,4(a3)
	lsr.l	#1,d0
	move.l	d0,sp_frames(a5)
	move.l	(a3),sp_sampledata(a5)



	move.l	sp_rangestart(a5),d0
	lsr.l	#1,d0
	move.l	sp_rangestop(a5),d1
	lsr.l	#1,d1

;=== Ist die Loop vor der Range ?
	cmp.l	sp_loopend(a5),d0
	bcc.s	.gofurther

;=== Ist die Loop hinter der Range ?
	cmp.l	sp_loopstart(a5),d1
	bhi.s	.not1
	move.l	d1,d2
	sub.l	d0,d2
	sub.l	d2,sp_loopstart(a5)
	sub.l	d2,sp_loopend(a5)
	bra.s	.gofurther

;=== Loopstart korrigieren
.not1	cmp.l	sp_loopstart(a5),d0	; d0=rangestart
	bcc.s	.not2
	move.l	d0,sp_loopstart(a5)

;=== Loopend korrigieren
.not2	cmp.l	sp_loopend(a5),d1
	bls.s	.not3
	move.l	d0,sp_loopend(a5)
	bra.s	.gofurther
.not3	move.l	d1,d2
	sub.l	d0,d2
	sub.l	d2,sp_loopend(a5)

.gofurther


	moveq	#-1,d0
	move.l	d0,sp_rangestart(a5)	; -1 = "keine range"


	move.l	4(a3),d0
;=== Rechten Display-Rand abchecken
	cmp.l	rightmargin(a5),d0
	bcc.s	.okay
	move.l	d0,rightmargin(a5)
.okay


	st	realloc_flag(a5)
	st	sample_changed(a5)
	bsr	RefreshDisplay
	bsr	UpdateSprocScroller
	lea	rangecut_txt(pc),a1
	move.w	#loc_rangecut,d0
	jsr	sproc_statusJ(a5)
.out	jsr	SprocActivePointerJ(a5)
.rts	rts

.nomem	addq.w	#4,sp
	bsr	nomemory
	bra.s	.out









;====================================================================

		rsreset
GD_display	rs.b	1
GD_editsmp	rs.b	1
GD_geteditsmp	rs.b	1
GD_smpzoomin	rs.b	1
GD_smpzoomout	rs.b	1
GD_smpcut	rs.b	1
GD_smpcopy	rs.b	1
GD_smppaste	rs.b	1
GD_smpjoin	rs.b	1
GD_smpplayall	rs.b	1
GD_smpplayrange	rs.b	1
GD_smpstop	rs.b	1
GD_smploop	rs.b	1
GD_rangeall	rs.b	1
GD_showall	rs.b	1
GD_smpplaydis	rs.b	1
GD_smpcutout	rs.b	1
GD_rate		rs.b	1

MTsproc_CNT	rs.b	1



MTsprocBevels
	dc.w	6,4,484,130,0
sprocbevelsnum = (*-MTsprocBevels)/10


MTsprocNGads

.toff	= 150		; Offset zum oberen Rand
.loff	= 6		; Offset zum linken Rand
.xs	= 100		; X-Size
.ys	= 17		; Y-Size (auch fr BlockOp-Gadgets)
.xd	= .xs+3		; X-Delta
.xdb	= 83		; X-Delta fr Block-Operations-Gadgets
.yd	= .ys+3		; Y-Delta
.loffb	= .loff+3*.xd+11 ; linker Offset zu den BlockOp-Gadgets

	NEWGAD	6,134,484,12,*,-1,GD_display,$0000
	NEWGAD	.loff,.toff+1+3*.yd,261,15,*,-1,GD_editsmp,$0000
	NEWGAD	.loff+262,.toff+1+3*.yd,26,15,*,-1,GD_geteditsmp,$0000
	NEWGAD	.loff,.toff,.xs,.ys,*,loc_zoomin,GD_smpzoomin,$0010
	NEWGAD	.loff,.toff+.yd,.xs,.ys,*,loc_zoomout,GD_smpzoomout,$0010
	NEWGAD	.loffb,.toff,81,.ys,*,loc_sp_cut,GD_smpcut,$0010
	NEWGAD	.loffb+.xdb,.toff,81,.ys,*,loc_sp_copy,GD_smpcopy,$0010
	NEWGAD	.loffb,.toff+.yd,81,.ys,*,loc_sp_paste,GD_smppaste,$0010
	NEWGAD	.loffb+.xdb,.toff+.yd,81,.ys,*,loc_sp_mix,GD_smpjoin,$0010
	NEWGAD	.loff+.xd,.toff+2*.yd,.xs,.ys,*,loc_playall,GD_smpplayall,$0010
	NEWGAD	.loff+.xd,.toff+.yd,.xs,.ys,*,loc_playrange,GD_smpplayrange,$0010
	NEWGAD	.loff+2*.xd,.toff+.yd,.xs,.ys,*,loc_sp_stop,GD_smpstop,$0010
	NEWGAD	.loff+2*.xd,.toff,.xs,.ys,*,-1,GD_smploop,$0000
	NEWGAD	.loff+2*.xd,.toff+2*.yd,.xs,.ys,*,loc_rangeall,GD_rangeall,$0010
	NEWGAD	.loff,.toff+2*.yd,.xs,.ys,*,loc_showall,GD_showall,$0010
	NEWGAD	.loff+.xd,.toff,.xs,.ys,*,loc_playdisplay,GD_smpplaydis,$0010
	NEWGAD	.loffb,.toff+.yd*2,81,.ys,*,loc_sp_cutout,GD_smpcutout,$0010
	NEWGAD	.loffb+30,.toff+1+3*.yd,65,14,*,loc_sdsrate,GD_rate,$0001




MTsprocGTags
MTsprocGTtop = *+4-MTsprocGTags
	dc.L	$80080015,0
MTsprocGTtotal = *+4-MTsprocGTags
	DC.L	$80080016,480
MTsprocGTvisible = *+4-MTsprocGTags
	DC.L	$80080017,480
	DC.L	$8008003B,17
	DC.L	$80031001,$00000001
	DC.L	$80030016,1
	DC.L	$00000000
MTsprocGTfile = *+4-MTsprocGTags
	DC.L	$8008000B,0
	DC.L	$80080039,1		; put border
	DC.L	$00000000
	DC.L	$00000000		; getfile
;	DC.L	$80080040,'_'
	DC.L	$00000000
;	DC.L	$80080040,'_'
	DC.L	$00000000
	DC.L	$00000000
;	DC.L	$80080040,'_'
	DC.L	$00000000
	DC.L	$8003000E,1		; paste (disable)
	DC.L	$00000000
;	DC.L	$80080040,'_'
	DC.L	$8003000E,1		; mix (disable)
	DC.L	$00000000
;	DC.L	$80080040,'_'
	DC.L	$00000000
;	DC.L	$80080040,'_'
	DC.L	$00000000
;	DC.L	$80080040,'_'
	DC.L	$00000000
	DC.L	$8008000E,smploopLabels
	DC.L	$00000000
;	DC.L	$80080040,'_'
	DC.L	$00000000
	DC.L	$00000000
;	DC.L	$80080040,'_'
	DC.L	$00000000
;	DC.L	$80080040,'_'
	DC.L	$00000000
MTsprocGTrate = *+4-MTsprocGTags
	DC.L	$8008002F,44100
	DC.L	$80080030,5
	DC.L	$80032010,$00000400
	DC.L	$00000000



smploopLabels
	dc.w	1,loc_loopoff
	dc.w	1,loc_loopforward

	DC.l	0



smploopLab0	DC.B	'Loop Off',0
smploopLab1	DC.B	'Forward',0



MTsprocGTypes
	DC.b	9,13,-1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,3



MTsprocWdef	DC.B	'16bit Sample Processor',0
sproctitle_len = 30					; max status length

display_text	dc.b	'Display:',0
display_titlelen = 8					; length of number


smpzoominText	DC.B	'Zoom in',0
smpzoomoutText	DC.B	'Zoom out',0
smpcutText	DC.B	'Cut',0
smpcutoutText	DC.B	'Cut out',0
smpcopyText	DC.B	'Copy',0
smppasteText	DC.B	'Paste',0
smpjoinText	DC.B	'Mix',0
smpplayallText	DC.B	'Play All',0
smpplayrangeText DC.B	'Play Range',0
smpplaydisText	DC.B	'Play Display',0
smpstopText	DC.B	'Stop',0
rangeallText	DC.B	'Range All',0
showallText	DC.B	'Show All',0


MTsprocMclose	DC.B	'Close Window',0
MTsprocMsample	DC.B	'Sample',0
MTsprocMopen	DC.B	'Open',0
MTsprocMunload	DC.B	'Unload',0
MTsprocMs_raw	DC.B	'Save DUMP',0
MTsprocMs_aiff	DC.B	'Save AIFF',0
MTsprocMs_maud	DC.B	'Save MAUD',0
MTsprocMflags	DC.B	'Settings',0
MTsprocMcuttobuf DC.B	'Cut Into Buffer',0
MTsprocMautozom	DC.B	'Auto Zoom',0
MTsprocMendian	dc.b	'DUMP endian toggle',0
MTsprocMedit	DC.B	'Edit',0
MTsprocMrate	dc.b	'Sample Rate',0
MTsprocMr44100	dc.b	'44100',0
MTsprocMr22050	dc.b	'22050',0
MTsprocMr11025	dc.b	'11025',0
MTsprocMoctup	dc.b	'Octave up',0
MTsprocMoctdown	dc.b	'Octave down',0
MTsprocMboost	dc.b	'Boost',0
MTsprocMfilter	dc.b	'Filter',0
MTsprocMflip	dc.b	'Flip',0
MTsprocMlowpass	dc.b	'Low-Pass Filter',0
MTsprocMf_ignore dc.b	'Don''t touch',0
MTsprocMf_on	dc.b	'On',0
MTsprocMf_off	dc.b	'Off',0
MTsprocMvol200	dc.b	'Volume 200%',0
MTsprocMvol50	dc.b	'Volume  50%',0
MTsprocMvolx	dc.b	'Volume any%',0


MTsprocKclose	DC.B	'q',0
MTsprocKopen	DC.B	'o',0
MTsprocKs_raw	DC.B	'1',0
MTsprocKs_aiff	DC.B	'2',0
MTsprocKs_maud	DC.B	'3',0
MTsprocKautozom	DC.B	'z',0
MTsprocKr11025	dc.b	'7',0
MTsprocKr22050	dc.b	'8',0
MTsprocKr44100	dc.b	'9',0
MTsprocKboost	dc.b	'b',0
MTsprocKfilter	dc.b	'l',0
MTsprocKflip	dc.b	'f',0
MTsprocKvol200	dc.b	'+',0
MTsprocKvol50	dc.b	'-',0
MTsprocKvolx	dc.b	'v',0

		even


MTsprocWindowTags
	DC.L	$80000064,72
	DC.L	$80000065,20
	DC.L	$80000066,503
	DC.L	$80000067,213
	DC.L	$8000006B,sprocWFlags
MTsprocWG = *+4-MTsprocWindowTags
	DC.L	$8000006C,0
MTsprocWT = *+4-MTsprocWindowTags
	DC.L	$8000006E,0
MTsprocST = *+4-MTsprocWindowTags
	DC.L	$8000006F,0
MTsprocSC = *+4-MTsprocWindowTags
	DC.L	$80000079,0
	DC.L	$80000090,1		; AutoAdjust
MTsprocHG = *+4-MTsprocWindowTags
	dc.l	$8000009b,0		; Help Group (V39)
	DC.L	$00000000




	dc.b	0	; V37-Verarbeitung
	dc.b	0	;  0 = noch nicht localized,
			; -1 = ist bereits localized
MTsprocNewMenu0
	MENU	1,MTsprocMsample,-1
	MENU	  2,0,loc_sp_open,MTsprocKopen
	MENU	  2,0,loc_sp_unload
	MENU	  2,BARLABEL
	MENU	  2,0,loc_saveraw,MTsprocKs_raw
	MENU	  2,0,loc_saveaiff,MTsprocKs_aiff
	MENU	  2,0,loc_savemaud,MTsprocKs_maud
	MENU	  2,BARLABEL
	MENU	  2,0,loc_close,MTsprocKclose

	MENU	1,0,loc_sp_flags
MTsprocNMcuttobuf = *+10-MTsprocNewMenu0
cuttobuffer_menu = 31*$800+0*$20+1
	MENU	  2,0,loc_sp_cuttobuf,0,$0109

MTsprocNMautozom = *+10-MTsprocNewMenu0
autozoom_menu = 31*$800+1*$20+1
	MENU	  2,0,loc_autozoom,MTsprocKautozom,$0009

MTsprocNMendian = *+10-MTsprocNewMenu0
endian_menu = 31*$800+2*$20+1
	MENU	  2,0,loc_endian,0,$0010

	MENU	  2,0,loc_lowpass
MTsprocNMfignonoff = *+10-MTsprocNewMenu0
f_ignore_menu = 0*$800+3*$20+1
	MENU	    3,0,loc_lp_ignore,0,$0101,~1
f_on_menu = 1*$800+3*$20+1
	MENU	    3,0,loc_lp_on,0,$0001,~2
	MENU	    3,0,loc_lp_off,0,$0001,~4

	MENU	  2,BARLABEL
	MENU	  2,0,loc_sp_rate
	MENU	    3,MTsprocMr11025,-1,MTsprocKr11025
	MENU	    3,MTsprocMr22050,-1,MTsprocKr22050
	MENU	    3,MTsprocMr44100,-1,MTsprocKr44100

	MENU	1,0,loc_sp_edit
	MENU	  2,0,loc_sp_oct_up
	MENU	  2,0,loc_sp_oct_down
	MENU	  2,BARLABEL
	MENU	  2,0,loc_sp_vol200,MTsprocKvol200
	MENU	  2,0,loc_sp_vol50,MTsprocKvol50
	MENU	  2,0,loc_sp_volany,MTsprocKvolx
	MENU	  2,BARLABEL
	MENU	  2,0,loc_sp_boost,MTsprocKboost
	MENU	  2,0,loc_sp_filter,MTsprocKfilter
	MENU	  2,0,loc_sp_flip,MTsprocKflip

	MENU	0

