;APS00009849000000000000000000000000000000000000000000000000000000000000000000000000
;==============================================================
;==============================================================
;==============================================================
;==============================================================
;==============================================================
;
;
;
;
;               S A M P L E    D U M P
;
;
;
;
;
;==============================================================
;==============================================================
;==============================================================
;==============================================================
;==============================================================



sample_dump
	move.l	MTsdsStruct+wd_Wnd(a5),d0
	bne	window_activation

;=== Fenster ffnen
	lea	MTsdsStruct(a5),a4
	bsr.s	.RefreshSds
	bsr	OpenWD
	bne.s	.neg
	bsr	.AfterRefresh
	POSITIV
.neg	NEGATIV


.RefreshSds
	move.l	wd_GTags(a4),a3

	lea	rt_sdsload_name(a5),a1
	move.l	a1,MTsdsGTfile(a3)
	move.b	samplesaver(a5),MTsdsGTsaver+3(a3)

	move.b	dump_handshake(a5),MTsdsGThandshake+3(a3)

	move.w	samplenumber(a5),MTsdsGTnumber(a3)
	move.b	sdumpchannel(a5),MTsdsGTsysexid(a3)
	move.l	samplerate(a5),MTsdsGTrate(a3)
	move.l	samplelength(a5),MTsdsGTsmplength(a3)
	move.l	samplelstart(a5),MTsdsGTloopstart(a3)
	move.l	samplelend(a5),MTsdsGTloopend(a3)

	moveq	#0,d0
	tst.l	sp_sample(a5)
	bne.s	.enable
	moveq	#1,d0
.enable	move.l	d0,MTsdsGTsmpbuf_en(a3)

	move.b	smpbuffer(a5),MTsdsGTsmpbuf(a3)


	tst.b	smpbuffer(a5)
	bne.s	.frombuffer

	moveq	#0,d0
	move.l	d0,MTsdsGTrate_en(a3)
	move.l	d0,MTsdsGTsmplength_en(a3)
	move.l	d0,MTsdsGTloopstart_en(a3)
	move.l	d0,MTsdsGTloopend_en(a3)
	move.l	d0,MTsdsGTfile_en(a3)

	tst.b	rt_sdsload_name(a5)
	beq.s	.empty
	cmp.b	#1,sampletype(a5)
	beq.s	.disbts
.empty	moveq	#1,d0
.disbts	move.l	d0,MTsdsGTbits_en(a3)
	bra.s	.weiter

.frombuffer
	moveq	#1,d0
	move.l	d0,MTsdsGTrate_en(a3)
	move.l	d0,MTsdsGTsmplength_en(a3)
	move.l	d0,MTsdsGTloopstart_en(a3)
	move.l	d0,MTsdsGTloopend_en(a3)
	move.l	d0,MTsdsGTfile_en(a3)
	move.l	d0,MTsdsGTbits_en(a3)
.weiter



;=== construct window title

	move.w	#loc_dump_at,d0
	jsr	getcatstringJ(a5)
	move.l	a1,a2
	move.l	a1,a0
	bsr	stringlength
	moveq	#sdswtitle_len,d1
	add.l	d1,d0
	addq.l	#1,d0			; 1 space
	move.w	d0,dumpingpos(a5)
	addq.l	#dumpingbytes,d0	; + 1 nullbyte
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	move.l	d0,sdstitle(a5)
	beq.s	.notitle

	lea	MTsdsWindowTags+MTsdsWT(pc),a0
	move.l	d0,(a0)
	move.l	d0,a1

	lea	MTsdsWTitle(pc),a0
	COPYWITHOUTZERO

	move.l	a2,a0
	COPYWITHOUTZERO

	moveq	#' ',d0
	REPT	1+dumpingbytes-1
	move.b	d0,(a1)+
	ENDR
	move.b	#'0',(a1)+
	clr.b	(a1)

.notitle



	rts




.AfterRefresh	;nachdem das Window geffnet wurde
	moveq	#GD_getsmp,d1
	tst.b	smpbuffer(a5)
	beq.s	.diskfile
	bra	DisableGetFileSds
.diskfile
	bra	EnableGetFileSds





sdswdclosegad
	tst.b	dumping(a5)
	beq.s	sdswdclose
	rts
sdswdclose
;wird aufgerufen, falls Menpunkt nochmals angewhlt wird
;und auch von FreeSomething !
	lea	MTsdsStruct(a5),a4
	bsr	CloseWD

	lea	sdstitle(a5),a0
	jmp	MyFreeVectorJ(a5)





sdsgadgetup
	lea	.sdsGadgetTab(pc),a0
	jmp	gadgetjsrJ(a5)

.sdsGadgetTab
	dr.w	get_sample
	dr.w	smp_bits
	dr.w	smp_dump
	dr.w	smp_abort
	dr.w	dump_request
	dr.w	smp_saver
	dr.w	sdump_handshake
	dr.w	.nop_gadget		;smp_file
	dr.w	smp_number
	dr.w	smp_rate
	dr.w	smp_length
	dr.w	smp_loopstart
	dr.w	smp_loopend
	dr.w	smp_buffer
	dr.w	sdump_sysexid

.nop_gadget
	rts





;==============================================================
;
;  GetFile Gadget
;
;==============================================================

get_sample
	lea	rt_sdsload_struct(pc),a4
	bsr	FileRequester
	beq	.load_cancelled



;	lea	rt_sdsload_name(a5),a1
	lea	rt_sdsload_struct(pc),a0
;	move.l	a1,d1
	move.l	#1005,d2
;	move.l	dosbas(a5),a6
	jsr	OpenFileFromFRJ(a5)
;	jsr	Open(a6)
	move.l	d0,d1
	beq	openerror1

	move.l	d1,-(sp)
	lea	sample_buffer(a5),a0
	move.l	a0,d2
	moveq	#smpbuffersize,d3
	jsr	Read(a6)
	cmp.l	d3,d0
	bne	openerror2

	move.l	d2,a2
	cmp.l	#'RIFF',(a2)
	beq	.wav
	cmp.l	#'Crea',(a2)
	beq	.voc
	cmp.l	#'FORM',(a2)
	bne	.raw

;=== iff sample
	cmp.l	#'8SVX',8(a2)
	bne	.aiff

	move.l	#'VHDR',d0
	move.l	(sp),d1
	lea	chunk_VHDR(a5),a0
	bsr	GetIffChunk
	beq	openerror2

	clr.b	sampletype(a5)
	move.b	#8,samplebits(a5)
	clr.b	samplelooptype(a5)
	sf	sample_zeromin(a5)
	st	sample_endian(a5)

	move.l	(a0),a0
	move.l	(a0)+,d0
	move.l	d0,samplelstart(a5)
	add.l	(a0)+,d0
	subq.l	#1,d0
	move.l	d0,samplelend(a5)
	addq.w	#4,a0
	moveq	#0,d0
	move.w	(a0)+,d0	;sampling rate
	move.l	d0,samplerate(a5)

	lea	chunk_VHDR(a5),a0
	bsr	FreeIffChunk

	move.l	#'BODY',d0
	move.l	(sp),d1
	bsr	GetIffChunkHead
	beq	openerror2
	move.l	chunkread+4(a5),d0
	move.l	d0,samplelength(a5)
	move.l	d0,samplefilesize(a5)

.noraw
;=== Rawbits disablen
	moveq	#GD_smpbits,d1
	bsr	DisableGadSds
	bra.s	.refresh

;=== RAW sample
.raw
	move.l	(sp),d1
	move.l	fib(a5),d2
	jsr	ExamineFH(a6)
	tst.l	d0
	beq	openerror2

	move.l	d2,a0
	move.l	$7c(a0),d0
	move.l	d0,samplefilesize(a5)

;=== Rawbits enablen
	moveq	#GD_smpbits,d1
	bsr	EnableGadSds

	moveq	#GD_smpbits,d1
	bsr	GetCycleSds
	move.l	samplefilesize(a5),d2
	tst.b	d0
	beq.s	.8bit
	move.b	#16,samplebits(a5)
	lsr.l	#1,d2
	sf	sample_endian(a5)
	subq.b	#1,d0
	bne.s	.set
	st	sample_endian(a5)
	bra.s	.set
.8bit	move.b	#8,samplebits(a5)
.set	sf	sample_zeromin(a5)
	clr.b	samplelooptype(a5)
	move.b	#1,sampletype(a5)

	move.l	d2,samplelength(a5)	;hier steht die # words drin!
	move.l	d2,samplelstart(a5)
	move.l	d2,samplelend(a5)
;es geht weiter

.refresh
	move.l	samplelength(a5),d0
	moveq	#GD_smplength,d1
	bsr	SetIntegerSds
	move.l	samplelstart(a5),d0
	moveq	#GD_loopstart,d1
	bsr	SetIntegerSds
	move.l	samplelend(a5),d0
	moveq	#GD_loopend,d1
	bsr	SetIntegerSds
	move.l	samplerate(a5),d0
	moveq	#GD_smprate,d1
	bsr	SetIntegerSds

	move.l	(sp)+,d1
	move.l	dosbas(a5),a6
	jsr	Close(a6)

	lea	rt_sdsload_name(a5),a0
	moveq	#1,d0
	moveq	#GD_smpfile,d1
	bra	SetTextSds



;=== wav sample (Achtung: sowohl 8bit als auch 16bit!)
.wav	cmp.l	#'WAVE',8(a2)
	bne	.raw

	move.l	#'fmt ',d0
	move.l	(sp),d1
	lea	chunk_VHDR(a5),a0
	bsr	GetWaveChunk
	beq	openerror2

	move.l	(a0),a1
	cmp.w	#$0100,(a1)
	bne	.nopcm
	cmp.w	#$0100,2(a1)
	bne	.stereo

	move.b	$e(a1),d0
	cmp.b	#8,d0
	beq.s	.8bitwv
	cmp.b	#16,d0
	bne.s	.no16b
	move.b	d0,samplebits(a5)
	bra.s	.cont
.8bitwv	move.b	d0,samplebits(a5)
.cont	move.b	#2,sampletype(a5)
	clr.b	samplelooptype(a5)
	sf	sample_zeromin(a5)
	sf	sample_endian(a5)

	lea	4(a1),a0
	bsr	get_ibmlong4
	move.l	d0,samplerate(a5)

	lea	chunk_VHDR(a5),a0
	bsr	FreeIffChunk
	move.l	#'data',d0
	move.l	(sp),d1
	bsr	GetWaveChunkHead
	beq	openerror2
	move.l	chunkread+4(a5),d0
	move.l	d0,samplefilesize(a5)
	cmp.b	#8,samplebits(a5)
	beq.s	.skip
	lsr.l	#1,d0	;16bit-Samples halbieren
.skip	move.l	d0,samplelength(a5)
	move.l	d0,samplelstart(a5)
	move.l	d0,samplelend(a5)
	bra	.noraw

.no16b
.stereo
.nopcm	lea	chunk_VHDR(a5),a0
	bsr	FreeIffChunk
	bra	.raw

;=== Creative Voice File
.voc	cmp.l	#'tive',$4(a2)
	bne	.raw
	cmp.l	#' Voi',$8(a2)
	bne	.raw
	cmp.l	#'ce F',$c(a2)
	bne	.raw
	cmp.l	#'ile'*$100+$1a,$10(a2)
	bne	.raw

	lea	$14(a2),a0
	bsr	get_ibmlong2
	move.l	(sp),d1
	moveq	#0,d2
	move.w	d0,d2
	moveq	#-1,d3
	move.l	dosbas(a5),a6
	jsr	Seek(a6)
	tst.l	d0
	bmi	openerror2

;=== Extended Type (Time Constant, Pack, Mode)
	moveq	#$08,d0
	move.l	(sp),d1
	bsr	GetVocChunk
	beq	openerror2

	move.l	(sp),d1
	lea	chunkread(a5),a0
	move.l	a0,d2
	moveq	#4,d3
	move.l	dosbas(a5),a6
	jsr	Read(a6)
	move.l	d2,a0
	tst.b	2(a0)	;Pack
	bne	.raw	;sollte 8bit sein
	tst.b	3(a0)	;Mode
	bne	.raw	;sollte Mono sein

	moveq	#0,d0
	bsr	get_ibmlong2
	move.l	#$10000,d1
	sub.l	d0,d1
	move.l	#256000000,d0
	LONGDIVU
	move.l	d0,samplerate(a5)

;=== Sound Data Type
	moveq	#$01,d0
	move.l	(sp),d1
	bsr	GetVocChunk
	beq	openerror2

	subq.l	#2,d1
	move.l	d1,samplelength(a5)
	move.l	d1,samplelstart(a5)
	move.l	d1,samplelend(a5)
	move.l	d1,samplefilesize(a5)
	move.b	#8,samplebits(a5)
	move.b	#5,sampletype(a5)
	clr.b	samplelooptype(a5)
	st	sample_zeromin(a5)
	sf	sample_endian(a5)

	move.l	(sp),d1
	moveq	#0,d2
	moveq	#0,d3
	move.l	dosbas(a5),a6
	jsr	Seek(a6)
	move.l	d0,chunkread(a5)
	bmi	openerror2

	bra	.noraw

;=== AIFF 16bit Sample
.aiff	cmp.l	#'AIFF',8(a2)
	bne	.maud

;=== Common Chunk
	move.l	#'COMM',d0
	move.l	(sp),d1
	lea	chunk_VHDR(a5),a0
	bsr	GetIffChunk
	beq	openerror2

	move.b	#3,sampletype(a5)
	move.b	#16,samplebits(a5)
	sf	sample_zeromin(a5)
	st	sample_endian(a5)

	move.l	(a0),a0
	move.w	(a0)+,d0	;numChannels
	cmp.w	#1,d0
	bne	openerror3	;darf nicht stereo sein
	move.l	(a0)+,d0	;numSampleFrames
	move.l	d0,samplelength(a5)
	add.l	d0,d0
	move.l	d0,samplefilesize(a5)
	move.w	(a0)+,d0	;sampleSize in Bits
	cmp.w	#16,d0
	bne	openerror4	;nur 16bit
	bsr	get_extended
	move.l	d0,samplerate(a5)
	lea	chunk_VHDR(a5),a0
	bsr	FreeIffChunk

;=== Instrument Chunk
	move.l	#'INST',d0
	move.l	(sp),d1
	lea	chunk_VHDR(a5),a0
	bsr	GetIffChunk
	bne.s	.inst
	clr.l	-(sp)
	moveq	#0,d0
	bra.s	.fake_inst

.inst	move.l	(a0),a0
	movem.w	8(a0),d0-d2	;playMode, beginLoop, endLoop
	movem.w	d0-d2,-(sp)
	lea	chunk_VHDR(a5),a0
	bsr	FreeIffChunk
	move.w	(sp)+,d0
.fake_inst
	move.b	d0,samplelooptype(a5)
	beq.s	.noloop


;=== Marker Chunk
	move.l	#'MARK',d0
	move.l	4(sp),d1
	lea	chunk_VHDR(a5),a0
	bsr	GetIffChunk
	beq.s	.nomarkchunk
	move.l	(a0),a0

	move.w	(a0)+,d2	;numMarkers
	beq.s	.nomarkchunk
.markerloop
	move.w	(a0)+,d1	;MarkerId
	move.l	(a0)+,d0
	cmp.w	(sp),d1
	bne.s	.next1
	move.l	d0,samplelstart(a5)	;beginloop
	bra.s	.next2
.next1	cmp.w	2(sp),d1
	bne.s	.next2
	move.l	d0,samplelend(a5)	;endloop
.next2	moveq	#0,d0
	move.b	(a0),d0
	lea	2(a0,d0.w),a0
	subq.w	#1,d2
	bne.s	.markerloop

	lea	chunk_VHDR(a5),a0
	bsr	FreeIffChunk
	addq.w	#4,sp
.goon	bra	.noraw

.noloop
	move.l	samplelength(a5),d0
	move.l	d0,samplelstart(a5)
	move.l	d0,samplelend(a5)
	addq.w	#4,sp
	bra.s	.goon

.nomarkchunk
	addq.w	#6,sp
	bra	openerror2


;=== MAUD 16bit Sample
.maud	cmp.l	#'MAUD',8(a2)
	bne	.raw

	move.l	#'MHDR',d0
	move.l	(sp),d1
	lea	chunk_VHDR(a5),a0
	bsr	GetIffChunk
	beq	openerror2

	move.b	#4,sampletype(a5)
	move.b	#16,samplebits(a5)
	clr.b	samplelooptype(a5)
	sf	sample_zeromin(a5)
	st	sample_endian(a5)

	move.l	(a0),a0
	cmp.w	#1,16(a0)
	bne	openerror2	;number of tracks
	cmp.w	#16,4(a0)	;16 bit
	bne	openerror4
	move.l	(a0),d0
	move.l	d0,samplelstart(a5)
	move.l	d0,samplelend(a5)
	move.l	d0,samplelength(a5)
	add.l	d0,d0
	move.l	d0,samplefilesize(a5)
	move.l	8(a0),samplerate(a5)	;sampling rate

	lea	chunk_VHDR(a5),a0
	bsr	FreeIffChunk

	bra	.noraw


.load_cancelled
	jmp	load_cancelledJ(a5)



GetWaveChunk	;d0.l=ChunkID, d1=FH, a0=^Adr+Len
	lea	GetWaveChunkHead(pc),a1
	bra.s	GetChunk

GetIffChunk	;d0.l=ChunkID, d1=FH, a0=^Adr+Len
	lea	GetIffChunkHead(pc),a1
;es geht weiter

GetChunk	;d0.l=ChunkID, d1=FH, a0=^Adr+Len,
		;a1=^GetChunkHead-Routine
	movem.l	d0-d1/a0,-(sp)

	jsr	(a1)
	beq.s	.error

.readit	move.l	chunkread+4(a5),d0
	moveq	#1,d1
	move.l	(a5),a6
	jsr	AllocMem(a6)
	move.l	8(sp),a0
	move.l	d0,(a0)
	beq.s	.error
	move.l	chunkread+4(a5),d3
	move.l	d3,4(a0)

	move.l	4(sp),d1
	move.l	d0,d2
	move.l	dosbas(a5),a6
	jsr	Read(a6)
	cmp.l	d3,d0
	bne.s	.error2

	movem.l	(sp)+,d0-d1/a0
	POSITIV
.error2	move.l	8(sp),a0
	bsr	FreeIffChunk
.error	movem.l	(sp)+,d0-d1/a0
	NEGATIV

GetIffChunkHead	;d0=ChunkID, d1=FH
	movem.l	d0-d1,-(sp)

	moveq	#$0c,d2
	moveq	#-1,d3
	move.l	dosbas(a5),a6
	jsr	Seek(a6)
	tst.l	d0
	bmi.s	.error

.readloop
	move.l	4(sp),d1
	lea	chunkread(a5),a0
	move.l	a0,d2
	moveq	#8,d3
	jsr	Read(a6)
	cmp.l	d3,d0
	bne.s	.error

	move.l	(sp),d0
	cmp.l	chunkread(a5),d0
	beq.s	.ok
	move.l	4(sp),d1
	move.l	chunkread+4(a5),d2
	moveq	#0,d3
	jsr	Seek(a6)
	tst.l	d0
	bmi.s	.error
	bra.s	.readloop

.ok	addq.w	#8,sp
	POSITIV
.error	addq.w	#8,sp
	NEGATIV

FreeIffChunk	;a0=^Adr+Len
	move.l	a0,-(sp)
	move.l	(a0),d0
	beq.s	.nofree
	move.l	d0,a1
	clr.l	(a0)+
	move.l	(a0),d0
	move.l	(a5),a6
	jsr	FreeMem(a6)
.nofree	move.l	(sp)+,a0
	rts

GetWaveChunkHead	;d0=ChunkID, d1=FH
	movem.l	d0-d1,-(sp)

	moveq	#$0c,d2
	moveq	#-1,d3
	move.l	dosbas(a5),a6
	jsr	Seek(a6)
	tst.l	d0
	bmi.s	.error

.readloop
	move.l	4(sp),d1
	lea	chunkread(a5),a0
	move.l	a0,d2
	moveq	#8,d3
	jsr	Read(a6)
	cmp.l	d3,d0
	bne.s	.error

	lea	chunkread+4(a5),a0
	bsr	get_ibmlong4
	move.l	d0,chunkread+4(a5)
	move.l	(sp),d0
	cmp.l	chunkread(a5),d0
	beq.s	.ok

	move.l	4(sp),d1
	move.l	chunkread+4(a5),d2
	moveq	#0,d3
	jsr	Seek(a6)
	tst.l	d0
	bmi.s	.error
	bra.s	.readloop

.ok	addq.w	#8,sp
	POSITIV
.error	addq.w	#8,sp
	NEGATIV

GetVocChunk	;d0.b=Type, d1=FH
		;zurck: d1=Lnge des Chunks
	movem.l	d0-d1,-(sp)

	lea	sample_buffer+$14(a5),a0
	bsr	get_ibmlong2
	moveq	#0,d2
	move.w	d0,d2
	moveq	#-1,d3
	move.l	dosbas(a5),a6
	jsr	Seek(a6)
	tst.l	d0
	bmi.s	.error

.loop	move.l	4(sp),d1
	lea	chunkread(a5),a0
	move.l	a0,d2
	moveq	#4,d3
	jsr	Read(a6)
	lea	chunkread(a5),a0
	bsr	get_ibmlong4
	lsr.l	#8,d0
	move.b	3(sp),d1
	cmp.b	(a0),d1
	beq.s	.ok

	move.l	d0,d2
	move.l	4(sp),d1
	moveq	#0,d3
	jsr	Seek(a6)
	tst.l	d0
	bmi.s	.error
	bra.s	.loop

.ok	move.l	d0,d1
	addq.w	#8,sp
	POSITIV
.error	addq.w	#8,sp
	NEGATIV



get_extended	;a0=^10 Bytes extended-precision real
		;zurck: d0.l=long
	move.w	(a0)+,d1
	and.w	#$7fff,d1
	sub.w	#16382+32,d1
	neg.w	d1
	move.l	(a0)+,d0
	lsr.l	d1,d0
	addq.w	#4,a0
	rts

put_extended	;a0=^10 Bytes fr extended-precision real
		;d0.l=long
	movem.l	d1-d2,-(sp)
	move.w	#$3fff,d1
	moveq	#31,d2
.loop	btst	d2,d0
	dbne	d2,.loop
	beq.s	.zero
	add.w	d2,d1
	addq.w	#1,d2
	ror.l	d2,d0
	move.w	d1,(a0)+
	move.l	d0,(a0)+
	clr.l	(a0)+
.back	movem.l	(sp)+,d1-d2
	rts
.zero	moveq	#0,d0
	move.w	d0,(a0)+
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	bra.s	.back

get_ibmlong4	;a0=^4 Bytes low-endian
		;zurck: d0=Longword
	move.l	(a0),d0
	ror.w	#8,d0
	swap	d0
	ror.w	#8,d0
	rts

get_ibmlong2	;a0=^2 Bytes low-endian
		;zurck: d0=word
	move.w	(a0),d0
	ror.w	#8,d0
	rts

put_ibmlong4	;a0=Dest, d0=longword
	ror.w	#8,d0
	swap	d0
	ror.w	#8,d0
	move.l	d0,(a0)
	rts

put_ibmlong3	;a0=Dest, d0=24bit-Zahl
	move.b	d0,(a0)
	ror.w	#8,d0
	move.b	d0,1(a0)
	swap	d0
	move.b	d0,2(a0)
	rts

put_ibmlong2	;a0=^Dest, d0=word
	ror.w	#8,d0
	move.w	d0,(a0)
	rts





rt_sdsload_struct
	dc.w	rt_sdsload_fr
	dc.w	MTsdsStruct
	dr.w	rt_sds_pat
;	dr.w	rt_sdsload_title
	dc.w	loc_sdsltitle
	dc.w	rt_sdsload_name
	dc.w	rt_sds_path
	dc.l	rt_load_flags

rt_sdssave_struct
	dc.w	rt_sdssave_fr
	dc.w	MTsdsStruct
	dr.w	rt_sds_pat
;	dr.w	rt_sdssave_title
	dc.w	loc_sdsstitle
	dc.w	rt_sdssave_name
	dc.w	rt_sds_path
	dc.l	rt_save_flags

rt_sdssave_title dc.b	'Sample Dump Destination',0
rt_sdsload_title dc.b	'Attach Sample to dump',0
rt_sds_pat	dc.b	'#?.(iff|wav|raw|dump|maud|aif|voc)',0
		even








;==============================================================
;
;  Sample Bits Gadget
;
;==============================================================

smp_bits
	bsr	GetCycleSds
	move.l	MTsdsStruct+wd_GTags(a5),a0
	move.b	d0,MTsdsGTbits+3(a0)
	beq.s	.8bit
	subq.b	#1,d0
	seq	sample_endian(a5)
	cmp.b	#16,samplebits(a5)
	beq.s	.leave
	move.l	samplelength(a5),d0
	lsr.l	#1,d0
	move.l	d0,samplelength(a5)
	moveq	#GD_smplength,d1
	bsr	SetIntegerSds
	move.l	samplelstart(a5),d0
	lsr.l	#1,d0
	move.l	d0,samplelstart(a5)
	moveq	#GD_loopstart,d1
	bsr	SetIntegerSds
	move.l	samplelend(a5),d0
	lsr.l	#1,d0
	move.l	d0,samplelend(a5)
	moveq	#GD_loopend,d1
	bsr	SetIntegerSds
	move.b	#16,samplebits(a5)
.leave	rts
.8bit	cmp.b	#8,samplebits(a5)
	beq.s	.leave
	move.l	samplelength(a5),d0
	add.l	d0,d0
	move.l	d0,samplelength(a5)
	moveq	#GD_smplength,d1
	bsr	SetIntegerSds
	move.l	samplelstart(a5),d0
	add.l	d0,d0
	move.l	d0,samplelstart(a5)
	moveq	#GD_loopstart,d1
	bsr	SetIntegerSds
	move.l	samplelend(a5),d0
	add.l	d0,d0
	move.l	d0,samplelend(a5)
	moveq	#GD_loopend,d1
	bsr	SetIntegerSds
	move.b	#8,samplebits(a5)
	rts


;==============================================================
;
;  Sample Rate Gadget
;
;==============================================================

smp_rate
	bsr	GetIntegerSds
	tst.l	d0
	ble.s	.reset
	cmp.l	#65535,d0
	bgt.s	.reset
	move.l	d0,samplerate(a5)
	rts

.reset	move.l	samplerate(a5),d0
	moveq	#GD_smprate,d1
	bra	SetIntegerSds




;==============================================================
;
;  Sample Saver Methode
;
;==============================================================

smp_saver
	bsr	GetCycleSds
	move.b	d0,samplesaver(a5)
	move.b	.saverbits(pc,d0.w),saverbits(a5)
	rts
.saverbits
	dc.b	8,8,16,8,16,16,16,8
	even


;==============================================================
;
;  Sample Length Gadget
;
;==============================================================

smp_length
	bsr	GetIntegerSds
	tst.l	d0
	ble.s	.reset
	cmp.l	samplelend(a5),d0
	bpl.s	.reset
	move.l	d0,samplelength(a5)
	rts

.reset	move.l	samplelength(a5),d0
	moveq	#GD_smplength,d1
	bra	SetIntegerSds



;==============================================================
;
;  Loop Start Gadget
;
;==============================================================

smp_loopstart
	bsr	GetIntegerSds
	tst.l	d0
	bmi.s	.reset
	cmp.l	samplelength(a5),d0
	bgt.s	.reset
	cmp.l	samplelend(a5),d0
	bgt.s	.reset
	move.l	d0,samplelstart(a5)
	rts

.reset	move.l	samplelstart(a5),d0
	moveq	#GD_loopstart,d1
	bra	SetIntegerSds


;==============================================================
;
;  Loop End Gadget
;
;==============================================================

smp_loopend
	bsr	GetIntegerSds
	tst.l	d0
	bmi.s	.reset
	cmp.l	samplelstart(a5),d0
	bmi.s	.reset
	cmp.l	samplelength(a5),d0
	bgt.s	.reset
	move.l	d0,samplelend(a5)
	rts

.reset	move.l	samplelend(a5),d0
	moveq	#GD_loopend,d1
	bra	SetIntegerSds



;==============================================================
;
;  Sample Number Gadget
;
;==============================================================

smp_number
	bsr	GetIntegerSds
	tst.l	d0
	bmi.s	.reset
	move.w	d0,samplenumber(a5)
	rts

.reset	moveq	#0,d0
	move.w	samplenumber(a5),d0
	moveq	#GD_smpnumber,d1
	bra	SetIntegerSds




;==============================================================
;
;  Handshake Gadget
;
;==============================================================

sdump_handshake
	bsr	GetCheckboxSds
	move.b	d0,dump_handshake(a5)
	rts




;==============================================================
;
;  SAMPLE DUMP
;
;==============================================================

smp_dump
	tst.b	smpbuffer(a5)
	beq.s	.buf1

;=== Variablen bereitstellen fr Buffer-Dump
	move.l	sp_frames(a5),samplelength(a5)
	move.l	sp_rate(a5),samplerate(a5)
	move.l	sp_loopstart(a5),samplelstart(a5)
	move.l	sp_loopend(a5),samplelend(a5)
	move.b	sp_looptype(a5),samplelooptype(a5)
	move.b	#16,samplebits(a5)
	st	sample_endian(a5)
	sf	sample_zeromin(a5)
	moveq	#80,d0	;siehe AllocSample
	move.l	d0,samplesize(a5)
	move.l	sp_sampledata(a5),a0	;Weil der Pointer VOR der
	suba.l	d0,a0			;Konvertierung erhht wird
	move.l	a0,sampleaddr(a5)
	move.l	sp_frames(a5),d0
	add.l	d0,d0
	move.l	d0,samplefilesize(a5)

.buf1
	tst.l	samplelength(a5)
	beq	openerror0

	jsr	stop_buttonJ(a5)
	st	dumping(a5)

	tst.b	smpbuffer(a5)		; Dump vom Samplebuffer ?
	bne.s	.buf2

	lea	rt_sdsload_struct(pc),a0
;	move.l	a0,d1
	move.l	#1005,d2
;	move.l	dosbas(a5),a6
	jsr	OpenFileFromFRJ(a5)
;	jsr	Open(a6)
	move.l	d0,d1
	beq	.openerror1
	move.l	d1,-(sp)

;=== Sample auf den BODY spulen
	lea	.bodytab(pc),a0
	moveq	#0,d0
	move.b	sampletype(a5),d0
	add.w	d0,d0
	adda.w	d0,a0
	adda.w	(a0),a0
	jsr	(a0)
	beq	.openerror2

	bsr	.AllocSample
	beq	.openerror5

.buf2

	lea	sds_header(a5),a2
	move.b	#$f0,sds_sysex(a2)
	move.b	#$7e,sds_sdsid(a2)
	move.b	sdumpchannel(a5),sds_channel(a2)
	move.b	#$01,sds_type(a2)
	move.b	samplelooptype(a5),sds_looptype(a2)
	move.b	#$f7,sds_eox(a2)
	move.b	samplebits(a5),sds_bits(a2)


;=== samplenumber berechnen
	move.w	samplenumber(a5),d0
	lea	sds_smpnumber(a2),a0
	bsr	lsb_first_2

;=== sample-period berechnen
	move.l	#1000000000,d0		; 1s in nanoseconds
	move.l	samplerate(a5),d1
	LONGDIVU
	lea	sds_rate(a2),a0
	bsr	lsb_first_3

;=== sample-length berechnen
	move.l	samplelength(a5),d0
	lea	sds_length(a2),a0
	bsr	lsb_first_3

;=== loop-start berechnen
	move.l	samplelstart(a5),d0
	lea	sds_lstart(a2),a0
	bsr	lsb_first_3

;=== loop-end berechnen
	move.l	samplelend(a5),d0
	subq.l	#1,d0
	lea	sds_lend(a2),a0
	bsr	lsb_first_3


	bsr	PreDump_Gadgets
	bsr	clear_indicator



.nack_header

;=== sds-header abschicken
	lea	sds_header(a5),a1
	moveq	#sds_sizeof,d1
	jsr	send_stream_mainJ(a5)

	tst.b	dump_handshake(a5)
	beq.s	.ack_header		; we don't want handshakes


;=== wait for handshake
	bsr	readhandshake
	bne.s	.check

;=== timed out -> switch to Open-MIDI-Loop
	sf	dump_handshake(a5)
	moveq	#0,d0
	moveq	#GD_handshake,d1
	bsr	SetCheckboxSds
	bra.s	.ack_header


.check
;=== handshake ist angekommen, jetzt berprfen
	bsr	check_handshake_rc
	bmi.s	.nack_header
	beq	.cancel

.ack_header


;=== sds-packet vorbereiten und andere sachen initialisieren
	clr.l	samplectr(a5)
	sf	aborted(a5)
	bsr	sdump_status
	lea	sds_packet(a5),a2
	move.b	#$f0,sdsp_sysex(a2)
	move.b	#$7e,sdsp_sdsid(a2)
	move.b	sdumpchannel(a5),sdsp_channel(a2)
	move.b	#$02,sdsp_type(a2)
	move.b	#$00,sdsp_count(a2)
	move.b	#$f7,sdsp_eox(a2)



;=========== Begin Of Loop
.dumploop
	tst.b	smpbuffer(a5)
	beq.s	.buf4
	move.l	samplesize(a5),d0
	add.l	d0,sampleaddr(a5)
	bra.s	.sixt
.buf4

;=== Von Disk laden
	move.l	(sp),d1
	move.l	sampleaddr(a5),d2
	move.l	samplesize(a5),d3
	move.l	dosbas(a5),a6
	jsr	Read(a6)

;=== Sample fr MIDI konvertieren
	cmp.b	#8,samplebits(a5)
	beq.s	.eight
.sixt	bsr	.conv_16bit
	bra.s	.goon
.eight	bsr	.conv_8bit
.goon	bsr	.checksum

.nak
;=== Checken, ob das Abort-Gadget gedrckt wurde
	lea	MTsdsStruct(a5),a0
	jsr	IDCMPhandlerJ(a5)
	tst.b	aborted(a5)
	bne.s	.cancel

;=== sds-packet abschicken
	lea	sds_packet(a5),a1
	moveq	#sdsp_sizeof,d1
	jsr	send_stream_mainJ(a5)


	addq.b	#1,sds_packet+sdsp_count(a5)
	and.b	#$7f,sds_packet+sdsp_count(a5)


;=== auf eine Antwort warten
	tst.b	dump_handshake(a5)
	beq.s	.ack

	bsr	readhandshake
	beq.s	.ack		; Timeout (jemand hat die MidiLoop unterbrochen)
	bsr	check_handshake_rc
	bmi.s	.nak
	beq.s	.cancelled
.ack

	move.l	samplectr(a5),d0
	move.l	samplefilesize(a5),d1
	bsr	dump_indicator

	bsr	sdump_status


;=== Packetcounter erhhen; nchstes Packet
	move.l	samplectr(a5),d0
	cmp.l	samplefilesize(a5),d0
	bcs	.dumploop
;=========== End Of Loop
.cancel
	bsr	PostDump_Gadgets

	tst.b	smpbuffer(a5)		; Dump vom Samplebuffer ?
	bne.s	.buf3

	bsr	FreeSample
	move.l	(sp)+,d1
	move.l	dosbas(a5),a6
	jsr	Close(a6)
.buf3

.out
	sf	dumping(a5)
;	jsr	SyntheOnlineJ(a5)
.rts	rts



.cancelled	; Vom Synthe gecancelled
	bsr	sdump_cancelled
	bra.s	.cancel

.openerror1
	bsr.s	.out
	bra	openerror1
.openerror2
	bsr.s	.out
	bra	openerror2
.openerror5
	bsr.s	.out
	bra	openerror5




;====================================== Zum Body seeken
.bodytab
	dr.w	.body_iff
	dr.w	.body_raw
	dr.w	.body_wav
	dr.w	.body_aiff
	dr.w	.body_maud
	dr.w	.body_voc

.body_iff
	move.l	#'BODY',d0
	move.l	4(sp),d1
	bsr	GetIffChunkHead
	beq.s	.neg
	bra.s	.pos

.body_raw
	bra.s	.pos

.body_wav
	move.l	#'data',d0
	move.l	4(sp),d1
	bsr	GetWaveChunkHead
	beq.s	.neg
	POSITIV

.body_aiff
	move.l	#'SSND',d0
	move.l	4(sp),d1
	bsr	GetIffChunkHead
	beq.s	.neg

	move.l	4(sp),d1
	moveq	#8,d2
	moveq	#0,d3
	move.l	dosbas(a5),a6
	jsr	Seek(a6)
	tst.l	d0
	beq.s	.neg
.pos	POSITIV
.neg	NEGATIV

.body_maud
	move.l	#'MDAT',d0
	move.l	4(sp),d1
	bsr	GetIffChunkHead
	beq.s	.neg
	bra.s	.pos

.body_voc
	moveq	#$01,d0
	move.l	4(sp),d1
	bsr	GetVocChunk
	beq.s	.neg

	move.l	4(sp),d1
	moveq	#2,d2
	moveq	#0,d3
	move.l	dosbas(a5),a6
	jsr	Seek(a6)
	tst.l	d0
	bmi.s	.neg
	bra.s	.pos



;=== sample nach MIDI-Konvention konvertieren (8 bit)
.conv_8bit
	bsr.s	.vorspann
	moveq	#-$80,d2
	moveq	#$7f,d3
.sampleloop8
	move.b	(a0)+,d0
	tst.b	sample_zeromin(a5)
	bne.s	.zero
	eor.b	d2,d0
.zero	move.b	d0,d1

	lsl.b	#6,d1
	and.b	d3,d1
	lsr.b	#1,d0

	move.b	d0,(a1)+
	move.b	d1,(a1)+
	dbf	d5,.sampleloop8
	rts

.vorspann
	move.l	sampleaddr(a5),a0
	lea	sds_packet+sdsp_data(a5),a1
	move.l	samplesize(a5),d5
	add.l	d5,samplectr(a5)
	move.l	samplectr(a5),d0
	sub.l	samplefilesize(a5),d0
	bls.s	.do
	sub.l	d0,d5
.do	subq.w	#1,d5
	rts

;=== sample nach MIDI-Konvention konvertieren (16 bit)
.conv_16bit
	bsr.s	.vorspann
	lsr.w	#1,d5
	move.w	#$8000,d4
	moveq	#$7f,d6
.sampleloop16
	move.w	(a0)+,d0
	tst.b	sample_endian(a5)
	bne.s	.noturn
	ror.w	#8,d0	;falls LSB vor MSB
.noturn	tst.b	sample_zeromin(a5)
	bne.s	.zero16
	eor.w	d4,d0
.zero16	move.w	d0,d1
	move.b	d0,d2

	moveq	#9,d3
	lsr.w	d3,d0
	lsr.w	#2,d1
	and.b	d6,d1
	lsl.b	#5,d2
	and.b	d6,d2

	move.b	d0,(a1)+
	move.b	d1,(a1)+
	move.b	d2,(a1)+
	dbf	d5,.sampleloop16
	rts



;=== checksum berechnen

.checksum
	lea	sds_packet+sdsp_sdsid(a5),a0
	moveq	#(sdsp_checksum-sdsp_sdsid)-1,d2
	moveq	#0,d0
.checksumloop
	move.b	(a0)+,d1
	eor.b	d1,d0
	dbf	d2,.checksumloop
	move.b	d0,sds_packet+sdsp_checksum(a5)
	rts




;=== Sample-Ausschnitt allocaten

.AllocSample
	cmp.b	#8,samplebits(a5)
	bne.s	.alloc1
	moveq	#60,d0	;8bit
	bra.s	.cont2
.alloc1	moveq	#80,d0	;16bit (40 words)
.cont2	move.l	d0,samplesize(a5)
	moveq	#1,d1
	move.l	(a5),a6
	jsr	AllocMem(a6)
	move.l	d0,sampleaddr(a5)
	beq.s	.neg2
	POSITIV
.neg2	NEGATIV





;=== Sample-Ausschnitt allocaten

FreeSample
	move.l	sampleaddr(a5),d0
	beq.s	.nofree
	move.l	d0,a1
	move.l	samplesize(a5),d0
	move.l	(a5),a6
	jsr	FreeMem(a6)
	clr.l	sampleaddr(a5)
.nofree	rts





;=== Gibt die Zahl in d0 in 3 Bytes aus

lsb_first_3	;d0.l=wert, a0=^dest
	bsr.s	lsb_first_2
	lsr.l	#7,d0
	move.b	d0,d1
	and.b	#$7f,d1
	move.b	d1,(a0)+
	rts




;=== Gibt die Zahl in d0 in 2 Bytes aus

lsb_first_2	;d0.l=wert, a0=^dest
	move.b	d0,d1
	and.b	#$7f,d1
	move.b	d1,(a0)+
	lsr.l	#7,d0
	move.b	d0,d1
	and.b	#$7f,d1
	move.b	d1,(a0)+
	rts



;=== Cancel-Requester

sdump_cancelled
	move.w	#loc_sdcancel,d0
	move.w	#loc_ohboy,d1
	bra	EZrequest




check_handshake_rc
	move.b	sds_handshake_rc(a5),d0
	sub.b	#$7e,d0
	beq.s	.nak
	subq.b	#1,d0
	beq.s	.ack
.cancel	moveq	#0,d0
	rts
.ack	moveq	#1,d0
	rts
.nak	moveq	#-1,d0
	rts






sdump_status
	move.l	sdstitle(a5),a0
	adda.w	dumpingpos(a5),a0
	move.l	samplectr(a5),d0
	moveq	#dumpingbytes-1,d1
	jsr	decout_noleadJ(a5)

	move.l	sdstitle(a5),a1
	bra	set_wdtitle_sds






;==============================================================
;
;  Gadgets disablen und Abort enablen
;
;==============================================================

PreDump_Gadgets
	moveq	#GD_smpdump,d1
	bsr	DisableGadSds
	moveq	#GD_dumpreq,d1
	bsr	DisableGadSds
	moveq	#GD_smpsaver,d1
	bsr	DisableGadSds
	moveq	#GD_handshake,d1
	bsr	DisableGadSds
	moveq	#GD_smpnumber,d1
	bsr	DisableGadSds
	moveq	#GD_sysexid,d1
	bsr	DisableGadSds

	moveq	#GD_smpbits,d1
	bsr	GetAbleSds
	move.b	d0,temp_smpbits(a5)
	bne.s	.disabled1
	moveq	#GD_smpbits,d1
	bsr	DisableGadSds
.disabled1
	moveq	#GD_smpbuffer,d1
	bsr	GetAbleSds
	move.b	d0,temp_smpbuffer(a5)
	bne.s	.disabled2
	moveq	#GD_smpbuffer,d1
	bsr	DisableGadSds
.disabled2

	tst.b	smpbuffer(a5)
	bne.s	.already_disabled

	moveq	#GD_getsmp,d1
	bsr	DisableGetfileSds
;	moveq	#GD_smpfile,d1
;	bsr	DisableGadSds
	moveq	#GD_smprate,d1
	bsr	DisableGadSds
	moveq	#GD_smplength,d1
	bsr	DisableGadSds
	moveq	#GD_loopstart,d1
	bsr	DisableGadSds
	moveq	#GD_loopend,d1
	bsr	DisableGadSds

.already_disabled

	moveq	#GD_smpabort,d1
	bsr	EnableGadSds
	rts


;==============================================================
;
;  Gadgets enablen und Abort disablen
;
;==============================================================

PostDump_Gadgets
	moveq	#GD_smpdump,d1
	bsr	EnableGadSds
	moveq	#GD_dumpreq,d1
	bsr	EnableGadSds
	moveq	#GD_smpsaver,d1
	bsr	EnableGadSds
	moveq	#GD_handshake,d1
	bsr	EnableGadSds
	moveq	#GD_smpnumber,d1
	bsr	EnableGadSds
	moveq	#GD_sysexid,d1
	bsr	EnableGadSds

;=== Falls smpbits-Gadget vorher enabled war -> jetzt wieder enablen!
	tst.b	temp_smpbits(a5)
	bne.s	.dis1
	moveq	#GD_smpbits,d1
	bsr	EnableGadSds
.dis1
;=== Falls smpbuffer-Gadget vorher enabled war -> jetzt wieder enablen!
	tst.b	temp_smpbuffer(a5)
	bne.s	.dis2
	moveq	#GD_smpbuffer,d1
	bsr	EnableGadSds
.dis2

	tst.b	smpbuffer(a5)
	bne.s	.not_enable

	moveq	#GD_getsmp,d1
	bsr	EnableGetfileSds
;	moveq	#GD_smpfile,d1
;	bsr	EnableGadSds
	moveq	#GD_smprate,d1
	bsr	EnableGadSds
	moveq	#GD_smplength,d1
	bsr	EnableGadSds
	moveq	#GD_loopstart,d1
	bsr	EnableGadSds
	moveq	#GD_loopend,d1
	bsr	EnableGadSds

.not_enable

	moveq	#GD_smpabort,d1
	bsr	DisableGadSds
	rts


;==============================================================
;
;  Fehlermeldungen
;
;==============================================================

;=== out of memory (dump)
openerror5
	bsr	nomemory
	bra.s	opencont1

;=== File ist nicht 16bit
openerror4
	move.w	#loc_not16bit,d0
	move.w	#loc_letmesee,d1
	bra.s	opencont

;=== File ist sterero
openerror3
	move.w	#loc_onlymono,d0
	move.w	#loc_alright,d1
	bra.s	opencont

;=== load error: chunk missing
openerror2
	move.w	#loc_loaderror,d0
	move.w	#loc_letmesee,d1
opencont
	bsr	EZrequest
opencont1
	move.l	(sp)+,d1
	move.l	dosbas(a5),a6
	jsr	Close(a6)
	bra.s	opencont2

;=== file not found
openerror1
	moveq	#loc_filenfound,d0
	moveq	#loc_niceday,d1
	bsr	EZrequest
opencont2
	rts
;	moveq	#GD_smpfile,d1
;	bra	ActivateGadSds




not16bit_body	dc.b	'Sample is not 16 Bit.',0
onlymono_body	dc.b	'Only Mono Samples are supported.',10
		dc.b	'Please tell the author to implement.',0
loaderr_body	dc.b	'Load error or missing chunk',0

alright_gadfmt	dc.b	'_Alright',0
letmesee_gadfmt	dc.b	'_Let me see',0

sdcancel_body	dc.b	'Sample Dump has been cancelled.',0
ohboy_gadfmt	dc.b	'_Oh boy',0

		even



;=== kein sample vorhanden
openerror0
	bra	nosample







;==============================================================
;
;  Read Handshake (=ACK/NACK/CANCEL)
;
;==============================================================

readhandshake

;=== returns: pos = Handshake arrived, packet-type is in handshake-variable
;===          neg = Timeout


.waitloop
	bsr	BeginTimer2secs

.readyloop
;=== Auf eins der beiden SigBits warten
	bsr	WaitTimerAndSerial
	beq.s	.timerbit

.getmidiloop
	jsr	get_next_midimsgJ(a5)
	beq.s	.readyloop

	cmp.b	#$f0,(a2)
	bne.s	.nosysex

	cmp.b	#$7e,sdsh_sdsid(a2)
	bne.s	.reloop

	move.b	sdumpchannel(a5),d0
	cmp.b	sdsh_channel(a2),d0
	bne.s	.reloop

	cmp.b	#$f7,sdsh_eox(a2)
	bne.s	.reloop
	bra.s	.outloop

.reloop	jsr	free_last_midimsgJ(a5)
	bra.s	.getmidiloop
.outloop

	move.b	sdsh_type(a2),sds_handshake_rc(a5)
	jsr	free_last_midimsgJ(a5)
	jsr	AbortTimerJ(a5)

	cmp.b	#$7c,sds_handshake_rc(a5)	; WAIT-Packet
	beq.s	.waitloop

	POSITIV

.timerbit
	NEGATIV


.nosysex
	jsr	MakeONline_routineJ(a5)
	bra.s	.reloop






;==============================================================
;
;  Read Headerpacket (oder auch nicht, falls z.B. kein Sample vorhanden)
;
;==============================================================

readheader	; returns: pos/neg, a2 = ^header-sysexmsg, if received

	bsr	BeginTimer2secs


.readyloop

;=== Header lesen (Background)
	bsr	WaitTimerAndSerial
	beq	.timerbit

.getmidiloop
	jsr	get_next_midimsgJ(a5)
	beq.s	.readyloop

	cmp.b	#$f0,(a2)
	bne.s	.reloop

	cmp.b	#$7e,sds_sdsid(a2)
	bne.s	.reloop

	cmp.b	#$01,sds_type(a2)
	bne.s	.reloop

	move.b	sdumpchannel(a5),d0
	cmp.b	sds_channel(a2),d0
	bne.s	.reloop

	cmp.b	#$f7,sds_eox(a2)
	bne.s	.reloop
	bra.s	.outloop

.reloop	jsr	free_last_midimsgJ(a5)
	bra.s	.getmidiloop
.outloop

;=== bits checken (im Moment nur 16bit mglich!)
	move.b	sds_bits(a2),synthe_bits(a5)
	cmp.b	#$10,synthe_bits(a5)
	bne.s	.cancelheader

	jsr	AbortTimerJ(a5)
	POSITIV



;=== Header canceln und so tun, als ob kein Header angekommen sei
.cancelheader
	jsr	free_last_midimsgJ(a5)
	bsr.s	send_cancel_handshake


;=== Timeout

.timerbit
	NEGATIV





send_cancel_handshake
	moveq	#$7d,d0
	moveq	#0,d1
	bra.s	send_handshake

send_ack_handshake	; d1=packetnumber
	moveq	#$7f,d0
	bra.s	send_handshake

send_nak_handshake	; d1=packetnumber
	moveq	#$7e,d0

send_handshake	; d0 = $7c-$7f (handshake), d1 = packet-number
	lea	sds_handshake(a5),a1
	move.b	#$f0,(a1)
	move.b	#$7e,sdsh_sdsid(a1)
	move.b	sdumpchannel(a5),sdsh_channel(a1)
	move.b	d0,sdsh_type(a1)
	move.b	d1,sdsh_packet(a1)
	move.b	#$f7,sdsh_eox(a1)
	moveq	#sdsh_sizeof,d1
	jmp	send_stream_mainJ(a5)






;==============================================================
;
;  Read Data-Packet or Handshake-Packet
;
;==============================================================

readdatapacket	; a2 = ^sysexmsg, if success

.waitloop
	bsr	BeginTimer2secs


.readyloop

;=== Header lesen (Background)
	bsr	WaitTimerAndSerial
	beq	.timerbit

.getmidiloop
	jsr	get_next_midimsgJ(a5)
	beq.s	.readyloop

	cmp.b	#$f0,(a2)
	bne.s	.nosysex

	cmp.b	#$7e,sdsp_sdsid(a2)
	bne.s	.reloop

	move.b	sdumpchannel(a5),d0
	cmp.b	sdsp_channel(a2),d0
	bne.s	.reloop

	cmp.b	#$02,sdsp_type(a2)
	beq.s	.packet_arrived

	move.b	sdsp_type(a2),d0
	sub.b	#$7c,d0			; WAIT
	beq.s	.wait
	subq.b	#1,d0			; CANCEL
	beq.s	.handshake
	subq.b	#1,d0			; NACK
	beq.s	.handshake
	subq.b	#1,d0			; ACK
	beq.s	.handshake

.reloop	jsr	free_last_midimsgJ(a5)
	bra.s	.getmidiloop


;=== data packet arrived
.packet_arrived
	cmp.b	#$f7,sdsp_eox(a2)
	bne.s	.reloop
	sf	sds_handshake_rc(a5)

.done	jsr	AbortTimerJ(a5)
	POSITIV


;=== handshake packet arrived (only WAIT or CANCEL valid)
.handshake
	move.b	sdsh_type(a2),sds_handshake_rc(a5)
	jsr	free_last_midimsgJ(a5)
	bra.s	.done

.wait	jsr	free_last_midimsgJ(a5)
	jsr	AbortTimerJ(a5)
	bra.s	.waitloop


.timerbit
	NEGATIV


.nosysex
	jsr	MakeONline_routineJ(a5)
	bra.s	.reloop






;==============================================================
;
;  Progress Indicator aktualisieren
;
;==============================================================

dump_indicator	;d0=Anteil, d1=Voller Pegel
	cmp.l	d1,d0
	bcs.s	.under
	move.l	#288,d0
	bra.s	.cont
.under	move.l	d0,d2	;=mulu #256+32,d0
	lsl.l	#8,d0	;
	lsl.l	#5,d2	;
	add.l	d2,d0	;
	LONGDIVU		;samplefilesize noch in d1

.cont	move.w	d0,d2
	sub.w	indictr(a5),d0
	beq.s	.out
	move.w	d0,d4

	lea	MTsdsBevels(pc),a0
	move.w	(a0),d0
	addq.w	#2,d0
	add.w	indictr(a5),d0
	move.w	d2,indictr(a5)
	add.w	MTsdsStruct+wd_LeftTop+2(a5),d0

	move.w	2(a0),d1
	add.w	MTsdsStruct+wd_LeftTop+6(a5),d1
	move.w	d1,d3
	addq.w	#1,d1
	move.w	d4,d2
	add.w	d0,d2
	subq.w	#1,d2
	add.w	6(a0),d3
	subq.w	#2,d3
	movem.w	d0-d3,-(sp)

	move.l	gfxbas(a5),a6
	move.l	MTsdsStruct+wd_Wnd(a5),a1
	move.l	$32(a1),a1
	move.l	a1,-(sp)
	moveq	#3,d0
	jsr	SetAPen(a6)

	cmp.w	#1,d4
	beq.s	.line
;rechteck
	move.l	(sp)+,a1
	movem.w	(sp)+,d0-d3
	jsr	RectFill(a6)
	bra.s	.out
.line
	move.l	(sp),a1
	movem.w	4(sp),d0-d1
	jsr	Move(a6)
	move.l	(sp)+,a1
	movem.w	4(sp),d0-d1
	jsr	Draw(a6)
	addq.w	#8,sp
.out	rts


;==============================================================
;
;  Progress Indicator lschen
;
;==============================================================

clear_indicator
	clr.w	indictr(a5)
	move.l	MTsdsStruct+wd_Wnd(a5),a1
	move.l	$32(a1),a1
	lea	MTsdsBevels(pc),a0
	move.w	(a0)+,d0
	move.w	(a0)+,d1
	add.w	MTsdsStruct+wd_LeftTop+2(a5),d0
	add.w	MTsdsStruct+wd_LeftTop+6(a5),d1
	move.w	d0,d2
	addq.w	#2,d0
	add.w	(a0)+,d2
	subq.w	#3,d2
	move.w	d1,d3
	addq.w	#1,d1
	add.w	(a0)+,d3
	subq.w	#2,d3
	move.l	gfxbas(a5),a6
	jmp	EraseRect(a6)


;==============================================================
;
;  DUMP REQUEST
;
;==============================================================

dump_request
	lea	rt_sdssave_struct(pc),a4
	bsr	FileRequester
	beq	.fr_cancel

	lea	rt_sdssave_name(a5),a0
	move.l	a0,d1
	moveq	#-2,d2
	move.l	dosbas(a5),a6
	jsr	Lock(a6)
	move.l	d0,d1
	beq.s	.open
	jsr	UnLock(a6)
	move.w	#loc_fileexists,d0
	move.w	#loc_goaheaddont,d1
	bsr	EZrequest
	tst.l	d0
	beq	.fr_cancel

.open
	jsr	stop_routineJ(a5)
;	jsr	SyntheOfflineJ(a5)
	st	dumping(a5)

	lea	sds_request(a5),a2
	move.b	#$f0,(a2)
	move.b	#$7e,sdsr_sdsid(a2)
	move.b	sdumpchannel(a5),sdsr_channel(a2)
	move.b	#$03,sdsr_type(a2)
	move.b	#$f7,sdsr_eox(a2)
;=== samplenumber berechnen
	move.w	samplenumber(a5),d0
	beq.s	.nosub
	subq.w	#1,d0
.nosub	lea	sdsr_smpnumber(a2),a0
	bsr	lsb_first_2


;=== Request abschicken
	bsr	put_sysex_msg_a2



;=== wait for Header
	bsr	readheader
	beq	.noheader			; timeout


	bsr	.AllocSample
	bne.s	.alloc_ok

;=== CANCEL schicken
	jsr	free_last_midimsgJ(a5)
	bsr	send_cancel_handshake
	bra	.nomem


.alloc_ok
;	lea	rt_sdssave_name(a5),a0
	lea	rt_sdssave_struct(pc),a0
;	move.l	a0,d1
	move.l	#1006,d2
;	move.l	dosbas(a5),a6
	jsr	OpenFileFromFRJ(a5)
;	jsr	Open(a6)
	move.l	d0,d1
	bne.s	.open_ok
	jsr	free_last_midimsgJ(a5)
	bsr	send_cancel_handshake
	bra	.openerror
.open_ok
	move.l	d1,-(sp)

	clr.l	samplectr(a5)
	sf	aborted(a5)
	bsr	sdump_status
	clr.b	packetcounter(a5)
	bsr	clear_indicator

;=== samplerate holen
	lea	sds_rate(a2),a0
	bsr	get_lsb_first_3
	move.l	d0,d1
	move.l	#1000000000,d0		; 1s in nanosekunden
	LONGDIVU
	move.l	d0,synthe_rate(a5)

;=== samplelength holen
	lea	sds_length(a2),a0
	bsr	get_lsb_first_3
	move.l	d0,synthe_length(a5)

;=== sample-lstart holen
	lea	sds_lstart(a2),a0
	bsr	get_lsb_first_3
	move.l	d0,synthe_lstart(a5)

;=== sample-lend holen
	lea	sds_lend(a2),a0
	bsr	get_lsb_first_3
	move.l	d0,synthe_lend(a5)

;=== free header
	jsr	free_last_midimsgJ(a5)


;=== send ACK
	tst.b	dump_handshake(a5)
	beq.s	.noack
	moveq	#0,d1
	bsr	send_ack_handshake
.noack


;=== Header schonmal abspeichern
	lea	savertab(pc),a0
	moveq	#0,d0
	move.b	samplesaver(a5),d0
	add.w	d0,d0
	adda.w	d0,a0
	adda.w	(a0),a0

	;d0.l=synthe_length
	;d1.l=samplerate
	;d2.l=synthe_lstart
	;d3.l=synthe_lend
	;d4.b=looptype
	;d5.b=saverbits
	;a1=^Filename
	move.l	synthe_length(a5),d0
	move.l	synthe_rate(a5),d1
	move.l	synthe_lstart(a5),d2
	move.l	synthe_lend(a5),d3
	move.b	samplelooptype(a5),d4
	move.b	saverbits(a5),d5
	lea	rt_sdssave_name(a5),a1

	jsr	(a0)
	move.l	d0,d3
	beq.s	.nowrite
	move.l	(sp),d1
	move.l	a0,d2
	move.l	dosbas(a5),a6
	jsr	Write(a6)
.nowrite

;=== Gadgets disablen
	bsr	PreDump_Gadgets



;=========== Begin Of Loop
.dumploop
	bsr	readdatapacket
	beq	.cancelled			; timeout


;=== Das Type-field vom Packet ist $02.
;=== Bei einem Cancel(-Handshake)-Packet steht dort $7d.
	move.b	sds_handshake_rc(a5),d0
	bne	.cancelled			; if any handshake packet rec'd


.is_packet
;=== Packet Verarbeitung
	tst.b	dump_handshake(a5)
	beq	.goon

; a2 points to midimsg
	bsr	.check_checksum
	bne.s	.ack

;=== reject packet, send NAK
	jsr	free_last_midimsgJ(a5)

	move.b	packetcounter(a5),d1
	bsr	send_nak_handshake
	bra.s	.dumploop


.ack
;=== ACK schicken
	move.b	packetcounter(a5),d1
	bsr	send_ack_handshake

	addq.b	#1,packetcounter(a5)
	and.b	#$7f,packetcounter(a5)


.goon
;=== Packet konvertieren und abspeichern
	lea	sdsp_data(a2),a3
	moveq	#0,d0
	move.b	samplesaver(a5),d0
	lea	.datasavertab(pc),a0
	add.w	d0,d0
	adda.w	d0,a0
	adda.w	(a0),a0
	jsr	(a0)	; gibt d3 fr Write() zurck
	move.l	(sp),d1
	move.l	sampleaddr(a5),d2
	move.l	dosbas(a5),a6
	jsr	Write(a6)

;=== free midipacket
	jsr	free_last_midimsgJ(a5)


;=== Checken, ob das Abort-Gadget gedrckt wurde
	jsr	IDCMPhandlerJ(a5)
	tst.b	aborted(a5)
	bne.s	.cancel

	move.l	samplectr(a5),d0
	move.l	synthe_length(a5),d1
	bsr	dump_indicator

	bsr	sdump_status


;=== nchstes Packet
	move.l	samplectr(a5),d0
	cmp.l	synthe_length(a5),d0
	bcs	.dumploop
;=========== End Of Loop

.cancel
;=== Bei VOC-Samples ein $00-Byte anhngen (Terminatorbyte)
	cmp.b	#7,samplesaver(a5)
	bne.s	.novoc
	move.l	(sp),d1
	move.l	dosbas(a5),a6
	jsr	Flush(a6)
	move.l	(sp),d1
	moveq	#$00,d2
	jsr	FPutC(a6)
.novoc

	bsr	PostDump_Gadgets

	move.l	(sp)+,d1
	move.l	dosbas(a5),a6
	jsr	Close(a6)

.openerror
	bsr	FreeSample

.out	sf	dumping(a5)
;	jsr	SyntheOnlineJ(a5)
.rts	rts


.nomem
	jsr	nomemoryJ(a5)
.fr_cancel
	bra.s	.out


.noheader
	move.w	#loc_wrongsample,d0
	move.w	#loc_whatthehell,d1
	bsr	EZrequest
	moveq	#GD_smpnumber,d1
	bsr	ActivateGadSds
	bra.s	.out

.cancelled	; Vom Synthe gecancelled
	bsr	sdump_cancelled
	bra.s	.cancel




;=== checksum kontrollieren
.check_checksum	; a2=^midimsg
	lea	sdsp_sdsid(a2),a0
	moveq	#(sdsp_checksum-sdsp_sdsid)-1,d2
	moveq	#0,d0
.checksumloop
	move.b	(a0)+,d1
	eor.b	d1,d0
	dbf	d2,.checksumloop
	cmp.b	sdsp_checksum(a2),d0
	bne.s	.neg
.pos	POSITIV
.neg	NEGATIV




; Sample-Ausschnitt allocaten
.AllocSample
	cmp.b	#16,saverbits(a5)
	beq.s	.to16
	moveq	#40,d0			; 16bit -> 8bit
	bra.s	.cont2
.to16	moveq	#80,d0			; 16bit -> 16bit
.cont2
	move.l	d0,samplesize(a5)
	moveq	#1,d1
	move.l	(a5),a6
	jsr	AllocMem(a6)
	move.l	d0,sampleaddr(a5)
	beq.s	.neg
	bra.s	.pos


.datasavertab	dr.w	.datasaver_iff
		dr.w	.datasaver_raw8
		dr.w	.datasaver_raw16
		dr.w	.datasaver_wav8
		dr.w	.datasaver_wav16
		dr.w	.datasaver_aiff
		dr.w	.datasaver_maud
		dr.w	.datasaver_voc

.datasaver_iff
.datasaver_raw8
	lea	.do_iff8(pc),a2
	bra.s	.vorspann
.do_iff8
	subq.w	#1,d5
	moveq	#$40,d2
.conv16to8	;16bit -> 8bit
	move.b	(a0)+,d0
	eor.b	d2,d0
	add.b	d0,d0
	move.b	(a0)+,d1
	lsr.b	#6,d1
	add.b	d1,d0
	addq.w	#1,a0
	move.b	d0,(a1)+
	dbf	d5,.conv16to8
	rts

.datasaver_raw16
.datasaver_aiff
.datasaver_maud
	lea	.do_raw16(pc),a2
	bsr.s	.vorspann
	add.l	d3,d3
	rts
.do_raw16
	subq.w	#1,d5
	move.w	#$8000,d2
.conv16to16
	move.b	(a0)+,d0
	lsl.w	#7,d0
	add.b	(a0)+,d0
	lsl.w	#2,d0
	move.b	(a0)+,d1
	lsr.b	#5,d1
	add.b	d1,d0
	eor.w	d2,d0
	move.w	d0,(a1)+
	dbf	d5,.conv16to16
	rts

.vorspann	; a2 = ^Routine, a3 = ^mididata

	move.l	a3,a0
	move.l	sampleaddr(a5),a1
	moveq	#40,d5		;source = 16bit
	add.l	d5,samplectr(a5)
	move.l	samplectr(a5),d0
	sub.l	synthe_length(a5),d0
	bls.s	.do
	sub.l	d0,d5
.do	move.l	d5,-(sp)
	jsr	(a2)
	move.l	(sp)+,d3
	rts


.datasaver_wav8
.datasaver_voc
	lea	.do_wav8(pc),a2
	bra.s	.vorspann
.do_wav8
	subq.w	#1,d5
.conv16to8wav	;16bit -> 8bit
	move.b	(a0)+,d0
	add.b	d0,d0
	move.b	(a0)+,d1
	lsr.b	#6,d1
	add.b	d1,d0
	addq.w	#1,a0
	move.b	d0,(a1)+
	dbf	d5,.conv16to8wav
	rts

.datasaver_wav16
	lea	.do_wav16(pc),a2
	bsr.s	.vorspann
	add.l	d3,d3
	rts
.do_wav16
	subq.w	#1,d5
	move.w	#$8000,d2
.conv16to16wav
	move.b	(a0)+,d0
	lsl.w	#7,d0
	add.b	(a0)+,d0
	lsl.w	#2,d0
	move.b	(a0)+,d1
	lsr.b	#5,d1
	add.b	d1,d0
	eor.w	d2,d0
	ror.w	#8,d0
	move.w	d0,(a1)+
	dbf	d5,.conv16to16wav
	rts


;================================== Header absaven

savertab	dr.w	.saver_iff
		dr.w	saver_raw8
		dr.w	saver_raw16
		dr.w	.saver_wav8
		dr.w	.saver_wav16
		dr.w	saver_aiff
		dr.w	saver_maud
		dr.w	.saver_voc

.saver_iff
	; d0.l=synthe_length
	; d1.l=samplerate
	; d2.l=synthe_lstart
	; d3.l=synthe_lend
	; d4.b=looptype
	; d5.b=saverbits
	; a1=^Filename

	lea	.iff_header(pc),a0
	moveq	#.iff_sizeof-.iff_form-4,d4
	move.l	d0,.iff_body(a0)
	add.l	d0,d4
	move.l	d4,.iff_form(a0)
	move.l	d2,.iff_oneshot(a0)
	sub.l	d2,d3
	move.l	d3,.iff_repeat(a0)
	beq.s	.oneshot
	moveq	#32,d0
	bra.s	.set
.oneshot
	moveq	#0,d0
.set	move.l	d0,.iff_cycles(a0)
	move.w	d1,.iff_rate(a0)

	lea	.iff_name(a0),a2
	moveq	#19,d0
.copy	move.b	(a1)+,(a2)+
	dbeq	d0,.copy
	bne.s	.cont
	subq.w	#1,d0
	bcs.s	.cont
	moveq	#0,d1
.fill	move.b	d1,(a2)+
	dbf	d0,.fill
.cont	moveq	#.iff_sizeof,d0
	rts

.iff_header
	dc.b	'FORM'
.iff_form = *-.iff_header
	dc.l	0
	dc.b	'8SVXVHDR'
	dc.l	$14
.iff_oneshot = *-.iff_header
	dc.l	0
.iff_repeat = *-.iff_header
	dc.l	0
.iff_cycles = *-.iff_header
	dc.l	0
.iff_rate = *-.iff_header
	dc.w	0
	dc.b	1,0	; octaves, compression (none)
	dc.w	1,0	; 1.0 % = full volume
	dc.b	'NAME'
	dc.l	20
.iff_name = *-.iff_header
	dc.l	0,0,0,0,0
	dc.b	'ANNO'
	dc.l	.iff_anno_len
.iff_anno
	dc.b	'MidiTracker V'
	VERSION_STRING
	dc.b	0
	even
.iff_anno_len = *-.iff_anno
	dc.b	'BODY'
.iff_body = *-.iff_header
	dc.l	0
.iff_sizeof = *-.iff_header

.saver_wav8
.saver_wav16
	;d0.l=synthe_length
	;d1.l=samplerate
	;d2.l=synthe_lstart
	;d3.l=synthe_lend
	;d4.b=looptype
	;d5.b=saverbits
	;a1=^Filename

	lea	.wav_header(pc),a1
	moveq	#.wav_sizeof-.wav_riff-4,d4
	exg	d0,d4
	add.l	d4,d0
	lea	.wav_riff(a1),a0
	bsr	put_ibmlong4
	move.l	d1,d0
	lea	.wav_rate1(a1),a0
	bsr	put_ibmlong4
	move.l	.wav_rate1(a1),.wav_rate2(a1)
	move.l	d4,d0
	moveq	#0,d1
	move.b	d5,d1
	lsr.w	#4,d1
	lsl.l	d1,d0
	lea	.wav_data(a1),a0
	bsr	put_ibmlong4
	moveq	#0,d0
	move.b	d5,d0
	lea	.wav_bits(a1),a0
	bsr	put_ibmlong2
	moveq	#0,d0
	move.b	d5,d0
	addq.w	#7,d0
	lsr.w	#3,d0
	lea	.wav_dbytes(a1),a0
	bsr	put_ibmlong2
	move.l	a1,a0
	moveq	#.wav_sizeof,d0
	rts

.wav_header
	dc.b	'RIFF'
.wav_riff = *-.wav_header
	dc.l	0
	dc.b	'WAVEfmt '
	dc.l	$10000000
	dc.l	$01000100
.wav_rate1 = *-.wav_header
	dc.l	0
.wav_rate2 = *-.wav_header
	dc.l	0
.wav_dbytes = *-.wav_header
	dc.w	0
.wav_bits = *-.wav_header
	dc.w	0
	dc.b	'data'
.wav_data = *-.wav_header
	dc.l	0
.wav_sizeof = *-.wav_header


.saver_voc
	;d0.l=synthe_length
	;d1.l=samplerate
	;d2.l=synthe_lstart
	;d3.l=synthe_lend
	;d4.b=looptype
	;d5.b=saverbits
	;a1=^Filename

	lea	.voc_header(pc),a1
	movem.l	d0-d1,-(sp)
; sample rate byte
	move.l	d1,d0
	move.l	#1000000,d1
	exg	d0,d1
	LONGDIVU
	sub.w	#256,d0
	neg.w	d0
	move.b	d0,.voc_sr(a1)
; time constant
	move.l	4(sp),d1
	move.l	#256000000,d0
	LONGDIVU
	sub.l	#65536,d0
	neg.l	d0
	lea	.voc_tc(a1),a0
	bsr	put_ibmlong2
; length
	move.l	(sp),d0
	addq.l	#2,d0
	lea	.voc_datalen(a1),a0
	bsr	put_ibmlong3
	addq.w	#8,sp
	moveq	#.voc_sizeof,d0
	move.l	a1,a0
	rts

.voc_header
	dc.b	'Creative Voice File',$1a
	dc.w	$1A00,$0001,$3311	; Alternativ: $0a01,$2911
	dc.b	$08,$04,$00,$00
.voc_tc = *-.voc_header
	dc.w	0,0
	dc.b	$01
.voc_datalen = *-.voc_header
	dc.b	0,0,0
.voc_sr = *-.voc_header
	dc.b	0,0
.voc_sizeof = *-.voc_header


saver_raw8
saver_raw16
	moveq	#0,d0
	rts

saver_aiff
	; d0.l=synthe_length
	; d1.l=synthe_rate
	; d2.l=synthe_lstart
	; d3.l=synthe_lend
	; d4.b=looptype
	; d5.b=saverbits
	; a1=^Filename

	lea	.aiff_header(pc),a2
	move.l	d0,.aiff_frames(a2)
	add.l	d0,d0
	move.l	d0,.aiff_body(a2)
	addq.l	#8,.aiff_body(a2)
	add.l	#.aiff_sizeof-.aiff_form-4,d0
	move.l	d0,.aiff_form(a2)
	move.l	d2,.aiff_lstart(a2)
	move.l	d3,.aiff_lend(a2)
	move.l	d1,d0
	lea	.aiff_rate(a2),a0
	bsr	put_extended
	moveq	#0,d0
	move.b	d4,d0
	move.w	d0,.aiff_looptype(a2)

	lea	.aiff_name(a2),a0
	moveq	#19,d0
.copy2	move.b	(a1)+,(a0)+
	dbeq	d0,.copy2
	bne.s	.cont3
	subq.w	#1,d0
	bcs.s	.cont3
	moveq	#0,d1
.fill2	move.b	d1,(a0)+
	dbf	d0,.fill2
.cont3	move.l	#.aiff_sizeof,d0
	move.l	a2,a0
	rts

.aiff_header
	dc.b	'FORM'
.aiff_form = *-.aiff_header
	dc.l	0
	dc.b	'AIFFCOMM'
	dc.l	18
	dc.w	1	;numChannels
.aiff_frames = *-.aiff_header
	dc.l	0
	dc.w	16	;sampleSize
.aiff_rate = *-.aiff_header
	dcb.w	5	;sampleRate
	dc.b	'MARK'
	dc.l	$22
	dc.w	2	;2 Markers
	dc.w	1	;Marker 1 Id
.aiff_lstart = *-.aiff_header
	dc.l	0	;Marker 1
	dc.b	8,'beg loop',0
	dc.w	2	;Marker 2 Id
.aiff_lend = *-.aiff_header
	dc.l	0	;Marker 2
	dc.b	8,'end loop',0
	dc.b	'INST'
	dc.l	20
	dc.b	60,0,1,127,1,127
	dc.w	0
.aiff_looptype = *-.aiff_header
	dc.w	0	;looptype
	dc.w	1,2	;Markers
	dc.w	0,0,0	;releaseloop
	dc.b	'NAME'
	dc.l	20
.aiff_name = *-.aiff_header
	dcb.b	20
	dc.b	'SSND'
.aiff_body = *-.aiff_header
	dc.l	0
	dc.l	0,0	;offset, blocksize
.aiff_sizeof = *-.aiff_header

saver_maud
	;d0.l=synthe_length
	;d1.l=samplerate
	;d2.l=synthe_lstart
	;d3.l=synthe_lend
	;d4.b=looptype
	;d5.b=saverbits
	;a1=^Filename

	lea	.maud_header(pc),a0
	moveq	#.maud_sizeof-.maud_form-4,d4
	move.l	d0,.maud_length(a0)
	add.l	d0,d0
	move.l	d0,.maud_mdat(a0)
	add.l	d4,d0
	move.l	d0,.maud_form(a0)
	move.w	d1,.maud_rate(a0)

	moveq	#.maud_sizeof,d0
	rts

.maud_header
	dc.b	'FORM'
.maud_form = *-.maud_header
	dc.l	0
	dc.b	'MAUDMHDR'
	dc.l	$20
.maud_length = *-.maud_header
	dc.l	0
	dc.w	16,16,0
.maud_rate = *-.maud_header
	dc.w	0
	dc.w	1,0,1,0
	dc.l	0,0,0
	dc.b	'ANNO'
	dc.l	.maud_anno_len
.maud_anno
	dc.b	'MidiTracker V'
	VERSION_STRING
	dc.b	0
	even
.maud_anno_len = *-.maud_anno
	dc.b	'MDAT'
.maud_mdat = *-.maud_header
	dc.l	0
.maud_sizeof = *-.maud_header



get_lsb_first_2	;a0=^2bytes
		;zurck: d0.l=Wert
	moveq	#0,d0
	moveq	#0,d1
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	lsl.w	#7,d1
	add.w	d1,d0
	rts

get_lsb_first_3	;a0=^3bytes
		;zurck: d0.l=Wert
	bsr.s	get_lsb_first_2
	moveq	#0,d1
	move.b	(a0)+,d1
	swap	d1
	lsr.l	#2,d1
	add.l	d1,d0
	rts




wrongsmp_body	dc.b	'There is no sample on this number.',10
		dc.b	'(MIDI not responding)',0
whatthehell	dc.b	'_What the hell',0
		even







smp_abort
	st	aborted(a5)
	rts


smp_buffer
	not.b	smpbuffer(a5)
	beq.s	.dumpfromfile

;=== Dump from Sample Buffer
;	moveq	#GD_smpfile,d1
;	bsr	DisableGadSds
	moveq	#GD_getsmp,d1
	bsr	DisableGetfileSds
	moveq	#GD_smplength,d1
	bsr	DisableGadSds
	moveq	#GD_smprate,d1
	bsr	DisableGadSds
	moveq	#GD_loopstart,d1
	bsr	DisableGadSds
	moveq	#GD_loopend,d1
	bsr	DisableGadSds

	moveq	#GD_smpbits,d1
	bsr	DisableGadSds
	rts

;=== Dump from Disk File
.dumpfromfile
;	moveq	#GD_smpfile,d1
;	bsr	EnableGadSds
	moveq	#GD_getsmp,d1
	bsr	EnableGetfileSds
	moveq	#GD_smplength,d1
	bsr	EnableGadSds
	moveq	#GD_smprate,d1
	bsr	EnableGadSds
	moveq	#GD_loopstart,d1
	bsr	EnableGadSds
	moveq	#GD_loopend,d1
	bsr	EnableGadSds

	tst.b	rt_sdsload_name(a5)
	beq.s	.not_disable
	cmp.b	#1,sampletype(a5)	;RAW Sample?
	bne.s	.not_disable
	moveq	#GD_smpbits,d1
	bsr	EnableGadSds
.not_disable

;	tst.b	rt_sdsload_name(a5)
;	beq.s	.empty
;	bsr	smp_file
;.empty
	rts




put_sysex_msg_a2	; a2=^sysex msg

	lea	1(a2),a0
.byteloop
	move.b	(a0)+,d0
	bpl.s	.byteloop

	move.l	a0,d1
	sub.l	a2,d1
	move.l	a2,a1
	jmp	send_stream_mainJ(a5)





sdsIDCMP
	dc.w	.count-1
	dc.l	$00000004
	dr.l	window_refresh
	dc.l	$00000040
	dr.l	sdsgadgetup
	dc.l	$00000100
	dr.l	mainmenupick
	dc.l	$00000200
	dr.l	sdswdclosegad
	dc.l	$00000400
	dr.l	mainrawkey
	dc.l	$00400000
	dr.l	Generalintuiticks
	dc.l	$04000000
	dr.l	sdsgadgethelp
.count = (*-sdsIDCMP-2)/8




;==============================================================
;
;  GADGETHELP Event
;
;==============================================================

sdsgadgethelp
;	lea	.helpoffsets(pc),a0
	lea	.loc_helpoffsets(pc),a1
	lea	MTsdsStruct(a5),a2
	jmp	gadgethelpJ(a5)

	IFEQ	1

.helpoffsets
	dr.l	get_sampleH
	dr.l	smp_bitsH
	dr.l	smp_dumpH
	dr.l	smp_abortH
	dr.l	dump_requestH
	dr.l	smp_saverH
	dr.l	sds_handshakeH
	dr.l	smp_fileH
	dr.l	smp_numberH
	dr.l	smp_rateH
	dr.l	smp_lengthH
	dr.l	smp_loopstartH
	dr.l	smp_loopendH
	dr.l	smp_bufferH
	dr.l	sysexidH

	ENDC

.loc_helpoffsets
	dc.w	l_get_sampleH
	dc.w	l_smp_bitsH
	dc.w	l_smp_dumpH
	dc.w	l_smp_abortH
	dc.w	l_dump_requestH
	dc.w	l_smp_saverH
	dc.w	l_sds_handshakeH
	dc.w	l_smp_fileH
	dc.w	l_smp_numberH
	dc.w	l_smp_rateH
	dc.w	l_smp_lengthH
	dc.w	l_smp_loopstartH
	dc.w	l_smp_loopendH
	dc.w	l_smp_bufferH
	dc.w	l_sysexidH





sdump_sysexid
	bsr	GetIntegerSds
	tst.l	d0
	bmi.s	.reset
	moveq	#127,d1
	cmp.l	d1,d0
	bgt.s	.reset
	move.b	d0,sdumpchannel(a5)
	rts

.reset	moveq	#0,d0
	move.b	sdumpchannel(a5),d0
	moveq	#GD_sysexid,d1
	bra	SetIntegerSds






;=====================================================================


MTsdsBevels
	dc.w	10,103,291,16,0
sdsbevelsnum = (*-MTsdsBevels)/10



		rsreset
GD_getsmp	rs.b	1
GD_smpbits	rs.b	1
GD_smpdump	rs.b	1
GD_smpabort	rs.b	1
GD_dumpreq	rs.b	1
GD_smpsaver	rs.b	1
GD_handshake	rs.b	1
GD_smpfile	rs.b	1
GD_smpnumber	rs.b	1
GD_smprate	rs.b	1
GD_smplength	rs.b	1
GD_loopstart	rs.b	1
GD_loopend	rs.b	1
GD_smpbuffer	rs.b	1
GD_sysexid	rs.b	1

MTsds_CNT	rs.b	1



MTsdsNGads
	NEWGAD	279,3,26,15,*,-1,GD_getsmp,$0000
	NEWGAD	195,21,111,15,smpbitsText,-1,GD_smpbits,$0001
	NEWGAD	6,123,97,19,smpdumpText,-1,GD_smpdump,$0010
	NEWGAD	210,123,97,19,*,loc_sdsabort,GD_smpabort,$0010
	NEWGAD	108,123,97,19,dumpreqText,-1,GD_dumpreq,$0010
	NEWGAD	195,39,111,15,*,loc_sdssaver,GD_smpsaver,$0001
	NEWGAD	110,39,26,11,*,loc_handshake,GD_handshake,$0001
	NEWGAD	54,3,223,15,*,loc_sdsfile,GD_smpfile,$0001
	NEWGAD	80,56,57,14,smpnumberText,-1,GD_smpnumber,$0001
	NEWGAD	8,86,68,14,*,loc_sdsrate,GD_smprate,$0004
	NEWGAD	84,86,68,14,*,loc_sdslength,GD_smplength,$0004
	NEWGAD	160,86,68,14,*,loc_loopstart,GD_loopstart,$0004
	NEWGAD	236,86,68,14,*,loc_loopend,GD_loopend,$0004
	NEWGAD	110,23,26,11,*,loc_sdsbuffer,GD_smpbuffer,$0001
	NEWGAD	246,56,57,14,k2kidText,-1,GD_sysexid,$0001



MTsdsGTags
	DC.L	$00000000
MTsdsGTbits_en = *-MTsdsGTags+4
	dc.l	$8003000e,0
	DC.L	$8008000E,smpbitsLabels
MTsdsGTbits = *-MTsdsGTags+4
	dc.l	$8008000f,0
	dc.l	$8003000e,1
	DC.L	$00000000
	DC.L	$00000000
	DC.L	$8003000E,1
	DC.L	$00000000
	DC.L	$00000000
	DC.L	$8008000E,smpsaverLabels
MTsdsGTsaver = *-MTsdsGTags+4
	dc.l	$8008000f,0
	DC.L	$00000000
MTsdsGThandshake = *-MTsdsGTags+4
	DC.L	$80080004,1
	DC.L	$00000000
MTsdsGTfile_en = *-MTsdsGTags+4
	DC.L	$8003000E,0
MTsdsGTfile = *-MTsdsGTags+4
	DC.L	$8008000B,0
	DC.L	$80080039,1		; put border
	DC.L	$00000000
MTsdsGTnumber = *-MTsdsGTags+6
	DC.L	$8008002F,0
	DC.L	$80080030,3
	DC.L	$00000000
MTsdsGTrate_en = *-MTsdsGTags+4
	DC.L	$8003000E,0
MTsdsGTrate = *-MTsdsGTags+4
	DC.L	$8008002F,44100
	DC.L	$80080030,6
	DC.L	$00000000
MTsdsGTsmplength_en = *-MTsdsGTags+4
	DC.L	$8003000E,0
MTsdsGTsmplength = *-MTsdsGTags+4
	DC.L	$8008002F,0
	DC.L	$80080030,7
	DC.L	$00000000
MTsdsGTloopstart_en = *-MTsdsGTags+4
	DC.L	$8003000E,0
MTsdsGTloopstart = *-MTsdsGTags+4
	DC.L	$8008002F,0
	DC.L	$80080030,7
	DC.L	$00000000
MTsdsGTloopend_en = *-MTsdsGTags+4
	DC.L	$8003000E,0
MTsdsGTloopend = *-MTsdsGTags+4
	DC.L	$8008002F,0
	DC.L	$80080030,7
	DC.L	$00000000
MTsdsGTsmpbuf_en = *-MTsdsGTags+4
	DC.L	$8003000E,1
MTsdsGTsmpbuf = *-MTsdsGTags+7
	DC.L	$80080004,1
	DC.L	$00000000
MTsdsGTsysexid = *-MTsdsGTags+7
	DC.L	$8008002F,0
	DC.L	$80080030,3
	DC.L	$00000000



smpbitsLabels
	dc.w	-1
	dr.w	smpbitsLab0
	dc.w	-1
	dr.w	smpbitsLab1
	dc.w	-1
	dr.w	smpbitsLab2
	DC.l	0


smpsaverLabels
	dc.w	-1
	dr.w	smpsaverLab0
	dc.w	-1
	dr.w	smpsaverLab1
	dc.w	-1
	dr.w	smpsaverLab2
	dc.w	-1
	dr.w	smpsaverLab3
	dc.w	-1
	dr.w	smpsaverLab4
	dc.w	-1
	dr.w	smpsaverLab5
	dc.w	-1
	dr.w	smpsaverLab6
	dc.w	-1
	dr.w	smpsaverLab7
	DC.l	0



smpbitsLab0	DC.B	'8 bit',0
smpbitsLab1	DC.B	'16 bit Hi',0
smpbitsLab2	DC.B	'16 bit Lo',0

smpsaverLab0	DC.B	'IFF-8SVX',0
smpsaverLab1	DC.B	'RAW 8bit',0
smpsaverLab2	DC.B	'RAW 16bit',0
smpsaverLab3	DC.B	'WAVE 8bit',0
smpsaverLab4	DC.B	'WAVE 16bit',0
smpsaverLab5	DC.B	'AIFF',0
smpsaverLab6	DC.B	'MAUD',0
smpsaverLab7	DC.B	'VOC',0

MTsdsGTypes
	dc.b	-1,7,1,1,1,7,2,13,3,3,3,3,3,2,3

;smpfileString	DC.B	'dh0:asm/miditracker/samples/AirChorus.DUMP',0

smpfileText	DC.B	'File',0
smpbitsText	DC.B	'Raw',0
smpdumpText	DC.B	'Dump',0
smpabortText	DC.B	'Abort',0
smplengthText	DC.B	'Length',0
loopstartText	DC.B	'LoopStart',0
loopendText	DC.B	'LoopEnd',0
dumpreqText	DC.B	'Request',0
smpsaverText	DC.B	'Saver',0
smpnumberText	DC.B	'Sample',0
handshakeText	DC.B	'Handshake',0
smpbufferText	DC.B	'Samplebuffer',0
smprateText	DC.B	'Rate',0	; wird auch von Sproc genutzt

MTsdsWTitle	DC.B	'Sample Dump - ',0
sdswtitle_len = *-1-MTsdsWTitle
dump_at		dc.b	'Dumping at',0


		even




MTsdsWindowTags
	DC.L	$80000064,137
	DC.L	$80000065,52
	DC.L	$80000066,321
	DC.L	$80000067,148
	DC.L	$8000006B,sdsWFlags
MTsdsWG = *+4-MTsdsWindowTags
	DC.L	$8000006C,0
MTsdsWT = *+4-MTsdsWindowTags
	DC.L	$8000006E,0
MTsdsST = *+4-MTsdsWindowTags
	DC.L	$8000006F,0
MTsdsSC = *+4-MTsdsWindowTags
	DC.L	$80000079,0
	DC.L	$80000090,1		; AutoAdjust
MTsdsHG = *+4-MTsdsWindowTags
	dc.l	$8000009b,0		; Help Group (V39)
	DC.L	$00000000

