;APS000018500000264400005EE300005EE30000265E00005E4B00005E4B000000010000000100000001

mc68020		equ 1	; 0 = 68000+ version, 1 = 68020+ version
executable	equ 0	; 0 = vom Assembler aus starten, 1 = als exe
deutsch_locale	equ 0	; 0 = system-locale, 1 = deutsch (zum testen)



	incdir	sd0:asm/
	include	includes/gadtools.i
	include	includes/graphics.i
	include	includes/intuition.i
	include	includes/dos.i
	include	includes/exec.i
	include	includes/reqtools.i
	include	includes/timer.i
	include	includes/devices.i
	include	includes/utility.i
	include	includes/diskfont.i
	include	includes/locale.i
	include	includes/rexxsyslib.i
	include	includes/xpkmaster.i
	include	includes/icon.i
	include	includes/workbench.i
	include	includes/amigaguide.i
	include	includes/cybergraphics.i
	include	includes/cia.i
	include	includes/misc.i
	include	includes/midi.i
	include	includes/camd.i
	include	miditracker/mt-key.i
	include	miditracker/keyfile-includes.i


	include	miditracker/mt-equs.s


s
	lea	varbase,a5
	bsr	InitSomething
	beq	normit

.mainevent
	move.l	#$1000,d0

	tst.l	iconify(a5)
	bne	.iconified
	move.l	IDCMPport(a5),a0
.bset	move.b	$f(a0),d1
	bset	d1,d0
.iconify_back

;	jsr	add_audio_signalJ(a5)
	bsr	add_arexx_signal
	jsr	add_amigaguide_signalJ(a5)

	move.b	replayoutput_sig(a5),d2
	bset	d2,d0

	move.l	todo_port(a5),a0
	move.b	$f(a0),d1
	bset	d1,d0

	move.l	midiin_port_main(a5),a0
	move.b	$f(a0),d1
	bset	d1,d0

; wait
	move.l	(a5),a6
	jsr	Wait(a6)

	btst	#12,d0
	bne	normit


	btst	d2,d0
	beq.s	.noreplysig
	move.l	d0,-(sp)
	jsr	player_updateJ(a5)
	move.l	(sp)+,d0
.noreplysig


	move.l	todo_port(a5),a0
	move.b	$f(a0),d1
	btst	d1,d0
	beq.s	.notodomsg
	move.l	d0,-(sp)
	bsr	.handle_todo
	move.l	(sp)+,d0
.notodomsg


	move.l	midiin_port_main(a5),a0
	move.b	$f(a0),d1
	btst	d1,d0
	beq.s	.nomidimsg
	move.l	d0,-(sp)
	jsr	makeOnlineJ(a5)
	move.l	(sp)+,d0
.nomidimsg


	jsr	check_amigaguide_signalJ(a5)
	bsr	check_arexxport
;	jsr	check_audio_signalJ(a5)

	tst.l	iconify(a5)
	beq.s	.noticonified
	bsr	iconify_handler
	beq	normit
	bra	.mainevent
.noticonified

	bsr	IDCMPhandler
	beq	normit
	bra	.mainevent




.iconified
	move.b	hide_method(a5),d1
	beq.s	.hide_window

;=== hide as appicon or appmenu

.hide_appmenu
	move.l	hide_msgport(a5),a0
	bra.s	.ctrld

.hide_window
	move.l	iconifyWnd(a5),a0
	move.l	$56(a0),a0
.ctrld	bset	#13,d0			; ^D for remote uniconify
	bra	.bset





.handle_todo
	bra.s	.todoj
.todoloop
	move.l	d0,a1
	move.l	$14(a1),d2
	jsr	ReplyMsg(a6)

	IFEQ	mc68020
	lsl.l	#2,d2
	lea	.todo_tab(pc,d2.l),a0
	ELSE
	lea	.todo_tab(pc,d2.l*4),a0
	ENDC
	adda.l	(a0),a0
	jsr	(a0)

.todoj	move.l	todo_port(a5),a0
	move.l	(a5),a6
	jsr	GetMsg(a6)
	tst.l	d0
	bne.s	.todoloop
	rts

.todo_tab
	dr.l	rec_patt_menu
	dr.l	rec_song_menu
	dr.l	play_patt_menu
	dr.l	play_song_menu
	dr.l	fastrewind_menuitem
	dr.l	fastforward_menuitem
	dr.l	stop_button




mainIDCMP
	dc.w	.count-1
	dc.l	$00000004
	dr.l	window_refresh
	dc.l	$00000008
	dr.l	mainmousebuttons
	dc.l	$00000010
	dr.l	mainmousemove
	dc.l	$00000020
	dr.l	maingadgetdown
	dc.l	$00000040
	dr.l	maingadgetup
	dc.l	$00000100
	dr.l	mainmenupick
	dc.l	$00000200
	dr.l	mainwdclosegad
	dc.l	$00000400
	dr.l	mainrawkey
	dc.l	$00400000
	dr.l	mainintuiticks
	dc.l	$04000000
	dr.l	maingadgethelp
.count = (*-mainIDCMP-2)/8




IDCMPhandler
		; zurck: positiv=normale events, negativ=closewindow
.nextmsg
	move.l	MTmainStruct+wd_Wnd(a5),d0
	beq	.closed
	move.l	d0,a0
	move.l	$56(a0),a0
	move.l	gadbas(a5),a6
	jsr	GT_GetIMsg(a6)
	tst.l	d0
	beq.s	.nomore
	move.l	d0,a1

	move.l	$14(a1),d4	; im_Class
	move.w	$18(a1),d5	; im_Code
	move.w	$1a(a1),d3	; im_Qualifier
	move.l	$1c(a1),a3	; im_IAddress
	move.w	$20(a1),d6	; im_MouseX
	move.w	$22(a1),d7	; im_MouseY
	move.l	$2c(a1),a4	; im_Window
	jsr	GT_ReplyIMsg(a6)



;=== Zugehrige Window-Struktur herausfinden
	move.l	windowtableD(a5),a0
.windowloop
	move.w	(a0)+,d2
	beq.s	.isnt
	cmpa.l	wd_Wnd(a5,d2.w),a4
	beq.s	.itis
	addq.l	#8,a0
	bra.s	.windowloop
.isnt

;=== ghelp-Window extra untersuchen!
;	move.w	#MTghelpStruct,d2
;	lea	(a5,d2.w),a1
;	cmpa.l	wd_Wnd(a1),a4
;	bne.s	.next

	bra.s	.next

.itis
;=== IDCMP-Message auswerten
	move.l	wd_IDCMP(a5,d2.w),a0
	move.w	(a0)+,d1
.idcmploop
	cmp.l	(a0)+,d4
	addq.w	#4,a0
	dbeq	d1,.idcmploop
	bne.s	.next
	adda.l	-(a0),a0
	jsr	(a0)

.next	bra	.nextmsg

.nomore	POSITIV
.closed	tst.l	iconify(a5)
	bne.s	.nomore
	NEGATIV





iconify_handler
	move.l	d0,-(sp)

	move.b	hide_method(a5),d3
	beq.s	.next


;=== hide via appicon or appmenu

	subq.b	#1,d3
	move.l	(a5),a6
.apploop
	move.l	hide_msgport(a5),a0
	jsr	GetMsg(a6)
	tst.l	d0
	beq.s	.nomore
	move.l	d0,a1
	move.w	$14(a1),d2
	jsr	ReplyMsg(a6)

	tst.b	d3
	beq.s	.menu
	cmp.w	#8,d2			; AMTYPE_APPICON
	bne.s	.apploop
	bra.s	.uniconify_by_user

.menu	cmp.w	#9,d2			; AMTYPE_APPMENUITEM
	bne.s	.apploop
	bra.s	.uniconify_by_user




;=== hide via window on wb

.next	move.l	iconifyWnd(a5),a0
	move.l	$56(a0),a0
	move.l	(a5),a6
	jsr	GetMsg(a6)
	tst.l	d0
	beq.s	.nomore
	move.l	d0,a1
	move.l	$14(a1),d4	; im_Class
	jsr	ReplyMsg(a6)

	cmp.l	#$200,d4
	beq.s	.quit
	subq.l	#1,d4		; IDCMP_SIZEVERIFY
	bne.s	.next
.uniconify_by_user
	addq.w	#4,sp
	bra.s	.uniconify

.nomore
	move.l	(sp)+,d0
	btst	#13,d0
	beq.s	.pos


.uniconify
	bsr.s	CleanupIconifyState
	clr.l	iconify(a5)
	jsr	OpenVisualsJ(a5)
.pos	POSITIV


.quit	jsr	ask_songchangedJ(a5)
	beq.s	.next
	bsr.s	CleanupIconifyState
	addq.w	#4,sp
	NEGATIV





CleanupIconifyState
	move.l	iconifyWnd(a5),d0
	beq.s	.nownd
	move.l	d0,a0
	move.l	4(a0),Iconify_coords(a5)	; save coords to prefs

	move.l	intbas(a5),a6
	jsr	CloseWindow(a6)
	clr.l	iconifyWnd(a5)
.nownd

	move.l	hide_msgport(a5),d0
	beq.s	.norep
	move.l	d0,a0
	bsr	reply_all_messages
.norep

	move.l	appmenu(a5),d0
	beq.s	.noapp
	move.l	d0,a0
	move.l	wbbas(a5),a6
	jsr	RemoveAppMenuItem(a6)
	clr.l	appmenu(a5)
.noapp

	move.l	appicon(a5),d0
	beq.s	.noicon
	move.l	d0,a0
	move.l	wbbas(a5),a6
	jsr	RemoveAppIcon(a6)
	clr.l	appicon(a5)
.noicon

	move.l	hide_msgport(a5),d0
	beq.s	.nomp
	move.l	d0,a0
	move.l	(a5),a6
	jsr	DeleteMsgPort(a6)
	clr.l	hide_msgport(a5)
.nomp

	move.l	iconifyicon(a5),d0
	beq.s	.noobj
	clr.l	iconifyicon(a5)
	move.l	d0,a0
	move.l	iconbas(a5),a6
	jsr	FreeDiskObject(a6)
.noobj


	rts







normit
	IFNE	executable

	bsr	FreeSomething
	moveq	#0,d0
	rts

	ELSE

	rts

n	bra	FreeSomething

	ENDC




MainOpen
	lea	MTmainStruct(a5),a4
	bsr.s	.RefreshMain
	jsr	OpenWDJ(a5)
	bne.s	.neg

	jsr	set_songnameJ(a5)	; set songname to sth meaningful
	jsr	pos_set_ohne_scrJ(a5)

	POSITIV
.neg	NEGATIV



.RefreshMain
;=== Gadget Tags
	move.l	wd_GTags(a4),a2


	jsr	GetChannelResolutionJ(a5)
	move.l	d0,MTmainGTscale(a2)
	move.l	events(a5),d2
	divu	d0,d2
	ext.l	d2
	move.l	d2,MTmainGTpattsize(a2)


;=== calculate positions-scroller
	move.l	currentpos(a5),d0
	move.l	d0,MTmainGTposscrtop(a2)
	move.l	length(a5),d2
	addq.l	#8,d2
	move.l	d2,MTmainGTposscrtot(a2)

	move.l	positionsA(a5),a1
	moveq	#1,d1
	IFEQ	mc68020
	add.l	d0,d0
	add.w	(a1,d0.l),d1
	ELSE
	add.w	(a1,d0.l*2),d1
	ENDC
	move.w	d1,MTmainGTposint(a2)



	move.w	tempo(a5),d0
	divu	#100,d0
	move.w	d0,MTmainGTbpm(a2)


	move.l	bpmstringD(a5),MTmainGTbpmstr(a2)

	move.l	length(a5),MTmainGTlength(a2)
	move.w	currentchannel(a5),MTmainGTchannel(a2)
	move.w	mastervolume(a5),MTmainGTvolume+2(a2)
	move.b	recordmode(a5),MTmainGTrecmode(a2)
	move.l	looppos(a5),d0
	addq.l	#1,d0
	move.l	d0,MTmainGTlooppos(a2)

	move.l	currentpattern(a5),d0
	addq.l	#1,d0
	move.l	d0,MTmainGTpattern(a2)

	move.b	transpose(a5),MTmainGTtrans(a2)
	move.l	currentsong(a5),d0
	addq.l	#1,d0
	move.l	d0,MTmainGTsong(a2)
	move.b	editmode(a5),MTmainGTedit(a2)
	move.b	chordmode(a5),MTmainGTchord(a2)


	moveq	#$01,d1


;=== pattlock text setzen
	tst.b	pattern_locked(a5)
	bne.s	.locked

	clr.b	MTmainGTpattdis(a2)
	clr.b	MTmainGTpattmdis(a2)
	clr.b	MTmainGTpattpdis(a2)
	moveq	#1,d0
	move.l	d0,MTmainGTpattlockpen(a2)
	move.l	pattlock_pattD(a5),a1
	bra.s	.lock_go
.locked
;	move.l	pattlock_lockD(a5),a1
	move.w	#loc_pattlock,d0
	jsr	getcatstringJ(a5)
	move.b	d1,MTmainGTpattdis(a2)
	move.b	d1,MTmainGTpattmdis(a2)
	move.b	d1,MTmainGTpattpdis(a2)
	moveq	#2,d0
	move.l	d0,MTmainGTpattlockpen(a2)
.lock_go
	move.l	a1,MTmainGTpattlock(a2)



	move.w	currentchannel(a5),d0
	jsr	GetChannelnameJ(a5)
	move.l	a0,MTmainGTchanname(a2)


	move.b	solomode(a5),d0
;	and.b	d1,d0
	move.b	d0,MTmainGTsolo(a2)

	move.b	metroflag(a5),d0
;	and.b	d1,d0
	move.b	d0,MTmainGTmetro(a2)

	move.b	ignorenoffs(a5),MTmainGTignoren0(a2)

	move.b	scaledrec(a5),d0
;	and.b	d1,d0
	move.b	d0,MTmainGTquantrec(a2)

	move.b	loopsong(a5),d0
;	and.b	d1,d0
	move.b	d0,MTmainGTloopsong(a2)


;=== Men Strukturen
	move.l	wd_NewMenu0(a4),a0


	move.b	pastemode(a5),d0
	move.w	#MTmainNMpmode,d1
	moveq	#1,d2
	bsr	MutualXcluder

	move.b	pattout(a5),d0
	move.w	#MTmainNMpattout,d1
	bsr	PutCheckmark

	move.b	alltrackdisplays(a5),d0
	move.w	#MTmainNMalltd,d1
	bsr	PutCheckmark

	move.b	useinstname(a5),d0
	move.w	#MTmainNMusename,d1
	bsr	PutCheckmark



;=== Gadgethelp Menuitem disablen, falls <V39
	tst.b	kick30(a5)
	beq.s	.nov39
	and.w	#~$10,MTmainNMohelp(a0)

	move.b	gadgethelp_active(a5),d0
	move.w	#MTmainNMohelp,d1
	bsr	PutCheckmark
	bra.s	.kick1
.nov39	or.w	#$10,MTmainNMohelp(a0)
.kick1



	IFNE	keyfile_active
;=== Here's some keyfile checking
	move.l	keybas(a5),d0
	beq.s	.nokey
	move.l	d0,a6
	lea	maindisablesD(a5),a0
	jsr	keyEnableGadgets(a6)
.nokey
	ENDC



	jsr	calc_total_time_routineJ(a5)



;=== Statuszeile einfgen

	move.w	#loc_allright,d0
	jmp	status_fillJ(a5)






MutualXcluder	; d0.b=data, d1.w=newmenu-offset, d2.w=#items-1
		; a0=^NewMenu

.mutualloop
	subq.b	#1,d0
	bcs.s	.set1
	and.w	#~$0100,(a0,d1.w)
	bra.s	.cont1
.set1	ori.w	#$0100,(a0,d1.w)
.cont1	add.w	#20,d1
	dbf	d2,.mutualloop
	rts



PutCheckmark	; a0=^NewMenu, d0=dataflag, d1=menu-offset
	and.w	#$0001,d0
	lsl.w	#8,d0
	and.w	#~$0100,(a0,d1.w)
	or.w	d0,(a0,d1.w)
	rts






	include	miditracker/mt-init+free.s
	include	miditracker/mt-locale.s
	include	miditracker/mt-arexx.s
	include	miditracker/mt-gadgethelp.s





window_refresh

	move.l	a4,a0
	move.l	gadbas(a5),a6
	jsr	GT_BeginRefresh(a6)
	move.l	a4,a0
	moveq	#1,d0
	jmp	GT_EndRefresh(a6)

;	move.l	a4,a0
;	suba.l	a1,a1
;	jmp	GT_RefreshWindow(a6)





;==============================================================
;
;  GADGETUP Message frs Mainwindow
;
;==============================================================


maingadgetup
	sf	gadgetisdown(a5)
	lea	.GadgetUpTab(pc),a0
	bra	gadgetjsr_long



;=== "dr.l *"'s are NEVER jumped to, because they are text-gadgets

.GadgetUpTab
MainGadgetUpTab
	dr.l	pat_minus
	dr.l	pat_plus
	dr.l	len_minus
	dr.l	len_plus
	IFNE	keyfile_active
	dr.l	nop_gadget
	dr.l	nop_gadget
	ELSE
	dr.l	ins_button
	dr.l	del_button
	ENDC
	dr.l	song_minus
	dr.l	song_plus
	dr.l	play_song_button
	dr.l	stop_button
	dr.l	play_patt_button
	IFNE	keyfile_active
	dr.l	nop_gadget	; length button (nop'ed for unregistered users)
	ELSE
	dr.l	len_button
	ENDC
	dr.l	song_button
	dr.l	nop_gadget	; channel_slider
	dr.l	nop_gadget	; bpm_slider
	dr.l	bpm_integer
	dr.l	nop_gadget	; volume_slider
	dr.l	forward_button
;	dr.l	pause_button
	dr.l	fastforward_button
	dr.l	rec_song_button
	dr.l	patt_button
	dr.l	patt_minus
	dr.l	patt_plus
	dr.l	edit_button
	dr.l	panic_button
	dr.l	pattscale_gad
	dr.l	quantize_gad
	dr.l	pattscale_minus
	dr.l	pattscale_plus
	dr.l	quantize_minus
	dr.l	quantize_plus
	dr.l	Pattsize_gad
	dr.l	pattsize_minus
	dr.l	pattsize_plus
	dr.l	rec_patt_button
	dr.l	fastrewind_button

	dr.l	* ;time_button
	dr.l	channelname_gadget
	dr.l	transpose_gadget
	dr.l	trans_oct_up
	dr.l	trans_oct_down
	dr.l	trans_note_up
	dr.l	trans_note_down
	dr.l	solo_channel
	dr.l	metro_enable
	dr.l	ignore_noteoffs
	dr.l	chord_mode
	dr.l	positions_scroller
	dr.l	recmode_gadget
	dr.l	quantize_record
	dr.l	pattern_lock
	dr.l	positions_intgad
	dr.l	loopsong_gadget
	dr.l	nop_gadget



gadgetjsr	; fr Tabellen mit dr.w
	move.w	38(a3),d1	; in d1 kopieren zum Gadget-auslesen

jump_into_word_table		; d1=item number, a0=dr.w-table
	IFEQ	mc68020
	move.w	d1,d0
	add.w	d0,d0
	adda.w	d0,a0
	adda.w	(a0),a0
	jmp	(a0)
	ELSE
	adda.w	(a0,d1.w*2),a0
	jmp	(a0,d1.w*2)
	ENDC


gadgetjsr_long	; fr Tabellen mit dr.l
		; a0=^tabelle

	move.w	38(a3),d1	; in d1 kopieren zum Gadget-auslesen

jump_into_long_table		; d1=item number, a0=dr.l-table
	IFEQ	mc68020
	move.w	d1,d0
	lsl.w	#2,d0
	adda.w	d0,a0
	adda.l	(a0),a0
	jmp	(a0)
	ELSE
	adda.l	(a0,d1.w*4),a0
	jmp	(a0,d1.w*4)
	ENDC




;==============================================================
;
;  GADGETDOWN Message frs Mainwindow
;
;==============================================================

maingadgetdown
	st	gadgetisdown(a5)
	move.b	#4,downcounter(a5)
	move.l	a3,downgadget(a5)

maingadgetdowner	;=== wird von mainintuiticks angesprungen
	lea	Maingadgetdowntab(pc),a0
	bra.s	gadgetdown
MainGadgetDownTab
	dc.w	GD_forward
	dr.l	forward_down
	dc.w	GD_fastforward
	dr.l	fastforward_down
	dc.w	GD_fastrewind
	dr.l	fastrewind_down
;	dc.w	GD_posplus
;	dr.l	pos_plus_down
;	dc.w	GD_posminus
;	dr.l	pos_minus_down
	dc.w	GD_patplus
	dr.l	pat_plus_down
	dc.w	GD_patminus
	dr.l	pat_minus_down
len_plus_down_num = (*-MainGadgetDownTab)/6
	dc.w	GD_lenplus
	IFNE	keyfile_active
	dr.l	nop_gadget
	ELSE
	dr.l	len_plus_down
	ENDC
len_minus_down_num = (*-MainGadgetDownTab)/6
	dc.w	GD_lenminus
	IFNE	keyfile_active
	dr.l	nop_gadget
	ELSE
	dr.l	len_minus_down
	ENDC
	dc.w	GD_quantizeminus
	dr.l	quantize_minus_down
	dc.w	GD_quantizeplus
	dr.l	quantize_plus_down

	dc.w	-1




gadgetdown
	move.w	38(a3),d1		; d1=GadgetID
.next	move.w	(a0)+,d2
	bmi.s	.rts
	move.l	(a0)+,d3
	cmp.w	d1,d2
	bne.s	.next
	jmp	-4(a0,d3.l)
.rts	rts





;==============================================================
;
;  INTUITICKS Message
;
;==============================================================

mainintuiticks
	tst.b	gadgetisdown(a5)
	beq.s	.notdown
	subq.b	#1,downcounter(a5)
	bcc.s	.notdown
	clr.b	downcounter(a5)
	move.l	downgadget(a5),a3
	bsr	maingadgetdowner
.notdown

	move.l	MTmainStruct+wd_Wnd(a5),a0
	jmp	all_purpose_intuiticksJ(a5)




;==============================================================
;
;  GADGETHELP Message frs Mainwindow
;
;==============================================================

maingadgethelp
;	lea	.helpoffsets(pc),a0
	lea	.loc_helpoffsets(pc),a1
	lea	MTmainStruct(a5),a2
	bra	gadgethelp

	IFEQ	1

.helpoffsets
	dr.l	pat_minusH
	dr.l	pat_plusH
	dr.l	len_minusH
	dr.l	len_plusH
	dr.l	ins_buttonH
	dr.l	del_buttonH
	dr.l	song_minusH
	dr.l	song_plusH
	dr.l	play_song_buttonH
	dr.l	stop_buttonH
	dr.l	play_patt_buttonH
	dr.l	len_buttonH
	dr.l	song_buttonH
	dr.l	channel_sliderH
	dr.l	bpm_sliderH
	dr.l	bpm_sliderH
	dr.l	volume_sliderH
	dr.l	forward_buttonH
	dr.l	fastforward_buttonH
	dr.l	rec_song_buttonH
	dr.l	patt_buttonH
	dr.l	patt_minusH
	dr.l	patt_plusH
	dr.l	edit_buttonH
	dr.l	panic_buttonH
	dr.l	pattscale_gadH
	dr.l	quantize_gadH
	dr.l	pattscale_minusH
	dr.l	pattscale_plusH
	dr.l	quantize_minusH
	dr.l	quantize_plusH
	dr.l	Pattsize_gadH
	dr.l	pattsize_minusH
	dr.l	pattsize_plusH
	dr.l	rec_patt_buttonH
	dr.l	fastrewind_buttonH

	dr.l	time_buttonH
	dr.l	channelname_gadgetH
	dr.l	transpose_gadgetH
	dr.l	trans_oct_upH
	dr.l	trans_oct_downH
	dr.l	trans_note_upH
	dr.l	trans_note_downH
	dr.l	solo_channelH
	dr.l	metro_enableH
	dr.l	ignore_noteoffsH
	dr.l	chord_modeH
	dr.l	positions_scrollerH
	dr.l	recmode_buttonH
	dr.l	quantize_recordH
	dr.l	patternlockH
	dr.l	posintH
	dr.l	loopsongH
	dr.l	loopposH

	ENDC

.loc_helpoffsets
	dc.w	loc_pat_minusH
	dc.w	loc_pat_plusH
	dc.w	loc_len_minusH
	dc.w	loc_len_plusH
	dc.w	loc_ins_buttonH
	dc.w	loc_del_buttonH
	dc.w	loc_song_minusH
	dc.w	loc_song_plusH
	dc.w	loc_play_song_buttonH
	dc.w	loc_stop_buttonH
	dc.w	loc_play_patt_buttonH
	dc.w	loc_len_buttonH
	dc.w	loc_song_buttonH
	dc.w	loc_channel_sliderH
	dc.w	loc_bpm_sliderH
	dc.w	loc_bpm_sliderH
	dc.w	loc_volume_sliderH
	dc.w	loc_forward_buttonH
	dc.w	loc_fastforward_buttonH
	dc.w	loc_rec_song_buttonH
	dc.w	loc_patt_buttonH
	dc.w	loc_patt_minusH
	dc.w	loc_patt_plusH
	dc.w	loc_edit_buttonH
	dc.w	loc_panic_buttonH
	dc.w	loc_pattscale_gadH
	dc.w	loc_quantize_gadH
	dc.w	loc_pattscale_minusH
	dc.w	loc_pattscale_plusH
	dc.w	loc_quantize_minusH
	dc.w	loc_quantize_plusH
	dc.w	loc_Pattsize_gadH
	dc.w	loc_pattsize_minusH
	dc.w	loc_pattsize_plusH
	dc.w	loc_rec_patt_buttonH
	dc.w	loc_fastrewind_buttonH

	dc.w	loc_time_buttonH
	dc.w	loc_channelnameH
	dc.w	loc_transpose_gadgetH
	dc.w	loc_trans_oct_upH
	dc.w	loc_trans_oct_downH
	dc.w	loc_trans_note_upH
	dc.w	loc_trans_note_downH
	dc.w	loc_solo_channelH
	dc.w	loc_metro_enableH
	dc.w	loc_ignore_noteoffsH
	dc.w	loc_chord_modeH
	dc.w	loc_positions_scrollerH
	dc.w	loc_recmode_buttonH
	dc.w	loc_quantize_recordH
	dc.w	loc_patternlockH
	dc.w	loc_posintH
	dc.w	loc_loopsongH
	dc.w	loc_loopposH



;==============================================================
;
;  MOUSEMOVE Message
;
;==============================================================

mainmousemove
	lea	.mmovetab(pc),a0
	lea	MTmainStruct(a5),a1
	bra.s	mousemover
.mmovetab
	dc.w	.mmovesize-1

	bra	channel_slider
	dc.w	GD_channel

	bra	bpm_slider
	dc.w	GD_bpm

	bra	volume_slider
	dc.w	GD_volume

	bra	positions_scroller
	dc.w	GD_posscroller

.mmovesize = (*-.mmovetab-2)/6



mousemover	; a0=^movetab, a1=^windowstruct, a3=IAddress

	cmpa.l	wd_Wnd(a1),a3		; Object = Window ?
	beq.s	.back

	move.w	wd_Gadgets(a1),d0
	lea	(a5,d0.w),a2
	move.w	(a0)+,d0
.mouseloop
	addq.w	#4,a0
	move.w	(a0)+,d1
	IFEQ	mc68020
	lsl.w	#2,d1
	cmpa.l	(a2,d1.w),a3
	ELSE
	cmpa.l	(a2,d1.w*4),a3
	ENDC
	dbeq	d0,.mouseloop
	bne.s	.back
	move.w	-(a0),d1		; Gadget-ID
	jmp	-4(a0)
.back	rts





;==============================================================
;
;  MENUPICK Message frs Mainwindow
;
;==============================================================

mainmenupick
	lea	.menutab(pc),a0
	bra.s	menuhandler
.menutab
	dr.w	menu_project
	dr.w	menu_edit
	dr.w	menu_actions
	dr.w	menu_tools
	dr.w	menu_prefs
	dr.w	menu_block


menuhandler	; a0=^menutab
	cmp.w	#-1,d5
	beq.s	.rts
	bsr	make_qualifier

	movem.l	d2/a0,-(sp)	; ^menutab, Offset des Windowstructs
.nextitem
	move.l	d5,-(sp)

	move.w	d5,d0		; d5=MenuNumber
	and.w	#$001f,d0
	IFEQ	mc68020
	add.w	d0,d0
	adda.w	d0,a0
	adda.w	(a0),a0
	jsr	(a0)
	ELSE
	adda.w	(a0,d0.w*2),a0
	jsr	(a0,d0.w*2)
	ENDC

	move.l	(sp)+,d0		; MenuNumber
	move.l	(sp),d2			; ^Windowstruct-Offset
	move.l	wd_NewMenu0(a5,d2.w),d3
	beq.s	.frommainmenu
	cmp.l	MTmainStruct+wd_NewMenu0(a5),d3	; nur bei diesem Menu
	bne.s	.skip1
.frommainmenu

; Falls Screenmode-MenuItem
; oder LoadPrefs-MenuItem  
; -> keine weiteren Items  
; (weil dort das Window neu
;  geffnet wird)

	lea	.mainmenu_skipitems(pc),a0
	bra.s	.min
.menuloop
	cmp.w	d1,d0
	beq.s	.thatsit
.min	move.w	(a0)+,d1
	cmp.w	#-1,d1
	bne.s	.menuloop

.skip1

	move.l	wd_Menus(a5,d2.w),a0	; ^Menus
	move.l	intbas(a5),a6
	jsr	ItemAddress(a6)
	tst.l	d0
	beq.s	.thatsit
	move.l	d0,a0
	move.w	$20(a0),d0		; nchstes selektiertes Checkmark
	cmp.w	#-1,d0
	beq.s	.thatsit

	move.w	d0,d5
	movem.l	(sp),d2/a0
	bra.s	.nextitem

.thatsit
	addq.w	#8,sp

.rts	rts



.mainmenu_skipitems
	dc.w	loadprefs_menu
	dc.w	iconify_menu
	dc.w	clearsong_menu
	dc.w	loadsong_menu
	dc.w	savesong_menu
	dc.w	savesongas_menu
	dc.w	quick1_menu
	dc.w	quick2_menu
	dc.w	quick3_menu
	dc.w	quick4_menu
	dc.w	quick5_menu
	dc.w	channel1_menu
	dc.w	channel2_menu
	dc.w	channel3_menu
	dc.w	channel4_menu
	dc.w	channel5_menu
	dc.w	channel6_menu
	dc.w	channel7_menu
	dc.w	channel8_menu
	dc.w	channel9_menu
	dc.w	channel10_menu
	dc.w	channel11_menu
	dc.w	channel12_menu
	dc.w	channel13_menu
	dc.w	channel14_menu
	dc.w	channel15_menu
	dc.w	channel16_menu
	dc.w	-1



;==============================================================
;
;  Project Men
;
;==============================================================

menu_project
	lea	.projecttab(pc),a0
	bra	item_activator_long
.projecttab
	dr.l	project_clear
	dr.l	*
	dr.l	load_song
	dr.l	quickloader_sub
	dr.l	save_mt
	dr.l	saveas_mt
	dr.l	delete_song
	dr.l	*
	dr.l	save_mid
	dr.l	*
	dr.l	load_pattern
	dr.l	save_pattern
	dr.l	load_channel
	dr.l	save_channel
	dr.l	*
	dr.l	project_songname
	dr.l	project_author
	dr.l	*
	dr.l	project_about
	dr.l	online_help
	dr.l	*
	dr.l	iconify_miditracker
	dr.l	project_quit






quickloader_sub
	lea	.subtab(pc),a0
	jmp	subitem_activatorJ(a5)
.subtab
	dr.w	quickloader1
	dr.w	quickloader2
	dr.w	quickloader3
	dr.w	quickloader4
	dr.w	quickloader5


quickloader1
	moveq	#0,d0
	bra.s	quickloader

quickloader2
	moveq	#1,d0
	bra.s	quickloader

quickloader3
	moveq	#2,d0
	bra.s	quickloader

quickloader4
	moveq	#3,d0
	bra.s	quickloader

quickloader5
	moveq	#4,d0

quickloader
	move.l	MTmainMquick1D(a5),a0
	mulu	#quickload_len,d0
	adda.w	d0,a0
	tst.b	(a0)+
	beq.s	.rts
	bra	load_song_routine
.rts	rts





;==============================================================
;
;  Edit Men
;
;==============================================================

menu_edit
	lea	.edittab(pc),a0
	bra	item_activator
.edittab
	dr.w	edit_jointrack
	dr.w	edit_cuttrack
	dr.w	edit_copytrack
	dr.w	edit_pastetrack
	dr.w	*
	dr.w	edit_cutchannel
	dr.w	edit_copychannel
	dr.w	edit_pastechannel
	dr.w	edit_flushchannel
	dr.w	*
	dr.w	edit_cutpattern
	dr.w	edit_copypattern
	dr.w	edit_pastepattern
	dr.w	*
	dr.w	del_eot
	dr.w	fixvelocity
	dr.w	add_to_controlsource


	include	miditracker/mt-edit.s


;==============================================================
;
;  Tools Men
;
;==============================================================

menu_tools
	lea	toolsmenutab(pc),a0
	bra	item_activator_long

toolsmenutab
	IFNE	keyfile_active
midifilter_menu_id = (*-toolsmenutab)/4
	dr.l	nop_gadget		; for unregged users
	ELSE
	dr.l	midifilter
	ENDC
	dr.l	nop_gadget ;sample_dump
	dr.l	channelscope
	dr.l	parametergfx
	dr.l	nop_gadget ;sample_processor
	dr.l	score
	dr.l	midi_activity
;	IFNE	keyfile_active
;remapper_menu_id = (*-toolsmenutab)/4
;	dr.l	nop_gadget		; for unregged users
;	ELSE
	dr.l	remapper
;	ENDC
	dr.l	sysex_editor
	dr.l	nop_gadget
	dr.l	dialog_window
	dr.l	nop_gadget
	dr.l	channel_selector



;==============================================================
;
;  Actions Men
;
;==============================================================

menu_actions
	lea	.actionstab(pc),a0
	bra	item_activator_long
.actionstab
	dr.l	fastrewind_menuitem
	dr.l	forward_menuitem
	dr.l	fastforward_menuitem
	dr.l	play_patt_menu
	dr.l	play_song_menu
	dr.l	*
	dr.l	rec_patt_menu
	dr.l	rec_song_menu
	dr.l	rec_undo
	dr.l	*
	dr.l	stop_button
	dr.l	panic_button


;==============================================================
;
;  Prefs Men
;
;==============================================================

menu_prefs
	lea	.prefstab(pc),a0
	bra.s	item_activator_long
.prefstab
	dr.l	editprefs
	dr.l	midiprefs
	dr.l	sysprefs
	dr.l	metronome
	dr.l	keyboard_actions
	dr.l	*
	dr.l	all_trackdisplays_scroll
	dr.l	realtime_trackdisplay
	dr.l	*
	dr.l	loadprefs
	dr.l	saveprefs
	dr.l	saveprefsas


;=== Menu Item Activator (.l sized)

item_activator_long	; a0=^branchtable
	lsr.w	#5,d5
	move.w	d5,d1
	and.w	#$003f,d1
	bra	jump_into_long_table



;=== Menu Item Activator (.w sized)

item_activator	; a0=^branchtable
	lsr.w	#5,d5
	move.w	d5,d1
	and.w	#$003f,d1
	bra	jump_into_word_table




;==============================================================
;
;  Block Men
;
;==============================================================

menu_block
	tst.b	playflag(a5)
	bne.s	.rts
	tst.l	active_channelwindow(a5)
	bmi.s	.rts
	lea	.blocktab(pc),a0
	bra.s	item_activator
.rts	rts
.blocktab
	dr.w	block_mark_track
	dr.w	block_mark_channel
	dr.w	*
	dr.w	block_cut
	dr.w	block_clear
	dr.w	block_copy
	dr.w	block_spread
	dr.w	block_random
	dr.w	block_flip
	dr.w	block_invert
	dr.w	block_shift
	dr.w	*
	dr.w	block_pastemode
	dr.w	block_insert_track
	dr.w	block_insert_chan
	dr.w	block_join_track
	dr.w	block_join_chan


	include	miditracker/mt-block.s
	include	miditracker/mt-keyroutines.s
	include	miditracker/mt-config.s
	include	miditracker/mt-someroutines.s

	include	miditracker/mt-quasar.s
	include	miditracker/mt-k2000.s
	include	miditracker/mt-quadrasynth.s
	include	miditracker/mt-boehm.s
	include	miditracker/mt-mc303.s
	include	miditracker/mt-yamahaxg.s
	include	miditracker/mt-yamahacs1x.s

	include	miditracker/mt-channelselect.s
	include	miditracker/mt-kernroutines.s
;	include	miditracker/mt-sampledump.s
	include	miditracker/mt-wdroutines.s
	include	miditracker/mt-channelscope.s
	include	miditracker/mt-activity.s
	include	miditracker/mt-pgfx.s
;	include	miditracker/mt-sampleprocessor.s
	include	miditracker/mt-prefs.s
	include	miditracker/mt-metro.s
	include	miditracker/mt-sysexeditor.s
	include	miditracker/mt-score.s
	include	miditracker/mt-remapper.s
	include	miditracker/mt-midifilter.s
	include	miditracker/mt-keyboardactions.s
	include	miditracker/mt-variablen.s


;faulty_recbuf
;	incbin	"dh0:miditracker/stuff/alex's stuff/serial-out_16"
;faulty_recbuf_len = *-faulty_recbuf
;	even





	include	miditracker/mt-playerprocess.s

	include	miditracker/mt-midiprocess.s
	include	miditracker/mt-scoper.s



;================================= Chip Segment
	section	chipmem,data_c

	include	miditracker/mt-images.s
	include	miditracker/mt-mousepointer.s



;=============================================
	section	bss_segment,bss


sp_graph	ds.l	480+1

csources_strings ds.l	128
panic_codes	ds.b	128

serialoutpuffer	ds.b	serialoutsize
serialinpuffer	ds.b	serialinsize
replaypuffer	ds.b	replaysize
;replaypufferopt	ds.b	replaysize

sysexbuffer1	ds.b	4+sysexbuffersize
sysexbuffer2	ds.b	4+sysexbuffersize

varbase		ds.b	varsize	; mu an .l-Adresse liegen!


blockrange_offset = 10+2+channelname_len+1

MTinstWTitles
		REPT	16
		ds.b	10+2			; "Active: "
		ds.b	channelname_len+1	; name + 1 space
		ds.b	9+1			; block-range + zerobyte
		ENDR
MTinstWTitle_len = (*-MTinstWTitles)/16


startcdname		ds.b	108
complete_filename	ds.b	256


;puf	ds.b	$20000

;bss_len=*-bss_start
