;APS00000CED000000000000000000000000000000000000000000000000000000000000000000000000

sysex_editor
	move.l	MTsysexStruct+wd_Wnd(a5),d0
	bne	window_activation

;=== Fenster ffnen
	lea	MTsysexStruct(a5),a4
	bsr.s	.RefreshSysex
	bsr	OpenWD
	bne.s	.norm

	POSITIV
.norm	NEGATIV


.RefreshSysex
	move.l	MTsysexStruct+wd_GTags(a5),a3

	move.b	autosysex(a5),MTsysexGTauto(a3)
	move.l	sysexdelay(a5),MTsysexGTdelay(a3)

	move.l	sysex_msgs(a5),d0
	bne.s	.notempty
	lea	-1.w,a0
	bra.s	.set
.notempty
	lea	sysex_listroot(a5),a0
.set	move.l	a0,MTsysexGTlist(a3)


	move.l	MTsysexStruct+wd_WindowTags(a5),a3
	move.w	#loc_sysexed,d0
	jsr	getcatstringJ(a5)
	move.l	a1,MTsysexWT(a3)

	rts





sysexIDCMP
	dc.w	.count-1
	dc.l	$00000004
	dr.l	window_refresh
	dc.l	$00000040
	dr.l	sysexgadgetup
	dc.l	$00000100
	dr.l	mainmenupick
	dc.l	$00000200
	dr.l	sysexwdclosegad
	dc.l	$00000400
	dr.l	mainrawkey
	dc.l	$00400000
	dr.l	Generalintuiticks
	dc.l	$04000000
	dr.l	sysexgadgethelp
.count = (*-sysexIDCMP-2)/8



;==============================================================
;
;  WINDOWCLOSE Event
;
;==============================================================

sysexwdclosegad
sysexwdclose
	lea	MTsysexStruct(a5),a4
	bra	CloseWD



;==============================================================
;
;  GADGETHELP Event
;
;==============================================================

sysexgadgethelp
;	lea	.helpoffsets(pc),a0
	lea	.loc_helpoffsets(pc),a1
	lea	MTsysexStruct(a5),a2
	jmp	gadgethelpJ(a5)

	IFEQ	1

.helpoffsets
	dr.l	sysexlistH
	dr.l	sysex_newH
	dr.l	sysex_renameH
	dr.l	sysex_deleteH
	dr.l	sysex_loadH
	dr.l	sysex_saveH
	dr.l	sysex_sendH
	dr.l	autosysexH
	dr.l	sysexdelayH

	ENDC

.loc_helpoffsets
	dc.w	loc_sysexlistH
	dc.w	loc_sysex_newH
	dc.w	loc_sysex_renameH
	dc.w	loc_sysex_deleteH
	dc.w	loc_sysex_loadH
	dc.w	loc_sysex_saveH
	dc.w	loc_sysex_sendH
	dc.w	loc_autosysexH
	dc.w	loc_sysexdelayH


;==============================================================
;
;  GADGETUP Event
;
;==============================================================

sysexgadgetup
	lea	.sysexGadgetTab(pc),a0
	jmp	gadgetjsrJ(a5)
.sysexGadgetTab
	dr.w	sysex_list
	dr.w	sysex_new
	dr.w	sysex_rename
	dr.w	sysex_delete
	dr.w	sysex_load
	dr.w	sysex_save
	dr.w	sysex_send
	dr.w	automatic_sysex
	dr.w	sysex_delay



sysex_list
	jsr	GetListviewSysexJ(a5)
	move.l	d0,active_sysex(a5)

	subq.w	#8,sp
	move.l	sp,a0
	lea	4(sp),a1
	move.l	intbas(a5),a6
	jsr	CurrentTime(a6)

	movem.l	(sp)+,d2-d3
	movem.l	sysex_time(a5),d0-d1
	movem.l	d2-d3,sysex_time(a5)

	jsr	DoubleClick(a6)
	tst.l	d0
	bne	sysex_rename

	rts





sysex_new

	tst.b	playflag(a5)
	bne	.rts


;=== prepare status display
	move.w	#loc_sysexrecstatus,d0
	bsr	create_sysex_status
	beq	.rts


	moveq	#GD_sysexlist,d1
	jsr	ResetListviewSysexJ(a5)

	sf	sysex_arrived(a5)

	move.w	#loc_sysexnew_body,d0
	move.w	#loc_donecancel,d1
	jsr	Prepare_Async_EZJ(a5)
	beq	.cancel


	jsr	BeginTimer2secsJ(a5)

.setsig	move.l	TimerReply(a5),a0
	move.b	$f(a0),d0
	moveq	#0,d1
	bset	d0,d1

	move.l	d1,-(sp)
	jsr	get_Midi_signalJ(a5)
	or.l	(sp)+,d2

	jsr	Loop_Async_EZJ(a5)
	beq.s	.reqbutton


	move.l	TimerReply(a5),a0
	move.b	$f(a0),d0
	btst	d0,d1
	beq.s	.getloop
;=== timeout check
	tst.b	autosysex(a5)
	beq.s	.getloop
	tst.b	sysex_arrived(a5)
	beq.s	.getloop
	jsr	AbortTimerJ(a5)
	jsr	dispatch_async_EZJ(a5)
	bra.s	.timeout


.getloop
	jsr	get_next_midimsgJ(a5)
	beq.s	.setsig

	cmp.b	#$f0,(a2)
	bne.s	.skip

	move.l	a2,a1
	move.l	d1,d0
	move.l	d0,-(sp)
	bsr	refresh_sysexstatus
	move.l	(sp)+,d0

	move.l	sp_packetaddr-sp_status(a2),a0
	bsr	collect_sysex
	beq.s	.skip

	jsr	free_last_midimsgJ(a5)

	jsr	AbortTimerJ(a5)
	jsr	BeginTimer2secsJ(a5)
	st	sysex_arrived(a5)
	bra.s	.getloop

.skip	jsr	free_last_midimsgJ(a5)
	bra.s	.getloop



.reqbutton
	move.l	d1,-(sp)
	jsr	AbortTimerJ(a5)
	tst.l	(sp)+
	beq.s	.cancel

.timeout
	tst.l	sysex_root(a5)
	beq.s	.cancel

	bsr	insert_sysex
	beq.s	.cancel


;=== copy default sysex name
	move.w	#loc_new_sysex,d0
	jsr	getcatstringJ(a5)
	move.l	a1,a0
	lea	sx_name(a2),a1
	COPYTILLZERO


	bsr.s	free_sysexstatus

	bra	sysex_rename


.cancel
	bsr.s	free_sysexstatus
	bsr	free_sysex
	bra	set_sysex_listview

.rts	rts



free_sysexstatus
	move.w	#loc_sysexed,d0
	jsr	getcatstringJ(a5)
	jsr	set_wdtitle_sysexJ(a5)

	move.l	sysexstatus(a5),a1
	jmp	MyFreeVecJ(a5)



create_sysex_status	; a1 = ^statusmsg (receive or transmit),
			; d0 = locale

	jsr	getcatstringJ(a5)
	move.l	a1,a2
	move.l	a1,a0
	jsr	stringlengthJ(a5)
	move.l	d0,d2
	addq.l	#1,d0
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	move.l	d0,sysexstatus(a5)
	beq.s	.neg

	move.l	d0,a1
	move.l	a2,d0
	subq.l	#1,d2
.lengthloop

	move.b	(a2)+,d1
	cmp.b	#':',d1
	bne.s	.nope
	sub.l	a2,d0
	neg.l	d0
	addq.l	#1,d0
	move.l	d0,sysexstatusoffset(a5)
	move.b	d1,(a1)+
	bra.s	.jin
.innerloop
	move.b	(a2)+,(a1)+
.jin	dbf	d2,.innerloop
	bra.s	.out
.nope	move.b	d1,(a1)+
	dbf	d2,.lengthloop
	clr.l	sysexstatusoffset(a5)
.out
	clr.b	(a1)

	clr.l	sysexxferedbytes(a5)
	clr.l	sysexxferedmsgs(a5)
	bsr.s	set_sysex_status

	POSITIV
.neg	NEGATIV




;=== update incoming dump status
set_sysex_status
	move.l	a2,-(sp)

	move.l	sysexstatus(a5),a0
	adda.l	sysexstatusoffset(a5),a0
	move.l	sysexxferedbytes(a5),d0
	moveq	#5,d1
	jsr	decout_noleadJ(a5)
	addq.w	#1,a0

	move.l	sysexxferedmsgs(a5),d0
	moveq	#3,d1
	jsr	decout_noleadJ(a5)

	move.l	sysexstatus(a5),a1
	jsr	set_wdtitle_sysexJ(a5)

	move.l	(sp)+,a2
	rts



refresh_sysexstatus	; a1 = ^body, d0.l = length
	add.l	d0,sysexxferedbytes(a5)
	moveq	#-9,d2			; $f7 = eox
.countloop
	move.b	(a1)+,d1
	cmp.b	d2,d1
	bne.s	.noadd
	addq.l	#1,sysexxferedmsgs(a5)
.noadd	subq.l	#1,d0
	bne.s	.countloop

	bra.s	set_sysex_status




collect_sysex	; d0.l = size of sysex, a0 = ^sysex-body
		; returns: pos/neg

; Sysex-Daten werden in einer Liste gesammelt (sysex_root).


	movem.l	d0/a0,-(sp)

	addq.l	#8,d0
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	tst.l	d0
	beq.s	.neg
	move.l	d0,a1

	lea	sysex_root(a5),a0
.sxloop	move.l	(a0),d1
	beq.s	.eoq
	move.l	d1,a0
	bra.s	.sxloop
.eoq	move.l	a1,(a0)
	clr.l	(a1)+

	movem.l	(sp)+,d0/a0
	move.l	d0,(a1)+
	jsr	CopyMem(a6)

	POSITIV

.neg	addq.w	#8,sp
	NEGATIV





set_sysex_listview
	moveq	#GD_sysexlist,d1
	lea	sysex_listroot(a5),a0
	move.l	active_sysex(a5),d0
	jmp	SetListviewSysexJ(a5)





go_to_sysex	; d1 = element number (starting with 0)
		; returns: a0 = ^element

	move.l	sysex_listroot(a5),a0
	bra.s	.jin
.findloop
	move.l	(a0),a0
.jin	dbf	d1,.findloop
	rts






insert_sysex	; returns: a2 = list element, pos/neg

; Die gesammelte Sysexdatenliste (sysex_root) wird in einen
; zusammenhngenden Block kopiert und in die Listview-Struktur
; eingefgt.

	moveq	#0,d2
	move.l	sysex_root(a5),a0
	bra.s	.jin
.lenloop
	move.l	d1,a0
.jin	add.l	4(a0),d2
	move.l	(a0),d1
	bne.s	.lenloop

	moveq	#sx_sizeof,d0
	add.l	d2,d0
	move.l	#$10001,d1
	jsr	MyAllocVecJ(a5)
	tst.l	d0
	beq	.neg


	move.l	sysex_msgs(a5),d1
	beq.s	.zerolist
	subq.l	#1,d1
	bsr	go_to_sysex
	move.l	(a0),a1		; a1 = ^successor (NULL in last element)
	bra.s	.insert
.zerolist
; Sonderbehandlung, falls erstes Element
	lea	sysex_listroot(a5),a0
	lea	4(a0),a1

.insert	move.l	d0,(a0)		; a0 = prev
	move.l	d0,4(a1)	; a1 = next
	move.l	d0,a2		; a2 = current (the new one)
	move.l	a0,4(a2)
	move.l	a1,(a2)

	move.l	d2,sx_length(a2)


;=== copy sysex body
	lea	sx_sizeof(a2),a4	; dest
	lea	sysex_root(a5),a3
	moveq	#-$10,d3
	moveq	#0,d2
	bra.s	.cin
.insertloop
	move.l	d0,a3

	move.l	4(a3),d0
	lea	8(a3),a0
.copysx	move.b	(a0)+,d1
	cmp.b	d1,d3
	bne.s	.noadd
	addq.l	#1,d2
.noadd	move.b	d1,(a4)+
	subq.l	#1,d0
	bne.s	.copysx

.cin	move.l	(a3),d0
	bne.s	.insertloop



	move.l	d2,sx_msgs(a2)
	move.l	a2,a4

	lea	sx_lventry(a4),a0
	move.l	a0,10(a4)
	move.l	sx_length(a4),d0
	moveq	#5,d1
	jsr	decout_noleadJ(a5)
	move.b	#'/',(a0)+
	move.l	sx_msgs(a4),d0
	moveq	#2,d1
	jsr	decout_noleadJ(a5)
	move.b	#':',(a0)+
	move.b	#' ',(a0)+
	move.l	a4,a2


	move.l	sysex_msgs(a5),active_sysex(a5)
	addq.l	#1,sysex_msgs(a5)

	bsr.s	free_sysex

	POSITIV

.neg	NEGATIV






free_sysex
	move.l	a2,-(sp)

	move.l	sysex_root(a5),a2
	bra.s	.in
.freeloop
	move.l	d0,a1
	move.l	(a1),a2
	jsr	MyFreeVecJ(a5)
.in	move.l	a2,d0
	bne.s	.freeloop
	clr.l	sysex_root(a5)

	move.l	(sp)+,a2
	rts





sysex_rename

	tst.l	sysex_msgs(a5)
	beq.s	.rts

	moveq	#GD_sysexlist,d1
	jsr	ResetListviewSysexJ(a5)

	move.l	active_sysex(a5),d1
	bsr	go_to_sysex

	lea	sx_name(a0),a2
	moveq	#sysex_name_len-1,d1	; -1 wegen 0-byte
	move.w	#loc_sysexrename_title,d0
	jsr	rtStringJ(a5)
;	beq.s	.rts

	bra	set_sysex_listview

.rts	rts






sysex_delete
	tst.l	sysex_msgs(a5)
	beq.s	.none


	move.w	#loc_delsysex,d0
	move.w	#loc_surenoway,d1
	jsr	EZrequestJ(a5)
	beq.s	.none


	moveq	#GD_sysexlist,d1
	jsr	ResetListviewSysexJ(a5)

	move.l	active_sysex(a5),d1
	bsr	go_to_sysex

	subq.l	#1,sysex_msgs(a5)
	bne.s	.notlast
	lea	sysex_listroot(a5),a1
	lea	4(a1),a2
	move.l	a2,(a1)
	move.l	a2,8(a1)
	bra.s	.free

.notlast
	move.l	4(a0),a1
	move.l	(a0),a2
	move.l	a2,(a1)
	move.l	a1,4(a2)
.free	move.l	a0,a1
	jsr	MyFreeVecJ(a5)

	move.l	sysex_msgs(a5),d0
	beq.s	.empty
	cmp.l	active_sysex(a5),d0
	bhi.s	.in
	subq.l	#1,d0
.empty	move.l	d0,active_sysex(a5)
.in

	bra	set_sysex_listview

.none	rts






sysex_load
	lea	rt_loadsysex_struct(pc),a4
	jsr	FileRequesterJ(a5)
	beq	.none

	jsr	SysexBusyPointerJ(a5)

	lea	rt_sysex_path(a5),a0
	lea	rt_loadsysex_name(a5),a1
	jsr	CompleteFilenameJ(a5)
	move.l	d1,a2
	lea	sysex_loadfile(a5),a3
	jsr	loadfile_publicJ(a5)
	beq	.error


	move.l	(a3),a0
	cmp.l	#'MTSY',(a0)+
	bne	.isnt
	move.l	(a0)+,d0
	move.b	d0,d7
	clr.b	d0
	cmp.l	#'SEX'*$100,d0
	bne.s	.isnt

	move.b	d7,d0
	beq.s	.version_ok
	subq.b	#1,d0
	bhi.s	.isnt
.version_ok




	moveq	#GD_sysexlist,d1
	jsr	ResetListviewSysexJ(a5)

	move.l	sysex_loadfile(a5),a0
	addq.w	#8,a0
	tst.b	d7
	beq.s	.v0_1
	move.l	(a0)+,d0
	bra.s	.vok_1
.v0_1	moveq	#0,d0
	move.w	(a0)+,d0
.vok_1	lea	sysex_name_len(a0),a0


	bsr	collect_sysex
	beq.s	.error2

	bsr	insert_sysex
	beq.s	.error2


	move.l	sysex_loadfile(a5),a0
	tst.b	d7
	beq.s	.v0_2
	lea	12(a0),a0
	bra.s	.vok_2
.v0_2	lea	10(a0),a0
.vok_2	lea	sx_name(a2),a1
	COPYTILLZERO


	bsr	set_sysex_listview

	lea	sysex_loadfile(a5),a3
	jsr	unloadfileJ(a5)

	move.w	#loc_sysexloaded,d0
	jsr	status_displayJ(a5)

	jmp	SysexActivePointerJ(a5)

.none	rts


.error2	bsr	free_sysex
	bsr	set_sysex_listview

.isnt	lea	sysex_loadfile(a5),a3
	jsr	unloadfileJ(a5)

.error
	move.w	#loc_loaderror,d0
	jsr	status_displayJ(a5)

	jmp	SysexActivePointerJ(a5)




rt_loadsysex_struct
	dc.w	rt_sysex_fr
	dc.w	MTsysexStruct
	dr.w	rt_sysex_pat
	dc.w	loc_loadsysex_title
	dc.w	rt_loadsysex_name
	dc.w	rt_sysex_path
	dc.l	rt_load_flags


rt_savesysex_struct
	dc.w	rt_sysex_fr
	dc.w	MTsysexStruct
	dr.w	rt_sysex_pat
	dc.w	loc_savesysex_title
	dc.w	rt_savesysex_name
	dc.w	rt_sysex_path
	dc.l	rt_save_flags



rt_sysex_pat	dc.b	0

		even




sysex_save
	tst.l	sysex_msgs(a5)
	beq	.none

;=== use sysex name as default
	move.l	active_sysex(a5),d1
	bsr	go_to_sysex
	lea	sx_name(a0),a0
	lea	rt_savesysex_name(a5),a1
	COPYTILLZERO

	lea	rt_savesysex_struct(pc),a4
	jsr	FileRequesterJ(a5)
	beq.s	.none


;	lea	rt_savesysex_name(a5),a0
	lea	rt_savesysex_struct(pc),a0
;	move.l	a0,d1
	move.l	#1006,d2
;	move.l	dosbas(a5),a6
	jsr	OpenFileFromFRJ(a5)
;	jsr	Open(a6)
	move.l	d0,d7
	beq.s	.openerror

	jsr	SysexBusyPointerJ(a5)

	move.l	active_sysex(a5),d1
	bsr	go_to_sysex
	move.l	a0,a2

	lea	sysex_header(pc),a1
	move.l	sx_length(a2),8(a1)

;=== write the header
	move.l	d7,d1
	move.l	a1,d2
	moveq	#12,d3
	move.l	dosbas(a5),a6
	jsr	Write(a6)
	cmp.l	d3,d0
	bne.s	.writeerror


;=== write the sysex's name
	move.l	d7,d1
	lea	sx_name(a2),a0
	move.l	a0,d2
	moveq	#sysex_name_len,d3
	jsr	Write(a6)
	cmp.l	d3,d0
	bne.s	.writeerror


;=== at last, write the sysex body
	move.l	d7,d1
	lea	sx_sizeof(a2),a0
	move.l	a0,d2
	move.l	sx_length(a2),d3
	jsr	Write(a6)
	cmp.l	d3,d0
	bne.s	.writeerror

	move.l	d7,d1
	jsr	Close(a6)

	jsr	SysexActivePointerJ(a5)
	jmp	save_okJ(a5)

.none	rts



.writeerror
	move.l	d7,d1
	jsr	Close(a6)

.openerror
	jsr	SysexActivePointerJ(a5)
	jmp	save_errorJ(a5)





sysex_header	dc.b	'MTSYSEX'
		dc.b	1		; version
		dc.l	0		; sysex length --
					; v0: dc.w, v1: dc.l



sysex_send
	tst.b	playflag(a5)
	bne	.none

	tst.l	sysex_msgs(a5)
	beq	.none


;=== prepare status display
	move.w	#loc_sysexdumpstatus,d0
	bsr	create_sysex_status
	beq	.none


	jsr	SysexBusyPointerJ(a5)

	move.w	#loc_sysexdumping,d0
	jsr	status_displayJ(a5)

	move.l	active_sysex(a5),d1
	bsr	go_to_sysex




	lea	sx_sizeof(a0),a2
	move.l	sx_length(a0),d7
.sendloop

	move.l	a2,a0
	moveq	#-9,d0		; $f7
.eoxloop
	cmp.b	(a0)+,d0
	bne.s	.eoxloop
	move.l	a0,d5
	sub.l	a2,d5

	sub.l	d5,d7

	move.l	#$400,d6	; chunk size
	bra.s	.jin
.chunkloop

	move.l	d6,d1
	move.l	a2,a1
	jsr	send_stream_mainJ(a5)

	; a1 = ^body
	move.l	d6,d0
	bsr	refresh_sysexstatus

	adda.l	d6,a2

.jin	sub.l	d6,d5
	bcc.s	.chunkloop
	add.l	d6,d5
	beq.s	.ready
	move.l	d5,d6
	moveq	#0,d5
	bra.s	.chunkloop
.ready

	move.l	sysexdelay(a5),d1
	move.l	dosbas(a5),a6
	jsr	Delay(a6)

	tst.l	d7
	bne.s	.sendloop




	bsr	free_sysexstatus
	jsr	allright_statusJ(a5)

	jmp	SysexActivePointerJ(a5)

.none	rts





;BeginTimer1sec
;	moveq	#1,d0
;	bra.s	BeginTimer

BeginTimer2secs
	moveq	#2,d0

;=== Post request to wait <d0> seconds
BeginTimer	; d0 = number of seconds to wait
	move.l	d0,-(sp)

	moveq	#0,d1
	move.l	TimerReply(a5),a0
	move.b	$f(a0),d0
	bset	d0,d1
	moveq	#0,d0
	move.l	(a5),a6
	jsr	SetSignal(a6)

	move.l	timerio(a5),a1
	move.w	#9,$1c(a1)
	move.l	(sp)+,$20(a1)
	clr.l	$24(a1)
	jmp	SendIO(a6)



;=== Wait for timer sigbit and serialread-sigbit.

WaitTimerAndSerial	; returns: positive = serial data has arrived,
			;          negative = timeout.

	moveq	#0,d0
	move.l	midiin_port_main(a5),a0
	move.b	$f(a0),d2
	bset	d2,d0
	move.l	TimerReply(a5),a0
	move.b	$f(a0),d1
	bset	d1,d0
	move.l	(a5),a6
	jsr	Wait(a6)
	btst	d2,d0
	beq.s	.timer

	POSITIV

.timer	move.l	timerio(a5),a1
	bsr.s	ClearSignal
	NEGATIV




;==============================================================
;
;  Abort pending IORequest
;
;==============================================================

AbortTimer
	move.l	timerio(a5),a1

AbortDevice	; a1 = ^iorequest
;=== Nach dieser Routine ist das SigBit im Task gelscht.
	move.l	a1,-(sp)
	move.l	(a5),a6
	jsr	CheckIO(a6)
	tst.l	d0
	bne.s	.ready
	move.l	(sp),a1
	jsr	AbortIO(a6)	; Nachher ist msg->node_type = 7 !!!
.ready
	move.l	(sp),a1
	jsr	WaitIO(a6)
	move.l	(sp)+,a1

ClearSignal	; a1 = ^iorequest
	move.l	$e(a1),a1
	move.b	$f(a1),d0
	moveq	#0,d1
	bset	d0,d1
	moveq	#0,d0
	move.l	(a5),a6
	jmp	SetSignal(a6)







automatic_sysex
	jsr	GetCheckboxSysexJ(a5)
	move.b	d0,autosysex(a5)
	rts




sysex_delay
	jsr	GetIntegerSysexJ(a5)
	tst.l	d0
	ble.s	.reset
	move.l	d0,sysexdelay(a5)
	rts

.reset	move.l	sysexdelay(a5),d0
	moveq	#GD_sysexdelay,d1
	jmp	SetIntegerSysexJ(a5)



;===================================================================

		rsreset
GD_sysexlist	rs.b	1
GD_sysex_new	rs.b	1
GD_sysex_rename	rs.b	1
GD_sysex_delete	rs.b	1
GD_sysex_load	rs.b	1
GD_sysex_save	rs.b	1
GD_sysex_send	rs.b	1
GD_autosysex	rs.b	1
GD_sysexdelay	rs.b	1

MTsysex_CNT	rs.b	1


MTsysexNGads

.b_xsize  = 100
.b_ysize  = 15
.b_xstart = 3
.b_ystart = 85

	NEWGAD	.b_xstart,2,.b_xsize*3,.b_ystart-4,*,-1,GD_sysexlist,$0000
	NEWGAD	.b_xstart,.b_ystart,.b_xsize,.b_ysize,*,loc_sysex_new,GD_sysex_new,$0010
	NEWGAD	.b_xstart+.b_xsize,.b_ystart,.b_xsize,.b_ysize,*,loc_sysex_rename,GD_sysex_rename,$0010
	NEWGAD	.b_xstart+.b_xsize*2,.b_ystart,.b_xsize,.b_ysize,*,loc_sysex_delete,GD_sysex_delete,$0010
	NEWGAD	.b_xstart,.b_ystart+.b_ysize,.b_xsize,.b_ysize,*,loc_sysex_load,GD_sysex_load,$0010
	NEWGAD	.b_xstart+.b_xsize,.b_ystart+.b_ysize,.b_xsize,.b_ysize,*,loc_sysex_save,GD_sysex_save,$0010
	NEWGAD	.b_xstart+.b_xsize*2,.b_ystart+.b_ysize,.b_xsize,.b_ysize,*,loc_sysex_send,GD_sysex_send,$0010
	NEWGAD	.b_xstart+14,.b_ystart+.b_ysize*2+2,26,11,*,loc_autosysex,GD_autosysex,$0002
	NEWGAD	.b_xstart,.b_ystart+.b_ysize*2+15,40,14,*,loc_sysexdelay,GD_sysexdelay,$0002


MTsysexGTags
MTsysexGTlist = *+4-MTsysexGTags
	DC.L	$80080006,-1
	DC.L	$80080008,20
	dc.l	$80080035,0
	dc.l	$8008004f,9			; GTLV_ItemHeight
	DC.L	$00000000
	DC.L	$00000000
	DC.L	$00000000
	DC.L	$00000000
	DC.L	$00000000
	DC.L	$00000000
	DC.L	$00000000
MTsysexGTauto = *+7-MTsysexGTags
	DC.L	$80080004,1
	DC.L	$00000000
MTsysexGTdelay = *+4-MTsysexGTags
	DC.L	$8008002F,0
	DC.L	$80080030,3
	DC.L	$80032010,$00000400
	DC.L	$00000000



MTsysexGTypes
		DC.b	4,1,1,1,1,1,1,2,3


		even


MTsysexWindowTags
	DC.L	$80000064,0
	DC.L	$80000065,0
	DC.L	$80000066,0
	DC.L	$80000067,0
	DC.L	$8000006B,sysexWFlags
MTsysexWG = *+4-MTsysexWindowTags
	DC.L	$8000006C,0
MTsysexWT = *+4-MTsysexWindowTags
	DC.L	$8000006E,0
MTsysexST = *+4-MTsysexWindowTags
	DC.L	$8000006F,0
MTsysexSC = *+4-MTsysexWindowTags
	DC.L	$80000079,0
	DC.L	$80000090,1
MTsysexHG = *+4-MTsysexWindowTags
	dc.l	$8000009b,0		; Help Group (V39)
	DC.L	$00000000

