;APS00000000000000000000000000000000000000000000000000000000000000000000000000000000

midifilter
	move.l	MTfiltStruct+wd_Wnd(a5),d0
	bne.s	.act

;=== Fenster ffnen
	lea	MTfiltStruct(a5),a4
	bsr.s	.Refreshfilt
	beq.s	.norm
	jsr	OpenWDJ(a5)
	bne.s	.norm

	POSITIV
.norm	NEGATIV

.act	jmp	window_activationJ(a5)


.Refreshfilt

	lea	MTfiltGTags(pc),a2
	move.b	mpress_or_ppress(a5),MTfiltGTpress(a2)

	move.w	#loc_notefilter,d0
	jsr	getcatstringJ(a5)
	move.l	a1,MTfiltGTnote(a2)

	move.w	#loc_pchgfilter,d0
	jsr	getcatstringJ(a5)
	move.l	a1,MTfiltGTpchg(a2)


	addq.w	#4,a2

;=== note filters
	tst.b	inout_filter(a5)
	bne.s	.nout
	move.w	note_ifilter(a5),d1
	bra.s	.ngo
.nout	move.w	note_ofilter(a5),d1
.ngo	bsr	.filter_loop


;=== progchange filters
	tst.b	inout_filter(a5)
	bne.s	.cout
	move.w	pchg_ifilter(a5),d1
	bra.s	.cgo
.cout	move.w	pchg_ofilter(a5),d1
.cgo	bsr	.filter_loop


;=== pitchbend filters
	tst.b	inout_filter(a5)
	bne.s	.pbout
	move.w	pibe_ifilter(a5),d1
	bra.s	.pbgo
.pbout	move.w	pibe_ofilter(a5),d1
.pbgo	bsr	.filter_loop


;=== pressure filters
	tst.b	mpress_or_ppress(a5)
	bne.s	.ppress

	tst.b	inout_filter(a5)
	bne.s	.mout
	move.w	mpress_ifilter(a5),d1
	bra.s	.change
.mout	move.w	mpress_ofilter(a5),d1
	bra.s	.change

.ppress	tst.b	inout_filter(a5)
	bne.s	.pout
	move.w	ppress_ifilter(a5),d1
	bra.s	.change
.pout	move.w	ppress_ofilter(a5),d1
.change	bsr.s	.filter_loop


;=== controlsources filters
	tst.b	inout_filter(a5)
	bne.s	.csout
	lea	cs_ifilters(a5),a0
	bra.s	.csgo
.csout	lea	cs_ofilters(a5),a0
.csgo
	lea	codetab(a5),a1
	move.w	filtered_cs(a5),d0
	moveq	#0,d1
	IFEQ	mc68020
	move.b	(a1,d0.w),d1
	add.l	d1,d1
	move.w	(a0,d1.w),d1
	ELSE
	move.b	(a1,d0.w),d1
	move.w	(a0,d1.l*2),d1
	ENDC
	bsr.s	.filter_loop




;=== controlsource cycle-gad

	bsr	update_cs_filters
	beq.s	.neg


	lea	MTfiltGTags(pc),a2
	move.l	filtercs_array(a5),MTfiltGTcslabs(a2)
	move.w	filtered_cs(a5),MTfiltGTcsfilt(a2)
	move.b	global_infilters(a5),MTfiltGTglobin(a2)
	move.b	global_outfilters(a5),MTfiltGTglobout(a2)


	lea	MTfiltWindowTags(pc),a2
	move.w	#loc_filter_title,d0
	jsr	getcatstringJ(a5)
	move.l	a1,MTfiltWT(a2)


	POSITIV
.neg	NEGATIV



.filter_loop
	moveq	#15,d2
.pchgloop
	moveq	#0,d0
	lsr.w	#1,d1
	scs	d0
	move.l	d0,(a2)+
	addq.w	#8,a2
	dbf	d2,.pchgloop
	rts



update_cs_filters

	move.l	active_csources(a5),d0
	addq.l	#1,d0
	lsl.l	#2,d0
	moveq	#1,d1
	jsr	MyAllocVecJ(a5)
	tst.l	d0
	beq.s	.neg

	move.l	d0,-(sp)

	move.l	d0,a1
	lea	codetab(a5),a3
	move.l	csources_stringsD(a5),a2
	move.l	active_csources_m1(a5),d2
.stringloop
	moveq	#0,d0
	move.b	(a3)+,d0
	cmp.b	#$80,d0
	beq.s	.is_mp
	IFEQ	mc68020
	lsl.l	#2,d0
	move.l	(a2,d0.l),a0
	ELSE
	move.l	(a2,d0.l*4),a0
	ENDC
	addq.w	#1,a0		; skip state-char
	move.l	a0,(a1)+
.is_mp	dbf	d2,.stringloop

	clr.l	(a1)


	move.l	(sp),a0
	moveq	#0,d0
	move.w	filtered_cs(a5),d0
	moveq	#GD_cs_filter,d1
	jsr	SetCyclelabFiltJ(a5)

	bsr.s	free_cs_filters

	move.l	(sp)+,filtercs_array(a5)


	bsr	refresh_cs_filters


	POSITIV
.neg	NEGATIV




free_cs_filters
	lea	filtercs_array(a5),a0
	jmp	MyFreeVectorJ(a5)




filtIDCMP
	dc.w	.count-1
	dc.l	$00000004
	dr.l	window_refresh
	dc.l	$00000040
	dr.l	filtgadgetup
	dc.l	$00000100
	dr.l	mainmenupick
	dc.l	$00000200
	dr.l	filtwdclosegad
	dc.l	$00000400
	dr.l	mainrawkey
	dc.l	$00400000
	dr.l	Generalintuiticks
	dc.l	$04000000
	dr.l	filtgadgethelp
.count = (*-filtIDCMP-2)/8



;==============================================================
;
;  WINDOWCLOSE Event
;
;==============================================================

filtwdclosegad
filtwdclose
	lea	MTfiltStruct(a5),a4
	jsr	CloseWDJ(a5)

	bra.s	free_cs_filters



;==============================================================
;
;  GADGETHELP Event
;
;==============================================================

filtgadgethelp
;	lea	.helpoffsets(pc),a0
	lea	.loc_helpoffsets(pc),a1
	lea	MTfiltStruct(a5),a2
	jmp	gadgethelpJ(a5)

	IFEQ	1

.helpoffsets
	REPT	16
	dr.l	note_filterH
	ENDR
	REPT	16
	dr.l	pchg_filterH
	ENDR
	REPT	16
	dr.l	pibe_filterH
	ENDR
	REPT	16
	dr.l	press_filterH
	ENDR
	REPT	16
	dr.l	cs_filterH
	ENDR
	dr.l	inoutfilterH
	dr.l	globalinfiltersH
	dr.l	globaloutfiltersH
	dr.l	note_filterH
	dr.l	pchg_filterH
	dr.l	pibe_filterH
	dr.l	press_filterH
	dr.l	cs_filterH
	REPT	5
	dr.l	toggle_allH
	ENDR

	ENDC

.loc_helpoffsets
	dcb.w	16,loc_note_filterH
	dcb.w	16,loc_pchg_filterH
	dcb.w	16,loc_pibe_filterH
	dcb.w	16,loc_press_filterH
	dcb.w	16,loc_cs_filterH
	dc.w	loc_inoutfilterH
	dc.w	loc_globalinfiltersH
	dc.w	loc_globaloutfiltersH
	dc.w	loc_note_filterH
	dc.w	loc_pchg_filterH
	dc.w	loc_pibe_filterH
	dc.w	loc_press_filterH
	dc.w	loc_cs_filterH
	dcb.w	5,loc_toggle_allH






;==============================================================
;
;  GADGETUP Event
;
;==============================================================

filtgadgetup
	lea	.filtGadgetTab(pc),a0
	jmp	gadgetjsrJ(a5)
.filtGadgetTab
	REPT	16
	dr.w	filter_note
	ENDR
	REPT	16
	dr.w	filter_pchg
	ENDR
	REPT	16
	dr.w	filter_pibe
	ENDR
	REPT	16
	dr.w	filter_press
	ENDR
	REPT	16
	dr.w	filter_controlsource
	ENDR
	dr.w	filter_inout
	dr.w	global_input_filters
	dr.w	global_output_filters
	dr.w	*
	dr.w	*
	dr.w	*
	dr.w	pressure_change
	dr.w	controlsource_change
	dr.w	toggle_all_note
	dr.w	toggle_all_pchg
	dr.w	toggle_all_pibe
	dr.w	toggle_all_press
	dr.w	toggle_all_cs



filter_note
	move.w	d1,d6
	tst.b	inout_filter(a5)
	bne.s	.out
	move.w	#note_ifilter,d5
	bra.s	.do
.out	move.w	#note_ofilter,d5
.do

do_filter	; d1 = GadgetID, d5 = filter-var, d6 = channel (0-15)
	move.w	(a5,d5.w),d7
	jsr	GetCheckboxFiltJ(a5)
	beq.s	.off
	bset	d6,d7
	bra.s	.set
.off	bclr	d6,d7
.set	move.w	d7,(a5,d5.w)
	rts




filter_pchg
	move.w	d1,d6
	sub.w	#GD_filt_pchg1,d6
	tst.b	inout_filter(a5)
	bne.s	.out
	move.w	#pchg_ifilter,d5
	bra.s	.do
.out	move.w	#pchg_ofilter,d5
.do	bra.s	do_filter



filter_pibe
	move.w	d1,d6
	sub.w	#GD_filt_pibe1,d6
	tst.b	inout_filter(a5)
	bne.s	.out
	move.w	#pibe_ifilter,d5
	bra.s	.do
.out	move.w	#pibe_ofilter,d5
.do	bra.s	do_filter



filter_press
	move.w	d1,d6
	sub.w	#GD_filt_press1,d6
	tst.b	mpress_or_ppress(a5)
	beq.s	.mpress

	tst.b	inout_filter(a5)
	bne.s	.pout
	move.w	#ppress_ifilter,d5
	bra.s	.do
.pout	move.w	#ppress_ofilter,d5
.do	bra.s	do_filter

.mpress
	tst.b	inout_filter(a5)
	bne.s	.mout
	move.w	#mpress_ifilter,d5
	bra.s	.do
.mout	move.w	#mpress_ofilter,d5
	bra.s	do_filter




filter_controlsource
	move.w	d1,d6
	sub.w	#GD_filt_cs1,d6
	tst.b	inout_filter(a5)
	bne.s	.out
	move.w	#cs_ifilters,d0
	bra.s	.do
.out	move.w	#cs_ofilters,d0
.do
	move.w	filtered_cs(a5),d1
	lea	codetab(a5),a1
	moveq	#0,d5
	move.b	(a1,d1.w),d5
	add.w	d5,d5
	add.w	d0,d5

	bra	do_filter






filter_inout
	jsr	GetCycleFiltJ(a5)
	move.b	d0,inout_filter(a5)
	bne.s	.out


	move.w	note_ifilter(a5),d5
	moveq	#GD_filt_note16,d6
	bsr	set_filter_row

	move.w	pchg_ifilter(a5),d5
	moveq	#GD_filt_pchg16,d6
	bsr	set_filter_row

	move.w	pibe_ifilter(a5),d5
	moveq	#GD_filt_pibe16,d6
	bsr	set_filter_row

	tst.b	mpress_or_ppress(a5)
	bne.s	.ipp
	move.w	mpress_ifilter(a5),d5
	bra.s	.ichg
.ipp	move.w	ppress_ifilter(a5),d5
.ichg	bra.s	.ochg


.out
	move.w	note_ofilter(a5),d5
	moveq	#GD_filt_note16,d6
	bsr	set_filter_row

	move.w	pchg_ofilter(a5),d5
	moveq	#GD_filt_pchg16,d6
	bsr	set_filter_row

	move.w	pibe_ofilter(a5),d5
	moveq	#GD_filt_pibe16,d6
	bsr	set_filter_row

	tst.b	mpress_or_ppress(a5)
	bne.s	.opp
	move.w	mpress_ofilter(a5),d5
	bra.s	.ochg
.opp	move.w	ppress_ofilter(a5),d5
.ochg	moveq	#GD_filt_press16,d6
	bsr.s	set_filter_row

	bra.s	refresh_cs_filters



pressure_change
	jsr	GetCycleFiltJ(a5)
	move.b	d0,mpress_or_ppress(a5)
	bne.s	.ppress

	tst.b	inout_filter(a5)
	bne.s	.mout
	move.w	mpress_ifilter(a5),d5
	bra.s	.change
.mout	move.w	mpress_ofilter(a5),d5
	bra.s	.change

.ppress	tst.b	inout_filter(a5)
	bne.s	.pout
	move.w	ppress_ifilter(a5),d5
	bra.s	.change
.pout	move.w	ppress_ofilter(a5),d5

.change	moveq	#GD_filt_press16,d6
	bra.s	set_filter_row




controlsource_change
	jsr	GetCycleFiltJ(a5)
	move.w	d0,filtered_cs(a5)


refresh_cs_filters
	tst.b	inout_filter(a5)
	bne.s	.out
	lea	cs_ifilters(a5),a0
	bra.s	.do
.out	lea	cs_ofilters(a5),a0
.do
	lea	codetab(a5),a1
	move.w	filtered_cs(a5),d0
	moveq	#0,d1
	IFEQ	mc68020
	move.b	(a1,d0.w),d1
	add.l	d1,d1
	move.w	(a0,d1.l),d5
	ELSE
	move.b	(a1,d0.w),d1
	move.w	(a0,d1.l*2),d5
	ENDC

	moveq	#GD_filt_cs16,d6
	bra.s	set_filter_row






toggle_all_note
	tst.b	inout_filter(a5)
	bne.s	.out
	move.w	#note_ifilter,d5
	bra.s	.do
.out	move.w	#note_ofilter,d5
.do	moveq	#GD_filt_note16,d6


toggle_row	; d5 = filter var-offset, d6 = last checkbox id
	not.w	(a5,d5.w)
	move.w	(a5,d5.w),d5

set_filter_row	; d5 = filterbits, d6 = last checkbox id
	moveq	#15,d7
.changeloop
	moveq	#0,d0
	btst	d7,d5
	sne	d0
	move.w	d6,d1
	jsr	SetCheckboxFiltJ(a5)
	subq.w	#1,d6
	dbf	d7,.changeloop
	rts




toggle_all_pchg
	tst.b	inout_filter(a5)
	bne.s	.out
	move.w	#pchg_ifilter,d5
	bra.s	.do
.out	move.w	#pchg_ofilter,d5
.do	moveq	#GD_filt_pchg16,d6
	bra.s	toggle_row




toggle_all_pibe
	tst.b	inout_filter(a5)
	bne.s	.out
	move.w	#pibe_ifilter,d5
	bra.s	.do
.out	move.w	#pibe_ofilter,d5
.do	moveq	#GD_filt_pibe16,d6
	bra.s	toggle_row




toggle_all_press
	tst.b	mpress_or_ppress(a5)
	bne.s	.ppress

	tst.b	inout_filter(a5)
	bne.s	.mout
	move.w	#mpress_ifilter,d5
	bra.s	.change
.mout	move.w	#mpress_ofilter,d5
	bra.s	.change

.ppress	tst.b	inout_filter(a5)
	bne.s	.pout
	move.w	#ppress_ifilter,d5
	bra.s	.change
.pout	move.w	#ppress_ofilter,d5

.change	moveq	#GD_filt_press16,d6
	bra.s	toggle_row




toggle_all_cs
	tst.b	inout_filter(a5)
	bne.s	.out
	move.w	#cs_ifilters,d5
	bra.s	.do
.out	move.w	#cs_ofilters,d5
.do	move.w	filtered_cs(a5),d0
	lea	codetab(a5),a1
	moveq	#0,d1
	move.b	(a1,d0.w),d1
	add.l	d1,d1
	add.w	d1,d5
	moveq	#GD_filt_cs16,d6
	bra	toggle_row





global_input_filters
	jsr	GetCheckboxFiltJ(a5)
	move.b	d0,global_infilters(a5)
	rts



global_output_filters
	jsr	GetCheckboxFiltJ(a5)
	move.b	d0,global_outfilters(a5)
	rts





;===================================================================

		rsreset
GD_filt_note1	rs.b	1
GD_filt_note2	rs.b	1
GD_filt_note3	rs.b	1
GD_filt_note4	rs.b	1
GD_filt_note5	rs.b	1
GD_filt_note6	rs.b	1
GD_filt_note7	rs.b	1
GD_filt_note8	rs.b	1
GD_filt_note9	rs.b	1
GD_filt_note10	rs.b	1
GD_filt_note11	rs.b	1
GD_filt_note12	rs.b	1
GD_filt_note13	rs.b	1
GD_filt_note14	rs.b	1
GD_filt_note15	rs.b	1
GD_filt_note16	rs.b	1

GD_filt_pchg1	rs.b	1
GD_filt_pchg2	rs.b	1
GD_filt_pchg3	rs.b	1
GD_filt_pchg4	rs.b	1
GD_filt_pchg5	rs.b	1
GD_filt_pchg6	rs.b	1
GD_filt_pchg7	rs.b	1
GD_filt_pchg8	rs.b	1
GD_filt_pchg9	rs.b	1
GD_filt_pchg10	rs.b	1
GD_filt_pchg11	rs.b	1
GD_filt_pchg12	rs.b	1
GD_filt_pchg13	rs.b	1
GD_filt_pchg14	rs.b	1
GD_filt_pchg15	rs.b	1
GD_filt_pchg16	rs.b	1

GD_filt_pibe1	rs.b	1
GD_filt_pibe2	rs.b	1
GD_filt_pibe3	rs.b	1
GD_filt_pibe4	rs.b	1
GD_filt_pibe5	rs.b	1
GD_filt_pibe6	rs.b	1
GD_filt_pibe7	rs.b	1
GD_filt_pibe8	rs.b	1
GD_filt_pibe9	rs.b	1
GD_filt_pibe10	rs.b	1
GD_filt_pibe11	rs.b	1
GD_filt_pibe12	rs.b	1
GD_filt_pibe13	rs.b	1
GD_filt_pibe14	rs.b	1
GD_filt_pibe15	rs.b	1
GD_filt_pibe16	rs.b	1

GD_filt_press1	rs.b	1
GD_filt_press2	rs.b	1
GD_filt_press3	rs.b	1
GD_filt_press4	rs.b	1
GD_filt_press5	rs.b	1
GD_filt_press6	rs.b	1
GD_filt_press7	rs.b	1
GD_filt_press8	rs.b	1
GD_filt_press9	rs.b	1
GD_filt_press10	rs.b	1
GD_filt_press11	rs.b	1
GD_filt_press12	rs.b	1
GD_filt_press13	rs.b	1
GD_filt_press14	rs.b	1
GD_filt_press15	rs.b	1
GD_filt_press16	rs.b	1

GD_filt_cs1	rs.b	1
GD_filt_cs2	rs.b	1
GD_filt_cs3	rs.b	1
GD_filt_cs4	rs.b	1
GD_filt_cs5	rs.b	1
GD_filt_cs6	rs.b	1
GD_filt_cs7	rs.b	1
GD_filt_cs8	rs.b	1
GD_filt_cs9	rs.b	1
GD_filt_cs10	rs.b	1
GD_filt_cs11	rs.b	1
GD_filt_cs12	rs.b	1
GD_filt_cs13	rs.b	1
GD_filt_cs14	rs.b	1
GD_filt_cs15	rs.b	1
GD_filt_cs16	rs.b	1

GD_inoutfilter	rs.b	1
GD_global_infilters	rs.b	1
GD_global_outfilters	rs.b	1

GD_note_filter	rs.b	1
GD_pchg_filter	rs.b	1
GD_pibe_filter	rs.b	1
GD_pressure	rs.b	1
GD_cs_filter	rs.b	1

GD_all_note	rs.b	1
GD_all_pchg	rs.b	1
GD_all_pibe	rs.b	1
GD_all_press	rs.b	1
GD_all_cs	rs.b	1


MTfilt_CNT	rs.b	1



FILT_CBOX_NOTE MACRO
	NEWGAD	150+(\1-1)*26,29+(\2-1)*14,26,11,volchan\1Text,-1,GD_filt_note\1,$0004
	ENDM

FILT_CBOX MACRO
	NEWGAD	150+(\2-1)*26,29+(\3-1)*14,26,11,*,-1,GD_filt_\1\2,$0004
	ENDM


MTfiltNGads

.ypos  = 28
.xsize = 144
.ysize = 14

.axpos  = 150+16*26+4
.axsize = 50

	FILT_CBOX_note 1,1
	FILT_CBOX_note 2,1
	FILT_CBOX_note 3,1
	FILT_CBOX_note 4,1
	FILT_CBOX_note 5,1
	FILT_CBOX_note 6,1
	FILT_CBOX_note 7,1
	FILT_CBOX_note 8,1
	FILT_CBOX_note 9,1
	FILT_CBOX_note 10,1
	FILT_CBOX_note 11,1
	FILT_CBOX_note 12,1
	FILT_CBOX_note 13,1
	FILT_CBOX_note 14,1
	FILT_CBOX_note 15,1
	FILT_CBOX_note 16,1

	FILT_CBOX pchg,1,2
	FILT_CBOX pchg,2,2
	FILT_CBOX pchg,3,2
	FILT_CBOX pchg,4,2
	FILT_CBOX pchg,5,2
	FILT_CBOX pchg,6,2
	FILT_CBOX pchg,7,2
	FILT_CBOX pchg,8,2
	FILT_CBOX pchg,9,2
	FILT_CBOX pchg,10,2
	FILT_CBOX pchg,11,2
	FILT_CBOX pchg,12,2
	FILT_CBOX pchg,13,2
	FILT_CBOX pchg,14,2
	FILT_CBOX pchg,15,2
	FILT_CBOX pchg,16,2

	FILT_CBOX pibe,1,3
	FILT_CBOX pibe,2,3
	FILT_CBOX pibe,3,3
	FILT_CBOX pibe,4,3
	FILT_CBOX pibe,5,3
	FILT_CBOX pibe,6,3
	FILT_CBOX pibe,7,3
	FILT_CBOX pibe,8,3
	FILT_CBOX pibe,9,3
	FILT_CBOX pibe,10,3
	FILT_CBOX pibe,11,3
	FILT_CBOX pibe,12,3
	FILT_CBOX pibe,13,3
	FILT_CBOX pibe,14,3
	FILT_CBOX pibe,15,3
	FILT_CBOX pibe,16,3

	FILT_CBOX press,1,4
	FILT_CBOX press,2,4
	FILT_CBOX press,3,4
	FILT_CBOX press,4,4
	FILT_CBOX press,5,4
	FILT_CBOX press,6,4
	FILT_CBOX press,7,4
	FILT_CBOX press,8,4
	FILT_CBOX press,9,4
	FILT_CBOX press,10,4
	FILT_CBOX press,11,4
	FILT_CBOX press,12,4
	FILT_CBOX press,13,4
	FILT_CBOX press,14,4
	FILT_CBOX press,15,4
	FILT_CBOX press,16,4

	FILT_CBOX cs,1,5
	FILT_CBOX cs,2,5
	FILT_CBOX cs,3,5
	FILT_CBOX cs,4,5
	FILT_CBOX cs,5,5
	FILT_CBOX cs,6,5
	FILT_CBOX cs,7,5
	FILT_CBOX cs,8,5
	FILT_CBOX cs,9,5
	FILT_CBOX cs,10,5
	FILT_CBOX cs,11,5
	FILT_CBOX cs,12,5
	FILT_CBOX cs,13,5
	FILT_CBOX cs,14,5
	FILT_CBOX cs,15,5
	FILT_CBOX cs,16,5

	NEWGAD	3,2,.xsize,.ysize-1,*,-1,GD_inoutfilter,$0004
	NEWGAD	350,2,26,11,*,loc_globalinfilters,GD_global_infilters,$0001
	NEWGAD	592,2,26,11,*,loc_globaloutfilters,GD_global_outfilters,$0001
	NEWGAD	3,.ypos,.xsize,.ysize-1,*,-1,GD_note_filter,$0000
	NEWGAD	3,.ypos+.ysize,.xsize,.ysize-1,*,-1,GD_pchg_filter,$0000
	NEWGAD	3,.ypos+2*.ysize,.xsize,.ysize-1,*,-1,GD_pibe_filter,$0000
	NEWGAD	3,.ypos+3*.ysize,.xsize,.ysize-1,*,-1,GD_pressure,$0004
	NEWGAD	3,.ypos+4*.ysize,.xsize,.ysize-1,*,-1,GD_cs_filter,$0004

	NEWGAD	.axpos,.ypos,.axsize,.ysize-1,*,loc_toggleall,GD_all_note,$0010
	NEWGAD	.axpos,.ypos+.ysize,.axsize,.ysize-1,*,loc_toggleall,GD_all_pchg,$0010
	NEWGAD	.axpos,.ypos+2*.ysize,.axsize,.ysize-1,*,loc_toggleall,GD_all_pibe,$0010
	NEWGAD	.axpos,.ypos+3*.ysize,.axsize,.ysize-1,*,loc_toggleall,GD_all_press,$0010
	NEWGAD	.axpos,.ypos+4*.ysize,.axsize,.ysize-1,*,loc_toggleall,GD_all_cs,$0010



MTfiltGTags

	REPT	16*5
	DC.L	$80080004,1
	DC.L	$00000000
	ENDR

	DC.L	$8008000E,inoutLabels
MTfiltGTinout = *+7-MTfiltGTags
	DC.L	$8008000f,0		; active label
	DC.L	$00000000

MTfiltGTglobin = *+7-MTfiltGTags
	DC.L	$80080004,1
	DC.L	$00000000
MTfiltGTglobout = *+7-MTfiltGTags
	DC.L	$80080004,1
	DC.L	$00000000

MTfiltGTnote = *+4-MTfiltGTags
	DC.L	$8008000B,0
	DC.L	$8008004a,2
	DC.L	$80080039,1
	DC.L	$00000000

MTfiltGTpchg = *+4-MTfiltGTags
	DC.L	$8008000B,0
	DC.L	$8008004a,2
	DC.L	$80080039,1
	DC.L	$00000000

	DC.L	$8008000B,pitchbendString
	DC.L	$8008004a,2
	DC.L	$80080039,1
	DC.L	$00000000

	DC.L	$8008000E,pressLabels
MTfiltGTpress = *+7-MTfiltGTags
	DC.L	$8008000f,0
	DC.L	$00000000

MTfiltGTcslabs = *+4-MTfiltGTags
	DC.L	$8008000E,0
MTfiltGTcsfilt = *+6-MTfiltGTags
	DC.L	$8008000f,0
	DC.L	$00000000

	DC.L	$00000000
	DC.L	$00000000
	DC.L	$00000000
	DC.L	$00000000
	DC.L	$00000000


MTfiltGTypes
		DCb.b	16*5,2
		dc.b	7,2,2,13,13,13,7,7,1,1,1,1,1




pitchbendString	dc.b	'Pitchbend',0

pressLab0	dc.b	'Aftertouch',0
pressLab1	dc.b	'Poly Pressure',0

		even



inoutLabels
	dc.w	1,loc_inputfilter
	dc.w	1,loc_outputfilter

	dc.l	0


pressLabels
	dc.w	-1
	dr.w	pressLab0

	dc.w	-1
	dr.w	pressLab1

	dc.l	0




MTfiltWindowTags
	DC.L	$80000064,0
	DC.L	$80000065,0
	DC.L	$80000066,0
	DC.L	$80000067,0
	DC.L	$8000006B,filtWFlags
MTfiltWG = *+4-MTfiltWindowTags
	DC.L	$8000006C,0
MTfiltWT = *+4-MTfiltWindowTags
	DC.L	$8000006E,0
MTfiltST = *+4-MTfiltWindowTags
	DC.L	$8000006F,0
MTfiltSC = *+4-MTfiltWindowTags
	DC.L	$80000079,0
	DC.L	$80000090,1
MTfiltHG = *+4-MTfiltWindowTags
	dc.l	$8000009b,0		; Help Group (V39)
	DC.L	$00000000


