;APS00000A2F00004B1C0000000000000000000000000000000000000000000000000000000000000000
;==============================================================
;
;                     L O C A L E 
;
;==============================================================


;==============================================================
;
;  CatalogString von Locale holen
;
;==============================================================

getcatstring	; d0.w=number
		; zurck: a1=locale String

	movem.l	d1/a0/a6,-(sp)

	IFEQ	mc68020
	move.w	d0,d1
	lsl.w	#2,d1
	lea	.locale_strings(pc,d1.w),a1
	ELSE
	lea	.locale_strings(pc,d0.w*4),a1
	ENDC
	adda.l	(a1),a1

	move.l	locbas(a5),d1
	beq.s	.noloc
	move.l	d1,a6
	ext.l	d0
	move.l	catalog(a5),a0
	jsr	GetCatalogStr(a6)
	move.l	d0,a1
.noloc	movem.l	(sp)+,d1/a0/a6
	rts


;==============================================================
;
; string pointers
;
;==============================================================

.locale_strings

	include	miditracker/mt-strings.S



;==============================================================
;
;  Catalog laden
;
;==============================================================

load_catalog
	move.l	locbas(a5),d0
	beq.s	.noloc
	move.l	d0,a6
	suba.l	a0,a0
	lea	mtcatname(pc),a1	; "MidiTracker.catalog"
	lea	.catalogtags(pc),a2
	jsr	OpenCatalogA(a6)
	move.l	d0,catalog(a5)

	IFEQ deutsch_locale
	suba.l	a0,a0
	ELSE
	lea	.deutsch_locale(pc),a0
	ENDC
	jsr	OpenLocale(a6)
	move.l	d0,locale(a5)

.noloc	rts



.catalogtags	; version must match Catalog's version exactly !
	dc.l	$80090003,CATALOG_VERSION
	IFNE	deutsch_locale
	dc.l	$80090004,.language	; preferred language (test)
	ENDC
	dc.l	0


	IFNE	deutsch_locale

.language	dc.b	'deutsch',0
.deutsch_locale	dc.b	'LOCALE:Languages/deutsch.language',0
		even

	ENDC



;==============================================================
;
;  Catalog freigeben
;
;==============================================================

unload_catalog
	move.l	locbas(a5),d0
	beq.s	.norm1
	move.l	d0,a6
	move.l	catalog(a5),d0
	beq.s	.norm2
	move.l	d0,a0
	jsr	CloseCatalog(a6)
	clr.l	catalog(a5)

.norm2	move.l	locale(a5),a0
	jsr	CloseLocale(a6)

.norm1	rts


