            H  *                    
mc68020 equ 1


	include	includes/exec.i
	include	includes/devices.i
	include	includes/dos.i
	include	includes/cia.i
	include	includes/misc.i
	include	includes/timer.i
	include	includes/utility.i
	include	dh0:asm/includes/miditracker.i


	include	miditracker/mt-equs.s

			rsset	so_sizeof
soX_channels_maps	rs.w	16
soX_channelnames	rs.b	16*channelname_len
soX_positions		rs.w	0





s
	lea	dosnam(pc),a1
	moveq	#36,d0
	move.l	$4.w,a6
	jsr	OpenLibrary(a6)
	tst.l	d0
	beq.s	.nodos
	move.l	d0,a6

	lea	libidstring(pc),a0
	move.l	a0,d1
	jsr	PutStr(a6)

	move.l	a6,a1
	move.l	$4.w,a6
	jsr	CloseLibrary(a6)

.nodos	moveq	#0,d0
	rts



dosnam		dc.b	'dos.library',0
mtnam		dc.b	'miditracker.library',0
libidstring	dc.b	'$VER: miditracker.library 1.0 (07.05.1997)',13,10,0
		even



;======================================================
;  lib-start


libresident
	illegal
	dc.l	libresident
	dc.l	endresident
	dc.b	$80		; flags
	dc.b	1		; version
	dc.b	9,0		; type, pri
	dc.l	mtnam
	dc.l	libidstring
	dc.l	libinitdata


libinitdata
	dc.l	lib_sizeof
	dc.l	functab
	dc.l	datatab
	dc.l	libinitrout


LIBENTRY MACRO
	dc.w	lib_\1-functab
	ENDM


functab
	dc.w	-1

;=== library internals

	LIBENTRY mtOpen
	LIBENTRY mtClose
	LIBENTRY mtExpunge
	LIBENTRY mtExtFunc


;=== miditracker internals

;	LIBENTRY mtReadMIDI
;	LIBENTRY mtWriteMIDI


;=== miditracker public

	LIBENTRY mtInit
	LIBENTRY mtFree
	LIBENTRY mtPlay
	LIBENTRY mtStop
	LIBENTRY mtContinue
	LIBENTRY mtPause
	LIBENTRY mtInfo

	dc.l	-1


datatab
	dc.b	$e0,0
	dc.w	8
	dc.b	9,0		; type, pri

	dc.b	$c0,0
	dc.w	10
	dc.l	mtnam		; libname

	dc.b	$e0,0
	dc.w	14
	dc.b	6,0		; flags

	dc.b	$c0,0
	dc.w	20
	dc.w	1,0		; version, revision

	dc.b	$c0,0
	dc.w	24
	dc.l	libidstring	; ascii IDstring

	dc.l	0


libinitrout
	movem.l	a0/a5,-(sp)
	move.l	d0,a5

	move.l	a0,seglist(a5)
	move.l	$4.w,exec(a5)

	lea	tbe_irq+$e(pc),a0
	move.l	a5,(a0)

	st	serialoutreadysig(a5)

	move.l	a5,d0
	movem.l	(sp)+,a0/a5
	rts



lib_mtOpen
	bclr	#3,14(a6)
	addq.w	#1,32(a6)
	move.l	a6,d0
	rts


lib_mtClose
	moveq	#0,d0
	subq.w	#1,32(a6)
	bne.s	.close

	btst	#3,14(a6)
	beq.s	.close
	bsr	lib_mtExpunge

.close	rts



lib_mtExpunge
	movem.l	d2/a4/a6,-(sp)

	tst.w	32(a6)
	beq.s	.do_expunge

	moveq	#0,d0
	bset	#3,14(a6)
	bra.s	.expunge_end

.do_expunge
	move.l	a6,a4

	move.l	a4,a1
	move.l	$4.w,a6
	jsr	Remove(a6)

	move.l	34(a4),d2

	moveq	#0,d0
	move.w	16(a4),d0
	move.l	a4,a1
	suba.l	d0,a1
	add.w	18(a4),d0
	jsr	FreeMem(a6)

	move.l	d2,d0

.expunge_end
	movem.l	(sp)+,d2/a4/a6
	rts



lib_mtExtFunc
	moveq	#0,d0
	rts






;lib_mtInitMainProgram
;	movem.l	a5-a6,-(sp)
;	move.l	a6,a5

;	movem.l	(sp)+,a5-a6
;	rts




;lib_mtReadMIDI
;	movem.l	a5-a6,-(sp)
;	move.l	a6,a5

;	movem.l	(sp)+,a5-a6
;	rts





;lib_mtWriteMIDI
;	movem.l	a5-a6,-(sp)
;	move.l	a6,a5

;	movem.l	(sp)+,a5-a6
;	rts







lib_mtPlay	; a1 = ^taglist (may be NULL)
		; returns: d0 = pos/neg for failure

	movem.l	d2/a5-a6,-(sp)
	move.l	a6,a5


;=== check out the tags
	move.l	a1,d2
	beq.s	.notags

	move.l	#MTP_MidiTimeCode,d0
	moveq	#0,d1
	move.l	utilbas(a5),a6
	jsr	GetTagData(a6)
	move.b	d0,send_mtc(a5)

	move.l	#MTP_PlayDisabledTracks,d0
	moveq	#0,d1
	move.l	d2,a0
	jsr	GetTagData(a6)
	move.b	d0,playdisabled(a5)

	tst.b	cia_or_midilib(a5)
	beq.s	.nomidi
	move.l	#MTP_PlaySamples,d0
	moveq	#0,d1
	move.l	d2,a0
	jsr	GetTagData(a6)
	move.b	d0,samples_active(a5)
.nomidi

	bra.s	.tagcont

.notags	sf	send_mtc(a5)
	sf	playdisabled(a5)
	sf	samples_active(a5)

.tagcont



	tst.b	cia_set(a5)
	beq.s	.stoped
	move.l	a5,a6
	bsr	lib_mtStop
.stoped


	st	playflag(a5)
	st	mtc_frameflag(a5)	; initialize midi time code frame



	bsr	start_replay
	beq.s	.neg


	moveq	#1,d0
.norm	movem.l	(sp)+,d2/a5-a6
	rts

.neg	moveq	#0,d0
	bra.s	.norm




start_replay
	tst.b	cia_or_midilib(a5)
	bne	.midilib


;=== SysTime merken
	lea	timervalinit(a5),a0
	move.l	timerio(a5),a6
	move.l	$14(a6),a6
	jsr	GetSysTime(a6)


;=== set interrupt code
	lea	cia_irq(pc),a1
	move.l	a5,14(a1)
	moveq	#0,d0			; Timer A
	move.l	ciares(a5),a6
	jsr	AddICRVector(a6)
	tst.l	d0
	bne.s	.neg


;=== stop timer
	move.l	$22(a6),a0
	and.b	#%11100010,ciacra(a0)


	move.w	playtempo(a5),d1
	bsr	calc_tempo

;=== start timer
	or.b	#$01,ciacra(a0) ; start cia, either one-shot or cont.

	st	cia_set(a5)

.pos	POSITIV
.neg	NEGATIV



.midilib
	move.w	playtempo(a5),d1
	bsr	calc_tempo

	move.b	playsignal(a5),d1
	bsr	put_player_signal

	bra.s	.pos






cia_irq
	dc.l	0,0
	dc.b	2,1
	dc.l	ciairqname
	dc.l	0		; user data
	dc.l	.irqcode




.irqcode
	tst.b	autostopped(a1)
	bne.s	.notrigger
;	tst.b	playflag(a1)
;	beq.s	.notrigger
;	tst.b	replay_paused(a1)
;	bne.s	.notrigger

	movem.l	d0-d1/a0-a1/a6,-(sp)

	move.l	a1,a0
	lea	.replay_irq(pc),a1
	move.b	#2,8(a1)
	move.l	a0,14(a1)
	move.l	exec(a0),a6
	jsr	Cause(a6)

	movem.l	(sp)+,d0-d1/a0-a1/a6
.notrigger
	moveq	#0,d0
	rts




.replay_irq
	dc.l	0,0
	dc.b	2,0
	dc.l	replayname
	dc.l	0		; user data
	dc.l	.replayirqcode


.replayirqcode
	movem.l	d0-d7/a0-a6,-(sp)
	move.l	a1,a5

	subq.b	#1,ciacount(a5)
	bne.s	.irqout
	move.b	ciacountinit(a5),ciacount(a5)

;	bsr	createmidi
;	beq.s	.autostop

.irqout
	movem.l	(sp)+,d0-d7/a0-a6
	moveq	#0,d0
	rts

.autostop
	st	autostopped(a5)
	bra.s	.irqout





calc_tempo	; d1=new tempo in bpm
;	bsr.s	check_external_clock
;	bne.s	.skip_cia

	tst.b	cia_or_midilib(a5)
	bne.s	.midilib

	moveq	#1,d0
.multiloop
	cmp.w	#2800,d1
	bcc.s	.ok
	add.w	d1,d1
	add.w	d0,d0
	bra.s	.multiloop
.ok
	move.w	d0,ciacount(a5)
	move.w	d0,ciacountinit(a5)

	move.l	ciafreq(a5),d0
	divu	d1,d0
	move.l	ciares(a5),a0
	move.l	$22(a0),a0
	move.w	#$0008,$dff09a
	move.b	d0,ciatalo(a0)
	lsr.w	#8,d0
	move.b	d0,ciatahi(a0)
	move.w	#$8008,$dff09a

.skip_cia
	rts

.midilib
	move.l	#250000000,d0
	ext.l	d1
	LONGDIVU
	move.l	#1000000,d1
	LONGDIVU
	movem.l	d0-d1,midilib_tempo(a5)
	rts








lib_mtStop
	movem.l	a5-a6,-(sp)
	move.l	a6,a5

	tst.b	cia_or_midilib(a5)
	bne.s	.midilib

	tst.b	cia_set(a5)
	beq.s	.nocia

	lea	cia_irq(pc),a1
	moveq	#0,d0			; Timer A
	move.l	ciares(a5),a6
	jsr	RemICRVector(a6)
	sf	cia_set(a5)
.nocia

.out
	bsr	ResetNotesAndControllers

	movem.l	(sp)+,a5-a6
	rts


.midilib
	move.b	stopsignal(a5),d1
	bsr	put_player_signal
	bra.s	.out




lib_mtContinue
	movem.l	a5-a6,-(sp)
	move.l	a6,a5




	movem.l	(sp)+,a5-a6
	rts





ResetNotesAndControllers

	move.l	mtsong(a5),a4

;=== reset all note-ons

	move.l	playcounters(a5),a3
	move.w	chanc(a5),d0
	move.w	d0,d1		; = mulu #15,d0
	lsl.w	#4,d0		;
	sub.w	d1,d0		;
	adda.w	csc(a5),a3
	adda.w	d0,a3
	moveq	#15,d6
.channelloop2

	lea	soX_channels_maps(a4),a0
	IFEQ	mc68020
	move.w	d6,d0
	add.w	d0,d0
	move.w	(a0,d0.w),d7
	ELSE
	move.w	(a0,d6.w*2),d7
	ENDC

	move.l	maxtracks_m1(a5),d5
	IFEQ	pc_sizeof-6
	move.w	d5,d0
	add.w	d0,d5
	add.w	d0,d5
	add.w	d5,d5
	ELSE
	mulu	#pc_sizeof,d5
	ENDC
.trackloop2
	move.b	pc_oldnote(a3,d5.w),d4
	bmi.s	.next
	st	pc_oldnote(a3,d5.w)		; set note to OFF

;=== consider remapping information and channel-transposes
	lea	so_desttranss(a4),a0
	moveq	#15,d3
.remaploop
	btst	d3,d7
	beq.s	.nomap

	move.b	d4,d1
	bsr	dest_transpose
	moveq	#-$80,d0
	or.b	d3,d0
	move.b	pc_oldvel(a3,d5.w),d2
	bsr	send_3_bytes

.nomap	dbf	d3,.remaploop


.next	subq.w	#pc_sizeof,d5
	bcc.s	.trackloop2


	bsr.s	ResetControllers

	suba.w	chanc(a5),a3
	dbf	d6,.channelloop2

	rts




ResetControllers	; d6=channel

;=== reset all Controllers

	moveq	#-$50,d0
	or.b	d6,d0
	lea	codetab(a5),a1
	lea	default_panic_codes(pc),a2
	move.l	active_csources_m1(a5),d7
.controllerloop
	moveq	#0,d1
	move.b	(a1,d7.w),d1
	move.b	(a2,d1.l),d2
	bsr	send_3_bytes
.skip	dbf	d7,.controllerloop


;=== Pitchbend reset

	moveq	#-$20,d0
	or.b	d6,d0
	moveq	#0,d1
	moveq	#$40,d2
	bsr	send_3_bytes


;=== MPress reset

	moveq	#-$30,d0
	or.b	d6,d0
	moveq	#0,d1
	bra	send_2_bytes




default_panic_codes
		dc.b	0,0,0,0,0,0,0,127,64,0	;   0-  9
		dc.b	64,127,0,0,0,0,0,0,0,0	;  10- 19
		dc.b	0,0,0,0,0,0,0,0,0,0
		dc.b	0,0,0,0,0,0,0,0,0,0
		dc.b	0,0,0,0,0,0,0,0,0,0
		dc.b	0,0,0,0,0,0,0,0,0,0
		dc.b	0,0,0,0,0,0,0,0,0,0
		dc.b	0,0,0,0,0,0,0,0,0,0
		dc.b	0,0,0,0,0,0,0,0,0,0
		dc.b	0,0,0,0,0,0,0,0,0,0
		dc.b	0,0,0,0,0,0,0,0,0,0	; 100-109
		dc.b	0,0,0,0,0,0,0,0,0,0
		dc.b	0,0,0,0,0,0,0,0		; 120-127





lib_mtPause
	movem.l	a5-a6,-(sp)
	move.l	a6,a5



	movem.l	(sp)+,a5-a6
	rts




lib_mtInfo
	movem.l	a5-a6,-(sp)
	move.l	a6,a5



	movem.l	(sp)+,a5-a6
	rts





lib_mtInit	; a0 = ^miditracker-songmodule
		; a1 = ^tags

	movem.l	a5-a6,-(sp)
	move.l	a6,a5

	tst.l	mtsong(a5)
	beq.s	.empty
	movem.l	a0-a1,-(sp)
	move.l	a5,a6
	bsr	lib_mtStop
	bsr	lib_mtFree
	movem.l	(sp)+,a0-a1
.empty


	addq.w	#8,a0		; skip header
	move.l	a0,mtsong(a5)
	move.l	a1,d2


	lea	utilnam(pc),a1
	moveq	#37,d0
	move.l	exec(a5),a6
	jsr	OpenLibrary(a6)
	move.l	d0,utilbas(a5)
	beq	.neg


;=== check out the tags
	tst.l	d2
	beq.s	.notags

	move.l	#MTI_ReplayMethod,d0
	moveq	#0,d1
	move.l	d2,a0
	move.l	utilbas(a5),a6
	jsr	GetTagData(a6)
	move.b	d0,cia_or_midilib(a5)

	bra.s	.tagcont

.notags	sf	cia_or_midilib(a5)

.tagcont



	tst.b	cia_or_midilib(a5)
	bne.s	.midilib


	lea	serialoutpuffer(a5),a0
	move.l	a0,irqptr_out(a5)
	move.l	a0,writeptr_out(a5)
	lea	serialoutsize(a0),a0
	move.l	a0,upperlimit_out(a5)


	bsr	OpenTimer
	beq	.neg

	lea	cianam(pc),a1
	move.l	exec(a5),a6
	jsr	OpenResource(a6)
	move.l	d0,ciares(a5)
	beq	.neg

;=== read cia clock value, calc tempo
	subq.w	#8,sp
	move.l	sp,a0
	move.l	timerio(a5),a6
	move.l	$14(a6),a6
	jsr	ReadEClock(a6)
	addq.w	#8,sp
	divu	#50,d0
	ext.l	d0
	mulu	#125*100,d0
	move.l	d0,ciafreq(a5)

	bsr	OpenHardwareSerial
	beq	.neg

	bra.s	.method_done


.midilib
	bsr	LaunchPlayerProcess
	beq	.neg


.method_done




;=== replaypuffer
	move.l	#replaysize*2,d0
	moveq	#1,d1
	move.l	exec(a5),a6
	jsr	AllocVec(a6)
	move.l	d0,replaypuffer(a5)
	beq.s	.neg
	add.l	#replaysize,d0
	move.l	d0,replaypufferopt(a5)




	bsr	prepare_songtables
	beq.s	.neg




;=== allocate playcounters

	moveq	#prec3,d0
	move.l	active_csources(a5),d1
	mulu	#pcc_sizeof,d1
	add.l	d1,d0
	move.w	d0,csc(a5)

	move.l	mtsong(a5),a0
	move.l	so_maxtracks(a0),d1
	mulu	#pc_sizeof,d1
	add.l	d1,d0
	move.w	d0,chanc(a5)

	lsl.l	#4,d0
	moveq	#1,d1
	move.l	exec(a5),a6
	jsr	AllocVec(a6)
	move.l	d0,playcounters(a5)
	beq.s	.neg


	bsr	init_playcounters




	moveq	#1,d0
.norm	movem.l	(sp)+,a5-a6
	rts

.neg	move.l	a5,a6
	bsr	lib_mtFree
	moveq	#0,d0
	bra.s	.norm




FreeLib	; a0 = ^libbase
	move.l	(a0),d0
	beq.s	.nolib
	move.l	d0,a1
	clr.l	(a0)
	move.l	exec(a5),a6
	jmp	CloseLibrary(a6)
.nolib	rts






prepare_songtables
	move.l	mtsong(a5),a4


;=== do not support old versions

	cmp.l	#'MTSO',-8(a4)
	bne	.neg
	cmp.w	#'NG',-4(a4)
	bne	.neg
	cmp.w	#10,-2(a4)
	bmi	.neg



;=== init song-pointers

	lea	soX_positions(a4),a0
	move.l	so_length(a4),d0
	move.l	d0,length(a5)
	IFEQ	mc68020
	add.l	d0,d0
	move.l	a0,a1
	adda.l	d0,a1
	ELSE
	lea	(a0,d0.l*2),a1
	ENDC
	move.l	a1,soX_sysexs(a5)


	move.l	so_sysexmsgs(a4),d2
	bra.s	.syxin
.sysexloop
	adda.l	(a1)+,a1
.syxin	subq.l	#1,d2
	bcc.s	.sysexloop
	move.l	a1,soX_patterns(a5)



	move.l	so_patterntablen(a4),d0
	lsl.l	#2,d0
	move.l	#$10001,d1
	move.l	exec(a5),a6
	jsr	AllocVec(a6)
	move.l	d0,patterntab(a5)
	beq	.neg


	move.w	so_bpm(a4),playtempo(a5)

	move.b	so_loopsong(a4),loopsong(a5)
	move.l	so_looppos(a4),looppos(a5)
	move.w	so_mastervolume(a4),mastervolume(a5)

	movem.l	so_chansliders(a4),d0-d3
	movem.l	d0-d3,channelsliders(a5)

	movem.l	so_desttranss(a4),d0-d3
	movem.l	d0-d3,desttranss(a5)

	movem.l	so_pchgtypes(a4),d0-d3
	movem.l	d0-d3,pchgtypes(a5)



	move.l	soX_patterns(a5),a4

.patternread

	lea	disk_pattern(a5),a1
	moveq	#pts_sizeof,d0
	bsr	ReadBytes

	tst.l	disk_pattern(a5)
	beq	.out


	move.w	disk_pattern+pts_pattnum(a5),d0
	bsr	AllocPattern
	beq	.harderror
	move.l	a0,a2
	move.l	a2,currentpatternA(a5)
	move.l	disk_pattern+pts_events(a5),pt_events(a2)
	move.w	disk_pattern+pts_chanmask(a5),pt_chanmask(a2)


;=== evtl. bpmtrack laden
	move.l	disk_pattern+pts_bpmsize(a5),d0
	beq.s	.nobpm
	move.l	d0,d2
	moveq	#1,d1
	jsr	AllocVec(a6)
	move.l	d0,pt_bpmtrack(a2)
	beq	.harderror
	move.l	d0,a1
	move.l	disk_pattern+pts_bpmsize(a5),d0
	bsr	ReadBytes
.nobpm


	moveq	#15,d6
.channelread
;=== Channel laden
	move.w	disk_pattern+pts_channels(a5),d0
	btst	d6,d0
	beq	.nochan

	bsr	AllocChannel
	beq	.harderror
	move.l	a0,a3
	move.w	d6,d0
	lsl.w	#2,d0
	move.l	currentpatternA(a5),a0
	move.l	a3,pt_channels(a0,d0.w)
	lea	disk_channel(a5),a1
	moveq	#chs_sizeof,d0
	bsr	ReadBytes

	move.w	disk_channel+chs_scale(a5),ch_scale(a3)
	move.w	disk_channel+chs_numcs(a5),ch_numcs(a3)
	move.b	disk_channel+chs_pb_onoff(a5),ch_pb_onoff(a3)
	move.b	disk_channel+chs_mp_onoff(a5),ch_mp_onoff(a3)
	move.w	disk_channel+chs_numtracks(a5),ch_numtracks(a3)

;=== ptrack laden
	move.l	disk_channel+chs_ptracksize(a5),d0
	beq.s	.noptrk
	moveq	#1,d1
	jsr	AllocVec(a6)
	move.l	d0,ch_ptrack(a3)
	beq	.harderror
	move.l	d0,a1
	move.l	disk_channel+chs_ptracksize(a5),d0
	bsr	ReadBytes
.noptrk

;=== pbtrack laden
	move.l	disk_channel+chs_pbtracksize(a5),d0
	beq.s	.nopbtrk
	moveq	#1,d1
	jsr	AllocVec(a6)
	move.l	d0,ch_pbtrack(a3)
	beq	.harderror
	move.l	d0,a1
	move.l	disk_channel+chs_pbtracksize(a5),d0
	bsr	ReadBytes
.nopbtrk

;=== mptrack laden
	move.l	disk_channel+chs_mptracksize(a5),d0
	beq.s	.nomptrk
	moveq	#1,d1
	jsr	AllocVec(a6)
	move.l	d0,ch_mptrack(a3)
	beq	.harderror
	move.l	d0,a1
	move.l	disk_channel+chs_mptracksize(a5),d0
	bsr	ReadBytes
.nomptrk


;=== csources Tracks laden
	move.w	ch_numcs(a3),d5
	beq	.noctracks
	lea	ch_csources(a3),a2
.ctrackread

	lea	disk_csource(a5),a1
	moveq	#css_sizeof,d0
	bsr	ReadBytes

	moveq	#cs_sizeof,d0
	add.l	disk_csource+css_datasize(a5),d0
	moveq	#1,d1
	jsr	AllocVec(a6)
	move.l	d0,(a2)
	beq	.harderror
	move.l	d0,a1
	move.b	disk_csource+css_parameter(a5),cs_parameter(a1)
	move.b	disk_csource+css_onoff(a5),cs_onoff(a1)
	move.l	disk_csource+css_datasize(a5),cs_datasize(a1)


	move.b	cs_parameter(a1),d0
	bsr	add_new_controlsource
	beq	.harderror


	lea	cs_sizeof(a1),a1
	move.l	cs_datasize(a0),d0
	bsr	ReadBytes

	move.l	(a2),a2
	subq.w	#1,d5
	bne	.ctrackread
	clr.l	(a2)
.noctracks


;=== Normale Tracks laden
	move.w	ch_numtracks(a3),d5
	beq.s	.notracks
	lea	ch_tracks(a3),a2
.trackread

	lea	disk_track(a5),a1
	moveq	#trs_sizeof,d0
	bsr	ReadBytes

	moveq	#tr_sizeof,d0
	add.l	disk_track+trs_datasize(a5),d0
	moveq	#1,d1
	jsr	AllocVec(a6)
	move.l	d0,(a2)
	beq	.harderror
	move.l	d0,a1
	move.w	disk_track+trs_number(a5),tr_number(a1)
	move.b	disk_track+trs_onoff(a5),tr_onoff(a1)
	move.l	disk_track+trs_datasize(a5),tr_datasize(a1)

	move.l	tr_datasize(a1),d0
	lea	tr_sizeof(a1),a1
	bsr	ReadBytes

	move.l	(a2),a2
	subq.w	#1,d5
	bne.s	.trackread
	clr.l	(a2)
.notracks



.nochan	dbf	d6,.channelread

	bra	.patternread

.out


	POSITIV
.harderror
.neg	NEGATIV





ReadBytes	; a4 = source, a1 = dest, d0 = len

.loop	move.b	(a4)+,(a1)+
	subq.l	#1,d0
	bne.s	.loop
	rts







AllocPattern	; d0.w=newpattern
		; zurck: d0=pos/neg, a0=^NewPattern

	ext.l	d0
	move.l	d0,d2

	bsr.s	AllocPatternDry
	beq.s	.fail

	move.l	patterntab(a5),a1	; in patterntab schreiben
	IFEQ	mc68020
	lsl.l	#2,d2
	move.l	a0,(a1,d2.l)
	ELSE
	move.l	a0,(a1,d2.l*4)
	ENDC
	POSITIV

.fail	NEGATIV




AllocPatternDry	; zurck: a0=^pattern (schreibt aber nicht in patterntab)
	moveq	#pt_sizeof,d0
	move.l	#$10001,d1
	move.l	exec(a5),a6
	jsr	AllocMem(a6)
	tst.l	d0
	beq.s	.neg
	move.l	d0,a0			; einiges initialisieren

	POSITIV
.neg	NEGATIV




AllocChannel	; zurck: a0=^channel (NICHT IN D0!!!)
;=== gibt Channel zurck, wird aber nicht ins Pattern eingetragen
	moveq	#ch_sizeof,d0
	move.l	#$10001,d1
	move.l	exec(a5),a6
	jsr	AllocMem(a6)
	tst.l	d0
	beq.s	.neg
	move.l	d0,a0

	POSITIV
.neg	NEGATIV








;=== add controlsource if not already allocated

add_new_controlsource	; d0=new parameter

	lea	codetab(a5),a0
	move.l	active_csources_m1(a5),d1
.paramloop
	cmp.b	(a0)+,d0
	dbeq	d1,.paramloop
	beq.s	.itshere

	bra.s	AddControlsource

.itshere
	rts







AddControlSource	; d0.b = parameter number
			; returns: pos/neg

;=== Make sure the new csource is not yet in the list!

	lea	codetab(a5),a0
	move.l	active_csources(a5),d1
	bra.s	.insin

.insertloop

	move.b	(a0,d1.l),d2
	cmp.b	d2,d0
	bhi.s	.ins
	move.b	d2,1(a0,d1.l)

.insin	subq.l	#1,d1
	bcc.s	.insertloop

.ins	move.b	d0,1(a0,d1.l)

	addq.l	#1,active_csources(a5)
	addq.l	#1,active_csources_m1(a5)
	rts





;PutActiveCsources	; d0.l=number of active csources
;	move.l	d0,active_csources(a5)
;	subq.l	#1,d0
;	move.l	d0,active_csources_m1(a5)
;	rts





OpenTimer
;=== Replyport fr Timer initiieren
	move.l	exec(a5),a6
	jsr	CreateMsgPort(a6)
	move.l	d0,TimerReply(a5)
	beq.s	.neg

	move.l	d0,a0
	moveq	#$28,d0
	jsr	CreateIORequest(a6)
	move.l	d0,timerio(a5)
	beq.s	.neg2

	move.l	d0,a1
	move.b	#$05,$9(a1)		; Pri

	lea	timnam(pc),a0
	move.l	a0,$a(a1)
	moveq	#0,d0			; unit_MICROHZ
	moveq	#0,d1
	jsr	OpenDevice(a6)
	tst.b	d0
	bne.s	.neg3

	POSITIV


.neg3	move.l	timerio(a5),a0
	clr.l	timerio(a5)
	jsr	DeleteIORequest(a6)

.neg2	move.l	timerreply(a5),a0
	clr.l	timerreply(a5)
	jsr	DeleteMsgPort(a6)

.neg	NEGATIV





CloseTimer
	move.l	exec(a5),a6


;=== Device schlieen
	move.l	timerio(a5),d0
	beq.s	.noio
	move.l	d0,a1
	tst.l	$14(a1)
	beq.s	.nodev
	jsr	CloseDevice(a6)
.nodev

	move.l	timerio(a5),a0
	jsr	DeleteIORequest(a6)
	clr.l	Timerio(a5)
.noio

;=== Replyport freigeben
	move.l	TimerReply(a5),d0
	beq.s	.noport
	move.l	d0,a0
	jsr	DeleteMsgPort(a6)
	clr.l	TimerReply(a5)
.noport

	rts





;==============================================================
;
;  Setup serial port
;
;==============================================================

OpenHardwareSerial

;=== signal, if serial output is complete
	moveq	#-1,d0
	move.l	exec(a5),a6
	jsr	AllocSignal(a6)
	move.b	d0,serialoutreadysig(a5)
	bmi	.neg

;=== expunge serial.device if still in memory
	jsr	Forbid(a6)

	lea	sernam(pc),a1
	lea	350(a6),a0
	jsr	FindName(a6)
	move.l	d0,-(sp)

	jsr	Permit(a6)

	move.l	(sp)+,d0
	beq.s	.nodev
	move.l	d0,a6
	jsr	ExpungeDevice(a6)
.nodev



;=== alloc misc-resource
	lea	miscnam(pc),a1
	move.l	exec(a5),a6
	jsr	OpenResource(a6)
	move.l	d0,miscres(a5)
	beq.s	.neg
	move.l	d0,a6

	lea	mtname(pc),a1
	moveq	#0,d0				; MR_SERIALPORT
	jsr	AllocMiscResource(a6)
	tst.l	d0
	beq.s	.misc_ok
	clr.l	miscres(a5)
	bra.s	.neg
.misc_ok

;=== activate serial-out irq
	moveq	#0,d0
	lea	tbe_irq(pc),a1
	move.l	exec(a5),a6
	jsr	SetIntVector(a6)
	tst.l	d0
	bne.s	.reset_tbe
	st	tbe_set(a5)


	move.w	#114,$dff032
	move.w	#$8001,$dff09a


	POSITIV


.reset_tbe
	suba.l	a1,a1
	moveq	#0,d0
	jsr	SetIntVector(a6)
	sf	tbe_set(a5)

.neg	NEGATIV





tbe_irq
	dc.l	0,0
	dc.b	2,1
	dc.l	tbename
	dc.l	0		; varbase
	dc.l	.tbecode



.tbecode
	move.w	#$0001,$9c(a0)
	move.l	a5,-(sp)
	move.l	a1,a5

	move.l	irqptr_out(a5),a1
	cmpa.l	writeptr_out(a5),a1
	beq.s	.back

	move.w	#$0100,d0
	move.b	(a1)+,d0

	cmpa.l	upperlimit_out(a5),a1
	bcs.s	.put
	lea	serialoutpuffer(a5),a1
.put	move.l	a1,irqptr_out(a5)



	IFEQ	1

	move.l	serialwrite_ptr(a5),d0
	beq.s	.back
	move.l	d0,a1
	move.w	#$0100,d0
	move.b	(a1)+,d0
	subq.l	#1,serialwrite_length(a5)
	bcc.s	.more

	clr.l	serialwrite_ptr(a5)
	moveq	#0,d0
	move.b	serialoutreadysig(a5),d1
	bset	d1,d0
	move.l	mytask(a5),a1
	move.l	exec(a5),a6
	jsr	Signal(a6)
	bra.s	.back

.more	move.l	a1,serialwrite_ptr(a5)

	ENDC

.put2	move.w	d0,$30(a0)

.back	move.l	(sp)+,a5
	rts






;==============================================================
;
;  Release serial resources
;
;==============================================================

CloseHardwareSerial


;=== free serial-out irq

	tst.b	tbe_set(a5)
	beq.s	.no_tbe

	move.w	#$0001,$dff09a
	moveq	#0,d0
	suba.l	a1,a1
	move.l	exec(a5),a6
	jsr	SetIntVector(a6)
	sf	tbe_set(a5)
.no_tbe



;=== free misc-resource
	move.l	miscres(a5),d0
	beq.s	.nomisc
	move.l	d0,a6
	moveq	#0,d0				; MR_SERIALPORT
	jsr	FreeMiscResource(a6)
	clr.l	miscres(a5)
.nomisc


;=== free a signal

	move.b	serialoutreadysig(a5),d0
	bmi.s	.nosig
	move.l	exec(a5),a6
	jsr	FreeSignal(a6)
.nosig

	rts




put_player_signal	; d1 = signal-# to set
			; returns: pos/neg for success or failure

	moveq	#0,d0
	bset	d1,d0
	move.l	playerprocess(a5),a1
	move.l	exec(a5),a6
	jsr	Signal(a6)

	move.b	answersignal(a5),d1
	moveq	#0,d0
	bset	d1,d0
	jmp	Wait(a6)







lib_mtFree
	movem.l	a5-a6,-(sp)
	move.l	a6,a5

	bsr	lib_mtStop

	bsr	CloseHardwareSerial
	bsr	KillPlayerProcess

	clr.l	mtsong(a5)

	bsr	close_midi
	bsr	CloseTimer

	lea	replaypuffer(a5),a0
	bsr.s	FreeVector

	lea	playcounters(a5),a0
	bsr.s	FreeVector

	lea	utilbas(a5),a0
	bsr	FreeLib

	movem.l	(sp)+,a5-a6
	rts




FreeVector	; a0=^Memoryaddress
	move.l	(a0),d0
	beq.s	.rts
	clr.l	(a0)
	move.l	d0,a1
	move.l	exec(a5),a6
	jmp	FreeVec(a6)
.rts	rts





;==============================================================
;
;  MIDI Daten erzeugen
;
;==============================================================

createmidi	; zurck: pos/neg

	move.l	replaypuffer(a5),a4

;=== music routine



;=== pattern am ende?
	move.l	currentpatternA(a5),a0
	move.l	playpos(a5),d0
	addq.l	#1,d0
	cmp.l	pt_events(a0),d0
	bcc.s	.nextpt
	move.l	d0,playpos(a5)
	bra.s	.notend

.nextpt
;=== pattern an den Anfang bringen
	clr.l	playpos(a5)
	bsr	clear_playcounters


;=== playsong-mode: nchstes pattern
	move.l	currentpos(a5),d0
	addq.l	#1,d0
	cmp.l	length(a5),d0
	bcs.s	.insong
;	cmp.b	#-2,playflag(a5)
;	beq.s	.psong
; record mode: stop playback, but continue recording
;	st	songready(a5)
;	bra	.record_ready

.psong
; playmode: loop back or stop
	tst.b	loopsong(a5)
	beq	.neg
	move.l	looppos(a5),d0

.insong	move.l	d0,currentpos(a5)
	move.l	positionsA(a5),a0
	moveq	#0,d1
	IFEQ	mc68020
	add.l	d0,d0
	move.w	(a0,d0.l),d1
	ELSE
	move.w	(a0,d0.l*2),d1
	ENDC
	move.l	d1,currentpattern(a5)
	bsr	CorrectPattern




;=== Hier fngt die MIDI Verarbeitung an!

.notend
	move.l	currentpatternA(a5),a3



;=== BPM Track
	lea	bpmplaycounter(a5),a6
	move.l	pt_bpmtrack(a3),d0
	beq.s	.nobpm
	tst.w	(a6)		; pcbpm_counter(a6)
	bne.s	.bpm1
	move.l	d0,a0
	adda.w	pcbpm_offset(a6),a0
	addq.w	#2,pcbpm_offset(a6)
	move.w	(a0),d1
	bpl.s	.newbpm
	move.w	d1,(a6)		; pcbpm_counter(a6)
	bra.s	.bpm1
.newbpm	move.w	d1,playtempo(a5)
	bsr	calc_tempo
	bra.s	.nobpm
.bpm1	addq.w	#1,(a6) 	; pcbpm_counter(a6)
.nobpm



;=== Die Channels werden von hinten nach vorne durchgegangen.

	move.l	playcounters(a5),a6
	move.w	chanc(a5),d0
	move.w	d0,d1		; = mulu #15,d0
	lsl.w	#4,d0		;
	sub.w	d1,d0		;
	adda.w	d0,a6
	moveq	#15,d6
.channelloop
	move.l	currentpatternA(a5),a3
	IFEQ	mc68020
	move.w	d6,d0
	lsl.w	#2,d0
	move.l	pt_channels(a3,d0.w),d1
	ELSE
	move.l	pt_channels(a3,d6.w*4),d1
	ENDC
	bne.s	.chanexists

;	bsr	mixdown
	bra	.nochan


.chanexists

	tst.b	playdisabled(a5)		; Play-disabled-tracks active?
	bne.s	.playit				; yes, play even if chan is off


;	tst.b	solomode(a5)
;	beq.s	.nosolo
;	move.w	currentchannel(a5),d0
;	subq.w	#1,d0
;	cmp.w	d6,d0
;	beq.s	.nosolo
;	st	channelquiet(a5)
;	bra.s	.playit

;.nosolo

	move.w	pt_chanmask(a3),d0		; the channelquiet flag decides
	btst	d6,d0				; for each channel, if the replay
	seq	channelquiet(a5)		; routine should send notes on it
; Note: channelquiet is a temporary flag (only used here)

; If channel is quiet, we still have to run the following routines, because
; all counters must continue counting, in case user re-enables the channel.

.playit
	move.l	d1,a3


;=== d7 carries the channel-mapping flags
	move.l	mtsong(a5),a0
	lea	soX_channels_maps(a5),a0
	IFEQ	mc68020
	move.w	d6,d0
	add.w	d0,d0
	move.w	(a0,d0.w),d7
	ELSE
	move.w	(a0,d6.w*2),d7
	ENDC





;=== Preset Track MIDI
	move.l	ch_ptrack(a3),d0
	beq.s	.no0
	tst.w	(a6)		; pcp_counter(a6)
	bne.s	.trk0
	move.l	d0,a0
	adda.w	pcp_offset(a6),a0
	addq.w	#2,pcp_offset(a6)
	move.w	(a0),d0
	bpl.s	.new0
	move.w	d0,(a6)		; pcp_counter(a6)
.trk0	addq.w	#1,(a6) 	; pcp_counter(a6)
	bra.s	.no0
.new0

	; d0=preset, d6=channel, a4=^buffer
;	bsr	make_preset_message
	nop

.no0





;=== Pitchbend Track MIDI
	move.l	ch_pbtrack(a3),d0
	beq.s	.no1

	tst.w	prec1+pcpb_counter(a6)
	bne.s	.trk1
	move.l	d0,a0
	adda.w	prec1+pcpb_offset(a6),a0
	addq.w	#2,prec1+pcpb_offset(a6)
	move.w	(a0),d4
	bpl.s	.new1
	move.w	d4,prec1+pcpb_counter(a6)
.trk1	addq.w	#1,prec1+pcpb_counter(a6)
	bra.s	.no1
.new1
	tst.b	playdisabled(a5)
	bne.s	.pbon
	tst.b	ch_pb_onoff(a3)
	beq.s	.no1
	tst.b	channelquiet(a5)
	bne.s	.no1
.pbon

	move.w	pibe_ofilter(a5),d2

	moveq	#15,d3
.pbmaploop
	btst	d3,d7
	beq.s	.pbnomap

	tst.b	global_outfilters(a5)
	beq.s	.pbnofilter
	btst	d3,d2
	bne.s	.pbnomap
.pbnofilter

	moveq	#-$20,d1	; d1.b=$e0
	or.b	d3,d1
	move.b	d1,(a4)+
	move.b	d4,d1
	and.b	#$7f,d1
	move.b	d1,(a4)+
	move.w	d4,d0
	lsr.w	#7,d0
	move.b	d0,(a4)+
.pbnomap
	dbf	d3,.pbmaploop

.no1





;=== Alle Controlsources, die mit $B0 (Parameter) einzustellen sind

	lea	ch_csources(a3),a1

.paramloop
	move.l	(a1),d0
	beq	.nomorecs
	move.l	d0,a1


;=== zur Controlsource spulen, um den richtigen Offset in d2 zu bekommen
	move.l	active_csources_m1(a5),d3
	moveq	#-pcc_sizeof,d2
	lea	codetab(a5),a0
	move.b	cs_parameter(a1),d4
.codeloop
	addq.w	#pcc_sizeof,d2
	cmp.b	(a0)+,d4
	dbeq	d3,.codeloop
	bne	.nomorecs


	tst.b	prec3+pcc_counter(a6,d2.w)
	bne.s	.trkc
	move.w	prec3+pcc_offset(a6,d2.w),d1
	addq.w	#1,prec3+pcc_offset(a6,d2.w)
	move.b	cs_data(a1,d1.w),d0
	bpl.s	.newc
	move.b	d0,prec3+pcc_counter(a6,d2.w)
.trkc	addq.b	#1,prec3+pcc_counter(a6,d2.w)
	bra.s	.stay
.newc
	tst.b	playdisabled(a5)
	bne.s	.cson
	tst.b	cs_onoff(a1)
	beq.s	.stay
	tst.b	channelquiet(a5)
	bne.s	.stay
.cson


	sub.l	active_csources_m1(a5),d3
	neg.l	d3
	lea	cs_ofilters(a5),a0
	IFEQ	mc68020
	add.l	d3,d3
	move.w	(a0,d3.l),d2
	ELSE
	move.w	(a0,d3.l*2),d2
	ENDC

	moveq	#15,d3

	cmp.b	#7,d4			; Volume-Parameter ?
	bne.s	.notvol

;=== Volume-Byte merken fr Mixdown
	lea	channelvolumes(a5),a0
	not.b	d0
.volloop
	btst	d3,d7
	beq.s	.volnomap

	tst.b	global_outfilters(a5)
	beq.s	.volnofilter
	btst	d3,d2
	bne.s	.volnomap
.volnofilter

	move.b	d0,(a0,d3.w)
.volnomap
	dbf	d3,.volloop
	bra.s	.stay



.notvol
.csmaploop
	btst	d3,d7
	beq.s	.csnomap

	tst.b	global_outfilters(a5)
	beq.s	.csnofilter
	btst	d3,d2
	bne.s	.csnomap
.csnofilter

	moveq	#-$50,d1
	or.b	d3,d1
	move.b	d1,(a4)+
	move.b	d4,(a4)+
	move.b	d0,(a4)+
.csnomap
	dbf	d3,.csmaploop

.stay	bra	.paramloop

.nomorecs




;=== mix all volumes together (master, channelscope-sliders, midi-volume)

	bsr	mixdown





;=== Now we're going to manage all note-tracks !

	tst.b	channelquiet(a5)
	beq.s	.not_quiet


	bsr	.silence_channel



;=== We still have to progress all counters, that's why we don't skip the
;=== ".not_quiet"-section.





;=== Play all channel's note-tracks regularly.

.not_quiet


;=== now process the note-tracks

	lea	ch_tracks(a3),a2
.trackloop
	move.l	(a2),d0
	beq	.nomoretracks
	move.l	d0,a2

	move.w	tr_number(a2),d4
	move.w	d4,d3				; use d3 later!
	IFEQ	pc_sizeof-6
	add.w	d3,d4
	add.w	d3,d4
	add.w	d4,d4				; use d4 as structure-offset
	ELSE
	mulu	#pc_sizeof,d4
	ENDC
	add.w	csc(a5),d4


	tst.w	pc_counter(a6,d4.w)
	bne.s	.sub2
	lea	tr_data(a2),a1
	adda.w	pc_offset(a6,d4.w),a1		; track-offset
	move.w	(a1),d1				; datenword oder counterword ?
	bpl.s	.midi2
;=== counterword
	move.w	d1,pc_counter(a6,d4.w)
	addq.w	#2,pc_offset(a6,d4.w)		; track-offset hochzhlen
.sub2	addq.w	#1,pc_counter(a6,d4.w)
	bra	.nextrk
;=== midi-daten
.midi2	addq.w	#wd_sizeof,pc_offset(a6,d4.w)

	tst.b	playdisabled(a5)
	bne.s	.active


;=== use these two lines in executable player's code !!!
	tst.b	tr_onoff(a2)
	bne.s	.playtrk
;=== use these three lines in MidiTracker replay code !!
;	move.l	current_onoffs(a5),a0
;	tst.b	(a0,d3.w)
;	bne.s	.playtrk
;=== silence current track
	bsr	.note_off
	bra	.nextrk


.playtrk
	tst.b	channelquiet(a5)
	bne	.nextrk
.active


	move.b	wd_pitch(a1),d1
	bmi.s	.off				; -1 means Note OFF specified
	IFNE	Pitch_clear
	cmp.b	#Pitch_clear,d1
	ENDC
	beq.s	.pp				; 0 means no note specified


;=== play a note on event
	move.b	pc_oldnote(a6,d4.w),d2		; $ff=Note ist schon off
	bmi.s	.skip_force

;=== force Note-OFF if previous note has not been released
	bsr	.note_off

.skip_force



	move.b	d1,pc_oldnote(a6,d4.w)		; d1 = the new note
	move.b	wd_vel(a1),d0			; if vel=clear, use prev value
	bmi.s	.novel
	move.b	d0,pc_oldvel(a6,d4.w)
.novel

	move.w	note_ofilter(a5),d2

	lea	desttranss(a5),a0
	moveq	#15,d3
.onmaploop
	btst	d3,d7
	beq.s	.onnomap

	tst.b	global_outfilters(a5)
	beq.s	.onnofilter
	btst	d3,d2
	bne.s	.onnomap
.onnofilter

	moveq	#-$70,d0
	or.b	d3,d0
	move.b	d0,(a4)+

	move.b	pc_oldnote(a6,d4.w),d1
	bsr	dest_transpose
	move.b	d1,(a4)+			; new note
	move.b	pc_oldvel(a6,d4.w),(a4)+	; new velocity
.onnomap
	dbf	d3,.onmaploop

	bra.s	.pp




;=== here is jumped to, if a Note-OFF event came up

.off	move.b	wd_vel(a1),d0		; if vel=clear, use prev value
	bmi.s	.novel2
	move.b	d0,pc_oldvel(a6,d4.w)
.novel2
	bsr	.note_off




;=== check poly pressure byte

.pp	move.b	wd_pp(a1),d1
	cmp.b	#cs_stay,d1
	beq.s	.nextrk			; no new pp-value
	tst.b	pc_oldnote(a6,d4.w)	; check if there is a note
	bmi.s	.nextrk			; pending (-1 = note is off)

	move.w	ppress_ofilter(a5),d2

	moveq	#15,d3
.ppmaploop
	btst	d3,d7
	beq.s	.ppnomap

	tst.b	global_outfilters(a5)
	beq.s	.ppnofilter
	btst	d3,d2
	bne.s	.ppnomap
.ppnofilter

	moveq	#-$60,d0
	or.b	d3,d0
	move.b	d0,(a4)+
	move.b	pc_oldnote(a6,d4.w),(a4)+
	move.b	d1,(a4)+
.ppnomap

	dbf	d3,.ppmaploop


.nextrk	bra	.trackloop
.nomoretracks






;=== MPress Track MIDI
	move.l	ch_mptrack(a3),d0
	beq.s	.no2

	tst.b	prec2+pcmp_counter(a6)
	bne.s	.trk2
	move.l	d0,a0
	adda.w	prec2+pcmp_offset(a6),a0
	addq.w	#1,prec2+pcmp_offset(a6)
	move.b	(a0),d0
	bpl.s	.new2
	move.b	d0,prec2+pcmp_counter(a6)
.trk2	addq.b	#1,prec2+pcmp_counter(a6)
	bra.s	.no2
.new2
	tst.b	playdisabled(a5)
	bne.s	.mpon
	tst.b	ch_mp_onoff(a3)
	beq.s	.no2
	tst.b	channelquiet(a5)
	bne.s	.no2
.mpon

	move.w	mpress_ofilter(a5),d2

	moveq	#15,d3
.mpmaploop
	btst	d3,d7
	beq.s	.mpnomap

	tst.b	global_outfilters(a5)
	beq.s	.mpnofilter
	btst	d3,d2
	bne.s	.mpnomap
.mpnofilter


	moveq	#-$30,d1	; d1.b=$d0
	or.b	d3,d1
	move.b	d1,(a4)+
	move.b	d0,(a4)+
.mpnomap

	dbf	d3,.mpmaploop
.no2





.nochan	suba.w	chanc(a5),a6			; next channel
	dbf	d6,.channelloop



;.record_ready
.send_data

	tst.b	send_mtc(a5)
	beq.s	.nomtc
	bsr	.midi_time_code
.nomtc

	bsr	check_external_clock
	bne.s	.noclock
	move.b	#$f8,(a4)+			; Realtime-Clock is ALWAYS sent
.noclock


	bsr.s	.optimize

	; a1=^puffer, d1=length

	st	from_irq(a5)
	bsr	send_stream
	sf	from_irq(a5)
.nosend

	POSITIV

.neg	bsr.s	.send_data
	NEGATIV






.note_off
	move.l	d1,-(sp)			; save d1
	tst.b	pc_oldnote(a6,d4.w)
	bmi.s	.back1				; already off

	move.w	note_ofilter(a5),d2

	lea	desttranss(a5),a0
	moveq	#15,d3
.offmaploop
	btst	d3,d7
	beq.s	.offnomap

	tst.b	global_outfilters(a5)
	beq.s	.offnofilter
	btst	d3,d2
	bne.s	.offnomap
.offnofilter

	moveq	#-$80,d0			; play real note-off
	or.b	d3,d0
	move.b	d0,(a4)+
	move.b	pc_oldnote(a6,d4.w),d1
	bsr	dest_transpose
	move.b	d1,(a4)+
	move.b	pc_oldvel(a6,d4.w),(a4)+
.offnomap

	dbf	d3,.offmaploop

	st	pc_oldnote(a6,d4.w)		; set note to OFF

.back1	move.l	(sp)+,d1
	rts





;=== Put all Note-OFFs in front of all Note-ONs

.optimize	; a4=^end of buffer
		; returns: a1=beginning of buffer, d1=length

	move.l	replaypufferD(a5),a0
	move.l	replaypufferoptD(a5),a1

;	move.l	a4,d1
;	sub.l	a0,d1
;	move.l	a0,a1
;	rts


; First, collect all note-offs.

.optloop1
	cmpa.l	a4,a0
	bcc.s	.optout1

	move.b	(a0),d0
	lsr.b	#4,d0
.reloop1
	subq.b	#8,d0
	beq.s	.3move1
	subq.b	#1,d0		; note on
	beq.s	.non1
	subq.b	#1,d0		; ppress
	beq.s	.3move1
	subq.b	#1,d0		; parameter
	beq.s	.3byte1
	subq.b	#2,d0		; program + mpress
	bls.s	.2byte1
	subq.b	#1,d0		; pitchbend
	beq.s	.3byte1
	move.b	(a0),d0		; check for sysex
	and.b	#$0f,d0
	beq.s	.sysex1
	subq.b	#1,d0		; $f1 mtc
	beq.s	.2byte1
	subq.b	#7,d0		; $f8 clock
	beq.s	.1byte1
	subq.b	#2,d0		; $fa start
	beq.s	.1byte1
	subq.b	#2,d0		; $fc stop
	beq.s	.1byte1

.sysex1	addq.w	#1,a0
.sexl1	move.b	(a0)+,d0
	bpl.s	.sexl1
	bra.s	.optloop1

.1byte1	addq.w	#1,a0
	bra.s	.optloop1

.2byte1	addq.w	#2,a0
	bra.s	.optloop1

.3byte1	addq.w	#3,a0
	bra.s	.optloop1

.3move1	move.b	(a0),(a1)+
	sf	(a0)+
	move.b	(a0),(a1)+
	sf	(a0)+
	move.b	(a0),(a1)+
	sf	(a0)+
	bra.s	.optloop1

.non1	addq.w	#3,a0
	cmpa.l	a4,a0
	bcc.s	.optout1
	move.b	(a0),d0
	lsr.b	#4,d0
	cmp.b	#$a,d0
	beq.s	.3byte1
	bra.s	.reloop1
.optout1



; Now, take over all other midi data.

	move.l	replaypufferD(a5),a0
.optloop2
	cmpa.l	a4,a0
	bcc.s	.optout2

	move.b	(a0)+,d0
	beq.s	.optloop2
	move.b	d0,d1
	lsr.b	#4,d0
	sub.b	#$b,d0
	bls.s	.3move2
	subq.b	#2,d0		; program + mpress
	bls.s	.2move2
	subq.b	#1,d0		; pitchbend
	beq.s	.3move2
	move.b	d1,d0		; check for sysex
	and.b	#$0f,d0
	beq.s	.sysex2
	subq.b	#1,d0		; $f1 mtc
	beq.s	.2move2
	subq.b	#6,d0		; $f7 eox
	beq.s	.1move2
	subq.b	#1,d0		; $f8 clock
	beq.s	.1move2
	subq.b	#2,d0		; $fa start
	beq.s	.1move2
	subq.b	#2,d0		; $fc stop
	beq.s	.1move2

.sysex2	move.b	d1,(a1)+
.sexl2	move.b	(a0)+,d0
	bmi.s	.optloop2
	move.b	d0,(a1)+
	bra.s	.sexl2

.1move2	move.b	d1,(a1)+
	bra.s	.optloop2

.2move2	move.b	d1,(a1)+
	move.b	(a0)+,(a1)+
	bra.s	.optloop2

.3move2	move.b	d1,(a1)+
	move.b	(a0)+,(a1)+
	move.b	(a0)+,(a1)+
	bra.s	.optloop2


.optout2
	move.l	a1,d1
	move.l	replaypufferoptD(a5),a1
	sub.l	a1,d1
	rts







.silence_channel	; d7=channel-mapping-word
			; a6=^playcounters

;=== By now, all held notes in this channel have to be silenced, ie Note-OFFed.

	move.l	a6,a0
	adda.w	csc(a5),a0
	move.l	maxtracks_m1(a5),d4
.silenceloop

	move.b	pc_oldnote(a0),d0
	bmi.s	.skipt				; note is off, no panic necessary
	st	pc_oldnote(a0)			; set note to OFF
	move.b	pc_oldvel(a0),d1		; get velocity

	moveq	#15,d3
.silencemaploop
	btst	d3,d7
	beq.s	.silencenomap
	moveq	#-$80,d2			; send the Note-OFF
	or.b	d3,d2
	move.b	d2,(a4)+
	move.b	d0,(a4)+			; pitch
	move.b	d1,(a4)+			; velocity
.silencenomap
	dbf	d3,.silencemaploop

.skipt	addq.w	#pc_sizeof,a0
	dbf	d4,.silenceloop

	rts






.midi_time_code

	moveq	#-$f,d4			; $f1
	moveq	#$0f,d5

	not.b	mtc_frameflag(a5)
	bne.s	.2nd_frame


	lea	timerval(a5),a0
	move.l	timerio(a5),a6
	move.l	$14(a6),a6
	jsr	GetSysTime(a6)
	lea	timervalinit(a5),a1
	jsr	SubTime(a6)


; frames in 1/25 per second
	move.l	4(a0),d0
	divu	#10000*4,d0
	move.b	d0,d2
	and.b	d5,d2
	move.b	d4,(a4)+
	move.b	d2,(a4)+		; LS nibble
	lsr.b	#4,d0
	add.b	#$10,d0
	move.b	d4,(a4)+
	move.b	d0,(a4)+		; MS nibble

; seconds
	move.l	(a0),d0
	divu	#60,d0
	move.w	d0,mtc_minutes(a5)
	swap	d0
	move.b	d0,d2
	and.b	d5,d2
	add.b	#$20,d2
	move.b	d4,(a4)+
	move.b	d2,(a4)+
	lsr.b	#4,d0
	add.b	#$30,d0
	move.b	d4,(a4)+
	move.b	d0,(a4)+

.rts	rts





.2nd_frame

; minutes
	move.w	mtc_minutes(a5),d0
	divu	#60,d0
	swap	d0			; hours in MSW
	move.b	d0,d2
	and.b	d5,d2
	add.b	#$40,d2
	move.b	d4,(a4)+
	move.b	d2,(a4)+
	lsr.b	#4,d0
	add.b	#$50,d0
	move.b	d4,(a4)+
	move.b	d0,(a4)+

; hours
	swap	d0
	move.b	d0,d2
	and.b	d5,d2
	add.b	#$60,d2
	move.b	d4,(a4)+
	move.b	d2,(a4)+
	lsr.b	#4,d0
	add.b	#$72,d0			; 1/25 frames/second
	move.b	d4,(a4)+
	move.b	d0,(a4)+

	rts





; consider destination transpose from the remapper window

dest_transpose	; d1=old note, a0=pointer to transpose table, d3=channel (0-15)
		; returns: d1=new note after transpose

	move.b	(a0,d3.w),d0
	beq.s	.rts
	bpl.s	.posn
	add.b	d0,d1
	cmp.b	#12,d1
	bgt.s	.noteok
	moveq	#12,d1
	rts

.posn	add.b	d0,d1
	bvc.s	.noteok
	moveq	#127,d1
.noteok
.rts	rts



;	ENDC




init_playcounters

	bsr.s	clear_playcounters

	move.l	playcounters(a5),a0
	moveq	#15,d2
.chanloop
	adda.w	csc(a5),a0

	move.l	maxtracks_m1(a5),d3
.trackloop
	st	pc_oldnote(a0)
	clr.b	pc_oldvel(a0)
	addq.w	#pc_sizeof,a0
	dbf	d3,.trackloop

	dbf	d2,.chanloop
	rts





clear_playcounters
	moveq	#0,d1
	move.l	d1,bpmplaycounter(a5)

	move.l	playcounters(a5),a0
	moveq	#15,d3
.clearloop
	move.l	d1,(a0)+	; preset
	move.l	d1,(a0)+	; pitch
	move.l	d1,(a0)+	; mpress

	move.l	active_csources_m1(a5),d2
.csclearloop
	move.b	d1,pcc_counter(a0)
	move.w	d1,pcc_offset(a0)
	addq.w	#pcc_sizeof,a0
	dbf	d2,.csclearloop

	move.l	maxtracks_m1(a5),d2
.trclearloop
	move.w	d1,pc_counter(a0)
	move.w	d1,pc_offset(a0)
	addq.w	#pc_sizeof,a0
	dbf	d2,.trclearloop

	dbf	d3,.clearloop

	rts




CorrectPattern
	move.l	patterntab(a5),a0
	move.l	currentpattern(a5),d0
	IFEQ	mc68020
	lsl.l	#2,d0
	move.l	(a0,d0.l),currentpatternA(a5)
	ELSE
	move.l	(a0,d0.l*4),currentpatternA(a5)
	ENDC
	rts





utilnam		dc.b	'utility.library',0
midinam		dc.b	'midi.library',0
timnam		dc.b	'timer.device',0
sernam		dc.b	'serial.device',0
cianam		dc.b	'ciaa.resource',0
miscnam		dc.b	'misc.resource',0
ciairqname	dc.b	'MT replay timer',0
replayname	dc.b	'MT replay irq',0
tbename		dc.b	'MT serial out',0

midioutname	dc.b	'MidiOut',0
mtname		dc.b	'MidiTracker',0

		even






send_1_byte	; d0 is the byte to write

	movem.l	d0-d1/a0-a2,-(sp)

	tst.b	cia_or_midilib(a5)
	bne.s	.mlib

	subq.w	#4,sp
	move.l	sp,a0
	move.b	d0,(a0)+
	move.l	sp,serialwrite_ptr(a5)
	moveq	#1,d0
	move.l	d0,serialwrite_length(a5)

	bsr	make_serial_write

.back2	addq.w	#4,sp
	movem.l	(sp)+,d0-d1/a0-a2
	rts

.mlib
	subq.w	#4,sp
	move.b	d0,(sp)

	move.l	sp,midi_address(a5)
	clr.l	midi_length(a5)
	move.b	midimsg_signal(a5),d1
	bsr	put_player_signal
	bra.s	.back2




send_2_bytes	; d0-d1 are bytes to write

	movem.l	d0-d1/a0-a2,-(sp)


;=== invoke midi-out filters

	tst.b	global_outfilters(a5)
	beq.s	.no_filtering

	move.b	d0,d1
	lsr.b	#4,d1
	and.w	#$f,d0
	sub.b	#$c,d1
	beq.s	.pchgfilter
	subq.b	#1,d1
	beq.s	.mpfilter
	bra.s	.no_filtering

.mpfilter
	move.w	mpress_ofilter(a5),d1
	bra.s	.fcheck

.pchgfilter
	move.w	pchg_ofilter(a5),d1
.fcheck	btst	d0,d1
	bne.s	.back
.no_filtering



	movem.l	(sp),d0-d1

	tst.b	cia_or_midilib(a5)
	bne.s	.mlib

	subq.w	#4,sp
	move.l	sp,a0
	move.b	d0,(a0)+
	move.b	d1,(a0)+
	move.l	sp,serialwrite_ptr(a5)
	moveq	#2,d0
	move.l	d0,serialwrite_length(a5)

	bsr	make_serial_write

.back2	addq.w	#4,sp
	movem.l	(sp)+,d0-d1/a0-a2
	rts

.mlib
	subq.w	#4,sp
	move.l	sp,a0
	move.b	d0,(a0)+
	move.b	d1,(a0)+

	move.l	sp,midi_address(a5)
	clr.l	midi_length(a5)
	move.b	midimsg_signal(a5),d1
	bsr	put_player_signal
	bra.s	.back2





send_3_bytes	; d0-d2 are bytes to write

	movem.l	d0-d2/a0-a2,-(sp)


;=== invoke midi-out filters

	tst.b	global_outfilters(a5)
	beq.s	.no_filtering

	move.b	d0,d1
	lsr.b	#4,d1
	and.w	#$0f,d0
	subq.b	#8,d1
	beq.s	.notefilter
	subq.b	#1,d1
	beq.s	.notefilter
	subq.b	#1,d1
	beq.s	.ppfilter
	subq.b	#1,d1
	beq.s	.csfilter
	subq.b	#3,d1
	beq.s	.pibefilter
	bra.s	.no_filtering

.pibefilter
	move.w	pibe_ofilter(a5),d1
	bra.s	.fcheck

.notefilter
	move.w	note_ofilter(a5),d1
.fcheck	btst	d0,d1
	bne	.back
	bra.s	.no_filtering

.ppfilter
	move.w	ppress_ofilter(a5),d1
	bra.s	.fcheck

.csfilter
	move.l	4(sp),d1
	lea	codetab(a5),a0
	move.l	active_csources_m1(a5),d2
.findloop
	cmp.b	(a0)+,d1
	dbeq	d2,.findloop
	bne.s	.no_filtering
	sub.l	active_csources_m1(a5),d2
	neg.l	d2
	lea	cs_ofilters(a5),a0
	IFEQ	mc68020
	adda.w	d2,d2
	move.w	(a0,d2.w),d1
	ELSE
	move.w	(a0,d2.w*2),d1
	ENDC
	bra.s	.fcheck

.no_filtering



	movem.l	(sp),d0-d2

	tst.b	cia_or_midilib(a5)
	bne.s	.mlib


	subq.w	#4,sp
	move.l	sp,a0
	move.b	d0,(a0)+
	move.b	d1,(a0)+
	move.b	d2,(a0)+
	move.l	sp,serialwrite_ptr(a5)
	moveq	#3,d0
	move.l	d0,serialwrite_length(a5)

	bsr	make_serial_write

.back2	addq.w	#4,sp
	movem.l	(sp)+,d0-d2/a0-a2
	rts


.mlib
	subq.w	#4,sp
	move.l	sp,a0
	move.b	d0,(a0)+
	move.b	d1,(a0)+
	move.b	d2,(a0)+

	move.l	sp,midi_address(a5)
	clr.l	midi_length(a5)
	move.b	midimsg_signal(a5),d1
	bsr	put_player_signal
	bra.s	.back2






send_stream	; d1=length, a1=^data
	tst.l	d1
	beq.s	.rts

	movem.l	d0-d2/a0-a3,-(sp)

	tst.b	cia_or_midilib(a5)
	bne.s	.mlib


;	move.l	a1,serialwrite_ptr(a5)
;	move.l	d1,serialwrite_length(a5)
;	bsr.s	make_serial_write


	move.l	irqptr_out(a5),a3
	subq.w	#1,a3
	lea	serialoutpuffer(a5),a0
	cmpa.l	a0,a3
	bcc.s	.regok1
	lea	serialoutsize(a3),a3
.regok1
	move.l	writeptr_out(a5),a0
	move.l	upperlimit_out(a5),a2

.copy	move.b	(a1)+,(a0)+
	cmpa.l	a2,a0
	bcs.s	.ok
	move.l	serialoutpufferD(a5),a0
.ok
	cmpa.l	a3,a0		; buffer overflow ?
	beq.s	.done
	subq.l	#1,d1
	bne.s	.copy
.done

	move.l	a0,writeptr_out(a5)
	bsr.s	start_serial_write


.back	movem.l	(sp)+,d0-d2/a0-a3
.rts	rts

.mlib
	move.l	a1,midi_address(a5)
	move.l	d1,midi_length(a5)

	move.b	midimsg_signal(a5),d1
	bsr	put_player_signal
	bra.s	.back






make_serial_write
	moveq	#0,d1
	move.b	serialoutreadysig(a5),d0
	bset	d0,d1
	moveq	#0,d0
	move.l	exec(a5),a6
	jsr	SetSignal(a6)

	bsr.s	start_serial_write


;wait_serial_write
	moveq	#0,d0
	move.b	serialoutreadysig(a5),d1
	bset	d1,d0
	jmp	Wait(a6)



start_serial_write
	move.w	$dff018,d1
	btst	#13,d1
	beq.s	.notbe
	move.w	#$8001,$dff09c
.notbe	rts







;==============================================================
;
;  Player-process
;
;==============================================================

LaunchPlayerProcess

	moveq	#-1,d0
	move.l	(a5),a6
	jsr	AllocSignal(a6)
	move.b	d0,answersignal(a5)
	bmi.s	.neg

;=== clear some signal
	moveq	#0,d0
	move.l	#$8000,d1
	jsr	SetSignal(a6)

;=== kick up process
	lea	.proctags(pc),a0
	move.l	a0,d1
	move.l	dosbas(a5),a6
	jsr	CreateNewProc(a6)
	tst.l	d0
	beq.s	.neg

;=== wait for process to initialize itself
	move.l	#$8000,d0
	move.l	(a5),a6
	jsr	Wait(a6)
	tst.l	playerprocess(a5)
	beq.s	.neg


	POSITIV
.neg	NEGATIV


.proctags
	dc.l	$800003e8+3,playerprocess_start	; Entry
	dc.l	$800003e8+11,2048		; Stacksize
	dc.l	$800003e8+12,playerprocname	; Name
	dc.l	$800003e8+13,40			; Priority (should be >30
						; because this is the prio
						; of midilib's processes)
	dc.l	0




KillPlayerProcess
	move.l	exec(a5),a6
	tst.l	playerprocess(a5)
	beq.s	.nomidi

;=== clear ctrl-f, this is the signal for answer
	moveq	#0,d0
	move.l	#$8000,d1
	jsr	SetSignal(a6)

	lea	playerprocname(pc),a1
	jsr	FindTask(a6)
	tst.l	d0
	beq.s	.nomidi

;=== dem Playerprocess Bescheid geben, da er sich beenden soll
	move.l	d0,a1
	move.l	#$8000,d0
	jsr	Signal(a6)
	move.l	#$8000,d0
	jsr	Wait(a6)
.nomidi
	clr.l	playerprocess(a5)

	move.b	answersignal(a5),d0
	bmi.s	.nosig
	jsr	FreeSignal(a6)
	st	answersignal(a5)
.nosig

	rts




playerprocess_Start

	move.l	tbe_irq+$e(pc),a5

	st	stopsignal(a5)
	st	playsignal(a5)
	st	midimsg_signal(a5)


	bsr	OpenTimer
	beq.s	.normit

	moveq	#-1,d0
	move.l	exec(a5),a6
	jsr	AllocSignal(a6)
	move.b	d0,playsignal(a5)
	bmi.s	.normit

	moveq	#-1,d0
	jsr	AllocSignal(a6)
	move.b	d0,stopsignal(a5)
	bmi.s	.normit

	moveq	#-1,d0
	jsr	AllocSignal(a6)
	move.b	d0,midimsg_signal(a5)
	bmi.s	.normit

	suba.l	a1,a1
	jsr	FindTask(a6)
	move.l	d0,playerprocess(a5)


	bsr	signal2main


.mainloop
	move.l	#$8000,d0
	move.b	playsignal(a5),d2
	bset	d2,d0
	move.b	midimsg_signal(a5),d1
	bset	d1,d0
	move.l	exec(a5),a6
	jsr	Wait(a6)

	btst	d2,d0
	beq.s	.nosig
	bsr.s	.do_replay
	bra.s	.mainloop
.nosig

	move.b	midimsg_signal(a5),d1
	btst	d1,d0
	beq.s	.no_msg
	move.l	d0,-(sp)
	bsr	send_midimsg_external
	bsr	put_answer
	move.l	(sp)+,d0
.no_msg


	btst	#15,d0
	beq.s	.mainloop


.normit

	bsr	close_midi

	move.l	exec(a5),a6

	move.b	stopsignal(a5),d0
	bmi.s	.nostop
	jsr	FreeSignal(a6)
	st	stopsignal(a5)
.nostop

	move.b	playsignal(a5),d0
	bmi.s	.noplay
	jsr	FreeSignal(a6)
	st	playsignal(a5)
.noplay

	move.b	midimsg_signal(a5),d0
	bmi.s	.nomsg
	jsr	FreeSignal(a6)
	st	midimsg_signal(a5)
.nomsg

	bsr	CloseTimer

	bsr	signal2main

	moveq	#0,d0
	rts





.do_replay

	move.b	stopsignal(a5),d2
	moveq	#0,d1
	bset	d2,d1
	moveq	#0,d0
	jsr	SetSignal(a6)

	bsr	put_answer

;=== SysTime merken
	lea	timervalinit(a5),a0
	move.l	timerio(a5),a6
	move.l	$14(a6),a6
	jsr	GetSysTime(a6)


.replay_loop

	move.l	playtimerio(a5),a1
	move.w	#9,$1c(a1)
	move.l	midilib_tempo(a5),$20(a1)
	move.l	midilib_tempo+4(a5),$24(a1)
	move.l	exec(a5),a6
	jsr	SendIO(a6)


	bsr	createmidi
	beq.s	.autostop


.replay_out

	move.l	playtimerio(a5),a1
	move.l	exec(a5),a6
	jsr	WaitIO(a6)

	tst.b	playflag(a5)
	bne	.replay_loop

	bra	put_answer




.autostop
	st	autostopped(a5)
	move.l	stop_buttonJ+2(a5),playertomain(a5)
	bsr	signal_main
	bra.s	.replay_out







send_midimsg_external
	move.l	midi_address(a5),a2
	move.l	midi_length(a5),d2
	bne.s	send_midistream

;send_midimsg	; a2 = midimsg
	move.l	midibas(a5),d1
	beq.s	.no
	move.l	d1,a6
	move.l	a2,a1
	move.l	player_msource(a5),a0
	jsr	PutMidiMsg(a6)

	bra.s	send_samples_msg
.no	rts



send_samples_msg	; a2 = midimsg

	tst.b	samples_active(a5)
	beq.s	.nosamples
	move.l	msource(a5),d0
	beq.s	.nosamples
	move.l	d0,a0
	move.l	a2,a1
	move.b	(a1),d0
	lsr.b	#4,d0
	cmp.b	#9,d0
	beq.s	.put
	cmp.b	#8,d0
	bne.s	.nosamples
.put	move.l	midibas(a5),a6
	jmp	PutMidiMsg(a6)
.nosamples

	rts



send_midistream	; a2 = midistream, d2 = length

	move.l	midibas(a5),d1
	beq.s	.no
	move.l	d1,a6

	move.l	d2,d1
	move.l	d1,d0
	move.l	player_msource(a5),a0
	suba.l	a1,a1
	jsr	PutMidiStream(a6)

	bra.s	send_samples_stream
.no	rts



send_samples_stream	; a2 = midistream, d2 = length

	tst.b	samples_active(a5)
	beq.s	.nosamples
	move.l	msource(a5),d0
	beq.s	.nosamples
	move.l	d0,a0
	move.l	d2,d1
	move.l	d1,d0
	suba.l	a1,a1
	move.l	midibas(a5),a6
	jmp	PutMidiStream(a6)
.nosamples

	rts





put_answer
	move.b	d0,player_rc(a5)

	move.b	answersignal(a5),d1
	moveq	#0,d0
	bset	d1,d0
	move.l	mytask(a5),a1
	move.l	(a5),a6
	jmp	Signal(a6)





open_midi
	lea	midinam(pc),a1
	moveq	#0,d0
	move.l	exec(a5),a6
	jsr	OpenLibrary(a6)
	move.l	d0,midibas(a5)
	beq.s	.neg
	move.l	d0,a6

	suba.l	a0,a0
	suba.l	a1,a1
	jsr	CreateMSource(a6)
	move.l	d0,player_msource(a5)
	beq.s	.neg

	move.l	d0,a0
	lea	midioutname(pc),a1
	suba.l	a2,a2
	jsr	MRouteSource(a6)
	move.l	d0,player_sourceroute(a5)
	beq.s	.neg


	bsr.s	open_samples
	beq.s	.neg


	POSITIV
.neg	NEGATIV





open_samples
	move.l	midibas(a5),d1
	beq.s	.neg
	move.l	d1,a6
	lea	mtname(pc),a0
	suba.l	a1,a1
	jsr	CreateMSource(a6)
	move.l	d0,msource(a5)
	beq.s	.neg

	POSITIV
.neg	NEGATIV






close_midi
	move.l	midibas(a5),d0
	beq.s	.nomidi
	move.l	d0,a6

	move.l	player_sourceroute(a5),d0
	beq.s	.nosroute
	move.l	d0,a0
	jsr	DeleteMRoute(a6)
	clr.l	player_sourceroute(a5)
.nosroute

	move.l	player_msource(a5),d0
	beq.s	.nosource
	move.l	d0,a0
	jsr	DeleteMSource(a6)
	clr.l	player_msource(a5)
.nosource


	bsr.s	close_samples

	lea	midibas(a5),a0
	bsr	FreeLib

.nomidi	rts






close_samples
	move.l	msource(a5),d0
	beq.s	.nosource
	move.l	midibas(a5),d1
	beq.s	.nosource
	move.l	d0,a0
	move.l	d1,a6
	jsr	DeleteMSource(a6)
	clr.l	msource(a5)
.nosource

	rts









endresident

;============================================================

		rsreset
library		rs.b	$22

cia_set		rs.b	1
tbe_set		rs.b	1
seglist		rs.l	1
exec		rs.l	1
utilbas		rs.l	1
midibas		rs.l	1
ciares		rs.l	1
miscres		rs.l	1
ciafreq		rs.l	1

playerprocess	rs.l	1
mytask		rs.l	1

timerreply	rs.l	1
timerio		rs.l	1
timervalinit	rs.l	2	; fr den Timerdisplay = Initwerte
timerval	rs.l	2	; fr den Timerdisplay

mtsong		rs.l	1
currentpos	rs.l	1
length		rs.l	1
maxtracks_m1	rs.l	1
maxtracks	rs.l	1

replaypuffer	rs.l	1
replaypufferopt	rs.l	1

ciacountinit	rs.b	1
ciacount	rs.b	1
autostopped	rs.b	1
playdisabled	rs.b	1

positionsA	rs.l	1
patterntab	rs.l	1
currentpattern	rs.l	1	; aktuelles pattern (zahl)
currentpatternA	rs.l	1	; ^aktuelles pattern
playpos		rs.l	1	; aktueller playing position
playtempo	rs.w	1
songready	rs.b	1
loopsong	rs.b	1
channelquiet	rs.b	1
playflag	rs.b	1

send_mtc	rs.b	1
mtc_frameflag	rs.b	1	; 0=first 4 frames, -1=last 4 frames
mtc_minutes	rs.w	1
mastervolume	rs.w	1

looppos		rs.l	1
pchgtypes	rs.b	16
channelsliders	rs.b	16
desttranss	rs.b	16

cia_or_midilib	rs.b	1	; 0 = use cia, 1 = use midilib
samples_active	rs.b	1	; 0 = no external mlib-port
playsignal	rs.b	1
stopsignal	rs.b	1
answersignal	rs.b	1
serialoutreadysig rs.b	1
		rs.b	2

soX_sysexs	rs.l	1
soX_patterns	rs.l	1

midilib_tempo	rs.l	2	; secs/micros to wait each mclock
player_msource	rs.l	1
player_sourceroute rs.l	1
player_mdest	rs.l	1
player_destroute rs.l	1
msource		rs.l	1

codetab		rs.b	128	; parameter-codes currently in use
active_csources	rs.l	1	; number of active controlsources
active_csources_m1 rs.l	1	; number of active controlsources, -1

irqptr_out	rs.l	1
writeptr_out	rs.l	1
upperlimit_out	rs.l	1



;csc = prec3+pcc_sizeof*maxcs
;chanc = csc+pc_sizeof*maxtracks
;playcounters	rs.b	16*chanc
			; channel1, channel2, ..., channel16
			; presettrack, pitchtrack, mpresstrack,
			; ctrack[0],...,ctrack[maxcs],
			; track[0],..., track[maxtracks]

playcounters	rs.l	1
chanc		rs.w	1
csc		rs.w	1


bpmplaycounter	rs.b	pcbpm_sizeof



disk_track	rs.b	trs_sizeof	; Temp-Puffer fr Tracksaver
disk_pattern	rs.b	pts_sizeof	; Temp-Puffer fr Patternsaver
disk_channel	rs.b	chs_sizeof	; Temp-Puffer fr Channelsaver
disk_csource	rs.b	css_sizeof	; Temp-Puffer fr Controlsource


serialoutpuffer	rs.b	serialoutsize


lib_sizeof	rs.b	0




