;APS000012E70000A9AF0000000000000000000000000000000000000000000000000000000000000000
;==============================================================
;==============================================================
;==============================================================
;==============================================================
;==============================================================
;
;
;
;
;               R A W K E Y   R O U T I N E N
;
;
;
;
;
;==============================================================
;==============================================================
;==============================================================
;==============================================================
;==============================================================


mainrawkey

	tst.b	d5
	smi	is_upstroke(a5)
	bmi.s	.upstroke

;=== downstroke
	lea	.rawkeytab(pc),a0
	lea	.rawjumptab(pc),a1
	moveq	#.rawtabsize-1,d0
.rawloop
	cmp.b	(a0)+,d5
	dbeq	d0,.rawloop
	bne.s	.unknown
	add.w	d0,d0
	adda.w	d0,a1
	adda.w	(a1),a1

	bsr	make_qualifier
	jsr	(a1)

.unknown
	rts




.upstroke
	sub.b	#$80,d5
	lea	.rawkeyuptab(pc),a0
	lea	.rawjumpuptab(pc),a1
	moveq	#.rawuptabsize-1,d0
	bra.s	.rawloop




.rawkeytab
		;ESC f1  f2  f3  f4  f5  f6  f7  f8  f9  f10
	dc.b	$45,$50,$51,$52,$53,$54,$55,$56,$57,$58,$59
		;`   1   2   3   4   5   6   7   8   9   0         \
	dc.b	$00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0a,$0b,$0c,$0d
		;q   w   e   r   t   z   u   i   o   p      +
	dc.b	$10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$1a,$1b
		;a   s   d   f   g   h   j   k   l         #
	dc.b	$20,$21,$22,$23,$24,$25,$26,$27,$28,$29,$2a,$2b
		;<   y   x   c   v   b   n   m   ,   .   -
	dc.b	$30,$31,$32,$33,$34,$35,$36,$37,$38,$39,$3a
		;spc bs tab cr  del c-u c-d c-r c-l help
	dc.b	$40,$41,$42,$44,$46,$4c,$4d,$4e,$4f,$5f
	;numpad:
		;[   ]   /   *
	dc.b	$5a,$5b,$5c,$5d
		;7   8   9   -
	dc.b	$3d,$3e,$3f,$4a
		;4   5   6   +
	dc.b	$2d,$2e,$2f,$5e
		;1   2   3  enter
	dc.b	$1d,$1e,$1f,$43
		;0   .
	dc.b	$0f,$3c

.rawtabsize = *-.rawkeytab

	even

;=== Rawkey jumptable - andersherum als die keys in rawkeytab !
.rawjumptab
	dr.w	key_pad_punkt
	dr.w	key_pad_0
	dr.w	key_pad_enter
	dr.w	key_pad_3
	dr.w	key_pad_2
	dr.w	key_pad_1
	dr.w	key_pad_plus
	dr.w	key_pad_6
	dr.w	key_pad_5
	dr.w	key_pad_4
	dr.w	key_pad_minus
	dr.w	key_pad_9
	dr.w	key_pad_8
	dr.w	key_pad_7
	dr.w	key_pad_stern
	dr.w	key_pad_slash
	dr.w	key_pad_bracket2
	dr.w	key_pad_bracket1
	dr.w	key_help
	dr.w	key_crsr_left
	dr.w	key_crsr_right
	dr.w	key_crsr_down
	dr.w	key_crsr_up
	dr.w	key_delete
	dr.w	key_return
	dr.w	key_tab
	dr.w	key_backspace
	dr.w	key_space
	dr.w	key_minus
	dr.w	key_punkt
	dr.w	key_komma
	dr.w	key_m
	dr.w	key_n
	dr.w	key_b
	dr.w	key_v
	dr.w	key_c
	dr.w	key_x
	dr.w	key_y
	dr.w	key_kleiner
	dr.w	key_fis
	dr.w	key_ae
	dr.w	key_oe
	dr.w	key_l
	dr.w	key_k
	dr.w	key_j
	dr.w	key_h
	dr.w	key_g
	dr.w	key_f
	dr.w	key_d
	dr.w	key_s
	dr.w	key_a
	dr.w	key_plus
	dr.w	key_ue
	dr.w	key_p
	dr.w	key_o
	dr.w	key_i
	dr.w	key_u
	dr.w	key_z
	dr.w	key_t
	dr.w	key_r
	dr.w	key_e
	dr.w	key_w
	dr.w	key_q
	dr.w	key_backslash
	dr.w	key_apostroph
	dr.w	key_sz
	dr.w	key_0
	dr.w	key_9
	dr.w	key_8
	dr.w	key_7
	dr.w	key_6
	dr.w	key_5
	dr.w	key_4
	dr.w	key_3
	dr.w	key_2
	dr.w	key_1
	dr.w	key_bwsinglequote
	dr.w	key_functionkeys
	dr.w	key_functionkeys
	dr.w	key_functionkeys
	dr.w	key_functionkeys
	dr.w	key_functionkeys
	dr.w	key_functionkeys
	dr.w	key_functionkeys
	dr.w	key_functionkeys
	dr.w	key_functionkeys
	dr.w	key_functionkeys
	dr.w	key_esc






.rawkeyuptab
		;f1  f2  f3  f4  f5
	dc.b	$50,$51,$52,$53,$54
		;1   2   3   4   5   6   7   8   9   0         \
	dc.b	$01,$02,$03,$04,$05,$06,$07,$08,$09,$0a,$0b,$0c,$0d
		;q   w   e   r   t   z   u   i   o   p      +
	dc.b	$10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$1a,$1b
		;a   s   d   f   g   h   j   k   l         #
	dc.b	$20,$21,$22,$23,$24,$25,$26,$27,$28,$29,$2a,$2b
		;<   y   x   c   v   b   n   m   ,   .   -
	dc.b	$30,$31,$32,$33,$34,$35,$36,$37,$38,$39,$3a
		;enter
	dc.b	$43

.rawuptabsize = *-.rawkeyuptab

	even

;=== Rawkey jumptable - andersherum als die keys in rawkeyuptab !
.rawjumpuptab

	dr.w	keyup_enter
	dr.w	key_minus
	dr.w	key_punkt
	dr.w	key_komma
	dr.w	keyup_m
	dr.w	key_n
	dr.w	key_b
	dr.w	key_v
	dr.w	key_c
	dr.w	key_x
	dr.w	key_y
	dr.w	key_kleiner
	dr.w	key_fis
	dr.w	key_ae
	dr.w	key_oe
	dr.w	key_l
	dr.w	keyup_k
	dr.w	key_j
	dr.w	keyup_h
	dr.w	key_g
	dr.w	key_f
	dr.w	keyup_d
	dr.w	keyup_s
	dr.w	key_a
	dr.w	key_plus
	dr.w	key_ue
	dr.w	key_p
	dr.w	key_o
	dr.w	keyup_i
	dr.w	key_u
	dr.w	key_z
	dr.w	key_t
	dr.w	key_r
	dr.w	key_e
	dr.w	key_w
	dr.w	key_q
	dr.w	key_backslash
	dr.w	key_apostroph
	dr.w	key_sz
	dr.w	key_0
	dr.w	key_9
	dr.w	key_8
	dr.w	key_7
	dr.w	key_6
	dr.w	key_5
	dr.w	key_4
	dr.w	key_3
	dr.w	key_2
	dr.w	key_1
	dr.w	keyup_functionkeys
	dr.w	keyup_functionkeys
	dr.w	keyup_functionkeys
	dr.w	keyup_functionkeys
	dr.w	keyup_functionkeys






key_esc
	tst.b	ctrlpressed(a5)
	bne	panic_button

; close the active window

	bsr.s	find_window_struct
	beq.s	.not

	move.l	wd_IDCMP(a1),a0
	move.w	(a0)+,d1
.idcmploop

	cmp.l	#$200,(a0)+
	beq.s	.found

	addq.l	#4,a0
	dbf	d1,.idcmploop

.not	rts

.found	adda.l	(a0),a0
	jmp	(a0)





find_window_struct	; a4 = windowptr
			; returns: pos = struct found, neg = not found
			;          a0 = ^windowtable-entry
			;          a1 = ^windowstruct

	move.l	windowtableD(a5),a0
	bra.s	.jin
.windowloop
	move.l	wd_Wnd(a5,d0.w),d1
	beq.s	.next
	cmpa.l	d1,a4
	beq.s	.found
.next	lea	windowtable_entry_sizeof(a0),a0
.jin	move.w	(a0),d0
	bne.s	.windowloop

	NEGATIV

.found	lea	(a5,d0.w),a1
	POSITIV





;=== Qualifier berechnen
make_qualifier	; d3.w=ie_Qualifier
	move.w	d3,d0
	and.w	#$03,d0
	sne	shiftpressed(a5)

;=== LAlt = 1, RAlt = -1 (Both-Alt = RAlt)

	btst	#5,d3
	bne.s	.ralt
	btst	#4,d3
	bne.s	.lalt
	sf	altpressed(a5)
	bra.s	.altcont
.lalt	move.b	#1,altpressed(a5)
	bra.s	.altcont
.ralt	st	altpressed(a5)
.altcont

	move.w	d3,d0
	and.w	#$c0,d0
	sne	amigapressed(a5)

	btst	#3,d3
	sne	ctrlpressed(a5)

;	btst	#13,d3
;	sne	rmbpressed(a5)

;	btst	#2,d3
;	sne	capslockpressed(a5)

	rts





key_functionkeys
	tst.b	shiftpressed(a5)
	bne	.withshift
	tst.b	amigapressed(a5)
	bne	.withamiga
	tst.b	altpressed(a5)
	bne	.withalt

	cmp.b	#$50,d5			; F1
	beq	fastrewind_key_down
	cmp.b	#$51,d5			; F2
	beq	forward_key_down
	cmp.b	#$52,d5			; F3
	beq	fastforward_key_down
	cmp.b	#$53,d5			; F4
	beq.s	.playrec_patt
	cmp.b	#$54,d5			; F5
	beq.s	.playrec_song

	tst.b	playflag(a5)
	bne	.rts

	cmp.b	#$55,d5			; F6
	bcs	.rts
	move.w	d5,d0
	sub.w	#$55,d0
	move.w	currentchannel(a5),d1
	bsr	get_function_key
	move.l	d0,eventpos(a5)

	bra	key_after


.playrec_patt
	tst.b	ctrlpressed(a5)
	bne.s	.recpatt
	bra	play_patt_menu
.recpatt
	bra	rec_patt_menu

.playrec_song
	tst.b	ctrlpressed(a5)
	bne.s	.recsong
	bra	play_song_menu
.recsong
	bra	rec_song_menu



.withshift
	cmp.b	#$55,d5			; F6
	bcs.s	.editfunctions

	sub.w	#$55,d5
	lea	fkeyeventtab(pc),a0
	IFEQ	mc68020
	lsl.w	#3,d5
	move.l	eventpos(a5),(a0,d5.w)
	move.l	events(a5),4(a0,d5.w)
	ELSE
	move.l	eventpos(a5),(a0,d5.w*8)
	move.l	events(a5),4(a0,d5.w*8)
	ENDC

	move.w	#loc_fkey_stored,d0
	jsr	status_displayJ(a5)

	jsr	RedrawPatternOhneScrJ(a5)
	jmp	Refresh_pgfx_areaJ(a5)


.withalt
	cmp.b	#$55,d5
	bcs.s	.editfunctions

	move.w	d5,d0
	sub.w	#$55,d0
	move.w	currentchannel(a5),d1
	bsr	get_function_key
	move.l	d0,d2
	bra	play_patt_routine


;=== F1 bis F5 mit Shift oder Alt (Editierfunktionen)

.editfunctions
	cmp.b	#$51,d5
	beq	.join
	cmp.b	#$52,d5
	beq	.cut
	cmp.b	#$53,d5
	beq	.copy
	cmp.b	#$54,d5
	beq	.paste

.rts	rts


.withamiga
	lea	toolskeytab(pc),a0
	move.w	d5,d1
	sub.w	#$50,d1
	bra	jump_into_long_table




.cut	tst.b	altpressed(a5)
	bne.s	.altcut
	bra	edit_cuttrack
.altcut	tst.b	shiftpressed(a5)
	bne	edit_cutpattern
	bra	edit_cutchannel

.copy	tst.b	altpressed(a5)
	bne.s	.altcopy
	bra	edit_copytrack
.altcopy
	tst.b	shiftpressed(a5)
	bne	edit_copypattern
	bra	edit_copychannel

.paste	tst.b	altpressed(a5)
	bne.s	.altpaste
	bra	edit_pastetrack
.altpaste
	tst.b	shiftpressed(a5)
	bne	edit_pastepattern
	bra	edit_pastechannel

.join	tst.b	altpressed(a5)
	bne.s	.altjoin
	bra	edit_jointrack
.altjoin
	rts
;	tst.b	shiftpressed(a5)
;	bne	edit_joinpattern
;	bra	edit_joinchannel




toolskeytab
	IFNE	keyfile_active
midifilter_key_id = (*-toolskeytab)/4
	dr.l	nop_gadget
	ELSE
	dr.l	midifilter
	ENDC
	dr.l	nop_gadget ; sample_dump
	dr.l	channelscope
	dr.l	parametergfx
	dr.l	nop_gadget ; sample_processor
	dr.l	score
	dr.l	midi_activity
	IFNE	keyfile_active
remapper_key_id = (*-toolskeytab)/4
	dr.l	nop_gadget
	ELSE
	dr.l	remapper
	ENDC
	dr.l	sysex_editor




keyup_functionkeys
	cmp.b	#$53,d5			; F4
	bcc.s	.rts

	cmp.b	#$50,d5			; F1
	beq	fastrewind_key_up
	cmp.b	#$51,d5			; F2
	beq	forward_key_up
	cmp.b	#$52,d5			; F3
	beq	fastforward_key_up

.rts	rts






get_function_key	; d0.w = key (0-4), d1.w = channel (1-16)
			; returns: d0=event-position in the channel

	move.l	d0,d2
	move.l	d1,d0
	jsr	GetAnyChannelResolutionJ(a5)
	move.l	d0,d3

	IFEQ	mc68020
	lsl.w	#3,d2
	movem.l	fkeyeventtab(pc,d2.w),d0-d1
	ELSE
	movem.l	fkeyeventtab(pc,d2.w*8),d0-d1	; d0 = eventpos, d1=total events
	ENDC

	move.l	events(a5),d2

	mulu	d2,d0
	divu	d1,d0
	ext.l	d0
	move.l	d0,d1
	divu	d3,d1
	swap	d1
	ext.l	d1
	sub.l	d1,d0
	rts


fkeyeventtab
	dc.l	0,events_def
	dc.l	events_def/4,events_def
	dc.l	events_def/4*2,events_def
	dc.l	events_def/4*3,events_def
	dc.l	events_def-pattscale_def,events_def




key_1
	moveq	#1,d3
	moveq	#-1,d4



;=== d3 is the digit (if 0-9/A-F was pressed)
;=== d3 = -1 means, the pressed key is NOT a digit entry
;=== d4 is the note (e.g. YXCVB....), starting at 1 for lower-C
;=== d4 = -1 means, no note belongs to this key; 0 means, DEL was pressed
;=== d4=34 means, generate Note-OFF

editentry	; d3=nibble, d4=note, falls 2. position

	tst.b	is_upstroke(a5)
	bne	.upstroke


; check for hotkeys ctrl 0-9

	tst.b	ctrlpressed(a5)
	beq.s	.noquant
	move.l	d3,d2
	bmi.s	.noquant
	moveq	#9,d1
	cmp.l	d1,d2
	bgt.s	.noquant
	bsr	quantctrl
	bra	quant_set2
.noquant



; check for hotkeys shift 0-9

	tst.b	shiftpressed(a5)
	beq.s	.noshift
	move.l	d3,d1
	bmi.s	.noshift
	bne.s	.add1
	moveq	#10,d1
.add1	subq.l	#1,d1
	moveq	#9,d0
	cmp.l	d0,d1
	bgt.s	.noshift
	sub.l	displaytrack(a5),d1
	bmi.s	.nope
	cmp.l	displayed_tracks(a5),d1
	bpl.s	.nope
	moveq	#GD_track0,d0
	add.l	d0,d1
	jmp	mb_tracksJ(a5)
.noshift


	tst.b	playflag(a5)
	bne.s	.nope

	tst.b	editmode(a5)
	beq	.no_editmode

	tst.l	active_channelwindow(a5)
	bmi.s	.nope


	tst.l	currenttrack(a5)
	bmi.s	.no_notetrack

	cmp.w	#2,cursorpos(a5)
	bne.s	.no_notepos

;	cmp.b	#34,d4				; Note OFF ?
;	beq.s	.note

	tst.w	d4
	bpl.s	.note
	bra.s	.nope

.no_notepos
	tst.w	d3
	bmi.s	.nope

;====================== d3=-1 bedeutet: keine Ziffer !
;	cmp.w	#2,cursorpos(a5)
;	bne.s	.nope

;.nibble
;	tst.w	d4
;	bpl.s	.note

;====================== d4=-1 bedeutet: keine Note; d4=0 ist DEL !
;	cmp.w	#2,cursorpos(a5)
;	beq.s	.nope

.note
	bsr	check_state_before

	move.l	currenttrack(a5),d0
	jsr	GetOrAllocTrackJ(a5)
	beq.s	.nope
	move.l	eventpos(a5),d0
	IFEQ	mc68020
	lsl.l	#2,d0
	lea	tr_sizeof(a0,d0),a0
	ELSE
	lea	tr_sizeof(a0,d0.l*4),a0
	ENDC
	lea	.trackpostab(pc),a1
	bra	.dotab

.nope	rts

.no_notetrack
	tst.w	d3
	bmi.s	.nope

	bsr	check_state_before

	move.l	currenttrack(a5),d0
	addq.l	#1,d0
	beq.s	.cstrack
	addq.l	#1,d0
	beq	.presettrack

;=== BPM Track
	jsr	GetOrAllocBPMTrackJ(a5)
	beq.s	.nope
	move.l	eventpos(a5),d0
	add.l	d0,d0
	adda.l	d0,a0
	lea	.bpmtrackpostab(pc),a1
	bra	.dotab

;=== Controlsources Track
.cstrack
	move.w	pgfx_active(a5),d0
	bne.s	.noPB

;=== Pitchbend
	jsr	GetOrAllocPibeTrackJ(a5)
	beq.s	.nope
	move.l	eventpos(a5),d0
	add.l	d0,d0
	adda.l	d0,a0
	lea	.pbtrackpostab(pc),a1
	bra.s	.checkanddo

.noPB	subq.w	#1,d0
	jsr	GetOrAllocCSourceTrackDataJ(a5)
	beq.s	.nope
	adda.l	eventpos(a5),a0
	lea	.ctrackpostab(pc),a1
.checkanddo
	bra.s	.dotab
;	jmp	Refresh_pgfx_areaJ(a5)


;=== Preset Track
.presettrack
	jsr	GetOrAllocPresetTrackJ(a5)
	beq.s	.nope
	move.l	eventpos(a5),d0
	add.l	d0,d0
	adda.l	d0,a0
	lea	.ptrackpostab(pc),a1
.dotab	move.w	cursorpos(a5),d1
	add.w	d1,d1
	adda.w	d1,a1
	adda.w	(a1),a1
	tst.w	d4
	jsr	(a1)



	IFEQ	1

;=== check if the song has been changed
	move.l	trackchanged(a5),a0
	move.l	maxtracks_m1(a5),d0
.changeloop
	tst.b	(a0)+
	dbne	d0,.changeloop
	bne.s	.changed

	move.l	ctrackchanged(a5),a0
	move.l	active_csources_m1(a5),d0
.cschangeloop
	tst.b	(a0)+
	dbne	d0,.cschangeloop
	bne.s	.changed

	tst.b	ptrackchanged(a5)
	bne.s	.changed
	tst.b	bpmtrackchanged(a5)
	bne.s	.changed
	tst.b	mptrackchanged(a5)
	bne.s	.changed
	tst.b	pbtrackchanged(a5)
	bne.s	.changed
	rts

.changed
	st	songchanged(a5)

	ENDC

	rts





;=== Bei Non-editmode: klimpern auf Tastatur mglich

.no_editmode
	tst.b	d4				; DEL pressed, or not a note
	ble.s	.nosend
	cmp.b	#34,d4				; Note-off-key pressed?
	beq.s	.nosend

	lea	keyb_notekeys(a5),a0
	tst.b	-1(a0,d4.w)
	bne.s	.nosend

	bsr	convert_note
	beq.s	.nosend

	move.b	d1,-1(a0,d4.w)
	move.w	currentchannel(a5),d0
	move.w	d0,keyb_lastchan(a5)



;=== play note with mapping channels

	move.b	firstautovel(a5),d2
	bsr	play_note



.nosend
.rts	rts





.upstroke

	tst.b	playflag(a5)
	bne.s	.rts

	tst.l	d4
	bmi.s	.rts

	tst.b	editmode(a5)
	bne.s	.editm

;=== Beim Klimpern auf der Tastatur: Note-OFF erzeugen!

	lea	keyb_notekeys(a5),a0
	move.b	-1(a0,d4.w),d1
	beq.s	.nosend
	sf	-1(a0,d4.w)


	move.w	keyb_lastchan(a5),d0
	moveq	#0,d2		; play note-off
	bsr	play_note



.editm
	tst.l	currenttrack(a5)
	bmi.s	.rts

	cmp.b	#34,d4				; Note OFF ?
	beq.s	.rts
	tst.w	d4
	beq.s	.rts

	cmp.w	#2,cursorpos(a5)
	bne.s	.rts
	bra	.note






.trackpostab
	dr.w	trackpos0
	dr.w	trackpos1
	dr.w	trackpos2
;	dr.w	trackpos3
;	dr.w	trackpos4

.ptrackpostab
	dr.w	ptrackpos0
	dr.w	ptrackpos1
	dr.w	ptrackpos2
	dr.w	ptrackpos3
	dr.w	ptrackpos4
	dr.w	ptrackpos5

.bpmtrackpostab
	dr.w	bpmtrackpos0
	dr.w	bpmtrackpos1
	dr.w	bpmtrackpos2
	dr.w	bpmtrackpos3
	dr.w	bpmtrackpos4

.pbtrackpostab
	dr.w	pbtrackpos0
	dr.w	pbtrackpos1
	dr.w	pbtrackpos2
	dr.w	pbtrackpos3

;.mptrackpostab
;	dr.w	mptrackpos0
;	dr.w	mptrackpos1

.ctrackpostab
	dr.w	ctrackpos0
	dr.w	ctrackpos1





play_note	; d0.w=midi channel (1-16), d1=note, d2=velocity

	lea	channels_maps(a5),a0
	IFEQ	mc68020
	add.w	d0,d0
	move.w	-2(a0,d0.w),d7
	ELSE
	move.w	-2(a0,d0.w*2),d7
	ENDC

	lea	desttranss(a5),a0
	move.b	d1,d5
	moveq	#15,d3
.trigloop
	btst	d3,d7
	beq.s	.nomap

	move.b	d5,d1
	jsr	dest_transposeJ(a5)
	; new note in d1
	moveq	#-$70,d0
	or.b	d3,d0
	jsr	send_3_bytesJ(a5)

.nomap	dbf	d3,.trigloop
	rts






chord_quant_crsr_down
	tst.b	editmode(a5)
	beq.s	quant_crsr_down
	tst.l	currenttrack(a5)
	bmi.s	quant_crsr_down
	cmp.w	#2,cursorpos(a5)
	bne.s	quant_crsr_down
	tst.b	chordmode(a5)
	beq.s	quant_crsr_down

	bsr	check_state_after

;	jsr	check_currenttrack_stateJ(a5)

;=== notes are entered in chord mode (jump to next track instead of scrolling
;=== down)
	move.l	currenttrack(a5),d0
	addq.l	#1,d0
	cmp.l	maxtracks(a5),d0
	bmi.s	.nextok
	moveq	#0,d0
.nextok	move.l	displaytrack(a5),d1
	cmp.l	d1,d0
	bcc.s	.ok2
	move.l	d0,d1
	bra.s	.set
.ok2	add.l	displayed_tracks(a5),d1
	cmp.l	d1,d0
	bcs.s	.ok
	move.l	d0,d1
	sub.l	displayed_tracks(a5),d1
	addq.l	#1,d1
.set	move.l	d1,displaytrack(a5)
	move.l	d0,-(sp)
	jsr	RefreshNumsJ(a5)
	move.l	(sp)+,d0
.ok
	move.l	d0,currenttrack(a5)
	bra.s	quant_redraw


quant_crsr_down

	bsr	check_state_after
;	jsr	check_currenttrack_stateJ(a5)


next_quant_position

	jsr	GetChannelResolutionJ(a5)
	move.l	d0,d3
	move.l	quantize(a5),d1
	mulu	d1,d0
	move.l	eventpos(a5),d2
	add.l	d0,d2
	move.l	events(a5),d1
	cmp.l	d2,d1
	bhi.s	.draw
	move.l	d1,d2
	sub.l	d3,d2
.draw	move.l	d2,eventpos(a5)


quant_redraw
	moveq	#-1,d0
	cmp.l	currenttrack(a5),d0
	beq.s	.is_cs
	jsr	pgfx_running_lineJ(a5)
	bra.s	.cscont
.is_cs	jsr	Refresh_pgfx_areaJ(a5)
.cscont

	bsr	RefreshBlock
	jsr	RedrawAllTrackdisplaysJ(a5)
	jmp	RefreshCurrentChannelEnableJ(a5)





check_state_before

	bsr	CheckPatternState
	sne	pattern_filled(a5)

	jsr	GetChannelJ(a5)
	sne	channel_filled(a5)

	tst.b	editmode(a5)
	beq.s	.noeditmode

	move.l	currenttrack(a5),d0
	bpl.s	.note_track
	addq.l	#1,d0
	beq.s	.cstrack
	addq.l	#1,d0
	beq.s	.ptrack

	jsr	GetBPMTrackJ(a5)
.make	sne	currenttrack_filled(a5)
.noeditmode
	rts

.ptrack	jsr	GetPresetTrackJ(a5)
	bra.s	.make

.cstrack
	move.w	pgfx_active(a5),d0
	beq.s	.pb
	subq.w	#1,d0
	jsr	GetCSourceTrackJ(a5)
	bra.s	.make
.pb	jsr	GetPibeTrackJ(a5)
	bra.s	.make

.note_track
	jsr	GetTrackJ(a5)
	bra.s	.make




check_state_after

	bsr	CheckPatternState
	sne	d0
	cmp.b	pattern_filled(a5),d0
	beq.s	.nopattchange

	bsr	refreshpatt

.nopattchange


	jsr	GetChannelJ(a5)
	sne	d0
	cmp.b	channel_filled(a5),d0
	beq.s	.nochanchange

	jsr	RefreshCurrentChannelEnableJ(a5)
	jsr	RefreshCurrentGlobalChannelStateJ(a5)
	jsr	score_refreshJ(a5)

.nochanchange


	tst.b	editmode(a5)
	beq.s	.noeditmode

	move.l	currenttrack(a5),d0
	bpl.s	.note_track
	addq.l	#1,d0
	beq.s	.cstrack
	addq.l	#1,d0
	beq.s	.ptrack

	jsr	GetBPMTrackJ(a5)
	sne	d0
	cmp.b	currenttrack_filled(a5),d0
	beq.s	.notrackchange
	jmp	RefreshBPMTrackJ(a5)

.noeditmode
.notrackchange
	rts

.ptrack	jsr	GetPresetTrackJ(a5)
	sne	d0
	cmp.b	currenttrack_filled(a5),d0
	beq.s	.notrackchange
	jmp	RefreshPresetTrackJ(a5)

.cstrack
	move.w	pgfx_active(a5),d0
	beq.s	.pb
	subq.w	#1,d0
	jsr	GetCSourceTrackJ(a5)
.cs	sne	d0
	cmp.b	currenttrack_filled(a5),d0
	beq.s	.notrackchange
	jsr	RefreshCSModeJ(a5)
	jmp	Refresh_pgfx_lvJ(a5)

.pb	jsr	GetPibeTrackJ(a5)
	bra.s	.cs

.note_track
	jsr	GetTrackJ(a5)
	sne	d0
	cmp.b	currenttrack_filled(a5),d0
	beq.s	.notrackchange
	jmp	RefreshCurrenttrackJ(a5)







;=== 0. Position
trackpos0
	beq.s	deltpos0
	cmp.b	#34,d4		; NOTE OFF ?
	beq	trackpos2
	cmp.b	#8,d3
	bpl.s	.rts
	tst.b	vel_or_pp(a5)
	bne.s	.pp
	move.b	wd_vel(a0),d0
	and.b	#$0f,d0
	lsl.b	#4,d3
	bne.s	.goon
	tst.b	d0
	beq.s	.rts		; do not allow velocity 0
.goon	add.b	d3,d0
	move.b	d0,wd_vel(a0)
	bra.s	down_track
.rts	rts

.pp	move.b	wd_pp(a0),d0
	and.b	#$0f,d0
	lsl.b	#4,d3
	add.b	d3,d0
	move.b	d0,wd_pp(a0)
	bra.s	down_track



deltpos0
	tst.b	vel_or_pp(a5)
	beq.s	.vel
	move.b	#PP_stay,wd_pp(a0)
	bra.s	down_track
.vel	move.b	#Vel_clear,wd_vel(a0)
	bsr	checkfree_track_and_channel
down_track
	bsr	quant_crsr_down
track_change
	st	songchanged(a5)
;	move.l	trackchanged(a5),a0
;	move.l	currenttrack(a5),d0
;	st	(a0,d0.l)
	rts


;=== 1. Position
trackpos1
	beq.s	deltpos0
	cmp.b	#34,d4		; NOTE OFF ?
	beq.s	trackpos2
	tst.b	vel_or_pp(a5)
	bne.s	.pp
	move.b	wd_vel(a0),d0
	and.b	#$70,d0
	tst.b	d3
	bne.s	.goon
	tst.b	d0
	beq.s	.rts
.goon	add.b	d3,d0
	move.b	d0,wd_vel(a0)
	bra.s	down_track
.rts	rts

.pp	move.b	wd_pp(a0),d0
	and.b	#$70,d0
	add.b	d3,d0
	move.b	d0,wd_pp(a0)
	bra.s	down_track




;=== 2. Position
trackpos2
	tst.b	d4
	bne.s	.nodel

;================ DEL key
	clr.b	wd_pitch(a0)
	tst.b	autovelflag(a5)
	beq.s	.novel2
	move.b	#Vel_clear,wd_vel(a0)
.novel2
	bsr.s	track_change
	bsr	checkfree_track_and_channel
	bra	chord_quant_crsr_down



.nodel
	bsr	convert_note
	beq	.rts

	cmp.b	#34,d4			; NOTE OFF ?
	beq.s	.off

	lea	keyb_notekeys(a5),a1
	tst.b	is_upstroke(a5)
	bne.s	.send_off

	move.b	d1,-1(a1,d4.w)
	moveq	#1,d2
	bra.s	.note

.send_off
	move.b	-1(a1,d4.w),d1
	beq.s	.rts
	sf	-1(a1,d4.w)
.off	moveq	#0,d2

.note
	subq.w	#4,sp
	move.w	currentchannel(a5),d0
	subq.w	#1,d0
	add.b	#$90,d0
	move.b	d0,(sp)
	move.b	d1,1(sp)

	tst.b	d2
	beq.s	.dovel


;=== ggf. velocity eintragen
	tst.b	is_upstroke(a5)
	beq.s	.avel
	move.b	firstautovel(a5),d2
	bra.s	.dovel

.avel	tst.b	autovelflag(a5)
	beq.s	.novel

;=== Auto Velocity: Velocity der letzten Note bernehmen!!!
	move.b	d1,d2
	bsr.s	get_last_velocity
	exg	d1,d2
	bra.s	.dovel

;.dovel	move.b	d1,2(sp)
;	move.l	sp,a1
;	moveq	#3,d1
;	jsr	send_streamJ(a5)
;	bra.s	.playok

.novel	move.b	wd_vel(a0),d2
.dovel	move.b	d2,2(sp)
;	cmp.b	#Vel_clear,d2
;	bne.s	.velok
;	move.b	firstautovel(a5),d2
.velok	move.w	currentchannel(a5),d0
	bsr	play_note
;	jsr	send_3_bytesJ(a5)
.playok


	move.b	ignorenoffs(a5),3(sp)
	cmp.b	#34,d4
	sne	ignorenoffs(a5)
	move.l	sp,a2
	jsr	MakeOnline_routineJ(a5)
	move.l	(sp)+,d0
	move.b	d0,ignorenoffs(a5)
.rts	rts






get_last_velocity	; returns: d1=Velocity of last Note
			; (either Note-ON or Note-OFF)

	movem.l	d2/a0,-(sp)
	move.l	currenttrack(a5),d0
	jsr	GetTrackDataJ(a5)
	beq.s	.noval

	move.l	eventpos(a5),d0
	IFEQ	mc68020
	lsl.l	#2,d0
	lea	(a0,d0.l),a1
	ELSE
	lea	(a0,d0.l*4),a1
	ENDC
	move.b	#Vel_clear,d2
.vloop	subq.w	#wd_sizeof,a1
	cmpa.l	a0,a1
	bcs.s	.noval
	move.b	wd_vel(a1),d1
	cmp.b	d1,d2
	beq.s	.vloop
	bra.s	.out

.noval	move.b	firstautovel(a5),d1
.out	movem.l	(sp)+,d2/a0
	rts






convert_note	; d4=keyboard-note (bleibt unverndert)
		; zurck: d1=MIDI-Note, pos/neg

	move.w	octave(a5),d0
	move.w	d0,d1	; = mulu #12,d0
	lsl.w	#3,d1	;
	lsl.w	#2,d0	;
	add.w	d0,d1	;
	add.w	d4,d1
	subq.w	#1,d1
	cmp.w	#$80,d1
	bcc.s	.neg
	POSITIV
.neg	NEGATIV




	IFEQ	1

;=== 3. Position
trackpos3
	beq.s	deltpos3
	cmp.b	#34,d4		; NOTE OFF ?
	beq	trackpos2
	cmp.b	#8,d3
	bpl.s	.rts
	lsl.b	#4,d3
	and.b	#$0f,wd_pp(a0)
	or.b	d3,wd_pp(a0)
	bra	down_track
.rts	rts

deltpos3
	move.b	#PP_stay,wd_pp(a0)
	bra	down_track

;=== 4. Position
trackpos4
	beq.s	deltpos3
	cmp.b	#34,d4		; NOTE OFF ?
	beq	trackpos2
	and.b	#$70,wd_pp(a0)
	or.b	d3,wd_pp(a0)
	bra	down_track

	ENDC



ptrackpos0
	beq.s	delctrack
	cmp.b	#9,d3
	bhi.s	.rts
	mulu	#100,d3
	moveq	#0,d0
	move.b	(a0),d0
	divu	#100,d0
	swap	d0		; d0 = 0ze
	bra.s	do_pre1
.rts	rts

ptrackpos1
	beq.s	delctrack
	cmp.b	#9,d3
	bhi.s	prerts1
	mulu	#10,d3		; d3 = 0z0
	moveq	#0,d0
	move.b	(a0),d0
	divu	#10,d0
	move.l	d0,d2		; d0 = 0hz
	swap	d2		; d2 = 00e
	ext.l	d0
	divu	#10,d0
	ext.l	d0		; d0 = 00h
	mulu	#100,d0		; d0 = h00
	add.w	d2,d0		; d0 = h0e
do_pre1	add.w	d3,d0		; d0 = hze
	cmp.w	#127,d0
	bhi.s	prerts1
	move.b	d0,(a0)
	bra.s	down_ptrack
prerts1	rts

ptrackpos2
	beq.s	delctrack
	cmp.b	#9,d3
	bhi.s	.rts
	moveq	#0,d0
	move.b	(a0),d0
	moveq	#10,d1
	divu	d1,d0
	ext.l	d0		; d0 = 0hz
	mulu	d1,d0		; d0 = hz0
	bra.s	do_pre1
.rts	rts



delctrack
	move.w	#Preset_stay,(a0)
	bsr	checkfree_track_and_channel
down_ptrack
	st	songchanged(a5)
;	st	ptrackchanged(a5)
	move.w	(a0),d0
	beq.s	.nosend
	bsr.s	send_preset_message
.nosend	bra	quant_crsr_down



ptrackpos3
	beq.s	delctrack
	cmp.b	#9,d3
	bhi.s	.rts
	mulu	#100,d3
	moveq	#0,d0
	move.b	1(a0),d0
	divu	#100,d0
	swap	d0		; d0 = 0ze
	bra.s	do_pre2
.rts	rts

ptrackpos4
	beq.s	delctrack
	cmp.b	#9,d3
	bhi.s	prerts2
	mulu	#10,d3		; d3 = 0z0
	moveq	#0,d0
	move.b	1(a0),d0
	divu	#10,d0
	move.l	d0,d2		; d0 = 0hz
	swap	d2		; d2 = 00e
	ext.l	d0
	divu	#10,d0
	ext.l	d0		; d0 = 00h
	mulu	#100,d0		; d0 = h00
	add.w	d2,d0		; d0 = h0e
do_pre2	add.w	d3,d0		; d0 = hze
	cmp.w	#127,d0
	bhi.s	prerts2
	move.b	d0,1(a0)
	bra.s	down_ptrack
prerts2	rts

ptrackpos5
	beq.s	delctrack
	cmp.b	#9,d3
	bhi.s	.rts
	moveq	#0,d0
	move.b	1(a0),d0
	moveq	#10,d1
	divu	d1,d0
	ext.l	d0		; d0 = 0hz
	mulu	d1,d0		; d0 = hz0
	bra.s	do_pre2
.rts	rts







;=== send MIDI message

send_preset_message	; d0=preset
	move.w	currentchannel(a5),d6

send_preset		; d0=preset, d6=channel (1-16)
	subq.w	#1,d6
	move.l	replaypufferD(a5),a4
	bsr.s	make_preset_message

	move.l	replaypufferD(a5),a1
	move.l	a4,d1
	sub.l	a1,d1
	jmp	send_stream_mainJ(a5)




make_preset_message	; d0=preset, a4=^buffer, d6=channel (0-15)

;=== check output filter
	tst.b	global_outfilters(a5)
	beq.s	.nofilter
	move.w	pchg_ofilter(a5),d2
	btst	d6,d2
	bne	.rts
.nofilter


	lea	pchgtypes(a5),a0
	moveq	#0,d2
	move.b	(a0,d6.w),d2
	beq.s	.extended
	subq.w	#2,d2
	bcc.s	.jv1080

.normal
	bra	.setprog

.extended
	moveq	#-$50,d1	; $b0
	or.b	d6,d1
	move.b	d1,(a4)+
	move.b	#$20,(a4)+	; BANK parameter
	ror.w	#8,d0
	move.b	d0,(a4)+	; bank number
	bra	.setrotprog


.jv1080
	sub.w	#15,d2
	bcc.s	.boehm
	add.w	#15,d2

	moveq	#-$50,d1			; $b0
	or.b	d6,d1
	move.b	d1,(a4)+
	clr.b	(a4)+				; controller 0
	lea	jv1080_bank_table(pc),a0
	IFEQ	mc68020
	add.w	d2,d2
	move.b	(a0,d2.w),(a4)+
	ELSE
	move.b	(a0,d2.w*2),(a4)+		; bank number, msb
	ENDC
	move.b	d1,(a4)+
	move.b	#$20,(a4)+			; BANK controller
	IFEQ	mc68020
	move.b	1(a0,d2.w),(a4)+
	ELSE
	move.b	1(a0,d2.w*2),(a4)+		; bank number, lsb
	ENDC
	bra	.setprog


.boehm
	subq.w	#3,d2
	bcc.s	.mc303

	moveq	#-$50,d1	; $b0
	or.b	d6,d1
	move.b	d1,(a4)+
	add.b	#$42+3,d2
	move.b	d2,(a4)+
	clr.b	(a4)+
	bra.s	.setprog


.mc303
	subq.w	#1,d2
	bcc.s	.yamahaxg

	move.w	d0,d1
	lsr.w	#8,d1
	move.l	mc303_banksD(a5),a0
	IFEQ	mc68020
	add.w	d1,d1
	lea	-2(a0,d1.w),a0
	ELSE
	lea	-2(a0,d1.w*2),a0
	ENDC
	adda.w	(a0),a0
	ext.w	d0
	IFEQ	mc68020
	add.w	d0,d0
	move.w	-2(a0,d0.w),d0
	ELSE
	move.w	-2(a0,d0.w*2),d0
	ENDC

	bsr.s	.setrotprog

	moveq	#-$50,d1	; $b0
	or.b	d6,d1
	move.b	d1,(a4)+
	clr.b	(a4)+		; put variation tone
	ror.w	#8,d0
	move.b	d0,(a4)+
	move.b	#32,(a4)+	; required for the mc303
	clr.b	(a4)+
.rts	rts



.yamahaxg
	subq.w	#1,d2
	bcc.s	.quasar

	moveq	#-$50,d1	; $b0
	or.b	d6,d1
	move.b	d1,(a4)+
	ror.w	#8,d0
	cmp.b	#$7f,d0
	beq.s	.dkit
	moveq	#$20,d1
	bra.s	.setyam
.dkit	moveq	#0,d1
.setyam	move.b	d1,(a4)+
	move.b	d0,(a4)+

.setrotprog
	ror.w	#8,d0
.setprog
	moveq	#-$40,d1	; d1.b=$c0
	or.b	d6,d1
	move.b	d1,(a4)+
	move.b	d0,(a4)+
	rts


.quasar
	subq.w	#1,d2
	bcc.s	.cs1x

	moveq	#-$50,d1	; $b0
	or.b	d6,d1
	move.b	d1,(a4)+
	clr.b	(a4)+		; controller 0
	move.w	d0,d1
	lsr.w	#8,d1
	add.b	#65-1,d1
	move.b	d1,(a4)+
	bra.s	.setprog

.cs1x
	cmp.w	#16*$100,d0
	bcc.s	.rts
	moveq	#-$50,d1	; $b0
	or.b	d6,d1
	move.b	d1,(a4)+
	clr.b	(a4)+		; bank MSB
	move.b	#63,(a4)+
	move.b	d1,(a4)+
	move.b	#32,(a4)+	; bank LSB
	move.w	d0,d1
	lsr.w	#8,d1
	move.b	cs1x_bank_table-1(pc,d1.w),(a4)+
	bra.s	.setprog



cs1x_bank_table
	dc.b	64,65,0,1,2,3,4,5,6,7,8,9,10,11,12
	even




jv1080_bank_table
	dc.b	80,0
	dc.b	81,0
	dc.b	81,1
	dc.b	81,2
	dc.b	81,3
	dc.b	82,0
	dc.b	83,0
	dc.b	84,0
	dc.b	84,1
	dc.b	84,2
	dc.b	84,3
	dc.b	84,4
	dc.b	84,5
	dc.b	84,6
	dc.b	84,7





progchange_pchg_check	; d1.w = channel (1-16),
			; d2.b = progchange-value
			; returns: pos: d1.w is new progchange
			;               or d1.w=-1 if pchg is not yet complete
			;          neg: bank doesn't belong to pchg

	lea	complete_progchanges(a5),a1
	IFEQ	mc68020
	move.w	d1,d0
	lsl.w	#2,d0
	lea	-4(a1,d0.w),a1
	ELSE
	lea	-4(a1,d1.w*4),a1
	ENDC
	move.b	d2,1(a1)
	lea	pchg_togo(a5),a0
	lea	-1(a0,d1.w),a0
;	bra.s	progchange_subcalc



progchange_subcalc
	subq.b	#1,(a0)
	bne.s	.npos
	move.w	(a1),d0
	lea	pchgtypes(a5),a1
	move.b	-1(a1,d1.w),d1
	move.b	pchg_togo_inits(pc,d1.w),(a0)
	move.w	d0,d1
	POSITIV
.npos	moveq	#-1,d1
	POSITIV





pchg_togo_inits	dc.b	2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3
		dc.b	2,2,2,2,3
		even



progchange_bank_check	; d1.w = channel (1-16),
			; d2.b = controlsource, d3.b = value
			; returns: pos: d1.w is new progchange
			;               or d1.w=-1 if pchg is not yet complete
			;          neg: bank doesn't belong to pchg


	lea	complete_progchanges(a5),a1
	IFEQ	mc68020
	move.w	d1,d0
	lsl.w	#2,d0
	lea	-4(a1,d0.w),a1
	ELSE
	lea	-4(a1,d1.w*4),a1
	ENDC
	lea	pchgtypes(a5),a0
	moveq	#0,d0
	move.b	-1(a0,d1.w),d0
	lea	pchg_togo(a5),a0
	lea	-1(a0,d1.w),a0
	beq.s	.extended
	subq.w	#2,d0
	bcc.s	.jv1080

.normal
.neg	NEGATIV

.extended
	cmp.b	#$20,d2
	bne.s	.neg
	move.b	d3,(a1)
	bra.s	progchange_subcalc



.jv1080
	sub.w	#15,d0
	bcc.s	.boehm

	tst.b	d2		; bank number, msb
	beq.s	.bankm
	cmp.b	#$20,d2
	bne.s	.neg
	move.b	d3,3(a1)
	bra.s	.subjv
.bankm	move.b	d3,2(a1)
.subjv
	cmp.b	#1,(a0)
	bne	progchange_subcalc

	move.l	d1,-(sp)
	lea	jv1080_bank_table(pc),a0
	moveq	#0,d0
.jvloop	move.b	(a0,d0.w),d1
	cmp.b	2(a1),d1
	bne.s	.isnt
	move.b	1(a0,d0.w),d1
	cmp.b	3(a1),d1
	beq.s	.jvout
.isnt	addq.w	#2,d0
	cmp.w	#30,d0
	bcs.s	.jvloop
	moveq	#0,d0		; default

.jvout	lsr.b	#1,d0
	move.b	d0,(a1)
	move.l	(sp)+,d1
	bra	progchange_subcalc




.boehm
	subq.w	#3,d0
	bcc.s	.mc303

	move.b	d2,d0
	sub.b	#$42,d0
	bcs.s	.neg
	cmp.b	#3,d0
	bcc.s	.neg
	move.b	d0,(a1)
	bra	progchange_subcalc


.mc303
	subq.w	#1,d0
	bcc.s	.yamahaxg

	tst.b	d2
	bne	.neg
	move.b	d3,(a1)
	bra	progchange_subcalc



.yamahaxg
	subq.w	#1,d0
	bcc.s	.quasar

	tst.b	d2
	beq.s	.yam0
	cmp.b	#$20,d2
	bne	.neg
.yam0	move.b	d3,(a1)
	bra	progchange_subcalc



.quasar
	subq.w	#1,d0
	bcc.s	.cs1x

	tst.b	d2
	bne	.neg
	move.b	d3,d0
	sub.b	#65-1,d0
	move.b	d0,(a1)
	bra	progchange_subcalc



.cs1x
	tst.b	d2
	beq.s	.cs1x_msb
	cmp.b	#$20,d2
	bne	.neg
	lea	cs1x_bank_table(pc),a0
	moveq	#13,d0
.cs1xloop
	cmp.b	(a0,d0.w),d3
	dbeq	d0,.cs1xloop
	bne	.neg
	addq.b	#1,d0
	move.b	d0,(a1)
	bra	progchange_subcalc
.cs1x_msb
	cmp.b	#63,d3
	bne	.neg
	bra	progchange_subcalc







;=== 0. Position BPMtrack
bpmtrackpos0
	beq	delbpmtrack
	cmp.b	#9,d3
	bhi.s	.rts
	mulu	#10000,d3
	moveq	#0,d0
	move.w	(a0),d0
	divu	#10000,d0
	swap	d0		; d0 = 0thze
	add.w	d3,d0		; d0 = zthze
	bra	bpm_do
.rts	rts

;=== 1. Position BPMtrack
bpmtrackpos1
	beq	delbpmtrack
	cmp.b	#9,d3
	bhi.s	.rts
	mulu	#1000,d3
	moveq	#0,d0
	move.w	(a0),d0
	divu	#1000,d0
	move.l	d0,d2		; d0 = 000zt
	swap	d2		; d2 = 00hze
	ext.l	d0
	divu	#10,d0
	ext.l	d0		; d0 = 0000z
	mulu	#10000,d0	; d0 = z0000
	add.w	d2,d0		; d0 = z0hze
	add.w	d3,d0		; d0 = zthze
	bra.s	bpm_do
.rts	rts

;=== 2. Position BPMtrack
bpmtrackpos2
	beq.s	delbpmtrack
	cmp.b	#9,d3
	bhi.s	.rts
	mulu	#100,d3
	moveq	#0,d0
	move.w	(a0),d0
	divu	#100,d0
	move.l	d0,d2		; d0 = 00zth
	swap	d2		; d2 = 000ze
	ext.l	d0
	divu	#10,d0
	ext.l	d0		; d0 = 000zt
	mulu	#1000,d0	; d0 = zt000
	add.w	d2,d0		; d0 = zt0ze
	add.w	d3,d0		; d0 = zthze
	bra.s	bpm_do
.rts	rts

;=== 3. Position BPMtrack
bpmtrackpos3
	beq.s	delbpmtrack
	cmp.b	#9,d3
	bhi.s	.rts
	mulu	#10,d3		; d3 = 000z0
	moveq	#0,d0
	move.w	(a0),d0
	divu	#10,d0
	move.l	d0,d2		; d0 = 0zthz
	swap	d2		; d2 = 0000e
	ext.l	d0
	divu	#10,d0
	ext.l	d0		; d0 = 00zth
	mulu	#100,d0		; d0 = zth00
	add.w	d2,d0		; d0 = zth0e
	add.w	d3,d0		; d0 = zthze
	bra.s	bpm_do
.rts	rts

bpm_do	cmp.w	#min_bpm,d0
	bmi.s	.rts
	cmp.w	#max_bpm,d0
	bhi.s	.rts
	move.w	d0,(a0)
	bra.s	down_bpmtrack
.rts	rts

delbpmtrack
	move.w	#BPM_stay,(a0)
	bsr	checkfree_track_and_channel
down_bpmtrack
	jsr	calc_total_timeJ(a5)
;	st	bpmtrackchanged(a5)
	st	songchanged(a5)
	bra	quant_crsr_down

;=== 4. Position BPMtrack
bpmtrackpos4
	beq.s	delbpmtrack
	cmp.b	#9,d3
	bhi.s	.rts
	moveq	#0,d0
	move.w	(a0),d0
	divu	#10,d0	; d0 = Hunderterstelle + Zehnerstelle
	ext.l	d0
	mulu	#10,d0
	add.w	d3,d0
	bra.s	bpm_do
.rts	rts




	IFEQ	1

;=== 0. Position Mono Pressure
mptrackpos0
	beq.s	delmppos0
	cmp.b	#8,d3
	bpl.s	.rts
	lsl.b	#4,d3
	and.b	#$0f,(a0)
	or.b	d3,(a0)
	bra.s	down_mptrack
.rts	rts

delmppos0
	move.b	#cs_stay,(a0)
down_mptrack
	st	mptrackchanged(a5)
	bra	quant_crsr_down

;=== 1. Position
mptrackpos1
	beq.s	delmppos0
	and.b	#$70,(a0)
	or.b	d3,(a0)
	bra.s	down_mptrack

	ENDC




;=== 0. Position Pitchbend
pbtrackpos0
	beq.s	delpbpos0
	cmp.b	#4,d3
	bpl.s	.rts
	lsl.b	#4,d3
	and.b	#$0f,(a0)
	or.b	d3,(a0)
	bra.s	down_pbtrack
.rts	rts

delpbpos0
	move.w	#PB_stay,(a0)
	bsr	checkfree_track_and_channel
down_pbtrack
;	st	pbtrackchanged(a5)
	st	songchanged(a5)
	bra	quant_crsr_down

;=== 1. Position
pbtrackpos1
	beq.s	delpbpos0
	and.b	#$30,(a0)
	or.b	d3,(a0)
	bra.s	down_pbtrack

;=== 2. Position
pbtrackpos2
	beq.s	delpbpos0
	lsl.b	#4,d3
	and.w	#$3f0f,(a0)
	or.w	d3,(a0)
	bra.s	down_pbtrack

;=== 3. Position
pbtrackpos3
	beq.s	delpbpos0
	and.w	#$3ff0,(a0)
	or.w	d3,(a0)
	bra.s	down_pbtrack




;=== 0. Position Controlsource Tracks
ctrackpos0
	beq.s	delcpos0
	cmp.b	#8,d3
	bpl.s	.rts
	lsl.b	#4,d3
	and.b	#$0f,(a0)
	or.b	d3,(a0)
	bra.s	down_ctrack
.rts	rts

delcpos0
	move.b	#cs_stay,(a0)
	bsr	checkfree_track_and_channel
down_ctrack
	st	songchanged(a5)
;	move.w	pgfx_active(a5),d0
;	move.l	ctrackchanged(a5),a0
;	st	-2(a0,d0.w)
	bra	quant_crsr_down

;=== 1. Position
ctrackpos1
	beq.s	delcpos0
	and.b	#$70,(a0)
	or.b	d3,(a0)
	bra.s	down_ctrack






key_2
	moveq	#2,d3
	moveq	#14,d4
	bra	editentry


key_3
	moveq	#3,d3
	moveq	#16,d4
	bra	editentry

key_4
	moveq	#4,d3
	moveq	#-1,d4
	bra	editentry

key_5
	moveq	#5,d3
	moveq	#19,d4
	bra	editentry

key_6
	moveq	#6,d3
	moveq	#21,d4
	bra	editentry

key_7
	moveq	#7,d3
	moveq	#23,d4
	bra	editentry

key_8
	moveq	#8,d3
	moveq	#-1,d4
	bra	editentry

key_9
	moveq	#9,d3
	moveq	#26,d4
	bra	editentry

key_0
	moveq	#0,d3
	moveq	#28,d4
	bra	editentry

key_sz
	rts

key_bwsinglequote	; means Note-OFF
	moveq	#-1,d3			; d3=-1 means, this is not a digit
	moveq	#34,d4			; 34 is NOTE-OFF code
	bra	editentry

key_apostroph
	moveq	#-1,d3
	moveq	#31,d4
	bra	editentry

key_backslash
	moveq	#-1,d3
	moveq	#33,d4
	bra	editentry

key_q
	moveq	#-1,d3
	moveq	#13,d4
	bra	editentry

key_w
	moveq	#-1,d3
	moveq	#15,d4
	bra	editentry

key_e
	moveq	#$e,d3
	moveq	#17,d4
	bra	editentry

key_r
	moveq	#-1,d3
	moveq	#18,d4
	bra	editentry

key_t
	moveq	#-1,d3
	moveq	#20,d4
	bra	editentry

key_z
	moveq	#-1,d3
	moveq	#22,d4
	bra	editentry

key_u
	moveq	#-1,d3
	moveq	#24,d4
	bra	editentry

key_i
	tst.b	altpressed(a5)
	beq.s	.noalt
	not.b	ignorenoffs(a5)
	jmp	freshen_noffsJ(a5)
.noalt
keyup_i	moveq	#-1,d3
	moveq	#25,d4
	bra	editentry

key_o
	moveq	#-1,d3
	moveq	#27,d4
	bra	editentry

key_p
	moveq	#-1,d3
	moveq	#29,d4
	bra	editentry

key_ue
	moveq	#-1,d3
	moveq	#30,d4
	bra	editentry

key_plus
	moveq	#-1,d3
	moveq	#32,d4
	bra	editentry

key_a
	moveq	#$a,d3
	moveq	#-1,d4
	bra	editentry

key_s
	tst.b	altpressed(a5)
	beq.s	.noalt
	not.b	sequencer_sysex(a5)
	jmp	freshen_seqsysexJ(a5)
.noalt
keyup_s	moveq	#-1,d3
	moveq	#2,d4
	bra	editentry

key_d
	tst.b	altpressed(a5)
	beq.s	.noalt
	not.b	playdisabled(a5)
	jmp	freshen_playdisJ(a5)
.noalt
keyup_d	moveq	#$d,d3
	moveq	#4,d4
	bra	editentry

key_f
	moveq	#$f,d3
	moveq	#-1,d4
	bra	editentry

key_g
	moveq	#-1,d3
	moveq	#7,d4
	bra	editentry

key_h
	tst.b	altpressed(a5)
	beq.s	.noalt
	not.b	haltpatt(a5)
	jmp	freshen_haltpattJ(a5)
.noalt
keyup_h	moveq	#-1,d3
	moveq	#9,d4
	bra	editentry

key_j
	moveq	#-1,d3
	moveq	#11,d4
	bra	editentry


key_k
	tst.b	altpressed(a5)
	beq.s	.noalt
	not.b	actions_enable(a5)
	jmp	freshen_kactJ(a5)
.noalt
keyup_k	rts


key_l
	moveq	#-1,d3
	moveq	#14,d4
	bra	editentry


key_oe
	moveq	#-1,d3
	moveq	#16,d4
	bra	editentry


key_ae
	rts


key_fis
	rts


key_kleiner
	rts


key_y
	moveq	#-1,d3
	moveq	#1,d4
	bra	editentry


key_x
	moveq	#-1,d3
	moveq	#3,d4
	bra	editentry


key_c
	moveq	#$c,d3
	moveq	#5,d4
	bra	editentry


key_v
	moveq	#-1,d3
	moveq	#6,d4
	bra	editentry



key_b
	moveq	#$b,d3
	moveq	#8,d4
	bra	editentry



key_n
	moveq	#-1,d3
	moveq	#10,d4
	bra	editentry



key_m
	tst.b	altpressed(a5)
	beq.s	.noalt
	not.b	send_mtc(a5)
	jmp	freshen_mtcJ(a5)
.noalt
keyup_m	moveq	#-1,d3
	moveq	#12,d4
	bra	editentry


key_komma
	moveq	#-1,d3
	moveq	#13,d4
	bra	editentry


key_punkt
	moveq	#-1,d3
	moveq	#15,d4
	bra	editentry


key_minus
	moveq	#-1,d3
	moveq	#17,d4
	bra	editentry



key_backspace
	tst.b	playflag(a5)
	bne	.rts

	tst.l	eventpos(a5)
	beq	.rts

	tst.b	shiftpressed(a5)
	bne.s	.channel
;	tst.b	altpressed(a5)
;	bne	.pattern
	tst.b	editmode(a5)
	beq	edit_noeditmode

;	tst.b	shiftpressed(a5)
;	bne.s	.cut_and_stay_track

;	jsr	check_state_beforeJ(a5)

	moveq	#0,d0
	bra.s	.go
.channel
	moveq	#1,d0
.go
	lea	.bs_jumptable(pc),a2
	bsr	bs_track_routine

	jsr	GetChannelResolutionJ(a5)
	sub.l	d0,eventpos(a5)

	bsr	checkfree_track_and_channel
	jsr	check_state_afterJ(a5)
	jmp	RedrawPatternJ(a5)


.bs_jumptable
	bra	.back_1b
	bra	.back_2b
	bra	.back_4b


.back_1b
	jsr	GetChannelResolutionJ(a5)
	move.l	d0,d2
	move.l	eventpos(a5),d3		; d0-d3 are parameters for later
	move.l	events(a5),d1

	sub.l	d3,d1

	sub.l	d2,d3
	adda.l	d3,a1
	lea	(a1,d2.l),a0

	tst.l	d1
	beq.s	.restMP
.copyMP	move.b	(a0)+,(a1)+
	subq.l	#1,d1
	bne.s	.copyMP

.restMP	move.b	d4,(a1)+
	subq.l	#1,d2
	bne.s	.restMP

.okay	st	songchanged(a5)
.rts	rts


.back_2b
	jsr	GetChannelResolutionJ(a5)
	move.l	d0,d2
	move.l	eventpos(a5),d3		; d0-d3 are parameters for later
	move.l	events(a5),d1

	sub.l	d3,d1
	sub.l	d2,d3

	IFEQ	mc68020
	add.l	d3,d3
	adda.l	d3,a1
	move.l	d2,d3
	add.l	d3,d3
	lea	(a1,d3.l),a0
	ELSE
	lea	(a1,d3.l*2),a1
	lea	(a1,d2.l*2),a0
	ENDC

	tst.l	d1
	beq.s	.restloop2
.copyloop2
	move.w	(a0)+,(a1)+
	subq.l	#1,d1
	bne.s	.copyloop2

.restloop2
	move.w	d4,(a1)+
	subq.l	#1,d2
	bne.s	.restloop2

	bra.s	.okay



.back_4b
	jsr	GetChannelResolutionJ(a5)
	move.l	d0,d2
	move.l	eventpos(a5),d3		; d0-d3 are parameters for later
	move.l	events(a5),d1

	sub.l	d3,d1		; d1 = events - eventpos
	sub.l	d2,d3		; d3 = eventpos - pattscale

	IFEQ	mc68020
	lsl.l	#2,d3		; =mulu #wd_sizeof,d3
	adda.l	d3,a1
	move.l	d2,d3
	lsl.l	#2,d3		; =mulu #wd_sizeof,d3
	lea	(a1,d3.l),a0	; a0=source
	ELSE
	lea	(a1,d3.l*4),a1
	lea	(a1,d2.l*4),a0
	ENDC

	tst.l	d1
	beq.s	.nocop
.copyloop4
	move.l	(a0)+,(a1)+
	subq.l	#1,d1
	bne.s	.copyloop4

.nocop	move.l	#track_def_entry,d0
.restloop4
	move.l	d0,(a1)+
	subq.l	#1,d2
	bne.s	.restloop4

	bra.s	.okay





bs_track_routine	; d0 = 0 (track) or 1 (channel), a2 = ^jumptable

		rsreset
.jmp_1b		rs.l	1
.jmp_2b		rs.l	1
.jmp_4b		rs.l	1


	movem.l	d0/a2,-(sp)
	jsr	check_state_beforeJ(a5)
	movem.l	(sp)+,d0/a2

	tst.l	d0
	bne	.channel

	move.l	currenttrack(a5),d0
	bpl.s	.bs_track
	addq.l	#1,d0
	beq.s	.csource
	addq.l	#1,d0
	beq.s	.bs_presettrack

	bra.s	.bs_bpmtrack

.csource
	move.w	pgfx_active(a5),d0
	beq.s	.PB
	subq.w	#1,d0
	bra.s	.bs_csource
.PB
	bra.s	.bs_pbtrack




;=== BPM-worktrack
.bs_bpmtrack
	jsr	GetBPMTrackJ(a5)
	beq.s	.rts
	move.l	a0,a1
	moveq	#BPM_stay,d4
	jmp	.jmp_2b(a2)

;=== Presettrack
.bs_presettrack
	jsr	GetPresetTrackJ(a5)
	beq.s	.rts
	move.l	a0,a1
	move.w	#Preset_stay,d4
	jmp	.jmp_2b(a2)



;=== Controlsource-worktrack
.bs_csource

;	beq.s	.MP

;=== CS-track
;	move.l	ctrackchanged(a5),a0
;	subq.w	#1,d0
;	st	(a0,d0.w)
;	move.l	d1,-(sp)
;	jsr	GetCSTrackJ(a5)
;	move.l	a0,a1

	jsr	GetCSourceTrackDataJ(a5)
	beq.s	.rts
	move.l	a0,a1

;	move.l	(sp)+,d1
	move.b	#CS_stay,d4
	jmp	.jmp_1b(a2)

.rts	rts

;=== Pitchbender
.bs_pbtrack
;	st	pbtrackchanged(a5)
	jsr	GetPibeTrackJ(a5)
	beq.s	.rts
	move.l	a0,a1
	move.w	#PB_stay,d4
	jmp	.jmp_2b(a2)


;=== Mono Press
;.MP	st	mptrackchanged(a5)
;	move.l	mpworktrack(a5),a1
;	move.b	#CS_stay,d0
;	jmp	(a2)


;=== normaler worktrack (d0=currenttrack)
.bs_track
	jsr	GetTrackDataJ(a5)
	beq.s	.rts
	move.l	a0,a1

;	move.l	trackchanged(a5),a0
;	st	(a0,d0.w)
;	jsr	GetWTrackJ(a5)
;	move.l	a0,a1
;	move.l	#track_def_entry,d0
	jmp	.jmp_4b(a2)






.channel
;	tst.b	shiftpressed(a5)
;	bne.s	.cut_and_stay_channel

;	lea	.bs_track(pc),a3

;bs_channel	; a3=Trackroutine

	bsr	.bs_presettrack


;=== note-tracks
	move.l	maxtracks_m1(a5),d7
.trkloop
	move.l	d7,d0
	bsr	.bs_track
	dbf	d7,.trkloop

;=== csource-tracks
;	move.w	pgfx_active(a5),-(sp)

	bsr	.bs_pbtrack

	move.l	active_csources_m1(a5),d7
.csloop
	move.l	d7,d0
	bsr	.bs_csource
	dbf	d7,.csloop

;	move.w	(sp)+,pgfx_active(a5)

	rts



;.cut_and_stay_channel
;	move.l	pattscale(a5),d0
;	add.l	d0,eventpos(a5)
;
;	lea	.bs_track(pc),a3
;	bsr.s	bs_channel
;	bra	.cont





;.pattern
;	jsr	MainBusyPointerJ(a5)

;	tst.b	shiftpressed(a5)
;	bne.s	.cut_and_stay_pattern

;	tst.l	eventpos(a5)
;	beq.s	.rts
;	lea	.bs_track(pc),a3
;	bsr.s	bs_pattern
;	bsr	.cont
;	bra.s	.further

;.cut_and_stay_pattern
;	move.l	pattscale(a5),d0
;	add.l	d0,eventpos(a5)
;
;	lea	.bs_track(pc),a3
;	bsr.s	bs_pattern
;	bsr	.cont

;.further
;	jmp	MainActivePointerJ(a5)







	IFEQ	1

bs_pattern	; a3=Trackroutine
	move.w	currentchannel(a5),-(sp)
	move.l	a3,-(sp)
	jsr	PackChannelJ(a5)
	move.w	#16,currentchannel(a5)
.pattloop
	jsr	CorrectChannelJ(a5)
	jsr	DepackChannelJ(a5)
	move.l	(sp),a3
	bsr.s	bs_channel
	jsr	PackChannelJ(a5)

	subq.w	#1,currentchannel(a5)
	bne.s	.pattloop

;=== BPM track still to do
	jsr	DepackChannelJ(a5)
	moveq	#-3,d0
	move.l	(sp)+,a3
	jsr	(a3)
	jsr	PackChannelJ(a5)


	move.w	(sp)+,currentchannel(a5)
	jsr	CorrectChannelJ(a5)
	jmp	DepackChannelJ(a5)

	ENDC




key_return
	tst.b	playflag(a5)
	bne	.rts

;	tst.b	altpressed(a5)
;	bne	.pattern

;	jsr	check_state_beforeJ(a5)

	tst.b	shiftpressed(a5)
	bne.s	.chan

	tst.b	editmode(a5)
	beq	edit_noeditmode

	moveq	#0,d0
	bra.s	.go
.chan	moveq	#1,d0
.go
	lea	.ret_jumptable(pc),a2
	bsr	bs_track_routine

	jsr	GetChannelResolutionJ(a5)
	move.l	eventpos(a5),d1
	add.l	d0,d1
	cmp.l	events(a5),d1
	bcc.s	.nonewpos
	move.l	d1,eventpos(a5)
.nonewpos

	bsr	checkfree_track_and_channel
	jsr	check_state_afterJ(a5)
	jmp	RedrawPatternJ(a5)


.ret_jumptable
	bra	.return_1b
	bra	.return_2b
	bra	.return_4b




.return_2b	; a0=^worktrack, d4=stay
	jsr	GetChannelResolutionJ(a5)
	move.l	d0,d2
	move.l	eventpos(a5),d3
	move.l	events(a5),d1

	move.l	d1,d0
	sub.l	d2,d0
	IFEQ	mc68020
	add.l	d0,d0
	lea	(a1,d0.l),a0
	move.l	d1,d0
	add.l	d0,d0
	lea	(a1,d0.l),a1
	ELSE
	lea	(a1,d0.l*2),a0
	lea	(a1,d1.l*2),a1
	ENDC

	sub.l	d3,d1
	sub.l	d2,d1
	beq.s	.restloop2

.copyloop2
	move.w	-(a0),-(a1)
	subq.l	#1,d1
	bne.s	.copyloop2

.restloop2
	move.w	d4,-(a1)
	subq.l	#1,d2
	bne.s	.restloop2

.okay	st	songchanged(a5)
.rts	rts





.return_1b
	jsr	GetChannelResolutionJ(a5)
	move.l	d0,d2
	move.l	eventpos(a5),d3
	move.l	events(a5),d1

	move.l	d1,d0
	sub.l	d2,d0
	lea	(a1,d0.l),a0
	lea	(a1,d1.l),a1

	sub.l	d3,d1
	sub.l	d2,d1
	beq.s	.restMP

.copyMP	move.b	-(a0),-(a1)
	subq.l	#1,d1
	bne.s	.copyMP

.restMP	move.b	d4,-(a1)
	subq.l	#1,d2
	bne.s	.restMP

	bra.s	.okay



.return_4b
	jsr	GetChannelResolutionJ(a5)
	move.l	d0,d2
	move.l	eventpos(a5),d3
	move.l	events(a5),d1

;	move.l	trackchanged(a5),a0
;	st	(a0,d0.w)

	move.l	d1,d0
	sub.l	d2,d0
	IFEQ	mc68020
	lsl.l	#2,d0
	lea	(a1,d0.l),a0
	move.l	d1,d0
	lsl.l	#2,d0
	lea	(a1,d0.l),a1
	ELSE
	lea	(a1,d0.l*4),a0
	lea	(a1,d1.l*4),a1
	ENDC

	sub.l	d3,d1
	sub.l	d2,d1
	beq.s	.nocop3
.copyloop3
	move.l	-(a0),-(a1)
	subq.l	#1,d1
	bne.s	.copyloop3
.nocop3	move.l	#track_def_entry,d0
.restloop3
	move.l	d0,-(a1)
	subq.l	#1,d2
	bne.s	.restloop3

	bra	.okay





key_tab
	tst.b	editmode(a5)
	beq.s	.rts

	tst.l	active_channelwindow(a5)
	bmi.s	.rts

	tst.b	shiftpressed(a5)
	beq.s	.without_shift

;=== einen Track nach links
	jsr	clear_cursorJ(a5)
	move.l	currenttrack(a5),d0
	addq.l	#3,d0
	beq.s	.under
	subq.l	#4,d0
.poing	tst.l	d0
	bmi.s	.pos_0
	tst.b	tabmode(a5)
	beq.s	.pos_0
	move.w	#2,cursorpos(a5)
	bra.s	.skipp0
.pos_0	clr.w	cursorpos(a5)
.skipp0	move.l	d0,currenttrack(a5)
	jmp	RefreshTracksJ(a5)
;	jmp	set_cursorJ(a5)
.under	move.l	maxtracks_m1(a5),d0
	bra.s	.poing
.rts	rts


;=== einen Track nach rechts
.without_shift
	jsr	clear_cursorJ(a5)
	move.l	currenttrack(a5),d0
	addq.l	#1,d0
	cmp.l	maxtracks(a5),d0
	bmi.s	.inrange
	moveq	#-3,d0			; skip to bpmtrack
.inrange
	bra.s	.poing




key_delete
	tst.b	shiftpressed(a5)
	bne.s	.entire_event
	tst.b	altpressed(a5)
	bne.s	.entire_line
.no_notetrack
	moveq	#0,d3			; d3 is somehow irrelevant
	moveq	#0,d4			; d4=0 means, delete that entry
	bra	editentry

;=== delete full event on a track (velocity + note + polypressure)

.entire_event
	tst.b	editmode(a5)
	beq.s	.dont
	tst.b	playflag(a5)
	bne.s	.dont

	move.l	currenttrack(a5),d0
	bmi.s	.no_notetrack

	jsr	GetTrackDataJ(a5)
	beq.s	.dont

	move.l	eventpos(a5),d0
	IFEQ	mc68020
	lsl.l	#2,d0
	move.l	#track_def_entry,(a0,d0.l)
	ELSE
	move.l	#track_def_entry,(a0,d0.l*4)
	ENDC
	bra	down_track

.dont	rts


;=== delete full event on all note-tracks

.entire_line
	tst.b	editmode(a5)
	beq.s	.dont
	tst.b	playflag(a5)
	bne.s	.dont

;	move.l	trackchanged(a5),a2
	moveq	#0,d2
	move.l	#track_def_entry,d3
.trackloop
;	st	(a2,d2.l)
	move.l	d2,d0
	jsr	GetTrackDataJ(a5)
	beq.s	.next
	move.l	eventpos(a5),d0
	IFEQ	mc68020
	lsl.l	#2,d0
	move.l	d3,(a0,d0.l)
	ELSE
	move.l	d3,(a0,d0.l*4)
	ENDC
.next	addq.l	#1,d2
	cmp.l	maxtracks(a5),d2
	bcs.s	.trackloop
	bra	quant_crsr_down





;=== bring amigaguide documentation to the front, according to the active window

key_help

	bsr	find_window_struct
	beq.s	.not

	move.l	wd_AGlink(a1),a0
	bra	show_amigaguide

.not	rts





;==============================================================
;
;  Cursor Up
;
;==============================================================

key_crsr_up
	tst.b	altpressed(a5)
	bne.s	.pos_up

	tst.b	ctrlpressed(a5)
	bne	csource_up

	tst.l	active_channelwindow(a5)
	bmi.s	.rts

	tst.b	playflag(a5)
	bne.s	.rts

	jsr	GetChannelResolutionJ(a5)

	tst.b	shiftpressed(a5)
	bne.s	.page_up

	sub.l	d0,eventpos(a5)
	bpl.s	.good
	move.l	events(a5),d1
	sub.l	d0,d1
	move.l	d1,eventpos(a5)
.good	bra	key_after

.page_up
	move.l	lines_in_td_half(a5),d1
	add.l	d1,d1
	mulu	d0,d1
	sub.l	d1,eventpos(a5)
	bcc.s	.good
	clr.l	eventpos(a5)
	bra.s	.good

.rts	rts

.pos_up
	move.b	playflag(a5),d3
	cmp.b	#2,d3
	beq.s	.rts

	move.l	currentpos(a5),d0
	beq.s	.rts

	tst.b	shiftpressed(a5)
	beq.s	.one_up
	tst.b	ctrlpressed(a5)
	bne.s	.top
	moveq	#4,d1
	bra.s	.up
.one_up	moveq	#1,d1
.up	sub.l	d1,d0
	bcc.s	.ok
.top	moveq	#0,d0
.ok
	bra	set_position





;=== Controlsource im pgfx-window eins nach oben
csource_up
	move.w	pgfx_active(a5),d0
	subq.w	#1,d0
	bcc.s	cscont
	move.l	active_csources_m1(a5),d0
	addq.l	#1,d0
cscont	move.w	d0,pgfx_active(a5)
	tst.l	MTpgfxStruct+wd_Wnd(a5)
	beq.s	.cs_closed
	ext.l	d0
	moveq	#GD_csource,d1
	jsr	SetLVActivePgfxJ(a5)
.cs_closed
	jmp	csource_refreshJ(a5)




key_after
	jsr	pgfx_running_lineJ(a5)
	bsr	RefreshBlock
	jmp	RedrawAllTrackdisplaysJ(a5)






;==============================================================
;
;  Cursor Down
;
;==============================================================

key_crsr_down

	tst.b	altpressed(a5)
	bne.s	.pos_down

	tst.b	ctrlpressed(a5)
	bne	.csource_down

	tst.l	active_channelwindow(a5)
	bmi.s	.rts

	tst.b	playflag(a5)
	bne.s	.rts

	jsr	GetChannelResolutionJ(a5)

	tst.b	shiftpressed(a5)
	bne.s	.page_down

	add.l	d0,eventpos(a5)
	move.l	eventpos(a5),d1
	cmp.l	events(a5),d1
	bcs.s	.good
	clr.l	eventpos(a5)
.good	bra	key_after


.page_down
	move.l	lines_in_td_half(a5),d1
	add.l	d1,d1
	mulu	d0,d1
	add.l	d1,eventpos(a5)
	jsr	check_eventposJ(a5)
	bra.s	.good

.rts	rts

.pos_down
	move.b	playflag(a5),d3
	cmp.b	#2,d3
	beq.s	.rts

	move.l	currentpos(a5),d0
	move.l	length(a5),d2
	subq.l	#1,d2
	cmp.l	d2,d0
	beq.s	.rts
	tst.b	shiftpressed(a5)
	beq.s	.one_dn
	tst.b	ctrlpressed(a5)
	bne.s	.bottom
	moveq	#4,d1
	bra.s	.down
.one_dn	moveq	#1,d1
.down	add.l	d1,d0
	cmp.l	d0,d2
	bhi.s	.ok
.bottom	move.l	d2,d0
.ok
	bra.s	set_position


;=== Controlsource im pgfx-window eins nach unten
.csource_down
	move.w	pgfx_active(a5),d0
	addq.w	#1,d0
	move.l	active_csources(a5),d1
	addq.l	#1,d1
	cmp.w	d1,d0
	bcs.s	.do
	moveq	#0,d0
.do	bra	cscont




set_position	; d0 = position, d3 = playflag
	cmp.b	#-2,d3
	bne.s	.go
	move.l	d0,positionjump(a5)
	move.b	#3,tapedeck(a5)
	rts

.go	move.l	d0,currentpos(a5)
	jsr	pos_setJ(a5)
	jmp	score_trackingJ(a5)





;==============================================================
;
;  Cursor Right
;
;==============================================================

key_crsr_right

	tst.b	altpressed(a5)
	bne	.patt_plus
	tst.b	ctrlpressed(a5)
	bne	pattscale_plus

	tst.l	active_channelwindow(a5)
	bmi.s	.rts

	tst.b	editmode(a5)
	beq	.kick_right

;=== editmode, eine stelle nach rechts
	jsr	clear_cursorJ(a5)
	move.l	currenttrack(a5),d1
	bpl.s	.ntrack
	addq.l	#1,d1
	beq.s	.ctrack
	addq.l	#1,d1
	beq.s	.ptrack

;=== im bpmtrack
	cmp.w	#4,cursorpos(a5)
	bne.s	.rechts
.nextt	clr.w	cursorpos(a5)
	addq.l	#1,currenttrack(a5)
	bra.s	.set

;=== im presettrack
.ptrack	cmp.w	#5,cursorpos(a5)
	bne.s	.rechts
	bra.s	.nextt

;=== im controltrack
.ctrack	move.w	pgfx_active(a5),d0
	bne.s	.noPB
	cmp.w	#3,cursorpos(a5)
	bne.s	.rechts
	bra.s	.next
.noPB	cmp.w	#1,cursorpos(a5)
	bne.s	.rechts
.next	clr.w	cursorpos(a5)
	bra.s	.oneup

.rts	rts

;=== im normalen track
.ntrack	cmp.w	#2,cursorpos(a5)
	bne.s	.rechts
;=== Cursor am rechten Rand eines normalen Tracks
	clr.w	cursorpos(a5)
	move.l	maxtracks_m1(a5),d0
	cmp.l	currenttrack(a5),d0
	beq.s	.mostright	;ganz rechts?
;=== einen Track weiter
.oneup	addq.l	#1,currenttrack(a5)
.goon	jmp	RefreshTracksJ(a5)
.set	jmp	set_cursorJ(a5)
.mostright
	moveq	#-3,d0
	move.l	d0,currenttrack(a5)	; -> bpmtrack
	bra.s	.set
.rechts	addq.w	#1,cursorpos(a5)
	bra.s	.set




.patt_plus
	tst.b	pattern_locked(a5)
	bne.s	.locked
	bra	patt_plus
.locked
	bra	pat_plus_down




;=== tracks um eins nach rechts shiften

.kick_right
	move.l	maxtracks(a5),d1
	sub.l	displayed_tracks(a5),d1
	bls.s	.rts
	move.l	displaytrack(a5),d0
	tst.b	shiftpressed(a5)
	bne.s	.fast

	addq.l	#1,d0
	cmp.l	d1,d0
	bhi.s	.rts
	bra.s	.shift

.fast	cmp.l	d1,d0
	beq.s	.rts
	add.l	displayed_tracks(a5),d0
	cmp.l	d1,d0
	bcs.s	.shift
	move.l	d1,d0
.shift	move.l	d0,displaytrack(a5)


fresh_leftright
	jsr	RefreshNumsJ(a5)
	jmp	RedrawPatternOhneScrJ(a5)





;==============================================================
;
;  Cursor Left
;
;==============================================================

key_crsr_left

	tst.b	altpressed(a5)
	bne	.patt_minus
	tst.b	ctrlpressed(a5)
	bne	pattscale_minus

	tst.l	active_channelwindow(a5)
	bmi.s	.rts

	tst.b	editmode(a5)
	beq.s	.kick_left


;=== editmode, eine stelle nach links
	jsr	clear_cursorJ(a5)
	tst.w	cursorpos(a5)
	bne.s	.links
;=== Cursor am linken Rand eines Tracks
	subq.l	#1,currenttrack(a5)
	bpl.s	.ntrack
	move.l	currenttrack(a5),d1
	addq.l	#1,d1
	beq.s	.ctrack
	addq.l	#1,d1
	beq.s	.ptrack
	addq.l	#1,d1
	bne.s	.mostleft
;=== in den bpmtrack springen
	move.w	#4,cursorpos(a5)
	bra.s	.set
;=== in den Controltrack springen
.ctrack	move.w	pgfx_active(a5),d0
	bne.s	.noPB
	move.w	#3,cursorpos(a5)
	bra.s	.set
.noPB	move.w	#1,cursorpos(a5)
	bra.s	.set
;=== in den preset-track springen
.ptrack	move.w	#5,cursorpos(a5)
	bra.s	.set

.rts	rts

;=== in den grten track springen
.mostleft
	move.l	maxtracks_m1(a5),currenttrack(a5)
.ntrack	move.w	#2,cursorpos(a5)
	jmp	RefreshTracksJ(a5)
.set	jmp	set_cursorJ(a5)
.links	subq.w	#1,cursorpos(a5)
	bra.s	.set


;=== tracks um eins nach links shiften

.kick_left
	tst.b	shiftpressed(a5)
	bne.s	.fast
	move.l	displaytrack(a5),d0
	subq.l	#1,d0
	bcs.s	.rts
	bra.s	.shift
.fast	move.l	displaytrack(a5),d0
	beq.s	.rts
	sub.l	displayed_tracks(a5),d0
	bcc.s	.shift
	moveq	#0,d0
.shift	move.l	d0,displaytrack(a5)
	bra	fresh_leftright


.patt_minus
	tst.b	pattern_locked(a5)
	bne.s	.locked
	bra	patt_minus
.locked
	bra	pat_minus_down





;==============================================================
;
;  Numeric Pad Tasten
;
;==============================================================

key_pad_bracket1
	moveq	#1,d0
	bra.s	KeySelectChannel

key_pad_bracket2
	moveq	#2,d0
	bra.s	KeySelectChannel

key_pad_slash
	moveq	#3,d0
	bra.s	KeySelectChannel

key_pad_stern
	moveq	#4,d0
	bra.s	KeySelectChannel

key_pad_7
	moveq	#5,d0
	bra.s	KeySelectChannel

key_pad_8
	moveq	#6,d0
	bra.s	KeySelectChannel

key_pad_9
	moveq	#7,d0
	bra.s	KeySelectChannel

key_pad_minus
	moveq	#8,d0
	bra.s	KeySelectChannel


numpad_conversion
	dc.b	0,0,0,0,7,8,9,0,4,5,6,0,1,2,3,-1


KeySelectChannel

	tst.b	pckeyboard(a5)
	beq.s	.amigakeyboard

	move.b	numpad_conversion-1(pc,d0.w),d0
	beq.s	.rts
	bpl.s	.isnumber
; enter has been pressed
	st	pcnumpad_shift(a5)
.rts	rts
.isnumber
	tst.b	pcnumpad_shift(a5)
	beq.s	.noshiftup
	addq.w	#8,d0
	cmp.w	#16,d0
	bgt.s	.rts
.noshiftup

.amigakeyboard




	tst.b	ctrlpressed(a5)
	beq.s	.nocontrol

;=== Control-qualifier will enable/disable global channelmutes


	moveq	#GD_chanen1-1,d1
	add.l	d0,d1
	move.l	d1,d3
	jsr	ToggleButtonChanJ(a5)

;	jsr	state_of_any_channelJ(a5)
;	beq.s	.empty

;	move.l	d3,d0
;	jsr	GetAnyChannelJ(a5)
;	beq.s	.empty


;	not.b	ch_onoff(a0)

	move.l	d3,d1
	jmp	chanen_gadsJ(a5)

;	beq.s	.set
;	jsr	UnselectButtonChanJ(a5)
;	bra.s	.cont
;.set	jsr	SelectButtonChanJ(a5)
;.cont

;.empty	rts

.nocontrol





	tst.b	shiftpressed(a5)
	beq.s	.noshift

	lea	chanselect_mappings(a5),a0
	moveq	#15,d1
.checkloop
	cmp.w	(a0)+,d0
	dbeq	d1,.checkloop
	beq.s	.Select

	; d0 is parameter
	jmp	OpenChannelJ(a5)
.noshift

.Select
	bsr	SelectChannel


RefreshMainChannel
	moveq	#0,d0
	move.w	currentchannel(a5),d0
	moveq	#GD_Channel,d1
	jmp	SetSliderMainJ(a5)

key_pad_4
	moveq	#9,d0
	bra	KeySelectChannel

key_pad_5
	moveq	#10,d0
	bra	KeySelectChannel

key_pad_6
	moveq	#11,d0
	bra	KeySelectChannel

key_pad_plus
	moveq	#12,d0
	bra	KeySelectChannel

key_pad_1
	moveq	#13,d0
	bra	KeySelectChannel

key_pad_2
	moveq	#14,d0
	bra	KeySelectChannel

key_pad_3
	moveq	#15,d0
	bra	KeySelectChannel

key_pad_enter
	moveq	#16,d0
	bra	KeySelectChannel


keyup_enter
	sf	pcnumpad_shift(a5)
	rts



key_pad_0

;=== Octave minus

	cmp.w	#1,octave(a5)
	bhi.s	.less
	rts
.less	subq.w	#1,octave(a5)
newoctave
	jsr	make_octaveJ(a5)
	jmp	set_wdtitle_mainJ(a5)




key_pad_punkt

;=== Octave plus

	cmp.w	#9,octave(a5)
	bmi.s	.more
	rts
.more	addq.w	#1,octave(a5)
	bra.s	newoctave

