;APS0000FB3E000025080000250800002508000025080000250800002508000025080000250800002508
;
; mt-config.S
;


;==============================================================
;
;  Prefs laden
;
;==============================================================

loadprefs
	jsr	checkpubscreenJ(a5)
	beq.s	.rts

	lea	.rt_lprefs_struct(pc),a4
	jsr	FileRequesterJ(a5)
	beq	load_cancelled

	bsr	stop_routine

	bsr	CloseVisuals

	move.l	maxtracks(a5),-(sp)
	bsr	loadprefs_routine
	move.l	(sp)+,d1
	subq.w	#1,d0
	beq.s	.error_notfound
	subq.w	#1,d0
	beq.s	.error_corrupt
	subq.w	#1,d0
	beq.s	.error_nomem


;=== init new maxtracks structures
	move.l	maxtracks(a5),d0
	move.l	d1,maxtracks(a5)
	jsr	NewMaxtracksDataJ(a5)		; d0 is input for this


	bsr	NewControlsources

	jsr	restore_filtersJ(a5)

	jsr	check_titleflagsJ(a5)
	jsr	PerformPatternfontJ(a5)

.backfromerror
	bsr	OpenVisuals
	beq.s	.openerror

.rts	rts

.openerror
	rts



.error_nomem
	jsr	nomemoryJ(a5)
	bra.s	.negback

.error_corrupt
	bsr	loaderror_corrupt
	bra.s	.negback

.error_notfound
	bsr	file_not_found
.negback
	jsr	allright_statusJ(a5)
	bra.s	.backfromerror


.rt_lprefs_struct
	dc.w	rt_prefs_fr
	dc.w	MTmainStruct
	dr.w	rt_prefs_pat
	dc.w	loc_lprefstitle
	dc.w	rt_prefs_name
	dc.w	rt_prefs_path
	dc.l	rt_load_flags



file_not_found
	move.w	#loc_filenfound,d0
	move.w	#loc_niceday,d1
	jmp	EZrequestJ(a5)


load_cancelled
	move.w	#loc_loadcancel,d0
	jmp	status_displayJ(a5)





FIXFLAG	MACRO
	tst.b	\1(a5)
	sne	\1(a5)
	ENDM




loadprefs_routine	; wird auch von initsomething aufgerufen

	clr.w	pr_version(a5)		; in case prefs cannot be loaded


;	lea	rt_prefs_path(a5),a0
;	jsr	DoCDJ(a5)
;	beq	.error_notfound


;=== Prefs ffnen
	lea	rt_prefs_path(a5),a0
	lea	rt_prefs_name(a5),a1
	jsr	CompleteFilenameJ(a5)
	move.l	#1005,d2
	move.l	dosbas(a5),a6
	jsr	Open(a6)
	move.l	d0,d7
	beq	.error_notfound

	move.l	d7,d1
	move.l	fib(a5),d2
	jsr	ExamineFH(a6)
	tst.l	d0
	beq	.error_corrupt
	move.l	d2,a0
	move.l	$7c(a0),d4
	cmp.l	#pr_sizeof,d4
	bhi	.error_corrupt

;=== Allocate temporary memory
	move.l	d4,d0
	moveq	#1,d1
	move.l	(a5),a6
	jsr	AllocMem(a6)
	tst.l	d0
	beq	.error_nomem
	move.l	d0,a2

;=== Read prefs data
	move.l	d7,d1
	move.l	a2,d2
	move.l	d4,d3
	move.l	dosbas(a5),a6
	jsr	Read(a6)
	cmp.l	d3,d0
	bne	.error_corrupt

;=== is it an MTCONFIG file ?
	cmp.l	#'MTCO',(a2)
	bne	.error_corrupt
	cmp.l	#'NFIG',4(a2)
	bne	.error_corrupt


	move.l	d7,d1
	jsr	Close(a6)
	moveq	#0,d7

;=== Copy prefs data, dependent of prefs' version
	move.w	pr_version-pr_code(a2),d0
	cmp.w	#current_prefs_version+1,d0
	bcc	.error_corrupt

	move.l	d4,d0				; d4 is length of file
	move.l	a2,a0
	lea	pr_code(a5),a1
	move.l	(a5),a6
	jsr	CopyMem(a6)



; copy channelwindow coords
;	move.l	pr_openwindows_more(a5),openwindows_more(a5)
;	lea	pr_inst1_ltwh(a5),a0
;	lea	inst1_ltwh(a5),a1
;	moveq	#15,d0
;.copycoords
;	move.l	(a0)+,(a1)+
;	move.l	(a0)+,(a1)+
;	dbf	d0,.copycoords



;=== Release temporary memory
	move.l	a2,a1
	move.l	d4,d0
	jsr	FreeMem(a6)


;=== fix some flags to correct values in earlier version
	cmp.w	#9,pr_version(a5)
	bhi.s	.noneed
	FIXFLAG	ignorenoffs
;	FIXFLAG	saveicons
;	FIXFLAG	hide_method
;	FIXFLAG	cuttobuf
;	FIXFLAG	joindomi
;	FIXFLAG	delchanb4rec
;	FIXFLAG	autovelflag
;	FIXFLAG	highresoflag
;	FIXFLAG	panicmode
	FIXFLAG	sequencer_sysex
	FIXFLAG	haltpatt
	FIXFLAG	send_mtc
	FIXFLAG	playdisabled
;	FIXFLAG	xpkonoff
;	FIXFLAG	midithru_global
;	FIXFLAG	dump_handshake
.noneed


	cmp.w	#11,pr_version(a5)
	bcc.s	.noneed11
	move.w	metropreset(a5),d0
	divu	#100,d0
	move.b	d0,metropreset(a5)
	swap	d0
	move.b	d0,metropreset+1(a5)
.noneed11


	cmp.w	#12,pr_version(a5)
	bcc.s	.noneed12
;	sf	cia_or_midilib(a5)
	sf	samples_active(a5)
.noneed12



	cmp.w	#13,pr_version(a5)
	bcc.s	.noneed13

	move.l	sernamD(a5),a0
	lea	serial_device(a5),a1
	COPYTILLZERO
	clr.b	serial_unit(a5)

.noneed13



;=== set empty window-coords to default values; set original sizes
	lea	pr_main_ltwh(a5),a0
	move.l	windowcoordsD(a5),a1
	move.w	#[coordsnum-1]*8,d0
;	bsr.s	.coordsloop

;	lea	inst1_ltwh(a5),a0
;	move.l	windowcoords_moreD(a5),a1
;	move.w	#[coordsnum_more-1]*8,d0
;	bsr.s	.coordsloop
;	bra.s	.coordscont

.coordsloop
	move.l	4(a1,d0.w),4(a0,d0.w)
	tst.l	(a0,d0.w)
	bne.s	.filled
	move.l	(a1,d0.w),(a0,d0.w)
.filled	subq.w	#8,d0
	bcc.s	.coordsloop
	rts
.coordscont



;=== calculate recordbuffer-size
	move.l	recbufsize(a5),d0
	lsl.l	#8,d0
	lsl.l	#2,d0
	move.l	d0,recbufsizebytes(a5)


;	move.w	#3,pr_screendepth(a5)


	moveq	#0,d0
	rts


.error_notfound
	moveq	#1,d0
	rts
.error_nomem
	moveq	#3,d0
	bra.s	.neg
.error_corrupt
	moveq	#2,d0

	move.l	d0,-(sp)
	move.l	a2,a1
	move.l	d4,d0
	move.l	(a5),a6
	jsr	FreeMem(a6)
	bra.s	.n3

.neg	move.l	d0,-(sp)
.n3	move.l	d7,d1
	beq.s	.closed
	move.l	dosbas(a5),a6
	jsr	Close(a6)
.closed	move.l	(sp)+,d0
	rts







NewControlsources

	move.l	pr_csources(a5),-(sp)

;=== free all csources, then add the new ones
	cmp.w	#3,pr_version(a5)
	bmi.s	.too_old

	jsr	FreeControlSourcesDataJ(a5)

	tst.l	(sp)
	beq.s	.too_old

.addloop
	subq.l	#1,(sp)
	bcs.s	.nomorecs
	move.l	(sp),d2
	lea	pr_codetab(a5),a0
	move.b	(a0,d2.l),d0
	jsr	AddControlsourceJ(a5)
	bne.s	.addloop

;=== error handling
.too_old
	jsr	InitControlSourcesDataJ(a5)	; includes FreeControlsourcesData
	beq.s	.neg

.nomorecs
;	jsr	defaultctracksJ(a5)
	move.w	#1,pgfx_active(a5)
	addq.w	#4,sp
	POSITIV

.neg	addq.w	#4,sp
	NEGATIV






;==============================================================
;
;  Prefs abspeichern
;
;==============================================================

saveprefsas
	lea	rt_sprefs_struct(pc),a4
	jsr	FileRequesterJ(a5)
	beq.s	save_cancelled

	lea	rt_prefs_path(a5),a0
	lea	rt_prefs_name(a5),a1
	jsr	CompleteFilenameJ(a5)
	move.l	#1005,d2
	move.l	dosbas(a5),a6
	jsr	Open(a6)
	move.l	d0,d1
	beq.s	saveprefs_routine
	jsr	Close(a6)

	move.w	#loc_fileexists,d0
	move.w	#loc_goaheaddont,d1
	jsr	EZrequestJ(a5)
	tst.l	d0
	bne.s	saveprefs_routine

save_cancelled
	move.w	#loc_savecancel,d0
	jmp	status_displayJ(a5)


saveprefs
;	lea	rt_prefs_path(a5),a0
;	tst.b	(a0)
;	beq.s	.nopath
;	jsr	DoCDJ(a5)
;	beq	save_error
;	bra.s	.cont
;.nopath
;	jsr	GoStartCDJ(a5)
;	beq	save_error
;.cont



saveprefs_routine

	bsr	save_ltwh

	bsr	saving_status

;=== open the file

	lea	rt_prefs_path(a5),a0
	lea	rt_prefs_name(a5),a1
	jsr	CompleteFilenameJ(a5)
	move.l	#1006,d2
	move.l	dosbas(a5),a6
	jsr	Open(a6)
	move.l	d0,d7
	beq	.openerror


;=== prepare Prefs structure

	move.l	d7,d1
	move.l	#'MTCO',pr_code(a5)
	move.l	#'NFIG',pr_code+4(a5)
	move.w	#current_prefs_version,pr_version(a5)


;=== copy some data to prefs structure

	move.l	maxtracks(a5),pr_maxtracks(a5)

	lea	codetab(a5),a0
	lea	pr_codetab(a5),a1
	move.l	active_csources(a5),d0
	move.l	d0,pr_csources(a5)
	move.l	(a5),a6
	jsr	CopyMem(a6)


	lea	pr_filter_block_start(a5),a1
	lea	filter_block_start(a5),a0
	move.l	#pr_filter_block_end-pr_filter_block_start,d0
	jsr	CopyMem(a6)



; copy channelwindow coords
;	move.l	openwindows_more(a5),pr_openwindows_more(a5)
;	lea	inst1_ltwh(a5),a0
;	lea	pr_inst1_ltwh(a5),a1
;	moveq	#15,d0
;.copycoords
;	move.l	(a0)+,(a1)+
;	move.l	(a0)+,(a1)+
;	dbf	d0,.copycoords




;=== save and close
	move.l	d7,d1
	lea	pr_code(a5),a0
	move.l	a0,d2
	move.l	#pr_sizeof,d3
	move.l	dosbas(a5),a6
	jsr	Write(a6)
	cmp.l	d3,d0
	bne.s	.writeerror

	move.l	d7,d1
	jsr	Close(a6)

	bra.s	save_ok


.writeerror
	move.l	d7,d1
	jsr	Close(a6)
.openerror
	bra.s	save_error



save_ok
	move.w	#loc_save_ok,d0
	jmp	status_displayJ(a5)


save_error
	move.w	#loc_saveerror,d0
	move.w	#loc_ohmygod,d1
	jmp	EZrequestJ(a5)




rt_prefs_pat	dc.b	'#?.prefs',0

		even


rt_sprefs_struct
	dc.w	rt_prefs_fr
	dc.w	MTmainStruct
	dr.w	rt_prefs_pat
	dc.w	loc_sprefstitle
	dc.w	rt_prefs_name
	dc.w	rt_prefs_path
	dc.l	rt_save_flags




