  '                  
animation_flag	equ 0	; enable/disable gadget animation


;==============================================================
;
;  gadget animation structure
;
;==============================================================

		IFNE	animation_flag

		rsreset
		rs.w	1	; varbase-offset to global flag
an_where	rs.b	1	; flag: -1=intro, 0=inloop, 1=outro
an_running	rs.b	1	; -1 = anim running, 0 = anim finished
an_whatisnext	rs.b	1	; -1 = fade to play, 0 = standard animation,
				;  1 = fade to stop
		rs.b	1
an_counter	rs.w	1	; offset-counter
an_intro	rs.w	1	; ^intro sequence (dr.w)
an_inloop	rs.w	1	; ^loop sequence (dr.w)
an_outro	rs.w	1	; ^outro sequence (dr.w)
an_imagery	rs.w	1	; ^image data table (dr.w)
an_gadgetID	rs.w	1	; gadget's ID number

		ENDC




	IFNE	animation_flag
	st	recsong_anim(a5)	; trigger gadget animation (after player)
	ELSE
	nop
	ENDC


	IFNE	animation_flag
	st	recpatt_anim(a5)	; trigger gadget animation (after player)
	ELSE
	nop
	ENDC

	IFNE	animation_flag
	st	playsong_anim(a5)	; trigger gadget animation (after player)
	ELSE
	nop
	ENDC

	IFNE	animation_flag
	st	playpatt_anim(a5)	; trigger gadget animation
	ELSE
	nop
	ENDC


	IFNE	animation_flag
	bsr	gadget_animator			; animate some gadgets
	ENDC


;==============================================================
;
;  Animate PlayPatt/PlaySong/RecPatt/RecSong gadgets!
;
;==============================================================

	IFNE	animation_flag

gadget_animator
	lea	.pp_animstruct(pc),a4
	bsr.s	.animate
	lea	.ps_animstruct(pc),a4
	bsr.s	.animate
;	lea	.rp_animstruct(pc),a4
;	bsr.s	.animate
;	lea	.rs_animstruct(pc),a4
;	bsr.s	.animate
	rts




.animate
	move.w	(a4),d0
	tst.b	(a5,d0.w)
	beq.s	.idle
	bmi.s	.start

;=== STOP is requested
	sf	(a5,d0.w)
	tst.b	an_running(a4)
	beq.s	.rts
	move.b	#1,an_whatisnext(a4)	; fade to stop
	bra.s	.anim_running

;=== start the anim

.start	sf	(a5,d0.w)
	tst.b	an_running(a4)
	beq.s	.restart
	st	an_whatisnext(a4)	; fade to playmode
	bra.s	.anim_running
.restart
	sf	an_whatisnext(a4)
	st	an_running(a4)
	st	an_where(a4)		; start with intro (this is -1)
	clr.w	an_counter(a4)
	bra.s	.anim_running


;=== user is idle, doing nothing

.idle	tst.b	an_running(a4)
	beq.s	.rts			; no anim is running


;=== the anim is in full motion!

.anim_running
	tst.b	an_where(a4)
	bmi.s	.intro
	beq.s	.inloop

;=== we are running the final part (outro)

.outro	move.w	an_counter(a4),d0
	addq.w	#1,an_counter(a4)
	move.w	an_outro(a4),d1
	lea	an_outro(a4,d1.w),a0	; pointer to outro-arrangement
	moveq	#0,d3
	move.b	(a0,d0.w),d3
	bpl.s	.make_gadget
	tst.b	an_whatisnext(a4)
	bmi.s	.restart		; if user has pressed PLAY during outro

;=== we have reached the total end
.end	sf	an_running(a4)		; no more anim
.rts	rts


;=== we are running the introduction...

.intro	tst.b	an_whatisnext(a4)
	ble.s	.normal_intro
	subq.w	#1,an_counter(a4)
	bcs.s	.end
	move.w	an_counter(a4),d0
	bra.s	.play_intro
.normal_intro
	sf	an_whatisnext(a4)
	move.w	an_counter(a4),d0
	addq.w	#1,an_counter(a4)
.play_intro
	move.w	an_intro(a4),d1
	lea	an_intro(a4,d1.w),a0	; pointer to intro-arrangement
	moveq	#0,d3
	move.b	(a0,d0.w),d3
	bpl.s	.make_gadget
	clr.w	an_counter(a4)		; we have reached the intro's end
	addq.b	#1,an_where(a4)		; inloop mode (this is 0)


;=== here we are running the midpart, in a forward-loop

.inloop	move.w	an_counter(a4),d0
	addq.w	#1,an_counter(a4)
	move.w	an_inloop(a4),d1
	lea	an_inloop(a4,d1.w),a0	; pointer to inloop-arrangement
	moveq	#0,d3
	move.b	(a0,d0.w),d3
	bpl.s	.make_gadget
	clr.w	an_counter(a4)		; set imagecounter to 0
	tst.b	an_whatisnext(a4)
	ble.s	.inloop			; repeat loop
	sf	an_whatisnext(a4)
	addq.b	#1,an_where(a4)		; set to outro mode (this is 1)
	bra	.outro


.make_gadget	; d3.w=imagery number

;=== remove the gadget in order to change it
	move.l	MTmainWnd(a5),d0
	beq.s	.rts			; in case we are iconified

	move.l	d0,a0
	move.w	an_gadgetid(a4),d0
	lea	MTmainGadgets(a5),a1
	IFEQ	mc68020
	lsl.w	#2,d0
	move.l	(a1,d0.w),a1
	ELSE
	move.l	(a1,d0.w*4),a1		; Gadget pointer
	ENDC
	move.l	a1,a3			; save this for AddGList()
	move.l	intbas(a5),a6
	jsr	RemoveGadget(a6)
	move.w	d0,d4


;=== plug in the new imagery
	move.l	18(a3),a0		; GadgetRender image
	move.w	an_imagery(a4),d0
	lea	an_imagery(a4,d0.w),a1	; pointer to imagery-table
	IFEQ	mc68020
	lsl.w	#2,d3
	move.l	-4(a1,d3.w),10(a0)	; d3 starts with 1, so we fix it with -4
	ELSE
	move.l	-4(a1,d3.w*4),10(a0)
	ENDC

;=== add the gadget to window's GList
	move.l	MTmainWnd(a5),a0
	move.l	a3,a1
	move.w	d4,d0
	jsr	AddGadget(a6)

;=== refresh our gadget to throw its imagery into the window
	move.l	a3,a0
	move.l	MTmainWnd(a5),a1
	suba.l	a2,a2
	moveq	#1,d0
	jmp	RefreshGList(a6)




;=== Animation structure for PlayPattern

.pp_animstruct
	dc.w	playpatt_anim	; varbase-offset to global flag
	dc.b	0		; status: -1=start, 0=inloop, 1=outro
	dc.b	0		; running flag
	dc.b	0		; what's next
	dc.b	0
	dc.w	0		; offset-counter
	dr.w	.pp_intro
	dr.w	.pp_inloop
	dr.w	.pp_outro
	dr.w	.pp_imagetable
	dc.w	GD_playpatt


;=== Animation structure for PlaySong

.ps_animstruct
	dc.w	playsong_anim	; varbase-offset to global flag
	dc.b	0		; status: -1=start, 0=inloop, 1=outro
	dc.b	0		; running flag
	dc.b	0		; what's next
	dc.b	0
	dc.w	0		; offset-counter
	dr.w	.pp_intro	; the same values as from PlayPattern
	dr.w	.pp_inloop	;
	dr.w	.pp_outro	;
	dr.w	.ps_imagetable
	dc.w	GD_playsong



.pp_imagetable	dc.l	PlayPattUp1,PlayPattUp2,PlayPattUp3,PlayPattUp4
		dc.l	PlayPattUp5,PlayPattUp6,PlayPattUp7,PlayPattUp8
		dc.l	PlayPattUp9,PlayPattUp10,PlayPattUp11,PlayPattUp12
		dc.l	PlayPattUp13,PlayPattUp14,PlayPattUp15,PlayPattUp16
		dc.l	PlayPattUp17,PlayPattUp18,PlayPattUp19,PlayPattUp20
		dc.l	PlayPattUp21,PlayPattUp12,PlayPattUp23,PlayPattUp24

.ps_imagetable	dc.l	PlaySongUp1,PlaySongUp2,PlaySongUp3,PlaySongUp4
		dc.l	PlaySongUp5,PlaySongUp6,PlaySongUp7,PlaySongUp8
		dc.l	PlaySongUp9,PlaySongUp10,PlaySongUp11,PlaySongUp12
		dc.l	PlaySongUp13,PlaySongUp14,PlaySongUp15,PlaySongUp16
		dc.l	PlaySongUp17,PlaySongUp18,PlaySongUp19,PlaySongUp20
		dc.l	PlaySongUp21,PlaySongUp12,PlaySongUp23,PlaySongUp24


.pp_intro	dc.b	1,2,3
		dc.b	-1

.pp_inloop	dc.b	4,5,6,7,8,9,10,11,12,13,14,15,16,17
		dc.b	-1

.pp_outro	dc.b	18,19,20,21,22,23,24,3,2,1
		dc.b	-1


		even


	ENDC



	IFNE	animation_flag
	dc.l	PlayPattUp1
	ELSE

	IFNE	animation_flag
	dc.l	PlaySongUp1
	ELSE

	IFNE	animation_flag
	dc.l	RecordSongUp1
	ELSE

	IFNE	animation_flag
	dc.l	RecordPattUp1
	ELSE


		IFNE	animation_flag
anim_allflags	rs.l	0	; optimizing, to access all flags in one longword
playpatt_anim	rs.b	1	; status flags
playsong_anim	rs.b	1	;   -1 = gadget was pressed (play/rec buttons)
recpatt_anim	rs.b	1	;    0 = idle or ready
recsong_anim	rs.b	1	;    1 = initiate outro (Stop button)
		ENDC
