const int keys_max=12,
      eUp=0, eDown=1; // stem direction

struct PostscriptOut {
  int lst_ind,
      start_meas,
      s_inst_voice; // the instrument voice-nr if s_voice true
  bool s_voice,  // true if 1 instr enabled, and no percussion
       s_perc;   // true if no instr enabled, only percussion
  void write_ps();
  void reset_ps();
  void insert(int col,int time,int midi_nr,int dur1,int triad_cat);
  void insert_slashed(int col,int time,int triad_cat);
  void insert_perc(int col,int time,int triad_cat);
  void add_staccato(int meas_nr);
  void fill_subvoice(int meas_nr,int subv_nr);
  void fill_perc_subv(int meas_nr,int subv_nr);
  bool create_postscript(int tr_mode); // in bigband.cpp
  void set(int tr_mode,bool skip_fr,bool inv_p_rest);
  void print_subvoice(int,struct Voice*,int subv);
  void print_perc_subvoice(struct SubVoice*,int subv);
};

extern PostscriptOut ps_out;

extern const char *clefname[2],
                  *tune_title,
                  *author,
                  *maj_keys[keys_max];
