#include <stdio.h>
#include "sdl-widgets.h"
#include "bigband.h"

struct HelpWin {
  BgrWin *bgw;
  HelpWin(WinBase *topw);
} *help_w;

BgrWin* help_window(WinBase *topw) {
  help_w=new HelpWin(topw);
  return help_w->bgw;
}

static void draw_helpw(BgrWin *bgw);

static void but_cmd(Id id) { help_w->bgw->hide(); }

HelpWin::HelpWin(WinBase *tw) {
  bgw=new BgrWin(tw,Rect(2,2,340,450),0,draw_helpw,0,0,0,calc_color(0xd0ffff));
  bgw->keep_on_top();
  new Button(bgw,Style(0,1),Rect(bgw->area.w-18,3,14,13),"X",but_cmd);
  bgw->draw_blit_recur();
  bgw->upd();
}

void draw_s(BgrWin *bgw,const char *s1,const char *s2,int x,int dx,int y) {
  draw_title_ttf->draw_string(bgw->win,s1,Point(x,y));
  draw_ttf->draw_string(bgw->win,s2,Point(x+dx,y));
}

void draw_helpw(BgrWin *bgw) {
  bgw->clear();
  rectangleColor(bgw->win,0,0,bgw->area.w-1,bgw->area.h-1,0xff);
  int y=4;
  draw_title_ttf->draw_string(bgw->win,"MOUSE & KEY BINDINGS",Point(70,y));
  y+=20;
  draw_title_ttf->draw_string(bgw->win,"annotations, chords window",Point(4,y));
  y+=16;
  draw_title_ttf->draw_string(bgw->win,"mouse buttons",Point(24,y));
  y+=16;
  draw_s(bgw,"L",": edit",44,12,y);
  draw_s(bgw,"M",": select >>",44,12,y+=14);
  draw_s(bgw,"R",": move selection",44,12,y+=14);
  y+=20;
  draw_title_ttf->draw_string(bgw->win,"instruments, percussion windows",Point(4,y));
  y+=16;
  draw_title_ttf->draw_string(bgw->win,"mouse buttons",Point(24,y));
  y+=16;
  draw_title_ttf->draw_string(bgw->win,"s key pressed",Point(44,y));
  y+=16;
  draw_s(bgw,"L",": select 1 color",64,12,y);
  draw_s(bgw,"M",": select all >>",64,12,y+=14);
  draw_s(bgw,"R",": select note or column",64,12,y+=14);
  y+=16;
  draw_title_ttf->draw_string(bgw->win,"else",Point(44,y));
  y+=16;
  draw_s(bgw,"L",": insert/remove note (1 color)",64,12,y);
  draw_s(bgw,"M",": stacc note (1 color)",64,12,y+=14);
  draw_s(bgw,"R",": insert/remove note",64,12,y+=14);
  y+=16;
  draw_title_ttf->draw_string(bgw->win,"keys",Point(24,y));
  y+=16;
  draw_s(bgw,"m",": move selection",44,10,y);
  draw_s(bgw,"c",": copy selection",44,10,y+=14);
  draw_s(bgw,"k",": (keep) no moving or copying",44,10,y+=14);
  draw_s(bgw,"p",": (place) copy selection to where mouse is clicked",44,10,y+=14);
  draw_s(bgw,"n",": (new) move selection to where mouse is clicked",44,10,y+=14);
  draw_s(bgw,"i",": (info) get data about a note",44,10,y+=14);
  draw_s(bgw,"<ctrl>",": move contents by dragging the mouse",44,35,y+=14);
  y+=20;
  draw_title_ttf->draw_string(bgw->win,"chord hint button",Point(4,y));
  y+=16;
  draw_title_ttf->draw_string(bgw->win,"keys",Point(24,y));
  y+=16;
  draw_s(bgw,"a",": all chord hints",44,10,y);
  draw_s(bgw,"i",": info about available chords",44,10,y+=14);
}
