/* Support routines for the HP11, but not HP11 specific */

/* Macros to convert to/from grad's/degrees from/to radians */
#define PI 3.141592654
#define TDEG(x) (x) * (180.0 / PI)
#define FDEG(x) (x) * (PI / 180.0)
#define TGRAD(x) (x) * (200.0 / PI)
#define FGRAD(x) (x) * (PI / 200.0)
#define E 2.718281828

double sign(double); /* return the sign of the number */
void Rect(double, double, double *, double *); /* Convert from Polar to Rectangular */
void Polar(double, double, double *, double *); /* Convert from Rectangular to Polar */
double Perm(int, int); /* Compute the permutation of y items taken x at a time (ordered) */
double Comb(int, int); /* Compute the combination of y items taken x at a time (unorderd) */
double hr(double); /* Convert to decimal hours */
double hms(double); /* Convert from decimal hours to hh.mmss */
double trunc(double); /* Truncate double, returning a double */
double frac(double); /* Take the fractional part of a double */
double factorial(int); /* Compute the factorial */
double gamma(double); /* Compute the gamma function */
double stirling(double); /* Stirling's approximation */
/* Hyperbolic reciprocal functions (the others are in the library) */
double asinh(double), acosh(double), atanh(double);
