#define __USE_INLINE__

#include <proto/exec.h>
#include <proto/graphics.h>
#include <proto/intuition.h>
#include <proto/icon.h>
#include <proto/dos.h>
#include <proto/asl.h>
#include <proto/gadtools.h>
#include <proto/wb.h>

#include <string.h>
#include <math.h>

#include "hp11.h"
#include "io.h"
#include "ins.h"
#include "internal.h"

#define FILENAMESIZE	256

static const char version [] = "$VER: HP11C 1.4 (21.03.2010) AROS version by Matthias Rustler - based on OS4 version from Bill Eaves";
static const char about[] = "HP11C RPN Calculator - version 1.4 (21.03.2010)\n"
                            "AROS version by Matthias Rustler\n"
                            "based on OS4 version from Bill Eaves";

static struct Menu *	hp11menu      = 0;
extern BOOL	    icons_on;
static char 		winname[110];


static struct NewMenu newmen[] = {
  NM_TITLE,"Project",	  0, 0, 0, 0,
  NM_ITEM, "Reset",	    0, 0, 0, 0,
  NM_ITEM, "Open...",	"O", 0, 0, 0,
  NM_ITEM, "Save",	  "S", 0, 0, 0,
  NM_ITEM, "Save As...","A", 0, 0, 0,
  NM_ITEM, NM_BARLABEL, 0, 0, 0, 0,
  NM_ITEM, "About",    "?", 0, 0, 0,
  NM_ITEM, NM_BARLABEL, 0, 0, 0, 0,
  NM_ITEM, "Iconify",    "I", 0, 0, 0,
  NM_ITEM, "Quit",	  "Q", 0, 0, 0,
  NM_TITLE,"Edit",	  0, 0, 0, 0,
  NM_ITEM, "Copy",      "C", 0, 0, 0,
  NM_ITEM, "Paste",     "V", 0, 0, 0,
  NM_TITLE,"Options",	  0, 0, 0, 0,
  NM_ITEM, "Radix",	  0, 0, 0, 0,
  NM_SUB, "Point",      ".", CHECKIT|CHECKED, 2, 0,
  NM_SUB, "Comma",      ",", CHECKIT, 1, 0,
  NM_ITEM, "Speed",	  0, 0, 0, 0,
  NM_SUB, "Slow",	  0, CHECKIT|CHECKED, 2, 0,
  NM_SUB, "Fast",	  0, CHECKIT, 1, 0,
  NM_ITEM, "Icons",	  0, MENUTOGGLE|CHECKIT|CHECKED, 0, 0,
  NM_END,   0, 0, 0, 0, 0};


void Message(STRPTR txt)
{
  struct EasyStruct es = { sizeof(struct EasyStruct), 0, "HP11C Message",
  0, "OK"};
  es.es_TextFormat = txt;
  EasyRequest(hp11, &es, 0, 0);
}



/* Enable menus */
void MenusOn(void)
{
  SetMenuStrip(hp11, hp11menu);
}

/* Disable menus */
void MenusOff(void)
{
  ClearMenuStrip(hp11);
}

void EditOn(void)
{
  OnMenu(hp11, FULLMENUNUM(1,NOITEM,NOSUB));
}

void EditOff(void)
{
  OffMenu(hp11, FULLMENUNUM(1,NOITEM,NOSUB));
}

static BOOL GetFile(STRPTR text, ULONG save)
{
  BOOL ret = FALSE;
  struct Library *AslBase;

  if((AslBase = OpenLibrary("asl.library", 37)))
  {
	struct FileRequester *r;
	if((r = (struct FileRequester *) AllocAslRequest(ASL_FileRequest, 0)))
	{
	  if(AslRequestTags(r, ASLFR_TitleText, text, ASLFR_DoSaveMode, save,
	  ASLFR_InitialFile, filename, TAG_DONE))
	  {
		strcpy(filename, r->fr_Drawer);
		AddPart(filename, r->fr_File, FILENAMESIZE);
		ret = TRUE;
	  }
	}
	FreeAslRequest(r);
  }
  CloseLibrary(AslBase);
  return ret;
}

void SetTitle(void)
{
  SetWindowTitles(hp11, strcat(strcpy(winname, "HP11C - "), filename), (STRPTR) ~0);
}

void LoadProg(void)
{
  BPTR file;
  struct DiskObject *icon;
  BYTE dummy;

  if((icon = GetDiskObject(filename)))
  {
	STRPTR val;

	if(!(val = FindToolType(icon->do_ToolTypes, "FILETYPE")) ||
	!MatchToolValue(val, "HP11"))
	{
	  Message("This isn't an HP11 program");
	  val = 0;
	}
	FreeDiskObject(icon);

	if(!val)
	  return;
  }
  if((file = Open(filename, MODE_OLDFILE)))
  {
	struct Regs newhp11;
	if((Read(file, &newhp11, sizeof(struct Regs)) == sizeof(struct Regs))
	&& (Read(file, &dummy, 1) != 1)) /* dummy read to check file size */
	{
	  hp11r = newhp11; /* Set new internal state */
	  running = FALSE; /* Interrupt program */
	  PC = 0;
	  retCnt = 0;
	  ENABLE();

	  SetTitle();
	}
	else
	  Message("This isn't an HP11 program");
	Close(file);
  }
  else
	Message("Couldn't open file");
}

/* Save current state under current filename */
static void StoreProg(void)
{
  BPTR file;
  LONG i;
  char tool[120];


  if(!(file = Open(filename, MODE_NEWFILE)))
	Message("Couldn't open file");
  else
  {
	i = Write(file, &hp11r, sizeof(struct Regs));
	Close(file);

	if(i != sizeof(struct Regs))
	  Message("Error writing the file");
	else
	{
	  SetTitle();
	  if(icons_on)
	  {
		struct DiskObject *ti;
		if(!(ti = GetDiskObject("env:sys/def_HP11C")))
		if(!(ti = GetDiskObjectNew(hp11name)))
			   ti=GetDefDiskObject(WBPROJECT);
		if (ti);
		{
			STRPTR tt[2] = {"FILETYPE=HP11" , 0};

		    ti->do_ToolTypes  = tt;
			ti->do_Gadget.Flags   = GFLG_GADGIMAGE|GFLG_GADGHCOMP;
		    ti->do_CurrentX	  = NO_ICON_POSITION;
		    ti->do_CurrentY	  = NO_ICON_POSITION;
		    ti->do_Type		  = WBPROJECT;
			ti->do_DefaultTool	  =	  strcat(strcpy(tool, hp11path),hp11name);
		    PutDiskObject(filename, ti);
			FreeDiskObject(ti);
		}
	  }
	}
  }
}

/* The menu handler, number represents the chosen option */
int MenuHandler(UWORD number)
{
  struct MenuItem *item;
  int key = -1;

  MenusOff(); /* Disable menus */

  while(number != MENUNULL)
  {
	item = ItemAddress(hp11menu, (long)number);

	switch(number)
	{
	case FULLMENUNUM(0,0,NOSUB): /* Project - New */
	  HP11ColdReset(); key = BRESET; break; /* back to main loop */
	case FULLMENUNUM(0,1,NOSUB): /* Project - Open */
	  if(GetFile("Open program", FALSE)) /* Get file name */
		LoadProg();
	  key = BRESET; break;
	case FULLMENUNUM(0,2,NOSUB): /* Project - Save */
	  StoreProg(); break;
	case FULLMENUNUM(0,3,NOSUB): /* Project - Save As */
	  if(GetFile("Save program", TRUE))
	StoreProg();
	  break;
	case FULLMENUNUM(0,5,NOSUB): /* Project - About */
		Message((STRPTR) about); break;
	case FULLMENUNUM(0,7,NOSUB): /* Project - Iconify */
		key=30; break;
	case FULLMENUNUM(0,8,NOSUB): /* Project - Quit */
	  quit = TRUE; key = BRESET; break;
	case FULLMENUNUM(1,0,NOSUB): /* Edit - Copy */
	  CBCut(X); break;
	case FULLMENUNUM(1,1,NOSUB): /* Edit - Paste */
	  {
		double x;
		if(CBPaste(&x))
		{
		  Enter(); ENABLE();
		  X = Check(x);
		}
	  }
	  key = BDISPLAY; break;
	case FULLMENUNUM(2,0,0):
	case FULLMENUNUM(2,0,1): /* Options - Radix */
	  comma = SUBNUM(number); /* false for Point, true for Comma */
	  key = BDISPLAY; /* Redisplay */
	  break;
	case FULLMENUNUM(2,1,0):
	case FULLMENUNUM(2,1,1): /* Options - Speed */
	  fast = SUBNUM(number); /* false for Slow, true for Fast */
	  break;
	case FULLMENUNUM(2,2,NOSUB): /* Options - Icons */
	  icons_on = item->Flags & CHECKED;
	  break;
	}

	number = item->NextSelect;
  }

  MenusOn();
  return(key);
}
BOOL MenuInit(void)
{
  if (icons_on==FALSE)
	 newmen[20].nm_Flags &= ~CHECKED;
  if(!(hp11menu = CreateMenusA(newmen, 0)))
	return FALSE;
  else
  {
	BOOL ret = TRUE;
	struct Screen *scr;

	if((scr = LockPubScreen(0)))
	{
	  APTR vi;

	  if((vi = GetVisualInfoA(scr, 0)))
	  {
		LayoutMenus(hp11menu, vi, GTMN_NewLookMenus, TRUE, TAG_DONE);
		FreeVisualInfo(vi);
	  }
	  else
		ret = FALSE;
	  UnlockPubScreen(0, scr);
	}
	else
	  ret = FALSE;
	if(!ret)
	  return ret;
  }
	MenusOn();
  return TRUE;
}

void MenuCleanUp (void)
{
	if(hp11menu)
		FreeMenus(hp11menu);
}


