/* Define type Decoder which is a function with a short * argument and which
  return an enum KeyTypes. These functions do the keyboard decoding for prefixes */
typedef enum KeyTypes (*Decoder)(short *);

/* One key of the keyboard structure : */
struct Key {
   enum KeyTypes Sort; /* The type of key */
   union { /* Different data for each type */
      Decoder suffix; /* Prefix ==> decoder function */
      LONG act; /* Action number */
      LONG code; /* Instruction number */
   } Data;
};

/* These defines are done to simplify access to the components */
#define Act Data.act
#define Code Data.code
#define Suffix Data.suffix

extern struct Key mainKbd[3 * NUMKEYS]; /* The main, f & g key sequences */
