/* A Bison parser, made by GNU Bison 1.875a.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     NUM = 258,
     VAR = 259,
     CONST = 260,
     FNCT = 261,
     CMD = 262,
     POW = 263,
     ROOT = 264,
     LEXERR = 265,
     INC = 266,
     DEC = 267,
     DIV = 268,
     MUL = 269,
     MOD = 270,
     NEG = 271
   };
#endif
#define NUM 258
#define VAR 259
#define CONST 260
#define FNCT 261
#define CMD 262
#define POW 263
#define ROOT 264
#define LEXERR 265
#define INC 266
#define DEC 267
#define DIV 268
#define MUL 269
#define MOD 270
#define NEG 271




/* Copy the first part of user declarations.  */
#line 1 "calc.y"

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <math.h>
#include "calc.h"
#include "ucon.h"

#define	CALC_PI	3.1415926535897932384626433832795029L
#define	CALC_E	2.7182818284590452353602874713526625L

//#ifndef HAVE_SNPRINTF
//#define	snprintf _snprintf
//#endif

int yylex();
int yyerror(const char *s);
static UCON_console *uc;
static int result;
static void checkdef(symrec *sr);


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 23 "calc.y"
typedef union YYSTYPE {
	double	val;	/* For returning numbers */
	symrec	*tptr;	/* For returning symbol-table pointers */
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 136 "calc.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 148 "calc.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  2
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   80

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  26
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  4
/* YYNRULES -- Number of rules. */
#define YYNRULES  25
/* YYNRULES -- Number of states. */
#define YYNSTATES  44

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   271

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      23,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,    21,     2,     2,
      24,    25,    19,    18,     2,    17,     2,    20,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    16,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    22
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned char yyprhs[] =
{
       0,     0,     3,     4,     7,     9,    11,    14,    16,    18,
      22,    24,    28,    32,    36,    40,    44,    47,    51,    55,
      59,    63,    67,    70,    74,    78
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const yysigned_char yyrhs[] =
{
      27,     0,    -1,    -1,    27,    28,    -1,     7,    -1,    29,
      -1,     1,    23,    -1,     3,    -1,     5,    -1,     4,    16,
      29,    -1,     4,    -1,     4,    11,    29,    -1,     4,    12,
      29,    -1,     4,    14,    29,    -1,     4,    13,    29,    -1,
       4,    15,    29,    -1,     6,    29,    -1,    29,    18,    29,
      -1,    29,    17,    29,    -1,    29,    19,    29,    -1,    29,
      20,    29,    -1,    29,    21,    29,    -1,    17,    29,    -1,
      29,     8,    29,    -1,    29,     9,    29,    -1,    24,    29,
      25,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned char yyrline[] =
{
       0,    50,    50,    51,    55,    56,    64,    67,    68,    69,
      75,    76,    83,    90,    97,   104,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "NUM", "VAR", "CONST", "FNCT", "CMD", 
  "POW", "ROOT", "LEXERR", "INC", "DEC", "DIV", "MUL", "MOD", "'='", 
  "'-'", "'+'", "'*'", "'/'", "'%'", "NEG", "'\\n'", "'('", "')'", 
  "$accept", "input", "line", "exp", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,    61,    45,    43,    42,
      47,    37,   271,    10,    40,    41
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    26,    27,    27,    28,    28,    28,    29,    29,    29,
      29,    29,    29,    29,    29,    29,    29,    29,    29,    29,
      29,    29,    29,    29,    29,    29
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     0,     2,     1,     1,     2,     1,     1,     3,
       1,     3,     3,     3,     3,     3,     2,     3,     3,     3,
       3,     3,     2,     3,     3,     3
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       2,     0,     1,     0,     7,    10,     8,     0,     4,     0,
       0,     3,     5,     6,     0,     0,     0,     0,     0,     0,
      16,    22,     0,     0,     0,     0,     0,     0,     0,     0,
      11,    12,    14,    13,    15,     9,    25,    23,    24,    18,
      17,    19,    20,    21
};

/* YYDEFGOTO[NTERM-NUM]. */
static const yysigned_char yydefgoto[] =
{
      -1,     1,    11,    12
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -22
static const yysigned_char yypact[] =
{
     -22,     0,   -22,   -21,   -22,    64,   -22,    31,   -22,    31,
      31,   -22,    50,   -22,    31,    31,    31,    31,    31,    31,
     -22,     1,    32,    31,    31,    31,    31,    31,    31,    31,
      50,    50,    50,    50,    50,    50,   -22,    -1,   -22,    53,
      53,     1,     1,     1
};

/* YYPGOTO[NTERM-NUM].  */
static const yysigned_char yypgoto[] =
{
     -22,   -22,   -22,     4
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const unsigned char yytable[] =
{
       2,     3,    13,     4,     5,     6,     7,     8,    24,    23,
      24,    20,     0,    21,    22,     0,     0,     9,    30,    31,
      32,    33,    34,    35,    10,     0,     0,    37,    38,    39,
      40,    41,    42,    43,     4,     5,     6,     7,     0,     0,
      23,    24,     0,     0,     0,     0,     0,     0,     9,    25,
      26,    27,    28,    29,     0,    10,     0,    36,    23,    24,
       0,    23,    24,     0,     0,     0,     0,    25,    26,    27,
      28,    29,    27,    28,    29,    14,    15,    16,    17,    18,
      19
};

static const yysigned_char yycheck[] =
{
       0,     1,    23,     3,     4,     5,     6,     7,     9,     8,
       9,     7,    -1,     9,    10,    -1,    -1,    17,    14,    15,
      16,    17,    18,    19,    24,    -1,    -1,    23,    24,    25,
      26,    27,    28,    29,     3,     4,     5,     6,    -1,    -1,
       8,     9,    -1,    -1,    -1,    -1,    -1,    -1,    17,    17,
      18,    19,    20,    21,    -1,    24,    -1,    25,     8,     9,
      -1,     8,     9,    -1,    -1,    -1,    -1,    17,    18,    19,
      20,    21,    19,    20,    21,    11,    12,    13,    14,    15,
      16
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,    27,     0,     1,     3,     4,     5,     6,     7,    17,
      24,    28,    29,    23,    11,    12,    13,    14,    15,    16,
      29,    29,    29,     8,     9,    17,    18,    19,    20,    21,
      29,    29,    29,    29,    29,    29,    25,    29,    29,    29,
      29,    29,    29,    29
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 4:
#line 55 "calc.y"
    { (*(yyvsp[0].tptr->value.fnctptr))(0); }
    break;

  case 5:
#line 57 "calc.y"
    {
		char buf[128];
		snprintf(buf, sizeof(buf), "    %.10g\n", yyvsp[0].val);
		uc->mark = MARK_RESULT;
		ucon_puts(uc, buf);
		uc->mark = 0;
	}
    break;

  case 6:
#line 64 "calc.y"
    { yyerrok; }
    break;

  case 7:
#line 67 "calc.y"
    { yyval.val = yyvsp[0].val; }
    break;

  case 8:
#line 68 "calc.y"
    { yyval.val = yyvsp[0].tptr->value.var; }
    break;

  case 9:
#line 70 "calc.y"
    {
		yyval.val = yyvsp[0].val;
		yyvsp[-2].tptr->value.var = yyvsp[0].val;
		yyvsp[-2].tptr->defined = 1;
	}
    break;

  case 10:
#line 75 "calc.y"
    { checkdef(yyvsp[0].tptr); yyval.val = yyvsp[0].tptr->value.var; }
    break;

  case 11:
#line 77 "calc.y"
    {
		checkdef(yyvsp[-2].tptr);
		yyvsp[-2].tptr->value.var += yyvsp[0].val;
		yyvsp[-2].tptr->defined = 1;
		yyval.val = yyvsp[-2].tptr->value.var;
	}
    break;

  case 12:
#line 84 "calc.y"
    {
		checkdef(yyvsp[-2].tptr);
		yyvsp[-2].tptr->value.var -= yyvsp[0].val;
		yyvsp[-2].tptr->defined = 1;
		yyval.val = yyvsp[-2].tptr->value.var;
	}
    break;

  case 13:
#line 91 "calc.y"
    {
		checkdef(yyvsp[-2].tptr);
		yyvsp[-2].tptr->value.var *= yyvsp[0].val;
		yyvsp[-2].tptr->defined = 1;
		yyval.val = yyvsp[-2].tptr->value.var;
	}
    break;

  case 14:
#line 98 "calc.y"
    {
		checkdef(yyvsp[-2].tptr);
		yyvsp[-2].tptr->value.var /= yyvsp[0].val;
		yyvsp[-2].tptr->defined = 1;
		yyval.val = yyvsp[-2].tptr->value.var;
	}
    break;

  case 15:
#line 105 "calc.y"
    {
		checkdef(yyvsp[-2].tptr);
		yyvsp[-2].tptr->value.var = fmod(yyvsp[-2].tptr->value.var, yyvsp[0].val);
		yyvsp[-2].tptr->defined = 1;
		yyval.val = yyvsp[-2].tptr->value.var;
	}
    break;

  case 16:
#line 111 "calc.y"
    { yyval.val = (*(yyvsp[-1].tptr->value.fnctptr))(yyvsp[0].val); }
    break;

  case 17:
#line 112 "calc.y"
    { yyval.val = yyvsp[-2].val + yyvsp[0].val; }
    break;

  case 18:
#line 113 "calc.y"
    { yyval.val = yyvsp[-2].val - yyvsp[0].val; }
    break;

  case 19:
#line 114 "calc.y"
    { yyval.val = yyvsp[-2].val * yyvsp[0].val; }
    break;

  case 20:
#line 115 "calc.y"
    { yyval.val = yyvsp[-2].val / yyvsp[0].val; }
    break;

  case 21:
#line 116 "calc.y"
    { yyval.val = fmod(yyvsp[-2].val, yyvsp[0].val); }
    break;

  case 22:
#line 117 "calc.y"
    { yyval.val = -yyvsp[0].val; }
    break;

  case 23:
#line 118 "calc.y"
    { yyval.val = pow(yyvsp[-2].val, yyvsp[0].val); }
    break;

  case 24:
#line 119 "calc.y"
    { yyval.val = pow(yyvsp[0].val, 1/(yyvsp[-2].val)); }
    break;

  case 25:
#line 120 "calc.y"
    { yyval.val = yyvsp[-1].val; }
    break;


    }

/* Line 999 of yacc.c.  */
#line 1204 "calc.c"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("syntax error, unexpected ") + 1;
	  yysize += yystrlen (yytname[yytype]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (yychar == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (yyss < yyssp)
	    {
	      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
	      yydestruct (yystos[*yyssp], yyvsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
      yydestruct (yytoken, &yylval);
      yychar = YYEMPTY;

    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*----------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      yyvsp--;
      yystate = *--yyssp;

      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 122 "calc.y"
                       
/* End of grammar */

int yyerror(const char *s)	/* Called by yyparse on error */
{
	ucon_puts(uc, s);
	ucon_putc(uc, 10);
	ucon_putc(uc, 10);
	return 0;
}

struct init
{
	const char *fname;
	double (*fnct)(double a);
};

static double cf = 1.0;

double w_sin(double a)
{
	return sin(a * cf);
}

double w_cos(double a)
{
	return cos(a * cf);
}

double w_tan(double a)
{
	return tan(a * cf);
}

double w_asin(double a)
{
	return asin(a) / cf;
}

double w_acos(double a)
{
	return acos(a) / cf;
}

double w_atan(double a)
{
	return atan(a) / cf;
}

#ifndef cbrt
double cbrt(double a)
{
	return pow(a, 1.0L / 3.0L);
}
#endif

double square(double a)
{
	return a * a;
}

double cube(double a)
{
	return a * a * a;
}

struct init arith_fncts[] = {
	{"sin", w_sin},
	{"cos", w_cos},
	{"tan", w_tan},
	{"asin", w_sin},
	{"acos", w_cos},
	{"atan", w_atan},
	{"ln", log},
	{"exp", exp},
	{"sqrt", sqrt},
	{"cbrt", cbrt},
	{"sq", square},
	{"square", square},
	{"cb", cube},
	{"cube", cube},
	{0, 0}
};

/* The symbol table: a chain of `struct symrec'.  */
symrec *sym_table = (symrec *)0;

double use_deg(double a)
{
	uc->mark = MARK_MESSAGE;
	ucon_puts(uc, "    Trig mode: DEG\n");
	uc->mark = 0;
	cf = CALC_PI / 180.0;
	return cf;
}

double use_rad(double a)
{
	uc->mark = MARK_MESSAGE;
	ucon_puts(uc, "    Trig mode: RAD\n");
	uc->mark = 0;
	cf = 1.0;
	return cf;
}


double quit(double a)
{
	uc->mark = MARK_MESSAGE;
	ucon_puts(uc, "    Bye!\n");
	uc->mark = 0;
	result = 1;
	return 0;
}


double help(double a)
{
	uc->mark = MARK_MESSAGE;
	ucon_puts(uc, "\n");
	ucon_puts(uc, " --- SDLCalc - a scientific style infix calculator ---\n");
	ucon_puts(uc, "\n");
	ucon_puts(uc, "    Math operators:             Math Functions:\n");
	ucon_puts(uc, "        = (assignment)              sin (sine)\n");
	ucon_puts(uc, "   +   += (addition)                cos (cosine)\n");
	ucon_puts(uc, "   -   -= (subtraction)             tan (tangent)\n");
	ucon_puts(uc, "   *   *= (multiplication)         asin (arc sine)\n");
	ucon_puts(uc, "   /   /= (division)               acos (arc cosine)\n");
	ucon_puts(uc, "   %   %= (modulus)                atan (arc tangent)\n");
	ucon_puts(uc, "      pow (power)                    ln (n logarithm)\n");
	ucon_puts(uc, "  rt root (x'th root)               exp (e raised)\n");
	ucon_puts(uc, "                                   sqrt (square root)\n");
	ucon_puts(uc, "    Commands:                      cbrt (cube root)\n");
	ucon_puts(uc, "      deg (Switch to DEG)     sq square (square)\n");
	ucon_puts(uc, "      rad (Switch to RAD)     cb   cube (cube)\n");
	ucon_puts(uc, "     quit (Exit SDLCalc)\n");
	ucon_puts(uc, "     help (This page)        Constants:  pi  e\n");
	ucon_puts(uc, "\n");
	uc->mark = 0;
	return 0;
}


symrec *putsym(const char *sym_name, int sym_type)
{
	symrec *ptr;
	ptr = (symrec *)malloc(sizeof(symrec));
	ptr->name = (char *) malloc(strlen(sym_name) + 1);
	strcpy(ptr->name, sym_name);
	ptr->type = sym_type;
	ptr->defined = 0;
	ptr->value.var = 0;
	ptr->next = (struct symrec *)sym_table;
	sym_table = ptr;
	return ptr;
}


symrec *putcmd(const char *name, double (*cb)(double a))
{
	symrec *ptr = putsym(name, CMD);
	ptr->value.fnctptr = cb;
	return ptr;
}


symrec *putconst(const char *name, double v)
{
	symrec *ptr = putsym(name, CONST);
	ptr->value.var = v;
	return ptr;
}


void init_table ()  /* puts arithmetic functions in table. */
{
	int i;
	symrec *ptr;
	for ( i = 0; arith_fncts[i].fname != 0; i++ )
	{
		ptr = putsym(arith_fncts[i].fname, FNCT);
		ptr->value.fnctptr = arith_fncts[i].fnct;
	}
	putcmd("deg", use_deg);
	putcmd("rad", use_rad);
	putcmd("quit", quit);
	putcmd("help", help);

	putsym("pow", POW);
	putsym("rt", ROOT);
	putsym("root", ROOT);

	putconst("pi", CALC_PI);
	putconst("e", CALC_E);
}


symrec *getsym (const char *sym_name)
{
	symrec *ptr;
	for (ptr = sym_table; ptr != (symrec *)0; ptr = (symrec *)ptr->next)
		if (strcmp(ptr->name,sym_name) == 0)
			return ptr;
	return 0;
}


static void checkdef(symrec *sr)
{
	if(!sr->defined)
	{
		char buf[128];
		snprintf(buf, sizeof(buf), "    Variable '%s' is not"
				" defined! (Evaluates to 0.)\n", sr->name);
		ucon_puts(uc, buf);
	}
}


static const char *buf;

int yylex()
{
	int c;

	/* Ignore whitespace, get first nonwhite character. */
	while((c = *buf++) == ' ' || c == '\t')
		;

	if(EOF == c)
		return 0;

	/* Char starts a number => parse the number. */
	if('.' == c || isdigit(c))
	{
		int count;
		--buf;
		if(sscanf(buf, "%lf%n", &yylval.val, &count) > 0)
			buf += count;
		else
		{
			++buf;
			return LEXERR;
		}
		return NUM;
	}

	/* Char starts an identifier => read the name. */
	if(isalpha(c))
	{
		symrec *s;
		static char *symbuf = 0;
		static int length = 0;
		int i;

		/* Initially make the buffer long enough
		   for a 40-character symbol name. */
		if( 0 == length )     
			length = 40, symbuf = (char *)malloc (length + 1);     

		i = 0;
		do
		{
			/* If buffer is full, make it bigger. */
			if( i == length )
			{
				length *= 2;
				symbuf = (char *)realloc (symbuf, length + 1);
			}
			/* Add this character to the buffer. */
			symbuf[i++] = c;
			/* Get another character. */
			c = *buf++;
		}
		while(c != EOF && (isalpha(c) || c == '.' || c == '_'));

		--buf;
		symbuf[i] = '\0';

		s = getsym(symbuf);
		if(!s)
			s = putsym(symbuf, VAR);
		yylval.tptr = s;
		return s->type;
	}

	if('?' == c)
	{
		yylval.tptr = getsym("help");
		return yylval.tptr->type;
	}

	/* Check for compound operators */
	if(*buf && ('=' == *buf))
	{
		++buf;
		switch(c)
		{
		  case '+':
			return INC;
		  case '-':
			return DEC;
		  case '/':
			return DIV;
		  case '*':
			return MUL;
		  case '%':
			return MOD;
		  default:
			--buf;
		}
	}

	/* Any other character is a token by itself. */
	return c;
}



int calc_open(UCON_console *console)
{
	uc = console;
	uc->cx = 0;
	uc->cy = uc->h - 1;
	uc->mark = MARK_MESSAGE;
	ucon_puts(uc,	"\n"
			"Dave's Sensible Infix Calculator\n");
	ucon_puts(uc,	"--------------------------------\n");
	ucon_puts(uc,	"          Version 0.0.1\n\n");
	ucon_puts(uc,	"Initializing...\n");
	init_table();
	ucon_puts(uc,	"    Ready.\n\n");
	uc->mark = 0;
	return 0;
}


int calc_eval(const char *b)
{
	result = 0;
	buf = b;
	yyparse();
	return result;
}


void calc_close(void)
{
}


