#ifndef CLIB_KERNEL_PROTOS_H
#define CLIB_KERNEL_PROTOS_H

/*
    *** Automatically generated from '/data/deadwood/gitAROS/AROS/rom/kernel/kernel.conf'. Edits will be lost. ***
    Copyright  1995-2011, The AROS Development Team. All rights reserved.
*/

#include <aros/libcall.h>

#include <aros/kernel.h>
#include <exec/memory.h>
#include <utility/tagitem.h>

#include <inttypes.h>
#include <stdarg.h>

static inline void __inline_KrnPrintf(APTR __KernelBase, const char *format, ...)
{
    va_list args;

    va_start(args, format);

    AROS_LC2(int, KrnBug,
    	     AROS_LCA(const char *, format, A0),
	     AROS_LCA(va_list, args, A1),
             APTR, __KernelBase, 12, Kernel);

    va_end(args);
}

#define KrnPrintf(...) __inline_KrnPrintf(KernelBase, __VA_ARGS__)


__BEGIN_DECLS

AROS_LP0(KRN_SchedType, KrnGetScheduler,
         LIBBASETYPEPTR, KernelBase, 1, Kernel
);
AROS_LP1(void, KrnSetScheduler,
         AROS_LPA(KRN_SchedType, sched, D0),
         LIBBASETYPEPTR, KernelBase, 2, Kernel
);
AROS_LP0(void, KrnCause,
         LIBBASETYPEPTR, KernelBase, 3, Kernel
);
AROS_LP0(void, KrnDispatch,
         LIBBASETYPEPTR, KernelBase, 4, Kernel
);
AROS_LP0(void, KrnSwitch,
         LIBBASETYPEPTR, KernelBase, 5, Kernel
);
AROS_LP0(void, KrnSchedule,
         LIBBASETYPEPTR, KernelBase, 6, Kernel
);
AROS_LP4(void *, KrnAddIRQHandler,
         AROS_LPA(uint8_t, irq, D0),
         AROS_LPA(void *, handler, A0),
         AROS_LPA(void *, handlerData, A1),
         AROS_LPA(void *, handlerData2, A2),
         LIBBASETYPEPTR, KernelBase, 7, Kernel
);
AROS_LP1(void, KrnRemIRQHandler,
         AROS_LPA(void *, handle, A0),
         LIBBASETYPEPTR, KernelBase, 8, Kernel
);
AROS_LP0(void, KrnCli,
         LIBBASETYPEPTR, KernelBase, 9, Kernel
);
AROS_LP0(void, KrnSti,
         LIBBASETYPEPTR, KernelBase, 10, Kernel
);
AROS_LP0(struct TagItem *, KrnGetBootInfo,
         LIBBASETYPEPTR, KernelBase, 11, Kernel
);
AROS_LP2(int, KrnBug,
         AROS_LPA(const char *, format, A0),
         AROS_LPA(va_list, args, A1),
         LIBBASETYPEPTR, KernelBase, 12, Kernel
);
AROS_LP0(int, KrnIsSuper,
         LIBBASETYPEPTR, KernelBase, 13, Kernel
);
AROS_LP4(void *, KrnAddExceptionHandler,
         AROS_LPA(uint8_t, irq, D0),
         AROS_LPA(void *, handler, A0),
         AROS_LPA(void *, handlerData, A1),
         AROS_LPA(void *, handlerData2, A2),
         LIBBASETYPEPTR, KernelBase, 14, Kernel
);
AROS_LP1(void, KrnRemExceptionHandler,
         AROS_LPA(void *, handle, A0),
         LIBBASETYPEPTR, KernelBase, 15, Kernel
);
AROS_LP4(int, KrnMapGlobal,
         AROS_LPA(void *, virtual, A0),
         AROS_LPA(void *, physical, A1),
         AROS_LPA(uint32_t, length, D0),
         AROS_LPA(KRN_MapAttr, flags, D1),
         LIBBASETYPEPTR, KernelBase, 16, Kernel
);
AROS_LP2(int, KrnUnmapGlobal,
         AROS_LPA(void *, virtual, A0),
         AROS_LPA(uint32_t, length, D0),
         LIBBASETYPEPTR, KernelBase, 17, Kernel
);
AROS_LP0(void *, KrnCreateContext,
         LIBBASETYPEPTR, KernelBase, 18, Kernel
);
AROS_LP1(void, KrnDeleteContext,
         AROS_LPA(void *, context, A0),
         LIBBASETYPEPTR, KernelBase, 19, Kernel
);
AROS_LP1(void *, KrnVirtualToPhysical,
         AROS_LPA(void *, virt, A0),
         LIBBASETYPEPTR, KernelBase, 20, Kernel
);
AROS_LP3(void, KrnSetProtection,
         AROS_LPA(void *, address, A0),
         AROS_LPA(uint32_t, length, D0),
         AROS_LPA(KRN_MapAttr, flags, D1),
         LIBBASETYPEPTR, KernelBase, 21, Kernel
);
AROS_LP1(void, KrnPutChar,
         AROS_LPA(char, c, D0),
         LIBBASETYPEPTR, KernelBase, 25, Kernel
);
AROS_LP0(int, KrnMayGetChar,
         LIBBASETYPEPTR, KernelBase, 26, Kernel
);
AROS_LP3(void *, KrnAllocPages,
         AROS_LPA(void *, addr, A0),
         AROS_LPA(uintptr_t, length, D0),
         AROS_LPA(uint32_t, flags, D1),
         LIBBASETYPEPTR, KernelBase, 27, Kernel
);
AROS_LP2(void, KrnFreePages,
         AROS_LPA(void *, phy_addr, A0),
         AROS_LPA(uintptr_t, length, D0),
         LIBBASETYPEPTR, KernelBase, 28, Kernel
);
AROS_LP1(intptr_t, KrnGetSystemAttr,
         AROS_LPA(uint32_t, id, D0),
         LIBBASETYPEPTR, KernelBase, 29, Kernel
);
AROS_LP2(int, KrnSetSystemAttr,
         AROS_LPA(uint32_t, id, D0),
         AROS_LPA(intptr_t, val, D1),
         LIBBASETYPEPTR, KernelBase, 30, Kernel
);
AROS_LP1(void, KrnInitMemory,
         AROS_LPA(struct MemHeader *, mh, A0),
         LIBBASETYPEPTR, KernelBase, 31, Kernel
);
AROS_LP2(ULONG, KrnStatMemoryA,
         AROS_LPA(uint32_t, flags, D0),
         AROS_LPA(struct TagItem *, query, A0),
         LIBBASETYPEPTR, KernelBase, 32, Kernel
);
AROS_LP0(int, KrnObtainInput,
         LIBBASETYPEPTR, KernelBase, 33, Kernel
);
AROS_LP0(void, KrnReleaseInput,
         LIBBASETYPEPTR, KernelBase, 34, Kernel
);

__END_DECLS

#endif /* CLIB_KERNEL_PROTOS_H */
