/*
 * E-UAE - The portable Amiga emulator.
 *
 * This file was generated by genlinetoscr. Don't edit.
 */

static int NOINLINE linetoscr_8 (int spix, int dpix, int stoppos)
{
    uae_u8 *buf = (uae_u8 *) xlinebuffer;

    if (dp_for_drawing->ham_seen) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            dpix_val = xcolors[ham_linebuf[spix]];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE linetoscr_8_stretch1 (int spix, int dpix, int stoppos)
{
    uae_u8 *buf = (uae_u8 *) xlinebuffer;

    if (dp_for_drawing->ham_seen) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            dpix_val = xcolors[ham_linebuf[spix]];
            spix++;
            out_val = dpix_val;
            *((uae_u16 *)&buf[dpix]) = (uae_u16) out_val;
            dpix += 2;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            *((uae_u16 *)&buf[dpix]) = (uae_u16) out_val;
            dpix += 2;
        }
    } else if (bplehb) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            *((uae_u16 *)&buf[dpix]) = (uae_u16) out_val;
            dpix += 2;
        }
    } else {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            *((uae_u16 *)&buf[dpix]) = (uae_u16) out_val;
            dpix += 2;
        }
    }

    return spix;
}

static int NOINLINE linetoscr_8_shrink1 (int spix, int dpix, int stoppos)
{
    uae_u8 *buf = (uae_u8 *) xlinebuffer;

    if (dp_for_drawing->ham_seen) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            dpix_val = xcolors[ham_linebuf[spix]];
            spix += 2;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 2;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 2;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE linetoscr_8_shrink2 (int spix, int dpix, int stoppos)
{
    uae_u8 *buf = (uae_u8 *) xlinebuffer;

    if (dp_for_drawing->ham_seen) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
            uae_u32 tmp_val;
        
            dpix_val = xcolors[ham_linebuf[spix]];
            spix++;
            tmp_val = dpix_val;
            dpix_val = xcolors[ham_linebuf[spix]];
            dpix_val = merge_2pixel8 (dpix_val, tmp_val);
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
            uae_u32 tmp_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            dpix_val = merge_2pixel8 (dpix_val, tmp_val);
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
            uae_u32 tmp_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            dpix_val = merge_2pixel8 (dpix_val, tmp_val);
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
            uae_u32 tmp_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel8 (dpix_val, tmp_val);
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

#ifdef AGA
static int NOINLINE linetoscr_8_aga (int spix, int dpix, int stoppos)
{
    uae_u8 *buf = (uae_u8 *) xlinebuffer;
    uae_u8 xor_val = (uae_u8)(dp_for_drawing->bplcon4 >> 8);

    if (dp_for_drawing->ham_seen) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = CONVERT_RGB (ham_linebuf[spix]);
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spriteagadpfpixels[spix]) {
                dpix_val = colors_for_drawing.acolors[spriteagadpfpixels[spix]];
                spriteagadpfpixels[spix] = 0;
            } else {
                unsigned int val = lookup[spix_val];
                if (lookup_no[spix_val] == 2)
                    val += dblpfofs[bpldualpf2of];
        	 val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE linetoscr_8_stretch1_aga (int spix, int dpix, int stoppos)
{
    uae_u8 *buf = (uae_u8 *) xlinebuffer;
    uae_u8 xor_val = (uae_u8)(dp_for_drawing->bplcon4 >> 8);

    if (dp_for_drawing->ham_seen) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = CONVERT_RGB (ham_linebuf[spix]);
            spix++;
            out_val = dpix_val;
            *((uae_u16 *)&buf[dpix]) = (uae_u16) out_val;
            dpix += 2;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spriteagadpfpixels[spix]) {
                dpix_val = colors_for_drawing.acolors[spriteagadpfpixels[spix]];
                spriteagadpfpixels[spix] = 0;
            } else {
                unsigned int val = lookup[spix_val];
                if (lookup_no[spix_val] == 2)
                    val += dblpfofs[bpldualpf2of];
        	 val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            *((uae_u16 *)&buf[dpix]) = (uae_u16) out_val;
            dpix += 2;
        }
    } else if (bplehb) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            *((uae_u16 *)&buf[dpix]) = (uae_u16) out_val;
            dpix += 2;
        }
    } else {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            *((uae_u16 *)&buf[dpix]) = (uae_u16) out_val;
            dpix += 2;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE linetoscr_8_shrink1_aga (int spix, int dpix, int stoppos)
{
    uae_u8 *buf = (uae_u8 *) xlinebuffer;
    uae_u8 xor_val = (uae_u8)(dp_for_drawing->bplcon4 >> 8);

    if (dp_for_drawing->ham_seen) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = CONVERT_RGB (ham_linebuf[spix]);
            spix += 2;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spriteagadpfpixels[spix]) {
                dpix_val = colors_for_drawing.acolors[spriteagadpfpixels[spix]];
                spriteagadpfpixels[spix] = 0;
            } else {
                unsigned int val = lookup[spix_val];
                if (lookup_no[spix_val] == 2)
                    val += dblpfofs[bpldualpf2of];
        	 val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 2;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE linetoscr_8_shrink2_aga (int spix, int dpix, int stoppos)
{
    uae_u8 *buf = (uae_u8 *) xlinebuffer;
    uae_u8 xor_val = (uae_u8)(dp_for_drawing->bplcon4 >> 8);

    if (dp_for_drawing->ham_seen) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
            uae_u32 tmp_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = CONVERT_RGB (ham_linebuf[spix]);
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = CONVERT_RGB (ham_linebuf[spix]);
            dpix_val = merge_2pixel8 (dpix_val, tmp_val);
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
            uae_u32 tmp_val;
        
            spix_val = pixdata.apixels[spix];
            if (spriteagadpfpixels[spix]) {
                dpix_val = colors_for_drawing.acolors[spriteagadpfpixels[spix]];
                spriteagadpfpixels[spix] = 0;
            } else {
                unsigned int val = lookup[spix_val];
                if (lookup_no[spix_val] == 2)
                    val += dblpfofs[bpldualpf2of];
        	 val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spriteagadpfpixels[spix]) {
                dpix_val = colors_for_drawing.acolors[spriteagadpfpixels[spix]];
                spriteagadpfpixels[spix] = 0;
            } else {
                unsigned int val = lookup[spix_val];
                if (lookup_no[spix_val] == 2)
                    val += dblpfofs[bpldualpf2of];
        	 val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            dpix_val = merge_2pixel8 (dpix_val, tmp_val);
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
            uae_u32 tmp_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel8 (dpix_val, tmp_val);
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
            uae_u32 tmp_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel8 (dpix_val, tmp_val);
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

static int NOINLINE linetoscr_16 (int spix, int dpix, int stoppos)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;

    if (dp_for_drawing->ham_seen) {
        int rem;
        if (((long)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            dpix_val = xcolors[ham_linebuf[spix]];
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= stoppos)
            return spix;
        rem = (((long)&buf[stoppos]) & 2);
        if (rem)
            stoppos--;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            dpix_val = xcolors[ham_linebuf[spix]];
            spix++;
            out_val = dpix_val;
            dpix_val = xcolors[ham_linebuf[spix]];
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            dpix_val = xcolors[ham_linebuf[spix]];
            spix++;
            buf[dpix++] = dpix_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        int rem;
        if (((long)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= stoppos)
            return spix;
        rem = (((long)&buf[stoppos]) & 2);
        if (rem)
            stoppos--;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            buf[dpix++] = dpix_val;
        }
    } else if (bplehb) {
        int rem;
        if (((long)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= stoppos)
            return spix;
        rem = (((long)&buf[stoppos]) & 2);
        if (rem)
            stoppos--;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            buf[dpix++] = dpix_val;
        }
    } else {
        int rem;
        if (((long)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= stoppos)
            return spix;
        rem = (((long)&buf[stoppos]) & 2);
        if (rem)
            stoppos--;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            buf[dpix++] = dpix_val;
        }
    }

    return spix;
}

static int NOINLINE linetoscr_16_stretch1 (int spix, int dpix, int stoppos)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;

    if (dp_for_drawing->ham_seen) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            dpix_val = xcolors[ham_linebuf[spix]];
            spix++;
            out_val = dpix_val;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else if (bplehb) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    }

    return spix;
}

static int NOINLINE linetoscr_16_shrink1 (int spix, int dpix, int stoppos)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;

    if (dp_for_drawing->ham_seen) {
        int rem;
        if (((long)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            dpix_val = xcolors[ham_linebuf[spix]];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= stoppos)
            return spix;
        rem = (((long)&buf[stoppos]) & 2);
        if (rem)
            stoppos--;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            dpix_val = xcolors[ham_linebuf[spix]];
            spix += 2;
            out_val = dpix_val;
            dpix_val = xcolors[ham_linebuf[spix]];
            spix += 2;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            dpix_val = xcolors[ham_linebuf[spix]];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        int rem;
        if (((long)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= stoppos)
            return spix;
        rem = (((long)&buf[stoppos]) & 2);
        if (rem)
            stoppos--;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 2;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 2;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
    } else if (bplehb) {
        int rem;
        if (((long)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= stoppos)
            return spix;
        rem = (((long)&buf[stoppos]) & 2);
        if (rem)
            stoppos--;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 2;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 2;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
    } else {
        int rem;
        if (((long)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= stoppos)
            return spix;
        rem = (((long)&buf[stoppos]) & 2);
        if (rem)
            stoppos--;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
    }

    return spix;
}

static int NOINLINE linetoscr_16_shrink2 (int spix, int dpix, int stoppos)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;

    if (dp_for_drawing->ham_seen) {
        int rem;
        if (((long)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 tmp_val;
            dpix_val = xcolors[ham_linebuf[spix]];
            spix++;
            tmp_val = dpix_val;
            dpix_val = xcolors[ham_linebuf[spix]];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= stoppos)
            return spix;
        rem = (((long)&buf[stoppos]) & 2);
        if (rem)
            stoppos--;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
            uae_u32 tmp_val;
        
            dpix_val = xcolors[ham_linebuf[spix]];
            spix++;
            tmp_val = dpix_val;
            dpix_val = xcolors[ham_linebuf[spix]];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            out_val = dpix_val;
            dpix_val = xcolors[ham_linebuf[spix]];
            spix++;
            tmp_val = dpix_val;
            dpix_val = xcolors[ham_linebuf[spix]];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 tmp_val;
            dpix_val = xcolors[ham_linebuf[spix]];
            spix++;
            tmp_val = dpix_val;
            dpix_val = xcolors[ham_linebuf[spix]];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            buf[dpix++] = dpix_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        int rem;
        if (((long)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 tmp_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= stoppos)
            return spix;
        rem = (((long)&buf[stoppos]) & 2);
        if (rem)
            stoppos--;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
            uae_u32 tmp_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 tmp_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            buf[dpix++] = dpix_val;
        }
    } else if (bplehb) {
        int rem;
        if (((long)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 tmp_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= stoppos)
            return spix;
        rem = (((long)&buf[stoppos]) & 2);
        if (rem)
            stoppos--;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
            uae_u32 tmp_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 tmp_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            buf[dpix++] = dpix_val;
        }
    } else {
        int rem;
        if (((long)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 tmp_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= stoppos)
            return spix;
        rem = (((long)&buf[stoppos]) & 2);
        if (rem)
            stoppos--;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
            uae_u32 tmp_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 tmp_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            buf[dpix++] = dpix_val;
        }
    }

    return spix;
}

#ifdef AGA
static int NOINLINE linetoscr_16_aga (int spix, int dpix, int stoppos)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 xor_val = (uae_u8)(dp_for_drawing->bplcon4 >> 8);

    if (dp_for_drawing->ham_seen) {
        int rem;
        if (((long)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = CONVERT_RGB (ham_linebuf[spix]);
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= stoppos)
            return spix;
        rem = (((long)&buf[stoppos]) & 2);
        if (rem)
            stoppos--;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = CONVERT_RGB (ham_linebuf[spix]);
            spix++;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = CONVERT_RGB (ham_linebuf[spix]);
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = CONVERT_RGB (ham_linebuf[spix]);
            spix++;
            buf[dpix++] = dpix_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        int rem;
        if (((long)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spriteagadpfpixels[spix]) {
                dpix_val = colors_for_drawing.acolors[spriteagadpfpixels[spix]];
                spriteagadpfpixels[spix] = 0;
            } else {
                unsigned int val = lookup[spix_val];
                if (lookup_no[spix_val] == 2)
                    val += dblpfofs[bpldualpf2of];
        	 val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= stoppos)
            return spix;
        rem = (((long)&buf[stoppos]) & 2);
        if (rem)
            stoppos--;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spriteagadpfpixels[spix]) {
                dpix_val = colors_for_drawing.acolors[spriteagadpfpixels[spix]];
                spriteagadpfpixels[spix] = 0;
            } else {
                unsigned int val = lookup[spix_val];
                if (lookup_no[spix_val] == 2)
                    val += dblpfofs[bpldualpf2of];
        	 val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spriteagadpfpixels[spix]) {
                dpix_val = colors_for_drawing.acolors[spriteagadpfpixels[spix]];
                spriteagadpfpixels[spix] = 0;
            } else {
                unsigned int val = lookup[spix_val];
                if (lookup_no[spix_val] == 2)
                    val += dblpfofs[bpldualpf2of];
        	 val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spriteagadpfpixels[spix]) {
                dpix_val = colors_for_drawing.acolors[spriteagadpfpixels[spix]];
                spriteagadpfpixels[spix] = 0;
            } else {
                unsigned int val = lookup[spix_val];
                if (lookup_no[spix_val] == 2)
                    val += dblpfofs[bpldualpf2of];
        	 val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            buf[dpix++] = dpix_val;
        }
    } else if (bplehb) {
        int rem;
        if (((long)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= stoppos)
            return spix;
        rem = (((long)&buf[stoppos]) & 2);
        if (rem)
            stoppos--;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            buf[dpix++] = dpix_val;
        }
    } else {
        int rem;
        if (((long)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= stoppos)
            return spix;
        rem = (((long)&buf[stoppos]) & 2);
        if (rem)
            stoppos--;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            buf[dpix++] = dpix_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE linetoscr_16_stretch1_aga (int spix, int dpix, int stoppos)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 xor_val = (uae_u8)(dp_for_drawing->bplcon4 >> 8);

    if (dp_for_drawing->ham_seen) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = CONVERT_RGB (ham_linebuf[spix]);
            spix++;
            out_val = dpix_val;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spriteagadpfpixels[spix]) {
                dpix_val = colors_for_drawing.acolors[spriteagadpfpixels[spix]];
                spriteagadpfpixels[spix] = 0;
            } else {
                unsigned int val = lookup[spix_val];
                if (lookup_no[spix_val] == 2)
                    val += dblpfofs[bpldualpf2of];
        	 val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else if (bplehb) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE linetoscr_16_shrink1_aga (int spix, int dpix, int stoppos)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 xor_val = (uae_u8)(dp_for_drawing->bplcon4 >> 8);

    if (dp_for_drawing->ham_seen) {
        int rem;
        if (((long)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = CONVERT_RGB (ham_linebuf[spix]);
            spix += 2;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= stoppos)
            return spix;
        rem = (((long)&buf[stoppos]) & 2);
        if (rem)
            stoppos--;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = CONVERT_RGB (ham_linebuf[spix]);
            spix += 2;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = CONVERT_RGB (ham_linebuf[spix]);
            spix += 2;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = CONVERT_RGB (ham_linebuf[spix]);
            spix += 2;
            buf[dpix++] = dpix_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        int rem;
        if (((long)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spriteagadpfpixels[spix]) {
                dpix_val = colors_for_drawing.acolors[spriteagadpfpixels[spix]];
                spriteagadpfpixels[spix] = 0;
            } else {
                unsigned int val = lookup[spix_val];
                if (lookup_no[spix_val] == 2)
                    val += dblpfofs[bpldualpf2of];
        	 val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 2;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= stoppos)
            return spix;
        rem = (((long)&buf[stoppos]) & 2);
        if (rem)
            stoppos--;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spriteagadpfpixels[spix]) {
                dpix_val = colors_for_drawing.acolors[spriteagadpfpixels[spix]];
                spriteagadpfpixels[spix] = 0;
            } else {
                unsigned int val = lookup[spix_val];
                if (lookup_no[spix_val] == 2)
                    val += dblpfofs[bpldualpf2of];
        	 val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 2;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spriteagadpfpixels[spix]) {
                dpix_val = colors_for_drawing.acolors[spriteagadpfpixels[spix]];
                spriteagadpfpixels[spix] = 0;
            } else {
                unsigned int val = lookup[spix_val];
                if (lookup_no[spix_val] == 2)
                    val += dblpfofs[bpldualpf2of];
        	 val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 2;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spriteagadpfpixels[spix]) {
                dpix_val = colors_for_drawing.acolors[spriteagadpfpixels[spix]];
                spriteagadpfpixels[spix] = 0;
            } else {
                unsigned int val = lookup[spix_val];
                if (lookup_no[spix_val] == 2)
                    val += dblpfofs[bpldualpf2of];
        	 val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 2;
            buf[dpix++] = dpix_val;
        }
    } else if (bplehb) {
        int rem;
        if (((long)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= stoppos)
            return spix;
        rem = (((long)&buf[stoppos]) & 2);
        if (rem)
            stoppos--;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
    } else {
        int rem;
        if (((long)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= stoppos)
            return spix;
        rem = (((long)&buf[stoppos]) & 2);
        if (rem)
            stoppos--;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE linetoscr_16_shrink2_aga (int spix, int dpix, int stoppos)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 xor_val = (uae_u8)(dp_for_drawing->bplcon4 >> 8);

    if (dp_for_drawing->ham_seen) {
        int rem;
        if (((long)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 tmp_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = CONVERT_RGB (ham_linebuf[spix]);
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = CONVERT_RGB (ham_linebuf[spix]);
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= stoppos)
            return spix;
        rem = (((long)&buf[stoppos]) & 2);
        if (rem)
            stoppos--;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
            uae_u32 tmp_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = CONVERT_RGB (ham_linebuf[spix]);
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = CONVERT_RGB (ham_linebuf[spix]);
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = CONVERT_RGB (ham_linebuf[spix]);
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = CONVERT_RGB (ham_linebuf[spix]);
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 tmp_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = CONVERT_RGB (ham_linebuf[spix]);
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = CONVERT_RGB (ham_linebuf[spix]);
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            buf[dpix++] = dpix_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        int rem;
        if (((long)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 tmp_val;
            spix_val = pixdata.apixels[spix];
            if (spriteagadpfpixels[spix]) {
                dpix_val = colors_for_drawing.acolors[spriteagadpfpixels[spix]];
                spriteagadpfpixels[spix] = 0;
            } else {
                unsigned int val = lookup[spix_val];
                if (lookup_no[spix_val] == 2)
                    val += dblpfofs[bpldualpf2of];
        	 val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spriteagadpfpixels[spix]) {
                dpix_val = colors_for_drawing.acolors[spriteagadpfpixels[spix]];
                spriteagadpfpixels[spix] = 0;
            } else {
                unsigned int val = lookup[spix_val];
                if (lookup_no[spix_val] == 2)
                    val += dblpfofs[bpldualpf2of];
        	 val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= stoppos)
            return spix;
        rem = (((long)&buf[stoppos]) & 2);
        if (rem)
            stoppos--;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
            uae_u32 tmp_val;
        
            spix_val = pixdata.apixels[spix];
            if (spriteagadpfpixels[spix]) {
                dpix_val = colors_for_drawing.acolors[spriteagadpfpixels[spix]];
                spriteagadpfpixels[spix] = 0;
            } else {
                unsigned int val = lookup[spix_val];
                if (lookup_no[spix_val] == 2)
                    val += dblpfofs[bpldualpf2of];
        	 val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spriteagadpfpixels[spix]) {
                dpix_val = colors_for_drawing.acolors[spriteagadpfpixels[spix]];
                spriteagadpfpixels[spix] = 0;
            } else {
                unsigned int val = lookup[spix_val];
                if (lookup_no[spix_val] == 2)
                    val += dblpfofs[bpldualpf2of];
        	 val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spriteagadpfpixels[spix]) {
                dpix_val = colors_for_drawing.acolors[spriteagadpfpixels[spix]];
                spriteagadpfpixels[spix] = 0;
            } else {
                unsigned int val = lookup[spix_val];
                if (lookup_no[spix_val] == 2)
                    val += dblpfofs[bpldualpf2of];
        	 val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spriteagadpfpixels[spix]) {
                dpix_val = colors_for_drawing.acolors[spriteagadpfpixels[spix]];
                spriteagadpfpixels[spix] = 0;
            } else {
                unsigned int val = lookup[spix_val];
                if (lookup_no[spix_val] == 2)
                    val += dblpfofs[bpldualpf2of];
        	 val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 tmp_val;
            spix_val = pixdata.apixels[spix];
            if (spriteagadpfpixels[spix]) {
                dpix_val = colors_for_drawing.acolors[spriteagadpfpixels[spix]];
                spriteagadpfpixels[spix] = 0;
            } else {
                unsigned int val = lookup[spix_val];
                if (lookup_no[spix_val] == 2)
                    val += dblpfofs[bpldualpf2of];
        	 val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spriteagadpfpixels[spix]) {
                dpix_val = colors_for_drawing.acolors[spriteagadpfpixels[spix]];
                spriteagadpfpixels[spix] = 0;
            } else {
                unsigned int val = lookup[spix_val];
                if (lookup_no[spix_val] == 2)
                    val += dblpfofs[bpldualpf2of];
        	 val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            buf[dpix++] = dpix_val;
        }
    } else if (bplehb) {
        int rem;
        if (((long)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 tmp_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= stoppos)
            return spix;
        rem = (((long)&buf[stoppos]) & 2);
        if (rem)
            stoppos--;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
            uae_u32 tmp_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 tmp_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            buf[dpix++] = dpix_val;
        }
    } else {
        int rem;
        if (((long)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 tmp_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= stoppos)
            return spix;
        rem = (((long)&buf[stoppos]) & 2);
        if (rem)
            stoppos--;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
            uae_u32 tmp_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 tmp_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            buf[dpix++] = dpix_val;
        }
    }

    return spix;
}
#endif

static int NOINLINE linetoscr_32 (int spix, int dpix, int stoppos)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;

    if (dp_for_drawing->ham_seen) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            dpix_val = xcolors[ham_linebuf[spix]];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE linetoscr_32_stretch1 (int spix, int dpix, int stoppos)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;

    if (dp_for_drawing->ham_seen) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            dpix_val = xcolors[ham_linebuf[spix]];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE linetoscr_32_shrink1 (int spix, int dpix, int stoppos)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;

    if (dp_for_drawing->ham_seen) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            dpix_val = xcolors[ham_linebuf[spix]];
            spix += 2;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 2;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 2;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE linetoscr_32_shrink2 (int spix, int dpix, int stoppos)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;

    if (dp_for_drawing->ham_seen) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
            uae_u32 tmp_val;
        
            dpix_val = xcolors[ham_linebuf[spix]];
            spix++;
            tmp_val = dpix_val;
            dpix_val = xcolors[ham_linebuf[spix]];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
            uae_u32 tmp_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
            uae_u32 tmp_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
            uae_u32 tmp_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

#ifdef AGA
static int NOINLINE linetoscr_32_aga (int spix, int dpix, int stoppos)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 xor_val = (uae_u8)(dp_for_drawing->bplcon4 >> 8);

    if (dp_for_drawing->ham_seen) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = CONVERT_RGB (ham_linebuf[spix]);
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spriteagadpfpixels[spix]) {
                dpix_val = colors_for_drawing.acolors[spriteagadpfpixels[spix]];
                spriteagadpfpixels[spix] = 0;
            } else {
                unsigned int val = lookup[spix_val];
                if (lookup_no[spix_val] == 2)
                    val += dblpfofs[bpldualpf2of];
        	 val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE linetoscr_32_stretch1_aga (int spix, int dpix, int stoppos)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 xor_val = (uae_u8)(dp_for_drawing->bplcon4 >> 8);

    if (dp_for_drawing->ham_seen) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = CONVERT_RGB (ham_linebuf[spix]);
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spriteagadpfpixels[spix]) {
                dpix_val = colors_for_drawing.acolors[spriteagadpfpixels[spix]];
                spriteagadpfpixels[spix] = 0;
            } else {
                unsigned int val = lookup[spix_val];
                if (lookup_no[spix_val] == 2)
                    val += dblpfofs[bpldualpf2of];
        	 val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE linetoscr_32_shrink1_aga (int spix, int dpix, int stoppos)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 xor_val = (uae_u8)(dp_for_drawing->bplcon4 >> 8);

    if (dp_for_drawing->ham_seen) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = CONVERT_RGB (ham_linebuf[spix]);
            spix += 2;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spriteagadpfpixels[spix]) {
                dpix_val = colors_for_drawing.acolors[spriteagadpfpixels[spix]];
                spriteagadpfpixels[spix] = 0;
            } else {
                unsigned int val = lookup[spix_val];
                if (lookup_no[spix_val] == 2)
                    val += dblpfofs[bpldualpf2of];
        	 val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 2;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE linetoscr_32_shrink2_aga (int spix, int dpix, int stoppos)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 xor_val = (uae_u8)(dp_for_drawing->bplcon4 >> 8);

    if (dp_for_drawing->ham_seen) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
            uae_u32 tmp_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = CONVERT_RGB (ham_linebuf[spix]);
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = CONVERT_RGB (ham_linebuf[spix]);
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
            uae_u32 tmp_val;
        
            spix_val = pixdata.apixels[spix];
            if (spriteagadpfpixels[spix]) {
                dpix_val = colors_for_drawing.acolors[spriteagadpfpixels[spix]];
                spriteagadpfpixels[spix] = 0;
            } else {
                unsigned int val = lookup[spix_val];
                if (lookup_no[spix_val] == 2)
                    val += dblpfofs[bpldualpf2of];
        	 val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spriteagadpfpixels[spix]) {
                dpix_val = colors_for_drawing.acolors[spriteagadpfpixels[spix]];
                spriteagadpfpixels[spix] = 0;
            } else {
                unsigned int val = lookup[spix_val];
                if (lookup_no[spix_val] == 2)
                    val += dblpfofs[bpldualpf2of];
        	 val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
            uae_u32 tmp_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < stoppos) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
            uae_u32 tmp_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

