/*
 * Decompiled with CFR 0.152.
 */
package jamal;

import jamal.AbkViewer;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class AbkFile {
    AbkViewer parent;
    File file;
    String filename;
    int bufferposition;
    FileInputStream in;

    AbkFile(AbkViewer par, String arg) {
        this.filename = arg;
        this.parent = par;
        this.init();
    }

    AbkFile(AbkViewer par) {
        this.filename = "";
        this.parent = par;
        this.init();
    }

    void init() {
    }

    String[] selectfile_native(String fname) {
        boolean usefilereq = false;
        if (fname == null) {
            usefilereq = true;
        } else if (fname.equals("")) {
            usefilereq = true;
        }
        if (!usefilereq) {
            File file = new File(fname);
            return new String[]{file.getAbsolutePath(), file.getName()};
        }
        FileDialog fd = new FileDialog(new Frame(), "Load an .abk Sprite or Icon file", 0);
        fd.setFile("Sprites.Abk");
        fd.setDirectory(".");
        fd.setLocation(50, 50);
        fd.setVisible(true);
        this.filename = fd.getFile();
        return new String[]{String.valueOf(fd.getDirectory()) + "/" + fd.getFile(), fd.getFile()};
    }

    FileInputStream openbinaryfile(String filename) {
        FileInputStream in = null;
        this.file = null;
        try {
            this.file = new File(filename);
            in = new FileInputStream(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return in;
    }

    void closebinaryfile(FileInputStream file) {
        try {
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    int getnextbyte() {
        byte b = 0;
        try {
            if (this.bufferposition < this.parent.filebuffer.length) {
                b = this.parent.filebuffer[this.bufferposition];
                ++this.bufferposition;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return AbkFile.unsignedByteToInt(b);
    }

    int getnextword() {
        int w = 0;
        try {
            w = this.getnextbyte() << 8;
            w |= this.getnextbyte();
            this.bufferposition += 2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return w;
    }

    byte getnextbyte_file() {
        byte b = 0;
        try {
            b = (byte)this.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return b;
    }

    public byte[] loadfiletobuffer(String filename) {
        this.file = new File(filename);
        this.in = this.openbinaryfile(filename);
        if (this.in == null) {
            return null;
        }
        int filesize = (int)this.file.length();
        byte[] ret = new byte[filesize];
        try {
            this.in.read(ret);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.closebinaryfile(this.in);
        return ret;
    }

    public static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }
}

