/*  Grafx2 - The Ultimate 256-color bitmap paint program

    Copyright 2008 Yves Rizoud
    Copyright 1996-2001 Sunset Design (Guillaume Dorme & Karl Maritaud)

    Grafx2 is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; version 2
    of the License.

    Grafx2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Grafx2; if not, see <http://www.gnu.org/licenses/> or
    write to the Free Software Foundation, Inc.,
    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
// Les tables suivantes servent de table de conversion entre un caractre ASCII
// et le sprite qui le reprsente dans la Fonte

// Table de caractres Normaux
static const int Caracteres_Aide_N[] = { // Commence  ' '
    0,     1,     2,     3,     4,     5,     6,     7,     8,     9,
   10,    11,    12,    13,    14,    15,    16,    17,    18,    19,
   20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
   30,    31,    32,    33,    34,    35,    36,    37,    38,    39,
   40,    41,    42,    43,    44,    45,    46,    47,    48,    49,
   50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
   60,    61,     0,    62,    63,    64,    65,    66,    67,    68,
   69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
   79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
   89,    90,    91,    92,     0,     0,    93,    94,    95,    96,
    0,    97,     0,    98,    99,   100,   101,     0,     0,     0,
    0,     0,     0,   102,     0,   103,     0,     0,   104,   105};



// Table de caractres Sous-Titres
static const int Caracteres_Aide_S[] = { // Commence  ' '
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,   132,   133,   134,   135,   136,   137,   138,
  139,   140,   141,   142,   143,   144,   145,     0,     0,     0,
    0,   146,     0,   106,   107,   108,   109,   110,   111,   112,
  113,   114,   115,   116,   117,   118,   119,   120,   121,   122,
  123,   124,   125,   126,   127,   128,   129,   130,   131 };
  // Table de caractres Titres (demi-ligne suprieure)
static const int Caracteres_Aide_Titre_haut[] = { // Commence  ' '
  126+147,
  126+147,
  126+147,
  126+147,
  126+147,
  126+147,
  126+147,
  126+147,
  126+147,
  126+147,
  126+147,
  126+147,
  126+147,
   96+147, // -
   98+147, // .
  100+147, // /
  102+147, // 0
  104+147, // 1
  106+147, // 2
  108+147, // 3
  110+147, // 4
  112+147, // 5
  114+147, // 6
  116+147, // 7
  118+147, // 8
  120+147, // 9
  122+147, // :
  126+147,
  126+147,
  126+147,
  126+147,
  124+147,  // ?// ?
  126+147,
    0+147, // A
    2+147, // B
    4+147, // C
    6+147, // D
    8+147, // E
   10+147, // F
   12+147, // G
   14+147, // H
   16+147, // I
   18+147, // J
   20+147, // K
   22+147, // L
   24+147, // M
   26+147, // N
   28+147, // O
   30+147, // P
   32+147, // Q
   34+147, // R
   36+147, // S
   38+147, // T
   40+147, // U
   42+147, // V
   88+147, // W
   90+147, // X
   92+147, // Y
   94+147  // Z
};
  // Table de caractres Titres (demi-ligne suprieure)
static const int Caracteres_Aide_Titre_bas[] = { // Commence  ' '
  126+147+40,
  126+147+40,
  126+147+40,
  126+147+40,
  126+147+40,
  126+147+40,
  126+147+40,
  126+147+40,
  126+147+40,
  126+147+40,
  126+147+40,
  126+147+40,
  126+147+40,
   96+147+40, // -
   98+147+40, // .
  100+147+40, // /
  102+147+40, // 0
  104+147+40, // 1
  106+147+40, // 2
  108+147+40, // 3
  110+147+40, // 4
  112+147+40, // 5
  114+147+40, // 6
  116+147+40, // 7
  118+147+40, // 8
  120+147+40, // 9
  122+147+40, // :
  126+147+40,
  126+147+40,
  126+147+40,
  126+147+40,
  124+147+40, // ?
  126+147+40,
    0+147+44, // A
    2+147+44, // B
    4+147+44, // C
    6+147+44, // D
    8+147+44, // E
   10+147+44, // F
   12+147+44, // G
   14+147+44, // H
   16+147+44, // I
   18+147+44, // J
   20+147+44, // K
   22+147+44, // L
   24+147+44, // M
   26+147+44, // N
   28+147+44, // O
   30+147+44, // P
   32+147+44, // Q
   34+147+44, // R
   36+147+44, // S
   38+147+44, // T
   40+147+44, // U
   42+147+44, // V
   88+147+40, // W
   90+147+40, // X
   92+147+40, // Y
   94+147+40  // Z
};

// Quelques formules magiques:
#define AIDE_TEXTE(x) "N" x,
// Gnre une ligne "Ntexte",

#define AIDE_BOLD(x) "S" x,
// Gnre une ligne "Stexte",

#define AIDE_TITRE(x) "T" x, "-",
// Gnre une ligne "Ttexte",
// et une deuxime  "-",
// (pour grer les gros titres qui occupent deux lignes)

static const char * TableAideAbout[] =
/*
  AIDE_TEXTE("--------------------------------------------")
*/
{
  AIDE_TEXTE("") // Laisse de la place pour le logo
  AIDE_TEXTE("")
  AIDE_TEXTE("")
  AIDE_TEXTE("")
  AIDE_TEXTE("")
  AIDE_TEXTE("")
  AIDE_TITRE("      GRAFX 2.00")
  AIDE_BOLD ("  THE ULTIMATE MULTI-RESOLUTION GFX EDITOR")
  AIDE_TEXTE("       http://grafx2.googlecode.com")
  AIDE_TEXTE("")
  AIDE_TEXTE("  Copyright 2007 by the Grafx2 project team")
  AIDE_TEXTE("    Copyright 1996-2001 by SUNSET DESIGN")
};
static const char * TableAideLicense[] =
{
  AIDE_TITRE("       LICENSE")
  AIDE_TEXTE("")
  AIDE_TEXTE("Grafx2 is FREE SOFTWARE, you can")
  AIDE_TEXTE("redistribute it and/or modify it under the")
  AIDE_TEXTE("terms of the GNU General Public License as")
  AIDE_TEXTE("published by the Free Software Foundation;")
  AIDE_TEXTE("version 2 of the License.")
  AIDE_TEXTE("")
  AIDE_TEXTE("Grafx2 is distributed in the hope that it")
  AIDE_TEXTE("will be useful, but WITHOUT ANY WARRANTY;")
  AIDE_TEXTE("without even the implied warranty of")
  AIDE_TEXTE("MERCHANTABILITY or FITNESS FOR A PARTICULAR")
  AIDE_TEXTE("PURPOSE.  See the GNU General Public License")
  AIDE_TEXTE("for more details.")
  AIDE_TEXTE("")
  AIDE_TEXTE("You should have received a copy of the GNU")
  AIDE_TEXTE("General Public License along with Grafx2;")
  AIDE_TEXTE("if not, see http://www.gnu.org/licenses/ or")
  AIDE_TEXTE("write to the Free Software Foundation, Inc.")
  AIDE_TEXTE(" 59 Temple Place - Suite 330, Boston,")
  AIDE_TEXTE(" MA  02111-1307, USA.")

};
static const char * TableAideHelp[] =
{
  AIDE_TITRE("HELP")
  AIDE_TEXTE("")
  AIDE_TEXTE("  Contextual help is available.")
  AIDE_TEXTE("  Just press your Help key (usually <F1>)")
  AIDE_TEXTE("  while hovering an icon, or inside a menu.")
};
static const char * TableAideCredits[] =
{
  AIDE_TITRE(" GRAFX2 IS CREATED BY")
  AIDE_BOLD ("         THE GRAFX2 PROJECT TEAM")
  AIDE_TEXTE("")
  AIDE_TEXTE("  Adrien Destugues (pulkomandy@gmail.com)")
  AIDE_TEXTE("  Yves Rizoud (yrizoud@gmail.com)")
  AIDE_TEXTE("")
  AIDE_BOLD ("                    ART")
  AIDE_TEXTE("")
  AIDE_TEXTE("  GrafX2 logo by Made (www.m4de.com)")
  AIDE_TEXTE("  Icons and fonts by X-Man ")
  AIDE_TEXTE("")
  AIDE_BOLD ("              AMIGA OS 4 PORT")
  AIDE_TEXTE("")
  AIDE_TEXTE("  xeron")
  AIDE_TEXTE("")
  AIDE_BOLD ("               MAC OS X PORT")              //
  AIDE_TEXTE("")                                          //
  AIDE_TEXTE("  hitchhikr")                               //
  AIDE_TEXTE("")
  AIDE_BOLD("                 BUGFINDERS")                //
  AIDE_TEXTE("")                                          //
  AIDE_TEXTE("  Ced        El Topo    Frost         Grimmy")
  AIDE_TEXTE("  keito      kusma      Lord Graga    mind")
  AIDE_TEXTE("  MooZ       tempest    titus^Rab")
  AIDE_TEXTE("")
  AIDE_BOLD ("               OUR HOMEPAGE")               //
  AIDE_TEXTE("")                                          //
  AIDE_TEXTE("http://grafx2.codegoogle.com")
  AIDE_TEXTE("Please report any bug you may find there")
  AIDE_TEXTE("")
  AIDE_BOLD ("               GREETINGS")
  AIDE_TEXTE("")                                          //
  AIDE_TEXTE("- To the Pouet.net BBS posters, the #CPC")
  AIDE_TEXTE(" trolls and the bitfellas")
  AIDE_TEXTE("- To every people who makes the scene alive!")
  AIDE_TEXTE("- To all guys making nice pixelled pictures")
  AIDE_TEXTE("  (with or without GrafX2)")
  AIDE_TEXTE("")
  AIDE_TITRE("    SUNSET DESIGN")
  AIDE_BOLD ("       AUTHORS OF GRAFX2.0 BETA 96.5%")
  AIDE_TEXTE("")
  AIDE_BOLD ("    GUILLAUME DORME       KARL MARITAUD")
  AIDE_TEXTE("   alias \"Robinson\"   &   alias \"X-Man\"")
  AIDE_TEXTE("         programmer       programmer")
  AIDE_TEXTE("                          GFX artist")
  AIDE_TEXTE("")
  AIDE_TEXTE("   Re-licensed GrafX2 under the GPL in 2001")
  AIDE_TEXTE("")
  AIDE_BOLD ("  SNAIL MAIL:")
  AIDE_TEXTE("  (From 2001, current status: unknown)")
  AIDE_TEXTE("")
  AIDE_TEXTE("    GUILLAUME DORME (Robinson)")
  AIDE_TEXTE("    15, rue de l'observatoire")
  AIDE_TEXTE("    87000 LIMOGES (FRANCE)")
  AIDE_TEXTE("")
  AIDE_TEXTE("    KARL MARITAUD (X-Man)")
  AIDE_TEXTE("    10, rue de la Brasserie")
  AIDE_TEXTE("    87000 LIMOGES (FRANCE)")
  AIDE_TEXTE("")
  AIDE_BOLD ("  WEBSITE:")
  AIDE_TEXTE("  (From 2001, current status: down)")
  AIDE_TEXTE("  http://w3.ensil.unilim.fr/~maritaud/sunset")
  AIDE_TEXTE("")
  AIDE_BOLD("  THANKS:")
  AIDE_TEXTE("")
  AIDE_TEXTE("    We were inspired by the XSetMode routine")
  AIDE_TEXTE("   from 'XLIB2' to create more amazing video")
  AIDE_TEXTE("   resolutions.")
  AIDE_TEXTE("")
  AIDE_TEXTE("    Thanks to Eclipse for their EOS 3.05 dos")
  AIDE_TEXTE("   extender (WEOSlite).")
  AIDE_TEXTE("")
  AIDE_TEXTE("    Some information taken from several docs")
  AIDE_TEXTE("   (PCGPE, Intervue, PC Interdit...) gave us")
  AIDE_TEXTE("   an invaluable help.")
  AIDE_TEXTE("")
  AIDE_TEXTE("    Thanks to Shawn Hargreaves for his")
  AIDE_TEXTE("   filled polygon routine from Allegro v2.2.")
  AIDE_TEXTE("")
  AIDE_TEXTE("    Thanks to Carlos \"Made\" Pardo for his")
  AIDE_TEXTE("   great GrafX2 logo.")
  AIDE_TEXTE("")
  AIDE_TEXTE("    This is our very first program compiled")
  AIDE_TEXTE("   in Watcom C (10.6).")
  AIDE_TEXTE("    Low-level routines were written in 80386")
  AIDE_TEXTE("   Assembler (optimized for 80486) and")
  AIDE_TEXTE("   compiled with Borland TASM 5 (4.1).")
  AIDE_TEXTE("    A thousand thanks to the authors of")
  AIDE_TEXTE("    these compilers.")
  AIDE_TEXTE("")
  AIDE_TEXTE("    We also would like to thank all the")
  AIDE_TEXTE("   people who gave us ideas to improve")
  AIDE_TEXTE("   GrafX2.")
  AIDE_TITRE("")
  AIDE_BOLD ("  FILE FORMATS CREDITS:")
  AIDE_TEXTE("")
  AIDE_TEXTE("   PKM : Sunset Design")
  AIDE_TEXTE("   LBM : Electronic Arts")
  AIDE_TEXTE("   GIF : Compuserve")
  AIDE_TEXTE("   BMP : Microsoft")
  AIDE_TEXTE("   PCX : Z-Soft")
  AIDE_TEXTE("   IMG : Bivas (W. Wiedmann?)")
  AIDE_TEXTE("   SCx : Colorix (?)")
  AIDE_TEXTE("   CEL,KCF : K.O.S. (KISekae Set system)")
  AIDE_TEXTE("   PI1,PC1 : Degas Elite")
  AIDE_TEXTE("   PAL : ermmh... nobody (?)")
  AIDE_TEXTE("")
  AIDE_TEXTE("We send our best regards to...")
  AIDE_TEXTE("")
  AIDE_TEXTE("  Access        Filter        Pink")
  AIDE_TEXTE("  Ace           Fiver         Pixel")
  AIDE_TEXTE("  AcidJam       Flan          Profil")
  AIDE_TEXTE("  Acryl         Fred          Prowler")
  AIDE_TEXTE("  Alexel        FreddyV       Puznik")
  AIDE_TEXTE("  Alias         Frost         Quick")
  AIDE_TEXTE("  Amiral        Gal(GDC)     Ra")
  AIDE_TEXTE("  Arrakis       GainX         Raster")
  AIDE_TEXTE("  Avocado       Gandalf       Ravian")
  AIDE_TEXTE("  Baloo         Goblin        RedBug")
  AIDE_TEXTE("  Barti         Greenpix7     Rem")
  AIDE_TEXTE("  Bat           Grid          Rez")
  AIDE_TEXTE("  Biro          GrosQuick     Roudoudou")
  AIDE_TEXTE("  Bisounours    HackerCroll   Sacrilege")
  AIDE_TEXTE("  BlackAxe      Haplo         Sam")
  AIDE_TEXTE("  Bonnie        Hof           SandMan")
  AIDE_TEXTE("  Boo           Hornet        Scape")
  AIDE_TEXTE("  Boz           Hulud         Sbastien")
  AIDE_TEXTE("  Carine        Java          Shodan")
  AIDE_TEXTE("  Chandra       JBT           Skal")
  AIDE_TEXTE("  Cheetah       Jrme        Skyfire")
  AIDE_TEXTE("  Chill         Julien(JCA)   Sphair")
  AIDE_TEXTE("  Cougar        KalMinDo      Sprocket")
  AIDE_TEXTE("  Cremax        KaneWood      Stef")
  AIDE_TEXTE("  Cyclone       Karma         Stony")
  AIDE_TEXTE("  Dake          Keith303      Sumaleth")
  AIDE_TEXTE("  Danny         Lazur         Sunday")
  AIDE_TEXTE("  Danube        LightShow     Suny")
  AIDE_TEXTE("  Darjul        Lluvia        Sybaris")
  AIDE_TEXTE("  Darwin        Louie         TBF")
  AIDE_TEXTE("  DarkAngel     Luk           Tempest")
  AIDE_TEXTE("  Das           Made          Thor")
  AIDE_TEXTE("  Decker        Mamos         TMK")
  AIDE_TEXTE("  DerPiipo      Mandrixx      TwoFace")
  AIDE_TEXTE("  Destop        Mangue        Underking")
  AIDE_TEXTE("  Diabolo       Mars          Unreal")
  AIDE_TEXTE("  DineS         Mephisto      VaeVictis")
  AIDE_TEXTE("  Drac          Mercure       Vastator")
  AIDE_TEXTE("  DrYes         Mirec         Vatin")
  AIDE_TEXTE("  Edyx          Moa           Veckman")
  AIDE_TEXTE("  Eller         Moxica        Wain")
  AIDE_TEXTE("  Ellyn         MRK           Wally")
  AIDE_TEXTE("  EOF           Nitch         WillBe")
  AIDE_TEXTE("  Fall          Noal          Xoomie")
  AIDE_TEXTE("  Fame          Nytrik        Xtrm")
  AIDE_TEXTE("  Fantom        Optic         YannSulu")
  AIDE_TEXTE("  Fear          Orome         Z")
  AIDE_TEXTE("  Feather       Pahladin      Zeb")
  AIDE_TEXTE("  Fennec        Phar          Zebig")
  AIDE_TEXTE("  and all #pixel, #demofr and #coders.")
};
static const char * TableAidePinceaux[] =
{
  AIDE_TITRE("PAINTBRUSHES")
  AIDE_TEXTE("")
  AIDE_BOLD ("    LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Displays a menu where you can choose the")
  AIDE_TEXTE("shape of your paintbrush.")
  AIDE_TEXTE("")
  AIDE_TEXTE("Paintbrushes are sorted by family. You can")
  AIDE_TEXTE("see some paintbrushes of the same family but")
  AIDE_TEXTE("with different sizes. There is at least one")
  AIDE_TEXTE("paint-brush from each family displayed in")
  AIDE_TEXTE("this menu.")
  AIDE_TEXTE("Here is the list of all the different")
  AIDE_TEXTE("paintbrush families:")
  AIDE_TEXTE("")
  AIDE_TEXTE("*******      ***      * * * *      * *   ")
  AIDE_TEXTE("*******     *****      * * *      * * *  ")
  AIDE_TEXTE("*******    *******    * * * *    * * * * ")
  AIDE_TEXTE("*******    *******     * * *      * * *  ")
  AIDE_TEXTE("*******    *******    * * * *    * * * * ")
  AIDE_TEXTE("*******     *****      * * *      * * *  ")
  AIDE_TEXTE("*******      ***      * * * *      * *   ")
  AIDE_TEXTE("")
  AIDE_TEXTE("Square      Disc       Sieve      Sieve  ")
  AIDE_TEXTE("                      square      disc   ")
  AIDE_TEXTE("                                         ")
  AIDE_TEXTE("   *           *                    *    ")
  AIDE_TEXTE("  ***       *    *                  *    ")
  AIDE_TEXTE(" *****        *                     *    ")
  AIDE_TEXTE("*******               *******       *    ")
  AIDE_TEXTE(" *****     *  *  *                  *    ")
  AIDE_TEXTE("  ***                               *    ")
  AIDE_TEXTE("   *         *  *                   *    ")
  AIDE_TEXTE("                                         ")
  AIDE_TEXTE("Diamond    Random      Horiz.    Vertical")
  AIDE_TEXTE("                        bar        bar   ")
  AIDE_TEXTE("")
  AIDE_TEXTE("")
  AIDE_TEXTE("      *    *          *     *       *")
  AIDE_TEXTE("     *      *          *   *        *")
  AIDE_TEXTE("    *        *          * *         *")
  AIDE_TEXTE("   *          *          *       *******")
  AIDE_TEXTE("  *            *        * *         *")
  AIDE_TEXTE(" *              *      *   *        *")
  AIDE_TEXTE("*                *    *     *       *")
  AIDE_TEXTE("")
  AIDE_TEXTE(" Slash      Back-     Cross X    Cross +")
  AIDE_TEXTE("            slash")
  AIDE_TEXTE("")
  AIDE_TEXTE("The 3 last paintbrushes in the menu belong")
  AIDE_TEXTE("to the \"miscellaneous\" family and their size")
  AIDE_TEXTE("cannot be modified.")
  AIDE_TEXTE("")
  AIDE_BOLD ("    RIGHT CLICK     ")
  AIDE_TEXTE("")
  AIDE_TEXTE("Transforms your current user-defined brush")
  AIDE_TEXTE("into a paintbrush. This is actually a")
  AIDE_TEXTE("\"monochromisation\" of your user-defined")
  AIDE_TEXTE("brush. This means that every color of the")
  AIDE_TEXTE("brush that aren't the Back-color will be")
  AIDE_TEXTE("set to the Fore-color. But this option")
  AIDE_TEXTE("doesn't alter the brush: you'll just have")
  AIDE_TEXTE("to right-click on the \"Get brush\" buttons")
  AIDE_TEXTE("to get your brush back.")
  AIDE_TEXTE("")
  AIDE_TEXTE("Note: When you press (not in the menu) the")
  AIDE_TEXTE("<Delete> key (default value), the current")
  AIDE_TEXTE("paintbrush becomes the smallest member of")
  AIDE_TEXTE("the \"Disc\" family: i.e one pixel.")

};
static const char * TableAideAjuster[] =
{
  AIDE_TITRE("ADJUST PICTURE")
  AIDE_TEXTE("")
  AIDE_BOLD ("    LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Allows you to scroll the picture to")
  AIDE_TEXTE("re-center your graph for example.")
  AIDE_TEXTE("")
  AIDE_TEXTE("Any part of the picture that goes out of")
  AIDE_TEXTE("the image by a side comes back by the")
  AIDE_TEXTE("opposite one.")
  AIDE_TEXTE("")
  AIDE_TEXTE("It is assimilated to the drawing tools")
  AIDE_TEXTE("family.")
  AIDE_TEXTE("")
  AIDE_TEXTE("")
  AIDE_BOLD ("    RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("        *** Not implemented yet ***")

};
static const char * TableAideDessin[] =
{
  AIDE_TITRE("HAND-DRAWING")
  AIDE_TEXTE("")
  AIDE_BOLD ("    LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Selects the current hand-drawing mode as the")
  AIDE_TEXTE("active drawing tool. There are 3")
  AIDE_TEXTE("hand-drawing modes:")
  AIDE_TEXTE("")
  AIDE_TEXTE("Continuous hand-drawing: as you move the")
  AIDE_TEXTE("mouse, the paintbrush is regularily pasted")
  AIDE_TEXTE("on the picture. This drawing tool allows to")
  AIDE_TEXTE("change the fore and back colors when being")
  AIDE_TEXTE("in use.")
  AIDE_TEXTE("")
  AIDE_TEXTE("Discontinuous hand-drawing: as you move the")
  AIDE_TEXTE("mouse, the paintbrush is pasted on the")
  AIDE_TEXTE("picture every time a delay is passed")
  AIDE_TEXTE("(actually, the delay is 1 VBL")
  AIDE_TEXTE("(vertical blanking)). This drawing tool")
  AIDE_TEXTE("allows to change the fore and back colors")
  AIDE_TEXTE("when being in use.")
  AIDE_TEXTE("")
  AIDE_TEXTE("Dot by dot hand-drawing: the paintbrush is")
  AIDE_TEXTE("only pasted at the position where you first")
  AIDE_TEXTE("clicked.")
  AIDE_TEXTE("")
  AIDE_TEXTE("")
  AIDE_BOLD ("    RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Toggles the different hand-drawing modes")
  AIDE_TEXTE("and activates, at the same time, the")
  AIDE_TEXTE("hand-drawing tool.")
};
static const char * TableAideCourbes[] =
{
  AIDE_TITRE("SPLINES")
  AIDE_TEXTE("")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Selects the current curve-drawing mode as")
  AIDE_TEXTE("the active drawing tool. There are 2")
  AIDE_TEXTE("different curve-drawing modes:")
  AIDE_TEXTE("")
  AIDE_TEXTE("* 4 control points curves: define the basic")
  AIDE_TEXTE("line like a classical line, then move, with")
  AIDE_TEXTE("the left mouse button, the inner control")
  AIDE_TEXTE("points to choose the shape of your curve.")
  AIDE_TEXTE("When the curve has the shape you want, click")
  AIDE_TEXTE("with the right mouse button to draw it")
  AIDE_TEXTE("definitively.")
  AIDE_TEXTE("")
  AIDE_TEXTE("* 3 control points curves: the same as")
  AIDE_TEXTE("above, but you'll have only one inner")
  AIDE_TEXTE("control point to place. Moreover, the spline")
  AIDE_TEXTE("will be traced just after placing this")
  AIDE_TEXTE("point.")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Toggles the different curve-drawing modes")
  AIDE_TEXTE("and activates, at the same time, the")
  AIDE_TEXTE("curve-drawing tool.")
};
static const char * TableAideLignes[] =
{
  AIDE_TITRE("LINES")
  AIDE_TEXTE("")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Selects the current line-drawing mode as the")
  AIDE_TEXTE("active drawing tool. There are 3")
  AIDE_TEXTE("line-drawing modes:")
  AIDE_TEXTE("")
  AIDE_TEXTE("* Classical lines: when first clicking on")
  AIDE_TEXTE("the picture, you'll define the start of the")
  AIDE_TEXTE("line. Maintain your click to choose the end")
  AIDE_TEXTE("of the line and release the mouse button to")
  AIDE_TEXTE("set it.")
  AIDE_TEXTE("If you hold SHIFT when drawing, the line")
  AIDE_TEXTE("will be constrained to horizonal, vertical")
  AIDE_TEXTE("or diagonal.")
  AIDE_TEXTE("")
  AIDE_TEXTE("* Knotted lines: works like classical lines,")
  AIDE_TEXTE("but the end of your line will automatically")
  AIDE_TEXTE("become the start of the next one. When you")
  AIDE_TEXTE("want to stop chaining lines, use the")
  AIDE_TEXTE("opposite mouse button. \"The opposite button\"")
  AIDE_TEXTE("means that if you started to draw lignes")
  AIDE_TEXTE("with the left button (Fore-color), you'll")
  AIDE_TEXTE("have to stop the procedure with the right")
  AIDE_TEXTE("button; and conversely.")
  AIDE_TEXTE("")
  AIDE_TEXTE("* Concentric lines: when first clicking on")
  AIDE_TEXTE("the picture, you'll define center of the")
  AIDE_TEXTE("lines. In fact, the center is defined by the")
  AIDE_TEXTE("the position of the mouse when you release")
  AIDE_TEXTE("the mouse button. Then you can draw lines")
  AIDE_TEXTE("from the center to the current mouse")
  AIDE_TEXTE("position by clicking. To stop drawing")
  AIDE_TEXTE("concentric lines, use the opposite mouse")
  AIDE_TEXTE("button. This drawing tool allows to change")
  AIDE_TEXTE("the fore and back colors when being in use.")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Toggles the different line-drawing modes and")
  AIDE_TEXTE("activates, at the same time, the")
  AIDE_TEXTE("line-drawing tool.")

};
static const char * TableAideSpray[] =
{
  AIDE_TITRE("SPRAY")
  AIDE_TEXTE("")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Selects the spray as the active drawing")
  AIDE_TEXTE("tool. This drawing tool allows to change the")
  AIDE_TEXTE("fore and back colors when being in use.")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Displays a menu where you can configure the")
  AIDE_TEXTE("spray:")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Size: Defines the diameter of the circle")
  AIDE_TEXTE("in which will effectively fit the spray.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Delay: Defines the number of VBLs that")
  AIDE_TEXTE("will be waited for between two flows of")
  AIDE_TEXTE("spray.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Mode: Defines whether you want to use a")
  AIDE_TEXTE("monochrome spray or a multi- colored one.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Mono-flow: Defines the number of")
  AIDE_TEXTE("paintbrushes that will be pasted in the")
  AIDE_TEXTE("circle of the spray at each cycle.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Palette: Left-click on a color of the")
  AIDE_TEXTE("palette to see how much it will be used in")
  AIDE_TEXTE("the multicolored flow, and modify it by")
  AIDE_TEXTE("using the gauge on the right. If the flow of")
  AIDE_TEXTE("this color was equal to 0, then the \"Init\"")
  AIDE_TEXTE("value will be applied. Or set the flow of a")
  AIDE_TEXTE("color to 0 by clicking on it with the right")
  AIDE_TEXTE("mouse button.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Clear: Removes all the colors from the")
  AIDE_TEXTE("multicolored flow. Actually, this puts a 0")
  AIDE_TEXTE("value in the use of each color.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Init: Allows you to define a value that")
  AIDE_TEXTE("will be set to the color you click on in the")
  AIDE_TEXTE("palette if its value is equal to 0. This")
  AIDE_TEXTE("permits to tag a set of colors more quickly.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- +1,-1,x2,/2: Modify the values of all the")
  AIDE_TEXTE("tagged colors (and only them).")
  AIDE_TEXTE("")
  AIDE_TEXTE("")
  AIDE_TEXTE("Tip: If you often use the Shade mode, and")
  AIDE_TEXTE("are bored to click many times on a color to")
  AIDE_TEXTE("reach the color you want, you can define a")
  AIDE_TEXTE("spray with \"Size\"=1, \"Mono-flow\"=1, and")
  AIDE_TEXTE("\"Delay\"=2 (or more, according to your")
  AIDE_TEXTE("reflexes). And then, you'll just have to")
  AIDE_TEXTE("click a few hundredths of second to modify a")
  AIDE_TEXTE("color.")
};
static const char * TableAideFloodfill[] =
{
  AIDE_TITRE("FLOODFILL")
  AIDE_TEXTE("")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Selects the filler as the active drawing")
  AIDE_TEXTE("tool. The filler, as any drawing tool, will")
  AIDE_TEXTE("be affected by all the effects!")
  AIDE_TEXTE("")
  AIDE_TEXTE("Note that only the visible part of the")
  AIDE_TEXTE("picture will be filled (as every other")
  AIDE_TEXTE("drawing tools, the floodfill only alters the")
  AIDE_TEXTE("visible part of the picture; this avoids")
  AIDE_TEXTE("unwanted effects that wouldn't be controlled")
  AIDE_TEXTE("by the user).")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Selects the color replacement as the active")
  AIDE_TEXTE("drawing tool.")
  AIDE_TEXTE("")
  AIDE_TEXTE("Any rule has its exceptions and this one")
  AIDE_TEXTE("doesn't depart from that. Indeed, this tool")
  AIDE_TEXTE("is the only one to be affected by no effect")
  AIDE_TEXTE("(except Stencil) and to be able to modify")
  AIDE_TEXTE("non visible parts of the picture.")
  AIDE_TEXTE("The function of this tool being replacing")
  AIDE_TEXTE("all the occurences of a color in the picture")
  AIDE_TEXTE("by another, if would have been a shame to")
  AIDE_TEXTE("limit modifications only to the visible part")
  AIDE_TEXTE("of the picture.")
};
static const char * TableAidePolygones[] =
{
  AIDE_TITRE("POLYGONS")
  AIDE_TITRE("POLYFORMS")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Selects the polygons as the active drawing")
  AIDE_TEXTE("tool.")
  AIDE_TEXTE("")
  AIDE_TEXTE("This works just like knotted-lines but loops")
  AIDE_TEXTE("the extremities when you're finished.")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Selects the polyforms as the active drawing")
  AIDE_TEXTE("tool.")
  AIDE_TEXTE("")
  AIDE_TEXTE("This works like a combination of free-hand")
  AIDE_TEXTE("drawing and knotted-lines. If you keep the")
  AIDE_TEXTE("mouse button pressed, you'll draw as if you")
  AIDE_TEXTE("were in free-hand drawing mode. And, if you")
  AIDE_TEXTE("release the mouse button, it will work like")
  AIDE_TEXTE("knotted lines.")
  AIDE_TEXTE("")
  AIDE_TEXTE("Click on the opposite mouse button (i.e.:")
  AIDE_TEXTE("click right if you started to draw with the")
  AIDE_TEXTE("left mouse button, and vice versa) to")
  AIDE_TEXTE("terminate the operation. The two extremities")
  AIDE_TEXTE("will be linked automatically.")
};
static const char * TableAidePolyfill[] =
{
  AIDE_TITRE("FILLED POLY")
  AIDE_TEXTE(" Work exactly the same way as the polygons")
  AIDE_TEXTE("et polyforms above, but fill in the interior")
  AIDE_TEXTE("of the drawn shapes.")
};
static const char * TableAideRectangles[] =
{
  AIDE_TITRE("RECTANGLES")
  AIDE_TEXTE("")
  AIDE_TEXTE("Selects the empty rectangles as the active")
  AIDE_TEXTE("drawing tool.")
  AIDE_TEXTE("")
  AIDE_TEXTE("Set a corner of a rectangle. Maintain the")
  AIDE_TEXTE("click to move the opposite corner and")
  AIDE_TEXTE("release the mouse button to set it")
  AIDE_TEXTE("definitively.")
};
static const char * TableAideFillRect[] =
{
  AIDE_TITRE("FILLED RECT")
  AIDE_TEXTE("")
  AIDE_TEXTE("Selects the filled rectangles as the active")
  AIDE_TEXTE("drawing tool.")
  AIDE_TEXTE("")
  AIDE_TEXTE("Works like an empty rectangle.")
};
static const char * TableAideCercles[] =
{
  AIDE_TITRE("CIRCLES")
  AIDE_TITRE("ELLIPSES")
  AIDE_TEXTE("")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Selects the empty circles as the active")
  AIDE_TEXTE("drawing tool.")
  AIDE_TEXTE("")
  AIDE_TEXTE("Position the center of the cercle and")
  AIDE_TEXTE("maintain the mouse button to select its")
  AIDE_TEXTE("radius.")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Selects the empty ellipses as the active")
  AIDE_TEXTE("drawing tool.")
  AIDE_TEXTE("")
  AIDE_TEXTE("Position the center of the cercle and")
  AIDE_TEXTE("maintain the mouse button to select its")
  AIDE_TEXTE("dimensions.")
};
static const char * TableAideFillCerc[] =
{
  AIDE_TITRE("FILLED CIRCLES")
  AIDE_TITRE(" AND ELLIPSES")
  AIDE_TEXTE("")
  AIDE_TEXTE("Works like empty circles and ellipses.")
};
static const char * TableAideGradRect[] =
{
  AIDE_TITRE("GRAD RECTANGLE")
  AIDE_TEXTE("")
  AIDE_TEXTE("   *** Not implemented yet ***")
};
static const char * TableAideGradMenu[] =
{
  AIDE_TITRE("GRAD MENU")
  AIDE_TEXTE("")
  AIDE_TEXTE("Opens a window where you can define the way")
  AIDE_TEXTE("gradations are processed. The different")
  AIDE_TEXTE("sections of this menu are:")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Direction (arrow): Switches the direction")
  AIDE_TEXTE("of the gradation.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Dithering method: Toggles the 3 following")
  AIDE_TEXTE("methods:")
  AIDE_TEXTE("  - No dithering")
  AIDE_TEXTE("  - Basical dithering")
  AIDE_TEXTE("  - Enhanced dithering")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Mix: Mixes the gradation with a more or")
  AIDE_TEXTE("less random factor.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Palette: Select a color range to build a")
  AIDE_TEXTE("gradation.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Index scroller: Defines the current")
  AIDE_TEXTE("gradation among a set of 16 that will be")
  AIDE_TEXTE("memorised.")
};
static const char * TableAideSpheres[] =
{
  AIDE_TITRE("GRAD SPHERE")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Selects the spheres as the active drawing")
  AIDE_TEXTE("tool.")
  AIDE_TEXTE("")
  AIDE_TEXTE("Position the center of the sphere and")
  AIDE_TEXTE("maintain the mouse button to select its")
  AIDE_TEXTE("radius. Then place the spot-light.")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Selects the ellipses with gradation as the")
  AIDE_TEXTE("active drawing tool.")
  AIDE_TEXTE("")
  AIDE_TEXTE("*** The current version of this tool isn't")
  AIDE_TEXTE("the right one; ***")
  AIDE_TEXTE("***  so we'll explain how to use it when it")
  AIDE_TEXTE("will be done  ***")
  AIDE_TEXTE("")
  AIDE_TEXTE(" If you trace a sphere or an ellipse with")
  AIDE_TEXTE("gradation with the right mouse button, the")
  AIDE_TEXTE("result will be the same figure filled with")
  AIDE_TEXTE("the Back-color.")
};
static const char * TableAideBrosse[] =
{
  AIDE_TITRE("GRAB BRUSH")
  AIDE_BOLD ("  OR RESTORE BRUSH")
  AIDE_TEXTE("")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Engages a brush grabbing.")
  AIDE_TEXTE("")
  AIDE_TEXTE("Click on a corner of the rectangle")
  AIDE_TEXTE("containing the brush then maintain the click")
  AIDE_TEXTE("to define the opposite corner of the")
  AIDE_TEXTE("rectangle. Release the mouse button to grab")
  AIDE_TEXTE("the brush. Performing this operation with")
  AIDE_TEXTE("the right mouse button will erase the area")
  AIDE_TEXTE("where the brush was grabbed with the")
  AIDE_TEXTE("Back-color.")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Restores the old brush.")
};
static const char * TableAidePolybrosse[] =
{
  AIDE_TITRE("POLY GRAB")
  AIDE_TEXTE("")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Grabs a brush of any shape by defining a")
  AIDE_TEXTE("polyform (please refer to section 8 for more")
  AIDE_TEXTE("explanations).")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Restores the old brush (same as above).")
};
static const char * TableAideEffetsBrosse[] =
{
  AIDE_TITRE("BRUSH FX")
  AIDE_TEXTE("")
  AIDE_TEXTE("Displays a menu where the following options")
  AIDE_TEXTE("are available:")
  AIDE_TEXTE("")
  AIDE_TEXTE("- X: Flip-X.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Y: Flip-Y.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Rotate by 90: Rotates the brush by an")
  AIDE_TEXTE("angle of 90 degrees.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Rotate by 180: Rotates the brush by an")
  AIDE_TEXTE("angle of 180 degrees.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Rotate by any angle: Triggers an")
  AIDE_TEXTE("interactive operation that allows you to")
  AIDE_TEXTE("rotate the brush. For this, start by placing")
  AIDE_TEXTE("the center or rotation with the left mouse")
  AIDE_TEXTE("button (if, at this moment, you press the")
  AIDE_TEXTE("right button, the operation with be")
  AIDE_TEXTE("cancelled). After that, you can define the")
  AIDE_TEXTE("angle of rotation as many times as you want")
  AIDE_TEXTE("by moving the mouse and left-clicking. Then")
  AIDE_TEXTE("validate with the right button when you are")
  AIDE_TEXTE("satisfied. Meanwhile, you can press on the 8")
  AIDE_TEXTE("outer digits of the numeric pad for defining")
  AIDE_TEXTE("angles multiple of 45 degrees:")
  AIDE_TEXTE("")
  AIDE_TEXTE("             135     90      45")
  AIDE_TEXTE("                \\     |     /")
  AIDE_TEXTE("                 '7' '8' '9'")
  AIDE_TEXTE("           180  -'4'     '6'- 0")
  AIDE_TEXTE("                 '1' '2' '3'")
  AIDE_TEXTE("                /     |     \\")
  AIDE_TEXTE("             225     270    315")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Stretch: Triggers an interactive operation")
  AIDE_TEXTE("that enables you to stretch the brush. For")
  AIDE_TEXTE("this, start by placing the upper-left")
  AIDE_TEXTE("cornerof the brush with the left mouse")
  AIDE_TEXTE("button (if, at this moment, you press the")
  AIDE_TEXTE("right button, the operation will be")
  AIDE_TEXTE("cancelled). after that, you can place the")
  AIDE_TEXTE("opposite corner as many times as you need,")
  AIDE_TEXTE("then validate with the right mouse button")
  AIDE_TEXTE("when you are satisfied. If you place this")
  AIDE_TEXTE("point at coordinates inferior to the ones of")
  AIDE_TEXTE("the first point, the brush will be inverted.")
  AIDE_TEXTE("Meanwhile, you can press the following keys")
  AIDE_TEXTE("whose effects are:   'D'      : double the")
  AIDE_TEXTE("brush in X and Y   'H'      : reduce the")
  AIDE_TEXTE("brush by half in X and Y   'X'      : double")
  AIDE_TEXTE("the brush in X   'Shift+X': reduce the brush")
  AIDE_TEXTE("by half in X   'Y'      : double the brush")
  AIDE_TEXTE("in Y   'Shift+Y': reduce the brush by half")
  AIDE_TEXTE("in Y   'N'      : restore the normal size of")
  AIDE_TEXTE("the brush (can be useful")
  AIDE_TEXTE("because it's the only way for cancelling)")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Distort: *** Not implemented yet ***")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Outline: This option permits to draw the")
  AIDE_TEXTE("outlines of the brush with the Fore- color.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Nibble: This option \"nibbles\" the outlines")
  AIDE_TEXTE("of the brush. It's in some way the opposite")
  AIDE_TEXTE("effect of the Outline option.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Recolorize: Remaps the brush so that it")
  AIDE_TEXTE("looks like it would in the spare page, using")
  AIDE_TEXTE("the current palette.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Get brush colors: Transfers the spare")
  AIDE_TEXTE("page's colors used by the brush to the")
  AIDE_TEXTE("current palette.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Brush handle: Allows you to choose where")
  AIDE_TEXTE("to place the handle of the brush.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Load / Save: load or save a brush from")
  AIDE_TEXTE("disk.")
};
static const char * TableAideEffets[] =
{
  AIDE_TITRE("DRAW MODES")
  AIDE_TEXTE(" This button opens a menu where you can")
  AIDE_TEXTE("switch on or off the different   drawing")
  AIDE_TEXTE("modes. ([F1]-[F9] keys correspond to the 9")
  AIDE_TEXTE("buttons)")
  AIDE_TEXTE(" In this menu, the \"All off\" button switches")
  AIDE_TEXTE("all the drawing modes off.   The [Del] key")
  AIDE_TEXTE("is the keyboard shortcut for this button.")
  AIDE_TEXTE(" The \"Feedback\" button is only used in")
  AIDE_TEXTE("\"Shade\", \"Quick-shade, \"Transparency\"")
  AIDE_TEXTE("and \"Smooth\" modes. When it is set, it means")
  AIDE_TEXTE("that the _current_   state of the picture")
  AIDE_TEXTE("has to be taken into account for the effect")
  AIDE_TEXTE("instead   of the state in which the image")
  AIDE_TEXTE("was when you started to click for drawing.")
  AIDE_TEXTE("The best, as often, is that you try by")
  AIDE_TEXTE("yourself with and without Feedback   to see")
  AIDE_TEXTE("the difference.")
  AIDE_TEXTE("   The other buttons are the following:")
  AIDE_TEXTE("")
  AIDE_TITRE("SHADE")
  AIDE_TEXTE(" It consists in increasing or decreasing the")
  AIDE_TEXTE("color number within a user-   defined range.")
  AIDE_TEXTE("This shows its real dimension when used with")
  AIDE_TEXTE("a range of   colors that shade off. Then,")
  AIDE_TEXTE("you can work on a part of your picture where")
  AIDE_TEXTE("colors belong to the same range without")
  AIDE_TEXTE("having to change your brush color   all the")
  AIDE_TEXTE("time. You can choose the incrementation or")
  AIDE_TEXTE("decrementation of the color by   pressing")
  AIDE_TEXTE("the left or right mouse button while")
  AIDE_TEXTE("drawing. If you click on a   color that does")
  AIDE_TEXTE("not belong to the range, it will remain")
  AIDE_TEXTE("unchanged.")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Switches the Shade mode.")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Opens a menu where you can define one table")
  AIDE_TEXTE("of shades within a range of 8 memorised by")
  AIDE_TEXTE("the program. The different sections of this")
  AIDE_TEXTE("menu are:")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Palette: You can define in it the color")
  AIDE_TEXTE("blocks that will be inserted")
  AIDE_TEXTE("into the table of shades.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Scroller: Used to change flick through the")
  AIDE_TEXTE("tables of shades.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- table of shades definition area: The 512")
  AIDE_TEXTE("squares should be widely")
  AIDE_TEXTE("sufficient to define the different shades")
  AIDE_TEXTE("since every 256 colors of")
  AIDE_TEXTE("the palette cannot be present more than once")
  AIDE_TEXTE("in each table.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- A window (on the top-right side) permits")
  AIDE_TEXTE("to visualize the different")
  AIDE_TEXTE("shades defined in he current table.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Copy: Copy the contents of the table in a")
  AIDE_TEXTE("buffer.")
  AIDE_TEXTE("(Each time you open this menu, the current")
  AIDE_TEXTE("table is automatically")
  AIDE_TEXTE("transfered into this buffer).")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Paste: Copy the contents of the buffer")
  AIDE_TEXTE("above in the current table.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Clear: Reset the \"shades\" table.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Insert: Used to insert the block selected")
  AIDE_TEXTE("in the palette at the")
  AIDE_TEXTE("cursor's position in the table of shades.")
  AIDE_TEXTE("IF you click with the left mouse button on")
  AIDE_TEXTE("this button THEN IF a block of more than one")
  AIDE_TEXTE("color is selected in the table THEN   It is")
  AIDE_TEXTE("deleted and the block defined in the palette")
  AIDE_TEXTE("is inserted. ELSE   The block defined in the")
  AIDE_TEXTE("palette is inserted at the postion just")
  AIDE_TEXTE("before the selected square. END IF")
  AIDE_TEXTE("ELSE The block defined in the palette is")
  AIDE_TEXTE("inserted by erasing the colors following the")
  AIDE_TEXTE("beginning of the bloc selected in the table.")
  AIDE_TEXTE("END IF")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Delete: Delete the block selected in the")
  AIDE_TEXTE("table.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Blank: Follows this algorithm:")
  AIDE_TEXTE("IF you click with the left mouse button on")
  AIDE_TEXTE("this button THEN Replace the block selected")
  AIDE_TEXTE("in the table by blank squares.")
  AIDE_TEXTE("ELSE IF a block of more than one color is")
  AIDE_TEXTE("selected in the table THEN   Insert blank")
  AIDE_TEXTE("squares to the left and to the right of the")
  AIDE_TEXTE("block.   (this is useful for isolating a")
  AIDE_TEXTE("shade quickly) ELSE   Insert blank squares")
  AIDE_TEXTE("to the left of the selected square. END IF")
  AIDE_TEXTE("END IF")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Invert: Invert the order of the block")
  AIDE_TEXTE("selected in the table.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Swap: Allows you you move a block (this")
  AIDE_TEXTE("exchanges it with what is")
  AIDE_TEXTE("where you want to move it).")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Undo: Cancel the last modification of the")
  AIDE_TEXTE("table.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- The 2 numbers displayed on the right of")
  AIDE_TEXTE("these buttons are: (above) - the number of")
  AIDE_TEXTE("the color selected in the palette if only")
  AIDE_TEXTE("one color is selected. (below) - the number")
  AIDE_TEXTE("of the color contained in a square in the")
  AIDE_TEXTE("shades table if this square is the only one")
  AIDE_TEXTE("selected.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- The \"mode\" button displays 3 different")
  AIDE_TEXTE("modes:")
  AIDE_TEXTE("\"Normal\": Shades in the range and saturates")
  AIDE_TEXTE("to its boundaries.")
  AIDE_TEXTE("\"Loop\": Shades in the range and loops if")
  AIDE_TEXTE("boundaries are passed.")
  AIDE_TEXTE("\"No saturation\": Shades in the range and")
  AIDE_TEXTE("doesn't saturate if boundaries are passed.")
  AIDE_TEXTE("If the Step (see below) is set to 1, this")
  AIDE_TEXTE("option does exactly the same as the Normal")
  AIDE_TEXTE("mode.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Set/Disable: If you want to define several")
  AIDE_TEXTE("shades in the same table")
  AIDE_TEXTE("but you'd like these shades not to be")
  AIDE_TEXTE("effective at the same time, you")
  AIDE_TEXTE("can mask (disable) some parts of the table")
  AIDE_TEXTE("so that they will be")
  AIDE_TEXTE("interpreted a blank squares.")
  AIDE_TEXTE("To do that, select a block in the table of")
  AIDE_TEXTE("shades and click on \"Set\".")
  AIDE_TEXTE("The block will be underlined with a white")
  AIDE_TEXTE("line; this means that it is")
  AIDE_TEXTE("disabled.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Clear/Enable: This does exactly the")
  AIDE_TEXTE("opposite as the button above.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Step: Defines the step of incrementation")
  AIDE_TEXTE("of the shade. The bigger,")
  AIDE_TEXTE("the faster you run through the colors of the")
  AIDE_TEXTE("shade.")
  AIDE_TEXTE("For example: if the step is 2 and that you")
  AIDE_TEXTE("have defined a shade with")
  AIDE_TEXTE("the colors 0,1,4,5,9 and that you click on a")
  AIDE_TEXTE("pixel of color 1, it will")
  AIDE_TEXTE("take the value 5 which is 2 positions next")
  AIDE_TEXTE("in the la table.")
  AIDE_TEXTE("")
  AIDE_TEXTE("(We are sorry for these technical")
  AIDE_TEXTE("considerations quite far from a purely")
  AIDE_TEXTE("artistic point of view; but know that this")
  AIDE_TEXTE("effect is really very useful and it is")
  AIDE_TEXTE("preferable that you understand its whole")
  AIDE_TEXTE("functionment if you want to fully take")
  AIDE_TEXTE("advantage of it).")
  AIDE_TEXTE("")
  AIDE_TEXTE("")
  AIDE_TITRE("QUICK SHADE")
  AIDE_TEXTE(" This drawing mode has about the same effect")
  AIDE_TEXTE("as Shade mode's except that   it is faster")
  AIDE_TEXTE("to configurate but a little bit less")
  AIDE_TEXTE("powerful. When you draw on a color of the")
  AIDE_TEXTE("image which is between the fore- and the")
  AIDE_TEXTE("back-color in the palette, the color tends")
  AIDE_TEXTE("towards the fore-color   (according to the")
  AIDE_TEXTE("step defined) if you draw with the left")
  AIDE_TEXTE("mouse button, or   it tends towards the")
  AIDE_TEXTE("back-color if you are using the right mouse")
  AIDE_TEXTE("button.")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Switches the Quick-shade mode.")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Opens a menu with a few parameters that mean")
  AIDE_TEXTE("exactly the same as in the menu of Shade")
  AIDE_TEXTE("mode. These parameters are the step and the")
  AIDE_TEXTE("loop/satu- ration mode (normal, loop, no")
  AIDE_TEXTE("saturation).")
  AIDE_TEXTE("")
  AIDE_TEXTE("")
  AIDE_TITRE("STENCIL")
  AIDE_TEXTE(" It is used to prevent some colors from")
  AIDE_TEXTE("being modified if you draw on   them. The")
  AIDE_TEXTE("main application of the stencil is when you")
  AIDE_TEXTE("want to change one   color or more into")
  AIDE_TEXTE("another.")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Switches the Stencil mode.")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Opens a menu where you can define a stencil.")
  AIDE_TEXTE("The different sections of this menu are:")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Clear: No color is protected.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Invert: Colors that were protected are")
  AIDE_TEXTE("unprotected and vice versa.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Palette: Select colors that should be")
  AIDE_TEXTE("protected with the left mouse button or")
  AIDE_TEXTE("unprotect colors with the right mouse")
  AIDE_TEXTE("button.")
  AIDE_TEXTE("")
  AIDE_TEXTE("")
  AIDE_TITRE("MASK")
  AIDE_TEXTE(" This effect could have been called \"True")
  AIDE_TEXTE("stencil\" because it protects   some parts of")
  AIDE_TEXTE("the picture instead of some colors. The")
  AIDE_TEXTE("colors you tag   represent the pixels in the")
  AIDE_TEXTE("spare page, corresponding to the pixels in")
  AIDE_TEXTE("the   current page, that you don't want to")
  AIDE_TEXTE("alter. For example, draw a simple white")
  AIDE_TEXTE("figure on a black background in the   spare")
  AIDE_TEXTE("page. Then, tag the black color in the menu")
  AIDE_TEXTE("of the Mask mode. When   you'll draw in the")
  AIDE_TEXTE("current page, only the pixels corresponding")
  AIDE_TEXTE("to the   white (non-black) ones in the spare")
  AIDE_TEXTE("page will be modified.")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Switches the Mask mode.")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Opens a menu where you can set the colors of")
  AIDE_TEXTE("the Mask.")
  AIDE_TEXTE("This menu works the same way as the one of")
  AIDE_TEXTE("the Stencil, so please refer to the Stencil")
  AIDE_TEXTE("paragraph to know how to use it.")
  AIDE_TEXTE("")
  AIDE_TEXTE("")
  AIDE_TITRE("GRID")
  AIDE_TEXTE(" This is useful to snap the cursor to the")
  AIDE_TEXTE("cross-points of a grid. It's   generally")
  AIDE_TEXTE("used to draw a grid before drawing sprites")
  AIDE_TEXTE("of the same size such   as a font or tiles,")
  AIDE_TEXTE("or for drawing figures or grabbing brushes")
  AIDE_TEXTE("with their   dimensions multiple of the step")
  AIDE_TEXTE("of the grid.');")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Switches the Grid mode.")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Opens a menu where you can define the grid")
  AIDE_TEXTE("parameters. These parameters are:")
  AIDE_TEXTE("")
  AIDE_TEXTE("- X,Y: Steps of the grid.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- dX,dY: Offsets of the grid.")
  AIDE_TEXTE("")
  AIDE_TEXTE("")
  AIDE_TITRE("SIEVE")
  AIDE_TEXTE(" This effect allows you, by defining a")
  AIDE_TEXTE("pattern, to draw only on   particular points")
  AIDE_TEXTE("of the picture. If you are a Manga drawer,")
  AIDE_TEXTE("you might find this useful to make patterned")
  AIDE_TEXTE("shades or color transitions.")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Switches the Sieve mode.")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Opens a menu where you can define the Sieve")
  AIDE_TEXTE("parameters. This menu consists in:")
  AIDE_TEXTE("")
  AIDE_TEXTE("- 16x16 drawing area: You can define a")
  AIDE_TEXTE("pattern in it (left click => white pixel /")
  AIDE_TEXTE("right click => black pixel). All the white")
  AIDE_TEXTE("pixels indicate that, when you'll draw,")
  AIDE_TEXTE("pixels will be applied on the picture at the")
  AIDE_TEXTE("corresponding positions whereas black pixels")
  AIDE_TEXTE("won't modify the picture: whites pixels are")
  AIDE_TEXTE("the \"holes of the sieve\".")
  AIDE_TEXTE("")
  AIDE_TEXTE("- 12 default patterns: They can be copied to")
  AIDE_TEXTE("the drawing area.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- \"Transfer to brush\": Copies the pattern to")
  AIDE_TEXTE("the brush (white pixels => Fore-color /")
  AIDE_TEXTE("black pixels => Back-color).")
  AIDE_TEXTE("")
  AIDE_TEXTE("- \"Get from brush\": Puts the brush into the")
  AIDE_TEXTE("drawing area (back-color => black pixels /")
  AIDE_TEXTE("others => white pixels).")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Scrolling 4-arrows pad: Scrolls the")
  AIDE_TEXTE("pattern in the drawing area.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Resizing 4-arrows pad: Defines the")
  AIDE_TEXTE("dimensions of the pattern.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Default-value (black or white square):")
  AIDE_TEXTE("Indicates which value must be inserted when")
  AIDE_TEXTE("you increase the dimensions of the pattern.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- \"Clear\": Sets the whole pattern with the")
  AIDE_TEXTE("default value (see above).")
  AIDE_TEXTE("")
  AIDE_TEXTE("- \"Invert\": It... inverts :) ... black and")
  AIDE_TEXTE("white pixels.")
  AIDE_TEXTE("")
  AIDE_TEXTE("")
  AIDE_TITRE("TRANSPARENCY")
  AIDE_TEXTE(" This allows to mix the color(s) of the")
  AIDE_TEXTE("paintbrush with the colors of the   picture.")
  AIDE_TEXTE("It's used to make transparency effects like")
  AIDE_TEXTE("with watercolors.")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Switches the Transparency mode.")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Opens a menu where you can define the")
  AIDE_TEXTE("Transparency parameters. These parameters")
  AIDE_TEXTE("are:")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Interpolation rate: Indicates the")
  AIDE_TEXTE("percentage of the applied color that will be")
  AIDE_TEXTE("considered upon the replaced color.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Interpolation method: Uses an")
  AIDE_TEXTE("interpolation algorithm to compute the")
  AIDE_TEXTE("color, according to the interpolation rate.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Additive method: Uses the lightest colors")
  AIDE_TEXTE("to choose the color to apply. For example:")
  AIDE_TEXTE("if you want to apply a color RGB:30,20,40 on")
  AIDE_TEXTE("a color RGB:10,50,20, the color applied will")
  AIDE_TEXTE("be the one, in the palette, that is the")
  AIDE_TEXTE("closest to the theoretic color RGB:30,50,40.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Subtractive method: uses the darkest")
  AIDE_TEXTE("colors to choose the color to apply. For")
  AIDE_TEXTE("example: if you want to apply a color")
  AIDE_TEXTE("RGB:30,20,40 on a color RGB:10,50,20, the")
  AIDE_TEXTE("color applied will be the one, in the")
  AIDE_TEXTE("palette, that is the closest to the")
  AIDE_TEXTE("theoretic color RGB:10,20,20.")
  AIDE_TEXTE("")
  AIDE_TEXTE("")
  AIDE_TITRE("SMOOTH")
  AIDE_TEXTE(" It provides an easy but not as efficient")
  AIDE_TEXTE("anti-aliasing as any artist's   touch.")
  AIDE_TEXTE("Anyway this effect finds a better use in")
  AIDE_TEXTE("making a blurry aspect.")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Switches the Smooth mode.")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Opens a menu where you can define the Smooth")
  AIDE_TEXTE("matrix or choose one among the 4 ones")
  AIDE_TEXTE("predefined.")
  AIDE_TEXTE("The middle square represents the pixel on")
  AIDE_TEXTE("which you draw and the 8 others represent")
  AIDE_TEXTE("the neighbour pixels. Then, the point on")
  AIDE_TEXTE("which one draw will be replaced by the")
  AIDE_TEXTE("weighted average (according to values of")
  AIDE_TEXTE("each squares) of the 9 defined points.")
  AIDE_TEXTE("")
  AIDE_TEXTE("")
  AIDE_TITRE("SMEAR")
  AIDE_TEXTE(" It smears pixels in the direction you are")
  AIDE_TEXTE("moving your paintbrush, just   as if you")
  AIDE_TEXTE("wanted to spread fresh paint with your")
  AIDE_TEXTE("fingers. You can combine   this effect with")
  AIDE_TEXTE("the transparency effect.")
  AIDE_TEXTE("")
  AIDE_TEXTE("Switches the Smear mode.")
  AIDE_TEXTE("")
  AIDE_TEXTE("")
  AIDE_TITRE("TILING")
  AIDE_TEXTE(" It consists in displaying parts of the")
  AIDE_TEXTE("brush that are adjusted on a   tiling when")
  AIDE_TEXTE("you are drawing. It's mainly used for")
  AIDE_TEXTE("quickly drawing a   background with a")
  AIDE_TEXTE("pattern, but there is a great number of")
  AIDE_TEXTE("other   possibilities.")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Switches the Tiling mode.")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Opens a menu where you can define the Tiling")
  AIDE_TEXTE("parameters. These parameters are the offsets")
  AIDE_TEXTE("of the tiling.")
};
static const char * TableAideTexte[] =
{
  AIDE_TITRE("TEXT")
  AIDE_TEXTE("   *** Not implemented yet ***")
};
static const char * TableAideLoupe[] =
{
  AIDE_TITRE("MAGNIFIER")
  AIDE_TEXTE("")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Engages/Disengages the choice of the zoomed")
  AIDE_TEXTE("window. If you're already in magnifier mode,")
  AIDE_TEXTE("you'll return to normal mode.")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Displays a menu where you can choose the")
  AIDE_TEXTE("magnifying factor.")
  AIDE_TEXTE("")
  AIDE_TEXTE(" Note: When you are in Zoom mode, you can")
  AIDE_TEXTE("move the \"split\" bar by   clicking on it and")
  AIDE_TEXTE("moving your mouse left or right while")
  AIDE_TEXTE("holding the mouse   button down.")
};
static const char * TableAidePipette[] =
{
  AIDE_TITRE("PIPETTE")
  AIDE_TEXTE("")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Engages a color grabbing.")
  AIDE_TEXTE("")
  AIDE_TEXTE("Click on the picture to get the color of the")
  AIDE_TEXTE("pixel you're on. You can either get a new")
  AIDE_TEXTE("Fore-color or Back-color with respectively")
  AIDE_TEXTE("left or right mouse button.")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Swap Fore-color and Back-color.")
  AIDE_TEXTE("")
  AIDE_TEXTE(" The color currently pointed will be")
  AIDE_TEXTE("displayed in the tool-bar right   after the")
  AIDE_TEXTE("coordinates. If you click outside the")
  AIDE_TEXTE("picture, the color 0 will be returned.")
};
static const char * TableAideResol[] =
{
  AIDE_TITRE("RESOLUTION AND")
  AIDE_TITRE(" IMAGE SIZE")
  AIDE_TEXTE("")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Displays a menu where you can define the")
  AIDE_TEXTE("size of your picture (up to 1024x768) by")
  AIDE_TEXTE("clicking in the boxes named \"Width\" and")
  AIDE_TEXTE("\"Height\"; and the resolution in which you")
  AIDE_TEXTE("want to draw (in the list).")
  AIDE_TEXTE("")
  AIDE_TEXTE("Clicking on a resolution button with the")
  AIDE_TEXTE("right mouse button will not only set the")
  AIDE_TEXTE("resolution of the screen, but also set the")
  AIDE_TEXTE("picture dimensions to the screen ones.")
  AIDE_TEXTE("")
  AIDE_TEXTE("Resolutions written in dark gray are VESA")
  AIDE_TEXTE("modes that aren't supported by your video")
  AIDE_TEXTE("card. If you have some modes like that, you")
  AIDE_TEXTE("should try to run a VESA driver such as")
  AIDE_TEXTE("Univesa or Univbe before running the")
  AIDE_TEXTE("program. If these modes still aren't")
  AIDE_TEXTE("available, then this means that your video")
  AIDE_TEXTE("card really doesn't support them.")
  AIDE_TEXTE("")
  AIDE_TEXTE("The small buttons on the left-hand side of")
  AIDE_TEXTE("the lines in the list of modes have been")
  AIDE_TEXTE("designed to allow you to disable some modes")
  AIDE_TEXTE("that are not supported by your card. So, the")
  AIDE_TEXTE("modes that you will disable won't be used")
  AIDE_TEXTE("when loading pictures with \"Auto-set")
  AIDE_TEXTE("resolution\" ON.")
  AIDE_TEXTE("")
  AIDE_TEXTE("When you click on one of these buttons, its")
  AIDE_TEXTE("color changes to one of the 4 following. The")
  AIDE_TEXTE("signification for each color of these")
  AIDE_TEXTE("buttons is:")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Light gray: The video mode is OK. It can")
  AIDE_TEXTE("be used by the auto-set resolution option")
  AIDE_TEXTE("when you load picture, and you can select it")
  AIDE_TEXTE("in the menu of resolutions.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- White: It works exactly the same as above.")
  AIDE_TEXTE("Moreover, it allows you to tag your")
  AIDE_TEXTE("favourite modes. Indeed, the huge number of")
  AIDE_TEXTE("video modes makes it more difficult to find")
  AIDE_TEXTE("the mode your want in the list; so you can")
  AIDE_TEXTE("tag your favoutite ones in white, so that it")
  AIDE_TEXTE("will be easier to locate them. (Note: you")
  AIDE_TEXTE("cannot disable the standard 320x200 mode)")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Dark gray: It allows you to indicate which")
  AIDE_TEXTE("modes are not really perfect (flickering,")
  AIDE_TEXTE("not centered, etc...) but which can be used")
  AIDE_TEXTE("even so. The difference with the light grey")
  AIDE_TEXTE("button is that these modes won't be used by")
  AIDE_TEXTE("the auto-set resolution option.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Black: Use it for totally unsupported")
  AIDE_TEXTE("modes. Thus, these modes won't be selected")
  AIDE_TEXTE("the \"auto-set res.\" and the program will")
  AIDE_TEXTE("prevent you from selecting them from the")
  AIDE_TEXTE("menu of resolutions.")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE(" Automaticaly switches to the 640x400 window")
  AIDE_TEXTE("mode.")
};
static const char * TableAidePage[] =
{
  AIDE_TITRE("SPARE")
  AIDE_TEXTE("")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Jumps to spare page. The current page is")
  AIDE_TEXTE("then considered as the new spare page, and")
  AIDE_TEXTE("the spare page considered as the new current")
  AIDE_TEXTE("page.")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Opens a menu where you can choose whether")
  AIDE_TEXTE("you want to copy the whole picture (keyboard")
  AIDE_TEXTE("short-cut in this menu is [Return]), only")
  AIDE_TEXTE("the pixels, only the palette, or only some")
  AIDE_TEXTE("colors.")
  AIDE_TEXTE("In this last case, a second menu")
  AIDE_TEXTE("(stencil-like) will propose you to tag the")
  AIDE_TEXTE("colors you want to copy (they are all")
  AIDE_TEXTE("selected by default).")
  AIDE_TEXTE("Please refer to section \"Stencil\" to know")
  AIDE_TEXTE("how to use this last menu.")
  AIDE_TEXTE("The last option the menu (\"Copy palette and")
  AIDE_TEXTE("remap\"), remaps the spare page with the")
  AIDE_TEXTE("current palette and replicates this palette")
  AIDE_TEXTE("to the spare page. This option is useful to")
  AIDE_TEXTE("quickly remap a picture with the palette of")
  AIDE_TEXTE("another.")
};
static const char * TableAideSauver[] =
{
  AIDE_TITRE("SAVE")
  AIDE_TEXTE("")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Displays a fileselector where the following")
  AIDE_TEXTE("options are available:")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Drives: Allow you to change the current")
  AIDE_TEXTE("drive. You can use <Alt>+ <Letter> to change")
  AIDE_TEXTE("drives too.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Format: Allows you to choose the file")
  AIDE_TEXTE("format you want. (PAL and KCF file formats")
  AIDE_TEXTE("are \"palette\" files).")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Filename: Allows you to give a new name to")
  AIDE_TEXTE("the picture. If no extension is given, the")
  AIDE_TEXTE("default (according to the format) will be")
  AIDE_TEXTE("used.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- File-list: Allows you to flick through the")
  AIDE_TEXTE("disk tree or to overwrite an existing file.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Delete: Allows you to delete the item")
  AIDE_TEXTE("under the selection bar. If the item is a")
  AIDE_TEXTE("directory, it must be empty to be removed.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Save: Saves the picture with the current")
  AIDE_TEXTE("filename, with the chosen format and with")
  AIDE_TEXTE("the current comment (for PKM files). If the")
  AIDE_TEXTE("current filename represents a directory,")
  AIDE_TEXTE("you'll enter it.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Comment (Txt): If you're using the PKM")
  AIDE_TEXTE("format, you can type in a comment on your")
  AIDE_TEXTE("picture.")
  AIDE_TEXTE("")
  AIDE_TEXTE("Note: The Backspace key brings you directly")
  AIDE_TEXTE("to the parent directory.     Type in the 1st")
  AIDE_TEXTE("letters of a filename you are looking for to")
  AIDE_TEXTE("access it faster.")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Save the current picture with its current")
  AIDE_TEXTE("filename, format and comment.")
  AIDE_TEXTE("")
  AIDE_TEXTE("If the file already exists, a confirmation")
  AIDE_TEXTE("box will appear.")
};
static const char * TableAideCharger[] =
{

  AIDE_TITRE("LOAD")
  AIDE_TEXTE("")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("This works the same way as Save.")
  AIDE_TEXTE("")
  AIDE_TEXTE("You'll have access in the format selector to")
  AIDE_TEXTE("a \"*.*\" filter. And of course, you won't be")
  AIDE_TEXTE("able to type in any comment.")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Reloads the picture.")
  AIDE_TEXTE("")
  AIDE_TEXTE("If you want to load a picture and that you")
  AIDE_TEXTE("haven't saved the last modifications of the")
  AIDE_TEXTE("current picture, a confirmation box will")
  AIDE_TEXTE("appear.")
};
static const char * TableAideParametres[] =
{
  AIDE_TITRE("SETTINGS")
  AIDE_TEXTE("")
  AIDE_TEXTE("Displays a menu where you can configure some")
  AIDE_TEXTE("miscellaneous elements of the program:")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Number of UNDO pages: indicates the total")
  AIDE_TEXTE("number of pages that GrafX2 will memorize.")
  AIDE_TEXTE("Each time you modify the picture, its")
  AIDE_TEXTE("current state is memorized in one of these")
  AIDE_TEXTE("pages. To flick through these pages, use the")
  AIDE_TEXTE("\"Oops\" button (Undo/Redo).")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Font: determines whether you want to use")
  AIDE_TEXTE("GrafX2 with a classical font, or another one")
  AIDE_TEXTE("a bit funnier.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Mouse sensibility: Modifies the speed of")
  AIDE_TEXTE("the mouse.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Show/Hide in file list: Defines whether")
  AIDE_TEXTE("some particular files or directories must be")
  AIDE_TEXTE("displayed by the fileselectors or not.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Show/Hide picture limits: Indicates if the")
  AIDE_TEXTE("picture boundaries must be displayed when")
  AIDE_TEXTE("you are in a resolution bigger than the")
  AIDE_TEXTE("picture.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Clear palette: Indicates if loading a file")
  AIDE_TEXTE("with a palette of less than 256 colors must")
  AIDE_TEXTE("erase the rest of the current palette")
  AIDE_TEXTE("(replace by the black color).")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Maximize preview: maximizes the preview of")
  AIDE_TEXTE("the pictures so that it is as big as")
  AIDE_TEXTE("possible. If you're not in the same")
  AIDE_TEXTE("resolution as the picture's one, it can try")
  AIDE_TEXTE("to correct the aspect ratio, but if the")
  AIDE_TEXTE("picture does not fill the whole screen, it")
  AIDE_TEXTE("can be worse.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Backup: when you'll save a picture over an")
  AIDE_TEXTE("existing file, the program will rename this")
  AIDE_TEXTE("file to \"*.BAK\" where * is the name of the")
  AIDE_TEXTE("picture without its extension. If the backup")
  AIDE_TEXTE("file already exists in the directory, it")
  AIDE_TEXTE("will be replaced. If you save a picture with")
  AIDE_TEXTE("the name of the backup file, no backup file")
  AIDE_TEXTE("will be created (of course!) ;).")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Cursor: allows you to choose whether you")
  AIDE_TEXTE("prefer a solid cursor or a transparent")
  AIDE_TEXTE("cursor.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Safety colors: Brings back the 4 default")
  AIDE_TEXTE("colors of the menus if you run an operation")
  AIDE_TEXTE("that passes the image in less than four")
  AIDE_TEXTE("colors in the palette editor.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Adjust brush pick: This option is used")
  AIDE_TEXTE("when you grab a brush in Grid (Snap) mode.")
  AIDE_TEXTE("Then, the right-most and down-most pixels")
  AIDE_TEXTE("won't be picked up with the rest of the")
  AIDE_TEXTE("brush. This option has been made because, if")
  AIDE_TEXTE("people grab brushes in Grid mode, that's")
  AIDE_TEXTE("mostly when they want to grab sprites. For")
  AIDE_TEXTE("example: if you have 16x16 sprites on your")
  AIDE_TEXTE("page, you'll set the grid mode to 16x16. But")
  AIDE_TEXTE("the cursor will snap at points like (0,0),")
  AIDE_TEXTE("(16,0), (16,16) and so on... And the problem")
  AIDE_TEXTE("is that, from (0,0) to (16,16), there are 17")
  AIDE_TEXTE("pixels! But if you keep the")
  AIDE_TEXTE("adjust-brush-pick option on, the unwanted")
  AIDE_TEXTE("pixels will be ignored. Moreover, this")
  AIDE_TEXTE("option adjusts the brush handle so that the")
  AIDE_TEXTE("brush still fits in the grid, instead of")
  AIDE_TEXTE("placing the handle in the center of the")
  AIDE_TEXTE("brush.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Separate colors: Draws a squaring around")
  AIDE_TEXTE("the colors of the tool-bar.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Auto-set resolution: sets the best")
  AIDE_TEXTE("resolution for the loaded image.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Coordinates: Choose if you want to display")
  AIDE_TEXTE("relative or absolute coordinates when using")
  AIDE_TEXTE("tools such as circles, rectangles, etc...")
  AIDE_TEXTE("for example, if you draw a circle: if coords")
  AIDE_TEXTE("are relative, the radius of the circle will")
  AIDE_TEXTE("be displayed, while in absolute coords, the")
  AIDE_TEXTE("coordinates of the cursor will be displayed.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Reload: loads the previously saved")
  AIDE_TEXTE("configuration.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Auto-save: means that the configuration")
  AIDE_TEXTE("will be automatically saved when you'll quit")
  AIDE_TEXTE("the program.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Save: saves the configuration at once.")
  AIDE_TEXTE(" All modifications will be effective just")
  AIDE_TEXTE("after closing the menu.")
};
static const char * TableAideClear[] =
{

  AIDE_TITRE("CLEAR")
  AIDE_TEXTE("")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Clears the picture with the color number 0.")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Clears the picture with the Back-color.")
};
static const char * TableAideAide[] =
{

  AIDE_TITRE("HELP STATS")
  AIDE_TEXTE("")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Displays an info window where you'll find")
  AIDE_TEXTE("some credits, help about the credits,")
  AIDE_TEXTE("different effects, greetings, registering...")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Displays a window where you'll find")
  AIDE_TEXTE("miscellaneous informations about the system.")
  AIDE_TEXTE(" Note: you should take care to keep more")
  AIDE_TEXTE("than 128 Kb in order to let the   program")
  AIDE_TEXTE("run in a proper way.")
};
static const char * TableAideUndo[] =
{

  AIDE_TITRE("OOPS")
  AIDE_TEXTE("(UNDO/REDO)")
  AIDE_TEXTE("LEFT CLICK Allows you to undo the last")
  AIDE_TEXTE("modification on the picture.")
  AIDE_TEXTE("RIGHT CLICK Allows you to redo the last")
  AIDE_TEXTE("modification undone on the         picture.")
  AIDE_TEXTE("The maximum number of UNDO that you can")
  AIDE_TEXTE("perform can be defined in the   settings")
  AIDE_TEXTE("menu.")
  AIDE_TEXTE("Undo/Redo aren't effective after page")
  AIDE_TEXTE("switching, picture loading and   picture")
  AIDE_TEXTE("size modifications.")
};
static const char * TableAideKill[] =
{

  AIDE_TITRE("KILL")
  AIDE_TEXTE("KILL CURRENT PAGE")
  AIDE_TEXTE("")
  AIDE_TEXTE("Removes the current page from the list of")
  AIDE_TEXTE("\"Undo\" pages. This allows you to free some")
  AIDE_TEXTE("memory if you need it. For instance, this")
  AIDE_TEXTE("will allow you to delete the start-up page")
  AIDE_TEXTE("after having loaded an image. A message will")
  AIDE_TEXTE("appear if you've already erased all the")
  AIDE_TEXTE("pages except the last one.")
  AIDE_TEXTE(" Note: Another way to free some memory is to")
  AIDE_TEXTE("decrease the number of   \"Undo\" pages. Or")
  AIDE_TEXTE("else, if you have recentlt grabbed a very")
  AIDE_TEXTE("big   brush that you don't use any more, you")
  AIDE_TEXTE("can grab a new smaller one.   The memory")
  AIDE_TEXTE("allocated by the big brush will be thus")
  AIDE_TEXTE("freed.")
};
static const char * TableAideQuit[] =
{

  AIDE_TITRE("QUIT")
  AIDE_TEXTE("")
  AIDE_TEXTE("Allows you to leave GrafX2. If there are")
  AIDE_TEXTE("unsaved modifications in the current or")
  AIDE_TEXTE("spare page, a confirmation box will ask you")
  AIDE_TEXTE("if you really want to quit GrafX2, if you")
  AIDE_TEXTE("want to save (Auto-save, no fileselector) or")
  AIDE_TEXTE("if you want to stay in GrafX2.")
};
static const char * TableAidePalette[] =
{

  AIDE_TITRE("PAL MENU")
  AIDE_TEXTE("")
  AIDE_TEXTE("Displays a menu where the following options")
  AIDE_TEXTE("are available:")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Palette: Allows you to choose a")
  AIDE_TEXTE("color-block to edit. If you click with the")
  AIDE_TEXTE("right mouse button, you'll choose a new")
  AIDE_TEXTE("Back-color.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- RGB gauges: Allow you to modify the")
  AIDE_TEXTE("current selection.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- \"+\" and \"-\": Allow you to lighten or")
  AIDE_TEXTE("darken the current selection.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Default: Restores the predifined GrafX2")
  AIDE_TEXTE("palette.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Gray: Transforms the current selection")
  AIDE_TEXTE("into its gray-scaled equivalent.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Negative: Transforms the current selection")
  AIDE_TEXTE("into its reverse video equivalent.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Invert: Swaps the colors of the current")
  AIDE_TEXTE("selection so that the first colors become")
  AIDE_TEXTE("the last ones.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- X-Invert: Works as above but modifies the")
  AIDE_TEXTE("picture so that it looks the same.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Swap: Swaps the current selection with")
  AIDE_TEXTE("another color-block. Click on the beginning")
  AIDE_TEXTE("of the new color-block.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- X-Swap: Works as above but modifies the")
  AIDE_TEXTE("picture so that it looks the same. This may")
  AIDE_TEXTE("be useful if you want to sort your palette.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Copy: Copies the current selection to")
  AIDE_TEXTE("another color-block. Click on the beginning")
  AIDE_TEXTE("of the new color-block.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Spread: Computes a gradation between two")
  AIDE_TEXTE("colors. If your selection is only made up of")
  AIDE_TEXTE("one color, select the second color in the")
  AIDE_TEXTE("palette. Otherwise, the two colors used will")
  AIDE_TEXTE("be its extremities.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Used: Indicates the number of colors used")
  AIDE_TEXTE("in the picture.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Zap unused: Erases the unused colors with")
  AIDE_TEXTE("copies of the current selection. (The")
  AIDE_TEXTE("keyboard shortcut for this button is <Del>).")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Reduce: Allows you to reduce the palette")
  AIDE_TEXTE("to the number of colors you want (and")
  AIDE_TEXTE("modifies the picture).")
  AIDE_TEXTE("")
  AIDE_TEXTE("- Undo: Allows you to recover the last")
  AIDE_TEXTE("modifications made on the palette. If the")
  AIDE_TEXTE("last operation modified the picture, it")
  AIDE_TEXTE("won't recover them: you'll have to click on")
  AIDE_TEXTE("Cancel to do so.")
  AIDE_TEXTE("")
  AIDE_TEXTE("")
  AIDE_TEXTE("If you press <Backspace>, the program will")
  AIDE_TEXTE("replace, as well as possible, some unused")
  AIDE_TEXTE("colors by the four default colors of the")
  AIDE_TEXTE("menu. The image won't look altered because")
  AIDE_TEXTE("the modified colors (in the case they were")
  AIDE_TEXTE("used on a few points) will be replaced by")
  AIDE_TEXTE("the closest colors in the rest of the")
  AIDE_TEXTE("palette. This option is really useful when")
  AIDE_TEXTE("you modify the palette so that there are no")
  AIDE_TEXTE("colors that fit for the menu (eg: \"Zap")
  AIDE_TEXTE("unused\" while very little colors are used in")
  AIDE_TEXTE("the picture; or \"Reduce\" with a very small")
  AIDE_TEXTE("number of colors).")
  AIDE_TEXTE("")
  AIDE_TEXTE("If you press the key below <Escape> or <,>")
  AIDE_TEXTE("(QWERTY), the menu will disappear and you")
  AIDE_TEXTE("will be able to pick up a color from the")
  AIDE_TEXTE("picture easily. Press <Escape> to cancel.")
  AIDE_TEXTE("")
  AIDE_TEXTE("If only one color is selected (not a block),")
  AIDE_TEXTE("the <[> and <]> keys can be used to select")
  AIDE_TEXTE("the previous or next Forecolor (Backcolor if")
  AIDE_TEXTE("you press <Shift> at the same time).")
  AIDE_TEXTE("")
  AIDE_TEXTE("Warning! If you press Undo after an action")
  AIDE_TEXTE("that modifies the picture (X-Swap, X-Invert")
  AIDE_TEXTE("and Reduce colors), the picture won't be")
  AIDE_TEXTE("remapped as it was just before this action.")
  AIDE_TEXTE("Only Cancel will.")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Opens a menu from where you can access the")
  AIDE_TEXTE("following menus:")
  AIDE_TEXTE("")
  AIDE_TEXTE("- A menu in which you can select the colors")
  AIDE_TEXTE("that have not to be used")
  AIDE_TEXTE("for smoothing, for the transparency mode and")
  AIDE_TEXTE("for remapping.")
  AIDE_TEXTE("")
  AIDE_TEXTE("- A menu in which you can define color")
  AIDE_TEXTE("series.")
  AIDE_TEXTE("*** Not implemented yet ***")
};
static const char * TableAidePalScroll[] =
{

  AIDE_TITRE("SCROLL PAL")
  AIDE_TEXTE("")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Scrolls the palette window in the right of")
  AIDE_TEXTE("the menu.")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Same as above, but faster.")
};
static const char * TableAideChoixCol[] =
{

  AIDE_TITRE("PALETTE")
  AIDE_TEXTE("")
  AIDE_BOLD ("LEFT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Defines the Fore-color.")
  AIDE_TEXTE("")
  AIDE_BOLD ("RIGHT CLICK")
  AIDE_TEXTE("")
  AIDE_TEXTE("Defines the Back-color.")
};
static const char * TableAideCacher[] =
{

  AIDE_TITRE("HIDE MENU")
  AIDE_TEXTE("")
  AIDE_TEXTE("Allows you to hide the menu. If you do this,")
  AIDE_TEXTE("take care to watch before the key to press")
  AIDE_TEXTE("to show the menu back (the default key is")
  AIDE_TEXTE("<F10>).")

};

#define DECLARATION_TABLE_AIDE(x) {x, sizeof(x)/sizeof(const char **)},

struct Section_d_aide Table_d_aide[] =
{
  DECLARATION_TABLE_AIDE(TableAideAbout)
  DECLARATION_TABLE_AIDE(TableAideLicense)
  DECLARATION_TABLE_AIDE(TableAideHelp)
  DECLARATION_TABLE_AIDE(TableAideCredits)

  // Attention, dans l'ordre de NUMEROS_DE_BOUTONS
  DECLARATION_TABLE_AIDE(TableAidePinceaux     )
  DECLARATION_TABLE_AIDE(TableAideAjuster      )
  DECLARATION_TABLE_AIDE(TableAideDessin       )
  DECLARATION_TABLE_AIDE(TableAideCourbes      )
  DECLARATION_TABLE_AIDE(TableAideLignes       )
  DECLARATION_TABLE_AIDE(TableAideSpray        )
  DECLARATION_TABLE_AIDE(TableAideFloodfill    )
  DECLARATION_TABLE_AIDE(TableAidePolygones    )
  DECLARATION_TABLE_AIDE(TableAidePolyfill     )
  DECLARATION_TABLE_AIDE(TableAideRectangles   )
  DECLARATION_TABLE_AIDE(TableAideFillRect     )
  DECLARATION_TABLE_AIDE(TableAideCercles      )
  DECLARATION_TABLE_AIDE(TableAideFillCerc     )
  DECLARATION_TABLE_AIDE(TableAideGradRect     )
  DECLARATION_TABLE_AIDE(TableAideGradMenu     )
  DECLARATION_TABLE_AIDE(TableAideSpheres      )
  DECLARATION_TABLE_AIDE(TableAideBrosse       )
  DECLARATION_TABLE_AIDE(TableAidePolybrosse   )
  DECLARATION_TABLE_AIDE(TableAideEffetsBrosse )
  DECLARATION_TABLE_AIDE(TableAideEffets       )
  DECLARATION_TABLE_AIDE(TableAideTexte        )
  DECLARATION_TABLE_AIDE(TableAideLoupe        )
  DECLARATION_TABLE_AIDE(TableAidePipette      )
  DECLARATION_TABLE_AIDE(TableAideResol        )
  DECLARATION_TABLE_AIDE(TableAidePage         )
  DECLARATION_TABLE_AIDE(TableAideSauver       )
  DECLARATION_TABLE_AIDE(TableAideCharger      )
  DECLARATION_TABLE_AIDE(TableAideParametres   )
  DECLARATION_TABLE_AIDE(TableAideClear        )
  DECLARATION_TABLE_AIDE(TableAideAide         )
  DECLARATION_TABLE_AIDE(TableAideUndo         )
  DECLARATION_TABLE_AIDE(TableAideKill         )
  DECLARATION_TABLE_AIDE(TableAideQuit         )
  DECLARATION_TABLE_AIDE(TableAidePalette      )
  DECLARATION_TABLE_AIDE(TableAidePalScroll    )
  DECLARATION_TABLE_AIDE(TableAidePalScroll    )
  DECLARATION_TABLE_AIDE(TableAideChoixCol     )
  DECLARATION_TABLE_AIDE(TableAideCacher       )
};
