/*
This is a Optical-Character-Recognition program designed for 
the Zune/MUI GUI-Toolkit by Christoph J. Szczecina [craid-haujobb]


This software is based on the GOCR package
Copyright (C) 2000 GOCR Team (Joerg Schulenburg) 


This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 
 */
 
 
#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include <string.h>
#include <sys/time.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "pnm.h"
#include "pgm2asc.h"
#include "pcx.h"
#include "ocr0.h"		/* only_numbers */
#include "zune-gocr.h"

// AROS
#include <exec/types.h>
#include <libraries/mui.h>
#include<clib/dos_protos.h>
#include <libraries/asl.h>

#include<clib/exec_protos.h>
#include<clib/asl_protos.h>

     
#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/muimaster.h>
#include <clib/alib_protos.h>

#include <datatypes/textclass.h>

#include <libraries/iffparse.h>

#include <proto/muimaster.h> 
#include <cybergraphx/cybergraphics.h>



/* the following line is used to name the package (make dist) */
#define version_string "0.39"



//---------------------------------------------------------------------------------------------------------
// clipboard routines
//---------------------------------------------------------------------------------------------------------


struct IFFHandle * clip = NULL;
 
 /*** Open the clipboard using iffparse library***/
static BOOL CBOpen(ULONG unit)
{
	extern struct Library * IFFParseBase;

	if( IFFParseBase != NULL && (clip = (APTR) AllocIFF() ) )
	{
		if( (clip->iff_Stream = (ULONG) OpenClipboard(unit)) )
		{
			InitIFFasClip(clip);

			return TRUE;
		}
		FreeIFF( clip );
	}
	//ThrowError(Wnd, ErrMsg(ERR_OPENCLIP));
	return FALSE;
}


/*** Close clipboard ***/
void CBClose( void )
{
	if( clip )
	{
		CloseClipboard( (APTR) clip->iff_Stream );
		FreeIFF(clip);
	}
}  


#define	STD_CLIP_UNIT     PRIMARY_CLIP

/*** Write strings to the clipboard.device ***/
BOOL CBWriteFTXT( char *clipboardtext)
{
	long  length = strlen( clipboardtext );

	/* If clipboard not already allocated, makes it now */
	if( clip == NULL && !CBOpen(STD_CLIP_UNIT) ) return FALSE;

	if( !OpenIFF(clip, IFFF_WRITE) )
	{
		/* Let iffparse manage main chunk size */
		if( !PushChunk(clip, ID_FTXT, ID_FORM, IFFSIZE_UNKNOWN) )
		{
			if( !PushChunk(clip, ID_FTXT, ID_CHRS, length) )
			{
                    // copy data to clipboard
					STRPTR stream;
					stream = (STRPTR)clipboardtext;
					WriteChunkBytes(clip, stream, length);
					
					//if(add_eol)
					//	WriteChunkBytes(clip, &eol, 1);
				
				    PopChunk(clip);
			}
			//else ThrowError(Wnd, ErrMsg(ERR_NOMEM));
			PopChunk(clip);
		}
		//else ThrowError(Wnd, ErrMsg(ERR_NOMEM));
		CloseIFF(clip);
	}
	
	// close clipboard again
	//CBClose();
	
	return TRUE;
}

//---------------------------------------------------------------------------------------------------------
// zune class stuff
//---------------------------------------------------------------------------------------------------------


unsigned int areaWidth = 0, areaHeight = 0;
unsigned int topEdge = 0, leftEdge = 0;

IPTR layerMinMax ( Class *CLASS, Object *self, struct MUIP_AskMinMax *message )
{
  message->MinMaxInfo->DefWidth = JOB->src.p.x;
  message->MinMaxInfo->MaxWidth = JOB->src.p.x;
  message->MinMaxInfo->DefHeight = JOB->src.p.y;
  message->MinMaxInfo->MaxHeight = JOB->src.p.y; 
  return 0;
}

// m0ns00n favourite DrawRectangle function!! :) greetigs!
/*void DrawRectangle ( ULONG x, ULONG y, ULONG w, ULONG height, struct RastPort r )
{
	int yp = y; for ( yp = 0 ;yp < y + height; yp++ )
	{
		int xp = x; for ( xp = 0 ;xp < x + w; xp++ )
		{
			if ( xp == x || yp == y || xp == x + w - 1 || yp == y + height - 1 )
				WritePixelArray ( r, xp, yp, ( ULONG )0xFFFFFFFFUL );  
		}
	}  
}*/

int selection_x1 = 0, selection_y1 = 0;
int selection_x2 = 0, selection_y2 = 0;
int buttondown;
char tempstring[255];

void DrawRectangle ( ULONG x, ULONG y, ULONG w, ULONG height, Object *bitmap)
{
    int yp = 0;
    for ( yp = y; yp < height; yp++ )
	{
        int xp = 0;
        for ( xp = x; xp < w; xp++ )
		{
			if ( xp == x || yp == y || xp == w - 1 || yp == height - 1 )
				//WritePixelArray ( _rp ( bitmap ), xp, yp, ( ULONG )0xFFFFFFFFUL );  
				WriteRGBPixel ( _rp ( bitmap ), xp, yp, ( ULONG )0x0000FFF0UL );  
				
		}
	}  
}

IPTR RGBitmapHandleInput ( Class *CLASS, Object *self, struct MUIP_HandleInput *message )  
{ 
/*     //MUIKEY_PRESS
  if (  )
  {
   set(status, MUIA_Text_Contents, (IPTR)message->imsg->MouseX); //message->imsg->MouseX;
  }*/
  struct Window *win = NULL; get ( imagewnd, MUIA_Window_Window, &win );
  
    switch (message->imsg->Class)
    {
      case IDCMP_RAWKEY:
      {
      }
      case IDCMP_MOUSEBUTTONS:
      {
           if(message->imsg->Code == SELECTDOWN) // Pressed
           {
                   if (buttondown != 1)
                   {
                        buttondown = 1;
                        selection_x1 = message->imsg->MouseX - ( int )win->BorderLeft;// + win->XOffset; //- ( int )win->LeftEdge;
                        selection_y1 = message->imsg->MouseY - ( int )win->BorderTop;;// + win->YOffset; //- ( int )win->TopEdge; 
                        //set(status, MUIA_Text_Contents, (IPTR)message->imsg->MouseX); //message->imsg->MouseX;
                   }
                   
                   //DrawRectangle(selection_x1,selection_y1,message->imsg->MouseX,message->imsg->MouseY, bitmap );
                   //DoMethod(self, MUIM_Draw, MADF_DRAWUPDATE);
           }
           else if(message->imsg->Code == SELECTUP)
           {
                   buttondown = 0;
                   
                   // change values if needed
                   if (message->imsg->MouseX < selection_x1)
                   {
                         selection_x2 = selection_x1;           
                         selection_x1 = message->imsg->MouseX  - ( int )win->BorderLeft;// -  data->arealeft;
                   }
                   else selection_x2 = message->imsg->MouseX - ( int )win->BorderLeft; //-  ( int )win->LeftEdge;
                   
                   // change values if needed
                   if (message->imsg->MouseY < selection_y1)
                   {
                         selection_y2 = selection_y1;           
                         selection_y1 = message->imsg->MouseY - ( int )win->BorderTop;; //- ( int )win->TopEdge; 
                   }
                   else selection_y2 = message->imsg->MouseY - ( int )win->BorderTop;; //- ( int )win->TopEdge;                                   
                   
                   //DrawRectangle(selection_x1,selection_y1,selection_x2,selection_y2, bitmap );
                   sprintf(tempstring, "\33cArea selected: %d, %d, %d, %d", selection_x1,selection_y1,selection_x2,selection_y2);
                   set(status, MUIA_Text_Contents, (IPTR)tempstring); 
                   
                   DoMethod(self, MUIM_Draw, MADF_DRAWUPDATE);
           }
      }
      
    }     
  return 0;
}



BOOPSI_DISPATCHER ( IPTR, YourClass, CLASS, self, message )
{
  switch ( message->MethodID )
  {
    case MUIM_Setup:
      MUI_RequestIDCMP( self, IDCMP_MOUSEBUTTONS | IDCMP_MOUSEMOVE | IDCMP_RAWKEY );
      return DoSuperMethodA ( CLASS, self, message ); 
 
    case MUIM_Draw:
         
 
          get ( bitmap, MUIA_Width, &areaWidth );
          get ( bitmap, MUIA_Height, &areaHeight );
          get ( bitmap, MUIA_TopEdge, &topEdge );
          get ( bitmap, MUIA_LeftEdge, &leftEdge );
            //  WritePixelArray ( job->src.p.p, 0, 0, areaWidth * 4,
            //         _rp ( WidgetLayers ), leftEdge, topEdge, areaWidth, areaHeight, RECTFMT_RGBA);
            
            
               WritePixelArray ( JOB->src.p.p, 0, 0, JOB->src.p.x * 1,
                     _rp ( bitmap ), leftEdge, topEdge, areaWidth, areaHeight, RECTFMT_GREY8);
                 
                 
               // draw selection if selected      
               if ( (selection_x2 > 0) && (selection_y2 > selection_y1) && (selection_x2 > selection_x1) ) 
               {
                       struct Window *win = NULL; get ( imagewnd, MUIA_Window_Window, &win );
                        
                       DrawRectangle(selection_x1+(int)win->BorderLeft,selection_y1+(int)win->BorderTop,selection_x2+(int)win->BorderLeft,selection_y2+(int)win->BorderTop, bitmap );
               }             
                     
      return 0;   

    case MUIM_HandleInput: //MUIM_HandleEvent:
         DoSuperMethodA ( CLASS, self, message );
         return ( IPTR )RGBitmapHandleInput ( CLASS, self, ( struct MUIP_HandleInput *)message );  
 

    case MUIM_AskMinMax:
      DoSuperMethodA ( CLASS, self, message );
      return ( IPTR )layerMinMax ( CLASS, self, ( struct MUIP_AskMinMax * )message );
 
    default:
      return DoSuperMethodA ( CLASS, self, message );
  }
  return 0;
}
BOOPSI_DISPATCHER_END	

//---------------------------------------------------------------------------------------------------------
// routines from "gocr.cpp"
//---------------------------------------------------------------------------------------------------------

int read_picture(job_t *job) {
  assert(job);

  if (strstr(job->src.fname, ".pcx"))
  {
    readpcx(job->src.fname, &job->src.p, job->cfg.verbose);
  }
  else if ( strstr(job->src.fname, ".jpg") || strstr(job->src.fname, ".jpeg") )
  {
    if (readjpg(job->src.fname, &job->src.p, job->cfg.verbose) == 0) return 1;
  }
  else
  {
#ifdef HAVE_PNM_H
    readpnm(job->src.fname, &job->src.p, job->cfg.verbose);
#else
    readpgm(job->src.fname, &job->src.p, job->cfg.verbose);
#endif
   }


    return 0;
} 

//- get output string---------------------------------craid^hjb--

//char output[2000];  // erstes zeichen = 0 -> string ende
char *output;
char *outputtemp;
    	
void get_output_string(job_t *job)
{
    const char *outputline;  // erstes zeichen = 0 -> string ende
    
	assert(job);

	int linecounter = 0;
	outputline = getTextLine(linecounter++);

	while (outputline)
	{        
        // check for bufferend                                  
        if (outputtemp + (strlen(outputline)) >= outputtemp + OCR_LISTBUFFERSIZE )    
        {
           set(status, MUIA_Text_Contents, (IPTR)"\33cListbuffer full, please clear!");
           break;
        }
        else
        {                         
    		strcat(outputtemp, outputline);
    		strcat(outputtemp, "\n");
    		
  		
        }
      
		outputline = getTextLine(linecounter++);	
	}
    
    // copy recognized string to clipboard
    CBWriteFTXT(outputtemp);
    
    // copy entry to mui list        
    DoMethod(list, MUIM_List_Insert, (IPTR)&outputtemp, 1, MUIV_List_Insert_Bottom);
            
    // outputtemp (output) used as stack, "+1" to skip zerotermination       
    outputtemp = outputtemp + (strlen(outputtemp)) + 1 ;  
    
	free_textlines();
 
	//return output; //output;
}

//- cut area------------------------------------------craid^hjb--

int cut_bitmap(job_t *job) 
{
	int error = 0;
	unsigned char *pic;
	unsigned char *newpic;

    
 

	// check if x_start or y_start wrong
	if ( (job->src.p.x < x_start) || (job->src.p.y < y_start) )
	{
		return(5);
	}
	// check if range is too big
	if ((((job->src.p.x)-x_start) < x_length) || (((job->src.p.y)-y_start) < y_length))
	{
		return(4);
	}
	// check if range = 0
	if (((x_start > 0) && (y_start > 0)) && ((x_length == 0) || (y_length == 0)) )
	{
		return(3);
	}

	// check if length arguments were not set
	if (x_length == 0) { x_length = (job->src.p.x)-x_start; }
	if (y_length == 0) { y_length = (job->src.p.y)-y_start; }


	// mem for NEW grayscale bitmap
	newpic=(unsigned char *)malloc( x_length*y_length );	// alloc mem for x*y pixels

	// ERROR: no memory
	if(newpic==NULL) return(2);			

	pic = (job->src.p.p);	

	int x,y,i;
	i = 0;
	
	// loop cuts bitmap
	for (y = y_start; y < (y_start+y_length); y++) 
	{
		for (x = x_start; x < (x_start+x_length); x++) 
		{
			// save (rgb)r-channel as grayscale to pic buffer
			newpic[i++] = pic[x+(y*(job->src.p.x))];     //x_length];

		}
	
	}

	// free old bitmap memory
	free( (job->src.p.p) );

	// set NEW bitmap values for gocr
	(job->src.p.p)=newpic; (job->src.p.x)=x_length; (job->src.p.y)=y_length;// p->bpp=1;  // (bpp ????????????)

	return error;
}


//- cut spaces from string----------------------------craid^hjb--

char* kill_spaces(char *in_str)
{
		char *string;
		unsigned int i,n = 0;

		string = (char *) malloc( (strlen(in_str)) );

		for (i = 0; i < (strlen(in_str)); i++)
		{
			if ( (in_str[i]) != 32) 
			{
				string[n++] = in_str[i];
			}
		}

		// add termination char
		string[n++] = 0;

		free(in_str);

		return string;
}


//=========================================================================================================
// MAIN
//=========================================================================================================

#define OPEN     44
BOOL running = TRUE;

char filename[255];
job_t job;
   
   
   
static VOID fail(APTR APP_Main,char *str)
{
  if (APP_Main)
    MUI_DisposeObject(APP_Main);
  if (MUIMasterBase)
    CloseLibrary(MUIMasterBase);
  if (str)
  { puts(str);
    exit(20);
  }
  exit(0);
}    
static VOID init(VOID)
{
  //APP_Main = NULL;
  if (!(MUIMasterBase = (struct Library *) OpenLibrary(MUIMASTER_NAME,MUIMASTER_VMIN-1)))
    fail(NULL,"Failed to open "MUIMASTER_NAME".");
}
 
 
Object *YourObject;

/*
** Convetional GadTools NewMenu structure, a memory
** saving way of definig menus.
*/

#define ID_ABOUT  1
#define ID_OPEN 2
#define ID_HIDE 3
#define ID_SCAN 4
#define ID_CLEAR  8
#define ID_COPY  9
#define ID_CROP  10

struct NewMenu Menu[] =
{
	{ NM_TITLE, "Project"  , 0 ,0,0,(APTR)0            },
	{ NM_ITEM , "Open image" ,"O",0,0,(APTR)ID_OPEN     },
	{ NM_ITEM , "Scan area" ,"S",0,0,(APTR)ID_SCAN     },	
//	{ NM_ITEM , "Take Screenshot" ,"S",0,0,(APTR)ID_OPEN     },
	{ NM_ITEM , NM_BARLABEL, 0 ,0,0,(APTR)0            },
	{ NM_ITEM , "About..." ,"?",0,0,(APTR)ID_ABOUT     },
	{ NM_ITEM , NM_BARLABEL, 0 ,0,0,(APTR)0            },
	{ NM_ITEM , "Hide" ,"H",0,0,(APTR)ID_HIDE     },
	{ NM_ITEM , "Quit"     ,"Q",0,0,(APTR)MUIV_Application_ReturnID_Quit },
	{ NM_TITLE, "Edit"      , 0 ,1,0,(APTR)0            },	
	{ NM_ITEM , "Clear"      ,"X",0,0,(APTR)ID_CLEAR     },
	{ NM_ITEM , "Copy"      ,"C",0,0,(APTR)ID_COPY     },
	{ NM_ITEM , NM_BARLABEL, 0 ,0,0,(APTR)0            },
	{ NM_ITEM , "Crop selection"      ,"Y",0,0,(APTR)ID_CROP     },
	{ NM_END  , NULL       , 0 ,0,0,(APTR)0            },
};

      
int main(int argn, char *argv[]) 
{

 struct Library *AslBase=0;
 init(); 
   
         Object *wnd, *app, *buttonload, *buttonscan, *aboutokbutton;
  
         // init string buffer for list
 	     output = (char *) malloc( OCR_LISTBUFFERSIZE ); 
 	     memset( output, '\0', sizeof(output) ); 
 	     outputtemp = output;
         	
         struct MUI_CustomClass *YourObject = MUI_CreateCustomClass (
                NULL, MUIC_Area, NULL, 0, YourClass
         );
        
         // GUI creation
         app = ApplicationObject,
     		MUIA_Application_Title         , "ZuneGOCR",
    		MUIA_Application_Version       , "$VER: ZuneGOCR v"zunegocr_version,
    		MUIA_Application_Copyright     , "Copyright 2006, craid-hjb",
    		MUIA_Application_Author        , "Christoph Johann Szczecina",
    		MUIA_Application_Description   , "Optical-Character-Recognition program.",
    		MUIA_Application_Base          , "ZUNEGOCR",
    		MUIA_Application_Menustrip     , MUI_MakeObject(MUIO_MenustripNM,Menu,0),
    		
             SubWindow, wnd = WindowObject,
                 MUIA_Window_Title, "ZuneGOCR v"zunegocr_version" by Resistance",
                 MUIA_Window_Width, 320,
                 MUIA_Window_Height, 256,
                 WindowContents, VGroup,
                   
                     Child, list = ListviewObject,
                       MUIA_Listview_List, ListObject,
                          InputListFrame,
                          //MUIA_List_AdjustWidth, TRUE,
                          //MUIA_List_SourceArray, KeyList,
                          End,
                       End,
 

          
                     Child, status = TextObject,
                        MUIA_Text_Contents, "\33cWelcome to ZuneGOCR!",
                        End,
                     
                     Child, buttonload = SimpleButton("_Open image"),
                     Child, buttonscan = SimpleButton("_Scan area"),
                     //End,                      

                     //Child, but = SimpleButton("_Screenshot"),
                     //End, 

                     //Child, but = SimpleButton("_Hide"),
                     //End, 
                            
                   End,
                 End,
                 
             SubWindow, imagewnd = WindowObject,
                 //MUIA_Window_Title, "iamge",
                 MUIA_Window_Width, 1000,
                 MUIA_Window_Height, 1000,
                 MUIA_Window_CloseGadget, FALSE,      
                 //MUIA_Window_LeftEdge, 0,
                 //MUIA_Window_TopEdge, 400,           
                 WindowContents, VGroup,
                      
                    Child, bitmap = NewObject (
                      YourObject->mcc_Class, NULL, 
                      TAG_DONE
                    ),   

            
                End,
             End,
              
             SubWindow, aboutwnd = WindowObject,
                 MUIA_Window_Title, "About..",
                 MUIA_Window_Width, 320,
                 MUIA_Window_Height, 256,
                 MUIA_Window_CloseGadget, FALSE,  
                 MUIA_Window_SizeGadget, FALSE,
                 MUIA_Window_DepthGadget, FALSE, 
                 MUIA_Window_ZoomGadget, FALSE,
                 //MUIA_Window_IsSubWindow, TRUE,    
                 //MUIA_Window_LeftEdge, 0,
                 //MUIA_Window_TopEdge, 400,           
                 WindowContents, VGroup,
                            
                     Child, MUI_MakeObject(MUIO_BarTitle, (IPTR)("Welcome to ZuneGOCR v"zunegocr_version" !") ),
                     //Child, aboutokbutton = SimpleChainedButton("\033l\33n\0332        \33b. .  . . .  . . . . . .  \n                           \33n z\33b :                        \33nn           \n\33b      __________ \33b:       . . . . . . . . \33b/_________\33ne\33b: : : : : : : : : : : : : : \33b\n         /                   /\33b:       :          . : : \33b                    / \33b: : . . . . . . . : : : : : : \33b      \n\33b         ----------------\33n'   \33b-\33nu\33b:\33nuuu\33b--------/_______/ \33b : : . \n                              :       : \33n \n             ===== \33bG\33b : : : : : \33bO\33n ===== \33bC\33n ===== \33bR\33n =====\n"),                                               
                     

 
                    Child, TextObject,
                        MUIA_Font, MUIV_Font_Fixed,
                        MUIA_Text_Contents, "\n  .. ... ......\n              z:            n\n   __________ :   ......../_________e::::::::::::::\n    /        /:   :    .::         /::.......::::::  \n    ----------' -u:uuu----/_______/ ::. \n              :   :                   \n      ===== G ::::: O ===== C ===== R =====\n\n",         
                        End,
                     
                     Child, MUI_MakeObject(MUIO_BarTitle, (IPTR)("Credits") ),
                     Child, TextObject,
                        MUIA_Text_Contents, "\0338\n\33c\33nCopyright  2006, Christoph J. Szczecina and the GOCR team.\nReleased under the terms of the \33iGNU General Public License\33n.\n\n\33c\33n icon: d980 - ascii: chosenf\n",
                        End,
                                                
                     Child, aboutokbutton = SimpleButton("_Ok"),             
  
                     End,
                     
                End,
                                                  
             End;
     
    
         
         if (app != NULL)
         {
             ULONG sigs = 0;
             
             // Click Close gadget or hit Escape to quit
       DoMethod(wnd, MUIM_Notify, MUIA_Window_CloseRequest, TRUE,
                      (IPTR)app, 2,
                      MUIM_Application_ReturnID, MUIV_Application_ReturnID_Quit);
     /*
         DoMethod(wnd,MUIM_Notify,
           MUIA_Window_CloseRequest, TRUE,
           (IPTR)app,3,MUIM_Set,MUIA_Window_Open,0); */
     
 /*
    DoMethod(wnd, MUIM_Notify, MUIA_Window_CloseRequest, TRUE,
	app, 3, MUIM_Set, MUIA_Application_Iconified, TRUE); */
    

               // Click the button to quit
             DoMethod(aboutokbutton, MUIM_Notify, MUIA_Pressed, FALSE,
                      (IPTR)app, 2,
                      MUIM_Application_ReturnID, ID_ABOUT); 
                                       
             // Click the button to quit
             DoMethod(buttonload, MUIM_Notify, MUIA_Pressed, FALSE,
                      (IPTR)app, 2,
                      MUIM_Application_ReturnID, ID_OPEN);
   
             DoMethod(buttonscan, MUIM_Notify, MUIA_Pressed, FALSE,
                      (IPTR)app, 2,
                      MUIM_Application_ReturnID, ID_SCAN);
                           
             // Open the window
             set(wnd, MUIA_Window_Open, TRUE);
     
             LONG  returnid;
             
             // Check that the window opened
             if (XGET(wnd, MUIA_Window_Open))
             {
                 
                  int error_value = 666;
                  UBYTE copytemp[5000];
                  UBYTE *copytempptr = copytemp;
                                                    
                // while((LONG)DoMethod(app, MUIM_Application_NewInput, (IPTR)&sigs) != MUIV_Application_ReturnID_Quit)                     
                  while (running) 
                  {
                
                        LONG result;
                        int checkopen;
                                       
                        LONG id = MUIV_List_NextSelected_Start;
                        
                        returnid = (LONG) DoMethod(app, MUIM_Application_NewInput, (IPTR) &sigs);
                        
                        if (returnid == MUIV_Application_ReturnID_Quit) break;
                        
                        //switch ( (LONG)DoMethod(app,MUIM_Application_NewInput,(IPTR)&sigs) ) 
                        switch(returnid)
                        {
                
                                case MUIV_Application_ReturnID_Quit:
                                     running = FALSE;
                                     break;
                                     
                                case ID_ABOUT:
                                       
                                     // check if aboutwindow already open          
                                     get ( aboutwnd, MUIA_Window_Open, &checkopen );
                                     
                                     if (!checkopen)
                                     {
                                        set(aboutwnd, MUIA_Window_Open, TRUE);
                                     }
                                     else
                                     {
                                         set(aboutwnd, MUIA_Window_Open, FALSE);
                                     }
                                     break;
                                     
                                     
                                case ID_HIDE:
                                     set(app, MUIA_Application_Iconified, TRUE);
                                     break;
                                     
                                case ID_CLEAR:
                                     DoMethod(list, MUIM_List_Clear);
                          	         memset( output, '\0', sizeof(output) ); 
 	                                 outputtemp = output;
                                     break;

                                case ID_COPY:
                                     // set to first selected entry
                                     id = MUIV_List_NextSelected_Start;
                            
                                     // get number of selectred entry 
                                     DoMethod(list,MUIM_List_NextSelected,&id);
                                             
                                     // get entry                             
                                     DoMethod(list,MUIM_List_GetEntry,id,&copytempptr);
                                     if (!fib) break;
                                     
                                     // copy to vlipboard
                                     CBWriteFTXT( (APTR)copytempptr ); 
                                     
                                     set(status, MUIA_Text_Contents, (IPTR)"\33cCopied selected item to clipboard.");
                                     

                                     break;
                                                                          
                                case ID_OPEN:
                                     // open lib   
                                     
                                     AslBase=OpenLibrary("asl.library",40L);
                                                                                                             
                                      // Allocate file requesters
                                      open_req = (struct FileRequester *)MUI_AllocAslRequestTags(ASL_FileRequest,
                                                  ASLFR_Window, NULL,//(ULONG)wnd,//(ULONG)PrefsWnd,
                                                  ASLFR_SleepWindow, FALSE, //TRUE,
                                                  ASLFR_TitleText, (ULONG)"ZUNE-GOCR: Open Image..",
                                                  ASLFR_RejectIcons, TRUE,
                                                  TAG_DONE);       
                                    
                                      // init filename to NULL
                                      open_req->fr_File = NULL;   
                                      
                                      // open requester
                                      MUI_AslRequest(open_req, NULL); 
 
                                      // check for no file selected, and display image
                                      if (open_req->fr_File == NULL) set(status, MUIA_Text_Contents, (IPTR)"\33cNo file chosen!");
                                      else
                                      {  
                                         // get full filename  
                                         strcpy( filename, open_req->fr_Drawer);  
                                         strcat( filename, open_req->fr_File); 
                                         //strcpy( filename, "ocr-a.pcx");  
                                      
                                         //printf("%s%s",open_req->fr_Drawer, open_req->fr_File);  
                                         //printf("%s",filename);  
                                         set(imagewnd, MUIA_Window_Title, (IPTR)filename);
                                         
                                         
                                         //------------------------------------
                                          // GOCR START!!!!!!!!!
                                          JOB = &job;
                                          
                                          
                                          // free old job
                                          set(imagewnd, MUIA_Window_Open, FALSE);
                                          job_free(&job);   
                                                                                                                          
                                          job_init(&job);
                                          
                                          // init job from arguments
                                          job.src.fname = filename;
                                          job.cfg.verbose = 0;
                                                                                  
                                          // read picture
                                          //set(status, MUIA_Text_Contents, (IPTR)"\33cReading image..");
                                          error_value = read_picture(&job);
                                           
                                          // call GOCR main loop   
                                          if (error_value == 0)
                                          {                                       
                                              // open image window - STILL BUGGGYY
                                              set(imagewnd, MUIA_Window_Open, TRUE);
                                              set(imagewnd, MUIA_Window_Height, JOB->src.p.x);
                                              set(imagewnd, MUIA_Window_Width, JOB->src.p.y);
                                              //set(imagewnd, MUIA_MaxHeight, JOB->src.p.x);
                                              //set(imagewnd, MUIA_MaxWidth, JOB->src.p.y);
                                              
                                              //DoMethod(wnd,MUIM_Window_ToFront);
                                                                                            
                                              set(status, MUIA_Text_Contents, (IPTR)"\33cReady.");                                              
                                          }
                                          else set(status, MUIA_Text_Contents, (IPTR)"\33cError reading picture.");
                                          
                                      }
                                         
                                      // close lib
                                      if (AslBase) CloseLibrary(AslBase);
                                      
                                      // free
                                      MUI_FreeAslRequest(open_req);      
                                                                        
                                      break;

                                case ID_CROP: 
                                      if (error_value == 666)
                                      {
                                         set(status, MUIA_Text_Contents, (IPTR)"\33cNo image opened!");
                                         break;
                                      }
            
                                      // if special area selected, copy area first   
                                      if ( (selection_x2 > 0) && (selection_y2 > selection_y1) && (selection_x2 > selection_x1) ) 
                                      {    
                                               
                                                                                    
                                          x_start = selection_x1; y_start = selection_y1;
                                           x_length = (selection_x2 - selection_x1);
                                           y_length = (selection_y2 - selection_y1);
                                           
                                           
                                           set(imagewnd, MUIA_Window_Open, FALSE);
                                           
                                          if (cut_bitmap(&job) != 0)
                                           {
                                                       set(status, MUIA_Text_Contents, (IPTR)"\33cCut error..");
                                                       break;
                                           }
                                            
                                           selection_x1 = 0; selection_y1 = 0; selection_x2 = 0; selection_y2 = 0;
                                                                
                                          // open image window - STILL BUGGGYYY
                                          set(imagewnd, MUIA_Window_Open, TRUE);
                                          set(imagewnd, MUIA_Window_Height, JOB->src.p.x);
                                          set(imagewnd, MUIA_Window_Width, JOB->src.p.y);   
                                          //set(imagewnd, MUIA_MaxHeight, JOB->src.p.x);
                                          //set(imagewnd, MUIA_MaxWidth, JOB->src.p.y);                                                                                       
                                          //set(imagewnd, MUIA_Window_Open, TRUE);
                                          
                                      }
                                      else
                                      {
                                          set(status, MUIA_Text_Contents, (IPTR)"\33cNo selection made!");
                                      }
                                      break;
                                                                             
                                case ID_SCAN:        
                                           
                                          if (error_value == 666)
                                          {
                                             set(status, MUIA_Text_Contents, (IPTR)"\33cNo image opened!");
                                             break;
                                          }
                                          else if (error_value != 0)
                                          {
                                             set(status, MUIA_Text_Contents, (IPTR)"\33cError reading picture.");
                                             break;
                                          }
            
                                          // if special area selected, copy area first   
                                          if ( (selection_x2 > 0) && (selection_y2 > selection_y1) && (selection_x2 > selection_x1) ) 
                                          {    
 
                                               pix oldpic;
                                               pix newpic;
                                               pix temppic;
                                                                                             
                                               oldpic = (job.src.p);
                                               
                                               // allocate new picture space
                                               newpic.p =(unsigned char *)malloc( (selection_x2 - selection_x1) * (selection_y2 - selection_y1) * 1);
                                               newpic.x = (selection_x2 - selection_x1); newpic.y =(selection_y2 - selection_y1);
                                               newpic.bpp = 1;

                                               temppic.p =(unsigned char *)malloc( (selection_x2 - selection_x1) * (selection_y2 - selection_y1) * 4);                                               
                                               
                                               // status   
                                               set(status, MUIA_Text_Contents, (IPTR)"\33cScanning selected area..");
                                             
                                               //break;
                                                
                                               set(imagewnd, MUIA_Window_Open, FALSE);
                                                                                           
                                               //ULONG ReadPixelArray( APTR dst, UWORD destx, UWORD desty, UWORD dstmod, struct RastPort * rp, UWORD srcx, UWORD srcy, UWORD width, UWORD height, UBYTE dstformat );
                                               //WritePixelArray ( JOB->src.p.p, 0, 0, JOB->src.p.x * 1,_rp ( bitmap ), leftEdge, topEdge, areaWidth, areaHeight, RECTFMT_GREY8);     
                                               ReadPixelArray ( newpic.p, 0, 0, 640 * 3,
                                                          _rp ( bitmap ), selection_x1, selection_y1, (selection_x2 - selection_x1), (selection_y2 - selection_y1), RECTFMT_GREY8);
                                                          //_rp ( bitmap ), 10, 10, 10, 10, RECTFMT_ARGB);



                                        		// "convert" file to "grayscale"  :))
                                        /*		int x,y;
                                        
                                        		double luminance;
                                        
                                        
                                        		for (y = 0; y < newpic.y ; y++) 
                                        		{
                                        
                                        			for (x = 0; x < newpic.x ; x++) 
                                        			{
                                        
                                        				// get the rgb-values of the two pixels (bitmap a & b) at position x,y
                                        
                                        				unsigned char *pixel_a=temppic.p+y*3+(x<<1)+x;
                                        				// get luminance
                                        				luminance = (0.3*(pixel_a[0])) + (0.59*(pixel_a[1])) + (0.11*(pixel_a[2]));
                                        				// save (rgb)r-channel as grayscale to pic buffer
                                        				newpic.p[x+newpic.x*y] = (unsigned char) luminance;
                                        			}
                                        		}*/
                                        
                                                 
                                              // update image data
                                              (job.src.p.p) = newpic.p;                                              
                                              (job.src.p.x) = newpic.x;
                                              (job.src.p.y) = newpic.y; 
                                              (job.src.p.bpp) = 1;
  
                                               // open image window - STILL BUGGGYYY
                                              set(imagewnd, MUIA_Window_Height, JOB->src.p.x);
                                              set(imagewnd, MUIA_Window_Width, JOB->src.p.y);   
                                              //set(imagewnd, MUIA_MaxHeight, JOB->src.p.x);
                                              //set(imagewnd, MUIA_MaxWidth, JOB->src.p.y);                                                                                       
                                              set(imagewnd, MUIA_Window_Open, TRUE);
                                                                                            
                                               // start image parsing 
                                               set(status, MUIA_Text_Contents, (IPTR)"\33cScanning image..");
                                               pgm2asc(&job);
                                                                                          
    
                                               set(status, MUIA_Text_Contents, (IPTR)"\33cReady.");             
                                               get_output_string(&job); 
                                               
                                               //(job.src.p) = oldpic;    
                                                                                          
                                               break;
                                           }  
             
                                              

                                  
/*
	unsigned char *pic;
	unsigned char *newpic;

    
 

	// mem for NEW grayscale bitmap
	newpic=(unsigned char *)malloc( x_length*y_length );	// alloc mem for x*y pixels

	// ERROR: no memory
	if(newpic==NULL) return(2);			

	pic = (job->src.p.p);	


	// free old bitmap memory
	free( (job->src.p.p) );

	// set NEW bitmap values for gocr
	(job->src.p.p)=newpic; (job->src.p.x)=x_length; (job->src.p.y)=y_length;// p->bpp=1;  // (bpp ????????????)

*/



          
                                          // start image parsing 
                                          set(status, MUIA_Text_Contents, (IPTR)"\33cScanning image..");
                                          pgm2asc(&job);
                                                                                      

                                          set(status, MUIA_Text_Contents, (IPTR)"\33cReady.");             
                                          get_output_string(&job);                    
              
                                     break;
                
                
                             /*   case MEN_ABOUT:
                                     MUI_RequestA(app,window,0,"About ASCIImui","*OK",about_text,NULL);
                                     break;*/
                
                            /*   case MEN_QUIT:
                                     result=MUI_RequestA(app,0,0,"Quit","_Quit|_Cancel","\33cAre you sure you want\nto quit ASCIImui?",0);
                                        if(result==1)
                                           running=FALSE;
                                    break;*/
                
                
                        } // end switch
                
                         if (sigs)
                         {
                             sigs = Wait(sigs | SIGBREAKF_CTRL_C);
                             if (sigs & SIGBREAKF_CTRL_C)
                                 break;
                         }
                                     
                        //if (running && sigs) Wait(sigs); 
                    
                    } // end while
                     
                     
              }  // end if
                     
             // Destroy our application and all its objects
             MUI_DisposeObject(app);
             
             free(output);
             job_free(&job);   
         }
         
         return 0;
       
     
}
