/*
 * Copyright (C) 1997-2001 Id Software, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 * =======================================================================
 *
 * This file implements the operating system binding of GL to QGL function
 * pointers.  When doing a port of Quake2 you must implement the following
 * two functions:
 *
 * QGL_Init() - loads libraries, assigns function pointers, etc.
 * QGL_Shutdown() - unloads libraries, NULLs function pointers
 *
 * =======================================================================
 */

#include "../refresh/header/local.h"
#include "../unix/header/glwindow.h"

void ( APIENTRY *qglPointParameterfEXT )( GLenum param, GLfloat value );
void ( APIENTRY *qglPointParameterfvEXT )( GLenum param, const GLfloat *value );
void ( APIENTRY *qglColorTableEXT )( GLenum, GLenum, GLsizei, GLenum, GLenum, const GLvoid * );
void ( APIENTRY *qglLockArraysEXT )( int, int );

void ( APIENTRY *qglUnlockArraysEXT )( void );
void ( APIENTRY *qglMTexCoord2fSGIS )( GLenum, GLfloat, GLfloat );
void ( APIENTRY *qglSelectTextureSGIS )( GLenum );

void ( APIENTRY *qglActiveTextureARB )( GLenum );
void ( APIENTRY *qglClientActiveTextureARB )( GLenum );

/*
 * Unloads the specified DLL then nulls out all the proc pointers.
 */
void
QGL_Shutdown(void)
{
}

/* defined in qgl_static.h */
/*void *
qwglGetProcAddress(char *symbol)
{
	return SDL_GL_GetProcAddress(symbol);
}*/

/*
 * This is responsible for binding our qgl function pointers to
 * the appropriate GL stuff.  In Windows this means doing a
 * LoadLibrary and a bunch of calls to GetProcAddress.  On other
 * operating systems we need to do the right thing, whatever that
 * might be.
 */
qboolean
QGL_Init(const char *dllname)
{
	qglLockArraysEXT = 0;
	qglUnlockArraysEXT = 0;
	qglPointParameterfEXT = 0;
	qglPointParameterfvEXT = 0;
	qglColorTableEXT = 0;
	qglSelectTextureSGIS = 0;
	qglMTexCoord2fSGIS = 0;
	qglActiveTextureARB = 0;
	qglClientActiveTextureARB = 0;

	return true;
}

void
GLimp_EnableLogging(qboolean enable)
{
	/* Not supported. */
}

void
GLimp_LogNewFrame(void)
{
	/* Not supported. */
}

