ExecBase	=	4
OldOpenLibrary	=	-408
CloseLibrary	=	-414

DosOpen		=	-30
DosClose	=	-36
DosWrite	=	-48
DosSeek		=	-66

FirstScreen	=	60

GetRGB4		=	-582

Start:
	lea	DosLibName(pc),a1
	move.l	ExecBase.w,a6
	jsr	OldOpenLibrary(a6)
	move.l	d0,DosBase
	beq.s	Err1

	lea	IntLibName(pc),a1
	move.l	ExecBase.w,a6
	jsr	OldOpenLibrary(a6)
	move.l	d0,IntBase
	beq.s	Err2

	lea	GfxLibName(pc),a1
	move.l	ExecBase.w,a6
	jsr	OldOpenLibrary(a6)
	move.l	d0,GfxBase
	beq.s	Err3

	lea	FileName(pc),a0
	exg	a0,d1
	move.l	#1006,d2
	move.l	DosBase(pc),a6
	jsr	DosOpen(a6)
	move.l	d0,FHandle
	beq.s	Err4

	bsr.s	Program

	move.l	FHandle(pc),d1
	move.l	DosBase(pc),a6
	jsr	DosClose(a6)

Err4:	move.l	GfxBase(pc),a1
	move.l	ExecBase.w,a6
	jsr	CloseLibrary(a6)

Err3:	move.l	IntBase(pc),a1
	move.l	ExecBase.w,a6
	jsr	CloseLibrary(a6)

Err2:	move.l	DosBase(pc),a1
	move.l	ExecBase.w,a6
	jsr	CloseLibrary(a6)

Err1:	rts

Program:
	bsr.L	GetIFF
	lea	Size(pc),a0
	clr.l	(a0)

	move.l	#'FORM',d0
	bsr.L	WriteL
	moveq	#0,d0
	bsr.L	WriteL
	move.l	#'ILBM',d0
	bsr.L	WriteL

	lea	Modulo(pc),a6
	sf	(a6)
	move.l	#'BMHD',d0
	bsr.L	WriteL
	moveq	#20,d0
	bsr.L	WriteL
	move.l	Screen(pc),a0
	move.w	12(a0),d0
	move.w	d0,d7
	bsr.L	WriteW
	move.w	14(a0),d0
	bsr.L	WriteW
	moveq	#0,d0
	bsr.L	WriteW
	bsr.L	WriteW
	move.l	BitMap(pc),a0
	move.b	5(a0),d0
	bsr.L	WriteB
	moveq	#0,d0
	bsr.L	WriteB
	bsr.L	WriteB
	bsr.L	WriteB
	bsr.L	WriteW
	moveq	#1,d0
	bsr.L	WriteB
	moveq	#1,d0
	bsr.L	WriteB
	move.w	(a0),d0
	lsl.w	#3,d0
	cmp.w	d0,d7
	beq.s	ModOK
	st	(a6)
	exg	d0,d7
ModOK:	bsr.L	WriteW
	move.w	2(a0),d0
	bsr.L	WriteW

	move.l	#'CMAP',d0
	bsr.L	WriteL
	moveq	#0,d0
	move.w	IlColors(pc),d0
	mulu.w	#3,d0
	btst	#0,d0
	beq.s	Jump1
	addq.l	#1,d0
Jump1:	bsr.L	WriteL
	move.w	IlColors(pc),d7
	subq.w	#1,d7
	lea	ColorsTable(pc),a0
Jump2:	move.w	(a0)+,d1
	move.w	d1,d2
	move.w	d2,d3
	lsr.w	#8,d1
	lsr.w	#4,d2
	and.w	#$f,d1
	and.w	#$f,d2
	and.w	#$f,d3
	lsl.w	#4,d1
	lsl.w	#4,d2
	lsl.w	#4,d3
	move.b	d1,d0
	bsr.L	WriteB
	move.b	d2,d0
	bsr.L	WriteB
	move.b	d3,d0
	bsr.L	WriteB
	dbf	d7,Jump2
	move.w	IlColors(pc),d0
	btst	#0,d0
	beq.s	Jump3
	moveq	#0,d0
	bsr.L	WriteB
Jump3:

	move.l	#'CAMG',d0
	bsr.L	WriteL
	moveq	#4,d0
	bsr.L	WriteL
	moveq	#0,d0
	move.l	ViewPort(pc),a6
	move.w	32(a6),d0
	swap	d0
	bsr.L	WriteL

	move.l	#'BODY',d0
	bsr.L	WriteL
	move.l	AllSize(pc),d0
	bsr.L	WriteL

	lea	Modulo(pc),a0
	tst.b	(a0)
	bne.s	JumpMod

	move.l	BitMap(pc),a0
	moveq	#0,d0
	move.w	(a0),d0
	move.w	2(a0),d6
	subq.w	#1,d6
	moveq	#0,d7
	move.b	5(a0),d7
	subq.w	#1,d7
	moveq	#0,d1
Jump4:
	move.w	d7,d5
	lea	Planes(pc),a1
Jump5:
	move.l	(a1)+,a0
	adda.l	d1,a0
	bsr.L	Write
	dbf	d5,Jump5
	add.l	d0,d1
	dbf	d6,Jump4

	bsr.L	CloseIFF
	rts

JumpMod:
	move.l	BitMap(pc),a0
	move.l	8(a0),a0
	move.l	AllSize(pc),d0
	bsr.L	Write
	bsr.L	CloseIFF
	rts

GetIFF:
	move.l	IntBase(pc),a0
	move.l	FirstScreen(a0),a0
	move.l	a0,Screen
	lea	44(a0),a1
	move.l	a1,ViewPort
	lea	184(a0),a1
	move.l	a1,BitMap

	move.l	ViewPort(pc),a0
	move.l	4(a0),ColorMap

	moveq	#1,d0
	moveq	#0,d1
	move.l	BitMap(pc),a0
	move.b	5(a0),d1
	lsl.w	d1,d0
	move.w	d0,IlColors
	subq.w	#1,d0
	exg	d0,d1
	lea	ColorsTable(pc),a1
	moveq	#0,d0
	move.l	ColorMap(pc),a0
Ge1:
	move.l	d0,-(sp)
	movem.l	d1-d7/a0-a6,-(sp)
	move.l	GfxBase(pc),a6
	jsr	GetRGB4(a6)
	movem.l	(sp)+,d1-d7/a0-a6
	move.w	d0,(a1)+
	move.l	(sp)+,d0
	addq.l	#1,d0
	dbf	d1,Ge1

	move.l	BitMap(pc),a0
	lea	Planes(pc),a1
	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	move.w	(a0),d0
	move.w	2(a0),d1
	move.b	5(a0),d2
	mulu.w	d1,d0
	move.l	d0,PlaneSize
	move.l	d0,d3
	lea	8(a0),a0
Ge2:
	move.l	(a0)+,(a1)+
	sub.b	#1,d2
	beq.s	Ge3
	add.l	d3,d0
	bra.s	Ge2
Ge3:
	move.l	d0,AllSize
	rts

CloseIFF:
	moveq	#4,d0
	bsr.s	Seek
	move.l	Size(pc),d0
	subq.l	#8,d0
	bsr.s	WriteL
	rts

;d0.l - Position
Seek:
	movem.l	d0-d7/a0-a6,-(sp)
	move.l	FHandle(pc),d1
	exg	d0,d2
	moveq	#-1,d3
	move.l	DosBase(pc),a6
	jsr	DosSeek(a6)
	movem.l	(sp)+,d0-d7/a0-a6
	rts

;a0.l - adres
;d0.l - size
Write:
	movem.l	d0-d7/a0-a6,-(sp)
	lea	Size(pc),a6
	add.l	d0,(a6)
	move.l	FHandle(pc),d1
	exg	a0,d2
	exg	d0,d3
	move.l	DosBase(pc),a6
	jsr	DosWrite(a6)
	movem.l	(sp)+,d0-d7/a0-a6
	rts

WriteL:
	movem.l	d0-d7/a0-a6,-(sp)
	lea	Size(pc),a6
	add.l	#4,(a6)
	lea	Help(pc),a0
	move.l	d0,(a0)
	move.l	FHandle(pc),d1
	exg	a0,d2
	moveq	#4,d3
	move.l	DosBase(pc),a6
	jsr	DosWrite(a6)
	movem.l	(sp)+,d0-d7/a0-a6
	rts

WriteW:
	movem.l	d0-d7/a0-a6,-(sp)
	lea	Size(pc),a6
	add.l	#2,(a6)
	lea	Help(pc),a0
	move.w	d0,(a0)
	move.l	FHandle(pc),d1
	exg	a0,d2
	moveq	#2,d3
	move.l	DosBase(pc),a6
	jsr	DosWrite(a6)
	movem.l	(sp)+,d0-d7/a0-a6
	rts

WriteB:
	movem.l	d0-d7/a0-a6,-(sp)
	lea	Size(pc),a6
	add.l	#1,(a6)
	lea	Help(pc),a0
	move.b	d0,(a0)
	move.l	FHandle(pc),d1
	exg	a0,d2
	moveq	#1,d3
	move.l	DosBase(pc),a6
	jsr	DosWrite(a6)
	movem.l	(sp)+,d0-d7/a0-a6
	rts

DosLibName:	dc.b	'dos.library',0
	EVEN
IntLibName:	dc.b	'intuition.library',0
	EVEN
GfxLibName:	dc.b	'graphics.library',0
	EVEN
FileName:	dc.b	'RAM:Picture',0
	EVEN
DosBase:	dc.l	0
IntBase:	dc.l	0
GfxBase:	dc.l	0
FHandle:	dc.l	0
Help:		dc.l	0
Size:		dc.l	0

Screen:		dc.l	0
ViewPort:	dc.l	0
BitMap:		dc.l	0
ColorMap:	dc.l	0

PlaneSize:	dc.l	0
AllSize:	dc.l	0
Planes:		blk.l	8,0
Modulo:		dc.w	0

IlColors:	dc.w	0
ColorsTable:	blk.w	256,0
	EVEN
