StarsAdd	=	3
StarsIl		=	192/StarsAdd

SAnim1		=	2
OFS		=	0
BLTF		=	%0000111100000000+%11100010
STACKSIZE	=	1024

Start:
	moveq	#0,d7
	bra.s	Start2
	dc.l	Start2
Start2:
	move.b	d7,SysStat
	bne.s	Begin
	bsr.L	StartSystem
	lea	Begin,a6
	move.l	a6,$80
	trap	#0
	bsr.L	StopSystem
Strt0:	rts
Begin:	move.l	a7,MemStack
	lea	Stack+STACKSIZE,a7
	lea	CUSTOM,a6
	bsr.s	Program
Halt:	move.l	MemStack,a7
	tst.b	SysStat
	bne.s	Strt0
	rte

;*******************************************************************

Program:
	bsr.L	Install
	bsr.L	SetVBL
	lea	CL,a0
	move.l	a0,COP1PTR(a6)
	move.w	#%1000011111000000,DMACON(a6)
	lea	Pal000,a0
	move.l	a0,PalPtr
	st	ChgPal
	bsr.L	StartVBL
	bsr.L	Show0
	bsr.L	Set0
	lea	Pal0,a0
	move.l	a0,PalPtr

	move.w	#100,d0
	move.w	#80,d1
	move.w	#0,d2
	lea	Bob00,a5
	move.w	#47,d3
L1:
	movem.l	d0-d7/a5,-(sp)
	bsr.L	Bob
	bsr.L	ScrSwap
	movem.l	(sp)+,d0-d7/a5
	addq.w	#2,d0
	addq.w	#1,d1
	tst.b	Anim1
	bne.s	L2
	add.b	#1,d2
L2:
	cmp.b	#7,d3
	bne.s	L3
	lea	Pal000,a0
	move.l	a0,PalPtr
L3:
	dbf	d3,L1

	bsr.L	Set1
	lea	Pal1,a0
	move.l	a0,PalPtr
	move.w	#0,d0
	move.w	#120,d1
	move.w	#30,d2
	lea	Bob00,a5
	move.w	#44,d3
L10:
	movem.l	d0-d7/a5,-(sp)
	bsr.L	Bob
	bsr.L	ScrSwap
	movem.l	(sp)+,d0-d7/a5
	addq.w	#3,d0
	subq.w	#1,d1
	tst.b	Anim1
	bne.s	L11
	subq.w	#1,d2
L11:
	dbf	d3,L10
	bsr.L	ScrSwap
	lea	Pal0,a0
	move.l	a0,PalPtr
	move.l	#18,d0
	bsr.L	Wait
	lea	Pal2,a0
	move.l	a0,PalPtr
	move.l	#18,d0
	bsr.L	Wait

	lea	T1,a5
	bsr.L	Pr

Loop:
	btst	#6,$bfe001
	beq.s	QuitS
	btst	#7,$bfe001
	beq.s	QuitS
	bra.s	Loop
QuitS:
	lea	Pal000,a0
	move.l	a0,PalPtr
	move.l	#18,d0
	bsr.L	Wait
	rts

T1:
	dc.b	14,4,'GRATULACJE !!!',10
	dc.b	5,8,'Dzi',234,'ki Tobie Robbo szcz',234,245,'liwie',10
	dc.b	7,10,'powrci na swoj',230,' planet',234,',',10
	dc.b	7,12,'gdzie by',231,' mo',254,'e czekaj',230,' go',10
	dc.b	12,14,'kolejne przygody.',0
	EVEN

;*******************************************************************

;a5-Tekst,0
Pr:
	move.b	(a5)+,d0
	move.b	(a5)+,d1
	add.b	#2,d1
PrL:	move.b	(a5)+,d2
	beq.s	Pri1
	cmp.b	#10,d2
	beq.s	Pr
	bsr.s	P
	movem.l	d0-d2/a5,-(sp)
	bsr.L	ScrSwap
	movem.l	(sp)+,d0-d2/a5
	bsr.s	P
	movem.l	d0-d2/a5,-(sp)
	bsr.L	ScrSwap
	movem.l	(sp)+,d0-d2/a5
	addq.b	#1,d0
	bra.s	PrL
Pri1:	rts

;*******************************************************************

;d0-x d1-y d2-code
P:
	movem.w	d0-d2,-(sp)
	and.l	#$ff,d0
	and.l	#$ff,d1
	and.l	#$ff,d2
	mulu.w	#1600,d1
	lea	Screen0,a0
	tst.b	ScrNum
	beq.s	P1
	lea	Screen1,a0
P1:
	adda.l	d1,a0
	adda.l	d0,a0
	lea	Fonts,a1
	lsl.l	#3,d2
	adda.l	d2,a1

	bsr.s	P9
	lea	40(a0),a0
	bsr.s	P9
	lea	40(a0),a0
	bsr.s	P9
	lea	40(a0),a0
	bsr.s	P9
	lea	40(a0),a0
	bsr.s	P0

	movem.w	(sp)+,d0-d2
	rts

P0:
	move.l	a1,-(sp)
	move.b	(a1)+,(a0)
	move.b	(a1)+,200(a0)
	move.b	(a1)+,400(a0)
	move.b	(a1)+,600(a0)
	move.b	(a1)+,800(a0)
	move.b	(a1)+,1000(a0)
	move.b	(a1)+,1200(a0)
	move.b	(a1)+,1400(a0)
	move.l	(sp)+,a1
	rts
P9:
	clr.b	(a0)
	clr.b	200(a0)
	clr.b	400(a0)
	clr.b	600(a0)
	clr.b	800(a0)
	clr.b	1000(a0)
	clr.b	1200(a0)
	clr.b	1400(a0)
	rts

;*******************************************************************

Clr0:
	lea	Bob00,a0
	bsr.s	ClrBob
	lea	12(a0),a0
	bsr.s	ClrBob
	lea	12(a0),a0
	bsr.s	ClrBob
	lea	12(a0),a0
	bsr.s	ClrBob
	rts

;*******************************************************************

Clr1:
	lea	Bob10,a0
	bsr.s	ClrBob
	lea	12(a0),a0
	bsr.s	ClrBob
	lea	12(a0),a0
	bsr.s	ClrBob
	lea	12(a0),a0
	bsr.s	ClrBob
	rts

;*******************************************************************

ClrBob:
	tst.w	4(a0)
	beq.s	CB0
	move.l	(a0),a1
	move.l	8(a0),a2
	move.w	#4,d0
	bsr.L	WBLT
	move.w	6(a0),BLTAMOD(a6)
	move.w	6(a0),BLTDMOD(a6)
	move.w	#$ffff,BLTAFWM(a6)
	move.w	#$ffff,BLTALWM(a6)
	move.w	#$09f0,BLTCON0(a6)
	move.w	#0,BLTCON1(a6)
CB1:	bsr.L	WBLT
	move.l	a1,BLTAPT(a6)
	move.l	a2,BLTDPT(a6)
	move.w	4(a0),BLTSIZE(a6)
	lea	40(a1),a1
	lea	40(a2),a2
	dbf	d0,CB1
	clr.w	4(a0)
CB0:	rts

;*******************************************************************

ScrSwap:
	add.b	#1,FrameCnt
	tst.b	Anim1
	bne.s	Cr0
	move.b	AddAnim,d0
	add.b	HlpAdd,d0
	move.b	d0,AddAnim
	cmp.b	#15,d0
	bne.s	Cr1
	move.b	#-1,HlpAdd
Cr1:
	cmp.b	#0,d0
	bne.s	Cr2
	move.b	#1,HlpAdd
Cr2:
Cr0:
	sub.b	#1,Anim1
	bpl.s	Pr2
	move.b	#SAnim1,Anim1
Pr2:
	bsr.L	WVBL
	bsr.L	WVBL
	tst.b	ScrNum
	bne.L	Show1
	bra.L	Show0

;*******************************************************************

;d0-x d1-y d2-bob a2-MemBOB
;0.l - src ptr
;4.w - bltsize
;6.w - modulo
;8.l - dest ptr
;12
;81,82
Bob:
	movea.l	a5,a2
	tst.b	ScrNum
	beq.s	Bob0
	lea	48(a2),a2
Bob0:
	move.w	d0,d6
	lsl.w	#8,d6
	lsl.w	#4,d6
	move.w	d6,d7
	or.w	#$0ff2,d7
	clr.l	d5
	move.w	d0,d5
	lsr.w	#4,d5
	lsl.w	#1,d5
	clr.l	d3
	move.w	d2,d3
	lsl.w	#1,d3
	lea	BobAddY,a1
	clr.l	d4
	move.b	d1,d4
	add.w	0(a1,d3.w),d4
	lsl.w	#2,d4
	lsl.w	#3,d3
	lea	Ship1_1T,a1
	lea	0(a1,d3.w),a1
	lea	YOfs,a0
	move.l	0(a0,d4.w),a0
	adda.l	d5,a0
	move.w	14(a1),6(a2)
	move.w	12(a1),4(a2)
	lea	Screen2,a3
	adda.l	a0,a3
	move.l	a3,(a2)
	adda.l	ActScreen,a0
	move.l	a0,8(a2)
	bsr.L	WBLT
	move.w	#$ffff,BLTAFWM(a6)
	move.w	#$ffff,BLTALWM(a6)
	move.w	d7,BLTCON0(a6)
	move.w	d6,BLTCON1(a6)
	move.w	#0,BLTAMOD(a6)
	move.w	#0,BLTBMOD(a6)
	move.w	14(a1),BLTDMOD(a6)
	move.w	14(a1),BLTCMOD(a6)
	move.l	(a1),BLTAPT(a6)
	move.l	4(a1),BLTBPT(a6)
	move.l	a0,BLTDPT(a6)
	move.l	a0,BLTCPT(a6)
	move.w	12(a1),BLTSIZE(a6)
	bsr.L	WBLT
	lea	40(a0),a0
	move.l	4(a1),BLTBPT(a6)
	move.l	a0,BLTDPT(a6)
	move.l	a0,BLTCPT(a6)
	move.w	12(a1),BLTSIZE(a6)
	bsr.L	WBLT
	lea	40(a0),a0
	move.l	4(a1),BLTBPT(a6)
	move.l	a0,BLTDPT(a6)
	move.l	a0,BLTCPT(a6)
	move.w	12(a1),BLTSIZE(a6)
	bsr.L	WBLT
	lea	40(a0),a0
	move.l	4(a1),BLTAPT(a6)
	move.l	a0,BLTCPT(a6)
	move.l	a0,BLTDPT(a6)
	move.w	d6,d5
	or.w	#%0000101100001010,d5
	move.w	d5,BLTCON0(a6)
	move.w	12(a1),BLTSIZE(a6)
	bsr.L	WBLT
	lea	40(a0),a0
	move.l	4(a1),BLTAPT(a6)
	move.l	a0,BLTCPT(a6)
	move.l	a0,BLTDPT(a6)
	move.w	d6,d5
	or.w	#%0000101111111010,d5
	move.w	d5,BLTCON0(a6)
	move.w	12(a1),BLTSIZE(a6)
	rts

;*******************************************************************

WBLT:
	btst	#6,DMACONR(a6)
WBLT0	btst	#6,DMACONR(a6)
	bne.s	WBLT0
	rts

;*******************************************************************

ResetBob:
	lea	Bob00,a0
	moveq	#7,d0
In00:
	clr.w	4(a0)
	lea	12(a0),a0
	dbf	d0,In00
	rts

;*******************************************************************

Install:

	sf	Anim1
	sf	ScrNum

	lea	YOfs,a0
	move.w	#255,d0
	clr.l	d1
In0:
	move.l	d1,(a0)+
	add.l	#200,d1
	dbf	d0,In0

	lea	Ship1_1,a0
	move.l	a0,d1
	lea	Ship1_1T,a1
	moveq	#15,d0
In1:	add.l	d1,(a1)
	add.l	d1,4(a1)

	move.w	8(a1),d7
	move.w	#40,d6
	sub.w	d7,d6
	move.w	#40*5,d7
	sub.w	d6,d7
	move.w	d7,14(a1)

	move.w	10(a1),12(a1)
	lea	16(a1),a1	;bobtab
	dbf	d0,In1

	lea	Ship1_2,a0
	move.l	a0,d1
	lea	Ship1_2T,a1
	moveq	#14,d0
In2:	add.l	d1,(a1)
	add.l	d1,4(a1)

	move.w	8(a1),d7
	move.w	#40,d6
	sub.w	d7,d6
	move.w	#40*5,d7
	sub.w	d6,d7
	move.w	d7,14(a1)

	move.w	10(a1),12(a1)
	lea	16(a1),a1	;bobtab
	dbf	d0,In2

	rts

;*******************************************************************

Set1:
	bsr.L	ResetBob
	lea	Scr1,a0
	lea	Screen0+OFS,a1
	lea	Screen1+OFS,a2
	lea	Screen2+OFS,a3
	move.w	#192-1,d0
Set11:
	move.w	#50-1,d1
Set12:
	move.l	(a0),(a1)+
	move.l	(a0),(a2)+
	move.l	(a0)+,(a3)+
	dbf	d1,Set12
	dbf	d0,Set11

	rts

;*******************************************************************

Set0:
	bsr.L	ResetBob
	lea	Scr0,a0
	lea	Screen0+OFS,a1
	lea	Screen1+OFS,a2
	lea	Screen2+OFS,a3
	move.w	#192-1,d0
Set01:
	move.w	#50-1,d1
Set02:
	move.l	(a0),(a1)+
	move.l	(a0),(a2)+
	move.l	(a0)+,(a3)+
	dbf	d1,Set02
	dbf	d0,Set01
	rts

;*******************************************************************

Show0:
	lea	Screen0+OFS,a0
	lea	CLPtr,a1
	moveq	#4,d0
Sh01:
	move.l	a0,d1
	lea	40(a0),a0
	move.w	d1,6(a1)
	swap	d1
	move.w	d1,2(a1)
	lea	8(a1),a1
	dbf	d0,Sh01
	lea	Screen1,a0
	move.l	a0,ActScreen
	st	ScrNum
	bra.L	Clr1

Show1:
	lea	Screen1+OFS,a0
	lea	CLPtr,a1
	moveq	#4,d0
Sh11:
	move.l	a0,d1
	lea	40(a0),a0
	move.w	d1,6(a1)
	swap	d1
	move.w	d1,2(a1)
	lea	8(a1),a1
	dbf	d0,Sh11
	lea	Screen0,a0
	move.l	a0,ActScreen
	sf	ScrNum
	bra.L	Clr0

;*******************************************************************

Wait:
	move.l	d0,CNT
Wa:	tst.l	CNT
	bne.s	Wa
	rts

;*******************************************************************

Fade16:
	move.w	#16,d7
Fade0:	movem.l	d7/a0,-(sp)
	bsr.L	WVBL
	bsr.L	Fade
	movem.l	(sp)+,d7/a0
	dbf	d7,Fade0
	rts

;*******************************************************************

Fade16B:
	move.w	#16,d7
Fade0B:	movem.l	d7/a0,-(sp)
	bsr.s	Fade
	movem.l	(sp)+,d7/a0
	dbf	d7,Fade0B
	rts

;*******************************************************************

;a0-palette a1-copperlist
Fade:
	move.l	PalPtr,a0
	lea	CLCol,a1
	move.w	#31,d0
Fa1:
	move.w	2(a1),d1
	move.w	(a0)+,d2
	move.w	d1,d3
	move.w	d2,d4
	and.w	#$f00,d3
	and.w	#$f00,d4
	cmp.w	d3,d4
	beq.s	Fa2a
	bcs.s	Fa3a
	add.w	#$100,d1
	bra.s	Fa2a
Fa3a:	sub.w	#$100,d1
Fa2a:
	move.w	d1,d3
	move.w	d2,d4
	and.w	#$0f0,d3
	and.w	#$0f0,d4
	cmp.w	d3,d4
	beq.s	Fa2b
	bcs.s	Fa3b
	add.w	#$010,d1
	bra.s	Fa2b
Fa3b:	sub.w	#$010,d1
Fa2b:
	move.w	d1,d3
	move.w	d2,d4
	and.w	#$00f,d3
	and.w	#$00f,d4
	cmp.w	d3,d4
	beq.s	Fa2c
	bcs.s	Fa3c
	add.w	#$001,d1
	bra.s	Fa2c
Fa3c:	sub.w	#$001,d1
Fa2c:
	move.w	d1,2(a1)
	lea	4(a1),a1
	dbf	d0,Fa1
	rts

;*******************************************************************

WVBL:
	sf	ByloVBL
WVBL0:	tst.b	ByloVBL
	beq.s	WVBL0
	rts

;*******************************************************************

ProcVBL:
	tst.b	ChgPal
	beq.s	Pr0
	bsr.L	Fade
Pr0:
	st	ByloVBL
	tst.l	CNT
	beq.L	Pr1
	sub.l	#1,CNT
Pr1:
	rts

;*******************************************************************

VBL:
	move.w	d0,-(sp)
	move.w	INTREQR+CUSTOM,d0
	btst	#5,d0
	beq.s	QuitV
	tst.b	WykonujVBL
	beq.s	QuitV
	movem.l	d0-d7/a0-a6,-(sp)
	lea	CUSTOM,a6
	bsr.L	ProcVBL
	movem.l	(sp)+,d0-d7/a0-a6
QuitV:	and.w	#$7fff,d0
	move.w	d0,INTREQ+CUSTOM
	move.w	(sp)+,d0
	rte

;*******************************************************************

StartVBL:
	st	WykonujVBL
	rts

;*******************************************************************

StopVBL:
	sf	WykonujVBL
	rts

;*******************************************************************

SetVBL:
	sf	WykonujVBL
	lea	VBL,a0
	move.l	a0,$6c
	move.w	#SETCLR+%100000+$4000,INTENA(a6)
	rts

;*******************************************************************

LMK:
	btst	#6,$bfe001
	bne.s	LMK
	rts

;*******************************************************************

WaitBlt:
	btst	#6,$dff002
WaBl1:	btst	#6,$dff002
	bne.s	WaBl1
	rts

;*******************************************************************

StartSystem:
	movem.l	d0-d7/a0-a6,-(sp)
	lea	GfxLibName,a1
	move.l	ExecBase,a6
	jsr	OldOpenLibrary(a6)
	move.l	d0,GfxLibBase
	exg	d0,a6
	jsr	OwnBlitter(a6)
	bsr.s	WaitBlt
	move.l	ExecBase,a6
	jsr	Forbid(a6)
	move.w	$dff002,MemDma
	move.w	$dff01c,MemInt
	or.w	#$8000,MemDma
	or.w	#$8000,MemInt
	move.w	#$7fff,$dff09a
	move.w	#$7fff,$dff096
	lea	MemVectors,a0
	lea	0,a1
	lea	Reset,a2
	moveq	#63,d0
StSy1:	move.l	(a1),(a0)+
	move.l	a2,(a1)+
	dbf	d0,StSy1
	bsr.s	InstEI
	movem.l	(sp)+,d0-d7/a0-a6
	rts

;*******************************************************************

StopSystem:
	movem.l	d0-d7/a0-a6,-(sp)
	move.w	#$7fff,$dff09a
	move.w	#$7fff,$dff096
	lea	MemVectors,a0
	lea	0,a1
	moveq	#63,d0
StSs1:	move.l	(a0)+,(a1)+
	dbf	d0,StSs1
	move.l	GfxLibBase,a6
	move.l	$26(a6),$dff080
	move.w	MemDma,$dff096
	move.w	MemInt,$dff09a
	move.l	ExecBase,a6
	jsr	Permit(a6)
	move.l	GfxLibBase,a6
	jsr	DisownBlitter(a6)
	exg	a6,a1
	move.l	ExecBase,a6
	jsr	CloseLibrary(a6)
	movem.l	(sp)+,d0-d7/a0-a6
	rts

;*******************************************************************

InstEI:
	lea	EmptyInt,a0
	move.l	a0,$64
	move.l	a0,$68
	move.l	a0,$6c
	move.l	a0,$70
	move.l	a0,$74
	move.l	a0,$78
	move.l	a0,$7c
	rts

;*******************************************************************

EmptyInt:
	move.w	d0,-(sp)
	move.w	INTREQR+CUSTOM,d0
	and.w	#$7fff,d0
	move.w	d0,INTREQ+CUSTOM
	move.w	(sp)+,d0
	rte

;*******************************************************************

Reset:
	move.w	#$7fff,$dff09a
	move.w	#$7fff,$dff096
	lea	ResetP,a0
	move.l	a0,$80
	trap	#0
ResetP:	clr.l	ExecBase
	lea	2,a0
	reset
	jmp	(a0)

;*******************************************************************
;			CONSTANS
;*******************************************************************

ExecBase	=	4
OldOpenLibrary	=	-408
CloseLibrary	=	-414
OwnBlitter	=	-456
DisownBlitter	=	-462
Forbid		=	-132
Permit		=	-138
CUSTOM		=	$dff000
BLTDDAT		=	$000
DMACONR		=	$002
VPOSR		=	$004
VHPOSR		=	$006
DSKDATR		=	$008
JOY0DAT		=	$00A
JOY1DAT		=	$00C
CLXDAT		=	$00E
ADKCONR		=	$010
POT0DAT		=	$012
POT1DAT		=	$014
POTGOR		=	$016
SERDATR		=	$018
DSKBYTR		=	$01A
INTENAR		=	$01C
INTREQR		=	$01E
DSKPTH		=	$020
DSKPTL		=	$022
DSKLEN		=	$024
DSKDAT		=	$026
REFPTR		=	$028
VPOSW		=	$02A
VHPOSW		=	$02C
COPCON		=	$02E
SERDAT		=	$030
SERPER		=	$032
POTGO		=	$034
JOYTEST		=	$036
STRQU		=	$038
STRVBL		=	$03A
STRHOR		=	$03C
STRLONG		=	$03E
BLTCON0		=	$040
BLTCON1		=	$042
BLTAFWM		=	$044
BLTALWM		=	$046
BLTCPT		=	$048
BLTBPT		=	$04C
BLTAPT		=	$050
BLTDPT		=	$054
BLTSIZE		=	$058
BLTCMOD		=	$060
BLTBMOD		=	$062
BLTAMOD		=	$064
BLTDMOD		=	$066
BLTCDAT		=	$070
BLTBDAT		=	$072
BLTADAT		=	$074
DSKSYNC		=	$07E
COP1PTR		=	$080
COP2PTR		=	$084
COP1LCH		=	$080
COP1LCL		=	$082
COP2LCH		=	$084
COP2LCL		=	$086
COPJMP1		=	$088
COPJMP2		=	$08A
COPINS		=	$08C
DIWSTRT		=	$08E
DIWSTOP		=	$090
DDFSTRT		=	$092
DDFSTOP		=	$094
DMACON		=	$096
CLXCON		=	$098
INTENA		=	$09A
INTREQ		=	$09C
ADKCON		=	$09E
AUDIO0		=	$0A0
AUDIO1		=	$0B0
AUDIO2		=	$0C0
AUDIO3		=	$0D0
BPL1PTH		=	$0E0
BPL1PTL		=	$0E2
BPL2PTH		=	$0E4
BPL2PTL		=	$0E6
BPL3PTH		=	$0E8
BPL3PTL		=	$0EA
BPL4PTH		=	$0EC
BPL4PTL		=	$0EE
BPL5PTH		=	$0F0
BPL5PTL		=	$0F2
BPL6PTH		=	$0F4
BPL6PTL		=	$0F6
BPLCON0		=	$100
BPLCON1		=	$102
BPLCON2		=	$104
BPL1MOD		=	$108
BPL2MOD		=	$10A
SPRPTR		=	$120
SPRPOS		=	$140
COLORS		=	$180
SETCLR		=	$8000
DSKEN		=	$10
SPREN		=	$20
BLTEN		=	$40
COPEN		=	$80
BPLEN		=	$100
DMAEN		=	$200
BLTPR		=	$400
ERSY		=	$2
LACE		=	$4
LPEN		=	$8
GAUD		=	$100
COLOR		=	$200
DBLPF		=	$400
HOMOD		=	$800
BPU0		=	$1000
BPU1		=	$2000
BPU2		=	$4000
HIRES		=	$8000
COPWAIT		=	$fffe
ENDCOPLST	=	$ffff
ENDHALF		=	$ffdf
KEYTALO		=	$bfe401
KEYTAHI		=	$bfe501
KEYCRA		=	$bfee01
KEYSDR		=	$bfec01
KEYICR		=	$bfed01
TBLO		=	$bfd600
TBHI		=	$bfd700
CRB		=	$bfdf00
ICR		=	$bfdd00
SPR0POS		=	$140
SPR0CTL		=	$142
SPR0DATA	=	$144
SPR0DATB	=	$146
SPR1POS		=	$148
SPR1CTL		=	$14a
SPR1DATA	=	$14c
SPR1DATB	=	$14e
SPR2POS		=	$150
SPR2CTL		=	$152
SPR2DATA	=	$154
SPR2DATB	=	$156
SPR3POS		=	$158
SPR3CTL		=	$15a
SPR3DATA	=	$15c
SPR3DATB	=	$15e
SPR4POS		=	$160
SPR4CTL		=	$162
SPR4DATA	=	$164
SPR4DATB	=	$166
SPR5POS		=	$168
SPR5CTL		=	$16a
SPR5DATA	=	$16c
SPR5DATB	=	$16e
SPR6POS		=	$170
SPR6CTL		=	$172
SPR6DATA	=	$174
SPR6DATB	=	$176
SPR7POS		=	$178
SPR7CTL		=	$17a
SPR7DATA	=	$17c
SPR7DATB	=	$17e

;*******************************************************************
;			CHIP DATA
;*******************************************************************

;*******************************************************************

CL:
		dc.w	SPR0CTL,0,SPR1CTL,0,SPR2CTL,0,SPR3CTL,0
		dc.w	SPR4CTL,0,SPR5CTL,0,SPR6CTL,0,SPR7CTL,0
		dc.w	$2003,COPWAIT
CLCol:
		dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
		dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
		dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
		dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

CLPtr:		dc.w	$e0,0,$e2,0
		dc.w	$e4,0,$e6,0
		dc.w	$e8,0,$ea,0
		dc.w	$ec,0,$ee,0
		dc.w	$f0,0,$f2,0

		dc.w	DDFSTRT,7*8
		dc.w	DDFSTOP,7*8+152
		dc.w	DIWSTRT,$0310
		dc.w	DIWSTOP,$7fc0
		dc.w	BPLCON1,0
		dc.w	BPLCON2,0
		dc.w	BPL1MOD,160
		dc.w	BPL2MOD,160

		dc.w	$3f03,COPWAIT,BPLCON0,COLOR+BPU0+BPU2

		dc.w	$ff03,COPWAIT
		dc.w	BPLCON0,COLOR
		dc.w	ENDCOPLST,COPWAIT

	;--- System. ---

SysStat:	dc.b	0
GfxLibName:	dc.b	'graphics.library',0
	EVEN

Pal0:
	dc.w	$000,$002,$fff,$ccc,$999,$666,$333,$000
	dc.w	$fed,$eca,$c97,$a75,$853,$631,$420,$210
	dc.w	$eee,$ccc,$aaa,$888,$666,$444,$333,$222
	dc.w	$fff,$fdb,$fa6,$e70,$d50,$b20,$910,$500
Pal1:
	dc.w	$000,$002,$fff,$ccc,$999,$666,$333,$000
	dc.w	$fed,$eca,$c97,$a75,$853,$631,$420,$210
	dc.w	$eee,$ccc,$aaa,$888,$666,$444,$333,$222
	dc.w	$000,$000,$000,$000,$000,$000,$000,$000
Pal2:
	dc.w	$000,$002,$fff,$ccc,$999,$666,$333,$000
	dc.w	$fed,$eca,$c97,$a75,$853,$631,$420,$210
	dc.w	$0f0,$ccc,$aaa,$888,$666,$444,$333,$222
	dc.w	$000,$000,$000,$000,$000,$000,$000,$000

Pal000:		blk.w	32,$000
Palfff:		blk.w	32,$fff

	incdir	'dh1:sources/asm/robbo/bin/stopbin/'

Ship1_1:	incbin	'mstop.BIN'
Ship1_2:	incbin	'mxstop.BIN'

Ship1_1T:	incbin	'mstop.TAB'
Ship1_2T:	incbin	'mxstop.TAB'

Fonts:		incbin	'StopFont.BIN'

Anim1:		dc.b	0
ChgPal:		dc.b	0
	EVEN

BobAddY:
	dc.w	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

;*******************************************************************
;			CHIP WORK
;*******************************************************************

Fine:

	;--- System. ---

GfxLibBase:	dc.l	0
MemStack:	dc.l	0
MemDma:		dc.w	0
MemInt:		dc.w	0
MemVectors:	blk.l	64
Stack:		blk.b	STACKSIZE
	EVEN

	;--- VBL. ---

PalPtr:		dc.l	0
ActScreen:	dc.l	0
CNT:		dc.l	0
LX:		dc.w	0
LY:		dc.w	0
SL:		dc.b	0
WykonujVBL:	dc.b	0
ByloVBL:	dc.b	0
ScrNum:		dc.b	0
HlpAdd:		dc.b	0
AddAnim:	dc.b	0
FrameCnt:	dc.b	0
	EVEN

YOfs:		blk.l	256,0

Bob00:		blk.b	12,0
Bob01:		blk.b	12,0
Bob02:		blk.b	12,0
Bob03:		blk.b	12,0
Bob10:		blk.b	12,0
Bob11:		blk.b	12,0
Bob12:		blk.b	12,0
Bob13:		blk.b	12,0

Screen0:	blk.b	40*192*5
Screen1:	blk.b	40*192*5
Screen2:	blk.b	40*192*5

;************** FAST !!! *****************

Scr0:		incbin	'StopMoon.BIN'
Scr1:		incbin	'StopStarNew.BIN'

Stop:
