StarPoc		=	16
PalVar		=	100
DY		=	96
STACKSIZE	=	1024

Start:
	moveq	#0,d7
	bra.s	Start2
	dc.l	Start2
Start2:
	move.b	d7,SysStat
	bne.s	Begin
	bsr.L	StartSystem
	lea	Begin,a6
	move.l	a6,$80
	trap	#0
	bsr.L	StopSystem
Strt0:	rts
Begin:	move.l	a7,MemStack
	lea	Stack+STACKSIZE,a7
	lea	CUSTOM,a6
	bsr.s	Program
	move.l	MemStack,a7
	tst.b	SysStat
	bne.s	Strt0
	rte

;*******************************************************************

Program:
	bsr.L	FindStars
	sf	Anim
	sf	Sprt
	move.w	#8,S1Num
	move.w	#2,S2Num
	move.w	#14,S3Num
	move.w	#6,S4Num
	move.w	#8,S5Num
	move.w	#10,S6Num
	move.w	#2,S7Num
	move.w	#14,S8Num
	lea	RobboPic,a1
	lea	[1*2]+[14*136](a1),a0
	move.l	a0,S1Ptr
	lea	[6*2]+[22*136](a1),a0
	move.l	a0,S2Ptr
	lea	[9*2]+[46*136](a1),a0
	move.l	a0,S3Ptr
	lea	[10*2]+[14*136](a1),a0
	move.l	a0,S4Ptr
	lea	[14*2]+[22*136](a1),a0
	move.l	a0,S5Ptr
	lea	[3*2]+[50*136](a1),a0
	move.l	a0,S6Ptr
	lea	[13*2]+[46*136](a1),a0
	move.l	a0,S7Ptr
	lea	[6*2]+[46*136](a1),a0
	move.l	a0,S8Ptr
	lea	BoxPal2,a0
	move.w	#$000,24*2(a0)
	lea	BoxPal3,a0
	move.w	#$000,24*2(a0)
	lea	BoxPal3,a0
	move.w	#15,d0
Prog:	clr.w	(a0)+
	dbf	d0,Prog
	move.l	a7,MST
	st	OKHalt
	bsr.L	SetVBL
	bsr.L	SetFirst
	lea	CL,a0
	move.l	a0,COP1PTR(a6)
	move.w	#SETCLR+BLTEN+COPEN+BPLEN+DMAEN+BLTPR,DMACON(a6)
	bsr.L	StartVBL

Loop:
	bsr.L	ShowEyes
	lea	EyesPal,a0
	bsr.L	FadeDown2
	move.l	#100,d0
	bsr.L	W
	lea	Pal000,a0
	bsr.L	FadeDown
	bsr.L	Clr
	lea	BoxPal,a0
	bsr.L	FadeDown
	lea	Txt1,a0
	bsr.L	Print
	bsr.L	Clr
	lea	BoxPal,a0
	bsr.L	FadeDown
	lea	Txt2,a0
	bsr.L	Print
	bsr.L	Clr
	lea	BoxPal,a0
	bsr.L	FadeDown
	lea	Txt3,a0
	bsr.L	Print
	bsr.L	Clr
	bsr.L	ShowKey1
	lea	BoxPal,a0
	bsr.L	FadeDown
	lea	Txt4,a0
	bsr.L	Print
	bsr.L	Clr
	bsr.L	ShowKey2
	lea	BoxPal,a0
	bsr.L	FadeDown
	lea	Txt5,a0
	bsr.L	Print
	bsr.L	Clr
	bsr.L	ShowKey3
	lea	BoxPal,a0
	bsr.L	FadeDown
	lea	Txt6,a0
	bsr.L	Print
	bsr.L	Clr
	moveq	#0,d0
	bsr.L	Show
	lea	BoxPal,a0
	bsr.L	FadeDown
	lea	Txt7,a0
	bsr.L	Print
	bsr.L	Clr
	moveq	#1,d0
	bsr.L	Show
	lea	BoxPal,a0
	bsr.L	FadeDown
	lea	Txt8,a0
	bsr.L	Print
	bsr.L	Clr
	moveq	#2,d0
	bsr.L	Show
	lea	BoxPal,a0
	bsr.L	FadeDown
	lea	Txt9,a0
	bsr.L	Print
	bsr.L	Clr
	moveq	#3,d0
	bsr.L	Show
	lea	BoxPal,a0
	bsr.L	FadeDown
	lea	Txt10,a0
	bsr.L	Print
	bsr.L	Clr
	moveq	#4,d0
	bsr.L	Show
	lea	BoxPal,a0
	bsr.L	FadeDown
	lea	Txt11,a0
	bsr.L	Print
	bsr.L	Clr
	moveq	#5,d0
	bsr.L	Show
	lea	BoxPal,a0
	bsr.L	FadeDown
	lea	Txt12,a0
	bsr.L	Print
	bsr.L	Clr
	moveq	#6,d0
	bsr.L	Show
	lea	BoxPal,a0
	bsr.L	FadeDown
	lea	Txt13,a0
	bsr.L	Print
	bsr.L	Clr
	moveq	#7,d0
	bsr.L	Show
	lea	BoxPal,a0
	bsr.L	FadeDown
	lea	Txt14,a0
	bsr.L	Print
	bsr.L	Clr
	moveq	#8,d0
	bsr.L	Show
	lea	BoxPal,a0
	bsr.L	FadeDown
	lea	Txt15,a0
	bsr.L	Print
	bsr.L	Clr
	moveq	#9,d0
	bsr.L	Show
	lea	BoxPal,a0
	bsr.L	FadeDown
	lea	Txt16,a0
	bsr.L	Print
	bsr.L	Clr
	moveq	#10,d0
	bsr.L	Show
	lea	BoxPal,a0
	bsr.L	FadeDown
	lea	Txt17,a0
	bsr.L	Print
	bsr.L	Clr
	moveq	#11,d0
	bsr.L	Show
	lea	BoxPal,a0
	bsr.L	FadeDown
	lea	Txt18,a0
	bsr.L	Print
	bsr.L	Clr
	moveq	#12,d0
	bsr.L	Show
	lea	BoxPal,a0
	bsr.L	FadeDown
	lea	Txt19,a0
	bsr.L	Print
	bsr.L	Clr
	moveq	#13,d0
	bsr.L	Show
	lea	BoxPal,a0
	bsr.L	FadeDown
	lea	Txt20,a0
	bsr.L	Print
	bsr.L	Clr
	moveq	#14,d0
	bsr.L	Show
	lea	BoxPal,a0
	bsr.L	FadeDown
	lea	Txt21,a0
	bsr.L	Print
	bsr.L	Clr
	moveq	#15,d0
	bsr.L	Show
	lea	BoxPal,a0
	bsr.L	FadeDown
	lea	Txt22,a0
	bsr.L	Print
	bsr.L	Clr
	moveq	#16,d0
	bsr.L	Show
	lea	BoxPal,a0
	bsr.L	FadeDown
	lea	Txt23,a0
	bsr.L	Print
	bsr.L	Clr
	moveq	#17,d0
	bsr.L	Show
	lea	BoxPal,a0
	bsr.L	FadeDown
	lea	Txt24,a0
	bsr.L	Print
	bsr.L	Clr
	lea	BoxPal,a0
	bsr.L	FadeDown
	lea	Txt25,a0
	bsr.L	Print
	lea	Pal000,a0
	bsr.L	FadeDown
	bra.L	Loop

;*******************************************************************

FindStars:
	lea	CLStars,a0
	move.w	#29,d0
	lea	StarsPtr,a1
FiSt1:	cmp.w	#$4321,(a0)+
	bne.s	FiSt1
	move.l	a0,(a1)
	sub.l	#2,(a1)+
	dbf	d0,FiSt1
	rts

;*******************************************************************

;a0.l-Text
Print:
PrintL:	move.b	(a0)+,d3
	move.b	(a0)+,d4
Pt1:	move.b	(a0)+,d2
	beq.s	Pt0
	cmp.b	#10,d2
	beq.s	PrintL
	move.b	d3,d0
	move.b	d4,d1
	bsr.s	Char
	addq.b	#1,d3
	bra.s	Pt1
Pt0:	move.l	#200,d0
	bsr.L	W
	lea	BoxPal2,a0
	bsr.L	FadeDown
	lea	BoxPal3,a0
	bsr.L	FadeDown
	rts

;*******************************************************************

;d0-x d1-y d2-code
Char:
	bsr.L	WVBL
	and.l	#$ff,d0
	and.w	#$ff,d1
	and.l	#$ff,d2
	lea	YPtr,a5
	lsl.w	#2,d1
	move.l	0(a5,d1.w),a5
	adda.l	d0,a5
	lsl.l	#3,d2
	lea	Fonts,a4
	adda.l	d2,a4
	clr.b	(a5)
	clr.b	180(a5)
	clr.b	360(a5)
	clr.b	540(a5)
	clr.b	720(a5)
	clr.b	900(a5)
	clr.b	1080(a5)
	clr.b	1260(a5)
	lea	36(a5),a5
	clr.b	(a5)
	clr.b	180(a5)
	clr.b	360(a5)
	clr.b	540(a5)
	clr.b	720(a5)
	clr.b	900(a5)
	clr.b	1080(a5)
	clr.b	1260(a5)
	lea	36(a5),a5
	clr.b	(a5)
	clr.b	180(a5)
	clr.b	360(a5)
	clr.b	540(a5)
	clr.b	720(a5)
	clr.b	900(a5)
	clr.b	1080(a5)
	clr.b	1260(a5)
	lea	36(a5),a5
	move.b	(a4),(a5)
	move.b	1(a4),180(a5)
	move.b	2(a4),360(a5)
	move.b	3(a4),540(a5)
	move.b	4(a4),720(a5)
	move.b	5(a4),900(a5)
	move.b	6(a4),1080(a5)
	move.b	7(a4),1260(a5)
	lea	36(a5),a5
	move.b	(a4)+,(a5)
	move.b	(a4)+,180(a5)
	move.b	(a4)+,360(a5)
	move.b	(a4)+,540(a5)
	move.b	(a4)+,720(a5)
	move.b	(a4)+,900(a5)
	move.b	(a4)+,1080(a5)
	move.b	(a4)+,1260(a5)
	rts

;*******************************************************************

HALT:	move.l	MST,a7
	lea	Pal000,a0
	bsr.s	FadeDown
	rts

;*******************************************************************

WVBL:
	sf	ByloVBL
WVBL0:	tst.b	ByloVBL
	beq.s	WVBL0
	rts

;*******************************************************************

FadeDown2:
	move.w	#15,d0
	bra.s	FD2
FadeDown:
	move.w	#31,d0
FD2:	lea	CLPal3,a1
	move.w	#17,d1
FaDo0:	bsr.s	WVBL
	movem.l	d0/d1/a0/a1,-(sp)
	bsr.L	Fade
	movem.l	(sp)+,d0/d1/a0/a1
	dbf	d1,FaDo0
	rts

;*******************************************************************

Clr:
	lea	Down,a0
	move.w	#36*5*dy/4-1,d0
Clr1:	clr.l	(a0)+
	dbf	d0,Clr1
	rts

;*******************************************************************

Show:
	move.w	d0,-(sp)
	bsr.L	ShowBox
	move.w	(sp)+,d0
	and.w	#$ff,d0
	mulu.w	#384,d0
	lea	Examples,a0
	adda.l	d0,a0
	lea	36*180+4+Down,a1
	move.w	#24-1,d0
Sw1:	move.w	(a0)+,(a1)+
	move.b	(a0)+,(a1)+
	lea	1(a0),a0
	lea	36-3(a1),a1
	move.w	(a0)+,(a1)+
	move.b	(a0)+,(a1)+
	lea	1(a0),a0
	lea	36-3(a1),a1
	move.w	(a0)+,(a1)+
	move.b	(a0)+,(a1)+
	lea	1(a0),a0
	lea	36-3(a1),a1
	move.w	(a0)+,(a1)+
	move.b	(a0)+,(a1)+
	lea	1(a0),a0
	lea	36-3(a1),a1
	clr.w	(a1)+
	clr.b	(a1)+
	lea	36-3(a1),a1
	dbf	d0,Sw1
	rts

;*******************************************************************

ShowKey1:
	lea	KeyPic,a1
	lea	70*180+12+Down,a0
	move.w	#26-1,d0
ShKe1:	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	lea	36-12(a0),a0
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	lea	36-12(a0),a0
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	lea	36-12(a0),a0
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	lea	36-12(a0),a0
	lea	36(a0),a0
	dbf	d0,ShKe1
	rts

;*******************************************************************

ShowKey2:
	lea	48*26+KeyPic,a1
	lea	70*180+12+Down,a0
	move.w	#26-1,d0
ShKe2:	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	lea	36-12(a0),a0
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	lea	36-12(a0),a0
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	lea	36-12(a0),a0
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	lea	36-12(a0),a0
	lea	36(a0),a0
	dbf	d0,ShKe2
	rts

;*******************************************************************

ShowKey3:
	lea	48*52+KeyPic,a1
	lea	80*180+16+Down,a0
	move.w	#16-1,d0
ShKe3:	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	lea	36-12(a0),a0
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	lea	36-12(a0),a0
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	lea	36-12(a0),a0
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	lea	36-12(a0),a0
	lea	36(a0),a0
	dbf	d0,ShKe3
	rts

;*******************************************************************

ShowBox:
	lea	BoxPic,a1
	lea	31*180+2+Down,a0
	move.w	#34*5-1,d0
ShBo1:	move.l	(a1)+,(a0)+
	move.w	(a1)+,(a0)+
	lea	30(a0),a0
	dbf	d0,ShBo1
	rts

;*******************************************************************

ShowEyes:
	bsr.L	Clr
	lea	BoxPal3,a0
	bsr.L	FadeDown
	lea	EyesPic,a0
	lea	180*13+Down+8,a1
	move.w	#71-1,d0
ShEy1:	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.w	(a0)+,(a1)+
	lea	18(a1),a1
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.w	(a0)+,(a1)+
	lea	18(a1),a1
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.w	(a0)+,(a1)+
	lea	18(a1),a1
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.w	(a0)+,(a1)+
	lea	18(a1),a1
	lea	36(a1),a1
	dbf	d0,ShEy1
	rts

;*******************************************************************

SetFirst:
	lea	YPtr,a0
	lea	Down,a1
	move.w	#11,d0
SeFr1:	move.l	a1,(a0)+
	lea	1440(a1),a1
	dbf	d0,SeFr1
	sf	PalNum
	move.b	#PalVar,PalDel
	lea	CLPtr1,a0
	lea	RobboPic,a1
	move.w	#3,d0
SeFi1:	move.l	a1,d1
	move.w	d1,6(a0)
	swap	d1
	move.w	d1,2(a0)
	lea	34(a1),a1
	lea	8(a0),a0
	dbf	d0,SeFi1
	lea	CLPtr2,a0
	lea	TSSPic,a1
	move.w	#3,d0
SeFi2:	move.l	a1,d1
	move.w	d1,6(a0)
	swap	d1
	move.w	d1,2(a0)
	lea	36(a1),a1
	lea	8(a0),a0
	dbf	d0,SeFi2
	lea	CLPtr3,a0
	lea	Down,a1
	move.w	#4,d0
SeFi3:	move.l	a1,d1
	move.w	d1,6(a0)
	swap	d1
	move.w	d1,2(a0)
	lea	36(a1),a1
	lea	8(a0),a0
	dbf	d0,SeFi3
	bsr.s	SetPalF
	rts

;*******************************************************************

;a0. - 16 kol
SetPalF:
	lea	RobboPal0,a0
	move.l	a0,PalPtr
	lea	CLPal1,a1
	move.w	#15,d0
SePa1:	move.w	(a0)+,2(a1)
	lea	4(a1),a1
	dbf	d0,SePa1
	lea	TSSPal,a0
	lea	CLPal2,a1
	move.w	#15,d0
SePa2:	move.w	(a0)+,2(a1)
	lea	4(a1),a1
	dbf	d0,SePa2
	rts

;*******************************************************************

;a0-palette a1-copperlist
Fade:
Fa1:
	move.w	2(a1),d1
	move.w	(a0)+,d2
	move.w	d1,d3
	move.w	d2,d4
	and.w	#$f00,d3
	and.w	#$f00,d4
	cmp.w	d3,d4
	beq.s	Fa2a
	bcs.s	Fa3a
	add.w	#$100,d1
	bra.s	Fa2a
Fa3a:	sub.w	#$100,d1
Fa2a:	move.w	d1,d3
	move.w	d2,d4
	and.w	#$0f0,d3
	and.w	#$0f0,d4
	cmp.w	d3,d4
	beq.s	Fa2b
	bcs.s	Fa3b
	add.w	#$010,d1
	bra.s	Fa2b
Fa3b:	sub.w	#$010,d1
Fa2b:	move.w	d1,d3
	move.w	d2,d4
	and.w	#$00f,d3
	and.w	#$00f,d4
	cmp.w	d3,d4
	beq.s	Fa2c
	bcs.s	Fa3c
	add.w	#$001,d1
	bra.s	Fa2c
Fa3c:	sub.w	#$001,d1
Fa2c:	move.w	d1,2(a1)
	lea	4(a1),a1
	dbf	d0,Fa1
	rts

;*******************************************************************

MoveStars:
	sub.b	#1,Anim
	bmi.s	MoveS
	rts
MoveS:	move.b	#2,Anim
	move.l	S1Ptr,a0
	lea	0*1152+Stars,a1
	move.w	S1Num,d0
	cmp.b	#8,d0
	bhi.s	MoSa1b
	lsl.w	#7,d0
	lea	0(a1,d0.w),a1
	bsr.L	Bob
MoSa1b:	add.b	#1,S1Num+1
	cmp.b	#StarPoc,S1Num+1
	bne.s	MoSa1
	clr.b	S1Num+1
MoSa1:	move.l	S2Ptr,a0
	lea	1*1152+Stars,a1
	move.w	S2Num,d0
	cmp.b	#8,d0
	bhi.s	MoSa2b
	lsl.w	#7,d0
	lea	0(a1,d0.w),a1
	bsr.L	Bob
MoSa2b:	add.b	#1,S2Num+1
	cmp.b	#StarPoc,S2Num+1
	bne.s	MoSa2
	clr.b	S2Num+1
MoSa2:	move.l	S3Ptr,a0
	lea	2*1152+Stars,a1
	move.w	S3Num,d0
	cmp.b	#8,d0
	bhi.s	MoSa3b
	lsl.w	#7,d0
	lea	0(a1,d0.w),a1
	bsr.L	Bob
MoSa3b:	add.b	#1,S3Num+1
	cmp.b	#StarPoc,S3Num+1
	bne.s	MoSa3
	clr.b	S3Num+1
MoSa3:	move.l	S4Ptr,a0
	lea	3*1152+Stars,a1
	move.w	S4Num,d0
	cmp.b	#8,d0
	bhi.s	MoSa4b
	lsl.w	#7,d0
	lea	0(a1,d0.w),a1
	bsr.L	Bob
MoSa4b:	add.b	#1,S4Num+1
	cmp.b	#StarPoc,S4Num+1
	bne.s	MoSa4
	clr.b	S4Num+1
MoSa4:	move.l	S5Ptr,a0
	lea	4*1152+Stars,a1
	move.w	S5Num,d0
	cmp.b	#8,d0
	bhi.s	MoSa5b
	lsl.w	#7,d0
	lea	0(a1,d0.w),a1
	bsr.L	Bob
MoSa5b:	add.b	#1,S5Num+1
	cmp.b	#StarPoc,S5Num+1
	bne.s	MoSa5
	clr.b	S5Num+1
MoSa5:	move.l	S6Ptr,a0
	lea	5*1152+Stars,a1
	move.w	S6Num,d0
	cmp.b	#8,d0
	bhi.s	MoSa6b
	lsl.w	#7,d0
	lea	0(a1,d0.w),a1
	bsr.L	Bob
MoSa6b:	add.b	#1,S6Num+1
	cmp.b	#StarPoc,S6Num+1
	bne.s	MoSa6
	clr.b	S6Num+1
MoSa6:	move.l	S7Ptr,a0
	lea	6*1152+Stars,a1
	move.w	S7Num,d0
	cmp.b	#8,d0
	bhi.s	MoSa7b
	lsl.w	#7,d0
	lea	0(a1,d0.w),a1
	bsr.s	Bob
MoSa7b:	add.b	#1,S7Num+1
	cmp.b	#StarPoc,S7Num+1
	bne.s	MoSa7
	clr.b	S7Num+1
MoSa7:	move.l	S8Ptr,a0
	lea	7*1152+Stars,a1
	move.w	S8Num,d0
	cmp.b	#8,d0
	bhi.s	MoSa8b
	lsl.w	#7,d0
	lea	0(a1,d0.w),a1
	bsr.s	Bob
MoSa8b:	add.b	#1,S8Num+1
	cmp.b	#StarPoc,S8Num+1
	bne.s	MoSa8
	clr.b	S8Num+1
MoSa8:	rts

Bob:	btst	#6,DMACONR(a6)
MoSt1:	btst	#6,DMACONR(a6)
	bne.s	MoSt1
	move.l	a1,BLTAPT(a6)
	move.l	a0,BLTDPT(a6)
	move.w	#0,BLTAMOD(a6)
	move.w	#32,BLTDMOD(a6)
	move.w	#$ffff,BLTALWM(a6)
	move.w	#$ffff,BLTAFWM(a6)
	move.w	#0,BLTCON1(a6)
	move.w	#$09f0,BLTCON0(a6)
	move.w	#64*16*4+1,BLTSIZE(a6)
	rts

;*******************************************************************

ProcVBL:
	tst.b	OKHalt
	beq.s	PrVl
	btst	#6,$bfe001
	beq.s	PoVl
	btst	#7,$bfe001
	beq.s	PoVl
	bra.s	PrVl
PoVl:	sf	OKHalt
	lea	Halt,a0
	move.l	a0,68(sp)
PrVl:	tst.l	WCnt
	beq.s	PrVb
	sub.l	#1,WCnt
PrVb:	st	ByloVBL
	move.w	#15,d0
	move.l	PalPtr,a0
	lea	CLPal1,a1
	bsr.L	Fade
	sub.b	#1,PalDel
	bpl.L	Pr1
	move.b	#PalVar,PalDel
	sub.b	#1,PalNum
	bpl.s	Pr2
	move.b	#3,PalNum
Pr2:	lea	RobboPal0,a0
	cmp.b	#0,PalNum
	beq.s	Pr3
	lea	RobboPal1,a0
	cmp.b	#1,PalNum
	beq.s	Pr3
	lea	RobboPal2,a0
	cmp.b	#2,PalNum
	beq.s	Pr3
	lea	RobboPal3,a0
Pr3:	move.l	a0,PalPtr
Pr1:	bsr.L	MoveStars

;*******************************************************************

Sprites:
	eor.b	#$ff,Sprt
	beq.s	SQ
	lea	StarsT,a0
	lea	StarsPtr,a1
	move.w	#29,d0
	moveq	#2,d1
Sp1:	move.l	(a1)+,a2
	move.w	(a0),(a2)
	add.w	d1,(a0)+
	add.b	#1,d1
	cmp.b	#4,d1
	bne.s	Sp2
	moveq	#1,d1
Sp2:
	dbf	d0,Sp1
SQ:	rts

;*******************************************************************

VBL:
	move.w	d0,-(sp)
	move.w	INTREQR+CUSTOM,d0
	btst	#5,d0
	beq.s	QuitV
	tst.b	WykonujVBL
	beq.s	QuitV
	movem.l	d0-d7/a0-a6,-(sp)
	lea	CUSTOM,a6
	bsr.L	ProcVBL
	movem.l	(sp)+,d0-d7/a0-a6
QuitV:	and.w	#$7fff,d0
	move.w	d0,INTREQ+CUSTOM
	move.w	(sp)+,d0
	rte

;*******************************************************************

StartVBL:
	st	WykonujVBL
	rts

;*******************************************************************

StopVBL:
	sf	WykonujVBL
	rts

;*******************************************************************

SetVBL:
	sf	WykonujVBL
	lea	VBL,a0
	move.l	a0,$6c
	move.w	#SETCLR+%100000+$4000,INTENA(a6)
	rts

;*******************************************************************

W:
	move.l	d0,WCnt
W0:	tst.l	WCnt
	bne.s	W0
	rts

;*******************************************************************

LMK:
	btst	#6,$bfe001
	bne.s	LMK
	rts

;*******************************************************************

WaitBlt:
	btst	#6,$dff002
WaBl1:	btst	#6,$dff002
	bne.s	WaBl1
	rts

;*******************************************************************

StartSystem:
	movem.l	d0-d7/a0-a6,-(sp)
	lea	GfxLibName,a1
	move.l	ExecBase,a6
	jsr	OldOpenLibrary(a6)
	move.l	d0,GfxLibBase
	exg	d0,a6
	jsr	OwnBlitter(a6)
	bsr.s	WaitBlt
	move.l	ExecBase,a6
	jsr	Forbid(a6)
	move.w	$dff002,MemDma
	move.w	$dff01c,MemInt
	or.w	#$8000,MemDma
	or.w	#$8000,MemInt
	move.w	#$7fff,$dff09a
	move.w	#$7fff,$dff096
	lea	MemVectors,a0
	lea	0,a1
	lea	Reset,a2
	moveq	#63,d0
StSy1:	move.l	(a1),(a0)+
	move.l	a2,(a1)+
	dbf	d0,StSy1
	bsr.s	InstEI
	movem.l	(sp)+,d0-d7/a0-a6
	rts

;*******************************************************************

StopSystem:
	movem.l	d0-d7/a0-a6,-(sp)
	move.w	#$7fff,$dff09a
	move.w	#$7fff,$dff096
	lea	MemVectors,a0
	lea	0,a1
	moveq	#63,d0
StSs1:	move.l	(a0)+,(a1)+
	dbf	d0,StSs1
	move.l	GfxLibBase,a6
	move.l	$26(a6),$dff080
	move.w	MemDma,$dff096
	move.w	MemInt,$dff09a
	move.l	ExecBase,a6
	jsr	Permit(a6)
	move.l	GfxLibBase,a6
	jsr	DisownBlitter(a6)
	exg	a6,a1
	move.l	ExecBase,a6
	jsr	CloseLibrary(a6)
	movem.l	(sp)+,d0-d7/a0-a6
	rts

;*******************************************************************

InstEI:
	lea	EmptyInt,a0
	move.l	a0,$64
	move.l	a0,$68
	move.l	a0,$6c
	move.l	a0,$70
	move.l	a0,$74
	move.l	a0,$78
	move.l	a0,$7c
	rts

;*******************************************************************

EmptyInt:
	move.w	d0,-(sp)
	move.w	INTREQR+CUSTOM,d0
	and.w	#$7fff,d0
	move.w	d0,INTREQ+CUSTOM
	move.w	(sp)+,d0
	rte

;*******************************************************************

Reset:
	move.w	#$7fff,$dff09a
	move.w	#$7fff,$dff096
	lea	ResetP,a0
	move.l	a0,$80
	trap	#0
ResetP:	clr.l	ExecBase
	lea	2,a0
	reset
	jmp	(a0)

;*******************************************************************
;			CONSTANS
;*******************************************************************

ExecBase	=	4
OldOpenLibrary	=	-408
CloseLibrary	=	-414
OwnBlitter	=	-456
DisownBlitter	=	-462
Forbid		=	-132
Permit		=	-138
CUSTOM		=	$dff000
BLTDDAT		=	$000
DMACONR		=	$002
VPOSR		=	$004
VHPOSR		=	$006
DSKDATR		=	$008
JOY0DAT		=	$00A
JOY1DAT		=	$00C
CLXDAT		=	$00E
ADKCONR		=	$010
POT0DAT		=	$012
POT1DAT		=	$014
POTGOR		=	$016
SERDATR		=	$018
DSKBYTR		=	$01A
INTENAR		=	$01C
INTREQR		=	$01E
DSKPTH		=	$020
DSKPTL		=	$022
DSKLEN		=	$024
DSKDAT		=	$026
REFPTR		=	$028
VPOSW		=	$02A
VHPOSW		=	$02C
COPCON		=	$02E
SERDAT		=	$030
SERPER		=	$032
POTGO		=	$034
JOYTEST		=	$036
STRQU		=	$038
STRVBL		=	$03A
STRHOR		=	$03C
STRLONG		=	$03E
BLTCON0		=	$040
BLTCON1		=	$042
BLTAFWM		=	$044
BLTALWM		=	$046
BLTCPT		=	$048
BLTBPT		=	$04C
BLTAPT		=	$050
BLTDPT		=	$054
BLTSIZE		=	$058
BLTCMOD		=	$060
BLTBMOD		=	$062
BLTAMOD		=	$064
BLTDMOD		=	$066
BLTCDAT		=	$070
BLTBDAT		=	$072
BLTADAT		=	$074
DSKSYNC		=	$07E
COP1PTR		=	$080
COP2PTR		=	$084
COP1LCH		=	$080
COP1LCL		=	$082
COP2LCH		=	$084
COP2LCL		=	$086
COPJMP1		=	$088
COPJMP2		=	$08A
COPINS		=	$08C
DIWSTRT		=	$08E
DIWSTOP		=	$090
DDFSTRT		=	$092
DDFSTOP		=	$094
DMACON		=	$096
CLXCON		=	$098
INTENA		=	$09A
INTREQ		=	$09C
ADKCON		=	$09E
AUDIO0		=	$0A0
AUDIO1		=	$0B0
AUDIO2		=	$0C0
AUDIO3		=	$0D0
BPL1PTH		=	$0E0
BPL1PTL		=	$0E2
BPL2PTH		=	$0E4
BPL2PTL		=	$0E6
BPL3PTH		=	$0E8
BPL3PTL		=	$0EA
BPL4PTH		=	$0EC
BPL4PTL		=	$0EE
BPL5PTH		=	$0F0
BPL5PTL		=	$0F2
BPL6PTH		=	$0F4
BPL6PTL		=	$0F6
BPLCON0		=	$100
BPLCON1		=	$102
BPLCON2		=	$104
BPL1MOD		=	$108
BPL2MOD		=	$10A
SPRPTR		=	$120
SPRPOS		=	$140
COLORS		=	$180
SETCLR		=	$8000
DSKEN		=	$10
SPREN		=	$20
BLTEN		=	$40
COPEN		=	$80
BPLEN		=	$100
DMAEN		=	$200
BLTPR		=	$400
ERSY		=	$2
LACE		=	$4
LPEN		=	$8
GAUD		=	$100
COLOR		=	$200
DBLPF		=	$400
HOMOD		=	$800
BPU0		=	$1000
BPU1		=	$2000
BPU2		=	$4000
HIRES		=	$8000
COPWAIT		=	$fffe
ENDCOPLST	=	$ffff
ENDHALF		=	$ffdf
KEYTALO		=	$bfe401
KEYTAHI		=	$bfe501
KEYCRA		=	$bfee01
KEYSDR		=	$bfec01
KEYICR		=	$bfed01
TBLO		=	$bfd600
TBHI		=	$bfd700
CRB		=	$bfdf00
ICR		=	$bfdd00
SPR0POS		=	$140
SPR0CTL		=	$142
SPR0DATA	=	$144
SPR0DATB	=	$146
SPR1POS		=	$148
SPR1CTL		=	$14a
SPR1DATA	=	$14c
SPR1DATB	=	$14e
SPR2POS		=	$150
SPR2CTL		=	$152
SPR2DATA	=	$154
SPR2DATB	=	$156
SPR3POS		=	$158
SPR3CTL		=	$15a
SPR3DATA	=	$15c
SPR3DATB	=	$15e
SPR4POS		=	$160
SPR4CTL		=	$162
SPR4DATA	=	$164
SPR4DATB	=	$166
SPR5POS		=	$168
SPR5CTL		=	$16a
SPR5DATA	=	$16c
SPR5DATB	=	$16e
SPR6POS		=	$170
SPR6CTL		=	$172
SPR6DATA	=	$174
SPR6DATB	=	$176
SPR7POS		=	$178
SPR7CTL		=	$17a
SPR7DATA	=	$17c
SPR7DATB	=	$17e

;*******************************************************************
;			FAST DATA
;*******************************************************************

	;--- System. ---

SysStat:	dc.b	0
GfxLibName:	dc.b	'graphics.library',0
	EVEN

	incdir	'dh1:sources/asm/robbo/bin/startbin/'

TSSPal:		incbin	'StartTSS.PAL'

RobboPal3:	
	dc.w	$000,$222,$555,$777,$aaa,$ddd,$f00
	dc.w	$633,$666,$699,$6cc,$6ff
	dc.w	$321,$543,$765,$a98

RobboPal2:	
	dc.w	$000,$222,$555,$777,$aaa,$ddd,$f00
	dc.w	$102,$204,$306,$408,$50a
	dc.w	$321,$543,$765,$a98

RobboPal1:	
	dc.w	$000,$222,$555,$777,$aaa,$ddd,$f00
	dc.w	$100,$300,$500,$700,$800
	dc.w	$321,$543,$765,$a98

RobboPal0:	
	dc.w	$000,$222,$555,$777,$aaa,$ddd,$f00
	dc.w	$303,$606,$919,$c3c,$f5f
	dc.w	$321,$543,$765,$a98

Pal000:	blk.w	32,$000

Fonts:	incbin	'StartFont.BIN'
StarsT:	incbin	'StarsT.BIN'

Txt1:	dc.b	12,1,'*** Robbo ***',248,10
	dc.b	2,4,'Dystrybucja:',10
	dc.b	11,6,'TWIN SPARK SOFT',10
	dc.b	2,8,'napisa',238,':',10
	dc.b	9,10,'S',238,'awomir Jura',238,'owicz',0
Txt2:	dc.b	2,1,'Wzorowane na wersji 8-bitowej',10
	dc.b	2,3,'wydanej przez:',10
	dc.b	13,5,'L.K. AVALON',10
	dc.b	2,7,'Pomys',238,':',10
	dc.b	13,9,'Janusz Pelc',0
Txt3:	dc.b	13,5,'Instrukcja:',0
Txt4:	dc.b	6,3,'Postaci',230,' mo',254,'esz sterowa',231,10
	dc.b	4,5,'joystick-iem lub klawiatur',230,'.',0
Txt5:	dc.b	6,3,'Naciskaj',230,'c przycisk FIRE',10
	dc.b	2,5,'( lub klawisz SHIFT ) i wskazuj',230,'c',10
	dc.b	6,7,'kierunek mo',254,'esz strzela',231,'.',0
Txt6:	dc.b	0,1,'Je',245,'li znajdziesz si',234,' w sytuacji bez',10
	dc.b	2,3,'wyj',245,'cia naci',245,'nij klawisz ESCAPE.',10
	dc.b	3,5,'B',234,'dziesz m',243,'g',238,' pr',243,'bowa',231,' przejs',231,10
	dc.b	6,7,'dan',230,' plansz',234,' jeszcze raz.',0
Txt7:	dc.b	17,1,'- Robbo -',10
	dc.b	10,5,'Bohater kt',243,'rym sterujesz.',0
Txt8:	dc.b	16,1,'- Kapsu',238,'a -',10
	dc.b	9,4,'Przeniesie Ci',234,' na nastepn',230,10
	dc.b	17,6,'planet',234,'.',0
Txt9:	dc.b	16,1,'- ',213,'rubka -',10
	dc.b	9,4,'Musisz zebra',231,' je wszystkie',10
	dc.b	10,6,'aby m',243,'c naprawi',231,' kapsu',238,234,10
	dc.b	10,8,'i dosta',231,' si',234,' na kolejn',230,10
	dc.b	17,10,'planet',234,'.',0
Txt10:	dc.b	16,1,'- Bateria -',10
	dc.b	12,4,'Potrzebujesz jej do',10
	dc.b	12,6,'zasilania kapsu',238,'y.',0
Txt11:	dc.b	16,1,'- Krata -',10
	dc.b	12,4,'Mo',254,'esz j',230,' pcha',231,' aby',10
	dc.b	15,6,'m',243,'c przej',245,231,'.',0
Txt12:	dc.b	13,1,'- Krata ruchoma -',10
	dc.b	10,4,'Po popchni',234,'ciu b',234,'dzie',10
	dc.b	13,6,'toczy',231,' si',234,' sama.',0
Txt13:	dc.b	16,1,'- Bomba -',10
	dc.b	12,4,'Zestrzelona niszczy',10
	dc.b	11,6,'wszystko wok',243,238,' siebie.',0
Txt14:	dc.b	16,1,'- Drzwi -',10
	dc.b	11,4,'Aby przez nie przej',245,231,10
	dc.b	11,6,'musisz posiada',231,' klucz.',0
Txt15:	dc.b	17,1,'- Klucz -',10
	dc.b	11,4,'Potrzebny do otwierania',10
	dc.b	19,6,'drzwi.',0
Txt16:	dc.b	13,1,'- Niespodzianka -',10
	dc.b	9,4,'Po zestrzeleniu jej pojawi',10
	dc.b	12,6,'si',234,' nowy przedmiot.',0
Txt17:	dc.b	16,1,'- Lustro -',10
	dc.b	9,4,'Przenosi Ci',234,' w inn',230,' cz',234,245,231,10
	dc.b	17,6,'planszy.',0
Txt18:	dc.b	12,1,'- Dodatkowy Robbo -',10
	dc.b	10,4,'Zwi',234,'ksza ilo',245,231,' mo',254,'liwych',10
	dc.b	17,6,'pomy',238,'ek.',0
Txt19:	dc.b	16,1,'- Naboje -',10
	dc.b	9,5,'Umo',254,'liwiaj',230,' Ci strzelanie.',0
Txt20:	dc.b	16,1,'- Magnes -',10
	dc.b	14,5,'Niszczy Robbo.',0
Txt21:	dc.b	12,1,'- Dzia',238,'o obrotowe -',10
	dc.b	9,4,'Strzela ogniem przerywanym',10
	dc.b	14,6,'w r',243,254,'ne strony.',0
Txt22:	dc.b	14,1,'- Laser, Fazer -',10
	dc.b	11,4,'Strzela ogniem ci',230,'gym',10
	dc.b	14,6,'w jedn',230,' stron',234,'.',0
Txt23:	dc.b	15,1,'- Nietoperz -',10
	dc.b	11,4,'W zetkni',234,'ciu z Robbbo',10
	dc.b	16,6,'niszczy go.',0
Txt24:	dc.b	15,1,'- Potworek -',10
	dc.b	11,4,'W zetkni',234,'ciu z Robbbo',10
	dc.b	16,6,'niszczy go.',0
Txt25:	dc.b	11,5,'Powodzenia !!!',0
	EVEN

;*******************************************************************
;			POINTERS
;*******************************************************************

;*******************************************************************
;			FAST WORK
;*******************************************************************

	;--- System. ---

GfxLibBase:	dc.l	0
MemStack:	dc.l	0
MemDma:		dc.w	0
MemInt:		dc.w	0
MemVectors:	blk.l	64
Stack:		blk.b	STACKSIZE
	EVEN

	;--- VBL. ---

Anim:		dc.b	0
ByloVBL:	dc.b	0
WykonujVBL:	dc.b	0
PalNum:		dc.b	0
PalDel:		dc.b	0
OKHalt:		dc.b	0
Sprt:		dc.b	0
	EVEN

PalPtr:		dc.l	0
WCnt:		dc.l	0
MST:		dc.l	0

YPtr:		blk.l	12,0

S1Ptr:	dc.l	0
S2Ptr:	dc.l	0
S3Ptr:	dc.l	0
S4Ptr:	dc.l	0
S5Ptr:	dc.l	0
S6Ptr:	dc.l	0
S7Ptr:	dc.l	0
S8Ptr:	dc.l	0

S1Num:	dc.w	0
S2Num:	dc.w	0
S3Num:	dc.w	0
S4Num:	dc.w	0
S5Num:	dc.w	0
S6Num:	dc.w	0
S7Num:	dc.w	0
S8Num:	dc.w	0

StarsPtr:	blk.l	30,0

;*******************************************************************
;			CHIP DATA
;*******************************************************************

CL:
	dc.w	SPR0CTL,0,SPR1CTL,0,SPR2CTL,0,SPR3CTL,0
	dc.w	SPR4CTL,0,SPR5CTL,0,SPR6CTL,0,SPR7CTL,0
	dc.w	SPR0DATB,0
	dc.w	SPR1DATB,1
	dc.w	SPR2DATB,0
	dc.w	SPR0CTL,0,SPR0POS,$0,SPR0DATA,1
	dc.w	SPR1CTL,0,SPR1POS,$0,SPR1DATA,1
	dc.w	SPR2CTL,0,SPR2POS,$0,SPR2DATA,1
	dc.w	$2003,COPWAIT
CLPal1:	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
CLPtr1:	dc.w	$e0,0,$e2,0
	dc.w	$e4,0,$e6,0
	dc.w	$e8,0,$ea,0
	dc.w	$ec,0,$ee,0
	dc.w	DDFSTRT,8*8
	dc.w	DDFSTOP,8*8+128
	dc.w	DIWSTRT,$0390
	dc.w	DIWSTOP,$7fae
	dc.w	BPLCON1,$88
	dc.w	BPLCON2,0
	dc.w	BPL1MOD,34*3
	dc.w	BPL2MOD,34*3
	dc.w	$3a03,COPWAIT
	dc.w	BPLCON0,COLOR+BPU2
	dc.w	$8c03,COPWAIT
	dc.w	BPLCON0,COLOR
CLPal2:	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
CLPtr2:	dc.w	$e0,0,$e2,0
	dc.w	$e4,0,$e6,0
	dc.w	$e8,0,$ea,0
	dc.w	$ec,0,$ee,0
	dc.w	DDFSTRT,7*8
	dc.w	DDFSTOP,7*8+136
	dc.w	BPL1MOD,36*3
	dc.w	BPL2MOD,36*3
	dc.w	BPLCON1,$ff
	dc.w	$9203,COPWAIT
	dc.w	BPLCON0,COLOR+BPU2,$182,$000
	dc.w	$9203,COPWAIT,$182,$1
	dc.w	$9303,COPWAIT,$182,$2
	dc.w	$9403,COPWAIT,$182,$3
	dc.w	$9503,COPWAIT,$182,$4
	dc.w	$9603,COPWAIT,$182,$5
	dc.w	$9703,COPWAIT,$182,$6
	dc.w	$9803,COPWAIT,$182,$7
	dc.w	$9903,COPWAIT,$182,$8
	dc.w	$9a03,COPWAIT,$182,$9
	dc.w	$9b03,COPWAIT,$182,$8
	dc.w	$9c03,COPWAIT,$182,$7
	dc.w	$9d03,COPWAIT,$182,$6
	dc.w	$9e03,COPWAIT,$182,$5
	dc.w	$9f03,COPWAIT,$182,$4
	dc.w	$a003,COPWAIT,$182,$3
	dc.w	$a103,COPWAIT,$182,$2
	dc.w	$a203,COPWAIT,$182,$1
	dc.w	$a303,COPWAIT,$182,$0
	dc.w	$a403,COPWAIT
	dc.w	BPLCON0,COLOR
CLPtr3:	dc.w	$e0,0,$e2,0
	dc.w	$e4,0,$e6,0
	dc.w	$e8,0,$ea,0
	dc.w	$ec,0,$ee,0
	dc.w	$f0,0,$f2,0
CLPal3:	dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
	dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
	dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0
	dc.w	BPL1MOD,36*4
	dc.w	BPL2MOD,36*4
	dc.w	$aa47,COPWAIT,$180,$100,$aad5,COPWAIT,$180,$0
	dc.w	$ab47,COPWAIT,$180,$200,$abd5,COPWAIT,$180,$0
	dc.w	$ac47,COPWAIT,$180,$300,$acd5,COPWAIT,$180,$0
	dc.w	$ad47,COPWAIT,$180,$400,$add5,COPWAIT,$180,$0
	dc.w	$ae47,COPWAIT,$180,$500,$aed5,COPWAIT,$180,$0
	dc.w	$af47,COPWAIT,$180,$600,$afd5,COPWAIT,$180,$0
	dc.w	$b103,COPWAIT,BPLCON0,COLOR+BPU2+BPU0
CLStars:
	dc.w	$b203,COPWAIT,SPR1POS,$4321
	dc.w	$b303,COPWAIT,SPR1POS,0
	dc.w	$b503,COPWAIT,SPR0POS,$4321
	dc.w	$b603,COPWAIT,SPR0POS,0
	dc.w	$b803,COPWAIT,SPR2POS,$4321
	dc.w	$b903,COPWAIT,SPR2POS,0
	dc.w	$bb03,COPWAIT,SPR1POS,$4321
	dc.w	$bc03,COPWAIT,SPR1POS,0
	dc.w	$be03,COPWAIT,SPR0POS,$4321
	dc.w	$bf03,COPWAIT,SPR0POS,0
	dc.w	$c203,COPWAIT,SPR2POS,$4321
	dc.w	$c303,COPWAIT,SPR2POS,0
	dc.w	$c503,COPWAIT,SPR1POS,$4321
	dc.w	$c603,COPWAIT,SPR1POS,0
	dc.w	$c803,COPWAIT,SPR0POS,$4321
	dc.w	$c903,COPWAIT,SPR0POS,0
	dc.w	$cb03,COPWAIT,SPR2POS,$4321
	dc.w	$cc03,COPWAIT,SPR2POS,0
	dc.w	$ce03,COPWAIT,SPR1POS,$4321
	dc.w	$cf03,COPWAIT,SPR1POS,0
	dc.w	$d203,COPWAIT,SPR0POS,$4321
	dc.w	$d303,COPWAIT,SPR0POS,0

	dc.w	$d403,COPWAIT,$182,$7
	dc.w	$d503,COPWAIT,$182,$6,SPR2POS,$4321
	dc.w	$d603,COPWAIT,$182,$5,SPR2POS,0
	dc.w	$d703,COPWAIT,$182,$4
	dc.w	$d803,COPWAIT,$182,$3,SPR1POS,$4321
	dc.w	$d903,COPWAIT,$182,$2,SPR1POS,0
	dc.w	$da03,COPWAIT,$182,$1
	dc.w	$db03,COPWAIT,$182,$0,SPR0POS,$4321
	dc.w	$dc03,COPWAIT,SPR0POS,0
	dc.w	$de03,COPWAIT,SPR2POS,$4321
	dc.w	$df03,COPWAIT,SPR2POS,0
	dc.w	$e203,COPWAIT,SPR1POS,$4321
	dc.w	$e303,COPWAIT,SPR1POS,0
	dc.w	$e503,COPWAIT,SPR0POS,$4321
	dc.w	$e603,COPWAIT,SPR0POS,0
	dc.w	$e703,COPWAIT,$182,$1
	dc.w	$e803,COPWAIT,$182,$2,SPR2POS,$4321
	dc.w	$e903,COPWAIT,$182,$3,SPR2POS,0
	dc.w	$ea03,COPWAIT,$182,$4
	dc.w	$eb03,COPWAIT,$182,$5,SPR1POS,$4321
	dc.w	$ec03,COPWAIT,$182,$6,SPR1POS,0
	dc.w	$ed03,COPWAIT,$182,$7

	dc.w	$ee03,COPWAIT,SPR0POS,$4321
	dc.w	$ef03,COPWAIT,SPR0POS,0
	dc.w	$f203,COPWAIT,SPR2POS,$4321
	dc.w	$f203,COPWAIT,SPR2POS,0
	dc.w	$f503,COPWAIT,SPR1POS,$4321
	dc.w	$f603,COPWAIT,SPR1POS,0
	dc.w	$f803,COPWAIT,SPR0POS,$4321
	dc.w	$f903,COPWAIT,SPR0POS,0
	dc.w	$fb03,COPWAIT,SPR2POS,$4321
	dc.w	$fc03,COPWAIT,SPR2POS,0
	dc.w	$fe03,COPWAIT,SPR1POS,$4321
	dc.w	$ff03,COPWAIT,SPR1POS,0

	dc.w	ENDHALF,COPWAIT

	dc.w	$0203,COPWAIT,SPR0POS,$4321
	dc.w	$0303,COPWAIT,SPR0POS,0
	dc.w	$0503,COPWAIT,SPR2POS,$4321
	dc.w	$0603,COPWAIT,SPR2POS,0
	dc.w	$0803,COPWAIT,SPR1POS,$4321
	dc.w	$0903,COPWAIT,SPR1POS,0
	dc.w	$0b03,COPWAIT,SPR0POS,$4321
	dc.w	$0c03,COPWAIT,SPR0POS,0
	dc.w	$0e03,COPWAIT,SPR2POS,$4321
	dc.w	$0f03,COPWAIT,SPR2POS,0

	dc.w	$1103,COPWAIT,BPLCON0,COLOR
	dc.w	$1447,COPWAIT,$180,$600,$14d5,COPWAIT,$180,$0
	dc.w	$1547,COPWAIT,$180,$500,$15d5,COPWAIT,$180,$0
	dc.w	$1647,COPWAIT,$180,$400,$16d5,COPWAIT,$180,$0
	dc.w	$1747,COPWAIT,$180,$300,$17d5,COPWAIT,$180,$0
	dc.w	$1847,COPWAIT,$180,$200,$18d5,COPWAIT,$180,$0
	dc.w	$1947,COPWAIT,$180,$100,$19d5,COPWAIT,$180,$0
	dc.w	ENDCOPLST,COPWAIT

RobboPic:	incbin	'StartRobbo.BIN'
TSSPic:		incbin	'StartTSS.BIN'
EyesPic:	incbin	'Eyes.BIN'
EyesPal:	incbin	'Eyes.PAL'
BoxPic:		incbin	'Box.BIN'
BoxPal:		incbin	'Box.PAL'
BoxPal2:	incbin	'Box.PAL'
BoxPal3:	incbin	'Box.PAL'
KeyPic:		incbin	'Key.BIN'
KeyPal:		incbin	'Key.PAL'
Examples:	incbin	'Examples.BIN'
Stars:		incbin	'Stars.BIN'
Down:		blk.b	36*5*DY,0

;*******************************************************************
;			CHIP WORK
;*******************************************************************

Stop:
