BitOffset	=	8
BitBlok		=	4
MaxOffset	=	256
MaxBlok		=	16
MinBlok		=	2

	lea	Data,a0
	lea	Buf,a1
	move.l	#Buf-Data,d0
	bsr.s	Crunch
	rts

;*******************************************************************

;In:
;a0.l - Data
;a1.l - Bufor (Even)
;d0.l - Size

;Out:
;d0.l - NewSize (=0 - error)

Crunch:
	move.l	a7,Stos
	move.l	d0,d5
	movea.l	a0,a2
	add.l	d0,a2
	movea.l	a0,a3
	movea.l	a0,a6
	move.l	d0,(a1)+
	moveq	#4,d0
	moveq	#7,d7
Cru0:	cmpa.l	a3,a2		;czy koniec
	beq.s	Cru6
Cru1:	move.l	a3,d1		;ile od poczatku do znacznika
	sub.l	a0,d1
	move.l	a2,d2		;ile od znacznika do konca
	sub.l	a3,d2
	cmp.l	#MaxOffset,d1	;czy offset nie za dlugi
	bls.s	Cru2
	move.l	#MaxOffset,d1
Cru2:	cmp.l	#MaxBlok,d2	;czy blok nie za dlugi
	bls.s	Cru3
	move.l	#MaxBlok,d2
Cru3:	cmp.l	d1,d2		;czy blok miesci sie w offsecie
	bls.s	Cru4
	move.l	d1,d2
Cru4:	move.l	d1,d4		;zapamietanie offsetu
Cru10:	cmp.l	#MinBlok,d2	;czy tak maly blok moze byc
	bls.s	Cru5
Cru9:	movea.l	a3,a4		;poczatek bloku do przeszukania
	suba.l	d1,a4
	movea.l	a3,a5		;adres porownania
	move.l	d2,d3		;licznik bajtu
Cru7:	cmpm.b	(a4)+,(a5)+	;porownanie
	bne.s	Cru8
	subq.l	#1,d3
	bne.s	Cru7
	bsr.s	PutNoCrunch
	bsr.L	Put1		;dane spakowane
	bsr.s	PutBlok
	bsr.L	PutOffset
	adda.l	d2,a3		;opusc porownane bajty
	movea.l	a3,a6
	bra.s	Cru0
Cru8:	subq.l	#1,d1		;zmniejszenie offsetu
	cmp.l	d2,d1		;czy w offsecie zmiesci sie blok
	bcc.s	Cru9		;tak
	move.l	d4,d1		;zwrot offsetu
	subq.l	#1,d2		;zmniejszenie bloku
	bra.s	Cru10
Cru5:	lea	1(a3),a3
	bra.s	Cru0
Cru6:	bsr.s	PutNoCrunch
	tst.l	d0
	rts

Halt:	move.l	Stos,a7
	moveq	#0,d0
	rts

;*******************************************************************

;a6.l - Start
;a3.l - Stop
;d2.l - BlokSize - obliczone
PutNoCrunch:
	move.l	d2,-(sp)
	cmpa.l	a3,a6
	beq.s	PNC0
PNC2:	move.l	a3,d2
	sub.l	a6,d2		;dlugosc bloku
	cmp.l	#MaxBlok,d2
	bls.s	PNC1
	move.l	#MaxBlok,d2	;blok za dlugi
PNC1:	bsr.s	Put0		;dane nie spakowane
	bsr.s	PutBlok		;dlugosc bloku
PNC6:	moveq	#7,d6		;wyslanie bajtu
PNC5:	btst	d6,(a6)
	bne.s	PNC3
	bsr.s	Put0
	bra.s	PNC4
PNC3:	bsr.s	Put1
PNC4:	dbf	d6,PNC5
	lea	1(a6),a6
	subq.l	#1,d2
	bne.s	PNC6
	cmpa.l	a3,a6		;czy caly blok
	bne.s	PNC2
PNC0:	move.l	(sp)+,d2
	rts

;*******************************************************************

PutBlok:
	subq.l	#1,d2
	move.w	#BitBlok-1,d6
PuBl0:	btst	d6,d2
	bne.s	PuBl1
	bsr.s	Put0
	dbf	d6,PuBl0
	addq.l	#1,d2
	rts
PuBl1:	bsr.s	Put1
	dbf	d6,PuBl0
	addq.l	#1,d2
	rts

;*******************************************************************

PutOffset:
	subq.l	#1,d1
	move.w	#BitOffset-1,d6
PuOf0:	btst	d6,d1
	bne.s	PuOf1
	bsr.s	Put0
	dbf	d6,PuOf0
	addq.l	#1,d1
	rts
PuOf1:	bsr.s	Put1
	dbf	d6,PuOf0
	addq.l	#1,d1
	rts

;*******************************************************************

Put0:
	bclr	d7,(a1)
	subq.b	#1,d7
	bpl.s	Put00
	moveq	#7,d7
	lea	1(a1),a1
	addq.l	#1,d0
	cmp.l	d5,d0
	bcc.L	Halt
Put00:	rts

;*******************************************************************

Put1:
	bset	d7,(a1)
	subq.b	#1,d7
	bpl.s	Put10
	moveq	#7,d7
	lea	1(a1),a1
	addq.l	#1,d0
	cmp.l	d5,d0
	bcc.L	Halt
Put10:	rts

;*******************************************************************

;In:
;a0.l - Data (Even)
;a1.l - Bufor
DeCrunch:
	movea.l	a1,a2
	adda.l	(a0)+,a2		;adres konca
	moveq	#0,d7			;licznik bitow
DeCr1:	cmpa.l	a1,a2			;glowna petla
	bls.s	DeCr0			;wszystkie dane
	dbf	d7,GeBi1		;pobranie bitu
	move.l	(a0)+,d5
	moveq	#31,d7
GeBi1:	rol.l	#1,d5
	bcs.s	DCB			;dane spakowane
	clr.w	d0			;dlugosc danych nie spakow.
	move.w	#BitBlok-1,d6
GeBl0:	dbf	d7,GeBi3
	move.l	(a0)+,d5
	moveq	#31,d7
GeBi3:	roxl.l	#1,d5
	roxl.w	#1,d0
	dbf	d6,GeBl0
DeCr2:	move.w	#7,d6			;pobranie bajtu
GeBy0:	dbf	d7,GeBi2
	move.l	(a0)+,d5
	moveq	#31,d7
GeBi2:	roxl.l	#1,d5
	roxl.b	#1,d2
	dbf	d6,GeBy0
	move.b	d2,(a1)+		;wpis bajtu do pamieci
	dbf	d0,DeCr2		;nastepny bajt
	bra.s	DeCr1
DCB:	clr.w	d0			;blok spakowany
	move.w	#BitBlok-1,d6		;pobranie dlugosci bloku
GeBl00:	dbf	d7,GeBi30
	move.l	(a0)+,d5
	moveq	#31,d7
GeBi30:	roxl.l	#1,d5
	roxl.w	#1,d0
	dbf	d6,GeBl00
	clr.w	d1
	move.w	#BitOffset-1,d6		;pobranie offsetu
GeOf0:	dbf	d7,GeBi4
	move.l	(a0)+,d5
	moveq	#31,d7
GeBi4:	roxl.l	#1,d5
	roxl.w	#1,d1
	dbf	d6,GeOf0
	addq.l	#1,d1
	neg.w	d1
DeCr3:	move.b	0(a1,d1.w),(a1)+
	dbf	d0,DeCr3
	bra.s	DeCr1
DeCr0:	rts

;*******************************************************************

Stos:	dc.l	0

Data:	incbin	'DF0:'
Buf:	blk.b	400000
