STACKSIZE	=	1024

Start:
		bsr.L	StartSystem
		lea	Run_Begin,a6
		move.l	a6,$80
		trap	#0
		bra.s	Run_Quit
Run_Begin:	move.l	a7,MemStack
		lea	Stack+STACKSIZE,a7
		lea	CUSTOM,a6
		bsr.s	Program
Halt:		move.l	MemStack,a7
		rte
Run_Quit:	bsr.L	StopSystem
		move.l	Buf,d0
		rts

;*******************************************************************

Program:
		bsr.L	MotorOn
		bsr.L	MotorOK
		bsr.L	ToZero
		bsr.s	Read
		bsr.L	MotorOff
		bsr.s	Decode
		rts

;*******************************************************************

SIZE		=	14000

Decode:
		lea	BuforMFM(pc),a0
		lea	Buf(pc),a1
		move.w	#10,d3
De1:		cmp.w	#$4489,(a0)+
		bne.s	De1
De2:		cmp.w	#$4489,(a0)+
		beq.s	De2
		move.l	-2(a0),d0
		move.l	2(a0),d1
		and.l	#$55555555,d0
		and.l	#$55555555,d1
		lsl.l	#1,d0
		or.l	d1,d0
		lsr.w	#8,d0
		and.l	#$ff,d0
		lsl.l	#8,d0
		lsl.l	#1,d0
		lea	0(a1,d0.w),a2
		lea	54(a0),a3
		lea	566(a0),a0
		move.w	#127,d2
De3:		move.l	(a3)+,d0
		move.l	(a0)+,d1
		and.l	#$55555555,d0
		and.l	#$55555555,d1
		lsl.l	#1,d0
		or.l	d1,d0
		move.l	d0,(a2)+
		dbf	d2,De3
		dbf	d3,De1
		rts

;*******************************************************************

Read:
		bclr	#2,CIABPRB
		move.w	#SIZE/2,d0
		move.w	#0,DSKLEN(a6)
		move.w	#$8210,DMACON(a6)
		move.w	#$7fff,ADKCON(a6)
		move.w	#%1001010100000000,ADKCON(a6)
		move.w	#$4489,DSKSYNC(a6)
		move.l	#BuforMFM,DSKPTH(a6)
		move.w	#2,INTREQ(a6)
		or.w	#$8000,d0
		move.w	d0,DSKLEN(a6)
		move.w	d0,DSKLEN(a6)
Re0:		move.w	INTREQR(a6),d0
		btst	#1,d0
		bne.s	Re1
		btst	#6,$bfe001
		bne.s	Re0
Re1:		move.w	#0,DSKLEN(a6)
		move.w	#$10,DMACON(a6)
		rts

;*******************************************************************

ToZero:
		move.l	#50000,d0
TZ0:		btst	#4,CIAAPRA
		beq.s	TZQuit
		move.b	#%01110011,CIABPRB	;To 0
		move.b	#%01110010,CIABPRB	;To 0
		move.b	#%01110011,CIABPRB	;To 0
		bsr.s	Wait
		bra.s	TZ0
TZQuit:		move.l	#2000000,d0
		bra.s	Wait

;*******************************************************************

MotorOK:
		btst	#5,CIAAPRA		;RDY
		bne.s	MotorOK
		rts

;*******************************************************************

MotorOn:
		move.b	#%11111001,CIABPRB	;all off
		move.b	#%01111001,CIABPRB	;motor on
		move.b	#%01110001,CIABPRB	;drive on
		rts

;*******************************************************************

MotorOff:
		move.b	#%11111001,CIABPRB	;all off
		move.b	#%11111001,CIABPRB	;motor off
		move.b	#%11110001,CIABPRB	;drive on
		move.b	#%11111001,CIABPRB	;all off
		rts

;*******************************************************************

Wait:		move.l	d0,d1
Wai:		subq.l	#1,d1
		bne.s	Wai
		rts

;*******************************************************************

Init:
		lea	Vbl(pc),a0
		move.l	a0,$6c
		move.w	#%1100000000100000,INTENA+CUSTOM
		rts

;*******************************************************************

Vbl:
		move.w	d0,-(sp)
		move.w	INTREQR+CUSTOM,d0
		and.w	#$7fff,d0
		btst	#5,d0
		beq.s	Quit
		nop
Quit:		move.w	d0,INTREQ+CUSTOM
		move.w	(sp)+,d0
		rte

;*******************************************************************

LMK:
		btst	#6,$bfe001
		bne.s	LMK
		rts

;*******************************************************************

WaitBlitter:
		btst	#6,$dff002
WaBl1:		btst	#6,$dff002
		bne.s	WaBl1
		rts

;*******************************************************************

ExecBase	=	4
OldOpenLibrary	=	-408
CloseLibrary	=	-414
OwnBlitter	=	-456
DisownBlitter	=	-462

StartSystem:
		lea	GfxLibName,a1
		move.l	ExecBase,a6
		jsr	OldOpenLibrary(a6)
		move.l	d0,GfxLibBase
		exg	d0,a6
		jsr	OwnBlitter(a6)
		bsr.s	WaitBlitter
		move.l	$26(a6),OldCLPtr
		move.w	$dff002,MemDma
		move.w	$dff01c,MemInt
		or.w	#$8000,MemDma
		or.w	#$8000,MemInt
		move.w	#$7fff,$dff09a
		move.w	#$7fff,$dff096
		lea	MemVectors,a0
		lea	0,a1
		lea	Reset,a2
		moveq	#63,d0
StSy1:		move.l	(a1),(a0)+
		move.l	a2,(a1)+
		dbf	d0,StSy1
		rts

;*******************************************************************

StopSystem:
		move.w	#$7fff,$dff09a
		move.w	#$7fff,$dff096
		lea	MemVectors,a0
		lea	0,a1
		moveq	#63,d0
StSs1:		move.l	(a0)+,(a1)+
		dbf	d0,StSs1
		move.l	OldCLPtr,$dff080
		move.w	MemDma,$dff096
		move.w	MemInt,$dff09a
		move.l	GfxLibBase,a6
		jsr	DisownBlitter(a6)
		exg	a6,a1
		move.l	ExecBase,a6
		jsr	CloseLibrary(a6)
		rts

;*******************************************************************

Reset:
		move.w	#$7fff,$dff09a
		move.w	#$7fff,$dff096
		lea	ResetProc,a0
		move.l	a0,$80
		trap	#0
ResetProc:	clr.l	ExecBase
		lea	2,a0
		reset
		jmp	(a0)

;*******************************************************************
;			CONSTANS
;*******************************************************************

CUSTOM		=	$dff000
BLTDDAT		=	$000
DMACONR		=	$002
VPOSR		=	$004
VHPOSR		=	$006
DSKDATR		=	$008
JOY0DAT		=	$00A
JOY1DAT		=	$00C
CLXDAT		=	$00E
ADKCONR		=	$010
POT0DAT		=	$012
POT1DAT		=	$014
POTGOR		=	$016
SERDATR		=	$018
DSKBYTR		=	$01A
INTENAR		=	$01C
INTREQR		=	$01E
DSKPTH		=	$020
DSKPTL		=	$022
DSKLEN		=	$024
DSKDAT		=	$026
REFPTR		=	$028
VPOSW		=	$02A
VHPOSW		=	$02C
COPCON		=	$02E
SERDAT		=	$030
SERPER		=	$032
POTGO		=	$034
JOYTEST		=	$036
STRQU		=	$038
STRVBL		=	$03A
STRHOR		=	$03C
STRLONG		=	$03E
BLTCON0		=	$040
BLTCON1		=	$042
BLTAFWM		=	$044
BLTALWM		=	$046
BLTCPT		=	$048
BLTBPT		=	$04C
BLTAPT		=	$050
BLTDPT		=	$054
BLTSIZE		=	$058
BLTCMOD		=	$060
BLTBMOD		=	$062
BLTAMOD		=	$064
BLTDMOD		=	$066
BLTCDAT		=	$070
BLTBDAT		=	$072
BLTADAT		=	$074
DSKSYNC		=	$07E
COP1PTR		=	$080
COP2PTR		=	$084
COP1LCH		=	$080
COP1LCL		=	$082
COP2LCH		=	$084
COP2LCL		=	$086
COPJMP1		=	$088
COPJMP2		=	$08A
COPINS		=	$08C
DIWSTRT		=	$08E
DIWSTOP		=	$090
DDFSTRT		=	$092
DDFSTOP		=	$094
DMACON		=	$096
CLXCON		=	$098
INTENA		=	$09A
INTREQ		=	$09C
ADKCON		=	$09E
AUDIO0		=	$0A0
AUDIO1		=	$0B0
AUDIO2		=	$0C0
AUDIO3		=	$0D0
BPL1PTH		=	$0E0
BPL1PTL		=	$0E2
BPL2PTH		=	$0E4
BPL2PTL		=	$0E6
BPL3PTH		=	$0E8
BPL3PTL		=	$0EA
BPL4PTH		=	$0EC
BPL4PTL		=	$0EE
BPL5PTH		=	$0F0
BPL5PTL		=	$0F2
BPL6PTH		=	$0F4
BPL6PTL		=	$0F6
BPLCON0		=	$100
BPLCON1		=	$102
BPLCON2		=	$104
BPL1MOD		=	$108
BPL2MOD		=	$10A
SPRPTR		=	$120
SPRPOS		=	$140
COLORS		=	$180
RND		=	$bfd600
SETCLR		=	$8000
DSKEN		=	$10
SPREN		=	$20
BLTEN		=	$40
COPEN		=	$80
BPLEN		=	$100
DMAEN		=	$200
BLTPR		=	$400
ERSY		=	$2
LACE		=	$4
LPEN		=	$8
GAUD		=	$100
COLOR		=	$200
DBLPF		=	$400
HOMOD		=	$800
BPU0		=	$1000
BPU1		=	$2000
BPU2		=	$4000
HIRES		=	$8000
COPWAIT		=	$fffe
ENDCOPLST	=	$ffff
ENDHALF		=	$ffdf
KEYTALO		=	$bfe401
KEYTAHI		=	$bfe501
KEYCRA		=	$bfee01
KEYSDR		=	$bfec01
KEYICR		=	$bfed01
CIAAPRA		=	$bfe001
CIABPRB		=	$bfd100

;*******************************************************************
;			FAST DATA
;*******************************************************************

GfxLibName:	dc.b	'graphics.library',0
	EVEN

;*******************************************************************
;			FAST WORK
;*******************************************************************

MemStack:	dc.l	0
Stack:		blk.b	STACKSIZE,0
MemVectors:	blk.l	64,0
MemDma:		dc.w	0
MemInt:		dc.w	0
OldCLPtr:	dc.l	0
GfxLibBase:	dc.l	0

T:
BuforMFM:	blk.b	SIZE,0
Buf:		blk.b	512*22,0
