ExecBase	=	4
OldOpenLibrary	=	-408
CloseLibrary	=	-414
FindTask	=	-294
AddPort		=	-354
RemPort		=	-360
OpenDevice	=	-444
CloseDevice	=	-450
DoIO		=	-456
AllocMem	=	-198
FreeMem		=	-210

Open		=	-30
Close		=	-36
Read		=	-42
Write		=	-48
Output		=	-60
Seek		=	-66

MODE_OLD	=	1005
MODE_NEW	=	1006

Start:
	bsr.L	StartTD

	lea	DosName(pc),a1
	move.l	ExecBase,a6
	jsr	OldOpenLibrary(a6)
	lea	DosBase(pc),a0
	move.l	d0,(a0)
	beq.s	Err1

	move.l	DosBase(pc),a6
	jsr	Output(a6)
	lea	Handle(pc),a0
	move.l	d0,(a0)
	beq.s	Err2

	bsr.s	P

Err2:	move.l	DosBase(pc),a1
	move.l	ExecBase,a6
	jsr	CloseLibrary(a6)

Err1:	bsr.L	StopTD
	rts
Quit:	bsr.L	CR
	rts
;*******************************************************************

P:
	lea	Txt00(pc),a0
	bsr.L	Print
Program:
	bsr.L	CR
	lea	Txt1(pc),a0
	bsr.L	Print
	bsr.L	GetVal
	lea	StartPtr(pc),a0
	move.l	d0,(a0)
	lea	Txt2(pc),a0
	bsr.L	Print
	bsr.L	GetVal
	lea	StopPtr(pc),a0
	move.l	d0,(a0)
	lea	Txt3(pc),a0
	bsr.L	Print
	move.l	StopPtr(pc),d0
	sub.l	StartPtr(pc),d0
	lea	NoPackSize(pc),a0
	move.l	d0,(a0)
	bsr.L	PrintVal
	move.l	NoPackSize(pc),d0
	beq.s	Quit
	bsr.L	CR
	bsr.L	AllocBuf
	beq.L	Error1
	lea	Txt9(pc),a0
	bsr.L	Print
	move.l	StartPtr(pc),a0
	move.l	BufPtr(pc),a1
	move.l	NoPackSize(pc),d0
	bsr.L	Crunch
	tst.l	d0
	beq.s	Error2
	lea	PackSize(pc),a0
	move.l	d0,(a0)
	lsr.l	#8,d0
	lsr.l	#1,d0
	addq.l	#1,d0
	lea	BlokSize(pc),a0
	move.l	d0,(a0)
	lea	Txt6(pc),a0
	bsr.L	Print
	move.l	PackSize(pc),d0
	bsr.L	PrintVal
	lea	Txt7(pc),a0
	bsr.L	Print
	move.l	BlokSize(pc),d0
	bsr.L	PrintVal
	bsr.L	CR
	lea	Txt8(pc),a0
	bsr.L	Print
	bsr.L	GetVal
	lea	StartBlok(pc),a0
	move.l	d0,(a0)
	add.l	BlokSize(pc),d0
	lea	Txt11(pc),a0
	move.l	d0,-(sp)
	bsr.L	Print
	move.l	(sp)+,d0
	subq.l	#1,d0
	bsr.L	PrintVal
	bsr.s	SaveTD
	bsr.s	FreeBuf
	bsr.L	CR
	bra.L	Program

Error1:
	lea	Txt4(pc),a0
	bsr.L	Print
	bsr.L	CR
	bra.L	Program

Error2:
	lea	Txt5(pc),a0
	bsr.L	Print
	bsr.L	CR
	bsr.s	FreeBuf
	bra.L	Program

;*******************************************************************

SaveTD:
	lea	Txt10(pc),a0
	bsr.L	Print
	bsr.L	GetVal
	move.l	BufPtr(pc),a0
	move.l	StartBlok(pc),d0
	move.l	BlokSize(pc),d1
	bsr.L	TDWrite
	rts

;*******************************************************************

AllocBuf:
	move.l	NoPackSize(pc),d0
	moveq	#2,d1
	move.l	ExecBase,a6
	jsr	AllocMem(a6)
	lea	BufPtr(pc),a0
	move.l	d0,(a0)
	rts

;*******************************************************************

FreeBuf:
	move.l	BufPtr(pc),a1
	move.l	NoPackSize(pc),d0
	move.l	ExecBase,a6
	jsr	FreeMem(a6)
	rts

;*******************************************************************

BitOffset	=	8
BitBlok		=	4
MaxOffset	=	256
MaxBlok		=	16
MinBlok		=	2

;In:
;a0.l - Data
;a1.l - Bufor (Even)
;d0.l - Size

;Out:
;d0.l - NewSize (=0 - error)

Crunch:
	move.l	a7,Stos
	move.l	d0,d5
	movea.l	a0,a2
	add.l	d0,a2
	movea.l	a0,a3
	movea.l	a0,a6
	move.l	d0,(a1)+
	moveq	#4,d0
	moveq	#7,d7
Cru0:	cmpa.l	a3,a2		;czy koniec
	beq.s	Cru6
Cru1:	move.l	a3,d1		;ile od poczatku do znacznika
	sub.l	a0,d1
	move.l	a2,d2		;ile od znacznika do konca
	sub.l	a3,d2
	cmp.l	#MaxOffset,d1	;czy offset nie za dlugi
	bls.s	Cru2
	move.l	#MaxOffset,d1
Cru2:	cmp.l	#MaxBlok,d2	;czy blok nie za dlugi
	bls.s	Cru3
	move.l	#MaxBlok,d2
Cru3:	cmp.l	d1,d2		;czy blok miesci sie w offsecie
	bls.s	Cru4
	move.l	d1,d2
Cru4:	move.l	d1,d4		;zapamietanie offsetu
Cru10:	cmp.l	#MinBlok,d2	;czy tak maly blok moze byc
	bls.s	Cru5
Cru9:	movea.l	a3,a4		;poczatek bloku do przeszukania
	suba.l	d1,a4
	movea.l	a3,a5		;adres porownania
	move.l	d2,d3		;licznik bajtu
Cru7:	cmpm.b	(a4)+,(a5)+	;porownanie
	bne.s	Cru8
	subq.l	#1,d3
	bne.s	Cru7
	bsr.s	PutNoCrunch
	bsr.L	Put1		;dane spakowane
	bsr.s	PutBlok
	bsr.L	PutOffset
	adda.l	d2,a3		;opusc porownane bajty
	movea.l	a3,a6
	bra.s	Cru0
Cru8:	subq.l	#1,d1		;zmniejszenie offsetu
	cmp.l	d2,d1		;czy w offsecie zmiesci sie blok
	bcc.s	Cru9		;tak
	move.l	d4,d1		;zwrot offsetu
	subq.l	#1,d2		;zmniejszenie bloku
	bra.s	Cru10
Cru5:	lea	1(a3),a3
	bra.s	Cru0
Cru6:	bsr.s	PutNoCrunch
	tst.l	d0
	rts

Halt:	move.l	Stos,a7
	moveq	#0,d0
	rts

;*******************************************************************

;a6.l - Start
;a3.l - Stop
;d2.l - BlokSize - obliczone
PutNoCrunch:
	move.l	d2,-(sp)
	cmpa.l	a3,a6
	beq.s	PNC0
PNC2:	move.l	a3,d2
	sub.l	a6,d2		;dlugosc bloku
	cmp.l	#MaxBlok,d2
	bls.s	PNC1
	move.l	#MaxBlok,d2	;blok za dlugi
PNC1:	bsr.s	Put0		;dane nie spakowane
	bsr.s	PutBlok		;dlugosc bloku
PNC6:	moveq	#7,d6		;wyslanie bajtu
PNC5:	btst	d6,(a6)
	bne.s	PNC3
	bsr.s	Put0
	bra.s	PNC4
PNC3:	bsr.s	Put1
PNC4:	dbf	d6,PNC5
	lea	1(a6),a6
	subq.l	#1,d2
	bne.s	PNC6
	cmpa.l	a3,a6		;czy caly blok
	bne.s	PNC2
PNC0:	move.l	(sp)+,d2
	rts

;*******************************************************************

PutBlok:
	subq.l	#1,d2
	move.w	#BitBlok-1,d6
PuBl0:	btst	d6,d2
	bne.s	PuBl1
	bsr.s	Put0
	dbf	d6,PuBl0
	addq.l	#1,d2
	rts
PuBl1:	bsr.s	Put1
	dbf	d6,PuBl0
	addq.l	#1,d2
	rts

;*******************************************************************

PutOffset:
	subq.l	#1,d1
	move.w	#BitOffset-1,d6
PuOf0:	btst	d6,d1
	bne.s	PuOf1
	bsr.s	Put0
	dbf	d6,PuOf0
	addq.l	#1,d1
	rts
PuOf1:	bsr.s	Put1
	dbf	d6,PuOf0
	addq.l	#1,d1
	rts

;*******************************************************************

Put0:
	move.b	d7,$dff180
	bclr	d7,(a1)
	subq.b	#1,d7
	bpl.s	Put00
	moveq	#7,d7
	lea	1(a1),a1
	addq.l	#1,d0
	cmp.l	d5,d0
	bcc.L	Halt
Put00:	rts

;*******************************************************************

Put1:
	move.b	d7,$dff180
	bset	d7,(a1)
	subq.b	#1,d7
	bpl.s	Put10
	moveq	#7,d7
	lea	1(a1),a1
	addq.l	#1,d0
	cmp.l	d5,d0
	bcc.L	Halt
Put10:	rts

;*******************************************************************

;a0.l - buffer
;d0.l - block
;d1.l - block cnt
TDWrite:
	movem.l	d0-d7/a0-a6,-(sp)
	lea	DiskIO(pc),a1
	move.w	#5,28(a1)
	bsr.s	DoTD
	movem.l	(sp)+,d0-d7/a0-a6
	lea	DiskIO(pc),a1
	move.w	#3,28(a1)
	move.l	a0,40(a1)
	lsl.l	#8,d0
	lsl.l	#1,d0
	lsl.l	#8,d1
	lsl.l	#1,d1
	move.l	d1,36(a1)
	move.l	d0,44(a1)
	bsr.s	DoTD
	bne.s	TDWErr
	lea	DiskIO(pc),a1
	move.w	#4,28(a1)
	bsr.s	DoTD
	lea	DiskIO(pc),a1
	move.w	#9,28(a1)
	clr.l	36(a1)
	bra.s	DoTD
TDWErr:	rts

;*******************************************************************

DoTD:
	move.l	ExecBase,a6
	jsr	DoIO(a6)
	moveq	#0,d7
	lea	DiskIO(pc),a1
	move.b	31(a1),d7
	rts

;*******************************************************************

GetVal:
	move.l	Handle(pc),d1
	lea	TxtBuf(pc),a0
	exg	a0,d2
	move.l	#255,d3
	move.l	DosBase(pc),a6
	jsr	Read(a6)
	moveq	#0,d1
	lea	TxtBuf(pc),a0
Get1:	addq.b	#1,d1
	cmp.b	#10,(a0)+
	bne.s	Get1
	subq.b	#2,d1
	lsl.l	#2,d1
	lea	TxtBuf(pc),a0
	lea	DecTab(pc),a1
	clr.l	d0
Get2:	cmp.b	#10,(a0)
	beq.s	Get3
	clr.l	d2
	move.b	(a0)+,d2
	sub.b	#'0',d2
	beq.s	Get4
Get5:	add.l	0(a1,d1.l),d0
	subq.b	#1,d2
	bne.s	Get5
Get4:	subq.l	#4,d1
	bra.s	Get2
Get3:	rts

;*******************************************************************

CR:
	lea	Txt0(pc),a0
	bra.s	Print

;*******************************************************************

PrintVal:
	lea	TxtBuf(pc),a0
	lea	DecTab+36(pc),a1
	moveq	#9,d1
PrV1:	move.b	#'0',(a0)
PrV3:	cmp.l	(a1),d0
	bcs.s	PrV2
	add.b	#1,(a0)
	sub.l	(a1),d0
	bra.s	PrV3
PrV2:
	lea	-4(a1),a1
	lea	1(a0),a0
	dbf	d1,PrV1
	move.b	#10,(a0)+
	move.b	#0,(a0)+
	lea	TxtBuf(pc),a0

;*******************************************************************

;a0.l - text
Print:
	move.l	Handle(pc),d1
	move.l	a0,d2
	moveq	#0,d3
Pr1:	addq.l	#1,d3
	tst.b	(a0)+
	bne.s	Pr1
	subq.l	#1,d3
	beq.s	Pr0
	move.l	DosBase(pc),a6
	jsr	Write(a6)
Pr0:	rts

;*******************************************************************

StartTD:
	move.l	ExecBase,a6
	sub.l	a1,a1
	jsr	FindTask(a6)
	lea	DiskRep(pc),a5
	move.l	d0,16(a5)
	lea	DiskRep(pc),a1
	jsr	AddPort(a6)
	lea	DiskIO(pc),a1
	lea	DiskRep(pc),a5
	move.l	a5,14(a1)
	moveq	#0,d0
	moveq	#0,d1
	lea	TrackName(pc),a0
	jsr	OpenDevice(a6)
	rts

;*******************************************************************

StopTD:
	move.l	ExecBase,a6
	lea	DiskIO(pc),a1
	jsr	CloseDevice(a6)
	lea	DiskRep(pc),a1
	jsr	RemPort(a6)
	rts

;*******************************************************************

Stos:		dc.l	0
DosBase:	dc.l	0
Handle:		dc.l	0
BufPtr:		dc.l	0
BufSize:	dc.l	0
StartPtr:	dc.l	0
StopPtr:	dc.l	0
NoPackSize:	dc.l	0
PackSize:	dc.l	0
BlokSize:	dc.l	0
StartBlok:	dc.l	0

DecTab:
	dc.l	1
	dc.l	10
	dc.l	100
	dc.l	1000
	dc.l	10000
	dc.l	100000
	dc.l	1000000
	dc.l	10000000
	dc.l	100000000
	dc.l	1000000000

DiskIO:		blk.l	20,0
DiskRep:	blk.l	8,0
TxtBuf:		blk.b	256,0

DosName:	dc.b	'dos.library',0
	EVEN
TrackName:	dc.b	'trackdisk.device',0
	EVEN

Txt00:	dc.b	10,'     MiniCruncher V1.0',10
	dc.b	'napisal: Slawomir Juralowicz',10,10,0
Txt0:	dc.b	10,0
Txt1:	dc.b	'Podaj adres poczatkowy: ',0
Txt2:	dc.b	'Podaj adres koncowy   : ',0
Txt3:	dc.b	'Dlugosc bloku         : ',0
Txt4:	dc.b	'Nie moge zajac pamieci!',0
Txt5:	dc.b	'Bufor niespakowany!',0
Txt6:	dc.b	10,10,'Dlugosc po spakowaniu: ',0
Txt7:	dc.b	'Dlugosc w blokach:     ',0
Txt8:	dc.b	'Podaj blok startowy: ',0
Txt11:	dc.b	'Zajety blok koncowy: ',0
Txt9:	dc.b	'Crunching...',0
Txt10:	dc.b	10,'Zapis na dysk... (Enter) >',0
	EVEN
