CopyProc	=	511*1024
MFMBuf		=	256
TRKBuf		=	14256
CHKBuf		=	19888
MainPtr		=	20912
Delay		=	250

BlkIntro	=	11
BlkDemo		=	72
BlkStart	=	266
BlkRobbo	=	324
BlkStop		=	429

AdrIntro	=	$00064688
AdrDemo		=	$00098860
AdrStart	=	$00065b00
AdrRobbo	=	$0006d2b8
AdrStop		=	$00062690

Start:
	bsr.s	GetNum
	move.w	d0,0
	move.w	#$7fff,$dff09a
	move.w	#$7fff,$dff096

	; Procedura kopiujaca na koniec 0.5MB Chip-u.

	lea	Copy(pc),a0
	lea	CopyProc,a1
	move.w	#$ff,d0
St1:	move.l	(a0)+,(a1)+
	dbf	d0,St1
	lea	Start(pc),a0
	move.l	#CopyProc,$80
	trap	#0

* Pobranie numeru stacji. ******************************************

GetNum:
	moveq	#3,d0
	move.l	$14(a1),a0
	lea	$24+16(a0),a0
	move.l	$18(a1),d1
Loop:	cmp.l	-(a0),d1
	dbeq	d0,Loop
	tst.b	d0
	bmi.s	Chg
	rts
Chg:	clr.l	d0
	rts

;* Procedura kopiujaca. ********************************************

Copy:

	; Kopiowanie sumy kontrolnej.

	lea	-1024(a0),a1
	lea	CHKBuf,a2
	move.w	#$ff,d0
Co1:	move.l	(a1)+,(a2)+
	dbf	d0,Co1

	; Kopiowanie loadera gry.

	lea	Main-Start(a0),a1
	lea	MainPtr,a2
	move.w	#Stop-Main-1,d0
Co2:	move.b	(a1)+,(a2)+
	dbf	d0,Co2

	jmp	MainPtr

;* Loader glowny. **************************************************

Main:
	lea	Stop(pc),a7
	bsr.L	GetDSKSEL
	bsr.L	ResetRegs
	bsr.L	ResetDrv
	bsr.s	GoIntro
	bsr.s	GoDemo
MLoop:	bsr.s	GoStart
	bsr.s	GoRobbo
	bsr.L	GoStop
	bra.s	MLoop
GoIntro:
	move.l	#BlkIntro,d0
	lea	AdrIntro-8,a0
	bsr.L	Read
	bsr.L	ResetRegs
	st	d0
	jsr	AdrIntro
	bra.L	ResetRegs
GoDemo:
	move.l	#BlkDemo,d0
	lea	AdrDemo-8,a0
	bsr.s	Read
	bsr.L	ResetRegs
	st	d7
	jsr	AdrDemo
	bra.L	ResetRegs
GoStart:
	move.l	#BlkStart,d0
	lea	AdrStart-8,a0
	bsr.s	Read
	bsr.L	ResetRegs
	st	d7
	jsr	AdrStart
	bra.L	ResetRegs
GoRobbo:
	move.l	#BlkRobbo,d0
	lea	AdrRobbo-8,a0
	bsr.s	Read
	bsr.L	ResetRegs
	st	d7
	jsr	AdrRobbo
	bra.L	ResetRegs
GoStop:
	move.l	#BlkStop,d0
	lea	AdrStop-8,a0
	bsr.s	Read
	bsr.L	ResetRegs
	st	d7
	jsr	AdrStop
	bra.L	ResetRegs

;*******************************************************************

;d0.l - StartBlok
;d1.l - IleBlok
;d2.l - PPSize
;a0.l - AdresDest

Read:
	lea	DestPtr(pc),a1
	move.l	a0,(a1)
	move.l	d0,d1
	divu.w	#11,d1
	move.l	d1,d2
	swap	d2
	and.l	#$ffff,d1
	and.l	#$ffff,d2
	lsl.l	#8,d2
	lsl.l	#1,d2
	lea	BufCnt(pc),a1
	move.l	d2,(a1)
	lea	PBVal(pc),a1
	clr.b	(a1)
	btst	#0,d1
	bne.s	Read0
	move.b	#%100,(a1)
Read0:	lsr.w	#1,d1
	lea	ReadTRK(pc),a1
	move.w	d1,(a1)
	lea	MustRead(pc),a1
	st	(a1)
	bsr.L	MotorOn
	bsr.L	DeCrunch
	bsr.L	MotorOff
	rts

;*******************************************************************


;Free a0,a3,a4,a5,a6
;Free d3,d4
;Out:
;d5.l - Data
GetLong:
	lea	MustRead(pc),a6
	tst.b	(a6)
	beq.s	GeLo1
	sf	(a6)
GeLo4:	lea	ReadTRK(pc),a6
	move.w	(a6),d5
	cmp.b	DSKTRK(pc),d5
	beq.s	GeLo2
	bhi.s	GeLo3
	bsr.L	To0
	bra.s	GeLo4
GeLo3:	bsr.L	To79
	bra.s	GeLo4
GeLo2:	movem.l	d0-d7/a0-a6,-(sp)
	bsr.L	ReadMFM
	movem.l	(sp)+,d0-d7/a0-a6
GeLo1:	move.l	BufCnt(pc),d5
	cmp.l	#5632,d5
	bcs.s	GeLo5
	lea	PBVal(pc),a6
	btst	#2,(a6)
	bne.s	GeLo6
	move.b	#%100,(a6)
	movem.l	d0-d7/a0-a6,-(sp)
	bsr.L	To79
	bra.s	GeLo7
GeLo6:	clr.b	(a6)
	movem.l	d0-d7/a0-a6,-(sp)
	bsr.L	Wait
GeLo7:	bsr.L	ReadMFM
	movem.l	(sp)+,d0-d7/a0-a6
	lea	BufCnt(pc),a6
	clr.l	(a6)
	moveq	#0,d5
GeLo5:	lea	TRKBUF,a0
	move.l	0(a0,d5.l),d5
	lea	BufCnt(pc),a6
	add.l	#4,(a6)
	rts

;*******************************************************************
;			Mini Decruncher.
;*******************************************************************

BitOffset	=	8
BitBlok		=	4
MaxOffset	=	256
MaxBlok		=	16
MinBlok		=	2

;In:
;a1.l - Bufor
DeCrunch:
	move.l	DestPtr(pc),a1
	movea.l	a1,a2
	bsr.L	GetLong
	adda.l	d5,a2			;adres konca
	moveq	#0,d7			;licznik bitow
DeCr1:	cmpa.l	a1,a2			;glowna petla
	bls.L	DeCr0			;wszystkie dane
	dbf	d7,GeBi1		;pobranie bitu
	bsr.L	GetLong
	moveq	#31,d7
GeBi1:	rol.l	#1,d5
	bcs.s	DCB			;dane spakowane
	clr.w	d0			;dlugosc danych nie spakow.
	move.w	#BitBlok-1,d6
GeBl0:	dbf	d7,GeBi3
	bsr.L	GetLong
	moveq	#31,d7
GeBi3:	roxl.l	#1,d5
	roxl.w	#1,d0
	dbf	d6,GeBl0
DeCr2:	move.w	#7,d6			;pobranie bajtu
GeBy0:	dbf	d7,GeBi2
	bsr.L	GetLong
	moveq	#31,d7
GeBi2:	roxl.l	#1,d5
	roxl.b	#1,d2
	dbf	d6,GeBy0
	move.b	d2,(a1)+		;wpis bajtu do pamieci
	dbf	d0,DeCr2		;nastepny bajt
	bra.s	DeCr1
DCB:	clr.w	d0			;blok spakowany
	move.w	#BitBlok-1,d6		;pobranie dlugosci bloku
GeBl00:	dbf	d7,GeBi30
	bsr.L	GetLong
	moveq	#31,d7
GeBi30:	roxl.l	#1,d5
	roxl.w	#1,d0
	dbf	d6,GeBl00
	clr.w	d1
	move.w	#BitOffset-1,d6		;pobranie offsetu
GeOf0:	dbf	d7,GeBi4
	bsr.L	GetLong
	moveq	#31,d7
GeBi4:	roxl.l	#1,d5
	roxl.w	#1,d1
	dbf	d6,GeOf0
	addq.l	#1,d1
	neg.w	d1
DeCr3:	move.b	0(a1,d1.w),(a1)+
	dbf	d0,DeCr3
	bra.L	DeCr1
DeCr0:	rts

;*******************************************************************

ResetDrv:
	lea	PBVal(pc),a0
	move.b	#0,(a0)
	move.b	DSKSelOn(pc),d0
	or.b	#%10000001,d0
	move.b	d0,CIABPRB
RDL:	btst	#4,CIAAPRA
	beq.s	RDQ
	bsr.L	To0
	bra.s	RDL
RDQ:	lea	DSKTRK(pc),a0
	clr.b	(a0)
	rts

;*******************************************************************

GetDSKSEL:
	lea	DSKSELOn(pc),a0
	move.w	0,d0
	cmp.b	#0,d0
	beq.s	DSK0
	cmp.b	#1,d0
	beq.s	DSK1
	cmp.b	#2,d0
	beq.s	DSK2
	cmp.b	#3,d0
	beq.s	DSK3
DSK0:	move.b	#%01110000,(a0)
	rts
DSK1:	move.b	#%01101000,(a0)
	rts
DSK2:	move.b	#%01011000,(a0)
	rts
DSK3:	move.b	#%00111000,(a0)
	rts

;*******************************************************************

ResetRegs:
	bset	#1,$bfe001
	lea	CUSTOM,a6
	move.w	#$7fff,$9a(a6)
	move.w	#$7fff,$96(a6)
	move.w	#0,$180(a6)
	move.w	#0,$142(a6)
	move.w	#0,$14a(a6)
	move.w	#0,$152(a6)
	move.w	#0,$15a(a6)
	move.w	#0,$162(a6)
	move.w	#0,$16a(a6)
	move.w	#0,$172(a6)
	move.w	#0,$17a(a6)
	rts

;*******************************************************************

Wait:
	btst	#2,CIAAPRA
	beq.s	Wait
	btst	#5,CIAAPRA
	bne.s	Wait
	movem.l	d0-d1,-(sp)
	move.b	DSKSelOn(pc),d0
	or.b	PBVal(pc),d0
	or.b	#1,d0
	move.b	d0,CIABPRB
	move.w	#Delay-1,d1
Wait1:	move.b	$dff006,d0
Wait2:	cmp.b	$dff006,d0
	beq.s	Wait2
	dbf	d1,Wait1
	movem.l	(sp)+,d0-d1
	rts

;*******************************************************************

ReadMFM:
		move.w	#7000,d0
		lea	CUSTOM,a6
		move.w	#0,DSKLEN(a6)
		move.w	#$8210,DMACON(a6)
		move.w	#$7fff,ADKCON(a6)
		move.w	#%1001010100000000,ADKCON(a6)
		move.w	#$4489,DSKSYNC(a6)
		move.l	#MFMBuf,DSKPTH(a6)
		move.w	#2,INTREQ(a6)
		or.w	#$8000,d0
		move.w	d0,DSKLEN(a6)
		move.w	d0,DSKLEN(a6)
Re0:		move.w	INTREQR(a6),d0
		btst	#1,d0
		beq.s	Re0
		move.w	#0,DSKLEN(a6)
		move.w	#$10,DMACON(a6)
Decode:		lea	MFMBuf,a0
		lea	TRKBuf,a1
		move.w	#10,d3
De1:		cmp.w	#$4489,(a0)+
		bne.s	De1
De2:		cmp.w	#$4489,(a0)+
		beq.s	De2
		move.l	-2(a0),d0
		move.l	2(a0),d1
		and.l	#$55555555,d0
		and.l	#$55555555,d1
		lsl.l	#1,d0
		or.l	d1,d0
		lsr.w	#8,d0
		and.l	#$ff,d0
		lsl.l	#8,d0
		lsl.l	#1,d0
		lea	0(a1,d0.w),a2
		lea	54(a0),a3
		lea	566(a0),a0
		move.w	#127,d2
De3:		move.l	(a3)+,d0
		move.l	(a0)+,d1
		and.l	#$55555555,d0
		and.l	#$55555555,d1
		lsl.l	#1,d0
		or.l	d1,d0
		move.l	d0,(a2)+
		dbf	d2,De3
		dbf	d3,De1
		rts

;*******************************************************************

To0:
		lea	DSKTRK(pc),a0
		sub.b	#1,(a0)
		move.b	DSKSELOn(pc),d0
		or.b	PBVal(pc),d0
		move.b	d0,d1
		move.b	d0,d2
		or.b	#%11,d1
		or.b	#%10,d2
		move.b	d1,CIABPRB
		move.b	d2,CIABPRB
		move.b	d1,CIABPRB
		bra.L	Wait

;*******************************************************************

To79:
		lea	DSKTRK(pc),a0
		add.b	#1,(a0)
		move.b	DSKSELOn(pc),d0
		or.b	PBVal(pc),d0
		move.b	d0,d1
		move.b	d0,d2
		or.b	#%01,d1
		or.b	#%00,d2
		move.b	d1,CIABPRB
		move.b	d2,CIABPRB
		move.b	d1,CIABPRB
		bra.L	Wait

;*******************************************************************

MotorOn:
		lea	PBVal(pc),a0
		lea	DSKSELOn(pc),a1
		move.b	(a0),d0
		move.b	(a0),d1
		move.b	(a1),d2
		or.b	(a0),d2
		or.b	#%11111001,d0
		or.b	#%01111001,d1
		or.b	#%00000001,d2
		move.b	d0,CIABPRB		;all off
		move.b	d1,CIABPRB		;motor on
		move.b	d2,CIABPRB		;drive on
		bra.L	Wait

;*******************************************************************

MotorOff:
		move.b	#%11111001,CIABPRB	;all off
		move.b	#%11111001,CIABPRB	;motor off
		move.b	#%11110001,CIABPRB	;drive on
		move.b	#%11111001,CIABPRB	;all off
		rts

;*******************************************************************
;			CONSTANS
;*******************************************************************

CUSTOM		=	$dff000
BLTDDAT		=	$000
DMACONR		=	$002
VPOSR		=	$004
VHPOSR		=	$006
DSKDATR		=	$008
JOY0DAT		=	$00A
JOY1DAT		=	$00C
CLXDAT		=	$00E
ADKCONR		=	$010
POT0DAT		=	$012
POT1DAT		=	$014
POTGOR		=	$016
SERDATR		=	$018
DSKBYTR		=	$01A
INTENAR		=	$01C
INTREQR		=	$01E
DSKPTH		=	$020
DSKPTL		=	$022
DSKLEN		=	$024
DSKDAT		=	$026
REFPTR		=	$028
VPOSW		=	$02A
VHPOSW		=	$02C
COPCON		=	$02E
SERDAT		=	$030
SERPER		=	$032
POTGO		=	$034
JOYTEST		=	$036
STRQU		=	$038
STRVBL		=	$03A
STRHOR		=	$03C
STRLONG		=	$03E
BLTCON0		=	$040
BLTCON1		=	$042
BLTAFWM		=	$044
BLTALWM		=	$046
BLTCPT		=	$048
BLTBPT		=	$04C
BLTAPT		=	$050
BLTDPT		=	$054
BLTSIZE		=	$058
BLTCMOD		=	$060
BLTBMOD		=	$062
BLTAMOD		=	$064
BLTDMOD		=	$066
BLTCDAT		=	$070
BLTBDAT		=	$072
BLTADAT		=	$074
DSKSYNC		=	$07E
COP1PTR		=	$080
COP2PTR		=	$084
COP1LCH		=	$080
COP1LCL		=	$082
COP2LCH		=	$084
COP2LCL		=	$086
COPJMP1		=	$088
COPJMP2		=	$08A
COPINS		=	$08C
DIWSTRT		=	$08E
DIWSTOP		=	$090
DDFSTRT		=	$092
DDFSTOP		=	$094
DMACON		=	$096
CLXCON		=	$098
INTENA		=	$09A
INTREQ		=	$09C
ADKCON		=	$09E
AUDIO0		=	$0A0
AUDIO1		=	$0B0
AUDIO2		=	$0C0
AUDIO3		=	$0D0
BPL1PTH		=	$0E0
BPL1PTL		=	$0E2
BPL2PTH		=	$0E4
BPL2PTL		=	$0E6
BPL3PTH		=	$0E8
BPL3PTL		=	$0EA
BPL4PTH		=	$0EC
BPL4PTL		=	$0EE
BPL5PTH		=	$0F0
BPL5PTL		=	$0F2
BPL6PTH		=	$0F4
BPL6PTL		=	$0F6
BPLCON0		=	$100
BPLCON1		=	$102
BPLCON2		=	$104
BPL1MOD		=	$108
BPL2MOD		=	$10A
SPRPTR		=	$120
SPRPOS		=	$140
COLORS		=	$180
RND		=	$bfd600
SETCLR		=	$8000
DSKEN		=	$10
SPREN		=	$20
BLTEN		=	$40
COPEN		=	$80
BPLEN		=	$100
DMAEN		=	$200
BLTPR		=	$400
ERSY		=	$2
LACE		=	$4
LPEN		=	$8
GAUD		=	$100
COLOR		=	$200
DBLPF		=	$400
HOMOD		=	$800
BPU0		=	$1000
BPU1		=	$2000
BPU2		=	$4000
HIRES		=	$8000
COPWAIT		=	$fffe
ENDCOPLST	=	$ffff
ENDHALF		=	$ffdf
KEYTALO		=	$bfe401
KEYTAHI		=	$bfe501
KEYCRA		=	$bfee01
KEYSDR		=	$bfec01
KEYICR		=	$bfed01
CIAAPRA		=	$bfe001
CIABPRB		=	$bfd100

;*******************************************************************

DestPtr:	dc.l	0
BufCnt:		dc.l	0
ReadTRK:	dc.w	0
DSKSelOn:	dc.b	0
PBVal:		dc.b	0
DSKTRK:		dc.b	0
MustRead:	dc.b	0
	EVEN
Stack:		blk.b	1024,0

Stop:
