StarsAdd	=	3
StarsIl		=	192/StarsAdd

SAnim1		=	1
OFS		=	0
BLTF		=	%0000111100000000+%11100010
STACKSIZE	=	1024

Start:
	moveq	#0,d7
	bra.s	Start2
	dc.l	Start2
Start2:
	move.b	d7,SysStat
	bne.s	Begin
	bsr.L	StartSystem
	lea	Begin,a6
	move.l	a6,$80
	trap	#0
	bsr.L	StopSystem
Strt0:	rts
Begin:	move.l	a7,MemStack
	lea	Stack+STACKSIZE,a7
	lea	CUSTOM,a6
	bsr.s	Program
Halt:	move.l	MemStack,a7
	tst.b	SysStat
	bne.s	Strt0
	rte

;*******************************************************************

Program:
	bsr.L	Install
	bsr.L	SetVBL
	lea	CL,a0
	move.l	a0,COP1PTR(a6)
	move.w	#%1000011111000000,DMACON(a6)
	lea	Pal000,a0
	move.l	a0,PalPtr
	st	ChgPal
	bsr.L	StartVBL
	bsr.L	Show0
	bsr.L	Set0
	lea	Pal0,a0
	move.l	a0,PalPtr
	move.w	#80,d7
	move.w	#250,d0
	move.w	#30,d1
	move.w	#0,d2
	moveq	#1,d3
	bsr.L	Frame
	sf	SL
L1:	movem.w	d0-d7,-(sp)
	lea	Bob00,a5
	add.b	AddAnim,d2
	bsr.L	Bob
	tst.b	SL
	beq.s	NL1
	move.w	LX,d0
	move.w	LY,d1
	moveq	#81,d2
	lea	Bob01,a5
	bsr.L	Bob
NL1:	bsr.L	ScrSwap
	movem.w	(sp)+,d0-d7
	subq.w	#3,d0
	addq.w	#1,d1
	cmp.b	#8,d7
	bne.s	L04
	lea	Pal000,a0
	move.l	a0,PalPtr
L04:	tst.b	SL
	beq.s	NL3
	sub.w	#12,LX
	add.w	#4,LY
NL3:	tst.w	LX
	bpl.s	NL2
	sf	SL
NL2:	cmp.b	#70,d7
	bne.s	NL4
	move.w	#290,LX
	move.w	#10,LY
	st	SL
NL4:	cmp.b	#40,d7
	bne.s	NL4b
	move.w	#290,LX
	move.w	#55,LY
	st	SL
NL4b:	cmp.b	#10,d7
	bne.s	NL4c
	move.w	#290,LX
	move.w	#60,LY
	st	SL
NL4c:	dbf	d7,L1
	lea	Pal0,a0
	move.l	a0,PalPtr
	move.w	#80,d7
	move.w	#250,d0
	move.w	#30,d1
	move.w	#32,d2
	moveq	#1,d3
	bsr.L	Frame
	sf	SL
qL1:	movem.w	d0-d7,-(sp)
	lea	Bob00,a5
	add.b	AddAnim,d2
	bsr.L	Bob
	tst.b	SL
	beq.s	qNL1
	move.w	LX,d0
	move.w	LY,d1
	moveq	#81,d2
	lea	Bob01,a5
	bsr.L	Bob
qNL1:	bsr.L	ScrSwap
	movem.w	(sp)+,d0-d7
	subq.w	#3,d0
	addq.w	#1,d1
	cmp.b	#8,d7
	bne.s	qL04
	lea	Pal000,a0
	move.l	a0,PalPtr
qL04:	tst.b	SL
	beq.s	qNL3
	sub.w	#12,LX
	add.w	#4,LY
qNL3:	tst.w	LX
	bpl.s	qNL2
	sf	SL
qNL2:	cmp.b	#70,d7
	bne.s	qNL4
	move.w	#180,LX
	move.w	#70,LY
	st	SL
qNL4:	cmp.b	#40,d7
	bne.s	qNL4b
	move.w	#140,LX
	move.w	#90,LY
	st	SL
qNL4b:	dbf	d7,qL1
	bsr.L	SetStars
	bsr.L	Stars
	lea	Pal1,a0
	move.l	a0,PalPtr
	move.l	#120,CNT
	bsr.L	Frame
	sf	SL
L10:	bsr.L	StarsM
	move.w	#120,d0
	move.w	#40,d1
	move.w	#16,d2
	add.b	AddAnim,d2
L111:	lea	Bob00,a5
	bsr.L	Bob
	tst.b	SL
	beq.s	L101
	move.w	LX,d0
	move.w	LY,d1
	moveq	#82,d2
	lea	Bob01,a5
	bsr.L	Bob
L101:	bsr.L	ScrSwap
	cmp.l	#16,Cnt
	bne.s	L100
	lea	Pal000,a0
	move.l	a0,PalPtr
L100:	cmp.l	#100,Cnt
	bne.s	L102
	st	SL
	move.w	#280,LX
	move.w	#140,LY
L102:	cmp.l	#50,Cnt
	bne.s	L102b
	st	SL
	move.w	#280,LX
	move.w	#60,LY
L102b:	tst.b	SL
	beq.s	L103
	sub.w	#12,LX
L103:	tst.w	LX
	bpl.s	L104
	sf	SL
L104:	tst.l	Cnt
	bne.L	L10
	lea	Pal1,a0
	move.l	a0,PalPtr
	move.l	#120,CNT
	bsr.L	Frame
	sf	SL
aL10:	bsr.L	StarsM
	move.w	#120,d0
	move.w	#64,d1
	move.w	#48,d2
	add.b	AddAnim,d2
aL111:	lea	Bob00,a5
	bsr.L	Bob
	tst.b	SL
	beq.s	aL101
	move.w	LX,d0
	move.w	LY,d1
	moveq	#82,d2
	lea	Bob01,a5
	bsr.L	Bob
aL101:	bsr.L	ScrSwap
	cmp.l	#16,Cnt
	bne.s	aL100
	lea	Pal000,a0
	move.l	a0,PalPtr
aL100:	cmp.l	#100,Cnt
	bne.s	aL102
	st	SL
	move.w	#130,LX
	move.w	#70,LY
aL102:	cmp.l	#40,Cnt
	bne.s	aL102b
	st	SL
	move.w	#140,LX
	move.w	#57,LY
aL102b:	tst.b	SL
	beq.s	aL103
	sub.w	#12,LX
aL103:	tst.w	LX
	bpl.s	aL104
	sf	SL
aL104:	tst.l	Cnt
	bne.L	aL10
	lea	Pal1,a0
	move.l	a0,PalPtr
	move.l	#50,CNT
	bsr.L	Frame
	move.w	#280,LX
	move.w	#94,LY
L10y:	bsr.L	StarsM
	move.w	#30,d0
	move.w	#40,d1
	move.w	#16,d2
	add.b	AddAnim,d2
	lea	Bob00,a5
	bsr.L	Bob
	move.w	LX,d0
	move.w	LY,d1
	moveq	#82,d2
	lea	Bob01,a5
	bsr.L	Bob
	sub.w	#6,LX
	bsr.L	ScrSwap
	cmp.l	#16,Cnt
	bne.s	L100y
	lea	Palfff,a0
	move.l	a0,PalPtr
L100y:	tst.l	Cnt
	bne.s	L10y
	bsr.L	Set1
	lea	Pal000,a0
	move.l	a0,PalPtr
	move.l	#100,d0
	bsr.L	Wait
	lea	Pal1,a0
	move.l	a0,PalPtr
	move.w	#200,d0
	move.w	#80,d1
	move.w	#64,d2
	move.w	#36,d7
L1B:	movem.w	d0-d7,-(sp)
	lea	Bob00,a5
	bsr.L	Bob
	bsr.L	ScrSwap
	moveq	#2,d0
	bsr.L	Wait
	movem.w	(sp)+,d0-d7
	subq.w	#2,d0
	tst.b	Anim1
	bne.s	L2B
	cmp.b	#79,d2
	beq.s	L2B
	addq.b	#1,d2
L2B:	cmp.b	#8,d7
	bne.s	L3B
	lea	Pal000,a0
	move.l	a0,PalPtr
L3B:	dbf	d7,L1B
	sf	ChgPal
	bsr.L	Set2
	lea	Pal2,a0
	move.l	a0,PalPtr
	bsr.L	Set2Pal
	move.w	#200,d0
	move.w	#0,d1
	move.w	#80,d2
	move.w	#68,d7
L1C:	movem.w	d0-d7,-(sp)
	lea	Bob00,a5
	bsr.L	Bob
	bsr.L	ScrSwap
	movem.w	(sp)+,d0-d7
	addq.w	#1,d1
	subq.w	#2,d0
	dbf	d7,L1C
	lea	Palfff,a0
	move.l	a0,PalPtr
	bsr.L	Fade16D
	lea	Pal000,a0
	move.l	a0,PalPtr
	bsr.L	Fade16C
	move.l	#20,d0
	bra.L	Wait

;*******************************************************************

Frame:
	clr.b	FrameCnt
	move.b	#8,AddAnim
	move.b	#-1,HlpAdd
	rts

;*******************************************************************

StarsM:
	lea	ST,a0
	move.w	#StarsIl-1,d0
	moveq	#0,d1
SM1:
	addq.b	#1,d1
	cmp.b	#3,d1
	bne.s	SM0
	moveq	#0,d1
SM0:
	move.b	11(a0),d2
	cmp.b	#0,d1
	beq.s	SM2
	cmp.b	#1,d1
	beq.s	SM3

	addq.b	#3,d2
	bra.s	SM00
SM2:
	addq.b	#2,d2
	bra.s	SM00
SM3:
	addq.b	#1,d2
SM00:
	move.b	d2,11(a0)
	lea	24(a0),a0
	dbf	d0,SM1
	rts

;*******************************************************************

Stars:
	lea	ST,a0
	lea	StarsT-2,a1
	move.w	#StarsIl-1,d0
	move.w	#$4000,d1
	move.w	#$fffe,d7
	moveq	#0,d6
St0:
	lea	2(a1),a1
	addq.b	#1,d6
	cmp.b	#3,d6
	bne.s	St00
	moveq	#0,d6
St00:
	cmp.b	#0,d6
	beq.s	St1
	cmp.b	#1,d6
	beq.L	St2

	move.w	d1,d2
	move.w	d1,d3
	or.w	#$03,d2
	or.w	#$ff,d3
	move.w	d2,(a0)
	move.w	d7,2(a0)
	move.w	#$14a,4(a0)
	move.w	#$f001,6(a0)
	move.w	#$148,8(a0)
	move.b	#0,10(a0)
	move.b	1(a1),11(a0)
	move.w	#$14c,12(a0)
	move.w	#1,14(a0)
	move.w	d3,16(a0)
	move.w	d7,18(a0)
	move.w	#$14a,20(a0)
	move.w	#0,22(a0)
	lea	24(a0),a0
	add.w	#StarsAdd*256,d1
	dbf	d0,St0
	rts

St1:	move.w	d1,d2
	move.w	d1,d3
	or.w	#$03,d2
	or.w	#$ff,d3
	move.w	d2,(a0)
	move.w	d7,2(a0)
	move.w	#$15a,4(a0)	;!
	move.w	#$f001,6(a0)
	move.w	#$158,8(a0)	;!
	move.b	#0,10(a0)
	move.b	1(a1),11(a0)
	move.w	#$15c,12(a0)	;!
	move.w	#1,14(a0)
	move.w	d3,16(a0)
	move.w	d7,18(a0)
	move.w	#$15a,20(a0)	;!
	move.w	#0,22(a0)
	lea	24(a0),a0
	add.w	#StarsAdd*256,d1
	dbf	d0,St0
	rts

St2:	move.w	d1,d2
	move.w	d1,d3
	or.w	#$03,d2
	or.w	#$ff,d3
	move.w	d2,(a0)
	move.w	d7,2(a0)
	move.w	#$152,4(a0)	;!
	move.w	#$f001,6(a0)
	move.w	#$150,8(a0)	;!
	move.b	#0,10(a0)
	move.b	1(a1),11(a0)
	move.w	#$154,12(a0)	;!
	move.w	#1,14(a0)
	move.w	d3,16(a0)
	move.w	d7,18(a0)
	move.w	#$152,20(a0)	;!
	move.w	#0,22(a0)
	lea	24(a0),a0
	add.w	#StarsAdd*256,d1
	dbf	d0,St0
	rts

;*******************************************************************

Clr0:
	lea	Bob00,a0
	bsr.s	ClrBob
	lea	12(a0),a0
	bsr.s	ClrBob
	lea	12(a0),a0
	bsr.s	ClrBob
	lea	12(a0),a0
	bsr.s	ClrBob
	rts

;*******************************************************************

Clr1:
	lea	Bob10,a0
	bsr.s	ClrBob
	lea	12(a0),a0
	bsr.s	ClrBob
	lea	12(a0),a0
	bsr.s	ClrBob
	lea	12(a0),a0
	bsr.s	ClrBob
	rts

;*******************************************************************

ClrBob:
	tst.w	4(a0)
	beq.s	CB0
	move.l	(a0),a1
	move.l	8(a0),a2
	move.w	#4,d0
	bsr.L	WBLT
	move.w	6(a0),BLTAMOD(a6)
	move.w	6(a0),BLTDMOD(a6)
	move.w	#$ffff,BLTAFWM(a6)
	move.w	#$ffff,BLTALWM(a6)
	move.w	#$09f0,BLTCON0(a6)
	move.w	#0,BLTCON1(a6)
CB1:	bsr.L	WBLT
	move.l	a1,BLTAPT(a6)
	move.l	a2,BLTDPT(a6)
	move.w	4(a0),BLTSIZE(a6)
	lea	40(a1),a1
	lea	40(a2),a2
	dbf	d0,CB1
	clr.w	4(a0)
CB0:	rts

;*******************************************************************

ScrSwap:
	add.b	#1,FrameCnt
	tst.b	Anim1
	bne.s	Cr0
	;cmp.b	#20,FrameCnt
	;bcs.s	Cr0
	;cmp.b	#90,FrameCnt
	;bhi.s	Cr0
	move.b	AddAnim,d0
	add.b	HlpAdd,d0
	move.b	d0,AddAnim
	cmp.b	#15,d0
	bne.s	Cr1
	move.b	#-1,HlpAdd
Cr1:
	cmp.b	#0,d0
	bne.s	Cr2
	move.b	#1,HlpAdd
Cr2:
Cr0:
	sub.b	#1,Anim1
	bpl.s	Pr2
	move.b	#SAnim1,Anim1
Pr2:
	bsr.L	WVBL
	bsr.L	WVBL
	tst.b	ScrNum
	bne.L	Show1
	bra.L	Show0

;*******************************************************************

;d0-x d1-y d2-bob a2-MemBOB
;0.l - src ptr
;4.w - bltsize
;6.w - modulo
;8.l - dest ptr
;12
;81,82
Bob:
	movea.l	a5,a2
	tst.b	ScrNum
	beq.s	Bob0
	lea	48(a2),a2
Bob0:
	move.w	d0,d6
	lsl.w	#8,d6
	lsl.w	#4,d6
	move.w	d6,d7
	or.w	#$0ff2,d7
	clr.l	d5
	move.w	d0,d5
	lsr.w	#4,d5
	lsl.w	#1,d5
	clr.l	d3
	move.w	d2,d3
	lsl.w	#1,d3
	lea	BobAddY,a1
	clr.l	d4
	move.b	d1,d4
	add.w	0(a1,d3.w),d4
	lsl.w	#2,d4
	lsl.w	#3,d3
	lea	Ship1_1T,a1
	lea	0(a1,d3.w),a1
	lea	YOfs,a0
	move.l	0(a0,d4.w),a0
	adda.l	d5,a0
	move.w	14(a1),6(a2)
	move.w	12(a1),4(a2)
	lea	Screen2,a3
	adda.l	a0,a3
	move.l	a3,(a2)
	adda.l	ActScreen,a0
	move.l	a0,8(a2)
	bsr.L	WBLT
	move.w	#$ffff,BLTAFWM(a6)
	move.w	#$ffff,BLTALWM(a6)
	move.w	d7,BLTCON0(a6)
	move.w	d6,BLTCON1(a6)
	move.w	#0,BLTAMOD(a6)
	move.w	#0,BLTBMOD(a6)
	move.w	14(a1),BLTDMOD(a6)
	move.w	14(a1),BLTCMOD(a6)
	move.l	(a1),BLTAPT(a6)
	move.l	4(a1),BLTBPT(a6)
	move.l	a0,BLTDPT(a6)
	move.l	a0,BLTCPT(a6)
	move.w	12(a1),BLTSIZE(a6)
	bsr.L	WBLT
	lea	40(a0),a0
	move.l	4(a1),BLTBPT(a6)
	move.l	a0,BLTDPT(a6)
	move.l	a0,BLTCPT(a6)
	move.w	12(a1),BLTSIZE(a6)
	bsr.L	WBLT
	lea	40(a0),a0
	move.l	4(a1),BLTBPT(a6)
	move.l	a0,BLTDPT(a6)
	move.l	a0,BLTCPT(a6)
	move.w	12(a1),BLTSIZE(a6)
	cmp.b	#81,d2
	beq.s	BobS
	cmp.b	#82,d2
	beq.s	BobS
	bsr.L	WBLT
	lea	40(a0),a0
	move.l	4(a1),BLTAPT(a6)
	move.l	a0,BLTCPT(a6)
	move.l	a0,BLTDPT(a6)
	move.w	d6,d5
	or.w	#%0000101100001010,d5
	move.w	d5,BLTCON0(a6)
	move.w	12(a1),BLTSIZE(a6)
	bsr.L	WBLT
	lea	40(a0),a0
	move.l	4(a1),BLTAPT(a6)
	move.l	a0,BLTDPT(a6)
	or.w	#$09f0,d6
	move.w	d6,BLTCON0(a6)
	move.w	12(a1),BLTSIZE(a6)
	rts

BobS:
	lea	40(a0),a0
	bsr.s	WBLT
	move.l	4(a1),BLTAPT(a6)
	move.l	a0,BLTCPT(a6)
	move.l	a0,BLTDPT(a6)
	move.w	d6,d5
	or.w	#%0000101111111010,d5
	move.w	d5,BLTCON0(a6)
	move.w	12(a1),BLTSIZE(a6)

	bsr.L	WBLT
	lea	40(a0),a0
	move.l	4(a1),BLTAPT(a6)
	move.l	a0,BLTDPT(a6)
	or.w	#$09f0,d6
	move.w	d6,BLTCON0(a6)
	move.w	12(a1),BLTSIZE(a6)
	rts

;*******************************************************************

WBLT:
	btst	#6,DMACONR(a6)
WBLT0	btst	#6,DMACONR(a6)
	bne.s	WBLT0
	rts

;*******************************************************************

ResetBob:
	lea	Bob00,a0
	moveq	#7,d0
In00:
	clr.w	4(a0)
	lea	12(a0),a0
	dbf	d0,In00
	rts

;*******************************************************************

Install:
	lea	CL2,a0
	movea.l	a0,d0
	move.w	d0,Jump+6
	swap	d0
	move.w	d0,Jump+2

	sf	Anim1
	sf	ScrNum

	lea	YOfs,a0
	move.w	#255,d0
	clr.l	d1
In0:
	move.l	d1,(a0)+
	add.l	#200,d1
	dbf	d0,In0

	lea	Ship1_1,a0
	move.l	a0,d1
	lea	Ship1_1T,a1
	moveq	#15,d0
In1:	add.l	d1,(a1)
	add.l	d1,4(a1)
	lea	16(a1),a1	;bobtab
	dbf	d0,In1

	lea	Ship1_2,a0
	move.l	a0,d1
	lea	Ship1_2T,a1
	moveq	#15,d0
In2:	add.l	d1,(a1)
	add.l	d1,4(a1)
	lea	16(a1),a1	;bobtab
	dbf	d0,In2

	lea	Ship2_1,a0
	move.l	a0,d1
	lea	Ship2_1T,a1
	moveq	#15,d0
In3:	add.l	d1,(a1)
	add.l	d1,4(a1)
	lea	16(a1),a1	;bobtab
	dbf	d0,In3

	lea	Ship2_2,a0
	move.l	a0,d1
	lea	Ship2_2T,a1
	moveq	#15,d0
In4:	add.l	d1,(a1)
	add.l	d1,4(a1)
	lea	16(a1),a1	;bobtab
	dbf	d0,In4

	lea	Kaps1_1,a0
	move.l	a0,d1
	lea	Kaps1_1T,a1
	moveq	#15,d0
In5:	add.l	d1,(a1)
	add.l	d1,4(a1)
	lea	16(a1),a1
	dbf	d0,In5

	lea	Kapsula,a0
	move.l	a0,d1
	lea	KapsulaT,a1
	add.l	d1,(a1)
	add.l	d1,4(a1)

	lea	Asteroid,a0
	move.l	a0,d1
	lea	AsteroidT,a1
	add.l	d1,(a1)
	add.l	d1,4(a1)

	lea	Laser1,a0
	move.l	a0,d1
	lea	Laser1T,a1
	add.l	d1,(a1)
	add.l	d1,4(a1)

	lea	Laser2,a0
	move.l	a0,d1
	lea	Laser2T,a1
	add.l	d1,(a1)
	add.l	d1,4(a1)

	rts

;*******************************************************************

Set2Pal:
	bsr.L	WVBL

	lea	CL3,a1
	movea.l	a1,d0
	move.w	d0,Jump+6
	swap	d0
	move.w	d0,Jump+2

	lea	CLCol,a1
	moveq	#32-1,d0
S2P:
	move.w	(a0)+,2(a1)
	lea	4(a1),a1
	dbf	d0,S2P
	rts

;*******************************************************************

Set2:
	bsr.L	ResetBob
	lea	Scr2,a0
	lea	Screen0+OFS,a1
	lea	Screen1+OFS,a2
	lea	Screen2+OFS,a3
	move.w	#192-1,d0
Set21:
	move.w	#40-1,d1
Set22:
	move.l	(a0),(a1)+
	move.l	(a0),(a2)+
	move.l	(a0)+,(a3)+
	dbf	d1,Set22
	move.w	#10-1,d1
Set23:
	clr.l	(a1)+
	clr.l	(a2)+
	clr.l	(a3)+
	dbf	d1,Set23
	dbf	d0,Set21
	rts

;*******************************************************************

SetStars:
	bsr.L	ResetBob
	lea	Screen0,a0
	move.w	#28800-1,d0
SS1:	clr.l	(a0)+
	dbf	d0,SS1
	lea	CL4,a1
	movea.l	a1,d0
	move.w	d0,Jump+6
	swap	d0
	move.w	d0,Jump+2
	rts

;*******************************************************************

Set1:
	bsr.L	ResetBob
	lea	Scr1,a0
	lea	Screen0+OFS,a1
	lea	Screen1+OFS,a2
	lea	Screen2+OFS,a3
	move.w	#192-1,d0
Set11:
	move.w	#40-1,d1
Set12:
	move.l	(a0),(a1)+
	move.l	(a0),(a2)+
	move.l	(a0)+,(a3)+
	dbf	d1,Set12
	move.w	#10-1,d1
Set13:
	clr.l	(a1)+
	clr.l	(a2)+
	clr.l	(a3)+
	dbf	d1,Set13
	dbf	d0,Set11

	lea	CL2,a1
	movea.l	a1,d0
	move.w	d0,Jump+6
	swap	d0
	move.w	d0,Jump+2
	rts

;*******************************************************************

Set0:
	bsr.L	ResetBob
	lea	Scr0,a0
	lea	Screen0+OFS,a1
	lea	Screen1+OFS,a2
	lea	Screen2+OFS,a3
	move.w	#192-1,d0
Set01:
	move.w	#40-1,d1
Set02:
	move.l	(a0),(a1)+
	move.l	(a0),(a2)+
	move.l	(a0)+,(a3)+
	dbf	d1,Set02
	move.w	#10-1,d1
Set03:
	clr.l	(a1)+
	clr.l	(a2)+
	clr.l	(a3)+
	dbf	d1,Set03
	dbf	d0,Set01
	rts

;*******************************************************************

Show0:
	lea	Screen0+OFS,a0
	lea	CLPtr,a1
	moveq	#4,d0
Sh01:
	move.l	a0,d1
	lea	40(a0),a0
	move.w	d1,6(a1)
	swap	d1
	move.w	d1,2(a1)
	lea	8(a1),a1
	dbf	d0,Sh01
	lea	Screen1,a0
	move.l	a0,ActScreen
	st	ScrNum
	bra.L	Clr1

Show1:
	lea	Screen1+OFS,a0
	lea	CLPtr,a1
	moveq	#4,d0
Sh11:
	move.l	a0,d1
	lea	40(a0),a0
	move.w	d1,6(a1)
	swap	d1
	move.w	d1,2(a1)
	lea	8(a1),a1
	dbf	d0,Sh11
	lea	Screen0,a0
	move.l	a0,ActScreen
	sf	ScrNum
	bra.L	Clr0

;*******************************************************************

Wait:
	move.l	d0,CNT
Wa:	tst.l	CNT
	bne.s	Wa
	rts

;*******************************************************************

Fade16:
	move.w	#16,d7
Fade0:	movem.l	d7/a0,-(sp)
	bsr.L	WVBL
	bsr.L	Fade
	movem.l	(sp)+,d7/a0
	dbf	d7,Fade0
	rts

;*******************************************************************

Fade16D:
	move.w	#16,d7
	bsr.L	WVBL
Fade0D:	movem.l	d7/a0,-(sp)
	bsr.s	Fade
	movem.l	(sp)+,d7/a0
	lea	CLR,a5
	lea	CLCol,a6
	moveq	#15-1,d0
FD:
	move.w	6(a6),2(a5)
	lea	8(a5),a5
	dbf	d0,FD
	dbf	d7,Fade0D
	rts

;*******************************************************************

Fade16C:
	move.w	#16,d7
Fade00:	movem.l	d7/a0,-(sp)
	bsr.L	WVBL
	bsr.L	WVBL
	bsr.s	Fade
	movem.l	(sp)+,d7/a0
	lea	CLR,a5
	lea	CLCol,a6
	moveq	#15-1,d0
FC:
	move.w	6(a6),2(a5)
	lea	8(a5),a5
	dbf	d0,FC
	dbf	d7,Fade00
	rts

;*******************************************************************

Fade16B:
	move.w	#16,d7
Fade0B:	movem.l	d7/a0,-(sp)
	bsr.s	Fade
	movem.l	(sp)+,d7/a0
	dbf	d7,Fade0B
	rts

;*******************************************************************

;a0-palette a1-copperlist
Fade:
	move.l	PalPtr,a0
	lea	CLCol,a1
	move.w	#31,d0
Fa1:
	move.w	2(a1),d1
	move.w	(a0)+,d2
	move.w	d1,d3
	move.w	d2,d4
	and.w	#$f00,d3
	and.w	#$f00,d4
	cmp.w	d3,d4
	beq.s	Fa2a
	bcs.s	Fa3a
	add.w	#$100,d1
	bra.s	Fa2a
Fa3a:	sub.w	#$100,d1
Fa2a:
	move.w	d1,d3
	move.w	d2,d4
	and.w	#$0f0,d3
	and.w	#$0f0,d4
	cmp.w	d3,d4
	beq.s	Fa2b
	bcs.s	Fa3b
	add.w	#$010,d1
	bra.s	Fa2b
Fa3b:	sub.w	#$010,d1
Fa2b:
	move.w	d1,d3
	move.w	d2,d4
	and.w	#$00f,d3
	and.w	#$00f,d4
	cmp.w	d3,d4
	beq.s	Fa2c
	bcs.s	Fa3c
	add.w	#$001,d1
	bra.s	Fa2c
Fa3c:	sub.w	#$001,d1
Fa2c:
	move.w	d1,2(a1)
	lea	4(a1),a1
	dbf	d0,Fa1
	rts

;*******************************************************************

WVBL:
	sf	ByloVBL
WVBL0:	tst.b	ByloVBL
	beq.s	WVBL0
	rts

;*******************************************************************

ProcVBL:
	tst.b	ChgPal
	beq.s	Pr0
	bsr.L	Fade
Pr0:
	st	ByloVBL
	tst.l	CNT
	beq.s	Pr1
	sub.l	#1,CNT
Pr1:
	rts

;*******************************************************************

VBL:
	move.w	d0,-(sp)
	move.w	INTREQR+CUSTOM,d0
	btst	#5,d0
	beq.s	QuitV
	tst.b	WykonujVBL
	beq.s	QuitV
	movem.l	d0-d7/a0-a6,-(sp)
	lea	CUSTOM,a6
	bsr.L	ProcVBL
	movem.l	(sp)+,d0-d7/a0-a6
QuitV:	and.w	#$7fff,d0
	move.w	d0,INTREQ+CUSTOM
	move.w	(sp)+,d0
	rte

;*******************************************************************

StartVBL:
	st	WykonujVBL
	rts

;*******************************************************************

StopVBL:
	sf	WykonujVBL
	rts

;*******************************************************************

SetVBL:
	sf	WykonujVBL
	lea	VBL,a0
	move.l	a0,$6c
	move.w	#SETCLR+%100000+$4000,INTENA(a6)
	rts

;*******************************************************************

LMK:
	btst	#6,$bfe001
	bne.s	LMK
	rts

;*******************************************************************

WaitBlt:
	btst	#6,$dff002
WaBl1:	btst	#6,$dff002
	bne.s	WaBl1
	rts

;*******************************************************************

StartSystem:
	movem.l	d0-d7/a0-a6,-(sp)
	lea	GfxLibName,a1
	move.l	ExecBase,a6
	jsr	OldOpenLibrary(a6)
	move.l	d0,GfxLibBase
	exg	d0,a6
	jsr	OwnBlitter(a6)
	bsr.s	WaitBlt
	move.l	ExecBase,a6
	jsr	Forbid(a6)
	move.w	$dff002,MemDma
	move.w	$dff01c,MemInt
	or.w	#$8000,MemDma
	or.w	#$8000,MemInt
	move.w	#$7fff,$dff09a
	move.w	#$7fff,$dff096
	lea	MemVectors,a0
	lea	0,a1
	lea	Reset,a2
	moveq	#63,d0
StSy1:	move.l	(a1),(a0)+
	move.l	a2,(a1)+
	dbf	d0,StSy1
	bsr.s	InstEI
	movem.l	(sp)+,d0-d7/a0-a6
	rts

;*******************************************************************

StopSystem:
	movem.l	d0-d7/a0-a6,-(sp)
	move.w	#$7fff,$dff09a
	move.w	#$7fff,$dff096
	lea	MemVectors,a0
	lea	0,a1
	moveq	#63,d0
StSs1:	move.l	(a0)+,(a1)+
	dbf	d0,StSs1
	move.l	GfxLibBase,a6
	move.l	$26(a6),$dff080
	move.w	MemDma,$dff096
	move.w	MemInt,$dff09a
	move.l	ExecBase,a6
	jsr	Permit(a6)
	move.l	GfxLibBase,a6
	jsr	DisownBlitter(a6)
	exg	a6,a1
	move.l	ExecBase,a6
	jsr	CloseLibrary(a6)
	movem.l	(sp)+,d0-d7/a0-a6
	rts

;*******************************************************************

InstEI:
	lea	EmptyInt,a0
	move.l	a0,$64
	move.l	a0,$68
	move.l	a0,$6c
	move.l	a0,$70
	move.l	a0,$74
	move.l	a0,$78
	move.l	a0,$7c
	rts

;*******************************************************************

EmptyInt:
	move.w	d0,-(sp)
	move.w	INTREQR+CUSTOM,d0
	and.w	#$7fff,d0
	move.w	d0,INTREQ+CUSTOM
	move.w	(sp)+,d0
	rte

;*******************************************************************

Reset:
	move.w	#$7fff,$dff09a
	move.w	#$7fff,$dff096
	lea	ResetP,a0
	move.l	a0,$80
	trap	#0
ResetP:	clr.l	ExecBase
	lea	2,a0
	reset
	jmp	(a0)

;*******************************************************************
;			CONSTANS
;*******************************************************************

ExecBase	=	4
OldOpenLibrary	=	-408
CloseLibrary	=	-414
OwnBlitter	=	-456
DisownBlitter	=	-462
Forbid		=	-132
Permit		=	-138
CUSTOM		=	$dff000
BLTDDAT		=	$000
DMACONR		=	$002
VPOSR		=	$004
VHPOSR		=	$006
DSKDATR		=	$008
JOY0DAT		=	$00A
JOY1DAT		=	$00C
CLXDAT		=	$00E
ADKCONR		=	$010
POT0DAT		=	$012
POT1DAT		=	$014
POTGOR		=	$016
SERDATR		=	$018
DSKBYTR		=	$01A
INTENAR		=	$01C
INTREQR		=	$01E
DSKPTH		=	$020
DSKPTL		=	$022
DSKLEN		=	$024
DSKDAT		=	$026
REFPTR		=	$028
VPOSW		=	$02A
VHPOSW		=	$02C
COPCON		=	$02E
SERDAT		=	$030
SERPER		=	$032
POTGO		=	$034
JOYTEST		=	$036
STRQU		=	$038
STRVBL		=	$03A
STRHOR		=	$03C
STRLONG		=	$03E
BLTCON0		=	$040
BLTCON1		=	$042
BLTAFWM		=	$044
BLTALWM		=	$046
BLTCPT		=	$048
BLTBPT		=	$04C
BLTAPT		=	$050
BLTDPT		=	$054
BLTSIZE		=	$058
BLTCMOD		=	$060
BLTBMOD		=	$062
BLTAMOD		=	$064
BLTDMOD		=	$066
BLTCDAT		=	$070
BLTBDAT		=	$072
BLTADAT		=	$074
DSKSYNC		=	$07E
COP1PTR		=	$080
COP2PTR		=	$084
COP1LCH		=	$080
COP1LCL		=	$082
COP2LCH		=	$084
COP2LCL		=	$086
COPJMP1		=	$088
COPJMP2		=	$08A
COPINS		=	$08C
DIWSTRT		=	$08E
DIWSTOP		=	$090
DDFSTRT		=	$092
DDFSTOP		=	$094
DMACON		=	$096
CLXCON		=	$098
INTENA		=	$09A
INTREQ		=	$09C
ADKCON		=	$09E
AUDIO0		=	$0A0
AUDIO1		=	$0B0
AUDIO2		=	$0C0
AUDIO3		=	$0D0
BPL1PTH		=	$0E0
BPL1PTL		=	$0E2
BPL2PTH		=	$0E4
BPL2PTL		=	$0E6
BPL3PTH		=	$0E8
BPL3PTL		=	$0EA
BPL4PTH		=	$0EC
BPL4PTL		=	$0EE
BPL5PTH		=	$0F0
BPL5PTL		=	$0F2
BPL6PTH		=	$0F4
BPL6PTL		=	$0F6
BPLCON0		=	$100
BPLCON1		=	$102
BPLCON2		=	$104
BPL1MOD		=	$108
BPL2MOD		=	$10A
SPRPTR		=	$120
SPRPOS		=	$140
COLORS		=	$180
SETCLR		=	$8000
DSKEN		=	$10
SPREN		=	$20
BLTEN		=	$40
COPEN		=	$80
BPLEN		=	$100
DMAEN		=	$200
BLTPR		=	$400
ERSY		=	$2
LACE		=	$4
LPEN		=	$8
GAUD		=	$100
COLOR		=	$200
DBLPF		=	$400
HOMOD		=	$800
BPU0		=	$1000
BPU1		=	$2000
BPU2		=	$4000
HIRES		=	$8000
COPWAIT		=	$fffe
ENDCOPLST	=	$ffff
ENDHALF		=	$ffdf
KEYTALO		=	$bfe401
KEYTAHI		=	$bfe501
KEYCRA		=	$bfee01
KEYSDR		=	$bfec01
KEYICR		=	$bfed01
TBLO		=	$bfd600
TBHI		=	$bfd700
CRB		=	$bfdf00
ICR		=	$bfdd00

SPR0POS		=	$140
SPR0CTL		=	$142
SPR0DATA	=	$144
SPR0DATB	=	$146
SPR1POS		=	$148
SPR1CTL		=	$14a
SPR1DATA	=	$14c
SPR1DATB	=	$14e
SPR2POS		=	$150
SPR2CTL		=	$152
SPR2DATA	=	$154
SPR2DATB	=	$156
SPR3POS		=	$158
SPR3CTL		=	$15a
SPR3DATA	=	$15c
SPR3DATB	=	$15e
SPR4POS		=	$160
SPR4CTL		=	$162
SPR4DATA	=	$164
SPR4DATB	=	$166
SPR5POS		=	$168
SPR5CTL		=	$16a
SPR5DATA	=	$16c
SPR5DATB	=	$16e
SPR6POS		=	$170
SPR6CTL		=	$172
SPR6DATA	=	$174
SPR6DATB	=	$176
SPR7POS		=	$178
SPR7CTL		=	$17a
SPR7DATA	=	$17c
SPR7DATB	=	$17e

;*******************************************************************
;			CHIP DATA
;*******************************************************************

CL:
		dc.w	SPR0CTL,0,SPR1CTL,0,SPR2CTL,0,SPR3CTL,0
		dc.w	SPR4CTL,0,SPR5CTL,0,SPR6CTL,0,SPR7CTL,0
		dc.w	$2003,COPWAIT
CLCol:
		dc.w	$180,0,$182,0,$184,0,$186,0,$188,0,$18a,0,$18c,0,$18e,0
		dc.w	$190,0,$192,0,$194,0,$196,0,$198,0,$19a,0,$19c,0,$19e,0
		dc.w	$1a0,0,$1a2,0,$1a4,0,$1a6,0,$1a8,0,$1aa,0,$1ac,0,$1ae,0
		dc.w	$1b0,0,$1b2,0,$1b4,0,$1b6,0,$1b8,0,$1ba,0,$1bc,0,$1be,0

CLPtr:		dc.w	$e0,0,$e2,0
		dc.w	$e4,0,$e6,0
		dc.w	$e8,0,$ea,0
		dc.w	$ec,0,$ee,0
		dc.w	$f0,0,$f2,0

		dc.w	DDFSTRT,7*8
		dc.w	DDFSTOP,7*8+152
		dc.w	DIWSTRT,$0310
		dc.w	DIWSTOP,$7fc0
		dc.w	BPLCON1,0
		dc.w	BPLCON2,0
		dc.w	BPL1MOD,160
		dc.w	BPL2MOD,160

		dc.w	$3f03,COPWAIT,BPLCON0,COLOR+BPU0+BPU2

Jump:		dc.w	COP2LCH,0
		dc.w	COP2LCL,0
		dc.w	COPJMP2,0

;*******************************************************************

CL2:
		dc.w	$ff03,COPWAIT
		dc.w	BPLCON0,COLOR
		dc.w	ENDCOPLST,COPWAIT

;*******************************************************************

CL3:
CLR:		dc.w	$180,$0
		dc.w	$4703,COPWAIT,$182,$1
		dc.w	$4f03,COPWAIT,$182,$2
		dc.w	$5703,COPWAIT,$182,$3
		dc.w	$5f03,COPWAIT,$182,$4
		dc.w	$6703,COPWAIT,$182,$5
		dc.w	$6f03,COPWAIT,$182,$6
		dc.w	$7703,COPWAIT,$182,$7
		dc.w	$7f03,COPWAIT,$182,$8
		dc.w	$8703,COPWAIT,$182,$9
		dc.w	$8f03,COPWAIT,$182,$a
		dc.w	$9703,COPWAIT,$182,$b
		dc.w	$9f03,COPWAIT,$182,$c
		dc.w	$a703,COPWAIT,$182,$d
		dc.w	$af03,COPWAIT,$182,$e
		dc.w	$b703,COPWAIT,$182,0
		dc.w	$ff03,COPWAIT
		dc.w	BPLCON0,COLOR
		dc.w	ENDCOPLST,COPWAIT

;*******************************************************************

CW	=	COPWAIT

CL4:
	dc.w	SPR1DATB,0,SPR3DATB,0,SPR2DATB,0

ST:	blk.w	12*StarsIl

	dc.w	$ff03,COPWAIT
	dc.w	BPLCON0,COLOR
	dc.w	ENDCOPLST,COPWAIT
	
	incdir	'DH1:Sources/asm/robbo/bin/demobin/'

StarsT:		incbin	'StarsT.BIN'

	;--- System. ---

SysStat:	dc.b	0
GfxLibName:	dc.b	'graphics.library',0
	EVEN

Pal0:
Pal1:
	dc.w	$000,$000,$fff,$ddd,$aaa,$777,$444,$222
	dc.w	$fed,$eca,$c97,$a75,$853,$631,$420,$210
	dc.w	$eff,$dee,$bcc,$9aa,$788,$566,$344,$122
	dc.w	$fff,$e99,$e55,$d00,$a00,$600,$300,$000
Pal2:
	dc.w	$000,$000,$020,$030,$040,$050,$060,$222
	dc.w	$444,$555,$777,$888,$aaa,$ccc,$ddd,$fff
	dc.w	$eff,$dee,$bcc,$9aa,$788,$566,$344,$122
	dc.w	$fff,$e99,$e55,$d00,$a00,$600,$300,$000

Pal000:		blk.w	32,$000
Palfff:		blk.w	32,$fff

Ship1_1:	incbin	'Ship1_1.BIN'
Ship1_2:	incbin	'Ship1_2.BIN'
Ship2_1:	incbin	'Ship2_1.BIN'
Ship2_2:	incbin	'Ship2_2.BIN'
Kaps1_1:	incbin	'Kaps1_1.BIN'
Kapsula:	incbin	'Kapsula.BIN'
Laser1:		incbin	'Laser1.BIN'
Laser2:		incbin	'Laser2.BIN'
Asteroid:	incbin	'Asteroid.BIN'

Ship1_1T:	incbin	'Ship1_1.TAB'
Ship1_2T:	incbin	'Ship1_2.TAB'
Ship2_1T:	incbin	'Ship2_1.TAB'
Ship2_2T:	incbin	'Ship2_2.TAB'
Kaps1_1T:	incbin	'Kaps1_1.TAB'
KapsulaT:	incbin	'Kapsula.TAB'
Laser1T:	incbin	'Laser1.TAB'
Laser2T:	incbin	'Laser2.TAB'
AsteroidT:	incbin	'Asteroid.TAB'

Anim1:		dc.b	0
ChgPal:		dc.b	0
	EVEN

BobAddY:
	dc.w	0,2,3,4,6,9,12,15,15,15,15,12,10,8,5,2
	dc.w	0,5,10,13,17,22,28,33,39,42,43,43,41,37,33,30
	dc.w	0,1,3,5,8,10,13,16,19,21,22,18,15,12,10,7
	dc.w	0,2,4,6,9,12,15,18,17,15,9,3,-4,-10,-17,-24
	dc.w	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

;*******************************************************************
;			CHIP WORK
;*******************************************************************

Fine:

	;--- System. ---

GfxLibBase:	dc.l	0
MemStack:	dc.l	0
MemDma:		dc.w	0
MemInt:		dc.w	0
MemVectors:	blk.l	64
Stack:		blk.b	STACKSIZE
	EVEN

	;--- VBL. ---

PalPtr:		dc.l	0
ActScreen:	dc.l	0
CNT:		dc.l	0
LX:		dc.w	0
LY:		dc.w	0
SL:		dc.b	0
WykonujVBL:	dc.b	0
ByloVBL:	dc.b	0
ScrNum:		dc.b	0
HlpAdd:		dc.b	0
AddAnim:	dc.b	0
FrameCnt:	dc.b	0
	EVEN

YOfs:		blk.l	256,0

Bob00:		blk.b	12,0
Bob01:		blk.b	12,0
Bob02:		blk.b	12,0
Bob03:		blk.b	12,0
Bob10:		blk.b	12,0
Bob11:		blk.b	12,0
Bob12:		blk.b	12,0
Bob13:		blk.b	12,0

Screen0:	blk.b	40*192*5
Screen1:	blk.b	40*192*5
Screen2:	blk.b	40*192*5

;************** FAST !!! *****************

Scr0:		incbin	'Screen0.BIN'
Scr1:		incbin	'Screen1.BIN'
Scr2:		incbin	'Screen2.BIN'

Stop:
