
;----------------------------------------------------------------------------;
;               Device Driver For Playstation Controllers                    ;
;----------------------------------------------------------------------------;

		OUTPUT	RAM:psxport-fast.device

; Includes

		INCDIR	DEVPAC:includes

		INCLUDE	exec/exec.i
		INCLUDE	devices/inputevent.i
		INCLUDE	devices/gameport.i

		include	resources/misc.i
		include	hardware/cia.i
		include offsets.lib

		include	psxport.i

; Misc definitions

_ciaa		equ	$BFE001
_ciab		equ	$BFD000

GPD_COMMUNICATE		equ	14

NSDEVTYPE_GAMEPORT      equ	1

		STRUCTURE NSDeviceQueryResult,0
		ULONG	nsdqr_DevQueryFormat	; this is type 0
		ULONG	nsdqr_SizeAvailable	; at least 16
		UWORD	nsdqr_DeviceType
		UWORD	nsdqr_DeviceSubType
		APTR	nsdqr_SupportedCommands
		LABEL	nsdqr_SIZEOF

CALLSYS		macro
		jsr	_LVO\1(a6)
		endm

LINKSYS		macro
		move.l	a6,-(a7)
		movea.l	\2,a6
		CALLSYS	\1
		movea.l	(a7)+,a6
		endm

;----------------------------------------------------------------------------;

VERSION		EQU	1			;Code version number
REVISION	EQU	0			;And revision

; Dummy entry (for idiots)
; Enters here if run as program

Entry		moveq	#0,d0
		rts

; Resident structure to initialize all of this

InitDescript	dc.w	RTC_MATCHWORD
		dc.l	InitDescript
		dc.l	EndCode
		dc.b	RTF_AUTOINIT
		dc.b	VERSION
		dc.b	NT_DEVICE
		dc.b	0
		dc.l	MyName
		dc.l	IDString
		dc.l	Init

		dc.l	0

MyName		dc.b	'psxport.device',0
		even

IDString	dc.b	'psxport.device 1.0 (11.10.99)'
		dc.b	' 1999 By Joseph Fenton',0
		even

Init		dc.l	MyDev_Sizeof		;data space size
		dc.l	FuncTable		;pointer to function initializers
		dc.l	DataTable		;pointer to data initializers
		dc.l	InitRoutine		;routine to run

FuncTable	dc.l	Open
		dc.l	Close
		dc.l	Expunge
		dc.l	Reserved		;Reserved for future use!
		dc.l	BeginIO
		dc.l	AbortIO
		dc.l	-1

DataTable	INITBYTE LN_TYPE,NT_DEVICE
		INITLONG LN_NAME,MyName
		INITBYTE LIB_FLAGS,LIBF_SUMUSED!LIBF_CHANGED
		INITWORD LIB_VERSION,VERSION
		INITWORD LIB_REVISION,REVISION
		INITLONG LIB_IDSTRING,IDString
		dc.w	0

;-------------------------------------------------------------------------
; a0 - ptr to seglist
; a3 - ptr to temporary ram
; a4 - ptr to expansion base
; a5 - ptr to our device
; a6 - ptr to exec base

InitRoutine	movem.l	d1-d7/a0-a5,-(a7)
		move.l	d0,a5
		move.l	a6,md_SysLib(a5)
		move.l	a0,md_SegList(a5)

		lea	md_HwLock(a5),a0
		CALLSYS	InitSemaphore

		moveq	#37,d0
		lea	dosname,a1
		CALLSYS	OpenLibrary
		move.l	d0,md_DOSBase(a5)
		beq.b	.err

		bsr	SetupPort
		beq.b	.exit

		movea.l	md_DOSBase(a5),a1
		CALLSYS	CloseLibrary
		moveq	#0,d0
		bra.b	.err
.exit		move.l	a5,d0
.err		movem.l	(a7)+,d1-d7/a0-a5
		rts

;-------------------------------------------------------------------------
; D0 = Unit #
; D1 = Flags
; A1 = ptr to io_req
; A6 = ptr to device

Open		addq.w	#1,LIB_OPENCNT(a6)	;prevent expunge during Open
		movem.l	d2/a2-a4,-(a7)
		move.l	a1,a2			;save ptr to io_req in a2
		cmpi.l	#7,d0			;max # of units=8 (0-3, 4-7)
		bhi.b	Open_Error		;too large!
		move.l	d0,d2			;save unit number
		lsl.l	#2,d0			;*4
		lea	md_Units(a6,d0.l),a4
		move.l	(a4),d0			;is unit already open?
		bne.b	Open_UnitOK		;yes, don't initialize it!
		bsr	InitUnit		;go initialize the unit
		move.l	(a4),d0
		beq.b	Open_Error
Open_UnitOK	move.l	d0,a3			;unit pointer in a3
		move.l	d0,IO_UNIT(a2)
		addq.w	#1,LIB_OPENCNT(a6)
		addq.w	#1,UNIT_OPENCNT(a3)
		bclr	#LIBB_DELEXP,md_Flags(a6)
		moveq	#0,d0
		move.b	d0,IO_ERROR(a2)
		move.b	#NT_REPLYMSG,LN_TYPE(a2)
Open_End	subq.w	#1,LIB_OPENCNT(a6)
		movem.l	(a7)+,d2/a2-a4
		rts

Open_Error	moveq	#IOERR_OPENFAIL,d0
		move.b	d0,IO_ERROR(a2)
		move.l	d0,IO_DEVICE(a2)
		bra.b	Open_End

;-------------------------------------------------------------------------
; A1 = ptr to io_req
; A6 = ptr to device

Close		movem.l	d1/a2-a3,-(a7)
		move.l	a1,a2
		move.l	IO_UNIT(a2),a3
		moveq	#-1,d0
		move.l	d0,IO_UNIT(a2)		;kill access to unit before expunge!
		move.l	d0,IO_DEVICE(a2)	;kill access to device
		subq.w	#1,UNIT_OPENCNT(a3)
		bne.b	Close_Device
		bsr	ExpungeUnit

Close_Device	moveq	#0,d0
		subq.w	#1,LIB_OPENCNT(a6)
		bne.b	Close_End
		btst	#LIBB_DELEXP,md_Flags(a6)
		beq.b	Close_End
		bsr.b	Expunge

Close_End	movem.l	(a7)+,d1/a2-a3
		rts


;-------------------------------------------------------------------------
; A6 = ptr to device

Expunge		movem.l	d1-d2/a5-a6,-(a7)
		move.l	a6,a5
		move.l	md_SysLib(a5),a6
		tst.w	LIB_OPENCNT(a5)
		beq.b	.0
		bset	#LIBB_DELEXP,md_Flags(a5)
		moveq	#0,d0
		bra.b	Expunge_End
		
.0		move.l	md_SegList(a5),d2
		move.l	a5,a1
		CALLSYS	Remove			;Remove first

		tst.b	rsrcFlag
		beq.b	.1
		bsr	CleanupPort

.1		movea.l	md_DOSBase(a5),a1
		CALLSYS	CloseLibrary

		move.l	a5,a1			;Devicebase
		moveq	#0,d0
		move.w	LIB_NEGSIZE(a5),d0
		suba.l	d0,a1			;Calculate base of functions
		add.w	LIB_POSSIZE(a5),d0	;Calculate size of functions + data area
		CALLSYS	FreeMem
		move.l	d2,d0
Expunge_End	movem.l	(a7)+,d1-d2/a5-a6
		rts

;-------------------------------------------------------------------------

Reserved	moveq	#0,d0
		rts

EndCode:

;-------------------------------------------------------------------------
; D1 = Flags
; D2 = Unit #
; A3 = ptr to Unit
; A6 = ptr to device

InitUnit	movem.l	d2-d4/a2,-(a7)
		move.l	d1,d3			;save flags
		move.b	d2,psxportunit
		addi.b	#'0',psxportunit

		move.l	#MyDevUnit_Sizeof,d0
		move.l	#MEMF_PUBLIC!MEMF_CLEAR,d1
		LINKSYS	AllocVec,md_SysLib(a6)  ;get some memory for structure
		move.l	d0,a3			;ptr to Unit Structure
		tst.l	d0
		beq.b	InitUnit_End

		move.b	d2,mdu_UnitNum(a3)
		move.b	d3,mdu_Flags(a3)	;set flags
		move.l	a6,mdu_Device(a3)	;save ptr to device

		bsr	TestUnit
		tst.l	d0
		bne.b	.err			; no device at this unit

		move.l	a3,CurrentUnitPtr
		move.l	#psxportname,d1
		moveq	#MYPROCPRI,d2
		move.l	#MyProc_SegList,d3
		lsr.l	#2,d3			;make it damn BCPL
		move.l	#MYPROCSTACKSIZE,d4
		LINKSYS	CreateProc,md_DOSBase(a6)
		move.l	d0,mdu_MsgPort(a3)
		beq.b	.err
		move.l	a3,(a4)			;mark unit as valid (store it's address)
		bra.b	InitUnit_End

.err		movea.l	a3,a1
		LINKSYS	FreeVec,md_SysLib(a6)

InitUnit_End	movem.l	(a7)+,d2-d4/a2
		rts

;-------------------------------------------------------------------------
; A3 = ptr to unit
; A6 = ptr to device

FreeUnit	move.l	a3,a1
		LINKSYS	FreeVec,md_SysLib(a6)
		rts

;---------------------------------------------------------------------------
; A3 = ptr to unit
; A6 = ptr to device

ExpungeUnit	lea	md_Units(a6),a0
.loop		cmpa.l	(a0)+,a3
		bne.b	.loop
		clr.l	-4(a0)			;mark unit as no longer there
		move.l	mdu_MsgPort(a3),a1	;get process's msgport
		suba.l	#92,a1			;go backwards to task address
		LINKSYS	RemTask,md_SysLib(a6)
		bsr	FreeUnit		;go free memory used by this unit
		rts

;-------------------------------------------------------------------------
; A3 = ptr to Unit
; A6 = ptr to device

TestUnit	lea	md_HwLock(a6),a0
		LINKSYS	ObtainSemaphore,md_SysLib(a6)

		clr.l	FLG_Interrupt+IS_DATA	; no signal, just global
		moveq	#CIAICRB_FLG,d0
		lea	FLG_Interrupt,a1
		LINKSYS	AddICRVector,md_CIAABase(a6)
		tst.l	d0
		bne	.nodev

		lea	_ciaa+ciaprb,a0
		move.b	#$FD,(a0)		; POWERON, /SEL = 0, /CLK = CMD = 1
		tst.b	(a0)
		tst.b	(a0)
		tst.b	(a0)
		tst.b	(a0)
		tst.b	(a0)
		tst.b	(a0)
		tst.b	(a0)
		tst.b	(a0)
		tst.b	(a0)

		move.b	mdu_UnitNum(a3),d0
		bclr	#2,d0
		beq.b	.0			; unit 0-3 = controller
		ori.b	#$80,d0			; unit 4-7 = memory card
.0		addq.b	#1,d0			; device number
		bsr	AckCMDByteTO
		cmpi.l	#-1,d0
		beq.b	.nodev1			; timeout

		move.b	#$42,d0			; controller status
		btst	#2,mdu_UnitNum(a3)
		beq.b	.1
		move.b	#'R',d0			; memory card read
.1		bsr	AckCMDByteTO
		cmpi.l	#-1,d0
		beq.b	.nodev1			; timeout

		moveq	#0,d0
		bsr	AckCMDByteTO
		cmpi.l	#-1,d0
		beq.b	.nodev1			; timeout

		lea	_ciaa+ciaprb,a0
		move.b	#$FF,(a0)		; POWERON, /CLK = /SEL = CMD = 1

		moveq	#CIAICRB_FLG,d0
		lea	FLG_Interrupt,a1
		LINKSYS	RemICRVector,md_CIAABase(a6)

		lea	md_HwLock(a6),a0
		LINKSYS	ReleaseSemaphore,md_SysLib(a6)
		moveq	#0,d0
		rts

.nodev1		lea	_ciaa+ciaprb,a0
		move.b	#$FF,(a0)		; POWERON, /CLK = /SEL = CMD = 1

		moveq	#CIAICRB_FLG,d0
		lea	FLG_Interrupt,a1
		LINKSYS	RemICRVector,md_CIAABase(a6)

.nodev		lea	md_HwLock(a6),a0
		LINKSYS	ReleaseSemaphore,md_SysLib(a6)
		moveq	#-1,d0
		rts

;-------------------------------------------------------------------------

		cnop	0,16

CMDTable	dc.l	Clear
		dc.l	ReadEvent
		dc.l	AskCType
		dc.l	SetCType
		dc.l	AskTrigger
		dc.l	SetTrigger
		dc.l	Communicate
		dc.l	NSDeviceQuery

CMDList		dc.w	5		; CMD_CLEAR
		dc.w	9		; GPD_READEVENT
		dc.w	10		; GPD_ASKCTYPE
		dc.w	11		; GPD_SETCTYPE
		dc.w	12		; GPD_ASKTRIGGER
		dc.w	13		; GPD_SETTRIGGER
		dc.w	14		; GPD_COMMUNICATE
		dc.w	$4000		; NSCMD_DEVICEQUERY
		dc.w	0

;-------------------------------------------------------------------------
; A1 = ptr to io_req
; A6 = ptr to device

		cnop	0,16

BeginIO		movem.l	d1/a0/a3,-(a7)
		move.b	#NT_MESSAGE,LN_TYPE(a1)		
		move.l	IO_UNIT(a1),a3
		clr.b	IO_ERROR(a1)
		move.w	IO_COMMAND(a1),d0
		lea	CMDList,a0
.loop		cmp.w	(a0)+,d0
		beq.b	.found
		tst.w	(a0)
		bne.b	.loop
		bra.b	BeginIO_NoCmd		; unsupported command

.found		cmpi.w	#GPD_READEVENT,d0
		beq.b	BeginIO_Qued
		cmpi.w	#GPD_COMMUNICATE,d0
		beq.b	BeginIO_Qued

		btst	#IOB_QUICK,IO_FLAGS(a1)
		bne.b	BeginIO_Quick

BeginIO_Qued	andi.b	#$7e,IO_FLAGS(a1)	; clear immediate and quick flags
		bset	#UNITB_INTASK,UNIT_FLAGS(a3)
		move.l	mdu_MsgPort(a3),a0
		LINKSYS	PutMsg,md_SysLib(a6)
BeginIO_End	movem.l	(a7)+,d1/a0/a3
		rts

BeginIO_Quick	bset	#7,IO_FLAGS(a1)
		bsr.b	PerformIO
		bra.b	BeginIO_End

BeginIO_NoCmd	move.b	#IOERR_NOCMD,IO_ERROR(a1)
		bra.b	BeginIO_End

;-------------------------------------------------------------------------
; A1 = ptr to io_req
; A3 = ptr to unit
; A6 = ptr to device

		cnop	0,16

PerformIO	move.w	IO_COMMAND(a1),d0
		lea	CMDList,a0
.loop		cmp.w	(a0)+,d0
		bne.b	.loop
		suba.l	#CMDList+2,a0
		move.l	a0,d1
		lea	CMDTable,a0
		move.l	(a0,d1.w*2),a0
		jmp	(a0)			; iob:a1  unit:a3  devprt:a6

;-------------------------------------------------------------------------
; A1 = ptr to io_req
; A3 = ptr to unit
; A6 = ptr to device

		cnop	0,16

TermIO		moveq	#0,d0
		move.w	IO_COMMAND(a1),d0
		cmpi.w	#GPD_READEVENT,d0
		beq.b	.queued
		cmpi.w	#GPD_COMMUNICATE,d0
		bne.b	.quick

.queued		btst	#UNITB_INTASK,UNIT_FLAGS(a3)
		bne.b	.quick
		bclr	#UNITB_ACTIVE,UNIT_FLAGS(a3)

.quick		btst	#IOB_QUICK,IO_FLAGS(a1)
		bne.b	.exit
		LINKSYS	ReplyMsg,md_SysLib(a6)	;a1-message
.exit		rts

;-------------------------------------------------------------------------
; A1 = ptr to io_req
; A3 = ptr to unit
; A6 = ptr to device

AbortIO		moveq	#0,d0			;return failed
		rts

;-------------------------------------------------------------------------
; A1 = ptr to io_req
; A3 = ptr to unit
; A6 = ptr to device

Clear		clr.w	mdu_Event+ie_Class(a3)
		clr.l	mdu_Event+ie_Code(a3)
		clr.l	mdu_Event+ie_X(a3)
		clr.l	mdu_Event+ie_TimeStamp(a3)
		clr.l	mdu_Event+ie_TimeStamp+4(a3)
		bra	TermIO

;-------------------------------------------------------------------------
; A1 = ptr to io_req
; A3 = ptr to unit
; A6 = ptr to device

		cnop	0,16

ReadEvent	move.l	a1,-(a7)
		lea	md_HwLock(a6),a0
		LINKSYS	ObtainSemaphore,md_SysLib(a6)

		move.l	a3,FLG_Interrupt+IS_DATA
		moveq	#CIAICRB_FLG,d0
		lea	FLG_Interrupt,a1
		LINKSYS	AddICRVector,md_CIAABase(a6)
		movea.l	(a7)+,a1
		tst.l	d0
		bne	.err1

		lea	_ciaa+ciaprb,a0
		move.b	#$FD,(a0)		; POWERON, /SEL = 0, /CLK = CMD = 1
		tst.b	(a0)
		tst.b	(a0)
		tst.b	(a0)
		tst.b	(a0)
		tst.b	(a0)
		tst.b	(a0)
		tst.b	(a0)
		tst.b	(a0)
		tst.b	(a0)

		move.b	mdu_UnitNum(a3),d0
		bclr	#2,d0
		bne	.err2			; unit 4-7 = memory card, no event data
		addq.b	#1,d0
		bsr	AckCMDByte		; device number

		move.b	#$42,d0
		bsr	AckCMDByte		; controller status
		move.b	d0,mdu_Event+ie_Class(a3)

		cmpi.b	#$80,d0
		bne.b	.notmultitap
; multitap
		moveq	#0,d0
		bsr	AckCMDByte
		moveq	#0,d0
		bsr	AckCMDByte
		move.b	d0,mdu_Event+ie_Class(a3)

.notmultitap	cmpi.b	#$41,d0
		beq.b	.joypad
		cmpi.b	#$23,d0
		beq.b	.wheel
		cmpi.b	#$12,d0
		beq	.mouse

; dual analog joystick
		moveq	#0,d0
		bsr	AckCMDByte
		move.b	d0,mdu_Event+ie_SubClass(a3)
		moveq	#0,d0
		bsr	AckCMDByte
		move.b	d0,mdu_Event+ie_Code(a3)	; L   D   R   U   S   R3  L3  Sel
		moveq	#0,d0
		bsr	AckCMDByte
		move.b	d0,mdu_Event+ie_Code+1(a3)	; []  X   O   <|  R1  L1  R2  L2
		moveq	#0,d0
		bsr	AckCMDByte
		move.b	d0,mdu_Event+ie_X(a3)		; Right Stick L <-> R (0=L, $80=C, $FF=R)
		moveq	#0,d0
		bsr	AckCMDByte
		move.b	d0,mdu_Event+ie_X+1(a3)		; Right Stick U <-> D (0=U, $80=C, $FF=D)
		moveq	#0,d0
		bsr	AckCMDByte
		move.b	d0,mdu_Event+ie_Y(a3)		; Left Stick L <-> R (0=L, $80=C, $FF=R)
		moveq	#0,d0
		bsr	NoAckCMDByte
		move.b	d0,mdu_Event+ie_Y+1(a3)		; Left Stick U <-> D (0=U, $80=C, $FF=D)
		bra	.done

.joypad		moveq	#0,d0
		bsr	AckCMDByte
		move.b	d0,mdu_Event+ie_SubClass(a3)
		moveq	#0,d0
		bsr	AckCMDByte
		move.b	d0,mdu_Event+ie_Code(a3)	; L   D   R   U   S   1   1   Sel
		moveq	#0,d0
		bsr	NoAckCMDByte
		move.b	d0,mdu_Event+ie_Code+1(a3)	; []  X   O   <|  R1  L1  R2  L2
		bra.b	.done

.wheel		moveq	#0,d0
		bsr	AckCMDByte
		move.b	d0,mdu_Event+ie_SubClass(a3)
		moveq	#0,d0
		bsr	AckCMDByte
		move.b	d0,mdu_Event+ie_Code(a3)	; L   D   R   U   S   1   1   Sel
		moveq	#0,d0
		bsr	AckCMDByte
		move.b	d0,mdu_Event+ie_Code+1(a3)	; 1   1   A   B   R   1   1   1
		moveq	#0,d0
		bsr	AckCMDByte
		move.b	d0,mdu_Event+ie_X(a3)		; Wheel L <-> R (0=L, $80=C, $FF=R)
		moveq	#0,d0
		bsr	AckCMDByte
		move.b	d0,mdu_Event+ie_X+1(a3)		; I Switch (0-$FF)
		moveq	#0,d0
		bsr	AckCMDByte
		move.b	d0,mdu_Event+ie_Y(a3)		; II Switch (0-$FF)
		moveq	#0,d0
		bsr	NoAckCMDByte
		move.b	d0,mdu_Event+ie_Y+1(a3)		; L Switch (0-$FF)
		bra.b	.done

.mouse		moveq	#0,d0
		bsr	AckCMDByte
		move.b	d0,mdu_Event+ie_SubClass(a3)
		moveq	#0,d0
		bsr	AckCMDByte
		move.b	d0,mdu_Event+ie_Code(a3)	; 1   1   1   1   1   1   1   1
		moveq	#0,d0
		bsr	AckCMDByte
		move.b	d0,mdu_Event+ie_Code+1(a3)	; 1   1   1   1   L   R   0   0
		moveq	#0,d0
		bsr	AckCMDByte
		ext.w	d0
		move.w	d0,mdu_Event+ie_X(a3)		; Mouse X Delta
		moveq	#0,d0
		bsr	NoAckCMDByte
		ext.w	d0
		move.w	d0,mdu_Event+ie_Y(a3)		; Mouse Y Delta

.done		lea	_ciaa+ciaprb,a0
		move.b	#$FF,(a0)		; POWERON, /CLK = /SEL = CMD = 1

		move.l	a1,-(a7)
		moveq	#CIAICRB_FLG,d0
		lea	FLG_Interrupt,a1
		LINKSYS	RemICRVector,md_CIAABase(a6)
		clr.l	FLG_Interrupt+IS_DATA

		lea	md_HwLock(a6),a0
		LINKSYS	ReleaseSemaphore,md_SysLib(a6)
		movea.l	(a7)+,a1

		move.l	IO_LENGTH(a1),d0
		movea.l	IO_DATA(a1),a0
		cmpi.l	#ie_SIZEOF,d0
		blo.b	.err
		move.w	mdu_Event+ie_Class(a3),ie_Class(a0)
		move.l	mdu_Event+ie_Code(a3),ie_Code(a0)
		move.l	mdu_Event+ie_X(a3),ie_X(a0)
		move.l	mdu_Event+ie_TimeStamp(a3),ie_TimeStamp(a0)
		move.l	mdu_Event+ie_TimeStamp+4(a3),ie_TimeStamp+4(a0)
		move.l	#ie_SIZEOF,IO_ACTUAL(a1)
		bra	TermIO

.err2		lea	_ciaa+ciaprb,a0
		move.b	#$FF,(a0)		; POWERON, /CLK = /SEL = CMD = 1

		move.l	a1,-(a7)
		moveq	#CIAICRB_FLG,d0
		lea	FLG_Interrupt,a1
		LINKSYS	RemICRVector,md_CIAABase(a6)
		clr.l	FLG_Interrupt+IS_DATA
		movea.l	(a7)+,a1

.err1		move.l	a1,-(a7)
		lea	md_HwLock(a6),a0
		LINKSYS	ReleaseSemaphore,md_SysLib(a6)
		movea.l	(a7)+,a1

.err		move.b	#-1,IO_ERROR(a1)
		bra	TermIO

;-------------------------------------------------------------------------
; A1 = ptr to io_req
; A3 = ptr to unit
; A6 = ptr to device

AskCType	movea.l	IO_DATA(a1),a0
		move.b	mdu_CType(a3),(a0)
		move.l	#1,IO_ACTUAL(a1)
		bra	TermIO

;-------------------------------------------------------------------------
; A1 = ptr to io_req
; A3 = ptr to unit
; A6 = ptr to device

SetCType	movea.l	IO_DATA(a1),a0
		move.b	(a0),mdu_CType(a3)
		move.l	#1,IO_ACTUAL(a1)
		bra	TermIO

;-------------------------------------------------------------------------
; A1 = ptr to io_req
; A3 = ptr to unit
; A6 = ptr to device

AskTrigger	movea.l	IO_DATA(a1),a0
		cmpi.l	#gpt_SIZEOF,IO_LENGTH(a1)
		blo.b	.err
		move.l	mdu_Trigger(a3),(a0)+
		move.l	mdu_Trigger+4(a3),(a0)
		move.l	#8,IO_ACTUAL(a1)
		bra	TermIO

.err		move.b	#-1,IO_ERROR(a1)
		bra	TermIO

;-------------------------------------------------------------------------
; A1 = ptr to io_req
; A3 = ptr to unit
; A6 = ptr to device

SetTrigger	movea.l	IO_DATA(a1),a0
		move.l	(a0)+,mdu_Trigger(a3)
		move.l	(a0),mdu_Trigger+4(a3)
		move.l	#8,IO_ACTUAL(a1)
		bra	TermIO

;-------------------------------------------------------------------------
; A1 = ptr to io_req
; A3 = ptr to unit
; A6 = ptr to device

		cnop	0,16

Communicate	move.l	a1,-(a7)
		lea	md_HwLock(a6),a0
		LINKSYS	ObtainSemaphore,md_SysLib(a6)

		btst	#0,mdu_Flags(a3)
		bne.b	.cont			; no signal flag
		move.l	a3,FLG_Interrupt+IS_DATA
.cont		moveq	#CIAICRB_FLG,d0
		lea	FLG_Interrupt,a1
		LINKSYS	AddICRVector,md_CIAABase(a6)
		movea.l	(a7)+,a1
		tst.l	d0
		bne	.err1

		lea	_ciaa+ciaprb,a0
		move.b	#$FD,(a0)		; POWERON, /SEL = 0, /CLK = CMD = 1
		tst.b	(a0)
		tst.b	(a0)
		tst.b	(a0)
		tst.b	(a0)
		tst.b	(a0)
		tst.b	(a0)
		tst.b	(a0)
		tst.b	(a0)
		tst.b	(a0)

		movea.l	IO_DATA(a1),a2
		move.l	IO_LENGTH(a1),d2
		move.l	d2,IO_ACTUAL(a1)
.loop		move.b	(a2),d0
		btst	#0,mdu_Flags(a3)
		beq.b	.ack			; no signal flag not set
		bsr	NoAckCMDByte
		bra.b	.next
.ack		bsr	AckCMDByte
.next		move.b	d0,(a2)+
		subq.l	#1,d2
		cmpi.l	#1,d2
		bne.b	.loop
		move.b	(a2),d0
		bsr	NoAckCMDByte
		move.b	d0,(a2)

		lea	_ciaa+ciaprb,a0
		move.b	#$FF,(a0)		; POWERON, /CLK = /SEL = CMD = 1

		move.l	a1,-(a7)
		moveq	#CIAICRB_FLG,d0
		lea	FLG_Interrupt,a1
		LINKSYS	RemICRVector,md_CIAABase(a6)
		clr.l	FLG_Interrupt+IS_DATA

		lea	md_HwLock(a6),a0
		LINKSYS	ReleaseSemaphore,md_SysLib(a6)
		movea.l	(a7)+,a1
		bra	TermIO

.err1		move.l	a1,-(a7)
		lea	md_HwLock(a6),a0
		LINKSYS	ReleaseSemaphore,md_SysLib(a6)
		movea.l	(a7)+,a1

.err		move.b	#-1,IO_ERROR(a1)
		bra	TermIO

;-------------------------------------------------------------------------
; A1 = ptr to io_req
; A3 = ptr to unit
; A6 = ptr to device

NSDeviceQuery	movea.l	IO_DATA(a1),a0
		move.l	#0,nsdqr_DevQueryFormat(a0)
		move.l	#16,nsdqr_SizeAvailable(a0)
		move.w	#NSDEVTYPE_GAMEPORT,nsdqr_DeviceType(a0)
		move.w	#'PX',nsdqr_DeviceSubType(a0)
		move.l	#CMDList,nsdqr_SupportedCommands(a0)
		move.l	#16,IO_ACTUAL(a1)
		bra	TermIO


;-------------------------------------------------------------------------
; D7 = Wait() Mask
; A3 = ptr to unit
; A6 = ptr to execbase
; A5 = ptr to device
; A4 = ptr to our task

		cnop	0,4

		dc.l	16
MyProc_SegList	dc.l	0			;pointer to next segment

Task_Begin	move.l	4.w,a6
		move.l	CurrentUnitPtr,a3	;Unit pointer
		move.l	mdu_Device(a3),a5	;Point to device structure
		move.l	mdu_MsgPort(a3),d7
		clr.l	CurrentUnitPtr		;ok, let another unit setup
		moveq	#-1,d0
		CALLSYS	AllocSignal
		moveq	#1,d1
		lsl.l	d0,d1
		move.l	d1,mdu_AckSignal(a3)
		suba.l	a1,a1
		CALLSYS	FindTask
		move.l	d0,mdu_AckTask(a3)
		bra.b	Task_StartHere

		cnop	0,16

Task_Unlock	and.b	#$ff&(~(UNITF_ACTIVE!UNITF_INTASK)),UNIT_FLAGS(a3)

Task_MainLoop	move.l	d7,a0
		CALLSYS	WaitPort
Task_StartHere	bset	#UNITB_ACTIVE,UNIT_FLAGS(a3)
		bne.b	Task_MainLoop		;device in use (immediate command)

Task_NextMsg	move.l	d7,a0
		CALLSYS	GetMsg
		tst.l	d0
		beq.b	Task_Unlock		;no message?
		move.l	d0,a1
		exg	a5,a6			;put device ptr in right place
		bsr	PerformIO
		exg	a5,a6			;get syslib back in a6
		bra.b	Task_NextMsg

;-------------------------------------------------------------------------
; A5 = Device
; A6 = _SysBase

SetupPort	movem.l	d1-d7/a0-a6,-(a7)

; allocate needed resources

		lea	ciaaname,a1
		CALLSYS	OpenResource
		move.l	d0,md_CIAABase(a5)
		beq	.err

		lea	miscname,a1
		CALLSYS	OpenResource
		move.l	d0,md_MiscBase(a5)
		beq	.err

		moveq	#MR_PARALLELPORT,d0
		lea	parportname,a1
		movea.l	md_MiscBase(a5),a6
		CALLSYS	AllocMiscResource
		tst.l	d0
		bne	.err

		moveq	#MR_PARALLELBITS,d0
		lea	parbitsname,a1
		CALLSYS	AllocMiscResource
		tst.l	d0
		bne	.err1

; setup port
		lea	_ciaa+ciaddrb,a0
		move.b	#$FF,(a0)		; outputs
		lea	_ciaa+ciaprb,a0
		move.b	#$FF,(a0)		; POWERON, /CLK = /SEL = CMD = 1

		move.l	#$40000,d0
.loop		tst.b	(a0)			; delay to allow power to stablize
		subq.l	#1,d0
		bne.b	.loop

		st	rsrcFlag

		movem.l	(a7)+,d1-d7/a0-a6
		moveq	#0,d0
		rts

.err1		moveq	#MR_PARALLELPORT,d0
		movea.l	md_MiscBase(a5),a6
		CALLSYS	FreeMiscResource

.err		movem.l	(a7)+,d1-d7/a0-a6
		moveq	#-1,d0
		rts

;-------------------------------------------------------------------------

CleanupPort	movem.l	d1-d7/a0-a6,-(a7)

		lea	_ciaa+ciaprb,a0
		move.b	#$FF,(a0)		; POWERON, /CLK = /SEL = CMD = 1

; free allocated resources

		moveq	#MR_PARALLELBITS,d0
		movea.l	md_MiscBase(a5),a6
		CALLSYS	FreeMiscResource

		moveq	#MR_PARALLELPORT,d0
		movea.l	md_MiscBase(a5),a6
		CALLSYS	FreeMiscResource

		clr.b	rsrcFlag

		movem.l	(a7)+,d1-d7/a0-a6
		moveq	#0,d0
		rts

;-------------------------------------------------------------------------

		cnop	0,16

AckCMDByteTO	movem.l	d1-d3/a0-a1,-(a7)
		clr.b	psxackflag
		bsr.b	SendCMDByte
		move.l	d0,-(a7)
;		move.l	#$40000,d0
		move.l	#$300,d0
.wait		tst.b	psxackflag
		bne.b	.exit			; got acknowledge
		tst.b	_ciaa+ciapra		; delay
		subq.l	#1,d0
		bcc.b	.wait
		move.l	d0,(a7)			; timeout
.exit		movem.l	(a7)+,d0-d3/a0-a1
		rts

		cnop	0,16

AckCMDByte	movem.l	d1-d3/a0-a1/a6,-(a7)
		bsr.b	SendCMDByte
		move.l	d0,-(a7)
		movea.l	md_SysLib(a6),a6
		move.l	mdu_AckSignal(a3),d0
		CALLSYS	Wait
		movem.l	(a7)+,d0-d3/a0-a1/a6
		rts

		cnop	0,16

NoAckCMDByte	movem.l	d1-d3/a0-a1,-(a7)
		bsr.b	SendCMDByte
		movem.l	(a7)+,d1-d3/a0-a1
		rts

; Entry:	d0 = CMD byte
; Exit:		d0 = DAT byte

		cnop	0,16

SendCMDByte	lea	_ciaa+ciaprb,a0
		lea	_ciab+ciapra,a1

		moveq	#1,d2
		and.b	d0,d2			; CMD b0
		lsr.b	#1,d0
		ori.b	#$F8,d2			; POWERON, /SEL = 0, /CLK = 0
		moveq	#4,d1			; /CLK = 1
		or.b	d2,d1			; POWERON, /SEL = 0, /CLK = 1
		move.b	d1,(a0)			; set CMD bit
		tst.b	(a0)
		tst.b	(a0)
		move.b	d2,(a0)			; clr /CLK bit
		tst.b	(a0)
		move.b	(a1),d2			; get DAT bit
		move.b	d1,(a0)			; set /CLK bit
		tst.b	(a0)
		lsr.b	#1,d2			; DAT b0
		roxr.b	#1,d3

		moveq	#1,d2
		and.b	d0,d2			; CMD b1
		lsr.b	#1,d0
		ori.b	#$F8,d2			; POWERON, /SEL = 0, /CLK = 0
		moveq	#4,d1			; /CLK = 1
		or.b	d2,d1			; POWERON, /SEL = 0, /CLK = 1
		move.b	d1,(a0)			; set CMD bit
		tst.b	(a0)
		tst.b	(a0)
		move.b	d2,(a0)			; clr /CLK bit
		tst.b	(a0)
		move.b	(a1),d2			; get DAT bit
		move.b	d1,(a0)			; set /CLK bit
		tst.b	(a0)
		lsr.b	#1,d2			; DAT b1
		roxr.b	#1,d3

		moveq	#1,d2
		and.b	d0,d2			; CMD b2
		lsr.b	#1,d0
		ori.b	#$F8,d2			; POWERON, /SEL = 0, /CLK = 0
		moveq	#4,d1			; /CLK = 1
		or.b	d2,d1			; POWERON, /SEL = 0, /CLK = 1
		move.b	d1,(a0)			; set CMD bit
		tst.b	(a0)
		tst.b	(a0)
		move.b	d2,(a0)			; clr /CLK bit
		tst.b	(a0)
		move.b	(a1),d2			; get DAT bit
		move.b	d1,(a0)			; set /CLK bit
		tst.b	(a0)
		lsr.b	#1,d2			; DAT b2
		roxr.b	#1,d3

		moveq	#1,d2
		and.b	d0,d2			; CMD b3
		lsr.b	#1,d0
		ori.b	#$F8,d2			; POWERON, /SEL = 0, /CLK = 0
		moveq	#4,d1			; /CLK = 1
		or.b	d2,d1			; POWERON, /SEL = 0, /CLK = 1
		move.b	d1,(a0)			; set CMD bit
		tst.b	(a0)
		tst.b	(a0)
		move.b	d2,(a0)			; clr /CLK bit
		tst.b	(a0)
		move.b	(a1),d2			; get DAT bit
		move.b	d1,(a0)			; set /CLK bit
		tst.b	(a0)
		lsr.b	#1,d2			; DAT b3
		roxr.b	#1,d3

		moveq	#1,d2
		and.b	d0,d2			; CMD b4
		lsr.b	#1,d0
		ori.b	#$F8,d2			; POWERON, /SEL = 0, /CLK = 0
		moveq	#4,d1			; /CLK = 1
		or.b	d2,d1			; POWERON, /SEL = 0, /CLK = 1
		move.b	d1,(a0)			; set CMD bit
		tst.b	(a0)
		tst.b	(a0)
		move.b	d2,(a0)			; clr /CLK bit
		tst.b	(a0)
		move.b	(a1),d2			; get DAT bit
		move.b	d1,(a0)			; set /CLK bit
		tst.b	(a0)
		lsr.b	#1,d2			; DAT b4
		roxr.b	#1,d3

		moveq	#1,d2
		and.b	d0,d2			; CMD b5
		lsr.b	#1,d0
		ori.b	#$F8,d2			; POWERON, /SEL = 0, /CLK = 0
		moveq	#4,d1			; /CLK = 1
		or.b	d2,d1			; POWERON, /SEL = 0, /CLK = 1
		move.b	d1,(a0)			; set CMD bit
		tst.b	(a0)
		tst.b	(a0)
		move.b	d2,(a0)			; clr /CLK bit
		tst.b	(a0)
		move.b	(a1),d2			; get DAT bit
		move.b	d1,(a0)			; set /CLK bit
		tst.b	(a0)
		lsr.b	#1,d2			; DAT b5
		roxr.b	#1,d3

		moveq	#1,d2
		and.b	d0,d2			; CMD b6
		lsr.b	#1,d0
		ori.b	#$F8,d2			; POWERON, /SEL = 0, /CLK = 0
		moveq	#4,d1			; /CLK = 1
		or.b	d2,d1			; POWERON, /SEL = 0, /CLK = 1
		move.b	d1,(a0)			; set CMD bit
		tst.b	(a0)
		tst.b	(a0)
		move.b	d2,(a0)			; clr /CLK bit
		tst.b	(a0)
		move.b	(a1),d2			; get DAT bit
		move.b	d1,(a0)			; set /CLK bit
		tst.b	(a0)
		lsr.b	#1,d2			; DAT b6
		roxr.b	#1,d3

		moveq	#1,d2
		and.b	d0,d2			; CMD b7
;		lsr.b	#1,d0
		ori.b	#$F8,d2			; POWERON, /SEL = 0, /CLK = 0
		moveq	#4,d1			; /CLK = 1
		or.b	d2,d1			; POWERON, /SEL = 0, /CLK = 1
		move.b	d1,(a0)			; set CMD bit
		tst.b	(a0)
		tst.b	(a0)
		move.b	d2,(a0)			; clr /CLK bit
		tst.b	(a0)
		move.b	(a1),d2			; get DAT bit
		move.b	d1,(a0)			; set /CLK bit
		tst.b	(a0)
		lsr.b	#1,d2			; DAT b7
		roxr.b	#1,d3

		moveq	#0,d0
		move.b	d3,d0			; return DAT
		rts

;-------------------------------------------------------------------------

		cnop	0,16

Acknowledge	tst.l	a1
		beq.b	.exit
		movea.l	mdu_Device(a1),a0
		movea.l	md_SysLib(a0),a6
		move.l	mdu_AckSignal(a1),d0
		movea.l	mdu_AckTask(a1),a1
		CALLSYS	Signal
.exit		st	psxackflag
		rts

;-------------------------------------------------------------------------

		cnop	0,16

dosname		dc.b	'dos.library',0

ciaaname	dc.b	'ciaa.resource',0
miscname	dc.b	'misc.resource',0

parportname	dc.b	'PSX Controller Port',0
parbitsname	dc.b	'PSX Controller Bits',0
psxportname	dc.b	'PSX Controller Unit '
psxportunit	dc.b	'0',0

		cnop	0,4

CurrentUnitPtr	dc.l	0

		cnop	0,16

FLG_Interrupt	dc.l	0,0
		dc.b	2,0
		dc.l	psxackname
		dc.l	0
		dc.l	Acknowledge

psxackname	dc.b	'PSX Controller ACK',0
		even

psxackflag	dc.b	0
rsrcFlag	dc.b	0

		cnop	0,4


		END
