#!/bin/sh

# #!/bin/dash
# #!/usr/bin/dash
# #!/usr/local/bin/dash

# Bomb.wav.sh
# Designed around a Macbook Pro 13", OSX 10.15.7, using a POSIX '[da]sh' shell.
# Issued as Public Domain, 2014-2022, B.Walker, G0LCU.

# Variables used.
number=0
count=0
# Use pure ASCII for the required sounds only.
char="  ~~"

# Initialise all files to zero, saved inside the CURRENT directory|folder|drawer.
: > Bomb.raw
: > Bomb.wav

# Generate the high start sound at 2KHz.
for number in $( seq 0 1 100 )
do
	printf "%b" "${char}" >> Bomb.raw
done

# Now build up the char by adding the correct byte values at the beginning first, then, at the end last.
for count in $( seq 0 1 11 )
do
	# Add the correct byte at the beginning, append the file, looping a few times...
	char=' '${char}
	for number in $( seq 0 1 14 )
	do
		printf "%b" "${char}" >> Bomb.raw
	done
	# Now add the correct byte at the end, append the file, looping a few times...
	char=${char}'~'
	for number in $( seq 0 1 13 )
	do
		printf "%b" "${char}" >> Bomb.raw
	done
done

# Create a short silent period...
char='O'
for number in $( seq 0 1 359 ) 
do
	printf "%b" "${char}" >> Bomb.raw
done

# This is the required '.WAV' header...
printf "%b" "\122\111\106\106\140\71\0\0\127\101\126\105\146\155\164\40\20\0\0\0\1\0\1\0\100\37\0\0\100\37\0\0\1\0\10\0\144\141\164\141\74\71\0\0" >> Bomb.wav

cat Bomb.raw >> Bomb.wav

# Create random ASCII characters as noise...
awk 'BEGIN \
{
	srand()
	for(n = 1; n <= 8152; ++n)
		{
			INTEGER = 32 + rand() * 95
			printf("%c", INTEGER) >> "Bomb.wav"
		}
}'

# For Linux use aplay OR paplay in place of afplay.
# aplay Bomb.wav
# paplay Bomb.wav
# Using Apple OSX 10.15.7 afplay.
afplay Bomb.wav

# Delete Bomb.raw as it is no longer needed...
rm Bomb.raw

exit 0
