#!/bin/bash
# Spec_An.sh
# GNU bash, version 3.2.57(1)-release (x86_64-apple-darwin16)
# Copyright (C) 2007 Free Software Foundation, Inc.
# $VER Spec_An.sh_(C)2017_2022_B.Walker_CC0_Licence.

# Create the blank files.
cp "$HOME"/AudioScope.tmp/symmetricalwave.raw /tmp/symmetricalwave.raw
: > /tmp/bash_array
: > /tmp/FFT_RAW.py

# Current variables.
BASH_ARRAY=()
COUNT=0
HORIZ=11
VERT=${BASH_ARRAY[$COUNT]}
DRAW=22
VER="3"

# Create the display, active area x = 64, y = 21. Bold cyan on black with yellow plots.
printf "%b" "\x1B[1;36;40m\x1B[2J\x1B[H"
printf "%b" "\
         ++----[ \$VER Spec_An.sh_(C)2017_2022_B.Walker_CC0_Licence. ]-----++
     100 +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 100
   U     ||       |       |       |       |       |       |       |       ||
   N  90 ++       +       +       +       +       +       +       +       ++ 80
   C     ||       |       |       |       |       |       |       |       ||
   A  80 ++       +       +       +       +       +       +       +       ++ 80
   L     ||       |       |       |       |       |       |       |       ||
   I  70 ++       +       +       +       +       +       +       +       ++ 70
   B     ||       |       |       |       |       |       |       |       ||
   R  60 ++       +       +       +       +       +       +       +       ++ 60
   A     ||       |       |       |       |       |       |       |       ||
   T  50 ++       +       +       +       +       +       +       +       ++ 50
   E     ||       |       |       |       |       |       |       |       ||
   D  40 ++       +       +       +       +       +       +       +       ++ 40
         ||       |       |       |       |       |       |       |       ||
   L  30 ++       +       +       +       +       +       +       +       ++ 30
   E     ||       |       |       |       |       |       |       |       ||
   V  20 ++       +       +       +       +       +       +       +       ++ 20
   E     ||       |       |       |       |       |       |       |       ||
   L  10 ++       +       +       +       +       +       +       +       ++ 10
LOG10(X) ||       |       |       |       |       |       |       |       ||
       0 ++-------+-------+-------+-------+-------+-------+-------+-------++ 0
 FREQ Hz +0------500----1000----1500----2000----2500----3000----3500----4000
                          \x1B[1;37;40mPress <CR> to continue:- "

# ****************************************************************************
# Create the Python code to do the heavy FFT lifting.
# This works from Python versions 2.0.1 to at least 3.10.0...
# NO python dependencies at all are required for this to work.
cat << "PYTHON_CODE" > /tmp/FFT_RAW.py
# FFT_RAW.py
# Barry Walker, G0LCU.
#
# Python Version 2.0.1 minimum to 3.10.2.

import sys
import cmath
import math

VER = int(eval(sys.version[0]))
if VER <= 2: import string

# Get data from a file and put into a _variable_.
FFT_data_str = open('/tmp/bash_array','r').read()
open('/tmp/bash_array','r').close()

# Convert to string representations of floats in a list.
if VER <= 2: Str_List = string.split(FFT_data_str,",")
if VER >= 3: Str_List = FFT_data_str.split(",")

# Convert strings to floats, from 0.0 to 255.0.
FFT_LIST = []

for number in range(0,len(Str_List)):
	if VER <= 2 : floatlist = string.atof(Str_List[number])
	if VER >= 3 : floatlist = float(Str_List[number])
	FFT_LIST.append(floatlist)

def Fast_Fourier_Transform(DATA):
	N = len(DATA)
	if N <= 1: return DATA
	# Check for powers of 2 and immediately exit if not.
	if N&(N-1) != 0:
		print("Power of 2 ERROR!")
		print("Padding or cropping is required to the nearest power of 2 elements.")
		print("Aborting with a return code of 1...")
		sys.exit(1)
	EVEN = Fast_Fourier_Transform([DATA[K] for K in range(0,N,2)])
	ODD = Fast_Fourier_Transform([DATA[K] for K in range(1,N,2)])
	return [EVEN[K]+cmath.exp(-2j*cmath.pi*K/N)*ODD[K] for K in range(int(N/2))]+[EVEN[K]-cmath.exp(-2j*cmath.pi*K/N)*ODD[K] for K in range(int(N/2))]

FFT = Fast_Fourier_Transform(FFT_LIST)
LENGTH = len(FFT)
for FFT_LISTING in range(0,LENGTH,1):
	print("%u " %(int(5*(math.log10(((abs(FFT[FFT_LISTING])+1)/100))))))

sys.exit(0)
PYTHON_CODE
# ****************************************************************************

# Create the comma delimited text file, 0 to 255, and, ADD the padding of 192 off '128' mid point padding values.
hexdump -v -e '1/1 "%u,"' /tmp/symmetricalwave.raw >> /tmp/bash_array
for COUNT in {8000..8190}
do
	printf "128," >> /tmp/bash_array
done
printf "128" >> /tmp/bash_array
# Text file with padding added, done!

# Place the FFT values into bash array, BASH_ARRAY.
BASH_ARRAY=($( "$HOME"/AudioScope.tmp/python /tmp/FFT_RAW.py ))

# Finally plot the audio spectrum.
COUNT=1
HORIZ=11
VERT=${BASH_ARRAY[$COUNT]}
DRAW=22
# Display window...
# HORIZ, 11 minimum, 77 maximum.
# VERT, 2 minimum, 22 maximum.
# VERT MUST be inverted.
while [ $COUNT -le 4097 ]
do
	# This should never be reached!
	if [ "$VERT" = "" ]
	then
		break
	fi
	VERT=$(( 22 - $VERT ))
	if [ $VERT -lt 2 ]
	then
		VERT=2
	fi
	if [ $VERT -gt 22 ]
	then
		VERT=22
	fi
	if [ $HORIZ -gt 75 ]
	then
		# 76 should never be reached! 
		break
	fi
	for (( DRAW=22; DRAW>=$VERT; DRAW-- ))
	do
		printf "%b" "\x1B[${DRAW};${HORIZ}f\x1B[1;33;40m*"
	done
	if [ $(( $COUNT % 63 )) -eq 0 ]
	then
		HORIZ=$(( $HORIZ + 1 ))
	fi
	COUNT=$(( $COUNT + 1 ))
	VERT=${BASH_ARRAY[$COUNT]}
done
printf "%b" "\x1B[24;52f"
read -r -n 1
exit 0
