# FFT_RAW.py
# Barry Walker, G0LCU.
#
# Python Version 2.0.1 minimum to 3.10.2.

import sys
import cmath
import math

VER = int(eval(sys.version[0]))
if VER <= 2: import string

# Get data from a file and put into a _variable_.
FFT_data_str = open('/tmp/bash_array','r').read()
open('/tmp/bash_array','r').close()

# Convert to string representations of floats in a list.
if VER <= 2: Str_List = string.split(FFT_data_str,",")
if VER >= 3: Str_List = FFT_data_str.split(",")

# Convert strings to floats, from 0.0 to 255.0.
FFT_LIST = []

for number in range(0,len(Str_List)):
	if VER <= 2 : floatlist = string.atof(Str_List[number])
	if VER >= 3 : floatlist = float(Str_List[number])
	FFT_LIST.append(floatlist)

def Fast_Fourier_Transform(DATA):
	N = len(DATA)
	if N <= 1: return DATA
	# Check for powers of 2 and immediately exit if not.
	if N&(N-1) != 0:
		print("Power of 2 ERROR!")
		print("Padding or cropping is required to the nearest power of 2 elements.")
		print("Aborting with a return code of 1...")
		sys.exit(1)
	EVEN = Fast_Fourier_Transform([DATA[K] for K in range(0,N,2)])
	ODD = Fast_Fourier_Transform([DATA[K] for K in range(1,N,2)])
	return [EVEN[K]+cmath.exp(-2j*cmath.pi*K/N)*ODD[K] for K in range(int(N/2))]+[EVEN[K]-cmath.exp(-2j*cmath.pi*K/N)*ODD[K] for K in range(int(N/2))]

FFT = Fast_Fourier_Transform(FFT_LIST)
LENGTH = len(FFT)
for FFT_LISTING in range(0,LENGTH,1):
	print("%u " %(int(5*(math.log10(((abs(FFT[FFT_LISTING])+1)/100))))))

sys.exit(0)
