#!/bin/dash

# #!/usr/local/bin/dash
# #!/bin/sh
#
# Barry Walker, G0LCU.

# DFT_POSIX_AWK.sh
# ONLY 'awk' allowed for the calculations.

# **************************************************
# Use awk as the prime calculator'
calc()
{
	# IMPORTANT! !!!Parentheses are very important!!!
	EXPRESSION=${1}
	awk 'BEGIN{ pi=3.141592653589793; e=2.718281828459045; printf "%.15f", ('"${EXPRESSION}"'); print ""; }'
}

# **************************************************
# The Discrete_Fourier_Transform and ARRAY_VALS functions.
ARRAY_VALS()
{
	# Usage: ARRAY_VALS <position_number> <${REAL_IMAG}>
	# Dump the value, REAL OR IMAGINARY, into R_OR_I.
	eval R_OR_I="\${${1}}"
}

Discrete_Fourier_Transform()
{
	# For each element to output...
	K=0
	while [ ${K} -lt ${N} ]
	do
		M=0
		SUBSCRIPT=0
		SUMREAL=0.0
		SUMIMAG=0.0
		# For each element from input...
		T=0
		while [ ${T} -lt ${N} ]
		do
			# Equation is ( 2 * PI * T * K ) / N...
			ANGLE=$( calc "( 2 * pi * ${T} * ${K} ) / ${N}" )

			# Obtain REAL and IMAG values.
			M=0
			while [ ${M} -le $(( ( N * 2 ) - 2 )) ]
			do
				if [ ${M} -eq ${SUBSCRIPT} ]
				then
					# Call the ARRAY_VALS function for REAL...
					ARRAY_VALS $(( M + 2 )) ${REAL_IMAG}
					# Obtain the REAL part.
					REAL="${R_OR_I}"
					# Call the ARRAY_VALS function again for IMAG...
					ARRAY_VALS $(( M + 3 )) ${REAL_IMAG}
					# Obtain the IMAGINARY part.
					IMAG="${R_OR_I}"
					# Remove the imaginary letter 'i'...
					IMAG="${IMAG%?}"
					break
				fi
				M=$(( M + 2 ))
			done

			# Equation is ( SUMREAL + ( REAL * COS_ANGLE ) + ( IMAG * SIN_ANGLE ) )
			SUMREAL=$( calc "${SUMREAL} + ( ${REAL} * cos(${ANGLE}) ) + ( ${IMAG} * sin(${ANGLE}) )" )

			# Equation is ( SUMIMAG - ( REAL * SIN_ANGLE ) + ( IMAG * COS_ANGLE ) )
			SUMIMAG=$( calc "${SUMIMAG} - ( ${REAL} * sin(${ANGLE}) ) + ( ${IMAG} * cos(${ANGLE}) )" )

			SUBSCRIPT=$(( SUBSCRIPT + 2 ))
			T=$(( T + 1 ))
		done
		LISTING=${LISTING}$( printf "\n  %.8f		%.8fi" "${SUMREAL}" "${SUMIMAG}" )
		ABS=$( calc "sqrt( ( ${SUMREAL} * ${SUMREAL} ) + ( ${SUMIMAG} * ${SUMIMAG} ) )" )
		printf "%.5f " "${ABS}"
		K=$(( K + 1 ))
	done
}
# **************************************************

# **************************************************
# 16 samples of single cycle square wave, floating point values must always be positive.
#
# REAL_IMAG='1.0 0.0i 1.0 0.0i 1.0 0.0i 1.0 0.0i 1.0 0.0i 1.0 0.0i 1.0 0.0i 1.0 0.0i 0.0 0.0i 0.0 0.0i 0.0 0.0i 0.0 0.0i 0.0 0.0i 0.0 0.0i 0.0 0.0i 0.0 0.0i'
#
# 8.00000 5.12583 0.00000 1.79995 0.00000 1.20269 0.00000 1.01959
# 0.00000 1.01959 0.00000 1.20269 0.00000 1.79995 0.00000 5.12583

# This has midway '0.5' value padding at the end to bring to the power of 2.
# This is the running default.
#
REAL_IMAG='1.0 0.0i 1.0 0.0i 1.0 0.0i 1.0 0.0i 1.0 0.0i 1.0 0.0i 0.0 0.0i 0.0 0.0i 0.0 0.0i 0.0 0.0i 0.0 0.0i 0.0 0.0i 1.0 0.0i 0.5 0.0i 0.5 0.0i 0.5 0.0i'
#
# 8.50000 4.11842 1.77882 0.24688 1.80278 0.49665 0.57947 1.31567
# 0.50000 1.31567 0.57947 0.49665 1.80278 0.24688 1.77882 4.11842

# Standard test values.
#
# REAL_IMAG='1.0 0.0i 1.0 0.0i 1.0 0.0i 1.0 0.0i 0.0 0.0i 0.0 0.0i 0.0 0.0i 0.0 0.0i'
#
# 4.00000 2.61313 0.00000 1.08239 0.00000 1.08239 0.00000 2.61313
# **************************************************

# START!

# **************************************************
# Get the length of the REAL and IMAGINARY pair combined.
# No *NIX tools are allowed so doing it longhand.
# DO NOT USE 'wc' or any other tools...
set -- ${REAL_IMAG}
N=$( echo $# )
if [ $(( N & ( N - 1 ) )) -ne 0 ]
then
	echo "ERROR: Padding or cropping is required to the nearest power of 2 elements."
	exit 1
fi
N=$(( N / 2 ))
# **************************************************

# **************************************************
# Finally Run the 'Discrete_Fourier_Transform' function...
LISTING=''
echo ''
#
Discrete_Fourier_Transform
echo ''
echo ''
printf '     REAL.		 IMAGINARY.'
# **************************************************

# **************************************************
# The code below added for ease but not needed...
echo "${LISTING}"

echo ''
# **************************************************

# END!

