# DWT.py
#
# Author: B.Walker, G0LCU. Issued is CC0, Public Domain, 17-10-2018.

# A very basic Python 1D Haar DWT, Discrete Wavelet Transform,
# using internal default Python floating point maths only.
#
# Works on Python Versions 1.4.0 to 2.0.1 and 2.4.6, (for the AMIGA A1200),
# to 3.10.1 on _ALL_ platforms without modification.
#
# Developed on OSX 10.12.x to 10.15.7, using Python Versions 2.7.x, 3.5.2 and 3.10.1.

# ******************************************************
# **************** DEFAULT test listing. ***************
# ******************************************************
# Integer values as floats used here for DEFAULT DEMO 8 sample size.
# The 8 test samples; sample size must be a power of 2.
#
# DEMO 1:
# START:
# 56.0, 40.0, 8.0, 24.0, 48.0, 48.0, 40.0, 16.0
#
# STEPS IN BETWEEN:
# 48.0, 16.0, 48.0, 28.0, 8.0, -8.0, 0.0, 12.0
# 32.0, 38.0, 16.0, 10.0, 8.0, -8.0, 0.0, 12.0
#
# FINAL RESULT:
# 35.0, -3.0, 16.0, 10.0, 8.0, -8.0, 0.0, 12.0
# Works from Python 1.4.0 to Python 3.10.1.
#
# Learning reference here:
# https://www.math.aau.dk/digitalAssets/120/120646_r-2003-24.pdf
#
LISTING=[56.0, 40.0, 8.0, 24.0, 48.0, 48.0, 40.0, 16.0]
#
# ******************************************************
# ************ End of DEFAULT test listing. ************
# ******************************************************

# ******************************************************
# ******************************************************
# Other test listings to try out...
# Transform creates genuine floating point values.
# DEMO 2:
# START:
# 6, 12, 15, 15, 14, 12, 120, 116
#
# FINAL RESULT:
# 38.75, -26.75, -3.0, -52.5, -3.0, 0.0, 1.0, 2.0
#
#LISTING=[6, 12, 15, 15, 14, 12, 120, 116]
#
# ******************************************************
# ******************************************************
# Basic transform.
# DEMO 3:
# START:
# 1, 2, 3, 4, 5, 6, 7, 8
#
# FINAL RESULT:
# 4.5, -2.0, -1.0, -1.0, -0.5, -0.5, -0.5, -0.5
#
#LISTING=[1, 2, 3, 4, 5, 6, 7, 8]
#
# ******************************************************
# ******************************************************
# Using padding of 0.0 for last three places.
# DEMO 4:
# START:
# 17.0, 3.0, 31.0, 213.0, 99.0, 0.0, 0.0, 0.0
#
# FINAL RESULT:
# 45.375, 20.625, -56.0, 24.75, 7.0, -91.0, 49.5, 0.0
#
#LISTING=[17.0, 3.0, 31.0, 213.0, 99.0, 0.0, 0.0, 0.0]
#
# ******************************************************
# ******************************************************

import sys

print("")
print("Eight input values:")
print(LISTING)

# Haar 1D DWT function.
def Discrete_Haar_Wavelet_Transform(DATA=[]):

	# NOTE: Scale factor is fixed at 0.5 for this DEMO.
	LENGTH=len(DATA)
	if LENGTH&(LENGTH-1)!=0:
		print("Power of 2 ERROR!")
		print("Padding or cropping is required to the nearest power of 2 elements.")
		print("Exiting with a return code of 1...")
		sys.exit(1)
	RESULT=[]
	while 1:
		TEMP=[0]*LENGTH
		for INDEX in range(0,LENGTH,2):
			MEAN_PAIR=(DATA[INDEX]+DATA[INDEX+1])/2.0
			DIFFERENCE=DATA[INDEX]-MEAN_PAIR
			TEMP[int(INDEX/2)]=MEAN_PAIR
			TEMP[int(LENGTH/2)+int(INDEX/2)]=DIFFERENCE
		DATA=TEMP
		RESULT=TEMP[int(LENGTH/2):]+RESULT
		LENGTH=int(LENGTH/2)
		if LENGTH==1:
			RESULT=TEMP[0:1]+RESULT
			return RESULT

# Obtain the results.
DWTDATA=Discrete_Haar_Wavelet_Transform(LISTING)

print("")
print("DWT results:")
print(DWTDATA)
print("")

sys.exit(0)

